/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management.internal;

import com.ibm.java.lang.management.internal.ThreadMXBeanImpl;
import com.ibm.lang.management.ExtendedThreadInfo;
import com.ibm.lang.management.ThreadMXBean;
import com.ibm.lang.management.internal.ExtendedThreadInfoImpl;
import com.ibm.oti.util.Msg;
import java.lang.management.ThreadInfo;

public final class ExtendedThreadMXBeanImpl
extends ThreadMXBeanImpl
implements ThreadMXBean {
    private static final ThreadMXBean instance = new ExtendedThreadMXBeanImpl();
    private boolean isThreadAllocatedMemoryEnabled = true;

    public static ThreadMXBean getInstance() {
        return instance;
    }

    private ExtendedThreadMXBeanImpl() {
    }

    @Override
    public ExtendedThreadInfo[] dumpAllExtendedThreads(boolean bl, boolean bl2) throws InternalError, SecurityException, UnsupportedOperationException {
        ThreadInfo[] threadInfoArray = this.dumpAllThreads(bl, bl2);
        int n = threadInfoArray.length;
        ExtendedThreadInfo[] extendedThreadInfoArray = new ExtendedThreadInfo[n];
        for (int i = 0; i < n; ++i) {
            extendedThreadInfoArray[i] = new ExtendedThreadInfoImpl(threadInfoArray[i]);
        }
        return extendedThreadInfoArray;
    }

    private static native long getThreadAllocatedBytesImpl(long var0);

    @Override
    public long getThreadAllocatedBytes(long l) {
        if (this.isThreadAllocatedMemorySupported()) {
            if (this.isThreadAllocatedMemoryEnabled()) {
                return ExtendedThreadMXBeanImpl.getThreadAllocatedBytesImpl(l);
            }
            return -1L;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public long[] getThreadAllocatedBytes(long[] lArray) {
        int n = lArray.length;
        long[] lArray2 = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray2[i] = this.getThreadAllocatedBytes(lArray[i]);
        }
        return lArray2;
    }

    @Override
    public long getTotalThreadAllocatedBytes() {
        long[] lArray;
        if (!this.isThreadAllocatedMemorySupported()) {
            throw new UnsupportedOperationException();
        }
        if (!this.isThreadAllocatedMemoryEnabled()) {
            return -1L;
        }
        long l = 0L;
        for (long l2 : lArray = this.getThreadAllocatedBytes(this.getAllThreadIds())) {
            if (l2 == -1L) continue;
            l += l2;
        }
        return l;
    }

    @Override
    public long[] getThreadCpuTime(long[] lArray) {
        int n;
        long[] lArray2 = new long[lArray.length];
        for (n = 0; n < lArray.length; ++n) {
            if (lArray[n] <= 0L) {
                throw new IllegalArgumentException(Msg.getString("K05F7"));
            }
            lArray2[n] = -1L;
        }
        if (this.isCurrentThreadCpuTimeSupported()) {
            if (this.isThreadCpuTimeEnabled()) {
                for (n = 0; n < lArray.length; ++n) {
                    lArray2[n] = this.getThreadCpuTime(lArray[n]);
                }
            }
        } else {
            throw new UnsupportedOperationException(Msg.getString("K05F6"));
        }
        return lArray2;
    }

    @Override
    public long[] getThreadUserTime(long[] lArray) {
        int n;
        long[] lArray2 = new long[lArray.length];
        for (n = 0; n < lArray.length; ++n) {
            if (lArray[n] <= 0L) {
                throw new IllegalArgumentException(Msg.getString("K05F7"));
            }
            lArray2[n] = -1L;
        }
        if (this.isCurrentThreadCpuTimeSupported()) {
            if (this.isThreadCpuTimeEnabled()) {
                for (n = 0; n < lArray.length; ++n) {
                    lArray2[n] = this.getThreadUserTime(lArray[n]);
                }
            }
        } else {
            throw new UnsupportedOperationException(Msg.getString("K05F6"));
        }
        return lArray2;
    }

    @Override
    public boolean isThreadAllocatedMemorySupported() {
        return true;
    }

    @Override
    public boolean isThreadAllocatedMemoryEnabled() {
        return this.isThreadAllocatedMemoryEnabled && this.isThreadAllocatedMemorySupported();
    }

    @Override
    public void setThreadAllocatedMemoryEnabled(boolean bl) {
        this.isThreadAllocatedMemoryEnabled = bl;
    }
}

