/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.showcommands;

import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.heapdump.HeapDumpSettings;
import java.io.PrintStream;

@DTFJPlugin(version="1.*", runtime=false)
public class ShowHeapdumpCommand
extends BaseJdmpviewCommand {
    public static final String COMMAND_NAME = "show heapdump";
    public static final String COMMAND_DESCRIPTION = "displays heapdump settings";
    public static final String LONG_DESCRIPTION = "Parameters:none\n\nPrints heapdump format and file name.\nUse \"set heapdump\" to change settings\n";

    public ShowHeapdumpCommand() {
        this.addCommand(COMMAND_NAME, "", COMMAND_DESCRIPTION);
    }

    public void run(String string, String[] stringArray, IContext iContext, PrintStream printStream) throws CommandException {
        if (this.initCommand(string, stringArray, iContext, printStream)) {
            return;
        }
        if (stringArray.length != 0) {
            printStream.println("\"show heapdump\" does not take any parameters.");
            return;
        }
        printStream.print("Heapdump Settings:\n\n");
        printStream.print("\tFormat: " + (HeapDumpSettings.areHeapDumpsPHD(this.ctx.getProperties()) ? "PHD" : "Classic (TXT)") + "\n");
        printStream.print("\tFile Name: " + HeapDumpSettings.getFileName(this.ctx.getProperties()) + "\n");
        printStream.print("\tMultiple heaps will be written to " + (HeapDumpSettings.multipleHeapsInMultipleFiles(this.ctx.getProperties()) ? "multiple files" : "a single file") + "\n");
    }

    @Override
    public void printDetailedHelp(PrintStream printStream) {
        printStream.println(LONG_DESCRIPTION);
    }
}

