/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.infocommands;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaHeap;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.commands.helpers.ClassOutput;
import com.ibm.jvm.dtfjview.commands.helpers.Exceptions;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;

@DTFJPlugin(version="1.*", runtime=false)
public class InfoClassCommand
extends BaseJdmpviewCommand {
    private static Map<JavaRuntime, Map<JavaClass, ClassStatistics>> classInstanceCounts;

    public InfoClassCommand() {
        this.addCommand("info class", "[Java class name] [-sort:<name|count|size>]", "Provides information about the specified Java class");
    }

    public void run(String string, String[] stringArray, IContext iContext, PrintStream printStream) throws CommandException {
        String string2 = null;
        Comparator<JavaClass> comparator = new ClassNameComparator();
        if (this.initCommand(string, stringArray, iContext, printStream)) {
            return;
        }
        if (classInstanceCounts == null) {
            this.cacheRuntimeClasses();
            this.countClassInstances();
        }
        for (String string3 : stringArray) {
            if ("-sort:size".equals(string3)) {
                comparator = new TotalSizeComparator();
                continue;
            }
            if ("-sort:count".equals(string3)) {
                comparator = new InstanceCountComparator();
                continue;
            }
            if ("-sort:name".equals(string3)) {
                comparator = new ClassNameComparator();
                continue;
            }
            string2 = string3;
        }
        if (string2 == null) {
            this.printAllRuntimeClasses(comparator);
        } else {
            this.printSingleRuntimeClassInfo(string2);
        }
    }

    private void printSingleRuntimeClassInfo(String string) {
        JavaClass javaClass;
        JavaRuntime javaRuntime = this.ctx.getRuntime();
        Long l = Utils.longFromStringWithPrefix(string);
        JavaClass[] javaClassArray = null;
        if (l != null) {
            javaClass = Utils.getClassGivenAddress(l, javaRuntime);
            if (javaClass != null) {
                javaClassArray = new JavaClass[]{javaClass};
            }
        } else {
            javaClassArray = Utils.getClassGivenName(string, javaRuntime, this.out);
        }
        if (null == javaClassArray || javaClassArray.length == 0) {
            this.out.print("\t  could not find class with name \"" + string + "\"\n\n");
        } else if (javaClassArray.length == 1) {
            javaClass = javaClassArray[0];
            this.printClassDetails(javaRuntime, string, javaClass);
        } else {
            this.out.println("name = " + string + " found " + javaClassArray.length + " on different class loaders");
            for (int i = 0; i < javaClassArray.length; ++i) {
                JavaClass javaClass2 = javaClassArray[i];
                ClassOutput.printRuntimeClassAndLoader(javaClass2, this.out);
            }
            this.out.println("Use info class with the class ID to print out information on a specific class.");
            this.out.println("For example: info class 0x" + Long.toHexString(javaClassArray[0].getID().getAddress()));
        }
    }

    private void printClassDetails(JavaRuntime javaRuntime, String string, JavaClass javaClass) {
        Object object;
        Object object2;
        String string2;
        Object object3;
        String string3 = "    ";
        String string4 = "N/A (CorruptDataException occurred)";
        try {
            this.out.print("name = " + javaClass.getName());
        }
        catch (CorruptDataException corruptDataException) {
            this.out.print("name = " + string4);
        }
        this.out.print("\n\n\t");
        this.out.print("ID = " + Utils.toHex(javaClass.getID()));
        try {
            object3 = javaClass.getSuperclass();
            string2 = null == object3 ? "<no superclass>" : Utils.toHex(object3.getID());
        }
        catch (CorruptDataException corruptDataException) {
            string2 = string4;
        }
        this.out.print(string3);
        this.out.print("superID = " + string2);
        try {
            object2 = javaClass.getClassLoader();
            object = object2.getObject();
            object3 = object != null ? Utils.toHex(object.getID()) : "<data unavailable>";
        }
        catch (CorruptDataException corruptDataException) {
            object3 = string4;
        }
        this.out.print(string3);
        this.out.print("\n\t");
        this.out.print("classLoader = " + (String)object3);
        try {
            object2 = Utils.getClassModifierString(javaClass);
        }
        catch (CorruptDataException corruptDataException) {
            object2 = string4;
        }
        this.out.print(string3);
        this.out.print("modifiers: " + (String)object2);
        this.out.print("\n\n");
        object = this.getClassStatisticsFor(javaRuntime, javaClass);
        this.out.print("\tnumber of instances:     " + ((ClassStatistics)object).getCount() + "\n");
        this.out.print("\ttotal size of instances on the heap: " + ((ClassStatistics)object).getSize() + " bytes");
        this.out.print("\n\n");
        this.printClassHierarchy(javaClass);
        this.out.print("\n");
        this.printFields(javaClass);
        this.out.print("\n");
        this.printMethods(javaClass);
    }

    private void printClassHierarchy(JavaClass javaClass) {
        Stack<String> stack = new Stack<String>();
        while (null != javaClass) {
            try {
                stack.add(javaClass.getName());
                javaClass = javaClass.getSuperclass();
            }
            catch (CorruptDataException corruptDataException) {
                stack.add("N/A (CorruptDataException occurred)");
                break;
            }
        }
        this.printStack(stack);
    }

    private void printStack(Stack<String> stack) {
        this.out.print("Inheritance chain....\n\n");
        String string = "\t";
        String string2 = "";
        while (stack.size() > 0) {
            this.out.print(string + string2 + stack.pop() + "\n");
            string2 = string2 + "   ";
        }
    }

    private void printFields(JavaClass javaClass) {
        this.out.print("Fields......\n\n");
        ClassOutput.printStaticFields(javaClass, this.out);
        ClassOutput.printNonStaticFields(javaClass, this.out);
    }

    private void printMethods(JavaClass javaClass) {
        this.out.print("Methods......\n\n");
        ClassOutput.printMethods(javaClass.getDeclaredMethods(), this.out);
        this.out.print("\n");
    }

    private void cacheRuntimeClasses() {
        classInstanceCounts = new HashMap<JavaRuntime, Map<JavaClass, ClassStatistics>>();
        long l = 0L;
        HashMap<JavaClass, ClassStatistics> hashMap = new HashMap<JavaClass, ClassStatistics>();
        JavaRuntime javaRuntime = this.ctx.getRuntime();
        classInstanceCounts.put(javaRuntime, hashMap);
        Iterator iterator = javaRuntime.getJavaClassLoaders();
        while (iterator.hasNext()) {
            JavaClassLoader javaClassLoader = (JavaClassLoader)iterator.next();
            Iterator iterator2 = javaClassLoader.getDefinedClasses();
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                if (e instanceof JavaClass) {
                    hashMap.put((JavaClass)e, new ClassStatistics());
                    continue;
                }
                ++l;
            }
        }
        if (l > 0L) {
            this.out.print("Warning, found " + l + " corrupt classes during classloader walk\n");
        }
    }

    private void printAllRuntimeClasses(Comparator<JavaClass> comparator) {
        Object object;
        JavaClass javaClass;
        Iterator<Object> iterator;
        JavaRuntime javaRuntime = this.ctx.getRuntime();
        Collection<JavaClass> collection = InfoClassCommand.getRuntimeClasses(javaRuntime);
        long l = 0L;
        long l2 = 0L;
        if (comparator == null) {
            iterator = collection.iterator();
        } else {
            javaClass = new LinkedList();
            object = collection.iterator();
            while (object.hasNext()) {
                javaClass.add(object.next());
            }
            Collections.sort(javaClass, comparator);
            iterator = javaClass.iterator();
        }
        if (iterator.hasNext()) {
            this.printClassListHeader();
        } else {
            this.out.print("\n\t No information found for loaded classes\n");
        }
        while (iterator.hasNext()) {
            javaClass = iterator.next();
            object = this.getClassStatisticsFor(javaRuntime, javaClass);
            l2 += ((ClassStatistics)object).getSize();
            l += (long)((ClassStatistics)object).getCount();
            this.printOneClass(javaClass, (ClassStatistics)object);
        }
        this.out.print("\n");
        this.out.print("\t Total number of objects: " + l + "\n");
        this.out.print("\t Total size of objects: " + l2 + "\n");
    }

    private static Collection<JavaClass> getRuntimeClasses(JavaRuntime javaRuntime) {
        return classInstanceCounts.get(javaRuntime).keySet();
    }

    private ClassStatistics getClassStatisticsFor(JavaRuntime javaRuntime, JavaClass javaClass) {
        return classInstanceCounts.get(javaRuntime).get(javaClass);
    }

    private void countClassInstances() {
        JavaRuntime javaRuntime = this.ctx.getRuntime();
        Map<JavaClass, ClassStatistics> map = classInstanceCounts.get(javaRuntime);
        Collection<JavaClass> collection = InfoClassCommand.getRuntimeClasses(javaRuntime);
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        Iterator iterator = javaRuntime.getHeaps();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof CorruptData) {
                this.out.println("[skipping corrupt heap]");
                continue;
            }
            JavaHeap javaHeap = (JavaHeap)e;
            Iterator iterator2 = javaHeap.getObjects();
            while (iterator2.hasNext()) {
                Object e2 = iterator2.next();
                if (e2 instanceof JavaObject) {
                    JavaObject javaObject = (JavaObject)e2;
                    ClassStatistics classStatistics = null;
                    try {
                        JavaClass javaClass = javaObject.getJavaClass();
                        if (collection.contains(javaClass)) {
                            classStatistics = map.get(javaClass);
                        } else {
                            classStatistics = new ClassStatistics();
                            map.put(javaClass, classStatistics);
                            try {
                                String string = javaClass.getName();
                                this.out.println("Warning, class: " + string + " found when walking the heap was missing from classloader walk");
                            }
                            catch (CorruptDataException corruptDataException) {
                                ++l3;
                            }
                        }
                        classStatistics.incrementCount();
                        try {
                            classStatistics.addToSize(javaObject.getSize());
                        }
                        catch (CorruptDataException corruptDataException) {
                            ++l;
                        }
                    }
                    catch (CorruptDataException corruptDataException) {
                        ++l2;
                    }
                    continue;
                }
                ++l;
            }
        }
        if (l != 0L) {
            this.out.println("Warning, found " + l + " corrupt objects during heap walk");
        }
        if (l2 != 0L) {
            this.out.println("Warning, found " + l2 + " corrupt class references during heap walk");
        }
        if (l3 != 0L) {
            this.out.println("Warning, found " + l3 + " corrupt class names during heap walk");
        }
    }

    private void printClassListHeader() {
        this.out.print("\n" + Utils.prePadWithSpaces("instances", 16));
        this.out.print(Utils.prePadWithSpaces("total size on heap", 20));
        this.out.print("  class name");
        this.out.print("\n");
    }

    private void printOneClass(JavaClass javaClass, ClassStatistics classStatistics) {
        String string;
        try {
            string = javaClass.getName();
        }
        catch (CorruptDataException corruptDataException) {
            string = Exceptions.getCorruptDataExceptionString();
        }
        this.out.print(Utils.prePadWithSpaces(String.valueOf(classStatistics.getCount()), 16));
        this.out.print(Utils.prePadWithSpaces(String.valueOf(classStatistics.getSize()), 20));
        this.out.print("  " + string);
        this.out.print("\n");
    }

    private static int cmp(long l, long l2) {
        if (l == l2) {
            return 0;
        }
        if (l > l2) {
            return 1;
        }
        return -1;
    }

    @Override
    public void printDetailedHelp(PrintStream printStream) {
        printStream.println("Prints inheritance chain and other data for a given class\n\nParameters: none, class name or ID, sort flags\n\nIf name or id parameters are omitted then \"info class\", prints the number of instances of each class and the total size of all instances of each class as well as the total number of instances of all classes and the total size of all objects.\nThis output may be sorted using the -sort:name, -sort:size or -sort:count flags.\n\nIf a class name or hex address is passed to \"info class\", it prints the following information about that class:\n  - name\n  - ID\n  - superclass ID\n  - class loader ID\n  - modifiers\n  - number of instances and total size of instances\n  - inheritance chain\n  - fields with modifiers (and values for static fields)\n  - methods with modifiers\nIf multiple classes with the same name (on different class loaders) are found then the class ID and class loader are printed for each class. Use info class with the class ID to print out information on a specific class.");
    }

    private class ClassNameComparator
    implements Comparator<JavaClass> {
        private ClassNameComparator() {
        }

        @Override
        public int compare(JavaClass javaClass, JavaClass javaClass2) {
            String string = "";
            String string2 = "";
            try {
                string = javaClass.getName();
            }
            catch (CorruptDataException corruptDataException) {
                // empty catch block
            }
            try {
                string2 = javaClass2.getName();
            }
            catch (CorruptDataException corruptDataException) {
                // empty catch block
            }
            return string.compareTo(string2);
        }
    }

    private class InstanceCountComparator
    implements Comparator<JavaClass> {
        private InstanceCountComparator() {
        }

        @Override
        public int compare(JavaClass javaClass, JavaClass javaClass2) {
            long l = InfoClassCommand.this.getClassStatisticsFor(InfoClassCommand.this.ctx.getRuntime(), javaClass).getCount();
            long l2 = InfoClassCommand.this.getClassStatisticsFor(InfoClassCommand.this.ctx.getRuntime(), javaClass2).getCount();
            return InfoClassCommand.cmp(l, l2);
        }
    }

    private class TotalSizeComparator
    implements Comparator<JavaClass> {
        private TotalSizeComparator() {
        }

        @Override
        public int compare(JavaClass javaClass, JavaClass javaClass2) {
            long l = InfoClassCommand.this.getClassStatisticsFor(InfoClassCommand.this.ctx.getRuntime(), javaClass).getSize();
            long l2 = InfoClassCommand.this.getClassStatisticsFor(InfoClassCommand.this.ctx.getRuntime(), javaClass2).getSize();
            return InfoClassCommand.cmp(l, l2);
        }
    }

    public static class ClassStatistics {
        private int count = 0;
        private long totalSize = 0L;

        public int getCount() {
            return this.count;
        }

        public long getSize() {
            return this.totalSize;
        }

        public void incrementCount() {
            ++this.count;
        }

        public void addToSize(long l) {
            this.totalSize += l;
        }
    }
}

