/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.helpers;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.jvm.dtfjview.commands.helpers.Exceptions;
import com.ibm.jvm.dtfjview.commands.helpers.MonitorNode;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;

public class NodeList {
    private MonitorNode head;
    private MonitorNode tail;
    private int id;

    public NodeList(MonitorNode monitorNode, int n) {
        this.head = monitorNode;
        this.tail = monitorNode;
        monitorNode.inList = this;
        this.id = n;
    }

    public int getID() {
        return this.id;
    }

    public boolean equals(Object object) {
        return ((NodeList)object).getID() == this.id;
    }

    public NodeList attachOrSplit(NodeList nodeList, int n) {
        MonitorNode monitorNode = nodeList.getHead();
        if (this.tail == monitorNode) {
            MonitorNode monitorNode2 = this.tail = nodeList.getTail();
            monitorNode2.inList = this;
            if (monitorNode2 != monitorNode) {
                do {
                    monitorNode2 = monitorNode2.waitingOn;
                    monitorNode2.inList = this;
                } while (monitorNode2 != monitorNode);
            }
            return null;
        }
        MonitorNode monitorNode3 = this.tail;
        NodeList nodeList2 = new NodeList(this.tail, n);
        do {
            if (monitorNode3 == monitorNode) {
                this.tail = monitorNode3;
                return nodeList2;
            }
            monitorNode3 = monitorNode3.waitingOn;
            nodeList2.add(monitorNode3);
            if (monitorNode3 == this.head) continue;
            monitorNode3.inList = nodeList2;
        } while (monitorNode3 != this.head);
        return null;
    }

    public void add(MonitorNode monitorNode) {
        this.head = monitorNode;
    }

    public MonitorNode getHead() {
        return this.head;
    }

    public MonitorNode getTail() {
        return this.tail;
    }

    public boolean isLoop() {
        return this.tail == this.head;
    }

    public String toString() {
        String string = "";
        MonitorNode monitorNode = this.tail;
        MonitorNode monitorNode2 = null;
        boolean bl = true;
        boolean bl2 = false;
        do {
            Object object;
            String string2 = "";
            String string3 = "";
            JavaObject javaObject = null;
            JavaThread javaThread = null;
            try {
                javaThread = monitorNode.getOwner();
                string2 = javaThread.getName();
                object = javaThread.getImageThread();
                if (object != null) {
                    string2 = string2 + " id: " + object.getID();
                }
            }
            catch (CorruptDataException corruptDataException) {
                string2 = Exceptions.getCorruptDataExceptionString();
            }
            catch (DataUnavailable dataUnavailable) {
                string2 = Exceptions.getDataUnavailableString();
            }
            catch (MemoryAccessException memoryAccessException) {
                string2 = Exceptions.getMemoryAccessExceptionString();
            }
            javaObject = monitorNode.getObject();
            string3 = null == javaObject ? " at : " + Utils.toHex(monitorNode.getMonitorAddress()) : " object : " + Utils.toHex(javaObject.getID().getAddress());
            object = monitorNode.getType();
            string = string + "thread: " + string2 + " (owns " + (String)object + string3 + ") waiting for =>\n\t  ";
            monitorNode2 = monitorNode;
            monitorNode = monitorNode.waitingOn;
            if (this.head == monitorNode2) {
                bl2 = !bl || this.head != this.tail;
            }
            bl = false;
        } while (!bl2);
        string = string.substring(0, string.length() - 18);
        return string;
    }
}

