/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.utils.plugins;

import com.ibm.java.diagnostics.utils.DTFJContext;
import com.ibm.java.diagnostics.utils.plugins.PackageFilteredClassloader;
import com.ibm.java.diagnostics.utils.plugins.PluginManager;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PluginManagerLocator {
    private static final URLClassLoader asmExtendedClassLoader;
    private static final Logger logger;

    public static PluginManager getManager() {
        try {
            Class<?> clazz = Class.forName("com.ibm.java.diagnostics.utils.plugins.impl.PluginManagerImpl", true, asmExtendedClassLoader);
            Method method = clazz.getDeclaredMethod("getPluginManager", null);
            return (PluginManager)method.invoke(null, (Object[])null);
        }
        catch (Exception exception) {
            logger.log(Level.FINE, "Problem initialising DTFJ plugin classloader: " + exception.getMessage());
            logger.log(Level.FINEST, "Problem initialising DTFJ plugin classloader: ", exception);
            return null;
        }
    }

    private static URL[] getASMURLs() {
        if (System.getProperty("com.ibm.java.diagnostics.nopackagefilter") != null) {
            return new URL[0];
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        String string = System.getProperty("java.home", "");
        ArrayList<URL> arrayList2 = new ArrayList<URL>();
        arrayList.add(new File(string, "lib/ext/dtfj.jar"));
        for (File file : arrayList) {
            try {
                arrayList2.add(file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                logger.log(Level.FINE, "Problem locating necessary libraries: " + malformedURLException.getMessage());
                logger.log(Level.FINEST, "Problem locating necessary libraries: ", malformedURLException);
            }
        }
        return arrayList2.toArray(new URL[arrayList2.size()]);
    }

    static {
        logger = Logger.getLogger("com.ibm.java.diagnostics.plugins");
        URL[] uRLArray = PluginManagerLocator.getASMURLs();
        asmExtendedClassLoader = new PackageFilteredClassloader(uRLArray, DTFJContext.class.getClassLoader());
    }
}

