/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.utils.plugins;

import com.ibm.java.diagnostics.utils.plugins.Annotation;
import com.ibm.java.diagnostics.utils.plugins.ClassInfo;
import com.ibm.java.diagnostics.utils.plugins.Entry;
import com.ibm.java.diagnostics.utils.plugins.PluginConfig;
import java.util.Map;

public class DTFJPluginConfig
extends PluginConfig {
    protected String version = "1.*";
    protected boolean runtime = false;
    protected boolean image = false;
    protected String csv = null;

    public DTFJPluginConfig(Entry entry) {
        super(entry);
    }

    public void processAnnotations() {
        ClassInfo classInfo = (ClassInfo)this.entry.getData();
        Annotation annotation = classInfo.getAnnotation("Lcom/ibm/java/diagnostics/utils/plugins/DTFJPlugin;");
        if (annotation == null) {
            throw new IllegalArgumentException("The entry " + this.entry.getName() + " does not have the DTFJ plugin annotation");
        }
        for (Map.Entry<String, Object> entry : annotation.getValues().entrySet()) {
            String string = entry.getKey();
            Object object = entry.getValue();
            if (string.equals("version")) {
                this.version = (String)object;
                continue;
            }
            if (string.equals("runtime")) {
                this.runtime = (Boolean)object;
                continue;
            }
            if (string.equals("image")) {
                this.image = (Boolean)object;
                continue;
            }
            if (!string.equals("cacheOutput")) continue;
            this.cacheOutput = (Boolean)object;
        }
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isRuntime() {
        return this.runtime;
    }

    public boolean isImage() {
        return this.image;
    }

    @Override
    public String toCSV() {
        if (this.csv == null) {
            ClassInfo classInfo = (ClassInfo)this.entry.getData();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(classInfo.getClassname());
            stringBuilder.append(',');
            stringBuilder.append(this.version);
            stringBuilder.append(",true,");
            stringBuilder.append(classInfo.getURL().toString());
            stringBuilder.append(',');
            if (null != this.t) {
                stringBuilder.append(this.t.getClass().getName());
            }
            this.csv = stringBuilder.toString();
        }
        return this.csv;
    }

    public String toString() {
        return "DTFJ Plugin " + this.getClassName();
    }
}

