/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.utils.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class FileSniffer {
    private static final int ELF = 2135247942;
    private static final int MINIDUMP = 1296321872;
    private static final int USERDUMP_1 = 1431520594;
    private static final int USERDUMP_2 = 1146441040;
    private static final int DR1 = -992349888;
    private static final int DR2 = -992349632;
    private static final int CORE_DUMP_XX_VERSION = 267312562;
    private static final int CORE_DUMP_X_VERSION = 267312561;
    private static final int MACHO_64 = -17958193;
    private static final int MACHO_64_REV = -805638658;
    private static int[] coreid = new int[]{2135247942, 1296321872, -992349888, -992349632};
    private static final String PHD_HEADER = "portable heap dump";
    private static final int PHD_HEADER_SIZE = "portable heap dump".length() + 2;
    private static final int ZIP_ID = 67324752;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CoreFormatType getCoreFormat(ImageInputStream imageInputStream) throws IOException {
        try {
            int n = imageInputStream.readInt();
            int n2 = imageInputStream.readInt();
            if (n == 1296321872) {
                CoreFormatType coreFormatType = CoreFormatType.MINIDUMP;
                return coreFormatType;
            }
            if (n == 1431520594 && n2 == 1146441040) {
                CoreFormatType coreFormatType = CoreFormatType.USERDUMP;
                return coreFormatType;
            }
            if (n == 2135247942 && FileSniffer.isElfCoreFile(imageInputStream)) {
                CoreFormatType coreFormatType = CoreFormatType.ELF;
                return coreFormatType;
            }
            if (n == -992349888 || n == -992349632) {
                CoreFormatType coreFormatType = CoreFormatType.MVS;
                return coreFormatType;
            }
            if (n2 == 267312561 || n2 == 267312562) {
                CoreFormatType coreFormatType = CoreFormatType.XCOFF;
                return coreFormatType;
            }
            if ((n == -17958193 || n == -805638658) && FileSniffer.isMachCoreFile(imageInputStream, n)) {
                CoreFormatType coreFormatType = CoreFormatType.MACHO;
                return coreFormatType;
            }
            CoreFormatType coreFormatType = CoreFormatType.UNKNOWN;
            return coreFormatType;
        }
        finally {
            imageInputStream.seek(0L);
        }
    }

    public static boolean isCoreFile(InputStream inputStream, long l) throws IOException {
        MemoryCacheImageInputStream memoryCacheImageInputStream = new MemoryCacheImageInputStream(inputStream);
        return FileSniffer.isCoreFile(memoryCacheImageInputStream, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCoreFile(ImageInputStream imageInputStream, long l) throws IOException {
        try {
            boolean bl;
            int n = imageInputStream.readInt();
            int n2 = imageInputStream.readInt();
            for (bl = false; bl < coreid.length; bl += 1) {
                if (n != coreid[bl]) continue;
                if (n == 2135247942) {
                    boolean bl2 = FileSniffer.isElfCoreFile(imageInputStream);
                    return bl2;
                }
                boolean bl3 = true;
                return bl3;
            }
            if (n == 1431520594 && n2 == 1146441040) {
                bl = true;
                return bl;
            }
            if (n2 == 267312561 || n2 == 267312562) {
                bl = true;
                return bl;
            }
            if ((n == -17958193 || n == -805638658) && FileSniffer.isMachCoreFile(imageInputStream, n)) {
                bl = true;
                return bl;
            }
            bl = false;
            return bl;
        }
        finally {
            imageInputStream.seek(0L);
        }
    }

    private static boolean isElfCoreFile(ImageInputStream imageInputStream) throws IOException {
        boolean bl = false;
        ByteOrder byteOrder = imageInputStream.getByteOrder();
        imageInputStream.seek(5L);
        byte by = imageInputStream.readByte();
        imageInputStream.seek(16L);
        short s = 0;
        if (by == 1) {
            imageInputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            s = imageInputStream.readShort();
        } else if (by == 2) {
            imageInputStream.setByteOrder(ByteOrder.BIG_ENDIAN);
            s = imageInputStream.readShort();
        }
        if (s == 4) {
            bl = true;
        }
        imageInputStream.setByteOrder(byteOrder);
        return bl;
    }

    private static boolean isMachCoreFile(ImageInputStream imageInputStream, int n) throws IOException {
        ByteOrder byteOrder = imageInputStream.getByteOrder();
        if (n == -805638658) {
            imageInputStream.setByteOrder(imageInputStream.getByteOrder() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        }
        imageInputStream.seek(12L);
        int n2 = imageInputStream.readInt();
        imageInputStream.setByteOrder(byteOrder);
        return n2 == 4;
    }

    public static boolean isJavaCoreFile(InputStream inputStream, long l) throws IOException {
        MemoryCacheImageInputStream memoryCacheImageInputStream = new MemoryCacheImageInputStream(inputStream);
        return FileSniffer.isJavaCoreFile(memoryCacheImageInputStream, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isJavaCoreFile(ImageInputStream imageInputStream, long l) throws IOException {
        try {
            byte[] byArray = new byte[256];
            imageInputStream.read(byArray);
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            String[] stringArray = new String[]{"IBM1047", "UTF-16BE", "UTF-16LE", System.getProperty("file.encoding"), "IBM850"};
            try {
                int n;
                Charset charset = null;
                for (n = 0; n < stringArray.length && charset == null; ++n) {
                    charset = FileSniffer.attemptCharset(byteBuffer, Charset.forName(stringArray[n]));
                }
                n = charset != null ? 1 : 0;
                return n != 0;
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                boolean bl = false;
                imageInputStream.seek(0L);
                return bl;
            }
        }
        finally {
            imageInputStream.seek(0L);
        }
    }

    private static Charset attemptCharset(ByteBuffer byteBuffer, Charset charset) throws IOException {
        byteBuffer.rewind();
        String string = charset.decode(byteBuffer).toString();
        if (string.indexOf("0SECTION") >= 0) {
            int n = string.indexOf("1TICHARSET");
            if (n >= 0) {
                String string2 = string.substring(n += "1TICHARSET".length()).trim();
                string2 = string2.split("\\s+")[0];
                try {
                    Charset charset2 = Charset.forName(string2);
                    ByteBuffer byteBuffer2 = charset.encode("0SECTION");
                    ByteBuffer byteBuffer3 = charset2.encode("0SECTION");
                    if (byteBuffer2.equals(byteBuffer3)) {
                        return charset2;
                    }
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    // empty catch block
                }
            }
            return charset;
        }
        return null;
    }

    public static boolean isPHDFile(InputStream inputStream, long l) throws IOException {
        MemoryCacheImageInputStream memoryCacheImageInputStream = new MemoryCacheImageInputStream(inputStream);
        return FileSniffer.isPHDFile(memoryCacheImageInputStream, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPHDFile(ImageInputStream imageInputStream, long l) throws IOException {
        if (l < (long)PHD_HEADER_SIZE) {
            return false;
        }
        try {
            String string = FileSniffer.readUTF(imageInputStream, PHD_HEADER_SIZE);
            boolean bl = string.equals(PHD_HEADER);
            return bl;
        }
        finally {
            imageInputStream.reset();
        }
    }

    private static String readUTF(ImageInputStream imageInputStream, int n) throws IOException {
        int n2 = imageInputStream.readUnsignedShort();
        if (n2 > n && n > 0) {
            n2 = n;
        }
        byte[] byArray = new byte[n2];
        imageInputStream.readFully(byArray);
        return new String(byArray, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isZipFile(ImageInputStream imageInputStream) throws IOException {
        ByteOrder byteOrder = imageInputStream.getByteOrder();
        try {
            imageInputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            imageInputStream.mark();
            int n = imageInputStream.readInt();
            if (n != 67324752) {
                boolean bl = false;
                return bl;
            }
            imageInputStream.seek(10L);
            int n2 = imageInputStream.readUnsignedShort();
            int n3 = (n2 & 0x1F) / 2;
            if (n3 < 0 || n3 > 60) {
                boolean bl = false;
                return bl;
            }
            int n4 = (n2 & 0x7E0) >> 5;
            if (n4 < 0 || n4 > 60) {
                boolean bl = false;
                return bl;
            }
            int n5 = (n2 & 0xF800) >> 11;
            if (n5 < 0 || n5 > 23) {
                boolean bl = false;
                return bl;
            }
            int n6 = imageInputStream.readUnsignedShort();
            int n7 = n6 & 0x1F;
            if (n7 < 1 || n7 > 31) {
                boolean bl = false;
                return bl;
            }
            int n8 = (n6 & 0x1E0) >> 5;
            if (n8 < 1 || n8 > 12) {
                boolean bl = false;
                return bl;
            }
            int n9 = ((n6 & 0xFE00) >> 9) + 1980;
            if (n9 < 1980 || n9 > 2500) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            imageInputStream.setByteOrder(byteOrder);
            imageInputStream.reset();
        }
        return true;
    }

    public static boolean isZipFile(File file) throws IOException {
        FileImageInputStream fileImageInputStream = new FileImageInputStream(file);
        boolean bl = FileSniffer.isZipFile(fileImageInputStream);
        fileImageInputStream.close();
        return bl;
    }

    public static enum CoreFormatType {
        ELF,
        MINIDUMP,
        MVS,
        XCOFF,
        USERDUMP,
        MACHO,
        UNKNOWN;

    }
}

