/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd.util;

import com.ibm.dtfj.phd.util.LongArray;
import com.ibm.dtfj.phd.util.NumberStream;
import java.util.NoSuchElementException;

public class BufferedNumberStream
extends NumberStream {
    static final int BUFFER_SIZE = 4096;
    LongArray buffer;
    int bufferCount;
    int size;
    int readBufferCount;

    public BufferedNumberStream() {
        this(4096);
    }

    public BufferedNumberStream(int n) {
        this.buffer = new LongArray(n);
        this.size = n;
    }

    @Override
    public void writeLong(long l) {
        this.buffer.put(this.bufferCount++, l);
        if (this.bufferCount == 4096) {
            this.flushBuffer();
        }
    }

    void flushBuffer() {
        for (int i = 0; i < this.bufferCount; ++i) {
            long l = this.buffer.get(i);
            super.writeLong(l);
        }
        this.bufferCount = 0;
    }

    @Override
    public long readLong() {
        if (super.hasMore()) {
            return super.readLong();
        }
        if (this.readBufferCount > 0) {
            int n = this.bufferCount - this.readBufferCount--;
            return this.buffer.get(n);
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean hasMore() {
        return super.hasMore() || this.readBufferCount > 0;
    }

    @Override
    public int elementCount() {
        return super.elementCount() + this.bufferCount;
    }

    @Override
    public void rewind() {
        super.rewind();
        this.readBufferCount = this.bufferCount;
    }

    @Override
    public void clear() {
        super.clear();
        this.bufferCount = 0;
    }
}

