/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.builder.javacore;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.image.javacore.JCImageAddressSpace;
import com.ibm.dtfj.image.javacore.JCImageProcess;
import com.ibm.dtfj.image.javacore.JCImageThread;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaMonitor;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaRuntimeMemoryCategory;
import com.ibm.dtfj.java.JavaStackFrame;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.dtfj.java.javacore.JCInvalidArgumentsException;
import com.ibm.dtfj.java.javacore.JCJavaClass;
import com.ibm.dtfj.java.javacore.JCJavaClassLoader;
import com.ibm.dtfj.java.javacore.JCJavaLocation;
import com.ibm.dtfj.java.javacore.JCJavaMethod;
import com.ibm.dtfj.java.javacore.JCJavaMonitor;
import com.ibm.dtfj.java.javacore.JCJavaObject;
import com.ibm.dtfj.java.javacore.JCJavaRuntime;
import com.ibm.dtfj.java.javacore.JCJavaRuntimeMemoryCategory;
import com.ibm.dtfj.java.javacore.JCJavaStackFrame;
import com.ibm.dtfj.java.javacore.JCJavaThread;
import com.ibm.dtfj.java.javacore.JCJavaVMInitArgs;
import com.ibm.dtfj.java.javacore.JCJavaVMOption;
import com.ibm.dtfj.javacore.builder.BuilderFailureException;
import com.ibm.dtfj.javacore.builder.IJavaRuntimeBuilder;
import com.ibm.dtfj.javacore.builder.javacore.AbstractBuilderComponent;
import java.util.HashMap;

public class JavaRuntimeBuilder
extends AbstractBuilderComponent
implements IJavaRuntimeBuilder {
    private JCImageProcess fImageProcess = null;
    private JCJavaRuntime fJavaRuntime = null;
    private JCImageAddressSpace fAddressSpace = null;
    private JCJavaVMInitArgs fJavaVMInitArgs = null;
    private HashMap j9ThreadToJNIEnv = new HashMap();
    private String fId;

    public JavaRuntimeBuilder(JCImageProcess jCImageProcess, String string) throws JCInvalidArgumentsException {
        super(string);
        if (jCImageProcess == null) {
            throw new JCInvalidArgumentsException("Must pass non-null image process");
        }
        this.fImageProcess = jCImageProcess;
        this.fId = string;
        if (this.fId == null) {
            this.fJavaRuntime = new JCJavaRuntime(this.fImageProcess, this.fId);
        }
        this.fAddressSpace = this.fImageProcess.getImageAddressSpace();
    }

    @Override
    public JavaClassLoader addClassLoader(String string, long l, long l2) throws BuilderFailureException {
        try {
            JCJavaObject jCJavaObject;
            JCJavaClassLoader jCJavaClassLoader = this.getJavaRuntime().findJavaClassLoader(l);
            if (jCJavaClassLoader == null) {
                jCJavaClassLoader = new JCJavaClassLoader(this.getJavaRuntime(), l);
            }
            if ((jCJavaObject = jCJavaClassLoader.getInternalObject()) == null) {
                JCJavaClass jCJavaClass = this.getJavaRuntime().findJavaClass(string);
                if (jCJavaClass == null) {
                    jCJavaClass = new JCJavaClass(this.getJavaRuntime(), string);
                }
                ImagePointer imagePointer = this.fAddressSpace.getPointer(l2);
                jCJavaObject = new JCJavaObject(imagePointer, jCJavaClass);
                jCJavaClassLoader.setObject(jCJavaObject);
            }
            return jCJavaClassLoader;
        }
        catch (JCInvalidArgumentsException jCInvalidArgumentsException) {
            throw new BuilderFailureException(jCInvalidArgumentsException);
        }
    }

    @Override
    public JavaClass addClass(JavaClassLoader javaClassLoader, String string, long l, long l2, String string2) throws BuilderFailureException {
        try {
            JCJavaClassLoader jCJavaClassLoader = (JCJavaClassLoader)javaClassLoader;
            JCJavaClass jCJavaClass = this.generateJavaClass(this.getJavaRuntime(), string, l);
            jCJavaClass.setJavaSuperClass(l2);
            jCJavaClass.setClassLoader(jCJavaClassLoader);
            ImagePointer imagePointer = jCJavaClass.getID();
            if (imagePointer != null) {
                jCJavaClassLoader.addClass(string, imagePointer);
            } else if (jCJavaClassLoader.internalGetClass(string) == null) {
                jCJavaClassLoader.addClass(string);
            }
            return jCJavaClass;
        }
        catch (JCInvalidArgumentsException jCInvalidArgumentsException) {
            throw new BuilderFailureException(jCInvalidArgumentsException);
        }
    }

    private JCJavaClass generateJavaClass(JCJavaRuntime jCJavaRuntime, String string, long l) throws JCInvalidArgumentsException {
        if (string != null) {
            if (this.fAddressSpace.isValidAddressID(l)) {
                JCJavaClass jCJavaClass = jCJavaRuntime.findJavaClass(l);
                if (jCJavaClass == null) {
                    jCJavaClass = jCJavaRuntime.findJavaClass(string);
                    if (jCJavaClass != null) {
                        ImagePointer imagePointer = jCJavaClass.getID();
                        if (imagePointer == null) {
                            jCJavaClass.setID(l);
                        } else {
                            jCJavaClass = new JCJavaClass(jCJavaRuntime, string);
                            jCJavaClass.setID(l);
                        }
                    } else {
                        jCJavaClass = new JCJavaClass(jCJavaRuntime, string);
                        jCJavaClass.setID(l);
                    }
                }
                return jCJavaClass;
            }
            JCJavaClass jCJavaClass = jCJavaRuntime.findJavaClass(string);
            if (jCJavaClass == null) {
                jCJavaClass = new JCJavaClass(jCJavaRuntime, string);
            }
            if (this.fAddressSpace.isValidAddressID(l)) {
                jCJavaClass.setID(l);
            }
            return jCJavaClass;
        }
        throw new JCInvalidArgumentsException("Failed to add class.  Null class name");
    }

    public ImageProcess getImageProcess() {
        return this.fImageProcess;
    }

    @Override
    public JavaThread addJavaThread(ImageThread imageThread, String string, long l, long l2, long l3, long l4, String string2, int n, long l5, String string3) throws BuilderFailureException {
        try {
            JCJavaObject jCJavaObject;
            ImagePointer imagePointer;
            Object object;
            Object object2;
            if (l2 != -1L && l4 != -1L) {
                object2 = this.fAddressSpace.getPointer(l4);
                this.j9ThreadToJNIEnv.put(l2, object2);
            }
            if (!this.fAddressSpace.isValidAddressID(l)) {
                throw new JCInvalidArgumentsException("Must pass a valid thread id");
            }
            object2 = this.getJavaRuntime().findJavaThread(l);
            if (object2 == null) {
                object = this.fAddressSpace.getPointer(l);
                object2 = new JCJavaThread(this.getJavaRuntime(), (ImagePointer)object);
            }
            ((JCJavaThread)object2).setName(string);
            ((JCJavaThread)object2).setPriority(n);
            ((JCJavaThread)object2).setState(string2);
            ((JCJavaThread)object2).setImageThread((JCImageThread)imageThread);
            if (l4 == -1L) {
                object = (ImagePointer)this.j9ThreadToJNIEnv.get(l2);
                if (object != null) {
                    ((JCJavaThread)object2).setJNIEnv((ImagePointer)object);
                } else {
                    ((JCJavaThread)object2).setJNIEnv(((JCJavaThread)object2).getThreadID());
                }
            }
            if (this.fAddressSpace.isValidAddressID(l3)) {
                object = this.generateJavaClass(this.getJavaRuntime(), "java/lang/Thread", -1L);
                imagePointer = this.fAddressSpace.getPointer(l3);
                jCJavaObject = new JCJavaObject(imagePointer, (JavaClass)object);
                ((JCJavaThread)object2).setObject(jCJavaObject);
            }
            if (this.fAddressSpace.isValidAddressID(l5)) {
                object = this.generateJavaClass(this.getJavaRuntime(), string3, -1L);
                imagePointer = this.fAddressSpace.getPointer(l5);
                jCJavaObject = new JCJavaObject(imagePointer, (JavaClass)object);
                ((JCJavaThread)object2).setBlockingObject(jCJavaObject);
            }
            return object2;
        }
        catch (JCInvalidArgumentsException jCInvalidArgumentsException) {
            throw new BuilderFailureException(jCInvalidArgumentsException);
        }
    }

    @Override
    public JavaStackFrame addJavaStackFrame(JavaThread javaThread, String string, String string2, String string3, String string4, String string5, int n) throws BuilderFailureException {
        try {
            JCJavaThread jCJavaThread = (JCJavaThread)javaThread;
            JCJavaClass jCJavaClass = this.getJavaRuntime().findJavaClass(string);
            if (jCJavaClass == null) {
                jCJavaClass = new JCJavaClass(this.getJavaRuntime(), string);
            }
            JCJavaMethod jCJavaMethod = new JCJavaMethod(string3, jCJavaClass);
            JCJavaLocation jCJavaLocation = new JCJavaLocation(jCJavaMethod);
            jCJavaLocation.setFilename(string2);
            jCJavaLocation.setCompilation(string5);
            jCJavaLocation.setLineNumber(n);
            JCJavaStackFrame jCJavaStackFrame = new JCJavaStackFrame(jCJavaThread, jCJavaLocation);
            if ("run".equals(string3)) {
                try {
                    ImagePointer imagePointer;
                    JavaObject javaObject = jCJavaThread.getObject();
                    if (javaObject != null && this.fAddressSpace.isValidAddressID((imagePointer = javaObject.getID()).getAddress())) {
                        JCJavaObject jCJavaObject = new JCJavaObject(imagePointer, jCJavaClass);
                        jCJavaThread.setObject(jCJavaObject);
                    }
                }
                catch (CorruptDataException corruptDataException) {
                    // empty catch block
                }
            }
            return jCJavaStackFrame;
        }
        catch (JCInvalidArgumentsException jCInvalidArgumentsException) {
            throw new BuilderFailureException(jCInvalidArgumentsException);
        }
    }

    @Override
    public JavaMonitor addJavaMonitor(String string, long l, long l2, String string2, long l3) throws BuilderFailureException {
        try {
            Object object;
            JCJavaMonitor jCJavaMonitor = this.getJavaRuntime().findMonitor(l);
            if (jCJavaMonitor == null) {
                object = this.fAddressSpace.getPointer(l);
                jCJavaMonitor = new JCJavaMonitor(this.getJavaRuntime(), (ImagePointer)object, string);
            }
            jCJavaMonitor.setOwner(l3);
            if (string2 != null && (object = this.generateJavaClass(this.getJavaRuntime(), string2, -1L)) != null && this.fAddressSpace.isValidAddressID(l2)) {
                ImagePointer imagePointer = this.fAddressSpace.getPointer(l2);
                JCJavaObject jCJavaObject = new JCJavaObject(imagePointer, (JavaClass)object);
                jCJavaMonitor.setObject(jCJavaObject);
            }
            return jCJavaMonitor;
        }
        catch (JCInvalidArgumentsException jCInvalidArgumentsException) {
            throw new BuilderFailureException(jCInvalidArgumentsException);
        }
    }

    @Override
    public void addBlockedThread(JavaMonitor javaMonitor, long l) throws BuilderFailureException {
        JCJavaMonitor jCJavaMonitor = (JCJavaMonitor)javaMonitor;
        ImagePointer imagePointer = this.fAddressSpace.getPointer(l);
        jCJavaMonitor.addEnterWaiter(imagePointer);
    }

    @Override
    public void addWaitOnNotifyThread(JavaMonitor javaMonitor, long l) throws BuilderFailureException {
        JCJavaMonitor jCJavaMonitor = (JCJavaMonitor)javaMonitor;
        ImagePointer imagePointer = this.fAddressSpace.getPointer(l);
        jCJavaMonitor.addNotifyWaiter(imagePointer);
    }

    @Override
    public void addVMInitArgs() throws BuilderFailureException {
        if (this.fJavaVMInitArgs != null) {
            throw new BuilderFailureException("JCJavaVMInitArgs already created for this JavaRuntime");
        }
        try {
            this.fJavaVMInitArgs = new JCJavaVMInitArgs(this.getJavaRuntime(), 0, true);
        }
        catch (JCInvalidArgumentsException jCInvalidArgumentsException) {
            throw new BuilderFailureException(jCInvalidArgumentsException);
        }
    }

    @Override
    public void addVMOption(String string) throws BuilderFailureException {
        if (this.fJavaVMInitArgs == null) {
            throw new BuilderFailureException("JCJavaVMInitArgs must be created before options added");
        }
        try {
            this.fJavaVMInitArgs.addOption(new JCJavaVMOption(string, null));
        }
        catch (JCInvalidArgumentsException jCInvalidArgumentsException) {
            throw new BuilderFailureException(jCInvalidArgumentsException);
        }
    }

    @Override
    public void addVMOption(String string, long l) throws BuilderFailureException {
        if (this.fJavaVMInitArgs == null) {
            throw new BuilderFailureException("JCJavaVMInitArgs must be created before options added");
        }
        try {
            ImagePointer imagePointer = this.fAddressSpace.getPointer(l);
            this.fJavaVMInitArgs.addOption(new JCJavaVMOption(string, imagePointer));
        }
        catch (JCInvalidArgumentsException jCInvalidArgumentsException) {
            throw new BuilderFailureException(jCInvalidArgumentsException);
        }
    }

    @Override
    public void setJavaVersion(String string) {
        this.getJavaRuntime().setVersion(string);
    }

    private JCJavaRuntime getJavaRuntime() {
        if (this.fJavaRuntime == null) {
            try {
                this.fJavaRuntime = new JCJavaRuntime(this.fImageProcess, this.fId);
            }
            catch (JCInvalidArgumentsException jCInvalidArgumentsException) {
                IllegalStateException illegalStateException = new IllegalStateException();
                illegalStateException.initCause(jCInvalidArgumentsException);
                throw illegalStateException;
            }
        }
        return this.fJavaRuntime;
    }

    @Override
    public JavaRuntimeMemoryCategory addMemoryCategory(String string, long l, long l2, JavaRuntimeMemoryCategory javaRuntimeMemoryCategory) {
        JCJavaRuntimeMemoryCategory jCJavaRuntimeMemoryCategory = new JCJavaRuntimeMemoryCategory(string, l, l2);
        if (javaRuntimeMemoryCategory != null) {
            ((JCJavaRuntimeMemoryCategory)javaRuntimeMemoryCategory).addChild(jCJavaRuntimeMemoryCategory);
        } else {
            this.getJavaRuntime().addTopLevelMemoryCategory(jCJavaRuntimeMemoryCategory);
        }
        return jCJavaRuntimeMemoryCategory;
    }

    @Override
    public void setShallowCountersForCategory(JavaRuntimeMemoryCategory javaRuntimeMemoryCategory, long l, long l2) {
        ((JCJavaRuntimeMemoryCategory)javaRuntimeMemoryCategory).setShallowCounters(l, l2);
    }

    @Override
    public void setJITEnabled(boolean bl) {
        this.getJavaRuntime().setJITEnabled(bl);
    }

    @Override
    public void addJITProperty(String string, String string2) {
        this.getJavaRuntime().addJITProperty(string, string2);
    }

    @Override
    public void setStartTime(long l) {
        this.getJavaRuntime().setStartTime(l);
    }

    @Override
    public void setStartTimeNanos(long l) {
        this.getJavaRuntime().setStartTimeNanos(l);
    }
}

