/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.builder.javacore;

import com.ibm.dtfj.image.ImageModule;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.image.ImageStackFrame;
import com.ibm.dtfj.image.ImageSymbol;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.image.javacore.JCImageAddressSpace;
import com.ibm.dtfj.image.javacore.JCImageModule;
import com.ibm.dtfj.image.javacore.JCImageProcess;
import com.ibm.dtfj.image.javacore.JCImageRegister;
import com.ibm.dtfj.image.javacore.JCImageStackFrame;
import com.ibm.dtfj.image.javacore.JCImageSymbol;
import com.ibm.dtfj.image.javacore.JCImageThread;
import com.ibm.dtfj.java.javacore.JCInvalidArgumentsException;
import com.ibm.dtfj.javacore.builder.BuilderFailureException;
import com.ibm.dtfj.javacore.builder.IImageProcessBuilder;
import com.ibm.dtfj.javacore.builder.IJavaRuntimeBuilder;
import com.ibm.dtfj.javacore.builder.javacore.AbstractBuilderComponent;
import com.ibm.dtfj.javacore.builder.javacore.BuilderContainer;
import com.ibm.dtfj.javacore.builder.javacore.JavaRuntimeBuilder;
import java.util.Map;
import java.util.Properties;

public class ImageProcessBuilder
extends AbstractBuilderComponent
implements IImageProcessBuilder {
    private JCImageAddressSpace fImageAddressSpace;
    private JCImageProcess fImageProcess;
    private BuilderContainer fBuilderContainer;
    private Map registers;

    public ImageProcessBuilder(JCImageAddressSpace jCImageAddressSpace, String string) throws JCInvalidArgumentsException {
        super(string);
        if (jCImageAddressSpace == null) {
            throw new IllegalArgumentException("A valid image must be passed");
        }
        this.fImageAddressSpace = jCImageAddressSpace;
        this.fBuilderContainer = this.getBuilderContainer();
        this.fImageProcess = new JCImageProcess(this.fImageAddressSpace);
    }

    @Override
    public IJavaRuntimeBuilder getCurrentJavaRuntimeBuilder() {
        return (IJavaRuntimeBuilder)((Object)this.fBuilderContainer.getLastAdded());
    }

    @Override
    public IJavaRuntimeBuilder getJavaRuntimeBuilder(String string) {
        return (IJavaRuntimeBuilder)((Object)this.fBuilderContainer.findComponent(string));
    }

    @Override
    public IJavaRuntimeBuilder generateJavaRuntimeBuilder(String string) throws BuilderFailureException {
        JavaRuntimeBuilder javaRuntimeBuilder = null;
        if (this.getJavaRuntimeBuilder(string) == null) {
            try {
                javaRuntimeBuilder = new JavaRuntimeBuilder(this.fImageProcess, string);
                if (!(javaRuntimeBuilder instanceof AbstractBuilderComponent)) {
                    throw new BuilderFailureException(javaRuntimeBuilder.toString() + " must also be an " + AbstractBuilderComponent.class);
                }
                this.fBuilderContainer.add(javaRuntimeBuilder);
            }
            catch (JCInvalidArgumentsException jCInvalidArgumentsException) {
                throw new BuilderFailureException(jCInvalidArgumentsException);
            }
        }
        return javaRuntimeBuilder;
    }

    @Override
    public ImageModule addLibrary(String string) {
        ImageModule imageModule = null;
        if (string != null && (imageModule = this.fImageProcess.getLibrary(string)) == null) {
            JCImageModule jCImageModule = new JCImageModule(string);
            this.fImageProcess.addLibrary(jCImageModule);
            imageModule = jCImageModule;
        }
        return imageModule;
    }

    @Override
    public void setPointerSize(int n) {
        this.fImageProcess.setPointerSize(n);
    }

    @Override
    public ImageThread addImageThread(long l, long l2, Properties properties) throws BuilderFailureException {
        try {
            ImagePointer imagePointer = this.fImageAddressSpace.getPointer(l);
            JCImageThread jCImageThread = this.fImageProcess.getImageThread(imagePointer);
            if (jCImageThread == null) {
                jCImageThread = new JCImageThread(imagePointer);
                if (this.registers != null) {
                    for (Map.Entry<Object, Object> entry : this.registers.entrySet()) {
                        JCImageRegister jCImageRegister = new JCImageRegister((String)entry.getKey(), (Number)entry.getValue());
                        jCImageThread.addRegister(jCImageRegister);
                    }
                    this.registers = null;
                }
                this.fImageProcess.addImageThread(jCImageThread);
            }
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                jCImageThread.addProperty(entry.getKey(), entry.getValue());
            }
            if (l2 != -1L) {
                imagePointer = this.fImageAddressSpace.getPointer(l2);
                jCImageThread.setSystemThreadID(imagePointer);
            }
            return jCImageThread;
        }
        catch (JCInvalidArgumentsException jCInvalidArgumentsException) {
            throw new BuilderFailureException(jCInvalidArgumentsException);
        }
    }

    @Override
    public void setSignal(int n) {
        this.fImageProcess.setSignal(n);
    }

    @Override
    public void setCommandLine(String string) {
        this.fImageProcess.setCommandLine(string);
    }

    @Override
    public ImageSection addImageStackSection(ImageThread imageThread, ImageSection imageSection) {
        JCImageThread jCImageThread = (JCImageThread)imageThread;
        jCImageThread.addImageStackSection(imageSection);
        return imageSection;
    }

    @Override
    public void setRegisters(Map map) {
        this.registers = map;
    }

    @Override
    public void addEnvironmentVariable(String string, String string2) {
        this.fImageProcess.addEnvironment(string, string2);
    }

    @Override
    public ImageSymbol addRoutine(ImageModule imageModule, String string, long l) {
        ImagePointer imagePointer = this.fImageAddressSpace.getPointer(l);
        JCImageSymbol jCImageSymbol = new JCImageSymbol(string, imagePointer);
        JCImageModule jCImageModule = (JCImageModule)imageModule;
        jCImageModule.addSymbol(jCImageSymbol);
        return jCImageSymbol;
    }

    @Override
    public ImageStackFrame addImageStackFrame(long l, String string, long l2, long l3) {
        ImagePointer imagePointer = this.fImageAddressSpace.getPointer(l);
        JCImageThread jCImageThread = this.fImageProcess.getImageThread(imagePointer);
        ImagePointer imagePointer2 = l3 != -1L ? this.fImageAddressSpace.getPointer(l3) : null;
        JCImageStackFrame jCImageStackFrame = new JCImageStackFrame(string, null, imagePointer2);
        if (jCImageThread != null) {
            JCImageThread jCImageThread2 = jCImageThread;
            jCImageThread2.addImageStackFrame(jCImageStackFrame);
        }
        return jCImageStackFrame;
    }

    @Override
    public void setExecutable(ImageModule imageModule) {
        this.fImageProcess.setExecutable(imageModule);
    }

    @Override
    public void setID(String string) {
        this.fImageProcess.setID(string);
    }

    @Override
    public void setCurrentThreadID(long l) {
        this.fImageProcess.setCurrentThreadID(l);
    }

    @Override
    public void addProperty(ImageModule imageModule, String string, String string2) {
        JCImageModule jCImageModule = (JCImageModule)imageModule;
        jCImageModule.addProperty(string, string2);
    }
}

