/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.image.javacore;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageModule;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.image.j9.SignalName;
import com.ibm.dtfj.image.javacore.JCCorruptData;
import com.ibm.dtfj.image.javacore.JCImage;
import com.ibm.dtfj.image.javacore.JCImageAddressSpace;
import com.ibm.dtfj.image.javacore.JCImageModule;
import com.ibm.dtfj.image.javacore.JCImageThread;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.java.javacore.JCInvalidArgumentsException;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class JCImageProcess
implements ImageProcess {
    private Vector<JavaRuntime> fRuntimes;
    private Vector<JCImageThread> fImageThreads;
    private Vector<JCImageModule> fLibraries;
    private Properties fProperties;
    private String fCommandLine;
    private String fID;
    private int fPointerSize;
    private ImageModule fExecutable;
    private int fSignal;
    private long fCurrentThreadID = -1L;
    private final JCImageAddressSpace fImageAddressSpace;

    public JCImageProcess(JCImageAddressSpace jCImageAddressSpace) throws JCInvalidArgumentsException {
        if (jCImageAddressSpace == null) {
            throw new JCInvalidArgumentsException("An image process must pertain to an image address space");
        }
        this.fImageAddressSpace = jCImageAddressSpace;
        this.fRuntimes = new Vector();
        this.fImageThreads = new Vector();
        this.fLibraries = new Vector();
        this.fProperties = new Properties();
        this.fCommandLine = null;
        this.fID = null;
        this.fPointerSize = -1;
        this.fExecutable = null;
        this.fSignal = -1;
        jCImageAddressSpace.addImageProcess(this);
    }

    @Override
    public String getCommandLine() throws DataUnavailable, CorruptDataException {
        if (this.fCommandLine == null) {
            throw new DataUnavailable("No command line available");
        }
        return this.fCommandLine;
    }

    @Override
    public ImageThread getCurrentThread() throws CorruptDataException {
        ImagePointer imagePointer;
        JCImageThread jCImageThread = null;
        if (this.fCurrentThreadID != -1L && (jCImageThread = this.getImageThread(imagePointer = this.fImageAddressSpace.getPointer(this.fCurrentThreadID))) == null) {
            throw new CorruptDataException(new JCCorruptData("Bad native thread ID", imagePointer));
        }
        return jCImageThread;
    }

    public void addEnvironment(Object object, Object object2) {
        this.fProperties.put(object, object2);
    }

    @Override
    public Properties getEnvironment() throws DataUnavailable, CorruptDataException {
        if (this.fProperties == null || this.fProperties.size() == 0) {
            throw new DataUnavailable("Environment data not available");
        }
        return this.fProperties;
    }

    @Override
    public ImageModule getExecutable() throws DataUnavailable, CorruptDataException {
        if (this.fExecutable == null) {
            throw new DataUnavailable("No executable data");
        }
        return this.fExecutable;
    }

    @Override
    public String getID() throws DataUnavailable, CorruptDataException {
        if (this.fID == null) {
            throw new DataUnavailable("No process ID available");
        }
        return this.fID;
    }

    @Override
    public Iterator<?> getLibraries() throws DataUnavailable, CorruptDataException {
        if (this.fLibraries.size() == 0) {
            throw new DataUnavailable("No library information available");
        }
        return this.fLibraries.iterator();
    }

    public void addLibrary(JCImageModule jCImageModule) {
        if (jCImageModule != null) {
            this.fLibraries.add(jCImageModule);
        }
    }

    public ImageModule getLibrary(String string) {
        JCImageModule jCImageModule = null;
        if (string != null) {
            Iterator<JCImageModule> iterator = this.fLibraries.iterator();
            while (jCImageModule == null && iterator.hasNext()) {
                String string2;
                JCImageModule jCImageModule2 = iterator.next();
                if (jCImageModule2 == null || (string2 = jCImageModule2.getInternalName()) == null || !string2.equals(string)) continue;
                jCImageModule = jCImageModule2;
            }
        }
        return jCImageModule;
    }

    @Override
    public int getPointerSize() {
        return this.fPointerSize;
    }

    public void setPointerSize(int n) {
        this.fPointerSize = n;
    }

    public void setSignal(int n) {
        this.fSignal = n;
    }

    public void setCommandLine(String string) {
        this.fCommandLine = string;
    }

    @Override
    public Iterator<?> getRuntimes() {
        return this.fRuntimes.iterator();
    }

    public void addRuntime(JavaRuntime javaRuntime) {
        if (javaRuntime != null) {
            this.fRuntimes.add(javaRuntime);
        }
    }

    @Override
    public String getSignalName() throws DataUnavailable, CorruptDataException {
        int n = this.fSignal;
        if (n == -1) {
            throw new DataUnavailable("No signal name available");
        }
        String string = null;
        try {
            JCImage jCImage = this.fImageAddressSpace.getImage();
            String string2 = jCImage.getSystemType();
            if (string2 != null) {
                if (string2.equalsIgnoreCase("AIX")) {
                    string = SignalName.forAIX(n);
                } else if (string2.equalsIgnoreCase("Linux")) {
                    string = SignalName.forLinux(n);
                } else if (string2.equalsIgnoreCase("Mac OS X")) {
                    string = SignalName.forOSX(n);
                } else if (string2.regionMatches(true, 0, "Windows", 0, 7)) {
                    string = SignalName.forWindows(n);
                } else if (string2.equalsIgnoreCase("z/OS")) {
                    string = SignalName.forZOS(n);
                }
            }
        }
        catch (CorruptDataException | DataUnavailable dTFJException) {
            // empty catch block
        }
        if (string == null) {
            string = "Unknown signal number " + n;
        }
        return string;
    }

    @Override
    public int getSignalNumber() throws DataUnavailable, CorruptDataException {
        if (this.fSignal == -1) {
            throw new DataUnavailable("No signal number available");
        }
        return this.fSignal;
    }

    @Override
    public Iterator<?> getThreads() {
        return this.fImageThreads.iterator();
    }

    public void addImageThread(JCImageThread jCImageThread) {
        if (jCImageThread != null) {
            this.fImageThreads.add(jCImageThread);
        }
    }

    public JCImageThread getImageThread(ImagePointer imagePointer) {
        JCImageThread jCImageThread = null;
        if (imagePointer != null) {
            Iterator<?> iterator = this.getThreads();
            while (jCImageThread == null && iterator.hasNext()) {
                ImagePointer imagePointer2;
                JCImageThread jCImageThread2 = (JCImageThread)iterator.next();
                if (jCImageThread2 == null || (imagePointer2 = jCImageThread2.getInternalID()) == null || !imagePointer2.equals(imagePointer)) continue;
                jCImageThread = jCImageThread2;
            }
        }
        return jCImageThread;
    }

    public JCImageAddressSpace getImageAddressSpace() {
        return this.fImageAddressSpace;
    }

    public void setExecutable(ImageModule imageModule) {
        this.fExecutable = imageModule;
    }

    public void setID(String string) {
        this.fID = string;
    }

    public void setCurrentThreadID(long l) {
        if (this.fCurrentThreadID == -1L) {
            this.fCurrentThreadID = l;
        }
    }

    @Override
    public Properties getProperties() {
        return new Properties();
    }
}

