!STARTOFREGISTRYGENERATEDFILE 'WakeDynamics_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! WakeDynamics_Types
!.................................................................................................................................
! This file is part of WakeDynamics.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in WakeDynamics. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE WakeDynamics_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE NWTC_Library
IMPLICIT NONE
    INTEGER(IntKi), PUBLIC, PARAMETER  :: WakeDiamMod_RotDiam = 1      ! Wake diameter calculation model: rotor diameter [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: WakeDiamMod_Velocity = 2      ! Wake diameter calculation model: velocity-based [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: WakeDiamMod_MassFlux = 3      ! Wake diameter calculation model: mass-flux based [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: WakeDiamMod_MtmFlux = 4      ! Wake diameter calculation model: momentum-flux based [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Mod_Wake_Polar = 1      ! Wake model [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Mod_Wake_Curl = 2      ! Wake model [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Mod_Wake_Cartesian = 3      ! Wake model [-]
! =========  WD_InputFileType  =======
  TYPE, PUBLIC :: WD_InputFileType
    REAL(ReKi)  :: dr = 0.0_ReKi      !< Radial increment of radial finite-difference grid [>0.0] [m]
    INTEGER(IntKi)  :: NumRadii = 0_IntKi      !< Number of radii in the radial finite-difference grid [>=2] [-]
    INTEGER(IntKi)  :: NumPlanes = 0_IntKi      !< Number of wake planes [>=2] [-]
    INTEGER(IntKi)  :: Mod_Wake = 0_IntKi      !< Switch between wake formulations 1=Polar, 2=Cartesian, 3=Curl [-]
    REAL(ReKi)  :: f_c = 0.0_ReKi      !< Cut-off frequency of the low-pass time-filter for the wake advection, deflection, and meandering model [>0.0] [Hz]
    REAL(ReKi)  :: C_HWkDfl_O = 0.0_ReKi      !< Calibrated parameter in the correction for wake deflection defining the horizontal offset at the rotor [m]
    REAL(ReKi)  :: C_HWkDfl_OY = 0.0_ReKi      !< Calibrated parameter in the correction for wake deflection defining the horizontal offset at the rotor scaled with yaw error [m/rad]
    REAL(ReKi)  :: C_HWkDfl_x = 0.0_ReKi      !< Calibrated parameter in the correction for wake deflection defining the horizontal offset scaled with downstream distance [-]
    REAL(ReKi)  :: C_HWkDfl_xY = 0.0_ReKi      !< Calibrated parameter in the correction for wake deflection defining the horizontal offset scaled with downstream distance and yaw error [1/rad]
    REAL(ReKi)  :: C_NearWake = 0.0_ReKi      !< Calibrated parameter for the near-wake correction [>-1.0] [-]
    REAL(ReKi)  :: k_vAmb = 0.0_ReKi      !< Calibrated parameter for the influence of ambient turbulence in the eddy viscosity [>=0.0] [-]
    REAL(ReKi)  :: C_vAmb_FMin = 0.0_ReKi      !< Calibrated parameter in the eddy viscosity filter function for ambient turbulence defining the value in the minimum region [>=0.0 and <=1.0] [-]
    REAL(ReKi)  :: C_vAmb_DMin = 0.0_ReKi      !< Calibrated parameter in the eddy viscosity filter function for ambient turbulence defining the transitional diameter fraction between the minimum and exponential regions [>=0.0 ] [-]
    REAL(ReKi)  :: C_vAmb_DMax = 0.0_ReKi      !< Calibrated parameter in the eddy viscosity filter function for ambient turbulence defining the transitional diameter fraction between the exponential and maximum regions [> C_vAmb_DMin] [-]
    REAL(ReKi)  :: C_vAmb_Exp = 0.0_ReKi      !< Calibrated parameter in the eddy viscosity filter function for ambient turbulence defining the exponent in the exponential region [> 0.0] [-]
    REAL(ReKi)  :: k_vShr = 0.0_ReKi      !< Calibrated parameter for the influence of the shear layer in the eddy viscosity [>=0.0] [-]
    REAL(ReKi)  :: C_vShr_FMin = 0.0_ReKi      !< Calibrated parameter in the eddy viscosity filter function for the shear layer defining the value in the minimum region [>=0.0 and <=1.0] [-]
    REAL(ReKi)  :: C_vShr_DMin = 0.0_ReKi      !< Calibrated parameter in the eddy viscosity filter function for the shear layer defining the transitional diameter fraction between the minimum and exponential regions [>=0.0] [-]
    REAL(ReKi)  :: C_vShr_DMax = 0.0_ReKi      !< Calibrated parameter in the eddy viscosity filter function for the shear layer defining the transitional diameter fraction between the exponential and maximum regions [> C_vShr_DMin] [-]
    REAL(ReKi)  :: C_vShr_Exp = 0.0_ReKi      !< Calibrated parameter in the eddy viscosity filter function for the shear layer defining the exponent in the exponential region [> 0.0] [-]
    INTEGER(IntKi)  :: Mod_WakeDiam = 0_IntKi      !< Wake diameter calculation model {1: rotor diameter, 2: velocity-based, 3: mass-flux based, 4: momentum-flux based} [DEFAULT=1] [-]
    REAL(ReKi)  :: C_WakeDiam = 0.0_ReKi      !< Calibrated parameter for wake diameter calculation [>0.0 and <1.0] [unused for Mod_WakeDiam=1] [-]
    LOGICAL  :: Swirl = .false.      !< Switch to add swirl [only used if Mod_Wake=2 or 2] [-]
    REAL(ReKi)  :: k_VortexDecay = 0.0_ReKi      !< Vortex decay constant for curl [-]
    REAL(ReKi)  :: sigma_D = 0.0_ReKi      !< The width of the Gaussian vortices used for the curled wake model divided by diameter [-]
    INTEGER(IntKi)  :: NumVortices = 0_IntKi      !< The number of vortices used for the curled wake model [-]
    INTEGER(IntKi)  :: FilterInit = 0_IntKi      !< Switch to filter the initial wake plane deficit and select the number of grid points for the filter {0: no filter, 1: filter of size 1} or DEFAULT [DEFAULT=0: if Mod_Wake is 1 or 3, or DEFAULT=2: if Mod_Wwake is 2] (switch) [-]
    REAL(ReKi)  :: k_vCurl = 0.0_ReKi      !< Calibrated parameter for the eddy viscosity in curled-wake model [>=0.0] [-]
    LOGICAL  :: OutAllPlanes = .false.      !< Output all planes [-]
    LOGICAL  :: WAT = .false.      !< Switch for turning on and off wake-added turbulence [-]
    REAL(ReKi)  :: WAT_k_Def_k_c = 0.0_ReKi      !< Calibrated parameter for the influence of the maximum wake deficit on wake-added turblence (-) [>=0] or DEFAULT [DEFAULT=0.6] [-]
    REAL(ReKi)  :: WAT_k_Def_FMin = 0.0_ReKi      !< Calibrated parameter in the eddy viscosity filter function for the WAT maximum wake deficit defining the value in the minimum region [>=0.0 and <=1.0] or DEFAULT [DEFAULT=0.0] [-]
    REAL(ReKi)  :: WAT_k_Def_DMin = 0.0_ReKi      !< Calibrated parameter in the eddy viscosity filter function for the WAT maximum wake deficit defining the transitional diameter fraction between the minimum and exponential regions [>=0.0] or DEFAULT [DEFAULT=0.0] [-]
    REAL(ReKi)  :: WAT_k_Def_DMax = 0.0_ReKi      !< Calibrated parameter in the eddy viscosity filter function for the WAT maximum wake deficit defining the transitional diameter fraction between the exponential and maximum regions [> WAT_k_Def_DMin] or DEFAULT [DEFAULT=2.0] [-]
    REAL(ReKi)  :: WAT_k_Def_Exp = 0.0_ReKi      !< Calibrated parameter in the eddy viscosity filter function for the WAT maximum wake deficit defining the exponent in the exponential region [> 0.0] or DEFAULT [DEFAULT=1.0] [-]
    REAL(ReKi)  :: WAT_k_Grad_k_c = 0.0_ReKi      !< Calibrated parameter for the influence of the radial velocity gradient of the wake deficit on wake-added turblence (-) [>=0] or DEFAULT [DEFAULT=3.0] [-]
    REAL(ReKi)  :: WAT_k_Grad_FMin = 0.0_ReKi      !< Calibrated parameter in the eddy viscosity filter function for the WAT radial velocity gradient of the wake deficit defining the value in the minimum region [>=0.0 and <=1.0] or DEFAULT [DEFAULT=0.0] [-]
    REAL(ReKi)  :: WAT_k_Grad_DMin = 0.0_ReKi      !< Calibrated parameter in the eddy viscosity filter function for the WAT radial velocity gradient of the wake deficit defining the transitional diameter fraction between the minimum and exponential regions [>=0.0] or DEFAULT [DEFAULT=0.0] [-]
    REAL(ReKi)  :: WAT_k_Grad_DMax = 0.0_ReKi      !< Calibrated parameter in the eddy viscosity filter function for the WAT radial velocity gradient of the wake deficit defining the transitional diameter fraction between the exponential and maximum regions [> WAT_k_Grad_DMin] or DEFAULT [DEFAULT=12.0] [-]
    REAL(ReKi)  :: WAT_k_Grad_Exp = 0.0_ReKi      !< Calibrated parameter in the eddy viscosity filter function for the WAT radial velocity gradient of the wake deficit defining the exponent in the exponential region [> 0.0] or DEFAULT [DEFAULT=0.65] [-]
  END TYPE WD_InputFileType
! =======================
! =========  WD_InitInputType  =======
  TYPE, PUBLIC :: WD_InitInputType
    TYPE(WD_InputFileType)  :: InputFileData      !< FAST.Farm input-file data for wake dynamics [-]
    INTEGER(IntKi)  :: TurbNum = 0      !< Turbine ID number (start with 1; end with number of turbines) [-]
    CHARACTER(1024)  :: OutFileRoot      !< The root name derived from the primary FAST.Farm input file [-]
  END TYPE WD_InitInputType
! =======================
! =========  WD_InitOutputType  =======
  TYPE, PUBLIC :: WD_InitOutputType
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputHdr      !< Names of the output-to-file channels [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputUnt      !< Units of the output-to-file channels [-]
    TYPE(ProgDesc)  :: Ver      !< This module's name, version, and date [-]
  END TYPE WD_InitOutputType
! =======================
! =========  WD_ContinuousStateType  =======
  TYPE, PUBLIC :: WD_ContinuousStateType
    REAL(ReKi)  :: DummyContState = 0.0_ReKi      !< Remove this variable if you have continuous states [-]
  END TYPE WD_ContinuousStateType
! =======================
! =========  WD_DiscreteStateType  =======
  TYPE, PUBLIC :: WD_DiscreteStateType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: xhat_plane      !< Orientations of wake planes, normal to wake planes [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: YawErr_filt      !< Time-filtered nacelle-yaw error at the wake planes [rad]
    REAL(ReKi)  :: psi_skew_filt = 0.0_ReKi      !< Time-filtered azimuth angle from skew vertical axis [rad]
    REAL(ReKi)  :: chi_skew_filt = 0.0_ReKi      !< Time-filtered inflow skew angle [rad]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: V_plane_filt      !< Time-filtered advection, deflection, and meandering velocity of wake planes [m/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: p_plane      !< Center positions of wake planes [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: x_plane      !< Downwind distance from rotor to each wake plane [m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Vx_wake      !< Axial wake velocity deficit at wake planes, distributed radially [m/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Vr_wake      !< Radial wake velocity deficit at wake planes, distributed radially [m/s]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Vx_wake2      !< Axial wake velocity deficit at wake planes, distributed radially [m/s]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Vy_wake2      !< Longitudinal wake velocity deficit at wake planes, distributed radially [m/s]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Vz_wake2      !< Vertical wake velocity deficit at wake planes, distributed radially [m/s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Vx_wind_disk_filt      !< Time-filtered rotor-disk-averaged ambient wind speed of wake planes, normal to planes [m/s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TI_amb_filt      !< Time-filtered ambient turbulence intensity of wind at wake planes [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: D_rotor_filt      !< Time-filtered rotor diameter associated with each wake plane [m]
    REAL(ReKi)  :: Vx_rel_disk_filt = 0.0_ReKi      !< Time-filtered rotor-disk-averaged relative wind speed (ambient + deficits + motion), normal to disk [m/s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Ct_azavg_filt      !< Time-filtered azimuthally averaged thrust force coefficient (normal to disk), distributed radially [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Cq_azavg_filt      !< Time-filtered azimuthally averaged torque coefficient (normal to disk), distributed radially [-]
  END TYPE WD_DiscreteStateType
! =======================
! =========  WD_ConstraintStateType  =======
  TYPE, PUBLIC :: WD_ConstraintStateType
    REAL(ReKi)  :: DummyConstrState = 0.0_ReKi      !< Remove this variable if you have constraint states [-]
  END TYPE WD_ConstraintStateType
! =======================
! =========  WD_OtherStateType  =======
  TYPE, PUBLIC :: WD_OtherStateType
    LOGICAL  :: firstPass = .false.      !< Flag indicating whether or not the states have been initialized with proper inputs [-]
  END TYPE WD_OtherStateType
! =======================
! =========  WD_MiscVarType  =======
  TYPE, PUBLIC :: WD_MiscVarType
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: dvtdr      !< Radial gradient of total eddy viscosity (nr) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: vt_tot      !< Polar total   eddy viscosity (nr,np) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: vt_amb      !< Polar ambient eddy viscosity (nr,np) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: vt_shr      !< Polar shear   eddy viscosity (nr,np) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: vt_tot2      !< Cartesian total   eddy viscosity (ny,nz,np) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: vt_amb2      !< Cartesian ambient eddy viscosity (ny,nz,np) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: vt_shr2      !< Cartesian shear   eddy viscosity (ny,nz,np) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: dvx_dy      !< Cartesian velocity gradient dVx/dy [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: dvx_dz      !< Cartesian velocity gradient dVx/dz [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: nu_dvx_dy      !< Product of total eddy viscosity and gradient [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: nu_dvx_dz      !< Product of total eddy viscosity and gradient [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: dnuvx_dy      !< Gradient of nu_dvx_dy wrt y [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: dnuvx_dz      !< Gradient of nu_dvx_dz wrt z [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: a      !<  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: b      !<  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: c      !<  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: d      !<  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: r_wake      !<  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Vx_high      !<  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Vx_polar      !< Vx as function of r for Cartesian implementation [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Vt_wake      !< Vr as function of r for Cartesian implementation [-]
    REAL(ReKi)  :: GammaCurl = 0.0_ReKi      !< Circulation used in Curled wake model [-]
    REAL(ReKi)  :: Ct_avg = 0.0_ReKi      !< Circulation used in Curled wake model [-]
  END TYPE WD_MiscVarType
! =======================
! =========  WD_ParameterType  =======
  TYPE, PUBLIC :: WD_ParameterType
    REAL(DbKi)  :: dt_low = 0.0_R8Ki      !< Time interval for wake dynamics calculations {or default} [s]
    INTEGER(IntKi)  :: NumPlanes = 0_IntKi      !< Number of wake planes [-]
    INTEGER(IntKi)  :: NumRadii = 0_IntKi      !< Number of radii in the radial finite-difference grid [-]
    REAL(ReKi)  :: dr = 0.0_ReKi      !< Radial increment of radial finite-difference grid [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: r      !< Discretization of radial finite-difference grid [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: y      !< Horizontal discretization of each wake plane (size ny=2nr-1) [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: z      !< Nomically-vertical discretization of each wake plane (size nz=2nr-1) [m]
    INTEGER(IntKi)  :: Mod_Wake = 0_IntKi      !< Switch between wake formulations 1=Polar, 2=Curl, 3=Cartesian [-]
    LOGICAL  :: Swirl = .false.      !< Switch to add swirl [only used if Mod_Wake=2 or 2] [-]
    REAL(ReKi)  :: k_VortexDecay = 0.0_ReKi      !< Vortex decay constant for curl [-]
    REAL(ReKi)  :: sigma_D = 0.0_ReKi      !< The width of the Gaussian vortices used for the curled wake model divided by diameter [-]
    INTEGER(IntKi)  :: NumVortices = 0_IntKi      !< The number of vortices used for the curled wake model [-]
    REAL(ReKi)  :: filtParam = 0.0_ReKi      !< Low-pass time-filter parameter, with a value between 0 (minimum filtering) and 1 (maximum filtering) (exclusive) [-]
    REAL(ReKi)  :: oneMinusFiltParam = 0.0_ReKi      !< 1.0 - filtParam [-]
    REAL(ReKi)  :: C_HWkDfl_O = 0.0_ReKi      !< Calibrated parameter in the correction for wake deflection defining the horizontal offset at the rotor [m]
    REAL(ReKi)  :: C_HWkDfl_OY = 0.0_ReKi      !< Calibrated parameter in the correction for wake deflection defining the horizontal offset at the rotor scaled with yaw error [m/rad]
    REAL(ReKi)  :: C_HWkDfl_x = 0.0_ReKi      !< Calibrated parameter in the correction for wake deflection defining the horizontal offset scaled with downstream distance [-]
    REAL(ReKi)  :: C_HWkDfl_xY = 0.0_ReKi      !< Calibrated parameter in the correction for wake deflection defining the horizontal offset scaled with downstream distance and yaw error [1/rad]
    REAL(ReKi)  :: C_NearWake = 0.0_ReKi      !< Calibrated parameter for near-wake correction [-]
    REAL(ReKi)  :: k_vAmb = 0.0_ReKi      !< Calibrated parameter for the influence of ambient turbulence in the eddy viscosity [-]
    REAL(ReKi)  :: C_vAmb_DMin = 0.0_ReKi      !< Calibrated parameter in the eddy viscosity filter function for ambient turbulence defining the transitional diameter fraction between the minimum and exponential regions [-]
    REAL(ReKi)  :: C_vAmb_DMax = 0.0_ReKi      !< Calibrated parameter in the eddy viscosity filter function for ambient turbulence defining the transitional diameter fraction between the exponential and maximum regions [-]
    REAL(ReKi)  :: C_vAmb_FMin = 0.0_ReKi      !< Calibrated parameter in the eddy viscosity filter function for ambient turbulence defining the functional value in the minimum region [-]
    REAL(ReKi)  :: C_vAmb_Exp = 0.0_ReKi      !< Calibrated parameter in the eddy viscosity filter function for ambient turbulence defining the exponent in the exponential region [-]
    REAL(ReKi)  :: k_vShr = 0.0_ReKi      !< Calibrated parameter for the influence of the shear layer in the eddy viscosity [-]
    REAL(ReKi)  :: C_vShr_DMin = 0.0_ReKi      !< Calibrated parameter in the eddy viscosity filter function for the shear layer defining the transitional diameter fraction between the minimum and exponential regions [-]
    REAL(ReKi)  :: C_vShr_DMax = 0.0_ReKi      !< Calibrated parameter in the eddy viscosity filter function for the shear layer defining the transitional diameter fraction between the exponential and maximum regions [-]
    REAL(ReKi)  :: C_vShr_FMin = 0.0_ReKi      !< Calibrated parameter in the eddy viscosity filter function for the shear layer defining the functional value in the minimum region [-]
    REAL(ReKi)  :: C_vShr_Exp = 0.0_ReKi      !< Calibrated parameter in the eddy viscosity filter function for the shear layer defining the exponent in the exponential region [-]
    INTEGER(IntKi)  :: Mod_WakeDiam = 0_IntKi      !< Wake diameter calculation model [-]
    REAL(ReKi)  :: C_WakeDiam = 0.0_ReKi      !< Calibrated parameter for wake diameter calculation [-]
    INTEGER(IntKi)  :: FilterInit = 0_IntKi      !< Switch to filter the initial wake plane deficit and select the number of grid points for the filter {0: no filter, 1: filter of size 1} or DEFAULT [DEFAULT=0: if Mod_Wake is 1 or 3, or DEFAULT=2: if Mod_Wwake is 2] (switch) [-]
    REAL(ReKi)  :: k_vCurl = 0.0_ReKi      !< Calibrated parameter for the eddy viscosity in curled-wake model [>=0.0] [-]
    LOGICAL  :: OutAllPlanes = .false.      !< Output all planes [-]
    CHARACTER(1024)  :: OutFileRoot      !< The root name derived from the primary FAST.Farm input file [-]
    CHARACTER(1024)  :: OutFileVTKDir      !< The parent directory for all VTK files written by WD [-]
    INTEGER(IntKi)  :: TurbNum = 0      !< Turbine ID number (start with 1; end with number of turbines) [-]
    LOGICAL  :: WAT = .false.      !< Switch for turning on and off wake-added turbulence [-]
    REAL(ReKi)  :: WAT_k_Def_k_c = 0.0_ReKi      !< Calibrated parameter for the influence of the maximum wake deficit on wake-added turblence (-) [>=0] or DEFAULT [DEFAULT=0.6] [-]
    REAL(ReKi)  :: WAT_k_Def_FMin = 0.0_ReKi      !< Calibrated parameter in the eddy viscosity filter function for the WAT maximum wake deficit defining the value in the minimum region [>=0.0 and <=1.0] or DEFAULT [DEFAULT=0.0] [-]
    REAL(ReKi)  :: WAT_k_Def_DMin = 0.0_ReKi      !< Calibrated parameter in the eddy viscosity filter function for the WAT maximum wake deficit defining the transitional diameter fraction between the minimum and exponential regions [>=0.0] or DEFAULT [DEFAULT=0.0] [-]
    REAL(ReKi)  :: WAT_k_Def_DMax = 0.0_ReKi      !< Calibrated parameter in the eddy viscosity filter function for the WAT maximum wake deficit defining the transitional diameter fraction between the exponential and maximum regions [> WAT_k_Def_DMin] or DEFAULT [DEFAULT=2.0] [-]
    REAL(ReKi)  :: WAT_k_Def_Exp = 0.0_ReKi      !< Calibrated parameter in the eddy viscosity filter function for the WAT maximum wake deficit defining the exponent in the exponential region [> 0.0] or DEFAULT [DEFAULT=1.0] [-]
    REAL(ReKi)  :: WAT_k_Grad_k_c = 0.0_ReKi      !< Calibrated parameter for the influence of the radial velocity gradient of the wake deficit on wake-added turblence (-) [>=0] or DEFAULT [DEFAULT=3.0] [-]
    REAL(ReKi)  :: WAT_k_Grad_FMin = 0.0_ReKi      !< Calibrated parameter in the eddy viscosity filter function for the WAT radial velocity gradient of the wake deficit defining the value in the minimum region [>=0.0 and <=1.0] or DEFAULT [DEFAULT=0.0] [-]
    REAL(ReKi)  :: WAT_k_Grad_DMin = 0.0_ReKi      !< Calibrated parameter in the eddy viscosity filter function for the WAT radial velocity gradient of the wake deficit defining the transitional diameter fraction between the minimum and exponential regions [>=0.0] or DEFAULT [DEFAULT=0.0] [-]
    REAL(ReKi)  :: WAT_k_Grad_DMax = 0.0_ReKi      !< Calibrated parameter in the eddy viscosity filter function for the WAT radial velocity gradient of the wake deficit defining the transitional diameter fraction between the exponential and maximum regions [> WAT_k_Grad_DMin] or DEFAULT [DEFAULT=12.0] [-]
    REAL(ReKi)  :: WAT_k_Grad_Exp = 0.0_ReKi      !< Calibrated parameter in the eddy viscosity filter function for the WAT radial velocity gradient of the wake deficit defining the exponent in the exponential region [> 0.0] or DEFAULT [DEFAULT=0.65] [-]
  END TYPE WD_ParameterType
! =======================
! =========  WD_InputType  =======
  TYPE, PUBLIC :: WD_InputType
    REAL(ReKi) , DIMENSION(1:3)  :: xhat_disk = 0.0_ReKi      !< Orientation of rotor centerline, normal to disk [-]
    REAL(ReKi)  :: YawErr = 0.0_ReKi      !< Nacelle-yaw error at the wake planes [rad]
    REAL(ReKi)  :: psi_skew = 0.0_ReKi      !< Azimuth angle from the nominally vertical axis in the disk plane to the vector about which the inflow skew angle is defined [rad]
    REAL(ReKi)  :: chi_skew = 0.0_ReKi      !< Inflow skew angle [rad]
    REAL(ReKi) , DIMENSION(1:3)  :: p_hub = 0.0_ReKi      !< Center position of hub [m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: V_plane      !< Advection, deflection, and meandering velocity of wake planes [m/s]
    REAL(ReKi)  :: Vx_wind_disk = 0.0_ReKi      !< Rotor-disk-averaged ambient wind speed, normal to planes [m/s]
    REAL(ReKi)  :: TI_amb = 0.0_ReKi      !< Ambient turbulence intensity of wind at rotor disk [-]
    REAL(ReKi)  :: D_rotor = 0.0_ReKi      !< Rotor diameter [m]
    REAL(ReKi)  :: Vx_rel_disk = 0.0_ReKi      !< Rotor-disk-averaged relative wind speed (ambient + deficits + motion), normal to disk [m/s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Ct_azavg      !< Azimuthally averaged thrust force coefficient (normal to disk), distributed radially [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Cq_azavg      !< Azimuthally averaged torque coefficient (normal to disk), distributed radially [-]
  END TYPE WD_InputType
! =======================
! =========  WD_OutputType  =======
  TYPE, PUBLIC :: WD_OutputType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: xhat_plane      !< Orientations of wake planes, normal to wake planes [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: p_plane      !< Center positions of wake planes [m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Vx_wake      !< Axial wake velocity deficit at wake planes, distributed radially [m/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Vr_wake      !< Radial wake velocity deficit at wake planes, distributed radially [m/s]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Vx_wake2      !< Axial wake velocity deficit at wake planes, distributed across the plane [m/s]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Vy_wake2      !< Transverse horizontal wake velocity deficit at wake planes, distributed across the plane [m/s]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Vz_wake2      !< Transverse nominally vertical wake velocity deficit at wake planes, distributed across the plane [m/s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: D_wake      !< Wake diameters at wake planes [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: x_plane      !< Downwind distance from rotor to each wake plane [m]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: WAT_k      !< Scaling factor k_mt(iP,y,z) for wake-added turbulence [-]
  END TYPE WD_OutputType
! =======================
CONTAINS

subroutine WD_CopyInputFileType(SrcInputFileTypeData, DstInputFileTypeData, CtrlCode, ErrStat, ErrMsg)
   type(WD_InputFileType), intent(in) :: SrcInputFileTypeData
   type(WD_InputFileType), intent(inout) :: DstInputFileTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'WD_CopyInputFileType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInputFileTypeData%dr = SrcInputFileTypeData%dr
   DstInputFileTypeData%NumRadii = SrcInputFileTypeData%NumRadii
   DstInputFileTypeData%NumPlanes = SrcInputFileTypeData%NumPlanes
   DstInputFileTypeData%Mod_Wake = SrcInputFileTypeData%Mod_Wake
   DstInputFileTypeData%f_c = SrcInputFileTypeData%f_c
   DstInputFileTypeData%C_HWkDfl_O = SrcInputFileTypeData%C_HWkDfl_O
   DstInputFileTypeData%C_HWkDfl_OY = SrcInputFileTypeData%C_HWkDfl_OY
   DstInputFileTypeData%C_HWkDfl_x = SrcInputFileTypeData%C_HWkDfl_x
   DstInputFileTypeData%C_HWkDfl_xY = SrcInputFileTypeData%C_HWkDfl_xY
   DstInputFileTypeData%C_NearWake = SrcInputFileTypeData%C_NearWake
   DstInputFileTypeData%k_vAmb = SrcInputFileTypeData%k_vAmb
   DstInputFileTypeData%C_vAmb_FMin = SrcInputFileTypeData%C_vAmb_FMin
   DstInputFileTypeData%C_vAmb_DMin = SrcInputFileTypeData%C_vAmb_DMin
   DstInputFileTypeData%C_vAmb_DMax = SrcInputFileTypeData%C_vAmb_DMax
   DstInputFileTypeData%C_vAmb_Exp = SrcInputFileTypeData%C_vAmb_Exp
   DstInputFileTypeData%k_vShr = SrcInputFileTypeData%k_vShr
   DstInputFileTypeData%C_vShr_FMin = SrcInputFileTypeData%C_vShr_FMin
   DstInputFileTypeData%C_vShr_DMin = SrcInputFileTypeData%C_vShr_DMin
   DstInputFileTypeData%C_vShr_DMax = SrcInputFileTypeData%C_vShr_DMax
   DstInputFileTypeData%C_vShr_Exp = SrcInputFileTypeData%C_vShr_Exp
   DstInputFileTypeData%Mod_WakeDiam = SrcInputFileTypeData%Mod_WakeDiam
   DstInputFileTypeData%C_WakeDiam = SrcInputFileTypeData%C_WakeDiam
   DstInputFileTypeData%Swirl = SrcInputFileTypeData%Swirl
   DstInputFileTypeData%k_VortexDecay = SrcInputFileTypeData%k_VortexDecay
   DstInputFileTypeData%sigma_D = SrcInputFileTypeData%sigma_D
   DstInputFileTypeData%NumVortices = SrcInputFileTypeData%NumVortices
   DstInputFileTypeData%FilterInit = SrcInputFileTypeData%FilterInit
   DstInputFileTypeData%k_vCurl = SrcInputFileTypeData%k_vCurl
   DstInputFileTypeData%OutAllPlanes = SrcInputFileTypeData%OutAllPlanes
   DstInputFileTypeData%WAT = SrcInputFileTypeData%WAT
   DstInputFileTypeData%WAT_k_Def_k_c = SrcInputFileTypeData%WAT_k_Def_k_c
   DstInputFileTypeData%WAT_k_Def_FMin = SrcInputFileTypeData%WAT_k_Def_FMin
   DstInputFileTypeData%WAT_k_Def_DMin = SrcInputFileTypeData%WAT_k_Def_DMin
   DstInputFileTypeData%WAT_k_Def_DMax = SrcInputFileTypeData%WAT_k_Def_DMax
   DstInputFileTypeData%WAT_k_Def_Exp = SrcInputFileTypeData%WAT_k_Def_Exp
   DstInputFileTypeData%WAT_k_Grad_k_c = SrcInputFileTypeData%WAT_k_Grad_k_c
   DstInputFileTypeData%WAT_k_Grad_FMin = SrcInputFileTypeData%WAT_k_Grad_FMin
   DstInputFileTypeData%WAT_k_Grad_DMin = SrcInputFileTypeData%WAT_k_Grad_DMin
   DstInputFileTypeData%WAT_k_Grad_DMax = SrcInputFileTypeData%WAT_k_Grad_DMax
   DstInputFileTypeData%WAT_k_Grad_Exp = SrcInputFileTypeData%WAT_k_Grad_Exp
end subroutine

subroutine WD_DestroyInputFileType(InputFileTypeData, ErrStat, ErrMsg)
   type(WD_InputFileType), intent(inout) :: InputFileTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'WD_DestroyInputFileType'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine WD_PackInputFileType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(WD_InputFileType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'WD_PackInputFileType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%dr)
   call RegPack(RF, InData%NumRadii)
   call RegPack(RF, InData%NumPlanes)
   call RegPack(RF, InData%Mod_Wake)
   call RegPack(RF, InData%f_c)
   call RegPack(RF, InData%C_HWkDfl_O)
   call RegPack(RF, InData%C_HWkDfl_OY)
   call RegPack(RF, InData%C_HWkDfl_x)
   call RegPack(RF, InData%C_HWkDfl_xY)
   call RegPack(RF, InData%C_NearWake)
   call RegPack(RF, InData%k_vAmb)
   call RegPack(RF, InData%C_vAmb_FMin)
   call RegPack(RF, InData%C_vAmb_DMin)
   call RegPack(RF, InData%C_vAmb_DMax)
   call RegPack(RF, InData%C_vAmb_Exp)
   call RegPack(RF, InData%k_vShr)
   call RegPack(RF, InData%C_vShr_FMin)
   call RegPack(RF, InData%C_vShr_DMin)
   call RegPack(RF, InData%C_vShr_DMax)
   call RegPack(RF, InData%C_vShr_Exp)
   call RegPack(RF, InData%Mod_WakeDiam)
   call RegPack(RF, InData%C_WakeDiam)
   call RegPack(RF, InData%Swirl)
   call RegPack(RF, InData%k_VortexDecay)
   call RegPack(RF, InData%sigma_D)
   call RegPack(RF, InData%NumVortices)
   call RegPack(RF, InData%FilterInit)
   call RegPack(RF, InData%k_vCurl)
   call RegPack(RF, InData%OutAllPlanes)
   call RegPack(RF, InData%WAT)
   call RegPack(RF, InData%WAT_k_Def_k_c)
   call RegPack(RF, InData%WAT_k_Def_FMin)
   call RegPack(RF, InData%WAT_k_Def_DMin)
   call RegPack(RF, InData%WAT_k_Def_DMax)
   call RegPack(RF, InData%WAT_k_Def_Exp)
   call RegPack(RF, InData%WAT_k_Grad_k_c)
   call RegPack(RF, InData%WAT_k_Grad_FMin)
   call RegPack(RF, InData%WAT_k_Grad_DMin)
   call RegPack(RF, InData%WAT_k_Grad_DMax)
   call RegPack(RF, InData%WAT_k_Grad_Exp)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine WD_UnPackInputFileType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(WD_InputFileType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'WD_UnPackInputFileType'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%dr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumRadii); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumPlanes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Mod_Wake); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%f_c); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_HWkDfl_O); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_HWkDfl_OY); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_HWkDfl_x); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_HWkDfl_xY); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_NearWake); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k_vAmb); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_vAmb_FMin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_vAmb_DMin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_vAmb_DMax); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_vAmb_Exp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k_vShr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_vShr_FMin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_vShr_DMin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_vShr_DMax); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_vShr_Exp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Mod_WakeDiam); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_WakeDiam); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Swirl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k_VortexDecay); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%sigma_D); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumVortices); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FilterInit); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k_vCurl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutAllPlanes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WAT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WAT_k_Def_k_c); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WAT_k_Def_FMin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WAT_k_Def_DMin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WAT_k_Def_DMax); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WAT_k_Def_Exp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WAT_k_Grad_k_c); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WAT_k_Grad_FMin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WAT_k_Grad_DMin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WAT_k_Grad_DMax); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WAT_k_Grad_Exp); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine WD_CopyInitInput(SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg)
   type(WD_InitInputType), intent(in) :: SrcInitInputData
   type(WD_InitInputType), intent(inout) :: DstInitInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'WD_CopyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call WD_CopyInputFileType(SrcInitInputData%InputFileData, DstInitInputData%InputFileData, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstInitInputData%TurbNum = SrcInitInputData%TurbNum
   DstInitInputData%OutFileRoot = SrcInitInputData%OutFileRoot
end subroutine

subroutine WD_DestroyInitInput(InitInputData, ErrStat, ErrMsg)
   type(WD_InitInputType), intent(inout) :: InitInputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'WD_DestroyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call WD_DestroyInputFileType(InitInputData%InputFileData, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine WD_PackInitInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(WD_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'WD_PackInitInput'
   if (RF%ErrStat >= AbortErrLev) return
   call WD_PackInputFileType(RF, InData%InputFileData) 
   call RegPack(RF, InData%TurbNum)
   call RegPack(RF, InData%OutFileRoot)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine WD_UnPackInitInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(WD_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'WD_UnPackInitInput'
   if (RF%ErrStat /= ErrID_None) return
   call WD_UnpackInputFileType(RF, OutData%InputFileData) ! InputFileData 
   call RegUnpack(RF, OutData%TurbNum); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutFileRoot); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine WD_CopyInitOutput(SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg)
   type(WD_InitOutputType), intent(in) :: SrcInitOutputData
   type(WD_InitOutputType), intent(inout) :: DstInitOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'WD_CopyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcInitOutputData%WriteOutputHdr)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputHdr)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputHdr)
      if (.not. allocated(DstInitOutputData%WriteOutputHdr)) then
         allocate(DstInitOutputData%WriteOutputHdr(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputHdr.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputHdr = SrcInitOutputData%WriteOutputHdr
   end if
   if (allocated(SrcInitOutputData%WriteOutputUnt)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputUnt)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputUnt)
      if (.not. allocated(DstInitOutputData%WriteOutputUnt)) then
         allocate(DstInitOutputData%WriteOutputUnt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputUnt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputUnt = SrcInitOutputData%WriteOutputUnt
   end if
   call NWTC_Library_CopyProgDesc(SrcInitOutputData%Ver, DstInitOutputData%Ver, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine WD_DestroyInitOutput(InitOutputData, ErrStat, ErrMsg)
   type(WD_InitOutputType), intent(inout) :: InitOutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'WD_DestroyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InitOutputData%WriteOutputHdr)) then
      deallocate(InitOutputData%WriteOutputHdr)
   end if
   if (allocated(InitOutputData%WriteOutputUnt)) then
      deallocate(InitOutputData%WriteOutputUnt)
   end if
   call NWTC_Library_DestroyProgDesc(InitOutputData%Ver, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine WD_PackInitOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(WD_InitOutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'WD_PackInitOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%WriteOutputHdr)
   call RegPackAlloc(RF, InData%WriteOutputUnt)
   call NWTC_Library_PackProgDesc(RF, InData%Ver) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine WD_UnPackInitOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(WD_InitOutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'WD_UnPackInitOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%WriteOutputHdr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutputUnt); if (RegCheckErr(RF, RoutineName)) return
   call NWTC_Library_UnpackProgDesc(RF, OutData%Ver) ! Ver 
end subroutine

subroutine WD_CopyContState(SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg)
   type(WD_ContinuousStateType), intent(in) :: SrcContStateData
   type(WD_ContinuousStateType), intent(inout) :: DstContStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'WD_CopyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstContStateData%DummyContState = SrcContStateData%DummyContState
end subroutine

subroutine WD_DestroyContState(ContStateData, ErrStat, ErrMsg)
   type(WD_ContinuousStateType), intent(inout) :: ContStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'WD_DestroyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine WD_PackContState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(WD_ContinuousStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'WD_PackContState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyContState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine WD_UnPackContState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(WD_ContinuousStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'WD_UnPackContState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyContState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine WD_CopyDiscState(SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg)
   type(WD_DiscreteStateType), intent(in) :: SrcDiscStateData
   type(WD_DiscreteStateType), intent(inout) :: DstDiscStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'WD_CopyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcDiscStateData%xhat_plane)) then
      LB(1:2) = lbound(SrcDiscStateData%xhat_plane)
      UB(1:2) = ubound(SrcDiscStateData%xhat_plane)
      if (.not. allocated(DstDiscStateData%xhat_plane)) then
         allocate(DstDiscStateData%xhat_plane(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%xhat_plane.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%xhat_plane = SrcDiscStateData%xhat_plane
   end if
   if (allocated(SrcDiscStateData%YawErr_filt)) then
      LB(1:1) = lbound(SrcDiscStateData%YawErr_filt)
      UB(1:1) = ubound(SrcDiscStateData%YawErr_filt)
      if (.not. allocated(DstDiscStateData%YawErr_filt)) then
         allocate(DstDiscStateData%YawErr_filt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%YawErr_filt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%YawErr_filt = SrcDiscStateData%YawErr_filt
   end if
   DstDiscStateData%psi_skew_filt = SrcDiscStateData%psi_skew_filt
   DstDiscStateData%chi_skew_filt = SrcDiscStateData%chi_skew_filt
   if (allocated(SrcDiscStateData%V_plane_filt)) then
      LB(1:2) = lbound(SrcDiscStateData%V_plane_filt)
      UB(1:2) = ubound(SrcDiscStateData%V_plane_filt)
      if (.not. allocated(DstDiscStateData%V_plane_filt)) then
         allocate(DstDiscStateData%V_plane_filt(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%V_plane_filt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%V_plane_filt = SrcDiscStateData%V_plane_filt
   end if
   if (allocated(SrcDiscStateData%p_plane)) then
      LB(1:2) = lbound(SrcDiscStateData%p_plane)
      UB(1:2) = ubound(SrcDiscStateData%p_plane)
      if (.not. allocated(DstDiscStateData%p_plane)) then
         allocate(DstDiscStateData%p_plane(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%p_plane.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%p_plane = SrcDiscStateData%p_plane
   end if
   if (allocated(SrcDiscStateData%x_plane)) then
      LB(1:1) = lbound(SrcDiscStateData%x_plane)
      UB(1:1) = ubound(SrcDiscStateData%x_plane)
      if (.not. allocated(DstDiscStateData%x_plane)) then
         allocate(DstDiscStateData%x_plane(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%x_plane.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%x_plane = SrcDiscStateData%x_plane
   end if
   if (allocated(SrcDiscStateData%Vx_wake)) then
      LB(1:2) = lbound(SrcDiscStateData%Vx_wake)
      UB(1:2) = ubound(SrcDiscStateData%Vx_wake)
      if (.not. allocated(DstDiscStateData%Vx_wake)) then
         allocate(DstDiscStateData%Vx_wake(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%Vx_wake.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%Vx_wake = SrcDiscStateData%Vx_wake
   end if
   if (allocated(SrcDiscStateData%Vr_wake)) then
      LB(1:2) = lbound(SrcDiscStateData%Vr_wake)
      UB(1:2) = ubound(SrcDiscStateData%Vr_wake)
      if (.not. allocated(DstDiscStateData%Vr_wake)) then
         allocate(DstDiscStateData%Vr_wake(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%Vr_wake.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%Vr_wake = SrcDiscStateData%Vr_wake
   end if
   if (allocated(SrcDiscStateData%Vx_wake2)) then
      LB(1:3) = lbound(SrcDiscStateData%Vx_wake2)
      UB(1:3) = ubound(SrcDiscStateData%Vx_wake2)
      if (.not. allocated(DstDiscStateData%Vx_wake2)) then
         allocate(DstDiscStateData%Vx_wake2(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%Vx_wake2.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%Vx_wake2 = SrcDiscStateData%Vx_wake2
   end if
   if (allocated(SrcDiscStateData%Vy_wake2)) then
      LB(1:3) = lbound(SrcDiscStateData%Vy_wake2)
      UB(1:3) = ubound(SrcDiscStateData%Vy_wake2)
      if (.not. allocated(DstDiscStateData%Vy_wake2)) then
         allocate(DstDiscStateData%Vy_wake2(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%Vy_wake2.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%Vy_wake2 = SrcDiscStateData%Vy_wake2
   end if
   if (allocated(SrcDiscStateData%Vz_wake2)) then
      LB(1:3) = lbound(SrcDiscStateData%Vz_wake2)
      UB(1:3) = ubound(SrcDiscStateData%Vz_wake2)
      if (.not. allocated(DstDiscStateData%Vz_wake2)) then
         allocate(DstDiscStateData%Vz_wake2(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%Vz_wake2.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%Vz_wake2 = SrcDiscStateData%Vz_wake2
   end if
   if (allocated(SrcDiscStateData%Vx_wind_disk_filt)) then
      LB(1:1) = lbound(SrcDiscStateData%Vx_wind_disk_filt)
      UB(1:1) = ubound(SrcDiscStateData%Vx_wind_disk_filt)
      if (.not. allocated(DstDiscStateData%Vx_wind_disk_filt)) then
         allocate(DstDiscStateData%Vx_wind_disk_filt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%Vx_wind_disk_filt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%Vx_wind_disk_filt = SrcDiscStateData%Vx_wind_disk_filt
   end if
   if (allocated(SrcDiscStateData%TI_amb_filt)) then
      LB(1:1) = lbound(SrcDiscStateData%TI_amb_filt)
      UB(1:1) = ubound(SrcDiscStateData%TI_amb_filt)
      if (.not. allocated(DstDiscStateData%TI_amb_filt)) then
         allocate(DstDiscStateData%TI_amb_filt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%TI_amb_filt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%TI_amb_filt = SrcDiscStateData%TI_amb_filt
   end if
   if (allocated(SrcDiscStateData%D_rotor_filt)) then
      LB(1:1) = lbound(SrcDiscStateData%D_rotor_filt)
      UB(1:1) = ubound(SrcDiscStateData%D_rotor_filt)
      if (.not. allocated(DstDiscStateData%D_rotor_filt)) then
         allocate(DstDiscStateData%D_rotor_filt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%D_rotor_filt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%D_rotor_filt = SrcDiscStateData%D_rotor_filt
   end if
   DstDiscStateData%Vx_rel_disk_filt = SrcDiscStateData%Vx_rel_disk_filt
   if (allocated(SrcDiscStateData%Ct_azavg_filt)) then
      LB(1:1) = lbound(SrcDiscStateData%Ct_azavg_filt)
      UB(1:1) = ubound(SrcDiscStateData%Ct_azavg_filt)
      if (.not. allocated(DstDiscStateData%Ct_azavg_filt)) then
         allocate(DstDiscStateData%Ct_azavg_filt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%Ct_azavg_filt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%Ct_azavg_filt = SrcDiscStateData%Ct_azavg_filt
   end if
   if (allocated(SrcDiscStateData%Cq_azavg_filt)) then
      LB(1:1) = lbound(SrcDiscStateData%Cq_azavg_filt)
      UB(1:1) = ubound(SrcDiscStateData%Cq_azavg_filt)
      if (.not. allocated(DstDiscStateData%Cq_azavg_filt)) then
         allocate(DstDiscStateData%Cq_azavg_filt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%Cq_azavg_filt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%Cq_azavg_filt = SrcDiscStateData%Cq_azavg_filt
   end if
end subroutine

subroutine WD_DestroyDiscState(DiscStateData, ErrStat, ErrMsg)
   type(WD_DiscreteStateType), intent(inout) :: DiscStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'WD_DestroyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(DiscStateData%xhat_plane)) then
      deallocate(DiscStateData%xhat_plane)
   end if
   if (allocated(DiscStateData%YawErr_filt)) then
      deallocate(DiscStateData%YawErr_filt)
   end if
   if (allocated(DiscStateData%V_plane_filt)) then
      deallocate(DiscStateData%V_plane_filt)
   end if
   if (allocated(DiscStateData%p_plane)) then
      deallocate(DiscStateData%p_plane)
   end if
   if (allocated(DiscStateData%x_plane)) then
      deallocate(DiscStateData%x_plane)
   end if
   if (allocated(DiscStateData%Vx_wake)) then
      deallocate(DiscStateData%Vx_wake)
   end if
   if (allocated(DiscStateData%Vr_wake)) then
      deallocate(DiscStateData%Vr_wake)
   end if
   if (allocated(DiscStateData%Vx_wake2)) then
      deallocate(DiscStateData%Vx_wake2)
   end if
   if (allocated(DiscStateData%Vy_wake2)) then
      deallocate(DiscStateData%Vy_wake2)
   end if
   if (allocated(DiscStateData%Vz_wake2)) then
      deallocate(DiscStateData%Vz_wake2)
   end if
   if (allocated(DiscStateData%Vx_wind_disk_filt)) then
      deallocate(DiscStateData%Vx_wind_disk_filt)
   end if
   if (allocated(DiscStateData%TI_amb_filt)) then
      deallocate(DiscStateData%TI_amb_filt)
   end if
   if (allocated(DiscStateData%D_rotor_filt)) then
      deallocate(DiscStateData%D_rotor_filt)
   end if
   if (allocated(DiscStateData%Ct_azavg_filt)) then
      deallocate(DiscStateData%Ct_azavg_filt)
   end if
   if (allocated(DiscStateData%Cq_azavg_filt)) then
      deallocate(DiscStateData%Cq_azavg_filt)
   end if
end subroutine

subroutine WD_PackDiscState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(WD_DiscreteStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'WD_PackDiscState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%xhat_plane)
   call RegPackAlloc(RF, InData%YawErr_filt)
   call RegPack(RF, InData%psi_skew_filt)
   call RegPack(RF, InData%chi_skew_filt)
   call RegPackAlloc(RF, InData%V_plane_filt)
   call RegPackAlloc(RF, InData%p_plane)
   call RegPackAlloc(RF, InData%x_plane)
   call RegPackAlloc(RF, InData%Vx_wake)
   call RegPackAlloc(RF, InData%Vr_wake)
   call RegPackAlloc(RF, InData%Vx_wake2)
   call RegPackAlloc(RF, InData%Vy_wake2)
   call RegPackAlloc(RF, InData%Vz_wake2)
   call RegPackAlloc(RF, InData%Vx_wind_disk_filt)
   call RegPackAlloc(RF, InData%TI_amb_filt)
   call RegPackAlloc(RF, InData%D_rotor_filt)
   call RegPack(RF, InData%Vx_rel_disk_filt)
   call RegPackAlloc(RF, InData%Ct_azavg_filt)
   call RegPackAlloc(RF, InData%Cq_azavg_filt)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine WD_UnPackDiscState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(WD_DiscreteStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'WD_UnPackDiscState'
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%xhat_plane); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%YawErr_filt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%psi_skew_filt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%chi_skew_filt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%V_plane_filt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%p_plane); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%x_plane); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Vx_wake); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Vr_wake); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Vx_wake2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Vy_wake2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Vz_wake2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Vx_wind_disk_filt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TI_amb_filt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%D_rotor_filt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Vx_rel_disk_filt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Ct_azavg_filt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Cq_azavg_filt); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine WD_CopyConstrState(SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg)
   type(WD_ConstraintStateType), intent(in) :: SrcConstrStateData
   type(WD_ConstraintStateType), intent(inout) :: DstConstrStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'WD_CopyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstConstrStateData%DummyConstrState = SrcConstrStateData%DummyConstrState
end subroutine

subroutine WD_DestroyConstrState(ConstrStateData, ErrStat, ErrMsg)
   type(WD_ConstraintStateType), intent(inout) :: ConstrStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'WD_DestroyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine WD_PackConstrState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(WD_ConstraintStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'WD_PackConstrState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyConstrState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine WD_UnPackConstrState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(WD_ConstraintStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'WD_UnPackConstrState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyConstrState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine WD_CopyOtherState(SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg)
   type(WD_OtherStateType), intent(in) :: SrcOtherStateData
   type(WD_OtherStateType), intent(inout) :: DstOtherStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'WD_CopyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstOtherStateData%firstPass = SrcOtherStateData%firstPass
end subroutine

subroutine WD_DestroyOtherState(OtherStateData, ErrStat, ErrMsg)
   type(WD_OtherStateType), intent(inout) :: OtherStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'WD_DestroyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine WD_PackOtherState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(WD_OtherStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'WD_PackOtherState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%firstPass)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine WD_UnPackOtherState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(WD_OtherStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'WD_UnPackOtherState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%firstPass); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine WD_CopyMisc(SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg)
   type(WD_MiscVarType), intent(in) :: SrcMiscData
   type(WD_MiscVarType), intent(inout) :: DstMiscData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'WD_CopyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcMiscData%dvtdr)) then
      LB(1:1) = lbound(SrcMiscData%dvtdr)
      UB(1:1) = ubound(SrcMiscData%dvtdr)
      if (.not. allocated(DstMiscData%dvtdr)) then
         allocate(DstMiscData%dvtdr(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%dvtdr.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%dvtdr = SrcMiscData%dvtdr
   end if
   if (allocated(SrcMiscData%vt_tot)) then
      LB(1:2) = lbound(SrcMiscData%vt_tot)
      UB(1:2) = ubound(SrcMiscData%vt_tot)
      if (.not. allocated(DstMiscData%vt_tot)) then
         allocate(DstMiscData%vt_tot(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%vt_tot.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%vt_tot = SrcMiscData%vt_tot
   end if
   if (allocated(SrcMiscData%vt_amb)) then
      LB(1:2) = lbound(SrcMiscData%vt_amb)
      UB(1:2) = ubound(SrcMiscData%vt_amb)
      if (.not. allocated(DstMiscData%vt_amb)) then
         allocate(DstMiscData%vt_amb(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%vt_amb.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%vt_amb = SrcMiscData%vt_amb
   end if
   if (allocated(SrcMiscData%vt_shr)) then
      LB(1:2) = lbound(SrcMiscData%vt_shr)
      UB(1:2) = ubound(SrcMiscData%vt_shr)
      if (.not. allocated(DstMiscData%vt_shr)) then
         allocate(DstMiscData%vt_shr(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%vt_shr.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%vt_shr = SrcMiscData%vt_shr
   end if
   if (allocated(SrcMiscData%vt_tot2)) then
      LB(1:3) = lbound(SrcMiscData%vt_tot2)
      UB(1:3) = ubound(SrcMiscData%vt_tot2)
      if (.not. allocated(DstMiscData%vt_tot2)) then
         allocate(DstMiscData%vt_tot2(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%vt_tot2.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%vt_tot2 = SrcMiscData%vt_tot2
   end if
   if (allocated(SrcMiscData%vt_amb2)) then
      LB(1:3) = lbound(SrcMiscData%vt_amb2)
      UB(1:3) = ubound(SrcMiscData%vt_amb2)
      if (.not. allocated(DstMiscData%vt_amb2)) then
         allocate(DstMiscData%vt_amb2(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%vt_amb2.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%vt_amb2 = SrcMiscData%vt_amb2
   end if
   if (allocated(SrcMiscData%vt_shr2)) then
      LB(1:3) = lbound(SrcMiscData%vt_shr2)
      UB(1:3) = ubound(SrcMiscData%vt_shr2)
      if (.not. allocated(DstMiscData%vt_shr2)) then
         allocate(DstMiscData%vt_shr2(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%vt_shr2.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%vt_shr2 = SrcMiscData%vt_shr2
   end if
   if (allocated(SrcMiscData%dvx_dy)) then
      LB(1:3) = lbound(SrcMiscData%dvx_dy)
      UB(1:3) = ubound(SrcMiscData%dvx_dy)
      if (.not. allocated(DstMiscData%dvx_dy)) then
         allocate(DstMiscData%dvx_dy(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%dvx_dy.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%dvx_dy = SrcMiscData%dvx_dy
   end if
   if (allocated(SrcMiscData%dvx_dz)) then
      LB(1:3) = lbound(SrcMiscData%dvx_dz)
      UB(1:3) = ubound(SrcMiscData%dvx_dz)
      if (.not. allocated(DstMiscData%dvx_dz)) then
         allocate(DstMiscData%dvx_dz(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%dvx_dz.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%dvx_dz = SrcMiscData%dvx_dz
   end if
   if (allocated(SrcMiscData%nu_dvx_dy)) then
      LB(1:2) = lbound(SrcMiscData%nu_dvx_dy)
      UB(1:2) = ubound(SrcMiscData%nu_dvx_dy)
      if (.not. allocated(DstMiscData%nu_dvx_dy)) then
         allocate(DstMiscData%nu_dvx_dy(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%nu_dvx_dy.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%nu_dvx_dy = SrcMiscData%nu_dvx_dy
   end if
   if (allocated(SrcMiscData%nu_dvx_dz)) then
      LB(1:2) = lbound(SrcMiscData%nu_dvx_dz)
      UB(1:2) = ubound(SrcMiscData%nu_dvx_dz)
      if (.not. allocated(DstMiscData%nu_dvx_dz)) then
         allocate(DstMiscData%nu_dvx_dz(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%nu_dvx_dz.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%nu_dvx_dz = SrcMiscData%nu_dvx_dz
   end if
   if (allocated(SrcMiscData%dnuvx_dy)) then
      LB(1:2) = lbound(SrcMiscData%dnuvx_dy)
      UB(1:2) = ubound(SrcMiscData%dnuvx_dy)
      if (.not. allocated(DstMiscData%dnuvx_dy)) then
         allocate(DstMiscData%dnuvx_dy(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%dnuvx_dy.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%dnuvx_dy = SrcMiscData%dnuvx_dy
   end if
   if (allocated(SrcMiscData%dnuvx_dz)) then
      LB(1:2) = lbound(SrcMiscData%dnuvx_dz)
      UB(1:2) = ubound(SrcMiscData%dnuvx_dz)
      if (.not. allocated(DstMiscData%dnuvx_dz)) then
         allocate(DstMiscData%dnuvx_dz(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%dnuvx_dz.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%dnuvx_dz = SrcMiscData%dnuvx_dz
   end if
   if (allocated(SrcMiscData%a)) then
      LB(1:1) = lbound(SrcMiscData%a)
      UB(1:1) = ubound(SrcMiscData%a)
      if (.not. allocated(DstMiscData%a)) then
         allocate(DstMiscData%a(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%a.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%a = SrcMiscData%a
   end if
   if (allocated(SrcMiscData%b)) then
      LB(1:1) = lbound(SrcMiscData%b)
      UB(1:1) = ubound(SrcMiscData%b)
      if (.not. allocated(DstMiscData%b)) then
         allocate(DstMiscData%b(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%b.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%b = SrcMiscData%b
   end if
   if (allocated(SrcMiscData%c)) then
      LB(1:1) = lbound(SrcMiscData%c)
      UB(1:1) = ubound(SrcMiscData%c)
      if (.not. allocated(DstMiscData%c)) then
         allocate(DstMiscData%c(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%c.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%c = SrcMiscData%c
   end if
   if (allocated(SrcMiscData%d)) then
      LB(1:1) = lbound(SrcMiscData%d)
      UB(1:1) = ubound(SrcMiscData%d)
      if (.not. allocated(DstMiscData%d)) then
         allocate(DstMiscData%d(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%d.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%d = SrcMiscData%d
   end if
   if (allocated(SrcMiscData%r_wake)) then
      LB(1:1) = lbound(SrcMiscData%r_wake)
      UB(1:1) = ubound(SrcMiscData%r_wake)
      if (.not. allocated(DstMiscData%r_wake)) then
         allocate(DstMiscData%r_wake(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%r_wake.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%r_wake = SrcMiscData%r_wake
   end if
   if (allocated(SrcMiscData%Vx_high)) then
      LB(1:1) = lbound(SrcMiscData%Vx_high)
      UB(1:1) = ubound(SrcMiscData%Vx_high)
      if (.not. allocated(DstMiscData%Vx_high)) then
         allocate(DstMiscData%Vx_high(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%Vx_high.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%Vx_high = SrcMiscData%Vx_high
   end if
   if (allocated(SrcMiscData%Vx_polar)) then
      LB(1:1) = lbound(SrcMiscData%Vx_polar)
      UB(1:1) = ubound(SrcMiscData%Vx_polar)
      if (.not. allocated(DstMiscData%Vx_polar)) then
         allocate(DstMiscData%Vx_polar(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%Vx_polar.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%Vx_polar = SrcMiscData%Vx_polar
   end if
   if (allocated(SrcMiscData%Vt_wake)) then
      LB(1:1) = lbound(SrcMiscData%Vt_wake)
      UB(1:1) = ubound(SrcMiscData%Vt_wake)
      if (.not. allocated(DstMiscData%Vt_wake)) then
         allocate(DstMiscData%Vt_wake(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%Vt_wake.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%Vt_wake = SrcMiscData%Vt_wake
   end if
   DstMiscData%GammaCurl = SrcMiscData%GammaCurl
   DstMiscData%Ct_avg = SrcMiscData%Ct_avg
end subroutine

subroutine WD_DestroyMisc(MiscData, ErrStat, ErrMsg)
   type(WD_MiscVarType), intent(inout) :: MiscData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'WD_DestroyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(MiscData%dvtdr)) then
      deallocate(MiscData%dvtdr)
   end if
   if (allocated(MiscData%vt_tot)) then
      deallocate(MiscData%vt_tot)
   end if
   if (allocated(MiscData%vt_amb)) then
      deallocate(MiscData%vt_amb)
   end if
   if (allocated(MiscData%vt_shr)) then
      deallocate(MiscData%vt_shr)
   end if
   if (allocated(MiscData%vt_tot2)) then
      deallocate(MiscData%vt_tot2)
   end if
   if (allocated(MiscData%vt_amb2)) then
      deallocate(MiscData%vt_amb2)
   end if
   if (allocated(MiscData%vt_shr2)) then
      deallocate(MiscData%vt_shr2)
   end if
   if (allocated(MiscData%dvx_dy)) then
      deallocate(MiscData%dvx_dy)
   end if
   if (allocated(MiscData%dvx_dz)) then
      deallocate(MiscData%dvx_dz)
   end if
   if (allocated(MiscData%nu_dvx_dy)) then
      deallocate(MiscData%nu_dvx_dy)
   end if
   if (allocated(MiscData%nu_dvx_dz)) then
      deallocate(MiscData%nu_dvx_dz)
   end if
   if (allocated(MiscData%dnuvx_dy)) then
      deallocate(MiscData%dnuvx_dy)
   end if
   if (allocated(MiscData%dnuvx_dz)) then
      deallocate(MiscData%dnuvx_dz)
   end if
   if (allocated(MiscData%a)) then
      deallocate(MiscData%a)
   end if
   if (allocated(MiscData%b)) then
      deallocate(MiscData%b)
   end if
   if (allocated(MiscData%c)) then
      deallocate(MiscData%c)
   end if
   if (allocated(MiscData%d)) then
      deallocate(MiscData%d)
   end if
   if (allocated(MiscData%r_wake)) then
      deallocate(MiscData%r_wake)
   end if
   if (allocated(MiscData%Vx_high)) then
      deallocate(MiscData%Vx_high)
   end if
   if (allocated(MiscData%Vx_polar)) then
      deallocate(MiscData%Vx_polar)
   end if
   if (allocated(MiscData%Vt_wake)) then
      deallocate(MiscData%Vt_wake)
   end if
end subroutine

subroutine WD_PackMisc(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(WD_MiscVarType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'WD_PackMisc'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%dvtdr)
   call RegPackAlloc(RF, InData%vt_tot)
   call RegPackAlloc(RF, InData%vt_amb)
   call RegPackAlloc(RF, InData%vt_shr)
   call RegPackAlloc(RF, InData%vt_tot2)
   call RegPackAlloc(RF, InData%vt_amb2)
   call RegPackAlloc(RF, InData%vt_shr2)
   call RegPackAlloc(RF, InData%dvx_dy)
   call RegPackAlloc(RF, InData%dvx_dz)
   call RegPackAlloc(RF, InData%nu_dvx_dy)
   call RegPackAlloc(RF, InData%nu_dvx_dz)
   call RegPackAlloc(RF, InData%dnuvx_dy)
   call RegPackAlloc(RF, InData%dnuvx_dz)
   call RegPackAlloc(RF, InData%a)
   call RegPackAlloc(RF, InData%b)
   call RegPackAlloc(RF, InData%c)
   call RegPackAlloc(RF, InData%d)
   call RegPackAlloc(RF, InData%r_wake)
   call RegPackAlloc(RF, InData%Vx_high)
   call RegPackAlloc(RF, InData%Vx_polar)
   call RegPackAlloc(RF, InData%Vt_wake)
   call RegPack(RF, InData%GammaCurl)
   call RegPack(RF, InData%Ct_avg)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine WD_UnPackMisc(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(WD_MiscVarType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'WD_UnPackMisc'
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%dvtdr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%vt_tot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%vt_amb); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%vt_shr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%vt_tot2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%vt_amb2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%vt_shr2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%dvx_dy); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%dvx_dz); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%nu_dvx_dy); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%nu_dvx_dz); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%dnuvx_dy); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%dnuvx_dz); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%a); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%b); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%c); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%d); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%r_wake); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Vx_high); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Vx_polar); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Vt_wake); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GammaCurl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Ct_avg); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine WD_CopyParam(SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg)
   type(WD_ParameterType), intent(in) :: SrcParamData
   type(WD_ParameterType), intent(inout) :: DstParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'WD_CopyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstParamData%dt_low = SrcParamData%dt_low
   DstParamData%NumPlanes = SrcParamData%NumPlanes
   DstParamData%NumRadii = SrcParamData%NumRadii
   DstParamData%dr = SrcParamData%dr
   if (allocated(SrcParamData%r)) then
      LB(1:1) = lbound(SrcParamData%r)
      UB(1:1) = ubound(SrcParamData%r)
      if (.not. allocated(DstParamData%r)) then
         allocate(DstParamData%r(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%r.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%r = SrcParamData%r
   end if
   if (allocated(SrcParamData%y)) then
      LB(1:1) = lbound(SrcParamData%y)
      UB(1:1) = ubound(SrcParamData%y)
      if (.not. allocated(DstParamData%y)) then
         allocate(DstParamData%y(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%y.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%y = SrcParamData%y
   end if
   if (allocated(SrcParamData%z)) then
      LB(1:1) = lbound(SrcParamData%z)
      UB(1:1) = ubound(SrcParamData%z)
      if (.not. allocated(DstParamData%z)) then
         allocate(DstParamData%z(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%z.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%z = SrcParamData%z
   end if
   DstParamData%Mod_Wake = SrcParamData%Mod_Wake
   DstParamData%Swirl = SrcParamData%Swirl
   DstParamData%k_VortexDecay = SrcParamData%k_VortexDecay
   DstParamData%sigma_D = SrcParamData%sigma_D
   DstParamData%NumVortices = SrcParamData%NumVortices
   DstParamData%filtParam = SrcParamData%filtParam
   DstParamData%oneMinusFiltParam = SrcParamData%oneMinusFiltParam
   DstParamData%C_HWkDfl_O = SrcParamData%C_HWkDfl_O
   DstParamData%C_HWkDfl_OY = SrcParamData%C_HWkDfl_OY
   DstParamData%C_HWkDfl_x = SrcParamData%C_HWkDfl_x
   DstParamData%C_HWkDfl_xY = SrcParamData%C_HWkDfl_xY
   DstParamData%C_NearWake = SrcParamData%C_NearWake
   DstParamData%k_vAmb = SrcParamData%k_vAmb
   DstParamData%C_vAmb_DMin = SrcParamData%C_vAmb_DMin
   DstParamData%C_vAmb_DMax = SrcParamData%C_vAmb_DMax
   DstParamData%C_vAmb_FMin = SrcParamData%C_vAmb_FMin
   DstParamData%C_vAmb_Exp = SrcParamData%C_vAmb_Exp
   DstParamData%k_vShr = SrcParamData%k_vShr
   DstParamData%C_vShr_DMin = SrcParamData%C_vShr_DMin
   DstParamData%C_vShr_DMax = SrcParamData%C_vShr_DMax
   DstParamData%C_vShr_FMin = SrcParamData%C_vShr_FMin
   DstParamData%C_vShr_Exp = SrcParamData%C_vShr_Exp
   DstParamData%Mod_WakeDiam = SrcParamData%Mod_WakeDiam
   DstParamData%C_WakeDiam = SrcParamData%C_WakeDiam
   DstParamData%FilterInit = SrcParamData%FilterInit
   DstParamData%k_vCurl = SrcParamData%k_vCurl
   DstParamData%OutAllPlanes = SrcParamData%OutAllPlanes
   DstParamData%OutFileRoot = SrcParamData%OutFileRoot
   DstParamData%OutFileVTKDir = SrcParamData%OutFileVTKDir
   DstParamData%TurbNum = SrcParamData%TurbNum
   DstParamData%WAT = SrcParamData%WAT
   DstParamData%WAT_k_Def_k_c = SrcParamData%WAT_k_Def_k_c
   DstParamData%WAT_k_Def_FMin = SrcParamData%WAT_k_Def_FMin
   DstParamData%WAT_k_Def_DMin = SrcParamData%WAT_k_Def_DMin
   DstParamData%WAT_k_Def_DMax = SrcParamData%WAT_k_Def_DMax
   DstParamData%WAT_k_Def_Exp = SrcParamData%WAT_k_Def_Exp
   DstParamData%WAT_k_Grad_k_c = SrcParamData%WAT_k_Grad_k_c
   DstParamData%WAT_k_Grad_FMin = SrcParamData%WAT_k_Grad_FMin
   DstParamData%WAT_k_Grad_DMin = SrcParamData%WAT_k_Grad_DMin
   DstParamData%WAT_k_Grad_DMax = SrcParamData%WAT_k_Grad_DMax
   DstParamData%WAT_k_Grad_Exp = SrcParamData%WAT_k_Grad_Exp
end subroutine

subroutine WD_DestroyParam(ParamData, ErrStat, ErrMsg)
   type(WD_ParameterType), intent(inout) :: ParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'WD_DestroyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ParamData%r)) then
      deallocate(ParamData%r)
   end if
   if (allocated(ParamData%y)) then
      deallocate(ParamData%y)
   end if
   if (allocated(ParamData%z)) then
      deallocate(ParamData%z)
   end if
end subroutine

subroutine WD_PackParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(WD_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'WD_PackParam'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%dt_low)
   call RegPack(RF, InData%NumPlanes)
   call RegPack(RF, InData%NumRadii)
   call RegPack(RF, InData%dr)
   call RegPackAlloc(RF, InData%r)
   call RegPackAlloc(RF, InData%y)
   call RegPackAlloc(RF, InData%z)
   call RegPack(RF, InData%Mod_Wake)
   call RegPack(RF, InData%Swirl)
   call RegPack(RF, InData%k_VortexDecay)
   call RegPack(RF, InData%sigma_D)
   call RegPack(RF, InData%NumVortices)
   call RegPack(RF, InData%filtParam)
   call RegPack(RF, InData%oneMinusFiltParam)
   call RegPack(RF, InData%C_HWkDfl_O)
   call RegPack(RF, InData%C_HWkDfl_OY)
   call RegPack(RF, InData%C_HWkDfl_x)
   call RegPack(RF, InData%C_HWkDfl_xY)
   call RegPack(RF, InData%C_NearWake)
   call RegPack(RF, InData%k_vAmb)
   call RegPack(RF, InData%C_vAmb_DMin)
   call RegPack(RF, InData%C_vAmb_DMax)
   call RegPack(RF, InData%C_vAmb_FMin)
   call RegPack(RF, InData%C_vAmb_Exp)
   call RegPack(RF, InData%k_vShr)
   call RegPack(RF, InData%C_vShr_DMin)
   call RegPack(RF, InData%C_vShr_DMax)
   call RegPack(RF, InData%C_vShr_FMin)
   call RegPack(RF, InData%C_vShr_Exp)
   call RegPack(RF, InData%Mod_WakeDiam)
   call RegPack(RF, InData%C_WakeDiam)
   call RegPack(RF, InData%FilterInit)
   call RegPack(RF, InData%k_vCurl)
   call RegPack(RF, InData%OutAllPlanes)
   call RegPack(RF, InData%OutFileRoot)
   call RegPack(RF, InData%OutFileVTKDir)
   call RegPack(RF, InData%TurbNum)
   call RegPack(RF, InData%WAT)
   call RegPack(RF, InData%WAT_k_Def_k_c)
   call RegPack(RF, InData%WAT_k_Def_FMin)
   call RegPack(RF, InData%WAT_k_Def_DMin)
   call RegPack(RF, InData%WAT_k_Def_DMax)
   call RegPack(RF, InData%WAT_k_Def_Exp)
   call RegPack(RF, InData%WAT_k_Grad_k_c)
   call RegPack(RF, InData%WAT_k_Grad_FMin)
   call RegPack(RF, InData%WAT_k_Grad_DMin)
   call RegPack(RF, InData%WAT_k_Grad_DMax)
   call RegPack(RF, InData%WAT_k_Grad_Exp)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine WD_UnPackParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(WD_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'WD_UnPackParam'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%dt_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumPlanes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumRadii); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%r); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%z); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Mod_Wake); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Swirl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k_VortexDecay); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%sigma_D); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumVortices); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%filtParam); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%oneMinusFiltParam); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_HWkDfl_O); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_HWkDfl_OY); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_HWkDfl_x); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_HWkDfl_xY); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_NearWake); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k_vAmb); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_vAmb_DMin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_vAmb_DMax); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_vAmb_FMin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_vAmb_Exp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k_vShr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_vShr_DMin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_vShr_DMax); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_vShr_FMin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_vShr_Exp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Mod_WakeDiam); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_WakeDiam); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FilterInit); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k_vCurl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutAllPlanes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutFileRoot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutFileVTKDir); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TurbNum); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WAT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WAT_k_Def_k_c); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WAT_k_Def_FMin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WAT_k_Def_DMin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WAT_k_Def_DMax); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WAT_k_Def_Exp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WAT_k_Grad_k_c); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WAT_k_Grad_FMin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WAT_k_Grad_DMin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WAT_k_Grad_DMax); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WAT_k_Grad_Exp); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine WD_CopyInput(SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg)
   type(WD_InputType), intent(in) :: SrcInputData
   type(WD_InputType), intent(inout) :: DstInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'WD_CopyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInputData%xhat_disk = SrcInputData%xhat_disk
   DstInputData%YawErr = SrcInputData%YawErr
   DstInputData%psi_skew = SrcInputData%psi_skew
   DstInputData%chi_skew = SrcInputData%chi_skew
   DstInputData%p_hub = SrcInputData%p_hub
   if (allocated(SrcInputData%V_plane)) then
      LB(1:2) = lbound(SrcInputData%V_plane)
      UB(1:2) = ubound(SrcInputData%V_plane)
      if (.not. allocated(DstInputData%V_plane)) then
         allocate(DstInputData%V_plane(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%V_plane.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%V_plane = SrcInputData%V_plane
   end if
   DstInputData%Vx_wind_disk = SrcInputData%Vx_wind_disk
   DstInputData%TI_amb = SrcInputData%TI_amb
   DstInputData%D_rotor = SrcInputData%D_rotor
   DstInputData%Vx_rel_disk = SrcInputData%Vx_rel_disk
   if (allocated(SrcInputData%Ct_azavg)) then
      LB(1:1) = lbound(SrcInputData%Ct_azavg)
      UB(1:1) = ubound(SrcInputData%Ct_azavg)
      if (.not. allocated(DstInputData%Ct_azavg)) then
         allocate(DstInputData%Ct_azavg(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%Ct_azavg.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%Ct_azavg = SrcInputData%Ct_azavg
   end if
   if (allocated(SrcInputData%Cq_azavg)) then
      LB(1:1) = lbound(SrcInputData%Cq_azavg)
      UB(1:1) = ubound(SrcInputData%Cq_azavg)
      if (.not. allocated(DstInputData%Cq_azavg)) then
         allocate(DstInputData%Cq_azavg(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%Cq_azavg.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%Cq_azavg = SrcInputData%Cq_azavg
   end if
end subroutine

subroutine WD_DestroyInput(InputData, ErrStat, ErrMsg)
   type(WD_InputType), intent(inout) :: InputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'WD_DestroyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InputData%V_plane)) then
      deallocate(InputData%V_plane)
   end if
   if (allocated(InputData%Ct_azavg)) then
      deallocate(InputData%Ct_azavg)
   end if
   if (allocated(InputData%Cq_azavg)) then
      deallocate(InputData%Cq_azavg)
   end if
end subroutine

subroutine WD_PackInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(WD_InputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'WD_PackInput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%xhat_disk)
   call RegPack(RF, InData%YawErr)
   call RegPack(RF, InData%psi_skew)
   call RegPack(RF, InData%chi_skew)
   call RegPack(RF, InData%p_hub)
   call RegPackAlloc(RF, InData%V_plane)
   call RegPack(RF, InData%Vx_wind_disk)
   call RegPack(RF, InData%TI_amb)
   call RegPack(RF, InData%D_rotor)
   call RegPack(RF, InData%Vx_rel_disk)
   call RegPackAlloc(RF, InData%Ct_azavg)
   call RegPackAlloc(RF, InData%Cq_azavg)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine WD_UnPackInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(WD_InputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'WD_UnPackInput'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%xhat_disk); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawErr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%psi_skew); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%chi_skew); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%p_hub); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%V_plane); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Vx_wind_disk); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TI_amb); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%D_rotor); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Vx_rel_disk); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Ct_azavg); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Cq_azavg); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine WD_CopyOutput(SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg)
   type(WD_OutputType), intent(in) :: SrcOutputData
   type(WD_OutputType), intent(inout) :: DstOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'WD_CopyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcOutputData%xhat_plane)) then
      LB(1:2) = lbound(SrcOutputData%xhat_plane)
      UB(1:2) = ubound(SrcOutputData%xhat_plane)
      if (.not. allocated(DstOutputData%xhat_plane)) then
         allocate(DstOutputData%xhat_plane(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%xhat_plane.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%xhat_plane = SrcOutputData%xhat_plane
   end if
   if (allocated(SrcOutputData%p_plane)) then
      LB(1:2) = lbound(SrcOutputData%p_plane)
      UB(1:2) = ubound(SrcOutputData%p_plane)
      if (.not. allocated(DstOutputData%p_plane)) then
         allocate(DstOutputData%p_plane(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%p_plane.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%p_plane = SrcOutputData%p_plane
   end if
   if (allocated(SrcOutputData%Vx_wake)) then
      LB(1:2) = lbound(SrcOutputData%Vx_wake)
      UB(1:2) = ubound(SrcOutputData%Vx_wake)
      if (.not. allocated(DstOutputData%Vx_wake)) then
         allocate(DstOutputData%Vx_wake(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%Vx_wake.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%Vx_wake = SrcOutputData%Vx_wake
   end if
   if (allocated(SrcOutputData%Vr_wake)) then
      LB(1:2) = lbound(SrcOutputData%Vr_wake)
      UB(1:2) = ubound(SrcOutputData%Vr_wake)
      if (.not. allocated(DstOutputData%Vr_wake)) then
         allocate(DstOutputData%Vr_wake(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%Vr_wake.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%Vr_wake = SrcOutputData%Vr_wake
   end if
   if (allocated(SrcOutputData%Vx_wake2)) then
      LB(1:3) = lbound(SrcOutputData%Vx_wake2)
      UB(1:3) = ubound(SrcOutputData%Vx_wake2)
      if (.not. allocated(DstOutputData%Vx_wake2)) then
         allocate(DstOutputData%Vx_wake2(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%Vx_wake2.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%Vx_wake2 = SrcOutputData%Vx_wake2
   end if
   if (allocated(SrcOutputData%Vy_wake2)) then
      LB(1:3) = lbound(SrcOutputData%Vy_wake2)
      UB(1:3) = ubound(SrcOutputData%Vy_wake2)
      if (.not. allocated(DstOutputData%Vy_wake2)) then
         allocate(DstOutputData%Vy_wake2(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%Vy_wake2.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%Vy_wake2 = SrcOutputData%Vy_wake2
   end if
   if (allocated(SrcOutputData%Vz_wake2)) then
      LB(1:3) = lbound(SrcOutputData%Vz_wake2)
      UB(1:3) = ubound(SrcOutputData%Vz_wake2)
      if (.not. allocated(DstOutputData%Vz_wake2)) then
         allocate(DstOutputData%Vz_wake2(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%Vz_wake2.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%Vz_wake2 = SrcOutputData%Vz_wake2
   end if
   if (allocated(SrcOutputData%D_wake)) then
      LB(1:1) = lbound(SrcOutputData%D_wake)
      UB(1:1) = ubound(SrcOutputData%D_wake)
      if (.not. allocated(DstOutputData%D_wake)) then
         allocate(DstOutputData%D_wake(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%D_wake.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%D_wake = SrcOutputData%D_wake
   end if
   if (allocated(SrcOutputData%x_plane)) then
      LB(1:1) = lbound(SrcOutputData%x_plane)
      UB(1:1) = ubound(SrcOutputData%x_plane)
      if (.not. allocated(DstOutputData%x_plane)) then
         allocate(DstOutputData%x_plane(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%x_plane.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%x_plane = SrcOutputData%x_plane
   end if
   if (allocated(SrcOutputData%WAT_k)) then
      LB(1:3) = lbound(SrcOutputData%WAT_k)
      UB(1:3) = ubound(SrcOutputData%WAT_k)
      if (.not. allocated(DstOutputData%WAT_k)) then
         allocate(DstOutputData%WAT_k(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%WAT_k.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%WAT_k = SrcOutputData%WAT_k
   end if
end subroutine

subroutine WD_DestroyOutput(OutputData, ErrStat, ErrMsg)
   type(WD_OutputType), intent(inout) :: OutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'WD_DestroyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(OutputData%xhat_plane)) then
      deallocate(OutputData%xhat_plane)
   end if
   if (allocated(OutputData%p_plane)) then
      deallocate(OutputData%p_plane)
   end if
   if (allocated(OutputData%Vx_wake)) then
      deallocate(OutputData%Vx_wake)
   end if
   if (allocated(OutputData%Vr_wake)) then
      deallocate(OutputData%Vr_wake)
   end if
   if (allocated(OutputData%Vx_wake2)) then
      deallocate(OutputData%Vx_wake2)
   end if
   if (allocated(OutputData%Vy_wake2)) then
      deallocate(OutputData%Vy_wake2)
   end if
   if (allocated(OutputData%Vz_wake2)) then
      deallocate(OutputData%Vz_wake2)
   end if
   if (allocated(OutputData%D_wake)) then
      deallocate(OutputData%D_wake)
   end if
   if (allocated(OutputData%x_plane)) then
      deallocate(OutputData%x_plane)
   end if
   if (allocated(OutputData%WAT_k)) then
      deallocate(OutputData%WAT_k)
   end if
end subroutine

subroutine WD_PackOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(WD_OutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'WD_PackOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%xhat_plane)
   call RegPackAlloc(RF, InData%p_plane)
   call RegPackAlloc(RF, InData%Vx_wake)
   call RegPackAlloc(RF, InData%Vr_wake)
   call RegPackAlloc(RF, InData%Vx_wake2)
   call RegPackAlloc(RF, InData%Vy_wake2)
   call RegPackAlloc(RF, InData%Vz_wake2)
   call RegPackAlloc(RF, InData%D_wake)
   call RegPackAlloc(RF, InData%x_plane)
   call RegPackAlloc(RF, InData%WAT_k)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine WD_UnPackOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(WD_OutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'WD_UnPackOutput'
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%xhat_plane); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%p_plane); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Vx_wake); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Vr_wake); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Vx_wake2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Vy_wake2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Vz_wake2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%D_wake); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%x_plane); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WAT_k); if (RegCheckErr(RF, RoutineName)) return
end subroutine
END MODULE WakeDynamics_Types
!ENDOFREGISTRYGENERATEDFILE
