!STARTOFREGISTRYGENERATEDFILE 'SubDyn_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! SubDyn_Types
!.................................................................................................................................
! This file is part of SubDyn.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in SubDyn. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE SubDyn_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE NWTC_Library
IMPLICIT NONE
! =========  IList  =======
  TYPE, PUBLIC :: IList
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: List      !< List of integers [-]
  END TYPE IList
! =======================
! =========  MeshAuxDataType  =======
  TYPE, PUBLIC :: MeshAuxDataType
    INTEGER(IntKi)  :: MemberID = 0_IntKi      !< Member ID for Output [-]
    INTEGER(IntKi)  :: NOutCnt = 0_IntKi      !< Number of Nodes for the output member [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: NodeCnt      !< Node ordinal numbers for the output member [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: NodeIDs      !< Node IDs associated with ordinal numbers for the output member [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: ElmIDs      !< Element IDs connected to each NodeIDs; max 10 elements [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: ElmNds      !< Flag to indicate 1st or 2nd node of element for each ElmIDs [-]
    REAL(R8Ki) , DIMENSION(:,:,:,:), ALLOCATABLE  :: Me      !< Mass matrix connected to each joint element for outAll output [-]
    REAL(R8Ki) , DIMENSION(:,:,:,:), ALLOCATABLE  :: Ke      !< Mass matrix connected to each joint element for outAll output [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: Fg      !< Gravity load vector connected to each joint element for requested member output [-]
  END TYPE MeshAuxDataType
! =======================
! =========  CB_MatArrays  =======
  TYPE, PUBLIC :: CB_MatArrays
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: MBB      !< FULL MBB ( no constraints applied) [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: MBM      !< FULL MBM ( no constraints applied) [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: KBB      !< FULL KBB ( no constraints applied) [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: PhiL      !< Retained CB modes, possibly allPhiL(nDOFL,nDOFL), or PhiL(nDOFL,nDOFM) [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: PhiR      !< FULL PhiR ( no constraints applied) [-]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: OmegaL      !< Eigenvalues of retained CB modes, possibly all (nDOFL or nDOFM) [-]
  END TYPE CB_MatArrays
! =======================
! =========  ElemPropType  =======
  TYPE, PUBLIC :: ElemPropType
    INTEGER(IntKi)  :: eType = 0_IntKi      !< Element Type [-]
    REAL(ReKi)  :: Length = 0.0_ReKi      !< Length of an element [-]
    REAL(ReKi)  :: Ixx = 0.0_ReKi      !< Moment of inertia of an element [-]
    REAL(ReKi)  :: Iyy = 0.0_ReKi      !< Moment of inertia of an element [-]
    REAL(ReKi)  :: Jzz = 0.0_ReKi      !< Moment of inertia of an element [-]
    REAL(ReKi)  :: Jt = 0.0_ReKi      !< Torsion constant of an element [-]
    LOGICAL  :: Shear = .false.      !< Use timoshenko (true) E-B (false) [-]
    REAL(ReKi)  :: Kappa_x = 0.0_ReKi      !< Shear coefficient [-]
    REAL(ReKi)  :: Kappa_y = 0.0_ReKi      !< Shear coefficient [-]
    REAL(ReKi)  :: YoungE = 0.0_ReKi      !< Young's modulus [-]
    REAL(ReKi)  :: ShearG = 0.0_ReKi      !< Shear modulus [N/m^2]
    REAL(ReKi) , DIMENSION(1:2)  :: D = 0.0_ReKi      !< Diameter at node 1 and 2, for visualization only [m]
    REAL(ReKi) , DIMENSION(1:2)  :: Sa = 0.0_ReKi      !< Side A lengths at node 1 and 2, for visualization only [m]
    REAL(ReKi) , DIMENSION(1:2)  :: Sb = 0.0_ReKi      !< Side B lengths at node 1 and 2, for visualization only [m]
    REAL(ReKi)  :: Area = 0.0_ReKi      !< Area of an element [m^2]
    REAL(ReKi)  :: Rho = 0.0_ReKi      !< Density [kg/m^3]
    REAL(ReKi)  :: T0 = 0.0_ReKi      !< Pretension  [N]
    REAL(ReKi)  :: k11 = 0.0_ReKi      !< Spring translational stiffness [N/m]
    REAL(ReKi)  :: k12 = 0.0_ReKi      !< Spring cross-coupling stiffness [N/m]
    REAL(ReKi)  :: k13 = 0.0_ReKi      !< Spring cross-coupling stiffness [N/m]
    REAL(ReKi)  :: k14 = 0.0_ReKi      !< Spring cross-coupling stiffness [N/rad]
    REAL(ReKi)  :: k15 = 0.0_ReKi      !< Spring cross-coupling stiffness [N/rad]
    REAL(ReKi)  :: k16 = 0.0_ReKi      !< Spring cross-coupling stiffness [N/rad]
    REAL(ReKi)  :: k22 = 0.0_ReKi      !< Spring translational stiffness [N/m]
    REAL(ReKi)  :: k23 = 0.0_ReKi      !< Spring cross-coupling stiffness [N/m]
    REAL(ReKi)  :: k24 = 0.0_ReKi      !< Spring cross-coupling stiffness [N/rad]
    REAL(ReKi)  :: k25 = 0.0_ReKi      !< Spring cross-coupling stiffness [N/rad]
    REAL(ReKi)  :: k26 = 0.0_ReKi      !< Spring cross-coupling stiffness [N/rad]
    REAL(ReKi)  :: k33 = 0.0_ReKi      !< Spring translational stiffness [N/m]
    REAL(ReKi)  :: k34 = 0.0_ReKi      !< Spring cross-coupling stiffness [N/rad]
    REAL(ReKi)  :: k35 = 0.0_ReKi      !< Spring cross-coupling stiffness [N/rad]
    REAL(ReKi)  :: k36 = 0.0_ReKi      !< Spring cross-coupling stiffness [N/rad]
    REAL(ReKi)  :: k44 = 0.0_ReKi      !< Spring rotational stiffness [Nm/rad]
    REAL(ReKi)  :: k45 = 0.0_ReKi      !< Spring cross-coupling stiffness [Nm/rad]
    REAL(ReKi)  :: k46 = 0.0_ReKi      !< Spring cross-coupling stiffness [Nm/rad]
    REAL(ReKi)  :: k55 = 0.0_ReKi      !< Spring rotational stiffness [Nm/rad]
    REAL(ReKi)  :: k56 = 0.0_ReKi      !< Spring cross-coupling stiffness [Nm/rad]
    REAL(ReKi)  :: k66 = 0.0_ReKi      !< Spring rotational stiffness [Nm/rad]
    REAL(R8Ki) , DIMENSION(1:3,1:3)  :: DirCos = 0.0_R8Ki      !< Element direction cosine matrix [-]
  END TYPE ElemPropType
! =======================
! =========  SD_InitInputType  =======
  TYPE, PUBLIC :: SD_InitInputType
    CHARACTER(1024)  :: SDInputFile      !< Name of the input file [-]
    CHARACTER(1024)  :: RootName      !< SubDyn rootname [-]
    REAL(ReKi)  :: g = 0.0_ReKi      !< Gravity acceleration [-]
    REAL(ReKi)  :: WtrDpth = 0.0_ReKi      !< Water Depth (positive valued) [-]
    REAL(ReKi) , DIMENSION(1:3)  :: TP_RefPoint = 0.0_ReKi      !< global position of transition piece reference point (could also be defined in SubDyn itself) [-]
    REAL(ReKi)  :: SubRotateZ = 0.0_ReKi      !< Rotation angle in degrees about global Z [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: SoilStiffness      !< Soil stiffness matrices from SoilDyn ['(N/m,]
    TYPE(MeshType)  :: SoilMesh      !< Mesh for soil stiffness locations [-]
    LOGICAL  :: Linearize = .FALSE.      !< Flag that tells this module if the glue code wants to linearize. [-]
  END TYPE SD_InitInputType
! =======================
! =========  SD_InitOutputType  =======
  TYPE, PUBLIC :: SD_InitOutputType
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputHdr      !< Names of the output-to-file channels [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputUnt      !< Units of the output-to-file channels [-]
    TYPE(ProgDesc)  :: Ver      !< This module's name, version, and date [-]
    CHARACTER(LinChanLen) , DIMENSION(:), ALLOCATABLE  :: LinNames_y      !< Names of the outputs used in linearization [-]
    CHARACTER(LinChanLen) , DIMENSION(:), ALLOCATABLE  :: LinNames_x      !< Names of the continuous states used in linearization [-]
    CHARACTER(LinChanLen) , DIMENSION(:), ALLOCATABLE  :: LinNames_u      !< Names of the inputs used in linearization [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: RotFrame_y      !< Flag that tells FAST/MBC3 if the outputs used in linearization are in the rotating frame [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: RotFrame_x      !< Flag that tells FAST/MBC3 if the continuous states used in linearization are in the rotating frame (not used for glue) [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: RotFrame_u      !< Flag that tells FAST/MBC3 if the inputs used in linearization are in the rotating frame [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: IsLoad_u      !< Flag that tells FAST if the inputs used in linearization are loads (for preconditioning matrix) [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: DerivOrder_x      !< Integer that tells FAST/MBC3 the maximum derivative order of continuous states used in linearization [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: CableCChanRqst      !< flag indicating control channel for active cable tensioning is requested [-]
  END TYPE SD_InitOutputType
! =======================
! =========  SD_InitType  =======
  TYPE, PUBLIC :: SD_InitType
    CHARACTER(1024)  :: RootName      !< SubDyn rootname [-]
    REAL(ReKi) , DIMENSION(1:3)  :: TP_RefPoint = 0.0_ReKi      !< global position of transition piece reference point (could also be defined in SubDyn itself) [-]
    REAL(ReKi)  :: SubRotateZ = 0.0_ReKi      !< Rotation angle in degrees about global Z [-]
    REAL(ReKi)  :: g = 0.0_ReKi      !< Gravity acceleration [m/s^2]
    REAL(DbKi)  :: DT = 0.0_R8Ki      !< Time step from Glue Code [seconds]
    INTEGER(IntKi)  :: NJoints = 0_IntKi      !< Number of joints of the sub structure [-]
    INTEGER(IntKi)  :: NPropSetsX = 0_IntKi      !< Number of extended property sets [-]
    INTEGER(IntKi)  :: NPropSetsBC = 0_IntKi      !< Number of property sets for beams with a circular section [-]
    INTEGER(IntKi)  :: NPropSetsBR = 0_IntKi      !< Number of property sets for beams with a rectangular section [-]
    INTEGER(IntKi)  :: NPropSetsC = 0_IntKi      !< Number of property sets for cables [-]
    INTEGER(IntKi)  :: NPropSetsR = 0_IntKi      !< Number of property sets for rigid links [-]
    INTEGER(IntKi)  :: NPropSetsS = 0_IntKi      !< Number of property sets for spring elements [-]
    INTEGER(IntKi)  :: NCMass = 0_IntKi      !< Number of joints with concentrated mass [-]
    INTEGER(IntKi)  :: NCOSMs = 0_IntKi      !< Number of independent cosine matrices [-]
    INTEGER(IntKi)  :: FEMMod = 0_IntKi      !< FEM switch  element model in the FEM [-]
    INTEGER(IntKi)  :: NDiv = 0_IntKi      !< Number of divisions for each member [-]
    LOGICAL  :: CBMod = .false.      !< Perform C-B flag [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Joints      !< Joints number and coordinate values [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PropSetsBC      !< Property sets number and values for circular beam sections [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PropSetsBR      !< Property sets number and values for rectangular beam sections [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PropSetsC      !< Property ID and values for cables [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PropSetsR      !< Property ID and values for rigid link [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PropSetsS      !< Property ID and values for spring element [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PropSetsX      !< Extended property sets [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: COSMs      !< Independent direction cosine matrices [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: CMass      !< Concentrated mass information [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: JDampings      !< Damping coefficients for internal modes [-]
    INTEGER(IntKi)  :: GuyanDampMod = 0_IntKi      !< Guyan damping [0=none, 1=Rayleigh Damping, 2= user specified 6x6 matrix] [-]
    REAL(ReKi) , DIMENSION(1:2)  :: RayleighDamp = 0.0_ReKi      !< Mass and stiffness proportional damping coefficients (Rayleigh Damping) [only if GuyanDampMod=1] [-]
    REAL(ReKi) , DIMENSION(1:6,1:6)  :: GuyanDampMat = 0.0_ReKi      !< Guyan Damping Matrix, see also CBB [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: Members      !< Member joints connection           [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: MemberSpin      !< Member spin angle about its axis - for rectangular members  [rad]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: SSOutList      !< List of Output Channels            [-]
    LOGICAL  :: OutCOSM = .false.      !< Output Cos-matrices Flag           [-]
    LOGICAL  :: TabDelim = .false.      !< Generate a tab-delimited output file in OutJckF-Flag                        [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: SSIK      !< SSI stiffness packed matrix elements (21 of them), for each reaction joint  [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: SSIM      !< SSI mass packed matrix elements (21 of them), for each reaction joint       [-]
    CHARACTER(1024) , DIMENSION(:), ALLOCATABLE  :: SSIfile      !< Soil Structure Interaction (SSI) files to associate with each reaction node [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Soil_K      !< Soil stiffness (at passed at Init, not in input file)  6x6xn                [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Soil_Points      !< Node positions where soil stiffness will be added                           [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: Soil_Nodes      !< Node indices where soil stiffness will be added                             [-]
    INTEGER(IntKi)  :: NElem = 0_IntKi      !< Total number of elements [-]
    INTEGER(IntKi)  :: NPropBC = 0_IntKi      !< Total number of property sets for Beams with a circular section [-]
    INTEGER(IntKi)  :: NPropBR = 0_IntKi      !< Total number of property sets for Beams with a rectangular section [-]
    INTEGER(IntKi)  :: NPropX = 0_IntKi      !< Total number of property sets for Beams with an arbitrary section [-]
    INTEGER(IntKi)  :: NPropC = 0_IntKi      !< Total number of property sets for Cable [-]
    INTEGER(IntKi)  :: NPropR = 0_IntKi      !< Total number of property sets for Rigid [-]
    INTEGER(IntKi)  :: NPropS = 0_IntKi      !< Total number of property sets for Spring [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Nodes      !< Nodes number and coordinates            [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PropsBC      !< Property sets and values for Beams with a circular section [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PropsBR      !< Property sets and values for Beams with a rectangular section [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PropsC      !< Property sets and values for Cable      [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PropsR      !< Property sets and values for Rigid link [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PropsS      !< Property sets and values for Spring     [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: K      !< System stiffness matrix                 [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: M      !< System mass matrix                      [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: ElemProps      !< Element properties(A, L, Ixx, Iyy, Jzz, Shear, Kappa, E, G, Rho, DirCos(1,1), DirCos(2, 1), ....., DirCos(3, 3) ) [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: MemberNodes      !< Member number and list of nodes making up a member (>2 if subdivided) [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: NodesConnN      !< Nodes that connect to a common node    [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: NodesConnE      !< Elements that connect to a common node [-]
    LOGICAL  :: SSSum = .false.      !< SubDyn Summary File Flag               [-]
  END TYPE SD_InitType
! =======================
! =========  SD_ContinuousStateType  =======
  TYPE, PUBLIC :: SD_ContinuousStateType
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: qm      !< Virtual states, Nmod elements [-]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: qmdot      !< Derivative of states, Nmod elements [-]
  END TYPE SD_ContinuousStateType
! =======================
! =========  SD_DiscreteStateType  =======
  TYPE, PUBLIC :: SD_DiscreteStateType
    REAL(ReKi)  :: DummyDiscState = 0.0_ReKi      !< Remove this variable if you have discrete states [-]
  END TYPE SD_DiscreteStateType
! =======================
! =========  SD_ConstraintStateType  =======
  TYPE, PUBLIC :: SD_ConstraintStateType
    REAL(ReKi)  :: DummyConstrState = 0.0_ReKi      !< Remove this variable if you have constraint states [-]
  END TYPE SD_ConstraintStateType
! =======================
! =========  SD_OtherStateType  =======
  TYPE, PUBLIC :: SD_OtherStateType
    TYPE(SD_ContinuousStateType) , DIMENSION(:), ALLOCATABLE  :: xdot      !< previous state derivs for m-step time integrator [-]
    INTEGER(IntKi)  :: n = 0_IntKi      !< tracks time step for which OtherState was updated last [-]
  END TYPE SD_OtherStateType
! =======================
! =========  SD_MiscVarType  =======
  TYPE, PUBLIC :: SD_MiscVarType
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: qmdotdot      !< 2nd Derivative of states, used only for output-file purposes [-]
    REAL(ReKi) , DIMENSION(1:6)  :: u_TP = 0.0_ReKi 
    REAL(ReKi) , DIMENSION(1:6)  :: udot_TP = 0.0_ReKi 
    REAL(ReKi) , DIMENSION(1:6)  :: udotdot_TP = 0.0_ReKi 
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: F_L      !< Loads on internal DOF, size nL [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: F_L2      !< Loads on internal DOF, size nL, used for SIM and ADM4 [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: UR_bar 
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: UR_bar_dot 
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: UR_bar_dotdot 
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: UL      !< Internal DOFs (L) displacements  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: UL_NS      !< Internal DOFs (L) displacements, No SIM (NS) [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: UL_dot 
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: UL_dotdot 
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: DU_full      !< Delta U used for extra moment, size nDOF [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: U_full      !< Displacement of all DOFs (full system) with SIM [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: U_full_NS      !< Displacement of all DOFs (full system), No SIM (NS) [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: U_full_dot 
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: U_full_dotdot 
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: U_full_elast      !< Elastic displacements for computation of K ue (without rigid body mode for floating), includes SIM [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: U_red 
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: FC_unit      !< Cable Force vector (for varying cable load, of unit cable load) [N]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: SDWrOutput      !< Data from previous step to be written to a SubDyn output file [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: AllOuts      !< Data for output file [-]
    REAL(DbKi)  :: LastOutTime = 0.0_R8Ki      !< The time of the most recent stored output data [s]
    INTEGER(IntKi)  :: Decimat = 0_IntKi      !< Current output decimation counter [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Fext      !< External loads on unconstrained DOFs [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Fext_red      !< External loads on constrained DOFs, Fext_red= T^t Fext [-]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: FG      !< Gravity force vector (without initial cable force T0) based on the instantaneous platform orientation, not reduced (floating only) [N]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: UL_SIM      !< UL for SIM = PhiL qL0- PhiM qm0, size nL [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: UL_0m      !< Intermediate UL term for SIM = PhiM qm0, size nL [-]
  END TYPE SD_MiscVarType
! =======================
! =========  SD_ParameterType  =======
  TYPE, PUBLIC :: SD_ParameterType
    REAL(ReKi)  :: g = 0.0_ReKi      !< Gravity acceleration [m/s^2]
    REAL(DbKi)  :: SDDeltaT = 0.0_R8Ki      !< Time step (for integration of continuous states) [seconds]
    INTEGER(IntKi)  :: IntMethod = 0_IntKi      !< Integration Method (1/2/3)Length of y2 array [-]
    INTEGER(IntKi)  :: nDOF = 0_IntKi      !< Total degree of freedom [-]
    INTEGER(IntKi)  :: nDOF_red = 0_IntKi      !< Total degree of freedom after constraint reduction [-]
    INTEGER(IntKi)  :: Nmembers = 0_IntKi      !< Number of members of the sub structure [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: Elems      !< Element nodes connections [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: ElemSpin      !< Element spin angle about its axis [rad]
    TYPE(ElemPropType) , DIMENSION(:), ALLOCATABLE  :: ElemProps      !< List of element properties [-]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: FC      !< Initial cable force T0, not reduced [N]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: FG      !< Gravity force vector, not reduced [N]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: DP0      !< Vector from TP to a Node at t=0, used for Floating Rigid Body motion [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: rPG      !< Vector from TP to rigid-body CoG in the Guyan (rigid-body) frame, used for Floating Rigid Body Motion [m]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: NodeID2JointID      !< Store Joint ID for each NodeID since SubDyn re-label nodes (and add more nodes) [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: CMassNode      !< Node indices for concentrated masses [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: CMassWeight      !< Weight of concentrated masses [N]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: CMassOffset      !< Concentrated mass CoG offset from attached nodes [m]
    LOGICAL  :: reduced = .false.      !< True if system has been reduced to account for constraints [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: T_red      !< Transformation matrix performing the constraint reduction x = T. xtilde [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: T_red_T      !< Transpose of T_red [-]
    TYPE(IList) , DIMENSION(:), ALLOCATABLE  :: NodesDOF      !< DOF indices of each nodes in unconstrained assembled system  [-]
    TYPE(IList) , DIMENSION(:), ALLOCATABLE  :: NodesDOFred      !< DOF indices of each nodes in constrained assembled system  [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: ElemsDOF      !< 12 DOF indices of node 1 and 2 of a given member in unconstrained assembled system  [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: DOFred2Nodes      !< nDOFRed x 3, for each constrained DOF, col1 node index, col2 number of DOF, col3 DOF starting from 1 [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: CtrlElem2Channel      !< nCtrlCable x 2, for each CtrlCable, Elem index, and Channel Index [-]
    INTEGER(IntKi)  :: nDOFM = 0_IntKi      !< retained degrees of freedom (modes) [-]
    INTEGER(IntKi)  :: SttcSolve = 0_IntKi      !< Solve dynamics about static equilibrium point (flag) [-]
    LOGICAL  :: GuyanLoadCorrection = .false.      !< Add Extra lever arm contribution to interface reaction outputs [-]
    LOGICAL  :: Floating = .false.      !< True if floating bottom (the 6 DOF are free at all reaction nodes) [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: KMMDiag      !< Diagonal coefficients of Kmm (OmegaM squared) [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: CMMDiag      !< Diagonal coefficients of Cmm (~2 Zeta OmegaM)) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: MMB      !< Matrix after C-B reduction (transpose of MBM [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: MBmmB      !< MBm * MmB, used for Y1 [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: C1_11      !< Coefficient of x in Y1 [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: C1_12      !< Coefficient of x in Y1 [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: D1_141      !< MBm PhiM^T [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: D1_142      !< TI^T PhiR^T [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PhiM      !< Coefficient of x in Y2 [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: C2_61      !< Coefficient of x in Y2 (URdotdot ULdotdot) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: C2_62      !< Coefficient of x in Y2 (URdotdot ULdotdot) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PhiRb_TI      !< Coefficient of u in Y2 (Phi_R bar * TI) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: D2_63      !< Coefficient of u in Y2 (URdotdot ULdotdot) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: D2_64      !< Coefficient of u in Y2 (URdotdot ULdotdot) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: MBB      !< Guyan Mass Matrix after C-B reduction [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: KBB      !< Guyan Stiffness Matrix after C-B reduction [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: CBB      !< Guyan Damping Matrix after C-B reduction [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: CMM      !< CB damping matrix [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: MBM      !< Matrix after C-B reduction [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PhiL_T      !< Transpose of Matrix of C-B  modes [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PhiLInvOmgL2      !< Matrix of C-B  modes times the inverse of OmegaL**2 (Phi_L*(Omg**2)^-1) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: KLLm1      !< KLL^{-1}, inverse of matrix KLL, for static solve only [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: AM2Jac      !< Jacobian (factored) for Adams-Boulton 2nd order Integration [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: AM2JacPiv      !< Pivot array for Jacobian factorization (for Adams-Boulton 2nd order Integration) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: TI      !< Matrix to calculate TP reference point reaction at top of structure [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: TIreact      !< Matrix to calculate single point reaction at base of structure [-]
    INTEGER(IntKi)  :: nNodes = 0_IntKi      !< Total number of nodes [-]
    INTEGER(IntKi)  :: nNodes_I = 0_IntKi      !< Number of Interface nodes [-]
    INTEGER(IntKi)  :: nNodes_L = 0_IntKi      !< Number of Internal nodes [-]
    INTEGER(IntKi)  :: nNodes_C = 0_IntKi      !< Number of joints with reactions [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: Nodes_I      !< Interface degree of freedoms [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: Nodes_L      !< Internal nodes (not interface nor reaction) [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: Nodes_C      !< React degree of freedoms [-]
    INTEGER(IntKi)  :: nDOFI__ = 0_IntKi      !< Size of IDI__ [-]
    INTEGER(IntKi)  :: nDOFI_Rb = 0_IntKi      !< Size of IDI_Rb [-]
    INTEGER(IntKi)  :: nDOFI_F = 0_IntKi      !< Size of IDI_F [-]
    INTEGER(IntKi)  :: nDOFL_L = 0_IntKi      !< Size of IDL_L [-]
    INTEGER(IntKi)  :: nDOFC__ = 0_IntKi      !< Size of IDC__ [-]
    INTEGER(IntKi)  :: nDOFC_Rb = 0_IntKi      !< Size of IDC_Rb [-]
    INTEGER(IntKi)  :: nDOFC_L = 0_IntKi      !< Size of IDC_L [-]
    INTEGER(IntKi)  :: nDOFC_F = 0_IntKi      !< Size of IDC_F [-]
    INTEGER(IntKi)  :: nDOFR__ = 0_IntKi      !< Size of IDR__ [-]
    INTEGER(IntKi)  :: nDOF__Rb = 0_IntKi      !< Size of ID__Rb [-]
    INTEGER(IntKi)  :: nDOF__L = 0_IntKi      !< Size of ID__L [-]
    INTEGER(IntKi)  :: nDOF__F = 0_IntKi      !< Size of ID__F [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: IDI__      !< Index of all Interface DOFs [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: IDI_Rb      !< Index array of the interface (nodes connect to TP) dofs that are retained/master/follower DOFs [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: IDI_F      !< Index array of the interface (nodes connect to TP) dofs that are fixed DOF [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: IDL_L      !< Index array of the internal dofs coming from internal nodes [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: IDC__      !< Index of all bottom DOF [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: IDC_Rb      !< Index array of the contraint dofs that are retained/master/follower DOF [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: IDC_L      !< Index array of the contraint dofs that are follower/internal DOF [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: IDC_F      !< Index array of the contraint dofs that are fixd DOF [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: IDR__      !< Index array of the interface and restraint dofs [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: ID__Rb      !< Index array of all the retained/leader/master dofs (from any nodes of the structure) [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: ID__L      !< Index array of all the follower/internal dofs (from any nodes of the structure) [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: ID__F      !< Index array of the DOF that are fixed (from any nodes of the structure) [-]
    INTEGER(IntKi)  :: NMOutputs = 0_IntKi      !< Number of members whose output is written [-]
    INTEGER(IntKi)  :: NumOuts = 0_IntKi      !< Number of output channels read from input file [-]
    INTEGER(IntKi)  :: OutSwtch = 0_IntKi      !< Output Requested Channels to local or global output file [1/2/3] [-]
    INTEGER(IntKi)  :: UnJckF = 0_IntKi      !< Unit of SD ouput file [-]
    CHARACTER(1)  :: Delim      !< Column delimiter for output text files [-]
    CHARACTER(20)  :: OutFmt      !< Format for Output [-]
    CHARACTER(20)  :: OutSFmt      !< Format for Output Headers [-]
    TYPE(MeshAuxDataType) , DIMENSION(:), ALLOCATABLE  :: MoutLst      !< List of user requested members and nodes [-]
    TYPE(MeshAuxDataType) , DIMENSION(:), ALLOCATABLE  :: MoutLst2      !< List of all member joint nodes and elements for output [-]
    TYPE(MeshAuxDataType) , DIMENSION(:), ALLOCATABLE  :: MoutLst3      !< List of all member joint nodes and elements for output [-]
    TYPE(OutParmType) , DIMENSION(:), ALLOCATABLE  :: OutParam      !< An array holding names, units, and indices of all of the selected output channels. # logical [-]
    LOGICAL  :: OutAll = .false.      !< Flag to output or not all joint forces [-]
    INTEGER(IntKi)  :: OutCBModes = 0_IntKi      !< Flag to output CB and Guyan modes to a given format [-]
    INTEGER(IntKi)  :: OutFEMModes = 0_IntKi      !< Flag to output FEM modes to a given format [-]
    LOGICAL  :: OutReact = .false.      !< Flag to check whether reactions are requested [-]
    INTEGER(IntKi)  :: OutAllInt = 0_IntKi      !< Integer version of OutAll [-]
    INTEGER(IntKi)  :: OutAllDims = 0_IntKi      !< Integer version of OutAll [-]
    INTEGER(IntKi)  :: OutDec = 0_IntKi      !< Output Decimation for Requested Channels [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: Jac_u_indx      !< matrix to help fill/pack the u vector in computing the jacobian [-]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: du      !< vector that determines size of perturbation for u (inputs) [-]
    REAL(R8Ki) , DIMENSION(1:2)  :: dx = 0.0_R8Ki      !< vector that determines size of perturbation for x (continuous states) [-]
    INTEGER(IntKi)  :: Jac_ny = 0_IntKi      !< number of outputs in jacobian matrix [-]
    INTEGER(IntKi)  :: Jac_nx = 0_IntKi      !< half the number of continuous states in jacobian matrix [-]
    LOGICAL  :: RotStates = .false.      !< Orient states in rotating frame during linearization? (flag) [-]
  END TYPE SD_ParameterType
! =======================
! =========  SD_InputType  =======
  TYPE, PUBLIC :: SD_InputType
    TYPE(MeshType)  :: TPMesh      !< Transition piece inputs on a point mesh [-]
    TYPE(MeshType)  :: LMesh      !< Point mesh for interior node inputs [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: CableDeltaL      !< Cable tension, control input [-]
  END TYPE SD_InputType
! =======================
! =========  SD_OutputType  =======
  TYPE, PUBLIC :: SD_OutputType
    TYPE(MeshType)  :: Y1Mesh      !< Transition piece outputs on a point mesh [-]
    TYPE(MeshType)  :: Y2Mesh      !< Interior+Interface nodes rigid body displacements + elastic velocities and accelerations on a point mesh [-]
    TYPE(MeshType)  :: Y3Mesh      !< Interior+Interface nodes full elastic displacements/velocities and accelerations on a point mesh [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WriteOutput      !< Data to be written to an output file [-]
  END TYPE SD_OutputType
! =======================
CONTAINS

subroutine SD_CopyIList(SrcIListData, DstIListData, CtrlCode, ErrStat, ErrMsg)
   type(IList), intent(in) :: SrcIListData
   type(IList), intent(inout) :: DstIListData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'SD_CopyIList'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcIListData%List)) then
      LB(1:1) = lbound(SrcIListData%List)
      UB(1:1) = ubound(SrcIListData%List)
      if (.not. allocated(DstIListData%List)) then
         allocate(DstIListData%List(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstIListData%List.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstIListData%List = SrcIListData%List
   end if
end subroutine

subroutine SD_DestroyIList(IListData, ErrStat, ErrMsg)
   type(IList), intent(inout) :: IListData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SD_DestroyIList'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(IListData%List)) then
      deallocate(IListData%List)
   end if
end subroutine

subroutine SD_PackIList(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(IList), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SD_PackIList'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%List)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SD_UnPackIList(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(IList), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SD_UnPackIList'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%List); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SD_CopyMeshAuxDataType(SrcMeshAuxDataTypeData, DstMeshAuxDataTypeData, CtrlCode, ErrStat, ErrMsg)
   type(MeshAuxDataType), intent(in) :: SrcMeshAuxDataTypeData
   type(MeshAuxDataType), intent(inout) :: DstMeshAuxDataTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(4), UB(4)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'SD_CopyMeshAuxDataType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstMeshAuxDataTypeData%MemberID = SrcMeshAuxDataTypeData%MemberID
   DstMeshAuxDataTypeData%NOutCnt = SrcMeshAuxDataTypeData%NOutCnt
   if (allocated(SrcMeshAuxDataTypeData%NodeCnt)) then
      LB(1:1) = lbound(SrcMeshAuxDataTypeData%NodeCnt)
      UB(1:1) = ubound(SrcMeshAuxDataTypeData%NodeCnt)
      if (.not. allocated(DstMeshAuxDataTypeData%NodeCnt)) then
         allocate(DstMeshAuxDataTypeData%NodeCnt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMeshAuxDataTypeData%NodeCnt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMeshAuxDataTypeData%NodeCnt = SrcMeshAuxDataTypeData%NodeCnt
   end if
   if (allocated(SrcMeshAuxDataTypeData%NodeIDs)) then
      LB(1:1) = lbound(SrcMeshAuxDataTypeData%NodeIDs)
      UB(1:1) = ubound(SrcMeshAuxDataTypeData%NodeIDs)
      if (.not. allocated(DstMeshAuxDataTypeData%NodeIDs)) then
         allocate(DstMeshAuxDataTypeData%NodeIDs(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMeshAuxDataTypeData%NodeIDs.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMeshAuxDataTypeData%NodeIDs = SrcMeshAuxDataTypeData%NodeIDs
   end if
   if (allocated(SrcMeshAuxDataTypeData%ElmIDs)) then
      LB(1:2) = lbound(SrcMeshAuxDataTypeData%ElmIDs)
      UB(1:2) = ubound(SrcMeshAuxDataTypeData%ElmIDs)
      if (.not. allocated(DstMeshAuxDataTypeData%ElmIDs)) then
         allocate(DstMeshAuxDataTypeData%ElmIDs(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMeshAuxDataTypeData%ElmIDs.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMeshAuxDataTypeData%ElmIDs = SrcMeshAuxDataTypeData%ElmIDs
   end if
   if (allocated(SrcMeshAuxDataTypeData%ElmNds)) then
      LB(1:2) = lbound(SrcMeshAuxDataTypeData%ElmNds)
      UB(1:2) = ubound(SrcMeshAuxDataTypeData%ElmNds)
      if (.not. allocated(DstMeshAuxDataTypeData%ElmNds)) then
         allocate(DstMeshAuxDataTypeData%ElmNds(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMeshAuxDataTypeData%ElmNds.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMeshAuxDataTypeData%ElmNds = SrcMeshAuxDataTypeData%ElmNds
   end if
   if (allocated(SrcMeshAuxDataTypeData%Me)) then
      LB(1:4) = lbound(SrcMeshAuxDataTypeData%Me)
      UB(1:4) = ubound(SrcMeshAuxDataTypeData%Me)
      if (.not. allocated(DstMeshAuxDataTypeData%Me)) then
         allocate(DstMeshAuxDataTypeData%Me(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMeshAuxDataTypeData%Me.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMeshAuxDataTypeData%Me = SrcMeshAuxDataTypeData%Me
   end if
   if (allocated(SrcMeshAuxDataTypeData%Ke)) then
      LB(1:4) = lbound(SrcMeshAuxDataTypeData%Ke)
      UB(1:4) = ubound(SrcMeshAuxDataTypeData%Ke)
      if (.not. allocated(DstMeshAuxDataTypeData%Ke)) then
         allocate(DstMeshAuxDataTypeData%Ke(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMeshAuxDataTypeData%Ke.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMeshAuxDataTypeData%Ke = SrcMeshAuxDataTypeData%Ke
   end if
   if (allocated(SrcMeshAuxDataTypeData%Fg)) then
      LB(1:3) = lbound(SrcMeshAuxDataTypeData%Fg)
      UB(1:3) = ubound(SrcMeshAuxDataTypeData%Fg)
      if (.not. allocated(DstMeshAuxDataTypeData%Fg)) then
         allocate(DstMeshAuxDataTypeData%Fg(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMeshAuxDataTypeData%Fg.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMeshAuxDataTypeData%Fg = SrcMeshAuxDataTypeData%Fg
   end if
end subroutine

subroutine SD_DestroyMeshAuxDataType(MeshAuxDataTypeData, ErrStat, ErrMsg)
   type(MeshAuxDataType), intent(inout) :: MeshAuxDataTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SD_DestroyMeshAuxDataType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(MeshAuxDataTypeData%NodeCnt)) then
      deallocate(MeshAuxDataTypeData%NodeCnt)
   end if
   if (allocated(MeshAuxDataTypeData%NodeIDs)) then
      deallocate(MeshAuxDataTypeData%NodeIDs)
   end if
   if (allocated(MeshAuxDataTypeData%ElmIDs)) then
      deallocate(MeshAuxDataTypeData%ElmIDs)
   end if
   if (allocated(MeshAuxDataTypeData%ElmNds)) then
      deallocate(MeshAuxDataTypeData%ElmNds)
   end if
   if (allocated(MeshAuxDataTypeData%Me)) then
      deallocate(MeshAuxDataTypeData%Me)
   end if
   if (allocated(MeshAuxDataTypeData%Ke)) then
      deallocate(MeshAuxDataTypeData%Ke)
   end if
   if (allocated(MeshAuxDataTypeData%Fg)) then
      deallocate(MeshAuxDataTypeData%Fg)
   end if
end subroutine

subroutine SD_PackMeshAuxDataType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(MeshAuxDataType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SD_PackMeshAuxDataType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%MemberID)
   call RegPack(RF, InData%NOutCnt)
   call RegPackAlloc(RF, InData%NodeCnt)
   call RegPackAlloc(RF, InData%NodeIDs)
   call RegPackAlloc(RF, InData%ElmIDs)
   call RegPackAlloc(RF, InData%ElmNds)
   call RegPackAlloc(RF, InData%Me)
   call RegPackAlloc(RF, InData%Ke)
   call RegPackAlloc(RF, InData%Fg)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SD_UnPackMeshAuxDataType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(MeshAuxDataType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SD_UnPackMeshAuxDataType'
   integer(B4Ki)   :: LB(4), UB(4)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%MemberID); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NOutCnt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%NodeCnt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%NodeIDs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%ElmIDs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%ElmNds); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Me); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Ke); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Fg); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SD_CopyCB_MatArrays(SrcCB_MatArraysData, DstCB_MatArraysData, CtrlCode, ErrStat, ErrMsg)
   type(CB_MatArrays), intent(in) :: SrcCB_MatArraysData
   type(CB_MatArrays), intent(inout) :: DstCB_MatArraysData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'SD_CopyCB_MatArrays'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcCB_MatArraysData%MBB)) then
      LB(1:2) = lbound(SrcCB_MatArraysData%MBB)
      UB(1:2) = ubound(SrcCB_MatArraysData%MBB)
      if (.not. allocated(DstCB_MatArraysData%MBB)) then
         allocate(DstCB_MatArraysData%MBB(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstCB_MatArraysData%MBB.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstCB_MatArraysData%MBB = SrcCB_MatArraysData%MBB
   end if
   if (allocated(SrcCB_MatArraysData%MBM)) then
      LB(1:2) = lbound(SrcCB_MatArraysData%MBM)
      UB(1:2) = ubound(SrcCB_MatArraysData%MBM)
      if (.not. allocated(DstCB_MatArraysData%MBM)) then
         allocate(DstCB_MatArraysData%MBM(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstCB_MatArraysData%MBM.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstCB_MatArraysData%MBM = SrcCB_MatArraysData%MBM
   end if
   if (allocated(SrcCB_MatArraysData%KBB)) then
      LB(1:2) = lbound(SrcCB_MatArraysData%KBB)
      UB(1:2) = ubound(SrcCB_MatArraysData%KBB)
      if (.not. allocated(DstCB_MatArraysData%KBB)) then
         allocate(DstCB_MatArraysData%KBB(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstCB_MatArraysData%KBB.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstCB_MatArraysData%KBB = SrcCB_MatArraysData%KBB
   end if
   if (allocated(SrcCB_MatArraysData%PhiL)) then
      LB(1:2) = lbound(SrcCB_MatArraysData%PhiL)
      UB(1:2) = ubound(SrcCB_MatArraysData%PhiL)
      if (.not. allocated(DstCB_MatArraysData%PhiL)) then
         allocate(DstCB_MatArraysData%PhiL(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstCB_MatArraysData%PhiL.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstCB_MatArraysData%PhiL = SrcCB_MatArraysData%PhiL
   end if
   if (allocated(SrcCB_MatArraysData%PhiR)) then
      LB(1:2) = lbound(SrcCB_MatArraysData%PhiR)
      UB(1:2) = ubound(SrcCB_MatArraysData%PhiR)
      if (.not. allocated(DstCB_MatArraysData%PhiR)) then
         allocate(DstCB_MatArraysData%PhiR(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstCB_MatArraysData%PhiR.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstCB_MatArraysData%PhiR = SrcCB_MatArraysData%PhiR
   end if
   if (allocated(SrcCB_MatArraysData%OmegaL)) then
      LB(1:1) = lbound(SrcCB_MatArraysData%OmegaL)
      UB(1:1) = ubound(SrcCB_MatArraysData%OmegaL)
      if (.not. allocated(DstCB_MatArraysData%OmegaL)) then
         allocate(DstCB_MatArraysData%OmegaL(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstCB_MatArraysData%OmegaL.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstCB_MatArraysData%OmegaL = SrcCB_MatArraysData%OmegaL
   end if
end subroutine

subroutine SD_DestroyCB_MatArrays(CB_MatArraysData, ErrStat, ErrMsg)
   type(CB_MatArrays), intent(inout) :: CB_MatArraysData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SD_DestroyCB_MatArrays'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(CB_MatArraysData%MBB)) then
      deallocate(CB_MatArraysData%MBB)
   end if
   if (allocated(CB_MatArraysData%MBM)) then
      deallocate(CB_MatArraysData%MBM)
   end if
   if (allocated(CB_MatArraysData%KBB)) then
      deallocate(CB_MatArraysData%KBB)
   end if
   if (allocated(CB_MatArraysData%PhiL)) then
      deallocate(CB_MatArraysData%PhiL)
   end if
   if (allocated(CB_MatArraysData%PhiR)) then
      deallocate(CB_MatArraysData%PhiR)
   end if
   if (allocated(CB_MatArraysData%OmegaL)) then
      deallocate(CB_MatArraysData%OmegaL)
   end if
end subroutine

subroutine SD_PackCB_MatArrays(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(CB_MatArrays), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SD_PackCB_MatArrays'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%MBB)
   call RegPackAlloc(RF, InData%MBM)
   call RegPackAlloc(RF, InData%KBB)
   call RegPackAlloc(RF, InData%PhiL)
   call RegPackAlloc(RF, InData%PhiR)
   call RegPackAlloc(RF, InData%OmegaL)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SD_UnPackCB_MatArrays(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(CB_MatArrays), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SD_UnPackCB_MatArrays'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%MBB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%MBM); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%KBB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PhiL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PhiR); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%OmegaL); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SD_CopyElemPropType(SrcElemPropTypeData, DstElemPropTypeData, CtrlCode, ErrStat, ErrMsg)
   type(ElemPropType), intent(in) :: SrcElemPropTypeData
   type(ElemPropType), intent(inout) :: DstElemPropTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SD_CopyElemPropType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstElemPropTypeData%eType = SrcElemPropTypeData%eType
   DstElemPropTypeData%Length = SrcElemPropTypeData%Length
   DstElemPropTypeData%Ixx = SrcElemPropTypeData%Ixx
   DstElemPropTypeData%Iyy = SrcElemPropTypeData%Iyy
   DstElemPropTypeData%Jzz = SrcElemPropTypeData%Jzz
   DstElemPropTypeData%Jt = SrcElemPropTypeData%Jt
   DstElemPropTypeData%Shear = SrcElemPropTypeData%Shear
   DstElemPropTypeData%Kappa_x = SrcElemPropTypeData%Kappa_x
   DstElemPropTypeData%Kappa_y = SrcElemPropTypeData%Kappa_y
   DstElemPropTypeData%YoungE = SrcElemPropTypeData%YoungE
   DstElemPropTypeData%ShearG = SrcElemPropTypeData%ShearG
   DstElemPropTypeData%D = SrcElemPropTypeData%D
   DstElemPropTypeData%Sa = SrcElemPropTypeData%Sa
   DstElemPropTypeData%Sb = SrcElemPropTypeData%Sb
   DstElemPropTypeData%Area = SrcElemPropTypeData%Area
   DstElemPropTypeData%Rho = SrcElemPropTypeData%Rho
   DstElemPropTypeData%T0 = SrcElemPropTypeData%T0
   DstElemPropTypeData%k11 = SrcElemPropTypeData%k11
   DstElemPropTypeData%k12 = SrcElemPropTypeData%k12
   DstElemPropTypeData%k13 = SrcElemPropTypeData%k13
   DstElemPropTypeData%k14 = SrcElemPropTypeData%k14
   DstElemPropTypeData%k15 = SrcElemPropTypeData%k15
   DstElemPropTypeData%k16 = SrcElemPropTypeData%k16
   DstElemPropTypeData%k22 = SrcElemPropTypeData%k22
   DstElemPropTypeData%k23 = SrcElemPropTypeData%k23
   DstElemPropTypeData%k24 = SrcElemPropTypeData%k24
   DstElemPropTypeData%k25 = SrcElemPropTypeData%k25
   DstElemPropTypeData%k26 = SrcElemPropTypeData%k26
   DstElemPropTypeData%k33 = SrcElemPropTypeData%k33
   DstElemPropTypeData%k34 = SrcElemPropTypeData%k34
   DstElemPropTypeData%k35 = SrcElemPropTypeData%k35
   DstElemPropTypeData%k36 = SrcElemPropTypeData%k36
   DstElemPropTypeData%k44 = SrcElemPropTypeData%k44
   DstElemPropTypeData%k45 = SrcElemPropTypeData%k45
   DstElemPropTypeData%k46 = SrcElemPropTypeData%k46
   DstElemPropTypeData%k55 = SrcElemPropTypeData%k55
   DstElemPropTypeData%k56 = SrcElemPropTypeData%k56
   DstElemPropTypeData%k66 = SrcElemPropTypeData%k66
   DstElemPropTypeData%DirCos = SrcElemPropTypeData%DirCos
end subroutine

subroutine SD_DestroyElemPropType(ElemPropTypeData, ErrStat, ErrMsg)
   type(ElemPropType), intent(inout) :: ElemPropTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SD_DestroyElemPropType'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine SD_PackElemPropType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ElemPropType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SD_PackElemPropType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%eType)
   call RegPack(RF, InData%Length)
   call RegPack(RF, InData%Ixx)
   call RegPack(RF, InData%Iyy)
   call RegPack(RF, InData%Jzz)
   call RegPack(RF, InData%Jt)
   call RegPack(RF, InData%Shear)
   call RegPack(RF, InData%Kappa_x)
   call RegPack(RF, InData%Kappa_y)
   call RegPack(RF, InData%YoungE)
   call RegPack(RF, InData%ShearG)
   call RegPack(RF, InData%D)
   call RegPack(RF, InData%Sa)
   call RegPack(RF, InData%Sb)
   call RegPack(RF, InData%Area)
   call RegPack(RF, InData%Rho)
   call RegPack(RF, InData%T0)
   call RegPack(RF, InData%k11)
   call RegPack(RF, InData%k12)
   call RegPack(RF, InData%k13)
   call RegPack(RF, InData%k14)
   call RegPack(RF, InData%k15)
   call RegPack(RF, InData%k16)
   call RegPack(RF, InData%k22)
   call RegPack(RF, InData%k23)
   call RegPack(RF, InData%k24)
   call RegPack(RF, InData%k25)
   call RegPack(RF, InData%k26)
   call RegPack(RF, InData%k33)
   call RegPack(RF, InData%k34)
   call RegPack(RF, InData%k35)
   call RegPack(RF, InData%k36)
   call RegPack(RF, InData%k44)
   call RegPack(RF, InData%k45)
   call RegPack(RF, InData%k46)
   call RegPack(RF, InData%k55)
   call RegPack(RF, InData%k56)
   call RegPack(RF, InData%k66)
   call RegPack(RF, InData%DirCos)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SD_UnPackElemPropType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ElemPropType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SD_UnPackElemPropType'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%eType); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Length); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Ixx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Iyy); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Jzz); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Jt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Shear); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Kappa_x); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Kappa_y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YoungE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ShearG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%D); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Sa); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Sb); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Area); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Rho); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%T0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k11); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k12); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k13); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k14); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k15); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k16); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k22); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k23); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k24); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k25); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k26); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k33); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k34); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k35); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k36); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k44); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k45); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k46); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k55); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k56); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k66); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DirCos); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SD_CopyInitInput(SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg)
   type(SD_InitInputType), intent(inout) :: SrcInitInputData
   type(SD_InitInputType), intent(inout) :: DstInitInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SD_CopyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInitInputData%SDInputFile = SrcInitInputData%SDInputFile
   DstInitInputData%RootName = SrcInitInputData%RootName
   DstInitInputData%g = SrcInitInputData%g
   DstInitInputData%WtrDpth = SrcInitInputData%WtrDpth
   DstInitInputData%TP_RefPoint = SrcInitInputData%TP_RefPoint
   DstInitInputData%SubRotateZ = SrcInitInputData%SubRotateZ
   if (allocated(SrcInitInputData%SoilStiffness)) then
      LB(1:3) = lbound(SrcInitInputData%SoilStiffness)
      UB(1:3) = ubound(SrcInitInputData%SoilStiffness)
      if (.not. allocated(DstInitInputData%SoilStiffness)) then
         allocate(DstInitInputData%SoilStiffness(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%SoilStiffness.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%SoilStiffness = SrcInitInputData%SoilStiffness
   end if
   call MeshCopy(SrcInitInputData%SoilMesh, DstInitInputData%SoilMesh, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstInitInputData%Linearize = SrcInitInputData%Linearize
end subroutine

subroutine SD_DestroyInitInput(InitInputData, ErrStat, ErrMsg)
   type(SD_InitInputType), intent(inout) :: InitInputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SD_DestroyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InitInputData%SoilStiffness)) then
      deallocate(InitInputData%SoilStiffness)
   end if
   call MeshDestroy( InitInputData%SoilMesh, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine SD_PackInitInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SD_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SD_PackInitInput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%SDInputFile)
   call RegPack(RF, InData%RootName)
   call RegPack(RF, InData%g)
   call RegPack(RF, InData%WtrDpth)
   call RegPack(RF, InData%TP_RefPoint)
   call RegPack(RF, InData%SubRotateZ)
   call RegPackAlloc(RF, InData%SoilStiffness)
   call MeshPack(RF, InData%SoilMesh) 
   call RegPack(RF, InData%Linearize)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SD_UnPackInitInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SD_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SD_UnPackInitInput'
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%SDInputFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%g); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WtrDpth); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TP_RefPoint); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SubRotateZ); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%SoilStiffness); if (RegCheckErr(RF, RoutineName)) return
   call MeshUnpack(RF, OutData%SoilMesh) ! SoilMesh 
   call RegUnpack(RF, OutData%Linearize); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SD_CopyInitOutput(SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg)
   type(SD_InitOutputType), intent(in) :: SrcInitOutputData
   type(SD_InitOutputType), intent(inout) :: DstInitOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SD_CopyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcInitOutputData%WriteOutputHdr)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputHdr)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputHdr)
      if (.not. allocated(DstInitOutputData%WriteOutputHdr)) then
         allocate(DstInitOutputData%WriteOutputHdr(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputHdr.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputHdr = SrcInitOutputData%WriteOutputHdr
   end if
   if (allocated(SrcInitOutputData%WriteOutputUnt)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputUnt)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputUnt)
      if (.not. allocated(DstInitOutputData%WriteOutputUnt)) then
         allocate(DstInitOutputData%WriteOutputUnt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputUnt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputUnt = SrcInitOutputData%WriteOutputUnt
   end if
   call NWTC_Library_CopyProgDesc(SrcInitOutputData%Ver, DstInitOutputData%Ver, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcInitOutputData%LinNames_y)) then
      LB(1:1) = lbound(SrcInitOutputData%LinNames_y)
      UB(1:1) = ubound(SrcInitOutputData%LinNames_y)
      if (.not. allocated(DstInitOutputData%LinNames_y)) then
         allocate(DstInitOutputData%LinNames_y(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LinNames_y.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%LinNames_y = SrcInitOutputData%LinNames_y
   end if
   if (allocated(SrcInitOutputData%LinNames_x)) then
      LB(1:1) = lbound(SrcInitOutputData%LinNames_x)
      UB(1:1) = ubound(SrcInitOutputData%LinNames_x)
      if (.not. allocated(DstInitOutputData%LinNames_x)) then
         allocate(DstInitOutputData%LinNames_x(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LinNames_x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%LinNames_x = SrcInitOutputData%LinNames_x
   end if
   if (allocated(SrcInitOutputData%LinNames_u)) then
      LB(1:1) = lbound(SrcInitOutputData%LinNames_u)
      UB(1:1) = ubound(SrcInitOutputData%LinNames_u)
      if (.not. allocated(DstInitOutputData%LinNames_u)) then
         allocate(DstInitOutputData%LinNames_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LinNames_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%LinNames_u = SrcInitOutputData%LinNames_u
   end if
   if (allocated(SrcInitOutputData%RotFrame_y)) then
      LB(1:1) = lbound(SrcInitOutputData%RotFrame_y)
      UB(1:1) = ubound(SrcInitOutputData%RotFrame_y)
      if (.not. allocated(DstInitOutputData%RotFrame_y)) then
         allocate(DstInitOutputData%RotFrame_y(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%RotFrame_y.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%RotFrame_y = SrcInitOutputData%RotFrame_y
   end if
   if (allocated(SrcInitOutputData%RotFrame_x)) then
      LB(1:1) = lbound(SrcInitOutputData%RotFrame_x)
      UB(1:1) = ubound(SrcInitOutputData%RotFrame_x)
      if (.not. allocated(DstInitOutputData%RotFrame_x)) then
         allocate(DstInitOutputData%RotFrame_x(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%RotFrame_x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%RotFrame_x = SrcInitOutputData%RotFrame_x
   end if
   if (allocated(SrcInitOutputData%RotFrame_u)) then
      LB(1:1) = lbound(SrcInitOutputData%RotFrame_u)
      UB(1:1) = ubound(SrcInitOutputData%RotFrame_u)
      if (.not. allocated(DstInitOutputData%RotFrame_u)) then
         allocate(DstInitOutputData%RotFrame_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%RotFrame_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%RotFrame_u = SrcInitOutputData%RotFrame_u
   end if
   if (allocated(SrcInitOutputData%IsLoad_u)) then
      LB(1:1) = lbound(SrcInitOutputData%IsLoad_u)
      UB(1:1) = ubound(SrcInitOutputData%IsLoad_u)
      if (.not. allocated(DstInitOutputData%IsLoad_u)) then
         allocate(DstInitOutputData%IsLoad_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%IsLoad_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%IsLoad_u = SrcInitOutputData%IsLoad_u
   end if
   if (allocated(SrcInitOutputData%DerivOrder_x)) then
      LB(1:1) = lbound(SrcInitOutputData%DerivOrder_x)
      UB(1:1) = ubound(SrcInitOutputData%DerivOrder_x)
      if (.not. allocated(DstInitOutputData%DerivOrder_x)) then
         allocate(DstInitOutputData%DerivOrder_x(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%DerivOrder_x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%DerivOrder_x = SrcInitOutputData%DerivOrder_x
   end if
   if (allocated(SrcInitOutputData%CableCChanRqst)) then
      LB(1:1) = lbound(SrcInitOutputData%CableCChanRqst)
      UB(1:1) = ubound(SrcInitOutputData%CableCChanRqst)
      if (.not. allocated(DstInitOutputData%CableCChanRqst)) then
         allocate(DstInitOutputData%CableCChanRqst(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%CableCChanRqst.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%CableCChanRqst = SrcInitOutputData%CableCChanRqst
   end if
end subroutine

subroutine SD_DestroyInitOutput(InitOutputData, ErrStat, ErrMsg)
   type(SD_InitOutputType), intent(inout) :: InitOutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SD_DestroyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InitOutputData%WriteOutputHdr)) then
      deallocate(InitOutputData%WriteOutputHdr)
   end if
   if (allocated(InitOutputData%WriteOutputUnt)) then
      deallocate(InitOutputData%WriteOutputUnt)
   end if
   call NWTC_Library_DestroyProgDesc(InitOutputData%Ver, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(InitOutputData%LinNames_y)) then
      deallocate(InitOutputData%LinNames_y)
   end if
   if (allocated(InitOutputData%LinNames_x)) then
      deallocate(InitOutputData%LinNames_x)
   end if
   if (allocated(InitOutputData%LinNames_u)) then
      deallocate(InitOutputData%LinNames_u)
   end if
   if (allocated(InitOutputData%RotFrame_y)) then
      deallocate(InitOutputData%RotFrame_y)
   end if
   if (allocated(InitOutputData%RotFrame_x)) then
      deallocate(InitOutputData%RotFrame_x)
   end if
   if (allocated(InitOutputData%RotFrame_u)) then
      deallocate(InitOutputData%RotFrame_u)
   end if
   if (allocated(InitOutputData%IsLoad_u)) then
      deallocate(InitOutputData%IsLoad_u)
   end if
   if (allocated(InitOutputData%DerivOrder_x)) then
      deallocate(InitOutputData%DerivOrder_x)
   end if
   if (allocated(InitOutputData%CableCChanRqst)) then
      deallocate(InitOutputData%CableCChanRqst)
   end if
end subroutine

subroutine SD_PackInitOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SD_InitOutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SD_PackInitOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%WriteOutputHdr)
   call RegPackAlloc(RF, InData%WriteOutputUnt)
   call NWTC_Library_PackProgDesc(RF, InData%Ver) 
   call RegPackAlloc(RF, InData%LinNames_y)
   call RegPackAlloc(RF, InData%LinNames_x)
   call RegPackAlloc(RF, InData%LinNames_u)
   call RegPackAlloc(RF, InData%RotFrame_y)
   call RegPackAlloc(RF, InData%RotFrame_x)
   call RegPackAlloc(RF, InData%RotFrame_u)
   call RegPackAlloc(RF, InData%IsLoad_u)
   call RegPackAlloc(RF, InData%DerivOrder_x)
   call RegPackAlloc(RF, InData%CableCChanRqst)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SD_UnPackInitOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SD_InitOutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SD_UnPackInitOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%WriteOutputHdr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutputUnt); if (RegCheckErr(RF, RoutineName)) return
   call NWTC_Library_UnpackProgDesc(RF, OutData%Ver) ! Ver 
   call RegUnpackAlloc(RF, OutData%LinNames_y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LinNames_x); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LinNames_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RotFrame_y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RotFrame_x); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RotFrame_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%IsLoad_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%DerivOrder_x); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%CableCChanRqst); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SD_CopyInitType(SrcInitTypeData, DstInitTypeData, CtrlCode, ErrStat, ErrMsg)
   type(SD_InitType), intent(in) :: SrcInitTypeData
   type(SD_InitType), intent(inout) :: DstInitTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'SD_CopyInitType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInitTypeData%RootName = SrcInitTypeData%RootName
   DstInitTypeData%TP_RefPoint = SrcInitTypeData%TP_RefPoint
   DstInitTypeData%SubRotateZ = SrcInitTypeData%SubRotateZ
   DstInitTypeData%g = SrcInitTypeData%g
   DstInitTypeData%DT = SrcInitTypeData%DT
   DstInitTypeData%NJoints = SrcInitTypeData%NJoints
   DstInitTypeData%NPropSetsX = SrcInitTypeData%NPropSetsX
   DstInitTypeData%NPropSetsBC = SrcInitTypeData%NPropSetsBC
   DstInitTypeData%NPropSetsBR = SrcInitTypeData%NPropSetsBR
   DstInitTypeData%NPropSetsC = SrcInitTypeData%NPropSetsC
   DstInitTypeData%NPropSetsR = SrcInitTypeData%NPropSetsR
   DstInitTypeData%NPropSetsS = SrcInitTypeData%NPropSetsS
   DstInitTypeData%NCMass = SrcInitTypeData%NCMass
   DstInitTypeData%NCOSMs = SrcInitTypeData%NCOSMs
   DstInitTypeData%FEMMod = SrcInitTypeData%FEMMod
   DstInitTypeData%NDiv = SrcInitTypeData%NDiv
   DstInitTypeData%CBMod = SrcInitTypeData%CBMod
   if (allocated(SrcInitTypeData%Joints)) then
      LB(1:2) = lbound(SrcInitTypeData%Joints)
      UB(1:2) = ubound(SrcInitTypeData%Joints)
      if (.not. allocated(DstInitTypeData%Joints)) then
         allocate(DstInitTypeData%Joints(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitTypeData%Joints.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitTypeData%Joints = SrcInitTypeData%Joints
   end if
   if (allocated(SrcInitTypeData%PropSetsBC)) then
      LB(1:2) = lbound(SrcInitTypeData%PropSetsBC)
      UB(1:2) = ubound(SrcInitTypeData%PropSetsBC)
      if (.not. allocated(DstInitTypeData%PropSetsBC)) then
         allocate(DstInitTypeData%PropSetsBC(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitTypeData%PropSetsBC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitTypeData%PropSetsBC = SrcInitTypeData%PropSetsBC
   end if
   if (allocated(SrcInitTypeData%PropSetsBR)) then
      LB(1:2) = lbound(SrcInitTypeData%PropSetsBR)
      UB(1:2) = ubound(SrcInitTypeData%PropSetsBR)
      if (.not. allocated(DstInitTypeData%PropSetsBR)) then
         allocate(DstInitTypeData%PropSetsBR(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitTypeData%PropSetsBR.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitTypeData%PropSetsBR = SrcInitTypeData%PropSetsBR
   end if
   if (allocated(SrcInitTypeData%PropSetsC)) then
      LB(1:2) = lbound(SrcInitTypeData%PropSetsC)
      UB(1:2) = ubound(SrcInitTypeData%PropSetsC)
      if (.not. allocated(DstInitTypeData%PropSetsC)) then
         allocate(DstInitTypeData%PropSetsC(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitTypeData%PropSetsC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitTypeData%PropSetsC = SrcInitTypeData%PropSetsC
   end if
   if (allocated(SrcInitTypeData%PropSetsR)) then
      LB(1:2) = lbound(SrcInitTypeData%PropSetsR)
      UB(1:2) = ubound(SrcInitTypeData%PropSetsR)
      if (.not. allocated(DstInitTypeData%PropSetsR)) then
         allocate(DstInitTypeData%PropSetsR(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitTypeData%PropSetsR.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitTypeData%PropSetsR = SrcInitTypeData%PropSetsR
   end if
   if (allocated(SrcInitTypeData%PropSetsS)) then
      LB(1:2) = lbound(SrcInitTypeData%PropSetsS)
      UB(1:2) = ubound(SrcInitTypeData%PropSetsS)
      if (.not. allocated(DstInitTypeData%PropSetsS)) then
         allocate(DstInitTypeData%PropSetsS(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitTypeData%PropSetsS.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitTypeData%PropSetsS = SrcInitTypeData%PropSetsS
   end if
   if (allocated(SrcInitTypeData%PropSetsX)) then
      LB(1:2) = lbound(SrcInitTypeData%PropSetsX)
      UB(1:2) = ubound(SrcInitTypeData%PropSetsX)
      if (.not. allocated(DstInitTypeData%PropSetsX)) then
         allocate(DstInitTypeData%PropSetsX(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitTypeData%PropSetsX.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitTypeData%PropSetsX = SrcInitTypeData%PropSetsX
   end if
   if (allocated(SrcInitTypeData%COSMs)) then
      LB(1:2) = lbound(SrcInitTypeData%COSMs)
      UB(1:2) = ubound(SrcInitTypeData%COSMs)
      if (.not. allocated(DstInitTypeData%COSMs)) then
         allocate(DstInitTypeData%COSMs(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitTypeData%COSMs.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitTypeData%COSMs = SrcInitTypeData%COSMs
   end if
   if (allocated(SrcInitTypeData%CMass)) then
      LB(1:2) = lbound(SrcInitTypeData%CMass)
      UB(1:2) = ubound(SrcInitTypeData%CMass)
      if (.not. allocated(DstInitTypeData%CMass)) then
         allocate(DstInitTypeData%CMass(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitTypeData%CMass.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitTypeData%CMass = SrcInitTypeData%CMass
   end if
   if (allocated(SrcInitTypeData%JDampings)) then
      LB(1:1) = lbound(SrcInitTypeData%JDampings)
      UB(1:1) = ubound(SrcInitTypeData%JDampings)
      if (.not. allocated(DstInitTypeData%JDampings)) then
         allocate(DstInitTypeData%JDampings(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitTypeData%JDampings.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitTypeData%JDampings = SrcInitTypeData%JDampings
   end if
   DstInitTypeData%GuyanDampMod = SrcInitTypeData%GuyanDampMod
   DstInitTypeData%RayleighDamp = SrcInitTypeData%RayleighDamp
   DstInitTypeData%GuyanDampMat = SrcInitTypeData%GuyanDampMat
   if (allocated(SrcInitTypeData%Members)) then
      LB(1:2) = lbound(SrcInitTypeData%Members)
      UB(1:2) = ubound(SrcInitTypeData%Members)
      if (.not. allocated(DstInitTypeData%Members)) then
         allocate(DstInitTypeData%Members(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitTypeData%Members.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitTypeData%Members = SrcInitTypeData%Members
   end if
   if (allocated(SrcInitTypeData%MemberSpin)) then
      LB(1:1) = lbound(SrcInitTypeData%MemberSpin)
      UB(1:1) = ubound(SrcInitTypeData%MemberSpin)
      if (.not. allocated(DstInitTypeData%MemberSpin)) then
         allocate(DstInitTypeData%MemberSpin(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitTypeData%MemberSpin.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitTypeData%MemberSpin = SrcInitTypeData%MemberSpin
   end if
   if (allocated(SrcInitTypeData%SSOutList)) then
      LB(1:1) = lbound(SrcInitTypeData%SSOutList)
      UB(1:1) = ubound(SrcInitTypeData%SSOutList)
      if (.not. allocated(DstInitTypeData%SSOutList)) then
         allocate(DstInitTypeData%SSOutList(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitTypeData%SSOutList.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitTypeData%SSOutList = SrcInitTypeData%SSOutList
   end if
   DstInitTypeData%OutCOSM = SrcInitTypeData%OutCOSM
   DstInitTypeData%TabDelim = SrcInitTypeData%TabDelim
   if (allocated(SrcInitTypeData%SSIK)) then
      LB(1:2) = lbound(SrcInitTypeData%SSIK)
      UB(1:2) = ubound(SrcInitTypeData%SSIK)
      if (.not. allocated(DstInitTypeData%SSIK)) then
         allocate(DstInitTypeData%SSIK(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitTypeData%SSIK.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitTypeData%SSIK = SrcInitTypeData%SSIK
   end if
   if (allocated(SrcInitTypeData%SSIM)) then
      LB(1:2) = lbound(SrcInitTypeData%SSIM)
      UB(1:2) = ubound(SrcInitTypeData%SSIM)
      if (.not. allocated(DstInitTypeData%SSIM)) then
         allocate(DstInitTypeData%SSIM(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitTypeData%SSIM.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitTypeData%SSIM = SrcInitTypeData%SSIM
   end if
   if (allocated(SrcInitTypeData%SSIfile)) then
      LB(1:1) = lbound(SrcInitTypeData%SSIfile)
      UB(1:1) = ubound(SrcInitTypeData%SSIfile)
      if (.not. allocated(DstInitTypeData%SSIfile)) then
         allocate(DstInitTypeData%SSIfile(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitTypeData%SSIfile.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitTypeData%SSIfile = SrcInitTypeData%SSIfile
   end if
   if (allocated(SrcInitTypeData%Soil_K)) then
      LB(1:3) = lbound(SrcInitTypeData%Soil_K)
      UB(1:3) = ubound(SrcInitTypeData%Soil_K)
      if (.not. allocated(DstInitTypeData%Soil_K)) then
         allocate(DstInitTypeData%Soil_K(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitTypeData%Soil_K.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitTypeData%Soil_K = SrcInitTypeData%Soil_K
   end if
   if (allocated(SrcInitTypeData%Soil_Points)) then
      LB(1:2) = lbound(SrcInitTypeData%Soil_Points)
      UB(1:2) = ubound(SrcInitTypeData%Soil_Points)
      if (.not. allocated(DstInitTypeData%Soil_Points)) then
         allocate(DstInitTypeData%Soil_Points(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitTypeData%Soil_Points.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitTypeData%Soil_Points = SrcInitTypeData%Soil_Points
   end if
   if (allocated(SrcInitTypeData%Soil_Nodes)) then
      LB(1:1) = lbound(SrcInitTypeData%Soil_Nodes)
      UB(1:1) = ubound(SrcInitTypeData%Soil_Nodes)
      if (.not. allocated(DstInitTypeData%Soil_Nodes)) then
         allocate(DstInitTypeData%Soil_Nodes(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitTypeData%Soil_Nodes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitTypeData%Soil_Nodes = SrcInitTypeData%Soil_Nodes
   end if
   DstInitTypeData%NElem = SrcInitTypeData%NElem
   DstInitTypeData%NPropBC = SrcInitTypeData%NPropBC
   DstInitTypeData%NPropBR = SrcInitTypeData%NPropBR
   DstInitTypeData%NPropX = SrcInitTypeData%NPropX
   DstInitTypeData%NPropC = SrcInitTypeData%NPropC
   DstInitTypeData%NPropR = SrcInitTypeData%NPropR
   DstInitTypeData%NPropS = SrcInitTypeData%NPropS
   if (allocated(SrcInitTypeData%Nodes)) then
      LB(1:2) = lbound(SrcInitTypeData%Nodes)
      UB(1:2) = ubound(SrcInitTypeData%Nodes)
      if (.not. allocated(DstInitTypeData%Nodes)) then
         allocate(DstInitTypeData%Nodes(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitTypeData%Nodes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitTypeData%Nodes = SrcInitTypeData%Nodes
   end if
   if (allocated(SrcInitTypeData%PropsBC)) then
      LB(1:2) = lbound(SrcInitTypeData%PropsBC)
      UB(1:2) = ubound(SrcInitTypeData%PropsBC)
      if (.not. allocated(DstInitTypeData%PropsBC)) then
         allocate(DstInitTypeData%PropsBC(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitTypeData%PropsBC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitTypeData%PropsBC = SrcInitTypeData%PropsBC
   end if
   if (allocated(SrcInitTypeData%PropsBR)) then
      LB(1:2) = lbound(SrcInitTypeData%PropsBR)
      UB(1:2) = ubound(SrcInitTypeData%PropsBR)
      if (.not. allocated(DstInitTypeData%PropsBR)) then
         allocate(DstInitTypeData%PropsBR(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitTypeData%PropsBR.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitTypeData%PropsBR = SrcInitTypeData%PropsBR
   end if
   if (allocated(SrcInitTypeData%PropsC)) then
      LB(1:2) = lbound(SrcInitTypeData%PropsC)
      UB(1:2) = ubound(SrcInitTypeData%PropsC)
      if (.not. allocated(DstInitTypeData%PropsC)) then
         allocate(DstInitTypeData%PropsC(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitTypeData%PropsC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitTypeData%PropsC = SrcInitTypeData%PropsC
   end if
   if (allocated(SrcInitTypeData%PropsR)) then
      LB(1:2) = lbound(SrcInitTypeData%PropsR)
      UB(1:2) = ubound(SrcInitTypeData%PropsR)
      if (.not. allocated(DstInitTypeData%PropsR)) then
         allocate(DstInitTypeData%PropsR(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitTypeData%PropsR.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitTypeData%PropsR = SrcInitTypeData%PropsR
   end if
   if (allocated(SrcInitTypeData%PropsS)) then
      LB(1:2) = lbound(SrcInitTypeData%PropsS)
      UB(1:2) = ubound(SrcInitTypeData%PropsS)
      if (.not. allocated(DstInitTypeData%PropsS)) then
         allocate(DstInitTypeData%PropsS(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitTypeData%PropsS.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitTypeData%PropsS = SrcInitTypeData%PropsS
   end if
   if (allocated(SrcInitTypeData%K)) then
      LB(1:2) = lbound(SrcInitTypeData%K)
      UB(1:2) = ubound(SrcInitTypeData%K)
      if (.not. allocated(DstInitTypeData%K)) then
         allocate(DstInitTypeData%K(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitTypeData%K.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitTypeData%K = SrcInitTypeData%K
   end if
   if (allocated(SrcInitTypeData%M)) then
      LB(1:2) = lbound(SrcInitTypeData%M)
      UB(1:2) = ubound(SrcInitTypeData%M)
      if (.not. allocated(DstInitTypeData%M)) then
         allocate(DstInitTypeData%M(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitTypeData%M.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitTypeData%M = SrcInitTypeData%M
   end if
   if (allocated(SrcInitTypeData%ElemProps)) then
      LB(1:2) = lbound(SrcInitTypeData%ElemProps)
      UB(1:2) = ubound(SrcInitTypeData%ElemProps)
      if (.not. allocated(DstInitTypeData%ElemProps)) then
         allocate(DstInitTypeData%ElemProps(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitTypeData%ElemProps.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitTypeData%ElemProps = SrcInitTypeData%ElemProps
   end if
   if (allocated(SrcInitTypeData%MemberNodes)) then
      LB(1:2) = lbound(SrcInitTypeData%MemberNodes)
      UB(1:2) = ubound(SrcInitTypeData%MemberNodes)
      if (.not. allocated(DstInitTypeData%MemberNodes)) then
         allocate(DstInitTypeData%MemberNodes(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitTypeData%MemberNodes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitTypeData%MemberNodes = SrcInitTypeData%MemberNodes
   end if
   if (allocated(SrcInitTypeData%NodesConnN)) then
      LB(1:2) = lbound(SrcInitTypeData%NodesConnN)
      UB(1:2) = ubound(SrcInitTypeData%NodesConnN)
      if (.not. allocated(DstInitTypeData%NodesConnN)) then
         allocate(DstInitTypeData%NodesConnN(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitTypeData%NodesConnN.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitTypeData%NodesConnN = SrcInitTypeData%NodesConnN
   end if
   if (allocated(SrcInitTypeData%NodesConnE)) then
      LB(1:2) = lbound(SrcInitTypeData%NodesConnE)
      UB(1:2) = ubound(SrcInitTypeData%NodesConnE)
      if (.not. allocated(DstInitTypeData%NodesConnE)) then
         allocate(DstInitTypeData%NodesConnE(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitTypeData%NodesConnE.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitTypeData%NodesConnE = SrcInitTypeData%NodesConnE
   end if
   DstInitTypeData%SSSum = SrcInitTypeData%SSSum
end subroutine

subroutine SD_DestroyInitType(InitTypeData, ErrStat, ErrMsg)
   type(SD_InitType), intent(inout) :: InitTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SD_DestroyInitType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InitTypeData%Joints)) then
      deallocate(InitTypeData%Joints)
   end if
   if (allocated(InitTypeData%PropSetsBC)) then
      deallocate(InitTypeData%PropSetsBC)
   end if
   if (allocated(InitTypeData%PropSetsBR)) then
      deallocate(InitTypeData%PropSetsBR)
   end if
   if (allocated(InitTypeData%PropSetsC)) then
      deallocate(InitTypeData%PropSetsC)
   end if
   if (allocated(InitTypeData%PropSetsR)) then
      deallocate(InitTypeData%PropSetsR)
   end if
   if (allocated(InitTypeData%PropSetsS)) then
      deallocate(InitTypeData%PropSetsS)
   end if
   if (allocated(InitTypeData%PropSetsX)) then
      deallocate(InitTypeData%PropSetsX)
   end if
   if (allocated(InitTypeData%COSMs)) then
      deallocate(InitTypeData%COSMs)
   end if
   if (allocated(InitTypeData%CMass)) then
      deallocate(InitTypeData%CMass)
   end if
   if (allocated(InitTypeData%JDampings)) then
      deallocate(InitTypeData%JDampings)
   end if
   if (allocated(InitTypeData%Members)) then
      deallocate(InitTypeData%Members)
   end if
   if (allocated(InitTypeData%MemberSpin)) then
      deallocate(InitTypeData%MemberSpin)
   end if
   if (allocated(InitTypeData%SSOutList)) then
      deallocate(InitTypeData%SSOutList)
   end if
   if (allocated(InitTypeData%SSIK)) then
      deallocate(InitTypeData%SSIK)
   end if
   if (allocated(InitTypeData%SSIM)) then
      deallocate(InitTypeData%SSIM)
   end if
   if (allocated(InitTypeData%SSIfile)) then
      deallocate(InitTypeData%SSIfile)
   end if
   if (allocated(InitTypeData%Soil_K)) then
      deallocate(InitTypeData%Soil_K)
   end if
   if (allocated(InitTypeData%Soil_Points)) then
      deallocate(InitTypeData%Soil_Points)
   end if
   if (allocated(InitTypeData%Soil_Nodes)) then
      deallocate(InitTypeData%Soil_Nodes)
   end if
   if (allocated(InitTypeData%Nodes)) then
      deallocate(InitTypeData%Nodes)
   end if
   if (allocated(InitTypeData%PropsBC)) then
      deallocate(InitTypeData%PropsBC)
   end if
   if (allocated(InitTypeData%PropsBR)) then
      deallocate(InitTypeData%PropsBR)
   end if
   if (allocated(InitTypeData%PropsC)) then
      deallocate(InitTypeData%PropsC)
   end if
   if (allocated(InitTypeData%PropsR)) then
      deallocate(InitTypeData%PropsR)
   end if
   if (allocated(InitTypeData%PropsS)) then
      deallocate(InitTypeData%PropsS)
   end if
   if (allocated(InitTypeData%K)) then
      deallocate(InitTypeData%K)
   end if
   if (allocated(InitTypeData%M)) then
      deallocate(InitTypeData%M)
   end if
   if (allocated(InitTypeData%ElemProps)) then
      deallocate(InitTypeData%ElemProps)
   end if
   if (allocated(InitTypeData%MemberNodes)) then
      deallocate(InitTypeData%MemberNodes)
   end if
   if (allocated(InitTypeData%NodesConnN)) then
      deallocate(InitTypeData%NodesConnN)
   end if
   if (allocated(InitTypeData%NodesConnE)) then
      deallocate(InitTypeData%NodesConnE)
   end if
end subroutine

subroutine SD_PackInitType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SD_InitType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SD_PackInitType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%RootName)
   call RegPack(RF, InData%TP_RefPoint)
   call RegPack(RF, InData%SubRotateZ)
   call RegPack(RF, InData%g)
   call RegPack(RF, InData%DT)
   call RegPack(RF, InData%NJoints)
   call RegPack(RF, InData%NPropSetsX)
   call RegPack(RF, InData%NPropSetsBC)
   call RegPack(RF, InData%NPropSetsBR)
   call RegPack(RF, InData%NPropSetsC)
   call RegPack(RF, InData%NPropSetsR)
   call RegPack(RF, InData%NPropSetsS)
   call RegPack(RF, InData%NCMass)
   call RegPack(RF, InData%NCOSMs)
   call RegPack(RF, InData%FEMMod)
   call RegPack(RF, InData%NDiv)
   call RegPack(RF, InData%CBMod)
   call RegPackAlloc(RF, InData%Joints)
   call RegPackAlloc(RF, InData%PropSetsBC)
   call RegPackAlloc(RF, InData%PropSetsBR)
   call RegPackAlloc(RF, InData%PropSetsC)
   call RegPackAlloc(RF, InData%PropSetsR)
   call RegPackAlloc(RF, InData%PropSetsS)
   call RegPackAlloc(RF, InData%PropSetsX)
   call RegPackAlloc(RF, InData%COSMs)
   call RegPackAlloc(RF, InData%CMass)
   call RegPackAlloc(RF, InData%JDampings)
   call RegPack(RF, InData%GuyanDampMod)
   call RegPack(RF, InData%RayleighDamp)
   call RegPack(RF, InData%GuyanDampMat)
   call RegPackAlloc(RF, InData%Members)
   call RegPackAlloc(RF, InData%MemberSpin)
   call RegPackAlloc(RF, InData%SSOutList)
   call RegPack(RF, InData%OutCOSM)
   call RegPack(RF, InData%TabDelim)
   call RegPackAlloc(RF, InData%SSIK)
   call RegPackAlloc(RF, InData%SSIM)
   call RegPackAlloc(RF, InData%SSIfile)
   call RegPackAlloc(RF, InData%Soil_K)
   call RegPackAlloc(RF, InData%Soil_Points)
   call RegPackAlloc(RF, InData%Soil_Nodes)
   call RegPack(RF, InData%NElem)
   call RegPack(RF, InData%NPropBC)
   call RegPack(RF, InData%NPropBR)
   call RegPack(RF, InData%NPropX)
   call RegPack(RF, InData%NPropC)
   call RegPack(RF, InData%NPropR)
   call RegPack(RF, InData%NPropS)
   call RegPackAlloc(RF, InData%Nodes)
   call RegPackAlloc(RF, InData%PropsBC)
   call RegPackAlloc(RF, InData%PropsBR)
   call RegPackAlloc(RF, InData%PropsC)
   call RegPackAlloc(RF, InData%PropsR)
   call RegPackAlloc(RF, InData%PropsS)
   call RegPackAlloc(RF, InData%K)
   call RegPackAlloc(RF, InData%M)
   call RegPackAlloc(RF, InData%ElemProps)
   call RegPackAlloc(RF, InData%MemberNodes)
   call RegPackAlloc(RF, InData%NodesConnN)
   call RegPackAlloc(RF, InData%NodesConnE)
   call RegPack(RF, InData%SSSum)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SD_UnPackInitType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SD_InitType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SD_UnPackInitType'
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%RootName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TP_RefPoint); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SubRotateZ); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%g); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NJoints); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NPropSetsX); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NPropSetsBC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NPropSetsBR); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NPropSetsC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NPropSetsR); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NPropSetsS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NCMass); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NCOSMs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FEMMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NDiv); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CBMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Joints); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PropSetsBC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PropSetsBR); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PropSetsC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PropSetsR); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PropSetsS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PropSetsX); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%COSMs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%CMass); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%JDampings); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GuyanDampMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RayleighDamp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GuyanDampMat); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Members); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%MemberSpin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%SSOutList); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutCOSM); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TabDelim); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%SSIK); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%SSIM); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%SSIfile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Soil_K); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Soil_Points); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Soil_Nodes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NElem); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NPropBC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NPropBR); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NPropX); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NPropC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NPropR); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NPropS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Nodes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PropsBC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PropsBR); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PropsC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PropsR); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PropsS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%K); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%M); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%ElemProps); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%MemberNodes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%NodesConnN); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%NodesConnE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SSSum); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SD_CopyContState(SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg)
   type(SD_ContinuousStateType), intent(in) :: SrcContStateData
   type(SD_ContinuousStateType), intent(inout) :: DstContStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'SD_CopyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcContStateData%qm)) then
      LB(1:1) = lbound(SrcContStateData%qm)
      UB(1:1) = ubound(SrcContStateData%qm)
      if (.not. allocated(DstContStateData%qm)) then
         allocate(DstContStateData%qm(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstContStateData%qm.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstContStateData%qm = SrcContStateData%qm
   end if
   if (allocated(SrcContStateData%qmdot)) then
      LB(1:1) = lbound(SrcContStateData%qmdot)
      UB(1:1) = ubound(SrcContStateData%qmdot)
      if (.not. allocated(DstContStateData%qmdot)) then
         allocate(DstContStateData%qmdot(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstContStateData%qmdot.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstContStateData%qmdot = SrcContStateData%qmdot
   end if
end subroutine

subroutine SD_DestroyContState(ContStateData, ErrStat, ErrMsg)
   type(SD_ContinuousStateType), intent(inout) :: ContStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SD_DestroyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ContStateData%qm)) then
      deallocate(ContStateData%qm)
   end if
   if (allocated(ContStateData%qmdot)) then
      deallocate(ContStateData%qmdot)
   end if
end subroutine

subroutine SD_PackContState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SD_ContinuousStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SD_PackContState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%qm)
   call RegPackAlloc(RF, InData%qmdot)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SD_UnPackContState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SD_ContinuousStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SD_UnPackContState'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%qm); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%qmdot); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SD_CopyDiscState(SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg)
   type(SD_DiscreteStateType), intent(in) :: SrcDiscStateData
   type(SD_DiscreteStateType), intent(inout) :: DstDiscStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SD_CopyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstDiscStateData%DummyDiscState = SrcDiscStateData%DummyDiscState
end subroutine

subroutine SD_DestroyDiscState(DiscStateData, ErrStat, ErrMsg)
   type(SD_DiscreteStateType), intent(inout) :: DiscStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SD_DestroyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine SD_PackDiscState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SD_DiscreteStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SD_PackDiscState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyDiscState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SD_UnPackDiscState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SD_DiscreteStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SD_UnPackDiscState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyDiscState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SD_CopyConstrState(SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg)
   type(SD_ConstraintStateType), intent(in) :: SrcConstrStateData
   type(SD_ConstraintStateType), intent(inout) :: DstConstrStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SD_CopyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstConstrStateData%DummyConstrState = SrcConstrStateData%DummyConstrState
end subroutine

subroutine SD_DestroyConstrState(ConstrStateData, ErrStat, ErrMsg)
   type(SD_ConstraintStateType), intent(inout) :: ConstrStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SD_DestroyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine SD_PackConstrState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SD_ConstraintStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SD_PackConstrState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyConstrState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SD_UnPackConstrState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SD_ConstraintStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SD_UnPackConstrState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyConstrState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SD_CopyOtherState(SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg)
   type(SD_OtherStateType), intent(in) :: SrcOtherStateData
   type(SD_OtherStateType), intent(inout) :: DstOtherStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SD_CopyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcOtherStateData%xdot)) then
      LB(1:1) = lbound(SrcOtherStateData%xdot)
      UB(1:1) = ubound(SrcOtherStateData%xdot)
      if (.not. allocated(DstOtherStateData%xdot)) then
         allocate(DstOtherStateData%xdot(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%xdot.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call SD_CopyContState(SrcOtherStateData%xdot(i1), DstOtherStateData%xdot(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstOtherStateData%n = SrcOtherStateData%n
end subroutine

subroutine SD_DestroyOtherState(OtherStateData, ErrStat, ErrMsg)
   type(SD_OtherStateType), intent(inout) :: OtherStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SD_DestroyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(OtherStateData%xdot)) then
      LB(1:1) = lbound(OtherStateData%xdot)
      UB(1:1) = ubound(OtherStateData%xdot)
      do i1 = LB(1), UB(1)
         call SD_DestroyContState(OtherStateData%xdot(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(OtherStateData%xdot)
   end if
end subroutine

subroutine SD_PackOtherState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SD_OtherStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SD_PackOtherState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%xdot))
   if (allocated(InData%xdot)) then
      call RegPackBounds(RF, 1, lbound(InData%xdot), ubound(InData%xdot))
      LB(1:1) = lbound(InData%xdot)
      UB(1:1) = ubound(InData%xdot)
      do i1 = LB(1), UB(1)
         call SD_PackContState(RF, InData%xdot(i1)) 
      end do
   end if
   call RegPack(RF, InData%n)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SD_UnPackOtherState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SD_OtherStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SD_UnPackOtherState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%xdot)) deallocate(OutData%xdot)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%xdot(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%xdot.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call SD_UnpackContState(RF, OutData%xdot(i1)) ! xdot 
      end do
   end if
   call RegUnpack(RF, OutData%n); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SD_CopyMisc(SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg)
   type(SD_MiscVarType), intent(in) :: SrcMiscData
   type(SD_MiscVarType), intent(inout) :: DstMiscData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'SD_CopyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcMiscData%qmdotdot)) then
      LB(1:1) = lbound(SrcMiscData%qmdotdot)
      UB(1:1) = ubound(SrcMiscData%qmdotdot)
      if (.not. allocated(DstMiscData%qmdotdot)) then
         allocate(DstMiscData%qmdotdot(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%qmdotdot.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%qmdotdot = SrcMiscData%qmdotdot
   end if
   DstMiscData%u_TP = SrcMiscData%u_TP
   DstMiscData%udot_TP = SrcMiscData%udot_TP
   DstMiscData%udotdot_TP = SrcMiscData%udotdot_TP
   if (allocated(SrcMiscData%F_L)) then
      LB(1:1) = lbound(SrcMiscData%F_L)
      UB(1:1) = ubound(SrcMiscData%F_L)
      if (.not. allocated(DstMiscData%F_L)) then
         allocate(DstMiscData%F_L(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%F_L.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%F_L = SrcMiscData%F_L
   end if
   if (allocated(SrcMiscData%F_L2)) then
      LB(1:1) = lbound(SrcMiscData%F_L2)
      UB(1:1) = ubound(SrcMiscData%F_L2)
      if (.not. allocated(DstMiscData%F_L2)) then
         allocate(DstMiscData%F_L2(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%F_L2.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%F_L2 = SrcMiscData%F_L2
   end if
   if (allocated(SrcMiscData%UR_bar)) then
      LB(1:1) = lbound(SrcMiscData%UR_bar)
      UB(1:1) = ubound(SrcMiscData%UR_bar)
      if (.not. allocated(DstMiscData%UR_bar)) then
         allocate(DstMiscData%UR_bar(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%UR_bar.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%UR_bar = SrcMiscData%UR_bar
   end if
   if (allocated(SrcMiscData%UR_bar_dot)) then
      LB(1:1) = lbound(SrcMiscData%UR_bar_dot)
      UB(1:1) = ubound(SrcMiscData%UR_bar_dot)
      if (.not. allocated(DstMiscData%UR_bar_dot)) then
         allocate(DstMiscData%UR_bar_dot(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%UR_bar_dot.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%UR_bar_dot = SrcMiscData%UR_bar_dot
   end if
   if (allocated(SrcMiscData%UR_bar_dotdot)) then
      LB(1:1) = lbound(SrcMiscData%UR_bar_dotdot)
      UB(1:1) = ubound(SrcMiscData%UR_bar_dotdot)
      if (.not. allocated(DstMiscData%UR_bar_dotdot)) then
         allocate(DstMiscData%UR_bar_dotdot(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%UR_bar_dotdot.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%UR_bar_dotdot = SrcMiscData%UR_bar_dotdot
   end if
   if (allocated(SrcMiscData%UL)) then
      LB(1:1) = lbound(SrcMiscData%UL)
      UB(1:1) = ubound(SrcMiscData%UL)
      if (.not. allocated(DstMiscData%UL)) then
         allocate(DstMiscData%UL(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%UL.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%UL = SrcMiscData%UL
   end if
   if (allocated(SrcMiscData%UL_NS)) then
      LB(1:1) = lbound(SrcMiscData%UL_NS)
      UB(1:1) = ubound(SrcMiscData%UL_NS)
      if (.not. allocated(DstMiscData%UL_NS)) then
         allocate(DstMiscData%UL_NS(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%UL_NS.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%UL_NS = SrcMiscData%UL_NS
   end if
   if (allocated(SrcMiscData%UL_dot)) then
      LB(1:1) = lbound(SrcMiscData%UL_dot)
      UB(1:1) = ubound(SrcMiscData%UL_dot)
      if (.not. allocated(DstMiscData%UL_dot)) then
         allocate(DstMiscData%UL_dot(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%UL_dot.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%UL_dot = SrcMiscData%UL_dot
   end if
   if (allocated(SrcMiscData%UL_dotdot)) then
      LB(1:1) = lbound(SrcMiscData%UL_dotdot)
      UB(1:1) = ubound(SrcMiscData%UL_dotdot)
      if (.not. allocated(DstMiscData%UL_dotdot)) then
         allocate(DstMiscData%UL_dotdot(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%UL_dotdot.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%UL_dotdot = SrcMiscData%UL_dotdot
   end if
   if (allocated(SrcMiscData%DU_full)) then
      LB(1:1) = lbound(SrcMiscData%DU_full)
      UB(1:1) = ubound(SrcMiscData%DU_full)
      if (.not. allocated(DstMiscData%DU_full)) then
         allocate(DstMiscData%DU_full(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%DU_full.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%DU_full = SrcMiscData%DU_full
   end if
   if (allocated(SrcMiscData%U_full)) then
      LB(1:1) = lbound(SrcMiscData%U_full)
      UB(1:1) = ubound(SrcMiscData%U_full)
      if (.not. allocated(DstMiscData%U_full)) then
         allocate(DstMiscData%U_full(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%U_full.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%U_full = SrcMiscData%U_full
   end if
   if (allocated(SrcMiscData%U_full_NS)) then
      LB(1:1) = lbound(SrcMiscData%U_full_NS)
      UB(1:1) = ubound(SrcMiscData%U_full_NS)
      if (.not. allocated(DstMiscData%U_full_NS)) then
         allocate(DstMiscData%U_full_NS(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%U_full_NS.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%U_full_NS = SrcMiscData%U_full_NS
   end if
   if (allocated(SrcMiscData%U_full_dot)) then
      LB(1:1) = lbound(SrcMiscData%U_full_dot)
      UB(1:1) = ubound(SrcMiscData%U_full_dot)
      if (.not. allocated(DstMiscData%U_full_dot)) then
         allocate(DstMiscData%U_full_dot(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%U_full_dot.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%U_full_dot = SrcMiscData%U_full_dot
   end if
   if (allocated(SrcMiscData%U_full_dotdot)) then
      LB(1:1) = lbound(SrcMiscData%U_full_dotdot)
      UB(1:1) = ubound(SrcMiscData%U_full_dotdot)
      if (.not. allocated(DstMiscData%U_full_dotdot)) then
         allocate(DstMiscData%U_full_dotdot(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%U_full_dotdot.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%U_full_dotdot = SrcMiscData%U_full_dotdot
   end if
   if (allocated(SrcMiscData%U_full_elast)) then
      LB(1:1) = lbound(SrcMiscData%U_full_elast)
      UB(1:1) = ubound(SrcMiscData%U_full_elast)
      if (.not. allocated(DstMiscData%U_full_elast)) then
         allocate(DstMiscData%U_full_elast(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%U_full_elast.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%U_full_elast = SrcMiscData%U_full_elast
   end if
   if (allocated(SrcMiscData%U_red)) then
      LB(1:1) = lbound(SrcMiscData%U_red)
      UB(1:1) = ubound(SrcMiscData%U_red)
      if (.not. allocated(DstMiscData%U_red)) then
         allocate(DstMiscData%U_red(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%U_red.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%U_red = SrcMiscData%U_red
   end if
   if (allocated(SrcMiscData%FC_unit)) then
      LB(1:1) = lbound(SrcMiscData%FC_unit)
      UB(1:1) = ubound(SrcMiscData%FC_unit)
      if (.not. allocated(DstMiscData%FC_unit)) then
         allocate(DstMiscData%FC_unit(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%FC_unit.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%FC_unit = SrcMiscData%FC_unit
   end if
   if (allocated(SrcMiscData%SDWrOutput)) then
      LB(1:1) = lbound(SrcMiscData%SDWrOutput)
      UB(1:1) = ubound(SrcMiscData%SDWrOutput)
      if (.not. allocated(DstMiscData%SDWrOutput)) then
         allocate(DstMiscData%SDWrOutput(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%SDWrOutput.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%SDWrOutput = SrcMiscData%SDWrOutput
   end if
   if (allocated(SrcMiscData%AllOuts)) then
      LB(1:1) = lbound(SrcMiscData%AllOuts)
      UB(1:1) = ubound(SrcMiscData%AllOuts)
      if (.not. allocated(DstMiscData%AllOuts)) then
         allocate(DstMiscData%AllOuts(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%AllOuts.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%AllOuts = SrcMiscData%AllOuts
   end if
   DstMiscData%LastOutTime = SrcMiscData%LastOutTime
   DstMiscData%Decimat = SrcMiscData%Decimat
   if (allocated(SrcMiscData%Fext)) then
      LB(1:1) = lbound(SrcMiscData%Fext)
      UB(1:1) = ubound(SrcMiscData%Fext)
      if (.not. allocated(DstMiscData%Fext)) then
         allocate(DstMiscData%Fext(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%Fext.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%Fext = SrcMiscData%Fext
   end if
   if (allocated(SrcMiscData%Fext_red)) then
      LB(1:1) = lbound(SrcMiscData%Fext_red)
      UB(1:1) = ubound(SrcMiscData%Fext_red)
      if (.not. allocated(DstMiscData%Fext_red)) then
         allocate(DstMiscData%Fext_red(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%Fext_red.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%Fext_red = SrcMiscData%Fext_red
   end if
   if (allocated(SrcMiscData%FG)) then
      LB(1:1) = lbound(SrcMiscData%FG)
      UB(1:1) = ubound(SrcMiscData%FG)
      if (.not. allocated(DstMiscData%FG)) then
         allocate(DstMiscData%FG(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%FG.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%FG = SrcMiscData%FG
   end if
   if (allocated(SrcMiscData%UL_SIM)) then
      LB(1:1) = lbound(SrcMiscData%UL_SIM)
      UB(1:1) = ubound(SrcMiscData%UL_SIM)
      if (.not. allocated(DstMiscData%UL_SIM)) then
         allocate(DstMiscData%UL_SIM(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%UL_SIM.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%UL_SIM = SrcMiscData%UL_SIM
   end if
   if (allocated(SrcMiscData%UL_0m)) then
      LB(1:1) = lbound(SrcMiscData%UL_0m)
      UB(1:1) = ubound(SrcMiscData%UL_0m)
      if (.not. allocated(DstMiscData%UL_0m)) then
         allocate(DstMiscData%UL_0m(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%UL_0m.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%UL_0m = SrcMiscData%UL_0m
   end if
end subroutine

subroutine SD_DestroyMisc(MiscData, ErrStat, ErrMsg)
   type(SD_MiscVarType), intent(inout) :: MiscData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SD_DestroyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(MiscData%qmdotdot)) then
      deallocate(MiscData%qmdotdot)
   end if
   if (allocated(MiscData%F_L)) then
      deallocate(MiscData%F_L)
   end if
   if (allocated(MiscData%F_L2)) then
      deallocate(MiscData%F_L2)
   end if
   if (allocated(MiscData%UR_bar)) then
      deallocate(MiscData%UR_bar)
   end if
   if (allocated(MiscData%UR_bar_dot)) then
      deallocate(MiscData%UR_bar_dot)
   end if
   if (allocated(MiscData%UR_bar_dotdot)) then
      deallocate(MiscData%UR_bar_dotdot)
   end if
   if (allocated(MiscData%UL)) then
      deallocate(MiscData%UL)
   end if
   if (allocated(MiscData%UL_NS)) then
      deallocate(MiscData%UL_NS)
   end if
   if (allocated(MiscData%UL_dot)) then
      deallocate(MiscData%UL_dot)
   end if
   if (allocated(MiscData%UL_dotdot)) then
      deallocate(MiscData%UL_dotdot)
   end if
   if (allocated(MiscData%DU_full)) then
      deallocate(MiscData%DU_full)
   end if
   if (allocated(MiscData%U_full)) then
      deallocate(MiscData%U_full)
   end if
   if (allocated(MiscData%U_full_NS)) then
      deallocate(MiscData%U_full_NS)
   end if
   if (allocated(MiscData%U_full_dot)) then
      deallocate(MiscData%U_full_dot)
   end if
   if (allocated(MiscData%U_full_dotdot)) then
      deallocate(MiscData%U_full_dotdot)
   end if
   if (allocated(MiscData%U_full_elast)) then
      deallocate(MiscData%U_full_elast)
   end if
   if (allocated(MiscData%U_red)) then
      deallocate(MiscData%U_red)
   end if
   if (allocated(MiscData%FC_unit)) then
      deallocate(MiscData%FC_unit)
   end if
   if (allocated(MiscData%SDWrOutput)) then
      deallocate(MiscData%SDWrOutput)
   end if
   if (allocated(MiscData%AllOuts)) then
      deallocate(MiscData%AllOuts)
   end if
   if (allocated(MiscData%Fext)) then
      deallocate(MiscData%Fext)
   end if
   if (allocated(MiscData%Fext_red)) then
      deallocate(MiscData%Fext_red)
   end if
   if (allocated(MiscData%FG)) then
      deallocate(MiscData%FG)
   end if
   if (allocated(MiscData%UL_SIM)) then
      deallocate(MiscData%UL_SIM)
   end if
   if (allocated(MiscData%UL_0m)) then
      deallocate(MiscData%UL_0m)
   end if
end subroutine

subroutine SD_PackMisc(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SD_MiscVarType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SD_PackMisc'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%qmdotdot)
   call RegPack(RF, InData%u_TP)
   call RegPack(RF, InData%udot_TP)
   call RegPack(RF, InData%udotdot_TP)
   call RegPackAlloc(RF, InData%F_L)
   call RegPackAlloc(RF, InData%F_L2)
   call RegPackAlloc(RF, InData%UR_bar)
   call RegPackAlloc(RF, InData%UR_bar_dot)
   call RegPackAlloc(RF, InData%UR_bar_dotdot)
   call RegPackAlloc(RF, InData%UL)
   call RegPackAlloc(RF, InData%UL_NS)
   call RegPackAlloc(RF, InData%UL_dot)
   call RegPackAlloc(RF, InData%UL_dotdot)
   call RegPackAlloc(RF, InData%DU_full)
   call RegPackAlloc(RF, InData%U_full)
   call RegPackAlloc(RF, InData%U_full_NS)
   call RegPackAlloc(RF, InData%U_full_dot)
   call RegPackAlloc(RF, InData%U_full_dotdot)
   call RegPackAlloc(RF, InData%U_full_elast)
   call RegPackAlloc(RF, InData%U_red)
   call RegPackAlloc(RF, InData%FC_unit)
   call RegPackAlloc(RF, InData%SDWrOutput)
   call RegPackAlloc(RF, InData%AllOuts)
   call RegPack(RF, InData%LastOutTime)
   call RegPack(RF, InData%Decimat)
   call RegPackAlloc(RF, InData%Fext)
   call RegPackAlloc(RF, InData%Fext_red)
   call RegPackAlloc(RF, InData%FG)
   call RegPackAlloc(RF, InData%UL_SIM)
   call RegPackAlloc(RF, InData%UL_0m)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SD_UnPackMisc(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SD_MiscVarType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SD_UnPackMisc'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%qmdotdot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%u_TP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%udot_TP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%udotdot_TP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%F_L); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%F_L2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%UR_bar); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%UR_bar_dot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%UR_bar_dotdot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%UL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%UL_NS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%UL_dot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%UL_dotdot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%DU_full); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%U_full); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%U_full_NS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%U_full_dot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%U_full_dotdot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%U_full_elast); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%U_red); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%FC_unit); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%SDWrOutput); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AllOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LastOutTime); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Decimat); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Fext); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Fext_red); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%FG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%UL_SIM); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%UL_0m); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SD_CopyParam(SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg)
   type(SD_ParameterType), intent(in) :: SrcParamData
   type(SD_ParameterType), intent(inout) :: DstParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SD_CopyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstParamData%g = SrcParamData%g
   DstParamData%SDDeltaT = SrcParamData%SDDeltaT
   DstParamData%IntMethod = SrcParamData%IntMethod
   DstParamData%nDOF = SrcParamData%nDOF
   DstParamData%nDOF_red = SrcParamData%nDOF_red
   DstParamData%Nmembers = SrcParamData%Nmembers
   if (allocated(SrcParamData%Elems)) then
      LB(1:2) = lbound(SrcParamData%Elems)
      UB(1:2) = ubound(SrcParamData%Elems)
      if (.not. allocated(DstParamData%Elems)) then
         allocate(DstParamData%Elems(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Elems.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Elems = SrcParamData%Elems
   end if
   if (allocated(SrcParamData%ElemSpin)) then
      LB(1:1) = lbound(SrcParamData%ElemSpin)
      UB(1:1) = ubound(SrcParamData%ElemSpin)
      if (.not. allocated(DstParamData%ElemSpin)) then
         allocate(DstParamData%ElemSpin(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%ElemSpin.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%ElemSpin = SrcParamData%ElemSpin
   end if
   if (allocated(SrcParamData%ElemProps)) then
      LB(1:1) = lbound(SrcParamData%ElemProps)
      UB(1:1) = ubound(SrcParamData%ElemProps)
      if (.not. allocated(DstParamData%ElemProps)) then
         allocate(DstParamData%ElemProps(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%ElemProps.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call SD_CopyElemPropType(SrcParamData%ElemProps(i1), DstParamData%ElemProps(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcParamData%FC)) then
      LB(1:1) = lbound(SrcParamData%FC)
      UB(1:1) = ubound(SrcParamData%FC)
      if (.not. allocated(DstParamData%FC)) then
         allocate(DstParamData%FC(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%FC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%FC = SrcParamData%FC
   end if
   if (allocated(SrcParamData%FG)) then
      LB(1:1) = lbound(SrcParamData%FG)
      UB(1:1) = ubound(SrcParamData%FG)
      if (.not. allocated(DstParamData%FG)) then
         allocate(DstParamData%FG(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%FG.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%FG = SrcParamData%FG
   end if
   if (allocated(SrcParamData%DP0)) then
      LB(1:2) = lbound(SrcParamData%DP0)
      UB(1:2) = ubound(SrcParamData%DP0)
      if (.not. allocated(DstParamData%DP0)) then
         allocate(DstParamData%DP0(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%DP0.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%DP0 = SrcParamData%DP0
   end if
   if (allocated(SrcParamData%rPG)) then
      LB(1:1) = lbound(SrcParamData%rPG)
      UB(1:1) = ubound(SrcParamData%rPG)
      if (.not. allocated(DstParamData%rPG)) then
         allocate(DstParamData%rPG(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%rPG.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%rPG = SrcParamData%rPG
   end if
   if (allocated(SrcParamData%NodeID2JointID)) then
      LB(1:1) = lbound(SrcParamData%NodeID2JointID)
      UB(1:1) = ubound(SrcParamData%NodeID2JointID)
      if (.not. allocated(DstParamData%NodeID2JointID)) then
         allocate(DstParamData%NodeID2JointID(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%NodeID2JointID.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%NodeID2JointID = SrcParamData%NodeID2JointID
   end if
   if (allocated(SrcParamData%CMassNode)) then
      LB(1:1) = lbound(SrcParamData%CMassNode)
      UB(1:1) = ubound(SrcParamData%CMassNode)
      if (.not. allocated(DstParamData%CMassNode)) then
         allocate(DstParamData%CMassNode(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%CMassNode.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%CMassNode = SrcParamData%CMassNode
   end if
   if (allocated(SrcParamData%CMassWeight)) then
      LB(1:1) = lbound(SrcParamData%CMassWeight)
      UB(1:1) = ubound(SrcParamData%CMassWeight)
      if (.not. allocated(DstParamData%CMassWeight)) then
         allocate(DstParamData%CMassWeight(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%CMassWeight.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%CMassWeight = SrcParamData%CMassWeight
   end if
   if (allocated(SrcParamData%CMassOffset)) then
      LB(1:2) = lbound(SrcParamData%CMassOffset)
      UB(1:2) = ubound(SrcParamData%CMassOffset)
      if (.not. allocated(DstParamData%CMassOffset)) then
         allocate(DstParamData%CMassOffset(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%CMassOffset.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%CMassOffset = SrcParamData%CMassOffset
   end if
   DstParamData%reduced = SrcParamData%reduced
   if (allocated(SrcParamData%T_red)) then
      LB(1:2) = lbound(SrcParamData%T_red)
      UB(1:2) = ubound(SrcParamData%T_red)
      if (.not. allocated(DstParamData%T_red)) then
         allocate(DstParamData%T_red(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%T_red.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%T_red = SrcParamData%T_red
   end if
   if (allocated(SrcParamData%T_red_T)) then
      LB(1:2) = lbound(SrcParamData%T_red_T)
      UB(1:2) = ubound(SrcParamData%T_red_T)
      if (.not. allocated(DstParamData%T_red_T)) then
         allocate(DstParamData%T_red_T(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%T_red_T.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%T_red_T = SrcParamData%T_red_T
   end if
   if (allocated(SrcParamData%NodesDOF)) then
      LB(1:1) = lbound(SrcParamData%NodesDOF)
      UB(1:1) = ubound(SrcParamData%NodesDOF)
      if (.not. allocated(DstParamData%NodesDOF)) then
         allocate(DstParamData%NodesDOF(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%NodesDOF.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call SD_CopyIList(SrcParamData%NodesDOF(i1), DstParamData%NodesDOF(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcParamData%NodesDOFred)) then
      LB(1:1) = lbound(SrcParamData%NodesDOFred)
      UB(1:1) = ubound(SrcParamData%NodesDOFred)
      if (.not. allocated(DstParamData%NodesDOFred)) then
         allocate(DstParamData%NodesDOFred(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%NodesDOFred.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call SD_CopyIList(SrcParamData%NodesDOFred(i1), DstParamData%NodesDOFred(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcParamData%ElemsDOF)) then
      LB(1:2) = lbound(SrcParamData%ElemsDOF)
      UB(1:2) = ubound(SrcParamData%ElemsDOF)
      if (.not. allocated(DstParamData%ElemsDOF)) then
         allocate(DstParamData%ElemsDOF(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%ElemsDOF.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%ElemsDOF = SrcParamData%ElemsDOF
   end if
   if (allocated(SrcParamData%DOFred2Nodes)) then
      LB(1:2) = lbound(SrcParamData%DOFred2Nodes)
      UB(1:2) = ubound(SrcParamData%DOFred2Nodes)
      if (.not. allocated(DstParamData%DOFred2Nodes)) then
         allocate(DstParamData%DOFred2Nodes(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%DOFred2Nodes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%DOFred2Nodes = SrcParamData%DOFred2Nodes
   end if
   if (allocated(SrcParamData%CtrlElem2Channel)) then
      LB(1:2) = lbound(SrcParamData%CtrlElem2Channel)
      UB(1:2) = ubound(SrcParamData%CtrlElem2Channel)
      if (.not. allocated(DstParamData%CtrlElem2Channel)) then
         allocate(DstParamData%CtrlElem2Channel(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%CtrlElem2Channel.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%CtrlElem2Channel = SrcParamData%CtrlElem2Channel
   end if
   DstParamData%nDOFM = SrcParamData%nDOFM
   DstParamData%SttcSolve = SrcParamData%SttcSolve
   DstParamData%GuyanLoadCorrection = SrcParamData%GuyanLoadCorrection
   DstParamData%Floating = SrcParamData%Floating
   if (allocated(SrcParamData%KMMDiag)) then
      LB(1:1) = lbound(SrcParamData%KMMDiag)
      UB(1:1) = ubound(SrcParamData%KMMDiag)
      if (.not. allocated(DstParamData%KMMDiag)) then
         allocate(DstParamData%KMMDiag(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%KMMDiag.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%KMMDiag = SrcParamData%KMMDiag
   end if
   if (allocated(SrcParamData%CMMDiag)) then
      LB(1:1) = lbound(SrcParamData%CMMDiag)
      UB(1:1) = ubound(SrcParamData%CMMDiag)
      if (.not. allocated(DstParamData%CMMDiag)) then
         allocate(DstParamData%CMMDiag(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%CMMDiag.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%CMMDiag = SrcParamData%CMMDiag
   end if
   if (allocated(SrcParamData%MMB)) then
      LB(1:2) = lbound(SrcParamData%MMB)
      UB(1:2) = ubound(SrcParamData%MMB)
      if (.not. allocated(DstParamData%MMB)) then
         allocate(DstParamData%MMB(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%MMB.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%MMB = SrcParamData%MMB
   end if
   if (allocated(SrcParamData%MBmmB)) then
      LB(1:2) = lbound(SrcParamData%MBmmB)
      UB(1:2) = ubound(SrcParamData%MBmmB)
      if (.not. allocated(DstParamData%MBmmB)) then
         allocate(DstParamData%MBmmB(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%MBmmB.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%MBmmB = SrcParamData%MBmmB
   end if
   if (allocated(SrcParamData%C1_11)) then
      LB(1:2) = lbound(SrcParamData%C1_11)
      UB(1:2) = ubound(SrcParamData%C1_11)
      if (.not. allocated(DstParamData%C1_11)) then
         allocate(DstParamData%C1_11(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%C1_11.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%C1_11 = SrcParamData%C1_11
   end if
   if (allocated(SrcParamData%C1_12)) then
      LB(1:2) = lbound(SrcParamData%C1_12)
      UB(1:2) = ubound(SrcParamData%C1_12)
      if (.not. allocated(DstParamData%C1_12)) then
         allocate(DstParamData%C1_12(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%C1_12.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%C1_12 = SrcParamData%C1_12
   end if
   if (allocated(SrcParamData%D1_141)) then
      LB(1:2) = lbound(SrcParamData%D1_141)
      UB(1:2) = ubound(SrcParamData%D1_141)
      if (.not. allocated(DstParamData%D1_141)) then
         allocate(DstParamData%D1_141(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%D1_141.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%D1_141 = SrcParamData%D1_141
   end if
   if (allocated(SrcParamData%D1_142)) then
      LB(1:2) = lbound(SrcParamData%D1_142)
      UB(1:2) = ubound(SrcParamData%D1_142)
      if (.not. allocated(DstParamData%D1_142)) then
         allocate(DstParamData%D1_142(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%D1_142.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%D1_142 = SrcParamData%D1_142
   end if
   if (allocated(SrcParamData%PhiM)) then
      LB(1:2) = lbound(SrcParamData%PhiM)
      UB(1:2) = ubound(SrcParamData%PhiM)
      if (.not. allocated(DstParamData%PhiM)) then
         allocate(DstParamData%PhiM(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%PhiM.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%PhiM = SrcParamData%PhiM
   end if
   if (allocated(SrcParamData%C2_61)) then
      LB(1:2) = lbound(SrcParamData%C2_61)
      UB(1:2) = ubound(SrcParamData%C2_61)
      if (.not. allocated(DstParamData%C2_61)) then
         allocate(DstParamData%C2_61(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%C2_61.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%C2_61 = SrcParamData%C2_61
   end if
   if (allocated(SrcParamData%C2_62)) then
      LB(1:2) = lbound(SrcParamData%C2_62)
      UB(1:2) = ubound(SrcParamData%C2_62)
      if (.not. allocated(DstParamData%C2_62)) then
         allocate(DstParamData%C2_62(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%C2_62.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%C2_62 = SrcParamData%C2_62
   end if
   if (allocated(SrcParamData%PhiRb_TI)) then
      LB(1:2) = lbound(SrcParamData%PhiRb_TI)
      UB(1:2) = ubound(SrcParamData%PhiRb_TI)
      if (.not. allocated(DstParamData%PhiRb_TI)) then
         allocate(DstParamData%PhiRb_TI(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%PhiRb_TI.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%PhiRb_TI = SrcParamData%PhiRb_TI
   end if
   if (allocated(SrcParamData%D2_63)) then
      LB(1:2) = lbound(SrcParamData%D2_63)
      UB(1:2) = ubound(SrcParamData%D2_63)
      if (.not. allocated(DstParamData%D2_63)) then
         allocate(DstParamData%D2_63(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%D2_63.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%D2_63 = SrcParamData%D2_63
   end if
   if (allocated(SrcParamData%D2_64)) then
      LB(1:2) = lbound(SrcParamData%D2_64)
      UB(1:2) = ubound(SrcParamData%D2_64)
      if (.not. allocated(DstParamData%D2_64)) then
         allocate(DstParamData%D2_64(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%D2_64.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%D2_64 = SrcParamData%D2_64
   end if
   if (allocated(SrcParamData%MBB)) then
      LB(1:2) = lbound(SrcParamData%MBB)
      UB(1:2) = ubound(SrcParamData%MBB)
      if (.not. allocated(DstParamData%MBB)) then
         allocate(DstParamData%MBB(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%MBB.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%MBB = SrcParamData%MBB
   end if
   if (allocated(SrcParamData%KBB)) then
      LB(1:2) = lbound(SrcParamData%KBB)
      UB(1:2) = ubound(SrcParamData%KBB)
      if (.not. allocated(DstParamData%KBB)) then
         allocate(DstParamData%KBB(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%KBB.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%KBB = SrcParamData%KBB
   end if
   if (allocated(SrcParamData%CBB)) then
      LB(1:2) = lbound(SrcParamData%CBB)
      UB(1:2) = ubound(SrcParamData%CBB)
      if (.not. allocated(DstParamData%CBB)) then
         allocate(DstParamData%CBB(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%CBB.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%CBB = SrcParamData%CBB
   end if
   if (allocated(SrcParamData%CMM)) then
      LB(1:2) = lbound(SrcParamData%CMM)
      UB(1:2) = ubound(SrcParamData%CMM)
      if (.not. allocated(DstParamData%CMM)) then
         allocate(DstParamData%CMM(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%CMM.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%CMM = SrcParamData%CMM
   end if
   if (allocated(SrcParamData%MBM)) then
      LB(1:2) = lbound(SrcParamData%MBM)
      UB(1:2) = ubound(SrcParamData%MBM)
      if (.not. allocated(DstParamData%MBM)) then
         allocate(DstParamData%MBM(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%MBM.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%MBM = SrcParamData%MBM
   end if
   if (allocated(SrcParamData%PhiL_T)) then
      LB(1:2) = lbound(SrcParamData%PhiL_T)
      UB(1:2) = ubound(SrcParamData%PhiL_T)
      if (.not. allocated(DstParamData%PhiL_T)) then
         allocate(DstParamData%PhiL_T(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%PhiL_T.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%PhiL_T = SrcParamData%PhiL_T
   end if
   if (allocated(SrcParamData%PhiLInvOmgL2)) then
      LB(1:2) = lbound(SrcParamData%PhiLInvOmgL2)
      UB(1:2) = ubound(SrcParamData%PhiLInvOmgL2)
      if (.not. allocated(DstParamData%PhiLInvOmgL2)) then
         allocate(DstParamData%PhiLInvOmgL2(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%PhiLInvOmgL2.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%PhiLInvOmgL2 = SrcParamData%PhiLInvOmgL2
   end if
   if (allocated(SrcParamData%KLLm1)) then
      LB(1:2) = lbound(SrcParamData%KLLm1)
      UB(1:2) = ubound(SrcParamData%KLLm1)
      if (.not. allocated(DstParamData%KLLm1)) then
         allocate(DstParamData%KLLm1(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%KLLm1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%KLLm1 = SrcParamData%KLLm1
   end if
   if (allocated(SrcParamData%AM2Jac)) then
      LB(1:2) = lbound(SrcParamData%AM2Jac)
      UB(1:2) = ubound(SrcParamData%AM2Jac)
      if (.not. allocated(DstParamData%AM2Jac)) then
         allocate(DstParamData%AM2Jac(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%AM2Jac.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%AM2Jac = SrcParamData%AM2Jac
   end if
   if (allocated(SrcParamData%AM2JacPiv)) then
      LB(1:1) = lbound(SrcParamData%AM2JacPiv)
      UB(1:1) = ubound(SrcParamData%AM2JacPiv)
      if (.not. allocated(DstParamData%AM2JacPiv)) then
         allocate(DstParamData%AM2JacPiv(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%AM2JacPiv.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%AM2JacPiv = SrcParamData%AM2JacPiv
   end if
   if (allocated(SrcParamData%TI)) then
      LB(1:2) = lbound(SrcParamData%TI)
      UB(1:2) = ubound(SrcParamData%TI)
      if (.not. allocated(DstParamData%TI)) then
         allocate(DstParamData%TI(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%TI.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%TI = SrcParamData%TI
   end if
   if (allocated(SrcParamData%TIreact)) then
      LB(1:2) = lbound(SrcParamData%TIreact)
      UB(1:2) = ubound(SrcParamData%TIreact)
      if (.not. allocated(DstParamData%TIreact)) then
         allocate(DstParamData%TIreact(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%TIreact.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%TIreact = SrcParamData%TIreact
   end if
   DstParamData%nNodes = SrcParamData%nNodes
   DstParamData%nNodes_I = SrcParamData%nNodes_I
   DstParamData%nNodes_L = SrcParamData%nNodes_L
   DstParamData%nNodes_C = SrcParamData%nNodes_C
   if (allocated(SrcParamData%Nodes_I)) then
      LB(1:2) = lbound(SrcParamData%Nodes_I)
      UB(1:2) = ubound(SrcParamData%Nodes_I)
      if (.not. allocated(DstParamData%Nodes_I)) then
         allocate(DstParamData%Nodes_I(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Nodes_I.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Nodes_I = SrcParamData%Nodes_I
   end if
   if (allocated(SrcParamData%Nodes_L)) then
      LB(1:2) = lbound(SrcParamData%Nodes_L)
      UB(1:2) = ubound(SrcParamData%Nodes_L)
      if (.not. allocated(DstParamData%Nodes_L)) then
         allocate(DstParamData%Nodes_L(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Nodes_L.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Nodes_L = SrcParamData%Nodes_L
   end if
   if (allocated(SrcParamData%Nodes_C)) then
      LB(1:2) = lbound(SrcParamData%Nodes_C)
      UB(1:2) = ubound(SrcParamData%Nodes_C)
      if (.not. allocated(DstParamData%Nodes_C)) then
         allocate(DstParamData%Nodes_C(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Nodes_C.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Nodes_C = SrcParamData%Nodes_C
   end if
   DstParamData%nDOFI__ = SrcParamData%nDOFI__
   DstParamData%nDOFI_Rb = SrcParamData%nDOFI_Rb
   DstParamData%nDOFI_F = SrcParamData%nDOFI_F
   DstParamData%nDOFL_L = SrcParamData%nDOFL_L
   DstParamData%nDOFC__ = SrcParamData%nDOFC__
   DstParamData%nDOFC_Rb = SrcParamData%nDOFC_Rb
   DstParamData%nDOFC_L = SrcParamData%nDOFC_L
   DstParamData%nDOFC_F = SrcParamData%nDOFC_F
   DstParamData%nDOFR__ = SrcParamData%nDOFR__
   DstParamData%nDOF__Rb = SrcParamData%nDOF__Rb
   DstParamData%nDOF__L = SrcParamData%nDOF__L
   DstParamData%nDOF__F = SrcParamData%nDOF__F
   if (allocated(SrcParamData%IDI__)) then
      LB(1:1) = lbound(SrcParamData%IDI__)
      UB(1:1) = ubound(SrcParamData%IDI__)
      if (.not. allocated(DstParamData%IDI__)) then
         allocate(DstParamData%IDI__(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%IDI__.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%IDI__ = SrcParamData%IDI__
   end if
   if (allocated(SrcParamData%IDI_Rb)) then
      LB(1:1) = lbound(SrcParamData%IDI_Rb)
      UB(1:1) = ubound(SrcParamData%IDI_Rb)
      if (.not. allocated(DstParamData%IDI_Rb)) then
         allocate(DstParamData%IDI_Rb(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%IDI_Rb.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%IDI_Rb = SrcParamData%IDI_Rb
   end if
   if (allocated(SrcParamData%IDI_F)) then
      LB(1:1) = lbound(SrcParamData%IDI_F)
      UB(1:1) = ubound(SrcParamData%IDI_F)
      if (.not. allocated(DstParamData%IDI_F)) then
         allocate(DstParamData%IDI_F(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%IDI_F.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%IDI_F = SrcParamData%IDI_F
   end if
   if (allocated(SrcParamData%IDL_L)) then
      LB(1:1) = lbound(SrcParamData%IDL_L)
      UB(1:1) = ubound(SrcParamData%IDL_L)
      if (.not. allocated(DstParamData%IDL_L)) then
         allocate(DstParamData%IDL_L(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%IDL_L.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%IDL_L = SrcParamData%IDL_L
   end if
   if (allocated(SrcParamData%IDC__)) then
      LB(1:1) = lbound(SrcParamData%IDC__)
      UB(1:1) = ubound(SrcParamData%IDC__)
      if (.not. allocated(DstParamData%IDC__)) then
         allocate(DstParamData%IDC__(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%IDC__.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%IDC__ = SrcParamData%IDC__
   end if
   if (allocated(SrcParamData%IDC_Rb)) then
      LB(1:1) = lbound(SrcParamData%IDC_Rb)
      UB(1:1) = ubound(SrcParamData%IDC_Rb)
      if (.not. allocated(DstParamData%IDC_Rb)) then
         allocate(DstParamData%IDC_Rb(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%IDC_Rb.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%IDC_Rb = SrcParamData%IDC_Rb
   end if
   if (allocated(SrcParamData%IDC_L)) then
      LB(1:1) = lbound(SrcParamData%IDC_L)
      UB(1:1) = ubound(SrcParamData%IDC_L)
      if (.not. allocated(DstParamData%IDC_L)) then
         allocate(DstParamData%IDC_L(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%IDC_L.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%IDC_L = SrcParamData%IDC_L
   end if
   if (allocated(SrcParamData%IDC_F)) then
      LB(1:1) = lbound(SrcParamData%IDC_F)
      UB(1:1) = ubound(SrcParamData%IDC_F)
      if (.not. allocated(DstParamData%IDC_F)) then
         allocate(DstParamData%IDC_F(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%IDC_F.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%IDC_F = SrcParamData%IDC_F
   end if
   if (allocated(SrcParamData%IDR__)) then
      LB(1:1) = lbound(SrcParamData%IDR__)
      UB(1:1) = ubound(SrcParamData%IDR__)
      if (.not. allocated(DstParamData%IDR__)) then
         allocate(DstParamData%IDR__(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%IDR__.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%IDR__ = SrcParamData%IDR__
   end if
   if (allocated(SrcParamData%ID__Rb)) then
      LB(1:1) = lbound(SrcParamData%ID__Rb)
      UB(1:1) = ubound(SrcParamData%ID__Rb)
      if (.not. allocated(DstParamData%ID__Rb)) then
         allocate(DstParamData%ID__Rb(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%ID__Rb.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%ID__Rb = SrcParamData%ID__Rb
   end if
   if (allocated(SrcParamData%ID__L)) then
      LB(1:1) = lbound(SrcParamData%ID__L)
      UB(1:1) = ubound(SrcParamData%ID__L)
      if (.not. allocated(DstParamData%ID__L)) then
         allocate(DstParamData%ID__L(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%ID__L.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%ID__L = SrcParamData%ID__L
   end if
   if (allocated(SrcParamData%ID__F)) then
      LB(1:1) = lbound(SrcParamData%ID__F)
      UB(1:1) = ubound(SrcParamData%ID__F)
      if (.not. allocated(DstParamData%ID__F)) then
         allocate(DstParamData%ID__F(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%ID__F.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%ID__F = SrcParamData%ID__F
   end if
   DstParamData%NMOutputs = SrcParamData%NMOutputs
   DstParamData%NumOuts = SrcParamData%NumOuts
   DstParamData%OutSwtch = SrcParamData%OutSwtch
   DstParamData%UnJckF = SrcParamData%UnJckF
   DstParamData%Delim = SrcParamData%Delim
   DstParamData%OutFmt = SrcParamData%OutFmt
   DstParamData%OutSFmt = SrcParamData%OutSFmt
   if (allocated(SrcParamData%MoutLst)) then
      LB(1:1) = lbound(SrcParamData%MoutLst)
      UB(1:1) = ubound(SrcParamData%MoutLst)
      if (.not. allocated(DstParamData%MoutLst)) then
         allocate(DstParamData%MoutLst(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%MoutLst.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call SD_CopyMeshAuxDataType(SrcParamData%MoutLst(i1), DstParamData%MoutLst(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcParamData%MoutLst2)) then
      LB(1:1) = lbound(SrcParamData%MoutLst2)
      UB(1:1) = ubound(SrcParamData%MoutLst2)
      if (.not. allocated(DstParamData%MoutLst2)) then
         allocate(DstParamData%MoutLst2(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%MoutLst2.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call SD_CopyMeshAuxDataType(SrcParamData%MoutLst2(i1), DstParamData%MoutLst2(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcParamData%MoutLst3)) then
      LB(1:1) = lbound(SrcParamData%MoutLst3)
      UB(1:1) = ubound(SrcParamData%MoutLst3)
      if (.not. allocated(DstParamData%MoutLst3)) then
         allocate(DstParamData%MoutLst3(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%MoutLst3.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call SD_CopyMeshAuxDataType(SrcParamData%MoutLst3(i1), DstParamData%MoutLst3(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcParamData%OutParam)) then
      LB(1:1) = lbound(SrcParamData%OutParam)
      UB(1:1) = ubound(SrcParamData%OutParam)
      if (.not. allocated(DstParamData%OutParam)) then
         allocate(DstParamData%OutParam(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%OutParam.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyOutParmType(SrcParamData%OutParam(i1), DstParamData%OutParam(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstParamData%OutAll = SrcParamData%OutAll
   DstParamData%OutCBModes = SrcParamData%OutCBModes
   DstParamData%OutFEMModes = SrcParamData%OutFEMModes
   DstParamData%OutReact = SrcParamData%OutReact
   DstParamData%OutAllInt = SrcParamData%OutAllInt
   DstParamData%OutAllDims = SrcParamData%OutAllDims
   DstParamData%OutDec = SrcParamData%OutDec
   if (allocated(SrcParamData%Jac_u_indx)) then
      LB(1:2) = lbound(SrcParamData%Jac_u_indx)
      UB(1:2) = ubound(SrcParamData%Jac_u_indx)
      if (.not. allocated(DstParamData%Jac_u_indx)) then
         allocate(DstParamData%Jac_u_indx(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Jac_u_indx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Jac_u_indx = SrcParamData%Jac_u_indx
   end if
   if (allocated(SrcParamData%du)) then
      LB(1:1) = lbound(SrcParamData%du)
      UB(1:1) = ubound(SrcParamData%du)
      if (.not. allocated(DstParamData%du)) then
         allocate(DstParamData%du(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%du.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%du = SrcParamData%du
   end if
   DstParamData%dx = SrcParamData%dx
   DstParamData%Jac_ny = SrcParamData%Jac_ny
   DstParamData%Jac_nx = SrcParamData%Jac_nx
   DstParamData%RotStates = SrcParamData%RotStates
end subroutine

subroutine SD_DestroyParam(ParamData, ErrStat, ErrMsg)
   type(SD_ParameterType), intent(inout) :: ParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SD_DestroyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ParamData%Elems)) then
      deallocate(ParamData%Elems)
   end if
   if (allocated(ParamData%ElemSpin)) then
      deallocate(ParamData%ElemSpin)
   end if
   if (allocated(ParamData%ElemProps)) then
      LB(1:1) = lbound(ParamData%ElemProps)
      UB(1:1) = ubound(ParamData%ElemProps)
      do i1 = LB(1), UB(1)
         call SD_DestroyElemPropType(ParamData%ElemProps(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%ElemProps)
   end if
   if (allocated(ParamData%FC)) then
      deallocate(ParamData%FC)
   end if
   if (allocated(ParamData%FG)) then
      deallocate(ParamData%FG)
   end if
   if (allocated(ParamData%DP0)) then
      deallocate(ParamData%DP0)
   end if
   if (allocated(ParamData%rPG)) then
      deallocate(ParamData%rPG)
   end if
   if (allocated(ParamData%NodeID2JointID)) then
      deallocate(ParamData%NodeID2JointID)
   end if
   if (allocated(ParamData%CMassNode)) then
      deallocate(ParamData%CMassNode)
   end if
   if (allocated(ParamData%CMassWeight)) then
      deallocate(ParamData%CMassWeight)
   end if
   if (allocated(ParamData%CMassOffset)) then
      deallocate(ParamData%CMassOffset)
   end if
   if (allocated(ParamData%T_red)) then
      deallocate(ParamData%T_red)
   end if
   if (allocated(ParamData%T_red_T)) then
      deallocate(ParamData%T_red_T)
   end if
   if (allocated(ParamData%NodesDOF)) then
      LB(1:1) = lbound(ParamData%NodesDOF)
      UB(1:1) = ubound(ParamData%NodesDOF)
      do i1 = LB(1), UB(1)
         call SD_DestroyIList(ParamData%NodesDOF(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%NodesDOF)
   end if
   if (allocated(ParamData%NodesDOFred)) then
      LB(1:1) = lbound(ParamData%NodesDOFred)
      UB(1:1) = ubound(ParamData%NodesDOFred)
      do i1 = LB(1), UB(1)
         call SD_DestroyIList(ParamData%NodesDOFred(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%NodesDOFred)
   end if
   if (allocated(ParamData%ElemsDOF)) then
      deallocate(ParamData%ElemsDOF)
   end if
   if (allocated(ParamData%DOFred2Nodes)) then
      deallocate(ParamData%DOFred2Nodes)
   end if
   if (allocated(ParamData%CtrlElem2Channel)) then
      deallocate(ParamData%CtrlElem2Channel)
   end if
   if (allocated(ParamData%KMMDiag)) then
      deallocate(ParamData%KMMDiag)
   end if
   if (allocated(ParamData%CMMDiag)) then
      deallocate(ParamData%CMMDiag)
   end if
   if (allocated(ParamData%MMB)) then
      deallocate(ParamData%MMB)
   end if
   if (allocated(ParamData%MBmmB)) then
      deallocate(ParamData%MBmmB)
   end if
   if (allocated(ParamData%C1_11)) then
      deallocate(ParamData%C1_11)
   end if
   if (allocated(ParamData%C1_12)) then
      deallocate(ParamData%C1_12)
   end if
   if (allocated(ParamData%D1_141)) then
      deallocate(ParamData%D1_141)
   end if
   if (allocated(ParamData%D1_142)) then
      deallocate(ParamData%D1_142)
   end if
   if (allocated(ParamData%PhiM)) then
      deallocate(ParamData%PhiM)
   end if
   if (allocated(ParamData%C2_61)) then
      deallocate(ParamData%C2_61)
   end if
   if (allocated(ParamData%C2_62)) then
      deallocate(ParamData%C2_62)
   end if
   if (allocated(ParamData%PhiRb_TI)) then
      deallocate(ParamData%PhiRb_TI)
   end if
   if (allocated(ParamData%D2_63)) then
      deallocate(ParamData%D2_63)
   end if
   if (allocated(ParamData%D2_64)) then
      deallocate(ParamData%D2_64)
   end if
   if (allocated(ParamData%MBB)) then
      deallocate(ParamData%MBB)
   end if
   if (allocated(ParamData%KBB)) then
      deallocate(ParamData%KBB)
   end if
   if (allocated(ParamData%CBB)) then
      deallocate(ParamData%CBB)
   end if
   if (allocated(ParamData%CMM)) then
      deallocate(ParamData%CMM)
   end if
   if (allocated(ParamData%MBM)) then
      deallocate(ParamData%MBM)
   end if
   if (allocated(ParamData%PhiL_T)) then
      deallocate(ParamData%PhiL_T)
   end if
   if (allocated(ParamData%PhiLInvOmgL2)) then
      deallocate(ParamData%PhiLInvOmgL2)
   end if
   if (allocated(ParamData%KLLm1)) then
      deallocate(ParamData%KLLm1)
   end if
   if (allocated(ParamData%AM2Jac)) then
      deallocate(ParamData%AM2Jac)
   end if
   if (allocated(ParamData%AM2JacPiv)) then
      deallocate(ParamData%AM2JacPiv)
   end if
   if (allocated(ParamData%TI)) then
      deallocate(ParamData%TI)
   end if
   if (allocated(ParamData%TIreact)) then
      deallocate(ParamData%TIreact)
   end if
   if (allocated(ParamData%Nodes_I)) then
      deallocate(ParamData%Nodes_I)
   end if
   if (allocated(ParamData%Nodes_L)) then
      deallocate(ParamData%Nodes_L)
   end if
   if (allocated(ParamData%Nodes_C)) then
      deallocate(ParamData%Nodes_C)
   end if
   if (allocated(ParamData%IDI__)) then
      deallocate(ParamData%IDI__)
   end if
   if (allocated(ParamData%IDI_Rb)) then
      deallocate(ParamData%IDI_Rb)
   end if
   if (allocated(ParamData%IDI_F)) then
      deallocate(ParamData%IDI_F)
   end if
   if (allocated(ParamData%IDL_L)) then
      deallocate(ParamData%IDL_L)
   end if
   if (allocated(ParamData%IDC__)) then
      deallocate(ParamData%IDC__)
   end if
   if (allocated(ParamData%IDC_Rb)) then
      deallocate(ParamData%IDC_Rb)
   end if
   if (allocated(ParamData%IDC_L)) then
      deallocate(ParamData%IDC_L)
   end if
   if (allocated(ParamData%IDC_F)) then
      deallocate(ParamData%IDC_F)
   end if
   if (allocated(ParamData%IDR__)) then
      deallocate(ParamData%IDR__)
   end if
   if (allocated(ParamData%ID__Rb)) then
      deallocate(ParamData%ID__Rb)
   end if
   if (allocated(ParamData%ID__L)) then
      deallocate(ParamData%ID__L)
   end if
   if (allocated(ParamData%ID__F)) then
      deallocate(ParamData%ID__F)
   end if
   if (allocated(ParamData%MoutLst)) then
      LB(1:1) = lbound(ParamData%MoutLst)
      UB(1:1) = ubound(ParamData%MoutLst)
      do i1 = LB(1), UB(1)
         call SD_DestroyMeshAuxDataType(ParamData%MoutLst(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%MoutLst)
   end if
   if (allocated(ParamData%MoutLst2)) then
      LB(1:1) = lbound(ParamData%MoutLst2)
      UB(1:1) = ubound(ParamData%MoutLst2)
      do i1 = LB(1), UB(1)
         call SD_DestroyMeshAuxDataType(ParamData%MoutLst2(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%MoutLst2)
   end if
   if (allocated(ParamData%MoutLst3)) then
      LB(1:1) = lbound(ParamData%MoutLst3)
      UB(1:1) = ubound(ParamData%MoutLst3)
      do i1 = LB(1), UB(1)
         call SD_DestroyMeshAuxDataType(ParamData%MoutLst3(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%MoutLst3)
   end if
   if (allocated(ParamData%OutParam)) then
      LB(1:1) = lbound(ParamData%OutParam)
      UB(1:1) = ubound(ParamData%OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyOutParmType(ParamData%OutParam(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%OutParam)
   end if
   if (allocated(ParamData%Jac_u_indx)) then
      deallocate(ParamData%Jac_u_indx)
   end if
   if (allocated(ParamData%du)) then
      deallocate(ParamData%du)
   end if
end subroutine

subroutine SD_PackParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SD_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SD_PackParam'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%g)
   call RegPack(RF, InData%SDDeltaT)
   call RegPack(RF, InData%IntMethod)
   call RegPack(RF, InData%nDOF)
   call RegPack(RF, InData%nDOF_red)
   call RegPack(RF, InData%Nmembers)
   call RegPackAlloc(RF, InData%Elems)
   call RegPackAlloc(RF, InData%ElemSpin)
   call RegPack(RF, allocated(InData%ElemProps))
   if (allocated(InData%ElemProps)) then
      call RegPackBounds(RF, 1, lbound(InData%ElemProps), ubound(InData%ElemProps))
      LB(1:1) = lbound(InData%ElemProps)
      UB(1:1) = ubound(InData%ElemProps)
      do i1 = LB(1), UB(1)
         call SD_PackElemPropType(RF, InData%ElemProps(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%FC)
   call RegPackAlloc(RF, InData%FG)
   call RegPackAlloc(RF, InData%DP0)
   call RegPackAlloc(RF, InData%rPG)
   call RegPackAlloc(RF, InData%NodeID2JointID)
   call RegPackAlloc(RF, InData%CMassNode)
   call RegPackAlloc(RF, InData%CMassWeight)
   call RegPackAlloc(RF, InData%CMassOffset)
   call RegPack(RF, InData%reduced)
   call RegPackAlloc(RF, InData%T_red)
   call RegPackAlloc(RF, InData%T_red_T)
   call RegPack(RF, allocated(InData%NodesDOF))
   if (allocated(InData%NodesDOF)) then
      call RegPackBounds(RF, 1, lbound(InData%NodesDOF), ubound(InData%NodesDOF))
      LB(1:1) = lbound(InData%NodesDOF)
      UB(1:1) = ubound(InData%NodesDOF)
      do i1 = LB(1), UB(1)
         call SD_PackIList(RF, InData%NodesDOF(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%NodesDOFred))
   if (allocated(InData%NodesDOFred)) then
      call RegPackBounds(RF, 1, lbound(InData%NodesDOFred), ubound(InData%NodesDOFred))
      LB(1:1) = lbound(InData%NodesDOFred)
      UB(1:1) = ubound(InData%NodesDOFred)
      do i1 = LB(1), UB(1)
         call SD_PackIList(RF, InData%NodesDOFred(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%ElemsDOF)
   call RegPackAlloc(RF, InData%DOFred2Nodes)
   call RegPackAlloc(RF, InData%CtrlElem2Channel)
   call RegPack(RF, InData%nDOFM)
   call RegPack(RF, InData%SttcSolve)
   call RegPack(RF, InData%GuyanLoadCorrection)
   call RegPack(RF, InData%Floating)
   call RegPackAlloc(RF, InData%KMMDiag)
   call RegPackAlloc(RF, InData%CMMDiag)
   call RegPackAlloc(RF, InData%MMB)
   call RegPackAlloc(RF, InData%MBmmB)
   call RegPackAlloc(RF, InData%C1_11)
   call RegPackAlloc(RF, InData%C1_12)
   call RegPackAlloc(RF, InData%D1_141)
   call RegPackAlloc(RF, InData%D1_142)
   call RegPackAlloc(RF, InData%PhiM)
   call RegPackAlloc(RF, InData%C2_61)
   call RegPackAlloc(RF, InData%C2_62)
   call RegPackAlloc(RF, InData%PhiRb_TI)
   call RegPackAlloc(RF, InData%D2_63)
   call RegPackAlloc(RF, InData%D2_64)
   call RegPackAlloc(RF, InData%MBB)
   call RegPackAlloc(RF, InData%KBB)
   call RegPackAlloc(RF, InData%CBB)
   call RegPackAlloc(RF, InData%CMM)
   call RegPackAlloc(RF, InData%MBM)
   call RegPackAlloc(RF, InData%PhiL_T)
   call RegPackAlloc(RF, InData%PhiLInvOmgL2)
   call RegPackAlloc(RF, InData%KLLm1)
   call RegPackAlloc(RF, InData%AM2Jac)
   call RegPackAlloc(RF, InData%AM2JacPiv)
   call RegPackAlloc(RF, InData%TI)
   call RegPackAlloc(RF, InData%TIreact)
   call RegPack(RF, InData%nNodes)
   call RegPack(RF, InData%nNodes_I)
   call RegPack(RF, InData%nNodes_L)
   call RegPack(RF, InData%nNodes_C)
   call RegPackAlloc(RF, InData%Nodes_I)
   call RegPackAlloc(RF, InData%Nodes_L)
   call RegPackAlloc(RF, InData%Nodes_C)
   call RegPack(RF, InData%nDOFI__)
   call RegPack(RF, InData%nDOFI_Rb)
   call RegPack(RF, InData%nDOFI_F)
   call RegPack(RF, InData%nDOFL_L)
   call RegPack(RF, InData%nDOFC__)
   call RegPack(RF, InData%nDOFC_Rb)
   call RegPack(RF, InData%nDOFC_L)
   call RegPack(RF, InData%nDOFC_F)
   call RegPack(RF, InData%nDOFR__)
   call RegPack(RF, InData%nDOF__Rb)
   call RegPack(RF, InData%nDOF__L)
   call RegPack(RF, InData%nDOF__F)
   call RegPackAlloc(RF, InData%IDI__)
   call RegPackAlloc(RF, InData%IDI_Rb)
   call RegPackAlloc(RF, InData%IDI_F)
   call RegPackAlloc(RF, InData%IDL_L)
   call RegPackAlloc(RF, InData%IDC__)
   call RegPackAlloc(RF, InData%IDC_Rb)
   call RegPackAlloc(RF, InData%IDC_L)
   call RegPackAlloc(RF, InData%IDC_F)
   call RegPackAlloc(RF, InData%IDR__)
   call RegPackAlloc(RF, InData%ID__Rb)
   call RegPackAlloc(RF, InData%ID__L)
   call RegPackAlloc(RF, InData%ID__F)
   call RegPack(RF, InData%NMOutputs)
   call RegPack(RF, InData%NumOuts)
   call RegPack(RF, InData%OutSwtch)
   call RegPack(RF, InData%UnJckF)
   call RegPack(RF, InData%Delim)
   call RegPack(RF, InData%OutFmt)
   call RegPack(RF, InData%OutSFmt)
   call RegPack(RF, allocated(InData%MoutLst))
   if (allocated(InData%MoutLst)) then
      call RegPackBounds(RF, 1, lbound(InData%MoutLst), ubound(InData%MoutLst))
      LB(1:1) = lbound(InData%MoutLst)
      UB(1:1) = ubound(InData%MoutLst)
      do i1 = LB(1), UB(1)
         call SD_PackMeshAuxDataType(RF, InData%MoutLst(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%MoutLst2))
   if (allocated(InData%MoutLst2)) then
      call RegPackBounds(RF, 1, lbound(InData%MoutLst2), ubound(InData%MoutLst2))
      LB(1:1) = lbound(InData%MoutLst2)
      UB(1:1) = ubound(InData%MoutLst2)
      do i1 = LB(1), UB(1)
         call SD_PackMeshAuxDataType(RF, InData%MoutLst2(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%MoutLst3))
   if (allocated(InData%MoutLst3)) then
      call RegPackBounds(RF, 1, lbound(InData%MoutLst3), ubound(InData%MoutLst3))
      LB(1:1) = lbound(InData%MoutLst3)
      UB(1:1) = ubound(InData%MoutLst3)
      do i1 = LB(1), UB(1)
         call SD_PackMeshAuxDataType(RF, InData%MoutLst3(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%OutParam))
   if (allocated(InData%OutParam)) then
      call RegPackBounds(RF, 1, lbound(InData%OutParam), ubound(InData%OutParam))
      LB(1:1) = lbound(InData%OutParam)
      UB(1:1) = ubound(InData%OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackOutParmType(RF, InData%OutParam(i1)) 
      end do
   end if
   call RegPack(RF, InData%OutAll)
   call RegPack(RF, InData%OutCBModes)
   call RegPack(RF, InData%OutFEMModes)
   call RegPack(RF, InData%OutReact)
   call RegPack(RF, InData%OutAllInt)
   call RegPack(RF, InData%OutAllDims)
   call RegPack(RF, InData%OutDec)
   call RegPackAlloc(RF, InData%Jac_u_indx)
   call RegPackAlloc(RF, InData%du)
   call RegPack(RF, InData%dx)
   call RegPack(RF, InData%Jac_ny)
   call RegPack(RF, InData%Jac_nx)
   call RegPack(RF, InData%RotStates)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SD_UnPackParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SD_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SD_UnPackParam'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%g); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SDDeltaT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%IntMethod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nDOF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nDOF_red); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Nmembers); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Elems); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%ElemSpin); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%ElemProps)) deallocate(OutData%ElemProps)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%ElemProps(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%ElemProps.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call SD_UnpackElemPropType(RF, OutData%ElemProps(i1)) ! ElemProps 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%FC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%FG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%DP0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%rPG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%NodeID2JointID); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%CMassNode); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%CMassWeight); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%CMassOffset); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%reduced); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%T_red); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%T_red_T); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%NodesDOF)) deallocate(OutData%NodesDOF)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%NodesDOF(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%NodesDOF.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call SD_UnpackIList(RF, OutData%NodesDOF(i1)) ! NodesDOF 
      end do
   end if
   if (allocated(OutData%NodesDOFred)) deallocate(OutData%NodesDOFred)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%NodesDOFred(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%NodesDOFred.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call SD_UnpackIList(RF, OutData%NodesDOFred(i1)) ! NodesDOFred 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%ElemsDOF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%DOFred2Nodes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%CtrlElem2Channel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nDOFM); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SttcSolve); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GuyanLoadCorrection); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Floating); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%KMMDiag); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%CMMDiag); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%MMB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%MBmmB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%C1_11); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%C1_12); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%D1_141); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%D1_142); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PhiM); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%C2_61); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%C2_62); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PhiRb_TI); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%D2_63); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%D2_64); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%MBB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%KBB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%CBB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%CMM); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%MBM); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PhiL_T); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PhiLInvOmgL2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%KLLm1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AM2Jac); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AM2JacPiv); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TI); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TIreact); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nNodes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nNodes_I); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nNodes_L); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nNodes_C); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Nodes_I); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Nodes_L); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Nodes_C); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nDOFI__); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nDOFI_Rb); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nDOFI_F); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nDOFL_L); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nDOFC__); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nDOFC_Rb); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nDOFC_L); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nDOFC_F); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nDOFR__); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nDOF__Rb); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nDOF__L); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nDOF__F); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%IDI__); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%IDI_Rb); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%IDI_F); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%IDL_L); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%IDC__); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%IDC_Rb); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%IDC_L); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%IDC_F); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%IDR__); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%ID__Rb); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%ID__L); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%ID__F); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NMOutputs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutSwtch); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UnJckF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Delim); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutFmt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutSFmt); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%MoutLst)) deallocate(OutData%MoutLst)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%MoutLst(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%MoutLst.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call SD_UnpackMeshAuxDataType(RF, OutData%MoutLst(i1)) ! MoutLst 
      end do
   end if
   if (allocated(OutData%MoutLst2)) deallocate(OutData%MoutLst2)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%MoutLst2(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%MoutLst2.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call SD_UnpackMeshAuxDataType(RF, OutData%MoutLst2(i1)) ! MoutLst2 
      end do
   end if
   if (allocated(OutData%MoutLst3)) deallocate(OutData%MoutLst3)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%MoutLst3(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%MoutLst3.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call SD_UnpackMeshAuxDataType(RF, OutData%MoutLst3(i1)) ! MoutLst3 
      end do
   end if
   if (allocated(OutData%OutParam)) deallocate(OutData%OutParam)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%OutParam(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%OutParam.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackOutParmType(RF, OutData%OutParam(i1)) ! OutParam 
      end do
   end if
   call RegUnpack(RF, OutData%OutAll); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutCBModes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutFEMModes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutReact); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutAllInt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutAllDims); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutDec); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Jac_u_indx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%du); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Jac_ny); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Jac_nx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RotStates); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SD_CopyInput(SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg)
   type(SD_InputType), intent(inout) :: SrcInputData
   type(SD_InputType), intent(inout) :: DstInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SD_CopyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshCopy(SrcInputData%TPMesh, DstInputData%TPMesh, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcInputData%LMesh, DstInputData%LMesh, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcInputData%CableDeltaL)) then
      LB(1:1) = lbound(SrcInputData%CableDeltaL)
      UB(1:1) = ubound(SrcInputData%CableDeltaL)
      if (.not. allocated(DstInputData%CableDeltaL)) then
         allocate(DstInputData%CableDeltaL(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%CableDeltaL.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%CableDeltaL = SrcInputData%CableDeltaL
   end if
end subroutine

subroutine SD_DestroyInput(InputData, ErrStat, ErrMsg)
   type(SD_InputType), intent(inout) :: InputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SD_DestroyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshDestroy( InputData%TPMesh, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( InputData%LMesh, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(InputData%CableDeltaL)) then
      deallocate(InputData%CableDeltaL)
   end if
end subroutine

subroutine SD_PackInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SD_InputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SD_PackInput'
   if (RF%ErrStat >= AbortErrLev) return
   call MeshPack(RF, InData%TPMesh) 
   call MeshPack(RF, InData%LMesh) 
   call RegPackAlloc(RF, InData%CableDeltaL)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SD_UnPackInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SD_InputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SD_UnPackInput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call MeshUnpack(RF, OutData%TPMesh) ! TPMesh 
   call MeshUnpack(RF, OutData%LMesh) ! LMesh 
   call RegUnpackAlloc(RF, OutData%CableDeltaL); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SD_CopyOutput(SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg)
   type(SD_OutputType), intent(inout) :: SrcOutputData
   type(SD_OutputType), intent(inout) :: DstOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SD_CopyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshCopy(SrcOutputData%Y1Mesh, DstOutputData%Y1Mesh, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcOutputData%Y2Mesh, DstOutputData%Y2Mesh, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcOutputData%Y3Mesh, DstOutputData%Y3Mesh, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcOutputData%WriteOutput)) then
      LB(1:1) = lbound(SrcOutputData%WriteOutput)
      UB(1:1) = ubound(SrcOutputData%WriteOutput)
      if (.not. allocated(DstOutputData%WriteOutput)) then
         allocate(DstOutputData%WriteOutput(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%WriteOutput.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%WriteOutput = SrcOutputData%WriteOutput
   end if
end subroutine

subroutine SD_DestroyOutput(OutputData, ErrStat, ErrMsg)
   type(SD_OutputType), intent(inout) :: OutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SD_DestroyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshDestroy( OutputData%Y1Mesh, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( OutputData%Y2Mesh, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( OutputData%Y3Mesh, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(OutputData%WriteOutput)) then
      deallocate(OutputData%WriteOutput)
   end if
end subroutine

subroutine SD_PackOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SD_OutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SD_PackOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call MeshPack(RF, InData%Y1Mesh) 
   call MeshPack(RF, InData%Y2Mesh) 
   call MeshPack(RF, InData%Y3Mesh) 
   call RegPackAlloc(RF, InData%WriteOutput)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SD_UnPackOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SD_OutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SD_UnPackOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call MeshUnpack(RF, OutData%Y1Mesh) ! Y1Mesh 
   call MeshUnpack(RF, OutData%Y2Mesh) ! Y2Mesh 
   call MeshUnpack(RF, OutData%Y3Mesh) ! Y3Mesh 
   call RegUnpackAlloc(RF, OutData%WriteOutput); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SD_Input_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
   ! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(SD_InputType), intent(inout)  :: u(:) ! Input at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Inputs
   type(SD_InputType), intent(inout)  :: u_out ! Input at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'SD_Input_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(u)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(u)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(u) - 1
   select case (order)
   case (0)
      call SD_CopyInput(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call SD_Input_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call SD_Input_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(u) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE SD_Input_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

   TYPE(SD_InputType), INTENT(INOUT)  :: u1    ! Input at t1 > t2
   TYPE(SD_InputType), INTENT(INOUT)  :: u2    ! Input at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Inputs
   TYPE(SD_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'SD_Input_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   CALL MeshExtrapInterp1(u1%TPMesh, u2%TPMesh, tin, u_out%TPMesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp1(u1%LMesh, u2%LMesh, tin, u_out%LMesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   IF (ALLOCATED(u_out%CableDeltaL) .AND. ALLOCATED(u1%CableDeltaL)) THEN
      u_out%CableDeltaL = a1*u1%CableDeltaL + a2*u2%CableDeltaL
   END IF ! check if allocated
END SUBROUTINE

SUBROUTINE SD_Input_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

   TYPE(SD_InputType), INTENT(INOUT)  :: u1      ! Input at t1 > t2 > t3
   TYPE(SD_InputType), INTENT(INOUT)  :: u2      ! Input at t2 > t3
   TYPE(SD_InputType), INTENT(INOUT)  :: u3      ! Input at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Inputs
   TYPE(SD_InputType), INTENT(INOUT)  :: u_out     ! Input at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'SD_Input_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   CALL MeshExtrapInterp2(u1%TPMesh, u2%TPMesh, u3%TPMesh, tin, u_out%TPMesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp2(u1%LMesh, u2%LMesh, u3%LMesh, tin, u_out%LMesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   IF (ALLOCATED(u_out%CableDeltaL) .AND. ALLOCATED(u1%CableDeltaL)) THEN
      u_out%CableDeltaL = a1*u1%CableDeltaL + a2*u2%CableDeltaL + a3*u3%CableDeltaL
   END IF ! check if allocated
END SUBROUTINE

subroutine SD_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
   ! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(SD_OutputType), intent(inout)  :: y(:) ! Output at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Outputs
   type(SD_OutputType), intent(inout)  :: y_out ! Output at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'SD_Output_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(y)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(y)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(y) - 1
   select case (order)
   case (0)
      call SD_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call SD_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call SD_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(y) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE SD_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

   TYPE(SD_OutputType), INTENT(INOUT)  :: y1    ! Output at t1 > t2
   TYPE(SD_OutputType), INTENT(INOUT)  :: y2    ! Output at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
   TYPE(SD_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'SD_Output_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   CALL MeshExtrapInterp1(y1%Y1Mesh, y2%Y1Mesh, tin, y_out%Y1Mesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp1(y1%Y2Mesh, y2%Y2Mesh, tin, y_out%Y2Mesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp1(y1%Y3Mesh, y2%Y3Mesh, tin, y_out%Y3Mesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
      y_out%WriteOutput = a1*y1%WriteOutput + a2*y2%WriteOutput
   END IF ! check if allocated
END SUBROUTINE

SUBROUTINE SD_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

   TYPE(SD_OutputType), INTENT(INOUT)  :: y1      ! Output at t1 > t2 > t3
   TYPE(SD_OutputType), INTENT(INOUT)  :: y2      ! Output at t2 > t3
   TYPE(SD_OutputType), INTENT(INOUT)  :: y3      ! Output at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
   TYPE(SD_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'SD_Output_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   CALL MeshExtrapInterp2(y1%Y1Mesh, y2%Y1Mesh, y3%Y1Mesh, tin, y_out%Y1Mesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp2(y1%Y2Mesh, y2%Y2Mesh, y3%Y2Mesh, tin, y_out%Y2Mesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp2(y1%Y3Mesh, y2%Y3Mesh, y3%Y3Mesh, tin, y_out%Y3Mesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
      y_out%WriteOutput = a1*y1%WriteOutput + a2*y2%WriteOutput + a3*y3%WriteOutput
   END IF ! check if allocated
END SUBROUTINE
END MODULE SubDyn_Types
!ENDOFREGISTRYGENERATEDFILE
