!STARTOFREGISTRYGENERATEDFILE 'SED_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! SED_Types
!.................................................................................................................................
! This file is part of SED.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in SED. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE SED_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE NWTC_Library
IMPLICIT NONE
    INTEGER(IntKi), PUBLIC, PARAMETER  :: SED_NMX = 4      ! Used in updating predictor-corrector values (size of state history) [-]
! =========  SED_InputFile  =======
  TYPE, PUBLIC :: SED_InputFile
    LOGICAL  :: Echo = .false.      !< Echo the input file [-]
    REAL(DbKi)  :: DT = 0.0_R8Ki      !< Time step for module time integration [s]
    INTEGER(IntKi)  :: IntMethod = 0_IntKi      !< Integration method {1: RK4, 2: AB4, or 3: ABM4} [-]
    LOGICAL  :: GenDOF = .false.      !< whether the generator is fixed or free [-]
    LOGICAL  :: YawDOF = .false.      !< Yaw controlled by controller, or fixed [-]
    REAL(R8Ki)  :: Azimuth = 0.0_R8Ki      !< Initial azimuth angle for blade 1 [deg]
    REAL(ReKi)  :: BlPitch = 0.0_ReKi      !< Initial blade pitch angles [radians]
    REAL(ReKi)  :: RotSpeed = 0.0_ReKi      !< Initial or fixed rotor speed [RPM]
    REAL(ReKi)  :: NacYaw = 0.0_ReKi      !< Initial or fixed nacelle yaw [deg]
    REAL(ReKi)  :: PtfmPitch = 0.0_ReKi      !< Fixed pitch tilt rotational displacement of platform [deg]
    INTEGER(IntKi)  :: NumBl = 0_IntKi      !< Number of blades on the turbine [-]
    REAL(ReKi)  :: TipRad = 0.0_ReKi      !< Preconed blade-tip radius (distance from the rotor apex to the blade tip) [m]
    REAL(ReKi)  :: HubRad = 0.0_ReKi      !< Preconed hub radius (distance from the rotor apex to the blade root) [m]
    REAL(ReKi)  :: PreCone = 0.0_ReKi      !< Rotor precone angles [deg]
    REAL(ReKi)  :: OverHang = 0.0_ReKi      !< Distance from yaw axis to rotor apex or teeter pin [m]
    REAL(ReKi)  :: ShftTilt = 0.0_ReKi      !< Rotor shaft tilt angle [deg]
    REAL(ReKi)  :: Twr2Shft = 0.0_ReKi      !< Vertical distance from the tower-top to the rotor shaft [m]
    REAL(ReKi)  :: TowerHt = 0.0_ReKi      !< Height of tower above ground level [onshore] or MSL [offshore] [m]
    REAL(ReKi)  :: RotIner = 0.0_ReKi      !< Hub inertia about teeter axis (2-blader) or rotor axis (3-blader) [kg m^2]
    REAL(ReKi)  :: GenIner = 0.0_ReKi      !< Generator inertia about HSS [kg m^2]
    REAL(ReKi)  :: GBoxRatio = 0.0_ReKi      !< Gearbox ratio [-]
    LOGICAL  :: SumPrint = .false.      !< Print summary data to <RootName>.sum [-]
    INTEGER(IntKi)  :: NumOuts = 0_IntKi      !< Number of outputs [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: OutList      !< List of user-requested output channels [-]
  END TYPE SED_InputFile
! =======================
! =========  SED_InitInputType  =======
  TYPE, PUBLIC :: SED_InitInputType
    CHARACTER(1024)  :: InputFile      !< Name of the input file [-]
    CHARACTER(1024)  :: RootName      !< RootName for writing output files [-]
    LOGICAL  :: Linearize = .false.      !< this module cannot be linearized at present [-]
    LOGICAL  :: UseInputFile = .TRUE.      !< Supplied by Driver:  .TRUE. if using a input file, .FALSE. if all inputs are being passed in by the caller [-]
    TYPE(FileInfoType)  :: PassedFileData      !< If we don't use the input file, pass everything through this [-]
  END TYPE SED_InitInputType
! =======================
! =========  SED_InitOutputType  =======
  TYPE, PUBLIC :: SED_InitOutputType
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputHdr      !< Names of the output-to-file channels [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputUnt      !< Units of the output-to-file channels [-]
    TYPE(ProgDesc)  :: Ver      !< This module's name, version, and date [-]
    INTEGER(IntKi)  :: NumBl = 0_IntKi      !< Number of blades on the turbine [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BlPitch      !< Initial blade pitch angles [radians]
    REAL(ReKi)  :: BladeLength = 0.0_ReKi      !< Blade length (for AeroDsk) [meters]
    REAL(ReKi)  :: TowerHt = 0.0_ReKi      !< Tower Height [meters]
    REAL(ReKi)  :: HubHt = 0.0_ReKi      !< Height of the hub [meters]
    REAL(ReKi) , DIMENSION(1:6)  :: PlatformPos = 0.0_ReKi      !< Initial platform position (6 DOFs) [-]
    REAL(ReKi)  :: HubRad = 0.0_ReKi      !< Preconed hub radius (distance from the rotor apex to the blade root) [m]
    REAL(ReKi)  :: RotSpeed = 0.0_ReKi      !< Initial or fixed rotor speed [rad/s]
    LOGICAL  :: GenDOF = .false.      !< whether the generator DOF is on (true) or off (false) [-]
  END TYPE SED_InitOutputType
! =======================
! =========  SED_InputType  =======
  TYPE, PUBLIC :: SED_InputType
    TYPE(MeshType)  :: HubPtLoad      !< AeroDyn/AeroDisk maps load to hub [-]
    REAL(ReKi)  :: HSSBrTrqC = 0.0_ReKi      !< Commanded HSS brake torque [N-m]
    REAL(ReKi)  :: GenTrq = 0.0_ReKi      !< Electrical generator torque [N-m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BlPitchCom      !< Commanded blade pitch angles [radians]
    REAL(ReKi)  :: YawPosCom = 0.0_ReKi      !< Yaw angle commanded [rad]
    REAL(ReKi)  :: YawRateCom = 0.0_ReKi      !< Yaw rate  commanded [rad/s]
  END TYPE SED_InputType
! =======================
! =========  SED_OutputType  =======
  TYPE, PUBLIC :: SED_OutputType
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: BladeRootMotion      !< For AeroDyn: motions at the blade roots [-]
    TYPE(MeshType)  :: HubPtMotion      !< For AeroDyn/AeroDisk: motions of the hub [-]
    TYPE(MeshType)  :: NacelleMotion      !< For AeroDyn: for aero effects in AD (aero nacelle loads ignored) [-]
    TYPE(MeshType)  :: TowerLn2Mesh      !< Tower line2 mesh for visualization / Aero tower effects [-]
    TYPE(MeshType)  :: PlatformPtMesh      !< Platform reference point for visualization [-]
    REAL(ReKi)  :: LSSTipPxa = 0.0_ReKi      !< Rotor azimuth angle (position) [radians]
    REAL(ReKi)  :: RotSpeed = 0.0_ReKi      !< Rotor azimuth angular speed [rad/s]
    REAL(ReKi)  :: RotPwr = 0.0_ReKi      !< Rotor power [W]
    REAL(ReKi)  :: RotTrq = 0.0_ReKi      !< Rotor torque [N-m]
    REAL(ReKi)  :: HSS_Spd = 0.0_ReKi      !< High-speed shaft (HSS) speed [rad/s]
    REAL(ReKi)  :: Yaw = 0.0_ReKi      !< Yaw angle [rad]
    REAL(ReKi)  :: YawRate = 0.0_ReKi      !< Yaw rate [rad/s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BlPitch      !< Actual blade pitch [radians]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WriteOutput      !< Data to be written to an output file: see WriteOutputHdr for names of each variable [see WriteOutputUnt]
  END TYPE SED_OutputType
! =======================
! =========  SED_ContinuousStateType  =======
  TYPE, PUBLIC :: SED_ContinuousStateType
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: QT      !< Current estimate of Q (displacement matrix) for each degree of freedom [-]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: QDT      !< Current estimate of QD (velocity matrix) for each degree of freedom [-]
  END TYPE SED_ContinuousStateType
! =======================
! =========  SED_DiscreteStateType  =======
  TYPE, PUBLIC :: SED_DiscreteStateType
    REAL(ReKi)  :: DummyDiscreteState = 0.0_ReKi      !<  [-]
  END TYPE SED_DiscreteStateType
! =======================
! =========  SED_ConstraintStateType  =======
  TYPE, PUBLIC :: SED_ConstraintStateType
    REAL(ReKi)  :: DummyConstrState = 0.0_ReKi      !<  [-]
  END TYPE SED_ConstraintStateType
! =======================
! =========  SED_OtherStateType  =======
  TYPE, PUBLIC :: SED_OtherStateType
    INTEGER(IntKi)  :: n = 0_IntKi      !< tracks time step for which OtherState was updated [-]
    TYPE(SED_ContinuousStateType) , DIMENSION(1:SED_NMX)  :: xdot      !< previous state deriv for multi-step [-]
    INTEGER(IntKi) , DIMENSION(1:SED_NMX)  :: IC = 0_IntKi      !< Array which stores pointers to predictor-corrector results [-]
    REAL(ReKi)  :: HSSBrTrq = 0.0_ReKi      !< HSSBrTrq from update states; a hack to get this working with a single integrator [-]
    REAL(ReKi)  :: HSSBrTrqC = 0.0_ReKi      !< Commanded HSS brake torque (adjusted for sign) [N-m]
    INTEGER(IntKi)  :: SgnPrvLSTQ = 0_IntKi      !< The sign of the low-speed shaft torque from the previous call to RtHS(). NOTE: The low-speed shaft torque is assumed to be positive at the beginning of the run! [-]
    INTEGER(IntKi) , DIMENSION(1:SED_NMX)  :: SgnLSTQ = 0_IntKi      !< history of sign of LSTQ (for HSS brake) [-]
  END TYPE SED_OtherStateType
! =======================
! =========  SED_ParameterType  =======
  TYPE, PUBLIC :: SED_ParameterType
    CHARACTER(1024)  :: RootName      !< RootName for writing output files [-]
    LOGICAL  :: GenDOF = .false.      !< whether the generator DOF is on (free) or off (fixed) [-]
    LOGICAL  :: YawDOF = .false.      !< Yaw controlled by controller, or fixed [-]
    REAL(DbKi)  :: DT = 0.0_R8Ki      !< Time step for module time integration [s]
    REAL(DbKi)  :: DT24 = 0.0_R8Ki      !< Time step for solver [s]
    INTEGER(IntKi)  :: IntMethod = 0_IntKi      !< Integration method {1: RK4, 2: AB4, or 3: ABM4} [-]
    REAL(ReKi)  :: J_DT = 0.0_ReKi      !< Drivetrain inertia (blades+hub+shaft+generator) [kgm^2]
    REAL(ReKi)  :: PtfmPitch = 0.0_ReKi      !< Static platform tilt angle [rad]
    REAL(ReKi)  :: InitYaw = 0.0_ReKi      !< Initial or fixed nacelle yaw -- store in case YawDOF is off [deg]
    REAL(R8Ki)  :: InitAzimuth = 0.0_R8Ki      !< Initial azimuth angle for blade 1 [deg]
    REAL(ReKi)  :: RotIner = 0.0_ReKi      !< Hub inertia about teeter axis (2-blader) or rotor axis (3-blader) [kg m^2]
    REAL(ReKi)  :: GenIner = 0.0_ReKi      !< Generator inertia about HSS [kg m^2]
    REAL(ReKi)  :: GBoxRatio = 0.0_ReKi      !< Gearbox ratio [-]
    INTEGER(IntKi)  :: NumBl = 0_IntKi      !< Number of blades on the turbine [-]
    REAL(ReKi)  :: TipRad = 0.0_ReKi      !< Preconed blade-tip radius (distance from the rotor apex to the blade tip) [m]
    REAL(ReKi)  :: HubRad = 0.0_ReKi      !< Preconed hub radius (distance from the rotor apex to the blade root) [m]
    REAL(ReKi)  :: BladeLength = 0.0_ReKi      !< Length of blades [m]
    REAL(ReKi)  :: PreCone = 0.0_ReKi      !< Rotor precone angles [deg]
    REAL(ReKi)  :: OverHang = 0.0_ReKi      !< Distance from yaw axis to rotor apex or teeter pin [m]
    REAL(ReKi)  :: ShftTilt = 0.0_ReKi      !< Rotor shaft tilt angle [deg]
    REAL(ReKi)  :: Twr2Shft = 0.0_ReKi      !< Vertical distance from the tower-top to the rotor shaft [m]
    REAL(ReKi)  :: TowerHt = 0.0_ReKi      !< Height of tower above ground level [onshore] or MSL [offshore] [m]
    REAL(ReKi)  :: HubHt = 0.0_ReKi      !< Height of hub center above ground level [onshore] or MSL [offshore] [m]
    INTEGER(IntKi)  :: NumOuts = 0_IntKi      !< Number of outputs [-]
    TYPE(OutParmType) , DIMENSION(:), ALLOCATABLE  :: OutParam      !< Names and units (and other characteristics) of all requested output parameters [-]
  END TYPE SED_ParameterType
! =======================
! =========  SED_MiscVarType  =======
  TYPE, PUBLIC :: SED_MiscVarType
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: AllOuts      !< Array of all outputs [-]
    TYPE(MeshMapType)  :: mapNac2Hub      !< Mesh mapping from Nacelle to Hub (hub rotation overwritten in calc) [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: mapHub2Root      !< Mesh mapping from Hub to BladeRootMotion (blade pitch overwritten in calc) [-]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: QD2T      !< Current estimate of first derivative of QD (acceleration matrix) for each degree of freedom [-]
    REAL(ReKi) , DIMENSION(1:3)  :: HubPt_X = 0.0_ReKi      !< X orientation of hub calculated in CalcOutput -- saving so we don't recalculate a bunch of things to get it in UpdateStates [-]
  END TYPE SED_MiscVarType
! =======================
CONTAINS

subroutine SED_CopyInputFile(SrcInputFileData, DstInputFileData, CtrlCode, ErrStat, ErrMsg)
   type(SED_InputFile), intent(in) :: SrcInputFileData
   type(SED_InputFile), intent(inout) :: DstInputFileData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'SED_CopyInputFile'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInputFileData%Echo = SrcInputFileData%Echo
   DstInputFileData%DT = SrcInputFileData%DT
   DstInputFileData%IntMethod = SrcInputFileData%IntMethod
   DstInputFileData%GenDOF = SrcInputFileData%GenDOF
   DstInputFileData%YawDOF = SrcInputFileData%YawDOF
   DstInputFileData%Azimuth = SrcInputFileData%Azimuth
   DstInputFileData%BlPitch = SrcInputFileData%BlPitch
   DstInputFileData%RotSpeed = SrcInputFileData%RotSpeed
   DstInputFileData%NacYaw = SrcInputFileData%NacYaw
   DstInputFileData%PtfmPitch = SrcInputFileData%PtfmPitch
   DstInputFileData%NumBl = SrcInputFileData%NumBl
   DstInputFileData%TipRad = SrcInputFileData%TipRad
   DstInputFileData%HubRad = SrcInputFileData%HubRad
   DstInputFileData%PreCone = SrcInputFileData%PreCone
   DstInputFileData%OverHang = SrcInputFileData%OverHang
   DstInputFileData%ShftTilt = SrcInputFileData%ShftTilt
   DstInputFileData%Twr2Shft = SrcInputFileData%Twr2Shft
   DstInputFileData%TowerHt = SrcInputFileData%TowerHt
   DstInputFileData%RotIner = SrcInputFileData%RotIner
   DstInputFileData%GenIner = SrcInputFileData%GenIner
   DstInputFileData%GBoxRatio = SrcInputFileData%GBoxRatio
   DstInputFileData%SumPrint = SrcInputFileData%SumPrint
   DstInputFileData%NumOuts = SrcInputFileData%NumOuts
   if (allocated(SrcInputFileData%OutList)) then
      LB(1:1) = lbound(SrcInputFileData%OutList)
      UB(1:1) = ubound(SrcInputFileData%OutList)
      if (.not. allocated(DstInputFileData%OutList)) then
         allocate(DstInputFileData%OutList(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%OutList.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%OutList = SrcInputFileData%OutList
   end if
end subroutine

subroutine SED_DestroyInputFile(InputFileData, ErrStat, ErrMsg)
   type(SED_InputFile), intent(inout) :: InputFileData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SED_DestroyInputFile'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InputFileData%OutList)) then
      deallocate(InputFileData%OutList)
   end if
end subroutine

subroutine SED_PackInputFile(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SED_InputFile), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SED_PackInputFile'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%Echo)
   call RegPack(RF, InData%DT)
   call RegPack(RF, InData%IntMethod)
   call RegPack(RF, InData%GenDOF)
   call RegPack(RF, InData%YawDOF)
   call RegPack(RF, InData%Azimuth)
   call RegPack(RF, InData%BlPitch)
   call RegPack(RF, InData%RotSpeed)
   call RegPack(RF, InData%NacYaw)
   call RegPack(RF, InData%PtfmPitch)
   call RegPack(RF, InData%NumBl)
   call RegPack(RF, InData%TipRad)
   call RegPack(RF, InData%HubRad)
   call RegPack(RF, InData%PreCone)
   call RegPack(RF, InData%OverHang)
   call RegPack(RF, InData%ShftTilt)
   call RegPack(RF, InData%Twr2Shft)
   call RegPack(RF, InData%TowerHt)
   call RegPack(RF, InData%RotIner)
   call RegPack(RF, InData%GenIner)
   call RegPack(RF, InData%GBoxRatio)
   call RegPack(RF, InData%SumPrint)
   call RegPack(RF, InData%NumOuts)
   call RegPackAlloc(RF, InData%OutList)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SED_UnPackInputFile(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SED_InputFile), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SED_UnPackInputFile'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%Echo); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%IntMethod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GenDOF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawDOF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Azimuth); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BlPitch); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RotSpeed); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NacYaw); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmPitch); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumBl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TipRad); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HubRad); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PreCone); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OverHang); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ShftTilt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Twr2Shft); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TowerHt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RotIner); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GenIner); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GBoxRatio); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SumPrint); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%OutList); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SED_CopyInitInput(SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg)
   type(SED_InitInputType), intent(in) :: SrcInitInputData
   type(SED_InitInputType), intent(inout) :: DstInitInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SED_CopyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInitInputData%InputFile = SrcInitInputData%InputFile
   DstInitInputData%RootName = SrcInitInputData%RootName
   DstInitInputData%Linearize = SrcInitInputData%Linearize
   DstInitInputData%UseInputFile = SrcInitInputData%UseInputFile
   call NWTC_Library_CopyFileInfoType(SrcInitInputData%PassedFileData, DstInitInputData%PassedFileData, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine SED_DestroyInitInput(InitInputData, ErrStat, ErrMsg)
   type(SED_InitInputType), intent(inout) :: InitInputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SED_DestroyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call NWTC_Library_DestroyFileInfoType(InitInputData%PassedFileData, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine SED_PackInitInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SED_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SED_PackInitInput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%InputFile)
   call RegPack(RF, InData%RootName)
   call RegPack(RF, InData%Linearize)
   call RegPack(RF, InData%UseInputFile)
   call NWTC_Library_PackFileInfoType(RF, InData%PassedFileData) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SED_UnPackInitInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SED_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SED_UnPackInitInput'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%InputFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Linearize); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UseInputFile); if (RegCheckErr(RF, RoutineName)) return
   call NWTC_Library_UnpackFileInfoType(RF, OutData%PassedFileData) ! PassedFileData 
end subroutine

subroutine SED_CopyInitOutput(SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg)
   type(SED_InitOutputType), intent(in) :: SrcInitOutputData
   type(SED_InitOutputType), intent(inout) :: DstInitOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SED_CopyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcInitOutputData%WriteOutputHdr)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputHdr)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputHdr)
      if (.not. allocated(DstInitOutputData%WriteOutputHdr)) then
         allocate(DstInitOutputData%WriteOutputHdr(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputHdr.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputHdr = SrcInitOutputData%WriteOutputHdr
   end if
   if (allocated(SrcInitOutputData%WriteOutputUnt)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputUnt)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputUnt)
      if (.not. allocated(DstInitOutputData%WriteOutputUnt)) then
         allocate(DstInitOutputData%WriteOutputUnt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputUnt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputUnt = SrcInitOutputData%WriteOutputUnt
   end if
   call NWTC_Library_CopyProgDesc(SrcInitOutputData%Ver, DstInitOutputData%Ver, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstInitOutputData%NumBl = SrcInitOutputData%NumBl
   if (allocated(SrcInitOutputData%BlPitch)) then
      LB(1:1) = lbound(SrcInitOutputData%BlPitch)
      UB(1:1) = ubound(SrcInitOutputData%BlPitch)
      if (.not. allocated(DstInitOutputData%BlPitch)) then
         allocate(DstInitOutputData%BlPitch(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%BlPitch.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%BlPitch = SrcInitOutputData%BlPitch
   end if
   DstInitOutputData%BladeLength = SrcInitOutputData%BladeLength
   DstInitOutputData%TowerHt = SrcInitOutputData%TowerHt
   DstInitOutputData%HubHt = SrcInitOutputData%HubHt
   DstInitOutputData%PlatformPos = SrcInitOutputData%PlatformPos
   DstInitOutputData%HubRad = SrcInitOutputData%HubRad
   DstInitOutputData%RotSpeed = SrcInitOutputData%RotSpeed
   DstInitOutputData%GenDOF = SrcInitOutputData%GenDOF
end subroutine

subroutine SED_DestroyInitOutput(InitOutputData, ErrStat, ErrMsg)
   type(SED_InitOutputType), intent(inout) :: InitOutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SED_DestroyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InitOutputData%WriteOutputHdr)) then
      deallocate(InitOutputData%WriteOutputHdr)
   end if
   if (allocated(InitOutputData%WriteOutputUnt)) then
      deallocate(InitOutputData%WriteOutputUnt)
   end if
   call NWTC_Library_DestroyProgDesc(InitOutputData%Ver, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(InitOutputData%BlPitch)) then
      deallocate(InitOutputData%BlPitch)
   end if
end subroutine

subroutine SED_PackInitOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SED_InitOutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SED_PackInitOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%WriteOutputHdr)
   call RegPackAlloc(RF, InData%WriteOutputUnt)
   call NWTC_Library_PackProgDesc(RF, InData%Ver) 
   call RegPack(RF, InData%NumBl)
   call RegPackAlloc(RF, InData%BlPitch)
   call RegPack(RF, InData%BladeLength)
   call RegPack(RF, InData%TowerHt)
   call RegPack(RF, InData%HubHt)
   call RegPack(RF, InData%PlatformPos)
   call RegPack(RF, InData%HubRad)
   call RegPack(RF, InData%RotSpeed)
   call RegPack(RF, InData%GenDOF)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SED_UnPackInitOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SED_InitOutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SED_UnPackInitOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%WriteOutputHdr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutputUnt); if (RegCheckErr(RF, RoutineName)) return
   call NWTC_Library_UnpackProgDesc(RF, OutData%Ver) ! Ver 
   call RegUnpack(RF, OutData%NumBl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BlPitch); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BladeLength); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TowerHt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HubHt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PlatformPos); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HubRad); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RotSpeed); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GenDOF); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SED_CopyInput(SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg)
   type(SED_InputType), intent(inout) :: SrcInputData
   type(SED_InputType), intent(inout) :: DstInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SED_CopyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshCopy(SrcInputData%HubPtLoad, DstInputData%HubPtLoad, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstInputData%HSSBrTrqC = SrcInputData%HSSBrTrqC
   DstInputData%GenTrq = SrcInputData%GenTrq
   if (allocated(SrcInputData%BlPitchCom)) then
      LB(1:1) = lbound(SrcInputData%BlPitchCom)
      UB(1:1) = ubound(SrcInputData%BlPitchCom)
      if (.not. allocated(DstInputData%BlPitchCom)) then
         allocate(DstInputData%BlPitchCom(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%BlPitchCom.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%BlPitchCom = SrcInputData%BlPitchCom
   end if
   DstInputData%YawPosCom = SrcInputData%YawPosCom
   DstInputData%YawRateCom = SrcInputData%YawRateCom
end subroutine

subroutine SED_DestroyInput(InputData, ErrStat, ErrMsg)
   type(SED_InputType), intent(inout) :: InputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SED_DestroyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshDestroy( InputData%HubPtLoad, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(InputData%BlPitchCom)) then
      deallocate(InputData%BlPitchCom)
   end if
end subroutine

subroutine SED_PackInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SED_InputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SED_PackInput'
   if (RF%ErrStat >= AbortErrLev) return
   call MeshPack(RF, InData%HubPtLoad) 
   call RegPack(RF, InData%HSSBrTrqC)
   call RegPack(RF, InData%GenTrq)
   call RegPackAlloc(RF, InData%BlPitchCom)
   call RegPack(RF, InData%YawPosCom)
   call RegPack(RF, InData%YawRateCom)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SED_UnPackInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SED_InputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SED_UnPackInput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call MeshUnpack(RF, OutData%HubPtLoad) ! HubPtLoad 
   call RegUnpack(RF, OutData%HSSBrTrqC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GenTrq); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BlPitchCom); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawPosCom); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawRateCom); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SED_CopyOutput(SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg)
   type(SED_OutputType), intent(inout) :: SrcOutputData
   type(SED_OutputType), intent(inout) :: DstOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SED_CopyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcOutputData%BladeRootMotion)) then
      LB(1:1) = lbound(SrcOutputData%BladeRootMotion)
      UB(1:1) = ubound(SrcOutputData%BladeRootMotion)
      if (.not. allocated(DstOutputData%BladeRootMotion)) then
         allocate(DstOutputData%BladeRootMotion(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%BladeRootMotion.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcOutputData%BladeRootMotion(i1), DstOutputData%BladeRootMotion(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call MeshCopy(SrcOutputData%HubPtMotion, DstOutputData%HubPtMotion, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcOutputData%NacelleMotion, DstOutputData%NacelleMotion, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcOutputData%TowerLn2Mesh, DstOutputData%TowerLn2Mesh, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcOutputData%PlatformPtMesh, DstOutputData%PlatformPtMesh, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstOutputData%LSSTipPxa = SrcOutputData%LSSTipPxa
   DstOutputData%RotSpeed = SrcOutputData%RotSpeed
   DstOutputData%RotPwr = SrcOutputData%RotPwr
   DstOutputData%RotTrq = SrcOutputData%RotTrq
   DstOutputData%HSS_Spd = SrcOutputData%HSS_Spd
   DstOutputData%Yaw = SrcOutputData%Yaw
   DstOutputData%YawRate = SrcOutputData%YawRate
   if (allocated(SrcOutputData%BlPitch)) then
      LB(1:1) = lbound(SrcOutputData%BlPitch)
      UB(1:1) = ubound(SrcOutputData%BlPitch)
      if (.not. allocated(DstOutputData%BlPitch)) then
         allocate(DstOutputData%BlPitch(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%BlPitch.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%BlPitch = SrcOutputData%BlPitch
   end if
   if (allocated(SrcOutputData%WriteOutput)) then
      LB(1:1) = lbound(SrcOutputData%WriteOutput)
      UB(1:1) = ubound(SrcOutputData%WriteOutput)
      if (.not. allocated(DstOutputData%WriteOutput)) then
         allocate(DstOutputData%WriteOutput(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%WriteOutput.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%WriteOutput = SrcOutputData%WriteOutput
   end if
end subroutine

subroutine SED_DestroyOutput(OutputData, ErrStat, ErrMsg)
   type(SED_OutputType), intent(inout) :: OutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SED_DestroyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(OutputData%BladeRootMotion)) then
      LB(1:1) = lbound(OutputData%BladeRootMotion)
      UB(1:1) = ubound(OutputData%BladeRootMotion)
      do i1 = LB(1), UB(1)
         call MeshDestroy( OutputData%BladeRootMotion(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(OutputData%BladeRootMotion)
   end if
   call MeshDestroy( OutputData%HubPtMotion, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( OutputData%NacelleMotion, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( OutputData%TowerLn2Mesh, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( OutputData%PlatformPtMesh, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(OutputData%BlPitch)) then
      deallocate(OutputData%BlPitch)
   end if
   if (allocated(OutputData%WriteOutput)) then
      deallocate(OutputData%WriteOutput)
   end if
end subroutine

subroutine SED_PackOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SED_OutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SED_PackOutput'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%BladeRootMotion))
   if (allocated(InData%BladeRootMotion)) then
      call RegPackBounds(RF, 1, lbound(InData%BladeRootMotion), ubound(InData%BladeRootMotion))
      LB(1:1) = lbound(InData%BladeRootMotion)
      UB(1:1) = ubound(InData%BladeRootMotion)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%BladeRootMotion(i1)) 
      end do
   end if
   call MeshPack(RF, InData%HubPtMotion) 
   call MeshPack(RF, InData%NacelleMotion) 
   call MeshPack(RF, InData%TowerLn2Mesh) 
   call MeshPack(RF, InData%PlatformPtMesh) 
   call RegPack(RF, InData%LSSTipPxa)
   call RegPack(RF, InData%RotSpeed)
   call RegPack(RF, InData%RotPwr)
   call RegPack(RF, InData%RotTrq)
   call RegPack(RF, InData%HSS_Spd)
   call RegPack(RF, InData%Yaw)
   call RegPack(RF, InData%YawRate)
   call RegPackAlloc(RF, InData%BlPitch)
   call RegPackAlloc(RF, InData%WriteOutput)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SED_UnPackOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SED_OutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SED_UnPackOutput'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%BladeRootMotion)) deallocate(OutData%BladeRootMotion)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BladeRootMotion(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BladeRootMotion.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%BladeRootMotion(i1)) ! BladeRootMotion 
      end do
   end if
   call MeshUnpack(RF, OutData%HubPtMotion) ! HubPtMotion 
   call MeshUnpack(RF, OutData%NacelleMotion) ! NacelleMotion 
   call MeshUnpack(RF, OutData%TowerLn2Mesh) ! TowerLn2Mesh 
   call MeshUnpack(RF, OutData%PlatformPtMesh) ! PlatformPtMesh 
   call RegUnpack(RF, OutData%LSSTipPxa); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RotSpeed); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RotPwr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RotTrq); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HSS_Spd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Yaw); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawRate); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BlPitch); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutput); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SED_CopyContState(SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg)
   type(SED_ContinuousStateType), intent(in) :: SrcContStateData
   type(SED_ContinuousStateType), intent(inout) :: DstContStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'SED_CopyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcContStateData%QT)) then
      LB(1:1) = lbound(SrcContStateData%QT)
      UB(1:1) = ubound(SrcContStateData%QT)
      if (.not. allocated(DstContStateData%QT)) then
         allocate(DstContStateData%QT(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstContStateData%QT.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstContStateData%QT = SrcContStateData%QT
   end if
   if (allocated(SrcContStateData%QDT)) then
      LB(1:1) = lbound(SrcContStateData%QDT)
      UB(1:1) = ubound(SrcContStateData%QDT)
      if (.not. allocated(DstContStateData%QDT)) then
         allocate(DstContStateData%QDT(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstContStateData%QDT.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstContStateData%QDT = SrcContStateData%QDT
   end if
end subroutine

subroutine SED_DestroyContState(ContStateData, ErrStat, ErrMsg)
   type(SED_ContinuousStateType), intent(inout) :: ContStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SED_DestroyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ContStateData%QT)) then
      deallocate(ContStateData%QT)
   end if
   if (allocated(ContStateData%QDT)) then
      deallocate(ContStateData%QDT)
   end if
end subroutine

subroutine SED_PackContState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SED_ContinuousStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SED_PackContState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%QT)
   call RegPackAlloc(RF, InData%QDT)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SED_UnPackContState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SED_ContinuousStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SED_UnPackContState'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%QT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%QDT); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SED_CopyDiscState(SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg)
   type(SED_DiscreteStateType), intent(in) :: SrcDiscStateData
   type(SED_DiscreteStateType), intent(inout) :: DstDiscStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SED_CopyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstDiscStateData%DummyDiscreteState = SrcDiscStateData%DummyDiscreteState
end subroutine

subroutine SED_DestroyDiscState(DiscStateData, ErrStat, ErrMsg)
   type(SED_DiscreteStateType), intent(inout) :: DiscStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SED_DestroyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine SED_PackDiscState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SED_DiscreteStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SED_PackDiscState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyDiscreteState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SED_UnPackDiscState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SED_DiscreteStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SED_UnPackDiscState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyDiscreteState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SED_CopyConstrState(SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg)
   type(SED_ConstraintStateType), intent(in) :: SrcConstrStateData
   type(SED_ConstraintStateType), intent(inout) :: DstConstrStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SED_CopyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstConstrStateData%DummyConstrState = SrcConstrStateData%DummyConstrState
end subroutine

subroutine SED_DestroyConstrState(ConstrStateData, ErrStat, ErrMsg)
   type(SED_ConstraintStateType), intent(inout) :: ConstrStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SED_DestroyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine SED_PackConstrState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SED_ConstraintStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SED_PackConstrState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyConstrState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SED_UnPackConstrState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SED_ConstraintStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SED_UnPackConstrState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyConstrState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SED_CopyOtherState(SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg)
   type(SED_OtherStateType), intent(in) :: SrcOtherStateData
   type(SED_OtherStateType), intent(inout) :: DstOtherStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SED_CopyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstOtherStateData%n = SrcOtherStateData%n
   LB(1:1) = lbound(SrcOtherStateData%xdot)
   UB(1:1) = ubound(SrcOtherStateData%xdot)
   do i1 = LB(1), UB(1)
      call SED_CopyContState(SrcOtherStateData%xdot(i1), DstOtherStateData%xdot(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   DstOtherStateData%IC = SrcOtherStateData%IC
   DstOtherStateData%HSSBrTrq = SrcOtherStateData%HSSBrTrq
   DstOtherStateData%HSSBrTrqC = SrcOtherStateData%HSSBrTrqC
   DstOtherStateData%SgnPrvLSTQ = SrcOtherStateData%SgnPrvLSTQ
   DstOtherStateData%SgnLSTQ = SrcOtherStateData%SgnLSTQ
end subroutine

subroutine SED_DestroyOtherState(OtherStateData, ErrStat, ErrMsg)
   type(SED_OtherStateType), intent(inout) :: OtherStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SED_DestroyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   LB(1:1) = lbound(OtherStateData%xdot)
   UB(1:1) = ubound(OtherStateData%xdot)
   do i1 = LB(1), UB(1)
      call SED_DestroyContState(OtherStateData%xdot(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
end subroutine

subroutine SED_PackOtherState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SED_OtherStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SED_PackOtherState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%n)
   LB(1:1) = lbound(InData%xdot)
   UB(1:1) = ubound(InData%xdot)
   do i1 = LB(1), UB(1)
      call SED_PackContState(RF, InData%xdot(i1)) 
   end do
   call RegPack(RF, InData%IC)
   call RegPack(RF, InData%HSSBrTrq)
   call RegPack(RF, InData%HSSBrTrqC)
   call RegPack(RF, InData%SgnPrvLSTQ)
   call RegPack(RF, InData%SgnLSTQ)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SED_UnPackOtherState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SED_OtherStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SED_UnPackOtherState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%n); if (RegCheckErr(RF, RoutineName)) return
   LB(1:1) = lbound(OutData%xdot)
   UB(1:1) = ubound(OutData%xdot)
   do i1 = LB(1), UB(1)
      call SED_UnpackContState(RF, OutData%xdot(i1)) ! xdot 
   end do
   call RegUnpack(RF, OutData%IC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HSSBrTrq); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HSSBrTrqC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SgnPrvLSTQ); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SgnLSTQ); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SED_CopyParam(SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg)
   type(SED_ParameterType), intent(in) :: SrcParamData
   type(SED_ParameterType), intent(inout) :: DstParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SED_CopyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstParamData%RootName = SrcParamData%RootName
   DstParamData%GenDOF = SrcParamData%GenDOF
   DstParamData%YawDOF = SrcParamData%YawDOF
   DstParamData%DT = SrcParamData%DT
   DstParamData%DT24 = SrcParamData%DT24
   DstParamData%IntMethod = SrcParamData%IntMethod
   DstParamData%J_DT = SrcParamData%J_DT
   DstParamData%PtfmPitch = SrcParamData%PtfmPitch
   DstParamData%InitYaw = SrcParamData%InitYaw
   DstParamData%InitAzimuth = SrcParamData%InitAzimuth
   DstParamData%RotIner = SrcParamData%RotIner
   DstParamData%GenIner = SrcParamData%GenIner
   DstParamData%GBoxRatio = SrcParamData%GBoxRatio
   DstParamData%NumBl = SrcParamData%NumBl
   DstParamData%TipRad = SrcParamData%TipRad
   DstParamData%HubRad = SrcParamData%HubRad
   DstParamData%BladeLength = SrcParamData%BladeLength
   DstParamData%PreCone = SrcParamData%PreCone
   DstParamData%OverHang = SrcParamData%OverHang
   DstParamData%ShftTilt = SrcParamData%ShftTilt
   DstParamData%Twr2Shft = SrcParamData%Twr2Shft
   DstParamData%TowerHt = SrcParamData%TowerHt
   DstParamData%HubHt = SrcParamData%HubHt
   DstParamData%NumOuts = SrcParamData%NumOuts
   if (allocated(SrcParamData%OutParam)) then
      LB(1:1) = lbound(SrcParamData%OutParam)
      UB(1:1) = ubound(SrcParamData%OutParam)
      if (.not. allocated(DstParamData%OutParam)) then
         allocate(DstParamData%OutParam(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%OutParam.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyOutParmType(SrcParamData%OutParam(i1), DstParamData%OutParam(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
end subroutine

subroutine SED_DestroyParam(ParamData, ErrStat, ErrMsg)
   type(SED_ParameterType), intent(inout) :: ParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SED_DestroyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ParamData%OutParam)) then
      LB(1:1) = lbound(ParamData%OutParam)
      UB(1:1) = ubound(ParamData%OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyOutParmType(ParamData%OutParam(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%OutParam)
   end if
end subroutine

subroutine SED_PackParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SED_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SED_PackParam'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%RootName)
   call RegPack(RF, InData%GenDOF)
   call RegPack(RF, InData%YawDOF)
   call RegPack(RF, InData%DT)
   call RegPack(RF, InData%DT24)
   call RegPack(RF, InData%IntMethod)
   call RegPack(RF, InData%J_DT)
   call RegPack(RF, InData%PtfmPitch)
   call RegPack(RF, InData%InitYaw)
   call RegPack(RF, InData%InitAzimuth)
   call RegPack(RF, InData%RotIner)
   call RegPack(RF, InData%GenIner)
   call RegPack(RF, InData%GBoxRatio)
   call RegPack(RF, InData%NumBl)
   call RegPack(RF, InData%TipRad)
   call RegPack(RF, InData%HubRad)
   call RegPack(RF, InData%BladeLength)
   call RegPack(RF, InData%PreCone)
   call RegPack(RF, InData%OverHang)
   call RegPack(RF, InData%ShftTilt)
   call RegPack(RF, InData%Twr2Shft)
   call RegPack(RF, InData%TowerHt)
   call RegPack(RF, InData%HubHt)
   call RegPack(RF, InData%NumOuts)
   call RegPack(RF, allocated(InData%OutParam))
   if (allocated(InData%OutParam)) then
      call RegPackBounds(RF, 1, lbound(InData%OutParam), ubound(InData%OutParam))
      LB(1:1) = lbound(InData%OutParam)
      UB(1:1) = ubound(InData%OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackOutParmType(RF, InData%OutParam(i1)) 
      end do
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SED_UnPackParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SED_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SED_UnPackParam'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%RootName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GenDOF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawDOF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DT24); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%IntMethod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%J_DT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmPitch); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%InitYaw); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%InitAzimuth); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RotIner); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GenIner); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GBoxRatio); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumBl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TipRad); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HubRad); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BladeLength); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PreCone); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OverHang); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ShftTilt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Twr2Shft); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TowerHt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HubHt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumOuts); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%OutParam)) deallocate(OutData%OutParam)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%OutParam(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%OutParam.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackOutParmType(RF, OutData%OutParam(i1)) ! OutParam 
      end do
   end if
end subroutine

subroutine SED_CopyMisc(SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg)
   type(SED_MiscVarType), intent(inout) :: SrcMiscData
   type(SED_MiscVarType), intent(inout) :: DstMiscData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SED_CopyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcMiscData%AllOuts)) then
      LB(1:1) = lbound(SrcMiscData%AllOuts)
      UB(1:1) = ubound(SrcMiscData%AllOuts)
      if (.not. allocated(DstMiscData%AllOuts)) then
         allocate(DstMiscData%AllOuts(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%AllOuts.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%AllOuts = SrcMiscData%AllOuts
   end if
   call NWTC_Library_CopyMeshMapType(SrcMiscData%mapNac2Hub, DstMiscData%mapNac2Hub, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcMiscData%mapHub2Root)) then
      LB(1:1) = lbound(SrcMiscData%mapHub2Root)
      UB(1:1) = ubound(SrcMiscData%mapHub2Root)
      if (.not. allocated(DstMiscData%mapHub2Root)) then
         allocate(DstMiscData%mapHub2Root(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%mapHub2Root.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyMeshMapType(SrcMiscData%mapHub2Root(i1), DstMiscData%mapHub2Root(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcMiscData%QD2T)) then
      LB(1:1) = lbound(SrcMiscData%QD2T)
      UB(1:1) = ubound(SrcMiscData%QD2T)
      if (.not. allocated(DstMiscData%QD2T)) then
         allocate(DstMiscData%QD2T(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%QD2T.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%QD2T = SrcMiscData%QD2T
   end if
   DstMiscData%HubPt_X = SrcMiscData%HubPt_X
end subroutine

subroutine SED_DestroyMisc(MiscData, ErrStat, ErrMsg)
   type(SED_MiscVarType), intent(inout) :: MiscData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SED_DestroyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(MiscData%AllOuts)) then
      deallocate(MiscData%AllOuts)
   end if
   call NWTC_Library_DestroyMeshMapType(MiscData%mapNac2Hub, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(MiscData%mapHub2Root)) then
      LB(1:1) = lbound(MiscData%mapHub2Root)
      UB(1:1) = ubound(MiscData%mapHub2Root)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyMeshMapType(MiscData%mapHub2Root(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MiscData%mapHub2Root)
   end if
   if (allocated(MiscData%QD2T)) then
      deallocate(MiscData%QD2T)
   end if
end subroutine

subroutine SED_PackMisc(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SED_MiscVarType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SED_PackMisc'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%AllOuts)
   call NWTC_Library_PackMeshMapType(RF, InData%mapNac2Hub) 
   call RegPack(RF, allocated(InData%mapHub2Root))
   if (allocated(InData%mapHub2Root)) then
      call RegPackBounds(RF, 1, lbound(InData%mapHub2Root), ubound(InData%mapHub2Root))
      LB(1:1) = lbound(InData%mapHub2Root)
      UB(1:1) = ubound(InData%mapHub2Root)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackMeshMapType(RF, InData%mapHub2Root(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%QD2T)
   call RegPack(RF, InData%HubPt_X)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SED_UnPackMisc(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SED_MiscVarType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SED_UnPackMisc'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%AllOuts); if (RegCheckErr(RF, RoutineName)) return
   call NWTC_Library_UnpackMeshMapType(RF, OutData%mapNac2Hub) ! mapNac2Hub 
   if (allocated(OutData%mapHub2Root)) deallocate(OutData%mapHub2Root)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%mapHub2Root(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%mapHub2Root.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackMeshMapType(RF, OutData%mapHub2Root(i1)) ! mapHub2Root 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%QD2T); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HubPt_X); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SED_Input_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
   ! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(SED_InputType), intent(inout)  :: u(:) ! Input at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Inputs
   type(SED_InputType), intent(inout)  :: u_out ! Input at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'SED_Input_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(u)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(u)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(u) - 1
   select case (order)
   case (0)
      call SED_CopyInput(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call SED_Input_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call SED_Input_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(u) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE SED_Input_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

   TYPE(SED_InputType), INTENT(INOUT)  :: u1    ! Input at t1 > t2
   TYPE(SED_InputType), INTENT(INOUT)  :: u2    ! Input at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Inputs
   TYPE(SED_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'SED_Input_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   CALL MeshExtrapInterp1(u1%HubPtLoad, u2%HubPtLoad, tin, u_out%HubPtLoad, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   u_out%HSSBrTrqC = a1*u1%HSSBrTrqC + a2*u2%HSSBrTrqC
   u_out%GenTrq = a1*u1%GenTrq + a2*u2%GenTrq
   IF (ALLOCATED(u_out%BlPitchCom) .AND. ALLOCATED(u1%BlPitchCom)) THEN
      do i1 = lbound(u_out%BlPitchCom,1),ubound(u_out%BlPitchCom,1)
         CALL Angles_ExtrapInterp( u1%BlPitchCom(i1), u2%BlPitchCom(i1), tin, u_out%BlPitchCom(i1), tin_out )
      END DO
   END IF ! check if allocated
   u_out%YawPosCom = a1*u1%YawPosCom + a2*u2%YawPosCom
   u_out%YawRateCom = a1*u1%YawRateCom + a2*u2%YawRateCom
END SUBROUTINE

SUBROUTINE SED_Input_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

   TYPE(SED_InputType), INTENT(INOUT)  :: u1      ! Input at t1 > t2 > t3
   TYPE(SED_InputType), INTENT(INOUT)  :: u2      ! Input at t2 > t3
   TYPE(SED_InputType), INTENT(INOUT)  :: u3      ! Input at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Inputs
   TYPE(SED_InputType), INTENT(INOUT)  :: u_out     ! Input at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'SED_Input_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   CALL MeshExtrapInterp2(u1%HubPtLoad, u2%HubPtLoad, u3%HubPtLoad, tin, u_out%HubPtLoad, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   u_out%HSSBrTrqC = a1*u1%HSSBrTrqC + a2*u2%HSSBrTrqC + a3*u3%HSSBrTrqC
   u_out%GenTrq = a1*u1%GenTrq + a2*u2%GenTrq + a3*u3%GenTrq
   IF (ALLOCATED(u_out%BlPitchCom) .AND. ALLOCATED(u1%BlPitchCom)) THEN
      do i1 = lbound(u_out%BlPitchCom,1),ubound(u_out%BlPitchCom,1)
         CALL Angles_ExtrapInterp( u1%BlPitchCom(i1), u2%BlPitchCom(i1), u3%BlPitchCom(i1), tin, u_out%BlPitchCom(i1), tin_out )
      END DO
   END IF ! check if allocated
   u_out%YawPosCom = a1*u1%YawPosCom + a2*u2%YawPosCom + a3*u3%YawPosCom
   u_out%YawRateCom = a1*u1%YawRateCom + a2*u2%YawRateCom + a3*u3%YawRateCom
END SUBROUTINE

subroutine SED_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
   ! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(SED_OutputType), intent(inout)  :: y(:) ! Output at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Outputs
   type(SED_OutputType), intent(inout)  :: y_out ! Output at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'SED_Output_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(y)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(y)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(y) - 1
   select case (order)
   case (0)
      call SED_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call SED_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call SED_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(y) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE SED_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

   TYPE(SED_OutputType), INTENT(INOUT)  :: y1    ! Output at t1 > t2
   TYPE(SED_OutputType), INTENT(INOUT)  :: y2    ! Output at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
   TYPE(SED_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'SED_Output_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   IF (ALLOCATED(y_out%BladeRootMotion) .AND. ALLOCATED(y1%BladeRootMotion)) THEN
      do i1 = lbound(y_out%BladeRootMotion,1),ubound(y_out%BladeRootMotion,1)
         CALL MeshExtrapInterp1(y1%BladeRootMotion(i1), y2%BladeRootMotion(i1), tin, y_out%BladeRootMotion(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   CALL MeshExtrapInterp1(y1%HubPtMotion, y2%HubPtMotion, tin, y_out%HubPtMotion, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp1(y1%NacelleMotion, y2%NacelleMotion, tin, y_out%NacelleMotion, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp1(y1%TowerLn2Mesh, y2%TowerLn2Mesh, tin, y_out%TowerLn2Mesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp1(y1%PlatformPtMesh, y2%PlatformPtMesh, tin, y_out%PlatformPtMesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL Angles_ExtrapInterp( y1%LSSTipPxa, y2%LSSTipPxa, tin, y_out%LSSTipPxa, tin_out )
   y_out%RotSpeed = a1*y1%RotSpeed + a2*y2%RotSpeed
   y_out%RotPwr = a1*y1%RotPwr + a2*y2%RotPwr
   y_out%RotTrq = a1*y1%RotTrq + a2*y2%RotTrq
   y_out%HSS_Spd = a1*y1%HSS_Spd + a2*y2%HSS_Spd
   y_out%Yaw = a1*y1%Yaw + a2*y2%Yaw
   y_out%YawRate = a1*y1%YawRate + a2*y2%YawRate
   IF (ALLOCATED(y_out%BlPitch) .AND. ALLOCATED(y1%BlPitch)) THEN
      do i1 = lbound(y_out%BlPitch,1),ubound(y_out%BlPitch,1)
         CALL Angles_ExtrapInterp( y1%BlPitch(i1), y2%BlPitch(i1), tin, y_out%BlPitch(i1), tin_out )
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
      y_out%WriteOutput = a1*y1%WriteOutput + a2*y2%WriteOutput
   END IF ! check if allocated
END SUBROUTINE

SUBROUTINE SED_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

   TYPE(SED_OutputType), INTENT(INOUT)  :: y1      ! Output at t1 > t2 > t3
   TYPE(SED_OutputType), INTENT(INOUT)  :: y2      ! Output at t2 > t3
   TYPE(SED_OutputType), INTENT(INOUT)  :: y3      ! Output at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
   TYPE(SED_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'SED_Output_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   IF (ALLOCATED(y_out%BladeRootMotion) .AND. ALLOCATED(y1%BladeRootMotion)) THEN
      do i1 = lbound(y_out%BladeRootMotion,1),ubound(y_out%BladeRootMotion,1)
         CALL MeshExtrapInterp2(y1%BladeRootMotion(i1), y2%BladeRootMotion(i1), y3%BladeRootMotion(i1), tin, y_out%BladeRootMotion(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   CALL MeshExtrapInterp2(y1%HubPtMotion, y2%HubPtMotion, y3%HubPtMotion, tin, y_out%HubPtMotion, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp2(y1%NacelleMotion, y2%NacelleMotion, y3%NacelleMotion, tin, y_out%NacelleMotion, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp2(y1%TowerLn2Mesh, y2%TowerLn2Mesh, y3%TowerLn2Mesh, tin, y_out%TowerLn2Mesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp2(y1%PlatformPtMesh, y2%PlatformPtMesh, y3%PlatformPtMesh, tin, y_out%PlatformPtMesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL Angles_ExtrapInterp( y1%LSSTipPxa, y2%LSSTipPxa, y3%LSSTipPxa, tin, y_out%LSSTipPxa, tin_out )
   y_out%RotSpeed = a1*y1%RotSpeed + a2*y2%RotSpeed + a3*y3%RotSpeed
   y_out%RotPwr = a1*y1%RotPwr + a2*y2%RotPwr + a3*y3%RotPwr
   y_out%RotTrq = a1*y1%RotTrq + a2*y2%RotTrq + a3*y3%RotTrq
   y_out%HSS_Spd = a1*y1%HSS_Spd + a2*y2%HSS_Spd + a3*y3%HSS_Spd
   y_out%Yaw = a1*y1%Yaw + a2*y2%Yaw + a3*y3%Yaw
   y_out%YawRate = a1*y1%YawRate + a2*y2%YawRate + a3*y3%YawRate
   IF (ALLOCATED(y_out%BlPitch) .AND. ALLOCATED(y1%BlPitch)) THEN
      do i1 = lbound(y_out%BlPitch,1),ubound(y_out%BlPitch,1)
         CALL Angles_ExtrapInterp( y1%BlPitch(i1), y2%BlPitch(i1), y3%BlPitch(i1), tin, y_out%BlPitch(i1), tin_out )
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
      y_out%WriteOutput = a1*y1%WriteOutput + a2*y2%WriteOutput + a3*y3%WriteOutput
   END IF ! check if allocated
END SUBROUTINE
END MODULE SED_Types
!ENDOFREGISTRYGENERATEDFILE
