   ! NOTE: This source file contains dummy placeholders for the
   !       user-specified routines available in ServoDyn.  These routines
   !       are as follows:
   !          Routine       Description
   !          ------------  ---------------------------------------------------
   !          PitchCntrl()  User-specified blade pitch control (either
   !                        independent or rotor-collective) model.
   !          UserGen()     User-specified generator torque and power model.
   !          UserHSSBr()   User-specified high-speed shaft brake model.
   !          UserVSCont()  User-specified variable-speed torque and power
   !                        control model.
   !          UserYawCont() User-specified nacelle-yaw control model.
   !       In order to interface FAST with your own user-specified routines,
   !       you can develop your own logic within these dummy placeholders and
   !       recompile FAST; OR comment out the appropriate dummy placeholders,
   !       create your own routines in their own source files, and recompile
   !       FAST while linking in these additional source files.  For example,
   !       the executable version of FAST that is distributed with the FAST
   !       archive is linked with the example PitchCntrl() routine contained in
   !       source file PitchCntrl_ACH.f90 and the example UserGen() and
   !       UserVSCont() routines contained in source file UserVSCont_KP.f90;
   !       thus, the dummy placeholders for routines PitchCntrl(), UserGen(),
   !       and UserVSCont() are commented out within this source file.  The
   !       example pitch controller was written by Craig Hansen (ACH) and the
   !       example generator and variable speed controllers were written by
   !       Kirk Pierce (KP).  Please see the aforementioned source files for
   !       additional information on these example user-specified routines.

   ! note: we recommend NOT using these routines because they do not conform to the FAST
   !       modularization framework. They remain for legacy purposes only.
   
module UserSubs
contains
   
!=======================================================================
!SUBROUTINE PitchCntrl ( BlPitch, ElecPwr, LSS_Spd, TwrAccel, NumBl, ZTime, DT, DirRoot, BlPitchCom )
!
!
!   ! This is a dummy routine for holding the place of a user-specified
!   ! blade pitch control model (either independent or rotor-collective).
!   ! Modify this code to create your own model.
!
!
!USE                             Precision
!
!
!IMPLICIT                        NONE
!
!
!   ! Passed variables:
!
!INTEGER(4), INTENT(IN )      :: NumBl                                           ! Number of blades, (-).
!
!REAL(ReKi), INTENT(IN )      :: BlPitch   (NumBl)                               ! Current values of the blade pitch angles, rad.
!REAL(DbKi), INTENT(IN )      :: DT                                              ! Integration time step, sec.
!REAL(ReKi), INTENT(IN )      :: ElecPwr                                         ! Electrical power, watts.
!REAL(ReKi), INTENT(IN )      :: LSS_Spd                                         ! LSS speed (rad/s)
!REAL(ReKi), INTENT(OUT)      :: BlPitchCom(NumBl)                               ! Commanded blade pitch angles (demand pitch angles), rad.
!REAL(ReKi), INTENT(IN )      :: TwrAccel                                        ! Tower Acceleration, m/s^2.
!REAL(DbKi), INTENT(IN )      :: ZTime                                           ! Current simulation time, sec.
!
!CHARACTER(1024), INTENT(IN ) :: DirRoot                                         ! The name of the root file including the full path to the current working directory.  This may be useful if you want this routine to write a permanent record of what it does to be stored with the simulation results: the results should be stored in a file whose name (including path) is generated by appending any suitable extension to DirRoot.
!
!
!
!BlPitchCom = 0.0
!
!
!
!RETURN
!END SUBROUTINE PitchCntrl
!=======================================================================
!SUBROUTINE UserGen ( HSS_Spd, LSS_Spd, NumBl, ZTime, DT, GenEff, DelGenTrq, DirRoot, GenTrq, ElecPwr )
!
!
!   ! This is a dummy routine for holding the place of a user-specified
!   ! generator torque and power model.  Modify this code to create your
!   ! own model.
!
!   ! NOTE: If you (the user) wants to switch on-or-off the generator DOF at
!   !       runtime from this user-defined routine, then do the following:
!   !          (1) USE MODULE DOFs().
!   !          (2) Type in "DOF_Flag(DOF_GeAz) = VALUE" where VALUE = .TRUE. or
!   !              .FALSE. depending on whether you want to turn-on or turn-off
!   !              the DOF, respectively.  Turning off the DOF forces the
!   !              current RATE to remain fixed.  If the rate is currently zero,
!   !              the current POSITION will remain fixed as well.
!
!
!USE                             Precision
!
!
!IMPLICIT                        NONE
!
!
!   ! Passed Variables:
!
!INTEGER(4), INTENT(IN )      :: NumBl                                           ! Number of blades, (-).
!
!REAL(ReKi), INTENT(IN )      :: DelGenTrq                                       ! Pertubation in generator torque used during FAST linearization (zero otherwise), N-m.
!REAL(DbKi), INTENT(IN )      :: DT                                              ! Integration time step, sec.
!REAL(ReKi), INTENT(OUT)      :: ElecPwr                                         ! Electrical power (account for losses), watts.
!REAL(ReKi), INTENT(IN )      :: GenEff                                          ! Generator efficiency, (-).
!REAL(ReKi), INTENT(OUT)      :: GenTrq                                          ! Electrical generator torque, N-m.
!REAL(ReKi), INTENT(IN )      :: LSS_Spd                                         ! LSS speed, rad/s.
!REAL(ReKi), INTENT(IN )      :: HSS_Spd                                         ! HSS speed, rad/s.
!REAL(DbKi), INTENT(IN )      :: ZTime                                           ! Current simulation time, sec.
!
!CHARACTER(1024), INTENT(IN ) :: DirRoot                                         ! The name of the root file including the full path to the current working directory.  This may be useful if you want this routine to write a permanent record of what it does to be stored with the simulation results: the results should be stored in a file whose name (including path) is generated by appending any suitable extension to DirRoot.
!
!
!
!GenTrq  = 0.0 + DelGenTrq  ! Make sure to add the pertubation on generator torque, DelGenTrq.  This is used only for FAST linearization (it is zero otherwise).
!
!
!   ! The generator efficiency is either additive for motoring,
!   !   or subtractive for generating power.
!
!IF ( GenTrq > 0.0 )  THEN
!   ElecPwr = GenTrq*HSS_Spd*GenEff
!ELSE
!   ElecPwr = GenTrq*HSS_Spd/GenEff
!ENDIF
!
!
!
!RETURN
!END SUBROUTINE UserGen
!=======================================================================
SUBROUTINE UserHSSBr ( GenTrq, ElecPwr, HSS_Spd, NumBl, ZTime, DT, DirRoot, HSSBrFrac )


   ! This is a dummy routine for holding the place of a user-specified
   ! HSS brake model.  This routine must specify the fraction
   ! (HSSBrFrac) of full torque to be applied to the HSS by the HSS
   ! brake.  The magnitude of the full torque (HSSBrFrac = 1.0) equals
   ! HSSBrTqF from the primary input file.  Modify this code to create
   ! your own model.

   ! NOTE: If you (the user) wants to switch on-or-off the generator DOF at
   !       runtime from this user-defined routine, then do the following:
   !          (1) USE MODULE DOFs().
   !          (2) Type in "DOF_Flag(DOF_GeAz) = VALUE" where VALUE = .TRUE. or
   !              .FALSE. depending on whether you want to turn-on or turn-off
   !              the DOF, respectively.  Turning off the DOF forces the
   !              current RATE to remain fixed.  If the rate is currently zero,
   !              the current POSITION will remain fixed as well.


USE                             Precision


IMPLICIT                        NONE


   ! Passed Variables:

INTEGER(4), INTENT(IN )      :: NumBl                                           ! Number of blades, (-).

REAL(DbKi), INTENT(IN )      :: DT                                              ! Integration time step, sec.
REAL(ReKi), INTENT(IN )      :: ElecPwr                                         ! Electrical power (account for losses), watts.
REAL(ReKi), INTENT(IN )      :: GenTrq                                          ! Electrical generator torque, N-m.
REAL(ReKi), INTENT(IN )      :: HSS_Spd                                         ! HSS speed, rad/s.
REAL(ReKi), INTENT(OUT)      :: HSSBrFrac                                       ! Fraction of full braking torque: 0 (off) <= HSSBrFrac <= 1 (full), (-).
REAL(DbKi), INTENT(IN )      :: ZTime                                           ! Current simulation time, sec.

CHARACTER(1024), INTENT(IN ) :: DirRoot                                         ! The name of the root file including the full path to the current working directory.  This may be useful if you want this routine to write a permanent record of what it does to be stored with the simulation results: the results should be stored in a file whose name (including path) is generated by appending any suitable extension to DirRoot.



HSSBrFrac = 0.0   ! NOTE: This must be specified as a real number between 0.0 (off - no brake torque) and 1.0 (full - max brake torque = HSSBrTqF); FAST will Abort otherwise.



RETURN
END SUBROUTINE UserHSSBr
!=======================================================================
SUBROUTINE UserTFin ( TFrlDef , TFrlRate, ZTime   , DirRoot, &
                      TFinCPxi, TFinCPyi, TFinCPzi,          &
                      TFinCPVx, TFinCPVy, TFinCPVz,          &
                      TFinAOA , TFinQ   ,                    &
                      TFinCL  , TFinCD  ,                    &
                      TFinKFx , TFinKFy                        )


   ! This is a dummy routine for holding the place of user-specified
   ! computations for tail fin aerodynamic loads.  Modify this code to
   ! create your own logic.


USE                             Precision


IMPLICIT                        NONE


   ! Passed Variables:

REAL(ReKi), INTENT(OUT)      :: TFinAOA                                         ! Angle-of-attack between the relative wind velocity and tail fin chordline, rad.
REAL(ReKi), INTENT(OUT)      :: TFinCD                                          ! Tail fin drag            coefficient resulting from current TFinAOA, (-).
REAL(ReKi), INTENT(OUT)      :: TFinCL                                          ! Tail fin lift            coefficient resulting from current TFinAOA, (-).
REAL(ReKi), INTENT(IN )      :: TFinCPVx                                        ! Absolute Velocity of the tail center-of-pressure along tail fin chordline pointing toward tail fin trailing edge, m/s.
REAL(ReKi), INTENT(IN )      :: TFinCPVy                                        ! Absolute Velocity of the tail center-of-pressure normal to plane of tail fin pointing towards suction surface   , m/s.
REAL(ReKi), INTENT(IN )      :: TFinCPVz                                        ! Absolute Velocity of the tail center-of-pressure in plane of tail fin normal to chordline and nominally upward  , m/s.
!jmj Start of proposed change.  v6.02a-jmj  25-Aug-2006.
!jmj Improve the description of input arguments TFinCPxi, TFinCPyi, and
!jmj   TFinCPzi:
!remove6.02aREAL(ReKi), INTENT(IN )      :: TFinCPxi                                        ! Downwind distance from the inertial frame origin to the tail fin center-of-pressure, m.
!remove6.02aREAL(ReKi), INTENT(IN )      :: TFinCPyi                                        ! Lateral  distance from the inertial frame origin to the tail fin center-of-pressure, m.
!remove6.02aREAL(ReKi), INTENT(IN )      :: TFinCPzi                                        ! Vertical distance from the inertial frame origin to the tail fin center-of-pressure, m.
REAL(ReKi), INTENT(IN )      :: TFinCPxi                                        ! Downwind distance from the inertial frame origin at ground level [onshore] or MSL [offshore] to the tail fin center-of-pressure, m.
REAL(ReKi), INTENT(IN )      :: TFinCPyi                                        ! Lateral  distance from the inertial frame origin at ground level [onshore] or MSL [offshore] to the tail fin center-of-pressure, m.
REAL(ReKi), INTENT(IN )      :: TFinCPzi                                        ! Vertical distance from the inertial frame origin at ground level [onshore] or MSL [offshore] to the tail fin center-of-pressure, m.
!jmj End of proposed change.  v6.02a-jmj  25-Aug-2006.
REAL(ReKi), INTENT(OUT)      :: TFinKFx                                         ! Aerodynamic force  at the tail fin center-of-pressure (point K) along tail fin chordline pointing toward tail fin trailing edge, N.
REAL(ReKi), INTENT(OUT)      :: TFinKFy                                         ! Aerodynamic force  at the tail fin center-of-pressure (point K) normal to plane of tail fin pointing towards suction surface   , N.
REAL(ReKi), INTENT(OUT)      :: TFinQ                                           ! Dynamic pressure of the relative wind velocity, Pa.
REAL(ReKi), INTENT(IN )      :: TFrlDef                                         ! Tail-furl angular deflection, rad.
REAL(ReKi), INTENT(IN )      :: TFrlRate                                        ! Tail-furl angular rate, rad/s
REAL(DbKi), INTENT(IN )      :: ZTime                                           ! Current simulation time, sec.

CHARACTER(1024), INTENT(IN ) :: DirRoot                                         ! The name of the root file including the full path to the current working directory.  This may be useful if you want this routine to write a permanent record of what it does to be stored with the simulation results: the results should be stored in a file whose name (including path) is generated by appending any suitable extension to DirRoot.



TFinAOA = 0.0
TFinCL  = 0.0
TFinCD  = 0.0
TFinQ   = 0.0
TFinKFx = 0.0
TFinKFy = 0.0



RETURN
END SUBROUTINE UserTFin
!=======================================================================
!SUBROUTINE UserVSCont ( HSS_Spd, LSS_Spd, NumBl, ZTime, DT, GenEff, DelGenTrq, DirRoot, GenTrq, ElecPwr )
!
!
!   ! This is a dummy routine for holding the place of a user-specified
!   ! variable-speed torque and power control model.  Modify this code to
!   ! create your own model.
!
!   ! NOTE: If you (the user) wants to switch on-or-off the generator DOF at
!   !       runtime from this user-defined routine, then do the following:
!   !          (1) USE MODULE DOFs().
!   !          (2) Type in "DOF_Flag(DOF_GeAz) = VALUE" where VALUE = .TRUE. or
!   !              .FALSE. depending on whether you want to turn-on or turn-off
!   !              the DOF, respectively.  Turning off the DOF forces the
!   !              current RATE to remain fixed.  If the rate is currently zero,
!   !              the current POSITION will remain fixed as well.
!
!
!USE                             Precision
!
!
!IMPLICIT                        NONE
!
!
!   ! Passed Variables:
!
!INTEGER(4), INTENT(IN )      :: NumBl                                           ! Number of blades, (-).
!
!REAL(ReKi), INTENT(IN )      :: DelGenTrq                                       ! Pertubation in generator torque used during FAST linearization (zero otherwise), N-m.
!REAL(DbKi), INTENT(IN )      :: DT                                              ! Integration time step, sec.
!REAL(ReKi), INTENT(OUT)      :: ElecPwr                                         ! Electrical power (account for losses), watts.
!REAL(ReKi), INTENT(IN )      :: LSS_Spd                                         ! LSS speed, rad/s.
!REAL(ReKi), INTENT(IN )      :: GenEff                                          ! Generator efficiency, (-).
!REAL(ReKi), INTENT(OUT)      :: GenTrq                                          ! Electrical generator torque, N-m.
!REAL(ReKi), INTENT(IN )      :: HSS_Spd                                         ! HSS speed, rad/s.
!REAL(DbKi), INTENT(IN )      :: ZTime                                           ! Current simulation time, sec.
!
!CHARACTER(1024), INTENT(IN ) :: DirRoot                                         ! The name of the root file including the full path to the current working directory.  This may be useful if you want this routine to write a permanent record of what it does to be stored with the simulation results: the results should be stored in a file whose name (including path) is generated by appending any suitable extension to DirRoot.
!
!
!
!GenTrq  = 0.0 + DelGenTrq  ! Make sure to add the pertubation on generator torque, DelGenTrq.  This is used only for FAST linearization (it is zero otherwise).
!
!
!   ! The generator efficiency is either additive for motoring,
!   !   or subtractive for generating power.
!
!IF ( GenTrq > 0.0 )  THEN
!   ElecPwr = GenTrq*HSS_Spd*GenEff
!ELSE
!   ElecPwr = GenTrq*HSS_Spd/GenEff
!ENDIF
!
!
!
!RETURN
!END SUBROUTINE UserVSCont
!=======================================================================
SUBROUTINE UserYawCont ( YawPos, YawRate, WindDir, YawError, NumBl, ZTime, DT, DirRoot, YawPosCom, YawRateCom )


   ! This is a dummy routine for holding the place of a user-specified
   ! nacelle-yaw controller.  Modify this code to create your own device.


   ! As indicated, the yaw controller must always specify a command (demand)
   !   yaw angle, YawPosCom, AND command (demand) yaw rate, YawRateCom.
   !   Normally, you should correlate these commands so that the commanded yaw
   !   angle is the integral of the commanded yaw rate, or likewise, the
   !   commanded yaw rate is the derivative of the commanded yaw angle.  FAST
   !   WILL NOT compute these correlations for you and DOES NOT check to
   !   ensure that they are correlated.  In some situations, it is desirable to
   !   set one of the commands (either yaw angle OR yaw rate) to ZERO depending
   !   on the desired transfer function of FAST's built-in actuator model (see
   !   below for a discussion of FAST's built-in actuator model).  In general,
   !   the commanded yaw angle and rate SHOULD NEVER be defined independent of
   !   each other with BOTH commands NONZERO.


   ! The yaw controller's effect on the FAST model depends on whether or not
   !   the yaw DOF is enabled as follows:
   !
   ! YawDOF = False - If the yaw DOF is disabled, then the commanded yaw angle
   !                  and rate will be the ACTUAL yaw angle and yaw rate used
   !                  internally by FAST (in general, you should ensure these
   !                  are correlated).  In this case, any desired actuator
   !                  effects should be built within this controller.  Also in
   !                  this case, FAST WILL NOT compute the correlated yaw
   !                  acceleration, but assume that it is ZERO.  If the
   !                  commanded yaw rate is zero while the commanded yaw angle
   !                  is changing in time, then the yaw controller's effect
   !                  on yaw angle is the identical to routine PitchCntrl()'s
   !                  effect on pitch angle (i.e., routine PitchCntrl()
   !                  commands changes in pitch angle with no associated
   !                  changes in pitch rate or pitch acceleration).  For yaw
   !                  control, this situation should be avoided however, since
   !                  yaw-induced gyroscopic pitching loads on the turbine
   !                  brought about by the yaw rate may be significant.
   !
   ! YawDOF = True  - If the yaw DOF is enabled, then the commanded yaw angle
   !                  and rate, YawPosCom and YawRateCom, become the neutral
   !                  yaw angle, YawNeut, and neutral yaw rate, YawRateNeut, in
   !                  FAST's built-in second-order actuator model defined by
   !                  inputs YawSpr and YawDamp.


   ! Description of FAST's built-in actuator model:
   !
   ! In the time-domain, FAST's built-in actuator model is defined as follows:
   !
   ! YawIner*YawAccel + YawDamp*YawRate + YawSpr*YawPos
   !                             = YawDamp*YawRateNeut + YawSpr*YawNeut + YawTq
   !
   ! so that the transmitted torque is:
   !
   ! YawMom = YawSpr*( YawPos - YawNeut ) + YawDamp*( YawRate - YawRateNeut )
   !
   ! where,
   !   YawSpr      = nacelle-yaw spring constant (defined in FAST's primary
   !                 input file)
   !   YawDamp     = nacelle-yaw damping constant (defined in FAST's primary
   !                 input file)
   !   YawIner     = instantaneous inertia of the nacelle and rotor about the
   !                 yaw axis
   !   YawNeut     = the commanded (neutral) yaw angle = YawPosCom
   !   YawRateNeut = the commanded (neutral) yaw rate  = YawRateCom
   !   YawPos      = yaw angle (position)
   !   YawRate     = yaw rate
   !   YawAccel    = yaw acceleration
   !   YawTq       = torque about the yaw axis applied by external forces above
   !                 the yaw bearing, such as wind loading
   !   YawMom      = torque transmitted through the yaw bearing
   !
   ! If the commanded yaw angle and rate are correlated (so that the commanded
   !   yaw angle is the integral of the commanded yaw rate, or likewise, the
   !   commanded yaw rate is the derivative of the commanded yaw angle), then
   !   FAST's built-in second-order actuator model will have the following
   !   characteristic transfer function:
   !
   !               YawDamp*s + YawSpr             2*Zeta*OmegaN*s + OmegaN^2
   ! T(s) = -------------------------------- = --------------------------------
   !        YawIner*s^2 + YawDamp*s + YawSpr   s^2 + 2*Zeta*OmegaN*s + OmegaN^2
   !
   ! where,
   !   T(s)    = the transfer function of FAST's built-in 2nd order actuator
   !             model
   !   OmegaN  = SQRT(YawSpr/YawIner) = yaw actuator natural frequency
   !   Zeta    = YawDamp/(2*SQRT(YawSpr*YawIner)) = yaw actuator damping ratio
   !             in fraction of critical
   !
   ! If only the yaw angle is commanded, and YawRateCom is zeroed, then the
   !   charecteristic transfer function of FAST's built-in second-order
   !   actuator model simplifies to:
   !
   !                     YawSpr                            OmegaN^2
   ! T(s) = -------------------------------- = --------------------------------
   !        YawIner*s^2 + YawDamp*s + YawSpr   s^2 + 2*Zeta*OmegaN*s + OmegaN^2
   !
   ! If only the yaw rate is commanded, and YawPosCom is zeroed, then the
   !   charecteristic transfer function of FAST's built-in second-order
   !   actuator model simplifies to:
   !
   !                    YawDamp                         2*Zeta*OmegaN
   ! T(s) = -------------------------------- = --------------------------------
   !        YawIner*s^2 + YawDamp*s + YawSpr   s^2 + 2*Zeta*OmegaN*s + OmegaN^2


   ! NOTE: If you (the user) wants to switch on-or-off the yaw DOF at
   !       runtime from this user-defined routine, then do the following:
   !          (1) USE MODULE DOFs().
   !          (2) Type in "DOF_Flag(DOF_Yaw) = VALUE" where VALUE = .TRUE. or
   !              .FALSE. depending on whether you want to turn-on or turn-off
   !              the DOF, respectively.  Turning off the DOF acts is like
   !              setting YawDOF to False.
   !       This technique is useful, for example, if the yaw bearing has
   !       an electromagnetic latch that will unlock and relock the hinge under
   !       certain specified conditions..


USE                             Precision
USE                             NWTC_Library


IMPLICIT                        NONE


   ! Passed Variables:

INTEGER(4), INTENT(IN )      :: NumBl                                           ! Number of blades, (-).

REAL(DbKi), INTENT(IN )      :: DT                                              ! Integration time step, sec.
REAL(ReKi), INTENT(IN )      :: WindDir                                         ! Current horizontal hub-height wind direction (positive about the zi-axis), rad.
REAL(ReKi), INTENT(IN )      :: YawError                                        ! Current nacelle-yaw error estimate (positve about the zi-axis), rad.
REAL(ReKi), INTENT(IN )      :: YawPos                                          ! Current nacelle-yaw angular position, rad.
REAL(ReKi), INTENT(OUT)      :: YawPosCom                                       ! Commanded nacelle-yaw angular position (demand yaw angle), rad.
REAL(ReKi), INTENT(IN )      :: YawRate                                         ! Current nacelle-yaw angular rate, rad/s.
REAL(ReKi), INTENT(OUT)      :: YawRateCom                                      ! Commanded nacelle-yaw angular rate (demand yaw rate), rad/s.
REAL(DbKi), INTENT(IN )      :: ZTime                                           ! Current simulation time, sec.

CHARACTER(1024), INTENT(IN ) :: DirRoot                                         ! The name of the root file including the full path to the current working directory.  This may be useful if you want this routine to write a permanent record of what it does to be stored with the simulation results: the results should be stored in a file whose name (including path) is generated by appending any suitable extension to DirRoot.



YawPosCom  = 0.0
YawRateCom = 0.0

!JASON: IMPOSE YAW STEP FOR FAST.Farm CALIBRATION CASE - START
IF (      ( ZTime >= 648.0_DbKi ) .AND. ( ZTime < 650.0_DbKi ) ) THEN
   YawRateCom = ( 10.0_ReKi/2.0_ReKi )*D2R 
   YawPosCom  =  0.0          + YawRateCom*( ZTime - 648.0_DbKi )
ELSE IF ( ( ZTime >= 650.0_DbKi ) .AND. ( ZTime < 948.0_DbKi ) ) THEN    
   YawRateCom =  0.0
   YawPosCom  = 10.0_ReKi*D2R
ELSE IF ( ( ZTime >= 948.0_DbKi ) .AND. ( ZTime < 950.0_DbKi ) ) THEN    
   YawRateCom = ( 15.0_ReKi/2.0_ReKi )*D2R 
   YawPosCom  = 10.0_ReKi*D2R + YawRateCom*( ZTime - 948.0_DbKi )
ELSE IF ( ( ZTime >= 950.0_DbKi )                               ) THEN
   YawRateCom =  0.0
   YawPosCom  = 25.0_ReKi*D2R
END IF
!JASON: IMPOSE YAW STEP FOR FAST.Farm CALIBRATION CASE - END


RETURN
END SUBROUTINE UserYawCont
!=======================================================================
end module UserSubs
