!STARTOFREGISTRYGENERATEDFILE 'StrucCtrl_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! StrucCtrl_Types
!.................................................................................................................................
! This file is part of StrucCtrl.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in StrucCtrl. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE StrucCtrl_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE NWTC_Library
IMPLICIT NONE
! =========  StC_InputFile  =======
  TYPE, PUBLIC :: StC_InputFile
    CHARACTER(1024)  :: StCFileName      !< Name of the input file; remove if there is no file [-]
    LOGICAL  :: Echo = .false.      !< Echo input file to echo file [-]
    INTEGER(IntKi)  :: StC_CMODE = 0_IntKi      !< control mode {0:none; 1: Semi-Active Control Mode; 2: Active Control Mode;}  [-]
    INTEGER(IntKi)  :: StC_SA_MODE = 0_IntKi      !< Semi-Active control mode {1: velocity-based ground hook control; 2: Inverse velocity-based ground hook control; 3: displacement-based ground hook control 4: Phase difference Algorithm with Friction Force 5: Phase difference Algorithm with Damping Force}  [-]
    INTEGER(IntKi)  :: StC_DOF_MODE = 0_IntKi      !< DOF mode {0: NO StC_DOF; 1: StC_X_DOF and StC_Y_DOF; 2: StC_XY_DOF; 3: TLCD; 4: Prescribed force/moment time series} [-]
    LOGICAL  :: StC_X_DOF = .false.      !< DOF on or off [-]
    LOGICAL  :: StC_Y_DOF = .false.      !< DOF on or off [-]
    LOGICAL  :: StC_Z_DOF = .false.      !< DOF on or off [-]
    REAL(ReKi)  :: StC_X_DSP = 0.0_ReKi      !< StC_X initial displacement [m]
    REAL(ReKi)  :: StC_Y_DSP = 0.0_ReKi      !< StC_Y initial displacement [m]
    REAL(ReKi)  :: StC_Z_DSP = 0.0_ReKi      !< StC_Z initial displacement [m]
    Character(10)  :: StC_Z_PreLdC      !< StC_Z spring preload [N]
    REAL(ReKi)  :: StC_X_M = 0.0_ReKi      !< StC X mass [kg]
    REAL(ReKi)  :: StC_Y_M = 0.0_ReKi      !< StC Y mass [kg]
    REAL(ReKi)  :: StC_Z_M = 0.0_ReKi      !< StC Z mass [kg]
    REAL(ReKi)  :: StC_XY_M = 0.0_ReKi      !< StC XY mass [kg]
    REAL(ReKi)  :: StC_X_K = 0.0_ReKi      !< StC X stiffness [N/m]
    REAL(ReKi)  :: StC_Y_K = 0.0_ReKi      !< StC Y stiffness [N/m]
    REAL(ReKi)  :: StC_Z_K = 0.0_ReKi      !< StC Y stiffness [N/m]
    REAL(ReKi)  :: StC_X_C = 0.0_ReKi      !< StC X damping [N/(m/s)]
    REAL(ReKi)  :: StC_Y_C = 0.0_ReKi      !< StC Y damping [N/(m/s)]
    REAL(ReKi)  :: StC_Z_C = 0.0_ReKi      !< StC Z damping [N/(m/s)]
    REAL(ReKi)  :: StC_X_PSP = 0.0_ReKi      !< Positive stop position (maximum X mass displacement) [m]
    REAL(ReKi)  :: StC_X_NSP = 0.0_ReKi      !< Negative stop position (minimum X mass displacement) [m]
    REAL(ReKi)  :: StC_Y_PSP = 0.0_ReKi      !< Positive stop position (maximum Y mass displacement) [m]
    REAL(ReKi)  :: StC_Y_NSP = 0.0_ReKi      !< Negative stop position (minimum Y mass displacement) [m]
    REAL(ReKi)  :: StC_Z_PSP = 0.0_ReKi      !< Positive stop position (maximum Z mass displacement) [m]
    REAL(ReKi)  :: StC_Z_NSP = 0.0_ReKi      !< Negative stop position (minimum Z mass displacement) [m]
    REAL(ReKi)  :: StC_X_KS = 0.0_ReKi      !< Stop spring X stiffness [N/m]
    REAL(ReKi)  :: StC_X_CS = 0.0_ReKi      !< Stop spring X damping [N/(m/s)]
    REAL(ReKi)  :: StC_Y_KS = 0.0_ReKi      !< Stop spring Y stiffness [N/m]
    REAL(ReKi)  :: StC_Y_CS = 0.0_ReKi      !< Stop spring Y damping [N/(m/s)]
    REAL(ReKi)  :: StC_Z_KS = 0.0_ReKi      !< Stop spring Z stiffness [used only when StC_DOF_MODE=1 and StC_Z_DOF=TRUE] [N/m]
    REAL(ReKi)  :: StC_Z_CS = 0.0_ReKi      !< Stop spring Z damping   [used only when StC_DOF_MODE=1 and StC_Z_DOF=TRUE] [N/(m/s)]
    REAL(ReKi)  :: StC_P_X = 0.0_ReKi      !< StC X initial displacement (m) [relative to at rest position] [m]
    REAL(ReKi)  :: StC_P_Y = 0.0_ReKi      !< StC Y initial displacement (m) [relative to at rest position] [m]
    REAL(ReKi)  :: StC_P_Z = 0.0_ReKi      !< StC Z initial displacement (m) [relative to at rest position; used only when StC_DOF_MODE=1 and StC_Z_DOF=TRUE] [m]
    REAL(ReKi)  :: StC_X_C_HIGH = 0.0_ReKi      !< StC X high damping for ground hook control [N/(m/s)]
    REAL(ReKi)  :: StC_X_C_LOW = 0.0_ReKi      !< StC X low damping for ground hook control [N/(m/s)]
    REAL(ReKi)  :: StC_Y_C_HIGH = 0.0_ReKi      !< StC Y high damping for ground hook control [N/(m/s)]
    REAL(ReKi)  :: StC_Y_C_LOW = 0.0_ReKi      !< StC Y low damping for ground hook control [N/(m/s)]
    REAL(ReKi)  :: StC_Z_C_HIGH = 0.0_ReKi      !< StC Z high damping for ground hook control [N/(m/s)]
    REAL(ReKi)  :: StC_Z_C_LOW = 0.0_ReKi      !< StC Z low damping for ground hook control [N/(m/s)]
    REAL(ReKi)  :: StC_X_C_BRAKE = 0.0_ReKi      !< StC X high damping for braking the StC [N/(m/s)]
    REAL(ReKi)  :: StC_Y_C_BRAKE = 0.0_ReKi      !< StC Y high damping for braking the StC [N/(m/s)]
    REAL(ReKi)  :: StC_Z_C_BRAKE = 0.0_ReKi      !< StC Z high damping for braking the StC [N/(m/s)]
    REAL(ReKi)  :: L_X = 0.0_ReKi      !< X TLCD total length [m]
    REAL(ReKi)  :: B_X = 0.0_ReKi      !< X TLCD horizontal length [m]
    REAL(ReKi)  :: area_X = 0.0_ReKi      !< X TLCD cross-sectional area of vertical column [m^2]
    REAL(ReKi)  :: area_ratio_X = 0.0_ReKi      !< X TLCD cross-sectional area ratio (vertical column area divided by horizontal column area) [-]
    REAL(ReKi)  :: headLossCoeff_X = 0.0_ReKi      !< X TLCD head loss coeff [-]
    REAL(ReKi)  :: rho_X = 0.0_ReKi      !< X TLCD liquid density [kg/m^3]
    REAL(ReKi)  :: L_Y = 0.0_ReKi      !< Y TLCD total length [m]
    REAL(ReKi)  :: B_Y = 0.0_ReKi      !< Y TLCD horizontal length [m]
    REAL(ReKi)  :: area_Y = 0.0_ReKi      !< Side-Side TLCD cross-sectional area of vertical column [m]
    REAL(ReKi)  :: area_ratio_Y = 0.0_ReKi      !< Side-Side TLCD cross-sectional area ratio (vertical column area divided by horizontal column area) [-]
    REAL(ReKi)  :: headLossCoeff_Y = 0.0_ReKi      !< Side-Side TLCD head loss coeff [-]
    REAL(ReKi)  :: rho_Y = 0.0_ReKi      !< Side-Side TLCD liquid density [kg/m^3]
    LOGICAL  :: USE_F_TBL = .false.      !< use spring force from user-defined table (flag) [-]
    INTEGER(IntKi)  :: NKInpSt = 0_IntKi      !< Number of input spring force rows in table [-]
    CHARACTER(1024)  :: StC_F_TBL_FILE      !< user-defined spring table filename [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_TBL      !< user-defined spring force [N]
    INTEGER(IntKi)  :: PrescribedForcesCoordSys = 0_IntKi      !< Prescribed forces coordinate system {0: global; 1: local} [-]
    CHARACTER(1024)  :: PrescribedForcesFile      !< Prescribed force time-series filename [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: StC_PrescribedForce      !< StC prescribed force time-series info [(s,N,N-m)]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: StC_CChan      !< StC control chan to use -- one per instance [-]
  END TYPE StC_InputFile
! =======================
! =========  StC_InitInputType  =======
  TYPE, PUBLIC :: StC_InitInputType
    CHARACTER(1024)  :: InputFile      !< Name of the input file; remove if there is no file [-]
    CHARACTER(1024)  :: RootName      !< RootName for writing output files [-]
    REAL(ReKi) , DIMENSION(1:3)  :: Gravity = 0.0_ReKi      !< Gravitational acceleration vector [m/s^2]
    INTEGER(IntKi)  :: NumMeshPts = 0_IntKi      !< Number of mesh points [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: InitRefPos      !< X-Y-Z reference position of point: i.e. each blade root (3 x NumBlades) [m]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: InitTransDisp      !< X-Y-Z displacement from position of point at init: i.e. each blade root (3 x NumBlades) [m]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: InitOrient      !< DCM orientation of point at init: i.e. each blade root (3x3 x NumBlades) [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: InitRefOrient      !< DCM reference orientation of point: i.e. each blade root (3x3 x NumBlades) [-]
    LOGICAL  :: UseInputFile = .TRUE.      !< Read from the input file.  If false, must parse the string info passed [-]
    TYPE(FileInfoType)  :: PassedPrimaryInputData      !< Primary input file as FileInfoType (set by driver/glue code) [-]
    LOGICAL  :: UseInputFile_PrescribeFrc = .TRUE.      !< Read from the input file.  If false, must parse the string info passed [-]
    TYPE(FileInfoType)  :: PassedPrescribeFrcData      !< Prescribed forces input file as FileInfoType (set by driver/glue code) [-]
  END TYPE StC_InitInputType
! =======================
! =========  StC_CtrlChanInitInfoType  =======
  TYPE, PUBLIC :: StC_CtrlChanInitInfoType
    CHARACTER(64) , DIMENSION(:), ALLOCATABLE  :: Requestor      !< text string of which StC requests which cable control channel [-]
    REAL(SiKi) , DIMENSION(:,:), ALLOCATABLE  :: InitStiff      !< StC stiffness at initialization  (3,NumStC_Control) -- passed from StC to let controller know the value during init [N/m]
    REAL(SiKi) , DIMENSION(:,:), ALLOCATABLE  :: InitDamp      !< StC damping at initialization  (3,NumStC_Control) -- passed from StC to let controller know the value during init [N/(m/s)]
    REAL(SiKi) , DIMENSION(:,:), ALLOCATABLE  :: InitBrake      !< StC braking signal at initialization  (3,NumStC_Control) -- passed from StC to let controller know the value during init [N]
    REAL(SiKi) , DIMENSION(:,:), ALLOCATABLE  :: InitForce      !< StC external force signal at initialization  (3,NumStC_Control) -- passed from StC to let controller know the value during init (should be zero) [N]
    REAL(SiKi) , DIMENSION(:,:), ALLOCATABLE  :: InitMeasDisp      !< StC measured local displacement signal from StC at initialization  (3,NumStC_Control) [m]
    REAL(SiKi) , DIMENSION(:,:), ALLOCATABLE  :: InitMeasVel      !< StC measured local velocity     signal from StC at initialization (3,NumStC_Control) [m/s]
  END TYPE StC_CtrlChanInitInfoType
! =======================
! =========  StC_InitOutputType  =======
  TYPE, PUBLIC :: StC_InitOutputType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: RelPosition      !< StC position relative to reference point (3,NumMeshPts) [m]
  END TYPE StC_InitOutputType
! =======================
! =========  StC_ContinuousStateType  =======
  TYPE, PUBLIC :: StC_ContinuousStateType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: StC_x      !< Continuous States -- StrucCtrl x [-]
  END TYPE StC_ContinuousStateType
! =======================
! =========  StC_DiscreteStateType  =======
  TYPE, PUBLIC :: StC_DiscreteStateType
    REAL(ReKi)  :: DummyDiscState = 0.0_ReKi      !< Remove this variable if you have discrete states [-]
  END TYPE StC_DiscreteStateType
! =======================
! =========  StC_ConstraintStateType  =======
  TYPE, PUBLIC :: StC_ConstraintStateType
    REAL(ReKi)  :: DummyConstrState = 0.0_ReKi      !< Remove this variable if you have constraint states [-]
  END TYPE StC_ConstraintStateType
! =======================
! =========  StC_OtherStateType  =======
  TYPE, PUBLIC :: StC_OtherStateType
    REAL(ReKi)  :: DummyOtherState = 0.0_ReKi      !< Remove this variable if you have other/logical states [-]
  END TYPE StC_OtherStateType
! =======================
! =========  StC_MiscVarType  =======
  TYPE, PUBLIC :: StC_MiscVarType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_stop      !< Stop forces [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_ext      !< External forces (user defined or from controller) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_fr      !< Friction forces [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: K      !< Stiffness -- might be changed if controller controls this [N/m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: C_ctrl      !< Controlled Damping (On/Off) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: C_Brake      !< Braking Damping [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_table      !< Tabled Stiffness [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_k      !< Factor for x and y-component stiffness force [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: a_G      !< Gravitational acceleration vector, local coordinates for point [m/s^2]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: rdisp_P      !< Translational displacement vector, local coordinates for point [m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: rdot_P      !< Translational velocity     vector, local coordinates for point [m/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: rddot_P      !< Translational acceleration vector, local coordinates for point [m/s^2]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: omega_P      !< Rotational		velocity		 vector, local coordinates for point [rad/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: alpha_P      !< Rotational    aceeleration vector, local coordinates for point [rad/s^2]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_P      !< StC force  vector, local coordinates for point [N]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: M_P      !< StC moment vector, local coordinates for point [N-m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Acc      !< StC aggregated acceleration in X,Y local coordinates for point [m/s^2]
    INTEGER(IntKi)  :: PrescribedInterpIdx = 0_IntKi      !< Index for interpolation of Prescribed force array [-]
  END TYPE StC_MiscVarType
! =======================
! =========  StC_ParameterType  =======
  TYPE, PUBLIC :: StC_ParameterType
    REAL(DbKi)  :: DT = 0.0_R8Ki      !< Time step for cont. state integration & disc. state update [seconds]
    CHARACTER(1024)  :: RootName      !< RootName for writing output files [-]
    INTEGER(IntKi)  :: StC_DOF_MODE = 0_IntKi      !< DOF mode {0: NO StC_DOF; 1: StC_X_DOF and StC_Y_DOF; 2: StC_XY_DOF; 3: TLCD; 4: Prescribed force/moment time series} [-]
    LOGICAL  :: StC_X_DOF = .false.      !< DOF on or off [-]
    LOGICAL  :: StC_Y_DOF = .false.      !< DOF on or off [-]
    LOGICAL  :: StC_Z_DOF = .false.      !< DOF on or off [-]
    REAL(ReKi)  :: StC_Z_PreLd = 0.0_ReKi      !< StC_Z spring preload [N]
    REAL(ReKi)  :: M_X = 0.0_ReKi      !< StC mass [kg]
    REAL(ReKi)  :: M_Y = 0.0_ReKi      !< StC mass [kg]
    REAL(ReKi)  :: M_Z = 0.0_ReKi      !< StC mass [kg]
    REAL(ReKi)  :: M_XY = 0.0_ReKi      !< StCXY mass [kg]
    REAL(ReKi)  :: K_X = 0.0_ReKi      !< StC stiffness [N/m]
    REAL(ReKi)  :: K_Y = 0.0_ReKi      !< StC stiffness [N/m]
    REAL(ReKi)  :: K_Z = 0.0_ReKi      !< StC stiffness [N/m]
    REAL(ReKi)  :: C_X = 0.0_ReKi      !< StC damping [N/(m/s)]
    REAL(ReKi)  :: C_Y = 0.0_ReKi      !< StC damping [N/(m/s)]
    REAL(ReKi)  :: C_Z = 0.0_ReKi      !< StC damping [N/(m/s)]
    REAL(ReKi) , DIMENSION(1:3)  :: K_S = 0.0_ReKi      !< StC stop stiffness [N/m]
    REAL(ReKi) , DIMENSION(1:3)  :: C_S = 0.0_ReKi      !< StC stop damping [N/(m/s)]
    REAL(ReKi) , DIMENSION(1:3)  :: P_SP = 0.0_ReKi      !< Positive stop position (maximum mass displacement) [m]
    REAL(ReKi) , DIMENSION(1:3)  :: N_SP = 0.0_ReKi      !< Negative stop position (minimum X mass displacement) [m]
    REAL(ReKi) , DIMENSION(1:3)  :: Gravity = 0.0_ReKi      !< Gravitational acceleration vector [m/s^2]
    INTEGER(IntKi)  :: StC_CMODE = 0_IntKi      !< control mode {0:none; 1: Semi-Active Control Mode; 4: Active Control Mode through Simulink (not available); 5: Active Control Mode through Bladed interface}  [-]
    INTEGER(IntKi)  :: StC_SA_MODE = 0_IntKi      !< Semi-Active control mode {1: velocity-based ground hook control; 2: Inverse velocity-based ground hook control; 3: displacement-based ground hook control 4: Phase difference Algorithm with Friction Force 5: Phase difference Algorithm with Damping Force}  [-]
    REAL(ReKi)  :: StC_X_C_HIGH = 0.0_ReKi      !< StC X high damping for ground hook control [N/(m/s)]
    REAL(ReKi)  :: StC_X_C_LOW = 0.0_ReKi      !< StC X low damping for ground hook control [N/(m/s)]
    REAL(ReKi)  :: StC_Y_C_HIGH = 0.0_ReKi      !< StC Y high damping for ground hook control [N/(m/s)]
    REAL(ReKi)  :: StC_Y_C_LOW = 0.0_ReKi      !< StC Y low damping for ground hook control [N/(m/s)]
    REAL(ReKi)  :: StC_Z_C_HIGH = 0.0_ReKi      !< StC Z high damping for ground hook control [N/(m/s)]
    REAL(ReKi)  :: StC_Z_C_LOW = 0.0_ReKi      !< StC Z low damping for ground hook control [N/(m/s)]
    REAL(ReKi)  :: StC_X_C_BRAKE = 0.0_ReKi      !< StC X high damping for braking the StC [N/(m/s)]
    REAL(ReKi)  :: StC_Y_C_BRAKE = 0.0_ReKi      !< StC Y high damping for braking the StC [N/(m/s)]
    REAL(ReKi)  :: StC_Z_C_BRAKE = 0.0_ReKi      !< StC Y high damping for braking the StC [N/(m/s)]
    REAL(ReKi)  :: L_X = 0.0_ReKi      !< X TLCD total length [m]
    REAL(ReKi)  :: B_X = 0.0_ReKi      !< X TLCD horizontal length [m]
    REAL(ReKi)  :: area_X = 0.0_ReKi      !< X TLCD cross-sectional area of vertical column [m^2]
    REAL(ReKi)  :: area_ratio_X = 0.0_ReKi      !< X TLCD cross-sectional area ratio (vertical column area divided by horizontal column area) [-]
    REAL(ReKi)  :: headLossCoeff_X = 0.0_ReKi      !< X TLCD head loss coeff [-]
    REAL(ReKi)  :: rho_X = 0.0_ReKi      !< X TLCD liquid density [kg/m^3]
    REAL(ReKi)  :: L_Y = 0.0_ReKi      !< Y TLCD total length [m]
    REAL(ReKi)  :: B_Y = 0.0_ReKi      !< Y TLCD horizontal length [m]
    REAL(ReKi)  :: area_Y = 0.0_ReKi      !< Side-Side TLCD cross-sectional area of vertical column [m]
    REAL(ReKi)  :: area_ratio_Y = 0.0_ReKi      !< Side-Side TLCD cross-sectional area ratio (vertical column area divided by horizontal column area) [-]
    REAL(ReKi)  :: headLossCoeff_Y = 0.0_ReKi      !< Side-Side TLCD head loss coeff [-]
    REAL(ReKi)  :: rho_Y = 0.0_ReKi      !< Side-Side TLCD liquid density [kg/m^3]
    LOGICAL  :: Use_F_TBL = .false.      !< use spring force from user-defined table (flag) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_TBL      !< user-defined spring force [N]
    INTEGER(IntKi)  :: NumMeshPts = 0_IntKi      !< Number of mesh points [-]
    INTEGER(IntKi)  :: PrescribedForcesCoordSys = 0_IntKi      !< Prescribed forces coordinate system {0: global; 1: local} [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: StC_PrescribedForce      !< StC prescribed force time-series info [(s,N,N-m)]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: StC_CChan      !< StC control chan to use [-]
  END TYPE StC_ParameterType
! =======================
! =========  StC_InputType  =======
  TYPE, PUBLIC :: StC_InputType
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: Mesh      !< Displacements at the StC reference point(s) P in the inertial frame [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: CmdStiff      !< StC stiffness from controller [N/m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: CmdDamp      !< StC damping   from controller [N/(m/s)]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: CmdBrake      !< StC braking   from controller [N/(m/s)]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: CmdForce      !< StC force     from controller [N]
  END TYPE StC_InputType
! =======================
! =========  StC_OutputType  =======
  TYPE, PUBLIC :: StC_OutputType
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: Mesh      !< Loads at the StC reference points in the inertial frame [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: MeasDisp      !< StC measured relative displacement of tmd mass (local coordinates) signal to controller [m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: MeasVel      !< StC measured relative velocity     of tmd mass (local coordinates) signal to controller [m/s]
  END TYPE StC_OutputType
! =======================
CONTAINS

subroutine StC_CopyInputFile(SrcInputFileData, DstInputFileData, CtrlCode, ErrStat, ErrMsg)
   type(StC_InputFile), intent(in) :: SrcInputFileData
   type(StC_InputFile), intent(inout) :: DstInputFileData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'StC_CopyInputFile'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInputFileData%StCFileName = SrcInputFileData%StCFileName
   DstInputFileData%Echo = SrcInputFileData%Echo
   DstInputFileData%StC_CMODE = SrcInputFileData%StC_CMODE
   DstInputFileData%StC_SA_MODE = SrcInputFileData%StC_SA_MODE
   DstInputFileData%StC_DOF_MODE = SrcInputFileData%StC_DOF_MODE
   DstInputFileData%StC_X_DOF = SrcInputFileData%StC_X_DOF
   DstInputFileData%StC_Y_DOF = SrcInputFileData%StC_Y_DOF
   DstInputFileData%StC_Z_DOF = SrcInputFileData%StC_Z_DOF
   DstInputFileData%StC_X_DSP = SrcInputFileData%StC_X_DSP
   DstInputFileData%StC_Y_DSP = SrcInputFileData%StC_Y_DSP
   DstInputFileData%StC_Z_DSP = SrcInputFileData%StC_Z_DSP
   DstInputFileData%StC_Z_PreLdC = SrcInputFileData%StC_Z_PreLdC
   DstInputFileData%StC_X_M = SrcInputFileData%StC_X_M
   DstInputFileData%StC_Y_M = SrcInputFileData%StC_Y_M
   DstInputFileData%StC_Z_M = SrcInputFileData%StC_Z_M
   DstInputFileData%StC_XY_M = SrcInputFileData%StC_XY_M
   DstInputFileData%StC_X_K = SrcInputFileData%StC_X_K
   DstInputFileData%StC_Y_K = SrcInputFileData%StC_Y_K
   DstInputFileData%StC_Z_K = SrcInputFileData%StC_Z_K
   DstInputFileData%StC_X_C = SrcInputFileData%StC_X_C
   DstInputFileData%StC_Y_C = SrcInputFileData%StC_Y_C
   DstInputFileData%StC_Z_C = SrcInputFileData%StC_Z_C
   DstInputFileData%StC_X_PSP = SrcInputFileData%StC_X_PSP
   DstInputFileData%StC_X_NSP = SrcInputFileData%StC_X_NSP
   DstInputFileData%StC_Y_PSP = SrcInputFileData%StC_Y_PSP
   DstInputFileData%StC_Y_NSP = SrcInputFileData%StC_Y_NSP
   DstInputFileData%StC_Z_PSP = SrcInputFileData%StC_Z_PSP
   DstInputFileData%StC_Z_NSP = SrcInputFileData%StC_Z_NSP
   DstInputFileData%StC_X_KS = SrcInputFileData%StC_X_KS
   DstInputFileData%StC_X_CS = SrcInputFileData%StC_X_CS
   DstInputFileData%StC_Y_KS = SrcInputFileData%StC_Y_KS
   DstInputFileData%StC_Y_CS = SrcInputFileData%StC_Y_CS
   DstInputFileData%StC_Z_KS = SrcInputFileData%StC_Z_KS
   DstInputFileData%StC_Z_CS = SrcInputFileData%StC_Z_CS
   DstInputFileData%StC_P_X = SrcInputFileData%StC_P_X
   DstInputFileData%StC_P_Y = SrcInputFileData%StC_P_Y
   DstInputFileData%StC_P_Z = SrcInputFileData%StC_P_Z
   DstInputFileData%StC_X_C_HIGH = SrcInputFileData%StC_X_C_HIGH
   DstInputFileData%StC_X_C_LOW = SrcInputFileData%StC_X_C_LOW
   DstInputFileData%StC_Y_C_HIGH = SrcInputFileData%StC_Y_C_HIGH
   DstInputFileData%StC_Y_C_LOW = SrcInputFileData%StC_Y_C_LOW
   DstInputFileData%StC_Z_C_HIGH = SrcInputFileData%StC_Z_C_HIGH
   DstInputFileData%StC_Z_C_LOW = SrcInputFileData%StC_Z_C_LOW
   DstInputFileData%StC_X_C_BRAKE = SrcInputFileData%StC_X_C_BRAKE
   DstInputFileData%StC_Y_C_BRAKE = SrcInputFileData%StC_Y_C_BRAKE
   DstInputFileData%StC_Z_C_BRAKE = SrcInputFileData%StC_Z_C_BRAKE
   DstInputFileData%L_X = SrcInputFileData%L_X
   DstInputFileData%B_X = SrcInputFileData%B_X
   DstInputFileData%area_X = SrcInputFileData%area_X
   DstInputFileData%area_ratio_X = SrcInputFileData%area_ratio_X
   DstInputFileData%headLossCoeff_X = SrcInputFileData%headLossCoeff_X
   DstInputFileData%rho_X = SrcInputFileData%rho_X
   DstInputFileData%L_Y = SrcInputFileData%L_Y
   DstInputFileData%B_Y = SrcInputFileData%B_Y
   DstInputFileData%area_Y = SrcInputFileData%area_Y
   DstInputFileData%area_ratio_Y = SrcInputFileData%area_ratio_Y
   DstInputFileData%headLossCoeff_Y = SrcInputFileData%headLossCoeff_Y
   DstInputFileData%rho_Y = SrcInputFileData%rho_Y
   DstInputFileData%USE_F_TBL = SrcInputFileData%USE_F_TBL
   DstInputFileData%NKInpSt = SrcInputFileData%NKInpSt
   DstInputFileData%StC_F_TBL_FILE = SrcInputFileData%StC_F_TBL_FILE
   if (allocated(SrcInputFileData%F_TBL)) then
      LB(1:2) = lbound(SrcInputFileData%F_TBL)
      UB(1:2) = ubound(SrcInputFileData%F_TBL)
      if (.not. allocated(DstInputFileData%F_TBL)) then
         allocate(DstInputFileData%F_TBL(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%F_TBL.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%F_TBL = SrcInputFileData%F_TBL
   end if
   DstInputFileData%PrescribedForcesCoordSys = SrcInputFileData%PrescribedForcesCoordSys
   DstInputFileData%PrescribedForcesFile = SrcInputFileData%PrescribedForcesFile
   if (allocated(SrcInputFileData%StC_PrescribedForce)) then
      LB(1:2) = lbound(SrcInputFileData%StC_PrescribedForce)
      UB(1:2) = ubound(SrcInputFileData%StC_PrescribedForce)
      if (.not. allocated(DstInputFileData%StC_PrescribedForce)) then
         allocate(DstInputFileData%StC_PrescribedForce(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%StC_PrescribedForce.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%StC_PrescribedForce = SrcInputFileData%StC_PrescribedForce
   end if
   if (allocated(SrcInputFileData%StC_CChan)) then
      LB(1:1) = lbound(SrcInputFileData%StC_CChan)
      UB(1:1) = ubound(SrcInputFileData%StC_CChan)
      if (.not. allocated(DstInputFileData%StC_CChan)) then
         allocate(DstInputFileData%StC_CChan(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%StC_CChan.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%StC_CChan = SrcInputFileData%StC_CChan
   end if
end subroutine

subroutine StC_DestroyInputFile(InputFileData, ErrStat, ErrMsg)
   type(StC_InputFile), intent(inout) :: InputFileData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'StC_DestroyInputFile'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InputFileData%F_TBL)) then
      deallocate(InputFileData%F_TBL)
   end if
   if (allocated(InputFileData%StC_PrescribedForce)) then
      deallocate(InputFileData%StC_PrescribedForce)
   end if
   if (allocated(InputFileData%StC_CChan)) then
      deallocate(InputFileData%StC_CChan)
   end if
end subroutine

subroutine StC_PackInputFile(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(StC_InputFile), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'StC_PackInputFile'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%StCFileName)
   call RegPack(RF, InData%Echo)
   call RegPack(RF, InData%StC_CMODE)
   call RegPack(RF, InData%StC_SA_MODE)
   call RegPack(RF, InData%StC_DOF_MODE)
   call RegPack(RF, InData%StC_X_DOF)
   call RegPack(RF, InData%StC_Y_DOF)
   call RegPack(RF, InData%StC_Z_DOF)
   call RegPack(RF, InData%StC_X_DSP)
   call RegPack(RF, InData%StC_Y_DSP)
   call RegPack(RF, InData%StC_Z_DSP)
   call RegPack(RF, InData%StC_Z_PreLdC)
   call RegPack(RF, InData%StC_X_M)
   call RegPack(RF, InData%StC_Y_M)
   call RegPack(RF, InData%StC_Z_M)
   call RegPack(RF, InData%StC_XY_M)
   call RegPack(RF, InData%StC_X_K)
   call RegPack(RF, InData%StC_Y_K)
   call RegPack(RF, InData%StC_Z_K)
   call RegPack(RF, InData%StC_X_C)
   call RegPack(RF, InData%StC_Y_C)
   call RegPack(RF, InData%StC_Z_C)
   call RegPack(RF, InData%StC_X_PSP)
   call RegPack(RF, InData%StC_X_NSP)
   call RegPack(RF, InData%StC_Y_PSP)
   call RegPack(RF, InData%StC_Y_NSP)
   call RegPack(RF, InData%StC_Z_PSP)
   call RegPack(RF, InData%StC_Z_NSP)
   call RegPack(RF, InData%StC_X_KS)
   call RegPack(RF, InData%StC_X_CS)
   call RegPack(RF, InData%StC_Y_KS)
   call RegPack(RF, InData%StC_Y_CS)
   call RegPack(RF, InData%StC_Z_KS)
   call RegPack(RF, InData%StC_Z_CS)
   call RegPack(RF, InData%StC_P_X)
   call RegPack(RF, InData%StC_P_Y)
   call RegPack(RF, InData%StC_P_Z)
   call RegPack(RF, InData%StC_X_C_HIGH)
   call RegPack(RF, InData%StC_X_C_LOW)
   call RegPack(RF, InData%StC_Y_C_HIGH)
   call RegPack(RF, InData%StC_Y_C_LOW)
   call RegPack(RF, InData%StC_Z_C_HIGH)
   call RegPack(RF, InData%StC_Z_C_LOW)
   call RegPack(RF, InData%StC_X_C_BRAKE)
   call RegPack(RF, InData%StC_Y_C_BRAKE)
   call RegPack(RF, InData%StC_Z_C_BRAKE)
   call RegPack(RF, InData%L_X)
   call RegPack(RF, InData%B_X)
   call RegPack(RF, InData%area_X)
   call RegPack(RF, InData%area_ratio_X)
   call RegPack(RF, InData%headLossCoeff_X)
   call RegPack(RF, InData%rho_X)
   call RegPack(RF, InData%L_Y)
   call RegPack(RF, InData%B_Y)
   call RegPack(RF, InData%area_Y)
   call RegPack(RF, InData%area_ratio_Y)
   call RegPack(RF, InData%headLossCoeff_Y)
   call RegPack(RF, InData%rho_Y)
   call RegPack(RF, InData%USE_F_TBL)
   call RegPack(RF, InData%NKInpSt)
   call RegPack(RF, InData%StC_F_TBL_FILE)
   call RegPackAlloc(RF, InData%F_TBL)
   call RegPack(RF, InData%PrescribedForcesCoordSys)
   call RegPack(RF, InData%PrescribedForcesFile)
   call RegPackAlloc(RF, InData%StC_PrescribedForce)
   call RegPackAlloc(RF, InData%StC_CChan)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine StC_UnPackInputFile(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(StC_InputFile), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'StC_UnPackInputFile'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%StCFileName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Echo); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_CMODE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_SA_MODE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_DOF_MODE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_X_DOF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_Y_DOF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_Z_DOF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_X_DSP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_Y_DSP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_Z_DSP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_Z_PreLdC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_X_M); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_Y_M); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_Z_M); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_XY_M); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_X_K); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_Y_K); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_Z_K); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_X_C); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_Y_C); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_Z_C); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_X_PSP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_X_NSP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_Y_PSP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_Y_NSP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_Z_PSP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_Z_NSP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_X_KS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_X_CS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_Y_KS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_Y_CS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_Z_KS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_Z_CS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_P_X); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_P_Y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_P_Z); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_X_C_HIGH); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_X_C_LOW); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_Y_C_HIGH); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_Y_C_LOW); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_Z_C_HIGH); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_Z_C_LOW); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_X_C_BRAKE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_Y_C_BRAKE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_Z_C_BRAKE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%L_X); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%B_X); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%area_X); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%area_ratio_X); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%headLossCoeff_X); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rho_X); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%L_Y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%B_Y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%area_Y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%area_ratio_Y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%headLossCoeff_Y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rho_Y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%USE_F_TBL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NKInpSt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_F_TBL_FILE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%F_TBL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PrescribedForcesCoordSys); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PrescribedForcesFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%StC_PrescribedForce); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%StC_CChan); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine StC_CopyInitInput(SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg)
   type(StC_InitInputType), intent(in) :: SrcInitInputData
   type(StC_InitInputType), intent(inout) :: DstInitInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'StC_CopyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInitInputData%InputFile = SrcInitInputData%InputFile
   DstInitInputData%RootName = SrcInitInputData%RootName
   DstInitInputData%Gravity = SrcInitInputData%Gravity
   DstInitInputData%NumMeshPts = SrcInitInputData%NumMeshPts
   if (allocated(SrcInitInputData%InitRefPos)) then
      LB(1:2) = lbound(SrcInitInputData%InitRefPos)
      UB(1:2) = ubound(SrcInitInputData%InitRefPos)
      if (.not. allocated(DstInitInputData%InitRefPos)) then
         allocate(DstInitInputData%InitRefPos(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%InitRefPos.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%InitRefPos = SrcInitInputData%InitRefPos
   end if
   if (allocated(SrcInitInputData%InitTransDisp)) then
      LB(1:2) = lbound(SrcInitInputData%InitTransDisp)
      UB(1:2) = ubound(SrcInitInputData%InitTransDisp)
      if (.not. allocated(DstInitInputData%InitTransDisp)) then
         allocate(DstInitInputData%InitTransDisp(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%InitTransDisp.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%InitTransDisp = SrcInitInputData%InitTransDisp
   end if
   if (allocated(SrcInitInputData%InitOrient)) then
      LB(1:3) = lbound(SrcInitInputData%InitOrient)
      UB(1:3) = ubound(SrcInitInputData%InitOrient)
      if (.not. allocated(DstInitInputData%InitOrient)) then
         allocate(DstInitInputData%InitOrient(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%InitOrient.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%InitOrient = SrcInitInputData%InitOrient
   end if
   if (allocated(SrcInitInputData%InitRefOrient)) then
      LB(1:3) = lbound(SrcInitInputData%InitRefOrient)
      UB(1:3) = ubound(SrcInitInputData%InitRefOrient)
      if (.not. allocated(DstInitInputData%InitRefOrient)) then
         allocate(DstInitInputData%InitRefOrient(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%InitRefOrient.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%InitRefOrient = SrcInitInputData%InitRefOrient
   end if
   DstInitInputData%UseInputFile = SrcInitInputData%UseInputFile
   call NWTC_Library_CopyFileInfoType(SrcInitInputData%PassedPrimaryInputData, DstInitInputData%PassedPrimaryInputData, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstInitInputData%UseInputFile_PrescribeFrc = SrcInitInputData%UseInputFile_PrescribeFrc
   call NWTC_Library_CopyFileInfoType(SrcInitInputData%PassedPrescribeFrcData, DstInitInputData%PassedPrescribeFrcData, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine StC_DestroyInitInput(InitInputData, ErrStat, ErrMsg)
   type(StC_InitInputType), intent(inout) :: InitInputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'StC_DestroyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InitInputData%InitRefPos)) then
      deallocate(InitInputData%InitRefPos)
   end if
   if (allocated(InitInputData%InitTransDisp)) then
      deallocate(InitInputData%InitTransDisp)
   end if
   if (allocated(InitInputData%InitOrient)) then
      deallocate(InitInputData%InitOrient)
   end if
   if (allocated(InitInputData%InitRefOrient)) then
      deallocate(InitInputData%InitRefOrient)
   end if
   call NWTC_Library_DestroyFileInfoType(InitInputData%PassedPrimaryInputData, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call NWTC_Library_DestroyFileInfoType(InitInputData%PassedPrescribeFrcData, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine StC_PackInitInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(StC_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'StC_PackInitInput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%InputFile)
   call RegPack(RF, InData%RootName)
   call RegPack(RF, InData%Gravity)
   call RegPack(RF, InData%NumMeshPts)
   call RegPackAlloc(RF, InData%InitRefPos)
   call RegPackAlloc(RF, InData%InitTransDisp)
   call RegPackAlloc(RF, InData%InitOrient)
   call RegPackAlloc(RF, InData%InitRefOrient)
   call RegPack(RF, InData%UseInputFile)
   call NWTC_Library_PackFileInfoType(RF, InData%PassedPrimaryInputData) 
   call RegPack(RF, InData%UseInputFile_PrescribeFrc)
   call NWTC_Library_PackFileInfoType(RF, InData%PassedPrescribeFrcData) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine StC_UnPackInitInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(StC_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'StC_UnPackInitInput'
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%InputFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Gravity); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumMeshPts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%InitRefPos); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%InitTransDisp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%InitOrient); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%InitRefOrient); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UseInputFile); if (RegCheckErr(RF, RoutineName)) return
   call NWTC_Library_UnpackFileInfoType(RF, OutData%PassedPrimaryInputData) ! PassedPrimaryInputData 
   call RegUnpack(RF, OutData%UseInputFile_PrescribeFrc); if (RegCheckErr(RF, RoutineName)) return
   call NWTC_Library_UnpackFileInfoType(RF, OutData%PassedPrescribeFrcData) ! PassedPrescribeFrcData 
end subroutine

subroutine StC_CopyCtrlChanInitInfoType(SrcCtrlChanInitInfoTypeData, DstCtrlChanInitInfoTypeData, CtrlCode, ErrStat, ErrMsg)
   type(StC_CtrlChanInitInfoType), intent(in) :: SrcCtrlChanInitInfoTypeData
   type(StC_CtrlChanInitInfoType), intent(inout) :: DstCtrlChanInitInfoTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'StC_CopyCtrlChanInitInfoType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcCtrlChanInitInfoTypeData%Requestor)) then
      LB(1:1) = lbound(SrcCtrlChanInitInfoTypeData%Requestor)
      UB(1:1) = ubound(SrcCtrlChanInitInfoTypeData%Requestor)
      if (.not. allocated(DstCtrlChanInitInfoTypeData%Requestor)) then
         allocate(DstCtrlChanInitInfoTypeData%Requestor(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstCtrlChanInitInfoTypeData%Requestor.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstCtrlChanInitInfoTypeData%Requestor = SrcCtrlChanInitInfoTypeData%Requestor
   end if
   if (allocated(SrcCtrlChanInitInfoTypeData%InitStiff)) then
      LB(1:2) = lbound(SrcCtrlChanInitInfoTypeData%InitStiff)
      UB(1:2) = ubound(SrcCtrlChanInitInfoTypeData%InitStiff)
      if (.not. allocated(DstCtrlChanInitInfoTypeData%InitStiff)) then
         allocate(DstCtrlChanInitInfoTypeData%InitStiff(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstCtrlChanInitInfoTypeData%InitStiff.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstCtrlChanInitInfoTypeData%InitStiff = SrcCtrlChanInitInfoTypeData%InitStiff
   end if
   if (allocated(SrcCtrlChanInitInfoTypeData%InitDamp)) then
      LB(1:2) = lbound(SrcCtrlChanInitInfoTypeData%InitDamp)
      UB(1:2) = ubound(SrcCtrlChanInitInfoTypeData%InitDamp)
      if (.not. allocated(DstCtrlChanInitInfoTypeData%InitDamp)) then
         allocate(DstCtrlChanInitInfoTypeData%InitDamp(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstCtrlChanInitInfoTypeData%InitDamp.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstCtrlChanInitInfoTypeData%InitDamp = SrcCtrlChanInitInfoTypeData%InitDamp
   end if
   if (allocated(SrcCtrlChanInitInfoTypeData%InitBrake)) then
      LB(1:2) = lbound(SrcCtrlChanInitInfoTypeData%InitBrake)
      UB(1:2) = ubound(SrcCtrlChanInitInfoTypeData%InitBrake)
      if (.not. allocated(DstCtrlChanInitInfoTypeData%InitBrake)) then
         allocate(DstCtrlChanInitInfoTypeData%InitBrake(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstCtrlChanInitInfoTypeData%InitBrake.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstCtrlChanInitInfoTypeData%InitBrake = SrcCtrlChanInitInfoTypeData%InitBrake
   end if
   if (allocated(SrcCtrlChanInitInfoTypeData%InitForce)) then
      LB(1:2) = lbound(SrcCtrlChanInitInfoTypeData%InitForce)
      UB(1:2) = ubound(SrcCtrlChanInitInfoTypeData%InitForce)
      if (.not. allocated(DstCtrlChanInitInfoTypeData%InitForce)) then
         allocate(DstCtrlChanInitInfoTypeData%InitForce(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstCtrlChanInitInfoTypeData%InitForce.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstCtrlChanInitInfoTypeData%InitForce = SrcCtrlChanInitInfoTypeData%InitForce
   end if
   if (allocated(SrcCtrlChanInitInfoTypeData%InitMeasDisp)) then
      LB(1:2) = lbound(SrcCtrlChanInitInfoTypeData%InitMeasDisp)
      UB(1:2) = ubound(SrcCtrlChanInitInfoTypeData%InitMeasDisp)
      if (.not. allocated(DstCtrlChanInitInfoTypeData%InitMeasDisp)) then
         allocate(DstCtrlChanInitInfoTypeData%InitMeasDisp(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstCtrlChanInitInfoTypeData%InitMeasDisp.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstCtrlChanInitInfoTypeData%InitMeasDisp = SrcCtrlChanInitInfoTypeData%InitMeasDisp
   end if
   if (allocated(SrcCtrlChanInitInfoTypeData%InitMeasVel)) then
      LB(1:2) = lbound(SrcCtrlChanInitInfoTypeData%InitMeasVel)
      UB(1:2) = ubound(SrcCtrlChanInitInfoTypeData%InitMeasVel)
      if (.not. allocated(DstCtrlChanInitInfoTypeData%InitMeasVel)) then
         allocate(DstCtrlChanInitInfoTypeData%InitMeasVel(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstCtrlChanInitInfoTypeData%InitMeasVel.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstCtrlChanInitInfoTypeData%InitMeasVel = SrcCtrlChanInitInfoTypeData%InitMeasVel
   end if
end subroutine

subroutine StC_DestroyCtrlChanInitInfoType(CtrlChanInitInfoTypeData, ErrStat, ErrMsg)
   type(StC_CtrlChanInitInfoType), intent(inout) :: CtrlChanInitInfoTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'StC_DestroyCtrlChanInitInfoType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(CtrlChanInitInfoTypeData%Requestor)) then
      deallocate(CtrlChanInitInfoTypeData%Requestor)
   end if
   if (allocated(CtrlChanInitInfoTypeData%InitStiff)) then
      deallocate(CtrlChanInitInfoTypeData%InitStiff)
   end if
   if (allocated(CtrlChanInitInfoTypeData%InitDamp)) then
      deallocate(CtrlChanInitInfoTypeData%InitDamp)
   end if
   if (allocated(CtrlChanInitInfoTypeData%InitBrake)) then
      deallocate(CtrlChanInitInfoTypeData%InitBrake)
   end if
   if (allocated(CtrlChanInitInfoTypeData%InitForce)) then
      deallocate(CtrlChanInitInfoTypeData%InitForce)
   end if
   if (allocated(CtrlChanInitInfoTypeData%InitMeasDisp)) then
      deallocate(CtrlChanInitInfoTypeData%InitMeasDisp)
   end if
   if (allocated(CtrlChanInitInfoTypeData%InitMeasVel)) then
      deallocate(CtrlChanInitInfoTypeData%InitMeasVel)
   end if
end subroutine

subroutine StC_PackCtrlChanInitInfoType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(StC_CtrlChanInitInfoType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'StC_PackCtrlChanInitInfoType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%Requestor)
   call RegPackAlloc(RF, InData%InitStiff)
   call RegPackAlloc(RF, InData%InitDamp)
   call RegPackAlloc(RF, InData%InitBrake)
   call RegPackAlloc(RF, InData%InitForce)
   call RegPackAlloc(RF, InData%InitMeasDisp)
   call RegPackAlloc(RF, InData%InitMeasVel)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine StC_UnPackCtrlChanInitInfoType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(StC_CtrlChanInitInfoType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'StC_UnPackCtrlChanInitInfoType'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%Requestor); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%InitStiff); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%InitDamp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%InitBrake); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%InitForce); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%InitMeasDisp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%InitMeasVel); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine StC_CopyInitOutput(SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg)
   type(StC_InitOutputType), intent(in) :: SrcInitOutputData
   type(StC_InitOutputType), intent(inout) :: DstInitOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'StC_CopyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcInitOutputData%RelPosition)) then
      LB(1:2) = lbound(SrcInitOutputData%RelPosition)
      UB(1:2) = ubound(SrcInitOutputData%RelPosition)
      if (.not. allocated(DstInitOutputData%RelPosition)) then
         allocate(DstInitOutputData%RelPosition(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%RelPosition.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%RelPosition = SrcInitOutputData%RelPosition
   end if
end subroutine

subroutine StC_DestroyInitOutput(InitOutputData, ErrStat, ErrMsg)
   type(StC_InitOutputType), intent(inout) :: InitOutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'StC_DestroyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InitOutputData%RelPosition)) then
      deallocate(InitOutputData%RelPosition)
   end if
end subroutine

subroutine StC_PackInitOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(StC_InitOutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'StC_PackInitOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%RelPosition)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine StC_UnPackInitOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(StC_InitOutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'StC_UnPackInitOutput'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%RelPosition); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine StC_CopyContState(SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg)
   type(StC_ContinuousStateType), intent(in) :: SrcContStateData
   type(StC_ContinuousStateType), intent(inout) :: DstContStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'StC_CopyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcContStateData%StC_x)) then
      LB(1:2) = lbound(SrcContStateData%StC_x)
      UB(1:2) = ubound(SrcContStateData%StC_x)
      if (.not. allocated(DstContStateData%StC_x)) then
         allocate(DstContStateData%StC_x(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstContStateData%StC_x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstContStateData%StC_x = SrcContStateData%StC_x
   end if
end subroutine

subroutine StC_DestroyContState(ContStateData, ErrStat, ErrMsg)
   type(StC_ContinuousStateType), intent(inout) :: ContStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'StC_DestroyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ContStateData%StC_x)) then
      deallocate(ContStateData%StC_x)
   end if
end subroutine

subroutine StC_PackContState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(StC_ContinuousStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'StC_PackContState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%StC_x)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine StC_UnPackContState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(StC_ContinuousStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'StC_UnPackContState'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%StC_x); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine StC_CopyDiscState(SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg)
   type(StC_DiscreteStateType), intent(in) :: SrcDiscStateData
   type(StC_DiscreteStateType), intent(inout) :: DstDiscStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'StC_CopyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstDiscStateData%DummyDiscState = SrcDiscStateData%DummyDiscState
end subroutine

subroutine StC_DestroyDiscState(DiscStateData, ErrStat, ErrMsg)
   type(StC_DiscreteStateType), intent(inout) :: DiscStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'StC_DestroyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine StC_PackDiscState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(StC_DiscreteStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'StC_PackDiscState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyDiscState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine StC_UnPackDiscState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(StC_DiscreteStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'StC_UnPackDiscState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyDiscState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine StC_CopyConstrState(SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg)
   type(StC_ConstraintStateType), intent(in) :: SrcConstrStateData
   type(StC_ConstraintStateType), intent(inout) :: DstConstrStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'StC_CopyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstConstrStateData%DummyConstrState = SrcConstrStateData%DummyConstrState
end subroutine

subroutine StC_DestroyConstrState(ConstrStateData, ErrStat, ErrMsg)
   type(StC_ConstraintStateType), intent(inout) :: ConstrStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'StC_DestroyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine StC_PackConstrState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(StC_ConstraintStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'StC_PackConstrState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyConstrState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine StC_UnPackConstrState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(StC_ConstraintStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'StC_UnPackConstrState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyConstrState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine StC_CopyOtherState(SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg)
   type(StC_OtherStateType), intent(in) :: SrcOtherStateData
   type(StC_OtherStateType), intent(inout) :: DstOtherStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'StC_CopyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstOtherStateData%DummyOtherState = SrcOtherStateData%DummyOtherState
end subroutine

subroutine StC_DestroyOtherState(OtherStateData, ErrStat, ErrMsg)
   type(StC_OtherStateType), intent(inout) :: OtherStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'StC_DestroyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine StC_PackOtherState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(StC_OtherStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'StC_PackOtherState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyOtherState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine StC_UnPackOtherState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(StC_OtherStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'StC_UnPackOtherState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyOtherState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine StC_CopyMisc(SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg)
   type(StC_MiscVarType), intent(in) :: SrcMiscData
   type(StC_MiscVarType), intent(inout) :: DstMiscData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'StC_CopyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcMiscData%F_stop)) then
      LB(1:2) = lbound(SrcMiscData%F_stop)
      UB(1:2) = ubound(SrcMiscData%F_stop)
      if (.not. allocated(DstMiscData%F_stop)) then
         allocate(DstMiscData%F_stop(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%F_stop.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%F_stop = SrcMiscData%F_stop
   end if
   if (allocated(SrcMiscData%F_ext)) then
      LB(1:2) = lbound(SrcMiscData%F_ext)
      UB(1:2) = ubound(SrcMiscData%F_ext)
      if (.not. allocated(DstMiscData%F_ext)) then
         allocate(DstMiscData%F_ext(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%F_ext.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%F_ext = SrcMiscData%F_ext
   end if
   if (allocated(SrcMiscData%F_fr)) then
      LB(1:2) = lbound(SrcMiscData%F_fr)
      UB(1:2) = ubound(SrcMiscData%F_fr)
      if (.not. allocated(DstMiscData%F_fr)) then
         allocate(DstMiscData%F_fr(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%F_fr.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%F_fr = SrcMiscData%F_fr
   end if
   if (allocated(SrcMiscData%K)) then
      LB(1:2) = lbound(SrcMiscData%K)
      UB(1:2) = ubound(SrcMiscData%K)
      if (.not. allocated(DstMiscData%K)) then
         allocate(DstMiscData%K(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%K.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%K = SrcMiscData%K
   end if
   if (allocated(SrcMiscData%C_ctrl)) then
      LB(1:2) = lbound(SrcMiscData%C_ctrl)
      UB(1:2) = ubound(SrcMiscData%C_ctrl)
      if (.not. allocated(DstMiscData%C_ctrl)) then
         allocate(DstMiscData%C_ctrl(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%C_ctrl.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%C_ctrl = SrcMiscData%C_ctrl
   end if
   if (allocated(SrcMiscData%C_Brake)) then
      LB(1:2) = lbound(SrcMiscData%C_Brake)
      UB(1:2) = ubound(SrcMiscData%C_Brake)
      if (.not. allocated(DstMiscData%C_Brake)) then
         allocate(DstMiscData%C_Brake(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%C_Brake.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%C_Brake = SrcMiscData%C_Brake
   end if
   if (allocated(SrcMiscData%F_table)) then
      LB(1:2) = lbound(SrcMiscData%F_table)
      UB(1:2) = ubound(SrcMiscData%F_table)
      if (.not. allocated(DstMiscData%F_table)) then
         allocate(DstMiscData%F_table(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%F_table.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%F_table = SrcMiscData%F_table
   end if
   if (allocated(SrcMiscData%F_k)) then
      LB(1:2) = lbound(SrcMiscData%F_k)
      UB(1:2) = ubound(SrcMiscData%F_k)
      if (.not. allocated(DstMiscData%F_k)) then
         allocate(DstMiscData%F_k(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%F_k.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%F_k = SrcMiscData%F_k
   end if
   if (allocated(SrcMiscData%a_G)) then
      LB(1:2) = lbound(SrcMiscData%a_G)
      UB(1:2) = ubound(SrcMiscData%a_G)
      if (.not. allocated(DstMiscData%a_G)) then
         allocate(DstMiscData%a_G(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%a_G.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%a_G = SrcMiscData%a_G
   end if
   if (allocated(SrcMiscData%rdisp_P)) then
      LB(1:2) = lbound(SrcMiscData%rdisp_P)
      UB(1:2) = ubound(SrcMiscData%rdisp_P)
      if (.not. allocated(DstMiscData%rdisp_P)) then
         allocate(DstMiscData%rdisp_P(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%rdisp_P.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%rdisp_P = SrcMiscData%rdisp_P
   end if
   if (allocated(SrcMiscData%rdot_P)) then
      LB(1:2) = lbound(SrcMiscData%rdot_P)
      UB(1:2) = ubound(SrcMiscData%rdot_P)
      if (.not. allocated(DstMiscData%rdot_P)) then
         allocate(DstMiscData%rdot_P(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%rdot_P.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%rdot_P = SrcMiscData%rdot_P
   end if
   if (allocated(SrcMiscData%rddot_P)) then
      LB(1:2) = lbound(SrcMiscData%rddot_P)
      UB(1:2) = ubound(SrcMiscData%rddot_P)
      if (.not. allocated(DstMiscData%rddot_P)) then
         allocate(DstMiscData%rddot_P(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%rddot_P.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%rddot_P = SrcMiscData%rddot_P
   end if
   if (allocated(SrcMiscData%omega_P)) then
      LB(1:2) = lbound(SrcMiscData%omega_P)
      UB(1:2) = ubound(SrcMiscData%omega_P)
      if (.not. allocated(DstMiscData%omega_P)) then
         allocate(DstMiscData%omega_P(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%omega_P.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%omega_P = SrcMiscData%omega_P
   end if
   if (allocated(SrcMiscData%alpha_P)) then
      LB(1:2) = lbound(SrcMiscData%alpha_P)
      UB(1:2) = ubound(SrcMiscData%alpha_P)
      if (.not. allocated(DstMiscData%alpha_P)) then
         allocate(DstMiscData%alpha_P(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%alpha_P.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%alpha_P = SrcMiscData%alpha_P
   end if
   if (allocated(SrcMiscData%F_P)) then
      LB(1:2) = lbound(SrcMiscData%F_P)
      UB(1:2) = ubound(SrcMiscData%F_P)
      if (.not. allocated(DstMiscData%F_P)) then
         allocate(DstMiscData%F_P(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%F_P.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%F_P = SrcMiscData%F_P
   end if
   if (allocated(SrcMiscData%M_P)) then
      LB(1:2) = lbound(SrcMiscData%M_P)
      UB(1:2) = ubound(SrcMiscData%M_P)
      if (.not. allocated(DstMiscData%M_P)) then
         allocate(DstMiscData%M_P(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%M_P.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%M_P = SrcMiscData%M_P
   end if
   if (allocated(SrcMiscData%Acc)) then
      LB(1:2) = lbound(SrcMiscData%Acc)
      UB(1:2) = ubound(SrcMiscData%Acc)
      if (.not. allocated(DstMiscData%Acc)) then
         allocate(DstMiscData%Acc(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%Acc.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%Acc = SrcMiscData%Acc
   end if
   DstMiscData%PrescribedInterpIdx = SrcMiscData%PrescribedInterpIdx
end subroutine

subroutine StC_DestroyMisc(MiscData, ErrStat, ErrMsg)
   type(StC_MiscVarType), intent(inout) :: MiscData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'StC_DestroyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(MiscData%F_stop)) then
      deallocate(MiscData%F_stop)
   end if
   if (allocated(MiscData%F_ext)) then
      deallocate(MiscData%F_ext)
   end if
   if (allocated(MiscData%F_fr)) then
      deallocate(MiscData%F_fr)
   end if
   if (allocated(MiscData%K)) then
      deallocate(MiscData%K)
   end if
   if (allocated(MiscData%C_ctrl)) then
      deallocate(MiscData%C_ctrl)
   end if
   if (allocated(MiscData%C_Brake)) then
      deallocate(MiscData%C_Brake)
   end if
   if (allocated(MiscData%F_table)) then
      deallocate(MiscData%F_table)
   end if
   if (allocated(MiscData%F_k)) then
      deallocate(MiscData%F_k)
   end if
   if (allocated(MiscData%a_G)) then
      deallocate(MiscData%a_G)
   end if
   if (allocated(MiscData%rdisp_P)) then
      deallocate(MiscData%rdisp_P)
   end if
   if (allocated(MiscData%rdot_P)) then
      deallocate(MiscData%rdot_P)
   end if
   if (allocated(MiscData%rddot_P)) then
      deallocate(MiscData%rddot_P)
   end if
   if (allocated(MiscData%omega_P)) then
      deallocate(MiscData%omega_P)
   end if
   if (allocated(MiscData%alpha_P)) then
      deallocate(MiscData%alpha_P)
   end if
   if (allocated(MiscData%F_P)) then
      deallocate(MiscData%F_P)
   end if
   if (allocated(MiscData%M_P)) then
      deallocate(MiscData%M_P)
   end if
   if (allocated(MiscData%Acc)) then
      deallocate(MiscData%Acc)
   end if
end subroutine

subroutine StC_PackMisc(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(StC_MiscVarType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'StC_PackMisc'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%F_stop)
   call RegPackAlloc(RF, InData%F_ext)
   call RegPackAlloc(RF, InData%F_fr)
   call RegPackAlloc(RF, InData%K)
   call RegPackAlloc(RF, InData%C_ctrl)
   call RegPackAlloc(RF, InData%C_Brake)
   call RegPackAlloc(RF, InData%F_table)
   call RegPackAlloc(RF, InData%F_k)
   call RegPackAlloc(RF, InData%a_G)
   call RegPackAlloc(RF, InData%rdisp_P)
   call RegPackAlloc(RF, InData%rdot_P)
   call RegPackAlloc(RF, InData%rddot_P)
   call RegPackAlloc(RF, InData%omega_P)
   call RegPackAlloc(RF, InData%alpha_P)
   call RegPackAlloc(RF, InData%F_P)
   call RegPackAlloc(RF, InData%M_P)
   call RegPackAlloc(RF, InData%Acc)
   call RegPack(RF, InData%PrescribedInterpIdx)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine StC_UnPackMisc(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(StC_MiscVarType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'StC_UnPackMisc'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%F_stop); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%F_ext); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%F_fr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%K); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%C_ctrl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%C_Brake); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%F_table); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%F_k); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%a_G); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%rdisp_P); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%rdot_P); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%rddot_P); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%omega_P); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%alpha_P); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%F_P); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%M_P); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Acc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PrescribedInterpIdx); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine StC_CopyParam(SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg)
   type(StC_ParameterType), intent(in) :: SrcParamData
   type(StC_ParameterType), intent(inout) :: DstParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'StC_CopyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstParamData%DT = SrcParamData%DT
   DstParamData%RootName = SrcParamData%RootName
   DstParamData%StC_DOF_MODE = SrcParamData%StC_DOF_MODE
   DstParamData%StC_X_DOF = SrcParamData%StC_X_DOF
   DstParamData%StC_Y_DOF = SrcParamData%StC_Y_DOF
   DstParamData%StC_Z_DOF = SrcParamData%StC_Z_DOF
   DstParamData%StC_Z_PreLd = SrcParamData%StC_Z_PreLd
   DstParamData%M_X = SrcParamData%M_X
   DstParamData%M_Y = SrcParamData%M_Y
   DstParamData%M_Z = SrcParamData%M_Z
   DstParamData%M_XY = SrcParamData%M_XY
   DstParamData%K_X = SrcParamData%K_X
   DstParamData%K_Y = SrcParamData%K_Y
   DstParamData%K_Z = SrcParamData%K_Z
   DstParamData%C_X = SrcParamData%C_X
   DstParamData%C_Y = SrcParamData%C_Y
   DstParamData%C_Z = SrcParamData%C_Z
   DstParamData%K_S = SrcParamData%K_S
   DstParamData%C_S = SrcParamData%C_S
   DstParamData%P_SP = SrcParamData%P_SP
   DstParamData%N_SP = SrcParamData%N_SP
   DstParamData%Gravity = SrcParamData%Gravity
   DstParamData%StC_CMODE = SrcParamData%StC_CMODE
   DstParamData%StC_SA_MODE = SrcParamData%StC_SA_MODE
   DstParamData%StC_X_C_HIGH = SrcParamData%StC_X_C_HIGH
   DstParamData%StC_X_C_LOW = SrcParamData%StC_X_C_LOW
   DstParamData%StC_Y_C_HIGH = SrcParamData%StC_Y_C_HIGH
   DstParamData%StC_Y_C_LOW = SrcParamData%StC_Y_C_LOW
   DstParamData%StC_Z_C_HIGH = SrcParamData%StC_Z_C_HIGH
   DstParamData%StC_Z_C_LOW = SrcParamData%StC_Z_C_LOW
   DstParamData%StC_X_C_BRAKE = SrcParamData%StC_X_C_BRAKE
   DstParamData%StC_Y_C_BRAKE = SrcParamData%StC_Y_C_BRAKE
   DstParamData%StC_Z_C_BRAKE = SrcParamData%StC_Z_C_BRAKE
   DstParamData%L_X = SrcParamData%L_X
   DstParamData%B_X = SrcParamData%B_X
   DstParamData%area_X = SrcParamData%area_X
   DstParamData%area_ratio_X = SrcParamData%area_ratio_X
   DstParamData%headLossCoeff_X = SrcParamData%headLossCoeff_X
   DstParamData%rho_X = SrcParamData%rho_X
   DstParamData%L_Y = SrcParamData%L_Y
   DstParamData%B_Y = SrcParamData%B_Y
   DstParamData%area_Y = SrcParamData%area_Y
   DstParamData%area_ratio_Y = SrcParamData%area_ratio_Y
   DstParamData%headLossCoeff_Y = SrcParamData%headLossCoeff_Y
   DstParamData%rho_Y = SrcParamData%rho_Y
   DstParamData%Use_F_TBL = SrcParamData%Use_F_TBL
   if (allocated(SrcParamData%F_TBL)) then
      LB(1:2) = lbound(SrcParamData%F_TBL)
      UB(1:2) = ubound(SrcParamData%F_TBL)
      if (.not. allocated(DstParamData%F_TBL)) then
         allocate(DstParamData%F_TBL(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%F_TBL.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%F_TBL = SrcParamData%F_TBL
   end if
   DstParamData%NumMeshPts = SrcParamData%NumMeshPts
   DstParamData%PrescribedForcesCoordSys = SrcParamData%PrescribedForcesCoordSys
   if (allocated(SrcParamData%StC_PrescribedForce)) then
      LB(1:2) = lbound(SrcParamData%StC_PrescribedForce)
      UB(1:2) = ubound(SrcParamData%StC_PrescribedForce)
      if (.not. allocated(DstParamData%StC_PrescribedForce)) then
         allocate(DstParamData%StC_PrescribedForce(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%StC_PrescribedForce.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%StC_PrescribedForce = SrcParamData%StC_PrescribedForce
   end if
   if (allocated(SrcParamData%StC_CChan)) then
      LB(1:1) = lbound(SrcParamData%StC_CChan)
      UB(1:1) = ubound(SrcParamData%StC_CChan)
      if (.not. allocated(DstParamData%StC_CChan)) then
         allocate(DstParamData%StC_CChan(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%StC_CChan.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%StC_CChan = SrcParamData%StC_CChan
   end if
end subroutine

subroutine StC_DestroyParam(ParamData, ErrStat, ErrMsg)
   type(StC_ParameterType), intent(inout) :: ParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'StC_DestroyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ParamData%F_TBL)) then
      deallocate(ParamData%F_TBL)
   end if
   if (allocated(ParamData%StC_PrescribedForce)) then
      deallocate(ParamData%StC_PrescribedForce)
   end if
   if (allocated(ParamData%StC_CChan)) then
      deallocate(ParamData%StC_CChan)
   end if
end subroutine

subroutine StC_PackParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(StC_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'StC_PackParam'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DT)
   call RegPack(RF, InData%RootName)
   call RegPack(RF, InData%StC_DOF_MODE)
   call RegPack(RF, InData%StC_X_DOF)
   call RegPack(RF, InData%StC_Y_DOF)
   call RegPack(RF, InData%StC_Z_DOF)
   call RegPack(RF, InData%StC_Z_PreLd)
   call RegPack(RF, InData%M_X)
   call RegPack(RF, InData%M_Y)
   call RegPack(RF, InData%M_Z)
   call RegPack(RF, InData%M_XY)
   call RegPack(RF, InData%K_X)
   call RegPack(RF, InData%K_Y)
   call RegPack(RF, InData%K_Z)
   call RegPack(RF, InData%C_X)
   call RegPack(RF, InData%C_Y)
   call RegPack(RF, InData%C_Z)
   call RegPack(RF, InData%K_S)
   call RegPack(RF, InData%C_S)
   call RegPack(RF, InData%P_SP)
   call RegPack(RF, InData%N_SP)
   call RegPack(RF, InData%Gravity)
   call RegPack(RF, InData%StC_CMODE)
   call RegPack(RF, InData%StC_SA_MODE)
   call RegPack(RF, InData%StC_X_C_HIGH)
   call RegPack(RF, InData%StC_X_C_LOW)
   call RegPack(RF, InData%StC_Y_C_HIGH)
   call RegPack(RF, InData%StC_Y_C_LOW)
   call RegPack(RF, InData%StC_Z_C_HIGH)
   call RegPack(RF, InData%StC_Z_C_LOW)
   call RegPack(RF, InData%StC_X_C_BRAKE)
   call RegPack(RF, InData%StC_Y_C_BRAKE)
   call RegPack(RF, InData%StC_Z_C_BRAKE)
   call RegPack(RF, InData%L_X)
   call RegPack(RF, InData%B_X)
   call RegPack(RF, InData%area_X)
   call RegPack(RF, InData%area_ratio_X)
   call RegPack(RF, InData%headLossCoeff_X)
   call RegPack(RF, InData%rho_X)
   call RegPack(RF, InData%L_Y)
   call RegPack(RF, InData%B_Y)
   call RegPack(RF, InData%area_Y)
   call RegPack(RF, InData%area_ratio_Y)
   call RegPack(RF, InData%headLossCoeff_Y)
   call RegPack(RF, InData%rho_Y)
   call RegPack(RF, InData%Use_F_TBL)
   call RegPackAlloc(RF, InData%F_TBL)
   call RegPack(RF, InData%NumMeshPts)
   call RegPack(RF, InData%PrescribedForcesCoordSys)
   call RegPackAlloc(RF, InData%StC_PrescribedForce)
   call RegPackAlloc(RF, InData%StC_CChan)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine StC_UnPackParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(StC_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'StC_UnPackParam'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_DOF_MODE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_X_DOF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_Y_DOF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_Z_DOF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_Z_PreLd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%M_X); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%M_Y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%M_Z); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%M_XY); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%K_X); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%K_Y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%K_Z); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_X); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_Y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_Z); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%K_S); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_S); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%P_SP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%N_SP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Gravity); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_CMODE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_SA_MODE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_X_C_HIGH); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_X_C_LOW); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_Y_C_HIGH); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_Y_C_LOW); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_Z_C_HIGH); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_Z_C_LOW); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_X_C_BRAKE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_Y_C_BRAKE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StC_Z_C_BRAKE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%L_X); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%B_X); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%area_X); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%area_ratio_X); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%headLossCoeff_X); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rho_X); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%L_Y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%B_Y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%area_Y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%area_ratio_Y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%headLossCoeff_Y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rho_Y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Use_F_TBL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%F_TBL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumMeshPts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PrescribedForcesCoordSys); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%StC_PrescribedForce); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%StC_CChan); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine StC_CopyInput(SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg)
   type(StC_InputType), intent(inout) :: SrcInputData
   type(StC_InputType), intent(inout) :: DstInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'StC_CopyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcInputData%Mesh)) then
      LB(1:1) = lbound(SrcInputData%Mesh)
      UB(1:1) = ubound(SrcInputData%Mesh)
      if (.not. allocated(DstInputData%Mesh)) then
         allocate(DstInputData%Mesh(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%Mesh.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcInputData%Mesh(i1), DstInputData%Mesh(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcInputData%CmdStiff)) then
      LB(1:2) = lbound(SrcInputData%CmdStiff)
      UB(1:2) = ubound(SrcInputData%CmdStiff)
      if (.not. allocated(DstInputData%CmdStiff)) then
         allocate(DstInputData%CmdStiff(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%CmdStiff.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%CmdStiff = SrcInputData%CmdStiff
   end if
   if (allocated(SrcInputData%CmdDamp)) then
      LB(1:2) = lbound(SrcInputData%CmdDamp)
      UB(1:2) = ubound(SrcInputData%CmdDamp)
      if (.not. allocated(DstInputData%CmdDamp)) then
         allocate(DstInputData%CmdDamp(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%CmdDamp.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%CmdDamp = SrcInputData%CmdDamp
   end if
   if (allocated(SrcInputData%CmdBrake)) then
      LB(1:2) = lbound(SrcInputData%CmdBrake)
      UB(1:2) = ubound(SrcInputData%CmdBrake)
      if (.not. allocated(DstInputData%CmdBrake)) then
         allocate(DstInputData%CmdBrake(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%CmdBrake.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%CmdBrake = SrcInputData%CmdBrake
   end if
   if (allocated(SrcInputData%CmdForce)) then
      LB(1:2) = lbound(SrcInputData%CmdForce)
      UB(1:2) = ubound(SrcInputData%CmdForce)
      if (.not. allocated(DstInputData%CmdForce)) then
         allocate(DstInputData%CmdForce(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%CmdForce.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%CmdForce = SrcInputData%CmdForce
   end if
end subroutine

subroutine StC_DestroyInput(InputData, ErrStat, ErrMsg)
   type(StC_InputType), intent(inout) :: InputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'StC_DestroyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InputData%Mesh)) then
      LB(1:1) = lbound(InputData%Mesh)
      UB(1:1) = ubound(InputData%Mesh)
      do i1 = LB(1), UB(1)
         call MeshDestroy( InputData%Mesh(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InputData%Mesh)
   end if
   if (allocated(InputData%CmdStiff)) then
      deallocate(InputData%CmdStiff)
   end if
   if (allocated(InputData%CmdDamp)) then
      deallocate(InputData%CmdDamp)
   end if
   if (allocated(InputData%CmdBrake)) then
      deallocate(InputData%CmdBrake)
   end if
   if (allocated(InputData%CmdForce)) then
      deallocate(InputData%CmdForce)
   end if
end subroutine

subroutine StC_PackInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(StC_InputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'StC_PackInput'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%Mesh))
   if (allocated(InData%Mesh)) then
      call RegPackBounds(RF, 1, lbound(InData%Mesh), ubound(InData%Mesh))
      LB(1:1) = lbound(InData%Mesh)
      UB(1:1) = ubound(InData%Mesh)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%Mesh(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%CmdStiff)
   call RegPackAlloc(RF, InData%CmdDamp)
   call RegPackAlloc(RF, InData%CmdBrake)
   call RegPackAlloc(RF, InData%CmdForce)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine StC_UnPackInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(StC_InputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'StC_UnPackInput'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%Mesh)) deallocate(OutData%Mesh)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Mesh(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Mesh.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%Mesh(i1)) ! Mesh 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%CmdStiff); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%CmdDamp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%CmdBrake); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%CmdForce); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine StC_CopyOutput(SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg)
   type(StC_OutputType), intent(inout) :: SrcOutputData
   type(StC_OutputType), intent(inout) :: DstOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'StC_CopyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcOutputData%Mesh)) then
      LB(1:1) = lbound(SrcOutputData%Mesh)
      UB(1:1) = ubound(SrcOutputData%Mesh)
      if (.not. allocated(DstOutputData%Mesh)) then
         allocate(DstOutputData%Mesh(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%Mesh.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcOutputData%Mesh(i1), DstOutputData%Mesh(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcOutputData%MeasDisp)) then
      LB(1:2) = lbound(SrcOutputData%MeasDisp)
      UB(1:2) = ubound(SrcOutputData%MeasDisp)
      if (.not. allocated(DstOutputData%MeasDisp)) then
         allocate(DstOutputData%MeasDisp(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%MeasDisp.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%MeasDisp = SrcOutputData%MeasDisp
   end if
   if (allocated(SrcOutputData%MeasVel)) then
      LB(1:2) = lbound(SrcOutputData%MeasVel)
      UB(1:2) = ubound(SrcOutputData%MeasVel)
      if (.not. allocated(DstOutputData%MeasVel)) then
         allocate(DstOutputData%MeasVel(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%MeasVel.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%MeasVel = SrcOutputData%MeasVel
   end if
end subroutine

subroutine StC_DestroyOutput(OutputData, ErrStat, ErrMsg)
   type(StC_OutputType), intent(inout) :: OutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'StC_DestroyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(OutputData%Mesh)) then
      LB(1:1) = lbound(OutputData%Mesh)
      UB(1:1) = ubound(OutputData%Mesh)
      do i1 = LB(1), UB(1)
         call MeshDestroy( OutputData%Mesh(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(OutputData%Mesh)
   end if
   if (allocated(OutputData%MeasDisp)) then
      deallocate(OutputData%MeasDisp)
   end if
   if (allocated(OutputData%MeasVel)) then
      deallocate(OutputData%MeasVel)
   end if
end subroutine

subroutine StC_PackOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(StC_OutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'StC_PackOutput'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%Mesh))
   if (allocated(InData%Mesh)) then
      call RegPackBounds(RF, 1, lbound(InData%Mesh), ubound(InData%Mesh))
      LB(1:1) = lbound(InData%Mesh)
      UB(1:1) = ubound(InData%Mesh)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%Mesh(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%MeasDisp)
   call RegPackAlloc(RF, InData%MeasVel)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine StC_UnPackOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(StC_OutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'StC_UnPackOutput'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%Mesh)) deallocate(OutData%Mesh)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Mesh(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Mesh.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%Mesh(i1)) ! Mesh 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%MeasDisp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%MeasVel); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine StC_Input_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
   ! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(StC_InputType), intent(inout)  :: u(:) ! Input at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Inputs
   type(StC_InputType), intent(inout)  :: u_out ! Input at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'StC_Input_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(u)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(u)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(u) - 1
   select case (order)
   case (0)
      call StC_CopyInput(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call StC_Input_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call StC_Input_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(u) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE StC_Input_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

   TYPE(StC_InputType), INTENT(INOUT)  :: u1    ! Input at t1 > t2
   TYPE(StC_InputType), INTENT(INOUT)  :: u2    ! Input at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Inputs
   TYPE(StC_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'StC_Input_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i02      ! dim2 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   INTEGER                                    :: i2       ! dim2 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   IF (ALLOCATED(u_out%Mesh) .AND. ALLOCATED(u1%Mesh)) THEN
      do i1 = lbound(u_out%Mesh,1),ubound(u_out%Mesh,1)
         CALL MeshExtrapInterp1(u1%Mesh(i1), u2%Mesh(i1), tin, u_out%Mesh(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(u_out%CmdStiff) .AND. ALLOCATED(u1%CmdStiff)) THEN
      u_out%CmdStiff = a1*u1%CmdStiff + a2*u2%CmdStiff
   END IF ! check if allocated
   IF (ALLOCATED(u_out%CmdDamp) .AND. ALLOCATED(u1%CmdDamp)) THEN
      u_out%CmdDamp = a1*u1%CmdDamp + a2*u2%CmdDamp
   END IF ! check if allocated
   IF (ALLOCATED(u_out%CmdBrake) .AND. ALLOCATED(u1%CmdBrake)) THEN
      u_out%CmdBrake = a1*u1%CmdBrake + a2*u2%CmdBrake
   END IF ! check if allocated
   IF (ALLOCATED(u_out%CmdForce) .AND. ALLOCATED(u1%CmdForce)) THEN
      u_out%CmdForce = a1*u1%CmdForce + a2*u2%CmdForce
   END IF ! check if allocated
END SUBROUTINE

SUBROUTINE StC_Input_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

   TYPE(StC_InputType), INTENT(INOUT)  :: u1      ! Input at t1 > t2 > t3
   TYPE(StC_InputType), INTENT(INOUT)  :: u2      ! Input at t2 > t3
   TYPE(StC_InputType), INTENT(INOUT)  :: u3      ! Input at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Inputs
   TYPE(StC_InputType), INTENT(INOUT)  :: u_out     ! Input at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'StC_Input_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i02    ! dim2 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   INTEGER                                    :: i2    ! dim2 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   IF (ALLOCATED(u_out%Mesh) .AND. ALLOCATED(u1%Mesh)) THEN
      do i1 = lbound(u_out%Mesh,1),ubound(u_out%Mesh,1)
         CALL MeshExtrapInterp2(u1%Mesh(i1), u2%Mesh(i1), u3%Mesh(i1), tin, u_out%Mesh(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(u_out%CmdStiff) .AND. ALLOCATED(u1%CmdStiff)) THEN
      u_out%CmdStiff = a1*u1%CmdStiff + a2*u2%CmdStiff + a3*u3%CmdStiff
   END IF ! check if allocated
   IF (ALLOCATED(u_out%CmdDamp) .AND. ALLOCATED(u1%CmdDamp)) THEN
      u_out%CmdDamp = a1*u1%CmdDamp + a2*u2%CmdDamp + a3*u3%CmdDamp
   END IF ! check if allocated
   IF (ALLOCATED(u_out%CmdBrake) .AND. ALLOCATED(u1%CmdBrake)) THEN
      u_out%CmdBrake = a1*u1%CmdBrake + a2*u2%CmdBrake + a3*u3%CmdBrake
   END IF ! check if allocated
   IF (ALLOCATED(u_out%CmdForce) .AND. ALLOCATED(u1%CmdForce)) THEN
      u_out%CmdForce = a1*u1%CmdForce + a2*u2%CmdForce + a3*u3%CmdForce
   END IF ! check if allocated
END SUBROUTINE

subroutine StC_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
   ! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(StC_OutputType), intent(inout)  :: y(:) ! Output at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Outputs
   type(StC_OutputType), intent(inout)  :: y_out ! Output at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'StC_Output_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(y)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(y)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(y) - 1
   select case (order)
   case (0)
      call StC_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call StC_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call StC_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(y) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE StC_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

   TYPE(StC_OutputType), INTENT(INOUT)  :: y1    ! Output at t1 > t2
   TYPE(StC_OutputType), INTENT(INOUT)  :: y2    ! Output at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
   TYPE(StC_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'StC_Output_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i02      ! dim2 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   INTEGER                                    :: i2       ! dim2 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   IF (ALLOCATED(y_out%Mesh) .AND. ALLOCATED(y1%Mesh)) THEN
      do i1 = lbound(y_out%Mesh,1),ubound(y_out%Mesh,1)
         CALL MeshExtrapInterp1(y1%Mesh(i1), y2%Mesh(i1), tin, y_out%Mesh(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(y_out%MeasDisp) .AND. ALLOCATED(y1%MeasDisp)) THEN
      y_out%MeasDisp = a1*y1%MeasDisp + a2*y2%MeasDisp
   END IF ! check if allocated
   IF (ALLOCATED(y_out%MeasVel) .AND. ALLOCATED(y1%MeasVel)) THEN
      y_out%MeasVel = a1*y1%MeasVel + a2*y2%MeasVel
   END IF ! check if allocated
END SUBROUTINE

SUBROUTINE StC_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

   TYPE(StC_OutputType), INTENT(INOUT)  :: y1      ! Output at t1 > t2 > t3
   TYPE(StC_OutputType), INTENT(INOUT)  :: y2      ! Output at t2 > t3
   TYPE(StC_OutputType), INTENT(INOUT)  :: y3      ! Output at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
   TYPE(StC_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'StC_Output_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i02    ! dim2 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   INTEGER                                    :: i2    ! dim2 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   IF (ALLOCATED(y_out%Mesh) .AND. ALLOCATED(y1%Mesh)) THEN
      do i1 = lbound(y_out%Mesh,1),ubound(y_out%Mesh,1)
         CALL MeshExtrapInterp2(y1%Mesh(i1), y2%Mesh(i1), y3%Mesh(i1), tin, y_out%Mesh(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(y_out%MeasDisp) .AND. ALLOCATED(y1%MeasDisp)) THEN
      y_out%MeasDisp = a1*y1%MeasDisp + a2*y2%MeasDisp + a3*y3%MeasDisp
   END IF ! check if allocated
   IF (ALLOCATED(y_out%MeasVel) .AND. ALLOCATED(y1%MeasVel)) THEN
      y_out%MeasVel = a1*y1%MeasVel + a2*y2%MeasVel + a3*y3%MeasVel
   END IF ! check if allocated
END SUBROUTINE
END MODULE StrucCtrl_Types
!ENDOFREGISTRYGENERATEDFILE
