!STARTOFREGISTRYGENERATEDFILE 'ServoDyn_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! ServoDyn_Types
!.................................................................................................................................
! This file is part of ServoDyn.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in ServoDyn. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE ServoDyn_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE StrucCtrl_Types
USE NWTC_Library
IMPLICIT NONE
! =========  SrvD_InitInputType  =======
  TYPE, PUBLIC :: SrvD_InitInputType
    CHARACTER(1024)  :: InputFile      !< Name of the input file [-]
    LOGICAL  :: Linearize = .FALSE.      !< Flag that tells this module if the glue code wants to linearize. [-]
    INTEGER(IntKi)  :: NumBl = 0_IntKi      !< Number of blades on the turbine [-]
    CHARACTER(1024)  :: RootName      !< RootName for writing output files [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BlPitchInit      !< Initial blade pitch [-]
    REAL(ReKi) , DIMENSION(1:3)  :: Gravity = 0.0_ReKi      !< Gravitational acceleration vector [m/s^2]
    REAL(ReKi) , DIMENSION(1:3)  :: NacRefPos = 0.0_ReKi      !< nacelle origin for setting up mesh [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: NacTransDisp = 0.0_R8Ki      !< nacelle displacement from origin at init for setting up mesh [m]
    REAL(R8Ki) , DIMENSION(1:3,1:3)  :: NacOrient = 0.0_R8Ki      !< nacelle orientation for setting up mesh [-]
    REAL(R8Ki) , DIMENSION(1:3,1:3)  :: NacRefOrient = 0.0_R8Ki      !< nacelle reference orientation for setting up mesh [-]
    REAL(ReKi) , DIMENSION(1:3)  :: TwrBaseRefPos = 0.0_ReKi      !< tower base origin for setting up mesh [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: TwrBaseTransDisp = 0.0_R8Ki      !< tower base translation from origin at init for setting up mesh [m]
    REAL(R8Ki) , DIMENSION(1:3,1:3)  :: TwrBaseOrient = 0.0_R8Ki      !< tower base orientation for setting up mesh [m]
    REAL(R8Ki) , DIMENSION(1:3,1:3)  :: TwrBaseRefOrient = 0.0_R8Ki      !< tower reference orientation for setting up mesh [m]
    REAL(ReKi) , DIMENSION(1:3)  :: PtfmRefPos = 0.0_ReKi      !< platform origin for setting up mesh [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: PtfmTransDisp = 0.0_R8Ki      !< platform displacement from origin for setting up mesh [m]
    REAL(R8Ki) , DIMENSION(1:3,1:3)  :: PtfmOrient = 0.0_R8Ki      !< platform orientation for setting up mesh [m]
    REAL(R8Ki) , DIMENSION(1:3,1:3)  :: PtfmRefOrient = 0.0_R8Ki      !< platform reference orientation for setting up mesh [m]
    REAL(DbKi)  :: Tmax = 0.0_R8Ki      !< max time from glue code [s]
    REAL(ReKi)  :: AvgWindSpeed = 0.0_ReKi      !< average wind speed for the simulation [m/s]
    REAL(ReKi)  :: AirDens = 0.0_ReKi      !< air density [kg/m^3]
    INTEGER(IntKi)  :: TrimCase = 0_IntKi      !< Controller parameter to be trimmed {1:yaw; 2:torque; 3:pitch} [used only if CalcSteady=True] [-]
    REAL(ReKi)  :: TrimGain = 0.0_ReKi      !< Proportional gain for the rotational speed error (>0) [used only if TrimCase>0] [rad/(rad/s) for yaw or pitch; Nm/(rad/s) for torque]
    REAL(ReKi)  :: RotSpeedRef = 0.0_ReKi      !< Reference rotor speed [rad/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: BladeRootRefPos      !< X-Y-Z reference position of each blade root (3 x NumBlades) [m]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: BladeRootTransDisp      !< X-Y-Z translation from reference position at init of each blade root (3 x NumBlades) [m]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: BladeRootOrient      !< DCM reference orientation of blade roots (3x3 x NumBlades) [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: BladeRootRefOrient      !< DCM reference orientation of blade roots (3x3 x NumBlades) [-]
    LOGICAL  :: UseInputFile = .TRUE.      !< read input from input file [-]
    TYPE(FileInfoType)  :: PassedPrimaryInputData      !< Primary input file as FileInfoType (set by driver/glue code) [-]
    INTEGER(IntKi)  :: NumCableControl = 0_IntKi      !< Number of cable control channels requested [-]
    CHARACTER(64) , DIMENSION(:), ALLOCATABLE  :: CableControlRequestor      !< Array with text info about which module requested the cable control channel (size of NumCableControl).  This is just for diagnostics. [-]
    INTEGER(IntKi)  :: InterpOrder = 0_IntKi      !< Interpolation order from glue code -- required to set m%u_xStC sizes [-]
    INTEGER(IntKi)  :: SensorType = 0_IntKi      !< Lidar sensor type [-]
    INTEGER(IntKi)  :: NumBeam = 0_IntKi      !< Number of beams [-]
    INTEGER(IntKi)  :: NumPulseGate = 0_IntKi      !< Number of pulse gates [-]
  END TYPE SrvD_InitInputType
! =======================
! =========  SrvD_InitOutputType  =======
  TYPE, PUBLIC :: SrvD_InitOutputType
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputHdr      !< Names of the output-to-file channels [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputUnt      !< Units of the output-to-file channels [-]
    TYPE(ProgDesc)  :: Ver      !< This module's name, version, and date [-]
    INTEGER(IntKi)  :: CouplingScheme = 0_IntKi      !< Switch that indicates if a particular coupling scheme is required [-]
    LOGICAL  :: UseHSSBrake = .false.      !< flag to determine if high-speed shaft brake is potentially used (true=yes) [-]
    CHARACTER(LinChanLen) , DIMENSION(:), ALLOCATABLE  :: LinNames_y      !< Names of the outputs used in linearization [-]
    CHARACTER(LinChanLen) , DIMENSION(:), ALLOCATABLE  :: LinNames_x      !< Names of the states used in linearization [-]
    CHARACTER(LinChanLen) , DIMENSION(:), ALLOCATABLE  :: LinNames_u      !< Names of the inputs used in linearization [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: RotFrame_y      !< Flag that tells FAST/MBC3 if the outputs used in linearization are in the rotating frame [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: RotFrame_x      !< Flag that tells FAST/MBC3 if the inputs used in linearization are in the rotating frame [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: RotFrame_u      !< Flag that tells FAST/MBC3 if the inputs used in linearization are in the rotating frame [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: IsLoad_u      !< Flag that tells FAST if the inputs used in linearization are loads (for preconditioning matrix) [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: DerivOrder_x      !< Integer that tells FAST/MBC3 the maximum derivative order of continuous states used in linearization [-]
  END TYPE SrvD_InitOutputType
! =======================
! =========  SrvD_InputFile  =======
  TYPE, PUBLIC :: SrvD_InputFile
    REAL(DbKi)  :: DT = 0.0_R8Ki      !< Communication interval for controllers [s]
    LOGICAL  :: Echo = .false.      !< Echo the input file out [-]
    INTEGER(IntKi)  :: PCMode = 0_IntKi      !< Pitch control mode [-]
    REAL(DbKi)  :: TPCOn = 0.0_R8Ki      !< Time to enable active pitch control [unused when PCMode=0] [s]
    REAL(DbKi) , DIMENSION(1:3)  :: TPitManS = 0.0_R8Ki      !< Time to start override pitch maneuver for blade (K) and end standard pitch control [s]
    REAL(ReKi) , DIMENSION(1:3)  :: PitManRat = 0.0_ReKi      !< Pitch rates at which override pitch maneuvers head toward final pitch angles [rad/s]
    REAL(ReKi) , DIMENSION(1:3)  :: BlPitchF = 0.0_ReKi      !< Blade (K) final pitch for pitch maneuvers [radians]
    INTEGER(IntKi)  :: VSContrl = 0_IntKi      !< Variable-speed control mode [-]
    INTEGER(IntKi)  :: GenModel = 0_IntKi      !< Generator model [used only when VSContrl=0] [-]
    REAL(ReKi)  :: GenEff = 0.0_ReKi      !< Generator efficiency [ignored by the Thevenin and user-defined generator models] [-]
    LOGICAL  :: GenTiStr = .false.      !< Method to start the generator {T: timed using TimGenOn, F: generator speed using SpdGenOn} [-]
    LOGICAL  :: GenTiStp = .false.      !< Method to stop the generator {T: timed using TimGenOf, F: when generator power = 0} [-]
    REAL(ReKi)  :: SpdGenOn = 0.0_ReKi      !< Generator speed to turn on the generator for a startup (HSS speed) [used only when GenTiStr=False] [rad/s]
    REAL(DbKi)  :: TimGenOn = 0.0_R8Ki      !< Time to turn on the generator for a startup [used only when GenTiStr=True] [s]
    REAL(DbKi)  :: TimGenOf = 0.0_R8Ki      !< Time to turn off the generator [used only when GenTiStp=True] [s]
    REAL(ReKi)  :: VS_RtGnSp = 0.0_ReKi      !< Rated generator speed for simple variable-speed generator control (HSS side) [used only when VSContrl=1] [rad/s]
    REAL(ReKi)  :: VS_RtTq = 0.0_ReKi      !< Rated generator torque/constant generator torque in Region 3 for simple variable-speed generator control (HSS side) [used only when VSContrl=1] [N-m]
    REAL(ReKi)  :: VS_Rgn2K = 0.0_ReKi      !< Generator torque constant in Region 2 for simple variable-speed generator control (HSS side) [used only when VSContrl=1] [N-m/(rad/s)^2]
    REAL(ReKi)  :: VS_SlPc = 0.0_ReKi      !< Rated generator slip percentage in Region 2 1/2 for simple variable-speed generator control [used only when VSContrl=1] [-]
    REAL(ReKi)  :: SIG_SlPc = 0.0_ReKi      !< Rated generator slip percentage [used only when VSContrl=0 and GenModel=1] [-]
    REAL(ReKi)  :: SIG_SySp = 0.0_ReKi      !< Synchronous (zero-torque) generator speed [used only when VSContrl=0 and GenModel=1] [rad/s]
    REAL(ReKi)  :: SIG_RtTq = 0.0_ReKi      !< Rated torque [used only when VSContrl=0 and GenModel=1] [N-m]
    REAL(ReKi)  :: SIG_PORt = 0.0_ReKi      !< Pull-out ratio (Tpullout/Trated) [used only when VSContrl=0 and GenModel=1] [-]
    REAL(ReKi)  :: TEC_Freq = 0.0_ReKi      !< Line frequency [50 or 60] [used only when VSContrl=0 and GenModel=2] [Hz]
    INTEGER(IntKi)  :: TEC_NPol = 0_IntKi      !< Number of poles [even integer > 0] [used only when VSContrl=0 and GenModel=2] [-]
    REAL(ReKi)  :: TEC_SRes = 0.0_ReKi      !< Stator resistance [used only when VSContrl=0 and GenModel=2] [ohms]
    REAL(ReKi)  :: TEC_RRes = 0.0_ReKi      !< Rotor resistance [used only when VSContrl=0 and GenModel=2] [ohms]
    REAL(ReKi)  :: TEC_VLL = 0.0_ReKi      !< Line-to-line RMS voltage [used only when VSContrl=0 and GenModel=2] [volts]
    REAL(ReKi)  :: TEC_SLR = 0.0_ReKi      !< Stator leakage reactance [used only when VSContrl=0 and GenModel=2] [ohms]
    REAL(ReKi)  :: TEC_RLR = 0.0_ReKi      !< Rotor leakage reactance [used only when VSContrl=0 and GenModel=2] [ohms]
    REAL(ReKi)  :: TEC_MR = 0.0_ReKi      !< Magnetizing reactance [used only when VSContrl=0 and GenModel=2] [ohms]
    INTEGER(IntKi)  :: HSSBrMode = 0_IntKi      !< HSS brake model [-]
    REAL(DbKi)  :: THSSBrDp = 0.0_R8Ki      !< Time to initiate deployment of the HSS brake [s]
    REAL(DbKi)  :: HSSBrDT = 0.0_R8Ki      !< Time for HSS-brake to reach full deployment once initiated [used only when HSSBrMode=1] [s]
    REAL(ReKi)  :: HSSBrTqF = 0.0_ReKi      !< Fully deployed HSS-brake torque [N-m]
    INTEGER(IntKi)  :: YCMode = 0_IntKi      !< Yaw control mode [-]
    REAL(DbKi)  :: TYCOn = 0.0_R8Ki      !< Time to enable active yaw control [unused when YCMode=0] [s]
    REAL(ReKi)  :: YawNeut = 0.0_ReKi      !< Neutral yaw position--yaw spring force is zero at this yaw [radians]
    REAL(ReKi)  :: YawSpr = 0.0_ReKi      !< Nacelle-yaw spring constant [N-m/rad]
    REAL(ReKi)  :: YawDamp = 0.0_ReKi      !< Nacelle-yaw constant [N-m/(rad/s)]
    REAL(DbKi)  :: TYawManS = 0.0_R8Ki      !< Time to start override yaw maneuver and end standard yaw control [s]
    REAL(ReKi)  :: YawManRat = 0.0_ReKi      !< Yaw maneuver rate (in absolute value) [rad/s]
    REAL(ReKi)  :: NacYawF = 0.0_ReKi      !< Final yaw angle for override yaw maneuvers [radians]
    LOGICAL  :: SumPrint = .false.      !< Print summary data to <RootName>.sum [-]
    INTEGER(IntKi)  :: OutFile = 0_IntKi      !< Switch to determine where output will be placed: (1: in module output file only; 2: in glue code output file only; 3: both) [-]
    LOGICAL  :: TabDelim = .false.      !< Use tab delimiters in text tabular output file? [-]
    CHARACTER(20)  :: OutFmt      !< Format used for text tabular output (except time) [-]
    REAL(DbKi)  :: Tstart = 0.0_R8Ki      !< Time to start module's tabular output [s]
    INTEGER(IntKi)  :: NumOuts = 0_IntKi      !< Number of parameters in the output list (number of outputs requested) [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: OutList      !< List of user-requested output channels [-]
    CHARACTER(1024)  :: DLL_FileName      !< Name of the DLL file including the full path [-]
    CHARACTER(1024)  :: DLL_ProcName      !< Name of the procedure in the DLL that will be called [-]
    CHARACTER(1024)  :: DLL_InFile      !< Name of input file used in DLL [-]
    REAL(DbKi)  :: DLL_DT = 0.0_R8Ki      !< interval for calling DLL (must be integer multiple number of DT steps) [s]
    LOGICAL  :: DLL_Ramp = .false.      !< whether the DLL pitch should be a ramp (true) or step change (false) when DLL_DT <> DT. If true, introduces a time delay. [-]
    REAL(ReKi)  :: BPCutoff = 0.0_ReKi      !< The cutoff frequency for the blade pitch low-pass filter. Large values => no filter. [Hz]
    REAL(ReKi)  :: NacYaw_North = 0.0_ReKi      !< Reference yaw angle of the nacelle when the upwind end points due North [used only with DLL Interface] [radians]
    INTEGER(IntKi)  :: Ptch_Cntrl = 0_IntKi      !< Record 28: Use individual pitch control {0: collective pitch; 1: individual pitch control} [used only with DLL Interface] [-]
    REAL(ReKi)  :: Ptch_SetPnt = 0.0_ReKi      !< Record  5: Below-rated pitch angle set-point [used only with DLL Interface] [radians]
    REAL(ReKi)  :: Ptch_Min = 0.0_ReKi      !< Record  6: Minimum pitch angle [used only with DLL Interface] [radians]
    REAL(ReKi)  :: Ptch_Max = 0.0_ReKi      !< Record  7: Maximum pitch angle [used only with DLL Interface] [radians]
    REAL(ReKi)  :: PtchRate_Min = 0.0_ReKi      !< Record  8: Minimum pitch rate (most negative value allowed) [used only with DLL Interface] [rad/s]
    REAL(ReKi)  :: PtchRate_Max = 0.0_ReKi      !< Record  9: Maximum pitch rate [used only with DLL Interface] [rad/s]
    REAL(ReKi)  :: Gain_OM = 0.0_ReKi      !< Record 16: Optimal mode gain [used only with DLL Interface] [Nm/(rad/s)^2]
    REAL(ReKi)  :: GenSpd_MinOM = 0.0_ReKi      !< Record 17: Minimum generator speed [used only with DLL Interface] [rad/s]
    REAL(ReKi)  :: GenSpd_MaxOM = 0.0_ReKi      !< Record 18: Optimal mode maximum speed [used only with DLL Interface] [rad/s]
    REAL(ReKi)  :: GenSpd_Dem = 0.0_ReKi      !< Record 19: Demanded generator speed above rated [used only with DLL Interface] [rad/s]
    REAL(ReKi)  :: GenTrq_Dem = 0.0_ReKi      !< Record 22: Demanded generator torque above rated [used only with DLL Interface] [Nm]
    REAL(ReKi)  :: GenPwr_Dem = 0.0_ReKi      !< Record 13: Demanded power [used only with DLL Interface] [W]
    INTEGER(IntKi)  :: DLL_NumTrq = 0_IntKi      !< Record 26: No. of points in torque-speed look-up table {0 = none and use the optimal mode PARAMETERs instead, nonzero = ignore the optimal mode PARAMETERs by setting Gain_OM (Record 16) to 0.0} [used only with DLL Interface] [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: GenSpd_TLU      !< Records R:2:R+2*DLL_NumTrq-2: Generator speed values in look-up table [used only with DLL Interface] [rad/s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: GenTrq_TLU      !< Records R+1:2:R+2*DLL_NumTrq-1: Generator torque values in look-up table [used only with DLL Interface] [Nm]
    LOGICAL  :: UseLegacyInterface = .false.      !< Flag that determines if the legacy Bladed interface is (legacy=DISCON with avrSWAP instead of CONTROLLER) [-]
    INTEGER(IntKi)  :: NumBStC = 0_IntKi      !< Number of blade structural controllers (integer) [-]
    CHARACTER(1024) , DIMENSION(:), ALLOCATABLE  :: BStCfiles      !< Name of the files for blade structural controllers (quoted strings) [unused when NumBStC==0] [-]
    INTEGER(IntKi)  :: NumNStC = 0_IntKi      !< Number of nacelle structural controllers (integer) [-]
    CHARACTER(1024) , DIMENSION(:), ALLOCATABLE  :: NStCfiles      !< Name of the files for nacelle structural controllers (quoted strings) [unused when NumNStC==0] [-]
    INTEGER(IntKi)  :: NumTStC = 0_IntKi      !< Number of tower structural controllers (integer) [-]
    CHARACTER(1024) , DIMENSION(:), ALLOCATABLE  :: TStCfiles      !< Name of the files for tower structural controllers (quoted strings) [unused when NumTStC==0] [-]
    INTEGER(IntKi)  :: NumSStC = 0_IntKi      !< Number of substructure structural controllers (integer) [-]
    CHARACTER(1024) , DIMENSION(:), ALLOCATABLE  :: SStCfiles      !< Name of the files for subtructure structural controllers (quoted strings) [unused when NumSStC==0] [-]
    INTEGER(IntKi)  :: AfCmode = 0_IntKi      !< Airfoil control mode {0: none, 1: sine wave cycle, 4: user-defined from Simulink/Labview, 5: user-defined from Bladed-style DLL} [-]
    REAL(ReKi)  :: AfC_Mean = 0.0_ReKi      !< Mean level for cosine cycling or steady value [used only with AfCmode==1] [-]
    REAL(ReKi)  :: AfC_Amp = 0.0_ReKi      !< Amplitude for for cosine cycling of flap signal (-) [used only with AfCmode==1] [-]
    REAL(ReKi)  :: AfC_Phase = 0.0_ReKi      !< Phase relative to the blade azimuth (0 is vertical) for for cosine cycling of flap signal (deg) [used only with AfCmode==1] [deg]
    INTEGER(IntKi)  :: CCmode = 0_IntKi      !< Cable control control mode {0: none, 4: user-defined from Simulink/Labview, 5: user-defined from Bladed-style DLL} [-]
    LOGICAL  :: EXavrSWAP = .false.      !< Use extendend AVR swap [-]
  END TYPE SrvD_InputFile
! =======================
! =========  BladedDLLType  =======
  TYPE, PUBLIC :: BladedDLLType
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: avrSWAP      !< The swap array: used to pass data to and from the DLL controller [see Bladed DLL documentation]
    REAL(ReKi)  :: HSSBrTrqDemand = 0.0_ReKi      !< Demanded braking torque - from Bladed DLL [-]
    REAL(ReKi)  :: YawRateCom = 0.0_ReKi      !< Nacelle yaw rate demanded from Bladed DLL [rad/s]
    REAL(ReKi)  :: GenTrq = 0.0_ReKi      !< Electrical generator torque from Bladed DLL [N-m]
    INTEGER(IntKi)  :: GenState = 0_IntKi      !< Generator state from Bladed DLL [-]
    REAL(ReKi) , DIMENSION(1:3)  :: BlPitchCom = 0.0_ReKi      !< Commanded blade pitch angles [radians]
    REAL(ReKi) , DIMENSION(1:3)  :: PrevBlPitch = 0.0_ReKi      !< Previously commanded blade pitch angles [radians]
    REAL(ReKi) , DIMENSION(1:3)  :: BlAirfoilCom = 0.0_ReKi      !< Commanded Airfoil UserProp for blade.  Passed to AD15 for airfoil interpolation (must be same units as given in AD15 airfoil tables) [-]
    REAL(ReKi) , DIMENSION(1:3)  :: PrevBlAirfoilCom = 0.0_ReKi      !< Previously commanded Airfoil UserProp for blade.  Passed to AD15 for airfoil interpolation (must be same units as given in AD15 airfoil tables) [-]
    REAL(ReKi)  :: ElecPwr_prev = 0.0_ReKi      !< Electrical power (from previous step), sent to Bladed DLL [W]
    REAL(ReKi)  :: GenTrq_prev = 0.0_ReKi      !< Electrical generator torque (from previous step), sent to Bladed DLL [N-m]
    LOGICAL  :: initialized = .false.      !< flag that determines if DLL has been called (for difference between CalcOutput and UpdateStates) [-]
    INTEGER(IntKi)  :: NumLogChannels = 0_IntKi      !< number of log channels from controller [-]
    TYPE(OutParmType) , DIMENSION(:), ALLOCATABLE  :: LogChannels_OutParam      !< Names and units (and other characteristics) of logging outputs from DLL [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LogChannels      !< logging outputs from controller [-]
    INTEGER(IntKi)  :: ErrStat = 0_IntKi      !< error message from external controller API [-]
    CHARACTER(ErrMsgLen)  :: ErrMsg      !< error message from external controller API [-]
    REAL(R8Ki)  :: CurrentTime = 0.0_R8Ki      !< Current Simulation Time [s]
    INTEGER(IntKi)  :: SimStatus = 0_IntKi      !< simulation status (see avrSWAP(1): Status flag set as follows: 0 if this is the first call, 1 for all subsequent time steps, -1 if this is the final call at the end of the simulation) [-]
    INTEGER(IntKi)  :: ShaftBrakeStatusBinaryFlag = 0_IntKi      !< binary flag indicating (on/off) status for shaft brake 1, shaft brake 2, generator brake, shaft brake 3, or brake torque set separately (0, 1, or 16 allowed in FAST) [-]
    LOGICAL  :: HSSBrDeployed = .false.      !< Whether the HSS brake has been deployed [-]
    REAL(R8Ki)  :: TimeHSSBrFullyDeployed = 0.0_R8Ki      !< Time at which the controller high-speed shaft is fully deployed [s]
    REAL(R8Ki)  :: TimeHSSBrDeployed = 0.0_R8Ki      !< Time at which the controller high-speed shaft is first deployed [s]
    LOGICAL  :: OverrideYawRateWithTorque = .false.      !< acts similiar to Yaw_Cntrl [-]
    REAL(ReKi)  :: YawTorqueDemand = 0.0_ReKi      !< Demanded yaw actuator torque (override of yaw rate control) [Nm]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BlPitchInput      !< Input blade pitch angles [radians]
    REAL(ReKi)  :: YawAngleFromNorth = 0.0_ReKi      !< Yaw angle of the nacelle relative to North (see NacYaw_North) [rad]
    REAL(ReKi)  :: HorWindV = 0.0_ReKi      !< Horizontal hub-height wind velocity magnitude [m/s]
    REAL(ReKi)  :: HSS_Spd = 0.0_ReKi      !< High-speed shaft (HSS) speed [rad/s]
    REAL(ReKi)  :: YawErr = 0.0_ReKi      !< Yaw error [radians]
    REAL(ReKi)  :: RotSpeed = 0.0_ReKi      !< Rotor azimuth angular speed [rad/s]
    REAL(ReKi)  :: YawBrTAxp = 0.0_ReKi      !< Tower-top / yaw bearing fore-aft (translational) acceleration (absolute) [m/s^2]
    REAL(ReKi)  :: YawBrTAyp = 0.0_ReKi      !< Tower-top / yaw bearing side-to-side (translational) acceleration (absolute) [m/s^2]
    REAL(ReKi)  :: LSSTipMys = 0.0_ReKi      !< Nonrotating low-speed shaft bending moment at the shaft tip (teeter pin for 2-blader, apex of rotation for 3-blader) [N-m]
    REAL(ReKi)  :: LSSTipMzs = 0.0_ReKi      !< Nonrotating low-speed shaft bending moment at the shaft tip (teeter pin for 2-blader, apex of rotation for 3-blader) [N-m]
    REAL(ReKi)  :: LSSTipMya = 0.0_ReKi      !< Rotating low-speed shaft bending moment at the shaft tip (teeter pin for 2-blader, apex of rotation for 3-blader) [N-m]
    REAL(ReKi)  :: LSSTipMza = 0.0_ReKi      !< Rotating low-speed shaft bending moment at the shaft tip (teeter pin for 2-blader, apex of rotation for 3-blader) [N-m]
    REAL(ReKi)  :: LSSTipPxa = 0.0_ReKi      !< Rotor azimuth angle (position) [radians]
    REAL(ReKi)  :: Yaw = 0.0_ReKi      !< Current nacelle yaw [radians]
    REAL(ReKi)  :: YawRate = 0.0_ReKi      !< Current nacelle yaw rate [rad/s]
    REAL(ReKi)  :: YawBrMyn = 0.0_ReKi      !< Rotating (with nacelle) tower-top / yaw bearing pitch moment [N-m]
    REAL(ReKi)  :: YawBrMzn = 0.0_ReKi      !< Tower-top / yaw bearing yaw moment [N-m]
    REAL(ReKi)  :: NcIMURAxs = 0.0_ReKi      !< Nacelle inertial measurement unit angular (rotational) acceleration (absolute) [rad/s^2]
    REAL(ReKi)  :: NcIMURAys = 0.0_ReKi      !< Nacelle inertial measurement unit angular (rotational) acceleration (absolute) [rad/s^2]
    REAL(ReKi)  :: NcIMURAzs = 0.0_ReKi      !< Nacelle inertial measurement unit angular (rotational) acceleration (absolute) [rad/s^2]
    REAL(ReKi)  :: RotPwr = 0.0_ReKi      !< Rotor power (this is equivalent to the low-speed shaft power) [W]
    REAL(ReKi)  :: LSSTipMxa = 0.0_ReKi      !< Rotating low-speed shaft bending moment at the shaft tip (teeter pin for 2-blader, apex of rotation for 3-blader) [N-m]
    REAL(ReKi) , DIMENSION(1:3)  :: RootMyc = 0.0_ReKi      !< Out-of-plane moment (i.e., the moment caused by out-of-plane forces) at the blade root for each of the blades (max 3) [N-m]
    REAL(ReKi) , DIMENSION(1:3)  :: RootMxc = 0.0_ReKi      !< In-plane moment (i.e., the moment caused by in-plane forces) at the blade root [N-m]
    REAL(ReKi)  :: LSShftFxa = 0.0_ReKi      !< Rotating low-speed shaft force x [N]
    REAL(ReKi)  :: LSShftFys = 0.0_ReKi      !< Nonrotating low-speed shaft force y [N]
    REAL(ReKi)  :: LSShftFzs = 0.0_ReKi      !< Nonrotating low-speed shaft force z [N]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LidSpeed      !< Lidar measured wind speed [m/s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: MsrPositionsX      !< Lidar X direction measurement points [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: MsrPositionsY      !< Lidar Y direction measurement points [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: MsrPositionsZ      !< Lidar Z direction measurement points [m]
    INTEGER(IntKi)  :: SensorType = 0_IntKi      !< Lidar sensor type [-]
    INTEGER(IntKi)  :: NumBeam = 0_IntKi      !< Number of beams [-]
    INTEGER(IntKi)  :: NumPulseGate = 0_IntKi      !< Number of pulse gates [-]
    REAL(DbKi)  :: DLL_DT = 0.0_R8Ki      !< interval for calling DLL (integer multiple number of DT) [s]
    CHARACTER(1024)  :: DLL_InFile      !< Name of input file used in DLL [-]
    CHARACTER(1024)  :: RootName      !< RootName for writing output files [-]
    REAL(ReKi)  :: GenTrq_Dem = 0.0_ReKi      !< Demanded generator torque above rated [Nm]
    REAL(ReKi)  :: GenSpd_Dem = 0.0_ReKi      !< Demanded generator speed above rated [rad/s]
    REAL(ReKi)  :: Ptch_Max = 0.0_ReKi      !< Maximum pitch angle [rad]
    REAL(ReKi)  :: Ptch_Min = 0.0_ReKi      !< Minimum pitch angle [rad]
    REAL(ReKi)  :: Ptch_SetPnt = 0.0_ReKi      !< Below-rated pitch angle set-point [rad]
    REAL(ReKi)  :: PtchRate_Max = 0.0_ReKi      !< Maximum pitch rate [rad/s]
    REAL(ReKi)  :: PtchRate_Min = 0.0_ReKi      !< Minimum pitch rate (most negative value allowed) [rad/s]
    REAL(ReKi)  :: GenPwr_Dem = 0.0_ReKi      !< Demanded power (This is not valid for variable-speed, pitch-regulated controllers.) [W]
    REAL(ReKi)  :: Gain_OM = 0.0_ReKi      !< Optimal mode gain [Nm/(rad/s)^2]
    REAL(ReKi)  :: GenSpd_MaxOM = 0.0_ReKi      !< Optimal mode maximum speed [rad/s]
    REAL(ReKi)  :: GenSpd_MinOM = 0.0_ReKi      !< Minimum generator speed [rad/s]
    INTEGER(IntKi)  :: Ptch_Cntrl = 0_IntKi      !< Pitch control: 0 = collective;  1 = individual [-]
    INTEGER(IntKi)  :: DLL_NumTrq = 0_IntKi      !< No. of points in torque-speed look-up table, 0 = none and use the optimal mode PARAMETERs instead;  nonzero = ignore the optimal mode PARAMETERs by setting Record 16 to 0.0 [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: GenSpd_TLU      !< Table (array) containing DLL_NumTrq generator speeds  for the torque-speed table look-up (TLU) -- this should be defined using an array constructor; for example,  if DLL_NumTrq = 3,  GenSpd_TLU(DLL_NumTrq)    = (/ 0.0, 99.9,  999.9 /) [rad/s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: GenTrq_TLU      !< Table (array) containing DLL_NumTrq generator torques for the torque-speed table look-up (TLU) -- this should be defined using an array constructor, for example,  if DLL_NumTrq = 3,  GenTrq_TLU(DLL_NumTrq)    = (/ 0.0, 10,  200.0 /) [Nm]
    INTEGER(IntKi)  :: Yaw_Cntrl = 0_IntKi      !< Yaw control: 0 = rate;  1 = torque [-]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: PrevCableDeltaL      !< Previous value for ramping for cable tensioning DeltaL using extended avrSWAP [see EXavrSWAP documentation in BladededInterface_EX] [m]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: PrevCableDeltaLdot      !< Previous value for ramping for cable tensioning DeltaLdot using extended avrSWAP [see EXavrSWAP documentation in BladededInterface_EX] [m/s]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: CableDeltaL      !< The swap array: used to pass data from the DLL controller for cable tensioning DeltaL using extended avrSWAP [see EXavrSWAP documentation in BladededInterface_EX] [m]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: CableDeltaLdot      !< The swap array: used to pass data from the DLL controller for cable tensioning DeltaLdot using extended avrSWAP [see EXavrSWAP documentation in BladededInterface_EX] [m/s]
    REAL(SiKi) , DIMENSION(:,:), ALLOCATABLE  :: PrevStCCmdStiff      !< Previous value for ramping StC stiffness from controller (3,NumStC_Control) [N/m]
    REAL(SiKi) , DIMENSION(:,:), ALLOCATABLE  :: PrevStCCmdDamp      !< Previous value for ramping StC damping from controller (3,NumStC_Control) [N/(m/s)]
    REAL(SiKi) , DIMENSION(:,:), ALLOCATABLE  :: PrevStCCmdBrake      !< Previous value for ramping StC braking signal (3,NumStC_Control) [N/(m/s)]
    REAL(SiKi) , DIMENSION(:,:), ALLOCATABLE  :: PrevStCCmdForce      !< Previous value for ramping StC force   signal (3,NumStC_Control) [N/(m/s)]
    REAL(SiKi) , DIMENSION(:,:), ALLOCATABLE  :: StCCmdStiff      !< StC stiffness from controller (3,NumStC_Control) [N/m]
    REAL(SiKi) , DIMENSION(:,:), ALLOCATABLE  :: StCCmdDamp      !< StC damping from controller (3,NumStC_Control) [N/(m/s)]
    REAL(SiKi) , DIMENSION(:,:), ALLOCATABLE  :: StCCmdBrake      !< StC braking signal (3,NumStC_Control) [N]
    REAL(SiKi) , DIMENSION(:,:), ALLOCATABLE  :: StCCmdForce      !< StC commanded force signal (3,NumStC_Control) [N]
    REAL(SiKi) , DIMENSION(:,:), ALLOCATABLE  :: StCMeasDisp      !< StC measured local displacement signal from StC (3,NumStC_Control) [m]
    REAL(SiKi) , DIMENSION(:,:), ALLOCATABLE  :: StCMeasVel      !< StC measured local velocity     signal from StC (3,NumStC_Control) [m/s]
  END TYPE BladedDLLType
! =======================
! =========  SrvD_ContinuousStateType  =======
  TYPE, PUBLIC :: SrvD_ContinuousStateType
    REAL(ReKi)  :: DummyContState = 0.0_ReKi      !< Remove this variable if you have continuous states [-]
    TYPE(StC_ContinuousStateType) , DIMENSION(:), ALLOCATABLE  :: BStC      !< StC module states - blade [-]
    TYPE(StC_ContinuousStateType) , DIMENSION(:), ALLOCATABLE  :: NStC      !< StC module states - nacelle [-]
    TYPE(StC_ContinuousStateType) , DIMENSION(:), ALLOCATABLE  :: TStC      !< StC module states - tower [-]
    TYPE(StC_ContinuousStateType) , DIMENSION(:), ALLOCATABLE  :: SStC      !< StC module inputs - substructure [-]
  END TYPE SrvD_ContinuousStateType
! =======================
! =========  SrvD_DiscreteStateType  =======
  TYPE, PUBLIC :: SrvD_DiscreteStateType
    REAL(ReKi)  :: CtrlOffset = 0.0_ReKi      !< Controller offset parameter [N-m]
    TYPE(StC_DiscreteStateType) , DIMENSION(:), ALLOCATABLE  :: BStC      !< StC module states - blade [-]
    TYPE(StC_DiscreteStateType) , DIMENSION(:), ALLOCATABLE  :: NStC      !< StC module states - nacelle [-]
    TYPE(StC_DiscreteStateType) , DIMENSION(:), ALLOCATABLE  :: TStC      !< StC module states - tower [-]
    TYPE(StC_DiscreteStateType) , DIMENSION(:), ALLOCATABLE  :: SStC      !< StC module inputs - substructure [-]
  END TYPE SrvD_DiscreteStateType
! =======================
! =========  SrvD_ConstraintStateType  =======
  TYPE, PUBLIC :: SrvD_ConstraintStateType
    REAL(ReKi)  :: DummyConstrState = 0.0_ReKi      !< Remove this variable if you have constraint states [-]
    TYPE(StC_ConstraintStateType) , DIMENSION(:), ALLOCATABLE  :: BStC      !< StC module states - blade [-]
    TYPE(StC_ConstraintStateType) , DIMENSION(:), ALLOCATABLE  :: NStC      !< StC module states - nacelle [-]
    TYPE(StC_ConstraintStateType) , DIMENSION(:), ALLOCATABLE  :: TStC      !< StC module states - tower [-]
    TYPE(StC_ConstraintStateType) , DIMENSION(:), ALLOCATABLE  :: SStC      !< StC module inputs - substructure [-]
  END TYPE SrvD_ConstraintStateType
! =======================
! =========  SrvD_OtherStateType  =======
  TYPE, PUBLIC :: SrvD_OtherStateType
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: BegPitMan      !< Whether the override pitch maneuver actually began [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BlPitchI      !< Initial blade pitch angles at the start of the override pitch maneuver [radians]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: TPitManE      !< Time to end pitch maneuvers for each blade [s]
    LOGICAL  :: BegYawMan = .false.      !< Whether the yaw maneuver actually began [-]
    REAL(ReKi)  :: NacYawI = 0.0_ReKi      !< Initial yaw angle at the start of the override yaw maneuver [radians]
    REAL(DbKi)  :: TYawManE = 0.0_R8Ki      !< Time to end override yaw maneuver [s]
    REAL(ReKi)  :: YawPosComInt = 0.0_ReKi      !< Internal variable that integrates the commanded yaw rate and passes it to YawPosCom [radians]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: BegTpBr      !< Whether the tip brakes actually deployed [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: TTpBrDp      !< Times to initiate deployment of tip brakes [s]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: TTpBrFl      !< Times at which tip brakes are fully deployed [s]
    LOGICAL  :: Off4Good = .false.      !< Is the generator offline for rest of simulation? [-]
    LOGICAL  :: GenOnLine = .false.      !< Is the generator online? [-]
    TYPE(StC_OtherStateType) , DIMENSION(:), ALLOCATABLE  :: BStC      !< StC module states - blade [-]
    TYPE(StC_OtherStateType) , DIMENSION(:), ALLOCATABLE  :: NStC      !< StC module states - nacelle [-]
    TYPE(StC_OtherStateType) , DIMENSION(:), ALLOCATABLE  :: TStC      !< StC module states - tower [-]
    TYPE(StC_OtherStateType) , DIMENSION(:), ALLOCATABLE  :: SStC      !< StC module inputs - substructure [-]
  END TYPE SrvD_OtherStateType
! =======================
! =========  SrvD_ModuleMapType  =======
  TYPE, PUBLIC :: SrvD_ModuleMapType
    TYPE(MeshMapType) , DIMENSION(:,:), ALLOCATABLE  :: u_BStC_Mot2_BStC      !< Map motions: u%BStCMotionMesh to m%u_BSTC%MotionMesh [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: u_NStC_Mot2_NStC      !< Map motions: u%NStCMotionMesh to m%u_NStC%MotionMesh [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: u_TStC_Mot2_TStC      !< Map motions: u%TStCMotionMesh to m%u_TStC%MotionMesh [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: u_SStC_Mot2_SStC      !< Map motions: u%SStCMotionMesh to m%u_SStC%MotionMesh [-]
    TYPE(MeshMapType) , DIMENSION(:,:), ALLOCATABLE  :: BStC_Frc2_y_BStC      !< Map loads: m%y_BStCLoadMesh to y%BSTC%LoadMesh [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: NStC_Frc2_y_NStC      !< Map loads: m%y_NStCLoadMesh to y%NStC%LoadMesh [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: TStC_Frc2_y_TStC      !< Map loads: m%y_TStCLoadMesh to y%TStC%LoadMesh [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: SStC_Frc2_y_SStC      !< Map loads: m%y_SStCLoadMesh to y%SStC%LoadMesh [-]
  END TYPE SrvD_ModuleMapType
! =======================
! =========  SrvD_MiscVarType  =======
  TYPE, PUBLIC :: SrvD_MiscVarType
    REAL(DbKi)  :: LastTimeCalled = 0.0_R8Ki      !< last time the CalcOutput/Bladed DLL was called [s]
    TYPE(BladedDLLType)  :: dll_data      !< data used for Bladed DLL [-]
    LOGICAL  :: FirstWarn = .false.      !< Whether or not this is the first warning about the DLL being called without Explicit-Loose coupling. [-]
    REAL(DbKi)  :: LastTimeFiltered = 0.0_R8Ki      !< last time the CalcOutput/Bladed DLL was filtered [s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: xd_BlPitchFilter      !< blade pitch filter [-]
    TYPE(StC_MiscVarType) , DIMENSION(:), ALLOCATABLE  :: BStC      !< StC module misc vars - blade [-]
    TYPE(StC_MiscVarType) , DIMENSION(:), ALLOCATABLE  :: NStC      !< StC module misc vars - nacelle [-]
    TYPE(StC_MiscVarType) , DIMENSION(:), ALLOCATABLE  :: TStC      !< StC module misc vars - tower [-]
    TYPE(StC_MiscVarType) , DIMENSION(:), ALLOCATABLE  :: SStC      !< StC module misc vars - substructure [-]
    TYPE(StC_InputType) , DIMENSION(:,:), ALLOCATABLE  :: u_BStC      !< StC module inputs - blade          size:(interpOrder,NumBStC) [-]
    TYPE(StC_InputType) , DIMENSION(:,:), ALLOCATABLE  :: u_NStC      !< StC module inputs - nacelle        size:(interpOrder,NumNStC) [-]
    TYPE(StC_InputType) , DIMENSION(:,:), ALLOCATABLE  :: u_TStC      !< StC module inputs - tower          size:(interpOrder,NumTStC) [-]
    TYPE(StC_InputType) , DIMENSION(:,:), ALLOCATABLE  :: u_SStC      !< StC module inputs - substructure   size:(interpOrder,NumSStC) [-]
    TYPE(StC_OutputType) , DIMENSION(:), ALLOCATABLE  :: y_BStC      !< StC module outputs - blade [-]
    TYPE(StC_OutputType) , DIMENSION(:), ALLOCATABLE  :: y_NStC      !< StC module outputs - nacelle [-]
    TYPE(StC_OutputType) , DIMENSION(:), ALLOCATABLE  :: y_TStC      !< StC module outputs - tower [-]
    TYPE(StC_OutputType) , DIMENSION(:), ALLOCATABLE  :: y_SStC      !< StC module outputs - substructure [-]
    TYPE(SrvD_ModuleMapType)  :: SrvD_MeshMap      !< Mesh mapping from inputs/output meshes to StC input/output meshes [-]
    INTEGER(IntKi)  :: PrevTstepNcall = -1      !< Previous timestep N for tracking when in predictor/corrector loop for setting StC u values [-]
  END TYPE SrvD_MiscVarType
! =======================
! =========  SrvD_ParameterType  =======
  TYPE, PUBLIC :: SrvD_ParameterType
    REAL(DbKi)  :: DT = 0.0_R8Ki      !< Time step for continuous state integration & discrete state update [seconds]
    REAL(DbKi)  :: HSSBrDT = 0.0_R8Ki      !< Time it takes for HSS brake to reach full deployment once deployed [seconds]
    REAL(ReKi)  :: HSSBrTqF = 0.0_ReKi      !< Fully deployed HSS brake torque [-]
    REAL(ReKi)  :: SIG_POSl = 0.0_ReKi      !< Pullout slip [-]
    REAL(ReKi)  :: SIG_POTq = 0.0_ReKi      !< Pullout torque [-]
    REAL(ReKi)  :: SIG_SlPc = 0.0_ReKi      !< Rated generator slip percentage [-]
    REAL(ReKi)  :: SIG_Slop = 0.0_ReKi      !< Torque/Speed slope for simple induction generator [-]
    REAL(ReKi)  :: SIG_SySp = 0.0_ReKi      !< Synchronous (zero-torque) generator speed [rad/s]
    REAL(ReKi)  :: TEC_A0 = 0.0_ReKi      !< A0 term for Thevenin-equivalent circuit [-]
    REAL(ReKi)  :: TEC_C0 = 0.0_ReKi      !< C0 term for Thevenin-equivalent circuit [-]
    REAL(ReKi)  :: TEC_C1 = 0.0_ReKi      !< C1 term for Thevenin-equivalent circuit [-]
    REAL(ReKi)  :: TEC_C2 = 0.0_ReKi      !< C2 term for Thevenin-equivalent circuit [-]
    REAL(ReKi)  :: TEC_K2 = 0.0_ReKi      !< K2 term for Thevenin-equivalent circuit [-]
    REAL(ReKi)  :: TEC_MR = 0.0_ReKi      !< Magnetizing reactance for Thevenin-equivalent circuit [ohms]
    REAL(ReKi)  :: TEC_Re1 = 0.0_ReKi      !< Thevenin's equivalent stator resistance (ohms) [ohms]
    REAL(ReKi)  :: TEC_RLR = 0.0_ReKi      !< Rotor leakage reactance for Thevenin-equivalent circuit [-]
    REAL(ReKi)  :: TEC_RRes = 0.0_ReKi      !< Rotor resistance for Thevenin-equivalent circuit [-]
    REAL(ReKi)  :: TEC_SRes = 0.0_ReKi      !< Stator resistance for Thevenin-equivalent circuit [-]
    REAL(ReKi)  :: TEC_SySp = 0.0_ReKi      !< Synchronous speed for Thevenin-equivalent circuit [-]
    REAL(ReKi)  :: TEC_V1a = 0.0_ReKi      !< Source voltage for Thevenin-equivalent circuit [-]
    REAL(ReKi)  :: TEC_VLL = 0.0_ReKi      !< Line-to-line RMS voltage for Thevenin-equivalent circuit [-]
    REAL(ReKi)  :: TEC_Xe1 = 0.0_ReKi      !< Thevenin's equivalent stator leakage reactance (ohms) [ohms]
    REAL(ReKi)  :: GenEff = 0.0_ReKi      !< Generator efficiency [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BlPitchInit      !< Initial blade pitch angles [radians]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BlPitchF      !< Final blade pitch [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: PitManRat      !< Pitch rates at which override pitch maneuvers head toward final pitch angles (does not include sign) [rad/s]
    REAL(ReKi)  :: YawManRat = 0.0_ReKi      !< Yaw rate at which override yaw maneuver head toward for final yaw angle (does not include sign) [rad/s]
    REAL(ReKi)  :: NacYawF = 0.0_ReKi      !< Final yaw angle after override yaw maneuver [-]
    REAL(ReKi)  :: SpdGenOn = 0.0_ReKi      !< Generator speed to turn on the generator for a startup [-]
    REAL(DbKi)  :: THSSBrDp = 0.0_R8Ki      !< Time to initiate deployment of the shaft brake [s]
    REAL(DbKi)  :: THSSBrFl = 0.0_R8Ki      !< Time at which shaft brake is fully deployed [s]
    REAL(DbKi)  :: TimGenOf = 0.0_R8Ki      !< Time to turn off generator for braking or modeling a run-away [s]
    REAL(DbKi)  :: TimGenOn = 0.0_R8Ki      !< Time to turn on generator for startup [s]
    REAL(DbKi)  :: TPCOn = 0.0_R8Ki      !< Time to enable active pitch control [s]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: TPitManS      !< Time to start pitch maneuvers for each blade [s]
    REAL(DbKi)  :: TYawManS = 0.0_R8Ki      !< Time to start override yaw maneuver [s]
    REAL(DbKi)  :: TYCOn = 0.0_R8Ki      !< Time to enable active yaw control [s]
    REAL(ReKi)  :: VS_RtGnSp = 0.0_ReKi      !< Rated generator speed (HSS side) [rad/s]
    REAL(ReKi)  :: VS_RtTq = 0.0_ReKi      !< Rated generator torque/constant generator torque in Region 3 (HSS side) [N-m]
    REAL(ReKi)  :: VS_Slope = 0.0_ReKi      !< Torque/speed slope of region 2 1/2 induction generator [-]
    REAL(ReKi)  :: VS_SlPc = 0.0_ReKi      !< Rated generator slip percentage in Region 2 1/2 [-]
    REAL(ReKi)  :: VS_SySp = 0.0_ReKi      !< Synchronous speed of region 2 1/2 induction generator [-]
    REAL(ReKi)  :: VS_TrGnSp = 0.0_ReKi      !< Transitional generator speed between regions 2 and 2 1/2 [-]
    REAL(ReKi)  :: YawPosCom = 0.0_ReKi      !< Commanded yaw angle from user-defined routines [rad]
    REAL(ReKi)  :: YawRateCom = 0.0_ReKi      !< Commanded yaw rate  from user-defined routines [rad/s]
    INTEGER(IntKi)  :: GenModel = 0_IntKi      !< Generator model [-]
    INTEGER(IntKi)  :: HSSBrMode = 0_IntKi      !< HSS brake model [-]
    INTEGER(IntKi)  :: PCMode = 0_IntKi      !< Pitch control mode [-]
    INTEGER(IntKi)  :: VSContrl = 0_IntKi      !< Variable-speed-generator control switch [-]
    INTEGER(IntKi)  :: YCMode = 0_IntKi      !< Yaw control mode [-]
    LOGICAL  :: GenTiStp = .false.      !< Stop generator based upon T: time or F: generator power = 0 [-]
    LOGICAL  :: GenTiStr = .false.      !< Start generator based upon T: time or F: generator speed [-]
    REAL(ReKi)  :: VS_Rgn2K = 0.0_ReKi      !< Generator torque constant in Region 2 for simple variable-speed generator control (HSS side) [used only when VSContrl=1] [N-m/(rad/s)^2]
    REAL(ReKi)  :: YawNeut = 0.0_ReKi      !< Neutral yaw position--yaw spring force is zero at this yaw [radians]
    REAL(ReKi)  :: YawSpr = 0.0_ReKi      !< Nacelle-yaw spring constant [N-m/rad]
    REAL(ReKi)  :: YawDamp = 0.0_ReKi      !< Nacelle-yaw constant [N-m/(rad/s)]
    REAL(DbKi)  :: TpBrDT = 0.0_R8Ki      !< Time for tip-brake to reach full deployment once released [s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TBDepISp      !< Deployment-initiation speed for the tip brakes [rad/s]
    REAL(ReKi)  :: TBDrConN = 0.0_ReKi      !< Tip-brake drag constant during normal operation, Cd*Area [-]
    REAL(ReKi)  :: TBDrConD = 0.0_ReKi      !< Tip-brake drag constant during fully-deployed operation, Cd*Area [-]
    INTEGER(IntKi)  :: NumBl = 0_IntKi      !< Number of blades on the turbine [-]
    INTEGER(IntKi)  :: NumBStC = 0_IntKi      !< Number of blade structural controllers (integer) [-]
    INTEGER(IntKi)  :: NumNStC = 0_IntKi      !< Number of nacelle structural controllers (integer) [-]
    INTEGER(IntKi)  :: NumTStC = 0_IntKi      !< Number of tower structural controllers (integer) [-]
    INTEGER(IntKi)  :: NumSStC = 0_IntKi      !< Number of substructure structural controllers (integer) [-]
    INTEGER(IntKi)  :: AfCmode = 0_IntKi      !< Airfoil control mode {0: none, 1: sine wave cycle, 4: user-defined from Simulink/Labview, 5: user-defined from Bladed-style DLL} [-]
    REAL(ReKi)  :: AfC_Mean = 0.0_ReKi      !< Mean level for cosine cycling or steady value [used only with AfCmode==1] [-]
    REAL(ReKi)  :: AfC_Amp = 0.0_ReKi      !< Amplitude for for cosine cycling of flap signal (-) [used only with AfCmode==1] [-]
    REAL(ReKi)  :: AfC_Phase = 0.0_ReKi      !< Phase relative to the blade azimuth (0 is vertical) for for cosine cycling of flap signal (deg) [used only with AfCmode==1] [deg]
    INTEGER(IntKi)  :: CCmode = 0_IntKi      !< Cable control control mode {0: none, 4: user-defined from Simulink/Labview, 5: user-defined from Bladed-style DLL} [-]
    INTEGER(IntKi)  :: StCCmode = 0_IntKi      !< Structural control control mode {0: none, 4: user-defined from Simulink/Labview, 5: user-defined from Bladed-style DLL} [-]
    INTEGER(IntKi)  :: NumOuts = 0_IntKi      !< Number of parameters in the output list (number of outputs requested) [-]
    INTEGER(IntKi)  :: NumOuts_DLL = 0_IntKi      !< Number of logging channels output from the DLL (set at initialization) [-]
    CHARACTER(1024)  :: RootName      !< RootName for writing output files [-]
    CHARACTER(1024)  :: PriPath      !< Path of the primary SrvD input file  [-]
    TYPE(OutParmType) , DIMENSION(:), ALLOCATABLE  :: OutParam      !< Names and units (and other characteristics) of all requested output parameters [-]
    CHARACTER(1)  :: Delim      !< Column delimiter for output text files [-]
    LOGICAL  :: UseBladedInterface = .false.      !< Flag that determines if BladedInterface was used [-]
    LOGICAL  :: UseLegacyInterface = .false.      !< Flag that determines if the legacy Bladed interface is (legacy=DISCON with avrSWAP instead of CONTROLLER) [-]
    TYPE(DLL_Type)  :: DLL_Trgt      !< The addresses and names of the Bladed DLL and its procedure [-]
    LOGICAL  :: DLL_Ramp = .false.      !< determines if there is a DLL_DT-ramp time delay (true only when DLL_DT /= DT) [-]
    REAL(ReKi)  :: BlAlpha = 0.0_ReKi      !< parameter for low-pass filter of blade pitch commands from the controller DLL [-]
    INTEGER(IntKi)  :: DLL_n = 0_IntKi      !< number of steps between the controller being called and SrvD being called [-]
    INTEGER(IntKi)  :: avcOUTNAME_LEN = 0_IntKi      !< Length of the avcOUTNAME character array passed to/from the DLL [-]
    REAL(ReKi)  :: NacYaw_North = 0.0_ReKi      !< Reference yaw angle of the nacelle when the upwind end points due North [rad]
    REAL(ReKi)  :: AvgWindSpeed = 0.0_ReKi      !< average wind speed for the simulation [m/s]
    REAL(ReKi)  :: AirDens = 0.0_ReKi      !< air density [kg/m^3]
    INTEGER(IntKi)  :: TrimCase = 0_IntKi      !< Controller parameter to be trimmed {1:yaw; 2:torque; 3:pitch} [used only if CalcSteady=True] [-]
    REAL(ReKi)  :: TrimGain = 0.0_ReKi      !< Proportional gain for the rotational speed error (>0) [used only if TrimCase>0] [rad/(rad/s) for yaw or pitch; Nm/(rad/s) for torque]
    REAL(ReKi)  :: RotSpeedRef = 0.0_ReKi      !< Reference rotor speed [rad/s]
    TYPE(StC_ParameterType) , DIMENSION(:), ALLOCATABLE  :: BStC      !< StC module parameters - blade [-]
    TYPE(StC_ParameterType) , DIMENSION(:), ALLOCATABLE  :: NStC      !< StC module parameters - nacelle [-]
    TYPE(StC_ParameterType) , DIMENSION(:), ALLOCATABLE  :: TStC      !< StC module parameters - tower [-]
    TYPE(StC_ParameterType) , DIMENSION(:), ALLOCATABLE  :: SStC      !< StC module parameters - substructure [-]
    INTEGER(IntKi)  :: InterpOrder = 0_IntKi      !< Interpolation order from glue code -- required to set m%u_xStC sizes [-]
    LOGICAL  :: EXavrSWAP = .false.      !< Use extendend avr SWAP [-]
    INTEGER(IntKi)  :: NumCableControl = 0_IntKi      !< Number of cable control channels requested [-]
    INTEGER(IntKi)  :: NumStC_Control = 0_IntKi      !< Number of cable StC channels requested [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: StCMeasNumPerChan      !< Number of cable StC channel to average on each control channel sent to DLL [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: Jac_u_indx      !< matrix to help fill/pack the u vector in computing the jacobian [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: Jac_x_indx      !< matrix to help fill/pack the x vector in computing the jacobian [-]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: du      !< vector that determines size of perturbation for u (inputs) [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: dx      !< vector that determines size of perturbation for x (continuous states) [-]
    INTEGER(IntKi)  :: Jac_nu = 0_IntKi      !< number of inputs in jacobian matrix [-]
    INTEGER(IntKi)  :: Jac_ny = 0_IntKi      !< number of outputs in jacobian matrix [-]
    INTEGER(IntKi)  :: Jac_nx = 0_IntKi      !< the number of continuous states in jacobian matrix [-]
    INTEGER(IntKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Jac_Idx_BStC_u      !< the start and end indices of blade        StC u jacobian [ start/end, blade, instance ] [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: Jac_Idx_NStC_u      !< the start and end indices of nacelle      StC u jacobian [ start/end, instance ] [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: Jac_Idx_TStC_u      !< the start and end indices of tower        StC u jacobian [ start/end, instance ] [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: Jac_Idx_SStC_u      !< the start and end indices of substructure StC u jacobian [ start/end, instance ] [-]
    INTEGER(IntKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Jac_Idx_BStC_x      !< the start and end indices of blade        StC x jacobian [ start/end, blade, instance ] [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: Jac_Idx_NStC_x      !< the start and end indices of nacelle      StC x jacobian [ start/end, instance ] [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: Jac_Idx_TStC_x      !< the start and end indices of tower        StC x jacobian [ start/end, instance ] [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: Jac_Idx_SStC_x      !< the start and end indices of substructure StC x jacobian [ start/end, instance ] [-]
    INTEGER(IntKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Jac_Idx_BStC_y      !< the start and end indices of blade        StC y jacobian [ start/end, blade, instance ] [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: Jac_Idx_NStC_y      !< the start and end indices of nacelle      StC y jacobian [ start/end, instance ] [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: Jac_Idx_TStC_y      !< the start and end indices of tower        StC y jacobian [ start/end, instance ] [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: Jac_Idx_SStC_y      !< the start and end indices of substructure StC y jacobian [ start/end, instance ] [-]
    INTEGER(IntKi)  :: SensorType = 0_IntKi      !< Lidar sensor type [-]
    INTEGER(IntKi)  :: NumBeam = 0_IntKi      !< Number of beams [-]
    INTEGER(IntKi)  :: NumPulseGate = 0_IntKi      !< Number of pulse gates [-]
  END TYPE SrvD_ParameterType
! =======================
! =========  SrvD_InputType  =======
  TYPE, PUBLIC :: SrvD_InputType
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BlPitch      !< Current blade pitch angles [radians]
    REAL(ReKi)  :: Yaw = 0.0_ReKi      !< Current nacelle yaw [radians]
    REAL(ReKi)  :: YawRate = 0.0_ReKi      !< Current nacelle yaw rate [rad/s]
    REAL(ReKi)  :: LSS_Spd = 0.0_ReKi      !< Low-speed shaft (LSS) speed at entrance to gearbox [rad/s]
    REAL(ReKi)  :: HSS_Spd = 0.0_ReKi      !< High-speed shaft (HSS) speed [rad/s]
    REAL(ReKi)  :: RotSpeed = 0.0_ReKi      !< Rotor azimuth angular speed [rad/s]
    REAL(ReKi)  :: ExternalYawPosCom = 0.0_ReKi      !< Commanded nacelle yaw position from Simulink or Labview [radians]
    REAL(ReKi)  :: ExternalYawRateCom = 0.0_ReKi      !< Commanded nacelle yaw rate from Simulink or Labview [rad/s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: ExternalBlPitchCom      !< Commanded blade pitch from Simulink or LabVIEW [radians]
    REAL(ReKi)  :: ExternalGenTrq = 0.0_ReKi      !< Electrical generator torque from Simulink or LabVIEW [N-m]
    REAL(ReKi)  :: ExternalElecPwr = 0.0_ReKi      !< Electrical power from Simulink or LabVIEW [W]
    REAL(ReKi)  :: ExternalHSSBrFrac = 0.0_ReKi      !< Fraction of full braking torque: 0 (off) <= HSSBrFrac <= 1 (full) from Simulink or LabVIEW [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: ExternalBlAirfoilCom      !< Commanded Airfoil UserProp for blade.  Passed to AD15 for airfoil interpolation (must be same units as given in AD15 airfoil tables) [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: ExternalCableDeltaL      !< Commanded Cable controlo DeltaL [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: ExternalCableDeltaLdot      !< Commanded Cable controlo DeltaLdot [m/s]
    REAL(ReKi)  :: TwrAccel = 0.0_ReKi      !< Tower acceleration for tower feedback control (user routine only) [m/s^2]
    REAL(ReKi)  :: YawErr = 0.0_ReKi      !< Yaw error [radians]
    REAL(ReKi)  :: WindDir = 0.0_ReKi      !< Wind direction [radians]
    REAL(ReKi) , DIMENSION(1:3)  :: RootMyc = 0.0_ReKi      !< Out-of-plane moment (i.e., the moment caused by out-of-plane forces) at the blade root for each of the blades (max 3) [N-m]
    REAL(ReKi)  :: YawBrTAxp = 0.0_ReKi      !< Tower-top / yaw bearing fore-aft (translational) acceleration (absolute) [m/s^2]
    REAL(ReKi)  :: YawBrTAyp = 0.0_ReKi      !< Tower-top / yaw bearing side-to-side (translational) acceleration (absolute) [m/s^2]
    REAL(ReKi)  :: LSSTipPxa = 0.0_ReKi      !< Rotor azimuth angle (position) [radians]
    REAL(ReKi) , DIMENSION(1:3)  :: RootMxc = 0.0_ReKi      !< In-plane moment (i.e., the moment caused by in-plane forces) at the blade root [N-m]
    REAL(ReKi)  :: LSSTipMxa = 0.0_ReKi      !< Rotating low-speed shaft bending moment at the shaft tip (teeter pin for 2-blader, apex of rotation for 3-blader) [N-m]
    REAL(ReKi)  :: LSSTipMya = 0.0_ReKi      !< Rotating low-speed shaft bending moment at the shaft tip (teeter pin for 2-blader, apex of rotation for 3-blader) [N-m]
    REAL(ReKi)  :: LSSTipMza = 0.0_ReKi      !< Rotating low-speed shaft bending moment at the shaft tip (teeter pin for 2-blader, apex of rotation for 3-blader) [N-m]
    REAL(ReKi)  :: LSSTipMys = 0.0_ReKi      !< Nonrotating low-speed shaft bending moment at the shaft tip (teeter pin for 2-blader, apex of rotation for 3-blader) [N-m]
    REAL(ReKi)  :: LSSTipMzs = 0.0_ReKi      !< Nonrotating low-speed shaft bending moment at the shaft tip (teeter pin for 2-blader, apex of rotation for 3-blader) [N-m]
    REAL(ReKi)  :: YawBrMyn = 0.0_ReKi      !< Rotating (with nacelle) tower-top / yaw bearing pitch moment [N-m]
    REAL(ReKi)  :: YawBrMzn = 0.0_ReKi      !< Tower-top / yaw bearing yaw moment [N-m]
    REAL(ReKi)  :: NcIMURAxs = 0.0_ReKi      !< Nacelle inertial measurement unit angular (rotational) acceleration (absolute) [rad/s^2]
    REAL(ReKi)  :: NcIMURAys = 0.0_ReKi      !< Nacelle inertial measurement unit angular (rotational) acceleration (absolute) [rad/s^2]
    REAL(ReKi)  :: NcIMURAzs = 0.0_ReKi      !< Nacelle inertial measurement unit angular (rotational) acceleration (absolute) [rad/s^2]
    REAL(ReKi)  :: RotPwr = 0.0_ReKi      !< Rotor power (this is equivalent to the low-speed shaft power) [W]
    REAL(ReKi)  :: HorWindV = 0.0_ReKi      !< Horizontal hub-height wind velocity magnitude [m/s]
    REAL(ReKi)  :: YawAngle = 0.0_ReKi      !< Estimate of yaw (nacelle + platform) [radians]
    REAL(ReKi)  :: LSShftFxa = 0.0_ReKi      !< Rotating low-speed shaft force x [N]
    REAL(ReKi)  :: LSShftFys = 0.0_ReKi      !< Nonrotating low-speed shaft force y [N]
    REAL(ReKi)  :: LSShftFzs = 0.0_ReKi      !< Nonrotating low-speed shaft force z [N]
    TYPE(MeshType)  :: PtfmMotionMesh      !< Platform motion mesh at platform reference point [-]
    TYPE(MeshType) , DIMENSION(:,:), ALLOCATABLE  :: BStCMotionMesh      !< StC module blade        input motion mesh [-]
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: NStCMotionMesh      !< StC module nacelle      input motion mesh [-]
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: TStCMotionMesh      !< StC module tower        input motion mesh [-]
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: SStCMotionMesh      !< StC module substructure input motion mesh [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LidSpeed      !< Lidar measured wind speeds [m/s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: MsrPositionsX      !< Lidar X direction measurement points [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: MsrPositionsY      !< Lidar Y direction measurement points [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: MsrPositionsZ      !< Lidar Z direction measurement points [m]
  END TYPE SrvD_InputType
! =======================
! =========  SrvD_OutputType  =======
  TYPE, PUBLIC :: SrvD_OutputType
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WriteOutput      !< Data to be written to an output file: see WriteOutputHdr for names of each variable [see WriteOutputUnt]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BlPitchCom      !< Commanded blade pitch angles [radians]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BlAirfoilCom      !< Commanded Airfoil UserProp for blade.  Passed to AD15 for airfoil interpolation (must be same units as given in AD15 airfoil tables) [-]
    REAL(ReKi)  :: YawMom = 0.0_ReKi      !< Torque transmitted through the yaw bearing [N-m]
    REAL(ReKi)  :: YawPosCom = 0.0_ReKi      !< Yaw command from controller (for SED module) [rad]
    REAL(ReKi)  :: YawRateCom = 0.0_ReKi      !< Yaw rate command from controller (for SED module) [rad/s]
    REAL(ReKi)  :: GenTrq = 0.0_ReKi      !< Electrical generator torque [N-m]
    REAL(ReKi)  :: HSSBrTrqC = 0.0_ReKi      !< Commanded HSS brake torque [N-m]
    REAL(ReKi)  :: ElecPwr = 0.0_ReKi      !< Electrical power [W]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TBDrCon      !< Instantaneous tip-brake drag constant, Cd*Area [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: CableDeltaL      !< Cable control -- Length change request (passed to MD or SD) [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: CableDeltaLdot      !< Cable control -- Length change rate request (passed to MD or SD) [m/s]
    TYPE(MeshType) , DIMENSION(:,:), ALLOCATABLE  :: BStCLoadMesh      !< StC module blade        output load mesh (NumBl,NumBStC) [-]
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: NStCLoadMesh      !< StC module nacelle      output load mesh [-]
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: TStCLoadMesh      !< StC module tower        output load mesh [-]
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: SStCLoadMesh      !< StC module substructure output load mesh [-]
  END TYPE SrvD_OutputType
! =======================
CONTAINS

subroutine SrvD_CopyInitInput(SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg)
   type(SrvD_InitInputType), intent(in) :: SrcInitInputData
   type(SrvD_InitInputType), intent(inout) :: DstInitInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SrvD_CopyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInitInputData%InputFile = SrcInitInputData%InputFile
   DstInitInputData%Linearize = SrcInitInputData%Linearize
   DstInitInputData%NumBl = SrcInitInputData%NumBl
   DstInitInputData%RootName = SrcInitInputData%RootName
   if (allocated(SrcInitInputData%BlPitchInit)) then
      LB(1:1) = lbound(SrcInitInputData%BlPitchInit)
      UB(1:1) = ubound(SrcInitInputData%BlPitchInit)
      if (.not. allocated(DstInitInputData%BlPitchInit)) then
         allocate(DstInitInputData%BlPitchInit(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%BlPitchInit.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%BlPitchInit = SrcInitInputData%BlPitchInit
   end if
   DstInitInputData%Gravity = SrcInitInputData%Gravity
   DstInitInputData%NacRefPos = SrcInitInputData%NacRefPos
   DstInitInputData%NacTransDisp = SrcInitInputData%NacTransDisp
   DstInitInputData%NacOrient = SrcInitInputData%NacOrient
   DstInitInputData%NacRefOrient = SrcInitInputData%NacRefOrient
   DstInitInputData%TwrBaseRefPos = SrcInitInputData%TwrBaseRefPos
   DstInitInputData%TwrBaseTransDisp = SrcInitInputData%TwrBaseTransDisp
   DstInitInputData%TwrBaseOrient = SrcInitInputData%TwrBaseOrient
   DstInitInputData%TwrBaseRefOrient = SrcInitInputData%TwrBaseRefOrient
   DstInitInputData%PtfmRefPos = SrcInitInputData%PtfmRefPos
   DstInitInputData%PtfmTransDisp = SrcInitInputData%PtfmTransDisp
   DstInitInputData%PtfmOrient = SrcInitInputData%PtfmOrient
   DstInitInputData%PtfmRefOrient = SrcInitInputData%PtfmRefOrient
   DstInitInputData%Tmax = SrcInitInputData%Tmax
   DstInitInputData%AvgWindSpeed = SrcInitInputData%AvgWindSpeed
   DstInitInputData%AirDens = SrcInitInputData%AirDens
   DstInitInputData%TrimCase = SrcInitInputData%TrimCase
   DstInitInputData%TrimGain = SrcInitInputData%TrimGain
   DstInitInputData%RotSpeedRef = SrcInitInputData%RotSpeedRef
   if (allocated(SrcInitInputData%BladeRootRefPos)) then
      LB(1:2) = lbound(SrcInitInputData%BladeRootRefPos)
      UB(1:2) = ubound(SrcInitInputData%BladeRootRefPos)
      if (.not. allocated(DstInitInputData%BladeRootRefPos)) then
         allocate(DstInitInputData%BladeRootRefPos(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%BladeRootRefPos.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%BladeRootRefPos = SrcInitInputData%BladeRootRefPos
   end if
   if (allocated(SrcInitInputData%BladeRootTransDisp)) then
      LB(1:2) = lbound(SrcInitInputData%BladeRootTransDisp)
      UB(1:2) = ubound(SrcInitInputData%BladeRootTransDisp)
      if (.not. allocated(DstInitInputData%BladeRootTransDisp)) then
         allocate(DstInitInputData%BladeRootTransDisp(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%BladeRootTransDisp.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%BladeRootTransDisp = SrcInitInputData%BladeRootTransDisp
   end if
   if (allocated(SrcInitInputData%BladeRootOrient)) then
      LB(1:3) = lbound(SrcInitInputData%BladeRootOrient)
      UB(1:3) = ubound(SrcInitInputData%BladeRootOrient)
      if (.not. allocated(DstInitInputData%BladeRootOrient)) then
         allocate(DstInitInputData%BladeRootOrient(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%BladeRootOrient.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%BladeRootOrient = SrcInitInputData%BladeRootOrient
   end if
   if (allocated(SrcInitInputData%BladeRootRefOrient)) then
      LB(1:3) = lbound(SrcInitInputData%BladeRootRefOrient)
      UB(1:3) = ubound(SrcInitInputData%BladeRootRefOrient)
      if (.not. allocated(DstInitInputData%BladeRootRefOrient)) then
         allocate(DstInitInputData%BladeRootRefOrient(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%BladeRootRefOrient.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%BladeRootRefOrient = SrcInitInputData%BladeRootRefOrient
   end if
   DstInitInputData%UseInputFile = SrcInitInputData%UseInputFile
   call NWTC_Library_CopyFileInfoType(SrcInitInputData%PassedPrimaryInputData, DstInitInputData%PassedPrimaryInputData, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstInitInputData%NumCableControl = SrcInitInputData%NumCableControl
   if (allocated(SrcInitInputData%CableControlRequestor)) then
      LB(1:1) = lbound(SrcInitInputData%CableControlRequestor)
      UB(1:1) = ubound(SrcInitInputData%CableControlRequestor)
      if (.not. allocated(DstInitInputData%CableControlRequestor)) then
         allocate(DstInitInputData%CableControlRequestor(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%CableControlRequestor.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%CableControlRequestor = SrcInitInputData%CableControlRequestor
   end if
   DstInitInputData%InterpOrder = SrcInitInputData%InterpOrder
   DstInitInputData%SensorType = SrcInitInputData%SensorType
   DstInitInputData%NumBeam = SrcInitInputData%NumBeam
   DstInitInputData%NumPulseGate = SrcInitInputData%NumPulseGate
end subroutine

subroutine SrvD_DestroyInitInput(InitInputData, ErrStat, ErrMsg)
   type(SrvD_InitInputType), intent(inout) :: InitInputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SrvD_DestroyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InitInputData%BlPitchInit)) then
      deallocate(InitInputData%BlPitchInit)
   end if
   if (allocated(InitInputData%BladeRootRefPos)) then
      deallocate(InitInputData%BladeRootRefPos)
   end if
   if (allocated(InitInputData%BladeRootTransDisp)) then
      deallocate(InitInputData%BladeRootTransDisp)
   end if
   if (allocated(InitInputData%BladeRootOrient)) then
      deallocate(InitInputData%BladeRootOrient)
   end if
   if (allocated(InitInputData%BladeRootRefOrient)) then
      deallocate(InitInputData%BladeRootRefOrient)
   end if
   call NWTC_Library_DestroyFileInfoType(InitInputData%PassedPrimaryInputData, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(InitInputData%CableControlRequestor)) then
      deallocate(InitInputData%CableControlRequestor)
   end if
end subroutine

subroutine SrvD_PackInitInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SrvD_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SrvD_PackInitInput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%InputFile)
   call RegPack(RF, InData%Linearize)
   call RegPack(RF, InData%NumBl)
   call RegPack(RF, InData%RootName)
   call RegPackAlloc(RF, InData%BlPitchInit)
   call RegPack(RF, InData%Gravity)
   call RegPack(RF, InData%NacRefPos)
   call RegPack(RF, InData%NacTransDisp)
   call RegPack(RF, InData%NacOrient)
   call RegPack(RF, InData%NacRefOrient)
   call RegPack(RF, InData%TwrBaseRefPos)
   call RegPack(RF, InData%TwrBaseTransDisp)
   call RegPack(RF, InData%TwrBaseOrient)
   call RegPack(RF, InData%TwrBaseRefOrient)
   call RegPack(RF, InData%PtfmRefPos)
   call RegPack(RF, InData%PtfmTransDisp)
   call RegPack(RF, InData%PtfmOrient)
   call RegPack(RF, InData%PtfmRefOrient)
   call RegPack(RF, InData%Tmax)
   call RegPack(RF, InData%AvgWindSpeed)
   call RegPack(RF, InData%AirDens)
   call RegPack(RF, InData%TrimCase)
   call RegPack(RF, InData%TrimGain)
   call RegPack(RF, InData%RotSpeedRef)
   call RegPackAlloc(RF, InData%BladeRootRefPos)
   call RegPackAlloc(RF, InData%BladeRootTransDisp)
   call RegPackAlloc(RF, InData%BladeRootOrient)
   call RegPackAlloc(RF, InData%BladeRootRefOrient)
   call RegPack(RF, InData%UseInputFile)
   call NWTC_Library_PackFileInfoType(RF, InData%PassedPrimaryInputData) 
   call RegPack(RF, InData%NumCableControl)
   call RegPackAlloc(RF, InData%CableControlRequestor)
   call RegPack(RF, InData%InterpOrder)
   call RegPack(RF, InData%SensorType)
   call RegPack(RF, InData%NumBeam)
   call RegPack(RF, InData%NumPulseGate)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SrvD_UnPackInitInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SrvD_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SrvD_UnPackInitInput'
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%InputFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Linearize); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumBl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BlPitchInit); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Gravity); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NacRefPos); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NacTransDisp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NacOrient); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NacRefOrient); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TwrBaseRefPos); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TwrBaseTransDisp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TwrBaseOrient); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TwrBaseRefOrient); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmRefPos); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmTransDisp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmOrient); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmRefOrient); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Tmax); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AvgWindSpeed); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AirDens); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TrimCase); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TrimGain); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RotSpeedRef); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BladeRootRefPos); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BladeRootTransDisp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BladeRootOrient); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BladeRootRefOrient); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UseInputFile); if (RegCheckErr(RF, RoutineName)) return
   call NWTC_Library_UnpackFileInfoType(RF, OutData%PassedPrimaryInputData) ! PassedPrimaryInputData 
   call RegUnpack(RF, OutData%NumCableControl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%CableControlRequestor); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%InterpOrder); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SensorType); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumBeam); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumPulseGate); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SrvD_CopyInitOutput(SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg)
   type(SrvD_InitOutputType), intent(in) :: SrcInitOutputData
   type(SrvD_InitOutputType), intent(inout) :: DstInitOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SrvD_CopyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcInitOutputData%WriteOutputHdr)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputHdr)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputHdr)
      if (.not. allocated(DstInitOutputData%WriteOutputHdr)) then
         allocate(DstInitOutputData%WriteOutputHdr(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputHdr.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputHdr = SrcInitOutputData%WriteOutputHdr
   end if
   if (allocated(SrcInitOutputData%WriteOutputUnt)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputUnt)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputUnt)
      if (.not. allocated(DstInitOutputData%WriteOutputUnt)) then
         allocate(DstInitOutputData%WriteOutputUnt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputUnt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputUnt = SrcInitOutputData%WriteOutputUnt
   end if
   call NWTC_Library_CopyProgDesc(SrcInitOutputData%Ver, DstInitOutputData%Ver, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstInitOutputData%CouplingScheme = SrcInitOutputData%CouplingScheme
   DstInitOutputData%UseHSSBrake = SrcInitOutputData%UseHSSBrake
   if (allocated(SrcInitOutputData%LinNames_y)) then
      LB(1:1) = lbound(SrcInitOutputData%LinNames_y)
      UB(1:1) = ubound(SrcInitOutputData%LinNames_y)
      if (.not. allocated(DstInitOutputData%LinNames_y)) then
         allocate(DstInitOutputData%LinNames_y(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LinNames_y.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%LinNames_y = SrcInitOutputData%LinNames_y
   end if
   if (allocated(SrcInitOutputData%LinNames_x)) then
      LB(1:1) = lbound(SrcInitOutputData%LinNames_x)
      UB(1:1) = ubound(SrcInitOutputData%LinNames_x)
      if (.not. allocated(DstInitOutputData%LinNames_x)) then
         allocate(DstInitOutputData%LinNames_x(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LinNames_x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%LinNames_x = SrcInitOutputData%LinNames_x
   end if
   if (allocated(SrcInitOutputData%LinNames_u)) then
      LB(1:1) = lbound(SrcInitOutputData%LinNames_u)
      UB(1:1) = ubound(SrcInitOutputData%LinNames_u)
      if (.not. allocated(DstInitOutputData%LinNames_u)) then
         allocate(DstInitOutputData%LinNames_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LinNames_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%LinNames_u = SrcInitOutputData%LinNames_u
   end if
   if (allocated(SrcInitOutputData%RotFrame_y)) then
      LB(1:1) = lbound(SrcInitOutputData%RotFrame_y)
      UB(1:1) = ubound(SrcInitOutputData%RotFrame_y)
      if (.not. allocated(DstInitOutputData%RotFrame_y)) then
         allocate(DstInitOutputData%RotFrame_y(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%RotFrame_y.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%RotFrame_y = SrcInitOutputData%RotFrame_y
   end if
   if (allocated(SrcInitOutputData%RotFrame_x)) then
      LB(1:1) = lbound(SrcInitOutputData%RotFrame_x)
      UB(1:1) = ubound(SrcInitOutputData%RotFrame_x)
      if (.not. allocated(DstInitOutputData%RotFrame_x)) then
         allocate(DstInitOutputData%RotFrame_x(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%RotFrame_x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%RotFrame_x = SrcInitOutputData%RotFrame_x
   end if
   if (allocated(SrcInitOutputData%RotFrame_u)) then
      LB(1:1) = lbound(SrcInitOutputData%RotFrame_u)
      UB(1:1) = ubound(SrcInitOutputData%RotFrame_u)
      if (.not. allocated(DstInitOutputData%RotFrame_u)) then
         allocate(DstInitOutputData%RotFrame_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%RotFrame_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%RotFrame_u = SrcInitOutputData%RotFrame_u
   end if
   if (allocated(SrcInitOutputData%IsLoad_u)) then
      LB(1:1) = lbound(SrcInitOutputData%IsLoad_u)
      UB(1:1) = ubound(SrcInitOutputData%IsLoad_u)
      if (.not. allocated(DstInitOutputData%IsLoad_u)) then
         allocate(DstInitOutputData%IsLoad_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%IsLoad_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%IsLoad_u = SrcInitOutputData%IsLoad_u
   end if
   if (allocated(SrcInitOutputData%DerivOrder_x)) then
      LB(1:1) = lbound(SrcInitOutputData%DerivOrder_x)
      UB(1:1) = ubound(SrcInitOutputData%DerivOrder_x)
      if (.not. allocated(DstInitOutputData%DerivOrder_x)) then
         allocate(DstInitOutputData%DerivOrder_x(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%DerivOrder_x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%DerivOrder_x = SrcInitOutputData%DerivOrder_x
   end if
end subroutine

subroutine SrvD_DestroyInitOutput(InitOutputData, ErrStat, ErrMsg)
   type(SrvD_InitOutputType), intent(inout) :: InitOutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SrvD_DestroyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InitOutputData%WriteOutputHdr)) then
      deallocate(InitOutputData%WriteOutputHdr)
   end if
   if (allocated(InitOutputData%WriteOutputUnt)) then
      deallocate(InitOutputData%WriteOutputUnt)
   end if
   call NWTC_Library_DestroyProgDesc(InitOutputData%Ver, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(InitOutputData%LinNames_y)) then
      deallocate(InitOutputData%LinNames_y)
   end if
   if (allocated(InitOutputData%LinNames_x)) then
      deallocate(InitOutputData%LinNames_x)
   end if
   if (allocated(InitOutputData%LinNames_u)) then
      deallocate(InitOutputData%LinNames_u)
   end if
   if (allocated(InitOutputData%RotFrame_y)) then
      deallocate(InitOutputData%RotFrame_y)
   end if
   if (allocated(InitOutputData%RotFrame_x)) then
      deallocate(InitOutputData%RotFrame_x)
   end if
   if (allocated(InitOutputData%RotFrame_u)) then
      deallocate(InitOutputData%RotFrame_u)
   end if
   if (allocated(InitOutputData%IsLoad_u)) then
      deallocate(InitOutputData%IsLoad_u)
   end if
   if (allocated(InitOutputData%DerivOrder_x)) then
      deallocate(InitOutputData%DerivOrder_x)
   end if
end subroutine

subroutine SrvD_PackInitOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SrvD_InitOutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SrvD_PackInitOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%WriteOutputHdr)
   call RegPackAlloc(RF, InData%WriteOutputUnt)
   call NWTC_Library_PackProgDesc(RF, InData%Ver) 
   call RegPack(RF, InData%CouplingScheme)
   call RegPack(RF, InData%UseHSSBrake)
   call RegPackAlloc(RF, InData%LinNames_y)
   call RegPackAlloc(RF, InData%LinNames_x)
   call RegPackAlloc(RF, InData%LinNames_u)
   call RegPackAlloc(RF, InData%RotFrame_y)
   call RegPackAlloc(RF, InData%RotFrame_x)
   call RegPackAlloc(RF, InData%RotFrame_u)
   call RegPackAlloc(RF, InData%IsLoad_u)
   call RegPackAlloc(RF, InData%DerivOrder_x)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SrvD_UnPackInitOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SrvD_InitOutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SrvD_UnPackInitOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%WriteOutputHdr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutputUnt); if (RegCheckErr(RF, RoutineName)) return
   call NWTC_Library_UnpackProgDesc(RF, OutData%Ver) ! Ver 
   call RegUnpack(RF, OutData%CouplingScheme); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UseHSSBrake); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LinNames_y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LinNames_x); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LinNames_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RotFrame_y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RotFrame_x); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RotFrame_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%IsLoad_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%DerivOrder_x); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SrvD_CopyInputFile(SrcInputFileData, DstInputFileData, CtrlCode, ErrStat, ErrMsg)
   type(SrvD_InputFile), intent(in) :: SrcInputFileData
   type(SrvD_InputFile), intent(inout) :: DstInputFileData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'SrvD_CopyInputFile'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInputFileData%DT = SrcInputFileData%DT
   DstInputFileData%Echo = SrcInputFileData%Echo
   DstInputFileData%PCMode = SrcInputFileData%PCMode
   DstInputFileData%TPCOn = SrcInputFileData%TPCOn
   DstInputFileData%TPitManS = SrcInputFileData%TPitManS
   DstInputFileData%PitManRat = SrcInputFileData%PitManRat
   DstInputFileData%BlPitchF = SrcInputFileData%BlPitchF
   DstInputFileData%VSContrl = SrcInputFileData%VSContrl
   DstInputFileData%GenModel = SrcInputFileData%GenModel
   DstInputFileData%GenEff = SrcInputFileData%GenEff
   DstInputFileData%GenTiStr = SrcInputFileData%GenTiStr
   DstInputFileData%GenTiStp = SrcInputFileData%GenTiStp
   DstInputFileData%SpdGenOn = SrcInputFileData%SpdGenOn
   DstInputFileData%TimGenOn = SrcInputFileData%TimGenOn
   DstInputFileData%TimGenOf = SrcInputFileData%TimGenOf
   DstInputFileData%VS_RtGnSp = SrcInputFileData%VS_RtGnSp
   DstInputFileData%VS_RtTq = SrcInputFileData%VS_RtTq
   DstInputFileData%VS_Rgn2K = SrcInputFileData%VS_Rgn2K
   DstInputFileData%VS_SlPc = SrcInputFileData%VS_SlPc
   DstInputFileData%SIG_SlPc = SrcInputFileData%SIG_SlPc
   DstInputFileData%SIG_SySp = SrcInputFileData%SIG_SySp
   DstInputFileData%SIG_RtTq = SrcInputFileData%SIG_RtTq
   DstInputFileData%SIG_PORt = SrcInputFileData%SIG_PORt
   DstInputFileData%TEC_Freq = SrcInputFileData%TEC_Freq
   DstInputFileData%TEC_NPol = SrcInputFileData%TEC_NPol
   DstInputFileData%TEC_SRes = SrcInputFileData%TEC_SRes
   DstInputFileData%TEC_RRes = SrcInputFileData%TEC_RRes
   DstInputFileData%TEC_VLL = SrcInputFileData%TEC_VLL
   DstInputFileData%TEC_SLR = SrcInputFileData%TEC_SLR
   DstInputFileData%TEC_RLR = SrcInputFileData%TEC_RLR
   DstInputFileData%TEC_MR = SrcInputFileData%TEC_MR
   DstInputFileData%HSSBrMode = SrcInputFileData%HSSBrMode
   DstInputFileData%THSSBrDp = SrcInputFileData%THSSBrDp
   DstInputFileData%HSSBrDT = SrcInputFileData%HSSBrDT
   DstInputFileData%HSSBrTqF = SrcInputFileData%HSSBrTqF
   DstInputFileData%YCMode = SrcInputFileData%YCMode
   DstInputFileData%TYCOn = SrcInputFileData%TYCOn
   DstInputFileData%YawNeut = SrcInputFileData%YawNeut
   DstInputFileData%YawSpr = SrcInputFileData%YawSpr
   DstInputFileData%YawDamp = SrcInputFileData%YawDamp
   DstInputFileData%TYawManS = SrcInputFileData%TYawManS
   DstInputFileData%YawManRat = SrcInputFileData%YawManRat
   DstInputFileData%NacYawF = SrcInputFileData%NacYawF
   DstInputFileData%SumPrint = SrcInputFileData%SumPrint
   DstInputFileData%OutFile = SrcInputFileData%OutFile
   DstInputFileData%TabDelim = SrcInputFileData%TabDelim
   DstInputFileData%OutFmt = SrcInputFileData%OutFmt
   DstInputFileData%Tstart = SrcInputFileData%Tstart
   DstInputFileData%NumOuts = SrcInputFileData%NumOuts
   if (allocated(SrcInputFileData%OutList)) then
      LB(1:1) = lbound(SrcInputFileData%OutList)
      UB(1:1) = ubound(SrcInputFileData%OutList)
      if (.not. allocated(DstInputFileData%OutList)) then
         allocate(DstInputFileData%OutList(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%OutList.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%OutList = SrcInputFileData%OutList
   end if
   DstInputFileData%DLL_FileName = SrcInputFileData%DLL_FileName
   DstInputFileData%DLL_ProcName = SrcInputFileData%DLL_ProcName
   DstInputFileData%DLL_InFile = SrcInputFileData%DLL_InFile
   DstInputFileData%DLL_DT = SrcInputFileData%DLL_DT
   DstInputFileData%DLL_Ramp = SrcInputFileData%DLL_Ramp
   DstInputFileData%BPCutoff = SrcInputFileData%BPCutoff
   DstInputFileData%NacYaw_North = SrcInputFileData%NacYaw_North
   DstInputFileData%Ptch_Cntrl = SrcInputFileData%Ptch_Cntrl
   DstInputFileData%Ptch_SetPnt = SrcInputFileData%Ptch_SetPnt
   DstInputFileData%Ptch_Min = SrcInputFileData%Ptch_Min
   DstInputFileData%Ptch_Max = SrcInputFileData%Ptch_Max
   DstInputFileData%PtchRate_Min = SrcInputFileData%PtchRate_Min
   DstInputFileData%PtchRate_Max = SrcInputFileData%PtchRate_Max
   DstInputFileData%Gain_OM = SrcInputFileData%Gain_OM
   DstInputFileData%GenSpd_MinOM = SrcInputFileData%GenSpd_MinOM
   DstInputFileData%GenSpd_MaxOM = SrcInputFileData%GenSpd_MaxOM
   DstInputFileData%GenSpd_Dem = SrcInputFileData%GenSpd_Dem
   DstInputFileData%GenTrq_Dem = SrcInputFileData%GenTrq_Dem
   DstInputFileData%GenPwr_Dem = SrcInputFileData%GenPwr_Dem
   DstInputFileData%DLL_NumTrq = SrcInputFileData%DLL_NumTrq
   if (allocated(SrcInputFileData%GenSpd_TLU)) then
      LB(1:1) = lbound(SrcInputFileData%GenSpd_TLU)
      UB(1:1) = ubound(SrcInputFileData%GenSpd_TLU)
      if (.not. allocated(DstInputFileData%GenSpd_TLU)) then
         allocate(DstInputFileData%GenSpd_TLU(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%GenSpd_TLU.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%GenSpd_TLU = SrcInputFileData%GenSpd_TLU
   end if
   if (allocated(SrcInputFileData%GenTrq_TLU)) then
      LB(1:1) = lbound(SrcInputFileData%GenTrq_TLU)
      UB(1:1) = ubound(SrcInputFileData%GenTrq_TLU)
      if (.not. allocated(DstInputFileData%GenTrq_TLU)) then
         allocate(DstInputFileData%GenTrq_TLU(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%GenTrq_TLU.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%GenTrq_TLU = SrcInputFileData%GenTrq_TLU
   end if
   DstInputFileData%UseLegacyInterface = SrcInputFileData%UseLegacyInterface
   DstInputFileData%NumBStC = SrcInputFileData%NumBStC
   if (allocated(SrcInputFileData%BStCfiles)) then
      LB(1:1) = lbound(SrcInputFileData%BStCfiles)
      UB(1:1) = ubound(SrcInputFileData%BStCfiles)
      if (.not. allocated(DstInputFileData%BStCfiles)) then
         allocate(DstInputFileData%BStCfiles(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%BStCfiles.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%BStCfiles = SrcInputFileData%BStCfiles
   end if
   DstInputFileData%NumNStC = SrcInputFileData%NumNStC
   if (allocated(SrcInputFileData%NStCfiles)) then
      LB(1:1) = lbound(SrcInputFileData%NStCfiles)
      UB(1:1) = ubound(SrcInputFileData%NStCfiles)
      if (.not. allocated(DstInputFileData%NStCfiles)) then
         allocate(DstInputFileData%NStCfiles(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%NStCfiles.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%NStCfiles = SrcInputFileData%NStCfiles
   end if
   DstInputFileData%NumTStC = SrcInputFileData%NumTStC
   if (allocated(SrcInputFileData%TStCfiles)) then
      LB(1:1) = lbound(SrcInputFileData%TStCfiles)
      UB(1:1) = ubound(SrcInputFileData%TStCfiles)
      if (.not. allocated(DstInputFileData%TStCfiles)) then
         allocate(DstInputFileData%TStCfiles(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%TStCfiles.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%TStCfiles = SrcInputFileData%TStCfiles
   end if
   DstInputFileData%NumSStC = SrcInputFileData%NumSStC
   if (allocated(SrcInputFileData%SStCfiles)) then
      LB(1:1) = lbound(SrcInputFileData%SStCfiles)
      UB(1:1) = ubound(SrcInputFileData%SStCfiles)
      if (.not. allocated(DstInputFileData%SStCfiles)) then
         allocate(DstInputFileData%SStCfiles(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%SStCfiles.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%SStCfiles = SrcInputFileData%SStCfiles
   end if
   DstInputFileData%AfCmode = SrcInputFileData%AfCmode
   DstInputFileData%AfC_Mean = SrcInputFileData%AfC_Mean
   DstInputFileData%AfC_Amp = SrcInputFileData%AfC_Amp
   DstInputFileData%AfC_Phase = SrcInputFileData%AfC_Phase
   DstInputFileData%CCmode = SrcInputFileData%CCmode
   DstInputFileData%EXavrSWAP = SrcInputFileData%EXavrSWAP
end subroutine

subroutine SrvD_DestroyInputFile(InputFileData, ErrStat, ErrMsg)
   type(SrvD_InputFile), intent(inout) :: InputFileData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SrvD_DestroyInputFile'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InputFileData%OutList)) then
      deallocate(InputFileData%OutList)
   end if
   if (allocated(InputFileData%GenSpd_TLU)) then
      deallocate(InputFileData%GenSpd_TLU)
   end if
   if (allocated(InputFileData%GenTrq_TLU)) then
      deallocate(InputFileData%GenTrq_TLU)
   end if
   if (allocated(InputFileData%BStCfiles)) then
      deallocate(InputFileData%BStCfiles)
   end if
   if (allocated(InputFileData%NStCfiles)) then
      deallocate(InputFileData%NStCfiles)
   end if
   if (allocated(InputFileData%TStCfiles)) then
      deallocate(InputFileData%TStCfiles)
   end if
   if (allocated(InputFileData%SStCfiles)) then
      deallocate(InputFileData%SStCfiles)
   end if
end subroutine

subroutine SrvD_PackInputFile(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SrvD_InputFile), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SrvD_PackInputFile'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DT)
   call RegPack(RF, InData%Echo)
   call RegPack(RF, InData%PCMode)
   call RegPack(RF, InData%TPCOn)
   call RegPack(RF, InData%TPitManS)
   call RegPack(RF, InData%PitManRat)
   call RegPack(RF, InData%BlPitchF)
   call RegPack(RF, InData%VSContrl)
   call RegPack(RF, InData%GenModel)
   call RegPack(RF, InData%GenEff)
   call RegPack(RF, InData%GenTiStr)
   call RegPack(RF, InData%GenTiStp)
   call RegPack(RF, InData%SpdGenOn)
   call RegPack(RF, InData%TimGenOn)
   call RegPack(RF, InData%TimGenOf)
   call RegPack(RF, InData%VS_RtGnSp)
   call RegPack(RF, InData%VS_RtTq)
   call RegPack(RF, InData%VS_Rgn2K)
   call RegPack(RF, InData%VS_SlPc)
   call RegPack(RF, InData%SIG_SlPc)
   call RegPack(RF, InData%SIG_SySp)
   call RegPack(RF, InData%SIG_RtTq)
   call RegPack(RF, InData%SIG_PORt)
   call RegPack(RF, InData%TEC_Freq)
   call RegPack(RF, InData%TEC_NPol)
   call RegPack(RF, InData%TEC_SRes)
   call RegPack(RF, InData%TEC_RRes)
   call RegPack(RF, InData%TEC_VLL)
   call RegPack(RF, InData%TEC_SLR)
   call RegPack(RF, InData%TEC_RLR)
   call RegPack(RF, InData%TEC_MR)
   call RegPack(RF, InData%HSSBrMode)
   call RegPack(RF, InData%THSSBrDp)
   call RegPack(RF, InData%HSSBrDT)
   call RegPack(RF, InData%HSSBrTqF)
   call RegPack(RF, InData%YCMode)
   call RegPack(RF, InData%TYCOn)
   call RegPack(RF, InData%YawNeut)
   call RegPack(RF, InData%YawSpr)
   call RegPack(RF, InData%YawDamp)
   call RegPack(RF, InData%TYawManS)
   call RegPack(RF, InData%YawManRat)
   call RegPack(RF, InData%NacYawF)
   call RegPack(RF, InData%SumPrint)
   call RegPack(RF, InData%OutFile)
   call RegPack(RF, InData%TabDelim)
   call RegPack(RF, InData%OutFmt)
   call RegPack(RF, InData%Tstart)
   call RegPack(RF, InData%NumOuts)
   call RegPackAlloc(RF, InData%OutList)
   call RegPack(RF, InData%DLL_FileName)
   call RegPack(RF, InData%DLL_ProcName)
   call RegPack(RF, InData%DLL_InFile)
   call RegPack(RF, InData%DLL_DT)
   call RegPack(RF, InData%DLL_Ramp)
   call RegPack(RF, InData%BPCutoff)
   call RegPack(RF, InData%NacYaw_North)
   call RegPack(RF, InData%Ptch_Cntrl)
   call RegPack(RF, InData%Ptch_SetPnt)
   call RegPack(RF, InData%Ptch_Min)
   call RegPack(RF, InData%Ptch_Max)
   call RegPack(RF, InData%PtchRate_Min)
   call RegPack(RF, InData%PtchRate_Max)
   call RegPack(RF, InData%Gain_OM)
   call RegPack(RF, InData%GenSpd_MinOM)
   call RegPack(RF, InData%GenSpd_MaxOM)
   call RegPack(RF, InData%GenSpd_Dem)
   call RegPack(RF, InData%GenTrq_Dem)
   call RegPack(RF, InData%GenPwr_Dem)
   call RegPack(RF, InData%DLL_NumTrq)
   call RegPackAlloc(RF, InData%GenSpd_TLU)
   call RegPackAlloc(RF, InData%GenTrq_TLU)
   call RegPack(RF, InData%UseLegacyInterface)
   call RegPack(RF, InData%NumBStC)
   call RegPackAlloc(RF, InData%BStCfiles)
   call RegPack(RF, InData%NumNStC)
   call RegPackAlloc(RF, InData%NStCfiles)
   call RegPack(RF, InData%NumTStC)
   call RegPackAlloc(RF, InData%TStCfiles)
   call RegPack(RF, InData%NumSStC)
   call RegPackAlloc(RF, InData%SStCfiles)
   call RegPack(RF, InData%AfCmode)
   call RegPack(RF, InData%AfC_Mean)
   call RegPack(RF, InData%AfC_Amp)
   call RegPack(RF, InData%AfC_Phase)
   call RegPack(RF, InData%CCmode)
   call RegPack(RF, InData%EXavrSWAP)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SrvD_UnPackInputFile(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SrvD_InputFile), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SrvD_UnPackInputFile'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Echo); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PCMode); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TPCOn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TPitManS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PitManRat); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BlPitchF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VSContrl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GenModel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GenEff); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GenTiStr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GenTiStp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SpdGenOn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TimGenOn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TimGenOf); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VS_RtGnSp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VS_RtTq); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VS_Rgn2K); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VS_SlPc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SIG_SlPc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SIG_SySp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SIG_RtTq); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SIG_PORt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TEC_Freq); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TEC_NPol); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TEC_SRes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TEC_RRes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TEC_VLL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TEC_SLR); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TEC_RLR); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TEC_MR); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HSSBrMode); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%THSSBrDp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HSSBrDT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HSSBrTqF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YCMode); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TYCOn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawNeut); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawSpr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawDamp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TYawManS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawManRat); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NacYawF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SumPrint); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TabDelim); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutFmt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Tstart); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%OutList); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DLL_FileName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DLL_ProcName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DLL_InFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DLL_DT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DLL_Ramp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BPCutoff); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NacYaw_North); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Ptch_Cntrl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Ptch_SetPnt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Ptch_Min); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Ptch_Max); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtchRate_Min); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtchRate_Max); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Gain_OM); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GenSpd_MinOM); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GenSpd_MaxOM); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GenSpd_Dem); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GenTrq_Dem); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GenPwr_Dem); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DLL_NumTrq); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%GenSpd_TLU); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%GenTrq_TLU); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UseLegacyInterface); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumBStC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BStCfiles); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumNStC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%NStCfiles); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumTStC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TStCfiles); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumSStC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%SStCfiles); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AfCmode); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AfC_Mean); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AfC_Amp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AfC_Phase); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CCmode); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%EXavrSWAP); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SrvD_CopyBladedDLLType(SrcBladedDLLTypeData, DstBladedDLLTypeData, CtrlCode, ErrStat, ErrMsg)
   type(BladedDLLType), intent(in) :: SrcBladedDLLTypeData
   type(BladedDLLType), intent(inout) :: DstBladedDLLTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SrvD_CopyBladedDLLType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcBladedDLLTypeData%avrSWAP)) then
      LB(1:1) = lbound(SrcBladedDLLTypeData%avrSWAP)
      UB(1:1) = ubound(SrcBladedDLLTypeData%avrSWAP)
      if (.not. allocated(DstBladedDLLTypeData%avrSWAP)) then
         allocate(DstBladedDLLTypeData%avrSWAP(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladedDLLTypeData%avrSWAP.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladedDLLTypeData%avrSWAP = SrcBladedDLLTypeData%avrSWAP
   end if
   DstBladedDLLTypeData%HSSBrTrqDemand = SrcBladedDLLTypeData%HSSBrTrqDemand
   DstBladedDLLTypeData%YawRateCom = SrcBladedDLLTypeData%YawRateCom
   DstBladedDLLTypeData%GenTrq = SrcBladedDLLTypeData%GenTrq
   DstBladedDLLTypeData%GenState = SrcBladedDLLTypeData%GenState
   DstBladedDLLTypeData%BlPitchCom = SrcBladedDLLTypeData%BlPitchCom
   DstBladedDLLTypeData%PrevBlPitch = SrcBladedDLLTypeData%PrevBlPitch
   DstBladedDLLTypeData%BlAirfoilCom = SrcBladedDLLTypeData%BlAirfoilCom
   DstBladedDLLTypeData%PrevBlAirfoilCom = SrcBladedDLLTypeData%PrevBlAirfoilCom
   DstBladedDLLTypeData%ElecPwr_prev = SrcBladedDLLTypeData%ElecPwr_prev
   DstBladedDLLTypeData%GenTrq_prev = SrcBladedDLLTypeData%GenTrq_prev
   DstBladedDLLTypeData%initialized = SrcBladedDLLTypeData%initialized
   DstBladedDLLTypeData%NumLogChannels = SrcBladedDLLTypeData%NumLogChannels
   if (allocated(SrcBladedDLLTypeData%LogChannels_OutParam)) then
      LB(1:1) = lbound(SrcBladedDLLTypeData%LogChannels_OutParam)
      UB(1:1) = ubound(SrcBladedDLLTypeData%LogChannels_OutParam)
      if (.not. allocated(DstBladedDLLTypeData%LogChannels_OutParam)) then
         allocate(DstBladedDLLTypeData%LogChannels_OutParam(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladedDLLTypeData%LogChannels_OutParam.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyOutParmType(SrcBladedDLLTypeData%LogChannels_OutParam(i1), DstBladedDLLTypeData%LogChannels_OutParam(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcBladedDLLTypeData%LogChannels)) then
      LB(1:1) = lbound(SrcBladedDLLTypeData%LogChannels)
      UB(1:1) = ubound(SrcBladedDLLTypeData%LogChannels)
      if (.not. allocated(DstBladedDLLTypeData%LogChannels)) then
         allocate(DstBladedDLLTypeData%LogChannels(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladedDLLTypeData%LogChannels.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladedDLLTypeData%LogChannels = SrcBladedDLLTypeData%LogChannels
   end if
   DstBladedDLLTypeData%ErrStat = SrcBladedDLLTypeData%ErrStat
   DstBladedDLLTypeData%ErrMsg = SrcBladedDLLTypeData%ErrMsg
   DstBladedDLLTypeData%CurrentTime = SrcBladedDLLTypeData%CurrentTime
   DstBladedDLLTypeData%SimStatus = SrcBladedDLLTypeData%SimStatus
   DstBladedDLLTypeData%ShaftBrakeStatusBinaryFlag = SrcBladedDLLTypeData%ShaftBrakeStatusBinaryFlag
   DstBladedDLLTypeData%HSSBrDeployed = SrcBladedDLLTypeData%HSSBrDeployed
   DstBladedDLLTypeData%TimeHSSBrFullyDeployed = SrcBladedDLLTypeData%TimeHSSBrFullyDeployed
   DstBladedDLLTypeData%TimeHSSBrDeployed = SrcBladedDLLTypeData%TimeHSSBrDeployed
   DstBladedDLLTypeData%OverrideYawRateWithTorque = SrcBladedDLLTypeData%OverrideYawRateWithTorque
   DstBladedDLLTypeData%YawTorqueDemand = SrcBladedDLLTypeData%YawTorqueDemand
   if (allocated(SrcBladedDLLTypeData%BlPitchInput)) then
      LB(1:1) = lbound(SrcBladedDLLTypeData%BlPitchInput)
      UB(1:1) = ubound(SrcBladedDLLTypeData%BlPitchInput)
      if (.not. allocated(DstBladedDLLTypeData%BlPitchInput)) then
         allocate(DstBladedDLLTypeData%BlPitchInput(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladedDLLTypeData%BlPitchInput.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladedDLLTypeData%BlPitchInput = SrcBladedDLLTypeData%BlPitchInput
   end if
   DstBladedDLLTypeData%YawAngleFromNorth = SrcBladedDLLTypeData%YawAngleFromNorth
   DstBladedDLLTypeData%HorWindV = SrcBladedDLLTypeData%HorWindV
   DstBladedDLLTypeData%HSS_Spd = SrcBladedDLLTypeData%HSS_Spd
   DstBladedDLLTypeData%YawErr = SrcBladedDLLTypeData%YawErr
   DstBladedDLLTypeData%RotSpeed = SrcBladedDLLTypeData%RotSpeed
   DstBladedDLLTypeData%YawBrTAxp = SrcBladedDLLTypeData%YawBrTAxp
   DstBladedDLLTypeData%YawBrTAyp = SrcBladedDLLTypeData%YawBrTAyp
   DstBladedDLLTypeData%LSSTipMys = SrcBladedDLLTypeData%LSSTipMys
   DstBladedDLLTypeData%LSSTipMzs = SrcBladedDLLTypeData%LSSTipMzs
   DstBladedDLLTypeData%LSSTipMya = SrcBladedDLLTypeData%LSSTipMya
   DstBladedDLLTypeData%LSSTipMza = SrcBladedDLLTypeData%LSSTipMza
   DstBladedDLLTypeData%LSSTipPxa = SrcBladedDLLTypeData%LSSTipPxa
   DstBladedDLLTypeData%Yaw = SrcBladedDLLTypeData%Yaw
   DstBladedDLLTypeData%YawRate = SrcBladedDLLTypeData%YawRate
   DstBladedDLLTypeData%YawBrMyn = SrcBladedDLLTypeData%YawBrMyn
   DstBladedDLLTypeData%YawBrMzn = SrcBladedDLLTypeData%YawBrMzn
   DstBladedDLLTypeData%NcIMURAxs = SrcBladedDLLTypeData%NcIMURAxs
   DstBladedDLLTypeData%NcIMURAys = SrcBladedDLLTypeData%NcIMURAys
   DstBladedDLLTypeData%NcIMURAzs = SrcBladedDLLTypeData%NcIMURAzs
   DstBladedDLLTypeData%RotPwr = SrcBladedDLLTypeData%RotPwr
   DstBladedDLLTypeData%LSSTipMxa = SrcBladedDLLTypeData%LSSTipMxa
   DstBladedDLLTypeData%RootMyc = SrcBladedDLLTypeData%RootMyc
   DstBladedDLLTypeData%RootMxc = SrcBladedDLLTypeData%RootMxc
   DstBladedDLLTypeData%LSShftFxa = SrcBladedDLLTypeData%LSShftFxa
   DstBladedDLLTypeData%LSShftFys = SrcBladedDLLTypeData%LSShftFys
   DstBladedDLLTypeData%LSShftFzs = SrcBladedDLLTypeData%LSShftFzs
   if (allocated(SrcBladedDLLTypeData%LidSpeed)) then
      LB(1:1) = lbound(SrcBladedDLLTypeData%LidSpeed)
      UB(1:1) = ubound(SrcBladedDLLTypeData%LidSpeed)
      if (.not. allocated(DstBladedDLLTypeData%LidSpeed)) then
         allocate(DstBladedDLLTypeData%LidSpeed(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladedDLLTypeData%LidSpeed.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladedDLLTypeData%LidSpeed = SrcBladedDLLTypeData%LidSpeed
   end if
   if (allocated(SrcBladedDLLTypeData%MsrPositionsX)) then
      LB(1:1) = lbound(SrcBladedDLLTypeData%MsrPositionsX)
      UB(1:1) = ubound(SrcBladedDLLTypeData%MsrPositionsX)
      if (.not. allocated(DstBladedDLLTypeData%MsrPositionsX)) then
         allocate(DstBladedDLLTypeData%MsrPositionsX(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladedDLLTypeData%MsrPositionsX.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladedDLLTypeData%MsrPositionsX = SrcBladedDLLTypeData%MsrPositionsX
   end if
   if (allocated(SrcBladedDLLTypeData%MsrPositionsY)) then
      LB(1:1) = lbound(SrcBladedDLLTypeData%MsrPositionsY)
      UB(1:1) = ubound(SrcBladedDLLTypeData%MsrPositionsY)
      if (.not. allocated(DstBladedDLLTypeData%MsrPositionsY)) then
         allocate(DstBladedDLLTypeData%MsrPositionsY(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladedDLLTypeData%MsrPositionsY.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladedDLLTypeData%MsrPositionsY = SrcBladedDLLTypeData%MsrPositionsY
   end if
   if (allocated(SrcBladedDLLTypeData%MsrPositionsZ)) then
      LB(1:1) = lbound(SrcBladedDLLTypeData%MsrPositionsZ)
      UB(1:1) = ubound(SrcBladedDLLTypeData%MsrPositionsZ)
      if (.not. allocated(DstBladedDLLTypeData%MsrPositionsZ)) then
         allocate(DstBladedDLLTypeData%MsrPositionsZ(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladedDLLTypeData%MsrPositionsZ.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladedDLLTypeData%MsrPositionsZ = SrcBladedDLLTypeData%MsrPositionsZ
   end if
   DstBladedDLLTypeData%SensorType = SrcBladedDLLTypeData%SensorType
   DstBladedDLLTypeData%NumBeam = SrcBladedDLLTypeData%NumBeam
   DstBladedDLLTypeData%NumPulseGate = SrcBladedDLLTypeData%NumPulseGate
   DstBladedDLLTypeData%DLL_DT = SrcBladedDLLTypeData%DLL_DT
   DstBladedDLLTypeData%DLL_InFile = SrcBladedDLLTypeData%DLL_InFile
   DstBladedDLLTypeData%RootName = SrcBladedDLLTypeData%RootName
   DstBladedDLLTypeData%GenTrq_Dem = SrcBladedDLLTypeData%GenTrq_Dem
   DstBladedDLLTypeData%GenSpd_Dem = SrcBladedDLLTypeData%GenSpd_Dem
   DstBladedDLLTypeData%Ptch_Max = SrcBladedDLLTypeData%Ptch_Max
   DstBladedDLLTypeData%Ptch_Min = SrcBladedDLLTypeData%Ptch_Min
   DstBladedDLLTypeData%Ptch_SetPnt = SrcBladedDLLTypeData%Ptch_SetPnt
   DstBladedDLLTypeData%PtchRate_Max = SrcBladedDLLTypeData%PtchRate_Max
   DstBladedDLLTypeData%PtchRate_Min = SrcBladedDLLTypeData%PtchRate_Min
   DstBladedDLLTypeData%GenPwr_Dem = SrcBladedDLLTypeData%GenPwr_Dem
   DstBladedDLLTypeData%Gain_OM = SrcBladedDLLTypeData%Gain_OM
   DstBladedDLLTypeData%GenSpd_MaxOM = SrcBladedDLLTypeData%GenSpd_MaxOM
   DstBladedDLLTypeData%GenSpd_MinOM = SrcBladedDLLTypeData%GenSpd_MinOM
   DstBladedDLLTypeData%Ptch_Cntrl = SrcBladedDLLTypeData%Ptch_Cntrl
   DstBladedDLLTypeData%DLL_NumTrq = SrcBladedDLLTypeData%DLL_NumTrq
   if (allocated(SrcBladedDLLTypeData%GenSpd_TLU)) then
      LB(1:1) = lbound(SrcBladedDLLTypeData%GenSpd_TLU)
      UB(1:1) = ubound(SrcBladedDLLTypeData%GenSpd_TLU)
      if (.not. allocated(DstBladedDLLTypeData%GenSpd_TLU)) then
         allocate(DstBladedDLLTypeData%GenSpd_TLU(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladedDLLTypeData%GenSpd_TLU.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladedDLLTypeData%GenSpd_TLU = SrcBladedDLLTypeData%GenSpd_TLU
   end if
   if (allocated(SrcBladedDLLTypeData%GenTrq_TLU)) then
      LB(1:1) = lbound(SrcBladedDLLTypeData%GenTrq_TLU)
      UB(1:1) = ubound(SrcBladedDLLTypeData%GenTrq_TLU)
      if (.not. allocated(DstBladedDLLTypeData%GenTrq_TLU)) then
         allocate(DstBladedDLLTypeData%GenTrq_TLU(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladedDLLTypeData%GenTrq_TLU.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladedDLLTypeData%GenTrq_TLU = SrcBladedDLLTypeData%GenTrq_TLU
   end if
   DstBladedDLLTypeData%Yaw_Cntrl = SrcBladedDLLTypeData%Yaw_Cntrl
   if (allocated(SrcBladedDLLTypeData%PrevCableDeltaL)) then
      LB(1:1) = lbound(SrcBladedDLLTypeData%PrevCableDeltaL)
      UB(1:1) = ubound(SrcBladedDLLTypeData%PrevCableDeltaL)
      if (.not. allocated(DstBladedDLLTypeData%PrevCableDeltaL)) then
         allocate(DstBladedDLLTypeData%PrevCableDeltaL(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladedDLLTypeData%PrevCableDeltaL.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladedDLLTypeData%PrevCableDeltaL = SrcBladedDLLTypeData%PrevCableDeltaL
   end if
   if (allocated(SrcBladedDLLTypeData%PrevCableDeltaLdot)) then
      LB(1:1) = lbound(SrcBladedDLLTypeData%PrevCableDeltaLdot)
      UB(1:1) = ubound(SrcBladedDLLTypeData%PrevCableDeltaLdot)
      if (.not. allocated(DstBladedDLLTypeData%PrevCableDeltaLdot)) then
         allocate(DstBladedDLLTypeData%PrevCableDeltaLdot(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladedDLLTypeData%PrevCableDeltaLdot.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladedDLLTypeData%PrevCableDeltaLdot = SrcBladedDLLTypeData%PrevCableDeltaLdot
   end if
   if (allocated(SrcBladedDLLTypeData%CableDeltaL)) then
      LB(1:1) = lbound(SrcBladedDLLTypeData%CableDeltaL)
      UB(1:1) = ubound(SrcBladedDLLTypeData%CableDeltaL)
      if (.not. allocated(DstBladedDLLTypeData%CableDeltaL)) then
         allocate(DstBladedDLLTypeData%CableDeltaL(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladedDLLTypeData%CableDeltaL.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladedDLLTypeData%CableDeltaL = SrcBladedDLLTypeData%CableDeltaL
   end if
   if (allocated(SrcBladedDLLTypeData%CableDeltaLdot)) then
      LB(1:1) = lbound(SrcBladedDLLTypeData%CableDeltaLdot)
      UB(1:1) = ubound(SrcBladedDLLTypeData%CableDeltaLdot)
      if (.not. allocated(DstBladedDLLTypeData%CableDeltaLdot)) then
         allocate(DstBladedDLLTypeData%CableDeltaLdot(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladedDLLTypeData%CableDeltaLdot.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladedDLLTypeData%CableDeltaLdot = SrcBladedDLLTypeData%CableDeltaLdot
   end if
   if (allocated(SrcBladedDLLTypeData%PrevStCCmdStiff)) then
      LB(1:2) = lbound(SrcBladedDLLTypeData%PrevStCCmdStiff)
      UB(1:2) = ubound(SrcBladedDLLTypeData%PrevStCCmdStiff)
      if (.not. allocated(DstBladedDLLTypeData%PrevStCCmdStiff)) then
         allocate(DstBladedDLLTypeData%PrevStCCmdStiff(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladedDLLTypeData%PrevStCCmdStiff.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladedDLLTypeData%PrevStCCmdStiff = SrcBladedDLLTypeData%PrevStCCmdStiff
   end if
   if (allocated(SrcBladedDLLTypeData%PrevStCCmdDamp)) then
      LB(1:2) = lbound(SrcBladedDLLTypeData%PrevStCCmdDamp)
      UB(1:2) = ubound(SrcBladedDLLTypeData%PrevStCCmdDamp)
      if (.not. allocated(DstBladedDLLTypeData%PrevStCCmdDamp)) then
         allocate(DstBladedDLLTypeData%PrevStCCmdDamp(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladedDLLTypeData%PrevStCCmdDamp.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladedDLLTypeData%PrevStCCmdDamp = SrcBladedDLLTypeData%PrevStCCmdDamp
   end if
   if (allocated(SrcBladedDLLTypeData%PrevStCCmdBrake)) then
      LB(1:2) = lbound(SrcBladedDLLTypeData%PrevStCCmdBrake)
      UB(1:2) = ubound(SrcBladedDLLTypeData%PrevStCCmdBrake)
      if (.not. allocated(DstBladedDLLTypeData%PrevStCCmdBrake)) then
         allocate(DstBladedDLLTypeData%PrevStCCmdBrake(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladedDLLTypeData%PrevStCCmdBrake.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladedDLLTypeData%PrevStCCmdBrake = SrcBladedDLLTypeData%PrevStCCmdBrake
   end if
   if (allocated(SrcBladedDLLTypeData%PrevStCCmdForce)) then
      LB(1:2) = lbound(SrcBladedDLLTypeData%PrevStCCmdForce)
      UB(1:2) = ubound(SrcBladedDLLTypeData%PrevStCCmdForce)
      if (.not. allocated(DstBladedDLLTypeData%PrevStCCmdForce)) then
         allocate(DstBladedDLLTypeData%PrevStCCmdForce(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladedDLLTypeData%PrevStCCmdForce.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladedDLLTypeData%PrevStCCmdForce = SrcBladedDLLTypeData%PrevStCCmdForce
   end if
   if (allocated(SrcBladedDLLTypeData%StCCmdStiff)) then
      LB(1:2) = lbound(SrcBladedDLLTypeData%StCCmdStiff)
      UB(1:2) = ubound(SrcBladedDLLTypeData%StCCmdStiff)
      if (.not. allocated(DstBladedDLLTypeData%StCCmdStiff)) then
         allocate(DstBladedDLLTypeData%StCCmdStiff(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladedDLLTypeData%StCCmdStiff.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladedDLLTypeData%StCCmdStiff = SrcBladedDLLTypeData%StCCmdStiff
   end if
   if (allocated(SrcBladedDLLTypeData%StCCmdDamp)) then
      LB(1:2) = lbound(SrcBladedDLLTypeData%StCCmdDamp)
      UB(1:2) = ubound(SrcBladedDLLTypeData%StCCmdDamp)
      if (.not. allocated(DstBladedDLLTypeData%StCCmdDamp)) then
         allocate(DstBladedDLLTypeData%StCCmdDamp(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladedDLLTypeData%StCCmdDamp.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladedDLLTypeData%StCCmdDamp = SrcBladedDLLTypeData%StCCmdDamp
   end if
   if (allocated(SrcBladedDLLTypeData%StCCmdBrake)) then
      LB(1:2) = lbound(SrcBladedDLLTypeData%StCCmdBrake)
      UB(1:2) = ubound(SrcBladedDLLTypeData%StCCmdBrake)
      if (.not. allocated(DstBladedDLLTypeData%StCCmdBrake)) then
         allocate(DstBladedDLLTypeData%StCCmdBrake(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladedDLLTypeData%StCCmdBrake.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladedDLLTypeData%StCCmdBrake = SrcBladedDLLTypeData%StCCmdBrake
   end if
   if (allocated(SrcBladedDLLTypeData%StCCmdForce)) then
      LB(1:2) = lbound(SrcBladedDLLTypeData%StCCmdForce)
      UB(1:2) = ubound(SrcBladedDLLTypeData%StCCmdForce)
      if (.not. allocated(DstBladedDLLTypeData%StCCmdForce)) then
         allocate(DstBladedDLLTypeData%StCCmdForce(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladedDLLTypeData%StCCmdForce.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladedDLLTypeData%StCCmdForce = SrcBladedDLLTypeData%StCCmdForce
   end if
   if (allocated(SrcBladedDLLTypeData%StCMeasDisp)) then
      LB(1:2) = lbound(SrcBladedDLLTypeData%StCMeasDisp)
      UB(1:2) = ubound(SrcBladedDLLTypeData%StCMeasDisp)
      if (.not. allocated(DstBladedDLLTypeData%StCMeasDisp)) then
         allocate(DstBladedDLLTypeData%StCMeasDisp(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladedDLLTypeData%StCMeasDisp.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladedDLLTypeData%StCMeasDisp = SrcBladedDLLTypeData%StCMeasDisp
   end if
   if (allocated(SrcBladedDLLTypeData%StCMeasVel)) then
      LB(1:2) = lbound(SrcBladedDLLTypeData%StCMeasVel)
      UB(1:2) = ubound(SrcBladedDLLTypeData%StCMeasVel)
      if (.not. allocated(DstBladedDLLTypeData%StCMeasVel)) then
         allocate(DstBladedDLLTypeData%StCMeasVel(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladedDLLTypeData%StCMeasVel.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladedDLLTypeData%StCMeasVel = SrcBladedDLLTypeData%StCMeasVel
   end if
end subroutine

subroutine SrvD_DestroyBladedDLLType(BladedDLLTypeData, ErrStat, ErrMsg)
   type(BladedDLLType), intent(inout) :: BladedDLLTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SrvD_DestroyBladedDLLType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(BladedDLLTypeData%avrSWAP)) then
      deallocate(BladedDLLTypeData%avrSWAP)
   end if
   if (allocated(BladedDLLTypeData%LogChannels_OutParam)) then
      LB(1:1) = lbound(BladedDLLTypeData%LogChannels_OutParam)
      UB(1:1) = ubound(BladedDLLTypeData%LogChannels_OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyOutParmType(BladedDLLTypeData%LogChannels_OutParam(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(BladedDLLTypeData%LogChannels_OutParam)
   end if
   if (allocated(BladedDLLTypeData%LogChannels)) then
      deallocate(BladedDLLTypeData%LogChannels)
   end if
   if (allocated(BladedDLLTypeData%BlPitchInput)) then
      deallocate(BladedDLLTypeData%BlPitchInput)
   end if
   if (allocated(BladedDLLTypeData%LidSpeed)) then
      deallocate(BladedDLLTypeData%LidSpeed)
   end if
   if (allocated(BladedDLLTypeData%MsrPositionsX)) then
      deallocate(BladedDLLTypeData%MsrPositionsX)
   end if
   if (allocated(BladedDLLTypeData%MsrPositionsY)) then
      deallocate(BladedDLLTypeData%MsrPositionsY)
   end if
   if (allocated(BladedDLLTypeData%MsrPositionsZ)) then
      deallocate(BladedDLLTypeData%MsrPositionsZ)
   end if
   if (allocated(BladedDLLTypeData%GenSpd_TLU)) then
      deallocate(BladedDLLTypeData%GenSpd_TLU)
   end if
   if (allocated(BladedDLLTypeData%GenTrq_TLU)) then
      deallocate(BladedDLLTypeData%GenTrq_TLU)
   end if
   if (allocated(BladedDLLTypeData%PrevCableDeltaL)) then
      deallocate(BladedDLLTypeData%PrevCableDeltaL)
   end if
   if (allocated(BladedDLLTypeData%PrevCableDeltaLdot)) then
      deallocate(BladedDLLTypeData%PrevCableDeltaLdot)
   end if
   if (allocated(BladedDLLTypeData%CableDeltaL)) then
      deallocate(BladedDLLTypeData%CableDeltaL)
   end if
   if (allocated(BladedDLLTypeData%CableDeltaLdot)) then
      deallocate(BladedDLLTypeData%CableDeltaLdot)
   end if
   if (allocated(BladedDLLTypeData%PrevStCCmdStiff)) then
      deallocate(BladedDLLTypeData%PrevStCCmdStiff)
   end if
   if (allocated(BladedDLLTypeData%PrevStCCmdDamp)) then
      deallocate(BladedDLLTypeData%PrevStCCmdDamp)
   end if
   if (allocated(BladedDLLTypeData%PrevStCCmdBrake)) then
      deallocate(BladedDLLTypeData%PrevStCCmdBrake)
   end if
   if (allocated(BladedDLLTypeData%PrevStCCmdForce)) then
      deallocate(BladedDLLTypeData%PrevStCCmdForce)
   end if
   if (allocated(BladedDLLTypeData%StCCmdStiff)) then
      deallocate(BladedDLLTypeData%StCCmdStiff)
   end if
   if (allocated(BladedDLLTypeData%StCCmdDamp)) then
      deallocate(BladedDLLTypeData%StCCmdDamp)
   end if
   if (allocated(BladedDLLTypeData%StCCmdBrake)) then
      deallocate(BladedDLLTypeData%StCCmdBrake)
   end if
   if (allocated(BladedDLLTypeData%StCCmdForce)) then
      deallocate(BladedDLLTypeData%StCCmdForce)
   end if
   if (allocated(BladedDLLTypeData%StCMeasDisp)) then
      deallocate(BladedDLLTypeData%StCMeasDisp)
   end if
   if (allocated(BladedDLLTypeData%StCMeasVel)) then
      deallocate(BladedDLLTypeData%StCMeasVel)
   end if
end subroutine

subroutine SrvD_PackBladedDLLType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(BladedDLLType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SrvD_PackBladedDLLType'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%avrSWAP)
   call RegPack(RF, InData%HSSBrTrqDemand)
   call RegPack(RF, InData%YawRateCom)
   call RegPack(RF, InData%GenTrq)
   call RegPack(RF, InData%GenState)
   call RegPack(RF, InData%BlPitchCom)
   call RegPack(RF, InData%PrevBlPitch)
   call RegPack(RF, InData%BlAirfoilCom)
   call RegPack(RF, InData%PrevBlAirfoilCom)
   call RegPack(RF, InData%ElecPwr_prev)
   call RegPack(RF, InData%GenTrq_prev)
   call RegPack(RF, InData%initialized)
   call RegPack(RF, InData%NumLogChannels)
   call RegPack(RF, allocated(InData%LogChannels_OutParam))
   if (allocated(InData%LogChannels_OutParam)) then
      call RegPackBounds(RF, 1, lbound(InData%LogChannels_OutParam), ubound(InData%LogChannels_OutParam))
      LB(1:1) = lbound(InData%LogChannels_OutParam)
      UB(1:1) = ubound(InData%LogChannels_OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackOutParmType(RF, InData%LogChannels_OutParam(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%LogChannels)
   call RegPack(RF, InData%ErrStat)
   call RegPack(RF, InData%ErrMsg)
   call RegPack(RF, InData%CurrentTime)
   call RegPack(RF, InData%SimStatus)
   call RegPack(RF, InData%ShaftBrakeStatusBinaryFlag)
   call RegPack(RF, InData%HSSBrDeployed)
   call RegPack(RF, InData%TimeHSSBrFullyDeployed)
   call RegPack(RF, InData%TimeHSSBrDeployed)
   call RegPack(RF, InData%OverrideYawRateWithTorque)
   call RegPack(RF, InData%YawTorqueDemand)
   call RegPackAlloc(RF, InData%BlPitchInput)
   call RegPack(RF, InData%YawAngleFromNorth)
   call RegPack(RF, InData%HorWindV)
   call RegPack(RF, InData%HSS_Spd)
   call RegPack(RF, InData%YawErr)
   call RegPack(RF, InData%RotSpeed)
   call RegPack(RF, InData%YawBrTAxp)
   call RegPack(RF, InData%YawBrTAyp)
   call RegPack(RF, InData%LSSTipMys)
   call RegPack(RF, InData%LSSTipMzs)
   call RegPack(RF, InData%LSSTipMya)
   call RegPack(RF, InData%LSSTipMza)
   call RegPack(RF, InData%LSSTipPxa)
   call RegPack(RF, InData%Yaw)
   call RegPack(RF, InData%YawRate)
   call RegPack(RF, InData%YawBrMyn)
   call RegPack(RF, InData%YawBrMzn)
   call RegPack(RF, InData%NcIMURAxs)
   call RegPack(RF, InData%NcIMURAys)
   call RegPack(RF, InData%NcIMURAzs)
   call RegPack(RF, InData%RotPwr)
   call RegPack(RF, InData%LSSTipMxa)
   call RegPack(RF, InData%RootMyc)
   call RegPack(RF, InData%RootMxc)
   call RegPack(RF, InData%LSShftFxa)
   call RegPack(RF, InData%LSShftFys)
   call RegPack(RF, InData%LSShftFzs)
   call RegPackAlloc(RF, InData%LidSpeed)
   call RegPackAlloc(RF, InData%MsrPositionsX)
   call RegPackAlloc(RF, InData%MsrPositionsY)
   call RegPackAlloc(RF, InData%MsrPositionsZ)
   call RegPack(RF, InData%SensorType)
   call RegPack(RF, InData%NumBeam)
   call RegPack(RF, InData%NumPulseGate)
   call RegPack(RF, InData%DLL_DT)
   call RegPack(RF, InData%DLL_InFile)
   call RegPack(RF, InData%RootName)
   call RegPack(RF, InData%GenTrq_Dem)
   call RegPack(RF, InData%GenSpd_Dem)
   call RegPack(RF, InData%Ptch_Max)
   call RegPack(RF, InData%Ptch_Min)
   call RegPack(RF, InData%Ptch_SetPnt)
   call RegPack(RF, InData%PtchRate_Max)
   call RegPack(RF, InData%PtchRate_Min)
   call RegPack(RF, InData%GenPwr_Dem)
   call RegPack(RF, InData%Gain_OM)
   call RegPack(RF, InData%GenSpd_MaxOM)
   call RegPack(RF, InData%GenSpd_MinOM)
   call RegPack(RF, InData%Ptch_Cntrl)
   call RegPack(RF, InData%DLL_NumTrq)
   call RegPackAlloc(RF, InData%GenSpd_TLU)
   call RegPackAlloc(RF, InData%GenTrq_TLU)
   call RegPack(RF, InData%Yaw_Cntrl)
   call RegPackAlloc(RF, InData%PrevCableDeltaL)
   call RegPackAlloc(RF, InData%PrevCableDeltaLdot)
   call RegPackAlloc(RF, InData%CableDeltaL)
   call RegPackAlloc(RF, InData%CableDeltaLdot)
   call RegPackAlloc(RF, InData%PrevStCCmdStiff)
   call RegPackAlloc(RF, InData%PrevStCCmdDamp)
   call RegPackAlloc(RF, InData%PrevStCCmdBrake)
   call RegPackAlloc(RF, InData%PrevStCCmdForce)
   call RegPackAlloc(RF, InData%StCCmdStiff)
   call RegPackAlloc(RF, InData%StCCmdDamp)
   call RegPackAlloc(RF, InData%StCCmdBrake)
   call RegPackAlloc(RF, InData%StCCmdForce)
   call RegPackAlloc(RF, InData%StCMeasDisp)
   call RegPackAlloc(RF, InData%StCMeasVel)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SrvD_UnPackBladedDLLType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(BladedDLLType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SrvD_UnPackBladedDLLType'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%avrSWAP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HSSBrTrqDemand); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawRateCom); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GenTrq); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GenState); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BlPitchCom); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PrevBlPitch); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BlAirfoilCom); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PrevBlAirfoilCom); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ElecPwr_prev); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GenTrq_prev); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%initialized); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumLogChannels); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%LogChannels_OutParam)) deallocate(OutData%LogChannels_OutParam)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%LogChannels_OutParam(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%LogChannels_OutParam.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackOutParmType(RF, OutData%LogChannels_OutParam(i1)) ! LogChannels_OutParam 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%LogChannels); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ErrStat); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ErrMsg); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CurrentTime); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SimStatus); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ShaftBrakeStatusBinaryFlag); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HSSBrDeployed); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TimeHSSBrFullyDeployed); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TimeHSSBrDeployed); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OverrideYawRateWithTorque); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawTorqueDemand); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BlPitchInput); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawAngleFromNorth); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HorWindV); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HSS_Spd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawErr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RotSpeed); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawBrTAxp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawBrTAyp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LSSTipMys); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LSSTipMzs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LSSTipMya); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LSSTipMza); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LSSTipPxa); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Yaw); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawRate); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawBrMyn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawBrMzn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NcIMURAxs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NcIMURAys); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NcIMURAzs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RotPwr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LSSTipMxa); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootMyc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootMxc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LSShftFxa); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LSShftFys); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LSShftFzs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LidSpeed); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%MsrPositionsX); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%MsrPositionsY); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%MsrPositionsZ); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SensorType); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumBeam); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumPulseGate); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DLL_DT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DLL_InFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GenTrq_Dem); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GenSpd_Dem); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Ptch_Max); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Ptch_Min); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Ptch_SetPnt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtchRate_Max); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtchRate_Min); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GenPwr_Dem); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Gain_OM); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GenSpd_MaxOM); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GenSpd_MinOM); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Ptch_Cntrl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DLL_NumTrq); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%GenSpd_TLU); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%GenTrq_TLU); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Yaw_Cntrl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PrevCableDeltaL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PrevCableDeltaLdot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%CableDeltaL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%CableDeltaLdot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PrevStCCmdStiff); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PrevStCCmdDamp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PrevStCCmdBrake); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PrevStCCmdForce); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%StCCmdStiff); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%StCCmdDamp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%StCCmdBrake); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%StCCmdForce); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%StCMeasDisp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%StCMeasVel); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SrvD_CopyContState(SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg)
   type(SrvD_ContinuousStateType), intent(in) :: SrcContStateData
   type(SrvD_ContinuousStateType), intent(inout) :: DstContStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SrvD_CopyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstContStateData%DummyContState = SrcContStateData%DummyContState
   if (allocated(SrcContStateData%BStC)) then
      LB(1:1) = lbound(SrcContStateData%BStC)
      UB(1:1) = ubound(SrcContStateData%BStC)
      if (.not. allocated(DstContStateData%BStC)) then
         allocate(DstContStateData%BStC(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstContStateData%BStC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call StC_CopyContState(SrcContStateData%BStC(i1), DstContStateData%BStC(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcContStateData%NStC)) then
      LB(1:1) = lbound(SrcContStateData%NStC)
      UB(1:1) = ubound(SrcContStateData%NStC)
      if (.not. allocated(DstContStateData%NStC)) then
         allocate(DstContStateData%NStC(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstContStateData%NStC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call StC_CopyContState(SrcContStateData%NStC(i1), DstContStateData%NStC(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcContStateData%TStC)) then
      LB(1:1) = lbound(SrcContStateData%TStC)
      UB(1:1) = ubound(SrcContStateData%TStC)
      if (.not. allocated(DstContStateData%TStC)) then
         allocate(DstContStateData%TStC(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstContStateData%TStC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call StC_CopyContState(SrcContStateData%TStC(i1), DstContStateData%TStC(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcContStateData%SStC)) then
      LB(1:1) = lbound(SrcContStateData%SStC)
      UB(1:1) = ubound(SrcContStateData%SStC)
      if (.not. allocated(DstContStateData%SStC)) then
         allocate(DstContStateData%SStC(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstContStateData%SStC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call StC_CopyContState(SrcContStateData%SStC(i1), DstContStateData%SStC(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
end subroutine

subroutine SrvD_DestroyContState(ContStateData, ErrStat, ErrMsg)
   type(SrvD_ContinuousStateType), intent(inout) :: ContStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SrvD_DestroyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ContStateData%BStC)) then
      LB(1:1) = lbound(ContStateData%BStC)
      UB(1:1) = ubound(ContStateData%BStC)
      do i1 = LB(1), UB(1)
         call StC_DestroyContState(ContStateData%BStC(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ContStateData%BStC)
   end if
   if (allocated(ContStateData%NStC)) then
      LB(1:1) = lbound(ContStateData%NStC)
      UB(1:1) = ubound(ContStateData%NStC)
      do i1 = LB(1), UB(1)
         call StC_DestroyContState(ContStateData%NStC(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ContStateData%NStC)
   end if
   if (allocated(ContStateData%TStC)) then
      LB(1:1) = lbound(ContStateData%TStC)
      UB(1:1) = ubound(ContStateData%TStC)
      do i1 = LB(1), UB(1)
         call StC_DestroyContState(ContStateData%TStC(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ContStateData%TStC)
   end if
   if (allocated(ContStateData%SStC)) then
      LB(1:1) = lbound(ContStateData%SStC)
      UB(1:1) = ubound(ContStateData%SStC)
      do i1 = LB(1), UB(1)
         call StC_DestroyContState(ContStateData%SStC(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ContStateData%SStC)
   end if
end subroutine

subroutine SrvD_PackContState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SrvD_ContinuousStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SrvD_PackContState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyContState)
   call RegPack(RF, allocated(InData%BStC))
   if (allocated(InData%BStC)) then
      call RegPackBounds(RF, 1, lbound(InData%BStC), ubound(InData%BStC))
      LB(1:1) = lbound(InData%BStC)
      UB(1:1) = ubound(InData%BStC)
      do i1 = LB(1), UB(1)
         call StC_PackContState(RF, InData%BStC(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%NStC))
   if (allocated(InData%NStC)) then
      call RegPackBounds(RF, 1, lbound(InData%NStC), ubound(InData%NStC))
      LB(1:1) = lbound(InData%NStC)
      UB(1:1) = ubound(InData%NStC)
      do i1 = LB(1), UB(1)
         call StC_PackContState(RF, InData%NStC(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%TStC))
   if (allocated(InData%TStC)) then
      call RegPackBounds(RF, 1, lbound(InData%TStC), ubound(InData%TStC))
      LB(1:1) = lbound(InData%TStC)
      UB(1:1) = ubound(InData%TStC)
      do i1 = LB(1), UB(1)
         call StC_PackContState(RF, InData%TStC(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%SStC))
   if (allocated(InData%SStC)) then
      call RegPackBounds(RF, 1, lbound(InData%SStC), ubound(InData%SStC))
      LB(1:1) = lbound(InData%SStC)
      UB(1:1) = ubound(InData%SStC)
      do i1 = LB(1), UB(1)
         call StC_PackContState(RF, InData%SStC(i1)) 
      end do
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SrvD_UnPackContState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SrvD_ContinuousStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SrvD_UnPackContState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyContState); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%BStC)) deallocate(OutData%BStC)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BStC(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BStC.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call StC_UnpackContState(RF, OutData%BStC(i1)) ! BStC 
      end do
   end if
   if (allocated(OutData%NStC)) deallocate(OutData%NStC)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%NStC(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%NStC.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call StC_UnpackContState(RF, OutData%NStC(i1)) ! NStC 
      end do
   end if
   if (allocated(OutData%TStC)) deallocate(OutData%TStC)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%TStC(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%TStC.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call StC_UnpackContState(RF, OutData%TStC(i1)) ! TStC 
      end do
   end if
   if (allocated(OutData%SStC)) deallocate(OutData%SStC)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%SStC(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%SStC.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call StC_UnpackContState(RF, OutData%SStC(i1)) ! SStC 
      end do
   end if
end subroutine

subroutine SrvD_CopyDiscState(SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg)
   type(SrvD_DiscreteStateType), intent(in) :: SrcDiscStateData
   type(SrvD_DiscreteStateType), intent(inout) :: DstDiscStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SrvD_CopyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstDiscStateData%CtrlOffset = SrcDiscStateData%CtrlOffset
   if (allocated(SrcDiscStateData%BStC)) then
      LB(1:1) = lbound(SrcDiscStateData%BStC)
      UB(1:1) = ubound(SrcDiscStateData%BStC)
      if (.not. allocated(DstDiscStateData%BStC)) then
         allocate(DstDiscStateData%BStC(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%BStC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call StC_CopyDiscState(SrcDiscStateData%BStC(i1), DstDiscStateData%BStC(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcDiscStateData%NStC)) then
      LB(1:1) = lbound(SrcDiscStateData%NStC)
      UB(1:1) = ubound(SrcDiscStateData%NStC)
      if (.not. allocated(DstDiscStateData%NStC)) then
         allocate(DstDiscStateData%NStC(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%NStC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call StC_CopyDiscState(SrcDiscStateData%NStC(i1), DstDiscStateData%NStC(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcDiscStateData%TStC)) then
      LB(1:1) = lbound(SrcDiscStateData%TStC)
      UB(1:1) = ubound(SrcDiscStateData%TStC)
      if (.not. allocated(DstDiscStateData%TStC)) then
         allocate(DstDiscStateData%TStC(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%TStC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call StC_CopyDiscState(SrcDiscStateData%TStC(i1), DstDiscStateData%TStC(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcDiscStateData%SStC)) then
      LB(1:1) = lbound(SrcDiscStateData%SStC)
      UB(1:1) = ubound(SrcDiscStateData%SStC)
      if (.not. allocated(DstDiscStateData%SStC)) then
         allocate(DstDiscStateData%SStC(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%SStC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call StC_CopyDiscState(SrcDiscStateData%SStC(i1), DstDiscStateData%SStC(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
end subroutine

subroutine SrvD_DestroyDiscState(DiscStateData, ErrStat, ErrMsg)
   type(SrvD_DiscreteStateType), intent(inout) :: DiscStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SrvD_DestroyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(DiscStateData%BStC)) then
      LB(1:1) = lbound(DiscStateData%BStC)
      UB(1:1) = ubound(DiscStateData%BStC)
      do i1 = LB(1), UB(1)
         call StC_DestroyDiscState(DiscStateData%BStC(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(DiscStateData%BStC)
   end if
   if (allocated(DiscStateData%NStC)) then
      LB(1:1) = lbound(DiscStateData%NStC)
      UB(1:1) = ubound(DiscStateData%NStC)
      do i1 = LB(1), UB(1)
         call StC_DestroyDiscState(DiscStateData%NStC(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(DiscStateData%NStC)
   end if
   if (allocated(DiscStateData%TStC)) then
      LB(1:1) = lbound(DiscStateData%TStC)
      UB(1:1) = ubound(DiscStateData%TStC)
      do i1 = LB(1), UB(1)
         call StC_DestroyDiscState(DiscStateData%TStC(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(DiscStateData%TStC)
   end if
   if (allocated(DiscStateData%SStC)) then
      LB(1:1) = lbound(DiscStateData%SStC)
      UB(1:1) = ubound(DiscStateData%SStC)
      do i1 = LB(1), UB(1)
         call StC_DestroyDiscState(DiscStateData%SStC(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(DiscStateData%SStC)
   end if
end subroutine

subroutine SrvD_PackDiscState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SrvD_DiscreteStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SrvD_PackDiscState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%CtrlOffset)
   call RegPack(RF, allocated(InData%BStC))
   if (allocated(InData%BStC)) then
      call RegPackBounds(RF, 1, lbound(InData%BStC), ubound(InData%BStC))
      LB(1:1) = lbound(InData%BStC)
      UB(1:1) = ubound(InData%BStC)
      do i1 = LB(1), UB(1)
         call StC_PackDiscState(RF, InData%BStC(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%NStC))
   if (allocated(InData%NStC)) then
      call RegPackBounds(RF, 1, lbound(InData%NStC), ubound(InData%NStC))
      LB(1:1) = lbound(InData%NStC)
      UB(1:1) = ubound(InData%NStC)
      do i1 = LB(1), UB(1)
         call StC_PackDiscState(RF, InData%NStC(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%TStC))
   if (allocated(InData%TStC)) then
      call RegPackBounds(RF, 1, lbound(InData%TStC), ubound(InData%TStC))
      LB(1:1) = lbound(InData%TStC)
      UB(1:1) = ubound(InData%TStC)
      do i1 = LB(1), UB(1)
         call StC_PackDiscState(RF, InData%TStC(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%SStC))
   if (allocated(InData%SStC)) then
      call RegPackBounds(RF, 1, lbound(InData%SStC), ubound(InData%SStC))
      LB(1:1) = lbound(InData%SStC)
      UB(1:1) = ubound(InData%SStC)
      do i1 = LB(1), UB(1)
         call StC_PackDiscState(RF, InData%SStC(i1)) 
      end do
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SrvD_UnPackDiscState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SrvD_DiscreteStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SrvD_UnPackDiscState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%CtrlOffset); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%BStC)) deallocate(OutData%BStC)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BStC(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BStC.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call StC_UnpackDiscState(RF, OutData%BStC(i1)) ! BStC 
      end do
   end if
   if (allocated(OutData%NStC)) deallocate(OutData%NStC)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%NStC(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%NStC.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call StC_UnpackDiscState(RF, OutData%NStC(i1)) ! NStC 
      end do
   end if
   if (allocated(OutData%TStC)) deallocate(OutData%TStC)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%TStC(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%TStC.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call StC_UnpackDiscState(RF, OutData%TStC(i1)) ! TStC 
      end do
   end if
   if (allocated(OutData%SStC)) deallocate(OutData%SStC)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%SStC(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%SStC.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call StC_UnpackDiscState(RF, OutData%SStC(i1)) ! SStC 
      end do
   end if
end subroutine

subroutine SrvD_CopyConstrState(SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg)
   type(SrvD_ConstraintStateType), intent(in) :: SrcConstrStateData
   type(SrvD_ConstraintStateType), intent(inout) :: DstConstrStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SrvD_CopyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstConstrStateData%DummyConstrState = SrcConstrStateData%DummyConstrState
   if (allocated(SrcConstrStateData%BStC)) then
      LB(1:1) = lbound(SrcConstrStateData%BStC)
      UB(1:1) = ubound(SrcConstrStateData%BStC)
      if (.not. allocated(DstConstrStateData%BStC)) then
         allocate(DstConstrStateData%BStC(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstConstrStateData%BStC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call StC_CopyConstrState(SrcConstrStateData%BStC(i1), DstConstrStateData%BStC(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcConstrStateData%NStC)) then
      LB(1:1) = lbound(SrcConstrStateData%NStC)
      UB(1:1) = ubound(SrcConstrStateData%NStC)
      if (.not. allocated(DstConstrStateData%NStC)) then
         allocate(DstConstrStateData%NStC(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstConstrStateData%NStC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call StC_CopyConstrState(SrcConstrStateData%NStC(i1), DstConstrStateData%NStC(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcConstrStateData%TStC)) then
      LB(1:1) = lbound(SrcConstrStateData%TStC)
      UB(1:1) = ubound(SrcConstrStateData%TStC)
      if (.not. allocated(DstConstrStateData%TStC)) then
         allocate(DstConstrStateData%TStC(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstConstrStateData%TStC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call StC_CopyConstrState(SrcConstrStateData%TStC(i1), DstConstrStateData%TStC(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcConstrStateData%SStC)) then
      LB(1:1) = lbound(SrcConstrStateData%SStC)
      UB(1:1) = ubound(SrcConstrStateData%SStC)
      if (.not. allocated(DstConstrStateData%SStC)) then
         allocate(DstConstrStateData%SStC(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstConstrStateData%SStC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call StC_CopyConstrState(SrcConstrStateData%SStC(i1), DstConstrStateData%SStC(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
end subroutine

subroutine SrvD_DestroyConstrState(ConstrStateData, ErrStat, ErrMsg)
   type(SrvD_ConstraintStateType), intent(inout) :: ConstrStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SrvD_DestroyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ConstrStateData%BStC)) then
      LB(1:1) = lbound(ConstrStateData%BStC)
      UB(1:1) = ubound(ConstrStateData%BStC)
      do i1 = LB(1), UB(1)
         call StC_DestroyConstrState(ConstrStateData%BStC(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ConstrStateData%BStC)
   end if
   if (allocated(ConstrStateData%NStC)) then
      LB(1:1) = lbound(ConstrStateData%NStC)
      UB(1:1) = ubound(ConstrStateData%NStC)
      do i1 = LB(1), UB(1)
         call StC_DestroyConstrState(ConstrStateData%NStC(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ConstrStateData%NStC)
   end if
   if (allocated(ConstrStateData%TStC)) then
      LB(1:1) = lbound(ConstrStateData%TStC)
      UB(1:1) = ubound(ConstrStateData%TStC)
      do i1 = LB(1), UB(1)
         call StC_DestroyConstrState(ConstrStateData%TStC(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ConstrStateData%TStC)
   end if
   if (allocated(ConstrStateData%SStC)) then
      LB(1:1) = lbound(ConstrStateData%SStC)
      UB(1:1) = ubound(ConstrStateData%SStC)
      do i1 = LB(1), UB(1)
         call StC_DestroyConstrState(ConstrStateData%SStC(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ConstrStateData%SStC)
   end if
end subroutine

subroutine SrvD_PackConstrState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SrvD_ConstraintStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SrvD_PackConstrState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyConstrState)
   call RegPack(RF, allocated(InData%BStC))
   if (allocated(InData%BStC)) then
      call RegPackBounds(RF, 1, lbound(InData%BStC), ubound(InData%BStC))
      LB(1:1) = lbound(InData%BStC)
      UB(1:1) = ubound(InData%BStC)
      do i1 = LB(1), UB(1)
         call StC_PackConstrState(RF, InData%BStC(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%NStC))
   if (allocated(InData%NStC)) then
      call RegPackBounds(RF, 1, lbound(InData%NStC), ubound(InData%NStC))
      LB(1:1) = lbound(InData%NStC)
      UB(1:1) = ubound(InData%NStC)
      do i1 = LB(1), UB(1)
         call StC_PackConstrState(RF, InData%NStC(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%TStC))
   if (allocated(InData%TStC)) then
      call RegPackBounds(RF, 1, lbound(InData%TStC), ubound(InData%TStC))
      LB(1:1) = lbound(InData%TStC)
      UB(1:1) = ubound(InData%TStC)
      do i1 = LB(1), UB(1)
         call StC_PackConstrState(RF, InData%TStC(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%SStC))
   if (allocated(InData%SStC)) then
      call RegPackBounds(RF, 1, lbound(InData%SStC), ubound(InData%SStC))
      LB(1:1) = lbound(InData%SStC)
      UB(1:1) = ubound(InData%SStC)
      do i1 = LB(1), UB(1)
         call StC_PackConstrState(RF, InData%SStC(i1)) 
      end do
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SrvD_UnPackConstrState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SrvD_ConstraintStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SrvD_UnPackConstrState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyConstrState); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%BStC)) deallocate(OutData%BStC)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BStC(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BStC.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call StC_UnpackConstrState(RF, OutData%BStC(i1)) ! BStC 
      end do
   end if
   if (allocated(OutData%NStC)) deallocate(OutData%NStC)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%NStC(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%NStC.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call StC_UnpackConstrState(RF, OutData%NStC(i1)) ! NStC 
      end do
   end if
   if (allocated(OutData%TStC)) deallocate(OutData%TStC)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%TStC(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%TStC.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call StC_UnpackConstrState(RF, OutData%TStC(i1)) ! TStC 
      end do
   end if
   if (allocated(OutData%SStC)) deallocate(OutData%SStC)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%SStC(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%SStC.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call StC_UnpackConstrState(RF, OutData%SStC(i1)) ! SStC 
      end do
   end if
end subroutine

subroutine SrvD_CopyOtherState(SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg)
   type(SrvD_OtherStateType), intent(in) :: SrcOtherStateData
   type(SrvD_OtherStateType), intent(inout) :: DstOtherStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SrvD_CopyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcOtherStateData%BegPitMan)) then
      LB(1:1) = lbound(SrcOtherStateData%BegPitMan)
      UB(1:1) = ubound(SrcOtherStateData%BegPitMan)
      if (.not. allocated(DstOtherStateData%BegPitMan)) then
         allocate(DstOtherStateData%BegPitMan(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%BegPitMan.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOtherStateData%BegPitMan = SrcOtherStateData%BegPitMan
   end if
   if (allocated(SrcOtherStateData%BlPitchI)) then
      LB(1:1) = lbound(SrcOtherStateData%BlPitchI)
      UB(1:1) = ubound(SrcOtherStateData%BlPitchI)
      if (.not. allocated(DstOtherStateData%BlPitchI)) then
         allocate(DstOtherStateData%BlPitchI(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%BlPitchI.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOtherStateData%BlPitchI = SrcOtherStateData%BlPitchI
   end if
   if (allocated(SrcOtherStateData%TPitManE)) then
      LB(1:1) = lbound(SrcOtherStateData%TPitManE)
      UB(1:1) = ubound(SrcOtherStateData%TPitManE)
      if (.not. allocated(DstOtherStateData%TPitManE)) then
         allocate(DstOtherStateData%TPitManE(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%TPitManE.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOtherStateData%TPitManE = SrcOtherStateData%TPitManE
   end if
   DstOtherStateData%BegYawMan = SrcOtherStateData%BegYawMan
   DstOtherStateData%NacYawI = SrcOtherStateData%NacYawI
   DstOtherStateData%TYawManE = SrcOtherStateData%TYawManE
   DstOtherStateData%YawPosComInt = SrcOtherStateData%YawPosComInt
   if (allocated(SrcOtherStateData%BegTpBr)) then
      LB(1:1) = lbound(SrcOtherStateData%BegTpBr)
      UB(1:1) = ubound(SrcOtherStateData%BegTpBr)
      if (.not. allocated(DstOtherStateData%BegTpBr)) then
         allocate(DstOtherStateData%BegTpBr(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%BegTpBr.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOtherStateData%BegTpBr = SrcOtherStateData%BegTpBr
   end if
   if (allocated(SrcOtherStateData%TTpBrDp)) then
      LB(1:1) = lbound(SrcOtherStateData%TTpBrDp)
      UB(1:1) = ubound(SrcOtherStateData%TTpBrDp)
      if (.not. allocated(DstOtherStateData%TTpBrDp)) then
         allocate(DstOtherStateData%TTpBrDp(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%TTpBrDp.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOtherStateData%TTpBrDp = SrcOtherStateData%TTpBrDp
   end if
   if (allocated(SrcOtherStateData%TTpBrFl)) then
      LB(1:1) = lbound(SrcOtherStateData%TTpBrFl)
      UB(1:1) = ubound(SrcOtherStateData%TTpBrFl)
      if (.not. allocated(DstOtherStateData%TTpBrFl)) then
         allocate(DstOtherStateData%TTpBrFl(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%TTpBrFl.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOtherStateData%TTpBrFl = SrcOtherStateData%TTpBrFl
   end if
   DstOtherStateData%Off4Good = SrcOtherStateData%Off4Good
   DstOtherStateData%GenOnLine = SrcOtherStateData%GenOnLine
   if (allocated(SrcOtherStateData%BStC)) then
      LB(1:1) = lbound(SrcOtherStateData%BStC)
      UB(1:1) = ubound(SrcOtherStateData%BStC)
      if (.not. allocated(DstOtherStateData%BStC)) then
         allocate(DstOtherStateData%BStC(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%BStC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call StC_CopyOtherState(SrcOtherStateData%BStC(i1), DstOtherStateData%BStC(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcOtherStateData%NStC)) then
      LB(1:1) = lbound(SrcOtherStateData%NStC)
      UB(1:1) = ubound(SrcOtherStateData%NStC)
      if (.not. allocated(DstOtherStateData%NStC)) then
         allocate(DstOtherStateData%NStC(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%NStC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call StC_CopyOtherState(SrcOtherStateData%NStC(i1), DstOtherStateData%NStC(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcOtherStateData%TStC)) then
      LB(1:1) = lbound(SrcOtherStateData%TStC)
      UB(1:1) = ubound(SrcOtherStateData%TStC)
      if (.not. allocated(DstOtherStateData%TStC)) then
         allocate(DstOtherStateData%TStC(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%TStC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call StC_CopyOtherState(SrcOtherStateData%TStC(i1), DstOtherStateData%TStC(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcOtherStateData%SStC)) then
      LB(1:1) = lbound(SrcOtherStateData%SStC)
      UB(1:1) = ubound(SrcOtherStateData%SStC)
      if (.not. allocated(DstOtherStateData%SStC)) then
         allocate(DstOtherStateData%SStC(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%SStC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call StC_CopyOtherState(SrcOtherStateData%SStC(i1), DstOtherStateData%SStC(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
end subroutine

subroutine SrvD_DestroyOtherState(OtherStateData, ErrStat, ErrMsg)
   type(SrvD_OtherStateType), intent(inout) :: OtherStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SrvD_DestroyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(OtherStateData%BegPitMan)) then
      deallocate(OtherStateData%BegPitMan)
   end if
   if (allocated(OtherStateData%BlPitchI)) then
      deallocate(OtherStateData%BlPitchI)
   end if
   if (allocated(OtherStateData%TPitManE)) then
      deallocate(OtherStateData%TPitManE)
   end if
   if (allocated(OtherStateData%BegTpBr)) then
      deallocate(OtherStateData%BegTpBr)
   end if
   if (allocated(OtherStateData%TTpBrDp)) then
      deallocate(OtherStateData%TTpBrDp)
   end if
   if (allocated(OtherStateData%TTpBrFl)) then
      deallocate(OtherStateData%TTpBrFl)
   end if
   if (allocated(OtherStateData%BStC)) then
      LB(1:1) = lbound(OtherStateData%BStC)
      UB(1:1) = ubound(OtherStateData%BStC)
      do i1 = LB(1), UB(1)
         call StC_DestroyOtherState(OtherStateData%BStC(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(OtherStateData%BStC)
   end if
   if (allocated(OtherStateData%NStC)) then
      LB(1:1) = lbound(OtherStateData%NStC)
      UB(1:1) = ubound(OtherStateData%NStC)
      do i1 = LB(1), UB(1)
         call StC_DestroyOtherState(OtherStateData%NStC(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(OtherStateData%NStC)
   end if
   if (allocated(OtherStateData%TStC)) then
      LB(1:1) = lbound(OtherStateData%TStC)
      UB(1:1) = ubound(OtherStateData%TStC)
      do i1 = LB(1), UB(1)
         call StC_DestroyOtherState(OtherStateData%TStC(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(OtherStateData%TStC)
   end if
   if (allocated(OtherStateData%SStC)) then
      LB(1:1) = lbound(OtherStateData%SStC)
      UB(1:1) = ubound(OtherStateData%SStC)
      do i1 = LB(1), UB(1)
         call StC_DestroyOtherState(OtherStateData%SStC(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(OtherStateData%SStC)
   end if
end subroutine

subroutine SrvD_PackOtherState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SrvD_OtherStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SrvD_PackOtherState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%BegPitMan)
   call RegPackAlloc(RF, InData%BlPitchI)
   call RegPackAlloc(RF, InData%TPitManE)
   call RegPack(RF, InData%BegYawMan)
   call RegPack(RF, InData%NacYawI)
   call RegPack(RF, InData%TYawManE)
   call RegPack(RF, InData%YawPosComInt)
   call RegPackAlloc(RF, InData%BegTpBr)
   call RegPackAlloc(RF, InData%TTpBrDp)
   call RegPackAlloc(RF, InData%TTpBrFl)
   call RegPack(RF, InData%Off4Good)
   call RegPack(RF, InData%GenOnLine)
   call RegPack(RF, allocated(InData%BStC))
   if (allocated(InData%BStC)) then
      call RegPackBounds(RF, 1, lbound(InData%BStC), ubound(InData%BStC))
      LB(1:1) = lbound(InData%BStC)
      UB(1:1) = ubound(InData%BStC)
      do i1 = LB(1), UB(1)
         call StC_PackOtherState(RF, InData%BStC(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%NStC))
   if (allocated(InData%NStC)) then
      call RegPackBounds(RF, 1, lbound(InData%NStC), ubound(InData%NStC))
      LB(1:1) = lbound(InData%NStC)
      UB(1:1) = ubound(InData%NStC)
      do i1 = LB(1), UB(1)
         call StC_PackOtherState(RF, InData%NStC(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%TStC))
   if (allocated(InData%TStC)) then
      call RegPackBounds(RF, 1, lbound(InData%TStC), ubound(InData%TStC))
      LB(1:1) = lbound(InData%TStC)
      UB(1:1) = ubound(InData%TStC)
      do i1 = LB(1), UB(1)
         call StC_PackOtherState(RF, InData%TStC(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%SStC))
   if (allocated(InData%SStC)) then
      call RegPackBounds(RF, 1, lbound(InData%SStC), ubound(InData%SStC))
      LB(1:1) = lbound(InData%SStC)
      UB(1:1) = ubound(InData%SStC)
      do i1 = LB(1), UB(1)
         call StC_PackOtherState(RF, InData%SStC(i1)) 
      end do
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SrvD_UnPackOtherState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SrvD_OtherStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SrvD_UnPackOtherState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%BegPitMan); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BlPitchI); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TPitManE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BegYawMan); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NacYawI); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TYawManE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawPosComInt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BegTpBr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TTpBrDp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TTpBrFl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Off4Good); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GenOnLine); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%BStC)) deallocate(OutData%BStC)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BStC(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BStC.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call StC_UnpackOtherState(RF, OutData%BStC(i1)) ! BStC 
      end do
   end if
   if (allocated(OutData%NStC)) deallocate(OutData%NStC)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%NStC(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%NStC.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call StC_UnpackOtherState(RF, OutData%NStC(i1)) ! NStC 
      end do
   end if
   if (allocated(OutData%TStC)) deallocate(OutData%TStC)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%TStC(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%TStC.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call StC_UnpackOtherState(RF, OutData%TStC(i1)) ! TStC 
      end do
   end if
   if (allocated(OutData%SStC)) deallocate(OutData%SStC)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%SStC(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%SStC.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call StC_UnpackOtherState(RF, OutData%SStC(i1)) ! SStC 
      end do
   end if
end subroutine

subroutine SrvD_CopyModuleMapType(SrcModuleMapTypeData, DstModuleMapTypeData, CtrlCode, ErrStat, ErrMsg)
   type(SrvD_ModuleMapType), intent(inout) :: SrcModuleMapTypeData
   type(SrvD_ModuleMapType), intent(inout) :: DstModuleMapTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SrvD_CopyModuleMapType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcModuleMapTypeData%u_BStC_Mot2_BStC)) then
      LB(1:2) = lbound(SrcModuleMapTypeData%u_BStC_Mot2_BStC)
      UB(1:2) = ubound(SrcModuleMapTypeData%u_BStC_Mot2_BStC)
      if (.not. allocated(DstModuleMapTypeData%u_BStC_Mot2_BStC)) then
         allocate(DstModuleMapTypeData%u_BStC_Mot2_BStC(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%u_BStC_Mot2_BStC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%u_BStC_Mot2_BStC(i1,i2), DstModuleMapTypeData%u_BStC_Mot2_BStC(i1,i2), CtrlCode, ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
            if (ErrStat >= AbortErrLev) return
         end do
      end do
   end if
   if (allocated(SrcModuleMapTypeData%u_NStC_Mot2_NStC)) then
      LB(1:1) = lbound(SrcModuleMapTypeData%u_NStC_Mot2_NStC)
      UB(1:1) = ubound(SrcModuleMapTypeData%u_NStC_Mot2_NStC)
      if (.not. allocated(DstModuleMapTypeData%u_NStC_Mot2_NStC)) then
         allocate(DstModuleMapTypeData%u_NStC_Mot2_NStC(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%u_NStC_Mot2_NStC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%u_NStC_Mot2_NStC(i1), DstModuleMapTypeData%u_NStC_Mot2_NStC(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcModuleMapTypeData%u_TStC_Mot2_TStC)) then
      LB(1:1) = lbound(SrcModuleMapTypeData%u_TStC_Mot2_TStC)
      UB(1:1) = ubound(SrcModuleMapTypeData%u_TStC_Mot2_TStC)
      if (.not. allocated(DstModuleMapTypeData%u_TStC_Mot2_TStC)) then
         allocate(DstModuleMapTypeData%u_TStC_Mot2_TStC(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%u_TStC_Mot2_TStC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%u_TStC_Mot2_TStC(i1), DstModuleMapTypeData%u_TStC_Mot2_TStC(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcModuleMapTypeData%u_SStC_Mot2_SStC)) then
      LB(1:1) = lbound(SrcModuleMapTypeData%u_SStC_Mot2_SStC)
      UB(1:1) = ubound(SrcModuleMapTypeData%u_SStC_Mot2_SStC)
      if (.not. allocated(DstModuleMapTypeData%u_SStC_Mot2_SStC)) then
         allocate(DstModuleMapTypeData%u_SStC_Mot2_SStC(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%u_SStC_Mot2_SStC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%u_SStC_Mot2_SStC(i1), DstModuleMapTypeData%u_SStC_Mot2_SStC(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcModuleMapTypeData%BStC_Frc2_y_BStC)) then
      LB(1:2) = lbound(SrcModuleMapTypeData%BStC_Frc2_y_BStC)
      UB(1:2) = ubound(SrcModuleMapTypeData%BStC_Frc2_y_BStC)
      if (.not. allocated(DstModuleMapTypeData%BStC_Frc2_y_BStC)) then
         allocate(DstModuleMapTypeData%BStC_Frc2_y_BStC(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%BStC_Frc2_y_BStC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%BStC_Frc2_y_BStC(i1,i2), DstModuleMapTypeData%BStC_Frc2_y_BStC(i1,i2), CtrlCode, ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
            if (ErrStat >= AbortErrLev) return
         end do
      end do
   end if
   if (allocated(SrcModuleMapTypeData%NStC_Frc2_y_NStC)) then
      LB(1:1) = lbound(SrcModuleMapTypeData%NStC_Frc2_y_NStC)
      UB(1:1) = ubound(SrcModuleMapTypeData%NStC_Frc2_y_NStC)
      if (.not. allocated(DstModuleMapTypeData%NStC_Frc2_y_NStC)) then
         allocate(DstModuleMapTypeData%NStC_Frc2_y_NStC(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%NStC_Frc2_y_NStC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%NStC_Frc2_y_NStC(i1), DstModuleMapTypeData%NStC_Frc2_y_NStC(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcModuleMapTypeData%TStC_Frc2_y_TStC)) then
      LB(1:1) = lbound(SrcModuleMapTypeData%TStC_Frc2_y_TStC)
      UB(1:1) = ubound(SrcModuleMapTypeData%TStC_Frc2_y_TStC)
      if (.not. allocated(DstModuleMapTypeData%TStC_Frc2_y_TStC)) then
         allocate(DstModuleMapTypeData%TStC_Frc2_y_TStC(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%TStC_Frc2_y_TStC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%TStC_Frc2_y_TStC(i1), DstModuleMapTypeData%TStC_Frc2_y_TStC(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcModuleMapTypeData%SStC_Frc2_y_SStC)) then
      LB(1:1) = lbound(SrcModuleMapTypeData%SStC_Frc2_y_SStC)
      UB(1:1) = ubound(SrcModuleMapTypeData%SStC_Frc2_y_SStC)
      if (.not. allocated(DstModuleMapTypeData%SStC_Frc2_y_SStC)) then
         allocate(DstModuleMapTypeData%SStC_Frc2_y_SStC(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%SStC_Frc2_y_SStC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%SStC_Frc2_y_SStC(i1), DstModuleMapTypeData%SStC_Frc2_y_SStC(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
end subroutine

subroutine SrvD_DestroyModuleMapType(ModuleMapTypeData, ErrStat, ErrMsg)
   type(SrvD_ModuleMapType), intent(inout) :: ModuleMapTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SrvD_DestroyModuleMapType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ModuleMapTypeData%u_BStC_Mot2_BStC)) then
      LB(1:2) = lbound(ModuleMapTypeData%u_BStC_Mot2_BStC)
      UB(1:2) = ubound(ModuleMapTypeData%u_BStC_Mot2_BStC)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%u_BStC_Mot2_BStC(i1,i2), ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         end do
      end do
      deallocate(ModuleMapTypeData%u_BStC_Mot2_BStC)
   end if
   if (allocated(ModuleMapTypeData%u_NStC_Mot2_NStC)) then
      LB(1:1) = lbound(ModuleMapTypeData%u_NStC_Mot2_NStC)
      UB(1:1) = ubound(ModuleMapTypeData%u_NStC_Mot2_NStC)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%u_NStC_Mot2_NStC(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ModuleMapTypeData%u_NStC_Mot2_NStC)
   end if
   if (allocated(ModuleMapTypeData%u_TStC_Mot2_TStC)) then
      LB(1:1) = lbound(ModuleMapTypeData%u_TStC_Mot2_TStC)
      UB(1:1) = ubound(ModuleMapTypeData%u_TStC_Mot2_TStC)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%u_TStC_Mot2_TStC(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ModuleMapTypeData%u_TStC_Mot2_TStC)
   end if
   if (allocated(ModuleMapTypeData%u_SStC_Mot2_SStC)) then
      LB(1:1) = lbound(ModuleMapTypeData%u_SStC_Mot2_SStC)
      UB(1:1) = ubound(ModuleMapTypeData%u_SStC_Mot2_SStC)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%u_SStC_Mot2_SStC(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ModuleMapTypeData%u_SStC_Mot2_SStC)
   end if
   if (allocated(ModuleMapTypeData%BStC_Frc2_y_BStC)) then
      LB(1:2) = lbound(ModuleMapTypeData%BStC_Frc2_y_BStC)
      UB(1:2) = ubound(ModuleMapTypeData%BStC_Frc2_y_BStC)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%BStC_Frc2_y_BStC(i1,i2), ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         end do
      end do
      deallocate(ModuleMapTypeData%BStC_Frc2_y_BStC)
   end if
   if (allocated(ModuleMapTypeData%NStC_Frc2_y_NStC)) then
      LB(1:1) = lbound(ModuleMapTypeData%NStC_Frc2_y_NStC)
      UB(1:1) = ubound(ModuleMapTypeData%NStC_Frc2_y_NStC)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%NStC_Frc2_y_NStC(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ModuleMapTypeData%NStC_Frc2_y_NStC)
   end if
   if (allocated(ModuleMapTypeData%TStC_Frc2_y_TStC)) then
      LB(1:1) = lbound(ModuleMapTypeData%TStC_Frc2_y_TStC)
      UB(1:1) = ubound(ModuleMapTypeData%TStC_Frc2_y_TStC)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%TStC_Frc2_y_TStC(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ModuleMapTypeData%TStC_Frc2_y_TStC)
   end if
   if (allocated(ModuleMapTypeData%SStC_Frc2_y_SStC)) then
      LB(1:1) = lbound(ModuleMapTypeData%SStC_Frc2_y_SStC)
      UB(1:1) = ubound(ModuleMapTypeData%SStC_Frc2_y_SStC)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%SStC_Frc2_y_SStC(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ModuleMapTypeData%SStC_Frc2_y_SStC)
   end if
end subroutine

subroutine SrvD_PackModuleMapType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SrvD_ModuleMapType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SrvD_PackModuleMapType'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%u_BStC_Mot2_BStC))
   if (allocated(InData%u_BStC_Mot2_BStC)) then
      call RegPackBounds(RF, 2, lbound(InData%u_BStC_Mot2_BStC), ubound(InData%u_BStC_Mot2_BStC))
      LB(1:2) = lbound(InData%u_BStC_Mot2_BStC)
      UB(1:2) = ubound(InData%u_BStC_Mot2_BStC)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call NWTC_Library_PackMeshMapType(RF, InData%u_BStC_Mot2_BStC(i1,i2)) 
         end do
      end do
   end if
   call RegPack(RF, allocated(InData%u_NStC_Mot2_NStC))
   if (allocated(InData%u_NStC_Mot2_NStC)) then
      call RegPackBounds(RF, 1, lbound(InData%u_NStC_Mot2_NStC), ubound(InData%u_NStC_Mot2_NStC))
      LB(1:1) = lbound(InData%u_NStC_Mot2_NStC)
      UB(1:1) = ubound(InData%u_NStC_Mot2_NStC)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackMeshMapType(RF, InData%u_NStC_Mot2_NStC(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%u_TStC_Mot2_TStC))
   if (allocated(InData%u_TStC_Mot2_TStC)) then
      call RegPackBounds(RF, 1, lbound(InData%u_TStC_Mot2_TStC), ubound(InData%u_TStC_Mot2_TStC))
      LB(1:1) = lbound(InData%u_TStC_Mot2_TStC)
      UB(1:1) = ubound(InData%u_TStC_Mot2_TStC)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackMeshMapType(RF, InData%u_TStC_Mot2_TStC(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%u_SStC_Mot2_SStC))
   if (allocated(InData%u_SStC_Mot2_SStC)) then
      call RegPackBounds(RF, 1, lbound(InData%u_SStC_Mot2_SStC), ubound(InData%u_SStC_Mot2_SStC))
      LB(1:1) = lbound(InData%u_SStC_Mot2_SStC)
      UB(1:1) = ubound(InData%u_SStC_Mot2_SStC)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackMeshMapType(RF, InData%u_SStC_Mot2_SStC(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%BStC_Frc2_y_BStC))
   if (allocated(InData%BStC_Frc2_y_BStC)) then
      call RegPackBounds(RF, 2, lbound(InData%BStC_Frc2_y_BStC), ubound(InData%BStC_Frc2_y_BStC))
      LB(1:2) = lbound(InData%BStC_Frc2_y_BStC)
      UB(1:2) = ubound(InData%BStC_Frc2_y_BStC)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call NWTC_Library_PackMeshMapType(RF, InData%BStC_Frc2_y_BStC(i1,i2)) 
         end do
      end do
   end if
   call RegPack(RF, allocated(InData%NStC_Frc2_y_NStC))
   if (allocated(InData%NStC_Frc2_y_NStC)) then
      call RegPackBounds(RF, 1, lbound(InData%NStC_Frc2_y_NStC), ubound(InData%NStC_Frc2_y_NStC))
      LB(1:1) = lbound(InData%NStC_Frc2_y_NStC)
      UB(1:1) = ubound(InData%NStC_Frc2_y_NStC)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackMeshMapType(RF, InData%NStC_Frc2_y_NStC(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%TStC_Frc2_y_TStC))
   if (allocated(InData%TStC_Frc2_y_TStC)) then
      call RegPackBounds(RF, 1, lbound(InData%TStC_Frc2_y_TStC), ubound(InData%TStC_Frc2_y_TStC))
      LB(1:1) = lbound(InData%TStC_Frc2_y_TStC)
      UB(1:1) = ubound(InData%TStC_Frc2_y_TStC)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackMeshMapType(RF, InData%TStC_Frc2_y_TStC(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%SStC_Frc2_y_SStC))
   if (allocated(InData%SStC_Frc2_y_SStC)) then
      call RegPackBounds(RF, 1, lbound(InData%SStC_Frc2_y_SStC), ubound(InData%SStC_Frc2_y_SStC))
      LB(1:1) = lbound(InData%SStC_Frc2_y_SStC)
      UB(1:1) = ubound(InData%SStC_Frc2_y_SStC)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackMeshMapType(RF, InData%SStC_Frc2_y_SStC(i1)) 
      end do
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SrvD_UnPackModuleMapType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SrvD_ModuleMapType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SrvD_UnPackModuleMapType'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%u_BStC_Mot2_BStC)) deallocate(OutData%u_BStC_Mot2_BStC)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 2, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%u_BStC_Mot2_BStC(LB(1):UB(1),LB(2):UB(2)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%u_BStC_Mot2_BStC.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call NWTC_Library_UnpackMeshMapType(RF, OutData%u_BStC_Mot2_BStC(i1,i2)) ! u_BStC_Mot2_BStC 
         end do
      end do
   end if
   if (allocated(OutData%u_NStC_Mot2_NStC)) deallocate(OutData%u_NStC_Mot2_NStC)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%u_NStC_Mot2_NStC(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%u_NStC_Mot2_NStC.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackMeshMapType(RF, OutData%u_NStC_Mot2_NStC(i1)) ! u_NStC_Mot2_NStC 
      end do
   end if
   if (allocated(OutData%u_TStC_Mot2_TStC)) deallocate(OutData%u_TStC_Mot2_TStC)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%u_TStC_Mot2_TStC(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%u_TStC_Mot2_TStC.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackMeshMapType(RF, OutData%u_TStC_Mot2_TStC(i1)) ! u_TStC_Mot2_TStC 
      end do
   end if
   if (allocated(OutData%u_SStC_Mot2_SStC)) deallocate(OutData%u_SStC_Mot2_SStC)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%u_SStC_Mot2_SStC(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%u_SStC_Mot2_SStC.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackMeshMapType(RF, OutData%u_SStC_Mot2_SStC(i1)) ! u_SStC_Mot2_SStC 
      end do
   end if
   if (allocated(OutData%BStC_Frc2_y_BStC)) deallocate(OutData%BStC_Frc2_y_BStC)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 2, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BStC_Frc2_y_BStC(LB(1):UB(1),LB(2):UB(2)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BStC_Frc2_y_BStC.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call NWTC_Library_UnpackMeshMapType(RF, OutData%BStC_Frc2_y_BStC(i1,i2)) ! BStC_Frc2_y_BStC 
         end do
      end do
   end if
   if (allocated(OutData%NStC_Frc2_y_NStC)) deallocate(OutData%NStC_Frc2_y_NStC)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%NStC_Frc2_y_NStC(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%NStC_Frc2_y_NStC.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackMeshMapType(RF, OutData%NStC_Frc2_y_NStC(i1)) ! NStC_Frc2_y_NStC 
      end do
   end if
   if (allocated(OutData%TStC_Frc2_y_TStC)) deallocate(OutData%TStC_Frc2_y_TStC)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%TStC_Frc2_y_TStC(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%TStC_Frc2_y_TStC.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackMeshMapType(RF, OutData%TStC_Frc2_y_TStC(i1)) ! TStC_Frc2_y_TStC 
      end do
   end if
   if (allocated(OutData%SStC_Frc2_y_SStC)) deallocate(OutData%SStC_Frc2_y_SStC)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%SStC_Frc2_y_SStC(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%SStC_Frc2_y_SStC.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackMeshMapType(RF, OutData%SStC_Frc2_y_SStC(i1)) ! SStC_Frc2_y_SStC 
      end do
   end if
end subroutine

subroutine SrvD_CopyMisc(SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg)
   type(SrvD_MiscVarType), intent(inout) :: SrcMiscData
   type(SrvD_MiscVarType), intent(inout) :: DstMiscData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SrvD_CopyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstMiscData%LastTimeCalled = SrcMiscData%LastTimeCalled
   call SrvD_CopyBladedDLLType(SrcMiscData%dll_data, DstMiscData%dll_data, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstMiscData%FirstWarn = SrcMiscData%FirstWarn
   DstMiscData%LastTimeFiltered = SrcMiscData%LastTimeFiltered
   if (allocated(SrcMiscData%xd_BlPitchFilter)) then
      LB(1:1) = lbound(SrcMiscData%xd_BlPitchFilter)
      UB(1:1) = ubound(SrcMiscData%xd_BlPitchFilter)
      if (.not. allocated(DstMiscData%xd_BlPitchFilter)) then
         allocate(DstMiscData%xd_BlPitchFilter(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%xd_BlPitchFilter.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%xd_BlPitchFilter = SrcMiscData%xd_BlPitchFilter
   end if
   if (allocated(SrcMiscData%BStC)) then
      LB(1:1) = lbound(SrcMiscData%BStC)
      UB(1:1) = ubound(SrcMiscData%BStC)
      if (.not. allocated(DstMiscData%BStC)) then
         allocate(DstMiscData%BStC(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%BStC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call StC_CopyMisc(SrcMiscData%BStC(i1), DstMiscData%BStC(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcMiscData%NStC)) then
      LB(1:1) = lbound(SrcMiscData%NStC)
      UB(1:1) = ubound(SrcMiscData%NStC)
      if (.not. allocated(DstMiscData%NStC)) then
         allocate(DstMiscData%NStC(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%NStC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call StC_CopyMisc(SrcMiscData%NStC(i1), DstMiscData%NStC(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcMiscData%TStC)) then
      LB(1:1) = lbound(SrcMiscData%TStC)
      UB(1:1) = ubound(SrcMiscData%TStC)
      if (.not. allocated(DstMiscData%TStC)) then
         allocate(DstMiscData%TStC(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%TStC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call StC_CopyMisc(SrcMiscData%TStC(i1), DstMiscData%TStC(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcMiscData%SStC)) then
      LB(1:1) = lbound(SrcMiscData%SStC)
      UB(1:1) = ubound(SrcMiscData%SStC)
      if (.not. allocated(DstMiscData%SStC)) then
         allocate(DstMiscData%SStC(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%SStC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call StC_CopyMisc(SrcMiscData%SStC(i1), DstMiscData%SStC(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcMiscData%u_BStC)) then
      LB(1:2) = lbound(SrcMiscData%u_BStC)
      UB(1:2) = ubound(SrcMiscData%u_BStC)
      if (.not. allocated(DstMiscData%u_BStC)) then
         allocate(DstMiscData%u_BStC(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%u_BStC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call StC_CopyInput(SrcMiscData%u_BStC(i1,i2), DstMiscData%u_BStC(i1,i2), CtrlCode, ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
            if (ErrStat >= AbortErrLev) return
         end do
      end do
   end if
   if (allocated(SrcMiscData%u_NStC)) then
      LB(1:2) = lbound(SrcMiscData%u_NStC)
      UB(1:2) = ubound(SrcMiscData%u_NStC)
      if (.not. allocated(DstMiscData%u_NStC)) then
         allocate(DstMiscData%u_NStC(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%u_NStC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call StC_CopyInput(SrcMiscData%u_NStC(i1,i2), DstMiscData%u_NStC(i1,i2), CtrlCode, ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
            if (ErrStat >= AbortErrLev) return
         end do
      end do
   end if
   if (allocated(SrcMiscData%u_TStC)) then
      LB(1:2) = lbound(SrcMiscData%u_TStC)
      UB(1:2) = ubound(SrcMiscData%u_TStC)
      if (.not. allocated(DstMiscData%u_TStC)) then
         allocate(DstMiscData%u_TStC(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%u_TStC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call StC_CopyInput(SrcMiscData%u_TStC(i1,i2), DstMiscData%u_TStC(i1,i2), CtrlCode, ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
            if (ErrStat >= AbortErrLev) return
         end do
      end do
   end if
   if (allocated(SrcMiscData%u_SStC)) then
      LB(1:2) = lbound(SrcMiscData%u_SStC)
      UB(1:2) = ubound(SrcMiscData%u_SStC)
      if (.not. allocated(DstMiscData%u_SStC)) then
         allocate(DstMiscData%u_SStC(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%u_SStC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call StC_CopyInput(SrcMiscData%u_SStC(i1,i2), DstMiscData%u_SStC(i1,i2), CtrlCode, ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
            if (ErrStat >= AbortErrLev) return
         end do
      end do
   end if
   if (allocated(SrcMiscData%y_BStC)) then
      LB(1:1) = lbound(SrcMiscData%y_BStC)
      UB(1:1) = ubound(SrcMiscData%y_BStC)
      if (.not. allocated(DstMiscData%y_BStC)) then
         allocate(DstMiscData%y_BStC(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%y_BStC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call StC_CopyOutput(SrcMiscData%y_BStC(i1), DstMiscData%y_BStC(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcMiscData%y_NStC)) then
      LB(1:1) = lbound(SrcMiscData%y_NStC)
      UB(1:1) = ubound(SrcMiscData%y_NStC)
      if (.not. allocated(DstMiscData%y_NStC)) then
         allocate(DstMiscData%y_NStC(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%y_NStC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call StC_CopyOutput(SrcMiscData%y_NStC(i1), DstMiscData%y_NStC(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcMiscData%y_TStC)) then
      LB(1:1) = lbound(SrcMiscData%y_TStC)
      UB(1:1) = ubound(SrcMiscData%y_TStC)
      if (.not. allocated(DstMiscData%y_TStC)) then
         allocate(DstMiscData%y_TStC(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%y_TStC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call StC_CopyOutput(SrcMiscData%y_TStC(i1), DstMiscData%y_TStC(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcMiscData%y_SStC)) then
      LB(1:1) = lbound(SrcMiscData%y_SStC)
      UB(1:1) = ubound(SrcMiscData%y_SStC)
      if (.not. allocated(DstMiscData%y_SStC)) then
         allocate(DstMiscData%y_SStC(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%y_SStC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call StC_CopyOutput(SrcMiscData%y_SStC(i1), DstMiscData%y_SStC(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call SrvD_CopyModuleMapType(SrcMiscData%SrvD_MeshMap, DstMiscData%SrvD_MeshMap, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstMiscData%PrevTstepNcall = SrcMiscData%PrevTstepNcall
end subroutine

subroutine SrvD_DestroyMisc(MiscData, ErrStat, ErrMsg)
   type(SrvD_MiscVarType), intent(inout) :: MiscData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SrvD_DestroyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call SrvD_DestroyBladedDLLType(MiscData%dll_data, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(MiscData%xd_BlPitchFilter)) then
      deallocate(MiscData%xd_BlPitchFilter)
   end if
   if (allocated(MiscData%BStC)) then
      LB(1:1) = lbound(MiscData%BStC)
      UB(1:1) = ubound(MiscData%BStC)
      do i1 = LB(1), UB(1)
         call StC_DestroyMisc(MiscData%BStC(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MiscData%BStC)
   end if
   if (allocated(MiscData%NStC)) then
      LB(1:1) = lbound(MiscData%NStC)
      UB(1:1) = ubound(MiscData%NStC)
      do i1 = LB(1), UB(1)
         call StC_DestroyMisc(MiscData%NStC(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MiscData%NStC)
   end if
   if (allocated(MiscData%TStC)) then
      LB(1:1) = lbound(MiscData%TStC)
      UB(1:1) = ubound(MiscData%TStC)
      do i1 = LB(1), UB(1)
         call StC_DestroyMisc(MiscData%TStC(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MiscData%TStC)
   end if
   if (allocated(MiscData%SStC)) then
      LB(1:1) = lbound(MiscData%SStC)
      UB(1:1) = ubound(MiscData%SStC)
      do i1 = LB(1), UB(1)
         call StC_DestroyMisc(MiscData%SStC(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MiscData%SStC)
   end if
   if (allocated(MiscData%u_BStC)) then
      LB(1:2) = lbound(MiscData%u_BStC)
      UB(1:2) = ubound(MiscData%u_BStC)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call StC_DestroyInput(MiscData%u_BStC(i1,i2), ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         end do
      end do
      deallocate(MiscData%u_BStC)
   end if
   if (allocated(MiscData%u_NStC)) then
      LB(1:2) = lbound(MiscData%u_NStC)
      UB(1:2) = ubound(MiscData%u_NStC)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call StC_DestroyInput(MiscData%u_NStC(i1,i2), ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         end do
      end do
      deallocate(MiscData%u_NStC)
   end if
   if (allocated(MiscData%u_TStC)) then
      LB(1:2) = lbound(MiscData%u_TStC)
      UB(1:2) = ubound(MiscData%u_TStC)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call StC_DestroyInput(MiscData%u_TStC(i1,i2), ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         end do
      end do
      deallocate(MiscData%u_TStC)
   end if
   if (allocated(MiscData%u_SStC)) then
      LB(1:2) = lbound(MiscData%u_SStC)
      UB(1:2) = ubound(MiscData%u_SStC)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call StC_DestroyInput(MiscData%u_SStC(i1,i2), ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         end do
      end do
      deallocate(MiscData%u_SStC)
   end if
   if (allocated(MiscData%y_BStC)) then
      LB(1:1) = lbound(MiscData%y_BStC)
      UB(1:1) = ubound(MiscData%y_BStC)
      do i1 = LB(1), UB(1)
         call StC_DestroyOutput(MiscData%y_BStC(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MiscData%y_BStC)
   end if
   if (allocated(MiscData%y_NStC)) then
      LB(1:1) = lbound(MiscData%y_NStC)
      UB(1:1) = ubound(MiscData%y_NStC)
      do i1 = LB(1), UB(1)
         call StC_DestroyOutput(MiscData%y_NStC(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MiscData%y_NStC)
   end if
   if (allocated(MiscData%y_TStC)) then
      LB(1:1) = lbound(MiscData%y_TStC)
      UB(1:1) = ubound(MiscData%y_TStC)
      do i1 = LB(1), UB(1)
         call StC_DestroyOutput(MiscData%y_TStC(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MiscData%y_TStC)
   end if
   if (allocated(MiscData%y_SStC)) then
      LB(1:1) = lbound(MiscData%y_SStC)
      UB(1:1) = ubound(MiscData%y_SStC)
      do i1 = LB(1), UB(1)
         call StC_DestroyOutput(MiscData%y_SStC(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MiscData%y_SStC)
   end if
   call SrvD_DestroyModuleMapType(MiscData%SrvD_MeshMap, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine SrvD_PackMisc(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SrvD_MiscVarType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SrvD_PackMisc'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%LastTimeCalled)
   call SrvD_PackBladedDLLType(RF, InData%dll_data) 
   call RegPack(RF, InData%FirstWarn)
   call RegPack(RF, InData%LastTimeFiltered)
   call RegPackAlloc(RF, InData%xd_BlPitchFilter)
   call RegPack(RF, allocated(InData%BStC))
   if (allocated(InData%BStC)) then
      call RegPackBounds(RF, 1, lbound(InData%BStC), ubound(InData%BStC))
      LB(1:1) = lbound(InData%BStC)
      UB(1:1) = ubound(InData%BStC)
      do i1 = LB(1), UB(1)
         call StC_PackMisc(RF, InData%BStC(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%NStC))
   if (allocated(InData%NStC)) then
      call RegPackBounds(RF, 1, lbound(InData%NStC), ubound(InData%NStC))
      LB(1:1) = lbound(InData%NStC)
      UB(1:1) = ubound(InData%NStC)
      do i1 = LB(1), UB(1)
         call StC_PackMisc(RF, InData%NStC(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%TStC))
   if (allocated(InData%TStC)) then
      call RegPackBounds(RF, 1, lbound(InData%TStC), ubound(InData%TStC))
      LB(1:1) = lbound(InData%TStC)
      UB(1:1) = ubound(InData%TStC)
      do i1 = LB(1), UB(1)
         call StC_PackMisc(RF, InData%TStC(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%SStC))
   if (allocated(InData%SStC)) then
      call RegPackBounds(RF, 1, lbound(InData%SStC), ubound(InData%SStC))
      LB(1:1) = lbound(InData%SStC)
      UB(1:1) = ubound(InData%SStC)
      do i1 = LB(1), UB(1)
         call StC_PackMisc(RF, InData%SStC(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%u_BStC))
   if (allocated(InData%u_BStC)) then
      call RegPackBounds(RF, 2, lbound(InData%u_BStC), ubound(InData%u_BStC))
      LB(1:2) = lbound(InData%u_BStC)
      UB(1:2) = ubound(InData%u_BStC)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call StC_PackInput(RF, InData%u_BStC(i1,i2)) 
         end do
      end do
   end if
   call RegPack(RF, allocated(InData%u_NStC))
   if (allocated(InData%u_NStC)) then
      call RegPackBounds(RF, 2, lbound(InData%u_NStC), ubound(InData%u_NStC))
      LB(1:2) = lbound(InData%u_NStC)
      UB(1:2) = ubound(InData%u_NStC)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call StC_PackInput(RF, InData%u_NStC(i1,i2)) 
         end do
      end do
   end if
   call RegPack(RF, allocated(InData%u_TStC))
   if (allocated(InData%u_TStC)) then
      call RegPackBounds(RF, 2, lbound(InData%u_TStC), ubound(InData%u_TStC))
      LB(1:2) = lbound(InData%u_TStC)
      UB(1:2) = ubound(InData%u_TStC)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call StC_PackInput(RF, InData%u_TStC(i1,i2)) 
         end do
      end do
   end if
   call RegPack(RF, allocated(InData%u_SStC))
   if (allocated(InData%u_SStC)) then
      call RegPackBounds(RF, 2, lbound(InData%u_SStC), ubound(InData%u_SStC))
      LB(1:2) = lbound(InData%u_SStC)
      UB(1:2) = ubound(InData%u_SStC)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call StC_PackInput(RF, InData%u_SStC(i1,i2)) 
         end do
      end do
   end if
   call RegPack(RF, allocated(InData%y_BStC))
   if (allocated(InData%y_BStC)) then
      call RegPackBounds(RF, 1, lbound(InData%y_BStC), ubound(InData%y_BStC))
      LB(1:1) = lbound(InData%y_BStC)
      UB(1:1) = ubound(InData%y_BStC)
      do i1 = LB(1), UB(1)
         call StC_PackOutput(RF, InData%y_BStC(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%y_NStC))
   if (allocated(InData%y_NStC)) then
      call RegPackBounds(RF, 1, lbound(InData%y_NStC), ubound(InData%y_NStC))
      LB(1:1) = lbound(InData%y_NStC)
      UB(1:1) = ubound(InData%y_NStC)
      do i1 = LB(1), UB(1)
         call StC_PackOutput(RF, InData%y_NStC(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%y_TStC))
   if (allocated(InData%y_TStC)) then
      call RegPackBounds(RF, 1, lbound(InData%y_TStC), ubound(InData%y_TStC))
      LB(1:1) = lbound(InData%y_TStC)
      UB(1:1) = ubound(InData%y_TStC)
      do i1 = LB(1), UB(1)
         call StC_PackOutput(RF, InData%y_TStC(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%y_SStC))
   if (allocated(InData%y_SStC)) then
      call RegPackBounds(RF, 1, lbound(InData%y_SStC), ubound(InData%y_SStC))
      LB(1:1) = lbound(InData%y_SStC)
      UB(1:1) = ubound(InData%y_SStC)
      do i1 = LB(1), UB(1)
         call StC_PackOutput(RF, InData%y_SStC(i1)) 
      end do
   end if
   call SrvD_PackModuleMapType(RF, InData%SrvD_MeshMap) 
   call RegPack(RF, InData%PrevTstepNcall)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SrvD_UnPackMisc(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SrvD_MiscVarType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SrvD_UnPackMisc'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%LastTimeCalled); if (RegCheckErr(RF, RoutineName)) return
   call SrvD_UnpackBladedDLLType(RF, OutData%dll_data) ! dll_data 
   call RegUnpack(RF, OutData%FirstWarn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LastTimeFiltered); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%xd_BlPitchFilter); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%BStC)) deallocate(OutData%BStC)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BStC(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BStC.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call StC_UnpackMisc(RF, OutData%BStC(i1)) ! BStC 
      end do
   end if
   if (allocated(OutData%NStC)) deallocate(OutData%NStC)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%NStC(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%NStC.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call StC_UnpackMisc(RF, OutData%NStC(i1)) ! NStC 
      end do
   end if
   if (allocated(OutData%TStC)) deallocate(OutData%TStC)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%TStC(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%TStC.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call StC_UnpackMisc(RF, OutData%TStC(i1)) ! TStC 
      end do
   end if
   if (allocated(OutData%SStC)) deallocate(OutData%SStC)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%SStC(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%SStC.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call StC_UnpackMisc(RF, OutData%SStC(i1)) ! SStC 
      end do
   end if
   if (allocated(OutData%u_BStC)) deallocate(OutData%u_BStC)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 2, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%u_BStC(LB(1):UB(1),LB(2):UB(2)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%u_BStC.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call StC_UnpackInput(RF, OutData%u_BStC(i1,i2)) ! u_BStC 
         end do
      end do
   end if
   if (allocated(OutData%u_NStC)) deallocate(OutData%u_NStC)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 2, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%u_NStC(LB(1):UB(1),LB(2):UB(2)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%u_NStC.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call StC_UnpackInput(RF, OutData%u_NStC(i1,i2)) ! u_NStC 
         end do
      end do
   end if
   if (allocated(OutData%u_TStC)) deallocate(OutData%u_TStC)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 2, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%u_TStC(LB(1):UB(1),LB(2):UB(2)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%u_TStC.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call StC_UnpackInput(RF, OutData%u_TStC(i1,i2)) ! u_TStC 
         end do
      end do
   end if
   if (allocated(OutData%u_SStC)) deallocate(OutData%u_SStC)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 2, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%u_SStC(LB(1):UB(1),LB(2):UB(2)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%u_SStC.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call StC_UnpackInput(RF, OutData%u_SStC(i1,i2)) ! u_SStC 
         end do
      end do
   end if
   if (allocated(OutData%y_BStC)) deallocate(OutData%y_BStC)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%y_BStC(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%y_BStC.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call StC_UnpackOutput(RF, OutData%y_BStC(i1)) ! y_BStC 
      end do
   end if
   if (allocated(OutData%y_NStC)) deallocate(OutData%y_NStC)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%y_NStC(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%y_NStC.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call StC_UnpackOutput(RF, OutData%y_NStC(i1)) ! y_NStC 
      end do
   end if
   if (allocated(OutData%y_TStC)) deallocate(OutData%y_TStC)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%y_TStC(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%y_TStC.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call StC_UnpackOutput(RF, OutData%y_TStC(i1)) ! y_TStC 
      end do
   end if
   if (allocated(OutData%y_SStC)) deallocate(OutData%y_SStC)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%y_SStC(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%y_SStC.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call StC_UnpackOutput(RF, OutData%y_SStC(i1)) ! y_SStC 
      end do
   end if
   call SrvD_UnpackModuleMapType(RF, OutData%SrvD_MeshMap) ! SrvD_MeshMap 
   call RegUnpack(RF, OutData%PrevTstepNcall); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SrvD_CopyParam(SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg)
   type(SrvD_ParameterType), intent(in) :: SrcParamData
   type(SrvD_ParameterType), intent(inout) :: DstParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SrvD_CopyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstParamData%DT = SrcParamData%DT
   DstParamData%HSSBrDT = SrcParamData%HSSBrDT
   DstParamData%HSSBrTqF = SrcParamData%HSSBrTqF
   DstParamData%SIG_POSl = SrcParamData%SIG_POSl
   DstParamData%SIG_POTq = SrcParamData%SIG_POTq
   DstParamData%SIG_SlPc = SrcParamData%SIG_SlPc
   DstParamData%SIG_Slop = SrcParamData%SIG_Slop
   DstParamData%SIG_SySp = SrcParamData%SIG_SySp
   DstParamData%TEC_A0 = SrcParamData%TEC_A0
   DstParamData%TEC_C0 = SrcParamData%TEC_C0
   DstParamData%TEC_C1 = SrcParamData%TEC_C1
   DstParamData%TEC_C2 = SrcParamData%TEC_C2
   DstParamData%TEC_K2 = SrcParamData%TEC_K2
   DstParamData%TEC_MR = SrcParamData%TEC_MR
   DstParamData%TEC_Re1 = SrcParamData%TEC_Re1
   DstParamData%TEC_RLR = SrcParamData%TEC_RLR
   DstParamData%TEC_RRes = SrcParamData%TEC_RRes
   DstParamData%TEC_SRes = SrcParamData%TEC_SRes
   DstParamData%TEC_SySp = SrcParamData%TEC_SySp
   DstParamData%TEC_V1a = SrcParamData%TEC_V1a
   DstParamData%TEC_VLL = SrcParamData%TEC_VLL
   DstParamData%TEC_Xe1 = SrcParamData%TEC_Xe1
   DstParamData%GenEff = SrcParamData%GenEff
   if (allocated(SrcParamData%BlPitchInit)) then
      LB(1:1) = lbound(SrcParamData%BlPitchInit)
      UB(1:1) = ubound(SrcParamData%BlPitchInit)
      if (.not. allocated(DstParamData%BlPitchInit)) then
         allocate(DstParamData%BlPitchInit(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%BlPitchInit.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%BlPitchInit = SrcParamData%BlPitchInit
   end if
   if (allocated(SrcParamData%BlPitchF)) then
      LB(1:1) = lbound(SrcParamData%BlPitchF)
      UB(1:1) = ubound(SrcParamData%BlPitchF)
      if (.not. allocated(DstParamData%BlPitchF)) then
         allocate(DstParamData%BlPitchF(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%BlPitchF.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%BlPitchF = SrcParamData%BlPitchF
   end if
   if (allocated(SrcParamData%PitManRat)) then
      LB(1:1) = lbound(SrcParamData%PitManRat)
      UB(1:1) = ubound(SrcParamData%PitManRat)
      if (.not. allocated(DstParamData%PitManRat)) then
         allocate(DstParamData%PitManRat(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%PitManRat.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%PitManRat = SrcParamData%PitManRat
   end if
   DstParamData%YawManRat = SrcParamData%YawManRat
   DstParamData%NacYawF = SrcParamData%NacYawF
   DstParamData%SpdGenOn = SrcParamData%SpdGenOn
   DstParamData%THSSBrDp = SrcParamData%THSSBrDp
   DstParamData%THSSBrFl = SrcParamData%THSSBrFl
   DstParamData%TimGenOf = SrcParamData%TimGenOf
   DstParamData%TimGenOn = SrcParamData%TimGenOn
   DstParamData%TPCOn = SrcParamData%TPCOn
   if (allocated(SrcParamData%TPitManS)) then
      LB(1:1) = lbound(SrcParamData%TPitManS)
      UB(1:1) = ubound(SrcParamData%TPitManS)
      if (.not. allocated(DstParamData%TPitManS)) then
         allocate(DstParamData%TPitManS(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%TPitManS.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%TPitManS = SrcParamData%TPitManS
   end if
   DstParamData%TYawManS = SrcParamData%TYawManS
   DstParamData%TYCOn = SrcParamData%TYCOn
   DstParamData%VS_RtGnSp = SrcParamData%VS_RtGnSp
   DstParamData%VS_RtTq = SrcParamData%VS_RtTq
   DstParamData%VS_Slope = SrcParamData%VS_Slope
   DstParamData%VS_SlPc = SrcParamData%VS_SlPc
   DstParamData%VS_SySp = SrcParamData%VS_SySp
   DstParamData%VS_TrGnSp = SrcParamData%VS_TrGnSp
   DstParamData%YawPosCom = SrcParamData%YawPosCom
   DstParamData%YawRateCom = SrcParamData%YawRateCom
   DstParamData%GenModel = SrcParamData%GenModel
   DstParamData%HSSBrMode = SrcParamData%HSSBrMode
   DstParamData%PCMode = SrcParamData%PCMode
   DstParamData%VSContrl = SrcParamData%VSContrl
   DstParamData%YCMode = SrcParamData%YCMode
   DstParamData%GenTiStp = SrcParamData%GenTiStp
   DstParamData%GenTiStr = SrcParamData%GenTiStr
   DstParamData%VS_Rgn2K = SrcParamData%VS_Rgn2K
   DstParamData%YawNeut = SrcParamData%YawNeut
   DstParamData%YawSpr = SrcParamData%YawSpr
   DstParamData%YawDamp = SrcParamData%YawDamp
   DstParamData%TpBrDT = SrcParamData%TpBrDT
   if (allocated(SrcParamData%TBDepISp)) then
      LB(1:1) = lbound(SrcParamData%TBDepISp)
      UB(1:1) = ubound(SrcParamData%TBDepISp)
      if (.not. allocated(DstParamData%TBDepISp)) then
         allocate(DstParamData%TBDepISp(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%TBDepISp.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%TBDepISp = SrcParamData%TBDepISp
   end if
   DstParamData%TBDrConN = SrcParamData%TBDrConN
   DstParamData%TBDrConD = SrcParamData%TBDrConD
   DstParamData%NumBl = SrcParamData%NumBl
   DstParamData%NumBStC = SrcParamData%NumBStC
   DstParamData%NumNStC = SrcParamData%NumNStC
   DstParamData%NumTStC = SrcParamData%NumTStC
   DstParamData%NumSStC = SrcParamData%NumSStC
   DstParamData%AfCmode = SrcParamData%AfCmode
   DstParamData%AfC_Mean = SrcParamData%AfC_Mean
   DstParamData%AfC_Amp = SrcParamData%AfC_Amp
   DstParamData%AfC_Phase = SrcParamData%AfC_Phase
   DstParamData%CCmode = SrcParamData%CCmode
   DstParamData%StCCmode = SrcParamData%StCCmode
   DstParamData%NumOuts = SrcParamData%NumOuts
   DstParamData%NumOuts_DLL = SrcParamData%NumOuts_DLL
   DstParamData%RootName = SrcParamData%RootName
   DstParamData%PriPath = SrcParamData%PriPath
   if (allocated(SrcParamData%OutParam)) then
      LB(1:1) = lbound(SrcParamData%OutParam)
      UB(1:1) = ubound(SrcParamData%OutParam)
      if (.not. allocated(DstParamData%OutParam)) then
         allocate(DstParamData%OutParam(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%OutParam.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyOutParmType(SrcParamData%OutParam(i1), DstParamData%OutParam(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstParamData%Delim = SrcParamData%Delim
   DstParamData%UseBladedInterface = SrcParamData%UseBladedInterface
   DstParamData%UseLegacyInterface = SrcParamData%UseLegacyInterface
   DstParamData%DLL_Trgt = SrcParamData%DLL_Trgt
   DstParamData%DLL_Ramp = SrcParamData%DLL_Ramp
   DstParamData%BlAlpha = SrcParamData%BlAlpha
   DstParamData%DLL_n = SrcParamData%DLL_n
   DstParamData%avcOUTNAME_LEN = SrcParamData%avcOUTNAME_LEN
   DstParamData%NacYaw_North = SrcParamData%NacYaw_North
   DstParamData%AvgWindSpeed = SrcParamData%AvgWindSpeed
   DstParamData%AirDens = SrcParamData%AirDens
   DstParamData%TrimCase = SrcParamData%TrimCase
   DstParamData%TrimGain = SrcParamData%TrimGain
   DstParamData%RotSpeedRef = SrcParamData%RotSpeedRef
   if (allocated(SrcParamData%BStC)) then
      LB(1:1) = lbound(SrcParamData%BStC)
      UB(1:1) = ubound(SrcParamData%BStC)
      if (.not. allocated(DstParamData%BStC)) then
         allocate(DstParamData%BStC(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%BStC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call StC_CopyParam(SrcParamData%BStC(i1), DstParamData%BStC(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcParamData%NStC)) then
      LB(1:1) = lbound(SrcParamData%NStC)
      UB(1:1) = ubound(SrcParamData%NStC)
      if (.not. allocated(DstParamData%NStC)) then
         allocate(DstParamData%NStC(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%NStC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call StC_CopyParam(SrcParamData%NStC(i1), DstParamData%NStC(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcParamData%TStC)) then
      LB(1:1) = lbound(SrcParamData%TStC)
      UB(1:1) = ubound(SrcParamData%TStC)
      if (.not. allocated(DstParamData%TStC)) then
         allocate(DstParamData%TStC(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%TStC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call StC_CopyParam(SrcParamData%TStC(i1), DstParamData%TStC(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcParamData%SStC)) then
      LB(1:1) = lbound(SrcParamData%SStC)
      UB(1:1) = ubound(SrcParamData%SStC)
      if (.not. allocated(DstParamData%SStC)) then
         allocate(DstParamData%SStC(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%SStC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call StC_CopyParam(SrcParamData%SStC(i1), DstParamData%SStC(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstParamData%InterpOrder = SrcParamData%InterpOrder
   DstParamData%EXavrSWAP = SrcParamData%EXavrSWAP
   DstParamData%NumCableControl = SrcParamData%NumCableControl
   DstParamData%NumStC_Control = SrcParamData%NumStC_Control
   if (allocated(SrcParamData%StCMeasNumPerChan)) then
      LB(1:1) = lbound(SrcParamData%StCMeasNumPerChan)
      UB(1:1) = ubound(SrcParamData%StCMeasNumPerChan)
      if (.not. allocated(DstParamData%StCMeasNumPerChan)) then
         allocate(DstParamData%StCMeasNumPerChan(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%StCMeasNumPerChan.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%StCMeasNumPerChan = SrcParamData%StCMeasNumPerChan
   end if
   if (allocated(SrcParamData%Jac_u_indx)) then
      LB(1:2) = lbound(SrcParamData%Jac_u_indx)
      UB(1:2) = ubound(SrcParamData%Jac_u_indx)
      if (.not. allocated(DstParamData%Jac_u_indx)) then
         allocate(DstParamData%Jac_u_indx(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Jac_u_indx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Jac_u_indx = SrcParamData%Jac_u_indx
   end if
   if (allocated(SrcParamData%Jac_x_indx)) then
      LB(1:2) = lbound(SrcParamData%Jac_x_indx)
      UB(1:2) = ubound(SrcParamData%Jac_x_indx)
      if (.not. allocated(DstParamData%Jac_x_indx)) then
         allocate(DstParamData%Jac_x_indx(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Jac_x_indx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Jac_x_indx = SrcParamData%Jac_x_indx
   end if
   if (allocated(SrcParamData%du)) then
      LB(1:1) = lbound(SrcParamData%du)
      UB(1:1) = ubound(SrcParamData%du)
      if (.not. allocated(DstParamData%du)) then
         allocate(DstParamData%du(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%du.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%du = SrcParamData%du
   end if
   if (allocated(SrcParamData%dx)) then
      LB(1:1) = lbound(SrcParamData%dx)
      UB(1:1) = ubound(SrcParamData%dx)
      if (.not. allocated(DstParamData%dx)) then
         allocate(DstParamData%dx(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%dx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%dx = SrcParamData%dx
   end if
   DstParamData%Jac_nu = SrcParamData%Jac_nu
   DstParamData%Jac_ny = SrcParamData%Jac_ny
   DstParamData%Jac_nx = SrcParamData%Jac_nx
   if (allocated(SrcParamData%Jac_Idx_BStC_u)) then
      LB(1:3) = lbound(SrcParamData%Jac_Idx_BStC_u)
      UB(1:3) = ubound(SrcParamData%Jac_Idx_BStC_u)
      if (.not. allocated(DstParamData%Jac_Idx_BStC_u)) then
         allocate(DstParamData%Jac_Idx_BStC_u(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Jac_Idx_BStC_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Jac_Idx_BStC_u = SrcParamData%Jac_Idx_BStC_u
   end if
   if (allocated(SrcParamData%Jac_Idx_NStC_u)) then
      LB(1:2) = lbound(SrcParamData%Jac_Idx_NStC_u)
      UB(1:2) = ubound(SrcParamData%Jac_Idx_NStC_u)
      if (.not. allocated(DstParamData%Jac_Idx_NStC_u)) then
         allocate(DstParamData%Jac_Idx_NStC_u(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Jac_Idx_NStC_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Jac_Idx_NStC_u = SrcParamData%Jac_Idx_NStC_u
   end if
   if (allocated(SrcParamData%Jac_Idx_TStC_u)) then
      LB(1:2) = lbound(SrcParamData%Jac_Idx_TStC_u)
      UB(1:2) = ubound(SrcParamData%Jac_Idx_TStC_u)
      if (.not. allocated(DstParamData%Jac_Idx_TStC_u)) then
         allocate(DstParamData%Jac_Idx_TStC_u(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Jac_Idx_TStC_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Jac_Idx_TStC_u = SrcParamData%Jac_Idx_TStC_u
   end if
   if (allocated(SrcParamData%Jac_Idx_SStC_u)) then
      LB(1:2) = lbound(SrcParamData%Jac_Idx_SStC_u)
      UB(1:2) = ubound(SrcParamData%Jac_Idx_SStC_u)
      if (.not. allocated(DstParamData%Jac_Idx_SStC_u)) then
         allocate(DstParamData%Jac_Idx_SStC_u(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Jac_Idx_SStC_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Jac_Idx_SStC_u = SrcParamData%Jac_Idx_SStC_u
   end if
   if (allocated(SrcParamData%Jac_Idx_BStC_x)) then
      LB(1:3) = lbound(SrcParamData%Jac_Idx_BStC_x)
      UB(1:3) = ubound(SrcParamData%Jac_Idx_BStC_x)
      if (.not. allocated(DstParamData%Jac_Idx_BStC_x)) then
         allocate(DstParamData%Jac_Idx_BStC_x(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Jac_Idx_BStC_x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Jac_Idx_BStC_x = SrcParamData%Jac_Idx_BStC_x
   end if
   if (allocated(SrcParamData%Jac_Idx_NStC_x)) then
      LB(1:2) = lbound(SrcParamData%Jac_Idx_NStC_x)
      UB(1:2) = ubound(SrcParamData%Jac_Idx_NStC_x)
      if (.not. allocated(DstParamData%Jac_Idx_NStC_x)) then
         allocate(DstParamData%Jac_Idx_NStC_x(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Jac_Idx_NStC_x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Jac_Idx_NStC_x = SrcParamData%Jac_Idx_NStC_x
   end if
   if (allocated(SrcParamData%Jac_Idx_TStC_x)) then
      LB(1:2) = lbound(SrcParamData%Jac_Idx_TStC_x)
      UB(1:2) = ubound(SrcParamData%Jac_Idx_TStC_x)
      if (.not. allocated(DstParamData%Jac_Idx_TStC_x)) then
         allocate(DstParamData%Jac_Idx_TStC_x(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Jac_Idx_TStC_x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Jac_Idx_TStC_x = SrcParamData%Jac_Idx_TStC_x
   end if
   if (allocated(SrcParamData%Jac_Idx_SStC_x)) then
      LB(1:2) = lbound(SrcParamData%Jac_Idx_SStC_x)
      UB(1:2) = ubound(SrcParamData%Jac_Idx_SStC_x)
      if (.not. allocated(DstParamData%Jac_Idx_SStC_x)) then
         allocate(DstParamData%Jac_Idx_SStC_x(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Jac_Idx_SStC_x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Jac_Idx_SStC_x = SrcParamData%Jac_Idx_SStC_x
   end if
   if (allocated(SrcParamData%Jac_Idx_BStC_y)) then
      LB(1:3) = lbound(SrcParamData%Jac_Idx_BStC_y)
      UB(1:3) = ubound(SrcParamData%Jac_Idx_BStC_y)
      if (.not. allocated(DstParamData%Jac_Idx_BStC_y)) then
         allocate(DstParamData%Jac_Idx_BStC_y(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Jac_Idx_BStC_y.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Jac_Idx_BStC_y = SrcParamData%Jac_Idx_BStC_y
   end if
   if (allocated(SrcParamData%Jac_Idx_NStC_y)) then
      LB(1:2) = lbound(SrcParamData%Jac_Idx_NStC_y)
      UB(1:2) = ubound(SrcParamData%Jac_Idx_NStC_y)
      if (.not. allocated(DstParamData%Jac_Idx_NStC_y)) then
         allocate(DstParamData%Jac_Idx_NStC_y(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Jac_Idx_NStC_y.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Jac_Idx_NStC_y = SrcParamData%Jac_Idx_NStC_y
   end if
   if (allocated(SrcParamData%Jac_Idx_TStC_y)) then
      LB(1:2) = lbound(SrcParamData%Jac_Idx_TStC_y)
      UB(1:2) = ubound(SrcParamData%Jac_Idx_TStC_y)
      if (.not. allocated(DstParamData%Jac_Idx_TStC_y)) then
         allocate(DstParamData%Jac_Idx_TStC_y(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Jac_Idx_TStC_y.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Jac_Idx_TStC_y = SrcParamData%Jac_Idx_TStC_y
   end if
   if (allocated(SrcParamData%Jac_Idx_SStC_y)) then
      LB(1:2) = lbound(SrcParamData%Jac_Idx_SStC_y)
      UB(1:2) = ubound(SrcParamData%Jac_Idx_SStC_y)
      if (.not. allocated(DstParamData%Jac_Idx_SStC_y)) then
         allocate(DstParamData%Jac_Idx_SStC_y(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Jac_Idx_SStC_y.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Jac_Idx_SStC_y = SrcParamData%Jac_Idx_SStC_y
   end if
   DstParamData%SensorType = SrcParamData%SensorType
   DstParamData%NumBeam = SrcParamData%NumBeam
   DstParamData%NumPulseGate = SrcParamData%NumPulseGate
end subroutine

subroutine SrvD_DestroyParam(ParamData, ErrStat, ErrMsg)
   type(SrvD_ParameterType), intent(inout) :: ParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SrvD_DestroyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ParamData%BlPitchInit)) then
      deallocate(ParamData%BlPitchInit)
   end if
   if (allocated(ParamData%BlPitchF)) then
      deallocate(ParamData%BlPitchF)
   end if
   if (allocated(ParamData%PitManRat)) then
      deallocate(ParamData%PitManRat)
   end if
   if (allocated(ParamData%TPitManS)) then
      deallocate(ParamData%TPitManS)
   end if
   if (allocated(ParamData%TBDepISp)) then
      deallocate(ParamData%TBDepISp)
   end if
   if (allocated(ParamData%OutParam)) then
      LB(1:1) = lbound(ParamData%OutParam)
      UB(1:1) = ubound(ParamData%OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyOutParmType(ParamData%OutParam(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%OutParam)
   end if
   call FreeDynamicLib( ParamData%DLL_Trgt, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(ParamData%BStC)) then
      LB(1:1) = lbound(ParamData%BStC)
      UB(1:1) = ubound(ParamData%BStC)
      do i1 = LB(1), UB(1)
         call StC_DestroyParam(ParamData%BStC(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%BStC)
   end if
   if (allocated(ParamData%NStC)) then
      LB(1:1) = lbound(ParamData%NStC)
      UB(1:1) = ubound(ParamData%NStC)
      do i1 = LB(1), UB(1)
         call StC_DestroyParam(ParamData%NStC(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%NStC)
   end if
   if (allocated(ParamData%TStC)) then
      LB(1:1) = lbound(ParamData%TStC)
      UB(1:1) = ubound(ParamData%TStC)
      do i1 = LB(1), UB(1)
         call StC_DestroyParam(ParamData%TStC(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%TStC)
   end if
   if (allocated(ParamData%SStC)) then
      LB(1:1) = lbound(ParamData%SStC)
      UB(1:1) = ubound(ParamData%SStC)
      do i1 = LB(1), UB(1)
         call StC_DestroyParam(ParamData%SStC(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%SStC)
   end if
   if (allocated(ParamData%StCMeasNumPerChan)) then
      deallocate(ParamData%StCMeasNumPerChan)
   end if
   if (allocated(ParamData%Jac_u_indx)) then
      deallocate(ParamData%Jac_u_indx)
   end if
   if (allocated(ParamData%Jac_x_indx)) then
      deallocate(ParamData%Jac_x_indx)
   end if
   if (allocated(ParamData%du)) then
      deallocate(ParamData%du)
   end if
   if (allocated(ParamData%dx)) then
      deallocate(ParamData%dx)
   end if
   if (allocated(ParamData%Jac_Idx_BStC_u)) then
      deallocate(ParamData%Jac_Idx_BStC_u)
   end if
   if (allocated(ParamData%Jac_Idx_NStC_u)) then
      deallocate(ParamData%Jac_Idx_NStC_u)
   end if
   if (allocated(ParamData%Jac_Idx_TStC_u)) then
      deallocate(ParamData%Jac_Idx_TStC_u)
   end if
   if (allocated(ParamData%Jac_Idx_SStC_u)) then
      deallocate(ParamData%Jac_Idx_SStC_u)
   end if
   if (allocated(ParamData%Jac_Idx_BStC_x)) then
      deallocate(ParamData%Jac_Idx_BStC_x)
   end if
   if (allocated(ParamData%Jac_Idx_NStC_x)) then
      deallocate(ParamData%Jac_Idx_NStC_x)
   end if
   if (allocated(ParamData%Jac_Idx_TStC_x)) then
      deallocate(ParamData%Jac_Idx_TStC_x)
   end if
   if (allocated(ParamData%Jac_Idx_SStC_x)) then
      deallocate(ParamData%Jac_Idx_SStC_x)
   end if
   if (allocated(ParamData%Jac_Idx_BStC_y)) then
      deallocate(ParamData%Jac_Idx_BStC_y)
   end if
   if (allocated(ParamData%Jac_Idx_NStC_y)) then
      deallocate(ParamData%Jac_Idx_NStC_y)
   end if
   if (allocated(ParamData%Jac_Idx_TStC_y)) then
      deallocate(ParamData%Jac_Idx_TStC_y)
   end if
   if (allocated(ParamData%Jac_Idx_SStC_y)) then
      deallocate(ParamData%Jac_Idx_SStC_y)
   end if
end subroutine

subroutine SrvD_PackParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SrvD_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SrvD_PackParam'
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)   :: LB(3), UB(3)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DT)
   call RegPack(RF, InData%HSSBrDT)
   call RegPack(RF, InData%HSSBrTqF)
   call RegPack(RF, InData%SIG_POSl)
   call RegPack(RF, InData%SIG_POTq)
   call RegPack(RF, InData%SIG_SlPc)
   call RegPack(RF, InData%SIG_Slop)
   call RegPack(RF, InData%SIG_SySp)
   call RegPack(RF, InData%TEC_A0)
   call RegPack(RF, InData%TEC_C0)
   call RegPack(RF, InData%TEC_C1)
   call RegPack(RF, InData%TEC_C2)
   call RegPack(RF, InData%TEC_K2)
   call RegPack(RF, InData%TEC_MR)
   call RegPack(RF, InData%TEC_Re1)
   call RegPack(RF, InData%TEC_RLR)
   call RegPack(RF, InData%TEC_RRes)
   call RegPack(RF, InData%TEC_SRes)
   call RegPack(RF, InData%TEC_SySp)
   call RegPack(RF, InData%TEC_V1a)
   call RegPack(RF, InData%TEC_VLL)
   call RegPack(RF, InData%TEC_Xe1)
   call RegPack(RF, InData%GenEff)
   call RegPackAlloc(RF, InData%BlPitchInit)
   call RegPackAlloc(RF, InData%BlPitchF)
   call RegPackAlloc(RF, InData%PitManRat)
   call RegPack(RF, InData%YawManRat)
   call RegPack(RF, InData%NacYawF)
   call RegPack(RF, InData%SpdGenOn)
   call RegPack(RF, InData%THSSBrDp)
   call RegPack(RF, InData%THSSBrFl)
   call RegPack(RF, InData%TimGenOf)
   call RegPack(RF, InData%TimGenOn)
   call RegPack(RF, InData%TPCOn)
   call RegPackAlloc(RF, InData%TPitManS)
   call RegPack(RF, InData%TYawManS)
   call RegPack(RF, InData%TYCOn)
   call RegPack(RF, InData%VS_RtGnSp)
   call RegPack(RF, InData%VS_RtTq)
   call RegPack(RF, InData%VS_Slope)
   call RegPack(RF, InData%VS_SlPc)
   call RegPack(RF, InData%VS_SySp)
   call RegPack(RF, InData%VS_TrGnSp)
   call RegPack(RF, InData%YawPosCom)
   call RegPack(RF, InData%YawRateCom)
   call RegPack(RF, InData%GenModel)
   call RegPack(RF, InData%HSSBrMode)
   call RegPack(RF, InData%PCMode)
   call RegPack(RF, InData%VSContrl)
   call RegPack(RF, InData%YCMode)
   call RegPack(RF, InData%GenTiStp)
   call RegPack(RF, InData%GenTiStr)
   call RegPack(RF, InData%VS_Rgn2K)
   call RegPack(RF, InData%YawNeut)
   call RegPack(RF, InData%YawSpr)
   call RegPack(RF, InData%YawDamp)
   call RegPack(RF, InData%TpBrDT)
   call RegPackAlloc(RF, InData%TBDepISp)
   call RegPack(RF, InData%TBDrConN)
   call RegPack(RF, InData%TBDrConD)
   call RegPack(RF, InData%NumBl)
   call RegPack(RF, InData%NumBStC)
   call RegPack(RF, InData%NumNStC)
   call RegPack(RF, InData%NumTStC)
   call RegPack(RF, InData%NumSStC)
   call RegPack(RF, InData%AfCmode)
   call RegPack(RF, InData%AfC_Mean)
   call RegPack(RF, InData%AfC_Amp)
   call RegPack(RF, InData%AfC_Phase)
   call RegPack(RF, InData%CCmode)
   call RegPack(RF, InData%StCCmode)
   call RegPack(RF, InData%NumOuts)
   call RegPack(RF, InData%NumOuts_DLL)
   call RegPack(RF, InData%RootName)
   call RegPack(RF, InData%PriPath)
   call RegPack(RF, allocated(InData%OutParam))
   if (allocated(InData%OutParam)) then
      call RegPackBounds(RF, 1, lbound(InData%OutParam), ubound(InData%OutParam))
      LB(1:1) = lbound(InData%OutParam)
      UB(1:1) = ubound(InData%OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackOutParmType(RF, InData%OutParam(i1)) 
      end do
   end if
   call RegPack(RF, InData%Delim)
   call RegPack(RF, InData%UseBladedInterface)
   call RegPack(RF, InData%UseLegacyInterface)
   call DLLTypePack(RF, InData%DLL_Trgt) 
   call RegPack(RF, InData%DLL_Ramp)
   call RegPack(RF, InData%BlAlpha)
   call RegPack(RF, InData%DLL_n)
   call RegPack(RF, InData%avcOUTNAME_LEN)
   call RegPack(RF, InData%NacYaw_North)
   call RegPack(RF, InData%AvgWindSpeed)
   call RegPack(RF, InData%AirDens)
   call RegPack(RF, InData%TrimCase)
   call RegPack(RF, InData%TrimGain)
   call RegPack(RF, InData%RotSpeedRef)
   call RegPack(RF, allocated(InData%BStC))
   if (allocated(InData%BStC)) then
      call RegPackBounds(RF, 1, lbound(InData%BStC), ubound(InData%BStC))
      LB(1:1) = lbound(InData%BStC)
      UB(1:1) = ubound(InData%BStC)
      do i1 = LB(1), UB(1)
         call StC_PackParam(RF, InData%BStC(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%NStC))
   if (allocated(InData%NStC)) then
      call RegPackBounds(RF, 1, lbound(InData%NStC), ubound(InData%NStC))
      LB(1:1) = lbound(InData%NStC)
      UB(1:1) = ubound(InData%NStC)
      do i1 = LB(1), UB(1)
         call StC_PackParam(RF, InData%NStC(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%TStC))
   if (allocated(InData%TStC)) then
      call RegPackBounds(RF, 1, lbound(InData%TStC), ubound(InData%TStC))
      LB(1:1) = lbound(InData%TStC)
      UB(1:1) = ubound(InData%TStC)
      do i1 = LB(1), UB(1)
         call StC_PackParam(RF, InData%TStC(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%SStC))
   if (allocated(InData%SStC)) then
      call RegPackBounds(RF, 1, lbound(InData%SStC), ubound(InData%SStC))
      LB(1:1) = lbound(InData%SStC)
      UB(1:1) = ubound(InData%SStC)
      do i1 = LB(1), UB(1)
         call StC_PackParam(RF, InData%SStC(i1)) 
      end do
   end if
   call RegPack(RF, InData%InterpOrder)
   call RegPack(RF, InData%EXavrSWAP)
   call RegPack(RF, InData%NumCableControl)
   call RegPack(RF, InData%NumStC_Control)
   call RegPackAlloc(RF, InData%StCMeasNumPerChan)
   call RegPackAlloc(RF, InData%Jac_u_indx)
   call RegPackAlloc(RF, InData%Jac_x_indx)
   call RegPackAlloc(RF, InData%du)
   call RegPackAlloc(RF, InData%dx)
   call RegPack(RF, InData%Jac_nu)
   call RegPack(RF, InData%Jac_ny)
   call RegPack(RF, InData%Jac_nx)
   call RegPackAlloc(RF, InData%Jac_Idx_BStC_u)
   call RegPackAlloc(RF, InData%Jac_Idx_NStC_u)
   call RegPackAlloc(RF, InData%Jac_Idx_TStC_u)
   call RegPackAlloc(RF, InData%Jac_Idx_SStC_u)
   call RegPackAlloc(RF, InData%Jac_Idx_BStC_x)
   call RegPackAlloc(RF, InData%Jac_Idx_NStC_x)
   call RegPackAlloc(RF, InData%Jac_Idx_TStC_x)
   call RegPackAlloc(RF, InData%Jac_Idx_SStC_x)
   call RegPackAlloc(RF, InData%Jac_Idx_BStC_y)
   call RegPackAlloc(RF, InData%Jac_Idx_NStC_y)
   call RegPackAlloc(RF, InData%Jac_Idx_TStC_y)
   call RegPackAlloc(RF, InData%Jac_Idx_SStC_y)
   call RegPack(RF, InData%SensorType)
   call RegPack(RF, InData%NumBeam)
   call RegPack(RF, InData%NumPulseGate)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SrvD_UnPackParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SrvD_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SrvD_UnPackParam'
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HSSBrDT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HSSBrTqF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SIG_POSl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SIG_POTq); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SIG_SlPc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SIG_Slop); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SIG_SySp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TEC_A0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TEC_C0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TEC_C1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TEC_C2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TEC_K2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TEC_MR); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TEC_Re1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TEC_RLR); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TEC_RRes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TEC_SRes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TEC_SySp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TEC_V1a); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TEC_VLL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TEC_Xe1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GenEff); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BlPitchInit); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BlPitchF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PitManRat); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawManRat); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NacYawF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SpdGenOn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%THSSBrDp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%THSSBrFl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TimGenOf); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TimGenOn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TPCOn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TPitManS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TYawManS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TYCOn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VS_RtGnSp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VS_RtTq); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VS_Slope); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VS_SlPc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VS_SySp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VS_TrGnSp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawPosCom); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawRateCom); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GenModel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HSSBrMode); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PCMode); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VSContrl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YCMode); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GenTiStp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GenTiStr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VS_Rgn2K); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawNeut); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawSpr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawDamp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TpBrDT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TBDepISp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TBDrConN); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TBDrConD); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumBl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumBStC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumNStC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumTStC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumSStC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AfCmode); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AfC_Mean); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AfC_Amp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AfC_Phase); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CCmode); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StCCmode); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumOuts_DLL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PriPath); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%OutParam)) deallocate(OutData%OutParam)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%OutParam(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%OutParam.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackOutParmType(RF, OutData%OutParam(i1)) ! OutParam 
      end do
   end if
   call RegUnpack(RF, OutData%Delim); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UseBladedInterface); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UseLegacyInterface); if (RegCheckErr(RF, RoutineName)) return
   call DLLTypeUnpack(RF, OutData%DLL_Trgt) ! DLL_Trgt 
   call RegUnpack(RF, OutData%DLL_Ramp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BlAlpha); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DLL_n); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%avcOUTNAME_LEN); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NacYaw_North); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AvgWindSpeed); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AirDens); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TrimCase); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TrimGain); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RotSpeedRef); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%BStC)) deallocate(OutData%BStC)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BStC(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BStC.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call StC_UnpackParam(RF, OutData%BStC(i1)) ! BStC 
      end do
   end if
   if (allocated(OutData%NStC)) deallocate(OutData%NStC)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%NStC(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%NStC.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call StC_UnpackParam(RF, OutData%NStC(i1)) ! NStC 
      end do
   end if
   if (allocated(OutData%TStC)) deallocate(OutData%TStC)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%TStC(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%TStC.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call StC_UnpackParam(RF, OutData%TStC(i1)) ! TStC 
      end do
   end if
   if (allocated(OutData%SStC)) deallocate(OutData%SStC)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%SStC(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%SStC.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call StC_UnpackParam(RF, OutData%SStC(i1)) ! SStC 
      end do
   end if
   call RegUnpack(RF, OutData%InterpOrder); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%EXavrSWAP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumCableControl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumStC_Control); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%StCMeasNumPerChan); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Jac_u_indx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Jac_x_indx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%du); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%dx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Jac_nu); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Jac_ny); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Jac_nx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Jac_Idx_BStC_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Jac_Idx_NStC_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Jac_Idx_TStC_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Jac_Idx_SStC_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Jac_Idx_BStC_x); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Jac_Idx_NStC_x); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Jac_Idx_TStC_x); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Jac_Idx_SStC_x); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Jac_Idx_BStC_y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Jac_Idx_NStC_y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Jac_Idx_TStC_y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Jac_Idx_SStC_y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SensorType); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumBeam); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumPulseGate); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SrvD_CopyInput(SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg)
   type(SrvD_InputType), intent(inout) :: SrcInputData
   type(SrvD_InputType), intent(inout) :: DstInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SrvD_CopyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcInputData%BlPitch)) then
      LB(1:1) = lbound(SrcInputData%BlPitch)
      UB(1:1) = ubound(SrcInputData%BlPitch)
      if (.not. allocated(DstInputData%BlPitch)) then
         allocate(DstInputData%BlPitch(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%BlPitch.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%BlPitch = SrcInputData%BlPitch
   end if
   DstInputData%Yaw = SrcInputData%Yaw
   DstInputData%YawRate = SrcInputData%YawRate
   DstInputData%LSS_Spd = SrcInputData%LSS_Spd
   DstInputData%HSS_Spd = SrcInputData%HSS_Spd
   DstInputData%RotSpeed = SrcInputData%RotSpeed
   DstInputData%ExternalYawPosCom = SrcInputData%ExternalYawPosCom
   DstInputData%ExternalYawRateCom = SrcInputData%ExternalYawRateCom
   if (allocated(SrcInputData%ExternalBlPitchCom)) then
      LB(1:1) = lbound(SrcInputData%ExternalBlPitchCom)
      UB(1:1) = ubound(SrcInputData%ExternalBlPitchCom)
      if (.not. allocated(DstInputData%ExternalBlPitchCom)) then
         allocate(DstInputData%ExternalBlPitchCom(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%ExternalBlPitchCom.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%ExternalBlPitchCom = SrcInputData%ExternalBlPitchCom
   end if
   DstInputData%ExternalGenTrq = SrcInputData%ExternalGenTrq
   DstInputData%ExternalElecPwr = SrcInputData%ExternalElecPwr
   DstInputData%ExternalHSSBrFrac = SrcInputData%ExternalHSSBrFrac
   if (allocated(SrcInputData%ExternalBlAirfoilCom)) then
      LB(1:1) = lbound(SrcInputData%ExternalBlAirfoilCom)
      UB(1:1) = ubound(SrcInputData%ExternalBlAirfoilCom)
      if (.not. allocated(DstInputData%ExternalBlAirfoilCom)) then
         allocate(DstInputData%ExternalBlAirfoilCom(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%ExternalBlAirfoilCom.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%ExternalBlAirfoilCom = SrcInputData%ExternalBlAirfoilCom
   end if
   if (allocated(SrcInputData%ExternalCableDeltaL)) then
      LB(1:1) = lbound(SrcInputData%ExternalCableDeltaL)
      UB(1:1) = ubound(SrcInputData%ExternalCableDeltaL)
      if (.not. allocated(DstInputData%ExternalCableDeltaL)) then
         allocate(DstInputData%ExternalCableDeltaL(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%ExternalCableDeltaL.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%ExternalCableDeltaL = SrcInputData%ExternalCableDeltaL
   end if
   if (allocated(SrcInputData%ExternalCableDeltaLdot)) then
      LB(1:1) = lbound(SrcInputData%ExternalCableDeltaLdot)
      UB(1:1) = ubound(SrcInputData%ExternalCableDeltaLdot)
      if (.not. allocated(DstInputData%ExternalCableDeltaLdot)) then
         allocate(DstInputData%ExternalCableDeltaLdot(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%ExternalCableDeltaLdot.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%ExternalCableDeltaLdot = SrcInputData%ExternalCableDeltaLdot
   end if
   DstInputData%TwrAccel = SrcInputData%TwrAccel
   DstInputData%YawErr = SrcInputData%YawErr
   DstInputData%WindDir = SrcInputData%WindDir
   DstInputData%RootMyc = SrcInputData%RootMyc
   DstInputData%YawBrTAxp = SrcInputData%YawBrTAxp
   DstInputData%YawBrTAyp = SrcInputData%YawBrTAyp
   DstInputData%LSSTipPxa = SrcInputData%LSSTipPxa
   DstInputData%RootMxc = SrcInputData%RootMxc
   DstInputData%LSSTipMxa = SrcInputData%LSSTipMxa
   DstInputData%LSSTipMya = SrcInputData%LSSTipMya
   DstInputData%LSSTipMza = SrcInputData%LSSTipMza
   DstInputData%LSSTipMys = SrcInputData%LSSTipMys
   DstInputData%LSSTipMzs = SrcInputData%LSSTipMzs
   DstInputData%YawBrMyn = SrcInputData%YawBrMyn
   DstInputData%YawBrMzn = SrcInputData%YawBrMzn
   DstInputData%NcIMURAxs = SrcInputData%NcIMURAxs
   DstInputData%NcIMURAys = SrcInputData%NcIMURAys
   DstInputData%NcIMURAzs = SrcInputData%NcIMURAzs
   DstInputData%RotPwr = SrcInputData%RotPwr
   DstInputData%HorWindV = SrcInputData%HorWindV
   DstInputData%YawAngle = SrcInputData%YawAngle
   DstInputData%LSShftFxa = SrcInputData%LSShftFxa
   DstInputData%LSShftFys = SrcInputData%LSShftFys
   DstInputData%LSShftFzs = SrcInputData%LSShftFzs
   call MeshCopy(SrcInputData%PtfmMotionMesh, DstInputData%PtfmMotionMesh, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcInputData%BStCMotionMesh)) then
      LB(1:2) = lbound(SrcInputData%BStCMotionMesh)
      UB(1:2) = ubound(SrcInputData%BStCMotionMesh)
      if (.not. allocated(DstInputData%BStCMotionMesh)) then
         allocate(DstInputData%BStCMotionMesh(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%BStCMotionMesh.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call MeshCopy(SrcInputData%BStCMotionMesh(i1,i2), DstInputData%BStCMotionMesh(i1,i2), CtrlCode, ErrStat2, ErrMsg2 )
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
            if (ErrStat >= AbortErrLev) return
         end do
      end do
   end if
   if (allocated(SrcInputData%NStCMotionMesh)) then
      LB(1:1) = lbound(SrcInputData%NStCMotionMesh)
      UB(1:1) = ubound(SrcInputData%NStCMotionMesh)
      if (.not. allocated(DstInputData%NStCMotionMesh)) then
         allocate(DstInputData%NStCMotionMesh(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%NStCMotionMesh.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcInputData%NStCMotionMesh(i1), DstInputData%NStCMotionMesh(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcInputData%TStCMotionMesh)) then
      LB(1:1) = lbound(SrcInputData%TStCMotionMesh)
      UB(1:1) = ubound(SrcInputData%TStCMotionMesh)
      if (.not. allocated(DstInputData%TStCMotionMesh)) then
         allocate(DstInputData%TStCMotionMesh(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%TStCMotionMesh.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcInputData%TStCMotionMesh(i1), DstInputData%TStCMotionMesh(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcInputData%SStCMotionMesh)) then
      LB(1:1) = lbound(SrcInputData%SStCMotionMesh)
      UB(1:1) = ubound(SrcInputData%SStCMotionMesh)
      if (.not. allocated(DstInputData%SStCMotionMesh)) then
         allocate(DstInputData%SStCMotionMesh(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%SStCMotionMesh.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcInputData%SStCMotionMesh(i1), DstInputData%SStCMotionMesh(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcInputData%LidSpeed)) then
      LB(1:1) = lbound(SrcInputData%LidSpeed)
      UB(1:1) = ubound(SrcInputData%LidSpeed)
      if (.not. allocated(DstInputData%LidSpeed)) then
         allocate(DstInputData%LidSpeed(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%LidSpeed.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%LidSpeed = SrcInputData%LidSpeed
   end if
   if (allocated(SrcInputData%MsrPositionsX)) then
      LB(1:1) = lbound(SrcInputData%MsrPositionsX)
      UB(1:1) = ubound(SrcInputData%MsrPositionsX)
      if (.not. allocated(DstInputData%MsrPositionsX)) then
         allocate(DstInputData%MsrPositionsX(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%MsrPositionsX.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%MsrPositionsX = SrcInputData%MsrPositionsX
   end if
   if (allocated(SrcInputData%MsrPositionsY)) then
      LB(1:1) = lbound(SrcInputData%MsrPositionsY)
      UB(1:1) = ubound(SrcInputData%MsrPositionsY)
      if (.not. allocated(DstInputData%MsrPositionsY)) then
         allocate(DstInputData%MsrPositionsY(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%MsrPositionsY.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%MsrPositionsY = SrcInputData%MsrPositionsY
   end if
   if (allocated(SrcInputData%MsrPositionsZ)) then
      LB(1:1) = lbound(SrcInputData%MsrPositionsZ)
      UB(1:1) = ubound(SrcInputData%MsrPositionsZ)
      if (.not. allocated(DstInputData%MsrPositionsZ)) then
         allocate(DstInputData%MsrPositionsZ(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%MsrPositionsZ.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%MsrPositionsZ = SrcInputData%MsrPositionsZ
   end if
end subroutine

subroutine SrvD_DestroyInput(InputData, ErrStat, ErrMsg)
   type(SrvD_InputType), intent(inout) :: InputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SrvD_DestroyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InputData%BlPitch)) then
      deallocate(InputData%BlPitch)
   end if
   if (allocated(InputData%ExternalBlPitchCom)) then
      deallocate(InputData%ExternalBlPitchCom)
   end if
   if (allocated(InputData%ExternalBlAirfoilCom)) then
      deallocate(InputData%ExternalBlAirfoilCom)
   end if
   if (allocated(InputData%ExternalCableDeltaL)) then
      deallocate(InputData%ExternalCableDeltaL)
   end if
   if (allocated(InputData%ExternalCableDeltaLdot)) then
      deallocate(InputData%ExternalCableDeltaLdot)
   end if
   call MeshDestroy( InputData%PtfmMotionMesh, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(InputData%BStCMotionMesh)) then
      LB(1:2) = lbound(InputData%BStCMotionMesh)
      UB(1:2) = ubound(InputData%BStCMotionMesh)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call MeshDestroy( InputData%BStCMotionMesh(i1,i2), ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         end do
      end do
      deallocate(InputData%BStCMotionMesh)
   end if
   if (allocated(InputData%NStCMotionMesh)) then
      LB(1:1) = lbound(InputData%NStCMotionMesh)
      UB(1:1) = ubound(InputData%NStCMotionMesh)
      do i1 = LB(1), UB(1)
         call MeshDestroy( InputData%NStCMotionMesh(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InputData%NStCMotionMesh)
   end if
   if (allocated(InputData%TStCMotionMesh)) then
      LB(1:1) = lbound(InputData%TStCMotionMesh)
      UB(1:1) = ubound(InputData%TStCMotionMesh)
      do i1 = LB(1), UB(1)
         call MeshDestroy( InputData%TStCMotionMesh(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InputData%TStCMotionMesh)
   end if
   if (allocated(InputData%SStCMotionMesh)) then
      LB(1:1) = lbound(InputData%SStCMotionMesh)
      UB(1:1) = ubound(InputData%SStCMotionMesh)
      do i1 = LB(1), UB(1)
         call MeshDestroy( InputData%SStCMotionMesh(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InputData%SStCMotionMesh)
   end if
   if (allocated(InputData%LidSpeed)) then
      deallocate(InputData%LidSpeed)
   end if
   if (allocated(InputData%MsrPositionsX)) then
      deallocate(InputData%MsrPositionsX)
   end if
   if (allocated(InputData%MsrPositionsY)) then
      deallocate(InputData%MsrPositionsY)
   end if
   if (allocated(InputData%MsrPositionsZ)) then
      deallocate(InputData%MsrPositionsZ)
   end if
end subroutine

subroutine SrvD_PackInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SrvD_InputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SrvD_PackInput'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%BlPitch)
   call RegPack(RF, InData%Yaw)
   call RegPack(RF, InData%YawRate)
   call RegPack(RF, InData%LSS_Spd)
   call RegPack(RF, InData%HSS_Spd)
   call RegPack(RF, InData%RotSpeed)
   call RegPack(RF, InData%ExternalYawPosCom)
   call RegPack(RF, InData%ExternalYawRateCom)
   call RegPackAlloc(RF, InData%ExternalBlPitchCom)
   call RegPack(RF, InData%ExternalGenTrq)
   call RegPack(RF, InData%ExternalElecPwr)
   call RegPack(RF, InData%ExternalHSSBrFrac)
   call RegPackAlloc(RF, InData%ExternalBlAirfoilCom)
   call RegPackAlloc(RF, InData%ExternalCableDeltaL)
   call RegPackAlloc(RF, InData%ExternalCableDeltaLdot)
   call RegPack(RF, InData%TwrAccel)
   call RegPack(RF, InData%YawErr)
   call RegPack(RF, InData%WindDir)
   call RegPack(RF, InData%RootMyc)
   call RegPack(RF, InData%YawBrTAxp)
   call RegPack(RF, InData%YawBrTAyp)
   call RegPack(RF, InData%LSSTipPxa)
   call RegPack(RF, InData%RootMxc)
   call RegPack(RF, InData%LSSTipMxa)
   call RegPack(RF, InData%LSSTipMya)
   call RegPack(RF, InData%LSSTipMza)
   call RegPack(RF, InData%LSSTipMys)
   call RegPack(RF, InData%LSSTipMzs)
   call RegPack(RF, InData%YawBrMyn)
   call RegPack(RF, InData%YawBrMzn)
   call RegPack(RF, InData%NcIMURAxs)
   call RegPack(RF, InData%NcIMURAys)
   call RegPack(RF, InData%NcIMURAzs)
   call RegPack(RF, InData%RotPwr)
   call RegPack(RF, InData%HorWindV)
   call RegPack(RF, InData%YawAngle)
   call RegPack(RF, InData%LSShftFxa)
   call RegPack(RF, InData%LSShftFys)
   call RegPack(RF, InData%LSShftFzs)
   call MeshPack(RF, InData%PtfmMotionMesh) 
   call RegPack(RF, allocated(InData%BStCMotionMesh))
   if (allocated(InData%BStCMotionMesh)) then
      call RegPackBounds(RF, 2, lbound(InData%BStCMotionMesh), ubound(InData%BStCMotionMesh))
      LB(1:2) = lbound(InData%BStCMotionMesh)
      UB(1:2) = ubound(InData%BStCMotionMesh)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call MeshPack(RF, InData%BStCMotionMesh(i1,i2)) 
         end do
      end do
   end if
   call RegPack(RF, allocated(InData%NStCMotionMesh))
   if (allocated(InData%NStCMotionMesh)) then
      call RegPackBounds(RF, 1, lbound(InData%NStCMotionMesh), ubound(InData%NStCMotionMesh))
      LB(1:1) = lbound(InData%NStCMotionMesh)
      UB(1:1) = ubound(InData%NStCMotionMesh)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%NStCMotionMesh(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%TStCMotionMesh))
   if (allocated(InData%TStCMotionMesh)) then
      call RegPackBounds(RF, 1, lbound(InData%TStCMotionMesh), ubound(InData%TStCMotionMesh))
      LB(1:1) = lbound(InData%TStCMotionMesh)
      UB(1:1) = ubound(InData%TStCMotionMesh)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%TStCMotionMesh(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%SStCMotionMesh))
   if (allocated(InData%SStCMotionMesh)) then
      call RegPackBounds(RF, 1, lbound(InData%SStCMotionMesh), ubound(InData%SStCMotionMesh))
      LB(1:1) = lbound(InData%SStCMotionMesh)
      UB(1:1) = ubound(InData%SStCMotionMesh)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%SStCMotionMesh(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%LidSpeed)
   call RegPackAlloc(RF, InData%MsrPositionsX)
   call RegPackAlloc(RF, InData%MsrPositionsY)
   call RegPackAlloc(RF, InData%MsrPositionsZ)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SrvD_UnPackInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SrvD_InputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SrvD_UnPackInput'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%BlPitch); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Yaw); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawRate); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LSS_Spd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HSS_Spd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RotSpeed); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ExternalYawPosCom); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ExternalYawRateCom); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%ExternalBlPitchCom); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ExternalGenTrq); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ExternalElecPwr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ExternalHSSBrFrac); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%ExternalBlAirfoilCom); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%ExternalCableDeltaL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%ExternalCableDeltaLdot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TwrAccel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawErr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WindDir); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootMyc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawBrTAxp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawBrTAyp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LSSTipPxa); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootMxc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LSSTipMxa); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LSSTipMya); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LSSTipMza); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LSSTipMys); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LSSTipMzs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawBrMyn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawBrMzn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NcIMURAxs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NcIMURAys); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NcIMURAzs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RotPwr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HorWindV); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawAngle); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LSShftFxa); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LSShftFys); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LSShftFzs); if (RegCheckErr(RF, RoutineName)) return
   call MeshUnpack(RF, OutData%PtfmMotionMesh) ! PtfmMotionMesh 
   if (allocated(OutData%BStCMotionMesh)) deallocate(OutData%BStCMotionMesh)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 2, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BStCMotionMesh(LB(1):UB(1),LB(2):UB(2)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BStCMotionMesh.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call MeshUnpack(RF, OutData%BStCMotionMesh(i1,i2)) ! BStCMotionMesh 
         end do
      end do
   end if
   if (allocated(OutData%NStCMotionMesh)) deallocate(OutData%NStCMotionMesh)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%NStCMotionMesh(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%NStCMotionMesh.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%NStCMotionMesh(i1)) ! NStCMotionMesh 
      end do
   end if
   if (allocated(OutData%TStCMotionMesh)) deallocate(OutData%TStCMotionMesh)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%TStCMotionMesh(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%TStCMotionMesh.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%TStCMotionMesh(i1)) ! TStCMotionMesh 
      end do
   end if
   if (allocated(OutData%SStCMotionMesh)) deallocate(OutData%SStCMotionMesh)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%SStCMotionMesh(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%SStCMotionMesh.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%SStCMotionMesh(i1)) ! SStCMotionMesh 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%LidSpeed); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%MsrPositionsX); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%MsrPositionsY); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%MsrPositionsZ); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SrvD_CopyOutput(SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg)
   type(SrvD_OutputType), intent(inout) :: SrcOutputData
   type(SrvD_OutputType), intent(inout) :: DstOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SrvD_CopyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcOutputData%WriteOutput)) then
      LB(1:1) = lbound(SrcOutputData%WriteOutput)
      UB(1:1) = ubound(SrcOutputData%WriteOutput)
      if (.not. allocated(DstOutputData%WriteOutput)) then
         allocate(DstOutputData%WriteOutput(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%WriteOutput.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%WriteOutput = SrcOutputData%WriteOutput
   end if
   if (allocated(SrcOutputData%BlPitchCom)) then
      LB(1:1) = lbound(SrcOutputData%BlPitchCom)
      UB(1:1) = ubound(SrcOutputData%BlPitchCom)
      if (.not. allocated(DstOutputData%BlPitchCom)) then
         allocate(DstOutputData%BlPitchCom(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%BlPitchCom.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%BlPitchCom = SrcOutputData%BlPitchCom
   end if
   if (allocated(SrcOutputData%BlAirfoilCom)) then
      LB(1:1) = lbound(SrcOutputData%BlAirfoilCom)
      UB(1:1) = ubound(SrcOutputData%BlAirfoilCom)
      if (.not. allocated(DstOutputData%BlAirfoilCom)) then
         allocate(DstOutputData%BlAirfoilCom(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%BlAirfoilCom.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%BlAirfoilCom = SrcOutputData%BlAirfoilCom
   end if
   DstOutputData%YawMom = SrcOutputData%YawMom
   DstOutputData%YawPosCom = SrcOutputData%YawPosCom
   DstOutputData%YawRateCom = SrcOutputData%YawRateCom
   DstOutputData%GenTrq = SrcOutputData%GenTrq
   DstOutputData%HSSBrTrqC = SrcOutputData%HSSBrTrqC
   DstOutputData%ElecPwr = SrcOutputData%ElecPwr
   if (allocated(SrcOutputData%TBDrCon)) then
      LB(1:1) = lbound(SrcOutputData%TBDrCon)
      UB(1:1) = ubound(SrcOutputData%TBDrCon)
      if (.not. allocated(DstOutputData%TBDrCon)) then
         allocate(DstOutputData%TBDrCon(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%TBDrCon.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%TBDrCon = SrcOutputData%TBDrCon
   end if
   if (allocated(SrcOutputData%CableDeltaL)) then
      LB(1:1) = lbound(SrcOutputData%CableDeltaL)
      UB(1:1) = ubound(SrcOutputData%CableDeltaL)
      if (.not. allocated(DstOutputData%CableDeltaL)) then
         allocate(DstOutputData%CableDeltaL(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%CableDeltaL.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%CableDeltaL = SrcOutputData%CableDeltaL
   end if
   if (allocated(SrcOutputData%CableDeltaLdot)) then
      LB(1:1) = lbound(SrcOutputData%CableDeltaLdot)
      UB(1:1) = ubound(SrcOutputData%CableDeltaLdot)
      if (.not. allocated(DstOutputData%CableDeltaLdot)) then
         allocate(DstOutputData%CableDeltaLdot(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%CableDeltaLdot.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%CableDeltaLdot = SrcOutputData%CableDeltaLdot
   end if
   if (allocated(SrcOutputData%BStCLoadMesh)) then
      LB(1:2) = lbound(SrcOutputData%BStCLoadMesh)
      UB(1:2) = ubound(SrcOutputData%BStCLoadMesh)
      if (.not. allocated(DstOutputData%BStCLoadMesh)) then
         allocate(DstOutputData%BStCLoadMesh(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%BStCLoadMesh.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call MeshCopy(SrcOutputData%BStCLoadMesh(i1,i2), DstOutputData%BStCLoadMesh(i1,i2), CtrlCode, ErrStat2, ErrMsg2 )
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
            if (ErrStat >= AbortErrLev) return
         end do
      end do
   end if
   if (allocated(SrcOutputData%NStCLoadMesh)) then
      LB(1:1) = lbound(SrcOutputData%NStCLoadMesh)
      UB(1:1) = ubound(SrcOutputData%NStCLoadMesh)
      if (.not. allocated(DstOutputData%NStCLoadMesh)) then
         allocate(DstOutputData%NStCLoadMesh(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%NStCLoadMesh.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcOutputData%NStCLoadMesh(i1), DstOutputData%NStCLoadMesh(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcOutputData%TStCLoadMesh)) then
      LB(1:1) = lbound(SrcOutputData%TStCLoadMesh)
      UB(1:1) = ubound(SrcOutputData%TStCLoadMesh)
      if (.not. allocated(DstOutputData%TStCLoadMesh)) then
         allocate(DstOutputData%TStCLoadMesh(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%TStCLoadMesh.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcOutputData%TStCLoadMesh(i1), DstOutputData%TStCLoadMesh(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcOutputData%SStCLoadMesh)) then
      LB(1:1) = lbound(SrcOutputData%SStCLoadMesh)
      UB(1:1) = ubound(SrcOutputData%SStCLoadMesh)
      if (.not. allocated(DstOutputData%SStCLoadMesh)) then
         allocate(DstOutputData%SStCLoadMesh(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%SStCLoadMesh.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcOutputData%SStCLoadMesh(i1), DstOutputData%SStCLoadMesh(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
end subroutine

subroutine SrvD_DestroyOutput(OutputData, ErrStat, ErrMsg)
   type(SrvD_OutputType), intent(inout) :: OutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SrvD_DestroyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(OutputData%WriteOutput)) then
      deallocate(OutputData%WriteOutput)
   end if
   if (allocated(OutputData%BlPitchCom)) then
      deallocate(OutputData%BlPitchCom)
   end if
   if (allocated(OutputData%BlAirfoilCom)) then
      deallocate(OutputData%BlAirfoilCom)
   end if
   if (allocated(OutputData%TBDrCon)) then
      deallocate(OutputData%TBDrCon)
   end if
   if (allocated(OutputData%CableDeltaL)) then
      deallocate(OutputData%CableDeltaL)
   end if
   if (allocated(OutputData%CableDeltaLdot)) then
      deallocate(OutputData%CableDeltaLdot)
   end if
   if (allocated(OutputData%BStCLoadMesh)) then
      LB(1:2) = lbound(OutputData%BStCLoadMesh)
      UB(1:2) = ubound(OutputData%BStCLoadMesh)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call MeshDestroy( OutputData%BStCLoadMesh(i1,i2), ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         end do
      end do
      deallocate(OutputData%BStCLoadMesh)
   end if
   if (allocated(OutputData%NStCLoadMesh)) then
      LB(1:1) = lbound(OutputData%NStCLoadMesh)
      UB(1:1) = ubound(OutputData%NStCLoadMesh)
      do i1 = LB(1), UB(1)
         call MeshDestroy( OutputData%NStCLoadMesh(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(OutputData%NStCLoadMesh)
   end if
   if (allocated(OutputData%TStCLoadMesh)) then
      LB(1:1) = lbound(OutputData%TStCLoadMesh)
      UB(1:1) = ubound(OutputData%TStCLoadMesh)
      do i1 = LB(1), UB(1)
         call MeshDestroy( OutputData%TStCLoadMesh(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(OutputData%TStCLoadMesh)
   end if
   if (allocated(OutputData%SStCLoadMesh)) then
      LB(1:1) = lbound(OutputData%SStCLoadMesh)
      UB(1:1) = ubound(OutputData%SStCLoadMesh)
      do i1 = LB(1), UB(1)
         call MeshDestroy( OutputData%SStCLoadMesh(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(OutputData%SStCLoadMesh)
   end if
end subroutine

subroutine SrvD_PackOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SrvD_OutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SrvD_PackOutput'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%WriteOutput)
   call RegPackAlloc(RF, InData%BlPitchCom)
   call RegPackAlloc(RF, InData%BlAirfoilCom)
   call RegPack(RF, InData%YawMom)
   call RegPack(RF, InData%YawPosCom)
   call RegPack(RF, InData%YawRateCom)
   call RegPack(RF, InData%GenTrq)
   call RegPack(RF, InData%HSSBrTrqC)
   call RegPack(RF, InData%ElecPwr)
   call RegPackAlloc(RF, InData%TBDrCon)
   call RegPackAlloc(RF, InData%CableDeltaL)
   call RegPackAlloc(RF, InData%CableDeltaLdot)
   call RegPack(RF, allocated(InData%BStCLoadMesh))
   if (allocated(InData%BStCLoadMesh)) then
      call RegPackBounds(RF, 2, lbound(InData%BStCLoadMesh), ubound(InData%BStCLoadMesh))
      LB(1:2) = lbound(InData%BStCLoadMesh)
      UB(1:2) = ubound(InData%BStCLoadMesh)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call MeshPack(RF, InData%BStCLoadMesh(i1,i2)) 
         end do
      end do
   end if
   call RegPack(RF, allocated(InData%NStCLoadMesh))
   if (allocated(InData%NStCLoadMesh)) then
      call RegPackBounds(RF, 1, lbound(InData%NStCLoadMesh), ubound(InData%NStCLoadMesh))
      LB(1:1) = lbound(InData%NStCLoadMesh)
      UB(1:1) = ubound(InData%NStCLoadMesh)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%NStCLoadMesh(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%TStCLoadMesh))
   if (allocated(InData%TStCLoadMesh)) then
      call RegPackBounds(RF, 1, lbound(InData%TStCLoadMesh), ubound(InData%TStCLoadMesh))
      LB(1:1) = lbound(InData%TStCLoadMesh)
      UB(1:1) = ubound(InData%TStCLoadMesh)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%TStCLoadMesh(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%SStCLoadMesh))
   if (allocated(InData%SStCLoadMesh)) then
      call RegPackBounds(RF, 1, lbound(InData%SStCLoadMesh), ubound(InData%SStCLoadMesh))
      LB(1:1) = lbound(InData%SStCLoadMesh)
      UB(1:1) = ubound(InData%SStCLoadMesh)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%SStCLoadMesh(i1)) 
      end do
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SrvD_UnPackOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SrvD_OutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SrvD_UnPackOutput'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%WriteOutput); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BlPitchCom); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BlAirfoilCom); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawMom); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawPosCom); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawRateCom); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GenTrq); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HSSBrTrqC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ElecPwr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TBDrCon); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%CableDeltaL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%CableDeltaLdot); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%BStCLoadMesh)) deallocate(OutData%BStCLoadMesh)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 2, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BStCLoadMesh(LB(1):UB(1),LB(2):UB(2)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BStCLoadMesh.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call MeshUnpack(RF, OutData%BStCLoadMesh(i1,i2)) ! BStCLoadMesh 
         end do
      end do
   end if
   if (allocated(OutData%NStCLoadMesh)) deallocate(OutData%NStCLoadMesh)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%NStCLoadMesh(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%NStCLoadMesh.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%NStCLoadMesh(i1)) ! NStCLoadMesh 
      end do
   end if
   if (allocated(OutData%TStCLoadMesh)) deallocate(OutData%TStCLoadMesh)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%TStCLoadMesh(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%TStCLoadMesh.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%TStCLoadMesh(i1)) ! TStCLoadMesh 
      end do
   end if
   if (allocated(OutData%SStCLoadMesh)) deallocate(OutData%SStCLoadMesh)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%SStCLoadMesh(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%SStCLoadMesh.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%SStCLoadMesh(i1)) ! SStCLoadMesh 
      end do
   end if
end subroutine

subroutine SrvD_Input_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
   ! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(SrvD_InputType), intent(inout)  :: u(:) ! Input at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Inputs
   type(SrvD_InputType), intent(inout)  :: u_out ! Input at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'SrvD_Input_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(u)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(u)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(u) - 1
   select case (order)
   case (0)
      call SrvD_CopyInput(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call SrvD_Input_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call SrvD_Input_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(u) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE SrvD_Input_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

   TYPE(SrvD_InputType), INTENT(INOUT)  :: u1    ! Input at t1 > t2
   TYPE(SrvD_InputType), INTENT(INOUT)  :: u2    ! Input at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Inputs
   TYPE(SrvD_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'SrvD_Input_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i02      ! dim2 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   INTEGER                                    :: i2       ! dim2 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   IF (ALLOCATED(u_out%BlPitch) .AND. ALLOCATED(u1%BlPitch)) THEN
      do i1 = lbound(u_out%BlPitch,1),ubound(u_out%BlPitch,1)
         CALL Angles_ExtrapInterp( u1%BlPitch(i1), u2%BlPitch(i1), tin, u_out%BlPitch(i1), tin_out )
      END DO
   END IF ! check if allocated
   CALL Angles_ExtrapInterp( u1%Yaw, u2%Yaw, tin, u_out%Yaw, tin_out )
   u_out%YawRate = a1*u1%YawRate + a2*u2%YawRate
   u_out%LSS_Spd = a1*u1%LSS_Spd + a2*u2%LSS_Spd
   u_out%HSS_Spd = a1*u1%HSS_Spd + a2*u2%HSS_Spd
   u_out%RotSpeed = a1*u1%RotSpeed + a2*u2%RotSpeed
   CALL Angles_ExtrapInterp( u1%ExternalYawPosCom, u2%ExternalYawPosCom, tin, u_out%ExternalYawPosCom, tin_out )
   u_out%ExternalYawRateCom = a1*u1%ExternalYawRateCom + a2*u2%ExternalYawRateCom
   IF (ALLOCATED(u_out%ExternalBlPitchCom) .AND. ALLOCATED(u1%ExternalBlPitchCom)) THEN
      do i1 = lbound(u_out%ExternalBlPitchCom,1),ubound(u_out%ExternalBlPitchCom,1)
         CALL Angles_ExtrapInterp( u1%ExternalBlPitchCom(i1), u2%ExternalBlPitchCom(i1), tin, u_out%ExternalBlPitchCom(i1), tin_out )
      END DO
   END IF ! check if allocated
   u_out%ExternalGenTrq = a1*u1%ExternalGenTrq + a2*u2%ExternalGenTrq
   u_out%ExternalElecPwr = a1*u1%ExternalElecPwr + a2*u2%ExternalElecPwr
   u_out%ExternalHSSBrFrac = a1*u1%ExternalHSSBrFrac + a2*u2%ExternalHSSBrFrac
   IF (ALLOCATED(u_out%ExternalBlAirfoilCom) .AND. ALLOCATED(u1%ExternalBlAirfoilCom)) THEN
      u_out%ExternalBlAirfoilCom = a1*u1%ExternalBlAirfoilCom + a2*u2%ExternalBlAirfoilCom
   END IF ! check if allocated
   IF (ALLOCATED(u_out%ExternalCableDeltaL) .AND. ALLOCATED(u1%ExternalCableDeltaL)) THEN
      u_out%ExternalCableDeltaL = a1*u1%ExternalCableDeltaL + a2*u2%ExternalCableDeltaL
   END IF ! check if allocated
   IF (ALLOCATED(u_out%ExternalCableDeltaLdot) .AND. ALLOCATED(u1%ExternalCableDeltaLdot)) THEN
      u_out%ExternalCableDeltaLdot = a1*u1%ExternalCableDeltaLdot + a2*u2%ExternalCableDeltaLdot
   END IF ! check if allocated
   u_out%TwrAccel = a1*u1%TwrAccel + a2*u2%TwrAccel
   CALL Angles_ExtrapInterp( u1%YawErr, u2%YawErr, tin, u_out%YawErr, tin_out )
   CALL Angles_ExtrapInterp( u1%WindDir, u2%WindDir, tin, u_out%WindDir, tin_out )
   u_out%RootMyc = a1*u1%RootMyc + a2*u2%RootMyc
   u_out%YawBrTAxp = a1*u1%YawBrTAxp + a2*u2%YawBrTAxp
   u_out%YawBrTAyp = a1*u1%YawBrTAyp + a2*u2%YawBrTAyp
   u_out%LSSTipPxa = a1*u1%LSSTipPxa + a2*u2%LSSTipPxa
   u_out%RootMxc = a1*u1%RootMxc + a2*u2%RootMxc
   u_out%LSSTipMxa = a1*u1%LSSTipMxa + a2*u2%LSSTipMxa
   u_out%LSSTipMya = a1*u1%LSSTipMya + a2*u2%LSSTipMya
   u_out%LSSTipMza = a1*u1%LSSTipMza + a2*u2%LSSTipMza
   u_out%LSSTipMys = a1*u1%LSSTipMys + a2*u2%LSSTipMys
   u_out%LSSTipMzs = a1*u1%LSSTipMzs + a2*u2%LSSTipMzs
   u_out%YawBrMyn = a1*u1%YawBrMyn + a2*u2%YawBrMyn
   u_out%YawBrMzn = a1*u1%YawBrMzn + a2*u2%YawBrMzn
   u_out%NcIMURAxs = a1*u1%NcIMURAxs + a2*u2%NcIMURAxs
   u_out%NcIMURAys = a1*u1%NcIMURAys + a2*u2%NcIMURAys
   u_out%NcIMURAzs = a1*u1%NcIMURAzs + a2*u2%NcIMURAzs
   u_out%RotPwr = a1*u1%RotPwr + a2*u2%RotPwr
   u_out%HorWindV = a1*u1%HorWindV + a2*u2%HorWindV
   CALL Angles_ExtrapInterp( u1%YawAngle, u2%YawAngle, tin, u_out%YawAngle, tin_out )
   u_out%LSShftFxa = a1*u1%LSShftFxa + a2*u2%LSShftFxa
   u_out%LSShftFys = a1*u1%LSShftFys + a2*u2%LSShftFys
   u_out%LSShftFzs = a1*u1%LSShftFzs + a2*u2%LSShftFzs
   CALL MeshExtrapInterp1(u1%PtfmMotionMesh, u2%PtfmMotionMesh, tin, u_out%PtfmMotionMesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   IF (ALLOCATED(u_out%BStCMotionMesh) .AND. ALLOCATED(u1%BStCMotionMesh)) THEN
      do i2 = lbound(u_out%BStCMotionMesh,2),ubound(u_out%BStCMotionMesh,2)
         do i1 = lbound(u_out%BStCMotionMesh,1),ubound(u_out%BStCMotionMesh,1)
            CALL MeshExtrapInterp1(u1%BStCMotionMesh(i1,i2), u2%BStCMotionMesh(i1,i2), tin, u_out%BStCMotionMesh(i1,i2), tin_out, ErrStat2, ErrMsg2)
               CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         END DO
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(u_out%NStCMotionMesh) .AND. ALLOCATED(u1%NStCMotionMesh)) THEN
      do i1 = lbound(u_out%NStCMotionMesh,1),ubound(u_out%NStCMotionMesh,1)
         CALL MeshExtrapInterp1(u1%NStCMotionMesh(i1), u2%NStCMotionMesh(i1), tin, u_out%NStCMotionMesh(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(u_out%TStCMotionMesh) .AND. ALLOCATED(u1%TStCMotionMesh)) THEN
      do i1 = lbound(u_out%TStCMotionMesh,1),ubound(u_out%TStCMotionMesh,1)
         CALL MeshExtrapInterp1(u1%TStCMotionMesh(i1), u2%TStCMotionMesh(i1), tin, u_out%TStCMotionMesh(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(u_out%SStCMotionMesh) .AND. ALLOCATED(u1%SStCMotionMesh)) THEN
      do i1 = lbound(u_out%SStCMotionMesh,1),ubound(u_out%SStCMotionMesh,1)
         CALL MeshExtrapInterp1(u1%SStCMotionMesh(i1), u2%SStCMotionMesh(i1), tin, u_out%SStCMotionMesh(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(u_out%LidSpeed) .AND. ALLOCATED(u1%LidSpeed)) THEN
      u_out%LidSpeed = a1*u1%LidSpeed + a2*u2%LidSpeed
   END IF ! check if allocated
   IF (ALLOCATED(u_out%MsrPositionsX) .AND. ALLOCATED(u1%MsrPositionsX)) THEN
      u_out%MsrPositionsX = a1*u1%MsrPositionsX + a2*u2%MsrPositionsX
   END IF ! check if allocated
   IF (ALLOCATED(u_out%MsrPositionsY) .AND. ALLOCATED(u1%MsrPositionsY)) THEN
      u_out%MsrPositionsY = a1*u1%MsrPositionsY + a2*u2%MsrPositionsY
   END IF ! check if allocated
   IF (ALLOCATED(u_out%MsrPositionsZ) .AND. ALLOCATED(u1%MsrPositionsZ)) THEN
      u_out%MsrPositionsZ = a1*u1%MsrPositionsZ + a2*u2%MsrPositionsZ
   END IF ! check if allocated
END SUBROUTINE

SUBROUTINE SrvD_Input_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

   TYPE(SrvD_InputType), INTENT(INOUT)  :: u1      ! Input at t1 > t2 > t3
   TYPE(SrvD_InputType), INTENT(INOUT)  :: u2      ! Input at t2 > t3
   TYPE(SrvD_InputType), INTENT(INOUT)  :: u3      ! Input at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Inputs
   TYPE(SrvD_InputType), INTENT(INOUT)  :: u_out     ! Input at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'SrvD_Input_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i02    ! dim2 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   INTEGER                                    :: i2    ! dim2 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   IF (ALLOCATED(u_out%BlPitch) .AND. ALLOCATED(u1%BlPitch)) THEN
      do i1 = lbound(u_out%BlPitch,1),ubound(u_out%BlPitch,1)
         CALL Angles_ExtrapInterp( u1%BlPitch(i1), u2%BlPitch(i1), u3%BlPitch(i1), tin, u_out%BlPitch(i1), tin_out )
      END DO
   END IF ! check if allocated
   CALL Angles_ExtrapInterp( u1%Yaw, u2%Yaw, u3%Yaw, tin, u_out%Yaw, tin_out )
   u_out%YawRate = a1*u1%YawRate + a2*u2%YawRate + a3*u3%YawRate
   u_out%LSS_Spd = a1*u1%LSS_Spd + a2*u2%LSS_Spd + a3*u3%LSS_Spd
   u_out%HSS_Spd = a1*u1%HSS_Spd + a2*u2%HSS_Spd + a3*u3%HSS_Spd
   u_out%RotSpeed = a1*u1%RotSpeed + a2*u2%RotSpeed + a3*u3%RotSpeed
   CALL Angles_ExtrapInterp( u1%ExternalYawPosCom, u2%ExternalYawPosCom, u3%ExternalYawPosCom, tin, u_out%ExternalYawPosCom, tin_out )
   u_out%ExternalYawRateCom = a1*u1%ExternalYawRateCom + a2*u2%ExternalYawRateCom + a3*u3%ExternalYawRateCom
   IF (ALLOCATED(u_out%ExternalBlPitchCom) .AND. ALLOCATED(u1%ExternalBlPitchCom)) THEN
      do i1 = lbound(u_out%ExternalBlPitchCom,1),ubound(u_out%ExternalBlPitchCom,1)
         CALL Angles_ExtrapInterp( u1%ExternalBlPitchCom(i1), u2%ExternalBlPitchCom(i1), u3%ExternalBlPitchCom(i1), tin, u_out%ExternalBlPitchCom(i1), tin_out )
      END DO
   END IF ! check if allocated
   u_out%ExternalGenTrq = a1*u1%ExternalGenTrq + a2*u2%ExternalGenTrq + a3*u3%ExternalGenTrq
   u_out%ExternalElecPwr = a1*u1%ExternalElecPwr + a2*u2%ExternalElecPwr + a3*u3%ExternalElecPwr
   u_out%ExternalHSSBrFrac = a1*u1%ExternalHSSBrFrac + a2*u2%ExternalHSSBrFrac + a3*u3%ExternalHSSBrFrac
   IF (ALLOCATED(u_out%ExternalBlAirfoilCom) .AND. ALLOCATED(u1%ExternalBlAirfoilCom)) THEN
      u_out%ExternalBlAirfoilCom = a1*u1%ExternalBlAirfoilCom + a2*u2%ExternalBlAirfoilCom + a3*u3%ExternalBlAirfoilCom
   END IF ! check if allocated
   IF (ALLOCATED(u_out%ExternalCableDeltaL) .AND. ALLOCATED(u1%ExternalCableDeltaL)) THEN
      u_out%ExternalCableDeltaL = a1*u1%ExternalCableDeltaL + a2*u2%ExternalCableDeltaL + a3*u3%ExternalCableDeltaL
   END IF ! check if allocated
   IF (ALLOCATED(u_out%ExternalCableDeltaLdot) .AND. ALLOCATED(u1%ExternalCableDeltaLdot)) THEN
      u_out%ExternalCableDeltaLdot = a1*u1%ExternalCableDeltaLdot + a2*u2%ExternalCableDeltaLdot + a3*u3%ExternalCableDeltaLdot
   END IF ! check if allocated
   u_out%TwrAccel = a1*u1%TwrAccel + a2*u2%TwrAccel + a3*u3%TwrAccel
   CALL Angles_ExtrapInterp( u1%YawErr, u2%YawErr, u3%YawErr, tin, u_out%YawErr, tin_out )
   CALL Angles_ExtrapInterp( u1%WindDir, u2%WindDir, u3%WindDir, tin, u_out%WindDir, tin_out )
   u_out%RootMyc = a1*u1%RootMyc + a2*u2%RootMyc + a3*u3%RootMyc
   u_out%YawBrTAxp = a1*u1%YawBrTAxp + a2*u2%YawBrTAxp + a3*u3%YawBrTAxp
   u_out%YawBrTAyp = a1*u1%YawBrTAyp + a2*u2%YawBrTAyp + a3*u3%YawBrTAyp
   u_out%LSSTipPxa = a1*u1%LSSTipPxa + a2*u2%LSSTipPxa + a3*u3%LSSTipPxa
   u_out%RootMxc = a1*u1%RootMxc + a2*u2%RootMxc + a3*u3%RootMxc
   u_out%LSSTipMxa = a1*u1%LSSTipMxa + a2*u2%LSSTipMxa + a3*u3%LSSTipMxa
   u_out%LSSTipMya = a1*u1%LSSTipMya + a2*u2%LSSTipMya + a3*u3%LSSTipMya
   u_out%LSSTipMza = a1*u1%LSSTipMza + a2*u2%LSSTipMza + a3*u3%LSSTipMza
   u_out%LSSTipMys = a1*u1%LSSTipMys + a2*u2%LSSTipMys + a3*u3%LSSTipMys
   u_out%LSSTipMzs = a1*u1%LSSTipMzs + a2*u2%LSSTipMzs + a3*u3%LSSTipMzs
   u_out%YawBrMyn = a1*u1%YawBrMyn + a2*u2%YawBrMyn + a3*u3%YawBrMyn
   u_out%YawBrMzn = a1*u1%YawBrMzn + a2*u2%YawBrMzn + a3*u3%YawBrMzn
   u_out%NcIMURAxs = a1*u1%NcIMURAxs + a2*u2%NcIMURAxs + a3*u3%NcIMURAxs
   u_out%NcIMURAys = a1*u1%NcIMURAys + a2*u2%NcIMURAys + a3*u3%NcIMURAys
   u_out%NcIMURAzs = a1*u1%NcIMURAzs + a2*u2%NcIMURAzs + a3*u3%NcIMURAzs
   u_out%RotPwr = a1*u1%RotPwr + a2*u2%RotPwr + a3*u3%RotPwr
   u_out%HorWindV = a1*u1%HorWindV + a2*u2%HorWindV + a3*u3%HorWindV
   CALL Angles_ExtrapInterp( u1%YawAngle, u2%YawAngle, u3%YawAngle, tin, u_out%YawAngle, tin_out )
   u_out%LSShftFxa = a1*u1%LSShftFxa + a2*u2%LSShftFxa + a3*u3%LSShftFxa
   u_out%LSShftFys = a1*u1%LSShftFys + a2*u2%LSShftFys + a3*u3%LSShftFys
   u_out%LSShftFzs = a1*u1%LSShftFzs + a2*u2%LSShftFzs + a3*u3%LSShftFzs
   CALL MeshExtrapInterp2(u1%PtfmMotionMesh, u2%PtfmMotionMesh, u3%PtfmMotionMesh, tin, u_out%PtfmMotionMesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   IF (ALLOCATED(u_out%BStCMotionMesh) .AND. ALLOCATED(u1%BStCMotionMesh)) THEN
      do i2 = lbound(u_out%BStCMotionMesh,2),ubound(u_out%BStCMotionMesh,2)
         do i1 = lbound(u_out%BStCMotionMesh,1),ubound(u_out%BStCMotionMesh,1)
            CALL MeshExtrapInterp2(u1%BStCMotionMesh(i1,i2), u2%BStCMotionMesh(i1,i2), u3%BStCMotionMesh(i1,i2), tin, u_out%BStCMotionMesh(i1,i2), tin_out, ErrStat2, ErrMsg2)
               CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         END DO
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(u_out%NStCMotionMesh) .AND. ALLOCATED(u1%NStCMotionMesh)) THEN
      do i1 = lbound(u_out%NStCMotionMesh,1),ubound(u_out%NStCMotionMesh,1)
         CALL MeshExtrapInterp2(u1%NStCMotionMesh(i1), u2%NStCMotionMesh(i1), u3%NStCMotionMesh(i1), tin, u_out%NStCMotionMesh(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(u_out%TStCMotionMesh) .AND. ALLOCATED(u1%TStCMotionMesh)) THEN
      do i1 = lbound(u_out%TStCMotionMesh,1),ubound(u_out%TStCMotionMesh,1)
         CALL MeshExtrapInterp2(u1%TStCMotionMesh(i1), u2%TStCMotionMesh(i1), u3%TStCMotionMesh(i1), tin, u_out%TStCMotionMesh(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(u_out%SStCMotionMesh) .AND. ALLOCATED(u1%SStCMotionMesh)) THEN
      do i1 = lbound(u_out%SStCMotionMesh,1),ubound(u_out%SStCMotionMesh,1)
         CALL MeshExtrapInterp2(u1%SStCMotionMesh(i1), u2%SStCMotionMesh(i1), u3%SStCMotionMesh(i1), tin, u_out%SStCMotionMesh(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(u_out%LidSpeed) .AND. ALLOCATED(u1%LidSpeed)) THEN
      u_out%LidSpeed = a1*u1%LidSpeed + a2*u2%LidSpeed + a3*u3%LidSpeed
   END IF ! check if allocated
   IF (ALLOCATED(u_out%MsrPositionsX) .AND. ALLOCATED(u1%MsrPositionsX)) THEN
      u_out%MsrPositionsX = a1*u1%MsrPositionsX + a2*u2%MsrPositionsX + a3*u3%MsrPositionsX
   END IF ! check if allocated
   IF (ALLOCATED(u_out%MsrPositionsY) .AND. ALLOCATED(u1%MsrPositionsY)) THEN
      u_out%MsrPositionsY = a1*u1%MsrPositionsY + a2*u2%MsrPositionsY + a3*u3%MsrPositionsY
   END IF ! check if allocated
   IF (ALLOCATED(u_out%MsrPositionsZ) .AND. ALLOCATED(u1%MsrPositionsZ)) THEN
      u_out%MsrPositionsZ = a1*u1%MsrPositionsZ + a2*u2%MsrPositionsZ + a3*u3%MsrPositionsZ
   END IF ! check if allocated
END SUBROUTINE

subroutine SrvD_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
   ! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(SrvD_OutputType), intent(inout)  :: y(:) ! Output at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Outputs
   type(SrvD_OutputType), intent(inout)  :: y_out ! Output at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'SrvD_Output_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(y)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(y)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(y) - 1
   select case (order)
   case (0)
      call SrvD_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call SrvD_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call SrvD_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(y) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE SrvD_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

   TYPE(SrvD_OutputType), INTENT(INOUT)  :: y1    ! Output at t1 > t2
   TYPE(SrvD_OutputType), INTENT(INOUT)  :: y2    ! Output at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
   TYPE(SrvD_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'SrvD_Output_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i02      ! dim2 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   INTEGER                                    :: i2       ! dim2 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
      y_out%WriteOutput = a1*y1%WriteOutput + a2*y2%WriteOutput
   END IF ! check if allocated
   IF (ALLOCATED(y_out%BlPitchCom) .AND. ALLOCATED(y1%BlPitchCom)) THEN
      do i1 = lbound(y_out%BlPitchCom,1),ubound(y_out%BlPitchCom,1)
         CALL Angles_ExtrapInterp( y1%BlPitchCom(i1), y2%BlPitchCom(i1), tin, y_out%BlPitchCom(i1), tin_out )
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(y_out%BlAirfoilCom) .AND. ALLOCATED(y1%BlAirfoilCom)) THEN
      y_out%BlAirfoilCom = a1*y1%BlAirfoilCom + a2*y2%BlAirfoilCom
   END IF ! check if allocated
   y_out%YawMom = a1*y1%YawMom + a2*y2%YawMom
   y_out%YawPosCom = a1*y1%YawPosCom + a2*y2%YawPosCom
   y_out%YawRateCom = a1*y1%YawRateCom + a2*y2%YawRateCom
   y_out%GenTrq = a1*y1%GenTrq + a2*y2%GenTrq
   y_out%HSSBrTrqC = a1*y1%HSSBrTrqC + a2*y2%HSSBrTrqC
   y_out%ElecPwr = a1*y1%ElecPwr + a2*y2%ElecPwr
   IF (ALLOCATED(y_out%TBDrCon) .AND. ALLOCATED(y1%TBDrCon)) THEN
      y_out%TBDrCon = a1*y1%TBDrCon + a2*y2%TBDrCon
   END IF ! check if allocated
   IF (ALLOCATED(y_out%CableDeltaL) .AND. ALLOCATED(y1%CableDeltaL)) THEN
      y_out%CableDeltaL = a1*y1%CableDeltaL + a2*y2%CableDeltaL
   END IF ! check if allocated
   IF (ALLOCATED(y_out%CableDeltaLdot) .AND. ALLOCATED(y1%CableDeltaLdot)) THEN
      y_out%CableDeltaLdot = a1*y1%CableDeltaLdot + a2*y2%CableDeltaLdot
   END IF ! check if allocated
   IF (ALLOCATED(y_out%BStCLoadMesh) .AND. ALLOCATED(y1%BStCLoadMesh)) THEN
      do i2 = lbound(y_out%BStCLoadMesh,2),ubound(y_out%BStCLoadMesh,2)
         do i1 = lbound(y_out%BStCLoadMesh,1),ubound(y_out%BStCLoadMesh,1)
            CALL MeshExtrapInterp1(y1%BStCLoadMesh(i1,i2), y2%BStCLoadMesh(i1,i2), tin, y_out%BStCLoadMesh(i1,i2), tin_out, ErrStat2, ErrMsg2)
               CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         END DO
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(y_out%NStCLoadMesh) .AND. ALLOCATED(y1%NStCLoadMesh)) THEN
      do i1 = lbound(y_out%NStCLoadMesh,1),ubound(y_out%NStCLoadMesh,1)
         CALL MeshExtrapInterp1(y1%NStCLoadMesh(i1), y2%NStCLoadMesh(i1), tin, y_out%NStCLoadMesh(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(y_out%TStCLoadMesh) .AND. ALLOCATED(y1%TStCLoadMesh)) THEN
      do i1 = lbound(y_out%TStCLoadMesh,1),ubound(y_out%TStCLoadMesh,1)
         CALL MeshExtrapInterp1(y1%TStCLoadMesh(i1), y2%TStCLoadMesh(i1), tin, y_out%TStCLoadMesh(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(y_out%SStCLoadMesh) .AND. ALLOCATED(y1%SStCLoadMesh)) THEN
      do i1 = lbound(y_out%SStCLoadMesh,1),ubound(y_out%SStCLoadMesh,1)
         CALL MeshExtrapInterp1(y1%SStCLoadMesh(i1), y2%SStCLoadMesh(i1), tin, y_out%SStCLoadMesh(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
END SUBROUTINE

SUBROUTINE SrvD_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

   TYPE(SrvD_OutputType), INTENT(INOUT)  :: y1      ! Output at t1 > t2 > t3
   TYPE(SrvD_OutputType), INTENT(INOUT)  :: y2      ! Output at t2 > t3
   TYPE(SrvD_OutputType), INTENT(INOUT)  :: y3      ! Output at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
   TYPE(SrvD_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'SrvD_Output_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i02    ! dim2 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   INTEGER                                    :: i2    ! dim2 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
      y_out%WriteOutput = a1*y1%WriteOutput + a2*y2%WriteOutput + a3*y3%WriteOutput
   END IF ! check if allocated
   IF (ALLOCATED(y_out%BlPitchCom) .AND. ALLOCATED(y1%BlPitchCom)) THEN
      do i1 = lbound(y_out%BlPitchCom,1),ubound(y_out%BlPitchCom,1)
         CALL Angles_ExtrapInterp( y1%BlPitchCom(i1), y2%BlPitchCom(i1), y3%BlPitchCom(i1), tin, y_out%BlPitchCom(i1), tin_out )
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(y_out%BlAirfoilCom) .AND. ALLOCATED(y1%BlAirfoilCom)) THEN
      y_out%BlAirfoilCom = a1*y1%BlAirfoilCom + a2*y2%BlAirfoilCom + a3*y3%BlAirfoilCom
   END IF ! check if allocated
   y_out%YawMom = a1*y1%YawMom + a2*y2%YawMom + a3*y3%YawMom
   y_out%YawPosCom = a1*y1%YawPosCom + a2*y2%YawPosCom + a3*y3%YawPosCom
   y_out%YawRateCom = a1*y1%YawRateCom + a2*y2%YawRateCom + a3*y3%YawRateCom
   y_out%GenTrq = a1*y1%GenTrq + a2*y2%GenTrq + a3*y3%GenTrq
   y_out%HSSBrTrqC = a1*y1%HSSBrTrqC + a2*y2%HSSBrTrqC + a3*y3%HSSBrTrqC
   y_out%ElecPwr = a1*y1%ElecPwr + a2*y2%ElecPwr + a3*y3%ElecPwr
   IF (ALLOCATED(y_out%TBDrCon) .AND. ALLOCATED(y1%TBDrCon)) THEN
      y_out%TBDrCon = a1*y1%TBDrCon + a2*y2%TBDrCon + a3*y3%TBDrCon
   END IF ! check if allocated
   IF (ALLOCATED(y_out%CableDeltaL) .AND. ALLOCATED(y1%CableDeltaL)) THEN
      y_out%CableDeltaL = a1*y1%CableDeltaL + a2*y2%CableDeltaL + a3*y3%CableDeltaL
   END IF ! check if allocated
   IF (ALLOCATED(y_out%CableDeltaLdot) .AND. ALLOCATED(y1%CableDeltaLdot)) THEN
      y_out%CableDeltaLdot = a1*y1%CableDeltaLdot + a2*y2%CableDeltaLdot + a3*y3%CableDeltaLdot
   END IF ! check if allocated
   IF (ALLOCATED(y_out%BStCLoadMesh) .AND. ALLOCATED(y1%BStCLoadMesh)) THEN
      do i2 = lbound(y_out%BStCLoadMesh,2),ubound(y_out%BStCLoadMesh,2)
         do i1 = lbound(y_out%BStCLoadMesh,1),ubound(y_out%BStCLoadMesh,1)
            CALL MeshExtrapInterp2(y1%BStCLoadMesh(i1,i2), y2%BStCLoadMesh(i1,i2), y3%BStCLoadMesh(i1,i2), tin, y_out%BStCLoadMesh(i1,i2), tin_out, ErrStat2, ErrMsg2)
               CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         END DO
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(y_out%NStCLoadMesh) .AND. ALLOCATED(y1%NStCLoadMesh)) THEN
      do i1 = lbound(y_out%NStCLoadMesh,1),ubound(y_out%NStCLoadMesh,1)
         CALL MeshExtrapInterp2(y1%NStCLoadMesh(i1), y2%NStCLoadMesh(i1), y3%NStCLoadMesh(i1), tin, y_out%NStCLoadMesh(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(y_out%TStCLoadMesh) .AND. ALLOCATED(y1%TStCLoadMesh)) THEN
      do i1 = lbound(y_out%TStCLoadMesh,1),ubound(y_out%TStCLoadMesh,1)
         CALL MeshExtrapInterp2(y1%TStCLoadMesh(i1), y2%TStCLoadMesh(i1), y3%TStCLoadMesh(i1), tin, y_out%TStCLoadMesh(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(y_out%SStCLoadMesh) .AND. ALLOCATED(y1%SStCLoadMesh)) THEN
      do i1 = lbound(y_out%SStCLoadMesh,1),ubound(y_out%SStCLoadMesh,1)
         CALL MeshExtrapInterp2(y1%SStCLoadMesh(i1), y2%SStCLoadMesh(i1), y3%SStCLoadMesh(i1), tin, y_out%SStCLoadMesh(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
END SUBROUTINE
END MODULE ServoDyn_Types
!ENDOFREGISTRYGENERATEDFILE
