!**********************************************************************************************************************************
! LICENSING
! Copyright (C) 2013-2016  National Renewable Energy Laboratory
!
!    This file is part of FAST's Controls and Electrical Drive Module, "ServoDyn".
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!**********************************************************************************************************************************
!> Control and electrical drive dynamics module for FAST   
MODULE ServoDyn_IO

   USE ServoDyn_Types
   USE NWTC_Library
   USE StrucCtrl_Types
   

   IMPLICIT NONE



   character(*),parameter        :: SectionDivide = '____________________________________________________________________________________________________'

! ===================================================================================================
! NOTE: The following lines of code were generated by a Matlab script called "Write_ChckOutLst.m"
!      using the parameters listed in the "OutListParameters.xlsx" Excel file. Any changes to these
!      lines should be modified in the Matlab script and/or Excel worksheet as necessary.
! ===================================================================================================
! This code was generated by Write_ChckOutLst.m at 04-Feb-2021 08:42:27.


     ! Indices for computing output channels:
     ! NOTES:
     !    (1) These parameters are in the order stored in "OutListParameters.xlsx"
     !    (2) Array AllOuts() must be dimensioned to the value of the largest output parameter

     !  Time:

   INTEGER(IntKi), PARAMETER      :: Time         =   0


     ! Airfoil control:

   INTEGER(IntKi), PARAMETER      :: BlAirFlC1    =   1
   INTEGER(IntKi), PARAMETER      :: BlAirFlC2    =   2
   INTEGER(IntKi), PARAMETER      :: BlAirFlC3    =   3


     ! Pitch Control:

   INTEGER(IntKi), PARAMETER      :: BlPitchC1    =   4
   INTEGER(IntKi), PARAMETER      :: BlPitchC2    =   5
   INTEGER(IntKi), PARAMETER      :: BlPitchC3    =   6


     ! Generator and Torque Control:

   INTEGER(IntKi), PARAMETER      :: GenTq        =   7
   INTEGER(IntKi), PARAMETER      :: GenPwr       =   8


     ! High Speed Shaft Brake:

   INTEGER(IntKi), PARAMETER      :: HSSBrTqC     =   9


     ! Nacelle Yaw Control:

   INTEGER(IntKi), PARAMETER      :: YawMomCom    =  10


     ! Nacelle Structural Control  (StC):

   INTEGER(IntKi), PARAMETER      :: NStC1_XQ     =  11
   INTEGER(IntKi), PARAMETER      :: NStC1_XQD    =  12
   INTEGER(IntKi), PARAMETER      :: NStC1_YQ     =  13
   INTEGER(IntKi), PARAMETER      :: NStC1_YQD    =  14
   INTEGER(IntKi), PARAMETER      :: NStC1_ZQ     =  15
   INTEGER(IntKi), PARAMETER      :: NStC1_ZQD    =  16
   INTEGER(IntKi), PARAMETER      :: NStC1_Fxi    =  17
   INTEGER(IntKi), PARAMETER      :: NStC1_Fyi    =  18
   INTEGER(IntKi), PARAMETER      :: NStC1_Fzi    =  19
   INTEGER(IntKi), PARAMETER      :: NStC1_Mxi    =  20
   INTEGER(IntKi), PARAMETER      :: NStC1_Myi    =  21
   INTEGER(IntKi), PARAMETER      :: NStC1_Mzi    =  22
   INTEGER(IntKi), PARAMETER      :: NStC1_Fxl    =  23
   INTEGER(IntKi), PARAMETER      :: NStC1_Fyl    =  24
   INTEGER(IntKi), PARAMETER      :: NStC1_Fzl    =  25
   INTEGER(IntKi), PARAMETER      :: NStC1_Mxl    =  26
   INTEGER(IntKi), PARAMETER      :: NStC1_Myl    =  27
   INTEGER(IntKi), PARAMETER      :: NStC1_Mzl    =  28
   INTEGER(IntKi), PARAMETER      :: NStC2_XQ     =  29
   INTEGER(IntKi), PARAMETER      :: NStC2_XQD    =  30
   INTEGER(IntKi), PARAMETER      :: NStC2_YQ     =  31
   INTEGER(IntKi), PARAMETER      :: NStC2_YQD    =  32
   INTEGER(IntKi), PARAMETER      :: NStC2_ZQ     =  33
   INTEGER(IntKi), PARAMETER      :: NStC2_ZQD    =  34
   INTEGER(IntKi), PARAMETER      :: NStC2_Fxi    =  35
   INTEGER(IntKi), PARAMETER      :: NStC2_Fyi    =  36
   INTEGER(IntKi), PARAMETER      :: NStC2_Fzi    =  37
   INTEGER(IntKi), PARAMETER      :: NStC2_Mxi    =  38
   INTEGER(IntKi), PARAMETER      :: NStC2_Myi    =  39
   INTEGER(IntKi), PARAMETER      :: NStC2_Mzi    =  40
   INTEGER(IntKi), PARAMETER      :: NStC2_Fxl    =  41
   INTEGER(IntKi), PARAMETER      :: NStC2_Fyl    =  42
   INTEGER(IntKi), PARAMETER      :: NStC2_Fzl    =  43
   INTEGER(IntKi), PARAMETER      :: NStC2_Mxl    =  44
   INTEGER(IntKi), PARAMETER      :: NStC2_Myl    =  45
   INTEGER(IntKi), PARAMETER      :: NStC2_Mzl    =  46
   INTEGER(IntKi), PARAMETER      :: NStC3_XQ     =  47
   INTEGER(IntKi), PARAMETER      :: NStC3_XQD    =  48
   INTEGER(IntKi), PARAMETER      :: NStC3_YQ     =  49
   INTEGER(IntKi), PARAMETER      :: NStC3_YQD    =  50
   INTEGER(IntKi), PARAMETER      :: NStC3_ZQ     =  51
   INTEGER(IntKi), PARAMETER      :: NStC3_ZQD    =  52
   INTEGER(IntKi), PARAMETER      :: NStC3_Fxi    =  53
   INTEGER(IntKi), PARAMETER      :: NStC3_Fyi    =  54
   INTEGER(IntKi), PARAMETER      :: NStC3_Fzi    =  55
   INTEGER(IntKi), PARAMETER      :: NStC3_Mxi    =  56
   INTEGER(IntKi), PARAMETER      :: NStC3_Myi    =  57
   INTEGER(IntKi), PARAMETER      :: NStC3_Mzi    =  58
   INTEGER(IntKi), PARAMETER      :: NStC3_Fxl    =  59
   INTEGER(IntKi), PARAMETER      :: NStC3_Fyl    =  60
   INTEGER(IntKi), PARAMETER      :: NStC3_Fzl    =  61
   INTEGER(IntKi), PARAMETER      :: NStC3_Mxl    =  62
   INTEGER(IntKi), PARAMETER      :: NStC3_Myl    =  63
   INTEGER(IntKi), PARAMETER      :: NStC3_Mzl    =  64
   INTEGER(IntKi), PARAMETER      :: NStC4_XQ     =  65
   INTEGER(IntKi), PARAMETER      :: NStC4_XQD    =  66
   INTEGER(IntKi), PARAMETER      :: NStC4_YQ     =  67
   INTEGER(IntKi), PARAMETER      :: NStC4_YQD    =  68
   INTEGER(IntKi), PARAMETER      :: NStC4_ZQ     =  69
   INTEGER(IntKi), PARAMETER      :: NStC4_ZQD    =  70
   INTEGER(IntKi), PARAMETER      :: NStC4_Fxi    =  71
   INTEGER(IntKi), PARAMETER      :: NStC4_Fyi    =  72
   INTEGER(IntKi), PARAMETER      :: NStC4_Fzi    =  73
   INTEGER(IntKi), PARAMETER      :: NStC4_Mxi    =  74
   INTEGER(IntKi), PARAMETER      :: NStC4_Myi    =  75
   INTEGER(IntKi), PARAMETER      :: NStC4_Mzi    =  76
   INTEGER(IntKi), PARAMETER      :: NStC4_Fxl    =  77
   INTEGER(IntKi), PARAMETER      :: NStC4_Fyl    =  78
   INTEGER(IntKi), PARAMETER      :: NStC4_Fzl    =  79
   INTEGER(IntKi), PARAMETER      :: NStC4_Mxl    =  80
   INTEGER(IntKi), PARAMETER      :: NStC4_Myl    =  81
   INTEGER(IntKi), PARAMETER      :: NStC4_Mzl    =  82


     ! Tower Structural Control  (StC):

   INTEGER(IntKi), PARAMETER      :: TStC1_XQ     =  83
   INTEGER(IntKi), PARAMETER      :: TStC1_XQD    =  84
   INTEGER(IntKi), PARAMETER      :: TStC1_YQ     =  85
   INTEGER(IntKi), PARAMETER      :: TStC1_YQD    =  86
   INTEGER(IntKi), PARAMETER      :: TStC1_ZQ     =  87
   INTEGER(IntKi), PARAMETER      :: TStC1_ZQD    =  88
   INTEGER(IntKi), PARAMETER      :: TStC1_Fxi    =  89
   INTEGER(IntKi), PARAMETER      :: TStC1_Fyi    =  90
   INTEGER(IntKi), PARAMETER      :: TStC1_Fzi    =  91
   INTEGER(IntKi), PARAMETER      :: TStC1_Mxi    =  92
   INTEGER(IntKi), PARAMETER      :: TStC1_Myi    =  93
   INTEGER(IntKi), PARAMETER      :: TStC1_Mzi    =  94
   INTEGER(IntKi), PARAMETER      :: TStC1_Fxl    =  95
   INTEGER(IntKi), PARAMETER      :: TStC1_Fyl    =  96
   INTEGER(IntKi), PARAMETER      :: TStC1_Fzl    =  97
   INTEGER(IntKi), PARAMETER      :: TStC1_Mxl    =  98
   INTEGER(IntKi), PARAMETER      :: TStC1_Myl    =  99
   INTEGER(IntKi), PARAMETER      :: TStC1_Mzl    = 100
   INTEGER(IntKi), PARAMETER      :: TStC2_XQ     = 101
   INTEGER(IntKi), PARAMETER      :: TStC2_XQD    = 102
   INTEGER(IntKi), PARAMETER      :: TStC2_YQ     = 103
   INTEGER(IntKi), PARAMETER      :: TStC2_YQD    = 104
   INTEGER(IntKi), PARAMETER      :: TStC2_ZQ     = 105
   INTEGER(IntKi), PARAMETER      :: TStC2_ZQD    = 106
   INTEGER(IntKi), PARAMETER      :: TStC2_Fxi    = 107
   INTEGER(IntKi), PARAMETER      :: TStC2_Fyi    = 108
   INTEGER(IntKi), PARAMETER      :: TStC2_Fzi    = 109
   INTEGER(IntKi), PARAMETER      :: TStC2_Mxi    = 110
   INTEGER(IntKi), PARAMETER      :: TStC2_Myi    = 111
   INTEGER(IntKi), PARAMETER      :: TStC2_Mzi    = 112
   INTEGER(IntKi), PARAMETER      :: TStC2_Fxl    = 113
   INTEGER(IntKi), PARAMETER      :: TStC2_Fyl    = 114
   INTEGER(IntKi), PARAMETER      :: TStC2_Fzl    = 115
   INTEGER(IntKi), PARAMETER      :: TStC2_Mxl    = 116
   INTEGER(IntKi), PARAMETER      :: TStC2_Myl    = 117
   INTEGER(IntKi), PARAMETER      :: TStC2_Mzl    = 118
   INTEGER(IntKi), PARAMETER      :: TStC3_XQ     = 119
   INTEGER(IntKi), PARAMETER      :: TStC3_XQD    = 120
   INTEGER(IntKi), PARAMETER      :: TStC3_YQ     = 121
   INTEGER(IntKi), PARAMETER      :: TStC3_YQD    = 122
   INTEGER(IntKi), PARAMETER      :: TStC3_ZQ     = 123
   INTEGER(IntKi), PARAMETER      :: TStC3_ZQD    = 124
   INTEGER(IntKi), PARAMETER      :: TStC3_Fxi    = 125
   INTEGER(IntKi), PARAMETER      :: TStC3_Fyi    = 126
   INTEGER(IntKi), PARAMETER      :: TStC3_Fzi    = 127
   INTEGER(IntKi), PARAMETER      :: TStC3_Mxi    = 128
   INTEGER(IntKi), PARAMETER      :: TStC3_Myi    = 129
   INTEGER(IntKi), PARAMETER      :: TStC3_Mzi    = 130
   INTEGER(IntKi), PARAMETER      :: TStC3_Fxl    = 131
   INTEGER(IntKi), PARAMETER      :: TStC3_Fyl    = 132
   INTEGER(IntKi), PARAMETER      :: TStC3_Fzl    = 133
   INTEGER(IntKi), PARAMETER      :: TStC3_Mxl    = 134
   INTEGER(IntKi), PARAMETER      :: TStC3_Myl    = 135
   INTEGER(IntKi), PARAMETER      :: TStC3_Mzl    = 136
   INTEGER(IntKi), PARAMETER      :: TStC4_XQ     = 137
   INTEGER(IntKi), PARAMETER      :: TStC4_XQD    = 138
   INTEGER(IntKi), PARAMETER      :: TStC4_YQ     = 139
   INTEGER(IntKi), PARAMETER      :: TStC4_YQD    = 140
   INTEGER(IntKi), PARAMETER      :: TStC4_ZQ     = 141
   INTEGER(IntKi), PARAMETER      :: TStC4_ZQD    = 142
   INTEGER(IntKi), PARAMETER      :: TStC4_Fxi    = 143
   INTEGER(IntKi), PARAMETER      :: TStC4_Fyi    = 144
   INTEGER(IntKi), PARAMETER      :: TStC4_Fzi    = 145
   INTEGER(IntKi), PARAMETER      :: TStC4_Mxi    = 146
   INTEGER(IntKi), PARAMETER      :: TStC4_Myi    = 147
   INTEGER(IntKi), PARAMETER      :: TStC4_Mzi    = 148
   INTEGER(IntKi), PARAMETER      :: TStC4_Fxl    = 149
   INTEGER(IntKi), PARAMETER      :: TStC4_Fyl    = 150
   INTEGER(IntKi), PARAMETER      :: TStC4_Fzl    = 151
   INTEGER(IntKi), PARAMETER      :: TStC4_Mxl    = 152
   INTEGER(IntKi), PARAMETER      :: TStC4_Myl    = 153
   INTEGER(IntKi), PARAMETER      :: TStC4_Mzl    = 154


     ! Blade  Structural Control  (StC):

   INTEGER(IntKi), PARAMETER      :: BStC1_B1_XQ  = 155
   INTEGER(IntKi), PARAMETER      :: BStC1_B1_XQD = 156
   INTEGER(IntKi), PARAMETER      :: BStC1_B1_YQ  = 157
   INTEGER(IntKi), PARAMETER      :: BStC1_B1_YQD = 158
   INTEGER(IntKi), PARAMETER      :: BStC1_B1_ZQ  = 159
   INTEGER(IntKi), PARAMETER      :: BStC1_B1_ZQD = 160
   INTEGER(IntKi), PARAMETER      :: BStC1_B1_Fxi = 161
   INTEGER(IntKi), PARAMETER      :: BStC1_B1_Fyi = 162
   INTEGER(IntKi), PARAMETER      :: BStC1_B1_Fzi = 163
   INTEGER(IntKi), PARAMETER      :: BStC1_B1_Mxi = 164
   INTEGER(IntKi), PARAMETER      :: BStC1_B1_Myi = 165
   INTEGER(IntKi), PARAMETER      :: BStC1_B1_Mzi = 166
   INTEGER(IntKi), PARAMETER      :: BStC1_B1_Fxl = 167
   INTEGER(IntKi), PARAMETER      :: BStC1_B1_Fyl = 168
   INTEGER(IntKi), PARAMETER      :: BStC1_B1_Fzl = 169
   INTEGER(IntKi), PARAMETER      :: BStC1_B1_Mxl = 170
   INTEGER(IntKi), PARAMETER      :: BStC1_B1_Myl = 171
   INTEGER(IntKi), PARAMETER      :: BStC1_B1_Mzl = 172
   INTEGER(IntKi), PARAMETER      :: BStC2_B1_XQ  = 173
   INTEGER(IntKi), PARAMETER      :: BStC2_B1_XQD = 174
   INTEGER(IntKi), PARAMETER      :: BStC2_B1_YQ  = 175
   INTEGER(IntKi), PARAMETER      :: BStC2_B1_YQD = 176
   INTEGER(IntKi), PARAMETER      :: BStC2_B1_ZQ  = 177
   INTEGER(IntKi), PARAMETER      :: BStC2_B1_ZQD = 178
   INTEGER(IntKi), PARAMETER      :: BStC2_B1_Fxi = 179
   INTEGER(IntKi), PARAMETER      :: BStC2_B1_Fyi = 180
   INTEGER(IntKi), PARAMETER      :: BStC2_B1_Fzi = 181
   INTEGER(IntKi), PARAMETER      :: BStC2_B1_Mxi = 182
   INTEGER(IntKi), PARAMETER      :: BStC2_B1_Myi = 183
   INTEGER(IntKi), PARAMETER      :: BStC2_B1_Mzi = 184
   INTEGER(IntKi), PARAMETER      :: BStC2_B1_Fxl = 185
   INTEGER(IntKi), PARAMETER      :: BStC2_B1_Fyl = 186
   INTEGER(IntKi), PARAMETER      :: BStC2_B1_Fzl = 187
   INTEGER(IntKi), PARAMETER      :: BStC2_B1_Mxl = 188
   INTEGER(IntKi), PARAMETER      :: BStC2_B1_Myl = 189
   INTEGER(IntKi), PARAMETER      :: BStC2_B1_Mzl = 190
   INTEGER(IntKi), PARAMETER      :: BStC3_B1_XQ  = 191
   INTEGER(IntKi), PARAMETER      :: BStC3_B1_XQD = 192
   INTEGER(IntKi), PARAMETER      :: BStC3_B1_YQ  = 193
   INTEGER(IntKi), PARAMETER      :: BStC3_B1_YQD = 194
   INTEGER(IntKi), PARAMETER      :: BStC3_B1_ZQ  = 195
   INTEGER(IntKi), PARAMETER      :: BStC3_B1_ZQD = 196
   INTEGER(IntKi), PARAMETER      :: BStC3_B1_Fxi = 197
   INTEGER(IntKi), PARAMETER      :: BStC3_B1_Fyi = 198
   INTEGER(IntKi), PARAMETER      :: BStC3_B1_Fzi = 199
   INTEGER(IntKi), PARAMETER      :: BStC3_B1_Mxi = 200
   INTEGER(IntKi), PARAMETER      :: BStC3_B1_Myi = 201
   INTEGER(IntKi), PARAMETER      :: BStC3_B1_Mzi = 202
   INTEGER(IntKi), PARAMETER      :: BStC3_B1_Fxl = 203
   INTEGER(IntKi), PARAMETER      :: BStC3_B1_Fyl = 204
   INTEGER(IntKi), PARAMETER      :: BStC3_B1_Fzl = 205
   INTEGER(IntKi), PARAMETER      :: BStC3_B1_Mxl = 206
   INTEGER(IntKi), PARAMETER      :: BStC3_B1_Myl = 207
   INTEGER(IntKi), PARAMETER      :: BStC3_B1_Mzl = 208
   INTEGER(IntKi), PARAMETER      :: BStC4_B1_XQ  = 209
   INTEGER(IntKi), PARAMETER      :: BStC4_B1_XQD = 210
   INTEGER(IntKi), PARAMETER      :: BStC4_B1_YQ  = 211
   INTEGER(IntKi), PARAMETER      :: BStC4_B1_YQD = 212
   INTEGER(IntKi), PARAMETER      :: BStC4_B1_ZQ  = 213
   INTEGER(IntKi), PARAMETER      :: BStC4_B1_ZQD = 214
   INTEGER(IntKi), PARAMETER      :: BStC4_B1_Fxi = 215
   INTEGER(IntKi), PARAMETER      :: BStC4_B1_Fyi = 216
   INTEGER(IntKi), PARAMETER      :: BStC4_B1_Fzi = 217
   INTEGER(IntKi), PARAMETER      :: BStC4_B1_Mxi = 218
   INTEGER(IntKi), PARAMETER      :: BStC4_B1_Myi = 219
   INTEGER(IntKi), PARAMETER      :: BStC4_B1_Mzi = 220
   INTEGER(IntKi), PARAMETER      :: BStC4_B1_Fxl = 221
   INTEGER(IntKi), PARAMETER      :: BStC4_B1_Fyl = 222
   INTEGER(IntKi), PARAMETER      :: BStC4_B1_Fzl = 223
   INTEGER(IntKi), PARAMETER      :: BStC4_B1_Mxl = 224
   INTEGER(IntKi), PARAMETER      :: BStC4_B1_Myl = 225
   INTEGER(IntKi), PARAMETER      :: BStC4_B1_Mzl = 226
   INTEGER(IntKi), PARAMETER      :: BStC1_B2_XQ  = 227
   INTEGER(IntKi), PARAMETER      :: BStC1_B2_XQD = 228
   INTEGER(IntKi), PARAMETER      :: BStC1_B2_YQ  = 229
   INTEGER(IntKi), PARAMETER      :: BStC1_B2_YQD = 230
   INTEGER(IntKi), PARAMETER      :: BStC1_B2_ZQ  = 231
   INTEGER(IntKi), PARAMETER      :: BStC1_B2_ZQD = 232
   INTEGER(IntKi), PARAMETER      :: BStC1_B2_Fxi = 233
   INTEGER(IntKi), PARAMETER      :: BStC1_B2_Fyi = 234
   INTEGER(IntKi), PARAMETER      :: BStC1_B2_Fzi = 235
   INTEGER(IntKi), PARAMETER      :: BStC1_B2_Mxi = 236
   INTEGER(IntKi), PARAMETER      :: BStC1_B2_Myi = 237
   INTEGER(IntKi), PARAMETER      :: BStC1_B2_Mzi = 238
   INTEGER(IntKi), PARAMETER      :: BStC1_B2_Fxl = 239
   INTEGER(IntKi), PARAMETER      :: BStC1_B2_Fyl = 240
   INTEGER(IntKi), PARAMETER      :: BStC1_B2_Fzl = 241
   INTEGER(IntKi), PARAMETER      :: BStC1_B2_Mxl = 242
   INTEGER(IntKi), PARAMETER      :: BStC1_B2_Myl = 243
   INTEGER(IntKi), PARAMETER      :: BStC1_B2_Mzl = 244
   INTEGER(IntKi), PARAMETER      :: BStC2_B2_XQ  = 245
   INTEGER(IntKi), PARAMETER      :: BStC2_B2_XQD = 246
   INTEGER(IntKi), PARAMETER      :: BStC2_B2_YQ  = 247
   INTEGER(IntKi), PARAMETER      :: BStC2_B2_YQD = 248
   INTEGER(IntKi), PARAMETER      :: BStC2_B2_ZQ  = 249
   INTEGER(IntKi), PARAMETER      :: BStC2_B2_ZQD = 250
   INTEGER(IntKi), PARAMETER      :: BStC2_B2_Fxi = 251
   INTEGER(IntKi), PARAMETER      :: BStC2_B2_Fyi = 252
   INTEGER(IntKi), PARAMETER      :: BStC2_B2_Fzi = 253
   INTEGER(IntKi), PARAMETER      :: BStC2_B2_Mxi = 254
   INTEGER(IntKi), PARAMETER      :: BStC2_B2_Myi = 255
   INTEGER(IntKi), PARAMETER      :: BStC2_B2_Mzi = 256
   INTEGER(IntKi), PARAMETER      :: BStC2_B2_Fxl = 257
   INTEGER(IntKi), PARAMETER      :: BStC2_B2_Fyl = 258
   INTEGER(IntKi), PARAMETER      :: BStC2_B2_Fzl = 259
   INTEGER(IntKi), PARAMETER      :: BStC2_B2_Mxl = 260
   INTEGER(IntKi), PARAMETER      :: BStC2_B2_Myl = 261
   INTEGER(IntKi), PARAMETER      :: BStC2_B2_Mzl = 262
   INTEGER(IntKi), PARAMETER      :: BStC3_B2_XQ  = 263
   INTEGER(IntKi), PARAMETER      :: BStC3_B2_XQD = 264
   INTEGER(IntKi), PARAMETER      :: BStC3_B2_YQ  = 265
   INTEGER(IntKi), PARAMETER      :: BStC3_B2_YQD = 266
   INTEGER(IntKi), PARAMETER      :: BStC3_B2_ZQ  = 267
   INTEGER(IntKi), PARAMETER      :: BStC3_B2_ZQD = 268
   INTEGER(IntKi), PARAMETER      :: BStC3_B2_Fxi = 269
   INTEGER(IntKi), PARAMETER      :: BStC3_B2_Fyi = 270
   INTEGER(IntKi), PARAMETER      :: BStC3_B2_Fzi = 271
   INTEGER(IntKi), PARAMETER      :: BStC3_B2_Mxi = 272
   INTEGER(IntKi), PARAMETER      :: BStC3_B2_Myi = 273
   INTEGER(IntKi), PARAMETER      :: BStC3_B2_Mzi = 274
   INTEGER(IntKi), PARAMETER      :: BStC3_B2_Fxl = 275
   INTEGER(IntKi), PARAMETER      :: BStC3_B2_Fyl = 276
   INTEGER(IntKi), PARAMETER      :: BStC3_B2_Fzl = 277
   INTEGER(IntKi), PARAMETER      :: BStC3_B2_Mxl = 278
   INTEGER(IntKi), PARAMETER      :: BStC3_B2_Myl = 279
   INTEGER(IntKi), PARAMETER      :: BStC3_B2_Mzl = 280
   INTEGER(IntKi), PARAMETER      :: BStC4_B2_XQ  = 281
   INTEGER(IntKi), PARAMETER      :: BStC4_B2_XQD = 282
   INTEGER(IntKi), PARAMETER      :: BStC4_B2_YQ  = 283
   INTEGER(IntKi), PARAMETER      :: BStC4_B2_YQD = 284
   INTEGER(IntKi), PARAMETER      :: BStC4_B2_ZQ  = 285
   INTEGER(IntKi), PARAMETER      :: BStC4_B2_ZQD = 286
   INTEGER(IntKi), PARAMETER      :: BStC4_B2_Fxi = 287
   INTEGER(IntKi), PARAMETER      :: BStC4_B2_Fyi = 288
   INTEGER(IntKi), PARAMETER      :: BStC4_B2_Fzi = 289
   INTEGER(IntKi), PARAMETER      :: BStC4_B2_Mxi = 290
   INTEGER(IntKi), PARAMETER      :: BStC4_B2_Myi = 291
   INTEGER(IntKi), PARAMETER      :: BStC4_B2_Mzi = 292
   INTEGER(IntKi), PARAMETER      :: BStC4_B2_Fxl = 293
   INTEGER(IntKi), PARAMETER      :: BStC4_B2_Fyl = 294
   INTEGER(IntKi), PARAMETER      :: BStC4_B2_Fzl = 295
   INTEGER(IntKi), PARAMETER      :: BStC4_B2_Mxl = 296
   INTEGER(IntKi), PARAMETER      :: BStC4_B2_Myl = 297
   INTEGER(IntKi), PARAMETER      :: BStC4_B2_Mzl = 298
   INTEGER(IntKi), PARAMETER      :: BStC1_B3_XQ  = 299
   INTEGER(IntKi), PARAMETER      :: BStC1_B3_XQD = 300
   INTEGER(IntKi), PARAMETER      :: BStC1_B3_YQ  = 301
   INTEGER(IntKi), PARAMETER      :: BStC1_B3_YQD = 302
   INTEGER(IntKi), PARAMETER      :: BStC1_B3_ZQ  = 303
   INTEGER(IntKi), PARAMETER      :: BStC1_B3_ZQD = 304
   INTEGER(IntKi), PARAMETER      :: BStC1_B3_Fxi = 305
   INTEGER(IntKi), PARAMETER      :: BStC1_B3_Fyi = 306
   INTEGER(IntKi), PARAMETER      :: BStC1_B3_Fzi = 307
   INTEGER(IntKi), PARAMETER      :: BStC1_B3_Mxi = 308
   INTEGER(IntKi), PARAMETER      :: BStC1_B3_Myi = 309
   INTEGER(IntKi), PARAMETER      :: BStC1_B3_Mzi = 310
   INTEGER(IntKi), PARAMETER      :: BStC1_B3_Fxl = 311
   INTEGER(IntKi), PARAMETER      :: BStC1_B3_Fyl = 312
   INTEGER(IntKi), PARAMETER      :: BStC1_B3_Fzl = 313
   INTEGER(IntKi), PARAMETER      :: BStC1_B3_Mxl = 314
   INTEGER(IntKi), PARAMETER      :: BStC1_B3_Myl = 315
   INTEGER(IntKi), PARAMETER      :: BStC1_B3_Mzl = 316
   INTEGER(IntKi), PARAMETER      :: BStC2_B3_XQ  = 317
   INTEGER(IntKi), PARAMETER      :: BStC2_B3_XQD = 318
   INTEGER(IntKi), PARAMETER      :: BStC2_B3_YQ  = 319
   INTEGER(IntKi), PARAMETER      :: BStC2_B3_YQD = 320
   INTEGER(IntKi), PARAMETER      :: BStC2_B3_ZQ  = 321
   INTEGER(IntKi), PARAMETER      :: BStC2_B3_ZQD = 322
   INTEGER(IntKi), PARAMETER      :: BStC2_B3_Fxi = 323
   INTEGER(IntKi), PARAMETER      :: BStC2_B3_Fyi = 324
   INTEGER(IntKi), PARAMETER      :: BStC2_B3_Fzi = 325
   INTEGER(IntKi), PARAMETER      :: BStC2_B3_Mxi = 326
   INTEGER(IntKi), PARAMETER      :: BStC2_B3_Myi = 327
   INTEGER(IntKi), PARAMETER      :: BStC2_B3_Mzi = 328
   INTEGER(IntKi), PARAMETER      :: BStC2_B3_Fxl = 329
   INTEGER(IntKi), PARAMETER      :: BStC2_B3_Fyl = 330
   INTEGER(IntKi), PARAMETER      :: BStC2_B3_Fzl = 331
   INTEGER(IntKi), PARAMETER      :: BStC2_B3_Mxl = 332
   INTEGER(IntKi), PARAMETER      :: BStC2_B3_Myl = 333
   INTEGER(IntKi), PARAMETER      :: BStC2_B3_Mzl = 334
   INTEGER(IntKi), PARAMETER      :: BStC3_B3_XQ  = 335
   INTEGER(IntKi), PARAMETER      :: BStC3_B3_XQD = 336
   INTEGER(IntKi), PARAMETER      :: BStC3_B3_YQ  = 337
   INTEGER(IntKi), PARAMETER      :: BStC3_B3_YQD = 338
   INTEGER(IntKi), PARAMETER      :: BStC3_B3_ZQ  = 339
   INTEGER(IntKi), PARAMETER      :: BStC3_B3_ZQD = 340
   INTEGER(IntKi), PARAMETER      :: BStC3_B3_Fxi = 341
   INTEGER(IntKi), PARAMETER      :: BStC3_B3_Fyi = 342
   INTEGER(IntKi), PARAMETER      :: BStC3_B3_Fzi = 343
   INTEGER(IntKi), PARAMETER      :: BStC3_B3_Mxi = 344
   INTEGER(IntKi), PARAMETER      :: BStC3_B3_Myi = 345
   INTEGER(IntKi), PARAMETER      :: BStC3_B3_Mzi = 346
   INTEGER(IntKi), PARAMETER      :: BStC3_B3_Fxl = 347
   INTEGER(IntKi), PARAMETER      :: BStC3_B3_Fyl = 348
   INTEGER(IntKi), PARAMETER      :: BStC3_B3_Fzl = 349
   INTEGER(IntKi), PARAMETER      :: BStC3_B3_Mxl = 350
   INTEGER(IntKi), PARAMETER      :: BStC3_B3_Myl = 351
   INTEGER(IntKi), PARAMETER      :: BStC3_B3_Mzl = 352
   INTEGER(IntKi), PARAMETER      :: BStC4_B3_XQ  = 353
   INTEGER(IntKi), PARAMETER      :: BStC4_B3_XQD = 354
   INTEGER(IntKi), PARAMETER      :: BStC4_B3_YQ  = 355
   INTEGER(IntKi), PARAMETER      :: BStC4_B3_YQD = 356
   INTEGER(IntKi), PARAMETER      :: BStC4_B3_ZQ  = 357
   INTEGER(IntKi), PARAMETER      :: BStC4_B3_ZQD = 358
   INTEGER(IntKi), PARAMETER      :: BStC4_B3_Fxi = 359
   INTEGER(IntKi), PARAMETER      :: BStC4_B3_Fyi = 360
   INTEGER(IntKi), PARAMETER      :: BStC4_B3_Fzi = 361
   INTEGER(IntKi), PARAMETER      :: BStC4_B3_Mxi = 362
   INTEGER(IntKi), PARAMETER      :: BStC4_B3_Myi = 363
   INTEGER(IntKi), PARAMETER      :: BStC4_B3_Mzi = 364
   INTEGER(IntKi), PARAMETER      :: BStC4_B3_Fxl = 365
   INTEGER(IntKi), PARAMETER      :: BStC4_B3_Fyl = 366
   INTEGER(IntKi), PARAMETER      :: BStC4_B3_Fzl = 367
   INTEGER(IntKi), PARAMETER      :: BStC4_B3_Mxl = 368
   INTEGER(IntKi), PARAMETER      :: BStC4_B3_Myl = 369
   INTEGER(IntKi), PARAMETER      :: BStC4_B3_Mzl = 370
   INTEGER(IntKi), PARAMETER      :: BStC1_B4_XQ  = 371
   INTEGER(IntKi), PARAMETER      :: BStC1_B4_XQD = 372
   INTEGER(IntKi), PARAMETER      :: BStC1_B4_YQ  = 373
   INTEGER(IntKi), PARAMETER      :: BStC1_B4_YQD = 374
   INTEGER(IntKi), PARAMETER      :: BStC1_B4_ZQ  = 375
   INTEGER(IntKi), PARAMETER      :: BStC1_B4_ZQD = 376
   INTEGER(IntKi), PARAMETER      :: BStC1_B4_Fxi = 377
   INTEGER(IntKi), PARAMETER      :: BStC1_B4_Fyi = 378
   INTEGER(IntKi), PARAMETER      :: BStC1_B4_Fzi = 379
   INTEGER(IntKi), PARAMETER      :: BStC1_B4_Mxi = 380
   INTEGER(IntKi), PARAMETER      :: BStC1_B4_Myi = 381
   INTEGER(IntKi), PARAMETER      :: BStC1_B4_Mzi = 382
   INTEGER(IntKi), PARAMETER      :: BStC1_B4_Fxl = 383
   INTEGER(IntKi), PARAMETER      :: BStC1_B4_Fyl = 384
   INTEGER(IntKi), PARAMETER      :: BStC1_B4_Fzl = 385
   INTEGER(IntKi), PARAMETER      :: BStC1_B4_Mxl = 386
   INTEGER(IntKi), PARAMETER      :: BStC1_B4_Myl = 387
   INTEGER(IntKi), PARAMETER      :: BStC1_B4_Mzl = 388
   INTEGER(IntKi), PARAMETER      :: BStC2_B4_XQ  = 389
   INTEGER(IntKi), PARAMETER      :: BStC2_B4_XQD = 390
   INTEGER(IntKi), PARAMETER      :: BStC2_B4_YQ  = 391
   INTEGER(IntKi), PARAMETER      :: BStC2_B4_YQD = 392
   INTEGER(IntKi), PARAMETER      :: BStC2_B4_ZQ  = 393
   INTEGER(IntKi), PARAMETER      :: BStC2_B4_ZQD = 394
   INTEGER(IntKi), PARAMETER      :: BStC2_B4_Fxi = 395
   INTEGER(IntKi), PARAMETER      :: BStC2_B4_Fyi = 396
   INTEGER(IntKi), PARAMETER      :: BStC2_B4_Fzi = 397
   INTEGER(IntKi), PARAMETER      :: BStC2_B4_Mxi = 398
   INTEGER(IntKi), PARAMETER      :: BStC2_B4_Myi = 399
   INTEGER(IntKi), PARAMETER      :: BStC2_B4_Mzi = 400
   INTEGER(IntKi), PARAMETER      :: BStC2_B4_Fxl = 401
   INTEGER(IntKi), PARAMETER      :: BStC2_B4_Fyl = 402
   INTEGER(IntKi), PARAMETER      :: BStC2_B4_Fzl = 403
   INTEGER(IntKi), PARAMETER      :: BStC2_B4_Mxl = 404
   INTEGER(IntKi), PARAMETER      :: BStC2_B4_Myl = 405
   INTEGER(IntKi), PARAMETER      :: BStC2_B4_Mzl = 406
   INTEGER(IntKi), PARAMETER      :: BStC3_B4_XQ  = 407
   INTEGER(IntKi), PARAMETER      :: BStC3_B4_XQD = 408
   INTEGER(IntKi), PARAMETER      :: BStC3_B4_YQ  = 409
   INTEGER(IntKi), PARAMETER      :: BStC3_B4_YQD = 410
   INTEGER(IntKi), PARAMETER      :: BStC3_B4_ZQ  = 411
   INTEGER(IntKi), PARAMETER      :: BStC3_B4_ZQD = 412
   INTEGER(IntKi), PARAMETER      :: BStC3_B4_Fxi = 413
   INTEGER(IntKi), PARAMETER      :: BStC3_B4_Fyi = 414
   INTEGER(IntKi), PARAMETER      :: BStC3_B4_Fzi = 415
   INTEGER(IntKi), PARAMETER      :: BStC3_B4_Mxi = 416
   INTEGER(IntKi), PARAMETER      :: BStC3_B4_Myi = 417
   INTEGER(IntKi), PARAMETER      :: BStC3_B4_Mzi = 418
   INTEGER(IntKi), PARAMETER      :: BStC3_B4_Fxl = 419
   INTEGER(IntKi), PARAMETER      :: BStC3_B4_Fyl = 420
   INTEGER(IntKi), PARAMETER      :: BStC3_B4_Fzl = 421
   INTEGER(IntKi), PARAMETER      :: BStC3_B4_Mxl = 422
   INTEGER(IntKi), PARAMETER      :: BStC3_B4_Myl = 423
   INTEGER(IntKi), PARAMETER      :: BStC3_B4_Mzl = 424
   INTEGER(IntKi), PARAMETER      :: BStC4_B4_XQ  = 425
   INTEGER(IntKi), PARAMETER      :: BStC4_B4_XQD = 426
   INTEGER(IntKi), PARAMETER      :: BStC4_B4_YQ  = 427
   INTEGER(IntKi), PARAMETER      :: BStC4_B4_YQD = 428
   INTEGER(IntKi), PARAMETER      :: BStC4_B4_ZQ  = 429
   INTEGER(IntKi), PARAMETER      :: BStC4_B4_ZQD = 430
   INTEGER(IntKi), PARAMETER      :: BStC4_B4_Fxi = 431
   INTEGER(IntKi), PARAMETER      :: BStC4_B4_Fyi = 432
   INTEGER(IntKi), PARAMETER      :: BStC4_B4_Fzi = 433
   INTEGER(IntKi), PARAMETER      :: BStC4_B4_Mxi = 434
   INTEGER(IntKi), PARAMETER      :: BStC4_B4_Myi = 435
   INTEGER(IntKi), PARAMETER      :: BStC4_B4_Mzi = 436
   INTEGER(IntKi), PARAMETER      :: BStC4_B4_Fxl = 437
   INTEGER(IntKi), PARAMETER      :: BStC4_B4_Fyl = 438
   INTEGER(IntKi), PARAMETER      :: BStC4_B4_Fzl = 439
   INTEGER(IntKi), PARAMETER      :: BStC4_B4_Mxl = 440
   INTEGER(IntKi), PARAMETER      :: BStC4_B4_Myl = 441
   INTEGER(IntKi), PARAMETER      :: BStC4_B4_Mzl = 442


     ! Substructure  Structural Control  (StC):

   INTEGER(IntKi), PARAMETER      :: SStC1_XQ     = 443
   INTEGER(IntKi), PARAMETER      :: SStC1_XQD    = 444
   INTEGER(IntKi), PARAMETER      :: SStC1_YQ     = 445
   INTEGER(IntKi), PARAMETER      :: SStC1_YQD    = 446
   INTEGER(IntKi), PARAMETER      :: SStC1_ZQ     = 447
   INTEGER(IntKi), PARAMETER      :: SStC1_ZQD    = 448
   INTEGER(IntKi), PARAMETER      :: SStC1_Fxi    = 449
   INTEGER(IntKi), PARAMETER      :: SStC1_Fyi    = 450
   INTEGER(IntKi), PARAMETER      :: SStC1_Fzi    = 451
   INTEGER(IntKi), PARAMETER      :: SStC1_Mxi    = 452
   INTEGER(IntKi), PARAMETER      :: SStC1_Myi    = 453
   INTEGER(IntKi), PARAMETER      :: SStC1_Mzi    = 454
   INTEGER(IntKi), PARAMETER      :: SStC1_Fxl    = 455
   INTEGER(IntKi), PARAMETER      :: SStC1_Fyl    = 456
   INTEGER(IntKi), PARAMETER      :: SStC1_Fzl    = 457
   INTEGER(IntKi), PARAMETER      :: SStC1_Mxl    = 458
   INTEGER(IntKi), PARAMETER      :: SStC1_Myl    = 459
   INTEGER(IntKi), PARAMETER      :: SStC1_Mzl    = 460
   INTEGER(IntKi), PARAMETER      :: SStC2_XQ     = 461
   INTEGER(IntKi), PARAMETER      :: SStC2_XQD    = 462
   INTEGER(IntKi), PARAMETER      :: SStC2_YQ     = 463
   INTEGER(IntKi), PARAMETER      :: SStC2_YQD    = 464
   INTEGER(IntKi), PARAMETER      :: SStC2_ZQ     = 465
   INTEGER(IntKi), PARAMETER      :: SStC2_ZQD    = 466
   INTEGER(IntKi), PARAMETER      :: SStC2_Fxi    = 467
   INTEGER(IntKi), PARAMETER      :: SStC2_Fyi    = 468
   INTEGER(IntKi), PARAMETER      :: SStC2_Fzi    = 469
   INTEGER(IntKi), PARAMETER      :: SStC2_Mxi    = 470
   INTEGER(IntKi), PARAMETER      :: SStC2_Myi    = 471
   INTEGER(IntKi), PARAMETER      :: SStC2_Mzi    = 472
   INTEGER(IntKi), PARAMETER      :: SStC2_Fxl    = 473
   INTEGER(IntKi), PARAMETER      :: SStC2_Fyl    = 474
   INTEGER(IntKi), PARAMETER      :: SStC2_Fzl    = 475
   INTEGER(IntKi), PARAMETER      :: SStC2_Mxl    = 476
   INTEGER(IntKi), PARAMETER      :: SStC2_Myl    = 477
   INTEGER(IntKi), PARAMETER      :: SStC2_Mzl    = 478
   INTEGER(IntKi), PARAMETER      :: SStC3_XQ     = 479
   INTEGER(IntKi), PARAMETER      :: SStC3_XQD    = 480
   INTEGER(IntKi), PARAMETER      :: SStC3_YQ     = 481
   INTEGER(IntKi), PARAMETER      :: SStC3_YQD    = 482
   INTEGER(IntKi), PARAMETER      :: SStC3_ZQ     = 483
   INTEGER(IntKi), PARAMETER      :: SStC3_ZQD    = 484
   INTEGER(IntKi), PARAMETER      :: SStC3_Fxi    = 485
   INTEGER(IntKi), PARAMETER      :: SStC3_Fyi    = 486
   INTEGER(IntKi), PARAMETER      :: SStC3_Fzi    = 487
   INTEGER(IntKi), PARAMETER      :: SStC3_Mxi    = 488
   INTEGER(IntKi), PARAMETER      :: SStC3_Myi    = 489
   INTEGER(IntKi), PARAMETER      :: SStC3_Mzi    = 490
   INTEGER(IntKi), PARAMETER      :: SStC3_Fxl    = 491
   INTEGER(IntKi), PARAMETER      :: SStC3_Fyl    = 492
   INTEGER(IntKi), PARAMETER      :: SStC3_Fzl    = 493
   INTEGER(IntKi), PARAMETER      :: SStC3_Mxl    = 494
   INTEGER(IntKi), PARAMETER      :: SStC3_Myl    = 495
   INTEGER(IntKi), PARAMETER      :: SStC3_Mzl    = 496
   INTEGER(IntKi), PARAMETER      :: SStC4_XQ     = 497
   INTEGER(IntKi), PARAMETER      :: SStC4_XQD    = 498
   INTEGER(IntKi), PARAMETER      :: SStC4_YQ     = 499
   INTEGER(IntKi), PARAMETER      :: SStC4_YQD    = 500
   INTEGER(IntKi), PARAMETER      :: SStC4_ZQ     = 501
   INTEGER(IntKi), PARAMETER      :: SStC4_ZQD    = 502
   INTEGER(IntKi), PARAMETER      :: SStC4_Fxi    = 503
   INTEGER(IntKi), PARAMETER      :: SStC4_Fyi    = 504
   INTEGER(IntKi), PARAMETER      :: SStC4_Fzi    = 505
   INTEGER(IntKi), PARAMETER      :: SStC4_Mxi    = 506
   INTEGER(IntKi), PARAMETER      :: SStC4_Myi    = 507
   INTEGER(IntKi), PARAMETER      :: SStC4_Mzi    = 508
   INTEGER(IntKi), PARAMETER      :: SStC4_Fxl    = 509
   INTEGER(IntKi), PARAMETER      :: SStC4_Fyl    = 510
   INTEGER(IntKi), PARAMETER      :: SStC4_Fzl    = 511
   INTEGER(IntKi), PARAMETER      :: SStC4_Mxl    = 512
   INTEGER(IntKi), PARAMETER      :: SStC4_Myl    = 513
   INTEGER(IntKi), PARAMETER      :: SStC4_Mzl    = 514


     ! The maximum number of output channels which can be output by the code.
   INTEGER(IntKi), PARAMETER      :: MaxOutPts    = 514

!End of code generated by Matlab script
! ===================================================================================================
   INTEGER(IntKi), PARAMETER      :: BlPitchC (3) = (/ BlPitchC1, BlPitchC2, BlPitchC3 /) 
   INTEGER(IntKi), PARAMETER      :: BlAirfoilC (3) = (/ BlAirFlC1, BlAirFlC2, BlAirFlC3 /)

   ! Structural Control outputs -- these arrays simplify the output a little.  The MaxBlOuts and MaxStC
   !                               must be set according to what is in the OutListParameters and auto
   !                               generated code above.
   INTEGER(IntKi), PARAMETER      :: MaxBlOuts = 4    ! maximum number of blades that we can output for
   INTEGER(IntKi), PARAMETER      :: MaxStC    = 4    ! maximum number of StC outputs of type
   ! StC nacelle outputs -- maximum of 4 for now.  Expand if more needed
   INTEGER(IntKi), PARAMETER      :: NStC_XQ(MaxStC)    = (/ NStC1_XQ,  NStC2_XQ,  NStC3_XQ,  NStC4_XQ  /)
   INTEGER(IntKi), PARAMETER      :: NStC_XQD(MaxStC)   = (/ NStC1_XQD, NStC2_XQD, NStC3_XQD, NStC4_XQD /)
   INTEGER(IntKi), PARAMETER      :: NStC_YQ(MaxStC)    = (/ NStC1_YQ,  NStC2_YQ,  NStC3_YQ,  NStC4_YQ  /)
   INTEGER(IntKi), PARAMETER      :: NStC_YQD(MaxStC)   = (/ NStC1_YQD, NStC2_YQD, NStC3_YQD, NStC4_YQD /)
   INTEGER(IntKi), PARAMETER      :: NStC_ZQ(MaxStC)    = (/ NStC1_ZQ,  NStC2_ZQ,  NStC3_ZQ,  NStC4_ZQ  /)
   INTEGER(IntKi), PARAMETER      :: NStC_ZQD(MaxStC)   = (/ NStC1_ZQD, NStC2_ZQD, NStC3_ZQD, NStC4_ZQD /)
   INTEGER(IntKi), PARAMETER      :: NStC_Fxi(MaxStC)   = (/ NStC1_Fxi, NStC2_Fxi, NStC3_Fxi, NStC4_Fxi /)
   INTEGER(IntKi), PARAMETER      :: NStC_Fyi(MaxStC)   = (/ NStC1_Fyi, NStC2_Fyi, NStC3_Fyi, NStC4_Fyi /)
   INTEGER(IntKi), PARAMETER      :: NStC_Fzi(MaxStC)   = (/ NStC1_Fzi, NStC2_Fzi, NStC3_Fzi, NStC4_Fzi /)
   INTEGER(IntKi), PARAMETER      :: NStC_Mxi(MaxStC)   = (/ NStC1_Mxi, NStC2_Mxi, NStC3_Mxi, NStC4_Mxi /)
   INTEGER(IntKi), PARAMETER      :: NStC_Myi(MaxStC)   = (/ NStC1_Myi, NStC2_Myi, NStC3_Myi, NStC4_Myi /)
   INTEGER(IntKi), PARAMETER      :: NStC_Mzi(MaxStC)   = (/ NStC1_Mzi, NStC2_Mzi, NStC3_Mzi, NStC4_Mzi /)
   INTEGER(IntKi), PARAMETER      :: NStC_Fxl(MaxStC)   = (/ NStC1_Fxl, NStC2_Fxl, NStC3_Fxl, NStC4_Fxl /)
   INTEGER(IntKi), PARAMETER      :: NStC_Fyl(MaxStC)   = (/ NStC1_Fyl, NStC2_Fyl, NStC3_Fyl, NStC4_Fyl /)
   INTEGER(IntKi), PARAMETER      :: NStC_Fzl(MaxStC)   = (/ NStC1_Fzl, NStC2_Fzl, NStC3_Fzl, NStC4_Fzl /)
   INTEGER(IntKi), PARAMETER      :: NStC_Mxl(MaxStC)   = (/ NStC1_Mxl, NStC2_Mxl, NStC3_Mxl, NStC4_Mxl /)
   INTEGER(IntKi), PARAMETER      :: NStC_Myl(MaxStC)   = (/ NStC1_Myl, NStC2_Myl, NStC3_Myl, NStC4_Myl /)
   INTEGER(IntKi), PARAMETER      :: NStC_Mzl(MaxStC)   = (/ NStC1_Mzl, NStC2_Mzl, NStC3_Mzl, NStC4_Mzl /)
   ! StC tower outputs -- maximum of 4 for now.  Expand if more needed
   INTEGER(IntKi), PARAMETER      :: TStC_XQ(MaxStC)    = (/ TStC1_XQ,  TStC2_XQ,  TStC3_XQ,  TStC4_XQ  /)
   INTEGER(IntKi), PARAMETER      :: TStC_XQD(MaxStC)   = (/ TStC1_XQD, TStC2_XQD, TStC3_XQD, TStC4_XQD /)
   INTEGER(IntKi), PARAMETER      :: TStC_YQ(MaxStC)    = (/ TStC1_YQ,  TStC2_YQ,  TStC3_YQ,  TStC4_YQ  /)
   INTEGER(IntKi), PARAMETER      :: TStC_YQD(MaxStC)   = (/ TStC1_YQD, TStC2_YQD, TStC3_YQD, TStC4_YQD /)
   INTEGER(IntKi), PARAMETER      :: TStC_ZQ(MaxStC)    = (/ TStC1_ZQ,  TStC2_ZQ,  TStC3_ZQ,  TStC4_ZQ  /)
   INTEGER(IntKi), PARAMETER      :: TStC_ZQD(MaxStC)   = (/ TStC1_ZQD, TStC2_ZQD, TStC3_ZQD, TStC4_ZQD /)
   INTEGER(IntKi), PARAMETER      :: TStC_Fxi(MaxStC)   = (/ TStC1_Fxi, TStC2_Fxi, TStC3_Fxi, TStC4_Fxi /)
   INTEGER(IntKi), PARAMETER      :: TStC_Fyi(MaxStC)   = (/ TStC1_Fyi, TStC2_Fyi, TStC3_Fyi, TStC4_Fyi /)
   INTEGER(IntKi), PARAMETER      :: TStC_Fzi(MaxStC)   = (/ TStC1_Fzi, TStC2_Fzi, TStC3_Fzi, TStC4_Fzi /)
   INTEGER(IntKi), PARAMETER      :: TStC_Mxi(MaxStC)   = (/ TStC1_Mxi, TStC2_Mxi, TStC3_Mxi, TStC4_Mxi /)
   INTEGER(IntKi), PARAMETER      :: TStC_Myi(MaxStC)   = (/ TStC1_Myi, TStC2_Myi, TStC3_Myi, TStC4_Myi /)
   INTEGER(IntKi), PARAMETER      :: TStC_Mzi(MaxStC)   = (/ TStC1_Mzi, TStC2_Mzi, TStC3_Mzi, TStC4_Mzi /)
   INTEGER(IntKi), PARAMETER      :: TStC_Fxl(MaxStC)   = (/ TStC1_Fxl, TStC2_Fxl, TStC3_Fxl, TStC4_Fxl /)
   INTEGER(IntKi), PARAMETER      :: TStC_Fyl(MaxStC)   = (/ TStC1_Fyl, TStC2_Fyl, TStC3_Fyl, TStC4_Fyl /)
   INTEGER(IntKi), PARAMETER      :: TStC_Fzl(MaxStC)   = (/ TStC1_Fzl, TStC2_Fzl, TStC3_Fzl, TStC4_Fzl /)
   INTEGER(IntKi), PARAMETER      :: TStC_Mxl(MaxStC)   = (/ TStC1_Mxl, TStC2_Mxl, TStC3_Mxl, TStC4_Mxl /)
   INTEGER(IntKi), PARAMETER      :: TStC_Myl(MaxStC)   = (/ TStC1_Myl, TStC2_Myl, TStC3_Myl, TStC4_Myl /)
   INTEGER(IntKi), PARAMETER      :: TStC_Mzl(MaxStC)   = (/ TStC1_Mzl, TStC2_Mzl, TStC3_Mzl, TStC4_Mzl /)
   ! StC blade outputs -- maximum of 4 for now.  Expand if more needed
   INTEGER(IntKi), PARAMETER      :: BStC_XQ(MaxStC,MaxBlOuts) = reshape((/ &
                                         BStC1_B1_XQ,  BStC2_B1_XQ,  BStC3_B1_XQ,  BStC4_B1_XQ,  &
                                         BStC1_B2_XQ,  BStC2_B2_XQ,  BStC3_B2_XQ,  BStC4_B2_XQ,  &
                                         BStC1_B3_XQ,  BStC2_B3_XQ,  BStC3_B3_XQ,  BStC4_B3_XQ,  &
                                         BStC1_B4_XQ,  BStC2_B4_XQ,  BStC3_B4_XQ,  BStC4_B4_XQ   /),(/4,MaxBlOuts/))
   INTEGER(IntKi), PARAMETER      :: BStC_XQD(MaxStC,MaxBlOuts)= reshape((/ &
                                         BStC1_B1_XQD, BStC2_B1_XQD, BStC3_B1_XQD, BStC4_B1_XQD, &
                                         BStC1_B2_XQD, BStC2_B2_XQD, BStC3_B2_XQD, BStC4_B2_XQD, &
                                         BStC1_B3_XQD, BStC2_B3_XQD, BStC3_B3_XQD, BStC4_B3_XQD, &
                                         BStC1_B4_XQD, BStC2_B4_XQD, BStC3_B4_XQD, BStC4_B4_XQD  /),(/4,MaxBlOuts/))
   INTEGER(IntKi), PARAMETER      :: BStC_YQ(MaxStC,MaxBlOuts) = reshape((/ &
                                         BStC1_B1_YQ,  BStC2_B1_YQ,  BStC3_B1_YQ,  BStC4_B1_YQ,  &
                                         BStC1_B2_YQ,  BStC2_B2_YQ,  BStC3_B2_YQ,  BStC4_B2_YQ,  &
                                         BStC1_B3_YQ,  BStC2_B3_YQ,  BStC3_B3_YQ,  BStC4_B3_YQ,  &
                                         BStC1_B4_YQ,  BStC2_B4_YQ,  BStC3_B4_YQ,  BStC4_B4_YQ   /),(/4,MaxBlOuts/))
   INTEGER(IntKi), PARAMETER      :: BStC_YQD(MaxStC,MaxBlOuts)= reshape((/ &
                                         BStC1_B1_YQD, BStC2_B1_YQD, BStC3_B1_YQD, BStC4_B1_YQD, &
                                         BStC1_B2_YQD, BStC2_B2_YQD, BStC3_B2_YQD, BStC4_B2_YQD, &
                                         BStC1_B3_YQD, BStC2_B3_YQD, BStC3_B3_YQD, BStC4_B3_YQD, &
                                         BStC1_B4_YQD, BStC2_B4_YQD, BStC3_B4_YQD, BStC4_B4_YQD  /),(/4,MaxBlOuts/))
   INTEGER(IntKi), PARAMETER      :: BStC_ZQ(MaxStC,MaxBlOuts) = reshape((/ &
                                         BStC1_B1_ZQ,  BStC2_B1_ZQ,  BStC3_B1_ZQ,  BStC4_B1_ZQ,  &
                                         BStC1_B2_ZQ,  BStC2_B2_ZQ,  BStC3_B2_ZQ,  BStC4_B2_ZQ,  &
                                         BStC1_B3_ZQ,  BStC2_B3_ZQ,  BStC3_B3_ZQ,  BStC4_B3_ZQ,  &
                                         BStC1_B4_ZQ,  BStC2_B4_ZQ,  BStC3_B4_ZQ,  BStC4_B4_ZQ   /),(/4,MaxBlOuts/))
   INTEGER(IntKi), PARAMETER      :: BStC_ZQD(MaxStC,MaxBlOuts)= reshape((/ &
                                         BStC1_B1_ZQD, BStC2_B1_ZQD, BStC3_B1_ZQD, BStC4_B1_ZQD, &
                                         BStC1_B2_ZQD, BStC2_B2_ZQD, BStC3_B2_ZQD, BStC4_B2_ZQD, &
                                         BStC1_B3_ZQD, BStC2_B3_ZQD, BStC3_B3_ZQD, BStC4_B3_ZQD, &
                                         BStC1_B4_ZQD, BStC2_B4_ZQD, BStC3_B4_ZQD, BStC4_B4_ZQD  /),(/4,MaxBlOuts/))
   INTEGER(IntKi), PARAMETER      :: BStC_Fxi(MaxStC,MaxBlOuts)= reshape((/ &
                                         BStC1_B1_Fxi, BStC2_B1_Fxi, BStC3_B1_Fxi, BStC4_B1_Fxi, &
                                         BStC1_B2_Fxi, BStC2_B2_Fxi, BStC3_B2_Fxi, BStC4_B2_Fxi, &
                                         BStC1_B3_Fxi, BStC2_B3_Fxi, BStC3_B3_Fxi, BStC4_B3_Fxi, &
                                         BStC1_B4_Fxi, BStC2_B4_Fxi, BStC3_B4_Fxi, BStC4_B4_Fxi  /),(/4,MaxBlOuts/))
   INTEGER(IntKi), PARAMETER      :: BStC_Fyi(MaxStC,MaxBlOuts)= reshape((/ &
                                         BStC1_B1_Fyi, BStC2_B1_Fyi, BStC3_B1_Fyi, BStC4_B1_Fyi, &
                                         BStC1_B2_Fyi, BStC2_B2_Fyi, BStC3_B2_Fyi, BStC4_B2_Fyi, &
                                         BStC1_B3_Fyi, BStC2_B3_Fyi, BStC3_B3_Fyi, BStC4_B3_Fyi, &
                                         BStC1_B4_Fyi, BStC2_B4_Fyi, BStC3_B4_Fyi, BStC4_B4_Fyi  /),(/4,MaxBlOuts/))
   INTEGER(IntKi), PARAMETER      :: BStC_Fzi(MaxStC,MaxBlOuts)= reshape((/ &
                                         BStC1_B1_Fzi, BStC2_B1_Fzi, BStC3_B1_Fzi, BStC4_B1_Fzi, &
                                         BStC1_B2_Fzi, BStC2_B2_Fzi, BStC3_B2_Fzi, BStC4_B2_Fzi, &
                                         BStC1_B3_Fzi, BStC2_B3_Fzi, BStC3_B3_Fzi, BStC4_B3_Fzi, &
                                         BStC1_B4_Fzi, BStC2_B4_Fzi, BStC3_B4_Fzi, BStC4_B4_Fzi  /),(/4,MaxBlOuts/))
   INTEGER(IntKi), PARAMETER      :: BStC_Mxi(MaxStC,MaxBlOuts)= reshape((/ &
                                         BStC1_B1_Mxi, BStC2_B1_Mxi, BStC3_B1_Mxi, BStC4_B1_Mxi, &
                                         BStC1_B2_Mxi, BStC2_B2_Mxi, BStC3_B2_Mxi, BStC4_B2_Mxi, &
                                         BStC1_B3_Mxi, BStC2_B3_Mxi, BStC3_B3_Mxi, BStC4_B3_Mxi, &
                                         BStC1_B4_Mxi, BStC2_B4_Mxi, BStC3_B4_Mxi, BStC4_B4_Mxi  /),(/4,MaxBlOuts/))
   INTEGER(IntKi), PARAMETER      :: BStC_Myi(MaxStC,MaxBlOuts)= reshape((/ &
                                         BStC1_B1_Myi, BStC2_B1_Myi, BStC3_B1_Myi, BStC4_B1_Myi, &
                                         BStC1_B2_Myi, BStC2_B2_Myi, BStC3_B2_Myi, BStC4_B2_Myi, &
                                         BStC1_B3_Myi, BStC2_B3_Myi, BStC3_B3_Myi, BStC4_B3_Myi, &
                                         BStC1_B4_Myi, BStC2_B4_Myi, BStC3_B4_Myi, BStC4_B4_Myi  /),(/4,MaxBlOuts/))
   INTEGER(IntKi), PARAMETER      :: BStC_Mzi(MaxStC,MaxBlOuts)= reshape((/ &
                                         BStC1_B1_Mzi, BStC2_B1_Mzi, BStC3_B1_Mzi, BStC4_B1_Mzi, &
                                         BStC1_B2_Mzi, BStC2_B2_Mzi, BStC3_B2_Mzi, BStC4_B2_Mzi, &
                                         BStC1_B3_Mzi, BStC2_B3_Mzi, BStC3_B3_Mzi, BStC4_B3_Mzi, &
                                         BStC1_B4_Mzi, BStC2_B4_Mzi, BStC3_B4_Mzi, BStC4_B4_Mzi  /),(/4,MaxBlOuts/))
   INTEGER(IntKi), PARAMETER      :: BStC_Fxl(MaxStC,MaxBlOuts)= reshape((/ &
                                         BStC1_B1_Fxl, BStC2_B1_Fxl, BStC3_B1_Fxl, BStC4_B1_Fxl, &
                                         BStC1_B2_Fxl, BStC2_B2_Fxl, BStC3_B2_Fxl, BStC4_B2_Fxl, &
                                         BStC1_B3_Fxl, BStC2_B3_Fxl, BStC3_B3_Fxl, BStC4_B3_Fxl, &
                                         BStC1_B4_Fxl, BStC2_B4_Fxl, BStC3_B4_Fxl, BStC4_B4_Fxl  /),(/4,MaxBlOuts/))
   INTEGER(IntKi), PARAMETER      :: BStC_Fyl(MaxStC,MaxBlOuts)= reshape((/ &
                                         BStC1_B1_Fyl, BStC2_B1_Fyl, BStC3_B1_Fyl, BStC4_B1_Fyl, &
                                         BStC1_B2_Fyl, BStC2_B2_Fyl, BStC3_B2_Fyl, BStC4_B2_Fyl, &
                                         BStC1_B3_Fyl, BStC2_B3_Fyl, BStC3_B3_Fyl, BStC4_B3_Fyl, &
                                         BStC1_B1_Fyl, BStC2_B1_Fyl, BStC3_B1_Fyl, BStC4_B1_Fyl  /),(/4,MaxBlOuts/))
   INTEGER(IntKi), PARAMETER      :: BStC_Fzl(MaxStC,MaxBlOuts)= reshape((/ &
                                         BStC1_B1_Fzl, BStC2_B1_Fzl, BStC3_B1_Fzl, BStC4_B1_Fzl, &
                                         BStC1_B2_Fzl, BStC2_B2_Fzl, BStC3_B2_Fzl, BStC4_B2_Fzl, &
                                         BStC1_B3_Fzl, BStC2_B3_Fzl, BStC3_B3_Fzl, BStC4_B3_Fzl, &
                                         BStC1_B4_Fzl, BStC2_B4_Fzl, BStC3_B4_Fzl, BStC4_B4_Fzl  /),(/4,MaxBlOuts/))
   INTEGER(IntKi), PARAMETER      :: BStC_Mxl(MaxStC,MaxBlOuts)= reshape((/ &
                                         BStC1_B1_Mxl, BStC2_B1_Mxl, BStC3_B1_Mxl, BStC4_B1_Mxl, &
                                         BStC1_B2_Mxl, BStC2_B2_Mxl, BStC3_B2_Mxl, BStC4_B2_Mxl, &
                                         BStC1_B3_Mxl, BStC2_B3_Mxl, BStC3_B3_Mxl, BStC4_B3_Mxl, &
                                         BStC1_B4_Mxl, BStC2_B4_Mxl, BStC3_B4_Mxl, BStC4_B4_Mxl  /),(/4,MaxBlOuts/))
   INTEGER(IntKi), PARAMETER      :: BStC_Myl(MaxStC,MaxBlOuts)= reshape((/ &
                                         BStC1_B1_Myl, BStC2_B1_Myl, BStC3_B1_Myl, BStC4_B1_Myl, &
                                         BStC1_B2_Myl, BStC2_B2_Myl, BStC3_B2_Myl, BStC4_B2_Myl, &
                                         BStC1_B3_Myl, BStC2_B3_Myl, BStC3_B3_Myl, BStC4_B3_Myl, &
                                         BStC1_B4_Myl, BStC2_B4_Myl, BStC3_B4_Myl, BStC4_B4_Myl  /),(/4,MaxBlOuts/))
   INTEGER(IntKi), PARAMETER      :: BStC_Mzl(MaxStC,MaxBlOuts)= reshape((/ &
                                         BStC1_B1_Mzl, BStC2_B1_Mzl, BStC3_B1_Mzl, BStC4_B1_Mzl, &
                                         BStC1_B2_Mzl, BStC2_B2_Mzl, BStC3_B2_Mzl, BStC4_B2_Mzl, &
                                         BStC1_B3_Mzl, BStC2_B3_Mzl, BStC3_B3_Mzl, BStC4_B3_Mzl, &
                                         BStC1_B4_Mzl, BStC2_B4_Mzl, BStC3_B4_Mzl, BStC4_B4_Mzl  /),(/4,MaxBlOuts/))
   ! StC Platform outputs -- maximum of 4 for now.  Expand if more needed
   INTEGER(IntKi), PARAMETER      :: SStC_XQ(MaxStC)    = (/ SStC1_XQ,  SStC2_XQ,  SStC3_XQ,  SStC4_XQ  /)
   INTEGER(IntKi), PARAMETER      :: SStC_XQD(MaxStC)   = (/ SStC1_XQD, SStC2_XQD, SStC3_XQD, SStC4_XQD /)
   INTEGER(IntKi), PARAMETER      :: SStC_YQ(MaxStC)    = (/ SStC1_YQ,  SStC2_YQ,  SStC3_YQ,  SStC4_YQ  /)
   INTEGER(IntKi), PARAMETER      :: SStC_YQD(MaxStC)   = (/ SStC1_YQD, SStC2_YQD, SStC3_YQD, SStC4_YQD /)
   INTEGER(IntKi), PARAMETER      :: SStC_ZQ(MaxStC)    = (/ SStC1_ZQ,  SStC2_ZQ,  SStC3_ZQ,  SStC4_ZQ  /)
   INTEGER(IntKi), PARAMETER      :: SStC_ZQD(MaxStC)   = (/ SStC1_ZQD, SStC2_ZQD, SStC3_ZQD, SStC4_ZQD /)
   INTEGER(IntKi), PARAMETER      :: SStC_Fxi(MaxStC)   = (/ SStC1_Fxi, SStC2_Fxi, SStC3_Fxi, SStC4_Fxi /)
   INTEGER(IntKi), PARAMETER      :: SStC_Fyi(MaxStC)   = (/ SStC1_Fyi, SStC2_Fyi, SStC3_Fyi, SStC4_Fyi /)
   INTEGER(IntKi), PARAMETER      :: SStC_Fzi(MaxStC)   = (/ SStC1_Fzi, SStC2_Fzi, SStC3_Fzi, SStC4_Fzi /)
   INTEGER(IntKi), PARAMETER      :: SStC_Mxi(MaxStC)   = (/ SStC1_Mxi, SStC2_Mxi, SStC3_Mxi, SStC4_Mxi /)
   INTEGER(IntKi), PARAMETER      :: SStC_Myi(MaxStC)   = (/ SStC1_Myi, SStC2_Myi, SStC3_Myi, SStC4_Myi /)
   INTEGER(IntKi), PARAMETER      :: SStC_Mzi(MaxStC)   = (/ SStC1_Mzi, SStC2_Mzi, SStC3_Mzi, SStC4_Mzi /)
   INTEGER(IntKi), PARAMETER      :: SStC_Fxl(MaxStC)   = (/ SStC1_Fxl, SStC2_Fxl, SStC3_Fxl, SStC4_Fxl /)
   INTEGER(IntKi), PARAMETER      :: SStC_Fyl(MaxStC)   = (/ SStC1_Fyl, SStC2_Fyl, SStC3_Fyl, SStC4_Fyl /)
   INTEGER(IntKi), PARAMETER      :: SStC_Fzl(MaxStC)   = (/ SStC1_Fzl, SStC2_Fzl, SStC3_Fzl, SStC4_Fzl /)
   INTEGER(IntKi), PARAMETER      :: SStC_Mxl(MaxStC)   = (/ SStC1_Mxl, SStC2_Mxl, SStC3_Mxl, SStC4_Mxl /)
   INTEGER(IntKi), PARAMETER      :: SStC_Myl(MaxStC)   = (/ SStC1_Myl, SStC2_Myl, SStC3_Myl, SStC4_Myl /)
   INTEGER(IntKi), PARAMETER      :: SStC_Mzl(MaxStC)   = (/ SStC1_Mzl, SStC2_Mzl, SStC3_Mzl, SStC4_Mzl /)



CONTAINS
!---------------------------
subroutine Set_SrvD_Outs( p, y, m, AllOuts )
   type(SrvD_ParameterType),                    intent(in   )  :: p           !< Parameters
   type(SrvD_OutputType),                       intent(in   )  :: y           !< Outputs computed at Time
   type(SrvD_MiscVarType),                      intent(inout)  :: m           !< Misc (optimization) variables
   real(ReKi),                                  intent(inout)  :: AllOuts(0:MaxOutPts)  ! All the available output channels
   integer  :: K

   !...............................................................................................................................   
   ! Calculate all of the available output channels:
   !...............................................................................................................................   
      ! This is overwriting the values if it was called from UpdateStates, but they 
      ! should be the same and this sets the values if we called the DLL above.
   m%dll_data%ElecPwr_prev = y%ElecPwr
   m%dll_data%GenTrq_prev  = y%GenTrq
   
   !...............................................................................................................................   
   ! Calculate all of the available output channels:
   !...............................................................................................................................   
!   AllOuts(Time) = t    
   
   AllOuts(GenTq)   = 0.001*y%GenTrq
   AllOuts(GenPwr)  = 0.001*y%ElecPwr
   AllOuts(HSSBrTqC)= 0.001*y%HSSBrTrqC

   DO K=1,p%NumBl
      AllOuts( BlPitchC(K) )     = y%BlPitchCom(K)*R2D
      AllOuts( BlAirfoilC(K) )   = y%BlAirfoilCom(K)
   END DO

   AllOuts(YawMomCom) = -0.001*y%YawMom

end subroutine Set_SrvD_Outs
!---------------------------
subroutine Set_NStC_Outs( p_SrvD, x, m, y, AllOuts )     ! Nacelle
   type(SrvD_ParameterType),                    intent(in   )  :: p_SrvD               !< Parameters
   type(StC_ContinuousStateType),   allocatable,intent(in   )  :: x(:)                 !< Continuous states at t
   type(StC_MiscVarType),           allocatable,intent(in   )  :: m(:)                 !< Misc (optimization) variables
   type(StC_OutputType),            allocatable,intent(in   )  :: y(:)                 !< Outputs computed at Time
   real(ReKi),                                  intent(inout)  :: AllOuts(0:MaxOutPts) ! All the available output channels
   integer  :: i
   if (allocated(x) .and. allocated(m) .and. allocated(y)) then
      do i=1,min(p_SrvD%NumNStC,MaxStC)                       ! in case we have more Nacelle StCs than the outputs are set for
         call Set_NStC_Outs_Instance( i, x(i), m(i), y(i), AllOuts )
      enddo
   endif
end subroutine Set_NStC_Outs
!---------------------------
subroutine Set_NStC_Outs_Instance( i, x, m, y, AllOuts )     ! Nacelle single StC instance
   integer(IntKi),                  intent(in   )  :: i                    ! This instance
   type(StC_ContinuousStateType),   intent(in   )  :: x                    !< Continuous states at t
   type(StC_MiscVarType),           intent(in   )  :: m                    !< Misc (optimization) variables
   type(StC_OutputType),            intent(in   )  :: y                    !< Outputs computed at Time
   real(ReKi),                      intent(inout)  :: AllOuts(0:MaxOutPts) ! All the available output channels
   integer  :: j
   j=1
   if (i < MaxStC) then
      AllOuts(NStC_XQ( i)) = x%StC_x(1,1)                ! x
      AllOuts(NStC_XQD(i)) = x%StC_x(2,1)                ! x-dot
      AllOuts(NStC_YQ( i)) = x%StC_x(3,1)                ! y
      AllOuts(NStC_YQD(i)) = x%StC_x(4,1)                ! y-dot
      AllOuts(NStC_ZQ( i)) = x%StC_x(5,1)                ! z
      AllOuts(NStC_ZQD(i)) = x%StC_x(6,1)                ! z-dot
      AllOuts(NStC_Fxi(i)) = 0.001*y%Mesh(j)%Force(1,1)  ! only one mesh per NStC instance
      AllOuts(NStC_Fyi(i)) = 0.001*y%Mesh(j)%Force(2,1)  ! only one mesh per NStC instance
      AllOuts(NStC_Fzi(i)) = 0.001*y%Mesh(j)%Force(3,1)  ! only one mesh per NStC instance
      AllOuts(NStC_Mxi(i)) = 0.001*y%Mesh(j)%Moment(1,1) ! only one mesh per NStC instance
      AllOuts(NStC_Myi(i)) = 0.001*y%Mesh(j)%Moment(2,1) ! only one mesh per NStC instance
      AllOuts(NStC_Mzi(i)) = 0.001*y%Mesh(j)%Moment(3,1) ! only one mesh per NStC instance
      AllOuts(NStC_Fxl(i)) = 0.001*m%F_P(1,j)
      AllOuts(NStC_Fyl(i)) = 0.001*m%F_P(2,j)
      AllOuts(NStC_Fzl(i)) = 0.001*m%F_P(3,j)
      AllOuts(NStC_Mxl(i)) = 0.001*m%M_P(1,j)
      AllOuts(NStC_Myl(i)) = 0.001*m%M_P(2,j)
      AllOuts(NStC_Mzl(i)) = 0.001*m%M_P(3,j)
   endif
end subroutine Set_NStC_Outs_Instance
!---------------------------
subroutine Set_TStC_Outs( p_SrvD, x, m, y, AllOuts )     ! Tower
   type(SrvD_ParameterType),                    intent(in   )  :: p_SrvD               !< Parameters
   type(StC_ContinuousStateType),   allocatable,intent(in   )  :: x(:)                 !< Continuous states at t
   type(StC_MiscVarType),           allocatable,intent(in   )  :: m(:)                 !< Misc (optimization) variables
   type(StC_OutputType),            allocatable,intent(in   )  :: y(:)                 !< Outputs computed at Time
   real(ReKi),                                  intent(inout)  :: AllOuts(0:MaxOutPts) ! All the available output channels
   integer  :: i
   if (allocated(x) .and. allocated(m) .and. allocated(y)) then
      do i=1,min(p_SrvD%NumTStC,MaxStC)                       ! in case we have more Nacelle StCs than the outputs are set for
         call Set_TStC_Outs_Instance( i, x(i), m(i), y(i), AllOuts )
      enddo
   endif
end subroutine Set_TStC_Outs
!---------------------------
subroutine Set_TStC_Outs_Instance( i, x, m, y, AllOuts )     ! Tower single StC instance
   integer(IntKi),                  intent(in   )  :: i                    ! This instance
   type(StC_ContinuousStateType),   intent(in   )  :: x                    !< Continuous states at t
   type(StC_MiscVarType),           intent(in   )  :: m                    !< Misc (optimization) variables
   type(StC_OutputType),            intent(in   )  :: y                    !< Outputs computed at Time
   real(ReKi),                      intent(inout)  :: AllOuts(0:MaxOutPts) ! All the available output channels
   integer  :: j
   j=1
   if (i < MaxStC) then
      AllOuts(TStC_XQ( i)) = x%StC_x(1,1)                ! x
      AllOuts(TStC_XQD(i)) = x%StC_x(2,1)                ! x-dot
      AllOuts(TStC_YQ( i)) = x%StC_x(3,1)                ! y
      AllOuts(TStC_YQD(i)) = x%StC_x(4,1)                ! y-dot
      AllOuts(TStC_ZQ( i)) = x%StC_x(5,1)                ! z
      AllOuts(TStC_ZQD(i)) = x%StC_x(6,1)                ! z-dot
      AllOuts(TStC_Fxi(i)) = 0.001*y%Mesh(j)%Force(1,1)  ! only one mesh per TStC instance
      AllOuts(TStC_Fyi(i)) = 0.001*y%Mesh(j)%Force(2,1)  ! only one mesh per TStC instance
      AllOuts(TStC_Fzi(i)) = 0.001*y%Mesh(j)%Force(3,1)  ! only one mesh per TStC instance
      AllOuts(TStC_Mxi(i)) = 0.001*y%Mesh(j)%Moment(1,1) ! only one mesh per TStC instance
      AllOuts(TStC_Myi(i)) = 0.001*y%Mesh(j)%Moment(2,1) ! only one mesh per TStC instance
      AllOuts(TStC_Mzi(i)) = 0.001*y%Mesh(j)%Moment(3,1) ! only one mesh per TStC instance
      AllOuts(TStC_Fxl(i)) = 0.001*m%F_P(1,j)
      AllOuts(TStC_Fyl(i)) = 0.001*m%F_P(2,j)
      AllOuts(TStC_Fzl(i)) = 0.001*m%F_P(3,j)
      AllOuts(TStC_Mxl(i)) = 0.001*m%M_P(1,j)
      AllOuts(TStC_Myl(i)) = 0.001*m%M_P(2,j)
      AllOuts(TStC_Mzl(i)) = 0.001*m%M_P(3,j)
   endif
end subroutine Set_TStC_Outs_Instance
!---------------------------
subroutine Set_BStC_Outs( p_SrvD, x, m, y, AllOuts )        ! Blades
   type(SrvD_ParameterType),                    intent(in   )  :: p_SrvD               !< Parameters
   type(StC_ContinuousStateType),   allocatable,intent(in   )  :: x(:)                 !< Continuous states at t
   type(StC_MiscVarType),           allocatable,intent(in   )  :: m(:)                 !< Misc (optimization) variables
   type(StC_OutputType),            allocatable,intent(in   )  :: y(:)                 !< Outputs computed at Time
   real(ReKi),                                  intent(inout)  :: AllOuts(0:MaxOutPts) ! All the available output channels
   integer  :: i
   if (allocated(x) .and. allocated(m) .and. allocated(y)) then
      do i=1,min(p_SrvD%NumBStC,MaxStC)                         ! in case we have more Blade StCs than the outputs are set for
         call Set_BStC_Outs_Instance( i, p_SrvD%numBl, x(i), m(i), y(i), AllOuts )
      enddo
   endif
end subroutine Set_BStC_Outs
!---------------------------
subroutine Set_BStC_Outs_Instance( i, numBl, x, m, y, AllOuts )        ! Single StC on all blades
   integer(IntKi),                  intent(in   )  :: i                    ! This instance
   integer(IntKi),                  intent(in   )  :: numBl                ! number of blades 
   type(StC_ContinuousStateType),   intent(in   )  :: x                    !< Continuous states at t
   type(StC_MiscVarType),           intent(in   )  :: m                    !< Misc (optimization) variables
   type(StC_OutputType),            intent(in   )  :: y                    !< Outputs computed at Time
   real(ReKi),                      intent(inout)  :: AllOuts(0:MaxOutPts) ! All the available output channels
   integer  :: j
   if (i < MaxStC) then
      do j=1,min(NumBl,MaxBlOuts)
         AllOuts(BStC_XQ( i,j)) = x%StC_x(1,j)                ! x
         AllOuts(BStC_XQD(i,j)) = x%StC_x(2,j)                ! x-dot
         AllOuts(BStC_YQ( i,j)) = x%StC_x(3,j)                ! y
         AllOuts(BStC_YQD(i,j)) = x%StC_x(4,j)                ! y-dot
         AllOuts(BStC_ZQ( i,j)) = x%StC_x(5,j)                ! z
         AllOuts(BStC_ZQD(i,j)) = x%StC_x(6,j)                ! z-dot
         AllOuts(BStC_Fxi(i,j)) = 0.001*y%Mesh(j)%Force(1,1)  ! only one mesh per BStC instance
         AllOuts(BStC_Fyi(i,j)) = 0.001*y%Mesh(j)%Force(2,1)  ! only one mesh per BStC instance
         AllOuts(BStC_Fzi(i,j)) = 0.001*y%Mesh(j)%Force(3,1)  ! only one mesh per BStC instance
         AllOuts(BStC_Mxi(i,j)) = 0.001*y%Mesh(j)%Moment(1,1) ! only one mesh per BStC instance
         AllOuts(BStC_Myi(i,j)) = 0.001*y%Mesh(j)%Moment(2,1) ! only one mesh per BStC instance
         AllOuts(BStC_Mzi(i,j)) = 0.001*y%Mesh(j)%Moment(3,1) ! only one mesh per BStC instance
         AllOuts(BStC_Fxl(i,j)) = 0.001*m%F_P(1,j)
         AllOuts(BStC_Fyl(i,j)) = 0.001*m%F_P(2,j)
         AllOuts(BStC_Fzl(i,j)) = 0.001*m%F_P(3,j)
         AllOuts(BStC_Mxl(i,j)) = 0.001*m%M_P(1,j)
         AllOuts(BStC_Myl(i,j)) = 0.001*m%M_P(2,j)
         AllOuts(BStC_Mzl(i,j)) = 0.001*m%M_P(3,j)
      enddo
   endif
end subroutine Set_BStC_Outs_Instance
!---------------------------
subroutine Set_SStC_Outs( p_SrvD, x, m, y, AllOuts )     ! Platform 
   type(SrvD_ParameterType),                    intent(in   )  :: p_SrvD               !< Parameters
   type(StC_ContinuousStateType),   allocatable,intent(in   )  :: x(:)                 !< Continuous states at t
   type(StC_MiscVarType),           allocatable,intent(in   )  :: m(:)                 !< Misc (optimization) variables
   type(StC_OutputType),            allocatable,intent(in   )  :: y(:)                 !< Outputs computed at Time
   real(ReKi),                                  intent(inout)  :: AllOuts(0:MaxOutPts) ! All the available output channels
   integer  :: i
   if (allocated(x) .and. allocated(m) .and. allocated(y)) then
      do i=1,min(p_SrvD%NumSStC,MaxStC)                       ! in case we have more Nacelle StCs than the outputs are set for
         call Set_SStC_Outs_Instance( i, x(i), m(i), y(i), AllOuts )
      enddo
   endif
end subroutine Set_SStC_Outs
!---------------------------
subroutine Set_SStC_Outs_Instance( i, x, m, y, AllOuts )     ! Platform 
   integer(IntKi),                  intent(in   )  :: i                    ! This instance
   type(StC_ContinuousStateType),   intent(in   )  :: x                 !< Continuous states at t
   type(StC_MiscVarType),           intent(in   )  :: m                 !< Misc (optimization) variables
   type(StC_OutputType),            intent(in   )  :: y                 !< Outputs computed at Time
   real(ReKi),                      intent(inout)  :: AllOuts(0:MaxOutPts) ! All the available output channels
   integer  :: j
   j=1
   if (i < MaxStC) then
      AllOuts(SStC_XQ( i)) = x%StC_x(1,1)                ! x
      AllOuts(SStC_XQD(i)) = x%StC_x(2,1)                ! x-dot
      AllOuts(SStC_YQ( i)) = x%StC_x(3,1)                ! y
      AllOuts(SStC_YQD(i)) = x%StC_x(4,1)                ! y-dot
      AllOuts(SStC_ZQ( i)) = x%StC_x(5,1)                ! z
      AllOuts(SStC_ZQD(i)) = x%StC_x(6,1)                ! z-dot
      AllOuts(SStC_Fxi(i)) = 0.001*y%Mesh(j)%Force(1,1)  ! only one mesh per SStC instance
      AllOuts(SStC_Fyi(i)) = 0.001*y%Mesh(j)%Force(2,1)  ! only one mesh per SStC instance
      AllOuts(SStC_Fzi(i)) = 0.001*y%Mesh(j)%Force(3,1)  ! only one mesh per SStC instance
      AllOuts(SStC_Mxi(i)) = 0.001*y%Mesh(j)%Moment(1,1) ! only one mesh per SStC instance
      AllOuts(SStC_Myi(i)) = 0.001*y%Mesh(j)%Moment(2,1) ! only one mesh per SStC instance
      AllOuts(SStC_Mzi(i)) = 0.001*y%Mesh(j)%Moment(3,1) ! only one mesh per SStC instance
      AllOuts(SStC_Fxl(i)) = 0.001*m%F_P(1,j)
      AllOuts(SStC_Fyl(i)) = 0.001*m%F_P(2,j)
      AllOuts(SStC_Fzl(i)) = 0.001*m%F_P(3,j)
      AllOuts(SStC_Mxl(i)) = 0.001*m%M_P(1,j)
      AllOuts(SStC_Myl(i)) = 0.001*m%M_P(2,j)
      AllOuts(SStC_Mzl(i)) = 0.001*m%M_P(3,j)
   endif
end subroutine Set_SStC_Outs_Instance
!---------------------------

!----------------------------------------------------------------------------------------------------------------------------------
!> This subroutine parses the input file and stores all the data in the SrvD_InputFile structure.
!! It does not perform data validation.
subroutine ParseInputFileInfo( PriPath, InputFile, OutFileRoot, FileInfo_In, InputFileData, Default_DT, ErrStat, ErrMsg )

   implicit    none

      ! Passed variables
   character(*),                    intent(in   )  :: PriPath           ! Path name of the primary file
   character(*),                    intent(in   )  :: InputFile         !< Name of the file containing the primary input data
   character(*),                    intent(in   )  :: OutFileRoot       !< The rootname of the echo file, possibly opened in this routine
   type(SrvD_InputFile),            intent(  out)  :: InputFileData     !< All the data in the StrucCtrl input file
   type(FileInfoType),              intent(in   )  :: FileInfo_In       !< The derived type for holding the file information.
   real(DbKi),                      intent(in   )  :: Default_DT        !< The default DT (from glue code)
   integer(IntKi),                  intent(  out)  :: ErrStat           !< Error status
   character(ErrMsgLen),            intent(  out)  :: ErrMsg            !< Error message

      ! Local variables:
   integer(IntKi)                                  :: i                 !< generic counter
   character(20)                                   :: TmpChr            !< Temporary char array
   integer(IntKi)                                  :: UnEcho
   integer(IntKi)                                  :: ErrStat2          !< Temporary Error status
   character(ErrMsgLen)                            :: ErrMsg2           !< Temporary Error message
   integer(IntKi)                                  :: CurLine           !< current entry in FileInfo_In%Lines array
   real(ReKi)                                      :: TmpRe2(2)         !< temporary 2 number array for reading values in
   character(*), parameter                         :: RoutineName = 'ParseInputFileInfo'


   ! Initialization
   ErrStat  =  ErrID_None
   ErrMsg   =  ""
   UnEcho   = -1     ! Echo file unit.  >0 when used

   call AllocAry( InputFileData%OutList, MaxOutPts, "ServoDyn Input File's Outlist", ErrStat2, ErrMsg2 )
      if (Failed()) return;

      ! Give verbose info on what we are reading
   if (NWTC_VerboseLevel == NWTC_Verbose) THEN
      call WrScr( ' Heading of the ServoDyn input file: ' )      
      call WrScr( '   '//trim( FileInfo_In%Lines(2) ) )
   end if

   !-------------------------------------------------------------------------------------------------
   ! General settings
   !-------------------------------------------------------------------------------------------------
   CurLine = 4    ! Skip the first three lines as they are known to be header lines and separators
   call ParseVar( FileInfo_In, CurLine, 'Echo', InputFileData%Echo, ErrStat2, ErrMsg2 )
         if (Failed()) return;

   if ( InputFileData%Echo ) then
      CALL OpenEcho ( UnEcho, TRIM(OutFileRoot)//'.ech', ErrStat2, ErrMsg2 )
         if (Failed()) return;
      WRITE(UnEcho, '(A)') 'Echo file for ServoDyn input file: '//trim(InputFile)
      ! Write the first three lines into the echo file
      WRITE(UnEcho, '(A)') FileInfo_In%Lines(1)
      WRITE(UnEcho, '(A)') FileInfo_In%Lines(2)
      WRITE(UnEcho, '(A)') FileInfo_In%Lines(3)

      CurLine = 4
      call ParseVar( FileInfo_In, CurLine, 'Echo', InputFileData%Echo, ErrStat2, ErrMsg2, UnEcho )
            if (Failed()) return
   endif

      !  DT - Communication interval for controllers (s) (or "default")
   call ParseVarWDefault ( FileInfo_In, CurLine, 'DT', InputFileData%DT, Default_DT, ErrStat2, ErrMsg2, UnEcho )


   !---------------------- PITCH CONTROL -------------------------------------------
   if ( InputFileData%Echo )   WRITE(UnEcho, '(A)') FileInfo_In%Lines(CurLine)    ! Write section break to echo
   CurLine = CurLine + 1
      !  PCMode (switch) - Pitch control mode { 0: none
      !                                         3: user-defined from routine PitchCntrl,
      !                                         4: user-defined from Simulink/Labview
      !                                         5: user-defined from Bladed-style DLL} (switch)
   call ParseVar( FileInfo_In, CurLine, 'PCMode', InputFileData%PCMode, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
      !  TPCOn          - Time to enable active pitch control (s) [unused when PCMode=0]
   call ParseVar( FileInfo_In, CurLine, 'TPCOn', InputFileData%TPCOn, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;

      !  TPitManS       - Time to start override pitch maneuver for blade 1 and end standard pitch control (s)
   do i=1,size(InputFileData%TPitManS)
      TmpChr='TPitManS('//trim(Num2LStr(i))//')'
      call ParseVar( FileInfo_In, CurLine, trim(TmpChr), InputFileData%TPitManS(i), ErrStat2, ErrMsg2, UnEcho )
         if (Failed())  return;
   enddo

      !  PitManRat      - Pitch rate at which override pitch maneuver heads toward final pitch angle for blade 1 (deg/s)
   do i=1,size(InputFileData%PitManRat)
      TmpChr='PitManRat('//trim(Num2LStr(i))//')'
      call ParseVar( FileInfo_In, CurLine, trim(TmpChr), InputFileData%PitManRat(i), ErrStat2, ErrMsg2, UnEcho )
         if (Failed())  return;
   enddo
   InputFileData%PitManRat = InputFileData%PitManRat*D2R

      !  BlPitchF       - Blade 1 final pitch for pitch maneuvers (degrees)
   do i=1,size(InputFileData%BlPitchF)
      TmpChr='BlPitchF('//trim(Num2LStr(i))//')'
      call ParseVar( FileInfo_In, CurLine, trim(TmpChr), InputFileData%BlPitchF(i), ErrStat2, ErrMsg2, UnEcho )
         if (Failed())  return;
   enddo
   InputFileData%BlPitchF = InputFileData%BlPitchF*D2R


   !---------------------- GENERATOR AND TORQUE CONTROL ----------------------------
   if ( InputFileData%Echo )   WRITE(UnEcho, '(A)') FileInfo_In%Lines(CurLine)    ! Write section break to echo
   CurLine = CurLine + 1
      !  VSContrl (switch) - Variable-speed control mode {
      !                          0: none
      !                          1: simple VS,
      !                          3: user-defined from routine UserVSCont,
      !                          4: user-defined from Simulink/Labview,
      !                          5: user-defined from Bladed-style DLL}
   call ParseVar( FileInfo_In, CurLine, 'VSContrl', InputFileData%VSContrl, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
      !  GenModel       - Generator model {1: simple, 2: Thevenin, 3: user-defined from routine UserGen} (switch) [used only when VSContrl=0]
   call ParseVar( FileInfo_In, CurLine, 'GenModel', InputFileData%GenModel, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
      !  GenEff         - Generator efficiency [ignored by the Thevenin and user-defined generator models] (
   call ParseVar( FileInfo_In, CurLine, 'GenEff', InputFileData%GenEff, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
   InputFileData%GenEff = InputFileData%GenEff*0.01      
      !  GenTiStr       - Method to start the generator {T: timed using TimGenOn, F: generator speed using SpdGenOn} (flag)
   call ParseVar( FileInfo_In, CurLine, 'GenTiStr', InputFileData%GenTiStr, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
      !  GenTiStp       - Method to stop the generator {T: timed using TimGenOf, F: when generator power = 0} (flag)
   call ParseVar( FileInfo_In, CurLine, 'GenTiStp', InputFileData%GenTiStp, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
      !  SpdGenOn       - Generator speed to turn on the generator for a startup (HSS speed) (rpm) [used only when GenTiStr=False]
   call ParseVar( FileInfo_In, CurLine, 'SpdGenOn', InputFileData%SpdGenOn, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
   InputFileData%SpdGenOn = InputFileData%SpdGenOn*RPM2RPS
      !  TimGenOn       - Time to turn on the generator for a startup (s) [used only when GenTiStr=True]
   call ParseVar( FileInfo_In, CurLine, 'TimGenOn', InputFileData%TimGenOn, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
      !  TimGenOf       - Time to turn off the generator (s) [used only when GenTiStp=True]
   call ParseVar( FileInfo_In, CurLine, 'TimGenOf', InputFileData%TimGenOf, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;


   !---------------------- SIMPLE VARIABLE-SPEED TORQUE CONTROL --------------------
   if ( InputFileData%Echo )   WRITE(UnEcho, '(A)') FileInfo_In%Lines(CurLine)    ! Write section break to echo
   CurLine = CurLine + 1
      !  VS_RtGnSp      - Rated generator speed for simple variable-speed generator control (HSS side) (rpm) [used only when VSContrl=1]
   call ParseVar( FileInfo_In, CurLine, 'VS_RtGnSp', InputFileData%VS_RtGnSp, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
   InputFileData%VS_RtGnSp = InputFileData%VS_RtGnSp*RPM2RPS
      !  VS_RtTq        - Rated generator torque/constant generator torque in Region 3 for simple variable-speed generator control (HSS side) (N-m) [used only when VSContrl=1]
   call ParseVar( FileInfo_In, CurLine, 'VS_RtTq', InputFileData%VS_RtTq, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
      !  VS_Rgn2K       - Generator torque constant in Region 2 for simple variable-speed generator control (HSS side) (N-m/rpm^2) [used only when VSContrl=1]
   call ParseVar( FileInfo_In, CurLine, 'VS_Rgn2K', InputFileData%VS_Rgn2K, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
   InputFileData%VS_Rgn2K = InputFileData%VS_Rgn2K/( RPM2RPS**2 )
      !  VS_SlPc        - Rated generator slip percentage in Region 2 1/2 for simple variable-speed generator control (
   call ParseVar( FileInfo_In, CurLine, 'VS_SlPc', InputFileData%VS_SlPc, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
   InputFileData%VS_SlPc = InputFileData%VS_SlPc*.01


   !---------------------- SIMPLE INDUCTION GENERATOR ------------------------------
   if ( InputFileData%Echo )   WRITE(UnEcho, '(A)') FileInfo_In%Lines(CurLine)    ! Write section break to echo
   CurLine = CurLine + 1
      !  SIG_SlPc       - Rated generator slip percentage (
   call ParseVar( FileInfo_In, CurLine, 'SIG_SlPc', InputFileData%SIG_SlPc, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
   InputFileData%SIG_SlPc = InputFileData%SIG_SlPc*.01
      !  SIG_SySp       - Synchronous (zero-torque) generator speed (rpm) [used only when VSContrl=0 and GenModel=1]
   call ParseVar( FileInfo_In, CurLine, 'SIG_SySp', InputFileData%SIG_SySp, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
   InputFileData%SIG_SySp = InputFileData%SIG_SySp*RPM2RPS  
      !  SIG_RtTq       - Rated torque (N-m) [used only when VSContrl=0 and GenModel=1]
   call ParseVar( FileInfo_In, CurLine, 'SIG_RtTq', InputFileData%SIG_RtTq, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
      !  SIG_PORt       - Pull-out ratio (Tpullout/Trated) (-) [used only when VSContrl=0 and GenModel=1]
   call ParseVar( FileInfo_In, CurLine, 'SIG_PORt', InputFileData%SIG_PORt, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;


   !---------------------- THEVENIN-EQUIVALENT INDUCTION GENERATOR -----------------
   if ( InputFileData%Echo )   WRITE(UnEcho, '(A)') FileInfo_In%Lines(CurLine)    ! Write section break to echo
   CurLine = CurLine + 1
      !  TEC_Freq       - Line frequency [50 or 60] (Hz) [used only when VSContrl=0 and GenModel=2]
   call ParseVar( FileInfo_In, CurLine, 'TEC_Freq', InputFileData%TEC_Freq, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
      !  TEC_NPol       - Number of poles [even integer > 0] (-) [used only when VSContrl=0 and GenModel=2]
   call ParseVar( FileInfo_In, CurLine, 'TEC_NPol', InputFileData%TEC_NPol, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
      !  TEC_SRes       - Stator resistance (ohms) [used only when VSContrl=0 and GenModel=2]
   call ParseVar( FileInfo_In, CurLine, 'TEC_SRes', InputFileData%TEC_SRes, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
      !  TEC_RRes       - Rotor resistance (ohms) [used only when VSContrl=0 and GenModel=2]
   call ParseVar( FileInfo_In, CurLine, 'TEC_RRes', InputFileData%TEC_RRes, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
      !  TEC_VLL        - Line-to-line RMS voltage (volts) [used only when VSContrl=0 and GenModel=2]
   call ParseVar( FileInfo_In, CurLine, 'TEC_VLL', InputFileData%TEC_VLL, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
      !  TEC_SLR        - Stator leakage reactance (ohms) [used only when VSContrl=0 and GenModel=2]
   call ParseVar( FileInfo_In, CurLine, 'TEC_SLR', InputFileData%TEC_SLR, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
      !  TEC_RLR        - Rotor leakage reactance (ohms) [used only when VSContrl=0 and GenModel=2]
   call ParseVar( FileInfo_In, CurLine, 'TEC_RLR', InputFileData%TEC_RLR, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
      !  TEC_MR         - Magnetizing reactance (ohms) [used only when VSContrl=0 and GenModel=2]
   call ParseVar( FileInfo_In, CurLine, 'TEC_MR', InputFileData%TEC_MR, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;


   !---------------------- HIGH-SPEED SHAFT BRAKE ----------------------------------
   if ( InputFileData%Echo )   WRITE(UnEcho, '(A)') FileInfo_In%Lines(CurLine)    ! Write section break to echo
   CurLine = CurLine + 1
      !  HSSBrMode (switch)   - HSS brake model {
      !                             0: none,
      !                             1: simple,
      !                             3: user-defined from routine UserHSSBr,
      !                             4: user-defined from Simulink/Labview,
      !                             5: user-defined from Bladed-style DLL}
   call ParseVar( FileInfo_In, CurLine, 'HSSBrMode', InputFileData%HSSBrMode, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
      !  THSSBrDp   - Time to initiate deployment of the HSS brake (s)
   call ParseVar( FileInfo_In, CurLine, 'THSSBrDp', InputFileData%THSSBrDp, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
      !  HSSBrDT   - Time for HSS-brake to reach full deployment once initiated (sec) [used only when HSSBrMode=1]
   call ParseVar( FileInfo_In, CurLine, 'HSSBrDT', InputFileData%HSSBrDT, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
      !  HSSBrTqF   - Fully deployed HSS-brake torque (N-m)
   call ParseVar( FileInfo_In, CurLine, 'HSSBrTqF', InputFileData%HSSBrTqF, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;


   !---------------------- YAW CONTROL ---------------------------------------------
   if ( InputFileData%Echo )   WRITE(UnEcho, '(A)') FileInfo_In%Lines(CurLine)    ! Write section break to echo
   CurLine = CurLine + 1
      !  YCMode (switch)   - Yaw control mode {
      !                             0: none,
      !                             3: user-defined from routine UserYawCont,
      !                             4: user-defined from Simulink/Labview,
      !                             5: user-defined from Bladed-style DLL}
   call ParseVar( FileInfo_In, CurLine, 'YCMode', InputFileData%YCMode, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
      !  TYCOn  - Time to enable active yaw control (s) [unused when YCMode=0]
   call ParseVar( FileInfo_In, CurLine, 'TYCOn', InputFileData%TYCOn, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
      !  YawNeut  - Neutral yaw position--yaw spring force is zero at this yaw (degrees)
   call ParseVar( FileInfo_In, CurLine, 'YawNeut', InputFileData%YawNeut, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
   InputFileData%YawNeut = InputFileData%YawNeut*D2R
      !  YawSpr  - Nacelle-yaw spring constant (N-m/rad)
   call ParseVar( FileInfo_In, CurLine, 'YawSpr', InputFileData%YawSpr, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
      !  YawDamp  - Nacelle-yaw damping constant (N-m/(rad/s))
   call ParseVar( FileInfo_In, CurLine, 'YawDamp', InputFileData%YawDamp, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
      !  TYawManS  - Time to start override yaw maneuver and end standard yaw control (s)
   call ParseVar( FileInfo_In, CurLine, 'TYawManS', InputFileData%TYawManS, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
      !  YawManRat  - Yaw maneuver rate (in absolute value) (deg/s)
   call ParseVar( FileInfo_In, CurLine, 'YawManRat', InputFileData%YawManRat, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
   InputFileData%YawManRat = InputFileData%YawManRat*D2R
      !  NacYawF  - Final yaw angle for override yaw maneuvers (degrees)
   call ParseVar( FileInfo_In, CurLine, 'NacYawF', InputFileData%NacYawF, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
   InputFileData%NacYawF = InputFileData%NacYawF*D2R


   !---------------------- Aerodynamic Flow Control --------------------------------
   if ( InputFileData%Echo )   WRITE(UnEcho, '(A)') FileInfo_In%Lines(CurLine)    ! Write section break to echo
   CurLine = CurLine + 1
      ! AfCmode - Airfoil control mode {
      !                       0: none
      !                       1: cosine wave cycle
      !                       4: user-defined from Simulink/Labview
      !                       5: user-defined from Bladed-style DLL}
   call ParseVar( FileInfo_In, CurLine, 'AfCmode', InputFileData%AfCmode, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
      ! AfC_Mean - Mean level for sinusoidal cycling or steady value (-) [used only with AfCmode==1]
   call ParseVar( FileInfo_In, CurLine, 'AfC_Mean', InputFileData%AfC_mean, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
      ! AfC_amplitude - Amplitude for for cosine cycling of flap signal (AfC = AfC_Amp*cos(Azimuth+phase)+AfC_mean) (-) [used only with AfCmode==1]
   call ParseVar( FileInfo_In, CurLine, 'AfC_Amp', InputFileData%AfC_Amp, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
      ! AfC_phase - Phase relative to the blade azimuth (0 is vertical) for for cosine cycling of flap signal (deg) [used only with AfCmode==1]
   call ParseVar( FileInfo_In, CurLine, 'AfC_Phase', InputFileData%AfC_Phase, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
   InputFileData%AfC_phase = InputFileData%AfC_phase*D2R


   !---------------------- TUNED MASS DAMPER ----------------------------------------         
   if ( InputFileData%Echo )   WRITE(UnEcho, '(A)') FileInfo_In%Lines(CurLine)    ! Write section break to echo
   CurLine = CurLine + 1
      !  NumBStC      - Number of blade structural controllers (integer)
   call ParseVar( FileInfo_In, CurLine, 'NumBStC', InputFileData%NumBStC, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
      !  BStCfiles    - Name of the files for blade structural controllers (quoted strings) [unused when NumBStC==0]
   call AllocAry( InputFileData%BStCfiles, InputFileData%NumBStC, 'BStCfile', ErrStat2, ErrMsg2 )
      if (Failed())  return;
   call ParseAry( FileInfo_In, CurLine, 'BStCfile', InputFileData%BStCfiles, InputFileData%NumBStC, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
   do i=1,InputFileData%NumBStC
      if ( PathIsRelative( InputFileData%BStCfiles(i) ) ) InputFileData%BStCfiles(i) = TRIM(PriPath)//TRIM(InputFileData%BStCfiles(i))   
   enddo

      !  NumNStC      - Number of nacelle structural controllers (integer)
   call ParseVar( FileInfo_In, CurLine, 'NumNStC', InputFileData%NumNStC, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
      !  NStCfiles    - Name of the files for nacelle structural controllers (quoted strings) [unused when NumNStC==0]
   call AllocAry( InputFileData%NStCfiles, InputFileData%NumNStC, 'NStCfile', ErrStat2, ErrMsg2 )
      if (Failed())  return;
   call ParseAry( FileInfo_In, CurLine, 'NStCfile', InputFileData%NStCfiles, InputFileData%NumNStC, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
   do i=1,InputFileData%NumNStC
      if ( PathIsRelative( InputFileData%NStCfiles(i) ) ) InputFileData%NStCfiles(i) = TRIM(PriPath)//TRIM(InputFileData%NStCfiles(i))   
   enddo

      !  NumTStC      - Number of tower structural controllers (integer)
   call ParseVar( FileInfo_In, CurLine, 'NumTStC', InputFileData%NumTStC, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
      !  TStCfiles    - Name of the files for tower structural controllers (quoted strings) [unused when NumTStC==0]
   call AllocAry( InputFileData%TStCfiles, InputFileData%NumTStC, 'TStCfile', ErrStat2, ErrMsg2 )
      if (Failed())  return;
   call ParseAry( FileInfo_In, CurLine, 'TStCfile', InputFileData%TStCfiles, InputFileData%NumTStC, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
   do i=1,InputFileData%NumTStC
      if ( PathIsRelative( InputFileData%TStCfiles(i) ) ) InputFileData%TStCfiles(i) = TRIM(PriPath)//TRIM(InputFileData%TStCfiles(i))   
   enddo

      !  NumSStC   - Number of platform structural controllers (integer)
   call ParseVar( FileInfo_In, CurLine, 'NumSStC', InputFileData%NumSStC, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
      !  SStCfiles - Name of the files for blade structural controllers (quoted strings) [unused when NumSStC==0]
   call AllocAry( InputFileData%SStCfiles, InputFileData%NumSStC, 'SStCfile', ErrStat2, ErrMsg2 )
      if (Failed())  return;
   call ParseAry( FileInfo_In, CurLine, 'SStCfile', InputFileData%SStCfiles, InputFileData%NumSStC, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
   do i=1,InputFileData%NumSStC
      if ( PathIsRelative( InputFileData%SStCfiles(i) ) ) InputFileData%SStCfiles(i) = TRIM(PriPath)//TRIM(InputFileData%SStCfiles(i))   
   enddo


   !---------------------- Cable Control -------------------------------------------
   if ( InputFileData%Echo )   WRITE(UnEcho, '(A)') FileInfo_In%Lines(CurLine)    ! Write section break to echo
   CurLine = CurLine + 1
      ! CCmode - Cable control mode {
      !                       0: none
      !                       4: user-defined from Simulink/Labview
      !                       5: user-defined from Bladed-style DLL}
   call ParseVar( FileInfo_In, CurLine, 'CCmode', InputFileData%CCmode, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;


   !---------------------- BLADED INTERFACE ----------------------------------------         
   if ( InputFileData%Echo )   WRITE(UnEcho, '(A)') FileInfo_In%Lines(CurLine)    ! Write section break to echo
   CurLine = CurLine + 1
      !  DLL_FileName  - Name/location of the dynamic library {.dll [Windows] or .so [Linux]} in the Bladed-DLL format (-) [used only with Bladed Interface]
   call ParseVar( FileInfo_In, CurLine, 'DLL_FileName', InputFileData%DLL_FileName, ErrStat2, ErrMsg2, UnEcho, IsPath=.true. )
      if (Failed())  return;
   IF ( PathIsRelative( InputFileData%DLL_FileName ) ) InputFileData%DLL_FileName = TRIM(PriPath)//TRIM(InputFileData%DLL_FileName)
      !  DLL_InFile  - Name of input file sent to the DLL (-) [used only with Bladed Interface]
   call ParseVar( FileInfo_In, CurLine, 'DLL_InFile', InputFileData%DLL_InFile, ErrStat2, ErrMsg2, UnEcho, IsPath=.true. )
      if (Failed())  return;
   IF ( PathIsRelative( InputFileData%DLL_InFile ) ) InputFileData%DLL_InFile = TRIM(PriPath)//TRIM(InputFileData%DLL_InFile)   
      !  DLL_ProcName  - Name of procedure in DLL to be called (-) [case sensitive; used only with DLL Interface]
   call ParseVar( FileInfo_In, CurLine, 'DLL_ProcName', InputFileData%DLL_ProcName, ErrStat2, ErrMsg2, UnEcho, IsPath=.true. )
      if (Failed())  return;
      !  DLL_DT  - Communication interval for dynamic library (s) (or "default") [used only with Bladed Interface]
   call ParseVarWDefault( FileInfo_In, CurLine, 'DLL_DT', InputFileData%DLL_DT, InputFileData%DT, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
      !  DLL_Ramp  - Whether a linear ramp should be used between DLL_DT time steps [introduces time shift when true] (flag) [used only with Bladed Interface]
   call ParseVar( FileInfo_In, CurLine, 'DLL_Ramp', InputFileData%DLL_Ramp, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
      !  BPCutoff  - Cuttoff frequency for low-pass filter on blade pitch from DLL (Hz) [used only with Bladed Interface]
   call ParseVar( FileInfo_In, CurLine, 'BPCutoff', InputFileData%BPCutoff, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
!      !  EXavrSWAP - Use extended avrSWAP with Records 1000-3500 (flag) [may not be compatible with all controllers]
!   call ParseVar( FileInfo_In, CurLine, 'EXavrSWAP', InputFileData%EXavrSWAP, ErrStat2, ErrMsg2, UnEcho )
   InputFileData%EXavrSWAP = .TRUE.    ! Hard coding this, but leaving this read in case we want to enable control of this later
      if (Failed())  return;
      !  NacYaw_North  - Reference yaw angle of the nacelle when the upwind end points due North (deg) [used only with Bladed Interface]
   call ParseVar( FileInfo_In, CurLine, 'NacYaw_North', InputFileData%NacYaw_North, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
   InputFileData%NacYaw_North = InputFileData%NacYaw_North*D2R
      !  Ptch_Cntrl  - Record 28: Use individual pitch control {0: collective pitch; 1: individual pitch control} (switch) [used only with Bladed Interface]
   call ParseVar( FileInfo_In, CurLine, 'Ptch_Cntrl', InputFileData%Ptch_Cntrl, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
      !  Ptch_SetPnt  - Record  5: Below-rated pitch angle set-point (deg) [used only with Bladed Interface]
   call ParseVar( FileInfo_In, CurLine, 'Ptch_SetPnt', InputFileData%Ptch_SetPnt, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
   InputFileData%Ptch_SetPnt = InputFileData%Ptch_SetPnt*D2R
      !  Ptch_Min  - Record  6: Minimum pitch angle (deg) [used only with Bladed Interface]
   call ParseVar( FileInfo_In, CurLine, 'Ptch_Min', InputFileData%Ptch_Min, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
   InputFileData%Ptch_Min = InputFileData%Ptch_Min*D2R
      !  Ptch_Max  - Record  7: Maximum pitch angle (deg) [used only with Bladed Interface]
   call ParseVar( FileInfo_In, CurLine, 'Ptch_Max', InputFileData%Ptch_Max, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
   InputFileData%Ptch_Max = InputFileData%Ptch_Max*D2R
      !  PtchRate_Min  - Record  8: Minimum pitch rate (most negative value allowed) (deg/s) [used only with Bladed Interface]
   call ParseVar( FileInfo_In, CurLine, 'PtchRate_Min', InputFileData%PtchRate_Min, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
   InputFileData%PtchRate_Min = InputFileData%PtchRate_Min*D2R
      !  PtchRate_Max  - Record  9: Maximum pitch rate  (deg/s) [used only with Bladed Interface]
   call ParseVar( FileInfo_In, CurLine, 'PtchRate_Max', InputFileData%PtchRate_Max, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
   InputFileData%PtchRate_Max = InputFileData%PtchRate_Max*D2R
      !  Gain_OM  - Record 16: Optimal mode gain (Nm/(rad/s)^2) [used only with Bladed Interface]
   call ParseVar( FileInfo_In, CurLine, 'Gain_OM', InputFileData%Gain_OM, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
      !  GenSpd_MinOM  - Record 17: Minimum generator speed (rpm) [used only with Bladed Interface]
   call ParseVar( FileInfo_In, CurLine, 'GenSpd_MinOM', InputFileData%GenSpd_MinOM, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
   InputFileData%GenSpd_MinOM = InputFileData%GenSpd_MinOM*RPM2RPS
      !  GenSpd_MaxOM  - Record 18: Optimal mode maximum speed (rpm) [used only with Bladed Interface]
   call ParseVar( FileInfo_In, CurLine, 'GenSpd_MaxOM', InputFileData%GenSpd_MaxOM, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
   InputFileData%GenSpd_MaxOM = InputFileData%GenSpd_MaxOM*RPM2RPS
      !  GenSpd_Dem  - Record 19: Demanded generator speed above rated (rpm) [used only with Bladed Interface]
   call ParseVar( FileInfo_In, CurLine, 'GenSpd_Dem', InputFileData%GenSpd_Dem, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
   InputFileData%GenSpd_Dem = InputFileData%GenSpd_Dem*RPM2RPS
      !  GenTrq_Dem  - Record 22: Demanded generator torque above rated (Nm) [used only with Bladed Interface]
   call ParseVar( FileInfo_In, CurLine, 'GenTrq_Dem', InputFileData%GenTrq_Dem, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
      !  GenPwr_Dem  - Record 13: Demanded power (W) [used only with Bladed Interface]
   call ParseVar( FileInfo_In, CurLine, 'GenPwr_Dem', InputFileData%GenPwr_Dem, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;


   !---------------------- BLADED INTERFACE TORQUE-SPEED LOOK-UP TABLE -------------         
   if ( InputFileData%Echo )   WRITE(UnEcho, '(A)') FileInfo_In%Lines(CurLine)    ! Write section break to echo
   CurLine = CurLine + 1
      ! NKInpSt      - Number of spring force input stations
   call ParseVar( FileInfo_In, CurLine, 'DLL_NumTrq', InputFileData%DLL_NumTrq, ErrStat2, ErrMsg2, UnEcho)
         if (Failed()) return
   ! Section break --  GenSpd_TLU   GenTrq_TLU
   if ( InputFileData%Echo )   WRITE(UnEcho, '(A)') ' Table Header: '//FileInfo_In%Lines(CurLine)    ! Write section break to echo
   CurLine = CurLine + 1
   if ( InputFileData%Echo )   WRITE(UnEcho, '(A)') ' Table Units: '//FileInfo_In%Lines(CurLine)    ! Write section break to echo
   CurLine = CurLine + 1

   if (InputFileData%DLL_NumTrq > 0) then
      CALL AllocAry( InputFileData%GenSpd_TLU,   InputFileData%DLL_NumTrq, 'GenSpd_TLU', ErrStat2, ErrMsg2 )
            if (Failed()) return;
      CALL AllocAry( InputFileData%GenTrq_TLU,   InputFileData%DLL_NumTrq, 'GenTrq_TLU',ErrStat2, ErrMsg2 )
            if (Failed()) return;
         ! TABLE read
      do i=1,InputFileData%DLL_NumTrq
         call ParseAry ( FileInfo_In, CurLine, 'Coordinates', TmpRe2, 2, ErrStat2, ErrMsg2, UnEcho )
               if (Failed()) return;
         InputFileData%GenSpd_TLU(i) = TmpRe2(1)*RPM2RPS  ! GenSpd_TLU - Records R:2:R+2*DLL_NumTrq-2: Generator speed values in look-up table (rpm) (read from file in rpm and converted to rad/s here)
         InputFileData%GenTrq_TLU(i) = TmpRe2(2)          ! GenTrq_TLU - Records R+1:2:R+2*DLL_NumTrq-1: Generator torque values in look-up table (Nm)
      enddo
   endif


   !---------------------- OUTPUT --------------------------------------------------         
   if ( InputFileData%Echo )   WRITE(UnEcho, '(A)') FileInfo_In%Lines(CurLine)    ! Write section break to echo
   CurLine = CurLine + 1
      !  SumPrint  - Print summary data to <RootName>.sum (flag) (currently unused)
   call ParseVar( FileInfo_In, CurLine, 'SumPrint', InputFileData%SumPrint, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
      !  OutFile  - Switch to determine where output will be placed: {1: in module output file only; 2: in glue code output file only; 3: both} (currently unused)
   call ParseVar( FileInfo_In, CurLine, 'OutFile', InputFileData%OutFile, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
   !PLACEHOLDER: OutFileFmt - Format for module tabular (time-marching) output: (1: text file [<RootName>.out], 2: binary file [<RootName>.outb], 3: both):
      !  TabDelim  - Use tab delimiters in text tabular output file? (flag) (currently unused)
   call ParseVar( FileInfo_In, CurLine, 'TabDelim', InputFileData%TabDelim, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
      !  OutFmt  - Format used for text tabular output (except time).  Resulting field should be 10 characters. (quoted string) (currently unused)
   call ParseVar( FileInfo_In, CurLine, 'OutFmt', InputFileData%OutFmt, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
      !  TStart  - Time to begin tabular output (s) (currently unused)
   call ParseVar( FileInfo_In, CurLine, 'TStart', InputFileData%TStart, ErrStat2, ErrMsg2, UnEcho )
      if (Failed())  return;
   !PLACEHOLDER: DecFact - Decimation factor for module's tabular output (1=output every step) (-):

   !---------------------- OUTLIST  --------------------------------------------
   if ( InputFileData%Echo )   WRITE(UnEcho, '(A)') FileInfo_In%Lines(CurLine)    ! Write section break to echo
   CurLine = CurLine + 1
   call ReadOutputListFromFileInfo( FileInfo_In, CurLine, InputFileData%OutList, InputFileData%NumOuts, ErrStat2, ErrMsg2, UnEcho )
         if (Failed()) return;


   call Cleanup()
   return

contains
   !-------------------------------------------------------------------------------------------------
   logical function Failed()
      CALL SetErrStat( ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName )
      Failed = ErrStat >= AbortErrLev
      ! This fixes a strange compile issue with gfortran 9.1.0 on Mac where the CurLine and ErrStat end up sharing stack
      ! space due to the -fstack_reuse="all" is set for any optimization.  Can workaround with -fstack_reuse="none", but
      ! have not found any other viable workaround other than using CurLine here in the Failed function
      CurLine = CurLine
      if (Failed) call Cleanup()
   end function Failed
   !-------------------------------------------------------------------------------------------------
   subroutine Cleanup()
      if (UnEcho  > -1_IntKi)     CLOSE( UnEcho  )
   end subroutine Cleanup
end subroutine ParseInputFileInfo
!----------------------------------------------------------------------------------------------------------------------------------



!**********************************************************************************************************************************
! NOTE: The following lines of code were generated by a Matlab script called "Write_ChckOutLst.m"
!      using the parameters listed in the "OutListParameters.xlsx" Excel file. Any changes to these 
!      lines should be modified in the Matlab script and/or Excel worksheet as necessary. 
!----------------------------------------------------------------------------------------------------------------------------------
!> This routine checks to see if any requested output channel names (stored in the OutList(:)) are invalid. It returns a 
!! warning if any of the channels are not available outputs from the module.
!!  It assigns the settings for OutParam(:) (i.e, the index, name, and units of the output channels, WriteOutput(:)).
!!  the sign is set to 0 if the channel is invalid.
!! It sets assumes the value p%NumOuts has been set before this routine has been called, and it sets the values of p%OutParam here.
!! 
!! This routine was generated by Write_ChckOutLst.m using the parameters listed in OutListParameters.xlsx at 04-Feb-2021 08:42:27.
SUBROUTINE SetOutParam(OutList, p, ErrStat, ErrMsg )
!..................................................................................................................................

   IMPLICIT                        NONE

      ! Passed variables

   CHARACTER(ChanLen),        INTENT(IN)     :: OutList(:)                        !< The list out user-requested outputs
   TYPE(SrvD_ParameterType),    INTENT(INOUT)  :: p                                 !< The module parameters
   INTEGER(IntKi),            INTENT(OUT)    :: ErrStat                           !< The error status code
   CHARACTER(*),              INTENT(OUT)    :: ErrMsg                            !< The error message, if an error occurred

      ! Local variables

   INTEGER                      :: ErrStat2                                        ! temporary (local) error status
   INTEGER                      :: I                                               ! Generic loop-counting index
   INTEGER                      :: J                                               ! Generic loop-counting index
   INTEGER                      :: INDX                                            ! Index for valid arrays

   LOGICAL                      :: CheckOutListAgain                               ! Flag used to determine if output parameter starting with "M" is valid (or the negative of another parameter)
   LOGICAL                      :: InvalidOutput(0:MaxOutPts)                      ! This array determines if the output channel is valid for this configuration
   CHARACTER(ChanLen)           :: OutListTmp                                      ! A string to temporarily hold OutList(I)
   CHARACTER(*), PARAMETER      :: RoutineName = "SetOutParam"

   CHARACTER(OutStrLenM1), PARAMETER  :: ValidParamAry(518) =  (/  &   ! This lists the names of the allowed parameters, which must be sorted alphabetically
                               "BLAIRFLC1   ","BLAIRFLC2   ","BLAIRFLC3   ","BLFLAP1     ","BLFLAP2     ","BLFLAP3     ", &
                               "BLPITCHC1   ","BLPITCHC2   ","BLPITCHC3   ","BSTC1_B1_FXI","BSTC1_B1_FXL","BSTC1_B1_FYI", &
                               "BSTC1_B1_FYL","BSTC1_B1_FZI","BSTC1_B1_FZL","BSTC1_B1_MXI","BSTC1_B1_MXL","BSTC1_B1_MYI", &
                               "BSTC1_B1_MYL","BSTC1_B1_MZI","BSTC1_B1_MZL","BSTC1_B1_XQ ","BSTC1_B1_XQD","BSTC1_B1_YQ ", &
                               "BSTC1_B1_YQD","BSTC1_B1_ZQ ","BSTC1_B1_ZQD","BSTC1_B2_FXI","BSTC1_B2_FXL","BSTC1_B2_FYI", &
                               "BSTC1_B2_FYL","BSTC1_B2_FZI","BSTC1_B2_FZL","BSTC1_B2_MXI","BSTC1_B2_MXL","BSTC1_B2_MYI", &
                               "BSTC1_B2_MYL","BSTC1_B2_MZI","BSTC1_B2_MZL","BSTC1_B2_XQ ","BSTC1_B2_XQD","BSTC1_B2_YQ ", &
                               "BSTC1_B2_YQD","BSTC1_B2_ZQ ","BSTC1_B2_ZQD","BSTC1_B3_FXI","BSTC1_B3_FXL","BSTC1_B3_FYI", &
                               "BSTC1_B3_FYL","BSTC1_B3_FZI","BSTC1_B3_FZL","BSTC1_B3_MXI","BSTC1_B3_MXL","BSTC1_B3_MYI", &
                               "BSTC1_B3_MYL","BSTC1_B3_MZI","BSTC1_B3_MZL","BSTC1_B3_XQ ","BSTC1_B3_XQD","BSTC1_B3_YQ ", &
                               "BSTC1_B3_YQD","BSTC1_B3_ZQ ","BSTC1_B3_ZQD","BSTC1_B4_FXI","BSTC1_B4_FXL","BSTC1_B4_FYI", &
                               "BSTC1_B4_FYL","BSTC1_B4_FZI","BSTC1_B4_FZL","BSTC1_B4_MXI","BSTC1_B4_MXL","BSTC1_B4_MYI", &
                               "BSTC1_B4_MYL","BSTC1_B4_MZI","BSTC1_B4_MZL","BSTC1_B4_XQ ","BSTC1_B4_XQD","BSTC1_B4_YQ ", &
                               "BSTC1_B4_YQD","BSTC1_B4_ZQ ","BSTC1_B4_ZQD","BSTC2_B1_FXI","BSTC2_B1_FXL","BSTC2_B1_FYI", &
                               "BSTC2_B1_FYL","BSTC2_B1_FZI","BSTC2_B1_FZL","BSTC2_B1_MXI","BSTC2_B1_MXL","BSTC2_B1_MYI", &
                               "BSTC2_B1_MYL","BSTC2_B1_MZI","BSTC2_B1_MZL","BSTC2_B1_XQ ","BSTC2_B1_XQD","BSTC2_B1_YQ ", &
                               "BSTC2_B1_YQD","BSTC2_B1_ZQ ","BSTC2_B1_ZQD","BSTC2_B2_FXI","BSTC2_B2_FXL","BSTC2_B2_FYI", &
                               "BSTC2_B2_FYL","BSTC2_B2_FZI","BSTC2_B2_FZL","BSTC2_B2_MXI","BSTC2_B2_MXL","BSTC2_B2_MYI", &
                               "BSTC2_B2_MYL","BSTC2_B2_MZI","BSTC2_B2_MZL","BSTC2_B2_XQ ","BSTC2_B2_XQD","BSTC2_B2_YQ ", &
                               "BSTC2_B2_YQD","BSTC2_B2_ZQ ","BSTC2_B2_ZQD","BSTC2_B3_FXI","BSTC2_B3_FXL","BSTC2_B3_FYI", &
                               "BSTC2_B3_FYL","BSTC2_B3_FZI","BSTC2_B3_FZL","BSTC2_B3_MXI","BSTC2_B3_MXL","BSTC2_B3_MYI", &
                               "BSTC2_B3_MYL","BSTC2_B3_MZI","BSTC2_B3_MZL","BSTC2_B3_XQ ","BSTC2_B3_XQD","BSTC2_B3_YQ ", &
                               "BSTC2_B3_YQD","BSTC2_B3_ZQ ","BSTC2_B3_ZQD","BSTC2_B4_FXI","BSTC2_B4_FXL","BSTC2_B4_FYI", &
                               "BSTC2_B4_FYL","BSTC2_B4_FZI","BSTC2_B4_FZL","BSTC2_B4_MXI","BSTC2_B4_MXL","BSTC2_B4_MYI", &
                               "BSTC2_B4_MYL","BSTC2_B4_MZI","BSTC2_B4_MZL","BSTC2_B4_XQ ","BSTC2_B4_XQD","BSTC2_B4_YQ ", &
                               "BSTC2_B4_YQD","BSTC2_B4_ZQ ","BSTC2_B4_ZQD","BSTC3_B1_FXI","BSTC3_B1_FXL","BSTC3_B1_FYI", &
                               "BSTC3_B1_FYL","BSTC3_B1_FZI","BSTC3_B1_FZL","BSTC3_B1_MXI","BSTC3_B1_MXL","BSTC3_B1_MYI", &
                               "BSTC3_B1_MYL","BSTC3_B1_MZI","BSTC3_B1_MZL","BSTC3_B1_XQ ","BSTC3_B1_XQD","BSTC3_B1_YQ ", &
                               "BSTC3_B1_YQD","BSTC3_B1_ZQ ","BSTC3_B1_ZQD","BSTC3_B2_FXI","BSTC3_B2_FXL","BSTC3_B2_FYI", &
                               "BSTC3_B2_FYL","BSTC3_B2_FZI","BSTC3_B2_FZL","BSTC3_B2_MXI","BSTC3_B2_MXL","BSTC3_B2_MYI", &
                               "BSTC3_B2_MYL","BSTC3_B2_MZI","BSTC3_B2_MZL","BSTC3_B2_XQ ","BSTC3_B2_XQD","BSTC3_B2_YQ ", &
                               "BSTC3_B2_YQD","BSTC3_B2_ZQ ","BSTC3_B2_ZQD","BSTC3_B3_FXI","BSTC3_B3_FXL","BSTC3_B3_FYI", &
                               "BSTC3_B3_FYL","BSTC3_B3_FZI","BSTC3_B3_FZL","BSTC3_B3_MXI","BSTC3_B3_MXL","BSTC3_B3_MYI", &
                               "BSTC3_B3_MYL","BSTC3_B3_MZI","BSTC3_B3_MZL","BSTC3_B3_XQ ","BSTC3_B3_XQD","BSTC3_B3_YQ ", &
                               "BSTC3_B3_YQD","BSTC3_B3_ZQ ","BSTC3_B3_ZQD","BSTC3_B4_FXI","BSTC3_B4_FXL","BSTC3_B4_FYI", &
                               "BSTC3_B4_FYL","BSTC3_B4_FZI","BSTC3_B4_FZL","BSTC3_B4_MXI","BSTC3_B4_MXL","BSTC3_B4_MYI", &
                               "BSTC3_B4_MYL","BSTC3_B4_MZI","BSTC3_B4_MZL","BSTC3_B4_XQ ","BSTC3_B4_XQD","BSTC3_B4_YQ ", &
                               "BSTC3_B4_YQD","BSTC3_B4_ZQ ","BSTC3_B4_ZQD","BSTC4_B1_FXI","BSTC4_B1_FXL","BSTC4_B1_FYI", &
                               "BSTC4_B1_FYL","BSTC4_B1_FZI","BSTC4_B1_FZL","BSTC4_B1_MXI","BSTC4_B1_MXL","BSTC4_B1_MYI", &
                               "BSTC4_B1_MYL","BSTC4_B1_MZI","BSTC4_B1_MZL","BSTC4_B1_XQ ","BSTC4_B1_XQD","BSTC4_B1_YQ ", &
                               "BSTC4_B1_YQD","BSTC4_B1_ZQ ","BSTC4_B1_ZQD","BSTC4_B2_FXI","BSTC4_B2_FXL","BSTC4_B2_FYI", &
                               "BSTC4_B2_FYL","BSTC4_B2_FZI","BSTC4_B2_FZL","BSTC4_B2_MXI","BSTC4_B2_MXL","BSTC4_B2_MYI", &
                               "BSTC4_B2_MYL","BSTC4_B2_MZI","BSTC4_B2_MZL","BSTC4_B2_XQ ","BSTC4_B2_XQD","BSTC4_B2_YQ ", &
                               "BSTC4_B2_YQD","BSTC4_B2_ZQ ","BSTC4_B2_ZQD","BSTC4_B3_FXI","BSTC4_B3_FXL","BSTC4_B3_FYI", &
                               "BSTC4_B3_FYL","BSTC4_B3_FZI","BSTC4_B3_FZL","BSTC4_B3_MXI","BSTC4_B3_MXL","BSTC4_B3_MYI", &
                               "BSTC4_B3_MYL","BSTC4_B3_MZI","BSTC4_B3_MZL","BSTC4_B3_XQ ","BSTC4_B3_XQD","BSTC4_B3_YQ ", &
                               "BSTC4_B3_YQD","BSTC4_B3_ZQ ","BSTC4_B3_ZQD","BSTC4_B4_FXI","BSTC4_B4_FXL","BSTC4_B4_FYI", &
                               "BSTC4_B4_FYL","BSTC4_B4_FZI","BSTC4_B4_FZL","BSTC4_B4_MXI","BSTC4_B4_MXL","BSTC4_B4_MYI", &
                               "BSTC4_B4_MYL","BSTC4_B4_MZI","BSTC4_B4_MZL","BSTC4_B4_XQ ","BSTC4_B4_XQD","BSTC4_B4_YQ ", &
                               "BSTC4_B4_YQD","BSTC4_B4_ZQ ","BSTC4_B4_ZQD","GENPWR      ","GENTQ       ","HSSBRTQC    ", &
                               "NSTC1_FXI   ","NSTC1_FXL   ","NSTC1_FYI   ","NSTC1_FYL   ","NSTC1_FZI   ","NSTC1_FZL   ", &
                               "NSTC1_MXI   ","NSTC1_MXL   ","NSTC1_MYI   ","NSTC1_MYL   ","NSTC1_MZI   ","NSTC1_MZL   ", &
                               "NSTC1_XQ    ","NSTC1_XQD   ","NSTC1_YQ    ","NSTC1_YQD   ","NSTC1_ZQ    ","NSTC1_ZQD   ", &
                               "NSTC2_FXI   ","NSTC2_FXL   ","NSTC2_FYI   ","NSTC2_FYL   ","NSTC2_FZI   ","NSTC2_FZL   ", &
                               "NSTC2_MXI   ","NSTC2_MXL   ","NSTC2_MYI   ","NSTC2_MYL   ","NSTC2_MZI   ","NSTC2_MZL   ", &
                               "NSTC2_XQ    ","NSTC2_XQD   ","NSTC2_YQ    ","NSTC2_YQD   ","NSTC2_ZQ    ","NSTC2_ZQD   ", &
                               "NSTC3_FXI   ","NSTC3_FXL   ","NSTC3_FYI   ","NSTC3_FYL   ","NSTC3_FZI   ","NSTC3_FZL   ", &
                               "NSTC3_MXI   ","NSTC3_MXL   ","NSTC3_MYI   ","NSTC3_MYL   ","NSTC3_MZI   ","NSTC3_MZL   ", &
                               "NSTC3_XQ    ","NSTC3_XQD   ","NSTC3_YQ    ","NSTC3_YQD   ","NSTC3_ZQ    ","NSTC3_ZQD   ", &
                               "NSTC4_FXI   ","NSTC4_FXL   ","NSTC4_FYI   ","NSTC4_FYL   ","NSTC4_FZI   ","NSTC4_FZL   ", &
                               "NSTC4_MXI   ","NSTC4_MXL   ","NSTC4_MYI   ","NSTC4_MYL   ","NSTC4_MZI   ","NSTC4_MZL   ", &
                               "NSTC4_XQ    ","NSTC4_XQD   ","NSTC4_YQ    ","NSTC4_YQD   ","NSTC4_ZQ    ","NSTC4_ZQD   ", &
                               "SSTC1_FXI   ","SSTC1_FXL   ","SSTC1_FYI   ","SSTC1_FYL   ","SSTC1_FZI   ","SSTC1_FZL   ", &
                               "SSTC1_MXI   ","SSTC1_MXL   ","SSTC1_MYI   ","SSTC1_MYL   ","SSTC1_MZI   ","SSTC1_MZL   ", &
                               "SSTC1_XQ    ","SSTC1_XQD   ","SSTC1_YQ    ","SSTC1_YQD   ","SSTC1_ZQ    ","SSTC1_ZQD   ", &
                               "SSTC2_FXI   ","SSTC2_FXL   ","SSTC2_FYI   ","SSTC2_FYL   ","SSTC2_FZI   ","SSTC2_FZL   ", &
                               "SSTC2_MXI   ","SSTC2_MXL   ","SSTC2_MYI   ","SSTC2_MYL   ","SSTC2_MZI   ","SSTC2_MZL   ", &
                               "SSTC2_XQ    ","SSTC2_XQD   ","SSTC2_YQ    ","SSTC2_YQD   ","SSTC2_ZQ    ","SSTC2_ZQD   ", &
                               "SSTC3_FXI   ","SSTC3_FXL   ","SSTC3_FYI   ","SSTC3_FYL   ","SSTC3_FZI   ","SSTC3_FZL   ", &
                               "SSTC3_MXI   ","SSTC3_MXL   ","SSTC3_MYI   ","SSTC3_MYL   ","SSTC3_MZI   ","SSTC3_MZL   ", &
                               "SSTC3_XQ    ","SSTC3_XQD   ","SSTC3_YQ    ","SSTC3_YQD   ","SSTC3_ZQ    ","SSTC3_ZQD   ", &
                               "SSTC4_FXI   ","SSTC4_FXL   ","SSTC4_FYI   ","SSTC4_FYL   ","SSTC4_FZI   ","SSTC4_FZL   ", &
                               "SSTC4_MXI   ","SSTC4_MXL   ","SSTC4_MYI   ","SSTC4_MYL   ","SSTC4_MZI   ","SSTC4_MZL   ", &
                               "SSTC4_XQ    ","SSTC4_XQD   ","SSTC4_YQ    ","SSTC4_YQD   ","SSTC4_ZQ    ","SSTC4_ZQD   ", &
                               "TSTC1_FXI   ","TSTC1_FXL   ","TSTC1_FYI   ","TSTC1_FYL   ","TSTC1_FZI   ","TSTC1_FZL   ", &
                               "TSTC1_MXI   ","TSTC1_MXL   ","TSTC1_MYI   ","TSTC1_MYL   ","TSTC1_MZI   ","TSTC1_MZL   ", &
                               "TSTC1_XQ    ","TSTC1_XQD   ","TSTC1_YQ    ","TSTC1_YQD   ","TSTC1_ZQ    ","TSTC1_ZQD   ", &
                               "TSTC2_FXI   ","TSTC2_FXL   ","TSTC2_FYI   ","TSTC2_FYL   ","TSTC2_FZI   ","TSTC2_FZL   ", &
                               "TSTC2_MXI   ","TSTC2_MXL   ","TSTC2_MYI   ","TSTC2_MYL   ","TSTC2_MZI   ","TSTC2_MZL   ", &
                               "TSTC2_XQ    ","TSTC2_XQD   ","TSTC2_YQ    ","TSTC2_YQD   ","TSTC2_ZQ    ","TSTC2_ZQD   ", &
                               "TSTC3_FXI   ","TSTC3_FXL   ","TSTC3_FYI   ","TSTC3_FYL   ","TSTC3_FZI   ","TSTC3_FZL   ", &
                               "TSTC3_MXI   ","TSTC3_MXL   ","TSTC3_MYI   ","TSTC3_MYL   ","TSTC3_MZI   ","TSTC3_MZL   ", &
                               "TSTC3_XQ    ","TSTC3_XQD   ","TSTC3_YQ    ","TSTC3_YQD   ","TSTC3_ZQ    ","TSTC3_ZQD   ", &
                               "TSTC4_FXI   ","TSTC4_FXL   ","TSTC4_FYI   ","TSTC4_FYL   ","TSTC4_FZI   ","TSTC4_FZL   ", &
                               "TSTC4_MXI   ","TSTC4_MXL   ","TSTC4_MYI   ","TSTC4_MYL   ","TSTC4_MZI   ","TSTC4_MZL   ", &
                               "TSTC4_XQ    ","TSTC4_XQD   ","TSTC4_YQ    ","TSTC4_YQD   ","TSTC4_ZQ    ","TSTC4_ZQD   ", &
                               "YAWMOM      ","YAWMOMCOM   "/)
   INTEGER(IntKi), PARAMETER :: ParamIndxAry(518) =  (/ &                            ! This lists the index into AllOuts(:) of the allowed parameters ValidParamAry(:)
                                   BlAirFlC1 ,    BlAirFlC2 ,    BlAirFlC3 ,    BlAirFlC1 ,    BlAirFlC2 ,    BlAirFlC3 , &
                                   BlPitchC1 ,    BlPitchC2 ,    BlPitchC3 , BStC1_B1_Fxi , BStC1_B1_Fxl , BStC1_B1_Fyi , &
                                BStC1_B1_Fyl , BStC1_B1_Fzi , BStC1_B1_Fzl , BStC1_B1_Mxi , BStC1_B1_Mxl , BStC1_B1_Myi , &
                                BStC1_B1_Myl , BStC1_B1_Mzi , BStC1_B1_Mzl ,  BStC1_B1_XQ , BStC1_B1_XQD ,  BStC1_B1_YQ , &
                                BStC1_B1_YQD ,  BStC1_B1_ZQ , BStC1_B1_ZQD , BStC1_B2_Fxi , BStC1_B2_Fxl , BStC1_B2_Fyi , &
                                BStC1_B2_Fyl , BStC1_B2_Fzi , BStC1_B2_Fzl , BStC1_B2_Mxi , BStC1_B2_Mxl , BStC1_B2_Myi , &
                                BStC1_B2_Myl , BStC1_B2_Mzi , BStC1_B2_Mzl ,  BStC1_B2_XQ , BStC1_B2_XQD ,  BStC1_B2_YQ , &
                                BStC1_B2_YQD ,  BStC1_B2_ZQ , BStC1_B2_ZQD , BStC1_B3_Fxi , BStC1_B3_Fxl , BStC1_B3_Fyi , &
                                BStC1_B3_Fyl , BStC1_B3_Fzi , BStC1_B3_Fzl , BStC1_B3_Mxi , BStC1_B3_Mxl , BStC1_B3_Myi , &
                                BStC1_B3_Myl , BStC1_B3_Mzi , BStC1_B3_Mzl ,  BStC1_B3_XQ , BStC1_B3_XQD ,  BStC1_B3_YQ , &
                                BStC1_B3_YQD ,  BStC1_B3_ZQ , BStC1_B3_ZQD , BStC1_B4_Fxi , BStC1_B4_Fxl , BStC1_B4_Fyi , &
                                BStC1_B4_Fyl , BStC1_B4_Fzi , BStC1_B4_Fzl , BStC1_B4_Mxi , BStC1_B4_Mxl , BStC1_B4_Myi , &
                                BStC1_B4_Myl , BStC1_B4_Mzi , BStC1_B4_Mzl ,  BStC1_B4_XQ , BStC1_B4_XQD ,  BStC1_B4_YQ , &
                                BStC1_B4_YQD ,  BStC1_B4_ZQ , BStC1_B4_ZQD , BStC2_B1_Fxi , BStC2_B1_Fxl , BStC2_B1_Fyi , &
                                BStC2_B1_Fyl , BStC2_B1_Fzi , BStC2_B1_Fzl , BStC2_B1_Mxi , BStC2_B1_Mxl , BStC2_B1_Myi , &
                                BStC2_B1_Myl , BStC2_B1_Mzi , BStC2_B1_Mzl ,  BStC2_B1_XQ , BStC2_B1_XQD ,  BStC2_B1_YQ , &
                                BStC2_B1_YQD ,  BStC2_B1_ZQ , BStC2_B1_ZQD , BStC2_B2_Fxi , BStC2_B2_Fxl , BStC2_B2_Fyi , &
                                BStC2_B2_Fyl , BStC2_B2_Fzi , BStC2_B2_Fzl , BStC2_B2_Mxi , BStC2_B2_Mxl , BStC2_B2_Myi , &
                                BStC2_B2_Myl , BStC2_B2_Mzi , BStC2_B2_Mzl ,  BStC2_B2_XQ , BStC2_B2_XQD ,  BStC2_B2_YQ , &
                                BStC2_B2_YQD ,  BStC2_B2_ZQ , BStC2_B2_ZQD , BStC2_B3_Fxi , BStC2_B3_Fxl , BStC2_B3_Fyi , &
                                BStC2_B3_Fyl , BStC2_B3_Fzi , BStC2_B3_Fzl , BStC2_B3_Mxi , BStC2_B3_Mxl , BStC2_B3_Myi , &
                                BStC2_B3_Myl , BStC2_B3_Mzi , BStC2_B3_Mzl ,  BStC2_B3_XQ , BStC2_B3_XQD ,  BStC2_B3_YQ , &
                                BStC2_B3_YQD ,  BStC2_B3_ZQ , BStC2_B3_ZQD , BStC2_B4_Fxi , BStC2_B4_Fxl , BStC2_B4_Fyi , &
                                BStC2_B4_Fyl , BStC2_B4_Fzi , BStC2_B4_Fzl , BStC2_B4_Mxi , BStC2_B4_Mxl , BStC2_B4_Myi , &
                                BStC2_B4_Myl , BStC2_B4_Mzi , BStC2_B4_Mzl ,  BStC2_B4_XQ , BStC2_B4_XQD ,  BStC2_B4_YQ , &
                                BStC2_B4_YQD ,  BStC2_B4_ZQ , BStC2_B4_ZQD , BStC3_B1_Fxi , BStC3_B1_Fxl , BStC3_B1_Fyi , &
                                BStC3_B1_Fyl , BStC3_B1_Fzi , BStC3_B1_Fzl , BStC3_B1_Mxi , BStC3_B1_Mxl , BStC3_B1_Myi , &
                                BStC3_B1_Myl , BStC3_B1_Mzi , BStC3_B1_Mzl ,  BStC3_B1_XQ , BStC3_B1_XQD ,  BStC3_B1_YQ , &
                                BStC3_B1_YQD ,  BStC3_B1_ZQ , BStC3_B1_ZQD , BStC3_B2_Fxi , BStC3_B2_Fxl , BStC3_B2_Fyi , &
                                BStC3_B2_Fyl , BStC3_B2_Fzi , BStC3_B2_Fzl , BStC3_B2_Mxi , BStC3_B2_Mxl , BStC3_B2_Myi , &
                                BStC3_B2_Myl , BStC3_B2_Mzi , BStC3_B2_Mzl ,  BStC3_B2_XQ , BStC3_B2_XQD ,  BStC3_B2_YQ , &
                                BStC3_B2_YQD ,  BStC3_B2_ZQ , BStC3_B2_ZQD , BStC3_B3_Fxi , BStC3_B3_Fxl , BStC3_B3_Fyi , &
                                BStC3_B3_Fyl , BStC3_B3_Fzi , BStC3_B3_Fzl , BStC3_B3_Mxi , BStC3_B3_Mxl , BStC3_B3_Myi , &
                                BStC3_B3_Myl , BStC3_B3_Mzi , BStC3_B3_Mzl ,  BStC3_B3_XQ , BStC3_B3_XQD ,  BStC3_B3_YQ , &
                                BStC3_B3_YQD ,  BStC3_B3_ZQ , BStC3_B3_ZQD , BStC3_B4_Fxi , BStC3_B4_Fxl , BStC3_B4_Fyi , &
                                BStC3_B4_Fyl , BStC3_B4_Fzi , BStC3_B4_Fzl , BStC3_B4_Mxi , BStC3_B4_Mxl , BStC3_B4_Myi , &
                                BStC3_B4_Myl , BStC3_B4_Mzi , BStC3_B4_Mzl ,  BStC3_B4_XQ , BStC3_B4_XQD ,  BStC3_B4_YQ , &
                                BStC3_B4_YQD ,  BStC3_B4_ZQ , BStC3_B4_ZQD , BStC4_B1_Fxi , BStC4_B1_Fxl , BStC4_B1_Fyi , &
                                BStC4_B1_Fyl , BStC4_B1_Fzi , BStC4_B1_Fzl , BStC4_B1_Mxi , BStC4_B1_Mxl , BStC4_B1_Myi , &
                                BStC4_B1_Myl , BStC4_B1_Mzi , BStC4_B1_Mzl ,  BStC4_B1_XQ , BStC4_B1_XQD ,  BStC4_B1_YQ , &
                                BStC4_B1_YQD ,  BStC4_B1_ZQ , BStC4_B1_ZQD , BStC4_B2_Fxi , BStC4_B2_Fxl , BStC4_B2_Fyi , &
                                BStC4_B2_Fyl , BStC4_B2_Fzi , BStC4_B2_Fzl , BStC4_B2_Mxi , BStC4_B2_Mxl , BStC4_B2_Myi , &
                                BStC4_B2_Myl , BStC4_B2_Mzi , BStC4_B2_Mzl ,  BStC4_B2_XQ , BStC4_B2_XQD ,  BStC4_B2_YQ , &
                                BStC4_B2_YQD ,  BStC4_B2_ZQ , BStC4_B2_ZQD , BStC4_B3_Fxi , BStC4_B3_Fxl , BStC4_B3_Fyi , &
                                BStC4_B3_Fyl , BStC4_B3_Fzi , BStC4_B3_Fzl , BStC4_B3_Mxi , BStC4_B3_Mxl , BStC4_B3_Myi , &
                                BStC4_B3_Myl , BStC4_B3_Mzi , BStC4_B3_Mzl ,  BStC4_B3_XQ , BStC4_B3_XQD ,  BStC4_B3_YQ , &
                                BStC4_B3_YQD ,  BStC4_B3_ZQ , BStC4_B3_ZQD , BStC4_B4_Fxi , BStC4_B4_Fxl , BStC4_B4_Fyi , &
                                BStC4_B4_Fyl , BStC4_B4_Fzi , BStC4_B4_Fzl , BStC4_B4_Mxi , BStC4_B4_Mxl , BStC4_B4_Myi , &
                                BStC4_B4_Myl , BStC4_B4_Mzi , BStC4_B4_Mzl ,  BStC4_B4_XQ , BStC4_B4_XQD ,  BStC4_B4_YQ , &
                                BStC4_B4_YQD ,  BStC4_B4_ZQ , BStC4_B4_ZQD ,       GenPwr ,        GenTq ,     HSSBrTqC , &
                                   NStC1_Fxi ,    NStC1_Fxl ,    NStC1_Fyi ,    NStC1_Fyl ,    NStC1_Fzi ,    NStC1_Fzl , &
                                   NStC1_Mxi ,    NStC1_Mxl ,    NStC1_Myi ,    NStC1_Myl ,    NStC1_Mzi ,    NStC1_Mzl , &
                                    NStC1_XQ ,    NStC1_XQD ,     NStC1_YQ ,    NStC1_YQD ,     NStC1_ZQ ,    NStC1_ZQD , &
                                   NStC2_Fxi ,    NStC2_Fxl ,    NStC2_Fyi ,    NStC2_Fyl ,    NStC2_Fzi ,    NStC2_Fzl , &
                                   NStC2_Mxi ,    NStC2_Mxl ,    NStC2_Myi ,    NStC2_Myl ,    NStC2_Mzi ,    NStC2_Mzl , &
                                    NStC2_XQ ,    NStC2_XQD ,     NStC2_YQ ,    NStC2_YQD ,     NStC2_ZQ ,    NStC2_ZQD , &
                                   NStC3_Fxi ,    NStC3_Fxl ,    NStC3_Fyi ,    NStC3_Fyl ,    NStC3_Fzi ,    NStC3_Fzl , &
                                   NStC3_Mxi ,    NStC3_Mxl ,    NStC3_Myi ,    NStC3_Myl ,    NStC3_Mzi ,    NStC3_Mzl , &
                                    NStC3_XQ ,    NStC3_XQD ,     NStC3_YQ ,    NStC3_YQD ,     NStC3_ZQ ,    NStC3_ZQD , &
                                   NStC4_Fxi ,    NStC4_Fxl ,    NStC4_Fyi ,    NStC4_Fyl ,    NStC4_Fzi ,    NStC4_Fzl , &
                                   NStC4_Mxi ,    NStC4_Mxl ,    NStC4_Myi ,    NStC4_Myl ,    NStC4_Mzi ,    NStC4_Mzl , &
                                    NStC4_XQ ,    NStC4_XQD ,     NStC4_YQ ,    NStC4_YQD ,     NStC4_ZQ ,    NStC4_ZQD , &
                                   SStC1_Fxi ,    SStC1_Fxl ,    SStC1_Fyi ,    SStC1_Fyl ,    SStC1_Fzi ,    SStC1_Fzl , &
                                   SStC1_Mxi ,    SStC1_Mxl ,    SStC1_Myi ,    SStC1_Myl ,    SStC1_Mzi ,    SStC1_Mzl , &
                                    SStC1_XQ ,    SStC1_XQD ,     SStC1_YQ ,    SStC1_YQD ,     SStC1_ZQ ,    SStC1_ZQD , &
                                   SStC2_Fxi ,    SStC2_Fxl ,    SStC2_Fyi ,    SStC2_Fyl ,    SStC2_Fzi ,    SStC2_Fzl , &
                                   SStC2_Mxi ,    SStC2_Mxl ,    SStC2_Myi ,    SStC2_Myl ,    SStC2_Mzi ,    SStC2_Mzl , &
                                    SStC2_XQ ,    SStC2_XQD ,     SStC2_YQ ,    SStC2_YQD ,     SStC2_ZQ ,    SStC2_ZQD , &
                                   SStC3_Fxi ,    SStC3_Fxl ,    SStC3_Fyi ,    SStC3_Fyl ,    SStC3_Fzi ,    SStC3_Fzl , &
                                   SStC3_Mxi ,    SStC3_Mxl ,    SStC3_Myi ,    SStC3_Myl ,    SStC3_Mzi ,    SStC3_Mzl , &
                                    SStC3_XQ ,    SStC3_XQD ,     SStC3_YQ ,    SStC3_YQD ,     SStC3_ZQ ,    SStC3_ZQD , &
                                   SStC4_Fxi ,    SStC4_Fxl ,    SStC4_Fyi ,    SStC4_Fyl ,    SStC4_Fzi ,    SStC4_Fzl , &
                                   SStC4_Mxi ,    SStC4_Mxl ,    SStC4_Myi ,    SStC4_Myl ,    SStC4_Mzi ,    SStC4_Mzl , &
                                    SStC4_XQ ,    SStC4_XQD ,     SStC4_YQ ,    SStC4_YQD ,     SStC4_ZQ ,    SStC4_ZQD , &
                                   TStC1_Fxi ,    TStC1_Fxl ,    TStC1_Fyi ,    TStC1_Fyl ,    TStC1_Fzi ,    TStC1_Fzl , &
                                   TStC1_Mxi ,    TStC1_Mxl ,    TStC1_Myi ,    TStC1_Myl ,    TStC1_Mzi ,    TStC1_Mzl , &
                                    TStC1_XQ ,    TStC1_XQD ,     TStC1_YQ ,    TStC1_YQD ,     TStC1_ZQ ,    TStC1_ZQD , &
                                   TStC2_Fxi ,    TStC2_Fxl ,    TStC2_Fyi ,    TStC2_Fyl ,    TStC2_Fzi ,    TStC2_Fzl , &
                                   TStC2_Mxi ,    TStC2_Mxl ,    TStC2_Myi ,    TStC2_Myl ,    TStC2_Mzi ,    TStC2_Mzl , &
                                    TStC2_XQ ,    TStC2_XQD ,     TStC2_YQ ,    TStC2_YQD ,     TStC2_ZQ ,    TStC2_ZQD , &
                                   TStC3_Fxi ,    TStC3_Fxl ,    TStC3_Fyi ,    TStC3_Fyl ,    TStC3_Fzi ,    TStC3_Fzl , &
                                   TStC3_Mxi ,    TStC3_Mxl ,    TStC3_Myi ,    TStC3_Myl ,    TStC3_Mzi ,    TStC3_Mzl , &
                                    TStC3_XQ ,    TStC3_XQD ,     TStC3_YQ ,    TStC3_YQD ,     TStC3_ZQ ,    TStC3_ZQD , &
                                   TStC4_Fxi ,    TStC4_Fxl ,    TStC4_Fyi ,    TStC4_Fyl ,    TStC4_Fzi ,    TStC4_Fzl , &
                                   TStC4_Mxi ,    TStC4_Mxl ,    TStC4_Myi ,    TStC4_Myl ,    TStC4_Mzi ,    TStC4_Mzl , &
                                    TStC4_XQ ,    TStC4_XQD ,     TStC4_YQ ,    TStC4_YQD ,     TStC4_ZQ ,    TStC4_ZQD , &
                                   YawMomCom ,    YawMomCom /)
   CHARACTER(ChanLen), PARAMETER :: ParamUnitsAry(518) =  (/  &  ! This lists the units corresponding to the allowed parameters
                               "(-)   ","(-)   ","(-)   ","(-)   ","(-)   ","(-)   ", &
                               "(deg) ","(deg) ","(deg) ","(kN)  ","(kN)  ","(kN)  ", &
                               "(kN)  ","(kN)  ","(kN)  ","(kN-m)","(kN-m)","(kN-m)", &
                               "(kN-m)","(kN-m)","(kN-m)","(m)   ","(m/s) ","(m)   ", &
                               "(m/s) ","(m)   ","(m/s) ","(kN)  ","(kN)  ","(kN)  ", &
                               "(kN)  ","(kN)  ","(kN)  ","(kN-m)","(kN-m)","(kN-m)", &
                               "(kN-m)","(kN-m)","(kN-m)","(m)   ","(m/s) ","(m)   ", &
                               "(m/s) ","(m)   ","(m/s) ","(kN)  ","(kN)  ","(kN)  ", &
                               "(kN)  ","(kN)  ","(kN)  ","(kN-m)","(kN-m)","(kN-m)", &
                               "(kN-m)","(kN-m)","(kN-m)","(m)   ","(m/s) ","(m)   ", &
                               "(m/s) ","(m)   ","(m/s) ","(kN)  ","(kN)  ","(kN)  ", &
                               "(kN)  ","(kN)  ","(kN)  ","(kN-m)","(kN-m)","(kN-m)", &
                               "(kN-m)","(kN-m)","(kN-m)","(m)   ","(m/s) ","(m)   ", &
                               "(m/s) ","(m)   ","(m/s) ","(kN)  ","(kN)  ","(kN)  ", &
                               "(kN)  ","(kN)  ","(kN)  ","(kN-m)","(kN-m)","(kN-m)", &
                               "(kN-m)","(kN-m)","(kN-m)","(m)   ","(m/s) ","(m)   ", &
                               "(m/s) ","(m)   ","(m/s) ","(kN)  ","(kN)  ","(kN)  ", &
                               "(kN)  ","(kN)  ","(kN)  ","(kN-m)","(kN-m)","(kN-m)", &
                               "(kN-m)","(kN-m)","(kN-m)","(m)   ","(m/s) ","(m)   ", &
                               "(m/s) ","(m)   ","(m/s) ","(kN)  ","(kN)  ","(kN)  ", &
                               "(kN)  ","(kN)  ","(kN)  ","(kN-m)","(kN-m)","(kN-m)", &
                               "(kN-m)","(kN-m)","(kN-m)","(m)   ","(m/s) ","(m)   ", &
                               "(m/s) ","(m)   ","(m/s) ","(kN)  ","(kN)  ","(kN)  ", &
                               "(kN)  ","(kN)  ","(kN)  ","(kN-m)","(kN-m)","(kN-m)", &
                               "(kN-m)","(kN-m)","(kN-m)","(m)   ","(m/s) ","(m)   ", &
                               "(m/s) ","(m)   ","(m/s) ","(kN)  ","(kN)  ","(kN)  ", &
                               "(kN)  ","(kN)  ","(kN)  ","(kN-m)","(kN-m)","(kN-m)", &
                               "(kN-m)","(kN-m)","(kN-m)","(m)   ","(m/s) ","(m)   ", &
                               "(m/s) ","(m)   ","(m/s) ","(kN)  ","(kN)  ","(kN)  ", &
                               "(kN)  ","(kN)  ","(kN)  ","(kN-m)","(kN-m)","(kN-m)", &
                               "(kN-m)","(kN-m)","(kN-m)","(m)   ","(m/s) ","(m)   ", &
                               "(m/s) ","(m)   ","(m/s) ","(kN)  ","(kN)  ","(kN)  ", &
                               "(kN)  ","(kN)  ","(kN)  ","(kN-m)","(kN-m)","(kN-m)", &
                               "(kN-m)","(kN-m)","(kN-m)","(m)   ","(m/s) ","(m)   ", &
                               "(m/s) ","(m)   ","(m/s) ","(kN)  ","(kN)  ","(kN)  ", &
                               "(kN)  ","(kN)  ","(kN)  ","(kN-m)","(kN-m)","(kN-m)", &
                               "(kN-m)","(kN-m)","(kN-m)","(m)   ","(m/s) ","(m)   ", &
                               "(m/s) ","(m)   ","(m/s) ","(kN)  ","(kN)  ","(kN)  ", &
                               "(kN)  ","(kN)  ","(kN)  ","(kN-m)","(kN-m)","(kN-m)", &
                               "(kN-m)","(kN-m)","(kN-m)","(m)   ","(m/s) ","(m)   ", &
                               "(m/s) ","(m)   ","(m/s) ","(kN)  ","(kN)  ","(kN)  ", &
                               "(kN)  ","(kN)  ","(kN)  ","(kN-m)","(kN-m)","(kN-m)", &
                               "(kN-m)","(kN-m)","(kN-m)","(m)   ","(m/s) ","(m)   ", &
                               "(m/s) ","(m)   ","(m/s) ","(kN)  ","(kN)  ","(kN)  ", &
                               "(kN)  ","(kN)  ","(kN)  ","(kN-m)","(kN-m)","(kN-m)", &
                               "(kN-m)","(kN-m)","(kN-m)","(m)   ","(m/s) ","(m)   ", &
                               "(m/s) ","(m)   ","(m/s) ","(kN)  ","(kN)  ","(kN)  ", &
                               "(kN)  ","(kN)  ","(kN)  ","(kN-m)","(kN-m)","(kN-m)", &
                               "(kN-m)","(kN-m)","(kN-m)","(m)   ","(m/s) ","(m)   ", &
                               "(m/s) ","(m)   ","(m/s) ","(kW)  ","(kN-m)","(kN-m)", &
                               "(kN)  ","(kN)  ","(kN)  ","(kN)  ","(kN)  ","(kN)  ", &
                               "(kN-m)","(kN-m)","(kN-m)","(kN-m)","(kN-m)","(kN-m)", &
                               "(m)   ","(m/s) ","(m)   ","(m/s) ","(m)   ","(m/s) ", &
                               "(kN)  ","(kN)  ","(kN)  ","(kN)  ","(kN)  ","(kN)  ", &
                               "(kN-m)","(kN-m)","(kN-m)","(kN-m)","(kN-m)","(kN-m)", &
                               "(m)   ","(m/s) ","(m)   ","(m/s) ","(m)   ","(m/s) ", &
                               "(kN)  ","(kN)  ","(kN)  ","(kN)  ","(kN)  ","(kN)  ", &
                               "(kN-m)","(kN-m)","(kN-m)","(kN-m)","(kN-m)","(kN-m)", &
                               "(m)   ","(m/s) ","(m)   ","(m/s) ","(m)   ","(m/s) ", &
                               "(kN)  ","(kN)  ","(kN)  ","(kN)  ","(kN)  ","(kN)  ", &
                               "(kN-m)","(kN-m)","(kN-m)","(kN-m)","(kN-m)","(kN-m)", &
                               "(m)   ","(m/s) ","(m)   ","(m/s) ","(m)   ","(m/s) ", &
                               "(kN)  ","(kN)  ","(kN)  ","(kN)  ","(kN)  ","(kN)  ", &
                               "(kN-m)","(kN-m)","(kN-m)","(kN-m)","(kN-m)","(kN-m)", &
                               "(m)   ","(m/s) ","(m)   ","(m/s) ","(m)   ","(m/s) ", &
                               "(kN)  ","(kN)  ","(kN)  ","(kN)  ","(kN)  ","(kN)  ", &
                               "(kN-m)","(kN-m)","(kN-m)","(kN-m)","(kN-m)","(kN-m)", &
                               "(m)   ","(m/s) ","(m)   ","(m/s) ","(m)   ","(m/s) ", &
                               "(kN)  ","(kN)  ","(kN)  ","(kN)  ","(kN)  ","(kN)  ", &
                               "(kN-m)","(kN-m)","(kN-m)","(kN-m)","(kN-m)","(kN-m)", &
                               "(m)   ","(m/s) ","(m)   ","(m/s) ","(m)   ","(m/s) ", &
                               "(kN)  ","(kN)  ","(kN)  ","(kN)  ","(kN)  ","(kN)  ", &
                               "(kN-m)","(kN-m)","(kN-m)","(kN-m)","(kN-m)","(kN-m)", &
                               "(m)   ","(m/s) ","(m)   ","(m/s) ","(m)   ","(m/s) ", &
                               "(kN)  ","(kN)  ","(kN)  ","(kN)  ","(kN)  ","(kN)  ", &
                               "(kN-m)","(kN-m)","(kN-m)","(kN-m)","(kN-m)","(kN-m)", &
                               "(m)   ","(m/s) ","(m)   ","(m/s) ","(m)   ","(m/s) ", &
                               "(kN)  ","(kN)  ","(kN)  ","(kN)  ","(kN)  ","(kN)  ", &
                               "(kN-m)","(kN-m)","(kN-m)","(kN-m)","(kN-m)","(kN-m)", &
                               "(m)   ","(m/s) ","(m)   ","(m/s) ","(m)   ","(m/s) ", &
                               "(kN)  ","(kN)  ","(kN)  ","(kN)  ","(kN)  ","(kN)  ", &
                               "(kN-m)","(kN-m)","(kN-m)","(kN-m)","(kN-m)","(kN-m)", &
                               "(m)   ","(m/s) ","(m)   ","(m/s) ","(m)   ","(m/s) ", &
                               "(kN)  ","(kN)  ","(kN)  ","(kN)  ","(kN)  ","(kN)  ", &
                               "(kN-m)","(kN-m)","(kN-m)","(kN-m)","(kN-m)","(kN-m)", &
                               "(m)   ","(m/s) ","(m)   ","(m/s) ","(m)   ","(m/s) ", &
                               "(kN-m)","(kN-m)"/)


      ! Initialize values
   ErrStat = ErrID_None
   ErrMsg = ""
   InvalidOutput = .FALSE.


      ! Determine which inputs are not valid

   InvalidOutput(   BlAirFlC3) = ( p%NumBl < 3 )
   InvalidOutput(   BlPitchC3) = ( p%NumBl < 3 )
   InvalidOutput(    NStC1_XQ) = ( p%NumNStC<1 )
   InvalidOutput(   NStC1_XQD) = ( p%NumNStC<1 )
   InvalidOutput(    NStC1_YQ) = ( p%NumNStC<1 )
   InvalidOutput(   NStC1_YQD) = ( p%NumNStC<1 )
   InvalidOutput(    NStC1_ZQ) = ( p%NumNStC<1 )
   InvalidOutput(   NStC1_ZQD) = ( p%NumNStC<1 )
   InvalidOutput(   NStC1_Fxi) = ( p%NumNStC<1 )
   InvalidOutput(   NStC1_Fyi) = ( p%NumNStC<1 )
   InvalidOutput(   NStC1_Fzi) = ( p%NumNStC<1 )
   InvalidOutput(   NStC1_Mxi) = ( p%NumNStC<1 )
   InvalidOutput(   NStC1_Myi) = ( p%NumNStC<1 )
   InvalidOutput(   NStC1_Mzi) = ( p%NumNStC<1 )
   InvalidOutput(   NStC1_Fxl) = ( p%NumNStC<1 )
   InvalidOutput(   NStC1_Fyl) = ( p%NumNStC<1 )
   InvalidOutput(   NStC1_Fzl) = ( p%NumNStC<1 )
   InvalidOutput(   NStC1_Mxl) = ( p%NumNStC<1 )
   InvalidOutput(   NStC1_Myl) = ( p%NumNStC<1 )
   InvalidOutput(   NStC1_Mzl) = ( p%NumNStC<1 )
   InvalidOutput(    NStC2_XQ) = ( p%NumNStC<2 )
   InvalidOutput(   NStC2_XQD) = ( p%NumNStC<2 )
   InvalidOutput(    NStC2_YQ) = ( p%NumNStC<2 )
   InvalidOutput(   NStC2_YQD) = ( p%NumNStC<2 )
   InvalidOutput(    NStC2_ZQ) = ( p%NumNStC<2 )
   InvalidOutput(   NStC2_ZQD) = ( p%NumNStC<2 )
   InvalidOutput(   NStC2_Fxi) = ( p%NumNStC<2 )
   InvalidOutput(   NStC2_Fyi) = ( p%NumNStC<2 )
   InvalidOutput(   NStC2_Fzi) = ( p%NumNStC<2 )
   InvalidOutput(   NStC2_Mxi) = ( p%NumNStC<2 )
   InvalidOutput(   NStC2_Myi) = ( p%NumNStC<2 )
   InvalidOutput(   NStC2_Mzi) = ( p%NumNStC<2 )
   InvalidOutput(   NStC2_Fxl) = ( p%NumNStC<2 )
   InvalidOutput(   NStC2_Fyl) = ( p%NumNStC<2 )
   InvalidOutput(   NStC2_Fzl) = ( p%NumNStC<2 )
   InvalidOutput(   NStC2_Mxl) = ( p%NumNStC<2 )
   InvalidOutput(   NStC2_Myl) = ( p%NumNStC<2 )
   InvalidOutput(   NStC2_Mzl) = ( p%NumNStC<2 )
   InvalidOutput(    NStC3_XQ) = ( p%NumNStC<3 )
   InvalidOutput(   NStC3_XQD) = ( p%NumNStC<3 )
   InvalidOutput(    NStC3_YQ) = ( p%NumNStC<3 )
   InvalidOutput(   NStC3_YQD) = ( p%NumNStC<3 )
   InvalidOutput(    NStC3_ZQ) = ( p%NumNStC<3 )
   InvalidOutput(   NStC3_ZQD) = ( p%NumNStC<3 )
   InvalidOutput(   NStC3_Fxi) = ( p%NumNStC<3 )
   InvalidOutput(   NStC3_Fyi) = ( p%NumNStC<3 )
   InvalidOutput(   NStC3_Fzi) = ( p%NumNStC<3 )
   InvalidOutput(   NStC3_Mxi) = ( p%NumNStC<3 )
   InvalidOutput(   NStC3_Myi) = ( p%NumNStC<3 )
   InvalidOutput(   NStC3_Mzi) = ( p%NumNStC<3 )
   InvalidOutput(   NStC3_Fxl) = ( p%NumNStC<3 )
   InvalidOutput(   NStC3_Fyl) = ( p%NumNStC<3 )
   InvalidOutput(   NStC3_Fzl) = ( p%NumNStC<3 )
   InvalidOutput(   NStC3_Mxl) = ( p%NumNStC<3 )
   InvalidOutput(   NStC3_Myl) = ( p%NumNStC<3 )
   InvalidOutput(   NStC3_Mzl) = ( p%NumNStC<3 )
   InvalidOutput(    NStC4_XQ) = ( p%NumNStC<4 )
   InvalidOutput(   NStC4_XQD) = ( p%NumNStC<4 )
   InvalidOutput(    NStC4_YQ) = ( p%NumNStC<4 )
   InvalidOutput(   NStC4_YQD) = ( p%NumNStC<4 )
   InvalidOutput(    NStC4_ZQ) = ( p%NumNStC<4 )
   InvalidOutput(   NStC4_ZQD) = ( p%NumNStC<4 )
   InvalidOutput(   NStC4_Fxi) = ( p%NumNStC<4 )
   InvalidOutput(   NStC4_Fyi) = ( p%NumNStC<4 )
   InvalidOutput(   NStC4_Fzi) = ( p%NumNStC<4 )
   InvalidOutput(   NStC4_Mxi) = ( p%NumNStC<4 )
   InvalidOutput(   NStC4_Myi) = ( p%NumNStC<4 )
   InvalidOutput(   NStC4_Mzi) = ( p%NumNStC<4 )
   InvalidOutput(   NStC4_Fxl) = ( p%NumNStC<4 )
   InvalidOutput(   NStC4_Fyl) = ( p%NumNStC<4 )
   InvalidOutput(   NStC4_Fzl) = ( p%NumNStC<4 )
   InvalidOutput(   NStC4_Mxl) = ( p%NumNStC<4 )
   InvalidOutput(   NStC4_Myl) = ( p%NumNStC<4 )
   InvalidOutput(   NStC4_Mzl) = ( p%NumNStC<4 )
   InvalidOutput(    TStC1_XQ) = ( p%NumTStC<1 )
   InvalidOutput(   TStC1_XQD) = ( p%NumTStC<1 )
   InvalidOutput(    TStC1_YQ) = ( p%NumTStC<1 )
   InvalidOutput(   TStC1_YQD) = ( p%NumTStC<1 )
   InvalidOutput(    TStC1_ZQ) = ( p%NumTStC<1 )
   InvalidOutput(   TStC1_ZQD) = ( p%NumTStC<1 )
   InvalidOutput(   TStC1_Fxi) = ( p%NumTStC<1 )
   InvalidOutput(   TStC1_Fyi) = ( p%NumTStC<1 )
   InvalidOutput(   TStC1_Fzi) = ( p%NumTStC<1 )
   InvalidOutput(   TStC1_Mxi) = ( p%NumTStC<1 )
   InvalidOutput(   TStC1_Myi) = ( p%NumTStC<1 )
   InvalidOutput(   TStC1_Mzi) = ( p%NumTStC<1 )
   InvalidOutput(   TStC1_Fxl) = ( p%NumTStC<1 )
   InvalidOutput(   TStC1_Fyl) = ( p%NumTStC<1 )
   InvalidOutput(   TStC1_Fzl) = ( p%NumTStC<1 )
   InvalidOutput(   TStC1_Mxl) = ( p%NumTStC<1 )
   InvalidOutput(   TStC1_Myl) = ( p%NumTStC<1 )
   InvalidOutput(   TStC1_Mzl) = ( p%NumTStC<1 )
   InvalidOutput(    TStC2_XQ) = ( p%NumTStC<2 )
   InvalidOutput(   TStC2_XQD) = ( p%NumTStC<2 )
   InvalidOutput(    TStC2_YQ) = ( p%NumTStC<2 )
   InvalidOutput(   TStC2_YQD) = ( p%NumTStC<2 )
   InvalidOutput(    TStC2_ZQ) = ( p%NumTStC<2 )
   InvalidOutput(   TStC2_ZQD) = ( p%NumTStC<2 )
   InvalidOutput(   TStC2_Fxi) = ( p%NumTStC<2 )
   InvalidOutput(   TStC2_Fyi) = ( p%NumTStC<2 )
   InvalidOutput(   TStC2_Fzi) = ( p%NumTStC<2 )
   InvalidOutput(   TStC2_Mxi) = ( p%NumTStC<2 )
   InvalidOutput(   TStC2_Myi) = ( p%NumTStC<2 )
   InvalidOutput(   TStC2_Mzi) = ( p%NumTStC<2 )
   InvalidOutput(   TStC2_Fxl) = ( p%NumTStC<2 )
   InvalidOutput(   TStC2_Fyl) = ( p%NumTStC<2 )
   InvalidOutput(   TStC2_Fzl) = ( p%NumTStC<2 )
   InvalidOutput(   TStC2_Mxl) = ( p%NumTStC<2 )
   InvalidOutput(   TStC2_Myl) = ( p%NumTStC<2 )
   InvalidOutput(   TStC2_Mzl) = ( p%NumTStC<2 )
   InvalidOutput(    TStC3_XQ) = ( p%NumTStC<3 )
   InvalidOutput(   TStC3_XQD) = ( p%NumTStC<3 )
   InvalidOutput(    TStC3_YQ) = ( p%NumTStC<3 )
   InvalidOutput(   TStC3_YQD) = ( p%NumTStC<3 )
   InvalidOutput(    TStC3_ZQ) = ( p%NumTStC<3 )
   InvalidOutput(   TStC3_ZQD) = ( p%NumTStC<3 )
   InvalidOutput(   TStC3_Fxi) = ( p%NumTStC<3 )
   InvalidOutput(   TStC3_Fyi) = ( p%NumTStC<3 )
   InvalidOutput(   TStC3_Fzi) = ( p%NumTStC<3 )
   InvalidOutput(   TStC3_Mxi) = ( p%NumTStC<3 )
   InvalidOutput(   TStC3_Myi) = ( p%NumTStC<3 )
   InvalidOutput(   TStC3_Mzi) = ( p%NumTStC<3 )
   InvalidOutput(   TStC3_Fxl) = ( p%NumTStC<3 )
   InvalidOutput(   TStC3_Fyl) = ( p%NumTStC<3 )
   InvalidOutput(   TStC3_Fzl) = ( p%NumTStC<3 )
   InvalidOutput(   TStC3_Mxl) = ( p%NumTStC<3 )
   InvalidOutput(   TStC3_Myl) = ( p%NumTStC<3 )
   InvalidOutput(   TStC3_Mzl) = ( p%NumTStC<3 )
   InvalidOutput(    TStC4_XQ) = ( p%NumTStC<4 )
   InvalidOutput(   TStC4_XQD) = ( p%NumTStC<4 )
   InvalidOutput(    TStC4_YQ) = ( p%NumTStC<4 )
   InvalidOutput(   TStC4_YQD) = ( p%NumTStC<4 )
   InvalidOutput(    TStC4_ZQ) = ( p%NumTStC<4 )
   InvalidOutput(   TStC4_ZQD) = ( p%NumTStC<4 )
   InvalidOutput(   TStC4_Fxi) = ( p%NumTStC<4 )
   InvalidOutput(   TStC4_Fyi) = ( p%NumTStC<4 )
   InvalidOutput(   TStC4_Fzi) = ( p%NumTStC<4 )
   InvalidOutput(   TStC4_Mxi) = ( p%NumTStC<4 )
   InvalidOutput(   TStC4_Myi) = ( p%NumTStC<4 )
   InvalidOutput(   TStC4_Mzi) = ( p%NumTStC<4 )
   InvalidOutput(   TStC4_Fxl) = ( p%NumTStC<4 )
   InvalidOutput(   TStC4_Fyl) = ( p%NumTStC<4 )
   InvalidOutput(   TStC4_Fzl) = ( p%NumTStC<4 )
   InvalidOutput(   TStC4_Mxl) = ( p%NumTStC<4 )
   InvalidOutput(   TStC4_Myl) = ( p%NumTStC<4 )
   InvalidOutput(   TStC4_Mzl) = ( p%NumTStC<4 )
   InvalidOutput( BStC1_B1_XQ) = ( p%NumBStC<1 .or. p%NumBl<1 )
   InvalidOutput(BStC1_B1_XQD) = ( p%NumBStC<1 .or. p%NumBl<1 )
   InvalidOutput( BStC1_B1_YQ) = ( p%NumBStC<1 .or. p%NumBl<1 )
   InvalidOutput(BStC1_B1_YQD) = ( p%NumBStC<1 .or. p%NumBl<1 )
   InvalidOutput( BStC1_B1_ZQ) = ( p%NumBStC<1 .or. p%NumBl<1 )
   InvalidOutput(BStC1_B1_ZQD) = ( p%NumBStC<1 .or. p%NumBl<1 )
   InvalidOutput(BStC1_B1_Fxi) = ( p%NumBStC<1 .or. p%NumBl<1 )
   InvalidOutput(BStC1_B1_Fyi) = ( p%NumBStC<1 .or. p%NumBl<1 )
   InvalidOutput(BStC1_B1_Fzi) = ( p%NumBStC<1 .or. p%NumBl<1 )
   InvalidOutput(BStC1_B1_Mxi) = ( p%NumBStC<1 .or. p%NumBl<1 )
   InvalidOutput(BStC1_B1_Myi) = ( p%NumBStC<1 .or. p%NumBl<1 )
   InvalidOutput(BStC1_B1_Mzi) = ( p%NumBStC<1 .or. p%NumBl<1 )
   InvalidOutput(BStC1_B1_Fxl) = ( p%NumBStC<1 .or. p%NumBl<1 )
   InvalidOutput(BStC1_B1_Fyl) = ( p%NumBStC<1 .or. p%NumBl<1 )
   InvalidOutput(BStC1_B1_Fzl) = ( p%NumBStC<1 .or. p%NumBl<1 )
   InvalidOutput(BStC1_B1_Mxl) = ( p%NumBStC<1 .or. p%NumBl<1 )
   InvalidOutput(BStC1_B1_Myl) = ( p%NumBStC<1 .or. p%NumBl<1 )
   InvalidOutput(BStC1_B1_Mzl) = ( p%NumBStC<1 .or. p%NumBl<1 )
   InvalidOutput( BStC2_B1_XQ) = ( p%NumBStC<2 .or. p%NumBl<1 )
   InvalidOutput(BStC2_B1_XQD) = ( p%NumBStC<2 .or. p%NumBl<1 )
   InvalidOutput( BStC2_B1_YQ) = ( p%NumBStC<2 .or. p%NumBl<1 )
   InvalidOutput(BStC2_B1_YQD) = ( p%NumBStC<2 .or. p%NumBl<1 )
   InvalidOutput( BStC2_B1_ZQ) = ( p%NumBStC<2 .or. p%NumBl<1 )
   InvalidOutput(BStC2_B1_ZQD) = ( p%NumBStC<2 .or. p%NumBl<1 )
   InvalidOutput(BStC2_B1_Fxi) = ( p%NumBStC<2 .or. p%NumBl<1 )
   InvalidOutput(BStC2_B1_Fyi) = ( p%NumBStC<2 .or. p%NumBl<1 )
   InvalidOutput(BStC2_B1_Fzi) = ( p%NumBStC<2 .or. p%NumBl<1 )
   InvalidOutput(BStC2_B1_Mxi) = ( p%NumBStC<2 .or. p%NumBl<1 )
   InvalidOutput(BStC2_B1_Myi) = ( p%NumBStC<2 .or. p%NumBl<1 )
   InvalidOutput(BStC2_B1_Mzi) = ( p%NumBStC<2 .or. p%NumBl<1 )
   InvalidOutput(BStC2_B1_Fxl) = ( p%NumBStC<2 .or. p%NumBl<1 )
   InvalidOutput(BStC2_B1_Fyl) = ( p%NumBStC<2 .or. p%NumBl<1 )
   InvalidOutput(BStC2_B1_Fzl) = ( p%NumBStC<2 .or. p%NumBl<1 )
   InvalidOutput(BStC2_B1_Mxl) = ( p%NumBStC<2 .or. p%NumBl<1 )
   InvalidOutput(BStC2_B1_Myl) = ( p%NumBStC<2 .or. p%NumBl<1 )
   InvalidOutput(BStC2_B1_Mzl) = ( p%NumBStC<2 .or. p%NumBl<1 )
   InvalidOutput( BStC3_B1_XQ) = ( p%NumBStC<3 .or. p%NumBl<1 )
   InvalidOutput(BStC3_B1_XQD) = ( p%NumBStC<3 .or. p%NumBl<1 )
   InvalidOutput( BStC3_B1_YQ) = ( p%NumBStC<3 .or. p%NumBl<1 )
   InvalidOutput(BStC3_B1_YQD) = ( p%NumBStC<3 .or. p%NumBl<1 )
   InvalidOutput( BStC3_B1_ZQ) = ( p%NumBStC<3 .or. p%NumBl<1 )
   InvalidOutput(BStC3_B1_ZQD) = ( p%NumBStC<3 .or. p%NumBl<1 )
   InvalidOutput(BStC3_B1_Fxi) = ( p%NumBStC<3 .or. p%NumBl<1 )
   InvalidOutput(BStC3_B1_Fyi) = ( p%NumBStC<3 .or. p%NumBl<1 )
   InvalidOutput(BStC3_B1_Fzi) = ( p%NumBStC<3 .or. p%NumBl<1 )
   InvalidOutput(BStC3_B1_Mxi) = ( p%NumBStC<3 .or. p%NumBl<1 )
   InvalidOutput(BStC3_B1_Myi) = ( p%NumBStC<3 .or. p%NumBl<1 )
   InvalidOutput(BStC3_B1_Mzi) = ( p%NumBStC<3 .or. p%NumBl<1 )
   InvalidOutput(BStC3_B1_Fxl) = ( p%NumBStC<3 .or. p%NumBl<1 )
   InvalidOutput(BStC3_B1_Fyl) = ( p%NumBStC<3 .or. p%NumBl<1 )
   InvalidOutput(BStC3_B1_Fzl) = ( p%NumBStC<3 .or. p%NumBl<1 )
   InvalidOutput(BStC3_B1_Mxl) = ( p%NumBStC<3 .or. p%NumBl<1 )
   InvalidOutput(BStC3_B1_Myl) = ( p%NumBStC<3 .or. p%NumBl<1 )
   InvalidOutput(BStC3_B1_Mzl) = ( p%NumBStC<3 .or. p%NumBl<1 )
   InvalidOutput( BStC4_B1_XQ) = ( p%NumBStC<4 .or. p%NumBl<1 )
   InvalidOutput(BStC4_B1_XQD) = ( p%NumBStC<4 .or. p%NumBl<1 )
   InvalidOutput( BStC4_B1_YQ) = ( p%NumBStC<4 .or. p%NumBl<1 )
   InvalidOutput(BStC4_B1_YQD) = ( p%NumBStC<4 .or. p%NumBl<1 )
   InvalidOutput( BStC4_B1_ZQ) = ( p%NumBStC<4 .or. p%NumBl<1 )
   InvalidOutput(BStC4_B1_ZQD) = ( p%NumBStC<4 .or. p%NumBl<1 )
   InvalidOutput(BStC4_B1_Fxi) = ( p%NumBStC<4 .or. p%NumBl<1 )
   InvalidOutput(BStC4_B1_Fyi) = ( p%NumBStC<4 .or. p%NumBl<1 )
   InvalidOutput(BStC4_B1_Fzi) = ( p%NumBStC<4 .or. p%NumBl<1 )
   InvalidOutput(BStC4_B1_Mxi) = ( p%NumBStC<4 .or. p%NumBl<1 )
   InvalidOutput(BStC4_B1_Myi) = ( p%NumBStC<4 .or. p%NumBl<1 )
   InvalidOutput(BStC4_B1_Mzi) = ( p%NumBStC<4 .or. p%NumBl<1 )
   InvalidOutput(BStC4_B1_Fxl) = ( p%NumBStC<4 .or. p%NumBl<1 )
   InvalidOutput(BStC4_B1_Fyl) = ( p%NumBStC<4 .or. p%NumBl<1 )
   InvalidOutput(BStC4_B1_Fzl) = ( p%NumBStC<4 .or. p%NumBl<1 )
   InvalidOutput(BStC4_B1_Mxl) = ( p%NumBStC<4 .or. p%NumBl<1 )
   InvalidOutput(BStC4_B1_Myl) = ( p%NumBStC<4 .or. p%NumBl<1 )
   InvalidOutput(BStC4_B1_Mzl) = ( p%NumBStC<4 .or. p%NumBl<1 )
   InvalidOutput( BStC1_B2_XQ) = ( p%NumBStC<1 .or. p%NumBl<2 )
   InvalidOutput(BStC1_B2_XQD) = ( p%NumBStC<1 .or. p%NumBl<2 )
   InvalidOutput( BStC1_B2_YQ) = ( p%NumBStC<1 .or. p%NumBl<2 )
   InvalidOutput(BStC1_B2_YQD) = ( p%NumBStC<1 .or. p%NumBl<2 )
   InvalidOutput( BStC1_B2_ZQ) = ( p%NumBStC<1 .or. p%NumBl<2 )
   InvalidOutput(BStC1_B2_ZQD) = ( p%NumBStC<1 .or. p%NumBl<2 )
   InvalidOutput(BStC1_B2_Fxi) = ( p%NumBStC<1 .or. p%NumBl<2 )
   InvalidOutput(BStC1_B2_Fyi) = ( p%NumBStC<1 .or. p%NumBl<2 )
   InvalidOutput(BStC1_B2_Fzi) = ( p%NumBStC<1 .or. p%NumBl<2 )
   InvalidOutput(BStC1_B2_Mxi) = ( p%NumBStC<1 .or. p%NumBl<2 )
   InvalidOutput(BStC1_B2_Myi) = ( p%NumBStC<1 .or. p%NumBl<2 )
   InvalidOutput(BStC1_B2_Mzi) = ( p%NumBStC<1 .or. p%NumBl<2 )
   InvalidOutput(BStC1_B2_Fxl) = ( p%NumBStC<1 .or. p%NumBl<2 )
   InvalidOutput(BStC1_B2_Fyl) = ( p%NumBStC<1 .or. p%NumBl<2 )
   InvalidOutput(BStC1_B2_Fzl) = ( p%NumBStC<1 .or. p%NumBl<2 )
   InvalidOutput(BStC1_B2_Mxl) = ( p%NumBStC<1 .or. p%NumBl<2 )
   InvalidOutput(BStC1_B2_Myl) = ( p%NumBStC<1 .or. p%NumBl<2 )
   InvalidOutput(BStC1_B2_Mzl) = ( p%NumBStC<1 .or. p%NumBl<2 )
   InvalidOutput( BStC2_B2_XQ) = ( p%NumBStC<2 .or. p%NumBl<2 )
   InvalidOutput(BStC2_B2_XQD) = ( p%NumBStC<2 .or. p%NumBl<2 )
   InvalidOutput( BStC2_B2_YQ) = ( p%NumBStC<2 .or. p%NumBl<2 )
   InvalidOutput(BStC2_B2_YQD) = ( p%NumBStC<2 .or. p%NumBl<2 )
   InvalidOutput( BStC2_B2_ZQ) = ( p%NumBStC<2 .or. p%NumBl<2 )
   InvalidOutput(BStC2_B2_ZQD) = ( p%NumBStC<2 .or. p%NumBl<2 )
   InvalidOutput(BStC2_B2_Fxi) = ( p%NumBStC<2 .or. p%NumBl<2 )
   InvalidOutput(BStC2_B2_Fyi) = ( p%NumBStC<2 .or. p%NumBl<2 )
   InvalidOutput(BStC2_B2_Fzi) = ( p%NumBStC<2 .or. p%NumBl<2 )
   InvalidOutput(BStC2_B2_Mxi) = ( p%NumBStC<2 .or. p%NumBl<2 )
   InvalidOutput(BStC2_B2_Myi) = ( p%NumBStC<2 .or. p%NumBl<2 )
   InvalidOutput(BStC2_B2_Mzi) = ( p%NumBStC<2 .or. p%NumBl<2 )
   InvalidOutput(BStC2_B2_Fxl) = ( p%NumBStC<2 .or. p%NumBl<2 )
   InvalidOutput(BStC2_B2_Fyl) = ( p%NumBStC<2 .or. p%NumBl<2 )
   InvalidOutput(BStC2_B2_Fzl) = ( p%NumBStC<2 .or. p%NumBl<2 )
   InvalidOutput(BStC2_B2_Mxl) = ( p%NumBStC<2 .or. p%NumBl<2 )
   InvalidOutput(BStC2_B2_Myl) = ( p%NumBStC<2 .or. p%NumBl<2 )
   InvalidOutput(BStC2_B2_Mzl) = ( p%NumBStC<2 .or. p%NumBl<2 )
   InvalidOutput( BStC3_B2_XQ) = ( p%NumBStC<3 .or. p%NumBl<2 )
   InvalidOutput(BStC3_B2_XQD) = ( p%NumBStC<3 .or. p%NumBl<2 )
   InvalidOutput( BStC3_B2_YQ) = ( p%NumBStC<3 .or. p%NumBl<2 )
   InvalidOutput(BStC3_B2_YQD) = ( p%NumBStC<3 .or. p%NumBl<2 )
   InvalidOutput( BStC3_B2_ZQ) = ( p%NumBStC<3 .or. p%NumBl<2 )
   InvalidOutput(BStC3_B2_ZQD) = ( p%NumBStC<3 .or. p%NumBl<2 )
   InvalidOutput(BStC3_B2_Fxi) = ( p%NumBStC<3 .or. p%NumBl<2 )
   InvalidOutput(BStC3_B2_Fyi) = ( p%NumBStC<3 .or. p%NumBl<2 )
   InvalidOutput(BStC3_B2_Fzi) = ( p%NumBStC<3 .or. p%NumBl<2 )
   InvalidOutput(BStC3_B2_Mxi) = ( p%NumBStC<3 .or. p%NumBl<2 )
   InvalidOutput(BStC3_B2_Myi) = ( p%NumBStC<3 .or. p%NumBl<2 )
   InvalidOutput(BStC3_B2_Mzi) = ( p%NumBStC<3 .or. p%NumBl<2 )
   InvalidOutput(BStC3_B2_Fxl) = ( p%NumBStC<3 .or. p%NumBl<2 )
   InvalidOutput(BStC3_B2_Fyl) = ( p%NumBStC<3 .or. p%NumBl<2 )
   InvalidOutput(BStC3_B2_Fzl) = ( p%NumBStC<3 .or. p%NumBl<2 )
   InvalidOutput(BStC3_B2_Mxl) = ( p%NumBStC<3 .or. p%NumBl<2 )
   InvalidOutput(BStC3_B2_Myl) = ( p%NumBStC<3 .or. p%NumBl<2 )
   InvalidOutput(BStC3_B2_Mzl) = ( p%NumBStC<3 .or. p%NumBl<2 )
   InvalidOutput( BStC4_B2_XQ) = ( p%NumBStC<4 .or. p%NumBl<2 )
   InvalidOutput(BStC4_B2_XQD) = ( p%NumBStC<4 .or. p%NumBl<2 )
   InvalidOutput( BStC4_B2_YQ) = ( p%NumBStC<4 .or. p%NumBl<2 )
   InvalidOutput(BStC4_B2_YQD) = ( p%NumBStC<4 .or. p%NumBl<2 )
   InvalidOutput( BStC4_B2_ZQ) = ( p%NumBStC<4 .or. p%NumBl<2 )
   InvalidOutput(BStC4_B2_ZQD) = ( p%NumBStC<4 .or. p%NumBl<2 )
   InvalidOutput(BStC4_B2_Fxi) = ( p%NumBStC<4 .or. p%NumBl<2 )
   InvalidOutput(BStC4_B2_Fyi) = ( p%NumBStC<4 .or. p%NumBl<2 )
   InvalidOutput(BStC4_B2_Fzi) = ( p%NumBStC<4 .or. p%NumBl<2 )
   InvalidOutput(BStC4_B2_Mxi) = ( p%NumBStC<4 .or. p%NumBl<2 )
   InvalidOutput(BStC4_B2_Myi) = ( p%NumBStC<4 .or. p%NumBl<2 )
   InvalidOutput(BStC4_B2_Mzi) = ( p%NumBStC<4 .or. p%NumBl<2 )
   InvalidOutput(BStC4_B2_Fxl) = ( p%NumBStC<4 .or. p%NumBl<2 )
   InvalidOutput(BStC4_B2_Fyl) = ( p%NumBStC<4 .or. p%NumBl<2 )
   InvalidOutput(BStC4_B2_Fzl) = ( p%NumBStC<4 .or. p%NumBl<2 )
   InvalidOutput(BStC4_B2_Mxl) = ( p%NumBStC<4 .or. p%NumBl<2 )
   InvalidOutput(BStC4_B2_Myl) = ( p%NumBStC<4 .or. p%NumBl<2 )
   InvalidOutput(BStC4_B2_Mzl) = ( p%NumBStC<4 .or. p%NumBl<2 )
   InvalidOutput( BStC1_B3_XQ) = ( p%NumBStC<1 .or. p%NumBl<3 )
   InvalidOutput(BStC1_B3_XQD) = ( p%NumBStC<1 .or. p%NumBl<3 )
   InvalidOutput( BStC1_B3_YQ) = ( p%NumBStC<1 .or. p%NumBl<3 )
   InvalidOutput(BStC1_B3_YQD) = ( p%NumBStC<1 .or. p%NumBl<3 )
   InvalidOutput( BStC1_B3_ZQ) = ( p%NumBStC<1 .or. p%NumBl<3 )
   InvalidOutput(BStC1_B3_ZQD) = ( p%NumBStC<1 .or. p%NumBl<3 )
   InvalidOutput(BStC1_B3_Fxi) = ( p%NumBStC<1 .or. p%NumBl<3 )
   InvalidOutput(BStC1_B3_Fyi) = ( p%NumBStC<1 .or. p%NumBl<3 )
   InvalidOutput(BStC1_B3_Fzi) = ( p%NumBStC<1 .or. p%NumBl<3 )
   InvalidOutput(BStC1_B3_Mxi) = ( p%NumBStC<1 .or. p%NumBl<3 )
   InvalidOutput(BStC1_B3_Myi) = ( p%NumBStC<1 .or. p%NumBl<3 )
   InvalidOutput(BStC1_B3_Mzi) = ( p%NumBStC<1 .or. p%NumBl<3 )
   InvalidOutput(BStC1_B3_Fxl) = ( p%NumBStC<1 .or. p%NumBl<3 )
   InvalidOutput(BStC1_B3_Fyl) = ( p%NumBStC<1 .or. p%NumBl<3 )
   InvalidOutput(BStC1_B3_Fzl) = ( p%NumBStC<1 .or. p%NumBl<3 )
   InvalidOutput(BStC1_B3_Mxl) = ( p%NumBStC<1 .or. p%NumBl<3 )
   InvalidOutput(BStC1_B3_Myl) = ( p%NumBStC<1 .or. p%NumBl<3 )
   InvalidOutput(BStC1_B3_Mzl) = ( p%NumBStC<1 .or. p%NumBl<3 )
   InvalidOutput( BStC2_B3_XQ) = ( p%NumBStC<2 .or. p%NumBl<3 )
   InvalidOutput(BStC2_B3_XQD) = ( p%NumBStC<2 .or. p%NumBl<3 )
   InvalidOutput( BStC2_B3_YQ) = ( p%NumBStC<2 .or. p%NumBl<3 )
   InvalidOutput(BStC2_B3_YQD) = ( p%NumBStC<2 .or. p%NumBl<3 )
   InvalidOutput( BStC2_B3_ZQ) = ( p%NumBStC<2 .or. p%NumBl<3 )
   InvalidOutput(BStC2_B3_ZQD) = ( p%NumBStC<2 .or. p%NumBl<3 )
   InvalidOutput(BStC2_B3_Fxi) = ( p%NumBStC<2 .or. p%NumBl<3 )
   InvalidOutput(BStC2_B3_Fyi) = ( p%NumBStC<2 .or. p%NumBl<3 )
   InvalidOutput(BStC2_B3_Fzi) = ( p%NumBStC<2 .or. p%NumBl<3 )
   InvalidOutput(BStC2_B3_Mxi) = ( p%NumBStC<2 .or. p%NumBl<3 )
   InvalidOutput(BStC2_B3_Myi) = ( p%NumBStC<2 .or. p%NumBl<3 )
   InvalidOutput(BStC2_B3_Mzi) = ( p%NumBStC<2 .or. p%NumBl<3 )
   InvalidOutput(BStC2_B3_Fxl) = ( p%NumBStC<2 .or. p%NumBl<3 )
   InvalidOutput(BStC2_B3_Fyl) = ( p%NumBStC<2 .or. p%NumBl<3 )
   InvalidOutput(BStC2_B3_Fzl) = ( p%NumBStC<2 .or. p%NumBl<3 )
   InvalidOutput(BStC2_B3_Mxl) = ( p%NumBStC<2 .or. p%NumBl<3 )
   InvalidOutput(BStC2_B3_Myl) = ( p%NumBStC<2 .or. p%NumBl<3 )
   InvalidOutput(BStC2_B3_Mzl) = ( p%NumBStC<2 .or. p%NumBl<3 )
   InvalidOutput( BStC3_B3_XQ) = ( p%NumBStC<3 .or. p%NumBl<3 )
   InvalidOutput(BStC3_B3_XQD) = ( p%NumBStC<3 .or. p%NumBl<3 )
   InvalidOutput( BStC3_B3_YQ) = ( p%NumBStC<3 .or. p%NumBl<3 )
   InvalidOutput(BStC3_B3_YQD) = ( p%NumBStC<3 .or. p%NumBl<3 )
   InvalidOutput( BStC3_B3_ZQ) = ( p%NumBStC<3 .or. p%NumBl<3 )
   InvalidOutput(BStC3_B3_ZQD) = ( p%NumBStC<3 .or. p%NumBl<3 )
   InvalidOutput(BStC3_B3_Fxi) = ( p%NumBStC<3 .or. p%NumBl<3 )
   InvalidOutput(BStC3_B3_Fyi) = ( p%NumBStC<3 .or. p%NumBl<3 )
   InvalidOutput(BStC3_B3_Fzi) = ( p%NumBStC<3 .or. p%NumBl<3 )
   InvalidOutput(BStC3_B3_Mxi) = ( p%NumBStC<3 .or. p%NumBl<3 )
   InvalidOutput(BStC3_B3_Myi) = ( p%NumBStC<3 .or. p%NumBl<3 )
   InvalidOutput(BStC3_B3_Mzi) = ( p%NumBStC<3 .or. p%NumBl<3 )
   InvalidOutput(BStC3_B3_Fxl) = ( p%NumBStC<3 .or. p%NumBl<3 )
   InvalidOutput(BStC3_B3_Fyl) = ( p%NumBStC<3 .or. p%NumBl<3 )
   InvalidOutput(BStC3_B3_Fzl) = ( p%NumBStC<3 .or. p%NumBl<3 )
   InvalidOutput(BStC3_B3_Mxl) = ( p%NumBStC<3 .or. p%NumBl<3 )
   InvalidOutput(BStC3_B3_Myl) = ( p%NumBStC<3 .or. p%NumBl<3 )
   InvalidOutput(BStC3_B3_Mzl) = ( p%NumBStC<3 .or. p%NumBl<3 )
   InvalidOutput( BStC4_B3_XQ) = ( p%NumBStC<4 .or. p%NumBl<3 )
   InvalidOutput(BStC4_B3_XQD) = ( p%NumBStC<4 .or. p%NumBl<3 )
   InvalidOutput( BStC4_B3_YQ) = ( p%NumBStC<4 .or. p%NumBl<3 )
   InvalidOutput(BStC4_B3_YQD) = ( p%NumBStC<4 .or. p%NumBl<3 )
   InvalidOutput( BStC4_B3_ZQ) = ( p%NumBStC<4 .or. p%NumBl<3 )
   InvalidOutput(BStC4_B3_ZQD) = ( p%NumBStC<4 .or. p%NumBl<3 )
   InvalidOutput(BStC4_B3_Fxi) = ( p%NumBStC<4 .or. p%NumBl<3 )
   InvalidOutput(BStC4_B3_Fyi) = ( p%NumBStC<4 .or. p%NumBl<3 )
   InvalidOutput(BStC4_B3_Fzi) = ( p%NumBStC<4 .or. p%NumBl<3 )
   InvalidOutput(BStC4_B3_Mxi) = ( p%NumBStC<4 .or. p%NumBl<3 )
   InvalidOutput(BStC4_B3_Myi) = ( p%NumBStC<4 .or. p%NumBl<3 )
   InvalidOutput(BStC4_B3_Mzi) = ( p%NumBStC<4 .or. p%NumBl<3 )
   InvalidOutput(BStC4_B3_Fxl) = ( p%NumBStC<4 .or. p%NumBl<3 )
   InvalidOutput(BStC4_B3_Fyl) = ( p%NumBStC<4 .or. p%NumBl<3 )
   InvalidOutput(BStC4_B3_Fzl) = ( p%NumBStC<4 .or. p%NumBl<3 )
   InvalidOutput(BStC4_B3_Mxl) = ( p%NumBStC<4 .or. p%NumBl<3 )
   InvalidOutput(BStC4_B3_Myl) = ( p%NumBStC<4 .or. p%NumBl<3 )
   InvalidOutput(BStC4_B3_Mzl) = ( p%NumBStC<4 .or. p%NumBl<3 )
   InvalidOutput( BStC1_B4_XQ) = ( p%NumBStC<1 .or. p%NumBl<4 )
   InvalidOutput(BStC1_B4_XQD) = ( p%NumBStC<1 .or. p%NumBl<4 )
   InvalidOutput( BStC1_B4_YQ) = ( p%NumBStC<1 .or. p%NumBl<4 )
   InvalidOutput(BStC1_B4_YQD) = ( p%NumBStC<1 .or. p%NumBl<4 )
   InvalidOutput( BStC1_B4_ZQ) = ( p%NumBStC<1 .or. p%NumBl<4 )
   InvalidOutput(BStC1_B4_ZQD) = ( p%NumBStC<1 .or. p%NumBl<4 )
   InvalidOutput(BStC1_B4_Fxi) = ( p%NumBStC<1 .or. p%NumBl<4 )
   InvalidOutput(BStC1_B4_Fyi) = ( p%NumBStC<1 .or. p%NumBl<4 )
   InvalidOutput(BStC1_B4_Fzi) = ( p%NumBStC<1 .or. p%NumBl<4 )
   InvalidOutput(BStC1_B4_Mxi) = ( p%NumBStC<1 .or. p%NumBl<4 )
   InvalidOutput(BStC1_B4_Myi) = ( p%NumBStC<1 .or. p%NumBl<4 )
   InvalidOutput(BStC1_B4_Mzi) = ( p%NumBStC<1 .or. p%NumBl<4 )
   InvalidOutput(BStC1_B4_Fxl) = ( p%NumBStC<1 .or. p%NumBl<4 )
   InvalidOutput(BStC1_B4_Fyl) = ( p%NumBStC<1 .or. p%NumBl<4 )
   InvalidOutput(BStC1_B4_Fzl) = ( p%NumBStC<1 .or. p%NumBl<4 )
   InvalidOutput(BStC1_B4_Mxl) = ( p%NumBStC<1 .or. p%NumBl<4 )
   InvalidOutput(BStC1_B4_Myl) = ( p%NumBStC<1 .or. p%NumBl<4 )
   InvalidOutput(BStC1_B4_Mzl) = ( p%NumBStC<1 .or. p%NumBl<4 )
   InvalidOutput( BStC2_B4_XQ) = ( p%NumBStC<2 .or. p%NumBl<4 )
   InvalidOutput(BStC2_B4_XQD) = ( p%NumBStC<2 .or. p%NumBl<4 )
   InvalidOutput( BStC2_B4_YQ) = ( p%NumBStC<2 .or. p%NumBl<4 )
   InvalidOutput(BStC2_B4_YQD) = ( p%NumBStC<2 .or. p%NumBl<4 )
   InvalidOutput( BStC2_B4_ZQ) = ( p%NumBStC<2 .or. p%NumBl<4 )
   InvalidOutput(BStC2_B4_ZQD) = ( p%NumBStC<2 .or. p%NumBl<4 )
   InvalidOutput(BStC2_B4_Fxi) = ( p%NumBStC<2 .or. p%NumBl<4 )
   InvalidOutput(BStC2_B4_Fyi) = ( p%NumBStC<2 .or. p%NumBl<4 )
   InvalidOutput(BStC2_B4_Fzi) = ( p%NumBStC<2 .or. p%NumBl<4 )
   InvalidOutput(BStC2_B4_Mxi) = ( p%NumBStC<2 .or. p%NumBl<4 )
   InvalidOutput(BStC2_B4_Myi) = ( p%NumBStC<2 .or. p%NumBl<4 )
   InvalidOutput(BStC2_B4_Mzi) = ( p%NumBStC<2 .or. p%NumBl<4 )
   InvalidOutput(BStC2_B4_Fxl) = ( p%NumBStC<2 .or. p%NumBl<4 )
   InvalidOutput(BStC2_B4_Fyl) = ( p%NumBStC<2 .or. p%NumBl<4 )
   InvalidOutput(BStC2_B4_Fzl) = ( p%NumBStC<2 .or. p%NumBl<4 )
   InvalidOutput(BStC2_B4_Mxl) = ( p%NumBStC<2 .or. p%NumBl<4 )
   InvalidOutput(BStC2_B4_Myl) = ( p%NumBStC<2 .or. p%NumBl<4 )
   InvalidOutput(BStC2_B4_Mzl) = ( p%NumBStC<2 .or. p%NumBl<4 )
   InvalidOutput( BStC3_B4_XQ) = ( p%NumBStC<3 .or. p%NumBl<4 )
   InvalidOutput(BStC3_B4_XQD) = ( p%NumBStC<3 .or. p%NumBl<4 )
   InvalidOutput( BStC3_B4_YQ) = ( p%NumBStC<3 .or. p%NumBl<4 )
   InvalidOutput(BStC3_B4_YQD) = ( p%NumBStC<3 .or. p%NumBl<4 )
   InvalidOutput( BStC3_B4_ZQ) = ( p%NumBStC<3 .or. p%NumBl<4 )
   InvalidOutput(BStC3_B4_ZQD) = ( p%NumBStC<3 .or. p%NumBl<4 )
   InvalidOutput(BStC3_B4_Fxi) = ( p%NumBStC<3 .or. p%NumBl<4 )
   InvalidOutput(BStC3_B4_Fyi) = ( p%NumBStC<3 .or. p%NumBl<4 )
   InvalidOutput(BStC3_B4_Fzi) = ( p%NumBStC<3 .or. p%NumBl<4 )
   InvalidOutput(BStC3_B4_Mxi) = ( p%NumBStC<3 .or. p%NumBl<4 )
   InvalidOutput(BStC3_B4_Myi) = ( p%NumBStC<3 .or. p%NumBl<4 )
   InvalidOutput(BStC3_B4_Mzi) = ( p%NumBStC<3 .or. p%NumBl<4 )
   InvalidOutput(BStC3_B4_Fxl) = ( p%NumBStC<3 .or. p%NumBl<4 )
   InvalidOutput(BStC3_B4_Fyl) = ( p%NumBStC<3 .or. p%NumBl<4 )
   InvalidOutput(BStC3_B4_Fzl) = ( p%NumBStC<3 .or. p%NumBl<4 )
   InvalidOutput(BStC3_B4_Mxl) = ( p%NumBStC<3 .or. p%NumBl<4 )
   InvalidOutput(BStC3_B4_Myl) = ( p%NumBStC<3 .or. p%NumBl<4 )
   InvalidOutput(BStC3_B4_Mzl) = ( p%NumBStC<3 .or. p%NumBl<4 )
   InvalidOutput( BStC4_B4_XQ) = ( p%NumBStC<4 .or. p%NumBl<4 )
   InvalidOutput(BStC4_B4_XQD) = ( p%NumBStC<4 .or. p%NumBl<4 )
   InvalidOutput( BStC4_B4_YQ) = ( p%NumBStC<4 .or. p%NumBl<4 )
   InvalidOutput(BStC4_B4_YQD) = ( p%NumBStC<4 .or. p%NumBl<4 )
   InvalidOutput( BStC4_B4_ZQ) = ( p%NumBStC<4 .or. p%NumBl<4 )
   InvalidOutput(BStC4_B4_ZQD) = ( p%NumBStC<4 .or. p%NumBl<4 )
   InvalidOutput(BStC4_B4_Fxi) = ( p%NumBStC<4 .or. p%NumBl<4 )
   InvalidOutput(BStC4_B4_Fyi) = ( p%NumBStC<4 .or. p%NumBl<4 )
   InvalidOutput(BStC4_B4_Fzi) = ( p%NumBStC<4 .or. p%NumBl<4 )
   InvalidOutput(BStC4_B4_Mxi) = ( p%NumBStC<4 .or. p%NumBl<4 )
   InvalidOutput(BStC4_B4_Myi) = ( p%NumBStC<4 .or. p%NumBl<4 )
   InvalidOutput(BStC4_B4_Mzi) = ( p%NumBStC<4 .or. p%NumBl<4 )
   InvalidOutput(BStC4_B4_Fxl) = ( p%NumBStC<4 .or. p%NumBl<4 )
   InvalidOutput(BStC4_B4_Fyl) = ( p%NumBStC<4 .or. p%NumBl<4 )
   InvalidOutput(BStC4_B4_Fzl) = ( p%NumBStC<4 .or. p%NumBl<4 )
   InvalidOutput(BStC4_B4_Mxl) = ( p%NumBStC<4 .or. p%NumBl<4 )
   InvalidOutput(BStC4_B4_Myl) = ( p%NumBStC<4 .or. p%NumBl<4 )
   InvalidOutput(BStC4_B4_Mzl) = ( p%NumBStC<4 .or. p%NumBl<4 )
   InvalidOutput(    SStC1_XQ) = ( p%NumSStC<1 )
   InvalidOutput(   SStC1_XQD) = ( p%NumSStC<1 )
   InvalidOutput(    SStC1_YQ) = ( p%NumSStC<1 )
   InvalidOutput(   SStC1_YQD) = ( p%NumSStC<1 )
   InvalidOutput(    SStC1_ZQ) = ( p%NumSStC<1 )
   InvalidOutput(   SStC1_ZQD) = ( p%NumSStC<1 )
   InvalidOutput(   SStC1_Fxi) = ( p%NumSStC<1 )
   InvalidOutput(   SStC1_Fyi) = ( p%NumSStC<1 )
   InvalidOutput(   SStC1_Fzi) = ( p%NumSStC<1 )
   InvalidOutput(   SStC1_Mxi) = ( p%NumSStC<1 )
   InvalidOutput(   SStC1_Myi) = ( p%NumSStC<1 )
   InvalidOutput(   SStC1_Mzi) = ( p%NumSStC<1 )
   InvalidOutput(   SStC1_Fxl) = ( p%NumSStC<1 )
   InvalidOutput(   SStC1_Fyl) = ( p%NumSStC<1 )
   InvalidOutput(   SStC1_Fzl) = ( p%NumSStC<1 )
   InvalidOutput(   SStC1_Mxl) = ( p%NumSStC<1 )
   InvalidOutput(   SStC1_Myl) = ( p%NumSStC<1 )
   InvalidOutput(   SStC1_Mzl) = ( p%NumSStC<1 )
   InvalidOutput(    SStC2_XQ) = ( p%NumSStC<2 )
   InvalidOutput(   SStC2_XQD) = ( p%NumSStC<2 )
   InvalidOutput(    SStC2_YQ) = ( p%NumSStC<2 )
   InvalidOutput(   SStC2_YQD) = ( p%NumSStC<2 )
   InvalidOutput(    SStC2_ZQ) = ( p%NumSStC<2 )
   InvalidOutput(   SStC2_ZQD) = ( p%NumSStC<2 )
   InvalidOutput(   SStC2_Fxi) = ( p%NumSStC<2 )
   InvalidOutput(   SStC2_Fyi) = ( p%NumSStC<2 )
   InvalidOutput(   SStC2_Fzi) = ( p%NumSStC<2 )
   InvalidOutput(   SStC2_Mxi) = ( p%NumSStC<2 )
   InvalidOutput(   SStC2_Myi) = ( p%NumSStC<2 )
   InvalidOutput(   SStC2_Mzi) = ( p%NumSStC<2 )
   InvalidOutput(   SStC2_Fxl) = ( p%NumSStC<2 )
   InvalidOutput(   SStC2_Fyl) = ( p%NumSStC<2 )
   InvalidOutput(   SStC2_Fzl) = ( p%NumSStC<2 )
   InvalidOutput(   SStC2_Mxl) = ( p%NumSStC<2 )
   InvalidOutput(   SStC2_Myl) = ( p%NumSStC<2 )
   InvalidOutput(   SStC2_Mzl) = ( p%NumSStC<2 )
   InvalidOutput(    SStC3_XQ) = ( p%NumSStC<3 )
   InvalidOutput(   SStC3_XQD) = ( p%NumSStC<3 )
   InvalidOutput(    SStC3_YQ) = ( p%NumSStC<3 )
   InvalidOutput(   SStC3_YQD) = ( p%NumSStC<3 )
   InvalidOutput(    SStC3_ZQ) = ( p%NumSStC<3 )
   InvalidOutput(   SStC3_ZQD) = ( p%NumSStC<3 )
   InvalidOutput(   SStC3_Fxi) = ( p%NumSStC<3 )
   InvalidOutput(   SStC3_Fyi) = ( p%NumSStC<3 )
   InvalidOutput(   SStC3_Fzi) = ( p%NumSStC<3 )
   InvalidOutput(   SStC3_Mxi) = ( p%NumSStC<3 )
   InvalidOutput(   SStC3_Myi) = ( p%NumSStC<3 )
   InvalidOutput(   SStC3_Mzi) = ( p%NumSStC<3 )
   InvalidOutput(   SStC3_Fxl) = ( p%NumSStC<3 )
   InvalidOutput(   SStC3_Fyl) = ( p%NumSStC<3 )
   InvalidOutput(   SStC3_Fzl) = ( p%NumSStC<3 )
   InvalidOutput(   SStC3_Mxl) = ( p%NumSStC<3 )
   InvalidOutput(   SStC3_Myl) = ( p%NumSStC<3 )
   InvalidOutput(   SStC3_Mzl) = ( p%NumSStC<3 )
   InvalidOutput(    SStC4_XQ) = ( p%NumSStC<4 )
   InvalidOutput(   SStC4_XQD) = ( p%NumSStC<4 )
   InvalidOutput(    SStC4_YQ) = ( p%NumSStC<4 )
   InvalidOutput(   SStC4_YQD) = ( p%NumSStC<4 )
   InvalidOutput(    SStC4_ZQ) = ( p%NumSStC<4 )
   InvalidOutput(   SStC4_ZQD) = ( p%NumSStC<4 )
   InvalidOutput(   SStC4_Fxi) = ( p%NumSStC<4 )
   InvalidOutput(   SStC4_Fyi) = ( p%NumSStC<4 )
   InvalidOutput(   SStC4_Fzi) = ( p%NumSStC<4 )
   InvalidOutput(   SStC4_Mxi) = ( p%NumSStC<4 )
   InvalidOutput(   SStC4_Myi) = ( p%NumSStC<4 )
   InvalidOutput(   SStC4_Mzi) = ( p%NumSStC<4 )
   InvalidOutput(   SStC4_Fxl) = ( p%NumSStC<4 )
   InvalidOutput(   SStC4_Fyl) = ( p%NumSStC<4 )
   InvalidOutput(   SStC4_Fzl) = ( p%NumSStC<4 )
   InvalidOutput(   SStC4_Mxl) = ( p%NumSStC<4 )
   InvalidOutput(   SStC4_Myl) = ( p%NumSStC<4 )
   InvalidOutput(   SStC4_Mzl) = ( p%NumSStC<4 )


   !-------------------------------------------------------------------------------------------------
   ! Allocate and set index, name, and units for the output channels
   ! If a selected output channel is not available in this module, set error flag.
   !-------------------------------------------------------------------------------------------------

   ALLOCATE ( p%OutParam(0:p%NumOuts) , STAT=ErrStat2 )
   IF ( ErrStat2 /= 0_IntKi )  THEN
      CALL SetErrStat( ErrID_Fatal,"Error allocating memory for the ServoDyn OutParam array.", ErrStat, ErrMsg, RoutineName )
      RETURN
   ENDIF

      ! Set index, name, and units for the time output channel:

   p%OutParam(0)%Indx  = Time
   p%OutParam(0)%Name  = "Time"    ! OutParam(0) is the time channel by default.
   p%OutParam(0)%Units = "(s)"
   p%OutParam(0)%SignM = 1


      ! Set index, name, and units for all of the output channels.
      ! If a selected output channel is not available by this module set ErrStat = ErrID_Warn.

   DO I = 1,p%NumOuts

      p%OutParam(I)%Name  = OutList(I)
      OutListTmp          = OutList(I)

      ! Reverse the sign (+/-) of the output channel if the user prefixed the
      !   channel name with a "-", "_", "m", or "M" character indicating "minus".


      CheckOutListAgain = .FALSE.

      IF      ( INDEX( "-_", OutListTmp(1:1) ) > 0 ) THEN
         p%OutParam(I)%SignM = -1                         ! ex, "-TipDxc1" causes the sign of TipDxc1 to be switched.
         OutListTmp          = OutListTmp(2:)
      ELSE IF ( INDEX( "mM", OutListTmp(1:1) ) > 0 ) THEN ! We'll assume this is a variable name for now, (if not, we will check later if OutListTmp(2:) is also a variable name)
         CheckOutListAgain   = .TRUE.
         p%OutParam(I)%SignM = 1
      ELSE
         p%OutParam(I)%SignM = 1
      END IF

      CALL Conv2UC( OutListTmp )    ! Convert OutListTmp to upper case


      Indx = IndexCharAry( OutListTmp(1:OutStrLenM1), ValidParamAry )


         ! If it started with an "M" (CheckOutListAgain) we didn't find the value in our list (Indx < 1)

      IF ( CheckOutListAgain .AND. Indx < 1 ) THEN    ! Let's assume that "M" really meant "minus" and then test again
         p%OutParam(I)%SignM = -1                     ! ex, "MTipDxc1" causes the sign of TipDxc1 to be switched.
         OutListTmp          = OutListTmp(2:)

         Indx = IndexCharAry( OutListTmp(1:OutStrLenM1), ValidParamAry )
      END IF


      IF ( Indx > 0 ) THEN ! we found the channel name
         IF ( InvalidOutput( ParamIndxAry(Indx) ) ) THEN  ! but, it isn't valid for these settings
            p%OutParam(I)%Indx  = ParamIndxAry(Indx)  ! don't reset the index -- causes issues in linearization
            p%OutParam(I)%Units = "INVALID"
            p%OutParam(I)%SignM = 0
         ELSE
            p%OutParam(I)%Indx  = ParamIndxAry(Indx)
            p%OutParam(I)%Units = ParamUnitsAry(Indx) ! it's a valid output
         END IF
      ELSE ! this channel isn't valid
         p%OutParam(I)%Indx  = 0                    ! pick any valid channel (I just picked "Time=0" here because it's universal)
         p%OutParam(I)%Units = "INVALID"
         p%OutParam(I)%SignM = 0                    ! multiply all results by zero

         CALL SetErrStat(ErrID_Fatal, TRIM(p%OutParam(I)%Name)//" is not an available output channel.",ErrStat,ErrMsg,RoutineName)
      END IF

   END DO

   RETURN
END SUBROUTINE SetOutParam
!----------------------------------------------------------------------------------------------------------------------------------
!End of code generated by Matlab script
!**********************************************************************************************************************************


!====================================================================================================
subroutine InitializeSummaryFile(InputFileData,OutfileRoot,UnSum,ErrStat,ErrMsg)
   type(SrvD_InputFile),   intent(in   )  :: InputFileData  !< Data stored in the module's input file
   character(*),           intent(in   )  :: OutFileRoot    !< Rootname (including path) for writing summary file
   integer(IntKi),         intent(inout)  :: UnSum          !< summary file number (>0 when set)
   integer(IntKi),         intent(  out)  :: ErrStat        !< The error status code
   character(ErrMsgLen),   intent(  out)  :: ErrMsg         !< The error message, if an error occurred
   integer(IntKi)                         :: ErrStat2       ! Temporary error ID
   character(ErrMsgLen)                   :: ErrMsg2        ! Temporary message describing error
   character(*), parameter                :: RoutineName = 'InitializeSummaryFile'
   ! init vars
   ErrStat  =  ErrID_None
   ErrMsg   =  ''
   if ( InputFileData%SumPrint ) then
      !$OMP critical(fileopen_critical)
      call GetNewUnit( UnSum )
      CALL OpenEcho ( UnSum, TRIM(OutFileRoot)//'.sum', ErrStat2, ErrMsg2 )
      !$OMP end critical(fileopen_critical)
         CALL SetErrStat(ErrStat2,ErrMsg2,ErrStat,ErrMsg,RoutineName)
      IF (ErrStat >= AbortErrLev) RETURN
   else
      return
   endif
   ! Put some header info into the summary file
   WRITE (UnSum,'(/,A/)', IOSTAT=ErrStat2)  'This summary file was generated by ServoDyn'//&
         ' on '//CurDate()//' at '//CurTime()//'.'
end subroutine InitializeSummaryFile
!====================================================================================================
subroutine SrvD_CloseSum( UnSum, ErrStat, ErrMsg )
   integer,                intent(inout)  :: UnSum          ! the unit number for the SubDyn summary file
   integer,                intent(  out)  :: ErrStat        ! returns a non-zero value when an error occurs
   character(*),           intent(  out)  :: ErrMsg         ! Error message if ErrStat /= ErrID_None
   ! Local variables
   integer                                :: Stat           ! status from I/) operation
   ErrStat = ErrID_None
   ErrMsg  = ""
   ! Write any closing information in the summary file
   IF ( UnSum > 0 ) THEN
      WRITE (UnSum,'(/,A/)', IOSTAT=Stat)  'This summary file was closed on '//CurDate()//' at '//CurTime()//'.'
      IF (Stat /= 0) THEN
         ErrStat = ErrID_FATAL
         ErrMsg  = ' Problem writing to summary file.'
      END IF
      ! Close the file
      CLOSE( UnSum, IOSTAT=Stat )
      IF (Stat /= 0) THEN
         ErrStat = ErrID_FATAL
         ErrMsg  = TRIM(ErrMsg)//' Problem closing summary file.'
      END IF
      IF ( ErrStat /= ErrID_None ) ErrMsg = 'SrvD_CloseSum'//TRIM(ErrMsg)
      UnSum=-1
   END IF
end subroutine SrvD_CloseSum
!====================================================================================================
!> Write info about the simulink interface to the summary file if compiled for Simulink
!!       NOTE: Check the FAST_Library.f90 file for the authority on this!!!!  This file could be out of date!!!!
subroutine WrSumInfo4Simulink(p,SimulinkCtrlMode,UnSum)
   type(SrvD_ParameterType),     intent(in   )  :: p                 !< Parameters
   integer,                      intent(in   )  :: SimulinkCtrlMode  !< ControlMode_EXTERN value (we don't have that in here)
   integer,                      intent(in   )  :: UnSum             ! the unit number for the SubDyn summary file

   if (UnSum > 0) then
      write(UnSum, '(A)') ''
      write(UnSum, '(A)') SectionDivide
      write(UnSum, '(A)')              ' Simulink Interface used for:'
      call WrCtrlInfo( p%YCMode     ==SimulinkCtrlMode,'Nacelle yaw control           ','(YawPosCom,YawRateCom)        ')
      call WrCtrlInfo( p%YCMode     ==SimulinkCtrlMode,'Nacelle yaw control           ','(YawPosCom,YawRateCom)        ')
      call WrCtrlInfo( p%PCMode     ==SimulinkCtrlMode,'Blade pitch cotrol            ','(BlPitchCom)                  ')
      call WrCtrlInfo( p%VSContrl   ==SimulinkCtrlMode,'Variable generator speed      ','(GenTrq,ElecPwr)              ')
      call WrCtrlInfo( p%HSSBrMode  ==SimulinkCtrlMode,'High speed shaft brake        ','(HSSBrFrac)                   ')
      call WrCtrlInfo( p%AfCmode    ==SimulinkCtrlMode,'Airfoil commands (flaps)      ','(BlAirfoilCom)                ')
      call WrCtrlInfo( p%CCmode     ==SimulinkCtrlMode,'Cable actuator control        ','(CableDeltaL,CableDeltaLdot)  ')
      write(UnSum, '(A)') ''
      write(UnSum, '(A)') '      Simulink inteface to OpenFAST library InputAry:'
      write(UnSum, '(A)') '           (check FAST_Library.f90 if errors)        '
      write(UnSum, '(A)') ''
      write(UnSum, '(6x,8x,3x,A3,3x,A)') '<--','indicates from Simulink to SrvD'
      write(UnSum, '(6x,A8,3x,A3,3x,A11)') 'Record #','   ','Description'
      write(UnSum, '(6x,A8,3x,A3,3x,A11)') '--------','   ','-----------'
      write(UnSum, '(8x,A5,4x,A3,3x,A)')  '1     ','<--','GenTrq                 '
      write(UnSum, '(8x,A5,4x,A3,3x,A)')  '2     ','<--','ElecPwr                '
      write(UnSum, '(8x,A5,4x,A3,3x,A)')  '3     ','<--','YawPosCom              '
      write(UnSum, '(8x,A5,4x,A3,3x,A)')  '4     ','<--','YawRateCom             '
      write(UnSum, '(8x,A5,4x,A3,3x,A)')  '5:7   ','<--','BlPitchCom             '
      write(UnSum, '(8x,A5,4x,A3,3x,A)')  '8     ','<--','HSSBrFrac              '
      write(UnSum, '(8x,A5,4x,A3,3x,A)')  '9:11  ','<--','BlAirfoilCom           '
      write(UnSum, '(8x,A5,4x,A3,3x,A)')  '12:31 ','<--','CableDeltaL            '
      write(UnSum, '(8x,A5,4x,A3,3x,A)')  '32:51 ','<--','CableDektaLdot         '
      write(UnSum, '(8x,A5,4x,A3,3x,A)')  '52:54 ','<--','Lidar focus (optional) '
   endif
contains
   subroutine WrCtrlInfo( IsControlled, Desc, DataChans )
      logical,       intent(in   )  :: IsControlled
      character(30), intent(in   )  :: Desc
      character(30), intent(in   )  :: DataChans
      if (IsControlled) then
         write(UnSum, '(9x,A30,6x,A30)')  Desc,DataChans
      else
         write(UnSum, '(9x,A30,6x,A30)')  Desc,'NOT ACTIVE'
      endif
   end subroutine WrCtrlInfo
end subroutine WrSumInfo4Simulink


END MODULE ServoDyn_IO
!**********************************************************************************************************************************
