!STARTOFREGISTRYGENERATEDFILE 'Waves_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! Waves_Types
!.................................................................................................................................
! This file is part of Waves.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in Waves. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE Waves_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE NWTC_Library
IMPLICIT NONE
! =========  Waves_InitInputType  =======
  TYPE, PUBLIC :: Waves_InitInputType
    CHARACTER(1024)  :: InputFile      !< Name of the input file [-]
    CHARACTER(1024)  :: DirRoot      !< The name of the root file including the full path.  This may be useful if you want this routine to write a permanent record of what it does to be stored with the simulation results: the results should be stored in a file whose name (including path) is generated by appending any suitable extension to DirRoot. [-]
    CHARACTER(1024)  :: WvKinFile      !< The root name of user input wave kinematics files [-]
    REAL(ReKi)  :: Gravity = 0.0_ReKi      !< Gravitational acceleration [(m/s^2)]
    INTEGER(IntKi) , DIMENSION(1:3)  :: nGrid = 0_IntKi      !< Grid dimensions [-]
    INTEGER(IntKi)  :: WaveNDir = 0_IntKi      !< Number of wave directions [only used if WaveDirMod = 1] [Must be an odd number -- will be adjusted within the waves module] [(-)]
    REAL(SiKi)  :: WaveDirSpread = 0.0_R4Ki      !< Spreading coefficient [WaveMod=2,3,4 and WaveDirMod=1] [-]
    REAL(SiKi)  :: WaveDirRange = 0.0_R4Ki      !< Range of wave directions (full range: WaveDir +/- WaveDirRange/2) [only used if WaveMod=6] [(degrees)]
    REAL(DbKi)  :: WaveDT = 0.0_R8Ki      !< Time step for incident wave calculations [(sec)]
    REAL(SiKi)  :: WaveHs = 0.0_R4Ki      !< Significant wave height of incident waves [(meters)]
    LOGICAL  :: WaveNDAmp = .false.      !< Flag for normally-distributed amplitudes in incident waves spectrum [flag] [-]
    REAL(SiKi)  :: WavePhase = 0.0_R4Ki      !< Specified phase for regular waves [(radians)]
    REAL(SiKi)  :: WavePkShp = 0.0_R4Ki      !< Peak shape parameter of incident wave spectrum [1.0 for Pierson-Moskowitz] [-]
    REAL(DbKi)  :: WaveTMax = 0.0_R8Ki      !< Analysis time for incident wave calculations; the actual analysis time may be larger than this value in order for the maintain an effecient FFT [(sec)]
    REAL(SiKi)  :: WaveTp = 0.0_R4Ki      !< Peak spectral period of incident waves [(sec)]
    INTEGER(IntKi)  :: NWaveElevGrid = 0_IntKi      !< Number of grid points where the incident wave elevations are computed (the XY grid point locations) [-]
    INTEGER(IntKi)  :: NWaveKinGrid = 0_IntKi      !< Number of grid points where the incident wave kinematics will be computed [-]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: WaveKinGridxi      !< xi-coordinates for grid points where the incident wave kinematics will be computed (grid points); these are relative to the mean sea level [(meters)]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: WaveKinGridyi      !< yi-coordinates for grid points where the incident wave kinematics will be computed (grid points); these are relative to the mean sea level [(meters)]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: WaveKinGridzi      !< zi-coordinates for grid points where the incident wave kinematics will be computed (grid points); these are relative to the mean sea level [(meters)]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: CurrVxi      !< xi-component of the current velocity at elevation i [(m/s)]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: CurrVyi      !< yi-component of the current velocity at elevation i [(m/s)]
    REAL(SiKi)  :: PCurrVxiPz0 = 0.0_R4Ki      !< xi-component of the partial derivative of the current velocity at elevation near mean sea level [(m/s)]
    REAL(SiKi)  :: PCurrVyiPz0 = 0.0_R4Ki      !< yi-component of the partial derivative of the current velocity at elevation near mean sea level [(m/s)]
    TYPE(NWTC_RandomNumber_ParameterType)  :: RNG      !< Parameters for the pseudo random number generator [-]
    INTEGER(IntKi)  :: ConstWaveMod = 0_IntKi      !< Mode of the constrained wave [-]
    REAL(SiKi)  :: CrestHmax = 0.0_R4Ki      !< crest height or double the crest elevation [m]
    REAL(SiKi)  :: CrestTime = 0.0_R4Ki      !< time of the wave crest [sec]
    REAL(SiKi)  :: CrestXi = 0.0_R4Ki      !< xi-coordinate for the wave crest [m]
    REAL(SiKi)  :: CrestYi = 0.0_R4Ki      !< yi-coordinate for the wave crest [m]
    INTEGER(IntKi)  :: WaveFieldMod = 0_IntKi      !< Wave field handling (-) (switch) 0: use individual SeaState inputs without adjustment, 1: adjust wave phases based on turbine offsets from farm origin [-]
    REAL(ReKi)  :: PtfmLocationX = 0.0_ReKi      !< Supplied by Driver:  X coordinate of platform location in the wave field [m]
    REAL(ReKi)  :: PtfmLocationY = 0.0_ReKi      !< Supplied by Driver:  Y coordinate of platform location in the wave field [m]
  END TYPE Waves_InitInputType
! =======================
! =========  Waves_InitOutputType  =======
  TYPE, PUBLIC :: Waves_InitOutputType
    INTEGER(IntKi)  :: WaveNDir = 0_IntKi      !< Number of wave directions [only used if WaveDirMod = 1] [Must be an odd number -- will be adjusted within the waves module] [(-)]
    REAL(DbKi)  :: WaveTMax = 0.0_R8Ki      !< Analysis time for incident wave calculations; the actual analysis time may be larger than this value in order for the maintain an effecient FFT [(sec)]
  END TYPE Waves_InitOutputType
! =======================
CONTAINS

subroutine Waves_CopyInitInput(SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg)
   type(Waves_InitInputType), intent(in) :: SrcInitInputData
   type(Waves_InitInputType), intent(inout) :: DstInitInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'Waves_CopyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInitInputData%InputFile = SrcInitInputData%InputFile
   DstInitInputData%DirRoot = SrcInitInputData%DirRoot
   DstInitInputData%WvKinFile = SrcInitInputData%WvKinFile
   DstInitInputData%Gravity = SrcInitInputData%Gravity
   DstInitInputData%nGrid = SrcInitInputData%nGrid
   DstInitInputData%WaveNDir = SrcInitInputData%WaveNDir
   DstInitInputData%WaveDirSpread = SrcInitInputData%WaveDirSpread
   DstInitInputData%WaveDirRange = SrcInitInputData%WaveDirRange
   DstInitInputData%WaveDT = SrcInitInputData%WaveDT
   DstInitInputData%WaveHs = SrcInitInputData%WaveHs
   DstInitInputData%WaveNDAmp = SrcInitInputData%WaveNDAmp
   DstInitInputData%WavePhase = SrcInitInputData%WavePhase
   DstInitInputData%WavePkShp = SrcInitInputData%WavePkShp
   DstInitInputData%WaveTMax = SrcInitInputData%WaveTMax
   DstInitInputData%WaveTp = SrcInitInputData%WaveTp
   DstInitInputData%NWaveElevGrid = SrcInitInputData%NWaveElevGrid
   DstInitInputData%NWaveKinGrid = SrcInitInputData%NWaveKinGrid
   if (allocated(SrcInitInputData%WaveKinGridxi)) then
      LB(1:1) = lbound(SrcInitInputData%WaveKinGridxi)
      UB(1:1) = ubound(SrcInitInputData%WaveKinGridxi)
      if (.not. allocated(DstInitInputData%WaveKinGridxi)) then
         allocate(DstInitInputData%WaveKinGridxi(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%WaveKinGridxi.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%WaveKinGridxi = SrcInitInputData%WaveKinGridxi
   end if
   if (allocated(SrcInitInputData%WaveKinGridyi)) then
      LB(1:1) = lbound(SrcInitInputData%WaveKinGridyi)
      UB(1:1) = ubound(SrcInitInputData%WaveKinGridyi)
      if (.not. allocated(DstInitInputData%WaveKinGridyi)) then
         allocate(DstInitInputData%WaveKinGridyi(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%WaveKinGridyi.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%WaveKinGridyi = SrcInitInputData%WaveKinGridyi
   end if
   if (allocated(SrcInitInputData%WaveKinGridzi)) then
      LB(1:1) = lbound(SrcInitInputData%WaveKinGridzi)
      UB(1:1) = ubound(SrcInitInputData%WaveKinGridzi)
      if (.not. allocated(DstInitInputData%WaveKinGridzi)) then
         allocate(DstInitInputData%WaveKinGridzi(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%WaveKinGridzi.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%WaveKinGridzi = SrcInitInputData%WaveKinGridzi
   end if
   if (allocated(SrcInitInputData%CurrVxi)) then
      LB(1:1) = lbound(SrcInitInputData%CurrVxi)
      UB(1:1) = ubound(SrcInitInputData%CurrVxi)
      if (.not. allocated(DstInitInputData%CurrVxi)) then
         allocate(DstInitInputData%CurrVxi(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%CurrVxi.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%CurrVxi = SrcInitInputData%CurrVxi
   end if
   if (allocated(SrcInitInputData%CurrVyi)) then
      LB(1:1) = lbound(SrcInitInputData%CurrVyi)
      UB(1:1) = ubound(SrcInitInputData%CurrVyi)
      if (.not. allocated(DstInitInputData%CurrVyi)) then
         allocate(DstInitInputData%CurrVyi(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%CurrVyi.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%CurrVyi = SrcInitInputData%CurrVyi
   end if
   DstInitInputData%PCurrVxiPz0 = SrcInitInputData%PCurrVxiPz0
   DstInitInputData%PCurrVyiPz0 = SrcInitInputData%PCurrVyiPz0
   call NWTC_Library_CopyNWTC_RandomNumber_ParameterType(SrcInitInputData%RNG, DstInitInputData%RNG, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstInitInputData%ConstWaveMod = SrcInitInputData%ConstWaveMod
   DstInitInputData%CrestHmax = SrcInitInputData%CrestHmax
   DstInitInputData%CrestTime = SrcInitInputData%CrestTime
   DstInitInputData%CrestXi = SrcInitInputData%CrestXi
   DstInitInputData%CrestYi = SrcInitInputData%CrestYi
   DstInitInputData%WaveFieldMod = SrcInitInputData%WaveFieldMod
   DstInitInputData%PtfmLocationX = SrcInitInputData%PtfmLocationX
   DstInitInputData%PtfmLocationY = SrcInitInputData%PtfmLocationY
end subroutine

subroutine Waves_DestroyInitInput(InitInputData, ErrStat, ErrMsg)
   type(Waves_InitInputType), intent(inout) :: InitInputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'Waves_DestroyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InitInputData%WaveKinGridxi)) then
      deallocate(InitInputData%WaveKinGridxi)
   end if
   if (allocated(InitInputData%WaveKinGridyi)) then
      deallocate(InitInputData%WaveKinGridyi)
   end if
   if (allocated(InitInputData%WaveKinGridzi)) then
      deallocate(InitInputData%WaveKinGridzi)
   end if
   if (allocated(InitInputData%CurrVxi)) then
      deallocate(InitInputData%CurrVxi)
   end if
   if (allocated(InitInputData%CurrVyi)) then
      deallocate(InitInputData%CurrVyi)
   end if
   call NWTC_Library_DestroyNWTC_RandomNumber_ParameterType(InitInputData%RNG, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine Waves_PackInitInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Waves_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Waves_PackInitInput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%InputFile)
   call RegPack(RF, InData%DirRoot)
   call RegPack(RF, InData%WvKinFile)
   call RegPack(RF, InData%Gravity)
   call RegPack(RF, InData%nGrid)
   call RegPack(RF, InData%WaveNDir)
   call RegPack(RF, InData%WaveDirSpread)
   call RegPack(RF, InData%WaveDirRange)
   call RegPack(RF, InData%WaveDT)
   call RegPack(RF, InData%WaveHs)
   call RegPack(RF, InData%WaveNDAmp)
   call RegPack(RF, InData%WavePhase)
   call RegPack(RF, InData%WavePkShp)
   call RegPack(RF, InData%WaveTMax)
   call RegPack(RF, InData%WaveTp)
   call RegPack(RF, InData%NWaveElevGrid)
   call RegPack(RF, InData%NWaveKinGrid)
   call RegPackAlloc(RF, InData%WaveKinGridxi)
   call RegPackAlloc(RF, InData%WaveKinGridyi)
   call RegPackAlloc(RF, InData%WaveKinGridzi)
   call RegPackAlloc(RF, InData%CurrVxi)
   call RegPackAlloc(RF, InData%CurrVyi)
   call RegPack(RF, InData%PCurrVxiPz0)
   call RegPack(RF, InData%PCurrVyiPz0)
   call NWTC_Library_PackNWTC_RandomNumber_ParameterType(RF, InData%RNG) 
   call RegPack(RF, InData%ConstWaveMod)
   call RegPack(RF, InData%CrestHmax)
   call RegPack(RF, InData%CrestTime)
   call RegPack(RF, InData%CrestXi)
   call RegPack(RF, InData%CrestYi)
   call RegPack(RF, InData%WaveFieldMod)
   call RegPack(RF, InData%PtfmLocationX)
   call RegPack(RF, InData%PtfmLocationY)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Waves_UnPackInitInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Waves_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Waves_UnPackInitInput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%InputFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DirRoot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WvKinFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Gravity); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nGrid); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WaveNDir); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WaveDirSpread); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WaveDirRange); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WaveDT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WaveHs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WaveNDAmp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WavePhase); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WavePkShp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WaveTMax); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WaveTp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NWaveElevGrid); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NWaveKinGrid); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WaveKinGridxi); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WaveKinGridyi); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WaveKinGridzi); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%CurrVxi); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%CurrVyi); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PCurrVxiPz0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PCurrVyiPz0); if (RegCheckErr(RF, RoutineName)) return
   call NWTC_Library_UnpackNWTC_RandomNumber_ParameterType(RF, OutData%RNG) ! RNG 
   call RegUnpack(RF, OutData%ConstWaveMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CrestHmax); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CrestTime); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CrestXi); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CrestYi); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WaveFieldMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmLocationX); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmLocationY); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Waves_CopyInitOutput(SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg)
   type(Waves_InitOutputType), intent(in) :: SrcInitOutputData
   type(Waves_InitOutputType), intent(inout) :: DstInitOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Waves_CopyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInitOutputData%WaveNDir = SrcInitOutputData%WaveNDir
   DstInitOutputData%WaveTMax = SrcInitOutputData%WaveTMax
end subroutine

subroutine Waves_DestroyInitOutput(InitOutputData, ErrStat, ErrMsg)
   type(Waves_InitOutputType), intent(inout) :: InitOutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Waves_DestroyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine Waves_PackInitOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Waves_InitOutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Waves_PackInitOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%WaveNDir)
   call RegPack(RF, InData%WaveTMax)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Waves_UnPackInitOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Waves_InitOutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Waves_UnPackInitOutput'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%WaveNDir); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WaveTMax); if (RegCheckErr(RF, RoutineName)) return
end subroutine
END MODULE Waves_Types
!ENDOFREGISTRYGENERATEDFILE
