!STARTOFREGISTRYGENERATEDFILE 'SeaState_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! SeaState_Types
!.................................................................................................................................
! This file is part of SeaState.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in SeaState. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE SeaState_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE Current_Types
USE Waves_Types
USE Waves2_Types
USE SeaSt_WaveField_Types
USE NWTC_Library
IMPLICIT NONE
! =========  SeaSt_InputFile  =======
  TYPE, PUBLIC :: SeaSt_InputFile
    LOGICAL  :: EchoFlag = .false.      !< Echo the input file [-]
    REAL(ReKi)  :: MSL2SWL = 0.0_ReKi      !< Mean Sea Level to Still Water Level offset [m]
    REAL(ReKi)  :: X_HalfWidth = 0.0_ReKi      !< Half-width of the domain in the X direction [m]
    REAL(ReKi)  :: Y_HalfWidth = 0.0_ReKi      !< Half-width of the domain in the Y direction [m]
    REAL(ReKi)  :: Z_Depth = 0.0_ReKi      !< Depth of the domain the Z direction [m]
    INTEGER(IntKi)  :: NX = 0_IntKi      !< Number of nodes in half of the X-direction domain [-]
    INTEGER(IntKi)  :: NY = 0_IntKi      !< Number of nodes in half of the Y-direction domain [-]
    INTEGER(IntKi)  :: NZ = 0_IntKi      !< Number of nodes in half of the Z-direction domain [-]
    TYPE(Waves_InitInputType)  :: Waves      !< Initialization data for Waves module [-]
    TYPE(Waves2_InitInputType)  :: Waves2      !< Initialization data for Waves2 module [-]
    TYPE(Current_InitInputType)  :: Current      !< Initialization data for Current module [-]
    LOGICAL  :: Echo = .false.      !< Echo the input files to a file with the same name as the input but with a .echo extension [T/F] [-]
    INTEGER(IntKi)  :: NWaveElev = 0_IntKi      !< Number of user-requested points where the incident wave elevations can be output [-]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: WaveElevxi      !< xi-coordinates for points where the incident wave elevations can be output [(meters)]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: WaveElevyi      !< yi-coordinates for points where the incident wave elevations can be output [(meters)]
    INTEGER(IntKi)  :: NWaveKin = 0_IntKi      !< Number of points where the incident wave kinematics will be computed [-]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: WaveKinxi      !< xi-coordinates for points where the incident wave kinematics will be computed; these are relative to the mean sea level [(meters)]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: WaveKinyi      !< yi-coordinates for points where the incident wave kinematics will be computed; these are relative to the mean sea level [(meters)]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: WaveKinzi      !< zi-coordinates for points where the incident wave kinematics will be computed; these are relative to the mean sea level [(meters)]
    INTEGER(IntKi)  :: OutSwtch = 0_IntKi      !< Output requested channels to: [1=SeaState.out 2=GlueCode.out  3=both files] [-]
    LOGICAL  :: OutAll = .false.      !< Output all user-specified member and joint loads (only at each member end, not interior locations) [T/F] [-]
    INTEGER(IntKi)  :: NumOuts = 0_IntKi      !< The number of outputs for this module as requested in the input file [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: OutList      !< The user-requested output channel labels for this modules. This should really be dimensioned with MaxOutPts [-]
    LOGICAL  :: SeaStSum = .false.      !< Generate a SeaState summary file [T/F] [-]
    CHARACTER(20)  :: OutFmt      !< Output format for numerical results [-]
    CHARACTER(20)  :: OutSFmt      !< Output format for header strings [-]
    INTEGER(IntKi)  :: WaveStMod = 0_IntKi      !< Model for stretching incident wave kinematics to instantaneous free surface {0: none=no stretching, 1: vertical stretching, 2: extrapolation stretching, 3: Wheeler stretching} [-]
    REAL(ReKi)  :: WtrDpth = 0.0_ReKi      !< Water depth, this is necessary to inform glue-code what the module is using for WtrDpth (may not be the glue-code's default) [(m)]
    REAL(ReKi)  :: WtrDens = 0.0_ReKi      !< Water density, this is necessary to inform glue-code what the module is using for WtrDens (may not be the glue-code's default) [(kg/m^3)]
    INTEGER(IntKi)  :: WaveDirMod = 0_IntKi      !< Directional wave spreading function {0: none, 1: COS2S} [only used if WaveMod=6] [-]
    REAL(SiKi)  :: WaveDir = 0.0_R4Ki      !< Incident wave propagation heading direction [(degrees)]
    LOGICAL  :: WaveMultiDir = .false.      !< Indicates the waves are multidirectional [-]
    REAL(SiKi)  :: MCFD = 0.0_R4Ki      !< Diameter of members that will use the MacCamy-Fuchs diffraction model [-]
    REAL(SiKi)  :: WvLowCOff = 0.0_R4Ki      !< Low cut-off frequency or lower frequency limit of the wave spectrum beyond which the wave spectrum is zeroed.  [used only when WaveMod=2,3,4] [(rad/s)]
    REAL(SiKi)  :: WvHiCOff = 0.0_R4Ki      !< High cut-off frequency or upper frequency limit of the wave spectrum beyond which the wave spectrum is zeroed.  [used only when WaveMod=2,3,4] [(rad/s)]
    REAL(SiKi)  :: WvLowCOffD = 0.0_R4Ki      !< Minimum frequency used in the difference methods [Ignored if all difference methods = 0] [(rad/s)]
    REAL(SiKi)  :: WvHiCOffD = 0.0_R4Ki      !< Maximum frequency used in the difference methods [Ignored if all difference methods = 0] [(rad/s)]
    REAL(SiKi)  :: WvLowCOffS = 0.0_R4Ki      !< Minimum frequency used in the sum-QTF method     [Ignored if SumQTF = 0] [(rad/s)]
    REAL(SiKi)  :: WvHiCOffS = 0.0_R4Ki      !< Maximum frequency used in the sum-QTF method     [Ignored if SumQTF = 0] [(rad/s)]
    REAL(SiKi)  :: WaveDOmega = 0.0_R4Ki      !< Frequency step for incident wave calculations [(rad/s)]
    INTEGER(IntKi)  :: WaveMod = 0_IntKi      !< Incident wave kinematics model: See valid values in SeaSt_WaveField module parameters. [-]
  END TYPE SeaSt_InputFile
! =======================
! =========  SeaSt_InitInputType  =======
  TYPE, PUBLIC :: SeaSt_InitInputType
    CHARACTER(1024)  :: InputFile      !< Supplied by Driver:  full path and filename for the SeaState module [-]
    LOGICAL  :: UseInputFile = .TRUE.      !< Supplied by Driver:  .TRUE. if using a input file, .FALSE. if all inputs are being passed in by the caller [-]
    TYPE(FileInfoType)  :: PassedFileData      !< If we don't use the input file, pass everything through this [-]
    CHARACTER(1024)  :: OutRootName      !< Supplied by Driver:  The name of the root file (without extension) including the full path [-]
    REAL(ReKi)  :: Gravity = 0.0_ReKi      !< Supplied by Driver:  Gravitational acceleration [(m/s^2)]
    REAL(ReKi)  :: defWtrDens = 0.0_ReKi      !< Default water density from the driver; may be overwritten                       [(kg/m^3)]
    REAL(ReKi)  :: defWtrDpth = 0.0_ReKi      !< Default water depth from the driver; may be overwritten                         [m]
    REAL(ReKi)  :: defMSL2SWL = 0.0_ReKi      !< Default mean sea level to still water level from the driver; may be overwritten [m]
    REAL(DbKi)  :: TMax = 0.0_R8Ki      !< Supplied by Driver:  The total simulation time [(sec)]
    INTEGER(IntKi)  :: WaveFieldMod = 0_IntKi      !< Wave field handling (-) (switch) 0: use individual SeaState inputs without adjustment, 1: adjust wave phases based on turbine offsets from farm origin [-]
    REAL(ReKi)  :: PtfmLocationX = 0.0_ReKi      !< Supplied by Driver:  X coordinate of platform location in the wave field [m]
    REAL(ReKi)  :: PtfmLocationY = 0.0_ReKi      !< Supplied by Driver:  Y coordinate of platform location in the wave field [m]
    INTEGER(IntKi)  :: WrWvKinMod = 0      !< 0,1, or 2 indicating whether we are going to write out kinematics files.  [ignored if WaveMod = 6, if 1 or 2 then files are written using the outrootname] [-]
    LOGICAL  :: HasIce = .false.      !< Supplied by Driver:  Whether this simulation has ice loading (flag) [-]
    LOGICAL  :: Linearize = .FALSE.      !< Flag that tells this module if the glue code wants to linearize. [-]
    LOGICAL  :: SurfaceVis = .FALSE.      !< Turn on grid surface visualization outputs [-]
    INTEGER(IntKi)  :: SurfaceVisNx = 0      !< Number of points in X direction to output for visualization grid.  Use 0 or negative to set to SeaState resolution. [-]
    INTEGER(IntKi)  :: SurfaceVisNy = 0      !< Number of points in Y direction to output for visualization grid.  Use 0 or negative to set to SeaState resolution. [-]
  END TYPE SeaSt_InitInputType
! =======================
! =========  SeaSt_InitOutputType  =======
  TYPE, PUBLIC :: SeaSt_InitOutputType
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputHdr      !< The is the list of all HD-related output channel header strings (includes all sub-module channels) [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputUnt      !< The is the list of all HD-related output channel unit strings (includes all sub-module channels) [-]
    TYPE(ProgDesc)  :: Ver      !< Version of SeaState [-]
    LOGICAL  :: InvalidWithSSExctn = .false.      !< Whether SeaState configuration is invalid with HydroDyn's state-space excitation (ExctnMod=2) [(-)]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: WaveElevVisX      !< X locations of grid output [m,-]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: WaveElevVisY      !< Y locations of grid output [m,-]
    REAL(SiKi) , DIMENSION(:,:,:), ALLOCATABLE  :: WaveElevVisGrid      !< Wave elevation time-series at each of the points given by WaveElevXY.  First dimension is the timestep. Second/third dimensions are the grid of points. [(m)]
    TYPE(SeaSt_WaveFieldType) , POINTER :: WaveField => NULL()      !< Pointer to wave field [-]
    CHARACTER(LinChanLen) , DIMENSION(:), ALLOCATABLE  :: LinNames_y      !< Names of the outputs used in linearization [-]
    CHARACTER(LinChanLen) , DIMENSION(:), ALLOCATABLE  :: LinNames_u      !< Names of the inputs used in linearization [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: RotFrame_u      !< Flag that tells FAST/MBC3 if the inputs used in linearization are in the rotating frame [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: RotFrame_y      !< Flag that tells FAST/MBC3 if the outputs used in linearization are in the rotating frame [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: IsLoad_u      !< Flag that tells FAST if the inputs used in linearization are loads (for preconditioning matrix) [-]
  END TYPE SeaSt_InitOutputType
! =======================
! =========  SeaSt_ContinuousStateType  =======
  TYPE, PUBLIC :: SeaSt_ContinuousStateType
    REAL(R8Ki)  :: UnusedStates = 0.0_R8Ki      !< placeholder for states [-]
  END TYPE SeaSt_ContinuousStateType
! =======================
! =========  SeaSt_DiscreteStateType  =======
  TYPE, PUBLIC :: SeaSt_DiscreteStateType
    REAL(R8Ki)  :: UnusedStates = 0.0_R8Ki      !< placeholder for states [-]
  END TYPE SeaSt_DiscreteStateType
! =======================
! =========  SeaSt_ConstraintStateType  =======
  TYPE, PUBLIC :: SeaSt_ConstraintStateType
    REAL(R8Ki)  :: UnusedStates = 0.0_R8Ki      !< placeholder for states [-]
  END TYPE SeaSt_ConstraintStateType
! =======================
! =========  SeaSt_OtherStateType  =======
  TYPE, PUBLIC :: SeaSt_OtherStateType
    REAL(R8Ki)  :: UnusedStates = 0.0_R8Ki      !< placeholder for states [-]
  END TYPE SeaSt_OtherStateType
! =======================
! =========  SeaSt_MiscVarType  =======
  TYPE, PUBLIC :: SeaSt_MiscVarType
    INTEGER(IntKi)  :: Decimate = 0_IntKi      !< The output decimation counter [-]
    REAL(DbKi)  :: LastOutTime = 0.0_R8Ki      !< Last time step which was written to the output file (sec) [-]
    INTEGER(IntKi)  :: LastIndWave = 0_IntKi      !< The last index used in the wave kinematics arrays, used to optimize interpolation [-]
    TYPE(SeaSt_WaveField_MiscVarType)  :: WaveField_m      !< misc var information from the SeaState Interpolation module [-]
  END TYPE SeaSt_MiscVarType
! =======================
! =========  Jac_u_idxStarts  =======
  TYPE, PUBLIC :: Jac_u_idxStarts
    INTEGER(IntKi)  :: Extended = 1      !< Index to first point in u jacobian for Extended [-]
  END TYPE Jac_u_idxStarts
! =======================
! =========  Jac_y_idxStarts  =======
  TYPE, PUBLIC :: Jac_y_idxStarts
    INTEGER(IntKi)  :: Extended = 1      !< Index to first point in y jacobian for Extended [-]
    INTEGER(IntKi)  :: WrOuts = 2      !< Index to first point in y jacobian for WrOuts [-]
  END TYPE Jac_y_idxStarts
! =======================
! =========  SeaSt_LinParams  =======
  TYPE, PUBLIC :: SeaSt_LinParams
    INTEGER(IntKi)  :: NumExtendedInputs = 1      !< number of extended inputs [-]
    INTEGER(IntKi)  :: NumExtendedOutputs = 1      !< number of extended outputs [-]
    TYPE(Jac_u_idxStarts)  :: Jac_u_idxStartList      !< Starting indices for all Jac_u components [-]
    TYPE(Jac_y_idxStarts)  :: Jac_y_idxStartList      !< Starting indices for all Jac_y components [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: du      !< vector that determines size of perturbation for u (inputs) [-]
    INTEGER(IntKi)  :: Jac_nu = 0_IntKi      !< number of inputs  in jacobian matrix [-]
    INTEGER(IntKi)  :: Jac_ny = 0_IntKi      !< number of outputs in jacobian matrix [-]
  END TYPE SeaSt_LinParams
! =======================
! =========  SeaSt_ParameterType  =======
  TYPE, PUBLIC :: SeaSt_ParameterType
    REAL(DbKi)  :: WaveDT = 0.0_R8Ki      !< Wave DT [sec]
    INTEGER(IntKi)  :: NGridPts = 0_IntKi      !< Number of data points in the wave kinematics grid [-]
    INTEGER(IntKi) , DIMENSION(1:3)  :: NGrid = 0_IntKi      !< Number of grid entries in x, y, and z [-]
    REAL(ReKi) , DIMENSION(1:3)  :: deltaGrid = 0.0_ReKi      !< delta between grid points in x, y, and theta (for z) [m,m,rad]
    INTEGER(IntKi)  :: NWaveElev = 0_IntKi      !< Number of wave elevation outputs [-]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: WaveElevxi      !< xi-coordinates for points where the incident wave elevations can be output [(meters)]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: WaveElevyi      !< yi-coordinates for points where the incident wave elevations can be output [(meters)]
    INTEGER(IntKi)  :: NWaveKin = 0_IntKi      !< Number of points where the incident wave kinematics can be output [-]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: WaveKinxi      !< xi-coordinates for points where the incident wave kinematics can be output; these are relative to the mean sea level [(meters)]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: WaveKinyi      !< yi-coordinates for points where the incident wave kinematics can be output; these are relative to the mean sea level [(meters)]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: WaveKinzi      !< zi-coordinates for points where the incident wave kinematics can be output; these are relative to the mean sea level [(meters)]
    TYPE(OutParmType) , DIMENSION(:), ALLOCATABLE  :: OutParam      !<  [-]
    INTEGER(IntKi)  :: NumOuts = 0_IntKi      !< Number of SeaState module-level outputs (not the total number including sub-modules [-]
    INTEGER(IntKi)  :: OutSwtch = 0_IntKi      !< Output requested channels to: [1=SeaState.out 2=GlueCode.out  3=both files] [-]
    CHARACTER(20)  :: OutFmt      !< Output format for numerical results [-]
    CHARACTER(20)  :: OutSFmt      !< Output format for header strings [-]
    CHARACTER(1)  :: Delim      !< Delimiter string for outputs, defaults to space [-]
    INTEGER(IntKi)  :: UnOutFile = 0_IntKi      !< File unit for the SeaState outputs [-]
    INTEGER(IntKi)  :: OutDec = 0_IntKi      !< Write every OutDec time steps [-]
    TYPE(SeaSt_WaveFieldType) , POINTER :: WaveField => NULL()      !< Wave field [-]
    TYPE(SeaSt_LinParams)  :: LinParams      !< Linearization parameters [-]
  END TYPE SeaSt_ParameterType
! =======================
! =========  SeaSt_InputType  =======
  TYPE, PUBLIC :: SeaSt_InputType
    REAL(SiKi)  :: DummyInput = 0.0_R4Ki      !< Remove this variable if you have inputs [-]
  END TYPE SeaSt_InputType
! =======================
! =========  SeaSt_OutputType  =======
  TYPE, PUBLIC :: SeaSt_OutputType
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WriteOutput      !< Outputs to be written to the output file(s) [-]
  END TYPE SeaSt_OutputType
! =======================
CONTAINS

subroutine SeaSt_CopyInputFile(SrcInputFileData, DstInputFileData, CtrlCode, ErrStat, ErrMsg)
   type(SeaSt_InputFile), intent(in) :: SrcInputFileData
   type(SeaSt_InputFile), intent(inout) :: DstInputFileData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SeaSt_CopyInputFile'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInputFileData%EchoFlag = SrcInputFileData%EchoFlag
   DstInputFileData%MSL2SWL = SrcInputFileData%MSL2SWL
   DstInputFileData%X_HalfWidth = SrcInputFileData%X_HalfWidth
   DstInputFileData%Y_HalfWidth = SrcInputFileData%Y_HalfWidth
   DstInputFileData%Z_Depth = SrcInputFileData%Z_Depth
   DstInputFileData%NX = SrcInputFileData%NX
   DstInputFileData%NY = SrcInputFileData%NY
   DstInputFileData%NZ = SrcInputFileData%NZ
   call Waves_CopyInitInput(SrcInputFileData%Waves, DstInputFileData%Waves, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call Waves2_CopyInitInput(SrcInputFileData%Waves2, DstInputFileData%Waves2, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call Current_CopyInitInput(SrcInputFileData%Current, DstInputFileData%Current, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstInputFileData%Echo = SrcInputFileData%Echo
   DstInputFileData%NWaveElev = SrcInputFileData%NWaveElev
   if (allocated(SrcInputFileData%WaveElevxi)) then
      LB(1:1) = lbound(SrcInputFileData%WaveElevxi)
      UB(1:1) = ubound(SrcInputFileData%WaveElevxi)
      if (.not. allocated(DstInputFileData%WaveElevxi)) then
         allocate(DstInputFileData%WaveElevxi(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%WaveElevxi.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%WaveElevxi = SrcInputFileData%WaveElevxi
   end if
   if (allocated(SrcInputFileData%WaveElevyi)) then
      LB(1:1) = lbound(SrcInputFileData%WaveElevyi)
      UB(1:1) = ubound(SrcInputFileData%WaveElevyi)
      if (.not. allocated(DstInputFileData%WaveElevyi)) then
         allocate(DstInputFileData%WaveElevyi(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%WaveElevyi.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%WaveElevyi = SrcInputFileData%WaveElevyi
   end if
   DstInputFileData%NWaveKin = SrcInputFileData%NWaveKin
   if (allocated(SrcInputFileData%WaveKinxi)) then
      LB(1:1) = lbound(SrcInputFileData%WaveKinxi)
      UB(1:1) = ubound(SrcInputFileData%WaveKinxi)
      if (.not. allocated(DstInputFileData%WaveKinxi)) then
         allocate(DstInputFileData%WaveKinxi(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%WaveKinxi.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%WaveKinxi = SrcInputFileData%WaveKinxi
   end if
   if (allocated(SrcInputFileData%WaveKinyi)) then
      LB(1:1) = lbound(SrcInputFileData%WaveKinyi)
      UB(1:1) = ubound(SrcInputFileData%WaveKinyi)
      if (.not. allocated(DstInputFileData%WaveKinyi)) then
         allocate(DstInputFileData%WaveKinyi(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%WaveKinyi.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%WaveKinyi = SrcInputFileData%WaveKinyi
   end if
   if (allocated(SrcInputFileData%WaveKinzi)) then
      LB(1:1) = lbound(SrcInputFileData%WaveKinzi)
      UB(1:1) = ubound(SrcInputFileData%WaveKinzi)
      if (.not. allocated(DstInputFileData%WaveKinzi)) then
         allocate(DstInputFileData%WaveKinzi(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%WaveKinzi.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%WaveKinzi = SrcInputFileData%WaveKinzi
   end if
   DstInputFileData%OutSwtch = SrcInputFileData%OutSwtch
   DstInputFileData%OutAll = SrcInputFileData%OutAll
   DstInputFileData%NumOuts = SrcInputFileData%NumOuts
   if (allocated(SrcInputFileData%OutList)) then
      LB(1:1) = lbound(SrcInputFileData%OutList)
      UB(1:1) = ubound(SrcInputFileData%OutList)
      if (.not. allocated(DstInputFileData%OutList)) then
         allocate(DstInputFileData%OutList(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%OutList.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%OutList = SrcInputFileData%OutList
   end if
   DstInputFileData%SeaStSum = SrcInputFileData%SeaStSum
   DstInputFileData%OutFmt = SrcInputFileData%OutFmt
   DstInputFileData%OutSFmt = SrcInputFileData%OutSFmt
   DstInputFileData%WaveStMod = SrcInputFileData%WaveStMod
   DstInputFileData%WtrDpth = SrcInputFileData%WtrDpth
   DstInputFileData%WtrDens = SrcInputFileData%WtrDens
   DstInputFileData%WaveDirMod = SrcInputFileData%WaveDirMod
   DstInputFileData%WaveDir = SrcInputFileData%WaveDir
   DstInputFileData%WaveMultiDir = SrcInputFileData%WaveMultiDir
   DstInputFileData%MCFD = SrcInputFileData%MCFD
   DstInputFileData%WvLowCOff = SrcInputFileData%WvLowCOff
   DstInputFileData%WvHiCOff = SrcInputFileData%WvHiCOff
   DstInputFileData%WvLowCOffD = SrcInputFileData%WvLowCOffD
   DstInputFileData%WvHiCOffD = SrcInputFileData%WvHiCOffD
   DstInputFileData%WvLowCOffS = SrcInputFileData%WvLowCOffS
   DstInputFileData%WvHiCOffS = SrcInputFileData%WvHiCOffS
   DstInputFileData%WaveDOmega = SrcInputFileData%WaveDOmega
   DstInputFileData%WaveMod = SrcInputFileData%WaveMod
end subroutine

subroutine SeaSt_DestroyInputFile(InputFileData, ErrStat, ErrMsg)
   type(SeaSt_InputFile), intent(inout) :: InputFileData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SeaSt_DestroyInputFile'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call Waves_DestroyInitInput(InputFileData%Waves, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call Waves2_DestroyInitInput(InputFileData%Waves2, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call Current_DestroyInitInput(InputFileData%Current, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(InputFileData%WaveElevxi)) then
      deallocate(InputFileData%WaveElevxi)
   end if
   if (allocated(InputFileData%WaveElevyi)) then
      deallocate(InputFileData%WaveElevyi)
   end if
   if (allocated(InputFileData%WaveKinxi)) then
      deallocate(InputFileData%WaveKinxi)
   end if
   if (allocated(InputFileData%WaveKinyi)) then
      deallocate(InputFileData%WaveKinyi)
   end if
   if (allocated(InputFileData%WaveKinzi)) then
      deallocate(InputFileData%WaveKinzi)
   end if
   if (allocated(InputFileData%OutList)) then
      deallocate(InputFileData%OutList)
   end if
end subroutine

subroutine SeaSt_PackInputFile(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SeaSt_InputFile), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SeaSt_PackInputFile'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%EchoFlag)
   call RegPack(RF, InData%MSL2SWL)
   call RegPack(RF, InData%X_HalfWidth)
   call RegPack(RF, InData%Y_HalfWidth)
   call RegPack(RF, InData%Z_Depth)
   call RegPack(RF, InData%NX)
   call RegPack(RF, InData%NY)
   call RegPack(RF, InData%NZ)
   call Waves_PackInitInput(RF, InData%Waves) 
   call Waves2_PackInitInput(RF, InData%Waves2) 
   call Current_PackInitInput(RF, InData%Current) 
   call RegPack(RF, InData%Echo)
   call RegPack(RF, InData%NWaveElev)
   call RegPackAlloc(RF, InData%WaveElevxi)
   call RegPackAlloc(RF, InData%WaveElevyi)
   call RegPack(RF, InData%NWaveKin)
   call RegPackAlloc(RF, InData%WaveKinxi)
   call RegPackAlloc(RF, InData%WaveKinyi)
   call RegPackAlloc(RF, InData%WaveKinzi)
   call RegPack(RF, InData%OutSwtch)
   call RegPack(RF, InData%OutAll)
   call RegPack(RF, InData%NumOuts)
   call RegPackAlloc(RF, InData%OutList)
   call RegPack(RF, InData%SeaStSum)
   call RegPack(RF, InData%OutFmt)
   call RegPack(RF, InData%OutSFmt)
   call RegPack(RF, InData%WaveStMod)
   call RegPack(RF, InData%WtrDpth)
   call RegPack(RF, InData%WtrDens)
   call RegPack(RF, InData%WaveDirMod)
   call RegPack(RF, InData%WaveDir)
   call RegPack(RF, InData%WaveMultiDir)
   call RegPack(RF, InData%MCFD)
   call RegPack(RF, InData%WvLowCOff)
   call RegPack(RF, InData%WvHiCOff)
   call RegPack(RF, InData%WvLowCOffD)
   call RegPack(RF, InData%WvHiCOffD)
   call RegPack(RF, InData%WvLowCOffS)
   call RegPack(RF, InData%WvHiCOffS)
   call RegPack(RF, InData%WaveDOmega)
   call RegPack(RF, InData%WaveMod)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SeaSt_UnPackInputFile(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SeaSt_InputFile), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SeaSt_UnPackInputFile'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%EchoFlag); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MSL2SWL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%X_HalfWidth); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Y_HalfWidth); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Z_Depth); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NX); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NY); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NZ); if (RegCheckErr(RF, RoutineName)) return
   call Waves_UnpackInitInput(RF, OutData%Waves) ! Waves 
   call Waves2_UnpackInitInput(RF, OutData%Waves2) ! Waves2 
   call Current_UnpackInitInput(RF, OutData%Current) ! Current 
   call RegUnpack(RF, OutData%Echo); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NWaveElev); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WaveElevxi); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WaveElevyi); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NWaveKin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WaveKinxi); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WaveKinyi); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WaveKinzi); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutSwtch); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutAll); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%OutList); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SeaStSum); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutFmt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutSFmt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WaveStMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WtrDpth); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WtrDens); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WaveDirMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WaveDir); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WaveMultiDir); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MCFD); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WvLowCOff); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WvHiCOff); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WvLowCOffD); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WvHiCOffD); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WvLowCOffS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WvHiCOffS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WaveDOmega); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WaveMod); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SeaSt_CopyInitInput(SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg)
   type(SeaSt_InitInputType), intent(in) :: SrcInitInputData
   type(SeaSt_InitInputType), intent(inout) :: DstInitInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SeaSt_CopyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInitInputData%InputFile = SrcInitInputData%InputFile
   DstInitInputData%UseInputFile = SrcInitInputData%UseInputFile
   call NWTC_Library_CopyFileInfoType(SrcInitInputData%PassedFileData, DstInitInputData%PassedFileData, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstInitInputData%OutRootName = SrcInitInputData%OutRootName
   DstInitInputData%Gravity = SrcInitInputData%Gravity
   DstInitInputData%defWtrDens = SrcInitInputData%defWtrDens
   DstInitInputData%defWtrDpth = SrcInitInputData%defWtrDpth
   DstInitInputData%defMSL2SWL = SrcInitInputData%defMSL2SWL
   DstInitInputData%TMax = SrcInitInputData%TMax
   DstInitInputData%WaveFieldMod = SrcInitInputData%WaveFieldMod
   DstInitInputData%PtfmLocationX = SrcInitInputData%PtfmLocationX
   DstInitInputData%PtfmLocationY = SrcInitInputData%PtfmLocationY
   DstInitInputData%WrWvKinMod = SrcInitInputData%WrWvKinMod
   DstInitInputData%HasIce = SrcInitInputData%HasIce
   DstInitInputData%Linearize = SrcInitInputData%Linearize
   DstInitInputData%SurfaceVis = SrcInitInputData%SurfaceVis
   DstInitInputData%SurfaceVisNx = SrcInitInputData%SurfaceVisNx
   DstInitInputData%SurfaceVisNy = SrcInitInputData%SurfaceVisNy
end subroutine

subroutine SeaSt_DestroyInitInput(InitInputData, ErrStat, ErrMsg)
   type(SeaSt_InitInputType), intent(inout) :: InitInputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SeaSt_DestroyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call NWTC_Library_DestroyFileInfoType(InitInputData%PassedFileData, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine SeaSt_PackInitInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SeaSt_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SeaSt_PackInitInput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%InputFile)
   call RegPack(RF, InData%UseInputFile)
   call NWTC_Library_PackFileInfoType(RF, InData%PassedFileData) 
   call RegPack(RF, InData%OutRootName)
   call RegPack(RF, InData%Gravity)
   call RegPack(RF, InData%defWtrDens)
   call RegPack(RF, InData%defWtrDpth)
   call RegPack(RF, InData%defMSL2SWL)
   call RegPack(RF, InData%TMax)
   call RegPack(RF, InData%WaveFieldMod)
   call RegPack(RF, InData%PtfmLocationX)
   call RegPack(RF, InData%PtfmLocationY)
   call RegPack(RF, InData%WrWvKinMod)
   call RegPack(RF, InData%HasIce)
   call RegPack(RF, InData%Linearize)
   call RegPack(RF, InData%SurfaceVis)
   call RegPack(RF, InData%SurfaceVisNx)
   call RegPack(RF, InData%SurfaceVisNy)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SeaSt_UnPackInitInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SeaSt_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SeaSt_UnPackInitInput'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%InputFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UseInputFile); if (RegCheckErr(RF, RoutineName)) return
   call NWTC_Library_UnpackFileInfoType(RF, OutData%PassedFileData) ! PassedFileData 
   call RegUnpack(RF, OutData%OutRootName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Gravity); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%defWtrDens); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%defWtrDpth); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%defMSL2SWL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TMax); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WaveFieldMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmLocationX); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmLocationY); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WrWvKinMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HasIce); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Linearize); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SurfaceVis); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SurfaceVisNx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SurfaceVisNy); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SeaSt_CopyInitOutput(SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg)
   type(SeaSt_InitOutputType), intent(in) :: SrcInitOutputData
   type(SeaSt_InitOutputType), intent(inout) :: DstInitOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SeaSt_CopyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcInitOutputData%WriteOutputHdr)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputHdr)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputHdr)
      if (.not. allocated(DstInitOutputData%WriteOutputHdr)) then
         allocate(DstInitOutputData%WriteOutputHdr(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputHdr.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputHdr = SrcInitOutputData%WriteOutputHdr
   end if
   if (allocated(SrcInitOutputData%WriteOutputUnt)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputUnt)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputUnt)
      if (.not. allocated(DstInitOutputData%WriteOutputUnt)) then
         allocate(DstInitOutputData%WriteOutputUnt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputUnt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputUnt = SrcInitOutputData%WriteOutputUnt
   end if
   call NWTC_Library_CopyProgDesc(SrcInitOutputData%Ver, DstInitOutputData%Ver, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstInitOutputData%InvalidWithSSExctn = SrcInitOutputData%InvalidWithSSExctn
   if (allocated(SrcInitOutputData%WaveElevVisX)) then
      LB(1:1) = lbound(SrcInitOutputData%WaveElevVisX)
      UB(1:1) = ubound(SrcInitOutputData%WaveElevVisX)
      if (.not. allocated(DstInitOutputData%WaveElevVisX)) then
         allocate(DstInitOutputData%WaveElevVisX(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WaveElevVisX.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WaveElevVisX = SrcInitOutputData%WaveElevVisX
   end if
   if (allocated(SrcInitOutputData%WaveElevVisY)) then
      LB(1:1) = lbound(SrcInitOutputData%WaveElevVisY)
      UB(1:1) = ubound(SrcInitOutputData%WaveElevVisY)
      if (.not. allocated(DstInitOutputData%WaveElevVisY)) then
         allocate(DstInitOutputData%WaveElevVisY(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WaveElevVisY.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WaveElevVisY = SrcInitOutputData%WaveElevVisY
   end if
   if (allocated(SrcInitOutputData%WaveElevVisGrid)) then
      LB(1:3) = lbound(SrcInitOutputData%WaveElevVisGrid)
      UB(1:3) = ubound(SrcInitOutputData%WaveElevVisGrid)
      if (.not. allocated(DstInitOutputData%WaveElevVisGrid)) then
         allocate(DstInitOutputData%WaveElevVisGrid(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WaveElevVisGrid.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WaveElevVisGrid = SrcInitOutputData%WaveElevVisGrid
   end if
   DstInitOutputData%WaveField => SrcInitOutputData%WaveField
   if (allocated(SrcInitOutputData%LinNames_y)) then
      LB(1:1) = lbound(SrcInitOutputData%LinNames_y)
      UB(1:1) = ubound(SrcInitOutputData%LinNames_y)
      if (.not. allocated(DstInitOutputData%LinNames_y)) then
         allocate(DstInitOutputData%LinNames_y(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LinNames_y.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%LinNames_y = SrcInitOutputData%LinNames_y
   end if
   if (allocated(SrcInitOutputData%LinNames_u)) then
      LB(1:1) = lbound(SrcInitOutputData%LinNames_u)
      UB(1:1) = ubound(SrcInitOutputData%LinNames_u)
      if (.not. allocated(DstInitOutputData%LinNames_u)) then
         allocate(DstInitOutputData%LinNames_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LinNames_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%LinNames_u = SrcInitOutputData%LinNames_u
   end if
   if (allocated(SrcInitOutputData%RotFrame_u)) then
      LB(1:1) = lbound(SrcInitOutputData%RotFrame_u)
      UB(1:1) = ubound(SrcInitOutputData%RotFrame_u)
      if (.not. allocated(DstInitOutputData%RotFrame_u)) then
         allocate(DstInitOutputData%RotFrame_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%RotFrame_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%RotFrame_u = SrcInitOutputData%RotFrame_u
   end if
   if (allocated(SrcInitOutputData%RotFrame_y)) then
      LB(1:1) = lbound(SrcInitOutputData%RotFrame_y)
      UB(1:1) = ubound(SrcInitOutputData%RotFrame_y)
      if (.not. allocated(DstInitOutputData%RotFrame_y)) then
         allocate(DstInitOutputData%RotFrame_y(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%RotFrame_y.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%RotFrame_y = SrcInitOutputData%RotFrame_y
   end if
   if (allocated(SrcInitOutputData%IsLoad_u)) then
      LB(1:1) = lbound(SrcInitOutputData%IsLoad_u)
      UB(1:1) = ubound(SrcInitOutputData%IsLoad_u)
      if (.not. allocated(DstInitOutputData%IsLoad_u)) then
         allocate(DstInitOutputData%IsLoad_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%IsLoad_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%IsLoad_u = SrcInitOutputData%IsLoad_u
   end if
end subroutine

subroutine SeaSt_DestroyInitOutput(InitOutputData, ErrStat, ErrMsg)
   type(SeaSt_InitOutputType), intent(inout) :: InitOutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SeaSt_DestroyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InitOutputData%WriteOutputHdr)) then
      deallocate(InitOutputData%WriteOutputHdr)
   end if
   if (allocated(InitOutputData%WriteOutputUnt)) then
      deallocate(InitOutputData%WriteOutputUnt)
   end if
   call NWTC_Library_DestroyProgDesc(InitOutputData%Ver, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(InitOutputData%WaveElevVisX)) then
      deallocate(InitOutputData%WaveElevVisX)
   end if
   if (allocated(InitOutputData%WaveElevVisY)) then
      deallocate(InitOutputData%WaveElevVisY)
   end if
   if (allocated(InitOutputData%WaveElevVisGrid)) then
      deallocate(InitOutputData%WaveElevVisGrid)
   end if
   nullify(InitOutputData%WaveField)
   if (allocated(InitOutputData%LinNames_y)) then
      deallocate(InitOutputData%LinNames_y)
   end if
   if (allocated(InitOutputData%LinNames_u)) then
      deallocate(InitOutputData%LinNames_u)
   end if
   if (allocated(InitOutputData%RotFrame_u)) then
      deallocate(InitOutputData%RotFrame_u)
   end if
   if (allocated(InitOutputData%RotFrame_y)) then
      deallocate(InitOutputData%RotFrame_y)
   end if
   if (allocated(InitOutputData%IsLoad_u)) then
      deallocate(InitOutputData%IsLoad_u)
   end if
end subroutine

subroutine SeaSt_PackInitOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SeaSt_InitOutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SeaSt_PackInitOutput'
   logical         :: PtrInIndex
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%WriteOutputHdr)
   call RegPackAlloc(RF, InData%WriteOutputUnt)
   call NWTC_Library_PackProgDesc(RF, InData%Ver) 
   call RegPack(RF, InData%InvalidWithSSExctn)
   call RegPackAlloc(RF, InData%WaveElevVisX)
   call RegPackAlloc(RF, InData%WaveElevVisY)
   call RegPackAlloc(RF, InData%WaveElevVisGrid)
   call RegPack(RF, associated(InData%WaveField))
   if (associated(InData%WaveField)) then
      call RegPackPointer(RF, c_loc(InData%WaveField), PtrInIndex)
      if (.not. PtrInIndex) then
         call SeaSt_WaveField_PackSeaSt_WaveFieldType(RF, InData%WaveField) 
      end if
   end if
   call RegPackAlloc(RF, InData%LinNames_y)
   call RegPackAlloc(RF, InData%LinNames_u)
   call RegPackAlloc(RF, InData%RotFrame_u)
   call RegPackAlloc(RF, InData%RotFrame_y)
   call RegPackAlloc(RF, InData%IsLoad_u)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SeaSt_UnPackInitOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SeaSt_InitOutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SeaSt_UnPackInitOutput'
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   integer(B8Ki)   :: PtrIdx
   type(c_ptr)     :: Ptr
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%WriteOutputHdr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutputUnt); if (RegCheckErr(RF, RoutineName)) return
   call NWTC_Library_UnpackProgDesc(RF, OutData%Ver) ! Ver 
   call RegUnpack(RF, OutData%InvalidWithSSExctn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WaveElevVisX); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WaveElevVisY); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WaveElevVisGrid); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%WaveField)) deallocate(OutData%WaveField)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackPointer(RF, Ptr, PtrIdx); if (RegCheckErr(RF, RoutineName)) return
      if (c_associated(Ptr)) then
         call c_f_pointer(Ptr, OutData%WaveField)
      else
         allocate(OutData%WaveField,stat=stat)
         if (stat /= 0) then 
            call SetErrStat(ErrID_Fatal, 'Error allocating OutData%WaveField.', RF%ErrStat, RF%ErrMsg, RoutineName)
            return
         end if
         RF%Pointers(PtrIdx) = c_loc(OutData%WaveField)
         call SeaSt_WaveField_UnpackSeaSt_WaveFieldType(RF, OutData%WaveField) ! WaveField 
      end if
   else
      OutData%WaveField => null()
   end if
   call RegUnpackAlloc(RF, OutData%LinNames_y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LinNames_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RotFrame_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RotFrame_y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%IsLoad_u); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SeaSt_CopyContState(SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg)
   type(SeaSt_ContinuousStateType), intent(in) :: SrcContStateData
   type(SeaSt_ContinuousStateType), intent(inout) :: DstContStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SeaSt_CopyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstContStateData%UnusedStates = SrcContStateData%UnusedStates
end subroutine

subroutine SeaSt_DestroyContState(ContStateData, ErrStat, ErrMsg)
   type(SeaSt_ContinuousStateType), intent(inout) :: ContStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SeaSt_DestroyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine SeaSt_PackContState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SeaSt_ContinuousStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SeaSt_PackContState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%UnusedStates)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SeaSt_UnPackContState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SeaSt_ContinuousStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SeaSt_UnPackContState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%UnusedStates); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SeaSt_CopyDiscState(SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg)
   type(SeaSt_DiscreteStateType), intent(in) :: SrcDiscStateData
   type(SeaSt_DiscreteStateType), intent(inout) :: DstDiscStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SeaSt_CopyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstDiscStateData%UnusedStates = SrcDiscStateData%UnusedStates
end subroutine

subroutine SeaSt_DestroyDiscState(DiscStateData, ErrStat, ErrMsg)
   type(SeaSt_DiscreteStateType), intent(inout) :: DiscStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SeaSt_DestroyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine SeaSt_PackDiscState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SeaSt_DiscreteStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SeaSt_PackDiscState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%UnusedStates)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SeaSt_UnPackDiscState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SeaSt_DiscreteStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SeaSt_UnPackDiscState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%UnusedStates); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SeaSt_CopyConstrState(SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg)
   type(SeaSt_ConstraintStateType), intent(in) :: SrcConstrStateData
   type(SeaSt_ConstraintStateType), intent(inout) :: DstConstrStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SeaSt_CopyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstConstrStateData%UnusedStates = SrcConstrStateData%UnusedStates
end subroutine

subroutine SeaSt_DestroyConstrState(ConstrStateData, ErrStat, ErrMsg)
   type(SeaSt_ConstraintStateType), intent(inout) :: ConstrStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SeaSt_DestroyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine SeaSt_PackConstrState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SeaSt_ConstraintStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SeaSt_PackConstrState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%UnusedStates)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SeaSt_UnPackConstrState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SeaSt_ConstraintStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SeaSt_UnPackConstrState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%UnusedStates); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SeaSt_CopyOtherState(SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg)
   type(SeaSt_OtherStateType), intent(in) :: SrcOtherStateData
   type(SeaSt_OtherStateType), intent(inout) :: DstOtherStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SeaSt_CopyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstOtherStateData%UnusedStates = SrcOtherStateData%UnusedStates
end subroutine

subroutine SeaSt_DestroyOtherState(OtherStateData, ErrStat, ErrMsg)
   type(SeaSt_OtherStateType), intent(inout) :: OtherStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SeaSt_DestroyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine SeaSt_PackOtherState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SeaSt_OtherStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SeaSt_PackOtherState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%UnusedStates)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SeaSt_UnPackOtherState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SeaSt_OtherStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SeaSt_UnPackOtherState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%UnusedStates); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SeaSt_CopyMisc(SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg)
   type(SeaSt_MiscVarType), intent(in) :: SrcMiscData
   type(SeaSt_MiscVarType), intent(inout) :: DstMiscData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SeaSt_CopyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstMiscData%Decimate = SrcMiscData%Decimate
   DstMiscData%LastOutTime = SrcMiscData%LastOutTime
   DstMiscData%LastIndWave = SrcMiscData%LastIndWave
   call SeaSt_WaveField_CopyMisc(SrcMiscData%WaveField_m, DstMiscData%WaveField_m, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine SeaSt_DestroyMisc(MiscData, ErrStat, ErrMsg)
   type(SeaSt_MiscVarType), intent(inout) :: MiscData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SeaSt_DestroyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call SeaSt_WaveField_DestroyMisc(MiscData%WaveField_m, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine SeaSt_PackMisc(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SeaSt_MiscVarType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SeaSt_PackMisc'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%Decimate)
   call RegPack(RF, InData%LastOutTime)
   call RegPack(RF, InData%LastIndWave)
   call SeaSt_WaveField_PackMisc(RF, InData%WaveField_m) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SeaSt_UnPackMisc(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SeaSt_MiscVarType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SeaSt_UnPackMisc'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%Decimate); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LastOutTime); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LastIndWave); if (RegCheckErr(RF, RoutineName)) return
   call SeaSt_WaveField_UnpackMisc(RF, OutData%WaveField_m) ! WaveField_m 
end subroutine

subroutine SeaSt_CopyJac_u_idxStarts(SrcJac_u_idxStartsData, DstJac_u_idxStartsData, CtrlCode, ErrStat, ErrMsg)
   type(Jac_u_idxStarts), intent(in) :: SrcJac_u_idxStartsData
   type(Jac_u_idxStarts), intent(inout) :: DstJac_u_idxStartsData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SeaSt_CopyJac_u_idxStarts'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstJac_u_idxStartsData%Extended = SrcJac_u_idxStartsData%Extended
end subroutine

subroutine SeaSt_DestroyJac_u_idxStarts(Jac_u_idxStartsData, ErrStat, ErrMsg)
   type(Jac_u_idxStarts), intent(inout) :: Jac_u_idxStartsData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SeaSt_DestroyJac_u_idxStarts'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine SeaSt_PackJac_u_idxStarts(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Jac_u_idxStarts), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SeaSt_PackJac_u_idxStarts'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%Extended)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SeaSt_UnPackJac_u_idxStarts(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Jac_u_idxStarts), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SeaSt_UnPackJac_u_idxStarts'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%Extended); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SeaSt_CopyJac_y_idxStarts(SrcJac_y_idxStartsData, DstJac_y_idxStartsData, CtrlCode, ErrStat, ErrMsg)
   type(Jac_y_idxStarts), intent(in) :: SrcJac_y_idxStartsData
   type(Jac_y_idxStarts), intent(inout) :: DstJac_y_idxStartsData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SeaSt_CopyJac_y_idxStarts'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstJac_y_idxStartsData%Extended = SrcJac_y_idxStartsData%Extended
   DstJac_y_idxStartsData%WrOuts = SrcJac_y_idxStartsData%WrOuts
end subroutine

subroutine SeaSt_DestroyJac_y_idxStarts(Jac_y_idxStartsData, ErrStat, ErrMsg)
   type(Jac_y_idxStarts), intent(inout) :: Jac_y_idxStartsData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SeaSt_DestroyJac_y_idxStarts'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine SeaSt_PackJac_y_idxStarts(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Jac_y_idxStarts), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SeaSt_PackJac_y_idxStarts'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%Extended)
   call RegPack(RF, InData%WrOuts)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SeaSt_UnPackJac_y_idxStarts(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Jac_y_idxStarts), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SeaSt_UnPackJac_y_idxStarts'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%Extended); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WrOuts); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SeaSt_CopyLinParams(SrcLinParamsData, DstLinParamsData, CtrlCode, ErrStat, ErrMsg)
   type(SeaSt_LinParams), intent(in) :: SrcLinParamsData
   type(SeaSt_LinParams), intent(inout) :: DstLinParamsData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SeaSt_CopyLinParams'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstLinParamsData%NumExtendedInputs = SrcLinParamsData%NumExtendedInputs
   DstLinParamsData%NumExtendedOutputs = SrcLinParamsData%NumExtendedOutputs
   call SeaSt_CopyJac_u_idxStarts(SrcLinParamsData%Jac_u_idxStartList, DstLinParamsData%Jac_u_idxStartList, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call SeaSt_CopyJac_y_idxStarts(SrcLinParamsData%Jac_y_idxStartList, DstLinParamsData%Jac_y_idxStartList, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcLinParamsData%du)) then
      LB(1:1) = lbound(SrcLinParamsData%du)
      UB(1:1) = ubound(SrcLinParamsData%du)
      if (.not. allocated(DstLinParamsData%du)) then
         allocate(DstLinParamsData%du(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinParamsData%du.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLinParamsData%du = SrcLinParamsData%du
   end if
   DstLinParamsData%Jac_nu = SrcLinParamsData%Jac_nu
   DstLinParamsData%Jac_ny = SrcLinParamsData%Jac_ny
end subroutine

subroutine SeaSt_DestroyLinParams(LinParamsData, ErrStat, ErrMsg)
   type(SeaSt_LinParams), intent(inout) :: LinParamsData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SeaSt_DestroyLinParams'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call SeaSt_DestroyJac_u_idxStarts(LinParamsData%Jac_u_idxStartList, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call SeaSt_DestroyJac_y_idxStarts(LinParamsData%Jac_y_idxStartList, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(LinParamsData%du)) then
      deallocate(LinParamsData%du)
   end if
end subroutine

subroutine SeaSt_PackLinParams(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SeaSt_LinParams), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SeaSt_PackLinParams'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%NumExtendedInputs)
   call RegPack(RF, InData%NumExtendedOutputs)
   call SeaSt_PackJac_u_idxStarts(RF, InData%Jac_u_idxStartList) 
   call SeaSt_PackJac_y_idxStarts(RF, InData%Jac_y_idxStartList) 
   call RegPackAlloc(RF, InData%du)
   call RegPack(RF, InData%Jac_nu)
   call RegPack(RF, InData%Jac_ny)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SeaSt_UnPackLinParams(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SeaSt_LinParams), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SeaSt_UnPackLinParams'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%NumExtendedInputs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumExtendedOutputs); if (RegCheckErr(RF, RoutineName)) return
   call SeaSt_UnpackJac_u_idxStarts(RF, OutData%Jac_u_idxStartList) ! Jac_u_idxStartList 
   call SeaSt_UnpackJac_y_idxStarts(RF, OutData%Jac_y_idxStartList) ! Jac_y_idxStartList 
   call RegUnpackAlloc(RF, OutData%du); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Jac_nu); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Jac_ny); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SeaSt_CopyParam(SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg)
   type(SeaSt_ParameterType), intent(in) :: SrcParamData
   type(SeaSt_ParameterType), intent(inout) :: DstParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SeaSt_CopyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstParamData%WaveDT = SrcParamData%WaveDT
   DstParamData%NGridPts = SrcParamData%NGridPts
   DstParamData%NGrid = SrcParamData%NGrid
   DstParamData%deltaGrid = SrcParamData%deltaGrid
   DstParamData%NWaveElev = SrcParamData%NWaveElev
   if (allocated(SrcParamData%WaveElevxi)) then
      LB(1:1) = lbound(SrcParamData%WaveElevxi)
      UB(1:1) = ubound(SrcParamData%WaveElevxi)
      if (.not. allocated(DstParamData%WaveElevxi)) then
         allocate(DstParamData%WaveElevxi(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%WaveElevxi.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%WaveElevxi = SrcParamData%WaveElevxi
   end if
   if (allocated(SrcParamData%WaveElevyi)) then
      LB(1:1) = lbound(SrcParamData%WaveElevyi)
      UB(1:1) = ubound(SrcParamData%WaveElevyi)
      if (.not. allocated(DstParamData%WaveElevyi)) then
         allocate(DstParamData%WaveElevyi(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%WaveElevyi.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%WaveElevyi = SrcParamData%WaveElevyi
   end if
   DstParamData%NWaveKin = SrcParamData%NWaveKin
   if (allocated(SrcParamData%WaveKinxi)) then
      LB(1:1) = lbound(SrcParamData%WaveKinxi)
      UB(1:1) = ubound(SrcParamData%WaveKinxi)
      if (.not. allocated(DstParamData%WaveKinxi)) then
         allocate(DstParamData%WaveKinxi(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%WaveKinxi.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%WaveKinxi = SrcParamData%WaveKinxi
   end if
   if (allocated(SrcParamData%WaveKinyi)) then
      LB(1:1) = lbound(SrcParamData%WaveKinyi)
      UB(1:1) = ubound(SrcParamData%WaveKinyi)
      if (.not. allocated(DstParamData%WaveKinyi)) then
         allocate(DstParamData%WaveKinyi(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%WaveKinyi.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%WaveKinyi = SrcParamData%WaveKinyi
   end if
   if (allocated(SrcParamData%WaveKinzi)) then
      LB(1:1) = lbound(SrcParamData%WaveKinzi)
      UB(1:1) = ubound(SrcParamData%WaveKinzi)
      if (.not. allocated(DstParamData%WaveKinzi)) then
         allocate(DstParamData%WaveKinzi(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%WaveKinzi.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%WaveKinzi = SrcParamData%WaveKinzi
   end if
   if (allocated(SrcParamData%OutParam)) then
      LB(1:1) = lbound(SrcParamData%OutParam)
      UB(1:1) = ubound(SrcParamData%OutParam)
      if (.not. allocated(DstParamData%OutParam)) then
         allocate(DstParamData%OutParam(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%OutParam.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyOutParmType(SrcParamData%OutParam(i1), DstParamData%OutParam(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstParamData%NumOuts = SrcParamData%NumOuts
   DstParamData%OutSwtch = SrcParamData%OutSwtch
   DstParamData%OutFmt = SrcParamData%OutFmt
   DstParamData%OutSFmt = SrcParamData%OutSFmt
   DstParamData%Delim = SrcParamData%Delim
   DstParamData%UnOutFile = SrcParamData%UnOutFile
   DstParamData%OutDec = SrcParamData%OutDec
   if (associated(SrcParamData%WaveField)) then
      if (.not. associated(DstParamData%WaveField)) then
         allocate(DstParamData%WaveField, stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%WaveField.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      call SeaSt_WaveField_CopySeaSt_WaveFieldType(SrcParamData%WaveField, DstParamData%WaveField, CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end if
   call SeaSt_CopyLinParams(SrcParamData%LinParams, DstParamData%LinParams, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine SeaSt_DestroyParam(ParamData, ErrStat, ErrMsg)
   type(SeaSt_ParameterType), intent(inout) :: ParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SeaSt_DestroyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ParamData%WaveElevxi)) then
      deallocate(ParamData%WaveElevxi)
   end if
   if (allocated(ParamData%WaveElevyi)) then
      deallocate(ParamData%WaveElevyi)
   end if
   if (allocated(ParamData%WaveKinxi)) then
      deallocate(ParamData%WaveKinxi)
   end if
   if (allocated(ParamData%WaveKinyi)) then
      deallocate(ParamData%WaveKinyi)
   end if
   if (allocated(ParamData%WaveKinzi)) then
      deallocate(ParamData%WaveKinzi)
   end if
   if (allocated(ParamData%OutParam)) then
      LB(1:1) = lbound(ParamData%OutParam)
      UB(1:1) = ubound(ParamData%OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyOutParmType(ParamData%OutParam(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%OutParam)
   end if
   if (associated(ParamData%WaveField)) then
      call SeaSt_WaveField_DestroySeaSt_WaveFieldType(ParamData%WaveField, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      deallocate(ParamData%WaveField)
      ParamData%WaveField => null()
   end if
   call SeaSt_DestroyLinParams(ParamData%LinParams, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine SeaSt_PackParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SeaSt_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SeaSt_PackParam'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   logical         :: PtrInIndex
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%WaveDT)
   call RegPack(RF, InData%NGridPts)
   call RegPack(RF, InData%NGrid)
   call RegPack(RF, InData%deltaGrid)
   call RegPack(RF, InData%NWaveElev)
   call RegPackAlloc(RF, InData%WaveElevxi)
   call RegPackAlloc(RF, InData%WaveElevyi)
   call RegPack(RF, InData%NWaveKin)
   call RegPackAlloc(RF, InData%WaveKinxi)
   call RegPackAlloc(RF, InData%WaveKinyi)
   call RegPackAlloc(RF, InData%WaveKinzi)
   call RegPack(RF, allocated(InData%OutParam))
   if (allocated(InData%OutParam)) then
      call RegPackBounds(RF, 1, lbound(InData%OutParam), ubound(InData%OutParam))
      LB(1:1) = lbound(InData%OutParam)
      UB(1:1) = ubound(InData%OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackOutParmType(RF, InData%OutParam(i1)) 
      end do
   end if
   call RegPack(RF, InData%NumOuts)
   call RegPack(RF, InData%OutSwtch)
   call RegPack(RF, InData%OutFmt)
   call RegPack(RF, InData%OutSFmt)
   call RegPack(RF, InData%Delim)
   call RegPack(RF, InData%UnOutFile)
   call RegPack(RF, InData%OutDec)
   call RegPack(RF, associated(InData%WaveField))
   if (associated(InData%WaveField)) then
      call RegPackPointer(RF, c_loc(InData%WaveField), PtrInIndex)
      if (.not. PtrInIndex) then
         call SeaSt_WaveField_PackSeaSt_WaveFieldType(RF, InData%WaveField) 
      end if
   end if
   call SeaSt_PackLinParams(RF, InData%LinParams) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SeaSt_UnPackParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SeaSt_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SeaSt_UnPackParam'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   integer(B8Ki)   :: PtrIdx
   type(c_ptr)     :: Ptr
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%WaveDT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NGridPts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NGrid); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%deltaGrid); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NWaveElev); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WaveElevxi); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WaveElevyi); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NWaveKin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WaveKinxi); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WaveKinyi); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WaveKinzi); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%OutParam)) deallocate(OutData%OutParam)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%OutParam(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%OutParam.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackOutParmType(RF, OutData%OutParam(i1)) ! OutParam 
      end do
   end if
   call RegUnpack(RF, OutData%NumOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutSwtch); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutFmt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutSFmt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Delim); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UnOutFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutDec); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%WaveField)) deallocate(OutData%WaveField)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackPointer(RF, Ptr, PtrIdx); if (RegCheckErr(RF, RoutineName)) return
      if (c_associated(Ptr)) then
         call c_f_pointer(Ptr, OutData%WaveField)
      else
         allocate(OutData%WaveField,stat=stat)
         if (stat /= 0) then 
            call SetErrStat(ErrID_Fatal, 'Error allocating OutData%WaveField.', RF%ErrStat, RF%ErrMsg, RoutineName)
            return
         end if
         RF%Pointers(PtrIdx) = c_loc(OutData%WaveField)
         call SeaSt_WaveField_UnpackSeaSt_WaveFieldType(RF, OutData%WaveField) ! WaveField 
      end if
   else
      OutData%WaveField => null()
   end if
   call SeaSt_UnpackLinParams(RF, OutData%LinParams) ! LinParams 
end subroutine

subroutine SeaSt_CopyInput(SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg)
   type(SeaSt_InputType), intent(in) :: SrcInputData
   type(SeaSt_InputType), intent(inout) :: DstInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SeaSt_CopyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInputData%DummyInput = SrcInputData%DummyInput
end subroutine

subroutine SeaSt_DestroyInput(InputData, ErrStat, ErrMsg)
   type(SeaSt_InputType), intent(inout) :: InputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SeaSt_DestroyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine SeaSt_PackInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SeaSt_InputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SeaSt_PackInput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyInput)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SeaSt_UnPackInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SeaSt_InputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SeaSt_UnPackInput'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyInput); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SeaSt_CopyOutput(SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg)
   type(SeaSt_OutputType), intent(in) :: SrcOutputData
   type(SeaSt_OutputType), intent(inout) :: DstOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'SeaSt_CopyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcOutputData%WriteOutput)) then
      LB(1:1) = lbound(SrcOutputData%WriteOutput)
      UB(1:1) = ubound(SrcOutputData%WriteOutput)
      if (.not. allocated(DstOutputData%WriteOutput)) then
         allocate(DstOutputData%WriteOutput(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%WriteOutput.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%WriteOutput = SrcOutputData%WriteOutput
   end if
end subroutine

subroutine SeaSt_DestroyOutput(OutputData, ErrStat, ErrMsg)
   type(SeaSt_OutputType), intent(inout) :: OutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SeaSt_DestroyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(OutputData%WriteOutput)) then
      deallocate(OutputData%WriteOutput)
   end if
end subroutine

subroutine SeaSt_PackOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SeaSt_OutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SeaSt_PackOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%WriteOutput)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SeaSt_UnPackOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SeaSt_OutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SeaSt_UnPackOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%WriteOutput); if (RegCheckErr(RF, RoutineName)) return
end subroutine
END MODULE SeaState_Types
!ENDOFREGISTRYGENERATEDFILE
