!STARTOFREGISTRYGENERATEDFILE 'SeaSt_WaveField_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! SeaSt_WaveField_Types
!.................................................................................................................................
! This file is part of SeaSt_WaveField.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in SeaSt_WaveField. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE SeaSt_WaveField_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE Current_Types
USE NWTC_Library
IMPLICIT NONE
    INTEGER(IntKi), PUBLIC, PARAMETER  :: WaveDirMod_None = 0      ! WaveDirMod = 0 [Directional spreading function is NONE] [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: WaveDirMod_COS2S = 1      ! WaveDirMod = 1 [Directional spreading function is COS2S] [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: WaveMod_None = 0      ! WaveMod = 0   [Incident wave kinematics model: NONE (still water)] [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: WaveMod_Regular = 1      ! WaveMod = 1   [Incident wave kinematics model: Regular (periodic)] [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: WaveMod_RegularUsrPh = 10      ! WaveMod = 1P# [Incident wave kinematics model: Regular (user specified phase)] [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: WaveMod_JONSWAP = 2      ! WaveMod = 2   [Incident wave kinematics model: JONSWAP/Pierson-Moskowitz spectrum (irregular)] [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: WaveMod_WhiteNoise = 3      ! WaveMod = 3   [Incident wave kinematics model: White noise spectrum (irregular)] [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: WaveMod_UserSpctrm = 4      ! WaveMod = 4   [Incident wave kinematics model: user-defined spectrum from routine UserWaveSpctrm (irregular)] [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: WaveMod_ExtElev = 5      ! WaveMod = 5   [Incident wave kinematics model: Externally generated wave-elevation time series] [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: WaveMod_ExtFull = 6      ! WaveMod = 6   [Incident wave kinematics model: Externally generated full wave-kinematics time series (invalid for PotMod/=0)] [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: WaveMod_UserFreq = 7      ! WaveMod = 7   [Incident wave kinematics model: user-defined wave frequency components] [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: ConstWaveMod_None = 0      ! ConstWaveMod = 0 [Constrained wave model: No constrained waves] [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: ConstWaveMod_CrestElev = 1      ! ConstWaveMod = 1 [Constrained wave model: Constrained wave with specified crest elevation, alpha] [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: ConstWaveMod_Peak2Trough = 2      ! ConstWaveMod = 2 [Constrained wave model: Constrained wave with guaranteed peak-to-trough crest height, HCrest] [-]
! =========  SeaSt_WaveField_ParameterType  =======
  TYPE, PUBLIC :: SeaSt_WaveField_ParameterType
    INTEGER(IntKi) , DIMENSION(1:4)  :: n = 0_IntKi      !< number of evenly-spaced grid points in the t, x, y, and z directions [-]
    REAL(ReKi) , DIMENSION(1:4)  :: delta = 0.0_ReKi      !< size between 2 consecutive grid points in each grid direction [s,m,m,m]
    REAL(ReKi) , DIMENSION(1:4)  :: pZero = 0.0_ReKi      !< fixed position of the XYZ grid (i.e., XYZ coordinates of m%V(:,1,1,1,:)) [m]
    REAL(ReKi)  :: Z_Depth = 0.0_ReKi      !< grid depth [m]
  END TYPE SeaSt_WaveField_ParameterType
! =======================
! =========  SeaSt_WaveField_MiscVarType  =======
  TYPE, PUBLIC :: SeaSt_WaveField_MiscVarType
    REAL(SiKi) , DIMENSION(1:8)  :: N3D = 0.0_R4Ki      !< this is the weighting function for 3-d velocity field [-]
    REAL(SiKi) , DIMENSION(1:16)  :: N4D = 0.0_R4Ki      !< this is the weighting function for 4-d velocity field [-]
    INTEGER(IntKi) , DIMENSION(1:4)  :: Indx_Lo = 0_IntKi      !< this is the index into the 4-d velocity field for each wave component [-]
    INTEGER(IntKi) , DIMENSION(1:4)  :: Indx_Hi = 0_IntKi      !< this is the index into the 4-d velocity field for each wave component [-]
    LOGICAL  :: FirstWarn_Clamp = .true.      !< used to avoid too many 'Position has been clamped to the grid boundary' warning messages  [-]
  END TYPE SeaSt_WaveField_MiscVarType
! =======================
! =========  SeaSt_WaveFieldType  =======
  TYPE, PUBLIC :: SeaSt_WaveFieldType
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: WaveTime      !< Time array [(s)]
    REAL(SiKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: WaveDynP      !< Incident wave dynamic pressure [(N/m^2)]
    REAL(SiKi) , DIMENSION(:,:,:,:,:), ALLOCATABLE  :: WaveAcc      !< Incident wave acceleration [(m/s^2)]
    REAL(SiKi) , DIMENSION(:,:,:,:,:), ALLOCATABLE  :: WaveAccMCF      !< Scaled acceleration for MacCamy-Fuchs members [(m/s^2)]
    REAL(SiKi) , DIMENSION(:,:,:,:,:), ALLOCATABLE  :: WaveVel      !< Incident wave velocity [(m/s)]
    REAL(SiKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PWaveDynP0      !< Partial derivative of dynamic pressure in the vertical direction at the still water level [(Pa/m)]
    REAL(SiKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: PWaveAcc0      !< Partial derivative of incident wave acceleration in the vertical direction at the still water level [(m/s^2/m)]
    REAL(SiKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: PWaveAccMCF0      !< Partial derivative of scaled wave acceleration in the vertical direction at the still water level for MacCamy-Fuchs members [(m/s^2/m)]
    REAL(SiKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: PWaveVel0      !< Partial derivative of incident wave velocity in the vertical direction at the still water level [(m/s/m)]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: WaveElev0      !< Instantaneous elevation time-series of incident waves at the platform reference point (NOTE THAT THIS CAN GET MODIFIED IN WAMIT) [(m)]
    REAL(SiKi) , DIMENSION(:,:,:), ALLOCATABLE  :: WaveElev1      !< First order wave elevation [(m)]
    REAL(SiKi) , DIMENSION(:,:,:), ALLOCATABLE  :: WaveElev2      !< Second order wave elevation [(m)]
    TYPE(SeaSt_WaveField_ParameterType)  :: GridParams      !< Parameters for grid spacing [(-)]
    INTEGER(IntKi)  :: WaveStMod = 0_IntKi      !< Wave stretching model [-]
    REAL(ReKi)  :: EffWtrDpth = 0.0_ReKi      !< Water depth [(-)]
    REAL(ReKi)  :: MSL2SWL = 0.0_ReKi      !< Vertical distance from mean sea level to still water level [(m)]
    REAL(SiKi) , DIMENSION(:,:,:), ALLOCATABLE  :: WaveElevC      !< Discrete Fourier transform of the instantaneous elevation of incident waves at all grid points.  First column is real part, second column is imaginary part [(m)]
    REAL(SiKi) , DIMENSION(:,:), ALLOCATABLE  :: WaveElevC0      !< Fourier components of the incident wave elevation at the platform reference point. First column is the real part; second column is the imaginary part [(m)]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: WaveDirArr      !< Wave direction array. Each frequency has a unique direction of WaveNDir > 1 [(degrees)]
    REAL(ReKi)  :: WtrDpth = 0.0_ReKi      !< Water depth, this is necessary to inform glue-code what the module is using for WtrDpth (may not be the glue-code's default) [(m)]
    REAL(ReKi)  :: WtrDens = 0.0_ReKi      !< Water density, this is necessary to inform glue-code what the module is using for WtrDens (may not be the glue-code's default) [(kg/m^3)]
    REAL(SiKi)  :: RhoXg = 0.0_R4Ki      !< = WtrDens*Gravity [-]
    REAL(SiKi)  :: WaveDirMin = 0.0_R4Ki      !< Minimum wave direction. [(degrees)]
    REAL(SiKi)  :: WaveDirMax = 0.0_R4Ki      !< Maximum wave direction. [(degrees)]
    REAL(SiKi)  :: WaveDir = 0.0_R4Ki      !< Incident wave propagation heading direction [(degrees)]
    LOGICAL  :: WaveMultiDir = .false.      !< Indicates the waves are multidirectional -- set by HydroDyn_Input [-]
    REAL(SiKi)  :: MCFD = 0.0_R4Ki      !< Diameter of members that will use the MacCamy-Fuchs diffraction model [-]
    REAL(SiKi)  :: WvLowCOff = 0.0_R4Ki      !< Low cut-off frequency or lower frequency limit of the wave spectrum beyond which the wave spectrum is zeroed.  [used only when WaveMod=2,3,4] [(rad/s)]
    REAL(SiKi)  :: WvHiCOff = 0.0_R4Ki      !< High cut-off frequency or upper frequency limit of the wave spectrum beyond which the wave spectrum is zeroed.  [used only when WaveMod=2,3,4] [(rad/s)]
    REAL(SiKi)  :: WvLowCOffD = 0.0_R4Ki      !< Minimum frequency used in the difference methods [Ignored if all difference methods = 0] [(rad/s)]
    REAL(SiKi)  :: WvHiCOffD = 0.0_R4Ki      !< Maximum frequency used in the difference methods [Ignored if all difference methods = 0] [(rad/s)]
    REAL(SiKi)  :: WvLowCOffS = 0.0_R4Ki      !< Minimum frequency used in the sum-QTF method     [Ignored if SumQTF = 0] [(rad/s)]
    REAL(SiKi)  :: WvHiCOffS = 0.0_R4Ki      !< Maximum frequency used in the sum-QTF method     [Ignored if SumQTF = 0] [(rad/s)]
    REAL(SiKi)  :: WaveDOmega = 0.0_R4Ki      !< Frequency step for incident wave calculations [(rad/s)]
    INTEGER(IntKi)  :: WaveMod = 0_IntKi      !< Incident wave kinematics model: See valid values in SeaSt_WaveField module parameters. [-]
    INTEGER(IntKi)  :: NStepWave = 0_IntKi      !< Total number of frequency components = total number of time steps in the incident wave [-]
    INTEGER(IntKi)  :: NStepWave2 = 0_IntKi      !< NStepWave / 2 [-]
    TYPE(Current_InitInputType)  :: Current_InitInput      !< InitInputs in the Current Module. For coupling with MD. [-]
  END TYPE SeaSt_WaveFieldType
! =======================
CONTAINS

subroutine SeaSt_WaveField_CopyParam(SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg)
   type(SeaSt_WaveField_ParameterType), intent(in) :: SrcParamData
   type(SeaSt_WaveField_ParameterType), intent(inout) :: DstParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SeaSt_WaveField_CopyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstParamData%n = SrcParamData%n
   DstParamData%delta = SrcParamData%delta
   DstParamData%pZero = SrcParamData%pZero
   DstParamData%Z_Depth = SrcParamData%Z_Depth
end subroutine

subroutine SeaSt_WaveField_DestroyParam(ParamData, ErrStat, ErrMsg)
   type(SeaSt_WaveField_ParameterType), intent(inout) :: ParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SeaSt_WaveField_DestroyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine SeaSt_WaveField_PackParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SeaSt_WaveField_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SeaSt_WaveField_PackParam'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%n)
   call RegPack(RF, InData%delta)
   call RegPack(RF, InData%pZero)
   call RegPack(RF, InData%Z_Depth)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SeaSt_WaveField_UnPackParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SeaSt_WaveField_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SeaSt_WaveField_UnPackParam'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%n); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%delta); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%pZero); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Z_Depth); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SeaSt_WaveField_CopyMisc(SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg)
   type(SeaSt_WaveField_MiscVarType), intent(in) :: SrcMiscData
   type(SeaSt_WaveField_MiscVarType), intent(inout) :: DstMiscData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SeaSt_WaveField_CopyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstMiscData%N3D = SrcMiscData%N3D
   DstMiscData%N4D = SrcMiscData%N4D
   DstMiscData%Indx_Lo = SrcMiscData%Indx_Lo
   DstMiscData%Indx_Hi = SrcMiscData%Indx_Hi
   DstMiscData%FirstWarn_Clamp = SrcMiscData%FirstWarn_Clamp
end subroutine

subroutine SeaSt_WaveField_DestroyMisc(MiscData, ErrStat, ErrMsg)
   type(SeaSt_WaveField_MiscVarType), intent(inout) :: MiscData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SeaSt_WaveField_DestroyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine SeaSt_WaveField_PackMisc(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SeaSt_WaveField_MiscVarType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SeaSt_WaveField_PackMisc'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%N3D)
   call RegPack(RF, InData%N4D)
   call RegPack(RF, InData%Indx_Lo)
   call RegPack(RF, InData%Indx_Hi)
   call RegPack(RF, InData%FirstWarn_Clamp)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SeaSt_WaveField_UnPackMisc(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SeaSt_WaveField_MiscVarType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SeaSt_WaveField_UnPackMisc'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%N3D); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%N4D); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Indx_Lo); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Indx_Hi); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FirstWarn_Clamp); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SeaSt_WaveField_CopySeaSt_WaveFieldType(SrcSeaSt_WaveFieldTypeData, DstSeaSt_WaveFieldTypeData, CtrlCode, ErrStat, ErrMsg)
   type(SeaSt_WaveFieldType), intent(in) :: SrcSeaSt_WaveFieldTypeData
   type(SeaSt_WaveFieldType), intent(inout) :: DstSeaSt_WaveFieldTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(5), UB(5)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SeaSt_WaveField_CopySeaSt_WaveFieldType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcSeaSt_WaveFieldTypeData%WaveTime)) then
      LB(1:1) = lbound(SrcSeaSt_WaveFieldTypeData%WaveTime)
      UB(1:1) = ubound(SrcSeaSt_WaveFieldTypeData%WaveTime)
      if (.not. allocated(DstSeaSt_WaveFieldTypeData%WaveTime)) then
         allocate(DstSeaSt_WaveFieldTypeData%WaveTime(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstSeaSt_WaveFieldTypeData%WaveTime.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstSeaSt_WaveFieldTypeData%WaveTime = SrcSeaSt_WaveFieldTypeData%WaveTime
   end if
   if (allocated(SrcSeaSt_WaveFieldTypeData%WaveDynP)) then
      LB(1:4) = lbound(SrcSeaSt_WaveFieldTypeData%WaveDynP)
      UB(1:4) = ubound(SrcSeaSt_WaveFieldTypeData%WaveDynP)
      if (.not. allocated(DstSeaSt_WaveFieldTypeData%WaveDynP)) then
         allocate(DstSeaSt_WaveFieldTypeData%WaveDynP(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstSeaSt_WaveFieldTypeData%WaveDynP.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstSeaSt_WaveFieldTypeData%WaveDynP = SrcSeaSt_WaveFieldTypeData%WaveDynP
   end if
   if (allocated(SrcSeaSt_WaveFieldTypeData%WaveAcc)) then
      LB(1:5) = lbound(SrcSeaSt_WaveFieldTypeData%WaveAcc)
      UB(1:5) = ubound(SrcSeaSt_WaveFieldTypeData%WaveAcc)
      if (.not. allocated(DstSeaSt_WaveFieldTypeData%WaveAcc)) then
         allocate(DstSeaSt_WaveFieldTypeData%WaveAcc(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4),LB(5):UB(5)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstSeaSt_WaveFieldTypeData%WaveAcc.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstSeaSt_WaveFieldTypeData%WaveAcc = SrcSeaSt_WaveFieldTypeData%WaveAcc
   end if
   if (allocated(SrcSeaSt_WaveFieldTypeData%WaveAccMCF)) then
      LB(1:5) = lbound(SrcSeaSt_WaveFieldTypeData%WaveAccMCF)
      UB(1:5) = ubound(SrcSeaSt_WaveFieldTypeData%WaveAccMCF)
      if (.not. allocated(DstSeaSt_WaveFieldTypeData%WaveAccMCF)) then
         allocate(DstSeaSt_WaveFieldTypeData%WaveAccMCF(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4),LB(5):UB(5)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstSeaSt_WaveFieldTypeData%WaveAccMCF.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstSeaSt_WaveFieldTypeData%WaveAccMCF = SrcSeaSt_WaveFieldTypeData%WaveAccMCF
   end if
   if (allocated(SrcSeaSt_WaveFieldTypeData%WaveVel)) then
      LB(1:5) = lbound(SrcSeaSt_WaveFieldTypeData%WaveVel)
      UB(1:5) = ubound(SrcSeaSt_WaveFieldTypeData%WaveVel)
      if (.not. allocated(DstSeaSt_WaveFieldTypeData%WaveVel)) then
         allocate(DstSeaSt_WaveFieldTypeData%WaveVel(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4),LB(5):UB(5)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstSeaSt_WaveFieldTypeData%WaveVel.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstSeaSt_WaveFieldTypeData%WaveVel = SrcSeaSt_WaveFieldTypeData%WaveVel
   end if
   if (allocated(SrcSeaSt_WaveFieldTypeData%PWaveDynP0)) then
      LB(1:3) = lbound(SrcSeaSt_WaveFieldTypeData%PWaveDynP0)
      UB(1:3) = ubound(SrcSeaSt_WaveFieldTypeData%PWaveDynP0)
      if (.not. allocated(DstSeaSt_WaveFieldTypeData%PWaveDynP0)) then
         allocate(DstSeaSt_WaveFieldTypeData%PWaveDynP0(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstSeaSt_WaveFieldTypeData%PWaveDynP0.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstSeaSt_WaveFieldTypeData%PWaveDynP0 = SrcSeaSt_WaveFieldTypeData%PWaveDynP0
   end if
   if (allocated(SrcSeaSt_WaveFieldTypeData%PWaveAcc0)) then
      LB(1:4) = lbound(SrcSeaSt_WaveFieldTypeData%PWaveAcc0)
      UB(1:4) = ubound(SrcSeaSt_WaveFieldTypeData%PWaveAcc0)
      if (.not. allocated(DstSeaSt_WaveFieldTypeData%PWaveAcc0)) then
         allocate(DstSeaSt_WaveFieldTypeData%PWaveAcc0(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstSeaSt_WaveFieldTypeData%PWaveAcc0.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstSeaSt_WaveFieldTypeData%PWaveAcc0 = SrcSeaSt_WaveFieldTypeData%PWaveAcc0
   end if
   if (allocated(SrcSeaSt_WaveFieldTypeData%PWaveAccMCF0)) then
      LB(1:4) = lbound(SrcSeaSt_WaveFieldTypeData%PWaveAccMCF0)
      UB(1:4) = ubound(SrcSeaSt_WaveFieldTypeData%PWaveAccMCF0)
      if (.not. allocated(DstSeaSt_WaveFieldTypeData%PWaveAccMCF0)) then
         allocate(DstSeaSt_WaveFieldTypeData%PWaveAccMCF0(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstSeaSt_WaveFieldTypeData%PWaveAccMCF0.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstSeaSt_WaveFieldTypeData%PWaveAccMCF0 = SrcSeaSt_WaveFieldTypeData%PWaveAccMCF0
   end if
   if (allocated(SrcSeaSt_WaveFieldTypeData%PWaveVel0)) then
      LB(1:4) = lbound(SrcSeaSt_WaveFieldTypeData%PWaveVel0)
      UB(1:4) = ubound(SrcSeaSt_WaveFieldTypeData%PWaveVel0)
      if (.not. allocated(DstSeaSt_WaveFieldTypeData%PWaveVel0)) then
         allocate(DstSeaSt_WaveFieldTypeData%PWaveVel0(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstSeaSt_WaveFieldTypeData%PWaveVel0.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstSeaSt_WaveFieldTypeData%PWaveVel0 = SrcSeaSt_WaveFieldTypeData%PWaveVel0
   end if
   if (allocated(SrcSeaSt_WaveFieldTypeData%WaveElev0)) then
      LB(1:1) = lbound(SrcSeaSt_WaveFieldTypeData%WaveElev0)
      UB(1:1) = ubound(SrcSeaSt_WaveFieldTypeData%WaveElev0)
      if (.not. allocated(DstSeaSt_WaveFieldTypeData%WaveElev0)) then
         allocate(DstSeaSt_WaveFieldTypeData%WaveElev0(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstSeaSt_WaveFieldTypeData%WaveElev0.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstSeaSt_WaveFieldTypeData%WaveElev0 = SrcSeaSt_WaveFieldTypeData%WaveElev0
   end if
   if (allocated(SrcSeaSt_WaveFieldTypeData%WaveElev1)) then
      LB(1:3) = lbound(SrcSeaSt_WaveFieldTypeData%WaveElev1)
      UB(1:3) = ubound(SrcSeaSt_WaveFieldTypeData%WaveElev1)
      if (.not. allocated(DstSeaSt_WaveFieldTypeData%WaveElev1)) then
         allocate(DstSeaSt_WaveFieldTypeData%WaveElev1(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstSeaSt_WaveFieldTypeData%WaveElev1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstSeaSt_WaveFieldTypeData%WaveElev1 = SrcSeaSt_WaveFieldTypeData%WaveElev1
   end if
   if (allocated(SrcSeaSt_WaveFieldTypeData%WaveElev2)) then
      LB(1:3) = lbound(SrcSeaSt_WaveFieldTypeData%WaveElev2)
      UB(1:3) = ubound(SrcSeaSt_WaveFieldTypeData%WaveElev2)
      if (.not. allocated(DstSeaSt_WaveFieldTypeData%WaveElev2)) then
         allocate(DstSeaSt_WaveFieldTypeData%WaveElev2(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstSeaSt_WaveFieldTypeData%WaveElev2.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstSeaSt_WaveFieldTypeData%WaveElev2 = SrcSeaSt_WaveFieldTypeData%WaveElev2
   end if
   call SeaSt_WaveField_CopyParam(SrcSeaSt_WaveFieldTypeData%GridParams, DstSeaSt_WaveFieldTypeData%GridParams, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstSeaSt_WaveFieldTypeData%WaveStMod = SrcSeaSt_WaveFieldTypeData%WaveStMod
   DstSeaSt_WaveFieldTypeData%EffWtrDpth = SrcSeaSt_WaveFieldTypeData%EffWtrDpth
   DstSeaSt_WaveFieldTypeData%MSL2SWL = SrcSeaSt_WaveFieldTypeData%MSL2SWL
   if (allocated(SrcSeaSt_WaveFieldTypeData%WaveElevC)) then
      LB(1:3) = lbound(SrcSeaSt_WaveFieldTypeData%WaveElevC)
      UB(1:3) = ubound(SrcSeaSt_WaveFieldTypeData%WaveElevC)
      if (.not. allocated(DstSeaSt_WaveFieldTypeData%WaveElevC)) then
         allocate(DstSeaSt_WaveFieldTypeData%WaveElevC(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstSeaSt_WaveFieldTypeData%WaveElevC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstSeaSt_WaveFieldTypeData%WaveElevC = SrcSeaSt_WaveFieldTypeData%WaveElevC
   end if
   if (allocated(SrcSeaSt_WaveFieldTypeData%WaveElevC0)) then
      LB(1:2) = lbound(SrcSeaSt_WaveFieldTypeData%WaveElevC0)
      UB(1:2) = ubound(SrcSeaSt_WaveFieldTypeData%WaveElevC0)
      if (.not. allocated(DstSeaSt_WaveFieldTypeData%WaveElevC0)) then
         allocate(DstSeaSt_WaveFieldTypeData%WaveElevC0(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstSeaSt_WaveFieldTypeData%WaveElevC0.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstSeaSt_WaveFieldTypeData%WaveElevC0 = SrcSeaSt_WaveFieldTypeData%WaveElevC0
   end if
   if (allocated(SrcSeaSt_WaveFieldTypeData%WaveDirArr)) then
      LB(1:1) = lbound(SrcSeaSt_WaveFieldTypeData%WaveDirArr)
      UB(1:1) = ubound(SrcSeaSt_WaveFieldTypeData%WaveDirArr)
      if (.not. allocated(DstSeaSt_WaveFieldTypeData%WaveDirArr)) then
         allocate(DstSeaSt_WaveFieldTypeData%WaveDirArr(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstSeaSt_WaveFieldTypeData%WaveDirArr.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstSeaSt_WaveFieldTypeData%WaveDirArr = SrcSeaSt_WaveFieldTypeData%WaveDirArr
   end if
   DstSeaSt_WaveFieldTypeData%WtrDpth = SrcSeaSt_WaveFieldTypeData%WtrDpth
   DstSeaSt_WaveFieldTypeData%WtrDens = SrcSeaSt_WaveFieldTypeData%WtrDens
   DstSeaSt_WaveFieldTypeData%RhoXg = SrcSeaSt_WaveFieldTypeData%RhoXg
   DstSeaSt_WaveFieldTypeData%WaveDirMin = SrcSeaSt_WaveFieldTypeData%WaveDirMin
   DstSeaSt_WaveFieldTypeData%WaveDirMax = SrcSeaSt_WaveFieldTypeData%WaveDirMax
   DstSeaSt_WaveFieldTypeData%WaveDir = SrcSeaSt_WaveFieldTypeData%WaveDir
   DstSeaSt_WaveFieldTypeData%WaveMultiDir = SrcSeaSt_WaveFieldTypeData%WaveMultiDir
   DstSeaSt_WaveFieldTypeData%MCFD = SrcSeaSt_WaveFieldTypeData%MCFD
   DstSeaSt_WaveFieldTypeData%WvLowCOff = SrcSeaSt_WaveFieldTypeData%WvLowCOff
   DstSeaSt_WaveFieldTypeData%WvHiCOff = SrcSeaSt_WaveFieldTypeData%WvHiCOff
   DstSeaSt_WaveFieldTypeData%WvLowCOffD = SrcSeaSt_WaveFieldTypeData%WvLowCOffD
   DstSeaSt_WaveFieldTypeData%WvHiCOffD = SrcSeaSt_WaveFieldTypeData%WvHiCOffD
   DstSeaSt_WaveFieldTypeData%WvLowCOffS = SrcSeaSt_WaveFieldTypeData%WvLowCOffS
   DstSeaSt_WaveFieldTypeData%WvHiCOffS = SrcSeaSt_WaveFieldTypeData%WvHiCOffS
   DstSeaSt_WaveFieldTypeData%WaveDOmega = SrcSeaSt_WaveFieldTypeData%WaveDOmega
   DstSeaSt_WaveFieldTypeData%WaveMod = SrcSeaSt_WaveFieldTypeData%WaveMod
   DstSeaSt_WaveFieldTypeData%NStepWave = SrcSeaSt_WaveFieldTypeData%NStepWave
   DstSeaSt_WaveFieldTypeData%NStepWave2 = SrcSeaSt_WaveFieldTypeData%NStepWave2
   call Current_CopyInitInput(SrcSeaSt_WaveFieldTypeData%Current_InitInput, DstSeaSt_WaveFieldTypeData%Current_InitInput, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine SeaSt_WaveField_DestroySeaSt_WaveFieldType(SeaSt_WaveFieldTypeData, ErrStat, ErrMsg)
   type(SeaSt_WaveFieldType), intent(inout) :: SeaSt_WaveFieldTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SeaSt_WaveField_DestroySeaSt_WaveFieldType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SeaSt_WaveFieldTypeData%WaveTime)) then
      deallocate(SeaSt_WaveFieldTypeData%WaveTime)
   end if
   if (allocated(SeaSt_WaveFieldTypeData%WaveDynP)) then
      deallocate(SeaSt_WaveFieldTypeData%WaveDynP)
   end if
   if (allocated(SeaSt_WaveFieldTypeData%WaveAcc)) then
      deallocate(SeaSt_WaveFieldTypeData%WaveAcc)
   end if
   if (allocated(SeaSt_WaveFieldTypeData%WaveAccMCF)) then
      deallocate(SeaSt_WaveFieldTypeData%WaveAccMCF)
   end if
   if (allocated(SeaSt_WaveFieldTypeData%WaveVel)) then
      deallocate(SeaSt_WaveFieldTypeData%WaveVel)
   end if
   if (allocated(SeaSt_WaveFieldTypeData%PWaveDynP0)) then
      deallocate(SeaSt_WaveFieldTypeData%PWaveDynP0)
   end if
   if (allocated(SeaSt_WaveFieldTypeData%PWaveAcc0)) then
      deallocate(SeaSt_WaveFieldTypeData%PWaveAcc0)
   end if
   if (allocated(SeaSt_WaveFieldTypeData%PWaveAccMCF0)) then
      deallocate(SeaSt_WaveFieldTypeData%PWaveAccMCF0)
   end if
   if (allocated(SeaSt_WaveFieldTypeData%PWaveVel0)) then
      deallocate(SeaSt_WaveFieldTypeData%PWaveVel0)
   end if
   if (allocated(SeaSt_WaveFieldTypeData%WaveElev0)) then
      deallocate(SeaSt_WaveFieldTypeData%WaveElev0)
   end if
   if (allocated(SeaSt_WaveFieldTypeData%WaveElev1)) then
      deallocate(SeaSt_WaveFieldTypeData%WaveElev1)
   end if
   if (allocated(SeaSt_WaveFieldTypeData%WaveElev2)) then
      deallocate(SeaSt_WaveFieldTypeData%WaveElev2)
   end if
   call SeaSt_WaveField_DestroyParam(SeaSt_WaveFieldTypeData%GridParams, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(SeaSt_WaveFieldTypeData%WaveElevC)) then
      deallocate(SeaSt_WaveFieldTypeData%WaveElevC)
   end if
   if (allocated(SeaSt_WaveFieldTypeData%WaveElevC0)) then
      deallocate(SeaSt_WaveFieldTypeData%WaveElevC0)
   end if
   if (allocated(SeaSt_WaveFieldTypeData%WaveDirArr)) then
      deallocate(SeaSt_WaveFieldTypeData%WaveDirArr)
   end if
   call Current_DestroyInitInput(SeaSt_WaveFieldTypeData%Current_InitInput, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine SeaSt_WaveField_PackSeaSt_WaveFieldType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SeaSt_WaveFieldType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SeaSt_WaveField_PackSeaSt_WaveFieldType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%WaveTime)
   call RegPackAlloc(RF, InData%WaveDynP)
   call RegPackAlloc(RF, InData%WaveAcc)
   call RegPackAlloc(RF, InData%WaveAccMCF)
   call RegPackAlloc(RF, InData%WaveVel)
   call RegPackAlloc(RF, InData%PWaveDynP0)
   call RegPackAlloc(RF, InData%PWaveAcc0)
   call RegPackAlloc(RF, InData%PWaveAccMCF0)
   call RegPackAlloc(RF, InData%PWaveVel0)
   call RegPackAlloc(RF, InData%WaveElev0)
   call RegPackAlloc(RF, InData%WaveElev1)
   call RegPackAlloc(RF, InData%WaveElev2)
   call SeaSt_WaveField_PackParam(RF, InData%GridParams) 
   call RegPack(RF, InData%WaveStMod)
   call RegPack(RF, InData%EffWtrDpth)
   call RegPack(RF, InData%MSL2SWL)
   call RegPackAlloc(RF, InData%WaveElevC)
   call RegPackAlloc(RF, InData%WaveElevC0)
   call RegPackAlloc(RF, InData%WaveDirArr)
   call RegPack(RF, InData%WtrDpth)
   call RegPack(RF, InData%WtrDens)
   call RegPack(RF, InData%RhoXg)
   call RegPack(RF, InData%WaveDirMin)
   call RegPack(RF, InData%WaveDirMax)
   call RegPack(RF, InData%WaveDir)
   call RegPack(RF, InData%WaveMultiDir)
   call RegPack(RF, InData%MCFD)
   call RegPack(RF, InData%WvLowCOff)
   call RegPack(RF, InData%WvHiCOff)
   call RegPack(RF, InData%WvLowCOffD)
   call RegPack(RF, InData%WvHiCOffD)
   call RegPack(RF, InData%WvLowCOffS)
   call RegPack(RF, InData%WvHiCOffS)
   call RegPack(RF, InData%WaveDOmega)
   call RegPack(RF, InData%WaveMod)
   call RegPack(RF, InData%NStepWave)
   call RegPack(RF, InData%NStepWave2)
   call Current_PackInitInput(RF, InData%Current_InitInput) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SeaSt_WaveField_UnPackSeaSt_WaveFieldType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SeaSt_WaveFieldType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SeaSt_WaveField_UnPackSeaSt_WaveFieldType'
   integer(B4Ki)   :: LB(5), UB(5)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%WaveTime); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WaveDynP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WaveAcc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WaveAccMCF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WaveVel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PWaveDynP0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PWaveAcc0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PWaveAccMCF0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PWaveVel0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WaveElev0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WaveElev1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WaveElev2); if (RegCheckErr(RF, RoutineName)) return
   call SeaSt_WaveField_UnpackParam(RF, OutData%GridParams) ! GridParams 
   call RegUnpack(RF, OutData%WaveStMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%EffWtrDpth); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MSL2SWL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WaveElevC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WaveElevC0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WaveDirArr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WtrDpth); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WtrDens); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RhoXg); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WaveDirMin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WaveDirMax); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WaveDir); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WaveMultiDir); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MCFD); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WvLowCOff); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WvHiCOff); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WvLowCOffD); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WvHiCOffD); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WvLowCOffS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WvHiCOffS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WaveDOmega); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WaveMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NStepWave); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NStepWave2); if (RegCheckErr(RF, RoutineName)) return
   call Current_UnpackInitInput(RF, OutData%Current_InitInput) ! Current_InitInput 
end subroutine
END MODULE SeaSt_WaveField_Types
!ENDOFREGISTRYGENERATEDFILE
