!STARTOFREGISTRYGENERATEDFILE 'OrcaFlexInterface_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! OrcaFlexInterface_Types
!.................................................................................................................................
! This file is part of OrcaFlexInterface.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in OrcaFlexInterface. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE OrcaFlexInterface_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE NWTC_Library
IMPLICIT NONE
! =========  Orca_InitInputType  =======
  TYPE, PUBLIC :: Orca_InitInputType
    CHARACTER(1024)  :: InputFile      !< Name of the input file; remove if there is no file [-]
    CHARACTER(1024)  :: RootName      !< RootName for writing output files (echo file) [-]
    REAL(ReKi)  :: TMax = 0.0_ReKi      !< Maximum Time [seconds]
  END TYPE Orca_InitInputType
! =======================
! =========  Orca_InitOutputType  =======
  TYPE, PUBLIC :: Orca_InitOutputType
    TYPE(ProgDesc)  :: Ver      !< This module's name, version, and date [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputHdr      !< Names of the output-to-file channels [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputUnt      !< Units of the output-to-file channels [-]
  END TYPE Orca_InitOutputType
! =======================
! =========  Orca_InputFile  =======
  TYPE, PUBLIC :: Orca_InputFile
    CHARACTER(1024)  :: DLL_FileName      !< Name of the DLL file [-]
    CHARACTER(1024)  :: DLL_InitProcName      !< Name of the DLL procedure to call during initialisation [-]
    CHARACTER(1024)  :: DLL_CalcProcName      !< Name of the DLL procedure to call during CalcOutput [-]
    CHARACTER(1024)  :: DLL_EndProcName      !< Name of the DLL procedure to call during End [-]
    CHARACTER(1024)  :: DirRoot      !< Directory and rootname of simulation input file [-]
  END TYPE Orca_InputFile
! =======================
! =========  Orca_OtherStateType  =======
  TYPE, PUBLIC :: Orca_OtherStateType
    REAL(SiKi)  :: DummyOtherState = 0.0_R4Ki      !< Remove if you have OtherStates [-]
  END TYPE Orca_OtherStateType
! =======================
! =========  Orca_MiscVarType  =======
  TYPE, PUBLIC :: Orca_MiscVarType
    REAL(ReKi) , DIMENSION(1:6,1:6)  :: PtfmAM = 0.0_ReKi      !< Added mass matrix results from OrcaFlex [-]
    REAL(ReKi) , DIMENSION(1:6)  :: PtfmFt = 0.0_ReKi      !< Force/moment results from OrcaFlex [-]
    REAL(ReKi) , DIMENSION(1:6)  :: F_PtfmAM = 0.0_ReKi      !< Force/moment results calculated from the added mass and accel [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: AllOuts      !< An array holding the value of all of the calculated (not only selected) output channels [see OutListParameters.xlsx spreadsheet]
    REAL(DbKi)  :: LastTimeStep = 0.0_R8Ki      !< The last timestep called [-]
  END TYPE Orca_MiscVarType
! =======================
! =========  Orca_ParameterType  =======
  TYPE, PUBLIC :: Orca_ParameterType
    REAL(DbKi)  :: DT = 0.0_R8Ki      !< Time step for continuous state integration & discrete state update [seconds]
    TYPE(DLL_Type)  :: DLL_Orca      !< Info for the OrcaFlex DLL [-]
    CHARACTER(1024)  :: SimNamePath      !< Path with simulation rootname with null end character for passing to C [-]
    INTEGER(IntKi)  :: SimNamePathLen = 0_IntKi      !< Length of SimNamePath (including null char) [-]
    INTEGER(IntKi)  :: NumOuts = 0      !< Number of parameters in the output list (number of outputs requested) [-]
    TYPE(OutParmType) , DIMENSION(:), ALLOCATABLE  :: OutParam      !< Names and units (and other characteristics) of all requested output parameters [-]
  END TYPE Orca_ParameterType
! =======================
! =========  Orca_InputType  =======
  TYPE, PUBLIC :: Orca_InputType
    TYPE(MeshType)  :: PtfmMesh      !< Displacements at the platform reference point [-]
  END TYPE Orca_InputType
! =======================
! =========  Orca_OutputType  =======
  TYPE, PUBLIC :: Orca_OutputType
    TYPE(MeshType)  :: PtfmMesh      !< Loads at the platform reference point [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WriteOutput      !< Array with values to output to file [-]
  END TYPE Orca_OutputType
! =======================
! =========  Orca_ContinuousStateType  =======
  TYPE, PUBLIC :: Orca_ContinuousStateType
    REAL(ReKi)  :: Dummy = 0.0_ReKi      !< Dummy placeholder [-]
  END TYPE Orca_ContinuousStateType
! =======================
! =========  Orca_DiscreteStateType  =======
  TYPE, PUBLIC :: Orca_DiscreteStateType
    REAL(ReKi)  :: Dummy = 0.0_ReKi      !< Dummy placeholder [-]
  END TYPE Orca_DiscreteStateType
! =======================
! =========  Orca_ConstraintStateType  =======
  TYPE, PUBLIC :: Orca_ConstraintStateType
    REAL(ReKi)  :: DummyConstrState = 0.0_ReKi      !< Dummy placeholder [-]
  END TYPE Orca_ConstraintStateType
! =======================
CONTAINS

subroutine Orca_CopyInitInput(SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg)
   type(Orca_InitInputType), intent(in) :: SrcInitInputData
   type(Orca_InitInputType), intent(inout) :: DstInitInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Orca_CopyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInitInputData%InputFile = SrcInitInputData%InputFile
   DstInitInputData%RootName = SrcInitInputData%RootName
   DstInitInputData%TMax = SrcInitInputData%TMax
end subroutine

subroutine Orca_DestroyInitInput(InitInputData, ErrStat, ErrMsg)
   type(Orca_InitInputType), intent(inout) :: InitInputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Orca_DestroyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine Orca_PackInitInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Orca_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Orca_PackInitInput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%InputFile)
   call RegPack(RF, InData%RootName)
   call RegPack(RF, InData%TMax)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Orca_UnPackInitInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Orca_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Orca_UnPackInitInput'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%InputFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TMax); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Orca_CopyInitOutput(SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg)
   type(Orca_InitOutputType), intent(in) :: SrcInitOutputData
   type(Orca_InitOutputType), intent(inout) :: DstInitOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'Orca_CopyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call NWTC_Library_CopyProgDesc(SrcInitOutputData%Ver, DstInitOutputData%Ver, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcInitOutputData%WriteOutputHdr)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputHdr)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputHdr)
      if (.not. allocated(DstInitOutputData%WriteOutputHdr)) then
         allocate(DstInitOutputData%WriteOutputHdr(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputHdr.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputHdr = SrcInitOutputData%WriteOutputHdr
   end if
   if (allocated(SrcInitOutputData%WriteOutputUnt)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputUnt)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputUnt)
      if (.not. allocated(DstInitOutputData%WriteOutputUnt)) then
         allocate(DstInitOutputData%WriteOutputUnt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputUnt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputUnt = SrcInitOutputData%WriteOutputUnt
   end if
end subroutine

subroutine Orca_DestroyInitOutput(InitOutputData, ErrStat, ErrMsg)
   type(Orca_InitOutputType), intent(inout) :: InitOutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'Orca_DestroyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call NWTC_Library_DestroyProgDesc(InitOutputData%Ver, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(InitOutputData%WriteOutputHdr)) then
      deallocate(InitOutputData%WriteOutputHdr)
   end if
   if (allocated(InitOutputData%WriteOutputUnt)) then
      deallocate(InitOutputData%WriteOutputUnt)
   end if
end subroutine

subroutine Orca_PackInitOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Orca_InitOutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Orca_PackInitOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call NWTC_Library_PackProgDesc(RF, InData%Ver) 
   call RegPackAlloc(RF, InData%WriteOutputHdr)
   call RegPackAlloc(RF, InData%WriteOutputUnt)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Orca_UnPackInitOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Orca_InitOutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Orca_UnPackInitOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call NWTC_Library_UnpackProgDesc(RF, OutData%Ver) ! Ver 
   call RegUnpackAlloc(RF, OutData%WriteOutputHdr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutputUnt); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Orca_CopyInputFile(SrcInputFileData, DstInputFileData, CtrlCode, ErrStat, ErrMsg)
   type(Orca_InputFile), intent(in) :: SrcInputFileData
   type(Orca_InputFile), intent(inout) :: DstInputFileData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Orca_CopyInputFile'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInputFileData%DLL_FileName = SrcInputFileData%DLL_FileName
   DstInputFileData%DLL_InitProcName = SrcInputFileData%DLL_InitProcName
   DstInputFileData%DLL_CalcProcName = SrcInputFileData%DLL_CalcProcName
   DstInputFileData%DLL_EndProcName = SrcInputFileData%DLL_EndProcName
   DstInputFileData%DirRoot = SrcInputFileData%DirRoot
end subroutine

subroutine Orca_DestroyInputFile(InputFileData, ErrStat, ErrMsg)
   type(Orca_InputFile), intent(inout) :: InputFileData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Orca_DestroyInputFile'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine Orca_PackInputFile(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Orca_InputFile), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Orca_PackInputFile'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DLL_FileName)
   call RegPack(RF, InData%DLL_InitProcName)
   call RegPack(RF, InData%DLL_CalcProcName)
   call RegPack(RF, InData%DLL_EndProcName)
   call RegPack(RF, InData%DirRoot)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Orca_UnPackInputFile(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Orca_InputFile), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Orca_UnPackInputFile'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DLL_FileName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DLL_InitProcName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DLL_CalcProcName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DLL_EndProcName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DirRoot); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Orca_CopyOtherState(SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg)
   type(Orca_OtherStateType), intent(in) :: SrcOtherStateData
   type(Orca_OtherStateType), intent(inout) :: DstOtherStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Orca_CopyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstOtherStateData%DummyOtherState = SrcOtherStateData%DummyOtherState
end subroutine

subroutine Orca_DestroyOtherState(OtherStateData, ErrStat, ErrMsg)
   type(Orca_OtherStateType), intent(inout) :: OtherStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Orca_DestroyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine Orca_PackOtherState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Orca_OtherStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Orca_PackOtherState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyOtherState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Orca_UnPackOtherState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Orca_OtherStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Orca_UnPackOtherState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyOtherState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Orca_CopyMisc(SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg)
   type(Orca_MiscVarType), intent(in) :: SrcMiscData
   type(Orca_MiscVarType), intent(inout) :: DstMiscData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'Orca_CopyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstMiscData%PtfmAM = SrcMiscData%PtfmAM
   DstMiscData%PtfmFt = SrcMiscData%PtfmFt
   DstMiscData%F_PtfmAM = SrcMiscData%F_PtfmAM
   if (allocated(SrcMiscData%AllOuts)) then
      LB(1:1) = lbound(SrcMiscData%AllOuts)
      UB(1:1) = ubound(SrcMiscData%AllOuts)
      if (.not. allocated(DstMiscData%AllOuts)) then
         allocate(DstMiscData%AllOuts(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%AllOuts.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%AllOuts = SrcMiscData%AllOuts
   end if
   DstMiscData%LastTimeStep = SrcMiscData%LastTimeStep
end subroutine

subroutine Orca_DestroyMisc(MiscData, ErrStat, ErrMsg)
   type(Orca_MiscVarType), intent(inout) :: MiscData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Orca_DestroyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(MiscData%AllOuts)) then
      deallocate(MiscData%AllOuts)
   end if
end subroutine

subroutine Orca_PackMisc(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Orca_MiscVarType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Orca_PackMisc'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%PtfmAM)
   call RegPack(RF, InData%PtfmFt)
   call RegPack(RF, InData%F_PtfmAM)
   call RegPackAlloc(RF, InData%AllOuts)
   call RegPack(RF, InData%LastTimeStep)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Orca_UnPackMisc(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Orca_MiscVarType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Orca_UnPackMisc'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%PtfmAM); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmFt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%F_PtfmAM); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AllOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LastTimeStep); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Orca_CopyParam(SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg)
   type(Orca_ParameterType), intent(in) :: SrcParamData
   type(Orca_ParameterType), intent(inout) :: DstParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'Orca_CopyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstParamData%DT = SrcParamData%DT
   DstParamData%DLL_Orca = SrcParamData%DLL_Orca
   DstParamData%SimNamePath = SrcParamData%SimNamePath
   DstParamData%SimNamePathLen = SrcParamData%SimNamePathLen
   DstParamData%NumOuts = SrcParamData%NumOuts
   if (allocated(SrcParamData%OutParam)) then
      LB(1:1) = lbound(SrcParamData%OutParam)
      UB(1:1) = ubound(SrcParamData%OutParam)
      if (.not. allocated(DstParamData%OutParam)) then
         allocate(DstParamData%OutParam(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%OutParam.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyOutParmType(SrcParamData%OutParam(i1), DstParamData%OutParam(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
end subroutine

subroutine Orca_DestroyParam(ParamData, ErrStat, ErrMsg)
   type(Orca_ParameterType), intent(inout) :: ParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'Orca_DestroyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call FreeDynamicLib( ParamData%DLL_Orca, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(ParamData%OutParam)) then
      LB(1:1) = lbound(ParamData%OutParam)
      UB(1:1) = ubound(ParamData%OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyOutParmType(ParamData%OutParam(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%OutParam)
   end if
end subroutine

subroutine Orca_PackParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Orca_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Orca_PackParam'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DT)
   call DLLTypePack(RF, InData%DLL_Orca) 
   call RegPack(RF, InData%SimNamePath)
   call RegPack(RF, InData%SimNamePathLen)
   call RegPack(RF, InData%NumOuts)
   call RegPack(RF, allocated(InData%OutParam))
   if (allocated(InData%OutParam)) then
      call RegPackBounds(RF, 1, lbound(InData%OutParam), ubound(InData%OutParam))
      LB(1:1) = lbound(InData%OutParam)
      UB(1:1) = ubound(InData%OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackOutParmType(RF, InData%OutParam(i1)) 
      end do
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Orca_UnPackParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Orca_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Orca_UnPackParam'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DT); if (RegCheckErr(RF, RoutineName)) return
   call DLLTypeUnpack(RF, OutData%DLL_Orca) ! DLL_Orca 
   call RegUnpack(RF, OutData%SimNamePath); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SimNamePathLen); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumOuts); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%OutParam)) deallocate(OutData%OutParam)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%OutParam(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%OutParam.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackOutParmType(RF, OutData%OutParam(i1)) ! OutParam 
      end do
   end if
end subroutine

subroutine Orca_CopyInput(SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg)
   type(Orca_InputType), intent(inout) :: SrcInputData
   type(Orca_InputType), intent(inout) :: DstInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'Orca_CopyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshCopy(SrcInputData%PtfmMesh, DstInputData%PtfmMesh, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine Orca_DestroyInput(InputData, ErrStat, ErrMsg)
   type(Orca_InputType), intent(inout) :: InputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'Orca_DestroyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshDestroy( InputData%PtfmMesh, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine Orca_PackInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Orca_InputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Orca_PackInput'
   if (RF%ErrStat >= AbortErrLev) return
   call MeshPack(RF, InData%PtfmMesh) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Orca_UnPackInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Orca_InputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Orca_UnPackInput'
   if (RF%ErrStat /= ErrID_None) return
   call MeshUnpack(RF, OutData%PtfmMesh) ! PtfmMesh 
end subroutine

subroutine Orca_CopyOutput(SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg)
   type(Orca_OutputType), intent(inout) :: SrcOutputData
   type(Orca_OutputType), intent(inout) :: DstOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'Orca_CopyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshCopy(SrcOutputData%PtfmMesh, DstOutputData%PtfmMesh, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcOutputData%WriteOutput)) then
      LB(1:1) = lbound(SrcOutputData%WriteOutput)
      UB(1:1) = ubound(SrcOutputData%WriteOutput)
      if (.not. allocated(DstOutputData%WriteOutput)) then
         allocate(DstOutputData%WriteOutput(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%WriteOutput.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%WriteOutput = SrcOutputData%WriteOutput
   end if
end subroutine

subroutine Orca_DestroyOutput(OutputData, ErrStat, ErrMsg)
   type(Orca_OutputType), intent(inout) :: OutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'Orca_DestroyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshDestroy( OutputData%PtfmMesh, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(OutputData%WriteOutput)) then
      deallocate(OutputData%WriteOutput)
   end if
end subroutine

subroutine Orca_PackOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Orca_OutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Orca_PackOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call MeshPack(RF, InData%PtfmMesh) 
   call RegPackAlloc(RF, InData%WriteOutput)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Orca_UnPackOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Orca_OutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Orca_UnPackOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call MeshUnpack(RF, OutData%PtfmMesh) ! PtfmMesh 
   call RegUnpackAlloc(RF, OutData%WriteOutput); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Orca_CopyContState(SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg)
   type(Orca_ContinuousStateType), intent(in) :: SrcContStateData
   type(Orca_ContinuousStateType), intent(inout) :: DstContStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Orca_CopyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstContStateData%Dummy = SrcContStateData%Dummy
end subroutine

subroutine Orca_DestroyContState(ContStateData, ErrStat, ErrMsg)
   type(Orca_ContinuousStateType), intent(inout) :: ContStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Orca_DestroyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine Orca_PackContState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Orca_ContinuousStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Orca_PackContState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%Dummy)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Orca_UnPackContState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Orca_ContinuousStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Orca_UnPackContState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%Dummy); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Orca_CopyDiscState(SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg)
   type(Orca_DiscreteStateType), intent(in) :: SrcDiscStateData
   type(Orca_DiscreteStateType), intent(inout) :: DstDiscStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Orca_CopyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstDiscStateData%Dummy = SrcDiscStateData%Dummy
end subroutine

subroutine Orca_DestroyDiscState(DiscStateData, ErrStat, ErrMsg)
   type(Orca_DiscreteStateType), intent(inout) :: DiscStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Orca_DestroyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine Orca_PackDiscState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Orca_DiscreteStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Orca_PackDiscState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%Dummy)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Orca_UnPackDiscState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Orca_DiscreteStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Orca_UnPackDiscState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%Dummy); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Orca_CopyConstrState(SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg)
   type(Orca_ConstraintStateType), intent(in) :: SrcConstrStateData
   type(Orca_ConstraintStateType), intent(inout) :: DstConstrStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Orca_CopyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstConstrStateData%DummyConstrState = SrcConstrStateData%DummyConstrState
end subroutine

subroutine Orca_DestroyConstrState(ConstrStateData, ErrStat, ErrMsg)
   type(Orca_ConstraintStateType), intent(inout) :: ConstrStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Orca_DestroyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine Orca_PackConstrState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Orca_ConstraintStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Orca_PackConstrState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyConstrState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Orca_UnPackConstrState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Orca_ConstraintStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Orca_UnPackConstrState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyConstrState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Orca_Input_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
   ! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(Orca_InputType), intent(inout)  :: u(:) ! Input at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Inputs
   type(Orca_InputType), intent(inout)  :: u_out ! Input at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'Orca_Input_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(u)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(u)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(u) - 1
   select case (order)
   case (0)
      call Orca_CopyInput(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call Orca_Input_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call Orca_Input_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(u) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE Orca_Input_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

   TYPE(Orca_InputType), INTENT(INOUT)  :: u1    ! Input at t1 > t2
   TYPE(Orca_InputType), INTENT(INOUT)  :: u2    ! Input at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Inputs
   TYPE(Orca_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'Orca_Input_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   CALL MeshExtrapInterp1(u1%PtfmMesh, u2%PtfmMesh, tin, u_out%PtfmMesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
END SUBROUTINE

SUBROUTINE Orca_Input_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

   TYPE(Orca_InputType), INTENT(INOUT)  :: u1      ! Input at t1 > t2 > t3
   TYPE(Orca_InputType), INTENT(INOUT)  :: u2      ! Input at t2 > t3
   TYPE(Orca_InputType), INTENT(INOUT)  :: u3      ! Input at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Inputs
   TYPE(Orca_InputType), INTENT(INOUT)  :: u_out     ! Input at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'Orca_Input_ExtrapInterp2'
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   CALL MeshExtrapInterp2(u1%PtfmMesh, u2%PtfmMesh, u3%PtfmMesh, tin, u_out%PtfmMesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
END SUBROUTINE

subroutine Orca_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
   ! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(Orca_OutputType), intent(inout)  :: y(:) ! Output at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Outputs
   type(Orca_OutputType), intent(inout)  :: y_out ! Output at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'Orca_Output_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(y)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(y)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(y) - 1
   select case (order)
   case (0)
      call Orca_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call Orca_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call Orca_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(y) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE Orca_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

   TYPE(Orca_OutputType), INTENT(INOUT)  :: y1    ! Output at t1 > t2
   TYPE(Orca_OutputType), INTENT(INOUT)  :: y2    ! Output at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
   TYPE(Orca_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'Orca_Output_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   CALL MeshExtrapInterp1(y1%PtfmMesh, y2%PtfmMesh, tin, y_out%PtfmMesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
      y_out%WriteOutput = a1*y1%WriteOutput + a2*y2%WriteOutput
   END IF ! check if allocated
END SUBROUTINE

SUBROUTINE Orca_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

   TYPE(Orca_OutputType), INTENT(INOUT)  :: y1      ! Output at t1 > t2 > t3
   TYPE(Orca_OutputType), INTENT(INOUT)  :: y2      ! Output at t2 > t3
   TYPE(Orca_OutputType), INTENT(INOUT)  :: y3      ! Output at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
   TYPE(Orca_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'Orca_Output_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   CALL MeshExtrapInterp2(y1%PtfmMesh, y2%PtfmMesh, y3%PtfmMesh, tin, y_out%PtfmMesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
      y_out%WriteOutput = a1*y1%WriteOutput + a2*y2%WriteOutput + a3*y3%WriteOutput
   END IF ! check if allocated
END SUBROUTINE
END MODULE OrcaFlexInterface_Types
!ENDOFREGISTRYGENERATEDFILE
