!**********************************************************************************************************************************
! The OrcaFlexInterface.f90 and  OrcaFlexInterface_Types.f90 make up the OrcaFlexInterface module of the
! FAST Modularization Framework. OrcaFlexInterface_Types is auto-generated based on FAST_Registry.txt.
!..................................................................................................................................
! LICENSING
! Copyright (C) 2015-2016  National Renewable Energy Laboratory
!
!    This file is part of OrcaFlexInterface.
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!**********************************************************************************************************************************
!> This module contains definitions of compile-time PARAMETERS for the OrcaFlex Interface module.
!! Every variable defined here MUST have the PARAMETER attribute.
MODULE OrcaFlexInterface_Parameters

   USE NWTC_Library

   IMPLICIT                      NONE

   TYPE(ProgDesc), PARAMETER  :: Orca_Ver = ProgDesc( 'OrcaFlexInterface', '', '' )
   CHARACTER(*),   PARAMETER  :: Orca_Nickname = 'Orca'


! ===================================================================================================
! NOTE: The following lines of code were generated by a Matlab script called "Write_ChckOutLst.m"
!      using the parameters listed in the "OutListParameters.xlsx" Excel file. Any changes to these 
!      lines should be modified in the Matlab script and/or Excel worksheet as necessary. 
! ===================================================================================================
! This code was generated by Write_ChckOutLst.m at 01-Sep-2015 14:29:18.


     ! Indices for computing output channels:
     ! NOTES: 
     !    (1) These parameters are in the order stored in "OutListParameters.xlsx"
     !    (2) Array AllOuts() must be dimensioned to the value of the largest output parameter

     !  Time: 

   INTEGER(IntKi), PARAMETER      :: Time      =  0


     ! Platform forces:

   INTEGER(IntKi), PARAMETER      :: OrcaFxi   =  1
   INTEGER(IntKi), PARAMETER      :: OrcaFyi   =  2
   INTEGER(IntKi), PARAMETER      :: OrcaFzi   =  3
   INTEGER(IntKi), PARAMETER      :: OrcaMxi   =  4
   INTEGER(IntKi), PARAMETER      :: OrcaMyi   =  5
   INTEGER(IntKi), PARAMETER      :: OrcaMzi   =  6
   INTEGER(IntKi), PARAMETER      :: OrcaHMFxi =  7
   INTEGER(IntKi), PARAMETER      :: OrcaHMFyi =  8
   INTEGER(IntKi), PARAMETER      :: OrcaHMFzi =  9
   INTEGER(IntKi), PARAMETER      :: OrcaHMMxi = 10
   INTEGER(IntKi), PARAMETER      :: OrcaHMMyi = 11
   INTEGER(IntKi), PARAMETER      :: OrcaHMMzi = 12
   INTEGER(IntKi), PARAMETER      :: OrcaAMFxi = 13
   INTEGER(IntKi), PARAMETER      :: OrcaAMFyi = 14
   INTEGER(IntKi), PARAMETER      :: OrcaAMFzi = 15
   INTEGER(IntKi), PARAMETER      :: OrcaAMMxi = 16
   INTEGER(IntKi), PARAMETER      :: OrcaAMMyi = 17
   INTEGER(IntKi), PARAMETER      :: OrcaAMMzi = 18


     ! The maximum number of output channels which can be output by the code.
   INTEGER(IntKi), PARAMETER      :: MaxOutPts = 18

!End of code generated by Matlab script
! ===================================================================================================

END MODULE OrcaFlexInterface_Parameters
!**********************************************************************************************************************************
!> This module is an interface between FAST and OrcaFlex, a commercial software package developed by Orcina. This interfaces calls
!! an OrcaFlex DLL once per time step, and is valid for loose coupling. Tight coupling is not supported.
MODULE OrcaFlexInterface

   USE NWTC_Library
   USE NWTC_LAPACK
   
   USE OrcaFlexInterface_Parameters
   USE OrcaFlexInterface_Types

   USE, INTRINSIC             :: ISO_C_Binding


   IMPLICIT NONE

   PRIVATE


   INTERFACE      ! These are interfaces to the DLL

#ifdef __GFORTRAN__
      SUBROUTINE OrcaFlexUserPtfmLdInitialise(DT,TMax)   BIND(C)
#else
      SUBROUTINE OrcaFlexUserPtfmLdInitialise(DT,TMax)   !!!BIND(C)
#endif
         USE, INTRINSIC :: ISO_C_BINDING, ONLY: C_FLOAT
         !DEC$ ATTRIBUTES DEFAULT, STDCALL, DECORATE, ALIAS:'OrcaFlexUserPtfmLdInitialise'::OrcaFlexUserPtfmLdInitialise
         !GCC$ ATTRIBUTES STDCALL :: OrcaFlexUserPtfmLdInitialise
         REAL(C_FLOAT),             INTENT(IN   )  :: DT
         REAL(C_FLOAT),             INTENT(IN   )  :: TMax
      END SUBROUTINE OrcaFlexUserPtfmLdInitialise


#ifdef __GFORTRAN__
      SUBROUTINE OrcaFlexUserPtfmLd( X, XD, ZTime, DirRoot, PtfmAM, PtfmFt) BIND(C)
#else
      SUBROUTINE OrcaFlexUserPtfmLd( X, XD, ZTime, DirRoot, PtfmAM, PtfmFt) !!!BIND(C)
#endif
         USE, INTRINSIC :: ISO_C_Binding, ONLY: C_FLOAT, C_CHAR
         !DEC$ ATTRIBUTES DEFAULT, STDCALL, DECORATE, ALIAS:'OrcaFlexUserPtfmLd'::OrcaFlexUserPtfmLd
         !GCC$ ATTRIBUTES STDCALL :: OrcaFlexUserPtfmLd
         CHARACTER(KIND=C_CHAR),    INTENT(IN   )  :: DirRoot
         REAL(C_FLOAT),             INTENT(IN   )  :: X(6)           !< Translational and rotational displacement (m, radians) relative to inertial frame.
         REAL(C_FLOAT),             INTENT(IN   )  :: XD(6)          !< Translational and rotational velocity (m/s, radians/s) relative to inertial frame.
         REAL(C_FLOAT),             INTENT(IN   )  :: ZTime          !< Current time in seconds
         REAL(C_FLOAT),             INTENT(  OUT)  :: PtfmAM(6,6)    !< Added mass matrix (kg, kg-m, kg-m^2)
         REAL(C_FLOAT),             INTENT(  OUT)  :: PtfmFt(6)      !< Platform forces -- [3 translation (N), 3 moments (N-m)] at reference point.
      END SUBROUTINE OrcaFlexUserPtfmLd



#ifdef __GFORTRAN__
      SUBROUTINE OrcaFlexUserPtfmLdFinalise()  BIND(C)
#else
      SUBROUTINE OrcaFlexUserPtfmLdFinalise()  !!!BIND(C)
#endif
         USE, INTRINSIC :: ISO_C_BINDING
         !DEC$ ATTRIBUTES DEFAULT, STDCALL, DECORATE, ALIAS: 'OrcaFlexUserPtfmLdFinalise'::OrcaFlexUserPtfmLdFinalise
         !GCC$ ATTRIBUTES STDCALL :: OrcaFlexUserPtfmLdFinalise
         ! There is no data to pass.
      END SUBROUTINE OrcaFlexUserPtfmLdFinalise

   END INTERFACE


      ! ..... Public Subroutines ...................................................................................................

   PUBLIC :: Orca_Init                             ! Initialization routine
   PUBLIC :: Orca_End                              ! Ending routine (includes clean up)

   PUBLIC :: Orca_UpdateStates                     ! Loose coupling routine for solving for constraint states, integrating
                                                   !   continuous states, and updating discrete states
   PUBLIC :: Orca_CalcOutput                       ! Routine for computing outputs

CONTAINS
!----------------------------------------------------------------------------------------------------------------------------------
!> This routine is called at the start of the simulation to perform initialization steps.
!! The parameters are set here and not changed during the simulation.
!! The initial states and initial guess for the input are defined.
SUBROUTINE Orca_Init( InitInp, u, p, x, xd, z, OtherState, y, m, Interval, InitOut, ErrStat, ErrMsg )

   USE, INTRINSIC             :: ISO_C_Binding

   TYPE(Orca_InitInputType),        INTENT(IN   )  :: InitInp           !< Input data for initialization routine
   TYPE(Orca_InputType),            INTENT(  OUT)  :: u                 !< An initial guess for the input; input mesh must be defined
   TYPE(Orca_ParameterType),        INTENT(  OUT)  :: p                 !< Parameters
   TYPE(Orca_ContinuousStateType),  INTENT(  OUT)  :: x                 !< Initial continuous states
   TYPE(Orca_DiscreteStateType),    INTENT(  OUT)  :: xd                !< Initial discrete states
   TYPE(Orca_ConstraintStateType),  INTENT(  OUT)  :: z                 !< Initial guess of the constraint states
   TYPE(Orca_OtherStateType),       INTENT(  OUT)  :: OtherState        !< Initial other states
   TYPE(Orca_OutputType),           INTENT(  OUT)  :: y                 !< Initial system outputs (outputs are not calculated;
                                                                        !!   only the output mesh is initialized)
   TYPE(Orca_MiscVarType),          INTENT(INOUT)  :: m                 !<  Misc variables for optimization (not copied in glue code)
   REAL(DbKi),                      INTENT(INOUT)  :: Interval          !< Coupling interval in seconds: the rate that
                                                                        !!   (1) Orca_UpdateStates() is called in loose coupling &
                                                                        !!   (2) Orca_UpdateDiscState() is called in tight coupling.
                                                                        !!   Input is the suggested time from the glue code;
                                                                        !!   Output is the actual coupling interval that will be used
                                                                        !!   by the glue code.
   TYPE(Orca_InitOutputType),       INTENT(  OUT)  :: InitOut           !< Output for initialization routine
   INTEGER(IntKi),                  INTENT(  OUT)  :: ErrStat           !< Error status of the operation
   CHARACTER(*),                    INTENT(  OUT)  :: ErrMsg            !< Error message if ErrStat /= ErrID_None


      ! Local variables
   TYPE(Orca_InputFile)                            :: InputFileData     ! Data stored in the module's input file
   INTEGER(IntKi)                                  :: ErrStatTmp          ! temporary Error status of the operation
   CHARACTER(ErrMsgLen)                            :: ErrMsgTmp           ! temporary Error message if ErrStat /= ErrID_None
   CHARACTER(*),   PARAMETER                       :: RoutineName='Orca_Init'
   CHARACTER(ChanLen)                              :: TmpOutList(MaxOutPts)


   REAL(C_FLOAT)                                   :: DLL_DT
   REAL(C_FLOAT)                                   :: DLL_TMax


   PROCEDURE(OrcaFlexUserPtfmLdInitialise),POINTER :: OrcaDLL_Init




      ! Initialize variables for this routine
   ErrStat                 = ErrID_None
   ErrMsg                  = ""

   ! dummy variables for the FAST framework:
   ! (initialized to prevent compiler warnings about INTENT(OUT) variables)
   OtherState%DummyOtherState = 0
   z%DummyConstrState = 0.0_ReKi
   xd%Dummy = 0.0_ReKi
   x%Dummy = 0.0_ReKi
   

      ! Set some things for the DLL
   InputFileData%DLL_InitProcName   = 'OrcaFlexUserPtfmLdInitialise'
   InputFileData%DLL_CalcProcName   = 'OrcaFlexUserPtfmLd'
   InputFileData%DLL_EndProcName    = 'OrcaFlexUserPtfmLdFinalise'


      ! Display the module information
   CALL DispNVD( Orca_Ver )

   
   CALL ReadPrimaryFile( InitInp%InputFile, InputFileData, TRIM(InitInp%RootName)//'.Orca', ErrStatTmp, ErrMsgTmp )   
      CALL SetErrStat(ErrStatTmp,ErrMsgTmp,ErrStat,ErrMsg,RoutineName)


      ! We are going to output all the possible outlist variables, so pass in to SetOutParam the full list
   TmpOutList  =  (/    &
                     "OrcaFxi  ","OrcaFyi  ","OrcaFzi  ","OrcaMxi  ","OrcaMyi  ","OrcaMzi  ",   &     ! Total forces / moments
                     "OrcaHMFxi","OrcaHMFyi","OrcaHMFzi","OrcaHMMxi","OrcaHMMyi","OrcaHMMzi",   &     ! hydrodynamic contributions
                     "OrcaAMFxi","OrcaAMFyi","OrcaAMFzi","OrcaAMMxi","OrcaAMMyi","OrcaAMMzi"    &     ! Added mass contributions
                  /)
   p%NumOuts   =  MaxOutPts
   CALL SetOutParam( TmpOutList, p, ErrStatTmp, ErrMsgTmp )
   CALL SetErrStat(ErrStatTmp,ErrMsgTmp,ErrStat,ErrMsg,RoutineName)
   IF ( ErrStat>= AbortErrLev ) RETURN


      ! Allocate array for AllOuts
   CALL AllocAry( m%AllOuts, p%NumOuts, 'AllOuts', ErrStatTmp, ErrMsgTmp )
   CALL SetErrStat(ErrStatTmp,ErrMsgTmp,ErrStat,ErrMsg,RoutineName)
   IF ( ErrStat>= AbortErrLev ) RETURN
   m%AllOuts = 0.0_ReKi
  

      ! Allocate arrays for the WriteOutput
   CALL AllocAry( y%WriteOutput, p%NumOuts, 'WriteOutput', ErrStatTmp, ErrMsgTmp )
   CALL SetErrStat(ErrStatTmp,ErrMsgTmp,ErrStat,ErrMsg,RoutineName)
   IF ( ErrStat>= AbortErrLev ) THEN
      CALL Cleanup()
      RETURN
   ENDIF
   y%WriteOutput = 0.0_ReKi
   
   CALL AllocAry( InitOut%WriteOutputHdr, p%NumOuts, 'WriteOutputHdr', ErrStatTmp, ErrMsgTmp )
   CALL SetErrStat(ErrStatTmp,ErrMsgTmp,ErrStat,ErrMsg,RoutineName)
   IF ( ErrStat>= AbortErrLev ) THEN
      CALL Cleanup()
      RETURN
   ENDIF

   CALL AllocAry( InitOut%WriteOutputUnt, p%NumOuts, 'WriteOutputUnt', ErrStatTmp, ErrMsgTmp )
   CALL SetErrStat(ErrStatTmp,ErrMsgTmp,ErrStat,ErrMsg,RoutineName)
   IF ( ErrStat>= AbortErrLev ) THEN
      CALL Cleanup()
      RETURN
   ENDIF

   InitOut%WriteOutputHdr = p%OutParam(1:p%NumOuts)%Name
   InitOut%WriteOutputUnt = p%OutParam(1:p%NumOuts)%Units     
 








      ! Init routine load
   p%DLL_Orca%FileName     = InputFileData%DLL_FileName
   p%DLL_Orca%ProcName(1)  = InputFileData%DLL_InitProcName
   p%DLL_Orca%ProcName(2)  = InputFileData%DLL_CalcProcName
   p%DLL_Orca%ProcName(3)  = InputFileData%DLL_EndProcName

#ifdef NO_LibLoad
   CALL SetErrStat( ErrID_Warn,'   -->  Skipping LoadDynamicLib call for '//TRIM(p%DLL_Orca%FileName),ErrStat,ErrMsg,RoutineName )
#else
   CALL LoadDynamicLib ( p%DLL_Orca, ErrStatTmp, ErrMsgTmp )
   CALL SetErrStat( ErrStatTmp, ErrMsgTmp, ErrStat, ErrMsg, RoutineName)
   IF ( ErrStat >= AbortErrLev ) THEN
      CALL CleanUp
      RETURN
   END IF

   CALL C_F_PROCPOINTER( p%DLL_Orca%ProcAddr(1), OrcaDLL_Init )
#endif




      ! Set the values to pass to OrcaDLL_Init
   DLL_DT      =  Interval
   DLL_TMax    =  InitInp%TMax

#ifdef NO_LibLoad
   CALL SetErrStat( ErrID_Warn,'   -->  Skipping OrcaDLL_Init call',ErrStat,ErrMsg,RoutineName )
#else
   CALL OrcaDLL_Init ( DLL_DT, DLL_TMax )
   ! Unfortunately, we don't get any error reporting back from OrcaDLL_Init, so we can't really check anything.
   !bjj: we should be warning people to use text output files instead of binary in case OrcaFlex crashes...
#endif


      ! Copy relevant information into parameters.
   p%SimNamePathLen  =  LEN_TRIM(InputFileData%DirRoot)+1
   p%SimNamePath     =  TRIM(InputFileData%DirRoot)//CHAR(0)


      ! Create the input and output meshes associated with lumped loads
   CALL MeshCreate(  BlankMesh         = u%PtfmMesh       , &
                     IOS               = COMPONENT_INPUT  , &
                     Nnodes            = 1                , &
                     ErrStat           = ErrStatTmp       , &
                     ErrMess           = ErrMsgTmp        , &
                     TranslationDisp   = .TRUE.           , &
                     Orientation       = .TRUE.           , &
                     TranslationVel    = .TRUE.           , &
                     RotationVel       = .TRUE.           , &
                     TranslationAcc    = .TRUE.           , &
                     RotationAcc       = .TRUE.)

   CALL SetErrStat( ErrStatTmp, ErrMsgTmp, ErrStat, ErrMsg, RoutineName)
   IF ( ErrStat >= AbortErrLev ) THEN
      CALL CleanUp
      RETURN
   END IF

      ! Create the node on the mesh
   CALL MeshPositionNode (u%PtfmMesh, 1, (/0.0_ReKi, 0.0_ReKi, 0.0_ReKi/), ErrStatTmp, ErrMsgTmp )
   CALL SetErrStat( ErrStatTmp, ErrMsgTmp, ErrStat, ErrMsg, RoutineName)

      ! Create the mesh element
   CALL MeshConstructElement (  u%PtfmMesh, ELEMENT_POINT, ErrStatTmp, ErrMsgTmp, 1 )
   CALL SetErrStat( ErrStatTmp, ErrMsgTmp, ErrStat, ErrMsg, RoutineName)

   CALL MeshCommit ( u%PtfmMesh, ErrStatTmp, ErrMsgTmp )
   CALL SetErrStat( ErrStatTmp, ErrMsgTmp, ErrStat, ErrMsg, RoutineName)
   IF ( ErrStat >= AbortErrLev ) THEN
      CALL CleanUp
      RETURN
   END IF


   CALL MeshCopy( SrcMesh=u%PtfmMesh, DestMesh=y%PtfmMesh, CtrlCode=MESH_SIBLING, IOS=COMPONENT_OUTPUT, &
                  ErrStat=ErrStatTmp, ErrMess=ErrMsgTmp, Force=.TRUE., Moment=.TRUE. )
   CALL SetErrStat( ErrStatTmp, ErrMsgTmp, ErrStat, ErrMsg, RoutineName)
   IF ( ErrStat >= AbortErrLev ) THEN
      CALL CleanUp
      RETURN
   END IF


   u%PtfmMesh%RemapFlag    = .TRUE.
   y%PtfmMesh%RemapFlag    = .TRUE.




      ! Set zero values for the MiscVar arrays
   m%PtfmAM       =  0.0_ReKi
   m%PtfmFt       =  0.0_ReKi
   m%LastTimeStep =  -1.0_DbKi

   InitOut%Ver =  Orca_Ver


CONTAINS
   !------------------------------------------------------------------
   SUBROUTINE CleanUp()

      IF ( ErrStat >= AbortErrLev ) THEN
         CALL Orca_DestroyInputFile(InputFileData, ErrStatTmp, ErrMsgTmp )
         CALL SetErrStat(ErrStatTmp,ErrMsgTmp,ErrStat,ErrMsg,RoutineName)
      END IF

   END SUBROUTINE CleanUp

END SUBROUTINE Orca_Init

!----------------------------------------------------------------------------------------------------------------------------------
!> This routine reads in the primary OrcaFlex Interface input file and places the values it reads in the InputFileData structure.
!!   It opens an echo file if requested.
SUBROUTINE ReadPrimaryFile( InputFile, InputFileData, OutFileRoot, ErrStat, ErrMsg )

   IMPLICIT                        NONE

      ! Passed variables
   INTEGER(IntKi),       INTENT(OUT)    :: ErrStat                             !< Error status
                         
   CHARACTER(*),         INTENT(IN)     :: InputFile                           !< Name of the file containing the primary input data
   CHARACTER(*),         INTENT(OUT)    :: ErrMsg                              !< Error message
   CHARACTER(*),         INTENT(IN)     :: OutFileRoot                         !< The rootname of the echo file, possibly opened in this routine
                         
   TYPE(Orca_InputFile), INTENT(INOUT)  :: InputFileData                     !< All the data in the OrcaFlex Interface input file

      ! Local variables:
   INTEGER(IntKi)               :: I                                         ! loop counter
!   INTEGER(IntKi)               :: NumOuts                                  ! Number of output channel names read from the file
   INTEGER(IntKi)               :: UnEc                                      ! I/O unit for echo file. If > 0, file is open for writing.
   INTEGER(IntKi)               :: UnIn                                      ! Unit number for reading file
   INTEGER(IntKi)               :: IOS
   INTEGER(IntKi)               :: ErrStat2                                  ! Temporary Error status
   LOGICAL                      :: Echo                                      ! Determines if an echo file should be written
   CHARACTER(ErrMsgLen)         :: ErrMsg2                                   ! Temporary Error message
   CHARACTER(1024)              :: PriPath                                   ! Path name of the primary file
   CHARACTER(1024)              :: CWD                                       ! Path name of the current working directory
   CHARACTER(1024)              :: FTitle                                    ! "File Title": the 2nd line of the input file, which contains a description of its contents
   CHARACTER(200)               :: Line                                      ! Temporary storage of a line from the input file (to compare with "default")
   CHARACTER(*), PARAMETER      :: RoutineName = 'ReadPrimaryFile' 
   
      ! Initialize some variables:
   Echo = .FALSE.
   UnEc = -1                             ! Echo file not opened, yet
   CALL GetPath( InputFile, PriPath )    ! Input files will be relative to the path where the primary input file is located.

      ! OrcaFlex doesn't like relative path names, so we're going to make it absolute
   IF ( PathIsRelative( PriPath ) ) THEN
       CALL GET_CWD(CWD, ErrStat2)
!       PriPath = TRIM(CWD)//PathSep//TRIM(PriPath)
       PriPath = TRIM(CWD)//TRIM(PriPath(2:))
   END IF
         

      ! Get an available unit number for the file.

   CALL GetNewUnit( UnIn, ErrStat, ErrMsg )
   IF ( ErrStat >= AbortErrLev ) RETURN


      ! Open the Primary input file.

   CALL OpenFInpFile ( UnIn, InputFile, ErrStat2, ErrMsg2 )
      CALL SetErrStat( ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName )
      IF ( ErrStat >= AbortErrLev ) RETURN


   !CALL AllocAry( InputFileData%OutList, MaxOutPts, "OrcaFlex Interface Input File's Outlist", ErrStat2, ErrMsg2 )
   !   CALL SetErrStat( ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName )
   !   IF ( ErrStat >= AbortErrLev ) RETURN


   ! Read the lines up/including to the "Echo" simulation control variable
   ! If echo is FALSE, don't write these lines to the echo file.
   ! If Echo is TRUE, rewind and write on the second try.

   I    = 1 ! the number of times we've read the file (used for the Echo variable)
   DO
   !-------------------------- HEADER ---------------------------------------------
      CALL ReadCom( UnIn, InputFile, 'File Header: Module Version (line 1)', ErrStat2, ErrMsg2, UnEc )
         CALL SetErrStat( ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName )
         IF ( ErrStat >= AbortErrLev ) THEN
            CALL Cleanup()
            RETURN
         END IF

      CALL ReadStr( UnIn, InputFile, FTitle, 'FTitle', 'File Header: File Description (line 2)', ErrStat2, ErrMsg2, UnEc )
         CALL SetErrStat( ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName )
         IF ( ErrStat >= AbortErrLev ) THEN
            CALL Cleanup()
            RETURN
         END IF

   !---------------------- SIMULATION DATA --------------------------------------
      CALL ReadCom( UnIn, InputFile, 'Section Header: Simulation Control', ErrStat2, ErrMsg2, UnEc )
         CALL SetErrStat( ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName )
         IF ( ErrStat >= AbortErrLev ) THEN
            CALL Cleanup()
            RETURN
         END IF

         ! Echo - Echo input to "<RootName>.ech".

      CALL ReadVar( UnIn, InputFile, Echo, 'Echo',   'Echo switch', ErrStat2, ErrMsg2, UnEc )
         CALL SetErrStat( ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName )
         IF ( ErrStat >= AbortErrLev ) THEN
            CALL Cleanup()
            RETURN
         END IF


      IF (.NOT. Echo .OR. I > 1) EXIT !exit this loop

         ! Otherwise, open the echo file, then rewind the input file and echo everything we've read

      I = I + 1         ! make sure we do this only once (increment counter that says how many times we've read this file)

      CALL OpenEcho ( UnEc, TRIM(OutFileRoot)//'.ech', ErrStat2, ErrMsg2, Orca_Ver )
         CALL SetErrStat( ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName )
         IF ( ErrStat >= AbortErrLev ) THEN
            CALL Cleanup()
            RETURN
         END IF

      IF ( UnEc > 0 )  WRITE (UnEc,'(/,A,/)')  'Data from '//TRIM(Orca_Ver%Name)//' primary input file "'//TRIM( InputFile )//'":'

      REWIND( UnIn, IOSTAT=ErrStat2 )
         IF (ErrStat2 /= 0_IntKi ) THEN
            CALL SetErrStat( ErrID_Fatal, 'Error rewinding file "'//TRIM(InputFile)//'".', ErrStat, ErrMsg, RoutineName )
            CALL Cleanup()
            RETURN
         END IF

   END DO

   IF (NWTC_VerboseLevel == NWTC_Verbose) THEN
      CALL WrScr( ' Heading of the '//TRIM(Orca_Ver%Name)//' input file: ' )
      CALL WrScr( '   '//TRIM( FTitle ) )
   END IF


      ! InputFileData%DirRoot - Name of the file containing OrcaFlex simulation inputs:
   CALL ReadVar ( UnIn, InputFile, InputFileData%DirRoot, 'DirRoot', 'Name of the OrcaFlex simulation input file', ErrStat2, ErrMsg2, UnEc )
      CALL SetErrStat( ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName )
      IF ( ErrStat >= AbortErrLev ) THEN
         CALL Cleanup()
         RETURN
      END IF
   IF ( PathIsRelative( InputFileData%DirRoot ) ) InputFileData%DirRoot = TRIM(PriPath)//TRIM(InputFileData%DirRoot)
   
      ! InputFileData%DLLPathFileName - Name of the file containing OrcaFlex simulation inputs:
   CALL ReadVar ( UnIn, InputFile, InputFileData%DLL_FileName, 'DLL_FileName', 'Name of the OrcaFlex DLL', ErrStat2, ErrMsg2, UnEc )
      CALL SetErrStat( ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName )
      IF ( ErrStat >= AbortErrLev ) THEN
         CALL Cleanup()
         RETURN
      END IF
   IF ( PathIsRelative( InputFileData%DLL_FileName ) ) InputFileData%DLL_FileName = TRIM(PriPath)//TRIM(InputFileData%DLL_FileName)
   
         
   !   ! DT - Requested integration time for OrcaFlex (seconds):
   !CALL ReadVar( UnIn, InputFile, Line, "DT", "Requested integration time for OrcaFlex (seconds)", ErrStat2, ErrMsg2, UnEc)
   !   CALL CheckError( ErrStat2, ErrMsg2 )
   !   IF ( ErrStat >= AbortErrLev ) RETURN
   !   CALL Conv2UC( Line )
   !   IF ( INDEX(Line, "DEFAULT" ) /= 1 ) THEN ! If it's not "default", read this variable; otherwise use the value already stored in InputFileData%DT
   !      READ( Line, *, IOSTAT=IOS) InputFileData%DT
   !      IF ( IOS /= 0 ) THEN
   !         CALL CheckIOS ( IOS, InputFile, "DT", NumType, ErrStat2, ErrMsg2 )
   !         CALL CheckError( ErrStat2, ErrMsg2 )
   !         RETURN
   !      END IF
   !   END IF
   
   
   !!---------------------- OUTLIST  --------------------------------------------
   !CALL ReadCom( UnIn, InputFile, 'Section Header: OutList', ErrStat2, ErrMsg2, UnEc )
   !   CALL SetErrStat( ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName )
   !   IF ( ErrStat >= AbortErrLev ) THEN
   !      CALL Cleanup()
   !      RETURN
   !   END IF
   !
   !   ! OutList - List of user-requested output channels (-):
   !CALL ReadOutputList ( UnIn, InputFile, InputFileData%OutList, InputFileData%NumOuts, 'OutList', "List of user-requested output channels", ErrStat2, ErrMsg2, UnEc  )     ! Routine in NWTC Subroutine Library
   !   CALL SetErrStat( ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName )
   !   IF ( ErrStat >= AbortErrLev ) THEN
   !      CALL Cleanup()
   !      RETURN
   !   END IF

   !---------------------- END OF FILE -----------------------------------------

   CALL Cleanup()
   RETURN

CONTAINS
   SUBROUTINE Cleanup()
   
      CLOSE(UnIn)
      IF (UnEc > 0) CLOSE(UnEc)
      
   END SUBROUTINE Cleanup    
END SUBROUTINE ReadPrimaryFile
!----------------------------------------------------------------------------------------------------------------------------------


!----------------------------------------------------------------------------------------------------------------------------------
!> This routine is called at the end of the simulation.
SUBROUTINE Orca_End( u, p, x, xd, z, OtherState, y, m, ErrStat, ErrMsg )

   TYPE(Orca_InputType),            INTENT(INOUT)  :: u           !< System inputs
   TYPE(Orca_ParameterType),        INTENT(INOUT)  :: p           !< Parameters
   TYPE(Orca_ContinuousStateType),  INTENT(INOUT)  :: x           !< Continuous states
   TYPE(Orca_DiscreteStateType),    INTENT(INOUT)  :: xd          !< Discrete states
   TYPE(Orca_ConstraintStateType),  INTENT(INOUT)  :: z           !< Constraint states
   TYPE(Orca_OtherStateType),       INTENT(INOUT)  :: OtherState  !< Other states
   TYPE(Orca_OutputType),           INTENT(INOUT)  :: y           !< System outputs
   TYPE(Orca_MiscVarType),          INTENT(INOUT)  :: m           !<  Misc variables for optimization (not copied in glue code)
   INTEGER(IntKi),                  INTENT(  OUT)  :: ErrStat     !< Error status of the operation
   CHARACTER(*),                    INTENT(  OUT)  :: ErrMsg      !< Error message if ErrStat /= ErrID_None

   PROCEDURE(OrcaFlexUserPtfmLdFinalise),  POINTER :: OrcaDLL_End

      ! Error Handling
   INTEGER(IntKi)                                  :: ErrStatTmp        ! temporary Error status of the operation
   CHARACTER(ErrMsgLen)                            :: ErrMsgTmp         ! temporary Error message if ErrStat /= ErrID_None
   CHARACTER(*),   PARAMETER                       :: RoutineName='Orca_End'


      ! Initialize ErrStat
   ErrStat     = ErrID_None
   ErrMsg      = ""
   ErrStatTmp  = ErrID_None
   ErrMsgTmp   = ""




#ifdef NO_LibLoad
   CALL SetErrStat( ErrID_Warn,'   -->  Skipping OrcaDLL_End call',ErrStat,ErrMsg,RoutineName )
#else
      ! Release the DLL
   CALL C_F_PROCPOINTER( p%DLL_Orca%ProcAddr(3), OrcaDLL_End )
   CALL OrcaDLL_End        ! No error handling here.  Just have to assume it worked.


   CALL FreeDynamicLib( p%DLL_Orca, ErrStatTmp, ErrMsgTmp )
   CALL SetErrStat( ErrStatTmp,ErrMsgTmp,ErrStat,ErrMsg,RoutineName )   
#endif


      ! Destroy the input data:
   CALL Orca_DestroyInput( u, ErrStatTmp, ErrMsgTmp )
   CALL SetErrStat( ErrStatTmp,ErrMsgTmp,ErrStat,ErrMsg,RoutineName )


      ! Destroy the parameter data:
#ifdef NO_LibLoad
#else
   CALL Orca_DestroyParam( p, ErrStatTmp, ErrMsgTmp )
   CALL SetErrStat( ErrStatTmp,ErrMsgTmp,ErrStat,ErrMsg,RoutineName )
#endif


      ! Destroy the state data:
   CALL Orca_DestroyContState(   x,           ErrStatTmp, ErrMsgTmp )
   CALL SetErrStat( ErrStatTmp,ErrMsgTmp,ErrStat,ErrMsg,RoutineName )
   CALL Orca_DestroyDiscState(   xd,          ErrStatTmp, ErrMsgTmp )
   CALL SetErrStat( ErrStatTmp,ErrMsgTmp,ErrStat,ErrMsg,RoutineName )
   CALL Orca_DestroyConstrState( z,           ErrStatTmp, ErrMsgTmp )
   CALL SetErrStat( ErrStatTmp,ErrMsgTmp,ErrStat,ErrMsg,RoutineName )
   CALL Orca_DestroyOtherState(  OtherState,  ErrStatTmp, ErrMsgTmp )
   CALL SetErrStat( ErrStatTmp,ErrMsgTmp,ErrStat,ErrMsg,RoutineName )

      ! Destroy misc variables:
   CALL Orca_DestroyMisc(  m,  ErrStatTmp, ErrMsgTmp )
   CALL SetErrStat( ErrStatTmp,ErrMsgTmp,ErrStat,ErrMsg,RoutineName )

   
      ! Destroy the output data:
   CALL Orca_DestroyOutput( y, ErrStatTmp, ErrMsgTmp )
   CALL SetErrStat( ErrStatTmp,ErrMsgTmp,ErrStat,ErrMsg,RoutineName )


END SUBROUTINE Orca_End
!----------------------------------------------------------------------------------------------------------------------------------
!> Routine for computing outputs, used in both loose and tight coupling.
!! This SUBROUTINE is used to compute the output channels (motions and loads) and place them in the WriteOutput() array.
!! NOTE: the descriptions of the output channels are not given here. Please see the included OutListParameters.xlsx sheet for
!! for a complete description of each output parameter.
!! NOTE: no matter how many channels are selected for output, all of the outputs are calculated
!! All of the calculated output channels are placed into the m%AllOuts(:), while the channels selected for outputs are
!! placed in the y%WriteOutput(:) array.
SUBROUTINE Orca_CalcOutput( t, u, p, x, xd, z, OtherState, y, m, ErrStat, ErrMsg )

   REAL(DbKi),                      INTENT(IN   )  :: t                 !< Current simulation time in seconds
   TYPE(Orca_InputType),            INTENT(IN   )  :: u                 !< Inputs at Time t
   TYPE(Orca_ParameterType),        INTENT(IN   )  :: p                 !< Parameters
   TYPE(Orca_ContinuousStateType),  INTENT(IN   )  :: x                 !< Continuous states at t
   TYPE(Orca_DiscreteStateType),    INTENT(IN   )  :: xd                !< Discrete states at t
   TYPE(Orca_ConstraintStateType),  INTENT(IN   )  :: z                 !< Constraint states at t
   TYPE(Orca_OtherStateType),       INTENT(IN   )  :: OtherState        !< Other states at t
   TYPE(Orca_OutputType),           INTENT(INOUT)  :: y                 !< Outputs computed at t (Input only so that mesh con-
                                                                        !!   nectivity information does not have to be recalculated)
   TYPE(Orca_MiscVarType),          INTENT(INOUT)  :: m                 !<  Misc variables for optimization (not copied in glue code)
   INTEGER(IntKi),                  INTENT(  OUT)  :: ErrStat           !< Error status of the operation
   CHARACTER(*),                    INTENT(  OUT)  :: ErrMsg            !< Error message if ErrStat /= ErrID_None

   PROCEDURE(OrcaFlexUserPtfmLd),   POINTER        :: OrcaDLL_Calc


      ! Local variables copied from the mesh
   REAL(ReKi)                                      :: rotdisp(3)        !< Rotation angles from the mesh
   REAL(ReKi)                                      :: q(6)              !< Position from the mesh
   REAL(ReKi)                                      :: qdot(6)           !< Time derivative of position (velocity) from mesh
   REAL(ReKi)                                      :: qdotdot(6)        !< 2nd time derivative of position (acceleration) from mesh


      ! Local variables for data manipulation
   INTEGER(IntKi)                                  :: I,J               !< Generic counters



      ! Local variables for the getting the types correct to pass to the DLL
   CHARACTER(LEN=p%SimNamePathLen)                 :: DLL_DirRootName   !< Path and simulation name without extension
   REAL(C_FLOAT)                                   :: DLL_X(6)          !< Translational and rotational displacement (m, radians) relative to inertial frame.
   REAL(C_FLOAT)                                   :: DLL_Xdot(6)       !< Translational and rotational velocity (m/s, radians/s) relative to inertial frame.
   REAL(C_FLOAT)                                   :: DLL_ZTime         !< Current time in seconds
   REAL(C_FLOAT)                                   :: DLL_PtfmAM(6,6)   !< Added mass matrix (kg, kg-m, kg-m^2)
   REAL(C_FLOAT)                                   :: DLL_PtfmFt(6)     !< Platform forces -- [3 translation (N), 3 moments (N-m)] at reference point.


      ! Error Handling and data checking
   INTEGER(IntKi)                                  :: ErrStatTmp        !< Temporary Error status of the operation
   CHARACTER(ErrMsgLen)                            :: ErrMsgTmp         !< Temporary Error message if ErrStat /= ErrID_None
   CHARACTER(*),     PARAMETER                     :: RoutineName='Orca_Calc'
   REAL(ReKi),       PARAMETER                     :: SymmetryTol =  9.999E-4_ReKi  !< Tolerance used to determine if the PtfmAM is symmetric


      ! Copy over time and name to pass to OrcaFlex DLL
   DLL_DirRootName   =  TRIM(p%SimNamePath)//C_NULL_CHAR    ! Path and name of the simulation file without extension.  Null character added to convert from Fortran string to C-type string.
   DLL_ZTime = t                                            ! Current time

      ! Determine the rotational angles from the direction-cosine matrix
   rotdisp = GetSmllRotAngs ( u%PtfmMesh%Orientation(:,:,1), ErrStatTmp, ErrMsgTmp )
   CALL SetErrStat( ErrStatTmp, ErrMsgTmp, ErrStat, ErrMsg, RoutineName )
   IF ( ErrStat >= AbortErrLev) RETURN

   q         = reshape((/REAL(u%PtfmMesh%TranslationDisp(:,1),ReKi),rotdisp(:)/),(/6/))
   qdot      = reshape((/u%PtfmMesh%TranslationVel(:,1),u%PtfmMesh%RotationVel(:,1)/),(/6/))
   qdotdot   = reshape((/u%PtfmMesh%TranslationAcc(:,1),u%PtfmMesh%RotationAcc(:,1)/),(/6/))


      ! Copy position and motion information over to pass to the DLL
   DO I=1,6
      DLL_X(I)    =  q(I)
      DLL_Xdot(I) =  qdot(I)
   ENDDO



#ifdef NO_LibLoad
   CALL SetErrStat( ErrID_Warn,'   -->  Skipping OrcaDLL_Calc call',ErrStat,ErrMsg,RoutineName )
   DLL_PtfmAM  =  0.0_C_FLOAT
   DLL_PtfmFt  =  0.0_C_FLOAT
#else

      ! We do not want to call OrcaDLL twice in one timestep.  If _CalcOutput is called twice in a timestep, the second
      ! call is different from the first only with the accelerations, which OrcaFlex does not do anything with.
   IF ( t > m%LastTimeStep .and. .not. EqualRealNos(t,m%LastTimeStep) ) THEN
         ! Setup the pointer to the DLL procedure
      CALL C_F_PROCPOINTER( p%DLL_Orca%ProcAddr(2), OrcaDLL_Calc )
         ! Call OrcaFlex to run the calculation.  There is no error trapping on the OrcaFlex side, so we will have to do some checks on what receive back
      CALL OrcaDLL_Calc( DLL_X, DLL_Xdot, DLL_ZTime, DLL_DirRootName, DLL_PtfmAM, DLL_PtfmFt )
      m%LastTimeStep =  t

         ! Copy data over from the DLL output to the m
      DO I=1,6
         m%PtfmFT(I) =  DLL_PtfmFT(I)
         DO J=1,6
            m%PtfmAM(J,I)  =  DLL_PtfmAM(J,I)
         ENDDO
      ENDDO


      !!! bjj: commented this out 11=Apr=2016 because it doesn't seem like this is necessary; per jmj
      !!!   ! Perform some quick QA/QC on the DLL results.  There isn't much we can check, so just check that things are symmetric within some tolerance
      !!!DO I = 1,5        ! Loop through the 1st 5 rows (columns) of PtfmAM
      !!!   DO J = (I+1),6 ! Loop through all columns (rows) passed I
      !!!      IF ( ABS( m%PtfmAM(I,J) - m%PtfmAM(J,I) ) > SymmetryTol )  &
      !!!         ErrStatTmp  =  ErrID_Fatal
      !!!         ErrMsgTmp   =  ' The platform added mass matrix returned from OrcaFlex is unsymmetric.'// &
      !!!                        '  There may be issues with the OrcaFlex calculations.'
      !!!   ENDDO          ! J - All columns (rows) passed I
      !!!ENDDO             ! I - The 1st 5 rows (columns) of PtfmAM
      !!!CALL SetErrStat( ErrStatTmp, ErrMsgTmp, ErrStat, ErrMsg, RoutineName )
      !!!IF ( ErrStat >= ErrID_Fatal) RETURN

   ENDIF
#endif


      ! Now calculate the forces with what OrcaFlex returned
   m%F_PtfmAM     =  -matmul(m%PtfmAM, qdotdot)



      ! Update the Mesh with values from OrcaFlex
   DO I=1,3
      y%PtfmMesh%Force(I,1)  =  m%F_PtfmAM(I)   +  m%PtfmFT(I)
      y%PtfmMesh%Moment(I,1) =  m%F_PtfmAM(I+3) +  m%PtfmFT(I+3)
   ENDDO

!#ifdef NO_LibLoad
!   y%PtfmMesh%Force  =  6.0E6
!   y%PtfmMesh%Moment =  2.0E6
!#endif
   

      ! Set all the outputs
   CALL SetAllOuts( p, y, m, ErrStatTmp, ErrMsgTmp )
   CALL SetErrStat( ErrStatTmp, ErrMsgTmp, ErrStat, ErrMsg, RoutineName )
   IF ( ErrStat >= ErrID_Fatal) RETURN



   RETURN


END SUBROUTINE Orca_CalcOutput
!----------------------------------------------------------------------------------------------------------------------------------
!> This is a loose coupling routine for solving constraint states, integrating continuous states, and updating discrete and other 
!! states. Continuous, constraint, discrete, and other states are updated to values at t + Interval.
SUBROUTINE Orca_UpdateStates( t, n, u, utimes, p, x, xd, z, OtherState, m, ErrStat, ErrMsg )

      REAL(DbKi),                         INTENT(IN   ) :: t          !< Current simulation time in seconds
      INTEGER(IntKi),                     INTENT(IN   ) :: n          !< Current simulation time step n = 0,1,...
      TYPE(Orca_InputType),               INTENT(INOUT) :: u(:)       !< Inputs at utimes (out only for mesh record-keeping in ExtrapInterp routine)
      REAL(DbKi),                         INTENT(IN   ) :: utimes(:)  !< Times associated with u(:), in seconds
      TYPE(Orca_ParameterType),           INTENT(IN   ) :: p          !< Parameters
      TYPE(Orca_ContinuousStateType),     INTENT(INOUT) :: x          !< Input: Continuous states at t;
                                                                      !!   Output: Continuous states at t + Interval
      TYPE(Orca_DiscreteStateType),       INTENT(INOUT) :: xd         !< Input: Discrete states at t;
                                                                      !!   Output: Discrete states at t  + Interval
      TYPE(Orca_ConstraintStateType),     INTENT(INOUT) :: z          !< Input: Initial guess of constraint states at t+dt;
                                                                      !!   Output: Constraint states at t+dt
      TYPE(Orca_OtherStateType),          INTENT(INOUT) :: OtherState !< Other states: Other states at t;
                                                                      !!   Output: Other states at t + Interval
      TYPE(Orca_MiscVarType),             INTENT(INOUT) :: m          !<  Misc variables for optimization (not copied in glue code)
      INTEGER(IntKi),                     INTENT(  OUT) :: ErrStat    !< Error status of the operation
      CHARACTER(*),                       INTENT(  OUT) :: ErrMsg     !< Error message if ErrStat /= ErrID_None


         ! Initialize ErrStat

      ErrStat = ErrID_None
      ErrMsg  = ""


END SUBROUTINE Orca_UpdateStates
!++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++



!**********************************************************************************************************************************
! NOTE: The following lines of code were generated by a Matlab script called "Write_ChckOutLst.m"
!      using the parameters listed in the "OutListParameters.xlsx" Excel file. Any changes to these 
!      lines should be modified in the Matlab script and/or Excel worksheet as necessary. 
! This code was generated by Write_ChckOutLst.m at 01-Sep-2015 14:29:18.
!----------------------------------------------------------------------------------------------------------------------------------
SUBROUTINE SetOutParam(OutList, p, ErrStat, ErrMsg )
! This routine checks to see if any requested output channel names (stored in the OutList(:)) are invalid. It returns a 
! warning if any of the channels are not available outputs from the module.
!  It assigns the settings for OutParam(:) (i.e, the index, name, and units of the output channels, WriteOutput(:)).
!  the sign is set to 0 if the channel is invalid.
! It sets assumes the value p%NumOuts has been set before this routine has been called, and it sets the values of p%OutParam here.
!..................................................................................................................................

   IMPLICIT                        NONE

      ! Passed variables

   CHARACTER(ChanLen),        INTENT(IN)     :: OutList(:)                        ! The list out user-requested outputs
   TYPE(Orca_ParameterType),  INTENT(INOUT)  :: p                                 ! The module parameters
   INTEGER(IntKi),            INTENT(OUT)    :: ErrStat                           ! The error status code
   CHARACTER(*),              INTENT(OUT)    :: ErrMsg                            ! The error message, if an error occurred

      ! Local variables

   INTEGER                      :: ErrStat2                                        ! temporary (local) error status
   INTEGER                      :: I                                               ! Generic loop-counting index
   INTEGER                      :: J                                               ! Generic loop-counting index
   INTEGER                      :: INDX                                            ! Index for valid arrays

   LOGICAL                      :: CheckOutListAgain                               ! Flag used to determine if output parameter starting with "M" is valid (or the negative of another parameter)
   LOGICAL                      :: InvalidOutput(0:MaxOutPts)                      ! This array determines if the output channel is valid for this configuration
   CHARACTER(ChanLen)           :: OutListTmp                                      ! A string to temporarily hold OutList(I)
   CHARACTER(*), PARAMETER      :: RoutineName = "SetOutParam"

   CHARACTER(OutStrLenM1), PARAMETER  :: ValidParamAry(18) =  (/ &                  ! This lists the names of the allowed parameters, which must be sorted alphabetically
                               "ORCAAMFXI","ORCAAMFYI","ORCAAMFZI",  &
                               "ORCAAMMXI","ORCAAMMYI","ORCAAMMZI",  &
                               "ORCAFXI  ","ORCAFYI  ","ORCAFZI  ",  &
                               "ORCAHMFXI","ORCAHMFYI","ORCAHMFZI",  &
                               "ORCAHMMXI","ORCAHMMYI","ORCAHMMZI",  &
                               "ORCAMXI  ","ORCAMYI  ","ORCAMZI  "/)
   INTEGER(IntKi), PARAMETER :: ParamIndxAry(18) =  (/ &                            ! This lists the index into AllOuts(:) of the allowed parameters ValidParamAry(:)
                                OrcaAMFxi , OrcaAMFyi , OrcaAMFzi ,  &
                                OrcaAMMxi , OrcaAMMyi , OrcaAMMzi ,  &
                                  OrcaFxi ,   OrcaFyi ,   OrcaFzi ,  &
                                OrcaHMFxi , OrcaHMFyi , OrcaHMFzi ,  &
                                OrcaHMMxi , OrcaHMMyi , OrcaHMMzi ,  &
                                  OrcaMxi ,   OrcaMyi ,   OrcaMzi /)
   CHARACTER(ChanLen), PARAMETER :: ParamUnitsAry(18) =  (/ &                      ! This lists the units corresponding to the allowed parameters
                               "(kN)      ","(kN)      ","(kN)      ",  &
                               "(kN m)    ","(kN m)    ","(kN m)    ",  &
                               "(kN)      ","(kN)      ","(kN)      ",  &
                               "(kN)      ","(kN)      ","(kN)      ",  &
                               "(kN m)    ","(kN m)    ","(kN m)    ",  &
                               "(kN m)    ","(kN m)    ","(kN m)    "/)


      ! Initialize values
   ErrStat = ErrID_None
   ErrMsg = ""
   InvalidOutput = .FALSE.


!   ..... Developer must add checking for invalid inputs here: .....

!   ................. End of validity checking .................


   !-------------------------------------------------------------------------------------------------
   ! Allocate and set index, name, and units for the output channels
   ! If a selected output channel is not available in this module, set error flag.
   !-------------------------------------------------------------------------------------------------

   ALLOCATE ( p%OutParam(0:p%NumOuts) , STAT=ErrStat2 )
   IF ( ErrStat2 /= 0_IntKi )  THEN
      CALL SetErrStat( ErrID_Fatal,"Error allocating memory for the OrcaFlexInterface OutParam array.", ErrStat, ErrMsg, RoutineName )
      RETURN
   ENDIF

      ! Set index, name, and units for the time output channel:

   p%OutParam(0)%Indx  = Time
   p%OutParam(0)%Name  = "Time"    ! OutParam(0) is the time channel by default.
   p%OutParam(0)%Units = "(s)"
   p%OutParam(0)%SignM = 1


      ! Set index, name, and units for all of the output channels.
      ! If a selected output channel is not available by this module set ErrStat = ErrID_Warn.


   DO I = 1,p%NumOuts

      p%OutParam(I)%Name  = OutList(I)
      OutListTmp          = OutList(I)


      ! Reverse the sign (+/-) of the output channel if the user prefixed the
      !   channel name with a "-", "_", "m", or "M" character indicating "minus".


      CheckOutListAgain = .FALSE.

      IF      ( INDEX( "-_", OutListTmp(1:1) ) > 0 ) THEN
         p%OutParam(I)%SignM = -1                         ! ex, "-TipDxc1" causes the sign of TipDxc1 to be switched.
         OutListTmp          = OutListTmp(2:)
      ELSE IF ( INDEX( "mM", OutListTmp(1:1) ) > 0 ) THEN ! We'll assume this is a variable name for now, (if not, we will check later if OutListTmp(2:) is also a variable name)
         CheckOutListAgain   = .TRUE.
         p%OutParam(I)%SignM = 1
      ELSE
         p%OutParam(I)%SignM = 1
      END IF

      CALL Conv2UC( OutListTmp )    ! Convert OutListTmp to upper case


      Indx = IndexCharAry( OutListTmp(1:OutStrLenM1), ValidParamAry )


         ! If it started with an "M" (CheckOutListAgain) we didn't find the value in our list (Indx < 1)

      IF ( CheckOutListAgain .AND. Indx < 1 ) THEN    ! Let's assume that "M" really meant "minus" and then test again
         p%OutParam(I)%SignM = -1                     ! ex, "MTipDxc1" causes the sign of TipDxc1 to be switched.
         OutListTmp          = OutListTmp(2:)

         Indx = IndexCharAry( OutListTmp(1:OutStrLenM1), ValidParamAry )
      END IF


      IF ( Indx > 0 ) THEN ! we found the channel name
         p%OutParam(I)%Indx     = ParamIndxAry(Indx)
         IF ( InvalidOutput( ParamIndxAry(Indx) ) ) THEN  ! but, it isn't valid for these settings
            p%OutParam(I)%Units = "INVALID"
            p%OutParam(I)%SignM = 0
         ELSE
            p%OutParam(I)%Units = ParamUnitsAry(Indx) ! it's a valid output
         END IF
      ELSE ! this channel isn't valid
         p%OutParam(I)%Indx  = Time                 ! pick any valid channel (I just picked "Time" here because it's universal)
         p%OutParam(I)%Units = "INVALID"
         p%OutParam(I)%SignM = 0                    ! multiply all results by zero

         CALL SetErrStat(ErrID_Fatal, TRIM(p%OutParam(I)%Name)//" is not an available output channel.",ErrStat,ErrMsg,RoutineName)
      END IF

   END DO

   RETURN
END SUBROUTINE SetOutParam
!----------------------------------------------------------------------------------------------------------------------------------
!End of code generated by Matlab script
!**********************************************************************************************************************************

SUBROUTINE SetAllOuts( ParamData, OutData, m, ErrStat, ErrMsg )

   IMPLICIT                                              NONE

   CHARACTER(*),              PARAMETER               :: RoutineName="SetAllOuts"


   TYPE(Orca_ParameterType),           INTENT(IN   )  :: ParamData            !< The parameters for Orca
   TYPE(Orca_OutputType),              INTENT(INOUT)  :: OutData              !< Outputs
   TYPE(Orca_MiscVarType),             INTENT(INOUT)  :: m                    !< The MiscVars info for Orca
   INTEGER(IntKi),                     INTENT(  OUT)  :: ErrStat              !< Error status  from this subroutine
   CHARACTER(*),                       INTENT(  OUT)  :: ErrMsg               !< Error message from this subroutine


      ! Local Variables
   INTEGER(IntKi)                                     :: I                    !< Generic counter


      ! Initialization
   ErrStat  = ErrID_None
   ErrMsg   = ''


      ! Set the values
   m%AllOuts(  OrcaFxi  )  =  OutData%PtfmMesh%Force(1,1)/1000_ReKi
   m%AllOuts(  OrcaFyi  )  =  OutData%PtfmMesh%Force(2,1)/1000_ReKi
   m%AllOuts(  OrcaFzi  )  =  OutData%PtfmMesh%Force(3,1)/1000_ReKi
   m%AllOuts(  OrcaMxi  )  =  OutData%PtfmMesh%Moment(1,1)/1000_ReKi
   m%AllOuts(  OrcaMyi  )  =  OutData%PtfmMesh%Moment(2,1)/1000_ReKi
   m%AllOuts(  OrcaMzi  )  =  OutData%PtfmMesh%Moment(3,1)/1000_ReKi

   m%AllOuts(  OrcaHMFxi  )  =  m%PtfmFT(1)/1000_ReKi
   m%AllOuts(  OrcaHMFyi  )  =  m%PtfmFT(2)/1000_ReKi
   m%AllOuts(  OrcaHMFzi  )  =  m%PtfmFT(3)/1000_ReKi
   m%AllOuts(  OrcaHMMxi  )  =  m%PtfmFT(4)/1000_ReKi
   m%AllOuts(  OrcaHMMyi  )  =  m%PtfmFT(5)/1000_ReKi
   m%AllOuts(  OrcaHMMzi  )  =  m%PtfmFT(6)/1000_ReKi

   m%AllOuts(  OrcaAMFxi  )  =  m%F_PtfmAM(1)/1000_ReKi
   m%AllOuts(  OrcaAMFyi  )  =  m%F_PtfmAM(2)/1000_ReKi
   m%AllOuts(  OrcaAMFzi  )  =  m%F_PtfmAM(3)/1000_ReKi
   m%AllOuts(  OrcaAMMxi  )  =  m%F_PtfmAM(4)/1000_ReKi
   m%AllOuts(  OrcaAMMyi  )  =  m%F_PtfmAM(5)/1000_ReKi
   m%AllOuts(  OrcaAMMzi  )  =  m%F_PtfmAM(6)/1000_ReKi

      ! Set the values for the WriteOutput array
   OutData%WriteOutput(  OrcaFxi  )  =  OutData%PtfmMesh%Force(1,1)/1000_ReKi
   OutData%WriteOutput(  OrcaFyi  )  =  OutData%PtfmMesh%Force(2,1)/1000_ReKi
   OutData%WriteOutput(  OrcaFzi  )  =  OutData%PtfmMesh%Force(3,1)/1000_ReKi
   OutData%WriteOutput(  OrcaMxi  )  =  OutData%PtfmMesh%Moment(1,1)/1000_ReKi
   OutData%WriteOutput(  OrcaMyi  )  =  OutData%PtfmMesh%Moment(2,1)/1000_ReKi
   OutData%WriteOutput(  OrcaMzi  )  =  OutData%PtfmMesh%Moment(3,1)/1000_ReKi

   OutData%WriteOutput(  OrcaHMFxi  )  =  m%PtfmFT(1)/1000_ReKi
   OutData%WriteOutput(  OrcaHMFyi  )  =  m%PtfmFT(2)/1000_ReKi
   OutData%WriteOutput(  OrcaHMFzi  )  =  m%PtfmFT(3)/1000_ReKi
   OutData%WriteOutput(  OrcaHMMxi  )  =  m%PtfmFT(4)/1000_ReKi
   OutData%WriteOutput(  OrcaHMMyi  )  =  m%PtfmFT(5)/1000_ReKi
   OutData%WriteOutput(  OrcaHMMzi  )  =  m%PtfmFT(6)/1000_ReKi

   OutData%WriteOutput(  OrcaAMFxi  )  =  m%F_PtfmAM(1)/1000_ReKi
   OutData%WriteOutput(  OrcaAMFyi  )  =  m%F_PtfmAM(2)/1000_ReKi
   OutData%WriteOutput(  OrcaAMFzi  )  =  m%F_PtfmAM(3)/1000_ReKi
   OutData%WriteOutput(  OrcaAMMxi  )  =  m%F_PtfmAM(4)/1000_ReKi
   OutData%WriteOutput(  OrcaAMMyi  )  =  m%F_PtfmAM(5)/1000_ReKi
   OutData%WriteOutput(  OrcaAMMzi  )  =  m%F_PtfmAM(6)/1000_ReKi


END SUBROUTINE SetAllOuts




END MODULE OrcaFlexInterface
!**********************************************************************************************************************************
