!STARTOFREGISTRYGENERATEDFILE 'FAST_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! FAST_Types
!.................................................................................................................................
! This file is part of FAST.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in FAST. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE FAST_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE ElastoDyn_Types
USE SED_Types
USE BeamDyn_Types
USE ServoDyn_Types
USE AeroDyn_Types
USE AeroDisk_Types
USE ExtLoads_Types
USE SubDyn_Types
USE SeaState_Types
USE HydroDyn_Types
USE IceFloe_Types
USE ExternalInflow_Types
USE IceDyn_Types
USE FEAMooring_Types
USE MAP_Types
USE MoorDyn_Types
USE OrcaFlexInterface_Types
USE ExtPtfm_MCKF_Types
USE NWTC_Library
IMPLICIT NONE
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Module_Unknown = -1      ! Unknown [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Module_None = 0      ! No module selected [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Module_Glue = 1      ! Glue code [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Module_IfW = 2      ! InflowWind [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Module_ExtInfw = 3      ! ExternalInflow [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Module_ED = 4      ! ElastoDyn [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Module_BD = 5      ! BeamDyn [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Module_AD = 7      ! AeroDyn [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Module_ExtLd = 8      ! ExternalLoads [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Module_SrvD = 9      ! ServoDyn [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Module_SeaSt = 10      ! SeaState [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Module_HD = 11      ! HydroDyn [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Module_SD = 12      ! SubDyn [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Module_ExtPtfm = 13      ! External Platform Loading MCKF [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Module_MAP = 14      ! MAP (Mooring Analysis Program) [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Module_FEAM = 15      ! FEAMooring [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Module_MD = 16      ! MoorDyn [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Module_Orca = 17      ! OrcaFlex integration (HD/Mooring) [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Module_IceF = 18      ! IceFloe [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Module_IceD = 19      ! IceDyn [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Module_ADsk = 20      ! AeroDisk [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Module_SED = 21      ! Simplified-ElastoDyn [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: NumModules = 21      ! The number of modules available in FAST [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: MaxNBlades = 3      ! Maximum number of blades allowed on a turbine [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: IceD_MaxLegs = 4      ! because I don't know how many legs there are before calling IceD_Init and I don't want to copy the data because of sibling mesh issues, I'm going to allocate IceD based on this number [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: SS_Indx_Pitch = 1      ! pitch [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: SS_Indx_TSR = 2      ! TSR [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: SS_Indx_WS = 3      ! wind speed [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: SS_Indx_RotSpeed = 4      ! rotor speed [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: SS_Indx_Err = 5      ! err in the ss solve [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: SS_Indx_Iter = 6      ! number of iterations [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: NumStateTimes = 4      ! size of arrays of state derived types (Continuous state type etc). (STATE_CURR, STATE_PRED, STATE_SAVED_CURR, STATE_SAVED_PRED) [-]
! =========  FAST_VTK_BLSurfaceType  =======
  TYPE, PUBLIC :: FAST_VTK_BLSurfaceType
    REAL(SiKi) , DIMENSION(:,:,:), ALLOCATABLE  :: AirfoilCoords      !< x,y coordinates for airfoil around each blade node on a blade (relative to reference) [-]
  END TYPE FAST_VTK_BLSurfaceType
! =======================
! =========  FAST_VTK_SurfaceType  =======
  TYPE, PUBLIC :: FAST_VTK_SurfaceType
    INTEGER(IntKi)  :: NumSectors = 0_IntKi      !< number of sectors in which to split circles (higher number gives smoother surface) [-]
    REAL(SiKi)  :: HubRad = 0.0_R4Ki      !< Preconed hub radius (distance from the rotor apex to the blade root) [m]
    REAL(SiKi)  :: GroundRad = 0.0_R4Ki      !< radius for plotting circle on ground [m]
    REAL(SiKi) , DIMENSION(1:3,1:8)  :: NacelleBox = 0.0_R4Ki      !< X-Y-Z locations of 8 points that define the nacelle box, relative to the nacelle position [m]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: TowerRad      !< radius of each ED tower node [m]
    INTEGER(IntKi) , DIMENSION(1:2)  :: NWaveElevPts = 0_IntKi      !< number of points for wave elevation visualization [-]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: WaveElevVisX      !< X locations for WaveElev output (for visualization). [m,-]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: WaveElevVisY      !< Y locations for WaveElev output (for visualization). [m,-]
    REAL(SiKi) , DIMENSION(:,:,:), ALLOCATABLE  :: WaveElevVisGrid      !< wave elevation at WaveElevVis{XY}; first dimension is time step; second/third dimensions are grid of elevations [m,-]
    TYPE(FAST_VTK_BLSurfaceType) , DIMENSION(:), ALLOCATABLE  :: BladeShape      !< AirfoilCoords for each blade [m]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: MorisonVisRad      !< radius of each Morison node [m]
  END TYPE FAST_VTK_SurfaceType
! =======================
! =========  FAST_VTK_ModeShapeType  =======
  TYPE, PUBLIC :: FAST_VTK_ModeShapeType
    CHARACTER(1024)  :: CheckpointRoot      !< name of the checkpoint file written by FAST when linearization data was produced [-]
    CHARACTER(1024)  :: MatlabFileName      !< name of the file with eigenvectors written by Matlab [-]
    INTEGER(IntKi)  :: VTKLinModes = 0_IntKi      !< Number of modes to visualize [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: VTKModes      !< Which modes to visualize [-]
    INTEGER(IntKi)  :: VTKLinTim = 0_IntKi      !< Switch to make one animation for all LinTimes together (1) or separate animations for each LinTimes(2) [-]
    INTEGER(IntKi)  :: VTKNLinTimes = 0_IntKi      !< number of linearization times to use when VTKLinTim==2 [-]
    REAL(ReKi)  :: VTKLinScale = 0.0_ReKi      !< Mode shape visualization scaling factor [-]
    REAL(ReKi)  :: VTKLinPhase = 0.0_ReKi      !< Phase when making one animation for all LinTimes together (used only when VTKLinTim=1) [-]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: DampingRatio      !< damping ratios from mbc3 analysis [-]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: NaturalFreq_Hz      !< natural frequency from mbc3 analysis [-]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: DampedFreq_Hz      !< damped frequency from mbc3 analysis [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: x_eig_magnitude      !< magnitude of eigenvector (dimension 1=state, dim 2= azimuth, dim 3 = mode) [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: x_eig_phase      !< phase of eigenvector (dimension 1=state, dim 2= azimuth, dim 3 = mode) [-]
  END TYPE FAST_VTK_ModeShapeType
! =======================
! =========  FAST_SS_CaseType  =======
  TYPE, PUBLIC :: FAST_SS_CaseType
    REAL(ReKi)  :: RotSpeed = 0.0_ReKi      !< Rotor speed for this case of the steady-state solve [>0] [(rad/s)]
    REAL(ReKi)  :: TSR = 0.0_ReKi      !< TSR for this case of the steady-state solve [>0] [(-)]
    REAL(ReKi)  :: WindSpeed = 0.0_ReKi      !< Windspeed for this case of the steady-state solve [>0] [(m/s)]
    REAL(ReKi)  :: Pitch = 0.0_ReKi      !< Pitch angle for this case of the steady-state solve [(rad)]
  END TYPE FAST_SS_CaseType
! =======================
! =========  FAST_ParameterType  =======
  TYPE, PUBLIC :: FAST_ParameterType
    REAL(DbKi)  :: DT = 0.0_R8Ki      !< Integration time step [global time] [s]
    REAL(DbKi) , DIMENSION(1:NumModules)  :: DT_module = 0.0_R8Ki      !< Integration time step [global time] [s]
    INTEGER(IntKi) , DIMENSION(1:NumModules)  :: n_substeps = 0_IntKi      !< The number of module substeps for advancing states from t_global to t_global_next [-]
    INTEGER(IntKi)  :: n_TMax_m1 = 0_IntKi      !< The time step of TMax - dt (the end time of the simulation) [(-)]
    REAL(DbKi)  :: TMax = 0.0_R8Ki      !< Total run time [s]
    INTEGER(IntKi)  :: InterpOrder = 0_IntKi      !< Interpolation order {0,1,2} [-]
    INTEGER(IntKi)  :: NumCrctn = 0_IntKi      !< Number of correction iterations [-]
    INTEGER(IntKi)  :: KMax = 0_IntKi      !< Maximum number of input-output-solve or nonlinear solve residual equation iterations (KMax >= 1) [>0] [-]
    INTEGER(IntKi)  :: numIceLegs = 0_IntKi      !< number of suport-structure legs in contact with ice (IceDyn coupling) [-]
    INTEGER(IntKi)  :: nBeams = 0_IntKi      !< number of BeamDyn instances [-]
    LOGICAL  :: BD_OutputSibling = .false.      !< flag to determine if BD input is sibling of output mesh [-]
    LOGICAL , DIMENSION(1:NumModules)  :: ModuleInitialized = .false.      !< An array determining if the module has been initialized [-]
    REAL(DbKi)  :: DT_Ujac = 0.0_R8Ki      !< Time between when we need to re-calculate these Jacobians [s]
    REAL(ReKi)  :: UJacSclFact = 0.0_ReKi      !< Scaling factor used to get similar magnitudes between accelerations, forces, and moments in Jacobians [-]
    INTEGER(IntKi) , DIMENSION(1:9)  :: SizeJac_Opt1 = 0_IntKi      !< (1)=size of matrix; (2)=size of ED portion; (3)=size of SD portion [2 meshes]; (4)=size of HD portion; (5)=size of BD portion blade 1; (6)=size of BD portion blade 2; (7)=size of BD portion blade 3; (8)=size of Orca portion; (9)=size of ExtPtfm portion; [-]
    INTEGER(IntKi)  :: SolveOption = 0_IntKi      !< Switch to determine which solve option we are going to use (see Solve_FullOpt1, etc) [-]
    INTEGER(IntKi)  :: CompElast = 0_IntKi      !< Compute blade loads (switch) {Module_ED; Module_BD; Module_SED} [-]
    INTEGER(IntKi)  :: CompInflow = 0_IntKi      !< Compute inflow wind conditions (switch) {Module_None; Module_IfW; Module_ExtInfw} [-]
    INTEGER(IntKi)  :: CompAero = 0_IntKi      !< Compute aerodynamic loads (switch) {Module_None; Module_ADsk; Module_AD} [-]
    INTEGER(IntKi)  :: CompServo = 0_IntKi      !< Compute control and electrical-drive dynamics (switch) {Module_None; Module_SrvD} [-]
    INTEGER(IntKi)  :: CompSeaSt = 0_IntKi      !< Compute sea states; wave kinematics (switch) {Module_None; Module_SeaSt} [-]
    INTEGER(IntKi)  :: CompHydro = 0_IntKi      !< Compute hydrodynamic loads (switch) {Module_None; Module_HD} [-]
    INTEGER(IntKi)  :: CompSub = 0_IntKi      !< Compute sub-structural dynamics (switch) {Module_None; Module_SD, Module_ExtPtfm} [-]
    INTEGER(IntKi)  :: CompMooring = 0_IntKi      !< Compute mooring system (switch) {Module_None; Module_MAP; Module_FEAM; Module_MD; Module_Orca} [-]
    INTEGER(IntKi)  :: CompIce = 0_IntKi      !< Compute ice loading (switch) {Module_None; Module_IceF, Module_IceD} [-]
    INTEGER(IntKi)  :: MHK = 0_IntKi      !< MHK turbine type (switch) {0=Not an MHK turbine; 1=Fixed MHK turbine; 2=Floating MHK turbine} [-]
    LOGICAL  :: UseDWM = .false.      !< Use the DWM module in AeroDyn [-]
    LOGICAL  :: Linearize = .false.      !< Linearization analysis (flag) [-]
    INTEGER(IntKi)  :: WaveFieldMod = 0_IntKi      !< Wave field handling (-) (switch) 0: use individual HydroDyn inputs without adjustment, 1: adjust wave phases based on turbine offsets from farm origin [-]
    LOGICAL  :: FarmIntegration = .false.      !< whether this is called from FAST.Farm (or another program that doesn't want FAST to call all of the init stuff first) [-]
    REAL(SiKi) , DIMENSION(1:3)  :: TurbinePos = 0.0_R4Ki      !< Initial position of turbine base (origin used for graphics) [m]
    REAL(ReKi)  :: Gravity = 0.0_ReKi      !< Gravitational acceleration [m/s^2]
    REAL(ReKi)  :: AirDens = 0.0_ReKi      !< Air density [kg/m^3]
    REAL(ReKi)  :: WtrDens = 0.0_ReKi      !< Water density [kg/m^3]
    REAL(ReKi)  :: KinVisc = 0.0_ReKi      !< Kinematic viscosity of working fluid [m^2/s]
    REAL(ReKi)  :: SpdSound = 0.0_ReKi      !< Speed of sound in working fluid [m/s]
    REAL(ReKi)  :: Patm = 0.0_ReKi      !< Atmospheric pressure [Pa]
    REAL(ReKi)  :: Pvap = 0.0_ReKi      !< Vapour pressure of working fluid [Pa]
    REAL(ReKi)  :: WtrDpth = 0.0_ReKi      !< Water depth [m]
    REAL(ReKi)  :: MSL2SWL = 0.0_ReKi      !< Offset between still-water level and mean sea level [m]
    CHARACTER(1024)  :: EDFile      !< The name of the ElastoDyn/Simplified-ElastoDyn input file [-]
    CHARACTER(1024) , DIMENSION(1:MaxNBlades)  :: BDBldFile      !< Name of files containing BeamDyn inputs for each blade [-]
    CHARACTER(1024)  :: InflowFile      !< Name of file containing inflow wind input parameters [-]
    CHARACTER(1024)  :: AeroFile      !< Name of file containing aerodynamic input parameters [-]
    CHARACTER(1024)  :: ServoFile      !< Name of file containing control and electrical-drive input parameters [-]
    CHARACTER(1024)  :: SeaStFile      !< Name of file containing sea state input parameters [-]
    CHARACTER(1024)  :: HydroFile      !< Name of file containing hydrodynamic input parameters [-]
    CHARACTER(1024)  :: SubFile      !< Name of file containing sub-structural input parameters [-]
    CHARACTER(1024)  :: MooringFile      !< Name of file containing mooring system input parameters [-]
    CHARACTER(1024)  :: IceFile      !< Name of file containing ice loading input parameters [-]
    REAL(DbKi)  :: TStart = 0.0_R8Ki      !< Time to begin tabular output [s]
    REAL(DbKi)  :: DT_Out = 0.0_R8Ki      !< Time step for tabular output [s]
    LOGICAL  :: WrSttsTime = .false.      !< Whether we should write the status times to the screen [-]
    INTEGER(IntKi)  :: n_SttsTime = 0_IntKi      !< Number of time steps between screen status messages [-]
    INTEGER(IntKi)  :: n_ChkptTime = 0_IntKi      !< Number of time steps between writing checkpoint files [-]
    INTEGER(IntKi)  :: n_DT_Out = 0_IntKi      !< Number of time steps between writing a line in the time-marching output files [-]
    INTEGER(IntKi)  :: n_VTKTime = 0_IntKi      !< Number of time steps between writing VTK files [-]
    LOGICAL  :: WrBinOutFile = .false.      !< Write a binary output file? (.outb) [-]
    LOGICAL  :: WrTxtOutFile = .false.      !< Write a text (formatted) output file? (.out) [-]
    INTEGER(IntKi)  :: WrBinMod = 0_IntKi      !< If writing binary, which file format is to be written [1, 2, or 3] [-]
    LOGICAL  :: SumPrint = .false.      !< Print summary data to file? (.sum) [-]
    INTEGER(IntKi)  :: WrVTK = 0      !< VTK Visualization data output: (switch) {0=none; 1=initialization data only; 2=animation} [-]
    INTEGER(IntKi)  :: VTK_Type = 0_IntKi      !< Type of  VTK visualization data: (switch) {1=surfaces; 2=basic meshes (lines/points); 3=all meshes (debug)} [-]
    LOGICAL  :: VTK_fields = .false.      !< Write mesh fields to VTK data files? (flag) {true/false} [-]
    CHARACTER(1)  :: Delim      !< Delimiter between columns of text output file (.out): space or tab [-]
    CHARACTER(20)  :: OutFmt      !< Format used for text tabular output (except time); resulting field should be 10 characters [-]
    CHARACTER(20)  :: OutFmt_t      !< Format used for time channel in text tabular output; resulting field should be 10 characters [-]
    INTEGER(IntKi)  :: FmtWidth = 0_IntKi      !< width of the time OutFmt specifier [-]
    INTEGER(IntKi)  :: TChanLen = 0_IntKi      !< width of the time channel [-]
    CHARACTER(1024)  :: OutFileRoot      !< The rootname of the output files [-]
    CHARACTER(1024)  :: FTitle      !< The description line from the FAST (glue-code) input file [-]
    CHARACTER(1024)  :: VTK_OutFileRoot = ''      !< The rootname of the VTK output files [-]
    INTEGER(IntKi)  :: VTK_tWidth = 0_IntKi      !< Width of number of files for leading zeros in file name format [-]
    REAL(DbKi)  :: VTK_fps = 0.0_R8Ki      !< number of frames per second to output VTK data [-]
    TYPE(FAST_VTK_SurfaceType)  :: VTK_surface      !< Data for VTK surface visualization [-]
    CHARACTER(4)  :: Tdesc      !< description of turbine ID (for FAST.Farm) screen printing [-]
    REAL(DbKi) , DIMENSION(1:6)  :: PlatformPosInit = 0.0_R8Ki      !< Platform inital 6 DOF position from ED (this is different from TurbinePos) [-]
    LOGICAL  :: CalcSteady = .false.      !< Calculate a steady-state periodic operating point before linearization [unused if Linearize=False] [-]
    INTEGER(IntKi)  :: TrimCase = 0_IntKi      !< Controller parameter to be trimmed {1:yaw; 2:torque; 3:pitch} [unused if Linearize=False; used only if CalcSteady=True] [-]
    REAL(ReKi)  :: TrimTol = 0.0_ReKi      !< Tolerance for the rotational speed convergence (>0) [unused if Linearize=False; used only if CalcSteady=True] [-]
    REAL(ReKi)  :: TrimGain = 0.0_ReKi      !< Proportional gain for the rotational speed error (>0) [unused if Linearize=False; used only if CalcSteady=True] [rad/(rad/s) for yaw or pitch; Nm/(rad/s) for torque]
    REAL(ReKi)  :: Twr_Kdmp = 0.0_ReKi      !< Damping factor for the tower [unused if Linearize=False; used only if CalcSteady=True] [N/(m/s)]
    REAL(ReKi)  :: Bld_Kdmp = 0.0_ReKi      !< Damping factor for the blades [unused if Linearize=False; used only if CalcSteady=True] [N/(m/s)]
    INTEGER(IntKi)  :: NLinTimes = 0_IntKi      !< Number of LinTimes, or equally-spaced azimuth steps in periodic linearized model (>0)[unused if Linearize=False] [-]
    REAL(DbKi)  :: AzimDelta = 0.0_R8Ki      !< difference between two consecutive azimuth positions in CalcSteady algorithm [rad]
    INTEGER(IntKi)  :: LinInputs = 0_IntKi      !< Inputs included in linearization (switch) {0=none; 1=standard; 2=all module inputs (debug)} [unused if Linearize=False] [-]
    INTEGER(IntKi)  :: LinOutputs = 0_IntKi      !< Outputs included in linearization (switch) {0=none; 1=from OutList(s); 2=all module outputs (debug)} [unused if Linearize=False] [-]
    LOGICAL  :: LinOutJac = .false.      !< Include full Jacabians in linearization output (for debug) (flag) [unused if Linearize=False; used only if LinInputs=LinOutputs=2] [-]
    LOGICAL  :: LinOutMod = .false.      !< Write module-level linearization output files in addition to output for full system? (flag) [unused if Linearize=False] [-]
    TYPE(FAST_VTK_ModeShapeType)  :: VTK_modes      !< Data for VTK mode-shape visualization [-]
    INTEGER(IntKi)  :: Lin_NumMods = 0_IntKi      !< number of modules in the linearization [-]
    INTEGER(IntKi) , DIMENSION(1:NumModules)  :: Lin_ModOrder = 0_IntKi      !< indices that determine which order the modules are in the glue-code linearization matrix [-]
    INTEGER(IntKi)  :: LinInterpOrder = 0_IntKi      !< Interpolation order for CalcSteady solution [-]
    LOGICAL  :: CompAeroMaps = .false.      !< Flag to determine if we are calculating aero maps [-]
    INTEGER(IntKi)  :: N_UJac = 0_IntKi      !< Number of iterations between re-calculating Jacobian [(-)]
    INTEGER(IntKi)  :: NumBl_Lin = 0_IntKi      !< number of blades in the jacobian [-]
    REAL(R8Ki)  :: tolerSquared = 0.0_R8Ki      !< Convergence tolerance for nonlinear solve residual equation [>0] squared [(-)]
    INTEGER(IntKi)  :: NumSSCases = 0_IntKi      !< Number of cases for steady-state solver generation [>0] [(-)]
    INTEGER(IntKi)  :: WindSpeedOrTSR = 0_IntKi      !< Choice of swept parameter (switch) { 1:wind speed; 2: TSR } [(-)]
    REAL(ReKi)  :: RotSpeedInit = 0.0_ReKi      !< Initial rotor speed for steady-state solve [>0] [(rad/s)]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: RotSpeed      !< List of rotor speeds for steady-state solve [>0] [(rad/s)]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WS_TSR      !< List of WindSpeed or TSRs (depending on WindSpeedOrTSR setting) for aeromap generation [(m/s or -)]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Pitch      !< List of pitch angles for aeromap generation [(rad)]
    INTEGER(IntKi)  :: GearBox_index = 0_IntKi      !< Index to gearbox rotation in state array (for steady-state calculations) [-]
  END TYPE FAST_ParameterType
! =======================
! =========  FAST_LinStateSave  =======
  TYPE, PUBLIC :: FAST_LinStateSave
    TYPE(IceD_ContinuousStateType) , DIMENSION(:,:), ALLOCATABLE  :: x_IceD      !< Continuous states [-]
    TYPE(IceD_DiscreteStateType) , DIMENSION(:,:), ALLOCATABLE  :: xd_IceD      !< Discrete states [-]
    TYPE(IceD_ConstraintStateType) , DIMENSION(:,:), ALLOCATABLE  :: z_IceD      !< Constraint states [-]
    TYPE(IceD_OtherStateType) , DIMENSION(:,:), ALLOCATABLE  :: OtherSt_IceD      !< Other states [-]
    TYPE(IceD_InputType) , DIMENSION(:,:), ALLOCATABLE  :: u_IceD      !< System inputs [-]
    TYPE(BD_ContinuousStateType) , DIMENSION(:,:), ALLOCATABLE  :: x_BD      !< Continuous states [-]
    TYPE(BD_DiscreteStateType) , DIMENSION(:,:), ALLOCATABLE  :: xd_BD      !< Discrete states [-]
    TYPE(BD_ConstraintStateType) , DIMENSION(:,:), ALLOCATABLE  :: z_BD      !< Constraint states [-]
    TYPE(BD_OtherStateType) , DIMENSION(:,:), ALLOCATABLE  :: OtherSt_BD      !< Other states [-]
    TYPE(BD_InputType) , DIMENSION(:,:), ALLOCATABLE  :: u_BD      !< System inputs [-]
    TYPE(ED_ContinuousStateType) , DIMENSION(:), ALLOCATABLE  :: x_ED      !< Continuous states [-]
    TYPE(ED_DiscreteStateType) , DIMENSION(:), ALLOCATABLE  :: xd_ED      !< Discrete states [-]
    TYPE(ED_ConstraintStateType) , DIMENSION(:), ALLOCATABLE  :: z_ED      !< Constraint states [-]
    TYPE(ED_OtherStateType) , DIMENSION(:), ALLOCATABLE  :: OtherSt_ED      !< Other states [-]
    TYPE(ED_InputType) , DIMENSION(:), ALLOCATABLE  :: u_ED      !< System inputs [-]
    TYPE(SrvD_ContinuousStateType) , DIMENSION(:), ALLOCATABLE  :: x_SrvD      !< Continuous states [-]
    TYPE(SrvD_DiscreteStateType) , DIMENSION(:), ALLOCATABLE  :: xd_SrvD      !< Discrete states [-]
    TYPE(SrvD_ConstraintStateType) , DIMENSION(:), ALLOCATABLE  :: z_SrvD      !< Constraint states [-]
    TYPE(SrvD_OtherStateType) , DIMENSION(:), ALLOCATABLE  :: OtherSt_SrvD      !< Other states [-]
    TYPE(SrvD_InputType) , DIMENSION(:), ALLOCATABLE  :: u_SrvD      !< System inputs [-]
    TYPE(AD_ContinuousStateType) , DIMENSION(:), ALLOCATABLE  :: x_AD      !< Continuous states [-]
    TYPE(AD_DiscreteStateType) , DIMENSION(:), ALLOCATABLE  :: xd_AD      !< Discrete states [-]
    TYPE(AD_ConstraintStateType) , DIMENSION(:), ALLOCATABLE  :: z_AD      !< Constraint states [-]
    TYPE(AD_OtherStateType) , DIMENSION(:), ALLOCATABLE  :: OtherSt_AD      !< Other states [-]
    TYPE(AD_InputType) , DIMENSION(:), ALLOCATABLE  :: u_AD      !< System inputs [-]
    TYPE(InflowWind_ContinuousStateType) , DIMENSION(:), ALLOCATABLE  :: x_IfW      !< Continuous states [-]
    TYPE(InflowWind_DiscreteStateType) , DIMENSION(:), ALLOCATABLE  :: xd_IfW      !< Discrete states [-]
    TYPE(InflowWind_ConstraintStateType) , DIMENSION(:), ALLOCATABLE  :: z_IfW      !< Constraint states [-]
    TYPE(InflowWind_OtherStateType) , DIMENSION(:), ALLOCATABLE  :: OtherSt_IfW      !< Other states [-]
    TYPE(InflowWind_InputType) , DIMENSION(:), ALLOCATABLE  :: u_IfW      !< System inputs [-]
    TYPE(SD_ContinuousStateType) , DIMENSION(:), ALLOCATABLE  :: x_SD      !< Continuous states [-]
    TYPE(SD_DiscreteStateType) , DIMENSION(:), ALLOCATABLE  :: xd_SD      !< Discrete states [-]
    TYPE(SD_ConstraintStateType) , DIMENSION(:), ALLOCATABLE  :: z_SD      !< Constraint states [-]
    TYPE(SD_OtherStateType) , DIMENSION(:), ALLOCATABLE  :: OtherSt_SD      !< Other states [-]
    TYPE(SD_InputType) , DIMENSION(:), ALLOCATABLE  :: u_SD      !< System inputs [-]
    TYPE(ExtPtfm_ContinuousStateType) , DIMENSION(:), ALLOCATABLE  :: x_ExtPtfm      !< Continuous states [-]
    TYPE(ExtPtfm_DiscreteStateType) , DIMENSION(:), ALLOCATABLE  :: xd_ExtPtfm      !< Discrete states [-]
    TYPE(ExtPtfm_ConstraintStateType) , DIMENSION(:), ALLOCATABLE  :: z_ExtPtfm      !< Constraint states [-]
    TYPE(ExtPtfm_OtherStateType) , DIMENSION(:), ALLOCATABLE  :: OtherSt_ExtPtfm      !< Other states [-]
    TYPE(ExtPtfm_InputType) , DIMENSION(:), ALLOCATABLE  :: u_ExtPtfm      !< System inputs [-]
    TYPE(HydroDyn_ContinuousStateType) , DIMENSION(:), ALLOCATABLE  :: x_HD      !< Continuous states [-]
    TYPE(HydroDyn_DiscreteStateType) , DIMENSION(:), ALLOCATABLE  :: xd_HD      !< Discrete states [-]
    TYPE(HydroDyn_ConstraintStateType) , DIMENSION(:), ALLOCATABLE  :: z_HD      !< Constraint states [-]
    TYPE(HydroDyn_OtherStateType) , DIMENSION(:), ALLOCATABLE  :: OtherSt_HD      !< Other states [-]
    TYPE(HydroDyn_InputType) , DIMENSION(:), ALLOCATABLE  :: u_HD      !< System inputs [-]
    TYPE(SeaSt_ContinuousStateType) , DIMENSION(:), ALLOCATABLE  :: x_SeaSt      !< Continuous states [-]
    TYPE(SeaSt_DiscreteStateType) , DIMENSION(:), ALLOCATABLE  :: xd_SeaSt      !< Discrete states [-]
    TYPE(SeaSt_ConstraintStateType) , DIMENSION(:), ALLOCATABLE  :: z_SeaSt      !< Constraint states [-]
    TYPE(SeaSt_OtherStateType) , DIMENSION(:), ALLOCATABLE  :: OtherSt_SeaSt      !< Other states [-]
    TYPE(SeaSt_InputType) , DIMENSION(:), ALLOCATABLE  :: u_SeaSt      !< System inputs [-]
    TYPE(IceFloe_ContinuousStateType) , DIMENSION(:), ALLOCATABLE  :: x_IceF      !< Continuous states [-]
    TYPE(IceFloe_DiscreteStateType) , DIMENSION(:), ALLOCATABLE  :: xd_IceF      !< Discrete states [-]
    TYPE(IceFloe_ConstraintStateType) , DIMENSION(:), ALLOCATABLE  :: z_IceF      !< Constraint states [-]
    TYPE(IceFloe_OtherStateType) , DIMENSION(:), ALLOCATABLE  :: OtherSt_IceF      !< Other states [-]
    TYPE(IceFloe_InputType) , DIMENSION(:), ALLOCATABLE  :: u_IceF      !< System inputs [-]
    TYPE(MAP_ContinuousStateType) , DIMENSION(:), ALLOCATABLE  :: x_MAP      !< Continuous states [-]
    TYPE(MAP_DiscreteStateType) , DIMENSION(:), ALLOCATABLE  :: xd_MAP      !< Discrete states [-]
    TYPE(MAP_ConstraintStateType) , DIMENSION(:), ALLOCATABLE  :: z_MAP      !< Constraint states [-]
    TYPE(MAP_InputType) , DIMENSION(:), ALLOCATABLE  :: u_MAP      !< System inputs [-]
    TYPE(FEAM_ContinuousStateType) , DIMENSION(:), ALLOCATABLE  :: x_FEAM      !< Continuous states [-]
    TYPE(FEAM_DiscreteStateType) , DIMENSION(:), ALLOCATABLE  :: xd_FEAM      !< Discrete states [-]
    TYPE(FEAM_ConstraintStateType) , DIMENSION(:), ALLOCATABLE  :: z_FEAM      !< Constraint states [-]
    TYPE(FEAM_OtherStateType) , DIMENSION(:), ALLOCATABLE  :: OtherSt_FEAM      !< Other states [-]
    TYPE(FEAM_InputType) , DIMENSION(:), ALLOCATABLE  :: u_FEAM      !< System inputs [-]
    TYPE(MD_ContinuousStateType) , DIMENSION(:), ALLOCATABLE  :: x_MD      !< Continuous states [-]
    TYPE(MD_DiscreteStateType) , DIMENSION(:), ALLOCATABLE  :: xd_MD      !< Discrete states [-]
    TYPE(MD_ConstraintStateType) , DIMENSION(:), ALLOCATABLE  :: z_MD      !< Constraint states [-]
    TYPE(MD_OtherStateType) , DIMENSION(:), ALLOCATABLE  :: OtherSt_MD      !< Other states [-]
    TYPE(MD_InputType) , DIMENSION(:), ALLOCATABLE  :: u_MD      !< System inputs [-]
  END TYPE FAST_LinStateSave
! =======================
! =========  FAST_LinType  =======
  TYPE, PUBLIC :: FAST_LinType
    CHARACTER(LinChanLen) , DIMENSION(:), ALLOCATABLE  :: Names_u      !< Names of the linearized inputs [-]
    CHARACTER(LinChanLen) , DIMENSION(:), ALLOCATABLE  :: Names_y      !< Names of the linearized outputs [-]
    CHARACTER(LinChanLen) , DIMENSION(:), ALLOCATABLE  :: Names_x      !< Names of the linearized continuous states [-]
    CHARACTER(LinChanLen) , DIMENSION(:), ALLOCATABLE  :: Names_xd      !< Names of the linearized discrete states [-]
    CHARACTER(LinChanLen) , DIMENSION(:), ALLOCATABLE  :: Names_z      !< Names of the linearized constraint states [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: op_u      !< input operating point [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: op_y      !< output operating point [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: op_x      !< continuous state operating point [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: op_dx      !< 1st time derivative of continuous state operating point [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: op_xd      !< discrete state operating point [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: op_z      !< constraint state operating point [-]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: op_x_eig_mag      !< continuous state eigenvector magnitude [-]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: op_x_eig_phase      !< continuous state eigenvector phase [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: Use_u      !< array same size as names_u, which indicates if this input is used in linearization output file [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: Use_y      !< array same size as names_y, which indicates if this output is used in linearization output file [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: A      !< A matrix [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: B      !< B matrix [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: C      !< C matrix [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: D      !< D matrix [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: StateRotation      !< Matrix that rotates the continuous states [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: StateRel_x      !< Matrix that defines the continuous states relative to root motion [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: StateRel_xdot      !< Matrix that defines the continuous states relative to root motion [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: IsLoad_u      !< Whether the input is a load (used for scaling for potentially ill-conditioned G matrix) [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: RotFrame_u      !< Whether corresponding input is in rotating frame [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: RotFrame_y      !< Whether corresponding output is in rotating frame [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: RotFrame_x      !< Whether corresponding continuous state is in rotating frame [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: RotFrame_z      !< Whether corresponding constraint state is in rotating frame [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: DerivOrder_x      !< Derivative order for continuous states [-]
    INTEGER(IntKi) , DIMENSION(1:3)  :: SizeLin = 0_IntKi      !< sizes of (1) the module's inputs,  (2) the module's linearized outputs, and (3) the module's continuous states [-]
    INTEGER(IntKi) , DIMENSION(1:3)  :: LinStartIndx = 0_IntKi      !< the starting index in combined matrices of (1) the module's inputs, (2) the module's linearized outputs, and (3) the module's continuous states [-]
    INTEGER(IntKi)  :: NumOutputs = 0_IntKi      !< number of WriteOutputs in each linearized module [-]
  END TYPE FAST_LinType
! =======================
! =========  FAST_ModLinType  =======
  TYPE, PUBLIC :: FAST_ModLinType
    TYPE(FAST_LinType) , DIMENSION(:), ALLOCATABLE  :: Instance      !< Linearization data for each module instance (e.g., 3 blades for BD) [-]
  END TYPE FAST_ModLinType
! =======================
! =========  FAST_LinFileType  =======
  TYPE, PUBLIC :: FAST_LinFileType
    TYPE(FAST_ModLinType) , DIMENSION(1:NumModules)  :: Modules      !< Linearization data for each module [-]
    TYPE(FAST_LinType)  :: Glue      !< Linearization data for the glue code (coupled system) [-]
    REAL(ReKi)  :: RotSpeed = 0.0_ReKi      !< Rotor azimuth angular speed [rad/s]
    REAL(ReKi)  :: Azimuth = 0.0_ReKi      !< Rotor azimuth position [rad]
    REAL(ReKi)  :: WindSpeed = 0.0_ReKi      !< Wind speed at reference height [m/s]
  END TYPE FAST_LinFileType
! =======================
! =========  FAST_MiscLinType  =======
  TYPE, PUBLIC :: FAST_MiscLinType
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: LinTimes      !< List of times at which to linearize [s]
    INTEGER(IntKi)  :: CopyOP_CtrlCode = 0_IntKi      !< mesh control code for copy type (new on first call; update otherwise) [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: AzimTarget      !< target azimuth positions in CalcSteady algorithm [rad]
    LOGICAL  :: IsConverged = .false.      !< whether the error calculation in the CalcSteady algorithm is converged [-]
    LOGICAL  :: FoundSteady = .false.      !< whether the CalcSteady algorithm found a steady-state solution [-]
    LOGICAL  :: ForceLin = .false.      !< whether the CalcSteady algorithm found a steady-state solution [-]
    INTEGER(IntKi)  :: n_rot = 0_IntKi      !< number of rotations completed in CalcSteady algorithm [-]
    INTEGER(IntKi)  :: AzimIndx = 0_IntKi      !< index into target azimuth array in CalcSteady algorithm [-]
    INTEGER(IntKi)  :: NextLinTimeIndx = 0_IntKi      !< index for next time in LinTimes where linearization should occur [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: Psi      !< Azimuth angle at the current and previous time steps (uses LinInterpOrder); DbKi so that we can use registry-generated extrap/interp routines [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: y_interp      !< Interpolated outputs packed into an array [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: y_ref      !< Reference output range for CalcSteady error calculation [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Y_prevRot      !< Linearization outputs from previous rotor revolution at each target azimuth  [-]
  END TYPE FAST_MiscLinType
! =======================
! =========  FAST_OutputFileType  =======
  TYPE, PUBLIC :: FAST_OutputFileType
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: TimeData      !< Array to contain the time output data for the binary file (first output time and a time [fixed] increment) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: AllOutData      !< Array to contain all the output data (time history of all outputs); Index 1 is NumOuts, Index 2 is Time step [-]
    INTEGER(IntKi)  :: n_Out = 0_IntKi      !< Time index into the AllOutData array [-]
    INTEGER(IntKi)  :: NOutSteps = 0_IntKi      !< Maximum number of output steps [-]
    INTEGER(IntKi) , DIMENSION(1:NumModules)  :: numOuts = 0_IntKi      !< number of outputs to print from each module [-]
    INTEGER(IntKi)  :: UnOu = -1      !< I/O unit number for the tabular output file [-]
    INTEGER(IntKi)  :: UnSum = -1      !< I/O unit number for the summary file [-]
    INTEGER(IntKi)  :: UnGra = -1      !< I/O unit number for mesh graphics [-]
    CHARACTER(1024) , DIMENSION(1:3)  :: FileDescLines      !< Description lines to include in output files (header, time run, plus module names/versions) [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: ChannelNames      !< Names of the output channels [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: ChannelUnits      !< Units for the output channels [-]
    TYPE(ProgDesc) , DIMENSION(1:NumModules)  :: Module_Ver      !< version information from all modules [-]
    CHARACTER(ChanLen) , DIMENSION(1:NumModules)  :: Module_Abrev      !< abbreviation for module (used in file output naming conventions) [-]
    LOGICAL  :: WriteThisStep = .false.      !< Whether this step will be written in the FAST output files [-]
    INTEGER(IntKi)  :: VTK_count = 0_IntKi      !< Number of VTK files written (for naming output files) [-]
    INTEGER(IntKi)  :: VTK_LastWaveIndx = 0_IntKi      !< last index into wave array [-]
    TYPE(FAST_LinFileType)  :: Lin      !< linearization data for output [-]
    INTEGER(IntKi)  :: ActualChanLen = 0_IntKi      !< width of the column headers output in the text and/or binary file [-]
    TYPE(FAST_LinStateSave)  :: op      !< operating points of states and inputs for VTK output of mode shapes [-]
    REAL(ReKi) , DIMENSION(1:6)  :: DriverWriteOutput = 0.0_ReKi      !< pitch and tsr for current aero map case, plus error, number of iterations, wind speed, rotor speed [-]
  END TYPE FAST_OutputFileType
! =======================
! =========  IceDyn_Data  =======
  TYPE, PUBLIC :: IceDyn_Data
    TYPE(IceD_ContinuousStateType) , DIMENSION(:,:), ALLOCATABLE  :: x      !< Continuous states [-]
    TYPE(IceD_DiscreteStateType) , DIMENSION(:,:), ALLOCATABLE  :: xd      !< Discrete states [-]
    TYPE(IceD_ConstraintStateType) , DIMENSION(:,:), ALLOCATABLE  :: z      !< Constraint states [-]
    TYPE(IceD_OtherStateType) , DIMENSION(:,:), ALLOCATABLE  :: OtherSt      !< Other states [-]
    TYPE(IceD_ParameterType) , DIMENSION(:), ALLOCATABLE  :: p      !< Parameters [-]
    TYPE(IceD_InputType) , DIMENSION(:), ALLOCATABLE  :: u      !< System inputs [-]
    TYPE(IceD_OutputType) , DIMENSION(:), ALLOCATABLE  :: y      !< System outputs [-]
    TYPE(IceD_MiscVarType) , DIMENSION(:), ALLOCATABLE  :: m      !< Misc/optimization variables [-]
    TYPE(IceD_InputType) , DIMENSION(:,:), ALLOCATABLE  :: Input      !< Array of inputs associated with InputTimes [-]
    TYPE(IceD_InputType) , DIMENSION(:,:), ALLOCATABLE  :: Input_Saved      !< Backup Array of inputs associated with InputTimes [-]
    REAL(DbKi) , DIMENSION(:,:), ALLOCATABLE  :: InputTimes      !< Array of times associated with Input Array [-]
    REAL(DbKi) , DIMENSION(:,:), ALLOCATABLE  :: InputTimes_Saved      !< Backup Array of times associated with Input Array [-]
  END TYPE IceDyn_Data
! =======================
! =========  BeamDyn_Data  =======
  TYPE, PUBLIC :: BeamDyn_Data
    TYPE(BD_ContinuousStateType) , DIMENSION(:,:), ALLOCATABLE  :: x      !< Continuous states [-]
    TYPE(BD_DiscreteStateType) , DIMENSION(:,:), ALLOCATABLE  :: xd      !< Discrete states [-]
    TYPE(BD_ConstraintStateType) , DIMENSION(:,:), ALLOCATABLE  :: z      !< Constraint states [-]
    TYPE(BD_OtherStateType) , DIMENSION(:,:), ALLOCATABLE  :: OtherSt      !< Other states [-]
    TYPE(BD_ParameterType) , DIMENSION(:), ALLOCATABLE  :: p      !< Parameters [-]
    TYPE(BD_InputType) , DIMENSION(:), ALLOCATABLE  :: u      !< System inputs [-]
    TYPE(BD_OutputType) , DIMENSION(:), ALLOCATABLE  :: y      !< System outputs [-]
    TYPE(BD_MiscVarType) , DIMENSION(:), ALLOCATABLE  :: m      !< Misc/optimization variables [-]
    TYPE(BD_OutputType) , DIMENSION(:,:), ALLOCATABLE  :: Output      !< Array of outputs associated with CalcSteady Azimuths [-]
    TYPE(BD_OutputType) , DIMENSION(:), ALLOCATABLE  :: y_interp      !< interpolated system outputs for CalcSteady [-]
    TYPE(BD_InputType) , DIMENSION(:,:), ALLOCATABLE  :: Input      !< Array of inputs associated with InputTimes [-]
    TYPE(BD_InputType) , DIMENSION(:,:), ALLOCATABLE  :: Input_Saved      !< Backup Array of inputs associated with InputTimes [-]
    REAL(DbKi) , DIMENSION(:,:), ALLOCATABLE  :: InputTimes      !< Array of times associated with Input Array [-]
    REAL(DbKi) , DIMENSION(:,:), ALLOCATABLE  :: InputTimes_Saved      !< Backup Array of times associated with Input Array [-]
  END TYPE BeamDyn_Data
! =======================
! =========  ElastoDyn_Data  =======
  TYPE, PUBLIC :: ElastoDyn_Data
    TYPE(ED_ContinuousStateType) , DIMENSION(1:NumStateTimes)  :: x      !< Continuous states [-]
    TYPE(ED_DiscreteStateType) , DIMENSION(1:NumStateTimes)  :: xd      !< Discrete states [-]
    TYPE(ED_ConstraintStateType) , DIMENSION(1:NumStateTimes)  :: z      !< Constraint states [-]
    TYPE(ED_OtherStateType) , DIMENSION(1:NumStateTimes)  :: OtherSt      !< Other states [-]
    TYPE(ED_ParameterType)  :: p      !< Parameters [-]
    TYPE(ED_InputType)  :: u      !< System inputs [-]
    TYPE(ED_OutputType)  :: y      !< System outputs [-]
    TYPE(ED_MiscVarType)  :: m      !< Misc (optimization) variables not associated with time [-]
    TYPE(ED_OutputType) , DIMENSION(:), ALLOCATABLE  :: Output      !< Array of outputs associated with CalcSteady Azimuths [-]
    TYPE(ED_OutputType) , DIMENSION(:), ALLOCATABLE  :: Output_bak      !< Backup Array of outputs associated with InputTimes [-]
    TYPE(ED_OutputType)  :: y_interp      !< interpolated system outputs for CalcSteady [-]
    TYPE(ED_InputType) , DIMENSION(:), ALLOCATABLE  :: Input      !< Array of inputs associated with InputTimes [-]
    TYPE(ED_InputType) , DIMENSION(:), ALLOCATABLE  :: Input_Saved      !< Backup Array of inputs associated with InputTimes [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: InputTimes      !< Array of times associated with Input Array [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: InputTimes_Saved      !< Backup Array of times associated with Input Array [-]
  END TYPE ElastoDyn_Data
! =======================
! =========  SED_Data  =======
  TYPE, PUBLIC :: SED_Data
    TYPE(SED_ContinuousStateType) , DIMENSION(1:2)  :: x      !< Continuous states [-]
    TYPE(SED_DiscreteStateType) , DIMENSION(1:2)  :: xd      !< Discrete states [-]
    TYPE(SED_ConstraintStateType) , DIMENSION(1:2)  :: z      !< Constraint states [-]
    TYPE(SED_OtherStateType) , DIMENSION(1:2)  :: OtherSt      !< Other states [-]
    TYPE(SED_ParameterType)  :: p      !< Parameters [-]
    TYPE(SED_InputType)  :: u      !< System inputs [-]
    TYPE(SED_OutputType)  :: y      !< System outputs [-]
    TYPE(SED_MiscVarType)  :: m      !< Misc (optimization) variables not associated with time [-]
    TYPE(SED_OutputType) , DIMENSION(:), ALLOCATABLE  :: Output      !< Array of outputs associated with CalcSteady Azimuths [-]
    TYPE(SED_OutputType)  :: y_interp      !< interpolated system outputs for CalcSteady [-]
    TYPE(SED_InputType) , DIMENSION(:), ALLOCATABLE  :: Input      !< Array of inputs associated with InputTimes [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: InputTimes      !< Array of times associated with Input Array [-]
  END TYPE SED_Data
! =======================
! =========  ServoDyn_Data  =======
  TYPE, PUBLIC :: ServoDyn_Data
    TYPE(SrvD_ContinuousStateType) , DIMENSION(1:NumStateTimes)  :: x      !< Continuous states [-]
    TYPE(SrvD_DiscreteStateType) , DIMENSION(1:NumStateTimes)  :: xd      !< Discrete states [-]
    TYPE(SrvD_ConstraintStateType) , DIMENSION(1:NumStateTimes)  :: z      !< Constraint states [-]
    TYPE(SrvD_OtherStateType) , DIMENSION(1:NumStateTimes)  :: OtherSt      !< Other states [-]
    TYPE(SrvD_ParameterType)  :: p      !< Parameters [-]
    TYPE(SrvD_InputType)  :: u      !< System inputs [-]
    TYPE(SrvD_OutputType)  :: y      !< System outputs [-]
    TYPE(SrvD_MiscVarType)  :: m      !< Misc (optimization) variables not associated with time [-]
    TYPE(SrvD_MiscVarType)  :: m_bak      !< Backup Misc (optimization) variables not associated with time [-]
    TYPE(SrvD_OutputType) , DIMENSION(:), ALLOCATABLE  :: Output      !< Array of outputs associated with CalcSteady Azimuths [-]
    TYPE(SrvD_OutputType)  :: y_interp      !< interpolated system outputs for CalcSteady [-]
    TYPE(SrvD_InputType) , DIMENSION(:), ALLOCATABLE  :: Input      !< Array of inputs associated with InputTimes [-]
    TYPE(SrvD_InputType) , DIMENSION(:), ALLOCATABLE  :: Input_Saved      !< Backup Array of inputs associated with InputTimes [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: InputTimes      !< Array of times associated with Input Array [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: InputTimes_Saved      !< Backup Array of times associated with Input Array [-]
  END TYPE ServoDyn_Data
! =======================
! =========  AeroDyn_Data  =======
  TYPE, PUBLIC :: AeroDyn_Data
    TYPE(AD_ContinuousStateType) , DIMENSION(1:NumStateTimes)  :: x      !< Continuous states [-]
    TYPE(AD_DiscreteStateType) , DIMENSION(1:NumStateTimes)  :: xd      !< Discrete states [-]
    TYPE(AD_ConstraintStateType) , DIMENSION(1:NumStateTimes)  :: z      !< Constraint states [-]
    TYPE(AD_OtherStateType) , DIMENSION(1:NumStateTimes)  :: OtherSt      !< Other states [-]
    TYPE(AD_ParameterType)  :: p      !< Parameters [-]
    TYPE(AD_InputType)  :: u      !< System inputs [-]
    TYPE(AD_OutputType)  :: y      !< System outputs [-]
    TYPE(AD_MiscVarType)  :: m      !< Misc/optimization variables [-]
    TYPE(AD_OutputType) , DIMENSION(:), ALLOCATABLE  :: Output      !< Array of outputs associated with CalcSteady Azimuths [-]
    TYPE(AD_OutputType)  :: y_interp      !< interpolated system outputs for CalcSteady [-]
    TYPE(AD_InputType) , DIMENSION(:), ALLOCATABLE  :: Input      !< Array of inputs associated with InputTimes [-]
    TYPE(AD_InputType) , DIMENSION(:), ALLOCATABLE  :: Input_Saved      !< Backup Array of inputs associated with InputTimes [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: InputTimes      !< Array of times associated with Input Array [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: InputTimes_Saved      !< Backup Array of times associated with Input Array [-]
  END TYPE AeroDyn_Data
! =======================
! =========  ExtLoads_Data  =======
  TYPE, PUBLIC :: ExtLoads_Data
    TYPE(ExtLd_ContinuousStateType) , DIMENSION(1:NumStateTimes)  :: x      !< Continuous states [-]
    TYPE(ExtLd_DiscreteStateType) , DIMENSION(1:NumStateTimes)  :: xd      !< Discrete states [-]
    TYPE(ExtLd_ConstraintStateType) , DIMENSION(1:NumStateTimes)  :: z      !< Constraint states [-]
    TYPE(ExtLd_OtherStateType) , DIMENSION(1:NumStateTimes)  :: OtherSt      !< Other states [-]
    TYPE(ExtLd_ParameterType)  :: p      !< Parameters [-]
    TYPE(ExtLd_InputType)  :: u      !< System inputs [-]
    TYPE(ExtLd_OutputType)  :: y      !< System outputs [-]
    TYPE(ExtLd_MiscVarType)  :: m      !< Misc/optimization variables [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: InputTimes      !< Array of times associated with Input Array [-]
  END TYPE ExtLoads_Data
! =======================
! =========  AeroDisk_Data  =======
  TYPE, PUBLIC :: AeroDisk_Data
    TYPE(ADsk_ContinuousStateType) , DIMENSION(1:2)  :: x      !< Continuous states [-]
    TYPE(ADsk_DiscreteStateType) , DIMENSION(1:2)  :: xd      !< Discrete states [-]
    TYPE(ADsk_ConstraintStateType) , DIMENSION(1:2)  :: z      !< Constraint states [-]
    TYPE(ADsk_OtherStateType) , DIMENSION(1:2)  :: OtherSt      !< Other states [-]
    TYPE(ADsk_ParameterType)  :: p      !< Parameters [-]
    TYPE(ADsk_InputType)  :: u      !< System inputs [-]
    TYPE(ADsk_OutputType)  :: y      !< System outputs [-]
    TYPE(ADsk_MiscVarType)  :: m      !< Misc/optimization variables [-]
    TYPE(ADsk_OutputType) , DIMENSION(:), ALLOCATABLE  :: Output      !< Array of outputs associated with CalcSteady Azimuths [-]
    TYPE(ADsk_OutputType)  :: y_interp      !< interpolated system outputs for CalcSteady [-]
    TYPE(ADsk_InputType) , DIMENSION(:), ALLOCATABLE  :: Input      !< Array of inputs associated with InputTimes [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: InputTimes      !< Array of times associated with Input Array [-]
  END TYPE AeroDisk_Data
! =======================
! =========  InflowWind_Data  =======
  TYPE, PUBLIC :: InflowWind_Data
    TYPE(InflowWind_ContinuousStateType) , DIMENSION(1:NumStateTimes)  :: x      !< Continuous states [-]
    TYPE(InflowWind_DiscreteStateType) , DIMENSION(1:NumStateTimes)  :: xd      !< Discrete states [-]
    TYPE(InflowWind_ConstraintStateType) , DIMENSION(1:NumStateTimes)  :: z      !< Constraint states [-]
    TYPE(InflowWind_OtherStateType) , DIMENSION(1:NumStateTimes)  :: OtherSt      !< Other states [-]
    TYPE(InflowWind_ParameterType)  :: p      !< Parameters [-]
    TYPE(InflowWind_InputType)  :: u      !< System inputs [-]
    TYPE(InflowWind_OutputType)  :: y      !< System outputs [-]
    TYPE(InflowWind_MiscVarType)  :: m      !< Misc/optimization variables [-]
    TYPE(InflowWind_OutputType) , DIMENSION(:), ALLOCATABLE  :: Output      !< Array of outputs associated with CalcSteady Azimuths [-]
    TYPE(InflowWind_OutputType)  :: y_interp      !< interpolated system outputs for CalcSteady [-]
    TYPE(InflowWind_InputType) , DIMENSION(:), ALLOCATABLE  :: Input      !< Array of inputs associated with InputTimes [-]
    TYPE(InflowWind_InputType) , DIMENSION(:), ALLOCATABLE  :: Input_Saved      !< Backup Array of inputs associated with InputTimes [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: InputTimes      !< Array of times associated with Input Array [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: InputTimes_Saved      !< Backup Array of times associated with Input Array [-]
  END TYPE InflowWind_Data
! =======================
! =========  ExternalInflow_Data  =======
  TYPE, PUBLIC :: ExternalInflow_Data
    TYPE(ExtInfw_InputType)  :: u      !< System inputs [-]
    TYPE(ExtInfw_OutputType)  :: y      !< System outputs [-]
    TYPE(ExtInfw_ParameterType)  :: p      !< Parameters [-]
    TYPE(ExtInfw_MiscVarType)  :: m      !< Parameters [-]
  END TYPE ExternalInflow_Data
! =======================
! =========  SubDyn_Data  =======
  TYPE, PUBLIC :: SubDyn_Data
    TYPE(SD_ContinuousStateType) , DIMENSION(1:NumStateTimes)  :: x      !< Continuous states [-]
    TYPE(SD_DiscreteStateType) , DIMENSION(1:NumStateTimes)  :: xd      !< Discrete states [-]
    TYPE(SD_ConstraintStateType) , DIMENSION(1:NumStateTimes)  :: z      !< Constraint states [-]
    TYPE(SD_OtherStateType) , DIMENSION(1:NumStateTimes)  :: OtherSt      !< Other states [-]
    TYPE(SD_ParameterType)  :: p      !< Parameters [-]
    TYPE(SD_InputType)  :: u      !< System inputs [-]
    TYPE(SD_OutputType)  :: y      !< System outputs [-]
    TYPE(SD_MiscVarType)  :: m      !< Misc/optimization variables [-]
    TYPE(SD_InputType) , DIMENSION(:), ALLOCATABLE  :: Input      !< Array of inputs associated with InputTimes [-]
    TYPE(SD_InputType) , DIMENSION(:), ALLOCATABLE  :: Input_Saved      !< Backup Array of inputs associated with InputTimes [-]
    TYPE(SD_OutputType) , DIMENSION(:), ALLOCATABLE  :: Output      !< Array of outputs associated with CalcSteady Azimuths [-]
    TYPE(SD_OutputType)  :: y_interp      !< interpolated system outputs for CalcSteady [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: InputTimes      !< Array of times associated with Input Array [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: InputTimes_Saved      !< Backup Array of times associated with Input Array [-]
  END TYPE SubDyn_Data
! =======================
! =========  ExtPtfm_Data  =======
  TYPE, PUBLIC :: ExtPtfm_Data
    TYPE(ExtPtfm_ContinuousStateType) , DIMENSION(1:NumStateTimes)  :: x      !< Continuous states [-]
    TYPE(ExtPtfm_DiscreteStateType) , DIMENSION(1:NumStateTimes)  :: xd      !< Discrete states [-]
    TYPE(ExtPtfm_ConstraintStateType) , DIMENSION(1:NumStateTimes)  :: z      !< Constraint states [-]
    TYPE(ExtPtfm_OtherStateType) , DIMENSION(1:NumStateTimes)  :: OtherSt      !< Other states [-]
    TYPE(ExtPtfm_ParameterType)  :: p      !< Parameters [-]
    TYPE(ExtPtfm_InputType)  :: u      !< System inputs [-]
    TYPE(ExtPtfm_OutputType)  :: y      !< System outputs [-]
    TYPE(ExtPtfm_MiscVarType)  :: m      !< Misc/optimization variables [-]
    TYPE(ExtPtfm_InputType) , DIMENSION(:), ALLOCATABLE  :: Input      !< Array of inputs associated with InputTimes [-]
    TYPE(ExtPtfm_InputType) , DIMENSION(:), ALLOCATABLE  :: Input_Saved      !< Backup Array of inputs associated with InputTimes [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: InputTimes      !< Array of times associated with Input Array [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: InputTimes_Saved      !< Backup Array of times associated with Input Array [-]
  END TYPE ExtPtfm_Data
! =======================
! =========  SeaState_Data  =======
  TYPE, PUBLIC :: SeaState_Data
    TYPE(SeaSt_ContinuousStateType) , DIMENSION(1:NumStateTimes)  :: x      !< Continuous states [-]
    TYPE(SeaSt_DiscreteStateType) , DIMENSION(1:NumStateTimes)  :: xd      !< Discrete states [-]
    TYPE(SeaSt_ConstraintStateType) , DIMENSION(1:NumStateTimes)  :: z      !< Constraint states [-]
    TYPE(SeaSt_OtherStateType) , DIMENSION(1:NumStateTimes)  :: OtherSt      !< Other states [-]
    TYPE(SeaSt_ParameterType)  :: p      !< Parameters [-]
    TYPE(SeaSt_InputType)  :: u      !< System inputs [-]
    TYPE(SeaSt_OutputType)  :: y      !< System outputs [-]
    TYPE(SeaSt_MiscVarType)  :: m      !< Misc/optimization variables [-]
    TYPE(SeaSt_InputType) , DIMENSION(:), ALLOCATABLE  :: Input      !< Array of inputs associated with InputTimes [-]
    TYPE(SeaSt_InputType) , DIMENSION(:), ALLOCATABLE  :: Input_Saved      !< Backup Array of inputs associated with InputTimes [-]
    TYPE(SeaSt_OutputType) , DIMENSION(:), ALLOCATABLE  :: Output      !< Array of outputs associated with CalcSteady Azimuths [-]
    TYPE(SeaSt_OutputType)  :: y_interp      !< interpolated system outputs for CalcSteady [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: InputTimes      !< Array of times associated with Input Array [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: InputTimes_Saved      !< Backup Array of times associated with Input Array [-]
  END TYPE SeaState_Data
! =======================
! =========  HydroDyn_Data  =======
  TYPE, PUBLIC :: HydroDyn_Data
    TYPE(HydroDyn_ContinuousStateType) , DIMENSION(1:NumStateTimes)  :: x      !< Continuous states [-]
    TYPE(HydroDyn_DiscreteStateType) , DIMENSION(1:NumStateTimes)  :: xd      !< Discrete states [-]
    TYPE(HydroDyn_ConstraintStateType) , DIMENSION(1:NumStateTimes)  :: z      !< Constraint states [-]
    TYPE(HydroDyn_OtherStateType) , DIMENSION(1:NumStateTimes)  :: OtherSt      !< Other states [-]
    TYPE(HydroDyn_ParameterType)  :: p      !< Parameters [-]
    TYPE(HydroDyn_InputType)  :: u      !< System inputs [-]
    TYPE(HydroDyn_OutputType)  :: y      !< System outputs [-]
    TYPE(HydroDyn_MiscVarType)  :: m      !< Misc/optimization variables [-]
    TYPE(HydroDyn_OutputType) , DIMENSION(:), ALLOCATABLE  :: Output      !< Array of outputs associated with CalcSteady Azimuths [-]
    TYPE(HydroDyn_OutputType)  :: y_interp      !< interpolated system outputs for CalcSteady [-]
    TYPE(HydroDyn_InputType) , DIMENSION(:), ALLOCATABLE  :: Input      !< Array of inputs associated with InputTimes [-]
    TYPE(HydroDyn_InputType) , DIMENSION(:), ALLOCATABLE  :: Input_Saved      !< Backup Array of inputs associated with InputTimes [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: InputTimes      !< Array of times associated with Input Array [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: InputTimes_Saved      !< Backup Array of times associated with Input Array [-]
  END TYPE HydroDyn_Data
! =======================
! =========  IceFloe_Data  =======
  TYPE, PUBLIC :: IceFloe_Data
    TYPE(IceFloe_ContinuousStateType) , DIMENSION(1:NumStateTimes)  :: x      !< Continuous states [-]
    TYPE(IceFloe_DiscreteStateType) , DIMENSION(1:NumStateTimes)  :: xd      !< Discrete states [-]
    TYPE(IceFloe_ConstraintStateType) , DIMENSION(1:NumStateTimes)  :: z      !< Constraint states [-]
    TYPE(IceFloe_OtherStateType) , DIMENSION(1:NumStateTimes)  :: OtherSt      !< Other states [-]
    TYPE(IceFloe_ParameterType)  :: p      !< Parameters [-]
    TYPE(IceFloe_InputType)  :: u      !< System inputs [-]
    TYPE(IceFloe_OutputType)  :: y      !< System outputs [-]
    TYPE(IceFloe_MiscVarType)  :: m      !< Misc/optimization variables [-]
    TYPE(IceFloe_InputType) , DIMENSION(:), ALLOCATABLE  :: Input      !< Array of inputs associated with InputTimes [-]
    TYPE(IceFloe_InputType) , DIMENSION(:), ALLOCATABLE  :: Input_Saved      !< Backup Array of inputs associated with InputTimes [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: InputTimes      !< Array of times associated with Input Array [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: InputTimes_Saved      !< Backup Array of times associated with Input Array [-]
  END TYPE IceFloe_Data
! =======================
! =========  MAP_Data  =======
  TYPE, PUBLIC :: MAP_Data
    TYPE(MAP_ContinuousStateType) , DIMENSION(1:NumStateTimes)  :: x      !< Continuous states [-]
    TYPE(MAP_DiscreteStateType) , DIMENSION(1:NumStateTimes)  :: xd      !< Discrete states [-]
    TYPE(MAP_ConstraintStateType) , DIMENSION(1:NumStateTimes)  :: z      !< Constraint states [-]
    TYPE(MAP_OtherStateType)  :: OtherSt      !< Other/optimization states [-]
    TYPE(MAP_ParameterType)  :: p      !< Parameters [-]
    TYPE(MAP_InputType)  :: u      !< System inputs [-]
    TYPE(MAP_OutputType)  :: y      !< System outputs [-]
    TYPE(MAP_OtherStateType)  :: OtherSt_old      !< Other/optimization states (copied for the case of subcycling) [-]
    TYPE(MAP_OutputType) , DIMENSION(:), ALLOCATABLE  :: Output      !< Array of outputs associated with CalcSteady Azimuths [-]
    TYPE(MAP_OutputType)  :: y_interp      !< interpolated system outputs for CalcSteady [-]
    TYPE(MAP_InputType) , DIMENSION(:), ALLOCATABLE  :: Input      !< Array of inputs associated with InputTimes [-]
    TYPE(MAP_InputType) , DIMENSION(:), ALLOCATABLE  :: Input_Saved      !< Backup Array of inputs associated with InputTimes [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: InputTimes      !< Array of times associated with Input Array [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: InputTimes_Saved      !< Backup Array of times associated with Input Array [-]
  END TYPE MAP_Data
! =======================
! =========  FEAMooring_Data  =======
  TYPE, PUBLIC :: FEAMooring_Data
    TYPE(FEAM_ContinuousStateType) , DIMENSION(1:NumStateTimes)  :: x      !< Continuous states [-]
    TYPE(FEAM_DiscreteStateType) , DIMENSION(1:NumStateTimes)  :: xd      !< Discrete states [-]
    TYPE(FEAM_ConstraintStateType) , DIMENSION(1:NumStateTimes)  :: z      !< Constraint states [-]
    TYPE(FEAM_OtherStateType) , DIMENSION(1:NumStateTimes)  :: OtherSt      !< Other states [-]
    TYPE(FEAM_ParameterType)  :: p      !< Parameters [-]
    TYPE(FEAM_InputType)  :: u      !< System inputs [-]
    TYPE(FEAM_OutputType)  :: y      !< System outputs [-]
    TYPE(FEAM_MiscVarType)  :: m      !< Misc/optimization variables [-]
    TYPE(FEAM_InputType) , DIMENSION(:), ALLOCATABLE  :: Input      !< Array of inputs associated with InputTimes [-]
    TYPE(FEAM_InputType) , DIMENSION(:), ALLOCATABLE  :: Input_Saved      !< Backup Array of inputs associated with InputTimes [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: InputTimes      !< Array of times associated with Input Array [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: InputTimes_Saved      !< Backup Array of times associated with Input Array [-]
  END TYPE FEAMooring_Data
! =======================
! =========  MoorDyn_Data  =======
  TYPE, PUBLIC :: MoorDyn_Data
    TYPE(MD_ContinuousStateType) , DIMENSION(1:NumStateTimes)  :: x      !< Continuous states [-]
    TYPE(MD_DiscreteStateType) , DIMENSION(1:NumStateTimes)  :: xd      !< Discrete states [-]
    TYPE(MD_ConstraintStateType) , DIMENSION(1:NumStateTimes)  :: z      !< Constraint states [-]
    TYPE(MD_OtherStateType) , DIMENSION(1:NumStateTimes)  :: OtherSt      !< Other states [-]
    TYPE(MD_ParameterType)  :: p      !< Parameters [-]
    TYPE(MD_InputType)  :: u      !< System inputs [-]
    TYPE(MD_OutputType)  :: y      !< System outputs [-]
    TYPE(MD_MiscVarType)  :: m      !< Misc/optimization variables [-]
    TYPE(MD_OutputType) , DIMENSION(:), ALLOCATABLE  :: Output      !< Array of outputs associated with CalcSteady Azimuths [-]
    TYPE(MD_OutputType)  :: y_interp      !< interpolated system outputs for CalcSteady [-]
    TYPE(MD_InputType) , DIMENSION(:), ALLOCATABLE  :: Input      !< Array of inputs associated with InputTimes [-]
    TYPE(MD_InputType) , DIMENSION(:), ALLOCATABLE  :: Input_Saved      !< Backup Array of inputs associated with InputTimes [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: InputTimes      !< Array of times associated with Input Array [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: InputTimes_Saved      !< Backup Array of times associated with Input Array [-]
  END TYPE MoorDyn_Data
! =======================
! =========  OrcaFlex_Data  =======
  TYPE, PUBLIC :: OrcaFlex_Data
    TYPE(Orca_ContinuousStateType) , DIMENSION(1:NumStateTimes)  :: x      !< Continuous states [-]
    TYPE(Orca_DiscreteStateType) , DIMENSION(1:NumStateTimes)  :: xd      !< Discrete states [-]
    TYPE(Orca_ConstraintStateType) , DIMENSION(1:NumStateTimes)  :: z      !< Constraint states [-]
    TYPE(Orca_OtherStateType) , DIMENSION(1:NumStateTimes)  :: OtherSt      !< Other states [-]
    TYPE(Orca_ParameterType)  :: p      !< Parameters [-]
    TYPE(Orca_InputType)  :: u      !< System inputs [-]
    TYPE(Orca_OutputType)  :: y      !< System outputs [-]
    TYPE(Orca_MiscVarType)  :: m      !< Misc/optimization variables [-]
    TYPE(Orca_InputType) , DIMENSION(:), ALLOCATABLE  :: Input      !< Array of inputs associated with InputTimes [-]
    TYPE(Orca_InputType) , DIMENSION(:), ALLOCATABLE  :: Input_Saved      !< Backup Array of inputs associated with InputTimes [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: InputTimes      !< Array of times associated with Input Array [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: InputTimes_Saved      !< Backup Array of times associated with Input Array [-]
  END TYPE OrcaFlex_Data
! =======================
! =========  FAST_ModuleMapType  =======
  TYPE, PUBLIC :: FAST_ModuleMapType
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: ED_P_2_BD_P      !< Map ElastoDyn BladeRootMotion meshes to BeamDyn RootMotion point meshes [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: BD_P_2_ED_P      !< Map BeamDyn ReactionForce loads point meshes to ElastoDyn HubPtLoad point mesh [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: ED_P_2_BD_P_Hub      !< ElastoDyn hub to BeamDyn for hub orientation necessary for pitch actuator [-]
    TYPE(MeshMapType)  :: ED_P_2_HD_PRP_P      !< Map ElastoDyn PlatformPtMesh to HydroDyn platform reference Point [-]
    TYPE(MeshMapType)  :: SubStructure_2_HD_W_P      !< Map ElastoDyn PlatformPtMesh or SubDyn y2Mesh to HydroDyn WAMIT Point [-]
    TYPE(MeshMapType)  :: HD_W_P_2_SubStructure      !< Map HydroDyn WAMIT Point from y%WAMITMesh to ElastoDyn PlatformPtMesh or SD LMesh [-]
    TYPE(MeshMapType)  :: SubStructure_2_HD_M_P      !< Map ElastoDyn PlatformPtMesh or SubDyn y2Mesh to HydroDyn Morison Point [-]
    TYPE(MeshMapType)  :: HD_M_P_2_SubStructure      !< Map HydroDyn Morison Point to ElastoDyn PlatformPtMesh or SD LMesh [-]
    TYPE(MeshMapType)  :: Structure_2_Mooring      !< Map structural SD (y3Mesh)/ED to MAP/FEAM/MoorDyn/OrcaFlex point mesh [Motions]
    TYPE(MeshMapType)  :: Mooring_2_Structure      !< Map FEAM/MAP/MoorDyn/OrcaFlex mesh to SD (LMesh)/ED (PlatformPtMesh)/ExtPtfm mesh [Loads]
    TYPE(MeshMapType)  :: ED_P_2_SD_TP      !< Map ElastoDyn PlatformPtMesh to SubDyn transition-piece point mesh [-]
    TYPE(MeshMapType)  :: SD_TP_2_ED_P      !< Map SubDyn transition-piece point mesh to ElastoDyn PlatformPtMesh [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: ED_P_2_NStC_P_N      !< Map ElastoDyn      nacelle point mesh to ServoDyn/NStC point mesh [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: NStC_P_2_ED_P_N      !< Map ServoDyn/NStC  nacelle point mesh to ElastoDyn     point mesh on the nacelle [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: ED_L_2_TStC_P_T      !< Map ElastoDyn      tower   line2 mesh to ServoDyn/TStC point mesh [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: TStC_P_2_ED_P_T      !< Map ServoDyn/TStC  tower   point mesh to ElastoDyn     point load mesh on the tower [-]
    TYPE(MeshMapType) , DIMENSION(:,:), ALLOCATABLE  :: ED_L_2_BStC_P_B      !< Map ElastoDyn blade line2 mesh to ServoDyn/BStC point mesh [-]
    TYPE(MeshMapType) , DIMENSION(:,:), ALLOCATABLE  :: BStC_P_2_ED_P_B      !< Map ServoDyn/BStC point mesh to ElastoDyn point load mesh on the blade [-]
    TYPE(MeshMapType) , DIMENSION(:,:), ALLOCATABLE  :: BD_L_2_BStC_P_B      !< Map BeamDyn blade line2 mesh to ServoDyn/BStC point mesh [-]
    TYPE(MeshMapType) , DIMENSION(:,:), ALLOCATABLE  :: BStC_P_2_BD_P_B      !< Map ServoDyn/BStC point mesh to BeamDyn distributed load mesh on the blade [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: SStC_P_P_2_SubStructure      !< Map ServoDyn/SStC platform point mesh load   to SubDyn/ElastoDyn  point load mesh [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: SubStructure_2_SStC_P_P      !< Map SubDyn y3mesh or ED platform mesh motion to ServoDyn/SStC point mesh [-]
    TYPE(MeshMapType)  :: ED_P_2_SrvD_P_P      !< Map ElastoDyn/Simplified-ElastoDyn platform point mesh motion to ServoDyn      point mesh -- for passing to controller [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: BDED_L_2_AD_L_B      !< Map ElastoDyn BladeLn2Mesh point meshes OR BeamDyn BldMotion line2 meshes to AeroDyn14 InputMarkers OR AeroDyn BladeMotion line2 meshes [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: AD_L_2_BDED_B      !< Map AeroDyn14 InputMarkers or AeroDyn BladeLoad line2 meshes to ElastoDyn BladePtLoad point meshes or BeamDyn BldMotion line2 meshes [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: BD_L_2_BD_L      !< Map BeamDyn BldMotion output meshes to locations on the BD input DistrLoad mesh stored in MeshMapType%y_BD_BldMotion_4Loads (BD input and output meshes are not siblings and in fact have nodes at different locations [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: SED_P_2_AD_L_B      !< Map Simplified-ElastoDyn BladeRoot point meshes to rigid AeroDyn BladeMotion line2 meshes [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: SED_P_2_AD_P_R      !< Map Simplified-ElastoDyn BladeRootMotion point meshes to AeroDyn BladeRootMotion point meshes [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: AD_L_2_SED_P      !< Map AeroDyn blade load output mesh to Simplified-ElastoDyn Hub point mesh [-]
    TYPE(MeshMapType)  :: ED_P_2_AD_P_N      !< Map ElastoDyn Nacelle point motion mesh to AeroDyn Nacelle point motion mesh [-]
    TYPE(MeshMapType)  :: AD_P_2_ED_P_N      !< Map AeroDyn Nacelle point load mesh to ElastoDyn nacelle point load mesh [-]
    TYPE(MeshMapType)  :: ED_P_2_AD_P_TF      !< Map ElastoDyn TailFin CM point motion mesh to AeroDyn TailFin ref point motion mesh [-]
    TYPE(MeshMapType)  :: AD_P_2_ED_P_TF      !< Map AeroDyn TailFin ref point load mesh to ElastoDyn TailFin CM point load mesh [-]
    TYPE(MeshMapType)  :: ED_L_2_AD_L_T      !< Map ElastoDyn TowerLn2Mesh line2 mesh to AeroDyn14 Twr_InputMarkers or AeroDyn TowerMotion line2 mesh [-]
    TYPE(MeshMapType)  :: AD_L_2_ED_P_T      !< Map AeroDyn14 Twr_InputMarkers or AeroDyn TowerLoad line2 mesh to ElastoDyn TowerPtLoads point mesh [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: ED_P_2_AD_P_R      !< Map ElastoDyn BladeRootMotion point meshes to AeroDyn BladeRootMotion point meshes [-]
    TYPE(MeshMapType)  :: ED_P_2_AD_P_H      !< Map ElastoDyn HubPtMotion point mesh to AeroDyn HubMotion point mesh [-]
    TYPE(MeshMapType)  :: ADsk_P_2_ED_P_H      !< Map AeroDisk point load mesh to ElastoDyn hub point load mesh [-]
    TYPE(MeshMapType)  :: ED_P_2_ADsk_P_H      !< Map ElastoDyn HubPtMotion point mesh to AeroDisk HubMotion point mesh [-]
    TYPE(MeshMapType)  :: SED_P_2_AD_P_N      !< Map Simplified-ElastoDyn Nacelle point motion mesh to AeroDyn Nacelle point motion mesh [-]
    TYPE(MeshMapType)  :: SED_L_2_AD_L_T      !< Map Simplified-ElastoDyn TowerLn2Mesh line2 mesh to AeroDyn TowerMotion line2 mesh [-]
    TYPE(MeshMapType)  :: SED_P_2_AD_P_H      !< Map Simplified-ElastoDyn HubPtMotion point mesh to AeroDyn HubMotion point mesh [-]
    TYPE(MeshMapType)  :: ADsk_P_2_SED_P_H      !< Map AeroDisk point load mesh to Simplfied-ElastoDyn hub point load mesh [-]
    TYPE(MeshMapType)  :: SED_P_2_ADsk_P_H      !< Map Simplified-ElastoDyn HubPtMotion point mesh to AeroDisk HubMotion point mesh [-]
    TYPE(MeshMapType)  :: AD_P_2_ED_P_H      !< Map AeroDyn HubLoad point mesh to ElastoDyn HubPtLoad point mesh [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: BDED_L_2_ExtLd_P_B      !< Map ElastoDyn/BeamDyn BladeLn2Mesh point meshes OR BeamDyn BldMotion line2 meshes to ExtLoads point meshes [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: ExtLd_P_2_BDED_B      !< Map ExtLoads at points to ElastoDyn BladePtLoad point meshes or BeamDyn BldMotion line2 meshes [-]
    TYPE(MeshMapType)  :: ED_L_2_ExtLd_P_T      !< Map ElastoDyn TowerLn2Mesh line2 mesh to ExtLoads point mesh [-]
    TYPE(MeshMapType)  :: ExtLd_P_2_ED_P_T      !< Map ExtLoads TowerLoad point mesh to ElastoDyn TowerPtLoads point mesh [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: ED_P_2_ExtLd_P_R      !< Map ElastoDyn BladeRootMotion point meshes to ExtLoads BladeRootMotion point meshes [-]
    TYPE(MeshMapType)  :: ED_P_2_ExtLd_P_H      !< Map ElastoDyn HubPtMotion point mesh to ExtLoads HubMotion point mesh [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: AD_L_2_ExtLd_B      !< Map AeroDyn line loads on blades to ExtLoads point loads [-]
    TYPE(MeshMapType)  :: AD_L_2_ExtLd_T      !< Map AeroDyn line loads on tower to ExtKoads point loads [-]
    TYPE(MeshMapType)  :: IceF_P_2_SD_P      !< Map IceFloe point mesh to SubDyn LMesh point mesh [-]
    TYPE(MeshMapType)  :: SDy3_P_2_IceF_P      !< Map SubDyn y3Mesh point mesh to IceFloe point mesh [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: IceD_P_2_SD_P      !< Map IceDyn point mesh to SubDyn LMesh point mesh [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: SDy3_P_2_IceD_P      !< Map SubDyn y3Mesh point mesh to IceDyn point mesh [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Jacobian_Opt1      !< Stored Jacobian in ED_HD_InputOutputSolve or FullOpt1_InputOutputSolve [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: Jacobian_pivot      !< Pivot array used for LU decomposition of Jacobian_Opt1 [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: Jac_u_indx      !< matrix to help fill/pack the u vector in computing the jacobian [-]
    TYPE(MeshType)  :: u_ED_NacelleLoads      !< copy of ED input mesh [-]
    TYPE(MeshType)  :: SubstructureLoads_Tmp      !< copy of substructure loads input mesh (ED or SD) [-]
    TYPE(MeshType)  :: SubstructureLoads_Tmp2      !< copy of substructure loads input mesh (ED or SD, used only for temporary storage) [-]
    TYPE(MeshType)  :: PlatformLoads_Tmp      !< copy of platform loads input mesh (ED) [-]
    TYPE(MeshType)  :: PlatformLoads_Tmp2      !< copy of platform loads input mesh (ED, used only for temporary storage) [-]
    TYPE(MeshType)  :: SubstructureLoads_Tmp_Farm      !< copy of substructure mesh used to store loads from farm-level MD [-]
    TYPE(MeshType)  :: u_ED_TowerPtloads      !< copy of ED input mesh [-]
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: u_ED_BladePtLoads      !< copy of ED input mesh [-]
    TYPE(MeshType)  :: u_SD_TPMesh      !< copy of SD input mesh [-]
    TYPE(MeshType)  :: u_HD_M_Mesh      !< copy of HD morison input mesh [-]
    TYPE(MeshType)  :: u_HD_W_Mesh      !< copy of HD wamit input mesh [-]
    TYPE(MeshType)  :: u_ED_HubPtLoad      !< copy of  ED input mesh [-]
    TYPE(MeshType)  :: u_ED_HubPtLoad_2      !< copy of  ED input mesh [-]
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: u_BD_RootMotion      !< copy of  BD input meshes [-]
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: y_BD_BldMotion_4Loads      !< BD blade motion output at locations on DistrLoad input meshes [-]
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: u_BD_Distrload      !< copy of BD DistrLoad input meshes [-]
    TYPE(MeshType)  :: u_Orca_PtfmMesh      !< copy of Orca PtfmMesh input mesh [-]
    TYPE(MeshType)  :: u_ExtPtfm_PtfmMesh      !< copy of ExtPtfm_MCKF PtfmMesh input mesh [-]
    TYPE(MeshType)  :: u_SED_HubPtLoad      !< copy of  SED input mesh [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: HubOrient      !< Orientation matrix to translate results from blade 1 to remaining blades in aeromaps [(-)]
  END TYPE FAST_ModuleMapType
! =======================
! =========  FAST_ExternInputType  =======
  TYPE, PUBLIC :: FAST_ExternInputType
    REAL(ReKi)  :: GenTrq = 0.0_ReKi      !< generator torque input from Simulink/Labview [-]
    REAL(ReKi)  :: ElecPwr = 0.0_ReKi      !< electric power input from Simulink/Labview [-]
    REAL(ReKi)  :: YawPosCom = 0.0_ReKi      !< yaw position command from Simulink/Labview [-]
    REAL(ReKi)  :: YawRateCom = 0.0_ReKi      !< yaw rate command from Simulink/Labview [-]
    REAL(ReKi) , DIMENSION(1:3)  :: BlPitchCom = 0.0_ReKi      !< blade pitch commands from Simulink/Labview [rad]
    REAL(ReKi) , DIMENSION(1:3)  :: BlAirfoilCom = 0.0_ReKi      !< blade airfoil commands from Simulink/Labview [-]
    REAL(ReKi)  :: HSSBrFrac = 0.0_ReKi      !< Fraction of full braking torque: 0 (off) <= HSSBrFrac <= 1 (full) from Simulink or LabVIEW [-]
    REAL(ReKi) , DIMENSION(1:20)  :: CableDeltaL = 0.0_ReKi      !< Cable control DeltaL [m]
    REAL(ReKi) , DIMENSION(1:20)  :: CableDeltaLdot = 0.0_ReKi      !< Cable control DeltaLdot [m/s]
  END TYPE FAST_ExternInputType
! =======================
! =========  FAST_MiscVarType  =======
  TYPE, PUBLIC :: FAST_MiscVarType
    REAL(DbKi)  :: TiLstPrn = 0.0_R8Ki      !< The simulation time of the last print (to file) [(s)]
    REAL(DbKi)  :: t_global = 0.0_R8Ki      !< Current simulation time (for global/FAST simulation) [(s)]
    REAL(DbKi)  :: NextJacCalcTime = 0.0_R8Ki      !< Time between calculating Jacobians in the HD-ED and SD-ED simulations [(s)]
    REAL(ReKi)  :: PrevClockTime = 0.0_ReKi      !< Clock time at start of simulation in seconds [(s)]
    REAL(ReKi)  :: UsrTime1 = 0.0_ReKi      !< User CPU time for simulation initialization [(s)]
    REAL(ReKi)  :: UsrTime2 = 0.0_ReKi      !< User CPU time for simulation (without initialization) [(s)]
    INTEGER(IntKi) , DIMENSION(1:8)  :: StrtTime = 0_IntKi      !< Start time of simulation (including initialization) [-]
    INTEGER(IntKi) , DIMENSION(1:8)  :: SimStrtTime = 0_IntKi      !< Start time of simulation (after initialization) [-]
    LOGICAL  :: calcJacobian = .false.      !< Should we calculate Jacobians in Option 1? [(flag)]
    TYPE(FAST_ExternInputType)  :: ExternInput      !< external input values [-]
    TYPE(FAST_MiscLinType)  :: Lin      !< misc data for linearization analysis [-]
  END TYPE FAST_MiscVarType
! =======================
! =========  FAST_InitData  =======
  TYPE, PUBLIC :: FAST_InitData
    TYPE(ED_InitInputType)  :: InData_ED      !< ED Initialization input data [-]
    TYPE(ED_InitOutputType)  :: OutData_ED      !< ED Initialization output data [-]
    TYPE(SED_InitInputType)  :: InData_SED      !< SED Initialization input data [-]
    TYPE(SED_InitOutputType)  :: OutData_SED      !< SED Initialization output data [-]
    TYPE(BD_InitInputType)  :: InData_BD      !< BD Initialization input data [-]
    TYPE(BD_InitOutputType) , DIMENSION(:), ALLOCATABLE  :: OutData_BD      !< BD Initialization output data [-]
    TYPE(SrvD_InitInputType)  :: InData_SrvD      !< SrvD Initialization input data [-]
    TYPE(SrvD_InitOutputType)  :: OutData_SrvD      !< SrvD Initialization output data [-]
    TYPE(AD_InitInputType)  :: InData_AD      !< AD Initialization input data [-]
    TYPE(AD_InitOutputType)  :: OutData_AD      !< AD Initialization output data [-]
    TYPE(ADsk_InitInputType)  :: InData_ADsk      !< ADsk Initialization input data [-]
    TYPE(ADsk_InitOutputType)  :: OutData_ADsk      !< ADsk Initialization output data [-]
    TYPE(ExtLd_InitInputType)  :: InData_ExtLd      !< ExtLd Initialization input data [-]
    TYPE(ExtLd_InitOutputType)  :: OutData_ExtLd      !< ExtLd Initialization output data [-]
    TYPE(InflowWind_InitInputType)  :: InData_IfW      !< IfW Initialization input data [-]
    TYPE(InflowWind_InitOutputType)  :: OutData_IfW      !< IfW Initialization output data [-]
    TYPE(ExtInfw_InitInputType)  :: InData_ExtInfw      !< ExtInfw Initialization input data [-]
    TYPE(ExtInfw_InitOutputType)  :: OutData_ExtInfw      !< ExtInfw Initialization output data [-]
    TYPE(SeaSt_InitInputType)  :: InData_SeaSt      !< SeaSt Initialization input data [-]
    TYPE(SeaSt_InitOutputType)  :: OutData_SeaSt      !< SeaSt Initialization output data [-]
    TYPE(HydroDyn_InitInputType)  :: InData_HD      !< HD Initialization input data [-]
    TYPE(HydroDyn_InitOutputType)  :: OutData_HD      !< HD Initialization output data [-]
    TYPE(SD_InitInputType)  :: InData_SD      !< SD Initialization input data [-]
    TYPE(SD_InitOutputType)  :: OutData_SD      !< SD Initialization output data [-]
    TYPE(ExtPtfm_InitInputType)  :: InData_ExtPtfm      !< ExtPtfm Initialization input data [-]
    TYPE(ExtPtfm_InitOutputType)  :: OutData_ExtPtfm      !< ExtPtfm Initialization output data [-]
    TYPE(MAP_InitInputType)  :: InData_MAP      !< MAP Initialization input data [-]
    TYPE(MAP_InitOutputType)  :: OutData_MAP      !< MAP Initialization output data [-]
    TYPE(FEAM_InitInputType)  :: InData_FEAM      !< FEAM Initialization input data [-]
    TYPE(FEAM_InitOutputType)  :: OutData_FEAM      !< FEAM Initialization output data [-]
    TYPE(MD_InitInputType)  :: InData_MD      !< MD Initialization input data [-]
    TYPE(MD_InitOutputType)  :: OutData_MD      !< MD Initialization output data [-]
    TYPE(Orca_InitInputType)  :: InData_Orca      !< Orca Initialization input data [-]
    TYPE(Orca_InitOutputType)  :: OutData_Orca      !< Orca Initialization output data [-]
    TYPE(IceFloe_InitInputType)  :: InData_IceF      !< IceF Initialization input data [-]
    TYPE(IceFloe_InitOutputType)  :: OutData_IceF      !< IceF Initialization output data [-]
    TYPE(IceD_InitInputType)  :: InData_IceD      !< IceD Initialization input data [-]
    TYPE(IceD_InitOutputType)  :: OutData_IceD      !< IceD Initialization output data (each instance will have the same output channels) [-]
  END TYPE FAST_InitData
! =======================
! =========  FAST_ExternInitType  =======
  TYPE, PUBLIC :: FAST_ExternInitType
    REAL(DbKi)  :: Tmax = -1      !< External code specified Tmax [s]
    INTEGER(IntKi)  :: TurbIDforName = -1      !< ID number for turbine (used to create output file naming convention) [-]
    REAL(ReKi) , DIMENSION(1:3)  :: TurbinePos = 0.0_ReKi      !< Initial position of turbine base (origin used for graphics or in FAST.Farm) [m]
    INTEGER(IntKi)  :: WaveFieldMod = 0_IntKi      !< Wave field handling (-) (switch) 0: use individual HydroDyn inputs without adjustment, 1: adjust wave phases based on turbine offsets from farm origin [-]
    LOGICAL  :: FarmIntegration = .false.      !< whether this is called from FAST.Farm (or another program that doesn't want FAST to call all of the init stuff first) [-]
    INTEGER(IntKi) , DIMENSION(1:4)  :: windGrid_n = 0_IntKi      !< number of grid points in the x, y, z, and t directions for IfW [-]
    REAL(ReKi) , DIMENSION(1:4)  :: windGrid_delta = 0.0_ReKi      !< size between 2 consecutive grid points in each grid direction for IfW [m,m,m,s]
    REAL(ReKi) , DIMENSION(1:3)  :: windGrid_pZero = 0.0_ReKi      !< fixed position of the XYZ grid (i.e., XYZ coordinates of IfW m%V(:,1,1,1,:)) [m]
    REAL(SiKi) , DIMENSION(:,:,:,:,:), POINTER  :: windGrid_data => NULL()      !< Pointers to Wind velocity of disturbed wind (ambient + wakes) across each high-resolution domain around a turbine for each high-resolution step within a low-resolution step [m/s]
    CHARACTER(1024)  :: RootName      !< Root name of FAST output files (overrides normal operation) [-]
    INTEGER(IntKi)  :: NumActForcePtsBlade = 0_IntKi      !< number of actuator line force points in blade [-]
    INTEGER(IntKi)  :: NumActForcePtsTower = 0_IntKi      !< number of actuator line force points in tower [-]
    INTEGER(IntKi)  :: NodeClusterType = 0_IntKi      !< Node clustering for actuator line (0 - Uniform, 1 - Non-uniform clustered towards tip) [-]
    REAL(DbKi)  :: DTdriver = -1      !< External driver time step [s]
    LOGICAL  :: TwrAero = .false.      !< Is Tower aerodynamics enabled for ExtLoads module? [-]
    REAL(ReKi)  :: az_blend_mean = 0.0_ReKi      !< Mean azimuth at which to blend the external and aerodyn loads [-]
    REAL(ReKi)  :: az_blend_delta = 0.0_ReKi      !< Mean azimuth at which to blend the external and aerodyn loads [-]
  END TYPE FAST_ExternInitType
! =======================
! =========  FAST_TurbineType  =======
  TYPE, PUBLIC :: FAST_TurbineType
    INTEGER(IntKi)  :: TurbID = 1      !< Turbine ID Number [-]
    TYPE(FAST_ParameterType)  :: p_FAST      !< Parameters for the glue code [-]
    TYPE(FAST_OutputFileType)  :: y_FAST      !< Output variables for the glue code [-]
    TYPE(FAST_MiscVarType)  :: m_FAST      !< Miscellaneous variables [-]
    TYPE(FAST_ModuleMapType)  :: MeshMapData      !< Data for mapping between modules [-]
    TYPE(ElastoDyn_Data)  :: ED      !< Data for the ElastoDyn module [-]
    TYPE(SED_Data)  :: SED      !< Data for the Simplified-ElastoDyn module [-]
    TYPE(BeamDyn_Data)  :: BD      !< Data for the BeamDyn module [-]
    TYPE(ServoDyn_Data)  :: SrvD      !< Data for the ServoDyn module [-]
    TYPE(AeroDyn_Data)  :: AD      !< Data for the AeroDyn module [-]
    TYPE(AeroDisk_Data)  :: ADsk      !< Data for the AeroDisk module [-]
    TYPE(ExtLoads_Data)  :: ExtLd      !< Data for the External loads module [-]
    TYPE(InflowWind_Data)  :: IfW      !< Data for InflowWind module [-]
    TYPE(ExternalInflow_Data)  :: ExtInfw      !< Data for ExternalInflow integration module [-]
    TYPE(SeaState_Data)  :: SeaSt      !< Data for the SeaState module [-]
    TYPE(HydroDyn_Data)  :: HD      !< Data for the HydroDyn module [-]
    TYPE(SubDyn_Data)  :: SD      !< Data for the SubDyn module [-]
    TYPE(MAP_Data)  :: MAP      !< Data for the MAP (Mooring Analysis Program) module [-]
    TYPE(FEAMooring_Data)  :: FEAM      !< Data for the FEAMooring module [-]
    TYPE(MoorDyn_Data)  :: MD      !< Data for the MoorDyn module [-]
    TYPE(OrcaFlex_Data)  :: Orca      !< Data for the OrcaFlex interface module [-]
    TYPE(IceFloe_Data)  :: IceF      !< Data for the IceFloe module [-]
    TYPE(IceDyn_Data)  :: IceD      !< Data for the IceDyn module [-]
    TYPE(ExtPtfm_Data)  :: ExtPtfm      !< Data for the ExtPtfm (external platform loading) module [-]
  END TYPE FAST_TurbineType
! =======================
CONTAINS

subroutine FAST_CopyVTK_BLSurfaceType(SrcVTK_BLSurfaceTypeData, DstVTK_BLSurfaceTypeData, CtrlCode, ErrStat, ErrMsg)
   type(FAST_VTK_BLSurfaceType), intent(in) :: SrcVTK_BLSurfaceTypeData
   type(FAST_VTK_BLSurfaceType), intent(inout) :: DstVTK_BLSurfaceTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'FAST_CopyVTK_BLSurfaceType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcVTK_BLSurfaceTypeData%AirfoilCoords)) then
      LB(1:3) = lbound(SrcVTK_BLSurfaceTypeData%AirfoilCoords)
      UB(1:3) = ubound(SrcVTK_BLSurfaceTypeData%AirfoilCoords)
      if (.not. allocated(DstVTK_BLSurfaceTypeData%AirfoilCoords)) then
         allocate(DstVTK_BLSurfaceTypeData%AirfoilCoords(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstVTK_BLSurfaceTypeData%AirfoilCoords.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstVTK_BLSurfaceTypeData%AirfoilCoords = SrcVTK_BLSurfaceTypeData%AirfoilCoords
   end if
end subroutine

subroutine FAST_DestroyVTK_BLSurfaceType(VTK_BLSurfaceTypeData, ErrStat, ErrMsg)
   type(FAST_VTK_BLSurfaceType), intent(inout) :: VTK_BLSurfaceTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FAST_DestroyVTK_BLSurfaceType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(VTK_BLSurfaceTypeData%AirfoilCoords)) then
      deallocate(VTK_BLSurfaceTypeData%AirfoilCoords)
   end if
end subroutine

subroutine FAST_PackVTK_BLSurfaceType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FAST_VTK_BLSurfaceType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FAST_PackVTK_BLSurfaceType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%AirfoilCoords)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_UnPackVTK_BLSurfaceType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FAST_VTK_BLSurfaceType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FAST_UnPackVTK_BLSurfaceType'
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%AirfoilCoords); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_CopyVTK_SurfaceType(SrcVTK_SurfaceTypeData, DstVTK_SurfaceTypeData, CtrlCode, ErrStat, ErrMsg)
   type(FAST_VTK_SurfaceType), intent(in) :: SrcVTK_SurfaceTypeData
   type(FAST_VTK_SurfaceType), intent(inout) :: DstVTK_SurfaceTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_CopyVTK_SurfaceType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstVTK_SurfaceTypeData%NumSectors = SrcVTK_SurfaceTypeData%NumSectors
   DstVTK_SurfaceTypeData%HubRad = SrcVTK_SurfaceTypeData%HubRad
   DstVTK_SurfaceTypeData%GroundRad = SrcVTK_SurfaceTypeData%GroundRad
   DstVTK_SurfaceTypeData%NacelleBox = SrcVTK_SurfaceTypeData%NacelleBox
   if (allocated(SrcVTK_SurfaceTypeData%TowerRad)) then
      LB(1:1) = lbound(SrcVTK_SurfaceTypeData%TowerRad)
      UB(1:1) = ubound(SrcVTK_SurfaceTypeData%TowerRad)
      if (.not. allocated(DstVTK_SurfaceTypeData%TowerRad)) then
         allocate(DstVTK_SurfaceTypeData%TowerRad(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstVTK_SurfaceTypeData%TowerRad.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstVTK_SurfaceTypeData%TowerRad = SrcVTK_SurfaceTypeData%TowerRad
   end if
   DstVTK_SurfaceTypeData%NWaveElevPts = SrcVTK_SurfaceTypeData%NWaveElevPts
   if (allocated(SrcVTK_SurfaceTypeData%WaveElevVisX)) then
      LB(1:1) = lbound(SrcVTK_SurfaceTypeData%WaveElevVisX)
      UB(1:1) = ubound(SrcVTK_SurfaceTypeData%WaveElevVisX)
      if (.not. allocated(DstVTK_SurfaceTypeData%WaveElevVisX)) then
         allocate(DstVTK_SurfaceTypeData%WaveElevVisX(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstVTK_SurfaceTypeData%WaveElevVisX.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstVTK_SurfaceTypeData%WaveElevVisX = SrcVTK_SurfaceTypeData%WaveElevVisX
   end if
   if (allocated(SrcVTK_SurfaceTypeData%WaveElevVisY)) then
      LB(1:1) = lbound(SrcVTK_SurfaceTypeData%WaveElevVisY)
      UB(1:1) = ubound(SrcVTK_SurfaceTypeData%WaveElevVisY)
      if (.not. allocated(DstVTK_SurfaceTypeData%WaveElevVisY)) then
         allocate(DstVTK_SurfaceTypeData%WaveElevVisY(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstVTK_SurfaceTypeData%WaveElevVisY.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstVTK_SurfaceTypeData%WaveElevVisY = SrcVTK_SurfaceTypeData%WaveElevVisY
   end if
   if (allocated(SrcVTK_SurfaceTypeData%WaveElevVisGrid)) then
      LB(1:3) = lbound(SrcVTK_SurfaceTypeData%WaveElevVisGrid)
      UB(1:3) = ubound(SrcVTK_SurfaceTypeData%WaveElevVisGrid)
      if (.not. allocated(DstVTK_SurfaceTypeData%WaveElevVisGrid)) then
         allocate(DstVTK_SurfaceTypeData%WaveElevVisGrid(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstVTK_SurfaceTypeData%WaveElevVisGrid.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstVTK_SurfaceTypeData%WaveElevVisGrid = SrcVTK_SurfaceTypeData%WaveElevVisGrid
   end if
   if (allocated(SrcVTK_SurfaceTypeData%BladeShape)) then
      LB(1:1) = lbound(SrcVTK_SurfaceTypeData%BladeShape)
      UB(1:1) = ubound(SrcVTK_SurfaceTypeData%BladeShape)
      if (.not. allocated(DstVTK_SurfaceTypeData%BladeShape)) then
         allocate(DstVTK_SurfaceTypeData%BladeShape(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstVTK_SurfaceTypeData%BladeShape.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call FAST_CopyVTK_BLSurfaceType(SrcVTK_SurfaceTypeData%BladeShape(i1), DstVTK_SurfaceTypeData%BladeShape(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcVTK_SurfaceTypeData%MorisonVisRad)) then
      LB(1:1) = lbound(SrcVTK_SurfaceTypeData%MorisonVisRad)
      UB(1:1) = ubound(SrcVTK_SurfaceTypeData%MorisonVisRad)
      if (.not. allocated(DstVTK_SurfaceTypeData%MorisonVisRad)) then
         allocate(DstVTK_SurfaceTypeData%MorisonVisRad(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstVTK_SurfaceTypeData%MorisonVisRad.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstVTK_SurfaceTypeData%MorisonVisRad = SrcVTK_SurfaceTypeData%MorisonVisRad
   end if
end subroutine

subroutine FAST_DestroyVTK_SurfaceType(VTK_SurfaceTypeData, ErrStat, ErrMsg)
   type(FAST_VTK_SurfaceType), intent(inout) :: VTK_SurfaceTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_DestroyVTK_SurfaceType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(VTK_SurfaceTypeData%TowerRad)) then
      deallocate(VTK_SurfaceTypeData%TowerRad)
   end if
   if (allocated(VTK_SurfaceTypeData%WaveElevVisX)) then
      deallocate(VTK_SurfaceTypeData%WaveElevVisX)
   end if
   if (allocated(VTK_SurfaceTypeData%WaveElevVisY)) then
      deallocate(VTK_SurfaceTypeData%WaveElevVisY)
   end if
   if (allocated(VTK_SurfaceTypeData%WaveElevVisGrid)) then
      deallocate(VTK_SurfaceTypeData%WaveElevVisGrid)
   end if
   if (allocated(VTK_SurfaceTypeData%BladeShape)) then
      LB(1:1) = lbound(VTK_SurfaceTypeData%BladeShape)
      UB(1:1) = ubound(VTK_SurfaceTypeData%BladeShape)
      do i1 = LB(1), UB(1)
         call FAST_DestroyVTK_BLSurfaceType(VTK_SurfaceTypeData%BladeShape(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(VTK_SurfaceTypeData%BladeShape)
   end if
   if (allocated(VTK_SurfaceTypeData%MorisonVisRad)) then
      deallocate(VTK_SurfaceTypeData%MorisonVisRad)
   end if
end subroutine

subroutine FAST_PackVTK_SurfaceType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FAST_VTK_SurfaceType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FAST_PackVTK_SurfaceType'
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)   :: LB(3), UB(3)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%NumSectors)
   call RegPack(RF, InData%HubRad)
   call RegPack(RF, InData%GroundRad)
   call RegPack(RF, InData%NacelleBox)
   call RegPackAlloc(RF, InData%TowerRad)
   call RegPack(RF, InData%NWaveElevPts)
   call RegPackAlloc(RF, InData%WaveElevVisX)
   call RegPackAlloc(RF, InData%WaveElevVisY)
   call RegPackAlloc(RF, InData%WaveElevVisGrid)
   call RegPack(RF, allocated(InData%BladeShape))
   if (allocated(InData%BladeShape)) then
      call RegPackBounds(RF, 1, lbound(InData%BladeShape), ubound(InData%BladeShape))
      LB(1:1) = lbound(InData%BladeShape)
      UB(1:1) = ubound(InData%BladeShape)
      do i1 = LB(1), UB(1)
         call FAST_PackVTK_BLSurfaceType(RF, InData%BladeShape(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%MorisonVisRad)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_UnPackVTK_SurfaceType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FAST_VTK_SurfaceType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FAST_UnPackVTK_SurfaceType'
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%NumSectors); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HubRad); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GroundRad); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NacelleBox); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TowerRad); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NWaveElevPts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WaveElevVisX); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WaveElevVisY); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WaveElevVisGrid); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%BladeShape)) deallocate(OutData%BladeShape)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BladeShape(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BladeShape.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call FAST_UnpackVTK_BLSurfaceType(RF, OutData%BladeShape(i1)) ! BladeShape 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%MorisonVisRad); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_CopyVTK_ModeShapeType(SrcVTK_ModeShapeTypeData, DstVTK_ModeShapeTypeData, CtrlCode, ErrStat, ErrMsg)
   type(FAST_VTK_ModeShapeType), intent(in) :: SrcVTK_ModeShapeTypeData
   type(FAST_VTK_ModeShapeType), intent(inout) :: DstVTK_ModeShapeTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'FAST_CopyVTK_ModeShapeType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstVTK_ModeShapeTypeData%CheckpointRoot = SrcVTK_ModeShapeTypeData%CheckpointRoot
   DstVTK_ModeShapeTypeData%MatlabFileName = SrcVTK_ModeShapeTypeData%MatlabFileName
   DstVTK_ModeShapeTypeData%VTKLinModes = SrcVTK_ModeShapeTypeData%VTKLinModes
   if (allocated(SrcVTK_ModeShapeTypeData%VTKModes)) then
      LB(1:1) = lbound(SrcVTK_ModeShapeTypeData%VTKModes)
      UB(1:1) = ubound(SrcVTK_ModeShapeTypeData%VTKModes)
      if (.not. allocated(DstVTK_ModeShapeTypeData%VTKModes)) then
         allocate(DstVTK_ModeShapeTypeData%VTKModes(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstVTK_ModeShapeTypeData%VTKModes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstVTK_ModeShapeTypeData%VTKModes = SrcVTK_ModeShapeTypeData%VTKModes
   end if
   DstVTK_ModeShapeTypeData%VTKLinTim = SrcVTK_ModeShapeTypeData%VTKLinTim
   DstVTK_ModeShapeTypeData%VTKNLinTimes = SrcVTK_ModeShapeTypeData%VTKNLinTimes
   DstVTK_ModeShapeTypeData%VTKLinScale = SrcVTK_ModeShapeTypeData%VTKLinScale
   DstVTK_ModeShapeTypeData%VTKLinPhase = SrcVTK_ModeShapeTypeData%VTKLinPhase
   if (allocated(SrcVTK_ModeShapeTypeData%DampingRatio)) then
      LB(1:1) = lbound(SrcVTK_ModeShapeTypeData%DampingRatio)
      UB(1:1) = ubound(SrcVTK_ModeShapeTypeData%DampingRatio)
      if (.not. allocated(DstVTK_ModeShapeTypeData%DampingRatio)) then
         allocate(DstVTK_ModeShapeTypeData%DampingRatio(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstVTK_ModeShapeTypeData%DampingRatio.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstVTK_ModeShapeTypeData%DampingRatio = SrcVTK_ModeShapeTypeData%DampingRatio
   end if
   if (allocated(SrcVTK_ModeShapeTypeData%NaturalFreq_Hz)) then
      LB(1:1) = lbound(SrcVTK_ModeShapeTypeData%NaturalFreq_Hz)
      UB(1:1) = ubound(SrcVTK_ModeShapeTypeData%NaturalFreq_Hz)
      if (.not. allocated(DstVTK_ModeShapeTypeData%NaturalFreq_Hz)) then
         allocate(DstVTK_ModeShapeTypeData%NaturalFreq_Hz(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstVTK_ModeShapeTypeData%NaturalFreq_Hz.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstVTK_ModeShapeTypeData%NaturalFreq_Hz = SrcVTK_ModeShapeTypeData%NaturalFreq_Hz
   end if
   if (allocated(SrcVTK_ModeShapeTypeData%DampedFreq_Hz)) then
      LB(1:1) = lbound(SrcVTK_ModeShapeTypeData%DampedFreq_Hz)
      UB(1:1) = ubound(SrcVTK_ModeShapeTypeData%DampedFreq_Hz)
      if (.not. allocated(DstVTK_ModeShapeTypeData%DampedFreq_Hz)) then
         allocate(DstVTK_ModeShapeTypeData%DampedFreq_Hz(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstVTK_ModeShapeTypeData%DampedFreq_Hz.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstVTK_ModeShapeTypeData%DampedFreq_Hz = SrcVTK_ModeShapeTypeData%DampedFreq_Hz
   end if
   if (allocated(SrcVTK_ModeShapeTypeData%x_eig_magnitude)) then
      LB(1:3) = lbound(SrcVTK_ModeShapeTypeData%x_eig_magnitude)
      UB(1:3) = ubound(SrcVTK_ModeShapeTypeData%x_eig_magnitude)
      if (.not. allocated(DstVTK_ModeShapeTypeData%x_eig_magnitude)) then
         allocate(DstVTK_ModeShapeTypeData%x_eig_magnitude(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstVTK_ModeShapeTypeData%x_eig_magnitude.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstVTK_ModeShapeTypeData%x_eig_magnitude = SrcVTK_ModeShapeTypeData%x_eig_magnitude
   end if
   if (allocated(SrcVTK_ModeShapeTypeData%x_eig_phase)) then
      LB(1:3) = lbound(SrcVTK_ModeShapeTypeData%x_eig_phase)
      UB(1:3) = ubound(SrcVTK_ModeShapeTypeData%x_eig_phase)
      if (.not. allocated(DstVTK_ModeShapeTypeData%x_eig_phase)) then
         allocate(DstVTK_ModeShapeTypeData%x_eig_phase(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstVTK_ModeShapeTypeData%x_eig_phase.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstVTK_ModeShapeTypeData%x_eig_phase = SrcVTK_ModeShapeTypeData%x_eig_phase
   end if
end subroutine

subroutine FAST_DestroyVTK_ModeShapeType(VTK_ModeShapeTypeData, ErrStat, ErrMsg)
   type(FAST_VTK_ModeShapeType), intent(inout) :: VTK_ModeShapeTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FAST_DestroyVTK_ModeShapeType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(VTK_ModeShapeTypeData%VTKModes)) then
      deallocate(VTK_ModeShapeTypeData%VTKModes)
   end if
   if (allocated(VTK_ModeShapeTypeData%DampingRatio)) then
      deallocate(VTK_ModeShapeTypeData%DampingRatio)
   end if
   if (allocated(VTK_ModeShapeTypeData%NaturalFreq_Hz)) then
      deallocate(VTK_ModeShapeTypeData%NaturalFreq_Hz)
   end if
   if (allocated(VTK_ModeShapeTypeData%DampedFreq_Hz)) then
      deallocate(VTK_ModeShapeTypeData%DampedFreq_Hz)
   end if
   if (allocated(VTK_ModeShapeTypeData%x_eig_magnitude)) then
      deallocate(VTK_ModeShapeTypeData%x_eig_magnitude)
   end if
   if (allocated(VTK_ModeShapeTypeData%x_eig_phase)) then
      deallocate(VTK_ModeShapeTypeData%x_eig_phase)
   end if
end subroutine

subroutine FAST_PackVTK_ModeShapeType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FAST_VTK_ModeShapeType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FAST_PackVTK_ModeShapeType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%CheckpointRoot)
   call RegPack(RF, InData%MatlabFileName)
   call RegPack(RF, InData%VTKLinModes)
   call RegPackAlloc(RF, InData%VTKModes)
   call RegPack(RF, InData%VTKLinTim)
   call RegPack(RF, InData%VTKNLinTimes)
   call RegPack(RF, InData%VTKLinScale)
   call RegPack(RF, InData%VTKLinPhase)
   call RegPackAlloc(RF, InData%DampingRatio)
   call RegPackAlloc(RF, InData%NaturalFreq_Hz)
   call RegPackAlloc(RF, InData%DampedFreq_Hz)
   call RegPackAlloc(RF, InData%x_eig_magnitude)
   call RegPackAlloc(RF, InData%x_eig_phase)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_UnPackVTK_ModeShapeType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FAST_VTK_ModeShapeType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FAST_UnPackVTK_ModeShapeType'
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%CheckpointRoot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MatlabFileName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VTKLinModes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%VTKModes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VTKLinTim); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VTKNLinTimes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VTKLinScale); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VTKLinPhase); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%DampingRatio); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%NaturalFreq_Hz); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%DampedFreq_Hz); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%x_eig_magnitude); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%x_eig_phase); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_CopySS_CaseType(SrcSS_CaseTypeData, DstSS_CaseTypeData, CtrlCode, ErrStat, ErrMsg)
   type(FAST_SS_CaseType), intent(in) :: SrcSS_CaseTypeData
   type(FAST_SS_CaseType), intent(inout) :: DstSS_CaseTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FAST_CopySS_CaseType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstSS_CaseTypeData%RotSpeed = SrcSS_CaseTypeData%RotSpeed
   DstSS_CaseTypeData%TSR = SrcSS_CaseTypeData%TSR
   DstSS_CaseTypeData%WindSpeed = SrcSS_CaseTypeData%WindSpeed
   DstSS_CaseTypeData%Pitch = SrcSS_CaseTypeData%Pitch
end subroutine

subroutine FAST_DestroySS_CaseType(SS_CaseTypeData, ErrStat, ErrMsg)
   type(FAST_SS_CaseType), intent(inout) :: SS_CaseTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FAST_DestroySS_CaseType'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine FAST_PackSS_CaseType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FAST_SS_CaseType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FAST_PackSS_CaseType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%RotSpeed)
   call RegPack(RF, InData%TSR)
   call RegPack(RF, InData%WindSpeed)
   call RegPack(RF, InData%Pitch)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_UnPackSS_CaseType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FAST_SS_CaseType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FAST_UnPackSS_CaseType'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%RotSpeed); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TSR); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WindSpeed); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Pitch); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_CopyParam(SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg)
   type(FAST_ParameterType), intent(in) :: SrcParamData
   type(FAST_ParameterType), intent(inout) :: DstParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_CopyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstParamData%DT = SrcParamData%DT
   DstParamData%DT_module = SrcParamData%DT_module
   DstParamData%n_substeps = SrcParamData%n_substeps
   DstParamData%n_TMax_m1 = SrcParamData%n_TMax_m1
   DstParamData%TMax = SrcParamData%TMax
   DstParamData%InterpOrder = SrcParamData%InterpOrder
   DstParamData%NumCrctn = SrcParamData%NumCrctn
   DstParamData%KMax = SrcParamData%KMax
   DstParamData%numIceLegs = SrcParamData%numIceLegs
   DstParamData%nBeams = SrcParamData%nBeams
   DstParamData%BD_OutputSibling = SrcParamData%BD_OutputSibling
   DstParamData%ModuleInitialized = SrcParamData%ModuleInitialized
   DstParamData%DT_Ujac = SrcParamData%DT_Ujac
   DstParamData%UJacSclFact = SrcParamData%UJacSclFact
   DstParamData%SizeJac_Opt1 = SrcParamData%SizeJac_Opt1
   DstParamData%SolveOption = SrcParamData%SolveOption
   DstParamData%CompElast = SrcParamData%CompElast
   DstParamData%CompInflow = SrcParamData%CompInflow
   DstParamData%CompAero = SrcParamData%CompAero
   DstParamData%CompServo = SrcParamData%CompServo
   DstParamData%CompSeaSt = SrcParamData%CompSeaSt
   DstParamData%CompHydro = SrcParamData%CompHydro
   DstParamData%CompSub = SrcParamData%CompSub
   DstParamData%CompMooring = SrcParamData%CompMooring
   DstParamData%CompIce = SrcParamData%CompIce
   DstParamData%MHK = SrcParamData%MHK
   DstParamData%UseDWM = SrcParamData%UseDWM
   DstParamData%Linearize = SrcParamData%Linearize
   DstParamData%WaveFieldMod = SrcParamData%WaveFieldMod
   DstParamData%FarmIntegration = SrcParamData%FarmIntegration
   DstParamData%TurbinePos = SrcParamData%TurbinePos
   DstParamData%Gravity = SrcParamData%Gravity
   DstParamData%AirDens = SrcParamData%AirDens
   DstParamData%WtrDens = SrcParamData%WtrDens
   DstParamData%KinVisc = SrcParamData%KinVisc
   DstParamData%SpdSound = SrcParamData%SpdSound
   DstParamData%Patm = SrcParamData%Patm
   DstParamData%Pvap = SrcParamData%Pvap
   DstParamData%WtrDpth = SrcParamData%WtrDpth
   DstParamData%MSL2SWL = SrcParamData%MSL2SWL
   DstParamData%EDFile = SrcParamData%EDFile
   DstParamData%BDBldFile = SrcParamData%BDBldFile
   DstParamData%InflowFile = SrcParamData%InflowFile
   DstParamData%AeroFile = SrcParamData%AeroFile
   DstParamData%ServoFile = SrcParamData%ServoFile
   DstParamData%SeaStFile = SrcParamData%SeaStFile
   DstParamData%HydroFile = SrcParamData%HydroFile
   DstParamData%SubFile = SrcParamData%SubFile
   DstParamData%MooringFile = SrcParamData%MooringFile
   DstParamData%IceFile = SrcParamData%IceFile
   DstParamData%TStart = SrcParamData%TStart
   DstParamData%DT_Out = SrcParamData%DT_Out
   DstParamData%WrSttsTime = SrcParamData%WrSttsTime
   DstParamData%n_SttsTime = SrcParamData%n_SttsTime
   DstParamData%n_ChkptTime = SrcParamData%n_ChkptTime
   DstParamData%n_DT_Out = SrcParamData%n_DT_Out
   DstParamData%n_VTKTime = SrcParamData%n_VTKTime
   DstParamData%WrBinOutFile = SrcParamData%WrBinOutFile
   DstParamData%WrTxtOutFile = SrcParamData%WrTxtOutFile
   DstParamData%WrBinMod = SrcParamData%WrBinMod
   DstParamData%SumPrint = SrcParamData%SumPrint
   DstParamData%WrVTK = SrcParamData%WrVTK
   DstParamData%VTK_Type = SrcParamData%VTK_Type
   DstParamData%VTK_fields = SrcParamData%VTK_fields
   DstParamData%Delim = SrcParamData%Delim
   DstParamData%OutFmt = SrcParamData%OutFmt
   DstParamData%OutFmt_t = SrcParamData%OutFmt_t
   DstParamData%FmtWidth = SrcParamData%FmtWidth
   DstParamData%TChanLen = SrcParamData%TChanLen
   DstParamData%OutFileRoot = SrcParamData%OutFileRoot
   DstParamData%FTitle = SrcParamData%FTitle
   DstParamData%VTK_OutFileRoot = SrcParamData%VTK_OutFileRoot
   DstParamData%VTK_tWidth = SrcParamData%VTK_tWidth
   DstParamData%VTK_fps = SrcParamData%VTK_fps
   call FAST_CopyVTK_SurfaceType(SrcParamData%VTK_surface, DstParamData%VTK_surface, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstParamData%Tdesc = SrcParamData%Tdesc
   DstParamData%PlatformPosInit = SrcParamData%PlatformPosInit
   DstParamData%CalcSteady = SrcParamData%CalcSteady
   DstParamData%TrimCase = SrcParamData%TrimCase
   DstParamData%TrimTol = SrcParamData%TrimTol
   DstParamData%TrimGain = SrcParamData%TrimGain
   DstParamData%Twr_Kdmp = SrcParamData%Twr_Kdmp
   DstParamData%Bld_Kdmp = SrcParamData%Bld_Kdmp
   DstParamData%NLinTimes = SrcParamData%NLinTimes
   DstParamData%AzimDelta = SrcParamData%AzimDelta
   DstParamData%LinInputs = SrcParamData%LinInputs
   DstParamData%LinOutputs = SrcParamData%LinOutputs
   DstParamData%LinOutJac = SrcParamData%LinOutJac
   DstParamData%LinOutMod = SrcParamData%LinOutMod
   call FAST_CopyVTK_ModeShapeType(SrcParamData%VTK_modes, DstParamData%VTK_modes, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstParamData%Lin_NumMods = SrcParamData%Lin_NumMods
   DstParamData%Lin_ModOrder = SrcParamData%Lin_ModOrder
   DstParamData%LinInterpOrder = SrcParamData%LinInterpOrder
   DstParamData%CompAeroMaps = SrcParamData%CompAeroMaps
   DstParamData%N_UJac = SrcParamData%N_UJac
   DstParamData%NumBl_Lin = SrcParamData%NumBl_Lin
   DstParamData%tolerSquared = SrcParamData%tolerSquared
   DstParamData%NumSSCases = SrcParamData%NumSSCases
   DstParamData%WindSpeedOrTSR = SrcParamData%WindSpeedOrTSR
   DstParamData%RotSpeedInit = SrcParamData%RotSpeedInit
   if (allocated(SrcParamData%RotSpeed)) then
      LB(1:1) = lbound(SrcParamData%RotSpeed)
      UB(1:1) = ubound(SrcParamData%RotSpeed)
      if (.not. allocated(DstParamData%RotSpeed)) then
         allocate(DstParamData%RotSpeed(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%RotSpeed.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%RotSpeed = SrcParamData%RotSpeed
   end if
   if (allocated(SrcParamData%WS_TSR)) then
      LB(1:1) = lbound(SrcParamData%WS_TSR)
      UB(1:1) = ubound(SrcParamData%WS_TSR)
      if (.not. allocated(DstParamData%WS_TSR)) then
         allocate(DstParamData%WS_TSR(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%WS_TSR.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%WS_TSR = SrcParamData%WS_TSR
   end if
   if (allocated(SrcParamData%Pitch)) then
      LB(1:1) = lbound(SrcParamData%Pitch)
      UB(1:1) = ubound(SrcParamData%Pitch)
      if (.not. allocated(DstParamData%Pitch)) then
         allocate(DstParamData%Pitch(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Pitch.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Pitch = SrcParamData%Pitch
   end if
   DstParamData%GearBox_index = SrcParamData%GearBox_index
end subroutine

subroutine FAST_DestroyParam(ParamData, ErrStat, ErrMsg)
   type(FAST_ParameterType), intent(inout) :: ParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_DestroyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call FAST_DestroyVTK_SurfaceType(ParamData%VTK_surface, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FAST_DestroyVTK_ModeShapeType(ParamData%VTK_modes, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(ParamData%RotSpeed)) then
      deallocate(ParamData%RotSpeed)
   end if
   if (allocated(ParamData%WS_TSR)) then
      deallocate(ParamData%WS_TSR)
   end if
   if (allocated(ParamData%Pitch)) then
      deallocate(ParamData%Pitch)
   end if
end subroutine

subroutine FAST_PackParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FAST_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FAST_PackParam'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DT)
   call RegPack(RF, InData%DT_module)
   call RegPack(RF, InData%n_substeps)
   call RegPack(RF, InData%n_TMax_m1)
   call RegPack(RF, InData%TMax)
   call RegPack(RF, InData%InterpOrder)
   call RegPack(RF, InData%NumCrctn)
   call RegPack(RF, InData%KMax)
   call RegPack(RF, InData%numIceLegs)
   call RegPack(RF, InData%nBeams)
   call RegPack(RF, InData%BD_OutputSibling)
   call RegPack(RF, InData%ModuleInitialized)
   call RegPack(RF, InData%DT_Ujac)
   call RegPack(RF, InData%UJacSclFact)
   call RegPack(RF, InData%SizeJac_Opt1)
   call RegPack(RF, InData%SolveOption)
   call RegPack(RF, InData%CompElast)
   call RegPack(RF, InData%CompInflow)
   call RegPack(RF, InData%CompAero)
   call RegPack(RF, InData%CompServo)
   call RegPack(RF, InData%CompSeaSt)
   call RegPack(RF, InData%CompHydro)
   call RegPack(RF, InData%CompSub)
   call RegPack(RF, InData%CompMooring)
   call RegPack(RF, InData%CompIce)
   call RegPack(RF, InData%MHK)
   call RegPack(RF, InData%UseDWM)
   call RegPack(RF, InData%Linearize)
   call RegPack(RF, InData%WaveFieldMod)
   call RegPack(RF, InData%FarmIntegration)
   call RegPack(RF, InData%TurbinePos)
   call RegPack(RF, InData%Gravity)
   call RegPack(RF, InData%AirDens)
   call RegPack(RF, InData%WtrDens)
   call RegPack(RF, InData%KinVisc)
   call RegPack(RF, InData%SpdSound)
   call RegPack(RF, InData%Patm)
   call RegPack(RF, InData%Pvap)
   call RegPack(RF, InData%WtrDpth)
   call RegPack(RF, InData%MSL2SWL)
   call RegPack(RF, InData%EDFile)
   call RegPack(RF, InData%BDBldFile)
   call RegPack(RF, InData%InflowFile)
   call RegPack(RF, InData%AeroFile)
   call RegPack(RF, InData%ServoFile)
   call RegPack(RF, InData%SeaStFile)
   call RegPack(RF, InData%HydroFile)
   call RegPack(RF, InData%SubFile)
   call RegPack(RF, InData%MooringFile)
   call RegPack(RF, InData%IceFile)
   call RegPack(RF, InData%TStart)
   call RegPack(RF, InData%DT_Out)
   call RegPack(RF, InData%WrSttsTime)
   call RegPack(RF, InData%n_SttsTime)
   call RegPack(RF, InData%n_ChkptTime)
   call RegPack(RF, InData%n_DT_Out)
   call RegPack(RF, InData%n_VTKTime)
   call RegPack(RF, InData%WrBinOutFile)
   call RegPack(RF, InData%WrTxtOutFile)
   call RegPack(RF, InData%WrBinMod)
   call RegPack(RF, InData%SumPrint)
   call RegPack(RF, InData%WrVTK)
   call RegPack(RF, InData%VTK_Type)
   call RegPack(RF, InData%VTK_fields)
   call RegPack(RF, InData%Delim)
   call RegPack(RF, InData%OutFmt)
   call RegPack(RF, InData%OutFmt_t)
   call RegPack(RF, InData%FmtWidth)
   call RegPack(RF, InData%TChanLen)
   call RegPack(RF, InData%OutFileRoot)
   call RegPack(RF, InData%FTitle)
   call RegPack(RF, InData%VTK_OutFileRoot)
   call RegPack(RF, InData%VTK_tWidth)
   call RegPack(RF, InData%VTK_fps)
   call FAST_PackVTK_SurfaceType(RF, InData%VTK_surface) 
   call RegPack(RF, InData%Tdesc)
   call RegPack(RF, InData%PlatformPosInit)
   call RegPack(RF, InData%CalcSteady)
   call RegPack(RF, InData%TrimCase)
   call RegPack(RF, InData%TrimTol)
   call RegPack(RF, InData%TrimGain)
   call RegPack(RF, InData%Twr_Kdmp)
   call RegPack(RF, InData%Bld_Kdmp)
   call RegPack(RF, InData%NLinTimes)
   call RegPack(RF, InData%AzimDelta)
   call RegPack(RF, InData%LinInputs)
   call RegPack(RF, InData%LinOutputs)
   call RegPack(RF, InData%LinOutJac)
   call RegPack(RF, InData%LinOutMod)
   call FAST_PackVTK_ModeShapeType(RF, InData%VTK_modes) 
   call RegPack(RF, InData%Lin_NumMods)
   call RegPack(RF, InData%Lin_ModOrder)
   call RegPack(RF, InData%LinInterpOrder)
   call RegPack(RF, InData%CompAeroMaps)
   call RegPack(RF, InData%N_UJac)
   call RegPack(RF, InData%NumBl_Lin)
   call RegPack(RF, InData%tolerSquared)
   call RegPack(RF, InData%NumSSCases)
   call RegPack(RF, InData%WindSpeedOrTSR)
   call RegPack(RF, InData%RotSpeedInit)
   call RegPackAlloc(RF, InData%RotSpeed)
   call RegPackAlloc(RF, InData%WS_TSR)
   call RegPackAlloc(RF, InData%Pitch)
   call RegPack(RF, InData%GearBox_index)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_UnPackParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FAST_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FAST_UnPackParam'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DT_module); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%n_substeps); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%n_TMax_m1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TMax); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%InterpOrder); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumCrctn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%KMax); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%numIceLegs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nBeams); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BD_OutputSibling); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ModuleInitialized); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DT_Ujac); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UJacSclFact); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SizeJac_Opt1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SolveOption); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CompElast); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CompInflow); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CompAero); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CompServo); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CompSeaSt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CompHydro); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CompSub); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CompMooring); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CompIce); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MHK); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UseDWM); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Linearize); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WaveFieldMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FarmIntegration); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TurbinePos); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Gravity); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AirDens); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WtrDens); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%KinVisc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SpdSound); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Patm); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Pvap); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WtrDpth); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MSL2SWL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%EDFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BDBldFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%InflowFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AeroFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ServoFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SeaStFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HydroFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SubFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MooringFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%IceFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TStart); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DT_Out); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WrSttsTime); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%n_SttsTime); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%n_ChkptTime); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%n_DT_Out); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%n_VTKTime); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WrBinOutFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WrTxtOutFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WrBinMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SumPrint); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WrVTK); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VTK_Type); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VTK_fields); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Delim); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutFmt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutFmt_t); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FmtWidth); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TChanLen); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutFileRoot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FTitle); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VTK_OutFileRoot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VTK_tWidth); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VTK_fps); if (RegCheckErr(RF, RoutineName)) return
   call FAST_UnpackVTK_SurfaceType(RF, OutData%VTK_surface) ! VTK_surface 
   call RegUnpack(RF, OutData%Tdesc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PlatformPosInit); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CalcSteady); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TrimCase); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TrimTol); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TrimGain); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Twr_Kdmp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Bld_Kdmp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NLinTimes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AzimDelta); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LinInputs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LinOutputs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LinOutJac); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LinOutMod); if (RegCheckErr(RF, RoutineName)) return
   call FAST_UnpackVTK_ModeShapeType(RF, OutData%VTK_modes) ! VTK_modes 
   call RegUnpack(RF, OutData%Lin_NumMods); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Lin_ModOrder); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LinInterpOrder); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CompAeroMaps); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%N_UJac); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumBl_Lin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%tolerSquared); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumSSCases); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WindSpeedOrTSR); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RotSpeedInit); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RotSpeed); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WS_TSR); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Pitch); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GearBox_index); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_CopyLinStateSave(SrcLinStateSaveData, DstLinStateSaveData, CtrlCode, ErrStat, ErrMsg)
   type(FAST_LinStateSave), intent(inout) :: SrcLinStateSaveData
   type(FAST_LinStateSave), intent(inout) :: DstLinStateSaveData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_CopyLinStateSave'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcLinStateSaveData%x_IceD)) then
      LB(1:2) = lbound(SrcLinStateSaveData%x_IceD)
      UB(1:2) = ubound(SrcLinStateSaveData%x_IceD)
      if (.not. allocated(DstLinStateSaveData%x_IceD)) then
         allocate(DstLinStateSaveData%x_IceD(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%x_IceD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_CopyContState(SrcLinStateSaveData%x_IceD(i1,i2), DstLinStateSaveData%x_IceD(i1,i2), CtrlCode, ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
            if (ErrStat >= AbortErrLev) return
         end do
      end do
   end if
   if (allocated(SrcLinStateSaveData%xd_IceD)) then
      LB(1:2) = lbound(SrcLinStateSaveData%xd_IceD)
      UB(1:2) = ubound(SrcLinStateSaveData%xd_IceD)
      if (.not. allocated(DstLinStateSaveData%xd_IceD)) then
         allocate(DstLinStateSaveData%xd_IceD(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%xd_IceD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_CopyDiscState(SrcLinStateSaveData%xd_IceD(i1,i2), DstLinStateSaveData%xd_IceD(i1,i2), CtrlCode, ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
            if (ErrStat >= AbortErrLev) return
         end do
      end do
   end if
   if (allocated(SrcLinStateSaveData%z_IceD)) then
      LB(1:2) = lbound(SrcLinStateSaveData%z_IceD)
      UB(1:2) = ubound(SrcLinStateSaveData%z_IceD)
      if (.not. allocated(DstLinStateSaveData%z_IceD)) then
         allocate(DstLinStateSaveData%z_IceD(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%z_IceD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_CopyConstrState(SrcLinStateSaveData%z_IceD(i1,i2), DstLinStateSaveData%z_IceD(i1,i2), CtrlCode, ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
            if (ErrStat >= AbortErrLev) return
         end do
      end do
   end if
   if (allocated(SrcLinStateSaveData%OtherSt_IceD)) then
      LB(1:2) = lbound(SrcLinStateSaveData%OtherSt_IceD)
      UB(1:2) = ubound(SrcLinStateSaveData%OtherSt_IceD)
      if (.not. allocated(DstLinStateSaveData%OtherSt_IceD)) then
         allocate(DstLinStateSaveData%OtherSt_IceD(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%OtherSt_IceD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_CopyOtherState(SrcLinStateSaveData%OtherSt_IceD(i1,i2), DstLinStateSaveData%OtherSt_IceD(i1,i2), CtrlCode, ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
            if (ErrStat >= AbortErrLev) return
         end do
      end do
   end if
   if (allocated(SrcLinStateSaveData%u_IceD)) then
      LB(1:2) = lbound(SrcLinStateSaveData%u_IceD)
      UB(1:2) = ubound(SrcLinStateSaveData%u_IceD)
      if (.not. allocated(DstLinStateSaveData%u_IceD)) then
         allocate(DstLinStateSaveData%u_IceD(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%u_IceD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_CopyInput(SrcLinStateSaveData%u_IceD(i1,i2), DstLinStateSaveData%u_IceD(i1,i2), CtrlCode, ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
            if (ErrStat >= AbortErrLev) return
         end do
      end do
   end if
   if (allocated(SrcLinStateSaveData%x_BD)) then
      LB(1:2) = lbound(SrcLinStateSaveData%x_BD)
      UB(1:2) = ubound(SrcLinStateSaveData%x_BD)
      if (.not. allocated(DstLinStateSaveData%x_BD)) then
         allocate(DstLinStateSaveData%x_BD(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%x_BD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_CopyContState(SrcLinStateSaveData%x_BD(i1,i2), DstLinStateSaveData%x_BD(i1,i2), CtrlCode, ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
            if (ErrStat >= AbortErrLev) return
         end do
      end do
   end if
   if (allocated(SrcLinStateSaveData%xd_BD)) then
      LB(1:2) = lbound(SrcLinStateSaveData%xd_BD)
      UB(1:2) = ubound(SrcLinStateSaveData%xd_BD)
      if (.not. allocated(DstLinStateSaveData%xd_BD)) then
         allocate(DstLinStateSaveData%xd_BD(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%xd_BD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_CopyDiscState(SrcLinStateSaveData%xd_BD(i1,i2), DstLinStateSaveData%xd_BD(i1,i2), CtrlCode, ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
            if (ErrStat >= AbortErrLev) return
         end do
      end do
   end if
   if (allocated(SrcLinStateSaveData%z_BD)) then
      LB(1:2) = lbound(SrcLinStateSaveData%z_BD)
      UB(1:2) = ubound(SrcLinStateSaveData%z_BD)
      if (.not. allocated(DstLinStateSaveData%z_BD)) then
         allocate(DstLinStateSaveData%z_BD(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%z_BD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_CopyConstrState(SrcLinStateSaveData%z_BD(i1,i2), DstLinStateSaveData%z_BD(i1,i2), CtrlCode, ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
            if (ErrStat >= AbortErrLev) return
         end do
      end do
   end if
   if (allocated(SrcLinStateSaveData%OtherSt_BD)) then
      LB(1:2) = lbound(SrcLinStateSaveData%OtherSt_BD)
      UB(1:2) = ubound(SrcLinStateSaveData%OtherSt_BD)
      if (.not. allocated(DstLinStateSaveData%OtherSt_BD)) then
         allocate(DstLinStateSaveData%OtherSt_BD(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%OtherSt_BD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_CopyOtherState(SrcLinStateSaveData%OtherSt_BD(i1,i2), DstLinStateSaveData%OtherSt_BD(i1,i2), CtrlCode, ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
            if (ErrStat >= AbortErrLev) return
         end do
      end do
   end if
   if (allocated(SrcLinStateSaveData%u_BD)) then
      LB(1:2) = lbound(SrcLinStateSaveData%u_BD)
      UB(1:2) = ubound(SrcLinStateSaveData%u_BD)
      if (.not. allocated(DstLinStateSaveData%u_BD)) then
         allocate(DstLinStateSaveData%u_BD(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%u_BD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_CopyInput(SrcLinStateSaveData%u_BD(i1,i2), DstLinStateSaveData%u_BD(i1,i2), CtrlCode, ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
            if (ErrStat >= AbortErrLev) return
         end do
      end do
   end if
   if (allocated(SrcLinStateSaveData%x_ED)) then
      LB(1:1) = lbound(SrcLinStateSaveData%x_ED)
      UB(1:1) = ubound(SrcLinStateSaveData%x_ED)
      if (.not. allocated(DstLinStateSaveData%x_ED)) then
         allocate(DstLinStateSaveData%x_ED(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%x_ED.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call ED_CopyContState(SrcLinStateSaveData%x_ED(i1), DstLinStateSaveData%x_ED(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%xd_ED)) then
      LB(1:1) = lbound(SrcLinStateSaveData%xd_ED)
      UB(1:1) = ubound(SrcLinStateSaveData%xd_ED)
      if (.not. allocated(DstLinStateSaveData%xd_ED)) then
         allocate(DstLinStateSaveData%xd_ED(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%xd_ED.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call ED_CopyDiscState(SrcLinStateSaveData%xd_ED(i1), DstLinStateSaveData%xd_ED(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%z_ED)) then
      LB(1:1) = lbound(SrcLinStateSaveData%z_ED)
      UB(1:1) = ubound(SrcLinStateSaveData%z_ED)
      if (.not. allocated(DstLinStateSaveData%z_ED)) then
         allocate(DstLinStateSaveData%z_ED(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%z_ED.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call ED_CopyConstrState(SrcLinStateSaveData%z_ED(i1), DstLinStateSaveData%z_ED(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%OtherSt_ED)) then
      LB(1:1) = lbound(SrcLinStateSaveData%OtherSt_ED)
      UB(1:1) = ubound(SrcLinStateSaveData%OtherSt_ED)
      if (.not. allocated(DstLinStateSaveData%OtherSt_ED)) then
         allocate(DstLinStateSaveData%OtherSt_ED(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%OtherSt_ED.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call ED_CopyOtherState(SrcLinStateSaveData%OtherSt_ED(i1), DstLinStateSaveData%OtherSt_ED(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%u_ED)) then
      LB(1:1) = lbound(SrcLinStateSaveData%u_ED)
      UB(1:1) = ubound(SrcLinStateSaveData%u_ED)
      if (.not. allocated(DstLinStateSaveData%u_ED)) then
         allocate(DstLinStateSaveData%u_ED(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%u_ED.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call ED_CopyInput(SrcLinStateSaveData%u_ED(i1), DstLinStateSaveData%u_ED(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%x_SrvD)) then
      LB(1:1) = lbound(SrcLinStateSaveData%x_SrvD)
      UB(1:1) = ubound(SrcLinStateSaveData%x_SrvD)
      if (.not. allocated(DstLinStateSaveData%x_SrvD)) then
         allocate(DstLinStateSaveData%x_SrvD(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%x_SrvD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call SrvD_CopyContState(SrcLinStateSaveData%x_SrvD(i1), DstLinStateSaveData%x_SrvD(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%xd_SrvD)) then
      LB(1:1) = lbound(SrcLinStateSaveData%xd_SrvD)
      UB(1:1) = ubound(SrcLinStateSaveData%xd_SrvD)
      if (.not. allocated(DstLinStateSaveData%xd_SrvD)) then
         allocate(DstLinStateSaveData%xd_SrvD(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%xd_SrvD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call SrvD_CopyDiscState(SrcLinStateSaveData%xd_SrvD(i1), DstLinStateSaveData%xd_SrvD(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%z_SrvD)) then
      LB(1:1) = lbound(SrcLinStateSaveData%z_SrvD)
      UB(1:1) = ubound(SrcLinStateSaveData%z_SrvD)
      if (.not. allocated(DstLinStateSaveData%z_SrvD)) then
         allocate(DstLinStateSaveData%z_SrvD(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%z_SrvD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call SrvD_CopyConstrState(SrcLinStateSaveData%z_SrvD(i1), DstLinStateSaveData%z_SrvD(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%OtherSt_SrvD)) then
      LB(1:1) = lbound(SrcLinStateSaveData%OtherSt_SrvD)
      UB(1:1) = ubound(SrcLinStateSaveData%OtherSt_SrvD)
      if (.not. allocated(DstLinStateSaveData%OtherSt_SrvD)) then
         allocate(DstLinStateSaveData%OtherSt_SrvD(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%OtherSt_SrvD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call SrvD_CopyOtherState(SrcLinStateSaveData%OtherSt_SrvD(i1), DstLinStateSaveData%OtherSt_SrvD(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%u_SrvD)) then
      LB(1:1) = lbound(SrcLinStateSaveData%u_SrvD)
      UB(1:1) = ubound(SrcLinStateSaveData%u_SrvD)
      if (.not. allocated(DstLinStateSaveData%u_SrvD)) then
         allocate(DstLinStateSaveData%u_SrvD(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%u_SrvD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call SrvD_CopyInput(SrcLinStateSaveData%u_SrvD(i1), DstLinStateSaveData%u_SrvD(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%x_AD)) then
      LB(1:1) = lbound(SrcLinStateSaveData%x_AD)
      UB(1:1) = ubound(SrcLinStateSaveData%x_AD)
      if (.not. allocated(DstLinStateSaveData%x_AD)) then
         allocate(DstLinStateSaveData%x_AD(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%x_AD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call AD_CopyContState(SrcLinStateSaveData%x_AD(i1), DstLinStateSaveData%x_AD(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%xd_AD)) then
      LB(1:1) = lbound(SrcLinStateSaveData%xd_AD)
      UB(1:1) = ubound(SrcLinStateSaveData%xd_AD)
      if (.not. allocated(DstLinStateSaveData%xd_AD)) then
         allocate(DstLinStateSaveData%xd_AD(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%xd_AD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call AD_CopyDiscState(SrcLinStateSaveData%xd_AD(i1), DstLinStateSaveData%xd_AD(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%z_AD)) then
      LB(1:1) = lbound(SrcLinStateSaveData%z_AD)
      UB(1:1) = ubound(SrcLinStateSaveData%z_AD)
      if (.not. allocated(DstLinStateSaveData%z_AD)) then
         allocate(DstLinStateSaveData%z_AD(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%z_AD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call AD_CopyConstrState(SrcLinStateSaveData%z_AD(i1), DstLinStateSaveData%z_AD(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%OtherSt_AD)) then
      LB(1:1) = lbound(SrcLinStateSaveData%OtherSt_AD)
      UB(1:1) = ubound(SrcLinStateSaveData%OtherSt_AD)
      if (.not. allocated(DstLinStateSaveData%OtherSt_AD)) then
         allocate(DstLinStateSaveData%OtherSt_AD(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%OtherSt_AD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call AD_CopyOtherState(SrcLinStateSaveData%OtherSt_AD(i1), DstLinStateSaveData%OtherSt_AD(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%u_AD)) then
      LB(1:1) = lbound(SrcLinStateSaveData%u_AD)
      UB(1:1) = ubound(SrcLinStateSaveData%u_AD)
      if (.not. allocated(DstLinStateSaveData%u_AD)) then
         allocate(DstLinStateSaveData%u_AD(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%u_AD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call AD_CopyInput(SrcLinStateSaveData%u_AD(i1), DstLinStateSaveData%u_AD(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%x_IfW)) then
      LB(1:1) = lbound(SrcLinStateSaveData%x_IfW)
      UB(1:1) = ubound(SrcLinStateSaveData%x_IfW)
      if (.not. allocated(DstLinStateSaveData%x_IfW)) then
         allocate(DstLinStateSaveData%x_IfW(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%x_IfW.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call InflowWind_CopyContState(SrcLinStateSaveData%x_IfW(i1), DstLinStateSaveData%x_IfW(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%xd_IfW)) then
      LB(1:1) = lbound(SrcLinStateSaveData%xd_IfW)
      UB(1:1) = ubound(SrcLinStateSaveData%xd_IfW)
      if (.not. allocated(DstLinStateSaveData%xd_IfW)) then
         allocate(DstLinStateSaveData%xd_IfW(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%xd_IfW.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call InflowWind_CopyDiscState(SrcLinStateSaveData%xd_IfW(i1), DstLinStateSaveData%xd_IfW(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%z_IfW)) then
      LB(1:1) = lbound(SrcLinStateSaveData%z_IfW)
      UB(1:1) = ubound(SrcLinStateSaveData%z_IfW)
      if (.not. allocated(DstLinStateSaveData%z_IfW)) then
         allocate(DstLinStateSaveData%z_IfW(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%z_IfW.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call InflowWind_CopyConstrState(SrcLinStateSaveData%z_IfW(i1), DstLinStateSaveData%z_IfW(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%OtherSt_IfW)) then
      LB(1:1) = lbound(SrcLinStateSaveData%OtherSt_IfW)
      UB(1:1) = ubound(SrcLinStateSaveData%OtherSt_IfW)
      if (.not. allocated(DstLinStateSaveData%OtherSt_IfW)) then
         allocate(DstLinStateSaveData%OtherSt_IfW(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%OtherSt_IfW.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call InflowWind_CopyOtherState(SrcLinStateSaveData%OtherSt_IfW(i1), DstLinStateSaveData%OtherSt_IfW(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%u_IfW)) then
      LB(1:1) = lbound(SrcLinStateSaveData%u_IfW)
      UB(1:1) = ubound(SrcLinStateSaveData%u_IfW)
      if (.not. allocated(DstLinStateSaveData%u_IfW)) then
         allocate(DstLinStateSaveData%u_IfW(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%u_IfW.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call InflowWind_CopyInput(SrcLinStateSaveData%u_IfW(i1), DstLinStateSaveData%u_IfW(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%x_SD)) then
      LB(1:1) = lbound(SrcLinStateSaveData%x_SD)
      UB(1:1) = ubound(SrcLinStateSaveData%x_SD)
      if (.not. allocated(DstLinStateSaveData%x_SD)) then
         allocate(DstLinStateSaveData%x_SD(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%x_SD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call SD_CopyContState(SrcLinStateSaveData%x_SD(i1), DstLinStateSaveData%x_SD(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%xd_SD)) then
      LB(1:1) = lbound(SrcLinStateSaveData%xd_SD)
      UB(1:1) = ubound(SrcLinStateSaveData%xd_SD)
      if (.not. allocated(DstLinStateSaveData%xd_SD)) then
         allocate(DstLinStateSaveData%xd_SD(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%xd_SD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call SD_CopyDiscState(SrcLinStateSaveData%xd_SD(i1), DstLinStateSaveData%xd_SD(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%z_SD)) then
      LB(1:1) = lbound(SrcLinStateSaveData%z_SD)
      UB(1:1) = ubound(SrcLinStateSaveData%z_SD)
      if (.not. allocated(DstLinStateSaveData%z_SD)) then
         allocate(DstLinStateSaveData%z_SD(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%z_SD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call SD_CopyConstrState(SrcLinStateSaveData%z_SD(i1), DstLinStateSaveData%z_SD(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%OtherSt_SD)) then
      LB(1:1) = lbound(SrcLinStateSaveData%OtherSt_SD)
      UB(1:1) = ubound(SrcLinStateSaveData%OtherSt_SD)
      if (.not. allocated(DstLinStateSaveData%OtherSt_SD)) then
         allocate(DstLinStateSaveData%OtherSt_SD(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%OtherSt_SD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call SD_CopyOtherState(SrcLinStateSaveData%OtherSt_SD(i1), DstLinStateSaveData%OtherSt_SD(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%u_SD)) then
      LB(1:1) = lbound(SrcLinStateSaveData%u_SD)
      UB(1:1) = ubound(SrcLinStateSaveData%u_SD)
      if (.not. allocated(DstLinStateSaveData%u_SD)) then
         allocate(DstLinStateSaveData%u_SD(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%u_SD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call SD_CopyInput(SrcLinStateSaveData%u_SD(i1), DstLinStateSaveData%u_SD(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%x_ExtPtfm)) then
      LB(1:1) = lbound(SrcLinStateSaveData%x_ExtPtfm)
      UB(1:1) = ubound(SrcLinStateSaveData%x_ExtPtfm)
      if (.not. allocated(DstLinStateSaveData%x_ExtPtfm)) then
         allocate(DstLinStateSaveData%x_ExtPtfm(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%x_ExtPtfm.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call ExtPtfm_CopyContState(SrcLinStateSaveData%x_ExtPtfm(i1), DstLinStateSaveData%x_ExtPtfm(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%xd_ExtPtfm)) then
      LB(1:1) = lbound(SrcLinStateSaveData%xd_ExtPtfm)
      UB(1:1) = ubound(SrcLinStateSaveData%xd_ExtPtfm)
      if (.not. allocated(DstLinStateSaveData%xd_ExtPtfm)) then
         allocate(DstLinStateSaveData%xd_ExtPtfm(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%xd_ExtPtfm.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call ExtPtfm_CopyDiscState(SrcLinStateSaveData%xd_ExtPtfm(i1), DstLinStateSaveData%xd_ExtPtfm(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%z_ExtPtfm)) then
      LB(1:1) = lbound(SrcLinStateSaveData%z_ExtPtfm)
      UB(1:1) = ubound(SrcLinStateSaveData%z_ExtPtfm)
      if (.not. allocated(DstLinStateSaveData%z_ExtPtfm)) then
         allocate(DstLinStateSaveData%z_ExtPtfm(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%z_ExtPtfm.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call ExtPtfm_CopyConstrState(SrcLinStateSaveData%z_ExtPtfm(i1), DstLinStateSaveData%z_ExtPtfm(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%OtherSt_ExtPtfm)) then
      LB(1:1) = lbound(SrcLinStateSaveData%OtherSt_ExtPtfm)
      UB(1:1) = ubound(SrcLinStateSaveData%OtherSt_ExtPtfm)
      if (.not. allocated(DstLinStateSaveData%OtherSt_ExtPtfm)) then
         allocate(DstLinStateSaveData%OtherSt_ExtPtfm(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%OtherSt_ExtPtfm.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call ExtPtfm_CopyOtherState(SrcLinStateSaveData%OtherSt_ExtPtfm(i1), DstLinStateSaveData%OtherSt_ExtPtfm(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%u_ExtPtfm)) then
      LB(1:1) = lbound(SrcLinStateSaveData%u_ExtPtfm)
      UB(1:1) = ubound(SrcLinStateSaveData%u_ExtPtfm)
      if (.not. allocated(DstLinStateSaveData%u_ExtPtfm)) then
         allocate(DstLinStateSaveData%u_ExtPtfm(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%u_ExtPtfm.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call ExtPtfm_CopyInput(SrcLinStateSaveData%u_ExtPtfm(i1), DstLinStateSaveData%u_ExtPtfm(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%x_HD)) then
      LB(1:1) = lbound(SrcLinStateSaveData%x_HD)
      UB(1:1) = ubound(SrcLinStateSaveData%x_HD)
      if (.not. allocated(DstLinStateSaveData%x_HD)) then
         allocate(DstLinStateSaveData%x_HD(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%x_HD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call HydroDyn_CopyContState(SrcLinStateSaveData%x_HD(i1), DstLinStateSaveData%x_HD(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%xd_HD)) then
      LB(1:1) = lbound(SrcLinStateSaveData%xd_HD)
      UB(1:1) = ubound(SrcLinStateSaveData%xd_HD)
      if (.not. allocated(DstLinStateSaveData%xd_HD)) then
         allocate(DstLinStateSaveData%xd_HD(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%xd_HD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call HydroDyn_CopyDiscState(SrcLinStateSaveData%xd_HD(i1), DstLinStateSaveData%xd_HD(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%z_HD)) then
      LB(1:1) = lbound(SrcLinStateSaveData%z_HD)
      UB(1:1) = ubound(SrcLinStateSaveData%z_HD)
      if (.not. allocated(DstLinStateSaveData%z_HD)) then
         allocate(DstLinStateSaveData%z_HD(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%z_HD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call HydroDyn_CopyConstrState(SrcLinStateSaveData%z_HD(i1), DstLinStateSaveData%z_HD(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%OtherSt_HD)) then
      LB(1:1) = lbound(SrcLinStateSaveData%OtherSt_HD)
      UB(1:1) = ubound(SrcLinStateSaveData%OtherSt_HD)
      if (.not. allocated(DstLinStateSaveData%OtherSt_HD)) then
         allocate(DstLinStateSaveData%OtherSt_HD(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%OtherSt_HD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call HydroDyn_CopyOtherState(SrcLinStateSaveData%OtherSt_HD(i1), DstLinStateSaveData%OtherSt_HD(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%u_HD)) then
      LB(1:1) = lbound(SrcLinStateSaveData%u_HD)
      UB(1:1) = ubound(SrcLinStateSaveData%u_HD)
      if (.not. allocated(DstLinStateSaveData%u_HD)) then
         allocate(DstLinStateSaveData%u_HD(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%u_HD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call HydroDyn_CopyInput(SrcLinStateSaveData%u_HD(i1), DstLinStateSaveData%u_HD(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%x_SeaSt)) then
      LB(1:1) = lbound(SrcLinStateSaveData%x_SeaSt)
      UB(1:1) = ubound(SrcLinStateSaveData%x_SeaSt)
      if (.not. allocated(DstLinStateSaveData%x_SeaSt)) then
         allocate(DstLinStateSaveData%x_SeaSt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%x_SeaSt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call SeaSt_CopyContState(SrcLinStateSaveData%x_SeaSt(i1), DstLinStateSaveData%x_SeaSt(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%xd_SeaSt)) then
      LB(1:1) = lbound(SrcLinStateSaveData%xd_SeaSt)
      UB(1:1) = ubound(SrcLinStateSaveData%xd_SeaSt)
      if (.not. allocated(DstLinStateSaveData%xd_SeaSt)) then
         allocate(DstLinStateSaveData%xd_SeaSt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%xd_SeaSt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call SeaSt_CopyDiscState(SrcLinStateSaveData%xd_SeaSt(i1), DstLinStateSaveData%xd_SeaSt(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%z_SeaSt)) then
      LB(1:1) = lbound(SrcLinStateSaveData%z_SeaSt)
      UB(1:1) = ubound(SrcLinStateSaveData%z_SeaSt)
      if (.not. allocated(DstLinStateSaveData%z_SeaSt)) then
         allocate(DstLinStateSaveData%z_SeaSt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%z_SeaSt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call SeaSt_CopyConstrState(SrcLinStateSaveData%z_SeaSt(i1), DstLinStateSaveData%z_SeaSt(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%OtherSt_SeaSt)) then
      LB(1:1) = lbound(SrcLinStateSaveData%OtherSt_SeaSt)
      UB(1:1) = ubound(SrcLinStateSaveData%OtherSt_SeaSt)
      if (.not. allocated(DstLinStateSaveData%OtherSt_SeaSt)) then
         allocate(DstLinStateSaveData%OtherSt_SeaSt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%OtherSt_SeaSt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call SeaSt_CopyOtherState(SrcLinStateSaveData%OtherSt_SeaSt(i1), DstLinStateSaveData%OtherSt_SeaSt(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%u_SeaSt)) then
      LB(1:1) = lbound(SrcLinStateSaveData%u_SeaSt)
      UB(1:1) = ubound(SrcLinStateSaveData%u_SeaSt)
      if (.not. allocated(DstLinStateSaveData%u_SeaSt)) then
         allocate(DstLinStateSaveData%u_SeaSt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%u_SeaSt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call SeaSt_CopyInput(SrcLinStateSaveData%u_SeaSt(i1), DstLinStateSaveData%u_SeaSt(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%x_IceF)) then
      LB(1:1) = lbound(SrcLinStateSaveData%x_IceF)
      UB(1:1) = ubound(SrcLinStateSaveData%x_IceF)
      if (.not. allocated(DstLinStateSaveData%x_IceF)) then
         allocate(DstLinStateSaveData%x_IceF(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%x_IceF.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call IceFloe_CopyContState(SrcLinStateSaveData%x_IceF(i1), DstLinStateSaveData%x_IceF(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%xd_IceF)) then
      LB(1:1) = lbound(SrcLinStateSaveData%xd_IceF)
      UB(1:1) = ubound(SrcLinStateSaveData%xd_IceF)
      if (.not. allocated(DstLinStateSaveData%xd_IceF)) then
         allocate(DstLinStateSaveData%xd_IceF(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%xd_IceF.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call IceFloe_CopyDiscState(SrcLinStateSaveData%xd_IceF(i1), DstLinStateSaveData%xd_IceF(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%z_IceF)) then
      LB(1:1) = lbound(SrcLinStateSaveData%z_IceF)
      UB(1:1) = ubound(SrcLinStateSaveData%z_IceF)
      if (.not. allocated(DstLinStateSaveData%z_IceF)) then
         allocate(DstLinStateSaveData%z_IceF(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%z_IceF.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call IceFloe_CopyConstrState(SrcLinStateSaveData%z_IceF(i1), DstLinStateSaveData%z_IceF(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%OtherSt_IceF)) then
      LB(1:1) = lbound(SrcLinStateSaveData%OtherSt_IceF)
      UB(1:1) = ubound(SrcLinStateSaveData%OtherSt_IceF)
      if (.not. allocated(DstLinStateSaveData%OtherSt_IceF)) then
         allocate(DstLinStateSaveData%OtherSt_IceF(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%OtherSt_IceF.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call IceFloe_CopyOtherState(SrcLinStateSaveData%OtherSt_IceF(i1), DstLinStateSaveData%OtherSt_IceF(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%u_IceF)) then
      LB(1:1) = lbound(SrcLinStateSaveData%u_IceF)
      UB(1:1) = ubound(SrcLinStateSaveData%u_IceF)
      if (.not. allocated(DstLinStateSaveData%u_IceF)) then
         allocate(DstLinStateSaveData%u_IceF(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%u_IceF.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call IceFloe_CopyInput(SrcLinStateSaveData%u_IceF(i1), DstLinStateSaveData%u_IceF(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%x_MAP)) then
      LB(1:1) = lbound(SrcLinStateSaveData%x_MAP)
      UB(1:1) = ubound(SrcLinStateSaveData%x_MAP)
      if (.not. allocated(DstLinStateSaveData%x_MAP)) then
         allocate(DstLinStateSaveData%x_MAP(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%x_MAP.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MAP_CopyContState(SrcLinStateSaveData%x_MAP(i1), DstLinStateSaveData%x_MAP(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%xd_MAP)) then
      LB(1:1) = lbound(SrcLinStateSaveData%xd_MAP)
      UB(1:1) = ubound(SrcLinStateSaveData%xd_MAP)
      if (.not. allocated(DstLinStateSaveData%xd_MAP)) then
         allocate(DstLinStateSaveData%xd_MAP(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%xd_MAP.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MAP_CopyDiscState(SrcLinStateSaveData%xd_MAP(i1), DstLinStateSaveData%xd_MAP(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%z_MAP)) then
      LB(1:1) = lbound(SrcLinStateSaveData%z_MAP)
      UB(1:1) = ubound(SrcLinStateSaveData%z_MAP)
      if (.not. allocated(DstLinStateSaveData%z_MAP)) then
         allocate(DstLinStateSaveData%z_MAP(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%z_MAP.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MAP_CopyConstrState(SrcLinStateSaveData%z_MAP(i1), DstLinStateSaveData%z_MAP(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%u_MAP)) then
      LB(1:1) = lbound(SrcLinStateSaveData%u_MAP)
      UB(1:1) = ubound(SrcLinStateSaveData%u_MAP)
      if (.not. allocated(DstLinStateSaveData%u_MAP)) then
         allocate(DstLinStateSaveData%u_MAP(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%u_MAP.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MAP_CopyInput(SrcLinStateSaveData%u_MAP(i1), DstLinStateSaveData%u_MAP(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%x_FEAM)) then
      LB(1:1) = lbound(SrcLinStateSaveData%x_FEAM)
      UB(1:1) = ubound(SrcLinStateSaveData%x_FEAM)
      if (.not. allocated(DstLinStateSaveData%x_FEAM)) then
         allocate(DstLinStateSaveData%x_FEAM(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%x_FEAM.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call FEAM_CopyContState(SrcLinStateSaveData%x_FEAM(i1), DstLinStateSaveData%x_FEAM(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%xd_FEAM)) then
      LB(1:1) = lbound(SrcLinStateSaveData%xd_FEAM)
      UB(1:1) = ubound(SrcLinStateSaveData%xd_FEAM)
      if (.not. allocated(DstLinStateSaveData%xd_FEAM)) then
         allocate(DstLinStateSaveData%xd_FEAM(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%xd_FEAM.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call FEAM_CopyDiscState(SrcLinStateSaveData%xd_FEAM(i1), DstLinStateSaveData%xd_FEAM(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%z_FEAM)) then
      LB(1:1) = lbound(SrcLinStateSaveData%z_FEAM)
      UB(1:1) = ubound(SrcLinStateSaveData%z_FEAM)
      if (.not. allocated(DstLinStateSaveData%z_FEAM)) then
         allocate(DstLinStateSaveData%z_FEAM(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%z_FEAM.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call FEAM_CopyConstrState(SrcLinStateSaveData%z_FEAM(i1), DstLinStateSaveData%z_FEAM(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%OtherSt_FEAM)) then
      LB(1:1) = lbound(SrcLinStateSaveData%OtherSt_FEAM)
      UB(1:1) = ubound(SrcLinStateSaveData%OtherSt_FEAM)
      if (.not. allocated(DstLinStateSaveData%OtherSt_FEAM)) then
         allocate(DstLinStateSaveData%OtherSt_FEAM(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%OtherSt_FEAM.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call FEAM_CopyOtherState(SrcLinStateSaveData%OtherSt_FEAM(i1), DstLinStateSaveData%OtherSt_FEAM(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%u_FEAM)) then
      LB(1:1) = lbound(SrcLinStateSaveData%u_FEAM)
      UB(1:1) = ubound(SrcLinStateSaveData%u_FEAM)
      if (.not. allocated(DstLinStateSaveData%u_FEAM)) then
         allocate(DstLinStateSaveData%u_FEAM(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%u_FEAM.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call FEAM_CopyInput(SrcLinStateSaveData%u_FEAM(i1), DstLinStateSaveData%u_FEAM(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%x_MD)) then
      LB(1:1) = lbound(SrcLinStateSaveData%x_MD)
      UB(1:1) = ubound(SrcLinStateSaveData%x_MD)
      if (.not. allocated(DstLinStateSaveData%x_MD)) then
         allocate(DstLinStateSaveData%x_MD(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%x_MD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MD_CopyContState(SrcLinStateSaveData%x_MD(i1), DstLinStateSaveData%x_MD(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%xd_MD)) then
      LB(1:1) = lbound(SrcLinStateSaveData%xd_MD)
      UB(1:1) = ubound(SrcLinStateSaveData%xd_MD)
      if (.not. allocated(DstLinStateSaveData%xd_MD)) then
         allocate(DstLinStateSaveData%xd_MD(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%xd_MD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MD_CopyDiscState(SrcLinStateSaveData%xd_MD(i1), DstLinStateSaveData%xd_MD(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%z_MD)) then
      LB(1:1) = lbound(SrcLinStateSaveData%z_MD)
      UB(1:1) = ubound(SrcLinStateSaveData%z_MD)
      if (.not. allocated(DstLinStateSaveData%z_MD)) then
         allocate(DstLinStateSaveData%z_MD(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%z_MD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MD_CopyConstrState(SrcLinStateSaveData%z_MD(i1), DstLinStateSaveData%z_MD(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%OtherSt_MD)) then
      LB(1:1) = lbound(SrcLinStateSaveData%OtherSt_MD)
      UB(1:1) = ubound(SrcLinStateSaveData%OtherSt_MD)
      if (.not. allocated(DstLinStateSaveData%OtherSt_MD)) then
         allocate(DstLinStateSaveData%OtherSt_MD(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%OtherSt_MD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MD_CopyOtherState(SrcLinStateSaveData%OtherSt_MD(i1), DstLinStateSaveData%OtherSt_MD(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcLinStateSaveData%u_MD)) then
      LB(1:1) = lbound(SrcLinStateSaveData%u_MD)
      UB(1:1) = ubound(SrcLinStateSaveData%u_MD)
      if (.not. allocated(DstLinStateSaveData%u_MD)) then
         allocate(DstLinStateSaveData%u_MD(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinStateSaveData%u_MD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MD_CopyInput(SrcLinStateSaveData%u_MD(i1), DstLinStateSaveData%u_MD(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
end subroutine

subroutine FAST_DestroyLinStateSave(LinStateSaveData, ErrStat, ErrMsg)
   type(FAST_LinStateSave), intent(inout) :: LinStateSaveData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_DestroyLinStateSave'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(LinStateSaveData%x_IceD)) then
      LB(1:2) = lbound(LinStateSaveData%x_IceD)
      UB(1:2) = ubound(LinStateSaveData%x_IceD)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_DestroyContState(LinStateSaveData%x_IceD(i1,i2), ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         end do
      end do
      deallocate(LinStateSaveData%x_IceD)
   end if
   if (allocated(LinStateSaveData%xd_IceD)) then
      LB(1:2) = lbound(LinStateSaveData%xd_IceD)
      UB(1:2) = ubound(LinStateSaveData%xd_IceD)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_DestroyDiscState(LinStateSaveData%xd_IceD(i1,i2), ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         end do
      end do
      deallocate(LinStateSaveData%xd_IceD)
   end if
   if (allocated(LinStateSaveData%z_IceD)) then
      LB(1:2) = lbound(LinStateSaveData%z_IceD)
      UB(1:2) = ubound(LinStateSaveData%z_IceD)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_DestroyConstrState(LinStateSaveData%z_IceD(i1,i2), ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         end do
      end do
      deallocate(LinStateSaveData%z_IceD)
   end if
   if (allocated(LinStateSaveData%OtherSt_IceD)) then
      LB(1:2) = lbound(LinStateSaveData%OtherSt_IceD)
      UB(1:2) = ubound(LinStateSaveData%OtherSt_IceD)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_DestroyOtherState(LinStateSaveData%OtherSt_IceD(i1,i2), ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         end do
      end do
      deallocate(LinStateSaveData%OtherSt_IceD)
   end if
   if (allocated(LinStateSaveData%u_IceD)) then
      LB(1:2) = lbound(LinStateSaveData%u_IceD)
      UB(1:2) = ubound(LinStateSaveData%u_IceD)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_DestroyInput(LinStateSaveData%u_IceD(i1,i2), ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         end do
      end do
      deallocate(LinStateSaveData%u_IceD)
   end if
   if (allocated(LinStateSaveData%x_BD)) then
      LB(1:2) = lbound(LinStateSaveData%x_BD)
      UB(1:2) = ubound(LinStateSaveData%x_BD)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_DestroyContState(LinStateSaveData%x_BD(i1,i2), ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         end do
      end do
      deallocate(LinStateSaveData%x_BD)
   end if
   if (allocated(LinStateSaveData%xd_BD)) then
      LB(1:2) = lbound(LinStateSaveData%xd_BD)
      UB(1:2) = ubound(LinStateSaveData%xd_BD)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_DestroyDiscState(LinStateSaveData%xd_BD(i1,i2), ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         end do
      end do
      deallocate(LinStateSaveData%xd_BD)
   end if
   if (allocated(LinStateSaveData%z_BD)) then
      LB(1:2) = lbound(LinStateSaveData%z_BD)
      UB(1:2) = ubound(LinStateSaveData%z_BD)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_DestroyConstrState(LinStateSaveData%z_BD(i1,i2), ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         end do
      end do
      deallocate(LinStateSaveData%z_BD)
   end if
   if (allocated(LinStateSaveData%OtherSt_BD)) then
      LB(1:2) = lbound(LinStateSaveData%OtherSt_BD)
      UB(1:2) = ubound(LinStateSaveData%OtherSt_BD)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_DestroyOtherState(LinStateSaveData%OtherSt_BD(i1,i2), ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         end do
      end do
      deallocate(LinStateSaveData%OtherSt_BD)
   end if
   if (allocated(LinStateSaveData%u_BD)) then
      LB(1:2) = lbound(LinStateSaveData%u_BD)
      UB(1:2) = ubound(LinStateSaveData%u_BD)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_DestroyInput(LinStateSaveData%u_BD(i1,i2), ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         end do
      end do
      deallocate(LinStateSaveData%u_BD)
   end if
   if (allocated(LinStateSaveData%x_ED)) then
      LB(1:1) = lbound(LinStateSaveData%x_ED)
      UB(1:1) = ubound(LinStateSaveData%x_ED)
      do i1 = LB(1), UB(1)
         call ED_DestroyContState(LinStateSaveData%x_ED(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%x_ED)
   end if
   if (allocated(LinStateSaveData%xd_ED)) then
      LB(1:1) = lbound(LinStateSaveData%xd_ED)
      UB(1:1) = ubound(LinStateSaveData%xd_ED)
      do i1 = LB(1), UB(1)
         call ED_DestroyDiscState(LinStateSaveData%xd_ED(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%xd_ED)
   end if
   if (allocated(LinStateSaveData%z_ED)) then
      LB(1:1) = lbound(LinStateSaveData%z_ED)
      UB(1:1) = ubound(LinStateSaveData%z_ED)
      do i1 = LB(1), UB(1)
         call ED_DestroyConstrState(LinStateSaveData%z_ED(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%z_ED)
   end if
   if (allocated(LinStateSaveData%OtherSt_ED)) then
      LB(1:1) = lbound(LinStateSaveData%OtherSt_ED)
      UB(1:1) = ubound(LinStateSaveData%OtherSt_ED)
      do i1 = LB(1), UB(1)
         call ED_DestroyOtherState(LinStateSaveData%OtherSt_ED(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%OtherSt_ED)
   end if
   if (allocated(LinStateSaveData%u_ED)) then
      LB(1:1) = lbound(LinStateSaveData%u_ED)
      UB(1:1) = ubound(LinStateSaveData%u_ED)
      do i1 = LB(1), UB(1)
         call ED_DestroyInput(LinStateSaveData%u_ED(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%u_ED)
   end if
   if (allocated(LinStateSaveData%x_SrvD)) then
      LB(1:1) = lbound(LinStateSaveData%x_SrvD)
      UB(1:1) = ubound(LinStateSaveData%x_SrvD)
      do i1 = LB(1), UB(1)
         call SrvD_DestroyContState(LinStateSaveData%x_SrvD(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%x_SrvD)
   end if
   if (allocated(LinStateSaveData%xd_SrvD)) then
      LB(1:1) = lbound(LinStateSaveData%xd_SrvD)
      UB(1:1) = ubound(LinStateSaveData%xd_SrvD)
      do i1 = LB(1), UB(1)
         call SrvD_DestroyDiscState(LinStateSaveData%xd_SrvD(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%xd_SrvD)
   end if
   if (allocated(LinStateSaveData%z_SrvD)) then
      LB(1:1) = lbound(LinStateSaveData%z_SrvD)
      UB(1:1) = ubound(LinStateSaveData%z_SrvD)
      do i1 = LB(1), UB(1)
         call SrvD_DestroyConstrState(LinStateSaveData%z_SrvD(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%z_SrvD)
   end if
   if (allocated(LinStateSaveData%OtherSt_SrvD)) then
      LB(1:1) = lbound(LinStateSaveData%OtherSt_SrvD)
      UB(1:1) = ubound(LinStateSaveData%OtherSt_SrvD)
      do i1 = LB(1), UB(1)
         call SrvD_DestroyOtherState(LinStateSaveData%OtherSt_SrvD(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%OtherSt_SrvD)
   end if
   if (allocated(LinStateSaveData%u_SrvD)) then
      LB(1:1) = lbound(LinStateSaveData%u_SrvD)
      UB(1:1) = ubound(LinStateSaveData%u_SrvD)
      do i1 = LB(1), UB(1)
         call SrvD_DestroyInput(LinStateSaveData%u_SrvD(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%u_SrvD)
   end if
   if (allocated(LinStateSaveData%x_AD)) then
      LB(1:1) = lbound(LinStateSaveData%x_AD)
      UB(1:1) = ubound(LinStateSaveData%x_AD)
      do i1 = LB(1), UB(1)
         call AD_DestroyContState(LinStateSaveData%x_AD(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%x_AD)
   end if
   if (allocated(LinStateSaveData%xd_AD)) then
      LB(1:1) = lbound(LinStateSaveData%xd_AD)
      UB(1:1) = ubound(LinStateSaveData%xd_AD)
      do i1 = LB(1), UB(1)
         call AD_DestroyDiscState(LinStateSaveData%xd_AD(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%xd_AD)
   end if
   if (allocated(LinStateSaveData%z_AD)) then
      LB(1:1) = lbound(LinStateSaveData%z_AD)
      UB(1:1) = ubound(LinStateSaveData%z_AD)
      do i1 = LB(1), UB(1)
         call AD_DestroyConstrState(LinStateSaveData%z_AD(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%z_AD)
   end if
   if (allocated(LinStateSaveData%OtherSt_AD)) then
      LB(1:1) = lbound(LinStateSaveData%OtherSt_AD)
      UB(1:1) = ubound(LinStateSaveData%OtherSt_AD)
      do i1 = LB(1), UB(1)
         call AD_DestroyOtherState(LinStateSaveData%OtherSt_AD(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%OtherSt_AD)
   end if
   if (allocated(LinStateSaveData%u_AD)) then
      LB(1:1) = lbound(LinStateSaveData%u_AD)
      UB(1:1) = ubound(LinStateSaveData%u_AD)
      do i1 = LB(1), UB(1)
         call AD_DestroyInput(LinStateSaveData%u_AD(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%u_AD)
   end if
   if (allocated(LinStateSaveData%x_IfW)) then
      LB(1:1) = lbound(LinStateSaveData%x_IfW)
      UB(1:1) = ubound(LinStateSaveData%x_IfW)
      do i1 = LB(1), UB(1)
         call InflowWind_DestroyContState(LinStateSaveData%x_IfW(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%x_IfW)
   end if
   if (allocated(LinStateSaveData%xd_IfW)) then
      LB(1:1) = lbound(LinStateSaveData%xd_IfW)
      UB(1:1) = ubound(LinStateSaveData%xd_IfW)
      do i1 = LB(1), UB(1)
         call InflowWind_DestroyDiscState(LinStateSaveData%xd_IfW(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%xd_IfW)
   end if
   if (allocated(LinStateSaveData%z_IfW)) then
      LB(1:1) = lbound(LinStateSaveData%z_IfW)
      UB(1:1) = ubound(LinStateSaveData%z_IfW)
      do i1 = LB(1), UB(1)
         call InflowWind_DestroyConstrState(LinStateSaveData%z_IfW(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%z_IfW)
   end if
   if (allocated(LinStateSaveData%OtherSt_IfW)) then
      LB(1:1) = lbound(LinStateSaveData%OtherSt_IfW)
      UB(1:1) = ubound(LinStateSaveData%OtherSt_IfW)
      do i1 = LB(1), UB(1)
         call InflowWind_DestroyOtherState(LinStateSaveData%OtherSt_IfW(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%OtherSt_IfW)
   end if
   if (allocated(LinStateSaveData%u_IfW)) then
      LB(1:1) = lbound(LinStateSaveData%u_IfW)
      UB(1:1) = ubound(LinStateSaveData%u_IfW)
      do i1 = LB(1), UB(1)
         call InflowWind_DestroyInput(LinStateSaveData%u_IfW(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%u_IfW)
   end if
   if (allocated(LinStateSaveData%x_SD)) then
      LB(1:1) = lbound(LinStateSaveData%x_SD)
      UB(1:1) = ubound(LinStateSaveData%x_SD)
      do i1 = LB(1), UB(1)
         call SD_DestroyContState(LinStateSaveData%x_SD(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%x_SD)
   end if
   if (allocated(LinStateSaveData%xd_SD)) then
      LB(1:1) = lbound(LinStateSaveData%xd_SD)
      UB(1:1) = ubound(LinStateSaveData%xd_SD)
      do i1 = LB(1), UB(1)
         call SD_DestroyDiscState(LinStateSaveData%xd_SD(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%xd_SD)
   end if
   if (allocated(LinStateSaveData%z_SD)) then
      LB(1:1) = lbound(LinStateSaveData%z_SD)
      UB(1:1) = ubound(LinStateSaveData%z_SD)
      do i1 = LB(1), UB(1)
         call SD_DestroyConstrState(LinStateSaveData%z_SD(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%z_SD)
   end if
   if (allocated(LinStateSaveData%OtherSt_SD)) then
      LB(1:1) = lbound(LinStateSaveData%OtherSt_SD)
      UB(1:1) = ubound(LinStateSaveData%OtherSt_SD)
      do i1 = LB(1), UB(1)
         call SD_DestroyOtherState(LinStateSaveData%OtherSt_SD(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%OtherSt_SD)
   end if
   if (allocated(LinStateSaveData%u_SD)) then
      LB(1:1) = lbound(LinStateSaveData%u_SD)
      UB(1:1) = ubound(LinStateSaveData%u_SD)
      do i1 = LB(1), UB(1)
         call SD_DestroyInput(LinStateSaveData%u_SD(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%u_SD)
   end if
   if (allocated(LinStateSaveData%x_ExtPtfm)) then
      LB(1:1) = lbound(LinStateSaveData%x_ExtPtfm)
      UB(1:1) = ubound(LinStateSaveData%x_ExtPtfm)
      do i1 = LB(1), UB(1)
         call ExtPtfm_DestroyContState(LinStateSaveData%x_ExtPtfm(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%x_ExtPtfm)
   end if
   if (allocated(LinStateSaveData%xd_ExtPtfm)) then
      LB(1:1) = lbound(LinStateSaveData%xd_ExtPtfm)
      UB(1:1) = ubound(LinStateSaveData%xd_ExtPtfm)
      do i1 = LB(1), UB(1)
         call ExtPtfm_DestroyDiscState(LinStateSaveData%xd_ExtPtfm(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%xd_ExtPtfm)
   end if
   if (allocated(LinStateSaveData%z_ExtPtfm)) then
      LB(1:1) = lbound(LinStateSaveData%z_ExtPtfm)
      UB(1:1) = ubound(LinStateSaveData%z_ExtPtfm)
      do i1 = LB(1), UB(1)
         call ExtPtfm_DestroyConstrState(LinStateSaveData%z_ExtPtfm(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%z_ExtPtfm)
   end if
   if (allocated(LinStateSaveData%OtherSt_ExtPtfm)) then
      LB(1:1) = lbound(LinStateSaveData%OtherSt_ExtPtfm)
      UB(1:1) = ubound(LinStateSaveData%OtherSt_ExtPtfm)
      do i1 = LB(1), UB(1)
         call ExtPtfm_DestroyOtherState(LinStateSaveData%OtherSt_ExtPtfm(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%OtherSt_ExtPtfm)
   end if
   if (allocated(LinStateSaveData%u_ExtPtfm)) then
      LB(1:1) = lbound(LinStateSaveData%u_ExtPtfm)
      UB(1:1) = ubound(LinStateSaveData%u_ExtPtfm)
      do i1 = LB(1), UB(1)
         call ExtPtfm_DestroyInput(LinStateSaveData%u_ExtPtfm(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%u_ExtPtfm)
   end if
   if (allocated(LinStateSaveData%x_HD)) then
      LB(1:1) = lbound(LinStateSaveData%x_HD)
      UB(1:1) = ubound(LinStateSaveData%x_HD)
      do i1 = LB(1), UB(1)
         call HydroDyn_DestroyContState(LinStateSaveData%x_HD(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%x_HD)
   end if
   if (allocated(LinStateSaveData%xd_HD)) then
      LB(1:1) = lbound(LinStateSaveData%xd_HD)
      UB(1:1) = ubound(LinStateSaveData%xd_HD)
      do i1 = LB(1), UB(1)
         call HydroDyn_DestroyDiscState(LinStateSaveData%xd_HD(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%xd_HD)
   end if
   if (allocated(LinStateSaveData%z_HD)) then
      LB(1:1) = lbound(LinStateSaveData%z_HD)
      UB(1:1) = ubound(LinStateSaveData%z_HD)
      do i1 = LB(1), UB(1)
         call HydroDyn_DestroyConstrState(LinStateSaveData%z_HD(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%z_HD)
   end if
   if (allocated(LinStateSaveData%OtherSt_HD)) then
      LB(1:1) = lbound(LinStateSaveData%OtherSt_HD)
      UB(1:1) = ubound(LinStateSaveData%OtherSt_HD)
      do i1 = LB(1), UB(1)
         call HydroDyn_DestroyOtherState(LinStateSaveData%OtherSt_HD(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%OtherSt_HD)
   end if
   if (allocated(LinStateSaveData%u_HD)) then
      LB(1:1) = lbound(LinStateSaveData%u_HD)
      UB(1:1) = ubound(LinStateSaveData%u_HD)
      do i1 = LB(1), UB(1)
         call HydroDyn_DestroyInput(LinStateSaveData%u_HD(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%u_HD)
   end if
   if (allocated(LinStateSaveData%x_SeaSt)) then
      LB(1:1) = lbound(LinStateSaveData%x_SeaSt)
      UB(1:1) = ubound(LinStateSaveData%x_SeaSt)
      do i1 = LB(1), UB(1)
         call SeaSt_DestroyContState(LinStateSaveData%x_SeaSt(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%x_SeaSt)
   end if
   if (allocated(LinStateSaveData%xd_SeaSt)) then
      LB(1:1) = lbound(LinStateSaveData%xd_SeaSt)
      UB(1:1) = ubound(LinStateSaveData%xd_SeaSt)
      do i1 = LB(1), UB(1)
         call SeaSt_DestroyDiscState(LinStateSaveData%xd_SeaSt(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%xd_SeaSt)
   end if
   if (allocated(LinStateSaveData%z_SeaSt)) then
      LB(1:1) = lbound(LinStateSaveData%z_SeaSt)
      UB(1:1) = ubound(LinStateSaveData%z_SeaSt)
      do i1 = LB(1), UB(1)
         call SeaSt_DestroyConstrState(LinStateSaveData%z_SeaSt(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%z_SeaSt)
   end if
   if (allocated(LinStateSaveData%OtherSt_SeaSt)) then
      LB(1:1) = lbound(LinStateSaveData%OtherSt_SeaSt)
      UB(1:1) = ubound(LinStateSaveData%OtherSt_SeaSt)
      do i1 = LB(1), UB(1)
         call SeaSt_DestroyOtherState(LinStateSaveData%OtherSt_SeaSt(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%OtherSt_SeaSt)
   end if
   if (allocated(LinStateSaveData%u_SeaSt)) then
      LB(1:1) = lbound(LinStateSaveData%u_SeaSt)
      UB(1:1) = ubound(LinStateSaveData%u_SeaSt)
      do i1 = LB(1), UB(1)
         call SeaSt_DestroyInput(LinStateSaveData%u_SeaSt(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%u_SeaSt)
   end if
   if (allocated(LinStateSaveData%x_IceF)) then
      LB(1:1) = lbound(LinStateSaveData%x_IceF)
      UB(1:1) = ubound(LinStateSaveData%x_IceF)
      do i1 = LB(1), UB(1)
         call IceFloe_DestroyContState(LinStateSaveData%x_IceF(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%x_IceF)
   end if
   if (allocated(LinStateSaveData%xd_IceF)) then
      LB(1:1) = lbound(LinStateSaveData%xd_IceF)
      UB(1:1) = ubound(LinStateSaveData%xd_IceF)
      do i1 = LB(1), UB(1)
         call IceFloe_DestroyDiscState(LinStateSaveData%xd_IceF(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%xd_IceF)
   end if
   if (allocated(LinStateSaveData%z_IceF)) then
      LB(1:1) = lbound(LinStateSaveData%z_IceF)
      UB(1:1) = ubound(LinStateSaveData%z_IceF)
      do i1 = LB(1), UB(1)
         call IceFloe_DestroyConstrState(LinStateSaveData%z_IceF(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%z_IceF)
   end if
   if (allocated(LinStateSaveData%OtherSt_IceF)) then
      LB(1:1) = lbound(LinStateSaveData%OtherSt_IceF)
      UB(1:1) = ubound(LinStateSaveData%OtherSt_IceF)
      do i1 = LB(1), UB(1)
         call IceFloe_DestroyOtherState(LinStateSaveData%OtherSt_IceF(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%OtherSt_IceF)
   end if
   if (allocated(LinStateSaveData%u_IceF)) then
      LB(1:1) = lbound(LinStateSaveData%u_IceF)
      UB(1:1) = ubound(LinStateSaveData%u_IceF)
      do i1 = LB(1), UB(1)
         call IceFloe_DestroyInput(LinStateSaveData%u_IceF(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%u_IceF)
   end if
   if (allocated(LinStateSaveData%x_MAP)) then
      LB(1:1) = lbound(LinStateSaveData%x_MAP)
      UB(1:1) = ubound(LinStateSaveData%x_MAP)
      do i1 = LB(1), UB(1)
         call MAP_DestroyContState(LinStateSaveData%x_MAP(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%x_MAP)
   end if
   if (allocated(LinStateSaveData%xd_MAP)) then
      LB(1:1) = lbound(LinStateSaveData%xd_MAP)
      UB(1:1) = ubound(LinStateSaveData%xd_MAP)
      do i1 = LB(1), UB(1)
         call MAP_DestroyDiscState(LinStateSaveData%xd_MAP(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%xd_MAP)
   end if
   if (allocated(LinStateSaveData%z_MAP)) then
      LB(1:1) = lbound(LinStateSaveData%z_MAP)
      UB(1:1) = ubound(LinStateSaveData%z_MAP)
      do i1 = LB(1), UB(1)
         call MAP_DestroyConstrState(LinStateSaveData%z_MAP(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%z_MAP)
   end if
   if (allocated(LinStateSaveData%u_MAP)) then
      LB(1:1) = lbound(LinStateSaveData%u_MAP)
      UB(1:1) = ubound(LinStateSaveData%u_MAP)
      do i1 = LB(1), UB(1)
         call MAP_DestroyInput(LinStateSaveData%u_MAP(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%u_MAP)
   end if
   if (allocated(LinStateSaveData%x_FEAM)) then
      LB(1:1) = lbound(LinStateSaveData%x_FEAM)
      UB(1:1) = ubound(LinStateSaveData%x_FEAM)
      do i1 = LB(1), UB(1)
         call FEAM_DestroyContState(LinStateSaveData%x_FEAM(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%x_FEAM)
   end if
   if (allocated(LinStateSaveData%xd_FEAM)) then
      LB(1:1) = lbound(LinStateSaveData%xd_FEAM)
      UB(1:1) = ubound(LinStateSaveData%xd_FEAM)
      do i1 = LB(1), UB(1)
         call FEAM_DestroyDiscState(LinStateSaveData%xd_FEAM(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%xd_FEAM)
   end if
   if (allocated(LinStateSaveData%z_FEAM)) then
      LB(1:1) = lbound(LinStateSaveData%z_FEAM)
      UB(1:1) = ubound(LinStateSaveData%z_FEAM)
      do i1 = LB(1), UB(1)
         call FEAM_DestroyConstrState(LinStateSaveData%z_FEAM(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%z_FEAM)
   end if
   if (allocated(LinStateSaveData%OtherSt_FEAM)) then
      LB(1:1) = lbound(LinStateSaveData%OtherSt_FEAM)
      UB(1:1) = ubound(LinStateSaveData%OtherSt_FEAM)
      do i1 = LB(1), UB(1)
         call FEAM_DestroyOtherState(LinStateSaveData%OtherSt_FEAM(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%OtherSt_FEAM)
   end if
   if (allocated(LinStateSaveData%u_FEAM)) then
      LB(1:1) = lbound(LinStateSaveData%u_FEAM)
      UB(1:1) = ubound(LinStateSaveData%u_FEAM)
      do i1 = LB(1), UB(1)
         call FEAM_DestroyInput(LinStateSaveData%u_FEAM(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%u_FEAM)
   end if
   if (allocated(LinStateSaveData%x_MD)) then
      LB(1:1) = lbound(LinStateSaveData%x_MD)
      UB(1:1) = ubound(LinStateSaveData%x_MD)
      do i1 = LB(1), UB(1)
         call MD_DestroyContState(LinStateSaveData%x_MD(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%x_MD)
   end if
   if (allocated(LinStateSaveData%xd_MD)) then
      LB(1:1) = lbound(LinStateSaveData%xd_MD)
      UB(1:1) = ubound(LinStateSaveData%xd_MD)
      do i1 = LB(1), UB(1)
         call MD_DestroyDiscState(LinStateSaveData%xd_MD(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%xd_MD)
   end if
   if (allocated(LinStateSaveData%z_MD)) then
      LB(1:1) = lbound(LinStateSaveData%z_MD)
      UB(1:1) = ubound(LinStateSaveData%z_MD)
      do i1 = LB(1), UB(1)
         call MD_DestroyConstrState(LinStateSaveData%z_MD(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%z_MD)
   end if
   if (allocated(LinStateSaveData%OtherSt_MD)) then
      LB(1:1) = lbound(LinStateSaveData%OtherSt_MD)
      UB(1:1) = ubound(LinStateSaveData%OtherSt_MD)
      do i1 = LB(1), UB(1)
         call MD_DestroyOtherState(LinStateSaveData%OtherSt_MD(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%OtherSt_MD)
   end if
   if (allocated(LinStateSaveData%u_MD)) then
      LB(1:1) = lbound(LinStateSaveData%u_MD)
      UB(1:1) = ubound(LinStateSaveData%u_MD)
      do i1 = LB(1), UB(1)
         call MD_DestroyInput(LinStateSaveData%u_MD(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(LinStateSaveData%u_MD)
   end if
end subroutine

subroutine FAST_PackLinStateSave(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FAST_LinStateSave), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FAST_PackLinStateSave'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%x_IceD))
   if (allocated(InData%x_IceD)) then
      call RegPackBounds(RF, 2, lbound(InData%x_IceD), ubound(InData%x_IceD))
      LB(1:2) = lbound(InData%x_IceD)
      UB(1:2) = ubound(InData%x_IceD)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_PackContState(RF, InData%x_IceD(i1,i2)) 
         end do
      end do
   end if
   call RegPack(RF, allocated(InData%xd_IceD))
   if (allocated(InData%xd_IceD)) then
      call RegPackBounds(RF, 2, lbound(InData%xd_IceD), ubound(InData%xd_IceD))
      LB(1:2) = lbound(InData%xd_IceD)
      UB(1:2) = ubound(InData%xd_IceD)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_PackDiscState(RF, InData%xd_IceD(i1,i2)) 
         end do
      end do
   end if
   call RegPack(RF, allocated(InData%z_IceD))
   if (allocated(InData%z_IceD)) then
      call RegPackBounds(RF, 2, lbound(InData%z_IceD), ubound(InData%z_IceD))
      LB(1:2) = lbound(InData%z_IceD)
      UB(1:2) = ubound(InData%z_IceD)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_PackConstrState(RF, InData%z_IceD(i1,i2)) 
         end do
      end do
   end if
   call RegPack(RF, allocated(InData%OtherSt_IceD))
   if (allocated(InData%OtherSt_IceD)) then
      call RegPackBounds(RF, 2, lbound(InData%OtherSt_IceD), ubound(InData%OtherSt_IceD))
      LB(1:2) = lbound(InData%OtherSt_IceD)
      UB(1:2) = ubound(InData%OtherSt_IceD)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_PackOtherState(RF, InData%OtherSt_IceD(i1,i2)) 
         end do
      end do
   end if
   call RegPack(RF, allocated(InData%u_IceD))
   if (allocated(InData%u_IceD)) then
      call RegPackBounds(RF, 2, lbound(InData%u_IceD), ubound(InData%u_IceD))
      LB(1:2) = lbound(InData%u_IceD)
      UB(1:2) = ubound(InData%u_IceD)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_PackInput(RF, InData%u_IceD(i1,i2)) 
         end do
      end do
   end if
   call RegPack(RF, allocated(InData%x_BD))
   if (allocated(InData%x_BD)) then
      call RegPackBounds(RF, 2, lbound(InData%x_BD), ubound(InData%x_BD))
      LB(1:2) = lbound(InData%x_BD)
      UB(1:2) = ubound(InData%x_BD)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_PackContState(RF, InData%x_BD(i1,i2)) 
         end do
      end do
   end if
   call RegPack(RF, allocated(InData%xd_BD))
   if (allocated(InData%xd_BD)) then
      call RegPackBounds(RF, 2, lbound(InData%xd_BD), ubound(InData%xd_BD))
      LB(1:2) = lbound(InData%xd_BD)
      UB(1:2) = ubound(InData%xd_BD)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_PackDiscState(RF, InData%xd_BD(i1,i2)) 
         end do
      end do
   end if
   call RegPack(RF, allocated(InData%z_BD))
   if (allocated(InData%z_BD)) then
      call RegPackBounds(RF, 2, lbound(InData%z_BD), ubound(InData%z_BD))
      LB(1:2) = lbound(InData%z_BD)
      UB(1:2) = ubound(InData%z_BD)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_PackConstrState(RF, InData%z_BD(i1,i2)) 
         end do
      end do
   end if
   call RegPack(RF, allocated(InData%OtherSt_BD))
   if (allocated(InData%OtherSt_BD)) then
      call RegPackBounds(RF, 2, lbound(InData%OtherSt_BD), ubound(InData%OtherSt_BD))
      LB(1:2) = lbound(InData%OtherSt_BD)
      UB(1:2) = ubound(InData%OtherSt_BD)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_PackOtherState(RF, InData%OtherSt_BD(i1,i2)) 
         end do
      end do
   end if
   call RegPack(RF, allocated(InData%u_BD))
   if (allocated(InData%u_BD)) then
      call RegPackBounds(RF, 2, lbound(InData%u_BD), ubound(InData%u_BD))
      LB(1:2) = lbound(InData%u_BD)
      UB(1:2) = ubound(InData%u_BD)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_PackInput(RF, InData%u_BD(i1,i2)) 
         end do
      end do
   end if
   call RegPack(RF, allocated(InData%x_ED))
   if (allocated(InData%x_ED)) then
      call RegPackBounds(RF, 1, lbound(InData%x_ED), ubound(InData%x_ED))
      LB(1:1) = lbound(InData%x_ED)
      UB(1:1) = ubound(InData%x_ED)
      do i1 = LB(1), UB(1)
         call ED_PackContState(RF, InData%x_ED(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%xd_ED))
   if (allocated(InData%xd_ED)) then
      call RegPackBounds(RF, 1, lbound(InData%xd_ED), ubound(InData%xd_ED))
      LB(1:1) = lbound(InData%xd_ED)
      UB(1:1) = ubound(InData%xd_ED)
      do i1 = LB(1), UB(1)
         call ED_PackDiscState(RF, InData%xd_ED(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%z_ED))
   if (allocated(InData%z_ED)) then
      call RegPackBounds(RF, 1, lbound(InData%z_ED), ubound(InData%z_ED))
      LB(1:1) = lbound(InData%z_ED)
      UB(1:1) = ubound(InData%z_ED)
      do i1 = LB(1), UB(1)
         call ED_PackConstrState(RF, InData%z_ED(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%OtherSt_ED))
   if (allocated(InData%OtherSt_ED)) then
      call RegPackBounds(RF, 1, lbound(InData%OtherSt_ED), ubound(InData%OtherSt_ED))
      LB(1:1) = lbound(InData%OtherSt_ED)
      UB(1:1) = ubound(InData%OtherSt_ED)
      do i1 = LB(1), UB(1)
         call ED_PackOtherState(RF, InData%OtherSt_ED(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%u_ED))
   if (allocated(InData%u_ED)) then
      call RegPackBounds(RF, 1, lbound(InData%u_ED), ubound(InData%u_ED))
      LB(1:1) = lbound(InData%u_ED)
      UB(1:1) = ubound(InData%u_ED)
      do i1 = LB(1), UB(1)
         call ED_PackInput(RF, InData%u_ED(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%x_SrvD))
   if (allocated(InData%x_SrvD)) then
      call RegPackBounds(RF, 1, lbound(InData%x_SrvD), ubound(InData%x_SrvD))
      LB(1:1) = lbound(InData%x_SrvD)
      UB(1:1) = ubound(InData%x_SrvD)
      do i1 = LB(1), UB(1)
         call SrvD_PackContState(RF, InData%x_SrvD(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%xd_SrvD))
   if (allocated(InData%xd_SrvD)) then
      call RegPackBounds(RF, 1, lbound(InData%xd_SrvD), ubound(InData%xd_SrvD))
      LB(1:1) = lbound(InData%xd_SrvD)
      UB(1:1) = ubound(InData%xd_SrvD)
      do i1 = LB(1), UB(1)
         call SrvD_PackDiscState(RF, InData%xd_SrvD(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%z_SrvD))
   if (allocated(InData%z_SrvD)) then
      call RegPackBounds(RF, 1, lbound(InData%z_SrvD), ubound(InData%z_SrvD))
      LB(1:1) = lbound(InData%z_SrvD)
      UB(1:1) = ubound(InData%z_SrvD)
      do i1 = LB(1), UB(1)
         call SrvD_PackConstrState(RF, InData%z_SrvD(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%OtherSt_SrvD))
   if (allocated(InData%OtherSt_SrvD)) then
      call RegPackBounds(RF, 1, lbound(InData%OtherSt_SrvD), ubound(InData%OtherSt_SrvD))
      LB(1:1) = lbound(InData%OtherSt_SrvD)
      UB(1:1) = ubound(InData%OtherSt_SrvD)
      do i1 = LB(1), UB(1)
         call SrvD_PackOtherState(RF, InData%OtherSt_SrvD(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%u_SrvD))
   if (allocated(InData%u_SrvD)) then
      call RegPackBounds(RF, 1, lbound(InData%u_SrvD), ubound(InData%u_SrvD))
      LB(1:1) = lbound(InData%u_SrvD)
      UB(1:1) = ubound(InData%u_SrvD)
      do i1 = LB(1), UB(1)
         call SrvD_PackInput(RF, InData%u_SrvD(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%x_AD))
   if (allocated(InData%x_AD)) then
      call RegPackBounds(RF, 1, lbound(InData%x_AD), ubound(InData%x_AD))
      LB(1:1) = lbound(InData%x_AD)
      UB(1:1) = ubound(InData%x_AD)
      do i1 = LB(1), UB(1)
         call AD_PackContState(RF, InData%x_AD(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%xd_AD))
   if (allocated(InData%xd_AD)) then
      call RegPackBounds(RF, 1, lbound(InData%xd_AD), ubound(InData%xd_AD))
      LB(1:1) = lbound(InData%xd_AD)
      UB(1:1) = ubound(InData%xd_AD)
      do i1 = LB(1), UB(1)
         call AD_PackDiscState(RF, InData%xd_AD(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%z_AD))
   if (allocated(InData%z_AD)) then
      call RegPackBounds(RF, 1, lbound(InData%z_AD), ubound(InData%z_AD))
      LB(1:1) = lbound(InData%z_AD)
      UB(1:1) = ubound(InData%z_AD)
      do i1 = LB(1), UB(1)
         call AD_PackConstrState(RF, InData%z_AD(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%OtherSt_AD))
   if (allocated(InData%OtherSt_AD)) then
      call RegPackBounds(RF, 1, lbound(InData%OtherSt_AD), ubound(InData%OtherSt_AD))
      LB(1:1) = lbound(InData%OtherSt_AD)
      UB(1:1) = ubound(InData%OtherSt_AD)
      do i1 = LB(1), UB(1)
         call AD_PackOtherState(RF, InData%OtherSt_AD(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%u_AD))
   if (allocated(InData%u_AD)) then
      call RegPackBounds(RF, 1, lbound(InData%u_AD), ubound(InData%u_AD))
      LB(1:1) = lbound(InData%u_AD)
      UB(1:1) = ubound(InData%u_AD)
      do i1 = LB(1), UB(1)
         call AD_PackInput(RF, InData%u_AD(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%x_IfW))
   if (allocated(InData%x_IfW)) then
      call RegPackBounds(RF, 1, lbound(InData%x_IfW), ubound(InData%x_IfW))
      LB(1:1) = lbound(InData%x_IfW)
      UB(1:1) = ubound(InData%x_IfW)
      do i1 = LB(1), UB(1)
         call InflowWind_PackContState(RF, InData%x_IfW(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%xd_IfW))
   if (allocated(InData%xd_IfW)) then
      call RegPackBounds(RF, 1, lbound(InData%xd_IfW), ubound(InData%xd_IfW))
      LB(1:1) = lbound(InData%xd_IfW)
      UB(1:1) = ubound(InData%xd_IfW)
      do i1 = LB(1), UB(1)
         call InflowWind_PackDiscState(RF, InData%xd_IfW(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%z_IfW))
   if (allocated(InData%z_IfW)) then
      call RegPackBounds(RF, 1, lbound(InData%z_IfW), ubound(InData%z_IfW))
      LB(1:1) = lbound(InData%z_IfW)
      UB(1:1) = ubound(InData%z_IfW)
      do i1 = LB(1), UB(1)
         call InflowWind_PackConstrState(RF, InData%z_IfW(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%OtherSt_IfW))
   if (allocated(InData%OtherSt_IfW)) then
      call RegPackBounds(RF, 1, lbound(InData%OtherSt_IfW), ubound(InData%OtherSt_IfW))
      LB(1:1) = lbound(InData%OtherSt_IfW)
      UB(1:1) = ubound(InData%OtherSt_IfW)
      do i1 = LB(1), UB(1)
         call InflowWind_PackOtherState(RF, InData%OtherSt_IfW(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%u_IfW))
   if (allocated(InData%u_IfW)) then
      call RegPackBounds(RF, 1, lbound(InData%u_IfW), ubound(InData%u_IfW))
      LB(1:1) = lbound(InData%u_IfW)
      UB(1:1) = ubound(InData%u_IfW)
      do i1 = LB(1), UB(1)
         call InflowWind_PackInput(RF, InData%u_IfW(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%x_SD))
   if (allocated(InData%x_SD)) then
      call RegPackBounds(RF, 1, lbound(InData%x_SD), ubound(InData%x_SD))
      LB(1:1) = lbound(InData%x_SD)
      UB(1:1) = ubound(InData%x_SD)
      do i1 = LB(1), UB(1)
         call SD_PackContState(RF, InData%x_SD(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%xd_SD))
   if (allocated(InData%xd_SD)) then
      call RegPackBounds(RF, 1, lbound(InData%xd_SD), ubound(InData%xd_SD))
      LB(1:1) = lbound(InData%xd_SD)
      UB(1:1) = ubound(InData%xd_SD)
      do i1 = LB(1), UB(1)
         call SD_PackDiscState(RF, InData%xd_SD(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%z_SD))
   if (allocated(InData%z_SD)) then
      call RegPackBounds(RF, 1, lbound(InData%z_SD), ubound(InData%z_SD))
      LB(1:1) = lbound(InData%z_SD)
      UB(1:1) = ubound(InData%z_SD)
      do i1 = LB(1), UB(1)
         call SD_PackConstrState(RF, InData%z_SD(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%OtherSt_SD))
   if (allocated(InData%OtherSt_SD)) then
      call RegPackBounds(RF, 1, lbound(InData%OtherSt_SD), ubound(InData%OtherSt_SD))
      LB(1:1) = lbound(InData%OtherSt_SD)
      UB(1:1) = ubound(InData%OtherSt_SD)
      do i1 = LB(1), UB(1)
         call SD_PackOtherState(RF, InData%OtherSt_SD(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%u_SD))
   if (allocated(InData%u_SD)) then
      call RegPackBounds(RF, 1, lbound(InData%u_SD), ubound(InData%u_SD))
      LB(1:1) = lbound(InData%u_SD)
      UB(1:1) = ubound(InData%u_SD)
      do i1 = LB(1), UB(1)
         call SD_PackInput(RF, InData%u_SD(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%x_ExtPtfm))
   if (allocated(InData%x_ExtPtfm)) then
      call RegPackBounds(RF, 1, lbound(InData%x_ExtPtfm), ubound(InData%x_ExtPtfm))
      LB(1:1) = lbound(InData%x_ExtPtfm)
      UB(1:1) = ubound(InData%x_ExtPtfm)
      do i1 = LB(1), UB(1)
         call ExtPtfm_PackContState(RF, InData%x_ExtPtfm(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%xd_ExtPtfm))
   if (allocated(InData%xd_ExtPtfm)) then
      call RegPackBounds(RF, 1, lbound(InData%xd_ExtPtfm), ubound(InData%xd_ExtPtfm))
      LB(1:1) = lbound(InData%xd_ExtPtfm)
      UB(1:1) = ubound(InData%xd_ExtPtfm)
      do i1 = LB(1), UB(1)
         call ExtPtfm_PackDiscState(RF, InData%xd_ExtPtfm(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%z_ExtPtfm))
   if (allocated(InData%z_ExtPtfm)) then
      call RegPackBounds(RF, 1, lbound(InData%z_ExtPtfm), ubound(InData%z_ExtPtfm))
      LB(1:1) = lbound(InData%z_ExtPtfm)
      UB(1:1) = ubound(InData%z_ExtPtfm)
      do i1 = LB(1), UB(1)
         call ExtPtfm_PackConstrState(RF, InData%z_ExtPtfm(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%OtherSt_ExtPtfm))
   if (allocated(InData%OtherSt_ExtPtfm)) then
      call RegPackBounds(RF, 1, lbound(InData%OtherSt_ExtPtfm), ubound(InData%OtherSt_ExtPtfm))
      LB(1:1) = lbound(InData%OtherSt_ExtPtfm)
      UB(1:1) = ubound(InData%OtherSt_ExtPtfm)
      do i1 = LB(1), UB(1)
         call ExtPtfm_PackOtherState(RF, InData%OtherSt_ExtPtfm(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%u_ExtPtfm))
   if (allocated(InData%u_ExtPtfm)) then
      call RegPackBounds(RF, 1, lbound(InData%u_ExtPtfm), ubound(InData%u_ExtPtfm))
      LB(1:1) = lbound(InData%u_ExtPtfm)
      UB(1:1) = ubound(InData%u_ExtPtfm)
      do i1 = LB(1), UB(1)
         call ExtPtfm_PackInput(RF, InData%u_ExtPtfm(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%x_HD))
   if (allocated(InData%x_HD)) then
      call RegPackBounds(RF, 1, lbound(InData%x_HD), ubound(InData%x_HD))
      LB(1:1) = lbound(InData%x_HD)
      UB(1:1) = ubound(InData%x_HD)
      do i1 = LB(1), UB(1)
         call HydroDyn_PackContState(RF, InData%x_HD(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%xd_HD))
   if (allocated(InData%xd_HD)) then
      call RegPackBounds(RF, 1, lbound(InData%xd_HD), ubound(InData%xd_HD))
      LB(1:1) = lbound(InData%xd_HD)
      UB(1:1) = ubound(InData%xd_HD)
      do i1 = LB(1), UB(1)
         call HydroDyn_PackDiscState(RF, InData%xd_HD(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%z_HD))
   if (allocated(InData%z_HD)) then
      call RegPackBounds(RF, 1, lbound(InData%z_HD), ubound(InData%z_HD))
      LB(1:1) = lbound(InData%z_HD)
      UB(1:1) = ubound(InData%z_HD)
      do i1 = LB(1), UB(1)
         call HydroDyn_PackConstrState(RF, InData%z_HD(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%OtherSt_HD))
   if (allocated(InData%OtherSt_HD)) then
      call RegPackBounds(RF, 1, lbound(InData%OtherSt_HD), ubound(InData%OtherSt_HD))
      LB(1:1) = lbound(InData%OtherSt_HD)
      UB(1:1) = ubound(InData%OtherSt_HD)
      do i1 = LB(1), UB(1)
         call HydroDyn_PackOtherState(RF, InData%OtherSt_HD(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%u_HD))
   if (allocated(InData%u_HD)) then
      call RegPackBounds(RF, 1, lbound(InData%u_HD), ubound(InData%u_HD))
      LB(1:1) = lbound(InData%u_HD)
      UB(1:1) = ubound(InData%u_HD)
      do i1 = LB(1), UB(1)
         call HydroDyn_PackInput(RF, InData%u_HD(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%x_SeaSt))
   if (allocated(InData%x_SeaSt)) then
      call RegPackBounds(RF, 1, lbound(InData%x_SeaSt), ubound(InData%x_SeaSt))
      LB(1:1) = lbound(InData%x_SeaSt)
      UB(1:1) = ubound(InData%x_SeaSt)
      do i1 = LB(1), UB(1)
         call SeaSt_PackContState(RF, InData%x_SeaSt(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%xd_SeaSt))
   if (allocated(InData%xd_SeaSt)) then
      call RegPackBounds(RF, 1, lbound(InData%xd_SeaSt), ubound(InData%xd_SeaSt))
      LB(1:1) = lbound(InData%xd_SeaSt)
      UB(1:1) = ubound(InData%xd_SeaSt)
      do i1 = LB(1), UB(1)
         call SeaSt_PackDiscState(RF, InData%xd_SeaSt(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%z_SeaSt))
   if (allocated(InData%z_SeaSt)) then
      call RegPackBounds(RF, 1, lbound(InData%z_SeaSt), ubound(InData%z_SeaSt))
      LB(1:1) = lbound(InData%z_SeaSt)
      UB(1:1) = ubound(InData%z_SeaSt)
      do i1 = LB(1), UB(1)
         call SeaSt_PackConstrState(RF, InData%z_SeaSt(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%OtherSt_SeaSt))
   if (allocated(InData%OtherSt_SeaSt)) then
      call RegPackBounds(RF, 1, lbound(InData%OtherSt_SeaSt), ubound(InData%OtherSt_SeaSt))
      LB(1:1) = lbound(InData%OtherSt_SeaSt)
      UB(1:1) = ubound(InData%OtherSt_SeaSt)
      do i1 = LB(1), UB(1)
         call SeaSt_PackOtherState(RF, InData%OtherSt_SeaSt(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%u_SeaSt))
   if (allocated(InData%u_SeaSt)) then
      call RegPackBounds(RF, 1, lbound(InData%u_SeaSt), ubound(InData%u_SeaSt))
      LB(1:1) = lbound(InData%u_SeaSt)
      UB(1:1) = ubound(InData%u_SeaSt)
      do i1 = LB(1), UB(1)
         call SeaSt_PackInput(RF, InData%u_SeaSt(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%x_IceF))
   if (allocated(InData%x_IceF)) then
      call RegPackBounds(RF, 1, lbound(InData%x_IceF), ubound(InData%x_IceF))
      LB(1:1) = lbound(InData%x_IceF)
      UB(1:1) = ubound(InData%x_IceF)
      do i1 = LB(1), UB(1)
         call IceFloe_PackContState(RF, InData%x_IceF(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%xd_IceF))
   if (allocated(InData%xd_IceF)) then
      call RegPackBounds(RF, 1, lbound(InData%xd_IceF), ubound(InData%xd_IceF))
      LB(1:1) = lbound(InData%xd_IceF)
      UB(1:1) = ubound(InData%xd_IceF)
      do i1 = LB(1), UB(1)
         call IceFloe_PackDiscState(RF, InData%xd_IceF(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%z_IceF))
   if (allocated(InData%z_IceF)) then
      call RegPackBounds(RF, 1, lbound(InData%z_IceF), ubound(InData%z_IceF))
      LB(1:1) = lbound(InData%z_IceF)
      UB(1:1) = ubound(InData%z_IceF)
      do i1 = LB(1), UB(1)
         call IceFloe_PackConstrState(RF, InData%z_IceF(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%OtherSt_IceF))
   if (allocated(InData%OtherSt_IceF)) then
      call RegPackBounds(RF, 1, lbound(InData%OtherSt_IceF), ubound(InData%OtherSt_IceF))
      LB(1:1) = lbound(InData%OtherSt_IceF)
      UB(1:1) = ubound(InData%OtherSt_IceF)
      do i1 = LB(1), UB(1)
         call IceFloe_PackOtherState(RF, InData%OtherSt_IceF(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%u_IceF))
   if (allocated(InData%u_IceF)) then
      call RegPackBounds(RF, 1, lbound(InData%u_IceF), ubound(InData%u_IceF))
      LB(1:1) = lbound(InData%u_IceF)
      UB(1:1) = ubound(InData%u_IceF)
      do i1 = LB(1), UB(1)
         call IceFloe_PackInput(RF, InData%u_IceF(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%x_MAP))
   if (allocated(InData%x_MAP)) then
      call RegPackBounds(RF, 1, lbound(InData%x_MAP), ubound(InData%x_MAP))
      LB(1:1) = lbound(InData%x_MAP)
      UB(1:1) = ubound(InData%x_MAP)
      do i1 = LB(1), UB(1)
         call MAP_PackContState(RF, InData%x_MAP(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%xd_MAP))
   if (allocated(InData%xd_MAP)) then
      call RegPackBounds(RF, 1, lbound(InData%xd_MAP), ubound(InData%xd_MAP))
      LB(1:1) = lbound(InData%xd_MAP)
      UB(1:1) = ubound(InData%xd_MAP)
      do i1 = LB(1), UB(1)
         call MAP_PackDiscState(RF, InData%xd_MAP(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%z_MAP))
   if (allocated(InData%z_MAP)) then
      call RegPackBounds(RF, 1, lbound(InData%z_MAP), ubound(InData%z_MAP))
      LB(1:1) = lbound(InData%z_MAP)
      UB(1:1) = ubound(InData%z_MAP)
      do i1 = LB(1), UB(1)
         call MAP_PackConstrState(RF, InData%z_MAP(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%u_MAP))
   if (allocated(InData%u_MAP)) then
      call RegPackBounds(RF, 1, lbound(InData%u_MAP), ubound(InData%u_MAP))
      LB(1:1) = lbound(InData%u_MAP)
      UB(1:1) = ubound(InData%u_MAP)
      do i1 = LB(1), UB(1)
         call MAP_PackInput(RF, InData%u_MAP(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%x_FEAM))
   if (allocated(InData%x_FEAM)) then
      call RegPackBounds(RF, 1, lbound(InData%x_FEAM), ubound(InData%x_FEAM))
      LB(1:1) = lbound(InData%x_FEAM)
      UB(1:1) = ubound(InData%x_FEAM)
      do i1 = LB(1), UB(1)
         call FEAM_PackContState(RF, InData%x_FEAM(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%xd_FEAM))
   if (allocated(InData%xd_FEAM)) then
      call RegPackBounds(RF, 1, lbound(InData%xd_FEAM), ubound(InData%xd_FEAM))
      LB(1:1) = lbound(InData%xd_FEAM)
      UB(1:1) = ubound(InData%xd_FEAM)
      do i1 = LB(1), UB(1)
         call FEAM_PackDiscState(RF, InData%xd_FEAM(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%z_FEAM))
   if (allocated(InData%z_FEAM)) then
      call RegPackBounds(RF, 1, lbound(InData%z_FEAM), ubound(InData%z_FEAM))
      LB(1:1) = lbound(InData%z_FEAM)
      UB(1:1) = ubound(InData%z_FEAM)
      do i1 = LB(1), UB(1)
         call FEAM_PackConstrState(RF, InData%z_FEAM(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%OtherSt_FEAM))
   if (allocated(InData%OtherSt_FEAM)) then
      call RegPackBounds(RF, 1, lbound(InData%OtherSt_FEAM), ubound(InData%OtherSt_FEAM))
      LB(1:1) = lbound(InData%OtherSt_FEAM)
      UB(1:1) = ubound(InData%OtherSt_FEAM)
      do i1 = LB(1), UB(1)
         call FEAM_PackOtherState(RF, InData%OtherSt_FEAM(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%u_FEAM))
   if (allocated(InData%u_FEAM)) then
      call RegPackBounds(RF, 1, lbound(InData%u_FEAM), ubound(InData%u_FEAM))
      LB(1:1) = lbound(InData%u_FEAM)
      UB(1:1) = ubound(InData%u_FEAM)
      do i1 = LB(1), UB(1)
         call FEAM_PackInput(RF, InData%u_FEAM(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%x_MD))
   if (allocated(InData%x_MD)) then
      call RegPackBounds(RF, 1, lbound(InData%x_MD), ubound(InData%x_MD))
      LB(1:1) = lbound(InData%x_MD)
      UB(1:1) = ubound(InData%x_MD)
      do i1 = LB(1), UB(1)
         call MD_PackContState(RF, InData%x_MD(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%xd_MD))
   if (allocated(InData%xd_MD)) then
      call RegPackBounds(RF, 1, lbound(InData%xd_MD), ubound(InData%xd_MD))
      LB(1:1) = lbound(InData%xd_MD)
      UB(1:1) = ubound(InData%xd_MD)
      do i1 = LB(1), UB(1)
         call MD_PackDiscState(RF, InData%xd_MD(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%z_MD))
   if (allocated(InData%z_MD)) then
      call RegPackBounds(RF, 1, lbound(InData%z_MD), ubound(InData%z_MD))
      LB(1:1) = lbound(InData%z_MD)
      UB(1:1) = ubound(InData%z_MD)
      do i1 = LB(1), UB(1)
         call MD_PackConstrState(RF, InData%z_MD(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%OtherSt_MD))
   if (allocated(InData%OtherSt_MD)) then
      call RegPackBounds(RF, 1, lbound(InData%OtherSt_MD), ubound(InData%OtherSt_MD))
      LB(1:1) = lbound(InData%OtherSt_MD)
      UB(1:1) = ubound(InData%OtherSt_MD)
      do i1 = LB(1), UB(1)
         call MD_PackOtherState(RF, InData%OtherSt_MD(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%u_MD))
   if (allocated(InData%u_MD)) then
      call RegPackBounds(RF, 1, lbound(InData%u_MD), ubound(InData%u_MD))
      LB(1:1) = lbound(InData%u_MD)
      UB(1:1) = ubound(InData%u_MD)
      do i1 = LB(1), UB(1)
         call MD_PackInput(RF, InData%u_MD(i1)) 
      end do
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_UnPackLinStateSave(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FAST_LinStateSave), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FAST_UnPackLinStateSave'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%x_IceD)) deallocate(OutData%x_IceD)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 2, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%x_IceD(LB(1):UB(1),LB(2):UB(2)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%x_IceD.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_UnpackContState(RF, OutData%x_IceD(i1,i2)) ! x_IceD 
         end do
      end do
   end if
   if (allocated(OutData%xd_IceD)) deallocate(OutData%xd_IceD)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 2, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%xd_IceD(LB(1):UB(1),LB(2):UB(2)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%xd_IceD.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_UnpackDiscState(RF, OutData%xd_IceD(i1,i2)) ! xd_IceD 
         end do
      end do
   end if
   if (allocated(OutData%z_IceD)) deallocate(OutData%z_IceD)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 2, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%z_IceD(LB(1):UB(1),LB(2):UB(2)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%z_IceD.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_UnpackConstrState(RF, OutData%z_IceD(i1,i2)) ! z_IceD 
         end do
      end do
   end if
   if (allocated(OutData%OtherSt_IceD)) deallocate(OutData%OtherSt_IceD)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 2, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%OtherSt_IceD(LB(1):UB(1),LB(2):UB(2)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%OtherSt_IceD.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_UnpackOtherState(RF, OutData%OtherSt_IceD(i1,i2)) ! OtherSt_IceD 
         end do
      end do
   end if
   if (allocated(OutData%u_IceD)) deallocate(OutData%u_IceD)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 2, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%u_IceD(LB(1):UB(1),LB(2):UB(2)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%u_IceD.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_UnpackInput(RF, OutData%u_IceD(i1,i2)) ! u_IceD 
         end do
      end do
   end if
   if (allocated(OutData%x_BD)) deallocate(OutData%x_BD)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 2, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%x_BD(LB(1):UB(1),LB(2):UB(2)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%x_BD.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_UnpackContState(RF, OutData%x_BD(i1,i2)) ! x_BD 
         end do
      end do
   end if
   if (allocated(OutData%xd_BD)) deallocate(OutData%xd_BD)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 2, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%xd_BD(LB(1):UB(1),LB(2):UB(2)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%xd_BD.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_UnpackDiscState(RF, OutData%xd_BD(i1,i2)) ! xd_BD 
         end do
      end do
   end if
   if (allocated(OutData%z_BD)) deallocate(OutData%z_BD)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 2, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%z_BD(LB(1):UB(1),LB(2):UB(2)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%z_BD.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_UnpackConstrState(RF, OutData%z_BD(i1,i2)) ! z_BD 
         end do
      end do
   end if
   if (allocated(OutData%OtherSt_BD)) deallocate(OutData%OtherSt_BD)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 2, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%OtherSt_BD(LB(1):UB(1),LB(2):UB(2)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%OtherSt_BD.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_UnpackOtherState(RF, OutData%OtherSt_BD(i1,i2)) ! OtherSt_BD 
         end do
      end do
   end if
   if (allocated(OutData%u_BD)) deallocate(OutData%u_BD)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 2, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%u_BD(LB(1):UB(1),LB(2):UB(2)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%u_BD.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_UnpackInput(RF, OutData%u_BD(i1,i2)) ! u_BD 
         end do
      end do
   end if
   if (allocated(OutData%x_ED)) deallocate(OutData%x_ED)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%x_ED(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%x_ED.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call ED_UnpackContState(RF, OutData%x_ED(i1)) ! x_ED 
      end do
   end if
   if (allocated(OutData%xd_ED)) deallocate(OutData%xd_ED)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%xd_ED(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%xd_ED.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call ED_UnpackDiscState(RF, OutData%xd_ED(i1)) ! xd_ED 
      end do
   end if
   if (allocated(OutData%z_ED)) deallocate(OutData%z_ED)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%z_ED(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%z_ED.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call ED_UnpackConstrState(RF, OutData%z_ED(i1)) ! z_ED 
      end do
   end if
   if (allocated(OutData%OtherSt_ED)) deallocate(OutData%OtherSt_ED)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%OtherSt_ED(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%OtherSt_ED.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call ED_UnpackOtherState(RF, OutData%OtherSt_ED(i1)) ! OtherSt_ED 
      end do
   end if
   if (allocated(OutData%u_ED)) deallocate(OutData%u_ED)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%u_ED(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%u_ED.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call ED_UnpackInput(RF, OutData%u_ED(i1)) ! u_ED 
      end do
   end if
   if (allocated(OutData%x_SrvD)) deallocate(OutData%x_SrvD)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%x_SrvD(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%x_SrvD.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call SrvD_UnpackContState(RF, OutData%x_SrvD(i1)) ! x_SrvD 
      end do
   end if
   if (allocated(OutData%xd_SrvD)) deallocate(OutData%xd_SrvD)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%xd_SrvD(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%xd_SrvD.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call SrvD_UnpackDiscState(RF, OutData%xd_SrvD(i1)) ! xd_SrvD 
      end do
   end if
   if (allocated(OutData%z_SrvD)) deallocate(OutData%z_SrvD)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%z_SrvD(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%z_SrvD.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call SrvD_UnpackConstrState(RF, OutData%z_SrvD(i1)) ! z_SrvD 
      end do
   end if
   if (allocated(OutData%OtherSt_SrvD)) deallocate(OutData%OtherSt_SrvD)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%OtherSt_SrvD(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%OtherSt_SrvD.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call SrvD_UnpackOtherState(RF, OutData%OtherSt_SrvD(i1)) ! OtherSt_SrvD 
      end do
   end if
   if (allocated(OutData%u_SrvD)) deallocate(OutData%u_SrvD)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%u_SrvD(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%u_SrvD.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call SrvD_UnpackInput(RF, OutData%u_SrvD(i1)) ! u_SrvD 
      end do
   end if
   if (allocated(OutData%x_AD)) deallocate(OutData%x_AD)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%x_AD(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%x_AD.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call AD_UnpackContState(RF, OutData%x_AD(i1)) ! x_AD 
      end do
   end if
   if (allocated(OutData%xd_AD)) deallocate(OutData%xd_AD)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%xd_AD(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%xd_AD.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call AD_UnpackDiscState(RF, OutData%xd_AD(i1)) ! xd_AD 
      end do
   end if
   if (allocated(OutData%z_AD)) deallocate(OutData%z_AD)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%z_AD(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%z_AD.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call AD_UnpackConstrState(RF, OutData%z_AD(i1)) ! z_AD 
      end do
   end if
   if (allocated(OutData%OtherSt_AD)) deallocate(OutData%OtherSt_AD)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%OtherSt_AD(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%OtherSt_AD.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call AD_UnpackOtherState(RF, OutData%OtherSt_AD(i1)) ! OtherSt_AD 
      end do
   end if
   if (allocated(OutData%u_AD)) deallocate(OutData%u_AD)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%u_AD(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%u_AD.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call AD_UnpackInput(RF, OutData%u_AD(i1)) ! u_AD 
      end do
   end if
   if (allocated(OutData%x_IfW)) deallocate(OutData%x_IfW)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%x_IfW(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%x_IfW.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call InflowWind_UnpackContState(RF, OutData%x_IfW(i1)) ! x_IfW 
      end do
   end if
   if (allocated(OutData%xd_IfW)) deallocate(OutData%xd_IfW)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%xd_IfW(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%xd_IfW.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call InflowWind_UnpackDiscState(RF, OutData%xd_IfW(i1)) ! xd_IfW 
      end do
   end if
   if (allocated(OutData%z_IfW)) deallocate(OutData%z_IfW)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%z_IfW(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%z_IfW.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call InflowWind_UnpackConstrState(RF, OutData%z_IfW(i1)) ! z_IfW 
      end do
   end if
   if (allocated(OutData%OtherSt_IfW)) deallocate(OutData%OtherSt_IfW)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%OtherSt_IfW(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%OtherSt_IfW.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call InflowWind_UnpackOtherState(RF, OutData%OtherSt_IfW(i1)) ! OtherSt_IfW 
      end do
   end if
   if (allocated(OutData%u_IfW)) deallocate(OutData%u_IfW)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%u_IfW(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%u_IfW.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call InflowWind_UnpackInput(RF, OutData%u_IfW(i1)) ! u_IfW 
      end do
   end if
   if (allocated(OutData%x_SD)) deallocate(OutData%x_SD)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%x_SD(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%x_SD.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call SD_UnpackContState(RF, OutData%x_SD(i1)) ! x_SD 
      end do
   end if
   if (allocated(OutData%xd_SD)) deallocate(OutData%xd_SD)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%xd_SD(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%xd_SD.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call SD_UnpackDiscState(RF, OutData%xd_SD(i1)) ! xd_SD 
      end do
   end if
   if (allocated(OutData%z_SD)) deallocate(OutData%z_SD)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%z_SD(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%z_SD.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call SD_UnpackConstrState(RF, OutData%z_SD(i1)) ! z_SD 
      end do
   end if
   if (allocated(OutData%OtherSt_SD)) deallocate(OutData%OtherSt_SD)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%OtherSt_SD(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%OtherSt_SD.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call SD_UnpackOtherState(RF, OutData%OtherSt_SD(i1)) ! OtherSt_SD 
      end do
   end if
   if (allocated(OutData%u_SD)) deallocate(OutData%u_SD)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%u_SD(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%u_SD.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call SD_UnpackInput(RF, OutData%u_SD(i1)) ! u_SD 
      end do
   end if
   if (allocated(OutData%x_ExtPtfm)) deallocate(OutData%x_ExtPtfm)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%x_ExtPtfm(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%x_ExtPtfm.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call ExtPtfm_UnpackContState(RF, OutData%x_ExtPtfm(i1)) ! x_ExtPtfm 
      end do
   end if
   if (allocated(OutData%xd_ExtPtfm)) deallocate(OutData%xd_ExtPtfm)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%xd_ExtPtfm(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%xd_ExtPtfm.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call ExtPtfm_UnpackDiscState(RF, OutData%xd_ExtPtfm(i1)) ! xd_ExtPtfm 
      end do
   end if
   if (allocated(OutData%z_ExtPtfm)) deallocate(OutData%z_ExtPtfm)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%z_ExtPtfm(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%z_ExtPtfm.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call ExtPtfm_UnpackConstrState(RF, OutData%z_ExtPtfm(i1)) ! z_ExtPtfm 
      end do
   end if
   if (allocated(OutData%OtherSt_ExtPtfm)) deallocate(OutData%OtherSt_ExtPtfm)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%OtherSt_ExtPtfm(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%OtherSt_ExtPtfm.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call ExtPtfm_UnpackOtherState(RF, OutData%OtherSt_ExtPtfm(i1)) ! OtherSt_ExtPtfm 
      end do
   end if
   if (allocated(OutData%u_ExtPtfm)) deallocate(OutData%u_ExtPtfm)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%u_ExtPtfm(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%u_ExtPtfm.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call ExtPtfm_UnpackInput(RF, OutData%u_ExtPtfm(i1)) ! u_ExtPtfm 
      end do
   end if
   if (allocated(OutData%x_HD)) deallocate(OutData%x_HD)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%x_HD(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%x_HD.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call HydroDyn_UnpackContState(RF, OutData%x_HD(i1)) ! x_HD 
      end do
   end if
   if (allocated(OutData%xd_HD)) deallocate(OutData%xd_HD)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%xd_HD(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%xd_HD.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call HydroDyn_UnpackDiscState(RF, OutData%xd_HD(i1)) ! xd_HD 
      end do
   end if
   if (allocated(OutData%z_HD)) deallocate(OutData%z_HD)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%z_HD(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%z_HD.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call HydroDyn_UnpackConstrState(RF, OutData%z_HD(i1)) ! z_HD 
      end do
   end if
   if (allocated(OutData%OtherSt_HD)) deallocate(OutData%OtherSt_HD)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%OtherSt_HD(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%OtherSt_HD.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call HydroDyn_UnpackOtherState(RF, OutData%OtherSt_HD(i1)) ! OtherSt_HD 
      end do
   end if
   if (allocated(OutData%u_HD)) deallocate(OutData%u_HD)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%u_HD(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%u_HD.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call HydroDyn_UnpackInput(RF, OutData%u_HD(i1)) ! u_HD 
      end do
   end if
   if (allocated(OutData%x_SeaSt)) deallocate(OutData%x_SeaSt)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%x_SeaSt(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%x_SeaSt.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call SeaSt_UnpackContState(RF, OutData%x_SeaSt(i1)) ! x_SeaSt 
      end do
   end if
   if (allocated(OutData%xd_SeaSt)) deallocate(OutData%xd_SeaSt)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%xd_SeaSt(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%xd_SeaSt.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call SeaSt_UnpackDiscState(RF, OutData%xd_SeaSt(i1)) ! xd_SeaSt 
      end do
   end if
   if (allocated(OutData%z_SeaSt)) deallocate(OutData%z_SeaSt)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%z_SeaSt(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%z_SeaSt.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call SeaSt_UnpackConstrState(RF, OutData%z_SeaSt(i1)) ! z_SeaSt 
      end do
   end if
   if (allocated(OutData%OtherSt_SeaSt)) deallocate(OutData%OtherSt_SeaSt)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%OtherSt_SeaSt(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%OtherSt_SeaSt.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call SeaSt_UnpackOtherState(RF, OutData%OtherSt_SeaSt(i1)) ! OtherSt_SeaSt 
      end do
   end if
   if (allocated(OutData%u_SeaSt)) deallocate(OutData%u_SeaSt)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%u_SeaSt(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%u_SeaSt.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call SeaSt_UnpackInput(RF, OutData%u_SeaSt(i1)) ! u_SeaSt 
      end do
   end if
   if (allocated(OutData%x_IceF)) deallocate(OutData%x_IceF)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%x_IceF(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%x_IceF.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call IceFloe_UnpackContState(RF, OutData%x_IceF(i1)) ! x_IceF 
      end do
   end if
   if (allocated(OutData%xd_IceF)) deallocate(OutData%xd_IceF)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%xd_IceF(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%xd_IceF.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call IceFloe_UnpackDiscState(RF, OutData%xd_IceF(i1)) ! xd_IceF 
      end do
   end if
   if (allocated(OutData%z_IceF)) deallocate(OutData%z_IceF)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%z_IceF(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%z_IceF.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call IceFloe_UnpackConstrState(RF, OutData%z_IceF(i1)) ! z_IceF 
      end do
   end if
   if (allocated(OutData%OtherSt_IceF)) deallocate(OutData%OtherSt_IceF)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%OtherSt_IceF(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%OtherSt_IceF.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call IceFloe_UnpackOtherState(RF, OutData%OtherSt_IceF(i1)) ! OtherSt_IceF 
      end do
   end if
   if (allocated(OutData%u_IceF)) deallocate(OutData%u_IceF)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%u_IceF(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%u_IceF.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call IceFloe_UnpackInput(RF, OutData%u_IceF(i1)) ! u_IceF 
      end do
   end if
   if (allocated(OutData%x_MAP)) deallocate(OutData%x_MAP)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%x_MAP(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%x_MAP.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MAP_UnpackContState(RF, OutData%x_MAP(i1)) ! x_MAP 
      end do
   end if
   if (allocated(OutData%xd_MAP)) deallocate(OutData%xd_MAP)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%xd_MAP(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%xd_MAP.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MAP_UnpackDiscState(RF, OutData%xd_MAP(i1)) ! xd_MAP 
      end do
   end if
   if (allocated(OutData%z_MAP)) deallocate(OutData%z_MAP)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%z_MAP(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%z_MAP.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MAP_UnpackConstrState(RF, OutData%z_MAP(i1)) ! z_MAP 
      end do
   end if
   if (allocated(OutData%u_MAP)) deallocate(OutData%u_MAP)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%u_MAP(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%u_MAP.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MAP_UnpackInput(RF, OutData%u_MAP(i1)) ! u_MAP 
      end do
   end if
   if (allocated(OutData%x_FEAM)) deallocate(OutData%x_FEAM)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%x_FEAM(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%x_FEAM.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call FEAM_UnpackContState(RF, OutData%x_FEAM(i1)) ! x_FEAM 
      end do
   end if
   if (allocated(OutData%xd_FEAM)) deallocate(OutData%xd_FEAM)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%xd_FEAM(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%xd_FEAM.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call FEAM_UnpackDiscState(RF, OutData%xd_FEAM(i1)) ! xd_FEAM 
      end do
   end if
   if (allocated(OutData%z_FEAM)) deallocate(OutData%z_FEAM)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%z_FEAM(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%z_FEAM.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call FEAM_UnpackConstrState(RF, OutData%z_FEAM(i1)) ! z_FEAM 
      end do
   end if
   if (allocated(OutData%OtherSt_FEAM)) deallocate(OutData%OtherSt_FEAM)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%OtherSt_FEAM(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%OtherSt_FEAM.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call FEAM_UnpackOtherState(RF, OutData%OtherSt_FEAM(i1)) ! OtherSt_FEAM 
      end do
   end if
   if (allocated(OutData%u_FEAM)) deallocate(OutData%u_FEAM)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%u_FEAM(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%u_FEAM.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call FEAM_UnpackInput(RF, OutData%u_FEAM(i1)) ! u_FEAM 
      end do
   end if
   if (allocated(OutData%x_MD)) deallocate(OutData%x_MD)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%x_MD(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%x_MD.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MD_UnpackContState(RF, OutData%x_MD(i1)) ! x_MD 
      end do
   end if
   if (allocated(OutData%xd_MD)) deallocate(OutData%xd_MD)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%xd_MD(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%xd_MD.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MD_UnpackDiscState(RF, OutData%xd_MD(i1)) ! xd_MD 
      end do
   end if
   if (allocated(OutData%z_MD)) deallocate(OutData%z_MD)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%z_MD(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%z_MD.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MD_UnpackConstrState(RF, OutData%z_MD(i1)) ! z_MD 
      end do
   end if
   if (allocated(OutData%OtherSt_MD)) deallocate(OutData%OtherSt_MD)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%OtherSt_MD(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%OtherSt_MD.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MD_UnpackOtherState(RF, OutData%OtherSt_MD(i1)) ! OtherSt_MD 
      end do
   end if
   if (allocated(OutData%u_MD)) deallocate(OutData%u_MD)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%u_MD(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%u_MD.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MD_UnpackInput(RF, OutData%u_MD(i1)) ! u_MD 
      end do
   end if
end subroutine

subroutine FAST_CopyLinType(SrcLinTypeData, DstLinTypeData, CtrlCode, ErrStat, ErrMsg)
   type(FAST_LinType), intent(in) :: SrcLinTypeData
   type(FAST_LinType), intent(inout) :: DstLinTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'FAST_CopyLinType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcLinTypeData%Names_u)) then
      LB(1:1) = lbound(SrcLinTypeData%Names_u)
      UB(1:1) = ubound(SrcLinTypeData%Names_u)
      if (.not. allocated(DstLinTypeData%Names_u)) then
         allocate(DstLinTypeData%Names_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinTypeData%Names_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLinTypeData%Names_u = SrcLinTypeData%Names_u
   end if
   if (allocated(SrcLinTypeData%Names_y)) then
      LB(1:1) = lbound(SrcLinTypeData%Names_y)
      UB(1:1) = ubound(SrcLinTypeData%Names_y)
      if (.not. allocated(DstLinTypeData%Names_y)) then
         allocate(DstLinTypeData%Names_y(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinTypeData%Names_y.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLinTypeData%Names_y = SrcLinTypeData%Names_y
   end if
   if (allocated(SrcLinTypeData%Names_x)) then
      LB(1:1) = lbound(SrcLinTypeData%Names_x)
      UB(1:1) = ubound(SrcLinTypeData%Names_x)
      if (.not. allocated(DstLinTypeData%Names_x)) then
         allocate(DstLinTypeData%Names_x(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinTypeData%Names_x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLinTypeData%Names_x = SrcLinTypeData%Names_x
   end if
   if (allocated(SrcLinTypeData%Names_xd)) then
      LB(1:1) = lbound(SrcLinTypeData%Names_xd)
      UB(1:1) = ubound(SrcLinTypeData%Names_xd)
      if (.not. allocated(DstLinTypeData%Names_xd)) then
         allocate(DstLinTypeData%Names_xd(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinTypeData%Names_xd.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLinTypeData%Names_xd = SrcLinTypeData%Names_xd
   end if
   if (allocated(SrcLinTypeData%Names_z)) then
      LB(1:1) = lbound(SrcLinTypeData%Names_z)
      UB(1:1) = ubound(SrcLinTypeData%Names_z)
      if (.not. allocated(DstLinTypeData%Names_z)) then
         allocate(DstLinTypeData%Names_z(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinTypeData%Names_z.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLinTypeData%Names_z = SrcLinTypeData%Names_z
   end if
   if (allocated(SrcLinTypeData%op_u)) then
      LB(1:1) = lbound(SrcLinTypeData%op_u)
      UB(1:1) = ubound(SrcLinTypeData%op_u)
      if (.not. allocated(DstLinTypeData%op_u)) then
         allocate(DstLinTypeData%op_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinTypeData%op_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLinTypeData%op_u = SrcLinTypeData%op_u
   end if
   if (allocated(SrcLinTypeData%op_y)) then
      LB(1:1) = lbound(SrcLinTypeData%op_y)
      UB(1:1) = ubound(SrcLinTypeData%op_y)
      if (.not. allocated(DstLinTypeData%op_y)) then
         allocate(DstLinTypeData%op_y(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinTypeData%op_y.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLinTypeData%op_y = SrcLinTypeData%op_y
   end if
   if (allocated(SrcLinTypeData%op_x)) then
      LB(1:1) = lbound(SrcLinTypeData%op_x)
      UB(1:1) = ubound(SrcLinTypeData%op_x)
      if (.not. allocated(DstLinTypeData%op_x)) then
         allocate(DstLinTypeData%op_x(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinTypeData%op_x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLinTypeData%op_x = SrcLinTypeData%op_x
   end if
   if (allocated(SrcLinTypeData%op_dx)) then
      LB(1:1) = lbound(SrcLinTypeData%op_dx)
      UB(1:1) = ubound(SrcLinTypeData%op_dx)
      if (.not. allocated(DstLinTypeData%op_dx)) then
         allocate(DstLinTypeData%op_dx(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinTypeData%op_dx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLinTypeData%op_dx = SrcLinTypeData%op_dx
   end if
   if (allocated(SrcLinTypeData%op_xd)) then
      LB(1:1) = lbound(SrcLinTypeData%op_xd)
      UB(1:1) = ubound(SrcLinTypeData%op_xd)
      if (.not. allocated(DstLinTypeData%op_xd)) then
         allocate(DstLinTypeData%op_xd(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinTypeData%op_xd.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLinTypeData%op_xd = SrcLinTypeData%op_xd
   end if
   if (allocated(SrcLinTypeData%op_z)) then
      LB(1:1) = lbound(SrcLinTypeData%op_z)
      UB(1:1) = ubound(SrcLinTypeData%op_z)
      if (.not. allocated(DstLinTypeData%op_z)) then
         allocate(DstLinTypeData%op_z(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinTypeData%op_z.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLinTypeData%op_z = SrcLinTypeData%op_z
   end if
   if (allocated(SrcLinTypeData%op_x_eig_mag)) then
      LB(1:1) = lbound(SrcLinTypeData%op_x_eig_mag)
      UB(1:1) = ubound(SrcLinTypeData%op_x_eig_mag)
      if (.not. allocated(DstLinTypeData%op_x_eig_mag)) then
         allocate(DstLinTypeData%op_x_eig_mag(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinTypeData%op_x_eig_mag.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLinTypeData%op_x_eig_mag = SrcLinTypeData%op_x_eig_mag
   end if
   if (allocated(SrcLinTypeData%op_x_eig_phase)) then
      LB(1:1) = lbound(SrcLinTypeData%op_x_eig_phase)
      UB(1:1) = ubound(SrcLinTypeData%op_x_eig_phase)
      if (.not. allocated(DstLinTypeData%op_x_eig_phase)) then
         allocate(DstLinTypeData%op_x_eig_phase(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinTypeData%op_x_eig_phase.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLinTypeData%op_x_eig_phase = SrcLinTypeData%op_x_eig_phase
   end if
   if (allocated(SrcLinTypeData%Use_u)) then
      LB(1:1) = lbound(SrcLinTypeData%Use_u)
      UB(1:1) = ubound(SrcLinTypeData%Use_u)
      if (.not. allocated(DstLinTypeData%Use_u)) then
         allocate(DstLinTypeData%Use_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinTypeData%Use_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLinTypeData%Use_u = SrcLinTypeData%Use_u
   end if
   if (allocated(SrcLinTypeData%Use_y)) then
      LB(1:1) = lbound(SrcLinTypeData%Use_y)
      UB(1:1) = ubound(SrcLinTypeData%Use_y)
      if (.not. allocated(DstLinTypeData%Use_y)) then
         allocate(DstLinTypeData%Use_y(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinTypeData%Use_y.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLinTypeData%Use_y = SrcLinTypeData%Use_y
   end if
   if (allocated(SrcLinTypeData%A)) then
      LB(1:2) = lbound(SrcLinTypeData%A)
      UB(1:2) = ubound(SrcLinTypeData%A)
      if (.not. allocated(DstLinTypeData%A)) then
         allocate(DstLinTypeData%A(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinTypeData%A.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLinTypeData%A = SrcLinTypeData%A
   end if
   if (allocated(SrcLinTypeData%B)) then
      LB(1:2) = lbound(SrcLinTypeData%B)
      UB(1:2) = ubound(SrcLinTypeData%B)
      if (.not. allocated(DstLinTypeData%B)) then
         allocate(DstLinTypeData%B(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinTypeData%B.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLinTypeData%B = SrcLinTypeData%B
   end if
   if (allocated(SrcLinTypeData%C)) then
      LB(1:2) = lbound(SrcLinTypeData%C)
      UB(1:2) = ubound(SrcLinTypeData%C)
      if (.not. allocated(DstLinTypeData%C)) then
         allocate(DstLinTypeData%C(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinTypeData%C.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLinTypeData%C = SrcLinTypeData%C
   end if
   if (allocated(SrcLinTypeData%D)) then
      LB(1:2) = lbound(SrcLinTypeData%D)
      UB(1:2) = ubound(SrcLinTypeData%D)
      if (.not. allocated(DstLinTypeData%D)) then
         allocate(DstLinTypeData%D(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinTypeData%D.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLinTypeData%D = SrcLinTypeData%D
   end if
   if (allocated(SrcLinTypeData%StateRotation)) then
      LB(1:2) = lbound(SrcLinTypeData%StateRotation)
      UB(1:2) = ubound(SrcLinTypeData%StateRotation)
      if (.not. allocated(DstLinTypeData%StateRotation)) then
         allocate(DstLinTypeData%StateRotation(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinTypeData%StateRotation.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLinTypeData%StateRotation = SrcLinTypeData%StateRotation
   end if
   if (allocated(SrcLinTypeData%StateRel_x)) then
      LB(1:2) = lbound(SrcLinTypeData%StateRel_x)
      UB(1:2) = ubound(SrcLinTypeData%StateRel_x)
      if (.not. allocated(DstLinTypeData%StateRel_x)) then
         allocate(DstLinTypeData%StateRel_x(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinTypeData%StateRel_x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLinTypeData%StateRel_x = SrcLinTypeData%StateRel_x
   end if
   if (allocated(SrcLinTypeData%StateRel_xdot)) then
      LB(1:2) = lbound(SrcLinTypeData%StateRel_xdot)
      UB(1:2) = ubound(SrcLinTypeData%StateRel_xdot)
      if (.not. allocated(DstLinTypeData%StateRel_xdot)) then
         allocate(DstLinTypeData%StateRel_xdot(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinTypeData%StateRel_xdot.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLinTypeData%StateRel_xdot = SrcLinTypeData%StateRel_xdot
   end if
   if (allocated(SrcLinTypeData%IsLoad_u)) then
      LB(1:1) = lbound(SrcLinTypeData%IsLoad_u)
      UB(1:1) = ubound(SrcLinTypeData%IsLoad_u)
      if (.not. allocated(DstLinTypeData%IsLoad_u)) then
         allocate(DstLinTypeData%IsLoad_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinTypeData%IsLoad_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLinTypeData%IsLoad_u = SrcLinTypeData%IsLoad_u
   end if
   if (allocated(SrcLinTypeData%RotFrame_u)) then
      LB(1:1) = lbound(SrcLinTypeData%RotFrame_u)
      UB(1:1) = ubound(SrcLinTypeData%RotFrame_u)
      if (.not. allocated(DstLinTypeData%RotFrame_u)) then
         allocate(DstLinTypeData%RotFrame_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinTypeData%RotFrame_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLinTypeData%RotFrame_u = SrcLinTypeData%RotFrame_u
   end if
   if (allocated(SrcLinTypeData%RotFrame_y)) then
      LB(1:1) = lbound(SrcLinTypeData%RotFrame_y)
      UB(1:1) = ubound(SrcLinTypeData%RotFrame_y)
      if (.not. allocated(DstLinTypeData%RotFrame_y)) then
         allocate(DstLinTypeData%RotFrame_y(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinTypeData%RotFrame_y.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLinTypeData%RotFrame_y = SrcLinTypeData%RotFrame_y
   end if
   if (allocated(SrcLinTypeData%RotFrame_x)) then
      LB(1:1) = lbound(SrcLinTypeData%RotFrame_x)
      UB(1:1) = ubound(SrcLinTypeData%RotFrame_x)
      if (.not. allocated(DstLinTypeData%RotFrame_x)) then
         allocate(DstLinTypeData%RotFrame_x(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinTypeData%RotFrame_x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLinTypeData%RotFrame_x = SrcLinTypeData%RotFrame_x
   end if
   if (allocated(SrcLinTypeData%RotFrame_z)) then
      LB(1:1) = lbound(SrcLinTypeData%RotFrame_z)
      UB(1:1) = ubound(SrcLinTypeData%RotFrame_z)
      if (.not. allocated(DstLinTypeData%RotFrame_z)) then
         allocate(DstLinTypeData%RotFrame_z(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinTypeData%RotFrame_z.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLinTypeData%RotFrame_z = SrcLinTypeData%RotFrame_z
   end if
   if (allocated(SrcLinTypeData%DerivOrder_x)) then
      LB(1:1) = lbound(SrcLinTypeData%DerivOrder_x)
      UB(1:1) = ubound(SrcLinTypeData%DerivOrder_x)
      if (.not. allocated(DstLinTypeData%DerivOrder_x)) then
         allocate(DstLinTypeData%DerivOrder_x(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLinTypeData%DerivOrder_x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLinTypeData%DerivOrder_x = SrcLinTypeData%DerivOrder_x
   end if
   DstLinTypeData%SizeLin = SrcLinTypeData%SizeLin
   DstLinTypeData%LinStartIndx = SrcLinTypeData%LinStartIndx
   DstLinTypeData%NumOutputs = SrcLinTypeData%NumOutputs
end subroutine

subroutine FAST_DestroyLinType(LinTypeData, ErrStat, ErrMsg)
   type(FAST_LinType), intent(inout) :: LinTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FAST_DestroyLinType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(LinTypeData%Names_u)) then
      deallocate(LinTypeData%Names_u)
   end if
   if (allocated(LinTypeData%Names_y)) then
      deallocate(LinTypeData%Names_y)
   end if
   if (allocated(LinTypeData%Names_x)) then
      deallocate(LinTypeData%Names_x)
   end if
   if (allocated(LinTypeData%Names_xd)) then
      deallocate(LinTypeData%Names_xd)
   end if
   if (allocated(LinTypeData%Names_z)) then
      deallocate(LinTypeData%Names_z)
   end if
   if (allocated(LinTypeData%op_u)) then
      deallocate(LinTypeData%op_u)
   end if
   if (allocated(LinTypeData%op_y)) then
      deallocate(LinTypeData%op_y)
   end if
   if (allocated(LinTypeData%op_x)) then
      deallocate(LinTypeData%op_x)
   end if
   if (allocated(LinTypeData%op_dx)) then
      deallocate(LinTypeData%op_dx)
   end if
   if (allocated(LinTypeData%op_xd)) then
      deallocate(LinTypeData%op_xd)
   end if
   if (allocated(LinTypeData%op_z)) then
      deallocate(LinTypeData%op_z)
   end if
   if (allocated(LinTypeData%op_x_eig_mag)) then
      deallocate(LinTypeData%op_x_eig_mag)
   end if
   if (allocated(LinTypeData%op_x_eig_phase)) then
      deallocate(LinTypeData%op_x_eig_phase)
   end if
   if (allocated(LinTypeData%Use_u)) then
      deallocate(LinTypeData%Use_u)
   end if
   if (allocated(LinTypeData%Use_y)) then
      deallocate(LinTypeData%Use_y)
   end if
   if (allocated(LinTypeData%A)) then
      deallocate(LinTypeData%A)
   end if
   if (allocated(LinTypeData%B)) then
      deallocate(LinTypeData%B)
   end if
   if (allocated(LinTypeData%C)) then
      deallocate(LinTypeData%C)
   end if
   if (allocated(LinTypeData%D)) then
      deallocate(LinTypeData%D)
   end if
   if (allocated(LinTypeData%StateRotation)) then
      deallocate(LinTypeData%StateRotation)
   end if
   if (allocated(LinTypeData%StateRel_x)) then
      deallocate(LinTypeData%StateRel_x)
   end if
   if (allocated(LinTypeData%StateRel_xdot)) then
      deallocate(LinTypeData%StateRel_xdot)
   end if
   if (allocated(LinTypeData%IsLoad_u)) then
      deallocate(LinTypeData%IsLoad_u)
   end if
   if (allocated(LinTypeData%RotFrame_u)) then
      deallocate(LinTypeData%RotFrame_u)
   end if
   if (allocated(LinTypeData%RotFrame_y)) then
      deallocate(LinTypeData%RotFrame_y)
   end if
   if (allocated(LinTypeData%RotFrame_x)) then
      deallocate(LinTypeData%RotFrame_x)
   end if
   if (allocated(LinTypeData%RotFrame_z)) then
      deallocate(LinTypeData%RotFrame_z)
   end if
   if (allocated(LinTypeData%DerivOrder_x)) then
      deallocate(LinTypeData%DerivOrder_x)
   end if
end subroutine

subroutine FAST_PackLinType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FAST_LinType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FAST_PackLinType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%Names_u)
   call RegPackAlloc(RF, InData%Names_y)
   call RegPackAlloc(RF, InData%Names_x)
   call RegPackAlloc(RF, InData%Names_xd)
   call RegPackAlloc(RF, InData%Names_z)
   call RegPackAlloc(RF, InData%op_u)
   call RegPackAlloc(RF, InData%op_y)
   call RegPackAlloc(RF, InData%op_x)
   call RegPackAlloc(RF, InData%op_dx)
   call RegPackAlloc(RF, InData%op_xd)
   call RegPackAlloc(RF, InData%op_z)
   call RegPackAlloc(RF, InData%op_x_eig_mag)
   call RegPackAlloc(RF, InData%op_x_eig_phase)
   call RegPackAlloc(RF, InData%Use_u)
   call RegPackAlloc(RF, InData%Use_y)
   call RegPackAlloc(RF, InData%A)
   call RegPackAlloc(RF, InData%B)
   call RegPackAlloc(RF, InData%C)
   call RegPackAlloc(RF, InData%D)
   call RegPackAlloc(RF, InData%StateRotation)
   call RegPackAlloc(RF, InData%StateRel_x)
   call RegPackAlloc(RF, InData%StateRel_xdot)
   call RegPackAlloc(RF, InData%IsLoad_u)
   call RegPackAlloc(RF, InData%RotFrame_u)
   call RegPackAlloc(RF, InData%RotFrame_y)
   call RegPackAlloc(RF, InData%RotFrame_x)
   call RegPackAlloc(RF, InData%RotFrame_z)
   call RegPackAlloc(RF, InData%DerivOrder_x)
   call RegPack(RF, InData%SizeLin)
   call RegPack(RF, InData%LinStartIndx)
   call RegPack(RF, InData%NumOutputs)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_UnPackLinType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FAST_LinType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FAST_UnPackLinType'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%Names_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Names_y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Names_x); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Names_xd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Names_z); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%op_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%op_y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%op_x); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%op_dx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%op_xd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%op_z); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%op_x_eig_mag); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%op_x_eig_phase); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Use_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Use_y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%A); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%B); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%C); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%D); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%StateRotation); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%StateRel_x); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%StateRel_xdot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%IsLoad_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RotFrame_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RotFrame_y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RotFrame_x); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RotFrame_z); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%DerivOrder_x); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SizeLin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LinStartIndx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumOutputs); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_CopyModLinType(SrcModLinTypeData, DstModLinTypeData, CtrlCode, ErrStat, ErrMsg)
   type(FAST_ModLinType), intent(in) :: SrcModLinTypeData
   type(FAST_ModLinType), intent(inout) :: DstModLinTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_CopyModLinType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcModLinTypeData%Instance)) then
      LB(1:1) = lbound(SrcModLinTypeData%Instance)
      UB(1:1) = ubound(SrcModLinTypeData%Instance)
      if (.not. allocated(DstModLinTypeData%Instance)) then
         allocate(DstModLinTypeData%Instance(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModLinTypeData%Instance.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call FAST_CopyLinType(SrcModLinTypeData%Instance(i1), DstModLinTypeData%Instance(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
end subroutine

subroutine FAST_DestroyModLinType(ModLinTypeData, ErrStat, ErrMsg)
   type(FAST_ModLinType), intent(inout) :: ModLinTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_DestroyModLinType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ModLinTypeData%Instance)) then
      LB(1:1) = lbound(ModLinTypeData%Instance)
      UB(1:1) = ubound(ModLinTypeData%Instance)
      do i1 = LB(1), UB(1)
         call FAST_DestroyLinType(ModLinTypeData%Instance(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ModLinTypeData%Instance)
   end if
end subroutine

subroutine FAST_PackModLinType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FAST_ModLinType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FAST_PackModLinType'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%Instance))
   if (allocated(InData%Instance)) then
      call RegPackBounds(RF, 1, lbound(InData%Instance), ubound(InData%Instance))
      LB(1:1) = lbound(InData%Instance)
      UB(1:1) = ubound(InData%Instance)
      do i1 = LB(1), UB(1)
         call FAST_PackLinType(RF, InData%Instance(i1)) 
      end do
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_UnPackModLinType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FAST_ModLinType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FAST_UnPackModLinType'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%Instance)) deallocate(OutData%Instance)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Instance(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Instance.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call FAST_UnpackLinType(RF, OutData%Instance(i1)) ! Instance 
      end do
   end if
end subroutine

subroutine FAST_CopyLinFileType(SrcLinFileTypeData, DstLinFileTypeData, CtrlCode, ErrStat, ErrMsg)
   type(FAST_LinFileType), intent(in) :: SrcLinFileTypeData
   type(FAST_LinFileType), intent(inout) :: DstLinFileTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_CopyLinFileType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   LB(1:1) = lbound(SrcLinFileTypeData%Modules)
   UB(1:1) = ubound(SrcLinFileTypeData%Modules)
   do i1 = LB(1), UB(1)
      call FAST_CopyModLinType(SrcLinFileTypeData%Modules(i1), DstLinFileTypeData%Modules(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   call FAST_CopyLinType(SrcLinFileTypeData%Glue, DstLinFileTypeData%Glue, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstLinFileTypeData%RotSpeed = SrcLinFileTypeData%RotSpeed
   DstLinFileTypeData%Azimuth = SrcLinFileTypeData%Azimuth
   DstLinFileTypeData%WindSpeed = SrcLinFileTypeData%WindSpeed
end subroutine

subroutine FAST_DestroyLinFileType(LinFileTypeData, ErrStat, ErrMsg)
   type(FAST_LinFileType), intent(inout) :: LinFileTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_DestroyLinFileType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   LB(1:1) = lbound(LinFileTypeData%Modules)
   UB(1:1) = ubound(LinFileTypeData%Modules)
   do i1 = LB(1), UB(1)
      call FAST_DestroyModLinType(LinFileTypeData%Modules(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   call FAST_DestroyLinType(LinFileTypeData%Glue, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine FAST_PackLinFileType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FAST_LinFileType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FAST_PackLinFileType'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   LB(1:1) = lbound(InData%Modules)
   UB(1:1) = ubound(InData%Modules)
   do i1 = LB(1), UB(1)
      call FAST_PackModLinType(RF, InData%Modules(i1)) 
   end do
   call FAST_PackLinType(RF, InData%Glue) 
   call RegPack(RF, InData%RotSpeed)
   call RegPack(RF, InData%Azimuth)
   call RegPack(RF, InData%WindSpeed)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_UnPackLinFileType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FAST_LinFileType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FAST_UnPackLinFileType'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat /= ErrID_None) return
   LB(1:1) = lbound(OutData%Modules)
   UB(1:1) = ubound(OutData%Modules)
   do i1 = LB(1), UB(1)
      call FAST_UnpackModLinType(RF, OutData%Modules(i1)) ! Modules 
   end do
   call FAST_UnpackLinType(RF, OutData%Glue) ! Glue 
   call RegUnpack(RF, OutData%RotSpeed); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Azimuth); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WindSpeed); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_CopyMiscLinType(SrcMiscLinTypeData, DstMiscLinTypeData, CtrlCode, ErrStat, ErrMsg)
   type(FAST_MiscLinType), intent(in) :: SrcMiscLinTypeData
   type(FAST_MiscLinType), intent(inout) :: DstMiscLinTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'FAST_CopyMiscLinType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcMiscLinTypeData%LinTimes)) then
      LB(1:1) = lbound(SrcMiscLinTypeData%LinTimes)
      UB(1:1) = ubound(SrcMiscLinTypeData%LinTimes)
      if (.not. allocated(DstMiscLinTypeData%LinTimes)) then
         allocate(DstMiscLinTypeData%LinTimes(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscLinTypeData%LinTimes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscLinTypeData%LinTimes = SrcMiscLinTypeData%LinTimes
   end if
   DstMiscLinTypeData%CopyOP_CtrlCode = SrcMiscLinTypeData%CopyOP_CtrlCode
   if (allocated(SrcMiscLinTypeData%AzimTarget)) then
      LB(1:1) = lbound(SrcMiscLinTypeData%AzimTarget)
      UB(1:1) = ubound(SrcMiscLinTypeData%AzimTarget)
      if (.not. allocated(DstMiscLinTypeData%AzimTarget)) then
         allocate(DstMiscLinTypeData%AzimTarget(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscLinTypeData%AzimTarget.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscLinTypeData%AzimTarget = SrcMiscLinTypeData%AzimTarget
   end if
   DstMiscLinTypeData%IsConverged = SrcMiscLinTypeData%IsConverged
   DstMiscLinTypeData%FoundSteady = SrcMiscLinTypeData%FoundSteady
   DstMiscLinTypeData%ForceLin = SrcMiscLinTypeData%ForceLin
   DstMiscLinTypeData%n_rot = SrcMiscLinTypeData%n_rot
   DstMiscLinTypeData%AzimIndx = SrcMiscLinTypeData%AzimIndx
   DstMiscLinTypeData%NextLinTimeIndx = SrcMiscLinTypeData%NextLinTimeIndx
   if (allocated(SrcMiscLinTypeData%Psi)) then
      LB(1:1) = lbound(SrcMiscLinTypeData%Psi)
      UB(1:1) = ubound(SrcMiscLinTypeData%Psi)
      if (.not. allocated(DstMiscLinTypeData%Psi)) then
         allocate(DstMiscLinTypeData%Psi(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscLinTypeData%Psi.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscLinTypeData%Psi = SrcMiscLinTypeData%Psi
   end if
   if (allocated(SrcMiscLinTypeData%y_interp)) then
      LB(1:1) = lbound(SrcMiscLinTypeData%y_interp)
      UB(1:1) = ubound(SrcMiscLinTypeData%y_interp)
      if (.not. allocated(DstMiscLinTypeData%y_interp)) then
         allocate(DstMiscLinTypeData%y_interp(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscLinTypeData%y_interp.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscLinTypeData%y_interp = SrcMiscLinTypeData%y_interp
   end if
   if (allocated(SrcMiscLinTypeData%y_ref)) then
      LB(1:1) = lbound(SrcMiscLinTypeData%y_ref)
      UB(1:1) = ubound(SrcMiscLinTypeData%y_ref)
      if (.not. allocated(DstMiscLinTypeData%y_ref)) then
         allocate(DstMiscLinTypeData%y_ref(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscLinTypeData%y_ref.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscLinTypeData%y_ref = SrcMiscLinTypeData%y_ref
   end if
   if (allocated(SrcMiscLinTypeData%Y_prevRot)) then
      LB(1:2) = lbound(SrcMiscLinTypeData%Y_prevRot)
      UB(1:2) = ubound(SrcMiscLinTypeData%Y_prevRot)
      if (.not. allocated(DstMiscLinTypeData%Y_prevRot)) then
         allocate(DstMiscLinTypeData%Y_prevRot(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscLinTypeData%Y_prevRot.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscLinTypeData%Y_prevRot = SrcMiscLinTypeData%Y_prevRot
   end if
end subroutine

subroutine FAST_DestroyMiscLinType(MiscLinTypeData, ErrStat, ErrMsg)
   type(FAST_MiscLinType), intent(inout) :: MiscLinTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FAST_DestroyMiscLinType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(MiscLinTypeData%LinTimes)) then
      deallocate(MiscLinTypeData%LinTimes)
   end if
   if (allocated(MiscLinTypeData%AzimTarget)) then
      deallocate(MiscLinTypeData%AzimTarget)
   end if
   if (allocated(MiscLinTypeData%Psi)) then
      deallocate(MiscLinTypeData%Psi)
   end if
   if (allocated(MiscLinTypeData%y_interp)) then
      deallocate(MiscLinTypeData%y_interp)
   end if
   if (allocated(MiscLinTypeData%y_ref)) then
      deallocate(MiscLinTypeData%y_ref)
   end if
   if (allocated(MiscLinTypeData%Y_prevRot)) then
      deallocate(MiscLinTypeData%Y_prevRot)
   end if
end subroutine

subroutine FAST_PackMiscLinType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FAST_MiscLinType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FAST_PackMiscLinType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%LinTimes)
   call RegPack(RF, InData%CopyOP_CtrlCode)
   call RegPackAlloc(RF, InData%AzimTarget)
   call RegPack(RF, InData%IsConverged)
   call RegPack(RF, InData%FoundSteady)
   call RegPack(RF, InData%ForceLin)
   call RegPack(RF, InData%n_rot)
   call RegPack(RF, InData%AzimIndx)
   call RegPack(RF, InData%NextLinTimeIndx)
   call RegPackAlloc(RF, InData%Psi)
   call RegPackAlloc(RF, InData%y_interp)
   call RegPackAlloc(RF, InData%y_ref)
   call RegPackAlloc(RF, InData%Y_prevRot)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_UnPackMiscLinType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FAST_MiscLinType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FAST_UnPackMiscLinType'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%LinTimes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CopyOP_CtrlCode); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AzimTarget); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%IsConverged); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FoundSteady); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ForceLin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%n_rot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AzimIndx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NextLinTimeIndx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Psi); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%y_interp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%y_ref); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Y_prevRot); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_CopyOutputFileType(SrcOutputFileTypeData, DstOutputFileTypeData, CtrlCode, ErrStat, ErrMsg)
   type(FAST_OutputFileType), intent(inout) :: SrcOutputFileTypeData
   type(FAST_OutputFileType), intent(inout) :: DstOutputFileTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_CopyOutputFileType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcOutputFileTypeData%TimeData)) then
      LB(1:1) = lbound(SrcOutputFileTypeData%TimeData)
      UB(1:1) = ubound(SrcOutputFileTypeData%TimeData)
      if (.not. allocated(DstOutputFileTypeData%TimeData)) then
         allocate(DstOutputFileTypeData%TimeData(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputFileTypeData%TimeData.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputFileTypeData%TimeData = SrcOutputFileTypeData%TimeData
   end if
   if (allocated(SrcOutputFileTypeData%AllOutData)) then
      LB(1:2) = lbound(SrcOutputFileTypeData%AllOutData)
      UB(1:2) = ubound(SrcOutputFileTypeData%AllOutData)
      if (.not. allocated(DstOutputFileTypeData%AllOutData)) then
         allocate(DstOutputFileTypeData%AllOutData(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputFileTypeData%AllOutData.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputFileTypeData%AllOutData = SrcOutputFileTypeData%AllOutData
   end if
   DstOutputFileTypeData%n_Out = SrcOutputFileTypeData%n_Out
   DstOutputFileTypeData%NOutSteps = SrcOutputFileTypeData%NOutSteps
   DstOutputFileTypeData%numOuts = SrcOutputFileTypeData%numOuts
   DstOutputFileTypeData%UnOu = SrcOutputFileTypeData%UnOu
   DstOutputFileTypeData%UnSum = SrcOutputFileTypeData%UnSum
   DstOutputFileTypeData%UnGra = SrcOutputFileTypeData%UnGra
   DstOutputFileTypeData%FileDescLines = SrcOutputFileTypeData%FileDescLines
   if (allocated(SrcOutputFileTypeData%ChannelNames)) then
      LB(1:1) = lbound(SrcOutputFileTypeData%ChannelNames)
      UB(1:1) = ubound(SrcOutputFileTypeData%ChannelNames)
      if (.not. allocated(DstOutputFileTypeData%ChannelNames)) then
         allocate(DstOutputFileTypeData%ChannelNames(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputFileTypeData%ChannelNames.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputFileTypeData%ChannelNames = SrcOutputFileTypeData%ChannelNames
   end if
   if (allocated(SrcOutputFileTypeData%ChannelUnits)) then
      LB(1:1) = lbound(SrcOutputFileTypeData%ChannelUnits)
      UB(1:1) = ubound(SrcOutputFileTypeData%ChannelUnits)
      if (.not. allocated(DstOutputFileTypeData%ChannelUnits)) then
         allocate(DstOutputFileTypeData%ChannelUnits(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputFileTypeData%ChannelUnits.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputFileTypeData%ChannelUnits = SrcOutputFileTypeData%ChannelUnits
   end if
   LB(1:1) = lbound(SrcOutputFileTypeData%Module_Ver)
   UB(1:1) = ubound(SrcOutputFileTypeData%Module_Ver)
   do i1 = LB(1), UB(1)
      call NWTC_Library_CopyProgDesc(SrcOutputFileTypeData%Module_Ver(i1), DstOutputFileTypeData%Module_Ver(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   DstOutputFileTypeData%Module_Abrev = SrcOutputFileTypeData%Module_Abrev
   DstOutputFileTypeData%WriteThisStep = SrcOutputFileTypeData%WriteThisStep
   DstOutputFileTypeData%VTK_count = SrcOutputFileTypeData%VTK_count
   DstOutputFileTypeData%VTK_LastWaveIndx = SrcOutputFileTypeData%VTK_LastWaveIndx
   call FAST_CopyLinFileType(SrcOutputFileTypeData%Lin, DstOutputFileTypeData%Lin, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstOutputFileTypeData%ActualChanLen = SrcOutputFileTypeData%ActualChanLen
   call FAST_CopyLinStateSave(SrcOutputFileTypeData%op, DstOutputFileTypeData%op, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstOutputFileTypeData%DriverWriteOutput = SrcOutputFileTypeData%DriverWriteOutput
end subroutine

subroutine FAST_DestroyOutputFileType(OutputFileTypeData, ErrStat, ErrMsg)
   type(FAST_OutputFileType), intent(inout) :: OutputFileTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_DestroyOutputFileType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(OutputFileTypeData%TimeData)) then
      deallocate(OutputFileTypeData%TimeData)
   end if
   if (allocated(OutputFileTypeData%AllOutData)) then
      deallocate(OutputFileTypeData%AllOutData)
   end if
   if (allocated(OutputFileTypeData%ChannelNames)) then
      deallocate(OutputFileTypeData%ChannelNames)
   end if
   if (allocated(OutputFileTypeData%ChannelUnits)) then
      deallocate(OutputFileTypeData%ChannelUnits)
   end if
   LB(1:1) = lbound(OutputFileTypeData%Module_Ver)
   UB(1:1) = ubound(OutputFileTypeData%Module_Ver)
   do i1 = LB(1), UB(1)
      call NWTC_Library_DestroyProgDesc(OutputFileTypeData%Module_Ver(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   call FAST_DestroyLinFileType(OutputFileTypeData%Lin, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FAST_DestroyLinStateSave(OutputFileTypeData%op, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine FAST_PackOutputFileType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FAST_OutputFileType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FAST_PackOutputFileType'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%TimeData)
   call RegPackAlloc(RF, InData%AllOutData)
   call RegPack(RF, InData%n_Out)
   call RegPack(RF, InData%NOutSteps)
   call RegPack(RF, InData%numOuts)
   call RegPack(RF, InData%UnOu)
   call RegPack(RF, InData%UnSum)
   call RegPack(RF, InData%UnGra)
   call RegPack(RF, InData%FileDescLines)
   call RegPackAlloc(RF, InData%ChannelNames)
   call RegPackAlloc(RF, InData%ChannelUnits)
   LB(1:1) = lbound(InData%Module_Ver)
   UB(1:1) = ubound(InData%Module_Ver)
   do i1 = LB(1), UB(1)
      call NWTC_Library_PackProgDesc(RF, InData%Module_Ver(i1)) 
   end do
   call RegPack(RF, InData%Module_Abrev)
   call RegPack(RF, InData%WriteThisStep)
   call RegPack(RF, InData%VTK_count)
   call RegPack(RF, InData%VTK_LastWaveIndx)
   call FAST_PackLinFileType(RF, InData%Lin) 
   call RegPack(RF, InData%ActualChanLen)
   call FAST_PackLinStateSave(RF, InData%op) 
   call RegPack(RF, InData%DriverWriteOutput)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_UnPackOutputFileType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FAST_OutputFileType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FAST_UnPackOutputFileType'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%TimeData); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AllOutData); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%n_Out); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NOutSteps); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%numOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UnOu); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UnSum); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UnGra); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FileDescLines); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%ChannelNames); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%ChannelUnits); if (RegCheckErr(RF, RoutineName)) return
   LB(1:1) = lbound(OutData%Module_Ver)
   UB(1:1) = ubound(OutData%Module_Ver)
   do i1 = LB(1), UB(1)
      call NWTC_Library_UnpackProgDesc(RF, OutData%Module_Ver(i1)) ! Module_Ver 
   end do
   call RegUnpack(RF, OutData%Module_Abrev); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WriteThisStep); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VTK_count); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VTK_LastWaveIndx); if (RegCheckErr(RF, RoutineName)) return
   call FAST_UnpackLinFileType(RF, OutData%Lin) ! Lin 
   call RegUnpack(RF, OutData%ActualChanLen); if (RegCheckErr(RF, RoutineName)) return
   call FAST_UnpackLinStateSave(RF, OutData%op) ! op 
   call RegUnpack(RF, OutData%DriverWriteOutput); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_CopyIceDyn_Data(SrcIceDyn_DataData, DstIceDyn_DataData, CtrlCode, ErrStat, ErrMsg)
   type(IceDyn_Data), intent(inout) :: SrcIceDyn_DataData
   type(IceDyn_Data), intent(inout) :: DstIceDyn_DataData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_CopyIceDyn_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcIceDyn_DataData%x)) then
      LB(1:2) = lbound(SrcIceDyn_DataData%x)
      UB(1:2) = ubound(SrcIceDyn_DataData%x)
      if (.not. allocated(DstIceDyn_DataData%x)) then
         allocate(DstIceDyn_DataData%x(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstIceDyn_DataData%x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_CopyContState(SrcIceDyn_DataData%x(i1,i2), DstIceDyn_DataData%x(i1,i2), CtrlCode, ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
            if (ErrStat >= AbortErrLev) return
         end do
      end do
   end if
   if (allocated(SrcIceDyn_DataData%xd)) then
      LB(1:2) = lbound(SrcIceDyn_DataData%xd)
      UB(1:2) = ubound(SrcIceDyn_DataData%xd)
      if (.not. allocated(DstIceDyn_DataData%xd)) then
         allocate(DstIceDyn_DataData%xd(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstIceDyn_DataData%xd.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_CopyDiscState(SrcIceDyn_DataData%xd(i1,i2), DstIceDyn_DataData%xd(i1,i2), CtrlCode, ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
            if (ErrStat >= AbortErrLev) return
         end do
      end do
   end if
   if (allocated(SrcIceDyn_DataData%z)) then
      LB(1:2) = lbound(SrcIceDyn_DataData%z)
      UB(1:2) = ubound(SrcIceDyn_DataData%z)
      if (.not. allocated(DstIceDyn_DataData%z)) then
         allocate(DstIceDyn_DataData%z(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstIceDyn_DataData%z.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_CopyConstrState(SrcIceDyn_DataData%z(i1,i2), DstIceDyn_DataData%z(i1,i2), CtrlCode, ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
            if (ErrStat >= AbortErrLev) return
         end do
      end do
   end if
   if (allocated(SrcIceDyn_DataData%OtherSt)) then
      LB(1:2) = lbound(SrcIceDyn_DataData%OtherSt)
      UB(1:2) = ubound(SrcIceDyn_DataData%OtherSt)
      if (.not. allocated(DstIceDyn_DataData%OtherSt)) then
         allocate(DstIceDyn_DataData%OtherSt(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstIceDyn_DataData%OtherSt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_CopyOtherState(SrcIceDyn_DataData%OtherSt(i1,i2), DstIceDyn_DataData%OtherSt(i1,i2), CtrlCode, ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
            if (ErrStat >= AbortErrLev) return
         end do
      end do
   end if
   if (allocated(SrcIceDyn_DataData%p)) then
      LB(1:1) = lbound(SrcIceDyn_DataData%p)
      UB(1:1) = ubound(SrcIceDyn_DataData%p)
      if (.not. allocated(DstIceDyn_DataData%p)) then
         allocate(DstIceDyn_DataData%p(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstIceDyn_DataData%p.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call IceD_CopyParam(SrcIceDyn_DataData%p(i1), DstIceDyn_DataData%p(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcIceDyn_DataData%u)) then
      LB(1:1) = lbound(SrcIceDyn_DataData%u)
      UB(1:1) = ubound(SrcIceDyn_DataData%u)
      if (.not. allocated(DstIceDyn_DataData%u)) then
         allocate(DstIceDyn_DataData%u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstIceDyn_DataData%u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call IceD_CopyInput(SrcIceDyn_DataData%u(i1), DstIceDyn_DataData%u(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcIceDyn_DataData%y)) then
      LB(1:1) = lbound(SrcIceDyn_DataData%y)
      UB(1:1) = ubound(SrcIceDyn_DataData%y)
      if (.not. allocated(DstIceDyn_DataData%y)) then
         allocate(DstIceDyn_DataData%y(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstIceDyn_DataData%y.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call IceD_CopyOutput(SrcIceDyn_DataData%y(i1), DstIceDyn_DataData%y(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcIceDyn_DataData%m)) then
      LB(1:1) = lbound(SrcIceDyn_DataData%m)
      UB(1:1) = ubound(SrcIceDyn_DataData%m)
      if (.not. allocated(DstIceDyn_DataData%m)) then
         allocate(DstIceDyn_DataData%m(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstIceDyn_DataData%m.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call IceD_CopyMisc(SrcIceDyn_DataData%m(i1), DstIceDyn_DataData%m(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcIceDyn_DataData%Input)) then
      LB(1:2) = lbound(SrcIceDyn_DataData%Input)
      UB(1:2) = ubound(SrcIceDyn_DataData%Input)
      if (.not. allocated(DstIceDyn_DataData%Input)) then
         allocate(DstIceDyn_DataData%Input(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstIceDyn_DataData%Input.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_CopyInput(SrcIceDyn_DataData%Input(i1,i2), DstIceDyn_DataData%Input(i1,i2), CtrlCode, ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
            if (ErrStat >= AbortErrLev) return
         end do
      end do
   end if
   if (allocated(SrcIceDyn_DataData%Input_Saved)) then
      LB(1:2) = lbound(SrcIceDyn_DataData%Input_Saved)
      UB(1:2) = ubound(SrcIceDyn_DataData%Input_Saved)
      if (.not. allocated(DstIceDyn_DataData%Input_Saved)) then
         allocate(DstIceDyn_DataData%Input_Saved(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstIceDyn_DataData%Input_Saved.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_CopyInput(SrcIceDyn_DataData%Input_Saved(i1,i2), DstIceDyn_DataData%Input_Saved(i1,i2), CtrlCode, ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
            if (ErrStat >= AbortErrLev) return
         end do
      end do
   end if
   if (allocated(SrcIceDyn_DataData%InputTimes)) then
      LB(1:2) = lbound(SrcIceDyn_DataData%InputTimes)
      UB(1:2) = ubound(SrcIceDyn_DataData%InputTimes)
      if (.not. allocated(DstIceDyn_DataData%InputTimes)) then
         allocate(DstIceDyn_DataData%InputTimes(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstIceDyn_DataData%InputTimes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstIceDyn_DataData%InputTimes = SrcIceDyn_DataData%InputTimes
   end if
   if (allocated(SrcIceDyn_DataData%InputTimes_Saved)) then
      LB(1:2) = lbound(SrcIceDyn_DataData%InputTimes_Saved)
      UB(1:2) = ubound(SrcIceDyn_DataData%InputTimes_Saved)
      if (.not. allocated(DstIceDyn_DataData%InputTimes_Saved)) then
         allocate(DstIceDyn_DataData%InputTimes_Saved(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstIceDyn_DataData%InputTimes_Saved.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstIceDyn_DataData%InputTimes_Saved = SrcIceDyn_DataData%InputTimes_Saved
   end if
end subroutine

subroutine FAST_DestroyIceDyn_Data(IceDyn_DataData, ErrStat, ErrMsg)
   type(IceDyn_Data), intent(inout) :: IceDyn_DataData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_DestroyIceDyn_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(IceDyn_DataData%x)) then
      LB(1:2) = lbound(IceDyn_DataData%x)
      UB(1:2) = ubound(IceDyn_DataData%x)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_DestroyContState(IceDyn_DataData%x(i1,i2), ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         end do
      end do
      deallocate(IceDyn_DataData%x)
   end if
   if (allocated(IceDyn_DataData%xd)) then
      LB(1:2) = lbound(IceDyn_DataData%xd)
      UB(1:2) = ubound(IceDyn_DataData%xd)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_DestroyDiscState(IceDyn_DataData%xd(i1,i2), ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         end do
      end do
      deallocate(IceDyn_DataData%xd)
   end if
   if (allocated(IceDyn_DataData%z)) then
      LB(1:2) = lbound(IceDyn_DataData%z)
      UB(1:2) = ubound(IceDyn_DataData%z)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_DestroyConstrState(IceDyn_DataData%z(i1,i2), ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         end do
      end do
      deallocate(IceDyn_DataData%z)
   end if
   if (allocated(IceDyn_DataData%OtherSt)) then
      LB(1:2) = lbound(IceDyn_DataData%OtherSt)
      UB(1:2) = ubound(IceDyn_DataData%OtherSt)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_DestroyOtherState(IceDyn_DataData%OtherSt(i1,i2), ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         end do
      end do
      deallocate(IceDyn_DataData%OtherSt)
   end if
   if (allocated(IceDyn_DataData%p)) then
      LB(1:1) = lbound(IceDyn_DataData%p)
      UB(1:1) = ubound(IceDyn_DataData%p)
      do i1 = LB(1), UB(1)
         call IceD_DestroyParam(IceDyn_DataData%p(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(IceDyn_DataData%p)
   end if
   if (allocated(IceDyn_DataData%u)) then
      LB(1:1) = lbound(IceDyn_DataData%u)
      UB(1:1) = ubound(IceDyn_DataData%u)
      do i1 = LB(1), UB(1)
         call IceD_DestroyInput(IceDyn_DataData%u(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(IceDyn_DataData%u)
   end if
   if (allocated(IceDyn_DataData%y)) then
      LB(1:1) = lbound(IceDyn_DataData%y)
      UB(1:1) = ubound(IceDyn_DataData%y)
      do i1 = LB(1), UB(1)
         call IceD_DestroyOutput(IceDyn_DataData%y(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(IceDyn_DataData%y)
   end if
   if (allocated(IceDyn_DataData%m)) then
      LB(1:1) = lbound(IceDyn_DataData%m)
      UB(1:1) = ubound(IceDyn_DataData%m)
      do i1 = LB(1), UB(1)
         call IceD_DestroyMisc(IceDyn_DataData%m(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(IceDyn_DataData%m)
   end if
   if (allocated(IceDyn_DataData%Input)) then
      LB(1:2) = lbound(IceDyn_DataData%Input)
      UB(1:2) = ubound(IceDyn_DataData%Input)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_DestroyInput(IceDyn_DataData%Input(i1,i2), ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         end do
      end do
      deallocate(IceDyn_DataData%Input)
   end if
   if (allocated(IceDyn_DataData%Input_Saved)) then
      LB(1:2) = lbound(IceDyn_DataData%Input_Saved)
      UB(1:2) = ubound(IceDyn_DataData%Input_Saved)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_DestroyInput(IceDyn_DataData%Input_Saved(i1,i2), ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         end do
      end do
      deallocate(IceDyn_DataData%Input_Saved)
   end if
   if (allocated(IceDyn_DataData%InputTimes)) then
      deallocate(IceDyn_DataData%InputTimes)
   end if
   if (allocated(IceDyn_DataData%InputTimes_Saved)) then
      deallocate(IceDyn_DataData%InputTimes_Saved)
   end if
end subroutine

subroutine FAST_PackIceDyn_Data(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(IceDyn_Data), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FAST_PackIceDyn_Data'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%x))
   if (allocated(InData%x)) then
      call RegPackBounds(RF, 2, lbound(InData%x), ubound(InData%x))
      LB(1:2) = lbound(InData%x)
      UB(1:2) = ubound(InData%x)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_PackContState(RF, InData%x(i1,i2)) 
         end do
      end do
   end if
   call RegPack(RF, allocated(InData%xd))
   if (allocated(InData%xd)) then
      call RegPackBounds(RF, 2, lbound(InData%xd), ubound(InData%xd))
      LB(1:2) = lbound(InData%xd)
      UB(1:2) = ubound(InData%xd)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_PackDiscState(RF, InData%xd(i1,i2)) 
         end do
      end do
   end if
   call RegPack(RF, allocated(InData%z))
   if (allocated(InData%z)) then
      call RegPackBounds(RF, 2, lbound(InData%z), ubound(InData%z))
      LB(1:2) = lbound(InData%z)
      UB(1:2) = ubound(InData%z)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_PackConstrState(RF, InData%z(i1,i2)) 
         end do
      end do
   end if
   call RegPack(RF, allocated(InData%OtherSt))
   if (allocated(InData%OtherSt)) then
      call RegPackBounds(RF, 2, lbound(InData%OtherSt), ubound(InData%OtherSt))
      LB(1:2) = lbound(InData%OtherSt)
      UB(1:2) = ubound(InData%OtherSt)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_PackOtherState(RF, InData%OtherSt(i1,i2)) 
         end do
      end do
   end if
   call RegPack(RF, allocated(InData%p))
   if (allocated(InData%p)) then
      call RegPackBounds(RF, 1, lbound(InData%p), ubound(InData%p))
      LB(1:1) = lbound(InData%p)
      UB(1:1) = ubound(InData%p)
      do i1 = LB(1), UB(1)
         call IceD_PackParam(RF, InData%p(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%u))
   if (allocated(InData%u)) then
      call RegPackBounds(RF, 1, lbound(InData%u), ubound(InData%u))
      LB(1:1) = lbound(InData%u)
      UB(1:1) = ubound(InData%u)
      do i1 = LB(1), UB(1)
         call IceD_PackInput(RF, InData%u(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%y))
   if (allocated(InData%y)) then
      call RegPackBounds(RF, 1, lbound(InData%y), ubound(InData%y))
      LB(1:1) = lbound(InData%y)
      UB(1:1) = ubound(InData%y)
      do i1 = LB(1), UB(1)
         call IceD_PackOutput(RF, InData%y(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%m))
   if (allocated(InData%m)) then
      call RegPackBounds(RF, 1, lbound(InData%m), ubound(InData%m))
      LB(1:1) = lbound(InData%m)
      UB(1:1) = ubound(InData%m)
      do i1 = LB(1), UB(1)
         call IceD_PackMisc(RF, InData%m(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%Input))
   if (allocated(InData%Input)) then
      call RegPackBounds(RF, 2, lbound(InData%Input), ubound(InData%Input))
      LB(1:2) = lbound(InData%Input)
      UB(1:2) = ubound(InData%Input)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_PackInput(RF, InData%Input(i1,i2)) 
         end do
      end do
   end if
   call RegPack(RF, allocated(InData%Input_Saved))
   if (allocated(InData%Input_Saved)) then
      call RegPackBounds(RF, 2, lbound(InData%Input_Saved), ubound(InData%Input_Saved))
      LB(1:2) = lbound(InData%Input_Saved)
      UB(1:2) = ubound(InData%Input_Saved)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_PackInput(RF, InData%Input_Saved(i1,i2)) 
         end do
      end do
   end if
   call RegPackAlloc(RF, InData%InputTimes)
   call RegPackAlloc(RF, InData%InputTimes_Saved)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_UnPackIceDyn_Data(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(IceDyn_Data), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FAST_UnPackIceDyn_Data'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%x)) deallocate(OutData%x)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 2, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%x(LB(1):UB(1),LB(2):UB(2)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%x.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_UnpackContState(RF, OutData%x(i1,i2)) ! x 
         end do
      end do
   end if
   if (allocated(OutData%xd)) deallocate(OutData%xd)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 2, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%xd(LB(1):UB(1),LB(2):UB(2)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%xd.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_UnpackDiscState(RF, OutData%xd(i1,i2)) ! xd 
         end do
      end do
   end if
   if (allocated(OutData%z)) deallocate(OutData%z)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 2, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%z(LB(1):UB(1),LB(2):UB(2)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%z.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_UnpackConstrState(RF, OutData%z(i1,i2)) ! z 
         end do
      end do
   end if
   if (allocated(OutData%OtherSt)) deallocate(OutData%OtherSt)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 2, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%OtherSt(LB(1):UB(1),LB(2):UB(2)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%OtherSt.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_UnpackOtherState(RF, OutData%OtherSt(i1,i2)) ! OtherSt 
         end do
      end do
   end if
   if (allocated(OutData%p)) deallocate(OutData%p)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%p(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%p.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call IceD_UnpackParam(RF, OutData%p(i1)) ! p 
      end do
   end if
   if (allocated(OutData%u)) deallocate(OutData%u)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%u(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%u.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call IceD_UnpackInput(RF, OutData%u(i1)) ! u 
      end do
   end if
   if (allocated(OutData%y)) deallocate(OutData%y)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%y(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%y.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call IceD_UnpackOutput(RF, OutData%y(i1)) ! y 
      end do
   end if
   if (allocated(OutData%m)) deallocate(OutData%m)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%m(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%m.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call IceD_UnpackMisc(RF, OutData%m(i1)) ! m 
      end do
   end if
   if (allocated(OutData%Input)) deallocate(OutData%Input)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 2, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Input(LB(1):UB(1),LB(2):UB(2)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Input.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_UnpackInput(RF, OutData%Input(i1,i2)) ! Input 
         end do
      end do
   end if
   if (allocated(OutData%Input_Saved)) deallocate(OutData%Input_Saved)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 2, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Input_Saved(LB(1):UB(1),LB(2):UB(2)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Input_Saved.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call IceD_UnpackInput(RF, OutData%Input_Saved(i1,i2)) ! Input_Saved 
         end do
      end do
   end if
   call RegUnpackAlloc(RF, OutData%InputTimes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%InputTimes_Saved); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_CopyBeamDyn_Data(SrcBeamDyn_DataData, DstBeamDyn_DataData, CtrlCode, ErrStat, ErrMsg)
   type(BeamDyn_Data), intent(inout) :: SrcBeamDyn_DataData
   type(BeamDyn_Data), intent(inout) :: DstBeamDyn_DataData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_CopyBeamDyn_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcBeamDyn_DataData%x)) then
      LB(1:2) = lbound(SrcBeamDyn_DataData%x)
      UB(1:2) = ubound(SrcBeamDyn_DataData%x)
      if (.not. allocated(DstBeamDyn_DataData%x)) then
         allocate(DstBeamDyn_DataData%x(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBeamDyn_DataData%x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_CopyContState(SrcBeamDyn_DataData%x(i1,i2), DstBeamDyn_DataData%x(i1,i2), CtrlCode, ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
            if (ErrStat >= AbortErrLev) return
         end do
      end do
   end if
   if (allocated(SrcBeamDyn_DataData%xd)) then
      LB(1:2) = lbound(SrcBeamDyn_DataData%xd)
      UB(1:2) = ubound(SrcBeamDyn_DataData%xd)
      if (.not. allocated(DstBeamDyn_DataData%xd)) then
         allocate(DstBeamDyn_DataData%xd(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBeamDyn_DataData%xd.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_CopyDiscState(SrcBeamDyn_DataData%xd(i1,i2), DstBeamDyn_DataData%xd(i1,i2), CtrlCode, ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
            if (ErrStat >= AbortErrLev) return
         end do
      end do
   end if
   if (allocated(SrcBeamDyn_DataData%z)) then
      LB(1:2) = lbound(SrcBeamDyn_DataData%z)
      UB(1:2) = ubound(SrcBeamDyn_DataData%z)
      if (.not. allocated(DstBeamDyn_DataData%z)) then
         allocate(DstBeamDyn_DataData%z(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBeamDyn_DataData%z.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_CopyConstrState(SrcBeamDyn_DataData%z(i1,i2), DstBeamDyn_DataData%z(i1,i2), CtrlCode, ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
            if (ErrStat >= AbortErrLev) return
         end do
      end do
   end if
   if (allocated(SrcBeamDyn_DataData%OtherSt)) then
      LB(1:2) = lbound(SrcBeamDyn_DataData%OtherSt)
      UB(1:2) = ubound(SrcBeamDyn_DataData%OtherSt)
      if (.not. allocated(DstBeamDyn_DataData%OtherSt)) then
         allocate(DstBeamDyn_DataData%OtherSt(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBeamDyn_DataData%OtherSt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_CopyOtherState(SrcBeamDyn_DataData%OtherSt(i1,i2), DstBeamDyn_DataData%OtherSt(i1,i2), CtrlCode, ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
            if (ErrStat >= AbortErrLev) return
         end do
      end do
   end if
   if (allocated(SrcBeamDyn_DataData%p)) then
      LB(1:1) = lbound(SrcBeamDyn_DataData%p)
      UB(1:1) = ubound(SrcBeamDyn_DataData%p)
      if (.not. allocated(DstBeamDyn_DataData%p)) then
         allocate(DstBeamDyn_DataData%p(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBeamDyn_DataData%p.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call BD_CopyParam(SrcBeamDyn_DataData%p(i1), DstBeamDyn_DataData%p(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcBeamDyn_DataData%u)) then
      LB(1:1) = lbound(SrcBeamDyn_DataData%u)
      UB(1:1) = ubound(SrcBeamDyn_DataData%u)
      if (.not. allocated(DstBeamDyn_DataData%u)) then
         allocate(DstBeamDyn_DataData%u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBeamDyn_DataData%u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call BD_CopyInput(SrcBeamDyn_DataData%u(i1), DstBeamDyn_DataData%u(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcBeamDyn_DataData%y)) then
      LB(1:1) = lbound(SrcBeamDyn_DataData%y)
      UB(1:1) = ubound(SrcBeamDyn_DataData%y)
      if (.not. allocated(DstBeamDyn_DataData%y)) then
         allocate(DstBeamDyn_DataData%y(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBeamDyn_DataData%y.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call BD_CopyOutput(SrcBeamDyn_DataData%y(i1), DstBeamDyn_DataData%y(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcBeamDyn_DataData%m)) then
      LB(1:1) = lbound(SrcBeamDyn_DataData%m)
      UB(1:1) = ubound(SrcBeamDyn_DataData%m)
      if (.not. allocated(DstBeamDyn_DataData%m)) then
         allocate(DstBeamDyn_DataData%m(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBeamDyn_DataData%m.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call BD_CopyMisc(SrcBeamDyn_DataData%m(i1), DstBeamDyn_DataData%m(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcBeamDyn_DataData%Output)) then
      LB(1:2) = lbound(SrcBeamDyn_DataData%Output)
      UB(1:2) = ubound(SrcBeamDyn_DataData%Output)
      if (.not. allocated(DstBeamDyn_DataData%Output)) then
         allocate(DstBeamDyn_DataData%Output(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBeamDyn_DataData%Output.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_CopyOutput(SrcBeamDyn_DataData%Output(i1,i2), DstBeamDyn_DataData%Output(i1,i2), CtrlCode, ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
            if (ErrStat >= AbortErrLev) return
         end do
      end do
   end if
   if (allocated(SrcBeamDyn_DataData%y_interp)) then
      LB(1:1) = lbound(SrcBeamDyn_DataData%y_interp)
      UB(1:1) = ubound(SrcBeamDyn_DataData%y_interp)
      if (.not. allocated(DstBeamDyn_DataData%y_interp)) then
         allocate(DstBeamDyn_DataData%y_interp(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBeamDyn_DataData%y_interp.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call BD_CopyOutput(SrcBeamDyn_DataData%y_interp(i1), DstBeamDyn_DataData%y_interp(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcBeamDyn_DataData%Input)) then
      LB(1:2) = lbound(SrcBeamDyn_DataData%Input)
      UB(1:2) = ubound(SrcBeamDyn_DataData%Input)
      if (.not. allocated(DstBeamDyn_DataData%Input)) then
         allocate(DstBeamDyn_DataData%Input(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBeamDyn_DataData%Input.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_CopyInput(SrcBeamDyn_DataData%Input(i1,i2), DstBeamDyn_DataData%Input(i1,i2), CtrlCode, ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
            if (ErrStat >= AbortErrLev) return
         end do
      end do
   end if
   if (allocated(SrcBeamDyn_DataData%Input_Saved)) then
      LB(1:2) = lbound(SrcBeamDyn_DataData%Input_Saved)
      UB(1:2) = ubound(SrcBeamDyn_DataData%Input_Saved)
      if (.not. allocated(DstBeamDyn_DataData%Input_Saved)) then
         allocate(DstBeamDyn_DataData%Input_Saved(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBeamDyn_DataData%Input_Saved.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_CopyInput(SrcBeamDyn_DataData%Input_Saved(i1,i2), DstBeamDyn_DataData%Input_Saved(i1,i2), CtrlCode, ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
            if (ErrStat >= AbortErrLev) return
         end do
      end do
   end if
   if (allocated(SrcBeamDyn_DataData%InputTimes)) then
      LB(1:2) = lbound(SrcBeamDyn_DataData%InputTimes)
      UB(1:2) = ubound(SrcBeamDyn_DataData%InputTimes)
      if (.not. allocated(DstBeamDyn_DataData%InputTimes)) then
         allocate(DstBeamDyn_DataData%InputTimes(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBeamDyn_DataData%InputTimes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBeamDyn_DataData%InputTimes = SrcBeamDyn_DataData%InputTimes
   end if
   if (allocated(SrcBeamDyn_DataData%InputTimes_Saved)) then
      LB(1:2) = lbound(SrcBeamDyn_DataData%InputTimes_Saved)
      UB(1:2) = ubound(SrcBeamDyn_DataData%InputTimes_Saved)
      if (.not. allocated(DstBeamDyn_DataData%InputTimes_Saved)) then
         allocate(DstBeamDyn_DataData%InputTimes_Saved(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBeamDyn_DataData%InputTimes_Saved.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBeamDyn_DataData%InputTimes_Saved = SrcBeamDyn_DataData%InputTimes_Saved
   end if
end subroutine

subroutine FAST_DestroyBeamDyn_Data(BeamDyn_DataData, ErrStat, ErrMsg)
   type(BeamDyn_Data), intent(inout) :: BeamDyn_DataData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_DestroyBeamDyn_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(BeamDyn_DataData%x)) then
      LB(1:2) = lbound(BeamDyn_DataData%x)
      UB(1:2) = ubound(BeamDyn_DataData%x)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_DestroyContState(BeamDyn_DataData%x(i1,i2), ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         end do
      end do
      deallocate(BeamDyn_DataData%x)
   end if
   if (allocated(BeamDyn_DataData%xd)) then
      LB(1:2) = lbound(BeamDyn_DataData%xd)
      UB(1:2) = ubound(BeamDyn_DataData%xd)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_DestroyDiscState(BeamDyn_DataData%xd(i1,i2), ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         end do
      end do
      deallocate(BeamDyn_DataData%xd)
   end if
   if (allocated(BeamDyn_DataData%z)) then
      LB(1:2) = lbound(BeamDyn_DataData%z)
      UB(1:2) = ubound(BeamDyn_DataData%z)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_DestroyConstrState(BeamDyn_DataData%z(i1,i2), ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         end do
      end do
      deallocate(BeamDyn_DataData%z)
   end if
   if (allocated(BeamDyn_DataData%OtherSt)) then
      LB(1:2) = lbound(BeamDyn_DataData%OtherSt)
      UB(1:2) = ubound(BeamDyn_DataData%OtherSt)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_DestroyOtherState(BeamDyn_DataData%OtherSt(i1,i2), ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         end do
      end do
      deallocate(BeamDyn_DataData%OtherSt)
   end if
   if (allocated(BeamDyn_DataData%p)) then
      LB(1:1) = lbound(BeamDyn_DataData%p)
      UB(1:1) = ubound(BeamDyn_DataData%p)
      do i1 = LB(1), UB(1)
         call BD_DestroyParam(BeamDyn_DataData%p(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(BeamDyn_DataData%p)
   end if
   if (allocated(BeamDyn_DataData%u)) then
      LB(1:1) = lbound(BeamDyn_DataData%u)
      UB(1:1) = ubound(BeamDyn_DataData%u)
      do i1 = LB(1), UB(1)
         call BD_DestroyInput(BeamDyn_DataData%u(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(BeamDyn_DataData%u)
   end if
   if (allocated(BeamDyn_DataData%y)) then
      LB(1:1) = lbound(BeamDyn_DataData%y)
      UB(1:1) = ubound(BeamDyn_DataData%y)
      do i1 = LB(1), UB(1)
         call BD_DestroyOutput(BeamDyn_DataData%y(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(BeamDyn_DataData%y)
   end if
   if (allocated(BeamDyn_DataData%m)) then
      LB(1:1) = lbound(BeamDyn_DataData%m)
      UB(1:1) = ubound(BeamDyn_DataData%m)
      do i1 = LB(1), UB(1)
         call BD_DestroyMisc(BeamDyn_DataData%m(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(BeamDyn_DataData%m)
   end if
   if (allocated(BeamDyn_DataData%Output)) then
      LB(1:2) = lbound(BeamDyn_DataData%Output)
      UB(1:2) = ubound(BeamDyn_DataData%Output)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_DestroyOutput(BeamDyn_DataData%Output(i1,i2), ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         end do
      end do
      deallocate(BeamDyn_DataData%Output)
   end if
   if (allocated(BeamDyn_DataData%y_interp)) then
      LB(1:1) = lbound(BeamDyn_DataData%y_interp)
      UB(1:1) = ubound(BeamDyn_DataData%y_interp)
      do i1 = LB(1), UB(1)
         call BD_DestroyOutput(BeamDyn_DataData%y_interp(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(BeamDyn_DataData%y_interp)
   end if
   if (allocated(BeamDyn_DataData%Input)) then
      LB(1:2) = lbound(BeamDyn_DataData%Input)
      UB(1:2) = ubound(BeamDyn_DataData%Input)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_DestroyInput(BeamDyn_DataData%Input(i1,i2), ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         end do
      end do
      deallocate(BeamDyn_DataData%Input)
   end if
   if (allocated(BeamDyn_DataData%Input_Saved)) then
      LB(1:2) = lbound(BeamDyn_DataData%Input_Saved)
      UB(1:2) = ubound(BeamDyn_DataData%Input_Saved)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_DestroyInput(BeamDyn_DataData%Input_Saved(i1,i2), ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         end do
      end do
      deallocate(BeamDyn_DataData%Input_Saved)
   end if
   if (allocated(BeamDyn_DataData%InputTimes)) then
      deallocate(BeamDyn_DataData%InputTimes)
   end if
   if (allocated(BeamDyn_DataData%InputTimes_Saved)) then
      deallocate(BeamDyn_DataData%InputTimes_Saved)
   end if
end subroutine

subroutine FAST_PackBeamDyn_Data(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(BeamDyn_Data), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FAST_PackBeamDyn_Data'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%x))
   if (allocated(InData%x)) then
      call RegPackBounds(RF, 2, lbound(InData%x), ubound(InData%x))
      LB(1:2) = lbound(InData%x)
      UB(1:2) = ubound(InData%x)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_PackContState(RF, InData%x(i1,i2)) 
         end do
      end do
   end if
   call RegPack(RF, allocated(InData%xd))
   if (allocated(InData%xd)) then
      call RegPackBounds(RF, 2, lbound(InData%xd), ubound(InData%xd))
      LB(1:2) = lbound(InData%xd)
      UB(1:2) = ubound(InData%xd)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_PackDiscState(RF, InData%xd(i1,i2)) 
         end do
      end do
   end if
   call RegPack(RF, allocated(InData%z))
   if (allocated(InData%z)) then
      call RegPackBounds(RF, 2, lbound(InData%z), ubound(InData%z))
      LB(1:2) = lbound(InData%z)
      UB(1:2) = ubound(InData%z)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_PackConstrState(RF, InData%z(i1,i2)) 
         end do
      end do
   end if
   call RegPack(RF, allocated(InData%OtherSt))
   if (allocated(InData%OtherSt)) then
      call RegPackBounds(RF, 2, lbound(InData%OtherSt), ubound(InData%OtherSt))
      LB(1:2) = lbound(InData%OtherSt)
      UB(1:2) = ubound(InData%OtherSt)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_PackOtherState(RF, InData%OtherSt(i1,i2)) 
         end do
      end do
   end if
   call RegPack(RF, allocated(InData%p))
   if (allocated(InData%p)) then
      call RegPackBounds(RF, 1, lbound(InData%p), ubound(InData%p))
      LB(1:1) = lbound(InData%p)
      UB(1:1) = ubound(InData%p)
      do i1 = LB(1), UB(1)
         call BD_PackParam(RF, InData%p(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%u))
   if (allocated(InData%u)) then
      call RegPackBounds(RF, 1, lbound(InData%u), ubound(InData%u))
      LB(1:1) = lbound(InData%u)
      UB(1:1) = ubound(InData%u)
      do i1 = LB(1), UB(1)
         call BD_PackInput(RF, InData%u(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%y))
   if (allocated(InData%y)) then
      call RegPackBounds(RF, 1, lbound(InData%y), ubound(InData%y))
      LB(1:1) = lbound(InData%y)
      UB(1:1) = ubound(InData%y)
      do i1 = LB(1), UB(1)
         call BD_PackOutput(RF, InData%y(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%m))
   if (allocated(InData%m)) then
      call RegPackBounds(RF, 1, lbound(InData%m), ubound(InData%m))
      LB(1:1) = lbound(InData%m)
      UB(1:1) = ubound(InData%m)
      do i1 = LB(1), UB(1)
         call BD_PackMisc(RF, InData%m(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%Output))
   if (allocated(InData%Output)) then
      call RegPackBounds(RF, 2, lbound(InData%Output), ubound(InData%Output))
      LB(1:2) = lbound(InData%Output)
      UB(1:2) = ubound(InData%Output)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_PackOutput(RF, InData%Output(i1,i2)) 
         end do
      end do
   end if
   call RegPack(RF, allocated(InData%y_interp))
   if (allocated(InData%y_interp)) then
      call RegPackBounds(RF, 1, lbound(InData%y_interp), ubound(InData%y_interp))
      LB(1:1) = lbound(InData%y_interp)
      UB(1:1) = ubound(InData%y_interp)
      do i1 = LB(1), UB(1)
         call BD_PackOutput(RF, InData%y_interp(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%Input))
   if (allocated(InData%Input)) then
      call RegPackBounds(RF, 2, lbound(InData%Input), ubound(InData%Input))
      LB(1:2) = lbound(InData%Input)
      UB(1:2) = ubound(InData%Input)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_PackInput(RF, InData%Input(i1,i2)) 
         end do
      end do
   end if
   call RegPack(RF, allocated(InData%Input_Saved))
   if (allocated(InData%Input_Saved)) then
      call RegPackBounds(RF, 2, lbound(InData%Input_Saved), ubound(InData%Input_Saved))
      LB(1:2) = lbound(InData%Input_Saved)
      UB(1:2) = ubound(InData%Input_Saved)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_PackInput(RF, InData%Input_Saved(i1,i2)) 
         end do
      end do
   end if
   call RegPackAlloc(RF, InData%InputTimes)
   call RegPackAlloc(RF, InData%InputTimes_Saved)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_UnPackBeamDyn_Data(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(BeamDyn_Data), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FAST_UnPackBeamDyn_Data'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%x)) deallocate(OutData%x)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 2, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%x(LB(1):UB(1),LB(2):UB(2)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%x.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_UnpackContState(RF, OutData%x(i1,i2)) ! x 
         end do
      end do
   end if
   if (allocated(OutData%xd)) deallocate(OutData%xd)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 2, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%xd(LB(1):UB(1),LB(2):UB(2)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%xd.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_UnpackDiscState(RF, OutData%xd(i1,i2)) ! xd 
         end do
      end do
   end if
   if (allocated(OutData%z)) deallocate(OutData%z)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 2, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%z(LB(1):UB(1),LB(2):UB(2)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%z.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_UnpackConstrState(RF, OutData%z(i1,i2)) ! z 
         end do
      end do
   end if
   if (allocated(OutData%OtherSt)) deallocate(OutData%OtherSt)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 2, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%OtherSt(LB(1):UB(1),LB(2):UB(2)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%OtherSt.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_UnpackOtherState(RF, OutData%OtherSt(i1,i2)) ! OtherSt 
         end do
      end do
   end if
   if (allocated(OutData%p)) deallocate(OutData%p)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%p(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%p.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call BD_UnpackParam(RF, OutData%p(i1)) ! p 
      end do
   end if
   if (allocated(OutData%u)) deallocate(OutData%u)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%u(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%u.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call BD_UnpackInput(RF, OutData%u(i1)) ! u 
      end do
   end if
   if (allocated(OutData%y)) deallocate(OutData%y)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%y(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%y.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call BD_UnpackOutput(RF, OutData%y(i1)) ! y 
      end do
   end if
   if (allocated(OutData%m)) deallocate(OutData%m)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%m(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%m.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call BD_UnpackMisc(RF, OutData%m(i1)) ! m 
      end do
   end if
   if (allocated(OutData%Output)) deallocate(OutData%Output)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 2, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Output(LB(1):UB(1),LB(2):UB(2)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Output.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_UnpackOutput(RF, OutData%Output(i1,i2)) ! Output 
         end do
      end do
   end if
   if (allocated(OutData%y_interp)) deallocate(OutData%y_interp)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%y_interp(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%y_interp.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call BD_UnpackOutput(RF, OutData%y_interp(i1)) ! y_interp 
      end do
   end if
   if (allocated(OutData%Input)) deallocate(OutData%Input)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 2, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Input(LB(1):UB(1),LB(2):UB(2)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Input.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_UnpackInput(RF, OutData%Input(i1,i2)) ! Input 
         end do
      end do
   end if
   if (allocated(OutData%Input_Saved)) deallocate(OutData%Input_Saved)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 2, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Input_Saved(LB(1):UB(1),LB(2):UB(2)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Input_Saved.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call BD_UnpackInput(RF, OutData%Input_Saved(i1,i2)) ! Input_Saved 
         end do
      end do
   end if
   call RegUnpackAlloc(RF, OutData%InputTimes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%InputTimes_Saved); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_CopyElastoDyn_Data(SrcElastoDyn_DataData, DstElastoDyn_DataData, CtrlCode, ErrStat, ErrMsg)
   type(ElastoDyn_Data), intent(inout) :: SrcElastoDyn_DataData
   type(ElastoDyn_Data), intent(inout) :: DstElastoDyn_DataData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_CopyElastoDyn_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   LB(1:1) = lbound(SrcElastoDyn_DataData%x)
   UB(1:1) = ubound(SrcElastoDyn_DataData%x)
   do i1 = LB(1), UB(1)
      call ED_CopyContState(SrcElastoDyn_DataData%x(i1), DstElastoDyn_DataData%x(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcElastoDyn_DataData%xd)
   UB(1:1) = ubound(SrcElastoDyn_DataData%xd)
   do i1 = LB(1), UB(1)
      call ED_CopyDiscState(SrcElastoDyn_DataData%xd(i1), DstElastoDyn_DataData%xd(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcElastoDyn_DataData%z)
   UB(1:1) = ubound(SrcElastoDyn_DataData%z)
   do i1 = LB(1), UB(1)
      call ED_CopyConstrState(SrcElastoDyn_DataData%z(i1), DstElastoDyn_DataData%z(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcElastoDyn_DataData%OtherSt)
   UB(1:1) = ubound(SrcElastoDyn_DataData%OtherSt)
   do i1 = LB(1), UB(1)
      call ED_CopyOtherState(SrcElastoDyn_DataData%OtherSt(i1), DstElastoDyn_DataData%OtherSt(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   call ED_CopyParam(SrcElastoDyn_DataData%p, DstElastoDyn_DataData%p, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call ED_CopyInput(SrcElastoDyn_DataData%u, DstElastoDyn_DataData%u, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call ED_CopyOutput(SrcElastoDyn_DataData%y, DstElastoDyn_DataData%y, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call ED_CopyMisc(SrcElastoDyn_DataData%m, DstElastoDyn_DataData%m, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcElastoDyn_DataData%Output)) then
      LB(1:1) = lbound(SrcElastoDyn_DataData%Output)
      UB(1:1) = ubound(SrcElastoDyn_DataData%Output)
      if (.not. allocated(DstElastoDyn_DataData%Output)) then
         allocate(DstElastoDyn_DataData%Output(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstElastoDyn_DataData%Output.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call ED_CopyOutput(SrcElastoDyn_DataData%Output(i1), DstElastoDyn_DataData%Output(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcElastoDyn_DataData%Output_bak)) then
      LB(1:1) = lbound(SrcElastoDyn_DataData%Output_bak)
      UB(1:1) = ubound(SrcElastoDyn_DataData%Output_bak)
      if (.not. allocated(DstElastoDyn_DataData%Output_bak)) then
         allocate(DstElastoDyn_DataData%Output_bak(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstElastoDyn_DataData%Output_bak.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call ED_CopyOutput(SrcElastoDyn_DataData%Output_bak(i1), DstElastoDyn_DataData%Output_bak(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call ED_CopyOutput(SrcElastoDyn_DataData%y_interp, DstElastoDyn_DataData%y_interp, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcElastoDyn_DataData%Input)) then
      LB(1:1) = lbound(SrcElastoDyn_DataData%Input)
      UB(1:1) = ubound(SrcElastoDyn_DataData%Input)
      if (.not. allocated(DstElastoDyn_DataData%Input)) then
         allocate(DstElastoDyn_DataData%Input(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstElastoDyn_DataData%Input.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call ED_CopyInput(SrcElastoDyn_DataData%Input(i1), DstElastoDyn_DataData%Input(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcElastoDyn_DataData%Input_Saved)) then
      LB(1:1) = lbound(SrcElastoDyn_DataData%Input_Saved)
      UB(1:1) = ubound(SrcElastoDyn_DataData%Input_Saved)
      if (.not. allocated(DstElastoDyn_DataData%Input_Saved)) then
         allocate(DstElastoDyn_DataData%Input_Saved(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstElastoDyn_DataData%Input_Saved.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call ED_CopyInput(SrcElastoDyn_DataData%Input_Saved(i1), DstElastoDyn_DataData%Input_Saved(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcElastoDyn_DataData%InputTimes)) then
      LB(1:1) = lbound(SrcElastoDyn_DataData%InputTimes)
      UB(1:1) = ubound(SrcElastoDyn_DataData%InputTimes)
      if (.not. allocated(DstElastoDyn_DataData%InputTimes)) then
         allocate(DstElastoDyn_DataData%InputTimes(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstElastoDyn_DataData%InputTimes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstElastoDyn_DataData%InputTimes = SrcElastoDyn_DataData%InputTimes
   end if
   if (allocated(SrcElastoDyn_DataData%InputTimes_Saved)) then
      LB(1:1) = lbound(SrcElastoDyn_DataData%InputTimes_Saved)
      UB(1:1) = ubound(SrcElastoDyn_DataData%InputTimes_Saved)
      if (.not. allocated(DstElastoDyn_DataData%InputTimes_Saved)) then
         allocate(DstElastoDyn_DataData%InputTimes_Saved(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstElastoDyn_DataData%InputTimes_Saved.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstElastoDyn_DataData%InputTimes_Saved = SrcElastoDyn_DataData%InputTimes_Saved
   end if
end subroutine

subroutine FAST_DestroyElastoDyn_Data(ElastoDyn_DataData, ErrStat, ErrMsg)
   type(ElastoDyn_Data), intent(inout) :: ElastoDyn_DataData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_DestroyElastoDyn_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   LB(1:1) = lbound(ElastoDyn_DataData%x)
   UB(1:1) = ubound(ElastoDyn_DataData%x)
   do i1 = LB(1), UB(1)
      call ED_DestroyContState(ElastoDyn_DataData%x(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(ElastoDyn_DataData%xd)
   UB(1:1) = ubound(ElastoDyn_DataData%xd)
   do i1 = LB(1), UB(1)
      call ED_DestroyDiscState(ElastoDyn_DataData%xd(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(ElastoDyn_DataData%z)
   UB(1:1) = ubound(ElastoDyn_DataData%z)
   do i1 = LB(1), UB(1)
      call ED_DestroyConstrState(ElastoDyn_DataData%z(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(ElastoDyn_DataData%OtherSt)
   UB(1:1) = ubound(ElastoDyn_DataData%OtherSt)
   do i1 = LB(1), UB(1)
      call ED_DestroyOtherState(ElastoDyn_DataData%OtherSt(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   call ED_DestroyParam(ElastoDyn_DataData%p, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call ED_DestroyInput(ElastoDyn_DataData%u, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call ED_DestroyOutput(ElastoDyn_DataData%y, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call ED_DestroyMisc(ElastoDyn_DataData%m, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(ElastoDyn_DataData%Output)) then
      LB(1:1) = lbound(ElastoDyn_DataData%Output)
      UB(1:1) = ubound(ElastoDyn_DataData%Output)
      do i1 = LB(1), UB(1)
         call ED_DestroyOutput(ElastoDyn_DataData%Output(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ElastoDyn_DataData%Output)
   end if
   if (allocated(ElastoDyn_DataData%Output_bak)) then
      LB(1:1) = lbound(ElastoDyn_DataData%Output_bak)
      UB(1:1) = ubound(ElastoDyn_DataData%Output_bak)
      do i1 = LB(1), UB(1)
         call ED_DestroyOutput(ElastoDyn_DataData%Output_bak(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ElastoDyn_DataData%Output_bak)
   end if
   call ED_DestroyOutput(ElastoDyn_DataData%y_interp, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(ElastoDyn_DataData%Input)) then
      LB(1:1) = lbound(ElastoDyn_DataData%Input)
      UB(1:1) = ubound(ElastoDyn_DataData%Input)
      do i1 = LB(1), UB(1)
         call ED_DestroyInput(ElastoDyn_DataData%Input(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ElastoDyn_DataData%Input)
   end if
   if (allocated(ElastoDyn_DataData%Input_Saved)) then
      LB(1:1) = lbound(ElastoDyn_DataData%Input_Saved)
      UB(1:1) = ubound(ElastoDyn_DataData%Input_Saved)
      do i1 = LB(1), UB(1)
         call ED_DestroyInput(ElastoDyn_DataData%Input_Saved(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ElastoDyn_DataData%Input_Saved)
   end if
   if (allocated(ElastoDyn_DataData%InputTimes)) then
      deallocate(ElastoDyn_DataData%InputTimes)
   end if
   if (allocated(ElastoDyn_DataData%InputTimes_Saved)) then
      deallocate(ElastoDyn_DataData%InputTimes_Saved)
   end if
end subroutine

subroutine FAST_PackElastoDyn_Data(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ElastoDyn_Data), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FAST_PackElastoDyn_Data'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   LB(1:1) = lbound(InData%x)
   UB(1:1) = ubound(InData%x)
   do i1 = LB(1), UB(1)
      call ED_PackContState(RF, InData%x(i1)) 
   end do
   LB(1:1) = lbound(InData%xd)
   UB(1:1) = ubound(InData%xd)
   do i1 = LB(1), UB(1)
      call ED_PackDiscState(RF, InData%xd(i1)) 
   end do
   LB(1:1) = lbound(InData%z)
   UB(1:1) = ubound(InData%z)
   do i1 = LB(1), UB(1)
      call ED_PackConstrState(RF, InData%z(i1)) 
   end do
   LB(1:1) = lbound(InData%OtherSt)
   UB(1:1) = ubound(InData%OtherSt)
   do i1 = LB(1), UB(1)
      call ED_PackOtherState(RF, InData%OtherSt(i1)) 
   end do
   call ED_PackParam(RF, InData%p) 
   call ED_PackInput(RF, InData%u) 
   call ED_PackOutput(RF, InData%y) 
   call ED_PackMisc(RF, InData%m) 
   call RegPack(RF, allocated(InData%Output))
   if (allocated(InData%Output)) then
      call RegPackBounds(RF, 1, lbound(InData%Output), ubound(InData%Output))
      LB(1:1) = lbound(InData%Output)
      UB(1:1) = ubound(InData%Output)
      do i1 = LB(1), UB(1)
         call ED_PackOutput(RF, InData%Output(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%Output_bak))
   if (allocated(InData%Output_bak)) then
      call RegPackBounds(RF, 1, lbound(InData%Output_bak), ubound(InData%Output_bak))
      LB(1:1) = lbound(InData%Output_bak)
      UB(1:1) = ubound(InData%Output_bak)
      do i1 = LB(1), UB(1)
         call ED_PackOutput(RF, InData%Output_bak(i1)) 
      end do
   end if
   call ED_PackOutput(RF, InData%y_interp) 
   call RegPack(RF, allocated(InData%Input))
   if (allocated(InData%Input)) then
      call RegPackBounds(RF, 1, lbound(InData%Input), ubound(InData%Input))
      LB(1:1) = lbound(InData%Input)
      UB(1:1) = ubound(InData%Input)
      do i1 = LB(1), UB(1)
         call ED_PackInput(RF, InData%Input(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%Input_Saved))
   if (allocated(InData%Input_Saved)) then
      call RegPackBounds(RF, 1, lbound(InData%Input_Saved), ubound(InData%Input_Saved))
      LB(1:1) = lbound(InData%Input_Saved)
      UB(1:1) = ubound(InData%Input_Saved)
      do i1 = LB(1), UB(1)
         call ED_PackInput(RF, InData%Input_Saved(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%InputTimes)
   call RegPackAlloc(RF, InData%InputTimes_Saved)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_UnPackElastoDyn_Data(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ElastoDyn_Data), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FAST_UnPackElastoDyn_Data'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   LB(1:1) = lbound(OutData%x)
   UB(1:1) = ubound(OutData%x)
   do i1 = LB(1), UB(1)
      call ED_UnpackContState(RF, OutData%x(i1)) ! x 
   end do
   LB(1:1) = lbound(OutData%xd)
   UB(1:1) = ubound(OutData%xd)
   do i1 = LB(1), UB(1)
      call ED_UnpackDiscState(RF, OutData%xd(i1)) ! xd 
   end do
   LB(1:1) = lbound(OutData%z)
   UB(1:1) = ubound(OutData%z)
   do i1 = LB(1), UB(1)
      call ED_UnpackConstrState(RF, OutData%z(i1)) ! z 
   end do
   LB(1:1) = lbound(OutData%OtherSt)
   UB(1:1) = ubound(OutData%OtherSt)
   do i1 = LB(1), UB(1)
      call ED_UnpackOtherState(RF, OutData%OtherSt(i1)) ! OtherSt 
   end do
   call ED_UnpackParam(RF, OutData%p) ! p 
   call ED_UnpackInput(RF, OutData%u) ! u 
   call ED_UnpackOutput(RF, OutData%y) ! y 
   call ED_UnpackMisc(RF, OutData%m) ! m 
   if (allocated(OutData%Output)) deallocate(OutData%Output)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Output(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Output.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call ED_UnpackOutput(RF, OutData%Output(i1)) ! Output 
      end do
   end if
   if (allocated(OutData%Output_bak)) deallocate(OutData%Output_bak)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Output_bak(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Output_bak.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call ED_UnpackOutput(RF, OutData%Output_bak(i1)) ! Output_bak 
      end do
   end if
   call ED_UnpackOutput(RF, OutData%y_interp) ! y_interp 
   if (allocated(OutData%Input)) deallocate(OutData%Input)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Input(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Input.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call ED_UnpackInput(RF, OutData%Input(i1)) ! Input 
      end do
   end if
   if (allocated(OutData%Input_Saved)) deallocate(OutData%Input_Saved)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Input_Saved(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Input_Saved.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call ED_UnpackInput(RF, OutData%Input_Saved(i1)) ! Input_Saved 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%InputTimes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%InputTimes_Saved); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_CopySED_Data(SrcSED_DataData, DstSED_DataData, CtrlCode, ErrStat, ErrMsg)
   type(SED_Data), intent(inout) :: SrcSED_DataData
   type(SED_Data), intent(inout) :: DstSED_DataData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_CopySED_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   LB(1:1) = lbound(SrcSED_DataData%x)
   UB(1:1) = ubound(SrcSED_DataData%x)
   do i1 = LB(1), UB(1)
      call SED_CopyContState(SrcSED_DataData%x(i1), DstSED_DataData%x(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcSED_DataData%xd)
   UB(1:1) = ubound(SrcSED_DataData%xd)
   do i1 = LB(1), UB(1)
      call SED_CopyDiscState(SrcSED_DataData%xd(i1), DstSED_DataData%xd(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcSED_DataData%z)
   UB(1:1) = ubound(SrcSED_DataData%z)
   do i1 = LB(1), UB(1)
      call SED_CopyConstrState(SrcSED_DataData%z(i1), DstSED_DataData%z(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcSED_DataData%OtherSt)
   UB(1:1) = ubound(SrcSED_DataData%OtherSt)
   do i1 = LB(1), UB(1)
      call SED_CopyOtherState(SrcSED_DataData%OtherSt(i1), DstSED_DataData%OtherSt(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   call SED_CopyParam(SrcSED_DataData%p, DstSED_DataData%p, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call SED_CopyInput(SrcSED_DataData%u, DstSED_DataData%u, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call SED_CopyOutput(SrcSED_DataData%y, DstSED_DataData%y, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call SED_CopyMisc(SrcSED_DataData%m, DstSED_DataData%m, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcSED_DataData%Output)) then
      LB(1:1) = lbound(SrcSED_DataData%Output)
      UB(1:1) = ubound(SrcSED_DataData%Output)
      if (.not. allocated(DstSED_DataData%Output)) then
         allocate(DstSED_DataData%Output(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstSED_DataData%Output.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call SED_CopyOutput(SrcSED_DataData%Output(i1), DstSED_DataData%Output(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call SED_CopyOutput(SrcSED_DataData%y_interp, DstSED_DataData%y_interp, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcSED_DataData%Input)) then
      LB(1:1) = lbound(SrcSED_DataData%Input)
      UB(1:1) = ubound(SrcSED_DataData%Input)
      if (.not. allocated(DstSED_DataData%Input)) then
         allocate(DstSED_DataData%Input(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstSED_DataData%Input.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call SED_CopyInput(SrcSED_DataData%Input(i1), DstSED_DataData%Input(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcSED_DataData%InputTimes)) then
      LB(1:1) = lbound(SrcSED_DataData%InputTimes)
      UB(1:1) = ubound(SrcSED_DataData%InputTimes)
      if (.not. allocated(DstSED_DataData%InputTimes)) then
         allocate(DstSED_DataData%InputTimes(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstSED_DataData%InputTimes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstSED_DataData%InputTimes = SrcSED_DataData%InputTimes
   end if
end subroutine

subroutine FAST_DestroySED_Data(SED_DataData, ErrStat, ErrMsg)
   type(SED_Data), intent(inout) :: SED_DataData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_DestroySED_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   LB(1:1) = lbound(SED_DataData%x)
   UB(1:1) = ubound(SED_DataData%x)
   do i1 = LB(1), UB(1)
      call SED_DestroyContState(SED_DataData%x(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(SED_DataData%xd)
   UB(1:1) = ubound(SED_DataData%xd)
   do i1 = LB(1), UB(1)
      call SED_DestroyDiscState(SED_DataData%xd(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(SED_DataData%z)
   UB(1:1) = ubound(SED_DataData%z)
   do i1 = LB(1), UB(1)
      call SED_DestroyConstrState(SED_DataData%z(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(SED_DataData%OtherSt)
   UB(1:1) = ubound(SED_DataData%OtherSt)
   do i1 = LB(1), UB(1)
      call SED_DestroyOtherState(SED_DataData%OtherSt(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   call SED_DestroyParam(SED_DataData%p, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call SED_DestroyInput(SED_DataData%u, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call SED_DestroyOutput(SED_DataData%y, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call SED_DestroyMisc(SED_DataData%m, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(SED_DataData%Output)) then
      LB(1:1) = lbound(SED_DataData%Output)
      UB(1:1) = ubound(SED_DataData%Output)
      do i1 = LB(1), UB(1)
         call SED_DestroyOutput(SED_DataData%Output(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(SED_DataData%Output)
   end if
   call SED_DestroyOutput(SED_DataData%y_interp, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(SED_DataData%Input)) then
      LB(1:1) = lbound(SED_DataData%Input)
      UB(1:1) = ubound(SED_DataData%Input)
      do i1 = LB(1), UB(1)
         call SED_DestroyInput(SED_DataData%Input(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(SED_DataData%Input)
   end if
   if (allocated(SED_DataData%InputTimes)) then
      deallocate(SED_DataData%InputTimes)
   end if
end subroutine

subroutine FAST_PackSED_Data(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SED_Data), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FAST_PackSED_Data'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   LB(1:1) = lbound(InData%x)
   UB(1:1) = ubound(InData%x)
   do i1 = LB(1), UB(1)
      call SED_PackContState(RF, InData%x(i1)) 
   end do
   LB(1:1) = lbound(InData%xd)
   UB(1:1) = ubound(InData%xd)
   do i1 = LB(1), UB(1)
      call SED_PackDiscState(RF, InData%xd(i1)) 
   end do
   LB(1:1) = lbound(InData%z)
   UB(1:1) = ubound(InData%z)
   do i1 = LB(1), UB(1)
      call SED_PackConstrState(RF, InData%z(i1)) 
   end do
   LB(1:1) = lbound(InData%OtherSt)
   UB(1:1) = ubound(InData%OtherSt)
   do i1 = LB(1), UB(1)
      call SED_PackOtherState(RF, InData%OtherSt(i1)) 
   end do
   call SED_PackParam(RF, InData%p) 
   call SED_PackInput(RF, InData%u) 
   call SED_PackOutput(RF, InData%y) 
   call SED_PackMisc(RF, InData%m) 
   call RegPack(RF, allocated(InData%Output))
   if (allocated(InData%Output)) then
      call RegPackBounds(RF, 1, lbound(InData%Output), ubound(InData%Output))
      LB(1:1) = lbound(InData%Output)
      UB(1:1) = ubound(InData%Output)
      do i1 = LB(1), UB(1)
         call SED_PackOutput(RF, InData%Output(i1)) 
      end do
   end if
   call SED_PackOutput(RF, InData%y_interp) 
   call RegPack(RF, allocated(InData%Input))
   if (allocated(InData%Input)) then
      call RegPackBounds(RF, 1, lbound(InData%Input), ubound(InData%Input))
      LB(1:1) = lbound(InData%Input)
      UB(1:1) = ubound(InData%Input)
      do i1 = LB(1), UB(1)
         call SED_PackInput(RF, InData%Input(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%InputTimes)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_UnPackSED_Data(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SED_Data), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FAST_UnPackSED_Data'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   LB(1:1) = lbound(OutData%x)
   UB(1:1) = ubound(OutData%x)
   do i1 = LB(1), UB(1)
      call SED_UnpackContState(RF, OutData%x(i1)) ! x 
   end do
   LB(1:1) = lbound(OutData%xd)
   UB(1:1) = ubound(OutData%xd)
   do i1 = LB(1), UB(1)
      call SED_UnpackDiscState(RF, OutData%xd(i1)) ! xd 
   end do
   LB(1:1) = lbound(OutData%z)
   UB(1:1) = ubound(OutData%z)
   do i1 = LB(1), UB(1)
      call SED_UnpackConstrState(RF, OutData%z(i1)) ! z 
   end do
   LB(1:1) = lbound(OutData%OtherSt)
   UB(1:1) = ubound(OutData%OtherSt)
   do i1 = LB(1), UB(1)
      call SED_UnpackOtherState(RF, OutData%OtherSt(i1)) ! OtherSt 
   end do
   call SED_UnpackParam(RF, OutData%p) ! p 
   call SED_UnpackInput(RF, OutData%u) ! u 
   call SED_UnpackOutput(RF, OutData%y) ! y 
   call SED_UnpackMisc(RF, OutData%m) ! m 
   if (allocated(OutData%Output)) deallocate(OutData%Output)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Output(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Output.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call SED_UnpackOutput(RF, OutData%Output(i1)) ! Output 
      end do
   end if
   call SED_UnpackOutput(RF, OutData%y_interp) ! y_interp 
   if (allocated(OutData%Input)) deallocate(OutData%Input)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Input(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Input.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call SED_UnpackInput(RF, OutData%Input(i1)) ! Input 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%InputTimes); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_CopyServoDyn_Data(SrcServoDyn_DataData, DstServoDyn_DataData, CtrlCode, ErrStat, ErrMsg)
   type(ServoDyn_Data), intent(inout) :: SrcServoDyn_DataData
   type(ServoDyn_Data), intent(inout) :: DstServoDyn_DataData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_CopyServoDyn_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   LB(1:1) = lbound(SrcServoDyn_DataData%x)
   UB(1:1) = ubound(SrcServoDyn_DataData%x)
   do i1 = LB(1), UB(1)
      call SrvD_CopyContState(SrcServoDyn_DataData%x(i1), DstServoDyn_DataData%x(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcServoDyn_DataData%xd)
   UB(1:1) = ubound(SrcServoDyn_DataData%xd)
   do i1 = LB(1), UB(1)
      call SrvD_CopyDiscState(SrcServoDyn_DataData%xd(i1), DstServoDyn_DataData%xd(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcServoDyn_DataData%z)
   UB(1:1) = ubound(SrcServoDyn_DataData%z)
   do i1 = LB(1), UB(1)
      call SrvD_CopyConstrState(SrcServoDyn_DataData%z(i1), DstServoDyn_DataData%z(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcServoDyn_DataData%OtherSt)
   UB(1:1) = ubound(SrcServoDyn_DataData%OtherSt)
   do i1 = LB(1), UB(1)
      call SrvD_CopyOtherState(SrcServoDyn_DataData%OtherSt(i1), DstServoDyn_DataData%OtherSt(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   call SrvD_CopyParam(SrcServoDyn_DataData%p, DstServoDyn_DataData%p, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call SrvD_CopyInput(SrcServoDyn_DataData%u, DstServoDyn_DataData%u, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call SrvD_CopyOutput(SrcServoDyn_DataData%y, DstServoDyn_DataData%y, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call SrvD_CopyMisc(SrcServoDyn_DataData%m, DstServoDyn_DataData%m, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call SrvD_CopyMisc(SrcServoDyn_DataData%m_bak, DstServoDyn_DataData%m_bak, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcServoDyn_DataData%Output)) then
      LB(1:1) = lbound(SrcServoDyn_DataData%Output)
      UB(1:1) = ubound(SrcServoDyn_DataData%Output)
      if (.not. allocated(DstServoDyn_DataData%Output)) then
         allocate(DstServoDyn_DataData%Output(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstServoDyn_DataData%Output.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call SrvD_CopyOutput(SrcServoDyn_DataData%Output(i1), DstServoDyn_DataData%Output(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call SrvD_CopyOutput(SrcServoDyn_DataData%y_interp, DstServoDyn_DataData%y_interp, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcServoDyn_DataData%Input)) then
      LB(1:1) = lbound(SrcServoDyn_DataData%Input)
      UB(1:1) = ubound(SrcServoDyn_DataData%Input)
      if (.not. allocated(DstServoDyn_DataData%Input)) then
         allocate(DstServoDyn_DataData%Input(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstServoDyn_DataData%Input.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call SrvD_CopyInput(SrcServoDyn_DataData%Input(i1), DstServoDyn_DataData%Input(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcServoDyn_DataData%Input_Saved)) then
      LB(1:1) = lbound(SrcServoDyn_DataData%Input_Saved)
      UB(1:1) = ubound(SrcServoDyn_DataData%Input_Saved)
      if (.not. allocated(DstServoDyn_DataData%Input_Saved)) then
         allocate(DstServoDyn_DataData%Input_Saved(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstServoDyn_DataData%Input_Saved.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call SrvD_CopyInput(SrcServoDyn_DataData%Input_Saved(i1), DstServoDyn_DataData%Input_Saved(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcServoDyn_DataData%InputTimes)) then
      LB(1:1) = lbound(SrcServoDyn_DataData%InputTimes)
      UB(1:1) = ubound(SrcServoDyn_DataData%InputTimes)
      if (.not. allocated(DstServoDyn_DataData%InputTimes)) then
         allocate(DstServoDyn_DataData%InputTimes(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstServoDyn_DataData%InputTimes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstServoDyn_DataData%InputTimes = SrcServoDyn_DataData%InputTimes
   end if
   if (allocated(SrcServoDyn_DataData%InputTimes_Saved)) then
      LB(1:1) = lbound(SrcServoDyn_DataData%InputTimes_Saved)
      UB(1:1) = ubound(SrcServoDyn_DataData%InputTimes_Saved)
      if (.not. allocated(DstServoDyn_DataData%InputTimes_Saved)) then
         allocate(DstServoDyn_DataData%InputTimes_Saved(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstServoDyn_DataData%InputTimes_Saved.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstServoDyn_DataData%InputTimes_Saved = SrcServoDyn_DataData%InputTimes_Saved
   end if
end subroutine

subroutine FAST_DestroyServoDyn_Data(ServoDyn_DataData, ErrStat, ErrMsg)
   type(ServoDyn_Data), intent(inout) :: ServoDyn_DataData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_DestroyServoDyn_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   LB(1:1) = lbound(ServoDyn_DataData%x)
   UB(1:1) = ubound(ServoDyn_DataData%x)
   do i1 = LB(1), UB(1)
      call SrvD_DestroyContState(ServoDyn_DataData%x(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(ServoDyn_DataData%xd)
   UB(1:1) = ubound(ServoDyn_DataData%xd)
   do i1 = LB(1), UB(1)
      call SrvD_DestroyDiscState(ServoDyn_DataData%xd(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(ServoDyn_DataData%z)
   UB(1:1) = ubound(ServoDyn_DataData%z)
   do i1 = LB(1), UB(1)
      call SrvD_DestroyConstrState(ServoDyn_DataData%z(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(ServoDyn_DataData%OtherSt)
   UB(1:1) = ubound(ServoDyn_DataData%OtherSt)
   do i1 = LB(1), UB(1)
      call SrvD_DestroyOtherState(ServoDyn_DataData%OtherSt(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   call SrvD_DestroyParam(ServoDyn_DataData%p, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call SrvD_DestroyInput(ServoDyn_DataData%u, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call SrvD_DestroyOutput(ServoDyn_DataData%y, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call SrvD_DestroyMisc(ServoDyn_DataData%m, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call SrvD_DestroyMisc(ServoDyn_DataData%m_bak, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(ServoDyn_DataData%Output)) then
      LB(1:1) = lbound(ServoDyn_DataData%Output)
      UB(1:1) = ubound(ServoDyn_DataData%Output)
      do i1 = LB(1), UB(1)
         call SrvD_DestroyOutput(ServoDyn_DataData%Output(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ServoDyn_DataData%Output)
   end if
   call SrvD_DestroyOutput(ServoDyn_DataData%y_interp, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(ServoDyn_DataData%Input)) then
      LB(1:1) = lbound(ServoDyn_DataData%Input)
      UB(1:1) = ubound(ServoDyn_DataData%Input)
      do i1 = LB(1), UB(1)
         call SrvD_DestroyInput(ServoDyn_DataData%Input(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ServoDyn_DataData%Input)
   end if
   if (allocated(ServoDyn_DataData%Input_Saved)) then
      LB(1:1) = lbound(ServoDyn_DataData%Input_Saved)
      UB(1:1) = ubound(ServoDyn_DataData%Input_Saved)
      do i1 = LB(1), UB(1)
         call SrvD_DestroyInput(ServoDyn_DataData%Input_Saved(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ServoDyn_DataData%Input_Saved)
   end if
   if (allocated(ServoDyn_DataData%InputTimes)) then
      deallocate(ServoDyn_DataData%InputTimes)
   end if
   if (allocated(ServoDyn_DataData%InputTimes_Saved)) then
      deallocate(ServoDyn_DataData%InputTimes_Saved)
   end if
end subroutine

subroutine FAST_PackServoDyn_Data(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ServoDyn_Data), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FAST_PackServoDyn_Data'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   LB(1:1) = lbound(InData%x)
   UB(1:1) = ubound(InData%x)
   do i1 = LB(1), UB(1)
      call SrvD_PackContState(RF, InData%x(i1)) 
   end do
   LB(1:1) = lbound(InData%xd)
   UB(1:1) = ubound(InData%xd)
   do i1 = LB(1), UB(1)
      call SrvD_PackDiscState(RF, InData%xd(i1)) 
   end do
   LB(1:1) = lbound(InData%z)
   UB(1:1) = ubound(InData%z)
   do i1 = LB(1), UB(1)
      call SrvD_PackConstrState(RF, InData%z(i1)) 
   end do
   LB(1:1) = lbound(InData%OtherSt)
   UB(1:1) = ubound(InData%OtherSt)
   do i1 = LB(1), UB(1)
      call SrvD_PackOtherState(RF, InData%OtherSt(i1)) 
   end do
   call SrvD_PackParam(RF, InData%p) 
   call SrvD_PackInput(RF, InData%u) 
   call SrvD_PackOutput(RF, InData%y) 
   call SrvD_PackMisc(RF, InData%m) 
   call SrvD_PackMisc(RF, InData%m_bak) 
   call RegPack(RF, allocated(InData%Output))
   if (allocated(InData%Output)) then
      call RegPackBounds(RF, 1, lbound(InData%Output), ubound(InData%Output))
      LB(1:1) = lbound(InData%Output)
      UB(1:1) = ubound(InData%Output)
      do i1 = LB(1), UB(1)
         call SrvD_PackOutput(RF, InData%Output(i1)) 
      end do
   end if
   call SrvD_PackOutput(RF, InData%y_interp) 
   call RegPack(RF, allocated(InData%Input))
   if (allocated(InData%Input)) then
      call RegPackBounds(RF, 1, lbound(InData%Input), ubound(InData%Input))
      LB(1:1) = lbound(InData%Input)
      UB(1:1) = ubound(InData%Input)
      do i1 = LB(1), UB(1)
         call SrvD_PackInput(RF, InData%Input(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%Input_Saved))
   if (allocated(InData%Input_Saved)) then
      call RegPackBounds(RF, 1, lbound(InData%Input_Saved), ubound(InData%Input_Saved))
      LB(1:1) = lbound(InData%Input_Saved)
      UB(1:1) = ubound(InData%Input_Saved)
      do i1 = LB(1), UB(1)
         call SrvD_PackInput(RF, InData%Input_Saved(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%InputTimes)
   call RegPackAlloc(RF, InData%InputTimes_Saved)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_UnPackServoDyn_Data(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ServoDyn_Data), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FAST_UnPackServoDyn_Data'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   LB(1:1) = lbound(OutData%x)
   UB(1:1) = ubound(OutData%x)
   do i1 = LB(1), UB(1)
      call SrvD_UnpackContState(RF, OutData%x(i1)) ! x 
   end do
   LB(1:1) = lbound(OutData%xd)
   UB(1:1) = ubound(OutData%xd)
   do i1 = LB(1), UB(1)
      call SrvD_UnpackDiscState(RF, OutData%xd(i1)) ! xd 
   end do
   LB(1:1) = lbound(OutData%z)
   UB(1:1) = ubound(OutData%z)
   do i1 = LB(1), UB(1)
      call SrvD_UnpackConstrState(RF, OutData%z(i1)) ! z 
   end do
   LB(1:1) = lbound(OutData%OtherSt)
   UB(1:1) = ubound(OutData%OtherSt)
   do i1 = LB(1), UB(1)
      call SrvD_UnpackOtherState(RF, OutData%OtherSt(i1)) ! OtherSt 
   end do
   call SrvD_UnpackParam(RF, OutData%p) ! p 
   call SrvD_UnpackInput(RF, OutData%u) ! u 
   call SrvD_UnpackOutput(RF, OutData%y) ! y 
   call SrvD_UnpackMisc(RF, OutData%m) ! m 
   call SrvD_UnpackMisc(RF, OutData%m_bak) ! m_bak 
   if (allocated(OutData%Output)) deallocate(OutData%Output)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Output(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Output.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call SrvD_UnpackOutput(RF, OutData%Output(i1)) ! Output 
      end do
   end if
   call SrvD_UnpackOutput(RF, OutData%y_interp) ! y_interp 
   if (allocated(OutData%Input)) deallocate(OutData%Input)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Input(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Input.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call SrvD_UnpackInput(RF, OutData%Input(i1)) ! Input 
      end do
   end if
   if (allocated(OutData%Input_Saved)) deallocate(OutData%Input_Saved)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Input_Saved(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Input_Saved.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call SrvD_UnpackInput(RF, OutData%Input_Saved(i1)) ! Input_Saved 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%InputTimes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%InputTimes_Saved); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_CopyAeroDyn_Data(SrcAeroDyn_DataData, DstAeroDyn_DataData, CtrlCode, ErrStat, ErrMsg)
   type(AeroDyn_Data), intent(inout) :: SrcAeroDyn_DataData
   type(AeroDyn_Data), intent(inout) :: DstAeroDyn_DataData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_CopyAeroDyn_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   LB(1:1) = lbound(SrcAeroDyn_DataData%x)
   UB(1:1) = ubound(SrcAeroDyn_DataData%x)
   do i1 = LB(1), UB(1)
      call AD_CopyContState(SrcAeroDyn_DataData%x(i1), DstAeroDyn_DataData%x(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcAeroDyn_DataData%xd)
   UB(1:1) = ubound(SrcAeroDyn_DataData%xd)
   do i1 = LB(1), UB(1)
      call AD_CopyDiscState(SrcAeroDyn_DataData%xd(i1), DstAeroDyn_DataData%xd(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcAeroDyn_DataData%z)
   UB(1:1) = ubound(SrcAeroDyn_DataData%z)
   do i1 = LB(1), UB(1)
      call AD_CopyConstrState(SrcAeroDyn_DataData%z(i1), DstAeroDyn_DataData%z(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcAeroDyn_DataData%OtherSt)
   UB(1:1) = ubound(SrcAeroDyn_DataData%OtherSt)
   do i1 = LB(1), UB(1)
      call AD_CopyOtherState(SrcAeroDyn_DataData%OtherSt(i1), DstAeroDyn_DataData%OtherSt(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   call AD_CopyParam(SrcAeroDyn_DataData%p, DstAeroDyn_DataData%p, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call AD_CopyInput(SrcAeroDyn_DataData%u, DstAeroDyn_DataData%u, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call AD_CopyOutput(SrcAeroDyn_DataData%y, DstAeroDyn_DataData%y, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call AD_CopyMisc(SrcAeroDyn_DataData%m, DstAeroDyn_DataData%m, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcAeroDyn_DataData%Output)) then
      LB(1:1) = lbound(SrcAeroDyn_DataData%Output)
      UB(1:1) = ubound(SrcAeroDyn_DataData%Output)
      if (.not. allocated(DstAeroDyn_DataData%Output)) then
         allocate(DstAeroDyn_DataData%Output(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstAeroDyn_DataData%Output.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call AD_CopyOutput(SrcAeroDyn_DataData%Output(i1), DstAeroDyn_DataData%Output(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call AD_CopyOutput(SrcAeroDyn_DataData%y_interp, DstAeroDyn_DataData%y_interp, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcAeroDyn_DataData%Input)) then
      LB(1:1) = lbound(SrcAeroDyn_DataData%Input)
      UB(1:1) = ubound(SrcAeroDyn_DataData%Input)
      if (.not. allocated(DstAeroDyn_DataData%Input)) then
         allocate(DstAeroDyn_DataData%Input(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstAeroDyn_DataData%Input.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call AD_CopyInput(SrcAeroDyn_DataData%Input(i1), DstAeroDyn_DataData%Input(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcAeroDyn_DataData%Input_Saved)) then
      LB(1:1) = lbound(SrcAeroDyn_DataData%Input_Saved)
      UB(1:1) = ubound(SrcAeroDyn_DataData%Input_Saved)
      if (.not. allocated(DstAeroDyn_DataData%Input_Saved)) then
         allocate(DstAeroDyn_DataData%Input_Saved(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstAeroDyn_DataData%Input_Saved.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call AD_CopyInput(SrcAeroDyn_DataData%Input_Saved(i1), DstAeroDyn_DataData%Input_Saved(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcAeroDyn_DataData%InputTimes)) then
      LB(1:1) = lbound(SrcAeroDyn_DataData%InputTimes)
      UB(1:1) = ubound(SrcAeroDyn_DataData%InputTimes)
      if (.not. allocated(DstAeroDyn_DataData%InputTimes)) then
         allocate(DstAeroDyn_DataData%InputTimes(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstAeroDyn_DataData%InputTimes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstAeroDyn_DataData%InputTimes = SrcAeroDyn_DataData%InputTimes
   end if
   if (allocated(SrcAeroDyn_DataData%InputTimes_Saved)) then
      LB(1:1) = lbound(SrcAeroDyn_DataData%InputTimes_Saved)
      UB(1:1) = ubound(SrcAeroDyn_DataData%InputTimes_Saved)
      if (.not. allocated(DstAeroDyn_DataData%InputTimes_Saved)) then
         allocate(DstAeroDyn_DataData%InputTimes_Saved(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstAeroDyn_DataData%InputTimes_Saved.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstAeroDyn_DataData%InputTimes_Saved = SrcAeroDyn_DataData%InputTimes_Saved
   end if
end subroutine

subroutine FAST_DestroyAeroDyn_Data(AeroDyn_DataData, ErrStat, ErrMsg)
   type(AeroDyn_Data), intent(inout) :: AeroDyn_DataData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_DestroyAeroDyn_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   LB(1:1) = lbound(AeroDyn_DataData%x)
   UB(1:1) = ubound(AeroDyn_DataData%x)
   do i1 = LB(1), UB(1)
      call AD_DestroyContState(AeroDyn_DataData%x(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(AeroDyn_DataData%xd)
   UB(1:1) = ubound(AeroDyn_DataData%xd)
   do i1 = LB(1), UB(1)
      call AD_DestroyDiscState(AeroDyn_DataData%xd(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(AeroDyn_DataData%z)
   UB(1:1) = ubound(AeroDyn_DataData%z)
   do i1 = LB(1), UB(1)
      call AD_DestroyConstrState(AeroDyn_DataData%z(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(AeroDyn_DataData%OtherSt)
   UB(1:1) = ubound(AeroDyn_DataData%OtherSt)
   do i1 = LB(1), UB(1)
      call AD_DestroyOtherState(AeroDyn_DataData%OtherSt(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   call AD_DestroyParam(AeroDyn_DataData%p, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call AD_DestroyInput(AeroDyn_DataData%u, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call AD_DestroyOutput(AeroDyn_DataData%y, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call AD_DestroyMisc(AeroDyn_DataData%m, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(AeroDyn_DataData%Output)) then
      LB(1:1) = lbound(AeroDyn_DataData%Output)
      UB(1:1) = ubound(AeroDyn_DataData%Output)
      do i1 = LB(1), UB(1)
         call AD_DestroyOutput(AeroDyn_DataData%Output(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(AeroDyn_DataData%Output)
   end if
   call AD_DestroyOutput(AeroDyn_DataData%y_interp, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(AeroDyn_DataData%Input)) then
      LB(1:1) = lbound(AeroDyn_DataData%Input)
      UB(1:1) = ubound(AeroDyn_DataData%Input)
      do i1 = LB(1), UB(1)
         call AD_DestroyInput(AeroDyn_DataData%Input(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(AeroDyn_DataData%Input)
   end if
   if (allocated(AeroDyn_DataData%Input_Saved)) then
      LB(1:1) = lbound(AeroDyn_DataData%Input_Saved)
      UB(1:1) = ubound(AeroDyn_DataData%Input_Saved)
      do i1 = LB(1), UB(1)
         call AD_DestroyInput(AeroDyn_DataData%Input_Saved(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(AeroDyn_DataData%Input_Saved)
   end if
   if (allocated(AeroDyn_DataData%InputTimes)) then
      deallocate(AeroDyn_DataData%InputTimes)
   end if
   if (allocated(AeroDyn_DataData%InputTimes_Saved)) then
      deallocate(AeroDyn_DataData%InputTimes_Saved)
   end if
end subroutine

subroutine FAST_PackAeroDyn_Data(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AeroDyn_Data), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FAST_PackAeroDyn_Data'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   LB(1:1) = lbound(InData%x)
   UB(1:1) = ubound(InData%x)
   do i1 = LB(1), UB(1)
      call AD_PackContState(RF, InData%x(i1)) 
   end do
   LB(1:1) = lbound(InData%xd)
   UB(1:1) = ubound(InData%xd)
   do i1 = LB(1), UB(1)
      call AD_PackDiscState(RF, InData%xd(i1)) 
   end do
   LB(1:1) = lbound(InData%z)
   UB(1:1) = ubound(InData%z)
   do i1 = LB(1), UB(1)
      call AD_PackConstrState(RF, InData%z(i1)) 
   end do
   LB(1:1) = lbound(InData%OtherSt)
   UB(1:1) = ubound(InData%OtherSt)
   do i1 = LB(1), UB(1)
      call AD_PackOtherState(RF, InData%OtherSt(i1)) 
   end do
   call AD_PackParam(RF, InData%p) 
   call AD_PackInput(RF, InData%u) 
   call AD_PackOutput(RF, InData%y) 
   call AD_PackMisc(RF, InData%m) 
   call RegPack(RF, allocated(InData%Output))
   if (allocated(InData%Output)) then
      call RegPackBounds(RF, 1, lbound(InData%Output), ubound(InData%Output))
      LB(1:1) = lbound(InData%Output)
      UB(1:1) = ubound(InData%Output)
      do i1 = LB(1), UB(1)
         call AD_PackOutput(RF, InData%Output(i1)) 
      end do
   end if
   call AD_PackOutput(RF, InData%y_interp) 
   call RegPack(RF, allocated(InData%Input))
   if (allocated(InData%Input)) then
      call RegPackBounds(RF, 1, lbound(InData%Input), ubound(InData%Input))
      LB(1:1) = lbound(InData%Input)
      UB(1:1) = ubound(InData%Input)
      do i1 = LB(1), UB(1)
         call AD_PackInput(RF, InData%Input(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%Input_Saved))
   if (allocated(InData%Input_Saved)) then
      call RegPackBounds(RF, 1, lbound(InData%Input_Saved), ubound(InData%Input_Saved))
      LB(1:1) = lbound(InData%Input_Saved)
      UB(1:1) = ubound(InData%Input_Saved)
      do i1 = LB(1), UB(1)
         call AD_PackInput(RF, InData%Input_Saved(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%InputTimes)
   call RegPackAlloc(RF, InData%InputTimes_Saved)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_UnPackAeroDyn_Data(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AeroDyn_Data), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FAST_UnPackAeroDyn_Data'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   LB(1:1) = lbound(OutData%x)
   UB(1:1) = ubound(OutData%x)
   do i1 = LB(1), UB(1)
      call AD_UnpackContState(RF, OutData%x(i1)) ! x 
   end do
   LB(1:1) = lbound(OutData%xd)
   UB(1:1) = ubound(OutData%xd)
   do i1 = LB(1), UB(1)
      call AD_UnpackDiscState(RF, OutData%xd(i1)) ! xd 
   end do
   LB(1:1) = lbound(OutData%z)
   UB(1:1) = ubound(OutData%z)
   do i1 = LB(1), UB(1)
      call AD_UnpackConstrState(RF, OutData%z(i1)) ! z 
   end do
   LB(1:1) = lbound(OutData%OtherSt)
   UB(1:1) = ubound(OutData%OtherSt)
   do i1 = LB(1), UB(1)
      call AD_UnpackOtherState(RF, OutData%OtherSt(i1)) ! OtherSt 
   end do
   call AD_UnpackParam(RF, OutData%p) ! p 
   call AD_UnpackInput(RF, OutData%u) ! u 
   call AD_UnpackOutput(RF, OutData%y) ! y 
   call AD_UnpackMisc(RF, OutData%m) ! m 
   if (allocated(OutData%Output)) deallocate(OutData%Output)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Output(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Output.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call AD_UnpackOutput(RF, OutData%Output(i1)) ! Output 
      end do
   end if
   call AD_UnpackOutput(RF, OutData%y_interp) ! y_interp 
   if (allocated(OutData%Input)) deallocate(OutData%Input)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Input(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Input.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call AD_UnpackInput(RF, OutData%Input(i1)) ! Input 
      end do
   end if
   if (allocated(OutData%Input_Saved)) deallocate(OutData%Input_Saved)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Input_Saved(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Input_Saved.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call AD_UnpackInput(RF, OutData%Input_Saved(i1)) ! Input_Saved 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%InputTimes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%InputTimes_Saved); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_CopyExtLoads_Data(SrcExtLoads_DataData, DstExtLoads_DataData, CtrlCode, ErrStat, ErrMsg)
   type(ExtLoads_Data), intent(inout) :: SrcExtLoads_DataData
   type(ExtLoads_Data), intent(inout) :: DstExtLoads_DataData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_CopyExtLoads_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   LB(1:1) = lbound(SrcExtLoads_DataData%x)
   UB(1:1) = ubound(SrcExtLoads_DataData%x)
   do i1 = LB(1), UB(1)
      call ExtLd_CopyContState(SrcExtLoads_DataData%x(i1), DstExtLoads_DataData%x(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcExtLoads_DataData%xd)
   UB(1:1) = ubound(SrcExtLoads_DataData%xd)
   do i1 = LB(1), UB(1)
      call ExtLd_CopyDiscState(SrcExtLoads_DataData%xd(i1), DstExtLoads_DataData%xd(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcExtLoads_DataData%z)
   UB(1:1) = ubound(SrcExtLoads_DataData%z)
   do i1 = LB(1), UB(1)
      call ExtLd_CopyConstrState(SrcExtLoads_DataData%z(i1), DstExtLoads_DataData%z(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcExtLoads_DataData%OtherSt)
   UB(1:1) = ubound(SrcExtLoads_DataData%OtherSt)
   do i1 = LB(1), UB(1)
      call ExtLd_CopyOtherState(SrcExtLoads_DataData%OtherSt(i1), DstExtLoads_DataData%OtherSt(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   call ExtLd_CopyParam(SrcExtLoads_DataData%p, DstExtLoads_DataData%p, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call ExtLd_CopyInput(SrcExtLoads_DataData%u, DstExtLoads_DataData%u, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call ExtLd_CopyOutput(SrcExtLoads_DataData%y, DstExtLoads_DataData%y, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call ExtLd_CopyMisc(SrcExtLoads_DataData%m, DstExtLoads_DataData%m, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcExtLoads_DataData%InputTimes)) then
      LB(1:1) = lbound(SrcExtLoads_DataData%InputTimes)
      UB(1:1) = ubound(SrcExtLoads_DataData%InputTimes)
      if (.not. allocated(DstExtLoads_DataData%InputTimes)) then
         allocate(DstExtLoads_DataData%InputTimes(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstExtLoads_DataData%InputTimes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstExtLoads_DataData%InputTimes = SrcExtLoads_DataData%InputTimes
   end if
end subroutine

subroutine FAST_DestroyExtLoads_Data(ExtLoads_DataData, ErrStat, ErrMsg)
   type(ExtLoads_Data), intent(inout) :: ExtLoads_DataData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_DestroyExtLoads_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   LB(1:1) = lbound(ExtLoads_DataData%x)
   UB(1:1) = ubound(ExtLoads_DataData%x)
   do i1 = LB(1), UB(1)
      call ExtLd_DestroyContState(ExtLoads_DataData%x(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(ExtLoads_DataData%xd)
   UB(1:1) = ubound(ExtLoads_DataData%xd)
   do i1 = LB(1), UB(1)
      call ExtLd_DestroyDiscState(ExtLoads_DataData%xd(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(ExtLoads_DataData%z)
   UB(1:1) = ubound(ExtLoads_DataData%z)
   do i1 = LB(1), UB(1)
      call ExtLd_DestroyConstrState(ExtLoads_DataData%z(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(ExtLoads_DataData%OtherSt)
   UB(1:1) = ubound(ExtLoads_DataData%OtherSt)
   do i1 = LB(1), UB(1)
      call ExtLd_DestroyOtherState(ExtLoads_DataData%OtherSt(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   call ExtLd_DestroyParam(ExtLoads_DataData%p, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call ExtLd_DestroyInput(ExtLoads_DataData%u, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call ExtLd_DestroyOutput(ExtLoads_DataData%y, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call ExtLd_DestroyMisc(ExtLoads_DataData%m, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(ExtLoads_DataData%InputTimes)) then
      deallocate(ExtLoads_DataData%InputTimes)
   end if
end subroutine

subroutine FAST_PackExtLoads_Data(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ExtLoads_Data), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FAST_PackExtLoads_Data'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   LB(1:1) = lbound(InData%x)
   UB(1:1) = ubound(InData%x)
   do i1 = LB(1), UB(1)
      call ExtLd_PackContState(RF, InData%x(i1)) 
   end do
   LB(1:1) = lbound(InData%xd)
   UB(1:1) = ubound(InData%xd)
   do i1 = LB(1), UB(1)
      call ExtLd_PackDiscState(RF, InData%xd(i1)) 
   end do
   LB(1:1) = lbound(InData%z)
   UB(1:1) = ubound(InData%z)
   do i1 = LB(1), UB(1)
      call ExtLd_PackConstrState(RF, InData%z(i1)) 
   end do
   LB(1:1) = lbound(InData%OtherSt)
   UB(1:1) = ubound(InData%OtherSt)
   do i1 = LB(1), UB(1)
      call ExtLd_PackOtherState(RF, InData%OtherSt(i1)) 
   end do
   call ExtLd_PackParam(RF, InData%p) 
   call ExtLd_PackInput(RF, InData%u) 
   call ExtLd_PackOutput(RF, InData%y) 
   call ExtLd_PackMisc(RF, InData%m) 
   call RegPackAlloc(RF, InData%InputTimes)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_UnPackExtLoads_Data(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ExtLoads_Data), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FAST_UnPackExtLoads_Data'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   LB(1:1) = lbound(OutData%x)
   UB(1:1) = ubound(OutData%x)
   do i1 = LB(1), UB(1)
      call ExtLd_UnpackContState(RF, OutData%x(i1)) ! x 
   end do
   LB(1:1) = lbound(OutData%xd)
   UB(1:1) = ubound(OutData%xd)
   do i1 = LB(1), UB(1)
      call ExtLd_UnpackDiscState(RF, OutData%xd(i1)) ! xd 
   end do
   LB(1:1) = lbound(OutData%z)
   UB(1:1) = ubound(OutData%z)
   do i1 = LB(1), UB(1)
      call ExtLd_UnpackConstrState(RF, OutData%z(i1)) ! z 
   end do
   LB(1:1) = lbound(OutData%OtherSt)
   UB(1:1) = ubound(OutData%OtherSt)
   do i1 = LB(1), UB(1)
      call ExtLd_UnpackOtherState(RF, OutData%OtherSt(i1)) ! OtherSt 
   end do
   call ExtLd_UnpackParam(RF, OutData%p) ! p 
   call ExtLd_UnpackInput(RF, OutData%u) ! u 
   call ExtLd_UnpackOutput(RF, OutData%y) ! y 
   call ExtLd_UnpackMisc(RF, OutData%m) ! m 
   call RegUnpackAlloc(RF, OutData%InputTimes); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_CopyAeroDisk_Data(SrcAeroDisk_DataData, DstAeroDisk_DataData, CtrlCode, ErrStat, ErrMsg)
   type(AeroDisk_Data), intent(inout) :: SrcAeroDisk_DataData
   type(AeroDisk_Data), intent(inout) :: DstAeroDisk_DataData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_CopyAeroDisk_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   LB(1:1) = lbound(SrcAeroDisk_DataData%x)
   UB(1:1) = ubound(SrcAeroDisk_DataData%x)
   do i1 = LB(1), UB(1)
      call ADsk_CopyContState(SrcAeroDisk_DataData%x(i1), DstAeroDisk_DataData%x(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcAeroDisk_DataData%xd)
   UB(1:1) = ubound(SrcAeroDisk_DataData%xd)
   do i1 = LB(1), UB(1)
      call ADsk_CopyDiscState(SrcAeroDisk_DataData%xd(i1), DstAeroDisk_DataData%xd(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcAeroDisk_DataData%z)
   UB(1:1) = ubound(SrcAeroDisk_DataData%z)
   do i1 = LB(1), UB(1)
      call ADsk_CopyConstrState(SrcAeroDisk_DataData%z(i1), DstAeroDisk_DataData%z(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcAeroDisk_DataData%OtherSt)
   UB(1:1) = ubound(SrcAeroDisk_DataData%OtherSt)
   do i1 = LB(1), UB(1)
      call ADsk_CopyOtherState(SrcAeroDisk_DataData%OtherSt(i1), DstAeroDisk_DataData%OtherSt(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   call ADsk_CopyParam(SrcAeroDisk_DataData%p, DstAeroDisk_DataData%p, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call ADsk_CopyInput(SrcAeroDisk_DataData%u, DstAeroDisk_DataData%u, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call ADsk_CopyOutput(SrcAeroDisk_DataData%y, DstAeroDisk_DataData%y, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call ADsk_CopyMisc(SrcAeroDisk_DataData%m, DstAeroDisk_DataData%m, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcAeroDisk_DataData%Output)) then
      LB(1:1) = lbound(SrcAeroDisk_DataData%Output)
      UB(1:1) = ubound(SrcAeroDisk_DataData%Output)
      if (.not. allocated(DstAeroDisk_DataData%Output)) then
         allocate(DstAeroDisk_DataData%Output(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstAeroDisk_DataData%Output.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call ADsk_CopyOutput(SrcAeroDisk_DataData%Output(i1), DstAeroDisk_DataData%Output(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call ADsk_CopyOutput(SrcAeroDisk_DataData%y_interp, DstAeroDisk_DataData%y_interp, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcAeroDisk_DataData%Input)) then
      LB(1:1) = lbound(SrcAeroDisk_DataData%Input)
      UB(1:1) = ubound(SrcAeroDisk_DataData%Input)
      if (.not. allocated(DstAeroDisk_DataData%Input)) then
         allocate(DstAeroDisk_DataData%Input(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstAeroDisk_DataData%Input.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call ADsk_CopyInput(SrcAeroDisk_DataData%Input(i1), DstAeroDisk_DataData%Input(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcAeroDisk_DataData%InputTimes)) then
      LB(1:1) = lbound(SrcAeroDisk_DataData%InputTimes)
      UB(1:1) = ubound(SrcAeroDisk_DataData%InputTimes)
      if (.not. allocated(DstAeroDisk_DataData%InputTimes)) then
         allocate(DstAeroDisk_DataData%InputTimes(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstAeroDisk_DataData%InputTimes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstAeroDisk_DataData%InputTimes = SrcAeroDisk_DataData%InputTimes
   end if
end subroutine

subroutine FAST_DestroyAeroDisk_Data(AeroDisk_DataData, ErrStat, ErrMsg)
   type(AeroDisk_Data), intent(inout) :: AeroDisk_DataData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_DestroyAeroDisk_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   LB(1:1) = lbound(AeroDisk_DataData%x)
   UB(1:1) = ubound(AeroDisk_DataData%x)
   do i1 = LB(1), UB(1)
      call ADsk_DestroyContState(AeroDisk_DataData%x(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(AeroDisk_DataData%xd)
   UB(1:1) = ubound(AeroDisk_DataData%xd)
   do i1 = LB(1), UB(1)
      call ADsk_DestroyDiscState(AeroDisk_DataData%xd(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(AeroDisk_DataData%z)
   UB(1:1) = ubound(AeroDisk_DataData%z)
   do i1 = LB(1), UB(1)
      call ADsk_DestroyConstrState(AeroDisk_DataData%z(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(AeroDisk_DataData%OtherSt)
   UB(1:1) = ubound(AeroDisk_DataData%OtherSt)
   do i1 = LB(1), UB(1)
      call ADsk_DestroyOtherState(AeroDisk_DataData%OtherSt(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   call ADsk_DestroyParam(AeroDisk_DataData%p, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call ADsk_DestroyInput(AeroDisk_DataData%u, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call ADsk_DestroyOutput(AeroDisk_DataData%y, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call ADsk_DestroyMisc(AeroDisk_DataData%m, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(AeroDisk_DataData%Output)) then
      LB(1:1) = lbound(AeroDisk_DataData%Output)
      UB(1:1) = ubound(AeroDisk_DataData%Output)
      do i1 = LB(1), UB(1)
         call ADsk_DestroyOutput(AeroDisk_DataData%Output(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(AeroDisk_DataData%Output)
   end if
   call ADsk_DestroyOutput(AeroDisk_DataData%y_interp, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(AeroDisk_DataData%Input)) then
      LB(1:1) = lbound(AeroDisk_DataData%Input)
      UB(1:1) = ubound(AeroDisk_DataData%Input)
      do i1 = LB(1), UB(1)
         call ADsk_DestroyInput(AeroDisk_DataData%Input(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(AeroDisk_DataData%Input)
   end if
   if (allocated(AeroDisk_DataData%InputTimes)) then
      deallocate(AeroDisk_DataData%InputTimes)
   end if
end subroutine

subroutine FAST_PackAeroDisk_Data(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AeroDisk_Data), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FAST_PackAeroDisk_Data'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   LB(1:1) = lbound(InData%x)
   UB(1:1) = ubound(InData%x)
   do i1 = LB(1), UB(1)
      call ADsk_PackContState(RF, InData%x(i1)) 
   end do
   LB(1:1) = lbound(InData%xd)
   UB(1:1) = ubound(InData%xd)
   do i1 = LB(1), UB(1)
      call ADsk_PackDiscState(RF, InData%xd(i1)) 
   end do
   LB(1:1) = lbound(InData%z)
   UB(1:1) = ubound(InData%z)
   do i1 = LB(1), UB(1)
      call ADsk_PackConstrState(RF, InData%z(i1)) 
   end do
   LB(1:1) = lbound(InData%OtherSt)
   UB(1:1) = ubound(InData%OtherSt)
   do i1 = LB(1), UB(1)
      call ADsk_PackOtherState(RF, InData%OtherSt(i1)) 
   end do
   call ADsk_PackParam(RF, InData%p) 
   call ADsk_PackInput(RF, InData%u) 
   call ADsk_PackOutput(RF, InData%y) 
   call ADsk_PackMisc(RF, InData%m) 
   call RegPack(RF, allocated(InData%Output))
   if (allocated(InData%Output)) then
      call RegPackBounds(RF, 1, lbound(InData%Output), ubound(InData%Output))
      LB(1:1) = lbound(InData%Output)
      UB(1:1) = ubound(InData%Output)
      do i1 = LB(1), UB(1)
         call ADsk_PackOutput(RF, InData%Output(i1)) 
      end do
   end if
   call ADsk_PackOutput(RF, InData%y_interp) 
   call RegPack(RF, allocated(InData%Input))
   if (allocated(InData%Input)) then
      call RegPackBounds(RF, 1, lbound(InData%Input), ubound(InData%Input))
      LB(1:1) = lbound(InData%Input)
      UB(1:1) = ubound(InData%Input)
      do i1 = LB(1), UB(1)
         call ADsk_PackInput(RF, InData%Input(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%InputTimes)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_UnPackAeroDisk_Data(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AeroDisk_Data), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FAST_UnPackAeroDisk_Data'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   LB(1:1) = lbound(OutData%x)
   UB(1:1) = ubound(OutData%x)
   do i1 = LB(1), UB(1)
      call ADsk_UnpackContState(RF, OutData%x(i1)) ! x 
   end do
   LB(1:1) = lbound(OutData%xd)
   UB(1:1) = ubound(OutData%xd)
   do i1 = LB(1), UB(1)
      call ADsk_UnpackDiscState(RF, OutData%xd(i1)) ! xd 
   end do
   LB(1:1) = lbound(OutData%z)
   UB(1:1) = ubound(OutData%z)
   do i1 = LB(1), UB(1)
      call ADsk_UnpackConstrState(RF, OutData%z(i1)) ! z 
   end do
   LB(1:1) = lbound(OutData%OtherSt)
   UB(1:1) = ubound(OutData%OtherSt)
   do i1 = LB(1), UB(1)
      call ADsk_UnpackOtherState(RF, OutData%OtherSt(i1)) ! OtherSt 
   end do
   call ADsk_UnpackParam(RF, OutData%p) ! p 
   call ADsk_UnpackInput(RF, OutData%u) ! u 
   call ADsk_UnpackOutput(RF, OutData%y) ! y 
   call ADsk_UnpackMisc(RF, OutData%m) ! m 
   if (allocated(OutData%Output)) deallocate(OutData%Output)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Output(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Output.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call ADsk_UnpackOutput(RF, OutData%Output(i1)) ! Output 
      end do
   end if
   call ADsk_UnpackOutput(RF, OutData%y_interp) ! y_interp 
   if (allocated(OutData%Input)) deallocate(OutData%Input)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Input(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Input.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call ADsk_UnpackInput(RF, OutData%Input(i1)) ! Input 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%InputTimes); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_CopyInflowWind_Data(SrcInflowWind_DataData, DstInflowWind_DataData, CtrlCode, ErrStat, ErrMsg)
   type(InflowWind_Data), intent(in) :: SrcInflowWind_DataData
   type(InflowWind_Data), intent(inout) :: DstInflowWind_DataData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_CopyInflowWind_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   LB(1:1) = lbound(SrcInflowWind_DataData%x)
   UB(1:1) = ubound(SrcInflowWind_DataData%x)
   do i1 = LB(1), UB(1)
      call InflowWind_CopyContState(SrcInflowWind_DataData%x(i1), DstInflowWind_DataData%x(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcInflowWind_DataData%xd)
   UB(1:1) = ubound(SrcInflowWind_DataData%xd)
   do i1 = LB(1), UB(1)
      call InflowWind_CopyDiscState(SrcInflowWind_DataData%xd(i1), DstInflowWind_DataData%xd(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcInflowWind_DataData%z)
   UB(1:1) = ubound(SrcInflowWind_DataData%z)
   do i1 = LB(1), UB(1)
      call InflowWind_CopyConstrState(SrcInflowWind_DataData%z(i1), DstInflowWind_DataData%z(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcInflowWind_DataData%OtherSt)
   UB(1:1) = ubound(SrcInflowWind_DataData%OtherSt)
   do i1 = LB(1), UB(1)
      call InflowWind_CopyOtherState(SrcInflowWind_DataData%OtherSt(i1), DstInflowWind_DataData%OtherSt(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   call InflowWind_CopyParam(SrcInflowWind_DataData%p, DstInflowWind_DataData%p, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call InflowWind_CopyInput(SrcInflowWind_DataData%u, DstInflowWind_DataData%u, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call InflowWind_CopyOutput(SrcInflowWind_DataData%y, DstInflowWind_DataData%y, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call InflowWind_CopyMisc(SrcInflowWind_DataData%m, DstInflowWind_DataData%m, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcInflowWind_DataData%Output)) then
      LB(1:1) = lbound(SrcInflowWind_DataData%Output)
      UB(1:1) = ubound(SrcInflowWind_DataData%Output)
      if (.not. allocated(DstInflowWind_DataData%Output)) then
         allocate(DstInflowWind_DataData%Output(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInflowWind_DataData%Output.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call InflowWind_CopyOutput(SrcInflowWind_DataData%Output(i1), DstInflowWind_DataData%Output(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call InflowWind_CopyOutput(SrcInflowWind_DataData%y_interp, DstInflowWind_DataData%y_interp, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcInflowWind_DataData%Input)) then
      LB(1:1) = lbound(SrcInflowWind_DataData%Input)
      UB(1:1) = ubound(SrcInflowWind_DataData%Input)
      if (.not. allocated(DstInflowWind_DataData%Input)) then
         allocate(DstInflowWind_DataData%Input(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInflowWind_DataData%Input.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call InflowWind_CopyInput(SrcInflowWind_DataData%Input(i1), DstInflowWind_DataData%Input(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcInflowWind_DataData%Input_Saved)) then
      LB(1:1) = lbound(SrcInflowWind_DataData%Input_Saved)
      UB(1:1) = ubound(SrcInflowWind_DataData%Input_Saved)
      if (.not. allocated(DstInflowWind_DataData%Input_Saved)) then
         allocate(DstInflowWind_DataData%Input_Saved(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInflowWind_DataData%Input_Saved.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call InflowWind_CopyInput(SrcInflowWind_DataData%Input_Saved(i1), DstInflowWind_DataData%Input_Saved(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcInflowWind_DataData%InputTimes)) then
      LB(1:1) = lbound(SrcInflowWind_DataData%InputTimes)
      UB(1:1) = ubound(SrcInflowWind_DataData%InputTimes)
      if (.not. allocated(DstInflowWind_DataData%InputTimes)) then
         allocate(DstInflowWind_DataData%InputTimes(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInflowWind_DataData%InputTimes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInflowWind_DataData%InputTimes = SrcInflowWind_DataData%InputTimes
   end if
   if (allocated(SrcInflowWind_DataData%InputTimes_Saved)) then
      LB(1:1) = lbound(SrcInflowWind_DataData%InputTimes_Saved)
      UB(1:1) = ubound(SrcInflowWind_DataData%InputTimes_Saved)
      if (.not. allocated(DstInflowWind_DataData%InputTimes_Saved)) then
         allocate(DstInflowWind_DataData%InputTimes_Saved(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInflowWind_DataData%InputTimes_Saved.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInflowWind_DataData%InputTimes_Saved = SrcInflowWind_DataData%InputTimes_Saved
   end if
end subroutine

subroutine FAST_DestroyInflowWind_Data(InflowWind_DataData, ErrStat, ErrMsg)
   type(InflowWind_Data), intent(inout) :: InflowWind_DataData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_DestroyInflowWind_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   LB(1:1) = lbound(InflowWind_DataData%x)
   UB(1:1) = ubound(InflowWind_DataData%x)
   do i1 = LB(1), UB(1)
      call InflowWind_DestroyContState(InflowWind_DataData%x(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(InflowWind_DataData%xd)
   UB(1:1) = ubound(InflowWind_DataData%xd)
   do i1 = LB(1), UB(1)
      call InflowWind_DestroyDiscState(InflowWind_DataData%xd(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(InflowWind_DataData%z)
   UB(1:1) = ubound(InflowWind_DataData%z)
   do i1 = LB(1), UB(1)
      call InflowWind_DestroyConstrState(InflowWind_DataData%z(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(InflowWind_DataData%OtherSt)
   UB(1:1) = ubound(InflowWind_DataData%OtherSt)
   do i1 = LB(1), UB(1)
      call InflowWind_DestroyOtherState(InflowWind_DataData%OtherSt(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   call InflowWind_DestroyParam(InflowWind_DataData%p, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call InflowWind_DestroyInput(InflowWind_DataData%u, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call InflowWind_DestroyOutput(InflowWind_DataData%y, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call InflowWind_DestroyMisc(InflowWind_DataData%m, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(InflowWind_DataData%Output)) then
      LB(1:1) = lbound(InflowWind_DataData%Output)
      UB(1:1) = ubound(InflowWind_DataData%Output)
      do i1 = LB(1), UB(1)
         call InflowWind_DestroyOutput(InflowWind_DataData%Output(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InflowWind_DataData%Output)
   end if
   call InflowWind_DestroyOutput(InflowWind_DataData%y_interp, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(InflowWind_DataData%Input)) then
      LB(1:1) = lbound(InflowWind_DataData%Input)
      UB(1:1) = ubound(InflowWind_DataData%Input)
      do i1 = LB(1), UB(1)
         call InflowWind_DestroyInput(InflowWind_DataData%Input(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InflowWind_DataData%Input)
   end if
   if (allocated(InflowWind_DataData%Input_Saved)) then
      LB(1:1) = lbound(InflowWind_DataData%Input_Saved)
      UB(1:1) = ubound(InflowWind_DataData%Input_Saved)
      do i1 = LB(1), UB(1)
         call InflowWind_DestroyInput(InflowWind_DataData%Input_Saved(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InflowWind_DataData%Input_Saved)
   end if
   if (allocated(InflowWind_DataData%InputTimes)) then
      deallocate(InflowWind_DataData%InputTimes)
   end if
   if (allocated(InflowWind_DataData%InputTimes_Saved)) then
      deallocate(InflowWind_DataData%InputTimes_Saved)
   end if
end subroutine

subroutine FAST_PackInflowWind_Data(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(InflowWind_Data), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FAST_PackInflowWind_Data'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   LB(1:1) = lbound(InData%x)
   UB(1:1) = ubound(InData%x)
   do i1 = LB(1), UB(1)
      call InflowWind_PackContState(RF, InData%x(i1)) 
   end do
   LB(1:1) = lbound(InData%xd)
   UB(1:1) = ubound(InData%xd)
   do i1 = LB(1), UB(1)
      call InflowWind_PackDiscState(RF, InData%xd(i1)) 
   end do
   LB(1:1) = lbound(InData%z)
   UB(1:1) = ubound(InData%z)
   do i1 = LB(1), UB(1)
      call InflowWind_PackConstrState(RF, InData%z(i1)) 
   end do
   LB(1:1) = lbound(InData%OtherSt)
   UB(1:1) = ubound(InData%OtherSt)
   do i1 = LB(1), UB(1)
      call InflowWind_PackOtherState(RF, InData%OtherSt(i1)) 
   end do
   call InflowWind_PackParam(RF, InData%p) 
   call InflowWind_PackInput(RF, InData%u) 
   call InflowWind_PackOutput(RF, InData%y) 
   call InflowWind_PackMisc(RF, InData%m) 
   call RegPack(RF, allocated(InData%Output))
   if (allocated(InData%Output)) then
      call RegPackBounds(RF, 1, lbound(InData%Output), ubound(InData%Output))
      LB(1:1) = lbound(InData%Output)
      UB(1:1) = ubound(InData%Output)
      do i1 = LB(1), UB(1)
         call InflowWind_PackOutput(RF, InData%Output(i1)) 
      end do
   end if
   call InflowWind_PackOutput(RF, InData%y_interp) 
   call RegPack(RF, allocated(InData%Input))
   if (allocated(InData%Input)) then
      call RegPackBounds(RF, 1, lbound(InData%Input), ubound(InData%Input))
      LB(1:1) = lbound(InData%Input)
      UB(1:1) = ubound(InData%Input)
      do i1 = LB(1), UB(1)
         call InflowWind_PackInput(RF, InData%Input(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%Input_Saved))
   if (allocated(InData%Input_Saved)) then
      call RegPackBounds(RF, 1, lbound(InData%Input_Saved), ubound(InData%Input_Saved))
      LB(1:1) = lbound(InData%Input_Saved)
      UB(1:1) = ubound(InData%Input_Saved)
      do i1 = LB(1), UB(1)
         call InflowWind_PackInput(RF, InData%Input_Saved(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%InputTimes)
   call RegPackAlloc(RF, InData%InputTimes_Saved)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_UnPackInflowWind_Data(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(InflowWind_Data), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FAST_UnPackInflowWind_Data'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   LB(1:1) = lbound(OutData%x)
   UB(1:1) = ubound(OutData%x)
   do i1 = LB(1), UB(1)
      call InflowWind_UnpackContState(RF, OutData%x(i1)) ! x 
   end do
   LB(1:1) = lbound(OutData%xd)
   UB(1:1) = ubound(OutData%xd)
   do i1 = LB(1), UB(1)
      call InflowWind_UnpackDiscState(RF, OutData%xd(i1)) ! xd 
   end do
   LB(1:1) = lbound(OutData%z)
   UB(1:1) = ubound(OutData%z)
   do i1 = LB(1), UB(1)
      call InflowWind_UnpackConstrState(RF, OutData%z(i1)) ! z 
   end do
   LB(1:1) = lbound(OutData%OtherSt)
   UB(1:1) = ubound(OutData%OtherSt)
   do i1 = LB(1), UB(1)
      call InflowWind_UnpackOtherState(RF, OutData%OtherSt(i1)) ! OtherSt 
   end do
   call InflowWind_UnpackParam(RF, OutData%p) ! p 
   call InflowWind_UnpackInput(RF, OutData%u) ! u 
   call InflowWind_UnpackOutput(RF, OutData%y) ! y 
   call InflowWind_UnpackMisc(RF, OutData%m) ! m 
   if (allocated(OutData%Output)) deallocate(OutData%Output)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Output(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Output.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call InflowWind_UnpackOutput(RF, OutData%Output(i1)) ! Output 
      end do
   end if
   call InflowWind_UnpackOutput(RF, OutData%y_interp) ! y_interp 
   if (allocated(OutData%Input)) deallocate(OutData%Input)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Input(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Input.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call InflowWind_UnpackInput(RF, OutData%Input(i1)) ! Input 
      end do
   end if
   if (allocated(OutData%Input_Saved)) deallocate(OutData%Input_Saved)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Input_Saved(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Input_Saved.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call InflowWind_UnpackInput(RF, OutData%Input_Saved(i1)) ! Input_Saved 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%InputTimes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%InputTimes_Saved); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_CopyExternalInflow_Data(SrcExternalInflow_DataData, DstExternalInflow_DataData, CtrlCode, ErrStat, ErrMsg)
   type(ExternalInflow_Data), intent(inout) :: SrcExternalInflow_DataData
   type(ExternalInflow_Data), intent(inout) :: DstExternalInflow_DataData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_CopyExternalInflow_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call ExtInfw_CopyInput(SrcExternalInflow_DataData%u, DstExternalInflow_DataData%u, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call ExtInfw_CopyOutput(SrcExternalInflow_DataData%y, DstExternalInflow_DataData%y, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call ExtInfw_CopyParam(SrcExternalInflow_DataData%p, DstExternalInflow_DataData%p, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call ExtInfw_CopyMisc(SrcExternalInflow_DataData%m, DstExternalInflow_DataData%m, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine FAST_DestroyExternalInflow_Data(ExternalInflow_DataData, ErrStat, ErrMsg)
   type(ExternalInflow_Data), intent(inout) :: ExternalInflow_DataData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_DestroyExternalInflow_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call ExtInfw_DestroyInput(ExternalInflow_DataData%u, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call ExtInfw_DestroyOutput(ExternalInflow_DataData%y, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call ExtInfw_DestroyParam(ExternalInflow_DataData%p, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call ExtInfw_DestroyMisc(ExternalInflow_DataData%m, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine FAST_PackExternalInflow_Data(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ExternalInflow_Data), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FAST_PackExternalInflow_Data'
   if (RF%ErrStat >= AbortErrLev) return
   call ExtInfw_PackInput(RF, InData%u) 
   call ExtInfw_PackOutput(RF, InData%y) 
   call ExtInfw_PackParam(RF, InData%p) 
   call ExtInfw_PackMisc(RF, InData%m) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_UnPackExternalInflow_Data(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ExternalInflow_Data), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FAST_UnPackExternalInflow_Data'
   if (RF%ErrStat /= ErrID_None) return
   call ExtInfw_UnpackInput(RF, OutData%u) ! u 
   call ExtInfw_UnpackOutput(RF, OutData%y) ! y 
   call ExtInfw_UnpackParam(RF, OutData%p) ! p 
   call ExtInfw_UnpackMisc(RF, OutData%m) ! m 
end subroutine

subroutine FAST_CopySubDyn_Data(SrcSubDyn_DataData, DstSubDyn_DataData, CtrlCode, ErrStat, ErrMsg)
   type(SubDyn_Data), intent(inout) :: SrcSubDyn_DataData
   type(SubDyn_Data), intent(inout) :: DstSubDyn_DataData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_CopySubDyn_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   LB(1:1) = lbound(SrcSubDyn_DataData%x)
   UB(1:1) = ubound(SrcSubDyn_DataData%x)
   do i1 = LB(1), UB(1)
      call SD_CopyContState(SrcSubDyn_DataData%x(i1), DstSubDyn_DataData%x(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcSubDyn_DataData%xd)
   UB(1:1) = ubound(SrcSubDyn_DataData%xd)
   do i1 = LB(1), UB(1)
      call SD_CopyDiscState(SrcSubDyn_DataData%xd(i1), DstSubDyn_DataData%xd(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcSubDyn_DataData%z)
   UB(1:1) = ubound(SrcSubDyn_DataData%z)
   do i1 = LB(1), UB(1)
      call SD_CopyConstrState(SrcSubDyn_DataData%z(i1), DstSubDyn_DataData%z(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcSubDyn_DataData%OtherSt)
   UB(1:1) = ubound(SrcSubDyn_DataData%OtherSt)
   do i1 = LB(1), UB(1)
      call SD_CopyOtherState(SrcSubDyn_DataData%OtherSt(i1), DstSubDyn_DataData%OtherSt(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   call SD_CopyParam(SrcSubDyn_DataData%p, DstSubDyn_DataData%p, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call SD_CopyInput(SrcSubDyn_DataData%u, DstSubDyn_DataData%u, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call SD_CopyOutput(SrcSubDyn_DataData%y, DstSubDyn_DataData%y, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call SD_CopyMisc(SrcSubDyn_DataData%m, DstSubDyn_DataData%m, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcSubDyn_DataData%Input)) then
      LB(1:1) = lbound(SrcSubDyn_DataData%Input)
      UB(1:1) = ubound(SrcSubDyn_DataData%Input)
      if (.not. allocated(DstSubDyn_DataData%Input)) then
         allocate(DstSubDyn_DataData%Input(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstSubDyn_DataData%Input.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call SD_CopyInput(SrcSubDyn_DataData%Input(i1), DstSubDyn_DataData%Input(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcSubDyn_DataData%Input_Saved)) then
      LB(1:1) = lbound(SrcSubDyn_DataData%Input_Saved)
      UB(1:1) = ubound(SrcSubDyn_DataData%Input_Saved)
      if (.not. allocated(DstSubDyn_DataData%Input_Saved)) then
         allocate(DstSubDyn_DataData%Input_Saved(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstSubDyn_DataData%Input_Saved.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call SD_CopyInput(SrcSubDyn_DataData%Input_Saved(i1), DstSubDyn_DataData%Input_Saved(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcSubDyn_DataData%Output)) then
      LB(1:1) = lbound(SrcSubDyn_DataData%Output)
      UB(1:1) = ubound(SrcSubDyn_DataData%Output)
      if (.not. allocated(DstSubDyn_DataData%Output)) then
         allocate(DstSubDyn_DataData%Output(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstSubDyn_DataData%Output.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call SD_CopyOutput(SrcSubDyn_DataData%Output(i1), DstSubDyn_DataData%Output(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call SD_CopyOutput(SrcSubDyn_DataData%y_interp, DstSubDyn_DataData%y_interp, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcSubDyn_DataData%InputTimes)) then
      LB(1:1) = lbound(SrcSubDyn_DataData%InputTimes)
      UB(1:1) = ubound(SrcSubDyn_DataData%InputTimes)
      if (.not. allocated(DstSubDyn_DataData%InputTimes)) then
         allocate(DstSubDyn_DataData%InputTimes(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstSubDyn_DataData%InputTimes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstSubDyn_DataData%InputTimes = SrcSubDyn_DataData%InputTimes
   end if
   if (allocated(SrcSubDyn_DataData%InputTimes_Saved)) then
      LB(1:1) = lbound(SrcSubDyn_DataData%InputTimes_Saved)
      UB(1:1) = ubound(SrcSubDyn_DataData%InputTimes_Saved)
      if (.not. allocated(DstSubDyn_DataData%InputTimes_Saved)) then
         allocate(DstSubDyn_DataData%InputTimes_Saved(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstSubDyn_DataData%InputTimes_Saved.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstSubDyn_DataData%InputTimes_Saved = SrcSubDyn_DataData%InputTimes_Saved
   end if
end subroutine

subroutine FAST_DestroySubDyn_Data(SubDyn_DataData, ErrStat, ErrMsg)
   type(SubDyn_Data), intent(inout) :: SubDyn_DataData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_DestroySubDyn_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   LB(1:1) = lbound(SubDyn_DataData%x)
   UB(1:1) = ubound(SubDyn_DataData%x)
   do i1 = LB(1), UB(1)
      call SD_DestroyContState(SubDyn_DataData%x(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(SubDyn_DataData%xd)
   UB(1:1) = ubound(SubDyn_DataData%xd)
   do i1 = LB(1), UB(1)
      call SD_DestroyDiscState(SubDyn_DataData%xd(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(SubDyn_DataData%z)
   UB(1:1) = ubound(SubDyn_DataData%z)
   do i1 = LB(1), UB(1)
      call SD_DestroyConstrState(SubDyn_DataData%z(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(SubDyn_DataData%OtherSt)
   UB(1:1) = ubound(SubDyn_DataData%OtherSt)
   do i1 = LB(1), UB(1)
      call SD_DestroyOtherState(SubDyn_DataData%OtherSt(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   call SD_DestroyParam(SubDyn_DataData%p, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call SD_DestroyInput(SubDyn_DataData%u, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call SD_DestroyOutput(SubDyn_DataData%y, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call SD_DestroyMisc(SubDyn_DataData%m, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(SubDyn_DataData%Input)) then
      LB(1:1) = lbound(SubDyn_DataData%Input)
      UB(1:1) = ubound(SubDyn_DataData%Input)
      do i1 = LB(1), UB(1)
         call SD_DestroyInput(SubDyn_DataData%Input(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(SubDyn_DataData%Input)
   end if
   if (allocated(SubDyn_DataData%Input_Saved)) then
      LB(1:1) = lbound(SubDyn_DataData%Input_Saved)
      UB(1:1) = ubound(SubDyn_DataData%Input_Saved)
      do i1 = LB(1), UB(1)
         call SD_DestroyInput(SubDyn_DataData%Input_Saved(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(SubDyn_DataData%Input_Saved)
   end if
   if (allocated(SubDyn_DataData%Output)) then
      LB(1:1) = lbound(SubDyn_DataData%Output)
      UB(1:1) = ubound(SubDyn_DataData%Output)
      do i1 = LB(1), UB(1)
         call SD_DestroyOutput(SubDyn_DataData%Output(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(SubDyn_DataData%Output)
   end if
   call SD_DestroyOutput(SubDyn_DataData%y_interp, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(SubDyn_DataData%InputTimes)) then
      deallocate(SubDyn_DataData%InputTimes)
   end if
   if (allocated(SubDyn_DataData%InputTimes_Saved)) then
      deallocate(SubDyn_DataData%InputTimes_Saved)
   end if
end subroutine

subroutine FAST_PackSubDyn_Data(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SubDyn_Data), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FAST_PackSubDyn_Data'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   LB(1:1) = lbound(InData%x)
   UB(1:1) = ubound(InData%x)
   do i1 = LB(1), UB(1)
      call SD_PackContState(RF, InData%x(i1)) 
   end do
   LB(1:1) = lbound(InData%xd)
   UB(1:1) = ubound(InData%xd)
   do i1 = LB(1), UB(1)
      call SD_PackDiscState(RF, InData%xd(i1)) 
   end do
   LB(1:1) = lbound(InData%z)
   UB(1:1) = ubound(InData%z)
   do i1 = LB(1), UB(1)
      call SD_PackConstrState(RF, InData%z(i1)) 
   end do
   LB(1:1) = lbound(InData%OtherSt)
   UB(1:1) = ubound(InData%OtherSt)
   do i1 = LB(1), UB(1)
      call SD_PackOtherState(RF, InData%OtherSt(i1)) 
   end do
   call SD_PackParam(RF, InData%p) 
   call SD_PackInput(RF, InData%u) 
   call SD_PackOutput(RF, InData%y) 
   call SD_PackMisc(RF, InData%m) 
   call RegPack(RF, allocated(InData%Input))
   if (allocated(InData%Input)) then
      call RegPackBounds(RF, 1, lbound(InData%Input), ubound(InData%Input))
      LB(1:1) = lbound(InData%Input)
      UB(1:1) = ubound(InData%Input)
      do i1 = LB(1), UB(1)
         call SD_PackInput(RF, InData%Input(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%Input_Saved))
   if (allocated(InData%Input_Saved)) then
      call RegPackBounds(RF, 1, lbound(InData%Input_Saved), ubound(InData%Input_Saved))
      LB(1:1) = lbound(InData%Input_Saved)
      UB(1:1) = ubound(InData%Input_Saved)
      do i1 = LB(1), UB(1)
         call SD_PackInput(RF, InData%Input_Saved(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%Output))
   if (allocated(InData%Output)) then
      call RegPackBounds(RF, 1, lbound(InData%Output), ubound(InData%Output))
      LB(1:1) = lbound(InData%Output)
      UB(1:1) = ubound(InData%Output)
      do i1 = LB(1), UB(1)
         call SD_PackOutput(RF, InData%Output(i1)) 
      end do
   end if
   call SD_PackOutput(RF, InData%y_interp) 
   call RegPackAlloc(RF, InData%InputTimes)
   call RegPackAlloc(RF, InData%InputTimes_Saved)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_UnPackSubDyn_Data(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SubDyn_Data), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FAST_UnPackSubDyn_Data'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   LB(1:1) = lbound(OutData%x)
   UB(1:1) = ubound(OutData%x)
   do i1 = LB(1), UB(1)
      call SD_UnpackContState(RF, OutData%x(i1)) ! x 
   end do
   LB(1:1) = lbound(OutData%xd)
   UB(1:1) = ubound(OutData%xd)
   do i1 = LB(1), UB(1)
      call SD_UnpackDiscState(RF, OutData%xd(i1)) ! xd 
   end do
   LB(1:1) = lbound(OutData%z)
   UB(1:1) = ubound(OutData%z)
   do i1 = LB(1), UB(1)
      call SD_UnpackConstrState(RF, OutData%z(i1)) ! z 
   end do
   LB(1:1) = lbound(OutData%OtherSt)
   UB(1:1) = ubound(OutData%OtherSt)
   do i1 = LB(1), UB(1)
      call SD_UnpackOtherState(RF, OutData%OtherSt(i1)) ! OtherSt 
   end do
   call SD_UnpackParam(RF, OutData%p) ! p 
   call SD_UnpackInput(RF, OutData%u) ! u 
   call SD_UnpackOutput(RF, OutData%y) ! y 
   call SD_UnpackMisc(RF, OutData%m) ! m 
   if (allocated(OutData%Input)) deallocate(OutData%Input)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Input(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Input.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call SD_UnpackInput(RF, OutData%Input(i1)) ! Input 
      end do
   end if
   if (allocated(OutData%Input_Saved)) deallocate(OutData%Input_Saved)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Input_Saved(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Input_Saved.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call SD_UnpackInput(RF, OutData%Input_Saved(i1)) ! Input_Saved 
      end do
   end if
   if (allocated(OutData%Output)) deallocate(OutData%Output)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Output(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Output.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call SD_UnpackOutput(RF, OutData%Output(i1)) ! Output 
      end do
   end if
   call SD_UnpackOutput(RF, OutData%y_interp) ! y_interp 
   call RegUnpackAlloc(RF, OutData%InputTimes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%InputTimes_Saved); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_CopyExtPtfm_Data(SrcExtPtfm_DataData, DstExtPtfm_DataData, CtrlCode, ErrStat, ErrMsg)
   type(ExtPtfm_Data), intent(inout) :: SrcExtPtfm_DataData
   type(ExtPtfm_Data), intent(inout) :: DstExtPtfm_DataData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_CopyExtPtfm_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   LB(1:1) = lbound(SrcExtPtfm_DataData%x)
   UB(1:1) = ubound(SrcExtPtfm_DataData%x)
   do i1 = LB(1), UB(1)
      call ExtPtfm_CopyContState(SrcExtPtfm_DataData%x(i1), DstExtPtfm_DataData%x(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcExtPtfm_DataData%xd)
   UB(1:1) = ubound(SrcExtPtfm_DataData%xd)
   do i1 = LB(1), UB(1)
      call ExtPtfm_CopyDiscState(SrcExtPtfm_DataData%xd(i1), DstExtPtfm_DataData%xd(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcExtPtfm_DataData%z)
   UB(1:1) = ubound(SrcExtPtfm_DataData%z)
   do i1 = LB(1), UB(1)
      call ExtPtfm_CopyConstrState(SrcExtPtfm_DataData%z(i1), DstExtPtfm_DataData%z(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcExtPtfm_DataData%OtherSt)
   UB(1:1) = ubound(SrcExtPtfm_DataData%OtherSt)
   do i1 = LB(1), UB(1)
      call ExtPtfm_CopyOtherState(SrcExtPtfm_DataData%OtherSt(i1), DstExtPtfm_DataData%OtherSt(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   call ExtPtfm_CopyParam(SrcExtPtfm_DataData%p, DstExtPtfm_DataData%p, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call ExtPtfm_CopyInput(SrcExtPtfm_DataData%u, DstExtPtfm_DataData%u, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call ExtPtfm_CopyOutput(SrcExtPtfm_DataData%y, DstExtPtfm_DataData%y, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call ExtPtfm_CopyMisc(SrcExtPtfm_DataData%m, DstExtPtfm_DataData%m, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcExtPtfm_DataData%Input)) then
      LB(1:1) = lbound(SrcExtPtfm_DataData%Input)
      UB(1:1) = ubound(SrcExtPtfm_DataData%Input)
      if (.not. allocated(DstExtPtfm_DataData%Input)) then
         allocate(DstExtPtfm_DataData%Input(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstExtPtfm_DataData%Input.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call ExtPtfm_CopyInput(SrcExtPtfm_DataData%Input(i1), DstExtPtfm_DataData%Input(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcExtPtfm_DataData%Input_Saved)) then
      LB(1:1) = lbound(SrcExtPtfm_DataData%Input_Saved)
      UB(1:1) = ubound(SrcExtPtfm_DataData%Input_Saved)
      if (.not. allocated(DstExtPtfm_DataData%Input_Saved)) then
         allocate(DstExtPtfm_DataData%Input_Saved(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstExtPtfm_DataData%Input_Saved.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call ExtPtfm_CopyInput(SrcExtPtfm_DataData%Input_Saved(i1), DstExtPtfm_DataData%Input_Saved(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcExtPtfm_DataData%InputTimes)) then
      LB(1:1) = lbound(SrcExtPtfm_DataData%InputTimes)
      UB(1:1) = ubound(SrcExtPtfm_DataData%InputTimes)
      if (.not. allocated(DstExtPtfm_DataData%InputTimes)) then
         allocate(DstExtPtfm_DataData%InputTimes(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstExtPtfm_DataData%InputTimes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstExtPtfm_DataData%InputTimes = SrcExtPtfm_DataData%InputTimes
   end if
   if (allocated(SrcExtPtfm_DataData%InputTimes_Saved)) then
      LB(1:1) = lbound(SrcExtPtfm_DataData%InputTimes_Saved)
      UB(1:1) = ubound(SrcExtPtfm_DataData%InputTimes_Saved)
      if (.not. allocated(DstExtPtfm_DataData%InputTimes_Saved)) then
         allocate(DstExtPtfm_DataData%InputTimes_Saved(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstExtPtfm_DataData%InputTimes_Saved.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstExtPtfm_DataData%InputTimes_Saved = SrcExtPtfm_DataData%InputTimes_Saved
   end if
end subroutine

subroutine FAST_DestroyExtPtfm_Data(ExtPtfm_DataData, ErrStat, ErrMsg)
   type(ExtPtfm_Data), intent(inout) :: ExtPtfm_DataData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_DestroyExtPtfm_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   LB(1:1) = lbound(ExtPtfm_DataData%x)
   UB(1:1) = ubound(ExtPtfm_DataData%x)
   do i1 = LB(1), UB(1)
      call ExtPtfm_DestroyContState(ExtPtfm_DataData%x(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(ExtPtfm_DataData%xd)
   UB(1:1) = ubound(ExtPtfm_DataData%xd)
   do i1 = LB(1), UB(1)
      call ExtPtfm_DestroyDiscState(ExtPtfm_DataData%xd(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(ExtPtfm_DataData%z)
   UB(1:1) = ubound(ExtPtfm_DataData%z)
   do i1 = LB(1), UB(1)
      call ExtPtfm_DestroyConstrState(ExtPtfm_DataData%z(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(ExtPtfm_DataData%OtherSt)
   UB(1:1) = ubound(ExtPtfm_DataData%OtherSt)
   do i1 = LB(1), UB(1)
      call ExtPtfm_DestroyOtherState(ExtPtfm_DataData%OtherSt(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   call ExtPtfm_DestroyParam(ExtPtfm_DataData%p, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call ExtPtfm_DestroyInput(ExtPtfm_DataData%u, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call ExtPtfm_DestroyOutput(ExtPtfm_DataData%y, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call ExtPtfm_DestroyMisc(ExtPtfm_DataData%m, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(ExtPtfm_DataData%Input)) then
      LB(1:1) = lbound(ExtPtfm_DataData%Input)
      UB(1:1) = ubound(ExtPtfm_DataData%Input)
      do i1 = LB(1), UB(1)
         call ExtPtfm_DestroyInput(ExtPtfm_DataData%Input(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ExtPtfm_DataData%Input)
   end if
   if (allocated(ExtPtfm_DataData%Input_Saved)) then
      LB(1:1) = lbound(ExtPtfm_DataData%Input_Saved)
      UB(1:1) = ubound(ExtPtfm_DataData%Input_Saved)
      do i1 = LB(1), UB(1)
         call ExtPtfm_DestroyInput(ExtPtfm_DataData%Input_Saved(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ExtPtfm_DataData%Input_Saved)
   end if
   if (allocated(ExtPtfm_DataData%InputTimes)) then
      deallocate(ExtPtfm_DataData%InputTimes)
   end if
   if (allocated(ExtPtfm_DataData%InputTimes_Saved)) then
      deallocate(ExtPtfm_DataData%InputTimes_Saved)
   end if
end subroutine

subroutine FAST_PackExtPtfm_Data(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ExtPtfm_Data), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FAST_PackExtPtfm_Data'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   LB(1:1) = lbound(InData%x)
   UB(1:1) = ubound(InData%x)
   do i1 = LB(1), UB(1)
      call ExtPtfm_PackContState(RF, InData%x(i1)) 
   end do
   LB(1:1) = lbound(InData%xd)
   UB(1:1) = ubound(InData%xd)
   do i1 = LB(1), UB(1)
      call ExtPtfm_PackDiscState(RF, InData%xd(i1)) 
   end do
   LB(1:1) = lbound(InData%z)
   UB(1:1) = ubound(InData%z)
   do i1 = LB(1), UB(1)
      call ExtPtfm_PackConstrState(RF, InData%z(i1)) 
   end do
   LB(1:1) = lbound(InData%OtherSt)
   UB(1:1) = ubound(InData%OtherSt)
   do i1 = LB(1), UB(1)
      call ExtPtfm_PackOtherState(RF, InData%OtherSt(i1)) 
   end do
   call ExtPtfm_PackParam(RF, InData%p) 
   call ExtPtfm_PackInput(RF, InData%u) 
   call ExtPtfm_PackOutput(RF, InData%y) 
   call ExtPtfm_PackMisc(RF, InData%m) 
   call RegPack(RF, allocated(InData%Input))
   if (allocated(InData%Input)) then
      call RegPackBounds(RF, 1, lbound(InData%Input), ubound(InData%Input))
      LB(1:1) = lbound(InData%Input)
      UB(1:1) = ubound(InData%Input)
      do i1 = LB(1), UB(1)
         call ExtPtfm_PackInput(RF, InData%Input(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%Input_Saved))
   if (allocated(InData%Input_Saved)) then
      call RegPackBounds(RF, 1, lbound(InData%Input_Saved), ubound(InData%Input_Saved))
      LB(1:1) = lbound(InData%Input_Saved)
      UB(1:1) = ubound(InData%Input_Saved)
      do i1 = LB(1), UB(1)
         call ExtPtfm_PackInput(RF, InData%Input_Saved(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%InputTimes)
   call RegPackAlloc(RF, InData%InputTimes_Saved)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_UnPackExtPtfm_Data(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ExtPtfm_Data), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FAST_UnPackExtPtfm_Data'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   LB(1:1) = lbound(OutData%x)
   UB(1:1) = ubound(OutData%x)
   do i1 = LB(1), UB(1)
      call ExtPtfm_UnpackContState(RF, OutData%x(i1)) ! x 
   end do
   LB(1:1) = lbound(OutData%xd)
   UB(1:1) = ubound(OutData%xd)
   do i1 = LB(1), UB(1)
      call ExtPtfm_UnpackDiscState(RF, OutData%xd(i1)) ! xd 
   end do
   LB(1:1) = lbound(OutData%z)
   UB(1:1) = ubound(OutData%z)
   do i1 = LB(1), UB(1)
      call ExtPtfm_UnpackConstrState(RF, OutData%z(i1)) ! z 
   end do
   LB(1:1) = lbound(OutData%OtherSt)
   UB(1:1) = ubound(OutData%OtherSt)
   do i1 = LB(1), UB(1)
      call ExtPtfm_UnpackOtherState(RF, OutData%OtherSt(i1)) ! OtherSt 
   end do
   call ExtPtfm_UnpackParam(RF, OutData%p) ! p 
   call ExtPtfm_UnpackInput(RF, OutData%u) ! u 
   call ExtPtfm_UnpackOutput(RF, OutData%y) ! y 
   call ExtPtfm_UnpackMisc(RF, OutData%m) ! m 
   if (allocated(OutData%Input)) deallocate(OutData%Input)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Input(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Input.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call ExtPtfm_UnpackInput(RF, OutData%Input(i1)) ! Input 
      end do
   end if
   if (allocated(OutData%Input_Saved)) deallocate(OutData%Input_Saved)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Input_Saved(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Input_Saved.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call ExtPtfm_UnpackInput(RF, OutData%Input_Saved(i1)) ! Input_Saved 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%InputTimes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%InputTimes_Saved); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_CopySeaState_Data(SrcSeaState_DataData, DstSeaState_DataData, CtrlCode, ErrStat, ErrMsg)
   type(SeaState_Data), intent(in) :: SrcSeaState_DataData
   type(SeaState_Data), intent(inout) :: DstSeaState_DataData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_CopySeaState_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   LB(1:1) = lbound(SrcSeaState_DataData%x)
   UB(1:1) = ubound(SrcSeaState_DataData%x)
   do i1 = LB(1), UB(1)
      call SeaSt_CopyContState(SrcSeaState_DataData%x(i1), DstSeaState_DataData%x(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcSeaState_DataData%xd)
   UB(1:1) = ubound(SrcSeaState_DataData%xd)
   do i1 = LB(1), UB(1)
      call SeaSt_CopyDiscState(SrcSeaState_DataData%xd(i1), DstSeaState_DataData%xd(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcSeaState_DataData%z)
   UB(1:1) = ubound(SrcSeaState_DataData%z)
   do i1 = LB(1), UB(1)
      call SeaSt_CopyConstrState(SrcSeaState_DataData%z(i1), DstSeaState_DataData%z(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcSeaState_DataData%OtherSt)
   UB(1:1) = ubound(SrcSeaState_DataData%OtherSt)
   do i1 = LB(1), UB(1)
      call SeaSt_CopyOtherState(SrcSeaState_DataData%OtherSt(i1), DstSeaState_DataData%OtherSt(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   call SeaSt_CopyParam(SrcSeaState_DataData%p, DstSeaState_DataData%p, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call SeaSt_CopyInput(SrcSeaState_DataData%u, DstSeaState_DataData%u, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call SeaSt_CopyOutput(SrcSeaState_DataData%y, DstSeaState_DataData%y, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call SeaSt_CopyMisc(SrcSeaState_DataData%m, DstSeaState_DataData%m, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcSeaState_DataData%Input)) then
      LB(1:1) = lbound(SrcSeaState_DataData%Input)
      UB(1:1) = ubound(SrcSeaState_DataData%Input)
      if (.not. allocated(DstSeaState_DataData%Input)) then
         allocate(DstSeaState_DataData%Input(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstSeaState_DataData%Input.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call SeaSt_CopyInput(SrcSeaState_DataData%Input(i1), DstSeaState_DataData%Input(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcSeaState_DataData%Input_Saved)) then
      LB(1:1) = lbound(SrcSeaState_DataData%Input_Saved)
      UB(1:1) = ubound(SrcSeaState_DataData%Input_Saved)
      if (.not. allocated(DstSeaState_DataData%Input_Saved)) then
         allocate(DstSeaState_DataData%Input_Saved(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstSeaState_DataData%Input_Saved.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call SeaSt_CopyInput(SrcSeaState_DataData%Input_Saved(i1), DstSeaState_DataData%Input_Saved(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcSeaState_DataData%Output)) then
      LB(1:1) = lbound(SrcSeaState_DataData%Output)
      UB(1:1) = ubound(SrcSeaState_DataData%Output)
      if (.not. allocated(DstSeaState_DataData%Output)) then
         allocate(DstSeaState_DataData%Output(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstSeaState_DataData%Output.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call SeaSt_CopyOutput(SrcSeaState_DataData%Output(i1), DstSeaState_DataData%Output(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call SeaSt_CopyOutput(SrcSeaState_DataData%y_interp, DstSeaState_DataData%y_interp, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcSeaState_DataData%InputTimes)) then
      LB(1:1) = lbound(SrcSeaState_DataData%InputTimes)
      UB(1:1) = ubound(SrcSeaState_DataData%InputTimes)
      if (.not. allocated(DstSeaState_DataData%InputTimes)) then
         allocate(DstSeaState_DataData%InputTimes(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstSeaState_DataData%InputTimes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstSeaState_DataData%InputTimes = SrcSeaState_DataData%InputTimes
   end if
   if (allocated(SrcSeaState_DataData%InputTimes_Saved)) then
      LB(1:1) = lbound(SrcSeaState_DataData%InputTimes_Saved)
      UB(1:1) = ubound(SrcSeaState_DataData%InputTimes_Saved)
      if (.not. allocated(DstSeaState_DataData%InputTimes_Saved)) then
         allocate(DstSeaState_DataData%InputTimes_Saved(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstSeaState_DataData%InputTimes_Saved.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstSeaState_DataData%InputTimes_Saved = SrcSeaState_DataData%InputTimes_Saved
   end if
end subroutine

subroutine FAST_DestroySeaState_Data(SeaState_DataData, ErrStat, ErrMsg)
   type(SeaState_Data), intent(inout) :: SeaState_DataData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_DestroySeaState_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   LB(1:1) = lbound(SeaState_DataData%x)
   UB(1:1) = ubound(SeaState_DataData%x)
   do i1 = LB(1), UB(1)
      call SeaSt_DestroyContState(SeaState_DataData%x(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(SeaState_DataData%xd)
   UB(1:1) = ubound(SeaState_DataData%xd)
   do i1 = LB(1), UB(1)
      call SeaSt_DestroyDiscState(SeaState_DataData%xd(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(SeaState_DataData%z)
   UB(1:1) = ubound(SeaState_DataData%z)
   do i1 = LB(1), UB(1)
      call SeaSt_DestroyConstrState(SeaState_DataData%z(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(SeaState_DataData%OtherSt)
   UB(1:1) = ubound(SeaState_DataData%OtherSt)
   do i1 = LB(1), UB(1)
      call SeaSt_DestroyOtherState(SeaState_DataData%OtherSt(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   call SeaSt_DestroyParam(SeaState_DataData%p, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call SeaSt_DestroyInput(SeaState_DataData%u, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call SeaSt_DestroyOutput(SeaState_DataData%y, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call SeaSt_DestroyMisc(SeaState_DataData%m, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(SeaState_DataData%Input)) then
      LB(1:1) = lbound(SeaState_DataData%Input)
      UB(1:1) = ubound(SeaState_DataData%Input)
      do i1 = LB(1), UB(1)
         call SeaSt_DestroyInput(SeaState_DataData%Input(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(SeaState_DataData%Input)
   end if
   if (allocated(SeaState_DataData%Input_Saved)) then
      LB(1:1) = lbound(SeaState_DataData%Input_Saved)
      UB(1:1) = ubound(SeaState_DataData%Input_Saved)
      do i1 = LB(1), UB(1)
         call SeaSt_DestroyInput(SeaState_DataData%Input_Saved(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(SeaState_DataData%Input_Saved)
   end if
   if (allocated(SeaState_DataData%Output)) then
      LB(1:1) = lbound(SeaState_DataData%Output)
      UB(1:1) = ubound(SeaState_DataData%Output)
      do i1 = LB(1), UB(1)
         call SeaSt_DestroyOutput(SeaState_DataData%Output(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(SeaState_DataData%Output)
   end if
   call SeaSt_DestroyOutput(SeaState_DataData%y_interp, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(SeaState_DataData%InputTimes)) then
      deallocate(SeaState_DataData%InputTimes)
   end if
   if (allocated(SeaState_DataData%InputTimes_Saved)) then
      deallocate(SeaState_DataData%InputTimes_Saved)
   end if
end subroutine

subroutine FAST_PackSeaState_Data(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SeaState_Data), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FAST_PackSeaState_Data'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   LB(1:1) = lbound(InData%x)
   UB(1:1) = ubound(InData%x)
   do i1 = LB(1), UB(1)
      call SeaSt_PackContState(RF, InData%x(i1)) 
   end do
   LB(1:1) = lbound(InData%xd)
   UB(1:1) = ubound(InData%xd)
   do i1 = LB(1), UB(1)
      call SeaSt_PackDiscState(RF, InData%xd(i1)) 
   end do
   LB(1:1) = lbound(InData%z)
   UB(1:1) = ubound(InData%z)
   do i1 = LB(1), UB(1)
      call SeaSt_PackConstrState(RF, InData%z(i1)) 
   end do
   LB(1:1) = lbound(InData%OtherSt)
   UB(1:1) = ubound(InData%OtherSt)
   do i1 = LB(1), UB(1)
      call SeaSt_PackOtherState(RF, InData%OtherSt(i1)) 
   end do
   call SeaSt_PackParam(RF, InData%p) 
   call SeaSt_PackInput(RF, InData%u) 
   call SeaSt_PackOutput(RF, InData%y) 
   call SeaSt_PackMisc(RF, InData%m) 
   call RegPack(RF, allocated(InData%Input))
   if (allocated(InData%Input)) then
      call RegPackBounds(RF, 1, lbound(InData%Input), ubound(InData%Input))
      LB(1:1) = lbound(InData%Input)
      UB(1:1) = ubound(InData%Input)
      do i1 = LB(1), UB(1)
         call SeaSt_PackInput(RF, InData%Input(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%Input_Saved))
   if (allocated(InData%Input_Saved)) then
      call RegPackBounds(RF, 1, lbound(InData%Input_Saved), ubound(InData%Input_Saved))
      LB(1:1) = lbound(InData%Input_Saved)
      UB(1:1) = ubound(InData%Input_Saved)
      do i1 = LB(1), UB(1)
         call SeaSt_PackInput(RF, InData%Input_Saved(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%Output))
   if (allocated(InData%Output)) then
      call RegPackBounds(RF, 1, lbound(InData%Output), ubound(InData%Output))
      LB(1:1) = lbound(InData%Output)
      UB(1:1) = ubound(InData%Output)
      do i1 = LB(1), UB(1)
         call SeaSt_PackOutput(RF, InData%Output(i1)) 
      end do
   end if
   call SeaSt_PackOutput(RF, InData%y_interp) 
   call RegPackAlloc(RF, InData%InputTimes)
   call RegPackAlloc(RF, InData%InputTimes_Saved)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_UnPackSeaState_Data(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SeaState_Data), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FAST_UnPackSeaState_Data'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   LB(1:1) = lbound(OutData%x)
   UB(1:1) = ubound(OutData%x)
   do i1 = LB(1), UB(1)
      call SeaSt_UnpackContState(RF, OutData%x(i1)) ! x 
   end do
   LB(1:1) = lbound(OutData%xd)
   UB(1:1) = ubound(OutData%xd)
   do i1 = LB(1), UB(1)
      call SeaSt_UnpackDiscState(RF, OutData%xd(i1)) ! xd 
   end do
   LB(1:1) = lbound(OutData%z)
   UB(1:1) = ubound(OutData%z)
   do i1 = LB(1), UB(1)
      call SeaSt_UnpackConstrState(RF, OutData%z(i1)) ! z 
   end do
   LB(1:1) = lbound(OutData%OtherSt)
   UB(1:1) = ubound(OutData%OtherSt)
   do i1 = LB(1), UB(1)
      call SeaSt_UnpackOtherState(RF, OutData%OtherSt(i1)) ! OtherSt 
   end do
   call SeaSt_UnpackParam(RF, OutData%p) ! p 
   call SeaSt_UnpackInput(RF, OutData%u) ! u 
   call SeaSt_UnpackOutput(RF, OutData%y) ! y 
   call SeaSt_UnpackMisc(RF, OutData%m) ! m 
   if (allocated(OutData%Input)) deallocate(OutData%Input)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Input(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Input.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call SeaSt_UnpackInput(RF, OutData%Input(i1)) ! Input 
      end do
   end if
   if (allocated(OutData%Input_Saved)) deallocate(OutData%Input_Saved)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Input_Saved(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Input_Saved.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call SeaSt_UnpackInput(RF, OutData%Input_Saved(i1)) ! Input_Saved 
      end do
   end if
   if (allocated(OutData%Output)) deallocate(OutData%Output)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Output(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Output.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call SeaSt_UnpackOutput(RF, OutData%Output(i1)) ! Output 
      end do
   end if
   call SeaSt_UnpackOutput(RF, OutData%y_interp) ! y_interp 
   call RegUnpackAlloc(RF, OutData%InputTimes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%InputTimes_Saved); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_CopyHydroDyn_Data(SrcHydroDyn_DataData, DstHydroDyn_DataData, CtrlCode, ErrStat, ErrMsg)
   type(HydroDyn_Data), intent(inout) :: SrcHydroDyn_DataData
   type(HydroDyn_Data), intent(inout) :: DstHydroDyn_DataData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_CopyHydroDyn_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   LB(1:1) = lbound(SrcHydroDyn_DataData%x)
   UB(1:1) = ubound(SrcHydroDyn_DataData%x)
   do i1 = LB(1), UB(1)
      call HydroDyn_CopyContState(SrcHydroDyn_DataData%x(i1), DstHydroDyn_DataData%x(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcHydroDyn_DataData%xd)
   UB(1:1) = ubound(SrcHydroDyn_DataData%xd)
   do i1 = LB(1), UB(1)
      call HydroDyn_CopyDiscState(SrcHydroDyn_DataData%xd(i1), DstHydroDyn_DataData%xd(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcHydroDyn_DataData%z)
   UB(1:1) = ubound(SrcHydroDyn_DataData%z)
   do i1 = LB(1), UB(1)
      call HydroDyn_CopyConstrState(SrcHydroDyn_DataData%z(i1), DstHydroDyn_DataData%z(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcHydroDyn_DataData%OtherSt)
   UB(1:1) = ubound(SrcHydroDyn_DataData%OtherSt)
   do i1 = LB(1), UB(1)
      call HydroDyn_CopyOtherState(SrcHydroDyn_DataData%OtherSt(i1), DstHydroDyn_DataData%OtherSt(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   call HydroDyn_CopyParam(SrcHydroDyn_DataData%p, DstHydroDyn_DataData%p, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call HydroDyn_CopyInput(SrcHydroDyn_DataData%u, DstHydroDyn_DataData%u, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call HydroDyn_CopyOutput(SrcHydroDyn_DataData%y, DstHydroDyn_DataData%y, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call HydroDyn_CopyMisc(SrcHydroDyn_DataData%m, DstHydroDyn_DataData%m, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcHydroDyn_DataData%Output)) then
      LB(1:1) = lbound(SrcHydroDyn_DataData%Output)
      UB(1:1) = ubound(SrcHydroDyn_DataData%Output)
      if (.not. allocated(DstHydroDyn_DataData%Output)) then
         allocate(DstHydroDyn_DataData%Output(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstHydroDyn_DataData%Output.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call HydroDyn_CopyOutput(SrcHydroDyn_DataData%Output(i1), DstHydroDyn_DataData%Output(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call HydroDyn_CopyOutput(SrcHydroDyn_DataData%y_interp, DstHydroDyn_DataData%y_interp, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcHydroDyn_DataData%Input)) then
      LB(1:1) = lbound(SrcHydroDyn_DataData%Input)
      UB(1:1) = ubound(SrcHydroDyn_DataData%Input)
      if (.not. allocated(DstHydroDyn_DataData%Input)) then
         allocate(DstHydroDyn_DataData%Input(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstHydroDyn_DataData%Input.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call HydroDyn_CopyInput(SrcHydroDyn_DataData%Input(i1), DstHydroDyn_DataData%Input(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcHydroDyn_DataData%Input_Saved)) then
      LB(1:1) = lbound(SrcHydroDyn_DataData%Input_Saved)
      UB(1:1) = ubound(SrcHydroDyn_DataData%Input_Saved)
      if (.not. allocated(DstHydroDyn_DataData%Input_Saved)) then
         allocate(DstHydroDyn_DataData%Input_Saved(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstHydroDyn_DataData%Input_Saved.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call HydroDyn_CopyInput(SrcHydroDyn_DataData%Input_Saved(i1), DstHydroDyn_DataData%Input_Saved(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcHydroDyn_DataData%InputTimes)) then
      LB(1:1) = lbound(SrcHydroDyn_DataData%InputTimes)
      UB(1:1) = ubound(SrcHydroDyn_DataData%InputTimes)
      if (.not. allocated(DstHydroDyn_DataData%InputTimes)) then
         allocate(DstHydroDyn_DataData%InputTimes(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstHydroDyn_DataData%InputTimes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstHydroDyn_DataData%InputTimes = SrcHydroDyn_DataData%InputTimes
   end if
   if (allocated(SrcHydroDyn_DataData%InputTimes_Saved)) then
      LB(1:1) = lbound(SrcHydroDyn_DataData%InputTimes_Saved)
      UB(1:1) = ubound(SrcHydroDyn_DataData%InputTimes_Saved)
      if (.not. allocated(DstHydroDyn_DataData%InputTimes_Saved)) then
         allocate(DstHydroDyn_DataData%InputTimes_Saved(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstHydroDyn_DataData%InputTimes_Saved.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstHydroDyn_DataData%InputTimes_Saved = SrcHydroDyn_DataData%InputTimes_Saved
   end if
end subroutine

subroutine FAST_DestroyHydroDyn_Data(HydroDyn_DataData, ErrStat, ErrMsg)
   type(HydroDyn_Data), intent(inout) :: HydroDyn_DataData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_DestroyHydroDyn_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   LB(1:1) = lbound(HydroDyn_DataData%x)
   UB(1:1) = ubound(HydroDyn_DataData%x)
   do i1 = LB(1), UB(1)
      call HydroDyn_DestroyContState(HydroDyn_DataData%x(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(HydroDyn_DataData%xd)
   UB(1:1) = ubound(HydroDyn_DataData%xd)
   do i1 = LB(1), UB(1)
      call HydroDyn_DestroyDiscState(HydroDyn_DataData%xd(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(HydroDyn_DataData%z)
   UB(1:1) = ubound(HydroDyn_DataData%z)
   do i1 = LB(1), UB(1)
      call HydroDyn_DestroyConstrState(HydroDyn_DataData%z(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(HydroDyn_DataData%OtherSt)
   UB(1:1) = ubound(HydroDyn_DataData%OtherSt)
   do i1 = LB(1), UB(1)
      call HydroDyn_DestroyOtherState(HydroDyn_DataData%OtherSt(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   call HydroDyn_DestroyParam(HydroDyn_DataData%p, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call HydroDyn_DestroyInput(HydroDyn_DataData%u, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call HydroDyn_DestroyOutput(HydroDyn_DataData%y, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call HydroDyn_DestroyMisc(HydroDyn_DataData%m, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(HydroDyn_DataData%Output)) then
      LB(1:1) = lbound(HydroDyn_DataData%Output)
      UB(1:1) = ubound(HydroDyn_DataData%Output)
      do i1 = LB(1), UB(1)
         call HydroDyn_DestroyOutput(HydroDyn_DataData%Output(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(HydroDyn_DataData%Output)
   end if
   call HydroDyn_DestroyOutput(HydroDyn_DataData%y_interp, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(HydroDyn_DataData%Input)) then
      LB(1:1) = lbound(HydroDyn_DataData%Input)
      UB(1:1) = ubound(HydroDyn_DataData%Input)
      do i1 = LB(1), UB(1)
         call HydroDyn_DestroyInput(HydroDyn_DataData%Input(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(HydroDyn_DataData%Input)
   end if
   if (allocated(HydroDyn_DataData%Input_Saved)) then
      LB(1:1) = lbound(HydroDyn_DataData%Input_Saved)
      UB(1:1) = ubound(HydroDyn_DataData%Input_Saved)
      do i1 = LB(1), UB(1)
         call HydroDyn_DestroyInput(HydroDyn_DataData%Input_Saved(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(HydroDyn_DataData%Input_Saved)
   end if
   if (allocated(HydroDyn_DataData%InputTimes)) then
      deallocate(HydroDyn_DataData%InputTimes)
   end if
   if (allocated(HydroDyn_DataData%InputTimes_Saved)) then
      deallocate(HydroDyn_DataData%InputTimes_Saved)
   end if
end subroutine

subroutine FAST_PackHydroDyn_Data(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(HydroDyn_Data), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FAST_PackHydroDyn_Data'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   LB(1:1) = lbound(InData%x)
   UB(1:1) = ubound(InData%x)
   do i1 = LB(1), UB(1)
      call HydroDyn_PackContState(RF, InData%x(i1)) 
   end do
   LB(1:1) = lbound(InData%xd)
   UB(1:1) = ubound(InData%xd)
   do i1 = LB(1), UB(1)
      call HydroDyn_PackDiscState(RF, InData%xd(i1)) 
   end do
   LB(1:1) = lbound(InData%z)
   UB(1:1) = ubound(InData%z)
   do i1 = LB(1), UB(1)
      call HydroDyn_PackConstrState(RF, InData%z(i1)) 
   end do
   LB(1:1) = lbound(InData%OtherSt)
   UB(1:1) = ubound(InData%OtherSt)
   do i1 = LB(1), UB(1)
      call HydroDyn_PackOtherState(RF, InData%OtherSt(i1)) 
   end do
   call HydroDyn_PackParam(RF, InData%p) 
   call HydroDyn_PackInput(RF, InData%u) 
   call HydroDyn_PackOutput(RF, InData%y) 
   call HydroDyn_PackMisc(RF, InData%m) 
   call RegPack(RF, allocated(InData%Output))
   if (allocated(InData%Output)) then
      call RegPackBounds(RF, 1, lbound(InData%Output), ubound(InData%Output))
      LB(1:1) = lbound(InData%Output)
      UB(1:1) = ubound(InData%Output)
      do i1 = LB(1), UB(1)
         call HydroDyn_PackOutput(RF, InData%Output(i1)) 
      end do
   end if
   call HydroDyn_PackOutput(RF, InData%y_interp) 
   call RegPack(RF, allocated(InData%Input))
   if (allocated(InData%Input)) then
      call RegPackBounds(RF, 1, lbound(InData%Input), ubound(InData%Input))
      LB(1:1) = lbound(InData%Input)
      UB(1:1) = ubound(InData%Input)
      do i1 = LB(1), UB(1)
         call HydroDyn_PackInput(RF, InData%Input(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%Input_Saved))
   if (allocated(InData%Input_Saved)) then
      call RegPackBounds(RF, 1, lbound(InData%Input_Saved), ubound(InData%Input_Saved))
      LB(1:1) = lbound(InData%Input_Saved)
      UB(1:1) = ubound(InData%Input_Saved)
      do i1 = LB(1), UB(1)
         call HydroDyn_PackInput(RF, InData%Input_Saved(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%InputTimes)
   call RegPackAlloc(RF, InData%InputTimes_Saved)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_UnPackHydroDyn_Data(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(HydroDyn_Data), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FAST_UnPackHydroDyn_Data'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   LB(1:1) = lbound(OutData%x)
   UB(1:1) = ubound(OutData%x)
   do i1 = LB(1), UB(1)
      call HydroDyn_UnpackContState(RF, OutData%x(i1)) ! x 
   end do
   LB(1:1) = lbound(OutData%xd)
   UB(1:1) = ubound(OutData%xd)
   do i1 = LB(1), UB(1)
      call HydroDyn_UnpackDiscState(RF, OutData%xd(i1)) ! xd 
   end do
   LB(1:1) = lbound(OutData%z)
   UB(1:1) = ubound(OutData%z)
   do i1 = LB(1), UB(1)
      call HydroDyn_UnpackConstrState(RF, OutData%z(i1)) ! z 
   end do
   LB(1:1) = lbound(OutData%OtherSt)
   UB(1:1) = ubound(OutData%OtherSt)
   do i1 = LB(1), UB(1)
      call HydroDyn_UnpackOtherState(RF, OutData%OtherSt(i1)) ! OtherSt 
   end do
   call HydroDyn_UnpackParam(RF, OutData%p) ! p 
   call HydroDyn_UnpackInput(RF, OutData%u) ! u 
   call HydroDyn_UnpackOutput(RF, OutData%y) ! y 
   call HydroDyn_UnpackMisc(RF, OutData%m) ! m 
   if (allocated(OutData%Output)) deallocate(OutData%Output)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Output(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Output.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call HydroDyn_UnpackOutput(RF, OutData%Output(i1)) ! Output 
      end do
   end if
   call HydroDyn_UnpackOutput(RF, OutData%y_interp) ! y_interp 
   if (allocated(OutData%Input)) deallocate(OutData%Input)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Input(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Input.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call HydroDyn_UnpackInput(RF, OutData%Input(i1)) ! Input 
      end do
   end if
   if (allocated(OutData%Input_Saved)) deallocate(OutData%Input_Saved)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Input_Saved(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Input_Saved.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call HydroDyn_UnpackInput(RF, OutData%Input_Saved(i1)) ! Input_Saved 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%InputTimes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%InputTimes_Saved); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_CopyIceFloe_Data(SrcIceFloe_DataData, DstIceFloe_DataData, CtrlCode, ErrStat, ErrMsg)
   type(IceFloe_Data), intent(inout) :: SrcIceFloe_DataData
   type(IceFloe_Data), intent(inout) :: DstIceFloe_DataData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_CopyIceFloe_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   LB(1:1) = lbound(SrcIceFloe_DataData%x)
   UB(1:1) = ubound(SrcIceFloe_DataData%x)
   do i1 = LB(1), UB(1)
      call IceFloe_CopyContState(SrcIceFloe_DataData%x(i1), DstIceFloe_DataData%x(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcIceFloe_DataData%xd)
   UB(1:1) = ubound(SrcIceFloe_DataData%xd)
   do i1 = LB(1), UB(1)
      call IceFloe_CopyDiscState(SrcIceFloe_DataData%xd(i1), DstIceFloe_DataData%xd(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcIceFloe_DataData%z)
   UB(1:1) = ubound(SrcIceFloe_DataData%z)
   do i1 = LB(1), UB(1)
      call IceFloe_CopyConstrState(SrcIceFloe_DataData%z(i1), DstIceFloe_DataData%z(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcIceFloe_DataData%OtherSt)
   UB(1:1) = ubound(SrcIceFloe_DataData%OtherSt)
   do i1 = LB(1), UB(1)
      call IceFloe_CopyOtherState(SrcIceFloe_DataData%OtherSt(i1), DstIceFloe_DataData%OtherSt(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   call IceFloe_CopyParam(SrcIceFloe_DataData%p, DstIceFloe_DataData%p, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call IceFloe_CopyInput(SrcIceFloe_DataData%u, DstIceFloe_DataData%u, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call IceFloe_CopyOutput(SrcIceFloe_DataData%y, DstIceFloe_DataData%y, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call IceFloe_CopyMisc(SrcIceFloe_DataData%m, DstIceFloe_DataData%m, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcIceFloe_DataData%Input)) then
      LB(1:1) = lbound(SrcIceFloe_DataData%Input)
      UB(1:1) = ubound(SrcIceFloe_DataData%Input)
      if (.not. allocated(DstIceFloe_DataData%Input)) then
         allocate(DstIceFloe_DataData%Input(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstIceFloe_DataData%Input.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call IceFloe_CopyInput(SrcIceFloe_DataData%Input(i1), DstIceFloe_DataData%Input(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcIceFloe_DataData%Input_Saved)) then
      LB(1:1) = lbound(SrcIceFloe_DataData%Input_Saved)
      UB(1:1) = ubound(SrcIceFloe_DataData%Input_Saved)
      if (.not. allocated(DstIceFloe_DataData%Input_Saved)) then
         allocate(DstIceFloe_DataData%Input_Saved(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstIceFloe_DataData%Input_Saved.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call IceFloe_CopyInput(SrcIceFloe_DataData%Input_Saved(i1), DstIceFloe_DataData%Input_Saved(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcIceFloe_DataData%InputTimes)) then
      LB(1:1) = lbound(SrcIceFloe_DataData%InputTimes)
      UB(1:1) = ubound(SrcIceFloe_DataData%InputTimes)
      if (.not. allocated(DstIceFloe_DataData%InputTimes)) then
         allocate(DstIceFloe_DataData%InputTimes(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstIceFloe_DataData%InputTimes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstIceFloe_DataData%InputTimes = SrcIceFloe_DataData%InputTimes
   end if
   if (allocated(SrcIceFloe_DataData%InputTimes_Saved)) then
      LB(1:1) = lbound(SrcIceFloe_DataData%InputTimes_Saved)
      UB(1:1) = ubound(SrcIceFloe_DataData%InputTimes_Saved)
      if (.not. allocated(DstIceFloe_DataData%InputTimes_Saved)) then
         allocate(DstIceFloe_DataData%InputTimes_Saved(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstIceFloe_DataData%InputTimes_Saved.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstIceFloe_DataData%InputTimes_Saved = SrcIceFloe_DataData%InputTimes_Saved
   end if
end subroutine

subroutine FAST_DestroyIceFloe_Data(IceFloe_DataData, ErrStat, ErrMsg)
   type(IceFloe_Data), intent(inout) :: IceFloe_DataData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_DestroyIceFloe_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   LB(1:1) = lbound(IceFloe_DataData%x)
   UB(1:1) = ubound(IceFloe_DataData%x)
   do i1 = LB(1), UB(1)
      call IceFloe_DestroyContState(IceFloe_DataData%x(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(IceFloe_DataData%xd)
   UB(1:1) = ubound(IceFloe_DataData%xd)
   do i1 = LB(1), UB(1)
      call IceFloe_DestroyDiscState(IceFloe_DataData%xd(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(IceFloe_DataData%z)
   UB(1:1) = ubound(IceFloe_DataData%z)
   do i1 = LB(1), UB(1)
      call IceFloe_DestroyConstrState(IceFloe_DataData%z(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(IceFloe_DataData%OtherSt)
   UB(1:1) = ubound(IceFloe_DataData%OtherSt)
   do i1 = LB(1), UB(1)
      call IceFloe_DestroyOtherState(IceFloe_DataData%OtherSt(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   call IceFloe_DestroyParam(IceFloe_DataData%p, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call IceFloe_DestroyInput(IceFloe_DataData%u, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call IceFloe_DestroyOutput(IceFloe_DataData%y, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call IceFloe_DestroyMisc(IceFloe_DataData%m, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(IceFloe_DataData%Input)) then
      LB(1:1) = lbound(IceFloe_DataData%Input)
      UB(1:1) = ubound(IceFloe_DataData%Input)
      do i1 = LB(1), UB(1)
         call IceFloe_DestroyInput(IceFloe_DataData%Input(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(IceFloe_DataData%Input)
   end if
   if (allocated(IceFloe_DataData%Input_Saved)) then
      LB(1:1) = lbound(IceFloe_DataData%Input_Saved)
      UB(1:1) = ubound(IceFloe_DataData%Input_Saved)
      do i1 = LB(1), UB(1)
         call IceFloe_DestroyInput(IceFloe_DataData%Input_Saved(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(IceFloe_DataData%Input_Saved)
   end if
   if (allocated(IceFloe_DataData%InputTimes)) then
      deallocate(IceFloe_DataData%InputTimes)
   end if
   if (allocated(IceFloe_DataData%InputTimes_Saved)) then
      deallocate(IceFloe_DataData%InputTimes_Saved)
   end if
end subroutine

subroutine FAST_PackIceFloe_Data(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(IceFloe_Data), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FAST_PackIceFloe_Data'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   LB(1:1) = lbound(InData%x)
   UB(1:1) = ubound(InData%x)
   do i1 = LB(1), UB(1)
      call IceFloe_PackContState(RF, InData%x(i1)) 
   end do
   LB(1:1) = lbound(InData%xd)
   UB(1:1) = ubound(InData%xd)
   do i1 = LB(1), UB(1)
      call IceFloe_PackDiscState(RF, InData%xd(i1)) 
   end do
   LB(1:1) = lbound(InData%z)
   UB(1:1) = ubound(InData%z)
   do i1 = LB(1), UB(1)
      call IceFloe_PackConstrState(RF, InData%z(i1)) 
   end do
   LB(1:1) = lbound(InData%OtherSt)
   UB(1:1) = ubound(InData%OtherSt)
   do i1 = LB(1), UB(1)
      call IceFloe_PackOtherState(RF, InData%OtherSt(i1)) 
   end do
   call IceFloe_PackParam(RF, InData%p) 
   call IceFloe_PackInput(RF, InData%u) 
   call IceFloe_PackOutput(RF, InData%y) 
   call IceFloe_PackMisc(RF, InData%m) 
   call RegPack(RF, allocated(InData%Input))
   if (allocated(InData%Input)) then
      call RegPackBounds(RF, 1, lbound(InData%Input), ubound(InData%Input))
      LB(1:1) = lbound(InData%Input)
      UB(1:1) = ubound(InData%Input)
      do i1 = LB(1), UB(1)
         call IceFloe_PackInput(RF, InData%Input(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%Input_Saved))
   if (allocated(InData%Input_Saved)) then
      call RegPackBounds(RF, 1, lbound(InData%Input_Saved), ubound(InData%Input_Saved))
      LB(1:1) = lbound(InData%Input_Saved)
      UB(1:1) = ubound(InData%Input_Saved)
      do i1 = LB(1), UB(1)
         call IceFloe_PackInput(RF, InData%Input_Saved(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%InputTimes)
   call RegPackAlloc(RF, InData%InputTimes_Saved)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_UnPackIceFloe_Data(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(IceFloe_Data), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FAST_UnPackIceFloe_Data'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   LB(1:1) = lbound(OutData%x)
   UB(1:1) = ubound(OutData%x)
   do i1 = LB(1), UB(1)
      call IceFloe_UnpackContState(RF, OutData%x(i1)) ! x 
   end do
   LB(1:1) = lbound(OutData%xd)
   UB(1:1) = ubound(OutData%xd)
   do i1 = LB(1), UB(1)
      call IceFloe_UnpackDiscState(RF, OutData%xd(i1)) ! xd 
   end do
   LB(1:1) = lbound(OutData%z)
   UB(1:1) = ubound(OutData%z)
   do i1 = LB(1), UB(1)
      call IceFloe_UnpackConstrState(RF, OutData%z(i1)) ! z 
   end do
   LB(1:1) = lbound(OutData%OtherSt)
   UB(1:1) = ubound(OutData%OtherSt)
   do i1 = LB(1), UB(1)
      call IceFloe_UnpackOtherState(RF, OutData%OtherSt(i1)) ! OtherSt 
   end do
   call IceFloe_UnpackParam(RF, OutData%p) ! p 
   call IceFloe_UnpackInput(RF, OutData%u) ! u 
   call IceFloe_UnpackOutput(RF, OutData%y) ! y 
   call IceFloe_UnpackMisc(RF, OutData%m) ! m 
   if (allocated(OutData%Input)) deallocate(OutData%Input)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Input(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Input.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call IceFloe_UnpackInput(RF, OutData%Input(i1)) ! Input 
      end do
   end if
   if (allocated(OutData%Input_Saved)) deallocate(OutData%Input_Saved)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Input_Saved(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Input_Saved.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call IceFloe_UnpackInput(RF, OutData%Input_Saved(i1)) ! Input_Saved 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%InputTimes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%InputTimes_Saved); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_CopyMAP_Data(SrcMAP_DataData, DstMAP_DataData, CtrlCode, ErrStat, ErrMsg)
   type(MAP_Data), intent(inout) :: SrcMAP_DataData
   type(MAP_Data), intent(inout) :: DstMAP_DataData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_CopyMAP_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   LB(1:1) = lbound(SrcMAP_DataData%x)
   UB(1:1) = ubound(SrcMAP_DataData%x)
   do i1 = LB(1), UB(1)
      call MAP_CopyContState(SrcMAP_DataData%x(i1), DstMAP_DataData%x(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcMAP_DataData%xd)
   UB(1:1) = ubound(SrcMAP_DataData%xd)
   do i1 = LB(1), UB(1)
      call MAP_CopyDiscState(SrcMAP_DataData%xd(i1), DstMAP_DataData%xd(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcMAP_DataData%z)
   UB(1:1) = ubound(SrcMAP_DataData%z)
   do i1 = LB(1), UB(1)
      call MAP_CopyConstrState(SrcMAP_DataData%z(i1), DstMAP_DataData%z(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   call MAP_CopyOtherState(SrcMAP_DataData%OtherSt, DstMAP_DataData%OtherSt, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MAP_CopyParam(SrcMAP_DataData%p, DstMAP_DataData%p, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MAP_CopyInput(SrcMAP_DataData%u, DstMAP_DataData%u, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MAP_CopyOutput(SrcMAP_DataData%y, DstMAP_DataData%y, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MAP_CopyOtherState(SrcMAP_DataData%OtherSt_old, DstMAP_DataData%OtherSt_old, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcMAP_DataData%Output)) then
      LB(1:1) = lbound(SrcMAP_DataData%Output)
      UB(1:1) = ubound(SrcMAP_DataData%Output)
      if (.not. allocated(DstMAP_DataData%Output)) then
         allocate(DstMAP_DataData%Output(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMAP_DataData%Output.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MAP_CopyOutput(SrcMAP_DataData%Output(i1), DstMAP_DataData%Output(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call MAP_CopyOutput(SrcMAP_DataData%y_interp, DstMAP_DataData%y_interp, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcMAP_DataData%Input)) then
      LB(1:1) = lbound(SrcMAP_DataData%Input)
      UB(1:1) = ubound(SrcMAP_DataData%Input)
      if (.not. allocated(DstMAP_DataData%Input)) then
         allocate(DstMAP_DataData%Input(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMAP_DataData%Input.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MAP_CopyInput(SrcMAP_DataData%Input(i1), DstMAP_DataData%Input(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcMAP_DataData%Input_Saved)) then
      LB(1:1) = lbound(SrcMAP_DataData%Input_Saved)
      UB(1:1) = ubound(SrcMAP_DataData%Input_Saved)
      if (.not. allocated(DstMAP_DataData%Input_Saved)) then
         allocate(DstMAP_DataData%Input_Saved(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMAP_DataData%Input_Saved.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MAP_CopyInput(SrcMAP_DataData%Input_Saved(i1), DstMAP_DataData%Input_Saved(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcMAP_DataData%InputTimes)) then
      LB(1:1) = lbound(SrcMAP_DataData%InputTimes)
      UB(1:1) = ubound(SrcMAP_DataData%InputTimes)
      if (.not. allocated(DstMAP_DataData%InputTimes)) then
         allocate(DstMAP_DataData%InputTimes(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMAP_DataData%InputTimes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMAP_DataData%InputTimes = SrcMAP_DataData%InputTimes
   end if
   if (allocated(SrcMAP_DataData%InputTimes_Saved)) then
      LB(1:1) = lbound(SrcMAP_DataData%InputTimes_Saved)
      UB(1:1) = ubound(SrcMAP_DataData%InputTimes_Saved)
      if (.not. allocated(DstMAP_DataData%InputTimes_Saved)) then
         allocate(DstMAP_DataData%InputTimes_Saved(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMAP_DataData%InputTimes_Saved.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMAP_DataData%InputTimes_Saved = SrcMAP_DataData%InputTimes_Saved
   end if
end subroutine

subroutine FAST_DestroyMAP_Data(MAP_DataData, ErrStat, ErrMsg)
   type(MAP_Data), intent(inout) :: MAP_DataData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_DestroyMAP_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   LB(1:1) = lbound(MAP_DataData%x)
   UB(1:1) = ubound(MAP_DataData%x)
   do i1 = LB(1), UB(1)
      call MAP_DestroyContState(MAP_DataData%x(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(MAP_DataData%xd)
   UB(1:1) = ubound(MAP_DataData%xd)
   do i1 = LB(1), UB(1)
      call MAP_DestroyDiscState(MAP_DataData%xd(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(MAP_DataData%z)
   UB(1:1) = ubound(MAP_DataData%z)
   do i1 = LB(1), UB(1)
      call MAP_DestroyConstrState(MAP_DataData%z(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   call MAP_DestroyOtherState(MAP_DataData%OtherSt, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MAP_DestroyParam(MAP_DataData%p, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MAP_DestroyInput(MAP_DataData%u, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MAP_DestroyOutput(MAP_DataData%y, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MAP_DestroyOtherState(MAP_DataData%OtherSt_old, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(MAP_DataData%Output)) then
      LB(1:1) = lbound(MAP_DataData%Output)
      UB(1:1) = ubound(MAP_DataData%Output)
      do i1 = LB(1), UB(1)
         call MAP_DestroyOutput(MAP_DataData%Output(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MAP_DataData%Output)
   end if
   call MAP_DestroyOutput(MAP_DataData%y_interp, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(MAP_DataData%Input)) then
      LB(1:1) = lbound(MAP_DataData%Input)
      UB(1:1) = ubound(MAP_DataData%Input)
      do i1 = LB(1), UB(1)
         call MAP_DestroyInput(MAP_DataData%Input(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MAP_DataData%Input)
   end if
   if (allocated(MAP_DataData%Input_Saved)) then
      LB(1:1) = lbound(MAP_DataData%Input_Saved)
      UB(1:1) = ubound(MAP_DataData%Input_Saved)
      do i1 = LB(1), UB(1)
         call MAP_DestroyInput(MAP_DataData%Input_Saved(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MAP_DataData%Input_Saved)
   end if
   if (allocated(MAP_DataData%InputTimes)) then
      deallocate(MAP_DataData%InputTimes)
   end if
   if (allocated(MAP_DataData%InputTimes_Saved)) then
      deallocate(MAP_DataData%InputTimes_Saved)
   end if
end subroutine

subroutine FAST_PackMAP_Data(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(MAP_Data), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FAST_PackMAP_Data'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   LB(1:1) = lbound(InData%x)
   UB(1:1) = ubound(InData%x)
   do i1 = LB(1), UB(1)
      call MAP_PackContState(RF, InData%x(i1)) 
   end do
   LB(1:1) = lbound(InData%xd)
   UB(1:1) = ubound(InData%xd)
   do i1 = LB(1), UB(1)
      call MAP_PackDiscState(RF, InData%xd(i1)) 
   end do
   LB(1:1) = lbound(InData%z)
   UB(1:1) = ubound(InData%z)
   do i1 = LB(1), UB(1)
      call MAP_PackConstrState(RF, InData%z(i1)) 
   end do
   call MAP_PackOtherState(RF, InData%OtherSt) 
   call MAP_PackParam(RF, InData%p) 
   call MAP_PackInput(RF, InData%u) 
   call MAP_PackOutput(RF, InData%y) 
   call MAP_PackOtherState(RF, InData%OtherSt_old) 
   call RegPack(RF, allocated(InData%Output))
   if (allocated(InData%Output)) then
      call RegPackBounds(RF, 1, lbound(InData%Output), ubound(InData%Output))
      LB(1:1) = lbound(InData%Output)
      UB(1:1) = ubound(InData%Output)
      do i1 = LB(1), UB(1)
         call MAP_PackOutput(RF, InData%Output(i1)) 
      end do
   end if
   call MAP_PackOutput(RF, InData%y_interp) 
   call RegPack(RF, allocated(InData%Input))
   if (allocated(InData%Input)) then
      call RegPackBounds(RF, 1, lbound(InData%Input), ubound(InData%Input))
      LB(1:1) = lbound(InData%Input)
      UB(1:1) = ubound(InData%Input)
      do i1 = LB(1), UB(1)
         call MAP_PackInput(RF, InData%Input(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%Input_Saved))
   if (allocated(InData%Input_Saved)) then
      call RegPackBounds(RF, 1, lbound(InData%Input_Saved), ubound(InData%Input_Saved))
      LB(1:1) = lbound(InData%Input_Saved)
      UB(1:1) = ubound(InData%Input_Saved)
      do i1 = LB(1), UB(1)
         call MAP_PackInput(RF, InData%Input_Saved(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%InputTimes)
   call RegPackAlloc(RF, InData%InputTimes_Saved)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_UnPackMAP_Data(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(MAP_Data), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FAST_UnPackMAP_Data'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   LB(1:1) = lbound(OutData%x)
   UB(1:1) = ubound(OutData%x)
   do i1 = LB(1), UB(1)
      call MAP_UnpackContState(RF, OutData%x(i1)) ! x 
   end do
   LB(1:1) = lbound(OutData%xd)
   UB(1:1) = ubound(OutData%xd)
   do i1 = LB(1), UB(1)
      call MAP_UnpackDiscState(RF, OutData%xd(i1)) ! xd 
   end do
   LB(1:1) = lbound(OutData%z)
   UB(1:1) = ubound(OutData%z)
   do i1 = LB(1), UB(1)
      call MAP_UnpackConstrState(RF, OutData%z(i1)) ! z 
   end do
   call MAP_UnpackOtherState(RF, OutData%OtherSt) ! OtherSt 
   call MAP_UnpackParam(RF, OutData%p) ! p 
   call MAP_UnpackInput(RF, OutData%u) ! u 
   call MAP_UnpackOutput(RF, OutData%y) ! y 
   call MAP_UnpackOtherState(RF, OutData%OtherSt_old) ! OtherSt_old 
   if (allocated(OutData%Output)) deallocate(OutData%Output)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Output(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Output.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MAP_UnpackOutput(RF, OutData%Output(i1)) ! Output 
      end do
   end if
   call MAP_UnpackOutput(RF, OutData%y_interp) ! y_interp 
   if (allocated(OutData%Input)) deallocate(OutData%Input)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Input(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Input.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MAP_UnpackInput(RF, OutData%Input(i1)) ! Input 
      end do
   end if
   if (allocated(OutData%Input_Saved)) deallocate(OutData%Input_Saved)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Input_Saved(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Input_Saved.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MAP_UnpackInput(RF, OutData%Input_Saved(i1)) ! Input_Saved 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%InputTimes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%InputTimes_Saved); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_CopyFEAMooring_Data(SrcFEAMooring_DataData, DstFEAMooring_DataData, CtrlCode, ErrStat, ErrMsg)
   type(FEAMooring_Data), intent(inout) :: SrcFEAMooring_DataData
   type(FEAMooring_Data), intent(inout) :: DstFEAMooring_DataData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_CopyFEAMooring_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   LB(1:1) = lbound(SrcFEAMooring_DataData%x)
   UB(1:1) = ubound(SrcFEAMooring_DataData%x)
   do i1 = LB(1), UB(1)
      call FEAM_CopyContState(SrcFEAMooring_DataData%x(i1), DstFEAMooring_DataData%x(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcFEAMooring_DataData%xd)
   UB(1:1) = ubound(SrcFEAMooring_DataData%xd)
   do i1 = LB(1), UB(1)
      call FEAM_CopyDiscState(SrcFEAMooring_DataData%xd(i1), DstFEAMooring_DataData%xd(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcFEAMooring_DataData%z)
   UB(1:1) = ubound(SrcFEAMooring_DataData%z)
   do i1 = LB(1), UB(1)
      call FEAM_CopyConstrState(SrcFEAMooring_DataData%z(i1), DstFEAMooring_DataData%z(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcFEAMooring_DataData%OtherSt)
   UB(1:1) = ubound(SrcFEAMooring_DataData%OtherSt)
   do i1 = LB(1), UB(1)
      call FEAM_CopyOtherState(SrcFEAMooring_DataData%OtherSt(i1), DstFEAMooring_DataData%OtherSt(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   call FEAM_CopyParam(SrcFEAMooring_DataData%p, DstFEAMooring_DataData%p, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call FEAM_CopyInput(SrcFEAMooring_DataData%u, DstFEAMooring_DataData%u, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call FEAM_CopyOutput(SrcFEAMooring_DataData%y, DstFEAMooring_DataData%y, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call FEAM_CopyMisc(SrcFEAMooring_DataData%m, DstFEAMooring_DataData%m, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcFEAMooring_DataData%Input)) then
      LB(1:1) = lbound(SrcFEAMooring_DataData%Input)
      UB(1:1) = ubound(SrcFEAMooring_DataData%Input)
      if (.not. allocated(DstFEAMooring_DataData%Input)) then
         allocate(DstFEAMooring_DataData%Input(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstFEAMooring_DataData%Input.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call FEAM_CopyInput(SrcFEAMooring_DataData%Input(i1), DstFEAMooring_DataData%Input(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcFEAMooring_DataData%Input_Saved)) then
      LB(1:1) = lbound(SrcFEAMooring_DataData%Input_Saved)
      UB(1:1) = ubound(SrcFEAMooring_DataData%Input_Saved)
      if (.not. allocated(DstFEAMooring_DataData%Input_Saved)) then
         allocate(DstFEAMooring_DataData%Input_Saved(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstFEAMooring_DataData%Input_Saved.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call FEAM_CopyInput(SrcFEAMooring_DataData%Input_Saved(i1), DstFEAMooring_DataData%Input_Saved(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcFEAMooring_DataData%InputTimes)) then
      LB(1:1) = lbound(SrcFEAMooring_DataData%InputTimes)
      UB(1:1) = ubound(SrcFEAMooring_DataData%InputTimes)
      if (.not. allocated(DstFEAMooring_DataData%InputTimes)) then
         allocate(DstFEAMooring_DataData%InputTimes(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstFEAMooring_DataData%InputTimes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstFEAMooring_DataData%InputTimes = SrcFEAMooring_DataData%InputTimes
   end if
   if (allocated(SrcFEAMooring_DataData%InputTimes_Saved)) then
      LB(1:1) = lbound(SrcFEAMooring_DataData%InputTimes_Saved)
      UB(1:1) = ubound(SrcFEAMooring_DataData%InputTimes_Saved)
      if (.not. allocated(DstFEAMooring_DataData%InputTimes_Saved)) then
         allocate(DstFEAMooring_DataData%InputTimes_Saved(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstFEAMooring_DataData%InputTimes_Saved.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstFEAMooring_DataData%InputTimes_Saved = SrcFEAMooring_DataData%InputTimes_Saved
   end if
end subroutine

subroutine FAST_DestroyFEAMooring_Data(FEAMooring_DataData, ErrStat, ErrMsg)
   type(FEAMooring_Data), intent(inout) :: FEAMooring_DataData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_DestroyFEAMooring_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   LB(1:1) = lbound(FEAMooring_DataData%x)
   UB(1:1) = ubound(FEAMooring_DataData%x)
   do i1 = LB(1), UB(1)
      call FEAM_DestroyContState(FEAMooring_DataData%x(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(FEAMooring_DataData%xd)
   UB(1:1) = ubound(FEAMooring_DataData%xd)
   do i1 = LB(1), UB(1)
      call FEAM_DestroyDiscState(FEAMooring_DataData%xd(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(FEAMooring_DataData%z)
   UB(1:1) = ubound(FEAMooring_DataData%z)
   do i1 = LB(1), UB(1)
      call FEAM_DestroyConstrState(FEAMooring_DataData%z(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(FEAMooring_DataData%OtherSt)
   UB(1:1) = ubound(FEAMooring_DataData%OtherSt)
   do i1 = LB(1), UB(1)
      call FEAM_DestroyOtherState(FEAMooring_DataData%OtherSt(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   call FEAM_DestroyParam(FEAMooring_DataData%p, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FEAM_DestroyInput(FEAMooring_DataData%u, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FEAM_DestroyOutput(FEAMooring_DataData%y, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FEAM_DestroyMisc(FEAMooring_DataData%m, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(FEAMooring_DataData%Input)) then
      LB(1:1) = lbound(FEAMooring_DataData%Input)
      UB(1:1) = ubound(FEAMooring_DataData%Input)
      do i1 = LB(1), UB(1)
         call FEAM_DestroyInput(FEAMooring_DataData%Input(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(FEAMooring_DataData%Input)
   end if
   if (allocated(FEAMooring_DataData%Input_Saved)) then
      LB(1:1) = lbound(FEAMooring_DataData%Input_Saved)
      UB(1:1) = ubound(FEAMooring_DataData%Input_Saved)
      do i1 = LB(1), UB(1)
         call FEAM_DestroyInput(FEAMooring_DataData%Input_Saved(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(FEAMooring_DataData%Input_Saved)
   end if
   if (allocated(FEAMooring_DataData%InputTimes)) then
      deallocate(FEAMooring_DataData%InputTimes)
   end if
   if (allocated(FEAMooring_DataData%InputTimes_Saved)) then
      deallocate(FEAMooring_DataData%InputTimes_Saved)
   end if
end subroutine

subroutine FAST_PackFEAMooring_Data(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FEAMooring_Data), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FAST_PackFEAMooring_Data'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   LB(1:1) = lbound(InData%x)
   UB(1:1) = ubound(InData%x)
   do i1 = LB(1), UB(1)
      call FEAM_PackContState(RF, InData%x(i1)) 
   end do
   LB(1:1) = lbound(InData%xd)
   UB(1:1) = ubound(InData%xd)
   do i1 = LB(1), UB(1)
      call FEAM_PackDiscState(RF, InData%xd(i1)) 
   end do
   LB(1:1) = lbound(InData%z)
   UB(1:1) = ubound(InData%z)
   do i1 = LB(1), UB(1)
      call FEAM_PackConstrState(RF, InData%z(i1)) 
   end do
   LB(1:1) = lbound(InData%OtherSt)
   UB(1:1) = ubound(InData%OtherSt)
   do i1 = LB(1), UB(1)
      call FEAM_PackOtherState(RF, InData%OtherSt(i1)) 
   end do
   call FEAM_PackParam(RF, InData%p) 
   call FEAM_PackInput(RF, InData%u) 
   call FEAM_PackOutput(RF, InData%y) 
   call FEAM_PackMisc(RF, InData%m) 
   call RegPack(RF, allocated(InData%Input))
   if (allocated(InData%Input)) then
      call RegPackBounds(RF, 1, lbound(InData%Input), ubound(InData%Input))
      LB(1:1) = lbound(InData%Input)
      UB(1:1) = ubound(InData%Input)
      do i1 = LB(1), UB(1)
         call FEAM_PackInput(RF, InData%Input(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%Input_Saved))
   if (allocated(InData%Input_Saved)) then
      call RegPackBounds(RF, 1, lbound(InData%Input_Saved), ubound(InData%Input_Saved))
      LB(1:1) = lbound(InData%Input_Saved)
      UB(1:1) = ubound(InData%Input_Saved)
      do i1 = LB(1), UB(1)
         call FEAM_PackInput(RF, InData%Input_Saved(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%InputTimes)
   call RegPackAlloc(RF, InData%InputTimes_Saved)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_UnPackFEAMooring_Data(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FEAMooring_Data), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FAST_UnPackFEAMooring_Data'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   LB(1:1) = lbound(OutData%x)
   UB(1:1) = ubound(OutData%x)
   do i1 = LB(1), UB(1)
      call FEAM_UnpackContState(RF, OutData%x(i1)) ! x 
   end do
   LB(1:1) = lbound(OutData%xd)
   UB(1:1) = ubound(OutData%xd)
   do i1 = LB(1), UB(1)
      call FEAM_UnpackDiscState(RF, OutData%xd(i1)) ! xd 
   end do
   LB(1:1) = lbound(OutData%z)
   UB(1:1) = ubound(OutData%z)
   do i1 = LB(1), UB(1)
      call FEAM_UnpackConstrState(RF, OutData%z(i1)) ! z 
   end do
   LB(1:1) = lbound(OutData%OtherSt)
   UB(1:1) = ubound(OutData%OtherSt)
   do i1 = LB(1), UB(1)
      call FEAM_UnpackOtherState(RF, OutData%OtherSt(i1)) ! OtherSt 
   end do
   call FEAM_UnpackParam(RF, OutData%p) ! p 
   call FEAM_UnpackInput(RF, OutData%u) ! u 
   call FEAM_UnpackOutput(RF, OutData%y) ! y 
   call FEAM_UnpackMisc(RF, OutData%m) ! m 
   if (allocated(OutData%Input)) deallocate(OutData%Input)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Input(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Input.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call FEAM_UnpackInput(RF, OutData%Input(i1)) ! Input 
      end do
   end if
   if (allocated(OutData%Input_Saved)) deallocate(OutData%Input_Saved)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Input_Saved(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Input_Saved.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call FEAM_UnpackInput(RF, OutData%Input_Saved(i1)) ! Input_Saved 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%InputTimes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%InputTimes_Saved); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_CopyMoorDyn_Data(SrcMoorDyn_DataData, DstMoorDyn_DataData, CtrlCode, ErrStat, ErrMsg)
   type(MoorDyn_Data), intent(inout) :: SrcMoorDyn_DataData
   type(MoorDyn_Data), intent(inout) :: DstMoorDyn_DataData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_CopyMoorDyn_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   LB(1:1) = lbound(SrcMoorDyn_DataData%x)
   UB(1:1) = ubound(SrcMoorDyn_DataData%x)
   do i1 = LB(1), UB(1)
      call MD_CopyContState(SrcMoorDyn_DataData%x(i1), DstMoorDyn_DataData%x(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcMoorDyn_DataData%xd)
   UB(1:1) = ubound(SrcMoorDyn_DataData%xd)
   do i1 = LB(1), UB(1)
      call MD_CopyDiscState(SrcMoorDyn_DataData%xd(i1), DstMoorDyn_DataData%xd(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcMoorDyn_DataData%z)
   UB(1:1) = ubound(SrcMoorDyn_DataData%z)
   do i1 = LB(1), UB(1)
      call MD_CopyConstrState(SrcMoorDyn_DataData%z(i1), DstMoorDyn_DataData%z(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcMoorDyn_DataData%OtherSt)
   UB(1:1) = ubound(SrcMoorDyn_DataData%OtherSt)
   do i1 = LB(1), UB(1)
      call MD_CopyOtherState(SrcMoorDyn_DataData%OtherSt(i1), DstMoorDyn_DataData%OtherSt(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   call MD_CopyParam(SrcMoorDyn_DataData%p, DstMoorDyn_DataData%p, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MD_CopyInput(SrcMoorDyn_DataData%u, DstMoorDyn_DataData%u, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MD_CopyOutput(SrcMoorDyn_DataData%y, DstMoorDyn_DataData%y, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MD_CopyMisc(SrcMoorDyn_DataData%m, DstMoorDyn_DataData%m, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcMoorDyn_DataData%Output)) then
      LB(1:1) = lbound(SrcMoorDyn_DataData%Output)
      UB(1:1) = ubound(SrcMoorDyn_DataData%Output)
      if (.not. allocated(DstMoorDyn_DataData%Output)) then
         allocate(DstMoorDyn_DataData%Output(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMoorDyn_DataData%Output.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MD_CopyOutput(SrcMoorDyn_DataData%Output(i1), DstMoorDyn_DataData%Output(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call MD_CopyOutput(SrcMoorDyn_DataData%y_interp, DstMoorDyn_DataData%y_interp, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcMoorDyn_DataData%Input)) then
      LB(1:1) = lbound(SrcMoorDyn_DataData%Input)
      UB(1:1) = ubound(SrcMoorDyn_DataData%Input)
      if (.not. allocated(DstMoorDyn_DataData%Input)) then
         allocate(DstMoorDyn_DataData%Input(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMoorDyn_DataData%Input.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MD_CopyInput(SrcMoorDyn_DataData%Input(i1), DstMoorDyn_DataData%Input(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcMoorDyn_DataData%Input_Saved)) then
      LB(1:1) = lbound(SrcMoorDyn_DataData%Input_Saved)
      UB(1:1) = ubound(SrcMoorDyn_DataData%Input_Saved)
      if (.not. allocated(DstMoorDyn_DataData%Input_Saved)) then
         allocate(DstMoorDyn_DataData%Input_Saved(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMoorDyn_DataData%Input_Saved.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MD_CopyInput(SrcMoorDyn_DataData%Input_Saved(i1), DstMoorDyn_DataData%Input_Saved(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcMoorDyn_DataData%InputTimes)) then
      LB(1:1) = lbound(SrcMoorDyn_DataData%InputTimes)
      UB(1:1) = ubound(SrcMoorDyn_DataData%InputTimes)
      if (.not. allocated(DstMoorDyn_DataData%InputTimes)) then
         allocate(DstMoorDyn_DataData%InputTimes(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMoorDyn_DataData%InputTimes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMoorDyn_DataData%InputTimes = SrcMoorDyn_DataData%InputTimes
   end if
   if (allocated(SrcMoorDyn_DataData%InputTimes_Saved)) then
      LB(1:1) = lbound(SrcMoorDyn_DataData%InputTimes_Saved)
      UB(1:1) = ubound(SrcMoorDyn_DataData%InputTimes_Saved)
      if (.not. allocated(DstMoorDyn_DataData%InputTimes_Saved)) then
         allocate(DstMoorDyn_DataData%InputTimes_Saved(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMoorDyn_DataData%InputTimes_Saved.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMoorDyn_DataData%InputTimes_Saved = SrcMoorDyn_DataData%InputTimes_Saved
   end if
end subroutine

subroutine FAST_DestroyMoorDyn_Data(MoorDyn_DataData, ErrStat, ErrMsg)
   type(MoorDyn_Data), intent(inout) :: MoorDyn_DataData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_DestroyMoorDyn_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   LB(1:1) = lbound(MoorDyn_DataData%x)
   UB(1:1) = ubound(MoorDyn_DataData%x)
   do i1 = LB(1), UB(1)
      call MD_DestroyContState(MoorDyn_DataData%x(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(MoorDyn_DataData%xd)
   UB(1:1) = ubound(MoorDyn_DataData%xd)
   do i1 = LB(1), UB(1)
      call MD_DestroyDiscState(MoorDyn_DataData%xd(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(MoorDyn_DataData%z)
   UB(1:1) = ubound(MoorDyn_DataData%z)
   do i1 = LB(1), UB(1)
      call MD_DestroyConstrState(MoorDyn_DataData%z(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(MoorDyn_DataData%OtherSt)
   UB(1:1) = ubound(MoorDyn_DataData%OtherSt)
   do i1 = LB(1), UB(1)
      call MD_DestroyOtherState(MoorDyn_DataData%OtherSt(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   call MD_DestroyParam(MoorDyn_DataData%p, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MD_DestroyInput(MoorDyn_DataData%u, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MD_DestroyOutput(MoorDyn_DataData%y, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MD_DestroyMisc(MoorDyn_DataData%m, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(MoorDyn_DataData%Output)) then
      LB(1:1) = lbound(MoorDyn_DataData%Output)
      UB(1:1) = ubound(MoorDyn_DataData%Output)
      do i1 = LB(1), UB(1)
         call MD_DestroyOutput(MoorDyn_DataData%Output(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MoorDyn_DataData%Output)
   end if
   call MD_DestroyOutput(MoorDyn_DataData%y_interp, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(MoorDyn_DataData%Input)) then
      LB(1:1) = lbound(MoorDyn_DataData%Input)
      UB(1:1) = ubound(MoorDyn_DataData%Input)
      do i1 = LB(1), UB(1)
         call MD_DestroyInput(MoorDyn_DataData%Input(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MoorDyn_DataData%Input)
   end if
   if (allocated(MoorDyn_DataData%Input_Saved)) then
      LB(1:1) = lbound(MoorDyn_DataData%Input_Saved)
      UB(1:1) = ubound(MoorDyn_DataData%Input_Saved)
      do i1 = LB(1), UB(1)
         call MD_DestroyInput(MoorDyn_DataData%Input_Saved(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MoorDyn_DataData%Input_Saved)
   end if
   if (allocated(MoorDyn_DataData%InputTimes)) then
      deallocate(MoorDyn_DataData%InputTimes)
   end if
   if (allocated(MoorDyn_DataData%InputTimes_Saved)) then
      deallocate(MoorDyn_DataData%InputTimes_Saved)
   end if
end subroutine

subroutine FAST_PackMoorDyn_Data(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(MoorDyn_Data), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FAST_PackMoorDyn_Data'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   LB(1:1) = lbound(InData%x)
   UB(1:1) = ubound(InData%x)
   do i1 = LB(1), UB(1)
      call MD_PackContState(RF, InData%x(i1)) 
   end do
   LB(1:1) = lbound(InData%xd)
   UB(1:1) = ubound(InData%xd)
   do i1 = LB(1), UB(1)
      call MD_PackDiscState(RF, InData%xd(i1)) 
   end do
   LB(1:1) = lbound(InData%z)
   UB(1:1) = ubound(InData%z)
   do i1 = LB(1), UB(1)
      call MD_PackConstrState(RF, InData%z(i1)) 
   end do
   LB(1:1) = lbound(InData%OtherSt)
   UB(1:1) = ubound(InData%OtherSt)
   do i1 = LB(1), UB(1)
      call MD_PackOtherState(RF, InData%OtherSt(i1)) 
   end do
   call MD_PackParam(RF, InData%p) 
   call MD_PackInput(RF, InData%u) 
   call MD_PackOutput(RF, InData%y) 
   call MD_PackMisc(RF, InData%m) 
   call RegPack(RF, allocated(InData%Output))
   if (allocated(InData%Output)) then
      call RegPackBounds(RF, 1, lbound(InData%Output), ubound(InData%Output))
      LB(1:1) = lbound(InData%Output)
      UB(1:1) = ubound(InData%Output)
      do i1 = LB(1), UB(1)
         call MD_PackOutput(RF, InData%Output(i1)) 
      end do
   end if
   call MD_PackOutput(RF, InData%y_interp) 
   call RegPack(RF, allocated(InData%Input))
   if (allocated(InData%Input)) then
      call RegPackBounds(RF, 1, lbound(InData%Input), ubound(InData%Input))
      LB(1:1) = lbound(InData%Input)
      UB(1:1) = ubound(InData%Input)
      do i1 = LB(1), UB(1)
         call MD_PackInput(RF, InData%Input(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%Input_Saved))
   if (allocated(InData%Input_Saved)) then
      call RegPackBounds(RF, 1, lbound(InData%Input_Saved), ubound(InData%Input_Saved))
      LB(1:1) = lbound(InData%Input_Saved)
      UB(1:1) = ubound(InData%Input_Saved)
      do i1 = LB(1), UB(1)
         call MD_PackInput(RF, InData%Input_Saved(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%InputTimes)
   call RegPackAlloc(RF, InData%InputTimes_Saved)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_UnPackMoorDyn_Data(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(MoorDyn_Data), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FAST_UnPackMoorDyn_Data'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   LB(1:1) = lbound(OutData%x)
   UB(1:1) = ubound(OutData%x)
   do i1 = LB(1), UB(1)
      call MD_UnpackContState(RF, OutData%x(i1)) ! x 
   end do
   LB(1:1) = lbound(OutData%xd)
   UB(1:1) = ubound(OutData%xd)
   do i1 = LB(1), UB(1)
      call MD_UnpackDiscState(RF, OutData%xd(i1)) ! xd 
   end do
   LB(1:1) = lbound(OutData%z)
   UB(1:1) = ubound(OutData%z)
   do i1 = LB(1), UB(1)
      call MD_UnpackConstrState(RF, OutData%z(i1)) ! z 
   end do
   LB(1:1) = lbound(OutData%OtherSt)
   UB(1:1) = ubound(OutData%OtherSt)
   do i1 = LB(1), UB(1)
      call MD_UnpackOtherState(RF, OutData%OtherSt(i1)) ! OtherSt 
   end do
   call MD_UnpackParam(RF, OutData%p) ! p 
   call MD_UnpackInput(RF, OutData%u) ! u 
   call MD_UnpackOutput(RF, OutData%y) ! y 
   call MD_UnpackMisc(RF, OutData%m) ! m 
   if (allocated(OutData%Output)) deallocate(OutData%Output)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Output(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Output.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MD_UnpackOutput(RF, OutData%Output(i1)) ! Output 
      end do
   end if
   call MD_UnpackOutput(RF, OutData%y_interp) ! y_interp 
   if (allocated(OutData%Input)) deallocate(OutData%Input)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Input(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Input.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MD_UnpackInput(RF, OutData%Input(i1)) ! Input 
      end do
   end if
   if (allocated(OutData%Input_Saved)) deallocate(OutData%Input_Saved)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Input_Saved(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Input_Saved.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MD_UnpackInput(RF, OutData%Input_Saved(i1)) ! Input_Saved 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%InputTimes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%InputTimes_Saved); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_CopyOrcaFlex_Data(SrcOrcaFlex_DataData, DstOrcaFlex_DataData, CtrlCode, ErrStat, ErrMsg)
   type(OrcaFlex_Data), intent(inout) :: SrcOrcaFlex_DataData
   type(OrcaFlex_Data), intent(inout) :: DstOrcaFlex_DataData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_CopyOrcaFlex_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   LB(1:1) = lbound(SrcOrcaFlex_DataData%x)
   UB(1:1) = ubound(SrcOrcaFlex_DataData%x)
   do i1 = LB(1), UB(1)
      call Orca_CopyContState(SrcOrcaFlex_DataData%x(i1), DstOrcaFlex_DataData%x(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcOrcaFlex_DataData%xd)
   UB(1:1) = ubound(SrcOrcaFlex_DataData%xd)
   do i1 = LB(1), UB(1)
      call Orca_CopyDiscState(SrcOrcaFlex_DataData%xd(i1), DstOrcaFlex_DataData%xd(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcOrcaFlex_DataData%z)
   UB(1:1) = ubound(SrcOrcaFlex_DataData%z)
   do i1 = LB(1), UB(1)
      call Orca_CopyConstrState(SrcOrcaFlex_DataData%z(i1), DstOrcaFlex_DataData%z(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcOrcaFlex_DataData%OtherSt)
   UB(1:1) = ubound(SrcOrcaFlex_DataData%OtherSt)
   do i1 = LB(1), UB(1)
      call Orca_CopyOtherState(SrcOrcaFlex_DataData%OtherSt(i1), DstOrcaFlex_DataData%OtherSt(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   call Orca_CopyParam(SrcOrcaFlex_DataData%p, DstOrcaFlex_DataData%p, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call Orca_CopyInput(SrcOrcaFlex_DataData%u, DstOrcaFlex_DataData%u, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call Orca_CopyOutput(SrcOrcaFlex_DataData%y, DstOrcaFlex_DataData%y, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call Orca_CopyMisc(SrcOrcaFlex_DataData%m, DstOrcaFlex_DataData%m, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcOrcaFlex_DataData%Input)) then
      LB(1:1) = lbound(SrcOrcaFlex_DataData%Input)
      UB(1:1) = ubound(SrcOrcaFlex_DataData%Input)
      if (.not. allocated(DstOrcaFlex_DataData%Input)) then
         allocate(DstOrcaFlex_DataData%Input(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOrcaFlex_DataData%Input.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call Orca_CopyInput(SrcOrcaFlex_DataData%Input(i1), DstOrcaFlex_DataData%Input(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcOrcaFlex_DataData%Input_Saved)) then
      LB(1:1) = lbound(SrcOrcaFlex_DataData%Input_Saved)
      UB(1:1) = ubound(SrcOrcaFlex_DataData%Input_Saved)
      if (.not. allocated(DstOrcaFlex_DataData%Input_Saved)) then
         allocate(DstOrcaFlex_DataData%Input_Saved(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOrcaFlex_DataData%Input_Saved.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call Orca_CopyInput(SrcOrcaFlex_DataData%Input_Saved(i1), DstOrcaFlex_DataData%Input_Saved(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcOrcaFlex_DataData%InputTimes)) then
      LB(1:1) = lbound(SrcOrcaFlex_DataData%InputTimes)
      UB(1:1) = ubound(SrcOrcaFlex_DataData%InputTimes)
      if (.not. allocated(DstOrcaFlex_DataData%InputTimes)) then
         allocate(DstOrcaFlex_DataData%InputTimes(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOrcaFlex_DataData%InputTimes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOrcaFlex_DataData%InputTimes = SrcOrcaFlex_DataData%InputTimes
   end if
   if (allocated(SrcOrcaFlex_DataData%InputTimes_Saved)) then
      LB(1:1) = lbound(SrcOrcaFlex_DataData%InputTimes_Saved)
      UB(1:1) = ubound(SrcOrcaFlex_DataData%InputTimes_Saved)
      if (.not. allocated(DstOrcaFlex_DataData%InputTimes_Saved)) then
         allocate(DstOrcaFlex_DataData%InputTimes_Saved(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOrcaFlex_DataData%InputTimes_Saved.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOrcaFlex_DataData%InputTimes_Saved = SrcOrcaFlex_DataData%InputTimes_Saved
   end if
end subroutine

subroutine FAST_DestroyOrcaFlex_Data(OrcaFlex_DataData, ErrStat, ErrMsg)
   type(OrcaFlex_Data), intent(inout) :: OrcaFlex_DataData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_DestroyOrcaFlex_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   LB(1:1) = lbound(OrcaFlex_DataData%x)
   UB(1:1) = ubound(OrcaFlex_DataData%x)
   do i1 = LB(1), UB(1)
      call Orca_DestroyContState(OrcaFlex_DataData%x(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(OrcaFlex_DataData%xd)
   UB(1:1) = ubound(OrcaFlex_DataData%xd)
   do i1 = LB(1), UB(1)
      call Orca_DestroyDiscState(OrcaFlex_DataData%xd(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(OrcaFlex_DataData%z)
   UB(1:1) = ubound(OrcaFlex_DataData%z)
   do i1 = LB(1), UB(1)
      call Orca_DestroyConstrState(OrcaFlex_DataData%z(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(OrcaFlex_DataData%OtherSt)
   UB(1:1) = ubound(OrcaFlex_DataData%OtherSt)
   do i1 = LB(1), UB(1)
      call Orca_DestroyOtherState(OrcaFlex_DataData%OtherSt(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   call Orca_DestroyParam(OrcaFlex_DataData%p, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call Orca_DestroyInput(OrcaFlex_DataData%u, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call Orca_DestroyOutput(OrcaFlex_DataData%y, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call Orca_DestroyMisc(OrcaFlex_DataData%m, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(OrcaFlex_DataData%Input)) then
      LB(1:1) = lbound(OrcaFlex_DataData%Input)
      UB(1:1) = ubound(OrcaFlex_DataData%Input)
      do i1 = LB(1), UB(1)
         call Orca_DestroyInput(OrcaFlex_DataData%Input(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(OrcaFlex_DataData%Input)
   end if
   if (allocated(OrcaFlex_DataData%Input_Saved)) then
      LB(1:1) = lbound(OrcaFlex_DataData%Input_Saved)
      UB(1:1) = ubound(OrcaFlex_DataData%Input_Saved)
      do i1 = LB(1), UB(1)
         call Orca_DestroyInput(OrcaFlex_DataData%Input_Saved(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(OrcaFlex_DataData%Input_Saved)
   end if
   if (allocated(OrcaFlex_DataData%InputTimes)) then
      deallocate(OrcaFlex_DataData%InputTimes)
   end if
   if (allocated(OrcaFlex_DataData%InputTimes_Saved)) then
      deallocate(OrcaFlex_DataData%InputTimes_Saved)
   end if
end subroutine

subroutine FAST_PackOrcaFlex_Data(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(OrcaFlex_Data), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FAST_PackOrcaFlex_Data'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   LB(1:1) = lbound(InData%x)
   UB(1:1) = ubound(InData%x)
   do i1 = LB(1), UB(1)
      call Orca_PackContState(RF, InData%x(i1)) 
   end do
   LB(1:1) = lbound(InData%xd)
   UB(1:1) = ubound(InData%xd)
   do i1 = LB(1), UB(1)
      call Orca_PackDiscState(RF, InData%xd(i1)) 
   end do
   LB(1:1) = lbound(InData%z)
   UB(1:1) = ubound(InData%z)
   do i1 = LB(1), UB(1)
      call Orca_PackConstrState(RF, InData%z(i1)) 
   end do
   LB(1:1) = lbound(InData%OtherSt)
   UB(1:1) = ubound(InData%OtherSt)
   do i1 = LB(1), UB(1)
      call Orca_PackOtherState(RF, InData%OtherSt(i1)) 
   end do
   call Orca_PackParam(RF, InData%p) 
   call Orca_PackInput(RF, InData%u) 
   call Orca_PackOutput(RF, InData%y) 
   call Orca_PackMisc(RF, InData%m) 
   call RegPack(RF, allocated(InData%Input))
   if (allocated(InData%Input)) then
      call RegPackBounds(RF, 1, lbound(InData%Input), ubound(InData%Input))
      LB(1:1) = lbound(InData%Input)
      UB(1:1) = ubound(InData%Input)
      do i1 = LB(1), UB(1)
         call Orca_PackInput(RF, InData%Input(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%Input_Saved))
   if (allocated(InData%Input_Saved)) then
      call RegPackBounds(RF, 1, lbound(InData%Input_Saved), ubound(InData%Input_Saved))
      LB(1:1) = lbound(InData%Input_Saved)
      UB(1:1) = ubound(InData%Input_Saved)
      do i1 = LB(1), UB(1)
         call Orca_PackInput(RF, InData%Input_Saved(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%InputTimes)
   call RegPackAlloc(RF, InData%InputTimes_Saved)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_UnPackOrcaFlex_Data(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(OrcaFlex_Data), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FAST_UnPackOrcaFlex_Data'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   LB(1:1) = lbound(OutData%x)
   UB(1:1) = ubound(OutData%x)
   do i1 = LB(1), UB(1)
      call Orca_UnpackContState(RF, OutData%x(i1)) ! x 
   end do
   LB(1:1) = lbound(OutData%xd)
   UB(1:1) = ubound(OutData%xd)
   do i1 = LB(1), UB(1)
      call Orca_UnpackDiscState(RF, OutData%xd(i1)) ! xd 
   end do
   LB(1:1) = lbound(OutData%z)
   UB(1:1) = ubound(OutData%z)
   do i1 = LB(1), UB(1)
      call Orca_UnpackConstrState(RF, OutData%z(i1)) ! z 
   end do
   LB(1:1) = lbound(OutData%OtherSt)
   UB(1:1) = ubound(OutData%OtherSt)
   do i1 = LB(1), UB(1)
      call Orca_UnpackOtherState(RF, OutData%OtherSt(i1)) ! OtherSt 
   end do
   call Orca_UnpackParam(RF, OutData%p) ! p 
   call Orca_UnpackInput(RF, OutData%u) ! u 
   call Orca_UnpackOutput(RF, OutData%y) ! y 
   call Orca_UnpackMisc(RF, OutData%m) ! m 
   if (allocated(OutData%Input)) deallocate(OutData%Input)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Input(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Input.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call Orca_UnpackInput(RF, OutData%Input(i1)) ! Input 
      end do
   end if
   if (allocated(OutData%Input_Saved)) deallocate(OutData%Input_Saved)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Input_Saved(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Input_Saved.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call Orca_UnpackInput(RF, OutData%Input_Saved(i1)) ! Input_Saved 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%InputTimes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%InputTimes_Saved); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_CopyModuleMapType(SrcModuleMapTypeData, DstModuleMapTypeData, CtrlCode, ErrStat, ErrMsg)
   type(FAST_ModuleMapType), intent(inout) :: SrcModuleMapTypeData
   type(FAST_ModuleMapType), intent(inout) :: DstModuleMapTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_CopyModuleMapType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcModuleMapTypeData%ED_P_2_BD_P)) then
      LB(1:1) = lbound(SrcModuleMapTypeData%ED_P_2_BD_P)
      UB(1:1) = ubound(SrcModuleMapTypeData%ED_P_2_BD_P)
      if (.not. allocated(DstModuleMapTypeData%ED_P_2_BD_P)) then
         allocate(DstModuleMapTypeData%ED_P_2_BD_P(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%ED_P_2_BD_P.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%ED_P_2_BD_P(i1), DstModuleMapTypeData%ED_P_2_BD_P(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcModuleMapTypeData%BD_P_2_ED_P)) then
      LB(1:1) = lbound(SrcModuleMapTypeData%BD_P_2_ED_P)
      UB(1:1) = ubound(SrcModuleMapTypeData%BD_P_2_ED_P)
      if (.not. allocated(DstModuleMapTypeData%BD_P_2_ED_P)) then
         allocate(DstModuleMapTypeData%BD_P_2_ED_P(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%BD_P_2_ED_P.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%BD_P_2_ED_P(i1), DstModuleMapTypeData%BD_P_2_ED_P(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcModuleMapTypeData%ED_P_2_BD_P_Hub)) then
      LB(1:1) = lbound(SrcModuleMapTypeData%ED_P_2_BD_P_Hub)
      UB(1:1) = ubound(SrcModuleMapTypeData%ED_P_2_BD_P_Hub)
      if (.not. allocated(DstModuleMapTypeData%ED_P_2_BD_P_Hub)) then
         allocate(DstModuleMapTypeData%ED_P_2_BD_P_Hub(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%ED_P_2_BD_P_Hub.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%ED_P_2_BD_P_Hub(i1), DstModuleMapTypeData%ED_P_2_BD_P_Hub(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%ED_P_2_HD_PRP_P, DstModuleMapTypeData%ED_P_2_HD_PRP_P, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%SubStructure_2_HD_W_P, DstModuleMapTypeData%SubStructure_2_HD_W_P, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%HD_W_P_2_SubStructure, DstModuleMapTypeData%HD_W_P_2_SubStructure, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%SubStructure_2_HD_M_P, DstModuleMapTypeData%SubStructure_2_HD_M_P, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%HD_M_P_2_SubStructure, DstModuleMapTypeData%HD_M_P_2_SubStructure, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%Structure_2_Mooring, DstModuleMapTypeData%Structure_2_Mooring, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%Mooring_2_Structure, DstModuleMapTypeData%Mooring_2_Structure, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%ED_P_2_SD_TP, DstModuleMapTypeData%ED_P_2_SD_TP, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%SD_TP_2_ED_P, DstModuleMapTypeData%SD_TP_2_ED_P, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcModuleMapTypeData%ED_P_2_NStC_P_N)) then
      LB(1:1) = lbound(SrcModuleMapTypeData%ED_P_2_NStC_P_N)
      UB(1:1) = ubound(SrcModuleMapTypeData%ED_P_2_NStC_P_N)
      if (.not. allocated(DstModuleMapTypeData%ED_P_2_NStC_P_N)) then
         allocate(DstModuleMapTypeData%ED_P_2_NStC_P_N(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%ED_P_2_NStC_P_N.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%ED_P_2_NStC_P_N(i1), DstModuleMapTypeData%ED_P_2_NStC_P_N(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcModuleMapTypeData%NStC_P_2_ED_P_N)) then
      LB(1:1) = lbound(SrcModuleMapTypeData%NStC_P_2_ED_P_N)
      UB(1:1) = ubound(SrcModuleMapTypeData%NStC_P_2_ED_P_N)
      if (.not. allocated(DstModuleMapTypeData%NStC_P_2_ED_P_N)) then
         allocate(DstModuleMapTypeData%NStC_P_2_ED_P_N(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%NStC_P_2_ED_P_N.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%NStC_P_2_ED_P_N(i1), DstModuleMapTypeData%NStC_P_2_ED_P_N(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcModuleMapTypeData%ED_L_2_TStC_P_T)) then
      LB(1:1) = lbound(SrcModuleMapTypeData%ED_L_2_TStC_P_T)
      UB(1:1) = ubound(SrcModuleMapTypeData%ED_L_2_TStC_P_T)
      if (.not. allocated(DstModuleMapTypeData%ED_L_2_TStC_P_T)) then
         allocate(DstModuleMapTypeData%ED_L_2_TStC_P_T(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%ED_L_2_TStC_P_T.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%ED_L_2_TStC_P_T(i1), DstModuleMapTypeData%ED_L_2_TStC_P_T(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcModuleMapTypeData%TStC_P_2_ED_P_T)) then
      LB(1:1) = lbound(SrcModuleMapTypeData%TStC_P_2_ED_P_T)
      UB(1:1) = ubound(SrcModuleMapTypeData%TStC_P_2_ED_P_T)
      if (.not. allocated(DstModuleMapTypeData%TStC_P_2_ED_P_T)) then
         allocate(DstModuleMapTypeData%TStC_P_2_ED_P_T(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%TStC_P_2_ED_P_T.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%TStC_P_2_ED_P_T(i1), DstModuleMapTypeData%TStC_P_2_ED_P_T(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcModuleMapTypeData%ED_L_2_BStC_P_B)) then
      LB(1:2) = lbound(SrcModuleMapTypeData%ED_L_2_BStC_P_B)
      UB(1:2) = ubound(SrcModuleMapTypeData%ED_L_2_BStC_P_B)
      if (.not. allocated(DstModuleMapTypeData%ED_L_2_BStC_P_B)) then
         allocate(DstModuleMapTypeData%ED_L_2_BStC_P_B(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%ED_L_2_BStC_P_B.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%ED_L_2_BStC_P_B(i1,i2), DstModuleMapTypeData%ED_L_2_BStC_P_B(i1,i2), CtrlCode, ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
            if (ErrStat >= AbortErrLev) return
         end do
      end do
   end if
   if (allocated(SrcModuleMapTypeData%BStC_P_2_ED_P_B)) then
      LB(1:2) = lbound(SrcModuleMapTypeData%BStC_P_2_ED_P_B)
      UB(1:2) = ubound(SrcModuleMapTypeData%BStC_P_2_ED_P_B)
      if (.not. allocated(DstModuleMapTypeData%BStC_P_2_ED_P_B)) then
         allocate(DstModuleMapTypeData%BStC_P_2_ED_P_B(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%BStC_P_2_ED_P_B.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%BStC_P_2_ED_P_B(i1,i2), DstModuleMapTypeData%BStC_P_2_ED_P_B(i1,i2), CtrlCode, ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
            if (ErrStat >= AbortErrLev) return
         end do
      end do
   end if
   if (allocated(SrcModuleMapTypeData%BD_L_2_BStC_P_B)) then
      LB(1:2) = lbound(SrcModuleMapTypeData%BD_L_2_BStC_P_B)
      UB(1:2) = ubound(SrcModuleMapTypeData%BD_L_2_BStC_P_B)
      if (.not. allocated(DstModuleMapTypeData%BD_L_2_BStC_P_B)) then
         allocate(DstModuleMapTypeData%BD_L_2_BStC_P_B(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%BD_L_2_BStC_P_B.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%BD_L_2_BStC_P_B(i1,i2), DstModuleMapTypeData%BD_L_2_BStC_P_B(i1,i2), CtrlCode, ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
            if (ErrStat >= AbortErrLev) return
         end do
      end do
   end if
   if (allocated(SrcModuleMapTypeData%BStC_P_2_BD_P_B)) then
      LB(1:2) = lbound(SrcModuleMapTypeData%BStC_P_2_BD_P_B)
      UB(1:2) = ubound(SrcModuleMapTypeData%BStC_P_2_BD_P_B)
      if (.not. allocated(DstModuleMapTypeData%BStC_P_2_BD_P_B)) then
         allocate(DstModuleMapTypeData%BStC_P_2_BD_P_B(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%BStC_P_2_BD_P_B.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%BStC_P_2_BD_P_B(i1,i2), DstModuleMapTypeData%BStC_P_2_BD_P_B(i1,i2), CtrlCode, ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
            if (ErrStat >= AbortErrLev) return
         end do
      end do
   end if
   if (allocated(SrcModuleMapTypeData%SStC_P_P_2_SubStructure)) then
      LB(1:1) = lbound(SrcModuleMapTypeData%SStC_P_P_2_SubStructure)
      UB(1:1) = ubound(SrcModuleMapTypeData%SStC_P_P_2_SubStructure)
      if (.not. allocated(DstModuleMapTypeData%SStC_P_P_2_SubStructure)) then
         allocate(DstModuleMapTypeData%SStC_P_P_2_SubStructure(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%SStC_P_P_2_SubStructure.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%SStC_P_P_2_SubStructure(i1), DstModuleMapTypeData%SStC_P_P_2_SubStructure(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcModuleMapTypeData%SubStructure_2_SStC_P_P)) then
      LB(1:1) = lbound(SrcModuleMapTypeData%SubStructure_2_SStC_P_P)
      UB(1:1) = ubound(SrcModuleMapTypeData%SubStructure_2_SStC_P_P)
      if (.not. allocated(DstModuleMapTypeData%SubStructure_2_SStC_P_P)) then
         allocate(DstModuleMapTypeData%SubStructure_2_SStC_P_P(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%SubStructure_2_SStC_P_P.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%SubStructure_2_SStC_P_P(i1), DstModuleMapTypeData%SubStructure_2_SStC_P_P(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%ED_P_2_SrvD_P_P, DstModuleMapTypeData%ED_P_2_SrvD_P_P, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcModuleMapTypeData%BDED_L_2_AD_L_B)) then
      LB(1:1) = lbound(SrcModuleMapTypeData%BDED_L_2_AD_L_B)
      UB(1:1) = ubound(SrcModuleMapTypeData%BDED_L_2_AD_L_B)
      if (.not. allocated(DstModuleMapTypeData%BDED_L_2_AD_L_B)) then
         allocate(DstModuleMapTypeData%BDED_L_2_AD_L_B(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%BDED_L_2_AD_L_B.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%BDED_L_2_AD_L_B(i1), DstModuleMapTypeData%BDED_L_2_AD_L_B(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcModuleMapTypeData%AD_L_2_BDED_B)) then
      LB(1:1) = lbound(SrcModuleMapTypeData%AD_L_2_BDED_B)
      UB(1:1) = ubound(SrcModuleMapTypeData%AD_L_2_BDED_B)
      if (.not. allocated(DstModuleMapTypeData%AD_L_2_BDED_B)) then
         allocate(DstModuleMapTypeData%AD_L_2_BDED_B(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%AD_L_2_BDED_B.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%AD_L_2_BDED_B(i1), DstModuleMapTypeData%AD_L_2_BDED_B(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcModuleMapTypeData%BD_L_2_BD_L)) then
      LB(1:1) = lbound(SrcModuleMapTypeData%BD_L_2_BD_L)
      UB(1:1) = ubound(SrcModuleMapTypeData%BD_L_2_BD_L)
      if (.not. allocated(DstModuleMapTypeData%BD_L_2_BD_L)) then
         allocate(DstModuleMapTypeData%BD_L_2_BD_L(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%BD_L_2_BD_L.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%BD_L_2_BD_L(i1), DstModuleMapTypeData%BD_L_2_BD_L(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcModuleMapTypeData%SED_P_2_AD_L_B)) then
      LB(1:1) = lbound(SrcModuleMapTypeData%SED_P_2_AD_L_B)
      UB(1:1) = ubound(SrcModuleMapTypeData%SED_P_2_AD_L_B)
      if (.not. allocated(DstModuleMapTypeData%SED_P_2_AD_L_B)) then
         allocate(DstModuleMapTypeData%SED_P_2_AD_L_B(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%SED_P_2_AD_L_B.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%SED_P_2_AD_L_B(i1), DstModuleMapTypeData%SED_P_2_AD_L_B(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcModuleMapTypeData%SED_P_2_AD_P_R)) then
      LB(1:1) = lbound(SrcModuleMapTypeData%SED_P_2_AD_P_R)
      UB(1:1) = ubound(SrcModuleMapTypeData%SED_P_2_AD_P_R)
      if (.not. allocated(DstModuleMapTypeData%SED_P_2_AD_P_R)) then
         allocate(DstModuleMapTypeData%SED_P_2_AD_P_R(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%SED_P_2_AD_P_R.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%SED_P_2_AD_P_R(i1), DstModuleMapTypeData%SED_P_2_AD_P_R(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcModuleMapTypeData%AD_L_2_SED_P)) then
      LB(1:1) = lbound(SrcModuleMapTypeData%AD_L_2_SED_P)
      UB(1:1) = ubound(SrcModuleMapTypeData%AD_L_2_SED_P)
      if (.not. allocated(DstModuleMapTypeData%AD_L_2_SED_P)) then
         allocate(DstModuleMapTypeData%AD_L_2_SED_P(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%AD_L_2_SED_P.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%AD_L_2_SED_P(i1), DstModuleMapTypeData%AD_L_2_SED_P(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%ED_P_2_AD_P_N, DstModuleMapTypeData%ED_P_2_AD_P_N, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%AD_P_2_ED_P_N, DstModuleMapTypeData%AD_P_2_ED_P_N, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%ED_P_2_AD_P_TF, DstModuleMapTypeData%ED_P_2_AD_P_TF, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%AD_P_2_ED_P_TF, DstModuleMapTypeData%AD_P_2_ED_P_TF, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%ED_L_2_AD_L_T, DstModuleMapTypeData%ED_L_2_AD_L_T, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%AD_L_2_ED_P_T, DstModuleMapTypeData%AD_L_2_ED_P_T, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcModuleMapTypeData%ED_P_2_AD_P_R)) then
      LB(1:1) = lbound(SrcModuleMapTypeData%ED_P_2_AD_P_R)
      UB(1:1) = ubound(SrcModuleMapTypeData%ED_P_2_AD_P_R)
      if (.not. allocated(DstModuleMapTypeData%ED_P_2_AD_P_R)) then
         allocate(DstModuleMapTypeData%ED_P_2_AD_P_R(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%ED_P_2_AD_P_R.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%ED_P_2_AD_P_R(i1), DstModuleMapTypeData%ED_P_2_AD_P_R(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%ED_P_2_AD_P_H, DstModuleMapTypeData%ED_P_2_AD_P_H, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%ADsk_P_2_ED_P_H, DstModuleMapTypeData%ADsk_P_2_ED_P_H, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%ED_P_2_ADsk_P_H, DstModuleMapTypeData%ED_P_2_ADsk_P_H, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%SED_P_2_AD_P_N, DstModuleMapTypeData%SED_P_2_AD_P_N, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%SED_L_2_AD_L_T, DstModuleMapTypeData%SED_L_2_AD_L_T, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%SED_P_2_AD_P_H, DstModuleMapTypeData%SED_P_2_AD_P_H, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%ADsk_P_2_SED_P_H, DstModuleMapTypeData%ADsk_P_2_SED_P_H, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%SED_P_2_ADsk_P_H, DstModuleMapTypeData%SED_P_2_ADsk_P_H, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%AD_P_2_ED_P_H, DstModuleMapTypeData%AD_P_2_ED_P_H, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcModuleMapTypeData%BDED_L_2_ExtLd_P_B)) then
      LB(1:1) = lbound(SrcModuleMapTypeData%BDED_L_2_ExtLd_P_B)
      UB(1:1) = ubound(SrcModuleMapTypeData%BDED_L_2_ExtLd_P_B)
      if (.not. allocated(DstModuleMapTypeData%BDED_L_2_ExtLd_P_B)) then
         allocate(DstModuleMapTypeData%BDED_L_2_ExtLd_P_B(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%BDED_L_2_ExtLd_P_B.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%BDED_L_2_ExtLd_P_B(i1), DstModuleMapTypeData%BDED_L_2_ExtLd_P_B(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcModuleMapTypeData%ExtLd_P_2_BDED_B)) then
      LB(1:1) = lbound(SrcModuleMapTypeData%ExtLd_P_2_BDED_B)
      UB(1:1) = ubound(SrcModuleMapTypeData%ExtLd_P_2_BDED_B)
      if (.not. allocated(DstModuleMapTypeData%ExtLd_P_2_BDED_B)) then
         allocate(DstModuleMapTypeData%ExtLd_P_2_BDED_B(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%ExtLd_P_2_BDED_B.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%ExtLd_P_2_BDED_B(i1), DstModuleMapTypeData%ExtLd_P_2_BDED_B(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%ED_L_2_ExtLd_P_T, DstModuleMapTypeData%ED_L_2_ExtLd_P_T, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%ExtLd_P_2_ED_P_T, DstModuleMapTypeData%ExtLd_P_2_ED_P_T, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcModuleMapTypeData%ED_P_2_ExtLd_P_R)) then
      LB(1:1) = lbound(SrcModuleMapTypeData%ED_P_2_ExtLd_P_R)
      UB(1:1) = ubound(SrcModuleMapTypeData%ED_P_2_ExtLd_P_R)
      if (.not. allocated(DstModuleMapTypeData%ED_P_2_ExtLd_P_R)) then
         allocate(DstModuleMapTypeData%ED_P_2_ExtLd_P_R(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%ED_P_2_ExtLd_P_R.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%ED_P_2_ExtLd_P_R(i1), DstModuleMapTypeData%ED_P_2_ExtLd_P_R(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%ED_P_2_ExtLd_P_H, DstModuleMapTypeData%ED_P_2_ExtLd_P_H, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcModuleMapTypeData%AD_L_2_ExtLd_B)) then
      LB(1:1) = lbound(SrcModuleMapTypeData%AD_L_2_ExtLd_B)
      UB(1:1) = ubound(SrcModuleMapTypeData%AD_L_2_ExtLd_B)
      if (.not. allocated(DstModuleMapTypeData%AD_L_2_ExtLd_B)) then
         allocate(DstModuleMapTypeData%AD_L_2_ExtLd_B(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%AD_L_2_ExtLd_B.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%AD_L_2_ExtLd_B(i1), DstModuleMapTypeData%AD_L_2_ExtLd_B(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%AD_L_2_ExtLd_T, DstModuleMapTypeData%AD_L_2_ExtLd_T, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%IceF_P_2_SD_P, DstModuleMapTypeData%IceF_P_2_SD_P, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%SDy3_P_2_IceF_P, DstModuleMapTypeData%SDy3_P_2_IceF_P, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcModuleMapTypeData%IceD_P_2_SD_P)) then
      LB(1:1) = lbound(SrcModuleMapTypeData%IceD_P_2_SD_P)
      UB(1:1) = ubound(SrcModuleMapTypeData%IceD_P_2_SD_P)
      if (.not. allocated(DstModuleMapTypeData%IceD_P_2_SD_P)) then
         allocate(DstModuleMapTypeData%IceD_P_2_SD_P(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%IceD_P_2_SD_P.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%IceD_P_2_SD_P(i1), DstModuleMapTypeData%IceD_P_2_SD_P(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcModuleMapTypeData%SDy3_P_2_IceD_P)) then
      LB(1:1) = lbound(SrcModuleMapTypeData%SDy3_P_2_IceD_P)
      UB(1:1) = ubound(SrcModuleMapTypeData%SDy3_P_2_IceD_P)
      if (.not. allocated(DstModuleMapTypeData%SDy3_P_2_IceD_P)) then
         allocate(DstModuleMapTypeData%SDy3_P_2_IceD_P(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%SDy3_P_2_IceD_P.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyMeshMapType(SrcModuleMapTypeData%SDy3_P_2_IceD_P(i1), DstModuleMapTypeData%SDy3_P_2_IceD_P(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcModuleMapTypeData%Jacobian_Opt1)) then
      LB(1:2) = lbound(SrcModuleMapTypeData%Jacobian_Opt1)
      UB(1:2) = ubound(SrcModuleMapTypeData%Jacobian_Opt1)
      if (.not. allocated(DstModuleMapTypeData%Jacobian_Opt1)) then
         allocate(DstModuleMapTypeData%Jacobian_Opt1(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%Jacobian_Opt1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstModuleMapTypeData%Jacobian_Opt1 = SrcModuleMapTypeData%Jacobian_Opt1
   end if
   if (allocated(SrcModuleMapTypeData%Jacobian_pivot)) then
      LB(1:1) = lbound(SrcModuleMapTypeData%Jacobian_pivot)
      UB(1:1) = ubound(SrcModuleMapTypeData%Jacobian_pivot)
      if (.not. allocated(DstModuleMapTypeData%Jacobian_pivot)) then
         allocate(DstModuleMapTypeData%Jacobian_pivot(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%Jacobian_pivot.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstModuleMapTypeData%Jacobian_pivot = SrcModuleMapTypeData%Jacobian_pivot
   end if
   if (allocated(SrcModuleMapTypeData%Jac_u_indx)) then
      LB(1:2) = lbound(SrcModuleMapTypeData%Jac_u_indx)
      UB(1:2) = ubound(SrcModuleMapTypeData%Jac_u_indx)
      if (.not. allocated(DstModuleMapTypeData%Jac_u_indx)) then
         allocate(DstModuleMapTypeData%Jac_u_indx(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%Jac_u_indx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstModuleMapTypeData%Jac_u_indx = SrcModuleMapTypeData%Jac_u_indx
   end if
   call MeshCopy(SrcModuleMapTypeData%u_ED_NacelleLoads, DstModuleMapTypeData%u_ED_NacelleLoads, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcModuleMapTypeData%SubstructureLoads_Tmp, DstModuleMapTypeData%SubstructureLoads_Tmp, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcModuleMapTypeData%SubstructureLoads_Tmp2, DstModuleMapTypeData%SubstructureLoads_Tmp2, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcModuleMapTypeData%PlatformLoads_Tmp, DstModuleMapTypeData%PlatformLoads_Tmp, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcModuleMapTypeData%PlatformLoads_Tmp2, DstModuleMapTypeData%PlatformLoads_Tmp2, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcModuleMapTypeData%SubstructureLoads_Tmp_Farm, DstModuleMapTypeData%SubstructureLoads_Tmp_Farm, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcModuleMapTypeData%u_ED_TowerPtloads, DstModuleMapTypeData%u_ED_TowerPtloads, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcModuleMapTypeData%u_ED_BladePtLoads)) then
      LB(1:1) = lbound(SrcModuleMapTypeData%u_ED_BladePtLoads)
      UB(1:1) = ubound(SrcModuleMapTypeData%u_ED_BladePtLoads)
      if (.not. allocated(DstModuleMapTypeData%u_ED_BladePtLoads)) then
         allocate(DstModuleMapTypeData%u_ED_BladePtLoads(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%u_ED_BladePtLoads.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcModuleMapTypeData%u_ED_BladePtLoads(i1), DstModuleMapTypeData%u_ED_BladePtLoads(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call MeshCopy(SrcModuleMapTypeData%u_SD_TPMesh, DstModuleMapTypeData%u_SD_TPMesh, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcModuleMapTypeData%u_HD_M_Mesh, DstModuleMapTypeData%u_HD_M_Mesh, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcModuleMapTypeData%u_HD_W_Mesh, DstModuleMapTypeData%u_HD_W_Mesh, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcModuleMapTypeData%u_ED_HubPtLoad, DstModuleMapTypeData%u_ED_HubPtLoad, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcModuleMapTypeData%u_ED_HubPtLoad_2, DstModuleMapTypeData%u_ED_HubPtLoad_2, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcModuleMapTypeData%u_BD_RootMotion)) then
      LB(1:1) = lbound(SrcModuleMapTypeData%u_BD_RootMotion)
      UB(1:1) = ubound(SrcModuleMapTypeData%u_BD_RootMotion)
      if (.not. allocated(DstModuleMapTypeData%u_BD_RootMotion)) then
         allocate(DstModuleMapTypeData%u_BD_RootMotion(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%u_BD_RootMotion.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcModuleMapTypeData%u_BD_RootMotion(i1), DstModuleMapTypeData%u_BD_RootMotion(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcModuleMapTypeData%y_BD_BldMotion_4Loads)) then
      LB(1:1) = lbound(SrcModuleMapTypeData%y_BD_BldMotion_4Loads)
      UB(1:1) = ubound(SrcModuleMapTypeData%y_BD_BldMotion_4Loads)
      if (.not. allocated(DstModuleMapTypeData%y_BD_BldMotion_4Loads)) then
         allocate(DstModuleMapTypeData%y_BD_BldMotion_4Loads(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%y_BD_BldMotion_4Loads.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcModuleMapTypeData%y_BD_BldMotion_4Loads(i1), DstModuleMapTypeData%y_BD_BldMotion_4Loads(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcModuleMapTypeData%u_BD_Distrload)) then
      LB(1:1) = lbound(SrcModuleMapTypeData%u_BD_Distrload)
      UB(1:1) = ubound(SrcModuleMapTypeData%u_BD_Distrload)
      if (.not. allocated(DstModuleMapTypeData%u_BD_Distrload)) then
         allocate(DstModuleMapTypeData%u_BD_Distrload(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%u_BD_Distrload.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcModuleMapTypeData%u_BD_Distrload(i1), DstModuleMapTypeData%u_BD_Distrload(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call MeshCopy(SrcModuleMapTypeData%u_Orca_PtfmMesh, DstModuleMapTypeData%u_Orca_PtfmMesh, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcModuleMapTypeData%u_ExtPtfm_PtfmMesh, DstModuleMapTypeData%u_ExtPtfm_PtfmMesh, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcModuleMapTypeData%u_SED_HubPtLoad, DstModuleMapTypeData%u_SED_HubPtLoad, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcModuleMapTypeData%HubOrient)) then
      LB(1:3) = lbound(SrcModuleMapTypeData%HubOrient)
      UB(1:3) = ubound(SrcModuleMapTypeData%HubOrient)
      if (.not. allocated(DstModuleMapTypeData%HubOrient)) then
         allocate(DstModuleMapTypeData%HubOrient(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstModuleMapTypeData%HubOrient.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstModuleMapTypeData%HubOrient = SrcModuleMapTypeData%HubOrient
   end if
end subroutine

subroutine FAST_DestroyModuleMapType(ModuleMapTypeData, ErrStat, ErrMsg)
   type(FAST_ModuleMapType), intent(inout) :: ModuleMapTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_DestroyModuleMapType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ModuleMapTypeData%ED_P_2_BD_P)) then
      LB(1:1) = lbound(ModuleMapTypeData%ED_P_2_BD_P)
      UB(1:1) = ubound(ModuleMapTypeData%ED_P_2_BD_P)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%ED_P_2_BD_P(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ModuleMapTypeData%ED_P_2_BD_P)
   end if
   if (allocated(ModuleMapTypeData%BD_P_2_ED_P)) then
      LB(1:1) = lbound(ModuleMapTypeData%BD_P_2_ED_P)
      UB(1:1) = ubound(ModuleMapTypeData%BD_P_2_ED_P)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%BD_P_2_ED_P(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ModuleMapTypeData%BD_P_2_ED_P)
   end if
   if (allocated(ModuleMapTypeData%ED_P_2_BD_P_Hub)) then
      LB(1:1) = lbound(ModuleMapTypeData%ED_P_2_BD_P_Hub)
      UB(1:1) = ubound(ModuleMapTypeData%ED_P_2_BD_P_Hub)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%ED_P_2_BD_P_Hub(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ModuleMapTypeData%ED_P_2_BD_P_Hub)
   end if
   call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%ED_P_2_HD_PRP_P, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%SubStructure_2_HD_W_P, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%HD_W_P_2_SubStructure, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%SubStructure_2_HD_M_P, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%HD_M_P_2_SubStructure, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%Structure_2_Mooring, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%Mooring_2_Structure, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%ED_P_2_SD_TP, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%SD_TP_2_ED_P, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(ModuleMapTypeData%ED_P_2_NStC_P_N)) then
      LB(1:1) = lbound(ModuleMapTypeData%ED_P_2_NStC_P_N)
      UB(1:1) = ubound(ModuleMapTypeData%ED_P_2_NStC_P_N)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%ED_P_2_NStC_P_N(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ModuleMapTypeData%ED_P_2_NStC_P_N)
   end if
   if (allocated(ModuleMapTypeData%NStC_P_2_ED_P_N)) then
      LB(1:1) = lbound(ModuleMapTypeData%NStC_P_2_ED_P_N)
      UB(1:1) = ubound(ModuleMapTypeData%NStC_P_2_ED_P_N)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%NStC_P_2_ED_P_N(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ModuleMapTypeData%NStC_P_2_ED_P_N)
   end if
   if (allocated(ModuleMapTypeData%ED_L_2_TStC_P_T)) then
      LB(1:1) = lbound(ModuleMapTypeData%ED_L_2_TStC_P_T)
      UB(1:1) = ubound(ModuleMapTypeData%ED_L_2_TStC_P_T)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%ED_L_2_TStC_P_T(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ModuleMapTypeData%ED_L_2_TStC_P_T)
   end if
   if (allocated(ModuleMapTypeData%TStC_P_2_ED_P_T)) then
      LB(1:1) = lbound(ModuleMapTypeData%TStC_P_2_ED_P_T)
      UB(1:1) = ubound(ModuleMapTypeData%TStC_P_2_ED_P_T)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%TStC_P_2_ED_P_T(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ModuleMapTypeData%TStC_P_2_ED_P_T)
   end if
   if (allocated(ModuleMapTypeData%ED_L_2_BStC_P_B)) then
      LB(1:2) = lbound(ModuleMapTypeData%ED_L_2_BStC_P_B)
      UB(1:2) = ubound(ModuleMapTypeData%ED_L_2_BStC_P_B)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%ED_L_2_BStC_P_B(i1,i2), ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         end do
      end do
      deallocate(ModuleMapTypeData%ED_L_2_BStC_P_B)
   end if
   if (allocated(ModuleMapTypeData%BStC_P_2_ED_P_B)) then
      LB(1:2) = lbound(ModuleMapTypeData%BStC_P_2_ED_P_B)
      UB(1:2) = ubound(ModuleMapTypeData%BStC_P_2_ED_P_B)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%BStC_P_2_ED_P_B(i1,i2), ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         end do
      end do
      deallocate(ModuleMapTypeData%BStC_P_2_ED_P_B)
   end if
   if (allocated(ModuleMapTypeData%BD_L_2_BStC_P_B)) then
      LB(1:2) = lbound(ModuleMapTypeData%BD_L_2_BStC_P_B)
      UB(1:2) = ubound(ModuleMapTypeData%BD_L_2_BStC_P_B)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%BD_L_2_BStC_P_B(i1,i2), ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         end do
      end do
      deallocate(ModuleMapTypeData%BD_L_2_BStC_P_B)
   end if
   if (allocated(ModuleMapTypeData%BStC_P_2_BD_P_B)) then
      LB(1:2) = lbound(ModuleMapTypeData%BStC_P_2_BD_P_B)
      UB(1:2) = ubound(ModuleMapTypeData%BStC_P_2_BD_P_B)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%BStC_P_2_BD_P_B(i1,i2), ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         end do
      end do
      deallocate(ModuleMapTypeData%BStC_P_2_BD_P_B)
   end if
   if (allocated(ModuleMapTypeData%SStC_P_P_2_SubStructure)) then
      LB(1:1) = lbound(ModuleMapTypeData%SStC_P_P_2_SubStructure)
      UB(1:1) = ubound(ModuleMapTypeData%SStC_P_P_2_SubStructure)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%SStC_P_P_2_SubStructure(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ModuleMapTypeData%SStC_P_P_2_SubStructure)
   end if
   if (allocated(ModuleMapTypeData%SubStructure_2_SStC_P_P)) then
      LB(1:1) = lbound(ModuleMapTypeData%SubStructure_2_SStC_P_P)
      UB(1:1) = ubound(ModuleMapTypeData%SubStructure_2_SStC_P_P)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%SubStructure_2_SStC_P_P(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ModuleMapTypeData%SubStructure_2_SStC_P_P)
   end if
   call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%ED_P_2_SrvD_P_P, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(ModuleMapTypeData%BDED_L_2_AD_L_B)) then
      LB(1:1) = lbound(ModuleMapTypeData%BDED_L_2_AD_L_B)
      UB(1:1) = ubound(ModuleMapTypeData%BDED_L_2_AD_L_B)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%BDED_L_2_AD_L_B(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ModuleMapTypeData%BDED_L_2_AD_L_B)
   end if
   if (allocated(ModuleMapTypeData%AD_L_2_BDED_B)) then
      LB(1:1) = lbound(ModuleMapTypeData%AD_L_2_BDED_B)
      UB(1:1) = ubound(ModuleMapTypeData%AD_L_2_BDED_B)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%AD_L_2_BDED_B(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ModuleMapTypeData%AD_L_2_BDED_B)
   end if
   if (allocated(ModuleMapTypeData%BD_L_2_BD_L)) then
      LB(1:1) = lbound(ModuleMapTypeData%BD_L_2_BD_L)
      UB(1:1) = ubound(ModuleMapTypeData%BD_L_2_BD_L)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%BD_L_2_BD_L(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ModuleMapTypeData%BD_L_2_BD_L)
   end if
   if (allocated(ModuleMapTypeData%SED_P_2_AD_L_B)) then
      LB(1:1) = lbound(ModuleMapTypeData%SED_P_2_AD_L_B)
      UB(1:1) = ubound(ModuleMapTypeData%SED_P_2_AD_L_B)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%SED_P_2_AD_L_B(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ModuleMapTypeData%SED_P_2_AD_L_B)
   end if
   if (allocated(ModuleMapTypeData%SED_P_2_AD_P_R)) then
      LB(1:1) = lbound(ModuleMapTypeData%SED_P_2_AD_P_R)
      UB(1:1) = ubound(ModuleMapTypeData%SED_P_2_AD_P_R)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%SED_P_2_AD_P_R(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ModuleMapTypeData%SED_P_2_AD_P_R)
   end if
   if (allocated(ModuleMapTypeData%AD_L_2_SED_P)) then
      LB(1:1) = lbound(ModuleMapTypeData%AD_L_2_SED_P)
      UB(1:1) = ubound(ModuleMapTypeData%AD_L_2_SED_P)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%AD_L_2_SED_P(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ModuleMapTypeData%AD_L_2_SED_P)
   end if
   call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%ED_P_2_AD_P_N, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%AD_P_2_ED_P_N, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%ED_P_2_AD_P_TF, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%AD_P_2_ED_P_TF, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%ED_L_2_AD_L_T, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%AD_L_2_ED_P_T, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(ModuleMapTypeData%ED_P_2_AD_P_R)) then
      LB(1:1) = lbound(ModuleMapTypeData%ED_P_2_AD_P_R)
      UB(1:1) = ubound(ModuleMapTypeData%ED_P_2_AD_P_R)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%ED_P_2_AD_P_R(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ModuleMapTypeData%ED_P_2_AD_P_R)
   end if
   call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%ED_P_2_AD_P_H, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%ADsk_P_2_ED_P_H, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%ED_P_2_ADsk_P_H, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%SED_P_2_AD_P_N, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%SED_L_2_AD_L_T, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%SED_P_2_AD_P_H, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%ADsk_P_2_SED_P_H, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%SED_P_2_ADsk_P_H, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%AD_P_2_ED_P_H, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(ModuleMapTypeData%BDED_L_2_ExtLd_P_B)) then
      LB(1:1) = lbound(ModuleMapTypeData%BDED_L_2_ExtLd_P_B)
      UB(1:1) = ubound(ModuleMapTypeData%BDED_L_2_ExtLd_P_B)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%BDED_L_2_ExtLd_P_B(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ModuleMapTypeData%BDED_L_2_ExtLd_P_B)
   end if
   if (allocated(ModuleMapTypeData%ExtLd_P_2_BDED_B)) then
      LB(1:1) = lbound(ModuleMapTypeData%ExtLd_P_2_BDED_B)
      UB(1:1) = ubound(ModuleMapTypeData%ExtLd_P_2_BDED_B)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%ExtLd_P_2_BDED_B(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ModuleMapTypeData%ExtLd_P_2_BDED_B)
   end if
   call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%ED_L_2_ExtLd_P_T, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%ExtLd_P_2_ED_P_T, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(ModuleMapTypeData%ED_P_2_ExtLd_P_R)) then
      LB(1:1) = lbound(ModuleMapTypeData%ED_P_2_ExtLd_P_R)
      UB(1:1) = ubound(ModuleMapTypeData%ED_P_2_ExtLd_P_R)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%ED_P_2_ExtLd_P_R(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ModuleMapTypeData%ED_P_2_ExtLd_P_R)
   end if
   call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%ED_P_2_ExtLd_P_H, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(ModuleMapTypeData%AD_L_2_ExtLd_B)) then
      LB(1:1) = lbound(ModuleMapTypeData%AD_L_2_ExtLd_B)
      UB(1:1) = ubound(ModuleMapTypeData%AD_L_2_ExtLd_B)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%AD_L_2_ExtLd_B(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ModuleMapTypeData%AD_L_2_ExtLd_B)
   end if
   call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%AD_L_2_ExtLd_T, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%IceF_P_2_SD_P, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%SDy3_P_2_IceF_P, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(ModuleMapTypeData%IceD_P_2_SD_P)) then
      LB(1:1) = lbound(ModuleMapTypeData%IceD_P_2_SD_P)
      UB(1:1) = ubound(ModuleMapTypeData%IceD_P_2_SD_P)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%IceD_P_2_SD_P(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ModuleMapTypeData%IceD_P_2_SD_P)
   end if
   if (allocated(ModuleMapTypeData%SDy3_P_2_IceD_P)) then
      LB(1:1) = lbound(ModuleMapTypeData%SDy3_P_2_IceD_P)
      UB(1:1) = ubound(ModuleMapTypeData%SDy3_P_2_IceD_P)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyMeshMapType(ModuleMapTypeData%SDy3_P_2_IceD_P(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ModuleMapTypeData%SDy3_P_2_IceD_P)
   end if
   if (allocated(ModuleMapTypeData%Jacobian_Opt1)) then
      deallocate(ModuleMapTypeData%Jacobian_Opt1)
   end if
   if (allocated(ModuleMapTypeData%Jacobian_pivot)) then
      deallocate(ModuleMapTypeData%Jacobian_pivot)
   end if
   if (allocated(ModuleMapTypeData%Jac_u_indx)) then
      deallocate(ModuleMapTypeData%Jac_u_indx)
   end if
   call MeshDestroy( ModuleMapTypeData%u_ED_NacelleLoads, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( ModuleMapTypeData%SubstructureLoads_Tmp, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( ModuleMapTypeData%SubstructureLoads_Tmp2, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( ModuleMapTypeData%PlatformLoads_Tmp, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( ModuleMapTypeData%PlatformLoads_Tmp2, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( ModuleMapTypeData%SubstructureLoads_Tmp_Farm, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( ModuleMapTypeData%u_ED_TowerPtloads, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(ModuleMapTypeData%u_ED_BladePtLoads)) then
      LB(1:1) = lbound(ModuleMapTypeData%u_ED_BladePtLoads)
      UB(1:1) = ubound(ModuleMapTypeData%u_ED_BladePtLoads)
      do i1 = LB(1), UB(1)
         call MeshDestroy( ModuleMapTypeData%u_ED_BladePtLoads(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ModuleMapTypeData%u_ED_BladePtLoads)
   end if
   call MeshDestroy( ModuleMapTypeData%u_SD_TPMesh, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( ModuleMapTypeData%u_HD_M_Mesh, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( ModuleMapTypeData%u_HD_W_Mesh, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( ModuleMapTypeData%u_ED_HubPtLoad, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( ModuleMapTypeData%u_ED_HubPtLoad_2, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(ModuleMapTypeData%u_BD_RootMotion)) then
      LB(1:1) = lbound(ModuleMapTypeData%u_BD_RootMotion)
      UB(1:1) = ubound(ModuleMapTypeData%u_BD_RootMotion)
      do i1 = LB(1), UB(1)
         call MeshDestroy( ModuleMapTypeData%u_BD_RootMotion(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ModuleMapTypeData%u_BD_RootMotion)
   end if
   if (allocated(ModuleMapTypeData%y_BD_BldMotion_4Loads)) then
      LB(1:1) = lbound(ModuleMapTypeData%y_BD_BldMotion_4Loads)
      UB(1:1) = ubound(ModuleMapTypeData%y_BD_BldMotion_4Loads)
      do i1 = LB(1), UB(1)
         call MeshDestroy( ModuleMapTypeData%y_BD_BldMotion_4Loads(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ModuleMapTypeData%y_BD_BldMotion_4Loads)
   end if
   if (allocated(ModuleMapTypeData%u_BD_Distrload)) then
      LB(1:1) = lbound(ModuleMapTypeData%u_BD_Distrload)
      UB(1:1) = ubound(ModuleMapTypeData%u_BD_Distrload)
      do i1 = LB(1), UB(1)
         call MeshDestroy( ModuleMapTypeData%u_BD_Distrload(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ModuleMapTypeData%u_BD_Distrload)
   end if
   call MeshDestroy( ModuleMapTypeData%u_Orca_PtfmMesh, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( ModuleMapTypeData%u_ExtPtfm_PtfmMesh, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( ModuleMapTypeData%u_SED_HubPtLoad, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(ModuleMapTypeData%HubOrient)) then
      deallocate(ModuleMapTypeData%HubOrient)
   end if
end subroutine

subroutine FAST_PackModuleMapType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FAST_ModuleMapType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FAST_PackModuleMapType'
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)   :: LB(3), UB(3)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%ED_P_2_BD_P))
   if (allocated(InData%ED_P_2_BD_P)) then
      call RegPackBounds(RF, 1, lbound(InData%ED_P_2_BD_P), ubound(InData%ED_P_2_BD_P))
      LB(1:1) = lbound(InData%ED_P_2_BD_P)
      UB(1:1) = ubound(InData%ED_P_2_BD_P)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackMeshMapType(RF, InData%ED_P_2_BD_P(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%BD_P_2_ED_P))
   if (allocated(InData%BD_P_2_ED_P)) then
      call RegPackBounds(RF, 1, lbound(InData%BD_P_2_ED_P), ubound(InData%BD_P_2_ED_P))
      LB(1:1) = lbound(InData%BD_P_2_ED_P)
      UB(1:1) = ubound(InData%BD_P_2_ED_P)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackMeshMapType(RF, InData%BD_P_2_ED_P(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%ED_P_2_BD_P_Hub))
   if (allocated(InData%ED_P_2_BD_P_Hub)) then
      call RegPackBounds(RF, 1, lbound(InData%ED_P_2_BD_P_Hub), ubound(InData%ED_P_2_BD_P_Hub))
      LB(1:1) = lbound(InData%ED_P_2_BD_P_Hub)
      UB(1:1) = ubound(InData%ED_P_2_BD_P_Hub)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackMeshMapType(RF, InData%ED_P_2_BD_P_Hub(i1)) 
      end do
   end if
   call NWTC_Library_PackMeshMapType(RF, InData%ED_P_2_HD_PRP_P) 
   call NWTC_Library_PackMeshMapType(RF, InData%SubStructure_2_HD_W_P) 
   call NWTC_Library_PackMeshMapType(RF, InData%HD_W_P_2_SubStructure) 
   call NWTC_Library_PackMeshMapType(RF, InData%SubStructure_2_HD_M_P) 
   call NWTC_Library_PackMeshMapType(RF, InData%HD_M_P_2_SubStructure) 
   call NWTC_Library_PackMeshMapType(RF, InData%Structure_2_Mooring) 
   call NWTC_Library_PackMeshMapType(RF, InData%Mooring_2_Structure) 
   call NWTC_Library_PackMeshMapType(RF, InData%ED_P_2_SD_TP) 
   call NWTC_Library_PackMeshMapType(RF, InData%SD_TP_2_ED_P) 
   call RegPack(RF, allocated(InData%ED_P_2_NStC_P_N))
   if (allocated(InData%ED_P_2_NStC_P_N)) then
      call RegPackBounds(RF, 1, lbound(InData%ED_P_2_NStC_P_N), ubound(InData%ED_P_2_NStC_P_N))
      LB(1:1) = lbound(InData%ED_P_2_NStC_P_N)
      UB(1:1) = ubound(InData%ED_P_2_NStC_P_N)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackMeshMapType(RF, InData%ED_P_2_NStC_P_N(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%NStC_P_2_ED_P_N))
   if (allocated(InData%NStC_P_2_ED_P_N)) then
      call RegPackBounds(RF, 1, lbound(InData%NStC_P_2_ED_P_N), ubound(InData%NStC_P_2_ED_P_N))
      LB(1:1) = lbound(InData%NStC_P_2_ED_P_N)
      UB(1:1) = ubound(InData%NStC_P_2_ED_P_N)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackMeshMapType(RF, InData%NStC_P_2_ED_P_N(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%ED_L_2_TStC_P_T))
   if (allocated(InData%ED_L_2_TStC_P_T)) then
      call RegPackBounds(RF, 1, lbound(InData%ED_L_2_TStC_P_T), ubound(InData%ED_L_2_TStC_P_T))
      LB(1:1) = lbound(InData%ED_L_2_TStC_P_T)
      UB(1:1) = ubound(InData%ED_L_2_TStC_P_T)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackMeshMapType(RF, InData%ED_L_2_TStC_P_T(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%TStC_P_2_ED_P_T))
   if (allocated(InData%TStC_P_2_ED_P_T)) then
      call RegPackBounds(RF, 1, lbound(InData%TStC_P_2_ED_P_T), ubound(InData%TStC_P_2_ED_P_T))
      LB(1:1) = lbound(InData%TStC_P_2_ED_P_T)
      UB(1:1) = ubound(InData%TStC_P_2_ED_P_T)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackMeshMapType(RF, InData%TStC_P_2_ED_P_T(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%ED_L_2_BStC_P_B))
   if (allocated(InData%ED_L_2_BStC_P_B)) then
      call RegPackBounds(RF, 2, lbound(InData%ED_L_2_BStC_P_B), ubound(InData%ED_L_2_BStC_P_B))
      LB(1:2) = lbound(InData%ED_L_2_BStC_P_B)
      UB(1:2) = ubound(InData%ED_L_2_BStC_P_B)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call NWTC_Library_PackMeshMapType(RF, InData%ED_L_2_BStC_P_B(i1,i2)) 
         end do
      end do
   end if
   call RegPack(RF, allocated(InData%BStC_P_2_ED_P_B))
   if (allocated(InData%BStC_P_2_ED_P_B)) then
      call RegPackBounds(RF, 2, lbound(InData%BStC_P_2_ED_P_B), ubound(InData%BStC_P_2_ED_P_B))
      LB(1:2) = lbound(InData%BStC_P_2_ED_P_B)
      UB(1:2) = ubound(InData%BStC_P_2_ED_P_B)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call NWTC_Library_PackMeshMapType(RF, InData%BStC_P_2_ED_P_B(i1,i2)) 
         end do
      end do
   end if
   call RegPack(RF, allocated(InData%BD_L_2_BStC_P_B))
   if (allocated(InData%BD_L_2_BStC_P_B)) then
      call RegPackBounds(RF, 2, lbound(InData%BD_L_2_BStC_P_B), ubound(InData%BD_L_2_BStC_P_B))
      LB(1:2) = lbound(InData%BD_L_2_BStC_P_B)
      UB(1:2) = ubound(InData%BD_L_2_BStC_P_B)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call NWTC_Library_PackMeshMapType(RF, InData%BD_L_2_BStC_P_B(i1,i2)) 
         end do
      end do
   end if
   call RegPack(RF, allocated(InData%BStC_P_2_BD_P_B))
   if (allocated(InData%BStC_P_2_BD_P_B)) then
      call RegPackBounds(RF, 2, lbound(InData%BStC_P_2_BD_P_B), ubound(InData%BStC_P_2_BD_P_B))
      LB(1:2) = lbound(InData%BStC_P_2_BD_P_B)
      UB(1:2) = ubound(InData%BStC_P_2_BD_P_B)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call NWTC_Library_PackMeshMapType(RF, InData%BStC_P_2_BD_P_B(i1,i2)) 
         end do
      end do
   end if
   call RegPack(RF, allocated(InData%SStC_P_P_2_SubStructure))
   if (allocated(InData%SStC_P_P_2_SubStructure)) then
      call RegPackBounds(RF, 1, lbound(InData%SStC_P_P_2_SubStructure), ubound(InData%SStC_P_P_2_SubStructure))
      LB(1:1) = lbound(InData%SStC_P_P_2_SubStructure)
      UB(1:1) = ubound(InData%SStC_P_P_2_SubStructure)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackMeshMapType(RF, InData%SStC_P_P_2_SubStructure(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%SubStructure_2_SStC_P_P))
   if (allocated(InData%SubStructure_2_SStC_P_P)) then
      call RegPackBounds(RF, 1, lbound(InData%SubStructure_2_SStC_P_P), ubound(InData%SubStructure_2_SStC_P_P))
      LB(1:1) = lbound(InData%SubStructure_2_SStC_P_P)
      UB(1:1) = ubound(InData%SubStructure_2_SStC_P_P)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackMeshMapType(RF, InData%SubStructure_2_SStC_P_P(i1)) 
      end do
   end if
   call NWTC_Library_PackMeshMapType(RF, InData%ED_P_2_SrvD_P_P) 
   call RegPack(RF, allocated(InData%BDED_L_2_AD_L_B))
   if (allocated(InData%BDED_L_2_AD_L_B)) then
      call RegPackBounds(RF, 1, lbound(InData%BDED_L_2_AD_L_B), ubound(InData%BDED_L_2_AD_L_B))
      LB(1:1) = lbound(InData%BDED_L_2_AD_L_B)
      UB(1:1) = ubound(InData%BDED_L_2_AD_L_B)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackMeshMapType(RF, InData%BDED_L_2_AD_L_B(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%AD_L_2_BDED_B))
   if (allocated(InData%AD_L_2_BDED_B)) then
      call RegPackBounds(RF, 1, lbound(InData%AD_L_2_BDED_B), ubound(InData%AD_L_2_BDED_B))
      LB(1:1) = lbound(InData%AD_L_2_BDED_B)
      UB(1:1) = ubound(InData%AD_L_2_BDED_B)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackMeshMapType(RF, InData%AD_L_2_BDED_B(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%BD_L_2_BD_L))
   if (allocated(InData%BD_L_2_BD_L)) then
      call RegPackBounds(RF, 1, lbound(InData%BD_L_2_BD_L), ubound(InData%BD_L_2_BD_L))
      LB(1:1) = lbound(InData%BD_L_2_BD_L)
      UB(1:1) = ubound(InData%BD_L_2_BD_L)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackMeshMapType(RF, InData%BD_L_2_BD_L(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%SED_P_2_AD_L_B))
   if (allocated(InData%SED_P_2_AD_L_B)) then
      call RegPackBounds(RF, 1, lbound(InData%SED_P_2_AD_L_B), ubound(InData%SED_P_2_AD_L_B))
      LB(1:1) = lbound(InData%SED_P_2_AD_L_B)
      UB(1:1) = ubound(InData%SED_P_2_AD_L_B)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackMeshMapType(RF, InData%SED_P_2_AD_L_B(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%SED_P_2_AD_P_R))
   if (allocated(InData%SED_P_2_AD_P_R)) then
      call RegPackBounds(RF, 1, lbound(InData%SED_P_2_AD_P_R), ubound(InData%SED_P_2_AD_P_R))
      LB(1:1) = lbound(InData%SED_P_2_AD_P_R)
      UB(1:1) = ubound(InData%SED_P_2_AD_P_R)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackMeshMapType(RF, InData%SED_P_2_AD_P_R(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%AD_L_2_SED_P))
   if (allocated(InData%AD_L_2_SED_P)) then
      call RegPackBounds(RF, 1, lbound(InData%AD_L_2_SED_P), ubound(InData%AD_L_2_SED_P))
      LB(1:1) = lbound(InData%AD_L_2_SED_P)
      UB(1:1) = ubound(InData%AD_L_2_SED_P)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackMeshMapType(RF, InData%AD_L_2_SED_P(i1)) 
      end do
   end if
   call NWTC_Library_PackMeshMapType(RF, InData%ED_P_2_AD_P_N) 
   call NWTC_Library_PackMeshMapType(RF, InData%AD_P_2_ED_P_N) 
   call NWTC_Library_PackMeshMapType(RF, InData%ED_P_2_AD_P_TF) 
   call NWTC_Library_PackMeshMapType(RF, InData%AD_P_2_ED_P_TF) 
   call NWTC_Library_PackMeshMapType(RF, InData%ED_L_2_AD_L_T) 
   call NWTC_Library_PackMeshMapType(RF, InData%AD_L_2_ED_P_T) 
   call RegPack(RF, allocated(InData%ED_P_2_AD_P_R))
   if (allocated(InData%ED_P_2_AD_P_R)) then
      call RegPackBounds(RF, 1, lbound(InData%ED_P_2_AD_P_R), ubound(InData%ED_P_2_AD_P_R))
      LB(1:1) = lbound(InData%ED_P_2_AD_P_R)
      UB(1:1) = ubound(InData%ED_P_2_AD_P_R)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackMeshMapType(RF, InData%ED_P_2_AD_P_R(i1)) 
      end do
   end if
   call NWTC_Library_PackMeshMapType(RF, InData%ED_P_2_AD_P_H) 
   call NWTC_Library_PackMeshMapType(RF, InData%ADsk_P_2_ED_P_H) 
   call NWTC_Library_PackMeshMapType(RF, InData%ED_P_2_ADsk_P_H) 
   call NWTC_Library_PackMeshMapType(RF, InData%SED_P_2_AD_P_N) 
   call NWTC_Library_PackMeshMapType(RF, InData%SED_L_2_AD_L_T) 
   call NWTC_Library_PackMeshMapType(RF, InData%SED_P_2_AD_P_H) 
   call NWTC_Library_PackMeshMapType(RF, InData%ADsk_P_2_SED_P_H) 
   call NWTC_Library_PackMeshMapType(RF, InData%SED_P_2_ADsk_P_H) 
   call NWTC_Library_PackMeshMapType(RF, InData%AD_P_2_ED_P_H) 
   call RegPack(RF, allocated(InData%BDED_L_2_ExtLd_P_B))
   if (allocated(InData%BDED_L_2_ExtLd_P_B)) then
      call RegPackBounds(RF, 1, lbound(InData%BDED_L_2_ExtLd_P_B), ubound(InData%BDED_L_2_ExtLd_P_B))
      LB(1:1) = lbound(InData%BDED_L_2_ExtLd_P_B)
      UB(1:1) = ubound(InData%BDED_L_2_ExtLd_P_B)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackMeshMapType(RF, InData%BDED_L_2_ExtLd_P_B(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%ExtLd_P_2_BDED_B))
   if (allocated(InData%ExtLd_P_2_BDED_B)) then
      call RegPackBounds(RF, 1, lbound(InData%ExtLd_P_2_BDED_B), ubound(InData%ExtLd_P_2_BDED_B))
      LB(1:1) = lbound(InData%ExtLd_P_2_BDED_B)
      UB(1:1) = ubound(InData%ExtLd_P_2_BDED_B)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackMeshMapType(RF, InData%ExtLd_P_2_BDED_B(i1)) 
      end do
   end if
   call NWTC_Library_PackMeshMapType(RF, InData%ED_L_2_ExtLd_P_T) 
   call NWTC_Library_PackMeshMapType(RF, InData%ExtLd_P_2_ED_P_T) 
   call RegPack(RF, allocated(InData%ED_P_2_ExtLd_P_R))
   if (allocated(InData%ED_P_2_ExtLd_P_R)) then
      call RegPackBounds(RF, 1, lbound(InData%ED_P_2_ExtLd_P_R), ubound(InData%ED_P_2_ExtLd_P_R))
      LB(1:1) = lbound(InData%ED_P_2_ExtLd_P_R)
      UB(1:1) = ubound(InData%ED_P_2_ExtLd_P_R)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackMeshMapType(RF, InData%ED_P_2_ExtLd_P_R(i1)) 
      end do
   end if
   call NWTC_Library_PackMeshMapType(RF, InData%ED_P_2_ExtLd_P_H) 
   call RegPack(RF, allocated(InData%AD_L_2_ExtLd_B))
   if (allocated(InData%AD_L_2_ExtLd_B)) then
      call RegPackBounds(RF, 1, lbound(InData%AD_L_2_ExtLd_B), ubound(InData%AD_L_2_ExtLd_B))
      LB(1:1) = lbound(InData%AD_L_2_ExtLd_B)
      UB(1:1) = ubound(InData%AD_L_2_ExtLd_B)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackMeshMapType(RF, InData%AD_L_2_ExtLd_B(i1)) 
      end do
   end if
   call NWTC_Library_PackMeshMapType(RF, InData%AD_L_2_ExtLd_T) 
   call NWTC_Library_PackMeshMapType(RF, InData%IceF_P_2_SD_P) 
   call NWTC_Library_PackMeshMapType(RF, InData%SDy3_P_2_IceF_P) 
   call RegPack(RF, allocated(InData%IceD_P_2_SD_P))
   if (allocated(InData%IceD_P_2_SD_P)) then
      call RegPackBounds(RF, 1, lbound(InData%IceD_P_2_SD_P), ubound(InData%IceD_P_2_SD_P))
      LB(1:1) = lbound(InData%IceD_P_2_SD_P)
      UB(1:1) = ubound(InData%IceD_P_2_SD_P)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackMeshMapType(RF, InData%IceD_P_2_SD_P(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%SDy3_P_2_IceD_P))
   if (allocated(InData%SDy3_P_2_IceD_P)) then
      call RegPackBounds(RF, 1, lbound(InData%SDy3_P_2_IceD_P), ubound(InData%SDy3_P_2_IceD_P))
      LB(1:1) = lbound(InData%SDy3_P_2_IceD_P)
      UB(1:1) = ubound(InData%SDy3_P_2_IceD_P)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackMeshMapType(RF, InData%SDy3_P_2_IceD_P(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%Jacobian_Opt1)
   call RegPackAlloc(RF, InData%Jacobian_pivot)
   call RegPackAlloc(RF, InData%Jac_u_indx)
   call MeshPack(RF, InData%u_ED_NacelleLoads) 
   call MeshPack(RF, InData%SubstructureLoads_Tmp) 
   call MeshPack(RF, InData%SubstructureLoads_Tmp2) 
   call MeshPack(RF, InData%PlatformLoads_Tmp) 
   call MeshPack(RF, InData%PlatformLoads_Tmp2) 
   call MeshPack(RF, InData%SubstructureLoads_Tmp_Farm) 
   call MeshPack(RF, InData%u_ED_TowerPtloads) 
   call RegPack(RF, allocated(InData%u_ED_BladePtLoads))
   if (allocated(InData%u_ED_BladePtLoads)) then
      call RegPackBounds(RF, 1, lbound(InData%u_ED_BladePtLoads), ubound(InData%u_ED_BladePtLoads))
      LB(1:1) = lbound(InData%u_ED_BladePtLoads)
      UB(1:1) = ubound(InData%u_ED_BladePtLoads)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%u_ED_BladePtLoads(i1)) 
      end do
   end if
   call MeshPack(RF, InData%u_SD_TPMesh) 
   call MeshPack(RF, InData%u_HD_M_Mesh) 
   call MeshPack(RF, InData%u_HD_W_Mesh) 
   call MeshPack(RF, InData%u_ED_HubPtLoad) 
   call MeshPack(RF, InData%u_ED_HubPtLoad_2) 
   call RegPack(RF, allocated(InData%u_BD_RootMotion))
   if (allocated(InData%u_BD_RootMotion)) then
      call RegPackBounds(RF, 1, lbound(InData%u_BD_RootMotion), ubound(InData%u_BD_RootMotion))
      LB(1:1) = lbound(InData%u_BD_RootMotion)
      UB(1:1) = ubound(InData%u_BD_RootMotion)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%u_BD_RootMotion(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%y_BD_BldMotion_4Loads))
   if (allocated(InData%y_BD_BldMotion_4Loads)) then
      call RegPackBounds(RF, 1, lbound(InData%y_BD_BldMotion_4Loads), ubound(InData%y_BD_BldMotion_4Loads))
      LB(1:1) = lbound(InData%y_BD_BldMotion_4Loads)
      UB(1:1) = ubound(InData%y_BD_BldMotion_4Loads)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%y_BD_BldMotion_4Loads(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%u_BD_Distrload))
   if (allocated(InData%u_BD_Distrload)) then
      call RegPackBounds(RF, 1, lbound(InData%u_BD_Distrload), ubound(InData%u_BD_Distrload))
      LB(1:1) = lbound(InData%u_BD_Distrload)
      UB(1:1) = ubound(InData%u_BD_Distrload)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%u_BD_Distrload(i1)) 
      end do
   end if
   call MeshPack(RF, InData%u_Orca_PtfmMesh) 
   call MeshPack(RF, InData%u_ExtPtfm_PtfmMesh) 
   call MeshPack(RF, InData%u_SED_HubPtLoad) 
   call RegPackAlloc(RF, InData%HubOrient)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_UnPackModuleMapType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FAST_ModuleMapType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FAST_UnPackModuleMapType'
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%ED_P_2_BD_P)) deallocate(OutData%ED_P_2_BD_P)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%ED_P_2_BD_P(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%ED_P_2_BD_P.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackMeshMapType(RF, OutData%ED_P_2_BD_P(i1)) ! ED_P_2_BD_P 
      end do
   end if
   if (allocated(OutData%BD_P_2_ED_P)) deallocate(OutData%BD_P_2_ED_P)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BD_P_2_ED_P(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BD_P_2_ED_P.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackMeshMapType(RF, OutData%BD_P_2_ED_P(i1)) ! BD_P_2_ED_P 
      end do
   end if
   if (allocated(OutData%ED_P_2_BD_P_Hub)) deallocate(OutData%ED_P_2_BD_P_Hub)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%ED_P_2_BD_P_Hub(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%ED_P_2_BD_P_Hub.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackMeshMapType(RF, OutData%ED_P_2_BD_P_Hub(i1)) ! ED_P_2_BD_P_Hub 
      end do
   end if
   call NWTC_Library_UnpackMeshMapType(RF, OutData%ED_P_2_HD_PRP_P) ! ED_P_2_HD_PRP_P 
   call NWTC_Library_UnpackMeshMapType(RF, OutData%SubStructure_2_HD_W_P) ! SubStructure_2_HD_W_P 
   call NWTC_Library_UnpackMeshMapType(RF, OutData%HD_W_P_2_SubStructure) ! HD_W_P_2_SubStructure 
   call NWTC_Library_UnpackMeshMapType(RF, OutData%SubStructure_2_HD_M_P) ! SubStructure_2_HD_M_P 
   call NWTC_Library_UnpackMeshMapType(RF, OutData%HD_M_P_2_SubStructure) ! HD_M_P_2_SubStructure 
   call NWTC_Library_UnpackMeshMapType(RF, OutData%Structure_2_Mooring) ! Structure_2_Mooring 
   call NWTC_Library_UnpackMeshMapType(RF, OutData%Mooring_2_Structure) ! Mooring_2_Structure 
   call NWTC_Library_UnpackMeshMapType(RF, OutData%ED_P_2_SD_TP) ! ED_P_2_SD_TP 
   call NWTC_Library_UnpackMeshMapType(RF, OutData%SD_TP_2_ED_P) ! SD_TP_2_ED_P 
   if (allocated(OutData%ED_P_2_NStC_P_N)) deallocate(OutData%ED_P_2_NStC_P_N)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%ED_P_2_NStC_P_N(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%ED_P_2_NStC_P_N.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackMeshMapType(RF, OutData%ED_P_2_NStC_P_N(i1)) ! ED_P_2_NStC_P_N 
      end do
   end if
   if (allocated(OutData%NStC_P_2_ED_P_N)) deallocate(OutData%NStC_P_2_ED_P_N)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%NStC_P_2_ED_P_N(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%NStC_P_2_ED_P_N.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackMeshMapType(RF, OutData%NStC_P_2_ED_P_N(i1)) ! NStC_P_2_ED_P_N 
      end do
   end if
   if (allocated(OutData%ED_L_2_TStC_P_T)) deallocate(OutData%ED_L_2_TStC_P_T)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%ED_L_2_TStC_P_T(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%ED_L_2_TStC_P_T.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackMeshMapType(RF, OutData%ED_L_2_TStC_P_T(i1)) ! ED_L_2_TStC_P_T 
      end do
   end if
   if (allocated(OutData%TStC_P_2_ED_P_T)) deallocate(OutData%TStC_P_2_ED_P_T)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%TStC_P_2_ED_P_T(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%TStC_P_2_ED_P_T.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackMeshMapType(RF, OutData%TStC_P_2_ED_P_T(i1)) ! TStC_P_2_ED_P_T 
      end do
   end if
   if (allocated(OutData%ED_L_2_BStC_P_B)) deallocate(OutData%ED_L_2_BStC_P_B)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 2, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%ED_L_2_BStC_P_B(LB(1):UB(1),LB(2):UB(2)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%ED_L_2_BStC_P_B.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call NWTC_Library_UnpackMeshMapType(RF, OutData%ED_L_2_BStC_P_B(i1,i2)) ! ED_L_2_BStC_P_B 
         end do
      end do
   end if
   if (allocated(OutData%BStC_P_2_ED_P_B)) deallocate(OutData%BStC_P_2_ED_P_B)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 2, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BStC_P_2_ED_P_B(LB(1):UB(1),LB(2):UB(2)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BStC_P_2_ED_P_B.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call NWTC_Library_UnpackMeshMapType(RF, OutData%BStC_P_2_ED_P_B(i1,i2)) ! BStC_P_2_ED_P_B 
         end do
      end do
   end if
   if (allocated(OutData%BD_L_2_BStC_P_B)) deallocate(OutData%BD_L_2_BStC_P_B)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 2, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BD_L_2_BStC_P_B(LB(1):UB(1),LB(2):UB(2)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BD_L_2_BStC_P_B.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call NWTC_Library_UnpackMeshMapType(RF, OutData%BD_L_2_BStC_P_B(i1,i2)) ! BD_L_2_BStC_P_B 
         end do
      end do
   end if
   if (allocated(OutData%BStC_P_2_BD_P_B)) deallocate(OutData%BStC_P_2_BD_P_B)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 2, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BStC_P_2_BD_P_B(LB(1):UB(1),LB(2):UB(2)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BStC_P_2_BD_P_B.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call NWTC_Library_UnpackMeshMapType(RF, OutData%BStC_P_2_BD_P_B(i1,i2)) ! BStC_P_2_BD_P_B 
         end do
      end do
   end if
   if (allocated(OutData%SStC_P_P_2_SubStructure)) deallocate(OutData%SStC_P_P_2_SubStructure)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%SStC_P_P_2_SubStructure(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%SStC_P_P_2_SubStructure.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackMeshMapType(RF, OutData%SStC_P_P_2_SubStructure(i1)) ! SStC_P_P_2_SubStructure 
      end do
   end if
   if (allocated(OutData%SubStructure_2_SStC_P_P)) deallocate(OutData%SubStructure_2_SStC_P_P)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%SubStructure_2_SStC_P_P(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%SubStructure_2_SStC_P_P.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackMeshMapType(RF, OutData%SubStructure_2_SStC_P_P(i1)) ! SubStructure_2_SStC_P_P 
      end do
   end if
   call NWTC_Library_UnpackMeshMapType(RF, OutData%ED_P_2_SrvD_P_P) ! ED_P_2_SrvD_P_P 
   if (allocated(OutData%BDED_L_2_AD_L_B)) deallocate(OutData%BDED_L_2_AD_L_B)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BDED_L_2_AD_L_B(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BDED_L_2_AD_L_B.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackMeshMapType(RF, OutData%BDED_L_2_AD_L_B(i1)) ! BDED_L_2_AD_L_B 
      end do
   end if
   if (allocated(OutData%AD_L_2_BDED_B)) deallocate(OutData%AD_L_2_BDED_B)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%AD_L_2_BDED_B(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%AD_L_2_BDED_B.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackMeshMapType(RF, OutData%AD_L_2_BDED_B(i1)) ! AD_L_2_BDED_B 
      end do
   end if
   if (allocated(OutData%BD_L_2_BD_L)) deallocate(OutData%BD_L_2_BD_L)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BD_L_2_BD_L(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BD_L_2_BD_L.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackMeshMapType(RF, OutData%BD_L_2_BD_L(i1)) ! BD_L_2_BD_L 
      end do
   end if
   if (allocated(OutData%SED_P_2_AD_L_B)) deallocate(OutData%SED_P_2_AD_L_B)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%SED_P_2_AD_L_B(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%SED_P_2_AD_L_B.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackMeshMapType(RF, OutData%SED_P_2_AD_L_B(i1)) ! SED_P_2_AD_L_B 
      end do
   end if
   if (allocated(OutData%SED_P_2_AD_P_R)) deallocate(OutData%SED_P_2_AD_P_R)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%SED_P_2_AD_P_R(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%SED_P_2_AD_P_R.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackMeshMapType(RF, OutData%SED_P_2_AD_P_R(i1)) ! SED_P_2_AD_P_R 
      end do
   end if
   if (allocated(OutData%AD_L_2_SED_P)) deallocate(OutData%AD_L_2_SED_P)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%AD_L_2_SED_P(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%AD_L_2_SED_P.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackMeshMapType(RF, OutData%AD_L_2_SED_P(i1)) ! AD_L_2_SED_P 
      end do
   end if
   call NWTC_Library_UnpackMeshMapType(RF, OutData%ED_P_2_AD_P_N) ! ED_P_2_AD_P_N 
   call NWTC_Library_UnpackMeshMapType(RF, OutData%AD_P_2_ED_P_N) ! AD_P_2_ED_P_N 
   call NWTC_Library_UnpackMeshMapType(RF, OutData%ED_P_2_AD_P_TF) ! ED_P_2_AD_P_TF 
   call NWTC_Library_UnpackMeshMapType(RF, OutData%AD_P_2_ED_P_TF) ! AD_P_2_ED_P_TF 
   call NWTC_Library_UnpackMeshMapType(RF, OutData%ED_L_2_AD_L_T) ! ED_L_2_AD_L_T 
   call NWTC_Library_UnpackMeshMapType(RF, OutData%AD_L_2_ED_P_T) ! AD_L_2_ED_P_T 
   if (allocated(OutData%ED_P_2_AD_P_R)) deallocate(OutData%ED_P_2_AD_P_R)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%ED_P_2_AD_P_R(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%ED_P_2_AD_P_R.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackMeshMapType(RF, OutData%ED_P_2_AD_P_R(i1)) ! ED_P_2_AD_P_R 
      end do
   end if
   call NWTC_Library_UnpackMeshMapType(RF, OutData%ED_P_2_AD_P_H) ! ED_P_2_AD_P_H 
   call NWTC_Library_UnpackMeshMapType(RF, OutData%ADsk_P_2_ED_P_H) ! ADsk_P_2_ED_P_H 
   call NWTC_Library_UnpackMeshMapType(RF, OutData%ED_P_2_ADsk_P_H) ! ED_P_2_ADsk_P_H 
   call NWTC_Library_UnpackMeshMapType(RF, OutData%SED_P_2_AD_P_N) ! SED_P_2_AD_P_N 
   call NWTC_Library_UnpackMeshMapType(RF, OutData%SED_L_2_AD_L_T) ! SED_L_2_AD_L_T 
   call NWTC_Library_UnpackMeshMapType(RF, OutData%SED_P_2_AD_P_H) ! SED_P_2_AD_P_H 
   call NWTC_Library_UnpackMeshMapType(RF, OutData%ADsk_P_2_SED_P_H) ! ADsk_P_2_SED_P_H 
   call NWTC_Library_UnpackMeshMapType(RF, OutData%SED_P_2_ADsk_P_H) ! SED_P_2_ADsk_P_H 
   call NWTC_Library_UnpackMeshMapType(RF, OutData%AD_P_2_ED_P_H) ! AD_P_2_ED_P_H 
   if (allocated(OutData%BDED_L_2_ExtLd_P_B)) deallocate(OutData%BDED_L_2_ExtLd_P_B)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BDED_L_2_ExtLd_P_B(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BDED_L_2_ExtLd_P_B.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackMeshMapType(RF, OutData%BDED_L_2_ExtLd_P_B(i1)) ! BDED_L_2_ExtLd_P_B 
      end do
   end if
   if (allocated(OutData%ExtLd_P_2_BDED_B)) deallocate(OutData%ExtLd_P_2_BDED_B)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%ExtLd_P_2_BDED_B(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%ExtLd_P_2_BDED_B.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackMeshMapType(RF, OutData%ExtLd_P_2_BDED_B(i1)) ! ExtLd_P_2_BDED_B 
      end do
   end if
   call NWTC_Library_UnpackMeshMapType(RF, OutData%ED_L_2_ExtLd_P_T) ! ED_L_2_ExtLd_P_T 
   call NWTC_Library_UnpackMeshMapType(RF, OutData%ExtLd_P_2_ED_P_T) ! ExtLd_P_2_ED_P_T 
   if (allocated(OutData%ED_P_2_ExtLd_P_R)) deallocate(OutData%ED_P_2_ExtLd_P_R)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%ED_P_2_ExtLd_P_R(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%ED_P_2_ExtLd_P_R.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackMeshMapType(RF, OutData%ED_P_2_ExtLd_P_R(i1)) ! ED_P_2_ExtLd_P_R 
      end do
   end if
   call NWTC_Library_UnpackMeshMapType(RF, OutData%ED_P_2_ExtLd_P_H) ! ED_P_2_ExtLd_P_H 
   if (allocated(OutData%AD_L_2_ExtLd_B)) deallocate(OutData%AD_L_2_ExtLd_B)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%AD_L_2_ExtLd_B(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%AD_L_2_ExtLd_B.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackMeshMapType(RF, OutData%AD_L_2_ExtLd_B(i1)) ! AD_L_2_ExtLd_B 
      end do
   end if
   call NWTC_Library_UnpackMeshMapType(RF, OutData%AD_L_2_ExtLd_T) ! AD_L_2_ExtLd_T 
   call NWTC_Library_UnpackMeshMapType(RF, OutData%IceF_P_2_SD_P) ! IceF_P_2_SD_P 
   call NWTC_Library_UnpackMeshMapType(RF, OutData%SDy3_P_2_IceF_P) ! SDy3_P_2_IceF_P 
   if (allocated(OutData%IceD_P_2_SD_P)) deallocate(OutData%IceD_P_2_SD_P)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%IceD_P_2_SD_P(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%IceD_P_2_SD_P.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackMeshMapType(RF, OutData%IceD_P_2_SD_P(i1)) ! IceD_P_2_SD_P 
      end do
   end if
   if (allocated(OutData%SDy3_P_2_IceD_P)) deallocate(OutData%SDy3_P_2_IceD_P)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%SDy3_P_2_IceD_P(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%SDy3_P_2_IceD_P.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackMeshMapType(RF, OutData%SDy3_P_2_IceD_P(i1)) ! SDy3_P_2_IceD_P 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%Jacobian_Opt1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Jacobian_pivot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Jac_u_indx); if (RegCheckErr(RF, RoutineName)) return
   call MeshUnpack(RF, OutData%u_ED_NacelleLoads) ! u_ED_NacelleLoads 
   call MeshUnpack(RF, OutData%SubstructureLoads_Tmp) ! SubstructureLoads_Tmp 
   call MeshUnpack(RF, OutData%SubstructureLoads_Tmp2) ! SubstructureLoads_Tmp2 
   call MeshUnpack(RF, OutData%PlatformLoads_Tmp) ! PlatformLoads_Tmp 
   call MeshUnpack(RF, OutData%PlatformLoads_Tmp2) ! PlatformLoads_Tmp2 
   call MeshUnpack(RF, OutData%SubstructureLoads_Tmp_Farm) ! SubstructureLoads_Tmp_Farm 
   call MeshUnpack(RF, OutData%u_ED_TowerPtloads) ! u_ED_TowerPtloads 
   if (allocated(OutData%u_ED_BladePtLoads)) deallocate(OutData%u_ED_BladePtLoads)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%u_ED_BladePtLoads(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%u_ED_BladePtLoads.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%u_ED_BladePtLoads(i1)) ! u_ED_BladePtLoads 
      end do
   end if
   call MeshUnpack(RF, OutData%u_SD_TPMesh) ! u_SD_TPMesh 
   call MeshUnpack(RF, OutData%u_HD_M_Mesh) ! u_HD_M_Mesh 
   call MeshUnpack(RF, OutData%u_HD_W_Mesh) ! u_HD_W_Mesh 
   call MeshUnpack(RF, OutData%u_ED_HubPtLoad) ! u_ED_HubPtLoad 
   call MeshUnpack(RF, OutData%u_ED_HubPtLoad_2) ! u_ED_HubPtLoad_2 
   if (allocated(OutData%u_BD_RootMotion)) deallocate(OutData%u_BD_RootMotion)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%u_BD_RootMotion(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%u_BD_RootMotion.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%u_BD_RootMotion(i1)) ! u_BD_RootMotion 
      end do
   end if
   if (allocated(OutData%y_BD_BldMotion_4Loads)) deallocate(OutData%y_BD_BldMotion_4Loads)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%y_BD_BldMotion_4Loads(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%y_BD_BldMotion_4Loads.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%y_BD_BldMotion_4Loads(i1)) ! y_BD_BldMotion_4Loads 
      end do
   end if
   if (allocated(OutData%u_BD_Distrload)) deallocate(OutData%u_BD_Distrload)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%u_BD_Distrload(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%u_BD_Distrload.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%u_BD_Distrload(i1)) ! u_BD_Distrload 
      end do
   end if
   call MeshUnpack(RF, OutData%u_Orca_PtfmMesh) ! u_Orca_PtfmMesh 
   call MeshUnpack(RF, OutData%u_ExtPtfm_PtfmMesh) ! u_ExtPtfm_PtfmMesh 
   call MeshUnpack(RF, OutData%u_SED_HubPtLoad) ! u_SED_HubPtLoad 
   call RegUnpackAlloc(RF, OutData%HubOrient); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_CopyExternInputType(SrcExternInputTypeData, DstExternInputTypeData, CtrlCode, ErrStat, ErrMsg)
   type(FAST_ExternInputType), intent(in) :: SrcExternInputTypeData
   type(FAST_ExternInputType), intent(inout) :: DstExternInputTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FAST_CopyExternInputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstExternInputTypeData%GenTrq = SrcExternInputTypeData%GenTrq
   DstExternInputTypeData%ElecPwr = SrcExternInputTypeData%ElecPwr
   DstExternInputTypeData%YawPosCom = SrcExternInputTypeData%YawPosCom
   DstExternInputTypeData%YawRateCom = SrcExternInputTypeData%YawRateCom
   DstExternInputTypeData%BlPitchCom = SrcExternInputTypeData%BlPitchCom
   DstExternInputTypeData%BlAirfoilCom = SrcExternInputTypeData%BlAirfoilCom
   DstExternInputTypeData%HSSBrFrac = SrcExternInputTypeData%HSSBrFrac
   DstExternInputTypeData%CableDeltaL = SrcExternInputTypeData%CableDeltaL
   DstExternInputTypeData%CableDeltaLdot = SrcExternInputTypeData%CableDeltaLdot
end subroutine

subroutine FAST_DestroyExternInputType(ExternInputTypeData, ErrStat, ErrMsg)
   type(FAST_ExternInputType), intent(inout) :: ExternInputTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FAST_DestroyExternInputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine FAST_PackExternInputType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FAST_ExternInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FAST_PackExternInputType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%GenTrq)
   call RegPack(RF, InData%ElecPwr)
   call RegPack(RF, InData%YawPosCom)
   call RegPack(RF, InData%YawRateCom)
   call RegPack(RF, InData%BlPitchCom)
   call RegPack(RF, InData%BlAirfoilCom)
   call RegPack(RF, InData%HSSBrFrac)
   call RegPack(RF, InData%CableDeltaL)
   call RegPack(RF, InData%CableDeltaLdot)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_UnPackExternInputType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FAST_ExternInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FAST_UnPackExternInputType'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%GenTrq); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ElecPwr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawPosCom); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawRateCom); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BlPitchCom); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BlAirfoilCom); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HSSBrFrac); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CableDeltaL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CableDeltaLdot); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_CopyMisc(SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg)
   type(FAST_MiscVarType), intent(in) :: SrcMiscData
   type(FAST_MiscVarType), intent(inout) :: DstMiscData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_CopyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstMiscData%TiLstPrn = SrcMiscData%TiLstPrn
   DstMiscData%t_global = SrcMiscData%t_global
   DstMiscData%NextJacCalcTime = SrcMiscData%NextJacCalcTime
   DstMiscData%PrevClockTime = SrcMiscData%PrevClockTime
   DstMiscData%UsrTime1 = SrcMiscData%UsrTime1
   DstMiscData%UsrTime2 = SrcMiscData%UsrTime2
   DstMiscData%StrtTime = SrcMiscData%StrtTime
   DstMiscData%SimStrtTime = SrcMiscData%SimStrtTime
   DstMiscData%calcJacobian = SrcMiscData%calcJacobian
   call FAST_CopyExternInputType(SrcMiscData%ExternInput, DstMiscData%ExternInput, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call FAST_CopyMiscLinType(SrcMiscData%Lin, DstMiscData%Lin, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine FAST_DestroyMisc(MiscData, ErrStat, ErrMsg)
   type(FAST_MiscVarType), intent(inout) :: MiscData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_DestroyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call FAST_DestroyExternInputType(MiscData%ExternInput, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FAST_DestroyMiscLinType(MiscData%Lin, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine FAST_PackMisc(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FAST_MiscVarType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FAST_PackMisc'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%TiLstPrn)
   call RegPack(RF, InData%t_global)
   call RegPack(RF, InData%NextJacCalcTime)
   call RegPack(RF, InData%PrevClockTime)
   call RegPack(RF, InData%UsrTime1)
   call RegPack(RF, InData%UsrTime2)
   call RegPack(RF, InData%StrtTime)
   call RegPack(RF, InData%SimStrtTime)
   call RegPack(RF, InData%calcJacobian)
   call FAST_PackExternInputType(RF, InData%ExternInput) 
   call FAST_PackMiscLinType(RF, InData%Lin) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_UnPackMisc(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FAST_MiscVarType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FAST_UnPackMisc'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%TiLstPrn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%t_global); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NextJacCalcTime); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PrevClockTime); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UsrTime1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UsrTime2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StrtTime); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SimStrtTime); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%calcJacobian); if (RegCheckErr(RF, RoutineName)) return
   call FAST_UnpackExternInputType(RF, OutData%ExternInput) ! ExternInput 
   call FAST_UnpackMiscLinType(RF, OutData%Lin) ! Lin 
end subroutine

subroutine FAST_CopyInitData(SrcInitDataData, DstInitDataData, CtrlCode, ErrStat, ErrMsg)
   type(FAST_InitData), intent(inout) :: SrcInitDataData
   type(FAST_InitData), intent(inout) :: DstInitDataData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_CopyInitData'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call ED_CopyInitInput(SrcInitDataData%InData_ED, DstInitDataData%InData_ED, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call ED_CopyInitOutput(SrcInitDataData%OutData_ED, DstInitDataData%OutData_ED, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call SED_CopyInitInput(SrcInitDataData%InData_SED, DstInitDataData%InData_SED, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call SED_CopyInitOutput(SrcInitDataData%OutData_SED, DstInitDataData%OutData_SED, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call BD_CopyInitInput(SrcInitDataData%InData_BD, DstInitDataData%InData_BD, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcInitDataData%OutData_BD)) then
      LB(1:1) = lbound(SrcInitDataData%OutData_BD)
      UB(1:1) = ubound(SrcInitDataData%OutData_BD)
      if (.not. allocated(DstInitDataData%OutData_BD)) then
         allocate(DstInitDataData%OutData_BD(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitDataData%OutData_BD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call BD_CopyInitOutput(SrcInitDataData%OutData_BD(i1), DstInitDataData%OutData_BD(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call SrvD_CopyInitInput(SrcInitDataData%InData_SrvD, DstInitDataData%InData_SrvD, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call SrvD_CopyInitOutput(SrcInitDataData%OutData_SrvD, DstInitDataData%OutData_SrvD, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call AD_CopyInitInput(SrcInitDataData%InData_AD, DstInitDataData%InData_AD, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call AD_CopyInitOutput(SrcInitDataData%OutData_AD, DstInitDataData%OutData_AD, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call ADsk_CopyInitInput(SrcInitDataData%InData_ADsk, DstInitDataData%InData_ADsk, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call ADsk_CopyInitOutput(SrcInitDataData%OutData_ADsk, DstInitDataData%OutData_ADsk, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call ExtLd_CopyInitInput(SrcInitDataData%InData_ExtLd, DstInitDataData%InData_ExtLd, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call ExtLd_CopyInitOutput(SrcInitDataData%OutData_ExtLd, DstInitDataData%OutData_ExtLd, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call InflowWind_CopyInitInput(SrcInitDataData%InData_IfW, DstInitDataData%InData_IfW, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call InflowWind_CopyInitOutput(SrcInitDataData%OutData_IfW, DstInitDataData%OutData_IfW, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call ExtInfw_CopyInitInput(SrcInitDataData%InData_ExtInfw, DstInitDataData%InData_ExtInfw, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call ExtInfw_CopyInitOutput(SrcInitDataData%OutData_ExtInfw, DstInitDataData%OutData_ExtInfw, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call SeaSt_CopyInitInput(SrcInitDataData%InData_SeaSt, DstInitDataData%InData_SeaSt, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call SeaSt_CopyInitOutput(SrcInitDataData%OutData_SeaSt, DstInitDataData%OutData_SeaSt, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call HydroDyn_CopyInitInput(SrcInitDataData%InData_HD, DstInitDataData%InData_HD, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call HydroDyn_CopyInitOutput(SrcInitDataData%OutData_HD, DstInitDataData%OutData_HD, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call SD_CopyInitInput(SrcInitDataData%InData_SD, DstInitDataData%InData_SD, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call SD_CopyInitOutput(SrcInitDataData%OutData_SD, DstInitDataData%OutData_SD, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call ExtPtfm_CopyInitInput(SrcInitDataData%InData_ExtPtfm, DstInitDataData%InData_ExtPtfm, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call ExtPtfm_CopyInitOutput(SrcInitDataData%OutData_ExtPtfm, DstInitDataData%OutData_ExtPtfm, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MAP_CopyInitInput(SrcInitDataData%InData_MAP, DstInitDataData%InData_MAP, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MAP_CopyInitOutput(SrcInitDataData%OutData_MAP, DstInitDataData%OutData_MAP, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call FEAM_CopyInitInput(SrcInitDataData%InData_FEAM, DstInitDataData%InData_FEAM, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call FEAM_CopyInitOutput(SrcInitDataData%OutData_FEAM, DstInitDataData%OutData_FEAM, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MD_CopyInitInput(SrcInitDataData%InData_MD, DstInitDataData%InData_MD, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MD_CopyInitOutput(SrcInitDataData%OutData_MD, DstInitDataData%OutData_MD, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call Orca_CopyInitInput(SrcInitDataData%InData_Orca, DstInitDataData%InData_Orca, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call Orca_CopyInitOutput(SrcInitDataData%OutData_Orca, DstInitDataData%OutData_Orca, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call IceFloe_CopyInitInput(SrcInitDataData%InData_IceF, DstInitDataData%InData_IceF, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call IceFloe_CopyInitOutput(SrcInitDataData%OutData_IceF, DstInitDataData%OutData_IceF, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call IceD_CopyInitInput(SrcInitDataData%InData_IceD, DstInitDataData%InData_IceD, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call IceD_CopyInitOutput(SrcInitDataData%OutData_IceD, DstInitDataData%OutData_IceD, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine FAST_DestroyInitData(InitDataData, ErrStat, ErrMsg)
   type(FAST_InitData), intent(inout) :: InitDataData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_DestroyInitData'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call ED_DestroyInitInput(InitDataData%InData_ED, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call ED_DestroyInitOutput(InitDataData%OutData_ED, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call SED_DestroyInitInput(InitDataData%InData_SED, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call SED_DestroyInitOutput(InitDataData%OutData_SED, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call BD_DestroyInitInput(InitDataData%InData_BD, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(InitDataData%OutData_BD)) then
      LB(1:1) = lbound(InitDataData%OutData_BD)
      UB(1:1) = ubound(InitDataData%OutData_BD)
      do i1 = LB(1), UB(1)
         call BD_DestroyInitOutput(InitDataData%OutData_BD(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InitDataData%OutData_BD)
   end if
   call SrvD_DestroyInitInput(InitDataData%InData_SrvD, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call SrvD_DestroyInitOutput(InitDataData%OutData_SrvD, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call AD_DestroyInitInput(InitDataData%InData_AD, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call AD_DestroyInitOutput(InitDataData%OutData_AD, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call ADsk_DestroyInitInput(InitDataData%InData_ADsk, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call ADsk_DestroyInitOutput(InitDataData%OutData_ADsk, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call ExtLd_DestroyInitInput(InitDataData%InData_ExtLd, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call ExtLd_DestroyInitOutput(InitDataData%OutData_ExtLd, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call InflowWind_DestroyInitInput(InitDataData%InData_IfW, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call InflowWind_DestroyInitOutput(InitDataData%OutData_IfW, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call ExtInfw_DestroyInitInput(InitDataData%InData_ExtInfw, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call ExtInfw_DestroyInitOutput(InitDataData%OutData_ExtInfw, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call SeaSt_DestroyInitInput(InitDataData%InData_SeaSt, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call SeaSt_DestroyInitOutput(InitDataData%OutData_SeaSt, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call HydroDyn_DestroyInitInput(InitDataData%InData_HD, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call HydroDyn_DestroyInitOutput(InitDataData%OutData_HD, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call SD_DestroyInitInput(InitDataData%InData_SD, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call SD_DestroyInitOutput(InitDataData%OutData_SD, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call ExtPtfm_DestroyInitInput(InitDataData%InData_ExtPtfm, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call ExtPtfm_DestroyInitOutput(InitDataData%OutData_ExtPtfm, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MAP_DestroyInitInput(InitDataData%InData_MAP, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MAP_DestroyInitOutput(InitDataData%OutData_MAP, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FEAM_DestroyInitInput(InitDataData%InData_FEAM, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FEAM_DestroyInitOutput(InitDataData%OutData_FEAM, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MD_DestroyInitInput(InitDataData%InData_MD, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MD_DestroyInitOutput(InitDataData%OutData_MD, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call Orca_DestroyInitInput(InitDataData%InData_Orca, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call Orca_DestroyInitOutput(InitDataData%OutData_Orca, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call IceFloe_DestroyInitInput(InitDataData%InData_IceF, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call IceFloe_DestroyInitOutput(InitDataData%OutData_IceF, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call IceD_DestroyInitInput(InitDataData%InData_IceD, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call IceD_DestroyInitOutput(InitDataData%OutData_IceD, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine FAST_PackInitData(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FAST_InitData), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FAST_PackInitData'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call ED_PackInitInput(RF, InData%InData_ED) 
   call ED_PackInitOutput(RF, InData%OutData_ED) 
   call SED_PackInitInput(RF, InData%InData_SED) 
   call SED_PackInitOutput(RF, InData%OutData_SED) 
   call BD_PackInitInput(RF, InData%InData_BD) 
   call RegPack(RF, allocated(InData%OutData_BD))
   if (allocated(InData%OutData_BD)) then
      call RegPackBounds(RF, 1, lbound(InData%OutData_BD), ubound(InData%OutData_BD))
      LB(1:1) = lbound(InData%OutData_BD)
      UB(1:1) = ubound(InData%OutData_BD)
      do i1 = LB(1), UB(1)
         call BD_PackInitOutput(RF, InData%OutData_BD(i1)) 
      end do
   end if
   call SrvD_PackInitInput(RF, InData%InData_SrvD) 
   call SrvD_PackInitOutput(RF, InData%OutData_SrvD) 
   call AD_PackInitInput(RF, InData%InData_AD) 
   call AD_PackInitOutput(RF, InData%OutData_AD) 
   call ADsk_PackInitInput(RF, InData%InData_ADsk) 
   call ADsk_PackInitOutput(RF, InData%OutData_ADsk) 
   call ExtLd_PackInitInput(RF, InData%InData_ExtLd) 
   call ExtLd_PackInitOutput(RF, InData%OutData_ExtLd) 
   call InflowWind_PackInitInput(RF, InData%InData_IfW) 
   call InflowWind_PackInitOutput(RF, InData%OutData_IfW) 
   call ExtInfw_PackInitInput(RF, InData%InData_ExtInfw) 
   call ExtInfw_PackInitOutput(RF, InData%OutData_ExtInfw) 
   call SeaSt_PackInitInput(RF, InData%InData_SeaSt) 
   call SeaSt_PackInitOutput(RF, InData%OutData_SeaSt) 
   call HydroDyn_PackInitInput(RF, InData%InData_HD) 
   call HydroDyn_PackInitOutput(RF, InData%OutData_HD) 
   call SD_PackInitInput(RF, InData%InData_SD) 
   call SD_PackInitOutput(RF, InData%OutData_SD) 
   call ExtPtfm_PackInitInput(RF, InData%InData_ExtPtfm) 
   call ExtPtfm_PackInitOutput(RF, InData%OutData_ExtPtfm) 
   call MAP_PackInitInput(RF, InData%InData_MAP) 
   call MAP_PackInitOutput(RF, InData%OutData_MAP) 
   call FEAM_PackInitInput(RF, InData%InData_FEAM) 
   call FEAM_PackInitOutput(RF, InData%OutData_FEAM) 
   call MD_PackInitInput(RF, InData%InData_MD) 
   call MD_PackInitOutput(RF, InData%OutData_MD) 
   call Orca_PackInitInput(RF, InData%InData_Orca) 
   call Orca_PackInitOutput(RF, InData%OutData_Orca) 
   call IceFloe_PackInitInput(RF, InData%InData_IceF) 
   call IceFloe_PackInitOutput(RF, InData%OutData_IceF) 
   call IceD_PackInitInput(RF, InData%InData_IceD) 
   call IceD_PackInitOutput(RF, InData%OutData_IceD) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_UnPackInitData(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FAST_InitData), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FAST_UnPackInitData'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call ED_UnpackInitInput(RF, OutData%InData_ED) ! InData_ED 
   call ED_UnpackInitOutput(RF, OutData%OutData_ED) ! OutData_ED 
   call SED_UnpackInitInput(RF, OutData%InData_SED) ! InData_SED 
   call SED_UnpackInitOutput(RF, OutData%OutData_SED) ! OutData_SED 
   call BD_UnpackInitInput(RF, OutData%InData_BD) ! InData_BD 
   if (allocated(OutData%OutData_BD)) deallocate(OutData%OutData_BD)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%OutData_BD(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%OutData_BD.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call BD_UnpackInitOutput(RF, OutData%OutData_BD(i1)) ! OutData_BD 
      end do
   end if
   call SrvD_UnpackInitInput(RF, OutData%InData_SrvD) ! InData_SrvD 
   call SrvD_UnpackInitOutput(RF, OutData%OutData_SrvD) ! OutData_SrvD 
   call AD_UnpackInitInput(RF, OutData%InData_AD) ! InData_AD 
   call AD_UnpackInitOutput(RF, OutData%OutData_AD) ! OutData_AD 
   call ADsk_UnpackInitInput(RF, OutData%InData_ADsk) ! InData_ADsk 
   call ADsk_UnpackInitOutput(RF, OutData%OutData_ADsk) ! OutData_ADsk 
   call ExtLd_UnpackInitInput(RF, OutData%InData_ExtLd) ! InData_ExtLd 
   call ExtLd_UnpackInitOutput(RF, OutData%OutData_ExtLd) ! OutData_ExtLd 
   call InflowWind_UnpackInitInput(RF, OutData%InData_IfW) ! InData_IfW 
   call InflowWind_UnpackInitOutput(RF, OutData%OutData_IfW) ! OutData_IfW 
   call ExtInfw_UnpackInitInput(RF, OutData%InData_ExtInfw) ! InData_ExtInfw 
   call ExtInfw_UnpackInitOutput(RF, OutData%OutData_ExtInfw) ! OutData_ExtInfw 
   call SeaSt_UnpackInitInput(RF, OutData%InData_SeaSt) ! InData_SeaSt 
   call SeaSt_UnpackInitOutput(RF, OutData%OutData_SeaSt) ! OutData_SeaSt 
   call HydroDyn_UnpackInitInput(RF, OutData%InData_HD) ! InData_HD 
   call HydroDyn_UnpackInitOutput(RF, OutData%OutData_HD) ! OutData_HD 
   call SD_UnpackInitInput(RF, OutData%InData_SD) ! InData_SD 
   call SD_UnpackInitOutput(RF, OutData%OutData_SD) ! OutData_SD 
   call ExtPtfm_UnpackInitInput(RF, OutData%InData_ExtPtfm) ! InData_ExtPtfm 
   call ExtPtfm_UnpackInitOutput(RF, OutData%OutData_ExtPtfm) ! OutData_ExtPtfm 
   call MAP_UnpackInitInput(RF, OutData%InData_MAP) ! InData_MAP 
   call MAP_UnpackInitOutput(RF, OutData%OutData_MAP) ! OutData_MAP 
   call FEAM_UnpackInitInput(RF, OutData%InData_FEAM) ! InData_FEAM 
   call FEAM_UnpackInitOutput(RF, OutData%OutData_FEAM) ! OutData_FEAM 
   call MD_UnpackInitInput(RF, OutData%InData_MD) ! InData_MD 
   call MD_UnpackInitOutput(RF, OutData%OutData_MD) ! OutData_MD 
   call Orca_UnpackInitInput(RF, OutData%InData_Orca) ! InData_Orca 
   call Orca_UnpackInitOutput(RF, OutData%OutData_Orca) ! OutData_Orca 
   call IceFloe_UnpackInitInput(RF, OutData%InData_IceF) ! InData_IceF 
   call IceFloe_UnpackInitOutput(RF, OutData%OutData_IceF) ! OutData_IceF 
   call IceD_UnpackInitInput(RF, OutData%InData_IceD) ! InData_IceD 
   call IceD_UnpackInitOutput(RF, OutData%OutData_IceD) ! OutData_IceD 
end subroutine

subroutine FAST_CopyExternInitType(SrcExternInitTypeData, DstExternInitTypeData, CtrlCode, ErrStat, ErrMsg)
   type(FAST_ExternInitType), intent(in) :: SrcExternInitTypeData
   type(FAST_ExternInitType), intent(inout) :: DstExternInitTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(5), UB(5)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'FAST_CopyExternInitType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstExternInitTypeData%Tmax = SrcExternInitTypeData%Tmax
   DstExternInitTypeData%TurbIDforName = SrcExternInitTypeData%TurbIDforName
   DstExternInitTypeData%TurbinePos = SrcExternInitTypeData%TurbinePos
   DstExternInitTypeData%WaveFieldMod = SrcExternInitTypeData%WaveFieldMod
   DstExternInitTypeData%FarmIntegration = SrcExternInitTypeData%FarmIntegration
   DstExternInitTypeData%windGrid_n = SrcExternInitTypeData%windGrid_n
   DstExternInitTypeData%windGrid_delta = SrcExternInitTypeData%windGrid_delta
   DstExternInitTypeData%windGrid_pZero = SrcExternInitTypeData%windGrid_pZero
   DstExternInitTypeData%windGrid_data => SrcExternInitTypeData%windGrid_data
   DstExternInitTypeData%RootName = SrcExternInitTypeData%RootName
   DstExternInitTypeData%NumActForcePtsBlade = SrcExternInitTypeData%NumActForcePtsBlade
   DstExternInitTypeData%NumActForcePtsTower = SrcExternInitTypeData%NumActForcePtsTower
   DstExternInitTypeData%NodeClusterType = SrcExternInitTypeData%NodeClusterType
   DstExternInitTypeData%DTdriver = SrcExternInitTypeData%DTdriver
   DstExternInitTypeData%TwrAero = SrcExternInitTypeData%TwrAero
   DstExternInitTypeData%az_blend_mean = SrcExternInitTypeData%az_blend_mean
   DstExternInitTypeData%az_blend_delta = SrcExternInitTypeData%az_blend_delta
end subroutine

subroutine FAST_DestroyExternInitType(ExternInitTypeData, ErrStat, ErrMsg)
   type(FAST_ExternInitType), intent(inout) :: ExternInitTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FAST_DestroyExternInitType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   nullify(ExternInitTypeData%windGrid_data)
end subroutine

subroutine FAST_PackExternInitType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FAST_ExternInitType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FAST_PackExternInitType'
   logical         :: PtrInIndex
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%Tmax)
   call RegPack(RF, InData%TurbIDforName)
   call RegPack(RF, InData%TurbinePos)
   call RegPack(RF, InData%WaveFieldMod)
   call RegPack(RF, InData%FarmIntegration)
   call RegPack(RF, InData%windGrid_n)
   call RegPack(RF, InData%windGrid_delta)
   call RegPack(RF, InData%windGrid_pZero)
   call RegPackPtr(RF, InData%windGrid_data)
   call RegPack(RF, InData%RootName)
   call RegPack(RF, InData%NumActForcePtsBlade)
   call RegPack(RF, InData%NumActForcePtsTower)
   call RegPack(RF, InData%NodeClusterType)
   call RegPack(RF, InData%DTdriver)
   call RegPack(RF, InData%TwrAero)
   call RegPack(RF, InData%az_blend_mean)
   call RegPack(RF, InData%az_blend_delta)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_UnPackExternInitType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FAST_ExternInitType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FAST_UnPackExternInitType'
   integer(B4Ki)   :: LB(5), UB(5)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   integer(B8Ki)   :: PtrIdx
   type(c_ptr)     :: Ptr
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%Tmax); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TurbIDforName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TurbinePos); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WaveFieldMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FarmIntegration); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%windGrid_n); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%windGrid_delta); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%windGrid_pZero); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackPtr(RF, OutData%windGrid_data, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumActForcePtsBlade); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumActForcePtsTower); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NodeClusterType); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DTdriver); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TwrAero); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%az_blend_mean); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%az_blend_delta); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_CopyTurbineType(SrcTurbineTypeData, DstTurbineTypeData, CtrlCode, ErrStat, ErrMsg)
   type(FAST_TurbineType), intent(inout) :: SrcTurbineTypeData
   type(FAST_TurbineType), intent(inout) :: DstTurbineTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_CopyTurbineType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstTurbineTypeData%TurbID = SrcTurbineTypeData%TurbID
   call FAST_CopyParam(SrcTurbineTypeData%p_FAST, DstTurbineTypeData%p_FAST, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call FAST_CopyOutputFileType(SrcTurbineTypeData%y_FAST, DstTurbineTypeData%y_FAST, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call FAST_CopyMisc(SrcTurbineTypeData%m_FAST, DstTurbineTypeData%m_FAST, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call FAST_CopyModuleMapType(SrcTurbineTypeData%MeshMapData, DstTurbineTypeData%MeshMapData, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call FAST_CopyElastoDyn_Data(SrcTurbineTypeData%ED, DstTurbineTypeData%ED, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call FAST_CopySED_Data(SrcTurbineTypeData%SED, DstTurbineTypeData%SED, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call FAST_CopyBeamDyn_Data(SrcTurbineTypeData%BD, DstTurbineTypeData%BD, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call FAST_CopyServoDyn_Data(SrcTurbineTypeData%SrvD, DstTurbineTypeData%SrvD, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call FAST_CopyAeroDyn_Data(SrcTurbineTypeData%AD, DstTurbineTypeData%AD, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call FAST_CopyAeroDisk_Data(SrcTurbineTypeData%ADsk, DstTurbineTypeData%ADsk, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call FAST_CopyExtLoads_Data(SrcTurbineTypeData%ExtLd, DstTurbineTypeData%ExtLd, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call FAST_CopyInflowWind_Data(SrcTurbineTypeData%IfW, DstTurbineTypeData%IfW, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call FAST_CopyExternalInflow_Data(SrcTurbineTypeData%ExtInfw, DstTurbineTypeData%ExtInfw, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call FAST_CopySeaState_Data(SrcTurbineTypeData%SeaSt, DstTurbineTypeData%SeaSt, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call FAST_CopyHydroDyn_Data(SrcTurbineTypeData%HD, DstTurbineTypeData%HD, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call FAST_CopySubDyn_Data(SrcTurbineTypeData%SD, DstTurbineTypeData%SD, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call FAST_CopyMAP_Data(SrcTurbineTypeData%MAP, DstTurbineTypeData%MAP, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call FAST_CopyFEAMooring_Data(SrcTurbineTypeData%FEAM, DstTurbineTypeData%FEAM, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call FAST_CopyMoorDyn_Data(SrcTurbineTypeData%MD, DstTurbineTypeData%MD, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call FAST_CopyOrcaFlex_Data(SrcTurbineTypeData%Orca, DstTurbineTypeData%Orca, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call FAST_CopyIceFloe_Data(SrcTurbineTypeData%IceF, DstTurbineTypeData%IceF, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call FAST_CopyIceDyn_Data(SrcTurbineTypeData%IceD, DstTurbineTypeData%IceD, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call FAST_CopyExtPtfm_Data(SrcTurbineTypeData%ExtPtfm, DstTurbineTypeData%ExtPtfm, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine FAST_DestroyTurbineType(TurbineTypeData, ErrStat, ErrMsg)
   type(FAST_TurbineType), intent(inout) :: TurbineTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FAST_DestroyTurbineType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call FAST_DestroyParam(TurbineTypeData%p_FAST, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FAST_DestroyOutputFileType(TurbineTypeData%y_FAST, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FAST_DestroyMisc(TurbineTypeData%m_FAST, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FAST_DestroyModuleMapType(TurbineTypeData%MeshMapData, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FAST_DestroyElastoDyn_Data(TurbineTypeData%ED, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FAST_DestroySED_Data(TurbineTypeData%SED, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FAST_DestroyBeamDyn_Data(TurbineTypeData%BD, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FAST_DestroyServoDyn_Data(TurbineTypeData%SrvD, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FAST_DestroyAeroDyn_Data(TurbineTypeData%AD, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FAST_DestroyAeroDisk_Data(TurbineTypeData%ADsk, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FAST_DestroyExtLoads_Data(TurbineTypeData%ExtLd, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FAST_DestroyInflowWind_Data(TurbineTypeData%IfW, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FAST_DestroyExternalInflow_Data(TurbineTypeData%ExtInfw, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FAST_DestroySeaState_Data(TurbineTypeData%SeaSt, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FAST_DestroyHydroDyn_Data(TurbineTypeData%HD, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FAST_DestroySubDyn_Data(TurbineTypeData%SD, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FAST_DestroyMAP_Data(TurbineTypeData%MAP, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FAST_DestroyFEAMooring_Data(TurbineTypeData%FEAM, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FAST_DestroyMoorDyn_Data(TurbineTypeData%MD, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FAST_DestroyOrcaFlex_Data(TurbineTypeData%Orca, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FAST_DestroyIceFloe_Data(TurbineTypeData%IceF, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FAST_DestroyIceDyn_Data(TurbineTypeData%IceD, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FAST_DestroyExtPtfm_Data(TurbineTypeData%ExtPtfm, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine FAST_PackTurbineType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FAST_TurbineType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FAST_PackTurbineType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%TurbID)
   call FAST_PackParam(RF, InData%p_FAST) 
   call FAST_PackOutputFileType(RF, InData%y_FAST) 
   call FAST_PackMisc(RF, InData%m_FAST) 
   call FAST_PackModuleMapType(RF, InData%MeshMapData) 
   call FAST_PackElastoDyn_Data(RF, InData%ED) 
   call FAST_PackSED_Data(RF, InData%SED) 
   call FAST_PackBeamDyn_Data(RF, InData%BD) 
   call FAST_PackServoDyn_Data(RF, InData%SrvD) 
   call FAST_PackAeroDyn_Data(RF, InData%AD) 
   call FAST_PackAeroDisk_Data(RF, InData%ADsk) 
   call FAST_PackExtLoads_Data(RF, InData%ExtLd) 
   call FAST_PackInflowWind_Data(RF, InData%IfW) 
   call FAST_PackExternalInflow_Data(RF, InData%ExtInfw) 
   call FAST_PackSeaState_Data(RF, InData%SeaSt) 
   call FAST_PackHydroDyn_Data(RF, InData%HD) 
   call FAST_PackSubDyn_Data(RF, InData%SD) 
   call FAST_PackMAP_Data(RF, InData%MAP) 
   call FAST_PackFEAMooring_Data(RF, InData%FEAM) 
   call FAST_PackMoorDyn_Data(RF, InData%MD) 
   call FAST_PackOrcaFlex_Data(RF, InData%Orca) 
   call FAST_PackIceFloe_Data(RF, InData%IceF) 
   call FAST_PackIceDyn_Data(RF, InData%IceD) 
   call FAST_PackExtPtfm_Data(RF, InData%ExtPtfm) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FAST_UnPackTurbineType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FAST_TurbineType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FAST_UnPackTurbineType'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%TurbID); if (RegCheckErr(RF, RoutineName)) return
   call FAST_UnpackParam(RF, OutData%p_FAST) ! p_FAST 
   call FAST_UnpackOutputFileType(RF, OutData%y_FAST) ! y_FAST 
   call FAST_UnpackMisc(RF, OutData%m_FAST) ! m_FAST 
   call FAST_UnpackModuleMapType(RF, OutData%MeshMapData) ! MeshMapData 
   call FAST_UnpackElastoDyn_Data(RF, OutData%ED) ! ED 
   call FAST_UnpackSED_Data(RF, OutData%SED) ! SED 
   call FAST_UnpackBeamDyn_Data(RF, OutData%BD) ! BD 
   call FAST_UnpackServoDyn_Data(RF, OutData%SrvD) ! SrvD 
   call FAST_UnpackAeroDyn_Data(RF, OutData%AD) ! AD 
   call FAST_UnpackAeroDisk_Data(RF, OutData%ADsk) ! ADsk 
   call FAST_UnpackExtLoads_Data(RF, OutData%ExtLd) ! ExtLd 
   call FAST_UnpackInflowWind_Data(RF, OutData%IfW) ! IfW 
   call FAST_UnpackExternalInflow_Data(RF, OutData%ExtInfw) ! ExtInfw 
   call FAST_UnpackSeaState_Data(RF, OutData%SeaSt) ! SeaSt 
   call FAST_UnpackHydroDyn_Data(RF, OutData%HD) ! HD 
   call FAST_UnpackSubDyn_Data(RF, OutData%SD) ! SD 
   call FAST_UnpackMAP_Data(RF, OutData%MAP) ! MAP 
   call FAST_UnpackFEAMooring_Data(RF, OutData%FEAM) ! FEAM 
   call FAST_UnpackMoorDyn_Data(RF, OutData%MD) ! MD 
   call FAST_UnpackOrcaFlex_Data(RF, OutData%Orca) ! Orca 
   call FAST_UnpackIceFloe_Data(RF, OutData%IceF) ! IceF 
   call FAST_UnpackIceDyn_Data(RF, OutData%IceD) ! IceD 
   call FAST_UnpackExtPtfm_Data(RF, OutData%ExtPtfm) ! ExtPtfm 
end subroutine
END MODULE FAST_Types
!ENDOFREGISTRYGENERATEDFILE
