!STARTOFREGISTRYGENERATEDFILE 'MoorDyn_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! MoorDyn_Types
!.................................................................................................................................
! This file is part of MoorDyn.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in MoorDyn. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE MoorDyn_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE SeaSt_WaveField_Types
USE NWTC_Library
IMPLICIT NONE
! =========  MD_InputFileType  =======
  TYPE, PUBLIC :: MD_InputFileType
    REAL(DbKi)  :: DTIC = 0.5      !< convergence check time step for IC generation [[s]]
    REAL(DbKi)  :: TMaxIC = 120      !< maximum time to allow for getting converged ICs [[s]]
    REAL(ReKi)  :: CdScaleIC = 1      !< factor to scale drag coefficients by during dynamic relaxation [[]]
    REAL(ReKi)  :: threshIC = 0.01      !< convergence tolerance for ICs  (0.01 means 1%) [[]]
  END TYPE MD_InputFileType
! =======================
! =========  MD_InitInputType  =======
  TYPE, PUBLIC :: MD_InitInputType
    REAL(ReKi)  :: g = -999.9      !< gravity constant [[m/s^2]]
    REAL(ReKi)  :: rhoW = -999.9      !< sea density [[kg/m^3]]
    REAL(ReKi)  :: WtrDepth = -999.9      !< depth of water [[m]]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PtfmInit      !< initial position of platform(s) shape: 6, nTurbines [-]
    INTEGER(IntKi)  :: FarmSize = 0      !< Indicates normal FAST module mode if 0, FAST.Farm coupled mode and =nTurbines if >1 [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: TurbineRefPos      !< reference position of turbines in farm, shape: 3, nTurbines [-]
    REAL(ReKi)  :: Tmax = 0.0_ReKi      !< simulation duration [[s]]
    CHARACTER(1024)  :: FileName      !< MoorDyn input file [-]
    CHARACTER(1024)  :: RootName      !< RootName for writing output files [-]
    LOGICAL  :: UsePrimaryInputFile = .TRUE.      !< Read input file instead of passed data [-]
    TYPE(FileInfoType)  :: PassedPrimaryInputData      !< Primary input file as FileInfoType (set by driver/glue code) -- String array with metadata [-]
    LOGICAL  :: Echo = .false.      !< echo parameter - do we want to echo the header line describing the input file? [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: OutList      !< string containing list of output channels requested in input file [-]
    LOGICAL  :: Linearize = .FALSE.      !< Flag that tells this module if the glue code wants to linearize. [-]
    LOGICAL  :: VisMeshes = .FALSE.      !< Glue code requesting visualization meshes [-]
    TYPE(SeaSt_WaveFieldType) , POINTER :: WaveField => NULL()      !< Pointer to SeaState wave field [-]
  END TYPE MD_InitInputType
! =======================
! =========  MD_LineProp  =======
  TYPE, PUBLIC :: MD_LineProp
    INTEGER(IntKi)  :: IdNum = 0_IntKi      !< integer identifier of this set of line properties [-]
    CHARACTER(20)  :: name      !< name/identifier of this set of line properties [-]
    REAL(DbKi)  :: d = 0.0_R8Ki      !< volume-equivalent diameter [[m]]
    REAL(DbKi)  :: w = 0.0_R8Ki      !< per-length weight in air [[kg/m]]
    REAL(DbKi)  :: EA = 0.0_R8Ki      !< axial stiffness [[N]]
    REAL(DbKi)  :: EA_D = 0.0_R8Ki      !< axial stiffness [[N]]
    REAL(DbKi)  :: alphaMBL = 0.0_R8Ki      !< dynamic stiffness constant: Krd alpha term x MBL [[N]]
    REAL(DbKi)  :: vbeta = 0.0_R8Ki      !< dynamic stiffness Lm slope: Krd beta term (to be multiplied by mean load) [[N]]
    REAL(DbKi)  :: BA = 0.0_R8Ki      !< internal damping coefficient times area [[N-s]]
    REAL(DbKi)  :: BA_D = 0.0_R8Ki      !< internal damping coefficient times area [[N-s]]
    REAL(DbKi)  :: EI = 0.0_R8Ki      !< bending stiffness [[N-m]]
    REAL(DbKi)  :: Can = 0.0_R8Ki      !< transverse added mass coefficient [-]
    REAL(DbKi)  :: Cat = 0.0_R8Ki      !< tangential added mass coefficient [-]
    REAL(DbKi)  :: Cdn = 0.0_R8Ki      !< transverse drag coefficient [-]
    REAL(DbKi)  :: Cdt = 0.0_R8Ki      !< tangential drag coefficient [-]
    REAL(DbKi)  :: Cl = 0.0_R8Ki      !< VIV lift coefficient. If 0, VIV turned off [-]
    REAL(DbKi)  :: dF = 0.0_R8Ki      !< +- range of VIV synchronization in non-dimensional frequency [-]
    REAL(DbKi)  :: cF = 0.0_R8Ki      !< Center VIV synchronization in non-dimensional frequency [-]
    INTEGER(IntKi)  :: ElasticMod = 0_IntKi      !< Which elasticity model to use: {1 basic, 2 viscoelastic, 3 viscoelastic+meanload}  [-]
    INTEGER(IntKi)  :: nEApoints = 0_IntKi      !< number of values in stress-strain lookup table (0 means using constant E) [-]
    REAL(DbKi) , DIMENSION(1:30)  :: stiffXs = 0.0_R8Ki      !< x array for stress-strain lookup table (up to nCoef) [-]
    REAL(DbKi) , DIMENSION(1:30)  :: stiffYs = 0.0_R8Ki      !< y array for stress-strain lookup table [-]
    INTEGER(IntKi)  :: nBApoints = 0_IntKi      !< number of values in stress-strainrate lookup table (0 means using constant c) [-]
    REAL(DbKi) , DIMENSION(1:30)  :: dampXs = 0.0_R8Ki      !< x array for stress-strainrate lookup table (up to nCoef) [-]
    REAL(DbKi) , DIMENSION(1:30)  :: dampYs = 0.0_R8Ki      !< y array for stress-strainrate lookup table [-]
    INTEGER(IntKi)  :: nEIpoints = 0_IntKi      !< number of values in bending stress-strain lookup table (0 means using constant E) [-]
    REAL(DbKi) , DIMENSION(1:30)  :: bstiffXs = 0.0_R8Ki      !< x array for stress-strain lookup table (up to nCoef) [-]
    REAL(DbKi) , DIMENSION(1:30)  :: bstiffYs = 0.0_R8Ki      !< y array for stress-strain lookup table [-]
  END TYPE MD_LineProp
! =======================
! =========  MD_RodProp  =======
  TYPE, PUBLIC :: MD_RodProp
    INTEGER(IntKi)  :: IdNum = 0_IntKi      !< integer identifier of this set of rod properties [-]
    CHARACTER(10)  :: name      !< name/identifier of this set of rod properties [-]
    REAL(DbKi)  :: d = 0.0_R8Ki      !< volume-equivalent diameter [[m]]
    REAL(DbKi)  :: w = 0.0_R8Ki      !< per-length weight in air [[kg/m]]
    REAL(DbKi)  :: Can = 0.0_R8Ki      !< transverse added mass coefficient [-]
    REAL(DbKi)  :: Cat = 0.0_R8Ki      !< tangential added mass coefficient [-]
    REAL(DbKi)  :: Cdn = 0.0_R8Ki      !< transverse drag coefficient [-]
    REAL(DbKi)  :: Cdt = 0.0_R8Ki      !< tangential drag coefficient [-]
    REAL(DbKi)  :: CdEnd = 0.0_R8Ki      !< drag coefficient for rod end [[-]]
    REAL(DbKi)  :: CaEnd = 0.0_R8Ki      !< added mass coefficient for rod end [[-]]
  END TYPE MD_RodProp
! =======================
! =========  MD_Body  =======
  TYPE, PUBLIC :: MD_Body
    INTEGER(IntKi)  :: IdNum = 0_IntKi      !< integer identifier of this Point [-]
    INTEGER(IntKi)  :: typeNum = 0_IntKi      !< integer identifying the type.  0=free, 1=fixed, -1=coupled, 2=coupledpinned [-]
    INTEGER(IntKi) , DIMENSION(1:30)  :: AttachedC = 0_IntKi      !< list of IdNums of points attached to this body [-]
    INTEGER(IntKi) , DIMENSION(1:30)  :: AttachedR = 0_IntKi      !< list of IdNums of rods attached to this body [-]
    INTEGER(IntKi)  :: nAttachedP = 0_IntKi      !< number of attached points [-]
    INTEGER(IntKi)  :: nAttachedR = 0_IntKi      !< number of attached rods [-]
    REAL(DbKi) , DIMENSION(1:3,1:30)  :: rPointRel = 0.0_R8Ki      !< relative position of point on body [-]
    REAL(DbKi) , DIMENSION(1:6,1:30)  :: r6RodRel = 0.0_R8Ki      !< relative position and orientation of rod on body [-]
    REAL(DbKi)  :: bodyM = 0.0_R8Ki      !< body mass (separate from attached objects) [[kg]]
    REAL(DbKi)  :: bodyV = 0.0_R8Ki      !< body volume (for buoyancy calculation) [[m^3]]
    REAL(DbKi) , DIMENSION(1:3)  :: bodyI = 0.0_R8Ki      !< body 3x3 inertia matrix diagonals [[kg-m^2]]
    REAL(DbKi) , DIMENSION(1:6)  :: bodyCdA = 0.0_R8Ki      !< product of drag force and frontal area of body [[m^2]]
    REAL(DbKi) , DIMENSION(1:6)  :: bodyCa = 0.0_R8Ki      !< added mass coefficient of body [-]
    REAL(DbKi)  :: time = 0.0_R8Ki      !< current time [[s]]
    REAL(DbKi) , DIMENSION(1:6)  :: r6 = 0.0_R8Ki      !< position [-]
    REAL(DbKi) , DIMENSION(1:6)  :: v6 = 0.0_R8Ki      !< velocity [-]
    REAL(DbKi) , DIMENSION(1:6)  :: a6 = 0.0_R8Ki      !< acceleration (only used for coupled bodies) [-]
    REAL(DbKi) , DIMENSION(1:3)  :: U = 0.0_R8Ki      !< water velocity at ref point [[m/s]]
    REAL(DbKi) , DIMENSION(1:3)  :: Ud = 0.0_R8Ki      !< water acceleration at ref point [[m/s^2]]
    REAL(DbKi)  :: zeta = 0.0_R8Ki      !< water surface elevation above ref point [[m]]
    REAL(DbKi) , DIMENSION(1:6)  :: F6net = 0.0_R8Ki      !< total force and moment on body (excluding inertial loads) [-]
    REAL(DbKi) , DIMENSION(1:6,1:6)  :: M6net = 0.0_R8Ki      !< total mass matrix of Body and any attached objects [-]
    REAL(DbKi) , DIMENSION(1:6,1:6)  :: M = 0.0_R8Ki      !< rotated body 6-dof mass and inertia matrix in global orientation [-]
    REAL(DbKi) , DIMENSION(1:6,1:6)  :: M0 = 0.0_R8Ki      !< body 6-dof mass and inertia matrix in its own frame [-]
    REAL(DbKi) , DIMENSION(1:3,1:3)  :: OrMat = 0.0_R8Ki      !< DCM for body orientation [-]
    REAL(DbKi) , DIMENSION(1:3)  :: rCG = 0.0_R8Ki      !< vector in body frame from ref point to CG (before rods etc..) [-]
    REAL(DbKi) , DIMENSION(1:3)  :: FextG = 0.0_R8Ki      !< vector of user-defined external force on the body in the global frame [[N]]
    REAL(DbKi) , DIMENSION(1:3)  :: BlinG = 0.0_R8Ki      !< user-defined linear translational damping on the body in the global frame [[N/(m/s)]]
    REAL(DbKi) , DIMENSION(1:3)  :: BquadG = 0.0_R8Ki      !< user-defined quadratic translational damping on the body in the global frame [[N/(m/s)^2]]
    REAL(DbKi) , DIMENSION(1:3)  :: FextL = 0.0_R8Ki      !< vector of user-defined external force on the body in the local body-fixed frame [[N]]
    REAL(DbKi) , DIMENSION(1:3)  :: BlinL = 0.0_R8Ki      !< user-defined linear translational damping on the body in the local body-fixed frame [[N/(m/s)]]
    REAL(DbKi) , DIMENSION(1:3)  :: BquadL = 0.0_R8Ki      !< user-defined quadratic translational damping on the body in the local body-fixed frame [[N/(m/s)^2]]
  END TYPE MD_Body
! =======================
! =========  MD_Point  =======
  TYPE, PUBLIC :: MD_Point
    INTEGER(IntKi)  :: IdNum = 0_IntKi      !< integer identifier of this point [-]
    CHARACTER(10)  :: type      !< type of point: fix, vessel, point [-]
    INTEGER(IntKi)  :: typeNum = 0_IntKi      !< integer identifying the type.  1=fixed, -1=coupled, 0=free [-]
    INTEGER(IntKi) , DIMENSION(1:10)  :: Attached = 0_IntKi      !< list of IdNums of lines attached to this point node [-]
    INTEGER(IntKi) , DIMENSION(1:10)  :: Top = 0_IntKi      !< list of ints specifying whether each line is attached at 1 = top/fairlead(end B), 0 = bottom/anchor(end A) [-]
    INTEGER(IntKi)  :: nAttached = 0_IntKi      !< number of attached lines [-]
    REAL(DbKi)  :: pointM = 0.0_R8Ki      !< point mass [[kg]]
    REAL(DbKi)  :: pointV = 0.0_R8Ki      !< point volume [[m^3]]
    REAL(DbKi)  :: pointFX = 0.0_R8Ki      !<  [-]
    REAL(DbKi)  :: pointFY = 0.0_R8Ki      !<  [-]
    REAL(DbKi)  :: pointFZ = 0.0_R8Ki      !<  [-]
    REAL(DbKi)  :: pointCa = 0.0_R8Ki      !< added mass coefficient of point [-]
    REAL(DbKi)  :: pointCdA = 0.0_R8Ki      !< product of drag force and frontal area of point [[m^2]]
    REAL(DbKi)  :: time = 0.0_R8Ki      !< current time [[s]]
    REAL(DbKi) , DIMENSION(1:3)  :: r = 0.0_R8Ki      !< position [-]
    REAL(DbKi) , DIMENSION(1:3)  :: rd = 0.0_R8Ki      !< velocity [-]
    REAL(DbKi) , DIMENSION(1:3)  :: a = 0.0_R8Ki      !< acceleration (only used for coupled points) [-]
    REAL(DbKi) , DIMENSION(1:3)  :: U = 0.0_R8Ki      !< water velocity at node [[m/s]]
    REAL(DbKi) , DIMENSION(1:3)  :: Ud = 0.0_R8Ki      !< water acceleration at node [[m/s^2]]
    REAL(DbKi)  :: zeta = 0.0_R8Ki      !< water surface elevation above node [[m]]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: PDyn      !< water dynamic pressure at node [[Pa]]
    REAL(DbKi) , DIMENSION(1:3)  :: Fnet = 0.0_R8Ki      !< total force on node (excluding inertial loads) [-]
    REAL(DbKi) , DIMENSION(1:3,1:3)  :: M = 0.0_R8Ki      !< node mass matrix, from attached lines [-]
    REAL(DbKi) , DIMENSION(1:3)  :: Fext = 0.0_R8Ki      !< vector of user-defined external force on the point always in the global frame [[N]]
    REAL(DbKi) , DIMENSION(1:3)  :: Blin = 0.0_R8Ki      !< user-defined linear translational damping on the point always in the global frame [[N/(m/s)]]
    REAL(DbKi) , DIMENSION(1:3)  :: Bquad = 0.0_R8Ki      !< user-defined quadratic translational damping on the point always in the global frame [[N/(m/s)^2]]
  END TYPE MD_Point
! =======================
! =========  MD_Rod  =======
  TYPE, PUBLIC :: MD_Rod
    INTEGER(IntKi)  :: IdNum = 0_IntKi      !< integer identifier of this Line [-]
    CHARACTER(10)  :: type      !< type of Rod.  should match one of RodProp names [-]
    INTEGER(IntKi)  :: PropsIdNum = 0_IntKi      !< the IdNum of the associated rod properties [-]
    INTEGER(IntKi)  :: typeNum = 0_IntKi      !< integer identifying the type.  0=free, 1=pinned, 2=fixed, -1=coupledpinned, -2=coupled [-]
    INTEGER(IntKi) , DIMENSION(1:10)  :: AttachedA = 0_IntKi      !< list of IdNums of lines attached to end A [-]
    INTEGER(IntKi) , DIMENSION(1:10)  :: AttachedB = 0_IntKi      !< list of IdNums of lines attached to end B [-]
    INTEGER(IntKi) , DIMENSION(1:10)  :: TopA = 0_IntKi      !< list of ints specifying whether each line is attached at 1 = top/fairlead(end B), 0 = bottom/anchor(end A) [-]
    INTEGER(IntKi) , DIMENSION(1:10)  :: TopB = 0_IntKi      !< list of ints specifying whether each line is attached at 1 = top/fairlead(end B), 0 = bottom/anchor(end A) [-]
    INTEGER(IntKi)  :: nAttachedA = 0_IntKi      !< number of attached lines to Rod end A [-]
    INTEGER(IntKi)  :: nAttachedB = 0_IntKi      !< number of attached lines to Rod end B [-]
    INTEGER(IntKi) , DIMENSION(1:20)  :: OutFlagList = 0_IntKi      !< array specifying what line quantities should be output (1 vs 0) [-]
    INTEGER(IntKi)  :: N = 0_IntKi      !< The number of elements in the line [-]
    INTEGER(IntKi)  :: endTypeA = 0_IntKi      !< type of point at end A: 0=pinned to Point, 1=cantilevered to Rod. [-]
    INTEGER(IntKi)  :: endTypeB = 0_IntKi      !< type of point at end B: 0=pinned to Point, 1=cantilevered to Rod. [-]
    REAL(DbKi)  :: UnstrLen = 0.0_R8Ki      !< length of the rod [[m]]
    REAL(DbKi)  :: mass = 0.0_R8Ki      !< mass of the rod [[kg]]
    REAL(DbKi)  :: rho = 0.0_R8Ki      !< density [[kg/m3]]
    REAL(DbKi)  :: d = 0.0_R8Ki      !< volume-equivalent diameter [[m]]
    REAL(DbKi)  :: Can = 0.0_R8Ki      !<  [[-]]
    REAL(DbKi)  :: Cat = 0.0_R8Ki      !<  [[-]]
    REAL(DbKi)  :: Cdn = 0.0_R8Ki      !<  [[-]]
    REAL(DbKi)  :: Cdt = 0.0_R8Ki      !<  [[-]]
    REAL(DbKi)  :: CdEnd = 0.0_R8Ki      !< drag coefficient for rod end [[-]]
    REAL(DbKi)  :: CaEnd = 0.0_R8Ki      !< added mass coefficient for rod end [[-]]
    REAL(DbKi)  :: time = 0.0_R8Ki      !< current time [[s]]
    REAL(DbKi)  :: roll = 0.0_R8Ki      !< roll relative to vertical [[rad]]
    REAL(DbKi)  :: pitch = 0.0_R8Ki      !< pitch relative to vertical [[rad]]
    REAL(DbKi)  :: h0 = 0.0_R8Ki      !< submerged length of rod axis, distance along rod centerline from end A to the waterplane (0 <= h0 <= L) [m]
    REAL(DbKi) , DIMENSION(:,:), ALLOCATABLE  :: r      !< node positions [-]
    REAL(DbKi) , DIMENSION(:,:), ALLOCATABLE  :: rd      !< node velocities [-]
    REAL(DbKi) , DIMENSION(1:3)  :: q = 0.0_R8Ki      !< tangent vector for rod as a whole [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: l      !< segment unstretched length [[m]]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: V      !< segment volume [[m^3]]
    REAL(DbKi) , DIMENSION(:,:), ALLOCATABLE  :: U      !< water velocity at node [[m/s]]
    REAL(DbKi) , DIMENSION(:,:), ALLOCATABLE  :: Ud      !< water acceleration at node [[m/s^2]]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: zeta      !< water surface elevation above node [[m]]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: PDyn      !< water dynamic pressure at node [[Pa]]
    REAL(DbKi) , DIMENSION(:,:), ALLOCATABLE  :: W      !< weight vectors [[N]]
    REAL(DbKi) , DIMENSION(:,:), ALLOCATABLE  :: Bo      !< buoyancy force vectors [[N]]
    REAL(DbKi) , DIMENSION(:,:), ALLOCATABLE  :: Pd      !< dynamic pressure force vectors [[N]]
    REAL(DbKi) , DIMENSION(:,:), ALLOCATABLE  :: Dp      !< node drag (transverse) [[N]]
    REAL(DbKi) , DIMENSION(:,:), ALLOCATABLE  :: Dq      !< node drag (axial) [[N]]
    REAL(DbKi) , DIMENSION(:,:), ALLOCATABLE  :: Ap      !< node added mass forcing (transverse) [[N]]
    REAL(DbKi) , DIMENSION(:,:), ALLOCATABLE  :: Aq      !< node added mass forcing (axial) [[N]]
    REAL(DbKi) , DIMENSION(:,:), ALLOCATABLE  :: B      !< node bottom contact force [[N]]
    REAL(DbKi) , DIMENSION(:,:), ALLOCATABLE  :: Bp      !< transverse damping force [[N]]
    REAL(DbKi) , DIMENSION(:,:), ALLOCATABLE  :: Bq      !< axial damping force [[N]]
    REAL(DbKi) , DIMENSION(:,:), ALLOCATABLE  :: Fnet      !< total force on node [[N]]
    REAL(DbKi) , DIMENSION(:,:,:), ALLOCATABLE  :: M      !< node mass matrix [[kg]]
    REAL(DbKi) , DIMENSION(1:3)  :: FextA = 0.0_R8Ki      !< external forces from attached lines on/about end A  [-]
    REAL(DbKi) , DIMENSION(1:3)  :: FextB = 0.0_R8Ki      !< external forces from attached lines on/about end A  [-]
    REAL(DbKi) , DIMENSION(1:3)  :: Mext = 0.0_R8Ki      !< external moment vector holding sum of any externally applied moments i.e. bending lines [-]
    REAL(DbKi) , DIMENSION(1:6)  :: r6 = 0.0_R8Ki      !< 6 DOF position vector [-]
    REAL(DbKi) , DIMENSION(1:6)  :: v6 = 0.0_R8Ki      !< 6 DOF velocity vector [-]
    REAL(DbKi) , DIMENSION(1:6)  :: a6 = 0.0_R8Ki      !< 6 DOF acceleration vector (only used for coupled Rods) [-]
    REAL(DbKi) , DIMENSION(1:6)  :: F6net = 0.0_R8Ki      !< total force and moment about end A (excluding inertial loads) that Rod may exert on whatever it's attached to [-]
    REAL(DbKi) , DIMENSION(1:6,1:6)  :: M6net = 0.0_R8Ki      !< total mass matrix about end A of Rod and any attached Points [-]
    REAL(DbKi) , DIMENSION(1:3,1:3)  :: Imat = 0.0_R8Ki      !< inertia about CG in global frame [-]
    REAL(DbKi) , DIMENSION(1:3,1:3)  :: OrMat = 0.0_R8Ki      !< DCM for body orientation [-]
    INTEGER(IntKi)  :: RodUnOut = 0_IntKi      !< unit number of rod output file [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: RodWrOutput      !< one row of output data for this rod [-]
    REAL(DbKi) , DIMENSION(1:3)  :: FextU = 0.0_R8Ki      !< vector of user-defined external force on the rod end A always in the local body-fixed frame [[N]]
    REAL(DbKi) , DIMENSION(1:2)  :: Blin = 0.0_R8Ki      !< linear damping, transverse damping for rod element always in the local body-fixed frame [[N/(m/s)]]
    REAL(DbKi) , DIMENSION(1:2)  :: Bquad = 0.0_R8Ki      !< quadratic damping, transverse damping for rod element always in the local body-fixed frame [[N/(m/s)^2]]
  END TYPE MD_Rod
! =======================
! =========  MD_Line  =======
  TYPE, PUBLIC :: MD_Line
    INTEGER(IntKi)  :: IdNum = 0_IntKi      !< integer identifier of this Line [-]
    INTEGER(IntKi)  :: PropsIdNum = 0_IntKi      !< the IdNum of the associated line properties [-]
    INTEGER(IntKi)  :: ElasticMod = 0_IntKi      !< Which elasticity model to use: {1 basic, 2 viscoelastic, 3 viscoelastic+meanload}  [-]
    INTEGER(IntKi) , DIMENSION(1:20)  :: OutFlagList = 0_IntKi      !< array specifying what line quantities should be output (1 vs 0) [-]
    INTEGER(IntKi)  :: CtrlChan = 0_IntKi      !< index of control channel that will drive line active tensioning (0 for none) [-]
    INTEGER(IntKi)  :: FairPoint = 0_IntKi      !< IdNum of Point at fairlead [-]
    INTEGER(IntKi)  :: AnchPoint = 0_IntKi      !< IdNum of Point at anchor [-]
    INTEGER(IntKi)  :: N = 0_IntKi      !< The number of elements in the line [-]
    INTEGER(IntKi)  :: endTypeA = 0_IntKi      !< type of connection at end A: 0=pinned to Point, 1=cantilevered to Rod. [-]
    INTEGER(IntKi)  :: endTypeB = 0_IntKi      !< type of connection at end B: 0=pinned to Point, 1=cantilevered to Rod. [-]
    REAL(DbKi)  :: UnstrLen = 0.0_R8Ki      !< unstretched length of the line [-]
    REAL(DbKi)  :: rho = 0.0_R8Ki      !< density [[kg/m3]]
    REAL(DbKi)  :: d = 0.0_R8Ki      !< volume-equivalent diameter [[m]]
    REAL(DbKi)  :: EA = 0.0_R8Ki      !< stiffness [[N]]
    REAL(DbKi)  :: EA_D = 0.0_R8Ki      !< constant dynamic stiffness when using viscoelastic model [[N]]
    REAL(DbKi)  :: alphaMBL = 0.0_R8Ki      !< load dependent dynamic stiffness constant: Krd alpha term x MBL [[N]]
    REAL(DbKi)  :: vbeta = 0.0_R8Ki      !< load dependent dynamic stiffness Lm slope: Krd beta term (to be multiplied by mean load) [[N]]
    REAL(DbKi)  :: BA = 0.0_R8Ki      !< internal damping coefficient times area for this line only [[N-s]]
    REAL(DbKi)  :: BA_D = 0.0_R8Ki      !< dynamic internal damping coefficient times area when using viscoelastic model [[N-s]]
    REAL(DbKi)  :: EI = 0.0_R8Ki      !< bending stiffness [[N-m]]
    REAL(DbKi)  :: Can = 0.0_R8Ki      !<  [[-]]
    REAL(DbKi)  :: Cat = 0.0_R8Ki      !<  [[-]]
    REAL(DbKi)  :: Cdn = 0.0_R8Ki      !<  [[-]]
    REAL(DbKi)  :: Cdt = 0.0_R8Ki      !<  [[-]]
    REAL(DbKi)  :: Cl = 0.0_R8Ki      !< VIV lift coefficient. If 0, VIV turned off [-]
    REAL(DbKi)  :: dF = 0.0_R8Ki      !< +- range of VIV synchronization in non-dimensional frequency [-]
    REAL(DbKi)  :: cF = 0.0_R8Ki      !< Center VIV synchronization in non-dimensional frequency [-]
    INTEGER(IntKi)  :: nEApoints = 0_IntKi      !< number of values in stress-strain lookup table (0 means using constant E) [-]
    REAL(DbKi) , DIMENSION(1:30)  :: stiffXs = 0.0_R8Ki      !< x array for stress-strain lookup table (up to nCoef) [-]
    REAL(DbKi) , DIMENSION(1:30)  :: stiffYs = 0.0_R8Ki      !< y array for stress-strain lookup table [-]
    INTEGER(IntKi)  :: nBApoints = 0_IntKi      !< number of values in stress-strainrate lookup table (0 means using constant c) [-]
    REAL(DbKi) , DIMENSION(1:30)  :: dampXs = 0.0_R8Ki      !< x array for stress-strainrate lookup table (up to nCoef) [-]
    REAL(DbKi) , DIMENSION(1:30)  :: dampYs = 0.0_R8Ki      !< y array for stress-strainrate lookup table [-]
    INTEGER(IntKi)  :: nEIpoints = 0_IntKi      !< number of values in bending stress-strain lookup table (0 means using constant E) [-]
    REAL(DbKi) , DIMENSION(1:30)  :: bstiffXs = 0.0_R8Ki      !< x array for stress-strain lookup table (up to nCoef) [-]
    REAL(DbKi) , DIMENSION(1:30)  :: bstiffYs = 0.0_R8Ki      !< y array for stress-strain lookup table [-]
    REAL(DbKi)  :: time = 0.0_R8Ki      !< current time [[s]]
    REAL(DbKi) , DIMENSION(:,:), ALLOCATABLE  :: r      !< node positions [-]
    REAL(DbKi) , DIMENSION(:,:), ALLOCATABLE  :: rd      !< node velocities [-]
    REAL(DbKi) , DIMENSION(:,:), ALLOCATABLE  :: q      !< node tangent vectors [-]
    REAL(DbKi) , DIMENSION(:,:), ALLOCATABLE  :: qs      !< segment tangent vectors [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: l      !< segment unstretched length [[m]]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: ld      !< segment unstretched length rate of change (used in active tensioning) [[m]]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: lstr      !< segment stretched length [[m]]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: lstrd      !< segment change in stretched length [[m/s]]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: Kurv      !< curvature at each node point [[1/m]]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: dl_1      !< segment stretch attributed to static stiffness portion [[m]]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: V      !< segment volume [[m^3]]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: F      !< VOF scalar for each segment (1 = fully submerged, 0 = out of water) [-]
    REAL(DbKi) , DIMENSION(:,:), ALLOCATABLE  :: U      !< water velocity at node [[m/s]]
    REAL(DbKi) , DIMENSION(:,:), ALLOCATABLE  :: Ud      !< water acceleration at node [[m/s^2]]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: zeta      !< water surface elevation above node [[m]]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: PDyn      !< water dynamic pressure at node [[Pa]]
    REAL(DbKi) , DIMENSION(:,:), ALLOCATABLE  :: T      !< segment tension vectors [[N]]
    REAL(DbKi) , DIMENSION(:,:), ALLOCATABLE  :: Td      !< segment internal damping force vectors [[N]]
    REAL(DbKi) , DIMENSION(:,:), ALLOCATABLE  :: W      !< weight/buoyancy vectors [[N]]
    REAL(DbKi) , DIMENSION(:,:), ALLOCATABLE  :: Dp      !< node drag (transverse) [[N]]
    REAL(DbKi) , DIMENSION(:,:), ALLOCATABLE  :: Dq      !< node drag (axial) [[N]]
    REAL(DbKi) , DIMENSION(:,:), ALLOCATABLE  :: Ap      !< node added mass forcing (transverse) [[N]]
    REAL(DbKi) , DIMENSION(:,:), ALLOCATABLE  :: Aq      !< node added mass forcing (axial) [[N]]
    REAL(DbKi) , DIMENSION(:,:), ALLOCATABLE  :: B      !< node bottom contact force [[N]]
    REAL(DbKi) , DIMENSION(:,:), ALLOCATABLE  :: Bs      !< node force due to bending moments [[N]]
    REAL(DbKi) , DIMENSION(:,:), ALLOCATABLE  :: Lf      !< node crossflow viv lift force. TODO this will have to be allocated for only internal after fix [[N]]
    REAL(DbKi) , DIMENSION(:,:), ALLOCATABLE  :: Fnet      !< total force on node [[N]]
    REAL(DbKi) , DIMENSION(:,:,:), ALLOCATABLE  :: S      !< node inverse mass matrix [[kg]]
    REAL(DbKi) , DIMENSION(:,:,:), ALLOCATABLE  :: M      !< node mass matrix [[kg]]
    REAL(DbKi) , DIMENSION(1:3)  :: EndMomentA = 0.0_R8Ki      !< vector of end moments due to bending at line end A [[N-m]]
    REAL(DbKi) , DIMENSION(1:3)  :: EndMomentB = 0.0_R8Ki      !< vector of end moments due to bending at line end B [[N-m]]
    INTEGER(IntKi)  :: LineUnOut = 0_IntKi      !< unit number of line output file [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: LineWrOutput      !< one row of output data for this line [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: phi      !< phase of lift force [-]
    REAL(DbKi)  :: n_m = 500      !< Num timesteps for rolling RMS of crossflow velocity phase [-]
    REAL(DbKi)  :: phi_yd = 0.0_R8Ki      !< The crossflow motion phase [-]
    REAL(DbKi)  :: t_old = 0.0_R8Ki      !< old t [s]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: yd_rms_old      !< node old cf vel rms [m/s]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: ydd_rms_old      !< node old cf accel rms [m/s^2]
    REAL(DbKi) , DIMENSION(:,:), ALLOCATABLE  :: rdd_old      !< node accelerations previous iteration [m/s^2]
  END TYPE MD_Line
! =======================
! =========  MD_ExtLd  =======
  TYPE, PUBLIC :: MD_ExtLd
    INTEGER(IntKi)  :: IdNum = 0_IntKi      !< integer identifier of this external load entry [-]
    REAL(DbKi) , DIMENSION(1:3)  :: Fext = 0.0_R8Ki      !< user-defined external force on the object [[N]]
    REAL(DbKi) , DIMENSION(1:3)  :: Blin = 0.0_R8Ki      !< user-defined linear translational damping on the object [[N/(m/s)]]
    REAL(DbKi) , DIMENSION(1:3)  :: Bquad = 0.0_R8Ki      !< user-defined quadratic translational damping on the object [[N/(m/s)^2]]
    LOGICAL  :: isGlobal = .false.      !< external forces and damping to be applied in the global frame of reference [-]
  END TYPE MD_ExtLd
! =======================
! =========  MD_Fail  =======
  TYPE, PUBLIC :: MD_Fail
    INTEGER(IntKi)  :: IdNum = 0_IntKi      !< integer identifier of this failure [-]
    INTEGER(IntKi)  :: attachID = 0_IntKi      !< ID of connection or Rod the lines are attached to [-]
    INTEGER(IntKi)  :: isRod = 0_IntKi      !< 1 Rod end A, 2 Rod end B, 0 if point [-]
    INTEGER(IntKi) , DIMENSION(1:30)  :: lineIDs = 0_IntKi      !< array of one or more lines to detach (starting from 1...) [-]
    INTEGER(IntKi) , DIMENSION(1:30)  :: lineTops = 0_IntKi      !< an array that will be FILLED IN to return which end of each line was disconnected ... 1 = top/fairlead(end B), 0 = bottom/anchor(end A) [-]
    INTEGER(IntKi)  :: nLinesToDetach = 0_IntKi      !< how many lines to dettach [-]
    REAL(DbKi)  :: failTime = 0.0_R8Ki      !< time of failure [s]
    REAL(DbKi)  :: failTen = 0.0_R8Ki      !< tension threshold of failure [N]
    INTEGER(IntKi)  :: failStatus = 0_IntKi      !< 0 not failed yet, 1 failed, 2 invalid [-]
  END TYPE MD_Fail
! =======================
! =========  MD_OutParmType  =======
  TYPE, PUBLIC :: MD_OutParmType
    CHARACTER(10)  :: Name      !< name of output channel [-]
    CHARACTER(10)  :: Units      !< units string [-]
    INTEGER(IntKi)  :: QType = 0_IntKi      !< type of quantity - 0=tension, 1=x, 2=y, 3=z... [-]
    INTEGER(IntKi)  :: OType = 0_IntKi      !< type of object - 0=line, 1=point [-]
    INTEGER(IntKi)  :: NodeID = 0_IntKi      !< node number if OType=0.  0=anchor, -1=whole object [-]
    INTEGER(IntKi)  :: ObjID = 0_IntKi      !< number of Point or Line object [-]
  END TYPE MD_OutParmType
! =======================
! =========  VisDiam  =======
  TYPE, PUBLIC :: VisDiam
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: Diam      !< Diameter for visualization [-]
  END TYPE VisDiam
! =======================
! =========  MD_InitOutputType  =======
  TYPE, PUBLIC :: MD_InitOutputType
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: writeOutputHdr      !< first line output file contents: output variable names [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: writeOutputUnt      !< second line of output file contents: units [-]
    TYPE(ProgDesc)  :: Ver      !< this module's name, version, and date [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: CableCChanRqst      !< flag indicating control channel for drive line active tensioning is requested [-]
    CHARACTER(LinChanLen) , DIMENSION(:), ALLOCATABLE  :: LinNames_y      !< Names of the outputs used in linearization [-]
    CHARACTER(LinChanLen) , DIMENSION(:), ALLOCATABLE  :: LinNames_x      !< Names of the continuous states used in linearization [-]
    CHARACTER(LinChanLen) , DIMENSION(:), ALLOCATABLE  :: LinNames_u      !< Names of the inputs used in linearization [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: RotFrame_y      !< Flag that tells FAST/MBC3 if the outputs used in linearization are in the rotating frame [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: RotFrame_x      !< Flag that tells FAST/MBC3 if the continuous states used in linearization are in the rotating frame (not used for glue) [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: RotFrame_u      !< Flag that tells FAST/MBC3 if the inputs used in linearization are in the rotating frame [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: IsLoad_u      !< Flag that tells FAST if the inputs used in linearization are loads (for preconditioning matrix) [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: DerivOrder_x      !< Integer that tells FAST/MBC3 the maximum derivative order of continuous states used in linearization [-]
  END TYPE MD_InitOutputType
! =======================
! =========  MD_ContinuousStateType  =======
  TYPE, PUBLIC :: MD_ContinuousStateType
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: states      !< state vector of mooring system, e.g. node coordinates and velocities []
  END TYPE MD_ContinuousStateType
! =======================
! =========  MD_DiscreteStateType  =======
  TYPE, PUBLIC :: MD_DiscreteStateType
    REAL(SiKi)  :: dummy = 0.0_R4Ki      !< Remove this variable if you have discrete states [-]
  END TYPE MD_DiscreteStateType
! =======================
! =========  MD_ConstraintStateType  =======
  TYPE, PUBLIC :: MD_ConstraintStateType
    REAL(SiKi)  :: dummy = 0.0_R4Ki      !< Remove this variable if you have constraint states [-]
  END TYPE MD_ConstraintStateType
! =======================
! =========  MD_OtherStateType  =======
  TYPE, PUBLIC :: MD_OtherStateType
    REAL(SiKi)  :: dummy = 0.0_R4Ki      !< Remove this variable if you have other states [-]
  END TYPE MD_OtherStateType
! =======================
! =========  MD_MiscVarType  =======
  TYPE, PUBLIC :: MD_MiscVarType
    TYPE(MD_LineProp) , DIMENSION(:), ALLOCATABLE  :: LineTypeList      !< array of properties for each line type [-]
    TYPE(MD_RodProp) , DIMENSION(:), ALLOCATABLE  :: RodTypeList      !< array of properties for each rod type [-]
    TYPE(MD_Body)  :: GroundBody      !< the single ground body which is the parent of all stationary points [-]
    TYPE(MD_Body) , DIMENSION(:), ALLOCATABLE  :: BodyList      !< array of body objects [-]
    TYPE(MD_Rod) , DIMENSION(:), ALLOCATABLE  :: RodList      !< array of rod objects [-]
    TYPE(MD_Point) , DIMENSION(:), ALLOCATABLE  :: PointList      !< array of point objects [-]
    TYPE(MD_Line) , DIMENSION(:), ALLOCATABLE  :: LineList      !< array of line objects [-]
    TYPE(MD_ExtLd) , DIMENSION(:), ALLOCATABLE  :: ExtLdList      !< array of external load objects [-]
    TYPE(MD_Fail) , DIMENSION(:), ALLOCATABLE  :: FailList      !< array of line objects [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: FreePointIs      !< array of free point indices in PointList vector []
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: CpldPointIs      !< array of coupled/fairlead point indices in PointList vector []
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: FreeRodIs      !< array of free rod indices in RodList vector []
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: CpldRodIs      !< array of coupled/fairlead rod indices in RodList vector []
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: FreeBodyIs      !< array of free body indices in BodyList vector []
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: CpldBodyIs      !< array of coupled body indices in BodyList vector []
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: LineStateIs1      !< starting index of each line's states in state vector []
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: LineStateIsN      !< ending index of each line's states in state vector []
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: PointStateIs1      !< starting index of each point's states in state vector []
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: PointStateIsN      !< ending index of each point's states in state vector []
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: RodStateIs1      !< starting index of each rod's states in state vector []
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: RodStateIsN      !< ending index of each rod's states in state vector []
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: BodyStateIs1      !< starting index of each body's states in state vector []
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: BodyStateIsN      !< ending index of each body's states in state vector []
    INTEGER(IntKi)  :: Nx = 0_IntKi      !< number of states and size of state vector []
    INTEGER(IntKi)  :: Nxtra = 0_IntKi      !< number of states and size of state vector including points for potential line failures []
    INTEGER(IntKi)  :: WaveTi = 0_IntKi      !< current interpolation index for wave time series data []
    TYPE(MD_ContinuousStateType)  :: xTemp      !< contains temporary state vector used in integration (put here so it's only allocated once) [-]
    TYPE(MD_ContinuousStateType)  :: xdTemp      !< contains temporary state derivative vector used in integration (put here so it's only allocated once) [-]
    TYPE(MD_ContinuousStateType)  :: kSum      !< Sum of RK4 slope estimates: k0 + 2*k1 + 2*k2 + k3 [-]
    REAL(DbKi) , DIMENSION(1:6)  :: zeros6 = 0.0_R8Ki      !< array of zeros for convenience [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: MDWrOutput      !< Data from time step to be written to a MoorDyn output file [-]
    REAL(DbKi)  :: LastOutTime = 0.0_R8Ki      !< Time of last writing to MD output files [-]
    REAL(ReKi) , DIMENSION(1:6)  :: PtfmInit = 0.0_ReKi      !< initial position of platform for an individual (non-farm) MD instance [-]
    REAL(DbKi) , DIMENSION(:,:), ALLOCATABLE  :: BathymetryGrid      !< matrix describing the bathymetry in a grid of x's and y's [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: BathGrid_Xs      !< array of x-coordinates in the bathymetry grid [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: BathGrid_Ys      !< array of y-coordinates in the bathymetry grid [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: BathGrid_npoints      !< number of grid points to describe the bathymetry grid [-]
    TYPE(SeaSt_WaveField_MiscVarType)  :: WaveField_m      !< misc var information from the SeaState Interpolation module [-]
    LOGICAL  :: IC_gen = .FALSE.      !< boolean to indicate dynamic relaxation occuring [-]
  END TYPE MD_MiscVarType
! =======================
! =========  MD_ParameterType  =======
  TYPE, PUBLIC :: MD_ParameterType
    INTEGER(IntKi)  :: nLineTypes = 0      !< number of line types []
    INTEGER(IntKi)  :: nRodTypes = 0      !< number of rod types []
    INTEGER(IntKi)  :: nPoints = 0      !< number of Point objects []
    INTEGER(IntKi)  :: nPointsExtra = 0      !< number of Point objects including space for extra ones that could arise from line failures []
    INTEGER(IntKi)  :: nBodies = 0      !< number of Body objects []
    INTEGER(IntKi)  :: nRods = 0      !< number of Rod objects []
    INTEGER(IntKi)  :: nLines = 0      !< number of Line objects []
    INTEGER(IntKi)  :: nExtLds = 0      !< number of external loads or damping []
    INTEGER(IntKi)  :: nCtrlChans = 0      !< number of distinct control channels specified for use as inputs []
    INTEGER(IntKi)  :: nFails = 0      !< number of failure conditions []
    INTEGER(IntKi)  :: nFreeBodies = 0      !<  []
    INTEGER(IntKi)  :: nFreeRods = 0      !<  []
    INTEGER(IntKi)  :: nFreePoints = 0      !<  []
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: nCpldBodies      !< number of coupled bodies (for FAST.Farm, size>1 with an entry for each turbine) []
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: nCpldRods      !< number of coupled rods (for FAST.Farm, size>1 with an entry for each turbine) []
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: nCpldPoints      !< number of coupled points (for FAST.Farm, size>1 with an entry for each turbine) []
    INTEGER(IntKi)  :: NConns = 0      !< number of Connect type Points - not to be confused with NPoints []
    INTEGER(IntKi)  :: NAnchs = 0      !< number of Anchor type Points []
    REAL(DbKi)  :: Tmax = 0.0_R8Ki      !< simulation duration [[s]]
    INTEGER(IntKi)  :: tScheme = 0      !< Time integration scheme (0 = RK2, 1 = RK4). Default is RK2 [-]
    REAL(DbKi)  :: g = 9.81      !< gravitational constant (positive) [[m/s^2]]
    REAL(DbKi)  :: rhoW = 1025      !< density of seawater [[kg/m^3]]
    REAL(DbKi)  :: WtrDpth = 0.0_R8Ki      !< water depth [[m]]
    REAL(DbKi)  :: kBot = 0.0_R8Ki      !< bottom stiffness [[Pa/m]]
    REAL(DbKi)  :: cBot = 0.0_R8Ki      !< bottom damping [[Pa-s/m]]
    REAL(DbKi)  :: dtM0 = 0.0_R8Ki      !< desired mooring model time step [[s]]
    REAL(DbKi)  :: dtCoupling = 0.0_R8Ki      !< coupling time step that MoorDyn should expect [[s]]
    INTEGER(IntKi)  :: NumOuts = 0_IntKi      !< Number of parameters in the output list (number of outputs requested) [-]
    REAL(DbKi)  :: dtOut = 0.0_R8Ki      !< interval for writing output file lines [[s]]
    CHARACTER(1024)  :: RootName      !< RootName for writing output files [-]
    TYPE(MD_OutParmType) , DIMENSION(:), ALLOCATABLE  :: OutParam      !< Names and units (and other characteristics) of all requested output parameters [-]
    CHARACTER(1)  :: Delim      !< Column delimiter for output text files [-]
    INTEGER(IntKi)  :: MDUnOut = 0_IntKi      !< Unit number of main output file [-]
    CHARACTER(1024)  :: PriPath      !< The path to the primary MoorDyn input file, used if looking for additional input files [-]
    INTEGER(IntKi)  :: writeLog = -1      !< Switch for level of log file output [-]
    INTEGER(IntKi)  :: UnLog = -1      !< Unit number of log file [-]
    INTEGER(IntKi)  :: WaveKin = 0      !< Flag for whether or how to consider wave kinematics. (0: no waves, 1: old method, 2: hybrid method, 3: SeaState method) [-]
    INTEGER(IntKi)  :: Current = 0      !< Flag for whether or how to consider currents. (0: no currents, 1: old method, 2: hybrid method, 3: SeaState method) [-]
    INTEGER(IntKi)  :: WaterKin = 0      !< Flag for whether or how to consider water kinematics. (0: no kinematics, 1: old method, 2: hybrid method, 3: SeaState method) [-]
    TYPE(SeaSt_WaveFieldType) , POINTER :: WaveField => NULL()      !< Pointer to SeaState wave field [-]
    INTEGER(IntKi)  :: nTurbines = 0_IntKi      !< Number of turbines if MoorDyn is performing an array-level simulation with FAST.Farm, otherwise 1 [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: TurbineRefPos      !< reference position of turbines in farm, shape: 3, nTurbines [-]
    REAL(DbKi)  :: mu_kT = 0.0_R8Ki      !< transverse kinetic friction coefficient [(-)]
    REAL(DbKi)  :: mu_kA = 0.0_R8Ki      !< axial kinetic friction coefficient [(-)]
    REAL(DbKi)  :: mc = 0.0_R8Ki      !< ratio of the static friction coefficient to the kinetic friction coefficient [(-)]
    REAL(DbKi)  :: cv = 0.0_R8Ki      !< saturated damping coefficient [(-)]
    INTEGER(IntKi)  :: inertialF = 0      !< Indicates MoorDyn returning inertial moments for coupled 6DOF objects. 0: no, 1: yes, 2: yes with ramp to inertialF_rampT [-]
    REAL(R8Ki)  :: inertialF_rampT = 30      !< Ramp time for inertial forces [-]
    INTEGER(IntKi)  :: OutSwitch = 1      !< Switch to disable outputs when running with full OF. 0: no MD main outfile, 1: write MD main outfile [(-)]
    INTEGER(IntKi)  :: disableOutTime = 0      !< Disables the printing of the fairtens and timestep in init to the console, useful for the MATLAB wrapper [(-)]
    INTEGER(IntKi)  :: nxWave = 0_IntKi      !< number of x wave grid points [-]
    INTEGER(IntKi)  :: nyWave = 0_IntKi      !< number of y wave grid points [-]
    INTEGER(IntKi)  :: nzWave = 0_IntKi      !< number of z wave grid points [-]
    INTEGER(IntKi)  :: ntWave = 0_IntKi      !< number of wave time steps [-]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: pxWave      !< x location of wave grid points [-]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: pyWave      !< y location of wave grid points [-]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: pzWave      !< z location of wave grid points [-]
    REAL(SiKi)  :: dtWave = 0.0_R4Ki      !< wave data time step [-]
    REAL(SiKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: uxWave      !< wave velocities time series at each grid point [-]
    REAL(SiKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: uyWave      !< wave velocities time series at each grid point [-]
    REAL(SiKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: uzWave      !< wave velocities time series at each grid point [-]
    REAL(SiKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: axWave      !< wave accelerations time series at each grid point [-]
    REAL(SiKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: ayWave      !< wave accelerations time series at each grid point [-]
    REAL(SiKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: azWave      !< wave accelerations time series at each grid point [-]
    REAL(SiKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: PDyn      !< wave dynamic pressure time series at each grid point [-]
    REAL(SiKi) , DIMENSION(:,:,:), ALLOCATABLE  :: zeta      !< wave surface elevations time series at each surface grid point [-]
    INTEGER(IntKi)  :: nzCurrent = 0_IntKi      !< number of z current grid points [-]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: pzCurrent      !< z location of current grid points [-]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: uxCurrent      !< current velocities time series at each grid point [-]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: uyCurrent      !< current velocities time series at each grid point [-]
    INTEGER(IntKi)  :: Nx0 = 0_IntKi      !< copy of initial size of system state vector, for linearization routines [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: Jac_u_indx      !< matrix to help fill/pack the u vector in computing the jacobian [-]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: du      !< vector that determines size of perturbation for u (inputs) [-]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: dx      !< vector that determines size of perturbation for x (continuous states) [-]
    INTEGER(IntKi)  :: Jac_ny = 0_IntKi      !< number of outputs in jacobian matrix [-]
    INTEGER(IntKi)  :: Jac_nx = 0_IntKi      !< number of continuous states in jacobian matrix [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: dxIdx_map2_xStateIdx      !< Mapping array from index of dX array to corresponding state index [-]
    LOGICAL  :: VisMeshes = .false.      !< Using visualization meshes as requested by glue code [-]
    TYPE(VisDiam) , DIMENSION(:), ALLOCATABLE  :: VisRodsDiam      !< Diameters for visualization of rods [-]
  END TYPE MD_ParameterType
! =======================
! =========  MD_InputType  =======
  TYPE, PUBLIC :: MD_InputType
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: CoupledKinematics      !< array of meshes for each coupling point (6 DOF info used for rods and bodies) [[m, m/s]]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: DeltaL      !< change in line length command for each channel [[m]]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: DeltaLdot      !< rate of change of line length command for each channel [[m]]
  END TYPE MD_InputType
! =======================
! =========  MD_OutputType  =======
  TYPE, PUBLIC :: MD_OutputType
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: CoupledLoads      !< array of point meshes for mooring reaction forces (and moments) at coupling points [[N]]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WriteOutput      !< output vector returned to glue code []
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: VisLinesMesh      !< Line2 mesh for visualizing mooring lines [-]
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: VisRodsMesh      !< Line2 mesh for visualizing mooring rods [-]
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: VisBodiesMesh      !< Point mesh for visualizing mooring bodies [-]
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: VisAnchsMesh      !< Point mesh for visualizing mooring anchors [-]
  END TYPE MD_OutputType
! =======================
CONTAINS

subroutine MD_CopyInputFileType(SrcInputFileTypeData, DstInputFileTypeData, CtrlCode, ErrStat, ErrMsg)
   type(MD_InputFileType), intent(in) :: SrcInputFileTypeData
   type(MD_InputFileType), intent(inout) :: DstInputFileTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'MD_CopyInputFileType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInputFileTypeData%DTIC = SrcInputFileTypeData%DTIC
   DstInputFileTypeData%TMaxIC = SrcInputFileTypeData%TMaxIC
   DstInputFileTypeData%CdScaleIC = SrcInputFileTypeData%CdScaleIC
   DstInputFileTypeData%threshIC = SrcInputFileTypeData%threshIC
end subroutine

subroutine MD_DestroyInputFileType(InputFileTypeData, ErrStat, ErrMsg)
   type(MD_InputFileType), intent(inout) :: InputFileTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'MD_DestroyInputFileType'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine MD_PackInputFileType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(MD_InputFileType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'MD_PackInputFileType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DTIC)
   call RegPack(RF, InData%TMaxIC)
   call RegPack(RF, InData%CdScaleIC)
   call RegPack(RF, InData%threshIC)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MD_UnPackInputFileType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(MD_InputFileType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'MD_UnPackInputFileType'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DTIC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TMaxIC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CdScaleIC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%threshIC); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MD_CopyInitInput(SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg)
   type(MD_InitInputType), intent(in) :: SrcInitInputData
   type(MD_InitInputType), intent(inout) :: DstInitInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'MD_CopyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInitInputData%g = SrcInitInputData%g
   DstInitInputData%rhoW = SrcInitInputData%rhoW
   DstInitInputData%WtrDepth = SrcInitInputData%WtrDepth
   if (allocated(SrcInitInputData%PtfmInit)) then
      LB(1:2) = lbound(SrcInitInputData%PtfmInit)
      UB(1:2) = ubound(SrcInitInputData%PtfmInit)
      if (.not. allocated(DstInitInputData%PtfmInit)) then
         allocate(DstInitInputData%PtfmInit(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%PtfmInit.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%PtfmInit = SrcInitInputData%PtfmInit
   end if
   DstInitInputData%FarmSize = SrcInitInputData%FarmSize
   if (allocated(SrcInitInputData%TurbineRefPos)) then
      LB(1:2) = lbound(SrcInitInputData%TurbineRefPos)
      UB(1:2) = ubound(SrcInitInputData%TurbineRefPos)
      if (.not. allocated(DstInitInputData%TurbineRefPos)) then
         allocate(DstInitInputData%TurbineRefPos(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%TurbineRefPos.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%TurbineRefPos = SrcInitInputData%TurbineRefPos
   end if
   DstInitInputData%Tmax = SrcInitInputData%Tmax
   DstInitInputData%FileName = SrcInitInputData%FileName
   DstInitInputData%RootName = SrcInitInputData%RootName
   DstInitInputData%UsePrimaryInputFile = SrcInitInputData%UsePrimaryInputFile
   call NWTC_Library_CopyFileInfoType(SrcInitInputData%PassedPrimaryInputData, DstInitInputData%PassedPrimaryInputData, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstInitInputData%Echo = SrcInitInputData%Echo
   if (allocated(SrcInitInputData%OutList)) then
      LB(1:1) = lbound(SrcInitInputData%OutList)
      UB(1:1) = ubound(SrcInitInputData%OutList)
      if (.not. allocated(DstInitInputData%OutList)) then
         allocate(DstInitInputData%OutList(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%OutList.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%OutList = SrcInitInputData%OutList
   end if
   DstInitInputData%Linearize = SrcInitInputData%Linearize
   DstInitInputData%VisMeshes = SrcInitInputData%VisMeshes
   DstInitInputData%WaveField => SrcInitInputData%WaveField
end subroutine

subroutine MD_DestroyInitInput(InitInputData, ErrStat, ErrMsg)
   type(MD_InitInputType), intent(inout) :: InitInputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'MD_DestroyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InitInputData%PtfmInit)) then
      deallocate(InitInputData%PtfmInit)
   end if
   if (allocated(InitInputData%TurbineRefPos)) then
      deallocate(InitInputData%TurbineRefPos)
   end if
   call NWTC_Library_DestroyFileInfoType(InitInputData%PassedPrimaryInputData, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(InitInputData%OutList)) then
      deallocate(InitInputData%OutList)
   end if
   nullify(InitInputData%WaveField)
end subroutine

subroutine MD_PackInitInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(MD_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'MD_PackInitInput'
   logical         :: PtrInIndex
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%g)
   call RegPack(RF, InData%rhoW)
   call RegPack(RF, InData%WtrDepth)
   call RegPackAlloc(RF, InData%PtfmInit)
   call RegPack(RF, InData%FarmSize)
   call RegPackAlloc(RF, InData%TurbineRefPos)
   call RegPack(RF, InData%Tmax)
   call RegPack(RF, InData%FileName)
   call RegPack(RF, InData%RootName)
   call RegPack(RF, InData%UsePrimaryInputFile)
   call NWTC_Library_PackFileInfoType(RF, InData%PassedPrimaryInputData) 
   call RegPack(RF, InData%Echo)
   call RegPackAlloc(RF, InData%OutList)
   call RegPack(RF, InData%Linearize)
   call RegPack(RF, InData%VisMeshes)
   call RegPack(RF, associated(InData%WaveField))
   if (associated(InData%WaveField)) then
      call RegPackPointer(RF, c_loc(InData%WaveField), PtrInIndex)
      if (.not. PtrInIndex) then
         call SeaSt_WaveField_PackSeaSt_WaveFieldType(RF, InData%WaveField) 
      end if
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MD_UnPackInitInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(MD_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'MD_UnPackInitInput'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   integer(B8Ki)   :: PtrIdx
   type(c_ptr)     :: Ptr
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%g); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rhoW); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WtrDepth); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PtfmInit); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FarmSize); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TurbineRefPos); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Tmax); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FileName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UsePrimaryInputFile); if (RegCheckErr(RF, RoutineName)) return
   call NWTC_Library_UnpackFileInfoType(RF, OutData%PassedPrimaryInputData) ! PassedPrimaryInputData 
   call RegUnpack(RF, OutData%Echo); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%OutList); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Linearize); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VisMeshes); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%WaveField)) deallocate(OutData%WaveField)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackPointer(RF, Ptr, PtrIdx); if (RegCheckErr(RF, RoutineName)) return
      if (c_associated(Ptr)) then
         call c_f_pointer(Ptr, OutData%WaveField)
      else
         allocate(OutData%WaveField,stat=stat)
         if (stat /= 0) then 
            call SetErrStat(ErrID_Fatal, 'Error allocating OutData%WaveField.', RF%ErrStat, RF%ErrMsg, RoutineName)
            return
         end if
         RF%Pointers(PtrIdx) = c_loc(OutData%WaveField)
         call SeaSt_WaveField_UnpackSeaSt_WaveFieldType(RF, OutData%WaveField) ! WaveField 
      end if
   else
      OutData%WaveField => null()
   end if
end subroutine

subroutine MD_CopyLineProp(SrcLinePropData, DstLinePropData, CtrlCode, ErrStat, ErrMsg)
   type(MD_LineProp), intent(in) :: SrcLinePropData
   type(MD_LineProp), intent(inout) :: DstLinePropData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'MD_CopyLineProp'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstLinePropData%IdNum = SrcLinePropData%IdNum
   DstLinePropData%name = SrcLinePropData%name
   DstLinePropData%d = SrcLinePropData%d
   DstLinePropData%w = SrcLinePropData%w
   DstLinePropData%EA = SrcLinePropData%EA
   DstLinePropData%EA_D = SrcLinePropData%EA_D
   DstLinePropData%alphaMBL = SrcLinePropData%alphaMBL
   DstLinePropData%vbeta = SrcLinePropData%vbeta
   DstLinePropData%BA = SrcLinePropData%BA
   DstLinePropData%BA_D = SrcLinePropData%BA_D
   DstLinePropData%EI = SrcLinePropData%EI
   DstLinePropData%Can = SrcLinePropData%Can
   DstLinePropData%Cat = SrcLinePropData%Cat
   DstLinePropData%Cdn = SrcLinePropData%Cdn
   DstLinePropData%Cdt = SrcLinePropData%Cdt
   DstLinePropData%Cl = SrcLinePropData%Cl
   DstLinePropData%dF = SrcLinePropData%dF
   DstLinePropData%cF = SrcLinePropData%cF
   DstLinePropData%ElasticMod = SrcLinePropData%ElasticMod
   DstLinePropData%nEApoints = SrcLinePropData%nEApoints
   DstLinePropData%stiffXs = SrcLinePropData%stiffXs
   DstLinePropData%stiffYs = SrcLinePropData%stiffYs
   DstLinePropData%nBApoints = SrcLinePropData%nBApoints
   DstLinePropData%dampXs = SrcLinePropData%dampXs
   DstLinePropData%dampYs = SrcLinePropData%dampYs
   DstLinePropData%nEIpoints = SrcLinePropData%nEIpoints
   DstLinePropData%bstiffXs = SrcLinePropData%bstiffXs
   DstLinePropData%bstiffYs = SrcLinePropData%bstiffYs
end subroutine

subroutine MD_DestroyLineProp(LinePropData, ErrStat, ErrMsg)
   type(MD_LineProp), intent(inout) :: LinePropData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'MD_DestroyLineProp'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine MD_PackLineProp(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(MD_LineProp), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'MD_PackLineProp'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%IdNum)
   call RegPack(RF, InData%name)
   call RegPack(RF, InData%d)
   call RegPack(RF, InData%w)
   call RegPack(RF, InData%EA)
   call RegPack(RF, InData%EA_D)
   call RegPack(RF, InData%alphaMBL)
   call RegPack(RF, InData%vbeta)
   call RegPack(RF, InData%BA)
   call RegPack(RF, InData%BA_D)
   call RegPack(RF, InData%EI)
   call RegPack(RF, InData%Can)
   call RegPack(RF, InData%Cat)
   call RegPack(RF, InData%Cdn)
   call RegPack(RF, InData%Cdt)
   call RegPack(RF, InData%Cl)
   call RegPack(RF, InData%dF)
   call RegPack(RF, InData%cF)
   call RegPack(RF, InData%ElasticMod)
   call RegPack(RF, InData%nEApoints)
   call RegPack(RF, InData%stiffXs)
   call RegPack(RF, InData%stiffYs)
   call RegPack(RF, InData%nBApoints)
   call RegPack(RF, InData%dampXs)
   call RegPack(RF, InData%dampYs)
   call RegPack(RF, InData%nEIpoints)
   call RegPack(RF, InData%bstiffXs)
   call RegPack(RF, InData%bstiffYs)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MD_UnPackLineProp(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(MD_LineProp), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'MD_UnPackLineProp'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%IdNum); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%name); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%d); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%w); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%EA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%EA_D); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%alphaMBL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%vbeta); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BA_D); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%EI); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Can); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cat); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cdn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cdt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%cF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ElasticMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nEApoints); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%stiffXs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%stiffYs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nBApoints); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dampXs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dampYs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nEIpoints); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%bstiffXs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%bstiffYs); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MD_CopyRodProp(SrcRodPropData, DstRodPropData, CtrlCode, ErrStat, ErrMsg)
   type(MD_RodProp), intent(in) :: SrcRodPropData
   type(MD_RodProp), intent(inout) :: DstRodPropData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'MD_CopyRodProp'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstRodPropData%IdNum = SrcRodPropData%IdNum
   DstRodPropData%name = SrcRodPropData%name
   DstRodPropData%d = SrcRodPropData%d
   DstRodPropData%w = SrcRodPropData%w
   DstRodPropData%Can = SrcRodPropData%Can
   DstRodPropData%Cat = SrcRodPropData%Cat
   DstRodPropData%Cdn = SrcRodPropData%Cdn
   DstRodPropData%Cdt = SrcRodPropData%Cdt
   DstRodPropData%CdEnd = SrcRodPropData%CdEnd
   DstRodPropData%CaEnd = SrcRodPropData%CaEnd
end subroutine

subroutine MD_DestroyRodProp(RodPropData, ErrStat, ErrMsg)
   type(MD_RodProp), intent(inout) :: RodPropData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'MD_DestroyRodProp'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine MD_PackRodProp(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(MD_RodProp), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'MD_PackRodProp'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%IdNum)
   call RegPack(RF, InData%name)
   call RegPack(RF, InData%d)
   call RegPack(RF, InData%w)
   call RegPack(RF, InData%Can)
   call RegPack(RF, InData%Cat)
   call RegPack(RF, InData%Cdn)
   call RegPack(RF, InData%Cdt)
   call RegPack(RF, InData%CdEnd)
   call RegPack(RF, InData%CaEnd)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MD_UnPackRodProp(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(MD_RodProp), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'MD_UnPackRodProp'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%IdNum); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%name); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%d); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%w); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Can); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cat); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cdn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cdt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CdEnd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CaEnd); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MD_CopyBody(SrcBodyData, DstBodyData, CtrlCode, ErrStat, ErrMsg)
   type(MD_Body), intent(in) :: SrcBodyData
   type(MD_Body), intent(inout) :: DstBodyData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'MD_CopyBody'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstBodyData%IdNum = SrcBodyData%IdNum
   DstBodyData%typeNum = SrcBodyData%typeNum
   DstBodyData%AttachedC = SrcBodyData%AttachedC
   DstBodyData%AttachedR = SrcBodyData%AttachedR
   DstBodyData%nAttachedP = SrcBodyData%nAttachedP
   DstBodyData%nAttachedR = SrcBodyData%nAttachedR
   DstBodyData%rPointRel = SrcBodyData%rPointRel
   DstBodyData%r6RodRel = SrcBodyData%r6RodRel
   DstBodyData%bodyM = SrcBodyData%bodyM
   DstBodyData%bodyV = SrcBodyData%bodyV
   DstBodyData%bodyI = SrcBodyData%bodyI
   DstBodyData%bodyCdA = SrcBodyData%bodyCdA
   DstBodyData%bodyCa = SrcBodyData%bodyCa
   DstBodyData%time = SrcBodyData%time
   DstBodyData%r6 = SrcBodyData%r6
   DstBodyData%v6 = SrcBodyData%v6
   DstBodyData%a6 = SrcBodyData%a6
   DstBodyData%U = SrcBodyData%U
   DstBodyData%Ud = SrcBodyData%Ud
   DstBodyData%zeta = SrcBodyData%zeta
   DstBodyData%F6net = SrcBodyData%F6net
   DstBodyData%M6net = SrcBodyData%M6net
   DstBodyData%M = SrcBodyData%M
   DstBodyData%M0 = SrcBodyData%M0
   DstBodyData%OrMat = SrcBodyData%OrMat
   DstBodyData%rCG = SrcBodyData%rCG
   DstBodyData%FextG = SrcBodyData%FextG
   DstBodyData%BlinG = SrcBodyData%BlinG
   DstBodyData%BquadG = SrcBodyData%BquadG
   DstBodyData%FextL = SrcBodyData%FextL
   DstBodyData%BlinL = SrcBodyData%BlinL
   DstBodyData%BquadL = SrcBodyData%BquadL
end subroutine

subroutine MD_DestroyBody(BodyData, ErrStat, ErrMsg)
   type(MD_Body), intent(inout) :: BodyData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'MD_DestroyBody'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine MD_PackBody(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(MD_Body), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'MD_PackBody'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%IdNum)
   call RegPack(RF, InData%typeNum)
   call RegPack(RF, InData%AttachedC)
   call RegPack(RF, InData%AttachedR)
   call RegPack(RF, InData%nAttachedP)
   call RegPack(RF, InData%nAttachedR)
   call RegPack(RF, InData%rPointRel)
   call RegPack(RF, InData%r6RodRel)
   call RegPack(RF, InData%bodyM)
   call RegPack(RF, InData%bodyV)
   call RegPack(RF, InData%bodyI)
   call RegPack(RF, InData%bodyCdA)
   call RegPack(RF, InData%bodyCa)
   call RegPack(RF, InData%time)
   call RegPack(RF, InData%r6)
   call RegPack(RF, InData%v6)
   call RegPack(RF, InData%a6)
   call RegPack(RF, InData%U)
   call RegPack(RF, InData%Ud)
   call RegPack(RF, InData%zeta)
   call RegPack(RF, InData%F6net)
   call RegPack(RF, InData%M6net)
   call RegPack(RF, InData%M)
   call RegPack(RF, InData%M0)
   call RegPack(RF, InData%OrMat)
   call RegPack(RF, InData%rCG)
   call RegPack(RF, InData%FextG)
   call RegPack(RF, InData%BlinG)
   call RegPack(RF, InData%BquadG)
   call RegPack(RF, InData%FextL)
   call RegPack(RF, InData%BlinL)
   call RegPack(RF, InData%BquadL)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MD_UnPackBody(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(MD_Body), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'MD_UnPackBody'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%IdNum); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%typeNum); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AttachedC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AttachedR); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nAttachedP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nAttachedR); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rPointRel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%r6RodRel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%bodyM); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%bodyV); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%bodyI); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%bodyCdA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%bodyCa); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%time); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%r6); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%v6); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%a6); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%U); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Ud); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%zeta); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%F6net); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%M6net); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%M); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%M0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OrMat); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rCG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FextG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BlinG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BquadG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FextL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BlinL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BquadL); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MD_CopyPoint(SrcPointData, DstPointData, CtrlCode, ErrStat, ErrMsg)
   type(MD_Point), intent(in) :: SrcPointData
   type(MD_Point), intent(inout) :: DstPointData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'MD_CopyPoint'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstPointData%IdNum = SrcPointData%IdNum
   DstPointData%type = SrcPointData%type
   DstPointData%typeNum = SrcPointData%typeNum
   DstPointData%Attached = SrcPointData%Attached
   DstPointData%Top = SrcPointData%Top
   DstPointData%nAttached = SrcPointData%nAttached
   DstPointData%pointM = SrcPointData%pointM
   DstPointData%pointV = SrcPointData%pointV
   DstPointData%pointFX = SrcPointData%pointFX
   DstPointData%pointFY = SrcPointData%pointFY
   DstPointData%pointFZ = SrcPointData%pointFZ
   DstPointData%pointCa = SrcPointData%pointCa
   DstPointData%pointCdA = SrcPointData%pointCdA
   DstPointData%time = SrcPointData%time
   DstPointData%r = SrcPointData%r
   DstPointData%rd = SrcPointData%rd
   DstPointData%a = SrcPointData%a
   DstPointData%U = SrcPointData%U
   DstPointData%Ud = SrcPointData%Ud
   DstPointData%zeta = SrcPointData%zeta
   if (allocated(SrcPointData%PDyn)) then
      LB(1:1) = lbound(SrcPointData%PDyn)
      UB(1:1) = ubound(SrcPointData%PDyn)
      if (.not. allocated(DstPointData%PDyn)) then
         allocate(DstPointData%PDyn(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstPointData%PDyn.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstPointData%PDyn = SrcPointData%PDyn
   end if
   DstPointData%Fnet = SrcPointData%Fnet
   DstPointData%M = SrcPointData%M
   DstPointData%Fext = SrcPointData%Fext
   DstPointData%Blin = SrcPointData%Blin
   DstPointData%Bquad = SrcPointData%Bquad
end subroutine

subroutine MD_DestroyPoint(PointData, ErrStat, ErrMsg)
   type(MD_Point), intent(inout) :: PointData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'MD_DestroyPoint'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(PointData%PDyn)) then
      deallocate(PointData%PDyn)
   end if
end subroutine

subroutine MD_PackPoint(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(MD_Point), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'MD_PackPoint'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%IdNum)
   call RegPack(RF, InData%type)
   call RegPack(RF, InData%typeNum)
   call RegPack(RF, InData%Attached)
   call RegPack(RF, InData%Top)
   call RegPack(RF, InData%nAttached)
   call RegPack(RF, InData%pointM)
   call RegPack(RF, InData%pointV)
   call RegPack(RF, InData%pointFX)
   call RegPack(RF, InData%pointFY)
   call RegPack(RF, InData%pointFZ)
   call RegPack(RF, InData%pointCa)
   call RegPack(RF, InData%pointCdA)
   call RegPack(RF, InData%time)
   call RegPack(RF, InData%r)
   call RegPack(RF, InData%rd)
   call RegPack(RF, InData%a)
   call RegPack(RF, InData%U)
   call RegPack(RF, InData%Ud)
   call RegPack(RF, InData%zeta)
   call RegPackAlloc(RF, InData%PDyn)
   call RegPack(RF, InData%Fnet)
   call RegPack(RF, InData%M)
   call RegPack(RF, InData%Fext)
   call RegPack(RF, InData%Blin)
   call RegPack(RF, InData%Bquad)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MD_UnPackPoint(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(MD_Point), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'MD_UnPackPoint'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%IdNum); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%type); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%typeNum); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Attached); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Top); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nAttached); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%pointM); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%pointV); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%pointFX); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%pointFY); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%pointFZ); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%pointCa); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%pointCdA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%time); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%r); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%a); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%U); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Ud); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%zeta); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PDyn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Fnet); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%M); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Fext); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Blin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Bquad); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MD_CopyRod(SrcRodData, DstRodData, CtrlCode, ErrStat, ErrMsg)
   type(MD_Rod), intent(in) :: SrcRodData
   type(MD_Rod), intent(inout) :: DstRodData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'MD_CopyRod'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstRodData%IdNum = SrcRodData%IdNum
   DstRodData%type = SrcRodData%type
   DstRodData%PropsIdNum = SrcRodData%PropsIdNum
   DstRodData%typeNum = SrcRodData%typeNum
   DstRodData%AttachedA = SrcRodData%AttachedA
   DstRodData%AttachedB = SrcRodData%AttachedB
   DstRodData%TopA = SrcRodData%TopA
   DstRodData%TopB = SrcRodData%TopB
   DstRodData%nAttachedA = SrcRodData%nAttachedA
   DstRodData%nAttachedB = SrcRodData%nAttachedB
   DstRodData%OutFlagList = SrcRodData%OutFlagList
   DstRodData%N = SrcRodData%N
   DstRodData%endTypeA = SrcRodData%endTypeA
   DstRodData%endTypeB = SrcRodData%endTypeB
   DstRodData%UnstrLen = SrcRodData%UnstrLen
   DstRodData%mass = SrcRodData%mass
   DstRodData%rho = SrcRodData%rho
   DstRodData%d = SrcRodData%d
   DstRodData%Can = SrcRodData%Can
   DstRodData%Cat = SrcRodData%Cat
   DstRodData%Cdn = SrcRodData%Cdn
   DstRodData%Cdt = SrcRodData%Cdt
   DstRodData%CdEnd = SrcRodData%CdEnd
   DstRodData%CaEnd = SrcRodData%CaEnd
   DstRodData%time = SrcRodData%time
   DstRodData%roll = SrcRodData%roll
   DstRodData%pitch = SrcRodData%pitch
   DstRodData%h0 = SrcRodData%h0
   if (allocated(SrcRodData%r)) then
      LB(1:2) = lbound(SrcRodData%r)
      UB(1:2) = ubound(SrcRodData%r)
      if (.not. allocated(DstRodData%r)) then
         allocate(DstRodData%r(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRodData%r.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRodData%r = SrcRodData%r
   end if
   if (allocated(SrcRodData%rd)) then
      LB(1:2) = lbound(SrcRodData%rd)
      UB(1:2) = ubound(SrcRodData%rd)
      if (.not. allocated(DstRodData%rd)) then
         allocate(DstRodData%rd(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRodData%rd.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRodData%rd = SrcRodData%rd
   end if
   DstRodData%q = SrcRodData%q
   if (allocated(SrcRodData%l)) then
      LB(1:1) = lbound(SrcRodData%l)
      UB(1:1) = ubound(SrcRodData%l)
      if (.not. allocated(DstRodData%l)) then
         allocate(DstRodData%l(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRodData%l.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRodData%l = SrcRodData%l
   end if
   if (allocated(SrcRodData%V)) then
      LB(1:1) = lbound(SrcRodData%V)
      UB(1:1) = ubound(SrcRodData%V)
      if (.not. allocated(DstRodData%V)) then
         allocate(DstRodData%V(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRodData%V.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRodData%V = SrcRodData%V
   end if
   if (allocated(SrcRodData%U)) then
      LB(1:2) = lbound(SrcRodData%U)
      UB(1:2) = ubound(SrcRodData%U)
      if (.not. allocated(DstRodData%U)) then
         allocate(DstRodData%U(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRodData%U.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRodData%U = SrcRodData%U
   end if
   if (allocated(SrcRodData%Ud)) then
      LB(1:2) = lbound(SrcRodData%Ud)
      UB(1:2) = ubound(SrcRodData%Ud)
      if (.not. allocated(DstRodData%Ud)) then
         allocate(DstRodData%Ud(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRodData%Ud.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRodData%Ud = SrcRodData%Ud
   end if
   if (allocated(SrcRodData%zeta)) then
      LB(1:1) = lbound(SrcRodData%zeta)
      UB(1:1) = ubound(SrcRodData%zeta)
      if (.not. allocated(DstRodData%zeta)) then
         allocate(DstRodData%zeta(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRodData%zeta.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRodData%zeta = SrcRodData%zeta
   end if
   if (allocated(SrcRodData%PDyn)) then
      LB(1:1) = lbound(SrcRodData%PDyn)
      UB(1:1) = ubound(SrcRodData%PDyn)
      if (.not. allocated(DstRodData%PDyn)) then
         allocate(DstRodData%PDyn(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRodData%PDyn.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRodData%PDyn = SrcRodData%PDyn
   end if
   if (allocated(SrcRodData%W)) then
      LB(1:2) = lbound(SrcRodData%W)
      UB(1:2) = ubound(SrcRodData%W)
      if (.not. allocated(DstRodData%W)) then
         allocate(DstRodData%W(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRodData%W.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRodData%W = SrcRodData%W
   end if
   if (allocated(SrcRodData%Bo)) then
      LB(1:2) = lbound(SrcRodData%Bo)
      UB(1:2) = ubound(SrcRodData%Bo)
      if (.not. allocated(DstRodData%Bo)) then
         allocate(DstRodData%Bo(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRodData%Bo.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRodData%Bo = SrcRodData%Bo
   end if
   if (allocated(SrcRodData%Pd)) then
      LB(1:2) = lbound(SrcRodData%Pd)
      UB(1:2) = ubound(SrcRodData%Pd)
      if (.not. allocated(DstRodData%Pd)) then
         allocate(DstRodData%Pd(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRodData%Pd.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRodData%Pd = SrcRodData%Pd
   end if
   if (allocated(SrcRodData%Dp)) then
      LB(1:2) = lbound(SrcRodData%Dp)
      UB(1:2) = ubound(SrcRodData%Dp)
      if (.not. allocated(DstRodData%Dp)) then
         allocate(DstRodData%Dp(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRodData%Dp.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRodData%Dp = SrcRodData%Dp
   end if
   if (allocated(SrcRodData%Dq)) then
      LB(1:2) = lbound(SrcRodData%Dq)
      UB(1:2) = ubound(SrcRodData%Dq)
      if (.not. allocated(DstRodData%Dq)) then
         allocate(DstRodData%Dq(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRodData%Dq.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRodData%Dq = SrcRodData%Dq
   end if
   if (allocated(SrcRodData%Ap)) then
      LB(1:2) = lbound(SrcRodData%Ap)
      UB(1:2) = ubound(SrcRodData%Ap)
      if (.not. allocated(DstRodData%Ap)) then
         allocate(DstRodData%Ap(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRodData%Ap.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRodData%Ap = SrcRodData%Ap
   end if
   if (allocated(SrcRodData%Aq)) then
      LB(1:2) = lbound(SrcRodData%Aq)
      UB(1:2) = ubound(SrcRodData%Aq)
      if (.not. allocated(DstRodData%Aq)) then
         allocate(DstRodData%Aq(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRodData%Aq.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRodData%Aq = SrcRodData%Aq
   end if
   if (allocated(SrcRodData%B)) then
      LB(1:2) = lbound(SrcRodData%B)
      UB(1:2) = ubound(SrcRodData%B)
      if (.not. allocated(DstRodData%B)) then
         allocate(DstRodData%B(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRodData%B.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRodData%B = SrcRodData%B
   end if
   if (allocated(SrcRodData%Bp)) then
      LB(1:2) = lbound(SrcRodData%Bp)
      UB(1:2) = ubound(SrcRodData%Bp)
      if (.not. allocated(DstRodData%Bp)) then
         allocate(DstRodData%Bp(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRodData%Bp.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRodData%Bp = SrcRodData%Bp
   end if
   if (allocated(SrcRodData%Bq)) then
      LB(1:2) = lbound(SrcRodData%Bq)
      UB(1:2) = ubound(SrcRodData%Bq)
      if (.not. allocated(DstRodData%Bq)) then
         allocate(DstRodData%Bq(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRodData%Bq.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRodData%Bq = SrcRodData%Bq
   end if
   if (allocated(SrcRodData%Fnet)) then
      LB(1:2) = lbound(SrcRodData%Fnet)
      UB(1:2) = ubound(SrcRodData%Fnet)
      if (.not. allocated(DstRodData%Fnet)) then
         allocate(DstRodData%Fnet(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRodData%Fnet.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRodData%Fnet = SrcRodData%Fnet
   end if
   if (allocated(SrcRodData%M)) then
      LB(1:3) = lbound(SrcRodData%M)
      UB(1:3) = ubound(SrcRodData%M)
      if (.not. allocated(DstRodData%M)) then
         allocate(DstRodData%M(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRodData%M.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRodData%M = SrcRodData%M
   end if
   DstRodData%FextA = SrcRodData%FextA
   DstRodData%FextB = SrcRodData%FextB
   DstRodData%Mext = SrcRodData%Mext
   DstRodData%r6 = SrcRodData%r6
   DstRodData%v6 = SrcRodData%v6
   DstRodData%a6 = SrcRodData%a6
   DstRodData%F6net = SrcRodData%F6net
   DstRodData%M6net = SrcRodData%M6net
   DstRodData%Imat = SrcRodData%Imat
   DstRodData%OrMat = SrcRodData%OrMat
   DstRodData%RodUnOut = SrcRodData%RodUnOut
   if (allocated(SrcRodData%RodWrOutput)) then
      LB(1:1) = lbound(SrcRodData%RodWrOutput)
      UB(1:1) = ubound(SrcRodData%RodWrOutput)
      if (.not. allocated(DstRodData%RodWrOutput)) then
         allocate(DstRodData%RodWrOutput(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRodData%RodWrOutput.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRodData%RodWrOutput = SrcRodData%RodWrOutput
   end if
   DstRodData%FextU = SrcRodData%FextU
   DstRodData%Blin = SrcRodData%Blin
   DstRodData%Bquad = SrcRodData%Bquad
end subroutine

subroutine MD_DestroyRod(RodData, ErrStat, ErrMsg)
   type(MD_Rod), intent(inout) :: RodData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'MD_DestroyRod'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(RodData%r)) then
      deallocate(RodData%r)
   end if
   if (allocated(RodData%rd)) then
      deallocate(RodData%rd)
   end if
   if (allocated(RodData%l)) then
      deallocate(RodData%l)
   end if
   if (allocated(RodData%V)) then
      deallocate(RodData%V)
   end if
   if (allocated(RodData%U)) then
      deallocate(RodData%U)
   end if
   if (allocated(RodData%Ud)) then
      deallocate(RodData%Ud)
   end if
   if (allocated(RodData%zeta)) then
      deallocate(RodData%zeta)
   end if
   if (allocated(RodData%PDyn)) then
      deallocate(RodData%PDyn)
   end if
   if (allocated(RodData%W)) then
      deallocate(RodData%W)
   end if
   if (allocated(RodData%Bo)) then
      deallocate(RodData%Bo)
   end if
   if (allocated(RodData%Pd)) then
      deallocate(RodData%Pd)
   end if
   if (allocated(RodData%Dp)) then
      deallocate(RodData%Dp)
   end if
   if (allocated(RodData%Dq)) then
      deallocate(RodData%Dq)
   end if
   if (allocated(RodData%Ap)) then
      deallocate(RodData%Ap)
   end if
   if (allocated(RodData%Aq)) then
      deallocate(RodData%Aq)
   end if
   if (allocated(RodData%B)) then
      deallocate(RodData%B)
   end if
   if (allocated(RodData%Bp)) then
      deallocate(RodData%Bp)
   end if
   if (allocated(RodData%Bq)) then
      deallocate(RodData%Bq)
   end if
   if (allocated(RodData%Fnet)) then
      deallocate(RodData%Fnet)
   end if
   if (allocated(RodData%M)) then
      deallocate(RodData%M)
   end if
   if (allocated(RodData%RodWrOutput)) then
      deallocate(RodData%RodWrOutput)
   end if
end subroutine

subroutine MD_PackRod(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(MD_Rod), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'MD_PackRod'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%IdNum)
   call RegPack(RF, InData%type)
   call RegPack(RF, InData%PropsIdNum)
   call RegPack(RF, InData%typeNum)
   call RegPack(RF, InData%AttachedA)
   call RegPack(RF, InData%AttachedB)
   call RegPack(RF, InData%TopA)
   call RegPack(RF, InData%TopB)
   call RegPack(RF, InData%nAttachedA)
   call RegPack(RF, InData%nAttachedB)
   call RegPack(RF, InData%OutFlagList)
   call RegPack(RF, InData%N)
   call RegPack(RF, InData%endTypeA)
   call RegPack(RF, InData%endTypeB)
   call RegPack(RF, InData%UnstrLen)
   call RegPack(RF, InData%mass)
   call RegPack(RF, InData%rho)
   call RegPack(RF, InData%d)
   call RegPack(RF, InData%Can)
   call RegPack(RF, InData%Cat)
   call RegPack(RF, InData%Cdn)
   call RegPack(RF, InData%Cdt)
   call RegPack(RF, InData%CdEnd)
   call RegPack(RF, InData%CaEnd)
   call RegPack(RF, InData%time)
   call RegPack(RF, InData%roll)
   call RegPack(RF, InData%pitch)
   call RegPack(RF, InData%h0)
   call RegPackAlloc(RF, InData%r)
   call RegPackAlloc(RF, InData%rd)
   call RegPack(RF, InData%q)
   call RegPackAlloc(RF, InData%l)
   call RegPackAlloc(RF, InData%V)
   call RegPackAlloc(RF, InData%U)
   call RegPackAlloc(RF, InData%Ud)
   call RegPackAlloc(RF, InData%zeta)
   call RegPackAlloc(RF, InData%PDyn)
   call RegPackAlloc(RF, InData%W)
   call RegPackAlloc(RF, InData%Bo)
   call RegPackAlloc(RF, InData%Pd)
   call RegPackAlloc(RF, InData%Dp)
   call RegPackAlloc(RF, InData%Dq)
   call RegPackAlloc(RF, InData%Ap)
   call RegPackAlloc(RF, InData%Aq)
   call RegPackAlloc(RF, InData%B)
   call RegPackAlloc(RF, InData%Bp)
   call RegPackAlloc(RF, InData%Bq)
   call RegPackAlloc(RF, InData%Fnet)
   call RegPackAlloc(RF, InData%M)
   call RegPack(RF, InData%FextA)
   call RegPack(RF, InData%FextB)
   call RegPack(RF, InData%Mext)
   call RegPack(RF, InData%r6)
   call RegPack(RF, InData%v6)
   call RegPack(RF, InData%a6)
   call RegPack(RF, InData%F6net)
   call RegPack(RF, InData%M6net)
   call RegPack(RF, InData%Imat)
   call RegPack(RF, InData%OrMat)
   call RegPack(RF, InData%RodUnOut)
   call RegPackAlloc(RF, InData%RodWrOutput)
   call RegPack(RF, InData%FextU)
   call RegPack(RF, InData%Blin)
   call RegPack(RF, InData%Bquad)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MD_UnPackRod(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(MD_Rod), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'MD_UnPackRod'
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%IdNum); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%type); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PropsIdNum); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%typeNum); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AttachedA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AttachedB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TopA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TopB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nAttachedA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nAttachedB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutFlagList); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%N); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%endTypeA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%endTypeB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UnstrLen); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%mass); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rho); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%d); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Can); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cat); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cdn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cdt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CdEnd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CaEnd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%time); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%roll); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%pitch); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%h0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%r); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%rd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%q); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%l); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%V); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%U); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Ud); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%zeta); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PDyn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%W); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Bo); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Pd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Dp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Dq); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Ap); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Aq); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%B); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Bp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Bq); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Fnet); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%M); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FextA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FextB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Mext); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%r6); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%v6); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%a6); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%F6net); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%M6net); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Imat); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OrMat); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RodUnOut); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RodWrOutput); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FextU); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Blin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Bquad); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MD_CopyLine(SrcLineData, DstLineData, CtrlCode, ErrStat, ErrMsg)
   type(MD_Line), intent(in) :: SrcLineData
   type(MD_Line), intent(inout) :: DstLineData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'MD_CopyLine'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstLineData%IdNum = SrcLineData%IdNum
   DstLineData%PropsIdNum = SrcLineData%PropsIdNum
   DstLineData%ElasticMod = SrcLineData%ElasticMod
   DstLineData%OutFlagList = SrcLineData%OutFlagList
   DstLineData%CtrlChan = SrcLineData%CtrlChan
   DstLineData%FairPoint = SrcLineData%FairPoint
   DstLineData%AnchPoint = SrcLineData%AnchPoint
   DstLineData%N = SrcLineData%N
   DstLineData%endTypeA = SrcLineData%endTypeA
   DstLineData%endTypeB = SrcLineData%endTypeB
   DstLineData%UnstrLen = SrcLineData%UnstrLen
   DstLineData%rho = SrcLineData%rho
   DstLineData%d = SrcLineData%d
   DstLineData%EA = SrcLineData%EA
   DstLineData%EA_D = SrcLineData%EA_D
   DstLineData%alphaMBL = SrcLineData%alphaMBL
   DstLineData%vbeta = SrcLineData%vbeta
   DstLineData%BA = SrcLineData%BA
   DstLineData%BA_D = SrcLineData%BA_D
   DstLineData%EI = SrcLineData%EI
   DstLineData%Can = SrcLineData%Can
   DstLineData%Cat = SrcLineData%Cat
   DstLineData%Cdn = SrcLineData%Cdn
   DstLineData%Cdt = SrcLineData%Cdt
   DstLineData%Cl = SrcLineData%Cl
   DstLineData%dF = SrcLineData%dF
   DstLineData%cF = SrcLineData%cF
   DstLineData%nEApoints = SrcLineData%nEApoints
   DstLineData%stiffXs = SrcLineData%stiffXs
   DstLineData%stiffYs = SrcLineData%stiffYs
   DstLineData%nBApoints = SrcLineData%nBApoints
   DstLineData%dampXs = SrcLineData%dampXs
   DstLineData%dampYs = SrcLineData%dampYs
   DstLineData%nEIpoints = SrcLineData%nEIpoints
   DstLineData%bstiffXs = SrcLineData%bstiffXs
   DstLineData%bstiffYs = SrcLineData%bstiffYs
   DstLineData%time = SrcLineData%time
   if (allocated(SrcLineData%r)) then
      LB(1:2) = lbound(SrcLineData%r)
      UB(1:2) = ubound(SrcLineData%r)
      if (.not. allocated(DstLineData%r)) then
         allocate(DstLineData%r(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLineData%r.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLineData%r = SrcLineData%r
   end if
   if (allocated(SrcLineData%rd)) then
      LB(1:2) = lbound(SrcLineData%rd)
      UB(1:2) = ubound(SrcLineData%rd)
      if (.not. allocated(DstLineData%rd)) then
         allocate(DstLineData%rd(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLineData%rd.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLineData%rd = SrcLineData%rd
   end if
   if (allocated(SrcLineData%q)) then
      LB(1:2) = lbound(SrcLineData%q)
      UB(1:2) = ubound(SrcLineData%q)
      if (.not. allocated(DstLineData%q)) then
         allocate(DstLineData%q(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLineData%q.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLineData%q = SrcLineData%q
   end if
   if (allocated(SrcLineData%qs)) then
      LB(1:2) = lbound(SrcLineData%qs)
      UB(1:2) = ubound(SrcLineData%qs)
      if (.not. allocated(DstLineData%qs)) then
         allocate(DstLineData%qs(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLineData%qs.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLineData%qs = SrcLineData%qs
   end if
   if (allocated(SrcLineData%l)) then
      LB(1:1) = lbound(SrcLineData%l)
      UB(1:1) = ubound(SrcLineData%l)
      if (.not. allocated(DstLineData%l)) then
         allocate(DstLineData%l(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLineData%l.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLineData%l = SrcLineData%l
   end if
   if (allocated(SrcLineData%ld)) then
      LB(1:1) = lbound(SrcLineData%ld)
      UB(1:1) = ubound(SrcLineData%ld)
      if (.not. allocated(DstLineData%ld)) then
         allocate(DstLineData%ld(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLineData%ld.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLineData%ld = SrcLineData%ld
   end if
   if (allocated(SrcLineData%lstr)) then
      LB(1:1) = lbound(SrcLineData%lstr)
      UB(1:1) = ubound(SrcLineData%lstr)
      if (.not. allocated(DstLineData%lstr)) then
         allocate(DstLineData%lstr(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLineData%lstr.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLineData%lstr = SrcLineData%lstr
   end if
   if (allocated(SrcLineData%lstrd)) then
      LB(1:1) = lbound(SrcLineData%lstrd)
      UB(1:1) = ubound(SrcLineData%lstrd)
      if (.not. allocated(DstLineData%lstrd)) then
         allocate(DstLineData%lstrd(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLineData%lstrd.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLineData%lstrd = SrcLineData%lstrd
   end if
   if (allocated(SrcLineData%Kurv)) then
      LB(1:1) = lbound(SrcLineData%Kurv)
      UB(1:1) = ubound(SrcLineData%Kurv)
      if (.not. allocated(DstLineData%Kurv)) then
         allocate(DstLineData%Kurv(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLineData%Kurv.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLineData%Kurv = SrcLineData%Kurv
   end if
   if (allocated(SrcLineData%dl_1)) then
      LB(1:1) = lbound(SrcLineData%dl_1)
      UB(1:1) = ubound(SrcLineData%dl_1)
      if (.not. allocated(DstLineData%dl_1)) then
         allocate(DstLineData%dl_1(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLineData%dl_1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLineData%dl_1 = SrcLineData%dl_1
   end if
   if (allocated(SrcLineData%V)) then
      LB(1:1) = lbound(SrcLineData%V)
      UB(1:1) = ubound(SrcLineData%V)
      if (.not. allocated(DstLineData%V)) then
         allocate(DstLineData%V(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLineData%V.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLineData%V = SrcLineData%V
   end if
   if (allocated(SrcLineData%F)) then
      LB(1:1) = lbound(SrcLineData%F)
      UB(1:1) = ubound(SrcLineData%F)
      if (.not. allocated(DstLineData%F)) then
         allocate(DstLineData%F(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLineData%F.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLineData%F = SrcLineData%F
   end if
   if (allocated(SrcLineData%U)) then
      LB(1:2) = lbound(SrcLineData%U)
      UB(1:2) = ubound(SrcLineData%U)
      if (.not. allocated(DstLineData%U)) then
         allocate(DstLineData%U(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLineData%U.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLineData%U = SrcLineData%U
   end if
   if (allocated(SrcLineData%Ud)) then
      LB(1:2) = lbound(SrcLineData%Ud)
      UB(1:2) = ubound(SrcLineData%Ud)
      if (.not. allocated(DstLineData%Ud)) then
         allocate(DstLineData%Ud(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLineData%Ud.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLineData%Ud = SrcLineData%Ud
   end if
   if (allocated(SrcLineData%zeta)) then
      LB(1:1) = lbound(SrcLineData%zeta)
      UB(1:1) = ubound(SrcLineData%zeta)
      if (.not. allocated(DstLineData%zeta)) then
         allocate(DstLineData%zeta(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLineData%zeta.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLineData%zeta = SrcLineData%zeta
   end if
   if (allocated(SrcLineData%PDyn)) then
      LB(1:1) = lbound(SrcLineData%PDyn)
      UB(1:1) = ubound(SrcLineData%PDyn)
      if (.not. allocated(DstLineData%PDyn)) then
         allocate(DstLineData%PDyn(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLineData%PDyn.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLineData%PDyn = SrcLineData%PDyn
   end if
   if (allocated(SrcLineData%T)) then
      LB(1:2) = lbound(SrcLineData%T)
      UB(1:2) = ubound(SrcLineData%T)
      if (.not. allocated(DstLineData%T)) then
         allocate(DstLineData%T(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLineData%T.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLineData%T = SrcLineData%T
   end if
   if (allocated(SrcLineData%Td)) then
      LB(1:2) = lbound(SrcLineData%Td)
      UB(1:2) = ubound(SrcLineData%Td)
      if (.not. allocated(DstLineData%Td)) then
         allocate(DstLineData%Td(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLineData%Td.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLineData%Td = SrcLineData%Td
   end if
   if (allocated(SrcLineData%W)) then
      LB(1:2) = lbound(SrcLineData%W)
      UB(1:2) = ubound(SrcLineData%W)
      if (.not. allocated(DstLineData%W)) then
         allocate(DstLineData%W(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLineData%W.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLineData%W = SrcLineData%W
   end if
   if (allocated(SrcLineData%Dp)) then
      LB(1:2) = lbound(SrcLineData%Dp)
      UB(1:2) = ubound(SrcLineData%Dp)
      if (.not. allocated(DstLineData%Dp)) then
         allocate(DstLineData%Dp(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLineData%Dp.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLineData%Dp = SrcLineData%Dp
   end if
   if (allocated(SrcLineData%Dq)) then
      LB(1:2) = lbound(SrcLineData%Dq)
      UB(1:2) = ubound(SrcLineData%Dq)
      if (.not. allocated(DstLineData%Dq)) then
         allocate(DstLineData%Dq(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLineData%Dq.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLineData%Dq = SrcLineData%Dq
   end if
   if (allocated(SrcLineData%Ap)) then
      LB(1:2) = lbound(SrcLineData%Ap)
      UB(1:2) = ubound(SrcLineData%Ap)
      if (.not. allocated(DstLineData%Ap)) then
         allocate(DstLineData%Ap(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLineData%Ap.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLineData%Ap = SrcLineData%Ap
   end if
   if (allocated(SrcLineData%Aq)) then
      LB(1:2) = lbound(SrcLineData%Aq)
      UB(1:2) = ubound(SrcLineData%Aq)
      if (.not. allocated(DstLineData%Aq)) then
         allocate(DstLineData%Aq(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLineData%Aq.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLineData%Aq = SrcLineData%Aq
   end if
   if (allocated(SrcLineData%B)) then
      LB(1:2) = lbound(SrcLineData%B)
      UB(1:2) = ubound(SrcLineData%B)
      if (.not. allocated(DstLineData%B)) then
         allocate(DstLineData%B(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLineData%B.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLineData%B = SrcLineData%B
   end if
   if (allocated(SrcLineData%Bs)) then
      LB(1:2) = lbound(SrcLineData%Bs)
      UB(1:2) = ubound(SrcLineData%Bs)
      if (.not. allocated(DstLineData%Bs)) then
         allocate(DstLineData%Bs(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLineData%Bs.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLineData%Bs = SrcLineData%Bs
   end if
   if (allocated(SrcLineData%Lf)) then
      LB(1:2) = lbound(SrcLineData%Lf)
      UB(1:2) = ubound(SrcLineData%Lf)
      if (.not. allocated(DstLineData%Lf)) then
         allocate(DstLineData%Lf(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLineData%Lf.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLineData%Lf = SrcLineData%Lf
   end if
   if (allocated(SrcLineData%Fnet)) then
      LB(1:2) = lbound(SrcLineData%Fnet)
      UB(1:2) = ubound(SrcLineData%Fnet)
      if (.not. allocated(DstLineData%Fnet)) then
         allocate(DstLineData%Fnet(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLineData%Fnet.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLineData%Fnet = SrcLineData%Fnet
   end if
   if (allocated(SrcLineData%S)) then
      LB(1:3) = lbound(SrcLineData%S)
      UB(1:3) = ubound(SrcLineData%S)
      if (.not. allocated(DstLineData%S)) then
         allocate(DstLineData%S(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLineData%S.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLineData%S = SrcLineData%S
   end if
   if (allocated(SrcLineData%M)) then
      LB(1:3) = lbound(SrcLineData%M)
      UB(1:3) = ubound(SrcLineData%M)
      if (.not. allocated(DstLineData%M)) then
         allocate(DstLineData%M(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLineData%M.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLineData%M = SrcLineData%M
   end if
   DstLineData%EndMomentA = SrcLineData%EndMomentA
   DstLineData%EndMomentB = SrcLineData%EndMomentB
   DstLineData%LineUnOut = SrcLineData%LineUnOut
   if (allocated(SrcLineData%LineWrOutput)) then
      LB(1:1) = lbound(SrcLineData%LineWrOutput)
      UB(1:1) = ubound(SrcLineData%LineWrOutput)
      if (.not. allocated(DstLineData%LineWrOutput)) then
         allocate(DstLineData%LineWrOutput(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLineData%LineWrOutput.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLineData%LineWrOutput = SrcLineData%LineWrOutput
   end if
   if (allocated(SrcLineData%phi)) then
      LB(1:1) = lbound(SrcLineData%phi)
      UB(1:1) = ubound(SrcLineData%phi)
      if (.not. allocated(DstLineData%phi)) then
         allocate(DstLineData%phi(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLineData%phi.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLineData%phi = SrcLineData%phi
   end if
   DstLineData%n_m = SrcLineData%n_m
   DstLineData%phi_yd = SrcLineData%phi_yd
   DstLineData%t_old = SrcLineData%t_old
   if (allocated(SrcLineData%yd_rms_old)) then
      LB(1:1) = lbound(SrcLineData%yd_rms_old)
      UB(1:1) = ubound(SrcLineData%yd_rms_old)
      if (.not. allocated(DstLineData%yd_rms_old)) then
         allocate(DstLineData%yd_rms_old(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLineData%yd_rms_old.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLineData%yd_rms_old = SrcLineData%yd_rms_old
   end if
   if (allocated(SrcLineData%ydd_rms_old)) then
      LB(1:1) = lbound(SrcLineData%ydd_rms_old)
      UB(1:1) = ubound(SrcLineData%ydd_rms_old)
      if (.not. allocated(DstLineData%ydd_rms_old)) then
         allocate(DstLineData%ydd_rms_old(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLineData%ydd_rms_old.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLineData%ydd_rms_old = SrcLineData%ydd_rms_old
   end if
   if (allocated(SrcLineData%rdd_old)) then
      LB(1:2) = lbound(SrcLineData%rdd_old)
      UB(1:2) = ubound(SrcLineData%rdd_old)
      if (.not. allocated(DstLineData%rdd_old)) then
         allocate(DstLineData%rdd_old(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstLineData%rdd_old.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstLineData%rdd_old = SrcLineData%rdd_old
   end if
end subroutine

subroutine MD_DestroyLine(LineData, ErrStat, ErrMsg)
   type(MD_Line), intent(inout) :: LineData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'MD_DestroyLine'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(LineData%r)) then
      deallocate(LineData%r)
   end if
   if (allocated(LineData%rd)) then
      deallocate(LineData%rd)
   end if
   if (allocated(LineData%q)) then
      deallocate(LineData%q)
   end if
   if (allocated(LineData%qs)) then
      deallocate(LineData%qs)
   end if
   if (allocated(LineData%l)) then
      deallocate(LineData%l)
   end if
   if (allocated(LineData%ld)) then
      deallocate(LineData%ld)
   end if
   if (allocated(LineData%lstr)) then
      deallocate(LineData%lstr)
   end if
   if (allocated(LineData%lstrd)) then
      deallocate(LineData%lstrd)
   end if
   if (allocated(LineData%Kurv)) then
      deallocate(LineData%Kurv)
   end if
   if (allocated(LineData%dl_1)) then
      deallocate(LineData%dl_1)
   end if
   if (allocated(LineData%V)) then
      deallocate(LineData%V)
   end if
   if (allocated(LineData%F)) then
      deallocate(LineData%F)
   end if
   if (allocated(LineData%U)) then
      deallocate(LineData%U)
   end if
   if (allocated(LineData%Ud)) then
      deallocate(LineData%Ud)
   end if
   if (allocated(LineData%zeta)) then
      deallocate(LineData%zeta)
   end if
   if (allocated(LineData%PDyn)) then
      deallocate(LineData%PDyn)
   end if
   if (allocated(LineData%T)) then
      deallocate(LineData%T)
   end if
   if (allocated(LineData%Td)) then
      deallocate(LineData%Td)
   end if
   if (allocated(LineData%W)) then
      deallocate(LineData%W)
   end if
   if (allocated(LineData%Dp)) then
      deallocate(LineData%Dp)
   end if
   if (allocated(LineData%Dq)) then
      deallocate(LineData%Dq)
   end if
   if (allocated(LineData%Ap)) then
      deallocate(LineData%Ap)
   end if
   if (allocated(LineData%Aq)) then
      deallocate(LineData%Aq)
   end if
   if (allocated(LineData%B)) then
      deallocate(LineData%B)
   end if
   if (allocated(LineData%Bs)) then
      deallocate(LineData%Bs)
   end if
   if (allocated(LineData%Lf)) then
      deallocate(LineData%Lf)
   end if
   if (allocated(LineData%Fnet)) then
      deallocate(LineData%Fnet)
   end if
   if (allocated(LineData%S)) then
      deallocate(LineData%S)
   end if
   if (allocated(LineData%M)) then
      deallocate(LineData%M)
   end if
   if (allocated(LineData%LineWrOutput)) then
      deallocate(LineData%LineWrOutput)
   end if
   if (allocated(LineData%phi)) then
      deallocate(LineData%phi)
   end if
   if (allocated(LineData%yd_rms_old)) then
      deallocate(LineData%yd_rms_old)
   end if
   if (allocated(LineData%ydd_rms_old)) then
      deallocate(LineData%ydd_rms_old)
   end if
   if (allocated(LineData%rdd_old)) then
      deallocate(LineData%rdd_old)
   end if
end subroutine

subroutine MD_PackLine(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(MD_Line), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'MD_PackLine'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%IdNum)
   call RegPack(RF, InData%PropsIdNum)
   call RegPack(RF, InData%ElasticMod)
   call RegPack(RF, InData%OutFlagList)
   call RegPack(RF, InData%CtrlChan)
   call RegPack(RF, InData%FairPoint)
   call RegPack(RF, InData%AnchPoint)
   call RegPack(RF, InData%N)
   call RegPack(RF, InData%endTypeA)
   call RegPack(RF, InData%endTypeB)
   call RegPack(RF, InData%UnstrLen)
   call RegPack(RF, InData%rho)
   call RegPack(RF, InData%d)
   call RegPack(RF, InData%EA)
   call RegPack(RF, InData%EA_D)
   call RegPack(RF, InData%alphaMBL)
   call RegPack(RF, InData%vbeta)
   call RegPack(RF, InData%BA)
   call RegPack(RF, InData%BA_D)
   call RegPack(RF, InData%EI)
   call RegPack(RF, InData%Can)
   call RegPack(RF, InData%Cat)
   call RegPack(RF, InData%Cdn)
   call RegPack(RF, InData%Cdt)
   call RegPack(RF, InData%Cl)
   call RegPack(RF, InData%dF)
   call RegPack(RF, InData%cF)
   call RegPack(RF, InData%nEApoints)
   call RegPack(RF, InData%stiffXs)
   call RegPack(RF, InData%stiffYs)
   call RegPack(RF, InData%nBApoints)
   call RegPack(RF, InData%dampXs)
   call RegPack(RF, InData%dampYs)
   call RegPack(RF, InData%nEIpoints)
   call RegPack(RF, InData%bstiffXs)
   call RegPack(RF, InData%bstiffYs)
   call RegPack(RF, InData%time)
   call RegPackAlloc(RF, InData%r)
   call RegPackAlloc(RF, InData%rd)
   call RegPackAlloc(RF, InData%q)
   call RegPackAlloc(RF, InData%qs)
   call RegPackAlloc(RF, InData%l)
   call RegPackAlloc(RF, InData%ld)
   call RegPackAlloc(RF, InData%lstr)
   call RegPackAlloc(RF, InData%lstrd)
   call RegPackAlloc(RF, InData%Kurv)
   call RegPackAlloc(RF, InData%dl_1)
   call RegPackAlloc(RF, InData%V)
   call RegPackAlloc(RF, InData%F)
   call RegPackAlloc(RF, InData%U)
   call RegPackAlloc(RF, InData%Ud)
   call RegPackAlloc(RF, InData%zeta)
   call RegPackAlloc(RF, InData%PDyn)
   call RegPackAlloc(RF, InData%T)
   call RegPackAlloc(RF, InData%Td)
   call RegPackAlloc(RF, InData%W)
   call RegPackAlloc(RF, InData%Dp)
   call RegPackAlloc(RF, InData%Dq)
   call RegPackAlloc(RF, InData%Ap)
   call RegPackAlloc(RF, InData%Aq)
   call RegPackAlloc(RF, InData%B)
   call RegPackAlloc(RF, InData%Bs)
   call RegPackAlloc(RF, InData%Lf)
   call RegPackAlloc(RF, InData%Fnet)
   call RegPackAlloc(RF, InData%S)
   call RegPackAlloc(RF, InData%M)
   call RegPack(RF, InData%EndMomentA)
   call RegPack(RF, InData%EndMomentB)
   call RegPack(RF, InData%LineUnOut)
   call RegPackAlloc(RF, InData%LineWrOutput)
   call RegPackAlloc(RF, InData%phi)
   call RegPack(RF, InData%n_m)
   call RegPack(RF, InData%phi_yd)
   call RegPack(RF, InData%t_old)
   call RegPackAlloc(RF, InData%yd_rms_old)
   call RegPackAlloc(RF, InData%ydd_rms_old)
   call RegPackAlloc(RF, InData%rdd_old)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MD_UnPackLine(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(MD_Line), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'MD_UnPackLine'
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%IdNum); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PropsIdNum); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ElasticMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutFlagList); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CtrlChan); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FairPoint); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AnchPoint); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%N); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%endTypeA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%endTypeB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UnstrLen); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rho); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%d); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%EA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%EA_D); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%alphaMBL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%vbeta); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BA_D); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%EI); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Can); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cat); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cdn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cdt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%cF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nEApoints); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%stiffXs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%stiffYs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nBApoints); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dampXs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dampYs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nEIpoints); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%bstiffXs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%bstiffYs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%time); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%r); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%rd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%q); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%qs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%l); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%ld); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%lstr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%lstrd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Kurv); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%dl_1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%V); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%F); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%U); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Ud); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%zeta); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PDyn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%T); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Td); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%W); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Dp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Dq); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Ap); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Aq); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%B); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Bs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Lf); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Fnet); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%S); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%M); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%EndMomentA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%EndMomentB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LineUnOut); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LineWrOutput); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%phi); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%n_m); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%phi_yd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%t_old); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%yd_rms_old); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%ydd_rms_old); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%rdd_old); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MD_CopyExtLd(SrcExtLdData, DstExtLdData, CtrlCode, ErrStat, ErrMsg)
   type(MD_ExtLd), intent(in) :: SrcExtLdData
   type(MD_ExtLd), intent(inout) :: DstExtLdData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'MD_CopyExtLd'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstExtLdData%IdNum = SrcExtLdData%IdNum
   DstExtLdData%Fext = SrcExtLdData%Fext
   DstExtLdData%Blin = SrcExtLdData%Blin
   DstExtLdData%Bquad = SrcExtLdData%Bquad
   DstExtLdData%isGlobal = SrcExtLdData%isGlobal
end subroutine

subroutine MD_DestroyExtLd(ExtLdData, ErrStat, ErrMsg)
   type(MD_ExtLd), intent(inout) :: ExtLdData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'MD_DestroyExtLd'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine MD_PackExtLd(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(MD_ExtLd), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'MD_PackExtLd'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%IdNum)
   call RegPack(RF, InData%Fext)
   call RegPack(RF, InData%Blin)
   call RegPack(RF, InData%Bquad)
   call RegPack(RF, InData%isGlobal)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MD_UnPackExtLd(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(MD_ExtLd), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'MD_UnPackExtLd'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%IdNum); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Fext); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Blin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Bquad); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%isGlobal); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MD_CopyFail(SrcFailData, DstFailData, CtrlCode, ErrStat, ErrMsg)
   type(MD_Fail), intent(in) :: SrcFailData
   type(MD_Fail), intent(inout) :: DstFailData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'MD_CopyFail'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstFailData%IdNum = SrcFailData%IdNum
   DstFailData%attachID = SrcFailData%attachID
   DstFailData%isRod = SrcFailData%isRod
   DstFailData%lineIDs = SrcFailData%lineIDs
   DstFailData%lineTops = SrcFailData%lineTops
   DstFailData%nLinesToDetach = SrcFailData%nLinesToDetach
   DstFailData%failTime = SrcFailData%failTime
   DstFailData%failTen = SrcFailData%failTen
   DstFailData%failStatus = SrcFailData%failStatus
end subroutine

subroutine MD_DestroyFail(FailData, ErrStat, ErrMsg)
   type(MD_Fail), intent(inout) :: FailData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'MD_DestroyFail'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine MD_PackFail(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(MD_Fail), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'MD_PackFail'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%IdNum)
   call RegPack(RF, InData%attachID)
   call RegPack(RF, InData%isRod)
   call RegPack(RF, InData%lineIDs)
   call RegPack(RF, InData%lineTops)
   call RegPack(RF, InData%nLinesToDetach)
   call RegPack(RF, InData%failTime)
   call RegPack(RF, InData%failTen)
   call RegPack(RF, InData%failStatus)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MD_UnPackFail(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(MD_Fail), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'MD_UnPackFail'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%IdNum); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%attachID); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%isRod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%lineIDs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%lineTops); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nLinesToDetach); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%failTime); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%failTen); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%failStatus); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MD_CopyOutParmType(SrcOutParmTypeData, DstOutParmTypeData, CtrlCode, ErrStat, ErrMsg)
   type(MD_OutParmType), intent(in) :: SrcOutParmTypeData
   type(MD_OutParmType), intent(inout) :: DstOutParmTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'MD_CopyOutParmType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstOutParmTypeData%Name = SrcOutParmTypeData%Name
   DstOutParmTypeData%Units = SrcOutParmTypeData%Units
   DstOutParmTypeData%QType = SrcOutParmTypeData%QType
   DstOutParmTypeData%OType = SrcOutParmTypeData%OType
   DstOutParmTypeData%NodeID = SrcOutParmTypeData%NodeID
   DstOutParmTypeData%ObjID = SrcOutParmTypeData%ObjID
end subroutine

subroutine MD_DestroyOutParmType(OutParmTypeData, ErrStat, ErrMsg)
   type(MD_OutParmType), intent(inout) :: OutParmTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'MD_DestroyOutParmType'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine MD_PackOutParmType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(MD_OutParmType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'MD_PackOutParmType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%Name)
   call RegPack(RF, InData%Units)
   call RegPack(RF, InData%QType)
   call RegPack(RF, InData%OType)
   call RegPack(RF, InData%NodeID)
   call RegPack(RF, InData%ObjID)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MD_UnPackOutParmType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(MD_OutParmType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'MD_UnPackOutParmType'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%Name); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Units); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%QType); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OType); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NodeID); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ObjID); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MD_CopyVisDiam(SrcVisDiamData, DstVisDiamData, CtrlCode, ErrStat, ErrMsg)
   type(VisDiam), intent(in) :: SrcVisDiamData
   type(VisDiam), intent(inout) :: DstVisDiamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'MD_CopyVisDiam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcVisDiamData%Diam)) then
      LB(1:1) = lbound(SrcVisDiamData%Diam)
      UB(1:1) = ubound(SrcVisDiamData%Diam)
      if (.not. allocated(DstVisDiamData%Diam)) then
         allocate(DstVisDiamData%Diam(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstVisDiamData%Diam.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstVisDiamData%Diam = SrcVisDiamData%Diam
   end if
end subroutine

subroutine MD_DestroyVisDiam(VisDiamData, ErrStat, ErrMsg)
   type(VisDiam), intent(inout) :: VisDiamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'MD_DestroyVisDiam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(VisDiamData%Diam)) then
      deallocate(VisDiamData%Diam)
   end if
end subroutine

subroutine MD_PackVisDiam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(VisDiam), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'MD_PackVisDiam'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%Diam)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MD_UnPackVisDiam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(VisDiam), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'MD_UnPackVisDiam'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%Diam); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MD_CopyInitOutput(SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg)
   type(MD_InitOutputType), intent(in) :: SrcInitOutputData
   type(MD_InitOutputType), intent(inout) :: DstInitOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'MD_CopyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcInitOutputData%writeOutputHdr)) then
      LB(1:1) = lbound(SrcInitOutputData%writeOutputHdr)
      UB(1:1) = ubound(SrcInitOutputData%writeOutputHdr)
      if (.not. allocated(DstInitOutputData%writeOutputHdr)) then
         allocate(DstInitOutputData%writeOutputHdr(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%writeOutputHdr.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%writeOutputHdr = SrcInitOutputData%writeOutputHdr
   end if
   if (allocated(SrcInitOutputData%writeOutputUnt)) then
      LB(1:1) = lbound(SrcInitOutputData%writeOutputUnt)
      UB(1:1) = ubound(SrcInitOutputData%writeOutputUnt)
      if (.not. allocated(DstInitOutputData%writeOutputUnt)) then
         allocate(DstInitOutputData%writeOutputUnt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%writeOutputUnt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%writeOutputUnt = SrcInitOutputData%writeOutputUnt
   end if
   call NWTC_Library_CopyProgDesc(SrcInitOutputData%Ver, DstInitOutputData%Ver, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcInitOutputData%CableCChanRqst)) then
      LB(1:1) = lbound(SrcInitOutputData%CableCChanRqst)
      UB(1:1) = ubound(SrcInitOutputData%CableCChanRqst)
      if (.not. allocated(DstInitOutputData%CableCChanRqst)) then
         allocate(DstInitOutputData%CableCChanRqst(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%CableCChanRqst.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%CableCChanRqst = SrcInitOutputData%CableCChanRqst
   end if
   if (allocated(SrcInitOutputData%LinNames_y)) then
      LB(1:1) = lbound(SrcInitOutputData%LinNames_y)
      UB(1:1) = ubound(SrcInitOutputData%LinNames_y)
      if (.not. allocated(DstInitOutputData%LinNames_y)) then
         allocate(DstInitOutputData%LinNames_y(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LinNames_y.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%LinNames_y = SrcInitOutputData%LinNames_y
   end if
   if (allocated(SrcInitOutputData%LinNames_x)) then
      LB(1:1) = lbound(SrcInitOutputData%LinNames_x)
      UB(1:1) = ubound(SrcInitOutputData%LinNames_x)
      if (.not. allocated(DstInitOutputData%LinNames_x)) then
         allocate(DstInitOutputData%LinNames_x(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LinNames_x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%LinNames_x = SrcInitOutputData%LinNames_x
   end if
   if (allocated(SrcInitOutputData%LinNames_u)) then
      LB(1:1) = lbound(SrcInitOutputData%LinNames_u)
      UB(1:1) = ubound(SrcInitOutputData%LinNames_u)
      if (.not. allocated(DstInitOutputData%LinNames_u)) then
         allocate(DstInitOutputData%LinNames_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LinNames_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%LinNames_u = SrcInitOutputData%LinNames_u
   end if
   if (allocated(SrcInitOutputData%RotFrame_y)) then
      LB(1:1) = lbound(SrcInitOutputData%RotFrame_y)
      UB(1:1) = ubound(SrcInitOutputData%RotFrame_y)
      if (.not. allocated(DstInitOutputData%RotFrame_y)) then
         allocate(DstInitOutputData%RotFrame_y(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%RotFrame_y.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%RotFrame_y = SrcInitOutputData%RotFrame_y
   end if
   if (allocated(SrcInitOutputData%RotFrame_x)) then
      LB(1:1) = lbound(SrcInitOutputData%RotFrame_x)
      UB(1:1) = ubound(SrcInitOutputData%RotFrame_x)
      if (.not. allocated(DstInitOutputData%RotFrame_x)) then
         allocate(DstInitOutputData%RotFrame_x(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%RotFrame_x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%RotFrame_x = SrcInitOutputData%RotFrame_x
   end if
   if (allocated(SrcInitOutputData%RotFrame_u)) then
      LB(1:1) = lbound(SrcInitOutputData%RotFrame_u)
      UB(1:1) = ubound(SrcInitOutputData%RotFrame_u)
      if (.not. allocated(DstInitOutputData%RotFrame_u)) then
         allocate(DstInitOutputData%RotFrame_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%RotFrame_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%RotFrame_u = SrcInitOutputData%RotFrame_u
   end if
   if (allocated(SrcInitOutputData%IsLoad_u)) then
      LB(1:1) = lbound(SrcInitOutputData%IsLoad_u)
      UB(1:1) = ubound(SrcInitOutputData%IsLoad_u)
      if (.not. allocated(DstInitOutputData%IsLoad_u)) then
         allocate(DstInitOutputData%IsLoad_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%IsLoad_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%IsLoad_u = SrcInitOutputData%IsLoad_u
   end if
   if (allocated(SrcInitOutputData%DerivOrder_x)) then
      LB(1:1) = lbound(SrcInitOutputData%DerivOrder_x)
      UB(1:1) = ubound(SrcInitOutputData%DerivOrder_x)
      if (.not. allocated(DstInitOutputData%DerivOrder_x)) then
         allocate(DstInitOutputData%DerivOrder_x(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%DerivOrder_x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%DerivOrder_x = SrcInitOutputData%DerivOrder_x
   end if
end subroutine

subroutine MD_DestroyInitOutput(InitOutputData, ErrStat, ErrMsg)
   type(MD_InitOutputType), intent(inout) :: InitOutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'MD_DestroyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InitOutputData%writeOutputHdr)) then
      deallocate(InitOutputData%writeOutputHdr)
   end if
   if (allocated(InitOutputData%writeOutputUnt)) then
      deallocate(InitOutputData%writeOutputUnt)
   end if
   call NWTC_Library_DestroyProgDesc(InitOutputData%Ver, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(InitOutputData%CableCChanRqst)) then
      deallocate(InitOutputData%CableCChanRqst)
   end if
   if (allocated(InitOutputData%LinNames_y)) then
      deallocate(InitOutputData%LinNames_y)
   end if
   if (allocated(InitOutputData%LinNames_x)) then
      deallocate(InitOutputData%LinNames_x)
   end if
   if (allocated(InitOutputData%LinNames_u)) then
      deallocate(InitOutputData%LinNames_u)
   end if
   if (allocated(InitOutputData%RotFrame_y)) then
      deallocate(InitOutputData%RotFrame_y)
   end if
   if (allocated(InitOutputData%RotFrame_x)) then
      deallocate(InitOutputData%RotFrame_x)
   end if
   if (allocated(InitOutputData%RotFrame_u)) then
      deallocate(InitOutputData%RotFrame_u)
   end if
   if (allocated(InitOutputData%IsLoad_u)) then
      deallocate(InitOutputData%IsLoad_u)
   end if
   if (allocated(InitOutputData%DerivOrder_x)) then
      deallocate(InitOutputData%DerivOrder_x)
   end if
end subroutine

subroutine MD_PackInitOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(MD_InitOutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'MD_PackInitOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%writeOutputHdr)
   call RegPackAlloc(RF, InData%writeOutputUnt)
   call NWTC_Library_PackProgDesc(RF, InData%Ver) 
   call RegPackAlloc(RF, InData%CableCChanRqst)
   call RegPackAlloc(RF, InData%LinNames_y)
   call RegPackAlloc(RF, InData%LinNames_x)
   call RegPackAlloc(RF, InData%LinNames_u)
   call RegPackAlloc(RF, InData%RotFrame_y)
   call RegPackAlloc(RF, InData%RotFrame_x)
   call RegPackAlloc(RF, InData%RotFrame_u)
   call RegPackAlloc(RF, InData%IsLoad_u)
   call RegPackAlloc(RF, InData%DerivOrder_x)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MD_UnPackInitOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(MD_InitOutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'MD_UnPackInitOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%writeOutputHdr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%writeOutputUnt); if (RegCheckErr(RF, RoutineName)) return
   call NWTC_Library_UnpackProgDesc(RF, OutData%Ver) ! Ver 
   call RegUnpackAlloc(RF, OutData%CableCChanRqst); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LinNames_y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LinNames_x); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LinNames_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RotFrame_y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RotFrame_x); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RotFrame_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%IsLoad_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%DerivOrder_x); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MD_CopyContState(SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg)
   type(MD_ContinuousStateType), intent(in) :: SrcContStateData
   type(MD_ContinuousStateType), intent(inout) :: DstContStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'MD_CopyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcContStateData%states)) then
      LB(1:1) = lbound(SrcContStateData%states)
      UB(1:1) = ubound(SrcContStateData%states)
      if (.not. allocated(DstContStateData%states)) then
         allocate(DstContStateData%states(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstContStateData%states.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstContStateData%states = SrcContStateData%states
   end if
end subroutine

subroutine MD_DestroyContState(ContStateData, ErrStat, ErrMsg)
   type(MD_ContinuousStateType), intent(inout) :: ContStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'MD_DestroyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ContStateData%states)) then
      deallocate(ContStateData%states)
   end if
end subroutine

subroutine MD_PackContState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(MD_ContinuousStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'MD_PackContState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%states)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MD_UnPackContState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(MD_ContinuousStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'MD_UnPackContState'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%states); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MD_CopyDiscState(SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg)
   type(MD_DiscreteStateType), intent(in) :: SrcDiscStateData
   type(MD_DiscreteStateType), intent(inout) :: DstDiscStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'MD_CopyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstDiscStateData%dummy = SrcDiscStateData%dummy
end subroutine

subroutine MD_DestroyDiscState(DiscStateData, ErrStat, ErrMsg)
   type(MD_DiscreteStateType), intent(inout) :: DiscStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'MD_DestroyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine MD_PackDiscState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(MD_DiscreteStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'MD_PackDiscState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%dummy)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MD_UnPackDiscState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(MD_DiscreteStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'MD_UnPackDiscState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%dummy); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MD_CopyConstrState(SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg)
   type(MD_ConstraintStateType), intent(in) :: SrcConstrStateData
   type(MD_ConstraintStateType), intent(inout) :: DstConstrStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'MD_CopyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstConstrStateData%dummy = SrcConstrStateData%dummy
end subroutine

subroutine MD_DestroyConstrState(ConstrStateData, ErrStat, ErrMsg)
   type(MD_ConstraintStateType), intent(inout) :: ConstrStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'MD_DestroyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine MD_PackConstrState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(MD_ConstraintStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'MD_PackConstrState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%dummy)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MD_UnPackConstrState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(MD_ConstraintStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'MD_UnPackConstrState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%dummy); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MD_CopyOtherState(SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg)
   type(MD_OtherStateType), intent(in) :: SrcOtherStateData
   type(MD_OtherStateType), intent(inout) :: DstOtherStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'MD_CopyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstOtherStateData%dummy = SrcOtherStateData%dummy
end subroutine

subroutine MD_DestroyOtherState(OtherStateData, ErrStat, ErrMsg)
   type(MD_OtherStateType), intent(inout) :: OtherStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'MD_DestroyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine MD_PackOtherState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(MD_OtherStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'MD_PackOtherState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%dummy)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MD_UnPackOtherState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(MD_OtherStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'MD_UnPackOtherState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%dummy); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MD_CopyMisc(SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg)
   type(MD_MiscVarType), intent(in) :: SrcMiscData
   type(MD_MiscVarType), intent(inout) :: DstMiscData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'MD_CopyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcMiscData%LineTypeList)) then
      LB(1:1) = lbound(SrcMiscData%LineTypeList)
      UB(1:1) = ubound(SrcMiscData%LineTypeList)
      if (.not. allocated(DstMiscData%LineTypeList)) then
         allocate(DstMiscData%LineTypeList(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%LineTypeList.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MD_CopyLineProp(SrcMiscData%LineTypeList(i1), DstMiscData%LineTypeList(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcMiscData%RodTypeList)) then
      LB(1:1) = lbound(SrcMiscData%RodTypeList)
      UB(1:1) = ubound(SrcMiscData%RodTypeList)
      if (.not. allocated(DstMiscData%RodTypeList)) then
         allocate(DstMiscData%RodTypeList(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%RodTypeList.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MD_CopyRodProp(SrcMiscData%RodTypeList(i1), DstMiscData%RodTypeList(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call MD_CopyBody(SrcMiscData%GroundBody, DstMiscData%GroundBody, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcMiscData%BodyList)) then
      LB(1:1) = lbound(SrcMiscData%BodyList)
      UB(1:1) = ubound(SrcMiscData%BodyList)
      if (.not. allocated(DstMiscData%BodyList)) then
         allocate(DstMiscData%BodyList(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%BodyList.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MD_CopyBody(SrcMiscData%BodyList(i1), DstMiscData%BodyList(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcMiscData%RodList)) then
      LB(1:1) = lbound(SrcMiscData%RodList)
      UB(1:1) = ubound(SrcMiscData%RodList)
      if (.not. allocated(DstMiscData%RodList)) then
         allocate(DstMiscData%RodList(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%RodList.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MD_CopyRod(SrcMiscData%RodList(i1), DstMiscData%RodList(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcMiscData%PointList)) then
      LB(1:1) = lbound(SrcMiscData%PointList)
      UB(1:1) = ubound(SrcMiscData%PointList)
      if (.not. allocated(DstMiscData%PointList)) then
         allocate(DstMiscData%PointList(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%PointList.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MD_CopyPoint(SrcMiscData%PointList(i1), DstMiscData%PointList(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcMiscData%LineList)) then
      LB(1:1) = lbound(SrcMiscData%LineList)
      UB(1:1) = ubound(SrcMiscData%LineList)
      if (.not. allocated(DstMiscData%LineList)) then
         allocate(DstMiscData%LineList(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%LineList.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MD_CopyLine(SrcMiscData%LineList(i1), DstMiscData%LineList(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcMiscData%ExtLdList)) then
      LB(1:1) = lbound(SrcMiscData%ExtLdList)
      UB(1:1) = ubound(SrcMiscData%ExtLdList)
      if (.not. allocated(DstMiscData%ExtLdList)) then
         allocate(DstMiscData%ExtLdList(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%ExtLdList.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MD_CopyExtLd(SrcMiscData%ExtLdList(i1), DstMiscData%ExtLdList(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcMiscData%FailList)) then
      LB(1:1) = lbound(SrcMiscData%FailList)
      UB(1:1) = ubound(SrcMiscData%FailList)
      if (.not. allocated(DstMiscData%FailList)) then
         allocate(DstMiscData%FailList(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%FailList.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MD_CopyFail(SrcMiscData%FailList(i1), DstMiscData%FailList(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcMiscData%FreePointIs)) then
      LB(1:1) = lbound(SrcMiscData%FreePointIs)
      UB(1:1) = ubound(SrcMiscData%FreePointIs)
      if (.not. allocated(DstMiscData%FreePointIs)) then
         allocate(DstMiscData%FreePointIs(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%FreePointIs.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%FreePointIs = SrcMiscData%FreePointIs
   end if
   if (allocated(SrcMiscData%CpldPointIs)) then
      LB(1:2) = lbound(SrcMiscData%CpldPointIs)
      UB(1:2) = ubound(SrcMiscData%CpldPointIs)
      if (.not. allocated(DstMiscData%CpldPointIs)) then
         allocate(DstMiscData%CpldPointIs(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%CpldPointIs.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%CpldPointIs = SrcMiscData%CpldPointIs
   end if
   if (allocated(SrcMiscData%FreeRodIs)) then
      LB(1:1) = lbound(SrcMiscData%FreeRodIs)
      UB(1:1) = ubound(SrcMiscData%FreeRodIs)
      if (.not. allocated(DstMiscData%FreeRodIs)) then
         allocate(DstMiscData%FreeRodIs(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%FreeRodIs.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%FreeRodIs = SrcMiscData%FreeRodIs
   end if
   if (allocated(SrcMiscData%CpldRodIs)) then
      LB(1:2) = lbound(SrcMiscData%CpldRodIs)
      UB(1:2) = ubound(SrcMiscData%CpldRodIs)
      if (.not. allocated(DstMiscData%CpldRodIs)) then
         allocate(DstMiscData%CpldRodIs(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%CpldRodIs.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%CpldRodIs = SrcMiscData%CpldRodIs
   end if
   if (allocated(SrcMiscData%FreeBodyIs)) then
      LB(1:1) = lbound(SrcMiscData%FreeBodyIs)
      UB(1:1) = ubound(SrcMiscData%FreeBodyIs)
      if (.not. allocated(DstMiscData%FreeBodyIs)) then
         allocate(DstMiscData%FreeBodyIs(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%FreeBodyIs.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%FreeBodyIs = SrcMiscData%FreeBodyIs
   end if
   if (allocated(SrcMiscData%CpldBodyIs)) then
      LB(1:2) = lbound(SrcMiscData%CpldBodyIs)
      UB(1:2) = ubound(SrcMiscData%CpldBodyIs)
      if (.not. allocated(DstMiscData%CpldBodyIs)) then
         allocate(DstMiscData%CpldBodyIs(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%CpldBodyIs.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%CpldBodyIs = SrcMiscData%CpldBodyIs
   end if
   if (allocated(SrcMiscData%LineStateIs1)) then
      LB(1:1) = lbound(SrcMiscData%LineStateIs1)
      UB(1:1) = ubound(SrcMiscData%LineStateIs1)
      if (.not. allocated(DstMiscData%LineStateIs1)) then
         allocate(DstMiscData%LineStateIs1(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%LineStateIs1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%LineStateIs1 = SrcMiscData%LineStateIs1
   end if
   if (allocated(SrcMiscData%LineStateIsN)) then
      LB(1:1) = lbound(SrcMiscData%LineStateIsN)
      UB(1:1) = ubound(SrcMiscData%LineStateIsN)
      if (.not. allocated(DstMiscData%LineStateIsN)) then
         allocate(DstMiscData%LineStateIsN(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%LineStateIsN.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%LineStateIsN = SrcMiscData%LineStateIsN
   end if
   if (allocated(SrcMiscData%PointStateIs1)) then
      LB(1:1) = lbound(SrcMiscData%PointStateIs1)
      UB(1:1) = ubound(SrcMiscData%PointStateIs1)
      if (.not. allocated(DstMiscData%PointStateIs1)) then
         allocate(DstMiscData%PointStateIs1(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%PointStateIs1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%PointStateIs1 = SrcMiscData%PointStateIs1
   end if
   if (allocated(SrcMiscData%PointStateIsN)) then
      LB(1:1) = lbound(SrcMiscData%PointStateIsN)
      UB(1:1) = ubound(SrcMiscData%PointStateIsN)
      if (.not. allocated(DstMiscData%PointStateIsN)) then
         allocate(DstMiscData%PointStateIsN(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%PointStateIsN.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%PointStateIsN = SrcMiscData%PointStateIsN
   end if
   if (allocated(SrcMiscData%RodStateIs1)) then
      LB(1:1) = lbound(SrcMiscData%RodStateIs1)
      UB(1:1) = ubound(SrcMiscData%RodStateIs1)
      if (.not. allocated(DstMiscData%RodStateIs1)) then
         allocate(DstMiscData%RodStateIs1(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%RodStateIs1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%RodStateIs1 = SrcMiscData%RodStateIs1
   end if
   if (allocated(SrcMiscData%RodStateIsN)) then
      LB(1:1) = lbound(SrcMiscData%RodStateIsN)
      UB(1:1) = ubound(SrcMiscData%RodStateIsN)
      if (.not. allocated(DstMiscData%RodStateIsN)) then
         allocate(DstMiscData%RodStateIsN(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%RodStateIsN.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%RodStateIsN = SrcMiscData%RodStateIsN
   end if
   if (allocated(SrcMiscData%BodyStateIs1)) then
      LB(1:1) = lbound(SrcMiscData%BodyStateIs1)
      UB(1:1) = ubound(SrcMiscData%BodyStateIs1)
      if (.not. allocated(DstMiscData%BodyStateIs1)) then
         allocate(DstMiscData%BodyStateIs1(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%BodyStateIs1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%BodyStateIs1 = SrcMiscData%BodyStateIs1
   end if
   if (allocated(SrcMiscData%BodyStateIsN)) then
      LB(1:1) = lbound(SrcMiscData%BodyStateIsN)
      UB(1:1) = ubound(SrcMiscData%BodyStateIsN)
      if (.not. allocated(DstMiscData%BodyStateIsN)) then
         allocate(DstMiscData%BodyStateIsN(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%BodyStateIsN.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%BodyStateIsN = SrcMiscData%BodyStateIsN
   end if
   DstMiscData%Nx = SrcMiscData%Nx
   DstMiscData%Nxtra = SrcMiscData%Nxtra
   DstMiscData%WaveTi = SrcMiscData%WaveTi
   call MD_CopyContState(SrcMiscData%xTemp, DstMiscData%xTemp, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MD_CopyContState(SrcMiscData%xdTemp, DstMiscData%xdTemp, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MD_CopyContState(SrcMiscData%kSum, DstMiscData%kSum, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstMiscData%zeros6 = SrcMiscData%zeros6
   if (allocated(SrcMiscData%MDWrOutput)) then
      LB(1:1) = lbound(SrcMiscData%MDWrOutput)
      UB(1:1) = ubound(SrcMiscData%MDWrOutput)
      if (.not. allocated(DstMiscData%MDWrOutput)) then
         allocate(DstMiscData%MDWrOutput(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%MDWrOutput.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%MDWrOutput = SrcMiscData%MDWrOutput
   end if
   DstMiscData%LastOutTime = SrcMiscData%LastOutTime
   DstMiscData%PtfmInit = SrcMiscData%PtfmInit
   if (allocated(SrcMiscData%BathymetryGrid)) then
      LB(1:2) = lbound(SrcMiscData%BathymetryGrid)
      UB(1:2) = ubound(SrcMiscData%BathymetryGrid)
      if (.not. allocated(DstMiscData%BathymetryGrid)) then
         allocate(DstMiscData%BathymetryGrid(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%BathymetryGrid.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%BathymetryGrid = SrcMiscData%BathymetryGrid
   end if
   if (allocated(SrcMiscData%BathGrid_Xs)) then
      LB(1:1) = lbound(SrcMiscData%BathGrid_Xs)
      UB(1:1) = ubound(SrcMiscData%BathGrid_Xs)
      if (.not. allocated(DstMiscData%BathGrid_Xs)) then
         allocate(DstMiscData%BathGrid_Xs(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%BathGrid_Xs.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%BathGrid_Xs = SrcMiscData%BathGrid_Xs
   end if
   if (allocated(SrcMiscData%BathGrid_Ys)) then
      LB(1:1) = lbound(SrcMiscData%BathGrid_Ys)
      UB(1:1) = ubound(SrcMiscData%BathGrid_Ys)
      if (.not. allocated(DstMiscData%BathGrid_Ys)) then
         allocate(DstMiscData%BathGrid_Ys(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%BathGrid_Ys.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%BathGrid_Ys = SrcMiscData%BathGrid_Ys
   end if
   if (allocated(SrcMiscData%BathGrid_npoints)) then
      LB(1:1) = lbound(SrcMiscData%BathGrid_npoints)
      UB(1:1) = ubound(SrcMiscData%BathGrid_npoints)
      if (.not. allocated(DstMiscData%BathGrid_npoints)) then
         allocate(DstMiscData%BathGrid_npoints(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%BathGrid_npoints.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%BathGrid_npoints = SrcMiscData%BathGrid_npoints
   end if
   call SeaSt_WaveField_CopyMisc(SrcMiscData%WaveField_m, DstMiscData%WaveField_m, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstMiscData%IC_gen = SrcMiscData%IC_gen
end subroutine

subroutine MD_DestroyMisc(MiscData, ErrStat, ErrMsg)
   type(MD_MiscVarType), intent(inout) :: MiscData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'MD_DestroyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(MiscData%LineTypeList)) then
      LB(1:1) = lbound(MiscData%LineTypeList)
      UB(1:1) = ubound(MiscData%LineTypeList)
      do i1 = LB(1), UB(1)
         call MD_DestroyLineProp(MiscData%LineTypeList(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MiscData%LineTypeList)
   end if
   if (allocated(MiscData%RodTypeList)) then
      LB(1:1) = lbound(MiscData%RodTypeList)
      UB(1:1) = ubound(MiscData%RodTypeList)
      do i1 = LB(1), UB(1)
         call MD_DestroyRodProp(MiscData%RodTypeList(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MiscData%RodTypeList)
   end if
   call MD_DestroyBody(MiscData%GroundBody, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(MiscData%BodyList)) then
      LB(1:1) = lbound(MiscData%BodyList)
      UB(1:1) = ubound(MiscData%BodyList)
      do i1 = LB(1), UB(1)
         call MD_DestroyBody(MiscData%BodyList(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MiscData%BodyList)
   end if
   if (allocated(MiscData%RodList)) then
      LB(1:1) = lbound(MiscData%RodList)
      UB(1:1) = ubound(MiscData%RodList)
      do i1 = LB(1), UB(1)
         call MD_DestroyRod(MiscData%RodList(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MiscData%RodList)
   end if
   if (allocated(MiscData%PointList)) then
      LB(1:1) = lbound(MiscData%PointList)
      UB(1:1) = ubound(MiscData%PointList)
      do i1 = LB(1), UB(1)
         call MD_DestroyPoint(MiscData%PointList(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MiscData%PointList)
   end if
   if (allocated(MiscData%LineList)) then
      LB(1:1) = lbound(MiscData%LineList)
      UB(1:1) = ubound(MiscData%LineList)
      do i1 = LB(1), UB(1)
         call MD_DestroyLine(MiscData%LineList(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MiscData%LineList)
   end if
   if (allocated(MiscData%ExtLdList)) then
      LB(1:1) = lbound(MiscData%ExtLdList)
      UB(1:1) = ubound(MiscData%ExtLdList)
      do i1 = LB(1), UB(1)
         call MD_DestroyExtLd(MiscData%ExtLdList(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MiscData%ExtLdList)
   end if
   if (allocated(MiscData%FailList)) then
      LB(1:1) = lbound(MiscData%FailList)
      UB(1:1) = ubound(MiscData%FailList)
      do i1 = LB(1), UB(1)
         call MD_DestroyFail(MiscData%FailList(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MiscData%FailList)
   end if
   if (allocated(MiscData%FreePointIs)) then
      deallocate(MiscData%FreePointIs)
   end if
   if (allocated(MiscData%CpldPointIs)) then
      deallocate(MiscData%CpldPointIs)
   end if
   if (allocated(MiscData%FreeRodIs)) then
      deallocate(MiscData%FreeRodIs)
   end if
   if (allocated(MiscData%CpldRodIs)) then
      deallocate(MiscData%CpldRodIs)
   end if
   if (allocated(MiscData%FreeBodyIs)) then
      deallocate(MiscData%FreeBodyIs)
   end if
   if (allocated(MiscData%CpldBodyIs)) then
      deallocate(MiscData%CpldBodyIs)
   end if
   if (allocated(MiscData%LineStateIs1)) then
      deallocate(MiscData%LineStateIs1)
   end if
   if (allocated(MiscData%LineStateIsN)) then
      deallocate(MiscData%LineStateIsN)
   end if
   if (allocated(MiscData%PointStateIs1)) then
      deallocate(MiscData%PointStateIs1)
   end if
   if (allocated(MiscData%PointStateIsN)) then
      deallocate(MiscData%PointStateIsN)
   end if
   if (allocated(MiscData%RodStateIs1)) then
      deallocate(MiscData%RodStateIs1)
   end if
   if (allocated(MiscData%RodStateIsN)) then
      deallocate(MiscData%RodStateIsN)
   end if
   if (allocated(MiscData%BodyStateIs1)) then
      deallocate(MiscData%BodyStateIs1)
   end if
   if (allocated(MiscData%BodyStateIsN)) then
      deallocate(MiscData%BodyStateIsN)
   end if
   call MD_DestroyContState(MiscData%xTemp, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MD_DestroyContState(MiscData%xdTemp, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MD_DestroyContState(MiscData%kSum, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(MiscData%MDWrOutput)) then
      deallocate(MiscData%MDWrOutput)
   end if
   if (allocated(MiscData%BathymetryGrid)) then
      deallocate(MiscData%BathymetryGrid)
   end if
   if (allocated(MiscData%BathGrid_Xs)) then
      deallocate(MiscData%BathGrid_Xs)
   end if
   if (allocated(MiscData%BathGrid_Ys)) then
      deallocate(MiscData%BathGrid_Ys)
   end if
   if (allocated(MiscData%BathGrid_npoints)) then
      deallocate(MiscData%BathGrid_npoints)
   end if
   call SeaSt_WaveField_DestroyMisc(MiscData%WaveField_m, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine MD_PackMisc(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(MD_MiscVarType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'MD_PackMisc'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%LineTypeList))
   if (allocated(InData%LineTypeList)) then
      call RegPackBounds(RF, 1, lbound(InData%LineTypeList), ubound(InData%LineTypeList))
      LB(1:1) = lbound(InData%LineTypeList)
      UB(1:1) = ubound(InData%LineTypeList)
      do i1 = LB(1), UB(1)
         call MD_PackLineProp(RF, InData%LineTypeList(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%RodTypeList))
   if (allocated(InData%RodTypeList)) then
      call RegPackBounds(RF, 1, lbound(InData%RodTypeList), ubound(InData%RodTypeList))
      LB(1:1) = lbound(InData%RodTypeList)
      UB(1:1) = ubound(InData%RodTypeList)
      do i1 = LB(1), UB(1)
         call MD_PackRodProp(RF, InData%RodTypeList(i1)) 
      end do
   end if
   call MD_PackBody(RF, InData%GroundBody) 
   call RegPack(RF, allocated(InData%BodyList))
   if (allocated(InData%BodyList)) then
      call RegPackBounds(RF, 1, lbound(InData%BodyList), ubound(InData%BodyList))
      LB(1:1) = lbound(InData%BodyList)
      UB(1:1) = ubound(InData%BodyList)
      do i1 = LB(1), UB(1)
         call MD_PackBody(RF, InData%BodyList(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%RodList))
   if (allocated(InData%RodList)) then
      call RegPackBounds(RF, 1, lbound(InData%RodList), ubound(InData%RodList))
      LB(1:1) = lbound(InData%RodList)
      UB(1:1) = ubound(InData%RodList)
      do i1 = LB(1), UB(1)
         call MD_PackRod(RF, InData%RodList(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%PointList))
   if (allocated(InData%PointList)) then
      call RegPackBounds(RF, 1, lbound(InData%PointList), ubound(InData%PointList))
      LB(1:1) = lbound(InData%PointList)
      UB(1:1) = ubound(InData%PointList)
      do i1 = LB(1), UB(1)
         call MD_PackPoint(RF, InData%PointList(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%LineList))
   if (allocated(InData%LineList)) then
      call RegPackBounds(RF, 1, lbound(InData%LineList), ubound(InData%LineList))
      LB(1:1) = lbound(InData%LineList)
      UB(1:1) = ubound(InData%LineList)
      do i1 = LB(1), UB(1)
         call MD_PackLine(RF, InData%LineList(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%ExtLdList))
   if (allocated(InData%ExtLdList)) then
      call RegPackBounds(RF, 1, lbound(InData%ExtLdList), ubound(InData%ExtLdList))
      LB(1:1) = lbound(InData%ExtLdList)
      UB(1:1) = ubound(InData%ExtLdList)
      do i1 = LB(1), UB(1)
         call MD_PackExtLd(RF, InData%ExtLdList(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%FailList))
   if (allocated(InData%FailList)) then
      call RegPackBounds(RF, 1, lbound(InData%FailList), ubound(InData%FailList))
      LB(1:1) = lbound(InData%FailList)
      UB(1:1) = ubound(InData%FailList)
      do i1 = LB(1), UB(1)
         call MD_PackFail(RF, InData%FailList(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%FreePointIs)
   call RegPackAlloc(RF, InData%CpldPointIs)
   call RegPackAlloc(RF, InData%FreeRodIs)
   call RegPackAlloc(RF, InData%CpldRodIs)
   call RegPackAlloc(RF, InData%FreeBodyIs)
   call RegPackAlloc(RF, InData%CpldBodyIs)
   call RegPackAlloc(RF, InData%LineStateIs1)
   call RegPackAlloc(RF, InData%LineStateIsN)
   call RegPackAlloc(RF, InData%PointStateIs1)
   call RegPackAlloc(RF, InData%PointStateIsN)
   call RegPackAlloc(RF, InData%RodStateIs1)
   call RegPackAlloc(RF, InData%RodStateIsN)
   call RegPackAlloc(RF, InData%BodyStateIs1)
   call RegPackAlloc(RF, InData%BodyStateIsN)
   call RegPack(RF, InData%Nx)
   call RegPack(RF, InData%Nxtra)
   call RegPack(RF, InData%WaveTi)
   call MD_PackContState(RF, InData%xTemp) 
   call MD_PackContState(RF, InData%xdTemp) 
   call MD_PackContState(RF, InData%kSum) 
   call RegPack(RF, InData%zeros6)
   call RegPackAlloc(RF, InData%MDWrOutput)
   call RegPack(RF, InData%LastOutTime)
   call RegPack(RF, InData%PtfmInit)
   call RegPackAlloc(RF, InData%BathymetryGrid)
   call RegPackAlloc(RF, InData%BathGrid_Xs)
   call RegPackAlloc(RF, InData%BathGrid_Ys)
   call RegPackAlloc(RF, InData%BathGrid_npoints)
   call SeaSt_WaveField_PackMisc(RF, InData%WaveField_m) 
   call RegPack(RF, InData%IC_gen)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MD_UnPackMisc(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(MD_MiscVarType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'MD_UnPackMisc'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%LineTypeList)) deallocate(OutData%LineTypeList)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%LineTypeList(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%LineTypeList.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MD_UnpackLineProp(RF, OutData%LineTypeList(i1)) ! LineTypeList 
      end do
   end if
   if (allocated(OutData%RodTypeList)) deallocate(OutData%RodTypeList)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%RodTypeList(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%RodTypeList.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MD_UnpackRodProp(RF, OutData%RodTypeList(i1)) ! RodTypeList 
      end do
   end if
   call MD_UnpackBody(RF, OutData%GroundBody) ! GroundBody 
   if (allocated(OutData%BodyList)) deallocate(OutData%BodyList)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BodyList(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BodyList.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MD_UnpackBody(RF, OutData%BodyList(i1)) ! BodyList 
      end do
   end if
   if (allocated(OutData%RodList)) deallocate(OutData%RodList)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%RodList(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%RodList.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MD_UnpackRod(RF, OutData%RodList(i1)) ! RodList 
      end do
   end if
   if (allocated(OutData%PointList)) deallocate(OutData%PointList)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%PointList(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%PointList.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MD_UnpackPoint(RF, OutData%PointList(i1)) ! PointList 
      end do
   end if
   if (allocated(OutData%LineList)) deallocate(OutData%LineList)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%LineList(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%LineList.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MD_UnpackLine(RF, OutData%LineList(i1)) ! LineList 
      end do
   end if
   if (allocated(OutData%ExtLdList)) deallocate(OutData%ExtLdList)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%ExtLdList(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%ExtLdList.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MD_UnpackExtLd(RF, OutData%ExtLdList(i1)) ! ExtLdList 
      end do
   end if
   if (allocated(OutData%FailList)) deallocate(OutData%FailList)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%FailList(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%FailList.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MD_UnpackFail(RF, OutData%FailList(i1)) ! FailList 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%FreePointIs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%CpldPointIs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%FreeRodIs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%CpldRodIs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%FreeBodyIs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%CpldBodyIs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LineStateIs1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LineStateIsN); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PointStateIs1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PointStateIsN); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RodStateIs1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RodStateIsN); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BodyStateIs1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BodyStateIsN); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Nx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Nxtra); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WaveTi); if (RegCheckErr(RF, RoutineName)) return
   call MD_UnpackContState(RF, OutData%xTemp) ! xTemp 
   call MD_UnpackContState(RF, OutData%xdTemp) ! xdTemp 
   call MD_UnpackContState(RF, OutData%kSum) ! kSum 
   call RegUnpack(RF, OutData%zeros6); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%MDWrOutput); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LastOutTime); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmInit); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BathymetryGrid); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BathGrid_Xs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BathGrid_Ys); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BathGrid_npoints); if (RegCheckErr(RF, RoutineName)) return
   call SeaSt_WaveField_UnpackMisc(RF, OutData%WaveField_m) ! WaveField_m 
   call RegUnpack(RF, OutData%IC_gen); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MD_CopyParam(SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg)
   type(MD_ParameterType), intent(in) :: SrcParamData
   type(MD_ParameterType), intent(inout) :: DstParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2, i3, i4
   integer(B4Ki)                  :: LB(4), UB(4)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'MD_CopyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstParamData%nLineTypes = SrcParamData%nLineTypes
   DstParamData%nRodTypes = SrcParamData%nRodTypes
   DstParamData%nPoints = SrcParamData%nPoints
   DstParamData%nPointsExtra = SrcParamData%nPointsExtra
   DstParamData%nBodies = SrcParamData%nBodies
   DstParamData%nRods = SrcParamData%nRods
   DstParamData%nLines = SrcParamData%nLines
   DstParamData%nExtLds = SrcParamData%nExtLds
   DstParamData%nCtrlChans = SrcParamData%nCtrlChans
   DstParamData%nFails = SrcParamData%nFails
   DstParamData%nFreeBodies = SrcParamData%nFreeBodies
   DstParamData%nFreeRods = SrcParamData%nFreeRods
   DstParamData%nFreePoints = SrcParamData%nFreePoints
   if (allocated(SrcParamData%nCpldBodies)) then
      LB(1:1) = lbound(SrcParamData%nCpldBodies)
      UB(1:1) = ubound(SrcParamData%nCpldBodies)
      if (.not. allocated(DstParamData%nCpldBodies)) then
         allocate(DstParamData%nCpldBodies(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%nCpldBodies.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%nCpldBodies = SrcParamData%nCpldBodies
   end if
   if (allocated(SrcParamData%nCpldRods)) then
      LB(1:1) = lbound(SrcParamData%nCpldRods)
      UB(1:1) = ubound(SrcParamData%nCpldRods)
      if (.not. allocated(DstParamData%nCpldRods)) then
         allocate(DstParamData%nCpldRods(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%nCpldRods.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%nCpldRods = SrcParamData%nCpldRods
   end if
   if (allocated(SrcParamData%nCpldPoints)) then
      LB(1:1) = lbound(SrcParamData%nCpldPoints)
      UB(1:1) = ubound(SrcParamData%nCpldPoints)
      if (.not. allocated(DstParamData%nCpldPoints)) then
         allocate(DstParamData%nCpldPoints(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%nCpldPoints.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%nCpldPoints = SrcParamData%nCpldPoints
   end if
   DstParamData%NConns = SrcParamData%NConns
   DstParamData%NAnchs = SrcParamData%NAnchs
   DstParamData%Tmax = SrcParamData%Tmax
   DstParamData%tScheme = SrcParamData%tScheme
   DstParamData%g = SrcParamData%g
   DstParamData%rhoW = SrcParamData%rhoW
   DstParamData%WtrDpth = SrcParamData%WtrDpth
   DstParamData%kBot = SrcParamData%kBot
   DstParamData%cBot = SrcParamData%cBot
   DstParamData%dtM0 = SrcParamData%dtM0
   DstParamData%dtCoupling = SrcParamData%dtCoupling
   DstParamData%NumOuts = SrcParamData%NumOuts
   DstParamData%dtOut = SrcParamData%dtOut
   DstParamData%RootName = SrcParamData%RootName
   if (allocated(SrcParamData%OutParam)) then
      LB(1:1) = lbound(SrcParamData%OutParam)
      UB(1:1) = ubound(SrcParamData%OutParam)
      if (.not. allocated(DstParamData%OutParam)) then
         allocate(DstParamData%OutParam(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%OutParam.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MD_CopyOutParmType(SrcParamData%OutParam(i1), DstParamData%OutParam(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstParamData%Delim = SrcParamData%Delim
   DstParamData%MDUnOut = SrcParamData%MDUnOut
   DstParamData%PriPath = SrcParamData%PriPath
   DstParamData%writeLog = SrcParamData%writeLog
   DstParamData%UnLog = SrcParamData%UnLog
   DstParamData%WaveKin = SrcParamData%WaveKin
   DstParamData%Current = SrcParamData%Current
   DstParamData%WaterKin = SrcParamData%WaterKin
   DstParamData%WaveField => SrcParamData%WaveField
   DstParamData%nTurbines = SrcParamData%nTurbines
   if (allocated(SrcParamData%TurbineRefPos)) then
      LB(1:2) = lbound(SrcParamData%TurbineRefPos)
      UB(1:2) = ubound(SrcParamData%TurbineRefPos)
      if (.not. allocated(DstParamData%TurbineRefPos)) then
         allocate(DstParamData%TurbineRefPos(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%TurbineRefPos.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%TurbineRefPos = SrcParamData%TurbineRefPos
   end if
   DstParamData%mu_kT = SrcParamData%mu_kT
   DstParamData%mu_kA = SrcParamData%mu_kA
   DstParamData%mc = SrcParamData%mc
   DstParamData%cv = SrcParamData%cv
   DstParamData%inertialF = SrcParamData%inertialF
   DstParamData%inertialF_rampT = SrcParamData%inertialF_rampT
   DstParamData%OutSwitch = SrcParamData%OutSwitch
   DstParamData%disableOutTime = SrcParamData%disableOutTime
   DstParamData%nxWave = SrcParamData%nxWave
   DstParamData%nyWave = SrcParamData%nyWave
   DstParamData%nzWave = SrcParamData%nzWave
   DstParamData%ntWave = SrcParamData%ntWave
   if (allocated(SrcParamData%pxWave)) then
      LB(1:1) = lbound(SrcParamData%pxWave)
      UB(1:1) = ubound(SrcParamData%pxWave)
      if (.not. allocated(DstParamData%pxWave)) then
         allocate(DstParamData%pxWave(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%pxWave.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%pxWave = SrcParamData%pxWave
   end if
   if (allocated(SrcParamData%pyWave)) then
      LB(1:1) = lbound(SrcParamData%pyWave)
      UB(1:1) = ubound(SrcParamData%pyWave)
      if (.not. allocated(DstParamData%pyWave)) then
         allocate(DstParamData%pyWave(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%pyWave.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%pyWave = SrcParamData%pyWave
   end if
   if (allocated(SrcParamData%pzWave)) then
      LB(1:1) = lbound(SrcParamData%pzWave)
      UB(1:1) = ubound(SrcParamData%pzWave)
      if (.not. allocated(DstParamData%pzWave)) then
         allocate(DstParamData%pzWave(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%pzWave.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%pzWave = SrcParamData%pzWave
   end if
   DstParamData%dtWave = SrcParamData%dtWave
   if (allocated(SrcParamData%uxWave)) then
      LB(1:4) = lbound(SrcParamData%uxWave)
      UB(1:4) = ubound(SrcParamData%uxWave)
      if (.not. allocated(DstParamData%uxWave)) then
         allocate(DstParamData%uxWave(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%uxWave.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%uxWave = SrcParamData%uxWave
   end if
   if (allocated(SrcParamData%uyWave)) then
      LB(1:4) = lbound(SrcParamData%uyWave)
      UB(1:4) = ubound(SrcParamData%uyWave)
      if (.not. allocated(DstParamData%uyWave)) then
         allocate(DstParamData%uyWave(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%uyWave.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%uyWave = SrcParamData%uyWave
   end if
   if (allocated(SrcParamData%uzWave)) then
      LB(1:4) = lbound(SrcParamData%uzWave)
      UB(1:4) = ubound(SrcParamData%uzWave)
      if (.not. allocated(DstParamData%uzWave)) then
         allocate(DstParamData%uzWave(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%uzWave.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%uzWave = SrcParamData%uzWave
   end if
   if (allocated(SrcParamData%axWave)) then
      LB(1:4) = lbound(SrcParamData%axWave)
      UB(1:4) = ubound(SrcParamData%axWave)
      if (.not. allocated(DstParamData%axWave)) then
         allocate(DstParamData%axWave(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%axWave.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%axWave = SrcParamData%axWave
   end if
   if (allocated(SrcParamData%ayWave)) then
      LB(1:4) = lbound(SrcParamData%ayWave)
      UB(1:4) = ubound(SrcParamData%ayWave)
      if (.not. allocated(DstParamData%ayWave)) then
         allocate(DstParamData%ayWave(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%ayWave.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%ayWave = SrcParamData%ayWave
   end if
   if (allocated(SrcParamData%azWave)) then
      LB(1:4) = lbound(SrcParamData%azWave)
      UB(1:4) = ubound(SrcParamData%azWave)
      if (.not. allocated(DstParamData%azWave)) then
         allocate(DstParamData%azWave(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%azWave.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%azWave = SrcParamData%azWave
   end if
   if (allocated(SrcParamData%PDyn)) then
      LB(1:4) = lbound(SrcParamData%PDyn)
      UB(1:4) = ubound(SrcParamData%PDyn)
      if (.not. allocated(DstParamData%PDyn)) then
         allocate(DstParamData%PDyn(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%PDyn.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%PDyn = SrcParamData%PDyn
   end if
   if (allocated(SrcParamData%zeta)) then
      LB(1:3) = lbound(SrcParamData%zeta)
      UB(1:3) = ubound(SrcParamData%zeta)
      if (.not. allocated(DstParamData%zeta)) then
         allocate(DstParamData%zeta(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%zeta.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%zeta = SrcParamData%zeta
   end if
   DstParamData%nzCurrent = SrcParamData%nzCurrent
   if (allocated(SrcParamData%pzCurrent)) then
      LB(1:1) = lbound(SrcParamData%pzCurrent)
      UB(1:1) = ubound(SrcParamData%pzCurrent)
      if (.not. allocated(DstParamData%pzCurrent)) then
         allocate(DstParamData%pzCurrent(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%pzCurrent.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%pzCurrent = SrcParamData%pzCurrent
   end if
   if (allocated(SrcParamData%uxCurrent)) then
      LB(1:1) = lbound(SrcParamData%uxCurrent)
      UB(1:1) = ubound(SrcParamData%uxCurrent)
      if (.not. allocated(DstParamData%uxCurrent)) then
         allocate(DstParamData%uxCurrent(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%uxCurrent.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%uxCurrent = SrcParamData%uxCurrent
   end if
   if (allocated(SrcParamData%uyCurrent)) then
      LB(1:1) = lbound(SrcParamData%uyCurrent)
      UB(1:1) = ubound(SrcParamData%uyCurrent)
      if (.not. allocated(DstParamData%uyCurrent)) then
         allocate(DstParamData%uyCurrent(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%uyCurrent.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%uyCurrent = SrcParamData%uyCurrent
   end if
   DstParamData%Nx0 = SrcParamData%Nx0
   if (allocated(SrcParamData%Jac_u_indx)) then
      LB(1:2) = lbound(SrcParamData%Jac_u_indx)
      UB(1:2) = ubound(SrcParamData%Jac_u_indx)
      if (.not. allocated(DstParamData%Jac_u_indx)) then
         allocate(DstParamData%Jac_u_indx(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Jac_u_indx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Jac_u_indx = SrcParamData%Jac_u_indx
   end if
   if (allocated(SrcParamData%du)) then
      LB(1:1) = lbound(SrcParamData%du)
      UB(1:1) = ubound(SrcParamData%du)
      if (.not. allocated(DstParamData%du)) then
         allocate(DstParamData%du(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%du.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%du = SrcParamData%du
   end if
   if (allocated(SrcParamData%dx)) then
      LB(1:1) = lbound(SrcParamData%dx)
      UB(1:1) = ubound(SrcParamData%dx)
      if (.not. allocated(DstParamData%dx)) then
         allocate(DstParamData%dx(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%dx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%dx = SrcParamData%dx
   end if
   DstParamData%Jac_ny = SrcParamData%Jac_ny
   DstParamData%Jac_nx = SrcParamData%Jac_nx
   if (allocated(SrcParamData%dxIdx_map2_xStateIdx)) then
      LB(1:1) = lbound(SrcParamData%dxIdx_map2_xStateIdx)
      UB(1:1) = ubound(SrcParamData%dxIdx_map2_xStateIdx)
      if (.not. allocated(DstParamData%dxIdx_map2_xStateIdx)) then
         allocate(DstParamData%dxIdx_map2_xStateIdx(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%dxIdx_map2_xStateIdx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%dxIdx_map2_xStateIdx = SrcParamData%dxIdx_map2_xStateIdx
   end if
   DstParamData%VisMeshes = SrcParamData%VisMeshes
   if (allocated(SrcParamData%VisRodsDiam)) then
      LB(1:1) = lbound(SrcParamData%VisRodsDiam)
      UB(1:1) = ubound(SrcParamData%VisRodsDiam)
      if (.not. allocated(DstParamData%VisRodsDiam)) then
         allocate(DstParamData%VisRodsDiam(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%VisRodsDiam.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MD_CopyVisDiam(SrcParamData%VisRodsDiam(i1), DstParamData%VisRodsDiam(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
end subroutine

subroutine MD_DestroyParam(ParamData, ErrStat, ErrMsg)
   type(MD_ParameterType), intent(inout) :: ParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2, i3, i4
   integer(B4Ki)   :: LB(4), UB(4)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'MD_DestroyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ParamData%nCpldBodies)) then
      deallocate(ParamData%nCpldBodies)
   end if
   if (allocated(ParamData%nCpldRods)) then
      deallocate(ParamData%nCpldRods)
   end if
   if (allocated(ParamData%nCpldPoints)) then
      deallocate(ParamData%nCpldPoints)
   end if
   if (allocated(ParamData%OutParam)) then
      LB(1:1) = lbound(ParamData%OutParam)
      UB(1:1) = ubound(ParamData%OutParam)
      do i1 = LB(1), UB(1)
         call MD_DestroyOutParmType(ParamData%OutParam(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%OutParam)
   end if
   nullify(ParamData%WaveField)
   if (allocated(ParamData%TurbineRefPos)) then
      deallocate(ParamData%TurbineRefPos)
   end if
   if (allocated(ParamData%pxWave)) then
      deallocate(ParamData%pxWave)
   end if
   if (allocated(ParamData%pyWave)) then
      deallocate(ParamData%pyWave)
   end if
   if (allocated(ParamData%pzWave)) then
      deallocate(ParamData%pzWave)
   end if
   if (allocated(ParamData%uxWave)) then
      deallocate(ParamData%uxWave)
   end if
   if (allocated(ParamData%uyWave)) then
      deallocate(ParamData%uyWave)
   end if
   if (allocated(ParamData%uzWave)) then
      deallocate(ParamData%uzWave)
   end if
   if (allocated(ParamData%axWave)) then
      deallocate(ParamData%axWave)
   end if
   if (allocated(ParamData%ayWave)) then
      deallocate(ParamData%ayWave)
   end if
   if (allocated(ParamData%azWave)) then
      deallocate(ParamData%azWave)
   end if
   if (allocated(ParamData%PDyn)) then
      deallocate(ParamData%PDyn)
   end if
   if (allocated(ParamData%zeta)) then
      deallocate(ParamData%zeta)
   end if
   if (allocated(ParamData%pzCurrent)) then
      deallocate(ParamData%pzCurrent)
   end if
   if (allocated(ParamData%uxCurrent)) then
      deallocate(ParamData%uxCurrent)
   end if
   if (allocated(ParamData%uyCurrent)) then
      deallocate(ParamData%uyCurrent)
   end if
   if (allocated(ParamData%Jac_u_indx)) then
      deallocate(ParamData%Jac_u_indx)
   end if
   if (allocated(ParamData%du)) then
      deallocate(ParamData%du)
   end if
   if (allocated(ParamData%dx)) then
      deallocate(ParamData%dx)
   end if
   if (allocated(ParamData%dxIdx_map2_xStateIdx)) then
      deallocate(ParamData%dxIdx_map2_xStateIdx)
   end if
   if (allocated(ParamData%VisRodsDiam)) then
      LB(1:1) = lbound(ParamData%VisRodsDiam)
      UB(1:1) = ubound(ParamData%VisRodsDiam)
      do i1 = LB(1), UB(1)
         call MD_DestroyVisDiam(ParamData%VisRodsDiam(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%VisRodsDiam)
   end if
end subroutine

subroutine MD_PackParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(MD_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'MD_PackParam'
   integer(B4Ki)   :: i1, i2, i3, i4
   integer(B4Ki)   :: LB(4), UB(4)
   logical         :: PtrInIndex
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%nLineTypes)
   call RegPack(RF, InData%nRodTypes)
   call RegPack(RF, InData%nPoints)
   call RegPack(RF, InData%nPointsExtra)
   call RegPack(RF, InData%nBodies)
   call RegPack(RF, InData%nRods)
   call RegPack(RF, InData%nLines)
   call RegPack(RF, InData%nExtLds)
   call RegPack(RF, InData%nCtrlChans)
   call RegPack(RF, InData%nFails)
   call RegPack(RF, InData%nFreeBodies)
   call RegPack(RF, InData%nFreeRods)
   call RegPack(RF, InData%nFreePoints)
   call RegPackAlloc(RF, InData%nCpldBodies)
   call RegPackAlloc(RF, InData%nCpldRods)
   call RegPackAlloc(RF, InData%nCpldPoints)
   call RegPack(RF, InData%NConns)
   call RegPack(RF, InData%NAnchs)
   call RegPack(RF, InData%Tmax)
   call RegPack(RF, InData%tScheme)
   call RegPack(RF, InData%g)
   call RegPack(RF, InData%rhoW)
   call RegPack(RF, InData%WtrDpth)
   call RegPack(RF, InData%kBot)
   call RegPack(RF, InData%cBot)
   call RegPack(RF, InData%dtM0)
   call RegPack(RF, InData%dtCoupling)
   call RegPack(RF, InData%NumOuts)
   call RegPack(RF, InData%dtOut)
   call RegPack(RF, InData%RootName)
   call RegPack(RF, allocated(InData%OutParam))
   if (allocated(InData%OutParam)) then
      call RegPackBounds(RF, 1, lbound(InData%OutParam), ubound(InData%OutParam))
      LB(1:1) = lbound(InData%OutParam)
      UB(1:1) = ubound(InData%OutParam)
      do i1 = LB(1), UB(1)
         call MD_PackOutParmType(RF, InData%OutParam(i1)) 
      end do
   end if
   call RegPack(RF, InData%Delim)
   call RegPack(RF, InData%MDUnOut)
   call RegPack(RF, InData%PriPath)
   call RegPack(RF, InData%writeLog)
   call RegPack(RF, InData%UnLog)
   call RegPack(RF, InData%WaveKin)
   call RegPack(RF, InData%Current)
   call RegPack(RF, InData%WaterKin)
   call RegPack(RF, associated(InData%WaveField))
   if (associated(InData%WaveField)) then
      call RegPackPointer(RF, c_loc(InData%WaveField), PtrInIndex)
      if (.not. PtrInIndex) then
         call SeaSt_WaveField_PackSeaSt_WaveFieldType(RF, InData%WaveField) 
      end if
   end if
   call RegPack(RF, InData%nTurbines)
   call RegPackAlloc(RF, InData%TurbineRefPos)
   call RegPack(RF, InData%mu_kT)
   call RegPack(RF, InData%mu_kA)
   call RegPack(RF, InData%mc)
   call RegPack(RF, InData%cv)
   call RegPack(RF, InData%inertialF)
   call RegPack(RF, InData%inertialF_rampT)
   call RegPack(RF, InData%OutSwitch)
   call RegPack(RF, InData%disableOutTime)
   call RegPack(RF, InData%nxWave)
   call RegPack(RF, InData%nyWave)
   call RegPack(RF, InData%nzWave)
   call RegPack(RF, InData%ntWave)
   call RegPackAlloc(RF, InData%pxWave)
   call RegPackAlloc(RF, InData%pyWave)
   call RegPackAlloc(RF, InData%pzWave)
   call RegPack(RF, InData%dtWave)
   call RegPackAlloc(RF, InData%uxWave)
   call RegPackAlloc(RF, InData%uyWave)
   call RegPackAlloc(RF, InData%uzWave)
   call RegPackAlloc(RF, InData%axWave)
   call RegPackAlloc(RF, InData%ayWave)
   call RegPackAlloc(RF, InData%azWave)
   call RegPackAlloc(RF, InData%PDyn)
   call RegPackAlloc(RF, InData%zeta)
   call RegPack(RF, InData%nzCurrent)
   call RegPackAlloc(RF, InData%pzCurrent)
   call RegPackAlloc(RF, InData%uxCurrent)
   call RegPackAlloc(RF, InData%uyCurrent)
   call RegPack(RF, InData%Nx0)
   call RegPackAlloc(RF, InData%Jac_u_indx)
   call RegPackAlloc(RF, InData%du)
   call RegPackAlloc(RF, InData%dx)
   call RegPack(RF, InData%Jac_ny)
   call RegPack(RF, InData%Jac_nx)
   call RegPackAlloc(RF, InData%dxIdx_map2_xStateIdx)
   call RegPack(RF, InData%VisMeshes)
   call RegPack(RF, allocated(InData%VisRodsDiam))
   if (allocated(InData%VisRodsDiam)) then
      call RegPackBounds(RF, 1, lbound(InData%VisRodsDiam), ubound(InData%VisRodsDiam))
      LB(1:1) = lbound(InData%VisRodsDiam)
      UB(1:1) = ubound(InData%VisRodsDiam)
      do i1 = LB(1), UB(1)
         call MD_PackVisDiam(RF, InData%VisRodsDiam(i1)) 
      end do
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MD_UnPackParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(MD_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'MD_UnPackParam'
   integer(B4Ki)   :: i1, i2, i3, i4
   integer(B4Ki)   :: LB(4), UB(4)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   integer(B8Ki)   :: PtrIdx
   type(c_ptr)     :: Ptr
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%nLineTypes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nRodTypes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nPoints); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nPointsExtra); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nBodies); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nRods); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nLines); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nExtLds); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nCtrlChans); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nFails); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nFreeBodies); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nFreeRods); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nFreePoints); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%nCpldBodies); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%nCpldRods); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%nCpldPoints); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NConns); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NAnchs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Tmax); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%tScheme); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%g); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rhoW); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WtrDpth); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%kBot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%cBot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dtM0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dtCoupling); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dtOut); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootName); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%OutParam)) deallocate(OutData%OutParam)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%OutParam(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%OutParam.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MD_UnpackOutParmType(RF, OutData%OutParam(i1)) ! OutParam 
      end do
   end if
   call RegUnpack(RF, OutData%Delim); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MDUnOut); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PriPath); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%writeLog); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UnLog); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WaveKin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Current); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WaterKin); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%WaveField)) deallocate(OutData%WaveField)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackPointer(RF, Ptr, PtrIdx); if (RegCheckErr(RF, RoutineName)) return
      if (c_associated(Ptr)) then
         call c_f_pointer(Ptr, OutData%WaveField)
      else
         allocate(OutData%WaveField,stat=stat)
         if (stat /= 0) then 
            call SetErrStat(ErrID_Fatal, 'Error allocating OutData%WaveField.', RF%ErrStat, RF%ErrMsg, RoutineName)
            return
         end if
         RF%Pointers(PtrIdx) = c_loc(OutData%WaveField)
         call SeaSt_WaveField_UnpackSeaSt_WaveFieldType(RF, OutData%WaveField) ! WaveField 
      end if
   else
      OutData%WaveField => null()
   end if
   call RegUnpack(RF, OutData%nTurbines); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TurbineRefPos); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%mu_kT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%mu_kA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%mc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%cv); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%inertialF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%inertialF_rampT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutSwitch); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%disableOutTime); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nxWave); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nyWave); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nzWave); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ntWave); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%pxWave); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%pyWave); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%pzWave); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dtWave); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%uxWave); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%uyWave); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%uzWave); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%axWave); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%ayWave); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%azWave); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PDyn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%zeta); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nzCurrent); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%pzCurrent); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%uxCurrent); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%uyCurrent); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Nx0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Jac_u_indx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%du); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%dx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Jac_ny); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Jac_nx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%dxIdx_map2_xStateIdx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VisMeshes); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%VisRodsDiam)) deallocate(OutData%VisRodsDiam)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%VisRodsDiam(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%VisRodsDiam.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MD_UnpackVisDiam(RF, OutData%VisRodsDiam(i1)) ! VisRodsDiam 
      end do
   end if
end subroutine

subroutine MD_CopyInput(SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg)
   type(MD_InputType), intent(inout) :: SrcInputData
   type(MD_InputType), intent(inout) :: DstInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'MD_CopyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcInputData%CoupledKinematics)) then
      LB(1:1) = lbound(SrcInputData%CoupledKinematics)
      UB(1:1) = ubound(SrcInputData%CoupledKinematics)
      if (.not. allocated(DstInputData%CoupledKinematics)) then
         allocate(DstInputData%CoupledKinematics(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%CoupledKinematics.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcInputData%CoupledKinematics(i1), DstInputData%CoupledKinematics(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcInputData%DeltaL)) then
      LB(1:1) = lbound(SrcInputData%DeltaL)
      UB(1:1) = ubound(SrcInputData%DeltaL)
      if (.not. allocated(DstInputData%DeltaL)) then
         allocate(DstInputData%DeltaL(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%DeltaL.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%DeltaL = SrcInputData%DeltaL
   end if
   if (allocated(SrcInputData%DeltaLdot)) then
      LB(1:1) = lbound(SrcInputData%DeltaLdot)
      UB(1:1) = ubound(SrcInputData%DeltaLdot)
      if (.not. allocated(DstInputData%DeltaLdot)) then
         allocate(DstInputData%DeltaLdot(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%DeltaLdot.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%DeltaLdot = SrcInputData%DeltaLdot
   end if
end subroutine

subroutine MD_DestroyInput(InputData, ErrStat, ErrMsg)
   type(MD_InputType), intent(inout) :: InputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'MD_DestroyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InputData%CoupledKinematics)) then
      LB(1:1) = lbound(InputData%CoupledKinematics)
      UB(1:1) = ubound(InputData%CoupledKinematics)
      do i1 = LB(1), UB(1)
         call MeshDestroy( InputData%CoupledKinematics(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InputData%CoupledKinematics)
   end if
   if (allocated(InputData%DeltaL)) then
      deallocate(InputData%DeltaL)
   end if
   if (allocated(InputData%DeltaLdot)) then
      deallocate(InputData%DeltaLdot)
   end if
end subroutine

subroutine MD_PackInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(MD_InputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'MD_PackInput'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%CoupledKinematics))
   if (allocated(InData%CoupledKinematics)) then
      call RegPackBounds(RF, 1, lbound(InData%CoupledKinematics), ubound(InData%CoupledKinematics))
      LB(1:1) = lbound(InData%CoupledKinematics)
      UB(1:1) = ubound(InData%CoupledKinematics)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%CoupledKinematics(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%DeltaL)
   call RegPackAlloc(RF, InData%DeltaLdot)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MD_UnPackInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(MD_InputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'MD_UnPackInput'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%CoupledKinematics)) deallocate(OutData%CoupledKinematics)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%CoupledKinematics(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%CoupledKinematics.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%CoupledKinematics(i1)) ! CoupledKinematics 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%DeltaL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%DeltaLdot); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MD_CopyOutput(SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg)
   type(MD_OutputType), intent(inout) :: SrcOutputData
   type(MD_OutputType), intent(inout) :: DstOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'MD_CopyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcOutputData%CoupledLoads)) then
      LB(1:1) = lbound(SrcOutputData%CoupledLoads)
      UB(1:1) = ubound(SrcOutputData%CoupledLoads)
      if (.not. allocated(DstOutputData%CoupledLoads)) then
         allocate(DstOutputData%CoupledLoads(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%CoupledLoads.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcOutputData%CoupledLoads(i1), DstOutputData%CoupledLoads(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcOutputData%WriteOutput)) then
      LB(1:1) = lbound(SrcOutputData%WriteOutput)
      UB(1:1) = ubound(SrcOutputData%WriteOutput)
      if (.not. allocated(DstOutputData%WriteOutput)) then
         allocate(DstOutputData%WriteOutput(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%WriteOutput.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%WriteOutput = SrcOutputData%WriteOutput
   end if
   if (allocated(SrcOutputData%VisLinesMesh)) then
      LB(1:1) = lbound(SrcOutputData%VisLinesMesh)
      UB(1:1) = ubound(SrcOutputData%VisLinesMesh)
      if (.not. allocated(DstOutputData%VisLinesMesh)) then
         allocate(DstOutputData%VisLinesMesh(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%VisLinesMesh.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcOutputData%VisLinesMesh(i1), DstOutputData%VisLinesMesh(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcOutputData%VisRodsMesh)) then
      LB(1:1) = lbound(SrcOutputData%VisRodsMesh)
      UB(1:1) = ubound(SrcOutputData%VisRodsMesh)
      if (.not. allocated(DstOutputData%VisRodsMesh)) then
         allocate(DstOutputData%VisRodsMesh(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%VisRodsMesh.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcOutputData%VisRodsMesh(i1), DstOutputData%VisRodsMesh(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcOutputData%VisBodiesMesh)) then
      LB(1:1) = lbound(SrcOutputData%VisBodiesMesh)
      UB(1:1) = ubound(SrcOutputData%VisBodiesMesh)
      if (.not. allocated(DstOutputData%VisBodiesMesh)) then
         allocate(DstOutputData%VisBodiesMesh(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%VisBodiesMesh.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcOutputData%VisBodiesMesh(i1), DstOutputData%VisBodiesMesh(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcOutputData%VisAnchsMesh)) then
      LB(1:1) = lbound(SrcOutputData%VisAnchsMesh)
      UB(1:1) = ubound(SrcOutputData%VisAnchsMesh)
      if (.not. allocated(DstOutputData%VisAnchsMesh)) then
         allocate(DstOutputData%VisAnchsMesh(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%VisAnchsMesh.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcOutputData%VisAnchsMesh(i1), DstOutputData%VisAnchsMesh(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
end subroutine

subroutine MD_DestroyOutput(OutputData, ErrStat, ErrMsg)
   type(MD_OutputType), intent(inout) :: OutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'MD_DestroyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(OutputData%CoupledLoads)) then
      LB(1:1) = lbound(OutputData%CoupledLoads)
      UB(1:1) = ubound(OutputData%CoupledLoads)
      do i1 = LB(1), UB(1)
         call MeshDestroy( OutputData%CoupledLoads(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(OutputData%CoupledLoads)
   end if
   if (allocated(OutputData%WriteOutput)) then
      deallocate(OutputData%WriteOutput)
   end if
   if (allocated(OutputData%VisLinesMesh)) then
      LB(1:1) = lbound(OutputData%VisLinesMesh)
      UB(1:1) = ubound(OutputData%VisLinesMesh)
      do i1 = LB(1), UB(1)
         call MeshDestroy( OutputData%VisLinesMesh(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(OutputData%VisLinesMesh)
   end if
   if (allocated(OutputData%VisRodsMesh)) then
      LB(1:1) = lbound(OutputData%VisRodsMesh)
      UB(1:1) = ubound(OutputData%VisRodsMesh)
      do i1 = LB(1), UB(1)
         call MeshDestroy( OutputData%VisRodsMesh(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(OutputData%VisRodsMesh)
   end if
   if (allocated(OutputData%VisBodiesMesh)) then
      LB(1:1) = lbound(OutputData%VisBodiesMesh)
      UB(1:1) = ubound(OutputData%VisBodiesMesh)
      do i1 = LB(1), UB(1)
         call MeshDestroy( OutputData%VisBodiesMesh(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(OutputData%VisBodiesMesh)
   end if
   if (allocated(OutputData%VisAnchsMesh)) then
      LB(1:1) = lbound(OutputData%VisAnchsMesh)
      UB(1:1) = ubound(OutputData%VisAnchsMesh)
      do i1 = LB(1), UB(1)
         call MeshDestroy( OutputData%VisAnchsMesh(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(OutputData%VisAnchsMesh)
   end if
end subroutine

subroutine MD_PackOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(MD_OutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'MD_PackOutput'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%CoupledLoads))
   if (allocated(InData%CoupledLoads)) then
      call RegPackBounds(RF, 1, lbound(InData%CoupledLoads), ubound(InData%CoupledLoads))
      LB(1:1) = lbound(InData%CoupledLoads)
      UB(1:1) = ubound(InData%CoupledLoads)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%CoupledLoads(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%WriteOutput)
   call RegPack(RF, allocated(InData%VisLinesMesh))
   if (allocated(InData%VisLinesMesh)) then
      call RegPackBounds(RF, 1, lbound(InData%VisLinesMesh), ubound(InData%VisLinesMesh))
      LB(1:1) = lbound(InData%VisLinesMesh)
      UB(1:1) = ubound(InData%VisLinesMesh)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%VisLinesMesh(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%VisRodsMesh))
   if (allocated(InData%VisRodsMesh)) then
      call RegPackBounds(RF, 1, lbound(InData%VisRodsMesh), ubound(InData%VisRodsMesh))
      LB(1:1) = lbound(InData%VisRodsMesh)
      UB(1:1) = ubound(InData%VisRodsMesh)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%VisRodsMesh(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%VisBodiesMesh))
   if (allocated(InData%VisBodiesMesh)) then
      call RegPackBounds(RF, 1, lbound(InData%VisBodiesMesh), ubound(InData%VisBodiesMesh))
      LB(1:1) = lbound(InData%VisBodiesMesh)
      UB(1:1) = ubound(InData%VisBodiesMesh)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%VisBodiesMesh(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%VisAnchsMesh))
   if (allocated(InData%VisAnchsMesh)) then
      call RegPackBounds(RF, 1, lbound(InData%VisAnchsMesh), ubound(InData%VisAnchsMesh))
      LB(1:1) = lbound(InData%VisAnchsMesh)
      UB(1:1) = ubound(InData%VisAnchsMesh)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%VisAnchsMesh(i1)) 
      end do
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MD_UnPackOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(MD_OutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'MD_UnPackOutput'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%CoupledLoads)) deallocate(OutData%CoupledLoads)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%CoupledLoads(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%CoupledLoads.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%CoupledLoads(i1)) ! CoupledLoads 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%WriteOutput); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%VisLinesMesh)) deallocate(OutData%VisLinesMesh)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%VisLinesMesh(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%VisLinesMesh.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%VisLinesMesh(i1)) ! VisLinesMesh 
      end do
   end if
   if (allocated(OutData%VisRodsMesh)) deallocate(OutData%VisRodsMesh)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%VisRodsMesh(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%VisRodsMesh.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%VisRodsMesh(i1)) ! VisRodsMesh 
      end do
   end if
   if (allocated(OutData%VisBodiesMesh)) deallocate(OutData%VisBodiesMesh)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%VisBodiesMesh(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%VisBodiesMesh.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%VisBodiesMesh(i1)) ! VisBodiesMesh 
      end do
   end if
   if (allocated(OutData%VisAnchsMesh)) deallocate(OutData%VisAnchsMesh)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%VisAnchsMesh(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%VisAnchsMesh.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%VisAnchsMesh(i1)) ! VisAnchsMesh 
      end do
   end if
end subroutine

subroutine MD_Input_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
   ! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(MD_InputType), intent(inout)  :: u(:) ! Input at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Inputs
   type(MD_InputType), intent(inout)  :: u_out ! Input at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'MD_Input_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(u)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(u)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(u) - 1
   select case (order)
   case (0)
      call MD_CopyInput(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call MD_Input_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call MD_Input_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(u) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE MD_Input_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

   TYPE(MD_InputType), INTENT(INOUT)  :: u1    ! Input at t1 > t2
   TYPE(MD_InputType), INTENT(INOUT)  :: u2    ! Input at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Inputs
   TYPE(MD_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'MD_Input_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   IF (ALLOCATED(u_out%CoupledKinematics) .AND. ALLOCATED(u1%CoupledKinematics)) THEN
      do i1 = lbound(u_out%CoupledKinematics,1),ubound(u_out%CoupledKinematics,1)
         CALL MeshExtrapInterp1(u1%CoupledKinematics(i1), u2%CoupledKinematics(i1), tin, u_out%CoupledKinematics(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(u_out%DeltaL) .AND. ALLOCATED(u1%DeltaL)) THEN
      u_out%DeltaL = a1*u1%DeltaL + a2*u2%DeltaL
   END IF ! check if allocated
   IF (ALLOCATED(u_out%DeltaLdot) .AND. ALLOCATED(u1%DeltaLdot)) THEN
      u_out%DeltaLdot = a1*u1%DeltaLdot + a2*u2%DeltaLdot
   END IF ! check if allocated
END SUBROUTINE

SUBROUTINE MD_Input_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

   TYPE(MD_InputType), INTENT(INOUT)  :: u1      ! Input at t1 > t2 > t3
   TYPE(MD_InputType), INTENT(INOUT)  :: u2      ! Input at t2 > t3
   TYPE(MD_InputType), INTENT(INOUT)  :: u3      ! Input at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Inputs
   TYPE(MD_InputType), INTENT(INOUT)  :: u_out     ! Input at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'MD_Input_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   IF (ALLOCATED(u_out%CoupledKinematics) .AND. ALLOCATED(u1%CoupledKinematics)) THEN
      do i1 = lbound(u_out%CoupledKinematics,1),ubound(u_out%CoupledKinematics,1)
         CALL MeshExtrapInterp2(u1%CoupledKinematics(i1), u2%CoupledKinematics(i1), u3%CoupledKinematics(i1), tin, u_out%CoupledKinematics(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(u_out%DeltaL) .AND. ALLOCATED(u1%DeltaL)) THEN
      u_out%DeltaL = a1*u1%DeltaL + a2*u2%DeltaL + a3*u3%DeltaL
   END IF ! check if allocated
   IF (ALLOCATED(u_out%DeltaLdot) .AND. ALLOCATED(u1%DeltaLdot)) THEN
      u_out%DeltaLdot = a1*u1%DeltaLdot + a2*u2%DeltaLdot + a3*u3%DeltaLdot
   END IF ! check if allocated
END SUBROUTINE

subroutine MD_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
   ! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(MD_OutputType), intent(inout)  :: y(:) ! Output at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Outputs
   type(MD_OutputType), intent(inout)  :: y_out ! Output at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'MD_Output_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(y)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(y)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(y) - 1
   select case (order)
   case (0)
      call MD_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call MD_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call MD_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(y) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE MD_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

   TYPE(MD_OutputType), INTENT(INOUT)  :: y1    ! Output at t1 > t2
   TYPE(MD_OutputType), INTENT(INOUT)  :: y2    ! Output at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
   TYPE(MD_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'MD_Output_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   IF (ALLOCATED(y_out%CoupledLoads) .AND. ALLOCATED(y1%CoupledLoads)) THEN
      do i1 = lbound(y_out%CoupledLoads,1),ubound(y_out%CoupledLoads,1)
         CALL MeshExtrapInterp1(y1%CoupledLoads(i1), y2%CoupledLoads(i1), tin, y_out%CoupledLoads(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
      y_out%WriteOutput = a1*y1%WriteOutput + a2*y2%WriteOutput
   END IF ! check if allocated
   IF (ALLOCATED(y_out%VisLinesMesh) .AND. ALLOCATED(y1%VisLinesMesh)) THEN
      do i1 = lbound(y_out%VisLinesMesh,1),ubound(y_out%VisLinesMesh,1)
         CALL MeshExtrapInterp1(y1%VisLinesMesh(i1), y2%VisLinesMesh(i1), tin, y_out%VisLinesMesh(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(y_out%VisRodsMesh) .AND. ALLOCATED(y1%VisRodsMesh)) THEN
      do i1 = lbound(y_out%VisRodsMesh,1),ubound(y_out%VisRodsMesh,1)
         CALL MeshExtrapInterp1(y1%VisRodsMesh(i1), y2%VisRodsMesh(i1), tin, y_out%VisRodsMesh(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(y_out%VisBodiesMesh) .AND. ALLOCATED(y1%VisBodiesMesh)) THEN
      do i1 = lbound(y_out%VisBodiesMesh,1),ubound(y_out%VisBodiesMesh,1)
         CALL MeshExtrapInterp1(y1%VisBodiesMesh(i1), y2%VisBodiesMesh(i1), tin, y_out%VisBodiesMesh(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(y_out%VisAnchsMesh) .AND. ALLOCATED(y1%VisAnchsMesh)) THEN
      do i1 = lbound(y_out%VisAnchsMesh,1),ubound(y_out%VisAnchsMesh,1)
         CALL MeshExtrapInterp1(y1%VisAnchsMesh(i1), y2%VisAnchsMesh(i1), tin, y_out%VisAnchsMesh(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
END SUBROUTINE

SUBROUTINE MD_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

   TYPE(MD_OutputType), INTENT(INOUT)  :: y1      ! Output at t1 > t2 > t3
   TYPE(MD_OutputType), INTENT(INOUT)  :: y2      ! Output at t2 > t3
   TYPE(MD_OutputType), INTENT(INOUT)  :: y3      ! Output at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
   TYPE(MD_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'MD_Output_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   IF (ALLOCATED(y_out%CoupledLoads) .AND. ALLOCATED(y1%CoupledLoads)) THEN
      do i1 = lbound(y_out%CoupledLoads,1),ubound(y_out%CoupledLoads,1)
         CALL MeshExtrapInterp2(y1%CoupledLoads(i1), y2%CoupledLoads(i1), y3%CoupledLoads(i1), tin, y_out%CoupledLoads(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
      y_out%WriteOutput = a1*y1%WriteOutput + a2*y2%WriteOutput + a3*y3%WriteOutput
   END IF ! check if allocated
   IF (ALLOCATED(y_out%VisLinesMesh) .AND. ALLOCATED(y1%VisLinesMesh)) THEN
      do i1 = lbound(y_out%VisLinesMesh,1),ubound(y_out%VisLinesMesh,1)
         CALL MeshExtrapInterp2(y1%VisLinesMesh(i1), y2%VisLinesMesh(i1), y3%VisLinesMesh(i1), tin, y_out%VisLinesMesh(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(y_out%VisRodsMesh) .AND. ALLOCATED(y1%VisRodsMesh)) THEN
      do i1 = lbound(y_out%VisRodsMesh,1),ubound(y_out%VisRodsMesh,1)
         CALL MeshExtrapInterp2(y1%VisRodsMesh(i1), y2%VisRodsMesh(i1), y3%VisRodsMesh(i1), tin, y_out%VisRodsMesh(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(y_out%VisBodiesMesh) .AND. ALLOCATED(y1%VisBodiesMesh)) THEN
      do i1 = lbound(y_out%VisBodiesMesh,1),ubound(y_out%VisBodiesMesh,1)
         CALL MeshExtrapInterp2(y1%VisBodiesMesh(i1), y2%VisBodiesMesh(i1), y3%VisBodiesMesh(i1), tin, y_out%VisBodiesMesh(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(y_out%VisAnchsMesh) .AND. ALLOCATED(y1%VisAnchsMesh)) THEN
      do i1 = lbound(y_out%VisAnchsMesh,1),ubound(y_out%VisAnchsMesh,1)
         CALL MeshExtrapInterp2(y1%VisAnchsMesh(i1), y2%VisAnchsMesh(i1), y3%VisAnchsMesh(i1), tin, y_out%VisAnchsMesh(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
END SUBROUTINE
END MODULE MoorDyn_Types
!ENDOFREGISTRYGENERATEDFILE
