!STARTOFREGISTRYGENERATEDFILE 'MAP_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! MAP_Types
!.................................................................................................................................
! This file is part of MAP.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in MAP. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE MAP_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE MAP_Fortran_Types
USE NWTC_Library
IMPLICIT NONE
! =========  MAP_InitInputType_C  =======
  TYPE, BIND(C) :: MAP_InitInputType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    REAL(KIND=C_DOUBLE) :: gravity 
    REAL(KIND=C_DOUBLE) :: sea_density 
    REAL(KIND=C_DOUBLE) :: depth 
    CHARACTER(KIND=C_CHAR), DIMENSION(255) :: file_name 
    CHARACTER(KIND=C_CHAR), DIMENSION(255) :: summary_file_name 
    CHARACTER(KIND=C_CHAR), DIMENSION(255) :: library_input_str 
    CHARACTER(KIND=C_CHAR), DIMENSION(255) :: node_input_str 
    CHARACTER(KIND=C_CHAR), DIMENSION(255) :: line_input_str 
    CHARACTER(KIND=C_CHAR), DIMENSION(255) :: option_input_str 
  END TYPE MAP_InitInputType_C
  TYPE, PUBLIC :: MAP_InitInputType
    TYPE( MAP_InitInputType_C ) :: C_obj
    REAL(R8Ki)  :: gravity = -999.9      !< gravity constant [[m/s^2]]
    REAL(R8Ki)  :: sea_density = -999.9      !< sea density [[kg/m^3]]
    REAL(R8Ki)  :: depth = -999.9      !< depth of water [[m]]
    CHARACTER(255)  :: file_name      !< MAP input file [-]
    CHARACTER(255)  :: summary_file_name      !< MAP summary file name [-]
    CHARACTER(255)  :: library_input_str      !< cable library string information (from input file) [-]
    CHARACTER(255)  :: node_input_str      !< node string information (from input file) [-]
    CHARACTER(255)  :: line_input_str      !< element library string information (from input file) [-]
    CHARACTER(255)  :: option_input_str      !< solver options library string information (from input file) [-]
    TYPE(Lin_InitInputType)  :: LinInitInp      !<   [-]
  END TYPE MAP_InitInputType
! =======================
! =========  MAP_InitOutputType_C  =======
  TYPE, BIND(C) :: MAP_InitOutputType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    CHARACTER(KIND=C_CHAR), DIMENSION(99) :: progName 
    CHARACTER(KIND=C_CHAR), DIMENSION(99) :: version 
    CHARACTER(KIND=C_CHAR), DIMENSION(24) :: compilingData 
    TYPE(C_ptr) :: writeOutputHdr = C_NULL_PTR 
    INTEGER(C_int) :: writeOutputHdr_Len = 0 
    TYPE(C_ptr) :: writeOutputUnt = C_NULL_PTR 
    INTEGER(C_int) :: writeOutputUnt_Len = 0 
  END TYPE MAP_InitOutputType_C
  TYPE, PUBLIC :: MAP_InitOutputType
    TYPE( MAP_InitOutputType_C ) :: C_obj
    CHARACTER(99)  :: progName      !< program name [-]
    CHARACTER(99)  :: version      !< version numnber [-]
    CHARACTER(24)  :: compilingData      !< compiling data [-]
    CHARACTER(15) , DIMENSION(:), ALLOCATABLE  :: writeOutputHdr      !< first line output file contents: output variable names [-]
    CHARACTER(15) , DIMENSION(:), ALLOCATABLE  :: writeOutputUnt      !< second line of output file contents: units [-]
    TYPE(ProgDesc)  :: Ver      !< this module's name, version, and date [-]
    TYPE(Lin_InitOutputType)  :: LinInitOut      !< Init Output linearization data (fortran-only) [-]
  END TYPE MAP_InitOutputType
! =======================
! =========  MAP_ContinuousStateType_C  =======
  TYPE, BIND(C) :: MAP_ContinuousStateType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    REAL(KIND=C_DOUBLE) :: dummy 
  END TYPE MAP_ContinuousStateType_C
  TYPE, PUBLIC :: MAP_ContinuousStateType
    TYPE( MAP_ContinuousStateType_C ) :: C_obj
    REAL(R8Ki)  :: dummy = 0.0_R8Ki      !< Remove this variable if you have continuous states [-]
  END TYPE MAP_ContinuousStateType
! =======================
! =========  MAP_DiscreteStateType_C  =======
  TYPE, BIND(C) :: MAP_DiscreteStateType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    REAL(KIND=C_DOUBLE) :: dummy 
  END TYPE MAP_DiscreteStateType_C
  TYPE, PUBLIC :: MAP_DiscreteStateType
    TYPE( MAP_DiscreteStateType_C ) :: C_obj
    REAL(R8Ki)  :: dummy = 0.0_R8Ki      !< Remove this variable if you have discrete states [-]
  END TYPE MAP_DiscreteStateType
! =======================
! =========  MAP_OtherStateType_C  =======
  TYPE, BIND(C) :: MAP_OtherStateType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    TYPE(C_ptr) :: H = C_NULL_PTR 
    INTEGER(C_int) :: H_Len = 0 
    TYPE(C_ptr) :: V = C_NULL_PTR 
    INTEGER(C_int) :: V_Len = 0 
    TYPE(C_ptr) :: Ha = C_NULL_PTR 
    INTEGER(C_int) :: Ha_Len = 0 
    TYPE(C_ptr) :: Va = C_NULL_PTR 
    INTEGER(C_int) :: Va_Len = 0 
    TYPE(C_ptr) :: x = C_NULL_PTR 
    INTEGER(C_int) :: x_Len = 0 
    TYPE(C_ptr) :: y = C_NULL_PTR 
    INTEGER(C_int) :: y_Len = 0 
    TYPE(C_ptr) :: z = C_NULL_PTR 
    INTEGER(C_int) :: z_Len = 0 
    TYPE(C_ptr) :: xa = C_NULL_PTR 
    INTEGER(C_int) :: xa_Len = 0 
    TYPE(C_ptr) :: ya = C_NULL_PTR 
    INTEGER(C_int) :: ya_Len = 0 
    TYPE(C_ptr) :: za = C_NULL_PTR 
    INTEGER(C_int) :: za_Len = 0 
    TYPE(C_ptr) :: Fx_connect = C_NULL_PTR 
    INTEGER(C_int) :: Fx_connect_Len = 0 
    TYPE(C_ptr) :: Fy_connect = C_NULL_PTR 
    INTEGER(C_int) :: Fy_connect_Len = 0 
    TYPE(C_ptr) :: Fz_connect = C_NULL_PTR 
    INTEGER(C_int) :: Fz_connect_Len = 0 
    TYPE(C_ptr) :: Fx_anchor = C_NULL_PTR 
    INTEGER(C_int) :: Fx_anchor_Len = 0 
    TYPE(C_ptr) :: Fy_anchor = C_NULL_PTR 
    INTEGER(C_int) :: Fy_anchor_Len = 0 
    TYPE(C_ptr) :: Fz_anchor = C_NULL_PTR 
    INTEGER(C_int) :: Fz_anchor_Len = 0 
  END TYPE MAP_OtherStateType_C
  TYPE, PUBLIC :: MAP_OtherStateType
    TYPE( MAP_OtherStateType_C ) :: C_obj
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: H => NULL()      !< horizontal line force [[N]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: V => NULL()      !< Vertical line force [[N]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: Ha => NULL()      !< horizontal line force at anchor [[N]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: Va => NULL()      !< Vertical line force at anchor [[N]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: x => NULL()      !< x fairlead line position [[m]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: y => NULL()      !< y fairlead line position [[m]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: z => NULL()      !< z fairlead line position [[m]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: xa => NULL()      !< x fairlead line position at anchor [[m]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: ya => NULL()      !< y fairlead line position at anchor [[m]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: za => NULL()      !< z fairlead line position at anchor [[m]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: Fx_connect => NULL()      !< horizontal x line force at connect node [[N]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: Fy_connect => NULL()      !< horizontal y line force at connect node [[N]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: Fz_connect => NULL()      !< vertical z line force at connect node [[N]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: Fx_anchor => NULL()      !< horizontal x line force at connect node [[N]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: Fy_anchor => NULL()      !< horizontal y line force at connect node [[N]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: Fz_anchor => NULL()      !< vertical z line force at connect node [[N]]
  END TYPE MAP_OtherStateType
! =======================
! =========  MAP_ConstraintStateType_C  =======
  TYPE, BIND(C) :: MAP_ConstraintStateType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    TYPE(C_ptr) :: H = C_NULL_PTR 
    INTEGER(C_int) :: H_Len = 0 
    TYPE(C_ptr) :: V = C_NULL_PTR 
    INTEGER(C_int) :: V_Len = 0 
    TYPE(C_ptr) :: x = C_NULL_PTR 
    INTEGER(C_int) :: x_Len = 0 
    TYPE(C_ptr) :: y = C_NULL_PTR 
    INTEGER(C_int) :: y_Len = 0 
    TYPE(C_ptr) :: z = C_NULL_PTR 
    INTEGER(C_int) :: z_Len = 0 
  END TYPE MAP_ConstraintStateType_C
  TYPE, PUBLIC :: MAP_ConstraintStateType
    TYPE( MAP_ConstraintStateType_C ) :: C_obj
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: H => NULL()      !< horizontal line force [[N]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: V => NULL()      !< Vertical line force [[N]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: x => NULL()      !< fairlead x displacement [[m]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: y => NULL()      !< fairlead y displacement [[m]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: z => NULL()      !< fairlead z displacement [[m]]
  END TYPE MAP_ConstraintStateType
! =======================
! =========  MAP_ParameterType_C  =======
  TYPE, BIND(C) :: MAP_ParameterType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    REAL(KIND=C_DOUBLE) :: g 
    REAL(KIND=C_DOUBLE) :: depth 
    REAL(KIND=C_DOUBLE) :: rho_sea 
    REAL(KIND=C_DOUBLE) :: dt 
    INTEGER(KIND=C_INT) :: numOuts 
  END TYPE MAP_ParameterType_C
  TYPE, PUBLIC :: MAP_ParameterType
    TYPE( MAP_ParameterType_C ) :: C_obj
    REAL(R8Ki)  :: g = 0.0_R8Ki      !< gravitational constant [[kg/m^2]]
    REAL(R8Ki)  :: depth = 0.0_R8Ki      !< distance to seabed [[m]]
    REAL(R8Ki)  :: rho_sea = 0.0_R8Ki      !< density of seawater [[m]]
    REAL(R8Ki)  :: dt = 0.0_R8Ki      !< time step coupling interval [[sec]]
    CHARACTER(255) , DIMENSION(1:500)  :: InputLines      !< input file line for restart [-]
    CHARACTER(1) , DIMENSION(1:500)  :: InputLineType      !< input file line type for restart [-]
    INTEGER(IntKi)  :: numOuts = 0      !< Number of write outputs [-]
    TYPE(Lin_ParamType)  :: LinParams      !< Parameter linearization data (fortran-only) [-]
  END TYPE MAP_ParameterType
! =======================
! =========  MAP_InputType_C  =======
  TYPE, BIND(C) :: MAP_InputType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    TYPE(C_ptr) :: x = C_NULL_PTR 
    INTEGER(C_int) :: x_Len = 0 
    TYPE(C_ptr) :: y = C_NULL_PTR 
    INTEGER(C_int) :: y_Len = 0 
    TYPE(C_ptr) :: z = C_NULL_PTR 
    INTEGER(C_int) :: z_Len = 0 
  END TYPE MAP_InputType_C
  TYPE, PUBLIC :: MAP_InputType
    TYPE( MAP_InputType_C ) :: C_obj
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: x => NULL()      !< fairlead x displacement [[m]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: y => NULL()      !< fairlead y displacement [[m]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: z => NULL()      !< fairlead z displacement [[m]]
    TYPE(MeshType)  :: PtFairDisplacement      !< position of each fairlead in X,Y,Z [[m]]
  END TYPE MAP_InputType
! =======================
! =========  MAP_OutputType_C  =======
  TYPE, BIND(C) :: MAP_OutputType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    TYPE(C_ptr) :: Fx = C_NULL_PTR 
    INTEGER(C_int) :: Fx_Len = 0 
    TYPE(C_ptr) :: Fy = C_NULL_PTR 
    INTEGER(C_int) :: Fy_Len = 0 
    TYPE(C_ptr) :: Fz = C_NULL_PTR 
    INTEGER(C_int) :: Fz_Len = 0 
    TYPE(C_ptr) :: WriteOutput = C_NULL_PTR 
    INTEGER(C_int) :: WriteOutput_Len = 0 
    TYPE(C_ptr) :: wrtOutput = C_NULL_PTR 
    INTEGER(C_int) :: wrtOutput_Len = 0 
  END TYPE MAP_OutputType_C
  TYPE, PUBLIC :: MAP_OutputType
    TYPE( MAP_OutputType_C ) :: C_obj
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: Fx => NULL()      !< horizontal line force [[N]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: Fy => NULL()      !< Vertical line force [[N]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: Fz => NULL()      !< horizontal line force at anchor [[N]]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WriteOutput      !< outpur vector []
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: wrtOutput => NULL()      !< outpur vector []
    TYPE(MeshType)  :: ptFairleadLoad      !< point mesh for forces in X,Y,Z [[N]]
  END TYPE MAP_OutputType
! =======================
CONTAINS

subroutine MAP_CopyInitInput(SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg)
   type(MAP_InitInputType), intent(in) :: SrcInitInputData
   type(MAP_InitInputType), intent(inout) :: DstInitInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'MAP_CopyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInitInputData%gravity = SrcInitInputData%gravity
   DstInitInputData%C_obj%gravity = SrcInitInputData%C_obj%gravity
   DstInitInputData%sea_density = SrcInitInputData%sea_density
   DstInitInputData%C_obj%sea_density = SrcInitInputData%C_obj%sea_density
   DstInitInputData%depth = SrcInitInputData%depth
   DstInitInputData%C_obj%depth = SrcInitInputData%C_obj%depth
   DstInitInputData%file_name = SrcInitInputData%file_name
   DstInitInputData%C_obj%file_name = SrcInitInputData%C_obj%file_name
   DstInitInputData%summary_file_name = SrcInitInputData%summary_file_name
   DstInitInputData%C_obj%summary_file_name = SrcInitInputData%C_obj%summary_file_name
   DstInitInputData%library_input_str = SrcInitInputData%library_input_str
   DstInitInputData%C_obj%library_input_str = SrcInitInputData%C_obj%library_input_str
   DstInitInputData%node_input_str = SrcInitInputData%node_input_str
   DstInitInputData%C_obj%node_input_str = SrcInitInputData%C_obj%node_input_str
   DstInitInputData%line_input_str = SrcInitInputData%line_input_str
   DstInitInputData%C_obj%line_input_str = SrcInitInputData%C_obj%line_input_str
   DstInitInputData%option_input_str = SrcInitInputData%option_input_str
   DstInitInputData%C_obj%option_input_str = SrcInitInputData%C_obj%option_input_str
   call MAP_Fortran_CopyLin_InitInputType(SrcInitInputData%LinInitInp, DstInitInputData%LinInitInp, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine MAP_DestroyInitInput(InitInputData, ErrStat, ErrMsg)
   type(MAP_InitInputType), intent(inout) :: InitInputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'MAP_DestroyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MAP_Fortran_DestroyLin_InitInputType(InitInputData%LinInitInp, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine MAP_PackInitInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(MAP_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'MAP_PackInitInput'
   if (RF%ErrStat >= AbortErrLev) return
   if (c_associated(InData%C_obj%object)) then
      RF%ErrStat = ErrID_Fatal
      RF%ErrMsg = RoutineName//': C_obj%object cannot be packed.'
      return
   end if
   call RegPack(RF, InData%gravity)
   call RegPack(RF, InData%sea_density)
   call RegPack(RF, InData%depth)
   call RegPack(RF, InData%file_name)
   call RegPack(RF, InData%summary_file_name)
   call RegPack(RF, InData%library_input_str)
   call RegPack(RF, InData%node_input_str)
   call RegPack(RF, InData%line_input_str)
   call RegPack(RF, InData%option_input_str)
   call MAP_Fortran_PackLin_InitInputType(RF, InData%LinInitInp) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MAP_UnPackInitInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(MAP_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'MAP_UnPackInitInput'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%gravity); if (RegCheckErr(RF, RoutineName)) return
   OutData%C_obj%gravity = OutData%gravity
   call RegUnpack(RF, OutData%sea_density); if (RegCheckErr(RF, RoutineName)) return
   OutData%C_obj%sea_density = OutData%sea_density
   call RegUnpack(RF, OutData%depth); if (RegCheckErr(RF, RoutineName)) return
   OutData%C_obj%depth = OutData%depth
   call RegUnpack(RF, OutData%file_name); if (RegCheckErr(RF, RoutineName)) return
   OutData%C_obj%file_name = transfer(OutData%file_name, OutData%C_obj%file_name )
   call RegUnpack(RF, OutData%summary_file_name); if (RegCheckErr(RF, RoutineName)) return
   OutData%C_obj%summary_file_name = transfer(OutData%summary_file_name, OutData%C_obj%summary_file_name )
   call RegUnpack(RF, OutData%library_input_str); if (RegCheckErr(RF, RoutineName)) return
   OutData%C_obj%library_input_str = transfer(OutData%library_input_str, OutData%C_obj%library_input_str )
   call RegUnpack(RF, OutData%node_input_str); if (RegCheckErr(RF, RoutineName)) return
   OutData%C_obj%node_input_str = transfer(OutData%node_input_str, OutData%C_obj%node_input_str )
   call RegUnpack(RF, OutData%line_input_str); if (RegCheckErr(RF, RoutineName)) return
   OutData%C_obj%line_input_str = transfer(OutData%line_input_str, OutData%C_obj%line_input_str )
   call RegUnpack(RF, OutData%option_input_str); if (RegCheckErr(RF, RoutineName)) return
   OutData%C_obj%option_input_str = transfer(OutData%option_input_str, OutData%C_obj%option_input_str )
   call MAP_Fortran_UnpackLin_InitInputType(RF, OutData%LinInitInp) ! LinInitInp 
end subroutine

SUBROUTINE MAP_C2Fary_CopyInitInput(InitInputData, ErrStat, ErrMsg, SkipPointers)
   TYPE(MAP_InitInputType), INTENT(INOUT) :: InitInputData
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
   LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
   ! 
   LOGICAL                        :: SkipPointers_local
   ErrStat = ErrID_None
   ErrMsg  = ""
   
   IF (PRESENT(SkipPointers)) THEN
      SkipPointers_local = SkipPointers
   ELSE
      SkipPointers_local = .false.
   END IF
   InitInputData%gravity = InitInputData%C_obj%gravity
   InitInputData%sea_density = InitInputData%C_obj%sea_density
   InitInputData%depth = InitInputData%C_obj%depth
   InitInputData%file_name = TRANSFER(InitInputData%C_obj%file_name, InitInputData%file_name )
   InitInputData%summary_file_name = TRANSFER(InitInputData%C_obj%summary_file_name, InitInputData%summary_file_name )
   InitInputData%library_input_str = TRANSFER(InitInputData%C_obj%library_input_str, InitInputData%library_input_str )
   InitInputData%node_input_str = TRANSFER(InitInputData%C_obj%node_input_str, InitInputData%node_input_str )
   InitInputData%line_input_str = TRANSFER(InitInputData%C_obj%line_input_str, InitInputData%line_input_str )
   InitInputData%option_input_str = TRANSFER(InitInputData%C_obj%option_input_str, InitInputData%option_input_str )
END SUBROUTINE

SUBROUTINE MAP_F2C_CopyInitInput( InitInputData, ErrStat, ErrMsg, SkipPointers  )
   TYPE(MAP_InitInputType), INTENT(INOUT) :: InitInputData
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
   LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
   ! 
   LOGICAL                        :: SkipPointers_local
   ErrStat = ErrID_None
   ErrMsg  = ''
   
   IF (PRESENT(SkipPointers)) THEN
      SkipPointers_local = SkipPointers
   ELSE
      SkipPointers_local = .false.
   END IF
   InitInputData%C_obj%gravity = InitInputData%gravity
   InitInputData%C_obj%sea_density = InitInputData%sea_density
   InitInputData%C_obj%depth = InitInputData%depth
   InitInputData%C_obj%file_name = TRANSFER(InitInputData%file_name, InitInputData%C_obj%file_name)
   InitInputData%C_obj%summary_file_name = TRANSFER(InitInputData%summary_file_name, InitInputData%C_obj%summary_file_name)
   InitInputData%C_obj%library_input_str = TRANSFER(InitInputData%library_input_str, InitInputData%C_obj%library_input_str)
   InitInputData%C_obj%node_input_str = TRANSFER(InitInputData%node_input_str, InitInputData%C_obj%node_input_str)
   InitInputData%C_obj%line_input_str = TRANSFER(InitInputData%line_input_str, InitInputData%C_obj%line_input_str)
   InitInputData%C_obj%option_input_str = TRANSFER(InitInputData%option_input_str, InitInputData%C_obj%option_input_str)
END SUBROUTINE

subroutine MAP_CopyInitOutput(SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg)
   type(MAP_InitOutputType), intent(in) :: SrcInitOutputData
   type(MAP_InitOutputType), intent(inout) :: DstInitOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'MAP_CopyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInitOutputData%progName = SrcInitOutputData%progName
   DstInitOutputData%C_obj%progName = SrcInitOutputData%C_obj%progName
   DstInitOutputData%version = SrcInitOutputData%version
   DstInitOutputData%C_obj%version = SrcInitOutputData%C_obj%version
   DstInitOutputData%compilingData = SrcInitOutputData%compilingData
   DstInitOutputData%C_obj%compilingData = SrcInitOutputData%C_obj%compilingData
   if (allocated(SrcInitOutputData%writeOutputHdr)) then
      LB(1:1) = lbound(SrcInitOutputData%writeOutputHdr)
      UB(1:1) = ubound(SrcInitOutputData%writeOutputHdr)
      if (.not. allocated(DstInitOutputData%writeOutputHdr)) then
         allocate(DstInitOutputData%writeOutputHdr(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%writeOutputHdr.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%writeOutputHdr = SrcInitOutputData%writeOutputHdr
   end if
   if (allocated(SrcInitOutputData%writeOutputUnt)) then
      LB(1:1) = lbound(SrcInitOutputData%writeOutputUnt)
      UB(1:1) = ubound(SrcInitOutputData%writeOutputUnt)
      if (.not. allocated(DstInitOutputData%writeOutputUnt)) then
         allocate(DstInitOutputData%writeOutputUnt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%writeOutputUnt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%writeOutputUnt = SrcInitOutputData%writeOutputUnt
   end if
   call NWTC_Library_CopyProgDesc(SrcInitOutputData%Ver, DstInitOutputData%Ver, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MAP_Fortran_CopyLin_InitOutputType(SrcInitOutputData%LinInitOut, DstInitOutputData%LinInitOut, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine MAP_DestroyInitOutput(InitOutputData, ErrStat, ErrMsg)
   type(MAP_InitOutputType), intent(inout) :: InitOutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'MAP_DestroyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InitOutputData%writeOutputHdr)) then
      deallocate(InitOutputData%writeOutputHdr)
   end if
   if (allocated(InitOutputData%writeOutputUnt)) then
      deallocate(InitOutputData%writeOutputUnt)
   end if
   call NWTC_Library_DestroyProgDesc(InitOutputData%Ver, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MAP_Fortran_DestroyLin_InitOutputType(InitOutputData%LinInitOut, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine MAP_PackInitOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(MAP_InitOutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'MAP_PackInitOutput'
   if (RF%ErrStat >= AbortErrLev) return
   if (c_associated(InData%C_obj%object)) then
      RF%ErrStat = ErrID_Fatal
      RF%ErrMsg = RoutineName//': C_obj%object cannot be packed.'
      return
   end if
   call RegPack(RF, InData%progName)
   call RegPack(RF, InData%version)
   call RegPack(RF, InData%compilingData)
   call RegPackAlloc(RF, InData%writeOutputHdr)
   call RegPackAlloc(RF, InData%writeOutputUnt)
   call NWTC_Library_PackProgDesc(RF, InData%Ver) 
   call MAP_Fortran_PackLin_InitOutputType(RF, InData%LinInitOut) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MAP_UnPackInitOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(MAP_InitOutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'MAP_UnPackInitOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%progName); if (RegCheckErr(RF, RoutineName)) return
   OutData%C_obj%progName = transfer(OutData%progName, OutData%C_obj%progName )
   call RegUnpack(RF, OutData%version); if (RegCheckErr(RF, RoutineName)) return
   OutData%C_obj%version = transfer(OutData%version, OutData%C_obj%version )
   call RegUnpack(RF, OutData%compilingData); if (RegCheckErr(RF, RoutineName)) return
   OutData%C_obj%compilingData = transfer(OutData%compilingData, OutData%C_obj%compilingData )
   call RegUnpackAlloc(RF, OutData%writeOutputHdr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%writeOutputUnt); if (RegCheckErr(RF, RoutineName)) return
   call NWTC_Library_UnpackProgDesc(RF, OutData%Ver) ! Ver 
   call MAP_Fortran_UnpackLin_InitOutputType(RF, OutData%LinInitOut) ! LinInitOut 
end subroutine

SUBROUTINE MAP_C2Fary_CopyInitOutput(InitOutputData, ErrStat, ErrMsg, SkipPointers)
   TYPE(MAP_InitOutputType), INTENT(INOUT) :: InitOutputData
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
   LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
   ! 
   LOGICAL                        :: SkipPointers_local
   ErrStat = ErrID_None
   ErrMsg  = ""
   
   IF (PRESENT(SkipPointers)) THEN
      SkipPointers_local = SkipPointers
   ELSE
      SkipPointers_local = .false.
   END IF
   InitOutputData%progName = TRANSFER(InitOutputData%C_obj%progName, InitOutputData%progName )
   InitOutputData%version = TRANSFER(InitOutputData%C_obj%version, InitOutputData%version )
   InitOutputData%compilingData = TRANSFER(InitOutputData%C_obj%compilingData, InitOutputData%compilingData )
END SUBROUTINE

SUBROUTINE MAP_F2C_CopyInitOutput( InitOutputData, ErrStat, ErrMsg, SkipPointers  )
   TYPE(MAP_InitOutputType), INTENT(INOUT) :: InitOutputData
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
   LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
   ! 
   LOGICAL                        :: SkipPointers_local
   ErrStat = ErrID_None
   ErrMsg  = ''
   
   IF (PRESENT(SkipPointers)) THEN
      SkipPointers_local = SkipPointers
   ELSE
      SkipPointers_local = .false.
   END IF
   InitOutputData%C_obj%progName = TRANSFER(InitOutputData%progName, InitOutputData%C_obj%progName)
   InitOutputData%C_obj%version = TRANSFER(InitOutputData%version, InitOutputData%C_obj%version)
   InitOutputData%C_obj%compilingData = TRANSFER(InitOutputData%compilingData, InitOutputData%C_obj%compilingData)
END SUBROUTINE

subroutine MAP_CopyContState(SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg)
   type(MAP_ContinuousStateType), intent(in) :: SrcContStateData
   type(MAP_ContinuousStateType), intent(inout) :: DstContStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'MAP_CopyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstContStateData%dummy = SrcContStateData%dummy
   DstContStateData%C_obj%dummy = SrcContStateData%C_obj%dummy
end subroutine

subroutine MAP_DestroyContState(ContStateData, ErrStat, ErrMsg)
   type(MAP_ContinuousStateType), intent(inout) :: ContStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'MAP_DestroyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine MAP_PackContState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(MAP_ContinuousStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'MAP_PackContState'
   if (RF%ErrStat >= AbortErrLev) return
   if (c_associated(InData%C_obj%object)) then
      RF%ErrStat = ErrID_Fatal
      RF%ErrMsg = RoutineName//': C_obj%object cannot be packed.'
      return
   end if
   call RegPack(RF, InData%dummy)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MAP_UnPackContState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(MAP_ContinuousStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'MAP_UnPackContState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%dummy); if (RegCheckErr(RF, RoutineName)) return
   OutData%C_obj%dummy = OutData%dummy
end subroutine

SUBROUTINE MAP_C2Fary_CopyContState(ContStateData, ErrStat, ErrMsg, SkipPointers)
   TYPE(MAP_ContinuousStateType), INTENT(INOUT) :: ContStateData
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
   LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
   ! 
   LOGICAL                        :: SkipPointers_local
   ErrStat = ErrID_None
   ErrMsg  = ""
   
   IF (PRESENT(SkipPointers)) THEN
      SkipPointers_local = SkipPointers
   ELSE
      SkipPointers_local = .false.
   END IF
   ContStateData%dummy = ContStateData%C_obj%dummy
END SUBROUTINE

SUBROUTINE MAP_F2C_CopyContState( ContStateData, ErrStat, ErrMsg, SkipPointers  )
   TYPE(MAP_ContinuousStateType), INTENT(INOUT) :: ContStateData
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
   LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
   ! 
   LOGICAL                        :: SkipPointers_local
   ErrStat = ErrID_None
   ErrMsg  = ''
   
   IF (PRESENT(SkipPointers)) THEN
      SkipPointers_local = SkipPointers
   ELSE
      SkipPointers_local = .false.
   END IF
   ContStateData%C_obj%dummy = ContStateData%dummy
END SUBROUTINE

subroutine MAP_CopyDiscState(SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg)
   type(MAP_DiscreteStateType), intent(in) :: SrcDiscStateData
   type(MAP_DiscreteStateType), intent(inout) :: DstDiscStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'MAP_CopyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstDiscStateData%dummy = SrcDiscStateData%dummy
   DstDiscStateData%C_obj%dummy = SrcDiscStateData%C_obj%dummy
end subroutine

subroutine MAP_DestroyDiscState(DiscStateData, ErrStat, ErrMsg)
   type(MAP_DiscreteStateType), intent(inout) :: DiscStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'MAP_DestroyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine MAP_PackDiscState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(MAP_DiscreteStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'MAP_PackDiscState'
   if (RF%ErrStat >= AbortErrLev) return
   if (c_associated(InData%C_obj%object)) then
      RF%ErrStat = ErrID_Fatal
      RF%ErrMsg = RoutineName//': C_obj%object cannot be packed.'
      return
   end if
   call RegPack(RF, InData%dummy)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MAP_UnPackDiscState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(MAP_DiscreteStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'MAP_UnPackDiscState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%dummy); if (RegCheckErr(RF, RoutineName)) return
   OutData%C_obj%dummy = OutData%dummy
end subroutine

SUBROUTINE MAP_C2Fary_CopyDiscState(DiscStateData, ErrStat, ErrMsg, SkipPointers)
   TYPE(MAP_DiscreteStateType), INTENT(INOUT) :: DiscStateData
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
   LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
   ! 
   LOGICAL                        :: SkipPointers_local
   ErrStat = ErrID_None
   ErrMsg  = ""
   
   IF (PRESENT(SkipPointers)) THEN
      SkipPointers_local = SkipPointers
   ELSE
      SkipPointers_local = .false.
   END IF
   DiscStateData%dummy = DiscStateData%C_obj%dummy
END SUBROUTINE

SUBROUTINE MAP_F2C_CopyDiscState( DiscStateData, ErrStat, ErrMsg, SkipPointers  )
   TYPE(MAP_DiscreteStateType), INTENT(INOUT) :: DiscStateData
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
   LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
   ! 
   LOGICAL                        :: SkipPointers_local
   ErrStat = ErrID_None
   ErrMsg  = ''
   
   IF (PRESENT(SkipPointers)) THEN
      SkipPointers_local = SkipPointers
   ELSE
      SkipPointers_local = .false.
   END IF
   DiscStateData%C_obj%dummy = DiscStateData%dummy
END SUBROUTINE

subroutine MAP_CopyOtherState(SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg)
   type(MAP_OtherStateType), intent(in) :: SrcOtherStateData
   type(MAP_OtherStateType), intent(inout) :: DstOtherStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'MAP_CopyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (associated(SrcOtherStateData%H)) then
      LB(1:1) = lbound(SrcOtherStateData%H)
      UB(1:1) = ubound(SrcOtherStateData%H)
      if (.not. associated(DstOtherStateData%H)) then
         allocate(DstOtherStateData%H(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%H.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstOtherStateData%C_obj%H_Len = size(DstOtherStateData%H)
         if (DstOtherStateData%C_obj%H_Len > 0) &
            DstOtherStateData%C_obj%H = c_loc(DstOtherStateData%H(LB(1)))
      end if
      DstOtherStateData%H = SrcOtherStateData%H
   end if
   if (associated(SrcOtherStateData%V)) then
      LB(1:1) = lbound(SrcOtherStateData%V)
      UB(1:1) = ubound(SrcOtherStateData%V)
      if (.not. associated(DstOtherStateData%V)) then
         allocate(DstOtherStateData%V(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%V.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstOtherStateData%C_obj%V_Len = size(DstOtherStateData%V)
         if (DstOtherStateData%C_obj%V_Len > 0) &
            DstOtherStateData%C_obj%V = c_loc(DstOtherStateData%V(LB(1)))
      end if
      DstOtherStateData%V = SrcOtherStateData%V
   end if
   if (associated(SrcOtherStateData%Ha)) then
      LB(1:1) = lbound(SrcOtherStateData%Ha)
      UB(1:1) = ubound(SrcOtherStateData%Ha)
      if (.not. associated(DstOtherStateData%Ha)) then
         allocate(DstOtherStateData%Ha(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%Ha.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstOtherStateData%C_obj%Ha_Len = size(DstOtherStateData%Ha)
         if (DstOtherStateData%C_obj%Ha_Len > 0) &
            DstOtherStateData%C_obj%Ha = c_loc(DstOtherStateData%Ha(LB(1)))
      end if
      DstOtherStateData%Ha = SrcOtherStateData%Ha
   end if
   if (associated(SrcOtherStateData%Va)) then
      LB(1:1) = lbound(SrcOtherStateData%Va)
      UB(1:1) = ubound(SrcOtherStateData%Va)
      if (.not. associated(DstOtherStateData%Va)) then
         allocate(DstOtherStateData%Va(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%Va.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstOtherStateData%C_obj%Va_Len = size(DstOtherStateData%Va)
         if (DstOtherStateData%C_obj%Va_Len > 0) &
            DstOtherStateData%C_obj%Va = c_loc(DstOtherStateData%Va(LB(1)))
      end if
      DstOtherStateData%Va = SrcOtherStateData%Va
   end if
   if (associated(SrcOtherStateData%x)) then
      LB(1:1) = lbound(SrcOtherStateData%x)
      UB(1:1) = ubound(SrcOtherStateData%x)
      if (.not. associated(DstOtherStateData%x)) then
         allocate(DstOtherStateData%x(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstOtherStateData%C_obj%x_Len = size(DstOtherStateData%x)
         if (DstOtherStateData%C_obj%x_Len > 0) &
            DstOtherStateData%C_obj%x = c_loc(DstOtherStateData%x(LB(1)))
      end if
      DstOtherStateData%x = SrcOtherStateData%x
   end if
   if (associated(SrcOtherStateData%y)) then
      LB(1:1) = lbound(SrcOtherStateData%y)
      UB(1:1) = ubound(SrcOtherStateData%y)
      if (.not. associated(DstOtherStateData%y)) then
         allocate(DstOtherStateData%y(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%y.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstOtherStateData%C_obj%y_Len = size(DstOtherStateData%y)
         if (DstOtherStateData%C_obj%y_Len > 0) &
            DstOtherStateData%C_obj%y = c_loc(DstOtherStateData%y(LB(1)))
      end if
      DstOtherStateData%y = SrcOtherStateData%y
   end if
   if (associated(SrcOtherStateData%z)) then
      LB(1:1) = lbound(SrcOtherStateData%z)
      UB(1:1) = ubound(SrcOtherStateData%z)
      if (.not. associated(DstOtherStateData%z)) then
         allocate(DstOtherStateData%z(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%z.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstOtherStateData%C_obj%z_Len = size(DstOtherStateData%z)
         if (DstOtherStateData%C_obj%z_Len > 0) &
            DstOtherStateData%C_obj%z = c_loc(DstOtherStateData%z(LB(1)))
      end if
      DstOtherStateData%z = SrcOtherStateData%z
   end if
   if (associated(SrcOtherStateData%xa)) then
      LB(1:1) = lbound(SrcOtherStateData%xa)
      UB(1:1) = ubound(SrcOtherStateData%xa)
      if (.not. associated(DstOtherStateData%xa)) then
         allocate(DstOtherStateData%xa(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%xa.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstOtherStateData%C_obj%xa_Len = size(DstOtherStateData%xa)
         if (DstOtherStateData%C_obj%xa_Len > 0) &
            DstOtherStateData%C_obj%xa = c_loc(DstOtherStateData%xa(LB(1)))
      end if
      DstOtherStateData%xa = SrcOtherStateData%xa
   end if
   if (associated(SrcOtherStateData%ya)) then
      LB(1:1) = lbound(SrcOtherStateData%ya)
      UB(1:1) = ubound(SrcOtherStateData%ya)
      if (.not. associated(DstOtherStateData%ya)) then
         allocate(DstOtherStateData%ya(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%ya.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstOtherStateData%C_obj%ya_Len = size(DstOtherStateData%ya)
         if (DstOtherStateData%C_obj%ya_Len > 0) &
            DstOtherStateData%C_obj%ya = c_loc(DstOtherStateData%ya(LB(1)))
      end if
      DstOtherStateData%ya = SrcOtherStateData%ya
   end if
   if (associated(SrcOtherStateData%za)) then
      LB(1:1) = lbound(SrcOtherStateData%za)
      UB(1:1) = ubound(SrcOtherStateData%za)
      if (.not. associated(DstOtherStateData%za)) then
         allocate(DstOtherStateData%za(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%za.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstOtherStateData%C_obj%za_Len = size(DstOtherStateData%za)
         if (DstOtherStateData%C_obj%za_Len > 0) &
            DstOtherStateData%C_obj%za = c_loc(DstOtherStateData%za(LB(1)))
      end if
      DstOtherStateData%za = SrcOtherStateData%za
   end if
   if (associated(SrcOtherStateData%Fx_connect)) then
      LB(1:1) = lbound(SrcOtherStateData%Fx_connect)
      UB(1:1) = ubound(SrcOtherStateData%Fx_connect)
      if (.not. associated(DstOtherStateData%Fx_connect)) then
         allocate(DstOtherStateData%Fx_connect(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%Fx_connect.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstOtherStateData%C_obj%Fx_connect_Len = size(DstOtherStateData%Fx_connect)
         if (DstOtherStateData%C_obj%Fx_connect_Len > 0) &
            DstOtherStateData%C_obj%Fx_connect = c_loc(DstOtherStateData%Fx_connect(LB(1)))
      end if
      DstOtherStateData%Fx_connect = SrcOtherStateData%Fx_connect
   end if
   if (associated(SrcOtherStateData%Fy_connect)) then
      LB(1:1) = lbound(SrcOtherStateData%Fy_connect)
      UB(1:1) = ubound(SrcOtherStateData%Fy_connect)
      if (.not. associated(DstOtherStateData%Fy_connect)) then
         allocate(DstOtherStateData%Fy_connect(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%Fy_connect.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstOtherStateData%C_obj%Fy_connect_Len = size(DstOtherStateData%Fy_connect)
         if (DstOtherStateData%C_obj%Fy_connect_Len > 0) &
            DstOtherStateData%C_obj%Fy_connect = c_loc(DstOtherStateData%Fy_connect(LB(1)))
      end if
      DstOtherStateData%Fy_connect = SrcOtherStateData%Fy_connect
   end if
   if (associated(SrcOtherStateData%Fz_connect)) then
      LB(1:1) = lbound(SrcOtherStateData%Fz_connect)
      UB(1:1) = ubound(SrcOtherStateData%Fz_connect)
      if (.not. associated(DstOtherStateData%Fz_connect)) then
         allocate(DstOtherStateData%Fz_connect(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%Fz_connect.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstOtherStateData%C_obj%Fz_connect_Len = size(DstOtherStateData%Fz_connect)
         if (DstOtherStateData%C_obj%Fz_connect_Len > 0) &
            DstOtherStateData%C_obj%Fz_connect = c_loc(DstOtherStateData%Fz_connect(LB(1)))
      end if
      DstOtherStateData%Fz_connect = SrcOtherStateData%Fz_connect
   end if
   if (associated(SrcOtherStateData%Fx_anchor)) then
      LB(1:1) = lbound(SrcOtherStateData%Fx_anchor)
      UB(1:1) = ubound(SrcOtherStateData%Fx_anchor)
      if (.not. associated(DstOtherStateData%Fx_anchor)) then
         allocate(DstOtherStateData%Fx_anchor(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%Fx_anchor.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstOtherStateData%C_obj%Fx_anchor_Len = size(DstOtherStateData%Fx_anchor)
         if (DstOtherStateData%C_obj%Fx_anchor_Len > 0) &
            DstOtherStateData%C_obj%Fx_anchor = c_loc(DstOtherStateData%Fx_anchor(LB(1)))
      end if
      DstOtherStateData%Fx_anchor = SrcOtherStateData%Fx_anchor
   end if
   if (associated(SrcOtherStateData%Fy_anchor)) then
      LB(1:1) = lbound(SrcOtherStateData%Fy_anchor)
      UB(1:1) = ubound(SrcOtherStateData%Fy_anchor)
      if (.not. associated(DstOtherStateData%Fy_anchor)) then
         allocate(DstOtherStateData%Fy_anchor(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%Fy_anchor.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstOtherStateData%C_obj%Fy_anchor_Len = size(DstOtherStateData%Fy_anchor)
         if (DstOtherStateData%C_obj%Fy_anchor_Len > 0) &
            DstOtherStateData%C_obj%Fy_anchor = c_loc(DstOtherStateData%Fy_anchor(LB(1)))
      end if
      DstOtherStateData%Fy_anchor = SrcOtherStateData%Fy_anchor
   end if
   if (associated(SrcOtherStateData%Fz_anchor)) then
      LB(1:1) = lbound(SrcOtherStateData%Fz_anchor)
      UB(1:1) = ubound(SrcOtherStateData%Fz_anchor)
      if (.not. associated(DstOtherStateData%Fz_anchor)) then
         allocate(DstOtherStateData%Fz_anchor(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%Fz_anchor.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstOtherStateData%C_obj%Fz_anchor_Len = size(DstOtherStateData%Fz_anchor)
         if (DstOtherStateData%C_obj%Fz_anchor_Len > 0) &
            DstOtherStateData%C_obj%Fz_anchor = c_loc(DstOtherStateData%Fz_anchor(LB(1)))
      end if
      DstOtherStateData%Fz_anchor = SrcOtherStateData%Fz_anchor
   end if
end subroutine

subroutine MAP_DestroyOtherState(OtherStateData, ErrStat, ErrMsg)
   type(MAP_OtherStateType), intent(inout) :: OtherStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'MAP_DestroyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (associated(OtherStateData%H)) then
      deallocate(OtherStateData%H)
      OtherStateData%H => null()
      OtherStateData%C_obj%H = c_null_ptr
      OtherStateData%C_obj%H_Len = 0
   end if
   if (associated(OtherStateData%V)) then
      deallocate(OtherStateData%V)
      OtherStateData%V => null()
      OtherStateData%C_obj%V = c_null_ptr
      OtherStateData%C_obj%V_Len = 0
   end if
   if (associated(OtherStateData%Ha)) then
      deallocate(OtherStateData%Ha)
      OtherStateData%Ha => null()
      OtherStateData%C_obj%Ha = c_null_ptr
      OtherStateData%C_obj%Ha_Len = 0
   end if
   if (associated(OtherStateData%Va)) then
      deallocate(OtherStateData%Va)
      OtherStateData%Va => null()
      OtherStateData%C_obj%Va = c_null_ptr
      OtherStateData%C_obj%Va_Len = 0
   end if
   if (associated(OtherStateData%x)) then
      deallocate(OtherStateData%x)
      OtherStateData%x => null()
      OtherStateData%C_obj%x = c_null_ptr
      OtherStateData%C_obj%x_Len = 0
   end if
   if (associated(OtherStateData%y)) then
      deallocate(OtherStateData%y)
      OtherStateData%y => null()
      OtherStateData%C_obj%y = c_null_ptr
      OtherStateData%C_obj%y_Len = 0
   end if
   if (associated(OtherStateData%z)) then
      deallocate(OtherStateData%z)
      OtherStateData%z => null()
      OtherStateData%C_obj%z = c_null_ptr
      OtherStateData%C_obj%z_Len = 0
   end if
   if (associated(OtherStateData%xa)) then
      deallocate(OtherStateData%xa)
      OtherStateData%xa => null()
      OtherStateData%C_obj%xa = c_null_ptr
      OtherStateData%C_obj%xa_Len = 0
   end if
   if (associated(OtherStateData%ya)) then
      deallocate(OtherStateData%ya)
      OtherStateData%ya => null()
      OtherStateData%C_obj%ya = c_null_ptr
      OtherStateData%C_obj%ya_Len = 0
   end if
   if (associated(OtherStateData%za)) then
      deallocate(OtherStateData%za)
      OtherStateData%za => null()
      OtherStateData%C_obj%za = c_null_ptr
      OtherStateData%C_obj%za_Len = 0
   end if
   if (associated(OtherStateData%Fx_connect)) then
      deallocate(OtherStateData%Fx_connect)
      OtherStateData%Fx_connect => null()
      OtherStateData%C_obj%Fx_connect = c_null_ptr
      OtherStateData%C_obj%Fx_connect_Len = 0
   end if
   if (associated(OtherStateData%Fy_connect)) then
      deallocate(OtherStateData%Fy_connect)
      OtherStateData%Fy_connect => null()
      OtherStateData%C_obj%Fy_connect = c_null_ptr
      OtherStateData%C_obj%Fy_connect_Len = 0
   end if
   if (associated(OtherStateData%Fz_connect)) then
      deallocate(OtherStateData%Fz_connect)
      OtherStateData%Fz_connect => null()
      OtherStateData%C_obj%Fz_connect = c_null_ptr
      OtherStateData%C_obj%Fz_connect_Len = 0
   end if
   if (associated(OtherStateData%Fx_anchor)) then
      deallocate(OtherStateData%Fx_anchor)
      OtherStateData%Fx_anchor => null()
      OtherStateData%C_obj%Fx_anchor = c_null_ptr
      OtherStateData%C_obj%Fx_anchor_Len = 0
   end if
   if (associated(OtherStateData%Fy_anchor)) then
      deallocate(OtherStateData%Fy_anchor)
      OtherStateData%Fy_anchor => null()
      OtherStateData%C_obj%Fy_anchor = c_null_ptr
      OtherStateData%C_obj%Fy_anchor_Len = 0
   end if
   if (associated(OtherStateData%Fz_anchor)) then
      deallocate(OtherStateData%Fz_anchor)
      OtherStateData%Fz_anchor => null()
      OtherStateData%C_obj%Fz_anchor = c_null_ptr
      OtherStateData%C_obj%Fz_anchor_Len = 0
   end if
end subroutine

subroutine MAP_PackOtherState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(MAP_OtherStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'MAP_PackOtherState'
   logical         :: PtrInIndex
   if (RF%ErrStat >= AbortErrLev) return
   if (c_associated(InData%C_obj%object)) then
      RF%ErrStat = ErrID_Fatal
      RF%ErrMsg = RoutineName//': C_obj%object cannot be packed.'
      return
   end if
   call RegPackPtr(RF, InData%H)
   call RegPackPtr(RF, InData%V)
   call RegPackPtr(RF, InData%Ha)
   call RegPackPtr(RF, InData%Va)
   call RegPackPtr(RF, InData%x)
   call RegPackPtr(RF, InData%y)
   call RegPackPtr(RF, InData%z)
   call RegPackPtr(RF, InData%xa)
   call RegPackPtr(RF, InData%ya)
   call RegPackPtr(RF, InData%za)
   call RegPackPtr(RF, InData%Fx_connect)
   call RegPackPtr(RF, InData%Fy_connect)
   call RegPackPtr(RF, InData%Fz_connect)
   call RegPackPtr(RF, InData%Fx_anchor)
   call RegPackPtr(RF, InData%Fy_anchor)
   call RegPackPtr(RF, InData%Fz_anchor)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MAP_UnPackOtherState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(MAP_OtherStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'MAP_UnPackOtherState'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   integer(B8Ki)   :: PtrIdx
   type(c_ptr)     :: Ptr
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackPtr(RF, OutData%H, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%H)) then
      OutData%C_obj%H_Len = size(OutData%H)
      if (OutData%C_obj%H_Len > 0) OutData%C_obj%H = c_loc(OutData%H(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%V, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%V)) then
      OutData%C_obj%V_Len = size(OutData%V)
      if (OutData%C_obj%V_Len > 0) OutData%C_obj%V = c_loc(OutData%V(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%Ha, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%Ha)) then
      OutData%C_obj%Ha_Len = size(OutData%Ha)
      if (OutData%C_obj%Ha_Len > 0) OutData%C_obj%Ha = c_loc(OutData%Ha(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%Va, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%Va)) then
      OutData%C_obj%Va_Len = size(OutData%Va)
      if (OutData%C_obj%Va_Len > 0) OutData%C_obj%Va = c_loc(OutData%Va(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%x, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%x)) then
      OutData%C_obj%x_Len = size(OutData%x)
      if (OutData%C_obj%x_Len > 0) OutData%C_obj%x = c_loc(OutData%x(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%y, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%y)) then
      OutData%C_obj%y_Len = size(OutData%y)
      if (OutData%C_obj%y_Len > 0) OutData%C_obj%y = c_loc(OutData%y(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%z, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%z)) then
      OutData%C_obj%z_Len = size(OutData%z)
      if (OutData%C_obj%z_Len > 0) OutData%C_obj%z = c_loc(OutData%z(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%xa, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%xa)) then
      OutData%C_obj%xa_Len = size(OutData%xa)
      if (OutData%C_obj%xa_Len > 0) OutData%C_obj%xa = c_loc(OutData%xa(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%ya, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%ya)) then
      OutData%C_obj%ya_Len = size(OutData%ya)
      if (OutData%C_obj%ya_Len > 0) OutData%C_obj%ya = c_loc(OutData%ya(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%za, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%za)) then
      OutData%C_obj%za_Len = size(OutData%za)
      if (OutData%C_obj%za_Len > 0) OutData%C_obj%za = c_loc(OutData%za(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%Fx_connect, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%Fx_connect)) then
      OutData%C_obj%Fx_connect_Len = size(OutData%Fx_connect)
      if (OutData%C_obj%Fx_connect_Len > 0) OutData%C_obj%Fx_connect = c_loc(OutData%Fx_connect(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%Fy_connect, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%Fy_connect)) then
      OutData%C_obj%Fy_connect_Len = size(OutData%Fy_connect)
      if (OutData%C_obj%Fy_connect_Len > 0) OutData%C_obj%Fy_connect = c_loc(OutData%Fy_connect(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%Fz_connect, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%Fz_connect)) then
      OutData%C_obj%Fz_connect_Len = size(OutData%Fz_connect)
      if (OutData%C_obj%Fz_connect_Len > 0) OutData%C_obj%Fz_connect = c_loc(OutData%Fz_connect(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%Fx_anchor, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%Fx_anchor)) then
      OutData%C_obj%Fx_anchor_Len = size(OutData%Fx_anchor)
      if (OutData%C_obj%Fx_anchor_Len > 0) OutData%C_obj%Fx_anchor = c_loc(OutData%Fx_anchor(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%Fy_anchor, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%Fy_anchor)) then
      OutData%C_obj%Fy_anchor_Len = size(OutData%Fy_anchor)
      if (OutData%C_obj%Fy_anchor_Len > 0) OutData%C_obj%Fy_anchor = c_loc(OutData%Fy_anchor(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%Fz_anchor, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%Fz_anchor)) then
      OutData%C_obj%Fz_anchor_Len = size(OutData%Fz_anchor)
      if (OutData%C_obj%Fz_anchor_Len > 0) OutData%C_obj%Fz_anchor = c_loc(OutData%Fz_anchor(LB(1)))
   end if
end subroutine

SUBROUTINE MAP_C2Fary_CopyOtherState(OtherStateData, ErrStat, ErrMsg, SkipPointers)
   TYPE(MAP_OtherStateType), INTENT(INOUT) :: OtherStateData
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
   LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
   ! 
   LOGICAL                        :: SkipPointers_local
   ErrStat = ErrID_None
   ErrMsg  = ""
   
   IF (PRESENT(SkipPointers)) THEN
      SkipPointers_local = SkipPointers
   ELSE
      SkipPointers_local = .false.
   END IF
   
   ! -- H OtherState Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( OtherStateData%C_obj%H ) ) THEN
         NULLIFY( OtherStateData%H )
      ELSE
         CALL C_F_POINTER(OtherStateData%C_obj%H, OtherStateData%H, [OtherStateData%C_obj%H_Len])
      END IF
   END IF
   
   ! -- V OtherState Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( OtherStateData%C_obj%V ) ) THEN
         NULLIFY( OtherStateData%V )
      ELSE
         CALL C_F_POINTER(OtherStateData%C_obj%V, OtherStateData%V, [OtherStateData%C_obj%V_Len])
      END IF
   END IF
   
   ! -- Ha OtherState Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( OtherStateData%C_obj%Ha ) ) THEN
         NULLIFY( OtherStateData%Ha )
      ELSE
         CALL C_F_POINTER(OtherStateData%C_obj%Ha, OtherStateData%Ha, [OtherStateData%C_obj%Ha_Len])
      END IF
   END IF
   
   ! -- Va OtherState Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( OtherStateData%C_obj%Va ) ) THEN
         NULLIFY( OtherStateData%Va )
      ELSE
         CALL C_F_POINTER(OtherStateData%C_obj%Va, OtherStateData%Va, [OtherStateData%C_obj%Va_Len])
      END IF
   END IF
   
   ! -- x OtherState Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( OtherStateData%C_obj%x ) ) THEN
         NULLIFY( OtherStateData%x )
      ELSE
         CALL C_F_POINTER(OtherStateData%C_obj%x, OtherStateData%x, [OtherStateData%C_obj%x_Len])
      END IF
   END IF
   
   ! -- y OtherState Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( OtherStateData%C_obj%y ) ) THEN
         NULLIFY( OtherStateData%y )
      ELSE
         CALL C_F_POINTER(OtherStateData%C_obj%y, OtherStateData%y, [OtherStateData%C_obj%y_Len])
      END IF
   END IF
   
   ! -- z OtherState Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( OtherStateData%C_obj%z ) ) THEN
         NULLIFY( OtherStateData%z )
      ELSE
         CALL C_F_POINTER(OtherStateData%C_obj%z, OtherStateData%z, [OtherStateData%C_obj%z_Len])
      END IF
   END IF
   
   ! -- xa OtherState Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( OtherStateData%C_obj%xa ) ) THEN
         NULLIFY( OtherStateData%xa )
      ELSE
         CALL C_F_POINTER(OtherStateData%C_obj%xa, OtherStateData%xa, [OtherStateData%C_obj%xa_Len])
      END IF
   END IF
   
   ! -- ya OtherState Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( OtherStateData%C_obj%ya ) ) THEN
         NULLIFY( OtherStateData%ya )
      ELSE
         CALL C_F_POINTER(OtherStateData%C_obj%ya, OtherStateData%ya, [OtherStateData%C_obj%ya_Len])
      END IF
   END IF
   
   ! -- za OtherState Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( OtherStateData%C_obj%za ) ) THEN
         NULLIFY( OtherStateData%za )
      ELSE
         CALL C_F_POINTER(OtherStateData%C_obj%za, OtherStateData%za, [OtherStateData%C_obj%za_Len])
      END IF
   END IF
   
   ! -- Fx_connect OtherState Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( OtherStateData%C_obj%Fx_connect ) ) THEN
         NULLIFY( OtherStateData%Fx_connect )
      ELSE
         CALL C_F_POINTER(OtherStateData%C_obj%Fx_connect, OtherStateData%Fx_connect, [OtherStateData%C_obj%Fx_connect_Len])
      END IF
   END IF
   
   ! -- Fy_connect OtherState Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( OtherStateData%C_obj%Fy_connect ) ) THEN
         NULLIFY( OtherStateData%Fy_connect )
      ELSE
         CALL C_F_POINTER(OtherStateData%C_obj%Fy_connect, OtherStateData%Fy_connect, [OtherStateData%C_obj%Fy_connect_Len])
      END IF
   END IF
   
   ! -- Fz_connect OtherState Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( OtherStateData%C_obj%Fz_connect ) ) THEN
         NULLIFY( OtherStateData%Fz_connect )
      ELSE
         CALL C_F_POINTER(OtherStateData%C_obj%Fz_connect, OtherStateData%Fz_connect, [OtherStateData%C_obj%Fz_connect_Len])
      END IF
   END IF
   
   ! -- Fx_anchor OtherState Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( OtherStateData%C_obj%Fx_anchor ) ) THEN
         NULLIFY( OtherStateData%Fx_anchor )
      ELSE
         CALL C_F_POINTER(OtherStateData%C_obj%Fx_anchor, OtherStateData%Fx_anchor, [OtherStateData%C_obj%Fx_anchor_Len])
      END IF
   END IF
   
   ! -- Fy_anchor OtherState Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( OtherStateData%C_obj%Fy_anchor ) ) THEN
         NULLIFY( OtherStateData%Fy_anchor )
      ELSE
         CALL C_F_POINTER(OtherStateData%C_obj%Fy_anchor, OtherStateData%Fy_anchor, [OtherStateData%C_obj%Fy_anchor_Len])
      END IF
   END IF
   
   ! -- Fz_anchor OtherState Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( OtherStateData%C_obj%Fz_anchor ) ) THEN
         NULLIFY( OtherStateData%Fz_anchor )
      ELSE
         CALL C_F_POINTER(OtherStateData%C_obj%Fz_anchor, OtherStateData%Fz_anchor, [OtherStateData%C_obj%Fz_anchor_Len])
      END IF
   END IF
END SUBROUTINE

SUBROUTINE MAP_F2C_CopyOtherState( OtherStateData, ErrStat, ErrMsg, SkipPointers  )
   TYPE(MAP_OtherStateType), INTENT(INOUT) :: OtherStateData
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
   LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
   ! 
   LOGICAL                        :: SkipPointers_local
   ErrStat = ErrID_None
   ErrMsg  = ''
   
   IF (PRESENT(SkipPointers)) THEN
      SkipPointers_local = SkipPointers
   ELSE
      SkipPointers_local = .false.
   END IF
   
   ! -- H OtherState Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(OtherStateData%H)) THEN 
         OtherStateData%C_obj%H_Len = 0
         OtherStateData%C_obj%H = C_NULL_PTR
      ELSE
         OtherStateData%C_obj%H_Len = SIZE(OtherStateData%H)
         IF (OtherStateData%C_obj%H_Len > 0) &
            OtherStateData%C_obj%H = C_LOC(OtherStateData%H(lbound(OtherStateData%H,1)))
      END IF
   END IF
   
   ! -- V OtherState Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(OtherStateData%V)) THEN 
         OtherStateData%C_obj%V_Len = 0
         OtherStateData%C_obj%V = C_NULL_PTR
      ELSE
         OtherStateData%C_obj%V_Len = SIZE(OtherStateData%V)
         IF (OtherStateData%C_obj%V_Len > 0) &
            OtherStateData%C_obj%V = C_LOC(OtherStateData%V(lbound(OtherStateData%V,1)))
      END IF
   END IF
   
   ! -- Ha OtherState Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(OtherStateData%Ha)) THEN 
         OtherStateData%C_obj%Ha_Len = 0
         OtherStateData%C_obj%Ha = C_NULL_PTR
      ELSE
         OtherStateData%C_obj%Ha_Len = SIZE(OtherStateData%Ha)
         IF (OtherStateData%C_obj%Ha_Len > 0) &
            OtherStateData%C_obj%Ha = C_LOC(OtherStateData%Ha(lbound(OtherStateData%Ha,1)))
      END IF
   END IF
   
   ! -- Va OtherState Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(OtherStateData%Va)) THEN 
         OtherStateData%C_obj%Va_Len = 0
         OtherStateData%C_obj%Va = C_NULL_PTR
      ELSE
         OtherStateData%C_obj%Va_Len = SIZE(OtherStateData%Va)
         IF (OtherStateData%C_obj%Va_Len > 0) &
            OtherStateData%C_obj%Va = C_LOC(OtherStateData%Va(lbound(OtherStateData%Va,1)))
      END IF
   END IF
   
   ! -- x OtherState Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(OtherStateData%x)) THEN 
         OtherStateData%C_obj%x_Len = 0
         OtherStateData%C_obj%x = C_NULL_PTR
      ELSE
         OtherStateData%C_obj%x_Len = SIZE(OtherStateData%x)
         IF (OtherStateData%C_obj%x_Len > 0) &
            OtherStateData%C_obj%x = C_LOC(OtherStateData%x(lbound(OtherStateData%x,1)))
      END IF
   END IF
   
   ! -- y OtherState Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(OtherStateData%y)) THEN 
         OtherStateData%C_obj%y_Len = 0
         OtherStateData%C_obj%y = C_NULL_PTR
      ELSE
         OtherStateData%C_obj%y_Len = SIZE(OtherStateData%y)
         IF (OtherStateData%C_obj%y_Len > 0) &
            OtherStateData%C_obj%y = C_LOC(OtherStateData%y(lbound(OtherStateData%y,1)))
      END IF
   END IF
   
   ! -- z OtherState Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(OtherStateData%z)) THEN 
         OtherStateData%C_obj%z_Len = 0
         OtherStateData%C_obj%z = C_NULL_PTR
      ELSE
         OtherStateData%C_obj%z_Len = SIZE(OtherStateData%z)
         IF (OtherStateData%C_obj%z_Len > 0) &
            OtherStateData%C_obj%z = C_LOC(OtherStateData%z(lbound(OtherStateData%z,1)))
      END IF
   END IF
   
   ! -- xa OtherState Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(OtherStateData%xa)) THEN 
         OtherStateData%C_obj%xa_Len = 0
         OtherStateData%C_obj%xa = C_NULL_PTR
      ELSE
         OtherStateData%C_obj%xa_Len = SIZE(OtherStateData%xa)
         IF (OtherStateData%C_obj%xa_Len > 0) &
            OtherStateData%C_obj%xa = C_LOC(OtherStateData%xa(lbound(OtherStateData%xa,1)))
      END IF
   END IF
   
   ! -- ya OtherState Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(OtherStateData%ya)) THEN 
         OtherStateData%C_obj%ya_Len = 0
         OtherStateData%C_obj%ya = C_NULL_PTR
      ELSE
         OtherStateData%C_obj%ya_Len = SIZE(OtherStateData%ya)
         IF (OtherStateData%C_obj%ya_Len > 0) &
            OtherStateData%C_obj%ya = C_LOC(OtherStateData%ya(lbound(OtherStateData%ya,1)))
      END IF
   END IF
   
   ! -- za OtherState Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(OtherStateData%za)) THEN 
         OtherStateData%C_obj%za_Len = 0
         OtherStateData%C_obj%za = C_NULL_PTR
      ELSE
         OtherStateData%C_obj%za_Len = SIZE(OtherStateData%za)
         IF (OtherStateData%C_obj%za_Len > 0) &
            OtherStateData%C_obj%za = C_LOC(OtherStateData%za(lbound(OtherStateData%za,1)))
      END IF
   END IF
   
   ! -- Fx_connect OtherState Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(OtherStateData%Fx_connect)) THEN 
         OtherStateData%C_obj%Fx_connect_Len = 0
         OtherStateData%C_obj%Fx_connect = C_NULL_PTR
      ELSE
         OtherStateData%C_obj%Fx_connect_Len = SIZE(OtherStateData%Fx_connect)
         IF (OtherStateData%C_obj%Fx_connect_Len > 0) &
            OtherStateData%C_obj%Fx_connect = C_LOC(OtherStateData%Fx_connect(lbound(OtherStateData%Fx_connect,1)))
      END IF
   END IF
   
   ! -- Fy_connect OtherState Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(OtherStateData%Fy_connect)) THEN 
         OtherStateData%C_obj%Fy_connect_Len = 0
         OtherStateData%C_obj%Fy_connect = C_NULL_PTR
      ELSE
         OtherStateData%C_obj%Fy_connect_Len = SIZE(OtherStateData%Fy_connect)
         IF (OtherStateData%C_obj%Fy_connect_Len > 0) &
            OtherStateData%C_obj%Fy_connect = C_LOC(OtherStateData%Fy_connect(lbound(OtherStateData%Fy_connect,1)))
      END IF
   END IF
   
   ! -- Fz_connect OtherState Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(OtherStateData%Fz_connect)) THEN 
         OtherStateData%C_obj%Fz_connect_Len = 0
         OtherStateData%C_obj%Fz_connect = C_NULL_PTR
      ELSE
         OtherStateData%C_obj%Fz_connect_Len = SIZE(OtherStateData%Fz_connect)
         IF (OtherStateData%C_obj%Fz_connect_Len > 0) &
            OtherStateData%C_obj%Fz_connect = C_LOC(OtherStateData%Fz_connect(lbound(OtherStateData%Fz_connect,1)))
      END IF
   END IF
   
   ! -- Fx_anchor OtherState Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(OtherStateData%Fx_anchor)) THEN 
         OtherStateData%C_obj%Fx_anchor_Len = 0
         OtherStateData%C_obj%Fx_anchor = C_NULL_PTR
      ELSE
         OtherStateData%C_obj%Fx_anchor_Len = SIZE(OtherStateData%Fx_anchor)
         IF (OtherStateData%C_obj%Fx_anchor_Len > 0) &
            OtherStateData%C_obj%Fx_anchor = C_LOC(OtherStateData%Fx_anchor(lbound(OtherStateData%Fx_anchor,1)))
      END IF
   END IF
   
   ! -- Fy_anchor OtherState Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(OtherStateData%Fy_anchor)) THEN 
         OtherStateData%C_obj%Fy_anchor_Len = 0
         OtherStateData%C_obj%Fy_anchor = C_NULL_PTR
      ELSE
         OtherStateData%C_obj%Fy_anchor_Len = SIZE(OtherStateData%Fy_anchor)
         IF (OtherStateData%C_obj%Fy_anchor_Len > 0) &
            OtherStateData%C_obj%Fy_anchor = C_LOC(OtherStateData%Fy_anchor(lbound(OtherStateData%Fy_anchor,1)))
      END IF
   END IF
   
   ! -- Fz_anchor OtherState Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(OtherStateData%Fz_anchor)) THEN 
         OtherStateData%C_obj%Fz_anchor_Len = 0
         OtherStateData%C_obj%Fz_anchor = C_NULL_PTR
      ELSE
         OtherStateData%C_obj%Fz_anchor_Len = SIZE(OtherStateData%Fz_anchor)
         IF (OtherStateData%C_obj%Fz_anchor_Len > 0) &
            OtherStateData%C_obj%Fz_anchor = C_LOC(OtherStateData%Fz_anchor(lbound(OtherStateData%Fz_anchor,1)))
      END IF
   END IF
END SUBROUTINE

subroutine MAP_CopyConstrState(SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg)
   type(MAP_ConstraintStateType), intent(in) :: SrcConstrStateData
   type(MAP_ConstraintStateType), intent(inout) :: DstConstrStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'MAP_CopyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (associated(SrcConstrStateData%H)) then
      LB(1:1) = lbound(SrcConstrStateData%H)
      UB(1:1) = ubound(SrcConstrStateData%H)
      if (.not. associated(DstConstrStateData%H)) then
         allocate(DstConstrStateData%H(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstConstrStateData%H.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstConstrStateData%C_obj%H_Len = size(DstConstrStateData%H)
         if (DstConstrStateData%C_obj%H_Len > 0) &
            DstConstrStateData%C_obj%H = c_loc(DstConstrStateData%H(LB(1)))
      end if
      DstConstrStateData%H = SrcConstrStateData%H
   end if
   if (associated(SrcConstrStateData%V)) then
      LB(1:1) = lbound(SrcConstrStateData%V)
      UB(1:1) = ubound(SrcConstrStateData%V)
      if (.not. associated(DstConstrStateData%V)) then
         allocate(DstConstrStateData%V(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstConstrStateData%V.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstConstrStateData%C_obj%V_Len = size(DstConstrStateData%V)
         if (DstConstrStateData%C_obj%V_Len > 0) &
            DstConstrStateData%C_obj%V = c_loc(DstConstrStateData%V(LB(1)))
      end if
      DstConstrStateData%V = SrcConstrStateData%V
   end if
   if (associated(SrcConstrStateData%x)) then
      LB(1:1) = lbound(SrcConstrStateData%x)
      UB(1:1) = ubound(SrcConstrStateData%x)
      if (.not. associated(DstConstrStateData%x)) then
         allocate(DstConstrStateData%x(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstConstrStateData%x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstConstrStateData%C_obj%x_Len = size(DstConstrStateData%x)
         if (DstConstrStateData%C_obj%x_Len > 0) &
            DstConstrStateData%C_obj%x = c_loc(DstConstrStateData%x(LB(1)))
      end if
      DstConstrStateData%x = SrcConstrStateData%x
   end if
   if (associated(SrcConstrStateData%y)) then
      LB(1:1) = lbound(SrcConstrStateData%y)
      UB(1:1) = ubound(SrcConstrStateData%y)
      if (.not. associated(DstConstrStateData%y)) then
         allocate(DstConstrStateData%y(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstConstrStateData%y.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstConstrStateData%C_obj%y_Len = size(DstConstrStateData%y)
         if (DstConstrStateData%C_obj%y_Len > 0) &
            DstConstrStateData%C_obj%y = c_loc(DstConstrStateData%y(LB(1)))
      end if
      DstConstrStateData%y = SrcConstrStateData%y
   end if
   if (associated(SrcConstrStateData%z)) then
      LB(1:1) = lbound(SrcConstrStateData%z)
      UB(1:1) = ubound(SrcConstrStateData%z)
      if (.not. associated(DstConstrStateData%z)) then
         allocate(DstConstrStateData%z(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstConstrStateData%z.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstConstrStateData%C_obj%z_Len = size(DstConstrStateData%z)
         if (DstConstrStateData%C_obj%z_Len > 0) &
            DstConstrStateData%C_obj%z = c_loc(DstConstrStateData%z(LB(1)))
      end if
      DstConstrStateData%z = SrcConstrStateData%z
   end if
end subroutine

subroutine MAP_DestroyConstrState(ConstrStateData, ErrStat, ErrMsg)
   type(MAP_ConstraintStateType), intent(inout) :: ConstrStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'MAP_DestroyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (associated(ConstrStateData%H)) then
      deallocate(ConstrStateData%H)
      ConstrStateData%H => null()
      ConstrStateData%C_obj%H = c_null_ptr
      ConstrStateData%C_obj%H_Len = 0
   end if
   if (associated(ConstrStateData%V)) then
      deallocate(ConstrStateData%V)
      ConstrStateData%V => null()
      ConstrStateData%C_obj%V = c_null_ptr
      ConstrStateData%C_obj%V_Len = 0
   end if
   if (associated(ConstrStateData%x)) then
      deallocate(ConstrStateData%x)
      ConstrStateData%x => null()
      ConstrStateData%C_obj%x = c_null_ptr
      ConstrStateData%C_obj%x_Len = 0
   end if
   if (associated(ConstrStateData%y)) then
      deallocate(ConstrStateData%y)
      ConstrStateData%y => null()
      ConstrStateData%C_obj%y = c_null_ptr
      ConstrStateData%C_obj%y_Len = 0
   end if
   if (associated(ConstrStateData%z)) then
      deallocate(ConstrStateData%z)
      ConstrStateData%z => null()
      ConstrStateData%C_obj%z = c_null_ptr
      ConstrStateData%C_obj%z_Len = 0
   end if
end subroutine

subroutine MAP_PackConstrState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(MAP_ConstraintStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'MAP_PackConstrState'
   logical         :: PtrInIndex
   if (RF%ErrStat >= AbortErrLev) return
   if (c_associated(InData%C_obj%object)) then
      RF%ErrStat = ErrID_Fatal
      RF%ErrMsg = RoutineName//': C_obj%object cannot be packed.'
      return
   end if
   call RegPackPtr(RF, InData%H)
   call RegPackPtr(RF, InData%V)
   call RegPackPtr(RF, InData%x)
   call RegPackPtr(RF, InData%y)
   call RegPackPtr(RF, InData%z)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MAP_UnPackConstrState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(MAP_ConstraintStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'MAP_UnPackConstrState'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   integer(B8Ki)   :: PtrIdx
   type(c_ptr)     :: Ptr
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackPtr(RF, OutData%H, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%H)) then
      OutData%C_obj%H_Len = size(OutData%H)
      if (OutData%C_obj%H_Len > 0) OutData%C_obj%H = c_loc(OutData%H(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%V, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%V)) then
      OutData%C_obj%V_Len = size(OutData%V)
      if (OutData%C_obj%V_Len > 0) OutData%C_obj%V = c_loc(OutData%V(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%x, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%x)) then
      OutData%C_obj%x_Len = size(OutData%x)
      if (OutData%C_obj%x_Len > 0) OutData%C_obj%x = c_loc(OutData%x(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%y, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%y)) then
      OutData%C_obj%y_Len = size(OutData%y)
      if (OutData%C_obj%y_Len > 0) OutData%C_obj%y = c_loc(OutData%y(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%z, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%z)) then
      OutData%C_obj%z_Len = size(OutData%z)
      if (OutData%C_obj%z_Len > 0) OutData%C_obj%z = c_loc(OutData%z(LB(1)))
   end if
end subroutine

SUBROUTINE MAP_C2Fary_CopyConstrState(ConstrStateData, ErrStat, ErrMsg, SkipPointers)
   TYPE(MAP_ConstraintStateType), INTENT(INOUT) :: ConstrStateData
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
   LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
   ! 
   LOGICAL                        :: SkipPointers_local
   ErrStat = ErrID_None
   ErrMsg  = ""
   
   IF (PRESENT(SkipPointers)) THEN
      SkipPointers_local = SkipPointers
   ELSE
      SkipPointers_local = .false.
   END IF
   
   ! -- H ConstrState Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( ConstrStateData%C_obj%H ) ) THEN
         NULLIFY( ConstrStateData%H )
      ELSE
         CALL C_F_POINTER(ConstrStateData%C_obj%H, ConstrStateData%H, [ConstrStateData%C_obj%H_Len])
      END IF
   END IF
   
   ! -- V ConstrState Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( ConstrStateData%C_obj%V ) ) THEN
         NULLIFY( ConstrStateData%V )
      ELSE
         CALL C_F_POINTER(ConstrStateData%C_obj%V, ConstrStateData%V, [ConstrStateData%C_obj%V_Len])
      END IF
   END IF
   
   ! -- x ConstrState Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( ConstrStateData%C_obj%x ) ) THEN
         NULLIFY( ConstrStateData%x )
      ELSE
         CALL C_F_POINTER(ConstrStateData%C_obj%x, ConstrStateData%x, [ConstrStateData%C_obj%x_Len])
      END IF
   END IF
   
   ! -- y ConstrState Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( ConstrStateData%C_obj%y ) ) THEN
         NULLIFY( ConstrStateData%y )
      ELSE
         CALL C_F_POINTER(ConstrStateData%C_obj%y, ConstrStateData%y, [ConstrStateData%C_obj%y_Len])
      END IF
   END IF
   
   ! -- z ConstrState Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( ConstrStateData%C_obj%z ) ) THEN
         NULLIFY( ConstrStateData%z )
      ELSE
         CALL C_F_POINTER(ConstrStateData%C_obj%z, ConstrStateData%z, [ConstrStateData%C_obj%z_Len])
      END IF
   END IF
END SUBROUTINE

SUBROUTINE MAP_F2C_CopyConstrState( ConstrStateData, ErrStat, ErrMsg, SkipPointers  )
   TYPE(MAP_ConstraintStateType), INTENT(INOUT) :: ConstrStateData
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
   LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
   ! 
   LOGICAL                        :: SkipPointers_local
   ErrStat = ErrID_None
   ErrMsg  = ''
   
   IF (PRESENT(SkipPointers)) THEN
      SkipPointers_local = SkipPointers
   ELSE
      SkipPointers_local = .false.
   END IF
   
   ! -- H ConstrState Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(ConstrStateData%H)) THEN 
         ConstrStateData%C_obj%H_Len = 0
         ConstrStateData%C_obj%H = C_NULL_PTR
      ELSE
         ConstrStateData%C_obj%H_Len = SIZE(ConstrStateData%H)
         IF (ConstrStateData%C_obj%H_Len > 0) &
            ConstrStateData%C_obj%H = C_LOC(ConstrStateData%H(lbound(ConstrStateData%H,1)))
      END IF
   END IF
   
   ! -- V ConstrState Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(ConstrStateData%V)) THEN 
         ConstrStateData%C_obj%V_Len = 0
         ConstrStateData%C_obj%V = C_NULL_PTR
      ELSE
         ConstrStateData%C_obj%V_Len = SIZE(ConstrStateData%V)
         IF (ConstrStateData%C_obj%V_Len > 0) &
            ConstrStateData%C_obj%V = C_LOC(ConstrStateData%V(lbound(ConstrStateData%V,1)))
      END IF
   END IF
   
   ! -- x ConstrState Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(ConstrStateData%x)) THEN 
         ConstrStateData%C_obj%x_Len = 0
         ConstrStateData%C_obj%x = C_NULL_PTR
      ELSE
         ConstrStateData%C_obj%x_Len = SIZE(ConstrStateData%x)
         IF (ConstrStateData%C_obj%x_Len > 0) &
            ConstrStateData%C_obj%x = C_LOC(ConstrStateData%x(lbound(ConstrStateData%x,1)))
      END IF
   END IF
   
   ! -- y ConstrState Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(ConstrStateData%y)) THEN 
         ConstrStateData%C_obj%y_Len = 0
         ConstrStateData%C_obj%y = C_NULL_PTR
      ELSE
         ConstrStateData%C_obj%y_Len = SIZE(ConstrStateData%y)
         IF (ConstrStateData%C_obj%y_Len > 0) &
            ConstrStateData%C_obj%y = C_LOC(ConstrStateData%y(lbound(ConstrStateData%y,1)))
      END IF
   END IF
   
   ! -- z ConstrState Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(ConstrStateData%z)) THEN 
         ConstrStateData%C_obj%z_Len = 0
         ConstrStateData%C_obj%z = C_NULL_PTR
      ELSE
         ConstrStateData%C_obj%z_Len = SIZE(ConstrStateData%z)
         IF (ConstrStateData%C_obj%z_Len > 0) &
            ConstrStateData%C_obj%z = C_LOC(ConstrStateData%z(lbound(ConstrStateData%z,1)))
      END IF
   END IF
END SUBROUTINE

subroutine MAP_CopyParam(SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg)
   type(MAP_ParameterType), intent(in) :: SrcParamData
   type(MAP_ParameterType), intent(inout) :: DstParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'MAP_CopyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstParamData%g = SrcParamData%g
   DstParamData%C_obj%g = SrcParamData%C_obj%g
   DstParamData%depth = SrcParamData%depth
   DstParamData%C_obj%depth = SrcParamData%C_obj%depth
   DstParamData%rho_sea = SrcParamData%rho_sea
   DstParamData%C_obj%rho_sea = SrcParamData%C_obj%rho_sea
   DstParamData%dt = SrcParamData%dt
   DstParamData%C_obj%dt = SrcParamData%C_obj%dt
   DstParamData%InputLines = SrcParamData%InputLines
   DstParamData%InputLineType = SrcParamData%InputLineType
   DstParamData%numOuts = SrcParamData%numOuts
   DstParamData%C_obj%numOuts = SrcParamData%C_obj%numOuts
   call MAP_Fortran_CopyLin_ParamType(SrcParamData%LinParams, DstParamData%LinParams, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine MAP_DestroyParam(ParamData, ErrStat, ErrMsg)
   type(MAP_ParameterType), intent(inout) :: ParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'MAP_DestroyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MAP_Fortran_DestroyLin_ParamType(ParamData%LinParams, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine MAP_PackParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(MAP_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'MAP_PackParam'
   if (RF%ErrStat >= AbortErrLev) return
   if (c_associated(InData%C_obj%object)) then
      RF%ErrStat = ErrID_Fatal
      RF%ErrMsg = RoutineName//': C_obj%object cannot be packed.'
      return
   end if
   call RegPack(RF, InData%g)
   call RegPack(RF, InData%depth)
   call RegPack(RF, InData%rho_sea)
   call RegPack(RF, InData%dt)
   call RegPack(RF, InData%InputLines)
   call RegPack(RF, InData%InputLineType)
   call RegPack(RF, InData%numOuts)
   call MAP_Fortran_PackLin_ParamType(RF, InData%LinParams) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MAP_UnPackParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(MAP_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'MAP_UnPackParam'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%g); if (RegCheckErr(RF, RoutineName)) return
   OutData%C_obj%g = OutData%g
   call RegUnpack(RF, OutData%depth); if (RegCheckErr(RF, RoutineName)) return
   OutData%C_obj%depth = OutData%depth
   call RegUnpack(RF, OutData%rho_sea); if (RegCheckErr(RF, RoutineName)) return
   OutData%C_obj%rho_sea = OutData%rho_sea
   call RegUnpack(RF, OutData%dt); if (RegCheckErr(RF, RoutineName)) return
   OutData%C_obj%dt = OutData%dt
   call RegUnpack(RF, OutData%InputLines); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%InputLineType); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%numOuts); if (RegCheckErr(RF, RoutineName)) return
   OutData%C_obj%numOuts = OutData%numOuts
   call MAP_Fortran_UnpackLin_ParamType(RF, OutData%LinParams) ! LinParams 
end subroutine

SUBROUTINE MAP_C2Fary_CopyParam(ParamData, ErrStat, ErrMsg, SkipPointers)
   TYPE(MAP_ParameterType), INTENT(INOUT) :: ParamData
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
   LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
   ! 
   LOGICAL                        :: SkipPointers_local
   ErrStat = ErrID_None
   ErrMsg  = ""
   
   IF (PRESENT(SkipPointers)) THEN
      SkipPointers_local = SkipPointers
   ELSE
      SkipPointers_local = .false.
   END IF
   ParamData%g = ParamData%C_obj%g
   ParamData%depth = ParamData%C_obj%depth
   ParamData%rho_sea = ParamData%C_obj%rho_sea
   ParamData%dt = ParamData%C_obj%dt
   ParamData%numOuts = ParamData%C_obj%numOuts
END SUBROUTINE

SUBROUTINE MAP_F2C_CopyParam( ParamData, ErrStat, ErrMsg, SkipPointers  )
   TYPE(MAP_ParameterType), INTENT(INOUT) :: ParamData
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
   LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
   ! 
   LOGICAL                        :: SkipPointers_local
   ErrStat = ErrID_None
   ErrMsg  = ''
   
   IF (PRESENT(SkipPointers)) THEN
      SkipPointers_local = SkipPointers
   ELSE
      SkipPointers_local = .false.
   END IF
   ParamData%C_obj%g = ParamData%g
   ParamData%C_obj%depth = ParamData%depth
   ParamData%C_obj%rho_sea = ParamData%rho_sea
   ParamData%C_obj%dt = ParamData%dt
   ParamData%C_obj%numOuts = ParamData%numOuts
END SUBROUTINE

subroutine MAP_CopyInput(SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg)
   type(MAP_InputType), intent(inout) :: SrcInputData
   type(MAP_InputType), intent(inout) :: DstInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'MAP_CopyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (associated(SrcInputData%x)) then
      LB(1:1) = lbound(SrcInputData%x)
      UB(1:1) = ubound(SrcInputData%x)
      if (.not. associated(DstInputData%x)) then
         allocate(DstInputData%x(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstInputData%C_obj%x_Len = size(DstInputData%x)
         if (DstInputData%C_obj%x_Len > 0) &
            DstInputData%C_obj%x = c_loc(DstInputData%x(LB(1)))
      end if
      DstInputData%x = SrcInputData%x
   end if
   if (associated(SrcInputData%y)) then
      LB(1:1) = lbound(SrcInputData%y)
      UB(1:1) = ubound(SrcInputData%y)
      if (.not. associated(DstInputData%y)) then
         allocate(DstInputData%y(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%y.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstInputData%C_obj%y_Len = size(DstInputData%y)
         if (DstInputData%C_obj%y_Len > 0) &
            DstInputData%C_obj%y = c_loc(DstInputData%y(LB(1)))
      end if
      DstInputData%y = SrcInputData%y
   end if
   if (associated(SrcInputData%z)) then
      LB(1:1) = lbound(SrcInputData%z)
      UB(1:1) = ubound(SrcInputData%z)
      if (.not. associated(DstInputData%z)) then
         allocate(DstInputData%z(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%z.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstInputData%C_obj%z_Len = size(DstInputData%z)
         if (DstInputData%C_obj%z_Len > 0) &
            DstInputData%C_obj%z = c_loc(DstInputData%z(LB(1)))
      end if
      DstInputData%z = SrcInputData%z
   end if
   call MeshCopy(SrcInputData%PtFairDisplacement, DstInputData%PtFairDisplacement, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine MAP_DestroyInput(InputData, ErrStat, ErrMsg)
   type(MAP_InputType), intent(inout) :: InputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'MAP_DestroyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (associated(InputData%x)) then
      deallocate(InputData%x)
      InputData%x => null()
      InputData%C_obj%x = c_null_ptr
      InputData%C_obj%x_Len = 0
   end if
   if (associated(InputData%y)) then
      deallocate(InputData%y)
      InputData%y => null()
      InputData%C_obj%y = c_null_ptr
      InputData%C_obj%y_Len = 0
   end if
   if (associated(InputData%z)) then
      deallocate(InputData%z)
      InputData%z => null()
      InputData%C_obj%z = c_null_ptr
      InputData%C_obj%z_Len = 0
   end if
   call MeshDestroy( InputData%PtFairDisplacement, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine MAP_PackInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(MAP_InputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'MAP_PackInput'
   logical         :: PtrInIndex
   if (RF%ErrStat >= AbortErrLev) return
   if (c_associated(InData%C_obj%object)) then
      RF%ErrStat = ErrID_Fatal
      RF%ErrMsg = RoutineName//': C_obj%object cannot be packed.'
      return
   end if
   call RegPackPtr(RF, InData%x)
   call RegPackPtr(RF, InData%y)
   call RegPackPtr(RF, InData%z)
   call MeshPack(RF, InData%PtFairDisplacement) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MAP_UnPackInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(MAP_InputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'MAP_UnPackInput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   integer(B8Ki)   :: PtrIdx
   type(c_ptr)     :: Ptr
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackPtr(RF, OutData%x, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%x)) then
      OutData%C_obj%x_Len = size(OutData%x)
      if (OutData%C_obj%x_Len > 0) OutData%C_obj%x = c_loc(OutData%x(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%y, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%y)) then
      OutData%C_obj%y_Len = size(OutData%y)
      if (OutData%C_obj%y_Len > 0) OutData%C_obj%y = c_loc(OutData%y(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%z, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%z)) then
      OutData%C_obj%z_Len = size(OutData%z)
      if (OutData%C_obj%z_Len > 0) OutData%C_obj%z = c_loc(OutData%z(LB(1)))
   end if
   call MeshUnpack(RF, OutData%PtFairDisplacement) ! PtFairDisplacement 
end subroutine

SUBROUTINE MAP_C2Fary_CopyInput(InputData, ErrStat, ErrMsg, SkipPointers)
   TYPE(MAP_InputType), INTENT(INOUT) :: InputData
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
   LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
   ! 
   LOGICAL                        :: SkipPointers_local
   ErrStat = ErrID_None
   ErrMsg  = ""
   
   IF (PRESENT(SkipPointers)) THEN
      SkipPointers_local = SkipPointers
   ELSE
      SkipPointers_local = .false.
   END IF
   
   ! -- x Input Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( InputData%C_obj%x ) ) THEN
         NULLIFY( InputData%x )
      ELSE
         CALL C_F_POINTER(InputData%C_obj%x, InputData%x, [InputData%C_obj%x_Len])
      END IF
   END IF
   
   ! -- y Input Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( InputData%C_obj%y ) ) THEN
         NULLIFY( InputData%y )
      ELSE
         CALL C_F_POINTER(InputData%C_obj%y, InputData%y, [InputData%C_obj%y_Len])
      END IF
   END IF
   
   ! -- z Input Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( InputData%C_obj%z ) ) THEN
         NULLIFY( InputData%z )
      ELSE
         CALL C_F_POINTER(InputData%C_obj%z, InputData%z, [InputData%C_obj%z_Len])
      END IF
   END IF
END SUBROUTINE

SUBROUTINE MAP_F2C_CopyInput( InputData, ErrStat, ErrMsg, SkipPointers  )
   TYPE(MAP_InputType), INTENT(INOUT) :: InputData
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
   LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
   ! 
   LOGICAL                        :: SkipPointers_local
   ErrStat = ErrID_None
   ErrMsg  = ''
   
   IF (PRESENT(SkipPointers)) THEN
      SkipPointers_local = SkipPointers
   ELSE
      SkipPointers_local = .false.
   END IF
   
   ! -- x Input Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(InputData%x)) THEN 
         InputData%C_obj%x_Len = 0
         InputData%C_obj%x = C_NULL_PTR
      ELSE
         InputData%C_obj%x_Len = SIZE(InputData%x)
         IF (InputData%C_obj%x_Len > 0) &
            InputData%C_obj%x = C_LOC(InputData%x(lbound(InputData%x,1)))
      END IF
   END IF
   
   ! -- y Input Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(InputData%y)) THEN 
         InputData%C_obj%y_Len = 0
         InputData%C_obj%y = C_NULL_PTR
      ELSE
         InputData%C_obj%y_Len = SIZE(InputData%y)
         IF (InputData%C_obj%y_Len > 0) &
            InputData%C_obj%y = C_LOC(InputData%y(lbound(InputData%y,1)))
      END IF
   END IF
   
   ! -- z Input Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(InputData%z)) THEN 
         InputData%C_obj%z_Len = 0
         InputData%C_obj%z = C_NULL_PTR
      ELSE
         InputData%C_obj%z_Len = SIZE(InputData%z)
         IF (InputData%C_obj%z_Len > 0) &
            InputData%C_obj%z = C_LOC(InputData%z(lbound(InputData%z,1)))
      END IF
   END IF
END SUBROUTINE

subroutine MAP_CopyOutput(SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg)
   type(MAP_OutputType), intent(inout) :: SrcOutputData
   type(MAP_OutputType), intent(inout) :: DstOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'MAP_CopyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (associated(SrcOutputData%Fx)) then
      LB(1:1) = lbound(SrcOutputData%Fx)
      UB(1:1) = ubound(SrcOutputData%Fx)
      if (.not. associated(DstOutputData%Fx)) then
         allocate(DstOutputData%Fx(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%Fx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstOutputData%C_obj%Fx_Len = size(DstOutputData%Fx)
         if (DstOutputData%C_obj%Fx_Len > 0) &
            DstOutputData%C_obj%Fx = c_loc(DstOutputData%Fx(LB(1)))
      end if
      DstOutputData%Fx = SrcOutputData%Fx
   end if
   if (associated(SrcOutputData%Fy)) then
      LB(1:1) = lbound(SrcOutputData%Fy)
      UB(1:1) = ubound(SrcOutputData%Fy)
      if (.not. associated(DstOutputData%Fy)) then
         allocate(DstOutputData%Fy(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%Fy.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstOutputData%C_obj%Fy_Len = size(DstOutputData%Fy)
         if (DstOutputData%C_obj%Fy_Len > 0) &
            DstOutputData%C_obj%Fy = c_loc(DstOutputData%Fy(LB(1)))
      end if
      DstOutputData%Fy = SrcOutputData%Fy
   end if
   if (associated(SrcOutputData%Fz)) then
      LB(1:1) = lbound(SrcOutputData%Fz)
      UB(1:1) = ubound(SrcOutputData%Fz)
      if (.not. associated(DstOutputData%Fz)) then
         allocate(DstOutputData%Fz(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%Fz.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstOutputData%C_obj%Fz_Len = size(DstOutputData%Fz)
         if (DstOutputData%C_obj%Fz_Len > 0) &
            DstOutputData%C_obj%Fz = c_loc(DstOutputData%Fz(LB(1)))
      end if
      DstOutputData%Fz = SrcOutputData%Fz
   end if
   if (allocated(SrcOutputData%WriteOutput)) then
      LB(1:1) = lbound(SrcOutputData%WriteOutput)
      UB(1:1) = ubound(SrcOutputData%WriteOutput)
      if (.not. allocated(DstOutputData%WriteOutput)) then
         allocate(DstOutputData%WriteOutput(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%WriteOutput.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%WriteOutput = SrcOutputData%WriteOutput
   end if
   if (associated(SrcOutputData%wrtOutput)) then
      LB(1:1) = lbound(SrcOutputData%wrtOutput)
      UB(1:1) = ubound(SrcOutputData%wrtOutput)
      if (.not. associated(DstOutputData%wrtOutput)) then
         allocate(DstOutputData%wrtOutput(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%wrtOutput.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstOutputData%C_obj%wrtOutput_Len = size(DstOutputData%wrtOutput)
         if (DstOutputData%C_obj%wrtOutput_Len > 0) &
            DstOutputData%C_obj%wrtOutput = c_loc(DstOutputData%wrtOutput(LB(1)))
      end if
      DstOutputData%wrtOutput = SrcOutputData%wrtOutput
   end if
   call MeshCopy(SrcOutputData%ptFairleadLoad, DstOutputData%ptFairleadLoad, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine MAP_DestroyOutput(OutputData, ErrStat, ErrMsg)
   type(MAP_OutputType), intent(inout) :: OutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'MAP_DestroyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (associated(OutputData%Fx)) then
      deallocate(OutputData%Fx)
      OutputData%Fx => null()
      OutputData%C_obj%Fx = c_null_ptr
      OutputData%C_obj%Fx_Len = 0
   end if
   if (associated(OutputData%Fy)) then
      deallocate(OutputData%Fy)
      OutputData%Fy => null()
      OutputData%C_obj%Fy = c_null_ptr
      OutputData%C_obj%Fy_Len = 0
   end if
   if (associated(OutputData%Fz)) then
      deallocate(OutputData%Fz)
      OutputData%Fz => null()
      OutputData%C_obj%Fz = c_null_ptr
      OutputData%C_obj%Fz_Len = 0
   end if
   if (allocated(OutputData%WriteOutput)) then
      deallocate(OutputData%WriteOutput)
   end if
   if (associated(OutputData%wrtOutput)) then
      deallocate(OutputData%wrtOutput)
      OutputData%wrtOutput => null()
      OutputData%C_obj%wrtOutput = c_null_ptr
      OutputData%C_obj%wrtOutput_Len = 0
   end if
   call MeshDestroy( OutputData%ptFairleadLoad, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine MAP_PackOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(MAP_OutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'MAP_PackOutput'
   logical         :: PtrInIndex
   if (RF%ErrStat >= AbortErrLev) return
   if (c_associated(InData%C_obj%object)) then
      RF%ErrStat = ErrID_Fatal
      RF%ErrMsg = RoutineName//': C_obj%object cannot be packed.'
      return
   end if
   call RegPackPtr(RF, InData%Fx)
   call RegPackPtr(RF, InData%Fy)
   call RegPackPtr(RF, InData%Fz)
   call RegPackAlloc(RF, InData%WriteOutput)
   call RegPackPtr(RF, InData%wrtOutput)
   call MeshPack(RF, InData%ptFairleadLoad) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine MAP_UnPackOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(MAP_OutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'MAP_UnPackOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   integer(B8Ki)   :: PtrIdx
   type(c_ptr)     :: Ptr
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackPtr(RF, OutData%Fx, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%Fx)) then
      OutData%C_obj%Fx_Len = size(OutData%Fx)
      if (OutData%C_obj%Fx_Len > 0) OutData%C_obj%Fx = c_loc(OutData%Fx(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%Fy, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%Fy)) then
      OutData%C_obj%Fy_Len = size(OutData%Fy)
      if (OutData%C_obj%Fy_Len > 0) OutData%C_obj%Fy = c_loc(OutData%Fy(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%Fz, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%Fz)) then
      OutData%C_obj%Fz_Len = size(OutData%Fz)
      if (OutData%C_obj%Fz_Len > 0) OutData%C_obj%Fz = c_loc(OutData%Fz(LB(1)))
   end if
   call RegUnpackAlloc(RF, OutData%WriteOutput); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackPtr(RF, OutData%wrtOutput, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%wrtOutput)) then
      OutData%C_obj%wrtOutput_Len = size(OutData%wrtOutput)
      if (OutData%C_obj%wrtOutput_Len > 0) OutData%C_obj%wrtOutput = c_loc(OutData%wrtOutput(LB(1)))
   end if
   call MeshUnpack(RF, OutData%ptFairleadLoad) ! ptFairleadLoad 
end subroutine

SUBROUTINE MAP_C2Fary_CopyOutput(OutputData, ErrStat, ErrMsg, SkipPointers)
   TYPE(MAP_OutputType), INTENT(INOUT) :: OutputData
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
   LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
   ! 
   LOGICAL                        :: SkipPointers_local
   ErrStat = ErrID_None
   ErrMsg  = ""
   
   IF (PRESENT(SkipPointers)) THEN
      SkipPointers_local = SkipPointers
   ELSE
      SkipPointers_local = .false.
   END IF
   
   ! -- Fx Output Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( OutputData%C_obj%Fx ) ) THEN
         NULLIFY( OutputData%Fx )
      ELSE
         CALL C_F_POINTER(OutputData%C_obj%Fx, OutputData%Fx, [OutputData%C_obj%Fx_Len])
      END IF
   END IF
   
   ! -- Fy Output Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( OutputData%C_obj%Fy ) ) THEN
         NULLIFY( OutputData%Fy )
      ELSE
         CALL C_F_POINTER(OutputData%C_obj%Fy, OutputData%Fy, [OutputData%C_obj%Fy_Len])
      END IF
   END IF
   
   ! -- Fz Output Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( OutputData%C_obj%Fz ) ) THEN
         NULLIFY( OutputData%Fz )
      ELSE
         CALL C_F_POINTER(OutputData%C_obj%Fz, OutputData%Fz, [OutputData%C_obj%Fz_Len])
      END IF
   END IF
   
   ! -- wrtOutput Output Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( OutputData%C_obj%wrtOutput ) ) THEN
         NULLIFY( OutputData%wrtOutput )
      ELSE
         CALL C_F_POINTER(OutputData%C_obj%wrtOutput, OutputData%wrtOutput, [OutputData%C_obj%wrtOutput_Len])
      END IF
   END IF
END SUBROUTINE

SUBROUTINE MAP_F2C_CopyOutput( OutputData, ErrStat, ErrMsg, SkipPointers  )
   TYPE(MAP_OutputType), INTENT(INOUT) :: OutputData
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
   LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
   ! 
   LOGICAL                        :: SkipPointers_local
   ErrStat = ErrID_None
   ErrMsg  = ''
   
   IF (PRESENT(SkipPointers)) THEN
      SkipPointers_local = SkipPointers
   ELSE
      SkipPointers_local = .false.
   END IF
   
   ! -- Fx Output Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(OutputData%Fx)) THEN 
         OutputData%C_obj%Fx_Len = 0
         OutputData%C_obj%Fx = C_NULL_PTR
      ELSE
         OutputData%C_obj%Fx_Len = SIZE(OutputData%Fx)
         IF (OutputData%C_obj%Fx_Len > 0) &
            OutputData%C_obj%Fx = C_LOC(OutputData%Fx(lbound(OutputData%Fx,1)))
      END IF
   END IF
   
   ! -- Fy Output Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(OutputData%Fy)) THEN 
         OutputData%C_obj%Fy_Len = 0
         OutputData%C_obj%Fy = C_NULL_PTR
      ELSE
         OutputData%C_obj%Fy_Len = SIZE(OutputData%Fy)
         IF (OutputData%C_obj%Fy_Len > 0) &
            OutputData%C_obj%Fy = C_LOC(OutputData%Fy(lbound(OutputData%Fy,1)))
      END IF
   END IF
   
   ! -- Fz Output Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(OutputData%Fz)) THEN 
         OutputData%C_obj%Fz_Len = 0
         OutputData%C_obj%Fz = C_NULL_PTR
      ELSE
         OutputData%C_obj%Fz_Len = SIZE(OutputData%Fz)
         IF (OutputData%C_obj%Fz_Len > 0) &
            OutputData%C_obj%Fz = C_LOC(OutputData%Fz(lbound(OutputData%Fz,1)))
      END IF
   END IF
   
   ! -- wrtOutput Output Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(OutputData%wrtOutput)) THEN 
         OutputData%C_obj%wrtOutput_Len = 0
         OutputData%C_obj%wrtOutput = C_NULL_PTR
      ELSE
         OutputData%C_obj%wrtOutput_Len = SIZE(OutputData%wrtOutput)
         IF (OutputData%C_obj%wrtOutput_Len > 0) &
            OutputData%C_obj%wrtOutput = C_LOC(OutputData%wrtOutput(lbound(OutputData%wrtOutput,1)))
      END IF
   END IF
END SUBROUTINE

subroutine MAP_Input_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
   ! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(MAP_InputType), intent(inout)  :: u(:) ! Input at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Inputs
   type(MAP_InputType), intent(inout)  :: u_out ! Input at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'MAP_Input_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(u)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(u)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(u) - 1
   select case (order)
   case (0)
      call MAP_CopyInput(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call MAP_Input_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call MAP_Input_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(u) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE MAP_Input_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

   TYPE(MAP_InputType), INTENT(INOUT)  :: u1    ! Input at t1 > t2
   TYPE(MAP_InputType), INTENT(INOUT)  :: u2    ! Input at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Inputs
   TYPE(MAP_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'MAP_Input_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   IF (ASSOCIATED(u_out%x) .AND. ASSOCIATED(u1%x)) THEN
      u_out%x = a1*u1%x + a2*u2%x
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%y) .AND. ASSOCIATED(u1%y)) THEN
      u_out%y = a1*u1%y + a2*u2%y
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%z) .AND. ASSOCIATED(u1%z)) THEN
      u_out%z = a1*u1%z + a2*u2%z
   END IF ! check if allocated
   CALL MeshExtrapInterp1(u1%PtFairDisplacement, u2%PtFairDisplacement, tin, u_out%PtFairDisplacement, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
END SUBROUTINE

SUBROUTINE MAP_Input_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

   TYPE(MAP_InputType), INTENT(INOUT)  :: u1      ! Input at t1 > t2 > t3
   TYPE(MAP_InputType), INTENT(INOUT)  :: u2      ! Input at t2 > t3
   TYPE(MAP_InputType), INTENT(INOUT)  :: u3      ! Input at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Inputs
   TYPE(MAP_InputType), INTENT(INOUT)  :: u_out     ! Input at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'MAP_Input_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   IF (ASSOCIATED(u_out%x) .AND. ASSOCIATED(u1%x)) THEN
      u_out%x = a1*u1%x + a2*u2%x + a3*u3%x
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%y) .AND. ASSOCIATED(u1%y)) THEN
      u_out%y = a1*u1%y + a2*u2%y + a3*u3%y
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%z) .AND. ASSOCIATED(u1%z)) THEN
      u_out%z = a1*u1%z + a2*u2%z + a3*u3%z
   END IF ! check if allocated
   CALL MeshExtrapInterp2(u1%PtFairDisplacement, u2%PtFairDisplacement, u3%PtFairDisplacement, tin, u_out%PtFairDisplacement, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
END SUBROUTINE

subroutine MAP_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
   ! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(MAP_OutputType), intent(inout)  :: y(:) ! Output at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Outputs
   type(MAP_OutputType), intent(inout)  :: y_out ! Output at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'MAP_Output_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(y)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(y)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(y) - 1
   select case (order)
   case (0)
      call MAP_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call MAP_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call MAP_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(y) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE MAP_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

   TYPE(MAP_OutputType), INTENT(INOUT)  :: y1    ! Output at t1 > t2
   TYPE(MAP_OutputType), INTENT(INOUT)  :: y2    ! Output at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
   TYPE(MAP_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'MAP_Output_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   IF (ASSOCIATED(y_out%Fx) .AND. ASSOCIATED(y1%Fx)) THEN
      y_out%Fx = a1*y1%Fx + a2*y2%Fx
   END IF ! check if allocated
   IF (ASSOCIATED(y_out%Fy) .AND. ASSOCIATED(y1%Fy)) THEN
      y_out%Fy = a1*y1%Fy + a2*y2%Fy
   END IF ! check if allocated
   IF (ASSOCIATED(y_out%Fz) .AND. ASSOCIATED(y1%Fz)) THEN
      y_out%Fz = a1*y1%Fz + a2*y2%Fz
   END IF ! check if allocated
   IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
      y_out%WriteOutput = a1*y1%WriteOutput + a2*y2%WriteOutput
   END IF ! check if allocated
   IF (ASSOCIATED(y_out%wrtOutput) .AND. ASSOCIATED(y1%wrtOutput)) THEN
      y_out%wrtOutput = a1*y1%wrtOutput + a2*y2%wrtOutput
   END IF ! check if allocated
   CALL MeshExtrapInterp1(y1%ptFairleadLoad, y2%ptFairleadLoad, tin, y_out%ptFairleadLoad, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
END SUBROUTINE

SUBROUTINE MAP_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

   TYPE(MAP_OutputType), INTENT(INOUT)  :: y1      ! Output at t1 > t2 > t3
   TYPE(MAP_OutputType), INTENT(INOUT)  :: y2      ! Output at t2 > t3
   TYPE(MAP_OutputType), INTENT(INOUT)  :: y3      ! Output at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
   TYPE(MAP_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'MAP_Output_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   IF (ASSOCIATED(y_out%Fx) .AND. ASSOCIATED(y1%Fx)) THEN
      y_out%Fx = a1*y1%Fx + a2*y2%Fx + a3*y3%Fx
   END IF ! check if allocated
   IF (ASSOCIATED(y_out%Fy) .AND. ASSOCIATED(y1%Fy)) THEN
      y_out%Fy = a1*y1%Fy + a2*y2%Fy + a3*y3%Fy
   END IF ! check if allocated
   IF (ASSOCIATED(y_out%Fz) .AND. ASSOCIATED(y1%Fz)) THEN
      y_out%Fz = a1*y1%Fz + a2*y2%Fz + a3*y3%Fz
   END IF ! check if allocated
   IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
      y_out%WriteOutput = a1*y1%WriteOutput + a2*y2%WriteOutput + a3*y3%WriteOutput
   END IF ! check if allocated
   IF (ASSOCIATED(y_out%wrtOutput) .AND. ASSOCIATED(y1%wrtOutput)) THEN
      y_out%wrtOutput = a1*y1%wrtOutput + a2*y2%wrtOutput + a3*y3%wrtOutput
   END IF ! check if allocated
   CALL MeshExtrapInterp2(y1%ptFairleadLoad, y2%ptFairleadLoad, y3%ptFairleadLoad, tin, y_out%ptFairleadLoad, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
END SUBROUTINE
END MODULE MAP_Types
!ENDOFREGISTRYGENERATEDFILE
