!STARTOFREGISTRYGENERATEDFILE 'LinDyn_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! LinDyn_Types
!.................................................................................................................................
! This file is part of LinDyn.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in LinDyn. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE LinDyn_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE NWTC_Library
IMPLICIT NONE
! =========  LD_InitInputType  =======
  TYPE, PUBLIC :: LD_InitInputType
    REAL(DbKi)  :: dt = 0.0_R8Ki      !< time step [s]
    INTEGER(IntKi)  :: IntMethod = 0_IntKi      !< Identifier for integration method (1 [RK4], 2 [AB4], or 3 [ABM4]) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: MM      !< Mass      matrix [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: CC      !< Damping   matrix [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: KK      !< Stiffness matrix [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: x0      !< Degrees of freedom initial conditions - shape nx [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: xd0      !< Velocities initial conditions - shape nx [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: activeDOFs      !< Degrees of freedom that are active - shape nx [-]
    character(8)  :: prefix      !< Prefix for degrees of freedom write outputs [-]
    character(8) , DIMENSION(:), ALLOCATABLE  :: DOFsNames      !< Names of degrees of freedom for write outputs [-]
    character(8) , DIMENSION(:), ALLOCATABLE  :: DOFsUnits      !< Units of degrees of freedom for write outputs [-]
    LOGICAL  :: Linearize = .false.      !< Flag that tells this module if the glue code wants to linearize. [-]
    character(2048)  :: PrescribedMotionFile      !< Input file for prescribed motion [-]
  END TYPE LD_InitInputType
! =======================
! =========  LD_InitOutputType  =======
  TYPE, PUBLIC :: LD_InitOutputType
    TYPE(ProgDesc)  :: Ver      !< This module's name, version, and date [-]
    character(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputHdr      !< The is the list of all output channel header strings (includes all sub-module channels) [-]
    character(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputUnt      !< The is the list of all output channel unit strings (includes all sub-module channels) [-]
    character(LinChanLen) , DIMENSION(:), ALLOCATABLE  :: LinNames_y      !< Names of the outputs used in linearization [-]
    character(LinChanLen) , DIMENSION(:), ALLOCATABLE  :: LinNames_x      !< Names of the continuous states used in linearization [-]
    character(LinChanLen) , DIMENSION(:), ALLOCATABLE  :: LinNames_u      !< Names of the inputs used in linearization [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: RotFrame_y      !< Flag that tells FAST/MBC3 if the outputs used in linearization are in the rotating frame [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: RotFrame_x      !< Flag that tells FAST/MBC3 if the continuous states used in linearization are in the rotating frame [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: RotFrame_u      !< Flag that tells FAST/MBC3 if the inputs used in linearization are in the rotating frame [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: IsLoad_u      !< Flag that tells FAST if the inputs used in linearization are loads (for preconditioning matrix) [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: DerivOrder_x      !< Integer that tells FAST/MBC3 the maximum derivative order of continuous states used in linearization [-]
  END TYPE LD_InitOutputType
! =======================
! =========  LD_ContinuousStateType  =======
  TYPE, PUBLIC :: LD_ContinuousStateType
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: q      !< Continuous states q =(x,xdot) [-]
  END TYPE LD_ContinuousStateType
! =======================
! =========  LD_DiscreteStateType  =======
  TYPE, PUBLIC :: LD_DiscreteStateType
    REAL(SiKi)  :: Dummy = 0.0_R4Ki      !<  [-]
  END TYPE LD_DiscreteStateType
! =======================
! =========  LD_ConstraintStateType  =======
  TYPE, PUBLIC :: LD_ConstraintStateType
    REAL(SiKi)  :: Dummy = 0.0_R4Ki      !<  [-]
  END TYPE LD_ConstraintStateType
! =======================
! =========  LD_OtherStateType  =======
  TYPE, PUBLIC :: LD_OtherStateType
    TYPE(LD_ContinuousStateType) , DIMENSION(:), ALLOCATABLE  :: xdot      !< Previous state derivs for m-step time integrator [-]
    INTEGER(IntKi)  :: n = 0_IntKi      !< Tracks time step for which OtherState was updated last [-]
    INTEGER(IntKi)  :: iMotionInterpLast = 1      !< Last index used to interpolate the presribed motion time series [-]
  END TYPE LD_OtherStateType
! =======================
! =========  LD_MiscVarType  =======
  TYPE, PUBLIC :: LD_MiscVarType
    LOGICAL  :: Dummy = .false.      !<  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: qPrescribed      !< Prescribed motion/velocity/accelerations for all degrees of freedom at a given time [-]
  END TYPE LD_MiscVarType
! =======================
! =========  LD_ParameterType  =======
  TYPE, PUBLIC :: LD_ParameterType
    REAL(DbKi)  :: dt = 0.0_R8Ki      !< time step [s]
    INTEGER(IntKi)  :: IntMethod = 0_IntKi      !< Identifier for integration method (1 [RK4], 2 [AB4], or 3 [ABM4]) [-]
    INTEGER(IntKi)  :: nx = 0_IntKi      !< Number of degrees of freedom (size of M) [-]
    INTEGER(IntKi)  :: nq = 0_IntKi      !< nq=2*nx [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: MM      !< Mass      Matrix - shape (nx x nx) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: CC      !< Damping   Matrix - shape (nx x nx) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: KK      !< Stiffness Matrix - shape (nx x nx) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Minv      !< Inverse of Mass matrix [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: activeDOFs      !< Degrees of freedom that are active [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: AA      !< State matrix A - shape (nq x nq)  [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: BB      !< State matrix B - shape (nq x nx)  [-]
    INTEGER(IntKi)  :: NumOuts = 0_IntKi      !< Number of values in WriteOutput [-]
    TYPE(OutParmType) , DIMENSION(:), ALLOCATABLE  :: OutParam      !< Names and units (and other characteristics) of all requested output parameters [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: OutParamLinIndx      !< Index into WriteOutput for linearization analysis [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PrescribedValues      !< Prescribed motion for all degrees of freedom [-]
  END TYPE LD_ParameterType
! =======================
! =========  LD_InputType  =======
  TYPE, PUBLIC :: LD_InputType
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Fext      !< External loads - shape nx [-]
  END TYPE LD_InputType
! =======================
! =========  LD_OutputType  =======
  TYPE, PUBLIC :: LD_OutputType
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: xdd 
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WriteOutput      !< outputs to be written to a file [-]
  END TYPE LD_OutputType
! =======================
CONTAINS

subroutine LD_CopyInitInput(SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg)
   type(LD_InitInputType), intent(in) :: SrcInitInputData
   type(LD_InitInputType), intent(inout) :: DstInitInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'LD_CopyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInitInputData%dt = SrcInitInputData%dt
   DstInitInputData%IntMethod = SrcInitInputData%IntMethod
   if (allocated(SrcInitInputData%MM)) then
      LB(1:2) = lbound(SrcInitInputData%MM)
      UB(1:2) = ubound(SrcInitInputData%MM)
      if (.not. allocated(DstInitInputData%MM)) then
         allocate(DstInitInputData%MM(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%MM.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%MM = SrcInitInputData%MM
   end if
   if (allocated(SrcInitInputData%CC)) then
      LB(1:2) = lbound(SrcInitInputData%CC)
      UB(1:2) = ubound(SrcInitInputData%CC)
      if (.not. allocated(DstInitInputData%CC)) then
         allocate(DstInitInputData%CC(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%CC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%CC = SrcInitInputData%CC
   end if
   if (allocated(SrcInitInputData%KK)) then
      LB(1:2) = lbound(SrcInitInputData%KK)
      UB(1:2) = ubound(SrcInitInputData%KK)
      if (.not. allocated(DstInitInputData%KK)) then
         allocate(DstInitInputData%KK(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%KK.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%KK = SrcInitInputData%KK
   end if
   if (allocated(SrcInitInputData%x0)) then
      LB(1:1) = lbound(SrcInitInputData%x0)
      UB(1:1) = ubound(SrcInitInputData%x0)
      if (.not. allocated(DstInitInputData%x0)) then
         allocate(DstInitInputData%x0(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%x0.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%x0 = SrcInitInputData%x0
   end if
   if (allocated(SrcInitInputData%xd0)) then
      LB(1:1) = lbound(SrcInitInputData%xd0)
      UB(1:1) = ubound(SrcInitInputData%xd0)
      if (.not. allocated(DstInitInputData%xd0)) then
         allocate(DstInitInputData%xd0(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%xd0.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%xd0 = SrcInitInputData%xd0
   end if
   if (allocated(SrcInitInputData%activeDOFs)) then
      LB(1:1) = lbound(SrcInitInputData%activeDOFs)
      UB(1:1) = ubound(SrcInitInputData%activeDOFs)
      if (.not. allocated(DstInitInputData%activeDOFs)) then
         allocate(DstInitInputData%activeDOFs(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%activeDOFs.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%activeDOFs = SrcInitInputData%activeDOFs
   end if
   DstInitInputData%prefix = SrcInitInputData%prefix
   if (allocated(SrcInitInputData%DOFsNames)) then
      LB(1:1) = lbound(SrcInitInputData%DOFsNames)
      UB(1:1) = ubound(SrcInitInputData%DOFsNames)
      if (.not. allocated(DstInitInputData%DOFsNames)) then
         allocate(DstInitInputData%DOFsNames(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%DOFsNames.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%DOFsNames = SrcInitInputData%DOFsNames
   end if
   if (allocated(SrcInitInputData%DOFsUnits)) then
      LB(1:1) = lbound(SrcInitInputData%DOFsUnits)
      UB(1:1) = ubound(SrcInitInputData%DOFsUnits)
      if (.not. allocated(DstInitInputData%DOFsUnits)) then
         allocate(DstInitInputData%DOFsUnits(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%DOFsUnits.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%DOFsUnits = SrcInitInputData%DOFsUnits
   end if
   DstInitInputData%Linearize = SrcInitInputData%Linearize
   DstInitInputData%PrescribedMotionFile = SrcInitInputData%PrescribedMotionFile
end subroutine

subroutine LD_DestroyInitInput(InitInputData, ErrStat, ErrMsg)
   type(LD_InitInputType), intent(inout) :: InitInputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'LD_DestroyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InitInputData%MM)) then
      deallocate(InitInputData%MM)
   end if
   if (allocated(InitInputData%CC)) then
      deallocate(InitInputData%CC)
   end if
   if (allocated(InitInputData%KK)) then
      deallocate(InitInputData%KK)
   end if
   if (allocated(InitInputData%x0)) then
      deallocate(InitInputData%x0)
   end if
   if (allocated(InitInputData%xd0)) then
      deallocate(InitInputData%xd0)
   end if
   if (allocated(InitInputData%activeDOFs)) then
      deallocate(InitInputData%activeDOFs)
   end if
   if (allocated(InitInputData%DOFsNames)) then
      deallocate(InitInputData%DOFsNames)
   end if
   if (allocated(InitInputData%DOFsUnits)) then
      deallocate(InitInputData%DOFsUnits)
   end if
end subroutine

subroutine LD_PackInitInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(LD_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'LD_PackInitInput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%dt)
   call RegPack(RF, InData%IntMethod)
   call RegPackAlloc(RF, InData%MM)
   call RegPackAlloc(RF, InData%CC)
   call RegPackAlloc(RF, InData%KK)
   call RegPackAlloc(RF, InData%x0)
   call RegPackAlloc(RF, InData%xd0)
   call RegPackAlloc(RF, InData%activeDOFs)
   call RegPack(RF, InData%prefix)
   call RegPackAlloc(RF, InData%DOFsNames)
   call RegPackAlloc(RF, InData%DOFsUnits)
   call RegPack(RF, InData%Linearize)
   call RegPack(RF, InData%PrescribedMotionFile)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine LD_UnPackInitInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(LD_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'LD_UnPackInitInput'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%dt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%IntMethod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%MM); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%CC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%KK); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%x0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%xd0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%activeDOFs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%prefix); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%DOFsNames); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%DOFsUnits); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Linearize); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PrescribedMotionFile); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine LD_CopyInitOutput(SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg)
   type(LD_InitOutputType), intent(in) :: SrcInitOutputData
   type(LD_InitOutputType), intent(inout) :: DstInitOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'LD_CopyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call NWTC_Library_CopyProgDesc(SrcInitOutputData%Ver, DstInitOutputData%Ver, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcInitOutputData%WriteOutputHdr)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputHdr)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputHdr)
      if (.not. allocated(DstInitOutputData%WriteOutputHdr)) then
         allocate(DstInitOutputData%WriteOutputHdr(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputHdr.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputHdr = SrcInitOutputData%WriteOutputHdr
   end if
   if (allocated(SrcInitOutputData%WriteOutputUnt)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputUnt)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputUnt)
      if (.not. allocated(DstInitOutputData%WriteOutputUnt)) then
         allocate(DstInitOutputData%WriteOutputUnt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputUnt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputUnt = SrcInitOutputData%WriteOutputUnt
   end if
   if (allocated(SrcInitOutputData%LinNames_y)) then
      LB(1:1) = lbound(SrcInitOutputData%LinNames_y)
      UB(1:1) = ubound(SrcInitOutputData%LinNames_y)
      if (.not. allocated(DstInitOutputData%LinNames_y)) then
         allocate(DstInitOutputData%LinNames_y(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LinNames_y.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%LinNames_y = SrcInitOutputData%LinNames_y
   end if
   if (allocated(SrcInitOutputData%LinNames_x)) then
      LB(1:1) = lbound(SrcInitOutputData%LinNames_x)
      UB(1:1) = ubound(SrcInitOutputData%LinNames_x)
      if (.not. allocated(DstInitOutputData%LinNames_x)) then
         allocate(DstInitOutputData%LinNames_x(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LinNames_x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%LinNames_x = SrcInitOutputData%LinNames_x
   end if
   if (allocated(SrcInitOutputData%LinNames_u)) then
      LB(1:1) = lbound(SrcInitOutputData%LinNames_u)
      UB(1:1) = ubound(SrcInitOutputData%LinNames_u)
      if (.not. allocated(DstInitOutputData%LinNames_u)) then
         allocate(DstInitOutputData%LinNames_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LinNames_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%LinNames_u = SrcInitOutputData%LinNames_u
   end if
   if (allocated(SrcInitOutputData%RotFrame_y)) then
      LB(1:1) = lbound(SrcInitOutputData%RotFrame_y)
      UB(1:1) = ubound(SrcInitOutputData%RotFrame_y)
      if (.not. allocated(DstInitOutputData%RotFrame_y)) then
         allocate(DstInitOutputData%RotFrame_y(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%RotFrame_y.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%RotFrame_y = SrcInitOutputData%RotFrame_y
   end if
   if (allocated(SrcInitOutputData%RotFrame_x)) then
      LB(1:1) = lbound(SrcInitOutputData%RotFrame_x)
      UB(1:1) = ubound(SrcInitOutputData%RotFrame_x)
      if (.not. allocated(DstInitOutputData%RotFrame_x)) then
         allocate(DstInitOutputData%RotFrame_x(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%RotFrame_x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%RotFrame_x = SrcInitOutputData%RotFrame_x
   end if
   if (allocated(SrcInitOutputData%RotFrame_u)) then
      LB(1:1) = lbound(SrcInitOutputData%RotFrame_u)
      UB(1:1) = ubound(SrcInitOutputData%RotFrame_u)
      if (.not. allocated(DstInitOutputData%RotFrame_u)) then
         allocate(DstInitOutputData%RotFrame_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%RotFrame_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%RotFrame_u = SrcInitOutputData%RotFrame_u
   end if
   if (allocated(SrcInitOutputData%IsLoad_u)) then
      LB(1:1) = lbound(SrcInitOutputData%IsLoad_u)
      UB(1:1) = ubound(SrcInitOutputData%IsLoad_u)
      if (.not. allocated(DstInitOutputData%IsLoad_u)) then
         allocate(DstInitOutputData%IsLoad_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%IsLoad_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%IsLoad_u = SrcInitOutputData%IsLoad_u
   end if
   if (allocated(SrcInitOutputData%DerivOrder_x)) then
      LB(1:1) = lbound(SrcInitOutputData%DerivOrder_x)
      UB(1:1) = ubound(SrcInitOutputData%DerivOrder_x)
      if (.not. allocated(DstInitOutputData%DerivOrder_x)) then
         allocate(DstInitOutputData%DerivOrder_x(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%DerivOrder_x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%DerivOrder_x = SrcInitOutputData%DerivOrder_x
   end if
end subroutine

subroutine LD_DestroyInitOutput(InitOutputData, ErrStat, ErrMsg)
   type(LD_InitOutputType), intent(inout) :: InitOutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'LD_DestroyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call NWTC_Library_DestroyProgDesc(InitOutputData%Ver, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(InitOutputData%WriteOutputHdr)) then
      deallocate(InitOutputData%WriteOutputHdr)
   end if
   if (allocated(InitOutputData%WriteOutputUnt)) then
      deallocate(InitOutputData%WriteOutputUnt)
   end if
   if (allocated(InitOutputData%LinNames_y)) then
      deallocate(InitOutputData%LinNames_y)
   end if
   if (allocated(InitOutputData%LinNames_x)) then
      deallocate(InitOutputData%LinNames_x)
   end if
   if (allocated(InitOutputData%LinNames_u)) then
      deallocate(InitOutputData%LinNames_u)
   end if
   if (allocated(InitOutputData%RotFrame_y)) then
      deallocate(InitOutputData%RotFrame_y)
   end if
   if (allocated(InitOutputData%RotFrame_x)) then
      deallocate(InitOutputData%RotFrame_x)
   end if
   if (allocated(InitOutputData%RotFrame_u)) then
      deallocate(InitOutputData%RotFrame_u)
   end if
   if (allocated(InitOutputData%IsLoad_u)) then
      deallocate(InitOutputData%IsLoad_u)
   end if
   if (allocated(InitOutputData%DerivOrder_x)) then
      deallocate(InitOutputData%DerivOrder_x)
   end if
end subroutine

subroutine LD_PackInitOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(LD_InitOutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'LD_PackInitOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call NWTC_Library_PackProgDesc(RF, InData%Ver) 
   call RegPackAlloc(RF, InData%WriteOutputHdr)
   call RegPackAlloc(RF, InData%WriteOutputUnt)
   call RegPackAlloc(RF, InData%LinNames_y)
   call RegPackAlloc(RF, InData%LinNames_x)
   call RegPackAlloc(RF, InData%LinNames_u)
   call RegPackAlloc(RF, InData%RotFrame_y)
   call RegPackAlloc(RF, InData%RotFrame_x)
   call RegPackAlloc(RF, InData%RotFrame_u)
   call RegPackAlloc(RF, InData%IsLoad_u)
   call RegPackAlloc(RF, InData%DerivOrder_x)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine LD_UnPackInitOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(LD_InitOutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'LD_UnPackInitOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call NWTC_Library_UnpackProgDesc(RF, OutData%Ver) ! Ver 
   call RegUnpackAlloc(RF, OutData%WriteOutputHdr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutputUnt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LinNames_y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LinNames_x); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LinNames_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RotFrame_y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RotFrame_x); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RotFrame_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%IsLoad_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%DerivOrder_x); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine LD_CopyContState(SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg)
   type(LD_ContinuousStateType), intent(in) :: SrcContStateData
   type(LD_ContinuousStateType), intent(inout) :: DstContStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'LD_CopyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcContStateData%q)) then
      LB(1:1) = lbound(SrcContStateData%q)
      UB(1:1) = ubound(SrcContStateData%q)
      if (.not. allocated(DstContStateData%q)) then
         allocate(DstContStateData%q(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstContStateData%q.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstContStateData%q = SrcContStateData%q
   end if
end subroutine

subroutine LD_DestroyContState(ContStateData, ErrStat, ErrMsg)
   type(LD_ContinuousStateType), intent(inout) :: ContStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'LD_DestroyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ContStateData%q)) then
      deallocate(ContStateData%q)
   end if
end subroutine

subroutine LD_PackContState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(LD_ContinuousStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'LD_PackContState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%q)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine LD_UnPackContState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(LD_ContinuousStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'LD_UnPackContState'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%q); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine LD_CopyDiscState(SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg)
   type(LD_DiscreteStateType), intent(in) :: SrcDiscStateData
   type(LD_DiscreteStateType), intent(inout) :: DstDiscStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'LD_CopyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstDiscStateData%Dummy = SrcDiscStateData%Dummy
end subroutine

subroutine LD_DestroyDiscState(DiscStateData, ErrStat, ErrMsg)
   type(LD_DiscreteStateType), intent(inout) :: DiscStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'LD_DestroyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine LD_PackDiscState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(LD_DiscreteStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'LD_PackDiscState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%Dummy)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine LD_UnPackDiscState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(LD_DiscreteStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'LD_UnPackDiscState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%Dummy); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine LD_CopyConstrState(SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg)
   type(LD_ConstraintStateType), intent(in) :: SrcConstrStateData
   type(LD_ConstraintStateType), intent(inout) :: DstConstrStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'LD_CopyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstConstrStateData%Dummy = SrcConstrStateData%Dummy
end subroutine

subroutine LD_DestroyConstrState(ConstrStateData, ErrStat, ErrMsg)
   type(LD_ConstraintStateType), intent(inout) :: ConstrStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'LD_DestroyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine LD_PackConstrState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(LD_ConstraintStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'LD_PackConstrState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%Dummy)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine LD_UnPackConstrState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(LD_ConstraintStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'LD_UnPackConstrState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%Dummy); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine LD_CopyOtherState(SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg)
   type(LD_OtherStateType), intent(in) :: SrcOtherStateData
   type(LD_OtherStateType), intent(inout) :: DstOtherStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'LD_CopyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcOtherStateData%xdot)) then
      LB(1:1) = lbound(SrcOtherStateData%xdot)
      UB(1:1) = ubound(SrcOtherStateData%xdot)
      if (.not. allocated(DstOtherStateData%xdot)) then
         allocate(DstOtherStateData%xdot(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%xdot.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call LD_CopyContState(SrcOtherStateData%xdot(i1), DstOtherStateData%xdot(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstOtherStateData%n = SrcOtherStateData%n
   DstOtherStateData%iMotionInterpLast = SrcOtherStateData%iMotionInterpLast
end subroutine

subroutine LD_DestroyOtherState(OtherStateData, ErrStat, ErrMsg)
   type(LD_OtherStateType), intent(inout) :: OtherStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'LD_DestroyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(OtherStateData%xdot)) then
      LB(1:1) = lbound(OtherStateData%xdot)
      UB(1:1) = ubound(OtherStateData%xdot)
      do i1 = LB(1), UB(1)
         call LD_DestroyContState(OtherStateData%xdot(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(OtherStateData%xdot)
   end if
end subroutine

subroutine LD_PackOtherState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(LD_OtherStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'LD_PackOtherState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%xdot))
   if (allocated(InData%xdot)) then
      call RegPackBounds(RF, 1, lbound(InData%xdot), ubound(InData%xdot))
      LB(1:1) = lbound(InData%xdot)
      UB(1:1) = ubound(InData%xdot)
      do i1 = LB(1), UB(1)
         call LD_PackContState(RF, InData%xdot(i1)) 
      end do
   end if
   call RegPack(RF, InData%n)
   call RegPack(RF, InData%iMotionInterpLast)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine LD_UnPackOtherState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(LD_OtherStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'LD_UnPackOtherState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%xdot)) deallocate(OutData%xdot)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%xdot(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%xdot.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call LD_UnpackContState(RF, OutData%xdot(i1)) ! xdot 
      end do
   end if
   call RegUnpack(RF, OutData%n); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%iMotionInterpLast); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine LD_CopyMisc(SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg)
   type(LD_MiscVarType), intent(in) :: SrcMiscData
   type(LD_MiscVarType), intent(inout) :: DstMiscData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'LD_CopyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstMiscData%Dummy = SrcMiscData%Dummy
   if (allocated(SrcMiscData%qPrescribed)) then
      LB(1:1) = lbound(SrcMiscData%qPrescribed)
      UB(1:1) = ubound(SrcMiscData%qPrescribed)
      if (.not. allocated(DstMiscData%qPrescribed)) then
         allocate(DstMiscData%qPrescribed(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%qPrescribed.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%qPrescribed = SrcMiscData%qPrescribed
   end if
end subroutine

subroutine LD_DestroyMisc(MiscData, ErrStat, ErrMsg)
   type(LD_MiscVarType), intent(inout) :: MiscData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'LD_DestroyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(MiscData%qPrescribed)) then
      deallocate(MiscData%qPrescribed)
   end if
end subroutine

subroutine LD_PackMisc(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(LD_MiscVarType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'LD_PackMisc'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%Dummy)
   call RegPackAlloc(RF, InData%qPrescribed)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine LD_UnPackMisc(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(LD_MiscVarType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'LD_UnPackMisc'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%Dummy); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%qPrescribed); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine LD_CopyParam(SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg)
   type(LD_ParameterType), intent(in) :: SrcParamData
   type(LD_ParameterType), intent(inout) :: DstParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'LD_CopyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstParamData%dt = SrcParamData%dt
   DstParamData%IntMethod = SrcParamData%IntMethod
   DstParamData%nx = SrcParamData%nx
   DstParamData%nq = SrcParamData%nq
   if (allocated(SrcParamData%MM)) then
      LB(1:2) = lbound(SrcParamData%MM)
      UB(1:2) = ubound(SrcParamData%MM)
      if (.not. allocated(DstParamData%MM)) then
         allocate(DstParamData%MM(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%MM.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%MM = SrcParamData%MM
   end if
   if (allocated(SrcParamData%CC)) then
      LB(1:2) = lbound(SrcParamData%CC)
      UB(1:2) = ubound(SrcParamData%CC)
      if (.not. allocated(DstParamData%CC)) then
         allocate(DstParamData%CC(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%CC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%CC = SrcParamData%CC
   end if
   if (allocated(SrcParamData%KK)) then
      LB(1:2) = lbound(SrcParamData%KK)
      UB(1:2) = ubound(SrcParamData%KK)
      if (.not. allocated(DstParamData%KK)) then
         allocate(DstParamData%KK(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%KK.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%KK = SrcParamData%KK
   end if
   if (allocated(SrcParamData%Minv)) then
      LB(1:2) = lbound(SrcParamData%Minv)
      UB(1:2) = ubound(SrcParamData%Minv)
      if (.not. allocated(DstParamData%Minv)) then
         allocate(DstParamData%Minv(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Minv.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Minv = SrcParamData%Minv
   end if
   if (allocated(SrcParamData%activeDOFs)) then
      LB(1:1) = lbound(SrcParamData%activeDOFs)
      UB(1:1) = ubound(SrcParamData%activeDOFs)
      if (.not. allocated(DstParamData%activeDOFs)) then
         allocate(DstParamData%activeDOFs(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%activeDOFs.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%activeDOFs = SrcParamData%activeDOFs
   end if
   if (allocated(SrcParamData%AA)) then
      LB(1:2) = lbound(SrcParamData%AA)
      UB(1:2) = ubound(SrcParamData%AA)
      if (.not. allocated(DstParamData%AA)) then
         allocate(DstParamData%AA(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%AA.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%AA = SrcParamData%AA
   end if
   if (allocated(SrcParamData%BB)) then
      LB(1:2) = lbound(SrcParamData%BB)
      UB(1:2) = ubound(SrcParamData%BB)
      if (.not. allocated(DstParamData%BB)) then
         allocate(DstParamData%BB(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%BB.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%BB = SrcParamData%BB
   end if
   DstParamData%NumOuts = SrcParamData%NumOuts
   if (allocated(SrcParamData%OutParam)) then
      LB(1:1) = lbound(SrcParamData%OutParam)
      UB(1:1) = ubound(SrcParamData%OutParam)
      if (.not. allocated(DstParamData%OutParam)) then
         allocate(DstParamData%OutParam(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%OutParam.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyOutParmType(SrcParamData%OutParam(i1), DstParamData%OutParam(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcParamData%OutParamLinIndx)) then
      LB(1:2) = lbound(SrcParamData%OutParamLinIndx)
      UB(1:2) = ubound(SrcParamData%OutParamLinIndx)
      if (.not. allocated(DstParamData%OutParamLinIndx)) then
         allocate(DstParamData%OutParamLinIndx(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%OutParamLinIndx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%OutParamLinIndx = SrcParamData%OutParamLinIndx
   end if
   if (allocated(SrcParamData%PrescribedValues)) then
      LB(1:2) = lbound(SrcParamData%PrescribedValues)
      UB(1:2) = ubound(SrcParamData%PrescribedValues)
      if (.not. allocated(DstParamData%PrescribedValues)) then
         allocate(DstParamData%PrescribedValues(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%PrescribedValues.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%PrescribedValues = SrcParamData%PrescribedValues
   end if
end subroutine

subroutine LD_DestroyParam(ParamData, ErrStat, ErrMsg)
   type(LD_ParameterType), intent(inout) :: ParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'LD_DestroyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ParamData%MM)) then
      deallocate(ParamData%MM)
   end if
   if (allocated(ParamData%CC)) then
      deallocate(ParamData%CC)
   end if
   if (allocated(ParamData%KK)) then
      deallocate(ParamData%KK)
   end if
   if (allocated(ParamData%Minv)) then
      deallocate(ParamData%Minv)
   end if
   if (allocated(ParamData%activeDOFs)) then
      deallocate(ParamData%activeDOFs)
   end if
   if (allocated(ParamData%AA)) then
      deallocate(ParamData%AA)
   end if
   if (allocated(ParamData%BB)) then
      deallocate(ParamData%BB)
   end if
   if (allocated(ParamData%OutParam)) then
      LB(1:1) = lbound(ParamData%OutParam)
      UB(1:1) = ubound(ParamData%OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyOutParmType(ParamData%OutParam(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%OutParam)
   end if
   if (allocated(ParamData%OutParamLinIndx)) then
      deallocate(ParamData%OutParamLinIndx)
   end if
   if (allocated(ParamData%PrescribedValues)) then
      deallocate(ParamData%PrescribedValues)
   end if
end subroutine

subroutine LD_PackParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(LD_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'LD_PackParam'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%dt)
   call RegPack(RF, InData%IntMethod)
   call RegPack(RF, InData%nx)
   call RegPack(RF, InData%nq)
   call RegPackAlloc(RF, InData%MM)
   call RegPackAlloc(RF, InData%CC)
   call RegPackAlloc(RF, InData%KK)
   call RegPackAlloc(RF, InData%Minv)
   call RegPackAlloc(RF, InData%activeDOFs)
   call RegPackAlloc(RF, InData%AA)
   call RegPackAlloc(RF, InData%BB)
   call RegPack(RF, InData%NumOuts)
   call RegPack(RF, allocated(InData%OutParam))
   if (allocated(InData%OutParam)) then
      call RegPackBounds(RF, 1, lbound(InData%OutParam), ubound(InData%OutParam))
      LB(1:1) = lbound(InData%OutParam)
      UB(1:1) = ubound(InData%OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackOutParmType(RF, InData%OutParam(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%OutParamLinIndx)
   call RegPackAlloc(RF, InData%PrescribedValues)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine LD_UnPackParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(LD_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'LD_UnPackParam'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%dt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%IntMethod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nq); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%MM); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%CC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%KK); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Minv); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%activeDOFs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumOuts); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%OutParam)) deallocate(OutData%OutParam)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%OutParam(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%OutParam.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackOutParmType(RF, OutData%OutParam(i1)) ! OutParam 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%OutParamLinIndx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PrescribedValues); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine LD_CopyInput(SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg)
   type(LD_InputType), intent(in) :: SrcInputData
   type(LD_InputType), intent(inout) :: DstInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'LD_CopyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcInputData%Fext)) then
      LB(1:1) = lbound(SrcInputData%Fext)
      UB(1:1) = ubound(SrcInputData%Fext)
      if (.not. allocated(DstInputData%Fext)) then
         allocate(DstInputData%Fext(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%Fext.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%Fext = SrcInputData%Fext
   end if
end subroutine

subroutine LD_DestroyInput(InputData, ErrStat, ErrMsg)
   type(LD_InputType), intent(inout) :: InputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'LD_DestroyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InputData%Fext)) then
      deallocate(InputData%Fext)
   end if
end subroutine

subroutine LD_PackInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(LD_InputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'LD_PackInput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%Fext)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine LD_UnPackInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(LD_InputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'LD_UnPackInput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%Fext); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine LD_CopyOutput(SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg)
   type(LD_OutputType), intent(in) :: SrcOutputData
   type(LD_OutputType), intent(inout) :: DstOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'LD_CopyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcOutputData%xdd)) then
      LB(1:1) = lbound(SrcOutputData%xdd)
      UB(1:1) = ubound(SrcOutputData%xdd)
      if (.not. allocated(DstOutputData%xdd)) then
         allocate(DstOutputData%xdd(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%xdd.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%xdd = SrcOutputData%xdd
   end if
   if (allocated(SrcOutputData%WriteOutput)) then
      LB(1:1) = lbound(SrcOutputData%WriteOutput)
      UB(1:1) = ubound(SrcOutputData%WriteOutput)
      if (.not. allocated(DstOutputData%WriteOutput)) then
         allocate(DstOutputData%WriteOutput(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%WriteOutput.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%WriteOutput = SrcOutputData%WriteOutput
   end if
end subroutine

subroutine LD_DestroyOutput(OutputData, ErrStat, ErrMsg)
   type(LD_OutputType), intent(inout) :: OutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'LD_DestroyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(OutputData%xdd)) then
      deallocate(OutputData%xdd)
   end if
   if (allocated(OutputData%WriteOutput)) then
      deallocate(OutputData%WriteOutput)
   end if
end subroutine

subroutine LD_PackOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(LD_OutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'LD_PackOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%xdd)
   call RegPackAlloc(RF, InData%WriteOutput)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine LD_UnPackOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(LD_OutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'LD_UnPackOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%xdd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutput); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine LD_Input_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
   ! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(LD_InputType), intent(in)  :: u(:) ! Input at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Inputs
   type(LD_InputType), intent(inout)  :: u_out ! Input at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'LD_Input_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(u)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(u)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(u) - 1
   select case (order)
   case (0)
      call LD_CopyInput(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call LD_Input_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call LD_Input_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(u) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE LD_Input_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

   TYPE(LD_InputType), INTENT(IN)  :: u1    ! Input at t1 > t2
   TYPE(LD_InputType), INTENT(IN)  :: u2    ! Input at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Inputs
   TYPE(LD_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'LD_Input_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   IF (ALLOCATED(u_out%Fext) .AND. ALLOCATED(u1%Fext)) THEN
      u_out%Fext = a1*u1%Fext + a2*u2%Fext
   END IF ! check if allocated
END SUBROUTINE

SUBROUTINE LD_Input_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

   TYPE(LD_InputType), INTENT(IN)  :: u1      ! Input at t1 > t2 > t3
   TYPE(LD_InputType), INTENT(IN)  :: u2      ! Input at t2 > t3
   TYPE(LD_InputType), INTENT(IN)  :: u3      ! Input at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Inputs
   TYPE(LD_InputType), INTENT(INOUT)  :: u_out     ! Input at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'LD_Input_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   IF (ALLOCATED(u_out%Fext) .AND. ALLOCATED(u1%Fext)) THEN
      u_out%Fext = a1*u1%Fext + a2*u2%Fext + a3*u3%Fext
   END IF ! check if allocated
END SUBROUTINE

subroutine LD_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
   ! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(LD_OutputType), intent(in)  :: y(:) ! Output at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Outputs
   type(LD_OutputType), intent(inout)  :: y_out ! Output at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'LD_Output_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(y)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(y)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(y) - 1
   select case (order)
   case (0)
      call LD_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call LD_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call LD_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(y) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE LD_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

   TYPE(LD_OutputType), INTENT(IN)  :: y1    ! Output at t1 > t2
   TYPE(LD_OutputType), INTENT(IN)  :: y2    ! Output at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
   TYPE(LD_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'LD_Output_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   IF (ALLOCATED(y_out%xdd) .AND. ALLOCATED(y1%xdd)) THEN
      y_out%xdd = a1*y1%xdd + a2*y2%xdd
   END IF ! check if allocated
   IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
      y_out%WriteOutput = a1*y1%WriteOutput + a2*y2%WriteOutput
   END IF ! check if allocated
END SUBROUTINE

SUBROUTINE LD_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

   TYPE(LD_OutputType), INTENT(IN)  :: y1      ! Output at t1 > t2 > t3
   TYPE(LD_OutputType), INTENT(IN)  :: y2      ! Output at t2 > t3
   TYPE(LD_OutputType), INTENT(IN)  :: y3      ! Output at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
   TYPE(LD_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'LD_Output_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   IF (ALLOCATED(y_out%xdd) .AND. ALLOCATED(y1%xdd)) THEN
      y_out%xdd = a1*y1%xdd + a2*y2%xdd + a3*y3%xdd
   END IF ! check if allocated
   IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
      y_out%WriteOutput = a1*y1%WriteOutput + a2*y2%WriteOutput + a3*y3%WriteOutput
   END IF ! check if allocated
END SUBROUTINE
END MODULE LinDyn_Types
!ENDOFREGISTRYGENERATEDFILE
