!STARTOFREGISTRYGENERATEDFILE 'Lidar_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! Lidar_Types
!.................................................................................................................................
! This file is part of Lidar.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in Lidar. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE Lidar_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE NWTC_Library
IMPLICIT NONE
    INTEGER(IntKi), PUBLIC, PARAMETER  :: SensorType_None = 0
    INTEGER(IntKi), PUBLIC, PARAMETER  :: SensorType_SinglePoint = 1
    INTEGER(IntKi), PUBLIC, PARAMETER  :: SensorType_ContinuousLidar = 2
    INTEGER(IntKi), PUBLIC, PARAMETER  :: SensorType_PulsedLidar = 3
! =========  Lidar_ParameterType  =======
  TYPE, PUBLIC :: Lidar_ParameterType
    INTEGER(IntKi)  :: NumPulseGate = 0_IntKi      !< the number of range gates to return wind speeds at; pulsed lidar only [-]
    REAL(ReKi) , DIMENSION(1:3)  :: RotorApexOffsetPos = 0.0_ReKi      !< position of the lidar unit relative to the rotor apex of rotation [m]
    REAL(ReKi)  :: RayRangeSq = 0.0_ReKi      !< Rayleigh Range Squared [-]
    REAL(ReKi)  :: SpatialRes = 0.0_ReKi      !< spatial sampling distance of weighting function (1/2)*(avg ws)*dt [-]
    INTEGER(IntKi)  :: SensorType = 0_IntKi      !< SensorType_* parameter [-]
    REAL(ReKi)  :: WtFnTrunc = 0.0_ReKi      !< Percentage of the peak value at which to truncate weighting function [-]
    REAL(ReKi)  :: PulseRangeOne = 0.0_ReKi      !< the range to the closest range gate [m]
    REAL(ReKi)  :: DeltaR = 0.0_ReKi      !< the FWHM width of the pulse [-]
    REAL(ReKi)  :: r_p = 0.0_ReKi 
    LOGICAL  :: LidRadialVel = .false.      !< TRUE => return radial component, FALSE => return 'x' direction estimate [-]
    REAL(ReKi)  :: DisplacementLidarX = 0.0_ReKi      !< Displacement of the lidar system from the focal measurement point [m]
    REAL(ReKi)  :: DisplacementLidarY = 0.0_ReKi      !< Displacement of the lidar system from the focal measurement point [m]
    REAL(ReKi)  :: DisplacementLidarZ = 0.0_ReKi      !< Displacement of the lidar system from the focal measurement point [m]
    INTEGER(IntKi)  :: NumBeam = 0_IntKi      !< Number of lidar beams [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: FocalDistanceX      !< LIDAR LOS focal distance co-ordinates in the x direction [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: FocalDistanceY      !< LIDAR LOS focal distance co-ordinates in the y direction [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: FocalDistanceZ      !< LIDAR LOS focal distance co-ordinates in the z direction [m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: MsrPosition      !< Position of the desired wind measurement, per beam (was XMsrPt, YMsrPt, ZMsrPt) [m]
    REAL(ReKi)  :: PulseSpacing = 0.0_ReKi      !< Distance between range gates [m]
    REAL(ReKi)  :: URefLid = 0.0_ReKi      !< Reference average wind speed for the lidar [m/s]
    INTEGER(IntKi)  :: ConsiderHubMotion = 0_IntKi      !< Whether to consider the hub motion's impact on the Lidar measurement [-]
    REAL(ReKi)  :: MeasurementInterval = 0.0_ReKi      !< Time steps between lidar measurements [s]
    REAL(ReKi) , DIMENSION(1:3)  :: LidPosition = 0.0_ReKi      !< Position of the Lidar unit (was XLidPt, YLidPt, ZLidPt) [m]
    INTEGER(IntKi)  :: NumMeasurements = 0      !< Number of measurements output [-]
  END TYPE Lidar_ParameterType
! =======================
! =========  Lidar_InputType  =======
  TYPE, PUBLIC :: Lidar_InputType
    REAL(ReKi)  :: PulseLidEl = 0.0_ReKi      !< the angle off of the x axis that the lidar is aimed (0 would be staring directly upwind, pi/2 would be staring perpendicular to the x axis) [-]
    REAL(ReKi)  :: PulseLidAz = 0.0_ReKi      !< the angle in the YZ plane that the lidar is staring (if PulseLidEl is set to pi/2, then 0 would be aligned with the positive z axis, pi/2 would be aligned with the positive y axis) [-]
    REAL(ReKi)  :: HubDisplacementX = 0.0_ReKi      !< X direction hub displacement of the lidar (from ElastoDyn) [m]
    REAL(ReKi)  :: HubDisplacementY = 0.0_ReKi      !< Y direction hub displacement of the lidar (from ElastoDyn) [m]
    REAL(ReKi)  :: HubDisplacementZ = 0.0_ReKi      !< Z direction hub displacement of the lidar (from ElastoDyn) [m]
  END TYPE Lidar_InputType
! =======================
! =========  Lidar_OutputType  =======
  TYPE, PUBLIC :: Lidar_OutputType
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LidSpeed      !< Speed detected by Lidar at measurement point (range gates for pulsed lidar) [m/s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WtTrunc      !< Contains the fraction of the peak that the weighting function was truncated at (for when truncated early). [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: MsrPositionsX      !< Lidar X direction measurement points [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: MsrPositionsY      !< Lidar Y direction measurement points [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: MsrPositionsZ      !< Lidar Z direction measurement points [m]
  END TYPE Lidar_OutputType
! =======================
CONTAINS

subroutine Lidar_CopyParam(SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg)
   type(Lidar_ParameterType), intent(in) :: SrcParamData
   type(Lidar_ParameterType), intent(inout) :: DstParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'Lidar_CopyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstParamData%NumPulseGate = SrcParamData%NumPulseGate
   DstParamData%RotorApexOffsetPos = SrcParamData%RotorApexOffsetPos
   DstParamData%RayRangeSq = SrcParamData%RayRangeSq
   DstParamData%SpatialRes = SrcParamData%SpatialRes
   DstParamData%SensorType = SrcParamData%SensorType
   DstParamData%WtFnTrunc = SrcParamData%WtFnTrunc
   DstParamData%PulseRangeOne = SrcParamData%PulseRangeOne
   DstParamData%DeltaR = SrcParamData%DeltaR
   DstParamData%r_p = SrcParamData%r_p
   DstParamData%LidRadialVel = SrcParamData%LidRadialVel
   DstParamData%DisplacementLidarX = SrcParamData%DisplacementLidarX
   DstParamData%DisplacementLidarY = SrcParamData%DisplacementLidarY
   DstParamData%DisplacementLidarZ = SrcParamData%DisplacementLidarZ
   DstParamData%NumBeam = SrcParamData%NumBeam
   if (allocated(SrcParamData%FocalDistanceX)) then
      LB(1:1) = lbound(SrcParamData%FocalDistanceX)
      UB(1:1) = ubound(SrcParamData%FocalDistanceX)
      if (.not. allocated(DstParamData%FocalDistanceX)) then
         allocate(DstParamData%FocalDistanceX(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%FocalDistanceX.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%FocalDistanceX = SrcParamData%FocalDistanceX
   end if
   if (allocated(SrcParamData%FocalDistanceY)) then
      LB(1:1) = lbound(SrcParamData%FocalDistanceY)
      UB(1:1) = ubound(SrcParamData%FocalDistanceY)
      if (.not. allocated(DstParamData%FocalDistanceY)) then
         allocate(DstParamData%FocalDistanceY(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%FocalDistanceY.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%FocalDistanceY = SrcParamData%FocalDistanceY
   end if
   if (allocated(SrcParamData%FocalDistanceZ)) then
      LB(1:1) = lbound(SrcParamData%FocalDistanceZ)
      UB(1:1) = ubound(SrcParamData%FocalDistanceZ)
      if (.not. allocated(DstParamData%FocalDistanceZ)) then
         allocate(DstParamData%FocalDistanceZ(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%FocalDistanceZ.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%FocalDistanceZ = SrcParamData%FocalDistanceZ
   end if
   if (allocated(SrcParamData%MsrPosition)) then
      LB(1:2) = lbound(SrcParamData%MsrPosition)
      UB(1:2) = ubound(SrcParamData%MsrPosition)
      if (.not. allocated(DstParamData%MsrPosition)) then
         allocate(DstParamData%MsrPosition(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%MsrPosition.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%MsrPosition = SrcParamData%MsrPosition
   end if
   DstParamData%PulseSpacing = SrcParamData%PulseSpacing
   DstParamData%URefLid = SrcParamData%URefLid
   DstParamData%ConsiderHubMotion = SrcParamData%ConsiderHubMotion
   DstParamData%MeasurementInterval = SrcParamData%MeasurementInterval
   DstParamData%LidPosition = SrcParamData%LidPosition
   DstParamData%NumMeasurements = SrcParamData%NumMeasurements
end subroutine

subroutine Lidar_DestroyParam(ParamData, ErrStat, ErrMsg)
   type(Lidar_ParameterType), intent(inout) :: ParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Lidar_DestroyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ParamData%FocalDistanceX)) then
      deallocate(ParamData%FocalDistanceX)
   end if
   if (allocated(ParamData%FocalDistanceY)) then
      deallocate(ParamData%FocalDistanceY)
   end if
   if (allocated(ParamData%FocalDistanceZ)) then
      deallocate(ParamData%FocalDistanceZ)
   end if
   if (allocated(ParamData%MsrPosition)) then
      deallocate(ParamData%MsrPosition)
   end if
end subroutine

subroutine Lidar_PackParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Lidar_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Lidar_PackParam'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%NumPulseGate)
   call RegPack(RF, InData%RotorApexOffsetPos)
   call RegPack(RF, InData%RayRangeSq)
   call RegPack(RF, InData%SpatialRes)
   call RegPack(RF, InData%SensorType)
   call RegPack(RF, InData%WtFnTrunc)
   call RegPack(RF, InData%PulseRangeOne)
   call RegPack(RF, InData%DeltaR)
   call RegPack(RF, InData%r_p)
   call RegPack(RF, InData%LidRadialVel)
   call RegPack(RF, InData%DisplacementLidarX)
   call RegPack(RF, InData%DisplacementLidarY)
   call RegPack(RF, InData%DisplacementLidarZ)
   call RegPack(RF, InData%NumBeam)
   call RegPackAlloc(RF, InData%FocalDistanceX)
   call RegPackAlloc(RF, InData%FocalDistanceY)
   call RegPackAlloc(RF, InData%FocalDistanceZ)
   call RegPackAlloc(RF, InData%MsrPosition)
   call RegPack(RF, InData%PulseSpacing)
   call RegPack(RF, InData%URefLid)
   call RegPack(RF, InData%ConsiderHubMotion)
   call RegPack(RF, InData%MeasurementInterval)
   call RegPack(RF, InData%LidPosition)
   call RegPack(RF, InData%NumMeasurements)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Lidar_UnPackParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Lidar_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Lidar_UnPackParam'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%NumPulseGate); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RotorApexOffsetPos); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RayRangeSq); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SpatialRes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SensorType); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WtFnTrunc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PulseRangeOne); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DeltaR); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%r_p); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LidRadialVel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DisplacementLidarX); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DisplacementLidarY); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DisplacementLidarZ); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumBeam); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%FocalDistanceX); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%FocalDistanceY); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%FocalDistanceZ); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%MsrPosition); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PulseSpacing); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%URefLid); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ConsiderHubMotion); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MeasurementInterval); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LidPosition); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumMeasurements); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Lidar_CopyInput(SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg)
   type(Lidar_InputType), intent(in) :: SrcInputData
   type(Lidar_InputType), intent(inout) :: DstInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Lidar_CopyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInputData%PulseLidEl = SrcInputData%PulseLidEl
   DstInputData%PulseLidAz = SrcInputData%PulseLidAz
   DstInputData%HubDisplacementX = SrcInputData%HubDisplacementX
   DstInputData%HubDisplacementY = SrcInputData%HubDisplacementY
   DstInputData%HubDisplacementZ = SrcInputData%HubDisplacementZ
end subroutine

subroutine Lidar_DestroyInput(InputData, ErrStat, ErrMsg)
   type(Lidar_InputType), intent(inout) :: InputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Lidar_DestroyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine Lidar_PackInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Lidar_InputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Lidar_PackInput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%PulseLidEl)
   call RegPack(RF, InData%PulseLidAz)
   call RegPack(RF, InData%HubDisplacementX)
   call RegPack(RF, InData%HubDisplacementY)
   call RegPack(RF, InData%HubDisplacementZ)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Lidar_UnPackInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Lidar_InputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Lidar_UnPackInput'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%PulseLidEl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PulseLidAz); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HubDisplacementX); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HubDisplacementY); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HubDisplacementZ); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Lidar_CopyOutput(SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg)
   type(Lidar_OutputType), intent(in) :: SrcOutputData
   type(Lidar_OutputType), intent(inout) :: DstOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'Lidar_CopyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcOutputData%LidSpeed)) then
      LB(1:1) = lbound(SrcOutputData%LidSpeed)
      UB(1:1) = ubound(SrcOutputData%LidSpeed)
      if (.not. allocated(DstOutputData%LidSpeed)) then
         allocate(DstOutputData%LidSpeed(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%LidSpeed.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%LidSpeed = SrcOutputData%LidSpeed
   end if
   if (allocated(SrcOutputData%WtTrunc)) then
      LB(1:1) = lbound(SrcOutputData%WtTrunc)
      UB(1:1) = ubound(SrcOutputData%WtTrunc)
      if (.not. allocated(DstOutputData%WtTrunc)) then
         allocate(DstOutputData%WtTrunc(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%WtTrunc.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%WtTrunc = SrcOutputData%WtTrunc
   end if
   if (allocated(SrcOutputData%MsrPositionsX)) then
      LB(1:1) = lbound(SrcOutputData%MsrPositionsX)
      UB(1:1) = ubound(SrcOutputData%MsrPositionsX)
      if (.not. allocated(DstOutputData%MsrPositionsX)) then
         allocate(DstOutputData%MsrPositionsX(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%MsrPositionsX.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%MsrPositionsX = SrcOutputData%MsrPositionsX
   end if
   if (allocated(SrcOutputData%MsrPositionsY)) then
      LB(1:1) = lbound(SrcOutputData%MsrPositionsY)
      UB(1:1) = ubound(SrcOutputData%MsrPositionsY)
      if (.not. allocated(DstOutputData%MsrPositionsY)) then
         allocate(DstOutputData%MsrPositionsY(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%MsrPositionsY.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%MsrPositionsY = SrcOutputData%MsrPositionsY
   end if
   if (allocated(SrcOutputData%MsrPositionsZ)) then
      LB(1:1) = lbound(SrcOutputData%MsrPositionsZ)
      UB(1:1) = ubound(SrcOutputData%MsrPositionsZ)
      if (.not. allocated(DstOutputData%MsrPositionsZ)) then
         allocate(DstOutputData%MsrPositionsZ(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%MsrPositionsZ.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%MsrPositionsZ = SrcOutputData%MsrPositionsZ
   end if
end subroutine

subroutine Lidar_DestroyOutput(OutputData, ErrStat, ErrMsg)
   type(Lidar_OutputType), intent(inout) :: OutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Lidar_DestroyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(OutputData%LidSpeed)) then
      deallocate(OutputData%LidSpeed)
   end if
   if (allocated(OutputData%WtTrunc)) then
      deallocate(OutputData%WtTrunc)
   end if
   if (allocated(OutputData%MsrPositionsX)) then
      deallocate(OutputData%MsrPositionsX)
   end if
   if (allocated(OutputData%MsrPositionsY)) then
      deallocate(OutputData%MsrPositionsY)
   end if
   if (allocated(OutputData%MsrPositionsZ)) then
      deallocate(OutputData%MsrPositionsZ)
   end if
end subroutine

subroutine Lidar_PackOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Lidar_OutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Lidar_PackOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%LidSpeed)
   call RegPackAlloc(RF, InData%WtTrunc)
   call RegPackAlloc(RF, InData%MsrPositionsX)
   call RegPackAlloc(RF, InData%MsrPositionsY)
   call RegPackAlloc(RF, InData%MsrPositionsZ)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Lidar_UnPackOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Lidar_OutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Lidar_UnPackOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%LidSpeed); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WtTrunc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%MsrPositionsX); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%MsrPositionsY); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%MsrPositionsZ); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Lidar_Input_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
   ! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(Lidar_InputType), intent(in)  :: u(:) ! Input at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Inputs
   type(Lidar_InputType), intent(inout)  :: u_out ! Input at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'Lidar_Input_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(u)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(u)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(u) - 1
   select case (order)
   case (0)
      call Lidar_CopyInput(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call Lidar_Input_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call Lidar_Input_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(u) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE Lidar_Input_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

   TYPE(Lidar_InputType), INTENT(IN)  :: u1    ! Input at t1 > t2
   TYPE(Lidar_InputType), INTENT(IN)  :: u2    ! Input at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Inputs
   TYPE(Lidar_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'Lidar_Input_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   u_out%PulseLidEl = a1*u1%PulseLidEl + a2*u2%PulseLidEl
   u_out%PulseLidAz = a1*u1%PulseLidAz + a2*u2%PulseLidAz
   u_out%HubDisplacementX = a1*u1%HubDisplacementX + a2*u2%HubDisplacementX
   u_out%HubDisplacementY = a1*u1%HubDisplacementY + a2*u2%HubDisplacementY
   u_out%HubDisplacementZ = a1*u1%HubDisplacementZ + a2*u2%HubDisplacementZ
END SUBROUTINE

SUBROUTINE Lidar_Input_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

   TYPE(Lidar_InputType), INTENT(IN)  :: u1      ! Input at t1 > t2 > t3
   TYPE(Lidar_InputType), INTENT(IN)  :: u2      ! Input at t2 > t3
   TYPE(Lidar_InputType), INTENT(IN)  :: u3      ! Input at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Inputs
   TYPE(Lidar_InputType), INTENT(INOUT)  :: u_out     ! Input at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'Lidar_Input_ExtrapInterp2'
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   u_out%PulseLidEl = a1*u1%PulseLidEl + a2*u2%PulseLidEl + a3*u3%PulseLidEl
   u_out%PulseLidAz = a1*u1%PulseLidAz + a2*u2%PulseLidAz + a3*u3%PulseLidAz
   u_out%HubDisplacementX = a1*u1%HubDisplacementX + a2*u2%HubDisplacementX + a3*u3%HubDisplacementX
   u_out%HubDisplacementY = a1*u1%HubDisplacementY + a2*u2%HubDisplacementY + a3*u3%HubDisplacementY
   u_out%HubDisplacementZ = a1*u1%HubDisplacementZ + a2*u2%HubDisplacementZ + a3*u3%HubDisplacementZ
END SUBROUTINE

subroutine Lidar_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
   ! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(Lidar_OutputType), intent(in)  :: y(:) ! Output at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Outputs
   type(Lidar_OutputType), intent(inout)  :: y_out ! Output at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'Lidar_Output_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(y)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(y)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(y) - 1
   select case (order)
   case (0)
      call Lidar_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call Lidar_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call Lidar_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(y) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE Lidar_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

   TYPE(Lidar_OutputType), INTENT(IN)  :: y1    ! Output at t1 > t2
   TYPE(Lidar_OutputType), INTENT(IN)  :: y2    ! Output at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
   TYPE(Lidar_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'Lidar_Output_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   IF (ALLOCATED(y_out%LidSpeed) .AND. ALLOCATED(y1%LidSpeed)) THEN
      y_out%LidSpeed = a1*y1%LidSpeed + a2*y2%LidSpeed
   END IF ! check if allocated
   IF (ALLOCATED(y_out%WtTrunc) .AND. ALLOCATED(y1%WtTrunc)) THEN
      y_out%WtTrunc = a1*y1%WtTrunc + a2*y2%WtTrunc
   END IF ! check if allocated
   IF (ALLOCATED(y_out%MsrPositionsX) .AND. ALLOCATED(y1%MsrPositionsX)) THEN
      y_out%MsrPositionsX = a1*y1%MsrPositionsX + a2*y2%MsrPositionsX
   END IF ! check if allocated
   IF (ALLOCATED(y_out%MsrPositionsY) .AND. ALLOCATED(y1%MsrPositionsY)) THEN
      y_out%MsrPositionsY = a1*y1%MsrPositionsY + a2*y2%MsrPositionsY
   END IF ! check if allocated
   IF (ALLOCATED(y_out%MsrPositionsZ) .AND. ALLOCATED(y1%MsrPositionsZ)) THEN
      y_out%MsrPositionsZ = a1*y1%MsrPositionsZ + a2*y2%MsrPositionsZ
   END IF ! check if allocated
END SUBROUTINE

SUBROUTINE Lidar_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

   TYPE(Lidar_OutputType), INTENT(IN)  :: y1      ! Output at t1 > t2 > t3
   TYPE(Lidar_OutputType), INTENT(IN)  :: y2      ! Output at t2 > t3
   TYPE(Lidar_OutputType), INTENT(IN)  :: y3      ! Output at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
   TYPE(Lidar_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'Lidar_Output_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   IF (ALLOCATED(y_out%LidSpeed) .AND. ALLOCATED(y1%LidSpeed)) THEN
      y_out%LidSpeed = a1*y1%LidSpeed + a2*y2%LidSpeed + a3*y3%LidSpeed
   END IF ! check if allocated
   IF (ALLOCATED(y_out%WtTrunc) .AND. ALLOCATED(y1%WtTrunc)) THEN
      y_out%WtTrunc = a1*y1%WtTrunc + a2*y2%WtTrunc + a3*y3%WtTrunc
   END IF ! check if allocated
   IF (ALLOCATED(y_out%MsrPositionsX) .AND. ALLOCATED(y1%MsrPositionsX)) THEN
      y_out%MsrPositionsX = a1*y1%MsrPositionsX + a2*y2%MsrPositionsX + a3*y3%MsrPositionsX
   END IF ! check if allocated
   IF (ALLOCATED(y_out%MsrPositionsY) .AND. ALLOCATED(y1%MsrPositionsY)) THEN
      y_out%MsrPositionsY = a1*y1%MsrPositionsY + a2*y2%MsrPositionsY + a3*y3%MsrPositionsY
   END IF ! check if allocated
   IF (ALLOCATED(y_out%MsrPositionsZ) .AND. ALLOCATED(y1%MsrPositionsZ)) THEN
      y_out%MsrPositionsZ = a1*y1%MsrPositionsZ + a2*y2%MsrPositionsZ + a3*y3%MsrPositionsZ
   END IF ! check if allocated
END SUBROUTINE
END MODULE Lidar_Types
!ENDOFREGISTRYGENERATEDFILE
