!STARTOFREGISTRYGENERATEDFILE 'InflowWind_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! InflowWind_Types
!.................................................................................................................................
! This file is part of InflowWind.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in InflowWind. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE InflowWind_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE IfW_FlowField_Types
USE InflowWind_IO_Types
USE Lidar_Types
USE NWTC_Library
IMPLICIT NONE
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Undef_WindNumber = 0      ! This is the code for an undefined WindFileType [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Steady_WindNumber = 1      ! Steady wind.  Calculated internally. [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Uniform_WindNumber = 2      ! Uniform wind.  Formally known as a Hub-Height wind file. [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: TSFF_WindNumber = 3      ! TurbSim full-field binary file. [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: BladedFF_WindNumber = 4      ! Bladed style binary full-field file.  Includes native bladed format [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: HAWC_WindNumber = 5      ! HAWC wind file. [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: User_WindNumber = 6      ! User defined wind. [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: BladedFF_Shr_WindNumber = 7      ! Native Bladed binary full-field file. [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: FDext_WindNumber = 8      ! 4D wind from external souce (i.e., FAST.Farm). [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Point_WindNumber = 9      ! 1D wind components from ExtInflow [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Highest_WindNumber = 9      ! Highest wind number supported. [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: IfW_NumPtsAvg = 144      ! Number of points averaged for rotor-average wind speed [-]
! =========  InflowWind_InputFile  =======
  TYPE, PUBLIC :: InflowWind_InputFile
    LOGICAL  :: EchoFlag = .false.      !< Echo the input file [-]
    INTEGER(IntKi)  :: WindType = 0      !< Type of windfile [-]
    REAL(ReKi)  :: PropagationDir = 0.0_ReKi      !< Direction of wind propagation (meteorological direction) [(degrees)]
    REAL(ReKi)  :: VFlowAngle = 0.0_ReKi      !< Vertical (upflow) angle [degrees]
    LOGICAL  :: VelInterpCubic = .FALSE.      !< Use cubic interpolation for velocity in time (false=linear, true=cubic) [Used with WindType=2,3,4,5,7] [-]
    INTEGER(IntKi)  :: NWindVel = 0_IntKi      !< Number of points to output the wind velocity (0 to 9) [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WindVxiList      !< List of X coordinates for wind velocity measurements [meters]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WindVyiList      !< List of Y coordinates for wind velocity measurements [meters]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WindVziList      !< List of Z coordinates for wind velocity measurements [meters]
    REAL(ReKi)  :: Steady_HWindSpeed = 0.0_ReKi      !< Steady wind -- horizontal windspeed [meters/s]
    REAL(ReKi)  :: Steady_RefHt = 0.0_ReKi      !< Steady wind -- reference height [meters]
    REAL(ReKi)  :: Steady_PLexp = 0.0_ReKi      !< Steady wind -- power law exponent [-]
    CHARACTER(1024)  :: Uniform_FileName      !< Uniform wind -- filename [-]
    REAL(ReKi)  :: Uniform_RefHt = 0.0_ReKi      !< Uniform wind -- reference height [meters]
    REAL(ReKi)  :: Uniform_RefLength = 0.0_ReKi      !< Uniform wind -- reference length [meters]
    CHARACTER(1024)  :: TSFF_FileName      !< TurbSim Full-Field -- filename [-]
    CHARACTER(1024)  :: BladedFF_FileName      !< Bladed-style Full-Field -- filename [-]
    LOGICAL  :: BladedFF_TowerFile = .false.      !< Bladed-style Full-Field -- tower file exists [-]
    LOGICAL  :: CTTS_CoherentTurb = .FALSE.      !< Coherent turbulence data exists [-]
    CHARACTER(1024)  :: CTTS_FileName      !< Name of coherent turbulence file [-]
    CHARACTER(1024)  :: CTTS_Path      !< Path to coherent turbulence binary data files [-]
    CHARACTER(1024)  :: HAWC_FileName_u      !< HAWC -- u component binary data file name [-]
    CHARACTER(1024)  :: HAWC_FileName_v      !< HAWC -- v component binary data file name [-]
    CHARACTER(1024)  :: HAWC_FileName_w      !< HAWC -- w component binary data file name [-]
    INTEGER(IntKi)  :: HAWC_nx = 0_IntKi      !< HAWC -- number of grids in x direction [-]
    INTEGER(IntKi)  :: HAWC_ny = 0_IntKi      !< HAWC -- number of grids in y direction [-]
    INTEGER(IntKi)  :: HAWC_nz = 0_IntKi      !< HAWC -- number of grids in z direction [-]
    REAL(ReKi)  :: HAWC_dx = 0.0_ReKi      !< HAWC -- distance between points in x direction [meters]
    REAL(ReKi)  :: HAWC_dy = 0.0_ReKi      !< HAWC -- distance between points in y direction [meters]
    REAL(ReKi)  :: HAWC_dz = 0.0_ReKi      !< HAWC -- distance between points in z direction [meters]
    LOGICAL  :: SumPrint = .false.      !< Write summary info to a file <ROOTNAME>.IfW.Sum [-]
    INTEGER(IntKi)  :: NumOuts = 0_IntKi      !< Number of parameters in the output list (number of outputs requested) [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: OutList      !< List of user-requested output channels [-]
    INTEGER(IntKi)  :: SensorType = 0_IntKi      !< Sensor type (for lidar/sensor module) [-]
    INTEGER(IntKi)  :: NumBeam = 0_IntKi      !< Number of lidar beams [-]
    INTEGER(IntKi)  :: NumPulseGate = 0_IntKi      !< The number of range gates to return wind speeds at [-]
    REAL(ReKi) , DIMENSION(1:3)  :: RotorApexOffsetPos = 0.0_ReKi      !< Position of the lidar unit relative to the rotor apex of rotation [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: FocalDistanceX      !< LIDAR LOS focal distance co-ordinates in the x direction [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: FocalDistanceY      !< LIDAR LOS focal distance co-ordinates in the y direction [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: FocalDistanceZ      !< LIDAR LOS focal distance co-ordinates in the z direction [m]
    REAL(ReKi)  :: PulseSpacing = 0.0_ReKi      !< Distance between range gates [m]
    REAL(ReKi)  :: MeasurementInterval = 0.0_ReKi      !< Time between each measurement [s]
    REAL(ReKi)  :: URefLid = 0.0_ReKi      !< Reference average wind speed for the lidar [m/s]
    LOGICAL  :: LidRadialVel = .false.      !< TRUE => return radial component, FALSE => return 'x' direction estimate [-]
    INTEGER(IntKi)  :: ConsiderHubMotion = 0_IntKi      !< whether or not the hub motion's impact on the Lidar measurement will be considered [-]
    TYPE(Grid3D_InitInputType)  :: FF      !< scaling data [-]
  END TYPE InflowWind_InputFile
! =======================
! =========  InflowWind_InitInputType  =======
  TYPE, PUBLIC :: InflowWind_InitInputType
    CHARACTER(1024)  :: InputFileName      !< Name of the InflowWind input file to use [-]
    LOGICAL  :: Linearize = .FALSE.      !< Flag that tells this module if the glue code wants to linearize. [-]
    LOGICAL  :: Use4Dext = .FALSE.      !< Flag that tells this module if an external module will pass it 4-D velocity grids. [-]
    INTEGER(IntKi)  :: NumWindPoints = 0_IntKi      !< Number of wind velocity points expected [-]
    INTEGER(IntKi)  :: TurbineID = 0      !< Wind turbine ID number in the fixed (DEFAULT) file name when FixedWindFileRootName = .TRUE. (used by FAST.Farm) [-]
    LOGICAL  :: FixedWindFileRootName = .FALSE.      !< Do the wind data files have a fixed (DEFAULT) file name? (used by FAST.Farm) [-]
    CHARACTER(1024)  :: RootName      !< RootName for writing output files [-]
    INTEGER(IntKi)  :: FilePassingMethod = 0      !< Method for file passing {0: None (read from file), 1: as FileInfoType to parse, 2: as InputFileType already parsed} [-]
    TYPE(FileInfoType)  :: PassedFileInfo      !< If we don't use the input file, pass everything through this [FilePassingMethod = 1] [-]
    TYPE(InflowWind_InputFile)  :: PassedFileData      !< If we don't use the input file, pass everything through this [FilePassingMethod = 2] [-]
    LOGICAL  :: OutputAccel = .FALSE.      !< Flag to output wind acceleration [-]
    TYPE(Grid4D_InitInputType)  :: FDext      !< InitInput for 4D external wind data [-]
    REAL(ReKi)  :: RadAvg = 0.0_ReKi      !< Radius (from hub) used for averaging wind speed [-]
    INTEGER(IntKi)  :: MHK = 0_IntKi      !< MHK turbine type switch [-]
    REAL(ReKi)  :: WtrDpth = 0.0_ReKi      !< Water depth [m]
    REAL(ReKi)  :: MSL2SWL = 0.0_ReKi      !< Mean sea level to still water level [m]
    LOGICAL  :: BoxExceedAllow = .FALSE.      !< Flag to allow Extrapolation winds outside box starting at this index (for OLAF wakes and LidarSim) [-]
    LOGICAL  :: LidarEnabled = .false.      !< Enable LiDAR for this instance of InflowWind? (FAST.Farm, ADI, and InflowWind driver/library are not compatible) [-]
    REAL(ReKi) , DIMENSION(1:3)  :: HubPosition = 0.0_ReKi      !< initial position of the hub (lidar mounted on hub) [0,0,HubHeight] [m]
  END TYPE InflowWind_InitInputType
! =======================
! =========  InflowWind_InitOutputType  =======
  TYPE, PUBLIC :: InflowWind_InitOutputType
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputHdr      !< Names of output-to-file channels [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputUnt      !< Units of output-to-file channels [-]
    TYPE(ProgDesc)  :: Ver      !< Version information of InflowWind module [-]
    TYPE(WindFileDat)  :: WindFileInfo      !< Meta data from the wind file [-]
    CHARACTER(LinChanLen) , DIMENSION(:), ALLOCATABLE  :: LinNames_y      !< Names of the outputs used in linearization [-]
    CHARACTER(LinChanLen) , DIMENSION(:), ALLOCATABLE  :: LinNames_u      !< Names of the inputs used in linearization [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: RotFrame_y      !< Flag that tells FAST/MBC3 if the outputs used in linearization are in the rotating frame [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: RotFrame_u      !< Flag that tells FAST/MBC3 if the inputs used in linearization are in the rotating frame [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: IsLoad_u      !< Flag that tells FAST if the inputs used in linearization are loads (for preconditioning matrix) [-]
    TYPE(FlowFieldType) , POINTER :: FlowField => NULL()      !< Flow field data to represent all wind types [-]
  END TYPE InflowWind_InitOutputType
! =======================
! =========  InflowWind_ParameterType  =======
  TYPE, PUBLIC :: InflowWind_ParameterType
    CHARACTER(1024)  :: RootFileName      !< Root of the InflowWind input   filename [-]
    REAL(DbKi)  :: DT = 0.0_R8Ki      !< Time step for cont. state integration & disc. state update [seconds]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: WindViXYZprime      !< List of XYZ coordinates for velocity measurements, translated to the wind coordinate system (prime coordinates).  This equals MATMUL( RotToWind, ParamData%WindViXYZ ) [meters]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: WindViXYZ      !< List of XYZ coordinates for wind velocity measurements, 3xNWindVel [meters]
    TYPE(FlowFieldType) , POINTER :: FlowField => NULL()      !< Flow field data to represent all wind types [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PositionAvg      !< (non-rotated) positions of points used for averaging wind speed [meters]
    INTEGER(IntKi)  :: NWindVel = 0_IntKi      !< Number of points in the wind velocity list [-]
    INTEGER(IntKi)  :: NumOuts = 0      !< Number of parameters in the output list (number of outputs requested) [-]
    TYPE(OutParmType) , DIMENSION(:), ALLOCATABLE  :: OutParam      !< Names and units (and other characteristics) of all requested output parameters [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: OutParamLinIndx      !< Index into WriteOutput for WindViXYZ in linearization analysis [-]
    TYPE(Lidar_ParameterType)  :: lidar      !< Lidar parameter data [-]
    LOGICAL  :: OutputAccel = .FALSE.      !< Flag to output wind acceleration [-]
  END TYPE InflowWind_ParameterType
! =======================
! =========  InflowWind_InputType  =======
  TYPE, PUBLIC :: InflowWind_InputType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PositionXYZ      !< Array holding the input positions at a given timestep [meters]
    TYPE(Lidar_InputType)  :: lidar      !< Lidar data [-]
    REAL(ReKi) , DIMENSION(1:3)  :: HubPosition = 0.0_ReKi      !< position of the hub (inertial frame) [m]
    REAL(ReKi) , DIMENSION(1:3,1:3)  :: HubOrientation = 0.0_ReKi      !< orientation of the hub (direction cosine matrix) [-]
  END TYPE InflowWind_InputType
! =======================
! =========  InflowWind_OutputType  =======
  TYPE, PUBLIC :: InflowWind_OutputType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: VelocityUVW      !< Array holding the U,V,W velocity for a given timestep [meters/sec]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: AccelUVW      !< Array holding the U,V,W acceleration for a given timestep [meters/sec]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WriteOutput      !< Array with values to output to file [-]
    REAL(ReKi) , DIMENSION(1:3)  :: DiskVel = 0.0_ReKi      !< Vector holding the U,V,W average velocity of the disk [meters/sec]
    REAL(ReKi) , DIMENSION(1:3)  :: HubVel = 0.0_ReKi      !< Vector holding the U,V,W velocity at the hub [meters/sec]
    TYPE(Lidar_OutputType)  :: lidar      !< Lidar data [-]
  END TYPE InflowWind_OutputType
! =======================
! =========  InflowWind_ContinuousStateType  =======
  TYPE, PUBLIC :: InflowWind_ContinuousStateType
    REAL(ReKi)  :: DummyContState = 0.0_ReKi      !< Remove this variable if you have continuous states [-]
  END TYPE InflowWind_ContinuousStateType
! =======================
! =========  InflowWind_DiscreteStateType  =======
  TYPE, PUBLIC :: InflowWind_DiscreteStateType
    REAL(ReKi)  :: DummyDiscState = 0.0_ReKi      !< Remove this variable if you have discrete states [-]
  END TYPE InflowWind_DiscreteStateType
! =======================
! =========  InflowWind_ConstraintStateType  =======
  TYPE, PUBLIC :: InflowWind_ConstraintStateType
    REAL(ReKi)  :: DummyConstrState = 0.0_ReKi      !< Remove this variable if you have constraint states [-]
  END TYPE InflowWind_ConstraintStateType
! =======================
! =========  InflowWind_OtherStateType  =======
  TYPE, PUBLIC :: InflowWind_OtherStateType
    REAL(ReKi)  :: DummyOtherState = 0.0_ReKi      !< Remove this variable if you have other states [-]
  END TYPE InflowWind_OtherStateType
! =======================
! =========  InflowWind_MiscVarType  =======
  TYPE, PUBLIC :: InflowWind_MiscVarType
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: AllOuts      !< An array holding the value of all of the calculated (not only selected) output channels [see OutListParameters.xlsx spreadsheet]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: WindViUVW      !< List of UVW velocities for wind velocity measurements, 3xNWindVel. corresponds to ParamData%WindViXYZ [meters/second]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: WindAiUVW      !< List of UVW accelerations for wind acceleration measurements, 3xNWindVel. corresponds to ParamData%WindViXYZ [m/s^2]
    TYPE(InflowWind_InputType)  :: u_Avg      !< inputs for computing rotor-averaged values [-]
    TYPE(InflowWind_OutputType)  :: y_Avg      !< outputs for computing rotor-averaged values [-]
    TYPE(InflowWind_InputType)  :: u_Hub      !< inputs for computing hub values [-]
    TYPE(InflowWind_OutputType)  :: y_Hub      !< outputs for computing hub values [-]
  END TYPE InflowWind_MiscVarType
! =======================
CONTAINS

subroutine InflowWind_CopyInputFile(SrcInputFileData, DstInputFileData, CtrlCode, ErrStat, ErrMsg)
   type(InflowWind_InputFile), intent(in) :: SrcInputFileData
   type(InflowWind_InputFile), intent(inout) :: DstInputFileData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'InflowWind_CopyInputFile'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInputFileData%EchoFlag = SrcInputFileData%EchoFlag
   DstInputFileData%WindType = SrcInputFileData%WindType
   DstInputFileData%PropagationDir = SrcInputFileData%PropagationDir
   DstInputFileData%VFlowAngle = SrcInputFileData%VFlowAngle
   DstInputFileData%VelInterpCubic = SrcInputFileData%VelInterpCubic
   DstInputFileData%NWindVel = SrcInputFileData%NWindVel
   if (allocated(SrcInputFileData%WindVxiList)) then
      LB(1:1) = lbound(SrcInputFileData%WindVxiList)
      UB(1:1) = ubound(SrcInputFileData%WindVxiList)
      if (.not. allocated(DstInputFileData%WindVxiList)) then
         allocate(DstInputFileData%WindVxiList(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%WindVxiList.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%WindVxiList = SrcInputFileData%WindVxiList
   end if
   if (allocated(SrcInputFileData%WindVyiList)) then
      LB(1:1) = lbound(SrcInputFileData%WindVyiList)
      UB(1:1) = ubound(SrcInputFileData%WindVyiList)
      if (.not. allocated(DstInputFileData%WindVyiList)) then
         allocate(DstInputFileData%WindVyiList(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%WindVyiList.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%WindVyiList = SrcInputFileData%WindVyiList
   end if
   if (allocated(SrcInputFileData%WindVziList)) then
      LB(1:1) = lbound(SrcInputFileData%WindVziList)
      UB(1:1) = ubound(SrcInputFileData%WindVziList)
      if (.not. allocated(DstInputFileData%WindVziList)) then
         allocate(DstInputFileData%WindVziList(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%WindVziList.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%WindVziList = SrcInputFileData%WindVziList
   end if
   DstInputFileData%Steady_HWindSpeed = SrcInputFileData%Steady_HWindSpeed
   DstInputFileData%Steady_RefHt = SrcInputFileData%Steady_RefHt
   DstInputFileData%Steady_PLexp = SrcInputFileData%Steady_PLexp
   DstInputFileData%Uniform_FileName = SrcInputFileData%Uniform_FileName
   DstInputFileData%Uniform_RefHt = SrcInputFileData%Uniform_RefHt
   DstInputFileData%Uniform_RefLength = SrcInputFileData%Uniform_RefLength
   DstInputFileData%TSFF_FileName = SrcInputFileData%TSFF_FileName
   DstInputFileData%BladedFF_FileName = SrcInputFileData%BladedFF_FileName
   DstInputFileData%BladedFF_TowerFile = SrcInputFileData%BladedFF_TowerFile
   DstInputFileData%CTTS_CoherentTurb = SrcInputFileData%CTTS_CoherentTurb
   DstInputFileData%CTTS_FileName = SrcInputFileData%CTTS_FileName
   DstInputFileData%CTTS_Path = SrcInputFileData%CTTS_Path
   DstInputFileData%HAWC_FileName_u = SrcInputFileData%HAWC_FileName_u
   DstInputFileData%HAWC_FileName_v = SrcInputFileData%HAWC_FileName_v
   DstInputFileData%HAWC_FileName_w = SrcInputFileData%HAWC_FileName_w
   DstInputFileData%HAWC_nx = SrcInputFileData%HAWC_nx
   DstInputFileData%HAWC_ny = SrcInputFileData%HAWC_ny
   DstInputFileData%HAWC_nz = SrcInputFileData%HAWC_nz
   DstInputFileData%HAWC_dx = SrcInputFileData%HAWC_dx
   DstInputFileData%HAWC_dy = SrcInputFileData%HAWC_dy
   DstInputFileData%HAWC_dz = SrcInputFileData%HAWC_dz
   DstInputFileData%SumPrint = SrcInputFileData%SumPrint
   DstInputFileData%NumOuts = SrcInputFileData%NumOuts
   if (allocated(SrcInputFileData%OutList)) then
      LB(1:1) = lbound(SrcInputFileData%OutList)
      UB(1:1) = ubound(SrcInputFileData%OutList)
      if (.not. allocated(DstInputFileData%OutList)) then
         allocate(DstInputFileData%OutList(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%OutList.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%OutList = SrcInputFileData%OutList
   end if
   DstInputFileData%SensorType = SrcInputFileData%SensorType
   DstInputFileData%NumBeam = SrcInputFileData%NumBeam
   DstInputFileData%NumPulseGate = SrcInputFileData%NumPulseGate
   DstInputFileData%RotorApexOffsetPos = SrcInputFileData%RotorApexOffsetPos
   if (allocated(SrcInputFileData%FocalDistanceX)) then
      LB(1:1) = lbound(SrcInputFileData%FocalDistanceX)
      UB(1:1) = ubound(SrcInputFileData%FocalDistanceX)
      if (.not. allocated(DstInputFileData%FocalDistanceX)) then
         allocate(DstInputFileData%FocalDistanceX(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%FocalDistanceX.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%FocalDistanceX = SrcInputFileData%FocalDistanceX
   end if
   if (allocated(SrcInputFileData%FocalDistanceY)) then
      LB(1:1) = lbound(SrcInputFileData%FocalDistanceY)
      UB(1:1) = ubound(SrcInputFileData%FocalDistanceY)
      if (.not. allocated(DstInputFileData%FocalDistanceY)) then
         allocate(DstInputFileData%FocalDistanceY(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%FocalDistanceY.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%FocalDistanceY = SrcInputFileData%FocalDistanceY
   end if
   if (allocated(SrcInputFileData%FocalDistanceZ)) then
      LB(1:1) = lbound(SrcInputFileData%FocalDistanceZ)
      UB(1:1) = ubound(SrcInputFileData%FocalDistanceZ)
      if (.not. allocated(DstInputFileData%FocalDistanceZ)) then
         allocate(DstInputFileData%FocalDistanceZ(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%FocalDistanceZ.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%FocalDistanceZ = SrcInputFileData%FocalDistanceZ
   end if
   DstInputFileData%PulseSpacing = SrcInputFileData%PulseSpacing
   DstInputFileData%MeasurementInterval = SrcInputFileData%MeasurementInterval
   DstInputFileData%URefLid = SrcInputFileData%URefLid
   DstInputFileData%LidRadialVel = SrcInputFileData%LidRadialVel
   DstInputFileData%ConsiderHubMotion = SrcInputFileData%ConsiderHubMotion
   call InflowWind_IO_CopyGrid3D_InitInputType(SrcInputFileData%FF, DstInputFileData%FF, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine InflowWind_DestroyInputFile(InputFileData, ErrStat, ErrMsg)
   type(InflowWind_InputFile), intent(inout) :: InputFileData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'InflowWind_DestroyInputFile'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InputFileData%WindVxiList)) then
      deallocate(InputFileData%WindVxiList)
   end if
   if (allocated(InputFileData%WindVyiList)) then
      deallocate(InputFileData%WindVyiList)
   end if
   if (allocated(InputFileData%WindVziList)) then
      deallocate(InputFileData%WindVziList)
   end if
   if (allocated(InputFileData%OutList)) then
      deallocate(InputFileData%OutList)
   end if
   if (allocated(InputFileData%FocalDistanceX)) then
      deallocate(InputFileData%FocalDistanceX)
   end if
   if (allocated(InputFileData%FocalDistanceY)) then
      deallocate(InputFileData%FocalDistanceY)
   end if
   if (allocated(InputFileData%FocalDistanceZ)) then
      deallocate(InputFileData%FocalDistanceZ)
   end if
   call InflowWind_IO_DestroyGrid3D_InitInputType(InputFileData%FF, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine InflowWind_PackInputFile(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(InflowWind_InputFile), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'InflowWind_PackInputFile'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%EchoFlag)
   call RegPack(RF, InData%WindType)
   call RegPack(RF, InData%PropagationDir)
   call RegPack(RF, InData%VFlowAngle)
   call RegPack(RF, InData%VelInterpCubic)
   call RegPack(RF, InData%NWindVel)
   call RegPackAlloc(RF, InData%WindVxiList)
   call RegPackAlloc(RF, InData%WindVyiList)
   call RegPackAlloc(RF, InData%WindVziList)
   call RegPack(RF, InData%Steady_HWindSpeed)
   call RegPack(RF, InData%Steady_RefHt)
   call RegPack(RF, InData%Steady_PLexp)
   call RegPack(RF, InData%Uniform_FileName)
   call RegPack(RF, InData%Uniform_RefHt)
   call RegPack(RF, InData%Uniform_RefLength)
   call RegPack(RF, InData%TSFF_FileName)
   call RegPack(RF, InData%BladedFF_FileName)
   call RegPack(RF, InData%BladedFF_TowerFile)
   call RegPack(RF, InData%CTTS_CoherentTurb)
   call RegPack(RF, InData%CTTS_FileName)
   call RegPack(RF, InData%CTTS_Path)
   call RegPack(RF, InData%HAWC_FileName_u)
   call RegPack(RF, InData%HAWC_FileName_v)
   call RegPack(RF, InData%HAWC_FileName_w)
   call RegPack(RF, InData%HAWC_nx)
   call RegPack(RF, InData%HAWC_ny)
   call RegPack(RF, InData%HAWC_nz)
   call RegPack(RF, InData%HAWC_dx)
   call RegPack(RF, InData%HAWC_dy)
   call RegPack(RF, InData%HAWC_dz)
   call RegPack(RF, InData%SumPrint)
   call RegPack(RF, InData%NumOuts)
   call RegPackAlloc(RF, InData%OutList)
   call RegPack(RF, InData%SensorType)
   call RegPack(RF, InData%NumBeam)
   call RegPack(RF, InData%NumPulseGate)
   call RegPack(RF, InData%RotorApexOffsetPos)
   call RegPackAlloc(RF, InData%FocalDistanceX)
   call RegPackAlloc(RF, InData%FocalDistanceY)
   call RegPackAlloc(RF, InData%FocalDistanceZ)
   call RegPack(RF, InData%PulseSpacing)
   call RegPack(RF, InData%MeasurementInterval)
   call RegPack(RF, InData%URefLid)
   call RegPack(RF, InData%LidRadialVel)
   call RegPack(RF, InData%ConsiderHubMotion)
   call InflowWind_IO_PackGrid3D_InitInputType(RF, InData%FF) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_UnPackInputFile(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(InflowWind_InputFile), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'InflowWind_UnPackInputFile'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%EchoFlag); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WindType); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PropagationDir); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VFlowAngle); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VelInterpCubic); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NWindVel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WindVxiList); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WindVyiList); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WindVziList); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Steady_HWindSpeed); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Steady_RefHt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Steady_PLexp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Uniform_FileName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Uniform_RefHt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Uniform_RefLength); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TSFF_FileName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BladedFF_FileName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BladedFF_TowerFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CTTS_CoherentTurb); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CTTS_FileName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CTTS_Path); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HAWC_FileName_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HAWC_FileName_v); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HAWC_FileName_w); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HAWC_nx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HAWC_ny); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HAWC_nz); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HAWC_dx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HAWC_dy); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HAWC_dz); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SumPrint); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%OutList); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SensorType); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumBeam); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumPulseGate); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RotorApexOffsetPos); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%FocalDistanceX); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%FocalDistanceY); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%FocalDistanceZ); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PulseSpacing); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MeasurementInterval); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%URefLid); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LidRadialVel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ConsiderHubMotion); if (RegCheckErr(RF, RoutineName)) return
   call InflowWind_IO_UnpackGrid3D_InitInputType(RF, OutData%FF) ! FF 
end subroutine

subroutine InflowWind_CopyInitInput(SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg)
   type(InflowWind_InitInputType), intent(in) :: SrcInitInputData
   type(InflowWind_InitInputType), intent(inout) :: DstInitInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'InflowWind_CopyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInitInputData%InputFileName = SrcInitInputData%InputFileName
   DstInitInputData%Linearize = SrcInitInputData%Linearize
   DstInitInputData%Use4Dext = SrcInitInputData%Use4Dext
   DstInitInputData%NumWindPoints = SrcInitInputData%NumWindPoints
   DstInitInputData%TurbineID = SrcInitInputData%TurbineID
   DstInitInputData%FixedWindFileRootName = SrcInitInputData%FixedWindFileRootName
   DstInitInputData%RootName = SrcInitInputData%RootName
   DstInitInputData%FilePassingMethod = SrcInitInputData%FilePassingMethod
   call NWTC_Library_CopyFileInfoType(SrcInitInputData%PassedFileInfo, DstInitInputData%PassedFileInfo, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call InflowWind_CopyInputFile(SrcInitInputData%PassedFileData, DstInitInputData%PassedFileData, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstInitInputData%OutputAccel = SrcInitInputData%OutputAccel
   call InflowWind_IO_CopyGrid4D_InitInputType(SrcInitInputData%FDext, DstInitInputData%FDext, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstInitInputData%RadAvg = SrcInitInputData%RadAvg
   DstInitInputData%MHK = SrcInitInputData%MHK
   DstInitInputData%WtrDpth = SrcInitInputData%WtrDpth
   DstInitInputData%MSL2SWL = SrcInitInputData%MSL2SWL
   DstInitInputData%BoxExceedAllow = SrcInitInputData%BoxExceedAllow
   DstInitInputData%LidarEnabled = SrcInitInputData%LidarEnabled
   DstInitInputData%HubPosition = SrcInitInputData%HubPosition
end subroutine

subroutine InflowWind_DestroyInitInput(InitInputData, ErrStat, ErrMsg)
   type(InflowWind_InitInputType), intent(inout) :: InitInputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'InflowWind_DestroyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call NWTC_Library_DestroyFileInfoType(InitInputData%PassedFileInfo, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call InflowWind_DestroyInputFile(InitInputData%PassedFileData, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call InflowWind_IO_DestroyGrid4D_InitInputType(InitInputData%FDext, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine InflowWind_PackInitInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(InflowWind_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'InflowWind_PackInitInput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%InputFileName)
   call RegPack(RF, InData%Linearize)
   call RegPack(RF, InData%Use4Dext)
   call RegPack(RF, InData%NumWindPoints)
   call RegPack(RF, InData%TurbineID)
   call RegPack(RF, InData%FixedWindFileRootName)
   call RegPack(RF, InData%RootName)
   call RegPack(RF, InData%FilePassingMethod)
   call NWTC_Library_PackFileInfoType(RF, InData%PassedFileInfo) 
   call InflowWind_PackInputFile(RF, InData%PassedFileData) 
   call RegPack(RF, InData%OutputAccel)
   call InflowWind_IO_PackGrid4D_InitInputType(RF, InData%FDext) 
   call RegPack(RF, InData%RadAvg)
   call RegPack(RF, InData%MHK)
   call RegPack(RF, InData%WtrDpth)
   call RegPack(RF, InData%MSL2SWL)
   call RegPack(RF, InData%BoxExceedAllow)
   call RegPack(RF, InData%LidarEnabled)
   call RegPack(RF, InData%HubPosition)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_UnPackInitInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(InflowWind_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'InflowWind_UnPackInitInput'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%InputFileName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Linearize); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Use4Dext); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumWindPoints); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TurbineID); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FixedWindFileRootName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FilePassingMethod); if (RegCheckErr(RF, RoutineName)) return
   call NWTC_Library_UnpackFileInfoType(RF, OutData%PassedFileInfo) ! PassedFileInfo 
   call InflowWind_UnpackInputFile(RF, OutData%PassedFileData) ! PassedFileData 
   call RegUnpack(RF, OutData%OutputAccel); if (RegCheckErr(RF, RoutineName)) return
   call InflowWind_IO_UnpackGrid4D_InitInputType(RF, OutData%FDext) ! FDext 
   call RegUnpack(RF, OutData%RadAvg); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MHK); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WtrDpth); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MSL2SWL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BoxExceedAllow); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LidarEnabled); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HubPosition); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_CopyInitOutput(SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg)
   type(InflowWind_InitOutputType), intent(in) :: SrcInitOutputData
   type(InflowWind_InitOutputType), intent(inout) :: DstInitOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'InflowWind_CopyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcInitOutputData%WriteOutputHdr)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputHdr)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputHdr)
      if (.not. allocated(DstInitOutputData%WriteOutputHdr)) then
         allocate(DstInitOutputData%WriteOutputHdr(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputHdr.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputHdr = SrcInitOutputData%WriteOutputHdr
   end if
   if (allocated(SrcInitOutputData%WriteOutputUnt)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputUnt)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputUnt)
      if (.not. allocated(DstInitOutputData%WriteOutputUnt)) then
         allocate(DstInitOutputData%WriteOutputUnt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputUnt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputUnt = SrcInitOutputData%WriteOutputUnt
   end if
   call NWTC_Library_CopyProgDesc(SrcInitOutputData%Ver, DstInitOutputData%Ver, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call InflowWind_IO_CopyWindFileDat(SrcInitOutputData%WindFileInfo, DstInitOutputData%WindFileInfo, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcInitOutputData%LinNames_y)) then
      LB(1:1) = lbound(SrcInitOutputData%LinNames_y)
      UB(1:1) = ubound(SrcInitOutputData%LinNames_y)
      if (.not. allocated(DstInitOutputData%LinNames_y)) then
         allocate(DstInitOutputData%LinNames_y(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LinNames_y.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%LinNames_y = SrcInitOutputData%LinNames_y
   end if
   if (allocated(SrcInitOutputData%LinNames_u)) then
      LB(1:1) = lbound(SrcInitOutputData%LinNames_u)
      UB(1:1) = ubound(SrcInitOutputData%LinNames_u)
      if (.not. allocated(DstInitOutputData%LinNames_u)) then
         allocate(DstInitOutputData%LinNames_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LinNames_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%LinNames_u = SrcInitOutputData%LinNames_u
   end if
   if (allocated(SrcInitOutputData%RotFrame_y)) then
      LB(1:1) = lbound(SrcInitOutputData%RotFrame_y)
      UB(1:1) = ubound(SrcInitOutputData%RotFrame_y)
      if (.not. allocated(DstInitOutputData%RotFrame_y)) then
         allocate(DstInitOutputData%RotFrame_y(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%RotFrame_y.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%RotFrame_y = SrcInitOutputData%RotFrame_y
   end if
   if (allocated(SrcInitOutputData%RotFrame_u)) then
      LB(1:1) = lbound(SrcInitOutputData%RotFrame_u)
      UB(1:1) = ubound(SrcInitOutputData%RotFrame_u)
      if (.not. allocated(DstInitOutputData%RotFrame_u)) then
         allocate(DstInitOutputData%RotFrame_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%RotFrame_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%RotFrame_u = SrcInitOutputData%RotFrame_u
   end if
   if (allocated(SrcInitOutputData%IsLoad_u)) then
      LB(1:1) = lbound(SrcInitOutputData%IsLoad_u)
      UB(1:1) = ubound(SrcInitOutputData%IsLoad_u)
      if (.not. allocated(DstInitOutputData%IsLoad_u)) then
         allocate(DstInitOutputData%IsLoad_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%IsLoad_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%IsLoad_u = SrcInitOutputData%IsLoad_u
   end if
   DstInitOutputData%FlowField => SrcInitOutputData%FlowField
end subroutine

subroutine InflowWind_DestroyInitOutput(InitOutputData, ErrStat, ErrMsg)
   type(InflowWind_InitOutputType), intent(inout) :: InitOutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'InflowWind_DestroyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InitOutputData%WriteOutputHdr)) then
      deallocate(InitOutputData%WriteOutputHdr)
   end if
   if (allocated(InitOutputData%WriteOutputUnt)) then
      deallocate(InitOutputData%WriteOutputUnt)
   end if
   call NWTC_Library_DestroyProgDesc(InitOutputData%Ver, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call InflowWind_IO_DestroyWindFileDat(InitOutputData%WindFileInfo, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(InitOutputData%LinNames_y)) then
      deallocate(InitOutputData%LinNames_y)
   end if
   if (allocated(InitOutputData%LinNames_u)) then
      deallocate(InitOutputData%LinNames_u)
   end if
   if (allocated(InitOutputData%RotFrame_y)) then
      deallocate(InitOutputData%RotFrame_y)
   end if
   if (allocated(InitOutputData%RotFrame_u)) then
      deallocate(InitOutputData%RotFrame_u)
   end if
   if (allocated(InitOutputData%IsLoad_u)) then
      deallocate(InitOutputData%IsLoad_u)
   end if
   nullify(InitOutputData%FlowField)
end subroutine

subroutine InflowWind_PackInitOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(InflowWind_InitOutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'InflowWind_PackInitOutput'
   logical         :: PtrInIndex
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%WriteOutputHdr)
   call RegPackAlloc(RF, InData%WriteOutputUnt)
   call NWTC_Library_PackProgDesc(RF, InData%Ver) 
   call InflowWind_IO_PackWindFileDat(RF, InData%WindFileInfo) 
   call RegPackAlloc(RF, InData%LinNames_y)
   call RegPackAlloc(RF, InData%LinNames_u)
   call RegPackAlloc(RF, InData%RotFrame_y)
   call RegPackAlloc(RF, InData%RotFrame_u)
   call RegPackAlloc(RF, InData%IsLoad_u)
   call RegPack(RF, associated(InData%FlowField))
   if (associated(InData%FlowField)) then
      call RegPackPointer(RF, c_loc(InData%FlowField), PtrInIndex)
      if (.not. PtrInIndex) then
         call IfW_FlowField_PackFlowFieldType(RF, InData%FlowField) 
      end if
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_UnPackInitOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(InflowWind_InitOutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'InflowWind_UnPackInitOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   integer(B8Ki)   :: PtrIdx
   type(c_ptr)     :: Ptr
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%WriteOutputHdr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutputUnt); if (RegCheckErr(RF, RoutineName)) return
   call NWTC_Library_UnpackProgDesc(RF, OutData%Ver) ! Ver 
   call InflowWind_IO_UnpackWindFileDat(RF, OutData%WindFileInfo) ! WindFileInfo 
   call RegUnpackAlloc(RF, OutData%LinNames_y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LinNames_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RotFrame_y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RotFrame_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%IsLoad_u); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%FlowField)) deallocate(OutData%FlowField)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackPointer(RF, Ptr, PtrIdx); if (RegCheckErr(RF, RoutineName)) return
      if (c_associated(Ptr)) then
         call c_f_pointer(Ptr, OutData%FlowField)
      else
         allocate(OutData%FlowField,stat=stat)
         if (stat /= 0) then 
            call SetErrStat(ErrID_Fatal, 'Error allocating OutData%FlowField.', RF%ErrStat, RF%ErrMsg, RoutineName)
            return
         end if
         RF%Pointers(PtrIdx) = c_loc(OutData%FlowField)
         call IfW_FlowField_UnpackFlowFieldType(RF, OutData%FlowField) ! FlowField 
      end if
   else
      OutData%FlowField => null()
   end if
end subroutine

subroutine InflowWind_CopyParam(SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg)
   type(InflowWind_ParameterType), intent(in) :: SrcParamData
   type(InflowWind_ParameterType), intent(inout) :: DstParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'InflowWind_CopyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstParamData%RootFileName = SrcParamData%RootFileName
   DstParamData%DT = SrcParamData%DT
   if (allocated(SrcParamData%WindViXYZprime)) then
      LB(1:2) = lbound(SrcParamData%WindViXYZprime)
      UB(1:2) = ubound(SrcParamData%WindViXYZprime)
      if (.not. allocated(DstParamData%WindViXYZprime)) then
         allocate(DstParamData%WindViXYZprime(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%WindViXYZprime.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%WindViXYZprime = SrcParamData%WindViXYZprime
   end if
   if (allocated(SrcParamData%WindViXYZ)) then
      LB(1:2) = lbound(SrcParamData%WindViXYZ)
      UB(1:2) = ubound(SrcParamData%WindViXYZ)
      if (.not. allocated(DstParamData%WindViXYZ)) then
         allocate(DstParamData%WindViXYZ(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%WindViXYZ.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%WindViXYZ = SrcParamData%WindViXYZ
   end if
   if (associated(SrcParamData%FlowField)) then
      if (.not. associated(DstParamData%FlowField)) then
         allocate(DstParamData%FlowField, stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%FlowField.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      call IfW_FlowField_CopyFlowFieldType(SrcParamData%FlowField, DstParamData%FlowField, CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end if
   if (allocated(SrcParamData%PositionAvg)) then
      LB(1:2) = lbound(SrcParamData%PositionAvg)
      UB(1:2) = ubound(SrcParamData%PositionAvg)
      if (.not. allocated(DstParamData%PositionAvg)) then
         allocate(DstParamData%PositionAvg(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%PositionAvg.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%PositionAvg = SrcParamData%PositionAvg
   end if
   DstParamData%NWindVel = SrcParamData%NWindVel
   DstParamData%NumOuts = SrcParamData%NumOuts
   if (allocated(SrcParamData%OutParam)) then
      LB(1:1) = lbound(SrcParamData%OutParam)
      UB(1:1) = ubound(SrcParamData%OutParam)
      if (.not. allocated(DstParamData%OutParam)) then
         allocate(DstParamData%OutParam(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%OutParam.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyOutParmType(SrcParamData%OutParam(i1), DstParamData%OutParam(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcParamData%OutParamLinIndx)) then
      LB(1:2) = lbound(SrcParamData%OutParamLinIndx)
      UB(1:2) = ubound(SrcParamData%OutParamLinIndx)
      if (.not. allocated(DstParamData%OutParamLinIndx)) then
         allocate(DstParamData%OutParamLinIndx(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%OutParamLinIndx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%OutParamLinIndx = SrcParamData%OutParamLinIndx
   end if
   call Lidar_CopyParam(SrcParamData%lidar, DstParamData%lidar, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstParamData%OutputAccel = SrcParamData%OutputAccel
end subroutine

subroutine InflowWind_DestroyParam(ParamData, ErrStat, ErrMsg)
   type(InflowWind_ParameterType), intent(inout) :: ParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'InflowWind_DestroyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ParamData%WindViXYZprime)) then
      deallocate(ParamData%WindViXYZprime)
   end if
   if (allocated(ParamData%WindViXYZ)) then
      deallocate(ParamData%WindViXYZ)
   end if
   if (associated(ParamData%FlowField)) then
      call IfW_FlowField_DestroyFlowFieldType(ParamData%FlowField, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      deallocate(ParamData%FlowField)
      ParamData%FlowField => null()
   end if
   if (allocated(ParamData%PositionAvg)) then
      deallocate(ParamData%PositionAvg)
   end if
   if (allocated(ParamData%OutParam)) then
      LB(1:1) = lbound(ParamData%OutParam)
      UB(1:1) = ubound(ParamData%OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyOutParmType(ParamData%OutParam(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%OutParam)
   end if
   if (allocated(ParamData%OutParamLinIndx)) then
      deallocate(ParamData%OutParamLinIndx)
   end if
   call Lidar_DestroyParam(ParamData%lidar, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine InflowWind_PackParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(InflowWind_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'InflowWind_PackParam'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   logical         :: PtrInIndex
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%RootFileName)
   call RegPack(RF, InData%DT)
   call RegPackAlloc(RF, InData%WindViXYZprime)
   call RegPackAlloc(RF, InData%WindViXYZ)
   call RegPack(RF, associated(InData%FlowField))
   if (associated(InData%FlowField)) then
      call RegPackPointer(RF, c_loc(InData%FlowField), PtrInIndex)
      if (.not. PtrInIndex) then
         call IfW_FlowField_PackFlowFieldType(RF, InData%FlowField) 
      end if
   end if
   call RegPackAlloc(RF, InData%PositionAvg)
   call RegPack(RF, InData%NWindVel)
   call RegPack(RF, InData%NumOuts)
   call RegPack(RF, allocated(InData%OutParam))
   if (allocated(InData%OutParam)) then
      call RegPackBounds(RF, 1, lbound(InData%OutParam), ubound(InData%OutParam))
      LB(1:1) = lbound(InData%OutParam)
      UB(1:1) = ubound(InData%OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackOutParmType(RF, InData%OutParam(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%OutParamLinIndx)
   call Lidar_PackParam(RF, InData%lidar) 
   call RegPack(RF, InData%OutputAccel)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_UnPackParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(InflowWind_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'InflowWind_UnPackParam'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   integer(B8Ki)   :: PtrIdx
   type(c_ptr)     :: Ptr
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%RootFileName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WindViXYZprime); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WindViXYZ); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%FlowField)) deallocate(OutData%FlowField)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackPointer(RF, Ptr, PtrIdx); if (RegCheckErr(RF, RoutineName)) return
      if (c_associated(Ptr)) then
         call c_f_pointer(Ptr, OutData%FlowField)
      else
         allocate(OutData%FlowField,stat=stat)
         if (stat /= 0) then 
            call SetErrStat(ErrID_Fatal, 'Error allocating OutData%FlowField.', RF%ErrStat, RF%ErrMsg, RoutineName)
            return
         end if
         RF%Pointers(PtrIdx) = c_loc(OutData%FlowField)
         call IfW_FlowField_UnpackFlowFieldType(RF, OutData%FlowField) ! FlowField 
      end if
   else
      OutData%FlowField => null()
   end if
   call RegUnpackAlloc(RF, OutData%PositionAvg); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NWindVel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumOuts); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%OutParam)) deallocate(OutData%OutParam)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%OutParam(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%OutParam.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackOutParmType(RF, OutData%OutParam(i1)) ! OutParam 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%OutParamLinIndx); if (RegCheckErr(RF, RoutineName)) return
   call Lidar_UnpackParam(RF, OutData%lidar) ! lidar 
   call RegUnpack(RF, OutData%OutputAccel); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_CopyInput(SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg)
   type(InflowWind_InputType), intent(in) :: SrcInputData
   type(InflowWind_InputType), intent(inout) :: DstInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'InflowWind_CopyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcInputData%PositionXYZ)) then
      LB(1:2) = lbound(SrcInputData%PositionXYZ)
      UB(1:2) = ubound(SrcInputData%PositionXYZ)
      if (.not. allocated(DstInputData%PositionXYZ)) then
         allocate(DstInputData%PositionXYZ(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%PositionXYZ.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%PositionXYZ = SrcInputData%PositionXYZ
   end if
   call Lidar_CopyInput(SrcInputData%lidar, DstInputData%lidar, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstInputData%HubPosition = SrcInputData%HubPosition
   DstInputData%HubOrientation = SrcInputData%HubOrientation
end subroutine

subroutine InflowWind_DestroyInput(InputData, ErrStat, ErrMsg)
   type(InflowWind_InputType), intent(inout) :: InputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'InflowWind_DestroyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InputData%PositionXYZ)) then
      deallocate(InputData%PositionXYZ)
   end if
   call Lidar_DestroyInput(InputData%lidar, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine InflowWind_PackInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(InflowWind_InputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'InflowWind_PackInput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%PositionXYZ)
   call Lidar_PackInput(RF, InData%lidar) 
   call RegPack(RF, InData%HubPosition)
   call RegPack(RF, InData%HubOrientation)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_UnPackInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(InflowWind_InputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'InflowWind_UnPackInput'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%PositionXYZ); if (RegCheckErr(RF, RoutineName)) return
   call Lidar_UnpackInput(RF, OutData%lidar) ! lidar 
   call RegUnpack(RF, OutData%HubPosition); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HubOrientation); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_CopyOutput(SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg)
   type(InflowWind_OutputType), intent(in) :: SrcOutputData
   type(InflowWind_OutputType), intent(inout) :: DstOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'InflowWind_CopyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcOutputData%VelocityUVW)) then
      LB(1:2) = lbound(SrcOutputData%VelocityUVW)
      UB(1:2) = ubound(SrcOutputData%VelocityUVW)
      if (.not. allocated(DstOutputData%VelocityUVW)) then
         allocate(DstOutputData%VelocityUVW(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%VelocityUVW.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%VelocityUVW = SrcOutputData%VelocityUVW
   end if
   if (allocated(SrcOutputData%AccelUVW)) then
      LB(1:2) = lbound(SrcOutputData%AccelUVW)
      UB(1:2) = ubound(SrcOutputData%AccelUVW)
      if (.not. allocated(DstOutputData%AccelUVW)) then
         allocate(DstOutputData%AccelUVW(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%AccelUVW.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%AccelUVW = SrcOutputData%AccelUVW
   end if
   if (allocated(SrcOutputData%WriteOutput)) then
      LB(1:1) = lbound(SrcOutputData%WriteOutput)
      UB(1:1) = ubound(SrcOutputData%WriteOutput)
      if (.not. allocated(DstOutputData%WriteOutput)) then
         allocate(DstOutputData%WriteOutput(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%WriteOutput.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%WriteOutput = SrcOutputData%WriteOutput
   end if
   DstOutputData%DiskVel = SrcOutputData%DiskVel
   DstOutputData%HubVel = SrcOutputData%HubVel
   call Lidar_CopyOutput(SrcOutputData%lidar, DstOutputData%lidar, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine InflowWind_DestroyOutput(OutputData, ErrStat, ErrMsg)
   type(InflowWind_OutputType), intent(inout) :: OutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'InflowWind_DestroyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(OutputData%VelocityUVW)) then
      deallocate(OutputData%VelocityUVW)
   end if
   if (allocated(OutputData%AccelUVW)) then
      deallocate(OutputData%AccelUVW)
   end if
   if (allocated(OutputData%WriteOutput)) then
      deallocate(OutputData%WriteOutput)
   end if
   call Lidar_DestroyOutput(OutputData%lidar, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine InflowWind_PackOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(InflowWind_OutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'InflowWind_PackOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%VelocityUVW)
   call RegPackAlloc(RF, InData%AccelUVW)
   call RegPackAlloc(RF, InData%WriteOutput)
   call RegPack(RF, InData%DiskVel)
   call RegPack(RF, InData%HubVel)
   call Lidar_PackOutput(RF, InData%lidar) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_UnPackOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(InflowWind_OutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'InflowWind_UnPackOutput'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%VelocityUVW); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AccelUVW); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutput); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DiskVel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HubVel); if (RegCheckErr(RF, RoutineName)) return
   call Lidar_UnpackOutput(RF, OutData%lidar) ! lidar 
end subroutine

subroutine InflowWind_CopyContState(SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg)
   type(InflowWind_ContinuousStateType), intent(in) :: SrcContStateData
   type(InflowWind_ContinuousStateType), intent(inout) :: DstContStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'InflowWind_CopyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstContStateData%DummyContState = SrcContStateData%DummyContState
end subroutine

subroutine InflowWind_DestroyContState(ContStateData, ErrStat, ErrMsg)
   type(InflowWind_ContinuousStateType), intent(inout) :: ContStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'InflowWind_DestroyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine InflowWind_PackContState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(InflowWind_ContinuousStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'InflowWind_PackContState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyContState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_UnPackContState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(InflowWind_ContinuousStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'InflowWind_UnPackContState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyContState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_CopyDiscState(SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg)
   type(InflowWind_DiscreteStateType), intent(in) :: SrcDiscStateData
   type(InflowWind_DiscreteStateType), intent(inout) :: DstDiscStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'InflowWind_CopyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstDiscStateData%DummyDiscState = SrcDiscStateData%DummyDiscState
end subroutine

subroutine InflowWind_DestroyDiscState(DiscStateData, ErrStat, ErrMsg)
   type(InflowWind_DiscreteStateType), intent(inout) :: DiscStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'InflowWind_DestroyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine InflowWind_PackDiscState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(InflowWind_DiscreteStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'InflowWind_PackDiscState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyDiscState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_UnPackDiscState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(InflowWind_DiscreteStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'InflowWind_UnPackDiscState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyDiscState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_CopyConstrState(SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg)
   type(InflowWind_ConstraintStateType), intent(in) :: SrcConstrStateData
   type(InflowWind_ConstraintStateType), intent(inout) :: DstConstrStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'InflowWind_CopyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstConstrStateData%DummyConstrState = SrcConstrStateData%DummyConstrState
end subroutine

subroutine InflowWind_DestroyConstrState(ConstrStateData, ErrStat, ErrMsg)
   type(InflowWind_ConstraintStateType), intent(inout) :: ConstrStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'InflowWind_DestroyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine InflowWind_PackConstrState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(InflowWind_ConstraintStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'InflowWind_PackConstrState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyConstrState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_UnPackConstrState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(InflowWind_ConstraintStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'InflowWind_UnPackConstrState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyConstrState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_CopyOtherState(SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg)
   type(InflowWind_OtherStateType), intent(in) :: SrcOtherStateData
   type(InflowWind_OtherStateType), intent(inout) :: DstOtherStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'InflowWind_CopyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstOtherStateData%DummyOtherState = SrcOtherStateData%DummyOtherState
end subroutine

subroutine InflowWind_DestroyOtherState(OtherStateData, ErrStat, ErrMsg)
   type(InflowWind_OtherStateType), intent(inout) :: OtherStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'InflowWind_DestroyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine InflowWind_PackOtherState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(InflowWind_OtherStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'InflowWind_PackOtherState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyOtherState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_UnPackOtherState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(InflowWind_OtherStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'InflowWind_UnPackOtherState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyOtherState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_CopyMisc(SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg)
   type(InflowWind_MiscVarType), intent(in) :: SrcMiscData
   type(InflowWind_MiscVarType), intent(inout) :: DstMiscData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'InflowWind_CopyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcMiscData%AllOuts)) then
      LB(1:1) = lbound(SrcMiscData%AllOuts)
      UB(1:1) = ubound(SrcMiscData%AllOuts)
      if (.not. allocated(DstMiscData%AllOuts)) then
         allocate(DstMiscData%AllOuts(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%AllOuts.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%AllOuts = SrcMiscData%AllOuts
   end if
   if (allocated(SrcMiscData%WindViUVW)) then
      LB(1:2) = lbound(SrcMiscData%WindViUVW)
      UB(1:2) = ubound(SrcMiscData%WindViUVW)
      if (.not. allocated(DstMiscData%WindViUVW)) then
         allocate(DstMiscData%WindViUVW(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%WindViUVW.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%WindViUVW = SrcMiscData%WindViUVW
   end if
   if (allocated(SrcMiscData%WindAiUVW)) then
      LB(1:2) = lbound(SrcMiscData%WindAiUVW)
      UB(1:2) = ubound(SrcMiscData%WindAiUVW)
      if (.not. allocated(DstMiscData%WindAiUVW)) then
         allocate(DstMiscData%WindAiUVW(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%WindAiUVW.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%WindAiUVW = SrcMiscData%WindAiUVW
   end if
   call InflowWind_CopyInput(SrcMiscData%u_Avg, DstMiscData%u_Avg, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call InflowWind_CopyOutput(SrcMiscData%y_Avg, DstMiscData%y_Avg, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call InflowWind_CopyInput(SrcMiscData%u_Hub, DstMiscData%u_Hub, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call InflowWind_CopyOutput(SrcMiscData%y_Hub, DstMiscData%y_Hub, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine InflowWind_DestroyMisc(MiscData, ErrStat, ErrMsg)
   type(InflowWind_MiscVarType), intent(inout) :: MiscData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'InflowWind_DestroyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(MiscData%AllOuts)) then
      deallocate(MiscData%AllOuts)
   end if
   if (allocated(MiscData%WindViUVW)) then
      deallocate(MiscData%WindViUVW)
   end if
   if (allocated(MiscData%WindAiUVW)) then
      deallocate(MiscData%WindAiUVW)
   end if
   call InflowWind_DestroyInput(MiscData%u_Avg, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call InflowWind_DestroyOutput(MiscData%y_Avg, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call InflowWind_DestroyInput(MiscData%u_Hub, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call InflowWind_DestroyOutput(MiscData%y_Hub, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine InflowWind_PackMisc(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(InflowWind_MiscVarType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'InflowWind_PackMisc'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%AllOuts)
   call RegPackAlloc(RF, InData%WindViUVW)
   call RegPackAlloc(RF, InData%WindAiUVW)
   call InflowWind_PackInput(RF, InData%u_Avg) 
   call InflowWind_PackOutput(RF, InData%y_Avg) 
   call InflowWind_PackInput(RF, InData%u_Hub) 
   call InflowWind_PackOutput(RF, InData%y_Hub) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_UnPackMisc(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(InflowWind_MiscVarType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'InflowWind_UnPackMisc'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%AllOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WindViUVW); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WindAiUVW); if (RegCheckErr(RF, RoutineName)) return
   call InflowWind_UnpackInput(RF, OutData%u_Avg) ! u_Avg 
   call InflowWind_UnpackOutput(RF, OutData%y_Avg) ! y_Avg 
   call InflowWind_UnpackInput(RF, OutData%u_Hub) ! u_Hub 
   call InflowWind_UnpackOutput(RF, OutData%y_Hub) ! y_Hub 
end subroutine

subroutine InflowWind_Input_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
   ! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(InflowWind_InputType), intent(in)  :: u(:) ! Input at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Inputs
   type(InflowWind_InputType), intent(inout)  :: u_out ! Input at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'InflowWind_Input_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(u)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(u)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(u) - 1
   select case (order)
   case (0)
      call InflowWind_CopyInput(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call InflowWind_Input_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call InflowWind_Input_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(u) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE InflowWind_Input_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

   TYPE(InflowWind_InputType), INTENT(IN)  :: u1    ! Input at t1 > t2
   TYPE(InflowWind_InputType), INTENT(IN)  :: u2    ! Input at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Inputs
   TYPE(InflowWind_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'InflowWind_Input_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i02      ! dim2 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   INTEGER                                    :: i2       ! dim2 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   IF (ALLOCATED(u_out%PositionXYZ) .AND. ALLOCATED(u1%PositionXYZ)) THEN
      u_out%PositionXYZ = a1*u1%PositionXYZ + a2*u2%PositionXYZ
   END IF ! check if allocated
   CALL Lidar_Input_ExtrapInterp1( u1%lidar, u2%lidar, tin, u_out%lidar, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   u_out%HubPosition = a1*u1%HubPosition + a2*u2%HubPosition
   u_out%HubOrientation = a1*u1%HubOrientation + a2*u2%HubOrientation
END SUBROUTINE

SUBROUTINE InflowWind_Input_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

   TYPE(InflowWind_InputType), INTENT(IN)  :: u1      ! Input at t1 > t2 > t3
   TYPE(InflowWind_InputType), INTENT(IN)  :: u2      ! Input at t2 > t3
   TYPE(InflowWind_InputType), INTENT(IN)  :: u3      ! Input at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Inputs
   TYPE(InflowWind_InputType), INTENT(INOUT)  :: u_out     ! Input at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'InflowWind_Input_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i02    ! dim2 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   INTEGER                                    :: i2    ! dim2 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   IF (ALLOCATED(u_out%PositionXYZ) .AND. ALLOCATED(u1%PositionXYZ)) THEN
      u_out%PositionXYZ = a1*u1%PositionXYZ + a2*u2%PositionXYZ + a3*u3%PositionXYZ
   END IF ! check if allocated
   CALL Lidar_Input_ExtrapInterp2( u1%lidar, u2%lidar, u3%lidar, tin, u_out%lidar, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   u_out%HubPosition = a1*u1%HubPosition + a2*u2%HubPosition + a3*u3%HubPosition
   u_out%HubOrientation = a1*u1%HubOrientation + a2*u2%HubOrientation + a3*u3%HubOrientation
END SUBROUTINE

subroutine InflowWind_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
   ! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(InflowWind_OutputType), intent(in)  :: y(:) ! Output at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Outputs
   type(InflowWind_OutputType), intent(inout)  :: y_out ! Output at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'InflowWind_Output_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(y)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(y)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(y) - 1
   select case (order)
   case (0)
      call InflowWind_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call InflowWind_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call InflowWind_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(y) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE InflowWind_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

   TYPE(InflowWind_OutputType), INTENT(IN)  :: y1    ! Output at t1 > t2
   TYPE(InflowWind_OutputType), INTENT(IN)  :: y2    ! Output at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
   TYPE(InflowWind_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'InflowWind_Output_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i02      ! dim2 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   INTEGER                                    :: i2       ! dim2 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   IF (ALLOCATED(y_out%VelocityUVW) .AND. ALLOCATED(y1%VelocityUVW)) THEN
      y_out%VelocityUVW = a1*y1%VelocityUVW + a2*y2%VelocityUVW
   END IF ! check if allocated
   IF (ALLOCATED(y_out%AccelUVW) .AND. ALLOCATED(y1%AccelUVW)) THEN
      y_out%AccelUVW = a1*y1%AccelUVW + a2*y2%AccelUVW
   END IF ! check if allocated
   IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
      y_out%WriteOutput = a1*y1%WriteOutput + a2*y2%WriteOutput
   END IF ! check if allocated
   y_out%DiskVel = a1*y1%DiskVel + a2*y2%DiskVel
   y_out%HubVel = a1*y1%HubVel + a2*y2%HubVel
   CALL Lidar_Output_ExtrapInterp1( y1%lidar, y2%lidar, tin, y_out%lidar, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
END SUBROUTINE

SUBROUTINE InflowWind_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

   TYPE(InflowWind_OutputType), INTENT(IN)  :: y1      ! Output at t1 > t2 > t3
   TYPE(InflowWind_OutputType), INTENT(IN)  :: y2      ! Output at t2 > t3
   TYPE(InflowWind_OutputType), INTENT(IN)  :: y3      ! Output at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
   TYPE(InflowWind_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'InflowWind_Output_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i02    ! dim2 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   INTEGER                                    :: i2    ! dim2 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   IF (ALLOCATED(y_out%VelocityUVW) .AND. ALLOCATED(y1%VelocityUVW)) THEN
      y_out%VelocityUVW = a1*y1%VelocityUVW + a2*y2%VelocityUVW + a3*y3%VelocityUVW
   END IF ! check if allocated
   IF (ALLOCATED(y_out%AccelUVW) .AND. ALLOCATED(y1%AccelUVW)) THEN
      y_out%AccelUVW = a1*y1%AccelUVW + a2*y2%AccelUVW + a3*y3%AccelUVW
   END IF ! check if allocated
   IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
      y_out%WriteOutput = a1*y1%WriteOutput + a2*y2%WriteOutput + a3*y3%WriteOutput
   END IF ! check if allocated
   y_out%DiskVel = a1*y1%DiskVel + a2*y2%DiskVel + a3*y3%DiskVel
   y_out%HubVel = a1*y1%HubVel + a2*y2%HubVel + a3*y3%HubVel
   CALL Lidar_Output_ExtrapInterp2( y1%lidar, y2%lidar, y3%lidar, tin, y_out%lidar, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
END SUBROUTINE
END MODULE InflowWind_Types
!ENDOFREGISTRYGENERATEDFILE
