!STARTOFREGISTRYGENERATEDFILE 'InflowWind_IO_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! InflowWind_IO_Types
!.................................................................................................................................
! This file is part of InflowWind_IO.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in InflowWind_IO. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE InflowWind_IO_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE IfW_FlowField_Types
USE NWTC_Library
IMPLICIT NONE
! =========  WindFileDat  =======
  TYPE, PUBLIC :: WindFileDat
    character(1024)  :: FileName      !< Name of the windfile retrieved [-]
    INTEGER(IntKi)  :: WindType = 0      !< Type of the windfile [-]
    REAL(ReKi)  :: RefHt = 0.0_ReKi      !< Reference height given in file [meters]
    LOGICAL  :: RefHt_Set = .false.      !< Reference height was given in file [-]
    REAL(DbKi)  :: DT = 0.0_R8Ki      !< TimeStep of the wind file -- zero value for none [seconds]
    INTEGER(IntKi)  :: NumTSteps = 0_IntKi      !< Number of timesteps in the time range of wind file [-]
    LOGICAL  :: ConstantDT = .false.      !< Timesteps are the same throughout file [-]
    REAL(ReKi) , DIMENSION(1:2)  :: TRange = 0.0_ReKi      !< Time range of the wind file [seconds]
    LOGICAL  :: TRange_Limited = .false.      !< TRange limits strictly enforced [-]
    REAL(ReKi) , DIMENSION(1:2)  :: YRange = 0.0_ReKi      !< Range in y direction [meters]
    LOGICAL  :: YRange_Limited = .false.      !< YRange limits strictly enforced [-]
    REAL(ReKi) , DIMENSION(1:2)  :: ZRange = 0.0_ReKi      !< Range in z direction [meters]
    LOGICAL  :: ZRange_Limited = .false.      !< ZRange limits strictly enforced [-]
    INTEGER(IntKi)  :: BinaryFormat = 0_IntKi      !< Binary format identifier [-]
    LOGICAL  :: IsBinary = .false.      !< Windfile is a binary file [-]
    REAL(ReKi) , DIMENSION(1:3)  :: TI = 0.0_ReKi      !< Turbulence intensity (U,V,W) [-]
    LOGICAL  :: TI_listed = .false.      !< Turbulence intesity given in file [-]
    REAL(ReKi)  :: MWS = 0.0_ReKi      !< Approximate mean wind speed [-]
  END TYPE WindFileDat
! =======================
! =========  Steady_InitInputType  =======
  TYPE, PUBLIC :: Steady_InitInputType
    REAL(ReKi)  :: HWindSpeed = 0.0_ReKi      !< Horizontal wind speed [m/s]
    REAL(ReKi)  :: RefHt = 0.0_ReKi      !< Reference height for horizontal wind speed [meters]
    REAL(ReKi)  :: PLExp = 0.0_ReKi      !< Power law exponent [-]
  END TYPE Steady_InitInputType
! =======================
! =========  Uniform_InitInputType  =======
  TYPE, PUBLIC :: Uniform_InitInputType
    character(1024)  :: WindFileName      !< Name of the wind file to use [-]
    REAL(ReKi)  :: RefHt = 0.0_ReKi      !< Reference height for horizontal wind speed [meters]
    REAL(ReKi)  :: RefLength = 0.0_ReKi      !< Reference length for linear horizontal and vertical sheer [-]
    REAL(ReKi)  :: PropagationDir = 0.0_ReKi      !< Direction of wind propagation [radians]
    LOGICAL  :: UseInputFile = .true.      !< Flag for toggling file based IO in wind type 2. [-]
  END TYPE Uniform_InitInputType
! =======================
! =========  Grid3D_InitInputType  =======
  TYPE, PUBLIC :: Grid3D_InitInputType
    INTEGER(IntKi)  :: ScaleMethod = 0      !< Turbulence scaling method [0=none, 1=direct scaling, 2= calculate scaling factor based on a desired standard deviation] [-]
    REAL(ReKi) , DIMENSION(1:3)  :: SF = 0      !< Turbulence scaling factor for each direction [ScaleMethod=1] [-]
    REAL(ReKi) , DIMENSION(1:3)  :: SigmaF = 0      !< Turbulence standard deviation to calculate scaling from in each direction [ScaleMethod=2] [-]
    INTEGER(IntKi)  :: WindProfileType = -1      !< Wind profile type (0=constant;1=logarithmic;2=power law) [-]
    REAL(ReKi)  :: RefHt = 0      !< Reference (hub) height of the grid [meters]
    REAL(ReKi)  :: URef = 0      !< Mean u-component wind speed at the reference height [meters]
    REAL(ReKi)  :: PLExp = 0      !< Power law exponent (used for PL wind profile type only) [-]
    REAL(ReKi)  :: VLinShr = 0      !< Vertical linear wind shear coefficient (used for vertical linear wind profile type only) [-]
    REAL(ReKi)  :: HLinShr = 0      !< Horizontal linear wind shear coefficient (used for horizontal wind profile type only) [-]
    REAL(ReKi)  :: RefLength = 1      !< Reference (rotor) length of the grid (used for horizontal wind profile type only) [-]
    REAL(ReKi)  :: Z0 = 0      !< Surface roughness length (used for LOG wind profile type only) [-]
    REAL(ReKi)  :: XOffset = 0      !< distance offset for FF wind files [m]
  END TYPE Grid3D_InitInputType
! =======================
! =========  TurbSim_InitInputType  =======
  TYPE, PUBLIC :: TurbSim_InitInputType
    character(1024)  :: WindFileName      !< Name of the wind file to use [-]
  END TYPE TurbSim_InitInputType
! =======================
! =========  Bladed_InitInputType  =======
  TYPE, PUBLIC :: Bladed_InitInputType
    character(1024)  :: WindFileName      !< Root filename [-]
    INTEGER(IntKi)  :: WindType = 0_IntKi      !< Whether this is native Bladed (needs wind profile and TI scaling) or not [-]
    LOGICAL  :: NativeBladedFmt = .false.      !< Whether this is native Bladed (needs wind profile and TI scaling) or not [-]
    LOGICAL  :: TowerFileExist = .false.      !< Tower file exists [-]
    INTEGER(IntKi)  :: TurbineID = 0      !< Wind turbine ID number in the fixed (DEFAULT) file name when FixedWindFileRootName = .TRUE. (used by FAST.Farm) [-]
    LOGICAL  :: FixedWindFileRootName = .false.      !< Do the wind data files have a fixed (DEFAULT) file name? (used by FAST.Farm) [-]
  END TYPE Bladed_InitInputType
! =======================
! =========  Bladed_InitOutputType  =======
  TYPE, PUBLIC :: Bladed_InitOutputType
    REAL(ReKi)  :: PropagationDir = 0.0_ReKi      !< Propogation direction from native Bladed format [degrees]
    REAL(ReKi)  :: VFlowAngle = 0.0_ReKi      !< Vertical flow angle from native Bladed format [degrees]
  END TYPE Bladed_InitOutputType
! =======================
! =========  HAWC_InitInputType  =======
  TYPE, PUBLIC :: HAWC_InitInputType
    character(1024) , DIMENSION(1:3)  :: WindFileName      !< Name of the wind file to use [-]
    INTEGER(IntKi)  :: nx = 0      !< Number of grids in the x direction (in the 3 files above) [-]
    INTEGER(IntKi)  :: ny = 0      !< Number of grids in the y direction (in the 3 files above) [-]
    INTEGER(IntKi)  :: nz = 0      !< Number of grids in the z direction (in the 3 files above) [-]
    REAL(ReKi)  :: dx = 0      !< size of grids in the x direction (in the 3 files above) [-]
    REAL(ReKi)  :: dy = 0      !< size of grids in the y direction (in the 3 files above) [-]
    REAL(ReKi)  :: dz = 0      !< size of grids in the z direction (in the 3 files above) [-]
    TYPE(Grid3D_InitInputType)  :: G3D      !< Grid3D initialization input [-]
  END TYPE HAWC_InitInputType
! =======================
! =========  User_InitInputType  =======
  TYPE, PUBLIC :: User_InitInputType
    REAL(SiKi)  :: Dummy = 0.0_R4Ki      !< User field initialization input dummy value [-]
  END TYPE User_InitInputType
! =======================
! =========  Grid4D_InitInputType  =======
  TYPE, PUBLIC :: Grid4D_InitInputType
    INTEGER(IntKi) , DIMENSION(1:4)  :: n = 0_IntKi      !< number of grid points in the x, y, z, and t directions [-]
    REAL(ReKi) , DIMENSION(1:4)  :: delta = 0.0_ReKi      !< size between 2 consecutive grid points in each grid direction [m,m,m,s]
    REAL(ReKi) , DIMENSION(1:3)  :: pZero = 0.0_ReKi      !< fixed position of the XYZ grid (i.e., XYZ coordinates of m%V(:,1,1,1,:)) [m]
    REAL(SiKi) , DIMENSION(:,:,:,:,:), POINTER  :: Vel => NULL()      !< pointer to 4D grid velocity data [m/s]
  END TYPE Grid4D_InitInputType
! =======================
! =========  Points_InitInputType  =======
  TYPE, PUBLIC :: Points_InitInputType
    INTEGER(IntKi)  :: NumWindPoints = 0_IntKi      !< Number of points where wind components will be provided [-]
  END TYPE Points_InitInputType
! =======================
CONTAINS

subroutine InflowWind_IO_CopyWindFileDat(SrcWindFileDatData, DstWindFileDatData, CtrlCode, ErrStat, ErrMsg)
   type(WindFileDat), intent(in) :: SrcWindFileDatData
   type(WindFileDat), intent(inout) :: DstWindFileDatData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'InflowWind_IO_CopyWindFileDat'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstWindFileDatData%FileName = SrcWindFileDatData%FileName
   DstWindFileDatData%WindType = SrcWindFileDatData%WindType
   DstWindFileDatData%RefHt = SrcWindFileDatData%RefHt
   DstWindFileDatData%RefHt_Set = SrcWindFileDatData%RefHt_Set
   DstWindFileDatData%DT = SrcWindFileDatData%DT
   DstWindFileDatData%NumTSteps = SrcWindFileDatData%NumTSteps
   DstWindFileDatData%ConstantDT = SrcWindFileDatData%ConstantDT
   DstWindFileDatData%TRange = SrcWindFileDatData%TRange
   DstWindFileDatData%TRange_Limited = SrcWindFileDatData%TRange_Limited
   DstWindFileDatData%YRange = SrcWindFileDatData%YRange
   DstWindFileDatData%YRange_Limited = SrcWindFileDatData%YRange_Limited
   DstWindFileDatData%ZRange = SrcWindFileDatData%ZRange
   DstWindFileDatData%ZRange_Limited = SrcWindFileDatData%ZRange_Limited
   DstWindFileDatData%BinaryFormat = SrcWindFileDatData%BinaryFormat
   DstWindFileDatData%IsBinary = SrcWindFileDatData%IsBinary
   DstWindFileDatData%TI = SrcWindFileDatData%TI
   DstWindFileDatData%TI_listed = SrcWindFileDatData%TI_listed
   DstWindFileDatData%MWS = SrcWindFileDatData%MWS
end subroutine

subroutine InflowWind_IO_DestroyWindFileDat(WindFileDatData, ErrStat, ErrMsg)
   type(WindFileDat), intent(inout) :: WindFileDatData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'InflowWind_IO_DestroyWindFileDat'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine InflowWind_IO_PackWindFileDat(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(WindFileDat), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'InflowWind_IO_PackWindFileDat'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%FileName)
   call RegPack(RF, InData%WindType)
   call RegPack(RF, InData%RefHt)
   call RegPack(RF, InData%RefHt_Set)
   call RegPack(RF, InData%DT)
   call RegPack(RF, InData%NumTSteps)
   call RegPack(RF, InData%ConstantDT)
   call RegPack(RF, InData%TRange)
   call RegPack(RF, InData%TRange_Limited)
   call RegPack(RF, InData%YRange)
   call RegPack(RF, InData%YRange_Limited)
   call RegPack(RF, InData%ZRange)
   call RegPack(RF, InData%ZRange_Limited)
   call RegPack(RF, InData%BinaryFormat)
   call RegPack(RF, InData%IsBinary)
   call RegPack(RF, InData%TI)
   call RegPack(RF, InData%TI_listed)
   call RegPack(RF, InData%MWS)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_IO_UnPackWindFileDat(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(WindFileDat), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'InflowWind_IO_UnPackWindFileDat'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%FileName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WindType); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RefHt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RefHt_Set); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumTSteps); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ConstantDT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TRange); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TRange_Limited); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YRange); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YRange_Limited); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ZRange); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ZRange_Limited); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BinaryFormat); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%IsBinary); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TI); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TI_listed); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MWS); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_IO_CopySteady_InitInputType(SrcSteady_InitInputTypeData, DstSteady_InitInputTypeData, CtrlCode, ErrStat, ErrMsg)
   type(Steady_InitInputType), intent(in) :: SrcSteady_InitInputTypeData
   type(Steady_InitInputType), intent(inout) :: DstSteady_InitInputTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'InflowWind_IO_CopySteady_InitInputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstSteady_InitInputTypeData%HWindSpeed = SrcSteady_InitInputTypeData%HWindSpeed
   DstSteady_InitInputTypeData%RefHt = SrcSteady_InitInputTypeData%RefHt
   DstSteady_InitInputTypeData%PLExp = SrcSteady_InitInputTypeData%PLExp
end subroutine

subroutine InflowWind_IO_DestroySteady_InitInputType(Steady_InitInputTypeData, ErrStat, ErrMsg)
   type(Steady_InitInputType), intent(inout) :: Steady_InitInputTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'InflowWind_IO_DestroySteady_InitInputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine InflowWind_IO_PackSteady_InitInputType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Steady_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'InflowWind_IO_PackSteady_InitInputType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%HWindSpeed)
   call RegPack(RF, InData%RefHt)
   call RegPack(RF, InData%PLExp)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_IO_UnPackSteady_InitInputType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Steady_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'InflowWind_IO_UnPackSteady_InitInputType'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%HWindSpeed); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RefHt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PLExp); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_IO_CopyUniform_InitInputType(SrcUniform_InitInputTypeData, DstUniform_InitInputTypeData, CtrlCode, ErrStat, ErrMsg)
   type(Uniform_InitInputType), intent(in) :: SrcUniform_InitInputTypeData
   type(Uniform_InitInputType), intent(inout) :: DstUniform_InitInputTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'InflowWind_IO_CopyUniform_InitInputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstUniform_InitInputTypeData%WindFileName = SrcUniform_InitInputTypeData%WindFileName
   DstUniform_InitInputTypeData%RefHt = SrcUniform_InitInputTypeData%RefHt
   DstUniform_InitInputTypeData%RefLength = SrcUniform_InitInputTypeData%RefLength
   DstUniform_InitInputTypeData%PropagationDir = SrcUniform_InitInputTypeData%PropagationDir
   DstUniform_InitInputTypeData%UseInputFile = SrcUniform_InitInputTypeData%UseInputFile
end subroutine

subroutine InflowWind_IO_DestroyUniform_InitInputType(Uniform_InitInputTypeData, ErrStat, ErrMsg)
   type(Uniform_InitInputType), intent(inout) :: Uniform_InitInputTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'InflowWind_IO_DestroyUniform_InitInputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine InflowWind_IO_PackUniform_InitInputType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Uniform_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'InflowWind_IO_PackUniform_InitInputType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%WindFileName)
   call RegPack(RF, InData%RefHt)
   call RegPack(RF, InData%RefLength)
   call RegPack(RF, InData%PropagationDir)
   call RegPack(RF, InData%UseInputFile)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_IO_UnPackUniform_InitInputType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Uniform_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'InflowWind_IO_UnPackUniform_InitInputType'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%WindFileName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RefHt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RefLength); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PropagationDir); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UseInputFile); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_IO_CopyGrid3D_InitInputType(SrcGrid3D_InitInputTypeData, DstGrid3D_InitInputTypeData, CtrlCode, ErrStat, ErrMsg)
   type(Grid3D_InitInputType), intent(in) :: SrcGrid3D_InitInputTypeData
   type(Grid3D_InitInputType), intent(inout) :: DstGrid3D_InitInputTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'InflowWind_IO_CopyGrid3D_InitInputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstGrid3D_InitInputTypeData%ScaleMethod = SrcGrid3D_InitInputTypeData%ScaleMethod
   DstGrid3D_InitInputTypeData%SF = SrcGrid3D_InitInputTypeData%SF
   DstGrid3D_InitInputTypeData%SigmaF = SrcGrid3D_InitInputTypeData%SigmaF
   DstGrid3D_InitInputTypeData%WindProfileType = SrcGrid3D_InitInputTypeData%WindProfileType
   DstGrid3D_InitInputTypeData%RefHt = SrcGrid3D_InitInputTypeData%RefHt
   DstGrid3D_InitInputTypeData%URef = SrcGrid3D_InitInputTypeData%URef
   DstGrid3D_InitInputTypeData%PLExp = SrcGrid3D_InitInputTypeData%PLExp
   DstGrid3D_InitInputTypeData%VLinShr = SrcGrid3D_InitInputTypeData%VLinShr
   DstGrid3D_InitInputTypeData%HLinShr = SrcGrid3D_InitInputTypeData%HLinShr
   DstGrid3D_InitInputTypeData%RefLength = SrcGrid3D_InitInputTypeData%RefLength
   DstGrid3D_InitInputTypeData%Z0 = SrcGrid3D_InitInputTypeData%Z0
   DstGrid3D_InitInputTypeData%XOffset = SrcGrid3D_InitInputTypeData%XOffset
end subroutine

subroutine InflowWind_IO_DestroyGrid3D_InitInputType(Grid3D_InitInputTypeData, ErrStat, ErrMsg)
   type(Grid3D_InitInputType), intent(inout) :: Grid3D_InitInputTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'InflowWind_IO_DestroyGrid3D_InitInputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine InflowWind_IO_PackGrid3D_InitInputType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Grid3D_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'InflowWind_IO_PackGrid3D_InitInputType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%ScaleMethod)
   call RegPack(RF, InData%SF)
   call RegPack(RF, InData%SigmaF)
   call RegPack(RF, InData%WindProfileType)
   call RegPack(RF, InData%RefHt)
   call RegPack(RF, InData%URef)
   call RegPack(RF, InData%PLExp)
   call RegPack(RF, InData%VLinShr)
   call RegPack(RF, InData%HLinShr)
   call RegPack(RF, InData%RefLength)
   call RegPack(RF, InData%Z0)
   call RegPack(RF, InData%XOffset)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_IO_UnPackGrid3D_InitInputType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Grid3D_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'InflowWind_IO_UnPackGrid3D_InitInputType'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%ScaleMethod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SigmaF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WindProfileType); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RefHt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%URef); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PLExp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VLinShr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HLinShr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RefLength); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Z0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%XOffset); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_IO_CopyTurbSim_InitInputType(SrcTurbSim_InitInputTypeData, DstTurbSim_InitInputTypeData, CtrlCode, ErrStat, ErrMsg)
   type(TurbSim_InitInputType), intent(in) :: SrcTurbSim_InitInputTypeData
   type(TurbSim_InitInputType), intent(inout) :: DstTurbSim_InitInputTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'InflowWind_IO_CopyTurbSim_InitInputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstTurbSim_InitInputTypeData%WindFileName = SrcTurbSim_InitInputTypeData%WindFileName
end subroutine

subroutine InflowWind_IO_DestroyTurbSim_InitInputType(TurbSim_InitInputTypeData, ErrStat, ErrMsg)
   type(TurbSim_InitInputType), intent(inout) :: TurbSim_InitInputTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'InflowWind_IO_DestroyTurbSim_InitInputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine InflowWind_IO_PackTurbSim_InitInputType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(TurbSim_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'InflowWind_IO_PackTurbSim_InitInputType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%WindFileName)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_IO_UnPackTurbSim_InitInputType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(TurbSim_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'InflowWind_IO_UnPackTurbSim_InitInputType'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%WindFileName); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_IO_CopyBladed_InitInputType(SrcBladed_InitInputTypeData, DstBladed_InitInputTypeData, CtrlCode, ErrStat, ErrMsg)
   type(Bladed_InitInputType), intent(in) :: SrcBladed_InitInputTypeData
   type(Bladed_InitInputType), intent(inout) :: DstBladed_InitInputTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'InflowWind_IO_CopyBladed_InitInputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstBladed_InitInputTypeData%WindFileName = SrcBladed_InitInputTypeData%WindFileName
   DstBladed_InitInputTypeData%WindType = SrcBladed_InitInputTypeData%WindType
   DstBladed_InitInputTypeData%NativeBladedFmt = SrcBladed_InitInputTypeData%NativeBladedFmt
   DstBladed_InitInputTypeData%TowerFileExist = SrcBladed_InitInputTypeData%TowerFileExist
   DstBladed_InitInputTypeData%TurbineID = SrcBladed_InitInputTypeData%TurbineID
   DstBladed_InitInputTypeData%FixedWindFileRootName = SrcBladed_InitInputTypeData%FixedWindFileRootName
end subroutine

subroutine InflowWind_IO_DestroyBladed_InitInputType(Bladed_InitInputTypeData, ErrStat, ErrMsg)
   type(Bladed_InitInputType), intent(inout) :: Bladed_InitInputTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'InflowWind_IO_DestroyBladed_InitInputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine InflowWind_IO_PackBladed_InitInputType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Bladed_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'InflowWind_IO_PackBladed_InitInputType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%WindFileName)
   call RegPack(RF, InData%WindType)
   call RegPack(RF, InData%NativeBladedFmt)
   call RegPack(RF, InData%TowerFileExist)
   call RegPack(RF, InData%TurbineID)
   call RegPack(RF, InData%FixedWindFileRootName)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_IO_UnPackBladed_InitInputType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Bladed_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'InflowWind_IO_UnPackBladed_InitInputType'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%WindFileName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WindType); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NativeBladedFmt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TowerFileExist); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TurbineID); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FixedWindFileRootName); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_IO_CopyBladed_InitOutputType(SrcBladed_InitOutputTypeData, DstBladed_InitOutputTypeData, CtrlCode, ErrStat, ErrMsg)
   type(Bladed_InitOutputType), intent(in) :: SrcBladed_InitOutputTypeData
   type(Bladed_InitOutputType), intent(inout) :: DstBladed_InitOutputTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'InflowWind_IO_CopyBladed_InitOutputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstBladed_InitOutputTypeData%PropagationDir = SrcBladed_InitOutputTypeData%PropagationDir
   DstBladed_InitOutputTypeData%VFlowAngle = SrcBladed_InitOutputTypeData%VFlowAngle
end subroutine

subroutine InflowWind_IO_DestroyBladed_InitOutputType(Bladed_InitOutputTypeData, ErrStat, ErrMsg)
   type(Bladed_InitOutputType), intent(inout) :: Bladed_InitOutputTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'InflowWind_IO_DestroyBladed_InitOutputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine InflowWind_IO_PackBladed_InitOutputType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Bladed_InitOutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'InflowWind_IO_PackBladed_InitOutputType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%PropagationDir)
   call RegPack(RF, InData%VFlowAngle)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_IO_UnPackBladed_InitOutputType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Bladed_InitOutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'InflowWind_IO_UnPackBladed_InitOutputType'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%PropagationDir); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VFlowAngle); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_IO_CopyHAWC_InitInputType(SrcHAWC_InitInputTypeData, DstHAWC_InitInputTypeData, CtrlCode, ErrStat, ErrMsg)
   type(HAWC_InitInputType), intent(in) :: SrcHAWC_InitInputTypeData
   type(HAWC_InitInputType), intent(inout) :: DstHAWC_InitInputTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'InflowWind_IO_CopyHAWC_InitInputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstHAWC_InitInputTypeData%WindFileName = SrcHAWC_InitInputTypeData%WindFileName
   DstHAWC_InitInputTypeData%nx = SrcHAWC_InitInputTypeData%nx
   DstHAWC_InitInputTypeData%ny = SrcHAWC_InitInputTypeData%ny
   DstHAWC_InitInputTypeData%nz = SrcHAWC_InitInputTypeData%nz
   DstHAWC_InitInputTypeData%dx = SrcHAWC_InitInputTypeData%dx
   DstHAWC_InitInputTypeData%dy = SrcHAWC_InitInputTypeData%dy
   DstHAWC_InitInputTypeData%dz = SrcHAWC_InitInputTypeData%dz
   call InflowWind_IO_CopyGrid3D_InitInputType(SrcHAWC_InitInputTypeData%G3D, DstHAWC_InitInputTypeData%G3D, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine InflowWind_IO_DestroyHAWC_InitInputType(HAWC_InitInputTypeData, ErrStat, ErrMsg)
   type(HAWC_InitInputType), intent(inout) :: HAWC_InitInputTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'InflowWind_IO_DestroyHAWC_InitInputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call InflowWind_IO_DestroyGrid3D_InitInputType(HAWC_InitInputTypeData%G3D, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine InflowWind_IO_PackHAWC_InitInputType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(HAWC_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'InflowWind_IO_PackHAWC_InitInputType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%WindFileName)
   call RegPack(RF, InData%nx)
   call RegPack(RF, InData%ny)
   call RegPack(RF, InData%nz)
   call RegPack(RF, InData%dx)
   call RegPack(RF, InData%dy)
   call RegPack(RF, InData%dz)
   call InflowWind_IO_PackGrid3D_InitInputType(RF, InData%G3D) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_IO_UnPackHAWC_InitInputType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(HAWC_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'InflowWind_IO_UnPackHAWC_InitInputType'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%WindFileName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ny); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nz); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dy); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dz); if (RegCheckErr(RF, RoutineName)) return
   call InflowWind_IO_UnpackGrid3D_InitInputType(RF, OutData%G3D) ! G3D 
end subroutine

subroutine InflowWind_IO_CopyUser_InitInputType(SrcUser_InitInputTypeData, DstUser_InitInputTypeData, CtrlCode, ErrStat, ErrMsg)
   type(User_InitInputType), intent(in) :: SrcUser_InitInputTypeData
   type(User_InitInputType), intent(inout) :: DstUser_InitInputTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'InflowWind_IO_CopyUser_InitInputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstUser_InitInputTypeData%Dummy = SrcUser_InitInputTypeData%Dummy
end subroutine

subroutine InflowWind_IO_DestroyUser_InitInputType(User_InitInputTypeData, ErrStat, ErrMsg)
   type(User_InitInputType), intent(inout) :: User_InitInputTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'InflowWind_IO_DestroyUser_InitInputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine InflowWind_IO_PackUser_InitInputType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(User_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'InflowWind_IO_PackUser_InitInputType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%Dummy)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_IO_UnPackUser_InitInputType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(User_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'InflowWind_IO_UnPackUser_InitInputType'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%Dummy); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_IO_CopyGrid4D_InitInputType(SrcGrid4D_InitInputTypeData, DstGrid4D_InitInputTypeData, CtrlCode, ErrStat, ErrMsg)
   type(Grid4D_InitInputType), intent(in) :: SrcGrid4D_InitInputTypeData
   type(Grid4D_InitInputType), intent(inout) :: DstGrid4D_InitInputTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(5), UB(5)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'InflowWind_IO_CopyGrid4D_InitInputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstGrid4D_InitInputTypeData%n = SrcGrid4D_InitInputTypeData%n
   DstGrid4D_InitInputTypeData%delta = SrcGrid4D_InitInputTypeData%delta
   DstGrid4D_InitInputTypeData%pZero = SrcGrid4D_InitInputTypeData%pZero
   DstGrid4D_InitInputTypeData%Vel => SrcGrid4D_InitInputTypeData%Vel
end subroutine

subroutine InflowWind_IO_DestroyGrid4D_InitInputType(Grid4D_InitInputTypeData, ErrStat, ErrMsg)
   type(Grid4D_InitInputType), intent(inout) :: Grid4D_InitInputTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'InflowWind_IO_DestroyGrid4D_InitInputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   nullify(Grid4D_InitInputTypeData%Vel)
end subroutine

subroutine InflowWind_IO_PackGrid4D_InitInputType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Grid4D_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'InflowWind_IO_PackGrid4D_InitInputType'
   logical         :: PtrInIndex
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%n)
   call RegPack(RF, InData%delta)
   call RegPack(RF, InData%pZero)
   call RegPackPtr(RF, InData%Vel)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_IO_UnPackGrid4D_InitInputType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Grid4D_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'InflowWind_IO_UnPackGrid4D_InitInputType'
   integer(B4Ki)   :: LB(5), UB(5)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   integer(B8Ki)   :: PtrIdx
   type(c_ptr)     :: Ptr
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%n); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%delta); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%pZero); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackPtr(RF, OutData%Vel, LB, UB); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_IO_CopyPoints_InitInputType(SrcPoints_InitInputTypeData, DstPoints_InitInputTypeData, CtrlCode, ErrStat, ErrMsg)
   type(Points_InitInputType), intent(in) :: SrcPoints_InitInputTypeData
   type(Points_InitInputType), intent(inout) :: DstPoints_InitInputTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'InflowWind_IO_CopyPoints_InitInputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstPoints_InitInputTypeData%NumWindPoints = SrcPoints_InitInputTypeData%NumWindPoints
end subroutine

subroutine InflowWind_IO_DestroyPoints_InitInputType(Points_InitInputTypeData, ErrStat, ErrMsg)
   type(Points_InitInputType), intent(inout) :: Points_InitInputTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'InflowWind_IO_DestroyPoints_InitInputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine InflowWind_IO_PackPoints_InitInputType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Points_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'InflowWind_IO_PackPoints_InitInputType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%NumWindPoints)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_IO_UnPackPoints_InitInputType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Points_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'InflowWind_IO_UnPackPoints_InitInputType'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%NumWindPoints); if (RegCheckErr(RF, RoutineName)) return
end subroutine
END MODULE InflowWind_IO_Types
!ENDOFREGISTRYGENERATEDFILE
