!STARTOFREGISTRYGENERATEDFILE 'InflowWind_Driver_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! InflowWind_Driver_Types
!.................................................................................................................................
! This file is part of InflowWind_Driver.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in InflowWind_Driver. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE InflowWind_Driver_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE NWTC_Library
IMPLICIT NONE
! =========  OutputFile  =======
  TYPE, PUBLIC :: OutputFile
    character(1024)  :: Name      !< Filename for output from points read in from points file [-]
    INTEGER(IntKi)  :: Unit = -1      !< Unit number for the output file for the Points file output [-]
    LOGICAL  :: Initialized = .false.      !< Flag indicating that file has been initialized [-]
  END TYPE OutputFile
! =======================
! =========  IfWDriver_Flags  =======
  TYPE, PUBLIC :: IfWDriver_Flags
    LOGICAL  :: DvrIptFile = .false.      !< Was an input file name given on the command line? [-]
    LOGICAL  :: IfWIptFile = .false.      !< Was an InflowWind input file requested? [-]
    LOGICAL  :: Summary = .false.      !< create a summary at command line? (data extents in the wind file) [-]
    LOGICAL  :: SummaryFile = .false.      !< create a summary file of the output? [-]
    LOGICAL  :: TStart = .false.      !< specified a start time [-]
    LOGICAL  :: NumTimeSteps = .false.      !< specified a number of timesteps to process [-]
    LOGICAL  :: NumTimeStepsDefault = .false.      !< specified a 'DEFAULT' for number of timesteps to process [-]
    LOGICAL  :: DT = .false.      !< specified a resolution in time [-]
    LOGICAL  :: DTDefault = .false.      !< specified a 'DEFAULT' for the time resolution [-]
    LOGICAL  :: FFTcalc = .false.      !< do an FFT [-]
    LOGICAL  :: WindGrid = .false.      !< Requested output of wind data on a grid -- input file option only [-]
    LOGICAL  :: XRange = .false.      !< specified a range of x      -- command line option only -- stored as GridCtrCoord and GridDelta [-]
    LOGICAL  :: YRange = .false.      !< specified a range of y      -- command line option only -- stored as GridCtrCoord and GridDelta [-]
    LOGICAL  :: ZRange = .false.      !< specified a range of z      -- command line option only -- stored as GridCtrCoord and GridDelta [-]
    LOGICAL  :: Dx = .false.      !< specified a resolution in x -- command line option only, 0.0 otherwise [-]
    LOGICAL  :: Dy = .false.      !< speficied a resolution in y [-]
    LOGICAL  :: Dz = .false.      !< specified a resolution in z [-]
    LOGICAL  :: PointsFile = .false.      !< points filename to read in [-]
    LOGICAL  :: OutputAccel = .false.      !< flag to calculate and output wind acceleration in addition to velocity [-]
    LOGICAL  :: Verbose = .false.      !< Verbose error reporting [-]
    LOGICAL  :: VVerbose = .false.      !< Very Verbose error reporting [-]
    LOGICAL  :: BoxExceedAllowF = .false.      !< set flag to allow exceeding wind box boundaries for FF files (for diagnostic purposes) [-]
    LOGICAL  :: WrHAWC = .false.      !< Requested file conversion to HAWC2 format? [-]
    LOGICAL  :: WrBladed = .false.      !< Requested file conversion to Bladed format? [-]
    LOGICAL  :: WrVTK = .false.      !< Requested file output as VTK? [-]
    LOGICAL  :: WrUniform = .false.      !< Requested file output as Uniform wind format? [-]
    LOGICAL  :: XYslice = .false.      !< Take XY slice at one elevation [-]
  END TYPE IfWDriver_Flags
! =======================
! =========  IfWDriver_Settings  =======
  TYPE, PUBLIC :: IfWDriver_Settings
    character(1024)  :: DvrIptFileName      !< Driver input file name [-]
    character(1024)  :: IfWIptFileName      !< Filename of InflowWind input file to read (if no driver input file) [-]
    character(1024)  :: SummaryFileName      !< Filename for the summary information output [-]
    character(1024)  :: PointsFileName      !< Filename of points file to read in [-]
    INTEGER(IntKi)  :: NumTimeSteps = 0      !< Number of timesteps [-]
    REAL(DbKi)  :: DT = 0.0_DbKi      !< resolution of time [s]
    REAL(DbKi)  :: TStart = 0.0_DbKi      !< range of time -- end time converted from TRange (command line option only) [s]
    REAL(ReKi)  :: FFTcoord(1:3) = 0.0_ReKi      !< (x,y,z) coordinate to do an FFT at [(m)]
    REAL(ReKi)  :: GridDelta(1:3) = 0.0_ReKi      !< (GridDx,GridDy,GridDz) -- grid point spacing [(m)]
    INTEGER(IntKi)  :: GridN(1:3) = 1_IntKi      !< (GridNx,GridNy,GridNz) -- number of grid points [-]
    REAL(ReKi)  :: XRange(1:2) = 0.0_ReKi      !< Range in the x-direction for the gridded data [(m)]
    REAL(ReKi)  :: YRange(1:2) = 0.0_ReKi      !< Range in the y-direction for the gridded data [(m)]
    REAL(ReKi)  :: ZRange(1:2) = 0.0_ReKi      !< Range in the z-direction for the gridded data [(m)]
    TYPE(ProgDesc)  :: ProgInfo      !< Program info [-]
    TYPE(OutputFile)  :: WindGridOutput      !< Wind grid file handling [-]
    TYPE(OutputFile)  :: FFTOutput      !< FFT file handling [-]
    TYPE(OutputFile)  :: PointsVelOutput      !< Points output velocity file handling [-]
    INTEGER(IntKi)  :: NOutWindXY = 0      !< Number of XY planes for output <RootName>.XY<loc>.t<n>.vtk [0 to 9] [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: OutWindZ      !< Z coordinates of XY planes for output [1 to NOutWindXY] [unused for NOutWindXY=0] [(m)]
    INTEGER(IntKi)  :: NOutWindXZ = 0      !< Number of YZ planes for output <RootName>.YZ<loc>.t<n>.vtk [0 to 9] [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: OutWindY      !< Y coordinates of YZ planes for output [1 to NOutWindYZ] [unused for NOutWindYZ=0] [(m)]
    INTEGER(IntKi)  :: NOutWindYZ = 0      !< Number of YZ planes for output <RootName>.YZ<loc>.t<n>.vtk [0 to 9] [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: OutWindX      !< X coordinates of YZ planes for output [1 to NOutWindYZ] [unused for NOutWindYZ=0] [(m)]
  END TYPE IfWDriver_Settings
! =======================
CONTAINS

subroutine InflowWind_Driver_CopyOutputFile(SrcOutputFileData, DstOutputFileData, CtrlCode, ErrStat, ErrMsg)
   type(OutputFile), intent(in) :: SrcOutputFileData
   type(OutputFile), intent(inout) :: DstOutputFileData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'InflowWind_Driver_CopyOutputFile'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstOutputFileData%Name = SrcOutputFileData%Name
   DstOutputFileData%Unit = SrcOutputFileData%Unit
   DstOutputFileData%Initialized = SrcOutputFileData%Initialized
end subroutine

subroutine InflowWind_Driver_DestroyOutputFile(OutputFileData, ErrStat, ErrMsg)
   type(OutputFile), intent(inout) :: OutputFileData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'InflowWind_Driver_DestroyOutputFile'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine InflowWind_Driver_PackOutputFile(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(OutputFile), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'InflowWind_Driver_PackOutputFile'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%Name)
   call RegPack(RF, InData%Unit)
   call RegPack(RF, InData%Initialized)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_Driver_UnPackOutputFile(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(OutputFile), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'InflowWind_Driver_UnPackOutputFile'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%Name); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Unit); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Initialized); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_Driver_CopyIfWDriver_Flags(SrcIfWDriver_FlagsData, DstIfWDriver_FlagsData, CtrlCode, ErrStat, ErrMsg)
   type(IfWDriver_Flags), intent(in) :: SrcIfWDriver_FlagsData
   type(IfWDriver_Flags), intent(inout) :: DstIfWDriver_FlagsData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'InflowWind_Driver_CopyIfWDriver_Flags'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstIfWDriver_FlagsData%DvrIptFile = SrcIfWDriver_FlagsData%DvrIptFile
   DstIfWDriver_FlagsData%IfWIptFile = SrcIfWDriver_FlagsData%IfWIptFile
   DstIfWDriver_FlagsData%Summary = SrcIfWDriver_FlagsData%Summary
   DstIfWDriver_FlagsData%SummaryFile = SrcIfWDriver_FlagsData%SummaryFile
   DstIfWDriver_FlagsData%TStart = SrcIfWDriver_FlagsData%TStart
   DstIfWDriver_FlagsData%NumTimeSteps = SrcIfWDriver_FlagsData%NumTimeSteps
   DstIfWDriver_FlagsData%NumTimeStepsDefault = SrcIfWDriver_FlagsData%NumTimeStepsDefault
   DstIfWDriver_FlagsData%DT = SrcIfWDriver_FlagsData%DT
   DstIfWDriver_FlagsData%DTDefault = SrcIfWDriver_FlagsData%DTDefault
   DstIfWDriver_FlagsData%FFTcalc = SrcIfWDriver_FlagsData%FFTcalc
   DstIfWDriver_FlagsData%WindGrid = SrcIfWDriver_FlagsData%WindGrid
   DstIfWDriver_FlagsData%XRange = SrcIfWDriver_FlagsData%XRange
   DstIfWDriver_FlagsData%YRange = SrcIfWDriver_FlagsData%YRange
   DstIfWDriver_FlagsData%ZRange = SrcIfWDriver_FlagsData%ZRange
   DstIfWDriver_FlagsData%Dx = SrcIfWDriver_FlagsData%Dx
   DstIfWDriver_FlagsData%Dy = SrcIfWDriver_FlagsData%Dy
   DstIfWDriver_FlagsData%Dz = SrcIfWDriver_FlagsData%Dz
   DstIfWDriver_FlagsData%PointsFile = SrcIfWDriver_FlagsData%PointsFile
   DstIfWDriver_FlagsData%OutputAccel = SrcIfWDriver_FlagsData%OutputAccel
   DstIfWDriver_FlagsData%Verbose = SrcIfWDriver_FlagsData%Verbose
   DstIfWDriver_FlagsData%VVerbose = SrcIfWDriver_FlagsData%VVerbose
   DstIfWDriver_FlagsData%BoxExceedAllowF = SrcIfWDriver_FlagsData%BoxExceedAllowF
   DstIfWDriver_FlagsData%WrHAWC = SrcIfWDriver_FlagsData%WrHAWC
   DstIfWDriver_FlagsData%WrBladed = SrcIfWDriver_FlagsData%WrBladed
   DstIfWDriver_FlagsData%WrVTK = SrcIfWDriver_FlagsData%WrVTK
   DstIfWDriver_FlagsData%WrUniform = SrcIfWDriver_FlagsData%WrUniform
   DstIfWDriver_FlagsData%XYslice = SrcIfWDriver_FlagsData%XYslice
end subroutine

subroutine InflowWind_Driver_DestroyIfWDriver_Flags(IfWDriver_FlagsData, ErrStat, ErrMsg)
   type(IfWDriver_Flags), intent(inout) :: IfWDriver_FlagsData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'InflowWind_Driver_DestroyIfWDriver_Flags'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine InflowWind_Driver_PackIfWDriver_Flags(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(IfWDriver_Flags), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'InflowWind_Driver_PackIfWDriver_Flags'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DvrIptFile)
   call RegPack(RF, InData%IfWIptFile)
   call RegPack(RF, InData%Summary)
   call RegPack(RF, InData%SummaryFile)
   call RegPack(RF, InData%TStart)
   call RegPack(RF, InData%NumTimeSteps)
   call RegPack(RF, InData%NumTimeStepsDefault)
   call RegPack(RF, InData%DT)
   call RegPack(RF, InData%DTDefault)
   call RegPack(RF, InData%FFTcalc)
   call RegPack(RF, InData%WindGrid)
   call RegPack(RF, InData%XRange)
   call RegPack(RF, InData%YRange)
   call RegPack(RF, InData%ZRange)
   call RegPack(RF, InData%Dx)
   call RegPack(RF, InData%Dy)
   call RegPack(RF, InData%Dz)
   call RegPack(RF, InData%PointsFile)
   call RegPack(RF, InData%OutputAccel)
   call RegPack(RF, InData%Verbose)
   call RegPack(RF, InData%VVerbose)
   call RegPack(RF, InData%BoxExceedAllowF)
   call RegPack(RF, InData%WrHAWC)
   call RegPack(RF, InData%WrBladed)
   call RegPack(RF, InData%WrVTK)
   call RegPack(RF, InData%WrUniform)
   call RegPack(RF, InData%XYslice)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_Driver_UnPackIfWDriver_Flags(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(IfWDriver_Flags), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'InflowWind_Driver_UnPackIfWDriver_Flags'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DvrIptFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%IfWIptFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Summary); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SummaryFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TStart); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumTimeSteps); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumTimeStepsDefault); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DTDefault); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FFTcalc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WindGrid); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%XRange); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YRange); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ZRange); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Dx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Dy); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Dz); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PointsFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutputAccel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Verbose); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VVerbose); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BoxExceedAllowF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WrHAWC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WrBladed); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WrVTK); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WrUniform); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%XYslice); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_Driver_CopyIfWDriver_Settings(SrcIfWDriver_SettingsData, DstIfWDriver_SettingsData, CtrlCode, ErrStat, ErrMsg)
   type(IfWDriver_Settings), intent(in) :: SrcIfWDriver_SettingsData
   type(IfWDriver_Settings), intent(inout) :: DstIfWDriver_SettingsData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'InflowWind_Driver_CopyIfWDriver_Settings'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstIfWDriver_SettingsData%DvrIptFileName = SrcIfWDriver_SettingsData%DvrIptFileName
   DstIfWDriver_SettingsData%IfWIptFileName = SrcIfWDriver_SettingsData%IfWIptFileName
   DstIfWDriver_SettingsData%SummaryFileName = SrcIfWDriver_SettingsData%SummaryFileName
   DstIfWDriver_SettingsData%PointsFileName = SrcIfWDriver_SettingsData%PointsFileName
   DstIfWDriver_SettingsData%NumTimeSteps = SrcIfWDriver_SettingsData%NumTimeSteps
   DstIfWDriver_SettingsData%DT = SrcIfWDriver_SettingsData%DT
   DstIfWDriver_SettingsData%TStart = SrcIfWDriver_SettingsData%TStart
   DstIfWDriver_SettingsData%FFTcoord(1:3) = SrcIfWDriver_SettingsData%FFTcoord(1:3)
   DstIfWDriver_SettingsData%GridDelta(1:3) = SrcIfWDriver_SettingsData%GridDelta(1:3)
   DstIfWDriver_SettingsData%GridN(1:3) = SrcIfWDriver_SettingsData%GridN(1:3)
   DstIfWDriver_SettingsData%XRange(1:2) = SrcIfWDriver_SettingsData%XRange(1:2)
   DstIfWDriver_SettingsData%YRange(1:2) = SrcIfWDriver_SettingsData%YRange(1:2)
   DstIfWDriver_SettingsData%ZRange(1:2) = SrcIfWDriver_SettingsData%ZRange(1:2)
   call NWTC_Library_CopyProgDesc(SrcIfWDriver_SettingsData%ProgInfo, DstIfWDriver_SettingsData%ProgInfo, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call InflowWind_Driver_CopyOutputFile(SrcIfWDriver_SettingsData%WindGridOutput, DstIfWDriver_SettingsData%WindGridOutput, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call InflowWind_Driver_CopyOutputFile(SrcIfWDriver_SettingsData%FFTOutput, DstIfWDriver_SettingsData%FFTOutput, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call InflowWind_Driver_CopyOutputFile(SrcIfWDriver_SettingsData%PointsVelOutput, DstIfWDriver_SettingsData%PointsVelOutput, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstIfWDriver_SettingsData%NOutWindXY = SrcIfWDriver_SettingsData%NOutWindXY
   if (allocated(SrcIfWDriver_SettingsData%OutWindZ)) then
      LB(1:1) = lbound(SrcIfWDriver_SettingsData%OutWindZ)
      UB(1:1) = ubound(SrcIfWDriver_SettingsData%OutWindZ)
      if (.not. allocated(DstIfWDriver_SettingsData%OutWindZ)) then
         allocate(DstIfWDriver_SettingsData%OutWindZ(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstIfWDriver_SettingsData%OutWindZ.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstIfWDriver_SettingsData%OutWindZ = SrcIfWDriver_SettingsData%OutWindZ
   end if
   DstIfWDriver_SettingsData%NOutWindXZ = SrcIfWDriver_SettingsData%NOutWindXZ
   if (allocated(SrcIfWDriver_SettingsData%OutWindY)) then
      LB(1:1) = lbound(SrcIfWDriver_SettingsData%OutWindY)
      UB(1:1) = ubound(SrcIfWDriver_SettingsData%OutWindY)
      if (.not. allocated(DstIfWDriver_SettingsData%OutWindY)) then
         allocate(DstIfWDriver_SettingsData%OutWindY(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstIfWDriver_SettingsData%OutWindY.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstIfWDriver_SettingsData%OutWindY = SrcIfWDriver_SettingsData%OutWindY
   end if
   DstIfWDriver_SettingsData%NOutWindYZ = SrcIfWDriver_SettingsData%NOutWindYZ
   if (allocated(SrcIfWDriver_SettingsData%OutWindX)) then
      LB(1:1) = lbound(SrcIfWDriver_SettingsData%OutWindX)
      UB(1:1) = ubound(SrcIfWDriver_SettingsData%OutWindX)
      if (.not. allocated(DstIfWDriver_SettingsData%OutWindX)) then
         allocate(DstIfWDriver_SettingsData%OutWindX(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstIfWDriver_SettingsData%OutWindX.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstIfWDriver_SettingsData%OutWindX = SrcIfWDriver_SettingsData%OutWindX
   end if
end subroutine

subroutine InflowWind_Driver_DestroyIfWDriver_Settings(IfWDriver_SettingsData, ErrStat, ErrMsg)
   type(IfWDriver_Settings), intent(inout) :: IfWDriver_SettingsData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'InflowWind_Driver_DestroyIfWDriver_Settings'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call NWTC_Library_DestroyProgDesc(IfWDriver_SettingsData%ProgInfo, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call InflowWind_Driver_DestroyOutputFile(IfWDriver_SettingsData%WindGridOutput, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call InflowWind_Driver_DestroyOutputFile(IfWDriver_SettingsData%FFTOutput, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call InflowWind_Driver_DestroyOutputFile(IfWDriver_SettingsData%PointsVelOutput, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(IfWDriver_SettingsData%OutWindZ)) then
      deallocate(IfWDriver_SettingsData%OutWindZ)
   end if
   if (allocated(IfWDriver_SettingsData%OutWindY)) then
      deallocate(IfWDriver_SettingsData%OutWindY)
   end if
   if (allocated(IfWDriver_SettingsData%OutWindX)) then
      deallocate(IfWDriver_SettingsData%OutWindX)
   end if
end subroutine

subroutine InflowWind_Driver_PackIfWDriver_Settings(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(IfWDriver_Settings), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'InflowWind_Driver_PackIfWDriver_Settings'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DvrIptFileName)
   call RegPack(RF, InData%IfWIptFileName)
   call RegPack(RF, InData%SummaryFileName)
   call RegPack(RF, InData%PointsFileName)
   call RegPack(RF, InData%NumTimeSteps)
   call RegPack(RF, InData%DT)
   call RegPack(RF, InData%TStart)
   call RegPack(RF, InData%FFTcoord(1:3))
   call RegPack(RF, InData%GridDelta(1:3))
   call RegPack(RF, InData%GridN(1:3))
   call RegPack(RF, InData%XRange(1:2))
   call RegPack(RF, InData%YRange(1:2))
   call RegPack(RF, InData%ZRange(1:2))
   call NWTC_Library_PackProgDesc(RF, InData%ProgInfo) 
   call InflowWind_Driver_PackOutputFile(RF, InData%WindGridOutput) 
   call InflowWind_Driver_PackOutputFile(RF, InData%FFTOutput) 
   call InflowWind_Driver_PackOutputFile(RF, InData%PointsVelOutput) 
   call RegPack(RF, InData%NOutWindXY)
   call RegPackAlloc(RF, InData%OutWindZ)
   call RegPack(RF, InData%NOutWindXZ)
   call RegPackAlloc(RF, InData%OutWindY)
   call RegPack(RF, InData%NOutWindYZ)
   call RegPackAlloc(RF, InData%OutWindX)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine InflowWind_Driver_UnPackIfWDriver_Settings(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(IfWDriver_Settings), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'InflowWind_Driver_UnPackIfWDriver_Settings'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DvrIptFileName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%IfWIptFileName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SummaryFileName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PointsFileName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumTimeSteps); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TStart); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FFTcoord(1:3)); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GridDelta(1:3)); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GridN(1:3)); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%XRange(1:2)); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YRange(1:2)); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ZRange(1:2)); if (RegCheckErr(RF, RoutineName)) return
   call NWTC_Library_UnpackProgDesc(RF, OutData%ProgInfo) ! ProgInfo 
   call InflowWind_Driver_UnpackOutputFile(RF, OutData%WindGridOutput) ! WindGridOutput 
   call InflowWind_Driver_UnpackOutputFile(RF, OutData%FFTOutput) ! FFTOutput 
   call InflowWind_Driver_UnpackOutputFile(RF, OutData%PointsVelOutput) ! PointsVelOutput 
   call RegUnpack(RF, OutData%NOutWindXY); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%OutWindZ); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NOutWindXZ); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%OutWindY); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NOutWindYZ); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%OutWindX); if (RegCheckErr(RF, RoutineName)) return
end subroutine
END MODULE InflowWind_Driver_Types
!ENDOFREGISTRYGENERATEDFILE
