!STARTOFREGISTRYGENERATEDFILE 'IfW_FlowField_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! IfW_FlowField_Types
!.................................................................................................................................
! This file is part of IfW_FlowField.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in IfW_FlowField. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE IfW_FlowField_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE NWTC_Library
IMPLICIT NONE
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Undef_FieldType = 0      ! This is the code for an undefined FieldType [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Uniform_FieldType = 1      ! Uniform FieldType from SteadyWind or Uniform Wind [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Grid3D_FieldType = 2      ! 3D Grid FieldType from TurbSim, Bladed, HAWC [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Grid4D_FieldType = 3      ! 4D Grid FieldType from FAST.Farm [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Point_FieldType = 4      ! Points FieldType from ExtInflow [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: User_FieldType = 5      ! User FieldType configured by the user [-]
! =========  UniformFieldType  =======
  TYPE, PUBLIC :: UniformFieldType
    REAL(ReKi)  :: RefHeight = 0.0_ReKi      !< reference height; used to center the wind [meters]
    REAL(ReKi)  :: RefLength = 0.0_ReKi      !< reference length used to scale the linear shear [meters]
    INTEGER(IntKi)  :: DataSize = 0_IntKi      !< size of data in HH file [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Time      !< HH time array [seconds]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: VelH      !< HH horizontal wind speed [meters/sec]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: VelHDot      !< Derivative of HH horizontal wind speed wrt time [meters/sec]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: VelV      !< HH vertical wind speed, including tower shadow [meters/sec]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: VelVDot      !< Derivative of HH vertical wind speed wrt time [meters/sec]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: VelGust      !< HH wind gust speed [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: VelGustDot      !< Derivative of HH wind gust speed wrt time [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: AngleH      !< HH wind direction angle [degrees]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: AngleHDot      !< Derivative of HH wind direction angle wrt time [degrees]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: AngleV      !< HH upflow angle [degrees]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: AngleVDot      !< Derivative of HH upflow angle wrt time [degrees]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: ShrH      !< HH horizontal linear shear [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: ShrHDot      !< Derivative of HH horizontal linear shear wrt time [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: ShrV      !< HH vertical shear exponent [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: ShrVDot      !< Derivative of HH vertical shear exponent wrt time [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LinShrV      !< HH vertical linear shear [seconds]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LinShrVDot      !< Derivative of HH vertical linear shear wrt time [seconds]
  END TYPE UniformFieldType
! =======================
! =========  UniformField_Interp  =======
  TYPE, PUBLIC :: UniformField_Interp
    REAL(ReKi)  :: VelH = 0.0_ReKi      !< HH horizontal wind speed [meters/sec]
    REAL(ReKi)  :: VelHDot = 0.0_ReKi      !< derivative of HH horizontal wind speed wrt Time [meters/sec]
    REAL(ReKi)  :: VelV = 0.0_ReKi      !< HH vertical wind speed, including tower shadow [meters/sec]
    REAL(ReKi)  :: VelVDot = 0.0_ReKi      !< derivative of HH vertical wind speed wrt Time [meters/sec]
    REAL(ReKi)  :: VelGust = 0.0_ReKi      !< HH wind gust speed [-]
    REAL(ReKi)  :: VelGustDot = 0.0_ReKi      !< derivative of HH wind gust speed wrt Time [-]
    REAL(ReKi)  :: AngleH = 0.0_ReKi      !< HH wind direction angle [degrees]
    REAL(ReKi)  :: AngleHDot = 0.0_ReKi      !< derivative of HH wind direction angle wrt Time [degrees]
    REAL(ReKi)  :: AngleV = 0.0_ReKi      !< HH upflow angle [degrees]
    REAL(ReKi)  :: AngleVDot = 0.0_ReKi      !< derivative of HH upflow angle wrt Time [degrees]
    REAL(ReKi)  :: ShrH = 0.0_ReKi      !< HH horizontal linear shear [-]
    REAL(ReKi)  :: ShrHDot = 0.0_ReKi      !< derivative of HH horizontal linear shear wrt Time [-]
    REAL(ReKi)  :: ShrV = 0.0_ReKi      !< HH vertical shear exponent [-]
    REAL(ReKi)  :: ShrVDot = 0.0_ReKi      !< derivative of HH vertical shear exponent wrt Time [-]
    REAL(ReKi)  :: LinShrV = 0.0_ReKi      !< HH vertical linear shear [seconds]
    REAL(ReKi)  :: LinShrVDot = 0.0_ReKi      !< derivative of HH vertical linear shear wrt Time [seconds]
    REAL(ReKi)  :: CosAngleH = 0.0_ReKi      !< Horizontal angle components [-]
    REAL(ReKi)  :: SinAngleH = 0.0_ReKi      !< Horizontal angle components [-]
    REAL(ReKi)  :: CosAngleV = 0.0_ReKi      !< Vertical angle components [-]
    REAL(ReKi)  :: SinAngleV = 0.0_ReKi      !< Vertical angle components [-]
  END TYPE UniformField_Interp
! =======================
! =========  Grid3DFieldType  =======
  TYPE, PUBLIC :: Grid3DFieldType
    INTEGER(IntKi)  :: WindFileFormat = 0_IntKi      !< Binary file format description number [-]
    INTEGER(IntKi)  :: WindProfileType = -1      !< Wind profile type (0=constant;1=logarithmic;2=power law) [-]
    LOGICAL  :: Periodic = .false.      !< Flag to indicate if the wind file is periodic [-]
    LOGICAL  :: InterpTower = .false.      !< Flag to indicate if we should interpolate wind speeds below the tower [-]
    LOGICAL  :: AddMeanAfterInterp = .false.      !< Add the mean wind speed after interpolating at a given height? [-]
    REAL(ReKi)  :: RefHeight = 0      !< Reference (hub) height of the grid [meters]
    REAL(ReKi)  :: RefLength = 1.0_ReKi      !< Reference (rotor) length of the grid (used for horizontal wind profile type only) [-]
    REAL(SiKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: Vel      !< Array of field velocities [-]
    REAL(SiKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: Acc      !< Array of field accelerations [-]
    REAL(SiKi) , DIMENSION(:,:,:), ALLOCATABLE  :: VelTower      !< Array of tower velocities [-]
    REAL(SiKi) , DIMENSION(:,:,:), ALLOCATABLE  :: AccTower      !< Array of tower accelerations [-]
    REAL(SiKi) , DIMENSION(:,:,:), ALLOCATABLE  :: VelAvg      !< Average velocity profile by Z and time [-]
    REAL(SiKi) , DIMENSION(:,:,:), ALLOCATABLE  :: AccAvg      !< Average acceleration profile by Z and time [-]
    REAL(ReKi)  :: DTime = 0      !< Delta time [seconds]
    REAL(ReKi)  :: Rate = 0      !< Data rate (1/FFDTime) [Hertz]
    REAL(ReKi)  :: YHWid = 0      !< Half the grid width [meters]
    REAL(ReKi)  :: ZHWid = 0      !< Half the grid height [meters]
    REAL(ReKi)  :: GridBase = 0      !< the height of the bottom of the grid [meters]
    REAL(ReKi)  :: InitXPosition = 0      !< the initial x position of grid (distance in FF is offset) [meters]
    REAL(ReKi)  :: InvDY = 0      !< reciprocal of delta y [1/meters]
    REAL(ReKi)  :: InvDZ = 0      !< reciprocal of delta z [1/meters]
    REAL(ReKi)  :: MeanWS = 0      !< Mean wind speed (as defined in FF file), not necessarily of the portion used [meters/second]
    REAL(ReKi)  :: InvMWS = 0      !< reciprocal of mean wind speed (MeanFFWS) [seconds/meter]
    REAL(ReKi)  :: TotalTime = 0      !< The total time of the simulation [seconds]
    INTEGER(IntKi)  :: NComp = 3      !< Number of wind components [-]
    INTEGER(IntKi)  :: NYGrids = 0      !< Number of points in the lateral (y) direction of the grids [-]
    INTEGER(IntKi)  :: NZGrids = 0      !< Number of points in the vertical (z) direction of the grids [-]
    INTEGER(IntKi)  :: NTGrids = 0      !< Number of points in the vertical (z) direction on the tower (below the grids) [-]
    INTEGER(IntKi)  :: NSteps = 0      !< Number of time steps in the FF array [-]
    REAL(ReKi)  :: PLExp = 0      !< Power law exponent (used for PL wind profile type only) [-]
    REAL(ReKi)  :: Z0 = 0      !< Surface roughness length (used for LOG wind profile type only) [-]
    REAL(ReKi)  :: VLinShr = 0      !< Vertical linear wind shear coefficient (used for vertical linear wind profile type only) [-]
    REAL(ReKi)  :: HLinShr = 0      !< Horizontal linear wind shear coefficient (used for horizontal wind profile type only) [-]
    LOGICAL  :: BoxExceedAllow = .FALSE.      !< Flag to allow Extrapolation winds outside box starting at this index (for OLAF wakes and LidarSim) [-]
    LOGICAL  :: BoxExceedAllowDrv = .FALSE.      !< Flag to allow Extrapolation winds outside box set by driver [-]
  END TYPE Grid3DFieldType
! =======================
! =========  Grid4DFieldType  =======
  TYPE, PUBLIC :: Grid4DFieldType
    INTEGER(IntKi) , DIMENSION(1:4)  :: n = 0_IntKi      !< number of evenly-spaced grid points in the x, y, z, and t directions [-]
    REAL(DbKi) , DIMENSION(1:4)  :: delta = 0.0_R8Ki      !< size between 2 consecutive grid points in each grid direction [m,m,m,s]
    REAL(ReKi) , DIMENSION(1:3)  :: pZero = 0.0_ReKi      !< fixed position of the XYZ grid (i.e., XYZ coordinates of m%V(:,1,1,1,:)) [m]
    REAL(SiKi) , DIMENSION(:,:,:,:,:), POINTER  :: Vel => NULL()      !< this is the 4-d velocity field for each wind component [{uvw},nx,ny,nz,nt] [-]
    REAL(ReKi)  :: TimeStart = 0.0_ReKi      !< this is the time where the first time grid in m%V starts (i.e, the time associated with m%V(:,:,:,:,1)) [s]
    REAL(ReKi)  :: RefHeight = 0.0_ReKi      !< reference height; used to center the wind [meters]
  END TYPE Grid4DFieldType
! =======================
! =========  PointsFieldType  =======
  TYPE, PUBLIC :: PointsFieldType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Vel      !< Point velocities populated by external driver [uvw,point] [-]
  END TYPE PointsFieldType
! =======================
! =========  UserFieldType  =======
  TYPE, PUBLIC :: UserFieldType
    REAL(ReKi)  :: RefHeight = 0.0_ReKi      !< reference height; used to center the wind [meters]
  END TYPE UserFieldType
! =======================
! =========  FlowFieldType  =======
  TYPE, PUBLIC :: FlowFieldType
    INTEGER(IntKi)  :: FieldType = 0      !< Switch for flow field type {1=Uniform, 2=Grid, 3=User, 4=External} [-]
    REAL(ReKi) , DIMENSION(1:3)  :: RefPosition = 0.0_ReKi      !< Reference position (point where box is rotated) [meters]
    REAL(ReKi)  :: PropagationDir = 0.0_ReKi      !< Direction of wind propagation [radians]
    REAL(ReKi)  :: VFlowAngle = 0.0_ReKi      !< Vertical (upflow) angle [radians]
    LOGICAL  :: VelInterpCubic = .false.      !< Velocity interpolation order in time (1=linear; 3=cubic) [Used with WindType=2,3,4,5,7] [-]
    LOGICAL  :: RotateWindBox = .false.      !< flag indicating if the wind will be rotated [-]
    LOGICAL  :: AccFieldValid = .false.      !< flag indicating that acceleration field has been calculated [-]
    REAL(ReKi) , DIMENSION(1:3,1:3)  :: RotToWind = 0.0_ReKi      !< Rotation matrix for rotating from the global XYZ coordinate system to the wind coordinate system (wind along X') [-]
    REAL(ReKi) , DIMENSION(1:3,1:3)  :: RotFromWind = 0.0_ReKi      !< Rotation matrix for rotating from the wind coordinate system (wind along X') back to the global XYZ coordinate system.  Equal to TRANSPOSE(RotToWind) [-]
    TYPE(UniformFieldType)  :: Uniform      !< Uniform Flow Data [-]
    TYPE(Grid3DFieldType)  :: Grid3D      !< Grid Field Wind Data [-]
    TYPE(Grid4DFieldType)  :: Grid4D      !< External Grid Flow Data [-]
    TYPE(PointsFieldType)  :: Points      !< External Point Flow Data [-]
    TYPE(UserFieldType)  :: User      !< User Field Wind Data [-]
  END TYPE FlowFieldType
! =======================
CONTAINS

subroutine IfW_FlowField_CopyUniformFieldType(SrcUniformFieldTypeData, DstUniformFieldTypeData, CtrlCode, ErrStat, ErrMsg)
   type(UniformFieldType), intent(in) :: SrcUniformFieldTypeData
   type(UniformFieldType), intent(inout) :: DstUniformFieldTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'IfW_FlowField_CopyUniformFieldType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstUniformFieldTypeData%RefHeight = SrcUniformFieldTypeData%RefHeight
   DstUniformFieldTypeData%RefLength = SrcUniformFieldTypeData%RefLength
   DstUniformFieldTypeData%DataSize = SrcUniformFieldTypeData%DataSize
   if (allocated(SrcUniformFieldTypeData%Time)) then
      LB(1:1) = lbound(SrcUniformFieldTypeData%Time)
      UB(1:1) = ubound(SrcUniformFieldTypeData%Time)
      if (.not. allocated(DstUniformFieldTypeData%Time)) then
         allocate(DstUniformFieldTypeData%Time(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstUniformFieldTypeData%Time.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstUniformFieldTypeData%Time = SrcUniformFieldTypeData%Time
   end if
   if (allocated(SrcUniformFieldTypeData%VelH)) then
      LB(1:1) = lbound(SrcUniformFieldTypeData%VelH)
      UB(1:1) = ubound(SrcUniformFieldTypeData%VelH)
      if (.not. allocated(DstUniformFieldTypeData%VelH)) then
         allocate(DstUniformFieldTypeData%VelH(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstUniformFieldTypeData%VelH.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstUniformFieldTypeData%VelH = SrcUniformFieldTypeData%VelH
   end if
   if (allocated(SrcUniformFieldTypeData%VelHDot)) then
      LB(1:1) = lbound(SrcUniformFieldTypeData%VelHDot)
      UB(1:1) = ubound(SrcUniformFieldTypeData%VelHDot)
      if (.not. allocated(DstUniformFieldTypeData%VelHDot)) then
         allocate(DstUniformFieldTypeData%VelHDot(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstUniformFieldTypeData%VelHDot.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstUniformFieldTypeData%VelHDot = SrcUniformFieldTypeData%VelHDot
   end if
   if (allocated(SrcUniformFieldTypeData%VelV)) then
      LB(1:1) = lbound(SrcUniformFieldTypeData%VelV)
      UB(1:1) = ubound(SrcUniformFieldTypeData%VelV)
      if (.not. allocated(DstUniformFieldTypeData%VelV)) then
         allocate(DstUniformFieldTypeData%VelV(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstUniformFieldTypeData%VelV.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstUniformFieldTypeData%VelV = SrcUniformFieldTypeData%VelV
   end if
   if (allocated(SrcUniformFieldTypeData%VelVDot)) then
      LB(1:1) = lbound(SrcUniformFieldTypeData%VelVDot)
      UB(1:1) = ubound(SrcUniformFieldTypeData%VelVDot)
      if (.not. allocated(DstUniformFieldTypeData%VelVDot)) then
         allocate(DstUniformFieldTypeData%VelVDot(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstUniformFieldTypeData%VelVDot.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstUniformFieldTypeData%VelVDot = SrcUniformFieldTypeData%VelVDot
   end if
   if (allocated(SrcUniformFieldTypeData%VelGust)) then
      LB(1:1) = lbound(SrcUniformFieldTypeData%VelGust)
      UB(1:1) = ubound(SrcUniformFieldTypeData%VelGust)
      if (.not. allocated(DstUniformFieldTypeData%VelGust)) then
         allocate(DstUniformFieldTypeData%VelGust(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstUniformFieldTypeData%VelGust.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstUniformFieldTypeData%VelGust = SrcUniformFieldTypeData%VelGust
   end if
   if (allocated(SrcUniformFieldTypeData%VelGustDot)) then
      LB(1:1) = lbound(SrcUniformFieldTypeData%VelGustDot)
      UB(1:1) = ubound(SrcUniformFieldTypeData%VelGustDot)
      if (.not. allocated(DstUniformFieldTypeData%VelGustDot)) then
         allocate(DstUniformFieldTypeData%VelGustDot(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstUniformFieldTypeData%VelGustDot.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstUniformFieldTypeData%VelGustDot = SrcUniformFieldTypeData%VelGustDot
   end if
   if (allocated(SrcUniformFieldTypeData%AngleH)) then
      LB(1:1) = lbound(SrcUniformFieldTypeData%AngleH)
      UB(1:1) = ubound(SrcUniformFieldTypeData%AngleH)
      if (.not. allocated(DstUniformFieldTypeData%AngleH)) then
         allocate(DstUniformFieldTypeData%AngleH(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstUniformFieldTypeData%AngleH.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstUniformFieldTypeData%AngleH = SrcUniformFieldTypeData%AngleH
   end if
   if (allocated(SrcUniformFieldTypeData%AngleHDot)) then
      LB(1:1) = lbound(SrcUniformFieldTypeData%AngleHDot)
      UB(1:1) = ubound(SrcUniformFieldTypeData%AngleHDot)
      if (.not. allocated(DstUniformFieldTypeData%AngleHDot)) then
         allocate(DstUniformFieldTypeData%AngleHDot(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstUniformFieldTypeData%AngleHDot.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstUniformFieldTypeData%AngleHDot = SrcUniformFieldTypeData%AngleHDot
   end if
   if (allocated(SrcUniformFieldTypeData%AngleV)) then
      LB(1:1) = lbound(SrcUniformFieldTypeData%AngleV)
      UB(1:1) = ubound(SrcUniformFieldTypeData%AngleV)
      if (.not. allocated(DstUniformFieldTypeData%AngleV)) then
         allocate(DstUniformFieldTypeData%AngleV(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstUniformFieldTypeData%AngleV.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstUniformFieldTypeData%AngleV = SrcUniformFieldTypeData%AngleV
   end if
   if (allocated(SrcUniformFieldTypeData%AngleVDot)) then
      LB(1:1) = lbound(SrcUniformFieldTypeData%AngleVDot)
      UB(1:1) = ubound(SrcUniformFieldTypeData%AngleVDot)
      if (.not. allocated(DstUniformFieldTypeData%AngleVDot)) then
         allocate(DstUniformFieldTypeData%AngleVDot(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstUniformFieldTypeData%AngleVDot.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstUniformFieldTypeData%AngleVDot = SrcUniformFieldTypeData%AngleVDot
   end if
   if (allocated(SrcUniformFieldTypeData%ShrH)) then
      LB(1:1) = lbound(SrcUniformFieldTypeData%ShrH)
      UB(1:1) = ubound(SrcUniformFieldTypeData%ShrH)
      if (.not. allocated(DstUniformFieldTypeData%ShrH)) then
         allocate(DstUniformFieldTypeData%ShrH(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstUniformFieldTypeData%ShrH.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstUniformFieldTypeData%ShrH = SrcUniformFieldTypeData%ShrH
   end if
   if (allocated(SrcUniformFieldTypeData%ShrHDot)) then
      LB(1:1) = lbound(SrcUniformFieldTypeData%ShrHDot)
      UB(1:1) = ubound(SrcUniformFieldTypeData%ShrHDot)
      if (.not. allocated(DstUniformFieldTypeData%ShrHDot)) then
         allocate(DstUniformFieldTypeData%ShrHDot(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstUniformFieldTypeData%ShrHDot.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstUniformFieldTypeData%ShrHDot = SrcUniformFieldTypeData%ShrHDot
   end if
   if (allocated(SrcUniformFieldTypeData%ShrV)) then
      LB(1:1) = lbound(SrcUniformFieldTypeData%ShrV)
      UB(1:1) = ubound(SrcUniformFieldTypeData%ShrV)
      if (.not. allocated(DstUniformFieldTypeData%ShrV)) then
         allocate(DstUniformFieldTypeData%ShrV(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstUniformFieldTypeData%ShrV.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstUniformFieldTypeData%ShrV = SrcUniformFieldTypeData%ShrV
   end if
   if (allocated(SrcUniformFieldTypeData%ShrVDot)) then
      LB(1:1) = lbound(SrcUniformFieldTypeData%ShrVDot)
      UB(1:1) = ubound(SrcUniformFieldTypeData%ShrVDot)
      if (.not. allocated(DstUniformFieldTypeData%ShrVDot)) then
         allocate(DstUniformFieldTypeData%ShrVDot(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstUniformFieldTypeData%ShrVDot.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstUniformFieldTypeData%ShrVDot = SrcUniformFieldTypeData%ShrVDot
   end if
   if (allocated(SrcUniformFieldTypeData%LinShrV)) then
      LB(1:1) = lbound(SrcUniformFieldTypeData%LinShrV)
      UB(1:1) = ubound(SrcUniformFieldTypeData%LinShrV)
      if (.not. allocated(DstUniformFieldTypeData%LinShrV)) then
         allocate(DstUniformFieldTypeData%LinShrV(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstUniformFieldTypeData%LinShrV.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstUniformFieldTypeData%LinShrV = SrcUniformFieldTypeData%LinShrV
   end if
   if (allocated(SrcUniformFieldTypeData%LinShrVDot)) then
      LB(1:1) = lbound(SrcUniformFieldTypeData%LinShrVDot)
      UB(1:1) = ubound(SrcUniformFieldTypeData%LinShrVDot)
      if (.not. allocated(DstUniformFieldTypeData%LinShrVDot)) then
         allocate(DstUniformFieldTypeData%LinShrVDot(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstUniformFieldTypeData%LinShrVDot.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstUniformFieldTypeData%LinShrVDot = SrcUniformFieldTypeData%LinShrVDot
   end if
end subroutine

subroutine IfW_FlowField_DestroyUniformFieldType(UniformFieldTypeData, ErrStat, ErrMsg)
   type(UniformFieldType), intent(inout) :: UniformFieldTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'IfW_FlowField_DestroyUniformFieldType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(UniformFieldTypeData%Time)) then
      deallocate(UniformFieldTypeData%Time)
   end if
   if (allocated(UniformFieldTypeData%VelH)) then
      deallocate(UniformFieldTypeData%VelH)
   end if
   if (allocated(UniformFieldTypeData%VelHDot)) then
      deallocate(UniformFieldTypeData%VelHDot)
   end if
   if (allocated(UniformFieldTypeData%VelV)) then
      deallocate(UniformFieldTypeData%VelV)
   end if
   if (allocated(UniformFieldTypeData%VelVDot)) then
      deallocate(UniformFieldTypeData%VelVDot)
   end if
   if (allocated(UniformFieldTypeData%VelGust)) then
      deallocate(UniformFieldTypeData%VelGust)
   end if
   if (allocated(UniformFieldTypeData%VelGustDot)) then
      deallocate(UniformFieldTypeData%VelGustDot)
   end if
   if (allocated(UniformFieldTypeData%AngleH)) then
      deallocate(UniformFieldTypeData%AngleH)
   end if
   if (allocated(UniformFieldTypeData%AngleHDot)) then
      deallocate(UniformFieldTypeData%AngleHDot)
   end if
   if (allocated(UniformFieldTypeData%AngleV)) then
      deallocate(UniformFieldTypeData%AngleV)
   end if
   if (allocated(UniformFieldTypeData%AngleVDot)) then
      deallocate(UniformFieldTypeData%AngleVDot)
   end if
   if (allocated(UniformFieldTypeData%ShrH)) then
      deallocate(UniformFieldTypeData%ShrH)
   end if
   if (allocated(UniformFieldTypeData%ShrHDot)) then
      deallocate(UniformFieldTypeData%ShrHDot)
   end if
   if (allocated(UniformFieldTypeData%ShrV)) then
      deallocate(UniformFieldTypeData%ShrV)
   end if
   if (allocated(UniformFieldTypeData%ShrVDot)) then
      deallocate(UniformFieldTypeData%ShrVDot)
   end if
   if (allocated(UniformFieldTypeData%LinShrV)) then
      deallocate(UniformFieldTypeData%LinShrV)
   end if
   if (allocated(UniformFieldTypeData%LinShrVDot)) then
      deallocate(UniformFieldTypeData%LinShrVDot)
   end if
end subroutine

subroutine IfW_FlowField_PackUniformFieldType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(UniformFieldType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'IfW_FlowField_PackUniformFieldType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%RefHeight)
   call RegPack(RF, InData%RefLength)
   call RegPack(RF, InData%DataSize)
   call RegPackAlloc(RF, InData%Time)
   call RegPackAlloc(RF, InData%VelH)
   call RegPackAlloc(RF, InData%VelHDot)
   call RegPackAlloc(RF, InData%VelV)
   call RegPackAlloc(RF, InData%VelVDot)
   call RegPackAlloc(RF, InData%VelGust)
   call RegPackAlloc(RF, InData%VelGustDot)
   call RegPackAlloc(RF, InData%AngleH)
   call RegPackAlloc(RF, InData%AngleHDot)
   call RegPackAlloc(RF, InData%AngleV)
   call RegPackAlloc(RF, InData%AngleVDot)
   call RegPackAlloc(RF, InData%ShrH)
   call RegPackAlloc(RF, InData%ShrHDot)
   call RegPackAlloc(RF, InData%ShrV)
   call RegPackAlloc(RF, InData%ShrVDot)
   call RegPackAlloc(RF, InData%LinShrV)
   call RegPackAlloc(RF, InData%LinShrVDot)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IfW_FlowField_UnPackUniformFieldType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(UniformFieldType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'IfW_FlowField_UnPackUniformFieldType'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%RefHeight); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RefLength); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DataSize); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Time); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%VelH); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%VelHDot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%VelV); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%VelVDot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%VelGust); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%VelGustDot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AngleH); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AngleHDot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AngleV); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AngleVDot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%ShrH); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%ShrHDot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%ShrV); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%ShrVDot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LinShrV); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LinShrVDot); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IfW_FlowField_CopyUniformField_Interp(SrcUniformField_InterpData, DstUniformField_InterpData, CtrlCode, ErrStat, ErrMsg)
   type(UniformField_Interp), intent(in) :: SrcUniformField_InterpData
   type(UniformField_Interp), intent(inout) :: DstUniformField_InterpData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'IfW_FlowField_CopyUniformField_Interp'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstUniformField_InterpData%VelH = SrcUniformField_InterpData%VelH
   DstUniformField_InterpData%VelHDot = SrcUniformField_InterpData%VelHDot
   DstUniformField_InterpData%VelV = SrcUniformField_InterpData%VelV
   DstUniformField_InterpData%VelVDot = SrcUniformField_InterpData%VelVDot
   DstUniformField_InterpData%VelGust = SrcUniformField_InterpData%VelGust
   DstUniformField_InterpData%VelGustDot = SrcUniformField_InterpData%VelGustDot
   DstUniformField_InterpData%AngleH = SrcUniformField_InterpData%AngleH
   DstUniformField_InterpData%AngleHDot = SrcUniformField_InterpData%AngleHDot
   DstUniformField_InterpData%AngleV = SrcUniformField_InterpData%AngleV
   DstUniformField_InterpData%AngleVDot = SrcUniformField_InterpData%AngleVDot
   DstUniformField_InterpData%ShrH = SrcUniformField_InterpData%ShrH
   DstUniformField_InterpData%ShrHDot = SrcUniformField_InterpData%ShrHDot
   DstUniformField_InterpData%ShrV = SrcUniformField_InterpData%ShrV
   DstUniformField_InterpData%ShrVDot = SrcUniformField_InterpData%ShrVDot
   DstUniformField_InterpData%LinShrV = SrcUniformField_InterpData%LinShrV
   DstUniformField_InterpData%LinShrVDot = SrcUniformField_InterpData%LinShrVDot
   DstUniformField_InterpData%CosAngleH = SrcUniformField_InterpData%CosAngleH
   DstUniformField_InterpData%SinAngleH = SrcUniformField_InterpData%SinAngleH
   DstUniformField_InterpData%CosAngleV = SrcUniformField_InterpData%CosAngleV
   DstUniformField_InterpData%SinAngleV = SrcUniformField_InterpData%SinAngleV
end subroutine

subroutine IfW_FlowField_DestroyUniformField_Interp(UniformField_InterpData, ErrStat, ErrMsg)
   type(UniformField_Interp), intent(inout) :: UniformField_InterpData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'IfW_FlowField_DestroyUniformField_Interp'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine IfW_FlowField_PackUniformField_Interp(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(UniformField_Interp), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'IfW_FlowField_PackUniformField_Interp'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%VelH)
   call RegPack(RF, InData%VelHDot)
   call RegPack(RF, InData%VelV)
   call RegPack(RF, InData%VelVDot)
   call RegPack(RF, InData%VelGust)
   call RegPack(RF, InData%VelGustDot)
   call RegPack(RF, InData%AngleH)
   call RegPack(RF, InData%AngleHDot)
   call RegPack(RF, InData%AngleV)
   call RegPack(RF, InData%AngleVDot)
   call RegPack(RF, InData%ShrH)
   call RegPack(RF, InData%ShrHDot)
   call RegPack(RF, InData%ShrV)
   call RegPack(RF, InData%ShrVDot)
   call RegPack(RF, InData%LinShrV)
   call RegPack(RF, InData%LinShrVDot)
   call RegPack(RF, InData%CosAngleH)
   call RegPack(RF, InData%SinAngleH)
   call RegPack(RF, InData%CosAngleV)
   call RegPack(RF, InData%SinAngleV)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IfW_FlowField_UnPackUniformField_Interp(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(UniformField_Interp), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'IfW_FlowField_UnPackUniformField_Interp'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%VelH); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VelHDot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VelV); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VelVDot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VelGust); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VelGustDot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AngleH); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AngleHDot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AngleV); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AngleVDot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ShrH); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ShrHDot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ShrV); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ShrVDot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LinShrV); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LinShrVDot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CosAngleH); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SinAngleH); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CosAngleV); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SinAngleV); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IfW_FlowField_CopyGrid3DFieldType(SrcGrid3DFieldTypeData, DstGrid3DFieldTypeData, CtrlCode, ErrStat, ErrMsg)
   type(Grid3DFieldType), intent(in) :: SrcGrid3DFieldTypeData
   type(Grid3DFieldType), intent(inout) :: DstGrid3DFieldTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(4), UB(4)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'IfW_FlowField_CopyGrid3DFieldType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstGrid3DFieldTypeData%WindFileFormat = SrcGrid3DFieldTypeData%WindFileFormat
   DstGrid3DFieldTypeData%WindProfileType = SrcGrid3DFieldTypeData%WindProfileType
   DstGrid3DFieldTypeData%Periodic = SrcGrid3DFieldTypeData%Periodic
   DstGrid3DFieldTypeData%InterpTower = SrcGrid3DFieldTypeData%InterpTower
   DstGrid3DFieldTypeData%AddMeanAfterInterp = SrcGrid3DFieldTypeData%AddMeanAfterInterp
   DstGrid3DFieldTypeData%RefHeight = SrcGrid3DFieldTypeData%RefHeight
   DstGrid3DFieldTypeData%RefLength = SrcGrid3DFieldTypeData%RefLength
   if (allocated(SrcGrid3DFieldTypeData%Vel)) then
      LB(1:4) = lbound(SrcGrid3DFieldTypeData%Vel)
      UB(1:4) = ubound(SrcGrid3DFieldTypeData%Vel)
      if (.not. allocated(DstGrid3DFieldTypeData%Vel)) then
         allocate(DstGrid3DFieldTypeData%Vel(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstGrid3DFieldTypeData%Vel.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstGrid3DFieldTypeData%Vel = SrcGrid3DFieldTypeData%Vel
   end if
   if (allocated(SrcGrid3DFieldTypeData%Acc)) then
      LB(1:4) = lbound(SrcGrid3DFieldTypeData%Acc)
      UB(1:4) = ubound(SrcGrid3DFieldTypeData%Acc)
      if (.not. allocated(DstGrid3DFieldTypeData%Acc)) then
         allocate(DstGrid3DFieldTypeData%Acc(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstGrid3DFieldTypeData%Acc.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstGrid3DFieldTypeData%Acc = SrcGrid3DFieldTypeData%Acc
   end if
   if (allocated(SrcGrid3DFieldTypeData%VelTower)) then
      LB(1:3) = lbound(SrcGrid3DFieldTypeData%VelTower)
      UB(1:3) = ubound(SrcGrid3DFieldTypeData%VelTower)
      if (.not. allocated(DstGrid3DFieldTypeData%VelTower)) then
         allocate(DstGrid3DFieldTypeData%VelTower(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstGrid3DFieldTypeData%VelTower.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstGrid3DFieldTypeData%VelTower = SrcGrid3DFieldTypeData%VelTower
   end if
   if (allocated(SrcGrid3DFieldTypeData%AccTower)) then
      LB(1:3) = lbound(SrcGrid3DFieldTypeData%AccTower)
      UB(1:3) = ubound(SrcGrid3DFieldTypeData%AccTower)
      if (.not. allocated(DstGrid3DFieldTypeData%AccTower)) then
         allocate(DstGrid3DFieldTypeData%AccTower(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstGrid3DFieldTypeData%AccTower.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstGrid3DFieldTypeData%AccTower = SrcGrid3DFieldTypeData%AccTower
   end if
   if (allocated(SrcGrid3DFieldTypeData%VelAvg)) then
      LB(1:3) = lbound(SrcGrid3DFieldTypeData%VelAvg)
      UB(1:3) = ubound(SrcGrid3DFieldTypeData%VelAvg)
      if (.not. allocated(DstGrid3DFieldTypeData%VelAvg)) then
         allocate(DstGrid3DFieldTypeData%VelAvg(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstGrid3DFieldTypeData%VelAvg.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstGrid3DFieldTypeData%VelAvg = SrcGrid3DFieldTypeData%VelAvg
   end if
   if (allocated(SrcGrid3DFieldTypeData%AccAvg)) then
      LB(1:3) = lbound(SrcGrid3DFieldTypeData%AccAvg)
      UB(1:3) = ubound(SrcGrid3DFieldTypeData%AccAvg)
      if (.not. allocated(DstGrid3DFieldTypeData%AccAvg)) then
         allocate(DstGrid3DFieldTypeData%AccAvg(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstGrid3DFieldTypeData%AccAvg.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstGrid3DFieldTypeData%AccAvg = SrcGrid3DFieldTypeData%AccAvg
   end if
   DstGrid3DFieldTypeData%DTime = SrcGrid3DFieldTypeData%DTime
   DstGrid3DFieldTypeData%Rate = SrcGrid3DFieldTypeData%Rate
   DstGrid3DFieldTypeData%YHWid = SrcGrid3DFieldTypeData%YHWid
   DstGrid3DFieldTypeData%ZHWid = SrcGrid3DFieldTypeData%ZHWid
   DstGrid3DFieldTypeData%GridBase = SrcGrid3DFieldTypeData%GridBase
   DstGrid3DFieldTypeData%InitXPosition = SrcGrid3DFieldTypeData%InitXPosition
   DstGrid3DFieldTypeData%InvDY = SrcGrid3DFieldTypeData%InvDY
   DstGrid3DFieldTypeData%InvDZ = SrcGrid3DFieldTypeData%InvDZ
   DstGrid3DFieldTypeData%MeanWS = SrcGrid3DFieldTypeData%MeanWS
   DstGrid3DFieldTypeData%InvMWS = SrcGrid3DFieldTypeData%InvMWS
   DstGrid3DFieldTypeData%TotalTime = SrcGrid3DFieldTypeData%TotalTime
   DstGrid3DFieldTypeData%NComp = SrcGrid3DFieldTypeData%NComp
   DstGrid3DFieldTypeData%NYGrids = SrcGrid3DFieldTypeData%NYGrids
   DstGrid3DFieldTypeData%NZGrids = SrcGrid3DFieldTypeData%NZGrids
   DstGrid3DFieldTypeData%NTGrids = SrcGrid3DFieldTypeData%NTGrids
   DstGrid3DFieldTypeData%NSteps = SrcGrid3DFieldTypeData%NSteps
   DstGrid3DFieldTypeData%PLExp = SrcGrid3DFieldTypeData%PLExp
   DstGrid3DFieldTypeData%Z0 = SrcGrid3DFieldTypeData%Z0
   DstGrid3DFieldTypeData%VLinShr = SrcGrid3DFieldTypeData%VLinShr
   DstGrid3DFieldTypeData%HLinShr = SrcGrid3DFieldTypeData%HLinShr
   DstGrid3DFieldTypeData%BoxExceedAllow = SrcGrid3DFieldTypeData%BoxExceedAllow
   DstGrid3DFieldTypeData%BoxExceedAllowDrv = SrcGrid3DFieldTypeData%BoxExceedAllowDrv
end subroutine

subroutine IfW_FlowField_DestroyGrid3DFieldType(Grid3DFieldTypeData, ErrStat, ErrMsg)
   type(Grid3DFieldType), intent(inout) :: Grid3DFieldTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'IfW_FlowField_DestroyGrid3DFieldType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(Grid3DFieldTypeData%Vel)) then
      deallocate(Grid3DFieldTypeData%Vel)
   end if
   if (allocated(Grid3DFieldTypeData%Acc)) then
      deallocate(Grid3DFieldTypeData%Acc)
   end if
   if (allocated(Grid3DFieldTypeData%VelTower)) then
      deallocate(Grid3DFieldTypeData%VelTower)
   end if
   if (allocated(Grid3DFieldTypeData%AccTower)) then
      deallocate(Grid3DFieldTypeData%AccTower)
   end if
   if (allocated(Grid3DFieldTypeData%VelAvg)) then
      deallocate(Grid3DFieldTypeData%VelAvg)
   end if
   if (allocated(Grid3DFieldTypeData%AccAvg)) then
      deallocate(Grid3DFieldTypeData%AccAvg)
   end if
end subroutine

subroutine IfW_FlowField_PackGrid3DFieldType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Grid3DFieldType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'IfW_FlowField_PackGrid3DFieldType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%WindFileFormat)
   call RegPack(RF, InData%WindProfileType)
   call RegPack(RF, InData%Periodic)
   call RegPack(RF, InData%InterpTower)
   call RegPack(RF, InData%AddMeanAfterInterp)
   call RegPack(RF, InData%RefHeight)
   call RegPack(RF, InData%RefLength)
   call RegPackAlloc(RF, InData%Vel)
   call RegPackAlloc(RF, InData%Acc)
   call RegPackAlloc(RF, InData%VelTower)
   call RegPackAlloc(RF, InData%AccTower)
   call RegPackAlloc(RF, InData%VelAvg)
   call RegPackAlloc(RF, InData%AccAvg)
   call RegPack(RF, InData%DTime)
   call RegPack(RF, InData%Rate)
   call RegPack(RF, InData%YHWid)
   call RegPack(RF, InData%ZHWid)
   call RegPack(RF, InData%GridBase)
   call RegPack(RF, InData%InitXPosition)
   call RegPack(RF, InData%InvDY)
   call RegPack(RF, InData%InvDZ)
   call RegPack(RF, InData%MeanWS)
   call RegPack(RF, InData%InvMWS)
   call RegPack(RF, InData%TotalTime)
   call RegPack(RF, InData%NComp)
   call RegPack(RF, InData%NYGrids)
   call RegPack(RF, InData%NZGrids)
   call RegPack(RF, InData%NTGrids)
   call RegPack(RF, InData%NSteps)
   call RegPack(RF, InData%PLExp)
   call RegPack(RF, InData%Z0)
   call RegPack(RF, InData%VLinShr)
   call RegPack(RF, InData%HLinShr)
   call RegPack(RF, InData%BoxExceedAllow)
   call RegPack(RF, InData%BoxExceedAllowDrv)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IfW_FlowField_UnPackGrid3DFieldType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Grid3DFieldType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'IfW_FlowField_UnPackGrid3DFieldType'
   integer(B4Ki)   :: LB(4), UB(4)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%WindFileFormat); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WindProfileType); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Periodic); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%InterpTower); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AddMeanAfterInterp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RefHeight); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RefLength); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Vel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Acc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%VelTower); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AccTower); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%VelAvg); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AccAvg); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DTime); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Rate); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YHWid); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ZHWid); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GridBase); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%InitXPosition); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%InvDY); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%InvDZ); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MeanWS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%InvMWS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TotalTime); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NComp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NYGrids); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NZGrids); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NTGrids); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NSteps); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PLExp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Z0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VLinShr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HLinShr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BoxExceedAllow); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BoxExceedAllowDrv); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IfW_FlowField_CopyGrid4DFieldType(SrcGrid4DFieldTypeData, DstGrid4DFieldTypeData, CtrlCode, ErrStat, ErrMsg)
   type(Grid4DFieldType), intent(in) :: SrcGrid4DFieldTypeData
   type(Grid4DFieldType), intent(inout) :: DstGrid4DFieldTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(5), UB(5)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'IfW_FlowField_CopyGrid4DFieldType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstGrid4DFieldTypeData%n = SrcGrid4DFieldTypeData%n
   DstGrid4DFieldTypeData%delta = SrcGrid4DFieldTypeData%delta
   DstGrid4DFieldTypeData%pZero = SrcGrid4DFieldTypeData%pZero
   DstGrid4DFieldTypeData%Vel => SrcGrid4DFieldTypeData%Vel
   DstGrid4DFieldTypeData%TimeStart = SrcGrid4DFieldTypeData%TimeStart
   DstGrid4DFieldTypeData%RefHeight = SrcGrid4DFieldTypeData%RefHeight
end subroutine

subroutine IfW_FlowField_DestroyGrid4DFieldType(Grid4DFieldTypeData, ErrStat, ErrMsg)
   type(Grid4DFieldType), intent(inout) :: Grid4DFieldTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'IfW_FlowField_DestroyGrid4DFieldType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   nullify(Grid4DFieldTypeData%Vel)
end subroutine

subroutine IfW_FlowField_PackGrid4DFieldType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Grid4DFieldType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'IfW_FlowField_PackGrid4DFieldType'
   logical         :: PtrInIndex
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%n)
   call RegPack(RF, InData%delta)
   call RegPack(RF, InData%pZero)
   call RegPackPtr(RF, InData%Vel)
   call RegPack(RF, InData%TimeStart)
   call RegPack(RF, InData%RefHeight)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IfW_FlowField_UnPackGrid4DFieldType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Grid4DFieldType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'IfW_FlowField_UnPackGrid4DFieldType'
   integer(B4Ki)   :: LB(5), UB(5)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   integer(B8Ki)   :: PtrIdx
   type(c_ptr)     :: Ptr
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%n); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%delta); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%pZero); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackPtr(RF, OutData%Vel, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TimeStart); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RefHeight); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IfW_FlowField_CopyPointsFieldType(SrcPointsFieldTypeData, DstPointsFieldTypeData, CtrlCode, ErrStat, ErrMsg)
   type(PointsFieldType), intent(in) :: SrcPointsFieldTypeData
   type(PointsFieldType), intent(inout) :: DstPointsFieldTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'IfW_FlowField_CopyPointsFieldType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcPointsFieldTypeData%Vel)) then
      LB(1:2) = lbound(SrcPointsFieldTypeData%Vel)
      UB(1:2) = ubound(SrcPointsFieldTypeData%Vel)
      if (.not. allocated(DstPointsFieldTypeData%Vel)) then
         allocate(DstPointsFieldTypeData%Vel(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstPointsFieldTypeData%Vel.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstPointsFieldTypeData%Vel = SrcPointsFieldTypeData%Vel
   end if
end subroutine

subroutine IfW_FlowField_DestroyPointsFieldType(PointsFieldTypeData, ErrStat, ErrMsg)
   type(PointsFieldType), intent(inout) :: PointsFieldTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'IfW_FlowField_DestroyPointsFieldType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(PointsFieldTypeData%Vel)) then
      deallocate(PointsFieldTypeData%Vel)
   end if
end subroutine

subroutine IfW_FlowField_PackPointsFieldType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(PointsFieldType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'IfW_FlowField_PackPointsFieldType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%Vel)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IfW_FlowField_UnPackPointsFieldType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(PointsFieldType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'IfW_FlowField_UnPackPointsFieldType'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%Vel); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IfW_FlowField_CopyUserFieldType(SrcUserFieldTypeData, DstUserFieldTypeData, CtrlCode, ErrStat, ErrMsg)
   type(UserFieldType), intent(in) :: SrcUserFieldTypeData
   type(UserFieldType), intent(inout) :: DstUserFieldTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'IfW_FlowField_CopyUserFieldType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstUserFieldTypeData%RefHeight = SrcUserFieldTypeData%RefHeight
end subroutine

subroutine IfW_FlowField_DestroyUserFieldType(UserFieldTypeData, ErrStat, ErrMsg)
   type(UserFieldType), intent(inout) :: UserFieldTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'IfW_FlowField_DestroyUserFieldType'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine IfW_FlowField_PackUserFieldType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(UserFieldType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'IfW_FlowField_PackUserFieldType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%RefHeight)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IfW_FlowField_UnPackUserFieldType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(UserFieldType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'IfW_FlowField_UnPackUserFieldType'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%RefHeight); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IfW_FlowField_CopyFlowFieldType(SrcFlowFieldTypeData, DstFlowFieldTypeData, CtrlCode, ErrStat, ErrMsg)
   type(FlowFieldType), intent(in) :: SrcFlowFieldTypeData
   type(FlowFieldType), intent(inout) :: DstFlowFieldTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'IfW_FlowField_CopyFlowFieldType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstFlowFieldTypeData%FieldType = SrcFlowFieldTypeData%FieldType
   DstFlowFieldTypeData%RefPosition = SrcFlowFieldTypeData%RefPosition
   DstFlowFieldTypeData%PropagationDir = SrcFlowFieldTypeData%PropagationDir
   DstFlowFieldTypeData%VFlowAngle = SrcFlowFieldTypeData%VFlowAngle
   DstFlowFieldTypeData%VelInterpCubic = SrcFlowFieldTypeData%VelInterpCubic
   DstFlowFieldTypeData%RotateWindBox = SrcFlowFieldTypeData%RotateWindBox
   DstFlowFieldTypeData%AccFieldValid = SrcFlowFieldTypeData%AccFieldValid
   DstFlowFieldTypeData%RotToWind = SrcFlowFieldTypeData%RotToWind
   DstFlowFieldTypeData%RotFromWind = SrcFlowFieldTypeData%RotFromWind
   call IfW_FlowField_CopyUniformFieldType(SrcFlowFieldTypeData%Uniform, DstFlowFieldTypeData%Uniform, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call IfW_FlowField_CopyGrid3DFieldType(SrcFlowFieldTypeData%Grid3D, DstFlowFieldTypeData%Grid3D, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call IfW_FlowField_CopyGrid4DFieldType(SrcFlowFieldTypeData%Grid4D, DstFlowFieldTypeData%Grid4D, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call IfW_FlowField_CopyPointsFieldType(SrcFlowFieldTypeData%Points, DstFlowFieldTypeData%Points, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call IfW_FlowField_CopyUserFieldType(SrcFlowFieldTypeData%User, DstFlowFieldTypeData%User, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine IfW_FlowField_DestroyFlowFieldType(FlowFieldTypeData, ErrStat, ErrMsg)
   type(FlowFieldType), intent(inout) :: FlowFieldTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'IfW_FlowField_DestroyFlowFieldType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call IfW_FlowField_DestroyUniformFieldType(FlowFieldTypeData%Uniform, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call IfW_FlowField_DestroyGrid3DFieldType(FlowFieldTypeData%Grid3D, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call IfW_FlowField_DestroyGrid4DFieldType(FlowFieldTypeData%Grid4D, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call IfW_FlowField_DestroyPointsFieldType(FlowFieldTypeData%Points, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call IfW_FlowField_DestroyUserFieldType(FlowFieldTypeData%User, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine IfW_FlowField_PackFlowFieldType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FlowFieldType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'IfW_FlowField_PackFlowFieldType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%FieldType)
   call RegPack(RF, InData%RefPosition)
   call RegPack(RF, InData%PropagationDir)
   call RegPack(RF, InData%VFlowAngle)
   call RegPack(RF, InData%VelInterpCubic)
   call RegPack(RF, InData%RotateWindBox)
   call RegPack(RF, InData%AccFieldValid)
   call RegPack(RF, InData%RotToWind)
   call RegPack(RF, InData%RotFromWind)
   call IfW_FlowField_PackUniformFieldType(RF, InData%Uniform) 
   call IfW_FlowField_PackGrid3DFieldType(RF, InData%Grid3D) 
   call IfW_FlowField_PackGrid4DFieldType(RF, InData%Grid4D) 
   call IfW_FlowField_PackPointsFieldType(RF, InData%Points) 
   call IfW_FlowField_PackUserFieldType(RF, InData%User) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IfW_FlowField_UnPackFlowFieldType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FlowFieldType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'IfW_FlowField_UnPackFlowFieldType'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%FieldType); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RefPosition); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PropagationDir); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VFlowAngle); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VelInterpCubic); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RotateWindBox); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AccFieldValid); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RotToWind); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RotFromWind); if (RegCheckErr(RF, RoutineName)) return
   call IfW_FlowField_UnpackUniformFieldType(RF, OutData%Uniform) ! Uniform 
   call IfW_FlowField_UnpackGrid3DFieldType(RF, OutData%Grid3D) ! Grid3D 
   call IfW_FlowField_UnpackGrid4DFieldType(RF, OutData%Grid4D) ! Grid4D 
   call IfW_FlowField_UnpackPointsFieldType(RF, OutData%Points) ! Points 
   call IfW_FlowField_UnpackUserFieldType(RF, OutData%User) ! User 
end subroutine
END MODULE IfW_FlowField_Types
!ENDOFREGISTRYGENERATEDFILE
