!STARTOFREGISTRYGENERATEDFILE 'IceFloe_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! IceFloe_Types
!.................................................................................................................................
! This file is part of IceFloe.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in IceFloe. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE IceFloe_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE NWTC_Library
IMPLICIT NONE
! =========  IceFloe_InitInputType  =======
  TYPE, PUBLIC :: IceFloe_InitInputType
    CHARACTER(1024)  :: InputFile      !< Name of the input file [-]
    REAL(ReKi)  :: simLength = 0.0_ReKi      !< Duration of simulation [sec]
    REAL(ReKi)  :: MSL2SWL = 0.0_ReKi      !< Offset between still-water level and mean sea level [m]
    REAL(ReKi)  :: gravity = 0.0_ReKi      !< Gravitational acceleration [m/s^2]
    character(1024)  :: RootName      !< Output file root name [-]
  END TYPE IceFloe_InitInputType
! =======================
! =========  IceFloe_InitOutputType  =======
  TYPE, PUBLIC :: IceFloe_InitOutputType
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputHdr      !< Names of the output-to-file channels [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputUnt      !< Units of the output-to-file channels [-]
    TYPE(ProgDesc)  :: Ver      !< This module's name, version, and date [-]
  END TYPE IceFloe_InitOutputType
! =======================
! =========  IceFloe_ContinuousStateType  =======
  TYPE, PUBLIC :: IceFloe_ContinuousStateType
    REAL(SiKi)  :: DummyContStateVar = 0.0_R4Ki      !< None currently used [-]
  END TYPE IceFloe_ContinuousStateType
! =======================
! =========  IceFloe_DiscreteStateType  =======
  TYPE, PUBLIC :: IceFloe_DiscreteStateType
    REAL(SiKi)  :: DummyDiscStateVar = 0.0_R4Ki      !< None currently used [-]
  END TYPE IceFloe_DiscreteStateType
! =======================
! =========  IceFloe_ConstraintStateType  =======
  TYPE, PUBLIC :: IceFloe_ConstraintStateType
    REAL(SiKi)  :: DummyConstrStateVar = 0.0_R4Ki      !< None currently used [-]
  END TYPE IceFloe_ConstraintStateType
! =======================
! =========  IceFloe_OtherStateType  =======
  TYPE, PUBLIC :: IceFloe_OtherStateType
    INTEGER(IntKi)  :: DummyOtherState = 0_IntKi      !< Remove this variable if you have other states [-]
  END TYPE IceFloe_OtherStateType
! =======================
! =========  IceFloe_MiscVarType  =======
  TYPE, PUBLIC :: IceFloe_MiscVarType
    INTEGER(IntKi)  :: DummyMiscVar = 0_IntKi      !< Remove this variable if you have misc/optimization variables [-]
  END TYPE IceFloe_MiscVarType
! =======================
! =========  IceFloe_ParameterType  =======
  TYPE, PUBLIC :: IceFloe_ParameterType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: loadSeries      !< - [precalculated time series of ice loads for each leg]
    REAL(ReKi)  :: iceVel = 0.0_ReKi      !< ice floe velocity [m/s]
    REAL(ReKi)  :: iceDirection = 0.0_ReKi      !< ice floe direction [degrees]
    REAL(ReKi)  :: minStrength = 0.0_ReKi      !< minimum dynamic ice strength [Pa]
    REAL(ReKi)  :: minStrengthNegVel = 0.0_ReKi      !< minimum dynamic ice strength for negative velocity [Pa]
    REAL(ReKi)  :: defaultArea = 0.0_ReKi      !< structure width to use in cpld crushin [m]
    REAL(ReKi)  :: crushArea = 0.0_ReKi      !< cross sectional area of ice against tower [m^2]
    REAL(ReKi)  :: coeffStressRate = 0.0_ReKi      !< coefficient to calc stress rate from relative vellocity [Pa/m]
    REAL(ReKi)  :: C(4) = 0.0_ReKi      !< coefficient of cubic transition curve for negative stress rates [-]
    REAL(ReKi)  :: dt = 0.0_ReKi      !< time step [sec]
    REAL(ReKi)  :: rampTime = 0.0_ReKi      !< load ramp up time [sec]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: legX      !< - [x position of each leg relative to structure center]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: legY      !< - [y position of each leg relative to structure center]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: ks      !< - [shelter factor due to upstream leg]
    INTEGER(IntKi)  :: numLegs = 0_IntKi      !< Number of tower legs (=1 for monopile) [-]
    INTEGER(IntKi)  :: iceType = 0_IntKi      !< Type of ice Floe: flex, crush, etc. [-]
    INTEGER(IntKi)  :: logUnitNum = 0_IntKi      !< Unit number for log file [-]
    LOGICAL  :: singleLoad = .false.      !< Flag for load application at single point vs multiple legs [-]
    LOGICAL  :: initFlag = .false.      !< Flag for successful initialization [-]
  END TYPE IceFloe_ParameterType
! =======================
! =========  IceFloe_InputType  =======
  TYPE, PUBLIC :: IceFloe_InputType
    TYPE(MeshType)  :: iceMesh      !< Horizontal velocities on support structure leg(s) at water line [-]
  END TYPE IceFloe_InputType
! =======================
! =========  IceFloe_OutputType  =======
  TYPE, PUBLIC :: IceFloe_OutputType
    TYPE(MeshType)  :: iceMesh      !< Horizontal forces and torsional moment(s) on support structure leg(s) at water line [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WriteOutput      !< Data to be written to an output file: see WriteOutputHdr for names of each variable [see WriteOutputUnt]
  END TYPE IceFloe_OutputType
! =======================
CONTAINS

subroutine IceFloe_CopyInitInput(SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg)
   type(IceFloe_InitInputType), intent(in) :: SrcInitInputData
   type(IceFloe_InitInputType), intent(inout) :: DstInitInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'IceFloe_CopyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInitInputData%InputFile = SrcInitInputData%InputFile
   DstInitInputData%simLength = SrcInitInputData%simLength
   DstInitInputData%MSL2SWL = SrcInitInputData%MSL2SWL
   DstInitInputData%gravity = SrcInitInputData%gravity
   DstInitInputData%RootName = SrcInitInputData%RootName
end subroutine

subroutine IceFloe_DestroyInitInput(InitInputData, ErrStat, ErrMsg)
   type(IceFloe_InitInputType), intent(inout) :: InitInputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'IceFloe_DestroyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine IceFloe_PackInitInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(IceFloe_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'IceFloe_PackInitInput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%InputFile)
   call RegPack(RF, InData%simLength)
   call RegPack(RF, InData%MSL2SWL)
   call RegPack(RF, InData%gravity)
   call RegPack(RF, InData%RootName)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IceFloe_UnPackInitInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(IceFloe_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'IceFloe_UnPackInitInput'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%InputFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%simLength); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MSL2SWL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%gravity); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootName); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IceFloe_CopyInitOutput(SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg)
   type(IceFloe_InitOutputType), intent(in) :: SrcInitOutputData
   type(IceFloe_InitOutputType), intent(inout) :: DstInitOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'IceFloe_CopyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcInitOutputData%WriteOutputHdr)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputHdr)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputHdr)
      if (.not. allocated(DstInitOutputData%WriteOutputHdr)) then
         allocate(DstInitOutputData%WriteOutputHdr(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputHdr.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputHdr = SrcInitOutputData%WriteOutputHdr
   end if
   if (allocated(SrcInitOutputData%WriteOutputUnt)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputUnt)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputUnt)
      if (.not. allocated(DstInitOutputData%WriteOutputUnt)) then
         allocate(DstInitOutputData%WriteOutputUnt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputUnt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputUnt = SrcInitOutputData%WriteOutputUnt
   end if
   call NWTC_Library_CopyProgDesc(SrcInitOutputData%Ver, DstInitOutputData%Ver, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine IceFloe_DestroyInitOutput(InitOutputData, ErrStat, ErrMsg)
   type(IceFloe_InitOutputType), intent(inout) :: InitOutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'IceFloe_DestroyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InitOutputData%WriteOutputHdr)) then
      deallocate(InitOutputData%WriteOutputHdr)
   end if
   if (allocated(InitOutputData%WriteOutputUnt)) then
      deallocate(InitOutputData%WriteOutputUnt)
   end if
   call NWTC_Library_DestroyProgDesc(InitOutputData%Ver, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine IceFloe_PackInitOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(IceFloe_InitOutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'IceFloe_PackInitOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%WriteOutputHdr)
   call RegPackAlloc(RF, InData%WriteOutputUnt)
   call NWTC_Library_PackProgDesc(RF, InData%Ver) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IceFloe_UnPackInitOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(IceFloe_InitOutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'IceFloe_UnPackInitOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%WriteOutputHdr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutputUnt); if (RegCheckErr(RF, RoutineName)) return
   call NWTC_Library_UnpackProgDesc(RF, OutData%Ver) ! Ver 
end subroutine

subroutine IceFloe_CopyContState(SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg)
   type(IceFloe_ContinuousStateType), intent(in) :: SrcContStateData
   type(IceFloe_ContinuousStateType), intent(inout) :: DstContStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'IceFloe_CopyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstContStateData%DummyContStateVar = SrcContStateData%DummyContStateVar
end subroutine

subroutine IceFloe_DestroyContState(ContStateData, ErrStat, ErrMsg)
   type(IceFloe_ContinuousStateType), intent(inout) :: ContStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'IceFloe_DestroyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine IceFloe_PackContState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(IceFloe_ContinuousStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'IceFloe_PackContState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyContStateVar)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IceFloe_UnPackContState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(IceFloe_ContinuousStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'IceFloe_UnPackContState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyContStateVar); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IceFloe_CopyDiscState(SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg)
   type(IceFloe_DiscreteStateType), intent(in) :: SrcDiscStateData
   type(IceFloe_DiscreteStateType), intent(inout) :: DstDiscStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'IceFloe_CopyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstDiscStateData%DummyDiscStateVar = SrcDiscStateData%DummyDiscStateVar
end subroutine

subroutine IceFloe_DestroyDiscState(DiscStateData, ErrStat, ErrMsg)
   type(IceFloe_DiscreteStateType), intent(inout) :: DiscStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'IceFloe_DestroyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine IceFloe_PackDiscState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(IceFloe_DiscreteStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'IceFloe_PackDiscState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyDiscStateVar)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IceFloe_UnPackDiscState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(IceFloe_DiscreteStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'IceFloe_UnPackDiscState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyDiscStateVar); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IceFloe_CopyConstrState(SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg)
   type(IceFloe_ConstraintStateType), intent(in) :: SrcConstrStateData
   type(IceFloe_ConstraintStateType), intent(inout) :: DstConstrStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'IceFloe_CopyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstConstrStateData%DummyConstrStateVar = SrcConstrStateData%DummyConstrStateVar
end subroutine

subroutine IceFloe_DestroyConstrState(ConstrStateData, ErrStat, ErrMsg)
   type(IceFloe_ConstraintStateType), intent(inout) :: ConstrStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'IceFloe_DestroyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine IceFloe_PackConstrState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(IceFloe_ConstraintStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'IceFloe_PackConstrState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyConstrStateVar)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IceFloe_UnPackConstrState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(IceFloe_ConstraintStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'IceFloe_UnPackConstrState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyConstrStateVar); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IceFloe_CopyOtherState(SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg)
   type(IceFloe_OtherStateType), intent(in) :: SrcOtherStateData
   type(IceFloe_OtherStateType), intent(inout) :: DstOtherStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'IceFloe_CopyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstOtherStateData%DummyOtherState = SrcOtherStateData%DummyOtherState
end subroutine

subroutine IceFloe_DestroyOtherState(OtherStateData, ErrStat, ErrMsg)
   type(IceFloe_OtherStateType), intent(inout) :: OtherStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'IceFloe_DestroyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine IceFloe_PackOtherState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(IceFloe_OtherStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'IceFloe_PackOtherState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyOtherState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IceFloe_UnPackOtherState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(IceFloe_OtherStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'IceFloe_UnPackOtherState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyOtherState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IceFloe_CopyMisc(SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg)
   type(IceFloe_MiscVarType), intent(in) :: SrcMiscData
   type(IceFloe_MiscVarType), intent(inout) :: DstMiscData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'IceFloe_CopyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstMiscData%DummyMiscVar = SrcMiscData%DummyMiscVar
end subroutine

subroutine IceFloe_DestroyMisc(MiscData, ErrStat, ErrMsg)
   type(IceFloe_MiscVarType), intent(inout) :: MiscData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'IceFloe_DestroyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine IceFloe_PackMisc(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(IceFloe_MiscVarType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'IceFloe_PackMisc'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyMiscVar)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IceFloe_UnPackMisc(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(IceFloe_MiscVarType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'IceFloe_UnPackMisc'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyMiscVar); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IceFloe_CopyParam(SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg)
   type(IceFloe_ParameterType), intent(in) :: SrcParamData
   type(IceFloe_ParameterType), intent(inout) :: DstParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'IceFloe_CopyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcParamData%loadSeries)) then
      LB(1:2) = lbound(SrcParamData%loadSeries)
      UB(1:2) = ubound(SrcParamData%loadSeries)
      if (.not. allocated(DstParamData%loadSeries)) then
         allocate(DstParamData%loadSeries(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%loadSeries.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%loadSeries = SrcParamData%loadSeries
   end if
   DstParamData%iceVel = SrcParamData%iceVel
   DstParamData%iceDirection = SrcParamData%iceDirection
   DstParamData%minStrength = SrcParamData%minStrength
   DstParamData%minStrengthNegVel = SrcParamData%minStrengthNegVel
   DstParamData%defaultArea = SrcParamData%defaultArea
   DstParamData%crushArea = SrcParamData%crushArea
   DstParamData%coeffStressRate = SrcParamData%coeffStressRate
   DstParamData%C(4) = SrcParamData%C(4)
   DstParamData%dt = SrcParamData%dt
   DstParamData%rampTime = SrcParamData%rampTime
   if (allocated(SrcParamData%legX)) then
      LB(1:1) = lbound(SrcParamData%legX)
      UB(1:1) = ubound(SrcParamData%legX)
      if (.not. allocated(DstParamData%legX)) then
         allocate(DstParamData%legX(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%legX.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%legX = SrcParamData%legX
   end if
   if (allocated(SrcParamData%legY)) then
      LB(1:1) = lbound(SrcParamData%legY)
      UB(1:1) = ubound(SrcParamData%legY)
      if (.not. allocated(DstParamData%legY)) then
         allocate(DstParamData%legY(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%legY.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%legY = SrcParamData%legY
   end if
   if (allocated(SrcParamData%ks)) then
      LB(1:1) = lbound(SrcParamData%ks)
      UB(1:1) = ubound(SrcParamData%ks)
      if (.not. allocated(DstParamData%ks)) then
         allocate(DstParamData%ks(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%ks.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%ks = SrcParamData%ks
   end if
   DstParamData%numLegs = SrcParamData%numLegs
   DstParamData%iceType = SrcParamData%iceType
   DstParamData%logUnitNum = SrcParamData%logUnitNum
   DstParamData%singleLoad = SrcParamData%singleLoad
   DstParamData%initFlag = SrcParamData%initFlag
end subroutine

subroutine IceFloe_DestroyParam(ParamData, ErrStat, ErrMsg)
   type(IceFloe_ParameterType), intent(inout) :: ParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'IceFloe_DestroyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ParamData%loadSeries)) then
      deallocate(ParamData%loadSeries)
   end if
   if (allocated(ParamData%legX)) then
      deallocate(ParamData%legX)
   end if
   if (allocated(ParamData%legY)) then
      deallocate(ParamData%legY)
   end if
   if (allocated(ParamData%ks)) then
      deallocate(ParamData%ks)
   end if
end subroutine

subroutine IceFloe_PackParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(IceFloe_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'IceFloe_PackParam'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%loadSeries)
   call RegPack(RF, InData%iceVel)
   call RegPack(RF, InData%iceDirection)
   call RegPack(RF, InData%minStrength)
   call RegPack(RF, InData%minStrengthNegVel)
   call RegPack(RF, InData%defaultArea)
   call RegPack(RF, InData%crushArea)
   call RegPack(RF, InData%coeffStressRate)
   call RegPack(RF, InData%C(4))
   call RegPack(RF, InData%dt)
   call RegPack(RF, InData%rampTime)
   call RegPackAlloc(RF, InData%legX)
   call RegPackAlloc(RF, InData%legY)
   call RegPackAlloc(RF, InData%ks)
   call RegPack(RF, InData%numLegs)
   call RegPack(RF, InData%iceType)
   call RegPack(RF, InData%logUnitNum)
   call RegPack(RF, InData%singleLoad)
   call RegPack(RF, InData%initFlag)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IceFloe_UnPackParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(IceFloe_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'IceFloe_UnPackParam'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%loadSeries); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%iceVel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%iceDirection); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%minStrength); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%minStrengthNegVel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%defaultArea); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%crushArea); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%coeffStressRate); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C(4)); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rampTime); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%legX); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%legY); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%ks); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%numLegs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%iceType); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%logUnitNum); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%singleLoad); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%initFlag); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IceFloe_CopyInput(SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg)
   type(IceFloe_InputType), intent(inout) :: SrcInputData
   type(IceFloe_InputType), intent(inout) :: DstInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'IceFloe_CopyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshCopy(SrcInputData%iceMesh, DstInputData%iceMesh, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine IceFloe_DestroyInput(InputData, ErrStat, ErrMsg)
   type(IceFloe_InputType), intent(inout) :: InputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'IceFloe_DestroyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshDestroy( InputData%iceMesh, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine IceFloe_PackInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(IceFloe_InputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'IceFloe_PackInput'
   if (RF%ErrStat >= AbortErrLev) return
   call MeshPack(RF, InData%iceMesh) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IceFloe_UnPackInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(IceFloe_InputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'IceFloe_UnPackInput'
   if (RF%ErrStat /= ErrID_None) return
   call MeshUnpack(RF, OutData%iceMesh) ! iceMesh 
end subroutine

subroutine IceFloe_CopyOutput(SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg)
   type(IceFloe_OutputType), intent(inout) :: SrcOutputData
   type(IceFloe_OutputType), intent(inout) :: DstOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'IceFloe_CopyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshCopy(SrcOutputData%iceMesh, DstOutputData%iceMesh, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcOutputData%WriteOutput)) then
      LB(1:1) = lbound(SrcOutputData%WriteOutput)
      UB(1:1) = ubound(SrcOutputData%WriteOutput)
      if (.not. allocated(DstOutputData%WriteOutput)) then
         allocate(DstOutputData%WriteOutput(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%WriteOutput.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%WriteOutput = SrcOutputData%WriteOutput
   end if
end subroutine

subroutine IceFloe_DestroyOutput(OutputData, ErrStat, ErrMsg)
   type(IceFloe_OutputType), intent(inout) :: OutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'IceFloe_DestroyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshDestroy( OutputData%iceMesh, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(OutputData%WriteOutput)) then
      deallocate(OutputData%WriteOutput)
   end if
end subroutine

subroutine IceFloe_PackOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(IceFloe_OutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'IceFloe_PackOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call MeshPack(RF, InData%iceMesh) 
   call RegPackAlloc(RF, InData%WriteOutput)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IceFloe_UnPackOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(IceFloe_OutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'IceFloe_UnPackOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call MeshUnpack(RF, OutData%iceMesh) ! iceMesh 
   call RegUnpackAlloc(RF, OutData%WriteOutput); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IceFloe_Input_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
   ! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(IceFloe_InputType), intent(inout)  :: u(:) ! Input at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Inputs
   type(IceFloe_InputType), intent(inout)  :: u_out ! Input at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'IceFloe_Input_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(u)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(u)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(u) - 1
   select case (order)
   case (0)
      call IceFloe_CopyInput(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call IceFloe_Input_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call IceFloe_Input_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(u) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE IceFloe_Input_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

   TYPE(IceFloe_InputType), INTENT(INOUT)  :: u1    ! Input at t1 > t2
   TYPE(IceFloe_InputType), INTENT(INOUT)  :: u2    ! Input at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Inputs
   TYPE(IceFloe_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'IceFloe_Input_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   CALL MeshExtrapInterp1(u1%iceMesh, u2%iceMesh, tin, u_out%iceMesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
END SUBROUTINE

SUBROUTINE IceFloe_Input_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

   TYPE(IceFloe_InputType), INTENT(INOUT)  :: u1      ! Input at t1 > t2 > t3
   TYPE(IceFloe_InputType), INTENT(INOUT)  :: u2      ! Input at t2 > t3
   TYPE(IceFloe_InputType), INTENT(INOUT)  :: u3      ! Input at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Inputs
   TYPE(IceFloe_InputType), INTENT(INOUT)  :: u_out     ! Input at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'IceFloe_Input_ExtrapInterp2'
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   CALL MeshExtrapInterp2(u1%iceMesh, u2%iceMesh, u3%iceMesh, tin, u_out%iceMesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
END SUBROUTINE

subroutine IceFloe_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
   ! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(IceFloe_OutputType), intent(inout)  :: y(:) ! Output at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Outputs
   type(IceFloe_OutputType), intent(inout)  :: y_out ! Output at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'IceFloe_Output_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(y)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(y)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(y) - 1
   select case (order)
   case (0)
      call IceFloe_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call IceFloe_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call IceFloe_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(y) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE IceFloe_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

   TYPE(IceFloe_OutputType), INTENT(INOUT)  :: y1    ! Output at t1 > t2
   TYPE(IceFloe_OutputType), INTENT(INOUT)  :: y2    ! Output at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
   TYPE(IceFloe_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'IceFloe_Output_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   CALL MeshExtrapInterp1(y1%iceMesh, y2%iceMesh, tin, y_out%iceMesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
      y_out%WriteOutput = a1*y1%WriteOutput + a2*y2%WriteOutput
   END IF ! check if allocated
END SUBROUTINE

SUBROUTINE IceFloe_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

   TYPE(IceFloe_OutputType), INTENT(INOUT)  :: y1      ! Output at t1 > t2 > t3
   TYPE(IceFloe_OutputType), INTENT(INOUT)  :: y2      ! Output at t2 > t3
   TYPE(IceFloe_OutputType), INTENT(INOUT)  :: y3      ! Output at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
   TYPE(IceFloe_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'IceFloe_Output_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   CALL MeshExtrapInterp2(y1%iceMesh, y2%iceMesh, y3%iceMesh, tin, y_out%iceMesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
      y_out%WriteOutput = a1*y1%WriteOutput + a2*y2%WriteOutput + a3*y3%WriteOutput
   END IF ! check if allocated
END SUBROUTINE
END MODULE IceFloe_Types
!ENDOFREGISTRYGENERATEDFILE
