!STARTOFREGISTRYGENERATEDFILE 'IceDyn_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! IceDyn_Types
!.................................................................................................................................
! This file is part of IceDyn.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in IceDyn. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE IceDyn_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE NWTC_Library
IMPLICIT NONE
! =========  IceD_InputFile  =======
  TYPE, PUBLIC :: IceD_InputFile
    INTEGER(IntKi)  :: IceModel = 0_IntKi      !< The current ice model number [-]
    INTEGER(IntKi)  :: IceSubModel = 0_IntKi      !< The current ice sub-model number [-]
    REAL(ReKi)  :: h = 0.0_ReKi      !< Ice thickness [m]
    REAL(ReKi)  :: v = 0.0_ReKi      !< Ice velocity [m/s]
    REAL(ReKi)  :: InitLoc = 0.0_ReKi      !< Ice sheet initial location [m]
    REAL(ReKi)  :: t0 = 0.0_ReKi      !< Ice load starting time [s]
    REAL(ReKi)  :: rhow = 0.0_ReKi      !< Water mass density [kg/m^3]
    REAL(ReKi)  :: rhoi = 0.0_ReKi      !< Ice mass density [kg/m^3]
    INTEGER(IntKi)  :: Seed1 = 0_IntKi      !< Random seed 1 [-]
    INTEGER(IntKi)  :: Seed2 = 0_IntKi      !< Random seed 2 [-]
    INTEGER(IntKi)  :: NumLegs = 0_IntKi      !< Number of support structure legs in ice [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LegPosX      !< global X position of legs 1-NumLegs  [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LegPosY      !< global Y position of legs 1-NumLegs  [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: StrWd      !< The width of the leg (structure) [m]
    REAL(ReKi)  :: Ikm = 0.0_ReKi      !< Indentation factor [-]
    REAL(ReKi)  :: Ag = 0.0_ReKi      !< Ice crystal type factor [MPa^-3s^-1]
    REAL(ReKi)  :: Qg = 0.0_ReKi      !< Activation energy [kJ]
    REAL(ReKi)  :: Rg = 0.0_ReKi      !< Universal gas constant [J]
    REAL(ReKi)  :: Tice = 0.0_ReKi      !< Ice temperature [K]
    REAL(ReKi)  :: nu = 0.0_ReKi      !< Poison ratio of ice [-]
    REAL(ReKi)  :: phi = 0.0_ReKi      !< Ice wedge angle [degree]
    REAL(ReKi)  :: SigNm = 0.0_ReKi      !< Nominal ice strength [MPa]
    REAL(ReKi)  :: Eice = 0.0_ReKi      !< Elastic modulus of ice [GPa]
    REAL(ReKi)  :: IceStr2 = 0.0_ReKi      !< Ice tooth brittle strength [MPa]
    REAL(ReKi)  :: Delmax2 = 0.0_ReKi      !< Ice tooth maximum elastic deformation for model 2 [m]
    REAL(ReKi)  :: Pitch = 0.0_ReKi      !< Distance between sequential ice teeth for model 2 [m]
    REAL(ReKi)  :: miuh = 0.0_ReKi      !< Mean value of random ice thickness [m]
    REAL(ReKi)  :: varh = 0.0_ReKi      !< Variance of random ice thicknesss [m^2]
    REAL(ReKi)  :: miuv = 0.0_ReKi      !< Mean value of random ice velocity [m/s]
    REAL(ReKi)  :: varv = 0.0_ReKi      !< Variance of random ice velocity [m^2/s^2]
    REAL(ReKi)  :: miut = 0.0_ReKi      !< Mean value of ice loading event duration time [s]
    REAL(ReKi)  :: miubr = 0.0_ReKi      !< Mean value of random ice brittle strength [MPa]
    REAL(ReKi)  :: varbr = 0.0_ReKi      !< Variance of random ice brittle strength [MPa^2]
    REAL(ReKi)  :: miuDelm = 0.0_ReKi      !< Mean value of random random maximum ice tooth tip displacement [MPa]
    REAL(ReKi)  :: varDelm = 0.0_ReKi      !< Variance of random random maximum ice tooth tip displacement [MPa^2]
    REAL(ReKi)  :: miuP = 0.0_ReKi      !< Mean value of random distance between sequential ice teeth [m]
    REAL(ReKi)  :: varP = 0.0_ReKi      !< Variance of random distance between sequential ice teeth [m^2]
    INTEGER(IntKi)  :: Zn1 = 0_IntKi      !< Number of failure zones along contact width [-]
    INTEGER(IntKi)  :: Zn2 = 0_IntKi      !< Number of failure zones along contact height/thickness [-]
    REAL(ReKi)  :: ZonePitch = 0.0_ReKi      !< Distance between sequential ice teeth [m]
    REAL(ReKi)  :: PrflMean = 0.0_ReKi      !< Ice structure contact profile mean value [m]
    REAL(ReKi)  :: PrflSig = 0.0_ReKi      !< Ice structure contact profile standard deviation [m]
    REAL(ReKi)  :: IceStr = 0.0_ReKi      !< Ice failure strength [MPa]
    REAL(ReKi)  :: Delmax = 0.0_ReKi      !< Ice teeth maximum elastic deformation [m]
    REAL(ReKi)  :: alpha = 0.0_ReKi      !< slope angle of the cone [degree]
    REAL(ReKi)  :: Dwl = 0.0_ReKi      !< cone waterline diameter [m]
    REAL(ReKi)  :: Dtp = 0.0_ReKi      !< cone top diameter [m]
    REAL(ReKi)  :: hr = 0.0_ReKi      !< ride-up ice thickness [m]
    REAL(ReKi)  :: mu = 0.0_ReKi      !< friction coefficient between structure and ice [-]
    REAL(ReKi)  :: sigf = 0.0_ReKi      !< flexural strength of ice [MPa]
    REAL(ReKi)  :: StrLim = 0.0_ReKi      !< limit strain [-]
    REAL(ReKi)  :: StrRtLim = 0.0_ReKi      !< limit strain rate [s^-1]
    INTEGER(IntKi)  :: UorD = 0_IntKi      !< flag that indicates upward or downward breaking cone: 0,upward, 1,downward. [-]
    REAL(ReKi)  :: Ll = 0.0_ReKi      !< Ice floe length [m]
    REAL(ReKi)  :: Lw = 0.0_ReKi      !< Ice floe width [m]
    REAL(ReKi)  :: Cpa = 0.0_ReKi      !< ice crushing strength pressure-area relation constant [-]
    REAL(ReKi)  :: dpa = 0.0_ReKi      !< ice crushing strength pressure-area relation order [-]
    REAL(ReKi)  :: Fdr = 0.0_ReKi      !< Constant external driving force [MN]
    REAL(ReKi)  :: Kic = 0.0_ReKi      !< Fracture toughness of ice [kNm^(-3/2)]
    REAL(ReKi)  :: FspN = 0.0_ReKi      !< Non-dimensional splitting load [-]
  END TYPE IceD_InputFile
! =======================
! =========  IceD_InitInputType  =======
  TYPE, PUBLIC :: IceD_InitInputType
    CHARACTER(1024)  :: InputFile      !< Name of the input file; remove if there is no file [-]
    CHARACTER(1024)  :: RootName      !< Root name of the output file [-]
    REAL(ReKi)  :: MSL2SWL = 0.0_ReKi      !< Offset between still-water level and mean sea level [m]
    REAL(ReKi)  :: WtrDens = 0.0_ReKi      !< Density of water [kg/m^3]
    REAL(ReKi)  :: gravity = 0.0_ReKi      !< Gravitational acceleration [m/s^2]
    INTEGER(IntKi)  :: LegNum = 0_IntKi      !< Which number of legs on the turbine this is being initialized for [m]
    REAL(DbKi)  :: TMax = 0.0_R8Ki      !< Total simulation time [s]
  END TYPE IceD_InitInputType
! =======================
! =========  IceD_InitOutputType  =======
  TYPE, PUBLIC :: IceD_InitOutputType
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputHdr      !< Names of the output-to-file channels [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputUnt      !< Units of the output-to-file channels [-]
    INTEGER(IntKi)  :: numLegs = 0_IntKi      !< Number of legs on the structure [-]
    TYPE(ProgDesc)  :: Ver      !< This module's name, version, and date [-]
  END TYPE IceD_InitOutputType
! =======================
! =========  IceD_ContinuousStateType  =======
  TYPE, PUBLIC :: IceD_ContinuousStateType
    REAL(ReKi)  :: q = 0.0_ReKi      !< q - displacement of ice mass [m]
    REAL(ReKi)  :: dqdt = 0.0_ReKi      !< dqdt - velocity of ice mass [m/s]
  END TYPE IceD_ContinuousStateType
! =======================
! =========  IceD_DiscreteStateType  =======
  TYPE, PUBLIC :: IceD_DiscreteStateType
    REAL(SiKi)  :: DummyDiscState = 0.0_R4Ki      !< A variable, Replace if you have discrete states [-]
  END TYPE IceD_DiscreteStateType
! =======================
! =========  IceD_ConstraintStateType  =======
  TYPE, PUBLIC :: IceD_ConstraintStateType
    REAL(SiKi)  :: DummyConstrState = 0.0_R4Ki      !< A variable, Replace if you have constraint states [-]
  END TYPE IceD_ConstraintStateType
! =======================
! =========  IceD_OtherStateType  =======
  TYPE, PUBLIC :: IceD_OtherStateType
    INTEGER(IntKi)  :: IceTthNo2 = 0_IntKi      !< Ice tooth number of the current ice tooth, for model 2 (updated in UpdateStates; used in CalcOutput) [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: Nc      !< Number of the current ice tooths number (time series) [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Psum      !< The sum of pitches of all broken ice teeth (time series) [m]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: IceTthNo      !< IceTthNo - the current numbers of ice teeth of each zone [-]
    REAL(ReKi)  :: Beta = 0.0_ReKi      !< angle between broken ice sheet and level waterline [rad]
    REAL(DbKi)  :: Tinit = 0.0_R8Ki      !< Initial time of the current load cycle [s]
    INTEGER(IntKi)  :: Splitf = 0_IntKi      !< flag to indicate if the ice floe has split (0 not splitted, 1 splitted) [-]
    REAL(ReKi)  :: dxc = 0.0_ReKi      !< crushed depth of ice [m]
    TYPE(IceD_ContinuousStateType) , DIMENSION(:), ALLOCATABLE  :: xdot      !< previous state deriv for multi-step [m]
    INTEGER(IntKi)  :: n = 0_IntKi      !< tracks time step for which OtherState was updated [-]
  END TYPE IceD_OtherStateType
! =======================
! =========  IceD_MiscVarType  =======
  TYPE, PUBLIC :: IceD_MiscVarType
    INTEGER(IntKi)  :: DummyMiscVar = 0_IntKi      !< Remove this variable if you have misc/optimization variables [-]
  END TYPE IceD_MiscVarType
! =======================
! =========  IceD_ParameterType  =======
  TYPE, PUBLIC :: IceD_ParameterType
    REAL(ReKi)  :: h = 0.0_ReKi      !< Ice thickness [m]
    REAL(ReKi)  :: v = 0.0_ReKi      !< Ice velocity [m/s]
    REAL(ReKi)  :: t0 = 0.0_ReKi      !< Ice load starting time [s]
    REAL(ReKi)  :: StrWd = 0.0_ReKi      !< The width of the structure [m]
    REAL(ReKi)  :: dt = 0.0_ReKi      !< Time interval for integration within the module [s]
    REAL(ReKi)  :: InitLoc = 0.0_ReKi      !< Ice sheet initial location [m]
    REAL(ReKi)  :: tolerance = 0.0_ReKi      !< Tolerance when calculating ice breaking force, etc. [-]
    REAL(ReKi)  :: Tmax = 0.0_ReKi      !< Total simulation time [s]
    INTEGER(IntKi)  :: verif = 0_IntKi      !< flag to indicate if verification is being peformed [-]
    INTEGER(IntKi)  :: ModNo = 0_IntKi      !< The current ice model number [-]
    INTEGER(IntKi)  :: SubModNo = 0_IntKi      !< The current ice sub-model number [-]
    INTEGER(IntKi)  :: NumOuts = 0_IntKi      !< The number of output channels [-]
    INTEGER(IntKi)  :: method = 0_IntKi      !< integration method: 1-RK4, 2-AB4, 3-ABM4 [-]
    INTEGER(IntKi)  :: TmStep = 0_IntKi      !< Total time step [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: OutName      !< Names of all requested output parameters [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: OutUnit      !< Units of all requested output parameters [-]
    CHARACTER(1024)  :: RootName      !< Rootname [-]
    REAL(ReKi)  :: tm1a = 0.0_ReKi      !< Time for the maximum force to be reached for model 1a [s]
    REAL(ReKi)  :: tm1b = 0.0_ReKi      !< Time for the maximum force to be reached for model 1b [s]
    REAL(ReKi)  :: tm1c = 0.0_ReKi      !< Time for the maximum force to be reached for model 1c [s]
    REAL(ReKi)  :: Fmax1a = 0.0_ReKi      !< Maximum ice force of model 1a [N]
    REAL(ReKi)  :: Fmax1b = 0.0_ReKi      !< Maximum ice force of model 1b [N]
    REAL(ReKi)  :: Fmax1c = 0.0_ReKi      !< Maximum ice force of model 1c [N]
    REAL(ReKi)  :: Ikm = 0.0_ReKi      !< Indentation factor [-]
    REAL(ReKi)  :: Cstr = 0.0_ReKi      !< Constant when calculating creeping stresss [Pa*s^(-1/3)]
    REAL(ReKi)  :: EiPa = 0.0_ReKi      !< Elastic modulus of ice [Pa]
    REAL(ReKi)  :: Delmax2 = 0.0_ReKi      !< Ice tooth maximum elastic deformation for model 2 [m]
    REAL(ReKi)  :: Pitch = 0.0_ReKi      !< Distance between sequential ice teeth [m]
    REAL(ReKi)  :: Kice2 = 0.0_ReKi      !< Stiffness of ice teeth for model 2 [N/m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: rdmFm      !< Random maximum ice force time series [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: rdmt0      !< Random ice loading event starting time [s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: rdmtm      !< Random time when the maximum force is reached [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: rdmDm      !< Random maximum ice tooth tip displacement time series [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: rdmP      !< Random distance between sequential ice teeth [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: rdmKi      !< Random ice teeth stiffness [N/m]
    REAL(ReKi)  :: ZonePitch = 0.0_ReKi      !< Distance between sequential ice teeth [m]
    REAL(ReKi)  :: Kice = 0.0_ReKi      !< Stiffness of ice teeth [N/m]
    REAL(ReKi)  :: Delmax = 0.0_ReKi      !< Ice teeth maximum elastic deformation [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Y0      !< Ice structure contact profile initial location [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: ContPrfl      !< Ice structure contact profile [m]
    INTEGER(IntKi)  :: Zn = 0_IntKi      !< Number of failure zones [-]
    REAL(ReKi)  :: rhoi = 0.0_ReKi      !< Ice mass density  [kg/m^3]
    REAL(ReKi)  :: rhow = 0.0_ReKi      !< Water mass density [kg/m^3]
    REAL(ReKi)  :: alphaR = 0.0_ReKi      !< Slope angle of the cone [rad]
    REAL(ReKi)  :: Dwl = 0.0_ReKi      !< Cone waterline diameter  [m]
    REAL(ReKi)  :: Zr = 0.0_ReKi      !< Ice ride-up height [m]
    REAL(ReKi)  :: RHbr = 0.0_ReKi      !< Horizontal breaking force [N]
    REAL(ReKi)  :: RVbr = 0.0_ReKi      !< Vertical breaking force [N]
    REAL(ReKi)  :: Lbr = 0.0_ReKi      !< Ice sheet breaking length [m]
    REAL(ReKi)  :: LovR = 0.0_ReKi      !< Ratio of ice breaking length over cone radius [-]
    REAL(ReKi)  :: mu = 0.0_ReKi      !< Friction coefficient between structure and ice [-]
    REAL(ReKi)  :: Wri = 0.0_ReKi      !< Initial ride-up ice weight  [kg]
    REAL(ReKi)  :: WL = 0.0_ReKi      !< Broken ice piece weight [kg]
    REAL(ReKi)  :: Cpa = 0.0_ReKi      !< ice crushing strength pressure-area relation constant [-]
    REAL(ReKi)  :: dpa = 0.0_ReKi      !< ice crushing strength pressure-area relation order [-]
    REAL(ReKi)  :: FdrN = 0.0_ReKi      !< Constant external driving force [N]
    REAL(ReKi)  :: Mice = 0.0_ReKi      !< Ice floe mass [kg]
    REAL(ReKi)  :: Fsp = 0.0_ReKi      !< Ice floe splitting force [N]
  END TYPE IceD_ParameterType
! =======================
! =========  IceD_InputType  =======
  TYPE, PUBLIC :: IceD_InputType
    TYPE(MeshType)  :: PointMesh      !< contains displacement and velocity of structure [-]
  END TYPE IceD_InputType
! =======================
! =========  IceD_OutputType  =======
  TYPE, PUBLIC :: IceD_OutputType
    TYPE(MeshType)  :: PointMesh      !< contains Ice force [N]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WriteOutput      !< Data to be written to an output file: see WriteOutputHdr for names of each variable [see WriteOutputUnt]
  END TYPE IceD_OutputType
! =======================
CONTAINS

subroutine IceD_CopyInputFile(SrcInputFileData, DstInputFileData, CtrlCode, ErrStat, ErrMsg)
   type(IceD_InputFile), intent(in) :: SrcInputFileData
   type(IceD_InputFile), intent(inout) :: DstInputFileData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'IceD_CopyInputFile'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInputFileData%IceModel = SrcInputFileData%IceModel
   DstInputFileData%IceSubModel = SrcInputFileData%IceSubModel
   DstInputFileData%h = SrcInputFileData%h
   DstInputFileData%v = SrcInputFileData%v
   DstInputFileData%InitLoc = SrcInputFileData%InitLoc
   DstInputFileData%t0 = SrcInputFileData%t0
   DstInputFileData%rhow = SrcInputFileData%rhow
   DstInputFileData%rhoi = SrcInputFileData%rhoi
   DstInputFileData%Seed1 = SrcInputFileData%Seed1
   DstInputFileData%Seed2 = SrcInputFileData%Seed2
   DstInputFileData%NumLegs = SrcInputFileData%NumLegs
   if (allocated(SrcInputFileData%LegPosX)) then
      LB(1:1) = lbound(SrcInputFileData%LegPosX)
      UB(1:1) = ubound(SrcInputFileData%LegPosX)
      if (.not. allocated(DstInputFileData%LegPosX)) then
         allocate(DstInputFileData%LegPosX(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%LegPosX.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%LegPosX = SrcInputFileData%LegPosX
   end if
   if (allocated(SrcInputFileData%LegPosY)) then
      LB(1:1) = lbound(SrcInputFileData%LegPosY)
      UB(1:1) = ubound(SrcInputFileData%LegPosY)
      if (.not. allocated(DstInputFileData%LegPosY)) then
         allocate(DstInputFileData%LegPosY(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%LegPosY.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%LegPosY = SrcInputFileData%LegPosY
   end if
   if (allocated(SrcInputFileData%StrWd)) then
      LB(1:1) = lbound(SrcInputFileData%StrWd)
      UB(1:1) = ubound(SrcInputFileData%StrWd)
      if (.not. allocated(DstInputFileData%StrWd)) then
         allocate(DstInputFileData%StrWd(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%StrWd.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%StrWd = SrcInputFileData%StrWd
   end if
   DstInputFileData%Ikm = SrcInputFileData%Ikm
   DstInputFileData%Ag = SrcInputFileData%Ag
   DstInputFileData%Qg = SrcInputFileData%Qg
   DstInputFileData%Rg = SrcInputFileData%Rg
   DstInputFileData%Tice = SrcInputFileData%Tice
   DstInputFileData%nu = SrcInputFileData%nu
   DstInputFileData%phi = SrcInputFileData%phi
   DstInputFileData%SigNm = SrcInputFileData%SigNm
   DstInputFileData%Eice = SrcInputFileData%Eice
   DstInputFileData%IceStr2 = SrcInputFileData%IceStr2
   DstInputFileData%Delmax2 = SrcInputFileData%Delmax2
   DstInputFileData%Pitch = SrcInputFileData%Pitch
   DstInputFileData%miuh = SrcInputFileData%miuh
   DstInputFileData%varh = SrcInputFileData%varh
   DstInputFileData%miuv = SrcInputFileData%miuv
   DstInputFileData%varv = SrcInputFileData%varv
   DstInputFileData%miut = SrcInputFileData%miut
   DstInputFileData%miubr = SrcInputFileData%miubr
   DstInputFileData%varbr = SrcInputFileData%varbr
   DstInputFileData%miuDelm = SrcInputFileData%miuDelm
   DstInputFileData%varDelm = SrcInputFileData%varDelm
   DstInputFileData%miuP = SrcInputFileData%miuP
   DstInputFileData%varP = SrcInputFileData%varP
   DstInputFileData%Zn1 = SrcInputFileData%Zn1
   DstInputFileData%Zn2 = SrcInputFileData%Zn2
   DstInputFileData%ZonePitch = SrcInputFileData%ZonePitch
   DstInputFileData%PrflMean = SrcInputFileData%PrflMean
   DstInputFileData%PrflSig = SrcInputFileData%PrflSig
   DstInputFileData%IceStr = SrcInputFileData%IceStr
   DstInputFileData%Delmax = SrcInputFileData%Delmax
   DstInputFileData%alpha = SrcInputFileData%alpha
   DstInputFileData%Dwl = SrcInputFileData%Dwl
   DstInputFileData%Dtp = SrcInputFileData%Dtp
   DstInputFileData%hr = SrcInputFileData%hr
   DstInputFileData%mu = SrcInputFileData%mu
   DstInputFileData%sigf = SrcInputFileData%sigf
   DstInputFileData%StrLim = SrcInputFileData%StrLim
   DstInputFileData%StrRtLim = SrcInputFileData%StrRtLim
   DstInputFileData%UorD = SrcInputFileData%UorD
   DstInputFileData%Ll = SrcInputFileData%Ll
   DstInputFileData%Lw = SrcInputFileData%Lw
   DstInputFileData%Cpa = SrcInputFileData%Cpa
   DstInputFileData%dpa = SrcInputFileData%dpa
   DstInputFileData%Fdr = SrcInputFileData%Fdr
   DstInputFileData%Kic = SrcInputFileData%Kic
   DstInputFileData%FspN = SrcInputFileData%FspN
end subroutine

subroutine IceD_DestroyInputFile(InputFileData, ErrStat, ErrMsg)
   type(IceD_InputFile), intent(inout) :: InputFileData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'IceD_DestroyInputFile'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InputFileData%LegPosX)) then
      deallocate(InputFileData%LegPosX)
   end if
   if (allocated(InputFileData%LegPosY)) then
      deallocate(InputFileData%LegPosY)
   end if
   if (allocated(InputFileData%StrWd)) then
      deallocate(InputFileData%StrWd)
   end if
end subroutine

subroutine IceD_PackInputFile(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(IceD_InputFile), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'IceD_PackInputFile'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%IceModel)
   call RegPack(RF, InData%IceSubModel)
   call RegPack(RF, InData%h)
   call RegPack(RF, InData%v)
   call RegPack(RF, InData%InitLoc)
   call RegPack(RF, InData%t0)
   call RegPack(RF, InData%rhow)
   call RegPack(RF, InData%rhoi)
   call RegPack(RF, InData%Seed1)
   call RegPack(RF, InData%Seed2)
   call RegPack(RF, InData%NumLegs)
   call RegPackAlloc(RF, InData%LegPosX)
   call RegPackAlloc(RF, InData%LegPosY)
   call RegPackAlloc(RF, InData%StrWd)
   call RegPack(RF, InData%Ikm)
   call RegPack(RF, InData%Ag)
   call RegPack(RF, InData%Qg)
   call RegPack(RF, InData%Rg)
   call RegPack(RF, InData%Tice)
   call RegPack(RF, InData%nu)
   call RegPack(RF, InData%phi)
   call RegPack(RF, InData%SigNm)
   call RegPack(RF, InData%Eice)
   call RegPack(RF, InData%IceStr2)
   call RegPack(RF, InData%Delmax2)
   call RegPack(RF, InData%Pitch)
   call RegPack(RF, InData%miuh)
   call RegPack(RF, InData%varh)
   call RegPack(RF, InData%miuv)
   call RegPack(RF, InData%varv)
   call RegPack(RF, InData%miut)
   call RegPack(RF, InData%miubr)
   call RegPack(RF, InData%varbr)
   call RegPack(RF, InData%miuDelm)
   call RegPack(RF, InData%varDelm)
   call RegPack(RF, InData%miuP)
   call RegPack(RF, InData%varP)
   call RegPack(RF, InData%Zn1)
   call RegPack(RF, InData%Zn2)
   call RegPack(RF, InData%ZonePitch)
   call RegPack(RF, InData%PrflMean)
   call RegPack(RF, InData%PrflSig)
   call RegPack(RF, InData%IceStr)
   call RegPack(RF, InData%Delmax)
   call RegPack(RF, InData%alpha)
   call RegPack(RF, InData%Dwl)
   call RegPack(RF, InData%Dtp)
   call RegPack(RF, InData%hr)
   call RegPack(RF, InData%mu)
   call RegPack(RF, InData%sigf)
   call RegPack(RF, InData%StrLim)
   call RegPack(RF, InData%StrRtLim)
   call RegPack(RF, InData%UorD)
   call RegPack(RF, InData%Ll)
   call RegPack(RF, InData%Lw)
   call RegPack(RF, InData%Cpa)
   call RegPack(RF, InData%dpa)
   call RegPack(RF, InData%Fdr)
   call RegPack(RF, InData%Kic)
   call RegPack(RF, InData%FspN)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IceD_UnPackInputFile(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(IceD_InputFile), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'IceD_UnPackInputFile'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%IceModel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%IceSubModel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%h); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%v); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%InitLoc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%t0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rhow); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rhoi); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Seed1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Seed2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumLegs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LegPosX); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LegPosY); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%StrWd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Ikm); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Ag); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Qg); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Rg); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Tice); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nu); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%phi); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SigNm); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Eice); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%IceStr2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Delmax2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Pitch); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%miuh); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%varh); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%miuv); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%varv); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%miut); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%miubr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%varbr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%miuDelm); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%varDelm); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%miuP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%varP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Zn1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Zn2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ZonePitch); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PrflMean); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PrflSig); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%IceStr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Delmax); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%alpha); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Dwl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Dtp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%hr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%mu); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%sigf); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StrLim); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StrRtLim); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UorD); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Ll); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Lw); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cpa); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dpa); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Fdr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Kic); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FspN); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IceD_CopyInitInput(SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg)
   type(IceD_InitInputType), intent(in) :: SrcInitInputData
   type(IceD_InitInputType), intent(inout) :: DstInitInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'IceD_CopyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInitInputData%InputFile = SrcInitInputData%InputFile
   DstInitInputData%RootName = SrcInitInputData%RootName
   DstInitInputData%MSL2SWL = SrcInitInputData%MSL2SWL
   DstInitInputData%WtrDens = SrcInitInputData%WtrDens
   DstInitInputData%gravity = SrcInitInputData%gravity
   DstInitInputData%LegNum = SrcInitInputData%LegNum
   DstInitInputData%TMax = SrcInitInputData%TMax
end subroutine

subroutine IceD_DestroyInitInput(InitInputData, ErrStat, ErrMsg)
   type(IceD_InitInputType), intent(inout) :: InitInputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'IceD_DestroyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine IceD_PackInitInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(IceD_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'IceD_PackInitInput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%InputFile)
   call RegPack(RF, InData%RootName)
   call RegPack(RF, InData%MSL2SWL)
   call RegPack(RF, InData%WtrDens)
   call RegPack(RF, InData%gravity)
   call RegPack(RF, InData%LegNum)
   call RegPack(RF, InData%TMax)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IceD_UnPackInitInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(IceD_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'IceD_UnPackInitInput'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%InputFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MSL2SWL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WtrDens); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%gravity); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LegNum); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TMax); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IceD_CopyInitOutput(SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg)
   type(IceD_InitOutputType), intent(in) :: SrcInitOutputData
   type(IceD_InitOutputType), intent(inout) :: DstInitOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'IceD_CopyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcInitOutputData%WriteOutputHdr)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputHdr)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputHdr)
      if (.not. allocated(DstInitOutputData%WriteOutputHdr)) then
         allocate(DstInitOutputData%WriteOutputHdr(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputHdr.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputHdr = SrcInitOutputData%WriteOutputHdr
   end if
   if (allocated(SrcInitOutputData%WriteOutputUnt)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputUnt)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputUnt)
      if (.not. allocated(DstInitOutputData%WriteOutputUnt)) then
         allocate(DstInitOutputData%WriteOutputUnt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputUnt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputUnt = SrcInitOutputData%WriteOutputUnt
   end if
   DstInitOutputData%numLegs = SrcInitOutputData%numLegs
   call NWTC_Library_CopyProgDesc(SrcInitOutputData%Ver, DstInitOutputData%Ver, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine IceD_DestroyInitOutput(InitOutputData, ErrStat, ErrMsg)
   type(IceD_InitOutputType), intent(inout) :: InitOutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'IceD_DestroyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InitOutputData%WriteOutputHdr)) then
      deallocate(InitOutputData%WriteOutputHdr)
   end if
   if (allocated(InitOutputData%WriteOutputUnt)) then
      deallocate(InitOutputData%WriteOutputUnt)
   end if
   call NWTC_Library_DestroyProgDesc(InitOutputData%Ver, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine IceD_PackInitOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(IceD_InitOutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'IceD_PackInitOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%WriteOutputHdr)
   call RegPackAlloc(RF, InData%WriteOutputUnt)
   call RegPack(RF, InData%numLegs)
   call NWTC_Library_PackProgDesc(RF, InData%Ver) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IceD_UnPackInitOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(IceD_InitOutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'IceD_UnPackInitOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%WriteOutputHdr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutputUnt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%numLegs); if (RegCheckErr(RF, RoutineName)) return
   call NWTC_Library_UnpackProgDesc(RF, OutData%Ver) ! Ver 
end subroutine

subroutine IceD_CopyContState(SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg)
   type(IceD_ContinuousStateType), intent(in) :: SrcContStateData
   type(IceD_ContinuousStateType), intent(inout) :: DstContStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'IceD_CopyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstContStateData%q = SrcContStateData%q
   DstContStateData%dqdt = SrcContStateData%dqdt
end subroutine

subroutine IceD_DestroyContState(ContStateData, ErrStat, ErrMsg)
   type(IceD_ContinuousStateType), intent(inout) :: ContStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'IceD_DestroyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine IceD_PackContState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(IceD_ContinuousStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'IceD_PackContState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%q)
   call RegPack(RF, InData%dqdt)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IceD_UnPackContState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(IceD_ContinuousStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'IceD_UnPackContState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%q); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dqdt); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IceD_CopyDiscState(SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg)
   type(IceD_DiscreteStateType), intent(in) :: SrcDiscStateData
   type(IceD_DiscreteStateType), intent(inout) :: DstDiscStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'IceD_CopyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstDiscStateData%DummyDiscState = SrcDiscStateData%DummyDiscState
end subroutine

subroutine IceD_DestroyDiscState(DiscStateData, ErrStat, ErrMsg)
   type(IceD_DiscreteStateType), intent(inout) :: DiscStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'IceD_DestroyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine IceD_PackDiscState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(IceD_DiscreteStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'IceD_PackDiscState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyDiscState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IceD_UnPackDiscState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(IceD_DiscreteStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'IceD_UnPackDiscState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyDiscState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IceD_CopyConstrState(SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg)
   type(IceD_ConstraintStateType), intent(in) :: SrcConstrStateData
   type(IceD_ConstraintStateType), intent(inout) :: DstConstrStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'IceD_CopyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstConstrStateData%DummyConstrState = SrcConstrStateData%DummyConstrState
end subroutine

subroutine IceD_DestroyConstrState(ConstrStateData, ErrStat, ErrMsg)
   type(IceD_ConstraintStateType), intent(inout) :: ConstrStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'IceD_DestroyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine IceD_PackConstrState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(IceD_ConstraintStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'IceD_PackConstrState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyConstrState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IceD_UnPackConstrState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(IceD_ConstraintStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'IceD_UnPackConstrState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyConstrState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IceD_CopyOtherState(SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg)
   type(IceD_OtherStateType), intent(in) :: SrcOtherStateData
   type(IceD_OtherStateType), intent(inout) :: DstOtherStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'IceD_CopyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstOtherStateData%IceTthNo2 = SrcOtherStateData%IceTthNo2
   if (allocated(SrcOtherStateData%Nc)) then
      LB(1:1) = lbound(SrcOtherStateData%Nc)
      UB(1:1) = ubound(SrcOtherStateData%Nc)
      if (.not. allocated(DstOtherStateData%Nc)) then
         allocate(DstOtherStateData%Nc(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%Nc.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOtherStateData%Nc = SrcOtherStateData%Nc
   end if
   if (allocated(SrcOtherStateData%Psum)) then
      LB(1:1) = lbound(SrcOtherStateData%Psum)
      UB(1:1) = ubound(SrcOtherStateData%Psum)
      if (.not. allocated(DstOtherStateData%Psum)) then
         allocate(DstOtherStateData%Psum(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%Psum.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOtherStateData%Psum = SrcOtherStateData%Psum
   end if
   if (allocated(SrcOtherStateData%IceTthNo)) then
      LB(1:1) = lbound(SrcOtherStateData%IceTthNo)
      UB(1:1) = ubound(SrcOtherStateData%IceTthNo)
      if (.not. allocated(DstOtherStateData%IceTthNo)) then
         allocate(DstOtherStateData%IceTthNo(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%IceTthNo.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOtherStateData%IceTthNo = SrcOtherStateData%IceTthNo
   end if
   DstOtherStateData%Beta = SrcOtherStateData%Beta
   DstOtherStateData%Tinit = SrcOtherStateData%Tinit
   DstOtherStateData%Splitf = SrcOtherStateData%Splitf
   DstOtherStateData%dxc = SrcOtherStateData%dxc
   if (allocated(SrcOtherStateData%xdot)) then
      LB(1:1) = lbound(SrcOtherStateData%xdot)
      UB(1:1) = ubound(SrcOtherStateData%xdot)
      if (.not. allocated(DstOtherStateData%xdot)) then
         allocate(DstOtherStateData%xdot(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%xdot.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call IceD_CopyContState(SrcOtherStateData%xdot(i1), DstOtherStateData%xdot(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstOtherStateData%n = SrcOtherStateData%n
end subroutine

subroutine IceD_DestroyOtherState(OtherStateData, ErrStat, ErrMsg)
   type(IceD_OtherStateType), intent(inout) :: OtherStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'IceD_DestroyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(OtherStateData%Nc)) then
      deallocate(OtherStateData%Nc)
   end if
   if (allocated(OtherStateData%Psum)) then
      deallocate(OtherStateData%Psum)
   end if
   if (allocated(OtherStateData%IceTthNo)) then
      deallocate(OtherStateData%IceTthNo)
   end if
   if (allocated(OtherStateData%xdot)) then
      LB(1:1) = lbound(OtherStateData%xdot)
      UB(1:1) = ubound(OtherStateData%xdot)
      do i1 = LB(1), UB(1)
         call IceD_DestroyContState(OtherStateData%xdot(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(OtherStateData%xdot)
   end if
end subroutine

subroutine IceD_PackOtherState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(IceD_OtherStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'IceD_PackOtherState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%IceTthNo2)
   call RegPackAlloc(RF, InData%Nc)
   call RegPackAlloc(RF, InData%Psum)
   call RegPackAlloc(RF, InData%IceTthNo)
   call RegPack(RF, InData%Beta)
   call RegPack(RF, InData%Tinit)
   call RegPack(RF, InData%Splitf)
   call RegPack(RF, InData%dxc)
   call RegPack(RF, allocated(InData%xdot))
   if (allocated(InData%xdot)) then
      call RegPackBounds(RF, 1, lbound(InData%xdot), ubound(InData%xdot))
      LB(1:1) = lbound(InData%xdot)
      UB(1:1) = ubound(InData%xdot)
      do i1 = LB(1), UB(1)
         call IceD_PackContState(RF, InData%xdot(i1)) 
      end do
   end if
   call RegPack(RF, InData%n)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IceD_UnPackOtherState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(IceD_OtherStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'IceD_UnPackOtherState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%IceTthNo2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Nc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Psum); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%IceTthNo); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Beta); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Tinit); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Splitf); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dxc); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%xdot)) deallocate(OutData%xdot)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%xdot(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%xdot.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call IceD_UnpackContState(RF, OutData%xdot(i1)) ! xdot 
      end do
   end if
   call RegUnpack(RF, OutData%n); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IceD_CopyMisc(SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg)
   type(IceD_MiscVarType), intent(in) :: SrcMiscData
   type(IceD_MiscVarType), intent(inout) :: DstMiscData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'IceD_CopyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstMiscData%DummyMiscVar = SrcMiscData%DummyMiscVar
end subroutine

subroutine IceD_DestroyMisc(MiscData, ErrStat, ErrMsg)
   type(IceD_MiscVarType), intent(inout) :: MiscData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'IceD_DestroyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine IceD_PackMisc(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(IceD_MiscVarType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'IceD_PackMisc'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyMiscVar)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IceD_UnPackMisc(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(IceD_MiscVarType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'IceD_UnPackMisc'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyMiscVar); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IceD_CopyParam(SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg)
   type(IceD_ParameterType), intent(in) :: SrcParamData
   type(IceD_ParameterType), intent(inout) :: DstParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'IceD_CopyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstParamData%h = SrcParamData%h
   DstParamData%v = SrcParamData%v
   DstParamData%t0 = SrcParamData%t0
   DstParamData%StrWd = SrcParamData%StrWd
   DstParamData%dt = SrcParamData%dt
   DstParamData%InitLoc = SrcParamData%InitLoc
   DstParamData%tolerance = SrcParamData%tolerance
   DstParamData%Tmax = SrcParamData%Tmax
   DstParamData%verif = SrcParamData%verif
   DstParamData%ModNo = SrcParamData%ModNo
   DstParamData%SubModNo = SrcParamData%SubModNo
   DstParamData%NumOuts = SrcParamData%NumOuts
   DstParamData%method = SrcParamData%method
   DstParamData%TmStep = SrcParamData%TmStep
   if (allocated(SrcParamData%OutName)) then
      LB(1:1) = lbound(SrcParamData%OutName)
      UB(1:1) = ubound(SrcParamData%OutName)
      if (.not. allocated(DstParamData%OutName)) then
         allocate(DstParamData%OutName(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%OutName.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%OutName = SrcParamData%OutName
   end if
   if (allocated(SrcParamData%OutUnit)) then
      LB(1:1) = lbound(SrcParamData%OutUnit)
      UB(1:1) = ubound(SrcParamData%OutUnit)
      if (.not. allocated(DstParamData%OutUnit)) then
         allocate(DstParamData%OutUnit(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%OutUnit.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%OutUnit = SrcParamData%OutUnit
   end if
   DstParamData%RootName = SrcParamData%RootName
   DstParamData%tm1a = SrcParamData%tm1a
   DstParamData%tm1b = SrcParamData%tm1b
   DstParamData%tm1c = SrcParamData%tm1c
   DstParamData%Fmax1a = SrcParamData%Fmax1a
   DstParamData%Fmax1b = SrcParamData%Fmax1b
   DstParamData%Fmax1c = SrcParamData%Fmax1c
   DstParamData%Ikm = SrcParamData%Ikm
   DstParamData%Cstr = SrcParamData%Cstr
   DstParamData%EiPa = SrcParamData%EiPa
   DstParamData%Delmax2 = SrcParamData%Delmax2
   DstParamData%Pitch = SrcParamData%Pitch
   DstParamData%Kice2 = SrcParamData%Kice2
   if (allocated(SrcParamData%rdmFm)) then
      LB(1:1) = lbound(SrcParamData%rdmFm)
      UB(1:1) = ubound(SrcParamData%rdmFm)
      if (.not. allocated(DstParamData%rdmFm)) then
         allocate(DstParamData%rdmFm(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%rdmFm.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%rdmFm = SrcParamData%rdmFm
   end if
   if (allocated(SrcParamData%rdmt0)) then
      LB(1:1) = lbound(SrcParamData%rdmt0)
      UB(1:1) = ubound(SrcParamData%rdmt0)
      if (.not. allocated(DstParamData%rdmt0)) then
         allocate(DstParamData%rdmt0(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%rdmt0.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%rdmt0 = SrcParamData%rdmt0
   end if
   if (allocated(SrcParamData%rdmtm)) then
      LB(1:1) = lbound(SrcParamData%rdmtm)
      UB(1:1) = ubound(SrcParamData%rdmtm)
      if (.not. allocated(DstParamData%rdmtm)) then
         allocate(DstParamData%rdmtm(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%rdmtm.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%rdmtm = SrcParamData%rdmtm
   end if
   if (allocated(SrcParamData%rdmDm)) then
      LB(1:1) = lbound(SrcParamData%rdmDm)
      UB(1:1) = ubound(SrcParamData%rdmDm)
      if (.not. allocated(DstParamData%rdmDm)) then
         allocate(DstParamData%rdmDm(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%rdmDm.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%rdmDm = SrcParamData%rdmDm
   end if
   if (allocated(SrcParamData%rdmP)) then
      LB(1:1) = lbound(SrcParamData%rdmP)
      UB(1:1) = ubound(SrcParamData%rdmP)
      if (.not. allocated(DstParamData%rdmP)) then
         allocate(DstParamData%rdmP(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%rdmP.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%rdmP = SrcParamData%rdmP
   end if
   if (allocated(SrcParamData%rdmKi)) then
      LB(1:1) = lbound(SrcParamData%rdmKi)
      UB(1:1) = ubound(SrcParamData%rdmKi)
      if (.not. allocated(DstParamData%rdmKi)) then
         allocate(DstParamData%rdmKi(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%rdmKi.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%rdmKi = SrcParamData%rdmKi
   end if
   DstParamData%ZonePitch = SrcParamData%ZonePitch
   DstParamData%Kice = SrcParamData%Kice
   DstParamData%Delmax = SrcParamData%Delmax
   if (allocated(SrcParamData%Y0)) then
      LB(1:1) = lbound(SrcParamData%Y0)
      UB(1:1) = ubound(SrcParamData%Y0)
      if (.not. allocated(DstParamData%Y0)) then
         allocate(DstParamData%Y0(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Y0.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Y0 = SrcParamData%Y0
   end if
   if (allocated(SrcParamData%ContPrfl)) then
      LB(1:1) = lbound(SrcParamData%ContPrfl)
      UB(1:1) = ubound(SrcParamData%ContPrfl)
      if (.not. allocated(DstParamData%ContPrfl)) then
         allocate(DstParamData%ContPrfl(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%ContPrfl.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%ContPrfl = SrcParamData%ContPrfl
   end if
   DstParamData%Zn = SrcParamData%Zn
   DstParamData%rhoi = SrcParamData%rhoi
   DstParamData%rhow = SrcParamData%rhow
   DstParamData%alphaR = SrcParamData%alphaR
   DstParamData%Dwl = SrcParamData%Dwl
   DstParamData%Zr = SrcParamData%Zr
   DstParamData%RHbr = SrcParamData%RHbr
   DstParamData%RVbr = SrcParamData%RVbr
   DstParamData%Lbr = SrcParamData%Lbr
   DstParamData%LovR = SrcParamData%LovR
   DstParamData%mu = SrcParamData%mu
   DstParamData%Wri = SrcParamData%Wri
   DstParamData%WL = SrcParamData%WL
   DstParamData%Cpa = SrcParamData%Cpa
   DstParamData%dpa = SrcParamData%dpa
   DstParamData%FdrN = SrcParamData%FdrN
   DstParamData%Mice = SrcParamData%Mice
   DstParamData%Fsp = SrcParamData%Fsp
end subroutine

subroutine IceD_DestroyParam(ParamData, ErrStat, ErrMsg)
   type(IceD_ParameterType), intent(inout) :: ParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'IceD_DestroyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ParamData%OutName)) then
      deallocate(ParamData%OutName)
   end if
   if (allocated(ParamData%OutUnit)) then
      deallocate(ParamData%OutUnit)
   end if
   if (allocated(ParamData%rdmFm)) then
      deallocate(ParamData%rdmFm)
   end if
   if (allocated(ParamData%rdmt0)) then
      deallocate(ParamData%rdmt0)
   end if
   if (allocated(ParamData%rdmtm)) then
      deallocate(ParamData%rdmtm)
   end if
   if (allocated(ParamData%rdmDm)) then
      deallocate(ParamData%rdmDm)
   end if
   if (allocated(ParamData%rdmP)) then
      deallocate(ParamData%rdmP)
   end if
   if (allocated(ParamData%rdmKi)) then
      deallocate(ParamData%rdmKi)
   end if
   if (allocated(ParamData%Y0)) then
      deallocate(ParamData%Y0)
   end if
   if (allocated(ParamData%ContPrfl)) then
      deallocate(ParamData%ContPrfl)
   end if
end subroutine

subroutine IceD_PackParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(IceD_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'IceD_PackParam'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%h)
   call RegPack(RF, InData%v)
   call RegPack(RF, InData%t0)
   call RegPack(RF, InData%StrWd)
   call RegPack(RF, InData%dt)
   call RegPack(RF, InData%InitLoc)
   call RegPack(RF, InData%tolerance)
   call RegPack(RF, InData%Tmax)
   call RegPack(RF, InData%verif)
   call RegPack(RF, InData%ModNo)
   call RegPack(RF, InData%SubModNo)
   call RegPack(RF, InData%NumOuts)
   call RegPack(RF, InData%method)
   call RegPack(RF, InData%TmStep)
   call RegPackAlloc(RF, InData%OutName)
   call RegPackAlloc(RF, InData%OutUnit)
   call RegPack(RF, InData%RootName)
   call RegPack(RF, InData%tm1a)
   call RegPack(RF, InData%tm1b)
   call RegPack(RF, InData%tm1c)
   call RegPack(RF, InData%Fmax1a)
   call RegPack(RF, InData%Fmax1b)
   call RegPack(RF, InData%Fmax1c)
   call RegPack(RF, InData%Ikm)
   call RegPack(RF, InData%Cstr)
   call RegPack(RF, InData%EiPa)
   call RegPack(RF, InData%Delmax2)
   call RegPack(RF, InData%Pitch)
   call RegPack(RF, InData%Kice2)
   call RegPackAlloc(RF, InData%rdmFm)
   call RegPackAlloc(RF, InData%rdmt0)
   call RegPackAlloc(RF, InData%rdmtm)
   call RegPackAlloc(RF, InData%rdmDm)
   call RegPackAlloc(RF, InData%rdmP)
   call RegPackAlloc(RF, InData%rdmKi)
   call RegPack(RF, InData%ZonePitch)
   call RegPack(RF, InData%Kice)
   call RegPack(RF, InData%Delmax)
   call RegPackAlloc(RF, InData%Y0)
   call RegPackAlloc(RF, InData%ContPrfl)
   call RegPack(RF, InData%Zn)
   call RegPack(RF, InData%rhoi)
   call RegPack(RF, InData%rhow)
   call RegPack(RF, InData%alphaR)
   call RegPack(RF, InData%Dwl)
   call RegPack(RF, InData%Zr)
   call RegPack(RF, InData%RHbr)
   call RegPack(RF, InData%RVbr)
   call RegPack(RF, InData%Lbr)
   call RegPack(RF, InData%LovR)
   call RegPack(RF, InData%mu)
   call RegPack(RF, InData%Wri)
   call RegPack(RF, InData%WL)
   call RegPack(RF, InData%Cpa)
   call RegPack(RF, InData%dpa)
   call RegPack(RF, InData%FdrN)
   call RegPack(RF, InData%Mice)
   call RegPack(RF, InData%Fsp)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IceD_UnPackParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(IceD_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'IceD_UnPackParam'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%h); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%v); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%t0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%StrWd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%InitLoc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%tolerance); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Tmax); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%verif); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ModNo); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SubModNo); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%method); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TmStep); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%OutName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%OutUnit); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%tm1a); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%tm1b); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%tm1c); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Fmax1a); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Fmax1b); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Fmax1c); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Ikm); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cstr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%EiPa); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Delmax2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Pitch); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Kice2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%rdmFm); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%rdmt0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%rdmtm); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%rdmDm); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%rdmP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%rdmKi); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ZonePitch); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Kice); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Delmax); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Y0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%ContPrfl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Zn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rhoi); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rhow); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%alphaR); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Dwl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Zr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RHbr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RVbr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Lbr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LovR); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%mu); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Wri); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cpa); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dpa); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FdrN); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Mice); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Fsp); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IceD_CopyInput(SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg)
   type(IceD_InputType), intent(inout) :: SrcInputData
   type(IceD_InputType), intent(inout) :: DstInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'IceD_CopyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshCopy(SrcInputData%PointMesh, DstInputData%PointMesh, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine IceD_DestroyInput(InputData, ErrStat, ErrMsg)
   type(IceD_InputType), intent(inout) :: InputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'IceD_DestroyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshDestroy( InputData%PointMesh, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine IceD_PackInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(IceD_InputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'IceD_PackInput'
   if (RF%ErrStat >= AbortErrLev) return
   call MeshPack(RF, InData%PointMesh) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IceD_UnPackInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(IceD_InputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'IceD_UnPackInput'
   if (RF%ErrStat /= ErrID_None) return
   call MeshUnpack(RF, OutData%PointMesh) ! PointMesh 
end subroutine

subroutine IceD_CopyOutput(SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg)
   type(IceD_OutputType), intent(inout) :: SrcOutputData
   type(IceD_OutputType), intent(inout) :: DstOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'IceD_CopyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshCopy(SrcOutputData%PointMesh, DstOutputData%PointMesh, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcOutputData%WriteOutput)) then
      LB(1:1) = lbound(SrcOutputData%WriteOutput)
      UB(1:1) = ubound(SrcOutputData%WriteOutput)
      if (.not. allocated(DstOutputData%WriteOutput)) then
         allocate(DstOutputData%WriteOutput(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%WriteOutput.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%WriteOutput = SrcOutputData%WriteOutput
   end if
end subroutine

subroutine IceD_DestroyOutput(OutputData, ErrStat, ErrMsg)
   type(IceD_OutputType), intent(inout) :: OutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'IceD_DestroyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshDestroy( OutputData%PointMesh, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(OutputData%WriteOutput)) then
      deallocate(OutputData%WriteOutput)
   end if
end subroutine

subroutine IceD_PackOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(IceD_OutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'IceD_PackOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call MeshPack(RF, InData%PointMesh) 
   call RegPackAlloc(RF, InData%WriteOutput)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IceD_UnPackOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(IceD_OutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'IceD_UnPackOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call MeshUnpack(RF, OutData%PointMesh) ! PointMesh 
   call RegUnpackAlloc(RF, OutData%WriteOutput); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine IceD_Input_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
   ! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(IceD_InputType), intent(inout)  :: u(:) ! Input at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Inputs
   type(IceD_InputType), intent(inout)  :: u_out ! Input at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'IceD_Input_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(u)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(u)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(u) - 1
   select case (order)
   case (0)
      call IceD_CopyInput(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call IceD_Input_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call IceD_Input_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(u) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE IceD_Input_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

   TYPE(IceD_InputType), INTENT(INOUT)  :: u1    ! Input at t1 > t2
   TYPE(IceD_InputType), INTENT(INOUT)  :: u2    ! Input at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Inputs
   TYPE(IceD_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'IceD_Input_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   CALL MeshExtrapInterp1(u1%PointMesh, u2%PointMesh, tin, u_out%PointMesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
END SUBROUTINE

SUBROUTINE IceD_Input_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

   TYPE(IceD_InputType), INTENT(INOUT)  :: u1      ! Input at t1 > t2 > t3
   TYPE(IceD_InputType), INTENT(INOUT)  :: u2      ! Input at t2 > t3
   TYPE(IceD_InputType), INTENT(INOUT)  :: u3      ! Input at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Inputs
   TYPE(IceD_InputType), INTENT(INOUT)  :: u_out     ! Input at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'IceD_Input_ExtrapInterp2'
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   CALL MeshExtrapInterp2(u1%PointMesh, u2%PointMesh, u3%PointMesh, tin, u_out%PointMesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
END SUBROUTINE

subroutine IceD_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
   ! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(IceD_OutputType), intent(inout)  :: y(:) ! Output at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Outputs
   type(IceD_OutputType), intent(inout)  :: y_out ! Output at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'IceD_Output_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(y)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(y)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(y) - 1
   select case (order)
   case (0)
      call IceD_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call IceD_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call IceD_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(y) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE IceD_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

   TYPE(IceD_OutputType), INTENT(INOUT)  :: y1    ! Output at t1 > t2
   TYPE(IceD_OutputType), INTENT(INOUT)  :: y2    ! Output at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
   TYPE(IceD_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'IceD_Output_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   CALL MeshExtrapInterp1(y1%PointMesh, y2%PointMesh, tin, y_out%PointMesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
      y_out%WriteOutput = a1*y1%WriteOutput + a2*y2%WriteOutput
   END IF ! check if allocated
END SUBROUTINE

SUBROUTINE IceD_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

   TYPE(IceD_OutputType), INTENT(INOUT)  :: y1      ! Output at t1 > t2 > t3
   TYPE(IceD_OutputType), INTENT(INOUT)  :: y2      ! Output at t2 > t3
   TYPE(IceD_OutputType), INTENT(INOUT)  :: y3      ! Output at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
   TYPE(IceD_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'IceD_Output_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   CALL MeshExtrapInterp2(y1%PointMesh, y2%PointMesh, y3%PointMesh, tin, y_out%PointMesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
      y_out%WriteOutput = a1*y1%WriteOutput + a2*y2%WriteOutput + a3*y3%WriteOutput
   END IF ! check if allocated
END SUBROUTINE
END MODULE IceDyn_Types
!ENDOFREGISTRYGENERATEDFILE
