!STARTOFREGISTRYGENERATEDFILE 'WAMIT_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! WAMIT_Types
!.................................................................................................................................
! This file is part of WAMIT.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in WAMIT. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE WAMIT_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE Conv_Radiation_Types
USE SS_Radiation_Types
USE SS_Excitation_Types
USE NWTC_Library
IMPLICIT NONE
! =========  WAMIT_InitInputType  =======
  TYPE, PUBLIC :: WAMIT_InitInputType
    INTEGER(IntKi)  :: NBody = 0_IntKi      !< [>=1; only used when PotMod=1. If NBodyMod=1, the WAMIT data contains a vector of size 6*NBody x 1 and matrices of size 6*NBody x 6*NBody; if NBodyMod>1, there are NBody sets of WAMIT data each with a vector of size 6 x 1 and matrices of size 6 x 6] [-]
    INTEGER(IntKi)  :: NBodyMod = 0_IntKi      !< Body coupling model {1: include coupling terms between each body and NBody in HydroDyn equals NBODY in WAMIT, 2: neglect coupling terms between each body and NBODY=1 with XBODY=0 in WAMIT, 3: Neglect coupling terms between each body and NBODY=1 with XBODY=/0 in WAMIT} (switch) [only used when PotMod=1] [-]
    REAL(ReKi)  :: Gravity = 0.0_ReKi      !< Supplied by Driver:  Gravitational acceleration [(m/s^2)]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: PtfmVol0      !<  [-]
    LOGICAL  :: HasWAMIT = .false.      !< .TRUE. if using WAMIT model, .FALSE. otherwise [-]
    REAL(ReKi)  :: WAMITULEN = 0.0_ReKi      !<  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: PtfmRefxt      !< The xt offset of the body reference point(s) from (0,0,0)  [1 to NBody; only used when PotMod=1 ] [(m)]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: PtfmRefyt      !< The yt offset of the body reference point(s) from (0,0,0)  [1 to NBody; only used when PotMod=1 ] [(m)]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: PtfmRefzt      !< The zt offset of the body reference point(s) from (0,0,0)  [1 to NBody; only used when PotMod=1; must be 0.0 if NBodyMod=2 ] [(m)]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: PtfmRefztRot      !< The rotation about zt of the body reference frame(s) from xt/yt [radians]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: PtfmCOBxt      !<  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: PtfmCOByt      !<  [-]
    INTEGER(IntKi)  :: RdtnMod = 0_IntKi      !<  [-]
    INTEGER(IntKi)  :: ExctnMod = 0_IntKi      !<  [-]
    INTEGER(IntKi)  :: ExctnDisp = 0_IntKi      !< 0: use undisplaced position, 1: use displaced position, 2: use low-pass filtered displaced position) [only used when PotMod=1 and ExctnMod>0] [-]
    REAL(ReKi)  :: ExctnCutOff = 0.0_ReKi      !< Cutoff (corner) frequency of the low-pass time-filtered displaced position (Hz) [>0.0]  [Hz]
    INTEGER(IntKi)  :: NExctnHdg = 0_IntKi      !< Number of PRP headings/yaw offset evenly distributed over the region [-180, 180) deg to be used when precomputing the wave excitation [only used when PtfmYMod=1] [-]
    REAL(DbKi)  :: RdtnTMax = 0.0_R8Ki      !<  [-]
    CHARACTER(1024)  :: WAMITFile      !<  [-]
    TYPE(Conv_Rdtn_InitInputType)  :: Conv_Rdtn      !<  [-]
    TYPE(SeaSt_WaveFieldType) , POINTER :: WaveField => NULL()      !< Pointer to wave field [-]
    INTEGER(IntKi)  :: PtfmYMod = 0_IntKi      !< Large yaw model [-]
    REAL(ReKi)  :: PtfmRefY = 0.0_ReKi      !< Initial reference yaw offset [(rad)]
    REAL(ReKi) , DIMENSION(1:6)  :: PlatformPos = 0.0_ReKi      !< Initial platform position (6 DOFs) [-]
  END TYPE WAMIT_InitInputType
! =======================
! =========  WAMIT_ContinuousStateType  =======
  TYPE, PUBLIC :: WAMIT_ContinuousStateType
    TYPE(SS_Rad_ContinuousStateType)  :: SS_Rdtn      !< continuous states from the State Space radiation module [-]
    TYPE(SS_Exc_ContinuousStateType)  :: SS_Exctn      !< continuous states from the State Space radiation module [-]
    TYPE(Conv_Rdtn_ContinuousStateType)  :: Conv_Rdtn      !< placeholder [-]
  END TYPE WAMIT_ContinuousStateType
! =======================
! =========  WAMIT_DiscreteStateType  =======
  TYPE, PUBLIC :: WAMIT_DiscreteStateType
    TYPE(Conv_Rdtn_DiscreteStateType)  :: Conv_Rdtn      !< discrete states from the convolution radiation module [-]
    TYPE(SS_Rad_DiscreteStateType)  :: SS_Rdtn      !< placeholder [-]
    TYPE(SS_Exc_DiscreteStateType)  :: SS_Exctn      !< placeholder [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: BdyPosFilt      !< Low-pass filtered WAMIT body position at the current and previous steps used when ExctnDisp=2 [-]
  END TYPE WAMIT_DiscreteStateType
! =======================
! =========  WAMIT_ConstraintStateType  =======
  TYPE, PUBLIC :: WAMIT_ConstraintStateType
    TYPE(Conv_Rdtn_ConstraintStateType)  :: Conv_Rdtn      !< placeholder [-]
    TYPE(SS_Rad_ConstraintStateType)  :: SS_Rdtn      !< placeholder [-]
    TYPE(SS_Exc_ConstraintStateType)  :: SS_Exctn      !< placeholder [-]
  END TYPE WAMIT_ConstraintStateType
! =======================
! =========  WAMIT_OtherStateType  =======
  TYPE, PUBLIC :: WAMIT_OtherStateType
    TYPE(SS_Rad_OtherStateType)  :: SS_Rdtn      !<  [-]
    TYPE(SS_Exc_OtherStateType)  :: SS_Exctn      !<  [-]
    TYPE(Conv_Rdtn_OtherStateType)  :: Conv_Rdtn      !<  [-]
  END TYPE WAMIT_OtherStateType
! =======================
! =========  WAMIT_MiscVarType  =======
  TYPE, PUBLIC :: WAMIT_MiscVarType
    INTEGER(IntKi)  :: LastIndWave = 0_IntKi      !<  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: F_HS      !< local variable in CalcOutput:Total load contribution from hydrostatics, including the effects of waterplane area and the center of buoyancy [(N, N-m)]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: F_Waves1      !< local variable in CalcOutput:Total load contribution from incident waves (i.e., the diffraction problem) [(N, N-m)]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: F_Rdtn      !< local variable in CalcOutput:Total load contribution from wave radiation damping (i.e., the diffraction problem) [(N, N-m)]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: F_PtfmAM      !< local variable in CalcOutput: [-]
    TYPE(SS_Rad_MiscVarType)  :: SS_Rdtn      !<  [-]
    TYPE(SS_Rad_InputType)  :: SS_Rdtn_u      !<  [-]
    TYPE(SS_Rad_OutputType)  :: SS_Rdtn_y      !<  [-]
    TYPE(SS_Exc_MiscVarType)  :: SS_Exctn      !<  [-]
    TYPE(SS_Exc_InputType)  :: SS_Exctn_u      !<  [-]
    TYPE(SS_Exc_OutputType)  :: SS_Exctn_y      !<  [-]
    TYPE(Conv_Rdtn_MiscVarType)  :: Conv_Rdtn      !<  [-]
    TYPE(Conv_Rdtn_InputType)  :: Conv_Rdtn_u      !<  [-]
    TYPE(Conv_Rdtn_OutputType)  :: Conv_Rdtn_y      !<  [-]
    TYPE(SeaSt_WaveField_MiscVarType)  :: WaveField_m      !< misc var information from the SeaState Interpolation module [-]
  END TYPE WAMIT_MiscVarType
! =======================
! =========  WAMIT_ParameterType  =======
  TYPE, PUBLIC :: WAMIT_ParameterType
    INTEGER(IntKi)  :: NBody = 0_IntKi      !< [>=1; only used when PotMod=1. If NBodyMod=1, the WAMIT data contains a vector of size 6*NBody x 1 and matrices of size 6*NBody x 6*NBody; if NBodyMod>1, there are NBody sets of WAMIT data each with a vector of size 6 x 1 and matrices of size 6 x 6] [-]
    INTEGER(IntKi)  :: NBodyMod = 0_IntKi      !< Body coupling model {1: include coupling terms between each body and NBody in HydroDyn equals NBODY in WAMIT, 2: neglect coupling terms between each body and NBODY=1 with XBODY=0 in WAMIT, 3: Neglect coupling terms between each body and NBODY=1 with XBODY=/0 in WAMIT} (switch) [only used when PotMod=1] [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_HS_Moment_Offset      !< The offset moment due to the COB being offset from the WAMIT body's local location {matrix 3xNBody} [N-m]
    REAL(SiKi) , DIMENSION(:,:), ALLOCATABLE  :: HdroAdMsI      !<  [(sec)]
    REAL(SiKi) , DIMENSION(:,:), ALLOCATABLE  :: HdroSttc      !<  [-]
    INTEGER(IntKi)  :: RdtnMod = 0_IntKi      !<  [-]
    INTEGER(IntKi)  :: ExctnMod = 0_IntKi      !<  [-]
    INTEGER(IntKi)  :: ExctnDisp = 0_IntKi      !< 0: use undisplaced position, 1: use displaced position, 2: use low-pass filtered displaced position) [only used when PotMod=1 and ExctnMod>0] [-]
    REAL(ReKi)  :: ExctnCutOff = 0.0_ReKi      !< Cutoff (corner) frequency of the low-pass time-filtered displaced position (Hz) [>0.0]  [Hz]
    INTEGER(IntKi)  :: NExctnHdg = 0_IntKi      !< Number of PRP headings/yaw offset evenly distributed over the region [-180, 180) deg to be used when precomputing the wave excitation [only used when PtfmYMod=1] [-]
    REAL(ReKi)  :: ExctnFiltConst = 0.0_ReKi      !< Low-pass time filter constant computed from ExctnCutOff [-]
    REAL(SiKi) , DIMENSION(:,:,:), ALLOCATABLE  :: WaveExctn      !<  [-]
    REAL(SiKi) , DIMENSION(:,:,:,:,:), ALLOCATABLE  :: WaveExctnGrid      !< WaveExctnGrid dimensions are: 1st: wavetime, 2nd: X, 3rd: Y, 4th: PRP Yaw, 5th: Force component for eac WAMIT Body [-]
    TYPE(Conv_Rdtn_ParameterType)  :: Conv_Rdtn      !<  [-]
    TYPE(SS_Rad_ParameterType)  :: SS_Rdtn      !<  [-]
    TYPE(SS_Exc_ParameterType)  :: SS_Exctn      !<  [-]
    REAL(DbKi)  :: DT = 0.0_R8Ki      !<  [-]
    TYPE(SeaSt_WaveFieldType) , POINTER :: WaveField => NULL()      !< Pointer to wave field [-]
    INTEGER(IntKi)  :: PtfmYMod = 0_IntKi      !< Large yaw model [-]
    TYPE(SeaSt_WaveField_ParameterType)  :: ExctnGridParams      !< Parameters of WaveExctnGrid [-]
  END TYPE WAMIT_ParameterType
! =======================
! =========  WAMIT_InputType  =======
  TYPE, PUBLIC :: WAMIT_InputType
    TYPE(MeshType)  :: Mesh      !< Displacements at the WAMIT reference point in the inertial frame [-]
    REAL(ReKi)  :: PtfmRefY = 0.0_ReKi      !< Reference yaw offset [(rad)]
  END TYPE WAMIT_InputType
! =======================
! =========  WAMIT_OutputType  =======
  TYPE, PUBLIC :: WAMIT_OutputType
    TYPE(MeshType)  :: Mesh      !< Loads at the WAMIT reference point in the inertial frame [-]
  END TYPE WAMIT_OutputType
! =======================
CONTAINS

subroutine WAMIT_CopyInitInput(SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg)
   type(WAMIT_InitInputType), intent(in) :: SrcInitInputData
   type(WAMIT_InitInputType), intent(inout) :: DstInitInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'WAMIT_CopyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInitInputData%NBody = SrcInitInputData%NBody
   DstInitInputData%NBodyMod = SrcInitInputData%NBodyMod
   DstInitInputData%Gravity = SrcInitInputData%Gravity
   if (allocated(SrcInitInputData%PtfmVol0)) then
      LB(1:1) = lbound(SrcInitInputData%PtfmVol0)
      UB(1:1) = ubound(SrcInitInputData%PtfmVol0)
      if (.not. allocated(DstInitInputData%PtfmVol0)) then
         allocate(DstInitInputData%PtfmVol0(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%PtfmVol0.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%PtfmVol0 = SrcInitInputData%PtfmVol0
   end if
   DstInitInputData%HasWAMIT = SrcInitInputData%HasWAMIT
   DstInitInputData%WAMITULEN = SrcInitInputData%WAMITULEN
   if (allocated(SrcInitInputData%PtfmRefxt)) then
      LB(1:1) = lbound(SrcInitInputData%PtfmRefxt)
      UB(1:1) = ubound(SrcInitInputData%PtfmRefxt)
      if (.not. allocated(DstInitInputData%PtfmRefxt)) then
         allocate(DstInitInputData%PtfmRefxt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%PtfmRefxt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%PtfmRefxt = SrcInitInputData%PtfmRefxt
   end if
   if (allocated(SrcInitInputData%PtfmRefyt)) then
      LB(1:1) = lbound(SrcInitInputData%PtfmRefyt)
      UB(1:1) = ubound(SrcInitInputData%PtfmRefyt)
      if (.not. allocated(DstInitInputData%PtfmRefyt)) then
         allocate(DstInitInputData%PtfmRefyt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%PtfmRefyt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%PtfmRefyt = SrcInitInputData%PtfmRefyt
   end if
   if (allocated(SrcInitInputData%PtfmRefzt)) then
      LB(1:1) = lbound(SrcInitInputData%PtfmRefzt)
      UB(1:1) = ubound(SrcInitInputData%PtfmRefzt)
      if (.not. allocated(DstInitInputData%PtfmRefzt)) then
         allocate(DstInitInputData%PtfmRefzt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%PtfmRefzt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%PtfmRefzt = SrcInitInputData%PtfmRefzt
   end if
   if (allocated(SrcInitInputData%PtfmRefztRot)) then
      LB(1:1) = lbound(SrcInitInputData%PtfmRefztRot)
      UB(1:1) = ubound(SrcInitInputData%PtfmRefztRot)
      if (.not. allocated(DstInitInputData%PtfmRefztRot)) then
         allocate(DstInitInputData%PtfmRefztRot(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%PtfmRefztRot.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%PtfmRefztRot = SrcInitInputData%PtfmRefztRot
   end if
   if (allocated(SrcInitInputData%PtfmCOBxt)) then
      LB(1:1) = lbound(SrcInitInputData%PtfmCOBxt)
      UB(1:1) = ubound(SrcInitInputData%PtfmCOBxt)
      if (.not. allocated(DstInitInputData%PtfmCOBxt)) then
         allocate(DstInitInputData%PtfmCOBxt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%PtfmCOBxt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%PtfmCOBxt = SrcInitInputData%PtfmCOBxt
   end if
   if (allocated(SrcInitInputData%PtfmCOByt)) then
      LB(1:1) = lbound(SrcInitInputData%PtfmCOByt)
      UB(1:1) = ubound(SrcInitInputData%PtfmCOByt)
      if (.not. allocated(DstInitInputData%PtfmCOByt)) then
         allocate(DstInitInputData%PtfmCOByt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%PtfmCOByt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%PtfmCOByt = SrcInitInputData%PtfmCOByt
   end if
   DstInitInputData%RdtnMod = SrcInitInputData%RdtnMod
   DstInitInputData%ExctnMod = SrcInitInputData%ExctnMod
   DstInitInputData%ExctnDisp = SrcInitInputData%ExctnDisp
   DstInitInputData%ExctnCutOff = SrcInitInputData%ExctnCutOff
   DstInitInputData%NExctnHdg = SrcInitInputData%NExctnHdg
   DstInitInputData%RdtnTMax = SrcInitInputData%RdtnTMax
   DstInitInputData%WAMITFile = SrcInitInputData%WAMITFile
   call Conv_Rdtn_CopyInitInput(SrcInitInputData%Conv_Rdtn, DstInitInputData%Conv_Rdtn, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstInitInputData%WaveField => SrcInitInputData%WaveField
   DstInitInputData%PtfmYMod = SrcInitInputData%PtfmYMod
   DstInitInputData%PtfmRefY = SrcInitInputData%PtfmRefY
   DstInitInputData%PlatformPos = SrcInitInputData%PlatformPos
end subroutine

subroutine WAMIT_DestroyInitInput(InitInputData, ErrStat, ErrMsg)
   type(WAMIT_InitInputType), intent(inout) :: InitInputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'WAMIT_DestroyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InitInputData%PtfmVol0)) then
      deallocate(InitInputData%PtfmVol0)
   end if
   if (allocated(InitInputData%PtfmRefxt)) then
      deallocate(InitInputData%PtfmRefxt)
   end if
   if (allocated(InitInputData%PtfmRefyt)) then
      deallocate(InitInputData%PtfmRefyt)
   end if
   if (allocated(InitInputData%PtfmRefzt)) then
      deallocate(InitInputData%PtfmRefzt)
   end if
   if (allocated(InitInputData%PtfmRefztRot)) then
      deallocate(InitInputData%PtfmRefztRot)
   end if
   if (allocated(InitInputData%PtfmCOBxt)) then
      deallocate(InitInputData%PtfmCOBxt)
   end if
   if (allocated(InitInputData%PtfmCOByt)) then
      deallocate(InitInputData%PtfmCOByt)
   end if
   call Conv_Rdtn_DestroyInitInput(InitInputData%Conv_Rdtn, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   nullify(InitInputData%WaveField)
end subroutine

subroutine WAMIT_PackInitInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(WAMIT_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'WAMIT_PackInitInput'
   logical         :: PtrInIndex
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%NBody)
   call RegPack(RF, InData%NBodyMod)
   call RegPack(RF, InData%Gravity)
   call RegPackAlloc(RF, InData%PtfmVol0)
   call RegPack(RF, InData%HasWAMIT)
   call RegPack(RF, InData%WAMITULEN)
   call RegPackAlloc(RF, InData%PtfmRefxt)
   call RegPackAlloc(RF, InData%PtfmRefyt)
   call RegPackAlloc(RF, InData%PtfmRefzt)
   call RegPackAlloc(RF, InData%PtfmRefztRot)
   call RegPackAlloc(RF, InData%PtfmCOBxt)
   call RegPackAlloc(RF, InData%PtfmCOByt)
   call RegPack(RF, InData%RdtnMod)
   call RegPack(RF, InData%ExctnMod)
   call RegPack(RF, InData%ExctnDisp)
   call RegPack(RF, InData%ExctnCutOff)
   call RegPack(RF, InData%NExctnHdg)
   call RegPack(RF, InData%RdtnTMax)
   call RegPack(RF, InData%WAMITFile)
   call Conv_Rdtn_PackInitInput(RF, InData%Conv_Rdtn) 
   call RegPack(RF, associated(InData%WaveField))
   if (associated(InData%WaveField)) then
      call RegPackPointer(RF, c_loc(InData%WaveField), PtrInIndex)
      if (.not. PtrInIndex) then
         call SeaSt_WaveField_PackSeaSt_WaveFieldType(RF, InData%WaveField) 
      end if
   end if
   call RegPack(RF, InData%PtfmYMod)
   call RegPack(RF, InData%PtfmRefY)
   call RegPack(RF, InData%PlatformPos)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine WAMIT_UnPackInitInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(WAMIT_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'WAMIT_UnPackInitInput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   integer(B8Ki)   :: PtrIdx
   type(c_ptr)     :: Ptr
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%NBody); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NBodyMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Gravity); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PtfmVol0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HasWAMIT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WAMITULEN); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PtfmRefxt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PtfmRefyt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PtfmRefzt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PtfmRefztRot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PtfmCOBxt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PtfmCOByt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RdtnMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ExctnMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ExctnDisp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ExctnCutOff); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NExctnHdg); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RdtnTMax); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WAMITFile); if (RegCheckErr(RF, RoutineName)) return
   call Conv_Rdtn_UnpackInitInput(RF, OutData%Conv_Rdtn) ! Conv_Rdtn 
   if (associated(OutData%WaveField)) deallocate(OutData%WaveField)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackPointer(RF, Ptr, PtrIdx); if (RegCheckErr(RF, RoutineName)) return
      if (c_associated(Ptr)) then
         call c_f_pointer(Ptr, OutData%WaveField)
      else
         allocate(OutData%WaveField,stat=stat)
         if (stat /= 0) then 
            call SetErrStat(ErrID_Fatal, 'Error allocating OutData%WaveField.', RF%ErrStat, RF%ErrMsg, RoutineName)
            return
         end if
         RF%Pointers(PtrIdx) = c_loc(OutData%WaveField)
         call SeaSt_WaveField_UnpackSeaSt_WaveFieldType(RF, OutData%WaveField) ! WaveField 
      end if
   else
      OutData%WaveField => null()
   end if
   call RegUnpack(RF, OutData%PtfmYMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmRefY); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PlatformPos); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine WAMIT_CopyContState(SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg)
   type(WAMIT_ContinuousStateType), intent(in) :: SrcContStateData
   type(WAMIT_ContinuousStateType), intent(inout) :: DstContStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'WAMIT_CopyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call SS_Rad_CopyContState(SrcContStateData%SS_Rdtn, DstContStateData%SS_Rdtn, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call SS_Exc_CopyContState(SrcContStateData%SS_Exctn, DstContStateData%SS_Exctn, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call Conv_Rdtn_CopyContState(SrcContStateData%Conv_Rdtn, DstContStateData%Conv_Rdtn, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine WAMIT_DestroyContState(ContStateData, ErrStat, ErrMsg)
   type(WAMIT_ContinuousStateType), intent(inout) :: ContStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'WAMIT_DestroyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call SS_Rad_DestroyContState(ContStateData%SS_Rdtn, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call SS_Exc_DestroyContState(ContStateData%SS_Exctn, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call Conv_Rdtn_DestroyContState(ContStateData%Conv_Rdtn, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine WAMIT_PackContState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(WAMIT_ContinuousStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'WAMIT_PackContState'
   if (RF%ErrStat >= AbortErrLev) return
   call SS_Rad_PackContState(RF, InData%SS_Rdtn) 
   call SS_Exc_PackContState(RF, InData%SS_Exctn) 
   call Conv_Rdtn_PackContState(RF, InData%Conv_Rdtn) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine WAMIT_UnPackContState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(WAMIT_ContinuousStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'WAMIT_UnPackContState'
   if (RF%ErrStat /= ErrID_None) return
   call SS_Rad_UnpackContState(RF, OutData%SS_Rdtn) ! SS_Rdtn 
   call SS_Exc_UnpackContState(RF, OutData%SS_Exctn) ! SS_Exctn 
   call Conv_Rdtn_UnpackContState(RF, OutData%Conv_Rdtn) ! Conv_Rdtn 
end subroutine

subroutine WAMIT_CopyDiscState(SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg)
   type(WAMIT_DiscreteStateType), intent(in) :: SrcDiscStateData
   type(WAMIT_DiscreteStateType), intent(inout) :: DstDiscStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'WAMIT_CopyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call Conv_Rdtn_CopyDiscState(SrcDiscStateData%Conv_Rdtn, DstDiscStateData%Conv_Rdtn, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call SS_Rad_CopyDiscState(SrcDiscStateData%SS_Rdtn, DstDiscStateData%SS_Rdtn, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call SS_Exc_CopyDiscState(SrcDiscStateData%SS_Exctn, DstDiscStateData%SS_Exctn, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcDiscStateData%BdyPosFilt)) then
      LB(1:3) = lbound(SrcDiscStateData%BdyPosFilt)
      UB(1:3) = ubound(SrcDiscStateData%BdyPosFilt)
      if (.not. allocated(DstDiscStateData%BdyPosFilt)) then
         allocate(DstDiscStateData%BdyPosFilt(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%BdyPosFilt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%BdyPosFilt = SrcDiscStateData%BdyPosFilt
   end if
end subroutine

subroutine WAMIT_DestroyDiscState(DiscStateData, ErrStat, ErrMsg)
   type(WAMIT_DiscreteStateType), intent(inout) :: DiscStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'WAMIT_DestroyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call Conv_Rdtn_DestroyDiscState(DiscStateData%Conv_Rdtn, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call SS_Rad_DestroyDiscState(DiscStateData%SS_Rdtn, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call SS_Exc_DestroyDiscState(DiscStateData%SS_Exctn, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(DiscStateData%BdyPosFilt)) then
      deallocate(DiscStateData%BdyPosFilt)
   end if
end subroutine

subroutine WAMIT_PackDiscState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(WAMIT_DiscreteStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'WAMIT_PackDiscState'
   if (RF%ErrStat >= AbortErrLev) return
   call Conv_Rdtn_PackDiscState(RF, InData%Conv_Rdtn) 
   call SS_Rad_PackDiscState(RF, InData%SS_Rdtn) 
   call SS_Exc_PackDiscState(RF, InData%SS_Exctn) 
   call RegPackAlloc(RF, InData%BdyPosFilt)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine WAMIT_UnPackDiscState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(WAMIT_DiscreteStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'WAMIT_UnPackDiscState'
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call Conv_Rdtn_UnpackDiscState(RF, OutData%Conv_Rdtn) ! Conv_Rdtn 
   call SS_Rad_UnpackDiscState(RF, OutData%SS_Rdtn) ! SS_Rdtn 
   call SS_Exc_UnpackDiscState(RF, OutData%SS_Exctn) ! SS_Exctn 
   call RegUnpackAlloc(RF, OutData%BdyPosFilt); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine WAMIT_CopyConstrState(SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg)
   type(WAMIT_ConstraintStateType), intent(in) :: SrcConstrStateData
   type(WAMIT_ConstraintStateType), intent(inout) :: DstConstrStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'WAMIT_CopyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call Conv_Rdtn_CopyConstrState(SrcConstrStateData%Conv_Rdtn, DstConstrStateData%Conv_Rdtn, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call SS_Rad_CopyConstrState(SrcConstrStateData%SS_Rdtn, DstConstrStateData%SS_Rdtn, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call SS_Exc_CopyConstrState(SrcConstrStateData%SS_Exctn, DstConstrStateData%SS_Exctn, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine WAMIT_DestroyConstrState(ConstrStateData, ErrStat, ErrMsg)
   type(WAMIT_ConstraintStateType), intent(inout) :: ConstrStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'WAMIT_DestroyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call Conv_Rdtn_DestroyConstrState(ConstrStateData%Conv_Rdtn, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call SS_Rad_DestroyConstrState(ConstrStateData%SS_Rdtn, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call SS_Exc_DestroyConstrState(ConstrStateData%SS_Exctn, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine WAMIT_PackConstrState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(WAMIT_ConstraintStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'WAMIT_PackConstrState'
   if (RF%ErrStat >= AbortErrLev) return
   call Conv_Rdtn_PackConstrState(RF, InData%Conv_Rdtn) 
   call SS_Rad_PackConstrState(RF, InData%SS_Rdtn) 
   call SS_Exc_PackConstrState(RF, InData%SS_Exctn) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine WAMIT_UnPackConstrState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(WAMIT_ConstraintStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'WAMIT_UnPackConstrState'
   if (RF%ErrStat /= ErrID_None) return
   call Conv_Rdtn_UnpackConstrState(RF, OutData%Conv_Rdtn) ! Conv_Rdtn 
   call SS_Rad_UnpackConstrState(RF, OutData%SS_Rdtn) ! SS_Rdtn 
   call SS_Exc_UnpackConstrState(RF, OutData%SS_Exctn) ! SS_Exctn 
end subroutine

subroutine WAMIT_CopyOtherState(SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg)
   type(WAMIT_OtherStateType), intent(in) :: SrcOtherStateData
   type(WAMIT_OtherStateType), intent(inout) :: DstOtherStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'WAMIT_CopyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call SS_Rad_CopyOtherState(SrcOtherStateData%SS_Rdtn, DstOtherStateData%SS_Rdtn, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call SS_Exc_CopyOtherState(SrcOtherStateData%SS_Exctn, DstOtherStateData%SS_Exctn, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call Conv_Rdtn_CopyOtherState(SrcOtherStateData%Conv_Rdtn, DstOtherStateData%Conv_Rdtn, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine WAMIT_DestroyOtherState(OtherStateData, ErrStat, ErrMsg)
   type(WAMIT_OtherStateType), intent(inout) :: OtherStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'WAMIT_DestroyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call SS_Rad_DestroyOtherState(OtherStateData%SS_Rdtn, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call SS_Exc_DestroyOtherState(OtherStateData%SS_Exctn, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call Conv_Rdtn_DestroyOtherState(OtherStateData%Conv_Rdtn, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine WAMIT_PackOtherState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(WAMIT_OtherStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'WAMIT_PackOtherState'
   if (RF%ErrStat >= AbortErrLev) return
   call SS_Rad_PackOtherState(RF, InData%SS_Rdtn) 
   call SS_Exc_PackOtherState(RF, InData%SS_Exctn) 
   call Conv_Rdtn_PackOtherState(RF, InData%Conv_Rdtn) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine WAMIT_UnPackOtherState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(WAMIT_OtherStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'WAMIT_UnPackOtherState'
   if (RF%ErrStat /= ErrID_None) return
   call SS_Rad_UnpackOtherState(RF, OutData%SS_Rdtn) ! SS_Rdtn 
   call SS_Exc_UnpackOtherState(RF, OutData%SS_Exctn) ! SS_Exctn 
   call Conv_Rdtn_UnpackOtherState(RF, OutData%Conv_Rdtn) ! Conv_Rdtn 
end subroutine

subroutine WAMIT_CopyMisc(SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg)
   type(WAMIT_MiscVarType), intent(in) :: SrcMiscData
   type(WAMIT_MiscVarType), intent(inout) :: DstMiscData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'WAMIT_CopyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstMiscData%LastIndWave = SrcMiscData%LastIndWave
   if (allocated(SrcMiscData%F_HS)) then
      LB(1:1) = lbound(SrcMiscData%F_HS)
      UB(1:1) = ubound(SrcMiscData%F_HS)
      if (.not. allocated(DstMiscData%F_HS)) then
         allocate(DstMiscData%F_HS(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%F_HS.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%F_HS = SrcMiscData%F_HS
   end if
   if (allocated(SrcMiscData%F_Waves1)) then
      LB(1:1) = lbound(SrcMiscData%F_Waves1)
      UB(1:1) = ubound(SrcMiscData%F_Waves1)
      if (.not. allocated(DstMiscData%F_Waves1)) then
         allocate(DstMiscData%F_Waves1(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%F_Waves1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%F_Waves1 = SrcMiscData%F_Waves1
   end if
   if (allocated(SrcMiscData%F_Rdtn)) then
      LB(1:1) = lbound(SrcMiscData%F_Rdtn)
      UB(1:1) = ubound(SrcMiscData%F_Rdtn)
      if (.not. allocated(DstMiscData%F_Rdtn)) then
         allocate(DstMiscData%F_Rdtn(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%F_Rdtn.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%F_Rdtn = SrcMiscData%F_Rdtn
   end if
   if (allocated(SrcMiscData%F_PtfmAM)) then
      LB(1:1) = lbound(SrcMiscData%F_PtfmAM)
      UB(1:1) = ubound(SrcMiscData%F_PtfmAM)
      if (.not. allocated(DstMiscData%F_PtfmAM)) then
         allocate(DstMiscData%F_PtfmAM(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%F_PtfmAM.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%F_PtfmAM = SrcMiscData%F_PtfmAM
   end if
   call SS_Rad_CopyMisc(SrcMiscData%SS_Rdtn, DstMiscData%SS_Rdtn, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call SS_Rad_CopyInput(SrcMiscData%SS_Rdtn_u, DstMiscData%SS_Rdtn_u, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call SS_Rad_CopyOutput(SrcMiscData%SS_Rdtn_y, DstMiscData%SS_Rdtn_y, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call SS_Exc_CopyMisc(SrcMiscData%SS_Exctn, DstMiscData%SS_Exctn, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call SS_Exc_CopyInput(SrcMiscData%SS_Exctn_u, DstMiscData%SS_Exctn_u, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call SS_Exc_CopyOutput(SrcMiscData%SS_Exctn_y, DstMiscData%SS_Exctn_y, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call Conv_Rdtn_CopyMisc(SrcMiscData%Conv_Rdtn, DstMiscData%Conv_Rdtn, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call Conv_Rdtn_CopyInput(SrcMiscData%Conv_Rdtn_u, DstMiscData%Conv_Rdtn_u, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call Conv_Rdtn_CopyOutput(SrcMiscData%Conv_Rdtn_y, DstMiscData%Conv_Rdtn_y, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call SeaSt_WaveField_CopyMisc(SrcMiscData%WaveField_m, DstMiscData%WaveField_m, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine WAMIT_DestroyMisc(MiscData, ErrStat, ErrMsg)
   type(WAMIT_MiscVarType), intent(inout) :: MiscData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'WAMIT_DestroyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(MiscData%F_HS)) then
      deallocate(MiscData%F_HS)
   end if
   if (allocated(MiscData%F_Waves1)) then
      deallocate(MiscData%F_Waves1)
   end if
   if (allocated(MiscData%F_Rdtn)) then
      deallocate(MiscData%F_Rdtn)
   end if
   if (allocated(MiscData%F_PtfmAM)) then
      deallocate(MiscData%F_PtfmAM)
   end if
   call SS_Rad_DestroyMisc(MiscData%SS_Rdtn, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call SS_Rad_DestroyInput(MiscData%SS_Rdtn_u, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call SS_Rad_DestroyOutput(MiscData%SS_Rdtn_y, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call SS_Exc_DestroyMisc(MiscData%SS_Exctn, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call SS_Exc_DestroyInput(MiscData%SS_Exctn_u, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call SS_Exc_DestroyOutput(MiscData%SS_Exctn_y, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call Conv_Rdtn_DestroyMisc(MiscData%Conv_Rdtn, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call Conv_Rdtn_DestroyInput(MiscData%Conv_Rdtn_u, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call Conv_Rdtn_DestroyOutput(MiscData%Conv_Rdtn_y, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call SeaSt_WaveField_DestroyMisc(MiscData%WaveField_m, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine WAMIT_PackMisc(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(WAMIT_MiscVarType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'WAMIT_PackMisc'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%LastIndWave)
   call RegPackAlloc(RF, InData%F_HS)
   call RegPackAlloc(RF, InData%F_Waves1)
   call RegPackAlloc(RF, InData%F_Rdtn)
   call RegPackAlloc(RF, InData%F_PtfmAM)
   call SS_Rad_PackMisc(RF, InData%SS_Rdtn) 
   call SS_Rad_PackInput(RF, InData%SS_Rdtn_u) 
   call SS_Rad_PackOutput(RF, InData%SS_Rdtn_y) 
   call SS_Exc_PackMisc(RF, InData%SS_Exctn) 
   call SS_Exc_PackInput(RF, InData%SS_Exctn_u) 
   call SS_Exc_PackOutput(RF, InData%SS_Exctn_y) 
   call Conv_Rdtn_PackMisc(RF, InData%Conv_Rdtn) 
   call Conv_Rdtn_PackInput(RF, InData%Conv_Rdtn_u) 
   call Conv_Rdtn_PackOutput(RF, InData%Conv_Rdtn_y) 
   call SeaSt_WaveField_PackMisc(RF, InData%WaveField_m) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine WAMIT_UnPackMisc(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(WAMIT_MiscVarType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'WAMIT_UnPackMisc'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%LastIndWave); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%F_HS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%F_Waves1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%F_Rdtn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%F_PtfmAM); if (RegCheckErr(RF, RoutineName)) return
   call SS_Rad_UnpackMisc(RF, OutData%SS_Rdtn) ! SS_Rdtn 
   call SS_Rad_UnpackInput(RF, OutData%SS_Rdtn_u) ! SS_Rdtn_u 
   call SS_Rad_UnpackOutput(RF, OutData%SS_Rdtn_y) ! SS_Rdtn_y 
   call SS_Exc_UnpackMisc(RF, OutData%SS_Exctn) ! SS_Exctn 
   call SS_Exc_UnpackInput(RF, OutData%SS_Exctn_u) ! SS_Exctn_u 
   call SS_Exc_UnpackOutput(RF, OutData%SS_Exctn_y) ! SS_Exctn_y 
   call Conv_Rdtn_UnpackMisc(RF, OutData%Conv_Rdtn) ! Conv_Rdtn 
   call Conv_Rdtn_UnpackInput(RF, OutData%Conv_Rdtn_u) ! Conv_Rdtn_u 
   call Conv_Rdtn_UnpackOutput(RF, OutData%Conv_Rdtn_y) ! Conv_Rdtn_y 
   call SeaSt_WaveField_UnpackMisc(RF, OutData%WaveField_m) ! WaveField_m 
end subroutine

subroutine WAMIT_CopyParam(SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg)
   type(WAMIT_ParameterType), intent(in) :: SrcParamData
   type(WAMIT_ParameterType), intent(inout) :: DstParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(5), UB(5)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'WAMIT_CopyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstParamData%NBody = SrcParamData%NBody
   DstParamData%NBodyMod = SrcParamData%NBodyMod
   if (allocated(SrcParamData%F_HS_Moment_Offset)) then
      LB(1:2) = lbound(SrcParamData%F_HS_Moment_Offset)
      UB(1:2) = ubound(SrcParamData%F_HS_Moment_Offset)
      if (.not. allocated(DstParamData%F_HS_Moment_Offset)) then
         allocate(DstParamData%F_HS_Moment_Offset(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%F_HS_Moment_Offset.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%F_HS_Moment_Offset = SrcParamData%F_HS_Moment_Offset
   end if
   if (allocated(SrcParamData%HdroAdMsI)) then
      LB(1:2) = lbound(SrcParamData%HdroAdMsI)
      UB(1:2) = ubound(SrcParamData%HdroAdMsI)
      if (.not. allocated(DstParamData%HdroAdMsI)) then
         allocate(DstParamData%HdroAdMsI(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%HdroAdMsI.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%HdroAdMsI = SrcParamData%HdroAdMsI
   end if
   if (allocated(SrcParamData%HdroSttc)) then
      LB(1:2) = lbound(SrcParamData%HdroSttc)
      UB(1:2) = ubound(SrcParamData%HdroSttc)
      if (.not. allocated(DstParamData%HdroSttc)) then
         allocate(DstParamData%HdroSttc(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%HdroSttc.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%HdroSttc = SrcParamData%HdroSttc
   end if
   DstParamData%RdtnMod = SrcParamData%RdtnMod
   DstParamData%ExctnMod = SrcParamData%ExctnMod
   DstParamData%ExctnDisp = SrcParamData%ExctnDisp
   DstParamData%ExctnCutOff = SrcParamData%ExctnCutOff
   DstParamData%NExctnHdg = SrcParamData%NExctnHdg
   DstParamData%ExctnFiltConst = SrcParamData%ExctnFiltConst
   if (allocated(SrcParamData%WaveExctn)) then
      LB(1:3) = lbound(SrcParamData%WaveExctn)
      UB(1:3) = ubound(SrcParamData%WaveExctn)
      if (.not. allocated(DstParamData%WaveExctn)) then
         allocate(DstParamData%WaveExctn(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%WaveExctn.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%WaveExctn = SrcParamData%WaveExctn
   end if
   if (allocated(SrcParamData%WaveExctnGrid)) then
      LB(1:5) = lbound(SrcParamData%WaveExctnGrid)
      UB(1:5) = ubound(SrcParamData%WaveExctnGrid)
      if (.not. allocated(DstParamData%WaveExctnGrid)) then
         allocate(DstParamData%WaveExctnGrid(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4),LB(5):UB(5)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%WaveExctnGrid.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%WaveExctnGrid = SrcParamData%WaveExctnGrid
   end if
   call Conv_Rdtn_CopyParam(SrcParamData%Conv_Rdtn, DstParamData%Conv_Rdtn, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call SS_Rad_CopyParam(SrcParamData%SS_Rdtn, DstParamData%SS_Rdtn, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call SS_Exc_CopyParam(SrcParamData%SS_Exctn, DstParamData%SS_Exctn, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstParamData%DT = SrcParamData%DT
   DstParamData%WaveField => SrcParamData%WaveField
   DstParamData%PtfmYMod = SrcParamData%PtfmYMod
   call SeaSt_WaveField_CopyParam(SrcParamData%ExctnGridParams, DstParamData%ExctnGridParams, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine WAMIT_DestroyParam(ParamData, ErrStat, ErrMsg)
   type(WAMIT_ParameterType), intent(inout) :: ParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'WAMIT_DestroyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ParamData%F_HS_Moment_Offset)) then
      deallocate(ParamData%F_HS_Moment_Offset)
   end if
   if (allocated(ParamData%HdroAdMsI)) then
      deallocate(ParamData%HdroAdMsI)
   end if
   if (allocated(ParamData%HdroSttc)) then
      deallocate(ParamData%HdroSttc)
   end if
   if (allocated(ParamData%WaveExctn)) then
      deallocate(ParamData%WaveExctn)
   end if
   if (allocated(ParamData%WaveExctnGrid)) then
      deallocate(ParamData%WaveExctnGrid)
   end if
   call Conv_Rdtn_DestroyParam(ParamData%Conv_Rdtn, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call SS_Rad_DestroyParam(ParamData%SS_Rdtn, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call SS_Exc_DestroyParam(ParamData%SS_Exctn, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   nullify(ParamData%WaveField)
   call SeaSt_WaveField_DestroyParam(ParamData%ExctnGridParams, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine WAMIT_PackParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(WAMIT_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'WAMIT_PackParam'
   logical         :: PtrInIndex
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%NBody)
   call RegPack(RF, InData%NBodyMod)
   call RegPackAlloc(RF, InData%F_HS_Moment_Offset)
   call RegPackAlloc(RF, InData%HdroAdMsI)
   call RegPackAlloc(RF, InData%HdroSttc)
   call RegPack(RF, InData%RdtnMod)
   call RegPack(RF, InData%ExctnMod)
   call RegPack(RF, InData%ExctnDisp)
   call RegPack(RF, InData%ExctnCutOff)
   call RegPack(RF, InData%NExctnHdg)
   call RegPack(RF, InData%ExctnFiltConst)
   call RegPackAlloc(RF, InData%WaveExctn)
   call RegPackAlloc(RF, InData%WaveExctnGrid)
   call Conv_Rdtn_PackParam(RF, InData%Conv_Rdtn) 
   call SS_Rad_PackParam(RF, InData%SS_Rdtn) 
   call SS_Exc_PackParam(RF, InData%SS_Exctn) 
   call RegPack(RF, InData%DT)
   call RegPack(RF, associated(InData%WaveField))
   if (associated(InData%WaveField)) then
      call RegPackPointer(RF, c_loc(InData%WaveField), PtrInIndex)
      if (.not. PtrInIndex) then
         call SeaSt_WaveField_PackSeaSt_WaveFieldType(RF, InData%WaveField) 
      end if
   end if
   call RegPack(RF, InData%PtfmYMod)
   call SeaSt_WaveField_PackParam(RF, InData%ExctnGridParams) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine WAMIT_UnPackParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(WAMIT_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'WAMIT_UnPackParam'
   integer(B4Ki)   :: LB(5), UB(5)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   integer(B8Ki)   :: PtrIdx
   type(c_ptr)     :: Ptr
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%NBody); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NBodyMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%F_HS_Moment_Offset); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%HdroAdMsI); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%HdroSttc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RdtnMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ExctnMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ExctnDisp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ExctnCutOff); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NExctnHdg); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ExctnFiltConst); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WaveExctn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WaveExctnGrid); if (RegCheckErr(RF, RoutineName)) return
   call Conv_Rdtn_UnpackParam(RF, OutData%Conv_Rdtn) ! Conv_Rdtn 
   call SS_Rad_UnpackParam(RF, OutData%SS_Rdtn) ! SS_Rdtn 
   call SS_Exc_UnpackParam(RF, OutData%SS_Exctn) ! SS_Exctn 
   call RegUnpack(RF, OutData%DT); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%WaveField)) deallocate(OutData%WaveField)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackPointer(RF, Ptr, PtrIdx); if (RegCheckErr(RF, RoutineName)) return
      if (c_associated(Ptr)) then
         call c_f_pointer(Ptr, OutData%WaveField)
      else
         allocate(OutData%WaveField,stat=stat)
         if (stat /= 0) then 
            call SetErrStat(ErrID_Fatal, 'Error allocating OutData%WaveField.', RF%ErrStat, RF%ErrMsg, RoutineName)
            return
         end if
         RF%Pointers(PtrIdx) = c_loc(OutData%WaveField)
         call SeaSt_WaveField_UnpackSeaSt_WaveFieldType(RF, OutData%WaveField) ! WaveField 
      end if
   else
      OutData%WaveField => null()
   end if
   call RegUnpack(RF, OutData%PtfmYMod); if (RegCheckErr(RF, RoutineName)) return
   call SeaSt_WaveField_UnpackParam(RF, OutData%ExctnGridParams) ! ExctnGridParams 
end subroutine

subroutine WAMIT_CopyInput(SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg)
   type(WAMIT_InputType), intent(inout) :: SrcInputData
   type(WAMIT_InputType), intent(inout) :: DstInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'WAMIT_CopyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshCopy(SrcInputData%Mesh, DstInputData%Mesh, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstInputData%PtfmRefY = SrcInputData%PtfmRefY
end subroutine

subroutine WAMIT_DestroyInput(InputData, ErrStat, ErrMsg)
   type(WAMIT_InputType), intent(inout) :: InputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'WAMIT_DestroyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshDestroy( InputData%Mesh, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine WAMIT_PackInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(WAMIT_InputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'WAMIT_PackInput'
   if (RF%ErrStat >= AbortErrLev) return
   call MeshPack(RF, InData%Mesh) 
   call RegPack(RF, InData%PtfmRefY)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine WAMIT_UnPackInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(WAMIT_InputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'WAMIT_UnPackInput'
   if (RF%ErrStat /= ErrID_None) return
   call MeshUnpack(RF, OutData%Mesh) ! Mesh 
   call RegUnpack(RF, OutData%PtfmRefY); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine WAMIT_CopyOutput(SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg)
   type(WAMIT_OutputType), intent(inout) :: SrcOutputData
   type(WAMIT_OutputType), intent(inout) :: DstOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'WAMIT_CopyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshCopy(SrcOutputData%Mesh, DstOutputData%Mesh, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine WAMIT_DestroyOutput(OutputData, ErrStat, ErrMsg)
   type(WAMIT_OutputType), intent(inout) :: OutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'WAMIT_DestroyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshDestroy( OutputData%Mesh, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine WAMIT_PackOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(WAMIT_OutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'WAMIT_PackOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call MeshPack(RF, InData%Mesh) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine WAMIT_UnPackOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(WAMIT_OutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'WAMIT_UnPackOutput'
   if (RF%ErrStat /= ErrID_None) return
   call MeshUnpack(RF, OutData%Mesh) ! Mesh 
end subroutine

subroutine WAMIT_Input_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
   ! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(WAMIT_InputType), intent(inout)  :: u(:) ! Input at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Inputs
   type(WAMIT_InputType), intent(inout)  :: u_out ! Input at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'WAMIT_Input_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(u)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(u)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(u) - 1
   select case (order)
   case (0)
      call WAMIT_CopyInput(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call WAMIT_Input_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call WAMIT_Input_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(u) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE WAMIT_Input_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

   TYPE(WAMIT_InputType), INTENT(INOUT)  :: u1    ! Input at t1 > t2
   TYPE(WAMIT_InputType), INTENT(INOUT)  :: u2    ! Input at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Inputs
   TYPE(WAMIT_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'WAMIT_Input_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   CALL MeshExtrapInterp1(u1%Mesh, u2%Mesh, tin, u_out%Mesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   u_out%PtfmRefY = a1*u1%PtfmRefY + a2*u2%PtfmRefY
END SUBROUTINE

SUBROUTINE WAMIT_Input_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

   TYPE(WAMIT_InputType), INTENT(INOUT)  :: u1      ! Input at t1 > t2 > t3
   TYPE(WAMIT_InputType), INTENT(INOUT)  :: u2      ! Input at t2 > t3
   TYPE(WAMIT_InputType), INTENT(INOUT)  :: u3      ! Input at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Inputs
   TYPE(WAMIT_InputType), INTENT(INOUT)  :: u_out     ! Input at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'WAMIT_Input_ExtrapInterp2'
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   CALL MeshExtrapInterp2(u1%Mesh, u2%Mesh, u3%Mesh, tin, u_out%Mesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   u_out%PtfmRefY = a1*u1%PtfmRefY + a2*u2%PtfmRefY + a3*u3%PtfmRefY
END SUBROUTINE

subroutine WAMIT_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
   ! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(WAMIT_OutputType), intent(inout)  :: y(:) ! Output at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Outputs
   type(WAMIT_OutputType), intent(inout)  :: y_out ! Output at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'WAMIT_Output_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(y)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(y)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(y) - 1
   select case (order)
   case (0)
      call WAMIT_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call WAMIT_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call WAMIT_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(y) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE WAMIT_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

   TYPE(WAMIT_OutputType), INTENT(INOUT)  :: y1    ! Output at t1 > t2
   TYPE(WAMIT_OutputType), INTENT(INOUT)  :: y2    ! Output at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
   TYPE(WAMIT_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'WAMIT_Output_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   CALL MeshExtrapInterp1(y1%Mesh, y2%Mesh, tin, y_out%Mesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
END SUBROUTINE

SUBROUTINE WAMIT_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

   TYPE(WAMIT_OutputType), INTENT(INOUT)  :: y1      ! Output at t1 > t2 > t3
   TYPE(WAMIT_OutputType), INTENT(INOUT)  :: y2      ! Output at t2 > t3
   TYPE(WAMIT_OutputType), INTENT(INOUT)  :: y3      ! Output at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
   TYPE(WAMIT_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'WAMIT_Output_ExtrapInterp2'
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   CALL MeshExtrapInterp2(y1%Mesh, y2%Mesh, y3%Mesh, tin, y_out%Mesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
END SUBROUTINE
END MODULE WAMIT_Types
!ENDOFREGISTRYGENERATEDFILE
