!STARTOFREGISTRYGENERATEDFILE 'SS_Radiation_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! SS_Radiation_Types
!.................................................................................................................................
! This file is part of SS_Radiation.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in SS_Radiation. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE SS_Radiation_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE NWTC_Library
IMPLICIT NONE
! =========  SS_Rad_InitInputType  =======
  TYPE, PUBLIC :: SS_Rad_InitInputType
    CHARACTER(1024)  :: InputFile      !< Name of the input file [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: enabledDOFs      !< Vector with enable platf. DOFs [(m/s]
    INTEGER(IntKi)  :: NBody = 0_IntKi      !< Number of WAMIT bodies for this State Space model [-]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: PtfmRefztRot      !< The rotation about zt of the body reference frame(s) from xt/yt [radians]
  END TYPE SS_Rad_InitInputType
! =======================
! =========  SS_Rad_InitOutputType  =======
  TYPE, PUBLIC :: SS_Rad_InitOutputType
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputHdr      !< Header of the output [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputUnt      !< Units of the output [-]
  END TYPE SS_Rad_InitOutputType
! =======================
! =========  SS_Rad_ContinuousStateType  =======
  TYPE, PUBLIC :: SS_Rad_ContinuousStateType
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: x      !< Continuous States [-]
  END TYPE SS_Rad_ContinuousStateType
! =======================
! =========  SS_Rad_DiscreteStateType  =======
  TYPE, PUBLIC :: SS_Rad_DiscreteStateType
    REAL(SiKi)  :: DummyDiscState = 0.0_R4Ki      !<  [-]
  END TYPE SS_Rad_DiscreteStateType
! =======================
! =========  SS_Rad_ConstraintStateType  =======
  TYPE, PUBLIC :: SS_Rad_ConstraintStateType
    REAL(SiKi)  :: DummyConstrState = 0.0_R4Ki      !<  [-]
  END TYPE SS_Rad_ConstraintStateType
! =======================
! =========  SS_Rad_OtherStateType  =======
  TYPE, PUBLIC :: SS_Rad_OtherStateType
    INTEGER(IntKi)  :: n = 0_IntKi      !< Current Time step [-]
    TYPE(SS_Rad_ContinuousStateType) , DIMENSION(1:4)  :: xdot      !< Old Values of dxdt to used by the solver (multistep method) [-]
  END TYPE SS_Rad_OtherStateType
! =======================
! =========  SS_Rad_MiscVarType  =======
  TYPE, PUBLIC :: SS_Rad_MiscVarType
    REAL(SiKi)  :: DummyMiscVar = 0.0_R4Ki      !< Remove this variable if you have misc/optimization variables [-]
  END TYPE SS_Rad_MiscVarType
! =======================
! =========  SS_Rad_ParameterType  =======
  TYPE, PUBLIC :: SS_Rad_ParameterType
    REAL(DbKi)  :: DT = 0.0_R8Ki      !< Time step [(s)]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: A      !< A matrix [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: B      !< B matrix [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: C      !< C matrix [-]
    INTEGER(IntKi)  :: numStates = 0      !< Number of states [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: spdof      !< States per dof [-]
    INTEGER(IntKi)  :: NBody = 0_IntKi      !< Number of WAMIT bodies for this State Space model [-]
  END TYPE SS_Rad_ParameterType
! =======================
! =========  SS_Rad_InputType  =======
  TYPE, PUBLIC :: SS_Rad_InputType
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: dq      !< Body velocities [-]
  END TYPE SS_Rad_InputType
! =======================
! =========  SS_Rad_OutputType  =======
  TYPE, PUBLIC :: SS_Rad_OutputType
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: y      !< Force [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WriteOutput      !< output Data [(kN)]
  END TYPE SS_Rad_OutputType
! =======================
CONTAINS

subroutine SS_Rad_CopyInitInput(SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg)
   type(SS_Rad_InitInputType), intent(in) :: SrcInitInputData
   type(SS_Rad_InitInputType), intent(inout) :: DstInitInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'SS_Rad_CopyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInitInputData%InputFile = SrcInitInputData%InputFile
   if (allocated(SrcInitInputData%enabledDOFs)) then
      LB(1:1) = lbound(SrcInitInputData%enabledDOFs)
      UB(1:1) = ubound(SrcInitInputData%enabledDOFs)
      if (.not. allocated(DstInitInputData%enabledDOFs)) then
         allocate(DstInitInputData%enabledDOFs(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%enabledDOFs.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%enabledDOFs = SrcInitInputData%enabledDOFs
   end if
   DstInitInputData%NBody = SrcInitInputData%NBody
   if (allocated(SrcInitInputData%PtfmRefztRot)) then
      LB(1:1) = lbound(SrcInitInputData%PtfmRefztRot)
      UB(1:1) = ubound(SrcInitInputData%PtfmRefztRot)
      if (.not. allocated(DstInitInputData%PtfmRefztRot)) then
         allocate(DstInitInputData%PtfmRefztRot(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%PtfmRefztRot.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%PtfmRefztRot = SrcInitInputData%PtfmRefztRot
   end if
end subroutine

subroutine SS_Rad_DestroyInitInput(InitInputData, ErrStat, ErrMsg)
   type(SS_Rad_InitInputType), intent(inout) :: InitInputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SS_Rad_DestroyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InitInputData%enabledDOFs)) then
      deallocate(InitInputData%enabledDOFs)
   end if
   if (allocated(InitInputData%PtfmRefztRot)) then
      deallocate(InitInputData%PtfmRefztRot)
   end if
end subroutine

subroutine SS_Rad_PackInitInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SS_Rad_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SS_Rad_PackInitInput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%InputFile)
   call RegPackAlloc(RF, InData%enabledDOFs)
   call RegPack(RF, InData%NBody)
   call RegPackAlloc(RF, InData%PtfmRefztRot)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SS_Rad_UnPackInitInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SS_Rad_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SS_Rad_UnPackInitInput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%InputFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%enabledDOFs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NBody); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PtfmRefztRot); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SS_Rad_CopyInitOutput(SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg)
   type(SS_Rad_InitOutputType), intent(in) :: SrcInitOutputData
   type(SS_Rad_InitOutputType), intent(inout) :: DstInitOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'SS_Rad_CopyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcInitOutputData%WriteOutputHdr)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputHdr)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputHdr)
      if (.not. allocated(DstInitOutputData%WriteOutputHdr)) then
         allocate(DstInitOutputData%WriteOutputHdr(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputHdr.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputHdr = SrcInitOutputData%WriteOutputHdr
   end if
   if (allocated(SrcInitOutputData%WriteOutputUnt)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputUnt)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputUnt)
      if (.not. allocated(DstInitOutputData%WriteOutputUnt)) then
         allocate(DstInitOutputData%WriteOutputUnt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputUnt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputUnt = SrcInitOutputData%WriteOutputUnt
   end if
end subroutine

subroutine SS_Rad_DestroyInitOutput(InitOutputData, ErrStat, ErrMsg)
   type(SS_Rad_InitOutputType), intent(inout) :: InitOutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SS_Rad_DestroyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InitOutputData%WriteOutputHdr)) then
      deallocate(InitOutputData%WriteOutputHdr)
   end if
   if (allocated(InitOutputData%WriteOutputUnt)) then
      deallocate(InitOutputData%WriteOutputUnt)
   end if
end subroutine

subroutine SS_Rad_PackInitOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SS_Rad_InitOutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SS_Rad_PackInitOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%WriteOutputHdr)
   call RegPackAlloc(RF, InData%WriteOutputUnt)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SS_Rad_UnPackInitOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SS_Rad_InitOutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SS_Rad_UnPackInitOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%WriteOutputHdr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutputUnt); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SS_Rad_CopyContState(SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg)
   type(SS_Rad_ContinuousStateType), intent(in) :: SrcContStateData
   type(SS_Rad_ContinuousStateType), intent(inout) :: DstContStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'SS_Rad_CopyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcContStateData%x)) then
      LB(1:1) = lbound(SrcContStateData%x)
      UB(1:1) = ubound(SrcContStateData%x)
      if (.not. allocated(DstContStateData%x)) then
         allocate(DstContStateData%x(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstContStateData%x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstContStateData%x = SrcContStateData%x
   end if
end subroutine

subroutine SS_Rad_DestroyContState(ContStateData, ErrStat, ErrMsg)
   type(SS_Rad_ContinuousStateType), intent(inout) :: ContStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SS_Rad_DestroyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ContStateData%x)) then
      deallocate(ContStateData%x)
   end if
end subroutine

subroutine SS_Rad_PackContState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SS_Rad_ContinuousStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SS_Rad_PackContState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%x)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SS_Rad_UnPackContState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SS_Rad_ContinuousStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SS_Rad_UnPackContState'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%x); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SS_Rad_CopyDiscState(SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg)
   type(SS_Rad_DiscreteStateType), intent(in) :: SrcDiscStateData
   type(SS_Rad_DiscreteStateType), intent(inout) :: DstDiscStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SS_Rad_CopyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstDiscStateData%DummyDiscState = SrcDiscStateData%DummyDiscState
end subroutine

subroutine SS_Rad_DestroyDiscState(DiscStateData, ErrStat, ErrMsg)
   type(SS_Rad_DiscreteStateType), intent(inout) :: DiscStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SS_Rad_DestroyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine SS_Rad_PackDiscState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SS_Rad_DiscreteStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SS_Rad_PackDiscState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyDiscState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SS_Rad_UnPackDiscState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SS_Rad_DiscreteStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SS_Rad_UnPackDiscState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyDiscState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SS_Rad_CopyConstrState(SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg)
   type(SS_Rad_ConstraintStateType), intent(in) :: SrcConstrStateData
   type(SS_Rad_ConstraintStateType), intent(inout) :: DstConstrStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SS_Rad_CopyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstConstrStateData%DummyConstrState = SrcConstrStateData%DummyConstrState
end subroutine

subroutine SS_Rad_DestroyConstrState(ConstrStateData, ErrStat, ErrMsg)
   type(SS_Rad_ConstraintStateType), intent(inout) :: ConstrStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SS_Rad_DestroyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine SS_Rad_PackConstrState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SS_Rad_ConstraintStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SS_Rad_PackConstrState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyConstrState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SS_Rad_UnPackConstrState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SS_Rad_ConstraintStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SS_Rad_UnPackConstrState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyConstrState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SS_Rad_CopyOtherState(SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg)
   type(SS_Rad_OtherStateType), intent(in) :: SrcOtherStateData
   type(SS_Rad_OtherStateType), intent(inout) :: DstOtherStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SS_Rad_CopyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstOtherStateData%n = SrcOtherStateData%n
   LB(1:1) = lbound(SrcOtherStateData%xdot)
   UB(1:1) = ubound(SrcOtherStateData%xdot)
   do i1 = LB(1), UB(1)
      call SS_Rad_CopyContState(SrcOtherStateData%xdot(i1), DstOtherStateData%xdot(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
end subroutine

subroutine SS_Rad_DestroyOtherState(OtherStateData, ErrStat, ErrMsg)
   type(SS_Rad_OtherStateType), intent(inout) :: OtherStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'SS_Rad_DestroyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   LB(1:1) = lbound(OtherStateData%xdot)
   UB(1:1) = ubound(OtherStateData%xdot)
   do i1 = LB(1), UB(1)
      call SS_Rad_DestroyContState(OtherStateData%xdot(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
end subroutine

subroutine SS_Rad_PackOtherState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SS_Rad_OtherStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SS_Rad_PackOtherState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%n)
   LB(1:1) = lbound(InData%xdot)
   UB(1:1) = ubound(InData%xdot)
   do i1 = LB(1), UB(1)
      call SS_Rad_PackContState(RF, InData%xdot(i1)) 
   end do
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SS_Rad_UnPackOtherState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SS_Rad_OtherStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SS_Rad_UnPackOtherState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%n); if (RegCheckErr(RF, RoutineName)) return
   LB(1:1) = lbound(OutData%xdot)
   UB(1:1) = ubound(OutData%xdot)
   do i1 = LB(1), UB(1)
      call SS_Rad_UnpackContState(RF, OutData%xdot(i1)) ! xdot 
   end do
end subroutine

subroutine SS_Rad_CopyMisc(SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg)
   type(SS_Rad_MiscVarType), intent(in) :: SrcMiscData
   type(SS_Rad_MiscVarType), intent(inout) :: DstMiscData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SS_Rad_CopyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstMiscData%DummyMiscVar = SrcMiscData%DummyMiscVar
end subroutine

subroutine SS_Rad_DestroyMisc(MiscData, ErrStat, ErrMsg)
   type(SS_Rad_MiscVarType), intent(inout) :: MiscData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SS_Rad_DestroyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine SS_Rad_PackMisc(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SS_Rad_MiscVarType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SS_Rad_PackMisc'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyMiscVar)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SS_Rad_UnPackMisc(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SS_Rad_MiscVarType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SS_Rad_UnPackMisc'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyMiscVar); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SS_Rad_CopyParam(SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg)
   type(SS_Rad_ParameterType), intent(in) :: SrcParamData
   type(SS_Rad_ParameterType), intent(inout) :: DstParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'SS_Rad_CopyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstParamData%DT = SrcParamData%DT
   if (allocated(SrcParamData%A)) then
      LB(1:2) = lbound(SrcParamData%A)
      UB(1:2) = ubound(SrcParamData%A)
      if (.not. allocated(DstParamData%A)) then
         allocate(DstParamData%A(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%A.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%A = SrcParamData%A
   end if
   if (allocated(SrcParamData%B)) then
      LB(1:2) = lbound(SrcParamData%B)
      UB(1:2) = ubound(SrcParamData%B)
      if (.not. allocated(DstParamData%B)) then
         allocate(DstParamData%B(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%B.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%B = SrcParamData%B
   end if
   if (allocated(SrcParamData%C)) then
      LB(1:2) = lbound(SrcParamData%C)
      UB(1:2) = ubound(SrcParamData%C)
      if (.not. allocated(DstParamData%C)) then
         allocate(DstParamData%C(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%C.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%C = SrcParamData%C
   end if
   DstParamData%numStates = SrcParamData%numStates
   if (allocated(SrcParamData%spdof)) then
      LB(1:1) = lbound(SrcParamData%spdof)
      UB(1:1) = ubound(SrcParamData%spdof)
      if (.not. allocated(DstParamData%spdof)) then
         allocate(DstParamData%spdof(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%spdof.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%spdof = SrcParamData%spdof
   end if
   DstParamData%NBody = SrcParamData%NBody
end subroutine

subroutine SS_Rad_DestroyParam(ParamData, ErrStat, ErrMsg)
   type(SS_Rad_ParameterType), intent(inout) :: ParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SS_Rad_DestroyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ParamData%A)) then
      deallocate(ParamData%A)
   end if
   if (allocated(ParamData%B)) then
      deallocate(ParamData%B)
   end if
   if (allocated(ParamData%C)) then
      deallocate(ParamData%C)
   end if
   if (allocated(ParamData%spdof)) then
      deallocate(ParamData%spdof)
   end if
end subroutine

subroutine SS_Rad_PackParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SS_Rad_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SS_Rad_PackParam'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DT)
   call RegPackAlloc(RF, InData%A)
   call RegPackAlloc(RF, InData%B)
   call RegPackAlloc(RF, InData%C)
   call RegPack(RF, InData%numStates)
   call RegPackAlloc(RF, InData%spdof)
   call RegPack(RF, InData%NBody)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SS_Rad_UnPackParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SS_Rad_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SS_Rad_UnPackParam'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%A); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%B); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%C); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%numStates); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%spdof); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NBody); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SS_Rad_CopyInput(SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg)
   type(SS_Rad_InputType), intent(in) :: SrcInputData
   type(SS_Rad_InputType), intent(inout) :: DstInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'SS_Rad_CopyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcInputData%dq)) then
      LB(1:1) = lbound(SrcInputData%dq)
      UB(1:1) = ubound(SrcInputData%dq)
      if (.not. allocated(DstInputData%dq)) then
         allocate(DstInputData%dq(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%dq.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%dq = SrcInputData%dq
   end if
end subroutine

subroutine SS_Rad_DestroyInput(InputData, ErrStat, ErrMsg)
   type(SS_Rad_InputType), intent(inout) :: InputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SS_Rad_DestroyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InputData%dq)) then
      deallocate(InputData%dq)
   end if
end subroutine

subroutine SS_Rad_PackInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SS_Rad_InputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SS_Rad_PackInput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%dq)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SS_Rad_UnPackInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SS_Rad_InputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SS_Rad_UnPackInput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%dq); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SS_Rad_CopyOutput(SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg)
   type(SS_Rad_OutputType), intent(in) :: SrcOutputData
   type(SS_Rad_OutputType), intent(inout) :: DstOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'SS_Rad_CopyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcOutputData%y)) then
      LB(1:1) = lbound(SrcOutputData%y)
      UB(1:1) = ubound(SrcOutputData%y)
      if (.not. allocated(DstOutputData%y)) then
         allocate(DstOutputData%y(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%y.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%y = SrcOutputData%y
   end if
   if (allocated(SrcOutputData%WriteOutput)) then
      LB(1:1) = lbound(SrcOutputData%WriteOutput)
      UB(1:1) = ubound(SrcOutputData%WriteOutput)
      if (.not. allocated(DstOutputData%WriteOutput)) then
         allocate(DstOutputData%WriteOutput(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%WriteOutput.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%WriteOutput = SrcOutputData%WriteOutput
   end if
end subroutine

subroutine SS_Rad_DestroyOutput(OutputData, ErrStat, ErrMsg)
   type(SS_Rad_OutputType), intent(inout) :: OutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'SS_Rad_DestroyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(OutputData%y)) then
      deallocate(OutputData%y)
   end if
   if (allocated(OutputData%WriteOutput)) then
      deallocate(OutputData%WriteOutput)
   end if
end subroutine

subroutine SS_Rad_PackOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(SS_Rad_OutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'SS_Rad_PackOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%y)
   call RegPackAlloc(RF, InData%WriteOutput)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SS_Rad_UnPackOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(SS_Rad_OutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'SS_Rad_UnPackOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutput); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine SS_Rad_Input_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
   ! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(SS_Rad_InputType), intent(in)  :: u(:) ! Input at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Inputs
   type(SS_Rad_InputType), intent(inout)  :: u_out ! Input at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'SS_Rad_Input_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(u)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(u)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(u) - 1
   select case (order)
   case (0)
      call SS_Rad_CopyInput(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call SS_Rad_Input_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call SS_Rad_Input_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(u) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE SS_Rad_Input_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

   TYPE(SS_Rad_InputType), INTENT(IN)  :: u1    ! Input at t1 > t2
   TYPE(SS_Rad_InputType), INTENT(IN)  :: u2    ! Input at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Inputs
   TYPE(SS_Rad_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'SS_Rad_Input_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   IF (ALLOCATED(u_out%dq) .AND. ALLOCATED(u1%dq)) THEN
      u_out%dq = a1*u1%dq + a2*u2%dq
   END IF ! check if allocated
END SUBROUTINE

SUBROUTINE SS_Rad_Input_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

   TYPE(SS_Rad_InputType), INTENT(IN)  :: u1      ! Input at t1 > t2 > t3
   TYPE(SS_Rad_InputType), INTENT(IN)  :: u2      ! Input at t2 > t3
   TYPE(SS_Rad_InputType), INTENT(IN)  :: u3      ! Input at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Inputs
   TYPE(SS_Rad_InputType), INTENT(INOUT)  :: u_out     ! Input at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'SS_Rad_Input_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   IF (ALLOCATED(u_out%dq) .AND. ALLOCATED(u1%dq)) THEN
      u_out%dq = a1*u1%dq + a2*u2%dq + a3*u3%dq
   END IF ! check if allocated
END SUBROUTINE

subroutine SS_Rad_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
   ! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(SS_Rad_OutputType), intent(in)  :: y(:) ! Output at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Outputs
   type(SS_Rad_OutputType), intent(inout)  :: y_out ! Output at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'SS_Rad_Output_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(y)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(y)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(y) - 1
   select case (order)
   case (0)
      call SS_Rad_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call SS_Rad_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call SS_Rad_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(y) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE SS_Rad_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

   TYPE(SS_Rad_OutputType), INTENT(IN)  :: y1    ! Output at t1 > t2
   TYPE(SS_Rad_OutputType), INTENT(IN)  :: y2    ! Output at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
   TYPE(SS_Rad_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'SS_Rad_Output_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   IF (ALLOCATED(y_out%y) .AND. ALLOCATED(y1%y)) THEN
      y_out%y = a1*y1%y + a2*y2%y
   END IF ! check if allocated
   IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
      y_out%WriteOutput = a1*y1%WriteOutput + a2*y2%WriteOutput
   END IF ! check if allocated
END SUBROUTINE

SUBROUTINE SS_Rad_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

   TYPE(SS_Rad_OutputType), INTENT(IN)  :: y1      ! Output at t1 > t2 > t3
   TYPE(SS_Rad_OutputType), INTENT(IN)  :: y2      ! Output at t2 > t3
   TYPE(SS_Rad_OutputType), INTENT(IN)  :: y3      ! Output at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
   TYPE(SS_Rad_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'SS_Rad_Output_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   IF (ALLOCATED(y_out%y) .AND. ALLOCATED(y1%y)) THEN
      y_out%y = a1*y1%y + a2*y2%y + a3*y3%y
   END IF ! check if allocated
   IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
      y_out%WriteOutput = a1*y1%WriteOutput + a2*y2%WriteOutput + a3*y3%WriteOutput
   END IF ! check if allocated
END SUBROUTINE
END MODULE SS_Radiation_Types
!ENDOFREGISTRYGENERATEDFILE
