!STARTOFREGISTRYGENERATEDFILE 'Morison_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! Morison_Types
!.................................................................................................................................
! This file is part of Morison.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in Morison. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE Morison_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE SeaSt_WaveField_Types
USE NWTC_Library
IMPLICIT NONE
    INTEGER(IntKi), PUBLIC, PARAMETER  :: MSecGeom_Cyl = 1      ! MSecGeom = 1   [circular member cross section] [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: MSecGeom_Rec = 2      ! MSecGeom = 2   [rectangular member cross section] [-]
! =========  Morison_JointType  =======
  TYPE, PUBLIC :: Morison_JointType
    INTEGER(IntKi)  :: JointID = 0_IntKi      !< User-specified integer ID for the given joint [-]
    REAL(ReKi) , DIMENSION(1:3)  :: Position = 0.0_ReKi      !< Undisplaced location of the joint in the platform coordinate system [m]
    INTEGER(IntKi)  :: JointAxID = 0_IntKi      !< Axial ID (found in the user-supplied Axial Coefficients Table) for this joint: used to determine axial coefs [-]
    INTEGER(IntKi)  :: JointAxIDIndx = 0_IntKi      !< The index into the Axial Coefs arrays corresponding to the above Axial ID [-]
    INTEGER(IntKi)  :: JointOvrlp = 0_IntKi      !< Joint overlap code [Unused [-]
    INTEGER(IntKi)  :: NConnections = 0_IntKi      !< Number of members connecting to this joint [-]
    INTEGER(IntKi) , DIMENSION(1:50)  :: ConnectionList = 0_IntKi      !< List of Members connected to this joint.  The member index is what is stored, not the Member ID [-]
  END TYPE Morison_JointType
! =======================
! =========  Morison_MemberPropTypeCyl  =======
  TYPE, PUBLIC :: Morison_MemberPropTypeCyl
    INTEGER(IntKi)  :: PropSetID = 0_IntKi      !< User-specified integer ID for this group of properties [-]
    REAL(ReKi)  :: PropD = 0.0_ReKi      !< Diameter [m]
    REAL(ReKi)  :: PropThck = 0.0_ReKi      !< Wall thickness [m]
  END TYPE Morison_MemberPropTypeCyl
! =======================
! =========  Morison_MemberPropTypeRec  =======
  TYPE, PUBLIC :: Morison_MemberPropTypeRec
    INTEGER(IntKi)  :: PropSetID = 0_IntKi      !< User-specified integer ID for this group of properties [-]
    REAL(ReKi)  :: PropA = 0.0_ReKi      !< Length of side A [m]
    REAL(ReKi)  :: PropB = 0.0_ReKi      !< Length of side B [m]
    REAL(ReKi)  :: PropThck = 0.0_ReKi      !< Wall thickness [m]
  END TYPE Morison_MemberPropTypeRec
! =======================
! =========  Morison_FilledGroupType  =======
  TYPE, PUBLIC :: Morison_FilledGroupType
    INTEGER(IntKi)  :: FillNumM = 0_IntKi      !< Number of members in the Fill Group [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: FillMList      !< List of Member IDs for the members in this fill group [-]
    REAL(ReKi)  :: FillFSLoc = 0.0_ReKi      !< The free-surface location (in Z) for this fill group [m]
    CHARACTER(80)  :: FillDensChr      !< String version of the Fill density [can be DEFAULT which sets the fill density to WtrDens] [kg/m^3]
    REAL(ReKi)  :: FillDens = 0.0_ReKi      !< Numerical fill density [kg/m^3]
    LOGICAL  :: IsOpen = .false.      !< Whether the internal ballast is open to the outside through the open end of members buried in the seabed [-]
  END TYPE Morison_FilledGroupType
! =======================
! =========  Morison_CoefDpthsCyl  =======
  TYPE, PUBLIC :: Morison_CoefDpthsCyl
    REAL(ReKi)  :: Dpth = 0.0_ReKi      !< Depth location for these depth-based hydrodynamic coefs [m]
    REAL(ReKi)  :: DpthCd = 0.0_ReKi      !< Depth-based drag coef [-]
    REAL(ReKi)  :: DpthCdMG = 0.0_ReKi      !< Depth-based drag coef for marine growth [-]
    REAL(ReKi)  :: DpthCa = 0.0_ReKi      !< Depth-based Ca [-]
    REAL(ReKi)  :: DpthCaMG = 0.0_ReKi      !< Depth-based Ca for marine growth [-]
    REAL(ReKi)  :: DpthCp = 0.0_ReKi      !< Depth-based Cp [-]
    REAL(ReKi)  :: DpthCpMG = 0.0_ReKi      !< Depth-based Cp for marine growth [-]
    REAL(ReKi)  :: DpthAxCd = 0.0_ReKi      !< Depth-based Axial Cd [-]
    REAL(ReKi)  :: DpthAxCdMG = 0.0_ReKi      !< Depth-based Axial Cd for marine growth [-]
    REAL(ReKi)  :: DpthAxCa = 0.0_ReKi      !< Depth-based Axial Ca [-]
    REAL(ReKi)  :: DpthAxCaMG = 0.0_ReKi      !< Depth-based Axial Ca for marine growth [-]
    REAL(ReKi)  :: DpthAxCp = 0.0_ReKi      !< Depth-based Axial Cp [-]
    REAL(ReKi)  :: DpthAxCpMG = 0.0_ReKi      !< Depth-based Axial Cp for marine growth [-]
    REAL(ReKi)  :: DpthCb = 0.0_ReKi      !< Simple model hydrostatic/buoyancy load coefficient [-]
    REAL(ReKi)  :: DpthCbMg = 0.0_ReKi      !< Simple model hydrostatic/buoyancy load coefficient for marine growth [-]
    LOGICAL  :: DpthMCF = .false.      !< Flag T/F for whether the member is modeled with the MacCamy-Fuchs diffraction model [-]
  END TYPE Morison_CoefDpthsCyl
! =======================
! =========  Morison_CoefDpthsRec  =======
  TYPE, PUBLIC :: Morison_CoefDpthsRec
    REAL(ReKi)  :: Dpth = 0.0_ReKi      !< Depth location for these depth-based hydrodynamic coefs [m]
    REAL(ReKi)  :: DpthCdA = 0.0_ReKi      !< Depth-based drag coef [-]
    REAL(ReKi)  :: DpthCdAMG = 0.0_ReKi      !< Depth-based drag coef for marine growth [-]
    REAL(ReKi)  :: DpthCdB = 0.0_ReKi      !< Depth-based drag coef [-]
    REAL(ReKi)  :: DpthCdBMG = 0.0_ReKi      !< Depth-based drag coef for marine growth [-]
    REAL(ReKi)  :: DpthCaA = 0.0_ReKi      !< Depth-based Ca [-]
    REAL(ReKi)  :: DpthCaAMG = 0.0_ReKi      !< Depth-based Ca for marine growth [-]
    REAL(ReKi)  :: DpthCaB = 0.0_ReKi      !< Depth-based Ca [-]
    REAL(ReKi)  :: DpthCaBMG = 0.0_ReKi      !< Depth-based Ca for marine growth [-]
    REAL(ReKi)  :: DpthCp = 0.0_ReKi      !< Depth-based Cp [-]
    REAL(ReKi)  :: DpthCpMG = 0.0_ReKi      !< Depth-based Cp for marine growth [-]
    REAL(ReKi)  :: DpthAxCd = 0.0_ReKi      !< Depth-based Axial Cd [-]
    REAL(ReKi)  :: DpthAxCdMG = 0.0_ReKi      !< Depth-based Axial Cd for marine growth [-]
    REAL(ReKi)  :: DpthAxCa = 0.0_ReKi      !< Depth-based Axial Ca [-]
    REAL(ReKi)  :: DpthAxCaMG = 0.0_ReKi      !< Depth-based Axial Ca for marine growth [-]
    REAL(ReKi)  :: DpthAxCp = 0.0_ReKi      !< Depth-based Axial Cp [-]
    REAL(ReKi)  :: DpthAxCpMG = 0.0_ReKi      !< Depth-based Axial Cp for marine growth [-]
    REAL(ReKi)  :: DpthCb = 0.0_ReKi      !< Simple model hydrostatic/buoyancy load coefficient [-]
    REAL(ReKi)  :: DpthCbMg = 0.0_ReKi      !< Simple model hydrostatic/buoyancy load coefficient for marine growth [-]
    LOGICAL  :: DpthMCF = .false.      !< Flag T/F for whether the member is modeled with the MacCamy-Fuchs diffraction model [-]
  END TYPE Morison_CoefDpthsRec
! =======================
! =========  Morison_AxialCoefType  =======
  TYPE, PUBLIC :: Morison_AxialCoefType
    INTEGER(IntKi)  :: AxCoefID = 0_IntKi      !< User-supplied integer ID for this set of Axial coefs [-]
    REAL(ReKi)  :: AxCd = 0.0_ReKi      !< Axial Cd [-]
    REAL(ReKi)  :: AxCa = 0.0_ReKi      !< Axial Ca [-]
    REAL(ReKi)  :: AxCp = 0.0_ReKi      !< Axial Cp [-]
    REAL(ReKi)  :: AxVnCOff = 0.0_ReKi      !< High-pass cut-off frequency for normal velocity when computing axial drag force [-]
    REAL(ReKi)  :: AxFDLoFSc = 0.0_ReKi      !< Scaling factor for low frequency axial drag force [-]
    INTEGER(IntKi)  :: AxFDMod = 0_IntKi      !< Switch for the axial drag formulation {0: original formulation, 1: Away from member only} [-]
  END TYPE Morison_AxialCoefType
! =======================
! =========  Morison_MemberInputType  =======
  TYPE, PUBLIC :: Morison_MemberInputType
    INTEGER(IntKi)  :: MemberID = 0_IntKi      !< User-supplied integer ID for this member [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: NodeIndx      !< Index of each of the member's nodes in the master node list [-]
    INTEGER(IntKi)  :: MJointID1 = 0_IntKi      !< Joint ID for start of member [-]
    INTEGER(IntKi)  :: MJointID2 = 0_IntKi      !< Joint ID for end of member [-]
    INTEGER(IntKi)  :: MJointID1Indx = 0_IntKi      !< Index into the joint table for the start of this member [-]
    INTEGER(IntKi)  :: MJointID2Indx = 0_IntKi      !< Index into the joint table for the end of this member [-]
    INTEGER(IntKi)  :: MPropSetID1 = 0_IntKi      !< Property set ID for the start of this member [-]
    INTEGER(IntKi)  :: MPropSetID2 = 0_IntKi      !< Property set ID for the end of this member [-]
    INTEGER(IntKi)  :: MPropSetID1Indx = 0_IntKi      !< Index into the Property table for the start of this member [-]
    INTEGER(IntKi)  :: MPropSetID2Indx = 0_IntKi      !< Index into the Property table for the end of this member [-]
    INTEGER(IntKi)  :: MSecGeom = 0_IntKi      !< Member cross section geometry. 1: Circular. 2: Rectangular [-]
    REAL(ReKi)  :: MSpinOrient = 0.0_ReKi      !< Member orientation in terms of rotation angle about the member axis [rad]
    REAL(ReKi)  :: MDivSize = 0.0_ReKi      !< User-specified desired member discretization size for the final element [m]
    INTEGER(IntKi)  :: MCoefMod = 0_IntKi      !< Which coef. model is being used for this member [1=simple, 2=depth-based, 3=member-based] [-]
    INTEGER(IntKi)  :: MHstLMod = 0_IntKi      !< Which hydrostatic model is being used for this member [1=column-type, 2=ship-type] [-]
    INTEGER(IntKi)  :: MmbrCoefIDIndx = 0_IntKi      !< Index into the appropriate coefs table for this member's properties [-]
    INTEGER(IntKi)  :: MmbrFilledIDIndx = 0_IntKi      !< Index into the filled group table if this is a filled member [-]
    LOGICAL  :: PropPot = .false.      !< Flag T/F for whether the member is modeled with potential flow theory [-]
    LOGICAL  :: PropMCF = .false.      !< Flag T/F for whether the member is modeled with the MacCamy-Fuchs diffraction model [-]
    INTEGER(IntKi)  :: NElements = 0_IntKi      !< number of elements in this member [-]
    REAL(ReKi)  :: RefLength = 0.0_ReKi      !< the reference total length for this member [m]
    REAL(ReKi)  :: dl = 0.0_ReKi      !< the reference element length for this member (may be less than MDivSize to achieve uniform element lengths) [m]
  END TYPE Morison_MemberInputType
! =======================
! =========  Morison_NodeType  =======
  TYPE, PUBLIC :: Morison_NodeType
    INTEGER(IntKi)  :: JointIndx = 0_IntKi      !< Joint index from the user joint table that this node corresponds to.  If the software created this node, index is set to -1 [-]
    REAL(ReKi) , DIMENSION(1:3)  :: Position = 0.0_ReKi      !< Position of the node in global coordinates [m]
    INTEGER(IntKi)  :: JointOvrlp = 0_IntKi      !<  [-]
    INTEGER(IntKi)  :: JointAxIDIndx = 0_IntKi      !<  [-]
    INTEGER(IntKi)  :: NConnections = 0_IntKi      !< Number of elements connecting to this node [-]
    INTEGER(IntKi) , DIMENSION(1:50)  :: ConnectionList = 0_IntKi      !< Indices of all the members connected to this node (positive if end 1, negative if end 2) [-]
    REAL(ReKi)  :: JAxCd = 0.0_ReKi      !< Nodal lumped (joint) axial Cd [-]
    REAL(ReKi)  :: JAxCa = 0.0_ReKi      !< Nodal lumped (joint) axial Cp [-]
    REAL(ReKi)  :: JAxCp = 0.0_ReKi      !< Nodal lumped (joint) axial Ca [-]
    REAL(ReKi)  :: JAxVnCOff = 0.0_ReKi      !< High-pass cut-off frequency for normal velocity when computing axial drag force [-]
    REAL(ReKi)  :: JAxFDLoFSc = 0.0_ReKi      !< Scaling factor for low frequency axial drag force [-]
    INTEGER(IntKi)  :: JAxFDMod = 0_IntKi      !< Switch for the axial drag formulation {0: original formulation, 1: Away from member only} [-]
    REAL(ReKi)  :: FillDensity = 0.0_ReKi      !< Fill fluid density [kg/m^3]
    REAL(ReKi)  :: tMG = 0.0_ReKi      !< Nodal thickness with marine growth  [m]
    REAL(ReKi)  :: MGdensity = 0.0_ReKi      !< Nodal density of marine growth [kg/m^3]
  END TYPE Morison_NodeType
! =======================
! =========  Morison_MemberType  =======
  TYPE, PUBLIC :: Morison_MemberType
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: NodeIndx      !< Index of each of the member's nodes in the master node list [-]
    INTEGER(IntKi)  :: MemberID = 0_IntKi      !< User-supplied integer ID for this member [-]
    INTEGER(IntKi)  :: NElements = 0_IntKi      !< number of elements in this member [-]
    REAL(ReKi)  :: RefLength = 0.0_ReKi      !< the reference total length for this member [m]
    REAL(ReKi)  :: cosPhi_ref = 0.0_ReKi      !< the reference cosine of the inclination angle of the member [-]
    REAL(ReKi)  :: dl = 0.0_ReKi      !< the reference element length for this member (may be less than MDivSize to achieve uniform element lengths) [m]
    REAL(ReKi) , DIMENSION(1:3)  :: k = 0.0_ReKi      !< unit vector of the member's orientation (may be changed to per-element once additional flexibility is accounted for in HydroDyn) [m]
    REAL(ReKi) , DIMENSION(1:3,1:3)  :: kkt = 0.0_ReKi      !< matrix of matmul(k_hat, transpose(k_hat) [-]
    REAL(ReKi) , DIMENSION(1:3,1:3)  :: Ak = 0.0_ReKi      !< matrix of I - kkt [-]
    REAL(ReKi) , DIMENSION(1:3)  :: x_hat = 0.0_ReKi      !< unit vector of rectangular member local x-axis aligned with Side A [-]
    REAL(ReKi) , DIMENSION(1:3)  :: y_hat = 0.0_ReKi      !< unit vector of rectangular member local y-axis aligned with Side B [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: R      !< outer member radius at each node [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: RMG      !< radius at each node including marine growth [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: RMGB      !< radius at each node including marine growth scaled by sqrt(Cb) [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Rin      !< inner member radius at node, equivalent to radius of water ballast at this node if filled [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Sa      !< outer member side A length at each node [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: SaMG      !< side A length with marine growth at each node [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: SaMGB      !< side A length with marine growth scaled by sqrt(Cb) [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Sain      !< inner member side A length at node, equivalent to width of water ballast at this node if filled [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Sb      !< outer member side B length at each node [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: SbMG      !< side B length with marine growth at each node [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: SbMGB      !< side B length with marine growth scaled by sqrt(Cb) [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Sbin      !< inner member side B length at node, equivalent to width of water ballast at this node if filled [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: tMG      !< Nodal thickness with marine growth (of member at node location) [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: MGdensity      !< Nodal density of marine growth [kg/m^3]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: dRdl_mg      !< taper dr/dl of outer surface including marine growth of each element [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: dRdl_mg_b      !< taper dr/dl of outer surface including marine growth of each element with scaling of sqrt(Cb) [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: dRdl_in      !< taper dr/dl of interior surface of each element [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: dSadl_mg      !< taper dSa/dl of outer surface including marine growth of each element [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: dSadl_mg_b      !< taper dSa/dl of outer surface including marine growth of each element with scaling of sqrt(Cb) [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: dSadl_in      !< taper dSa/dl of interior surface of each element [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: dSbdl_mg      !< taper dSb/dl of outer surface including marine growth of each element [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: dSbdl_mg_b      !< taper dSb/dl of outer surface including marine growth of each element with scaling of sqrt(Cb) [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: dSbdl_in      !< taper dSb/dl of interior surface of each element [-]
    REAL(ReKi)  :: Vinner = 0.0_ReKi      !< Member volume without marine growth [m^3]
    REAL(ReKi)  :: Vouter = 0.0_ReKi      !< Member volume including marine growth [m^3]
    REAL(ReKi)  :: Vballast = 0.0_ReKi      !< Member ballast volume [m^3]
    REAL(ReKi)  :: Vsubmerged = 0.0_ReKi      !< Submerged volume corresponding to portion of Member in the water [m^3]
    INTEGER(IntKi)  :: elem_fill = 0_IntKi      !< Last (partially) filled element of the member [-]
    REAL(ReKi)  :: l_fill = 0.0_ReKi      !< fill length along member axis from start node 1 [m]
    REAL(ReKi)  :: h_fill = 0.0_ReKi      !< fill length of partially flooded element [m]
    REAL(ReKi)  :: z_overfill = 0.0_ReKi      !< if member is fully filled, the head height of the fill pressure at the end node N+1. Zero if member is partially filled. [m]
    REAL(ReKi)  :: h_floor = 0.0_ReKi      !< the distance from the node to the seabed along the member axis (negative value) [m]
    INTEGER(IntKi)  :: i_floor = 0_IntKi      !< the number of the element that pierces the seabed (zero if the member doesn't pierce it) [-]
    LOGICAL  :: doEndBuoyancy = .false.      !< compute the end plate effect for the hightest node of this member [-]
    INTEGER(IntKi)  :: memfloodstatus = 0_IntKi      !< Member-level flooded status for each elemen: 0 unflooded or fully below seabed, 2 partially flooded, 1 fully flooded  [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: floodstatus      !< flooded status for each element: 0 unflooded or fully below seabed, 1 fully flooded, 2 partially flooded [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: alpha      !< relative volume centroid of each element including marine growth, from node i to node i+1 [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: alpha_fb      !< relative volume centroid of each element's flooded ballast, from node i to node i+1 [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: alpha_fb_star      !< load distribution factor for each element after adjusting alpha_fb for node reference depths [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Cd      !< Member Cd at each node [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Ca      !< Member Ca at each node [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: CdA      !< Member Cd normal to side A at each node [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: CaA      !< Member Ca normal to side A at each node [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: CdB      !< Member Cd normal to side B at each node [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: CaB      !< Member Ca normal to side B at each node [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Cp      !< Member Cp at each node [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: AxCd      !< Member axial Cd at each node [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: AxCa      !< Member axial Ca at each node [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: AxCp      !< Member axial Cp at each node [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Cb      !< Member Cb at each node [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: m_fb_l      !< mass of flooded ballast in lower portion of each element [kg]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: m_fb_u      !< mass of flooded ballast in upper portion of each element [kg]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: h_cfb_l      !< distance to flooded ballast centroid from node point in lower portion of each element [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: h_cfb_u      !< distance to flooded ballast centroid from node point in upper portion of each element [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: I_lfb_l      !< axial moment of inertia of flooded ballast in lower portion of each element [kg-m^2]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: I_lfb_u      !< axial moment of inertia of flooded ballast in upper portion of each element [kg-m^2]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: I_rfb_l      !< radial moment of inertia of flooded ballast in lower portion of each element [kg-m^2]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: I_rfb_u      !< radial moment of inertia of flooded ballast in upper portion of each element [kg-m^2]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: I_xfb_l      !< element local x-moment of inertia of flooded ballast in lower portion of each element [kg-m^2]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: I_xfb_u      !< element local x-moment of inertia of flooded ballast in upper portion of each element [kg-m^2]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: I_yfb_l      !< element local y-moment of inertia of flooded ballast in lower portion of each element [kg-m^2]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: I_yfb_u      !< element local y-moment of inertia of flooded ballast in upper portion of each element [kg-m^2]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: m_mg_l      !< mass of marine growth in lower portion of each element [kg]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: m_mg_u      !< mass of marine growth in upper portion of each element [kg]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: h_cmg_l      !< distance to marine growth centroid from node point in lower portion of each element [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: h_cmg_u      !< distance to marine growth centroid from node point in upper portion of each element [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: I_lmg_l      !< axial moment of inertia of marine growth in lower portion of each element [kg-m^2]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: I_lmg_u      !< axial moment of inertia of marine growth in upper portion of each element [kg-m^2]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: I_rmg_l      !< radial moment of inertia of marine growth in lower portion of each element [kg-m^2]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: I_rmg_u      !< radial moment of inertia of flooded ballast in upper portion of each element [kg-m^2]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: I_xmg_l      !< element local x-moment of inertia of marine growth in lower portion of each element [kg-m^2]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: I_xmg_u      !< element local x-moment of inertia of marine growth in upper portion of each element [kg-m^2]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: I_ymg_l      !< element local y-moment of inertia of marine growth in lower portion of each element [kg-m^2]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: I_ymg_u      !< element local y-moment of inertia of marine growth in upper portion of each element [kg-m^2]
    REAL(ReKi)  :: MGvolume = 0.0_ReKi      !< Volume of marine growth material for this member/element [m^3]
    INTEGER(IntKi)  :: MSecGeom = 0_IntKi      !< Member cross section geometry. 1: Circular. 2: Rectangular [-]
    REAL(ReKi)  :: MSpinOrient = 0.0_ReKi      !< Member orientation in terms of rotation angle about the member axis [rad]
    REAL(ReKi)  :: MDivSize = 0.0_ReKi      !< User-requested final element length (actual length may vary from this request) [m]
    INTEGER(IntKi)  :: MCoefMod = 0_IntKi      !< Coefs model for member: 1 = simple, 2 =depth, 3 = member-based  [-]
    INTEGER(IntKi)  :: MmbrCoefIDIndx = 0_IntKi      !< If MCoefMod=3, then this is the index for the member's coefs in the master Member Coefs Table [-]
    INTEGER(IntKi)  :: MmbrFilledIDIndx = 0_IntKi      !< If this member is part of a fill group, this is the index into the master fill group table, if not = -1 [-]
    INTEGER(IntKi)  :: MHstLMod = 0_IntKi      !< Hydrostatic model for member [1=column-type, 2=ship-type] [-]
    REAL(ReKi)  :: FillFSLoc = 0.0_ReKi      !< Z-location of the filled free-surface [m]
    REAL(ReKi)  :: FillDens = 0.0_ReKi      !< Filled fluid density [kg/m^3]
    LOGICAL  :: PropPot = .false.      !< Is this element/member modeled with potential flow theory T/F [-]
    LOGICAL  :: PropMCF = .false.      !< Flag T/F for whether the member is modeled with the MacCamy-Fuchs diffraction model [-]
    LOGICAL  :: Flipped = .false.      !< Was the member flipped in a reordering event?  Need to know this to get the correct normal vector to the ends [-]
  END TYPE Morison_MemberType
! =======================
! =========  Morison_MemberLoads  =======
  TYPE, PUBLIC :: Morison_MemberLoads
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_D      !< Member-based (side-effects) Nodal viscous drag loads at time t [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_I      !< Member-based (side-effects) Nodal inertial loads at time t [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_A      !< Member-based (side-effects) Nodal added mass loads at time t [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_B      !< Member-based (side-effects) Nodal buoyancy loads [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_BF      !< Member-based (side-effects) Nodal flooded ballast weight/buoyancy loads [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_If      !< Member-based (side-effects) Nodal flooded ballast inertia loads [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_WMG      !< Member-based (side-effects) Nodal marine growth weight loads [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_IMG      !< Member-based (side-effects) Nodal marine growth inertia loads [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: FV      !< Fluid velocity at line element node at time t, which may not correspond to the WaveTime array of times [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: FA      !< Fluid acceleration at line element node at time t, which may not correspond to the WaveTime array of times [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_DP      !< Lumped dynamic pressure loads at time t, which may not correspond to the WaveTime array of times [-]
  END TYPE Morison_MemberLoads
! =======================
! =========  Morison_CoefMembersCyl  =======
  TYPE, PUBLIC :: Morison_CoefMembersCyl
    INTEGER(IntKi)  :: MemberID = 0_IntKi      !< User-specified integer id for the Member-based coefs [-]
    REAL(ReKi)  :: MemberCd1 = 0.0_ReKi      !< Cylindrical member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCd2 = 0.0_ReKi      !< Cylindrical member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCdMG1 = 0.0_ReKi      !< Cylindrical member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCdMG2 = 0.0_ReKi      !< Cylindrical member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCa1 = 0.0_ReKi      !< Cylindrical member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCa2 = 0.0_ReKi      !< Cylindrical member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCaMG1 = 0.0_ReKi      !< Cylindrical member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCaMG2 = 0.0_ReKi      !< Cylindrical member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCp1 = 0.0_ReKi      !< Cylindrical member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCp2 = 0.0_ReKi      !< Cylindrical member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCpMG1 = 0.0_ReKi      !< Cylindrical member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCpMG2 = 0.0_ReKi      !< Cylindrical member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberAxCd1 = 0.0_ReKi      !< Cylindrical member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberAxCd2 = 0.0_ReKi      !< Cylindrical member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberAxCdMG1 = 0.0_ReKi      !< Cylindrical member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberAxCdMG2 = 0.0_ReKi      !< Cylindrical member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberAxCa1 = 0.0_ReKi      !< Cylindrical member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberAxCa2 = 0.0_ReKi      !< Cylindrical member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberAxCaMG1 = 0.0_ReKi      !< Cylindrical member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberAxCaMG2 = 0.0_ReKi      !< Cylindrical member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberAxCp1 = 0.0_ReKi      !< Cylindrical member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberAxCp2 = 0.0_ReKi      !< Cylindrical member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberAxCpMG1 = 0.0_ReKi      !< Cylindrical member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberAxCpMG2 = 0.0_ReKi      !< Cylindrical member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCb1 = 0.0_ReKi      !< Cylindrical member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCb2 = 0.0_ReKi      !< Cylindrical member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCbMG1 = 0.0_ReKi      !< Cylindrical member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCbMG2 = 0.0_ReKi      !< Cylindrical member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    LOGICAL  :: MemberMCF = .false.      !< Flag T/F for whether the cylindrical member is modeled with the MacCamy-Fuchs diffraction model [-]
  END TYPE Morison_CoefMembersCyl
! =======================
! =========  Morison_CoefMembersRec  =======
  TYPE, PUBLIC :: Morison_CoefMembersRec
    INTEGER(IntKi)  :: MemberID = 0_IntKi      !< User-specified integer id for the Member-based coefs [-]
    REAL(ReKi)  :: MemberCdA1 = 0.0_ReKi      !< Rectangular member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCdA2 = 0.0_ReKi      !< Rectangular member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCdAMG1 = 0.0_ReKi      !< Rectangular member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCdAMG2 = 0.0_ReKi      !< Rectangular member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCdB1 = 0.0_ReKi      !< Rectangular member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCdB2 = 0.0_ReKi      !< Rectangular member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCdBMG1 = 0.0_ReKi      !< Rectangular member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCdBMG2 = 0.0_ReKi      !< Rectangular member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCaA1 = 0.0_ReKi      !< Rectangular member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCaA2 = 0.0_ReKi      !< Rectangular member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCaAMG1 = 0.0_ReKi      !< Rectangular member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCaAMG2 = 0.0_ReKi      !< Rectangular member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCaB1 = 0.0_ReKi      !< Rectangular member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCaB2 = 0.0_ReKi      !< Rectangular member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCaBMG1 = 0.0_ReKi      !< Rectangular member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCaBMG2 = 0.0_ReKi      !< Rectangular member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCp1 = 0.0_ReKi      !< Rectangular member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCp2 = 0.0_ReKi      !< Rectangular member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCpMG1 = 0.0_ReKi      !< Rectangular member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCpMG2 = 0.0_ReKi      !< Rectangular member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberAxCd1 = 0.0_ReKi      !< Rectangular member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberAxCd2 = 0.0_ReKi      !< Rectangular member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberAxCdMG1 = 0.0_ReKi      !< Rectangular member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberAxCdMG2 = 0.0_ReKi      !< Rectangular member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberAxCa1 = 0.0_ReKi      !< Rectangular member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberAxCa2 = 0.0_ReKi      !< Rectangular member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberAxCaMG1 = 0.0_ReKi      !< Rectangular member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberAxCaMG2 = 0.0_ReKi      !< Rectangular member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberAxCp1 = 0.0_ReKi      !< Rectangular member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberAxCp2 = 0.0_ReKi      !< Rectangular member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberAxCpMG1 = 0.0_ReKi      !< Rectangular member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberAxCpMG2 = 0.0_ReKi      !< Rectangular member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCb1 = 0.0_ReKi      !< Rectangular member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCb2 = 0.0_ReKi      !< Rectangular member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCbMG1 = 0.0_ReKi      !< Rectangular member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCbMG2 = 0.0_ReKi      !< Rectangular member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    LOGICAL  :: MemberMCF = .false.      !< Flag T/F for whether the rectangular member is modeled with the MacCamy-Fuchs diffraction model [-]
  END TYPE Morison_CoefMembersRec
! =======================
! =========  Morison_MGDepthsType  =======
  TYPE, PUBLIC :: Morison_MGDepthsType
    REAL(ReKi)  :: MGDpth = 0.0_ReKi      !< Marine growth depth location for these properties [m]
    REAL(ReKi)  :: MGThck = 0.0_ReKi      !< Marine growth thickness [m]
    REAL(ReKi)  :: MGDens = 0.0_ReKi      !< Marine growth density [kg/m^3]
  END TYPE Morison_MGDepthsType
! =======================
! =========  Morison_MOutput  =======
  TYPE, PUBLIC :: Morison_MOutput
    INTEGER(IntKi)  :: MemberID = 0_IntKi      !< Member ID for requested output [-]
    INTEGER(IntKi)  :: NOutLoc = 0_IntKi      !< The number of requested output locations [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: NodeLocs      !< Normalized locations along user-specified member for the outputs [-]
    INTEGER(IntKi)  :: MemberIDIndx = 0_IntKi      !< Index for member in the master list [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: MeshIndx1      !< Index of node in Mesh for the start of the member element [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: MeshIndx2      !< Index of node in Mesh for the end of the member element [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: MemberIndx1      !< Index of Member nodes for the start of the member element [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: MemberIndx2      !< Index of Member nodes for the end of the member element [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: s      !< Linear interpolation factor between node1 and node2 for the output location [-]
  END TYPE Morison_MOutput
! =======================
! =========  Morison_JOutput  =======
  TYPE, PUBLIC :: Morison_JOutput
    INTEGER(IntKi)  :: JointID = 0_IntKi      !< Joint ID for the requested output [-]
    INTEGER(IntKi)  :: JointIDIndx = 0_IntKi      !< Joint index in the master list [-]
  END TYPE Morison_JOutput
! =======================
! =========  Morison_InitInputType  =======
  TYPE, PUBLIC :: Morison_InitInputType
    REAL(ReKi)  :: Gravity = 0.0_ReKi      !< Gravity (scalar, positive-valued) [m/s^2]
    INTEGER(IntKi)  :: WaveDisp = 0_IntKi      !< Method of computing Wave Kinematics. (0: use undisplaced position, 1: use displaced position, 2: use low-pass filtered displaced position)  [-]
    INTEGER(IntKi)  :: AMMod = 0_IntKi      !< Method of computing distributed added-mass force. (0: Only and always on nodes below SWL at the undisplaced position. 1: Up to the instantaneous free surface) [overwrite to 0 when WaveMod = 0 or 6 or when WaveStMod = 0 in SeaState] [-]
    INTEGER(IntKi)  :: NJoints = 0_IntKi      !< Number of user-specified joints [-]
    INTEGER(IntKi)  :: NNodes = 0_IntKi      !< Total number of nodes in the final software model [-]
    TYPE(Morison_JointType) , DIMENSION(:), ALLOCATABLE  :: InpJoints      !< Array of user-specified joints [-]
    TYPE(Morison_NodeType) , DIMENSION(:), ALLOCATABLE  :: Nodes      !< Array of simulation node (some correspond to user-specified joints, others are created by software) [-]
    INTEGER(IntKi)  :: NAxCoefs = 0_IntKi      !< Number of axial Coefs entries in input file table [-]
    TYPE(Morison_AxialCoefType) , DIMENSION(:), ALLOCATABLE  :: AxialCoefs      !< List of axial coefs [-]
    INTEGER(IntKi)  :: NPropSetsCyl = 0_IntKi      !< Number of cylindrical member property sets [-]
    TYPE(Morison_MemberPropTypeCyl) , DIMENSION(:), ALLOCATABLE  :: MPropSetsCyl      !< List of cylindrical member property sets [-]
    INTEGER(IntKi)  :: NPropSetsRec = 0_IntKi      !< Number of rectangular member property sets [-]
    TYPE(Morison_MemberPropTypeRec) , DIMENSION(:), ALLOCATABLE  :: MPropSetsRec      !< List of rectangular member property sets [-]
    REAL(ReKi)  :: SimplCd = 0.0_ReKi      !< Simple model drag coef for cylindrical members [-]
    REAL(ReKi)  :: SimplCdMG = 0.0_ReKi      !< Simple model drag coef for cylindrical members with marine growth [-]
    REAL(ReKi)  :: SimplCa = 0.0_ReKi      !< Simple model Ca for cylindrical members [-]
    REAL(ReKi)  :: SimplCaMG = 0.0_ReKi      !< Simple model Ca for cylindrical members with marine growth [-]
    REAL(ReKi)  :: SimplCp = 0.0_ReKi      !< Simple model Cp for cylindrical members [-]
    REAL(ReKi)  :: SimplCpMG = 0.0_ReKi      !< Simple model Cp for cylindrical members with marine growth [-]
    REAL(ReKi)  :: SimplAxCd = 0.0_ReKi      !< Simple model Axial Cd for cylindrical members [-]
    REAL(ReKi)  :: SimplAxCdMG = 0.0_ReKi      !< Simple model Axial Cd for cylindrical members with marine growth [-]
    REAL(ReKi)  :: SimplAxCa = 0.0_ReKi      !< Simple model Axial Ca for cylindrical members [-]
    REAL(ReKi)  :: SimplAxCaMG = 0.0_ReKi      !< Simple model Axial Ca for cylindrical members with marine growth [-]
    REAL(ReKi)  :: SimplAxCp = 0.0_ReKi      !< Simple model Axial Cp for cylindrical members [-]
    REAL(ReKi)  :: SimplAxCpMG = 0.0_ReKi      !< Simple model Axial Cp for cylindrical members with marine growth [-]
    REAL(ReKi)  :: SimplCb = 0.0_ReKi      !< Simple model hydrostatic/buoyancy load coefficient for cylindrical members [-]
    REAL(ReKi)  :: SimplCbMg = 0.0_ReKi      !< Simple model hydrostatic/buoyancy load coefficient for cylindrical members with marine growth [-]
    LOGICAL  :: SimplMCF = .false.      !< Flag T/F for whether the cylindrical member is modeled with the MacCamy-Fuchs diffraction model [-]
    REAL(ReKi)  :: SimplRecCdA = 0.0_ReKi      !< Simple model drag coef for rectangular members normal to side A [-]
    REAL(ReKi)  :: SimplRecCdAMG = 0.0_ReKi      !< Simple model drag coef for rectangular members normal to side A with marine growth [-]
    REAL(ReKi)  :: SimplRecCdB = 0.0_ReKi      !< Simple model drag coef for rectangular members normal to side B [-]
    REAL(ReKi)  :: SimplRecCdBMG = 0.0_ReKi      !< Simple model drag coef for rectangular members normal to side B with marine growth [-]
    REAL(ReKi)  :: SimplRecCaA = 0.0_ReKi      !< Simple model Ca for rectangular members normal to side A [-]
    REAL(ReKi)  :: SimplRecCaAMG = 0.0_ReKi      !< Simple model Ca for rectangular members normal to side A with marine growth [-]
    REAL(ReKi)  :: SimplRecCaB = 0.0_ReKi      !< Simple model Ca for rectangular members normal to side B [-]
    REAL(ReKi)  :: SimplRecCaBMG = 0.0_ReKi      !< Simple model Ca for rectangular members normal to side B with marine growth [-]
    REAL(ReKi)  :: SimplRecCp = 0.0_ReKi      !< Simple model Cp for rectangular members [-]
    REAL(ReKi)  :: SimplRecCpMG = 0.0_ReKi      !< Simple model Cp for rectangular members with marine growth [-]
    REAL(ReKi)  :: SimplRecAxCd = 0.0_ReKi      !< Simple model Axial Cd for rectangular members [-]
    REAL(ReKi)  :: SimplRecAxCdMG = 0.0_ReKi      !< Simple model Axial Cd for rectangular members with marine growth [-]
    REAL(ReKi)  :: SimplRecAxCa = 0.0_ReKi      !< Simple model Axial Ca for rectangular members [-]
    REAL(ReKi)  :: SimplRecAxCaMG = 0.0_ReKi      !< Simple model Axial Ca for rectangular members with marine growth [-]
    REAL(ReKi)  :: SimplRecAxCp = 0.0_ReKi      !< Simple model Axial Cp for rectangular members [-]
    REAL(ReKi)  :: SimplRecAxCpMG = 0.0_ReKi      !< Simple model Axial Cp for rectangular members with marine growth [-]
    REAL(ReKi)  :: SimplRecCb = 0.0_ReKi      !< Simple model hydrostatic/buoyancy load coefficient for rectangular members [-]
    REAL(ReKi)  :: SimplRecCbMg = 0.0_ReKi      !< Simple model hydrostatic/buoyancy load coefficient for rectangular members with marine growth [-]
    LOGICAL  :: SimplRecMCF = .false.      !< Flag T/F for whether the rectangular member is modeled with the MacCamy-Fuchs diffraction model [-]
    INTEGER(IntKi)  :: NCoefDpthCyl = 0_IntKi      !<  [-]
    TYPE(Morison_CoefDpthsCyl) , DIMENSION(:), ALLOCATABLE  :: CoefDpthsCyl      !<  [-]
    INTEGER(IntKi)  :: NCoefDpthRec = 0_IntKi      !<  [-]
    TYPE(Morison_CoefDpthsRec) , DIMENSION(:), ALLOCATABLE  :: CoefDpthsRec      !<  [-]
    INTEGER(IntKi)  :: NCoefMembersCyl = 0_IntKi      !<  [-]
    TYPE(Morison_CoefMembersCyl) , DIMENSION(:), ALLOCATABLE  :: CoefMembersCyl      !<  [-]
    INTEGER(IntKi)  :: NCoefMembersRec = 0_IntKi      !<  [-]
    TYPE(Morison_CoefMembersRec) , DIMENSION(:), ALLOCATABLE  :: CoefMembersRec      !<  [-]
    INTEGER(IntKi)  :: NMembers = 0_IntKi      !< Number of user-specified members in the input file [-]
    TYPE(Morison_MemberInputType) , DIMENSION(:), ALLOCATABLE  :: InpMembers      !< Array of user-specified members [-]
    INTEGER(IntKi)  :: NFillGroups = 0_IntKi      !<  [-]
    TYPE(Morison_FilledGroupType) , DIMENSION(:), ALLOCATABLE  :: FilledGroups      !<  [-]
    INTEGER(IntKi)  :: NMGDepths = 0_IntKi      !<  [-]
    TYPE(Morison_MGDepthsType) , DIMENSION(:), ALLOCATABLE  :: MGDepths      !<  [-]
    REAL(ReKi)  :: MGTop = 0.0_ReKi      !<  [-]
    REAL(ReKi)  :: MGBottom = 0.0_ReKi      !<  [-]
    INTEGER(IntKi)  :: NMOutputs = 0_IntKi      !<  [-]
    TYPE(Morison_MOutput) , DIMENSION(:), ALLOCATABLE  :: MOutLst      !<  [-]
    INTEGER(IntKi)  :: NJOutputs = 0_IntKi      !<  [-]
    TYPE(Morison_JOutput) , DIMENSION(:), ALLOCATABLE  :: JOutLst      !<  [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: OutList      !< This list size needs to be the maximum # of possible outputs because of the use of ReadAry(). Use MaxMrsnOutputs [-]
    INTEGER(IntKi)  :: NumOuts = 0_IntKi      !<  [-]
    INTEGER(IntKi)  :: UnSum = 0_IntKi      !<  [-]
    TYPE(SeaSt_WaveFieldType) , POINTER :: WaveField => NULL()      !< Pointer to SeaState wave field [-]
    LOGICAL  :: VisMeshes = .false.      !< Output visualization meshes [-]
    INTEGER(IntKi)  :: PtfmYMod = 0_IntKi      !< Large yaw model [-]
  END TYPE Morison_InitInputType
! =======================
! =========  Morison_InitOutputType  =======
  TYPE, PUBLIC :: Morison_InitOutputType
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: MorisonVisRad      !< radius of node (for FAST visualization) [(m)]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputHdr      !< User-requested Output channel names [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputUnt      !<  [-]
  END TYPE Morison_InitOutputType
! =======================
! =========  Morison_ContinuousStateType  =======
  TYPE, PUBLIC :: Morison_ContinuousStateType
    REAL(SiKi)  :: DummyContState = 0.0_R4Ki      !< Remove this variable if you have continuous states [-]
  END TYPE Morison_ContinuousStateType
! =======================
! =========  Morison_DiscreteStateType  =======
  TYPE, PUBLIC :: Morison_DiscreteStateType
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: V_rel_n_FiltStat      !< State of the high-pass filter for the joint relative normal velocity [m/s]
  END TYPE Morison_DiscreteStateType
! =======================
! =========  Morison_ConstraintStateType  =======
  TYPE, PUBLIC :: Morison_ConstraintStateType
    REAL(SiKi)  :: DummyConstrState = 0.0_R4Ki      !< Remove this variable if you have constraint states [-]
  END TYPE Morison_ConstraintStateType
! =======================
! =========  Morison_OtherStateType  =======
  TYPE, PUBLIC :: Morison_OtherStateType
    INTEGER(IntKi)  :: DummyOtherState = 0_IntKi      !< Remove this variable if you have other states [-]
  END TYPE Morison_OtherStateType
! =======================
! =========  Morison_MiscVarType  =======
  TYPE, PUBLIC :: Morison_MiscVarType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: DispNodePosHdn      !< Instantaneous displaced position of the line element nodes at time t for hydrodynamic load calculation [(m)]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: DispNodePosHst      !< Instantaneous displaced position of the line element nodes at time t for hydrostatic and other load calcuation [(m)]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: FV      !< Fluid velocity at line element node at time t, which may not correspond to the WaveTime array of times [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: FA      !< Fluid acceleration at line element node at time t, which may not correspond to the WaveTime array of times [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: FAMCF      !< Fluid acceleration at line element node at time t, which may not correspond to the WaveTime array of times [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: FDynP      !< Fluid dynamic pressure at line element node at time t, which may not correspond to the WaveTime array of times [-]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: WaveElev      !< Total wave elevation [m]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: WaveElev1      !< First order wave elevation [m]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: WaveElev2      !< Second order wave elevation [m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: vrel      !< velocity of structural node relative to the water [m/s^2]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: nodeInWater      !< Logical flag indicating if the node at the given time step is in the water, and hence needs to have hydrodynamic forces calculated [-]
    TYPE(Morison_MemberLoads) , DIMENSION(:), ALLOCATABLE  :: memberLoads      !< Array (NMembers long) of member-based side-effects load contributions [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_B_End      !<  [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_D_End      !< Lumped viscous drag loads at time t, which may not correspond to the WaveTime array of times [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_I_End      !< Lumped intertia loads at time t, which may not correspond to the WaveTime array of times [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_IMG_End      !< Joint marine growth intertia loads at time t, which may not correspond to the WaveTime array of times [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_A_End      !< Lumped added mass loads at time t, which may not correspond to the WaveTime array of times [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_BF_End      !<  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: V_rel_n      !< Normal relative flow velocity at joints [m/s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: V_rel_n_HiPass      !< High-pass filtered normal relative flow velocity at joints [m/s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: zFillGroup      !< Instantaneous highest point of each filled group [m]
    TYPE(MeshMapType)  :: VisMeshMap      !< Mesh mapping for visualization mesh [-]
    TYPE(SeaSt_WaveField_MiscVarType)  :: WaveField_m      !< misc var information from the SeaState Interpolation module [-]
  END TYPE Morison_MiscVarType
! =======================
! =========  Morison_ParameterType  =======
  TYPE, PUBLIC :: Morison_ParameterType
    REAL(DbKi)  :: DT = 0.0_R8Ki      !< Time step for continuous state integration & discrete state update [(sec)]
    REAL(ReKi)  :: Gravity = 0.0_ReKi      !< Gravity (scalar, positive-valued) [m/s^2]
    INTEGER(IntKi)  :: WaveDisp = 0_IntKi      !< Method of computing Wave Kinematics. (0: use undisplaced position, 1: use displaced position, 2: use low-pass filtered displaced position)  [-]
    INTEGER(IntKi)  :: AMMod = 0_IntKi      !< Method of computing distributed added-mass force. (0: Only and always on nodes below SWL at the undisplaced position. 1: Up to the instantaneous free surface) [overwrite to 0 when WaveMod = 0 or 6 or when WaveStMod = 0 in SeaState] [-]
    INTEGER(IntKi)  :: NMembers = 0_IntKi      !< number of members [-]
    TYPE(Morison_MemberType) , DIMENSION(:), ALLOCATABLE  :: Members      !< Array of Morison members used during simulation [-]
    INTEGER(IntKi)  :: NNodes = 0_IntKi      !<  [-]
    INTEGER(IntKi)  :: NJoints = 0_IntKi      !< Number of user-specified joints [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: I_MG_End      !< Inertial matrix associated with marine growth mass at joint [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: An_End      !< directional area vector of each joint [m^2]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: DragConst_End      !<  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: VRelNFiltConst      !<  [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: DragMod_End      !<  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: DragLoFSc_End      !<  [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_WMG_End      !< Joint marine growth weight loads, constant for all t [N]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: DP_Const_End      !< Constant part of Joint dynamic pressure term [N]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Mass_MG_End      !< Joint marine growth mass [kg]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: AM_End      !< 3x3 Joint added mass matrix, constant for all t [N]
    INTEGER(IntKi)  :: NMOutputs = 0_IntKi      !<  [-]
    TYPE(Morison_MOutput) , DIMENSION(:), ALLOCATABLE  :: MOutLst      !<  [-]
    INTEGER(IntKi)  :: NJOutputs = 0_IntKi      !<  [-]
    TYPE(Morison_JOutput) , DIMENSION(:), ALLOCATABLE  :: JOutLst      !<  [-]
    TYPE(OutParmType) , DIMENSION(:), ALLOCATABLE  :: OutParam      !<  [-]
    INTEGER(IntKi)  :: NumOuts = 0_IntKi      !<  [-]
    TYPE(SeaSt_WaveFieldType) , POINTER :: WaveField => NULL()      !< SeaState wave field [-]
    LOGICAL  :: VisMeshes = .false.      !< Output visualization meshes [-]
    INTEGER(IntKi)  :: PtfmYMod = 0_IntKi      !< Large yaw model [-]
    INTEGER(IntKi)  :: NFillGroups = 0_IntKi      !<  [-]
    TYPE(Morison_FilledGroupType) , DIMENSION(:), ALLOCATABLE  :: FilledGroups      !<  [-]
  END TYPE Morison_ParameterType
! =======================
! =========  Morison_InputType  =======
  TYPE, PUBLIC :: Morison_InputType
    TYPE(MeshType)  :: Mesh      !< Kinematics of each node input mesh [-]
    REAL(ReKi)  :: PtfmRefY = 0.0_ReKi      !< Reference platform yaw offset [(rad)]
  END TYPE Morison_InputType
! =======================
! =========  Morison_OutputType  =======
  TYPE, PUBLIC :: Morison_OutputType
    TYPE(MeshType)  :: Mesh      !< Loads on each node output mesh [-]
    TYPE(MeshType)  :: VisMesh      !< Line mesh for visualization [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WriteOutput      !<  [-]
  END TYPE Morison_OutputType
! =======================
CONTAINS

subroutine Morison_CopyJointType(SrcJointTypeData, DstJointTypeData, CtrlCode, ErrStat, ErrMsg)
   type(Morison_JointType), intent(in) :: SrcJointTypeData
   type(Morison_JointType), intent(inout) :: DstJointTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Morison_CopyJointType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstJointTypeData%JointID = SrcJointTypeData%JointID
   DstJointTypeData%Position = SrcJointTypeData%Position
   DstJointTypeData%JointAxID = SrcJointTypeData%JointAxID
   DstJointTypeData%JointAxIDIndx = SrcJointTypeData%JointAxIDIndx
   DstJointTypeData%JointOvrlp = SrcJointTypeData%JointOvrlp
   DstJointTypeData%NConnections = SrcJointTypeData%NConnections
   DstJointTypeData%ConnectionList = SrcJointTypeData%ConnectionList
end subroutine

subroutine Morison_DestroyJointType(JointTypeData, ErrStat, ErrMsg)
   type(Morison_JointType), intent(inout) :: JointTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Morison_DestroyJointType'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine Morison_PackJointType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Morison_JointType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Morison_PackJointType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%JointID)
   call RegPack(RF, InData%Position)
   call RegPack(RF, InData%JointAxID)
   call RegPack(RF, InData%JointAxIDIndx)
   call RegPack(RF, InData%JointOvrlp)
   call RegPack(RF, InData%NConnections)
   call RegPack(RF, InData%ConnectionList)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_UnPackJointType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Morison_JointType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Morison_UnPackJointType'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%JointID); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Position); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%JointAxID); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%JointAxIDIndx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%JointOvrlp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NConnections); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ConnectionList); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_CopyMemberPropTypeCyl(SrcMemberPropTypeCylData, DstMemberPropTypeCylData, CtrlCode, ErrStat, ErrMsg)
   type(Morison_MemberPropTypeCyl), intent(in) :: SrcMemberPropTypeCylData
   type(Morison_MemberPropTypeCyl), intent(inout) :: DstMemberPropTypeCylData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Morison_CopyMemberPropTypeCyl'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstMemberPropTypeCylData%PropSetID = SrcMemberPropTypeCylData%PropSetID
   DstMemberPropTypeCylData%PropD = SrcMemberPropTypeCylData%PropD
   DstMemberPropTypeCylData%PropThck = SrcMemberPropTypeCylData%PropThck
end subroutine

subroutine Morison_DestroyMemberPropTypeCyl(MemberPropTypeCylData, ErrStat, ErrMsg)
   type(Morison_MemberPropTypeCyl), intent(inout) :: MemberPropTypeCylData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Morison_DestroyMemberPropTypeCyl'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine Morison_PackMemberPropTypeCyl(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Morison_MemberPropTypeCyl), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Morison_PackMemberPropTypeCyl'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%PropSetID)
   call RegPack(RF, InData%PropD)
   call RegPack(RF, InData%PropThck)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_UnPackMemberPropTypeCyl(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Morison_MemberPropTypeCyl), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Morison_UnPackMemberPropTypeCyl'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%PropSetID); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PropD); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PropThck); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_CopyMemberPropTypeRec(SrcMemberPropTypeRecData, DstMemberPropTypeRecData, CtrlCode, ErrStat, ErrMsg)
   type(Morison_MemberPropTypeRec), intent(in) :: SrcMemberPropTypeRecData
   type(Morison_MemberPropTypeRec), intent(inout) :: DstMemberPropTypeRecData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Morison_CopyMemberPropTypeRec'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstMemberPropTypeRecData%PropSetID = SrcMemberPropTypeRecData%PropSetID
   DstMemberPropTypeRecData%PropA = SrcMemberPropTypeRecData%PropA
   DstMemberPropTypeRecData%PropB = SrcMemberPropTypeRecData%PropB
   DstMemberPropTypeRecData%PropThck = SrcMemberPropTypeRecData%PropThck
end subroutine

subroutine Morison_DestroyMemberPropTypeRec(MemberPropTypeRecData, ErrStat, ErrMsg)
   type(Morison_MemberPropTypeRec), intent(inout) :: MemberPropTypeRecData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Morison_DestroyMemberPropTypeRec'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine Morison_PackMemberPropTypeRec(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Morison_MemberPropTypeRec), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Morison_PackMemberPropTypeRec'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%PropSetID)
   call RegPack(RF, InData%PropA)
   call RegPack(RF, InData%PropB)
   call RegPack(RF, InData%PropThck)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_UnPackMemberPropTypeRec(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Morison_MemberPropTypeRec), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Morison_UnPackMemberPropTypeRec'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%PropSetID); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PropA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PropB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PropThck); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_CopyFilledGroupType(SrcFilledGroupTypeData, DstFilledGroupTypeData, CtrlCode, ErrStat, ErrMsg)
   type(Morison_FilledGroupType), intent(in) :: SrcFilledGroupTypeData
   type(Morison_FilledGroupType), intent(inout) :: DstFilledGroupTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'Morison_CopyFilledGroupType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstFilledGroupTypeData%FillNumM = SrcFilledGroupTypeData%FillNumM
   if (allocated(SrcFilledGroupTypeData%FillMList)) then
      LB(1:1) = lbound(SrcFilledGroupTypeData%FillMList)
      UB(1:1) = ubound(SrcFilledGroupTypeData%FillMList)
      if (.not. allocated(DstFilledGroupTypeData%FillMList)) then
         allocate(DstFilledGroupTypeData%FillMList(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstFilledGroupTypeData%FillMList.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstFilledGroupTypeData%FillMList = SrcFilledGroupTypeData%FillMList
   end if
   DstFilledGroupTypeData%FillFSLoc = SrcFilledGroupTypeData%FillFSLoc
   DstFilledGroupTypeData%FillDensChr = SrcFilledGroupTypeData%FillDensChr
   DstFilledGroupTypeData%FillDens = SrcFilledGroupTypeData%FillDens
   DstFilledGroupTypeData%IsOpen = SrcFilledGroupTypeData%IsOpen
end subroutine

subroutine Morison_DestroyFilledGroupType(FilledGroupTypeData, ErrStat, ErrMsg)
   type(Morison_FilledGroupType), intent(inout) :: FilledGroupTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Morison_DestroyFilledGroupType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(FilledGroupTypeData%FillMList)) then
      deallocate(FilledGroupTypeData%FillMList)
   end if
end subroutine

subroutine Morison_PackFilledGroupType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Morison_FilledGroupType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Morison_PackFilledGroupType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%FillNumM)
   call RegPackAlloc(RF, InData%FillMList)
   call RegPack(RF, InData%FillFSLoc)
   call RegPack(RF, InData%FillDensChr)
   call RegPack(RF, InData%FillDens)
   call RegPack(RF, InData%IsOpen)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_UnPackFilledGroupType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Morison_FilledGroupType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Morison_UnPackFilledGroupType'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%FillNumM); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%FillMList); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FillFSLoc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FillDensChr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FillDens); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%IsOpen); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_CopyCoefDpthsCyl(SrcCoefDpthsCylData, DstCoefDpthsCylData, CtrlCode, ErrStat, ErrMsg)
   type(Morison_CoefDpthsCyl), intent(in) :: SrcCoefDpthsCylData
   type(Morison_CoefDpthsCyl), intent(inout) :: DstCoefDpthsCylData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Morison_CopyCoefDpthsCyl'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstCoefDpthsCylData%Dpth = SrcCoefDpthsCylData%Dpth
   DstCoefDpthsCylData%DpthCd = SrcCoefDpthsCylData%DpthCd
   DstCoefDpthsCylData%DpthCdMG = SrcCoefDpthsCylData%DpthCdMG
   DstCoefDpthsCylData%DpthCa = SrcCoefDpthsCylData%DpthCa
   DstCoefDpthsCylData%DpthCaMG = SrcCoefDpthsCylData%DpthCaMG
   DstCoefDpthsCylData%DpthCp = SrcCoefDpthsCylData%DpthCp
   DstCoefDpthsCylData%DpthCpMG = SrcCoefDpthsCylData%DpthCpMG
   DstCoefDpthsCylData%DpthAxCd = SrcCoefDpthsCylData%DpthAxCd
   DstCoefDpthsCylData%DpthAxCdMG = SrcCoefDpthsCylData%DpthAxCdMG
   DstCoefDpthsCylData%DpthAxCa = SrcCoefDpthsCylData%DpthAxCa
   DstCoefDpthsCylData%DpthAxCaMG = SrcCoefDpthsCylData%DpthAxCaMG
   DstCoefDpthsCylData%DpthAxCp = SrcCoefDpthsCylData%DpthAxCp
   DstCoefDpthsCylData%DpthAxCpMG = SrcCoefDpthsCylData%DpthAxCpMG
   DstCoefDpthsCylData%DpthCb = SrcCoefDpthsCylData%DpthCb
   DstCoefDpthsCylData%DpthCbMg = SrcCoefDpthsCylData%DpthCbMg
   DstCoefDpthsCylData%DpthMCF = SrcCoefDpthsCylData%DpthMCF
end subroutine

subroutine Morison_DestroyCoefDpthsCyl(CoefDpthsCylData, ErrStat, ErrMsg)
   type(Morison_CoefDpthsCyl), intent(inout) :: CoefDpthsCylData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Morison_DestroyCoefDpthsCyl'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine Morison_PackCoefDpthsCyl(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Morison_CoefDpthsCyl), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Morison_PackCoefDpthsCyl'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%Dpth)
   call RegPack(RF, InData%DpthCd)
   call RegPack(RF, InData%DpthCdMG)
   call RegPack(RF, InData%DpthCa)
   call RegPack(RF, InData%DpthCaMG)
   call RegPack(RF, InData%DpthCp)
   call RegPack(RF, InData%DpthCpMG)
   call RegPack(RF, InData%DpthAxCd)
   call RegPack(RF, InData%DpthAxCdMG)
   call RegPack(RF, InData%DpthAxCa)
   call RegPack(RF, InData%DpthAxCaMG)
   call RegPack(RF, InData%DpthAxCp)
   call RegPack(RF, InData%DpthAxCpMG)
   call RegPack(RF, InData%DpthCb)
   call RegPack(RF, InData%DpthCbMg)
   call RegPack(RF, InData%DpthMCF)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_UnPackCoefDpthsCyl(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Morison_CoefDpthsCyl), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Morison_UnPackCoefDpthsCyl'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%Dpth); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DpthCd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DpthCdMG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DpthCa); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DpthCaMG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DpthCp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DpthCpMG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DpthAxCd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DpthAxCdMG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DpthAxCa); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DpthAxCaMG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DpthAxCp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DpthAxCpMG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DpthCb); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DpthCbMg); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DpthMCF); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_CopyCoefDpthsRec(SrcCoefDpthsRecData, DstCoefDpthsRecData, CtrlCode, ErrStat, ErrMsg)
   type(Morison_CoefDpthsRec), intent(in) :: SrcCoefDpthsRecData
   type(Morison_CoefDpthsRec), intent(inout) :: DstCoefDpthsRecData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Morison_CopyCoefDpthsRec'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstCoefDpthsRecData%Dpth = SrcCoefDpthsRecData%Dpth
   DstCoefDpthsRecData%DpthCdA = SrcCoefDpthsRecData%DpthCdA
   DstCoefDpthsRecData%DpthCdAMG = SrcCoefDpthsRecData%DpthCdAMG
   DstCoefDpthsRecData%DpthCdB = SrcCoefDpthsRecData%DpthCdB
   DstCoefDpthsRecData%DpthCdBMG = SrcCoefDpthsRecData%DpthCdBMG
   DstCoefDpthsRecData%DpthCaA = SrcCoefDpthsRecData%DpthCaA
   DstCoefDpthsRecData%DpthCaAMG = SrcCoefDpthsRecData%DpthCaAMG
   DstCoefDpthsRecData%DpthCaB = SrcCoefDpthsRecData%DpthCaB
   DstCoefDpthsRecData%DpthCaBMG = SrcCoefDpthsRecData%DpthCaBMG
   DstCoefDpthsRecData%DpthCp = SrcCoefDpthsRecData%DpthCp
   DstCoefDpthsRecData%DpthCpMG = SrcCoefDpthsRecData%DpthCpMG
   DstCoefDpthsRecData%DpthAxCd = SrcCoefDpthsRecData%DpthAxCd
   DstCoefDpthsRecData%DpthAxCdMG = SrcCoefDpthsRecData%DpthAxCdMG
   DstCoefDpthsRecData%DpthAxCa = SrcCoefDpthsRecData%DpthAxCa
   DstCoefDpthsRecData%DpthAxCaMG = SrcCoefDpthsRecData%DpthAxCaMG
   DstCoefDpthsRecData%DpthAxCp = SrcCoefDpthsRecData%DpthAxCp
   DstCoefDpthsRecData%DpthAxCpMG = SrcCoefDpthsRecData%DpthAxCpMG
   DstCoefDpthsRecData%DpthCb = SrcCoefDpthsRecData%DpthCb
   DstCoefDpthsRecData%DpthCbMg = SrcCoefDpthsRecData%DpthCbMg
   DstCoefDpthsRecData%DpthMCF = SrcCoefDpthsRecData%DpthMCF
end subroutine

subroutine Morison_DestroyCoefDpthsRec(CoefDpthsRecData, ErrStat, ErrMsg)
   type(Morison_CoefDpthsRec), intent(inout) :: CoefDpthsRecData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Morison_DestroyCoefDpthsRec'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine Morison_PackCoefDpthsRec(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Morison_CoefDpthsRec), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Morison_PackCoefDpthsRec'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%Dpth)
   call RegPack(RF, InData%DpthCdA)
   call RegPack(RF, InData%DpthCdAMG)
   call RegPack(RF, InData%DpthCdB)
   call RegPack(RF, InData%DpthCdBMG)
   call RegPack(RF, InData%DpthCaA)
   call RegPack(RF, InData%DpthCaAMG)
   call RegPack(RF, InData%DpthCaB)
   call RegPack(RF, InData%DpthCaBMG)
   call RegPack(RF, InData%DpthCp)
   call RegPack(RF, InData%DpthCpMG)
   call RegPack(RF, InData%DpthAxCd)
   call RegPack(RF, InData%DpthAxCdMG)
   call RegPack(RF, InData%DpthAxCa)
   call RegPack(RF, InData%DpthAxCaMG)
   call RegPack(RF, InData%DpthAxCp)
   call RegPack(RF, InData%DpthAxCpMG)
   call RegPack(RF, InData%DpthCb)
   call RegPack(RF, InData%DpthCbMg)
   call RegPack(RF, InData%DpthMCF)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_UnPackCoefDpthsRec(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Morison_CoefDpthsRec), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Morison_UnPackCoefDpthsRec'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%Dpth); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DpthCdA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DpthCdAMG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DpthCdB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DpthCdBMG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DpthCaA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DpthCaAMG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DpthCaB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DpthCaBMG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DpthCp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DpthCpMG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DpthAxCd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DpthAxCdMG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DpthAxCa); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DpthAxCaMG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DpthAxCp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DpthAxCpMG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DpthCb); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DpthCbMg); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DpthMCF); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_CopyAxialCoefType(SrcAxialCoefTypeData, DstAxialCoefTypeData, CtrlCode, ErrStat, ErrMsg)
   type(Morison_AxialCoefType), intent(in) :: SrcAxialCoefTypeData
   type(Morison_AxialCoefType), intent(inout) :: DstAxialCoefTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Morison_CopyAxialCoefType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstAxialCoefTypeData%AxCoefID = SrcAxialCoefTypeData%AxCoefID
   DstAxialCoefTypeData%AxCd = SrcAxialCoefTypeData%AxCd
   DstAxialCoefTypeData%AxCa = SrcAxialCoefTypeData%AxCa
   DstAxialCoefTypeData%AxCp = SrcAxialCoefTypeData%AxCp
   DstAxialCoefTypeData%AxVnCOff = SrcAxialCoefTypeData%AxVnCOff
   DstAxialCoefTypeData%AxFDLoFSc = SrcAxialCoefTypeData%AxFDLoFSc
   DstAxialCoefTypeData%AxFDMod = SrcAxialCoefTypeData%AxFDMod
end subroutine

subroutine Morison_DestroyAxialCoefType(AxialCoefTypeData, ErrStat, ErrMsg)
   type(Morison_AxialCoefType), intent(inout) :: AxialCoefTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Morison_DestroyAxialCoefType'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine Morison_PackAxialCoefType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Morison_AxialCoefType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Morison_PackAxialCoefType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%AxCoefID)
   call RegPack(RF, InData%AxCd)
   call RegPack(RF, InData%AxCa)
   call RegPack(RF, InData%AxCp)
   call RegPack(RF, InData%AxVnCOff)
   call RegPack(RF, InData%AxFDLoFSc)
   call RegPack(RF, InData%AxFDMod)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_UnPackAxialCoefType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Morison_AxialCoefType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Morison_UnPackAxialCoefType'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%AxCoefID); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AxCd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AxCa); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AxCp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AxVnCOff); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AxFDLoFSc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AxFDMod); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_CopyMemberInputType(SrcMemberInputTypeData, DstMemberInputTypeData, CtrlCode, ErrStat, ErrMsg)
   type(Morison_MemberInputType), intent(in) :: SrcMemberInputTypeData
   type(Morison_MemberInputType), intent(inout) :: DstMemberInputTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'Morison_CopyMemberInputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstMemberInputTypeData%MemberID = SrcMemberInputTypeData%MemberID
   if (allocated(SrcMemberInputTypeData%NodeIndx)) then
      LB(1:1) = lbound(SrcMemberInputTypeData%NodeIndx)
      UB(1:1) = ubound(SrcMemberInputTypeData%NodeIndx)
      if (.not. allocated(DstMemberInputTypeData%NodeIndx)) then
         allocate(DstMemberInputTypeData%NodeIndx(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberInputTypeData%NodeIndx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberInputTypeData%NodeIndx = SrcMemberInputTypeData%NodeIndx
   end if
   DstMemberInputTypeData%MJointID1 = SrcMemberInputTypeData%MJointID1
   DstMemberInputTypeData%MJointID2 = SrcMemberInputTypeData%MJointID2
   DstMemberInputTypeData%MJointID1Indx = SrcMemberInputTypeData%MJointID1Indx
   DstMemberInputTypeData%MJointID2Indx = SrcMemberInputTypeData%MJointID2Indx
   DstMemberInputTypeData%MPropSetID1 = SrcMemberInputTypeData%MPropSetID1
   DstMemberInputTypeData%MPropSetID2 = SrcMemberInputTypeData%MPropSetID2
   DstMemberInputTypeData%MPropSetID1Indx = SrcMemberInputTypeData%MPropSetID1Indx
   DstMemberInputTypeData%MPropSetID2Indx = SrcMemberInputTypeData%MPropSetID2Indx
   DstMemberInputTypeData%MSecGeom = SrcMemberInputTypeData%MSecGeom
   DstMemberInputTypeData%MSpinOrient = SrcMemberInputTypeData%MSpinOrient
   DstMemberInputTypeData%MDivSize = SrcMemberInputTypeData%MDivSize
   DstMemberInputTypeData%MCoefMod = SrcMemberInputTypeData%MCoefMod
   DstMemberInputTypeData%MHstLMod = SrcMemberInputTypeData%MHstLMod
   DstMemberInputTypeData%MmbrCoefIDIndx = SrcMemberInputTypeData%MmbrCoefIDIndx
   DstMemberInputTypeData%MmbrFilledIDIndx = SrcMemberInputTypeData%MmbrFilledIDIndx
   DstMemberInputTypeData%PropPot = SrcMemberInputTypeData%PropPot
   DstMemberInputTypeData%PropMCF = SrcMemberInputTypeData%PropMCF
   DstMemberInputTypeData%NElements = SrcMemberInputTypeData%NElements
   DstMemberInputTypeData%RefLength = SrcMemberInputTypeData%RefLength
   DstMemberInputTypeData%dl = SrcMemberInputTypeData%dl
end subroutine

subroutine Morison_DestroyMemberInputType(MemberInputTypeData, ErrStat, ErrMsg)
   type(Morison_MemberInputType), intent(inout) :: MemberInputTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Morison_DestroyMemberInputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(MemberInputTypeData%NodeIndx)) then
      deallocate(MemberInputTypeData%NodeIndx)
   end if
end subroutine

subroutine Morison_PackMemberInputType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Morison_MemberInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Morison_PackMemberInputType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%MemberID)
   call RegPackAlloc(RF, InData%NodeIndx)
   call RegPack(RF, InData%MJointID1)
   call RegPack(RF, InData%MJointID2)
   call RegPack(RF, InData%MJointID1Indx)
   call RegPack(RF, InData%MJointID2Indx)
   call RegPack(RF, InData%MPropSetID1)
   call RegPack(RF, InData%MPropSetID2)
   call RegPack(RF, InData%MPropSetID1Indx)
   call RegPack(RF, InData%MPropSetID2Indx)
   call RegPack(RF, InData%MSecGeom)
   call RegPack(RF, InData%MSpinOrient)
   call RegPack(RF, InData%MDivSize)
   call RegPack(RF, InData%MCoefMod)
   call RegPack(RF, InData%MHstLMod)
   call RegPack(RF, InData%MmbrCoefIDIndx)
   call RegPack(RF, InData%MmbrFilledIDIndx)
   call RegPack(RF, InData%PropPot)
   call RegPack(RF, InData%PropMCF)
   call RegPack(RF, InData%NElements)
   call RegPack(RF, InData%RefLength)
   call RegPack(RF, InData%dl)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_UnPackMemberInputType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Morison_MemberInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Morison_UnPackMemberInputType'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%MemberID); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%NodeIndx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MJointID1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MJointID2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MJointID1Indx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MJointID2Indx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MPropSetID1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MPropSetID2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MPropSetID1Indx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MPropSetID2Indx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MSecGeom); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MSpinOrient); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MDivSize); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MCoefMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MHstLMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MmbrCoefIDIndx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MmbrFilledIDIndx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PropPot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PropMCF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NElements); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RefLength); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dl); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_CopyNodeType(SrcNodeTypeData, DstNodeTypeData, CtrlCode, ErrStat, ErrMsg)
   type(Morison_NodeType), intent(in) :: SrcNodeTypeData
   type(Morison_NodeType), intent(inout) :: DstNodeTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Morison_CopyNodeType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstNodeTypeData%JointIndx = SrcNodeTypeData%JointIndx
   DstNodeTypeData%Position = SrcNodeTypeData%Position
   DstNodeTypeData%JointOvrlp = SrcNodeTypeData%JointOvrlp
   DstNodeTypeData%JointAxIDIndx = SrcNodeTypeData%JointAxIDIndx
   DstNodeTypeData%NConnections = SrcNodeTypeData%NConnections
   DstNodeTypeData%ConnectionList = SrcNodeTypeData%ConnectionList
   DstNodeTypeData%JAxCd = SrcNodeTypeData%JAxCd
   DstNodeTypeData%JAxCa = SrcNodeTypeData%JAxCa
   DstNodeTypeData%JAxCp = SrcNodeTypeData%JAxCp
   DstNodeTypeData%JAxVnCOff = SrcNodeTypeData%JAxVnCOff
   DstNodeTypeData%JAxFDLoFSc = SrcNodeTypeData%JAxFDLoFSc
   DstNodeTypeData%JAxFDMod = SrcNodeTypeData%JAxFDMod
   DstNodeTypeData%FillDensity = SrcNodeTypeData%FillDensity
   DstNodeTypeData%tMG = SrcNodeTypeData%tMG
   DstNodeTypeData%MGdensity = SrcNodeTypeData%MGdensity
end subroutine

subroutine Morison_DestroyNodeType(NodeTypeData, ErrStat, ErrMsg)
   type(Morison_NodeType), intent(inout) :: NodeTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Morison_DestroyNodeType'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine Morison_PackNodeType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Morison_NodeType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Morison_PackNodeType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%JointIndx)
   call RegPack(RF, InData%Position)
   call RegPack(RF, InData%JointOvrlp)
   call RegPack(RF, InData%JointAxIDIndx)
   call RegPack(RF, InData%NConnections)
   call RegPack(RF, InData%ConnectionList)
   call RegPack(RF, InData%JAxCd)
   call RegPack(RF, InData%JAxCa)
   call RegPack(RF, InData%JAxCp)
   call RegPack(RF, InData%JAxVnCOff)
   call RegPack(RF, InData%JAxFDLoFSc)
   call RegPack(RF, InData%JAxFDMod)
   call RegPack(RF, InData%FillDensity)
   call RegPack(RF, InData%tMG)
   call RegPack(RF, InData%MGdensity)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_UnPackNodeType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Morison_NodeType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Morison_UnPackNodeType'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%JointIndx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Position); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%JointOvrlp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%JointAxIDIndx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NConnections); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ConnectionList); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%JAxCd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%JAxCa); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%JAxCp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%JAxVnCOff); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%JAxFDLoFSc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%JAxFDMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FillDensity); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%tMG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MGdensity); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_CopyMemberType(SrcMemberTypeData, DstMemberTypeData, CtrlCode, ErrStat, ErrMsg)
   type(Morison_MemberType), intent(in) :: SrcMemberTypeData
   type(Morison_MemberType), intent(inout) :: DstMemberTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'Morison_CopyMemberType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcMemberTypeData%NodeIndx)) then
      LB(1:1) = lbound(SrcMemberTypeData%NodeIndx)
      UB(1:1) = ubound(SrcMemberTypeData%NodeIndx)
      if (.not. allocated(DstMemberTypeData%NodeIndx)) then
         allocate(DstMemberTypeData%NodeIndx(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%NodeIndx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%NodeIndx = SrcMemberTypeData%NodeIndx
   end if
   DstMemberTypeData%MemberID = SrcMemberTypeData%MemberID
   DstMemberTypeData%NElements = SrcMemberTypeData%NElements
   DstMemberTypeData%RefLength = SrcMemberTypeData%RefLength
   DstMemberTypeData%cosPhi_ref = SrcMemberTypeData%cosPhi_ref
   DstMemberTypeData%dl = SrcMemberTypeData%dl
   DstMemberTypeData%k = SrcMemberTypeData%k
   DstMemberTypeData%kkt = SrcMemberTypeData%kkt
   DstMemberTypeData%Ak = SrcMemberTypeData%Ak
   DstMemberTypeData%x_hat = SrcMemberTypeData%x_hat
   DstMemberTypeData%y_hat = SrcMemberTypeData%y_hat
   if (allocated(SrcMemberTypeData%R)) then
      LB(1:1) = lbound(SrcMemberTypeData%R)
      UB(1:1) = ubound(SrcMemberTypeData%R)
      if (.not. allocated(DstMemberTypeData%R)) then
         allocate(DstMemberTypeData%R(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%R.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%R = SrcMemberTypeData%R
   end if
   if (allocated(SrcMemberTypeData%RMG)) then
      LB(1:1) = lbound(SrcMemberTypeData%RMG)
      UB(1:1) = ubound(SrcMemberTypeData%RMG)
      if (.not. allocated(DstMemberTypeData%RMG)) then
         allocate(DstMemberTypeData%RMG(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%RMG.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%RMG = SrcMemberTypeData%RMG
   end if
   if (allocated(SrcMemberTypeData%RMGB)) then
      LB(1:1) = lbound(SrcMemberTypeData%RMGB)
      UB(1:1) = ubound(SrcMemberTypeData%RMGB)
      if (.not. allocated(DstMemberTypeData%RMGB)) then
         allocate(DstMemberTypeData%RMGB(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%RMGB.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%RMGB = SrcMemberTypeData%RMGB
   end if
   if (allocated(SrcMemberTypeData%Rin)) then
      LB(1:1) = lbound(SrcMemberTypeData%Rin)
      UB(1:1) = ubound(SrcMemberTypeData%Rin)
      if (.not. allocated(DstMemberTypeData%Rin)) then
         allocate(DstMemberTypeData%Rin(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%Rin.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%Rin = SrcMemberTypeData%Rin
   end if
   if (allocated(SrcMemberTypeData%Sa)) then
      LB(1:1) = lbound(SrcMemberTypeData%Sa)
      UB(1:1) = ubound(SrcMemberTypeData%Sa)
      if (.not. allocated(DstMemberTypeData%Sa)) then
         allocate(DstMemberTypeData%Sa(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%Sa.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%Sa = SrcMemberTypeData%Sa
   end if
   if (allocated(SrcMemberTypeData%SaMG)) then
      LB(1:1) = lbound(SrcMemberTypeData%SaMG)
      UB(1:1) = ubound(SrcMemberTypeData%SaMG)
      if (.not. allocated(DstMemberTypeData%SaMG)) then
         allocate(DstMemberTypeData%SaMG(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%SaMG.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%SaMG = SrcMemberTypeData%SaMG
   end if
   if (allocated(SrcMemberTypeData%SaMGB)) then
      LB(1:1) = lbound(SrcMemberTypeData%SaMGB)
      UB(1:1) = ubound(SrcMemberTypeData%SaMGB)
      if (.not. allocated(DstMemberTypeData%SaMGB)) then
         allocate(DstMemberTypeData%SaMGB(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%SaMGB.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%SaMGB = SrcMemberTypeData%SaMGB
   end if
   if (allocated(SrcMemberTypeData%Sain)) then
      LB(1:1) = lbound(SrcMemberTypeData%Sain)
      UB(1:1) = ubound(SrcMemberTypeData%Sain)
      if (.not. allocated(DstMemberTypeData%Sain)) then
         allocate(DstMemberTypeData%Sain(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%Sain.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%Sain = SrcMemberTypeData%Sain
   end if
   if (allocated(SrcMemberTypeData%Sb)) then
      LB(1:1) = lbound(SrcMemberTypeData%Sb)
      UB(1:1) = ubound(SrcMemberTypeData%Sb)
      if (.not. allocated(DstMemberTypeData%Sb)) then
         allocate(DstMemberTypeData%Sb(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%Sb.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%Sb = SrcMemberTypeData%Sb
   end if
   if (allocated(SrcMemberTypeData%SbMG)) then
      LB(1:1) = lbound(SrcMemberTypeData%SbMG)
      UB(1:1) = ubound(SrcMemberTypeData%SbMG)
      if (.not. allocated(DstMemberTypeData%SbMG)) then
         allocate(DstMemberTypeData%SbMG(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%SbMG.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%SbMG = SrcMemberTypeData%SbMG
   end if
   if (allocated(SrcMemberTypeData%SbMGB)) then
      LB(1:1) = lbound(SrcMemberTypeData%SbMGB)
      UB(1:1) = ubound(SrcMemberTypeData%SbMGB)
      if (.not. allocated(DstMemberTypeData%SbMGB)) then
         allocate(DstMemberTypeData%SbMGB(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%SbMGB.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%SbMGB = SrcMemberTypeData%SbMGB
   end if
   if (allocated(SrcMemberTypeData%Sbin)) then
      LB(1:1) = lbound(SrcMemberTypeData%Sbin)
      UB(1:1) = ubound(SrcMemberTypeData%Sbin)
      if (.not. allocated(DstMemberTypeData%Sbin)) then
         allocate(DstMemberTypeData%Sbin(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%Sbin.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%Sbin = SrcMemberTypeData%Sbin
   end if
   if (allocated(SrcMemberTypeData%tMG)) then
      LB(1:1) = lbound(SrcMemberTypeData%tMG)
      UB(1:1) = ubound(SrcMemberTypeData%tMG)
      if (.not. allocated(DstMemberTypeData%tMG)) then
         allocate(DstMemberTypeData%tMG(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%tMG.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%tMG = SrcMemberTypeData%tMG
   end if
   if (allocated(SrcMemberTypeData%MGdensity)) then
      LB(1:1) = lbound(SrcMemberTypeData%MGdensity)
      UB(1:1) = ubound(SrcMemberTypeData%MGdensity)
      if (.not. allocated(DstMemberTypeData%MGdensity)) then
         allocate(DstMemberTypeData%MGdensity(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%MGdensity.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%MGdensity = SrcMemberTypeData%MGdensity
   end if
   if (allocated(SrcMemberTypeData%dRdl_mg)) then
      LB(1:1) = lbound(SrcMemberTypeData%dRdl_mg)
      UB(1:1) = ubound(SrcMemberTypeData%dRdl_mg)
      if (.not. allocated(DstMemberTypeData%dRdl_mg)) then
         allocate(DstMemberTypeData%dRdl_mg(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%dRdl_mg.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%dRdl_mg = SrcMemberTypeData%dRdl_mg
   end if
   if (allocated(SrcMemberTypeData%dRdl_mg_b)) then
      LB(1:1) = lbound(SrcMemberTypeData%dRdl_mg_b)
      UB(1:1) = ubound(SrcMemberTypeData%dRdl_mg_b)
      if (.not. allocated(DstMemberTypeData%dRdl_mg_b)) then
         allocate(DstMemberTypeData%dRdl_mg_b(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%dRdl_mg_b.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%dRdl_mg_b = SrcMemberTypeData%dRdl_mg_b
   end if
   if (allocated(SrcMemberTypeData%dRdl_in)) then
      LB(1:1) = lbound(SrcMemberTypeData%dRdl_in)
      UB(1:1) = ubound(SrcMemberTypeData%dRdl_in)
      if (.not. allocated(DstMemberTypeData%dRdl_in)) then
         allocate(DstMemberTypeData%dRdl_in(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%dRdl_in.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%dRdl_in = SrcMemberTypeData%dRdl_in
   end if
   if (allocated(SrcMemberTypeData%dSadl_mg)) then
      LB(1:1) = lbound(SrcMemberTypeData%dSadl_mg)
      UB(1:1) = ubound(SrcMemberTypeData%dSadl_mg)
      if (.not. allocated(DstMemberTypeData%dSadl_mg)) then
         allocate(DstMemberTypeData%dSadl_mg(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%dSadl_mg.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%dSadl_mg = SrcMemberTypeData%dSadl_mg
   end if
   if (allocated(SrcMemberTypeData%dSadl_mg_b)) then
      LB(1:1) = lbound(SrcMemberTypeData%dSadl_mg_b)
      UB(1:1) = ubound(SrcMemberTypeData%dSadl_mg_b)
      if (.not. allocated(DstMemberTypeData%dSadl_mg_b)) then
         allocate(DstMemberTypeData%dSadl_mg_b(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%dSadl_mg_b.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%dSadl_mg_b = SrcMemberTypeData%dSadl_mg_b
   end if
   if (allocated(SrcMemberTypeData%dSadl_in)) then
      LB(1:1) = lbound(SrcMemberTypeData%dSadl_in)
      UB(1:1) = ubound(SrcMemberTypeData%dSadl_in)
      if (.not. allocated(DstMemberTypeData%dSadl_in)) then
         allocate(DstMemberTypeData%dSadl_in(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%dSadl_in.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%dSadl_in = SrcMemberTypeData%dSadl_in
   end if
   if (allocated(SrcMemberTypeData%dSbdl_mg)) then
      LB(1:1) = lbound(SrcMemberTypeData%dSbdl_mg)
      UB(1:1) = ubound(SrcMemberTypeData%dSbdl_mg)
      if (.not. allocated(DstMemberTypeData%dSbdl_mg)) then
         allocate(DstMemberTypeData%dSbdl_mg(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%dSbdl_mg.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%dSbdl_mg = SrcMemberTypeData%dSbdl_mg
   end if
   if (allocated(SrcMemberTypeData%dSbdl_mg_b)) then
      LB(1:1) = lbound(SrcMemberTypeData%dSbdl_mg_b)
      UB(1:1) = ubound(SrcMemberTypeData%dSbdl_mg_b)
      if (.not. allocated(DstMemberTypeData%dSbdl_mg_b)) then
         allocate(DstMemberTypeData%dSbdl_mg_b(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%dSbdl_mg_b.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%dSbdl_mg_b = SrcMemberTypeData%dSbdl_mg_b
   end if
   if (allocated(SrcMemberTypeData%dSbdl_in)) then
      LB(1:1) = lbound(SrcMemberTypeData%dSbdl_in)
      UB(1:1) = ubound(SrcMemberTypeData%dSbdl_in)
      if (.not. allocated(DstMemberTypeData%dSbdl_in)) then
         allocate(DstMemberTypeData%dSbdl_in(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%dSbdl_in.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%dSbdl_in = SrcMemberTypeData%dSbdl_in
   end if
   DstMemberTypeData%Vinner = SrcMemberTypeData%Vinner
   DstMemberTypeData%Vouter = SrcMemberTypeData%Vouter
   DstMemberTypeData%Vballast = SrcMemberTypeData%Vballast
   DstMemberTypeData%Vsubmerged = SrcMemberTypeData%Vsubmerged
   DstMemberTypeData%elem_fill = SrcMemberTypeData%elem_fill
   DstMemberTypeData%l_fill = SrcMemberTypeData%l_fill
   DstMemberTypeData%h_fill = SrcMemberTypeData%h_fill
   DstMemberTypeData%z_overfill = SrcMemberTypeData%z_overfill
   DstMemberTypeData%h_floor = SrcMemberTypeData%h_floor
   DstMemberTypeData%i_floor = SrcMemberTypeData%i_floor
   DstMemberTypeData%doEndBuoyancy = SrcMemberTypeData%doEndBuoyancy
   DstMemberTypeData%memfloodstatus = SrcMemberTypeData%memfloodstatus
   if (allocated(SrcMemberTypeData%floodstatus)) then
      LB(1:1) = lbound(SrcMemberTypeData%floodstatus)
      UB(1:1) = ubound(SrcMemberTypeData%floodstatus)
      if (.not. allocated(DstMemberTypeData%floodstatus)) then
         allocate(DstMemberTypeData%floodstatus(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%floodstatus.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%floodstatus = SrcMemberTypeData%floodstatus
   end if
   if (allocated(SrcMemberTypeData%alpha)) then
      LB(1:1) = lbound(SrcMemberTypeData%alpha)
      UB(1:1) = ubound(SrcMemberTypeData%alpha)
      if (.not. allocated(DstMemberTypeData%alpha)) then
         allocate(DstMemberTypeData%alpha(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%alpha.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%alpha = SrcMemberTypeData%alpha
   end if
   if (allocated(SrcMemberTypeData%alpha_fb)) then
      LB(1:1) = lbound(SrcMemberTypeData%alpha_fb)
      UB(1:1) = ubound(SrcMemberTypeData%alpha_fb)
      if (.not. allocated(DstMemberTypeData%alpha_fb)) then
         allocate(DstMemberTypeData%alpha_fb(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%alpha_fb.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%alpha_fb = SrcMemberTypeData%alpha_fb
   end if
   if (allocated(SrcMemberTypeData%alpha_fb_star)) then
      LB(1:1) = lbound(SrcMemberTypeData%alpha_fb_star)
      UB(1:1) = ubound(SrcMemberTypeData%alpha_fb_star)
      if (.not. allocated(DstMemberTypeData%alpha_fb_star)) then
         allocate(DstMemberTypeData%alpha_fb_star(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%alpha_fb_star.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%alpha_fb_star = SrcMemberTypeData%alpha_fb_star
   end if
   if (allocated(SrcMemberTypeData%Cd)) then
      LB(1:1) = lbound(SrcMemberTypeData%Cd)
      UB(1:1) = ubound(SrcMemberTypeData%Cd)
      if (.not. allocated(DstMemberTypeData%Cd)) then
         allocate(DstMemberTypeData%Cd(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%Cd.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%Cd = SrcMemberTypeData%Cd
   end if
   if (allocated(SrcMemberTypeData%Ca)) then
      LB(1:1) = lbound(SrcMemberTypeData%Ca)
      UB(1:1) = ubound(SrcMemberTypeData%Ca)
      if (.not. allocated(DstMemberTypeData%Ca)) then
         allocate(DstMemberTypeData%Ca(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%Ca.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%Ca = SrcMemberTypeData%Ca
   end if
   if (allocated(SrcMemberTypeData%CdA)) then
      LB(1:1) = lbound(SrcMemberTypeData%CdA)
      UB(1:1) = ubound(SrcMemberTypeData%CdA)
      if (.not. allocated(DstMemberTypeData%CdA)) then
         allocate(DstMemberTypeData%CdA(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%CdA.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%CdA = SrcMemberTypeData%CdA
   end if
   if (allocated(SrcMemberTypeData%CaA)) then
      LB(1:1) = lbound(SrcMemberTypeData%CaA)
      UB(1:1) = ubound(SrcMemberTypeData%CaA)
      if (.not. allocated(DstMemberTypeData%CaA)) then
         allocate(DstMemberTypeData%CaA(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%CaA.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%CaA = SrcMemberTypeData%CaA
   end if
   if (allocated(SrcMemberTypeData%CdB)) then
      LB(1:1) = lbound(SrcMemberTypeData%CdB)
      UB(1:1) = ubound(SrcMemberTypeData%CdB)
      if (.not. allocated(DstMemberTypeData%CdB)) then
         allocate(DstMemberTypeData%CdB(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%CdB.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%CdB = SrcMemberTypeData%CdB
   end if
   if (allocated(SrcMemberTypeData%CaB)) then
      LB(1:1) = lbound(SrcMemberTypeData%CaB)
      UB(1:1) = ubound(SrcMemberTypeData%CaB)
      if (.not. allocated(DstMemberTypeData%CaB)) then
         allocate(DstMemberTypeData%CaB(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%CaB.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%CaB = SrcMemberTypeData%CaB
   end if
   if (allocated(SrcMemberTypeData%Cp)) then
      LB(1:1) = lbound(SrcMemberTypeData%Cp)
      UB(1:1) = ubound(SrcMemberTypeData%Cp)
      if (.not. allocated(DstMemberTypeData%Cp)) then
         allocate(DstMemberTypeData%Cp(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%Cp.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%Cp = SrcMemberTypeData%Cp
   end if
   if (allocated(SrcMemberTypeData%AxCd)) then
      LB(1:1) = lbound(SrcMemberTypeData%AxCd)
      UB(1:1) = ubound(SrcMemberTypeData%AxCd)
      if (.not. allocated(DstMemberTypeData%AxCd)) then
         allocate(DstMemberTypeData%AxCd(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%AxCd.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%AxCd = SrcMemberTypeData%AxCd
   end if
   if (allocated(SrcMemberTypeData%AxCa)) then
      LB(1:1) = lbound(SrcMemberTypeData%AxCa)
      UB(1:1) = ubound(SrcMemberTypeData%AxCa)
      if (.not. allocated(DstMemberTypeData%AxCa)) then
         allocate(DstMemberTypeData%AxCa(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%AxCa.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%AxCa = SrcMemberTypeData%AxCa
   end if
   if (allocated(SrcMemberTypeData%AxCp)) then
      LB(1:1) = lbound(SrcMemberTypeData%AxCp)
      UB(1:1) = ubound(SrcMemberTypeData%AxCp)
      if (.not. allocated(DstMemberTypeData%AxCp)) then
         allocate(DstMemberTypeData%AxCp(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%AxCp.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%AxCp = SrcMemberTypeData%AxCp
   end if
   if (allocated(SrcMemberTypeData%Cb)) then
      LB(1:1) = lbound(SrcMemberTypeData%Cb)
      UB(1:1) = ubound(SrcMemberTypeData%Cb)
      if (.not. allocated(DstMemberTypeData%Cb)) then
         allocate(DstMemberTypeData%Cb(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%Cb.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%Cb = SrcMemberTypeData%Cb
   end if
   if (allocated(SrcMemberTypeData%m_fb_l)) then
      LB(1:1) = lbound(SrcMemberTypeData%m_fb_l)
      UB(1:1) = ubound(SrcMemberTypeData%m_fb_l)
      if (.not. allocated(DstMemberTypeData%m_fb_l)) then
         allocate(DstMemberTypeData%m_fb_l(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%m_fb_l.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%m_fb_l = SrcMemberTypeData%m_fb_l
   end if
   if (allocated(SrcMemberTypeData%m_fb_u)) then
      LB(1:1) = lbound(SrcMemberTypeData%m_fb_u)
      UB(1:1) = ubound(SrcMemberTypeData%m_fb_u)
      if (.not. allocated(DstMemberTypeData%m_fb_u)) then
         allocate(DstMemberTypeData%m_fb_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%m_fb_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%m_fb_u = SrcMemberTypeData%m_fb_u
   end if
   if (allocated(SrcMemberTypeData%h_cfb_l)) then
      LB(1:1) = lbound(SrcMemberTypeData%h_cfb_l)
      UB(1:1) = ubound(SrcMemberTypeData%h_cfb_l)
      if (.not. allocated(DstMemberTypeData%h_cfb_l)) then
         allocate(DstMemberTypeData%h_cfb_l(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%h_cfb_l.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%h_cfb_l = SrcMemberTypeData%h_cfb_l
   end if
   if (allocated(SrcMemberTypeData%h_cfb_u)) then
      LB(1:1) = lbound(SrcMemberTypeData%h_cfb_u)
      UB(1:1) = ubound(SrcMemberTypeData%h_cfb_u)
      if (.not. allocated(DstMemberTypeData%h_cfb_u)) then
         allocate(DstMemberTypeData%h_cfb_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%h_cfb_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%h_cfb_u = SrcMemberTypeData%h_cfb_u
   end if
   if (allocated(SrcMemberTypeData%I_lfb_l)) then
      LB(1:1) = lbound(SrcMemberTypeData%I_lfb_l)
      UB(1:1) = ubound(SrcMemberTypeData%I_lfb_l)
      if (.not. allocated(DstMemberTypeData%I_lfb_l)) then
         allocate(DstMemberTypeData%I_lfb_l(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%I_lfb_l.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%I_lfb_l = SrcMemberTypeData%I_lfb_l
   end if
   if (allocated(SrcMemberTypeData%I_lfb_u)) then
      LB(1:1) = lbound(SrcMemberTypeData%I_lfb_u)
      UB(1:1) = ubound(SrcMemberTypeData%I_lfb_u)
      if (.not. allocated(DstMemberTypeData%I_lfb_u)) then
         allocate(DstMemberTypeData%I_lfb_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%I_lfb_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%I_lfb_u = SrcMemberTypeData%I_lfb_u
   end if
   if (allocated(SrcMemberTypeData%I_rfb_l)) then
      LB(1:1) = lbound(SrcMemberTypeData%I_rfb_l)
      UB(1:1) = ubound(SrcMemberTypeData%I_rfb_l)
      if (.not. allocated(DstMemberTypeData%I_rfb_l)) then
         allocate(DstMemberTypeData%I_rfb_l(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%I_rfb_l.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%I_rfb_l = SrcMemberTypeData%I_rfb_l
   end if
   if (allocated(SrcMemberTypeData%I_rfb_u)) then
      LB(1:1) = lbound(SrcMemberTypeData%I_rfb_u)
      UB(1:1) = ubound(SrcMemberTypeData%I_rfb_u)
      if (.not. allocated(DstMemberTypeData%I_rfb_u)) then
         allocate(DstMemberTypeData%I_rfb_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%I_rfb_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%I_rfb_u = SrcMemberTypeData%I_rfb_u
   end if
   if (allocated(SrcMemberTypeData%I_xfb_l)) then
      LB(1:1) = lbound(SrcMemberTypeData%I_xfb_l)
      UB(1:1) = ubound(SrcMemberTypeData%I_xfb_l)
      if (.not. allocated(DstMemberTypeData%I_xfb_l)) then
         allocate(DstMemberTypeData%I_xfb_l(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%I_xfb_l.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%I_xfb_l = SrcMemberTypeData%I_xfb_l
   end if
   if (allocated(SrcMemberTypeData%I_xfb_u)) then
      LB(1:1) = lbound(SrcMemberTypeData%I_xfb_u)
      UB(1:1) = ubound(SrcMemberTypeData%I_xfb_u)
      if (.not. allocated(DstMemberTypeData%I_xfb_u)) then
         allocate(DstMemberTypeData%I_xfb_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%I_xfb_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%I_xfb_u = SrcMemberTypeData%I_xfb_u
   end if
   if (allocated(SrcMemberTypeData%I_yfb_l)) then
      LB(1:1) = lbound(SrcMemberTypeData%I_yfb_l)
      UB(1:1) = ubound(SrcMemberTypeData%I_yfb_l)
      if (.not. allocated(DstMemberTypeData%I_yfb_l)) then
         allocate(DstMemberTypeData%I_yfb_l(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%I_yfb_l.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%I_yfb_l = SrcMemberTypeData%I_yfb_l
   end if
   if (allocated(SrcMemberTypeData%I_yfb_u)) then
      LB(1:1) = lbound(SrcMemberTypeData%I_yfb_u)
      UB(1:1) = ubound(SrcMemberTypeData%I_yfb_u)
      if (.not. allocated(DstMemberTypeData%I_yfb_u)) then
         allocate(DstMemberTypeData%I_yfb_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%I_yfb_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%I_yfb_u = SrcMemberTypeData%I_yfb_u
   end if
   if (allocated(SrcMemberTypeData%m_mg_l)) then
      LB(1:1) = lbound(SrcMemberTypeData%m_mg_l)
      UB(1:1) = ubound(SrcMemberTypeData%m_mg_l)
      if (.not. allocated(DstMemberTypeData%m_mg_l)) then
         allocate(DstMemberTypeData%m_mg_l(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%m_mg_l.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%m_mg_l = SrcMemberTypeData%m_mg_l
   end if
   if (allocated(SrcMemberTypeData%m_mg_u)) then
      LB(1:1) = lbound(SrcMemberTypeData%m_mg_u)
      UB(1:1) = ubound(SrcMemberTypeData%m_mg_u)
      if (.not. allocated(DstMemberTypeData%m_mg_u)) then
         allocate(DstMemberTypeData%m_mg_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%m_mg_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%m_mg_u = SrcMemberTypeData%m_mg_u
   end if
   if (allocated(SrcMemberTypeData%h_cmg_l)) then
      LB(1:1) = lbound(SrcMemberTypeData%h_cmg_l)
      UB(1:1) = ubound(SrcMemberTypeData%h_cmg_l)
      if (.not. allocated(DstMemberTypeData%h_cmg_l)) then
         allocate(DstMemberTypeData%h_cmg_l(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%h_cmg_l.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%h_cmg_l = SrcMemberTypeData%h_cmg_l
   end if
   if (allocated(SrcMemberTypeData%h_cmg_u)) then
      LB(1:1) = lbound(SrcMemberTypeData%h_cmg_u)
      UB(1:1) = ubound(SrcMemberTypeData%h_cmg_u)
      if (.not. allocated(DstMemberTypeData%h_cmg_u)) then
         allocate(DstMemberTypeData%h_cmg_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%h_cmg_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%h_cmg_u = SrcMemberTypeData%h_cmg_u
   end if
   if (allocated(SrcMemberTypeData%I_lmg_l)) then
      LB(1:1) = lbound(SrcMemberTypeData%I_lmg_l)
      UB(1:1) = ubound(SrcMemberTypeData%I_lmg_l)
      if (.not. allocated(DstMemberTypeData%I_lmg_l)) then
         allocate(DstMemberTypeData%I_lmg_l(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%I_lmg_l.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%I_lmg_l = SrcMemberTypeData%I_lmg_l
   end if
   if (allocated(SrcMemberTypeData%I_lmg_u)) then
      LB(1:1) = lbound(SrcMemberTypeData%I_lmg_u)
      UB(1:1) = ubound(SrcMemberTypeData%I_lmg_u)
      if (.not. allocated(DstMemberTypeData%I_lmg_u)) then
         allocate(DstMemberTypeData%I_lmg_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%I_lmg_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%I_lmg_u = SrcMemberTypeData%I_lmg_u
   end if
   if (allocated(SrcMemberTypeData%I_rmg_l)) then
      LB(1:1) = lbound(SrcMemberTypeData%I_rmg_l)
      UB(1:1) = ubound(SrcMemberTypeData%I_rmg_l)
      if (.not. allocated(DstMemberTypeData%I_rmg_l)) then
         allocate(DstMemberTypeData%I_rmg_l(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%I_rmg_l.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%I_rmg_l = SrcMemberTypeData%I_rmg_l
   end if
   if (allocated(SrcMemberTypeData%I_rmg_u)) then
      LB(1:1) = lbound(SrcMemberTypeData%I_rmg_u)
      UB(1:1) = ubound(SrcMemberTypeData%I_rmg_u)
      if (.not. allocated(DstMemberTypeData%I_rmg_u)) then
         allocate(DstMemberTypeData%I_rmg_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%I_rmg_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%I_rmg_u = SrcMemberTypeData%I_rmg_u
   end if
   if (allocated(SrcMemberTypeData%I_xmg_l)) then
      LB(1:1) = lbound(SrcMemberTypeData%I_xmg_l)
      UB(1:1) = ubound(SrcMemberTypeData%I_xmg_l)
      if (.not. allocated(DstMemberTypeData%I_xmg_l)) then
         allocate(DstMemberTypeData%I_xmg_l(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%I_xmg_l.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%I_xmg_l = SrcMemberTypeData%I_xmg_l
   end if
   if (allocated(SrcMemberTypeData%I_xmg_u)) then
      LB(1:1) = lbound(SrcMemberTypeData%I_xmg_u)
      UB(1:1) = ubound(SrcMemberTypeData%I_xmg_u)
      if (.not. allocated(DstMemberTypeData%I_xmg_u)) then
         allocate(DstMemberTypeData%I_xmg_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%I_xmg_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%I_xmg_u = SrcMemberTypeData%I_xmg_u
   end if
   if (allocated(SrcMemberTypeData%I_ymg_l)) then
      LB(1:1) = lbound(SrcMemberTypeData%I_ymg_l)
      UB(1:1) = ubound(SrcMemberTypeData%I_ymg_l)
      if (.not. allocated(DstMemberTypeData%I_ymg_l)) then
         allocate(DstMemberTypeData%I_ymg_l(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%I_ymg_l.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%I_ymg_l = SrcMemberTypeData%I_ymg_l
   end if
   if (allocated(SrcMemberTypeData%I_ymg_u)) then
      LB(1:1) = lbound(SrcMemberTypeData%I_ymg_u)
      UB(1:1) = ubound(SrcMemberTypeData%I_ymg_u)
      if (.not. allocated(DstMemberTypeData%I_ymg_u)) then
         allocate(DstMemberTypeData%I_ymg_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%I_ymg_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberTypeData%I_ymg_u = SrcMemberTypeData%I_ymg_u
   end if
   DstMemberTypeData%MGvolume = SrcMemberTypeData%MGvolume
   DstMemberTypeData%MSecGeom = SrcMemberTypeData%MSecGeom
   DstMemberTypeData%MSpinOrient = SrcMemberTypeData%MSpinOrient
   DstMemberTypeData%MDivSize = SrcMemberTypeData%MDivSize
   DstMemberTypeData%MCoefMod = SrcMemberTypeData%MCoefMod
   DstMemberTypeData%MmbrCoefIDIndx = SrcMemberTypeData%MmbrCoefIDIndx
   DstMemberTypeData%MmbrFilledIDIndx = SrcMemberTypeData%MmbrFilledIDIndx
   DstMemberTypeData%MHstLMod = SrcMemberTypeData%MHstLMod
   DstMemberTypeData%FillFSLoc = SrcMemberTypeData%FillFSLoc
   DstMemberTypeData%FillDens = SrcMemberTypeData%FillDens
   DstMemberTypeData%PropPot = SrcMemberTypeData%PropPot
   DstMemberTypeData%PropMCF = SrcMemberTypeData%PropMCF
   DstMemberTypeData%Flipped = SrcMemberTypeData%Flipped
end subroutine

subroutine Morison_DestroyMemberType(MemberTypeData, ErrStat, ErrMsg)
   type(Morison_MemberType), intent(inout) :: MemberTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Morison_DestroyMemberType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(MemberTypeData%NodeIndx)) then
      deallocate(MemberTypeData%NodeIndx)
   end if
   if (allocated(MemberTypeData%R)) then
      deallocate(MemberTypeData%R)
   end if
   if (allocated(MemberTypeData%RMG)) then
      deallocate(MemberTypeData%RMG)
   end if
   if (allocated(MemberTypeData%RMGB)) then
      deallocate(MemberTypeData%RMGB)
   end if
   if (allocated(MemberTypeData%Rin)) then
      deallocate(MemberTypeData%Rin)
   end if
   if (allocated(MemberTypeData%Sa)) then
      deallocate(MemberTypeData%Sa)
   end if
   if (allocated(MemberTypeData%SaMG)) then
      deallocate(MemberTypeData%SaMG)
   end if
   if (allocated(MemberTypeData%SaMGB)) then
      deallocate(MemberTypeData%SaMGB)
   end if
   if (allocated(MemberTypeData%Sain)) then
      deallocate(MemberTypeData%Sain)
   end if
   if (allocated(MemberTypeData%Sb)) then
      deallocate(MemberTypeData%Sb)
   end if
   if (allocated(MemberTypeData%SbMG)) then
      deallocate(MemberTypeData%SbMG)
   end if
   if (allocated(MemberTypeData%SbMGB)) then
      deallocate(MemberTypeData%SbMGB)
   end if
   if (allocated(MemberTypeData%Sbin)) then
      deallocate(MemberTypeData%Sbin)
   end if
   if (allocated(MemberTypeData%tMG)) then
      deallocate(MemberTypeData%tMG)
   end if
   if (allocated(MemberTypeData%MGdensity)) then
      deallocate(MemberTypeData%MGdensity)
   end if
   if (allocated(MemberTypeData%dRdl_mg)) then
      deallocate(MemberTypeData%dRdl_mg)
   end if
   if (allocated(MemberTypeData%dRdl_mg_b)) then
      deallocate(MemberTypeData%dRdl_mg_b)
   end if
   if (allocated(MemberTypeData%dRdl_in)) then
      deallocate(MemberTypeData%dRdl_in)
   end if
   if (allocated(MemberTypeData%dSadl_mg)) then
      deallocate(MemberTypeData%dSadl_mg)
   end if
   if (allocated(MemberTypeData%dSadl_mg_b)) then
      deallocate(MemberTypeData%dSadl_mg_b)
   end if
   if (allocated(MemberTypeData%dSadl_in)) then
      deallocate(MemberTypeData%dSadl_in)
   end if
   if (allocated(MemberTypeData%dSbdl_mg)) then
      deallocate(MemberTypeData%dSbdl_mg)
   end if
   if (allocated(MemberTypeData%dSbdl_mg_b)) then
      deallocate(MemberTypeData%dSbdl_mg_b)
   end if
   if (allocated(MemberTypeData%dSbdl_in)) then
      deallocate(MemberTypeData%dSbdl_in)
   end if
   if (allocated(MemberTypeData%floodstatus)) then
      deallocate(MemberTypeData%floodstatus)
   end if
   if (allocated(MemberTypeData%alpha)) then
      deallocate(MemberTypeData%alpha)
   end if
   if (allocated(MemberTypeData%alpha_fb)) then
      deallocate(MemberTypeData%alpha_fb)
   end if
   if (allocated(MemberTypeData%alpha_fb_star)) then
      deallocate(MemberTypeData%alpha_fb_star)
   end if
   if (allocated(MemberTypeData%Cd)) then
      deallocate(MemberTypeData%Cd)
   end if
   if (allocated(MemberTypeData%Ca)) then
      deallocate(MemberTypeData%Ca)
   end if
   if (allocated(MemberTypeData%CdA)) then
      deallocate(MemberTypeData%CdA)
   end if
   if (allocated(MemberTypeData%CaA)) then
      deallocate(MemberTypeData%CaA)
   end if
   if (allocated(MemberTypeData%CdB)) then
      deallocate(MemberTypeData%CdB)
   end if
   if (allocated(MemberTypeData%CaB)) then
      deallocate(MemberTypeData%CaB)
   end if
   if (allocated(MemberTypeData%Cp)) then
      deallocate(MemberTypeData%Cp)
   end if
   if (allocated(MemberTypeData%AxCd)) then
      deallocate(MemberTypeData%AxCd)
   end if
   if (allocated(MemberTypeData%AxCa)) then
      deallocate(MemberTypeData%AxCa)
   end if
   if (allocated(MemberTypeData%AxCp)) then
      deallocate(MemberTypeData%AxCp)
   end if
   if (allocated(MemberTypeData%Cb)) then
      deallocate(MemberTypeData%Cb)
   end if
   if (allocated(MemberTypeData%m_fb_l)) then
      deallocate(MemberTypeData%m_fb_l)
   end if
   if (allocated(MemberTypeData%m_fb_u)) then
      deallocate(MemberTypeData%m_fb_u)
   end if
   if (allocated(MemberTypeData%h_cfb_l)) then
      deallocate(MemberTypeData%h_cfb_l)
   end if
   if (allocated(MemberTypeData%h_cfb_u)) then
      deallocate(MemberTypeData%h_cfb_u)
   end if
   if (allocated(MemberTypeData%I_lfb_l)) then
      deallocate(MemberTypeData%I_lfb_l)
   end if
   if (allocated(MemberTypeData%I_lfb_u)) then
      deallocate(MemberTypeData%I_lfb_u)
   end if
   if (allocated(MemberTypeData%I_rfb_l)) then
      deallocate(MemberTypeData%I_rfb_l)
   end if
   if (allocated(MemberTypeData%I_rfb_u)) then
      deallocate(MemberTypeData%I_rfb_u)
   end if
   if (allocated(MemberTypeData%I_xfb_l)) then
      deallocate(MemberTypeData%I_xfb_l)
   end if
   if (allocated(MemberTypeData%I_xfb_u)) then
      deallocate(MemberTypeData%I_xfb_u)
   end if
   if (allocated(MemberTypeData%I_yfb_l)) then
      deallocate(MemberTypeData%I_yfb_l)
   end if
   if (allocated(MemberTypeData%I_yfb_u)) then
      deallocate(MemberTypeData%I_yfb_u)
   end if
   if (allocated(MemberTypeData%m_mg_l)) then
      deallocate(MemberTypeData%m_mg_l)
   end if
   if (allocated(MemberTypeData%m_mg_u)) then
      deallocate(MemberTypeData%m_mg_u)
   end if
   if (allocated(MemberTypeData%h_cmg_l)) then
      deallocate(MemberTypeData%h_cmg_l)
   end if
   if (allocated(MemberTypeData%h_cmg_u)) then
      deallocate(MemberTypeData%h_cmg_u)
   end if
   if (allocated(MemberTypeData%I_lmg_l)) then
      deallocate(MemberTypeData%I_lmg_l)
   end if
   if (allocated(MemberTypeData%I_lmg_u)) then
      deallocate(MemberTypeData%I_lmg_u)
   end if
   if (allocated(MemberTypeData%I_rmg_l)) then
      deallocate(MemberTypeData%I_rmg_l)
   end if
   if (allocated(MemberTypeData%I_rmg_u)) then
      deallocate(MemberTypeData%I_rmg_u)
   end if
   if (allocated(MemberTypeData%I_xmg_l)) then
      deallocate(MemberTypeData%I_xmg_l)
   end if
   if (allocated(MemberTypeData%I_xmg_u)) then
      deallocate(MemberTypeData%I_xmg_u)
   end if
   if (allocated(MemberTypeData%I_ymg_l)) then
      deallocate(MemberTypeData%I_ymg_l)
   end if
   if (allocated(MemberTypeData%I_ymg_u)) then
      deallocate(MemberTypeData%I_ymg_u)
   end if
end subroutine

subroutine Morison_PackMemberType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Morison_MemberType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Morison_PackMemberType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%NodeIndx)
   call RegPack(RF, InData%MemberID)
   call RegPack(RF, InData%NElements)
   call RegPack(RF, InData%RefLength)
   call RegPack(RF, InData%cosPhi_ref)
   call RegPack(RF, InData%dl)
   call RegPack(RF, InData%k)
   call RegPack(RF, InData%kkt)
   call RegPack(RF, InData%Ak)
   call RegPack(RF, InData%x_hat)
   call RegPack(RF, InData%y_hat)
   call RegPackAlloc(RF, InData%R)
   call RegPackAlloc(RF, InData%RMG)
   call RegPackAlloc(RF, InData%RMGB)
   call RegPackAlloc(RF, InData%Rin)
   call RegPackAlloc(RF, InData%Sa)
   call RegPackAlloc(RF, InData%SaMG)
   call RegPackAlloc(RF, InData%SaMGB)
   call RegPackAlloc(RF, InData%Sain)
   call RegPackAlloc(RF, InData%Sb)
   call RegPackAlloc(RF, InData%SbMG)
   call RegPackAlloc(RF, InData%SbMGB)
   call RegPackAlloc(RF, InData%Sbin)
   call RegPackAlloc(RF, InData%tMG)
   call RegPackAlloc(RF, InData%MGdensity)
   call RegPackAlloc(RF, InData%dRdl_mg)
   call RegPackAlloc(RF, InData%dRdl_mg_b)
   call RegPackAlloc(RF, InData%dRdl_in)
   call RegPackAlloc(RF, InData%dSadl_mg)
   call RegPackAlloc(RF, InData%dSadl_mg_b)
   call RegPackAlloc(RF, InData%dSadl_in)
   call RegPackAlloc(RF, InData%dSbdl_mg)
   call RegPackAlloc(RF, InData%dSbdl_mg_b)
   call RegPackAlloc(RF, InData%dSbdl_in)
   call RegPack(RF, InData%Vinner)
   call RegPack(RF, InData%Vouter)
   call RegPack(RF, InData%Vballast)
   call RegPack(RF, InData%Vsubmerged)
   call RegPack(RF, InData%elem_fill)
   call RegPack(RF, InData%l_fill)
   call RegPack(RF, InData%h_fill)
   call RegPack(RF, InData%z_overfill)
   call RegPack(RF, InData%h_floor)
   call RegPack(RF, InData%i_floor)
   call RegPack(RF, InData%doEndBuoyancy)
   call RegPack(RF, InData%memfloodstatus)
   call RegPackAlloc(RF, InData%floodstatus)
   call RegPackAlloc(RF, InData%alpha)
   call RegPackAlloc(RF, InData%alpha_fb)
   call RegPackAlloc(RF, InData%alpha_fb_star)
   call RegPackAlloc(RF, InData%Cd)
   call RegPackAlloc(RF, InData%Ca)
   call RegPackAlloc(RF, InData%CdA)
   call RegPackAlloc(RF, InData%CaA)
   call RegPackAlloc(RF, InData%CdB)
   call RegPackAlloc(RF, InData%CaB)
   call RegPackAlloc(RF, InData%Cp)
   call RegPackAlloc(RF, InData%AxCd)
   call RegPackAlloc(RF, InData%AxCa)
   call RegPackAlloc(RF, InData%AxCp)
   call RegPackAlloc(RF, InData%Cb)
   call RegPackAlloc(RF, InData%m_fb_l)
   call RegPackAlloc(RF, InData%m_fb_u)
   call RegPackAlloc(RF, InData%h_cfb_l)
   call RegPackAlloc(RF, InData%h_cfb_u)
   call RegPackAlloc(RF, InData%I_lfb_l)
   call RegPackAlloc(RF, InData%I_lfb_u)
   call RegPackAlloc(RF, InData%I_rfb_l)
   call RegPackAlloc(RF, InData%I_rfb_u)
   call RegPackAlloc(RF, InData%I_xfb_l)
   call RegPackAlloc(RF, InData%I_xfb_u)
   call RegPackAlloc(RF, InData%I_yfb_l)
   call RegPackAlloc(RF, InData%I_yfb_u)
   call RegPackAlloc(RF, InData%m_mg_l)
   call RegPackAlloc(RF, InData%m_mg_u)
   call RegPackAlloc(RF, InData%h_cmg_l)
   call RegPackAlloc(RF, InData%h_cmg_u)
   call RegPackAlloc(RF, InData%I_lmg_l)
   call RegPackAlloc(RF, InData%I_lmg_u)
   call RegPackAlloc(RF, InData%I_rmg_l)
   call RegPackAlloc(RF, InData%I_rmg_u)
   call RegPackAlloc(RF, InData%I_xmg_l)
   call RegPackAlloc(RF, InData%I_xmg_u)
   call RegPackAlloc(RF, InData%I_ymg_l)
   call RegPackAlloc(RF, InData%I_ymg_u)
   call RegPack(RF, InData%MGvolume)
   call RegPack(RF, InData%MSecGeom)
   call RegPack(RF, InData%MSpinOrient)
   call RegPack(RF, InData%MDivSize)
   call RegPack(RF, InData%MCoefMod)
   call RegPack(RF, InData%MmbrCoefIDIndx)
   call RegPack(RF, InData%MmbrFilledIDIndx)
   call RegPack(RF, InData%MHstLMod)
   call RegPack(RF, InData%FillFSLoc)
   call RegPack(RF, InData%FillDens)
   call RegPack(RF, InData%PropPot)
   call RegPack(RF, InData%PropMCF)
   call RegPack(RF, InData%Flipped)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_UnPackMemberType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Morison_MemberType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Morison_UnPackMemberType'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%NodeIndx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberID); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NElements); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RefLength); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%cosPhi_ref); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%kkt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Ak); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%x_hat); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%y_hat); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%R); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RMG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RMGB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Rin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Sa); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%SaMG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%SaMGB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Sain); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Sb); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%SbMG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%SbMGB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Sbin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%tMG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%MGdensity); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%dRdl_mg); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%dRdl_mg_b); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%dRdl_in); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%dSadl_mg); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%dSadl_mg_b); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%dSadl_in); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%dSbdl_mg); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%dSbdl_mg_b); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%dSbdl_in); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Vinner); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Vouter); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Vballast); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Vsubmerged); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%elem_fill); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%l_fill); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%h_fill); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%z_overfill); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%h_floor); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%i_floor); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%doEndBuoyancy); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%memfloodstatus); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%floodstatus); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%alpha); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%alpha_fb); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%alpha_fb_star); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Cd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Ca); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%CdA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%CaA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%CdB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%CaB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Cp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AxCd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AxCa); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AxCp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Cb); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%m_fb_l); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%m_fb_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%h_cfb_l); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%h_cfb_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%I_lfb_l); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%I_lfb_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%I_rfb_l); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%I_rfb_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%I_xfb_l); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%I_xfb_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%I_yfb_l); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%I_yfb_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%m_mg_l); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%m_mg_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%h_cmg_l); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%h_cmg_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%I_lmg_l); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%I_lmg_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%I_rmg_l); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%I_rmg_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%I_xmg_l); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%I_xmg_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%I_ymg_l); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%I_ymg_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MGvolume); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MSecGeom); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MSpinOrient); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MDivSize); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MCoefMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MmbrCoefIDIndx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MmbrFilledIDIndx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MHstLMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FillFSLoc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FillDens); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PropPot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PropMCF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Flipped); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_CopyMemberLoads(SrcMemberLoadsData, DstMemberLoadsData, CtrlCode, ErrStat, ErrMsg)
   type(Morison_MemberLoads), intent(in) :: SrcMemberLoadsData
   type(Morison_MemberLoads), intent(inout) :: DstMemberLoadsData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'Morison_CopyMemberLoads'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcMemberLoadsData%F_D)) then
      LB(1:2) = lbound(SrcMemberLoadsData%F_D)
      UB(1:2) = ubound(SrcMemberLoadsData%F_D)
      if (.not. allocated(DstMemberLoadsData%F_D)) then
         allocate(DstMemberLoadsData%F_D(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberLoadsData%F_D.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberLoadsData%F_D = SrcMemberLoadsData%F_D
   end if
   if (allocated(SrcMemberLoadsData%F_I)) then
      LB(1:2) = lbound(SrcMemberLoadsData%F_I)
      UB(1:2) = ubound(SrcMemberLoadsData%F_I)
      if (.not. allocated(DstMemberLoadsData%F_I)) then
         allocate(DstMemberLoadsData%F_I(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberLoadsData%F_I.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberLoadsData%F_I = SrcMemberLoadsData%F_I
   end if
   if (allocated(SrcMemberLoadsData%F_A)) then
      LB(1:2) = lbound(SrcMemberLoadsData%F_A)
      UB(1:2) = ubound(SrcMemberLoadsData%F_A)
      if (.not. allocated(DstMemberLoadsData%F_A)) then
         allocate(DstMemberLoadsData%F_A(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberLoadsData%F_A.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberLoadsData%F_A = SrcMemberLoadsData%F_A
   end if
   if (allocated(SrcMemberLoadsData%F_B)) then
      LB(1:2) = lbound(SrcMemberLoadsData%F_B)
      UB(1:2) = ubound(SrcMemberLoadsData%F_B)
      if (.not. allocated(DstMemberLoadsData%F_B)) then
         allocate(DstMemberLoadsData%F_B(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberLoadsData%F_B.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberLoadsData%F_B = SrcMemberLoadsData%F_B
   end if
   if (allocated(SrcMemberLoadsData%F_BF)) then
      LB(1:2) = lbound(SrcMemberLoadsData%F_BF)
      UB(1:2) = ubound(SrcMemberLoadsData%F_BF)
      if (.not. allocated(DstMemberLoadsData%F_BF)) then
         allocate(DstMemberLoadsData%F_BF(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberLoadsData%F_BF.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberLoadsData%F_BF = SrcMemberLoadsData%F_BF
   end if
   if (allocated(SrcMemberLoadsData%F_If)) then
      LB(1:2) = lbound(SrcMemberLoadsData%F_If)
      UB(1:2) = ubound(SrcMemberLoadsData%F_If)
      if (.not. allocated(DstMemberLoadsData%F_If)) then
         allocate(DstMemberLoadsData%F_If(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberLoadsData%F_If.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberLoadsData%F_If = SrcMemberLoadsData%F_If
   end if
   if (allocated(SrcMemberLoadsData%F_WMG)) then
      LB(1:2) = lbound(SrcMemberLoadsData%F_WMG)
      UB(1:2) = ubound(SrcMemberLoadsData%F_WMG)
      if (.not. allocated(DstMemberLoadsData%F_WMG)) then
         allocate(DstMemberLoadsData%F_WMG(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberLoadsData%F_WMG.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberLoadsData%F_WMG = SrcMemberLoadsData%F_WMG
   end if
   if (allocated(SrcMemberLoadsData%F_IMG)) then
      LB(1:2) = lbound(SrcMemberLoadsData%F_IMG)
      UB(1:2) = ubound(SrcMemberLoadsData%F_IMG)
      if (.not. allocated(DstMemberLoadsData%F_IMG)) then
         allocate(DstMemberLoadsData%F_IMG(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberLoadsData%F_IMG.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberLoadsData%F_IMG = SrcMemberLoadsData%F_IMG
   end if
   if (allocated(SrcMemberLoadsData%FV)) then
      LB(1:2) = lbound(SrcMemberLoadsData%FV)
      UB(1:2) = ubound(SrcMemberLoadsData%FV)
      if (.not. allocated(DstMemberLoadsData%FV)) then
         allocate(DstMemberLoadsData%FV(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberLoadsData%FV.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberLoadsData%FV = SrcMemberLoadsData%FV
   end if
   if (allocated(SrcMemberLoadsData%FA)) then
      LB(1:2) = lbound(SrcMemberLoadsData%FA)
      UB(1:2) = ubound(SrcMemberLoadsData%FA)
      if (.not. allocated(DstMemberLoadsData%FA)) then
         allocate(DstMemberLoadsData%FA(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberLoadsData%FA.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberLoadsData%FA = SrcMemberLoadsData%FA
   end if
   if (allocated(SrcMemberLoadsData%F_DP)) then
      LB(1:2) = lbound(SrcMemberLoadsData%F_DP)
      UB(1:2) = ubound(SrcMemberLoadsData%F_DP)
      if (.not. allocated(DstMemberLoadsData%F_DP)) then
         allocate(DstMemberLoadsData%F_DP(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMemberLoadsData%F_DP.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMemberLoadsData%F_DP = SrcMemberLoadsData%F_DP
   end if
end subroutine

subroutine Morison_DestroyMemberLoads(MemberLoadsData, ErrStat, ErrMsg)
   type(Morison_MemberLoads), intent(inout) :: MemberLoadsData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Morison_DestroyMemberLoads'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(MemberLoadsData%F_D)) then
      deallocate(MemberLoadsData%F_D)
   end if
   if (allocated(MemberLoadsData%F_I)) then
      deallocate(MemberLoadsData%F_I)
   end if
   if (allocated(MemberLoadsData%F_A)) then
      deallocate(MemberLoadsData%F_A)
   end if
   if (allocated(MemberLoadsData%F_B)) then
      deallocate(MemberLoadsData%F_B)
   end if
   if (allocated(MemberLoadsData%F_BF)) then
      deallocate(MemberLoadsData%F_BF)
   end if
   if (allocated(MemberLoadsData%F_If)) then
      deallocate(MemberLoadsData%F_If)
   end if
   if (allocated(MemberLoadsData%F_WMG)) then
      deallocate(MemberLoadsData%F_WMG)
   end if
   if (allocated(MemberLoadsData%F_IMG)) then
      deallocate(MemberLoadsData%F_IMG)
   end if
   if (allocated(MemberLoadsData%FV)) then
      deallocate(MemberLoadsData%FV)
   end if
   if (allocated(MemberLoadsData%FA)) then
      deallocate(MemberLoadsData%FA)
   end if
   if (allocated(MemberLoadsData%F_DP)) then
      deallocate(MemberLoadsData%F_DP)
   end if
end subroutine

subroutine Morison_PackMemberLoads(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Morison_MemberLoads), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Morison_PackMemberLoads'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%F_D)
   call RegPackAlloc(RF, InData%F_I)
   call RegPackAlloc(RF, InData%F_A)
   call RegPackAlloc(RF, InData%F_B)
   call RegPackAlloc(RF, InData%F_BF)
   call RegPackAlloc(RF, InData%F_If)
   call RegPackAlloc(RF, InData%F_WMG)
   call RegPackAlloc(RF, InData%F_IMG)
   call RegPackAlloc(RF, InData%FV)
   call RegPackAlloc(RF, InData%FA)
   call RegPackAlloc(RF, InData%F_DP)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_UnPackMemberLoads(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Morison_MemberLoads), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Morison_UnPackMemberLoads'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%F_D); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%F_I); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%F_A); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%F_B); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%F_BF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%F_If); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%F_WMG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%F_IMG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%FV); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%FA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%F_DP); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_CopyCoefMembersCyl(SrcCoefMembersCylData, DstCoefMembersCylData, CtrlCode, ErrStat, ErrMsg)
   type(Morison_CoefMembersCyl), intent(in) :: SrcCoefMembersCylData
   type(Morison_CoefMembersCyl), intent(inout) :: DstCoefMembersCylData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Morison_CopyCoefMembersCyl'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstCoefMembersCylData%MemberID = SrcCoefMembersCylData%MemberID
   DstCoefMembersCylData%MemberCd1 = SrcCoefMembersCylData%MemberCd1
   DstCoefMembersCylData%MemberCd2 = SrcCoefMembersCylData%MemberCd2
   DstCoefMembersCylData%MemberCdMG1 = SrcCoefMembersCylData%MemberCdMG1
   DstCoefMembersCylData%MemberCdMG2 = SrcCoefMembersCylData%MemberCdMG2
   DstCoefMembersCylData%MemberCa1 = SrcCoefMembersCylData%MemberCa1
   DstCoefMembersCylData%MemberCa2 = SrcCoefMembersCylData%MemberCa2
   DstCoefMembersCylData%MemberCaMG1 = SrcCoefMembersCylData%MemberCaMG1
   DstCoefMembersCylData%MemberCaMG2 = SrcCoefMembersCylData%MemberCaMG2
   DstCoefMembersCylData%MemberCp1 = SrcCoefMembersCylData%MemberCp1
   DstCoefMembersCylData%MemberCp2 = SrcCoefMembersCylData%MemberCp2
   DstCoefMembersCylData%MemberCpMG1 = SrcCoefMembersCylData%MemberCpMG1
   DstCoefMembersCylData%MemberCpMG2 = SrcCoefMembersCylData%MemberCpMG2
   DstCoefMembersCylData%MemberAxCd1 = SrcCoefMembersCylData%MemberAxCd1
   DstCoefMembersCylData%MemberAxCd2 = SrcCoefMembersCylData%MemberAxCd2
   DstCoefMembersCylData%MemberAxCdMG1 = SrcCoefMembersCylData%MemberAxCdMG1
   DstCoefMembersCylData%MemberAxCdMG2 = SrcCoefMembersCylData%MemberAxCdMG2
   DstCoefMembersCylData%MemberAxCa1 = SrcCoefMembersCylData%MemberAxCa1
   DstCoefMembersCylData%MemberAxCa2 = SrcCoefMembersCylData%MemberAxCa2
   DstCoefMembersCylData%MemberAxCaMG1 = SrcCoefMembersCylData%MemberAxCaMG1
   DstCoefMembersCylData%MemberAxCaMG2 = SrcCoefMembersCylData%MemberAxCaMG2
   DstCoefMembersCylData%MemberAxCp1 = SrcCoefMembersCylData%MemberAxCp1
   DstCoefMembersCylData%MemberAxCp2 = SrcCoefMembersCylData%MemberAxCp2
   DstCoefMembersCylData%MemberAxCpMG1 = SrcCoefMembersCylData%MemberAxCpMG1
   DstCoefMembersCylData%MemberAxCpMG2 = SrcCoefMembersCylData%MemberAxCpMG2
   DstCoefMembersCylData%MemberCb1 = SrcCoefMembersCylData%MemberCb1
   DstCoefMembersCylData%MemberCb2 = SrcCoefMembersCylData%MemberCb2
   DstCoefMembersCylData%MemberCbMG1 = SrcCoefMembersCylData%MemberCbMG1
   DstCoefMembersCylData%MemberCbMG2 = SrcCoefMembersCylData%MemberCbMG2
   DstCoefMembersCylData%MemberMCF = SrcCoefMembersCylData%MemberMCF
end subroutine

subroutine Morison_DestroyCoefMembersCyl(CoefMembersCylData, ErrStat, ErrMsg)
   type(Morison_CoefMembersCyl), intent(inout) :: CoefMembersCylData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Morison_DestroyCoefMembersCyl'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine Morison_PackCoefMembersCyl(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Morison_CoefMembersCyl), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Morison_PackCoefMembersCyl'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%MemberID)
   call RegPack(RF, InData%MemberCd1)
   call RegPack(RF, InData%MemberCd2)
   call RegPack(RF, InData%MemberCdMG1)
   call RegPack(RF, InData%MemberCdMG2)
   call RegPack(RF, InData%MemberCa1)
   call RegPack(RF, InData%MemberCa2)
   call RegPack(RF, InData%MemberCaMG1)
   call RegPack(RF, InData%MemberCaMG2)
   call RegPack(RF, InData%MemberCp1)
   call RegPack(RF, InData%MemberCp2)
   call RegPack(RF, InData%MemberCpMG1)
   call RegPack(RF, InData%MemberCpMG2)
   call RegPack(RF, InData%MemberAxCd1)
   call RegPack(RF, InData%MemberAxCd2)
   call RegPack(RF, InData%MemberAxCdMG1)
   call RegPack(RF, InData%MemberAxCdMG2)
   call RegPack(RF, InData%MemberAxCa1)
   call RegPack(RF, InData%MemberAxCa2)
   call RegPack(RF, InData%MemberAxCaMG1)
   call RegPack(RF, InData%MemberAxCaMG2)
   call RegPack(RF, InData%MemberAxCp1)
   call RegPack(RF, InData%MemberAxCp2)
   call RegPack(RF, InData%MemberAxCpMG1)
   call RegPack(RF, InData%MemberAxCpMG2)
   call RegPack(RF, InData%MemberCb1)
   call RegPack(RF, InData%MemberCb2)
   call RegPack(RF, InData%MemberCbMG1)
   call RegPack(RF, InData%MemberCbMG2)
   call RegPack(RF, InData%MemberMCF)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_UnPackCoefMembersCyl(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Morison_CoefMembersCyl), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Morison_UnPackCoefMembersCyl'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%MemberID); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberCd1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberCd2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberCdMG1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberCdMG2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberCa1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberCa2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberCaMG1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberCaMG2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberCp1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberCp2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberCpMG1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberCpMG2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberAxCd1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberAxCd2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberAxCdMG1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberAxCdMG2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberAxCa1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberAxCa2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberAxCaMG1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberAxCaMG2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberAxCp1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberAxCp2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberAxCpMG1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberAxCpMG2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberCb1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberCb2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberCbMG1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberCbMG2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberMCF); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_CopyCoefMembersRec(SrcCoefMembersRecData, DstCoefMembersRecData, CtrlCode, ErrStat, ErrMsg)
   type(Morison_CoefMembersRec), intent(in) :: SrcCoefMembersRecData
   type(Morison_CoefMembersRec), intent(inout) :: DstCoefMembersRecData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Morison_CopyCoefMembersRec'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstCoefMembersRecData%MemberID = SrcCoefMembersRecData%MemberID
   DstCoefMembersRecData%MemberCdA1 = SrcCoefMembersRecData%MemberCdA1
   DstCoefMembersRecData%MemberCdA2 = SrcCoefMembersRecData%MemberCdA2
   DstCoefMembersRecData%MemberCdAMG1 = SrcCoefMembersRecData%MemberCdAMG1
   DstCoefMembersRecData%MemberCdAMG2 = SrcCoefMembersRecData%MemberCdAMG2
   DstCoefMembersRecData%MemberCdB1 = SrcCoefMembersRecData%MemberCdB1
   DstCoefMembersRecData%MemberCdB2 = SrcCoefMembersRecData%MemberCdB2
   DstCoefMembersRecData%MemberCdBMG1 = SrcCoefMembersRecData%MemberCdBMG1
   DstCoefMembersRecData%MemberCdBMG2 = SrcCoefMembersRecData%MemberCdBMG2
   DstCoefMembersRecData%MemberCaA1 = SrcCoefMembersRecData%MemberCaA1
   DstCoefMembersRecData%MemberCaA2 = SrcCoefMembersRecData%MemberCaA2
   DstCoefMembersRecData%MemberCaAMG1 = SrcCoefMembersRecData%MemberCaAMG1
   DstCoefMembersRecData%MemberCaAMG2 = SrcCoefMembersRecData%MemberCaAMG2
   DstCoefMembersRecData%MemberCaB1 = SrcCoefMembersRecData%MemberCaB1
   DstCoefMembersRecData%MemberCaB2 = SrcCoefMembersRecData%MemberCaB2
   DstCoefMembersRecData%MemberCaBMG1 = SrcCoefMembersRecData%MemberCaBMG1
   DstCoefMembersRecData%MemberCaBMG2 = SrcCoefMembersRecData%MemberCaBMG2
   DstCoefMembersRecData%MemberCp1 = SrcCoefMembersRecData%MemberCp1
   DstCoefMembersRecData%MemberCp2 = SrcCoefMembersRecData%MemberCp2
   DstCoefMembersRecData%MemberCpMG1 = SrcCoefMembersRecData%MemberCpMG1
   DstCoefMembersRecData%MemberCpMG2 = SrcCoefMembersRecData%MemberCpMG2
   DstCoefMembersRecData%MemberAxCd1 = SrcCoefMembersRecData%MemberAxCd1
   DstCoefMembersRecData%MemberAxCd2 = SrcCoefMembersRecData%MemberAxCd2
   DstCoefMembersRecData%MemberAxCdMG1 = SrcCoefMembersRecData%MemberAxCdMG1
   DstCoefMembersRecData%MemberAxCdMG2 = SrcCoefMembersRecData%MemberAxCdMG2
   DstCoefMembersRecData%MemberAxCa1 = SrcCoefMembersRecData%MemberAxCa1
   DstCoefMembersRecData%MemberAxCa2 = SrcCoefMembersRecData%MemberAxCa2
   DstCoefMembersRecData%MemberAxCaMG1 = SrcCoefMembersRecData%MemberAxCaMG1
   DstCoefMembersRecData%MemberAxCaMG2 = SrcCoefMembersRecData%MemberAxCaMG2
   DstCoefMembersRecData%MemberAxCp1 = SrcCoefMembersRecData%MemberAxCp1
   DstCoefMembersRecData%MemberAxCp2 = SrcCoefMembersRecData%MemberAxCp2
   DstCoefMembersRecData%MemberAxCpMG1 = SrcCoefMembersRecData%MemberAxCpMG1
   DstCoefMembersRecData%MemberAxCpMG2 = SrcCoefMembersRecData%MemberAxCpMG2
   DstCoefMembersRecData%MemberCb1 = SrcCoefMembersRecData%MemberCb1
   DstCoefMembersRecData%MemberCb2 = SrcCoefMembersRecData%MemberCb2
   DstCoefMembersRecData%MemberCbMG1 = SrcCoefMembersRecData%MemberCbMG1
   DstCoefMembersRecData%MemberCbMG2 = SrcCoefMembersRecData%MemberCbMG2
   DstCoefMembersRecData%MemberMCF = SrcCoefMembersRecData%MemberMCF
end subroutine

subroutine Morison_DestroyCoefMembersRec(CoefMembersRecData, ErrStat, ErrMsg)
   type(Morison_CoefMembersRec), intent(inout) :: CoefMembersRecData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Morison_DestroyCoefMembersRec'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine Morison_PackCoefMembersRec(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Morison_CoefMembersRec), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Morison_PackCoefMembersRec'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%MemberID)
   call RegPack(RF, InData%MemberCdA1)
   call RegPack(RF, InData%MemberCdA2)
   call RegPack(RF, InData%MemberCdAMG1)
   call RegPack(RF, InData%MemberCdAMG2)
   call RegPack(RF, InData%MemberCdB1)
   call RegPack(RF, InData%MemberCdB2)
   call RegPack(RF, InData%MemberCdBMG1)
   call RegPack(RF, InData%MemberCdBMG2)
   call RegPack(RF, InData%MemberCaA1)
   call RegPack(RF, InData%MemberCaA2)
   call RegPack(RF, InData%MemberCaAMG1)
   call RegPack(RF, InData%MemberCaAMG2)
   call RegPack(RF, InData%MemberCaB1)
   call RegPack(RF, InData%MemberCaB2)
   call RegPack(RF, InData%MemberCaBMG1)
   call RegPack(RF, InData%MemberCaBMG2)
   call RegPack(RF, InData%MemberCp1)
   call RegPack(RF, InData%MemberCp2)
   call RegPack(RF, InData%MemberCpMG1)
   call RegPack(RF, InData%MemberCpMG2)
   call RegPack(RF, InData%MemberAxCd1)
   call RegPack(RF, InData%MemberAxCd2)
   call RegPack(RF, InData%MemberAxCdMG1)
   call RegPack(RF, InData%MemberAxCdMG2)
   call RegPack(RF, InData%MemberAxCa1)
   call RegPack(RF, InData%MemberAxCa2)
   call RegPack(RF, InData%MemberAxCaMG1)
   call RegPack(RF, InData%MemberAxCaMG2)
   call RegPack(RF, InData%MemberAxCp1)
   call RegPack(RF, InData%MemberAxCp2)
   call RegPack(RF, InData%MemberAxCpMG1)
   call RegPack(RF, InData%MemberAxCpMG2)
   call RegPack(RF, InData%MemberCb1)
   call RegPack(RF, InData%MemberCb2)
   call RegPack(RF, InData%MemberCbMG1)
   call RegPack(RF, InData%MemberCbMG2)
   call RegPack(RF, InData%MemberMCF)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_UnPackCoefMembersRec(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Morison_CoefMembersRec), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Morison_UnPackCoefMembersRec'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%MemberID); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberCdA1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberCdA2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberCdAMG1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberCdAMG2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberCdB1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberCdB2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberCdBMG1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberCdBMG2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberCaA1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberCaA2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberCaAMG1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberCaAMG2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberCaB1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberCaB2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberCaBMG1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberCaBMG2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberCp1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberCp2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberCpMG1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberCpMG2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberAxCd1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberAxCd2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberAxCdMG1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberAxCdMG2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberAxCa1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberAxCa2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberAxCaMG1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberAxCaMG2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberAxCp1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberAxCp2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberAxCpMG1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberAxCpMG2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberCb1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberCb2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberCbMG1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberCbMG2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberMCF); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_CopyMGDepthsType(SrcMGDepthsTypeData, DstMGDepthsTypeData, CtrlCode, ErrStat, ErrMsg)
   type(Morison_MGDepthsType), intent(in) :: SrcMGDepthsTypeData
   type(Morison_MGDepthsType), intent(inout) :: DstMGDepthsTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Morison_CopyMGDepthsType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstMGDepthsTypeData%MGDpth = SrcMGDepthsTypeData%MGDpth
   DstMGDepthsTypeData%MGThck = SrcMGDepthsTypeData%MGThck
   DstMGDepthsTypeData%MGDens = SrcMGDepthsTypeData%MGDens
end subroutine

subroutine Morison_DestroyMGDepthsType(MGDepthsTypeData, ErrStat, ErrMsg)
   type(Morison_MGDepthsType), intent(inout) :: MGDepthsTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Morison_DestroyMGDepthsType'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine Morison_PackMGDepthsType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Morison_MGDepthsType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Morison_PackMGDepthsType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%MGDpth)
   call RegPack(RF, InData%MGThck)
   call RegPack(RF, InData%MGDens)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_UnPackMGDepthsType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Morison_MGDepthsType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Morison_UnPackMGDepthsType'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%MGDpth); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MGThck); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MGDens); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_CopyMOutput(SrcMOutputData, DstMOutputData, CtrlCode, ErrStat, ErrMsg)
   type(Morison_MOutput), intent(in) :: SrcMOutputData
   type(Morison_MOutput), intent(inout) :: DstMOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'Morison_CopyMOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstMOutputData%MemberID = SrcMOutputData%MemberID
   DstMOutputData%NOutLoc = SrcMOutputData%NOutLoc
   if (allocated(SrcMOutputData%NodeLocs)) then
      LB(1:1) = lbound(SrcMOutputData%NodeLocs)
      UB(1:1) = ubound(SrcMOutputData%NodeLocs)
      if (.not. allocated(DstMOutputData%NodeLocs)) then
         allocate(DstMOutputData%NodeLocs(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMOutputData%NodeLocs.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMOutputData%NodeLocs = SrcMOutputData%NodeLocs
   end if
   DstMOutputData%MemberIDIndx = SrcMOutputData%MemberIDIndx
   if (allocated(SrcMOutputData%MeshIndx1)) then
      LB(1:1) = lbound(SrcMOutputData%MeshIndx1)
      UB(1:1) = ubound(SrcMOutputData%MeshIndx1)
      if (.not. allocated(DstMOutputData%MeshIndx1)) then
         allocate(DstMOutputData%MeshIndx1(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMOutputData%MeshIndx1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMOutputData%MeshIndx1 = SrcMOutputData%MeshIndx1
   end if
   if (allocated(SrcMOutputData%MeshIndx2)) then
      LB(1:1) = lbound(SrcMOutputData%MeshIndx2)
      UB(1:1) = ubound(SrcMOutputData%MeshIndx2)
      if (.not. allocated(DstMOutputData%MeshIndx2)) then
         allocate(DstMOutputData%MeshIndx2(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMOutputData%MeshIndx2.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMOutputData%MeshIndx2 = SrcMOutputData%MeshIndx2
   end if
   if (allocated(SrcMOutputData%MemberIndx1)) then
      LB(1:1) = lbound(SrcMOutputData%MemberIndx1)
      UB(1:1) = ubound(SrcMOutputData%MemberIndx1)
      if (.not. allocated(DstMOutputData%MemberIndx1)) then
         allocate(DstMOutputData%MemberIndx1(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMOutputData%MemberIndx1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMOutputData%MemberIndx1 = SrcMOutputData%MemberIndx1
   end if
   if (allocated(SrcMOutputData%MemberIndx2)) then
      LB(1:1) = lbound(SrcMOutputData%MemberIndx2)
      UB(1:1) = ubound(SrcMOutputData%MemberIndx2)
      if (.not. allocated(DstMOutputData%MemberIndx2)) then
         allocate(DstMOutputData%MemberIndx2(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMOutputData%MemberIndx2.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMOutputData%MemberIndx2 = SrcMOutputData%MemberIndx2
   end if
   if (allocated(SrcMOutputData%s)) then
      LB(1:1) = lbound(SrcMOutputData%s)
      UB(1:1) = ubound(SrcMOutputData%s)
      if (.not. allocated(DstMOutputData%s)) then
         allocate(DstMOutputData%s(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMOutputData%s.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMOutputData%s = SrcMOutputData%s
   end if
end subroutine

subroutine Morison_DestroyMOutput(MOutputData, ErrStat, ErrMsg)
   type(Morison_MOutput), intent(inout) :: MOutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Morison_DestroyMOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(MOutputData%NodeLocs)) then
      deallocate(MOutputData%NodeLocs)
   end if
   if (allocated(MOutputData%MeshIndx1)) then
      deallocate(MOutputData%MeshIndx1)
   end if
   if (allocated(MOutputData%MeshIndx2)) then
      deallocate(MOutputData%MeshIndx2)
   end if
   if (allocated(MOutputData%MemberIndx1)) then
      deallocate(MOutputData%MemberIndx1)
   end if
   if (allocated(MOutputData%MemberIndx2)) then
      deallocate(MOutputData%MemberIndx2)
   end if
   if (allocated(MOutputData%s)) then
      deallocate(MOutputData%s)
   end if
end subroutine

subroutine Morison_PackMOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Morison_MOutput), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Morison_PackMOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%MemberID)
   call RegPack(RF, InData%NOutLoc)
   call RegPackAlloc(RF, InData%NodeLocs)
   call RegPack(RF, InData%MemberIDIndx)
   call RegPackAlloc(RF, InData%MeshIndx1)
   call RegPackAlloc(RF, InData%MeshIndx2)
   call RegPackAlloc(RF, InData%MemberIndx1)
   call RegPackAlloc(RF, InData%MemberIndx2)
   call RegPackAlloc(RF, InData%s)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_UnPackMOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Morison_MOutput), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Morison_UnPackMOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%MemberID); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NOutLoc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%NodeLocs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MemberIDIndx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%MeshIndx1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%MeshIndx2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%MemberIndx1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%MemberIndx2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%s); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_CopyJOutput(SrcJOutputData, DstJOutputData, CtrlCode, ErrStat, ErrMsg)
   type(Morison_JOutput), intent(in) :: SrcJOutputData
   type(Morison_JOutput), intent(inout) :: DstJOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Morison_CopyJOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstJOutputData%JointID = SrcJOutputData%JointID
   DstJOutputData%JointIDIndx = SrcJOutputData%JointIDIndx
end subroutine

subroutine Morison_DestroyJOutput(JOutputData, ErrStat, ErrMsg)
   type(Morison_JOutput), intent(inout) :: JOutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Morison_DestroyJOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine Morison_PackJOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Morison_JOutput), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Morison_PackJOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%JointID)
   call RegPack(RF, InData%JointIDIndx)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_UnPackJOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Morison_JOutput), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Morison_UnPackJOutput'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%JointID); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%JointIDIndx); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_CopyInitInput(SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg)
   type(Morison_InitInputType), intent(in) :: SrcInitInputData
   type(Morison_InitInputType), intent(inout) :: DstInitInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'Morison_CopyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInitInputData%Gravity = SrcInitInputData%Gravity
   DstInitInputData%WaveDisp = SrcInitInputData%WaveDisp
   DstInitInputData%AMMod = SrcInitInputData%AMMod
   DstInitInputData%NJoints = SrcInitInputData%NJoints
   DstInitInputData%NNodes = SrcInitInputData%NNodes
   if (allocated(SrcInitInputData%InpJoints)) then
      LB(1:1) = lbound(SrcInitInputData%InpJoints)
      UB(1:1) = ubound(SrcInitInputData%InpJoints)
      if (.not. allocated(DstInitInputData%InpJoints)) then
         allocate(DstInitInputData%InpJoints(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%InpJoints.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call Morison_CopyJointType(SrcInitInputData%InpJoints(i1), DstInitInputData%InpJoints(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcInitInputData%Nodes)) then
      LB(1:1) = lbound(SrcInitInputData%Nodes)
      UB(1:1) = ubound(SrcInitInputData%Nodes)
      if (.not. allocated(DstInitInputData%Nodes)) then
         allocate(DstInitInputData%Nodes(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%Nodes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call Morison_CopyNodeType(SrcInitInputData%Nodes(i1), DstInitInputData%Nodes(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstInitInputData%NAxCoefs = SrcInitInputData%NAxCoefs
   if (allocated(SrcInitInputData%AxialCoefs)) then
      LB(1:1) = lbound(SrcInitInputData%AxialCoefs)
      UB(1:1) = ubound(SrcInitInputData%AxialCoefs)
      if (.not. allocated(DstInitInputData%AxialCoefs)) then
         allocate(DstInitInputData%AxialCoefs(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%AxialCoefs.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call Morison_CopyAxialCoefType(SrcInitInputData%AxialCoefs(i1), DstInitInputData%AxialCoefs(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstInitInputData%NPropSetsCyl = SrcInitInputData%NPropSetsCyl
   if (allocated(SrcInitInputData%MPropSetsCyl)) then
      LB(1:1) = lbound(SrcInitInputData%MPropSetsCyl)
      UB(1:1) = ubound(SrcInitInputData%MPropSetsCyl)
      if (.not. allocated(DstInitInputData%MPropSetsCyl)) then
         allocate(DstInitInputData%MPropSetsCyl(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%MPropSetsCyl.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call Morison_CopyMemberPropTypeCyl(SrcInitInputData%MPropSetsCyl(i1), DstInitInputData%MPropSetsCyl(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstInitInputData%NPropSetsRec = SrcInitInputData%NPropSetsRec
   if (allocated(SrcInitInputData%MPropSetsRec)) then
      LB(1:1) = lbound(SrcInitInputData%MPropSetsRec)
      UB(1:1) = ubound(SrcInitInputData%MPropSetsRec)
      if (.not. allocated(DstInitInputData%MPropSetsRec)) then
         allocate(DstInitInputData%MPropSetsRec(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%MPropSetsRec.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call Morison_CopyMemberPropTypeRec(SrcInitInputData%MPropSetsRec(i1), DstInitInputData%MPropSetsRec(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstInitInputData%SimplCd = SrcInitInputData%SimplCd
   DstInitInputData%SimplCdMG = SrcInitInputData%SimplCdMG
   DstInitInputData%SimplCa = SrcInitInputData%SimplCa
   DstInitInputData%SimplCaMG = SrcInitInputData%SimplCaMG
   DstInitInputData%SimplCp = SrcInitInputData%SimplCp
   DstInitInputData%SimplCpMG = SrcInitInputData%SimplCpMG
   DstInitInputData%SimplAxCd = SrcInitInputData%SimplAxCd
   DstInitInputData%SimplAxCdMG = SrcInitInputData%SimplAxCdMG
   DstInitInputData%SimplAxCa = SrcInitInputData%SimplAxCa
   DstInitInputData%SimplAxCaMG = SrcInitInputData%SimplAxCaMG
   DstInitInputData%SimplAxCp = SrcInitInputData%SimplAxCp
   DstInitInputData%SimplAxCpMG = SrcInitInputData%SimplAxCpMG
   DstInitInputData%SimplCb = SrcInitInputData%SimplCb
   DstInitInputData%SimplCbMg = SrcInitInputData%SimplCbMg
   DstInitInputData%SimplMCF = SrcInitInputData%SimplMCF
   DstInitInputData%SimplRecCdA = SrcInitInputData%SimplRecCdA
   DstInitInputData%SimplRecCdAMG = SrcInitInputData%SimplRecCdAMG
   DstInitInputData%SimplRecCdB = SrcInitInputData%SimplRecCdB
   DstInitInputData%SimplRecCdBMG = SrcInitInputData%SimplRecCdBMG
   DstInitInputData%SimplRecCaA = SrcInitInputData%SimplRecCaA
   DstInitInputData%SimplRecCaAMG = SrcInitInputData%SimplRecCaAMG
   DstInitInputData%SimplRecCaB = SrcInitInputData%SimplRecCaB
   DstInitInputData%SimplRecCaBMG = SrcInitInputData%SimplRecCaBMG
   DstInitInputData%SimplRecCp = SrcInitInputData%SimplRecCp
   DstInitInputData%SimplRecCpMG = SrcInitInputData%SimplRecCpMG
   DstInitInputData%SimplRecAxCd = SrcInitInputData%SimplRecAxCd
   DstInitInputData%SimplRecAxCdMG = SrcInitInputData%SimplRecAxCdMG
   DstInitInputData%SimplRecAxCa = SrcInitInputData%SimplRecAxCa
   DstInitInputData%SimplRecAxCaMG = SrcInitInputData%SimplRecAxCaMG
   DstInitInputData%SimplRecAxCp = SrcInitInputData%SimplRecAxCp
   DstInitInputData%SimplRecAxCpMG = SrcInitInputData%SimplRecAxCpMG
   DstInitInputData%SimplRecCb = SrcInitInputData%SimplRecCb
   DstInitInputData%SimplRecCbMg = SrcInitInputData%SimplRecCbMg
   DstInitInputData%SimplRecMCF = SrcInitInputData%SimplRecMCF
   DstInitInputData%NCoefDpthCyl = SrcInitInputData%NCoefDpthCyl
   if (allocated(SrcInitInputData%CoefDpthsCyl)) then
      LB(1:1) = lbound(SrcInitInputData%CoefDpthsCyl)
      UB(1:1) = ubound(SrcInitInputData%CoefDpthsCyl)
      if (.not. allocated(DstInitInputData%CoefDpthsCyl)) then
         allocate(DstInitInputData%CoefDpthsCyl(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%CoefDpthsCyl.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call Morison_CopyCoefDpthsCyl(SrcInitInputData%CoefDpthsCyl(i1), DstInitInputData%CoefDpthsCyl(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstInitInputData%NCoefDpthRec = SrcInitInputData%NCoefDpthRec
   if (allocated(SrcInitInputData%CoefDpthsRec)) then
      LB(1:1) = lbound(SrcInitInputData%CoefDpthsRec)
      UB(1:1) = ubound(SrcInitInputData%CoefDpthsRec)
      if (.not. allocated(DstInitInputData%CoefDpthsRec)) then
         allocate(DstInitInputData%CoefDpthsRec(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%CoefDpthsRec.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call Morison_CopyCoefDpthsRec(SrcInitInputData%CoefDpthsRec(i1), DstInitInputData%CoefDpthsRec(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstInitInputData%NCoefMembersCyl = SrcInitInputData%NCoefMembersCyl
   if (allocated(SrcInitInputData%CoefMembersCyl)) then
      LB(1:1) = lbound(SrcInitInputData%CoefMembersCyl)
      UB(1:1) = ubound(SrcInitInputData%CoefMembersCyl)
      if (.not. allocated(DstInitInputData%CoefMembersCyl)) then
         allocate(DstInitInputData%CoefMembersCyl(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%CoefMembersCyl.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call Morison_CopyCoefMembersCyl(SrcInitInputData%CoefMembersCyl(i1), DstInitInputData%CoefMembersCyl(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstInitInputData%NCoefMembersRec = SrcInitInputData%NCoefMembersRec
   if (allocated(SrcInitInputData%CoefMembersRec)) then
      LB(1:1) = lbound(SrcInitInputData%CoefMembersRec)
      UB(1:1) = ubound(SrcInitInputData%CoefMembersRec)
      if (.not. allocated(DstInitInputData%CoefMembersRec)) then
         allocate(DstInitInputData%CoefMembersRec(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%CoefMembersRec.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call Morison_CopyCoefMembersRec(SrcInitInputData%CoefMembersRec(i1), DstInitInputData%CoefMembersRec(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstInitInputData%NMembers = SrcInitInputData%NMembers
   if (allocated(SrcInitInputData%InpMembers)) then
      LB(1:1) = lbound(SrcInitInputData%InpMembers)
      UB(1:1) = ubound(SrcInitInputData%InpMembers)
      if (.not. allocated(DstInitInputData%InpMembers)) then
         allocate(DstInitInputData%InpMembers(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%InpMembers.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call Morison_CopyMemberInputType(SrcInitInputData%InpMembers(i1), DstInitInputData%InpMembers(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstInitInputData%NFillGroups = SrcInitInputData%NFillGroups
   if (allocated(SrcInitInputData%FilledGroups)) then
      LB(1:1) = lbound(SrcInitInputData%FilledGroups)
      UB(1:1) = ubound(SrcInitInputData%FilledGroups)
      if (.not. allocated(DstInitInputData%FilledGroups)) then
         allocate(DstInitInputData%FilledGroups(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%FilledGroups.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call Morison_CopyFilledGroupType(SrcInitInputData%FilledGroups(i1), DstInitInputData%FilledGroups(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstInitInputData%NMGDepths = SrcInitInputData%NMGDepths
   if (allocated(SrcInitInputData%MGDepths)) then
      LB(1:1) = lbound(SrcInitInputData%MGDepths)
      UB(1:1) = ubound(SrcInitInputData%MGDepths)
      if (.not. allocated(DstInitInputData%MGDepths)) then
         allocate(DstInitInputData%MGDepths(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%MGDepths.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call Morison_CopyMGDepthsType(SrcInitInputData%MGDepths(i1), DstInitInputData%MGDepths(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstInitInputData%MGTop = SrcInitInputData%MGTop
   DstInitInputData%MGBottom = SrcInitInputData%MGBottom
   DstInitInputData%NMOutputs = SrcInitInputData%NMOutputs
   if (allocated(SrcInitInputData%MOutLst)) then
      LB(1:1) = lbound(SrcInitInputData%MOutLst)
      UB(1:1) = ubound(SrcInitInputData%MOutLst)
      if (.not. allocated(DstInitInputData%MOutLst)) then
         allocate(DstInitInputData%MOutLst(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%MOutLst.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call Morison_CopyMOutput(SrcInitInputData%MOutLst(i1), DstInitInputData%MOutLst(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstInitInputData%NJOutputs = SrcInitInputData%NJOutputs
   if (allocated(SrcInitInputData%JOutLst)) then
      LB(1:1) = lbound(SrcInitInputData%JOutLst)
      UB(1:1) = ubound(SrcInitInputData%JOutLst)
      if (.not. allocated(DstInitInputData%JOutLst)) then
         allocate(DstInitInputData%JOutLst(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%JOutLst.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call Morison_CopyJOutput(SrcInitInputData%JOutLst(i1), DstInitInputData%JOutLst(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcInitInputData%OutList)) then
      LB(1:1) = lbound(SrcInitInputData%OutList)
      UB(1:1) = ubound(SrcInitInputData%OutList)
      if (.not. allocated(DstInitInputData%OutList)) then
         allocate(DstInitInputData%OutList(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%OutList.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%OutList = SrcInitInputData%OutList
   end if
   DstInitInputData%NumOuts = SrcInitInputData%NumOuts
   DstInitInputData%UnSum = SrcInitInputData%UnSum
   DstInitInputData%WaveField => SrcInitInputData%WaveField
   DstInitInputData%VisMeshes = SrcInitInputData%VisMeshes
   DstInitInputData%PtfmYMod = SrcInitInputData%PtfmYMod
end subroutine

subroutine Morison_DestroyInitInput(InitInputData, ErrStat, ErrMsg)
   type(Morison_InitInputType), intent(inout) :: InitInputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'Morison_DestroyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InitInputData%InpJoints)) then
      LB(1:1) = lbound(InitInputData%InpJoints)
      UB(1:1) = ubound(InitInputData%InpJoints)
      do i1 = LB(1), UB(1)
         call Morison_DestroyJointType(InitInputData%InpJoints(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InitInputData%InpJoints)
   end if
   if (allocated(InitInputData%Nodes)) then
      LB(1:1) = lbound(InitInputData%Nodes)
      UB(1:1) = ubound(InitInputData%Nodes)
      do i1 = LB(1), UB(1)
         call Morison_DestroyNodeType(InitInputData%Nodes(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InitInputData%Nodes)
   end if
   if (allocated(InitInputData%AxialCoefs)) then
      LB(1:1) = lbound(InitInputData%AxialCoefs)
      UB(1:1) = ubound(InitInputData%AxialCoefs)
      do i1 = LB(1), UB(1)
         call Morison_DestroyAxialCoefType(InitInputData%AxialCoefs(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InitInputData%AxialCoefs)
   end if
   if (allocated(InitInputData%MPropSetsCyl)) then
      LB(1:1) = lbound(InitInputData%MPropSetsCyl)
      UB(1:1) = ubound(InitInputData%MPropSetsCyl)
      do i1 = LB(1), UB(1)
         call Morison_DestroyMemberPropTypeCyl(InitInputData%MPropSetsCyl(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InitInputData%MPropSetsCyl)
   end if
   if (allocated(InitInputData%MPropSetsRec)) then
      LB(1:1) = lbound(InitInputData%MPropSetsRec)
      UB(1:1) = ubound(InitInputData%MPropSetsRec)
      do i1 = LB(1), UB(1)
         call Morison_DestroyMemberPropTypeRec(InitInputData%MPropSetsRec(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InitInputData%MPropSetsRec)
   end if
   if (allocated(InitInputData%CoefDpthsCyl)) then
      LB(1:1) = lbound(InitInputData%CoefDpthsCyl)
      UB(1:1) = ubound(InitInputData%CoefDpthsCyl)
      do i1 = LB(1), UB(1)
         call Morison_DestroyCoefDpthsCyl(InitInputData%CoefDpthsCyl(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InitInputData%CoefDpthsCyl)
   end if
   if (allocated(InitInputData%CoefDpthsRec)) then
      LB(1:1) = lbound(InitInputData%CoefDpthsRec)
      UB(1:1) = ubound(InitInputData%CoefDpthsRec)
      do i1 = LB(1), UB(1)
         call Morison_DestroyCoefDpthsRec(InitInputData%CoefDpthsRec(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InitInputData%CoefDpthsRec)
   end if
   if (allocated(InitInputData%CoefMembersCyl)) then
      LB(1:1) = lbound(InitInputData%CoefMembersCyl)
      UB(1:1) = ubound(InitInputData%CoefMembersCyl)
      do i1 = LB(1), UB(1)
         call Morison_DestroyCoefMembersCyl(InitInputData%CoefMembersCyl(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InitInputData%CoefMembersCyl)
   end if
   if (allocated(InitInputData%CoefMembersRec)) then
      LB(1:1) = lbound(InitInputData%CoefMembersRec)
      UB(1:1) = ubound(InitInputData%CoefMembersRec)
      do i1 = LB(1), UB(1)
         call Morison_DestroyCoefMembersRec(InitInputData%CoefMembersRec(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InitInputData%CoefMembersRec)
   end if
   if (allocated(InitInputData%InpMembers)) then
      LB(1:1) = lbound(InitInputData%InpMembers)
      UB(1:1) = ubound(InitInputData%InpMembers)
      do i1 = LB(1), UB(1)
         call Morison_DestroyMemberInputType(InitInputData%InpMembers(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InitInputData%InpMembers)
   end if
   if (allocated(InitInputData%FilledGroups)) then
      LB(1:1) = lbound(InitInputData%FilledGroups)
      UB(1:1) = ubound(InitInputData%FilledGroups)
      do i1 = LB(1), UB(1)
         call Morison_DestroyFilledGroupType(InitInputData%FilledGroups(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InitInputData%FilledGroups)
   end if
   if (allocated(InitInputData%MGDepths)) then
      LB(1:1) = lbound(InitInputData%MGDepths)
      UB(1:1) = ubound(InitInputData%MGDepths)
      do i1 = LB(1), UB(1)
         call Morison_DestroyMGDepthsType(InitInputData%MGDepths(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InitInputData%MGDepths)
   end if
   if (allocated(InitInputData%MOutLst)) then
      LB(1:1) = lbound(InitInputData%MOutLst)
      UB(1:1) = ubound(InitInputData%MOutLst)
      do i1 = LB(1), UB(1)
         call Morison_DestroyMOutput(InitInputData%MOutLst(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InitInputData%MOutLst)
   end if
   if (allocated(InitInputData%JOutLst)) then
      LB(1:1) = lbound(InitInputData%JOutLst)
      UB(1:1) = ubound(InitInputData%JOutLst)
      do i1 = LB(1), UB(1)
         call Morison_DestroyJOutput(InitInputData%JOutLst(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InitInputData%JOutLst)
   end if
   if (allocated(InitInputData%OutList)) then
      deallocate(InitInputData%OutList)
   end if
   nullify(InitInputData%WaveField)
end subroutine

subroutine Morison_PackInitInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Morison_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Morison_PackInitInput'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   logical         :: PtrInIndex
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%Gravity)
   call RegPack(RF, InData%WaveDisp)
   call RegPack(RF, InData%AMMod)
   call RegPack(RF, InData%NJoints)
   call RegPack(RF, InData%NNodes)
   call RegPack(RF, allocated(InData%InpJoints))
   if (allocated(InData%InpJoints)) then
      call RegPackBounds(RF, 1, lbound(InData%InpJoints), ubound(InData%InpJoints))
      LB(1:1) = lbound(InData%InpJoints)
      UB(1:1) = ubound(InData%InpJoints)
      do i1 = LB(1), UB(1)
         call Morison_PackJointType(RF, InData%InpJoints(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%Nodes))
   if (allocated(InData%Nodes)) then
      call RegPackBounds(RF, 1, lbound(InData%Nodes), ubound(InData%Nodes))
      LB(1:1) = lbound(InData%Nodes)
      UB(1:1) = ubound(InData%Nodes)
      do i1 = LB(1), UB(1)
         call Morison_PackNodeType(RF, InData%Nodes(i1)) 
      end do
   end if
   call RegPack(RF, InData%NAxCoefs)
   call RegPack(RF, allocated(InData%AxialCoefs))
   if (allocated(InData%AxialCoefs)) then
      call RegPackBounds(RF, 1, lbound(InData%AxialCoefs), ubound(InData%AxialCoefs))
      LB(1:1) = lbound(InData%AxialCoefs)
      UB(1:1) = ubound(InData%AxialCoefs)
      do i1 = LB(1), UB(1)
         call Morison_PackAxialCoefType(RF, InData%AxialCoefs(i1)) 
      end do
   end if
   call RegPack(RF, InData%NPropSetsCyl)
   call RegPack(RF, allocated(InData%MPropSetsCyl))
   if (allocated(InData%MPropSetsCyl)) then
      call RegPackBounds(RF, 1, lbound(InData%MPropSetsCyl), ubound(InData%MPropSetsCyl))
      LB(1:1) = lbound(InData%MPropSetsCyl)
      UB(1:1) = ubound(InData%MPropSetsCyl)
      do i1 = LB(1), UB(1)
         call Morison_PackMemberPropTypeCyl(RF, InData%MPropSetsCyl(i1)) 
      end do
   end if
   call RegPack(RF, InData%NPropSetsRec)
   call RegPack(RF, allocated(InData%MPropSetsRec))
   if (allocated(InData%MPropSetsRec)) then
      call RegPackBounds(RF, 1, lbound(InData%MPropSetsRec), ubound(InData%MPropSetsRec))
      LB(1:1) = lbound(InData%MPropSetsRec)
      UB(1:1) = ubound(InData%MPropSetsRec)
      do i1 = LB(1), UB(1)
         call Morison_PackMemberPropTypeRec(RF, InData%MPropSetsRec(i1)) 
      end do
   end if
   call RegPack(RF, InData%SimplCd)
   call RegPack(RF, InData%SimplCdMG)
   call RegPack(RF, InData%SimplCa)
   call RegPack(RF, InData%SimplCaMG)
   call RegPack(RF, InData%SimplCp)
   call RegPack(RF, InData%SimplCpMG)
   call RegPack(RF, InData%SimplAxCd)
   call RegPack(RF, InData%SimplAxCdMG)
   call RegPack(RF, InData%SimplAxCa)
   call RegPack(RF, InData%SimplAxCaMG)
   call RegPack(RF, InData%SimplAxCp)
   call RegPack(RF, InData%SimplAxCpMG)
   call RegPack(RF, InData%SimplCb)
   call RegPack(RF, InData%SimplCbMg)
   call RegPack(RF, InData%SimplMCF)
   call RegPack(RF, InData%SimplRecCdA)
   call RegPack(RF, InData%SimplRecCdAMG)
   call RegPack(RF, InData%SimplRecCdB)
   call RegPack(RF, InData%SimplRecCdBMG)
   call RegPack(RF, InData%SimplRecCaA)
   call RegPack(RF, InData%SimplRecCaAMG)
   call RegPack(RF, InData%SimplRecCaB)
   call RegPack(RF, InData%SimplRecCaBMG)
   call RegPack(RF, InData%SimplRecCp)
   call RegPack(RF, InData%SimplRecCpMG)
   call RegPack(RF, InData%SimplRecAxCd)
   call RegPack(RF, InData%SimplRecAxCdMG)
   call RegPack(RF, InData%SimplRecAxCa)
   call RegPack(RF, InData%SimplRecAxCaMG)
   call RegPack(RF, InData%SimplRecAxCp)
   call RegPack(RF, InData%SimplRecAxCpMG)
   call RegPack(RF, InData%SimplRecCb)
   call RegPack(RF, InData%SimplRecCbMg)
   call RegPack(RF, InData%SimplRecMCF)
   call RegPack(RF, InData%NCoefDpthCyl)
   call RegPack(RF, allocated(InData%CoefDpthsCyl))
   if (allocated(InData%CoefDpthsCyl)) then
      call RegPackBounds(RF, 1, lbound(InData%CoefDpthsCyl), ubound(InData%CoefDpthsCyl))
      LB(1:1) = lbound(InData%CoefDpthsCyl)
      UB(1:1) = ubound(InData%CoefDpthsCyl)
      do i1 = LB(1), UB(1)
         call Morison_PackCoefDpthsCyl(RF, InData%CoefDpthsCyl(i1)) 
      end do
   end if
   call RegPack(RF, InData%NCoefDpthRec)
   call RegPack(RF, allocated(InData%CoefDpthsRec))
   if (allocated(InData%CoefDpthsRec)) then
      call RegPackBounds(RF, 1, lbound(InData%CoefDpthsRec), ubound(InData%CoefDpthsRec))
      LB(1:1) = lbound(InData%CoefDpthsRec)
      UB(1:1) = ubound(InData%CoefDpthsRec)
      do i1 = LB(1), UB(1)
         call Morison_PackCoefDpthsRec(RF, InData%CoefDpthsRec(i1)) 
      end do
   end if
   call RegPack(RF, InData%NCoefMembersCyl)
   call RegPack(RF, allocated(InData%CoefMembersCyl))
   if (allocated(InData%CoefMembersCyl)) then
      call RegPackBounds(RF, 1, lbound(InData%CoefMembersCyl), ubound(InData%CoefMembersCyl))
      LB(1:1) = lbound(InData%CoefMembersCyl)
      UB(1:1) = ubound(InData%CoefMembersCyl)
      do i1 = LB(1), UB(1)
         call Morison_PackCoefMembersCyl(RF, InData%CoefMembersCyl(i1)) 
      end do
   end if
   call RegPack(RF, InData%NCoefMembersRec)
   call RegPack(RF, allocated(InData%CoefMembersRec))
   if (allocated(InData%CoefMembersRec)) then
      call RegPackBounds(RF, 1, lbound(InData%CoefMembersRec), ubound(InData%CoefMembersRec))
      LB(1:1) = lbound(InData%CoefMembersRec)
      UB(1:1) = ubound(InData%CoefMembersRec)
      do i1 = LB(1), UB(1)
         call Morison_PackCoefMembersRec(RF, InData%CoefMembersRec(i1)) 
      end do
   end if
   call RegPack(RF, InData%NMembers)
   call RegPack(RF, allocated(InData%InpMembers))
   if (allocated(InData%InpMembers)) then
      call RegPackBounds(RF, 1, lbound(InData%InpMembers), ubound(InData%InpMembers))
      LB(1:1) = lbound(InData%InpMembers)
      UB(1:1) = ubound(InData%InpMembers)
      do i1 = LB(1), UB(1)
         call Morison_PackMemberInputType(RF, InData%InpMembers(i1)) 
      end do
   end if
   call RegPack(RF, InData%NFillGroups)
   call RegPack(RF, allocated(InData%FilledGroups))
   if (allocated(InData%FilledGroups)) then
      call RegPackBounds(RF, 1, lbound(InData%FilledGroups), ubound(InData%FilledGroups))
      LB(1:1) = lbound(InData%FilledGroups)
      UB(1:1) = ubound(InData%FilledGroups)
      do i1 = LB(1), UB(1)
         call Morison_PackFilledGroupType(RF, InData%FilledGroups(i1)) 
      end do
   end if
   call RegPack(RF, InData%NMGDepths)
   call RegPack(RF, allocated(InData%MGDepths))
   if (allocated(InData%MGDepths)) then
      call RegPackBounds(RF, 1, lbound(InData%MGDepths), ubound(InData%MGDepths))
      LB(1:1) = lbound(InData%MGDepths)
      UB(1:1) = ubound(InData%MGDepths)
      do i1 = LB(1), UB(1)
         call Morison_PackMGDepthsType(RF, InData%MGDepths(i1)) 
      end do
   end if
   call RegPack(RF, InData%MGTop)
   call RegPack(RF, InData%MGBottom)
   call RegPack(RF, InData%NMOutputs)
   call RegPack(RF, allocated(InData%MOutLst))
   if (allocated(InData%MOutLst)) then
      call RegPackBounds(RF, 1, lbound(InData%MOutLst), ubound(InData%MOutLst))
      LB(1:1) = lbound(InData%MOutLst)
      UB(1:1) = ubound(InData%MOutLst)
      do i1 = LB(1), UB(1)
         call Morison_PackMOutput(RF, InData%MOutLst(i1)) 
      end do
   end if
   call RegPack(RF, InData%NJOutputs)
   call RegPack(RF, allocated(InData%JOutLst))
   if (allocated(InData%JOutLst)) then
      call RegPackBounds(RF, 1, lbound(InData%JOutLst), ubound(InData%JOutLst))
      LB(1:1) = lbound(InData%JOutLst)
      UB(1:1) = ubound(InData%JOutLst)
      do i1 = LB(1), UB(1)
         call Morison_PackJOutput(RF, InData%JOutLst(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%OutList)
   call RegPack(RF, InData%NumOuts)
   call RegPack(RF, InData%UnSum)
   call RegPack(RF, associated(InData%WaveField))
   if (associated(InData%WaveField)) then
      call RegPackPointer(RF, c_loc(InData%WaveField), PtrInIndex)
      if (.not. PtrInIndex) then
         call SeaSt_WaveField_PackSeaSt_WaveFieldType(RF, InData%WaveField) 
      end if
   end if
   call RegPack(RF, InData%VisMeshes)
   call RegPack(RF, InData%PtfmYMod)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_UnPackInitInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Morison_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Morison_UnPackInitInput'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   integer(B8Ki)   :: PtrIdx
   type(c_ptr)     :: Ptr
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%Gravity); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WaveDisp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AMMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NJoints); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NNodes); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%InpJoints)) deallocate(OutData%InpJoints)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%InpJoints(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%InpJoints.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call Morison_UnpackJointType(RF, OutData%InpJoints(i1)) ! InpJoints 
      end do
   end if
   if (allocated(OutData%Nodes)) deallocate(OutData%Nodes)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Nodes(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Nodes.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call Morison_UnpackNodeType(RF, OutData%Nodes(i1)) ! Nodes 
      end do
   end if
   call RegUnpack(RF, OutData%NAxCoefs); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%AxialCoefs)) deallocate(OutData%AxialCoefs)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%AxialCoefs(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%AxialCoefs.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call Morison_UnpackAxialCoefType(RF, OutData%AxialCoefs(i1)) ! AxialCoefs 
      end do
   end if
   call RegUnpack(RF, OutData%NPropSetsCyl); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%MPropSetsCyl)) deallocate(OutData%MPropSetsCyl)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%MPropSetsCyl(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%MPropSetsCyl.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call Morison_UnpackMemberPropTypeCyl(RF, OutData%MPropSetsCyl(i1)) ! MPropSetsCyl 
      end do
   end if
   call RegUnpack(RF, OutData%NPropSetsRec); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%MPropSetsRec)) deallocate(OutData%MPropSetsRec)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%MPropSetsRec(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%MPropSetsRec.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call Morison_UnpackMemberPropTypeRec(RF, OutData%MPropSetsRec(i1)) ! MPropSetsRec 
      end do
   end if
   call RegUnpack(RF, OutData%SimplCd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SimplCdMG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SimplCa); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SimplCaMG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SimplCp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SimplCpMG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SimplAxCd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SimplAxCdMG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SimplAxCa); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SimplAxCaMG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SimplAxCp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SimplAxCpMG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SimplCb); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SimplCbMg); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SimplMCF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SimplRecCdA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SimplRecCdAMG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SimplRecCdB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SimplRecCdBMG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SimplRecCaA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SimplRecCaAMG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SimplRecCaB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SimplRecCaBMG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SimplRecCp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SimplRecCpMG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SimplRecAxCd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SimplRecAxCdMG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SimplRecAxCa); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SimplRecAxCaMG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SimplRecAxCp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SimplRecAxCpMG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SimplRecCb); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SimplRecCbMg); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SimplRecMCF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NCoefDpthCyl); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%CoefDpthsCyl)) deallocate(OutData%CoefDpthsCyl)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%CoefDpthsCyl(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%CoefDpthsCyl.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call Morison_UnpackCoefDpthsCyl(RF, OutData%CoefDpthsCyl(i1)) ! CoefDpthsCyl 
      end do
   end if
   call RegUnpack(RF, OutData%NCoefDpthRec); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%CoefDpthsRec)) deallocate(OutData%CoefDpthsRec)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%CoefDpthsRec(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%CoefDpthsRec.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call Morison_UnpackCoefDpthsRec(RF, OutData%CoefDpthsRec(i1)) ! CoefDpthsRec 
      end do
   end if
   call RegUnpack(RF, OutData%NCoefMembersCyl); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%CoefMembersCyl)) deallocate(OutData%CoefMembersCyl)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%CoefMembersCyl(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%CoefMembersCyl.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call Morison_UnpackCoefMembersCyl(RF, OutData%CoefMembersCyl(i1)) ! CoefMembersCyl 
      end do
   end if
   call RegUnpack(RF, OutData%NCoefMembersRec); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%CoefMembersRec)) deallocate(OutData%CoefMembersRec)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%CoefMembersRec(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%CoefMembersRec.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call Morison_UnpackCoefMembersRec(RF, OutData%CoefMembersRec(i1)) ! CoefMembersRec 
      end do
   end if
   call RegUnpack(RF, OutData%NMembers); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%InpMembers)) deallocate(OutData%InpMembers)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%InpMembers(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%InpMembers.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call Morison_UnpackMemberInputType(RF, OutData%InpMembers(i1)) ! InpMembers 
      end do
   end if
   call RegUnpack(RF, OutData%NFillGroups); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%FilledGroups)) deallocate(OutData%FilledGroups)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%FilledGroups(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%FilledGroups.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call Morison_UnpackFilledGroupType(RF, OutData%FilledGroups(i1)) ! FilledGroups 
      end do
   end if
   call RegUnpack(RF, OutData%NMGDepths); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%MGDepths)) deallocate(OutData%MGDepths)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%MGDepths(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%MGDepths.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call Morison_UnpackMGDepthsType(RF, OutData%MGDepths(i1)) ! MGDepths 
      end do
   end if
   call RegUnpack(RF, OutData%MGTop); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MGBottom); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NMOutputs); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%MOutLst)) deallocate(OutData%MOutLst)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%MOutLst(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%MOutLst.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call Morison_UnpackMOutput(RF, OutData%MOutLst(i1)) ! MOutLst 
      end do
   end if
   call RegUnpack(RF, OutData%NJOutputs); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%JOutLst)) deallocate(OutData%JOutLst)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%JOutLst(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%JOutLst.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call Morison_UnpackJOutput(RF, OutData%JOutLst(i1)) ! JOutLst 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%OutList); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UnSum); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%WaveField)) deallocate(OutData%WaveField)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackPointer(RF, Ptr, PtrIdx); if (RegCheckErr(RF, RoutineName)) return
      if (c_associated(Ptr)) then
         call c_f_pointer(Ptr, OutData%WaveField)
      else
         allocate(OutData%WaveField,stat=stat)
         if (stat /= 0) then 
            call SetErrStat(ErrID_Fatal, 'Error allocating OutData%WaveField.', RF%ErrStat, RF%ErrMsg, RoutineName)
            return
         end if
         RF%Pointers(PtrIdx) = c_loc(OutData%WaveField)
         call SeaSt_WaveField_UnpackSeaSt_WaveFieldType(RF, OutData%WaveField) ! WaveField 
      end if
   else
      OutData%WaveField => null()
   end if
   call RegUnpack(RF, OutData%VisMeshes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmYMod); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_CopyInitOutput(SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg)
   type(Morison_InitOutputType), intent(in) :: SrcInitOutputData
   type(Morison_InitOutputType), intent(inout) :: DstInitOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'Morison_CopyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcInitOutputData%MorisonVisRad)) then
      LB(1:1) = lbound(SrcInitOutputData%MorisonVisRad)
      UB(1:1) = ubound(SrcInitOutputData%MorisonVisRad)
      if (.not. allocated(DstInitOutputData%MorisonVisRad)) then
         allocate(DstInitOutputData%MorisonVisRad(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%MorisonVisRad.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%MorisonVisRad = SrcInitOutputData%MorisonVisRad
   end if
   if (allocated(SrcInitOutputData%WriteOutputHdr)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputHdr)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputHdr)
      if (.not. allocated(DstInitOutputData%WriteOutputHdr)) then
         allocate(DstInitOutputData%WriteOutputHdr(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputHdr.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputHdr = SrcInitOutputData%WriteOutputHdr
   end if
   if (allocated(SrcInitOutputData%WriteOutputUnt)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputUnt)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputUnt)
      if (.not. allocated(DstInitOutputData%WriteOutputUnt)) then
         allocate(DstInitOutputData%WriteOutputUnt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputUnt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputUnt = SrcInitOutputData%WriteOutputUnt
   end if
end subroutine

subroutine Morison_DestroyInitOutput(InitOutputData, ErrStat, ErrMsg)
   type(Morison_InitOutputType), intent(inout) :: InitOutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Morison_DestroyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InitOutputData%MorisonVisRad)) then
      deallocate(InitOutputData%MorisonVisRad)
   end if
   if (allocated(InitOutputData%WriteOutputHdr)) then
      deallocate(InitOutputData%WriteOutputHdr)
   end if
   if (allocated(InitOutputData%WriteOutputUnt)) then
      deallocate(InitOutputData%WriteOutputUnt)
   end if
end subroutine

subroutine Morison_PackInitOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Morison_InitOutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Morison_PackInitOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%MorisonVisRad)
   call RegPackAlloc(RF, InData%WriteOutputHdr)
   call RegPackAlloc(RF, InData%WriteOutputUnt)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_UnPackInitOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Morison_InitOutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Morison_UnPackInitOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%MorisonVisRad); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutputHdr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutputUnt); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_CopyContState(SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg)
   type(Morison_ContinuousStateType), intent(in) :: SrcContStateData
   type(Morison_ContinuousStateType), intent(inout) :: DstContStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Morison_CopyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstContStateData%DummyContState = SrcContStateData%DummyContState
end subroutine

subroutine Morison_DestroyContState(ContStateData, ErrStat, ErrMsg)
   type(Morison_ContinuousStateType), intent(inout) :: ContStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Morison_DestroyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine Morison_PackContState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Morison_ContinuousStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Morison_PackContState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyContState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_UnPackContState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Morison_ContinuousStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Morison_UnPackContState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyContState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_CopyDiscState(SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg)
   type(Morison_DiscreteStateType), intent(in) :: SrcDiscStateData
   type(Morison_DiscreteStateType), intent(inout) :: DstDiscStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'Morison_CopyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcDiscStateData%V_rel_n_FiltStat)) then
      LB(1:1) = lbound(SrcDiscStateData%V_rel_n_FiltStat)
      UB(1:1) = ubound(SrcDiscStateData%V_rel_n_FiltStat)
      if (.not. allocated(DstDiscStateData%V_rel_n_FiltStat)) then
         allocate(DstDiscStateData%V_rel_n_FiltStat(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%V_rel_n_FiltStat.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%V_rel_n_FiltStat = SrcDiscStateData%V_rel_n_FiltStat
   end if
end subroutine

subroutine Morison_DestroyDiscState(DiscStateData, ErrStat, ErrMsg)
   type(Morison_DiscreteStateType), intent(inout) :: DiscStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Morison_DestroyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(DiscStateData%V_rel_n_FiltStat)) then
      deallocate(DiscStateData%V_rel_n_FiltStat)
   end if
end subroutine

subroutine Morison_PackDiscState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Morison_DiscreteStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Morison_PackDiscState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%V_rel_n_FiltStat)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_UnPackDiscState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Morison_DiscreteStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Morison_UnPackDiscState'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%V_rel_n_FiltStat); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_CopyConstrState(SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg)
   type(Morison_ConstraintStateType), intent(in) :: SrcConstrStateData
   type(Morison_ConstraintStateType), intent(inout) :: DstConstrStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Morison_CopyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstConstrStateData%DummyConstrState = SrcConstrStateData%DummyConstrState
end subroutine

subroutine Morison_DestroyConstrState(ConstrStateData, ErrStat, ErrMsg)
   type(Morison_ConstraintStateType), intent(inout) :: ConstrStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Morison_DestroyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine Morison_PackConstrState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Morison_ConstraintStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Morison_PackConstrState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyConstrState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_UnPackConstrState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Morison_ConstraintStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Morison_UnPackConstrState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyConstrState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_CopyOtherState(SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg)
   type(Morison_OtherStateType), intent(in) :: SrcOtherStateData
   type(Morison_OtherStateType), intent(inout) :: DstOtherStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Morison_CopyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstOtherStateData%DummyOtherState = SrcOtherStateData%DummyOtherState
end subroutine

subroutine Morison_DestroyOtherState(OtherStateData, ErrStat, ErrMsg)
   type(Morison_OtherStateType), intent(inout) :: OtherStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Morison_DestroyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine Morison_PackOtherState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Morison_OtherStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Morison_PackOtherState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyOtherState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_UnPackOtherState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Morison_OtherStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Morison_UnPackOtherState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyOtherState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_CopyMisc(SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg)
   type(Morison_MiscVarType), intent(inout) :: SrcMiscData
   type(Morison_MiscVarType), intent(inout) :: DstMiscData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'Morison_CopyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcMiscData%DispNodePosHdn)) then
      LB(1:2) = lbound(SrcMiscData%DispNodePosHdn)
      UB(1:2) = ubound(SrcMiscData%DispNodePosHdn)
      if (.not. allocated(DstMiscData%DispNodePosHdn)) then
         allocate(DstMiscData%DispNodePosHdn(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%DispNodePosHdn.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%DispNodePosHdn = SrcMiscData%DispNodePosHdn
   end if
   if (allocated(SrcMiscData%DispNodePosHst)) then
      LB(1:2) = lbound(SrcMiscData%DispNodePosHst)
      UB(1:2) = ubound(SrcMiscData%DispNodePosHst)
      if (.not. allocated(DstMiscData%DispNodePosHst)) then
         allocate(DstMiscData%DispNodePosHst(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%DispNodePosHst.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%DispNodePosHst = SrcMiscData%DispNodePosHst
   end if
   if (allocated(SrcMiscData%FV)) then
      LB(1:2) = lbound(SrcMiscData%FV)
      UB(1:2) = ubound(SrcMiscData%FV)
      if (.not. allocated(DstMiscData%FV)) then
         allocate(DstMiscData%FV(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%FV.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%FV = SrcMiscData%FV
   end if
   if (allocated(SrcMiscData%FA)) then
      LB(1:2) = lbound(SrcMiscData%FA)
      UB(1:2) = ubound(SrcMiscData%FA)
      if (.not. allocated(DstMiscData%FA)) then
         allocate(DstMiscData%FA(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%FA.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%FA = SrcMiscData%FA
   end if
   if (allocated(SrcMiscData%FAMCF)) then
      LB(1:2) = lbound(SrcMiscData%FAMCF)
      UB(1:2) = ubound(SrcMiscData%FAMCF)
      if (.not. allocated(DstMiscData%FAMCF)) then
         allocate(DstMiscData%FAMCF(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%FAMCF.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%FAMCF = SrcMiscData%FAMCF
   end if
   if (allocated(SrcMiscData%FDynP)) then
      LB(1:1) = lbound(SrcMiscData%FDynP)
      UB(1:1) = ubound(SrcMiscData%FDynP)
      if (.not. allocated(DstMiscData%FDynP)) then
         allocate(DstMiscData%FDynP(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%FDynP.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%FDynP = SrcMiscData%FDynP
   end if
   if (allocated(SrcMiscData%WaveElev)) then
      LB(1:1) = lbound(SrcMiscData%WaveElev)
      UB(1:1) = ubound(SrcMiscData%WaveElev)
      if (.not. allocated(DstMiscData%WaveElev)) then
         allocate(DstMiscData%WaveElev(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%WaveElev.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%WaveElev = SrcMiscData%WaveElev
   end if
   if (allocated(SrcMiscData%WaveElev1)) then
      LB(1:1) = lbound(SrcMiscData%WaveElev1)
      UB(1:1) = ubound(SrcMiscData%WaveElev1)
      if (.not. allocated(DstMiscData%WaveElev1)) then
         allocate(DstMiscData%WaveElev1(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%WaveElev1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%WaveElev1 = SrcMiscData%WaveElev1
   end if
   if (allocated(SrcMiscData%WaveElev2)) then
      LB(1:1) = lbound(SrcMiscData%WaveElev2)
      UB(1:1) = ubound(SrcMiscData%WaveElev2)
      if (.not. allocated(DstMiscData%WaveElev2)) then
         allocate(DstMiscData%WaveElev2(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%WaveElev2.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%WaveElev2 = SrcMiscData%WaveElev2
   end if
   if (allocated(SrcMiscData%vrel)) then
      LB(1:2) = lbound(SrcMiscData%vrel)
      UB(1:2) = ubound(SrcMiscData%vrel)
      if (.not. allocated(DstMiscData%vrel)) then
         allocate(DstMiscData%vrel(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%vrel.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%vrel = SrcMiscData%vrel
   end if
   if (allocated(SrcMiscData%nodeInWater)) then
      LB(1:1) = lbound(SrcMiscData%nodeInWater)
      UB(1:1) = ubound(SrcMiscData%nodeInWater)
      if (.not. allocated(DstMiscData%nodeInWater)) then
         allocate(DstMiscData%nodeInWater(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%nodeInWater.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%nodeInWater = SrcMiscData%nodeInWater
   end if
   if (allocated(SrcMiscData%memberLoads)) then
      LB(1:1) = lbound(SrcMiscData%memberLoads)
      UB(1:1) = ubound(SrcMiscData%memberLoads)
      if (.not. allocated(DstMiscData%memberLoads)) then
         allocate(DstMiscData%memberLoads(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%memberLoads.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call Morison_CopyMemberLoads(SrcMiscData%memberLoads(i1), DstMiscData%memberLoads(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcMiscData%F_B_End)) then
      LB(1:2) = lbound(SrcMiscData%F_B_End)
      UB(1:2) = ubound(SrcMiscData%F_B_End)
      if (.not. allocated(DstMiscData%F_B_End)) then
         allocate(DstMiscData%F_B_End(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%F_B_End.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%F_B_End = SrcMiscData%F_B_End
   end if
   if (allocated(SrcMiscData%F_D_End)) then
      LB(1:2) = lbound(SrcMiscData%F_D_End)
      UB(1:2) = ubound(SrcMiscData%F_D_End)
      if (.not. allocated(DstMiscData%F_D_End)) then
         allocate(DstMiscData%F_D_End(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%F_D_End.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%F_D_End = SrcMiscData%F_D_End
   end if
   if (allocated(SrcMiscData%F_I_End)) then
      LB(1:2) = lbound(SrcMiscData%F_I_End)
      UB(1:2) = ubound(SrcMiscData%F_I_End)
      if (.not. allocated(DstMiscData%F_I_End)) then
         allocate(DstMiscData%F_I_End(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%F_I_End.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%F_I_End = SrcMiscData%F_I_End
   end if
   if (allocated(SrcMiscData%F_IMG_End)) then
      LB(1:2) = lbound(SrcMiscData%F_IMG_End)
      UB(1:2) = ubound(SrcMiscData%F_IMG_End)
      if (.not. allocated(DstMiscData%F_IMG_End)) then
         allocate(DstMiscData%F_IMG_End(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%F_IMG_End.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%F_IMG_End = SrcMiscData%F_IMG_End
   end if
   if (allocated(SrcMiscData%F_A_End)) then
      LB(1:2) = lbound(SrcMiscData%F_A_End)
      UB(1:2) = ubound(SrcMiscData%F_A_End)
      if (.not. allocated(DstMiscData%F_A_End)) then
         allocate(DstMiscData%F_A_End(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%F_A_End.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%F_A_End = SrcMiscData%F_A_End
   end if
   if (allocated(SrcMiscData%F_BF_End)) then
      LB(1:2) = lbound(SrcMiscData%F_BF_End)
      UB(1:2) = ubound(SrcMiscData%F_BF_End)
      if (.not. allocated(DstMiscData%F_BF_End)) then
         allocate(DstMiscData%F_BF_End(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%F_BF_End.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%F_BF_End = SrcMiscData%F_BF_End
   end if
   if (allocated(SrcMiscData%V_rel_n)) then
      LB(1:1) = lbound(SrcMiscData%V_rel_n)
      UB(1:1) = ubound(SrcMiscData%V_rel_n)
      if (.not. allocated(DstMiscData%V_rel_n)) then
         allocate(DstMiscData%V_rel_n(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%V_rel_n.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%V_rel_n = SrcMiscData%V_rel_n
   end if
   if (allocated(SrcMiscData%V_rel_n_HiPass)) then
      LB(1:1) = lbound(SrcMiscData%V_rel_n_HiPass)
      UB(1:1) = ubound(SrcMiscData%V_rel_n_HiPass)
      if (.not. allocated(DstMiscData%V_rel_n_HiPass)) then
         allocate(DstMiscData%V_rel_n_HiPass(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%V_rel_n_HiPass.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%V_rel_n_HiPass = SrcMiscData%V_rel_n_HiPass
   end if
   if (allocated(SrcMiscData%zFillGroup)) then
      LB(1:1) = lbound(SrcMiscData%zFillGroup)
      UB(1:1) = ubound(SrcMiscData%zFillGroup)
      if (.not. allocated(DstMiscData%zFillGroup)) then
         allocate(DstMiscData%zFillGroup(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%zFillGroup.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%zFillGroup = SrcMiscData%zFillGroup
   end if
   call NWTC_Library_CopyMeshMapType(SrcMiscData%VisMeshMap, DstMiscData%VisMeshMap, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call SeaSt_WaveField_CopyMisc(SrcMiscData%WaveField_m, DstMiscData%WaveField_m, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine Morison_DestroyMisc(MiscData, ErrStat, ErrMsg)
   type(Morison_MiscVarType), intent(inout) :: MiscData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'Morison_DestroyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(MiscData%DispNodePosHdn)) then
      deallocate(MiscData%DispNodePosHdn)
   end if
   if (allocated(MiscData%DispNodePosHst)) then
      deallocate(MiscData%DispNodePosHst)
   end if
   if (allocated(MiscData%FV)) then
      deallocate(MiscData%FV)
   end if
   if (allocated(MiscData%FA)) then
      deallocate(MiscData%FA)
   end if
   if (allocated(MiscData%FAMCF)) then
      deallocate(MiscData%FAMCF)
   end if
   if (allocated(MiscData%FDynP)) then
      deallocate(MiscData%FDynP)
   end if
   if (allocated(MiscData%WaveElev)) then
      deallocate(MiscData%WaveElev)
   end if
   if (allocated(MiscData%WaveElev1)) then
      deallocate(MiscData%WaveElev1)
   end if
   if (allocated(MiscData%WaveElev2)) then
      deallocate(MiscData%WaveElev2)
   end if
   if (allocated(MiscData%vrel)) then
      deallocate(MiscData%vrel)
   end if
   if (allocated(MiscData%nodeInWater)) then
      deallocate(MiscData%nodeInWater)
   end if
   if (allocated(MiscData%memberLoads)) then
      LB(1:1) = lbound(MiscData%memberLoads)
      UB(1:1) = ubound(MiscData%memberLoads)
      do i1 = LB(1), UB(1)
         call Morison_DestroyMemberLoads(MiscData%memberLoads(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MiscData%memberLoads)
   end if
   if (allocated(MiscData%F_B_End)) then
      deallocate(MiscData%F_B_End)
   end if
   if (allocated(MiscData%F_D_End)) then
      deallocate(MiscData%F_D_End)
   end if
   if (allocated(MiscData%F_I_End)) then
      deallocate(MiscData%F_I_End)
   end if
   if (allocated(MiscData%F_IMG_End)) then
      deallocate(MiscData%F_IMG_End)
   end if
   if (allocated(MiscData%F_A_End)) then
      deallocate(MiscData%F_A_End)
   end if
   if (allocated(MiscData%F_BF_End)) then
      deallocate(MiscData%F_BF_End)
   end if
   if (allocated(MiscData%V_rel_n)) then
      deallocate(MiscData%V_rel_n)
   end if
   if (allocated(MiscData%V_rel_n_HiPass)) then
      deallocate(MiscData%V_rel_n_HiPass)
   end if
   if (allocated(MiscData%zFillGroup)) then
      deallocate(MiscData%zFillGroup)
   end if
   call NWTC_Library_DestroyMeshMapType(MiscData%VisMeshMap, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call SeaSt_WaveField_DestroyMisc(MiscData%WaveField_m, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine Morison_PackMisc(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Morison_MiscVarType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Morison_PackMisc'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%DispNodePosHdn)
   call RegPackAlloc(RF, InData%DispNodePosHst)
   call RegPackAlloc(RF, InData%FV)
   call RegPackAlloc(RF, InData%FA)
   call RegPackAlloc(RF, InData%FAMCF)
   call RegPackAlloc(RF, InData%FDynP)
   call RegPackAlloc(RF, InData%WaveElev)
   call RegPackAlloc(RF, InData%WaveElev1)
   call RegPackAlloc(RF, InData%WaveElev2)
   call RegPackAlloc(RF, InData%vrel)
   call RegPackAlloc(RF, InData%nodeInWater)
   call RegPack(RF, allocated(InData%memberLoads))
   if (allocated(InData%memberLoads)) then
      call RegPackBounds(RF, 1, lbound(InData%memberLoads), ubound(InData%memberLoads))
      LB(1:1) = lbound(InData%memberLoads)
      UB(1:1) = ubound(InData%memberLoads)
      do i1 = LB(1), UB(1)
         call Morison_PackMemberLoads(RF, InData%memberLoads(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%F_B_End)
   call RegPackAlloc(RF, InData%F_D_End)
   call RegPackAlloc(RF, InData%F_I_End)
   call RegPackAlloc(RF, InData%F_IMG_End)
   call RegPackAlloc(RF, InData%F_A_End)
   call RegPackAlloc(RF, InData%F_BF_End)
   call RegPackAlloc(RF, InData%V_rel_n)
   call RegPackAlloc(RF, InData%V_rel_n_HiPass)
   call RegPackAlloc(RF, InData%zFillGroup)
   call NWTC_Library_PackMeshMapType(RF, InData%VisMeshMap) 
   call SeaSt_WaveField_PackMisc(RF, InData%WaveField_m) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_UnPackMisc(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Morison_MiscVarType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Morison_UnPackMisc'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%DispNodePosHdn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%DispNodePosHst); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%FV); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%FA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%FAMCF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%FDynP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WaveElev); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WaveElev1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WaveElev2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%vrel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%nodeInWater); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%memberLoads)) deallocate(OutData%memberLoads)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%memberLoads(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%memberLoads.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call Morison_UnpackMemberLoads(RF, OutData%memberLoads(i1)) ! memberLoads 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%F_B_End); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%F_D_End); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%F_I_End); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%F_IMG_End); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%F_A_End); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%F_BF_End); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%V_rel_n); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%V_rel_n_HiPass); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%zFillGroup); if (RegCheckErr(RF, RoutineName)) return
   call NWTC_Library_UnpackMeshMapType(RF, OutData%VisMeshMap) ! VisMeshMap 
   call SeaSt_WaveField_UnpackMisc(RF, OutData%WaveField_m) ! WaveField_m 
end subroutine

subroutine Morison_CopyParam(SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg)
   type(Morison_ParameterType), intent(in) :: SrcParamData
   type(Morison_ParameterType), intent(inout) :: DstParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'Morison_CopyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstParamData%DT = SrcParamData%DT
   DstParamData%Gravity = SrcParamData%Gravity
   DstParamData%WaveDisp = SrcParamData%WaveDisp
   DstParamData%AMMod = SrcParamData%AMMod
   DstParamData%NMembers = SrcParamData%NMembers
   if (allocated(SrcParamData%Members)) then
      LB(1:1) = lbound(SrcParamData%Members)
      UB(1:1) = ubound(SrcParamData%Members)
      if (.not. allocated(DstParamData%Members)) then
         allocate(DstParamData%Members(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Members.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call Morison_CopyMemberType(SrcParamData%Members(i1), DstParamData%Members(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstParamData%NNodes = SrcParamData%NNodes
   DstParamData%NJoints = SrcParamData%NJoints
   if (allocated(SrcParamData%I_MG_End)) then
      LB(1:3) = lbound(SrcParamData%I_MG_End)
      UB(1:3) = ubound(SrcParamData%I_MG_End)
      if (.not. allocated(DstParamData%I_MG_End)) then
         allocate(DstParamData%I_MG_End(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%I_MG_End.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%I_MG_End = SrcParamData%I_MG_End
   end if
   if (allocated(SrcParamData%An_End)) then
      LB(1:2) = lbound(SrcParamData%An_End)
      UB(1:2) = ubound(SrcParamData%An_End)
      if (.not. allocated(DstParamData%An_End)) then
         allocate(DstParamData%An_End(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%An_End.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%An_End = SrcParamData%An_End
   end if
   if (allocated(SrcParamData%DragConst_End)) then
      LB(1:1) = lbound(SrcParamData%DragConst_End)
      UB(1:1) = ubound(SrcParamData%DragConst_End)
      if (.not. allocated(DstParamData%DragConst_End)) then
         allocate(DstParamData%DragConst_End(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%DragConst_End.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%DragConst_End = SrcParamData%DragConst_End
   end if
   if (allocated(SrcParamData%VRelNFiltConst)) then
      LB(1:1) = lbound(SrcParamData%VRelNFiltConst)
      UB(1:1) = ubound(SrcParamData%VRelNFiltConst)
      if (.not. allocated(DstParamData%VRelNFiltConst)) then
         allocate(DstParamData%VRelNFiltConst(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%VRelNFiltConst.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%VRelNFiltConst = SrcParamData%VRelNFiltConst
   end if
   if (allocated(SrcParamData%DragMod_End)) then
      LB(1:1) = lbound(SrcParamData%DragMod_End)
      UB(1:1) = ubound(SrcParamData%DragMod_End)
      if (.not. allocated(DstParamData%DragMod_End)) then
         allocate(DstParamData%DragMod_End(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%DragMod_End.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%DragMod_End = SrcParamData%DragMod_End
   end if
   if (allocated(SrcParamData%DragLoFSc_End)) then
      LB(1:1) = lbound(SrcParamData%DragLoFSc_End)
      UB(1:1) = ubound(SrcParamData%DragLoFSc_End)
      if (.not. allocated(DstParamData%DragLoFSc_End)) then
         allocate(DstParamData%DragLoFSc_End(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%DragLoFSc_End.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%DragLoFSc_End = SrcParamData%DragLoFSc_End
   end if
   if (allocated(SrcParamData%F_WMG_End)) then
      LB(1:2) = lbound(SrcParamData%F_WMG_End)
      UB(1:2) = ubound(SrcParamData%F_WMG_End)
      if (.not. allocated(DstParamData%F_WMG_End)) then
         allocate(DstParamData%F_WMG_End(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%F_WMG_End.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%F_WMG_End = SrcParamData%F_WMG_End
   end if
   if (allocated(SrcParamData%DP_Const_End)) then
      LB(1:2) = lbound(SrcParamData%DP_Const_End)
      UB(1:2) = ubound(SrcParamData%DP_Const_End)
      if (.not. allocated(DstParamData%DP_Const_End)) then
         allocate(DstParamData%DP_Const_End(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%DP_Const_End.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%DP_Const_End = SrcParamData%DP_Const_End
   end if
   if (allocated(SrcParamData%Mass_MG_End)) then
      LB(1:1) = lbound(SrcParamData%Mass_MG_End)
      UB(1:1) = ubound(SrcParamData%Mass_MG_End)
      if (.not. allocated(DstParamData%Mass_MG_End)) then
         allocate(DstParamData%Mass_MG_End(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Mass_MG_End.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Mass_MG_End = SrcParamData%Mass_MG_End
   end if
   if (allocated(SrcParamData%AM_End)) then
      LB(1:3) = lbound(SrcParamData%AM_End)
      UB(1:3) = ubound(SrcParamData%AM_End)
      if (.not. allocated(DstParamData%AM_End)) then
         allocate(DstParamData%AM_End(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%AM_End.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%AM_End = SrcParamData%AM_End
   end if
   DstParamData%NMOutputs = SrcParamData%NMOutputs
   if (allocated(SrcParamData%MOutLst)) then
      LB(1:1) = lbound(SrcParamData%MOutLst)
      UB(1:1) = ubound(SrcParamData%MOutLst)
      if (.not. allocated(DstParamData%MOutLst)) then
         allocate(DstParamData%MOutLst(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%MOutLst.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call Morison_CopyMOutput(SrcParamData%MOutLst(i1), DstParamData%MOutLst(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstParamData%NJOutputs = SrcParamData%NJOutputs
   if (allocated(SrcParamData%JOutLst)) then
      LB(1:1) = lbound(SrcParamData%JOutLst)
      UB(1:1) = ubound(SrcParamData%JOutLst)
      if (.not. allocated(DstParamData%JOutLst)) then
         allocate(DstParamData%JOutLst(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%JOutLst.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call Morison_CopyJOutput(SrcParamData%JOutLst(i1), DstParamData%JOutLst(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcParamData%OutParam)) then
      LB(1:1) = lbound(SrcParamData%OutParam)
      UB(1:1) = ubound(SrcParamData%OutParam)
      if (.not. allocated(DstParamData%OutParam)) then
         allocate(DstParamData%OutParam(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%OutParam.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyOutParmType(SrcParamData%OutParam(i1), DstParamData%OutParam(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstParamData%NumOuts = SrcParamData%NumOuts
   DstParamData%WaveField => SrcParamData%WaveField
   DstParamData%VisMeshes = SrcParamData%VisMeshes
   DstParamData%PtfmYMod = SrcParamData%PtfmYMod
   DstParamData%NFillGroups = SrcParamData%NFillGroups
   if (allocated(SrcParamData%FilledGroups)) then
      LB(1:1) = lbound(SrcParamData%FilledGroups)
      UB(1:1) = ubound(SrcParamData%FilledGroups)
      if (.not. allocated(DstParamData%FilledGroups)) then
         allocate(DstParamData%FilledGroups(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%FilledGroups.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call Morison_CopyFilledGroupType(SrcParamData%FilledGroups(i1), DstParamData%FilledGroups(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
end subroutine

subroutine Morison_DestroyParam(ParamData, ErrStat, ErrMsg)
   type(Morison_ParameterType), intent(inout) :: ParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'Morison_DestroyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ParamData%Members)) then
      LB(1:1) = lbound(ParamData%Members)
      UB(1:1) = ubound(ParamData%Members)
      do i1 = LB(1), UB(1)
         call Morison_DestroyMemberType(ParamData%Members(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%Members)
   end if
   if (allocated(ParamData%I_MG_End)) then
      deallocate(ParamData%I_MG_End)
   end if
   if (allocated(ParamData%An_End)) then
      deallocate(ParamData%An_End)
   end if
   if (allocated(ParamData%DragConst_End)) then
      deallocate(ParamData%DragConst_End)
   end if
   if (allocated(ParamData%VRelNFiltConst)) then
      deallocate(ParamData%VRelNFiltConst)
   end if
   if (allocated(ParamData%DragMod_End)) then
      deallocate(ParamData%DragMod_End)
   end if
   if (allocated(ParamData%DragLoFSc_End)) then
      deallocate(ParamData%DragLoFSc_End)
   end if
   if (allocated(ParamData%F_WMG_End)) then
      deallocate(ParamData%F_WMG_End)
   end if
   if (allocated(ParamData%DP_Const_End)) then
      deallocate(ParamData%DP_Const_End)
   end if
   if (allocated(ParamData%Mass_MG_End)) then
      deallocate(ParamData%Mass_MG_End)
   end if
   if (allocated(ParamData%AM_End)) then
      deallocate(ParamData%AM_End)
   end if
   if (allocated(ParamData%MOutLst)) then
      LB(1:1) = lbound(ParamData%MOutLst)
      UB(1:1) = ubound(ParamData%MOutLst)
      do i1 = LB(1), UB(1)
         call Morison_DestroyMOutput(ParamData%MOutLst(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%MOutLst)
   end if
   if (allocated(ParamData%JOutLst)) then
      LB(1:1) = lbound(ParamData%JOutLst)
      UB(1:1) = ubound(ParamData%JOutLst)
      do i1 = LB(1), UB(1)
         call Morison_DestroyJOutput(ParamData%JOutLst(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%JOutLst)
   end if
   if (allocated(ParamData%OutParam)) then
      LB(1:1) = lbound(ParamData%OutParam)
      UB(1:1) = ubound(ParamData%OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyOutParmType(ParamData%OutParam(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%OutParam)
   end if
   nullify(ParamData%WaveField)
   if (allocated(ParamData%FilledGroups)) then
      LB(1:1) = lbound(ParamData%FilledGroups)
      UB(1:1) = ubound(ParamData%FilledGroups)
      do i1 = LB(1), UB(1)
         call Morison_DestroyFilledGroupType(ParamData%FilledGroups(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%FilledGroups)
   end if
end subroutine

subroutine Morison_PackParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Morison_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Morison_PackParam'
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)   :: LB(3), UB(3)
   logical         :: PtrInIndex
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DT)
   call RegPack(RF, InData%Gravity)
   call RegPack(RF, InData%WaveDisp)
   call RegPack(RF, InData%AMMod)
   call RegPack(RF, InData%NMembers)
   call RegPack(RF, allocated(InData%Members))
   if (allocated(InData%Members)) then
      call RegPackBounds(RF, 1, lbound(InData%Members), ubound(InData%Members))
      LB(1:1) = lbound(InData%Members)
      UB(1:1) = ubound(InData%Members)
      do i1 = LB(1), UB(1)
         call Morison_PackMemberType(RF, InData%Members(i1)) 
      end do
   end if
   call RegPack(RF, InData%NNodes)
   call RegPack(RF, InData%NJoints)
   call RegPackAlloc(RF, InData%I_MG_End)
   call RegPackAlloc(RF, InData%An_End)
   call RegPackAlloc(RF, InData%DragConst_End)
   call RegPackAlloc(RF, InData%VRelNFiltConst)
   call RegPackAlloc(RF, InData%DragMod_End)
   call RegPackAlloc(RF, InData%DragLoFSc_End)
   call RegPackAlloc(RF, InData%F_WMG_End)
   call RegPackAlloc(RF, InData%DP_Const_End)
   call RegPackAlloc(RF, InData%Mass_MG_End)
   call RegPackAlloc(RF, InData%AM_End)
   call RegPack(RF, InData%NMOutputs)
   call RegPack(RF, allocated(InData%MOutLst))
   if (allocated(InData%MOutLst)) then
      call RegPackBounds(RF, 1, lbound(InData%MOutLst), ubound(InData%MOutLst))
      LB(1:1) = lbound(InData%MOutLst)
      UB(1:1) = ubound(InData%MOutLst)
      do i1 = LB(1), UB(1)
         call Morison_PackMOutput(RF, InData%MOutLst(i1)) 
      end do
   end if
   call RegPack(RF, InData%NJOutputs)
   call RegPack(RF, allocated(InData%JOutLst))
   if (allocated(InData%JOutLst)) then
      call RegPackBounds(RF, 1, lbound(InData%JOutLst), ubound(InData%JOutLst))
      LB(1:1) = lbound(InData%JOutLst)
      UB(1:1) = ubound(InData%JOutLst)
      do i1 = LB(1), UB(1)
         call Morison_PackJOutput(RF, InData%JOutLst(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%OutParam))
   if (allocated(InData%OutParam)) then
      call RegPackBounds(RF, 1, lbound(InData%OutParam), ubound(InData%OutParam))
      LB(1:1) = lbound(InData%OutParam)
      UB(1:1) = ubound(InData%OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackOutParmType(RF, InData%OutParam(i1)) 
      end do
   end if
   call RegPack(RF, InData%NumOuts)
   call RegPack(RF, associated(InData%WaveField))
   if (associated(InData%WaveField)) then
      call RegPackPointer(RF, c_loc(InData%WaveField), PtrInIndex)
      if (.not. PtrInIndex) then
         call SeaSt_WaveField_PackSeaSt_WaveFieldType(RF, InData%WaveField) 
      end if
   end if
   call RegPack(RF, InData%VisMeshes)
   call RegPack(RF, InData%PtfmYMod)
   call RegPack(RF, InData%NFillGroups)
   call RegPack(RF, allocated(InData%FilledGroups))
   if (allocated(InData%FilledGroups)) then
      call RegPackBounds(RF, 1, lbound(InData%FilledGroups), ubound(InData%FilledGroups))
      LB(1:1) = lbound(InData%FilledGroups)
      UB(1:1) = ubound(InData%FilledGroups)
      do i1 = LB(1), UB(1)
         call Morison_PackFilledGroupType(RF, InData%FilledGroups(i1)) 
      end do
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_UnPackParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Morison_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Morison_UnPackParam'
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   integer(B8Ki)   :: PtrIdx
   type(c_ptr)     :: Ptr
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Gravity); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WaveDisp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AMMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NMembers); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%Members)) deallocate(OutData%Members)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Members(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Members.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call Morison_UnpackMemberType(RF, OutData%Members(i1)) ! Members 
      end do
   end if
   call RegUnpack(RF, OutData%NNodes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NJoints); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%I_MG_End); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%An_End); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%DragConst_End); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%VRelNFiltConst); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%DragMod_End); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%DragLoFSc_End); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%F_WMG_End); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%DP_Const_End); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Mass_MG_End); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AM_End); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NMOutputs); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%MOutLst)) deallocate(OutData%MOutLst)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%MOutLst(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%MOutLst.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call Morison_UnpackMOutput(RF, OutData%MOutLst(i1)) ! MOutLst 
      end do
   end if
   call RegUnpack(RF, OutData%NJOutputs); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%JOutLst)) deallocate(OutData%JOutLst)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%JOutLst(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%JOutLst.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call Morison_UnpackJOutput(RF, OutData%JOutLst(i1)) ! JOutLst 
      end do
   end if
   if (allocated(OutData%OutParam)) deallocate(OutData%OutParam)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%OutParam(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%OutParam.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackOutParmType(RF, OutData%OutParam(i1)) ! OutParam 
      end do
   end if
   call RegUnpack(RF, OutData%NumOuts); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%WaveField)) deallocate(OutData%WaveField)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackPointer(RF, Ptr, PtrIdx); if (RegCheckErr(RF, RoutineName)) return
      if (c_associated(Ptr)) then
         call c_f_pointer(Ptr, OutData%WaveField)
      else
         allocate(OutData%WaveField,stat=stat)
         if (stat /= 0) then 
            call SetErrStat(ErrID_Fatal, 'Error allocating OutData%WaveField.', RF%ErrStat, RF%ErrMsg, RoutineName)
            return
         end if
         RF%Pointers(PtrIdx) = c_loc(OutData%WaveField)
         call SeaSt_WaveField_UnpackSeaSt_WaveFieldType(RF, OutData%WaveField) ! WaveField 
      end if
   else
      OutData%WaveField => null()
   end if
   call RegUnpack(RF, OutData%VisMeshes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmYMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NFillGroups); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%FilledGroups)) deallocate(OutData%FilledGroups)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%FilledGroups(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%FilledGroups.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call Morison_UnpackFilledGroupType(RF, OutData%FilledGroups(i1)) ! FilledGroups 
      end do
   end if
end subroutine

subroutine Morison_CopyInput(SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg)
   type(Morison_InputType), intent(inout) :: SrcInputData
   type(Morison_InputType), intent(inout) :: DstInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'Morison_CopyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshCopy(SrcInputData%Mesh, DstInputData%Mesh, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstInputData%PtfmRefY = SrcInputData%PtfmRefY
end subroutine

subroutine Morison_DestroyInput(InputData, ErrStat, ErrMsg)
   type(Morison_InputType), intent(inout) :: InputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'Morison_DestroyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshDestroy( InputData%Mesh, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine Morison_PackInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Morison_InputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Morison_PackInput'
   if (RF%ErrStat >= AbortErrLev) return
   call MeshPack(RF, InData%Mesh) 
   call RegPack(RF, InData%PtfmRefY)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_UnPackInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Morison_InputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Morison_UnPackInput'
   if (RF%ErrStat /= ErrID_None) return
   call MeshUnpack(RF, OutData%Mesh) ! Mesh 
   call RegUnpack(RF, OutData%PtfmRefY); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_CopyOutput(SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg)
   type(Morison_OutputType), intent(inout) :: SrcOutputData
   type(Morison_OutputType), intent(inout) :: DstOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'Morison_CopyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshCopy(SrcOutputData%Mesh, DstOutputData%Mesh, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcOutputData%VisMesh, DstOutputData%VisMesh, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcOutputData%WriteOutput)) then
      LB(1:1) = lbound(SrcOutputData%WriteOutput)
      UB(1:1) = ubound(SrcOutputData%WriteOutput)
      if (.not. allocated(DstOutputData%WriteOutput)) then
         allocate(DstOutputData%WriteOutput(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%WriteOutput.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%WriteOutput = SrcOutputData%WriteOutput
   end if
end subroutine

subroutine Morison_DestroyOutput(OutputData, ErrStat, ErrMsg)
   type(Morison_OutputType), intent(inout) :: OutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'Morison_DestroyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshDestroy( OutputData%Mesh, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( OutputData%VisMesh, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(OutputData%WriteOutput)) then
      deallocate(OutputData%WriteOutput)
   end if
end subroutine

subroutine Morison_PackOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Morison_OutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Morison_PackOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call MeshPack(RF, InData%Mesh) 
   call MeshPack(RF, InData%VisMesh) 
   call RegPackAlloc(RF, InData%WriteOutput)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_UnPackOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Morison_OutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Morison_UnPackOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call MeshUnpack(RF, OutData%Mesh) ! Mesh 
   call MeshUnpack(RF, OutData%VisMesh) ! VisMesh 
   call RegUnpackAlloc(RF, OutData%WriteOutput); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Morison_Input_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
   ! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(Morison_InputType), intent(inout)  :: u(:) ! Input at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Inputs
   type(Morison_InputType), intent(inout)  :: u_out ! Input at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'Morison_Input_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(u)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(u)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(u) - 1
   select case (order)
   case (0)
      call Morison_CopyInput(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call Morison_Input_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call Morison_Input_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(u) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE Morison_Input_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

   TYPE(Morison_InputType), INTENT(INOUT)  :: u1    ! Input at t1 > t2
   TYPE(Morison_InputType), INTENT(INOUT)  :: u2    ! Input at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Inputs
   TYPE(Morison_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'Morison_Input_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   CALL MeshExtrapInterp1(u1%Mesh, u2%Mesh, tin, u_out%Mesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   u_out%PtfmRefY = a1*u1%PtfmRefY + a2*u2%PtfmRefY
END SUBROUTINE

SUBROUTINE Morison_Input_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

   TYPE(Morison_InputType), INTENT(INOUT)  :: u1      ! Input at t1 > t2 > t3
   TYPE(Morison_InputType), INTENT(INOUT)  :: u2      ! Input at t2 > t3
   TYPE(Morison_InputType), INTENT(INOUT)  :: u3      ! Input at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Inputs
   TYPE(Morison_InputType), INTENT(INOUT)  :: u_out     ! Input at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'Morison_Input_ExtrapInterp2'
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   CALL MeshExtrapInterp2(u1%Mesh, u2%Mesh, u3%Mesh, tin, u_out%Mesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   u_out%PtfmRefY = a1*u1%PtfmRefY + a2*u2%PtfmRefY + a3*u3%PtfmRefY
END SUBROUTINE

subroutine Morison_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
   ! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(Morison_OutputType), intent(inout)  :: y(:) ! Output at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Outputs
   type(Morison_OutputType), intent(inout)  :: y_out ! Output at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'Morison_Output_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(y)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(y)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(y) - 1
   select case (order)
   case (0)
      call Morison_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call Morison_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call Morison_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(y) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE Morison_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

   TYPE(Morison_OutputType), INTENT(INOUT)  :: y1    ! Output at t1 > t2
   TYPE(Morison_OutputType), INTENT(INOUT)  :: y2    ! Output at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
   TYPE(Morison_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'Morison_Output_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   CALL MeshExtrapInterp1(y1%Mesh, y2%Mesh, tin, y_out%Mesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp1(y1%VisMesh, y2%VisMesh, tin, y_out%VisMesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
      y_out%WriteOutput = a1*y1%WriteOutput + a2*y2%WriteOutput
   END IF ! check if allocated
END SUBROUTINE

SUBROUTINE Morison_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

   TYPE(Morison_OutputType), INTENT(INOUT)  :: y1      ! Output at t1 > t2 > t3
   TYPE(Morison_OutputType), INTENT(INOUT)  :: y2      ! Output at t2 > t3
   TYPE(Morison_OutputType), INTENT(INOUT)  :: y3      ! Output at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
   TYPE(Morison_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'Morison_Output_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   CALL MeshExtrapInterp2(y1%Mesh, y2%Mesh, y3%Mesh, tin, y_out%Mesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp2(y1%VisMesh, y2%VisMesh, y3%VisMesh, tin, y_out%VisMesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
      y_out%WriteOutput = a1*y1%WriteOutput + a2*y2%WriteOutput + a3*y3%WriteOutput
   END IF ! check if allocated
END SUBROUTINE
END MODULE Morison_Types
!ENDOFREGISTRYGENERATEDFILE
