!STARTOFREGISTRYGENERATEDFILE 'HydroDyn_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! HydroDyn_Types
!.................................................................................................................................
! This file is part of HydroDyn.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in HydroDyn. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE HydroDyn_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE Conv_Radiation_Types
USE SS_Radiation_Types
USE SS_Excitation_Types
USE WAMIT_Types
USE WAMIT2_Types
USE Morison_Types
USE NWTC_Library
IMPLICIT NONE
    INTEGER(IntKi), PUBLIC, PARAMETER  :: MaxHDOutputs = 510      ! The maximum number of output channels supported by this module [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: MaxUserOutputs = 5150      !  Total possible number of output channels:  SS_Excitation = 7 + SS_Radiation = 7 + Morison= 4626 + HydroDyn=510   =  5150 [-]
! =========  HydroDyn_InputFile  =======
  TYPE, PUBLIC :: HydroDyn_InputFile
    LOGICAL  :: EchoFlag = .false.      !< Echo the input file [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: AddF0      !< Additional pre-load forces and moments (N,N,N,N-m,N-m,N-m) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: AddCLin      !< Additional stiffness matrix [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: AddBLin      !< Additional linear damping matrix [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: AddBQuad      !< Additional quadratic damping (drag) matrix [-]
    CHARACTER(1024) , DIMENSION(:), ALLOCATABLE  :: PotFile      !< The name of the root potential flow file (without extension for WAMIT, complete name for FIT) [-]
    INTEGER(IntKi)  :: nWAMITObj = 0_IntKi      !< number of WAMIT input files.  If NBodyMod = 1 then nPotFiles will be 1 even if NBody > 1 [-]
    INTEGER(IntKi)  :: vecMultiplier = 0_IntKi      !< multiplier for the WAMIT vectors and matrices.  If NBodyMod=1 then this = NBody, else 1 [-]
    INTEGER(IntKi)  :: NBody = 0_IntKi      !< [>=1; only used when PotMod=1. If NBodyMod=1, the WAMIT data contains a vector of size 6*NBody x 1 and matrices of size 6*NBody x 6*NBody; if NBodyMod>1, there are NBody sets of WAMIT data each with a vector of size 6 x 1 and matrices of size 6 x 6] [-]
    INTEGER(IntKi)  :: NBodyMod = 0_IntKi      !< Body coupling model {1: include coupling terms between each body and NBody in HydroDyn equals NBODY in WAMIT, 2: neglect coupling terms between each body and NBODY=1 with XBODY=0 in WAMIT, 3: Neglect coupling terms between each body and NBODY=1 with XBODY=/0 in WAMIT} (switch) [only used when PotMod=1] [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: PtfmVol0      !<  [-]
    LOGICAL  :: HasWAMIT = .false.      !< .TRUE. if using WAMIT model, .FALSE. otherwise [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WAMITULEN      !<  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: PtfmRefxt      !< The xt offset of the body reference point(s) from (0,0,0)  [1 to NBody; only used when PotMod=1; must be 0.0 if NBodyMod=2 ] [(m)]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: PtfmRefyt      !< The yt offset of the body reference point(s) from (0,0,0)  [1 to NBody; only used when PotMod=1; must be 0.0 if NBodyMod=2 ] [(m)]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: PtfmRefzt      !< The zt offset of the body reference point(s) from (0,0,0)  [1 to NBody; only used when PotMod=1; must be 0.0 if NBodyMod=2 ] [(m)]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: PtfmRefztRot      !< The rotation about zt of the body reference frame(s) from xt/yt [radians]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: PtfmCOBxt      !<  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: PtfmCOByt      !<  [-]
    TYPE(WAMIT_InitInputType)  :: WAMIT      !< Initialization data for WAMIT module [-]
    TYPE(WAMIT2_InitInputType)  :: WAMIT2      !< Initialization data for WAMIT2 module [-]
    TYPE(Morison_InitInputType)  :: Morison      !< Initialization data for Morison module [-]
    LOGICAL  :: Echo = .false.      !< Echo the input files to a file with the same name as the input but with a .echo extension [T/F] [-]
    INTEGER(IntKi)  :: PotMod = 0_IntKi      !< 1 if using WAMIT model, 0 if no potential flow model, or 2 if FIT model [-]
    INTEGER(IntKi)  :: NUserOutputs = 0_IntKi      !< Number of Hydrodyn-level requested output channels [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: UserOutputs      !< This should really be dimensioned with MaxOutPts [-]
    INTEGER(IntKi)  :: OutSwtch = 0_IntKi      !< Output requested channels to: [1=Hydrodyn.out 2=GlueCode.out  3=both files] [-]
    LOGICAL  :: OutAll = .false.      !< Output all user-specified member and joint loads (only at each member end, not interior locations) [T/F] [-]
    INTEGER(IntKi)  :: NumOuts = 0_IntKi      !< The number of outputs for this module as requested in the input file [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: OutList      !< The user-requested output channel labels for this modules. This should really be dimensioned with MaxOutPts [-]
    LOGICAL  :: HDSum = .false.      !< Generate a HydroDyn summary file [T/F] [-]
    INTEGER(IntKi)  :: UnSum = 0_IntKi      !< File unit for the HydroDyn summary file [-1 = no summary file] [-]
    CHARACTER(20)  :: OutFmt      !< Output format for numerical results [-]
    CHARACTER(20)  :: OutSFmt      !< Output format for header strings [-]
    INTEGER(IntKi)  :: PtfmYMod = 0_IntKi      !< Large yaw model [-]
    REAL(ReKi)  :: PtfmRefY = 0.0_ReKi      !< Initial reference yaw offset [(rad)]
    REAL(ReKi)  :: PtfmYCutoff = 0.0_ReKi      !< Low-pass cutoff frequency for filtering the platform yaw motion to obtain the reference yaw offset [(Hz)]
  END TYPE HydroDyn_InputFile
! =======================
! =========  HydroDyn_InitInputType  =======
  TYPE, PUBLIC :: HydroDyn_InitInputType
    CHARACTER(1024)  :: InputFile      !< Supplied by Driver:  full path and filename for the HydroDyn module [-]
    LOGICAL  :: UseInputFile = .TRUE.      !< Supplied by Driver:  .TRUE. if using a input file, .FALSE. if all inputs are being passed in by the caller [-]
    TYPE(FileInfoType)  :: PassedFileData      !< If we don't use the input file, pass everything through this [-]
    CHARACTER(1024)  :: OutRootName      !< Supplied by Driver:  The name of the root file (without extension) including the full path [-]
    LOGICAL  :: Linearize = .FALSE.      !< Flag that tells this module if the glue code wants to linearize. [-]
    REAL(ReKi)  :: Gravity = 0.0_ReKi      !< Supplied by Driver:  Gravitational acceleration [(m/s^2)]
    REAL(DbKi)  :: TMax = 0.0_R8Ki      !< Supplied by Driver:  The total simulation time [(sec)]
    LOGICAL  :: VisMeshes = .false.      !< Output visualization meshes [-]
    LOGICAL  :: InvalidWithSSExctn = .false.      !< Whether SeaState configuration is invalid with HydroDyn's state-space excitation (ExctnMod=2) [(-)]
    TYPE(SeaSt_WaveFieldType) , POINTER :: WaveField => NULL()      !< Pointer to SeaState wave field [-]
    REAL(ReKi) , DIMENSION(1:6)  :: PlatformPos = 0.0_ReKi      !< Initial platform position (6 DOFs) [-]
  END TYPE HydroDyn_InitInputType
! =======================
! =========  HydroDyn_InitOutputType  =======
  TYPE, PUBLIC :: HydroDyn_InitOutputType
    TYPE(Morison_InitOutputType)  :: Morison      !< Initialization output from the Morison module [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputHdr      !< The is the list of all HD-related output channel header strings (includes all sub-module channels) [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputUnt      !< The is the list of all HD-related output channel unit strings (includes all sub-module channels) [-]
    TYPE(ProgDesc)  :: Ver      !< Version of HydroDyn [-]
    CHARACTER(LinChanLen) , DIMENSION(:), ALLOCATABLE  :: LinNames_y      !< Names of the outputs used in linearization [-]
    CHARACTER(LinChanLen) , DIMENSION(:), ALLOCATABLE  :: LinNames_x      !< Names of the continuous states used in linearization [-]
    CHARACTER(LinChanLen) , DIMENSION(:), ALLOCATABLE  :: LinNames_u      !< Names of the inputs used in linearization [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: DerivOrder_x      !< Integer that tells FAST/MBC3 the maximum derivative order of continuous states used in linearization [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: IsLoad_u      !< Flag that tells FAST if the inputs used in linearization are loads (for preconditioning matrix) [-]
  END TYPE HydroDyn_InitOutputType
! =======================
! =========  HD_ModuleMapType  =======
  TYPE, PUBLIC :: HD_ModuleMapType
    TYPE(MeshMapType)  :: uW_P_2_PRP_P      !< Mesh mapping data: WAMIT body kinematics to PRP node at (0,0,0) [-]
    TYPE(MeshMapType)  :: W_P_2_PRP_P      !< Mesh mapping data: WAMIT loads to PRP node at (0,0,0) [-]
    TYPE(MeshMapType)  :: M_P_2_PRP_P      !< Mesh mapping data: lumped Morison loads to PRP node at (0,0,0) [-]
  END TYPE HD_ModuleMapType
! =======================
! =========  HydroDyn_ContinuousStateType  =======
  TYPE, PUBLIC :: HydroDyn_ContinuousStateType
    TYPE(WAMIT_ContinuousStateType) , DIMENSION(:), ALLOCATABLE  :: WAMIT      !< continuous states from the wamit module [-]
    TYPE(Morison_ContinuousStateType)  :: Morison      !< continuous states from the Morison module [-]
  END TYPE HydroDyn_ContinuousStateType
! =======================
! =========  HydroDyn_DiscreteStateType  =======
  TYPE, PUBLIC :: HydroDyn_DiscreteStateType
    TYPE(WAMIT_DiscreteStateType) , DIMENSION(:), ALLOCATABLE  :: WAMIT      !< discrete states from the wamit module [-]
    TYPE(Morison_DiscreteStateType)  :: Morison      !< discrete states from the Morison module [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: PtfmRefY      !< Reference yaw position of the PRP relative to the inertial frame - Current step and two previous steps [(radians)]
  END TYPE HydroDyn_DiscreteStateType
! =======================
! =========  HydroDyn_ConstraintStateType  =======
  TYPE, PUBLIC :: HydroDyn_ConstraintStateType
    TYPE(WAMIT_ConstraintStateType)  :: WAMIT      !< constraint states from WAMIT (may be empty) [-]
    TYPE(Morison_ConstraintStateType)  :: Morison      !< constraint states from the Morison module [-]
  END TYPE HydroDyn_ConstraintStateType
! =======================
! =========  HydroDyn_OtherStateType  =======
  TYPE, PUBLIC :: HydroDyn_OtherStateType
    TYPE(WAMIT_OtherStateType) , DIMENSION(:), ALLOCATABLE  :: WAMIT      !< OtherState information from the WAMIT module [-]
    TYPE(Morison_OtherStateType)  :: Morison      !< OtherState information from the Morison module [-]
  END TYPE HydroDyn_OtherStateType
! =======================
! =========  HydroDyn_MiscVarType  =======
  TYPE, PUBLIC :: HydroDyn_MiscVarType
    TYPE(MeshType)  :: AllHdroOrigin      !< An intermediate mesh used to transfer hydrodynamic loads from the various HD-related meshes to the AllHdroOrigin mesh [-]
    TYPE(HD_ModuleMapType)  :: HD_MeshMap 
    INTEGER(IntKi)  :: Decimate = 0_IntKi      !< The output decimation counter [-]
    REAL(DbKi)  :: LastOutTime = 0.0_R8Ki      !< Last time step which was written to the output file (sec) [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: F_PtfmAdd      !< The total forces and moments due to additional pre-load, stiffness, and damping [-]
    REAL(ReKi) , DIMENSION(1:6)  :: F_Hydro = 0.0_ReKi      !< The total hydrodynamic forces and moments integrated about the (0,0,0) platform reference point [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: F_Waves      !< The total waves forces on a WAMIT body calculated by first and second order methods (WAMIT and WAMIT2 modules) [-]
    TYPE(WAMIT_MiscVarType) , DIMENSION(:), ALLOCATABLE  :: WAMIT      !< misc var information from the WAMIT module [-]
    TYPE(WAMIT2_MiscVarType) , DIMENSION(:), ALLOCATABLE  :: WAMIT2      !< misc var information from the WAMIT2 module [-]
    TYPE(Morison_MiscVarType)  :: Morison      !< misc var information from the Morison module [-]
    TYPE(WAMIT_InputType) , DIMENSION(:), ALLOCATABLE  :: u_WAMIT      !< WAMIT module inputs [-]
  END TYPE HydroDyn_MiscVarType
! =======================
! =========  HydroDyn_ParameterType  =======
  TYPE, PUBLIC :: HydroDyn_ParameterType
    INTEGER(IntKi)  :: nWAMITObj = 0_IntKi      !< number of WAMIT input files and matrices.  If NBodyMod = 1 then nPotFiles will be 1 even if NBody > 1 [-]
    INTEGER(IntKi)  :: vecMultiplier = 0_IntKi      !< multiplier for the WAMIT vectors and matrices.  If NBodyMod=1 then this = NBody, else 1 [-]
    TYPE(WAMIT_ParameterType) , DIMENSION(:), ALLOCATABLE  :: WAMIT      !< Parameter data for the WAMIT module [-]
    TYPE(WAMIT2_ParameterType) , DIMENSION(:), ALLOCATABLE  :: WAMIT2      !< Parameter data for the WAMIT2 module [-]
    LOGICAL  :: WAMIT2used = .FALSE.      !< Indicates when WAMIT2 is used.  Shortcuts some calculations [-]
    TYPE(Morison_ParameterType)  :: Morison      !< Parameter data for the Morison module [-]
    INTEGER(IntKi)  :: PotMod = 0_IntKi      !< 1 if using WAMIT model, 0 if no potential flow model, or 2 if FIT model [-]
    INTEGER(IntKi)  :: NBody = 0_IntKi      !< [>=1; only used when PotMod=1. If NBodyMod=1, the WAMIT data contains a vector of size 6*NBody x 1 and matrices of size 6*NBody x 6*NBody; if NBodyMod>1, there are NBody sets of WAMIT data each with a vector of size 6 x 1 and matrices of size 6 x 6] [-]
    INTEGER(IntKi)  :: NBodyMod = 0_IntKi      !< Body coupling model {1: include coupling terms between each body and NBody in HydroDyn equals NBODY in WAMIT, 2: neglect coupling terms between each body and NBODY=1 with XBODY=0 in WAMIT, 3: Neglect coupling terms between each body and NBODY=1 with XBODY=/0 in WAMIT} (switch) [only used when PotMod=1] [-]
    INTEGER(IntKi)  :: totalStates = 0_IntKi      !< Number of excitation and radiation states for all WAMIT bodies [-]
    INTEGER(IntKi)  :: totalExctnStates = 0_IntKi      !< Number of excitation states for all WAMIT bodies [-]
    INTEGER(IntKi)  :: totalRdtnStates = 0_IntKi      !< Number of radiation states for all WAMIT bodies [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: AddF0      !< Additional pre-load forces and moments (N,N,N,N-m,N-m,N-m) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: AddCLin      !< Additional stiffness matrix [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: AddBLin      !< Additional linear damping matrix [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: AddBQuad      !< Additional quadratic damping (drag) matrix [-]
    REAL(DbKi)  :: DT = 0.0_R8Ki      !< Time step in seconds for integration of continuous states (if a fixed-step integrator is used) and update of discrete states [-]
    TYPE(OutParmType) , DIMENSION(:), ALLOCATABLE  :: OutParam      !<  [-]
    INTEGER(IntKi)  :: NumOuts = 0_IntKi      !< Number of HydroDyn module-level outputs (not the total number including sub-modules [-]
    INTEGER(IntKi)  :: NumTotalOuts = 0_IntKi      !< Number of all requested outputs including sub-modules [-]
    INTEGER(IntKi)  :: OutSwtch = 0_IntKi      !< Output requested channels to: [1=Hydrodyn.out 2=GlueCode.out  3=both files] [-]
    CHARACTER(20)  :: OutFmt      !< Output format for numerical results [-]
    CHARACTER(20)  :: OutSFmt      !< Output format for header strings [-]
    CHARACTER(ChanLen)  :: Delim      !< Delimiter string for outputs, defaults to tab-delimiters [-]
    INTEGER(IntKi)  :: UnOutFile = 0_IntKi      !< File unit for the HydroDyn outputs [-]
    INTEGER(IntKi)  :: OutDec = 0_IntKi      !< Write every OutDec time steps [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: Jac_u_indx      !< matrix to help fill/pack the u vector in computing the jacobian [-]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: du      !< vector that determines size of perturbation for u (inputs) [-]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: dx      !< vector that determines size of perturbation for x (continuous states) [-]
    INTEGER(IntKi)  :: Jac_ny = 0_IntKi      !< number of outputs in jacobian matrix [-]
    LOGICAL  :: VisMeshes = .false.      !< Output visualization meshes [-]
    TYPE(SeaSt_WaveFieldType) , POINTER :: WaveField => NULL()      !< Pointer to SeaState wave field [-]
    INTEGER(IntKi)  :: PtfmYMod = 0_IntKi      !< Large yaw model [-]
    REAL(ReKi)  :: CYawFilt = 0.0_ReKi      !< Low-pass filter constant for reference platform yaw position PtfmRefY [-]
  END TYPE HydroDyn_ParameterType
! =======================
! =========  HydroDyn_InputType  =======
  TYPE, PUBLIC :: HydroDyn_InputType
    TYPE(Morison_InputType)  :: Morison      !< Morison module inputs [-]
    TYPE(MeshType)  :: WAMITMesh      !< Motions at the WAMIT reference point(s) in the inertial frame [-]
    TYPE(MeshType)  :: PRPMesh      !< Motions at the Platform reference point in the inertial frame [-]
  END TYPE HydroDyn_InputType
! =======================
! =========  HydroDyn_OutputType  =======
  TYPE, PUBLIC :: HydroDyn_OutputType
    TYPE(WAMIT_OutputType) , DIMENSION(:), ALLOCATABLE  :: WAMIT      !< WAMIT module outputs [-]
    TYPE(WAMIT2_OutputType) , DIMENSION(:), ALLOCATABLE  :: WAMIT2      !< WAMIT2 module outputs [-]
    TYPE(Morison_OutputType)  :: Morison      !< Morison module outputs [-]
    TYPE(MeshType)  :: WAMITMesh      !< Point Loads at the WAMIT reference point(s) in the inertial frame [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WriteOutput      !< Outputs to be written to the output file(s) [-]
  END TYPE HydroDyn_OutputType
! =======================
CONTAINS

subroutine HydroDyn_CopyInputFile(SrcInputFileData, DstInputFileData, CtrlCode, ErrStat, ErrMsg)
   type(HydroDyn_InputFile), intent(in) :: SrcInputFileData
   type(HydroDyn_InputFile), intent(inout) :: DstInputFileData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'HydroDyn_CopyInputFile'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInputFileData%EchoFlag = SrcInputFileData%EchoFlag
   if (allocated(SrcInputFileData%AddF0)) then
      LB(1:2) = lbound(SrcInputFileData%AddF0)
      UB(1:2) = ubound(SrcInputFileData%AddF0)
      if (.not. allocated(DstInputFileData%AddF0)) then
         allocate(DstInputFileData%AddF0(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%AddF0.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%AddF0 = SrcInputFileData%AddF0
   end if
   if (allocated(SrcInputFileData%AddCLin)) then
      LB(1:3) = lbound(SrcInputFileData%AddCLin)
      UB(1:3) = ubound(SrcInputFileData%AddCLin)
      if (.not. allocated(DstInputFileData%AddCLin)) then
         allocate(DstInputFileData%AddCLin(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%AddCLin.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%AddCLin = SrcInputFileData%AddCLin
   end if
   if (allocated(SrcInputFileData%AddBLin)) then
      LB(1:3) = lbound(SrcInputFileData%AddBLin)
      UB(1:3) = ubound(SrcInputFileData%AddBLin)
      if (.not. allocated(DstInputFileData%AddBLin)) then
         allocate(DstInputFileData%AddBLin(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%AddBLin.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%AddBLin = SrcInputFileData%AddBLin
   end if
   if (allocated(SrcInputFileData%AddBQuad)) then
      LB(1:3) = lbound(SrcInputFileData%AddBQuad)
      UB(1:3) = ubound(SrcInputFileData%AddBQuad)
      if (.not. allocated(DstInputFileData%AddBQuad)) then
         allocate(DstInputFileData%AddBQuad(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%AddBQuad.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%AddBQuad = SrcInputFileData%AddBQuad
   end if
   if (allocated(SrcInputFileData%PotFile)) then
      LB(1:1) = lbound(SrcInputFileData%PotFile)
      UB(1:1) = ubound(SrcInputFileData%PotFile)
      if (.not. allocated(DstInputFileData%PotFile)) then
         allocate(DstInputFileData%PotFile(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%PotFile.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%PotFile = SrcInputFileData%PotFile
   end if
   DstInputFileData%nWAMITObj = SrcInputFileData%nWAMITObj
   DstInputFileData%vecMultiplier = SrcInputFileData%vecMultiplier
   DstInputFileData%NBody = SrcInputFileData%NBody
   DstInputFileData%NBodyMod = SrcInputFileData%NBodyMod
   if (allocated(SrcInputFileData%PtfmVol0)) then
      LB(1:1) = lbound(SrcInputFileData%PtfmVol0)
      UB(1:1) = ubound(SrcInputFileData%PtfmVol0)
      if (.not. allocated(DstInputFileData%PtfmVol0)) then
         allocate(DstInputFileData%PtfmVol0(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%PtfmVol0.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%PtfmVol0 = SrcInputFileData%PtfmVol0
   end if
   DstInputFileData%HasWAMIT = SrcInputFileData%HasWAMIT
   if (allocated(SrcInputFileData%WAMITULEN)) then
      LB(1:1) = lbound(SrcInputFileData%WAMITULEN)
      UB(1:1) = ubound(SrcInputFileData%WAMITULEN)
      if (.not. allocated(DstInputFileData%WAMITULEN)) then
         allocate(DstInputFileData%WAMITULEN(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%WAMITULEN.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%WAMITULEN = SrcInputFileData%WAMITULEN
   end if
   if (allocated(SrcInputFileData%PtfmRefxt)) then
      LB(1:1) = lbound(SrcInputFileData%PtfmRefxt)
      UB(1:1) = ubound(SrcInputFileData%PtfmRefxt)
      if (.not. allocated(DstInputFileData%PtfmRefxt)) then
         allocate(DstInputFileData%PtfmRefxt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%PtfmRefxt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%PtfmRefxt = SrcInputFileData%PtfmRefxt
   end if
   if (allocated(SrcInputFileData%PtfmRefyt)) then
      LB(1:1) = lbound(SrcInputFileData%PtfmRefyt)
      UB(1:1) = ubound(SrcInputFileData%PtfmRefyt)
      if (.not. allocated(DstInputFileData%PtfmRefyt)) then
         allocate(DstInputFileData%PtfmRefyt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%PtfmRefyt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%PtfmRefyt = SrcInputFileData%PtfmRefyt
   end if
   if (allocated(SrcInputFileData%PtfmRefzt)) then
      LB(1:1) = lbound(SrcInputFileData%PtfmRefzt)
      UB(1:1) = ubound(SrcInputFileData%PtfmRefzt)
      if (.not. allocated(DstInputFileData%PtfmRefzt)) then
         allocate(DstInputFileData%PtfmRefzt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%PtfmRefzt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%PtfmRefzt = SrcInputFileData%PtfmRefzt
   end if
   if (allocated(SrcInputFileData%PtfmRefztRot)) then
      LB(1:1) = lbound(SrcInputFileData%PtfmRefztRot)
      UB(1:1) = ubound(SrcInputFileData%PtfmRefztRot)
      if (.not. allocated(DstInputFileData%PtfmRefztRot)) then
         allocate(DstInputFileData%PtfmRefztRot(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%PtfmRefztRot.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%PtfmRefztRot = SrcInputFileData%PtfmRefztRot
   end if
   if (allocated(SrcInputFileData%PtfmCOBxt)) then
      LB(1:1) = lbound(SrcInputFileData%PtfmCOBxt)
      UB(1:1) = ubound(SrcInputFileData%PtfmCOBxt)
      if (.not. allocated(DstInputFileData%PtfmCOBxt)) then
         allocate(DstInputFileData%PtfmCOBxt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%PtfmCOBxt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%PtfmCOBxt = SrcInputFileData%PtfmCOBxt
   end if
   if (allocated(SrcInputFileData%PtfmCOByt)) then
      LB(1:1) = lbound(SrcInputFileData%PtfmCOByt)
      UB(1:1) = ubound(SrcInputFileData%PtfmCOByt)
      if (.not. allocated(DstInputFileData%PtfmCOByt)) then
         allocate(DstInputFileData%PtfmCOByt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%PtfmCOByt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%PtfmCOByt = SrcInputFileData%PtfmCOByt
   end if
   call WAMIT_CopyInitInput(SrcInputFileData%WAMIT, DstInputFileData%WAMIT, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call WAMIT2_CopyInitInput(SrcInputFileData%WAMIT2, DstInputFileData%WAMIT2, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call Morison_CopyInitInput(SrcInputFileData%Morison, DstInputFileData%Morison, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstInputFileData%Echo = SrcInputFileData%Echo
   DstInputFileData%PotMod = SrcInputFileData%PotMod
   DstInputFileData%NUserOutputs = SrcInputFileData%NUserOutputs
   if (allocated(SrcInputFileData%UserOutputs)) then
      LB(1:1) = lbound(SrcInputFileData%UserOutputs)
      UB(1:1) = ubound(SrcInputFileData%UserOutputs)
      if (.not. allocated(DstInputFileData%UserOutputs)) then
         allocate(DstInputFileData%UserOutputs(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%UserOutputs.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%UserOutputs = SrcInputFileData%UserOutputs
   end if
   DstInputFileData%OutSwtch = SrcInputFileData%OutSwtch
   DstInputFileData%OutAll = SrcInputFileData%OutAll
   DstInputFileData%NumOuts = SrcInputFileData%NumOuts
   if (allocated(SrcInputFileData%OutList)) then
      LB(1:1) = lbound(SrcInputFileData%OutList)
      UB(1:1) = ubound(SrcInputFileData%OutList)
      if (.not. allocated(DstInputFileData%OutList)) then
         allocate(DstInputFileData%OutList(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%OutList.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%OutList = SrcInputFileData%OutList
   end if
   DstInputFileData%HDSum = SrcInputFileData%HDSum
   DstInputFileData%UnSum = SrcInputFileData%UnSum
   DstInputFileData%OutFmt = SrcInputFileData%OutFmt
   DstInputFileData%OutSFmt = SrcInputFileData%OutSFmt
   DstInputFileData%PtfmYMod = SrcInputFileData%PtfmYMod
   DstInputFileData%PtfmRefY = SrcInputFileData%PtfmRefY
   DstInputFileData%PtfmYCutoff = SrcInputFileData%PtfmYCutoff
end subroutine

subroutine HydroDyn_DestroyInputFile(InputFileData, ErrStat, ErrMsg)
   type(HydroDyn_InputFile), intent(inout) :: InputFileData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'HydroDyn_DestroyInputFile'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InputFileData%AddF0)) then
      deallocate(InputFileData%AddF0)
   end if
   if (allocated(InputFileData%AddCLin)) then
      deallocate(InputFileData%AddCLin)
   end if
   if (allocated(InputFileData%AddBLin)) then
      deallocate(InputFileData%AddBLin)
   end if
   if (allocated(InputFileData%AddBQuad)) then
      deallocate(InputFileData%AddBQuad)
   end if
   if (allocated(InputFileData%PotFile)) then
      deallocate(InputFileData%PotFile)
   end if
   if (allocated(InputFileData%PtfmVol0)) then
      deallocate(InputFileData%PtfmVol0)
   end if
   if (allocated(InputFileData%WAMITULEN)) then
      deallocate(InputFileData%WAMITULEN)
   end if
   if (allocated(InputFileData%PtfmRefxt)) then
      deallocate(InputFileData%PtfmRefxt)
   end if
   if (allocated(InputFileData%PtfmRefyt)) then
      deallocate(InputFileData%PtfmRefyt)
   end if
   if (allocated(InputFileData%PtfmRefzt)) then
      deallocate(InputFileData%PtfmRefzt)
   end if
   if (allocated(InputFileData%PtfmRefztRot)) then
      deallocate(InputFileData%PtfmRefztRot)
   end if
   if (allocated(InputFileData%PtfmCOBxt)) then
      deallocate(InputFileData%PtfmCOBxt)
   end if
   if (allocated(InputFileData%PtfmCOByt)) then
      deallocate(InputFileData%PtfmCOByt)
   end if
   call WAMIT_DestroyInitInput(InputFileData%WAMIT, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call WAMIT2_DestroyInitInput(InputFileData%WAMIT2, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call Morison_DestroyInitInput(InputFileData%Morison, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(InputFileData%UserOutputs)) then
      deallocate(InputFileData%UserOutputs)
   end if
   if (allocated(InputFileData%OutList)) then
      deallocate(InputFileData%OutList)
   end if
end subroutine

subroutine HydroDyn_PackInputFile(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(HydroDyn_InputFile), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'HydroDyn_PackInputFile'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%EchoFlag)
   call RegPackAlloc(RF, InData%AddF0)
   call RegPackAlloc(RF, InData%AddCLin)
   call RegPackAlloc(RF, InData%AddBLin)
   call RegPackAlloc(RF, InData%AddBQuad)
   call RegPackAlloc(RF, InData%PotFile)
   call RegPack(RF, InData%nWAMITObj)
   call RegPack(RF, InData%vecMultiplier)
   call RegPack(RF, InData%NBody)
   call RegPack(RF, InData%NBodyMod)
   call RegPackAlloc(RF, InData%PtfmVol0)
   call RegPack(RF, InData%HasWAMIT)
   call RegPackAlloc(RF, InData%WAMITULEN)
   call RegPackAlloc(RF, InData%PtfmRefxt)
   call RegPackAlloc(RF, InData%PtfmRefyt)
   call RegPackAlloc(RF, InData%PtfmRefzt)
   call RegPackAlloc(RF, InData%PtfmRefztRot)
   call RegPackAlloc(RF, InData%PtfmCOBxt)
   call RegPackAlloc(RF, InData%PtfmCOByt)
   call WAMIT_PackInitInput(RF, InData%WAMIT) 
   call WAMIT2_PackInitInput(RF, InData%WAMIT2) 
   call Morison_PackInitInput(RF, InData%Morison) 
   call RegPack(RF, InData%Echo)
   call RegPack(RF, InData%PotMod)
   call RegPack(RF, InData%NUserOutputs)
   call RegPackAlloc(RF, InData%UserOutputs)
   call RegPack(RF, InData%OutSwtch)
   call RegPack(RF, InData%OutAll)
   call RegPack(RF, InData%NumOuts)
   call RegPackAlloc(RF, InData%OutList)
   call RegPack(RF, InData%HDSum)
   call RegPack(RF, InData%UnSum)
   call RegPack(RF, InData%OutFmt)
   call RegPack(RF, InData%OutSFmt)
   call RegPack(RF, InData%PtfmYMod)
   call RegPack(RF, InData%PtfmRefY)
   call RegPack(RF, InData%PtfmYCutoff)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine HydroDyn_UnPackInputFile(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(HydroDyn_InputFile), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'HydroDyn_UnPackInputFile'
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%EchoFlag); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AddF0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AddCLin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AddBLin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AddBQuad); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PotFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nWAMITObj); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%vecMultiplier); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NBody); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NBodyMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PtfmVol0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HasWAMIT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WAMITULEN); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PtfmRefxt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PtfmRefyt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PtfmRefzt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PtfmRefztRot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PtfmCOBxt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PtfmCOByt); if (RegCheckErr(RF, RoutineName)) return
   call WAMIT_UnpackInitInput(RF, OutData%WAMIT) ! WAMIT 
   call WAMIT2_UnpackInitInput(RF, OutData%WAMIT2) ! WAMIT2 
   call Morison_UnpackInitInput(RF, OutData%Morison) ! Morison 
   call RegUnpack(RF, OutData%Echo); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PotMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NUserOutputs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%UserOutputs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutSwtch); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutAll); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%OutList); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HDSum); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UnSum); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutFmt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutSFmt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmYMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmRefY); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmYCutoff); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine HydroDyn_CopyInitInput(SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg)
   type(HydroDyn_InitInputType), intent(in) :: SrcInitInputData
   type(HydroDyn_InitInputType), intent(inout) :: DstInitInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'HydroDyn_CopyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInitInputData%InputFile = SrcInitInputData%InputFile
   DstInitInputData%UseInputFile = SrcInitInputData%UseInputFile
   call NWTC_Library_CopyFileInfoType(SrcInitInputData%PassedFileData, DstInitInputData%PassedFileData, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstInitInputData%OutRootName = SrcInitInputData%OutRootName
   DstInitInputData%Linearize = SrcInitInputData%Linearize
   DstInitInputData%Gravity = SrcInitInputData%Gravity
   DstInitInputData%TMax = SrcInitInputData%TMax
   DstInitInputData%VisMeshes = SrcInitInputData%VisMeshes
   DstInitInputData%InvalidWithSSExctn = SrcInitInputData%InvalidWithSSExctn
   DstInitInputData%WaveField => SrcInitInputData%WaveField
   DstInitInputData%PlatformPos = SrcInitInputData%PlatformPos
end subroutine

subroutine HydroDyn_DestroyInitInput(InitInputData, ErrStat, ErrMsg)
   type(HydroDyn_InitInputType), intent(inout) :: InitInputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'HydroDyn_DestroyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call NWTC_Library_DestroyFileInfoType(InitInputData%PassedFileData, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   nullify(InitInputData%WaveField)
end subroutine

subroutine HydroDyn_PackInitInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(HydroDyn_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'HydroDyn_PackInitInput'
   logical         :: PtrInIndex
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%InputFile)
   call RegPack(RF, InData%UseInputFile)
   call NWTC_Library_PackFileInfoType(RF, InData%PassedFileData) 
   call RegPack(RF, InData%OutRootName)
   call RegPack(RF, InData%Linearize)
   call RegPack(RF, InData%Gravity)
   call RegPack(RF, InData%TMax)
   call RegPack(RF, InData%VisMeshes)
   call RegPack(RF, InData%InvalidWithSSExctn)
   call RegPack(RF, associated(InData%WaveField))
   if (associated(InData%WaveField)) then
      call RegPackPointer(RF, c_loc(InData%WaveField), PtrInIndex)
      if (.not. PtrInIndex) then
         call SeaSt_WaveField_PackSeaSt_WaveFieldType(RF, InData%WaveField) 
      end if
   end if
   call RegPack(RF, InData%PlatformPos)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine HydroDyn_UnPackInitInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(HydroDyn_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'HydroDyn_UnPackInitInput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   integer(B8Ki)   :: PtrIdx
   type(c_ptr)     :: Ptr
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%InputFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UseInputFile); if (RegCheckErr(RF, RoutineName)) return
   call NWTC_Library_UnpackFileInfoType(RF, OutData%PassedFileData) ! PassedFileData 
   call RegUnpack(RF, OutData%OutRootName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Linearize); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Gravity); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TMax); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VisMeshes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%InvalidWithSSExctn); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%WaveField)) deallocate(OutData%WaveField)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackPointer(RF, Ptr, PtrIdx); if (RegCheckErr(RF, RoutineName)) return
      if (c_associated(Ptr)) then
         call c_f_pointer(Ptr, OutData%WaveField)
      else
         allocate(OutData%WaveField,stat=stat)
         if (stat /= 0) then 
            call SetErrStat(ErrID_Fatal, 'Error allocating OutData%WaveField.', RF%ErrStat, RF%ErrMsg, RoutineName)
            return
         end if
         RF%Pointers(PtrIdx) = c_loc(OutData%WaveField)
         call SeaSt_WaveField_UnpackSeaSt_WaveFieldType(RF, OutData%WaveField) ! WaveField 
      end if
   else
      OutData%WaveField => null()
   end if
   call RegUnpack(RF, OutData%PlatformPos); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine HydroDyn_CopyInitOutput(SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg)
   type(HydroDyn_InitOutputType), intent(in) :: SrcInitOutputData
   type(HydroDyn_InitOutputType), intent(inout) :: DstInitOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'HydroDyn_CopyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call Morison_CopyInitOutput(SrcInitOutputData%Morison, DstInitOutputData%Morison, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcInitOutputData%WriteOutputHdr)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputHdr)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputHdr)
      if (.not. allocated(DstInitOutputData%WriteOutputHdr)) then
         allocate(DstInitOutputData%WriteOutputHdr(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputHdr.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputHdr = SrcInitOutputData%WriteOutputHdr
   end if
   if (allocated(SrcInitOutputData%WriteOutputUnt)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputUnt)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputUnt)
      if (.not. allocated(DstInitOutputData%WriteOutputUnt)) then
         allocate(DstInitOutputData%WriteOutputUnt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputUnt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputUnt = SrcInitOutputData%WriteOutputUnt
   end if
   call NWTC_Library_CopyProgDesc(SrcInitOutputData%Ver, DstInitOutputData%Ver, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcInitOutputData%LinNames_y)) then
      LB(1:1) = lbound(SrcInitOutputData%LinNames_y)
      UB(1:1) = ubound(SrcInitOutputData%LinNames_y)
      if (.not. allocated(DstInitOutputData%LinNames_y)) then
         allocate(DstInitOutputData%LinNames_y(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LinNames_y.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%LinNames_y = SrcInitOutputData%LinNames_y
   end if
   if (allocated(SrcInitOutputData%LinNames_x)) then
      LB(1:1) = lbound(SrcInitOutputData%LinNames_x)
      UB(1:1) = ubound(SrcInitOutputData%LinNames_x)
      if (.not. allocated(DstInitOutputData%LinNames_x)) then
         allocate(DstInitOutputData%LinNames_x(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LinNames_x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%LinNames_x = SrcInitOutputData%LinNames_x
   end if
   if (allocated(SrcInitOutputData%LinNames_u)) then
      LB(1:1) = lbound(SrcInitOutputData%LinNames_u)
      UB(1:1) = ubound(SrcInitOutputData%LinNames_u)
      if (.not. allocated(DstInitOutputData%LinNames_u)) then
         allocate(DstInitOutputData%LinNames_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LinNames_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%LinNames_u = SrcInitOutputData%LinNames_u
   end if
   if (allocated(SrcInitOutputData%DerivOrder_x)) then
      LB(1:1) = lbound(SrcInitOutputData%DerivOrder_x)
      UB(1:1) = ubound(SrcInitOutputData%DerivOrder_x)
      if (.not. allocated(DstInitOutputData%DerivOrder_x)) then
         allocate(DstInitOutputData%DerivOrder_x(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%DerivOrder_x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%DerivOrder_x = SrcInitOutputData%DerivOrder_x
   end if
   if (allocated(SrcInitOutputData%IsLoad_u)) then
      LB(1:1) = lbound(SrcInitOutputData%IsLoad_u)
      UB(1:1) = ubound(SrcInitOutputData%IsLoad_u)
      if (.not. allocated(DstInitOutputData%IsLoad_u)) then
         allocate(DstInitOutputData%IsLoad_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%IsLoad_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%IsLoad_u = SrcInitOutputData%IsLoad_u
   end if
end subroutine

subroutine HydroDyn_DestroyInitOutput(InitOutputData, ErrStat, ErrMsg)
   type(HydroDyn_InitOutputType), intent(inout) :: InitOutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'HydroDyn_DestroyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call Morison_DestroyInitOutput(InitOutputData%Morison, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(InitOutputData%WriteOutputHdr)) then
      deallocate(InitOutputData%WriteOutputHdr)
   end if
   if (allocated(InitOutputData%WriteOutputUnt)) then
      deallocate(InitOutputData%WriteOutputUnt)
   end if
   call NWTC_Library_DestroyProgDesc(InitOutputData%Ver, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(InitOutputData%LinNames_y)) then
      deallocate(InitOutputData%LinNames_y)
   end if
   if (allocated(InitOutputData%LinNames_x)) then
      deallocate(InitOutputData%LinNames_x)
   end if
   if (allocated(InitOutputData%LinNames_u)) then
      deallocate(InitOutputData%LinNames_u)
   end if
   if (allocated(InitOutputData%DerivOrder_x)) then
      deallocate(InitOutputData%DerivOrder_x)
   end if
   if (allocated(InitOutputData%IsLoad_u)) then
      deallocate(InitOutputData%IsLoad_u)
   end if
end subroutine

subroutine HydroDyn_PackInitOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(HydroDyn_InitOutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'HydroDyn_PackInitOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call Morison_PackInitOutput(RF, InData%Morison) 
   call RegPackAlloc(RF, InData%WriteOutputHdr)
   call RegPackAlloc(RF, InData%WriteOutputUnt)
   call NWTC_Library_PackProgDesc(RF, InData%Ver) 
   call RegPackAlloc(RF, InData%LinNames_y)
   call RegPackAlloc(RF, InData%LinNames_x)
   call RegPackAlloc(RF, InData%LinNames_u)
   call RegPackAlloc(RF, InData%DerivOrder_x)
   call RegPackAlloc(RF, InData%IsLoad_u)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine HydroDyn_UnPackInitOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(HydroDyn_InitOutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'HydroDyn_UnPackInitOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call Morison_UnpackInitOutput(RF, OutData%Morison) ! Morison 
   call RegUnpackAlloc(RF, OutData%WriteOutputHdr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutputUnt); if (RegCheckErr(RF, RoutineName)) return
   call NWTC_Library_UnpackProgDesc(RF, OutData%Ver) ! Ver 
   call RegUnpackAlloc(RF, OutData%LinNames_y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LinNames_x); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LinNames_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%DerivOrder_x); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%IsLoad_u); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine HydroDyn_CopyHD_ModuleMapType(SrcHD_ModuleMapTypeData, DstHD_ModuleMapTypeData, CtrlCode, ErrStat, ErrMsg)
   type(HD_ModuleMapType), intent(inout) :: SrcHD_ModuleMapTypeData
   type(HD_ModuleMapType), intent(inout) :: DstHD_ModuleMapTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'HydroDyn_CopyHD_ModuleMapType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call NWTC_Library_CopyMeshMapType(SrcHD_ModuleMapTypeData%uW_P_2_PRP_P, DstHD_ModuleMapTypeData%uW_P_2_PRP_P, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call NWTC_Library_CopyMeshMapType(SrcHD_ModuleMapTypeData%W_P_2_PRP_P, DstHD_ModuleMapTypeData%W_P_2_PRP_P, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call NWTC_Library_CopyMeshMapType(SrcHD_ModuleMapTypeData%M_P_2_PRP_P, DstHD_ModuleMapTypeData%M_P_2_PRP_P, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine HydroDyn_DestroyHD_ModuleMapType(HD_ModuleMapTypeData, ErrStat, ErrMsg)
   type(HD_ModuleMapType), intent(inout) :: HD_ModuleMapTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'HydroDyn_DestroyHD_ModuleMapType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call NWTC_Library_DestroyMeshMapType(HD_ModuleMapTypeData%uW_P_2_PRP_P, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call NWTC_Library_DestroyMeshMapType(HD_ModuleMapTypeData%W_P_2_PRP_P, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call NWTC_Library_DestroyMeshMapType(HD_ModuleMapTypeData%M_P_2_PRP_P, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine HydroDyn_PackHD_ModuleMapType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(HD_ModuleMapType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'HydroDyn_PackHD_ModuleMapType'
   if (RF%ErrStat >= AbortErrLev) return
   call NWTC_Library_PackMeshMapType(RF, InData%uW_P_2_PRP_P) 
   call NWTC_Library_PackMeshMapType(RF, InData%W_P_2_PRP_P) 
   call NWTC_Library_PackMeshMapType(RF, InData%M_P_2_PRP_P) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine HydroDyn_UnPackHD_ModuleMapType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(HD_ModuleMapType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'HydroDyn_UnPackHD_ModuleMapType'
   if (RF%ErrStat /= ErrID_None) return
   call NWTC_Library_UnpackMeshMapType(RF, OutData%uW_P_2_PRP_P) ! uW_P_2_PRP_P 
   call NWTC_Library_UnpackMeshMapType(RF, OutData%W_P_2_PRP_P) ! W_P_2_PRP_P 
   call NWTC_Library_UnpackMeshMapType(RF, OutData%M_P_2_PRP_P) ! M_P_2_PRP_P 
end subroutine

subroutine HydroDyn_CopyContState(SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg)
   type(HydroDyn_ContinuousStateType), intent(in) :: SrcContStateData
   type(HydroDyn_ContinuousStateType), intent(inout) :: DstContStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'HydroDyn_CopyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcContStateData%WAMIT)) then
      LB(1:1) = lbound(SrcContStateData%WAMIT)
      UB(1:1) = ubound(SrcContStateData%WAMIT)
      if (.not. allocated(DstContStateData%WAMIT)) then
         allocate(DstContStateData%WAMIT(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstContStateData%WAMIT.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call WAMIT_CopyContState(SrcContStateData%WAMIT(i1), DstContStateData%WAMIT(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call Morison_CopyContState(SrcContStateData%Morison, DstContStateData%Morison, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine HydroDyn_DestroyContState(ContStateData, ErrStat, ErrMsg)
   type(HydroDyn_ContinuousStateType), intent(inout) :: ContStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'HydroDyn_DestroyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ContStateData%WAMIT)) then
      LB(1:1) = lbound(ContStateData%WAMIT)
      UB(1:1) = ubound(ContStateData%WAMIT)
      do i1 = LB(1), UB(1)
         call WAMIT_DestroyContState(ContStateData%WAMIT(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ContStateData%WAMIT)
   end if
   call Morison_DestroyContState(ContStateData%Morison, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine HydroDyn_PackContState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(HydroDyn_ContinuousStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'HydroDyn_PackContState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%WAMIT))
   if (allocated(InData%WAMIT)) then
      call RegPackBounds(RF, 1, lbound(InData%WAMIT), ubound(InData%WAMIT))
      LB(1:1) = lbound(InData%WAMIT)
      UB(1:1) = ubound(InData%WAMIT)
      do i1 = LB(1), UB(1)
         call WAMIT_PackContState(RF, InData%WAMIT(i1)) 
      end do
   end if
   call Morison_PackContState(RF, InData%Morison) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine HydroDyn_UnPackContState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(HydroDyn_ContinuousStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'HydroDyn_UnPackContState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%WAMIT)) deallocate(OutData%WAMIT)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%WAMIT(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%WAMIT.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call WAMIT_UnpackContState(RF, OutData%WAMIT(i1)) ! WAMIT 
      end do
   end if
   call Morison_UnpackContState(RF, OutData%Morison) ! Morison 
end subroutine

subroutine HydroDyn_CopyDiscState(SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg)
   type(HydroDyn_DiscreteStateType), intent(in) :: SrcDiscStateData
   type(HydroDyn_DiscreteStateType), intent(inout) :: DstDiscStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'HydroDyn_CopyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcDiscStateData%WAMIT)) then
      LB(1:1) = lbound(SrcDiscStateData%WAMIT)
      UB(1:1) = ubound(SrcDiscStateData%WAMIT)
      if (.not. allocated(DstDiscStateData%WAMIT)) then
         allocate(DstDiscStateData%WAMIT(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%WAMIT.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call WAMIT_CopyDiscState(SrcDiscStateData%WAMIT(i1), DstDiscStateData%WAMIT(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call Morison_CopyDiscState(SrcDiscStateData%Morison, DstDiscStateData%Morison, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcDiscStateData%PtfmRefY)) then
      LB(1:1) = lbound(SrcDiscStateData%PtfmRefY)
      UB(1:1) = ubound(SrcDiscStateData%PtfmRefY)
      if (.not. allocated(DstDiscStateData%PtfmRefY)) then
         allocate(DstDiscStateData%PtfmRefY(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%PtfmRefY.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%PtfmRefY = SrcDiscStateData%PtfmRefY
   end if
end subroutine

subroutine HydroDyn_DestroyDiscState(DiscStateData, ErrStat, ErrMsg)
   type(HydroDyn_DiscreteStateType), intent(inout) :: DiscStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'HydroDyn_DestroyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(DiscStateData%WAMIT)) then
      LB(1:1) = lbound(DiscStateData%WAMIT)
      UB(1:1) = ubound(DiscStateData%WAMIT)
      do i1 = LB(1), UB(1)
         call WAMIT_DestroyDiscState(DiscStateData%WAMIT(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(DiscStateData%WAMIT)
   end if
   call Morison_DestroyDiscState(DiscStateData%Morison, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(DiscStateData%PtfmRefY)) then
      deallocate(DiscStateData%PtfmRefY)
   end if
end subroutine

subroutine HydroDyn_PackDiscState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(HydroDyn_DiscreteStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'HydroDyn_PackDiscState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%WAMIT))
   if (allocated(InData%WAMIT)) then
      call RegPackBounds(RF, 1, lbound(InData%WAMIT), ubound(InData%WAMIT))
      LB(1:1) = lbound(InData%WAMIT)
      UB(1:1) = ubound(InData%WAMIT)
      do i1 = LB(1), UB(1)
         call WAMIT_PackDiscState(RF, InData%WAMIT(i1)) 
      end do
   end if
   call Morison_PackDiscState(RF, InData%Morison) 
   call RegPackAlloc(RF, InData%PtfmRefY)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine HydroDyn_UnPackDiscState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(HydroDyn_DiscreteStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'HydroDyn_UnPackDiscState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%WAMIT)) deallocate(OutData%WAMIT)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%WAMIT(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%WAMIT.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call WAMIT_UnpackDiscState(RF, OutData%WAMIT(i1)) ! WAMIT 
      end do
   end if
   call Morison_UnpackDiscState(RF, OutData%Morison) ! Morison 
   call RegUnpackAlloc(RF, OutData%PtfmRefY); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine HydroDyn_CopyConstrState(SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg)
   type(HydroDyn_ConstraintStateType), intent(in) :: SrcConstrStateData
   type(HydroDyn_ConstraintStateType), intent(inout) :: DstConstrStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'HydroDyn_CopyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call WAMIT_CopyConstrState(SrcConstrStateData%WAMIT, DstConstrStateData%WAMIT, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call Morison_CopyConstrState(SrcConstrStateData%Morison, DstConstrStateData%Morison, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine HydroDyn_DestroyConstrState(ConstrStateData, ErrStat, ErrMsg)
   type(HydroDyn_ConstraintStateType), intent(inout) :: ConstrStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'HydroDyn_DestroyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call WAMIT_DestroyConstrState(ConstrStateData%WAMIT, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call Morison_DestroyConstrState(ConstrStateData%Morison, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine HydroDyn_PackConstrState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(HydroDyn_ConstraintStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'HydroDyn_PackConstrState'
   if (RF%ErrStat >= AbortErrLev) return
   call WAMIT_PackConstrState(RF, InData%WAMIT) 
   call Morison_PackConstrState(RF, InData%Morison) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine HydroDyn_UnPackConstrState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(HydroDyn_ConstraintStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'HydroDyn_UnPackConstrState'
   if (RF%ErrStat /= ErrID_None) return
   call WAMIT_UnpackConstrState(RF, OutData%WAMIT) ! WAMIT 
   call Morison_UnpackConstrState(RF, OutData%Morison) ! Morison 
end subroutine

subroutine HydroDyn_CopyOtherState(SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg)
   type(HydroDyn_OtherStateType), intent(in) :: SrcOtherStateData
   type(HydroDyn_OtherStateType), intent(inout) :: DstOtherStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'HydroDyn_CopyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcOtherStateData%WAMIT)) then
      LB(1:1) = lbound(SrcOtherStateData%WAMIT)
      UB(1:1) = ubound(SrcOtherStateData%WAMIT)
      if (.not. allocated(DstOtherStateData%WAMIT)) then
         allocate(DstOtherStateData%WAMIT(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%WAMIT.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call WAMIT_CopyOtherState(SrcOtherStateData%WAMIT(i1), DstOtherStateData%WAMIT(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call Morison_CopyOtherState(SrcOtherStateData%Morison, DstOtherStateData%Morison, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine HydroDyn_DestroyOtherState(OtherStateData, ErrStat, ErrMsg)
   type(HydroDyn_OtherStateType), intent(inout) :: OtherStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'HydroDyn_DestroyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(OtherStateData%WAMIT)) then
      LB(1:1) = lbound(OtherStateData%WAMIT)
      UB(1:1) = ubound(OtherStateData%WAMIT)
      do i1 = LB(1), UB(1)
         call WAMIT_DestroyOtherState(OtherStateData%WAMIT(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(OtherStateData%WAMIT)
   end if
   call Morison_DestroyOtherState(OtherStateData%Morison, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine HydroDyn_PackOtherState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(HydroDyn_OtherStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'HydroDyn_PackOtherState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%WAMIT))
   if (allocated(InData%WAMIT)) then
      call RegPackBounds(RF, 1, lbound(InData%WAMIT), ubound(InData%WAMIT))
      LB(1:1) = lbound(InData%WAMIT)
      UB(1:1) = ubound(InData%WAMIT)
      do i1 = LB(1), UB(1)
         call WAMIT_PackOtherState(RF, InData%WAMIT(i1)) 
      end do
   end if
   call Morison_PackOtherState(RF, InData%Morison) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine HydroDyn_UnPackOtherState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(HydroDyn_OtherStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'HydroDyn_UnPackOtherState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%WAMIT)) deallocate(OutData%WAMIT)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%WAMIT(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%WAMIT.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call WAMIT_UnpackOtherState(RF, OutData%WAMIT(i1)) ! WAMIT 
      end do
   end if
   call Morison_UnpackOtherState(RF, OutData%Morison) ! Morison 
end subroutine

subroutine HydroDyn_CopyMisc(SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg)
   type(HydroDyn_MiscVarType), intent(inout) :: SrcMiscData
   type(HydroDyn_MiscVarType), intent(inout) :: DstMiscData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'HydroDyn_CopyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshCopy(SrcMiscData%AllHdroOrigin, DstMiscData%AllHdroOrigin, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call HydroDyn_CopyHD_ModuleMapType(SrcMiscData%HD_MeshMap, DstMiscData%HD_MeshMap, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstMiscData%Decimate = SrcMiscData%Decimate
   DstMiscData%LastOutTime = SrcMiscData%LastOutTime
   if (allocated(SrcMiscData%F_PtfmAdd)) then
      LB(1:1) = lbound(SrcMiscData%F_PtfmAdd)
      UB(1:1) = ubound(SrcMiscData%F_PtfmAdd)
      if (.not. allocated(DstMiscData%F_PtfmAdd)) then
         allocate(DstMiscData%F_PtfmAdd(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%F_PtfmAdd.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%F_PtfmAdd = SrcMiscData%F_PtfmAdd
   end if
   DstMiscData%F_Hydro = SrcMiscData%F_Hydro
   if (allocated(SrcMiscData%F_Waves)) then
      LB(1:1) = lbound(SrcMiscData%F_Waves)
      UB(1:1) = ubound(SrcMiscData%F_Waves)
      if (.not. allocated(DstMiscData%F_Waves)) then
         allocate(DstMiscData%F_Waves(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%F_Waves.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%F_Waves = SrcMiscData%F_Waves
   end if
   if (allocated(SrcMiscData%WAMIT)) then
      LB(1:1) = lbound(SrcMiscData%WAMIT)
      UB(1:1) = ubound(SrcMiscData%WAMIT)
      if (.not. allocated(DstMiscData%WAMIT)) then
         allocate(DstMiscData%WAMIT(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%WAMIT.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call WAMIT_CopyMisc(SrcMiscData%WAMIT(i1), DstMiscData%WAMIT(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcMiscData%WAMIT2)) then
      LB(1:1) = lbound(SrcMiscData%WAMIT2)
      UB(1:1) = ubound(SrcMiscData%WAMIT2)
      if (.not. allocated(DstMiscData%WAMIT2)) then
         allocate(DstMiscData%WAMIT2(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%WAMIT2.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call WAMIT2_CopyMisc(SrcMiscData%WAMIT2(i1), DstMiscData%WAMIT2(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call Morison_CopyMisc(SrcMiscData%Morison, DstMiscData%Morison, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcMiscData%u_WAMIT)) then
      LB(1:1) = lbound(SrcMiscData%u_WAMIT)
      UB(1:1) = ubound(SrcMiscData%u_WAMIT)
      if (.not. allocated(DstMiscData%u_WAMIT)) then
         allocate(DstMiscData%u_WAMIT(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%u_WAMIT.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call WAMIT_CopyInput(SrcMiscData%u_WAMIT(i1), DstMiscData%u_WAMIT(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
end subroutine

subroutine HydroDyn_DestroyMisc(MiscData, ErrStat, ErrMsg)
   type(HydroDyn_MiscVarType), intent(inout) :: MiscData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'HydroDyn_DestroyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshDestroy( MiscData%AllHdroOrigin, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call HydroDyn_DestroyHD_ModuleMapType(MiscData%HD_MeshMap, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(MiscData%F_PtfmAdd)) then
      deallocate(MiscData%F_PtfmAdd)
   end if
   if (allocated(MiscData%F_Waves)) then
      deallocate(MiscData%F_Waves)
   end if
   if (allocated(MiscData%WAMIT)) then
      LB(1:1) = lbound(MiscData%WAMIT)
      UB(1:1) = ubound(MiscData%WAMIT)
      do i1 = LB(1), UB(1)
         call WAMIT_DestroyMisc(MiscData%WAMIT(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MiscData%WAMIT)
   end if
   if (allocated(MiscData%WAMIT2)) then
      LB(1:1) = lbound(MiscData%WAMIT2)
      UB(1:1) = ubound(MiscData%WAMIT2)
      do i1 = LB(1), UB(1)
         call WAMIT2_DestroyMisc(MiscData%WAMIT2(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MiscData%WAMIT2)
   end if
   call Morison_DestroyMisc(MiscData%Morison, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(MiscData%u_WAMIT)) then
      LB(1:1) = lbound(MiscData%u_WAMIT)
      UB(1:1) = ubound(MiscData%u_WAMIT)
      do i1 = LB(1), UB(1)
         call WAMIT_DestroyInput(MiscData%u_WAMIT(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MiscData%u_WAMIT)
   end if
end subroutine

subroutine HydroDyn_PackMisc(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(HydroDyn_MiscVarType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'HydroDyn_PackMisc'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call MeshPack(RF, InData%AllHdroOrigin) 
   call HydroDyn_PackHD_ModuleMapType(RF, InData%HD_MeshMap) 
   call RegPack(RF, InData%Decimate)
   call RegPack(RF, InData%LastOutTime)
   call RegPackAlloc(RF, InData%F_PtfmAdd)
   call RegPack(RF, InData%F_Hydro)
   call RegPackAlloc(RF, InData%F_Waves)
   call RegPack(RF, allocated(InData%WAMIT))
   if (allocated(InData%WAMIT)) then
      call RegPackBounds(RF, 1, lbound(InData%WAMIT), ubound(InData%WAMIT))
      LB(1:1) = lbound(InData%WAMIT)
      UB(1:1) = ubound(InData%WAMIT)
      do i1 = LB(1), UB(1)
         call WAMIT_PackMisc(RF, InData%WAMIT(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%WAMIT2))
   if (allocated(InData%WAMIT2)) then
      call RegPackBounds(RF, 1, lbound(InData%WAMIT2), ubound(InData%WAMIT2))
      LB(1:1) = lbound(InData%WAMIT2)
      UB(1:1) = ubound(InData%WAMIT2)
      do i1 = LB(1), UB(1)
         call WAMIT2_PackMisc(RF, InData%WAMIT2(i1)) 
      end do
   end if
   call Morison_PackMisc(RF, InData%Morison) 
   call RegPack(RF, allocated(InData%u_WAMIT))
   if (allocated(InData%u_WAMIT)) then
      call RegPackBounds(RF, 1, lbound(InData%u_WAMIT), ubound(InData%u_WAMIT))
      LB(1:1) = lbound(InData%u_WAMIT)
      UB(1:1) = ubound(InData%u_WAMIT)
      do i1 = LB(1), UB(1)
         call WAMIT_PackInput(RF, InData%u_WAMIT(i1)) 
      end do
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine HydroDyn_UnPackMisc(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(HydroDyn_MiscVarType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'HydroDyn_UnPackMisc'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call MeshUnpack(RF, OutData%AllHdroOrigin) ! AllHdroOrigin 
   call HydroDyn_UnpackHD_ModuleMapType(RF, OutData%HD_MeshMap) ! HD_MeshMap 
   call RegUnpack(RF, OutData%Decimate); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LastOutTime); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%F_PtfmAdd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%F_Hydro); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%F_Waves); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%WAMIT)) deallocate(OutData%WAMIT)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%WAMIT(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%WAMIT.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call WAMIT_UnpackMisc(RF, OutData%WAMIT(i1)) ! WAMIT 
      end do
   end if
   if (allocated(OutData%WAMIT2)) deallocate(OutData%WAMIT2)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%WAMIT2(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%WAMIT2.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call WAMIT2_UnpackMisc(RF, OutData%WAMIT2(i1)) ! WAMIT2 
      end do
   end if
   call Morison_UnpackMisc(RF, OutData%Morison) ! Morison 
   if (allocated(OutData%u_WAMIT)) deallocate(OutData%u_WAMIT)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%u_WAMIT(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%u_WAMIT.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call WAMIT_UnpackInput(RF, OutData%u_WAMIT(i1)) ! u_WAMIT 
      end do
   end if
end subroutine

subroutine HydroDyn_CopyParam(SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg)
   type(HydroDyn_ParameterType), intent(in) :: SrcParamData
   type(HydroDyn_ParameterType), intent(inout) :: DstParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'HydroDyn_CopyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstParamData%nWAMITObj = SrcParamData%nWAMITObj
   DstParamData%vecMultiplier = SrcParamData%vecMultiplier
   if (allocated(SrcParamData%WAMIT)) then
      LB(1:1) = lbound(SrcParamData%WAMIT)
      UB(1:1) = ubound(SrcParamData%WAMIT)
      if (.not. allocated(DstParamData%WAMIT)) then
         allocate(DstParamData%WAMIT(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%WAMIT.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call WAMIT_CopyParam(SrcParamData%WAMIT(i1), DstParamData%WAMIT(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcParamData%WAMIT2)) then
      LB(1:1) = lbound(SrcParamData%WAMIT2)
      UB(1:1) = ubound(SrcParamData%WAMIT2)
      if (.not. allocated(DstParamData%WAMIT2)) then
         allocate(DstParamData%WAMIT2(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%WAMIT2.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call WAMIT2_CopyParam(SrcParamData%WAMIT2(i1), DstParamData%WAMIT2(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstParamData%WAMIT2used = SrcParamData%WAMIT2used
   call Morison_CopyParam(SrcParamData%Morison, DstParamData%Morison, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstParamData%PotMod = SrcParamData%PotMod
   DstParamData%NBody = SrcParamData%NBody
   DstParamData%NBodyMod = SrcParamData%NBodyMod
   DstParamData%totalStates = SrcParamData%totalStates
   DstParamData%totalExctnStates = SrcParamData%totalExctnStates
   DstParamData%totalRdtnStates = SrcParamData%totalRdtnStates
   if (allocated(SrcParamData%AddF0)) then
      LB(1:2) = lbound(SrcParamData%AddF0)
      UB(1:2) = ubound(SrcParamData%AddF0)
      if (.not. allocated(DstParamData%AddF0)) then
         allocate(DstParamData%AddF0(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%AddF0.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%AddF0 = SrcParamData%AddF0
   end if
   if (allocated(SrcParamData%AddCLin)) then
      LB(1:3) = lbound(SrcParamData%AddCLin)
      UB(1:3) = ubound(SrcParamData%AddCLin)
      if (.not. allocated(DstParamData%AddCLin)) then
         allocate(DstParamData%AddCLin(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%AddCLin.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%AddCLin = SrcParamData%AddCLin
   end if
   if (allocated(SrcParamData%AddBLin)) then
      LB(1:3) = lbound(SrcParamData%AddBLin)
      UB(1:3) = ubound(SrcParamData%AddBLin)
      if (.not. allocated(DstParamData%AddBLin)) then
         allocate(DstParamData%AddBLin(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%AddBLin.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%AddBLin = SrcParamData%AddBLin
   end if
   if (allocated(SrcParamData%AddBQuad)) then
      LB(1:3) = lbound(SrcParamData%AddBQuad)
      UB(1:3) = ubound(SrcParamData%AddBQuad)
      if (.not. allocated(DstParamData%AddBQuad)) then
         allocate(DstParamData%AddBQuad(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%AddBQuad.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%AddBQuad = SrcParamData%AddBQuad
   end if
   DstParamData%DT = SrcParamData%DT
   if (allocated(SrcParamData%OutParam)) then
      LB(1:1) = lbound(SrcParamData%OutParam)
      UB(1:1) = ubound(SrcParamData%OutParam)
      if (.not. allocated(DstParamData%OutParam)) then
         allocate(DstParamData%OutParam(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%OutParam.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyOutParmType(SrcParamData%OutParam(i1), DstParamData%OutParam(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstParamData%NumOuts = SrcParamData%NumOuts
   DstParamData%NumTotalOuts = SrcParamData%NumTotalOuts
   DstParamData%OutSwtch = SrcParamData%OutSwtch
   DstParamData%OutFmt = SrcParamData%OutFmt
   DstParamData%OutSFmt = SrcParamData%OutSFmt
   DstParamData%Delim = SrcParamData%Delim
   DstParamData%UnOutFile = SrcParamData%UnOutFile
   DstParamData%OutDec = SrcParamData%OutDec
   if (allocated(SrcParamData%Jac_u_indx)) then
      LB(1:2) = lbound(SrcParamData%Jac_u_indx)
      UB(1:2) = ubound(SrcParamData%Jac_u_indx)
      if (.not. allocated(DstParamData%Jac_u_indx)) then
         allocate(DstParamData%Jac_u_indx(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Jac_u_indx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Jac_u_indx = SrcParamData%Jac_u_indx
   end if
   if (allocated(SrcParamData%du)) then
      LB(1:1) = lbound(SrcParamData%du)
      UB(1:1) = ubound(SrcParamData%du)
      if (.not. allocated(DstParamData%du)) then
         allocate(DstParamData%du(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%du.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%du = SrcParamData%du
   end if
   if (allocated(SrcParamData%dx)) then
      LB(1:1) = lbound(SrcParamData%dx)
      UB(1:1) = ubound(SrcParamData%dx)
      if (.not. allocated(DstParamData%dx)) then
         allocate(DstParamData%dx(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%dx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%dx = SrcParamData%dx
   end if
   DstParamData%Jac_ny = SrcParamData%Jac_ny
   DstParamData%VisMeshes = SrcParamData%VisMeshes
   DstParamData%WaveField => SrcParamData%WaveField
   DstParamData%PtfmYMod = SrcParamData%PtfmYMod
   DstParamData%CYawFilt = SrcParamData%CYawFilt
end subroutine

subroutine HydroDyn_DestroyParam(ParamData, ErrStat, ErrMsg)
   type(HydroDyn_ParameterType), intent(inout) :: ParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'HydroDyn_DestroyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ParamData%WAMIT)) then
      LB(1:1) = lbound(ParamData%WAMIT)
      UB(1:1) = ubound(ParamData%WAMIT)
      do i1 = LB(1), UB(1)
         call WAMIT_DestroyParam(ParamData%WAMIT(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%WAMIT)
   end if
   if (allocated(ParamData%WAMIT2)) then
      LB(1:1) = lbound(ParamData%WAMIT2)
      UB(1:1) = ubound(ParamData%WAMIT2)
      do i1 = LB(1), UB(1)
         call WAMIT2_DestroyParam(ParamData%WAMIT2(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%WAMIT2)
   end if
   call Morison_DestroyParam(ParamData%Morison, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(ParamData%AddF0)) then
      deallocate(ParamData%AddF0)
   end if
   if (allocated(ParamData%AddCLin)) then
      deallocate(ParamData%AddCLin)
   end if
   if (allocated(ParamData%AddBLin)) then
      deallocate(ParamData%AddBLin)
   end if
   if (allocated(ParamData%AddBQuad)) then
      deallocate(ParamData%AddBQuad)
   end if
   if (allocated(ParamData%OutParam)) then
      LB(1:1) = lbound(ParamData%OutParam)
      UB(1:1) = ubound(ParamData%OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyOutParmType(ParamData%OutParam(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%OutParam)
   end if
   if (allocated(ParamData%Jac_u_indx)) then
      deallocate(ParamData%Jac_u_indx)
   end if
   if (allocated(ParamData%du)) then
      deallocate(ParamData%du)
   end if
   if (allocated(ParamData%dx)) then
      deallocate(ParamData%dx)
   end if
   nullify(ParamData%WaveField)
end subroutine

subroutine HydroDyn_PackParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(HydroDyn_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'HydroDyn_PackParam'
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)   :: LB(3), UB(3)
   logical         :: PtrInIndex
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%nWAMITObj)
   call RegPack(RF, InData%vecMultiplier)
   call RegPack(RF, allocated(InData%WAMIT))
   if (allocated(InData%WAMIT)) then
      call RegPackBounds(RF, 1, lbound(InData%WAMIT), ubound(InData%WAMIT))
      LB(1:1) = lbound(InData%WAMIT)
      UB(1:1) = ubound(InData%WAMIT)
      do i1 = LB(1), UB(1)
         call WAMIT_PackParam(RF, InData%WAMIT(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%WAMIT2))
   if (allocated(InData%WAMIT2)) then
      call RegPackBounds(RF, 1, lbound(InData%WAMIT2), ubound(InData%WAMIT2))
      LB(1:1) = lbound(InData%WAMIT2)
      UB(1:1) = ubound(InData%WAMIT2)
      do i1 = LB(1), UB(1)
         call WAMIT2_PackParam(RF, InData%WAMIT2(i1)) 
      end do
   end if
   call RegPack(RF, InData%WAMIT2used)
   call Morison_PackParam(RF, InData%Morison) 
   call RegPack(RF, InData%PotMod)
   call RegPack(RF, InData%NBody)
   call RegPack(RF, InData%NBodyMod)
   call RegPack(RF, InData%totalStates)
   call RegPack(RF, InData%totalExctnStates)
   call RegPack(RF, InData%totalRdtnStates)
   call RegPackAlloc(RF, InData%AddF0)
   call RegPackAlloc(RF, InData%AddCLin)
   call RegPackAlloc(RF, InData%AddBLin)
   call RegPackAlloc(RF, InData%AddBQuad)
   call RegPack(RF, InData%DT)
   call RegPack(RF, allocated(InData%OutParam))
   if (allocated(InData%OutParam)) then
      call RegPackBounds(RF, 1, lbound(InData%OutParam), ubound(InData%OutParam))
      LB(1:1) = lbound(InData%OutParam)
      UB(1:1) = ubound(InData%OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackOutParmType(RF, InData%OutParam(i1)) 
      end do
   end if
   call RegPack(RF, InData%NumOuts)
   call RegPack(RF, InData%NumTotalOuts)
   call RegPack(RF, InData%OutSwtch)
   call RegPack(RF, InData%OutFmt)
   call RegPack(RF, InData%OutSFmt)
   call RegPack(RF, InData%Delim)
   call RegPack(RF, InData%UnOutFile)
   call RegPack(RF, InData%OutDec)
   call RegPackAlloc(RF, InData%Jac_u_indx)
   call RegPackAlloc(RF, InData%du)
   call RegPackAlloc(RF, InData%dx)
   call RegPack(RF, InData%Jac_ny)
   call RegPack(RF, InData%VisMeshes)
   call RegPack(RF, associated(InData%WaveField))
   if (associated(InData%WaveField)) then
      call RegPackPointer(RF, c_loc(InData%WaveField), PtrInIndex)
      if (.not. PtrInIndex) then
         call SeaSt_WaveField_PackSeaSt_WaveFieldType(RF, InData%WaveField) 
      end if
   end if
   call RegPack(RF, InData%PtfmYMod)
   call RegPack(RF, InData%CYawFilt)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine HydroDyn_UnPackParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(HydroDyn_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'HydroDyn_UnPackParam'
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   integer(B8Ki)   :: PtrIdx
   type(c_ptr)     :: Ptr
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%nWAMITObj); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%vecMultiplier); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%WAMIT)) deallocate(OutData%WAMIT)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%WAMIT(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%WAMIT.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call WAMIT_UnpackParam(RF, OutData%WAMIT(i1)) ! WAMIT 
      end do
   end if
   if (allocated(OutData%WAMIT2)) deallocate(OutData%WAMIT2)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%WAMIT2(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%WAMIT2.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call WAMIT2_UnpackParam(RF, OutData%WAMIT2(i1)) ! WAMIT2 
      end do
   end if
   call RegUnpack(RF, OutData%WAMIT2used); if (RegCheckErr(RF, RoutineName)) return
   call Morison_UnpackParam(RF, OutData%Morison) ! Morison 
   call RegUnpack(RF, OutData%PotMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NBody); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NBodyMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%totalStates); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%totalExctnStates); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%totalRdtnStates); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AddF0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AddCLin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AddBLin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AddBQuad); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DT); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%OutParam)) deallocate(OutData%OutParam)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%OutParam(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%OutParam.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackOutParmType(RF, OutData%OutParam(i1)) ! OutParam 
      end do
   end if
   call RegUnpack(RF, OutData%NumOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumTotalOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutSwtch); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutFmt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutSFmt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Delim); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UnOutFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutDec); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Jac_u_indx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%du); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%dx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Jac_ny); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VisMeshes); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%WaveField)) deallocate(OutData%WaveField)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackPointer(RF, Ptr, PtrIdx); if (RegCheckErr(RF, RoutineName)) return
      if (c_associated(Ptr)) then
         call c_f_pointer(Ptr, OutData%WaveField)
      else
         allocate(OutData%WaveField,stat=stat)
         if (stat /= 0) then 
            call SetErrStat(ErrID_Fatal, 'Error allocating OutData%WaveField.', RF%ErrStat, RF%ErrMsg, RoutineName)
            return
         end if
         RF%Pointers(PtrIdx) = c_loc(OutData%WaveField)
         call SeaSt_WaveField_UnpackSeaSt_WaveFieldType(RF, OutData%WaveField) ! WaveField 
      end if
   else
      OutData%WaveField => null()
   end if
   call RegUnpack(RF, OutData%PtfmYMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CYawFilt); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine HydroDyn_CopyInput(SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg)
   type(HydroDyn_InputType), intent(inout) :: SrcInputData
   type(HydroDyn_InputType), intent(inout) :: DstInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'HydroDyn_CopyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call Morison_CopyInput(SrcInputData%Morison, DstInputData%Morison, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcInputData%WAMITMesh, DstInputData%WAMITMesh, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcInputData%PRPMesh, DstInputData%PRPMesh, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine HydroDyn_DestroyInput(InputData, ErrStat, ErrMsg)
   type(HydroDyn_InputType), intent(inout) :: InputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'HydroDyn_DestroyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call Morison_DestroyInput(InputData%Morison, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( InputData%WAMITMesh, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( InputData%PRPMesh, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine HydroDyn_PackInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(HydroDyn_InputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'HydroDyn_PackInput'
   if (RF%ErrStat >= AbortErrLev) return
   call Morison_PackInput(RF, InData%Morison) 
   call MeshPack(RF, InData%WAMITMesh) 
   call MeshPack(RF, InData%PRPMesh) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine HydroDyn_UnPackInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(HydroDyn_InputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'HydroDyn_UnPackInput'
   if (RF%ErrStat /= ErrID_None) return
   call Morison_UnpackInput(RF, OutData%Morison) ! Morison 
   call MeshUnpack(RF, OutData%WAMITMesh) ! WAMITMesh 
   call MeshUnpack(RF, OutData%PRPMesh) ! PRPMesh 
end subroutine

subroutine HydroDyn_CopyOutput(SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg)
   type(HydroDyn_OutputType), intent(inout) :: SrcOutputData
   type(HydroDyn_OutputType), intent(inout) :: DstOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'HydroDyn_CopyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcOutputData%WAMIT)) then
      LB(1:1) = lbound(SrcOutputData%WAMIT)
      UB(1:1) = ubound(SrcOutputData%WAMIT)
      if (.not. allocated(DstOutputData%WAMIT)) then
         allocate(DstOutputData%WAMIT(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%WAMIT.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call WAMIT_CopyOutput(SrcOutputData%WAMIT(i1), DstOutputData%WAMIT(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcOutputData%WAMIT2)) then
      LB(1:1) = lbound(SrcOutputData%WAMIT2)
      UB(1:1) = ubound(SrcOutputData%WAMIT2)
      if (.not. allocated(DstOutputData%WAMIT2)) then
         allocate(DstOutputData%WAMIT2(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%WAMIT2.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call WAMIT2_CopyOutput(SrcOutputData%WAMIT2(i1), DstOutputData%WAMIT2(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call Morison_CopyOutput(SrcOutputData%Morison, DstOutputData%Morison, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcOutputData%WAMITMesh, DstOutputData%WAMITMesh, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcOutputData%WriteOutput)) then
      LB(1:1) = lbound(SrcOutputData%WriteOutput)
      UB(1:1) = ubound(SrcOutputData%WriteOutput)
      if (.not. allocated(DstOutputData%WriteOutput)) then
         allocate(DstOutputData%WriteOutput(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%WriteOutput.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%WriteOutput = SrcOutputData%WriteOutput
   end if
end subroutine

subroutine HydroDyn_DestroyOutput(OutputData, ErrStat, ErrMsg)
   type(HydroDyn_OutputType), intent(inout) :: OutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'HydroDyn_DestroyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(OutputData%WAMIT)) then
      LB(1:1) = lbound(OutputData%WAMIT)
      UB(1:1) = ubound(OutputData%WAMIT)
      do i1 = LB(1), UB(1)
         call WAMIT_DestroyOutput(OutputData%WAMIT(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(OutputData%WAMIT)
   end if
   if (allocated(OutputData%WAMIT2)) then
      LB(1:1) = lbound(OutputData%WAMIT2)
      UB(1:1) = ubound(OutputData%WAMIT2)
      do i1 = LB(1), UB(1)
         call WAMIT2_DestroyOutput(OutputData%WAMIT2(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(OutputData%WAMIT2)
   end if
   call Morison_DestroyOutput(OutputData%Morison, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( OutputData%WAMITMesh, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(OutputData%WriteOutput)) then
      deallocate(OutputData%WriteOutput)
   end if
end subroutine

subroutine HydroDyn_PackOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(HydroDyn_OutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'HydroDyn_PackOutput'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%WAMIT))
   if (allocated(InData%WAMIT)) then
      call RegPackBounds(RF, 1, lbound(InData%WAMIT), ubound(InData%WAMIT))
      LB(1:1) = lbound(InData%WAMIT)
      UB(1:1) = ubound(InData%WAMIT)
      do i1 = LB(1), UB(1)
         call WAMIT_PackOutput(RF, InData%WAMIT(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%WAMIT2))
   if (allocated(InData%WAMIT2)) then
      call RegPackBounds(RF, 1, lbound(InData%WAMIT2), ubound(InData%WAMIT2))
      LB(1:1) = lbound(InData%WAMIT2)
      UB(1:1) = ubound(InData%WAMIT2)
      do i1 = LB(1), UB(1)
         call WAMIT2_PackOutput(RF, InData%WAMIT2(i1)) 
      end do
   end if
   call Morison_PackOutput(RF, InData%Morison) 
   call MeshPack(RF, InData%WAMITMesh) 
   call RegPackAlloc(RF, InData%WriteOutput)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine HydroDyn_UnPackOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(HydroDyn_OutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'HydroDyn_UnPackOutput'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%WAMIT)) deallocate(OutData%WAMIT)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%WAMIT(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%WAMIT.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call WAMIT_UnpackOutput(RF, OutData%WAMIT(i1)) ! WAMIT 
      end do
   end if
   if (allocated(OutData%WAMIT2)) deallocate(OutData%WAMIT2)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%WAMIT2(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%WAMIT2.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call WAMIT2_UnpackOutput(RF, OutData%WAMIT2(i1)) ! WAMIT2 
      end do
   end if
   call Morison_UnpackOutput(RF, OutData%Morison) ! Morison 
   call MeshUnpack(RF, OutData%WAMITMesh) ! WAMITMesh 
   call RegUnpackAlloc(RF, OutData%WriteOutput); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine HydroDyn_Input_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
   ! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(HydroDyn_InputType), intent(inout)  :: u(:) ! Input at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Inputs
   type(HydroDyn_InputType), intent(inout)  :: u_out ! Input at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'HydroDyn_Input_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(u)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(u)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(u) - 1
   select case (order)
   case (0)
      call HydroDyn_CopyInput(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call HydroDyn_Input_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call HydroDyn_Input_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(u) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE HydroDyn_Input_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

   TYPE(HydroDyn_InputType), INTENT(INOUT)  :: u1    ! Input at t1 > t2
   TYPE(HydroDyn_InputType), INTENT(INOUT)  :: u2    ! Input at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Inputs
   TYPE(HydroDyn_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'HydroDyn_Input_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   CALL Morison_Input_ExtrapInterp1( u1%Morison, u2%Morison, tin, u_out%Morison, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp1(u1%WAMITMesh, u2%WAMITMesh, tin, u_out%WAMITMesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp1(u1%PRPMesh, u2%PRPMesh, tin, u_out%PRPMesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
END SUBROUTINE

SUBROUTINE HydroDyn_Input_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

   TYPE(HydroDyn_InputType), INTENT(INOUT)  :: u1      ! Input at t1 > t2 > t3
   TYPE(HydroDyn_InputType), INTENT(INOUT)  :: u2      ! Input at t2 > t3
   TYPE(HydroDyn_InputType), INTENT(INOUT)  :: u3      ! Input at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Inputs
   TYPE(HydroDyn_InputType), INTENT(INOUT)  :: u_out     ! Input at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'HydroDyn_Input_ExtrapInterp2'
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   CALL Morison_Input_ExtrapInterp2( u1%Morison, u2%Morison, u3%Morison, tin, u_out%Morison, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp2(u1%WAMITMesh, u2%WAMITMesh, u3%WAMITMesh, tin, u_out%WAMITMesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp2(u1%PRPMesh, u2%PRPMesh, u3%PRPMesh, tin, u_out%PRPMesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
END SUBROUTINE

subroutine HydroDyn_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
   ! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(HydroDyn_OutputType), intent(inout)  :: y(:) ! Output at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Outputs
   type(HydroDyn_OutputType), intent(inout)  :: y_out ! Output at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'HydroDyn_Output_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(y)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(y)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(y) - 1
   select case (order)
   case (0)
      call HydroDyn_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call HydroDyn_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call HydroDyn_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(y) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE HydroDyn_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

   TYPE(HydroDyn_OutputType), INTENT(INOUT)  :: y1    ! Output at t1 > t2
   TYPE(HydroDyn_OutputType), INTENT(INOUT)  :: y2    ! Output at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
   TYPE(HydroDyn_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'HydroDyn_Output_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   IF (ALLOCATED(y_out%WAMIT) .AND. ALLOCATED(y1%WAMIT)) THEN
      do i1 = lbound(y_out%WAMIT,1),ubound(y_out%WAMIT,1)
         CALL WAMIT_Output_ExtrapInterp1( y1%WAMIT(i1), y2%WAMIT(i1), tin, y_out%WAMIT(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(y_out%WAMIT2) .AND. ALLOCATED(y1%WAMIT2)) THEN
      do i1 = lbound(y_out%WAMIT2,1),ubound(y_out%WAMIT2,1)
         CALL WAMIT2_Output_ExtrapInterp1( y1%WAMIT2(i1), y2%WAMIT2(i1), tin, y_out%WAMIT2(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   CALL Morison_Output_ExtrapInterp1( y1%Morison, y2%Morison, tin, y_out%Morison, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp1(y1%WAMITMesh, y2%WAMITMesh, tin, y_out%WAMITMesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
      y_out%WriteOutput = a1*y1%WriteOutput + a2*y2%WriteOutput
   END IF ! check if allocated
END SUBROUTINE

SUBROUTINE HydroDyn_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

   TYPE(HydroDyn_OutputType), INTENT(INOUT)  :: y1      ! Output at t1 > t2 > t3
   TYPE(HydroDyn_OutputType), INTENT(INOUT)  :: y2      ! Output at t2 > t3
   TYPE(HydroDyn_OutputType), INTENT(INOUT)  :: y3      ! Output at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
   TYPE(HydroDyn_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'HydroDyn_Output_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   IF (ALLOCATED(y_out%WAMIT) .AND. ALLOCATED(y1%WAMIT)) THEN
      do i1 = lbound(y_out%WAMIT,1),ubound(y_out%WAMIT,1)
         CALL WAMIT_Output_ExtrapInterp2( y1%WAMIT(i1), y2%WAMIT(i1), y3%WAMIT(i1), tin, y_out%WAMIT(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(y_out%WAMIT2) .AND. ALLOCATED(y1%WAMIT2)) THEN
      do i1 = lbound(y_out%WAMIT2,1),ubound(y_out%WAMIT2,1)
         CALL WAMIT2_Output_ExtrapInterp2( y1%WAMIT2(i1), y2%WAMIT2(i1), y3%WAMIT2(i1), tin, y_out%WAMIT2(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   CALL Morison_Output_ExtrapInterp2( y1%Morison, y2%Morison, y3%Morison, tin, y_out%Morison, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp2(y1%WAMITMesh, y2%WAMITMesh, y3%WAMITMesh, tin, y_out%WAMITMesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
      y_out%WriteOutput = a1*y1%WriteOutput + a2*y2%WriteOutput + a3*y3%WriteOutput
   END IF ! check if allocated
END SUBROUTINE
END MODULE HydroDyn_Types
!ENDOFREGISTRYGENERATEDFILE
