!STARTOFREGISTRYGENERATEDFILE 'Conv_Radiation_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! Conv_Radiation_Types
!.................................................................................................................................
! This file is part of Conv_Radiation.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in Conv_Radiation. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE Conv_Radiation_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE NWTC_Library
IMPLICIT NONE
! =========  Conv_Rdtn_InitInputType  =======
  TYPE, PUBLIC :: Conv_Rdtn_InitInputType
    REAL(DbKi)  :: RdtnDT = 0.0_R8Ki      !<  [-]
    CHARACTER(80)  :: RdtnDTChr 
    INTEGER(IntKi)  :: NBody = 0_IntKi      !< [>=1; only used when PotMod=1. If NBodyMod=1, the WAMIT data contains a vector of size 6*NBody x 1 and matrices of size 6*NBody x 6*NBody; if NBodyMod>1, there are NBody sets of WAMIT data each with a vector of size 6 x 1 and matrices of size 6 x 6] [-]
    REAL(ReKi)  :: HighFreq = 0.0_ReKi      !<  [-]
    CHARACTER(1024)  :: WAMITFile      !<  [-]
    REAL(SiKi) , DIMENSION(:,:,:), ALLOCATABLE  :: HdroAddMs      !<  [-]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: HdroFreq      !<  [-]
    REAL(SiKi) , DIMENSION(:,:,:), ALLOCATABLE  :: HdroDmpng      !<  [-]
    INTEGER(IntKi)  :: NInpFreq = 0_IntKi      !<  [-]
    REAL(DbKi)  :: RdtnTMax = 0.0_R8Ki      !<  [-]
  END TYPE Conv_Rdtn_InitInputType
! =======================
! =========  Conv_Rdtn_InitOutputType  =======
  TYPE, PUBLIC :: Conv_Rdtn_InitOutputType
    INTEGER(IntKi)  :: DummyInitOut = 0_IntKi      !<  [-]
  END TYPE Conv_Rdtn_InitOutputType
! =======================
! =========  Conv_Rdtn_ContinuousStateType  =======
  TYPE, PUBLIC :: Conv_Rdtn_ContinuousStateType
    REAL(SiKi)  :: DummyContState = 0.0_R4Ki      !< Remove this variable if you have continuous states [-]
  END TYPE Conv_Rdtn_ContinuousStateType
! =======================
! =========  Conv_Rdtn_DiscreteStateType  =======
  TYPE, PUBLIC :: Conv_Rdtn_DiscreteStateType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: XDHistory      !<  [-]
    REAL(DbKi)  :: LastTime = 0.0_R8Ki      !<  [-]
  END TYPE Conv_Rdtn_DiscreteStateType
! =======================
! =========  Conv_Rdtn_ConstraintStateType  =======
  TYPE, PUBLIC :: Conv_Rdtn_ConstraintStateType
    REAL(SiKi)  :: DummyConstrState = 0.0_R4Ki      !< Remove this variable if you have constraint states [-]
  END TYPE Conv_Rdtn_ConstraintStateType
! =======================
! =========  Conv_Rdtn_OtherStateType  =======
  TYPE, PUBLIC :: Conv_Rdtn_OtherStateType
    INTEGER(IntKi)  :: IndRdtn = 0_IntKi      !<  [-]
  END TYPE Conv_Rdtn_OtherStateType
! =======================
! =========  Conv_Rdtn_MiscVarType  =======
  TYPE, PUBLIC :: Conv_Rdtn_MiscVarType
    INTEGER(IntKi)  :: LastIndRdtn = 0_IntKi      !<  [-]
  END TYPE Conv_Rdtn_MiscVarType
! =======================
! =========  Conv_Rdtn_ParameterType  =======
  TYPE, PUBLIC :: Conv_Rdtn_ParameterType
    REAL(DbKi)  :: DT = 0.0_R8Ki      !< Time step for continuous state integration & discrete state update [seconds]
    REAL(DbKi)  :: RdtnDT = 0.0_R8Ki      !<  [-]
    INTEGER(IntKi)  :: NBody = 0_IntKi      !< [>=1; only used when PotMod=1. If NBodyMod=1, the WAMIT data contains a vector of size 6*NBody x 1 and matrices of size 6*NBody x 6*NBody; if NBodyMod>1, there are NBody sets of WAMIT data each with a vector of size 6 x 1 and matrices of size 6 x 6] [-]
    REAL(SiKi) , DIMENSION(:,:,:), ALLOCATABLE  :: RdtnKrnl      !<  [-]
    INTEGER(IntKi)  :: NStepRdtn = 0_IntKi      !<  [-]
    INTEGER(IntKi)  :: NStepRdtn1 = 0_IntKi      !<  [-]
  END TYPE Conv_Rdtn_ParameterType
! =======================
! =========  Conv_Rdtn_InputType  =======
  TYPE, PUBLIC :: Conv_Rdtn_InputType
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Velocity      !<  [-]
  END TYPE Conv_Rdtn_InputType
! =======================
! =========  Conv_Rdtn_OutputType  =======
  TYPE, PUBLIC :: Conv_Rdtn_OutputType
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: F_Rdtn      !<  [-]
  END TYPE Conv_Rdtn_OutputType
! =======================
CONTAINS

subroutine Conv_Rdtn_CopyInitInput(SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg)
   type(Conv_Rdtn_InitInputType), intent(in) :: SrcInitInputData
   type(Conv_Rdtn_InitInputType), intent(inout) :: DstInitInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'Conv_Rdtn_CopyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInitInputData%RdtnDT = SrcInitInputData%RdtnDT
   DstInitInputData%RdtnDTChr = SrcInitInputData%RdtnDTChr
   DstInitInputData%NBody = SrcInitInputData%NBody
   DstInitInputData%HighFreq = SrcInitInputData%HighFreq
   DstInitInputData%WAMITFile = SrcInitInputData%WAMITFile
   if (allocated(SrcInitInputData%HdroAddMs)) then
      LB(1:3) = lbound(SrcInitInputData%HdroAddMs)
      UB(1:3) = ubound(SrcInitInputData%HdroAddMs)
      if (.not. allocated(DstInitInputData%HdroAddMs)) then
         allocate(DstInitInputData%HdroAddMs(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%HdroAddMs.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%HdroAddMs = SrcInitInputData%HdroAddMs
   end if
   if (allocated(SrcInitInputData%HdroFreq)) then
      LB(1:1) = lbound(SrcInitInputData%HdroFreq)
      UB(1:1) = ubound(SrcInitInputData%HdroFreq)
      if (.not. allocated(DstInitInputData%HdroFreq)) then
         allocate(DstInitInputData%HdroFreq(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%HdroFreq.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%HdroFreq = SrcInitInputData%HdroFreq
   end if
   if (allocated(SrcInitInputData%HdroDmpng)) then
      LB(1:3) = lbound(SrcInitInputData%HdroDmpng)
      UB(1:3) = ubound(SrcInitInputData%HdroDmpng)
      if (.not. allocated(DstInitInputData%HdroDmpng)) then
         allocate(DstInitInputData%HdroDmpng(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%HdroDmpng.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%HdroDmpng = SrcInitInputData%HdroDmpng
   end if
   DstInitInputData%NInpFreq = SrcInitInputData%NInpFreq
   DstInitInputData%RdtnTMax = SrcInitInputData%RdtnTMax
end subroutine

subroutine Conv_Rdtn_DestroyInitInput(InitInputData, ErrStat, ErrMsg)
   type(Conv_Rdtn_InitInputType), intent(inout) :: InitInputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Conv_Rdtn_DestroyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InitInputData%HdroAddMs)) then
      deallocate(InitInputData%HdroAddMs)
   end if
   if (allocated(InitInputData%HdroFreq)) then
      deallocate(InitInputData%HdroFreq)
   end if
   if (allocated(InitInputData%HdroDmpng)) then
      deallocate(InitInputData%HdroDmpng)
   end if
end subroutine

subroutine Conv_Rdtn_PackInitInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Conv_Rdtn_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Conv_Rdtn_PackInitInput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%RdtnDT)
   call RegPack(RF, InData%RdtnDTChr)
   call RegPack(RF, InData%NBody)
   call RegPack(RF, InData%HighFreq)
   call RegPack(RF, InData%WAMITFile)
   call RegPackAlloc(RF, InData%HdroAddMs)
   call RegPackAlloc(RF, InData%HdroFreq)
   call RegPackAlloc(RF, InData%HdroDmpng)
   call RegPack(RF, InData%NInpFreq)
   call RegPack(RF, InData%RdtnTMax)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Conv_Rdtn_UnPackInitInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Conv_Rdtn_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Conv_Rdtn_UnPackInitInput'
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%RdtnDT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RdtnDTChr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NBody); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HighFreq); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WAMITFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%HdroAddMs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%HdroFreq); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%HdroDmpng); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NInpFreq); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RdtnTMax); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Conv_Rdtn_CopyInitOutput(SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg)
   type(Conv_Rdtn_InitOutputType), intent(in) :: SrcInitOutputData
   type(Conv_Rdtn_InitOutputType), intent(inout) :: DstInitOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Conv_Rdtn_CopyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInitOutputData%DummyInitOut = SrcInitOutputData%DummyInitOut
end subroutine

subroutine Conv_Rdtn_DestroyInitOutput(InitOutputData, ErrStat, ErrMsg)
   type(Conv_Rdtn_InitOutputType), intent(inout) :: InitOutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Conv_Rdtn_DestroyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine Conv_Rdtn_PackInitOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Conv_Rdtn_InitOutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Conv_Rdtn_PackInitOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyInitOut)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Conv_Rdtn_UnPackInitOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Conv_Rdtn_InitOutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Conv_Rdtn_UnPackInitOutput'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyInitOut); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Conv_Rdtn_CopyContState(SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg)
   type(Conv_Rdtn_ContinuousStateType), intent(in) :: SrcContStateData
   type(Conv_Rdtn_ContinuousStateType), intent(inout) :: DstContStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Conv_Rdtn_CopyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstContStateData%DummyContState = SrcContStateData%DummyContState
end subroutine

subroutine Conv_Rdtn_DestroyContState(ContStateData, ErrStat, ErrMsg)
   type(Conv_Rdtn_ContinuousStateType), intent(inout) :: ContStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Conv_Rdtn_DestroyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine Conv_Rdtn_PackContState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Conv_Rdtn_ContinuousStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Conv_Rdtn_PackContState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyContState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Conv_Rdtn_UnPackContState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Conv_Rdtn_ContinuousStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Conv_Rdtn_UnPackContState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyContState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Conv_Rdtn_CopyDiscState(SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg)
   type(Conv_Rdtn_DiscreteStateType), intent(in) :: SrcDiscStateData
   type(Conv_Rdtn_DiscreteStateType), intent(inout) :: DstDiscStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'Conv_Rdtn_CopyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcDiscStateData%XDHistory)) then
      LB(1:2) = lbound(SrcDiscStateData%XDHistory)
      UB(1:2) = ubound(SrcDiscStateData%XDHistory)
      if (.not. allocated(DstDiscStateData%XDHistory)) then
         allocate(DstDiscStateData%XDHistory(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%XDHistory.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%XDHistory = SrcDiscStateData%XDHistory
   end if
   DstDiscStateData%LastTime = SrcDiscStateData%LastTime
end subroutine

subroutine Conv_Rdtn_DestroyDiscState(DiscStateData, ErrStat, ErrMsg)
   type(Conv_Rdtn_DiscreteStateType), intent(inout) :: DiscStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Conv_Rdtn_DestroyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(DiscStateData%XDHistory)) then
      deallocate(DiscStateData%XDHistory)
   end if
end subroutine

subroutine Conv_Rdtn_PackDiscState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Conv_Rdtn_DiscreteStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Conv_Rdtn_PackDiscState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%XDHistory)
   call RegPack(RF, InData%LastTime)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Conv_Rdtn_UnPackDiscState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Conv_Rdtn_DiscreteStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Conv_Rdtn_UnPackDiscState'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%XDHistory); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LastTime); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Conv_Rdtn_CopyConstrState(SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg)
   type(Conv_Rdtn_ConstraintStateType), intent(in) :: SrcConstrStateData
   type(Conv_Rdtn_ConstraintStateType), intent(inout) :: DstConstrStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Conv_Rdtn_CopyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstConstrStateData%DummyConstrState = SrcConstrStateData%DummyConstrState
end subroutine

subroutine Conv_Rdtn_DestroyConstrState(ConstrStateData, ErrStat, ErrMsg)
   type(Conv_Rdtn_ConstraintStateType), intent(inout) :: ConstrStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Conv_Rdtn_DestroyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine Conv_Rdtn_PackConstrState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Conv_Rdtn_ConstraintStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Conv_Rdtn_PackConstrState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyConstrState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Conv_Rdtn_UnPackConstrState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Conv_Rdtn_ConstraintStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Conv_Rdtn_UnPackConstrState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyConstrState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Conv_Rdtn_CopyOtherState(SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg)
   type(Conv_Rdtn_OtherStateType), intent(in) :: SrcOtherStateData
   type(Conv_Rdtn_OtherStateType), intent(inout) :: DstOtherStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Conv_Rdtn_CopyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstOtherStateData%IndRdtn = SrcOtherStateData%IndRdtn
end subroutine

subroutine Conv_Rdtn_DestroyOtherState(OtherStateData, ErrStat, ErrMsg)
   type(Conv_Rdtn_OtherStateType), intent(inout) :: OtherStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Conv_Rdtn_DestroyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine Conv_Rdtn_PackOtherState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Conv_Rdtn_OtherStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Conv_Rdtn_PackOtherState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%IndRdtn)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Conv_Rdtn_UnPackOtherState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Conv_Rdtn_OtherStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Conv_Rdtn_UnPackOtherState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%IndRdtn); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Conv_Rdtn_CopyMisc(SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg)
   type(Conv_Rdtn_MiscVarType), intent(in) :: SrcMiscData
   type(Conv_Rdtn_MiscVarType), intent(inout) :: DstMiscData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Conv_Rdtn_CopyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstMiscData%LastIndRdtn = SrcMiscData%LastIndRdtn
end subroutine

subroutine Conv_Rdtn_DestroyMisc(MiscData, ErrStat, ErrMsg)
   type(Conv_Rdtn_MiscVarType), intent(inout) :: MiscData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Conv_Rdtn_DestroyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine Conv_Rdtn_PackMisc(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Conv_Rdtn_MiscVarType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Conv_Rdtn_PackMisc'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%LastIndRdtn)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Conv_Rdtn_UnPackMisc(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Conv_Rdtn_MiscVarType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Conv_Rdtn_UnPackMisc'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%LastIndRdtn); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Conv_Rdtn_CopyParam(SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg)
   type(Conv_Rdtn_ParameterType), intent(in) :: SrcParamData
   type(Conv_Rdtn_ParameterType), intent(inout) :: DstParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'Conv_Rdtn_CopyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstParamData%DT = SrcParamData%DT
   DstParamData%RdtnDT = SrcParamData%RdtnDT
   DstParamData%NBody = SrcParamData%NBody
   if (allocated(SrcParamData%RdtnKrnl)) then
      LB(1:3) = lbound(SrcParamData%RdtnKrnl)
      UB(1:3) = ubound(SrcParamData%RdtnKrnl)
      if (.not. allocated(DstParamData%RdtnKrnl)) then
         allocate(DstParamData%RdtnKrnl(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%RdtnKrnl.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%RdtnKrnl = SrcParamData%RdtnKrnl
   end if
   DstParamData%NStepRdtn = SrcParamData%NStepRdtn
   DstParamData%NStepRdtn1 = SrcParamData%NStepRdtn1
end subroutine

subroutine Conv_Rdtn_DestroyParam(ParamData, ErrStat, ErrMsg)
   type(Conv_Rdtn_ParameterType), intent(inout) :: ParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Conv_Rdtn_DestroyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ParamData%RdtnKrnl)) then
      deallocate(ParamData%RdtnKrnl)
   end if
end subroutine

subroutine Conv_Rdtn_PackParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Conv_Rdtn_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Conv_Rdtn_PackParam'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DT)
   call RegPack(RF, InData%RdtnDT)
   call RegPack(RF, InData%NBody)
   call RegPackAlloc(RF, InData%RdtnKrnl)
   call RegPack(RF, InData%NStepRdtn)
   call RegPack(RF, InData%NStepRdtn1)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Conv_Rdtn_UnPackParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Conv_Rdtn_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Conv_Rdtn_UnPackParam'
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RdtnDT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NBody); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RdtnKrnl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NStepRdtn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NStepRdtn1); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Conv_Rdtn_CopyInput(SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg)
   type(Conv_Rdtn_InputType), intent(in) :: SrcInputData
   type(Conv_Rdtn_InputType), intent(inout) :: DstInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'Conv_Rdtn_CopyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcInputData%Velocity)) then
      LB(1:1) = lbound(SrcInputData%Velocity)
      UB(1:1) = ubound(SrcInputData%Velocity)
      if (.not. allocated(DstInputData%Velocity)) then
         allocate(DstInputData%Velocity(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%Velocity.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%Velocity = SrcInputData%Velocity
   end if
end subroutine

subroutine Conv_Rdtn_DestroyInput(InputData, ErrStat, ErrMsg)
   type(Conv_Rdtn_InputType), intent(inout) :: InputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Conv_Rdtn_DestroyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InputData%Velocity)) then
      deallocate(InputData%Velocity)
   end if
end subroutine

subroutine Conv_Rdtn_PackInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Conv_Rdtn_InputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Conv_Rdtn_PackInput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%Velocity)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Conv_Rdtn_UnPackInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Conv_Rdtn_InputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Conv_Rdtn_UnPackInput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%Velocity); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Conv_Rdtn_CopyOutput(SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg)
   type(Conv_Rdtn_OutputType), intent(in) :: SrcOutputData
   type(Conv_Rdtn_OutputType), intent(inout) :: DstOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'Conv_Rdtn_CopyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcOutputData%F_Rdtn)) then
      LB(1:1) = lbound(SrcOutputData%F_Rdtn)
      UB(1:1) = ubound(SrcOutputData%F_Rdtn)
      if (.not. allocated(DstOutputData%F_Rdtn)) then
         allocate(DstOutputData%F_Rdtn(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%F_Rdtn.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%F_Rdtn = SrcOutputData%F_Rdtn
   end if
end subroutine

subroutine Conv_Rdtn_DestroyOutput(OutputData, ErrStat, ErrMsg)
   type(Conv_Rdtn_OutputType), intent(inout) :: OutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'Conv_Rdtn_DestroyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(OutputData%F_Rdtn)) then
      deallocate(OutputData%F_Rdtn)
   end if
end subroutine

subroutine Conv_Rdtn_PackOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Conv_Rdtn_OutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Conv_Rdtn_PackOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%F_Rdtn)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Conv_Rdtn_UnPackOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Conv_Rdtn_OutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Conv_Rdtn_UnPackOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%F_Rdtn); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Conv_Rdtn_Input_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
   ! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(Conv_Rdtn_InputType), intent(in)  :: u(:) ! Input at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Inputs
   type(Conv_Rdtn_InputType), intent(inout)  :: u_out ! Input at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'Conv_Rdtn_Input_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(u)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(u)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(u) - 1
   select case (order)
   case (0)
      call Conv_Rdtn_CopyInput(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call Conv_Rdtn_Input_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call Conv_Rdtn_Input_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(u) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE Conv_Rdtn_Input_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

   TYPE(Conv_Rdtn_InputType), INTENT(IN)  :: u1    ! Input at t1 > t2
   TYPE(Conv_Rdtn_InputType), INTENT(IN)  :: u2    ! Input at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Inputs
   TYPE(Conv_Rdtn_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'Conv_Rdtn_Input_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   IF (ALLOCATED(u_out%Velocity) .AND. ALLOCATED(u1%Velocity)) THEN
      u_out%Velocity = a1*u1%Velocity + a2*u2%Velocity
   END IF ! check if allocated
END SUBROUTINE

SUBROUTINE Conv_Rdtn_Input_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

   TYPE(Conv_Rdtn_InputType), INTENT(IN)  :: u1      ! Input at t1 > t2 > t3
   TYPE(Conv_Rdtn_InputType), INTENT(IN)  :: u2      ! Input at t2 > t3
   TYPE(Conv_Rdtn_InputType), INTENT(IN)  :: u3      ! Input at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Inputs
   TYPE(Conv_Rdtn_InputType), INTENT(INOUT)  :: u_out     ! Input at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'Conv_Rdtn_Input_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   IF (ALLOCATED(u_out%Velocity) .AND. ALLOCATED(u1%Velocity)) THEN
      u_out%Velocity = a1*u1%Velocity + a2*u2%Velocity + a3*u3%Velocity
   END IF ! check if allocated
END SUBROUTINE

subroutine Conv_Rdtn_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
   ! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(Conv_Rdtn_OutputType), intent(in)  :: y(:) ! Output at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Outputs
   type(Conv_Rdtn_OutputType), intent(inout)  :: y_out ! Output at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'Conv_Rdtn_Output_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(y)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(y)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(y) - 1
   select case (order)
   case (0)
      call Conv_Rdtn_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call Conv_Rdtn_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call Conv_Rdtn_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(y) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE Conv_Rdtn_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

   TYPE(Conv_Rdtn_OutputType), INTENT(IN)  :: y1    ! Output at t1 > t2
   TYPE(Conv_Rdtn_OutputType), INTENT(IN)  :: y2    ! Output at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
   TYPE(Conv_Rdtn_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'Conv_Rdtn_Output_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   IF (ALLOCATED(y_out%F_Rdtn) .AND. ALLOCATED(y1%F_Rdtn)) THEN
      y_out%F_Rdtn = a1*y1%F_Rdtn + a2*y2%F_Rdtn
   END IF ! check if allocated
END SUBROUTINE

SUBROUTINE Conv_Rdtn_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

   TYPE(Conv_Rdtn_OutputType), INTENT(IN)  :: y1      ! Output at t1 > t2 > t3
   TYPE(Conv_Rdtn_OutputType), INTENT(IN)  :: y2      ! Output at t2 > t3
   TYPE(Conv_Rdtn_OutputType), INTENT(IN)  :: y3      ! Output at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
   TYPE(Conv_Rdtn_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'Conv_Rdtn_Output_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   IF (ALLOCATED(y_out%F_Rdtn) .AND. ALLOCATED(y1%F_Rdtn)) THEN
      y_out%F_Rdtn = a1*y1%F_Rdtn + a2*y2%F_Rdtn + a3*y3%F_Rdtn
   END IF ! check if allocated
END SUBROUTINE
END MODULE Conv_Radiation_Types
!ENDOFREGISTRYGENERATEDFILE
