!STARTOFREGISTRYGENERATEDFILE 'FEAMooring_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! FEAMooring_Types
!.................................................................................................................................
! This file is part of FEAMooring.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in FEAMooring. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE FEAMooring_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE NWTC_Library
IMPLICIT NONE
! =========  FEAM_InputFile  =======
  TYPE, PUBLIC :: FEAM_InputFile
    REAL(DbKi)  :: DT = 0.0_R8Ki      !< Communication interval for mooring dynamics [s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LineCI      !< Mooring line inertia coefficient [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LineCD      !< Mooring line drag coefficient [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LEAStiff      !< Mooring line axial stiffness [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LMassDen      !< Mooring line mass per unit length [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LDMassDen      !< Mooring line displaced mass per unit length [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BottmStiff      !< Seabed spring stiffness [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LRadAnch      !< Anchor Radius [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LAngAnch      !< Anchor Angle [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LDpthAnch      !< Anchor Depth [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LRadFair      !< Fairlead Radius [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LAngFair      !< Fairlead Radius [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LDrftFair      !< Fairlead Draft [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LUnstrLen      !< Line unstretched length [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Tension      !< Line Top Tension [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: GSL      !< Linear spring stiffness at fairlead [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: GSR      !< Rotational spring stiffness at fairlead [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: GE      !< Reference tangent vector at fairlead [-]
    INTEGER(IntKi)  :: NumLines = 0_IntKi      !< Number of lines [-]
    INTEGER(IntKi)  :: NumElems = 0_IntKi      !< Number of elements [-]
    REAL(ReKi)  :: Eps = 0.0_ReKi      !< Tolerance for static iteration [-]
    REAL(ReKi)  :: Gravity = 0.0_ReKi      !< Gravity [-]
    REAL(ReKi)  :: WtrDens = 0.0_ReKi      !< Water density [-]
    INTEGER(IntKi)  :: MaxIter = 0_IntKi      !< Maximum number of iteration step for static analysis [-]
    LOGICAL  :: SumPrint = .false.      !< Print summary data to <RootName>.fsm? [-]
    INTEGER(IntKi)  :: OutFile = 0_IntKi      !< Switch to determine where output will be placed: (1: in module output file only; 2: in glue code output file only; 3: both) [-]
    LOGICAL  :: TabDelim = .false.      !< Use tab delimiters in text tabular output file? [-]
    CHARACTER(20)  :: OutFmt      !< Format used for text tabular output (except time) [-]
    REAL(DbKi)  :: Tstart = 0.0_R8Ki      !< Time to start module's tabular output [s]
    INTEGER(IntKi)  :: NumOuts = 0_IntKi      !< Number of parameters in the output list (number of outputs requested) [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: OutList      !< List of user-requested output channels [-]
  END TYPE FEAM_InputFile
! =======================
! =========  FEAM_InitInputType  =======
  TYPE, PUBLIC :: FEAM_InitInputType
    CHARACTER(1024)  :: InputFile      !< Name of the input file [-]
    CHARACTER(1024)  :: RootName      !< RootName for writing output files [-]
    REAL(ReKi) , DIMENSION(1:6)  :: PtfmInit = 0.0_ReKi      !< Platform Initial Position [-]
    INTEGER(IntKi)  :: NStepWave = 0_IntKi      !<  [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: WaveAcc0      !<  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WaveTime      !<  [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: WaveVel0      !<  [-]
    REAL(ReKi)  :: Gravity = 0.0_ReKi      !< Gravity [-]
    REAL(ReKi)  :: WtrDens = 0.0_ReKi      !< Water density [-]
  END TYPE FEAM_InitInputType
! =======================
! =========  FEAM_InitOutputType  =======
  TYPE, PUBLIC :: FEAM_InitOutputType
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputHdr      !< Names of the output-to-file channels [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputUnt      !< Units of the output-to-file channels [-]
    TYPE(ProgDesc)  :: Ver      !< This module's name, version, and date [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LAnchxi      !< Anchor coordinate [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LAnchyi      !< Anchor coordinate [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LAnchzi      !< Anchor coordinate [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LFairxt      !< Fairlead coordinate [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LFairyt      !< Fairlead coordinate [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LFairzt      !< Fairlead coordinate [-]
  END TYPE FEAM_InitOutputType
! =======================
! =========  FEAM_ContinuousStateType  =======
  TYPE, PUBLIC :: FEAM_ContinuousStateType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: GLU      !< Global matrix U (displacement) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: GLDU      !< Global matrix DU (velocity) [-]
  END TYPE FEAM_ContinuousStateType
! =======================
! =========  FEAM_DiscreteStateType  =======
  TYPE, PUBLIC :: FEAM_DiscreteStateType
    REAL(ReKi)  :: DummyDiscState = 0.0_ReKi      !< Remove this variable if you have discrete states [-]
  END TYPE FEAM_DiscreteStateType
! =======================
! =========  FEAM_ConstraintStateType  =======
  TYPE, PUBLIC :: FEAM_ConstraintStateType
    REAL(ReKi) , DIMENSION(1:3)  :: TSN = 0.0_ReKi      !< Lagrangian multiplier [-]
    REAL(ReKi) , DIMENSION(1:3)  :: TZER = 0.0_ReKi      !< Lagrangian multiplier [-]
  END TYPE FEAM_ConstraintStateType
! =======================
! =========  FEAM_OtherStateType  =======
  TYPE, PUBLIC :: FEAM_OtherStateType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: GLU0      !< Global matrix U0 (previous state) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: GLDDU      !< Global matrix DDU (accleration) -- other state [-]
    LOGICAL  :: BottomTouch = .false.      !< Bottom touch flag [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: GFORC0      !< Old element force matrix [-]
    REAL(ReKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: GMASS0      !< Old element mass matrix [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: FAST_FPA      !< Fairlead position - inputs from previous time step (we should replace this with a call to extrap-interp) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: FAST_RP      !< Fairlead tangent - part of output computation that was calculated in UpdateStates [-]
    INTEGER(IntKi)  :: INCR = 0_IntKi      !< FEAM step [-]
    REAL(ReKi) , DIMENSION(1:15)  :: RSDF = 0.0_ReKi      !< Line residue force - modifies values from previous call to FEAM_Solve [-]
    REAL(ReKi) , DIMENSION(1:15)  :: FORC0 = 0.0_ReKi      !< - [Local old element force matrix]
    REAL(ReKi) , DIMENSION(1:15,1:15)  :: EMAS0 = 0.0_ReKi      !< Local old element mass matrix [-]
  END TYPE FEAM_OtherStateType
! =======================
! =========  FEAM_MiscVarType  =======
  TYPE, PUBLIC :: FEAM_MiscVarType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: GLF      !< Global forcing matrix [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: GLK      !< Global stiffness matrix [-]
    REAL(ReKi) , DIMENSION(1:15,1:15)  :: EMASS = 0.0_ReKi      !< Line element mass [-]
    REAL(ReKi) , DIMENSION(1:15,1:15)  :: ESTIF = 0.0_ReKi      !< Line element stiffness [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: FAST_FP      !< Fairlead position at t+dt [-]
    REAL(ReKi) , DIMENSION(1:15)  :: FORCE = 0.0_ReKi      !< Line external force [-]
    REAL(ReKi) , DIMENSION(1:3)  :: FP = 0.0_ReKi      !< Fairlead position - used in Couple routine [-]
    REAL(ReKi) , DIMENSION(1:3,1:4)  :: U = 0.0_ReKi      !< Local matrix U [-]
    REAL(ReKi) , DIMENSION(1:3,1:4)  :: U0 = 0.0_ReKi      !< Local matrix U0 [-]
    REAL(ReKi) , DIMENSION(1:3,1:4)  :: DU = 0.0_ReKi      !< Local matrix DU [-]
    REAL(ReKi) , DIMENSION(1:3,1:4)  :: DDU = 0.0_ReKi      !< Local matrix DDU [-]
    REAL(ReKi) , DIMENSION(1:3)  :: R = 0.0_ReKi      !< POSITION VECTOR OF NODE OF ROD ELEMENT [-]
    REAL(ReKi) , DIMENSION(1:3)  :: RP = 0.0_ReKi      !< DR/DS AT R (TANGENT - NEED NOT BE UNIT VECTOR) [-]
    REAL(ReKi) , DIMENSION(1:6)  :: RHSR = 0.0_ReKi      !< RIGHT HAND SIDE CONTRIBUTION TO 6 DEGREES OF FREEDOM OF ROD NODE [-]
    REAL(ReKi) , DIMENSION(1:3)  :: SLIN = 0.0_ReKi      !< LINEAR SPRING CONSTANT - portion of p%GSL [(UNITS OF FORCE/LENGTH)]
    REAL(ReKi) , DIMENSION(1:6,1:6)  :: STIFR = 0.0_ReKi      !< STIFFNESS COEFFICIENTS FOR 6 DEGREES OF FREEDOM OF ROD NODE (X,DX/DS,Y,DY/DS,Z,DZ/DS) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: FAIR_ANG      !< Fairlead angle [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: FAIR_T      !< Fairlead tension [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: ANCH_ANG      !< Anchor angle [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: ANCH_T      !< Anchor tension [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Line_Coordinate      !< Mooring line coordinate [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Line_Tangent      !< Mooring line tangent vector [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_Lines      !< Mooring restoring force [-]
    INTEGER(IntKi)  :: LastIndWave = 0_IntKi      !< FEAM step [-]
  END TYPE FEAM_MiscVarType
! =======================
! =========  FEAM_ParameterType  =======
  TYPE, PUBLIC :: FEAM_ParameterType
    REAL(DbKi)  :: DT = 0.0_R8Ki      !< Time step for continuous state integration & discrete state update [seconds]
    REAL(ReKi) , DIMENSION(1:3)  :: GRAV = 0.0_ReKi      !< Gravity [-]
    REAL(ReKi)  :: Eps = 0.0_ReKi      !< Tolerance for static iteration [-]
    REAL(ReKi)  :: Gravity = 0.0_ReKi      !< Gravity [-]
    REAL(ReKi)  :: WtrDens = 0.0_ReKi      !< Water density [-]
    INTEGER(IntKi)  :: MaxIter = 0_IntKi      !< Maximum number of iteration step for static analysis [-]
    INTEGER(IntKi)  :: NHBD = 0_IntKi      !< Bandwidth = (NBAND+1)/2 [-]
    INTEGER(IntKi)  :: NDIM = 0_IntKi      !< Dimension = 3 [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: NEQ      !< Number of equation [-]
    INTEGER(IntKi)  :: NBAND = 0_IntKi      !< Bandwidth [-]
    INTEGER(IntKi)  :: NumLines = 0_IntKi      !< Number of lines [-]
    INTEGER(IntKi)  :: NumElems = 0_IntKi      !< Number of elements [-]
    INTEGER(IntKi)  :: NumNodes = 0_IntKi      !< Number of nodes [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: GSL      !< Linear spring stiffness at fairlead [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: GP      !< Fairlead position [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Elength      !< Element length [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BottmElev      !< Bottom elevation [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BottmStiff      !< Bottom stiffness [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LMassDen      !< Line mass per unit length [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LDMassDen      !< Line displaced mass per unit length [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LEAStiff      !< Line axial stiffness [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LineCI      !< Line inertia coefficient [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LineCD      !< Line drag coefficient [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Bvp      !< Boundary condtion [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: WaveAcc0      !<  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WaveTime      !<  [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: WaveVel0      !<  [-]
    INTEGER(IntKi)  :: NStepWave = 0_IntKi      !< Number of wave steps [-]
    REAL(ReKi) , DIMENSION(1:6,1:4)  :: SHAP = 0.0_ReKi      !< Shape function [-]
    REAL(ReKi) , DIMENSION(1:6,1:4)  :: SHAPS = 0.0_ReKi      !< Shape function [-]
    REAL(ReKi) , DIMENSION(1:6)  :: GAUSSW = 0.0_ReKi      !< Shape function [-]
    INTEGER(IntKi)  :: NGAUSS = 0_IntKi      !< 6 POINT GAUSSIAN QUADRATURE INTEGRATION [-]
    REAL(ReKi) , DIMENSION(1:10,1:4)  :: SHAPT = 0.0_ReKi      !< Shape function [-]
    REAL(ReKi) , DIMENSION(1:10,1:4)  :: SHAPTS = 0.0_ReKi      !< Shape function [-]
    INTEGER(IntKi)  :: NTRAP = 0_IntKi      !< 10 TRANPEZOIDE INTEGRATION point [-]
    REAL(ReKi) , DIMENSION(1:4,1:4)  :: SBEND = 0.0_ReKi      !< Internal [-]
    REAL(ReKi) , DIMENSION(1:3,1:4,1:4)  :: STEN = 0.0_ReKi      !< Internal [-]
    REAL(ReKi) , DIMENSION(1:4,1:4)  :: RMASS = 0.0_ReKi      !< Internal [-]
    REAL(ReKi) , DIMENSION(1:4,1:4,1:4,1:4)  :: RADDM = 0.0_ReKi      !< Internal [-]
    REAL(ReKi) , DIMENSION(1:3,1:3)  :: PMPN = 0.0_ReKi      !< Internal [-]
    REAL(ReKi) , DIMENSION(1:4)  :: AM = 0.0_ReKi      !< Internal [-]
    REAL(ReKi) , DIMENSION(1:3)  :: PM = 0.0_ReKi      !< Internal [-]
    INTEGER(IntKi) , DIMENSION(1:3,1:4)  :: IDOF = 0_IntKi      !< Internal [-]
    INTEGER(IntKi) , DIMENSION(1:3)  :: JDOF = 0_IntKi      !< Internal [-]
    REAL(ReKi) , DIMENSION(1:3,1:3,1:4)  :: PPA = 0.0_ReKi      !< Internal [-]
    REAL(ReKi)  :: PtfmRefzt = 0.0_ReKi      !< Platform reference [-]
    INTEGER(IntKi)  :: NumOuts = 0_IntKi      !< Number of parameters in the output list (number of outputs requested) [-]
    CHARACTER(1024)  :: RootName      !< RootName for writing output files [-]
    TYPE(OutParmType) , DIMENSION(:), ALLOCATABLE  :: OutParam      !< Names and units (and other characteristics) of all requested output parameters [-]
    CHARACTER(1)  :: Delim      !< Column delimiter for output text files [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: GLUZR      !< Line coordinate & direction cosine [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: GTZER      !< Line tension [-]
  END TYPE FEAM_ParameterType
! =======================
! =========  FEAM_InputType  =======
  TYPE, PUBLIC :: FEAM_InputType
    TYPE(MeshType)  :: HydroForceLineMesh      !< Meshed input data [-]
    TYPE(MeshType)  :: PtFairleadDisplacement      !< Meshed input data [-]
  END TYPE FEAM_InputType
! =======================
! =========  FEAM_OutputType  =======
  TYPE, PUBLIC :: FEAM_OutputType
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WriteOutput      !< Data to be written to an output file: see WriteOutputHdr for names of each variable [see WriteOutputUnt]
    TYPE(MeshType)  :: PtFairleadLoad      !< Meshed output data [-]
    TYPE(MeshType)  :: LineMeshPosition      !< Meshed output data [-]
  END TYPE FEAM_OutputType
! =======================
CONTAINS

subroutine FEAM_CopyInputFile(SrcInputFileData, DstInputFileData, CtrlCode, ErrStat, ErrMsg)
   type(FEAM_InputFile), intent(in) :: SrcInputFileData
   type(FEAM_InputFile), intent(inout) :: DstInputFileData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'FEAM_CopyInputFile'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInputFileData%DT = SrcInputFileData%DT
   if (allocated(SrcInputFileData%LineCI)) then
      LB(1:1) = lbound(SrcInputFileData%LineCI)
      UB(1:1) = ubound(SrcInputFileData%LineCI)
      if (.not. allocated(DstInputFileData%LineCI)) then
         allocate(DstInputFileData%LineCI(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%LineCI.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%LineCI = SrcInputFileData%LineCI
   end if
   if (allocated(SrcInputFileData%LineCD)) then
      LB(1:1) = lbound(SrcInputFileData%LineCD)
      UB(1:1) = ubound(SrcInputFileData%LineCD)
      if (.not. allocated(DstInputFileData%LineCD)) then
         allocate(DstInputFileData%LineCD(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%LineCD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%LineCD = SrcInputFileData%LineCD
   end if
   if (allocated(SrcInputFileData%LEAStiff)) then
      LB(1:1) = lbound(SrcInputFileData%LEAStiff)
      UB(1:1) = ubound(SrcInputFileData%LEAStiff)
      if (.not. allocated(DstInputFileData%LEAStiff)) then
         allocate(DstInputFileData%LEAStiff(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%LEAStiff.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%LEAStiff = SrcInputFileData%LEAStiff
   end if
   if (allocated(SrcInputFileData%LMassDen)) then
      LB(1:1) = lbound(SrcInputFileData%LMassDen)
      UB(1:1) = ubound(SrcInputFileData%LMassDen)
      if (.not. allocated(DstInputFileData%LMassDen)) then
         allocate(DstInputFileData%LMassDen(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%LMassDen.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%LMassDen = SrcInputFileData%LMassDen
   end if
   if (allocated(SrcInputFileData%LDMassDen)) then
      LB(1:1) = lbound(SrcInputFileData%LDMassDen)
      UB(1:1) = ubound(SrcInputFileData%LDMassDen)
      if (.not. allocated(DstInputFileData%LDMassDen)) then
         allocate(DstInputFileData%LDMassDen(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%LDMassDen.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%LDMassDen = SrcInputFileData%LDMassDen
   end if
   if (allocated(SrcInputFileData%BottmStiff)) then
      LB(1:1) = lbound(SrcInputFileData%BottmStiff)
      UB(1:1) = ubound(SrcInputFileData%BottmStiff)
      if (.not. allocated(DstInputFileData%BottmStiff)) then
         allocate(DstInputFileData%BottmStiff(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%BottmStiff.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%BottmStiff = SrcInputFileData%BottmStiff
   end if
   if (allocated(SrcInputFileData%LRadAnch)) then
      LB(1:1) = lbound(SrcInputFileData%LRadAnch)
      UB(1:1) = ubound(SrcInputFileData%LRadAnch)
      if (.not. allocated(DstInputFileData%LRadAnch)) then
         allocate(DstInputFileData%LRadAnch(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%LRadAnch.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%LRadAnch = SrcInputFileData%LRadAnch
   end if
   if (allocated(SrcInputFileData%LAngAnch)) then
      LB(1:1) = lbound(SrcInputFileData%LAngAnch)
      UB(1:1) = ubound(SrcInputFileData%LAngAnch)
      if (.not. allocated(DstInputFileData%LAngAnch)) then
         allocate(DstInputFileData%LAngAnch(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%LAngAnch.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%LAngAnch = SrcInputFileData%LAngAnch
   end if
   if (allocated(SrcInputFileData%LDpthAnch)) then
      LB(1:1) = lbound(SrcInputFileData%LDpthAnch)
      UB(1:1) = ubound(SrcInputFileData%LDpthAnch)
      if (.not. allocated(DstInputFileData%LDpthAnch)) then
         allocate(DstInputFileData%LDpthAnch(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%LDpthAnch.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%LDpthAnch = SrcInputFileData%LDpthAnch
   end if
   if (allocated(SrcInputFileData%LRadFair)) then
      LB(1:1) = lbound(SrcInputFileData%LRadFair)
      UB(1:1) = ubound(SrcInputFileData%LRadFair)
      if (.not. allocated(DstInputFileData%LRadFair)) then
         allocate(DstInputFileData%LRadFair(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%LRadFair.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%LRadFair = SrcInputFileData%LRadFair
   end if
   if (allocated(SrcInputFileData%LAngFair)) then
      LB(1:1) = lbound(SrcInputFileData%LAngFair)
      UB(1:1) = ubound(SrcInputFileData%LAngFair)
      if (.not. allocated(DstInputFileData%LAngFair)) then
         allocate(DstInputFileData%LAngFair(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%LAngFair.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%LAngFair = SrcInputFileData%LAngFair
   end if
   if (allocated(SrcInputFileData%LDrftFair)) then
      LB(1:1) = lbound(SrcInputFileData%LDrftFair)
      UB(1:1) = ubound(SrcInputFileData%LDrftFair)
      if (.not. allocated(DstInputFileData%LDrftFair)) then
         allocate(DstInputFileData%LDrftFair(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%LDrftFair.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%LDrftFair = SrcInputFileData%LDrftFair
   end if
   if (allocated(SrcInputFileData%LUnstrLen)) then
      LB(1:1) = lbound(SrcInputFileData%LUnstrLen)
      UB(1:1) = ubound(SrcInputFileData%LUnstrLen)
      if (.not. allocated(DstInputFileData%LUnstrLen)) then
         allocate(DstInputFileData%LUnstrLen(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%LUnstrLen.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%LUnstrLen = SrcInputFileData%LUnstrLen
   end if
   if (allocated(SrcInputFileData%Tension)) then
      LB(1:1) = lbound(SrcInputFileData%Tension)
      UB(1:1) = ubound(SrcInputFileData%Tension)
      if (.not. allocated(DstInputFileData%Tension)) then
         allocate(DstInputFileData%Tension(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%Tension.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%Tension = SrcInputFileData%Tension
   end if
   if (allocated(SrcInputFileData%GSL)) then
      LB(1:3) = lbound(SrcInputFileData%GSL)
      UB(1:3) = ubound(SrcInputFileData%GSL)
      if (.not. allocated(DstInputFileData%GSL)) then
         allocate(DstInputFileData%GSL(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%GSL.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%GSL = SrcInputFileData%GSL
   end if
   if (allocated(SrcInputFileData%GSR)) then
      LB(1:2) = lbound(SrcInputFileData%GSR)
      UB(1:2) = ubound(SrcInputFileData%GSR)
      if (.not. allocated(DstInputFileData%GSR)) then
         allocate(DstInputFileData%GSR(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%GSR.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%GSR = SrcInputFileData%GSR
   end if
   if (allocated(SrcInputFileData%GE)) then
      LB(1:3) = lbound(SrcInputFileData%GE)
      UB(1:3) = ubound(SrcInputFileData%GE)
      if (.not. allocated(DstInputFileData%GE)) then
         allocate(DstInputFileData%GE(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%GE.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%GE = SrcInputFileData%GE
   end if
   DstInputFileData%NumLines = SrcInputFileData%NumLines
   DstInputFileData%NumElems = SrcInputFileData%NumElems
   DstInputFileData%Eps = SrcInputFileData%Eps
   DstInputFileData%Gravity = SrcInputFileData%Gravity
   DstInputFileData%WtrDens = SrcInputFileData%WtrDens
   DstInputFileData%MaxIter = SrcInputFileData%MaxIter
   DstInputFileData%SumPrint = SrcInputFileData%SumPrint
   DstInputFileData%OutFile = SrcInputFileData%OutFile
   DstInputFileData%TabDelim = SrcInputFileData%TabDelim
   DstInputFileData%OutFmt = SrcInputFileData%OutFmt
   DstInputFileData%Tstart = SrcInputFileData%Tstart
   DstInputFileData%NumOuts = SrcInputFileData%NumOuts
   if (allocated(SrcInputFileData%OutList)) then
      LB(1:1) = lbound(SrcInputFileData%OutList)
      UB(1:1) = ubound(SrcInputFileData%OutList)
      if (.not. allocated(DstInputFileData%OutList)) then
         allocate(DstInputFileData%OutList(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%OutList.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%OutList = SrcInputFileData%OutList
   end if
end subroutine

subroutine FEAM_DestroyInputFile(InputFileData, ErrStat, ErrMsg)
   type(FEAM_InputFile), intent(inout) :: InputFileData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FEAM_DestroyInputFile'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InputFileData%LineCI)) then
      deallocate(InputFileData%LineCI)
   end if
   if (allocated(InputFileData%LineCD)) then
      deallocate(InputFileData%LineCD)
   end if
   if (allocated(InputFileData%LEAStiff)) then
      deallocate(InputFileData%LEAStiff)
   end if
   if (allocated(InputFileData%LMassDen)) then
      deallocate(InputFileData%LMassDen)
   end if
   if (allocated(InputFileData%LDMassDen)) then
      deallocate(InputFileData%LDMassDen)
   end if
   if (allocated(InputFileData%BottmStiff)) then
      deallocate(InputFileData%BottmStiff)
   end if
   if (allocated(InputFileData%LRadAnch)) then
      deallocate(InputFileData%LRadAnch)
   end if
   if (allocated(InputFileData%LAngAnch)) then
      deallocate(InputFileData%LAngAnch)
   end if
   if (allocated(InputFileData%LDpthAnch)) then
      deallocate(InputFileData%LDpthAnch)
   end if
   if (allocated(InputFileData%LRadFair)) then
      deallocate(InputFileData%LRadFair)
   end if
   if (allocated(InputFileData%LAngFair)) then
      deallocate(InputFileData%LAngFair)
   end if
   if (allocated(InputFileData%LDrftFair)) then
      deallocate(InputFileData%LDrftFair)
   end if
   if (allocated(InputFileData%LUnstrLen)) then
      deallocate(InputFileData%LUnstrLen)
   end if
   if (allocated(InputFileData%Tension)) then
      deallocate(InputFileData%Tension)
   end if
   if (allocated(InputFileData%GSL)) then
      deallocate(InputFileData%GSL)
   end if
   if (allocated(InputFileData%GSR)) then
      deallocate(InputFileData%GSR)
   end if
   if (allocated(InputFileData%GE)) then
      deallocate(InputFileData%GE)
   end if
   if (allocated(InputFileData%OutList)) then
      deallocate(InputFileData%OutList)
   end if
end subroutine

subroutine FEAM_PackInputFile(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FEAM_InputFile), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FEAM_PackInputFile'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DT)
   call RegPackAlloc(RF, InData%LineCI)
   call RegPackAlloc(RF, InData%LineCD)
   call RegPackAlloc(RF, InData%LEAStiff)
   call RegPackAlloc(RF, InData%LMassDen)
   call RegPackAlloc(RF, InData%LDMassDen)
   call RegPackAlloc(RF, InData%BottmStiff)
   call RegPackAlloc(RF, InData%LRadAnch)
   call RegPackAlloc(RF, InData%LAngAnch)
   call RegPackAlloc(RF, InData%LDpthAnch)
   call RegPackAlloc(RF, InData%LRadFair)
   call RegPackAlloc(RF, InData%LAngFair)
   call RegPackAlloc(RF, InData%LDrftFair)
   call RegPackAlloc(RF, InData%LUnstrLen)
   call RegPackAlloc(RF, InData%Tension)
   call RegPackAlloc(RF, InData%GSL)
   call RegPackAlloc(RF, InData%GSR)
   call RegPackAlloc(RF, InData%GE)
   call RegPack(RF, InData%NumLines)
   call RegPack(RF, InData%NumElems)
   call RegPack(RF, InData%Eps)
   call RegPack(RF, InData%Gravity)
   call RegPack(RF, InData%WtrDens)
   call RegPack(RF, InData%MaxIter)
   call RegPack(RF, InData%SumPrint)
   call RegPack(RF, InData%OutFile)
   call RegPack(RF, InData%TabDelim)
   call RegPack(RF, InData%OutFmt)
   call RegPack(RF, InData%Tstart)
   call RegPack(RF, InData%NumOuts)
   call RegPackAlloc(RF, InData%OutList)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FEAM_UnPackInputFile(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FEAM_InputFile), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FEAM_UnPackInputFile'
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LineCI); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LineCD); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LEAStiff); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LMassDen); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LDMassDen); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BottmStiff); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LRadAnch); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LAngAnch); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LDpthAnch); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LRadFair); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LAngFair); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LDrftFair); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LUnstrLen); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Tension); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%GSL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%GSR); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%GE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumLines); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumElems); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Eps); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Gravity); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WtrDens); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MaxIter); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SumPrint); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TabDelim); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutFmt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Tstart); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%OutList); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FEAM_CopyInitInput(SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg)
   type(FEAM_InitInputType), intent(in) :: SrcInitInputData
   type(FEAM_InitInputType), intent(inout) :: DstInitInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'FEAM_CopyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInitInputData%InputFile = SrcInitInputData%InputFile
   DstInitInputData%RootName = SrcInitInputData%RootName
   DstInitInputData%PtfmInit = SrcInitInputData%PtfmInit
   DstInitInputData%NStepWave = SrcInitInputData%NStepWave
   if (allocated(SrcInitInputData%WaveAcc0)) then
      LB(1:3) = lbound(SrcInitInputData%WaveAcc0)
      UB(1:3) = ubound(SrcInitInputData%WaveAcc0)
      if (.not. allocated(DstInitInputData%WaveAcc0)) then
         allocate(DstInitInputData%WaveAcc0(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%WaveAcc0.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%WaveAcc0 = SrcInitInputData%WaveAcc0
   end if
   if (allocated(SrcInitInputData%WaveTime)) then
      LB(1:1) = lbound(SrcInitInputData%WaveTime)
      UB(1:1) = ubound(SrcInitInputData%WaveTime)
      if (.not. allocated(DstInitInputData%WaveTime)) then
         allocate(DstInitInputData%WaveTime(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%WaveTime.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%WaveTime = SrcInitInputData%WaveTime
   end if
   if (allocated(SrcInitInputData%WaveVel0)) then
      LB(1:3) = lbound(SrcInitInputData%WaveVel0)
      UB(1:3) = ubound(SrcInitInputData%WaveVel0)
      if (.not. allocated(DstInitInputData%WaveVel0)) then
         allocate(DstInitInputData%WaveVel0(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%WaveVel0.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%WaveVel0 = SrcInitInputData%WaveVel0
   end if
   DstInitInputData%Gravity = SrcInitInputData%Gravity
   DstInitInputData%WtrDens = SrcInitInputData%WtrDens
end subroutine

subroutine FEAM_DestroyInitInput(InitInputData, ErrStat, ErrMsg)
   type(FEAM_InitInputType), intent(inout) :: InitInputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FEAM_DestroyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InitInputData%WaveAcc0)) then
      deallocate(InitInputData%WaveAcc0)
   end if
   if (allocated(InitInputData%WaveTime)) then
      deallocate(InitInputData%WaveTime)
   end if
   if (allocated(InitInputData%WaveVel0)) then
      deallocate(InitInputData%WaveVel0)
   end if
end subroutine

subroutine FEAM_PackInitInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FEAM_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FEAM_PackInitInput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%InputFile)
   call RegPack(RF, InData%RootName)
   call RegPack(RF, InData%PtfmInit)
   call RegPack(RF, InData%NStepWave)
   call RegPackAlloc(RF, InData%WaveAcc0)
   call RegPackAlloc(RF, InData%WaveTime)
   call RegPackAlloc(RF, InData%WaveVel0)
   call RegPack(RF, InData%Gravity)
   call RegPack(RF, InData%WtrDens)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FEAM_UnPackInitInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FEAM_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FEAM_UnPackInitInput'
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%InputFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmInit); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NStepWave); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WaveAcc0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WaveTime); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WaveVel0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Gravity); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WtrDens); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FEAM_CopyInitOutput(SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg)
   type(FEAM_InitOutputType), intent(in) :: SrcInitOutputData
   type(FEAM_InitOutputType), intent(inout) :: DstInitOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FEAM_CopyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcInitOutputData%WriteOutputHdr)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputHdr)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputHdr)
      if (.not. allocated(DstInitOutputData%WriteOutputHdr)) then
         allocate(DstInitOutputData%WriteOutputHdr(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputHdr.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputHdr = SrcInitOutputData%WriteOutputHdr
   end if
   if (allocated(SrcInitOutputData%WriteOutputUnt)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputUnt)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputUnt)
      if (.not. allocated(DstInitOutputData%WriteOutputUnt)) then
         allocate(DstInitOutputData%WriteOutputUnt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputUnt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputUnt = SrcInitOutputData%WriteOutputUnt
   end if
   call NWTC_Library_CopyProgDesc(SrcInitOutputData%Ver, DstInitOutputData%Ver, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcInitOutputData%LAnchxi)) then
      LB(1:1) = lbound(SrcInitOutputData%LAnchxi)
      UB(1:1) = ubound(SrcInitOutputData%LAnchxi)
      if (.not. allocated(DstInitOutputData%LAnchxi)) then
         allocate(DstInitOutputData%LAnchxi(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LAnchxi.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%LAnchxi = SrcInitOutputData%LAnchxi
   end if
   if (allocated(SrcInitOutputData%LAnchyi)) then
      LB(1:1) = lbound(SrcInitOutputData%LAnchyi)
      UB(1:1) = ubound(SrcInitOutputData%LAnchyi)
      if (.not. allocated(DstInitOutputData%LAnchyi)) then
         allocate(DstInitOutputData%LAnchyi(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LAnchyi.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%LAnchyi = SrcInitOutputData%LAnchyi
   end if
   if (allocated(SrcInitOutputData%LAnchzi)) then
      LB(1:1) = lbound(SrcInitOutputData%LAnchzi)
      UB(1:1) = ubound(SrcInitOutputData%LAnchzi)
      if (.not. allocated(DstInitOutputData%LAnchzi)) then
         allocate(DstInitOutputData%LAnchzi(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LAnchzi.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%LAnchzi = SrcInitOutputData%LAnchzi
   end if
   if (allocated(SrcInitOutputData%LFairxt)) then
      LB(1:1) = lbound(SrcInitOutputData%LFairxt)
      UB(1:1) = ubound(SrcInitOutputData%LFairxt)
      if (.not. allocated(DstInitOutputData%LFairxt)) then
         allocate(DstInitOutputData%LFairxt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LFairxt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%LFairxt = SrcInitOutputData%LFairxt
   end if
   if (allocated(SrcInitOutputData%LFairyt)) then
      LB(1:1) = lbound(SrcInitOutputData%LFairyt)
      UB(1:1) = ubound(SrcInitOutputData%LFairyt)
      if (.not. allocated(DstInitOutputData%LFairyt)) then
         allocate(DstInitOutputData%LFairyt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LFairyt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%LFairyt = SrcInitOutputData%LFairyt
   end if
   if (allocated(SrcInitOutputData%LFairzt)) then
      LB(1:1) = lbound(SrcInitOutputData%LFairzt)
      UB(1:1) = ubound(SrcInitOutputData%LFairzt)
      if (.not. allocated(DstInitOutputData%LFairzt)) then
         allocate(DstInitOutputData%LFairzt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LFairzt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%LFairzt = SrcInitOutputData%LFairzt
   end if
end subroutine

subroutine FEAM_DestroyInitOutput(InitOutputData, ErrStat, ErrMsg)
   type(FEAM_InitOutputType), intent(inout) :: InitOutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FEAM_DestroyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InitOutputData%WriteOutputHdr)) then
      deallocate(InitOutputData%WriteOutputHdr)
   end if
   if (allocated(InitOutputData%WriteOutputUnt)) then
      deallocate(InitOutputData%WriteOutputUnt)
   end if
   call NWTC_Library_DestroyProgDesc(InitOutputData%Ver, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(InitOutputData%LAnchxi)) then
      deallocate(InitOutputData%LAnchxi)
   end if
   if (allocated(InitOutputData%LAnchyi)) then
      deallocate(InitOutputData%LAnchyi)
   end if
   if (allocated(InitOutputData%LAnchzi)) then
      deallocate(InitOutputData%LAnchzi)
   end if
   if (allocated(InitOutputData%LFairxt)) then
      deallocate(InitOutputData%LFairxt)
   end if
   if (allocated(InitOutputData%LFairyt)) then
      deallocate(InitOutputData%LFairyt)
   end if
   if (allocated(InitOutputData%LFairzt)) then
      deallocate(InitOutputData%LFairzt)
   end if
end subroutine

subroutine FEAM_PackInitOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FEAM_InitOutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FEAM_PackInitOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%WriteOutputHdr)
   call RegPackAlloc(RF, InData%WriteOutputUnt)
   call NWTC_Library_PackProgDesc(RF, InData%Ver) 
   call RegPackAlloc(RF, InData%LAnchxi)
   call RegPackAlloc(RF, InData%LAnchyi)
   call RegPackAlloc(RF, InData%LAnchzi)
   call RegPackAlloc(RF, InData%LFairxt)
   call RegPackAlloc(RF, InData%LFairyt)
   call RegPackAlloc(RF, InData%LFairzt)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FEAM_UnPackInitOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FEAM_InitOutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FEAM_UnPackInitOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%WriteOutputHdr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutputUnt); if (RegCheckErr(RF, RoutineName)) return
   call NWTC_Library_UnpackProgDesc(RF, OutData%Ver) ! Ver 
   call RegUnpackAlloc(RF, OutData%LAnchxi); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LAnchyi); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LAnchzi); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LFairxt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LFairyt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LFairzt); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FEAM_CopyContState(SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg)
   type(FEAM_ContinuousStateType), intent(in) :: SrcContStateData
   type(FEAM_ContinuousStateType), intent(inout) :: DstContStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'FEAM_CopyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcContStateData%GLU)) then
      LB(1:2) = lbound(SrcContStateData%GLU)
      UB(1:2) = ubound(SrcContStateData%GLU)
      if (.not. allocated(DstContStateData%GLU)) then
         allocate(DstContStateData%GLU(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstContStateData%GLU.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstContStateData%GLU = SrcContStateData%GLU
   end if
   if (allocated(SrcContStateData%GLDU)) then
      LB(1:2) = lbound(SrcContStateData%GLDU)
      UB(1:2) = ubound(SrcContStateData%GLDU)
      if (.not. allocated(DstContStateData%GLDU)) then
         allocate(DstContStateData%GLDU(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstContStateData%GLDU.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstContStateData%GLDU = SrcContStateData%GLDU
   end if
end subroutine

subroutine FEAM_DestroyContState(ContStateData, ErrStat, ErrMsg)
   type(FEAM_ContinuousStateType), intent(inout) :: ContStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FEAM_DestroyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ContStateData%GLU)) then
      deallocate(ContStateData%GLU)
   end if
   if (allocated(ContStateData%GLDU)) then
      deallocate(ContStateData%GLDU)
   end if
end subroutine

subroutine FEAM_PackContState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FEAM_ContinuousStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FEAM_PackContState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%GLU)
   call RegPackAlloc(RF, InData%GLDU)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FEAM_UnPackContState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FEAM_ContinuousStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FEAM_UnPackContState'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%GLU); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%GLDU); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FEAM_CopyDiscState(SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg)
   type(FEAM_DiscreteStateType), intent(in) :: SrcDiscStateData
   type(FEAM_DiscreteStateType), intent(inout) :: DstDiscStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FEAM_CopyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstDiscStateData%DummyDiscState = SrcDiscStateData%DummyDiscState
end subroutine

subroutine FEAM_DestroyDiscState(DiscStateData, ErrStat, ErrMsg)
   type(FEAM_DiscreteStateType), intent(inout) :: DiscStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FEAM_DestroyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine FEAM_PackDiscState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FEAM_DiscreteStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FEAM_PackDiscState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyDiscState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FEAM_UnPackDiscState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FEAM_DiscreteStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FEAM_UnPackDiscState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyDiscState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FEAM_CopyConstrState(SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg)
   type(FEAM_ConstraintStateType), intent(in) :: SrcConstrStateData
   type(FEAM_ConstraintStateType), intent(inout) :: DstConstrStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FEAM_CopyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstConstrStateData%TSN = SrcConstrStateData%TSN
   DstConstrStateData%TZER = SrcConstrStateData%TZER
end subroutine

subroutine FEAM_DestroyConstrState(ConstrStateData, ErrStat, ErrMsg)
   type(FEAM_ConstraintStateType), intent(inout) :: ConstrStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FEAM_DestroyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine FEAM_PackConstrState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FEAM_ConstraintStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FEAM_PackConstrState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%TSN)
   call RegPack(RF, InData%TZER)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FEAM_UnPackConstrState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FEAM_ConstraintStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FEAM_UnPackConstrState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%TSN); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TZER); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FEAM_CopyOtherState(SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg)
   type(FEAM_OtherStateType), intent(in) :: SrcOtherStateData
   type(FEAM_OtherStateType), intent(inout) :: DstOtherStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(4), UB(4)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'FEAM_CopyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcOtherStateData%GLU0)) then
      LB(1:2) = lbound(SrcOtherStateData%GLU0)
      UB(1:2) = ubound(SrcOtherStateData%GLU0)
      if (.not. allocated(DstOtherStateData%GLU0)) then
         allocate(DstOtherStateData%GLU0(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%GLU0.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOtherStateData%GLU0 = SrcOtherStateData%GLU0
   end if
   if (allocated(SrcOtherStateData%GLDDU)) then
      LB(1:2) = lbound(SrcOtherStateData%GLDDU)
      UB(1:2) = ubound(SrcOtherStateData%GLDDU)
      if (.not. allocated(DstOtherStateData%GLDDU)) then
         allocate(DstOtherStateData%GLDDU(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%GLDDU.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOtherStateData%GLDDU = SrcOtherStateData%GLDDU
   end if
   DstOtherStateData%BottomTouch = SrcOtherStateData%BottomTouch
   if (allocated(SrcOtherStateData%GFORC0)) then
      LB(1:3) = lbound(SrcOtherStateData%GFORC0)
      UB(1:3) = ubound(SrcOtherStateData%GFORC0)
      if (.not. allocated(DstOtherStateData%GFORC0)) then
         allocate(DstOtherStateData%GFORC0(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%GFORC0.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOtherStateData%GFORC0 = SrcOtherStateData%GFORC0
   end if
   if (allocated(SrcOtherStateData%GMASS0)) then
      LB(1:4) = lbound(SrcOtherStateData%GMASS0)
      UB(1:4) = ubound(SrcOtherStateData%GMASS0)
      if (.not. allocated(DstOtherStateData%GMASS0)) then
         allocate(DstOtherStateData%GMASS0(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%GMASS0.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOtherStateData%GMASS0 = SrcOtherStateData%GMASS0
   end if
   if (allocated(SrcOtherStateData%FAST_FPA)) then
      LB(1:2) = lbound(SrcOtherStateData%FAST_FPA)
      UB(1:2) = ubound(SrcOtherStateData%FAST_FPA)
      if (.not. allocated(DstOtherStateData%FAST_FPA)) then
         allocate(DstOtherStateData%FAST_FPA(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%FAST_FPA.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOtherStateData%FAST_FPA = SrcOtherStateData%FAST_FPA
   end if
   if (allocated(SrcOtherStateData%FAST_RP)) then
      LB(1:2) = lbound(SrcOtherStateData%FAST_RP)
      UB(1:2) = ubound(SrcOtherStateData%FAST_RP)
      if (.not. allocated(DstOtherStateData%FAST_RP)) then
         allocate(DstOtherStateData%FAST_RP(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%FAST_RP.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOtherStateData%FAST_RP = SrcOtherStateData%FAST_RP
   end if
   DstOtherStateData%INCR = SrcOtherStateData%INCR
   DstOtherStateData%RSDF = SrcOtherStateData%RSDF
   DstOtherStateData%FORC0 = SrcOtherStateData%FORC0
   DstOtherStateData%EMAS0 = SrcOtherStateData%EMAS0
end subroutine

subroutine FEAM_DestroyOtherState(OtherStateData, ErrStat, ErrMsg)
   type(FEAM_OtherStateType), intent(inout) :: OtherStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FEAM_DestroyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(OtherStateData%GLU0)) then
      deallocate(OtherStateData%GLU0)
   end if
   if (allocated(OtherStateData%GLDDU)) then
      deallocate(OtherStateData%GLDDU)
   end if
   if (allocated(OtherStateData%GFORC0)) then
      deallocate(OtherStateData%GFORC0)
   end if
   if (allocated(OtherStateData%GMASS0)) then
      deallocate(OtherStateData%GMASS0)
   end if
   if (allocated(OtherStateData%FAST_FPA)) then
      deallocate(OtherStateData%FAST_FPA)
   end if
   if (allocated(OtherStateData%FAST_RP)) then
      deallocate(OtherStateData%FAST_RP)
   end if
end subroutine

subroutine FEAM_PackOtherState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FEAM_OtherStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FEAM_PackOtherState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%GLU0)
   call RegPackAlloc(RF, InData%GLDDU)
   call RegPack(RF, InData%BottomTouch)
   call RegPackAlloc(RF, InData%GFORC0)
   call RegPackAlloc(RF, InData%GMASS0)
   call RegPackAlloc(RF, InData%FAST_FPA)
   call RegPackAlloc(RF, InData%FAST_RP)
   call RegPack(RF, InData%INCR)
   call RegPack(RF, InData%RSDF)
   call RegPack(RF, InData%FORC0)
   call RegPack(RF, InData%EMAS0)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FEAM_UnPackOtherState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FEAM_OtherStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FEAM_UnPackOtherState'
   integer(B4Ki)   :: LB(4), UB(4)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%GLU0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%GLDDU); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BottomTouch); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%GFORC0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%GMASS0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%FAST_FPA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%FAST_RP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%INCR); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RSDF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FORC0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%EMAS0); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FEAM_CopyMisc(SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg)
   type(FEAM_MiscVarType), intent(in) :: SrcMiscData
   type(FEAM_MiscVarType), intent(inout) :: DstMiscData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'FEAM_CopyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcMiscData%GLF)) then
      LB(1:2) = lbound(SrcMiscData%GLF)
      UB(1:2) = ubound(SrcMiscData%GLF)
      if (.not. allocated(DstMiscData%GLF)) then
         allocate(DstMiscData%GLF(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%GLF.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%GLF = SrcMiscData%GLF
   end if
   if (allocated(SrcMiscData%GLK)) then
      LB(1:3) = lbound(SrcMiscData%GLK)
      UB(1:3) = ubound(SrcMiscData%GLK)
      if (.not. allocated(DstMiscData%GLK)) then
         allocate(DstMiscData%GLK(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%GLK.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%GLK = SrcMiscData%GLK
   end if
   DstMiscData%EMASS = SrcMiscData%EMASS
   DstMiscData%ESTIF = SrcMiscData%ESTIF
   if (allocated(SrcMiscData%FAST_FP)) then
      LB(1:2) = lbound(SrcMiscData%FAST_FP)
      UB(1:2) = ubound(SrcMiscData%FAST_FP)
      if (.not. allocated(DstMiscData%FAST_FP)) then
         allocate(DstMiscData%FAST_FP(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%FAST_FP.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%FAST_FP = SrcMiscData%FAST_FP
   end if
   DstMiscData%FORCE = SrcMiscData%FORCE
   DstMiscData%FP = SrcMiscData%FP
   DstMiscData%U = SrcMiscData%U
   DstMiscData%U0 = SrcMiscData%U0
   DstMiscData%DU = SrcMiscData%DU
   DstMiscData%DDU = SrcMiscData%DDU
   DstMiscData%R = SrcMiscData%R
   DstMiscData%RP = SrcMiscData%RP
   DstMiscData%RHSR = SrcMiscData%RHSR
   DstMiscData%SLIN = SrcMiscData%SLIN
   DstMiscData%STIFR = SrcMiscData%STIFR
   if (allocated(SrcMiscData%FAIR_ANG)) then
      LB(1:2) = lbound(SrcMiscData%FAIR_ANG)
      UB(1:2) = ubound(SrcMiscData%FAIR_ANG)
      if (.not. allocated(DstMiscData%FAIR_ANG)) then
         allocate(DstMiscData%FAIR_ANG(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%FAIR_ANG.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%FAIR_ANG = SrcMiscData%FAIR_ANG
   end if
   if (allocated(SrcMiscData%FAIR_T)) then
      LB(1:1) = lbound(SrcMiscData%FAIR_T)
      UB(1:1) = ubound(SrcMiscData%FAIR_T)
      if (.not. allocated(DstMiscData%FAIR_T)) then
         allocate(DstMiscData%FAIR_T(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%FAIR_T.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%FAIR_T = SrcMiscData%FAIR_T
   end if
   if (allocated(SrcMiscData%ANCH_ANG)) then
      LB(1:2) = lbound(SrcMiscData%ANCH_ANG)
      UB(1:2) = ubound(SrcMiscData%ANCH_ANG)
      if (.not. allocated(DstMiscData%ANCH_ANG)) then
         allocate(DstMiscData%ANCH_ANG(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%ANCH_ANG.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%ANCH_ANG = SrcMiscData%ANCH_ANG
   end if
   if (allocated(SrcMiscData%ANCH_T)) then
      LB(1:1) = lbound(SrcMiscData%ANCH_T)
      UB(1:1) = ubound(SrcMiscData%ANCH_T)
      if (.not. allocated(DstMiscData%ANCH_T)) then
         allocate(DstMiscData%ANCH_T(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%ANCH_T.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%ANCH_T = SrcMiscData%ANCH_T
   end if
   if (allocated(SrcMiscData%Line_Coordinate)) then
      LB(1:3) = lbound(SrcMiscData%Line_Coordinate)
      UB(1:3) = ubound(SrcMiscData%Line_Coordinate)
      if (.not. allocated(DstMiscData%Line_Coordinate)) then
         allocate(DstMiscData%Line_Coordinate(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%Line_Coordinate.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%Line_Coordinate = SrcMiscData%Line_Coordinate
   end if
   if (allocated(SrcMiscData%Line_Tangent)) then
      LB(1:3) = lbound(SrcMiscData%Line_Tangent)
      UB(1:3) = ubound(SrcMiscData%Line_Tangent)
      if (.not. allocated(DstMiscData%Line_Tangent)) then
         allocate(DstMiscData%Line_Tangent(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%Line_Tangent.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%Line_Tangent = SrcMiscData%Line_Tangent
   end if
   if (allocated(SrcMiscData%F_Lines)) then
      LB(1:2) = lbound(SrcMiscData%F_Lines)
      UB(1:2) = ubound(SrcMiscData%F_Lines)
      if (.not. allocated(DstMiscData%F_Lines)) then
         allocate(DstMiscData%F_Lines(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%F_Lines.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%F_Lines = SrcMiscData%F_Lines
   end if
   DstMiscData%LastIndWave = SrcMiscData%LastIndWave
end subroutine

subroutine FEAM_DestroyMisc(MiscData, ErrStat, ErrMsg)
   type(FEAM_MiscVarType), intent(inout) :: MiscData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FEAM_DestroyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(MiscData%GLF)) then
      deallocate(MiscData%GLF)
   end if
   if (allocated(MiscData%GLK)) then
      deallocate(MiscData%GLK)
   end if
   if (allocated(MiscData%FAST_FP)) then
      deallocate(MiscData%FAST_FP)
   end if
   if (allocated(MiscData%FAIR_ANG)) then
      deallocate(MiscData%FAIR_ANG)
   end if
   if (allocated(MiscData%FAIR_T)) then
      deallocate(MiscData%FAIR_T)
   end if
   if (allocated(MiscData%ANCH_ANG)) then
      deallocate(MiscData%ANCH_ANG)
   end if
   if (allocated(MiscData%ANCH_T)) then
      deallocate(MiscData%ANCH_T)
   end if
   if (allocated(MiscData%Line_Coordinate)) then
      deallocate(MiscData%Line_Coordinate)
   end if
   if (allocated(MiscData%Line_Tangent)) then
      deallocate(MiscData%Line_Tangent)
   end if
   if (allocated(MiscData%F_Lines)) then
      deallocate(MiscData%F_Lines)
   end if
end subroutine

subroutine FEAM_PackMisc(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FEAM_MiscVarType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FEAM_PackMisc'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%GLF)
   call RegPackAlloc(RF, InData%GLK)
   call RegPack(RF, InData%EMASS)
   call RegPack(RF, InData%ESTIF)
   call RegPackAlloc(RF, InData%FAST_FP)
   call RegPack(RF, InData%FORCE)
   call RegPack(RF, InData%FP)
   call RegPack(RF, InData%U)
   call RegPack(RF, InData%U0)
   call RegPack(RF, InData%DU)
   call RegPack(RF, InData%DDU)
   call RegPack(RF, InData%R)
   call RegPack(RF, InData%RP)
   call RegPack(RF, InData%RHSR)
   call RegPack(RF, InData%SLIN)
   call RegPack(RF, InData%STIFR)
   call RegPackAlloc(RF, InData%FAIR_ANG)
   call RegPackAlloc(RF, InData%FAIR_T)
   call RegPackAlloc(RF, InData%ANCH_ANG)
   call RegPackAlloc(RF, InData%ANCH_T)
   call RegPackAlloc(RF, InData%Line_Coordinate)
   call RegPackAlloc(RF, InData%Line_Tangent)
   call RegPackAlloc(RF, InData%F_Lines)
   call RegPack(RF, InData%LastIndWave)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FEAM_UnPackMisc(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FEAM_MiscVarType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FEAM_UnPackMisc'
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%GLF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%GLK); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%EMASS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ESTIF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%FAST_FP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FORCE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%U); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%U0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DU); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DDU); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%R); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RHSR); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SLIN); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%STIFR); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%FAIR_ANG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%FAIR_T); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%ANCH_ANG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%ANCH_T); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Line_Coordinate); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Line_Tangent); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%F_Lines); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LastIndWave); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FEAM_CopyParam(SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg)
   type(FEAM_ParameterType), intent(in) :: SrcParamData
   type(FEAM_ParameterType), intent(inout) :: DstParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2, i3, i4
   integer(B4Ki)                  :: LB(4), UB(4)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FEAM_CopyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstParamData%DT = SrcParamData%DT
   DstParamData%GRAV = SrcParamData%GRAV
   DstParamData%Eps = SrcParamData%Eps
   DstParamData%Gravity = SrcParamData%Gravity
   DstParamData%WtrDens = SrcParamData%WtrDens
   DstParamData%MaxIter = SrcParamData%MaxIter
   DstParamData%NHBD = SrcParamData%NHBD
   DstParamData%NDIM = SrcParamData%NDIM
   if (allocated(SrcParamData%NEQ)) then
      LB(1:1) = lbound(SrcParamData%NEQ)
      UB(1:1) = ubound(SrcParamData%NEQ)
      if (.not. allocated(DstParamData%NEQ)) then
         allocate(DstParamData%NEQ(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%NEQ.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%NEQ = SrcParamData%NEQ
   end if
   DstParamData%NBAND = SrcParamData%NBAND
   DstParamData%NumLines = SrcParamData%NumLines
   DstParamData%NumElems = SrcParamData%NumElems
   DstParamData%NumNodes = SrcParamData%NumNodes
   if (allocated(SrcParamData%GSL)) then
      LB(1:3) = lbound(SrcParamData%GSL)
      UB(1:3) = ubound(SrcParamData%GSL)
      if (.not. allocated(DstParamData%GSL)) then
         allocate(DstParamData%GSL(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%GSL.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%GSL = SrcParamData%GSL
   end if
   if (allocated(SrcParamData%GP)) then
      LB(1:2) = lbound(SrcParamData%GP)
      UB(1:2) = ubound(SrcParamData%GP)
      if (.not. allocated(DstParamData%GP)) then
         allocate(DstParamData%GP(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%GP.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%GP = SrcParamData%GP
   end if
   if (allocated(SrcParamData%Elength)) then
      LB(1:1) = lbound(SrcParamData%Elength)
      UB(1:1) = ubound(SrcParamData%Elength)
      if (.not. allocated(DstParamData%Elength)) then
         allocate(DstParamData%Elength(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Elength.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Elength = SrcParamData%Elength
   end if
   if (allocated(SrcParamData%BottmElev)) then
      LB(1:1) = lbound(SrcParamData%BottmElev)
      UB(1:1) = ubound(SrcParamData%BottmElev)
      if (.not. allocated(DstParamData%BottmElev)) then
         allocate(DstParamData%BottmElev(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%BottmElev.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%BottmElev = SrcParamData%BottmElev
   end if
   if (allocated(SrcParamData%BottmStiff)) then
      LB(1:1) = lbound(SrcParamData%BottmStiff)
      UB(1:1) = ubound(SrcParamData%BottmStiff)
      if (.not. allocated(DstParamData%BottmStiff)) then
         allocate(DstParamData%BottmStiff(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%BottmStiff.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%BottmStiff = SrcParamData%BottmStiff
   end if
   if (allocated(SrcParamData%LMassDen)) then
      LB(1:1) = lbound(SrcParamData%LMassDen)
      UB(1:1) = ubound(SrcParamData%LMassDen)
      if (.not. allocated(DstParamData%LMassDen)) then
         allocate(DstParamData%LMassDen(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%LMassDen.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%LMassDen = SrcParamData%LMassDen
   end if
   if (allocated(SrcParamData%LDMassDen)) then
      LB(1:1) = lbound(SrcParamData%LDMassDen)
      UB(1:1) = ubound(SrcParamData%LDMassDen)
      if (.not. allocated(DstParamData%LDMassDen)) then
         allocate(DstParamData%LDMassDen(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%LDMassDen.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%LDMassDen = SrcParamData%LDMassDen
   end if
   if (allocated(SrcParamData%LEAStiff)) then
      LB(1:1) = lbound(SrcParamData%LEAStiff)
      UB(1:1) = ubound(SrcParamData%LEAStiff)
      if (.not. allocated(DstParamData%LEAStiff)) then
         allocate(DstParamData%LEAStiff(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%LEAStiff.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%LEAStiff = SrcParamData%LEAStiff
   end if
   if (allocated(SrcParamData%LineCI)) then
      LB(1:1) = lbound(SrcParamData%LineCI)
      UB(1:1) = ubound(SrcParamData%LineCI)
      if (.not. allocated(DstParamData%LineCI)) then
         allocate(DstParamData%LineCI(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%LineCI.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%LineCI = SrcParamData%LineCI
   end if
   if (allocated(SrcParamData%LineCD)) then
      LB(1:1) = lbound(SrcParamData%LineCD)
      UB(1:1) = ubound(SrcParamData%LineCD)
      if (.not. allocated(DstParamData%LineCD)) then
         allocate(DstParamData%LineCD(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%LineCD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%LineCD = SrcParamData%LineCD
   end if
   if (allocated(SrcParamData%Bvp)) then
      LB(1:2) = lbound(SrcParamData%Bvp)
      UB(1:2) = ubound(SrcParamData%Bvp)
      if (.not. allocated(DstParamData%Bvp)) then
         allocate(DstParamData%Bvp(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Bvp.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Bvp = SrcParamData%Bvp
   end if
   if (allocated(SrcParamData%WaveAcc0)) then
      LB(1:3) = lbound(SrcParamData%WaveAcc0)
      UB(1:3) = ubound(SrcParamData%WaveAcc0)
      if (.not. allocated(DstParamData%WaveAcc0)) then
         allocate(DstParamData%WaveAcc0(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%WaveAcc0.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%WaveAcc0 = SrcParamData%WaveAcc0
   end if
   if (allocated(SrcParamData%WaveTime)) then
      LB(1:1) = lbound(SrcParamData%WaveTime)
      UB(1:1) = ubound(SrcParamData%WaveTime)
      if (.not. allocated(DstParamData%WaveTime)) then
         allocate(DstParamData%WaveTime(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%WaveTime.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%WaveTime = SrcParamData%WaveTime
   end if
   if (allocated(SrcParamData%WaveVel0)) then
      LB(1:3) = lbound(SrcParamData%WaveVel0)
      UB(1:3) = ubound(SrcParamData%WaveVel0)
      if (.not. allocated(DstParamData%WaveVel0)) then
         allocate(DstParamData%WaveVel0(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%WaveVel0.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%WaveVel0 = SrcParamData%WaveVel0
   end if
   DstParamData%NStepWave = SrcParamData%NStepWave
   DstParamData%SHAP = SrcParamData%SHAP
   DstParamData%SHAPS = SrcParamData%SHAPS
   DstParamData%GAUSSW = SrcParamData%GAUSSW
   DstParamData%NGAUSS = SrcParamData%NGAUSS
   DstParamData%SHAPT = SrcParamData%SHAPT
   DstParamData%SHAPTS = SrcParamData%SHAPTS
   DstParamData%NTRAP = SrcParamData%NTRAP
   DstParamData%SBEND = SrcParamData%SBEND
   DstParamData%STEN = SrcParamData%STEN
   DstParamData%RMASS = SrcParamData%RMASS
   DstParamData%RADDM = SrcParamData%RADDM
   DstParamData%PMPN = SrcParamData%PMPN
   DstParamData%AM = SrcParamData%AM
   DstParamData%PM = SrcParamData%PM
   DstParamData%IDOF = SrcParamData%IDOF
   DstParamData%JDOF = SrcParamData%JDOF
   DstParamData%PPA = SrcParamData%PPA
   DstParamData%PtfmRefzt = SrcParamData%PtfmRefzt
   DstParamData%NumOuts = SrcParamData%NumOuts
   DstParamData%RootName = SrcParamData%RootName
   if (allocated(SrcParamData%OutParam)) then
      LB(1:1) = lbound(SrcParamData%OutParam)
      UB(1:1) = ubound(SrcParamData%OutParam)
      if (.not. allocated(DstParamData%OutParam)) then
         allocate(DstParamData%OutParam(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%OutParam.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyOutParmType(SrcParamData%OutParam(i1), DstParamData%OutParam(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstParamData%Delim = SrcParamData%Delim
   if (allocated(SrcParamData%GLUZR)) then
      LB(1:3) = lbound(SrcParamData%GLUZR)
      UB(1:3) = ubound(SrcParamData%GLUZR)
      if (.not. allocated(DstParamData%GLUZR)) then
         allocate(DstParamData%GLUZR(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%GLUZR.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%GLUZR = SrcParamData%GLUZR
   end if
   if (allocated(SrcParamData%GTZER)) then
      LB(1:2) = lbound(SrcParamData%GTZER)
      UB(1:2) = ubound(SrcParamData%GTZER)
      if (.not. allocated(DstParamData%GTZER)) then
         allocate(DstParamData%GTZER(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%GTZER.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%GTZER = SrcParamData%GTZER
   end if
end subroutine

subroutine FEAM_DestroyParam(ParamData, ErrStat, ErrMsg)
   type(FEAM_ParameterType), intent(inout) :: ParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2, i3, i4
   integer(B4Ki)   :: LB(4), UB(4)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FEAM_DestroyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ParamData%NEQ)) then
      deallocate(ParamData%NEQ)
   end if
   if (allocated(ParamData%GSL)) then
      deallocate(ParamData%GSL)
   end if
   if (allocated(ParamData%GP)) then
      deallocate(ParamData%GP)
   end if
   if (allocated(ParamData%Elength)) then
      deallocate(ParamData%Elength)
   end if
   if (allocated(ParamData%BottmElev)) then
      deallocate(ParamData%BottmElev)
   end if
   if (allocated(ParamData%BottmStiff)) then
      deallocate(ParamData%BottmStiff)
   end if
   if (allocated(ParamData%LMassDen)) then
      deallocate(ParamData%LMassDen)
   end if
   if (allocated(ParamData%LDMassDen)) then
      deallocate(ParamData%LDMassDen)
   end if
   if (allocated(ParamData%LEAStiff)) then
      deallocate(ParamData%LEAStiff)
   end if
   if (allocated(ParamData%LineCI)) then
      deallocate(ParamData%LineCI)
   end if
   if (allocated(ParamData%LineCD)) then
      deallocate(ParamData%LineCD)
   end if
   if (allocated(ParamData%Bvp)) then
      deallocate(ParamData%Bvp)
   end if
   if (allocated(ParamData%WaveAcc0)) then
      deallocate(ParamData%WaveAcc0)
   end if
   if (allocated(ParamData%WaveTime)) then
      deallocate(ParamData%WaveTime)
   end if
   if (allocated(ParamData%WaveVel0)) then
      deallocate(ParamData%WaveVel0)
   end if
   if (allocated(ParamData%OutParam)) then
      LB(1:1) = lbound(ParamData%OutParam)
      UB(1:1) = ubound(ParamData%OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyOutParmType(ParamData%OutParam(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%OutParam)
   end if
   if (allocated(ParamData%GLUZR)) then
      deallocate(ParamData%GLUZR)
   end if
   if (allocated(ParamData%GTZER)) then
      deallocate(ParamData%GTZER)
   end if
end subroutine

subroutine FEAM_PackParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FEAM_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FEAM_PackParam'
   integer(B4Ki)   :: i1, i2, i3, i4
   integer(B4Ki)   :: LB(4), UB(4)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DT)
   call RegPack(RF, InData%GRAV)
   call RegPack(RF, InData%Eps)
   call RegPack(RF, InData%Gravity)
   call RegPack(RF, InData%WtrDens)
   call RegPack(RF, InData%MaxIter)
   call RegPack(RF, InData%NHBD)
   call RegPack(RF, InData%NDIM)
   call RegPackAlloc(RF, InData%NEQ)
   call RegPack(RF, InData%NBAND)
   call RegPack(RF, InData%NumLines)
   call RegPack(RF, InData%NumElems)
   call RegPack(RF, InData%NumNodes)
   call RegPackAlloc(RF, InData%GSL)
   call RegPackAlloc(RF, InData%GP)
   call RegPackAlloc(RF, InData%Elength)
   call RegPackAlloc(RF, InData%BottmElev)
   call RegPackAlloc(RF, InData%BottmStiff)
   call RegPackAlloc(RF, InData%LMassDen)
   call RegPackAlloc(RF, InData%LDMassDen)
   call RegPackAlloc(RF, InData%LEAStiff)
   call RegPackAlloc(RF, InData%LineCI)
   call RegPackAlloc(RF, InData%LineCD)
   call RegPackAlloc(RF, InData%Bvp)
   call RegPackAlloc(RF, InData%WaveAcc0)
   call RegPackAlloc(RF, InData%WaveTime)
   call RegPackAlloc(RF, InData%WaveVel0)
   call RegPack(RF, InData%NStepWave)
   call RegPack(RF, InData%SHAP)
   call RegPack(RF, InData%SHAPS)
   call RegPack(RF, InData%GAUSSW)
   call RegPack(RF, InData%NGAUSS)
   call RegPack(RF, InData%SHAPT)
   call RegPack(RF, InData%SHAPTS)
   call RegPack(RF, InData%NTRAP)
   call RegPack(RF, InData%SBEND)
   call RegPack(RF, InData%STEN)
   call RegPack(RF, InData%RMASS)
   call RegPack(RF, InData%RADDM)
   call RegPack(RF, InData%PMPN)
   call RegPack(RF, InData%AM)
   call RegPack(RF, InData%PM)
   call RegPack(RF, InData%IDOF)
   call RegPack(RF, InData%JDOF)
   call RegPack(RF, InData%PPA)
   call RegPack(RF, InData%PtfmRefzt)
   call RegPack(RF, InData%NumOuts)
   call RegPack(RF, InData%RootName)
   call RegPack(RF, allocated(InData%OutParam))
   if (allocated(InData%OutParam)) then
      call RegPackBounds(RF, 1, lbound(InData%OutParam), ubound(InData%OutParam))
      LB(1:1) = lbound(InData%OutParam)
      UB(1:1) = ubound(InData%OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackOutParmType(RF, InData%OutParam(i1)) 
      end do
   end if
   call RegPack(RF, InData%Delim)
   call RegPackAlloc(RF, InData%GLUZR)
   call RegPackAlloc(RF, InData%GTZER)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FEAM_UnPackParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FEAM_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FEAM_UnPackParam'
   integer(B4Ki)   :: i1, i2, i3, i4
   integer(B4Ki)   :: LB(4), UB(4)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GRAV); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Eps); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Gravity); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WtrDens); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MaxIter); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NHBD); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NDIM); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%NEQ); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NBAND); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumLines); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumElems); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumNodes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%GSL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%GP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Elength); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BottmElev); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BottmStiff); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LMassDen); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LDMassDen); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LEAStiff); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LineCI); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LineCD); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Bvp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WaveAcc0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WaveTime); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WaveVel0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NStepWave); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SHAP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SHAPS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GAUSSW); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NGAUSS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SHAPT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SHAPTS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NTRAP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SBEND); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%STEN); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RMASS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RADDM); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PMPN); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AM); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PM); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%IDOF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%JDOF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PPA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmRefzt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootName); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%OutParam)) deallocate(OutData%OutParam)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%OutParam(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%OutParam.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackOutParmType(RF, OutData%OutParam(i1)) ! OutParam 
      end do
   end if
   call RegUnpack(RF, OutData%Delim); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%GLUZR); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%GTZER); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FEAM_CopyInput(SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg)
   type(FEAM_InputType), intent(inout) :: SrcInputData
   type(FEAM_InputType), intent(inout) :: DstInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FEAM_CopyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshCopy(SrcInputData%HydroForceLineMesh, DstInputData%HydroForceLineMesh, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcInputData%PtFairleadDisplacement, DstInputData%PtFairleadDisplacement, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine FEAM_DestroyInput(InputData, ErrStat, ErrMsg)
   type(FEAM_InputType), intent(inout) :: InputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FEAM_DestroyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshDestroy( InputData%HydroForceLineMesh, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( InputData%PtFairleadDisplacement, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine FEAM_PackInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FEAM_InputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FEAM_PackInput'
   if (RF%ErrStat >= AbortErrLev) return
   call MeshPack(RF, InData%HydroForceLineMesh) 
   call MeshPack(RF, InData%PtFairleadDisplacement) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FEAM_UnPackInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FEAM_InputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FEAM_UnPackInput'
   if (RF%ErrStat /= ErrID_None) return
   call MeshUnpack(RF, OutData%HydroForceLineMesh) ! HydroForceLineMesh 
   call MeshUnpack(RF, OutData%PtFairleadDisplacement) ! PtFairleadDisplacement 
end subroutine

subroutine FEAM_CopyOutput(SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg)
   type(FEAM_OutputType), intent(inout) :: SrcOutputData
   type(FEAM_OutputType), intent(inout) :: DstOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FEAM_CopyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcOutputData%WriteOutput)) then
      LB(1:1) = lbound(SrcOutputData%WriteOutput)
      UB(1:1) = ubound(SrcOutputData%WriteOutput)
      if (.not. allocated(DstOutputData%WriteOutput)) then
         allocate(DstOutputData%WriteOutput(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%WriteOutput.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%WriteOutput = SrcOutputData%WriteOutput
   end if
   call MeshCopy(SrcOutputData%PtFairleadLoad, DstOutputData%PtFairleadLoad, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcOutputData%LineMeshPosition, DstOutputData%LineMeshPosition, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine FEAM_DestroyOutput(OutputData, ErrStat, ErrMsg)
   type(FEAM_OutputType), intent(inout) :: OutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FEAM_DestroyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(OutputData%WriteOutput)) then
      deallocate(OutputData%WriteOutput)
   end if
   call MeshDestroy( OutputData%PtFairleadLoad, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( OutputData%LineMeshPosition, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine FEAM_PackOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FEAM_OutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FEAM_PackOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%WriteOutput)
   call MeshPack(RF, InData%PtFairleadLoad) 
   call MeshPack(RF, InData%LineMeshPosition) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FEAM_UnPackOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FEAM_OutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FEAM_UnPackOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%WriteOutput); if (RegCheckErr(RF, RoutineName)) return
   call MeshUnpack(RF, OutData%PtFairleadLoad) ! PtFairleadLoad 
   call MeshUnpack(RF, OutData%LineMeshPosition) ! LineMeshPosition 
end subroutine

subroutine FEAM_Input_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
   ! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(FEAM_InputType), intent(inout)  :: u(:) ! Input at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Inputs
   type(FEAM_InputType), intent(inout)  :: u_out ! Input at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'FEAM_Input_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(u)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(u)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(u) - 1
   select case (order)
   case (0)
      call FEAM_CopyInput(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call FEAM_Input_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call FEAM_Input_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(u) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE FEAM_Input_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

   TYPE(FEAM_InputType), INTENT(INOUT)  :: u1    ! Input at t1 > t2
   TYPE(FEAM_InputType), INTENT(INOUT)  :: u2    ! Input at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Inputs
   TYPE(FEAM_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'FEAM_Input_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   CALL MeshExtrapInterp1(u1%HydroForceLineMesh, u2%HydroForceLineMesh, tin, u_out%HydroForceLineMesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp1(u1%PtFairleadDisplacement, u2%PtFairleadDisplacement, tin, u_out%PtFairleadDisplacement, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
END SUBROUTINE

SUBROUTINE FEAM_Input_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

   TYPE(FEAM_InputType), INTENT(INOUT)  :: u1      ! Input at t1 > t2 > t3
   TYPE(FEAM_InputType), INTENT(INOUT)  :: u2      ! Input at t2 > t3
   TYPE(FEAM_InputType), INTENT(INOUT)  :: u3      ! Input at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Inputs
   TYPE(FEAM_InputType), INTENT(INOUT)  :: u_out     ! Input at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'FEAM_Input_ExtrapInterp2'
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   CALL MeshExtrapInterp2(u1%HydroForceLineMesh, u2%HydroForceLineMesh, u3%HydroForceLineMesh, tin, u_out%HydroForceLineMesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp2(u1%PtFairleadDisplacement, u2%PtFairleadDisplacement, u3%PtFairleadDisplacement, tin, u_out%PtFairleadDisplacement, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
END SUBROUTINE

subroutine FEAM_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
   ! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(FEAM_OutputType), intent(inout)  :: y(:) ! Output at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Outputs
   type(FEAM_OutputType), intent(inout)  :: y_out ! Output at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'FEAM_Output_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(y)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(y)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(y) - 1
   select case (order)
   case (0)
      call FEAM_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call FEAM_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call FEAM_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(y) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE FEAM_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

   TYPE(FEAM_OutputType), INTENT(INOUT)  :: y1    ! Output at t1 > t2
   TYPE(FEAM_OutputType), INTENT(INOUT)  :: y2    ! Output at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
   TYPE(FEAM_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'FEAM_Output_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
      y_out%WriteOutput = a1*y1%WriteOutput + a2*y2%WriteOutput
   END IF ! check if allocated
   CALL MeshExtrapInterp1(y1%PtFairleadLoad, y2%PtFairleadLoad, tin, y_out%PtFairleadLoad, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp1(y1%LineMeshPosition, y2%LineMeshPosition, tin, y_out%LineMeshPosition, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
END SUBROUTINE

SUBROUTINE FEAM_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

   TYPE(FEAM_OutputType), INTENT(INOUT)  :: y1      ! Output at t1 > t2 > t3
   TYPE(FEAM_OutputType), INTENT(INOUT)  :: y2      ! Output at t2 > t3
   TYPE(FEAM_OutputType), INTENT(INOUT)  :: y3      ! Output at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
   TYPE(FEAM_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'FEAM_Output_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
      y_out%WriteOutput = a1*y1%WriteOutput + a2*y2%WriteOutput + a3*y3%WriteOutput
   END IF ! check if allocated
   CALL MeshExtrapInterp2(y1%PtFairleadLoad, y2%PtFairleadLoad, y3%PtFairleadLoad, tin, y_out%PtFairleadLoad, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp2(y1%LineMeshPosition, y2%LineMeshPosition, y3%LineMeshPosition, tin, y_out%LineMeshPosition, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
END SUBROUTINE
END MODULE FEAMooring_Types
!ENDOFREGISTRYGENERATEDFILE
