!STARTOFREGISTRYGENERATEDFILE 'ExtPtfm_MCKF_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! ExtPtfm_MCKF_Types
!.................................................................................................................................
! This file is part of ExtPtfm_MCKF.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in ExtPtfm_MCKF. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE ExtPtfm_MCKF_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE NWTC_Library
IMPLICIT NONE
! =========  ExtPtfm_InitInputType  =======
  TYPE, PUBLIC :: ExtPtfm_InitInputType
    CHARACTER(1024)  :: InputFile      !< Name of the input file; remove if there is no file [-]
    LOGICAL  :: Linearize = .FALSE.      !< Flag that tells this module if the glue code wants to linearize. [-]
    REAL(ReKi)  :: PtfmRefzt = 0.0_ReKi      !< Vertical distance from the ground level [onshore], MSL [offshore wind or floating MHK], or seabed [fixed MHK] to the platform reference point [meters]
    CHARACTER(1024)  :: RootName      !< RootName for writing output files [-]
  END TYPE ExtPtfm_InitInputType
! =======================
! =========  ExtPtfm_InputFile  =======
  TYPE, PUBLIC :: ExtPtfm_InputFile
    REAL(DbKi)  :: DT = 0.0_R8Ki      !< Requested integration time for ElastoDyn [seconds]
    INTEGER(IntKi)  :: IntMethod = 0_IntKi      !< Integration Method (1=RK4, 2=AB4, 3=ABM4) [-]
    INTEGER(IntKi)  :: FileFormat = 0_IntKi      !< File format switch [-]
    CHARACTER(1024)  :: RedFile      !< File containing reduction inputs [-]
    CHARACTER(1024)  :: RedFileCst      !< File containing constant reduction inputs [-]
    LOGICAL  :: EquilStart = .false.      !< Flag to determine the equilibrium positions of the CB modes at initialization (first call) [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: ActiveCBDOF      !< List of active CB DOF [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: InitPosList      !< Initial positions of the CB DOFs [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: InitVelList      !< Initial velocities of the CB DOFs [-]
    LOGICAL  :: SumPrint = .false.      !< Print summary data to <RootName>.sum [-]
    INTEGER(IntKi)  :: OutFile = 0_IntKi      !< Switch to determine where output will be placed: (1: in module output file only; 2: in glue code output file only; 3: both) [-]
    LOGICAL  :: TabDelim = .false.      !< Flag to cause tab-delimited text output (delimited by space otherwise) [-]
    CHARACTER(20)  :: OutFmt      !< Format used for module's text tabular output (except time); resulting field should be 10 characters [-]
    REAL(DbKi)  :: Tstart = 0.0_R8Ki      !< Time to start module's tabular output [seconds]
    INTEGER(IntKi)  :: NumOuts = 0_IntKi      !< Number of parameters in the output list (number of outputs requested) [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: OutList      !< List of user-requested output channels [-]
  END TYPE ExtPtfm_InputFile
! =======================
! =========  ExtPtfm_InitOutputType  =======
  TYPE, PUBLIC :: ExtPtfm_InitOutputType
    TYPE(ProgDesc)  :: Ver      !< This module's name, version, and date [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputHdr      !< Names of the output-to-file channels [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputUnt      !< Units of the output-to-file channels [-]
    CHARACTER(LinChanLen) , DIMENSION(:), ALLOCATABLE  :: LinNames_y      !< Names of the outputs used in linearization [-]
    CHARACTER(LinChanLen) , DIMENSION(:), ALLOCATABLE  :: LinNames_x      !< Names of the continuous states used in linearization [-]
    CHARACTER(LinChanLen) , DIMENSION(:), ALLOCATABLE  :: LinNames_u      !< Names of the inputs used in linearization [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: RotFrame_y      !< Flag that tells FAST/MBC3 if the outputs used in linearization are in the rotating frame [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: RotFrame_x      !< Flag that tells FAST/MBC3 if the continuous states used in linearization are in the rotating frame [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: RotFrame_u      !< Flag that tells FAST/MBC3 if the inputs used in linearization are in the rotating frame [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: IsLoad_u      !< Flag that tells FAST if the inputs used in linearization are loads (for preconditioning matrix) [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: DerivOrder_x      !< Integer that tells FAST/MBC3 the maximum derivative order of continuous states used in linearization [-]
  END TYPE ExtPtfm_InitOutputType
! =======================
! =========  ExtPtfm_ContinuousStateType  =======
  TYPE, PUBLIC :: ExtPtfm_ContinuousStateType
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: qm      !< Internal CraigBampton positions [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: qmdot      !< Internal CraigBampton velocities [-]
  END TYPE ExtPtfm_ContinuousStateType
! =======================
! =========  ExtPtfm_DiscreteStateType  =======
  TYPE, PUBLIC :: ExtPtfm_DiscreteStateType
    REAL(ReKi)  :: DummyDiscState = 0.0_ReKi      !< Remove this variable if you have discrete states [-]
  END TYPE ExtPtfm_DiscreteStateType
! =======================
! =========  ExtPtfm_ConstraintStateType  =======
  TYPE, PUBLIC :: ExtPtfm_ConstraintStateType
    REAL(ReKi)  :: DummyConstrState = 0.0_ReKi      !< Remove this variable if you have constraint states [-]
  END TYPE ExtPtfm_ConstraintStateType
! =======================
! =========  ExtPtfm_OtherStateType  =======
  TYPE, PUBLIC :: ExtPtfm_OtherStateType
    TYPE(ExtPtfm_ContinuousStateType) , DIMENSION(:), ALLOCATABLE  :: xdot      !< Previous state derivs for m-step time integrator [-]
    INTEGER(IntKi)  :: n = 0_IntKi      !< Tracks time step for which OtherState was updated last [-]
  END TYPE ExtPtfm_OtherStateType
! =======================
! =========  ExtPtfm_MiscVarType  =======
  TYPE, PUBLIC :: ExtPtfm_MiscVarType
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: xFlat      !< Flattened vector of states [-]
    REAL(ReKi) , DIMENSION(1:18)  :: uFlat = 0.0_ReKi      !< Flattened vector of inputs [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: F_at_t      !< The 6 interface loads and Craig-Bampton loads at t (force and moment acting at the platform reference (no added-mass effects); positive forces are in the direction of motion). [N, N-m]
    INTEGER(IntKi)  :: Indx = 0_IntKi      !< Index into times, to speed up interpolation [-]
    LOGICAL  :: EquilStart = .false.      !< Flag to determine the equilibrium position of the CB DOF at initialization (first call) [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: AllOuts      !< An array holding the value of all of the calculated (not only selected) output channels [see OutListParameters.xlsx spreadsheet]
  END TYPE ExtPtfm_MiscVarType
! =======================
! =========  ExtPtfm_ParameterType  =======
  TYPE, PUBLIC :: ExtPtfm_ParameterType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Mass      !< Mass matrix [kg, kg-m, kg-m^2]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Damp      !< Damping matrix [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Stff      !< Stiffness matrix [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Forces      !< Prescribed reduced loads, the 3 platform forces (in N) and moments (Nm) acting at the platform reference, associated with everything but the added-mass effects; positive forces are in the direction of motion. [N, N-m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: times      !< the time associated with each row of Forces [s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: AMat      !< State matrix A []
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: BMat      !< State matrix B []
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: CMat      !< State matrix C []
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: DMat      !< State matrix D []
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: FX      !< State  constant Fx []
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: FY      !< Output constant Fy []
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: M11      !< Matrix M11 []
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: M12      !< Matrix M12 []
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: M22      !< Matrix M22 []
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: M21      !< Matrix M21 []
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: K11      !< Matrix K11 []
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: K22      !< Matrix K22 []
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: C11      !< Matrix C11 []
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: C12      !< Matrix C12 []
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: C22      !< Matrix C22 []
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: C21      !< Matrix C21 []
    REAL(DbKi)  :: EP_DeltaT = 0.0_R8Ki      !< Time step (for integration of continuous states) [seconds]
    INTEGER(IntKi)  :: nTimeSteps = 0_IntKi      !< Number of values of Forces and times [-]
    INTEGER(IntKi)  :: nCB = 0_IntKi      !< Number of CraigBampton modes active [-]
    INTEGER(IntKi)  :: nCBFull = 0_IntKi      !< Totla number of CraigBampton modes given as input [-]
    INTEGER(IntKi)  :: nTot = 0_IntKi      !< Total number of debrees of freedom (CB + interface) [-]
    INTEGER(IntKi)  :: NumOuts = 0_IntKi      !< Number of values in WriteOutput [-]
    INTEGER(IntKi)  :: IntMethod = 0_IntKi      !< Integration Method (1=RK4, 2=AB4, 3=ABM4) [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: ActiveCBDOF      !< List of active CB DOF [-]
    TYPE(OutParmType) , DIMENSION(:), ALLOCATABLE  :: OutParam      !< Names and units (and other characteristics) of all requested output parameters [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: OutParamLinIndx      !< Index into WriteOutput for linearization analysis [-]
  END TYPE ExtPtfm_ParameterType
! =======================
! =========  ExtPtfm_InputType  =======
  TYPE, PUBLIC :: ExtPtfm_InputType
    TYPE(MeshType)  :: PtfmMesh      !< Displacements at the platform reference point [-]
  END TYPE ExtPtfm_InputType
! =======================
! =========  ExtPtfm_OutputType  =======
  TYPE, PUBLIC :: ExtPtfm_OutputType
    TYPE(MeshType)  :: PtfmMesh      !< Loads at the platform reference point [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WriteOutput      !< Example of data to be written to an output file [s,-]
  END TYPE ExtPtfm_OutputType
! =======================
CONTAINS

subroutine ExtPtfm_CopyInitInput(SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg)
   type(ExtPtfm_InitInputType), intent(in) :: SrcInitInputData
   type(ExtPtfm_InitInputType), intent(inout) :: DstInitInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ExtPtfm_CopyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInitInputData%InputFile = SrcInitInputData%InputFile
   DstInitInputData%Linearize = SrcInitInputData%Linearize
   DstInitInputData%PtfmRefzt = SrcInitInputData%PtfmRefzt
   DstInitInputData%RootName = SrcInitInputData%RootName
end subroutine

subroutine ExtPtfm_DestroyInitInput(InitInputData, ErrStat, ErrMsg)
   type(ExtPtfm_InitInputType), intent(inout) :: InitInputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ExtPtfm_DestroyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine ExtPtfm_PackInitInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ExtPtfm_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ExtPtfm_PackInitInput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%InputFile)
   call RegPack(RF, InData%Linearize)
   call RegPack(RF, InData%PtfmRefzt)
   call RegPack(RF, InData%RootName)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtPtfm_UnPackInitInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ExtPtfm_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ExtPtfm_UnPackInitInput'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%InputFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Linearize); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmRefzt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootName); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtPtfm_CopyInputFile(SrcInputFileData, DstInputFileData, CtrlCode, ErrStat, ErrMsg)
   type(ExtPtfm_InputFile), intent(in) :: SrcInputFileData
   type(ExtPtfm_InputFile), intent(inout) :: DstInputFileData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'ExtPtfm_CopyInputFile'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInputFileData%DT = SrcInputFileData%DT
   DstInputFileData%IntMethod = SrcInputFileData%IntMethod
   DstInputFileData%FileFormat = SrcInputFileData%FileFormat
   DstInputFileData%RedFile = SrcInputFileData%RedFile
   DstInputFileData%RedFileCst = SrcInputFileData%RedFileCst
   DstInputFileData%EquilStart = SrcInputFileData%EquilStart
   if (allocated(SrcInputFileData%ActiveCBDOF)) then
      LB(1:1) = lbound(SrcInputFileData%ActiveCBDOF)
      UB(1:1) = ubound(SrcInputFileData%ActiveCBDOF)
      if (.not. allocated(DstInputFileData%ActiveCBDOF)) then
         allocate(DstInputFileData%ActiveCBDOF(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%ActiveCBDOF.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%ActiveCBDOF = SrcInputFileData%ActiveCBDOF
   end if
   if (allocated(SrcInputFileData%InitPosList)) then
      LB(1:1) = lbound(SrcInputFileData%InitPosList)
      UB(1:1) = ubound(SrcInputFileData%InitPosList)
      if (.not. allocated(DstInputFileData%InitPosList)) then
         allocate(DstInputFileData%InitPosList(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%InitPosList.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%InitPosList = SrcInputFileData%InitPosList
   end if
   if (allocated(SrcInputFileData%InitVelList)) then
      LB(1:1) = lbound(SrcInputFileData%InitVelList)
      UB(1:1) = ubound(SrcInputFileData%InitVelList)
      if (.not. allocated(DstInputFileData%InitVelList)) then
         allocate(DstInputFileData%InitVelList(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%InitVelList.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%InitVelList = SrcInputFileData%InitVelList
   end if
   DstInputFileData%SumPrint = SrcInputFileData%SumPrint
   DstInputFileData%OutFile = SrcInputFileData%OutFile
   DstInputFileData%TabDelim = SrcInputFileData%TabDelim
   DstInputFileData%OutFmt = SrcInputFileData%OutFmt
   DstInputFileData%Tstart = SrcInputFileData%Tstart
   DstInputFileData%NumOuts = SrcInputFileData%NumOuts
   if (allocated(SrcInputFileData%OutList)) then
      LB(1:1) = lbound(SrcInputFileData%OutList)
      UB(1:1) = ubound(SrcInputFileData%OutList)
      if (.not. allocated(DstInputFileData%OutList)) then
         allocate(DstInputFileData%OutList(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%OutList.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%OutList = SrcInputFileData%OutList
   end if
end subroutine

subroutine ExtPtfm_DestroyInputFile(InputFileData, ErrStat, ErrMsg)
   type(ExtPtfm_InputFile), intent(inout) :: InputFileData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ExtPtfm_DestroyInputFile'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InputFileData%ActiveCBDOF)) then
      deallocate(InputFileData%ActiveCBDOF)
   end if
   if (allocated(InputFileData%InitPosList)) then
      deallocate(InputFileData%InitPosList)
   end if
   if (allocated(InputFileData%InitVelList)) then
      deallocate(InputFileData%InitVelList)
   end if
   if (allocated(InputFileData%OutList)) then
      deallocate(InputFileData%OutList)
   end if
end subroutine

subroutine ExtPtfm_PackInputFile(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ExtPtfm_InputFile), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ExtPtfm_PackInputFile'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DT)
   call RegPack(RF, InData%IntMethod)
   call RegPack(RF, InData%FileFormat)
   call RegPack(RF, InData%RedFile)
   call RegPack(RF, InData%RedFileCst)
   call RegPack(RF, InData%EquilStart)
   call RegPackAlloc(RF, InData%ActiveCBDOF)
   call RegPackAlloc(RF, InData%InitPosList)
   call RegPackAlloc(RF, InData%InitVelList)
   call RegPack(RF, InData%SumPrint)
   call RegPack(RF, InData%OutFile)
   call RegPack(RF, InData%TabDelim)
   call RegPack(RF, InData%OutFmt)
   call RegPack(RF, InData%Tstart)
   call RegPack(RF, InData%NumOuts)
   call RegPackAlloc(RF, InData%OutList)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtPtfm_UnPackInputFile(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ExtPtfm_InputFile), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ExtPtfm_UnPackInputFile'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%IntMethod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FileFormat); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RedFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RedFileCst); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%EquilStart); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%ActiveCBDOF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%InitPosList); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%InitVelList); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SumPrint); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TabDelim); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutFmt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Tstart); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%OutList); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtPtfm_CopyInitOutput(SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg)
   type(ExtPtfm_InitOutputType), intent(in) :: SrcInitOutputData
   type(ExtPtfm_InitOutputType), intent(inout) :: DstInitOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ExtPtfm_CopyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call NWTC_Library_CopyProgDesc(SrcInitOutputData%Ver, DstInitOutputData%Ver, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcInitOutputData%WriteOutputHdr)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputHdr)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputHdr)
      if (.not. allocated(DstInitOutputData%WriteOutputHdr)) then
         allocate(DstInitOutputData%WriteOutputHdr(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputHdr.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputHdr = SrcInitOutputData%WriteOutputHdr
   end if
   if (allocated(SrcInitOutputData%WriteOutputUnt)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputUnt)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputUnt)
      if (.not. allocated(DstInitOutputData%WriteOutputUnt)) then
         allocate(DstInitOutputData%WriteOutputUnt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputUnt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputUnt = SrcInitOutputData%WriteOutputUnt
   end if
   if (allocated(SrcInitOutputData%LinNames_y)) then
      LB(1:1) = lbound(SrcInitOutputData%LinNames_y)
      UB(1:1) = ubound(SrcInitOutputData%LinNames_y)
      if (.not. allocated(DstInitOutputData%LinNames_y)) then
         allocate(DstInitOutputData%LinNames_y(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LinNames_y.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%LinNames_y = SrcInitOutputData%LinNames_y
   end if
   if (allocated(SrcInitOutputData%LinNames_x)) then
      LB(1:1) = lbound(SrcInitOutputData%LinNames_x)
      UB(1:1) = ubound(SrcInitOutputData%LinNames_x)
      if (.not. allocated(DstInitOutputData%LinNames_x)) then
         allocate(DstInitOutputData%LinNames_x(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LinNames_x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%LinNames_x = SrcInitOutputData%LinNames_x
   end if
   if (allocated(SrcInitOutputData%LinNames_u)) then
      LB(1:1) = lbound(SrcInitOutputData%LinNames_u)
      UB(1:1) = ubound(SrcInitOutputData%LinNames_u)
      if (.not. allocated(DstInitOutputData%LinNames_u)) then
         allocate(DstInitOutputData%LinNames_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LinNames_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%LinNames_u = SrcInitOutputData%LinNames_u
   end if
   if (allocated(SrcInitOutputData%RotFrame_y)) then
      LB(1:1) = lbound(SrcInitOutputData%RotFrame_y)
      UB(1:1) = ubound(SrcInitOutputData%RotFrame_y)
      if (.not. allocated(DstInitOutputData%RotFrame_y)) then
         allocate(DstInitOutputData%RotFrame_y(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%RotFrame_y.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%RotFrame_y = SrcInitOutputData%RotFrame_y
   end if
   if (allocated(SrcInitOutputData%RotFrame_x)) then
      LB(1:1) = lbound(SrcInitOutputData%RotFrame_x)
      UB(1:1) = ubound(SrcInitOutputData%RotFrame_x)
      if (.not. allocated(DstInitOutputData%RotFrame_x)) then
         allocate(DstInitOutputData%RotFrame_x(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%RotFrame_x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%RotFrame_x = SrcInitOutputData%RotFrame_x
   end if
   if (allocated(SrcInitOutputData%RotFrame_u)) then
      LB(1:1) = lbound(SrcInitOutputData%RotFrame_u)
      UB(1:1) = ubound(SrcInitOutputData%RotFrame_u)
      if (.not. allocated(DstInitOutputData%RotFrame_u)) then
         allocate(DstInitOutputData%RotFrame_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%RotFrame_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%RotFrame_u = SrcInitOutputData%RotFrame_u
   end if
   if (allocated(SrcInitOutputData%IsLoad_u)) then
      LB(1:1) = lbound(SrcInitOutputData%IsLoad_u)
      UB(1:1) = ubound(SrcInitOutputData%IsLoad_u)
      if (.not. allocated(DstInitOutputData%IsLoad_u)) then
         allocate(DstInitOutputData%IsLoad_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%IsLoad_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%IsLoad_u = SrcInitOutputData%IsLoad_u
   end if
   if (allocated(SrcInitOutputData%DerivOrder_x)) then
      LB(1:1) = lbound(SrcInitOutputData%DerivOrder_x)
      UB(1:1) = ubound(SrcInitOutputData%DerivOrder_x)
      if (.not. allocated(DstInitOutputData%DerivOrder_x)) then
         allocate(DstInitOutputData%DerivOrder_x(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%DerivOrder_x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%DerivOrder_x = SrcInitOutputData%DerivOrder_x
   end if
end subroutine

subroutine ExtPtfm_DestroyInitOutput(InitOutputData, ErrStat, ErrMsg)
   type(ExtPtfm_InitOutputType), intent(inout) :: InitOutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ExtPtfm_DestroyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call NWTC_Library_DestroyProgDesc(InitOutputData%Ver, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(InitOutputData%WriteOutputHdr)) then
      deallocate(InitOutputData%WriteOutputHdr)
   end if
   if (allocated(InitOutputData%WriteOutputUnt)) then
      deallocate(InitOutputData%WriteOutputUnt)
   end if
   if (allocated(InitOutputData%LinNames_y)) then
      deallocate(InitOutputData%LinNames_y)
   end if
   if (allocated(InitOutputData%LinNames_x)) then
      deallocate(InitOutputData%LinNames_x)
   end if
   if (allocated(InitOutputData%LinNames_u)) then
      deallocate(InitOutputData%LinNames_u)
   end if
   if (allocated(InitOutputData%RotFrame_y)) then
      deallocate(InitOutputData%RotFrame_y)
   end if
   if (allocated(InitOutputData%RotFrame_x)) then
      deallocate(InitOutputData%RotFrame_x)
   end if
   if (allocated(InitOutputData%RotFrame_u)) then
      deallocate(InitOutputData%RotFrame_u)
   end if
   if (allocated(InitOutputData%IsLoad_u)) then
      deallocate(InitOutputData%IsLoad_u)
   end if
   if (allocated(InitOutputData%DerivOrder_x)) then
      deallocate(InitOutputData%DerivOrder_x)
   end if
end subroutine

subroutine ExtPtfm_PackInitOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ExtPtfm_InitOutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ExtPtfm_PackInitOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call NWTC_Library_PackProgDesc(RF, InData%Ver) 
   call RegPackAlloc(RF, InData%WriteOutputHdr)
   call RegPackAlloc(RF, InData%WriteOutputUnt)
   call RegPackAlloc(RF, InData%LinNames_y)
   call RegPackAlloc(RF, InData%LinNames_x)
   call RegPackAlloc(RF, InData%LinNames_u)
   call RegPackAlloc(RF, InData%RotFrame_y)
   call RegPackAlloc(RF, InData%RotFrame_x)
   call RegPackAlloc(RF, InData%RotFrame_u)
   call RegPackAlloc(RF, InData%IsLoad_u)
   call RegPackAlloc(RF, InData%DerivOrder_x)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtPtfm_UnPackInitOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ExtPtfm_InitOutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ExtPtfm_UnPackInitOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call NWTC_Library_UnpackProgDesc(RF, OutData%Ver) ! Ver 
   call RegUnpackAlloc(RF, OutData%WriteOutputHdr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutputUnt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LinNames_y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LinNames_x); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LinNames_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RotFrame_y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RotFrame_x); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RotFrame_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%IsLoad_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%DerivOrder_x); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtPtfm_CopyContState(SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg)
   type(ExtPtfm_ContinuousStateType), intent(in) :: SrcContStateData
   type(ExtPtfm_ContinuousStateType), intent(inout) :: DstContStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'ExtPtfm_CopyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcContStateData%qm)) then
      LB(1:1) = lbound(SrcContStateData%qm)
      UB(1:1) = ubound(SrcContStateData%qm)
      if (.not. allocated(DstContStateData%qm)) then
         allocate(DstContStateData%qm(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstContStateData%qm.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstContStateData%qm = SrcContStateData%qm
   end if
   if (allocated(SrcContStateData%qmdot)) then
      LB(1:1) = lbound(SrcContStateData%qmdot)
      UB(1:1) = ubound(SrcContStateData%qmdot)
      if (.not. allocated(DstContStateData%qmdot)) then
         allocate(DstContStateData%qmdot(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstContStateData%qmdot.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstContStateData%qmdot = SrcContStateData%qmdot
   end if
end subroutine

subroutine ExtPtfm_DestroyContState(ContStateData, ErrStat, ErrMsg)
   type(ExtPtfm_ContinuousStateType), intent(inout) :: ContStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ExtPtfm_DestroyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ContStateData%qm)) then
      deallocate(ContStateData%qm)
   end if
   if (allocated(ContStateData%qmdot)) then
      deallocate(ContStateData%qmdot)
   end if
end subroutine

subroutine ExtPtfm_PackContState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ExtPtfm_ContinuousStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ExtPtfm_PackContState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%qm)
   call RegPackAlloc(RF, InData%qmdot)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtPtfm_UnPackContState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ExtPtfm_ContinuousStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ExtPtfm_UnPackContState'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%qm); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%qmdot); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtPtfm_CopyDiscState(SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg)
   type(ExtPtfm_DiscreteStateType), intent(in) :: SrcDiscStateData
   type(ExtPtfm_DiscreteStateType), intent(inout) :: DstDiscStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ExtPtfm_CopyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstDiscStateData%DummyDiscState = SrcDiscStateData%DummyDiscState
end subroutine

subroutine ExtPtfm_DestroyDiscState(DiscStateData, ErrStat, ErrMsg)
   type(ExtPtfm_DiscreteStateType), intent(inout) :: DiscStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ExtPtfm_DestroyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine ExtPtfm_PackDiscState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ExtPtfm_DiscreteStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ExtPtfm_PackDiscState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyDiscState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtPtfm_UnPackDiscState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ExtPtfm_DiscreteStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ExtPtfm_UnPackDiscState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyDiscState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtPtfm_CopyConstrState(SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg)
   type(ExtPtfm_ConstraintStateType), intent(in) :: SrcConstrStateData
   type(ExtPtfm_ConstraintStateType), intent(inout) :: DstConstrStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ExtPtfm_CopyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstConstrStateData%DummyConstrState = SrcConstrStateData%DummyConstrState
end subroutine

subroutine ExtPtfm_DestroyConstrState(ConstrStateData, ErrStat, ErrMsg)
   type(ExtPtfm_ConstraintStateType), intent(inout) :: ConstrStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ExtPtfm_DestroyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine ExtPtfm_PackConstrState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ExtPtfm_ConstraintStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ExtPtfm_PackConstrState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyConstrState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtPtfm_UnPackConstrState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ExtPtfm_ConstraintStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ExtPtfm_UnPackConstrState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyConstrState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtPtfm_CopyOtherState(SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg)
   type(ExtPtfm_OtherStateType), intent(in) :: SrcOtherStateData
   type(ExtPtfm_OtherStateType), intent(inout) :: DstOtherStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ExtPtfm_CopyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcOtherStateData%xdot)) then
      LB(1:1) = lbound(SrcOtherStateData%xdot)
      UB(1:1) = ubound(SrcOtherStateData%xdot)
      if (.not. allocated(DstOtherStateData%xdot)) then
         allocate(DstOtherStateData%xdot(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%xdot.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call ExtPtfm_CopyContState(SrcOtherStateData%xdot(i1), DstOtherStateData%xdot(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstOtherStateData%n = SrcOtherStateData%n
end subroutine

subroutine ExtPtfm_DestroyOtherState(OtherStateData, ErrStat, ErrMsg)
   type(ExtPtfm_OtherStateType), intent(inout) :: OtherStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ExtPtfm_DestroyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(OtherStateData%xdot)) then
      LB(1:1) = lbound(OtherStateData%xdot)
      UB(1:1) = ubound(OtherStateData%xdot)
      do i1 = LB(1), UB(1)
         call ExtPtfm_DestroyContState(OtherStateData%xdot(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(OtherStateData%xdot)
   end if
end subroutine

subroutine ExtPtfm_PackOtherState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ExtPtfm_OtherStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ExtPtfm_PackOtherState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%xdot))
   if (allocated(InData%xdot)) then
      call RegPackBounds(RF, 1, lbound(InData%xdot), ubound(InData%xdot))
      LB(1:1) = lbound(InData%xdot)
      UB(1:1) = ubound(InData%xdot)
      do i1 = LB(1), UB(1)
         call ExtPtfm_PackContState(RF, InData%xdot(i1)) 
      end do
   end if
   call RegPack(RF, InData%n)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtPtfm_UnPackOtherState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ExtPtfm_OtherStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ExtPtfm_UnPackOtherState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%xdot)) deallocate(OutData%xdot)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%xdot(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%xdot.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call ExtPtfm_UnpackContState(RF, OutData%xdot(i1)) ! xdot 
      end do
   end if
   call RegUnpack(RF, OutData%n); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtPtfm_CopyMisc(SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg)
   type(ExtPtfm_MiscVarType), intent(in) :: SrcMiscData
   type(ExtPtfm_MiscVarType), intent(inout) :: DstMiscData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'ExtPtfm_CopyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcMiscData%xFlat)) then
      LB(1:1) = lbound(SrcMiscData%xFlat)
      UB(1:1) = ubound(SrcMiscData%xFlat)
      if (.not. allocated(DstMiscData%xFlat)) then
         allocate(DstMiscData%xFlat(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%xFlat.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%xFlat = SrcMiscData%xFlat
   end if
   DstMiscData%uFlat = SrcMiscData%uFlat
   if (allocated(SrcMiscData%F_at_t)) then
      LB(1:1) = lbound(SrcMiscData%F_at_t)
      UB(1:1) = ubound(SrcMiscData%F_at_t)
      if (.not. allocated(DstMiscData%F_at_t)) then
         allocate(DstMiscData%F_at_t(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%F_at_t.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%F_at_t = SrcMiscData%F_at_t
   end if
   DstMiscData%Indx = SrcMiscData%Indx
   DstMiscData%EquilStart = SrcMiscData%EquilStart
   if (allocated(SrcMiscData%AllOuts)) then
      LB(1:1) = lbound(SrcMiscData%AllOuts)
      UB(1:1) = ubound(SrcMiscData%AllOuts)
      if (.not. allocated(DstMiscData%AllOuts)) then
         allocate(DstMiscData%AllOuts(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%AllOuts.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%AllOuts = SrcMiscData%AllOuts
   end if
end subroutine

subroutine ExtPtfm_DestroyMisc(MiscData, ErrStat, ErrMsg)
   type(ExtPtfm_MiscVarType), intent(inout) :: MiscData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ExtPtfm_DestroyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(MiscData%xFlat)) then
      deallocate(MiscData%xFlat)
   end if
   if (allocated(MiscData%F_at_t)) then
      deallocate(MiscData%F_at_t)
   end if
   if (allocated(MiscData%AllOuts)) then
      deallocate(MiscData%AllOuts)
   end if
end subroutine

subroutine ExtPtfm_PackMisc(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ExtPtfm_MiscVarType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ExtPtfm_PackMisc'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%xFlat)
   call RegPack(RF, InData%uFlat)
   call RegPackAlloc(RF, InData%F_at_t)
   call RegPack(RF, InData%Indx)
   call RegPack(RF, InData%EquilStart)
   call RegPackAlloc(RF, InData%AllOuts)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtPtfm_UnPackMisc(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ExtPtfm_MiscVarType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ExtPtfm_UnPackMisc'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%xFlat); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%uFlat); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%F_at_t); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Indx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%EquilStart); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AllOuts); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtPtfm_CopyParam(SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg)
   type(ExtPtfm_ParameterType), intent(in) :: SrcParamData
   type(ExtPtfm_ParameterType), intent(inout) :: DstParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ExtPtfm_CopyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcParamData%Mass)) then
      LB(1:2) = lbound(SrcParamData%Mass)
      UB(1:2) = ubound(SrcParamData%Mass)
      if (.not. allocated(DstParamData%Mass)) then
         allocate(DstParamData%Mass(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Mass.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Mass = SrcParamData%Mass
   end if
   if (allocated(SrcParamData%Damp)) then
      LB(1:2) = lbound(SrcParamData%Damp)
      UB(1:2) = ubound(SrcParamData%Damp)
      if (.not. allocated(DstParamData%Damp)) then
         allocate(DstParamData%Damp(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Damp.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Damp = SrcParamData%Damp
   end if
   if (allocated(SrcParamData%Stff)) then
      LB(1:2) = lbound(SrcParamData%Stff)
      UB(1:2) = ubound(SrcParamData%Stff)
      if (.not. allocated(DstParamData%Stff)) then
         allocate(DstParamData%Stff(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Stff.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Stff = SrcParamData%Stff
   end if
   if (allocated(SrcParamData%Forces)) then
      LB(1:2) = lbound(SrcParamData%Forces)
      UB(1:2) = ubound(SrcParamData%Forces)
      if (.not. allocated(DstParamData%Forces)) then
         allocate(DstParamData%Forces(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Forces.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Forces = SrcParamData%Forces
   end if
   if (allocated(SrcParamData%times)) then
      LB(1:1) = lbound(SrcParamData%times)
      UB(1:1) = ubound(SrcParamData%times)
      if (.not. allocated(DstParamData%times)) then
         allocate(DstParamData%times(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%times.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%times = SrcParamData%times
   end if
   if (allocated(SrcParamData%AMat)) then
      LB(1:2) = lbound(SrcParamData%AMat)
      UB(1:2) = ubound(SrcParamData%AMat)
      if (.not. allocated(DstParamData%AMat)) then
         allocate(DstParamData%AMat(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%AMat.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%AMat = SrcParamData%AMat
   end if
   if (allocated(SrcParamData%BMat)) then
      LB(1:2) = lbound(SrcParamData%BMat)
      UB(1:2) = ubound(SrcParamData%BMat)
      if (.not. allocated(DstParamData%BMat)) then
         allocate(DstParamData%BMat(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%BMat.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%BMat = SrcParamData%BMat
   end if
   if (allocated(SrcParamData%CMat)) then
      LB(1:2) = lbound(SrcParamData%CMat)
      UB(1:2) = ubound(SrcParamData%CMat)
      if (.not. allocated(DstParamData%CMat)) then
         allocate(DstParamData%CMat(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%CMat.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%CMat = SrcParamData%CMat
   end if
   if (allocated(SrcParamData%DMat)) then
      LB(1:2) = lbound(SrcParamData%DMat)
      UB(1:2) = ubound(SrcParamData%DMat)
      if (.not. allocated(DstParamData%DMat)) then
         allocate(DstParamData%DMat(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%DMat.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%DMat = SrcParamData%DMat
   end if
   if (allocated(SrcParamData%FX)) then
      LB(1:1) = lbound(SrcParamData%FX)
      UB(1:1) = ubound(SrcParamData%FX)
      if (.not. allocated(DstParamData%FX)) then
         allocate(DstParamData%FX(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%FX.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%FX = SrcParamData%FX
   end if
   if (allocated(SrcParamData%FY)) then
      LB(1:1) = lbound(SrcParamData%FY)
      UB(1:1) = ubound(SrcParamData%FY)
      if (.not. allocated(DstParamData%FY)) then
         allocate(DstParamData%FY(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%FY.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%FY = SrcParamData%FY
   end if
   if (allocated(SrcParamData%M11)) then
      LB(1:2) = lbound(SrcParamData%M11)
      UB(1:2) = ubound(SrcParamData%M11)
      if (.not. allocated(DstParamData%M11)) then
         allocate(DstParamData%M11(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%M11.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%M11 = SrcParamData%M11
   end if
   if (allocated(SrcParamData%M12)) then
      LB(1:2) = lbound(SrcParamData%M12)
      UB(1:2) = ubound(SrcParamData%M12)
      if (.not. allocated(DstParamData%M12)) then
         allocate(DstParamData%M12(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%M12.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%M12 = SrcParamData%M12
   end if
   if (allocated(SrcParamData%M22)) then
      LB(1:2) = lbound(SrcParamData%M22)
      UB(1:2) = ubound(SrcParamData%M22)
      if (.not. allocated(DstParamData%M22)) then
         allocate(DstParamData%M22(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%M22.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%M22 = SrcParamData%M22
   end if
   if (allocated(SrcParamData%M21)) then
      LB(1:2) = lbound(SrcParamData%M21)
      UB(1:2) = ubound(SrcParamData%M21)
      if (.not. allocated(DstParamData%M21)) then
         allocate(DstParamData%M21(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%M21.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%M21 = SrcParamData%M21
   end if
   if (allocated(SrcParamData%K11)) then
      LB(1:2) = lbound(SrcParamData%K11)
      UB(1:2) = ubound(SrcParamData%K11)
      if (.not. allocated(DstParamData%K11)) then
         allocate(DstParamData%K11(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%K11.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%K11 = SrcParamData%K11
   end if
   if (allocated(SrcParamData%K22)) then
      LB(1:2) = lbound(SrcParamData%K22)
      UB(1:2) = ubound(SrcParamData%K22)
      if (.not. allocated(DstParamData%K22)) then
         allocate(DstParamData%K22(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%K22.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%K22 = SrcParamData%K22
   end if
   if (allocated(SrcParamData%C11)) then
      LB(1:2) = lbound(SrcParamData%C11)
      UB(1:2) = ubound(SrcParamData%C11)
      if (.not. allocated(DstParamData%C11)) then
         allocate(DstParamData%C11(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%C11.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%C11 = SrcParamData%C11
   end if
   if (allocated(SrcParamData%C12)) then
      LB(1:2) = lbound(SrcParamData%C12)
      UB(1:2) = ubound(SrcParamData%C12)
      if (.not. allocated(DstParamData%C12)) then
         allocate(DstParamData%C12(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%C12.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%C12 = SrcParamData%C12
   end if
   if (allocated(SrcParamData%C22)) then
      LB(1:2) = lbound(SrcParamData%C22)
      UB(1:2) = ubound(SrcParamData%C22)
      if (.not. allocated(DstParamData%C22)) then
         allocate(DstParamData%C22(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%C22.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%C22 = SrcParamData%C22
   end if
   if (allocated(SrcParamData%C21)) then
      LB(1:2) = lbound(SrcParamData%C21)
      UB(1:2) = ubound(SrcParamData%C21)
      if (.not. allocated(DstParamData%C21)) then
         allocate(DstParamData%C21(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%C21.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%C21 = SrcParamData%C21
   end if
   DstParamData%EP_DeltaT = SrcParamData%EP_DeltaT
   DstParamData%nTimeSteps = SrcParamData%nTimeSteps
   DstParamData%nCB = SrcParamData%nCB
   DstParamData%nCBFull = SrcParamData%nCBFull
   DstParamData%nTot = SrcParamData%nTot
   DstParamData%NumOuts = SrcParamData%NumOuts
   DstParamData%IntMethod = SrcParamData%IntMethod
   if (allocated(SrcParamData%ActiveCBDOF)) then
      LB(1:1) = lbound(SrcParamData%ActiveCBDOF)
      UB(1:1) = ubound(SrcParamData%ActiveCBDOF)
      if (.not. allocated(DstParamData%ActiveCBDOF)) then
         allocate(DstParamData%ActiveCBDOF(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%ActiveCBDOF.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%ActiveCBDOF = SrcParamData%ActiveCBDOF
   end if
   if (allocated(SrcParamData%OutParam)) then
      LB(1:1) = lbound(SrcParamData%OutParam)
      UB(1:1) = ubound(SrcParamData%OutParam)
      if (.not. allocated(DstParamData%OutParam)) then
         allocate(DstParamData%OutParam(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%OutParam.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyOutParmType(SrcParamData%OutParam(i1), DstParamData%OutParam(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcParamData%OutParamLinIndx)) then
      LB(1:2) = lbound(SrcParamData%OutParamLinIndx)
      UB(1:2) = ubound(SrcParamData%OutParamLinIndx)
      if (.not. allocated(DstParamData%OutParamLinIndx)) then
         allocate(DstParamData%OutParamLinIndx(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%OutParamLinIndx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%OutParamLinIndx = SrcParamData%OutParamLinIndx
   end if
end subroutine

subroutine ExtPtfm_DestroyParam(ParamData, ErrStat, ErrMsg)
   type(ExtPtfm_ParameterType), intent(inout) :: ParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ExtPtfm_DestroyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ParamData%Mass)) then
      deallocate(ParamData%Mass)
   end if
   if (allocated(ParamData%Damp)) then
      deallocate(ParamData%Damp)
   end if
   if (allocated(ParamData%Stff)) then
      deallocate(ParamData%Stff)
   end if
   if (allocated(ParamData%Forces)) then
      deallocate(ParamData%Forces)
   end if
   if (allocated(ParamData%times)) then
      deallocate(ParamData%times)
   end if
   if (allocated(ParamData%AMat)) then
      deallocate(ParamData%AMat)
   end if
   if (allocated(ParamData%BMat)) then
      deallocate(ParamData%BMat)
   end if
   if (allocated(ParamData%CMat)) then
      deallocate(ParamData%CMat)
   end if
   if (allocated(ParamData%DMat)) then
      deallocate(ParamData%DMat)
   end if
   if (allocated(ParamData%FX)) then
      deallocate(ParamData%FX)
   end if
   if (allocated(ParamData%FY)) then
      deallocate(ParamData%FY)
   end if
   if (allocated(ParamData%M11)) then
      deallocate(ParamData%M11)
   end if
   if (allocated(ParamData%M12)) then
      deallocate(ParamData%M12)
   end if
   if (allocated(ParamData%M22)) then
      deallocate(ParamData%M22)
   end if
   if (allocated(ParamData%M21)) then
      deallocate(ParamData%M21)
   end if
   if (allocated(ParamData%K11)) then
      deallocate(ParamData%K11)
   end if
   if (allocated(ParamData%K22)) then
      deallocate(ParamData%K22)
   end if
   if (allocated(ParamData%C11)) then
      deallocate(ParamData%C11)
   end if
   if (allocated(ParamData%C12)) then
      deallocate(ParamData%C12)
   end if
   if (allocated(ParamData%C22)) then
      deallocate(ParamData%C22)
   end if
   if (allocated(ParamData%C21)) then
      deallocate(ParamData%C21)
   end if
   if (allocated(ParamData%ActiveCBDOF)) then
      deallocate(ParamData%ActiveCBDOF)
   end if
   if (allocated(ParamData%OutParam)) then
      LB(1:1) = lbound(ParamData%OutParam)
      UB(1:1) = ubound(ParamData%OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyOutParmType(ParamData%OutParam(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%OutParam)
   end if
   if (allocated(ParamData%OutParamLinIndx)) then
      deallocate(ParamData%OutParamLinIndx)
   end if
end subroutine

subroutine ExtPtfm_PackParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ExtPtfm_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ExtPtfm_PackParam'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%Mass)
   call RegPackAlloc(RF, InData%Damp)
   call RegPackAlloc(RF, InData%Stff)
   call RegPackAlloc(RF, InData%Forces)
   call RegPackAlloc(RF, InData%times)
   call RegPackAlloc(RF, InData%AMat)
   call RegPackAlloc(RF, InData%BMat)
   call RegPackAlloc(RF, InData%CMat)
   call RegPackAlloc(RF, InData%DMat)
   call RegPackAlloc(RF, InData%FX)
   call RegPackAlloc(RF, InData%FY)
   call RegPackAlloc(RF, InData%M11)
   call RegPackAlloc(RF, InData%M12)
   call RegPackAlloc(RF, InData%M22)
   call RegPackAlloc(RF, InData%M21)
   call RegPackAlloc(RF, InData%K11)
   call RegPackAlloc(RF, InData%K22)
   call RegPackAlloc(RF, InData%C11)
   call RegPackAlloc(RF, InData%C12)
   call RegPackAlloc(RF, InData%C22)
   call RegPackAlloc(RF, InData%C21)
   call RegPack(RF, InData%EP_DeltaT)
   call RegPack(RF, InData%nTimeSteps)
   call RegPack(RF, InData%nCB)
   call RegPack(RF, InData%nCBFull)
   call RegPack(RF, InData%nTot)
   call RegPack(RF, InData%NumOuts)
   call RegPack(RF, InData%IntMethod)
   call RegPackAlloc(RF, InData%ActiveCBDOF)
   call RegPack(RF, allocated(InData%OutParam))
   if (allocated(InData%OutParam)) then
      call RegPackBounds(RF, 1, lbound(InData%OutParam), ubound(InData%OutParam))
      LB(1:1) = lbound(InData%OutParam)
      UB(1:1) = ubound(InData%OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackOutParmType(RF, InData%OutParam(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%OutParamLinIndx)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtPtfm_UnPackParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ExtPtfm_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ExtPtfm_UnPackParam'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%Mass); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Damp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Stff); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Forces); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%times); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AMat); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BMat); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%CMat); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%DMat); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%FX); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%FY); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%M11); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%M12); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%M22); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%M21); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%K11); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%K22); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%C11); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%C12); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%C22); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%C21); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%EP_DeltaT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nTimeSteps); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nCB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nCBFull); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nTot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%IntMethod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%ActiveCBDOF); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%OutParam)) deallocate(OutData%OutParam)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%OutParam(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%OutParam.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackOutParmType(RF, OutData%OutParam(i1)) ! OutParam 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%OutParamLinIndx); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtPtfm_CopyInput(SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg)
   type(ExtPtfm_InputType), intent(inout) :: SrcInputData
   type(ExtPtfm_InputType), intent(inout) :: DstInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ExtPtfm_CopyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshCopy(SrcInputData%PtfmMesh, DstInputData%PtfmMesh, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine ExtPtfm_DestroyInput(InputData, ErrStat, ErrMsg)
   type(ExtPtfm_InputType), intent(inout) :: InputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ExtPtfm_DestroyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshDestroy( InputData%PtfmMesh, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine ExtPtfm_PackInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ExtPtfm_InputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ExtPtfm_PackInput'
   if (RF%ErrStat >= AbortErrLev) return
   call MeshPack(RF, InData%PtfmMesh) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtPtfm_UnPackInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ExtPtfm_InputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ExtPtfm_UnPackInput'
   if (RF%ErrStat /= ErrID_None) return
   call MeshUnpack(RF, OutData%PtfmMesh) ! PtfmMesh 
end subroutine

subroutine ExtPtfm_CopyOutput(SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg)
   type(ExtPtfm_OutputType), intent(inout) :: SrcOutputData
   type(ExtPtfm_OutputType), intent(inout) :: DstOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ExtPtfm_CopyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshCopy(SrcOutputData%PtfmMesh, DstOutputData%PtfmMesh, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcOutputData%WriteOutput)) then
      LB(1:1) = lbound(SrcOutputData%WriteOutput)
      UB(1:1) = ubound(SrcOutputData%WriteOutput)
      if (.not. allocated(DstOutputData%WriteOutput)) then
         allocate(DstOutputData%WriteOutput(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%WriteOutput.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%WriteOutput = SrcOutputData%WriteOutput
   end if
end subroutine

subroutine ExtPtfm_DestroyOutput(OutputData, ErrStat, ErrMsg)
   type(ExtPtfm_OutputType), intent(inout) :: OutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ExtPtfm_DestroyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshDestroy( OutputData%PtfmMesh, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(OutputData%WriteOutput)) then
      deallocate(OutputData%WriteOutput)
   end if
end subroutine

subroutine ExtPtfm_PackOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ExtPtfm_OutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ExtPtfm_PackOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call MeshPack(RF, InData%PtfmMesh) 
   call RegPackAlloc(RF, InData%WriteOutput)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtPtfm_UnPackOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ExtPtfm_OutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ExtPtfm_UnPackOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call MeshUnpack(RF, OutData%PtfmMesh) ! PtfmMesh 
   call RegUnpackAlloc(RF, OutData%WriteOutput); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtPtfm_Input_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
   ! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(ExtPtfm_InputType), intent(inout)  :: u(:) ! Input at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Inputs
   type(ExtPtfm_InputType), intent(inout)  :: u_out ! Input at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'ExtPtfm_Input_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(u)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(u)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(u) - 1
   select case (order)
   case (0)
      call ExtPtfm_CopyInput(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call ExtPtfm_Input_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call ExtPtfm_Input_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(u) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE ExtPtfm_Input_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

   TYPE(ExtPtfm_InputType), INTENT(INOUT)  :: u1    ! Input at t1 > t2
   TYPE(ExtPtfm_InputType), INTENT(INOUT)  :: u2    ! Input at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Inputs
   TYPE(ExtPtfm_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'ExtPtfm_Input_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   CALL MeshExtrapInterp1(u1%PtfmMesh, u2%PtfmMesh, tin, u_out%PtfmMesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
END SUBROUTINE

SUBROUTINE ExtPtfm_Input_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

   TYPE(ExtPtfm_InputType), INTENT(INOUT)  :: u1      ! Input at t1 > t2 > t3
   TYPE(ExtPtfm_InputType), INTENT(INOUT)  :: u2      ! Input at t2 > t3
   TYPE(ExtPtfm_InputType), INTENT(INOUT)  :: u3      ! Input at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Inputs
   TYPE(ExtPtfm_InputType), INTENT(INOUT)  :: u_out     ! Input at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'ExtPtfm_Input_ExtrapInterp2'
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   CALL MeshExtrapInterp2(u1%PtfmMesh, u2%PtfmMesh, u3%PtfmMesh, tin, u_out%PtfmMesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
END SUBROUTINE

subroutine ExtPtfm_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
   ! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(ExtPtfm_OutputType), intent(inout)  :: y(:) ! Output at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Outputs
   type(ExtPtfm_OutputType), intent(inout)  :: y_out ! Output at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'ExtPtfm_Output_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(y)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(y)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(y) - 1
   select case (order)
   case (0)
      call ExtPtfm_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call ExtPtfm_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call ExtPtfm_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(y) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE ExtPtfm_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

   TYPE(ExtPtfm_OutputType), INTENT(INOUT)  :: y1    ! Output at t1 > t2
   TYPE(ExtPtfm_OutputType), INTENT(INOUT)  :: y2    ! Output at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
   TYPE(ExtPtfm_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'ExtPtfm_Output_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   CALL MeshExtrapInterp1(y1%PtfmMesh, y2%PtfmMesh, tin, y_out%PtfmMesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
      y_out%WriteOutput = a1*y1%WriteOutput + a2*y2%WriteOutput
   END IF ! check if allocated
END SUBROUTINE

SUBROUTINE ExtPtfm_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

   TYPE(ExtPtfm_OutputType), INTENT(INOUT)  :: y1      ! Output at t1 > t2 > t3
   TYPE(ExtPtfm_OutputType), INTENT(INOUT)  :: y2      ! Output at t2 > t3
   TYPE(ExtPtfm_OutputType), INTENT(INOUT)  :: y3      ! Output at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
   TYPE(ExtPtfm_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'ExtPtfm_Output_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   CALL MeshExtrapInterp2(y1%PtfmMesh, y2%PtfmMesh, y3%PtfmMesh, tin, y_out%PtfmMesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
      y_out%WriteOutput = a1*y1%WriteOutput + a2*y2%WriteOutput + a3*y3%WriteOutput
   END IF ! check if allocated
END SUBROUTINE
END MODULE ExtPtfm_MCKF_Types
!ENDOFREGISTRYGENERATEDFILE
