!STARTOFREGISTRYGENERATEDFILE 'ExtLoads_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! ExtLoads_Types
!.................................................................................................................................
! This file is part of ExtLoads.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in ExtLoads. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE ExtLoads_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE IfW_FlowField_Types
USE ExtLoadsDX_Types
USE NWTC_Library
IMPLICIT NONE
! =========  ExtLd_InitInputType  =======
  TYPE, PUBLIC :: ExtLd_InitInputType
    INTEGER(IntKi)  :: NumBlades = 0_IntKi      !< Number of blades on the turbine [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: NumBldNodes      !< Number of blade nodes for each blade [-]
    LOGICAL  :: TwrAero = .false.      !< Flag that tells this module if the tower aero is on. [-]
    INTEGER(IntKi)  :: NumTwrNds = 0_IntKi      !< Number of tower nodes for each blade [-]
    REAL(ReKi) , DIMENSION(1:3)  :: HubPos = 0.0_ReKi      !< X-Y-Z reference position of hub [m]
    REAL(R8Ki) , DIMENSION(1:3,1:3)  :: HubOrient = 0.0_R8Ki      !< DCM reference orientation of hub [-]
    REAL(ReKi) , DIMENSION(1:3)  :: NacellePos = 0.0_ReKi      !< X-Y-Z reference position of Nacelle [m]
    REAL(R8Ki) , DIMENSION(1:3,1:3)  :: NacelleOrient = 0.0_R8Ki      !< DCM reference orientation of Nacelle [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: BldRootPos      !< X-Y-Z reference position of each blade root (3 x NumBlades) [m]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: BldRootOrient      !< DCM reference orientation of blade root (3x3 x NumBlades ) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: BldPos      !< X-Y-Z reference position of each blade (3 x NumBladeNodesMax x NumBlades) [m]
    REAL(R8Ki) , DIMENSION(:,:,:,:), ALLOCATABLE  :: BldOrient      !< DCM reference orientation of blade (3x3 x NumBladeNodesMax x NumBlades ) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: TwrPos      !< X-Y-Z reference position of tower (3 x NumTowerNodes) [m]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: TwrOrient      !< DCM reference orientation of tower (3x3 x NumTowerNodes) [-]
    REAL(ReKi)  :: az_blend_mean = 0.0_ReKi      !< Mean azimuth at which to blend the external and aerodyn loads [-]
    REAL(ReKi)  :: az_blend_delta = 0.0_ReKi      !< The width of the tanh function over which to blend the external and aerodyn loads [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: BldChord      !< Blade chord  (NumBladeNodesMax x NumBlades) [m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: BldRloc      !< Radial location of each node along the blade [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TwrDia      !< Tower diameter (NumTwrNodes) [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TwrHloc      !< Height location of each node along the tower [m]
    INTEGER(IntKi)  :: nNodesVel = 0_IntKi      !< Number of nodes velocity data is needed from (for sizing array) [-]
  END TYPE ExtLd_InitInputType
! =======================
! =========  ExtLd_InitOutputType  =======
  TYPE, PUBLIC :: ExtLd_InitOutputType
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputHdr      !< Names of the output-to-file channels [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputUnt      !< Units of the output-to-file channels [-]
    TYPE(ProgDesc)  :: Ver      !< This module's name, version, and date [-]
    REAL(ReKi)  :: AirDens = 0.0_ReKi      !< Air density [kg/m^3]
  END TYPE ExtLd_InitOutputType
! =======================
! =========  ExtLd_ContinuousStateType  =======
  TYPE, PUBLIC :: ExtLd_ContinuousStateType
    REAL(ReKi)  :: blah = 0.0_ReKi      !< Something [-]
  END TYPE ExtLd_ContinuousStateType
! =======================
! =========  ExtLd_DiscreteStateType  =======
  TYPE, PUBLIC :: ExtLd_DiscreteStateType
    REAL(ReKi)  :: blah = 0.0_ReKi      !< Something [-]
  END TYPE ExtLd_DiscreteStateType
! =======================
! =========  ExtLd_MiscVarType  =======
  TYPE, PUBLIC :: ExtLd_MiscVarType
    REAL(ReKi)  :: az = 0.0_ReKi      !< Current azimuth [-]
    REAL(ReKi)  :: phi_cfd = 0.0_ReKi      !< Blending ratio of load from external driver [0-1] [-]
    TYPE(FlowFieldType) , POINTER :: FlowField => NULL()      !< Flow field data type [-]
  END TYPE ExtLd_MiscVarType
! =======================
! =========  ExtLd_ConstraintStateType  =======
  TYPE, PUBLIC :: ExtLd_ConstraintStateType
    REAL(ReKi)  :: blah = 0.0_ReKi      !< Something [-]
  END TYPE ExtLd_ConstraintStateType
! =======================
! =========  ExtLd_OtherStateType  =======
  TYPE, PUBLIC :: ExtLd_OtherStateType
    REAL(ReKi)  :: blah = 0.0_ReKi      !< Something [-]
  END TYPE ExtLd_OtherStateType
! =======================
! =========  ExtLd_ParameterType  =======
  TYPE, PUBLIC :: ExtLd_ParameterType
    TYPE(ExtLdDX_ParameterType)  :: DX_p      !< Data to send to external driver [-]
    INTEGER(IntKi)  :: NumBlds = 0_IntKi      !< Number of blades on the turbine [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: NumBldNds      !< Number of blade nodes for each blade [-]
    INTEGER(IntKi)  :: nTotBldNds = 0_IntKi      !< Total number of blade nodes [-]
    LOGICAL  :: TwrAero = .FALSE.      !< Flag that tells this module if the tower aero is on. [-]
    INTEGER(IntKi)  :: NumTwrNds = 0_IntKi      !< Number of tower nodes [-]
    REAL(ReKi)  :: az_blend_mean = 0.0_ReKi      !< Mean azimuth at which to blend the external and aerodyn loads [-]
    REAL(ReKi)  :: az_blend_delta = 0.0_ReKi      !< The width of the tanh function over which to blend the external and aerodyn loads [-]
  END TYPE ExtLd_ParameterType
! =======================
! =========  ExtLd_InputType  =======
  TYPE, PUBLIC :: ExtLd_InputType
    TYPE(ExtLdDX_InputType)  :: DX_u      !< Data to send to external driver [-]
    REAL(ReKi)  :: az = 0.0_ReKi      !< Azimuth of rotor [-]
    TYPE(MeshType)  :: TowerMotion      !< motion on the tower [-]
    TYPE(MeshType)  :: HubMotion      !< motion on the hub [-]
    TYPE(MeshType)  :: NacelleMotion      !< motion on the nacelle [-]
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: BladeRootMotion      !< motion on each blade root [-]
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: BladeMotion      !< motion on each blade [-]
  END TYPE ExtLd_InputType
! =======================
! =========  ExtLd_OutputType  =======
  TYPE, PUBLIC :: ExtLd_OutputType
    TYPE(ExtLdDX_OutputType)  :: DX_y      !< Data to get from external driver [-]
    TYPE(MeshType)  :: TowerLoad      !< loads on the tower [-]
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: BladeLoad      !< loads on each blade [-]
    TYPE(MeshType)  :: TowerLoadAD      !< loads on the tower from aerodyn [-]
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: BladeLoadAD      !< loads on each blade from aerodyn [-]
  END TYPE ExtLd_OutputType
! =======================
CONTAINS

subroutine ExtLd_CopyInitInput(SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg)
   type(ExtLd_InitInputType), intent(in) :: SrcInitInputData
   type(ExtLd_InitInputType), intent(inout) :: DstInitInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(4), UB(4)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'ExtLd_CopyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInitInputData%NumBlades = SrcInitInputData%NumBlades
   if (allocated(SrcInitInputData%NumBldNodes)) then
      LB(1:1) = lbound(SrcInitInputData%NumBldNodes)
      UB(1:1) = ubound(SrcInitInputData%NumBldNodes)
      if (.not. allocated(DstInitInputData%NumBldNodes)) then
         allocate(DstInitInputData%NumBldNodes(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%NumBldNodes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%NumBldNodes = SrcInitInputData%NumBldNodes
   end if
   DstInitInputData%TwrAero = SrcInitInputData%TwrAero
   DstInitInputData%NumTwrNds = SrcInitInputData%NumTwrNds
   DstInitInputData%HubPos = SrcInitInputData%HubPos
   DstInitInputData%HubOrient = SrcInitInputData%HubOrient
   DstInitInputData%NacellePos = SrcInitInputData%NacellePos
   DstInitInputData%NacelleOrient = SrcInitInputData%NacelleOrient
   if (allocated(SrcInitInputData%BldRootPos)) then
      LB(1:2) = lbound(SrcInitInputData%BldRootPos)
      UB(1:2) = ubound(SrcInitInputData%BldRootPos)
      if (.not. allocated(DstInitInputData%BldRootPos)) then
         allocate(DstInitInputData%BldRootPos(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%BldRootPos.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%BldRootPos = SrcInitInputData%BldRootPos
   end if
   if (allocated(SrcInitInputData%BldRootOrient)) then
      LB(1:3) = lbound(SrcInitInputData%BldRootOrient)
      UB(1:3) = ubound(SrcInitInputData%BldRootOrient)
      if (.not. allocated(DstInitInputData%BldRootOrient)) then
         allocate(DstInitInputData%BldRootOrient(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%BldRootOrient.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%BldRootOrient = SrcInitInputData%BldRootOrient
   end if
   if (allocated(SrcInitInputData%BldPos)) then
      LB(1:3) = lbound(SrcInitInputData%BldPos)
      UB(1:3) = ubound(SrcInitInputData%BldPos)
      if (.not. allocated(DstInitInputData%BldPos)) then
         allocate(DstInitInputData%BldPos(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%BldPos.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%BldPos = SrcInitInputData%BldPos
   end if
   if (allocated(SrcInitInputData%BldOrient)) then
      LB(1:4) = lbound(SrcInitInputData%BldOrient)
      UB(1:4) = ubound(SrcInitInputData%BldOrient)
      if (.not. allocated(DstInitInputData%BldOrient)) then
         allocate(DstInitInputData%BldOrient(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%BldOrient.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%BldOrient = SrcInitInputData%BldOrient
   end if
   if (allocated(SrcInitInputData%TwrPos)) then
      LB(1:2) = lbound(SrcInitInputData%TwrPos)
      UB(1:2) = ubound(SrcInitInputData%TwrPos)
      if (.not. allocated(DstInitInputData%TwrPos)) then
         allocate(DstInitInputData%TwrPos(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%TwrPos.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%TwrPos = SrcInitInputData%TwrPos
   end if
   if (allocated(SrcInitInputData%TwrOrient)) then
      LB(1:3) = lbound(SrcInitInputData%TwrOrient)
      UB(1:3) = ubound(SrcInitInputData%TwrOrient)
      if (.not. allocated(DstInitInputData%TwrOrient)) then
         allocate(DstInitInputData%TwrOrient(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%TwrOrient.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%TwrOrient = SrcInitInputData%TwrOrient
   end if
   DstInitInputData%az_blend_mean = SrcInitInputData%az_blend_mean
   DstInitInputData%az_blend_delta = SrcInitInputData%az_blend_delta
   if (allocated(SrcInitInputData%BldChord)) then
      LB(1:2) = lbound(SrcInitInputData%BldChord)
      UB(1:2) = ubound(SrcInitInputData%BldChord)
      if (.not. allocated(DstInitInputData%BldChord)) then
         allocate(DstInitInputData%BldChord(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%BldChord.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%BldChord = SrcInitInputData%BldChord
   end if
   if (allocated(SrcInitInputData%BldRloc)) then
      LB(1:2) = lbound(SrcInitInputData%BldRloc)
      UB(1:2) = ubound(SrcInitInputData%BldRloc)
      if (.not. allocated(DstInitInputData%BldRloc)) then
         allocate(DstInitInputData%BldRloc(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%BldRloc.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%BldRloc = SrcInitInputData%BldRloc
   end if
   if (allocated(SrcInitInputData%TwrDia)) then
      LB(1:1) = lbound(SrcInitInputData%TwrDia)
      UB(1:1) = ubound(SrcInitInputData%TwrDia)
      if (.not. allocated(DstInitInputData%TwrDia)) then
         allocate(DstInitInputData%TwrDia(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%TwrDia.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%TwrDia = SrcInitInputData%TwrDia
   end if
   if (allocated(SrcInitInputData%TwrHloc)) then
      LB(1:1) = lbound(SrcInitInputData%TwrHloc)
      UB(1:1) = ubound(SrcInitInputData%TwrHloc)
      if (.not. allocated(DstInitInputData%TwrHloc)) then
         allocate(DstInitInputData%TwrHloc(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%TwrHloc.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%TwrHloc = SrcInitInputData%TwrHloc
   end if
   DstInitInputData%nNodesVel = SrcInitInputData%nNodesVel
end subroutine

subroutine ExtLd_DestroyInitInput(InitInputData, ErrStat, ErrMsg)
   type(ExtLd_InitInputType), intent(inout) :: InitInputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ExtLd_DestroyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InitInputData%NumBldNodes)) then
      deallocate(InitInputData%NumBldNodes)
   end if
   if (allocated(InitInputData%BldRootPos)) then
      deallocate(InitInputData%BldRootPos)
   end if
   if (allocated(InitInputData%BldRootOrient)) then
      deallocate(InitInputData%BldRootOrient)
   end if
   if (allocated(InitInputData%BldPos)) then
      deallocate(InitInputData%BldPos)
   end if
   if (allocated(InitInputData%BldOrient)) then
      deallocate(InitInputData%BldOrient)
   end if
   if (allocated(InitInputData%TwrPos)) then
      deallocate(InitInputData%TwrPos)
   end if
   if (allocated(InitInputData%TwrOrient)) then
      deallocate(InitInputData%TwrOrient)
   end if
   if (allocated(InitInputData%BldChord)) then
      deallocate(InitInputData%BldChord)
   end if
   if (allocated(InitInputData%BldRloc)) then
      deallocate(InitInputData%BldRloc)
   end if
   if (allocated(InitInputData%TwrDia)) then
      deallocate(InitInputData%TwrDia)
   end if
   if (allocated(InitInputData%TwrHloc)) then
      deallocate(InitInputData%TwrHloc)
   end if
end subroutine

subroutine ExtLd_PackInitInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ExtLd_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ExtLd_PackInitInput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%NumBlades)
   call RegPackAlloc(RF, InData%NumBldNodes)
   call RegPack(RF, InData%TwrAero)
   call RegPack(RF, InData%NumTwrNds)
   call RegPack(RF, InData%HubPos)
   call RegPack(RF, InData%HubOrient)
   call RegPack(RF, InData%NacellePos)
   call RegPack(RF, InData%NacelleOrient)
   call RegPackAlloc(RF, InData%BldRootPos)
   call RegPackAlloc(RF, InData%BldRootOrient)
   call RegPackAlloc(RF, InData%BldPos)
   call RegPackAlloc(RF, InData%BldOrient)
   call RegPackAlloc(RF, InData%TwrPos)
   call RegPackAlloc(RF, InData%TwrOrient)
   call RegPack(RF, InData%az_blend_mean)
   call RegPack(RF, InData%az_blend_delta)
   call RegPackAlloc(RF, InData%BldChord)
   call RegPackAlloc(RF, InData%BldRloc)
   call RegPackAlloc(RF, InData%TwrDia)
   call RegPackAlloc(RF, InData%TwrHloc)
   call RegPack(RF, InData%nNodesVel)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtLd_UnPackInitInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ExtLd_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ExtLd_UnPackInitInput'
   integer(B4Ki)   :: LB(4), UB(4)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%NumBlades); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%NumBldNodes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TwrAero); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumTwrNds); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HubPos); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HubOrient); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NacellePos); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NacelleOrient); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BldRootPos); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BldRootOrient); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BldPos); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BldOrient); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TwrPos); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TwrOrient); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%az_blend_mean); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%az_blend_delta); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BldChord); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BldRloc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TwrDia); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TwrHloc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nNodesVel); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtLd_CopyInitOutput(SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg)
   type(ExtLd_InitOutputType), intent(in) :: SrcInitOutputData
   type(ExtLd_InitOutputType), intent(inout) :: DstInitOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ExtLd_CopyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcInitOutputData%WriteOutputHdr)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputHdr)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputHdr)
      if (.not. allocated(DstInitOutputData%WriteOutputHdr)) then
         allocate(DstInitOutputData%WriteOutputHdr(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputHdr.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputHdr = SrcInitOutputData%WriteOutputHdr
   end if
   if (allocated(SrcInitOutputData%WriteOutputUnt)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputUnt)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputUnt)
      if (.not. allocated(DstInitOutputData%WriteOutputUnt)) then
         allocate(DstInitOutputData%WriteOutputUnt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputUnt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputUnt = SrcInitOutputData%WriteOutputUnt
   end if
   call NWTC_Library_CopyProgDesc(SrcInitOutputData%Ver, DstInitOutputData%Ver, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstInitOutputData%AirDens = SrcInitOutputData%AirDens
end subroutine

subroutine ExtLd_DestroyInitOutput(InitOutputData, ErrStat, ErrMsg)
   type(ExtLd_InitOutputType), intent(inout) :: InitOutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ExtLd_DestroyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InitOutputData%WriteOutputHdr)) then
      deallocate(InitOutputData%WriteOutputHdr)
   end if
   if (allocated(InitOutputData%WriteOutputUnt)) then
      deallocate(InitOutputData%WriteOutputUnt)
   end if
   call NWTC_Library_DestroyProgDesc(InitOutputData%Ver, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine ExtLd_PackInitOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ExtLd_InitOutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ExtLd_PackInitOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%WriteOutputHdr)
   call RegPackAlloc(RF, InData%WriteOutputUnt)
   call NWTC_Library_PackProgDesc(RF, InData%Ver) 
   call RegPack(RF, InData%AirDens)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtLd_UnPackInitOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ExtLd_InitOutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ExtLd_UnPackInitOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%WriteOutputHdr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutputUnt); if (RegCheckErr(RF, RoutineName)) return
   call NWTC_Library_UnpackProgDesc(RF, OutData%Ver) ! Ver 
   call RegUnpack(RF, OutData%AirDens); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtLd_CopyContState(SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg)
   type(ExtLd_ContinuousStateType), intent(in) :: SrcContStateData
   type(ExtLd_ContinuousStateType), intent(inout) :: DstContStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ExtLd_CopyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstContStateData%blah = SrcContStateData%blah
end subroutine

subroutine ExtLd_DestroyContState(ContStateData, ErrStat, ErrMsg)
   type(ExtLd_ContinuousStateType), intent(inout) :: ContStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ExtLd_DestroyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine ExtLd_PackContState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ExtLd_ContinuousStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ExtLd_PackContState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%blah)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtLd_UnPackContState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ExtLd_ContinuousStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ExtLd_UnPackContState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%blah); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtLd_CopyDiscState(SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg)
   type(ExtLd_DiscreteStateType), intent(in) :: SrcDiscStateData
   type(ExtLd_DiscreteStateType), intent(inout) :: DstDiscStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ExtLd_CopyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstDiscStateData%blah = SrcDiscStateData%blah
end subroutine

subroutine ExtLd_DestroyDiscState(DiscStateData, ErrStat, ErrMsg)
   type(ExtLd_DiscreteStateType), intent(inout) :: DiscStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ExtLd_DestroyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine ExtLd_PackDiscState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ExtLd_DiscreteStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ExtLd_PackDiscState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%blah)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtLd_UnPackDiscState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ExtLd_DiscreteStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ExtLd_UnPackDiscState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%blah); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtLd_CopyMisc(SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg)
   type(ExtLd_MiscVarType), intent(in) :: SrcMiscData
   type(ExtLd_MiscVarType), intent(inout) :: DstMiscData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(0), UB(0)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ExtLd_CopyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstMiscData%az = SrcMiscData%az
   DstMiscData%phi_cfd = SrcMiscData%phi_cfd
   if (associated(SrcMiscData%FlowField)) then
      if (.not. associated(DstMiscData%FlowField)) then
         allocate(DstMiscData%FlowField, stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%FlowField.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      call IfW_FlowField_CopyFlowFieldType(SrcMiscData%FlowField, DstMiscData%FlowField, CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end if
end subroutine

subroutine ExtLd_DestroyMisc(MiscData, ErrStat, ErrMsg)
   type(ExtLd_MiscVarType), intent(inout) :: MiscData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ExtLd_DestroyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (associated(MiscData%FlowField)) then
      call IfW_FlowField_DestroyFlowFieldType(MiscData%FlowField, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      deallocate(MiscData%FlowField)
      MiscData%FlowField => null()
   end if
end subroutine

subroutine ExtLd_PackMisc(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ExtLd_MiscVarType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ExtLd_PackMisc'
   logical         :: PtrInIndex
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%az)
   call RegPack(RF, InData%phi_cfd)
   call RegPack(RF, associated(InData%FlowField))
   if (associated(InData%FlowField)) then
      call RegPackPointer(RF, c_loc(InData%FlowField), PtrInIndex)
      if (.not. PtrInIndex) then
         call IfW_FlowField_PackFlowFieldType(RF, InData%FlowField) 
      end if
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtLd_UnPackMisc(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ExtLd_MiscVarType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ExtLd_UnPackMisc'
   integer(B4Ki)   :: LB(0), UB(0)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   integer(B8Ki)   :: PtrIdx
   type(c_ptr)     :: Ptr
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%az); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%phi_cfd); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%FlowField)) deallocate(OutData%FlowField)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackPointer(RF, Ptr, PtrIdx); if (RegCheckErr(RF, RoutineName)) return
      if (c_associated(Ptr)) then
         call c_f_pointer(Ptr, OutData%FlowField)
      else
         allocate(OutData%FlowField,stat=stat)
         if (stat /= 0) then 
            call SetErrStat(ErrID_Fatal, 'Error allocating OutData%FlowField.', RF%ErrStat, RF%ErrMsg, RoutineName)
            return
         end if
         RF%Pointers(PtrIdx) = c_loc(OutData%FlowField)
         call IfW_FlowField_UnpackFlowFieldType(RF, OutData%FlowField) ! FlowField 
      end if
   else
      OutData%FlowField => null()
   end if
end subroutine

subroutine ExtLd_CopyConstrState(SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg)
   type(ExtLd_ConstraintStateType), intent(in) :: SrcConstrStateData
   type(ExtLd_ConstraintStateType), intent(inout) :: DstConstrStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ExtLd_CopyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstConstrStateData%blah = SrcConstrStateData%blah
end subroutine

subroutine ExtLd_DestroyConstrState(ConstrStateData, ErrStat, ErrMsg)
   type(ExtLd_ConstraintStateType), intent(inout) :: ConstrStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ExtLd_DestroyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine ExtLd_PackConstrState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ExtLd_ConstraintStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ExtLd_PackConstrState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%blah)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtLd_UnPackConstrState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ExtLd_ConstraintStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ExtLd_UnPackConstrState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%blah); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtLd_CopyOtherState(SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg)
   type(ExtLd_OtherStateType), intent(in) :: SrcOtherStateData
   type(ExtLd_OtherStateType), intent(inout) :: DstOtherStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ExtLd_CopyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstOtherStateData%blah = SrcOtherStateData%blah
end subroutine

subroutine ExtLd_DestroyOtherState(OtherStateData, ErrStat, ErrMsg)
   type(ExtLd_OtherStateType), intent(inout) :: OtherStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ExtLd_DestroyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine ExtLd_PackOtherState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ExtLd_OtherStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ExtLd_PackOtherState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%blah)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtLd_UnPackOtherState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ExtLd_OtherStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ExtLd_UnPackOtherState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%blah); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtLd_CopyParam(SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg)
   type(ExtLd_ParameterType), intent(in) :: SrcParamData
   type(ExtLd_ParameterType), intent(inout) :: DstParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ExtLd_CopyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call ExtLdDX_CopyParam(SrcParamData%DX_p, DstParamData%DX_p, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstParamData%NumBlds = SrcParamData%NumBlds
   if (allocated(SrcParamData%NumBldNds)) then
      LB(1:1) = lbound(SrcParamData%NumBldNds)
      UB(1:1) = ubound(SrcParamData%NumBldNds)
      if (.not. allocated(DstParamData%NumBldNds)) then
         allocate(DstParamData%NumBldNds(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%NumBldNds.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%NumBldNds = SrcParamData%NumBldNds
   end if
   DstParamData%nTotBldNds = SrcParamData%nTotBldNds
   DstParamData%TwrAero = SrcParamData%TwrAero
   DstParamData%NumTwrNds = SrcParamData%NumTwrNds
   DstParamData%az_blend_mean = SrcParamData%az_blend_mean
   DstParamData%az_blend_delta = SrcParamData%az_blend_delta
end subroutine

subroutine ExtLd_DestroyParam(ParamData, ErrStat, ErrMsg)
   type(ExtLd_ParameterType), intent(inout) :: ParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ExtLd_DestroyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call ExtLdDX_DestroyParam(ParamData%DX_p, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(ParamData%NumBldNds)) then
      deallocate(ParamData%NumBldNds)
   end if
end subroutine

subroutine ExtLd_PackParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ExtLd_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ExtLd_PackParam'
   if (RF%ErrStat >= AbortErrLev) return
   call ExtLdDX_PackParam(RF, InData%DX_p) 
   call RegPack(RF, InData%NumBlds)
   call RegPackAlloc(RF, InData%NumBldNds)
   call RegPack(RF, InData%nTotBldNds)
   call RegPack(RF, InData%TwrAero)
   call RegPack(RF, InData%NumTwrNds)
   call RegPack(RF, InData%az_blend_mean)
   call RegPack(RF, InData%az_blend_delta)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtLd_UnPackParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ExtLd_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ExtLd_UnPackParam'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call ExtLdDX_UnpackParam(RF, OutData%DX_p) ! DX_p 
   call RegUnpack(RF, OutData%NumBlds); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%NumBldNds); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nTotBldNds); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TwrAero); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumTwrNds); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%az_blend_mean); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%az_blend_delta); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtLd_CopyInput(SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg)
   type(ExtLd_InputType), intent(inout) :: SrcInputData
   type(ExtLd_InputType), intent(inout) :: DstInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ExtLd_CopyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call ExtLdDX_CopyInput(SrcInputData%DX_u, DstInputData%DX_u, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstInputData%az = SrcInputData%az
   call MeshCopy(SrcInputData%TowerMotion, DstInputData%TowerMotion, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcInputData%HubMotion, DstInputData%HubMotion, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcInputData%NacelleMotion, DstInputData%NacelleMotion, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcInputData%BladeRootMotion)) then
      LB(1:1) = lbound(SrcInputData%BladeRootMotion)
      UB(1:1) = ubound(SrcInputData%BladeRootMotion)
      if (.not. allocated(DstInputData%BladeRootMotion)) then
         allocate(DstInputData%BladeRootMotion(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%BladeRootMotion.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcInputData%BladeRootMotion(i1), DstInputData%BladeRootMotion(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcInputData%BladeMotion)) then
      LB(1:1) = lbound(SrcInputData%BladeMotion)
      UB(1:1) = ubound(SrcInputData%BladeMotion)
      if (.not. allocated(DstInputData%BladeMotion)) then
         allocate(DstInputData%BladeMotion(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%BladeMotion.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcInputData%BladeMotion(i1), DstInputData%BladeMotion(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
end subroutine

subroutine ExtLd_DestroyInput(InputData, ErrStat, ErrMsg)
   type(ExtLd_InputType), intent(inout) :: InputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ExtLd_DestroyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call ExtLdDX_DestroyInput(InputData%DX_u, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( InputData%TowerMotion, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( InputData%HubMotion, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( InputData%NacelleMotion, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(InputData%BladeRootMotion)) then
      LB(1:1) = lbound(InputData%BladeRootMotion)
      UB(1:1) = ubound(InputData%BladeRootMotion)
      do i1 = LB(1), UB(1)
         call MeshDestroy( InputData%BladeRootMotion(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InputData%BladeRootMotion)
   end if
   if (allocated(InputData%BladeMotion)) then
      LB(1:1) = lbound(InputData%BladeMotion)
      UB(1:1) = ubound(InputData%BladeMotion)
      do i1 = LB(1), UB(1)
         call MeshDestroy( InputData%BladeMotion(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InputData%BladeMotion)
   end if
end subroutine

subroutine ExtLd_PackInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ExtLd_InputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ExtLd_PackInput'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call ExtLdDX_PackInput(RF, InData%DX_u) 
   call RegPack(RF, InData%az)
   call MeshPack(RF, InData%TowerMotion) 
   call MeshPack(RF, InData%HubMotion) 
   call MeshPack(RF, InData%NacelleMotion) 
   call RegPack(RF, allocated(InData%BladeRootMotion))
   if (allocated(InData%BladeRootMotion)) then
      call RegPackBounds(RF, 1, lbound(InData%BladeRootMotion), ubound(InData%BladeRootMotion))
      LB(1:1) = lbound(InData%BladeRootMotion)
      UB(1:1) = ubound(InData%BladeRootMotion)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%BladeRootMotion(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%BladeMotion))
   if (allocated(InData%BladeMotion)) then
      call RegPackBounds(RF, 1, lbound(InData%BladeMotion), ubound(InData%BladeMotion))
      LB(1:1) = lbound(InData%BladeMotion)
      UB(1:1) = ubound(InData%BladeMotion)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%BladeMotion(i1)) 
      end do
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtLd_UnPackInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ExtLd_InputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ExtLd_UnPackInput'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call ExtLdDX_UnpackInput(RF, OutData%DX_u) ! DX_u 
   call RegUnpack(RF, OutData%az); if (RegCheckErr(RF, RoutineName)) return
   call MeshUnpack(RF, OutData%TowerMotion) ! TowerMotion 
   call MeshUnpack(RF, OutData%HubMotion) ! HubMotion 
   call MeshUnpack(RF, OutData%NacelleMotion) ! NacelleMotion 
   if (allocated(OutData%BladeRootMotion)) deallocate(OutData%BladeRootMotion)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BladeRootMotion(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BladeRootMotion.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%BladeRootMotion(i1)) ! BladeRootMotion 
      end do
   end if
   if (allocated(OutData%BladeMotion)) deallocate(OutData%BladeMotion)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BladeMotion(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BladeMotion.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%BladeMotion(i1)) ! BladeMotion 
      end do
   end if
end subroutine

subroutine ExtLd_CopyOutput(SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg)
   type(ExtLd_OutputType), intent(inout) :: SrcOutputData
   type(ExtLd_OutputType), intent(inout) :: DstOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ExtLd_CopyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call ExtLdDX_CopyOutput(SrcOutputData%DX_y, DstOutputData%DX_y, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcOutputData%TowerLoad, DstOutputData%TowerLoad, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcOutputData%BladeLoad)) then
      LB(1:1) = lbound(SrcOutputData%BladeLoad)
      UB(1:1) = ubound(SrcOutputData%BladeLoad)
      if (.not. allocated(DstOutputData%BladeLoad)) then
         allocate(DstOutputData%BladeLoad(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%BladeLoad.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcOutputData%BladeLoad(i1), DstOutputData%BladeLoad(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call MeshCopy(SrcOutputData%TowerLoadAD, DstOutputData%TowerLoadAD, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcOutputData%BladeLoadAD)) then
      LB(1:1) = lbound(SrcOutputData%BladeLoadAD)
      UB(1:1) = ubound(SrcOutputData%BladeLoadAD)
      if (.not. allocated(DstOutputData%BladeLoadAD)) then
         allocate(DstOutputData%BladeLoadAD(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%BladeLoadAD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcOutputData%BladeLoadAD(i1), DstOutputData%BladeLoadAD(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
end subroutine

subroutine ExtLd_DestroyOutput(OutputData, ErrStat, ErrMsg)
   type(ExtLd_OutputType), intent(inout) :: OutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ExtLd_DestroyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call ExtLdDX_DestroyOutput(OutputData%DX_y, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( OutputData%TowerLoad, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(OutputData%BladeLoad)) then
      LB(1:1) = lbound(OutputData%BladeLoad)
      UB(1:1) = ubound(OutputData%BladeLoad)
      do i1 = LB(1), UB(1)
         call MeshDestroy( OutputData%BladeLoad(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(OutputData%BladeLoad)
   end if
   call MeshDestroy( OutputData%TowerLoadAD, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(OutputData%BladeLoadAD)) then
      LB(1:1) = lbound(OutputData%BladeLoadAD)
      UB(1:1) = ubound(OutputData%BladeLoadAD)
      do i1 = LB(1), UB(1)
         call MeshDestroy( OutputData%BladeLoadAD(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(OutputData%BladeLoadAD)
   end if
end subroutine

subroutine ExtLd_PackOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ExtLd_OutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ExtLd_PackOutput'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call ExtLdDX_PackOutput(RF, InData%DX_y) 
   call MeshPack(RF, InData%TowerLoad) 
   call RegPack(RF, allocated(InData%BladeLoad))
   if (allocated(InData%BladeLoad)) then
      call RegPackBounds(RF, 1, lbound(InData%BladeLoad), ubound(InData%BladeLoad))
      LB(1:1) = lbound(InData%BladeLoad)
      UB(1:1) = ubound(InData%BladeLoad)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%BladeLoad(i1)) 
      end do
   end if
   call MeshPack(RF, InData%TowerLoadAD) 
   call RegPack(RF, allocated(InData%BladeLoadAD))
   if (allocated(InData%BladeLoadAD)) then
      call RegPackBounds(RF, 1, lbound(InData%BladeLoadAD), ubound(InData%BladeLoadAD))
      LB(1:1) = lbound(InData%BladeLoadAD)
      UB(1:1) = ubound(InData%BladeLoadAD)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%BladeLoadAD(i1)) 
      end do
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtLd_UnPackOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ExtLd_OutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ExtLd_UnPackOutput'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call ExtLdDX_UnpackOutput(RF, OutData%DX_y) ! DX_y 
   call MeshUnpack(RF, OutData%TowerLoad) ! TowerLoad 
   if (allocated(OutData%BladeLoad)) deallocate(OutData%BladeLoad)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BladeLoad(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BladeLoad.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%BladeLoad(i1)) ! BladeLoad 
      end do
   end if
   call MeshUnpack(RF, OutData%TowerLoadAD) ! TowerLoadAD 
   if (allocated(OutData%BladeLoadAD)) deallocate(OutData%BladeLoadAD)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BladeLoadAD(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BladeLoadAD.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%BladeLoadAD(i1)) ! BladeLoadAD 
      end do
   end if
end subroutine

subroutine ExtLd_Input_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
   ! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(ExtLd_InputType), intent(inout)  :: u(:) ! Input at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Inputs
   type(ExtLd_InputType), intent(inout)  :: u_out ! Input at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'ExtLd_Input_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(u)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(u)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(u) - 1
   select case (order)
   case (0)
      call ExtLd_CopyInput(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call ExtLd_Input_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call ExtLd_Input_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(u) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE ExtLd_Input_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

   TYPE(ExtLd_InputType), INTENT(INOUT)  :: u1    ! Input at t1 > t2
   TYPE(ExtLd_InputType), INTENT(INOUT)  :: u2    ! Input at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Inputs
   TYPE(ExtLd_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'ExtLd_Input_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   CALL ExtLdDX_Input_ExtrapInterp1( u1%DX_u, u2%DX_u, tin, u_out%DX_u, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   u_out%az = a1*u1%az + a2*u2%az
   CALL MeshExtrapInterp1(u1%TowerMotion, u2%TowerMotion, tin, u_out%TowerMotion, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp1(u1%HubMotion, u2%HubMotion, tin, u_out%HubMotion, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp1(u1%NacelleMotion, u2%NacelleMotion, tin, u_out%NacelleMotion, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   IF (ALLOCATED(u_out%BladeRootMotion) .AND. ALLOCATED(u1%BladeRootMotion)) THEN
      do i1 = lbound(u_out%BladeRootMotion,1),ubound(u_out%BladeRootMotion,1)
         CALL MeshExtrapInterp1(u1%BladeRootMotion(i1), u2%BladeRootMotion(i1), tin, u_out%BladeRootMotion(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(u_out%BladeMotion) .AND. ALLOCATED(u1%BladeMotion)) THEN
      do i1 = lbound(u_out%BladeMotion,1),ubound(u_out%BladeMotion,1)
         CALL MeshExtrapInterp1(u1%BladeMotion(i1), u2%BladeMotion(i1), tin, u_out%BladeMotion(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
END SUBROUTINE

SUBROUTINE ExtLd_Input_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

   TYPE(ExtLd_InputType), INTENT(INOUT)  :: u1      ! Input at t1 > t2 > t3
   TYPE(ExtLd_InputType), INTENT(INOUT)  :: u2      ! Input at t2 > t3
   TYPE(ExtLd_InputType), INTENT(INOUT)  :: u3      ! Input at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Inputs
   TYPE(ExtLd_InputType), INTENT(INOUT)  :: u_out     ! Input at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'ExtLd_Input_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   CALL ExtLdDX_Input_ExtrapInterp2( u1%DX_u, u2%DX_u, u3%DX_u, tin, u_out%DX_u, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   u_out%az = a1*u1%az + a2*u2%az + a3*u3%az
   CALL MeshExtrapInterp2(u1%TowerMotion, u2%TowerMotion, u3%TowerMotion, tin, u_out%TowerMotion, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp2(u1%HubMotion, u2%HubMotion, u3%HubMotion, tin, u_out%HubMotion, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp2(u1%NacelleMotion, u2%NacelleMotion, u3%NacelleMotion, tin, u_out%NacelleMotion, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   IF (ALLOCATED(u_out%BladeRootMotion) .AND. ALLOCATED(u1%BladeRootMotion)) THEN
      do i1 = lbound(u_out%BladeRootMotion,1),ubound(u_out%BladeRootMotion,1)
         CALL MeshExtrapInterp2(u1%BladeRootMotion(i1), u2%BladeRootMotion(i1), u3%BladeRootMotion(i1), tin, u_out%BladeRootMotion(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(u_out%BladeMotion) .AND. ALLOCATED(u1%BladeMotion)) THEN
      do i1 = lbound(u_out%BladeMotion,1),ubound(u_out%BladeMotion,1)
         CALL MeshExtrapInterp2(u1%BladeMotion(i1), u2%BladeMotion(i1), u3%BladeMotion(i1), tin, u_out%BladeMotion(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
END SUBROUTINE

subroutine ExtLd_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
   ! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(ExtLd_OutputType), intent(inout)  :: y(:) ! Output at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Outputs
   type(ExtLd_OutputType), intent(inout)  :: y_out ! Output at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'ExtLd_Output_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(y)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(y)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(y) - 1
   select case (order)
   case (0)
      call ExtLd_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call ExtLd_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call ExtLd_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(y) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE ExtLd_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

   TYPE(ExtLd_OutputType), INTENT(INOUT)  :: y1    ! Output at t1 > t2
   TYPE(ExtLd_OutputType), INTENT(INOUT)  :: y2    ! Output at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
   TYPE(ExtLd_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'ExtLd_Output_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   CALL ExtLdDX_Output_ExtrapInterp1( y1%DX_y, y2%DX_y, tin, y_out%DX_y, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp1(y1%TowerLoad, y2%TowerLoad, tin, y_out%TowerLoad, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   IF (ALLOCATED(y_out%BladeLoad) .AND. ALLOCATED(y1%BladeLoad)) THEN
      do i1 = lbound(y_out%BladeLoad,1),ubound(y_out%BladeLoad,1)
         CALL MeshExtrapInterp1(y1%BladeLoad(i1), y2%BladeLoad(i1), tin, y_out%BladeLoad(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   CALL MeshExtrapInterp1(y1%TowerLoadAD, y2%TowerLoadAD, tin, y_out%TowerLoadAD, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   IF (ALLOCATED(y_out%BladeLoadAD) .AND. ALLOCATED(y1%BladeLoadAD)) THEN
      do i1 = lbound(y_out%BladeLoadAD,1),ubound(y_out%BladeLoadAD,1)
         CALL MeshExtrapInterp1(y1%BladeLoadAD(i1), y2%BladeLoadAD(i1), tin, y_out%BladeLoadAD(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
END SUBROUTINE

SUBROUTINE ExtLd_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

   TYPE(ExtLd_OutputType), INTENT(INOUT)  :: y1      ! Output at t1 > t2 > t3
   TYPE(ExtLd_OutputType), INTENT(INOUT)  :: y2      ! Output at t2 > t3
   TYPE(ExtLd_OutputType), INTENT(INOUT)  :: y3      ! Output at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
   TYPE(ExtLd_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'ExtLd_Output_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   CALL ExtLdDX_Output_ExtrapInterp2( y1%DX_y, y2%DX_y, y3%DX_y, tin, y_out%DX_y, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp2(y1%TowerLoad, y2%TowerLoad, y3%TowerLoad, tin, y_out%TowerLoad, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   IF (ALLOCATED(y_out%BladeLoad) .AND. ALLOCATED(y1%BladeLoad)) THEN
      do i1 = lbound(y_out%BladeLoad,1),ubound(y_out%BladeLoad,1)
         CALL MeshExtrapInterp2(y1%BladeLoad(i1), y2%BladeLoad(i1), y3%BladeLoad(i1), tin, y_out%BladeLoad(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   CALL MeshExtrapInterp2(y1%TowerLoadAD, y2%TowerLoadAD, y3%TowerLoadAD, tin, y_out%TowerLoadAD, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   IF (ALLOCATED(y_out%BladeLoadAD) .AND. ALLOCATED(y1%BladeLoadAD)) THEN
      do i1 = lbound(y_out%BladeLoadAD,1),ubound(y_out%BladeLoadAD,1)
         CALL MeshExtrapInterp2(y1%BladeLoadAD(i1), y2%BladeLoadAD(i1), y3%BladeLoadAD(i1), tin, y_out%BladeLoadAD(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
END SUBROUTINE
END MODULE ExtLoads_Types
!ENDOFREGISTRYGENERATEDFILE
