!STARTOFREGISTRYGENERATEDFILE 'ExtLoadsDX_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! ExtLoadsDX_Types
!.................................................................................................................................
! This file is part of ExtLoadsDX.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in ExtLoadsDX. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE ExtLoadsDX_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE NWTC_Library
IMPLICIT NONE
! =========  ExtLdDX_InputType_C  =======
  TYPE, BIND(C) :: ExtLdDX_InputType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    TYPE(C_ptr) :: twrDef = C_NULL_PTR 
    INTEGER(C_int) :: twrDef_Len = 0 
    TYPE(C_ptr) :: bldDef = C_NULL_PTR 
    INTEGER(C_int) :: bldDef_Len = 0 
    TYPE(C_ptr) :: hubDef = C_NULL_PTR 
    INTEGER(C_int) :: hubDef_Len = 0 
    TYPE(C_ptr) :: nacDef = C_NULL_PTR 
    INTEGER(C_int) :: nacDef_Len = 0 
    TYPE(C_ptr) :: bldRootDef = C_NULL_PTR 
    INTEGER(C_int) :: bldRootDef_Len = 0 
    TYPE(C_ptr) :: bldPitch = C_NULL_PTR 
    INTEGER(C_int) :: bldPitch_Len = 0 
  END TYPE ExtLdDX_InputType_C
  TYPE, PUBLIC :: ExtLdDX_InputType
    TYPE( ExtLdDX_InputType_C ) :: C_obj
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: twrDef => NULL()      !< Deformations on the tower  - to send to external driver [-]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: bldDef => NULL()      !< Deformations on all blades - to send to external driver [-]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: hubDef => NULL()      !< Deformations on the hub  - to send to external driver [-]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: nacDef => NULL()      !< Deformations the nacelle - to send to external driver [-]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: bldRootDef => NULL()      !< Deformations of the blade root nodes - to send to external driver [-]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: bldPitch => NULL()      !< Pitch angle of blade [-]
  END TYPE ExtLdDX_InputType
! =======================
! =========  ExtLdDX_ParameterType_C  =======
  TYPE, BIND(C) :: ExtLdDX_ParameterType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    TYPE(C_ptr) :: nBlades = C_NULL_PTR 
    INTEGER(C_int) :: nBlades_Len = 0 
    TYPE(C_ptr) :: nBladeNodes = C_NULL_PTR 
    INTEGER(C_int) :: nBladeNodes_Len = 0 
    TYPE(C_ptr) :: nTowerNodes = C_NULL_PTR 
    INTEGER(C_int) :: nTowerNodes_Len = 0 
    TYPE(C_ptr) :: twrRefPos = C_NULL_PTR 
    INTEGER(C_int) :: twrRefPos_Len = 0 
    TYPE(C_ptr) :: bldRefPos = C_NULL_PTR 
    INTEGER(C_int) :: bldRefPos_Len = 0 
    TYPE(C_ptr) :: hubRefPos = C_NULL_PTR 
    INTEGER(C_int) :: hubRefPos_Len = 0 
    TYPE(C_ptr) :: nacRefPos = C_NULL_PTR 
    INTEGER(C_int) :: nacRefPos_Len = 0 
    TYPE(C_ptr) :: bldRootRefPos = C_NULL_PTR 
    INTEGER(C_int) :: bldRootRefPos_Len = 0 
    TYPE(C_ptr) :: bldChord = C_NULL_PTR 
    INTEGER(C_int) :: bldChord_Len = 0 
    TYPE(C_ptr) :: bldRloc = C_NULL_PTR 
    INTEGER(C_int) :: bldRloc_Len = 0 
    TYPE(C_ptr) :: twrDia = C_NULL_PTR 
    INTEGER(C_int) :: twrDia_Len = 0 
    TYPE(C_ptr) :: twrHloc = C_NULL_PTR 
    INTEGER(C_int) :: twrHloc_Len = 0 
  END TYPE ExtLdDX_ParameterType_C
  TYPE, PUBLIC :: ExtLdDX_ParameterType
    TYPE( ExtLdDX_ParameterType_C ) :: C_obj
    INTEGER(KIND=C_INT) , DIMENSION(:), POINTER  :: nBlades => NULL()      !< Number of blades [-]
    INTEGER(KIND=C_INT) , DIMENSION(:), POINTER  :: nBladeNodes => NULL()      !< Number of blade nodes for each blade [-]
    INTEGER(KIND=C_INT) , DIMENSION(:), POINTER  :: nTowerNodes => NULL()      !< Number of tower nodes for each blade [-]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: twrRefPos => NULL()      !< Reference position of the tower nodes - to send to external driver [-]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: bldRefPos => NULL()      !< Reference position of the all blade nodes - to send to external driver [-]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: hubRefPos => NULL()      !< Reference position of the tower nodes - to send to external driver [-]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: nacRefPos => NULL()      !< Reference position of the all blade nodes - to send to external driver [-]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: bldRootRefPos => NULL()      !< Reference position of the blade root nodes - to send to external driver [-]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: bldChord => NULL()      !< Blade chord [m]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: bldRloc => NULL()      !< Radial location along the blade [m]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: twrDia => NULL()      !< Tower diameter [m]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: twrHloc => NULL()      !< Height location along the tower [m]
  END TYPE ExtLdDX_ParameterType
! =======================
! =========  ExtLdDX_OutputType_C  =======
  TYPE, BIND(C) :: ExtLdDX_OutputType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    TYPE(C_ptr) :: twrLd = C_NULL_PTR 
    INTEGER(C_int) :: twrLd_Len = 0 
    TYPE(C_ptr) :: bldLd = C_NULL_PTR 
    INTEGER(C_int) :: bldLd_Len = 0 
  END TYPE ExtLdDX_OutputType_C
  TYPE, PUBLIC :: ExtLdDX_OutputType
    TYPE( ExtLdDX_OutputType_C ) :: C_obj
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: twrLd => NULL()      !< Loads on the tower  - Externally supplied [-]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: bldLd => NULL()      !< Loads on all blades - Externally supplied [-]
  END TYPE ExtLdDX_OutputType
! =======================
CONTAINS

subroutine ExtLdDX_CopyInput(SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg)
   type(ExtLdDX_InputType), intent(in) :: SrcInputData
   type(ExtLdDX_InputType), intent(inout) :: DstInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'ExtLdDX_CopyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (associated(SrcInputData%twrDef)) then
      LB(1:1) = lbound(SrcInputData%twrDef)
      UB(1:1) = ubound(SrcInputData%twrDef)
      if (.not. associated(DstInputData%twrDef)) then
         allocate(DstInputData%twrDef(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%twrDef.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstInputData%C_obj%twrDef_Len = size(DstInputData%twrDef)
         if (DstInputData%C_obj%twrDef_Len > 0) &
            DstInputData%C_obj%twrDef = c_loc(DstInputData%twrDef(LB(1)))
      end if
      DstInputData%twrDef = SrcInputData%twrDef
   end if
   if (associated(SrcInputData%bldDef)) then
      LB(1:1) = lbound(SrcInputData%bldDef)
      UB(1:1) = ubound(SrcInputData%bldDef)
      if (.not. associated(DstInputData%bldDef)) then
         allocate(DstInputData%bldDef(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%bldDef.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstInputData%C_obj%bldDef_Len = size(DstInputData%bldDef)
         if (DstInputData%C_obj%bldDef_Len > 0) &
            DstInputData%C_obj%bldDef = c_loc(DstInputData%bldDef(LB(1)))
      end if
      DstInputData%bldDef = SrcInputData%bldDef
   end if
   if (associated(SrcInputData%hubDef)) then
      LB(1:1) = lbound(SrcInputData%hubDef)
      UB(1:1) = ubound(SrcInputData%hubDef)
      if (.not. associated(DstInputData%hubDef)) then
         allocate(DstInputData%hubDef(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%hubDef.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstInputData%C_obj%hubDef_Len = size(DstInputData%hubDef)
         if (DstInputData%C_obj%hubDef_Len > 0) &
            DstInputData%C_obj%hubDef = c_loc(DstInputData%hubDef(LB(1)))
      end if
      DstInputData%hubDef = SrcInputData%hubDef
   end if
   if (associated(SrcInputData%nacDef)) then
      LB(1:1) = lbound(SrcInputData%nacDef)
      UB(1:1) = ubound(SrcInputData%nacDef)
      if (.not. associated(DstInputData%nacDef)) then
         allocate(DstInputData%nacDef(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%nacDef.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstInputData%C_obj%nacDef_Len = size(DstInputData%nacDef)
         if (DstInputData%C_obj%nacDef_Len > 0) &
            DstInputData%C_obj%nacDef = c_loc(DstInputData%nacDef(LB(1)))
      end if
      DstInputData%nacDef = SrcInputData%nacDef
   end if
   if (associated(SrcInputData%bldRootDef)) then
      LB(1:1) = lbound(SrcInputData%bldRootDef)
      UB(1:1) = ubound(SrcInputData%bldRootDef)
      if (.not. associated(DstInputData%bldRootDef)) then
         allocate(DstInputData%bldRootDef(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%bldRootDef.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstInputData%C_obj%bldRootDef_Len = size(DstInputData%bldRootDef)
         if (DstInputData%C_obj%bldRootDef_Len > 0) &
            DstInputData%C_obj%bldRootDef = c_loc(DstInputData%bldRootDef(LB(1)))
      end if
      DstInputData%bldRootDef = SrcInputData%bldRootDef
   end if
   if (associated(SrcInputData%bldPitch)) then
      LB(1:1) = lbound(SrcInputData%bldPitch)
      UB(1:1) = ubound(SrcInputData%bldPitch)
      if (.not. associated(DstInputData%bldPitch)) then
         allocate(DstInputData%bldPitch(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%bldPitch.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstInputData%C_obj%bldPitch_Len = size(DstInputData%bldPitch)
         if (DstInputData%C_obj%bldPitch_Len > 0) &
            DstInputData%C_obj%bldPitch = c_loc(DstInputData%bldPitch(LB(1)))
      end if
      DstInputData%bldPitch = SrcInputData%bldPitch
   end if
end subroutine

subroutine ExtLdDX_DestroyInput(InputData, ErrStat, ErrMsg)
   type(ExtLdDX_InputType), intent(inout) :: InputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ExtLdDX_DestroyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (associated(InputData%twrDef)) then
      deallocate(InputData%twrDef)
      InputData%twrDef => null()
      InputData%C_obj%twrDef = c_null_ptr
      InputData%C_obj%twrDef_Len = 0
   end if
   if (associated(InputData%bldDef)) then
      deallocate(InputData%bldDef)
      InputData%bldDef => null()
      InputData%C_obj%bldDef = c_null_ptr
      InputData%C_obj%bldDef_Len = 0
   end if
   if (associated(InputData%hubDef)) then
      deallocate(InputData%hubDef)
      InputData%hubDef => null()
      InputData%C_obj%hubDef = c_null_ptr
      InputData%C_obj%hubDef_Len = 0
   end if
   if (associated(InputData%nacDef)) then
      deallocate(InputData%nacDef)
      InputData%nacDef => null()
      InputData%C_obj%nacDef = c_null_ptr
      InputData%C_obj%nacDef_Len = 0
   end if
   if (associated(InputData%bldRootDef)) then
      deallocate(InputData%bldRootDef)
      InputData%bldRootDef => null()
      InputData%C_obj%bldRootDef = c_null_ptr
      InputData%C_obj%bldRootDef_Len = 0
   end if
   if (associated(InputData%bldPitch)) then
      deallocate(InputData%bldPitch)
      InputData%bldPitch => null()
      InputData%C_obj%bldPitch = c_null_ptr
      InputData%C_obj%bldPitch_Len = 0
   end if
end subroutine

subroutine ExtLdDX_PackInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ExtLdDX_InputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ExtLdDX_PackInput'
   logical         :: PtrInIndex
   if (RF%ErrStat >= AbortErrLev) return
   if (c_associated(InData%C_obj%object)) then
      RF%ErrStat = ErrID_Fatal
      RF%ErrMsg = RoutineName//': C_obj%object cannot be packed.'
      return
   end if
   call RegPackPtr(RF, InData%twrDef)
   call RegPackPtr(RF, InData%bldDef)
   call RegPackPtr(RF, InData%hubDef)
   call RegPackPtr(RF, InData%nacDef)
   call RegPackPtr(RF, InData%bldRootDef)
   call RegPackPtr(RF, InData%bldPitch)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtLdDX_UnPackInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ExtLdDX_InputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ExtLdDX_UnPackInput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   integer(B8Ki)   :: PtrIdx
   type(c_ptr)     :: Ptr
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackPtr(RF, OutData%twrDef, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%twrDef)) then
      OutData%C_obj%twrDef_Len = size(OutData%twrDef)
      if (OutData%C_obj%twrDef_Len > 0) OutData%C_obj%twrDef = c_loc(OutData%twrDef(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%bldDef, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%bldDef)) then
      OutData%C_obj%bldDef_Len = size(OutData%bldDef)
      if (OutData%C_obj%bldDef_Len > 0) OutData%C_obj%bldDef = c_loc(OutData%bldDef(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%hubDef, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%hubDef)) then
      OutData%C_obj%hubDef_Len = size(OutData%hubDef)
      if (OutData%C_obj%hubDef_Len > 0) OutData%C_obj%hubDef = c_loc(OutData%hubDef(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%nacDef, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%nacDef)) then
      OutData%C_obj%nacDef_Len = size(OutData%nacDef)
      if (OutData%C_obj%nacDef_Len > 0) OutData%C_obj%nacDef = c_loc(OutData%nacDef(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%bldRootDef, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%bldRootDef)) then
      OutData%C_obj%bldRootDef_Len = size(OutData%bldRootDef)
      if (OutData%C_obj%bldRootDef_Len > 0) OutData%C_obj%bldRootDef = c_loc(OutData%bldRootDef(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%bldPitch, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%bldPitch)) then
      OutData%C_obj%bldPitch_Len = size(OutData%bldPitch)
      if (OutData%C_obj%bldPitch_Len > 0) OutData%C_obj%bldPitch = c_loc(OutData%bldPitch(LB(1)))
   end if
end subroutine

SUBROUTINE ExtLdDX_C2Fary_CopyInput(InputData, ErrStat, ErrMsg, SkipPointers)
   TYPE(ExtLdDX_InputType), INTENT(INOUT) :: InputData
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
   LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
   ! 
   LOGICAL                        :: SkipPointers_local
   ErrStat = ErrID_None
   ErrMsg  = ""
   
   IF (PRESENT(SkipPointers)) THEN
      SkipPointers_local = SkipPointers
   ELSE
      SkipPointers_local = .false.
   END IF
   
   ! -- twrDef Input Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( InputData%C_obj%twrDef ) ) THEN
         NULLIFY( InputData%twrDef )
      ELSE
         CALL C_F_POINTER(InputData%C_obj%twrDef, InputData%twrDef, [InputData%C_obj%twrDef_Len])
      END IF
   END IF
   
   ! -- bldDef Input Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( InputData%C_obj%bldDef ) ) THEN
         NULLIFY( InputData%bldDef )
      ELSE
         CALL C_F_POINTER(InputData%C_obj%bldDef, InputData%bldDef, [InputData%C_obj%bldDef_Len])
      END IF
   END IF
   
   ! -- hubDef Input Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( InputData%C_obj%hubDef ) ) THEN
         NULLIFY( InputData%hubDef )
      ELSE
         CALL C_F_POINTER(InputData%C_obj%hubDef, InputData%hubDef, [InputData%C_obj%hubDef_Len])
      END IF
   END IF
   
   ! -- nacDef Input Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( InputData%C_obj%nacDef ) ) THEN
         NULLIFY( InputData%nacDef )
      ELSE
         CALL C_F_POINTER(InputData%C_obj%nacDef, InputData%nacDef, [InputData%C_obj%nacDef_Len])
      END IF
   END IF
   
   ! -- bldRootDef Input Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( InputData%C_obj%bldRootDef ) ) THEN
         NULLIFY( InputData%bldRootDef )
      ELSE
         CALL C_F_POINTER(InputData%C_obj%bldRootDef, InputData%bldRootDef, [InputData%C_obj%bldRootDef_Len])
      END IF
   END IF
   
   ! -- bldPitch Input Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( InputData%C_obj%bldPitch ) ) THEN
         NULLIFY( InputData%bldPitch )
      ELSE
         CALL C_F_POINTER(InputData%C_obj%bldPitch, InputData%bldPitch, [InputData%C_obj%bldPitch_Len])
      END IF
   END IF
END SUBROUTINE

SUBROUTINE ExtLdDX_F2C_CopyInput( InputData, ErrStat, ErrMsg, SkipPointers  )
   TYPE(ExtLdDX_InputType), INTENT(INOUT) :: InputData
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
   LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
   ! 
   LOGICAL                        :: SkipPointers_local
   ErrStat = ErrID_None
   ErrMsg  = ''
   
   IF (PRESENT(SkipPointers)) THEN
      SkipPointers_local = SkipPointers
   ELSE
      SkipPointers_local = .false.
   END IF
   
   ! -- twrDef Input Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(InputData%twrDef)) THEN 
         InputData%C_obj%twrDef_Len = 0
         InputData%C_obj%twrDef = C_NULL_PTR
      ELSE
         InputData%C_obj%twrDef_Len = SIZE(InputData%twrDef)
         IF (InputData%C_obj%twrDef_Len > 0) &
            InputData%C_obj%twrDef = C_LOC(InputData%twrDef(lbound(InputData%twrDef,1)))
      END IF
   END IF
   
   ! -- bldDef Input Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(InputData%bldDef)) THEN 
         InputData%C_obj%bldDef_Len = 0
         InputData%C_obj%bldDef = C_NULL_PTR
      ELSE
         InputData%C_obj%bldDef_Len = SIZE(InputData%bldDef)
         IF (InputData%C_obj%bldDef_Len > 0) &
            InputData%C_obj%bldDef = C_LOC(InputData%bldDef(lbound(InputData%bldDef,1)))
      END IF
   END IF
   
   ! -- hubDef Input Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(InputData%hubDef)) THEN 
         InputData%C_obj%hubDef_Len = 0
         InputData%C_obj%hubDef = C_NULL_PTR
      ELSE
         InputData%C_obj%hubDef_Len = SIZE(InputData%hubDef)
         IF (InputData%C_obj%hubDef_Len > 0) &
            InputData%C_obj%hubDef = C_LOC(InputData%hubDef(lbound(InputData%hubDef,1)))
      END IF
   END IF
   
   ! -- nacDef Input Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(InputData%nacDef)) THEN 
         InputData%C_obj%nacDef_Len = 0
         InputData%C_obj%nacDef = C_NULL_PTR
      ELSE
         InputData%C_obj%nacDef_Len = SIZE(InputData%nacDef)
         IF (InputData%C_obj%nacDef_Len > 0) &
            InputData%C_obj%nacDef = C_LOC(InputData%nacDef(lbound(InputData%nacDef,1)))
      END IF
   END IF
   
   ! -- bldRootDef Input Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(InputData%bldRootDef)) THEN 
         InputData%C_obj%bldRootDef_Len = 0
         InputData%C_obj%bldRootDef = C_NULL_PTR
      ELSE
         InputData%C_obj%bldRootDef_Len = SIZE(InputData%bldRootDef)
         IF (InputData%C_obj%bldRootDef_Len > 0) &
            InputData%C_obj%bldRootDef = C_LOC(InputData%bldRootDef(lbound(InputData%bldRootDef,1)))
      END IF
   END IF
   
   ! -- bldPitch Input Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(InputData%bldPitch)) THEN 
         InputData%C_obj%bldPitch_Len = 0
         InputData%C_obj%bldPitch = C_NULL_PTR
      ELSE
         InputData%C_obj%bldPitch_Len = SIZE(InputData%bldPitch)
         IF (InputData%C_obj%bldPitch_Len > 0) &
            InputData%C_obj%bldPitch = C_LOC(InputData%bldPitch(lbound(InputData%bldPitch,1)))
      END IF
   END IF
END SUBROUTINE

subroutine ExtLdDX_CopyParam(SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg)
   type(ExtLdDX_ParameterType), intent(in) :: SrcParamData
   type(ExtLdDX_ParameterType), intent(inout) :: DstParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'ExtLdDX_CopyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (associated(SrcParamData%nBlades)) then
      LB(1:1) = lbound(SrcParamData%nBlades)
      UB(1:1) = ubound(SrcParamData%nBlades)
      if (.not. associated(DstParamData%nBlades)) then
         allocate(DstParamData%nBlades(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%nBlades.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstParamData%C_obj%nBlades_Len = size(DstParamData%nBlades)
         if (DstParamData%C_obj%nBlades_Len > 0) &
            DstParamData%C_obj%nBlades = c_loc(DstParamData%nBlades(LB(1)))
      end if
      DstParamData%nBlades = SrcParamData%nBlades
   end if
   if (associated(SrcParamData%nBladeNodes)) then
      LB(1:1) = lbound(SrcParamData%nBladeNodes)
      UB(1:1) = ubound(SrcParamData%nBladeNodes)
      if (.not. associated(DstParamData%nBladeNodes)) then
         allocate(DstParamData%nBladeNodes(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%nBladeNodes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstParamData%C_obj%nBladeNodes_Len = size(DstParamData%nBladeNodes)
         if (DstParamData%C_obj%nBladeNodes_Len > 0) &
            DstParamData%C_obj%nBladeNodes = c_loc(DstParamData%nBladeNodes(LB(1)))
      end if
      DstParamData%nBladeNodes = SrcParamData%nBladeNodes
   end if
   if (associated(SrcParamData%nTowerNodes)) then
      LB(1:1) = lbound(SrcParamData%nTowerNodes)
      UB(1:1) = ubound(SrcParamData%nTowerNodes)
      if (.not. associated(DstParamData%nTowerNodes)) then
         allocate(DstParamData%nTowerNodes(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%nTowerNodes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstParamData%C_obj%nTowerNodes_Len = size(DstParamData%nTowerNodes)
         if (DstParamData%C_obj%nTowerNodes_Len > 0) &
            DstParamData%C_obj%nTowerNodes = c_loc(DstParamData%nTowerNodes(LB(1)))
      end if
      DstParamData%nTowerNodes = SrcParamData%nTowerNodes
   end if
   if (associated(SrcParamData%twrRefPos)) then
      LB(1:1) = lbound(SrcParamData%twrRefPos)
      UB(1:1) = ubound(SrcParamData%twrRefPos)
      if (.not. associated(DstParamData%twrRefPos)) then
         allocate(DstParamData%twrRefPos(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%twrRefPos.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstParamData%C_obj%twrRefPos_Len = size(DstParamData%twrRefPos)
         if (DstParamData%C_obj%twrRefPos_Len > 0) &
            DstParamData%C_obj%twrRefPos = c_loc(DstParamData%twrRefPos(LB(1)))
      end if
      DstParamData%twrRefPos = SrcParamData%twrRefPos
   end if
   if (associated(SrcParamData%bldRefPos)) then
      LB(1:1) = lbound(SrcParamData%bldRefPos)
      UB(1:1) = ubound(SrcParamData%bldRefPos)
      if (.not. associated(DstParamData%bldRefPos)) then
         allocate(DstParamData%bldRefPos(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%bldRefPos.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstParamData%C_obj%bldRefPos_Len = size(DstParamData%bldRefPos)
         if (DstParamData%C_obj%bldRefPos_Len > 0) &
            DstParamData%C_obj%bldRefPos = c_loc(DstParamData%bldRefPos(LB(1)))
      end if
      DstParamData%bldRefPos = SrcParamData%bldRefPos
   end if
   if (associated(SrcParamData%hubRefPos)) then
      LB(1:1) = lbound(SrcParamData%hubRefPos)
      UB(1:1) = ubound(SrcParamData%hubRefPos)
      if (.not. associated(DstParamData%hubRefPos)) then
         allocate(DstParamData%hubRefPos(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%hubRefPos.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstParamData%C_obj%hubRefPos_Len = size(DstParamData%hubRefPos)
         if (DstParamData%C_obj%hubRefPos_Len > 0) &
            DstParamData%C_obj%hubRefPos = c_loc(DstParamData%hubRefPos(LB(1)))
      end if
      DstParamData%hubRefPos = SrcParamData%hubRefPos
   end if
   if (associated(SrcParamData%nacRefPos)) then
      LB(1:1) = lbound(SrcParamData%nacRefPos)
      UB(1:1) = ubound(SrcParamData%nacRefPos)
      if (.not. associated(DstParamData%nacRefPos)) then
         allocate(DstParamData%nacRefPos(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%nacRefPos.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstParamData%C_obj%nacRefPos_Len = size(DstParamData%nacRefPos)
         if (DstParamData%C_obj%nacRefPos_Len > 0) &
            DstParamData%C_obj%nacRefPos = c_loc(DstParamData%nacRefPos(LB(1)))
      end if
      DstParamData%nacRefPos = SrcParamData%nacRefPos
   end if
   if (associated(SrcParamData%bldRootRefPos)) then
      LB(1:1) = lbound(SrcParamData%bldRootRefPos)
      UB(1:1) = ubound(SrcParamData%bldRootRefPos)
      if (.not. associated(DstParamData%bldRootRefPos)) then
         allocate(DstParamData%bldRootRefPos(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%bldRootRefPos.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstParamData%C_obj%bldRootRefPos_Len = size(DstParamData%bldRootRefPos)
         if (DstParamData%C_obj%bldRootRefPos_Len > 0) &
            DstParamData%C_obj%bldRootRefPos = c_loc(DstParamData%bldRootRefPos(LB(1)))
      end if
      DstParamData%bldRootRefPos = SrcParamData%bldRootRefPos
   end if
   if (associated(SrcParamData%bldChord)) then
      LB(1:1) = lbound(SrcParamData%bldChord)
      UB(1:1) = ubound(SrcParamData%bldChord)
      if (.not. associated(DstParamData%bldChord)) then
         allocate(DstParamData%bldChord(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%bldChord.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstParamData%C_obj%bldChord_Len = size(DstParamData%bldChord)
         if (DstParamData%C_obj%bldChord_Len > 0) &
            DstParamData%C_obj%bldChord = c_loc(DstParamData%bldChord(LB(1)))
      end if
      DstParamData%bldChord = SrcParamData%bldChord
   end if
   if (associated(SrcParamData%bldRloc)) then
      LB(1:1) = lbound(SrcParamData%bldRloc)
      UB(1:1) = ubound(SrcParamData%bldRloc)
      if (.not. associated(DstParamData%bldRloc)) then
         allocate(DstParamData%bldRloc(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%bldRloc.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstParamData%C_obj%bldRloc_Len = size(DstParamData%bldRloc)
         if (DstParamData%C_obj%bldRloc_Len > 0) &
            DstParamData%C_obj%bldRloc = c_loc(DstParamData%bldRloc(LB(1)))
      end if
      DstParamData%bldRloc = SrcParamData%bldRloc
   end if
   if (associated(SrcParamData%twrDia)) then
      LB(1:1) = lbound(SrcParamData%twrDia)
      UB(1:1) = ubound(SrcParamData%twrDia)
      if (.not. associated(DstParamData%twrDia)) then
         allocate(DstParamData%twrDia(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%twrDia.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstParamData%C_obj%twrDia_Len = size(DstParamData%twrDia)
         if (DstParamData%C_obj%twrDia_Len > 0) &
            DstParamData%C_obj%twrDia = c_loc(DstParamData%twrDia(LB(1)))
      end if
      DstParamData%twrDia = SrcParamData%twrDia
   end if
   if (associated(SrcParamData%twrHloc)) then
      LB(1:1) = lbound(SrcParamData%twrHloc)
      UB(1:1) = ubound(SrcParamData%twrHloc)
      if (.not. associated(DstParamData%twrHloc)) then
         allocate(DstParamData%twrHloc(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%twrHloc.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstParamData%C_obj%twrHloc_Len = size(DstParamData%twrHloc)
         if (DstParamData%C_obj%twrHloc_Len > 0) &
            DstParamData%C_obj%twrHloc = c_loc(DstParamData%twrHloc(LB(1)))
      end if
      DstParamData%twrHloc = SrcParamData%twrHloc
   end if
end subroutine

subroutine ExtLdDX_DestroyParam(ParamData, ErrStat, ErrMsg)
   type(ExtLdDX_ParameterType), intent(inout) :: ParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ExtLdDX_DestroyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (associated(ParamData%nBlades)) then
      deallocate(ParamData%nBlades)
      ParamData%nBlades => null()
      ParamData%C_obj%nBlades = c_null_ptr
      ParamData%C_obj%nBlades_Len = 0
   end if
   if (associated(ParamData%nBladeNodes)) then
      deallocate(ParamData%nBladeNodes)
      ParamData%nBladeNodes => null()
      ParamData%C_obj%nBladeNodes = c_null_ptr
      ParamData%C_obj%nBladeNodes_Len = 0
   end if
   if (associated(ParamData%nTowerNodes)) then
      deallocate(ParamData%nTowerNodes)
      ParamData%nTowerNodes => null()
      ParamData%C_obj%nTowerNodes = c_null_ptr
      ParamData%C_obj%nTowerNodes_Len = 0
   end if
   if (associated(ParamData%twrRefPos)) then
      deallocate(ParamData%twrRefPos)
      ParamData%twrRefPos => null()
      ParamData%C_obj%twrRefPos = c_null_ptr
      ParamData%C_obj%twrRefPos_Len = 0
   end if
   if (associated(ParamData%bldRefPos)) then
      deallocate(ParamData%bldRefPos)
      ParamData%bldRefPos => null()
      ParamData%C_obj%bldRefPos = c_null_ptr
      ParamData%C_obj%bldRefPos_Len = 0
   end if
   if (associated(ParamData%hubRefPos)) then
      deallocate(ParamData%hubRefPos)
      ParamData%hubRefPos => null()
      ParamData%C_obj%hubRefPos = c_null_ptr
      ParamData%C_obj%hubRefPos_Len = 0
   end if
   if (associated(ParamData%nacRefPos)) then
      deallocate(ParamData%nacRefPos)
      ParamData%nacRefPos => null()
      ParamData%C_obj%nacRefPos = c_null_ptr
      ParamData%C_obj%nacRefPos_Len = 0
   end if
   if (associated(ParamData%bldRootRefPos)) then
      deallocate(ParamData%bldRootRefPos)
      ParamData%bldRootRefPos => null()
      ParamData%C_obj%bldRootRefPos = c_null_ptr
      ParamData%C_obj%bldRootRefPos_Len = 0
   end if
   if (associated(ParamData%bldChord)) then
      deallocate(ParamData%bldChord)
      ParamData%bldChord => null()
      ParamData%C_obj%bldChord = c_null_ptr
      ParamData%C_obj%bldChord_Len = 0
   end if
   if (associated(ParamData%bldRloc)) then
      deallocate(ParamData%bldRloc)
      ParamData%bldRloc => null()
      ParamData%C_obj%bldRloc = c_null_ptr
      ParamData%C_obj%bldRloc_Len = 0
   end if
   if (associated(ParamData%twrDia)) then
      deallocate(ParamData%twrDia)
      ParamData%twrDia => null()
      ParamData%C_obj%twrDia = c_null_ptr
      ParamData%C_obj%twrDia_Len = 0
   end if
   if (associated(ParamData%twrHloc)) then
      deallocate(ParamData%twrHloc)
      ParamData%twrHloc => null()
      ParamData%C_obj%twrHloc = c_null_ptr
      ParamData%C_obj%twrHloc_Len = 0
   end if
end subroutine

subroutine ExtLdDX_PackParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ExtLdDX_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ExtLdDX_PackParam'
   logical         :: PtrInIndex
   if (RF%ErrStat >= AbortErrLev) return
   if (c_associated(InData%C_obj%object)) then
      RF%ErrStat = ErrID_Fatal
      RF%ErrMsg = RoutineName//': C_obj%object cannot be packed.'
      return
   end if
   call RegPackPtr(RF, InData%nBlades)
   call RegPackPtr(RF, InData%nBladeNodes)
   call RegPackPtr(RF, InData%nTowerNodes)
   call RegPackPtr(RF, InData%twrRefPos)
   call RegPackPtr(RF, InData%bldRefPos)
   call RegPackPtr(RF, InData%hubRefPos)
   call RegPackPtr(RF, InData%nacRefPos)
   call RegPackPtr(RF, InData%bldRootRefPos)
   call RegPackPtr(RF, InData%bldChord)
   call RegPackPtr(RF, InData%bldRloc)
   call RegPackPtr(RF, InData%twrDia)
   call RegPackPtr(RF, InData%twrHloc)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtLdDX_UnPackParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ExtLdDX_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ExtLdDX_UnPackParam'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   integer(B8Ki)   :: PtrIdx
   type(c_ptr)     :: Ptr
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackPtr(RF, OutData%nBlades, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%nBlades)) then
      OutData%C_obj%nBlades_Len = size(OutData%nBlades)
      if (OutData%C_obj%nBlades_Len > 0) OutData%C_obj%nBlades = c_loc(OutData%nBlades(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%nBladeNodes, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%nBladeNodes)) then
      OutData%C_obj%nBladeNodes_Len = size(OutData%nBladeNodes)
      if (OutData%C_obj%nBladeNodes_Len > 0) OutData%C_obj%nBladeNodes = c_loc(OutData%nBladeNodes(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%nTowerNodes, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%nTowerNodes)) then
      OutData%C_obj%nTowerNodes_Len = size(OutData%nTowerNodes)
      if (OutData%C_obj%nTowerNodes_Len > 0) OutData%C_obj%nTowerNodes = c_loc(OutData%nTowerNodes(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%twrRefPos, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%twrRefPos)) then
      OutData%C_obj%twrRefPos_Len = size(OutData%twrRefPos)
      if (OutData%C_obj%twrRefPos_Len > 0) OutData%C_obj%twrRefPos = c_loc(OutData%twrRefPos(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%bldRefPos, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%bldRefPos)) then
      OutData%C_obj%bldRefPos_Len = size(OutData%bldRefPos)
      if (OutData%C_obj%bldRefPos_Len > 0) OutData%C_obj%bldRefPos = c_loc(OutData%bldRefPos(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%hubRefPos, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%hubRefPos)) then
      OutData%C_obj%hubRefPos_Len = size(OutData%hubRefPos)
      if (OutData%C_obj%hubRefPos_Len > 0) OutData%C_obj%hubRefPos = c_loc(OutData%hubRefPos(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%nacRefPos, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%nacRefPos)) then
      OutData%C_obj%nacRefPos_Len = size(OutData%nacRefPos)
      if (OutData%C_obj%nacRefPos_Len > 0) OutData%C_obj%nacRefPos = c_loc(OutData%nacRefPos(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%bldRootRefPos, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%bldRootRefPos)) then
      OutData%C_obj%bldRootRefPos_Len = size(OutData%bldRootRefPos)
      if (OutData%C_obj%bldRootRefPos_Len > 0) OutData%C_obj%bldRootRefPos = c_loc(OutData%bldRootRefPos(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%bldChord, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%bldChord)) then
      OutData%C_obj%bldChord_Len = size(OutData%bldChord)
      if (OutData%C_obj%bldChord_Len > 0) OutData%C_obj%bldChord = c_loc(OutData%bldChord(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%bldRloc, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%bldRloc)) then
      OutData%C_obj%bldRloc_Len = size(OutData%bldRloc)
      if (OutData%C_obj%bldRloc_Len > 0) OutData%C_obj%bldRloc = c_loc(OutData%bldRloc(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%twrDia, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%twrDia)) then
      OutData%C_obj%twrDia_Len = size(OutData%twrDia)
      if (OutData%C_obj%twrDia_Len > 0) OutData%C_obj%twrDia = c_loc(OutData%twrDia(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%twrHloc, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%twrHloc)) then
      OutData%C_obj%twrHloc_Len = size(OutData%twrHloc)
      if (OutData%C_obj%twrHloc_Len > 0) OutData%C_obj%twrHloc = c_loc(OutData%twrHloc(LB(1)))
   end if
end subroutine

SUBROUTINE ExtLdDX_C2Fary_CopyParam(ParamData, ErrStat, ErrMsg, SkipPointers)
   TYPE(ExtLdDX_ParameterType), INTENT(INOUT) :: ParamData
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
   LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
   ! 
   LOGICAL                        :: SkipPointers_local
   ErrStat = ErrID_None
   ErrMsg  = ""
   
   IF (PRESENT(SkipPointers)) THEN
      SkipPointers_local = SkipPointers
   ELSE
      SkipPointers_local = .false.
   END IF
   
   ! -- nBlades Param Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( ParamData%C_obj%nBlades ) ) THEN
         NULLIFY( ParamData%nBlades )
      ELSE
         CALL C_F_POINTER(ParamData%C_obj%nBlades, ParamData%nBlades, [ParamData%C_obj%nBlades_Len])
      END IF
   END IF
   
   ! -- nBladeNodes Param Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( ParamData%C_obj%nBladeNodes ) ) THEN
         NULLIFY( ParamData%nBladeNodes )
      ELSE
         CALL C_F_POINTER(ParamData%C_obj%nBladeNodes, ParamData%nBladeNodes, [ParamData%C_obj%nBladeNodes_Len])
      END IF
   END IF
   
   ! -- nTowerNodes Param Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( ParamData%C_obj%nTowerNodes ) ) THEN
         NULLIFY( ParamData%nTowerNodes )
      ELSE
         CALL C_F_POINTER(ParamData%C_obj%nTowerNodes, ParamData%nTowerNodes, [ParamData%C_obj%nTowerNodes_Len])
      END IF
   END IF
   
   ! -- twrRefPos Param Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( ParamData%C_obj%twrRefPos ) ) THEN
         NULLIFY( ParamData%twrRefPos )
      ELSE
         CALL C_F_POINTER(ParamData%C_obj%twrRefPos, ParamData%twrRefPos, [ParamData%C_obj%twrRefPos_Len])
      END IF
   END IF
   
   ! -- bldRefPos Param Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( ParamData%C_obj%bldRefPos ) ) THEN
         NULLIFY( ParamData%bldRefPos )
      ELSE
         CALL C_F_POINTER(ParamData%C_obj%bldRefPos, ParamData%bldRefPos, [ParamData%C_obj%bldRefPos_Len])
      END IF
   END IF
   
   ! -- hubRefPos Param Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( ParamData%C_obj%hubRefPos ) ) THEN
         NULLIFY( ParamData%hubRefPos )
      ELSE
         CALL C_F_POINTER(ParamData%C_obj%hubRefPos, ParamData%hubRefPos, [ParamData%C_obj%hubRefPos_Len])
      END IF
   END IF
   
   ! -- nacRefPos Param Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( ParamData%C_obj%nacRefPos ) ) THEN
         NULLIFY( ParamData%nacRefPos )
      ELSE
         CALL C_F_POINTER(ParamData%C_obj%nacRefPos, ParamData%nacRefPos, [ParamData%C_obj%nacRefPos_Len])
      END IF
   END IF
   
   ! -- bldRootRefPos Param Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( ParamData%C_obj%bldRootRefPos ) ) THEN
         NULLIFY( ParamData%bldRootRefPos )
      ELSE
         CALL C_F_POINTER(ParamData%C_obj%bldRootRefPos, ParamData%bldRootRefPos, [ParamData%C_obj%bldRootRefPos_Len])
      END IF
   END IF
   
   ! -- bldChord Param Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( ParamData%C_obj%bldChord ) ) THEN
         NULLIFY( ParamData%bldChord )
      ELSE
         CALL C_F_POINTER(ParamData%C_obj%bldChord, ParamData%bldChord, [ParamData%C_obj%bldChord_Len])
      END IF
   END IF
   
   ! -- bldRloc Param Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( ParamData%C_obj%bldRloc ) ) THEN
         NULLIFY( ParamData%bldRloc )
      ELSE
         CALL C_F_POINTER(ParamData%C_obj%bldRloc, ParamData%bldRloc, [ParamData%C_obj%bldRloc_Len])
      END IF
   END IF
   
   ! -- twrDia Param Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( ParamData%C_obj%twrDia ) ) THEN
         NULLIFY( ParamData%twrDia )
      ELSE
         CALL C_F_POINTER(ParamData%C_obj%twrDia, ParamData%twrDia, [ParamData%C_obj%twrDia_Len])
      END IF
   END IF
   
   ! -- twrHloc Param Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( ParamData%C_obj%twrHloc ) ) THEN
         NULLIFY( ParamData%twrHloc )
      ELSE
         CALL C_F_POINTER(ParamData%C_obj%twrHloc, ParamData%twrHloc, [ParamData%C_obj%twrHloc_Len])
      END IF
   END IF
END SUBROUTINE

SUBROUTINE ExtLdDX_F2C_CopyParam( ParamData, ErrStat, ErrMsg, SkipPointers  )
   TYPE(ExtLdDX_ParameterType), INTENT(INOUT) :: ParamData
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
   LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
   ! 
   LOGICAL                        :: SkipPointers_local
   ErrStat = ErrID_None
   ErrMsg  = ''
   
   IF (PRESENT(SkipPointers)) THEN
      SkipPointers_local = SkipPointers
   ELSE
      SkipPointers_local = .false.
   END IF
   
   ! -- nBlades Param Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(ParamData%nBlades)) THEN 
         ParamData%C_obj%nBlades_Len = 0
         ParamData%C_obj%nBlades = C_NULL_PTR
      ELSE
         ParamData%C_obj%nBlades_Len = SIZE(ParamData%nBlades)
         IF (ParamData%C_obj%nBlades_Len > 0) &
            ParamData%C_obj%nBlades = C_LOC(ParamData%nBlades(lbound(ParamData%nBlades,1)))
      END IF
   END IF
   
   ! -- nBladeNodes Param Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(ParamData%nBladeNodes)) THEN 
         ParamData%C_obj%nBladeNodes_Len = 0
         ParamData%C_obj%nBladeNodes = C_NULL_PTR
      ELSE
         ParamData%C_obj%nBladeNodes_Len = SIZE(ParamData%nBladeNodes)
         IF (ParamData%C_obj%nBladeNodes_Len > 0) &
            ParamData%C_obj%nBladeNodes = C_LOC(ParamData%nBladeNodes(lbound(ParamData%nBladeNodes,1)))
      END IF
   END IF
   
   ! -- nTowerNodes Param Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(ParamData%nTowerNodes)) THEN 
         ParamData%C_obj%nTowerNodes_Len = 0
         ParamData%C_obj%nTowerNodes = C_NULL_PTR
      ELSE
         ParamData%C_obj%nTowerNodes_Len = SIZE(ParamData%nTowerNodes)
         IF (ParamData%C_obj%nTowerNodes_Len > 0) &
            ParamData%C_obj%nTowerNodes = C_LOC(ParamData%nTowerNodes(lbound(ParamData%nTowerNodes,1)))
      END IF
   END IF
   
   ! -- twrRefPos Param Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(ParamData%twrRefPos)) THEN 
         ParamData%C_obj%twrRefPos_Len = 0
         ParamData%C_obj%twrRefPos = C_NULL_PTR
      ELSE
         ParamData%C_obj%twrRefPos_Len = SIZE(ParamData%twrRefPos)
         IF (ParamData%C_obj%twrRefPos_Len > 0) &
            ParamData%C_obj%twrRefPos = C_LOC(ParamData%twrRefPos(lbound(ParamData%twrRefPos,1)))
      END IF
   END IF
   
   ! -- bldRefPos Param Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(ParamData%bldRefPos)) THEN 
         ParamData%C_obj%bldRefPos_Len = 0
         ParamData%C_obj%bldRefPos = C_NULL_PTR
      ELSE
         ParamData%C_obj%bldRefPos_Len = SIZE(ParamData%bldRefPos)
         IF (ParamData%C_obj%bldRefPos_Len > 0) &
            ParamData%C_obj%bldRefPos = C_LOC(ParamData%bldRefPos(lbound(ParamData%bldRefPos,1)))
      END IF
   END IF
   
   ! -- hubRefPos Param Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(ParamData%hubRefPos)) THEN 
         ParamData%C_obj%hubRefPos_Len = 0
         ParamData%C_obj%hubRefPos = C_NULL_PTR
      ELSE
         ParamData%C_obj%hubRefPos_Len = SIZE(ParamData%hubRefPos)
         IF (ParamData%C_obj%hubRefPos_Len > 0) &
            ParamData%C_obj%hubRefPos = C_LOC(ParamData%hubRefPos(lbound(ParamData%hubRefPos,1)))
      END IF
   END IF
   
   ! -- nacRefPos Param Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(ParamData%nacRefPos)) THEN 
         ParamData%C_obj%nacRefPos_Len = 0
         ParamData%C_obj%nacRefPos = C_NULL_PTR
      ELSE
         ParamData%C_obj%nacRefPos_Len = SIZE(ParamData%nacRefPos)
         IF (ParamData%C_obj%nacRefPos_Len > 0) &
            ParamData%C_obj%nacRefPos = C_LOC(ParamData%nacRefPos(lbound(ParamData%nacRefPos,1)))
      END IF
   END IF
   
   ! -- bldRootRefPos Param Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(ParamData%bldRootRefPos)) THEN 
         ParamData%C_obj%bldRootRefPos_Len = 0
         ParamData%C_obj%bldRootRefPos = C_NULL_PTR
      ELSE
         ParamData%C_obj%bldRootRefPos_Len = SIZE(ParamData%bldRootRefPos)
         IF (ParamData%C_obj%bldRootRefPos_Len > 0) &
            ParamData%C_obj%bldRootRefPos = C_LOC(ParamData%bldRootRefPos(lbound(ParamData%bldRootRefPos,1)))
      END IF
   END IF
   
   ! -- bldChord Param Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(ParamData%bldChord)) THEN 
         ParamData%C_obj%bldChord_Len = 0
         ParamData%C_obj%bldChord = C_NULL_PTR
      ELSE
         ParamData%C_obj%bldChord_Len = SIZE(ParamData%bldChord)
         IF (ParamData%C_obj%bldChord_Len > 0) &
            ParamData%C_obj%bldChord = C_LOC(ParamData%bldChord(lbound(ParamData%bldChord,1)))
      END IF
   END IF
   
   ! -- bldRloc Param Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(ParamData%bldRloc)) THEN 
         ParamData%C_obj%bldRloc_Len = 0
         ParamData%C_obj%bldRloc = C_NULL_PTR
      ELSE
         ParamData%C_obj%bldRloc_Len = SIZE(ParamData%bldRloc)
         IF (ParamData%C_obj%bldRloc_Len > 0) &
            ParamData%C_obj%bldRloc = C_LOC(ParamData%bldRloc(lbound(ParamData%bldRloc,1)))
      END IF
   END IF
   
   ! -- twrDia Param Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(ParamData%twrDia)) THEN 
         ParamData%C_obj%twrDia_Len = 0
         ParamData%C_obj%twrDia = C_NULL_PTR
      ELSE
         ParamData%C_obj%twrDia_Len = SIZE(ParamData%twrDia)
         IF (ParamData%C_obj%twrDia_Len > 0) &
            ParamData%C_obj%twrDia = C_LOC(ParamData%twrDia(lbound(ParamData%twrDia,1)))
      END IF
   END IF
   
   ! -- twrHloc Param Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(ParamData%twrHloc)) THEN 
         ParamData%C_obj%twrHloc_Len = 0
         ParamData%C_obj%twrHloc = C_NULL_PTR
      ELSE
         ParamData%C_obj%twrHloc_Len = SIZE(ParamData%twrHloc)
         IF (ParamData%C_obj%twrHloc_Len > 0) &
            ParamData%C_obj%twrHloc = C_LOC(ParamData%twrHloc(lbound(ParamData%twrHloc,1)))
      END IF
   END IF
END SUBROUTINE

subroutine ExtLdDX_CopyOutput(SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg)
   type(ExtLdDX_OutputType), intent(in) :: SrcOutputData
   type(ExtLdDX_OutputType), intent(inout) :: DstOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'ExtLdDX_CopyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (associated(SrcOutputData%twrLd)) then
      LB(1:1) = lbound(SrcOutputData%twrLd)
      UB(1:1) = ubound(SrcOutputData%twrLd)
      if (.not. associated(DstOutputData%twrLd)) then
         allocate(DstOutputData%twrLd(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%twrLd.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstOutputData%C_obj%twrLd_Len = size(DstOutputData%twrLd)
         if (DstOutputData%C_obj%twrLd_Len > 0) &
            DstOutputData%C_obj%twrLd = c_loc(DstOutputData%twrLd(LB(1)))
      end if
      DstOutputData%twrLd = SrcOutputData%twrLd
   end if
   if (associated(SrcOutputData%bldLd)) then
      LB(1:1) = lbound(SrcOutputData%bldLd)
      UB(1:1) = ubound(SrcOutputData%bldLd)
      if (.not. associated(DstOutputData%bldLd)) then
         allocate(DstOutputData%bldLd(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%bldLd.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstOutputData%C_obj%bldLd_Len = size(DstOutputData%bldLd)
         if (DstOutputData%C_obj%bldLd_Len > 0) &
            DstOutputData%C_obj%bldLd = c_loc(DstOutputData%bldLd(LB(1)))
      end if
      DstOutputData%bldLd = SrcOutputData%bldLd
   end if
end subroutine

subroutine ExtLdDX_DestroyOutput(OutputData, ErrStat, ErrMsg)
   type(ExtLdDX_OutputType), intent(inout) :: OutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ExtLdDX_DestroyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (associated(OutputData%twrLd)) then
      deallocate(OutputData%twrLd)
      OutputData%twrLd => null()
      OutputData%C_obj%twrLd = c_null_ptr
      OutputData%C_obj%twrLd_Len = 0
   end if
   if (associated(OutputData%bldLd)) then
      deallocate(OutputData%bldLd)
      OutputData%bldLd => null()
      OutputData%C_obj%bldLd = c_null_ptr
      OutputData%C_obj%bldLd_Len = 0
   end if
end subroutine

subroutine ExtLdDX_PackOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ExtLdDX_OutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ExtLdDX_PackOutput'
   logical         :: PtrInIndex
   if (RF%ErrStat >= AbortErrLev) return
   if (c_associated(InData%C_obj%object)) then
      RF%ErrStat = ErrID_Fatal
      RF%ErrMsg = RoutineName//': C_obj%object cannot be packed.'
      return
   end if
   call RegPackPtr(RF, InData%twrLd)
   call RegPackPtr(RF, InData%bldLd)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtLdDX_UnPackOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ExtLdDX_OutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ExtLdDX_UnPackOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   integer(B8Ki)   :: PtrIdx
   type(c_ptr)     :: Ptr
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackPtr(RF, OutData%twrLd, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%twrLd)) then
      OutData%C_obj%twrLd_Len = size(OutData%twrLd)
      if (OutData%C_obj%twrLd_Len > 0) OutData%C_obj%twrLd = c_loc(OutData%twrLd(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%bldLd, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%bldLd)) then
      OutData%C_obj%bldLd_Len = size(OutData%bldLd)
      if (OutData%C_obj%bldLd_Len > 0) OutData%C_obj%bldLd = c_loc(OutData%bldLd(LB(1)))
   end if
end subroutine

SUBROUTINE ExtLdDX_C2Fary_CopyOutput(OutputData, ErrStat, ErrMsg, SkipPointers)
   TYPE(ExtLdDX_OutputType), INTENT(INOUT) :: OutputData
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
   LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
   ! 
   LOGICAL                        :: SkipPointers_local
   ErrStat = ErrID_None
   ErrMsg  = ""
   
   IF (PRESENT(SkipPointers)) THEN
      SkipPointers_local = SkipPointers
   ELSE
      SkipPointers_local = .false.
   END IF
   
   ! -- twrLd Output Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( OutputData%C_obj%twrLd ) ) THEN
         NULLIFY( OutputData%twrLd )
      ELSE
         CALL C_F_POINTER(OutputData%C_obj%twrLd, OutputData%twrLd, [OutputData%C_obj%twrLd_Len])
      END IF
   END IF
   
   ! -- bldLd Output Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( OutputData%C_obj%bldLd ) ) THEN
         NULLIFY( OutputData%bldLd )
      ELSE
         CALL C_F_POINTER(OutputData%C_obj%bldLd, OutputData%bldLd, [OutputData%C_obj%bldLd_Len])
      END IF
   END IF
END SUBROUTINE

SUBROUTINE ExtLdDX_F2C_CopyOutput( OutputData, ErrStat, ErrMsg, SkipPointers  )
   TYPE(ExtLdDX_OutputType), INTENT(INOUT) :: OutputData
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
   LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
   ! 
   LOGICAL                        :: SkipPointers_local
   ErrStat = ErrID_None
   ErrMsg  = ''
   
   IF (PRESENT(SkipPointers)) THEN
      SkipPointers_local = SkipPointers
   ELSE
      SkipPointers_local = .false.
   END IF
   
   ! -- twrLd Output Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(OutputData%twrLd)) THEN 
         OutputData%C_obj%twrLd_Len = 0
         OutputData%C_obj%twrLd = C_NULL_PTR
      ELSE
         OutputData%C_obj%twrLd_Len = SIZE(OutputData%twrLd)
         IF (OutputData%C_obj%twrLd_Len > 0) &
            OutputData%C_obj%twrLd = C_LOC(OutputData%twrLd(lbound(OutputData%twrLd,1)))
      END IF
   END IF
   
   ! -- bldLd Output Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(OutputData%bldLd)) THEN 
         OutputData%C_obj%bldLd_Len = 0
         OutputData%C_obj%bldLd = C_NULL_PTR
      ELSE
         OutputData%C_obj%bldLd_Len = SIZE(OutputData%bldLd)
         IF (OutputData%C_obj%bldLd_Len > 0) &
            OutputData%C_obj%bldLd = C_LOC(OutputData%bldLd(lbound(OutputData%bldLd,1)))
      END IF
   END IF
END SUBROUTINE

subroutine ExtLdDX_Input_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
   ! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(ExtLdDX_InputType), intent(in)  :: u(:) ! Input at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Inputs
   type(ExtLdDX_InputType), intent(inout)  :: u_out ! Input at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'ExtLdDX_Input_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(u)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(u)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(u) - 1
   select case (order)
   case (0)
      call ExtLdDX_CopyInput(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call ExtLdDX_Input_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call ExtLdDX_Input_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(u) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE ExtLdDX_Input_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

   TYPE(ExtLdDX_InputType), INTENT(IN)  :: u1    ! Input at t1 > t2
   TYPE(ExtLdDX_InputType), INTENT(IN)  :: u2    ! Input at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Inputs
   TYPE(ExtLdDX_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'ExtLdDX_Input_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   IF (ASSOCIATED(u_out%twrDef) .AND. ASSOCIATED(u1%twrDef)) THEN
      u_out%twrDef = a1*u1%twrDef + a2*u2%twrDef
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%bldDef) .AND. ASSOCIATED(u1%bldDef)) THEN
      u_out%bldDef = a1*u1%bldDef + a2*u2%bldDef
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%hubDef) .AND. ASSOCIATED(u1%hubDef)) THEN
      u_out%hubDef = a1*u1%hubDef + a2*u2%hubDef
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%nacDef) .AND. ASSOCIATED(u1%nacDef)) THEN
      u_out%nacDef = a1*u1%nacDef + a2*u2%nacDef
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%bldRootDef) .AND. ASSOCIATED(u1%bldRootDef)) THEN
      u_out%bldRootDef = a1*u1%bldRootDef + a2*u2%bldRootDef
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%bldPitch) .AND. ASSOCIATED(u1%bldPitch)) THEN
      u_out%bldPitch = a1*u1%bldPitch + a2*u2%bldPitch
   END IF ! check if allocated
END SUBROUTINE

SUBROUTINE ExtLdDX_Input_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

   TYPE(ExtLdDX_InputType), INTENT(IN)  :: u1      ! Input at t1 > t2 > t3
   TYPE(ExtLdDX_InputType), INTENT(IN)  :: u2      ! Input at t2 > t3
   TYPE(ExtLdDX_InputType), INTENT(IN)  :: u3      ! Input at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Inputs
   TYPE(ExtLdDX_InputType), INTENT(INOUT)  :: u_out     ! Input at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'ExtLdDX_Input_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   IF (ASSOCIATED(u_out%twrDef) .AND. ASSOCIATED(u1%twrDef)) THEN
      u_out%twrDef = a1*u1%twrDef + a2*u2%twrDef + a3*u3%twrDef
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%bldDef) .AND. ASSOCIATED(u1%bldDef)) THEN
      u_out%bldDef = a1*u1%bldDef + a2*u2%bldDef + a3*u3%bldDef
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%hubDef) .AND. ASSOCIATED(u1%hubDef)) THEN
      u_out%hubDef = a1*u1%hubDef + a2*u2%hubDef + a3*u3%hubDef
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%nacDef) .AND. ASSOCIATED(u1%nacDef)) THEN
      u_out%nacDef = a1*u1%nacDef + a2*u2%nacDef + a3*u3%nacDef
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%bldRootDef) .AND. ASSOCIATED(u1%bldRootDef)) THEN
      u_out%bldRootDef = a1*u1%bldRootDef + a2*u2%bldRootDef + a3*u3%bldRootDef
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%bldPitch) .AND. ASSOCIATED(u1%bldPitch)) THEN
      u_out%bldPitch = a1*u1%bldPitch + a2*u2%bldPitch + a3*u3%bldPitch
   END IF ! check if allocated
END SUBROUTINE

subroutine ExtLdDX_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
   ! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(ExtLdDX_OutputType), intent(in)  :: y(:) ! Output at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Outputs
   type(ExtLdDX_OutputType), intent(inout)  :: y_out ! Output at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'ExtLdDX_Output_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(y)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(y)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(y) - 1
   select case (order)
   case (0)
      call ExtLdDX_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call ExtLdDX_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call ExtLdDX_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(y) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE ExtLdDX_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

   TYPE(ExtLdDX_OutputType), INTENT(IN)  :: y1    ! Output at t1 > t2
   TYPE(ExtLdDX_OutputType), INTENT(IN)  :: y2    ! Output at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
   TYPE(ExtLdDX_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'ExtLdDX_Output_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   IF (ASSOCIATED(y_out%twrLd) .AND. ASSOCIATED(y1%twrLd)) THEN
      y_out%twrLd = a1*y1%twrLd + a2*y2%twrLd
   END IF ! check if allocated
   IF (ASSOCIATED(y_out%bldLd) .AND. ASSOCIATED(y1%bldLd)) THEN
      y_out%bldLd = a1*y1%bldLd + a2*y2%bldLd
   END IF ! check if allocated
END SUBROUTINE

SUBROUTINE ExtLdDX_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

   TYPE(ExtLdDX_OutputType), INTENT(IN)  :: y1      ! Output at t1 > t2 > t3
   TYPE(ExtLdDX_OutputType), INTENT(IN)  :: y2      ! Output at t2 > t3
   TYPE(ExtLdDX_OutputType), INTENT(IN)  :: y3      ! Output at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
   TYPE(ExtLdDX_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'ExtLdDX_Output_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   IF (ASSOCIATED(y_out%twrLd) .AND. ASSOCIATED(y1%twrLd)) THEN
      y_out%twrLd = a1*y1%twrLd + a2*y2%twrLd + a3*y3%twrLd
   END IF ! check if allocated
   IF (ASSOCIATED(y_out%bldLd) .AND. ASSOCIATED(y1%bldLd)) THEN
      y_out%bldLd = a1*y1%bldLd + a2*y2%bldLd + a3*y3%bldLd
   END IF ! check if allocated
END SUBROUTINE
END MODULE ExtLoadsDX_Types
!ENDOFREGISTRYGENERATEDFILE
