!STARTOFREGISTRYGENERATEDFILE 'ExternalInflow_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! ExternalInflow_Types
!.................................................................................................................................
! This file is part of ExternalInflow.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in ExternalInflow. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE ExternalInflow_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE IfW_FlowField_Types
USE NWTC_Library
IMPLICIT NONE
! =========  ExtInfw_InitInputType_C  =======
  TYPE, BIND(C) :: ExtInfw_InitInputType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    INTEGER(KIND=C_INT) :: NumActForcePtsBlade 
    INTEGER(KIND=C_INT) :: NumActForcePtsTower 
    TYPE(C_ptr) :: StructBldRNodes = C_NULL_PTR 
    INTEGER(C_int) :: StructBldRNodes_Len = 0 
    TYPE(C_ptr) :: StructTwrHNodes = C_NULL_PTR 
    INTEGER(C_int) :: StructTwrHNodes_Len = 0 
    REAL(KIND=C_FLOAT) :: BladeLength 
    REAL(KIND=C_FLOAT) :: TowerHeight 
    REAL(KIND=C_FLOAT) :: TowerBaseHeight 
    INTEGER(KIND=C_INT) :: NodeClusterType 
  END TYPE ExtInfw_InitInputType_C
  TYPE, PUBLIC :: ExtInfw_InitInputType
    TYPE( ExtInfw_InitInputType_C ) :: C_obj
    INTEGER(IntKi)  :: NumActForcePtsBlade = 0_IntKi      !< number of actuator line force points in blade -- from extern (used to linearly interpolate along AD15 blades) [-]
    INTEGER(IntKi)  :: NumActForcePtsTower = 0_IntKi      !< number of actuator line force points in tower -- from extern (used to linearly interpolate along AD15 tower) [-]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: StructBldRNodes => NULL()      !< Radius to structural model analysis nodes relative to hub [-]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: StructTwrHNodes => NULL()      !< Location of tower nodes from AD15 (relative to the tower rigid base height) [-]
    REAL(ReKi)  :: BladeLength = 0.0_ReKi      !< Blade length [meters]
    REAL(ReKi)  :: TowerHeight = 0.0_ReKi      !< Tower Height [meters]
    REAL(ReKi)  :: TowerBaseHeight = 0.0_ReKi      !< Tower Base Height [meters]
    INTEGER(IntKi)  :: NodeClusterType = 0_IntKi      !< Node clustering (0 - Uniform, 1 - Non-uniform clustered towards tip) [-]
  END TYPE ExtInfw_InitInputType
! =======================
! =========  ExtInfw_InitOutputType_C  =======
  TYPE, BIND(C) :: ExtInfw_InitOutputType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    TYPE(C_ptr) :: WriteOutputHdr = C_NULL_PTR 
    INTEGER(C_int) :: WriteOutputHdr_Len = 0 
    TYPE(C_ptr) :: WriteOutputUnt = C_NULL_PTR 
    INTEGER(C_int) :: WriteOutputUnt_Len = 0 
  END TYPE ExtInfw_InitOutputType_C
  TYPE, PUBLIC :: ExtInfw_InitOutputType
    TYPE( ExtInfw_InitOutputType_C ) :: C_obj
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputHdr      !< Names of the output-to-file channels [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputUnt      !< Units of the output-to-file channels [-]
    TYPE(ProgDesc)  :: Ver      !< This module's name, version, and date [-]
    TYPE(FlowFieldType) , POINTER :: FlowField => NULL()      !< Pointer of flow field data type [-]
  END TYPE ExtInfw_InitOutputType
! =======================
! =========  ExtInfw_MiscVarType_C  =======
  TYPE, BIND(C) :: ExtInfw_MiscVarType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
  END TYPE ExtInfw_MiscVarType_C
  TYPE, PUBLIC :: ExtInfw_MiscVarType
    TYPE( ExtInfw_MiscVarType_C ) :: C_obj
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: ActForceMotionsPoints      !< point mesh for transferring AeroDyn motions to ExternalInflow  (includes hub+blades+nacelle+tower+tailfin) [-]
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: ActForceLoadsPoints      !< point mesh for transferring AeroDyn distributed loads to ExternalInflow (includes hub+blades+nacelle+tower+tailfin) [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: Line2_to_Point_Loads      !< mapping data structure to convert line2 loads to point loads [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: Line2_to_Point_Motions      !< mapping data structure to convert line2 loads to point motions [-]
    TYPE(FlowFieldType) , POINTER :: FlowField => NULL()      !< Flow field data type [-]
  END TYPE ExtInfw_MiscVarType
! =======================
! =========  ExtInfw_ParameterType_C  =======
  TYPE, BIND(C) :: ExtInfw_ParameterType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    REAL(KIND=C_FLOAT) :: AirDens 
    INTEGER(KIND=C_INT) :: NumBl 
    INTEGER(KIND=C_INT) :: NMappings 
    INTEGER(KIND=C_INT) :: NnodesVel 
    INTEGER(KIND=C_INT) :: NnodesForce 
    INTEGER(KIND=C_INT) :: NnodesForceBlade 
    INTEGER(KIND=C_INT) :: NnodesForceTower 
    TYPE(C_ptr) :: forceBldRnodes = C_NULL_PTR 
    INTEGER(C_int) :: forceBldRnodes_Len = 0 
    TYPE(C_ptr) :: forceTwrHnodes = C_NULL_PTR 
    INTEGER(C_int) :: forceTwrHnodes_Len = 0 
    REAL(KIND=C_FLOAT) :: BladeLength 
    REAL(KIND=C_FLOAT) :: TowerHeight 
    REAL(KIND=C_FLOAT) :: TowerBaseHeight 
    INTEGER(KIND=C_INT) :: NodeClusterType 
  END TYPE ExtInfw_ParameterType_C
  TYPE, PUBLIC :: ExtInfw_ParameterType
    TYPE( ExtInfw_ParameterType_C ) :: C_obj
    REAL(ReKi)  :: AirDens = 0.0_ReKi      !< Air density for normalization of loads sent to ExternalInflow [kg/m^3]
    INTEGER(IntKi)  :: NumBl = 0_IntKi      !< Number of blades [-]
    INTEGER(IntKi)  :: NMappings = 0_IntKi      !< Number of mappings [-]
    INTEGER(IntKi)  :: NnodesVel = 0_IntKi      !< number of velocity nodes on FAST v8-ExternalInflow interface [-]
    INTEGER(IntKi)  :: NnodesForce = 0_IntKi      !< number of force nodes on FAST v8-ExternalInflow interface [-]
    INTEGER(IntKi)  :: NnodesForceBlade = 0_IntKi      !< number of force nodes on FAST v8-ExternalInflow interface [-]
    INTEGER(IntKi)  :: NnodesForceTower = 0_IntKi      !< number of force nodes on FAST v8-ExternalInflow interface [-]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: forceBldRnodes => NULL()      !< Radial location of force nodes [-]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: forceTwrHnodes => NULL()      !< Vertical location of force nodes [-]
    REAL(ReKi)  :: BladeLength = 0.0_ReKi      !< Blade length (same for all blades) [m]
    REAL(ReKi)  :: TowerHeight = 0.0_ReKi      !< Tower height [m]
    REAL(ReKi)  :: TowerBaseHeight = 0.0_ReKi      !< Tower base height [m]
    INTEGER(IntKi)  :: NodeClusterType = 0_IntKi      !< Node clustering (0 - Uniform, 1 - Non-uniform clustered towards tip) [-]
  END TYPE ExtInfw_ParameterType
! =======================
! =========  ExtInfw_InputType_C  =======
  TYPE, BIND(C) :: ExtInfw_InputType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    TYPE(C_ptr) :: pxVel = C_NULL_PTR 
    INTEGER(C_int) :: pxVel_Len = 0 
    TYPE(C_ptr) :: pyVel = C_NULL_PTR 
    INTEGER(C_int) :: pyVel_Len = 0 
    TYPE(C_ptr) :: pzVel = C_NULL_PTR 
    INTEGER(C_int) :: pzVel_Len = 0 
    TYPE(C_ptr) :: pxForce = C_NULL_PTR 
    INTEGER(C_int) :: pxForce_Len = 0 
    TYPE(C_ptr) :: pyForce = C_NULL_PTR 
    INTEGER(C_int) :: pyForce_Len = 0 
    TYPE(C_ptr) :: pzForce = C_NULL_PTR 
    INTEGER(C_int) :: pzForce_Len = 0 
    TYPE(C_ptr) :: xdotForce = C_NULL_PTR 
    INTEGER(C_int) :: xdotForce_Len = 0 
    TYPE(C_ptr) :: ydotForce = C_NULL_PTR 
    INTEGER(C_int) :: ydotForce_Len = 0 
    TYPE(C_ptr) :: zdotForce = C_NULL_PTR 
    INTEGER(C_int) :: zdotForce_Len = 0 
    TYPE(C_ptr) :: pOrientation = C_NULL_PTR 
    INTEGER(C_int) :: pOrientation_Len = 0 
    TYPE(C_ptr) :: fx = C_NULL_PTR 
    INTEGER(C_int) :: fx_Len = 0 
    TYPE(C_ptr) :: fy = C_NULL_PTR 
    INTEGER(C_int) :: fy_Len = 0 
    TYPE(C_ptr) :: fz = C_NULL_PTR 
    INTEGER(C_int) :: fz_Len = 0 
    TYPE(C_ptr) :: momentx = C_NULL_PTR 
    INTEGER(C_int) :: momentx_Len = 0 
    TYPE(C_ptr) :: momenty = C_NULL_PTR 
    INTEGER(C_int) :: momenty_Len = 0 
    TYPE(C_ptr) :: momentz = C_NULL_PTR 
    INTEGER(C_int) :: momentz_Len = 0 
    TYPE(C_ptr) :: forceNodesChord = C_NULL_PTR 
    INTEGER(C_int) :: forceNodesChord_Len = 0 
  END TYPE ExtInfw_InputType_C
  TYPE, PUBLIC :: ExtInfw_InputType
    TYPE( ExtInfw_InputType_C ) :: C_obj
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: pxVel => NULL()      !< x position of velocity interface (Aerodyn) nodes [m]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: pyVel => NULL()      !< y position of velocity interface (Aerodyn) nodes [m]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: pzVel => NULL()      !< z position of velocity interface (Aerodyn) nodes [m]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: pxForce => NULL()      !< x position of actuator force nodes [m]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: pyForce => NULL()      !< y position of actuator force nodes [m]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: pzForce => NULL()      !< z position of actuator force nodes [m]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: xdotForce => NULL()      !< x velocity of actuator force nodes [m/s]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: ydotForce => NULL()      !< y velocity of actuator force nodes [m/s]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: zdotForce => NULL()      !< z velocity of actuator force nodes [m/s]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: pOrientation => NULL()      !< Direction cosine matrix to transform vectors from global frame of reference to actuator force node frame of reference [-]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: fx => NULL()      !< normalized x force at actuator force nodes [N/kg/m^3]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: fy => NULL()      !< normalized y force at actuator force nodes [N/kg/m^3]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: fz => NULL()      !< normalized z force at actuator force nodes [N/kg/m^3]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: momentx => NULL()      !< normalized x moment at actuator force nodes [Nm/kg/m^3]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: momenty => NULL()      !< normalized y moment at actuator force nodes [Nm/kg/m^3]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: momentz => NULL()      !< normalized z moment at actuator force nodes [Nm/kg/m^3]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: forceNodesChord => NULL()      !< chord distribution at the actuator force nodes [m]
  END TYPE ExtInfw_InputType
! =======================
! =========  ExtInfw_OutputType_C  =======
  TYPE, BIND(C) :: ExtInfw_OutputType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    TYPE(C_ptr) :: u = C_NULL_PTR 
    INTEGER(C_int) :: u_Len = 0 
    TYPE(C_ptr) :: v = C_NULL_PTR 
    INTEGER(C_int) :: v_Len = 0 
    TYPE(C_ptr) :: w = C_NULL_PTR 
    INTEGER(C_int) :: w_Len = 0 
    TYPE(C_ptr) :: WriteOutput = C_NULL_PTR 
    INTEGER(C_int) :: WriteOutput_Len = 0 
  END TYPE ExtInfw_OutputType_C
  TYPE, PUBLIC :: ExtInfw_OutputType
    TYPE( ExtInfw_OutputType_C ) :: C_obj
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: u => NULL()      !< U-component wind speed (in the X-direction) at interface nodes [m/s]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: v => NULL()      !< V-component wind speed (in the Y-direction) at interface nodes [m/s]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: w => NULL()      !< W-component wind speed (in the Z-direction) at interface nodes [m/s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WriteOutput      !< Data to be written to an output file: see WriteOutputHdr for names of each variable [see WriteOutputUnt]
  END TYPE ExtInfw_OutputType
! =======================
CONTAINS

subroutine ExtInfw_CopyInitInput(SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg)
   type(ExtInfw_InitInputType), intent(in) :: SrcInitInputData
   type(ExtInfw_InitInputType), intent(inout) :: DstInitInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'ExtInfw_CopyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInitInputData%NumActForcePtsBlade = SrcInitInputData%NumActForcePtsBlade
   DstInitInputData%C_obj%NumActForcePtsBlade = SrcInitInputData%C_obj%NumActForcePtsBlade
   DstInitInputData%NumActForcePtsTower = SrcInitInputData%NumActForcePtsTower
   DstInitInputData%C_obj%NumActForcePtsTower = SrcInitInputData%C_obj%NumActForcePtsTower
   if (associated(SrcInitInputData%StructBldRNodes)) then
      LB(1:1) = lbound(SrcInitInputData%StructBldRNodes)
      UB(1:1) = ubound(SrcInitInputData%StructBldRNodes)
      if (.not. associated(DstInitInputData%StructBldRNodes)) then
         allocate(DstInitInputData%StructBldRNodes(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%StructBldRNodes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstInitInputData%C_obj%StructBldRNodes_Len = size(DstInitInputData%StructBldRNodes)
         if (DstInitInputData%C_obj%StructBldRNodes_Len > 0) &
            DstInitInputData%C_obj%StructBldRNodes = c_loc(DstInitInputData%StructBldRNodes(LB(1)))
      end if
      DstInitInputData%StructBldRNodes = SrcInitInputData%StructBldRNodes
   end if
   if (associated(SrcInitInputData%StructTwrHNodes)) then
      LB(1:1) = lbound(SrcInitInputData%StructTwrHNodes)
      UB(1:1) = ubound(SrcInitInputData%StructTwrHNodes)
      if (.not. associated(DstInitInputData%StructTwrHNodes)) then
         allocate(DstInitInputData%StructTwrHNodes(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%StructTwrHNodes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstInitInputData%C_obj%StructTwrHNodes_Len = size(DstInitInputData%StructTwrHNodes)
         if (DstInitInputData%C_obj%StructTwrHNodes_Len > 0) &
            DstInitInputData%C_obj%StructTwrHNodes = c_loc(DstInitInputData%StructTwrHNodes(LB(1)))
      end if
      DstInitInputData%StructTwrHNodes = SrcInitInputData%StructTwrHNodes
   end if
   DstInitInputData%BladeLength = SrcInitInputData%BladeLength
   DstInitInputData%C_obj%BladeLength = SrcInitInputData%C_obj%BladeLength
   DstInitInputData%TowerHeight = SrcInitInputData%TowerHeight
   DstInitInputData%C_obj%TowerHeight = SrcInitInputData%C_obj%TowerHeight
   DstInitInputData%TowerBaseHeight = SrcInitInputData%TowerBaseHeight
   DstInitInputData%C_obj%TowerBaseHeight = SrcInitInputData%C_obj%TowerBaseHeight
   DstInitInputData%NodeClusterType = SrcInitInputData%NodeClusterType
   DstInitInputData%C_obj%NodeClusterType = SrcInitInputData%C_obj%NodeClusterType
end subroutine

subroutine ExtInfw_DestroyInitInput(InitInputData, ErrStat, ErrMsg)
   type(ExtInfw_InitInputType), intent(inout) :: InitInputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ExtInfw_DestroyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (associated(InitInputData%StructBldRNodes)) then
      deallocate(InitInputData%StructBldRNodes)
      InitInputData%StructBldRNodes => null()
      InitInputData%C_obj%StructBldRNodes = c_null_ptr
      InitInputData%C_obj%StructBldRNodes_Len = 0
   end if
   if (associated(InitInputData%StructTwrHNodes)) then
      deallocate(InitInputData%StructTwrHNodes)
      InitInputData%StructTwrHNodes => null()
      InitInputData%C_obj%StructTwrHNodes = c_null_ptr
      InitInputData%C_obj%StructTwrHNodes_Len = 0
   end if
end subroutine

subroutine ExtInfw_PackInitInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ExtInfw_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ExtInfw_PackInitInput'
   logical         :: PtrInIndex
   if (RF%ErrStat >= AbortErrLev) return
   if (c_associated(InData%C_obj%object)) then
      RF%ErrStat = ErrID_Fatal
      RF%ErrMsg = RoutineName//': C_obj%object cannot be packed.'
      return
   end if
   call RegPack(RF, InData%NumActForcePtsBlade)
   call RegPack(RF, InData%NumActForcePtsTower)
   call RegPackPtr(RF, InData%StructBldRNodes)
   call RegPackPtr(RF, InData%StructTwrHNodes)
   call RegPack(RF, InData%BladeLength)
   call RegPack(RF, InData%TowerHeight)
   call RegPack(RF, InData%TowerBaseHeight)
   call RegPack(RF, InData%NodeClusterType)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtInfw_UnPackInitInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ExtInfw_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ExtInfw_UnPackInitInput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   integer(B8Ki)   :: PtrIdx
   type(c_ptr)     :: Ptr
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%NumActForcePtsBlade); if (RegCheckErr(RF, RoutineName)) return
   OutData%C_obj%NumActForcePtsBlade = OutData%NumActForcePtsBlade
   call RegUnpack(RF, OutData%NumActForcePtsTower); if (RegCheckErr(RF, RoutineName)) return
   OutData%C_obj%NumActForcePtsTower = OutData%NumActForcePtsTower
   call RegUnpackPtr(RF, OutData%StructBldRNodes, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%StructBldRNodes)) then
      OutData%C_obj%StructBldRNodes_Len = size(OutData%StructBldRNodes)
      if (OutData%C_obj%StructBldRNodes_Len > 0) OutData%C_obj%StructBldRNodes = c_loc(OutData%StructBldRNodes(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%StructTwrHNodes, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%StructTwrHNodes)) then
      OutData%C_obj%StructTwrHNodes_Len = size(OutData%StructTwrHNodes)
      if (OutData%C_obj%StructTwrHNodes_Len > 0) OutData%C_obj%StructTwrHNodes = c_loc(OutData%StructTwrHNodes(LB(1)))
   end if
   call RegUnpack(RF, OutData%BladeLength); if (RegCheckErr(RF, RoutineName)) return
   OutData%C_obj%BladeLength = OutData%BladeLength
   call RegUnpack(RF, OutData%TowerHeight); if (RegCheckErr(RF, RoutineName)) return
   OutData%C_obj%TowerHeight = OutData%TowerHeight
   call RegUnpack(RF, OutData%TowerBaseHeight); if (RegCheckErr(RF, RoutineName)) return
   OutData%C_obj%TowerBaseHeight = OutData%TowerBaseHeight
   call RegUnpack(RF, OutData%NodeClusterType); if (RegCheckErr(RF, RoutineName)) return
   OutData%C_obj%NodeClusterType = OutData%NodeClusterType
end subroutine

SUBROUTINE ExtInfw_C2Fary_CopyInitInput(InitInputData, ErrStat, ErrMsg, SkipPointers)
   TYPE(ExtInfw_InitInputType), INTENT(INOUT) :: InitInputData
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
   LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
   ! 
   LOGICAL                        :: SkipPointers_local
   ErrStat = ErrID_None
   ErrMsg  = ""
   
   IF (PRESENT(SkipPointers)) THEN
      SkipPointers_local = SkipPointers
   ELSE
      SkipPointers_local = .false.
   END IF
   InitInputData%NumActForcePtsBlade = InitInputData%C_obj%NumActForcePtsBlade
   InitInputData%NumActForcePtsTower = InitInputData%C_obj%NumActForcePtsTower
   
   ! -- StructBldRNodes InitInput Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( InitInputData%C_obj%StructBldRNodes ) ) THEN
         NULLIFY( InitInputData%StructBldRNodes )
      ELSE
         CALL C_F_POINTER(InitInputData%C_obj%StructBldRNodes, InitInputData%StructBldRNodes, [InitInputData%C_obj%StructBldRNodes_Len])
      END IF
   END IF
   
   ! -- StructTwrHNodes InitInput Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( InitInputData%C_obj%StructTwrHNodes ) ) THEN
         NULLIFY( InitInputData%StructTwrHNodes )
      ELSE
         CALL C_F_POINTER(InitInputData%C_obj%StructTwrHNodes, InitInputData%StructTwrHNodes, [InitInputData%C_obj%StructTwrHNodes_Len])
      END IF
   END IF
   InitInputData%BladeLength = InitInputData%C_obj%BladeLength
   InitInputData%TowerHeight = InitInputData%C_obj%TowerHeight
   InitInputData%TowerBaseHeight = InitInputData%C_obj%TowerBaseHeight
   InitInputData%NodeClusterType = InitInputData%C_obj%NodeClusterType
END SUBROUTINE

SUBROUTINE ExtInfw_F2C_CopyInitInput( InitInputData, ErrStat, ErrMsg, SkipPointers  )
   TYPE(ExtInfw_InitInputType), INTENT(INOUT) :: InitInputData
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
   LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
   ! 
   LOGICAL                        :: SkipPointers_local
   ErrStat = ErrID_None
   ErrMsg  = ''
   
   IF (PRESENT(SkipPointers)) THEN
      SkipPointers_local = SkipPointers
   ELSE
      SkipPointers_local = .false.
   END IF
   InitInputData%C_obj%NumActForcePtsBlade = InitInputData%NumActForcePtsBlade
   InitInputData%C_obj%NumActForcePtsTower = InitInputData%NumActForcePtsTower
   
   ! -- StructBldRNodes InitInput Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(InitInputData%StructBldRNodes)) THEN 
         InitInputData%C_obj%StructBldRNodes_Len = 0
         InitInputData%C_obj%StructBldRNodes = C_NULL_PTR
      ELSE
         InitInputData%C_obj%StructBldRNodes_Len = SIZE(InitInputData%StructBldRNodes)
         IF (InitInputData%C_obj%StructBldRNodes_Len > 0) &
            InitInputData%C_obj%StructBldRNodes = C_LOC(InitInputData%StructBldRNodes(lbound(InitInputData%StructBldRNodes,1)))
      END IF
   END IF
   
   ! -- StructTwrHNodes InitInput Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(InitInputData%StructTwrHNodes)) THEN 
         InitInputData%C_obj%StructTwrHNodes_Len = 0
         InitInputData%C_obj%StructTwrHNodes = C_NULL_PTR
      ELSE
         InitInputData%C_obj%StructTwrHNodes_Len = SIZE(InitInputData%StructTwrHNodes)
         IF (InitInputData%C_obj%StructTwrHNodes_Len > 0) &
            InitInputData%C_obj%StructTwrHNodes = C_LOC(InitInputData%StructTwrHNodes(lbound(InitInputData%StructTwrHNodes,1)))
      END IF
   END IF
   InitInputData%C_obj%BladeLength = InitInputData%BladeLength
   InitInputData%C_obj%TowerHeight = InitInputData%TowerHeight
   InitInputData%C_obj%TowerBaseHeight = InitInputData%TowerBaseHeight
   InitInputData%C_obj%NodeClusterType = InitInputData%NodeClusterType
END SUBROUTINE

subroutine ExtInfw_CopyInitOutput(SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg)
   type(ExtInfw_InitOutputType), intent(in) :: SrcInitOutputData
   type(ExtInfw_InitOutputType), intent(inout) :: DstInitOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ExtInfw_CopyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcInitOutputData%WriteOutputHdr)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputHdr)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputHdr)
      if (.not. allocated(DstInitOutputData%WriteOutputHdr)) then
         allocate(DstInitOutputData%WriteOutputHdr(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputHdr.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputHdr = SrcInitOutputData%WriteOutputHdr
   end if
   if (allocated(SrcInitOutputData%WriteOutputUnt)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputUnt)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputUnt)
      if (.not. allocated(DstInitOutputData%WriteOutputUnt)) then
         allocate(DstInitOutputData%WriteOutputUnt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputUnt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputUnt = SrcInitOutputData%WriteOutputUnt
   end if
   call NWTC_Library_CopyProgDesc(SrcInitOutputData%Ver, DstInitOutputData%Ver, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstInitOutputData%FlowField => SrcInitOutputData%FlowField
end subroutine

subroutine ExtInfw_DestroyInitOutput(InitOutputData, ErrStat, ErrMsg)
   type(ExtInfw_InitOutputType), intent(inout) :: InitOutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ExtInfw_DestroyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InitOutputData%WriteOutputHdr)) then
      deallocate(InitOutputData%WriteOutputHdr)
   end if
   if (allocated(InitOutputData%WriteOutputUnt)) then
      deallocate(InitOutputData%WriteOutputUnt)
   end if
   call NWTC_Library_DestroyProgDesc(InitOutputData%Ver, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   nullify(InitOutputData%FlowField)
end subroutine

subroutine ExtInfw_PackInitOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ExtInfw_InitOutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ExtInfw_PackInitOutput'
   logical         :: PtrInIndex
   if (RF%ErrStat >= AbortErrLev) return
   if (c_associated(InData%C_obj%object)) then
      RF%ErrStat = ErrID_Fatal
      RF%ErrMsg = RoutineName//': C_obj%object cannot be packed.'
      return
   end if
   call RegPackAlloc(RF, InData%WriteOutputHdr)
   call RegPackAlloc(RF, InData%WriteOutputUnt)
   call NWTC_Library_PackProgDesc(RF, InData%Ver) 
   call RegPack(RF, associated(InData%FlowField))
   if (associated(InData%FlowField)) then
      call RegPackPointer(RF, c_loc(InData%FlowField), PtrInIndex)
      if (.not. PtrInIndex) then
         call IfW_FlowField_PackFlowFieldType(RF, InData%FlowField) 
      end if
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtInfw_UnPackInitOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ExtInfw_InitOutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ExtInfw_UnPackInitOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   integer(B8Ki)   :: PtrIdx
   type(c_ptr)     :: Ptr
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%WriteOutputHdr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutputUnt); if (RegCheckErr(RF, RoutineName)) return
   call NWTC_Library_UnpackProgDesc(RF, OutData%Ver) ! Ver 
   if (associated(OutData%FlowField)) deallocate(OutData%FlowField)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackPointer(RF, Ptr, PtrIdx); if (RegCheckErr(RF, RoutineName)) return
      if (c_associated(Ptr)) then
         call c_f_pointer(Ptr, OutData%FlowField)
      else
         allocate(OutData%FlowField,stat=stat)
         if (stat /= 0) then 
            call SetErrStat(ErrID_Fatal, 'Error allocating OutData%FlowField.', RF%ErrStat, RF%ErrMsg, RoutineName)
            return
         end if
         RF%Pointers(PtrIdx) = c_loc(OutData%FlowField)
         call IfW_FlowField_UnpackFlowFieldType(RF, OutData%FlowField) ! FlowField 
      end if
   else
      OutData%FlowField => null()
   end if
end subroutine

SUBROUTINE ExtInfw_C2Fary_CopyInitOutput(InitOutputData, ErrStat, ErrMsg, SkipPointers)
   TYPE(ExtInfw_InitOutputType), INTENT(INOUT) :: InitOutputData
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
   LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
   ! 
   LOGICAL                        :: SkipPointers_local
   ErrStat = ErrID_None
   ErrMsg  = ""
   
   IF (PRESENT(SkipPointers)) THEN
      SkipPointers_local = SkipPointers
   ELSE
      SkipPointers_local = .false.
   END IF
END SUBROUTINE

SUBROUTINE ExtInfw_F2C_CopyInitOutput( InitOutputData, ErrStat, ErrMsg, SkipPointers  )
   TYPE(ExtInfw_InitOutputType), INTENT(INOUT) :: InitOutputData
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
   LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
   ! 
   LOGICAL                        :: SkipPointers_local
   ErrStat = ErrID_None
   ErrMsg  = ''
   
   IF (PRESENT(SkipPointers)) THEN
      SkipPointers_local = SkipPointers
   ELSE
      SkipPointers_local = .false.
   END IF
END SUBROUTINE

subroutine ExtInfw_CopyMisc(SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg)
   type(ExtInfw_MiscVarType), intent(inout) :: SrcMiscData
   type(ExtInfw_MiscVarType), intent(inout) :: DstMiscData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ExtInfw_CopyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcMiscData%ActForceMotionsPoints)) then
      LB(1:1) = lbound(SrcMiscData%ActForceMotionsPoints)
      UB(1:1) = ubound(SrcMiscData%ActForceMotionsPoints)
      if (.not. allocated(DstMiscData%ActForceMotionsPoints)) then
         allocate(DstMiscData%ActForceMotionsPoints(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%ActForceMotionsPoints.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcMiscData%ActForceMotionsPoints(i1), DstMiscData%ActForceMotionsPoints(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcMiscData%ActForceLoadsPoints)) then
      LB(1:1) = lbound(SrcMiscData%ActForceLoadsPoints)
      UB(1:1) = ubound(SrcMiscData%ActForceLoadsPoints)
      if (.not. allocated(DstMiscData%ActForceLoadsPoints)) then
         allocate(DstMiscData%ActForceLoadsPoints(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%ActForceLoadsPoints.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcMiscData%ActForceLoadsPoints(i1), DstMiscData%ActForceLoadsPoints(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcMiscData%Line2_to_Point_Loads)) then
      LB(1:1) = lbound(SrcMiscData%Line2_to_Point_Loads)
      UB(1:1) = ubound(SrcMiscData%Line2_to_Point_Loads)
      if (.not. allocated(DstMiscData%Line2_to_Point_Loads)) then
         allocate(DstMiscData%Line2_to_Point_Loads(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%Line2_to_Point_Loads.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyMeshMapType(SrcMiscData%Line2_to_Point_Loads(i1), DstMiscData%Line2_to_Point_Loads(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcMiscData%Line2_to_Point_Motions)) then
      LB(1:1) = lbound(SrcMiscData%Line2_to_Point_Motions)
      UB(1:1) = ubound(SrcMiscData%Line2_to_Point_Motions)
      if (.not. allocated(DstMiscData%Line2_to_Point_Motions)) then
         allocate(DstMiscData%Line2_to_Point_Motions(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%Line2_to_Point_Motions.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyMeshMapType(SrcMiscData%Line2_to_Point_Motions(i1), DstMiscData%Line2_to_Point_Motions(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (associated(SrcMiscData%FlowField)) then
      if (.not. associated(DstMiscData%FlowField)) then
         allocate(DstMiscData%FlowField, stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%FlowField.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      call IfW_FlowField_CopyFlowFieldType(SrcMiscData%FlowField, DstMiscData%FlowField, CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end if
end subroutine

subroutine ExtInfw_DestroyMisc(MiscData, ErrStat, ErrMsg)
   type(ExtInfw_MiscVarType), intent(inout) :: MiscData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ExtInfw_DestroyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(MiscData%ActForceMotionsPoints)) then
      LB(1:1) = lbound(MiscData%ActForceMotionsPoints)
      UB(1:1) = ubound(MiscData%ActForceMotionsPoints)
      do i1 = LB(1), UB(1)
         call MeshDestroy( MiscData%ActForceMotionsPoints(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MiscData%ActForceMotionsPoints)
   end if
   if (allocated(MiscData%ActForceLoadsPoints)) then
      LB(1:1) = lbound(MiscData%ActForceLoadsPoints)
      UB(1:1) = ubound(MiscData%ActForceLoadsPoints)
      do i1 = LB(1), UB(1)
         call MeshDestroy( MiscData%ActForceLoadsPoints(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MiscData%ActForceLoadsPoints)
   end if
   if (allocated(MiscData%Line2_to_Point_Loads)) then
      LB(1:1) = lbound(MiscData%Line2_to_Point_Loads)
      UB(1:1) = ubound(MiscData%Line2_to_Point_Loads)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyMeshMapType(MiscData%Line2_to_Point_Loads(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MiscData%Line2_to_Point_Loads)
   end if
   if (allocated(MiscData%Line2_to_Point_Motions)) then
      LB(1:1) = lbound(MiscData%Line2_to_Point_Motions)
      UB(1:1) = ubound(MiscData%Line2_to_Point_Motions)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyMeshMapType(MiscData%Line2_to_Point_Motions(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MiscData%Line2_to_Point_Motions)
   end if
   if (associated(MiscData%FlowField)) then
      call IfW_FlowField_DestroyFlowFieldType(MiscData%FlowField, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      deallocate(MiscData%FlowField)
      MiscData%FlowField => null()
   end if
end subroutine

subroutine ExtInfw_PackMisc(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ExtInfw_MiscVarType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ExtInfw_PackMisc'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   logical         :: PtrInIndex
   if (RF%ErrStat >= AbortErrLev) return
   if (c_associated(InData%C_obj%object)) then
      RF%ErrStat = ErrID_Fatal
      RF%ErrMsg = RoutineName//': C_obj%object cannot be packed.'
      return
   end if
   call RegPack(RF, allocated(InData%ActForceMotionsPoints))
   if (allocated(InData%ActForceMotionsPoints)) then
      call RegPackBounds(RF, 1, lbound(InData%ActForceMotionsPoints), ubound(InData%ActForceMotionsPoints))
      LB(1:1) = lbound(InData%ActForceMotionsPoints)
      UB(1:1) = ubound(InData%ActForceMotionsPoints)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%ActForceMotionsPoints(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%ActForceLoadsPoints))
   if (allocated(InData%ActForceLoadsPoints)) then
      call RegPackBounds(RF, 1, lbound(InData%ActForceLoadsPoints), ubound(InData%ActForceLoadsPoints))
      LB(1:1) = lbound(InData%ActForceLoadsPoints)
      UB(1:1) = ubound(InData%ActForceLoadsPoints)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%ActForceLoadsPoints(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%Line2_to_Point_Loads))
   if (allocated(InData%Line2_to_Point_Loads)) then
      call RegPackBounds(RF, 1, lbound(InData%Line2_to_Point_Loads), ubound(InData%Line2_to_Point_Loads))
      LB(1:1) = lbound(InData%Line2_to_Point_Loads)
      UB(1:1) = ubound(InData%Line2_to_Point_Loads)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackMeshMapType(RF, InData%Line2_to_Point_Loads(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%Line2_to_Point_Motions))
   if (allocated(InData%Line2_to_Point_Motions)) then
      call RegPackBounds(RF, 1, lbound(InData%Line2_to_Point_Motions), ubound(InData%Line2_to_Point_Motions))
      LB(1:1) = lbound(InData%Line2_to_Point_Motions)
      UB(1:1) = ubound(InData%Line2_to_Point_Motions)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackMeshMapType(RF, InData%Line2_to_Point_Motions(i1)) 
      end do
   end if
   call RegPack(RF, associated(InData%FlowField))
   if (associated(InData%FlowField)) then
      call RegPackPointer(RF, c_loc(InData%FlowField), PtrInIndex)
      if (.not. PtrInIndex) then
         call IfW_FlowField_PackFlowFieldType(RF, InData%FlowField) 
      end if
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtInfw_UnPackMisc(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ExtInfw_MiscVarType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ExtInfw_UnPackMisc'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   integer(B8Ki)   :: PtrIdx
   type(c_ptr)     :: Ptr
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%ActForceMotionsPoints)) deallocate(OutData%ActForceMotionsPoints)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%ActForceMotionsPoints(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%ActForceMotionsPoints.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%ActForceMotionsPoints(i1)) ! ActForceMotionsPoints 
      end do
   end if
   if (allocated(OutData%ActForceLoadsPoints)) deallocate(OutData%ActForceLoadsPoints)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%ActForceLoadsPoints(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%ActForceLoadsPoints.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%ActForceLoadsPoints(i1)) ! ActForceLoadsPoints 
      end do
   end if
   if (allocated(OutData%Line2_to_Point_Loads)) deallocate(OutData%Line2_to_Point_Loads)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Line2_to_Point_Loads(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Line2_to_Point_Loads.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackMeshMapType(RF, OutData%Line2_to_Point_Loads(i1)) ! Line2_to_Point_Loads 
      end do
   end if
   if (allocated(OutData%Line2_to_Point_Motions)) deallocate(OutData%Line2_to_Point_Motions)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Line2_to_Point_Motions(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Line2_to_Point_Motions.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackMeshMapType(RF, OutData%Line2_to_Point_Motions(i1)) ! Line2_to_Point_Motions 
      end do
   end if
   if (associated(OutData%FlowField)) deallocate(OutData%FlowField)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackPointer(RF, Ptr, PtrIdx); if (RegCheckErr(RF, RoutineName)) return
      if (c_associated(Ptr)) then
         call c_f_pointer(Ptr, OutData%FlowField)
      else
         allocate(OutData%FlowField,stat=stat)
         if (stat /= 0) then 
            call SetErrStat(ErrID_Fatal, 'Error allocating OutData%FlowField.', RF%ErrStat, RF%ErrMsg, RoutineName)
            return
         end if
         RF%Pointers(PtrIdx) = c_loc(OutData%FlowField)
         call IfW_FlowField_UnpackFlowFieldType(RF, OutData%FlowField) ! FlowField 
      end if
   else
      OutData%FlowField => null()
   end if
end subroutine

SUBROUTINE ExtInfw_C2Fary_CopyMisc(MiscData, ErrStat, ErrMsg, SkipPointers)
   TYPE(ExtInfw_MiscVarType), INTENT(INOUT) :: MiscData
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
   LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
   ! 
   LOGICAL                        :: SkipPointers_local
   ErrStat = ErrID_None
   ErrMsg  = ""
   
   IF (PRESENT(SkipPointers)) THEN
      SkipPointers_local = SkipPointers
   ELSE
      SkipPointers_local = .false.
   END IF
END SUBROUTINE

SUBROUTINE ExtInfw_F2C_CopyMisc( MiscData, ErrStat, ErrMsg, SkipPointers  )
   TYPE(ExtInfw_MiscVarType), INTENT(INOUT) :: MiscData
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
   LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
   ! 
   LOGICAL                        :: SkipPointers_local
   ErrStat = ErrID_None
   ErrMsg  = ''
   
   IF (PRESENT(SkipPointers)) THEN
      SkipPointers_local = SkipPointers
   ELSE
      SkipPointers_local = .false.
   END IF
END SUBROUTINE

subroutine ExtInfw_CopyParam(SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg)
   type(ExtInfw_ParameterType), intent(in) :: SrcParamData
   type(ExtInfw_ParameterType), intent(inout) :: DstParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'ExtInfw_CopyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstParamData%AirDens = SrcParamData%AirDens
   DstParamData%C_obj%AirDens = SrcParamData%C_obj%AirDens
   DstParamData%NumBl = SrcParamData%NumBl
   DstParamData%C_obj%NumBl = SrcParamData%C_obj%NumBl
   DstParamData%NMappings = SrcParamData%NMappings
   DstParamData%C_obj%NMappings = SrcParamData%C_obj%NMappings
   DstParamData%NnodesVel = SrcParamData%NnodesVel
   DstParamData%C_obj%NnodesVel = SrcParamData%C_obj%NnodesVel
   DstParamData%NnodesForce = SrcParamData%NnodesForce
   DstParamData%C_obj%NnodesForce = SrcParamData%C_obj%NnodesForce
   DstParamData%NnodesForceBlade = SrcParamData%NnodesForceBlade
   DstParamData%C_obj%NnodesForceBlade = SrcParamData%C_obj%NnodesForceBlade
   DstParamData%NnodesForceTower = SrcParamData%NnodesForceTower
   DstParamData%C_obj%NnodesForceTower = SrcParamData%C_obj%NnodesForceTower
   if (associated(SrcParamData%forceBldRnodes)) then
      LB(1:1) = lbound(SrcParamData%forceBldRnodes)
      UB(1:1) = ubound(SrcParamData%forceBldRnodes)
      if (.not. associated(DstParamData%forceBldRnodes)) then
         allocate(DstParamData%forceBldRnodes(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%forceBldRnodes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstParamData%C_obj%forceBldRnodes_Len = size(DstParamData%forceBldRnodes)
         if (DstParamData%C_obj%forceBldRnodes_Len > 0) &
            DstParamData%C_obj%forceBldRnodes = c_loc(DstParamData%forceBldRnodes(LB(1)))
      end if
      DstParamData%forceBldRnodes = SrcParamData%forceBldRnodes
   end if
   if (associated(SrcParamData%forceTwrHnodes)) then
      LB(1:1) = lbound(SrcParamData%forceTwrHnodes)
      UB(1:1) = ubound(SrcParamData%forceTwrHnodes)
      if (.not. associated(DstParamData%forceTwrHnodes)) then
         allocate(DstParamData%forceTwrHnodes(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%forceTwrHnodes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstParamData%C_obj%forceTwrHnodes_Len = size(DstParamData%forceTwrHnodes)
         if (DstParamData%C_obj%forceTwrHnodes_Len > 0) &
            DstParamData%C_obj%forceTwrHnodes = c_loc(DstParamData%forceTwrHnodes(LB(1)))
      end if
      DstParamData%forceTwrHnodes = SrcParamData%forceTwrHnodes
   end if
   DstParamData%BladeLength = SrcParamData%BladeLength
   DstParamData%C_obj%BladeLength = SrcParamData%C_obj%BladeLength
   DstParamData%TowerHeight = SrcParamData%TowerHeight
   DstParamData%C_obj%TowerHeight = SrcParamData%C_obj%TowerHeight
   DstParamData%TowerBaseHeight = SrcParamData%TowerBaseHeight
   DstParamData%C_obj%TowerBaseHeight = SrcParamData%C_obj%TowerBaseHeight
   DstParamData%NodeClusterType = SrcParamData%NodeClusterType
   DstParamData%C_obj%NodeClusterType = SrcParamData%C_obj%NodeClusterType
end subroutine

subroutine ExtInfw_DestroyParam(ParamData, ErrStat, ErrMsg)
   type(ExtInfw_ParameterType), intent(inout) :: ParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ExtInfw_DestroyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (associated(ParamData%forceBldRnodes)) then
      deallocate(ParamData%forceBldRnodes)
      ParamData%forceBldRnodes => null()
      ParamData%C_obj%forceBldRnodes = c_null_ptr
      ParamData%C_obj%forceBldRnodes_Len = 0
   end if
   if (associated(ParamData%forceTwrHnodes)) then
      deallocate(ParamData%forceTwrHnodes)
      ParamData%forceTwrHnodes => null()
      ParamData%C_obj%forceTwrHnodes = c_null_ptr
      ParamData%C_obj%forceTwrHnodes_Len = 0
   end if
end subroutine

subroutine ExtInfw_PackParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ExtInfw_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ExtInfw_PackParam'
   logical         :: PtrInIndex
   if (RF%ErrStat >= AbortErrLev) return
   if (c_associated(InData%C_obj%object)) then
      RF%ErrStat = ErrID_Fatal
      RF%ErrMsg = RoutineName//': C_obj%object cannot be packed.'
      return
   end if
   call RegPack(RF, InData%AirDens)
   call RegPack(RF, InData%NumBl)
   call RegPack(RF, InData%NMappings)
   call RegPack(RF, InData%NnodesVel)
   call RegPack(RF, InData%NnodesForce)
   call RegPack(RF, InData%NnodesForceBlade)
   call RegPack(RF, InData%NnodesForceTower)
   call RegPackPtr(RF, InData%forceBldRnodes)
   call RegPackPtr(RF, InData%forceTwrHnodes)
   call RegPack(RF, InData%BladeLength)
   call RegPack(RF, InData%TowerHeight)
   call RegPack(RF, InData%TowerBaseHeight)
   call RegPack(RF, InData%NodeClusterType)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtInfw_UnPackParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ExtInfw_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ExtInfw_UnPackParam'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   integer(B8Ki)   :: PtrIdx
   type(c_ptr)     :: Ptr
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%AirDens); if (RegCheckErr(RF, RoutineName)) return
   OutData%C_obj%AirDens = OutData%AirDens
   call RegUnpack(RF, OutData%NumBl); if (RegCheckErr(RF, RoutineName)) return
   OutData%C_obj%NumBl = OutData%NumBl
   call RegUnpack(RF, OutData%NMappings); if (RegCheckErr(RF, RoutineName)) return
   OutData%C_obj%NMappings = OutData%NMappings
   call RegUnpack(RF, OutData%NnodesVel); if (RegCheckErr(RF, RoutineName)) return
   OutData%C_obj%NnodesVel = OutData%NnodesVel
   call RegUnpack(RF, OutData%NnodesForce); if (RegCheckErr(RF, RoutineName)) return
   OutData%C_obj%NnodesForce = OutData%NnodesForce
   call RegUnpack(RF, OutData%NnodesForceBlade); if (RegCheckErr(RF, RoutineName)) return
   OutData%C_obj%NnodesForceBlade = OutData%NnodesForceBlade
   call RegUnpack(RF, OutData%NnodesForceTower); if (RegCheckErr(RF, RoutineName)) return
   OutData%C_obj%NnodesForceTower = OutData%NnodesForceTower
   call RegUnpackPtr(RF, OutData%forceBldRnodes, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%forceBldRnodes)) then
      OutData%C_obj%forceBldRnodes_Len = size(OutData%forceBldRnodes)
      if (OutData%C_obj%forceBldRnodes_Len > 0) OutData%C_obj%forceBldRnodes = c_loc(OutData%forceBldRnodes(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%forceTwrHnodes, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%forceTwrHnodes)) then
      OutData%C_obj%forceTwrHnodes_Len = size(OutData%forceTwrHnodes)
      if (OutData%C_obj%forceTwrHnodes_Len > 0) OutData%C_obj%forceTwrHnodes = c_loc(OutData%forceTwrHnodes(LB(1)))
   end if
   call RegUnpack(RF, OutData%BladeLength); if (RegCheckErr(RF, RoutineName)) return
   OutData%C_obj%BladeLength = OutData%BladeLength
   call RegUnpack(RF, OutData%TowerHeight); if (RegCheckErr(RF, RoutineName)) return
   OutData%C_obj%TowerHeight = OutData%TowerHeight
   call RegUnpack(RF, OutData%TowerBaseHeight); if (RegCheckErr(RF, RoutineName)) return
   OutData%C_obj%TowerBaseHeight = OutData%TowerBaseHeight
   call RegUnpack(RF, OutData%NodeClusterType); if (RegCheckErr(RF, RoutineName)) return
   OutData%C_obj%NodeClusterType = OutData%NodeClusterType
end subroutine

SUBROUTINE ExtInfw_C2Fary_CopyParam(ParamData, ErrStat, ErrMsg, SkipPointers)
   TYPE(ExtInfw_ParameterType), INTENT(INOUT) :: ParamData
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
   LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
   ! 
   LOGICAL                        :: SkipPointers_local
   ErrStat = ErrID_None
   ErrMsg  = ""
   
   IF (PRESENT(SkipPointers)) THEN
      SkipPointers_local = SkipPointers
   ELSE
      SkipPointers_local = .false.
   END IF
   ParamData%AirDens = ParamData%C_obj%AirDens
   ParamData%NumBl = ParamData%C_obj%NumBl
   ParamData%NMappings = ParamData%C_obj%NMappings
   ParamData%NnodesVel = ParamData%C_obj%NnodesVel
   ParamData%NnodesForce = ParamData%C_obj%NnodesForce
   ParamData%NnodesForceBlade = ParamData%C_obj%NnodesForceBlade
   ParamData%NnodesForceTower = ParamData%C_obj%NnodesForceTower
   
   ! -- forceBldRnodes Param Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( ParamData%C_obj%forceBldRnodes ) ) THEN
         NULLIFY( ParamData%forceBldRnodes )
      ELSE
         CALL C_F_POINTER(ParamData%C_obj%forceBldRnodes, ParamData%forceBldRnodes, [ParamData%C_obj%forceBldRnodes_Len])
      END IF
   END IF
   
   ! -- forceTwrHnodes Param Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( ParamData%C_obj%forceTwrHnodes ) ) THEN
         NULLIFY( ParamData%forceTwrHnodes )
      ELSE
         CALL C_F_POINTER(ParamData%C_obj%forceTwrHnodes, ParamData%forceTwrHnodes, [ParamData%C_obj%forceTwrHnodes_Len])
      END IF
   END IF
   ParamData%BladeLength = ParamData%C_obj%BladeLength
   ParamData%TowerHeight = ParamData%C_obj%TowerHeight
   ParamData%TowerBaseHeight = ParamData%C_obj%TowerBaseHeight
   ParamData%NodeClusterType = ParamData%C_obj%NodeClusterType
END SUBROUTINE

SUBROUTINE ExtInfw_F2C_CopyParam( ParamData, ErrStat, ErrMsg, SkipPointers  )
   TYPE(ExtInfw_ParameterType), INTENT(INOUT) :: ParamData
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
   LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
   ! 
   LOGICAL                        :: SkipPointers_local
   ErrStat = ErrID_None
   ErrMsg  = ''
   
   IF (PRESENT(SkipPointers)) THEN
      SkipPointers_local = SkipPointers
   ELSE
      SkipPointers_local = .false.
   END IF
   ParamData%C_obj%AirDens = ParamData%AirDens
   ParamData%C_obj%NumBl = ParamData%NumBl
   ParamData%C_obj%NMappings = ParamData%NMappings
   ParamData%C_obj%NnodesVel = ParamData%NnodesVel
   ParamData%C_obj%NnodesForce = ParamData%NnodesForce
   ParamData%C_obj%NnodesForceBlade = ParamData%NnodesForceBlade
   ParamData%C_obj%NnodesForceTower = ParamData%NnodesForceTower
   
   ! -- forceBldRnodes Param Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(ParamData%forceBldRnodes)) THEN 
         ParamData%C_obj%forceBldRnodes_Len = 0
         ParamData%C_obj%forceBldRnodes = C_NULL_PTR
      ELSE
         ParamData%C_obj%forceBldRnodes_Len = SIZE(ParamData%forceBldRnodes)
         IF (ParamData%C_obj%forceBldRnodes_Len > 0) &
            ParamData%C_obj%forceBldRnodes = C_LOC(ParamData%forceBldRnodes(lbound(ParamData%forceBldRnodes,1)))
      END IF
   END IF
   
   ! -- forceTwrHnodes Param Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(ParamData%forceTwrHnodes)) THEN 
         ParamData%C_obj%forceTwrHnodes_Len = 0
         ParamData%C_obj%forceTwrHnodes = C_NULL_PTR
      ELSE
         ParamData%C_obj%forceTwrHnodes_Len = SIZE(ParamData%forceTwrHnodes)
         IF (ParamData%C_obj%forceTwrHnodes_Len > 0) &
            ParamData%C_obj%forceTwrHnodes = C_LOC(ParamData%forceTwrHnodes(lbound(ParamData%forceTwrHnodes,1)))
      END IF
   END IF
   ParamData%C_obj%BladeLength = ParamData%BladeLength
   ParamData%C_obj%TowerHeight = ParamData%TowerHeight
   ParamData%C_obj%TowerBaseHeight = ParamData%TowerBaseHeight
   ParamData%C_obj%NodeClusterType = ParamData%NodeClusterType
END SUBROUTINE

subroutine ExtInfw_CopyInput(SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg)
   type(ExtInfw_InputType), intent(in) :: SrcInputData
   type(ExtInfw_InputType), intent(inout) :: DstInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'ExtInfw_CopyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (associated(SrcInputData%pxVel)) then
      LB(1:1) = lbound(SrcInputData%pxVel)
      UB(1:1) = ubound(SrcInputData%pxVel)
      if (.not. associated(DstInputData%pxVel)) then
         allocate(DstInputData%pxVel(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%pxVel.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstInputData%C_obj%pxVel_Len = size(DstInputData%pxVel)
         if (DstInputData%C_obj%pxVel_Len > 0) &
            DstInputData%C_obj%pxVel = c_loc(DstInputData%pxVel(LB(1)))
      end if
      DstInputData%pxVel = SrcInputData%pxVel
   end if
   if (associated(SrcInputData%pyVel)) then
      LB(1:1) = lbound(SrcInputData%pyVel)
      UB(1:1) = ubound(SrcInputData%pyVel)
      if (.not. associated(DstInputData%pyVel)) then
         allocate(DstInputData%pyVel(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%pyVel.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstInputData%C_obj%pyVel_Len = size(DstInputData%pyVel)
         if (DstInputData%C_obj%pyVel_Len > 0) &
            DstInputData%C_obj%pyVel = c_loc(DstInputData%pyVel(LB(1)))
      end if
      DstInputData%pyVel = SrcInputData%pyVel
   end if
   if (associated(SrcInputData%pzVel)) then
      LB(1:1) = lbound(SrcInputData%pzVel)
      UB(1:1) = ubound(SrcInputData%pzVel)
      if (.not. associated(DstInputData%pzVel)) then
         allocate(DstInputData%pzVel(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%pzVel.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstInputData%C_obj%pzVel_Len = size(DstInputData%pzVel)
         if (DstInputData%C_obj%pzVel_Len > 0) &
            DstInputData%C_obj%pzVel = c_loc(DstInputData%pzVel(LB(1)))
      end if
      DstInputData%pzVel = SrcInputData%pzVel
   end if
   if (associated(SrcInputData%pxForce)) then
      LB(1:1) = lbound(SrcInputData%pxForce)
      UB(1:1) = ubound(SrcInputData%pxForce)
      if (.not. associated(DstInputData%pxForce)) then
         allocate(DstInputData%pxForce(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%pxForce.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstInputData%C_obj%pxForce_Len = size(DstInputData%pxForce)
         if (DstInputData%C_obj%pxForce_Len > 0) &
            DstInputData%C_obj%pxForce = c_loc(DstInputData%pxForce(LB(1)))
      end if
      DstInputData%pxForce = SrcInputData%pxForce
   end if
   if (associated(SrcInputData%pyForce)) then
      LB(1:1) = lbound(SrcInputData%pyForce)
      UB(1:1) = ubound(SrcInputData%pyForce)
      if (.not. associated(DstInputData%pyForce)) then
         allocate(DstInputData%pyForce(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%pyForce.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstInputData%C_obj%pyForce_Len = size(DstInputData%pyForce)
         if (DstInputData%C_obj%pyForce_Len > 0) &
            DstInputData%C_obj%pyForce = c_loc(DstInputData%pyForce(LB(1)))
      end if
      DstInputData%pyForce = SrcInputData%pyForce
   end if
   if (associated(SrcInputData%pzForce)) then
      LB(1:1) = lbound(SrcInputData%pzForce)
      UB(1:1) = ubound(SrcInputData%pzForce)
      if (.not. associated(DstInputData%pzForce)) then
         allocate(DstInputData%pzForce(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%pzForce.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstInputData%C_obj%pzForce_Len = size(DstInputData%pzForce)
         if (DstInputData%C_obj%pzForce_Len > 0) &
            DstInputData%C_obj%pzForce = c_loc(DstInputData%pzForce(LB(1)))
      end if
      DstInputData%pzForce = SrcInputData%pzForce
   end if
   if (associated(SrcInputData%xdotForce)) then
      LB(1:1) = lbound(SrcInputData%xdotForce)
      UB(1:1) = ubound(SrcInputData%xdotForce)
      if (.not. associated(DstInputData%xdotForce)) then
         allocate(DstInputData%xdotForce(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%xdotForce.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstInputData%C_obj%xdotForce_Len = size(DstInputData%xdotForce)
         if (DstInputData%C_obj%xdotForce_Len > 0) &
            DstInputData%C_obj%xdotForce = c_loc(DstInputData%xdotForce(LB(1)))
      end if
      DstInputData%xdotForce = SrcInputData%xdotForce
   end if
   if (associated(SrcInputData%ydotForce)) then
      LB(1:1) = lbound(SrcInputData%ydotForce)
      UB(1:1) = ubound(SrcInputData%ydotForce)
      if (.not. associated(DstInputData%ydotForce)) then
         allocate(DstInputData%ydotForce(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%ydotForce.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstInputData%C_obj%ydotForce_Len = size(DstInputData%ydotForce)
         if (DstInputData%C_obj%ydotForce_Len > 0) &
            DstInputData%C_obj%ydotForce = c_loc(DstInputData%ydotForce(LB(1)))
      end if
      DstInputData%ydotForce = SrcInputData%ydotForce
   end if
   if (associated(SrcInputData%zdotForce)) then
      LB(1:1) = lbound(SrcInputData%zdotForce)
      UB(1:1) = ubound(SrcInputData%zdotForce)
      if (.not. associated(DstInputData%zdotForce)) then
         allocate(DstInputData%zdotForce(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%zdotForce.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstInputData%C_obj%zdotForce_Len = size(DstInputData%zdotForce)
         if (DstInputData%C_obj%zdotForce_Len > 0) &
            DstInputData%C_obj%zdotForce = c_loc(DstInputData%zdotForce(LB(1)))
      end if
      DstInputData%zdotForce = SrcInputData%zdotForce
   end if
   if (associated(SrcInputData%pOrientation)) then
      LB(1:1) = lbound(SrcInputData%pOrientation)
      UB(1:1) = ubound(SrcInputData%pOrientation)
      if (.not. associated(DstInputData%pOrientation)) then
         allocate(DstInputData%pOrientation(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%pOrientation.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstInputData%C_obj%pOrientation_Len = size(DstInputData%pOrientation)
         if (DstInputData%C_obj%pOrientation_Len > 0) &
            DstInputData%C_obj%pOrientation = c_loc(DstInputData%pOrientation(LB(1)))
      end if
      DstInputData%pOrientation = SrcInputData%pOrientation
   end if
   if (associated(SrcInputData%fx)) then
      LB(1:1) = lbound(SrcInputData%fx)
      UB(1:1) = ubound(SrcInputData%fx)
      if (.not. associated(DstInputData%fx)) then
         allocate(DstInputData%fx(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%fx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstInputData%C_obj%fx_Len = size(DstInputData%fx)
         if (DstInputData%C_obj%fx_Len > 0) &
            DstInputData%C_obj%fx = c_loc(DstInputData%fx(LB(1)))
      end if
      DstInputData%fx = SrcInputData%fx
   end if
   if (associated(SrcInputData%fy)) then
      LB(1:1) = lbound(SrcInputData%fy)
      UB(1:1) = ubound(SrcInputData%fy)
      if (.not. associated(DstInputData%fy)) then
         allocate(DstInputData%fy(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%fy.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstInputData%C_obj%fy_Len = size(DstInputData%fy)
         if (DstInputData%C_obj%fy_Len > 0) &
            DstInputData%C_obj%fy = c_loc(DstInputData%fy(LB(1)))
      end if
      DstInputData%fy = SrcInputData%fy
   end if
   if (associated(SrcInputData%fz)) then
      LB(1:1) = lbound(SrcInputData%fz)
      UB(1:1) = ubound(SrcInputData%fz)
      if (.not. associated(DstInputData%fz)) then
         allocate(DstInputData%fz(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%fz.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstInputData%C_obj%fz_Len = size(DstInputData%fz)
         if (DstInputData%C_obj%fz_Len > 0) &
            DstInputData%C_obj%fz = c_loc(DstInputData%fz(LB(1)))
      end if
      DstInputData%fz = SrcInputData%fz
   end if
   if (associated(SrcInputData%momentx)) then
      LB(1:1) = lbound(SrcInputData%momentx)
      UB(1:1) = ubound(SrcInputData%momentx)
      if (.not. associated(DstInputData%momentx)) then
         allocate(DstInputData%momentx(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%momentx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstInputData%C_obj%momentx_Len = size(DstInputData%momentx)
         if (DstInputData%C_obj%momentx_Len > 0) &
            DstInputData%C_obj%momentx = c_loc(DstInputData%momentx(LB(1)))
      end if
      DstInputData%momentx = SrcInputData%momentx
   end if
   if (associated(SrcInputData%momenty)) then
      LB(1:1) = lbound(SrcInputData%momenty)
      UB(1:1) = ubound(SrcInputData%momenty)
      if (.not. associated(DstInputData%momenty)) then
         allocate(DstInputData%momenty(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%momenty.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstInputData%C_obj%momenty_Len = size(DstInputData%momenty)
         if (DstInputData%C_obj%momenty_Len > 0) &
            DstInputData%C_obj%momenty = c_loc(DstInputData%momenty(LB(1)))
      end if
      DstInputData%momenty = SrcInputData%momenty
   end if
   if (associated(SrcInputData%momentz)) then
      LB(1:1) = lbound(SrcInputData%momentz)
      UB(1:1) = ubound(SrcInputData%momentz)
      if (.not. associated(DstInputData%momentz)) then
         allocate(DstInputData%momentz(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%momentz.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstInputData%C_obj%momentz_Len = size(DstInputData%momentz)
         if (DstInputData%C_obj%momentz_Len > 0) &
            DstInputData%C_obj%momentz = c_loc(DstInputData%momentz(LB(1)))
      end if
      DstInputData%momentz = SrcInputData%momentz
   end if
   if (associated(SrcInputData%forceNodesChord)) then
      LB(1:1) = lbound(SrcInputData%forceNodesChord)
      UB(1:1) = ubound(SrcInputData%forceNodesChord)
      if (.not. associated(DstInputData%forceNodesChord)) then
         allocate(DstInputData%forceNodesChord(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%forceNodesChord.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstInputData%C_obj%forceNodesChord_Len = size(DstInputData%forceNodesChord)
         if (DstInputData%C_obj%forceNodesChord_Len > 0) &
            DstInputData%C_obj%forceNodesChord = c_loc(DstInputData%forceNodesChord(LB(1)))
      end if
      DstInputData%forceNodesChord = SrcInputData%forceNodesChord
   end if
end subroutine

subroutine ExtInfw_DestroyInput(InputData, ErrStat, ErrMsg)
   type(ExtInfw_InputType), intent(inout) :: InputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ExtInfw_DestroyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (associated(InputData%pxVel)) then
      deallocate(InputData%pxVel)
      InputData%pxVel => null()
      InputData%C_obj%pxVel = c_null_ptr
      InputData%C_obj%pxVel_Len = 0
   end if
   if (associated(InputData%pyVel)) then
      deallocate(InputData%pyVel)
      InputData%pyVel => null()
      InputData%C_obj%pyVel = c_null_ptr
      InputData%C_obj%pyVel_Len = 0
   end if
   if (associated(InputData%pzVel)) then
      deallocate(InputData%pzVel)
      InputData%pzVel => null()
      InputData%C_obj%pzVel = c_null_ptr
      InputData%C_obj%pzVel_Len = 0
   end if
   if (associated(InputData%pxForce)) then
      deallocate(InputData%pxForce)
      InputData%pxForce => null()
      InputData%C_obj%pxForce = c_null_ptr
      InputData%C_obj%pxForce_Len = 0
   end if
   if (associated(InputData%pyForce)) then
      deallocate(InputData%pyForce)
      InputData%pyForce => null()
      InputData%C_obj%pyForce = c_null_ptr
      InputData%C_obj%pyForce_Len = 0
   end if
   if (associated(InputData%pzForce)) then
      deallocate(InputData%pzForce)
      InputData%pzForce => null()
      InputData%C_obj%pzForce = c_null_ptr
      InputData%C_obj%pzForce_Len = 0
   end if
   if (associated(InputData%xdotForce)) then
      deallocate(InputData%xdotForce)
      InputData%xdotForce => null()
      InputData%C_obj%xdotForce = c_null_ptr
      InputData%C_obj%xdotForce_Len = 0
   end if
   if (associated(InputData%ydotForce)) then
      deallocate(InputData%ydotForce)
      InputData%ydotForce => null()
      InputData%C_obj%ydotForce = c_null_ptr
      InputData%C_obj%ydotForce_Len = 0
   end if
   if (associated(InputData%zdotForce)) then
      deallocate(InputData%zdotForce)
      InputData%zdotForce => null()
      InputData%C_obj%zdotForce = c_null_ptr
      InputData%C_obj%zdotForce_Len = 0
   end if
   if (associated(InputData%pOrientation)) then
      deallocate(InputData%pOrientation)
      InputData%pOrientation => null()
      InputData%C_obj%pOrientation = c_null_ptr
      InputData%C_obj%pOrientation_Len = 0
   end if
   if (associated(InputData%fx)) then
      deallocate(InputData%fx)
      InputData%fx => null()
      InputData%C_obj%fx = c_null_ptr
      InputData%C_obj%fx_Len = 0
   end if
   if (associated(InputData%fy)) then
      deallocate(InputData%fy)
      InputData%fy => null()
      InputData%C_obj%fy = c_null_ptr
      InputData%C_obj%fy_Len = 0
   end if
   if (associated(InputData%fz)) then
      deallocate(InputData%fz)
      InputData%fz => null()
      InputData%C_obj%fz = c_null_ptr
      InputData%C_obj%fz_Len = 0
   end if
   if (associated(InputData%momentx)) then
      deallocate(InputData%momentx)
      InputData%momentx => null()
      InputData%C_obj%momentx = c_null_ptr
      InputData%C_obj%momentx_Len = 0
   end if
   if (associated(InputData%momenty)) then
      deallocate(InputData%momenty)
      InputData%momenty => null()
      InputData%C_obj%momenty = c_null_ptr
      InputData%C_obj%momenty_Len = 0
   end if
   if (associated(InputData%momentz)) then
      deallocate(InputData%momentz)
      InputData%momentz => null()
      InputData%C_obj%momentz = c_null_ptr
      InputData%C_obj%momentz_Len = 0
   end if
   if (associated(InputData%forceNodesChord)) then
      deallocate(InputData%forceNodesChord)
      InputData%forceNodesChord => null()
      InputData%C_obj%forceNodesChord = c_null_ptr
      InputData%C_obj%forceNodesChord_Len = 0
   end if
end subroutine

subroutine ExtInfw_PackInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ExtInfw_InputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ExtInfw_PackInput'
   logical         :: PtrInIndex
   if (RF%ErrStat >= AbortErrLev) return
   if (c_associated(InData%C_obj%object)) then
      RF%ErrStat = ErrID_Fatal
      RF%ErrMsg = RoutineName//': C_obj%object cannot be packed.'
      return
   end if
   call RegPackPtr(RF, InData%pxVel)
   call RegPackPtr(RF, InData%pyVel)
   call RegPackPtr(RF, InData%pzVel)
   call RegPackPtr(RF, InData%pxForce)
   call RegPackPtr(RF, InData%pyForce)
   call RegPackPtr(RF, InData%pzForce)
   call RegPackPtr(RF, InData%xdotForce)
   call RegPackPtr(RF, InData%ydotForce)
   call RegPackPtr(RF, InData%zdotForce)
   call RegPackPtr(RF, InData%pOrientation)
   call RegPackPtr(RF, InData%fx)
   call RegPackPtr(RF, InData%fy)
   call RegPackPtr(RF, InData%fz)
   call RegPackPtr(RF, InData%momentx)
   call RegPackPtr(RF, InData%momenty)
   call RegPackPtr(RF, InData%momentz)
   call RegPackPtr(RF, InData%forceNodesChord)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtInfw_UnPackInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ExtInfw_InputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ExtInfw_UnPackInput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   integer(B8Ki)   :: PtrIdx
   type(c_ptr)     :: Ptr
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackPtr(RF, OutData%pxVel, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%pxVel)) then
      OutData%C_obj%pxVel_Len = size(OutData%pxVel)
      if (OutData%C_obj%pxVel_Len > 0) OutData%C_obj%pxVel = c_loc(OutData%pxVel(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%pyVel, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%pyVel)) then
      OutData%C_obj%pyVel_Len = size(OutData%pyVel)
      if (OutData%C_obj%pyVel_Len > 0) OutData%C_obj%pyVel = c_loc(OutData%pyVel(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%pzVel, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%pzVel)) then
      OutData%C_obj%pzVel_Len = size(OutData%pzVel)
      if (OutData%C_obj%pzVel_Len > 0) OutData%C_obj%pzVel = c_loc(OutData%pzVel(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%pxForce, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%pxForce)) then
      OutData%C_obj%pxForce_Len = size(OutData%pxForce)
      if (OutData%C_obj%pxForce_Len > 0) OutData%C_obj%pxForce = c_loc(OutData%pxForce(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%pyForce, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%pyForce)) then
      OutData%C_obj%pyForce_Len = size(OutData%pyForce)
      if (OutData%C_obj%pyForce_Len > 0) OutData%C_obj%pyForce = c_loc(OutData%pyForce(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%pzForce, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%pzForce)) then
      OutData%C_obj%pzForce_Len = size(OutData%pzForce)
      if (OutData%C_obj%pzForce_Len > 0) OutData%C_obj%pzForce = c_loc(OutData%pzForce(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%xdotForce, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%xdotForce)) then
      OutData%C_obj%xdotForce_Len = size(OutData%xdotForce)
      if (OutData%C_obj%xdotForce_Len > 0) OutData%C_obj%xdotForce = c_loc(OutData%xdotForce(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%ydotForce, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%ydotForce)) then
      OutData%C_obj%ydotForce_Len = size(OutData%ydotForce)
      if (OutData%C_obj%ydotForce_Len > 0) OutData%C_obj%ydotForce = c_loc(OutData%ydotForce(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%zdotForce, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%zdotForce)) then
      OutData%C_obj%zdotForce_Len = size(OutData%zdotForce)
      if (OutData%C_obj%zdotForce_Len > 0) OutData%C_obj%zdotForce = c_loc(OutData%zdotForce(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%pOrientation, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%pOrientation)) then
      OutData%C_obj%pOrientation_Len = size(OutData%pOrientation)
      if (OutData%C_obj%pOrientation_Len > 0) OutData%C_obj%pOrientation = c_loc(OutData%pOrientation(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%fx, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%fx)) then
      OutData%C_obj%fx_Len = size(OutData%fx)
      if (OutData%C_obj%fx_Len > 0) OutData%C_obj%fx = c_loc(OutData%fx(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%fy, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%fy)) then
      OutData%C_obj%fy_Len = size(OutData%fy)
      if (OutData%C_obj%fy_Len > 0) OutData%C_obj%fy = c_loc(OutData%fy(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%fz, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%fz)) then
      OutData%C_obj%fz_Len = size(OutData%fz)
      if (OutData%C_obj%fz_Len > 0) OutData%C_obj%fz = c_loc(OutData%fz(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%momentx, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%momentx)) then
      OutData%C_obj%momentx_Len = size(OutData%momentx)
      if (OutData%C_obj%momentx_Len > 0) OutData%C_obj%momentx = c_loc(OutData%momentx(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%momenty, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%momenty)) then
      OutData%C_obj%momenty_Len = size(OutData%momenty)
      if (OutData%C_obj%momenty_Len > 0) OutData%C_obj%momenty = c_loc(OutData%momenty(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%momentz, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%momentz)) then
      OutData%C_obj%momentz_Len = size(OutData%momentz)
      if (OutData%C_obj%momentz_Len > 0) OutData%C_obj%momentz = c_loc(OutData%momentz(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%forceNodesChord, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%forceNodesChord)) then
      OutData%C_obj%forceNodesChord_Len = size(OutData%forceNodesChord)
      if (OutData%C_obj%forceNodesChord_Len > 0) OutData%C_obj%forceNodesChord = c_loc(OutData%forceNodesChord(LB(1)))
   end if
end subroutine

SUBROUTINE ExtInfw_C2Fary_CopyInput(InputData, ErrStat, ErrMsg, SkipPointers)
   TYPE(ExtInfw_InputType), INTENT(INOUT) :: InputData
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
   LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
   ! 
   LOGICAL                        :: SkipPointers_local
   ErrStat = ErrID_None
   ErrMsg  = ""
   
   IF (PRESENT(SkipPointers)) THEN
      SkipPointers_local = SkipPointers
   ELSE
      SkipPointers_local = .false.
   END IF
   
   ! -- pxVel Input Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( InputData%C_obj%pxVel ) ) THEN
         NULLIFY( InputData%pxVel )
      ELSE
         CALL C_F_POINTER(InputData%C_obj%pxVel, InputData%pxVel, [InputData%C_obj%pxVel_Len])
      END IF
   END IF
   
   ! -- pyVel Input Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( InputData%C_obj%pyVel ) ) THEN
         NULLIFY( InputData%pyVel )
      ELSE
         CALL C_F_POINTER(InputData%C_obj%pyVel, InputData%pyVel, [InputData%C_obj%pyVel_Len])
      END IF
   END IF
   
   ! -- pzVel Input Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( InputData%C_obj%pzVel ) ) THEN
         NULLIFY( InputData%pzVel )
      ELSE
         CALL C_F_POINTER(InputData%C_obj%pzVel, InputData%pzVel, [InputData%C_obj%pzVel_Len])
      END IF
   END IF
   
   ! -- pxForce Input Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( InputData%C_obj%pxForce ) ) THEN
         NULLIFY( InputData%pxForce )
      ELSE
         CALL C_F_POINTER(InputData%C_obj%pxForce, InputData%pxForce, [InputData%C_obj%pxForce_Len])
      END IF
   END IF
   
   ! -- pyForce Input Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( InputData%C_obj%pyForce ) ) THEN
         NULLIFY( InputData%pyForce )
      ELSE
         CALL C_F_POINTER(InputData%C_obj%pyForce, InputData%pyForce, [InputData%C_obj%pyForce_Len])
      END IF
   END IF
   
   ! -- pzForce Input Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( InputData%C_obj%pzForce ) ) THEN
         NULLIFY( InputData%pzForce )
      ELSE
         CALL C_F_POINTER(InputData%C_obj%pzForce, InputData%pzForce, [InputData%C_obj%pzForce_Len])
      END IF
   END IF
   
   ! -- xdotForce Input Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( InputData%C_obj%xdotForce ) ) THEN
         NULLIFY( InputData%xdotForce )
      ELSE
         CALL C_F_POINTER(InputData%C_obj%xdotForce, InputData%xdotForce, [InputData%C_obj%xdotForce_Len])
      END IF
   END IF
   
   ! -- ydotForce Input Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( InputData%C_obj%ydotForce ) ) THEN
         NULLIFY( InputData%ydotForce )
      ELSE
         CALL C_F_POINTER(InputData%C_obj%ydotForce, InputData%ydotForce, [InputData%C_obj%ydotForce_Len])
      END IF
   END IF
   
   ! -- zdotForce Input Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( InputData%C_obj%zdotForce ) ) THEN
         NULLIFY( InputData%zdotForce )
      ELSE
         CALL C_F_POINTER(InputData%C_obj%zdotForce, InputData%zdotForce, [InputData%C_obj%zdotForce_Len])
      END IF
   END IF
   
   ! -- pOrientation Input Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( InputData%C_obj%pOrientation ) ) THEN
         NULLIFY( InputData%pOrientation )
      ELSE
         CALL C_F_POINTER(InputData%C_obj%pOrientation, InputData%pOrientation, [InputData%C_obj%pOrientation_Len])
      END IF
   END IF
   
   ! -- fx Input Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( InputData%C_obj%fx ) ) THEN
         NULLIFY( InputData%fx )
      ELSE
         CALL C_F_POINTER(InputData%C_obj%fx, InputData%fx, [InputData%C_obj%fx_Len])
      END IF
   END IF
   
   ! -- fy Input Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( InputData%C_obj%fy ) ) THEN
         NULLIFY( InputData%fy )
      ELSE
         CALL C_F_POINTER(InputData%C_obj%fy, InputData%fy, [InputData%C_obj%fy_Len])
      END IF
   END IF
   
   ! -- fz Input Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( InputData%C_obj%fz ) ) THEN
         NULLIFY( InputData%fz )
      ELSE
         CALL C_F_POINTER(InputData%C_obj%fz, InputData%fz, [InputData%C_obj%fz_Len])
      END IF
   END IF
   
   ! -- momentx Input Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( InputData%C_obj%momentx ) ) THEN
         NULLIFY( InputData%momentx )
      ELSE
         CALL C_F_POINTER(InputData%C_obj%momentx, InputData%momentx, [InputData%C_obj%momentx_Len])
      END IF
   END IF
   
   ! -- momenty Input Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( InputData%C_obj%momenty ) ) THEN
         NULLIFY( InputData%momenty )
      ELSE
         CALL C_F_POINTER(InputData%C_obj%momenty, InputData%momenty, [InputData%C_obj%momenty_Len])
      END IF
   END IF
   
   ! -- momentz Input Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( InputData%C_obj%momentz ) ) THEN
         NULLIFY( InputData%momentz )
      ELSE
         CALL C_F_POINTER(InputData%C_obj%momentz, InputData%momentz, [InputData%C_obj%momentz_Len])
      END IF
   END IF
   
   ! -- forceNodesChord Input Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( InputData%C_obj%forceNodesChord ) ) THEN
         NULLIFY( InputData%forceNodesChord )
      ELSE
         CALL C_F_POINTER(InputData%C_obj%forceNodesChord, InputData%forceNodesChord, [InputData%C_obj%forceNodesChord_Len])
      END IF
   END IF
END SUBROUTINE

SUBROUTINE ExtInfw_F2C_CopyInput( InputData, ErrStat, ErrMsg, SkipPointers  )
   TYPE(ExtInfw_InputType), INTENT(INOUT) :: InputData
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
   LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
   ! 
   LOGICAL                        :: SkipPointers_local
   ErrStat = ErrID_None
   ErrMsg  = ''
   
   IF (PRESENT(SkipPointers)) THEN
      SkipPointers_local = SkipPointers
   ELSE
      SkipPointers_local = .false.
   END IF
   
   ! -- pxVel Input Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(InputData%pxVel)) THEN 
         InputData%C_obj%pxVel_Len = 0
         InputData%C_obj%pxVel = C_NULL_PTR
      ELSE
         InputData%C_obj%pxVel_Len = SIZE(InputData%pxVel)
         IF (InputData%C_obj%pxVel_Len > 0) &
            InputData%C_obj%pxVel = C_LOC(InputData%pxVel(lbound(InputData%pxVel,1)))
      END IF
   END IF
   
   ! -- pyVel Input Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(InputData%pyVel)) THEN 
         InputData%C_obj%pyVel_Len = 0
         InputData%C_obj%pyVel = C_NULL_PTR
      ELSE
         InputData%C_obj%pyVel_Len = SIZE(InputData%pyVel)
         IF (InputData%C_obj%pyVel_Len > 0) &
            InputData%C_obj%pyVel = C_LOC(InputData%pyVel(lbound(InputData%pyVel,1)))
      END IF
   END IF
   
   ! -- pzVel Input Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(InputData%pzVel)) THEN 
         InputData%C_obj%pzVel_Len = 0
         InputData%C_obj%pzVel = C_NULL_PTR
      ELSE
         InputData%C_obj%pzVel_Len = SIZE(InputData%pzVel)
         IF (InputData%C_obj%pzVel_Len > 0) &
            InputData%C_obj%pzVel = C_LOC(InputData%pzVel(lbound(InputData%pzVel,1)))
      END IF
   END IF
   
   ! -- pxForce Input Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(InputData%pxForce)) THEN 
         InputData%C_obj%pxForce_Len = 0
         InputData%C_obj%pxForce = C_NULL_PTR
      ELSE
         InputData%C_obj%pxForce_Len = SIZE(InputData%pxForce)
         IF (InputData%C_obj%pxForce_Len > 0) &
            InputData%C_obj%pxForce = C_LOC(InputData%pxForce(lbound(InputData%pxForce,1)))
      END IF
   END IF
   
   ! -- pyForce Input Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(InputData%pyForce)) THEN 
         InputData%C_obj%pyForce_Len = 0
         InputData%C_obj%pyForce = C_NULL_PTR
      ELSE
         InputData%C_obj%pyForce_Len = SIZE(InputData%pyForce)
         IF (InputData%C_obj%pyForce_Len > 0) &
            InputData%C_obj%pyForce = C_LOC(InputData%pyForce(lbound(InputData%pyForce,1)))
      END IF
   END IF
   
   ! -- pzForce Input Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(InputData%pzForce)) THEN 
         InputData%C_obj%pzForce_Len = 0
         InputData%C_obj%pzForce = C_NULL_PTR
      ELSE
         InputData%C_obj%pzForce_Len = SIZE(InputData%pzForce)
         IF (InputData%C_obj%pzForce_Len > 0) &
            InputData%C_obj%pzForce = C_LOC(InputData%pzForce(lbound(InputData%pzForce,1)))
      END IF
   END IF
   
   ! -- xdotForce Input Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(InputData%xdotForce)) THEN 
         InputData%C_obj%xdotForce_Len = 0
         InputData%C_obj%xdotForce = C_NULL_PTR
      ELSE
         InputData%C_obj%xdotForce_Len = SIZE(InputData%xdotForce)
         IF (InputData%C_obj%xdotForce_Len > 0) &
            InputData%C_obj%xdotForce = C_LOC(InputData%xdotForce(lbound(InputData%xdotForce,1)))
      END IF
   END IF
   
   ! -- ydotForce Input Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(InputData%ydotForce)) THEN 
         InputData%C_obj%ydotForce_Len = 0
         InputData%C_obj%ydotForce = C_NULL_PTR
      ELSE
         InputData%C_obj%ydotForce_Len = SIZE(InputData%ydotForce)
         IF (InputData%C_obj%ydotForce_Len > 0) &
            InputData%C_obj%ydotForce = C_LOC(InputData%ydotForce(lbound(InputData%ydotForce,1)))
      END IF
   END IF
   
   ! -- zdotForce Input Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(InputData%zdotForce)) THEN 
         InputData%C_obj%zdotForce_Len = 0
         InputData%C_obj%zdotForce = C_NULL_PTR
      ELSE
         InputData%C_obj%zdotForce_Len = SIZE(InputData%zdotForce)
         IF (InputData%C_obj%zdotForce_Len > 0) &
            InputData%C_obj%zdotForce = C_LOC(InputData%zdotForce(lbound(InputData%zdotForce,1)))
      END IF
   END IF
   
   ! -- pOrientation Input Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(InputData%pOrientation)) THEN 
         InputData%C_obj%pOrientation_Len = 0
         InputData%C_obj%pOrientation = C_NULL_PTR
      ELSE
         InputData%C_obj%pOrientation_Len = SIZE(InputData%pOrientation)
         IF (InputData%C_obj%pOrientation_Len > 0) &
            InputData%C_obj%pOrientation = C_LOC(InputData%pOrientation(lbound(InputData%pOrientation,1)))
      END IF
   END IF
   
   ! -- fx Input Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(InputData%fx)) THEN 
         InputData%C_obj%fx_Len = 0
         InputData%C_obj%fx = C_NULL_PTR
      ELSE
         InputData%C_obj%fx_Len = SIZE(InputData%fx)
         IF (InputData%C_obj%fx_Len > 0) &
            InputData%C_obj%fx = C_LOC(InputData%fx(lbound(InputData%fx,1)))
      END IF
   END IF
   
   ! -- fy Input Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(InputData%fy)) THEN 
         InputData%C_obj%fy_Len = 0
         InputData%C_obj%fy = C_NULL_PTR
      ELSE
         InputData%C_obj%fy_Len = SIZE(InputData%fy)
         IF (InputData%C_obj%fy_Len > 0) &
            InputData%C_obj%fy = C_LOC(InputData%fy(lbound(InputData%fy,1)))
      END IF
   END IF
   
   ! -- fz Input Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(InputData%fz)) THEN 
         InputData%C_obj%fz_Len = 0
         InputData%C_obj%fz = C_NULL_PTR
      ELSE
         InputData%C_obj%fz_Len = SIZE(InputData%fz)
         IF (InputData%C_obj%fz_Len > 0) &
            InputData%C_obj%fz = C_LOC(InputData%fz(lbound(InputData%fz,1)))
      END IF
   END IF
   
   ! -- momentx Input Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(InputData%momentx)) THEN 
         InputData%C_obj%momentx_Len = 0
         InputData%C_obj%momentx = C_NULL_PTR
      ELSE
         InputData%C_obj%momentx_Len = SIZE(InputData%momentx)
         IF (InputData%C_obj%momentx_Len > 0) &
            InputData%C_obj%momentx = C_LOC(InputData%momentx(lbound(InputData%momentx,1)))
      END IF
   END IF
   
   ! -- momenty Input Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(InputData%momenty)) THEN 
         InputData%C_obj%momenty_Len = 0
         InputData%C_obj%momenty = C_NULL_PTR
      ELSE
         InputData%C_obj%momenty_Len = SIZE(InputData%momenty)
         IF (InputData%C_obj%momenty_Len > 0) &
            InputData%C_obj%momenty = C_LOC(InputData%momenty(lbound(InputData%momenty,1)))
      END IF
   END IF
   
   ! -- momentz Input Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(InputData%momentz)) THEN 
         InputData%C_obj%momentz_Len = 0
         InputData%C_obj%momentz = C_NULL_PTR
      ELSE
         InputData%C_obj%momentz_Len = SIZE(InputData%momentz)
         IF (InputData%C_obj%momentz_Len > 0) &
            InputData%C_obj%momentz = C_LOC(InputData%momentz(lbound(InputData%momentz,1)))
      END IF
   END IF
   
   ! -- forceNodesChord Input Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(InputData%forceNodesChord)) THEN 
         InputData%C_obj%forceNodesChord_Len = 0
         InputData%C_obj%forceNodesChord = C_NULL_PTR
      ELSE
         InputData%C_obj%forceNodesChord_Len = SIZE(InputData%forceNodesChord)
         IF (InputData%C_obj%forceNodesChord_Len > 0) &
            InputData%C_obj%forceNodesChord = C_LOC(InputData%forceNodesChord(lbound(InputData%forceNodesChord,1)))
      END IF
   END IF
END SUBROUTINE

subroutine ExtInfw_CopyOutput(SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg)
   type(ExtInfw_OutputType), intent(in) :: SrcOutputData
   type(ExtInfw_OutputType), intent(inout) :: DstOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'ExtInfw_CopyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (associated(SrcOutputData%u)) then
      LB(1:1) = lbound(SrcOutputData%u)
      UB(1:1) = ubound(SrcOutputData%u)
      if (.not. associated(DstOutputData%u)) then
         allocate(DstOutputData%u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstOutputData%C_obj%u_Len = size(DstOutputData%u)
         if (DstOutputData%C_obj%u_Len > 0) &
            DstOutputData%C_obj%u = c_loc(DstOutputData%u(LB(1)))
      end if
      DstOutputData%u = SrcOutputData%u
   end if
   if (associated(SrcOutputData%v)) then
      LB(1:1) = lbound(SrcOutputData%v)
      UB(1:1) = ubound(SrcOutputData%v)
      if (.not. associated(DstOutputData%v)) then
         allocate(DstOutputData%v(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%v.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstOutputData%C_obj%v_Len = size(DstOutputData%v)
         if (DstOutputData%C_obj%v_Len > 0) &
            DstOutputData%C_obj%v = c_loc(DstOutputData%v(LB(1)))
      end if
      DstOutputData%v = SrcOutputData%v
   end if
   if (associated(SrcOutputData%w)) then
      LB(1:1) = lbound(SrcOutputData%w)
      UB(1:1) = ubound(SrcOutputData%w)
      if (.not. associated(DstOutputData%w)) then
         allocate(DstOutputData%w(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%w.', ErrStat, ErrMsg, RoutineName)
            return
         end if
         DstOutputData%C_obj%w_Len = size(DstOutputData%w)
         if (DstOutputData%C_obj%w_Len > 0) &
            DstOutputData%C_obj%w = c_loc(DstOutputData%w(LB(1)))
      end if
      DstOutputData%w = SrcOutputData%w
   end if
   if (allocated(SrcOutputData%WriteOutput)) then
      LB(1:1) = lbound(SrcOutputData%WriteOutput)
      UB(1:1) = ubound(SrcOutputData%WriteOutput)
      if (.not. allocated(DstOutputData%WriteOutput)) then
         allocate(DstOutputData%WriteOutput(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%WriteOutput.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%WriteOutput = SrcOutputData%WriteOutput
   end if
end subroutine

subroutine ExtInfw_DestroyOutput(OutputData, ErrStat, ErrMsg)
   type(ExtInfw_OutputType), intent(inout) :: OutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ExtInfw_DestroyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (associated(OutputData%u)) then
      deallocate(OutputData%u)
      OutputData%u => null()
      OutputData%C_obj%u = c_null_ptr
      OutputData%C_obj%u_Len = 0
   end if
   if (associated(OutputData%v)) then
      deallocate(OutputData%v)
      OutputData%v => null()
      OutputData%C_obj%v = c_null_ptr
      OutputData%C_obj%v_Len = 0
   end if
   if (associated(OutputData%w)) then
      deallocate(OutputData%w)
      OutputData%w => null()
      OutputData%C_obj%w = c_null_ptr
      OutputData%C_obj%w_Len = 0
   end if
   if (allocated(OutputData%WriteOutput)) then
      deallocate(OutputData%WriteOutput)
   end if
end subroutine

subroutine ExtInfw_PackOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ExtInfw_OutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ExtInfw_PackOutput'
   logical         :: PtrInIndex
   if (RF%ErrStat >= AbortErrLev) return
   if (c_associated(InData%C_obj%object)) then
      RF%ErrStat = ErrID_Fatal
      RF%ErrMsg = RoutineName//': C_obj%object cannot be packed.'
      return
   end if
   call RegPackPtr(RF, InData%u)
   call RegPackPtr(RF, InData%v)
   call RegPackPtr(RF, InData%w)
   call RegPackAlloc(RF, InData%WriteOutput)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ExtInfw_UnPackOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ExtInfw_OutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ExtInfw_UnPackOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   integer(B8Ki)   :: PtrIdx
   type(c_ptr)     :: Ptr
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackPtr(RF, OutData%u, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%u)) then
      OutData%C_obj%u_Len = size(OutData%u)
      if (OutData%C_obj%u_Len > 0) OutData%C_obj%u = c_loc(OutData%u(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%v, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%v)) then
      OutData%C_obj%v_Len = size(OutData%v)
      if (OutData%C_obj%v_Len > 0) OutData%C_obj%v = c_loc(OutData%v(LB(1)))
   end if
   call RegUnpackPtr(RF, OutData%w, LB, UB); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%w)) then
      OutData%C_obj%w_Len = size(OutData%w)
      if (OutData%C_obj%w_Len > 0) OutData%C_obj%w = c_loc(OutData%w(LB(1)))
   end if
   call RegUnpackAlloc(RF, OutData%WriteOutput); if (RegCheckErr(RF, RoutineName)) return
end subroutine

SUBROUTINE ExtInfw_C2Fary_CopyOutput(OutputData, ErrStat, ErrMsg, SkipPointers)
   TYPE(ExtInfw_OutputType), INTENT(INOUT) :: OutputData
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
   LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
   ! 
   LOGICAL                        :: SkipPointers_local
   ErrStat = ErrID_None
   ErrMsg  = ""
   
   IF (PRESENT(SkipPointers)) THEN
      SkipPointers_local = SkipPointers
   ELSE
      SkipPointers_local = .false.
   END IF
   
   ! -- u Output Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( OutputData%C_obj%u ) ) THEN
         NULLIFY( OutputData%u )
      ELSE
         CALL C_F_POINTER(OutputData%C_obj%u, OutputData%u, [OutputData%C_obj%u_Len])
      END IF
   END IF
   
   ! -- v Output Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( OutputData%C_obj%v ) ) THEN
         NULLIFY( OutputData%v )
      ELSE
         CALL C_F_POINTER(OutputData%C_obj%v, OutputData%v, [OutputData%C_obj%v_Len])
      END IF
   END IF
   
   ! -- w Output Data fields
   IF ( .NOT. SkipPointers_local ) THEN
      IF ( .NOT. C_ASSOCIATED( OutputData%C_obj%w ) ) THEN
         NULLIFY( OutputData%w )
      ELSE
         CALL C_F_POINTER(OutputData%C_obj%w, OutputData%w, [OutputData%C_obj%w_Len])
      END IF
   END IF
END SUBROUTINE

SUBROUTINE ExtInfw_F2C_CopyOutput( OutputData, ErrStat, ErrMsg, SkipPointers  )
   TYPE(ExtInfw_OutputType), INTENT(INOUT) :: OutputData
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
   LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
   ! 
   LOGICAL                        :: SkipPointers_local
   ErrStat = ErrID_None
   ErrMsg  = ''
   
   IF (PRESENT(SkipPointers)) THEN
      SkipPointers_local = SkipPointers
   ELSE
      SkipPointers_local = .false.
   END IF
   
   ! -- u Output Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(OutputData%u)) THEN 
         OutputData%C_obj%u_Len = 0
         OutputData%C_obj%u = C_NULL_PTR
      ELSE
         OutputData%C_obj%u_Len = SIZE(OutputData%u)
         IF (OutputData%C_obj%u_Len > 0) &
            OutputData%C_obj%u = C_LOC(OutputData%u(lbound(OutputData%u,1)))
      END IF
   END IF
   
   ! -- v Output Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(OutputData%v)) THEN 
         OutputData%C_obj%v_Len = 0
         OutputData%C_obj%v = C_NULL_PTR
      ELSE
         OutputData%C_obj%v_Len = SIZE(OutputData%v)
         IF (OutputData%C_obj%v_Len > 0) &
            OutputData%C_obj%v = C_LOC(OutputData%v(lbound(OutputData%v,1)))
      END IF
   END IF
   
   ! -- w Output Data fields
   IF (.NOT. SkipPointers_local ) THEN
      IF (.NOT. ASSOCIATED(OutputData%w)) THEN 
         OutputData%C_obj%w_Len = 0
         OutputData%C_obj%w = C_NULL_PTR
      ELSE
         OutputData%C_obj%w_Len = SIZE(OutputData%w)
         IF (OutputData%C_obj%w_Len > 0) &
            OutputData%C_obj%w = C_LOC(OutputData%w(lbound(OutputData%w,1)))
      END IF
   END IF
END SUBROUTINE

subroutine ExtInfw_Input_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
   ! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(ExtInfw_InputType), intent(in)  :: u(:) ! Input at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Inputs
   type(ExtInfw_InputType), intent(inout)  :: u_out ! Input at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'ExtInfw_Input_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(u)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(u)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(u) - 1
   select case (order)
   case (0)
      call ExtInfw_CopyInput(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call ExtInfw_Input_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call ExtInfw_Input_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(u) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE ExtInfw_Input_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

   TYPE(ExtInfw_InputType), INTENT(IN)  :: u1    ! Input at t1 > t2
   TYPE(ExtInfw_InputType), INTENT(IN)  :: u2    ! Input at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Inputs
   TYPE(ExtInfw_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'ExtInfw_Input_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   IF (ASSOCIATED(u_out%pxVel) .AND. ASSOCIATED(u1%pxVel)) THEN
      u_out%pxVel = a1*u1%pxVel + a2*u2%pxVel
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%pyVel) .AND. ASSOCIATED(u1%pyVel)) THEN
      u_out%pyVel = a1*u1%pyVel + a2*u2%pyVel
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%pzVel) .AND. ASSOCIATED(u1%pzVel)) THEN
      u_out%pzVel = a1*u1%pzVel + a2*u2%pzVel
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%pxForce) .AND. ASSOCIATED(u1%pxForce)) THEN
      u_out%pxForce = a1*u1%pxForce + a2*u2%pxForce
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%pyForce) .AND. ASSOCIATED(u1%pyForce)) THEN
      u_out%pyForce = a1*u1%pyForce + a2*u2%pyForce
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%pzForce) .AND. ASSOCIATED(u1%pzForce)) THEN
      u_out%pzForce = a1*u1%pzForce + a2*u2%pzForce
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%xdotForce) .AND. ASSOCIATED(u1%xdotForce)) THEN
      u_out%xdotForce = a1*u1%xdotForce + a2*u2%xdotForce
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%ydotForce) .AND. ASSOCIATED(u1%ydotForce)) THEN
      u_out%ydotForce = a1*u1%ydotForce + a2*u2%ydotForce
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%zdotForce) .AND. ASSOCIATED(u1%zdotForce)) THEN
      u_out%zdotForce = a1*u1%zdotForce + a2*u2%zdotForce
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%pOrientation) .AND. ASSOCIATED(u1%pOrientation)) THEN
      u_out%pOrientation = a1*u1%pOrientation + a2*u2%pOrientation
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%fx) .AND. ASSOCIATED(u1%fx)) THEN
      u_out%fx = a1*u1%fx + a2*u2%fx
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%fy) .AND. ASSOCIATED(u1%fy)) THEN
      u_out%fy = a1*u1%fy + a2*u2%fy
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%fz) .AND. ASSOCIATED(u1%fz)) THEN
      u_out%fz = a1*u1%fz + a2*u2%fz
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%momentx) .AND. ASSOCIATED(u1%momentx)) THEN
      u_out%momentx = a1*u1%momentx + a2*u2%momentx
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%momenty) .AND. ASSOCIATED(u1%momenty)) THEN
      u_out%momenty = a1*u1%momenty + a2*u2%momenty
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%momentz) .AND. ASSOCIATED(u1%momentz)) THEN
      u_out%momentz = a1*u1%momentz + a2*u2%momentz
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%forceNodesChord) .AND. ASSOCIATED(u1%forceNodesChord)) THEN
      u_out%forceNodesChord = a1*u1%forceNodesChord + a2*u2%forceNodesChord
   END IF ! check if allocated
END SUBROUTINE

SUBROUTINE ExtInfw_Input_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

   TYPE(ExtInfw_InputType), INTENT(IN)  :: u1      ! Input at t1 > t2 > t3
   TYPE(ExtInfw_InputType), INTENT(IN)  :: u2      ! Input at t2 > t3
   TYPE(ExtInfw_InputType), INTENT(IN)  :: u3      ! Input at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Inputs
   TYPE(ExtInfw_InputType), INTENT(INOUT)  :: u_out     ! Input at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'ExtInfw_Input_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   IF (ASSOCIATED(u_out%pxVel) .AND. ASSOCIATED(u1%pxVel)) THEN
      u_out%pxVel = a1*u1%pxVel + a2*u2%pxVel + a3*u3%pxVel
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%pyVel) .AND. ASSOCIATED(u1%pyVel)) THEN
      u_out%pyVel = a1*u1%pyVel + a2*u2%pyVel + a3*u3%pyVel
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%pzVel) .AND. ASSOCIATED(u1%pzVel)) THEN
      u_out%pzVel = a1*u1%pzVel + a2*u2%pzVel + a3*u3%pzVel
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%pxForce) .AND. ASSOCIATED(u1%pxForce)) THEN
      u_out%pxForce = a1*u1%pxForce + a2*u2%pxForce + a3*u3%pxForce
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%pyForce) .AND. ASSOCIATED(u1%pyForce)) THEN
      u_out%pyForce = a1*u1%pyForce + a2*u2%pyForce + a3*u3%pyForce
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%pzForce) .AND. ASSOCIATED(u1%pzForce)) THEN
      u_out%pzForce = a1*u1%pzForce + a2*u2%pzForce + a3*u3%pzForce
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%xdotForce) .AND. ASSOCIATED(u1%xdotForce)) THEN
      u_out%xdotForce = a1*u1%xdotForce + a2*u2%xdotForce + a3*u3%xdotForce
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%ydotForce) .AND. ASSOCIATED(u1%ydotForce)) THEN
      u_out%ydotForce = a1*u1%ydotForce + a2*u2%ydotForce + a3*u3%ydotForce
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%zdotForce) .AND. ASSOCIATED(u1%zdotForce)) THEN
      u_out%zdotForce = a1*u1%zdotForce + a2*u2%zdotForce + a3*u3%zdotForce
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%pOrientation) .AND. ASSOCIATED(u1%pOrientation)) THEN
      u_out%pOrientation = a1*u1%pOrientation + a2*u2%pOrientation + a3*u3%pOrientation
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%fx) .AND. ASSOCIATED(u1%fx)) THEN
      u_out%fx = a1*u1%fx + a2*u2%fx + a3*u3%fx
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%fy) .AND. ASSOCIATED(u1%fy)) THEN
      u_out%fy = a1*u1%fy + a2*u2%fy + a3*u3%fy
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%fz) .AND. ASSOCIATED(u1%fz)) THEN
      u_out%fz = a1*u1%fz + a2*u2%fz + a3*u3%fz
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%momentx) .AND. ASSOCIATED(u1%momentx)) THEN
      u_out%momentx = a1*u1%momentx + a2*u2%momentx + a3*u3%momentx
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%momenty) .AND. ASSOCIATED(u1%momenty)) THEN
      u_out%momenty = a1*u1%momenty + a2*u2%momenty + a3*u3%momenty
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%momentz) .AND. ASSOCIATED(u1%momentz)) THEN
      u_out%momentz = a1*u1%momentz + a2*u2%momentz + a3*u3%momentz
   END IF ! check if allocated
   IF (ASSOCIATED(u_out%forceNodesChord) .AND. ASSOCIATED(u1%forceNodesChord)) THEN
      u_out%forceNodesChord = a1*u1%forceNodesChord + a2*u2%forceNodesChord + a3*u3%forceNodesChord
   END IF ! check if allocated
END SUBROUTINE

subroutine ExtInfw_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
   ! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(ExtInfw_OutputType), intent(in)  :: y(:) ! Output at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Outputs
   type(ExtInfw_OutputType), intent(inout)  :: y_out ! Output at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'ExtInfw_Output_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(y)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(y)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(y) - 1
   select case (order)
   case (0)
      call ExtInfw_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call ExtInfw_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call ExtInfw_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(y) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE ExtInfw_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

   TYPE(ExtInfw_OutputType), INTENT(IN)  :: y1    ! Output at t1 > t2
   TYPE(ExtInfw_OutputType), INTENT(IN)  :: y2    ! Output at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
   TYPE(ExtInfw_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'ExtInfw_Output_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   IF (ASSOCIATED(y_out%u) .AND. ASSOCIATED(y1%u)) THEN
      y_out%u = a1*y1%u + a2*y2%u
   END IF ! check if allocated
   IF (ASSOCIATED(y_out%v) .AND. ASSOCIATED(y1%v)) THEN
      y_out%v = a1*y1%v + a2*y2%v
   END IF ! check if allocated
   IF (ASSOCIATED(y_out%w) .AND. ASSOCIATED(y1%w)) THEN
      y_out%w = a1*y1%w + a2*y2%w
   END IF ! check if allocated
   IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
      y_out%WriteOutput = a1*y1%WriteOutput + a2*y2%WriteOutput
   END IF ! check if allocated
END SUBROUTINE

SUBROUTINE ExtInfw_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

   TYPE(ExtInfw_OutputType), INTENT(IN)  :: y1      ! Output at t1 > t2 > t3
   TYPE(ExtInfw_OutputType), INTENT(IN)  :: y2      ! Output at t2 > t3
   TYPE(ExtInfw_OutputType), INTENT(IN)  :: y3      ! Output at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
   TYPE(ExtInfw_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'ExtInfw_Output_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   IF (ASSOCIATED(y_out%u) .AND. ASSOCIATED(y1%u)) THEN
      y_out%u = a1*y1%u + a2*y2%u + a3*y3%u
   END IF ! check if allocated
   IF (ASSOCIATED(y_out%v) .AND. ASSOCIATED(y1%v)) THEN
      y_out%v = a1*y1%v + a2*y2%v + a3*y3%v
   END IF ! check if allocated
   IF (ASSOCIATED(y_out%w) .AND. ASSOCIATED(y1%w)) THEN
      y_out%w = a1*y1%w + a2*y2%w + a3*y3%w
   END IF ! check if allocated
   IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
      y_out%WriteOutput = a1*y1%WriteOutput + a2*y2%WriteOutput + a3*y3%WriteOutput
   END IF ! check if allocated
END SUBROUTINE
END MODULE ExternalInflow_Types
!ENDOFREGISTRYGENERATEDFILE
