!STARTOFREGISTRYGENERATEDFILE 'ElastoDyn_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! ElastoDyn_Types
!.................................................................................................................................
! This file is part of ElastoDyn.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in ElastoDyn. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE ElastoDyn_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE NWTC_Library
IMPLICIT NONE
    INTEGER(IntKi), PUBLIC, PARAMETER  :: ED_NMX = 4      ! Used in updating predictor-corrector values (size of state history) [-]
! =========  ED_InitInputType  =======
  TYPE, PUBLIC :: ED_InitInputType
    CHARACTER(1024)  :: InputFile      !< Name of the input file [-]
    LOGICAL  :: Linearize = .FALSE.      !< Flag that tells this module if the glue code wants to linearize. [-]
    LOGICAL  :: CompElast = .false.      !< flag to determine if ElastoDyn is computing blade loads (true) or BeamDyn is (false) [-]
    LOGICAL  :: RigidAero = .false.      !< flag to determine if ElastoDyn if blades are rigid for aero -- when AeroDisk is used [-]
    CHARACTER(1024)  :: RootName      !< RootName for writing output files [-]
    REAL(ReKi)  :: Gravity = 0.0_ReKi      !< Gravitational acceleration [m/s^2]
    INTEGER(IntKi)  :: MHK = 0_IntKi      !< MHK turbine type switch [-]
    REAL(ReKi)  :: WtrDpth = 0.0_ReKi      !< Water depth [m]
    LOGICAL  :: CompAeroMaps = .FALSE.      !< flag to determine if ElastoDyn is computing aero maps (true) or running a normal simulation (false) [-]
    REAL(ReKi)  :: RotSpeed = 0.0_ReKi      !< Rotor speed used when ElastoDyn is computing aero maps [rad/s]
  END TYPE ED_InitInputType
! =======================
! =========  ED_InitOutputType  =======
  TYPE, PUBLIC :: ED_InitOutputType
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputHdr      !< Names of the output-to-file channels [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputUnt      !< Units of the output-to-file channels [-]
    TYPE(ProgDesc)  :: Ver      !< This module's name, version, and date [-]
    INTEGER(IntKi)  :: NumBl = 0_IntKi      !< Number of blades on the turbine [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BlPitch      !< Initial blade pitch angles [radians]
    REAL(ReKi)  :: BladeLength = 0.0_ReKi      !< Blade length (for AeroDyn) [meters]
    REAL(ReKi)  :: TowerFlexL = 0.0_ReKi      !< Tower Flexible Length [meters]
    REAL(ReKi)  :: TowerBaseHeight = 0.0_ReKi      !< Tower Base Height [meters]
    REAL(ReKi)  :: HubHt = 0.0_ReKi      !< Height of the hub [meters]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BldRNodes      !< Radius to analysis nodes relative to hub ( 0 < RNodes(:) < BldFlexL ) [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TwrHNodes      !< Location of variable-spaced tower nodes (relative to the tower rigid base height [-]
    REAL(ReKi) , DIMENSION(1:6)  :: PlatformPos = 0.0_ReKi      !< Initial platform position (6 DOFs) [-]
    REAL(ReKi) , DIMENSION(1:3)  :: TwrBaseRefPos = 0.0_ReKi      !< initial position of the tower base (for SrvD) [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: TwrBaseTransDisp = 0.0_R8Ki      !< initial displacement of the tower base (for SrvD) [m]
    REAL(R8Ki) , DIMENSION(1:3,1:3)  :: TwrBaseRefOrient = 0.0_R8Ki      !< reference orientation of the tower base (for SrvD) [-]
    REAL(R8Ki) , DIMENSION(1:3,1:3)  :: TwrBaseOrient = 0.0_R8Ki      !< initial orientation of the tower base (for SrvD) [-]
    REAL(ReKi)  :: HubRad = 0.0_ReKi      !< Preconed hub radius (distance from the rotor apex to the blade root) [m]
    REAL(ReKi)  :: RotSpeed = 0.0_ReKi      !< Initial or fixed rotor speed [rad/s]
    LOGICAL  :: isFixed_GenDOF = .false.      !< whether the generator is fixed or free [-]
    CHARACTER(LinChanLen) , DIMENSION(:), ALLOCATABLE  :: LinNames_y      !< Names of the outputs used in linearization [-]
    CHARACTER(LinChanLen) , DIMENSION(:), ALLOCATABLE  :: LinNames_x      !< Names of the continuous states used in linearization [-]
    CHARACTER(LinChanLen) , DIMENSION(:), ALLOCATABLE  :: LinNames_u      !< Names of the inputs used in linearization [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: RotFrame_y      !< Flag that tells FAST/MBC3 if the outputs used in linearization are in the rotating frame [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: RotFrame_x      !< Flag that tells FAST/MBC3 if the continuous states used in linearization are in the rotating frame [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: DerivOrder_x      !< Integer that tells FAST/MBC3 the maximum derivative order of continuous states used in linearization [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: RotFrame_u      !< Flag that tells FAST/MBC3 if the inputs used in linearization are in the rotating frame [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: IsLoad_u      !< Flag that tells FAST if the inputs used in linearization are loads (for preconditioning matrix) [-]
    INTEGER(IntKi)  :: GearBox_index = 0_IntKi      !< Index to gearbox rotation in state array (for steady-state calculations) [-]
  END TYPE ED_InitOutputType
! =======================
! =========  BladeInputData  =======
  TYPE, PUBLIC :: BladeInputData
    INTEGER(IntKi)  :: NBlInpSt = 0_IntKi      !< Number of blade input stations [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BlFract      !< Blade fractional radius for distributed input data [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: PitchAx      !< Pitch axis for distributed input data [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: StrcTwst      !< Structural twist for distributed input data [radians]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BMassDen      !< Blade mass density for distributed input data [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: FlpStff      !< Blade flap stiffness for distributed input data [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: EdgStff      !< Blade edge stiffness for distributed input data [-]
    REAL(ReKi) , DIMENSION(1:2)  :: BldFlDmp = 0.0_ReKi      !< Blade structural damping ratios in flapwise direction [-]
    REAL(ReKi) , DIMENSION(1:1)  :: BldEdDmp = 0.0_ReKi      !< Blade structural damping ratios in edgewise direction [-]
    REAL(ReKi) , DIMENSION(1:2)  :: FlStTunr = 0.0_ReKi      !< Blade flapwise modal stiffness tuners (input) [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BldFl1Sh      !< Blade-flap-mode-1 shape coefficients [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BldFl2Sh      !< Blade-flap-mode-2 shape coefficients [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BldEdgSh      !< Blade-edge-mode shape coefficients [-]
  END TYPE BladeInputData
! =======================
! =========  ED_BladeMeshInputData  =======
  TYPE, PUBLIC :: ED_BladeMeshInputData
    INTEGER(IntKi)  :: BldNodes = 0_IntKi      !< Number of blade nodes used for analysis [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: RNodes      !< Radius to analysis nodes relative to hub ( 0 < RNodes(:) < BldFlexL ) [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: AeroTwst      !< Aerodynamic twist of the blade at the analysis nodes [radians]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Chord      !< Chord of the blade at the analysis nodes [-]
  END TYPE ED_BladeMeshInputData
! =======================
! =========  ED_InputFile  =======
  TYPE, PUBLIC :: ED_InputFile
    REAL(DbKi)  :: DT = 0.0_R8Ki      !< Requested integration time for ElastoDyn [seconds]
    LOGICAL  :: FlapDOF1 = .false.      !< First flapwise blade mode DOF [-]
    LOGICAL  :: FlapDOF2 = .false.      !< Second flapwise blade mode DOF [-]
    LOGICAL  :: EdgeDOF = .false.      !< Edgewise blade mode DOF [-]
    LOGICAL  :: TeetDOF = .false.      !< Rotor-teeter DOF [-]
    LOGICAL  :: DrTrDOF = .false.      !< Drivetrain rotational-flexibility DOF [-]
    LOGICAL  :: GenDOF = .false.      !< Generator DOF [-]
    LOGICAL  :: YawDOF = .false.      !< Nacelle-yaw DOF [-]
    LOGICAL  :: TwFADOF1 = .false.      !< First tower fore-aft bending-mode DOF [-]
    LOGICAL  :: TwFADOF2 = .false.      !< Second tower fore-aft bending-mode DOF [-]
    LOGICAL  :: TwSSDOF1 = .false.      !< First tower side-to-side bending-mode DOF [-]
    LOGICAL  :: TwSSDOF2 = .false.      !< Second tower side-to-side bending-mode DOF [-]
    LOGICAL  :: PtfmSgDOF = .false.      !< Platform horizontal surge translation DOF [-]
    LOGICAL  :: PtfmSwDOF = .false.      !< Platform horizontal sway translation DOF [-]
    LOGICAL  :: PtfmHvDOF = .false.      !< Platform vertical heave translation DOF [-]
    LOGICAL  :: PtfmRDOF = .false.      !< Platform roll tilt rotation DOF [-]
    LOGICAL  :: PtfmPDOF = .false.      !< Platform pitch tilt rotation DOF [-]
    LOGICAL  :: PtfmYDOF = .false.      !< Platform yaw rotation DOF [-]
    REAL(ReKi)  :: OoPDefl = 0.0_ReKi      !< Initial out-of-plane blade-tip displacement [meters]
    REAL(ReKi)  :: IPDefl = 0.0_ReKi      !< Initial in-plane blade-tip deflection [meters]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BlPitch      !< Initial blade pitch angles [radians]
    REAL(ReKi)  :: TeetDefl = 0.0_ReKi      !< Initial teeter angle [radians]
    REAL(R8Ki)  :: Azimuth = 0.0_R8Ki      !< Initial azimuth angle for blade 1 [radians]
    REAL(ReKi)  :: RotSpeed = 0.0_ReKi      !< Initial rotor speed [rad/s]
    REAL(ReKi)  :: NacYaw = 0.0_ReKi      !< Initial nacelle-yaw angle [radians]
    REAL(ReKi)  :: TTDspFA = 0.0_ReKi      !< Initial fore-aft tower-top displacement [meters]
    REAL(ReKi)  :: TTDspSS = 0.0_ReKi      !< Initial side-to-side tower-top displacement [meters]
    REAL(ReKi)  :: PtfmSurge = 0.0_ReKi      !< Initial horizontal surge translational displacement of platform [meters]
    REAL(ReKi)  :: PtfmSway = 0.0_ReKi      !< Initial horizontal sway translational displacement of platform [meters]
    REAL(ReKi)  :: PtfmHeave = 0.0_ReKi      !< Initial vertical heave translational displacement of platform [meters]
    REAL(ReKi)  :: PtfmRoll = 0.0_ReKi      !< Initial roll tilt rotational displacement of platform [radians]
    REAL(ReKi)  :: PtfmPitch = 0.0_ReKi      !< Initial pitch tilt rotational displacement of platform [radians]
    REAL(ReKi)  :: PtfmYaw = 0.0_ReKi      !< Initial yaw rotational displacement of platform [radians]
    INTEGER(IntKi)  :: NumBl = 0_IntKi      !< Number of blades [-]
    REAL(ReKi)  :: TipRad = 0.0_ReKi      !< Preconed blade-tip radius (distance from the rotor apex to the blade tip) [meters]
    REAL(ReKi)  :: HubRad = 0.0_ReKi      !< Preconed hub radius (distance from the rotor apex to the blade root) [meters]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: PreCone      !< Rotor precone angles [radians]
    REAL(ReKi)  :: HubCM = 0.0_ReKi      !< Distance from rotor apex to hub mass [meters]
    REAL(ReKi)  :: UndSling = 0.0_ReKi      !< Undersling length [meters]
    REAL(ReKi)  :: Delta3 = 0.0_ReKi      !< Delta-3 angle for teetering rotors [radians]
    REAL(R8Ki)  :: AzimB1Up = 0.0_R8Ki      !< Azimuth value to use for I/O when blade 1 points up [radians]
    REAL(ReKi)  :: OverHang = 0.0_ReKi      !< Distance from yaw axis to rotor apex or teeter pin [meters]
    REAL(ReKi)  :: ShftGagL = 0.0_ReKi      !< Distance from hub or teeter pin to shaft strain gages [meters]
    REAL(ReKi)  :: ShftTilt = 0.0_ReKi      !< Rotor shaft tilt angle [radians]
    REAL(ReKi)  :: NacCMxn = 0.0_ReKi      !< Downwind distance from tower-top to nacelle CM [meters]
    REAL(ReKi)  :: NacCMyn = 0.0_ReKi      !< Lateral distance from tower-top to nacelle CM [meters]
    REAL(ReKi)  :: NacCMzn = 0.0_ReKi      !< Vertical distance from tower-top to nacelle CM [meters]
    REAL(ReKi)  :: NcIMUxn = 0.0_ReKi      !< Downwind distance from the tower-top to the nacelle IMU [meters]
    REAL(ReKi)  :: NcIMUyn = 0.0_ReKi      !< Lateral distance from the tower-top to the nacelle IMU [meters]
    REAL(ReKi)  :: NcIMUzn = 0.0_ReKi      !< Vertical distance from the tower-top to the nacelle IMU [meters]
    REAL(ReKi)  :: Twr2Shft = 0.0_ReKi      !< Vertical distance from the tower-top to the rotor shaft [meters]
    REAL(ReKi)  :: TowerHt = 0.0_ReKi      !< Height of tower relative to ground level [onshore], MSL [offshore wind or floating MHK], or seabed [fixed MHK] [meters]
    REAL(ReKi)  :: TowerBsHt = 0.0_ReKi      !< Height of tower base relative to ground level [onshore], MSL [offshore wind or floating MHK], or seabed [fixed MHK] [meters]
    REAL(ReKi)  :: PtfmCMxt = 0.0_ReKi      !< Downwind distance from the ground level [onshore], MSL [offshore wind or floating MHK], or seabed [fixed MHK] to the platform CM [meters]
    REAL(ReKi)  :: PtfmCMyt = 0.0_ReKi      !< Lateral distance from the ground level [onshore], MSL [offshore wind or floating MHK], or seabed [fixed MHK] to the platform CM [meters]
    REAL(ReKi)  :: PtfmCMzt = 0.0_ReKi      !< Vertical distance from the ground level [onshore], MSL [offshore wind or floating MHK], or seabed [fixed MHK] to the platform CM [meters]
    REAL(ReKi)  :: PtfmRefzt = 0.0_ReKi      !< Vertical distance from the ground level [onshore], MSL [offshore wind or floating MHK], or seabed [fixed MHK] to the platform reference point [meters]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TipMass      !< Tip-brake masses [kg]
    REAL(ReKi)  :: HubMass = 0.0_ReKi      !< Hub mass [kg]
    REAL(ReKi)  :: HubIner = 0.0_ReKi      !< Hub inertia about teeter axis (2-blader) or rotor axis (3-blader) [kg m^2]
    REAL(ReKi)  :: GenIner = 0.0_ReKi      !< Generator inertia about HSS [kg m^2]
    REAL(ReKi)  :: NacMass = 0.0_ReKi      !< Nacelle mass [kg]
    REAL(ReKi)  :: NacYIner = 0.0_ReKi      !< Nacelle yaw inertia [kg m^2]
    REAL(ReKi)  :: YawBrMass = 0.0_ReKi      !< Yaw bearing mass [kg]
    REAL(ReKi)  :: PtfmMass = 0.0_ReKi      !< Platform mass [kg]
    REAL(ReKi)  :: PtfmRIner = 0.0_ReKi      !< Platform inertia for roll tilt rotation about the platform CM [kg m^2]
    REAL(ReKi)  :: PtfmPIner = 0.0_ReKi      !< Platform inertia for pitch tilt rotation about the platform CM [kg m^2]
    REAL(ReKi)  :: PtfmYIner = 0.0_ReKi      !< Platform inertia for yaw rotation about the platform CM [kg m^2]
    REAL(ReKi)  :: PtfmXYIner = 0.0_ReKi      !< Platform xy inertia about the platform CM [kg m^2]
    REAL(ReKi)  :: PtfmYZIner = 0.0_ReKi      !< Platform yz inertia about the platform CM [kg m^2]
    REAL(ReKi)  :: PtfmXZIner = 0.0_ReKi      !< Platform xz inertia about the platform CM [kg m^2]
    REAL(ReKi)  :: BldNodes = 0.0_ReKi      !< Number of blade nodes (per blade) used for analysis [-]
    TYPE(ED_BladeMeshInputData) , DIMENSION(:), ALLOCATABLE  :: InpBlMesh      !< Input data for blade discretizations (could be on each blade) [see BladeMeshInputData]
    TYPE(BladeInputData) , DIMENSION(:), ALLOCATABLE  :: InpBl      !< Input data for individual blades [see BladeInputData type]
    INTEGER(IntKi)  :: TeetMod = 0_IntKi      !< Rotor-teeter spring/damper model switch [-]
    REAL(ReKi)  :: TeetDmpP = 0.0_ReKi      !< Rotor-teeter damper position [radians]
    REAL(ReKi)  :: TeetDmp = 0.0_ReKi      !< Rotor-teeter damping constant [N-m/(rad/s)]
    REAL(ReKi)  :: TeetCDmp = 0.0_ReKi      !< Rotor-teeter rate-independent Coulomb-damping [N-m]
    REAL(ReKi)  :: TeetSStP = 0.0_ReKi      !< Rotor-teeter soft-stop position [radians]
    REAL(ReKi)  :: TeetHStP = 0.0_ReKi      !< Rotor-teeter hard-stop position [radians]
    REAL(ReKi)  :: TeetSSSp = 0.0_ReKi      !< Rotor-teeter soft-stop linear-spring constant [N-m/rad]
    REAL(ReKi)  :: TeetHSSp = 0.0_ReKi      !< Rotor-teeter hard-stop linear-spring constant [N-m/rad]
    INTEGER(IntKi)  :: YawFrctMod = 0_IntKi      !< Identifier for YawFrctMod (0 [no friction], 1 [does not use Fz at bearing], 2 [does use Fz at bearing], or 3 [user defined model] [-]
    REAL(R8Ki)  :: M_CD = 0.0_R8Ki      !< Dynamic friction moment at null yaw rate [N-m]
    REAL(R8Ki)  :: M_FCD = 0.0_R8Ki      !< Dynamic friction moment at null yaw rate proportional to yaw bearing shear force [N-m]
    REAL(R8Ki)  :: M_MCD = 0.0_R8Ki      !< Dynamic friction moment at null yaw rate proportional to yaw bearing bending moment [N-m]
    REAL(R8Ki)  :: M_CSMAX = 0.0_R8Ki      !< Maximum Coulomb friction torque [N-m]
    REAL(R8Ki)  :: M_FCSMAX = 0.0_R8Ki      !< Maximum Coulomb friction torque proportional to yaw bearing shear force [N-m]
    REAL(R8Ki)  :: M_MCSMAX = 0.0_R8Ki      !< Maximum Coulomb friction torque proportional to yaw bearing bending moment [N-m]
    REAL(R8Ki)  :: sig_v = 0.0_R8Ki      !< Linear viscous friction coefficient [N-m/(rad/s)]
    REAL(R8Ki)  :: sig_v2 = 0.0_R8Ki      !< Quadratic viscous friction coefficient [N-m/(rad/s)^2]
    REAL(R8Ki)  :: OmgCut = 0.0_R8Ki      !< Nacelle yaw angular velocity cutoff below which viscous friction is to be linearized [rad/s]
    REAL(ReKi)  :: GBoxEff = 0.0_ReKi      !< Gearbox efficiency [%]
    REAL(ReKi)  :: GBRatio = 0.0_ReKi      !< Gearbox ratio [-]
    REAL(ReKi)  :: DTTorSpr = 0.0_ReKi      !< Drivetrain torsional spring [N-m/rad]
    REAL(ReKi)  :: DTTorDmp = 0.0_ReKi      !< Drivetrain torsional damper [N-m/(rad/s)]
    LOGICAL  :: Furling = .false.      !< Use Additional Furling parameters? [-]
    INTEGER(IntKi)  :: TwrNodes = 0_IntKi      !< Number of tower nodes used in the analysis [-]
    LOGICAL  :: SumPrint = .false.      !< Print summary data to <RootName>.sum [-]
    INTEGER(IntKi)  :: OutFile = 0_IntKi      !< Switch to determine where output will be placed: (1: in module output file only; 2: in glue code output file only; 3: both) [-]
    LOGICAL  :: TabDelim = .false.      !< Flag to cause tab-delimited text output (delimited by space otherwise) [-]
    CHARACTER(20)  :: OutFmt      !< Format used for module's text tabular output (except time); resulting field should be 10 characters [-]
    REAL(DbKi)  :: Tstart = 0.0_R8Ki      !< Time to start module's tabular output [seconds]
    INTEGER(IntKi)  :: DecFact = 0_IntKi      !< Decimation factor for module's tabular output (1=output every step) [-]
    INTEGER(IntKi)  :: NTwGages = 0_IntKi      !< Number of tower strain gages [-]
    INTEGER(IntKi) , DIMENSION(1:9)  :: TwrGagNd = 0_IntKi      !< Nodes closest to the tower strain gages [-]
    INTEGER(IntKi)  :: NBlGages = 0_IntKi      !< Number of blade strain gages [-]
    INTEGER(IntKi) , DIMENSION(1:9)  :: BldGagNd = 0_IntKi      !< Nodes closest to the blade strain gages [-]
    INTEGER(IntKi)  :: NumOuts = 0_IntKi      !< Number of parameters in the output list (number of outputs requested) [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: OutList      !< List of user-requested output channels [-]
    INTEGER(IntKi)  :: NTwInpSt = 0_IntKi      !< Number of tower input stations [-]
    REAL(ReKi) , DIMENSION(1:2)  :: TwrFADmp = 0.0_ReKi      !< Tower fore-aft structural damping ratios [%]
    REAL(ReKi) , DIMENSION(1:2)  :: TwrSSDmp = 0.0_ReKi      !< Tower side-to-side structural damping ratios [%]
    REAL(ReKi) , DIMENSION(1:2)  :: FAStTunr = 0.0_ReKi      !< Tower fore-aft modal stiffness tuners [-]
    REAL(ReKi) , DIMENSION(1:2)  :: SSStTunr = 0.0_ReKi      !< Tower side-to-side modal stiffness tuners [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: HtFract      !< Fractional height of the flexible portion of tower for a given input station [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TMassDen      !< Tower mass density for a given input station [kg/m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TwFAStif      !< Tower fore-aft stiffness for a given input station [Nm^2]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TwSSStif      !< Tower side-to-side stiffness for a given input station [Nm^2]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TwFAM1Sh      !< Tower fore-aft mode-1 shape coefficients [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TwFAM2Sh      !< Tower fore-aft mode-2 shape coefficients [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TwSSM1Sh      !< Tower side-to-side mode-1 shape coefficients [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TwSSM2Sh      !< Tower side-to-side mode-2 shape coefficients [-]
    LOGICAL  :: RFrlDOF = .false.      !< Rotor-furl DOF [-]
    LOGICAL  :: TFrlDOF = .false.      !< Tail-furl DOF [-]
    REAL(ReKi)  :: RotFurl = 0.0_ReKi      !< Initial or fixed rotor-furl angle [radians]
    REAL(ReKi)  :: TailFurl = 0.0_ReKi      !< Initial or fixed tail-furl angle [radians]
    REAL(ReKi)  :: Yaw2Shft = 0.0_ReKi      !< Lateral distance from the yaw axis to the rotor shaft [meters]
    REAL(ReKi)  :: ShftSkew = 0.0_ReKi      !< Rotor shaft skew angle [radians]
    REAL(ReKi) , DIMENSION(1:3)  :: RFrlCM_n = 0.0_ReKi      !< Vector from tower-top to rotor-furl CM [meters]
    REAL(ReKi) , DIMENSION(1:3)  :: BoomCM_n = 0.0_ReKi      !< Vector from tower-top to tail boom CM [meters]
    REAL(ReKi) , DIMENSION(1:3)  :: TFinCM_n = 0.0_ReKi      !< Vector from tower-top to tail fin CM [meters]
    REAL(ReKi) , DIMENSION(1:3)  :: RFrlPnt_n = 0.0_ReKi      !< Vector from tower-top to arbitrary point on rotor-furl axis [meters]
    REAL(ReKi)  :: RFrlSkew = 0.0_ReKi      !< Rotor-furl axis skew angle [radians]
    REAL(ReKi)  :: RFrlTilt = 0.0_ReKi      !< Rotor-furl axis tilt angle [radians]
    REAL(ReKi) , DIMENSION(1:3)  :: TFrlPnt_n = 0.0_ReKi      !< Vector from tower-top to arbitrary point on tail-furl axis [meters]
    REAL(ReKi)  :: TFrlSkew = 0.0_ReKi      !< Rotor-furl axis skew angle [radians]
    REAL(ReKi)  :: TFrlTilt = 0.0_ReKi      !< Rotor-furl axis tilt angle [radians]
    REAL(ReKi)  :: RFrlMass = 0.0_ReKi      !< Rotor-furl mass [kg]
    REAL(ReKi)  :: BoomMass = 0.0_ReKi      !< Tail boom mass [kg]
    REAL(ReKi)  :: TFinMass = 0.0_ReKi      !< Tail fin mass [kg]
    REAL(ReKi)  :: RFrlIner = 0.0_ReKi      !< Rotor-furl inertia about rotor-furl axis [kg m^2]
    REAL(ReKi)  :: TFrlIner = 0.0_ReKi      !< Tail boom inertia about tail-furl axis [kg m^2]
    INTEGER(IntKi)  :: RFrlMod = 0_IntKi      !< Rotor-furl spring/damper model switch [-]
    REAL(ReKi)  :: RFrlSpr = 0.0_ReKi      !< Rotor-furl spring constant [N-m/rad]
    REAL(ReKi)  :: RFrlDmp = 0.0_ReKi      !< Rotor-furl damping constant [N-m/(rad/s)]
    REAL(ReKi)  :: RFrlUSSP = 0.0_ReKi      !< Rotor-furl up-stop spring position [radians]
    REAL(ReKi)  :: RFrlDSSP = 0.0_ReKi      !< Rotor-furl down-stop spring position [radians]
    REAL(ReKi)  :: RFrlUSSpr = 0.0_ReKi      !< Rotor-furl up-stop spring constant [N-m/rad]
    REAL(ReKi)  :: RFrlDSSpr = 0.0_ReKi      !< Rotor-furl down-stop spring constant [N-m/rad]
    REAL(ReKi)  :: RFrlUSDP = 0.0_ReKi      !< Rotor-furl up-stop damper position [radians]
    REAL(ReKi)  :: RFrlDSDP = 0.0_ReKi      !< Rotor-furl down-stop damper position [radians]
    REAL(ReKi)  :: RFrlUSDmp = 0.0_ReKi      !< Rotor-furl up-stop damping constant [N-m/(rad/s)]
    REAL(ReKi)  :: RFrlDSDmp = 0.0_ReKi      !< Rotor-furl down-stop damping constant [N-m/(rad/s)]
    INTEGER(IntKi)  :: TFrlMod = 0_IntKi      !< Tail-furl spring/damper model switch [-]
    REAL(ReKi)  :: TFrlSpr = 0.0_ReKi      !< Tail-furl spring constant [N-m/rad]
    REAL(ReKi)  :: TFrlDmp = 0.0_ReKi      !< Tail-furl damping constant [N-m/(rad/s)]
    REAL(ReKi)  :: TFrlUSSP = 0.0_ReKi      !< Tail-furl up-stop spring position [radians]
    REAL(ReKi)  :: TFrlDSSP = 0.0_ReKi      !< Tail-furl down-stop spring position [radians]
    REAL(ReKi)  :: TFrlUSSpr = 0.0_ReKi      !< Tail-furl up-stop spring constant [N-m/rad]
    REAL(ReKi)  :: TFrlDSSpr = 0.0_ReKi      !< Tail-furl down-stop spring constant [N-m/rad]
    REAL(ReKi)  :: TFrlUSDP = 0.0_ReKi      !< Tail-furl up-stop damper position [radians]
    REAL(ReKi)  :: TFrlDSDP = 0.0_ReKi      !< Tail-furl down-stop damper position [radians]
    REAL(ReKi)  :: TFrlUSDmp = 0.0_ReKi      !< Tail-furl up-stop damping constant [N-m/(rad/s)]
    REAL(ReKi)  :: TFrlDSDmp = 0.0_ReKi      !< Tail-furl down-stop damping constant [N-m/(rad/s)]
    INTEGER(IntKi)  :: method = 0_IntKi      !< Identifier for integration method (1 [RK4], 2 [AB4], or 3 [ABM4]) [-]
    INTEGER(IntKi)  :: BldNd_NumOuts = 0_IntKi      !< Number of requested output channels per blade node (ED_AllBldNdOuts) [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: BldNd_OutList      !< List of user-requested output channels (ED_AllBldNdOuts) [-]
    CHARACTER(1024)  :: BldNd_BlOutNd_Str      !< String to parse for the blade nodes to actually output (ED_AllBldNdOuts) [-]
    INTEGER(IntKi)  :: BldNd_BladesOut = 0_IntKi      !< The blades to output (ED_AllBldNdOuts) [-]
  END TYPE ED_InputFile
! =======================
! =========  ED_CoordSys  =======
  TYPE, PUBLIC :: ED_CoordSys
    REAL(R8Ki) , DIMENSION(1:3)  :: alpha1 = 0.0_R8Ki      !< Vector / direction alpha1 after ptfm yaw rotation [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: alpha2 = 0.0_R8Ki      !< Vector / direction alpha2 after ptfm yaw rotation [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: alpha3 = 0.0_R8Ki      !< Vector / direction alpha3 after ptfm yaw rotation [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: beta1 = 0.0_R8Ki      !< Vector / direction beta1 after ptfm yaw and pitch rotation [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: beta2 = 0.0_R8Ki      !< Vector / direction beta2 after ptfm yaw and pitch rotation [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: beta3 = 0.0_R8Ki      !< Vector / direction beta3 after ptfm yaw and pitch rotation [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: a1 = 0.0_R8Ki      !< Vector / direction a1 (=  xt from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: a2 = 0.0_R8Ki      !< Vector / direction a2 (=  zt from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: a3 = 0.0_R8Ki      !< Vector / direction a3 (= -yt from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: b1 = 0.0_R8Ki      !< Vector / direction b1 (=  xp from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: b2 = 0.0_R8Ki      !< Vector / direction b2 (=  zp from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: b3 = 0.0_R8Ki      !< Vector / direction b3 (= -yp from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: c1 = 0.0_R8Ki      !< Vector / direction c1 (=  xs from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: c2 = 0.0_R8Ki      !< Vector / direction c2 (=  zs from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: c3 = 0.0_R8Ki      !< Vector / direction c3 (= -ys from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: d1 = 0.0_R8Ki      !< Vector / direction d1 (=  xn from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: d2 = 0.0_R8Ki      !< Vector / direction d2 (=  zn from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: d3 = 0.0_R8Ki      !< Vector / direction d3 (= -yn from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: e1 = 0.0_R8Ki      !< Vector / direction e1 (=  xa from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: e2 = 0.0_R8Ki      !< Vector / direction e2 (=  ya from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: e3 = 0.0_R8Ki      !< Vector / direction e3 (=  za from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: f1 = 0.0_R8Ki      !< Vector / direction f1 [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: f2 = 0.0_R8Ki      !< Vector / direction f2 [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: f3 = 0.0_R8Ki      !< Vector / direction f3 [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: g1 = 0.0_R8Ki      !< Vector / direction g1 (=  xh from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: g2 = 0.0_R8Ki      !< Vector / direction g2 (=  yh from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: g3 = 0.0_R8Ki      !< Vector / direction g3 (=  zh from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: i1      !< i1(K,:) = vector / direction i1 for blade K (=  xcK from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: i2      !< i2(K,:) = vector / direction i2 for blade K (=  ycK from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: i3      !< i3(K,:) = vector / direction i3 for blade K (=  zcK from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: j1      !< j1(K,:) = vector / direction j1 for blade K (=  xbK from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: j2      !< j2(K,:) = vector / direction j2 for blade K (=  ybK from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: j3      !< j3(K,:) = vector / direction j3 for blade K (=  zbK from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: m1      !< m1(K,J,:) = vector / direction m1 for node J of blade K (used to calc. and return aerodynamic loads from AeroDyn) [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: m2      !< m2(K,J,:) = vector / direction m2 for node J of blade K (used to calc. and return aerodynamic loads from AeroDyn) [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: m3      !< m3(K,J,:) = vector / direction m3 for node J of blade K (used to calc. and return aerodynamic loads from AeroDyn) [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: n1      !< n1(K,J,:) = vector / direction n1 for node J of blade K (= LxbK from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: n2      !< n2(K,J,:) = vector / direction n2 for node J of blade K (= LybK from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: n3      !< n3(K,J,:) = vector / direction n3 for node J of blade K (= LzbK from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: rf1 = 0.0_R8Ki      !< Vector / direction rf1 (rotor-furl coordinate system = d1 when rotor-furl angle = 0) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: rf2 = 0.0_R8Ki      !< Vector / direction rf2 (rotor-furl coordinate system = d2 when rotor-furl angle = 0) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: rf3 = 0.0_R8Ki      !< Vector / direction rf3 (rotor-furl coordinate system = d3 when rotor-furl angle = 0) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: rfa = 0.0_R8Ki      !< Vector / direction of the rotor-furl axis [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: t1      !< Vector / direction t1 for tower node J (=  Lxt from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: t2      !< Vector / direction t2 for tower node J (=  Lzt from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: t3      !< Vector / direction t3 for tower node J (= -Lyt from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: te1      !< te1(K,J,:) = vector / direction te1 for node J of blade K (used to calc. noise) [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: te2      !< te2(K,J,:) = vector / direction te2 for node J of blade K (used to calc. noise) [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: te3      !< te3(K,J,:) = vector / direction te3 for node J of blade K (used to calc. noise) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: tf1 = 0.0_R8Ki      !< Vector / direction tf1 (tail-furl coordinate system = d1 when rotor-furl angle = 0) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: tf2 = 0.0_R8Ki      !< Vector / direction tf2 (tail-furl coordinate system = d2 when rotor-furl angle = 0) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: tf3 = 0.0_R8Ki      !< Vector / direction tf3 (tail-furl coordinate system = d3 when rotor-furl angle = 0) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: tfa = 0.0_R8Ki      !< Vector / direction of the tail-furl axis [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: z1 = 0.0_R8Ki      !< Vector / direction z1 (=  xi from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: z2 = 0.0_R8Ki      !< Vector / direction z2 (=  zi from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: z3 = 0.0_R8Ki      !< Vector / direction z3 (= -yi from the IEC coord. system) [-]
  END TYPE ED_CoordSys
! =======================
! =========  ED_ActiveDOFs  =======
  TYPE, PUBLIC :: ED_ActiveDOFs
    INTEGER(IntKi)  :: NActvDOF = 0_IntKi      !< The number of active (enabled) DOFs in the model [-]
    INTEGER(IntKi)  :: NPCE = 0_IntKi      !< Number of DOFs that contribute to the QD2T-related linear accelerations of the hub center of mass (point C) in the inertia frame, based on which DOFs are presently enabled [-]
    INTEGER(IntKi)  :: NPDE = 0_IntKi      !< Number of DOFs that contribute to the QD2T-related linear accelerations of the center of mass of the structure that furls with the rotor (not including rotor) (point D) in the inertia frame, based on which DOFs are presently enabled [-]
    INTEGER(IntKi)  :: NPIE = 0_IntKi      !< Number of DOFs that contribute to the QD2T-related linear accelerations of the tail boom center of mass (point I) in the inertia frame, based on which DOFs are presently enabled [-]
    INTEGER(IntKi)  :: NPTE = 0_IntKi      !< Number of DOFs that contribute to the QD2T-related linear accelerations of the tower nodes (point T) in the inertia frame, based on which DOFs are presently enabled [-]
    INTEGER(IntKi)  :: NPTTE = 0_IntKi      !< Number of tower DOFs that contribute to the QD2T-related linear accelerations of the tower nodes (point T) in the inertia frame, based on which DOFs are presently enabled [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: NPSBE      !< Number of blade DOFs that contribute to the QD2T-related linear accelerations of the blade nodes (point S) in the inertia frame, based on which DOFs are presently enabled [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: NPSE      !< Number of DOFs that contribute to the QD2T-related linear accelerations of the blade nodes (point S) in the inertia frame, based on which DOFs are presently enabled [-]
    INTEGER(IntKi)  :: NPUE = 0_IntKi      !< Number of DOFs that contribute to the QD2T-related linear accelerations of the nacelle center of mass (point U) in the inertia frame, based on which DOFs are presently enabled [-]
    INTEGER(IntKi)  :: NPYE = 0_IntKi      !< Number of DOFs that contribute to the QD2T-related linear accelerations of the platform center of mass (point Y) in the inertia frame, based on which DOFs are presently enabled [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: PCE      !< Array of DOF indices (pointers) that contribute to the QD2T-related linear accelerations of the hub center of mass (point C) in the inertia frame, based on which DOFs are presently enabled [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: PDE      !< Array of DOF indices (pointers) that contribute to the QD2T-related linear accelerations of the center of mass of the structure that furls with the rotor (not including rotor) (point D) in the inertia frame, based on which DOFs are presently enabled [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: PIE      !< Array of DOF indices (pointers) that contribute to the QD2T-related linear accelerations of the tail boom center of mass (point I) in the inertia frame, based on which DOFs are presently enabled [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: PTE      !< Array of DOF indices (pointers) that contribute to the QD2T-related linear accelerations of the tower nodes (point T) in the inertia frame, based on which DOFs are presently enabled [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: PTTE      !< Array of tower DOF indices (pointers) that contribute to the QD2T-related linear accelerations of the tower nodes (point T) in the inertia frame, based on which DOFs are presently enabled [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: PS      !< Array of DOF indices (pointers) to the active (enabled) DOFs/states [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: PSBE      !< Array of blade DOF indices (pointers) that contribute to the QD2T-related linear accelerations of the blade nodes (point S) in the inertia frame, based on which DOFs are presently enabled [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: PSE      !< Array of DOF indices (pointers) that contribute to the QD2T-related linear accelerations of the blade nodes (point S) in the inertia frame, based on which DOFs are presently enabled [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: PUE      !< Array of DOF indices (pointers) that contribute to the QD2T-related linear accelerations of the nacelle center of mass (point U) in the inertia frame, based on which DOFs are presently enabled [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: PYE      !< Array of DOF indices (pointers) that contribute to the QD2T-related linear accelerations of the platform center of mass (point Y) in the inertia frame, based on which DOFs are presently enabled [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: SrtPS      !< Sorted (from smallest to largest DOF index) version of PS() [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: SrtPSNAUG      !< SrtPS() with the additional value of NAUG [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: Diag      !< Array containing the indices of SrtPS() associated with each enabled DOF; that is, SrtPS(Diag(I)) = I [-]
  END TYPE ED_ActiveDOFs
! =======================
! =========  ED_RtHndSide  =======
  TYPE, PUBLIC :: ED_RtHndSide
    REAL(R8Ki) , DIMENSION(1:3)  :: rO = 0.0_R8Ki      !< Position vector from inertial frame origin to tower-top / base plate (point O) [m]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: rQS      !< Position vector from the apex of rotation (point Q) to a point on a blade (point S) [m]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: rS      !< Position vector from inertial frame origin to a point on a blade (point S) [m]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: rS0S      !< Position vector from the blade root (point S(0)) to a point on a blade (point S) [m]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: rT      !< Position vector from inertial frame origin to the current node (point T(HNodes(J)) [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: rT0O = 0.0_R8Ki      !< Position vector from the tower base (point T(0)) to tower-top / base plate (point O) [m]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: rT0T      !< Position vector from a height of TowerBsHt (base of flexible portion of tower) (point T(0)) to a point on the tower (point T) [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: rZ = 0.0_R8Ki      !< Position vector from inertia frame origin to platform reference (point Z) [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: rZO = 0.0_R8Ki      !< Position vector from platform reference (point Z) to tower-top / base plate (point O) [m]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: rZT      !< Position vector from platform reference (point Z) to a point on a tower (point T) [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: rPQ = 0.0_R8Ki      !< Position vector from teeter pin (point P) to apex of rotation (point Q) [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: rP = 0.0_R8Ki      !< Position vector from inertial frame origin to teeter pin (point P) [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: rV = 0.0_R8Ki      !< Position vector from inertial frame origin to specified point on rotor-furl axis (point V) [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: rJ = 0.0_R8Ki      !< Position vector from inertial frame origin to tail fin center of mass (point J) [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: rZY = 0.0_R8Ki      !< Position vector from platform reference (point Z) to platform mass center (point Y) [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: rOU = 0.0_R8Ki      !< Position vector from tower-top / base plate (point O) to nacelle center of mass (point U). [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: rOV = 0.0_R8Ki      !< Position vector from tower-top / base plate (point O) to specified point on rotor-furl axis (point V) [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: rVD = 0.0_R8Ki      !< Position vector from specified point on rotor-furl axis (point V) to center of mass of structure that furls with the rotor (not including rotor) (point D) [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: rOW = 0.0_R8Ki      !< Position vector from tower-top / base plate (point O) to specified point on  tail-furl axis (point W) [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: rPC = 0.0_R8Ki      !< Position vector from teeter pin (point P) to hub center of mass (point C) [m]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: rPS0      !< Position vector from teeter pin (point P) to blade root (point S(0)) [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: rQ = 0.0_R8Ki      !< Position vector from inertial frame origin to apex of rotation (point Q) [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: rQC = 0.0_R8Ki      !< Position vector from apex of rotation (point Q) to hub center of mass (point C) [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: rVIMU = 0.0_R8Ki      !< Position vector from specified point on rotor-furl axis (point V) to nacelle IMU (point IMU) [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: rVP = 0.0_R8Ki      !< Position vector from specified point on rotor-furl axis (point V) to teeter pin (point P) [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: rWI = 0.0_R8Ki      !< Position vector from specified point on  tail-furl axis (point W) to tail boom center of mass     (point I) [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: rWJ = 0.0_R8Ki      !< Position vector from specified point on  tail-furl axis (point W) to tail fin  center of mass     (point J) [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: rZT0 = 0.0_R8Ki      !< Position vector from platform reference (point Z) to tower base (point T(0)) [m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: AngPosEF      !< Angular position of the current point on the tower (body F) in the inertial frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: AngPosXF      !< Angular position of the current point on the tower (body F) in the platform (body X) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: AngPosHM      !< Angular position of eleMent J of blade K (body M) in the hub (body H) [-]
    REAL(ReKi) , DIMENSION(1:3)  :: AngPosXB = 0.0_ReKi      !< Angular position of the base plate (body B) in the platform (body X) [-]
    REAL(ReKi) , DIMENSION(1:3)  :: AngPosEX = 0.0_ReKi      !< Angular position of the platform                   (body X) in the inertial frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PAngVelEA      !< Partial angular velocity (and its 1st time derivative) of the tail (body A) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: PAngVelEF      !< Partial angular velocity (and its 1st time derivative) of tower element J (body F) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PAngVelEG      !< Partial angular velocity (and its 1st time derivative) of the generator (body G) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PAngVelEH      !< Partial angular velocity (and its 1st time derivative) of the hub (body H) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PAngVelEL      !< Partial angular velocity (and its 1st time derivative) of the low-speed shaft (body L) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:,:,:), ALLOCATABLE  :: PAngVelEM      !< Partial angular velocity (and its 1st time derivative) of eleMent J of blade K (body M) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: AngVelEM      !< Angular velocity of of eleMent J of blade K (body M) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PAngVelEN      !< Partial angular velocity (and its 1st time derivative) of the nacelle (body N) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(1:3)  :: AngVelEA = 0.0_ReKi      !< Angular velocity of the tail (body A) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PAngVelEB      !< Partial angular velocity (and its 1st time derivative) of the base plate (body B) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PAngVelER      !< Partial angular velocity (and its 1st time derivative) of the structure that furls with the rotor (not including rotor) (body R) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PAngVelEX      !< Partial angular velocity (and its 1st time derivative) of the platform (body B) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(1:3)  :: AngVelEG = 0.0_ReKi      !< Angular velocity of the generator (body G) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(1:3)  :: AngVelEH = 0.0_ReKi      !< Angular velocity of the hub (body H) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(1:3)  :: AngVelEL = 0.0_ReKi      !< Angular velocity of the low-speed shaft (body L) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(1:3)  :: AngVelEN = 0.0_ReKi      !< Angular velocity of the nacelle (body N) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(1:3)  :: AngVelEB = 0.0_ReKi      !< Angular velocity of the base plate (body B) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(1:3)  :: AngVelER = 0.0_ReKi      !< Angular velocity of the structure that furls with the rotor (not including rotor) (body R) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(1:3)  :: AngVelEX = 0.0_ReKi      !< Angular velocity of the platform (body X) in the inertia frame (body E for earth) [-]
    REAL(R8Ki)  :: TeetAngVel = 0.0_R8Ki      !< Angular velocity of the teeter motion [-]
    REAL(ReKi) , DIMENSION(1:3)  :: AngAccEBt = 0.0_ReKi      !< Portion of the angular acceleration of the base plate (body B) in the inertia frame (body E for earth) associated with everything but the QD2T()s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: AngAccERt = 0.0_ReKi      !< Portion of the angular acceleration of the structure that furls with the rotor (not including rotor) (body R) in the inertia frame (body E for earth) associated with everything but the QD2T()s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: AngAccEXt = 0.0_ReKi      !< Portion of the angular acceleration of the platform (body X) in the inertia frame (body E for earth) associated with everything but the QD2T()s [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: AngAccEFt      !< Portion of the angular acceleration of tower element J (body F) in the inertia frame (body E for earth) associated with everything but the QD2T()s [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: AngVelEF      !< Angular velocity of the current point on the tower (body F) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: AngVelHM      !< Angular velocity of the current point on the blade in the inertia frame  [-]
    REAL(ReKi) , DIMENSION(1:3)  :: AngAccEAt = 0.0_ReKi      !< Portion of the angular acceleration of the tail (body A) in the inertia frame (body E for earth) associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: AngAccEGt = 0.0_ReKi      !< Portion of the angular acceleration of the generator (body G) in the inertia frame (body E for earth) associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: AngAccEHt = 0.0_ReKi      !< Portion of the angular acceleration of the hub (body H) in the inertia frame (body E for earth) associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: AngAccEKt      !< Portion of the angular acceleration of the blade in the inertia frame associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: AngAccENt = 0.0_ReKi      !< Portion of the angular acceleration of the nacelle (body N) in the inertia frame (body E for earth) associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: LinAccECt = 0.0_ReKi      !< Portion of the linear acceleration of the hub center of mass (point C) in the inertia frame (body E for earth) associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: LinAccEDt = 0.0_ReKi      !< Portion of the linear acceleration of the center of mass of the structure that furls with the rotor (not including rotor) (point D) in the inertia frame (body E for earth) associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: LinAccEIt = 0.0_ReKi      !< Portion of the linear acceleration of the tail boom center of mass (point I) in the inertia frame (body E for earth) associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: LinAccEJt = 0.0_ReKi      !< Portion of the linear acceleration of the tail fin  center of mass (point J) in the inertia frame (body E for earth) associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: LinAccEUt = 0.0_ReKi      !< Portion of the linear acceleration of the nacelle center of mass (point U) in the inertia frame (body E for earth) associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: LinAccEYt = 0.0_ReKi      !< Portion of the linear acceleration of the platform center of mass (point Y) in the inertia frame (body E for earth) associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: LinVelES      !< Linear velocity of current point on the current blade (point S) in the inertia frame [-]
    REAL(ReKi) , DIMENSION(1:3)  :: LinVelEQ = 0.0_ReKi      !< Linear velocity of of the apex of rotation (point Q) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: LinVelET      !< Linear velocity of current point on the tower (point T) in the inertia frame [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LinVelESm2      !< The m2-component (closest to tip) of LinVelES [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PLinVelEIMU      !< Partial linear velocity (and its 1st time derivative) of the nacelle IMU (point IMU) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PLinVelEO      !< Partial linear velocity (and its 1st time derivative) of the base plate (point O) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:,:,:), ALLOCATABLE  :: PLinVelES      !< Partial linear velocity (and its 1st time derivative) of a point on a blade (point S) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: PLinVelET      !< Partial linear velocity (and its 1st time derivative) of a point on the tower (point T) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PLinVelEZ      !< Partial linear velocity (and its 1st time derivative) of the platform reference point (point Z) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PLinVelEC      !< Partial linear velocity (and its 1st time derivative) of the hub center of mass (point C) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PLinVelED      !< Partial linear velocity (and its 1st time derivative) of the center of mass of the structure that furls with the rotor (not including rotor) (point D) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PLinVelEI      !< Partial linear velocity (and its 1st time derivative) of the tail boom center of mass (point I) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PLinVelEJ      !< Partial linear velocity (and its 1st time derivative) of the tail fin center of mass (point J) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PLinVelEP      !< Partial linear velocity (and its 1st time derivative) of the teeter pin (point P) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PLinVelEQ      !< Partial linear velocity (and its 1st time derivative) of the apex of rotation (point Q) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PLinVelEU      !< Partial linear velocity (and its 1st time derivative) of the nacelle center of mass (point U) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PLinVelEV      !< Partial linear velocity (and its 1st time derivative) of the selected point on the rotor-furl axis (point V) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PLinVelEW      !< Partial linear velocity (and its 1st time derivative) of the selected point on the tail-furl axis (point W) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PLinVelEY      !< Partial linear velocity (and its 1st time derivative) of the platform mass center (point Y) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(1:3)  :: LinAccEIMUt = 0.0_ReKi      !< Portion of the linear acceleration of the nacelle IMU (point IMU) in the inertia frame (body E for earth) associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: LinAccEOt = 0.0_ReKi      !< Portion of the linear acceleration of the base plate (point O) in the inertia frame (body E for earth) associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: LinAccESt      !< Portion of the linear acceleration of a point on a blade (point S) in the inertia frame (body E for earth) associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: LinAccETt      !< Portion of the linear acceleration of a point on the tower (point T) in the inertia frame (body E for earth) associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: LinAccEZt = 0.0_ReKi      !< Portion of the linear acceleration of the platform reference (point Z) in the inertia frame (body E for earth) associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: LinVelEIMU = 0.0_ReKi      !< Linear velocity of the nacelle IMU (point IMU) in the inertia frame [-]
    REAL(ReKi) , DIMENSION(1:3)  :: LinVelEZ = 0.0_ReKi      !< Linear velocity of platform reference (point Z) in the inertia frame [-]
    REAL(ReKi) , DIMENSION(1:3)  :: LinVelEO = 0.0_ReKi      !< Linear velocity of the base plate (point O) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(1:3)  :: LinVelEJ = 0.0_ReKi      !< Linear velocity of the tail fin CM (point J) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(1:3)  :: FrcONcRtt = 0.0_ReKi      !< Portion of the force at yaw bearing (point O) due to the nacelle, generator, and rotor associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: FrcPRott = 0.0_ReKi      !< Portion of the force at the teeter pin (point P) due to the rotor associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: FrcS0Bt      !< Portion of the force at the blade root (point S(0)) due to the blade associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: FrcT0Trbt = 0.0_ReKi      !< Portion of the force at tower base (point T(0)) due to the turbine associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: FSAero      !< The aerodynamic force per unit span acting on a blade at point S [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: FSTipDrag      !< The aerodynamic force at a blade tip resulting from tip drag [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: FTHydrot      !< Portion of the hydrodynamic force (& all other external forces, including aerodynamic) per unit length acting on the tower at point T associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: FZHydrot = 0.0_ReKi      !< Portion of the platform hydrodynamic force at the platform reference (point Z) associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: MFHydrot      !< Portion of the hydrodynamic moment (and all other external moments, including aerodynamic) per unit length acting on a tower element (body F) at point T associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: MomBNcRtt = 0.0_ReKi      !< Portion of the moment at the base plate (body B) / yaw bearing (point O) due to the nacelle, generator, and rotor associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: MomH0Bt      !< Portion of the moment at the hub (body H) / blade root (point S(0)) due to the blade associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: MomLPRott = 0.0_ReKi      !< Portion of the moment at the teeter pin (point P) on the low-speed shaft (body L) due to the rotor associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: MomNGnRtt = 0.0_ReKi      !< Portion of the moment at the nacelle (body N) / selected point on rotor-furl axis (point V) due the structure that furls with the rotor, generator, and rotor associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: MomNTailt = 0.0_ReKi      !< Portion of the moment at the nacelle (body N) / selected point on tail-furl axis (point W) due the tail associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: MomX0Trbt = 0.0_ReKi      !< Portion of the moment at the platform (body X) / tower base (point T(0)) due to the turbine associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: MMAero      !< The aerodynamic moment per unit span acting on a blade at point S [-]
    REAL(ReKi) , DIMENSION(1:3)  :: MXHydrot = 0.0_ReKi      !< Portion of the platform hydrodynamic moment acting at the platform (body X) / platform reference (point Z) associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PFrcONcRt      !< Partial force at the yaw bearing (point O) due to the nacelle, generator, and rotor [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PFrcPRot      !< Partial force at the teeter pin (point P) due to the rotor [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PFrcS0B      !< Partial force at the blade root (point S(0)) due to the blade [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PFrcT0Trb      !< Partial force at the tower base (point T(0)) due to the turbine [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PFTHydro      !< Partial hydrodynamic force per unit length acting on the tower at point T [-]
    REAL(ReKi) , DIMENSION(1:6,1:3)  :: PFZHydro = 0.0_ReKi      !< Partial platform hydrodynamic force at the platform reference (point Z) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PMFHydro      !< Partial hydrodynamic moment per unit length acting on a tower element (body F) at point T [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PMomBNcRt      !< Partial moment at the base plate (body B) / yaw bearing (point O) due the nacelle, generator, and rotor [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PMomH0B      !< Partial moment at the hub (body H) / blade root (point S(0)) due to the blade [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PMomLPRot      !< Partial moment at the teeter pin (point P) on the low-speed shaft (body L) due to the rotor [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PMomNGnRt      !< Partial moment at the nacelle (body N) / selected point on rotor-furl axis (point V) due the structure that furls with the rotor, generator, and rotor [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PMomNTail      !< Partial moment at the nacelle (body N) / selected point on tail-furl axis (point W) due the tail [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PMomX0Trb      !< Partial moment at the platform (body X) / tower base (point T(0)) due to the turbine [-]
    REAL(ReKi) , DIMENSION(1:6,1:3)  :: PMXHydro = 0.0_ReKi      !< Partial platform hydrodynamic moment at the platform (body X) / platform reference (point Z) [-]
    REAL(R8Ki)  :: TeetAng = 0.0_R8Ki      !< Current teeter angle = QT(DOF_Teet) for 2-blader or 0 for 3-blader (this is used in place of QT(DOF_Teet) throughout RtHS() [-]
    REAL(ReKi) , DIMENSION(1:3)  :: FrcVGnRtt = 0.0_ReKi      !< Portion of the force at the rotor-furl axis (point V) due to the structure that furls with the rotor, generator, and rotor associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: FrcWTailt = 0.0_ReKi      !< Portion of the force at the tail-furl axis (point W) due to the tail associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: FrcZAllt = 0.0_ReKi      !< Portion of the force at platform reference (point Z) due to everything associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: MomXAllt = 0.0_ReKi      !< Portion of the moment at the platform (body X) / platform reference (point Z) due to everything associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PFrcVGnRt      !< Partial force at the rotor-furl axis (point V) due to the structure that furls with the rotor, generator, and rotor [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PFrcWTail      !< Partial force at the tail-furl axis (point W) due to the tail [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PFrcZAll      !< Partial force at the platform reference (point Z) due to everything [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PMomXAll      !< Partial moment at the platform (body X) / platform reference (point Z) due to the everything [-]
    REAL(ReKi)  :: TeetMom = 0.0_ReKi      !< The total moment supplied by the stop, spring, and damper of the teeter mechanism [-]
    REAL(ReKi)  :: TFrlMom = 0.0_ReKi      !< The total tail-furl spring and damper moment [-]
    REAL(ReKi)  :: RFrlMom = 0.0_ReKi      !< The total rotor-furl spring and damper moment [-]
    REAL(ReKi)  :: GBoxEffFac = 0.0_ReKi      !< The factor used to apply the gearbox efficiency effects to the equation associated with the generator DOF [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: rSAerCen      !< aerodynamic pitching moment arm (i.e., the position vector from point S on the blade to the aerodynamic center of the element) [-]
    REAL(ReKi)  :: YawFriMom = 0.0_ReKi      !< Yaw Friction Moment [kN-m]
  END TYPE ED_RtHndSide
! =======================
! =========  ED_ContinuousStateType  =======
  TYPE, PUBLIC :: ED_ContinuousStateType
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: QT      !< Current estimate of Q (displacement matrix) for each degree of freedom [-]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: QDT      !< Current estimate of QD (velocity matrix) for each degree of freedom [-]
  END TYPE ED_ContinuousStateType
! =======================
! =========  ED_DiscreteStateType  =======
  TYPE, PUBLIC :: ED_DiscreteStateType
    REAL(ReKi)  :: DummyDiscState = 0.0_ReKi      !< Remove this variable if you have discrete states [-]
  END TYPE ED_DiscreteStateType
! =======================
! =========  ED_ConstraintStateType  =======
  TYPE, PUBLIC :: ED_ConstraintStateType
    REAL(ReKi)  :: DummyConstrState = 0.0_ReKi      !< Remove this variable if you have constraint states [-]
  END TYPE ED_ConstraintStateType
! =======================
! =========  ED_OtherStateType  =======
  TYPE, PUBLIC :: ED_OtherStateType
    INTEGER(IntKi)  :: n = 0_IntKi      !< tracks time step for which OtherState was updated [-]
    TYPE(ED_ContinuousStateType) , DIMENSION(1:ED_NMX)  :: xdot      !< previous state deriv for multi-step [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: IC      !< Array which stores pointers to predictor-corrector results [-]
    REAL(ReKi)  :: HSSBrTrq = 0.0_ReKi      !< HSSBrTrq from update states; a hack to get this working with a single integrator [-]
    REAL(ReKi)  :: HSSBrTrqC = 0.0_ReKi      !< Commanded HSS brake torque (adjusted for sign) [N-m]
    INTEGER(IntKi)  :: SgnPrvLSTQ = 0_IntKi      !< The sign of the low-speed shaft torque from the previous call to RtHS().  This is calculated at the end of RtHS().  NOTE: The low-speed shaft torque is assumed to be positive at the beginning of the run! [-]
    INTEGER(IntKi) , DIMENSION(1:ED_NMX)  :: SgnLSTQ = 0_IntKi      !< history of sign of LSTQ [-]
    REAL(ReKi)  :: Mfhat = 0.0_ReKi      !< Final Yaw Friction Torque [N-m]
    REAL(ReKi)  :: YawFriMfp = 0.0_ReKi      !< Yaw Friction Torque to bring yaw system to a stop at current time step [N-m]
    REAL(R8Ki)  :: OmegaTn = 0.0_R8Ki      !< Yaw rate at t_n used to calculate friction torque and yaw rate at t_n+1 [rad/s]
    REAL(R8Ki)  :: OmegaDotTn = 0.0_R8Ki      !< Yaw acceleration at t_n used to calculate friction torque and yaw rate at t_n+1 [rad/s^2]
  END TYPE ED_OtherStateType
! =======================
! =========  ED_MiscVarType  =======
  TYPE, PUBLIC :: ED_MiscVarType
    TYPE(ED_CoordSys)  :: CoordSys      !< Coordinate systems in the FAST framework [-]
    TYPE(ED_RtHndSide)  :: RtHS      !< Values used in calculating the right-hand-side RtHS (and outputs) [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: AllOuts      !< An array holding the value of all of the calculated (not only selected) output channels [see OutListParameters.xlsx spreadsheet]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: AugMat      !< The augmented matrix used for the solution of the QD2T()s [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: AugMat_factor      !< factored version of AugMat matrix [-]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: SolnVec      !< b in the equation Ax=b (last column of AugMat) [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: AugMat_pivot      !< Pivot column for AugMat in LAPACK factorization [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: OgnlGeAzRo      !< Original DOF_GeAz row in AugMat [-]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: QD2T      !< Solution (acceleration) vector; the first time derivative of QDT [-]
    LOGICAL  :: IgnoreMod = .false.      !< whether to ignore the modulo in ED outputs (necessary for linearization perturbations) [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: OgnlYawRow      !< Original DOF_Yaw row in AugMat [-]
    REAL(ReKi) , DIMENSION(1:3)  :: FrcONcRt = 0.0_ReKi      !< Force acting on yaw bearing including inertial contributions [N]
    REAL(ReKi) , DIMENSION(1:3)  :: MomONcRt = 0.0_ReKi      !< Moment acting on yaw bearing including inertial contributions [N-m]
    REAL(ReKi)  :: YawFriMz = 0.0_ReKi      !< External loading on yaw bearing not including inertial contributions [N-m]
  END TYPE ED_MiscVarType
! =======================
! =========  Jac_u_idxStarts  =======
  TYPE, PUBLIC :: Jac_u_idxStarts
    INTEGER(IntKi)  :: BladeLoad = 1      !< Index to first point in y jacobian for BladeLoad [-]
    INTEGER(IntKi)  :: PlatformLoad = 1      !< Index to first point in y jacobian for PlatformLoad [-]
    INTEGER(IntKi)  :: TowerLoad = 1      !< Index to first point in y jacobian for TowerLoad [-]
    INTEGER(IntKi)  :: HubLoad = 1      !< Index to first point in y jacobian for HubLoad [-]
    INTEGER(IntKi)  :: NacelleLoad = 1      !< Index to first point in y jacobian for NacelleLoad [-]
    INTEGER(IntKi)  :: TFinLoad = 1      !< Index to first point in y jacobian for TFinLoad [-]
    INTEGER(IntKi)  :: BlPitchCom = 1      !< Index to first point in y jacobian for BlPitchCom [-]
  END TYPE Jac_u_idxStarts
! =======================
! =========  Jac_y_idxStarts  =======
  TYPE, PUBLIC :: Jac_y_idxStarts
    INTEGER(IntKi)  :: Blade = 1      !< Index to first point in u jacobian for Blade [-]
    INTEGER(IntKi)  :: Platform = 1      !< Index to first point in u jacobian for Platform [-]
    INTEGER(IntKi)  :: Tower = 1      !< Index to first point in u jacobian for Tower [-]
    INTEGER(IntKi)  :: Hub = 1      !< Index to first point in u jacobian for Hub [-]
    INTEGER(IntKi)  :: BladeRoot = 1      !< Index to first point in u jacobian for BladeRoot [-]
    INTEGER(IntKi)  :: Nacelle = 1      !< Index to first point in u jacobian for Nacelle [-]
    INTEGER(IntKi)  :: TFin = 1      !< Index to first point in u jacobian for TFin [-]
  END TYPE Jac_y_idxStarts
! =======================
! =========  ED_ParameterType  =======
  TYPE, PUBLIC :: ED_ParameterType
    REAL(DbKi)  :: DT = 0.0_R8Ki      !< Time step for continuous state integration & discrete state update [seconds]
    REAL(DbKi)  :: DT24 = 0.0_R8Ki      !< =DT/24 (used in loose coupling) [seconds]
    INTEGER(IntKi)  :: BldNodes = 0_IntKi      !< Number of blade nodes used in the analysis [-]
    INTEGER(IntKi)  :: TipNode = 0_IntKi      !< Index of the additional node located at the blade tip = BldNodes + 1 [-]
    INTEGER(IntKi)  :: NDOF = 0_IntKi      !< Number of total degrees of freedom (DOFs) [-]
    REAL(R8Ki)  :: TwoPiNB = 0.0_R8Ki      !< Two pi divided by the number of blades [radians]
    INTEGER(IntKi)  :: NAug = 0_IntKi      !< Dimension of augmented solution matrix [-]
    INTEGER(IntKi)  :: NPH = 0_IntKi      !< Number of DOFs that contribute to the angular velocity of the hub (body H) in the inertia frame [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: PH      !< Array of DOF indices (pointers) that contribute to the angular velocity of the hub (body H) in the inertia frame [-]
    INTEGER(IntKi)  :: NPM = 0_IntKi      !< Number of DOFs that contribute to the angular velocity of the blade elements (body M) in the inertia frame [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: PM      !< Array of DOF indices (pointers) that contribute to the angular velocity of the blade elements (body M) in the inertia frame [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: DOF_Flag      !< Array which stores values of the feature flags for each DOF [-]
    CHARACTER(99) , DIMENSION(:), ALLOCATABLE  :: DOF_Desc      !< Array which stores descriptions of each DOF [-]
    TYPE(ED_ActiveDOFs)  :: DOFs      !< Active degrees of freedom in the model [-]
    INTEGER(IntKi)  :: NumOuts = 0      !< Number of parameters in the output list (number of outputs requested) [-]
    CHARACTER(20)  :: OutFmt      !< Output format for tabular data [-]
    INTEGER(IntKi)  :: NBlGages = 0      !< Number of blade strain gages [-]
    INTEGER(IntKi)  :: NTwGages = 0      !< Number of tower strain gages [-]
    TYPE(OutParmType) , DIMENSION(:), ALLOCATABLE  :: OutParam      !< Names and units (and other characteristics) of all requested output parameters [-]
    CHARACTER(1)  :: Delim      !< Column delimiter for output text files [-]
    REAL(ReKi)  :: AvgNrmTpRd = 0.0_ReKi      !< Average tip radius normal to the shaft [meters]
    REAL(R8Ki)  :: AzimB1Up = 0.0_R8Ki      !< Azimuth value to use for I/O when blade 1 points up [radians]
    REAL(R8Ki)  :: CosDel3 = 1.0      !< Cosine of the Delta-3 angle for teetering rotors [-]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: CosPreC      !< Cosines of the precone angles [-]
    REAL(R8Ki)  :: CRFrlSkew = 0.0_R8Ki      !< Cosine of the rotor-furl axis skew angle [-]
    REAL(R8Ki)  :: CRFrlSkw2 = 0.0_R8Ki      !< Cosine-squared of the rotor-furl axis skew angle [-]
    REAL(R8Ki)  :: CRFrlTilt = 0.0_R8Ki      !< Cosine of the rotor-furl axis tilt angle [-]
    REAL(R8Ki)  :: CRFrlTlt2 = 0.0_R8Ki      !< Cosine-squared of the rotor-furl axis tilt angle [-]
    REAL(R8Ki)  :: CShftSkew = 0.0_R8Ki      !< Cosine of the shaft skew angle [-]
    REAL(R8Ki)  :: CShftTilt = 0.0_R8Ki      !< Cosine of the shaft tilt angle [-]
    REAL(R8Ki)  :: CSRFrlSkw = 0.0_R8Ki      !< Cosine*Sine of the rotor-furl axis skew angle [-]
    REAL(R8Ki)  :: CSRFrlTlt = 0.0_R8Ki      !< Cosine*Sine of the rotor-furl axis tilt angle [-]
    REAL(R8Ki)  :: CSTFrlSkw = 0.0_R8Ki      !< Cosine*Sine of the tail-furl axis skew angle [-]
    REAL(R8Ki)  :: CSTFrlTlt = 0.0_R8Ki      !< Cosine*Sine of the tail-furl axis tilt angle [-]
    REAL(R8Ki)  :: CTFrlSkew = 0.0_R8Ki      !< Cosine of the tail-furl axis skew angle [-]
    REAL(R8Ki)  :: CTFrlSkw2 = 0.0_R8Ki      !< Cosine-squared of the tail-furl axis skew angle [-]
    REAL(R8Ki)  :: CTFrlTilt = 0.0_R8Ki      !< Cosine of the tail-furl axis tilt angle [-]
    REAL(R8Ki)  :: CTFrlTlt2 = 0.0_R8Ki      !< Cosine-squared of the tail-furl axis tilt angle [-]
    REAL(ReKi)  :: HubHt = 0.0_ReKi      !< Hub-height as computed using FAST inputs [= TowerHt + Twr2Shft + OverHang*SIN( ShftTilt ) ] (was FASTHH) [-]
    REAL(ReKi)  :: HubCM = 0.0_ReKi      !< Distance from rotor apex to hub mass [-]
    REAL(ReKi)  :: HubRad = 0.0_ReKi      !< Preconed hub radius [-]
    REAL(ReKi)  :: NacCMxn = 0.0_ReKi      !< Downwind distance from tower-top to nacelle CM [-]
    REAL(ReKi)  :: NacCMyn = 0.0_ReKi      !< Lateral distance from tower-top to nacelle CM [-]
    REAL(ReKi)  :: NacCMzn = 0.0_ReKi      !< Vertical distance from tower-top to nacelle CM [-]
    REAL(ReKi)  :: OverHang = 0.0_ReKi      !< Distance from yaw axis to rotor apex or teeter pin [-]
    REAL(ReKi)  :: ProjArea = 0.0_ReKi      !< Swept area of the rotor projected onto the rotor plane (the plane normal to the low-speed shaft) [-]
    REAL(ReKi)  :: PtfmRefzt = 0.0_ReKi      !< Vertical distance from the ground level [onshore], MSL [offshore wind or floating MHK], or seabed [fixed MHK] to the platform reference point [-]
    REAL(ReKi)  :: RefTwrHt = 0.0_ReKi      !< Vertical distance between FAST's undisplaced tower height (variable TowerHt) and FAST's inertia frame reference point (variable PtfmRef); that is, RefTwrHt = TowerHt - PtfmRefzt [-]
    REAL(ReKi) , DIMENSION(1:3)  :: RFrlPnt_n = 0.0_ReKi      !< Vector from tower-top to arbitrary point on rotor-furl axis [-]
    REAL(ReKi)  :: rVDxn = 0.0_ReKi      !< xn-component of position vector Rvd [-]
    REAL(ReKi)  :: rVDyn = 0.0_ReKi      !< yn-component of position vector rVD [-]
    REAL(ReKi)  :: rVDzn = 0.0_ReKi      !< zn-component of position vector rVD [-]
    REAL(ReKi)  :: rVIMUxn = 0.0_ReKi      !< xn-component of position vector rVIMU [-]
    REAL(ReKi)  :: rVIMUyn = 0.0_ReKi      !< yn-component of position vector rVIMU [-]
    REAL(ReKi)  :: rVIMUzn = 0.0_ReKi      !< zn-component of position vector rVIMU [-]
    REAL(ReKi)  :: rVPxn = 0.0_ReKi      !< xn-component of position vector rVP [-]
    REAL(ReKi)  :: rVPyn = 0.0_ReKi      !< yn-component of position vector rVP [-]
    REAL(ReKi)  :: rVPzn = 0.0_ReKi      !< zn-component of position vector rVP [-]
    REAL(ReKi)  :: rWIxn = 0.0_ReKi      !< xn-component of position vector rWI [-]
    REAL(ReKi)  :: rWIyn = 0.0_ReKi      !< yn-component of position vector rWI [-]
    REAL(ReKi)  :: rWIzn = 0.0_ReKi      !< zn-component of position vector rWI [-]
    REAL(ReKi)  :: rWJxn = 0.0_ReKi      !< xn-component of position vector rWJ [-]
    REAL(ReKi)  :: rWJyn = 0.0_ReKi      !< yn-component of position vector rWJ [-]
    REAL(ReKi)  :: rWJzn = 0.0_ReKi      !< zn-component of position vector rWJ [-]
    REAL(ReKi)  :: rZT0zt = 0.0_ReKi      !< zt-component of position vector rZT0 [-]
    REAL(ReKi)  :: rZYzt = 0.0_ReKi      !< zt-component of position vector rZY [-]
    REAL(R8Ki)  :: SinDel3 = 0.0_R8Ki      !< Sine of the Delta-3 angle for teetering rotors [-]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: SinPreC      !< Sines of the precone angles [-]
    REAL(R8Ki)  :: SRFrlSkew = 0.0_R8Ki      !< Sine of the rotor-furl axis skew angle [-]
    REAL(R8Ki)  :: SRFrlSkw2 = 0.0_R8Ki      !< Sine-squared of the rotor-furl axis skew angle [-]
    REAL(R8Ki)  :: SRFrlTilt = 0.0_R8Ki      !< Sine of the rotor-furl axis tilt angle [-]
    REAL(R8Ki)  :: SRFrlTlt2 = 0.0_R8Ki      !< Sine-squared of the rotor-furl axis tilt angle [-]
    REAL(R8Ki)  :: SShftSkew = 0.0_R8Ki      !< Sine of the shaft skew angle [-]
    REAL(R8Ki)  :: SShftTilt = 0.0_R8Ki      !< Sine of the shaft tilt angle [-]
    REAL(R8Ki)  :: STFrlSkew = 0.0_R8Ki      !< Sine of the tail-furl axis skew angle [-]
    REAL(R8Ki)  :: STFrlSkw2 = 0.0_R8Ki      !< Sine-squared of the tail-furl axis skew angle [-]
    REAL(R8Ki)  :: STFrlTilt = 0.0_R8Ki      !< Sine of the tail-furl axis tilt angle [-]
    REAL(R8Ki)  :: STFrlTlt2 = 0.0_R8Ki      !< Sine-squared of the tail-furl axis tilt angle [-]
    REAL(ReKi) , DIMENSION(1:3)  :: TFrlPnt_n = 0.0_ReKi      !< Vector from tower-top to arbitrary point on tail-furl axis [-]
    REAL(ReKi)  :: TipRad = 0.0_ReKi      !< Preconed blade-tip radius [-]
    REAL(ReKi)  :: TowerHt = 0.0_ReKi      !< Height of tower relative to ground level [onshore], MSL [offshore wind or floating MHK], or seabed [fixed MHK] [meters]
    REAL(ReKi)  :: TowerBsHt = 0.0_ReKi      !< Height of tower base relative to ground level [onshore], MSL [offshore wind or floating MHK], or seabed [fixed MHK] [meters]
    REAL(ReKi)  :: UndSling = 0.0_ReKi      !< Undersling length [-]
    INTEGER(IntKi)  :: NumBl = 0_IntKi      !< Number of turbine blades [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: AxRedTFA      !< The axial-reduction terms for the fore-aft tower mode shapes [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: AxRedTSS      !< The axial-reduction terms for the side-to-side tower mode shapes [-]
    REAL(ReKi) , DIMENSION(1:2,1:2)  :: CTFA = 0.0_ReKi      !< Generalized damping of tower in fore-aft direction [-]
    REAL(ReKi) , DIMENSION(1:2,1:2)  :: CTSS = 0.0_ReKi      !< Generalized damping of tower in side-to-side direction [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: DHNodes      !< Length of variable-length tower elements [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: HNodes      !< Location of variable-spaced tower nodes (relative to the tower rigid base height [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: HNodesNorm      !< Normalized location of variable-spaced tower nodes (relative to the tower rigid base height) (0 < HNodesNorm(:) < 1) [-]
    REAL(ReKi) , DIMENSION(1:2,1:2)  :: KTFA = 0.0_ReKi      !< Generalized stiffness of tower in fore-aft direction [-]
    REAL(ReKi) , DIMENSION(1:2,1:2)  :: KTSS = 0.0_ReKi      !< Generalized stiffness of tower in side-to-side direction [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: MassT      !< Interpolated lineal mass density of tower [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: StiffTSS      !< Interpolated side-side tower stiffness [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: TwrFASF      !< Tower fore-aft shape functions [-]
    REAL(ReKi)  :: TwrFlexL = 0.0_ReKi      !< Height / length of the flexible portion of the tower [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: TwrSSSF      !< Tower side-to-side shape functions [-]
    INTEGER(IntKi)  :: TTopNode = 0_IntKi      !< Index of the additional node located at the tower-top = TwrNodes + 1 [-]
    INTEGER(IntKi)  :: TwrNodes = 0_IntKi      !< Number of tower nodes used in the analysis [-]
    INTEGER(IntKi)  :: MHK = 0_IntKi      !< MHK turbine type switch [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: StiffTFA      !< Interpolated fore-aft tower stiffness [-]
    REAL(ReKi)  :: AtfaIner = 0.0_ReKi      !< Inertia of tail boom about the tail-furl axis whose origin is the tail boom center of mass [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BldCG      !< Blade center of mass wrt the blade root [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BldMass      !< Blade masses [-]
    REAL(ReKi)  :: BoomMass = 0.0_ReKi      !< Tail boom mass [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: FirstMom      !< First mass moment of inertia of blades wrt the root [-]
    REAL(ReKi)  :: GenIner = 0.0_ReKi      !< Generator inertia about HSS [-]
    REAL(ReKi)  :: Hubg1Iner = 0.0_ReKi      !< Inertia of hub about g1-axis (rotor centerline) [-]
    REAL(ReKi)  :: Hubg2Iner = 0.0_ReKi      !< Inertia of hub about g2-axis (transverse to the cyclinder and passing through its c.g.) [-]
    REAL(ReKi)  :: HubMass = 0.0_ReKi      !< Hub mass [-]
    REAL(ReKi)  :: Nacd2Iner = 0.0_ReKi      !< Inertia of nacelle about the d2-axis whose origin is the nacelle center of mass [-]
    REAL(ReKi)  :: NacMass = 0.0_ReKi      !< Nacelle mass [-]
    REAL(ReKi)  :: PtfmMass = 0.0_ReKi      !< Platform mass [-]
    REAL(ReKi)  :: PtfmPIner = 0.0_ReKi      !< Platform inertia for pitch tilt rotation about the platform CM. [-]
    REAL(ReKi)  :: PtfmRIner = 0.0_ReKi      !< Platform inertia for roll tilt rotation about the platform CM. [-]
    REAL(ReKi)  :: PtfmYIner = 0.0_ReKi      !< Platform inertia for yaw rotation about the platform CM. [-]
    REAL(ReKi)  :: PtfmXYIner = 0.0_ReKi      !< Platform xy inertia about the platform CM [kg m^2]
    REAL(ReKi)  :: PtfmYZIner = 0.0_ReKi      !< Platform yz inertia about the platform CM [kg m^2]
    REAL(ReKi)  :: PtfmXZIner = 0.0_ReKi      !< Platform xz inertia about the platform CM [kg m^2]
    REAL(ReKi)  :: RFrlMass = 0.0_ReKi      !< Rotor-furl mass [-]
    REAL(ReKi)  :: RotIner = 0.0_ReKi      !< Inertia of rotor about its centerline [-]
    REAL(ReKi)  :: RotMass = 0.0_ReKi      !< Rotor mass (blades, tips, and hub) [-]
    REAL(ReKi)  :: RrfaIner = 0.0_ReKi      !< Inertia of structure that furls with the rotor (not including rotor) about the rotor-furl axis whose origin is the center of mass of the structure that furls with the rotor (not including rotor) [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: SecondMom      !< Second mass moment of inertia of blades wrt the root [-]
    REAL(ReKi)  :: TFinMass = 0.0_ReKi      !< Tail fin mass [-]
    REAL(ReKi)  :: TFrlIner = 0.0_ReKi      !< Tail boom inertia about tail-furl axis [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TipMass      !< Tip-brake masses [-]
    REAL(ReKi)  :: TurbMass = 0.0_ReKi      !< Mass of turbine (tower + rotor + nacelle) [-]
    REAL(ReKi)  :: TwrMass = 0.0_ReKi      !< Mass of tower [-]
    REAL(ReKi)  :: TwrTpMass = 0.0_ReKi      !< Tower-top mass (rotor + nacelle) [-]
    REAL(ReKi)  :: YawBrMass = 0.0_ReKi      !< Yaw bearing mass [-]
    REAL(ReKi)  :: Gravity = 0.0_ReKi      !< Gravitational acceleration [m/s^2]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PitchAxis      !< Pitch axis for analysis nodes [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: AeroTwst      !< Aerodynamic twist of the blade at the analysis nodes [-]
    REAL(ReKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: AxRedBld      !< The axial-reduction terms of the blade shape function [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: BldEDamp      !< Blade edgewise damping coefficients [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: BldFDamp      !< Blade flapwise damping coefficients [-]
    REAL(ReKi)  :: BldFlexL = 0.0_ReKi      !< Flexible blade length [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: CAeroTwst      !< Cosine of the aerodynamic twist of the blade at the analysis nodes [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: CBE      !< Generalized edgewise damping of the blades [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: CBF      !< Generalized flapwise damping of the blades [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Chord      !< Chord of the blade at the analysis nodes [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: CThetaS      !< COS( ThetaS ) [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: DRNodes      !< Length of variable-spaced blade elements [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: FStTunr      !< Blade flapwise modal stiffness tuners (stored for all blades) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: KBE      !< Generalized edgewise stiffness of the blades [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: KBF      !< Generalized flapwise stiffness of the blades [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: MassB      !< Interpolated lineal blade mass density [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: RNodes      !< Radius to analysis nodes relative to hub ( 0 < RNodes(:) < BldFlexL ) [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: RNodesNorm      !< Normalized radius to analysis nodes relative to hub ( 0 < RNodesNorm(:) < 1 ) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: rSAerCenn1      !< Distance from point S on a blade to the aerodynamic center in the n1 direction (m) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: rSAerCenn2      !< Distance from point S on a blade to the aerodynamic center in the n2 direction (m) [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: SAeroTwst      !< Sine of the aerodynamic twist of the blade at the analysis nodes [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: StiffBE      !< Interpolated edgewise blade stiffness [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: StiffBF      !< Interpolated flapwise blade stiffness [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: SThetaS      !< SIN( ThetaS ) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: ThetaS      !< Structural twist for analysis nodes [radians]
    REAL(ReKi) , DIMENSION(:,:,:,:,:), ALLOCATABLE  :: TwistedSF      !< Interpolated lineal blade mass density [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: BldFl1Sh      !< Blade-flap-mode-1 shape coefficients [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: BldFl2Sh      !< Blade-flap-mode-2 shape coefficients [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: BldEdgSh      !< Blade-edge-mode shape coefficients [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: FreqBE      !< Blade edgewise natural frequencies (both w/ and w/o centrifugal stiffening) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: FreqBF      !< Blade flapwise natural frequencies (both w/ and w/o centrifugal stiffening) [-]
    REAL(ReKi) , DIMENSION(1:2,1:2)  :: FreqTFA = 0.0_ReKi      !< Computed fore-aft tower natural frequencies [-]
    REAL(ReKi) , DIMENSION(1:2,1:2)  :: FreqTSS = 0.0_ReKi      !< Computed side-to-side tower natural frequencies [-]
    REAL(ReKi)  :: TeetCDmp = 0.0_ReKi      !< Rotor-teeter rate-independent Coulomb-damping [-]
    REAL(ReKi)  :: TeetDmp = 0.0_ReKi      !< Rotor-teeter damping constant [-]
    REAL(ReKi)  :: TeetDmpP = 0.0_ReKi      !< Rotor-teeter damper position [-]
    REAL(ReKi)  :: TeetHSSp = 0.0_ReKi      !< Rotor-teeter hard-stop linear-spring constant [-]
    REAL(ReKi)  :: TeetHStP = 0.0_ReKi      !< Rotor-teeter hard-stop position [-]
    REAL(ReKi)  :: TeetSSSp = 0.0_ReKi      !< Rotor-teeter soft-stop linear-spring constant [-]
    REAL(ReKi)  :: TeetSStP = 0.0_ReKi      !< Rotor-teeter soft-stop position [-]
    INTEGER(IntKi)  :: TeetMod = 0_IntKi      !< Rotor-teeter spring/damper model switch [-]
    REAL(ReKi)  :: TFrlDmp = 0.0_ReKi      !< Tail-furl damping constant [-]
    REAL(ReKi)  :: TFrlDSDmp = 0.0_ReKi      !< Tail-furl down-stop damping constant [-]
    REAL(ReKi)  :: TFrlDSDP = 0.0_ReKi      !< Tail-furl down-stop damper position [-]
    REAL(ReKi)  :: TFrlDSSP = 0.0_ReKi      !< Tail-furl down-stop spring position [-]
    REAL(ReKi)  :: TFrlDSSpr = 0.0_ReKi      !< Tail-furl down-stop spring constant [-]
    REAL(ReKi)  :: TFrlSpr = 0.0_ReKi      !< Tail-furl spring constant [-]
    REAL(ReKi)  :: TFrlUSDmp = 0.0_ReKi      !< Tail-furl up-stop damping constant [-]
    REAL(ReKi)  :: TFrlUSDP = 0.0_ReKi      !< Tail-furl up-stop damper position [-]
    REAL(ReKi)  :: TFrlUSSP = 0.0_ReKi      !< Tail-furl up-stop spring position [-]
    REAL(ReKi)  :: TFrlUSSpr = 0.0_ReKi      !< Tail-furl up-stop spring constant [-]
    INTEGER(IntKi)  :: TFrlMod = 0_IntKi      !< Tail-furl spring/damper model switch [-]
    REAL(ReKi)  :: RFrlDmp = 0.0_ReKi      !< Rotor-furl damping constant [-]
    REAL(ReKi)  :: RFrlDSDmp = 0.0_ReKi      !< Rotor-furl down-stop damping constant [-]
    REAL(ReKi)  :: RFrlDSDP = 0.0_ReKi      !< Rotor-furl down-stop damper position [-]
    REAL(ReKi)  :: RFrlDSSP = 0.0_ReKi      !< Rotor-furl down-stop spring position [-]
    REAL(ReKi)  :: RFrlDSSpr = 0.0_ReKi      !< Rotor-furl down-stop spring constant [-]
    REAL(ReKi)  :: RFrlSpr = 0.0_ReKi      !< Rotor-furl spring constant [-]
    REAL(ReKi)  :: RFrlUSDmp = 0.0_ReKi      !< Rotor-furl up-stop damping constant [-]
    REAL(ReKi)  :: RFrlUSDP = 0.0_ReKi      !< Rotor-furl up-stop damper position [-]
    REAL(ReKi)  :: RFrlUSSP = 0.0_ReKi      !< Rotor-furl up-stop spring position [-]
    REAL(ReKi)  :: RFrlUSSpr = 0.0_ReKi      !< Rotor-furl up-stop spring constant [-]
    INTEGER(IntKi)  :: RFrlMod = 0_IntKi      !< Rotor-furl spring/damper model switch [-]
    REAL(ReKi)  :: ShftGagL = 0.0_ReKi      !< Distance from hub or teeter pin to shaft strain gages [-]
    INTEGER(IntKi) , DIMENSION(1:9)  :: BldGagNd = 0_IntKi      !< Nodes closest to the blade strain gages [-]
    INTEGER(IntKi) , DIMENSION(1:9)  :: TwrGagNd = 0_IntKi      !< Nodes closest to the tower strain gages [-]
    REAL(DbKi)  :: TStart = 0.0_R8Ki      !< Time to begin tabular output [-]
    REAL(ReKi)  :: DTTorDmp = 0.0_ReKi      !< Drivetrain torsional damper [-]
    REAL(ReKi)  :: DTTorSpr = 0.0_ReKi      !< Drivetrain torsional spring [-]
    REAL(ReKi)  :: GBRatio = 0.0_ReKi      !< Gearbox ratio [-]
    REAL(ReKi)  :: GBoxEff = 0.0_ReKi      !< Gearbox efficiency [-]
    REAL(ReKi)  :: RotSpeed = 0.0_ReKi      !< Initial or fixed rotor speed [rad/s]
    CHARACTER(1024)  :: RootName      !< RootName for writing output files [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: BElmntMass      !< Mass of the blade elements [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TElmntMass      !< Mass of the tower elements [-]
    INTEGER(IntKi)  :: method = 0_IntKi      !< Identifier for integration method (1 [RK4], 2 [AB4], or 3 [ABM4]) [-]
    REAL(ReKi)  :: PtfmCMxt = 0.0_ReKi      !< Downwind distance from the ground level [onshore], MSL [offshore wind or floating MHK], or seabed [fixed MHK] to the platform CM [meters]
    REAL(ReKi)  :: PtfmCMyt = 0.0_ReKi      !< Lateral distance from the ground level [onshore], MSL [offshore wind or floating MHK], or seabed [fixed MHK] to the platform CM [meters]
    LOGICAL  :: BD4Blades = .false.      !< flag to determine if BeamDyn is computing blade loads (true) or ElastoDyn is (false) [-]
    LOGICAL  :: RigidAero = .false.      !< flag to determine if ElastoDyn if blades are rigid for aero -- when AeroDisk is used [-]
    INTEGER(IntKi)  :: YawFrctMod = 0_IntKi      !< Identifier for YawFrctMod (0 [no friction], 1 [does not use Fz at bearing], or 2 [does use Fz at bearing] [-]
    REAL(R8Ki)  :: M_CD = 0.0_R8Ki      !< Dynamic friction moment at null yaw rate [N-m]
    REAL(R8Ki)  :: M_FCD = 0.0_R8Ki      !< Dynamic friction moment at null yaw rate proportional to yaw bearing shear force [N-m]
    REAL(R8Ki)  :: M_MCD = 0.0_R8Ki      !< Dynamic friction moment at null yaw rate proportional to yaw bearing bending moment [N-m]
    REAL(R8Ki)  :: M_CSMAX = 0.0_R8Ki      !< Maximum Coulomb friction torque [N-m]
    REAL(R8Ki)  :: M_FCSMAX = 0.0_R8Ki      !< Maximum Coulomb friction torque proportional to yaw bearing shear force [N-m]
    REAL(R8Ki)  :: M_MCSMAX = 0.0_R8Ki      !< Maximum Coulomb friction torque proportional to yaw bearing bending moment [N-m]
    REAL(R8Ki)  :: sig_v = 0.0_R8Ki      !< Linear viscous friction coefficient [N-m/(rad/s)]
    REAL(R8Ki)  :: sig_v2 = 0.0_R8Ki      !< Quadratic viscous friction coefficient [N-m/(rad/s)^2]
    REAL(R8Ki)  :: OmgCut = 0.0_R8Ki      !< Nacelle yaw angular velocity cutoff below which viscous friction is to be linearized [rad/s]
    INTEGER(IntKi)  :: BldNd_NumOuts = 0_IntKi      !< Number of requested output channels per blade node (ED_AllBldNdOuts) [-]
    INTEGER(IntKi)  :: BldNd_TotNumOuts = 0_IntKi      !< Total number of requested output channels of blade node information (BldNd_NumOuts * BldNd_BlOutNd * BldNd_BladesOut -- ED_AllBldNdOuts) [-]
    TYPE(OutParmType) , DIMENSION(:), ALLOCATABLE  :: BldNd_OutParam      !< Names and units (and other characteristics) of all requested output parameters [-]
    INTEGER(IntKi)  :: BldNd_BladesOut = 0_IntKi      !< The blades to output (ED_AllBldNdOuts) [-]
    TYPE(Jac_u_idxStarts)  :: Jac_u_idxStartList      !< Starting indices for all Jac_u compenents [-]
    TYPE(Jac_y_idxStarts)  :: Jac_y_idxStartList      !< Starting indices for all Jac_u compenents [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: Jac_u_indx      !< matrix to help fill/pack the u vector in computing the jacobian [-]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: du      !< vector that determines size of perturbation for u (inputs) [-]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: dx      !< vector that determines size of perturbation for x (continuous states) [-]
    INTEGER(IntKi)  :: Jac_ny = 0_IntKi      !< number of outputs in jacobian matrix [-]
    LOGICAL  :: CompAeroMaps = .false.      !< number of outputs in jacobian matrix [-]
    INTEGER(IntKi)  :: NumExtendedInputs = 0_IntKi      !< number of extended inputs for linearization [-]
    INTEGER(IntKi)  :: NumBl_Lin = 0_IntKi      !< number of blades in the jacobian [-]
    INTEGER(IntKi)  :: NActvVelDOF_Lin = 0_IntKi      !< number of velocity states in the jacobian [-]
    INTEGER(IntKi)  :: NActvDOF_Lin = 0_IntKi      !< number of active DOFs to use in the jacobian [-]
    INTEGER(IntKi)  :: NActvDOF_Stride = 0_IntKi      !< stride for active DOFs to use in the jacobian [-]
  END TYPE ED_ParameterType
! =======================
! =========  ED_InputType  =======
  TYPE, PUBLIC :: ED_InputType
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: BladePtLoads      !< A mesh on each blade, containing aerodynamic forces and moments (formerly AeroBladeForce and AeroBladeMoment) [-]
    TYPE(MeshType)  :: PlatformPtMesh      !< A mesh at the platform reference (point Z), containing force: surge/xi (1), sway/yi (2), and heave/zi (3)-components; and moments: roll/xi (1), pitch/yi (2), and yaw/zi (3)-components acting at the platform (body X) / platform reference (point Z) associated with everything but the QD2T()s [N]
    TYPE(MeshType)  :: TowerPtLoads      !< Tower line2 mesh with forces: surge/xi (1), sway/yi (2), and heave/zi (3)-components of the portion of the tower force at the current tower node (point T); and moments: roll/xi (1), pitch/yi (2), and yaw/zi (3)-components of the portion of the tower moment acting at the current tower node [N/m]
    TYPE(MeshType)  :: HubPtLoad      !< A mesh at the teeter pin, containing forces: surge/xi (1), sway/yi (2), and heave/zi (3)-components; and moments: roll/xi (1), pitch/yi (2), and yaw/zi (3)-components acting at the hub. Passed from BeamDyn [-]
    TYPE(MeshType)  :: NacelleLoads      !< From ServoDyn/TMD: loads on the nacelle. [-]
    TYPE(MeshType)  :: TFinCMLoads      !< Aerodynamic forces and moments at the tail-fin center of mass point (point J) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: TwrAddedMass      !< 6-by-6 added mass matrix of the tower elements, per unit length-bjj: place on a mesh [per unit length]
    REAL(ReKi) , DIMENSION(1:6,1:6)  :: PtfmAddedMass = 0.0_ReKi      !< Platform added mass matrix [kg, kg-m, kg-m^2]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BlPitchCom      !< Commanded blade pitch angles [radians]
    REAL(ReKi)  :: YawMom = 0.0_ReKi      !< Torque transmitted through the yaw bearing [N-m]
    REAL(ReKi)  :: GenTrq = 0.0_ReKi      !< Electrical generator torque [N-m]
    REAL(ReKi)  :: HSSBrTrqC = 0.0_ReKi      !< Commanded HSS brake torque [N-m]
  END TYPE ED_InputType
! =======================
! =========  ED_OutputType  =======
  TYPE, PUBLIC :: ED_OutputType
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: BladeLn2Mesh      !< A mesh on each blade, containing positions and orientations of the blade elements [-]
    TYPE(MeshType)  :: PlatformPtMesh      !< Platform reference point positions/orientations/velocities/accelerations [-]
    TYPE(MeshType)  :: TowerLn2Mesh      !< Tower line2 mesh with positions/orientations/velocities/accelerations [-]
    TYPE(MeshType)  :: HubPtMotion      !< For AeroDyn and Lidar(InflowWind): motions of the hub [-]
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: BladeRootMotion      !< For AeroDyn/BeamDyn: motions at the blade roots [-]
    TYPE(MeshType)  :: NacelleMotion      !< For AeroDyn & ServoDyn/TMD: motions of the nacelle. [-]
    TYPE(MeshType)  :: TFinCMMotion      !< For AeroDyn: motions of the tail find CM point (point J) [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WriteOutput      !< Data to be written to an output file: see WriteOutputHdr for names of each variable [see WriteOutputUnt]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BlPitch      !< Current blade pitch angles [radians]
    REAL(ReKi)  :: Yaw = 0.0_ReKi      !< Current nacelle yaw [radians]
    REAL(ReKi)  :: YawRate = 0.0_ReKi      !< Current nacelle yaw rate [rad/s]
    REAL(ReKi)  :: LSS_Spd = 0.0_ReKi      !< Low-speed shaft (LSS) speed at entrance to gearbox [rad/s]
    REAL(ReKi)  :: HSS_Spd = 0.0_ReKi      !< High-speed shaft (HSS) speed [rad/s]
    REAL(ReKi)  :: RotSpeed = 0.0_ReKi      !< Rotor azimuth angular speed [rad/s]
    REAL(ReKi)  :: TwrAccel = 0.0_ReKi      !< Tower acceleration for tower feedback control (user routine only) [m/s^2]
    REAL(ReKi)  :: YawAngle = 0.0_ReKi      !< Yaw angle to be used for yaw error calculations [radians]
    REAL(ReKi) , DIMENSION(1:3)  :: RootMyc = 0.0_ReKi      !< Out-of-plane moment (i.e., the moment caused by out-of-plane forces) at the blade root for each of the blades (max 3) [N-m]
    REAL(ReKi)  :: YawBrTAxp = 0.0_ReKi      !< Tower-top / yaw bearing fore-aft (translational) acceleration (absolute) [m/s^2]
    REAL(ReKi)  :: YawBrTAyp = 0.0_ReKi      !< Tower-top / yaw bearing side-to-side (translational) acceleration (absolute) [m/s^2]
    REAL(ReKi)  :: LSSTipPxa = 0.0_ReKi      !< Rotor azimuth angle (position) [radians]
    REAL(ReKi) , DIMENSION(1:3)  :: RootMxc = 0.0_ReKi      !< In-plane moment (i.e., the moment caused by in-plane forces) at the blade root [N-m]
    REAL(ReKi)  :: LSSTipMxa = 0.0_ReKi      !< Rotating low-speed shaft bending moment at the shaft tip (teeter pin for 2-blader, apex of rotation for 3-blader) [N-m]
    REAL(ReKi)  :: LSSTipMya = 0.0_ReKi      !< Rotating low-speed shaft bending moment at the shaft tip (teeter pin for 2-blader, apex of rotation for 3-blader) [N-m]
    REAL(ReKi)  :: LSSTipMza = 0.0_ReKi      !< Rotating low-speed shaft bending moment at the shaft tip (teeter pin for 2-blader, apex of rotation for 3-blader) [N-m]
    REAL(ReKi)  :: LSSTipMys = 0.0_ReKi      !< Nonrotating low-speed shaft bending moment at the shaft tip (teeter pin for 2-blader, apex of rotation for 3-blader) [N-m]
    REAL(ReKi)  :: LSSTipMzs = 0.0_ReKi      !< Nonrotating low-speed shaft bending moment at the shaft tip (teeter pin for 2-blader, apex of rotation for 3-blader) [N-m]
    REAL(ReKi)  :: YawBrMyn = 0.0_ReKi      !< Rotating (with nacelle) tower-top / yaw bearing pitch moment [N-m]
    REAL(ReKi)  :: YawBrMzn = 0.0_ReKi      !< Tower-top / yaw bearing yaw moment [N-m]
    REAL(ReKi)  :: NcIMURAxs = 0.0_ReKi      !< Nacelle inertial measurement unit angular (rotational) acceleration (absolute) [rad/s^2]
    REAL(ReKi)  :: NcIMURAys = 0.0_ReKi      !< Nacelle inertial measurement unit angular (rotational) acceleration (absolute) [rad/s^2]
    REAL(ReKi)  :: NcIMURAzs = 0.0_ReKi      !< Nacelle inertial measurement unit angular (rotational) acceleration (absolute) [rad/s^2]
    REAL(ReKi)  :: RotPwr = 0.0_ReKi      !< Rotor power (this is equivalent to the low-speed shaft power) [W]
    REAL(ReKi)  :: LSShftFxa = 0.0_ReKi      !< Rotating low-speed shaft force x [N]
    REAL(ReKi)  :: LSShftFys = 0.0_ReKi      !< Nonrotating low-speed shaft force y [N]
    REAL(ReKi)  :: LSShftFzs = 0.0_ReKi      !< Nonrotating low-speed shaft force z [N]
  END TYPE ED_OutputType
! =======================
CONTAINS

subroutine ED_CopyInitInput(SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg)
   type(ED_InitInputType), intent(in) :: SrcInitInputData
   type(ED_InitInputType), intent(inout) :: DstInitInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ED_CopyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInitInputData%InputFile = SrcInitInputData%InputFile
   DstInitInputData%Linearize = SrcInitInputData%Linearize
   DstInitInputData%CompElast = SrcInitInputData%CompElast
   DstInitInputData%RigidAero = SrcInitInputData%RigidAero
   DstInitInputData%RootName = SrcInitInputData%RootName
   DstInitInputData%Gravity = SrcInitInputData%Gravity
   DstInitInputData%MHK = SrcInitInputData%MHK
   DstInitInputData%WtrDpth = SrcInitInputData%WtrDpth
   DstInitInputData%CompAeroMaps = SrcInitInputData%CompAeroMaps
   DstInitInputData%RotSpeed = SrcInitInputData%RotSpeed
end subroutine

subroutine ED_DestroyInitInput(InitInputData, ErrStat, ErrMsg)
   type(ED_InitInputType), intent(inout) :: InitInputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ED_DestroyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine ED_PackInitInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ED_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ED_PackInitInput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%InputFile)
   call RegPack(RF, InData%Linearize)
   call RegPack(RF, InData%CompElast)
   call RegPack(RF, InData%RigidAero)
   call RegPack(RF, InData%RootName)
   call RegPack(RF, InData%Gravity)
   call RegPack(RF, InData%MHK)
   call RegPack(RF, InData%WtrDpth)
   call RegPack(RF, InData%CompAeroMaps)
   call RegPack(RF, InData%RotSpeed)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ED_UnPackInitInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ED_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ED_UnPackInitInput'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%InputFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Linearize); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CompElast); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RigidAero); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Gravity); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MHK); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WtrDpth); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CompAeroMaps); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RotSpeed); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ED_CopyInitOutput(SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg)
   type(ED_InitOutputType), intent(in) :: SrcInitOutputData
   type(ED_InitOutputType), intent(inout) :: DstInitOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ED_CopyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcInitOutputData%WriteOutputHdr)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputHdr)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputHdr)
      if (.not. allocated(DstInitOutputData%WriteOutputHdr)) then
         allocate(DstInitOutputData%WriteOutputHdr(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputHdr.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputHdr = SrcInitOutputData%WriteOutputHdr
   end if
   if (allocated(SrcInitOutputData%WriteOutputUnt)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputUnt)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputUnt)
      if (.not. allocated(DstInitOutputData%WriteOutputUnt)) then
         allocate(DstInitOutputData%WriteOutputUnt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputUnt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputUnt = SrcInitOutputData%WriteOutputUnt
   end if
   call NWTC_Library_CopyProgDesc(SrcInitOutputData%Ver, DstInitOutputData%Ver, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstInitOutputData%NumBl = SrcInitOutputData%NumBl
   if (allocated(SrcInitOutputData%BlPitch)) then
      LB(1:1) = lbound(SrcInitOutputData%BlPitch)
      UB(1:1) = ubound(SrcInitOutputData%BlPitch)
      if (.not. allocated(DstInitOutputData%BlPitch)) then
         allocate(DstInitOutputData%BlPitch(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%BlPitch.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%BlPitch = SrcInitOutputData%BlPitch
   end if
   DstInitOutputData%BladeLength = SrcInitOutputData%BladeLength
   DstInitOutputData%TowerFlexL = SrcInitOutputData%TowerFlexL
   DstInitOutputData%TowerBaseHeight = SrcInitOutputData%TowerBaseHeight
   DstInitOutputData%HubHt = SrcInitOutputData%HubHt
   if (allocated(SrcInitOutputData%BldRNodes)) then
      LB(1:1) = lbound(SrcInitOutputData%BldRNodes)
      UB(1:1) = ubound(SrcInitOutputData%BldRNodes)
      if (.not. allocated(DstInitOutputData%BldRNodes)) then
         allocate(DstInitOutputData%BldRNodes(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%BldRNodes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%BldRNodes = SrcInitOutputData%BldRNodes
   end if
   if (allocated(SrcInitOutputData%TwrHNodes)) then
      LB(1:1) = lbound(SrcInitOutputData%TwrHNodes)
      UB(1:1) = ubound(SrcInitOutputData%TwrHNodes)
      if (.not. allocated(DstInitOutputData%TwrHNodes)) then
         allocate(DstInitOutputData%TwrHNodes(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%TwrHNodes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%TwrHNodes = SrcInitOutputData%TwrHNodes
   end if
   DstInitOutputData%PlatformPos = SrcInitOutputData%PlatformPos
   DstInitOutputData%TwrBaseRefPos = SrcInitOutputData%TwrBaseRefPos
   DstInitOutputData%TwrBaseTransDisp = SrcInitOutputData%TwrBaseTransDisp
   DstInitOutputData%TwrBaseRefOrient = SrcInitOutputData%TwrBaseRefOrient
   DstInitOutputData%TwrBaseOrient = SrcInitOutputData%TwrBaseOrient
   DstInitOutputData%HubRad = SrcInitOutputData%HubRad
   DstInitOutputData%RotSpeed = SrcInitOutputData%RotSpeed
   DstInitOutputData%isFixed_GenDOF = SrcInitOutputData%isFixed_GenDOF
   if (allocated(SrcInitOutputData%LinNames_y)) then
      LB(1:1) = lbound(SrcInitOutputData%LinNames_y)
      UB(1:1) = ubound(SrcInitOutputData%LinNames_y)
      if (.not. allocated(DstInitOutputData%LinNames_y)) then
         allocate(DstInitOutputData%LinNames_y(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LinNames_y.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%LinNames_y = SrcInitOutputData%LinNames_y
   end if
   if (allocated(SrcInitOutputData%LinNames_x)) then
      LB(1:1) = lbound(SrcInitOutputData%LinNames_x)
      UB(1:1) = ubound(SrcInitOutputData%LinNames_x)
      if (.not. allocated(DstInitOutputData%LinNames_x)) then
         allocate(DstInitOutputData%LinNames_x(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LinNames_x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%LinNames_x = SrcInitOutputData%LinNames_x
   end if
   if (allocated(SrcInitOutputData%LinNames_u)) then
      LB(1:1) = lbound(SrcInitOutputData%LinNames_u)
      UB(1:1) = ubound(SrcInitOutputData%LinNames_u)
      if (.not. allocated(DstInitOutputData%LinNames_u)) then
         allocate(DstInitOutputData%LinNames_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LinNames_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%LinNames_u = SrcInitOutputData%LinNames_u
   end if
   if (allocated(SrcInitOutputData%RotFrame_y)) then
      LB(1:1) = lbound(SrcInitOutputData%RotFrame_y)
      UB(1:1) = ubound(SrcInitOutputData%RotFrame_y)
      if (.not. allocated(DstInitOutputData%RotFrame_y)) then
         allocate(DstInitOutputData%RotFrame_y(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%RotFrame_y.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%RotFrame_y = SrcInitOutputData%RotFrame_y
   end if
   if (allocated(SrcInitOutputData%RotFrame_x)) then
      LB(1:1) = lbound(SrcInitOutputData%RotFrame_x)
      UB(1:1) = ubound(SrcInitOutputData%RotFrame_x)
      if (.not. allocated(DstInitOutputData%RotFrame_x)) then
         allocate(DstInitOutputData%RotFrame_x(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%RotFrame_x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%RotFrame_x = SrcInitOutputData%RotFrame_x
   end if
   if (allocated(SrcInitOutputData%DerivOrder_x)) then
      LB(1:1) = lbound(SrcInitOutputData%DerivOrder_x)
      UB(1:1) = ubound(SrcInitOutputData%DerivOrder_x)
      if (.not. allocated(DstInitOutputData%DerivOrder_x)) then
         allocate(DstInitOutputData%DerivOrder_x(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%DerivOrder_x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%DerivOrder_x = SrcInitOutputData%DerivOrder_x
   end if
   if (allocated(SrcInitOutputData%RotFrame_u)) then
      LB(1:1) = lbound(SrcInitOutputData%RotFrame_u)
      UB(1:1) = ubound(SrcInitOutputData%RotFrame_u)
      if (.not. allocated(DstInitOutputData%RotFrame_u)) then
         allocate(DstInitOutputData%RotFrame_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%RotFrame_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%RotFrame_u = SrcInitOutputData%RotFrame_u
   end if
   if (allocated(SrcInitOutputData%IsLoad_u)) then
      LB(1:1) = lbound(SrcInitOutputData%IsLoad_u)
      UB(1:1) = ubound(SrcInitOutputData%IsLoad_u)
      if (.not. allocated(DstInitOutputData%IsLoad_u)) then
         allocate(DstInitOutputData%IsLoad_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%IsLoad_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%IsLoad_u = SrcInitOutputData%IsLoad_u
   end if
   DstInitOutputData%GearBox_index = SrcInitOutputData%GearBox_index
end subroutine

subroutine ED_DestroyInitOutput(InitOutputData, ErrStat, ErrMsg)
   type(ED_InitOutputType), intent(inout) :: InitOutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ED_DestroyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InitOutputData%WriteOutputHdr)) then
      deallocate(InitOutputData%WriteOutputHdr)
   end if
   if (allocated(InitOutputData%WriteOutputUnt)) then
      deallocate(InitOutputData%WriteOutputUnt)
   end if
   call NWTC_Library_DestroyProgDesc(InitOutputData%Ver, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(InitOutputData%BlPitch)) then
      deallocate(InitOutputData%BlPitch)
   end if
   if (allocated(InitOutputData%BldRNodes)) then
      deallocate(InitOutputData%BldRNodes)
   end if
   if (allocated(InitOutputData%TwrHNodes)) then
      deallocate(InitOutputData%TwrHNodes)
   end if
   if (allocated(InitOutputData%LinNames_y)) then
      deallocate(InitOutputData%LinNames_y)
   end if
   if (allocated(InitOutputData%LinNames_x)) then
      deallocate(InitOutputData%LinNames_x)
   end if
   if (allocated(InitOutputData%LinNames_u)) then
      deallocate(InitOutputData%LinNames_u)
   end if
   if (allocated(InitOutputData%RotFrame_y)) then
      deallocate(InitOutputData%RotFrame_y)
   end if
   if (allocated(InitOutputData%RotFrame_x)) then
      deallocate(InitOutputData%RotFrame_x)
   end if
   if (allocated(InitOutputData%DerivOrder_x)) then
      deallocate(InitOutputData%DerivOrder_x)
   end if
   if (allocated(InitOutputData%RotFrame_u)) then
      deallocate(InitOutputData%RotFrame_u)
   end if
   if (allocated(InitOutputData%IsLoad_u)) then
      deallocate(InitOutputData%IsLoad_u)
   end if
end subroutine

subroutine ED_PackInitOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ED_InitOutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ED_PackInitOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%WriteOutputHdr)
   call RegPackAlloc(RF, InData%WriteOutputUnt)
   call NWTC_Library_PackProgDesc(RF, InData%Ver) 
   call RegPack(RF, InData%NumBl)
   call RegPackAlloc(RF, InData%BlPitch)
   call RegPack(RF, InData%BladeLength)
   call RegPack(RF, InData%TowerFlexL)
   call RegPack(RF, InData%TowerBaseHeight)
   call RegPack(RF, InData%HubHt)
   call RegPackAlloc(RF, InData%BldRNodes)
   call RegPackAlloc(RF, InData%TwrHNodes)
   call RegPack(RF, InData%PlatformPos)
   call RegPack(RF, InData%TwrBaseRefPos)
   call RegPack(RF, InData%TwrBaseTransDisp)
   call RegPack(RF, InData%TwrBaseRefOrient)
   call RegPack(RF, InData%TwrBaseOrient)
   call RegPack(RF, InData%HubRad)
   call RegPack(RF, InData%RotSpeed)
   call RegPack(RF, InData%isFixed_GenDOF)
   call RegPackAlloc(RF, InData%LinNames_y)
   call RegPackAlloc(RF, InData%LinNames_x)
   call RegPackAlloc(RF, InData%LinNames_u)
   call RegPackAlloc(RF, InData%RotFrame_y)
   call RegPackAlloc(RF, InData%RotFrame_x)
   call RegPackAlloc(RF, InData%DerivOrder_x)
   call RegPackAlloc(RF, InData%RotFrame_u)
   call RegPackAlloc(RF, InData%IsLoad_u)
   call RegPack(RF, InData%GearBox_index)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ED_UnPackInitOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ED_InitOutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ED_UnPackInitOutput'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%WriteOutputHdr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutputUnt); if (RegCheckErr(RF, RoutineName)) return
   call NWTC_Library_UnpackProgDesc(RF, OutData%Ver) ! Ver 
   call RegUnpack(RF, OutData%NumBl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BlPitch); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BladeLength); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TowerFlexL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TowerBaseHeight); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HubHt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BldRNodes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TwrHNodes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PlatformPos); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TwrBaseRefPos); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TwrBaseTransDisp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TwrBaseRefOrient); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TwrBaseOrient); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HubRad); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RotSpeed); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%isFixed_GenDOF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LinNames_y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LinNames_x); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LinNames_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RotFrame_y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RotFrame_x); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%DerivOrder_x); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RotFrame_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%IsLoad_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GearBox_index); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ED_CopyBladeInputData(SrcBladeInputDataData, DstBladeInputDataData, CtrlCode, ErrStat, ErrMsg)
   type(BladeInputData), intent(in) :: SrcBladeInputDataData
   type(BladeInputData), intent(inout) :: DstBladeInputDataData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'ED_CopyBladeInputData'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstBladeInputDataData%NBlInpSt = SrcBladeInputDataData%NBlInpSt
   if (allocated(SrcBladeInputDataData%BlFract)) then
      LB(1:1) = lbound(SrcBladeInputDataData%BlFract)
      UB(1:1) = ubound(SrcBladeInputDataData%BlFract)
      if (.not. allocated(DstBladeInputDataData%BlFract)) then
         allocate(DstBladeInputDataData%BlFract(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladeInputDataData%BlFract.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladeInputDataData%BlFract = SrcBladeInputDataData%BlFract
   end if
   if (allocated(SrcBladeInputDataData%PitchAx)) then
      LB(1:1) = lbound(SrcBladeInputDataData%PitchAx)
      UB(1:1) = ubound(SrcBladeInputDataData%PitchAx)
      if (.not. allocated(DstBladeInputDataData%PitchAx)) then
         allocate(DstBladeInputDataData%PitchAx(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladeInputDataData%PitchAx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladeInputDataData%PitchAx = SrcBladeInputDataData%PitchAx
   end if
   if (allocated(SrcBladeInputDataData%StrcTwst)) then
      LB(1:1) = lbound(SrcBladeInputDataData%StrcTwst)
      UB(1:1) = ubound(SrcBladeInputDataData%StrcTwst)
      if (.not. allocated(DstBladeInputDataData%StrcTwst)) then
         allocate(DstBladeInputDataData%StrcTwst(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladeInputDataData%StrcTwst.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladeInputDataData%StrcTwst = SrcBladeInputDataData%StrcTwst
   end if
   if (allocated(SrcBladeInputDataData%BMassDen)) then
      LB(1:1) = lbound(SrcBladeInputDataData%BMassDen)
      UB(1:1) = ubound(SrcBladeInputDataData%BMassDen)
      if (.not. allocated(DstBladeInputDataData%BMassDen)) then
         allocate(DstBladeInputDataData%BMassDen(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladeInputDataData%BMassDen.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladeInputDataData%BMassDen = SrcBladeInputDataData%BMassDen
   end if
   if (allocated(SrcBladeInputDataData%FlpStff)) then
      LB(1:1) = lbound(SrcBladeInputDataData%FlpStff)
      UB(1:1) = ubound(SrcBladeInputDataData%FlpStff)
      if (.not. allocated(DstBladeInputDataData%FlpStff)) then
         allocate(DstBladeInputDataData%FlpStff(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladeInputDataData%FlpStff.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladeInputDataData%FlpStff = SrcBladeInputDataData%FlpStff
   end if
   if (allocated(SrcBladeInputDataData%EdgStff)) then
      LB(1:1) = lbound(SrcBladeInputDataData%EdgStff)
      UB(1:1) = ubound(SrcBladeInputDataData%EdgStff)
      if (.not. allocated(DstBladeInputDataData%EdgStff)) then
         allocate(DstBladeInputDataData%EdgStff(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladeInputDataData%EdgStff.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladeInputDataData%EdgStff = SrcBladeInputDataData%EdgStff
   end if
   DstBladeInputDataData%BldFlDmp = SrcBladeInputDataData%BldFlDmp
   DstBladeInputDataData%BldEdDmp = SrcBladeInputDataData%BldEdDmp
   DstBladeInputDataData%FlStTunr = SrcBladeInputDataData%FlStTunr
   if (allocated(SrcBladeInputDataData%BldFl1Sh)) then
      LB(1:1) = lbound(SrcBladeInputDataData%BldFl1Sh)
      UB(1:1) = ubound(SrcBladeInputDataData%BldFl1Sh)
      if (.not. allocated(DstBladeInputDataData%BldFl1Sh)) then
         allocate(DstBladeInputDataData%BldFl1Sh(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladeInputDataData%BldFl1Sh.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladeInputDataData%BldFl1Sh = SrcBladeInputDataData%BldFl1Sh
   end if
   if (allocated(SrcBladeInputDataData%BldFl2Sh)) then
      LB(1:1) = lbound(SrcBladeInputDataData%BldFl2Sh)
      UB(1:1) = ubound(SrcBladeInputDataData%BldFl2Sh)
      if (.not. allocated(DstBladeInputDataData%BldFl2Sh)) then
         allocate(DstBladeInputDataData%BldFl2Sh(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladeInputDataData%BldFl2Sh.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladeInputDataData%BldFl2Sh = SrcBladeInputDataData%BldFl2Sh
   end if
   if (allocated(SrcBladeInputDataData%BldEdgSh)) then
      LB(1:1) = lbound(SrcBladeInputDataData%BldEdgSh)
      UB(1:1) = ubound(SrcBladeInputDataData%BldEdgSh)
      if (.not. allocated(DstBladeInputDataData%BldEdgSh)) then
         allocate(DstBladeInputDataData%BldEdgSh(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladeInputDataData%BldEdgSh.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladeInputDataData%BldEdgSh = SrcBladeInputDataData%BldEdgSh
   end if
end subroutine

subroutine ED_DestroyBladeInputData(BladeInputDataData, ErrStat, ErrMsg)
   type(BladeInputData), intent(inout) :: BladeInputDataData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ED_DestroyBladeInputData'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(BladeInputDataData%BlFract)) then
      deallocate(BladeInputDataData%BlFract)
   end if
   if (allocated(BladeInputDataData%PitchAx)) then
      deallocate(BladeInputDataData%PitchAx)
   end if
   if (allocated(BladeInputDataData%StrcTwst)) then
      deallocate(BladeInputDataData%StrcTwst)
   end if
   if (allocated(BladeInputDataData%BMassDen)) then
      deallocate(BladeInputDataData%BMassDen)
   end if
   if (allocated(BladeInputDataData%FlpStff)) then
      deallocate(BladeInputDataData%FlpStff)
   end if
   if (allocated(BladeInputDataData%EdgStff)) then
      deallocate(BladeInputDataData%EdgStff)
   end if
   if (allocated(BladeInputDataData%BldFl1Sh)) then
      deallocate(BladeInputDataData%BldFl1Sh)
   end if
   if (allocated(BladeInputDataData%BldFl2Sh)) then
      deallocate(BladeInputDataData%BldFl2Sh)
   end if
   if (allocated(BladeInputDataData%BldEdgSh)) then
      deallocate(BladeInputDataData%BldEdgSh)
   end if
end subroutine

subroutine ED_PackBladeInputData(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(BladeInputData), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ED_PackBladeInputData'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%NBlInpSt)
   call RegPackAlloc(RF, InData%BlFract)
   call RegPackAlloc(RF, InData%PitchAx)
   call RegPackAlloc(RF, InData%StrcTwst)
   call RegPackAlloc(RF, InData%BMassDen)
   call RegPackAlloc(RF, InData%FlpStff)
   call RegPackAlloc(RF, InData%EdgStff)
   call RegPack(RF, InData%BldFlDmp)
   call RegPack(RF, InData%BldEdDmp)
   call RegPack(RF, InData%FlStTunr)
   call RegPackAlloc(RF, InData%BldFl1Sh)
   call RegPackAlloc(RF, InData%BldFl2Sh)
   call RegPackAlloc(RF, InData%BldEdgSh)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ED_UnPackBladeInputData(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(BladeInputData), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ED_UnPackBladeInputData'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%NBlInpSt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BlFract); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PitchAx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%StrcTwst); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BMassDen); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%FlpStff); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%EdgStff); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BldFlDmp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BldEdDmp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FlStTunr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BldFl1Sh); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BldFl2Sh); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BldEdgSh); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ED_CopyBladeMeshInputData(SrcBladeMeshInputDataData, DstBladeMeshInputDataData, CtrlCode, ErrStat, ErrMsg)
   type(ED_BladeMeshInputData), intent(in) :: SrcBladeMeshInputDataData
   type(ED_BladeMeshInputData), intent(inout) :: DstBladeMeshInputDataData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'ED_CopyBladeMeshInputData'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstBladeMeshInputDataData%BldNodes = SrcBladeMeshInputDataData%BldNodes
   if (allocated(SrcBladeMeshInputDataData%RNodes)) then
      LB(1:1) = lbound(SrcBladeMeshInputDataData%RNodes)
      UB(1:1) = ubound(SrcBladeMeshInputDataData%RNodes)
      if (.not. allocated(DstBladeMeshInputDataData%RNodes)) then
         allocate(DstBladeMeshInputDataData%RNodes(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladeMeshInputDataData%RNodes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladeMeshInputDataData%RNodes = SrcBladeMeshInputDataData%RNodes
   end if
   if (allocated(SrcBladeMeshInputDataData%AeroTwst)) then
      LB(1:1) = lbound(SrcBladeMeshInputDataData%AeroTwst)
      UB(1:1) = ubound(SrcBladeMeshInputDataData%AeroTwst)
      if (.not. allocated(DstBladeMeshInputDataData%AeroTwst)) then
         allocate(DstBladeMeshInputDataData%AeroTwst(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladeMeshInputDataData%AeroTwst.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladeMeshInputDataData%AeroTwst = SrcBladeMeshInputDataData%AeroTwst
   end if
   if (allocated(SrcBladeMeshInputDataData%Chord)) then
      LB(1:1) = lbound(SrcBladeMeshInputDataData%Chord)
      UB(1:1) = ubound(SrcBladeMeshInputDataData%Chord)
      if (.not. allocated(DstBladeMeshInputDataData%Chord)) then
         allocate(DstBladeMeshInputDataData%Chord(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladeMeshInputDataData%Chord.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladeMeshInputDataData%Chord = SrcBladeMeshInputDataData%Chord
   end if
end subroutine

subroutine ED_DestroyBladeMeshInputData(BladeMeshInputDataData, ErrStat, ErrMsg)
   type(ED_BladeMeshInputData), intent(inout) :: BladeMeshInputDataData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ED_DestroyBladeMeshInputData'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(BladeMeshInputDataData%RNodes)) then
      deallocate(BladeMeshInputDataData%RNodes)
   end if
   if (allocated(BladeMeshInputDataData%AeroTwst)) then
      deallocate(BladeMeshInputDataData%AeroTwst)
   end if
   if (allocated(BladeMeshInputDataData%Chord)) then
      deallocate(BladeMeshInputDataData%Chord)
   end if
end subroutine

subroutine ED_PackBladeMeshInputData(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ED_BladeMeshInputData), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ED_PackBladeMeshInputData'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%BldNodes)
   call RegPackAlloc(RF, InData%RNodes)
   call RegPackAlloc(RF, InData%AeroTwst)
   call RegPackAlloc(RF, InData%Chord)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ED_UnPackBladeMeshInputData(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ED_BladeMeshInputData), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ED_UnPackBladeMeshInputData'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%BldNodes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RNodes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AeroTwst); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Chord); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ED_CopyInputFile(SrcInputFileData, DstInputFileData, CtrlCode, ErrStat, ErrMsg)
   type(ED_InputFile), intent(in) :: SrcInputFileData
   type(ED_InputFile), intent(inout) :: DstInputFileData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ED_CopyInputFile'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInputFileData%DT = SrcInputFileData%DT
   DstInputFileData%FlapDOF1 = SrcInputFileData%FlapDOF1
   DstInputFileData%FlapDOF2 = SrcInputFileData%FlapDOF2
   DstInputFileData%EdgeDOF = SrcInputFileData%EdgeDOF
   DstInputFileData%TeetDOF = SrcInputFileData%TeetDOF
   DstInputFileData%DrTrDOF = SrcInputFileData%DrTrDOF
   DstInputFileData%GenDOF = SrcInputFileData%GenDOF
   DstInputFileData%YawDOF = SrcInputFileData%YawDOF
   DstInputFileData%TwFADOF1 = SrcInputFileData%TwFADOF1
   DstInputFileData%TwFADOF2 = SrcInputFileData%TwFADOF2
   DstInputFileData%TwSSDOF1 = SrcInputFileData%TwSSDOF1
   DstInputFileData%TwSSDOF2 = SrcInputFileData%TwSSDOF2
   DstInputFileData%PtfmSgDOF = SrcInputFileData%PtfmSgDOF
   DstInputFileData%PtfmSwDOF = SrcInputFileData%PtfmSwDOF
   DstInputFileData%PtfmHvDOF = SrcInputFileData%PtfmHvDOF
   DstInputFileData%PtfmRDOF = SrcInputFileData%PtfmRDOF
   DstInputFileData%PtfmPDOF = SrcInputFileData%PtfmPDOF
   DstInputFileData%PtfmYDOF = SrcInputFileData%PtfmYDOF
   DstInputFileData%OoPDefl = SrcInputFileData%OoPDefl
   DstInputFileData%IPDefl = SrcInputFileData%IPDefl
   if (allocated(SrcInputFileData%BlPitch)) then
      LB(1:1) = lbound(SrcInputFileData%BlPitch)
      UB(1:1) = ubound(SrcInputFileData%BlPitch)
      if (.not. allocated(DstInputFileData%BlPitch)) then
         allocate(DstInputFileData%BlPitch(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%BlPitch.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%BlPitch = SrcInputFileData%BlPitch
   end if
   DstInputFileData%TeetDefl = SrcInputFileData%TeetDefl
   DstInputFileData%Azimuth = SrcInputFileData%Azimuth
   DstInputFileData%RotSpeed = SrcInputFileData%RotSpeed
   DstInputFileData%NacYaw = SrcInputFileData%NacYaw
   DstInputFileData%TTDspFA = SrcInputFileData%TTDspFA
   DstInputFileData%TTDspSS = SrcInputFileData%TTDspSS
   DstInputFileData%PtfmSurge = SrcInputFileData%PtfmSurge
   DstInputFileData%PtfmSway = SrcInputFileData%PtfmSway
   DstInputFileData%PtfmHeave = SrcInputFileData%PtfmHeave
   DstInputFileData%PtfmRoll = SrcInputFileData%PtfmRoll
   DstInputFileData%PtfmPitch = SrcInputFileData%PtfmPitch
   DstInputFileData%PtfmYaw = SrcInputFileData%PtfmYaw
   DstInputFileData%NumBl = SrcInputFileData%NumBl
   DstInputFileData%TipRad = SrcInputFileData%TipRad
   DstInputFileData%HubRad = SrcInputFileData%HubRad
   if (allocated(SrcInputFileData%PreCone)) then
      LB(1:1) = lbound(SrcInputFileData%PreCone)
      UB(1:1) = ubound(SrcInputFileData%PreCone)
      if (.not. allocated(DstInputFileData%PreCone)) then
         allocate(DstInputFileData%PreCone(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%PreCone.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%PreCone = SrcInputFileData%PreCone
   end if
   DstInputFileData%HubCM = SrcInputFileData%HubCM
   DstInputFileData%UndSling = SrcInputFileData%UndSling
   DstInputFileData%Delta3 = SrcInputFileData%Delta3
   DstInputFileData%AzimB1Up = SrcInputFileData%AzimB1Up
   DstInputFileData%OverHang = SrcInputFileData%OverHang
   DstInputFileData%ShftGagL = SrcInputFileData%ShftGagL
   DstInputFileData%ShftTilt = SrcInputFileData%ShftTilt
   DstInputFileData%NacCMxn = SrcInputFileData%NacCMxn
   DstInputFileData%NacCMyn = SrcInputFileData%NacCMyn
   DstInputFileData%NacCMzn = SrcInputFileData%NacCMzn
   DstInputFileData%NcIMUxn = SrcInputFileData%NcIMUxn
   DstInputFileData%NcIMUyn = SrcInputFileData%NcIMUyn
   DstInputFileData%NcIMUzn = SrcInputFileData%NcIMUzn
   DstInputFileData%Twr2Shft = SrcInputFileData%Twr2Shft
   DstInputFileData%TowerHt = SrcInputFileData%TowerHt
   DstInputFileData%TowerBsHt = SrcInputFileData%TowerBsHt
   DstInputFileData%PtfmCMxt = SrcInputFileData%PtfmCMxt
   DstInputFileData%PtfmCMyt = SrcInputFileData%PtfmCMyt
   DstInputFileData%PtfmCMzt = SrcInputFileData%PtfmCMzt
   DstInputFileData%PtfmRefzt = SrcInputFileData%PtfmRefzt
   if (allocated(SrcInputFileData%TipMass)) then
      LB(1:1) = lbound(SrcInputFileData%TipMass)
      UB(1:1) = ubound(SrcInputFileData%TipMass)
      if (.not. allocated(DstInputFileData%TipMass)) then
         allocate(DstInputFileData%TipMass(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%TipMass.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%TipMass = SrcInputFileData%TipMass
   end if
   DstInputFileData%HubMass = SrcInputFileData%HubMass
   DstInputFileData%HubIner = SrcInputFileData%HubIner
   DstInputFileData%GenIner = SrcInputFileData%GenIner
   DstInputFileData%NacMass = SrcInputFileData%NacMass
   DstInputFileData%NacYIner = SrcInputFileData%NacYIner
   DstInputFileData%YawBrMass = SrcInputFileData%YawBrMass
   DstInputFileData%PtfmMass = SrcInputFileData%PtfmMass
   DstInputFileData%PtfmRIner = SrcInputFileData%PtfmRIner
   DstInputFileData%PtfmPIner = SrcInputFileData%PtfmPIner
   DstInputFileData%PtfmYIner = SrcInputFileData%PtfmYIner
   DstInputFileData%PtfmXYIner = SrcInputFileData%PtfmXYIner
   DstInputFileData%PtfmYZIner = SrcInputFileData%PtfmYZIner
   DstInputFileData%PtfmXZIner = SrcInputFileData%PtfmXZIner
   DstInputFileData%BldNodes = SrcInputFileData%BldNodes
   if (allocated(SrcInputFileData%InpBlMesh)) then
      LB(1:1) = lbound(SrcInputFileData%InpBlMesh)
      UB(1:1) = ubound(SrcInputFileData%InpBlMesh)
      if (.not. allocated(DstInputFileData%InpBlMesh)) then
         allocate(DstInputFileData%InpBlMesh(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%InpBlMesh.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call ED_CopyBladeMeshInputData(SrcInputFileData%InpBlMesh(i1), DstInputFileData%InpBlMesh(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcInputFileData%InpBl)) then
      LB(1:1) = lbound(SrcInputFileData%InpBl)
      UB(1:1) = ubound(SrcInputFileData%InpBl)
      if (.not. allocated(DstInputFileData%InpBl)) then
         allocate(DstInputFileData%InpBl(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%InpBl.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call ED_CopyBladeInputData(SrcInputFileData%InpBl(i1), DstInputFileData%InpBl(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstInputFileData%TeetMod = SrcInputFileData%TeetMod
   DstInputFileData%TeetDmpP = SrcInputFileData%TeetDmpP
   DstInputFileData%TeetDmp = SrcInputFileData%TeetDmp
   DstInputFileData%TeetCDmp = SrcInputFileData%TeetCDmp
   DstInputFileData%TeetSStP = SrcInputFileData%TeetSStP
   DstInputFileData%TeetHStP = SrcInputFileData%TeetHStP
   DstInputFileData%TeetSSSp = SrcInputFileData%TeetSSSp
   DstInputFileData%TeetHSSp = SrcInputFileData%TeetHSSp
   DstInputFileData%YawFrctMod = SrcInputFileData%YawFrctMod
   DstInputFileData%M_CD = SrcInputFileData%M_CD
   DstInputFileData%M_FCD = SrcInputFileData%M_FCD
   DstInputFileData%M_MCD = SrcInputFileData%M_MCD
   DstInputFileData%M_CSMAX = SrcInputFileData%M_CSMAX
   DstInputFileData%M_FCSMAX = SrcInputFileData%M_FCSMAX
   DstInputFileData%M_MCSMAX = SrcInputFileData%M_MCSMAX
   DstInputFileData%sig_v = SrcInputFileData%sig_v
   DstInputFileData%sig_v2 = SrcInputFileData%sig_v2
   DstInputFileData%OmgCut = SrcInputFileData%OmgCut
   DstInputFileData%GBoxEff = SrcInputFileData%GBoxEff
   DstInputFileData%GBRatio = SrcInputFileData%GBRatio
   DstInputFileData%DTTorSpr = SrcInputFileData%DTTorSpr
   DstInputFileData%DTTorDmp = SrcInputFileData%DTTorDmp
   DstInputFileData%Furling = SrcInputFileData%Furling
   DstInputFileData%TwrNodes = SrcInputFileData%TwrNodes
   DstInputFileData%SumPrint = SrcInputFileData%SumPrint
   DstInputFileData%OutFile = SrcInputFileData%OutFile
   DstInputFileData%TabDelim = SrcInputFileData%TabDelim
   DstInputFileData%OutFmt = SrcInputFileData%OutFmt
   DstInputFileData%Tstart = SrcInputFileData%Tstart
   DstInputFileData%DecFact = SrcInputFileData%DecFact
   DstInputFileData%NTwGages = SrcInputFileData%NTwGages
   DstInputFileData%TwrGagNd = SrcInputFileData%TwrGagNd
   DstInputFileData%NBlGages = SrcInputFileData%NBlGages
   DstInputFileData%BldGagNd = SrcInputFileData%BldGagNd
   DstInputFileData%NumOuts = SrcInputFileData%NumOuts
   if (allocated(SrcInputFileData%OutList)) then
      LB(1:1) = lbound(SrcInputFileData%OutList)
      UB(1:1) = ubound(SrcInputFileData%OutList)
      if (.not. allocated(DstInputFileData%OutList)) then
         allocate(DstInputFileData%OutList(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%OutList.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%OutList = SrcInputFileData%OutList
   end if
   DstInputFileData%NTwInpSt = SrcInputFileData%NTwInpSt
   DstInputFileData%TwrFADmp = SrcInputFileData%TwrFADmp
   DstInputFileData%TwrSSDmp = SrcInputFileData%TwrSSDmp
   DstInputFileData%FAStTunr = SrcInputFileData%FAStTunr
   DstInputFileData%SSStTunr = SrcInputFileData%SSStTunr
   if (allocated(SrcInputFileData%HtFract)) then
      LB(1:1) = lbound(SrcInputFileData%HtFract)
      UB(1:1) = ubound(SrcInputFileData%HtFract)
      if (.not. allocated(DstInputFileData%HtFract)) then
         allocate(DstInputFileData%HtFract(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%HtFract.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%HtFract = SrcInputFileData%HtFract
   end if
   if (allocated(SrcInputFileData%TMassDen)) then
      LB(1:1) = lbound(SrcInputFileData%TMassDen)
      UB(1:1) = ubound(SrcInputFileData%TMassDen)
      if (.not. allocated(DstInputFileData%TMassDen)) then
         allocate(DstInputFileData%TMassDen(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%TMassDen.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%TMassDen = SrcInputFileData%TMassDen
   end if
   if (allocated(SrcInputFileData%TwFAStif)) then
      LB(1:1) = lbound(SrcInputFileData%TwFAStif)
      UB(1:1) = ubound(SrcInputFileData%TwFAStif)
      if (.not. allocated(DstInputFileData%TwFAStif)) then
         allocate(DstInputFileData%TwFAStif(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%TwFAStif.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%TwFAStif = SrcInputFileData%TwFAStif
   end if
   if (allocated(SrcInputFileData%TwSSStif)) then
      LB(1:1) = lbound(SrcInputFileData%TwSSStif)
      UB(1:1) = ubound(SrcInputFileData%TwSSStif)
      if (.not. allocated(DstInputFileData%TwSSStif)) then
         allocate(DstInputFileData%TwSSStif(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%TwSSStif.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%TwSSStif = SrcInputFileData%TwSSStif
   end if
   if (allocated(SrcInputFileData%TwFAM1Sh)) then
      LB(1:1) = lbound(SrcInputFileData%TwFAM1Sh)
      UB(1:1) = ubound(SrcInputFileData%TwFAM1Sh)
      if (.not. allocated(DstInputFileData%TwFAM1Sh)) then
         allocate(DstInputFileData%TwFAM1Sh(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%TwFAM1Sh.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%TwFAM1Sh = SrcInputFileData%TwFAM1Sh
   end if
   if (allocated(SrcInputFileData%TwFAM2Sh)) then
      LB(1:1) = lbound(SrcInputFileData%TwFAM2Sh)
      UB(1:1) = ubound(SrcInputFileData%TwFAM2Sh)
      if (.not. allocated(DstInputFileData%TwFAM2Sh)) then
         allocate(DstInputFileData%TwFAM2Sh(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%TwFAM2Sh.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%TwFAM2Sh = SrcInputFileData%TwFAM2Sh
   end if
   if (allocated(SrcInputFileData%TwSSM1Sh)) then
      LB(1:1) = lbound(SrcInputFileData%TwSSM1Sh)
      UB(1:1) = ubound(SrcInputFileData%TwSSM1Sh)
      if (.not. allocated(DstInputFileData%TwSSM1Sh)) then
         allocate(DstInputFileData%TwSSM1Sh(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%TwSSM1Sh.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%TwSSM1Sh = SrcInputFileData%TwSSM1Sh
   end if
   if (allocated(SrcInputFileData%TwSSM2Sh)) then
      LB(1:1) = lbound(SrcInputFileData%TwSSM2Sh)
      UB(1:1) = ubound(SrcInputFileData%TwSSM2Sh)
      if (.not. allocated(DstInputFileData%TwSSM2Sh)) then
         allocate(DstInputFileData%TwSSM2Sh(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%TwSSM2Sh.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%TwSSM2Sh = SrcInputFileData%TwSSM2Sh
   end if
   DstInputFileData%RFrlDOF = SrcInputFileData%RFrlDOF
   DstInputFileData%TFrlDOF = SrcInputFileData%TFrlDOF
   DstInputFileData%RotFurl = SrcInputFileData%RotFurl
   DstInputFileData%TailFurl = SrcInputFileData%TailFurl
   DstInputFileData%Yaw2Shft = SrcInputFileData%Yaw2Shft
   DstInputFileData%ShftSkew = SrcInputFileData%ShftSkew
   DstInputFileData%RFrlCM_n = SrcInputFileData%RFrlCM_n
   DstInputFileData%BoomCM_n = SrcInputFileData%BoomCM_n
   DstInputFileData%TFinCM_n = SrcInputFileData%TFinCM_n
   DstInputFileData%RFrlPnt_n = SrcInputFileData%RFrlPnt_n
   DstInputFileData%RFrlSkew = SrcInputFileData%RFrlSkew
   DstInputFileData%RFrlTilt = SrcInputFileData%RFrlTilt
   DstInputFileData%TFrlPnt_n = SrcInputFileData%TFrlPnt_n
   DstInputFileData%TFrlSkew = SrcInputFileData%TFrlSkew
   DstInputFileData%TFrlTilt = SrcInputFileData%TFrlTilt
   DstInputFileData%RFrlMass = SrcInputFileData%RFrlMass
   DstInputFileData%BoomMass = SrcInputFileData%BoomMass
   DstInputFileData%TFinMass = SrcInputFileData%TFinMass
   DstInputFileData%RFrlIner = SrcInputFileData%RFrlIner
   DstInputFileData%TFrlIner = SrcInputFileData%TFrlIner
   DstInputFileData%RFrlMod = SrcInputFileData%RFrlMod
   DstInputFileData%RFrlSpr = SrcInputFileData%RFrlSpr
   DstInputFileData%RFrlDmp = SrcInputFileData%RFrlDmp
   DstInputFileData%RFrlUSSP = SrcInputFileData%RFrlUSSP
   DstInputFileData%RFrlDSSP = SrcInputFileData%RFrlDSSP
   DstInputFileData%RFrlUSSpr = SrcInputFileData%RFrlUSSpr
   DstInputFileData%RFrlDSSpr = SrcInputFileData%RFrlDSSpr
   DstInputFileData%RFrlUSDP = SrcInputFileData%RFrlUSDP
   DstInputFileData%RFrlDSDP = SrcInputFileData%RFrlDSDP
   DstInputFileData%RFrlUSDmp = SrcInputFileData%RFrlUSDmp
   DstInputFileData%RFrlDSDmp = SrcInputFileData%RFrlDSDmp
   DstInputFileData%TFrlMod = SrcInputFileData%TFrlMod
   DstInputFileData%TFrlSpr = SrcInputFileData%TFrlSpr
   DstInputFileData%TFrlDmp = SrcInputFileData%TFrlDmp
   DstInputFileData%TFrlUSSP = SrcInputFileData%TFrlUSSP
   DstInputFileData%TFrlDSSP = SrcInputFileData%TFrlDSSP
   DstInputFileData%TFrlUSSpr = SrcInputFileData%TFrlUSSpr
   DstInputFileData%TFrlDSSpr = SrcInputFileData%TFrlDSSpr
   DstInputFileData%TFrlUSDP = SrcInputFileData%TFrlUSDP
   DstInputFileData%TFrlDSDP = SrcInputFileData%TFrlDSDP
   DstInputFileData%TFrlUSDmp = SrcInputFileData%TFrlUSDmp
   DstInputFileData%TFrlDSDmp = SrcInputFileData%TFrlDSDmp
   DstInputFileData%method = SrcInputFileData%method
   DstInputFileData%BldNd_NumOuts = SrcInputFileData%BldNd_NumOuts
   if (allocated(SrcInputFileData%BldNd_OutList)) then
      LB(1:1) = lbound(SrcInputFileData%BldNd_OutList)
      UB(1:1) = ubound(SrcInputFileData%BldNd_OutList)
      if (.not. allocated(DstInputFileData%BldNd_OutList)) then
         allocate(DstInputFileData%BldNd_OutList(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%BldNd_OutList.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%BldNd_OutList = SrcInputFileData%BldNd_OutList
   end if
   DstInputFileData%BldNd_BlOutNd_Str = SrcInputFileData%BldNd_BlOutNd_Str
   DstInputFileData%BldNd_BladesOut = SrcInputFileData%BldNd_BladesOut
end subroutine

subroutine ED_DestroyInputFile(InputFileData, ErrStat, ErrMsg)
   type(ED_InputFile), intent(inout) :: InputFileData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ED_DestroyInputFile'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InputFileData%BlPitch)) then
      deallocate(InputFileData%BlPitch)
   end if
   if (allocated(InputFileData%PreCone)) then
      deallocate(InputFileData%PreCone)
   end if
   if (allocated(InputFileData%TipMass)) then
      deallocate(InputFileData%TipMass)
   end if
   if (allocated(InputFileData%InpBlMesh)) then
      LB(1:1) = lbound(InputFileData%InpBlMesh)
      UB(1:1) = ubound(InputFileData%InpBlMesh)
      do i1 = LB(1), UB(1)
         call ED_DestroyBladeMeshInputData(InputFileData%InpBlMesh(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InputFileData%InpBlMesh)
   end if
   if (allocated(InputFileData%InpBl)) then
      LB(1:1) = lbound(InputFileData%InpBl)
      UB(1:1) = ubound(InputFileData%InpBl)
      do i1 = LB(1), UB(1)
         call ED_DestroyBladeInputData(InputFileData%InpBl(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InputFileData%InpBl)
   end if
   if (allocated(InputFileData%OutList)) then
      deallocate(InputFileData%OutList)
   end if
   if (allocated(InputFileData%HtFract)) then
      deallocate(InputFileData%HtFract)
   end if
   if (allocated(InputFileData%TMassDen)) then
      deallocate(InputFileData%TMassDen)
   end if
   if (allocated(InputFileData%TwFAStif)) then
      deallocate(InputFileData%TwFAStif)
   end if
   if (allocated(InputFileData%TwSSStif)) then
      deallocate(InputFileData%TwSSStif)
   end if
   if (allocated(InputFileData%TwFAM1Sh)) then
      deallocate(InputFileData%TwFAM1Sh)
   end if
   if (allocated(InputFileData%TwFAM2Sh)) then
      deallocate(InputFileData%TwFAM2Sh)
   end if
   if (allocated(InputFileData%TwSSM1Sh)) then
      deallocate(InputFileData%TwSSM1Sh)
   end if
   if (allocated(InputFileData%TwSSM2Sh)) then
      deallocate(InputFileData%TwSSM2Sh)
   end if
   if (allocated(InputFileData%BldNd_OutList)) then
      deallocate(InputFileData%BldNd_OutList)
   end if
end subroutine

subroutine ED_PackInputFile(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ED_InputFile), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ED_PackInputFile'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DT)
   call RegPack(RF, InData%FlapDOF1)
   call RegPack(RF, InData%FlapDOF2)
   call RegPack(RF, InData%EdgeDOF)
   call RegPack(RF, InData%TeetDOF)
   call RegPack(RF, InData%DrTrDOF)
   call RegPack(RF, InData%GenDOF)
   call RegPack(RF, InData%YawDOF)
   call RegPack(RF, InData%TwFADOF1)
   call RegPack(RF, InData%TwFADOF2)
   call RegPack(RF, InData%TwSSDOF1)
   call RegPack(RF, InData%TwSSDOF2)
   call RegPack(RF, InData%PtfmSgDOF)
   call RegPack(RF, InData%PtfmSwDOF)
   call RegPack(RF, InData%PtfmHvDOF)
   call RegPack(RF, InData%PtfmRDOF)
   call RegPack(RF, InData%PtfmPDOF)
   call RegPack(RF, InData%PtfmYDOF)
   call RegPack(RF, InData%OoPDefl)
   call RegPack(RF, InData%IPDefl)
   call RegPackAlloc(RF, InData%BlPitch)
   call RegPack(RF, InData%TeetDefl)
   call RegPack(RF, InData%Azimuth)
   call RegPack(RF, InData%RotSpeed)
   call RegPack(RF, InData%NacYaw)
   call RegPack(RF, InData%TTDspFA)
   call RegPack(RF, InData%TTDspSS)
   call RegPack(RF, InData%PtfmSurge)
   call RegPack(RF, InData%PtfmSway)
   call RegPack(RF, InData%PtfmHeave)
   call RegPack(RF, InData%PtfmRoll)
   call RegPack(RF, InData%PtfmPitch)
   call RegPack(RF, InData%PtfmYaw)
   call RegPack(RF, InData%NumBl)
   call RegPack(RF, InData%TipRad)
   call RegPack(RF, InData%HubRad)
   call RegPackAlloc(RF, InData%PreCone)
   call RegPack(RF, InData%HubCM)
   call RegPack(RF, InData%UndSling)
   call RegPack(RF, InData%Delta3)
   call RegPack(RF, InData%AzimB1Up)
   call RegPack(RF, InData%OverHang)
   call RegPack(RF, InData%ShftGagL)
   call RegPack(RF, InData%ShftTilt)
   call RegPack(RF, InData%NacCMxn)
   call RegPack(RF, InData%NacCMyn)
   call RegPack(RF, InData%NacCMzn)
   call RegPack(RF, InData%NcIMUxn)
   call RegPack(RF, InData%NcIMUyn)
   call RegPack(RF, InData%NcIMUzn)
   call RegPack(RF, InData%Twr2Shft)
   call RegPack(RF, InData%TowerHt)
   call RegPack(RF, InData%TowerBsHt)
   call RegPack(RF, InData%PtfmCMxt)
   call RegPack(RF, InData%PtfmCMyt)
   call RegPack(RF, InData%PtfmCMzt)
   call RegPack(RF, InData%PtfmRefzt)
   call RegPackAlloc(RF, InData%TipMass)
   call RegPack(RF, InData%HubMass)
   call RegPack(RF, InData%HubIner)
   call RegPack(RF, InData%GenIner)
   call RegPack(RF, InData%NacMass)
   call RegPack(RF, InData%NacYIner)
   call RegPack(RF, InData%YawBrMass)
   call RegPack(RF, InData%PtfmMass)
   call RegPack(RF, InData%PtfmRIner)
   call RegPack(RF, InData%PtfmPIner)
   call RegPack(RF, InData%PtfmYIner)
   call RegPack(RF, InData%PtfmXYIner)
   call RegPack(RF, InData%PtfmYZIner)
   call RegPack(RF, InData%PtfmXZIner)
   call RegPack(RF, InData%BldNodes)
   call RegPack(RF, allocated(InData%InpBlMesh))
   if (allocated(InData%InpBlMesh)) then
      call RegPackBounds(RF, 1, lbound(InData%InpBlMesh), ubound(InData%InpBlMesh))
      LB(1:1) = lbound(InData%InpBlMesh)
      UB(1:1) = ubound(InData%InpBlMesh)
      do i1 = LB(1), UB(1)
         call ED_PackBladeMeshInputData(RF, InData%InpBlMesh(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%InpBl))
   if (allocated(InData%InpBl)) then
      call RegPackBounds(RF, 1, lbound(InData%InpBl), ubound(InData%InpBl))
      LB(1:1) = lbound(InData%InpBl)
      UB(1:1) = ubound(InData%InpBl)
      do i1 = LB(1), UB(1)
         call ED_PackBladeInputData(RF, InData%InpBl(i1)) 
      end do
   end if
   call RegPack(RF, InData%TeetMod)
   call RegPack(RF, InData%TeetDmpP)
   call RegPack(RF, InData%TeetDmp)
   call RegPack(RF, InData%TeetCDmp)
   call RegPack(RF, InData%TeetSStP)
   call RegPack(RF, InData%TeetHStP)
   call RegPack(RF, InData%TeetSSSp)
   call RegPack(RF, InData%TeetHSSp)
   call RegPack(RF, InData%YawFrctMod)
   call RegPack(RF, InData%M_CD)
   call RegPack(RF, InData%M_FCD)
   call RegPack(RF, InData%M_MCD)
   call RegPack(RF, InData%M_CSMAX)
   call RegPack(RF, InData%M_FCSMAX)
   call RegPack(RF, InData%M_MCSMAX)
   call RegPack(RF, InData%sig_v)
   call RegPack(RF, InData%sig_v2)
   call RegPack(RF, InData%OmgCut)
   call RegPack(RF, InData%GBoxEff)
   call RegPack(RF, InData%GBRatio)
   call RegPack(RF, InData%DTTorSpr)
   call RegPack(RF, InData%DTTorDmp)
   call RegPack(RF, InData%Furling)
   call RegPack(RF, InData%TwrNodes)
   call RegPack(RF, InData%SumPrint)
   call RegPack(RF, InData%OutFile)
   call RegPack(RF, InData%TabDelim)
   call RegPack(RF, InData%OutFmt)
   call RegPack(RF, InData%Tstart)
   call RegPack(RF, InData%DecFact)
   call RegPack(RF, InData%NTwGages)
   call RegPack(RF, InData%TwrGagNd)
   call RegPack(RF, InData%NBlGages)
   call RegPack(RF, InData%BldGagNd)
   call RegPack(RF, InData%NumOuts)
   call RegPackAlloc(RF, InData%OutList)
   call RegPack(RF, InData%NTwInpSt)
   call RegPack(RF, InData%TwrFADmp)
   call RegPack(RF, InData%TwrSSDmp)
   call RegPack(RF, InData%FAStTunr)
   call RegPack(RF, InData%SSStTunr)
   call RegPackAlloc(RF, InData%HtFract)
   call RegPackAlloc(RF, InData%TMassDen)
   call RegPackAlloc(RF, InData%TwFAStif)
   call RegPackAlloc(RF, InData%TwSSStif)
   call RegPackAlloc(RF, InData%TwFAM1Sh)
   call RegPackAlloc(RF, InData%TwFAM2Sh)
   call RegPackAlloc(RF, InData%TwSSM1Sh)
   call RegPackAlloc(RF, InData%TwSSM2Sh)
   call RegPack(RF, InData%RFrlDOF)
   call RegPack(RF, InData%TFrlDOF)
   call RegPack(RF, InData%RotFurl)
   call RegPack(RF, InData%TailFurl)
   call RegPack(RF, InData%Yaw2Shft)
   call RegPack(RF, InData%ShftSkew)
   call RegPack(RF, InData%RFrlCM_n)
   call RegPack(RF, InData%BoomCM_n)
   call RegPack(RF, InData%TFinCM_n)
   call RegPack(RF, InData%RFrlPnt_n)
   call RegPack(RF, InData%RFrlSkew)
   call RegPack(RF, InData%RFrlTilt)
   call RegPack(RF, InData%TFrlPnt_n)
   call RegPack(RF, InData%TFrlSkew)
   call RegPack(RF, InData%TFrlTilt)
   call RegPack(RF, InData%RFrlMass)
   call RegPack(RF, InData%BoomMass)
   call RegPack(RF, InData%TFinMass)
   call RegPack(RF, InData%RFrlIner)
   call RegPack(RF, InData%TFrlIner)
   call RegPack(RF, InData%RFrlMod)
   call RegPack(RF, InData%RFrlSpr)
   call RegPack(RF, InData%RFrlDmp)
   call RegPack(RF, InData%RFrlUSSP)
   call RegPack(RF, InData%RFrlDSSP)
   call RegPack(RF, InData%RFrlUSSpr)
   call RegPack(RF, InData%RFrlDSSpr)
   call RegPack(RF, InData%RFrlUSDP)
   call RegPack(RF, InData%RFrlDSDP)
   call RegPack(RF, InData%RFrlUSDmp)
   call RegPack(RF, InData%RFrlDSDmp)
   call RegPack(RF, InData%TFrlMod)
   call RegPack(RF, InData%TFrlSpr)
   call RegPack(RF, InData%TFrlDmp)
   call RegPack(RF, InData%TFrlUSSP)
   call RegPack(RF, InData%TFrlDSSP)
   call RegPack(RF, InData%TFrlUSSpr)
   call RegPack(RF, InData%TFrlDSSpr)
   call RegPack(RF, InData%TFrlUSDP)
   call RegPack(RF, InData%TFrlDSDP)
   call RegPack(RF, InData%TFrlUSDmp)
   call RegPack(RF, InData%TFrlDSDmp)
   call RegPack(RF, InData%method)
   call RegPack(RF, InData%BldNd_NumOuts)
   call RegPackAlloc(RF, InData%BldNd_OutList)
   call RegPack(RF, InData%BldNd_BlOutNd_Str)
   call RegPack(RF, InData%BldNd_BladesOut)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ED_UnPackInputFile(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ED_InputFile), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ED_UnPackInputFile'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FlapDOF1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FlapDOF2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%EdgeDOF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TeetDOF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DrTrDOF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GenDOF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawDOF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TwFADOF1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TwFADOF2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TwSSDOF1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TwSSDOF2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmSgDOF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmSwDOF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmHvDOF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmRDOF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmPDOF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmYDOF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OoPDefl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%IPDefl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BlPitch); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TeetDefl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Azimuth); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RotSpeed); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NacYaw); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TTDspFA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TTDspSS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmSurge); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmSway); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmHeave); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmRoll); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmPitch); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmYaw); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumBl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TipRad); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HubRad); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PreCone); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HubCM); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UndSling); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Delta3); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AzimB1Up); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OverHang); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ShftGagL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ShftTilt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NacCMxn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NacCMyn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NacCMzn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NcIMUxn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NcIMUyn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NcIMUzn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Twr2Shft); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TowerHt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TowerBsHt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmCMxt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmCMyt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmCMzt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmRefzt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TipMass); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HubMass); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HubIner); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GenIner); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NacMass); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NacYIner); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawBrMass); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmMass); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmRIner); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmPIner); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmYIner); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmXYIner); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmYZIner); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmXZIner); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BldNodes); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%InpBlMesh)) deallocate(OutData%InpBlMesh)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%InpBlMesh(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%InpBlMesh.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call ED_UnpackBladeMeshInputData(RF, OutData%InpBlMesh(i1)) ! InpBlMesh 
      end do
   end if
   if (allocated(OutData%InpBl)) deallocate(OutData%InpBl)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%InpBl(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%InpBl.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call ED_UnpackBladeInputData(RF, OutData%InpBl(i1)) ! InpBl 
      end do
   end if
   call RegUnpack(RF, OutData%TeetMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TeetDmpP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TeetDmp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TeetCDmp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TeetSStP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TeetHStP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TeetSSSp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TeetHSSp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawFrctMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%M_CD); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%M_FCD); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%M_MCD); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%M_CSMAX); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%M_FCSMAX); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%M_MCSMAX); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%sig_v); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%sig_v2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OmgCut); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GBoxEff); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GBRatio); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DTTorSpr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DTTorDmp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Furling); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TwrNodes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SumPrint); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TabDelim); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutFmt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Tstart); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DecFact); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NTwGages); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TwrGagNd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NBlGages); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BldGagNd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%OutList); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NTwInpSt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TwrFADmp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TwrSSDmp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FAStTunr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SSStTunr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%HtFract); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TMassDen); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TwFAStif); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TwSSStif); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TwFAM1Sh); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TwFAM2Sh); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TwSSM1Sh); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TwSSM2Sh); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RFrlDOF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFrlDOF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RotFurl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TailFurl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Yaw2Shft); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ShftSkew); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RFrlCM_n); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BoomCM_n); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFinCM_n); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RFrlPnt_n); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RFrlSkew); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RFrlTilt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFrlPnt_n); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFrlSkew); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFrlTilt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RFrlMass); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BoomMass); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFinMass); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RFrlIner); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFrlIner); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RFrlMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RFrlSpr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RFrlDmp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RFrlUSSP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RFrlDSSP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RFrlUSSpr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RFrlDSSpr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RFrlUSDP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RFrlDSDP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RFrlUSDmp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RFrlDSDmp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFrlMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFrlSpr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFrlDmp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFrlUSSP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFrlDSSP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFrlUSSpr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFrlDSSpr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFrlUSDP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFrlDSDP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFrlUSDmp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFrlDSDmp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%method); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BldNd_NumOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BldNd_OutList); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BldNd_BlOutNd_Str); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BldNd_BladesOut); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ED_CopyCoordSys(SrcCoordSysData, DstCoordSysData, CtrlCode, ErrStat, ErrMsg)
   type(ED_CoordSys), intent(in) :: SrcCoordSysData
   type(ED_CoordSys), intent(inout) :: DstCoordSysData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'ED_CopyCoordSys'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstCoordSysData%alpha1 = SrcCoordSysData%alpha1
   DstCoordSysData%alpha2 = SrcCoordSysData%alpha2
   DstCoordSysData%alpha3 = SrcCoordSysData%alpha3
   DstCoordSysData%beta1 = SrcCoordSysData%beta1
   DstCoordSysData%beta2 = SrcCoordSysData%beta2
   DstCoordSysData%beta3 = SrcCoordSysData%beta3
   DstCoordSysData%a1 = SrcCoordSysData%a1
   DstCoordSysData%a2 = SrcCoordSysData%a2
   DstCoordSysData%a3 = SrcCoordSysData%a3
   DstCoordSysData%b1 = SrcCoordSysData%b1
   DstCoordSysData%b2 = SrcCoordSysData%b2
   DstCoordSysData%b3 = SrcCoordSysData%b3
   DstCoordSysData%c1 = SrcCoordSysData%c1
   DstCoordSysData%c2 = SrcCoordSysData%c2
   DstCoordSysData%c3 = SrcCoordSysData%c3
   DstCoordSysData%d1 = SrcCoordSysData%d1
   DstCoordSysData%d2 = SrcCoordSysData%d2
   DstCoordSysData%d3 = SrcCoordSysData%d3
   DstCoordSysData%e1 = SrcCoordSysData%e1
   DstCoordSysData%e2 = SrcCoordSysData%e2
   DstCoordSysData%e3 = SrcCoordSysData%e3
   DstCoordSysData%f1 = SrcCoordSysData%f1
   DstCoordSysData%f2 = SrcCoordSysData%f2
   DstCoordSysData%f3 = SrcCoordSysData%f3
   DstCoordSysData%g1 = SrcCoordSysData%g1
   DstCoordSysData%g2 = SrcCoordSysData%g2
   DstCoordSysData%g3 = SrcCoordSysData%g3
   if (allocated(SrcCoordSysData%i1)) then
      LB(1:2) = lbound(SrcCoordSysData%i1)
      UB(1:2) = ubound(SrcCoordSysData%i1)
      if (.not. allocated(DstCoordSysData%i1)) then
         allocate(DstCoordSysData%i1(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstCoordSysData%i1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstCoordSysData%i1 = SrcCoordSysData%i1
   end if
   if (allocated(SrcCoordSysData%i2)) then
      LB(1:2) = lbound(SrcCoordSysData%i2)
      UB(1:2) = ubound(SrcCoordSysData%i2)
      if (.not. allocated(DstCoordSysData%i2)) then
         allocate(DstCoordSysData%i2(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstCoordSysData%i2.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstCoordSysData%i2 = SrcCoordSysData%i2
   end if
   if (allocated(SrcCoordSysData%i3)) then
      LB(1:2) = lbound(SrcCoordSysData%i3)
      UB(1:2) = ubound(SrcCoordSysData%i3)
      if (.not. allocated(DstCoordSysData%i3)) then
         allocate(DstCoordSysData%i3(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstCoordSysData%i3.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstCoordSysData%i3 = SrcCoordSysData%i3
   end if
   if (allocated(SrcCoordSysData%j1)) then
      LB(1:2) = lbound(SrcCoordSysData%j1)
      UB(1:2) = ubound(SrcCoordSysData%j1)
      if (.not. allocated(DstCoordSysData%j1)) then
         allocate(DstCoordSysData%j1(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstCoordSysData%j1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstCoordSysData%j1 = SrcCoordSysData%j1
   end if
   if (allocated(SrcCoordSysData%j2)) then
      LB(1:2) = lbound(SrcCoordSysData%j2)
      UB(1:2) = ubound(SrcCoordSysData%j2)
      if (.not. allocated(DstCoordSysData%j2)) then
         allocate(DstCoordSysData%j2(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstCoordSysData%j2.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstCoordSysData%j2 = SrcCoordSysData%j2
   end if
   if (allocated(SrcCoordSysData%j3)) then
      LB(1:2) = lbound(SrcCoordSysData%j3)
      UB(1:2) = ubound(SrcCoordSysData%j3)
      if (.not. allocated(DstCoordSysData%j3)) then
         allocate(DstCoordSysData%j3(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstCoordSysData%j3.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstCoordSysData%j3 = SrcCoordSysData%j3
   end if
   if (allocated(SrcCoordSysData%m1)) then
      LB(1:3) = lbound(SrcCoordSysData%m1)
      UB(1:3) = ubound(SrcCoordSysData%m1)
      if (.not. allocated(DstCoordSysData%m1)) then
         allocate(DstCoordSysData%m1(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstCoordSysData%m1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstCoordSysData%m1 = SrcCoordSysData%m1
   end if
   if (allocated(SrcCoordSysData%m2)) then
      LB(1:3) = lbound(SrcCoordSysData%m2)
      UB(1:3) = ubound(SrcCoordSysData%m2)
      if (.not. allocated(DstCoordSysData%m2)) then
         allocate(DstCoordSysData%m2(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstCoordSysData%m2.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstCoordSysData%m2 = SrcCoordSysData%m2
   end if
   if (allocated(SrcCoordSysData%m3)) then
      LB(1:3) = lbound(SrcCoordSysData%m3)
      UB(1:3) = ubound(SrcCoordSysData%m3)
      if (.not. allocated(DstCoordSysData%m3)) then
         allocate(DstCoordSysData%m3(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstCoordSysData%m3.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstCoordSysData%m3 = SrcCoordSysData%m3
   end if
   if (allocated(SrcCoordSysData%n1)) then
      LB(1:3) = lbound(SrcCoordSysData%n1)
      UB(1:3) = ubound(SrcCoordSysData%n1)
      if (.not. allocated(DstCoordSysData%n1)) then
         allocate(DstCoordSysData%n1(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstCoordSysData%n1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstCoordSysData%n1 = SrcCoordSysData%n1
   end if
   if (allocated(SrcCoordSysData%n2)) then
      LB(1:3) = lbound(SrcCoordSysData%n2)
      UB(1:3) = ubound(SrcCoordSysData%n2)
      if (.not. allocated(DstCoordSysData%n2)) then
         allocate(DstCoordSysData%n2(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstCoordSysData%n2.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstCoordSysData%n2 = SrcCoordSysData%n2
   end if
   if (allocated(SrcCoordSysData%n3)) then
      LB(1:3) = lbound(SrcCoordSysData%n3)
      UB(1:3) = ubound(SrcCoordSysData%n3)
      if (.not. allocated(DstCoordSysData%n3)) then
         allocate(DstCoordSysData%n3(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstCoordSysData%n3.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstCoordSysData%n3 = SrcCoordSysData%n3
   end if
   DstCoordSysData%rf1 = SrcCoordSysData%rf1
   DstCoordSysData%rf2 = SrcCoordSysData%rf2
   DstCoordSysData%rf3 = SrcCoordSysData%rf3
   DstCoordSysData%rfa = SrcCoordSysData%rfa
   if (allocated(SrcCoordSysData%t1)) then
      LB(1:2) = lbound(SrcCoordSysData%t1)
      UB(1:2) = ubound(SrcCoordSysData%t1)
      if (.not. allocated(DstCoordSysData%t1)) then
         allocate(DstCoordSysData%t1(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstCoordSysData%t1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstCoordSysData%t1 = SrcCoordSysData%t1
   end if
   if (allocated(SrcCoordSysData%t2)) then
      LB(1:2) = lbound(SrcCoordSysData%t2)
      UB(1:2) = ubound(SrcCoordSysData%t2)
      if (.not. allocated(DstCoordSysData%t2)) then
         allocate(DstCoordSysData%t2(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstCoordSysData%t2.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstCoordSysData%t2 = SrcCoordSysData%t2
   end if
   if (allocated(SrcCoordSysData%t3)) then
      LB(1:2) = lbound(SrcCoordSysData%t3)
      UB(1:2) = ubound(SrcCoordSysData%t3)
      if (.not. allocated(DstCoordSysData%t3)) then
         allocate(DstCoordSysData%t3(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstCoordSysData%t3.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstCoordSysData%t3 = SrcCoordSysData%t3
   end if
   if (allocated(SrcCoordSysData%te1)) then
      LB(1:3) = lbound(SrcCoordSysData%te1)
      UB(1:3) = ubound(SrcCoordSysData%te1)
      if (.not. allocated(DstCoordSysData%te1)) then
         allocate(DstCoordSysData%te1(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstCoordSysData%te1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstCoordSysData%te1 = SrcCoordSysData%te1
   end if
   if (allocated(SrcCoordSysData%te2)) then
      LB(1:3) = lbound(SrcCoordSysData%te2)
      UB(1:3) = ubound(SrcCoordSysData%te2)
      if (.not. allocated(DstCoordSysData%te2)) then
         allocate(DstCoordSysData%te2(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstCoordSysData%te2.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstCoordSysData%te2 = SrcCoordSysData%te2
   end if
   if (allocated(SrcCoordSysData%te3)) then
      LB(1:3) = lbound(SrcCoordSysData%te3)
      UB(1:3) = ubound(SrcCoordSysData%te3)
      if (.not. allocated(DstCoordSysData%te3)) then
         allocate(DstCoordSysData%te3(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstCoordSysData%te3.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstCoordSysData%te3 = SrcCoordSysData%te3
   end if
   DstCoordSysData%tf1 = SrcCoordSysData%tf1
   DstCoordSysData%tf2 = SrcCoordSysData%tf2
   DstCoordSysData%tf3 = SrcCoordSysData%tf3
   DstCoordSysData%tfa = SrcCoordSysData%tfa
   DstCoordSysData%z1 = SrcCoordSysData%z1
   DstCoordSysData%z2 = SrcCoordSysData%z2
   DstCoordSysData%z3 = SrcCoordSysData%z3
end subroutine

subroutine ED_DestroyCoordSys(CoordSysData, ErrStat, ErrMsg)
   type(ED_CoordSys), intent(inout) :: CoordSysData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ED_DestroyCoordSys'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(CoordSysData%i1)) then
      deallocate(CoordSysData%i1)
   end if
   if (allocated(CoordSysData%i2)) then
      deallocate(CoordSysData%i2)
   end if
   if (allocated(CoordSysData%i3)) then
      deallocate(CoordSysData%i3)
   end if
   if (allocated(CoordSysData%j1)) then
      deallocate(CoordSysData%j1)
   end if
   if (allocated(CoordSysData%j2)) then
      deallocate(CoordSysData%j2)
   end if
   if (allocated(CoordSysData%j3)) then
      deallocate(CoordSysData%j3)
   end if
   if (allocated(CoordSysData%m1)) then
      deallocate(CoordSysData%m1)
   end if
   if (allocated(CoordSysData%m2)) then
      deallocate(CoordSysData%m2)
   end if
   if (allocated(CoordSysData%m3)) then
      deallocate(CoordSysData%m3)
   end if
   if (allocated(CoordSysData%n1)) then
      deallocate(CoordSysData%n1)
   end if
   if (allocated(CoordSysData%n2)) then
      deallocate(CoordSysData%n2)
   end if
   if (allocated(CoordSysData%n3)) then
      deallocate(CoordSysData%n3)
   end if
   if (allocated(CoordSysData%t1)) then
      deallocate(CoordSysData%t1)
   end if
   if (allocated(CoordSysData%t2)) then
      deallocate(CoordSysData%t2)
   end if
   if (allocated(CoordSysData%t3)) then
      deallocate(CoordSysData%t3)
   end if
   if (allocated(CoordSysData%te1)) then
      deallocate(CoordSysData%te1)
   end if
   if (allocated(CoordSysData%te2)) then
      deallocate(CoordSysData%te2)
   end if
   if (allocated(CoordSysData%te3)) then
      deallocate(CoordSysData%te3)
   end if
end subroutine

subroutine ED_PackCoordSys(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ED_CoordSys), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ED_PackCoordSys'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%alpha1)
   call RegPack(RF, InData%alpha2)
   call RegPack(RF, InData%alpha3)
   call RegPack(RF, InData%beta1)
   call RegPack(RF, InData%beta2)
   call RegPack(RF, InData%beta3)
   call RegPack(RF, InData%a1)
   call RegPack(RF, InData%a2)
   call RegPack(RF, InData%a3)
   call RegPack(RF, InData%b1)
   call RegPack(RF, InData%b2)
   call RegPack(RF, InData%b3)
   call RegPack(RF, InData%c1)
   call RegPack(RF, InData%c2)
   call RegPack(RF, InData%c3)
   call RegPack(RF, InData%d1)
   call RegPack(RF, InData%d2)
   call RegPack(RF, InData%d3)
   call RegPack(RF, InData%e1)
   call RegPack(RF, InData%e2)
   call RegPack(RF, InData%e3)
   call RegPack(RF, InData%f1)
   call RegPack(RF, InData%f2)
   call RegPack(RF, InData%f3)
   call RegPack(RF, InData%g1)
   call RegPack(RF, InData%g2)
   call RegPack(RF, InData%g3)
   call RegPackAlloc(RF, InData%i1)
   call RegPackAlloc(RF, InData%i2)
   call RegPackAlloc(RF, InData%i3)
   call RegPackAlloc(RF, InData%j1)
   call RegPackAlloc(RF, InData%j2)
   call RegPackAlloc(RF, InData%j3)
   call RegPackAlloc(RF, InData%m1)
   call RegPackAlloc(RF, InData%m2)
   call RegPackAlloc(RF, InData%m3)
   call RegPackAlloc(RF, InData%n1)
   call RegPackAlloc(RF, InData%n2)
   call RegPackAlloc(RF, InData%n3)
   call RegPack(RF, InData%rf1)
   call RegPack(RF, InData%rf2)
   call RegPack(RF, InData%rf3)
   call RegPack(RF, InData%rfa)
   call RegPackAlloc(RF, InData%t1)
   call RegPackAlloc(RF, InData%t2)
   call RegPackAlloc(RF, InData%t3)
   call RegPackAlloc(RF, InData%te1)
   call RegPackAlloc(RF, InData%te2)
   call RegPackAlloc(RF, InData%te3)
   call RegPack(RF, InData%tf1)
   call RegPack(RF, InData%tf2)
   call RegPack(RF, InData%tf3)
   call RegPack(RF, InData%tfa)
   call RegPack(RF, InData%z1)
   call RegPack(RF, InData%z2)
   call RegPack(RF, InData%z3)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ED_UnPackCoordSys(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ED_CoordSys), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ED_UnPackCoordSys'
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%alpha1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%alpha2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%alpha3); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%beta1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%beta2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%beta3); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%a1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%a2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%a3); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%b1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%b2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%b3); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%c1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%c2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%c3); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%d1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%d2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%d3); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%e1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%e2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%e3); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%f1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%f2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%f3); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%g1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%g2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%g3); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%i1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%i2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%i3); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%j1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%j2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%j3); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%m1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%m2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%m3); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%n1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%n2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%n3); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rf1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rf2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rf3); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rfa); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%t1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%t2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%t3); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%te1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%te2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%te3); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%tf1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%tf2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%tf3); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%tfa); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%z1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%z2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%z3); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ED_CopyActiveDOFs(SrcActiveDOFsData, DstActiveDOFsData, CtrlCode, ErrStat, ErrMsg)
   type(ED_ActiveDOFs), intent(in) :: SrcActiveDOFsData
   type(ED_ActiveDOFs), intent(inout) :: DstActiveDOFsData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'ED_CopyActiveDOFs'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstActiveDOFsData%NActvDOF = SrcActiveDOFsData%NActvDOF
   DstActiveDOFsData%NPCE = SrcActiveDOFsData%NPCE
   DstActiveDOFsData%NPDE = SrcActiveDOFsData%NPDE
   DstActiveDOFsData%NPIE = SrcActiveDOFsData%NPIE
   DstActiveDOFsData%NPTE = SrcActiveDOFsData%NPTE
   DstActiveDOFsData%NPTTE = SrcActiveDOFsData%NPTTE
   if (allocated(SrcActiveDOFsData%NPSBE)) then
      LB(1:1) = lbound(SrcActiveDOFsData%NPSBE)
      UB(1:1) = ubound(SrcActiveDOFsData%NPSBE)
      if (.not. allocated(DstActiveDOFsData%NPSBE)) then
         allocate(DstActiveDOFsData%NPSBE(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstActiveDOFsData%NPSBE.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstActiveDOFsData%NPSBE = SrcActiveDOFsData%NPSBE
   end if
   if (allocated(SrcActiveDOFsData%NPSE)) then
      LB(1:1) = lbound(SrcActiveDOFsData%NPSE)
      UB(1:1) = ubound(SrcActiveDOFsData%NPSE)
      if (.not. allocated(DstActiveDOFsData%NPSE)) then
         allocate(DstActiveDOFsData%NPSE(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstActiveDOFsData%NPSE.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstActiveDOFsData%NPSE = SrcActiveDOFsData%NPSE
   end if
   DstActiveDOFsData%NPUE = SrcActiveDOFsData%NPUE
   DstActiveDOFsData%NPYE = SrcActiveDOFsData%NPYE
   if (allocated(SrcActiveDOFsData%PCE)) then
      LB(1:1) = lbound(SrcActiveDOFsData%PCE)
      UB(1:1) = ubound(SrcActiveDOFsData%PCE)
      if (.not. allocated(DstActiveDOFsData%PCE)) then
         allocate(DstActiveDOFsData%PCE(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstActiveDOFsData%PCE.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstActiveDOFsData%PCE = SrcActiveDOFsData%PCE
   end if
   if (allocated(SrcActiveDOFsData%PDE)) then
      LB(1:1) = lbound(SrcActiveDOFsData%PDE)
      UB(1:1) = ubound(SrcActiveDOFsData%PDE)
      if (.not. allocated(DstActiveDOFsData%PDE)) then
         allocate(DstActiveDOFsData%PDE(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstActiveDOFsData%PDE.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstActiveDOFsData%PDE = SrcActiveDOFsData%PDE
   end if
   if (allocated(SrcActiveDOFsData%PIE)) then
      LB(1:1) = lbound(SrcActiveDOFsData%PIE)
      UB(1:1) = ubound(SrcActiveDOFsData%PIE)
      if (.not. allocated(DstActiveDOFsData%PIE)) then
         allocate(DstActiveDOFsData%PIE(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstActiveDOFsData%PIE.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstActiveDOFsData%PIE = SrcActiveDOFsData%PIE
   end if
   if (allocated(SrcActiveDOFsData%PTE)) then
      LB(1:1) = lbound(SrcActiveDOFsData%PTE)
      UB(1:1) = ubound(SrcActiveDOFsData%PTE)
      if (.not. allocated(DstActiveDOFsData%PTE)) then
         allocate(DstActiveDOFsData%PTE(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstActiveDOFsData%PTE.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstActiveDOFsData%PTE = SrcActiveDOFsData%PTE
   end if
   if (allocated(SrcActiveDOFsData%PTTE)) then
      LB(1:1) = lbound(SrcActiveDOFsData%PTTE)
      UB(1:1) = ubound(SrcActiveDOFsData%PTTE)
      if (.not. allocated(DstActiveDOFsData%PTTE)) then
         allocate(DstActiveDOFsData%PTTE(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstActiveDOFsData%PTTE.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstActiveDOFsData%PTTE = SrcActiveDOFsData%PTTE
   end if
   if (allocated(SrcActiveDOFsData%PS)) then
      LB(1:1) = lbound(SrcActiveDOFsData%PS)
      UB(1:1) = ubound(SrcActiveDOFsData%PS)
      if (.not. allocated(DstActiveDOFsData%PS)) then
         allocate(DstActiveDOFsData%PS(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstActiveDOFsData%PS.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstActiveDOFsData%PS = SrcActiveDOFsData%PS
   end if
   if (allocated(SrcActiveDOFsData%PSBE)) then
      LB(1:2) = lbound(SrcActiveDOFsData%PSBE)
      UB(1:2) = ubound(SrcActiveDOFsData%PSBE)
      if (.not. allocated(DstActiveDOFsData%PSBE)) then
         allocate(DstActiveDOFsData%PSBE(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstActiveDOFsData%PSBE.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstActiveDOFsData%PSBE = SrcActiveDOFsData%PSBE
   end if
   if (allocated(SrcActiveDOFsData%PSE)) then
      LB(1:2) = lbound(SrcActiveDOFsData%PSE)
      UB(1:2) = ubound(SrcActiveDOFsData%PSE)
      if (.not. allocated(DstActiveDOFsData%PSE)) then
         allocate(DstActiveDOFsData%PSE(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstActiveDOFsData%PSE.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstActiveDOFsData%PSE = SrcActiveDOFsData%PSE
   end if
   if (allocated(SrcActiveDOFsData%PUE)) then
      LB(1:1) = lbound(SrcActiveDOFsData%PUE)
      UB(1:1) = ubound(SrcActiveDOFsData%PUE)
      if (.not. allocated(DstActiveDOFsData%PUE)) then
         allocate(DstActiveDOFsData%PUE(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstActiveDOFsData%PUE.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstActiveDOFsData%PUE = SrcActiveDOFsData%PUE
   end if
   if (allocated(SrcActiveDOFsData%PYE)) then
      LB(1:1) = lbound(SrcActiveDOFsData%PYE)
      UB(1:1) = ubound(SrcActiveDOFsData%PYE)
      if (.not. allocated(DstActiveDOFsData%PYE)) then
         allocate(DstActiveDOFsData%PYE(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstActiveDOFsData%PYE.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstActiveDOFsData%PYE = SrcActiveDOFsData%PYE
   end if
   if (allocated(SrcActiveDOFsData%SrtPS)) then
      LB(1:1) = lbound(SrcActiveDOFsData%SrtPS)
      UB(1:1) = ubound(SrcActiveDOFsData%SrtPS)
      if (.not. allocated(DstActiveDOFsData%SrtPS)) then
         allocate(DstActiveDOFsData%SrtPS(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstActiveDOFsData%SrtPS.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstActiveDOFsData%SrtPS = SrcActiveDOFsData%SrtPS
   end if
   if (allocated(SrcActiveDOFsData%SrtPSNAUG)) then
      LB(1:1) = lbound(SrcActiveDOFsData%SrtPSNAUG)
      UB(1:1) = ubound(SrcActiveDOFsData%SrtPSNAUG)
      if (.not. allocated(DstActiveDOFsData%SrtPSNAUG)) then
         allocate(DstActiveDOFsData%SrtPSNAUG(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstActiveDOFsData%SrtPSNAUG.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstActiveDOFsData%SrtPSNAUG = SrcActiveDOFsData%SrtPSNAUG
   end if
   if (allocated(SrcActiveDOFsData%Diag)) then
      LB(1:1) = lbound(SrcActiveDOFsData%Diag)
      UB(1:1) = ubound(SrcActiveDOFsData%Diag)
      if (.not. allocated(DstActiveDOFsData%Diag)) then
         allocate(DstActiveDOFsData%Diag(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstActiveDOFsData%Diag.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstActiveDOFsData%Diag = SrcActiveDOFsData%Diag
   end if
end subroutine

subroutine ED_DestroyActiveDOFs(ActiveDOFsData, ErrStat, ErrMsg)
   type(ED_ActiveDOFs), intent(inout) :: ActiveDOFsData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ED_DestroyActiveDOFs'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ActiveDOFsData%NPSBE)) then
      deallocate(ActiveDOFsData%NPSBE)
   end if
   if (allocated(ActiveDOFsData%NPSE)) then
      deallocate(ActiveDOFsData%NPSE)
   end if
   if (allocated(ActiveDOFsData%PCE)) then
      deallocate(ActiveDOFsData%PCE)
   end if
   if (allocated(ActiveDOFsData%PDE)) then
      deallocate(ActiveDOFsData%PDE)
   end if
   if (allocated(ActiveDOFsData%PIE)) then
      deallocate(ActiveDOFsData%PIE)
   end if
   if (allocated(ActiveDOFsData%PTE)) then
      deallocate(ActiveDOFsData%PTE)
   end if
   if (allocated(ActiveDOFsData%PTTE)) then
      deallocate(ActiveDOFsData%PTTE)
   end if
   if (allocated(ActiveDOFsData%PS)) then
      deallocate(ActiveDOFsData%PS)
   end if
   if (allocated(ActiveDOFsData%PSBE)) then
      deallocate(ActiveDOFsData%PSBE)
   end if
   if (allocated(ActiveDOFsData%PSE)) then
      deallocate(ActiveDOFsData%PSE)
   end if
   if (allocated(ActiveDOFsData%PUE)) then
      deallocate(ActiveDOFsData%PUE)
   end if
   if (allocated(ActiveDOFsData%PYE)) then
      deallocate(ActiveDOFsData%PYE)
   end if
   if (allocated(ActiveDOFsData%SrtPS)) then
      deallocate(ActiveDOFsData%SrtPS)
   end if
   if (allocated(ActiveDOFsData%SrtPSNAUG)) then
      deallocate(ActiveDOFsData%SrtPSNAUG)
   end if
   if (allocated(ActiveDOFsData%Diag)) then
      deallocate(ActiveDOFsData%Diag)
   end if
end subroutine

subroutine ED_PackActiveDOFs(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ED_ActiveDOFs), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ED_PackActiveDOFs'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%NActvDOF)
   call RegPack(RF, InData%NPCE)
   call RegPack(RF, InData%NPDE)
   call RegPack(RF, InData%NPIE)
   call RegPack(RF, InData%NPTE)
   call RegPack(RF, InData%NPTTE)
   call RegPackAlloc(RF, InData%NPSBE)
   call RegPackAlloc(RF, InData%NPSE)
   call RegPack(RF, InData%NPUE)
   call RegPack(RF, InData%NPYE)
   call RegPackAlloc(RF, InData%PCE)
   call RegPackAlloc(RF, InData%PDE)
   call RegPackAlloc(RF, InData%PIE)
   call RegPackAlloc(RF, InData%PTE)
   call RegPackAlloc(RF, InData%PTTE)
   call RegPackAlloc(RF, InData%PS)
   call RegPackAlloc(RF, InData%PSBE)
   call RegPackAlloc(RF, InData%PSE)
   call RegPackAlloc(RF, InData%PUE)
   call RegPackAlloc(RF, InData%PYE)
   call RegPackAlloc(RF, InData%SrtPS)
   call RegPackAlloc(RF, InData%SrtPSNAUG)
   call RegPackAlloc(RF, InData%Diag)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ED_UnPackActiveDOFs(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ED_ActiveDOFs), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ED_UnPackActiveDOFs'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%NActvDOF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NPCE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NPDE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NPIE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NPTE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NPTTE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%NPSBE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%NPSE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NPUE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NPYE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PCE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PDE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PIE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PTE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PTTE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PSBE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PSE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PUE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PYE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%SrtPS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%SrtPSNAUG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Diag); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ED_CopyRtHndSide(SrcRtHndSideData, DstRtHndSideData, CtrlCode, ErrStat, ErrMsg)
   type(ED_RtHndSide), intent(in) :: SrcRtHndSideData
   type(ED_RtHndSide), intent(inout) :: DstRtHndSideData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(5), UB(5)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'ED_CopyRtHndSide'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstRtHndSideData%rO = SrcRtHndSideData%rO
   if (allocated(SrcRtHndSideData%rQS)) then
      LB(1:3) = lbound(SrcRtHndSideData%rQS)
      UB(1:3) = ubound(SrcRtHndSideData%rQS)
      if (.not. allocated(DstRtHndSideData%rQS)) then
         allocate(DstRtHndSideData%rQS(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%rQS.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%rQS = SrcRtHndSideData%rQS
   end if
   if (allocated(SrcRtHndSideData%rS)) then
      LB(1:3) = lbound(SrcRtHndSideData%rS)
      UB(1:3) = ubound(SrcRtHndSideData%rS)
      if (.not. allocated(DstRtHndSideData%rS)) then
         allocate(DstRtHndSideData%rS(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%rS.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%rS = SrcRtHndSideData%rS
   end if
   if (allocated(SrcRtHndSideData%rS0S)) then
      LB(1:3) = lbound(SrcRtHndSideData%rS0S)
      UB(1:3) = ubound(SrcRtHndSideData%rS0S)
      if (.not. allocated(DstRtHndSideData%rS0S)) then
         allocate(DstRtHndSideData%rS0S(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%rS0S.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%rS0S = SrcRtHndSideData%rS0S
   end if
   if (allocated(SrcRtHndSideData%rT)) then
      LB(1:2) = lbound(SrcRtHndSideData%rT)
      UB(1:2) = ubound(SrcRtHndSideData%rT)
      if (.not. allocated(DstRtHndSideData%rT)) then
         allocate(DstRtHndSideData%rT(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%rT.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%rT = SrcRtHndSideData%rT
   end if
   DstRtHndSideData%rT0O = SrcRtHndSideData%rT0O
   if (allocated(SrcRtHndSideData%rT0T)) then
      LB(1:2) = lbound(SrcRtHndSideData%rT0T)
      UB(1:2) = ubound(SrcRtHndSideData%rT0T)
      if (.not. allocated(DstRtHndSideData%rT0T)) then
         allocate(DstRtHndSideData%rT0T(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%rT0T.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%rT0T = SrcRtHndSideData%rT0T
   end if
   DstRtHndSideData%rZ = SrcRtHndSideData%rZ
   DstRtHndSideData%rZO = SrcRtHndSideData%rZO
   if (allocated(SrcRtHndSideData%rZT)) then
      LB(1:2) = lbound(SrcRtHndSideData%rZT)
      UB(1:2) = ubound(SrcRtHndSideData%rZT)
      if (.not. allocated(DstRtHndSideData%rZT)) then
         allocate(DstRtHndSideData%rZT(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%rZT.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%rZT = SrcRtHndSideData%rZT
   end if
   DstRtHndSideData%rPQ = SrcRtHndSideData%rPQ
   DstRtHndSideData%rP = SrcRtHndSideData%rP
   DstRtHndSideData%rV = SrcRtHndSideData%rV
   DstRtHndSideData%rJ = SrcRtHndSideData%rJ
   DstRtHndSideData%rZY = SrcRtHndSideData%rZY
   DstRtHndSideData%rOU = SrcRtHndSideData%rOU
   DstRtHndSideData%rOV = SrcRtHndSideData%rOV
   DstRtHndSideData%rVD = SrcRtHndSideData%rVD
   DstRtHndSideData%rOW = SrcRtHndSideData%rOW
   DstRtHndSideData%rPC = SrcRtHndSideData%rPC
   if (allocated(SrcRtHndSideData%rPS0)) then
      LB(1:2) = lbound(SrcRtHndSideData%rPS0)
      UB(1:2) = ubound(SrcRtHndSideData%rPS0)
      if (.not. allocated(DstRtHndSideData%rPS0)) then
         allocate(DstRtHndSideData%rPS0(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%rPS0.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%rPS0 = SrcRtHndSideData%rPS0
   end if
   DstRtHndSideData%rQ = SrcRtHndSideData%rQ
   DstRtHndSideData%rQC = SrcRtHndSideData%rQC
   DstRtHndSideData%rVIMU = SrcRtHndSideData%rVIMU
   DstRtHndSideData%rVP = SrcRtHndSideData%rVP
   DstRtHndSideData%rWI = SrcRtHndSideData%rWI
   DstRtHndSideData%rWJ = SrcRtHndSideData%rWJ
   DstRtHndSideData%rZT0 = SrcRtHndSideData%rZT0
   if (allocated(SrcRtHndSideData%AngPosEF)) then
      LB(1:2) = lbound(SrcRtHndSideData%AngPosEF)
      UB(1:2) = ubound(SrcRtHndSideData%AngPosEF)
      if (.not. allocated(DstRtHndSideData%AngPosEF)) then
         allocate(DstRtHndSideData%AngPosEF(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%AngPosEF.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%AngPosEF = SrcRtHndSideData%AngPosEF
   end if
   if (allocated(SrcRtHndSideData%AngPosXF)) then
      LB(1:2) = lbound(SrcRtHndSideData%AngPosXF)
      UB(1:2) = ubound(SrcRtHndSideData%AngPosXF)
      if (.not. allocated(DstRtHndSideData%AngPosXF)) then
         allocate(DstRtHndSideData%AngPosXF(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%AngPosXF.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%AngPosXF = SrcRtHndSideData%AngPosXF
   end if
   if (allocated(SrcRtHndSideData%AngPosHM)) then
      LB(1:3) = lbound(SrcRtHndSideData%AngPosHM)
      UB(1:3) = ubound(SrcRtHndSideData%AngPosHM)
      if (.not. allocated(DstRtHndSideData%AngPosHM)) then
         allocate(DstRtHndSideData%AngPosHM(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%AngPosHM.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%AngPosHM = SrcRtHndSideData%AngPosHM
   end if
   DstRtHndSideData%AngPosXB = SrcRtHndSideData%AngPosXB
   DstRtHndSideData%AngPosEX = SrcRtHndSideData%AngPosEX
   if (allocated(SrcRtHndSideData%PAngVelEA)) then
      LB(1:3) = lbound(SrcRtHndSideData%PAngVelEA)
      UB(1:3) = ubound(SrcRtHndSideData%PAngVelEA)
      if (.not. allocated(DstRtHndSideData%PAngVelEA)) then
         allocate(DstRtHndSideData%PAngVelEA(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PAngVelEA.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PAngVelEA = SrcRtHndSideData%PAngVelEA
   end if
   if (allocated(SrcRtHndSideData%PAngVelEF)) then
      LB(1:4) = lbound(SrcRtHndSideData%PAngVelEF)
      UB(1:4) = ubound(SrcRtHndSideData%PAngVelEF)
      if (.not. allocated(DstRtHndSideData%PAngVelEF)) then
         allocate(DstRtHndSideData%PAngVelEF(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PAngVelEF.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PAngVelEF = SrcRtHndSideData%PAngVelEF
   end if
   if (allocated(SrcRtHndSideData%PAngVelEG)) then
      LB(1:3) = lbound(SrcRtHndSideData%PAngVelEG)
      UB(1:3) = ubound(SrcRtHndSideData%PAngVelEG)
      if (.not. allocated(DstRtHndSideData%PAngVelEG)) then
         allocate(DstRtHndSideData%PAngVelEG(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PAngVelEG.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PAngVelEG = SrcRtHndSideData%PAngVelEG
   end if
   if (allocated(SrcRtHndSideData%PAngVelEH)) then
      LB(1:3) = lbound(SrcRtHndSideData%PAngVelEH)
      UB(1:3) = ubound(SrcRtHndSideData%PAngVelEH)
      if (.not. allocated(DstRtHndSideData%PAngVelEH)) then
         allocate(DstRtHndSideData%PAngVelEH(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PAngVelEH.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PAngVelEH = SrcRtHndSideData%PAngVelEH
   end if
   if (allocated(SrcRtHndSideData%PAngVelEL)) then
      LB(1:3) = lbound(SrcRtHndSideData%PAngVelEL)
      UB(1:3) = ubound(SrcRtHndSideData%PAngVelEL)
      if (.not. allocated(DstRtHndSideData%PAngVelEL)) then
         allocate(DstRtHndSideData%PAngVelEL(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PAngVelEL.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PAngVelEL = SrcRtHndSideData%PAngVelEL
   end if
   if (allocated(SrcRtHndSideData%PAngVelEM)) then
      LB(1:5) = lbound(SrcRtHndSideData%PAngVelEM)
      UB(1:5) = ubound(SrcRtHndSideData%PAngVelEM)
      if (.not. allocated(DstRtHndSideData%PAngVelEM)) then
         allocate(DstRtHndSideData%PAngVelEM(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4),LB(5):UB(5)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PAngVelEM.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PAngVelEM = SrcRtHndSideData%PAngVelEM
   end if
   if (allocated(SrcRtHndSideData%AngVelEM)) then
      LB(1:3) = lbound(SrcRtHndSideData%AngVelEM)
      UB(1:3) = ubound(SrcRtHndSideData%AngVelEM)
      if (.not. allocated(DstRtHndSideData%AngVelEM)) then
         allocate(DstRtHndSideData%AngVelEM(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%AngVelEM.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%AngVelEM = SrcRtHndSideData%AngVelEM
   end if
   if (allocated(SrcRtHndSideData%PAngVelEN)) then
      LB(1:3) = lbound(SrcRtHndSideData%PAngVelEN)
      UB(1:3) = ubound(SrcRtHndSideData%PAngVelEN)
      if (.not. allocated(DstRtHndSideData%PAngVelEN)) then
         allocate(DstRtHndSideData%PAngVelEN(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PAngVelEN.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PAngVelEN = SrcRtHndSideData%PAngVelEN
   end if
   DstRtHndSideData%AngVelEA = SrcRtHndSideData%AngVelEA
   if (allocated(SrcRtHndSideData%PAngVelEB)) then
      LB(1:3) = lbound(SrcRtHndSideData%PAngVelEB)
      UB(1:3) = ubound(SrcRtHndSideData%PAngVelEB)
      if (.not. allocated(DstRtHndSideData%PAngVelEB)) then
         allocate(DstRtHndSideData%PAngVelEB(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PAngVelEB.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PAngVelEB = SrcRtHndSideData%PAngVelEB
   end if
   if (allocated(SrcRtHndSideData%PAngVelER)) then
      LB(1:3) = lbound(SrcRtHndSideData%PAngVelER)
      UB(1:3) = ubound(SrcRtHndSideData%PAngVelER)
      if (.not. allocated(DstRtHndSideData%PAngVelER)) then
         allocate(DstRtHndSideData%PAngVelER(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PAngVelER.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PAngVelER = SrcRtHndSideData%PAngVelER
   end if
   if (allocated(SrcRtHndSideData%PAngVelEX)) then
      LB(1:3) = lbound(SrcRtHndSideData%PAngVelEX)
      UB(1:3) = ubound(SrcRtHndSideData%PAngVelEX)
      if (.not. allocated(DstRtHndSideData%PAngVelEX)) then
         allocate(DstRtHndSideData%PAngVelEX(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PAngVelEX.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PAngVelEX = SrcRtHndSideData%PAngVelEX
   end if
   DstRtHndSideData%AngVelEG = SrcRtHndSideData%AngVelEG
   DstRtHndSideData%AngVelEH = SrcRtHndSideData%AngVelEH
   DstRtHndSideData%AngVelEL = SrcRtHndSideData%AngVelEL
   DstRtHndSideData%AngVelEN = SrcRtHndSideData%AngVelEN
   DstRtHndSideData%AngVelEB = SrcRtHndSideData%AngVelEB
   DstRtHndSideData%AngVelER = SrcRtHndSideData%AngVelER
   DstRtHndSideData%AngVelEX = SrcRtHndSideData%AngVelEX
   DstRtHndSideData%TeetAngVel = SrcRtHndSideData%TeetAngVel
   DstRtHndSideData%AngAccEBt = SrcRtHndSideData%AngAccEBt
   DstRtHndSideData%AngAccERt = SrcRtHndSideData%AngAccERt
   DstRtHndSideData%AngAccEXt = SrcRtHndSideData%AngAccEXt
   if (allocated(SrcRtHndSideData%AngAccEFt)) then
      LB(1:2) = lbound(SrcRtHndSideData%AngAccEFt)
      UB(1:2) = ubound(SrcRtHndSideData%AngAccEFt)
      if (.not. allocated(DstRtHndSideData%AngAccEFt)) then
         allocate(DstRtHndSideData%AngAccEFt(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%AngAccEFt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%AngAccEFt = SrcRtHndSideData%AngAccEFt
   end if
   if (allocated(SrcRtHndSideData%AngVelEF)) then
      LB(1:2) = lbound(SrcRtHndSideData%AngVelEF)
      UB(1:2) = ubound(SrcRtHndSideData%AngVelEF)
      if (.not. allocated(DstRtHndSideData%AngVelEF)) then
         allocate(DstRtHndSideData%AngVelEF(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%AngVelEF.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%AngVelEF = SrcRtHndSideData%AngVelEF
   end if
   if (allocated(SrcRtHndSideData%AngVelHM)) then
      LB(1:3) = lbound(SrcRtHndSideData%AngVelHM)
      UB(1:3) = ubound(SrcRtHndSideData%AngVelHM)
      if (.not. allocated(DstRtHndSideData%AngVelHM)) then
         allocate(DstRtHndSideData%AngVelHM(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%AngVelHM.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%AngVelHM = SrcRtHndSideData%AngVelHM
   end if
   DstRtHndSideData%AngAccEAt = SrcRtHndSideData%AngAccEAt
   DstRtHndSideData%AngAccEGt = SrcRtHndSideData%AngAccEGt
   DstRtHndSideData%AngAccEHt = SrcRtHndSideData%AngAccEHt
   if (allocated(SrcRtHndSideData%AngAccEKt)) then
      LB(1:3) = lbound(SrcRtHndSideData%AngAccEKt)
      UB(1:3) = ubound(SrcRtHndSideData%AngAccEKt)
      if (.not. allocated(DstRtHndSideData%AngAccEKt)) then
         allocate(DstRtHndSideData%AngAccEKt(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%AngAccEKt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%AngAccEKt = SrcRtHndSideData%AngAccEKt
   end if
   DstRtHndSideData%AngAccENt = SrcRtHndSideData%AngAccENt
   DstRtHndSideData%LinAccECt = SrcRtHndSideData%LinAccECt
   DstRtHndSideData%LinAccEDt = SrcRtHndSideData%LinAccEDt
   DstRtHndSideData%LinAccEIt = SrcRtHndSideData%LinAccEIt
   DstRtHndSideData%LinAccEJt = SrcRtHndSideData%LinAccEJt
   DstRtHndSideData%LinAccEUt = SrcRtHndSideData%LinAccEUt
   DstRtHndSideData%LinAccEYt = SrcRtHndSideData%LinAccEYt
   if (allocated(SrcRtHndSideData%LinVelES)) then
      LB(1:3) = lbound(SrcRtHndSideData%LinVelES)
      UB(1:3) = ubound(SrcRtHndSideData%LinVelES)
      if (.not. allocated(DstRtHndSideData%LinVelES)) then
         allocate(DstRtHndSideData%LinVelES(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%LinVelES.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%LinVelES = SrcRtHndSideData%LinVelES
   end if
   DstRtHndSideData%LinVelEQ = SrcRtHndSideData%LinVelEQ
   if (allocated(SrcRtHndSideData%LinVelET)) then
      LB(1:2) = lbound(SrcRtHndSideData%LinVelET)
      UB(1:2) = ubound(SrcRtHndSideData%LinVelET)
      if (.not. allocated(DstRtHndSideData%LinVelET)) then
         allocate(DstRtHndSideData%LinVelET(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%LinVelET.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%LinVelET = SrcRtHndSideData%LinVelET
   end if
   if (allocated(SrcRtHndSideData%LinVelESm2)) then
      LB(1:1) = lbound(SrcRtHndSideData%LinVelESm2)
      UB(1:1) = ubound(SrcRtHndSideData%LinVelESm2)
      if (.not. allocated(DstRtHndSideData%LinVelESm2)) then
         allocate(DstRtHndSideData%LinVelESm2(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%LinVelESm2.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%LinVelESm2 = SrcRtHndSideData%LinVelESm2
   end if
   if (allocated(SrcRtHndSideData%PLinVelEIMU)) then
      LB(1:3) = lbound(SrcRtHndSideData%PLinVelEIMU)
      UB(1:3) = ubound(SrcRtHndSideData%PLinVelEIMU)
      if (.not. allocated(DstRtHndSideData%PLinVelEIMU)) then
         allocate(DstRtHndSideData%PLinVelEIMU(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PLinVelEIMU.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PLinVelEIMU = SrcRtHndSideData%PLinVelEIMU
   end if
   if (allocated(SrcRtHndSideData%PLinVelEO)) then
      LB(1:3) = lbound(SrcRtHndSideData%PLinVelEO)
      UB(1:3) = ubound(SrcRtHndSideData%PLinVelEO)
      if (.not. allocated(DstRtHndSideData%PLinVelEO)) then
         allocate(DstRtHndSideData%PLinVelEO(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PLinVelEO.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PLinVelEO = SrcRtHndSideData%PLinVelEO
   end if
   if (allocated(SrcRtHndSideData%PLinVelES)) then
      LB(1:5) = lbound(SrcRtHndSideData%PLinVelES)
      UB(1:5) = ubound(SrcRtHndSideData%PLinVelES)
      if (.not. allocated(DstRtHndSideData%PLinVelES)) then
         allocate(DstRtHndSideData%PLinVelES(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4),LB(5):UB(5)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PLinVelES.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PLinVelES = SrcRtHndSideData%PLinVelES
   end if
   if (allocated(SrcRtHndSideData%PLinVelET)) then
      LB(1:4) = lbound(SrcRtHndSideData%PLinVelET)
      UB(1:4) = ubound(SrcRtHndSideData%PLinVelET)
      if (.not. allocated(DstRtHndSideData%PLinVelET)) then
         allocate(DstRtHndSideData%PLinVelET(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PLinVelET.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PLinVelET = SrcRtHndSideData%PLinVelET
   end if
   if (allocated(SrcRtHndSideData%PLinVelEZ)) then
      LB(1:3) = lbound(SrcRtHndSideData%PLinVelEZ)
      UB(1:3) = ubound(SrcRtHndSideData%PLinVelEZ)
      if (.not. allocated(DstRtHndSideData%PLinVelEZ)) then
         allocate(DstRtHndSideData%PLinVelEZ(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PLinVelEZ.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PLinVelEZ = SrcRtHndSideData%PLinVelEZ
   end if
   if (allocated(SrcRtHndSideData%PLinVelEC)) then
      LB(1:3) = lbound(SrcRtHndSideData%PLinVelEC)
      UB(1:3) = ubound(SrcRtHndSideData%PLinVelEC)
      if (.not. allocated(DstRtHndSideData%PLinVelEC)) then
         allocate(DstRtHndSideData%PLinVelEC(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PLinVelEC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PLinVelEC = SrcRtHndSideData%PLinVelEC
   end if
   if (allocated(SrcRtHndSideData%PLinVelED)) then
      LB(1:3) = lbound(SrcRtHndSideData%PLinVelED)
      UB(1:3) = ubound(SrcRtHndSideData%PLinVelED)
      if (.not. allocated(DstRtHndSideData%PLinVelED)) then
         allocate(DstRtHndSideData%PLinVelED(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PLinVelED.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PLinVelED = SrcRtHndSideData%PLinVelED
   end if
   if (allocated(SrcRtHndSideData%PLinVelEI)) then
      LB(1:3) = lbound(SrcRtHndSideData%PLinVelEI)
      UB(1:3) = ubound(SrcRtHndSideData%PLinVelEI)
      if (.not. allocated(DstRtHndSideData%PLinVelEI)) then
         allocate(DstRtHndSideData%PLinVelEI(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PLinVelEI.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PLinVelEI = SrcRtHndSideData%PLinVelEI
   end if
   if (allocated(SrcRtHndSideData%PLinVelEJ)) then
      LB(1:3) = lbound(SrcRtHndSideData%PLinVelEJ)
      UB(1:3) = ubound(SrcRtHndSideData%PLinVelEJ)
      if (.not. allocated(DstRtHndSideData%PLinVelEJ)) then
         allocate(DstRtHndSideData%PLinVelEJ(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PLinVelEJ.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PLinVelEJ = SrcRtHndSideData%PLinVelEJ
   end if
   if (allocated(SrcRtHndSideData%PLinVelEP)) then
      LB(1:3) = lbound(SrcRtHndSideData%PLinVelEP)
      UB(1:3) = ubound(SrcRtHndSideData%PLinVelEP)
      if (.not. allocated(DstRtHndSideData%PLinVelEP)) then
         allocate(DstRtHndSideData%PLinVelEP(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PLinVelEP.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PLinVelEP = SrcRtHndSideData%PLinVelEP
   end if
   if (allocated(SrcRtHndSideData%PLinVelEQ)) then
      LB(1:3) = lbound(SrcRtHndSideData%PLinVelEQ)
      UB(1:3) = ubound(SrcRtHndSideData%PLinVelEQ)
      if (.not. allocated(DstRtHndSideData%PLinVelEQ)) then
         allocate(DstRtHndSideData%PLinVelEQ(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PLinVelEQ.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PLinVelEQ = SrcRtHndSideData%PLinVelEQ
   end if
   if (allocated(SrcRtHndSideData%PLinVelEU)) then
      LB(1:3) = lbound(SrcRtHndSideData%PLinVelEU)
      UB(1:3) = ubound(SrcRtHndSideData%PLinVelEU)
      if (.not. allocated(DstRtHndSideData%PLinVelEU)) then
         allocate(DstRtHndSideData%PLinVelEU(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PLinVelEU.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PLinVelEU = SrcRtHndSideData%PLinVelEU
   end if
   if (allocated(SrcRtHndSideData%PLinVelEV)) then
      LB(1:3) = lbound(SrcRtHndSideData%PLinVelEV)
      UB(1:3) = ubound(SrcRtHndSideData%PLinVelEV)
      if (.not. allocated(DstRtHndSideData%PLinVelEV)) then
         allocate(DstRtHndSideData%PLinVelEV(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PLinVelEV.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PLinVelEV = SrcRtHndSideData%PLinVelEV
   end if
   if (allocated(SrcRtHndSideData%PLinVelEW)) then
      LB(1:3) = lbound(SrcRtHndSideData%PLinVelEW)
      UB(1:3) = ubound(SrcRtHndSideData%PLinVelEW)
      if (.not. allocated(DstRtHndSideData%PLinVelEW)) then
         allocate(DstRtHndSideData%PLinVelEW(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PLinVelEW.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PLinVelEW = SrcRtHndSideData%PLinVelEW
   end if
   if (allocated(SrcRtHndSideData%PLinVelEY)) then
      LB(1:3) = lbound(SrcRtHndSideData%PLinVelEY)
      UB(1:3) = ubound(SrcRtHndSideData%PLinVelEY)
      if (.not. allocated(DstRtHndSideData%PLinVelEY)) then
         allocate(DstRtHndSideData%PLinVelEY(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PLinVelEY.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PLinVelEY = SrcRtHndSideData%PLinVelEY
   end if
   DstRtHndSideData%LinAccEIMUt = SrcRtHndSideData%LinAccEIMUt
   DstRtHndSideData%LinAccEOt = SrcRtHndSideData%LinAccEOt
   if (allocated(SrcRtHndSideData%LinAccESt)) then
      LB(1:3) = lbound(SrcRtHndSideData%LinAccESt)
      UB(1:3) = ubound(SrcRtHndSideData%LinAccESt)
      if (.not. allocated(DstRtHndSideData%LinAccESt)) then
         allocate(DstRtHndSideData%LinAccESt(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%LinAccESt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%LinAccESt = SrcRtHndSideData%LinAccESt
   end if
   if (allocated(SrcRtHndSideData%LinAccETt)) then
      LB(1:2) = lbound(SrcRtHndSideData%LinAccETt)
      UB(1:2) = ubound(SrcRtHndSideData%LinAccETt)
      if (.not. allocated(DstRtHndSideData%LinAccETt)) then
         allocate(DstRtHndSideData%LinAccETt(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%LinAccETt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%LinAccETt = SrcRtHndSideData%LinAccETt
   end if
   DstRtHndSideData%LinAccEZt = SrcRtHndSideData%LinAccEZt
   DstRtHndSideData%LinVelEIMU = SrcRtHndSideData%LinVelEIMU
   DstRtHndSideData%LinVelEZ = SrcRtHndSideData%LinVelEZ
   DstRtHndSideData%LinVelEO = SrcRtHndSideData%LinVelEO
   DstRtHndSideData%LinVelEJ = SrcRtHndSideData%LinVelEJ
   DstRtHndSideData%FrcONcRtt = SrcRtHndSideData%FrcONcRtt
   DstRtHndSideData%FrcPRott = SrcRtHndSideData%FrcPRott
   if (allocated(SrcRtHndSideData%FrcS0Bt)) then
      LB(1:2) = lbound(SrcRtHndSideData%FrcS0Bt)
      UB(1:2) = ubound(SrcRtHndSideData%FrcS0Bt)
      if (.not. allocated(DstRtHndSideData%FrcS0Bt)) then
         allocate(DstRtHndSideData%FrcS0Bt(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%FrcS0Bt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%FrcS0Bt = SrcRtHndSideData%FrcS0Bt
   end if
   DstRtHndSideData%FrcT0Trbt = SrcRtHndSideData%FrcT0Trbt
   if (allocated(SrcRtHndSideData%FSAero)) then
      LB(1:3) = lbound(SrcRtHndSideData%FSAero)
      UB(1:3) = ubound(SrcRtHndSideData%FSAero)
      if (.not. allocated(DstRtHndSideData%FSAero)) then
         allocate(DstRtHndSideData%FSAero(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%FSAero.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%FSAero = SrcRtHndSideData%FSAero
   end if
   if (allocated(SrcRtHndSideData%FSTipDrag)) then
      LB(1:2) = lbound(SrcRtHndSideData%FSTipDrag)
      UB(1:2) = ubound(SrcRtHndSideData%FSTipDrag)
      if (.not. allocated(DstRtHndSideData%FSTipDrag)) then
         allocate(DstRtHndSideData%FSTipDrag(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%FSTipDrag.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%FSTipDrag = SrcRtHndSideData%FSTipDrag
   end if
   if (allocated(SrcRtHndSideData%FTHydrot)) then
      LB(1:2) = lbound(SrcRtHndSideData%FTHydrot)
      UB(1:2) = ubound(SrcRtHndSideData%FTHydrot)
      if (.not. allocated(DstRtHndSideData%FTHydrot)) then
         allocate(DstRtHndSideData%FTHydrot(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%FTHydrot.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%FTHydrot = SrcRtHndSideData%FTHydrot
   end if
   DstRtHndSideData%FZHydrot = SrcRtHndSideData%FZHydrot
   if (allocated(SrcRtHndSideData%MFHydrot)) then
      LB(1:2) = lbound(SrcRtHndSideData%MFHydrot)
      UB(1:2) = ubound(SrcRtHndSideData%MFHydrot)
      if (.not. allocated(DstRtHndSideData%MFHydrot)) then
         allocate(DstRtHndSideData%MFHydrot(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%MFHydrot.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%MFHydrot = SrcRtHndSideData%MFHydrot
   end if
   DstRtHndSideData%MomBNcRtt = SrcRtHndSideData%MomBNcRtt
   if (allocated(SrcRtHndSideData%MomH0Bt)) then
      LB(1:2) = lbound(SrcRtHndSideData%MomH0Bt)
      UB(1:2) = ubound(SrcRtHndSideData%MomH0Bt)
      if (.not. allocated(DstRtHndSideData%MomH0Bt)) then
         allocate(DstRtHndSideData%MomH0Bt(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%MomH0Bt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%MomH0Bt = SrcRtHndSideData%MomH0Bt
   end if
   DstRtHndSideData%MomLPRott = SrcRtHndSideData%MomLPRott
   DstRtHndSideData%MomNGnRtt = SrcRtHndSideData%MomNGnRtt
   DstRtHndSideData%MomNTailt = SrcRtHndSideData%MomNTailt
   DstRtHndSideData%MomX0Trbt = SrcRtHndSideData%MomX0Trbt
   if (allocated(SrcRtHndSideData%MMAero)) then
      LB(1:3) = lbound(SrcRtHndSideData%MMAero)
      UB(1:3) = ubound(SrcRtHndSideData%MMAero)
      if (.not. allocated(DstRtHndSideData%MMAero)) then
         allocate(DstRtHndSideData%MMAero(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%MMAero.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%MMAero = SrcRtHndSideData%MMAero
   end if
   DstRtHndSideData%MXHydrot = SrcRtHndSideData%MXHydrot
   if (allocated(SrcRtHndSideData%PFrcONcRt)) then
      LB(1:2) = lbound(SrcRtHndSideData%PFrcONcRt)
      UB(1:2) = ubound(SrcRtHndSideData%PFrcONcRt)
      if (.not. allocated(DstRtHndSideData%PFrcONcRt)) then
         allocate(DstRtHndSideData%PFrcONcRt(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PFrcONcRt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PFrcONcRt = SrcRtHndSideData%PFrcONcRt
   end if
   if (allocated(SrcRtHndSideData%PFrcPRot)) then
      LB(1:2) = lbound(SrcRtHndSideData%PFrcPRot)
      UB(1:2) = ubound(SrcRtHndSideData%PFrcPRot)
      if (.not. allocated(DstRtHndSideData%PFrcPRot)) then
         allocate(DstRtHndSideData%PFrcPRot(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PFrcPRot.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PFrcPRot = SrcRtHndSideData%PFrcPRot
   end if
   if (allocated(SrcRtHndSideData%PFrcS0B)) then
      LB(1:3) = lbound(SrcRtHndSideData%PFrcS0B)
      UB(1:3) = ubound(SrcRtHndSideData%PFrcS0B)
      if (.not. allocated(DstRtHndSideData%PFrcS0B)) then
         allocate(DstRtHndSideData%PFrcS0B(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PFrcS0B.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PFrcS0B = SrcRtHndSideData%PFrcS0B
   end if
   if (allocated(SrcRtHndSideData%PFrcT0Trb)) then
      LB(1:2) = lbound(SrcRtHndSideData%PFrcT0Trb)
      UB(1:2) = ubound(SrcRtHndSideData%PFrcT0Trb)
      if (.not. allocated(DstRtHndSideData%PFrcT0Trb)) then
         allocate(DstRtHndSideData%PFrcT0Trb(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PFrcT0Trb.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PFrcT0Trb = SrcRtHndSideData%PFrcT0Trb
   end if
   if (allocated(SrcRtHndSideData%PFTHydro)) then
      LB(1:3) = lbound(SrcRtHndSideData%PFTHydro)
      UB(1:3) = ubound(SrcRtHndSideData%PFTHydro)
      if (.not. allocated(DstRtHndSideData%PFTHydro)) then
         allocate(DstRtHndSideData%PFTHydro(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PFTHydro.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PFTHydro = SrcRtHndSideData%PFTHydro
   end if
   DstRtHndSideData%PFZHydro = SrcRtHndSideData%PFZHydro
   if (allocated(SrcRtHndSideData%PMFHydro)) then
      LB(1:3) = lbound(SrcRtHndSideData%PMFHydro)
      UB(1:3) = ubound(SrcRtHndSideData%PMFHydro)
      if (.not. allocated(DstRtHndSideData%PMFHydro)) then
         allocate(DstRtHndSideData%PMFHydro(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PMFHydro.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PMFHydro = SrcRtHndSideData%PMFHydro
   end if
   if (allocated(SrcRtHndSideData%PMomBNcRt)) then
      LB(1:2) = lbound(SrcRtHndSideData%PMomBNcRt)
      UB(1:2) = ubound(SrcRtHndSideData%PMomBNcRt)
      if (.not. allocated(DstRtHndSideData%PMomBNcRt)) then
         allocate(DstRtHndSideData%PMomBNcRt(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PMomBNcRt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PMomBNcRt = SrcRtHndSideData%PMomBNcRt
   end if
   if (allocated(SrcRtHndSideData%PMomH0B)) then
      LB(1:3) = lbound(SrcRtHndSideData%PMomH0B)
      UB(1:3) = ubound(SrcRtHndSideData%PMomH0B)
      if (.not. allocated(DstRtHndSideData%PMomH0B)) then
         allocate(DstRtHndSideData%PMomH0B(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PMomH0B.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PMomH0B = SrcRtHndSideData%PMomH0B
   end if
   if (allocated(SrcRtHndSideData%PMomLPRot)) then
      LB(1:2) = lbound(SrcRtHndSideData%PMomLPRot)
      UB(1:2) = ubound(SrcRtHndSideData%PMomLPRot)
      if (.not. allocated(DstRtHndSideData%PMomLPRot)) then
         allocate(DstRtHndSideData%PMomLPRot(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PMomLPRot.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PMomLPRot = SrcRtHndSideData%PMomLPRot
   end if
   if (allocated(SrcRtHndSideData%PMomNGnRt)) then
      LB(1:2) = lbound(SrcRtHndSideData%PMomNGnRt)
      UB(1:2) = ubound(SrcRtHndSideData%PMomNGnRt)
      if (.not. allocated(DstRtHndSideData%PMomNGnRt)) then
         allocate(DstRtHndSideData%PMomNGnRt(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PMomNGnRt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PMomNGnRt = SrcRtHndSideData%PMomNGnRt
   end if
   if (allocated(SrcRtHndSideData%PMomNTail)) then
      LB(1:2) = lbound(SrcRtHndSideData%PMomNTail)
      UB(1:2) = ubound(SrcRtHndSideData%PMomNTail)
      if (.not. allocated(DstRtHndSideData%PMomNTail)) then
         allocate(DstRtHndSideData%PMomNTail(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PMomNTail.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PMomNTail = SrcRtHndSideData%PMomNTail
   end if
   if (allocated(SrcRtHndSideData%PMomX0Trb)) then
      LB(1:2) = lbound(SrcRtHndSideData%PMomX0Trb)
      UB(1:2) = ubound(SrcRtHndSideData%PMomX0Trb)
      if (.not. allocated(DstRtHndSideData%PMomX0Trb)) then
         allocate(DstRtHndSideData%PMomX0Trb(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PMomX0Trb.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PMomX0Trb = SrcRtHndSideData%PMomX0Trb
   end if
   DstRtHndSideData%PMXHydro = SrcRtHndSideData%PMXHydro
   DstRtHndSideData%TeetAng = SrcRtHndSideData%TeetAng
   DstRtHndSideData%FrcVGnRtt = SrcRtHndSideData%FrcVGnRtt
   DstRtHndSideData%FrcWTailt = SrcRtHndSideData%FrcWTailt
   DstRtHndSideData%FrcZAllt = SrcRtHndSideData%FrcZAllt
   DstRtHndSideData%MomXAllt = SrcRtHndSideData%MomXAllt
   if (allocated(SrcRtHndSideData%PFrcVGnRt)) then
      LB(1:2) = lbound(SrcRtHndSideData%PFrcVGnRt)
      UB(1:2) = ubound(SrcRtHndSideData%PFrcVGnRt)
      if (.not. allocated(DstRtHndSideData%PFrcVGnRt)) then
         allocate(DstRtHndSideData%PFrcVGnRt(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PFrcVGnRt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PFrcVGnRt = SrcRtHndSideData%PFrcVGnRt
   end if
   if (allocated(SrcRtHndSideData%PFrcWTail)) then
      LB(1:2) = lbound(SrcRtHndSideData%PFrcWTail)
      UB(1:2) = ubound(SrcRtHndSideData%PFrcWTail)
      if (.not. allocated(DstRtHndSideData%PFrcWTail)) then
         allocate(DstRtHndSideData%PFrcWTail(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PFrcWTail.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PFrcWTail = SrcRtHndSideData%PFrcWTail
   end if
   if (allocated(SrcRtHndSideData%PFrcZAll)) then
      LB(1:2) = lbound(SrcRtHndSideData%PFrcZAll)
      UB(1:2) = ubound(SrcRtHndSideData%PFrcZAll)
      if (.not. allocated(DstRtHndSideData%PFrcZAll)) then
         allocate(DstRtHndSideData%PFrcZAll(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PFrcZAll.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PFrcZAll = SrcRtHndSideData%PFrcZAll
   end if
   if (allocated(SrcRtHndSideData%PMomXAll)) then
      LB(1:2) = lbound(SrcRtHndSideData%PMomXAll)
      UB(1:2) = ubound(SrcRtHndSideData%PMomXAll)
      if (.not. allocated(DstRtHndSideData%PMomXAll)) then
         allocate(DstRtHndSideData%PMomXAll(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PMomXAll.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%PMomXAll = SrcRtHndSideData%PMomXAll
   end if
   DstRtHndSideData%TeetMom = SrcRtHndSideData%TeetMom
   DstRtHndSideData%TFrlMom = SrcRtHndSideData%TFrlMom
   DstRtHndSideData%RFrlMom = SrcRtHndSideData%RFrlMom
   DstRtHndSideData%GBoxEffFac = SrcRtHndSideData%GBoxEffFac
   if (allocated(SrcRtHndSideData%rSAerCen)) then
      LB(1:3) = lbound(SrcRtHndSideData%rSAerCen)
      UB(1:3) = ubound(SrcRtHndSideData%rSAerCen)
      if (.not. allocated(DstRtHndSideData%rSAerCen)) then
         allocate(DstRtHndSideData%rSAerCen(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%rSAerCen.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRtHndSideData%rSAerCen = SrcRtHndSideData%rSAerCen
   end if
   DstRtHndSideData%YawFriMom = SrcRtHndSideData%YawFriMom
end subroutine

subroutine ED_DestroyRtHndSide(RtHndSideData, ErrStat, ErrMsg)
   type(ED_RtHndSide), intent(inout) :: RtHndSideData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ED_DestroyRtHndSide'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(RtHndSideData%rQS)) then
      deallocate(RtHndSideData%rQS)
   end if
   if (allocated(RtHndSideData%rS)) then
      deallocate(RtHndSideData%rS)
   end if
   if (allocated(RtHndSideData%rS0S)) then
      deallocate(RtHndSideData%rS0S)
   end if
   if (allocated(RtHndSideData%rT)) then
      deallocate(RtHndSideData%rT)
   end if
   if (allocated(RtHndSideData%rT0T)) then
      deallocate(RtHndSideData%rT0T)
   end if
   if (allocated(RtHndSideData%rZT)) then
      deallocate(RtHndSideData%rZT)
   end if
   if (allocated(RtHndSideData%rPS0)) then
      deallocate(RtHndSideData%rPS0)
   end if
   if (allocated(RtHndSideData%AngPosEF)) then
      deallocate(RtHndSideData%AngPosEF)
   end if
   if (allocated(RtHndSideData%AngPosXF)) then
      deallocate(RtHndSideData%AngPosXF)
   end if
   if (allocated(RtHndSideData%AngPosHM)) then
      deallocate(RtHndSideData%AngPosHM)
   end if
   if (allocated(RtHndSideData%PAngVelEA)) then
      deallocate(RtHndSideData%PAngVelEA)
   end if
   if (allocated(RtHndSideData%PAngVelEF)) then
      deallocate(RtHndSideData%PAngVelEF)
   end if
   if (allocated(RtHndSideData%PAngVelEG)) then
      deallocate(RtHndSideData%PAngVelEG)
   end if
   if (allocated(RtHndSideData%PAngVelEH)) then
      deallocate(RtHndSideData%PAngVelEH)
   end if
   if (allocated(RtHndSideData%PAngVelEL)) then
      deallocate(RtHndSideData%PAngVelEL)
   end if
   if (allocated(RtHndSideData%PAngVelEM)) then
      deallocate(RtHndSideData%PAngVelEM)
   end if
   if (allocated(RtHndSideData%AngVelEM)) then
      deallocate(RtHndSideData%AngVelEM)
   end if
   if (allocated(RtHndSideData%PAngVelEN)) then
      deallocate(RtHndSideData%PAngVelEN)
   end if
   if (allocated(RtHndSideData%PAngVelEB)) then
      deallocate(RtHndSideData%PAngVelEB)
   end if
   if (allocated(RtHndSideData%PAngVelER)) then
      deallocate(RtHndSideData%PAngVelER)
   end if
   if (allocated(RtHndSideData%PAngVelEX)) then
      deallocate(RtHndSideData%PAngVelEX)
   end if
   if (allocated(RtHndSideData%AngAccEFt)) then
      deallocate(RtHndSideData%AngAccEFt)
   end if
   if (allocated(RtHndSideData%AngVelEF)) then
      deallocate(RtHndSideData%AngVelEF)
   end if
   if (allocated(RtHndSideData%AngVelHM)) then
      deallocate(RtHndSideData%AngVelHM)
   end if
   if (allocated(RtHndSideData%AngAccEKt)) then
      deallocate(RtHndSideData%AngAccEKt)
   end if
   if (allocated(RtHndSideData%LinVelES)) then
      deallocate(RtHndSideData%LinVelES)
   end if
   if (allocated(RtHndSideData%LinVelET)) then
      deallocate(RtHndSideData%LinVelET)
   end if
   if (allocated(RtHndSideData%LinVelESm2)) then
      deallocate(RtHndSideData%LinVelESm2)
   end if
   if (allocated(RtHndSideData%PLinVelEIMU)) then
      deallocate(RtHndSideData%PLinVelEIMU)
   end if
   if (allocated(RtHndSideData%PLinVelEO)) then
      deallocate(RtHndSideData%PLinVelEO)
   end if
   if (allocated(RtHndSideData%PLinVelES)) then
      deallocate(RtHndSideData%PLinVelES)
   end if
   if (allocated(RtHndSideData%PLinVelET)) then
      deallocate(RtHndSideData%PLinVelET)
   end if
   if (allocated(RtHndSideData%PLinVelEZ)) then
      deallocate(RtHndSideData%PLinVelEZ)
   end if
   if (allocated(RtHndSideData%PLinVelEC)) then
      deallocate(RtHndSideData%PLinVelEC)
   end if
   if (allocated(RtHndSideData%PLinVelED)) then
      deallocate(RtHndSideData%PLinVelED)
   end if
   if (allocated(RtHndSideData%PLinVelEI)) then
      deallocate(RtHndSideData%PLinVelEI)
   end if
   if (allocated(RtHndSideData%PLinVelEJ)) then
      deallocate(RtHndSideData%PLinVelEJ)
   end if
   if (allocated(RtHndSideData%PLinVelEP)) then
      deallocate(RtHndSideData%PLinVelEP)
   end if
   if (allocated(RtHndSideData%PLinVelEQ)) then
      deallocate(RtHndSideData%PLinVelEQ)
   end if
   if (allocated(RtHndSideData%PLinVelEU)) then
      deallocate(RtHndSideData%PLinVelEU)
   end if
   if (allocated(RtHndSideData%PLinVelEV)) then
      deallocate(RtHndSideData%PLinVelEV)
   end if
   if (allocated(RtHndSideData%PLinVelEW)) then
      deallocate(RtHndSideData%PLinVelEW)
   end if
   if (allocated(RtHndSideData%PLinVelEY)) then
      deallocate(RtHndSideData%PLinVelEY)
   end if
   if (allocated(RtHndSideData%LinAccESt)) then
      deallocate(RtHndSideData%LinAccESt)
   end if
   if (allocated(RtHndSideData%LinAccETt)) then
      deallocate(RtHndSideData%LinAccETt)
   end if
   if (allocated(RtHndSideData%FrcS0Bt)) then
      deallocate(RtHndSideData%FrcS0Bt)
   end if
   if (allocated(RtHndSideData%FSAero)) then
      deallocate(RtHndSideData%FSAero)
   end if
   if (allocated(RtHndSideData%FSTipDrag)) then
      deallocate(RtHndSideData%FSTipDrag)
   end if
   if (allocated(RtHndSideData%FTHydrot)) then
      deallocate(RtHndSideData%FTHydrot)
   end if
   if (allocated(RtHndSideData%MFHydrot)) then
      deallocate(RtHndSideData%MFHydrot)
   end if
   if (allocated(RtHndSideData%MomH0Bt)) then
      deallocate(RtHndSideData%MomH0Bt)
   end if
   if (allocated(RtHndSideData%MMAero)) then
      deallocate(RtHndSideData%MMAero)
   end if
   if (allocated(RtHndSideData%PFrcONcRt)) then
      deallocate(RtHndSideData%PFrcONcRt)
   end if
   if (allocated(RtHndSideData%PFrcPRot)) then
      deallocate(RtHndSideData%PFrcPRot)
   end if
   if (allocated(RtHndSideData%PFrcS0B)) then
      deallocate(RtHndSideData%PFrcS0B)
   end if
   if (allocated(RtHndSideData%PFrcT0Trb)) then
      deallocate(RtHndSideData%PFrcT0Trb)
   end if
   if (allocated(RtHndSideData%PFTHydro)) then
      deallocate(RtHndSideData%PFTHydro)
   end if
   if (allocated(RtHndSideData%PMFHydro)) then
      deallocate(RtHndSideData%PMFHydro)
   end if
   if (allocated(RtHndSideData%PMomBNcRt)) then
      deallocate(RtHndSideData%PMomBNcRt)
   end if
   if (allocated(RtHndSideData%PMomH0B)) then
      deallocate(RtHndSideData%PMomH0B)
   end if
   if (allocated(RtHndSideData%PMomLPRot)) then
      deallocate(RtHndSideData%PMomLPRot)
   end if
   if (allocated(RtHndSideData%PMomNGnRt)) then
      deallocate(RtHndSideData%PMomNGnRt)
   end if
   if (allocated(RtHndSideData%PMomNTail)) then
      deallocate(RtHndSideData%PMomNTail)
   end if
   if (allocated(RtHndSideData%PMomX0Trb)) then
      deallocate(RtHndSideData%PMomX0Trb)
   end if
   if (allocated(RtHndSideData%PFrcVGnRt)) then
      deallocate(RtHndSideData%PFrcVGnRt)
   end if
   if (allocated(RtHndSideData%PFrcWTail)) then
      deallocate(RtHndSideData%PFrcWTail)
   end if
   if (allocated(RtHndSideData%PFrcZAll)) then
      deallocate(RtHndSideData%PFrcZAll)
   end if
   if (allocated(RtHndSideData%PMomXAll)) then
      deallocate(RtHndSideData%PMomXAll)
   end if
   if (allocated(RtHndSideData%rSAerCen)) then
      deallocate(RtHndSideData%rSAerCen)
   end if
end subroutine

subroutine ED_PackRtHndSide(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ED_RtHndSide), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ED_PackRtHndSide'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%rO)
   call RegPackAlloc(RF, InData%rQS)
   call RegPackAlloc(RF, InData%rS)
   call RegPackAlloc(RF, InData%rS0S)
   call RegPackAlloc(RF, InData%rT)
   call RegPack(RF, InData%rT0O)
   call RegPackAlloc(RF, InData%rT0T)
   call RegPack(RF, InData%rZ)
   call RegPack(RF, InData%rZO)
   call RegPackAlloc(RF, InData%rZT)
   call RegPack(RF, InData%rPQ)
   call RegPack(RF, InData%rP)
   call RegPack(RF, InData%rV)
   call RegPack(RF, InData%rJ)
   call RegPack(RF, InData%rZY)
   call RegPack(RF, InData%rOU)
   call RegPack(RF, InData%rOV)
   call RegPack(RF, InData%rVD)
   call RegPack(RF, InData%rOW)
   call RegPack(RF, InData%rPC)
   call RegPackAlloc(RF, InData%rPS0)
   call RegPack(RF, InData%rQ)
   call RegPack(RF, InData%rQC)
   call RegPack(RF, InData%rVIMU)
   call RegPack(RF, InData%rVP)
   call RegPack(RF, InData%rWI)
   call RegPack(RF, InData%rWJ)
   call RegPack(RF, InData%rZT0)
   call RegPackAlloc(RF, InData%AngPosEF)
   call RegPackAlloc(RF, InData%AngPosXF)
   call RegPackAlloc(RF, InData%AngPosHM)
   call RegPack(RF, InData%AngPosXB)
   call RegPack(RF, InData%AngPosEX)
   call RegPackAlloc(RF, InData%PAngVelEA)
   call RegPackAlloc(RF, InData%PAngVelEF)
   call RegPackAlloc(RF, InData%PAngVelEG)
   call RegPackAlloc(RF, InData%PAngVelEH)
   call RegPackAlloc(RF, InData%PAngVelEL)
   call RegPackAlloc(RF, InData%PAngVelEM)
   call RegPackAlloc(RF, InData%AngVelEM)
   call RegPackAlloc(RF, InData%PAngVelEN)
   call RegPack(RF, InData%AngVelEA)
   call RegPackAlloc(RF, InData%PAngVelEB)
   call RegPackAlloc(RF, InData%PAngVelER)
   call RegPackAlloc(RF, InData%PAngVelEX)
   call RegPack(RF, InData%AngVelEG)
   call RegPack(RF, InData%AngVelEH)
   call RegPack(RF, InData%AngVelEL)
   call RegPack(RF, InData%AngVelEN)
   call RegPack(RF, InData%AngVelEB)
   call RegPack(RF, InData%AngVelER)
   call RegPack(RF, InData%AngVelEX)
   call RegPack(RF, InData%TeetAngVel)
   call RegPack(RF, InData%AngAccEBt)
   call RegPack(RF, InData%AngAccERt)
   call RegPack(RF, InData%AngAccEXt)
   call RegPackAlloc(RF, InData%AngAccEFt)
   call RegPackAlloc(RF, InData%AngVelEF)
   call RegPackAlloc(RF, InData%AngVelHM)
   call RegPack(RF, InData%AngAccEAt)
   call RegPack(RF, InData%AngAccEGt)
   call RegPack(RF, InData%AngAccEHt)
   call RegPackAlloc(RF, InData%AngAccEKt)
   call RegPack(RF, InData%AngAccENt)
   call RegPack(RF, InData%LinAccECt)
   call RegPack(RF, InData%LinAccEDt)
   call RegPack(RF, InData%LinAccEIt)
   call RegPack(RF, InData%LinAccEJt)
   call RegPack(RF, InData%LinAccEUt)
   call RegPack(RF, InData%LinAccEYt)
   call RegPackAlloc(RF, InData%LinVelES)
   call RegPack(RF, InData%LinVelEQ)
   call RegPackAlloc(RF, InData%LinVelET)
   call RegPackAlloc(RF, InData%LinVelESm2)
   call RegPackAlloc(RF, InData%PLinVelEIMU)
   call RegPackAlloc(RF, InData%PLinVelEO)
   call RegPackAlloc(RF, InData%PLinVelES)
   call RegPackAlloc(RF, InData%PLinVelET)
   call RegPackAlloc(RF, InData%PLinVelEZ)
   call RegPackAlloc(RF, InData%PLinVelEC)
   call RegPackAlloc(RF, InData%PLinVelED)
   call RegPackAlloc(RF, InData%PLinVelEI)
   call RegPackAlloc(RF, InData%PLinVelEJ)
   call RegPackAlloc(RF, InData%PLinVelEP)
   call RegPackAlloc(RF, InData%PLinVelEQ)
   call RegPackAlloc(RF, InData%PLinVelEU)
   call RegPackAlloc(RF, InData%PLinVelEV)
   call RegPackAlloc(RF, InData%PLinVelEW)
   call RegPackAlloc(RF, InData%PLinVelEY)
   call RegPack(RF, InData%LinAccEIMUt)
   call RegPack(RF, InData%LinAccEOt)
   call RegPackAlloc(RF, InData%LinAccESt)
   call RegPackAlloc(RF, InData%LinAccETt)
   call RegPack(RF, InData%LinAccEZt)
   call RegPack(RF, InData%LinVelEIMU)
   call RegPack(RF, InData%LinVelEZ)
   call RegPack(RF, InData%LinVelEO)
   call RegPack(RF, InData%LinVelEJ)
   call RegPack(RF, InData%FrcONcRtt)
   call RegPack(RF, InData%FrcPRott)
   call RegPackAlloc(RF, InData%FrcS0Bt)
   call RegPack(RF, InData%FrcT0Trbt)
   call RegPackAlloc(RF, InData%FSAero)
   call RegPackAlloc(RF, InData%FSTipDrag)
   call RegPackAlloc(RF, InData%FTHydrot)
   call RegPack(RF, InData%FZHydrot)
   call RegPackAlloc(RF, InData%MFHydrot)
   call RegPack(RF, InData%MomBNcRtt)
   call RegPackAlloc(RF, InData%MomH0Bt)
   call RegPack(RF, InData%MomLPRott)
   call RegPack(RF, InData%MomNGnRtt)
   call RegPack(RF, InData%MomNTailt)
   call RegPack(RF, InData%MomX0Trbt)
   call RegPackAlloc(RF, InData%MMAero)
   call RegPack(RF, InData%MXHydrot)
   call RegPackAlloc(RF, InData%PFrcONcRt)
   call RegPackAlloc(RF, InData%PFrcPRot)
   call RegPackAlloc(RF, InData%PFrcS0B)
   call RegPackAlloc(RF, InData%PFrcT0Trb)
   call RegPackAlloc(RF, InData%PFTHydro)
   call RegPack(RF, InData%PFZHydro)
   call RegPackAlloc(RF, InData%PMFHydro)
   call RegPackAlloc(RF, InData%PMomBNcRt)
   call RegPackAlloc(RF, InData%PMomH0B)
   call RegPackAlloc(RF, InData%PMomLPRot)
   call RegPackAlloc(RF, InData%PMomNGnRt)
   call RegPackAlloc(RF, InData%PMomNTail)
   call RegPackAlloc(RF, InData%PMomX0Trb)
   call RegPack(RF, InData%PMXHydro)
   call RegPack(RF, InData%TeetAng)
   call RegPack(RF, InData%FrcVGnRtt)
   call RegPack(RF, InData%FrcWTailt)
   call RegPack(RF, InData%FrcZAllt)
   call RegPack(RF, InData%MomXAllt)
   call RegPackAlloc(RF, InData%PFrcVGnRt)
   call RegPackAlloc(RF, InData%PFrcWTail)
   call RegPackAlloc(RF, InData%PFrcZAll)
   call RegPackAlloc(RF, InData%PMomXAll)
   call RegPack(RF, InData%TeetMom)
   call RegPack(RF, InData%TFrlMom)
   call RegPack(RF, InData%RFrlMom)
   call RegPack(RF, InData%GBoxEffFac)
   call RegPackAlloc(RF, InData%rSAerCen)
   call RegPack(RF, InData%YawFriMom)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ED_UnPackRtHndSide(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ED_RtHndSide), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ED_UnPackRtHndSide'
   integer(B4Ki)   :: LB(5), UB(5)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%rO); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%rQS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%rS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%rS0S); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%rT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rT0O); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%rT0T); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rZ); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rZO); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%rZT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rPQ); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rV); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rJ); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rZY); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rOU); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rOV); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rVD); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rOW); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rPC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%rPS0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rQ); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rQC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rVIMU); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rVP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rWI); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rWJ); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rZT0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AngPosEF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AngPosXF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AngPosHM); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AngPosXB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AngPosEX); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PAngVelEA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PAngVelEF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PAngVelEG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PAngVelEH); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PAngVelEL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PAngVelEM); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AngVelEM); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PAngVelEN); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AngVelEA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PAngVelEB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PAngVelER); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PAngVelEX); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AngVelEG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AngVelEH); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AngVelEL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AngVelEN); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AngVelEB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AngVelER); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AngVelEX); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TeetAngVel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AngAccEBt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AngAccERt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AngAccEXt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AngAccEFt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AngVelEF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AngVelHM); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AngAccEAt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AngAccEGt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AngAccEHt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AngAccEKt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AngAccENt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LinAccECt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LinAccEDt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LinAccEIt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LinAccEJt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LinAccEUt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LinAccEYt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LinVelES); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LinVelEQ); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LinVelET); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LinVelESm2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PLinVelEIMU); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PLinVelEO); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PLinVelES); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PLinVelET); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PLinVelEZ); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PLinVelEC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PLinVelED); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PLinVelEI); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PLinVelEJ); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PLinVelEP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PLinVelEQ); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PLinVelEU); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PLinVelEV); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PLinVelEW); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PLinVelEY); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LinAccEIMUt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LinAccEOt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LinAccESt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LinAccETt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LinAccEZt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LinVelEIMU); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LinVelEZ); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LinVelEO); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LinVelEJ); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FrcONcRtt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FrcPRott); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%FrcS0Bt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FrcT0Trbt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%FSAero); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%FSTipDrag); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%FTHydrot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FZHydrot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%MFHydrot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MomBNcRtt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%MomH0Bt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MomLPRott); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MomNGnRtt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MomNTailt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MomX0Trbt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%MMAero); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MXHydrot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PFrcONcRt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PFrcPRot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PFrcS0B); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PFrcT0Trb); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PFTHydro); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PFZHydro); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PMFHydro); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PMomBNcRt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PMomH0B); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PMomLPRot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PMomNGnRt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PMomNTail); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PMomX0Trb); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PMXHydro); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TeetAng); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FrcVGnRtt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FrcWTailt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FrcZAllt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MomXAllt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PFrcVGnRt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PFrcWTail); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PFrcZAll); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PMomXAll); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TeetMom); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFrlMom); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RFrlMom); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GBoxEffFac); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%rSAerCen); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawFriMom); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ED_CopyContState(SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg)
   type(ED_ContinuousStateType), intent(in) :: SrcContStateData
   type(ED_ContinuousStateType), intent(inout) :: DstContStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'ED_CopyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcContStateData%QT)) then
      LB(1:1) = lbound(SrcContStateData%QT)
      UB(1:1) = ubound(SrcContStateData%QT)
      if (.not. allocated(DstContStateData%QT)) then
         allocate(DstContStateData%QT(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstContStateData%QT.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstContStateData%QT = SrcContStateData%QT
   end if
   if (allocated(SrcContStateData%QDT)) then
      LB(1:1) = lbound(SrcContStateData%QDT)
      UB(1:1) = ubound(SrcContStateData%QDT)
      if (.not. allocated(DstContStateData%QDT)) then
         allocate(DstContStateData%QDT(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstContStateData%QDT.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstContStateData%QDT = SrcContStateData%QDT
   end if
end subroutine

subroutine ED_DestroyContState(ContStateData, ErrStat, ErrMsg)
   type(ED_ContinuousStateType), intent(inout) :: ContStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ED_DestroyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ContStateData%QT)) then
      deallocate(ContStateData%QT)
   end if
   if (allocated(ContStateData%QDT)) then
      deallocate(ContStateData%QDT)
   end if
end subroutine

subroutine ED_PackContState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ED_ContinuousStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ED_PackContState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%QT)
   call RegPackAlloc(RF, InData%QDT)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ED_UnPackContState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ED_ContinuousStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ED_UnPackContState'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%QT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%QDT); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ED_CopyDiscState(SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg)
   type(ED_DiscreteStateType), intent(in) :: SrcDiscStateData
   type(ED_DiscreteStateType), intent(inout) :: DstDiscStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ED_CopyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstDiscStateData%DummyDiscState = SrcDiscStateData%DummyDiscState
end subroutine

subroutine ED_DestroyDiscState(DiscStateData, ErrStat, ErrMsg)
   type(ED_DiscreteStateType), intent(inout) :: DiscStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ED_DestroyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine ED_PackDiscState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ED_DiscreteStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ED_PackDiscState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyDiscState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ED_UnPackDiscState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ED_DiscreteStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ED_UnPackDiscState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyDiscState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ED_CopyConstrState(SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg)
   type(ED_ConstraintStateType), intent(in) :: SrcConstrStateData
   type(ED_ConstraintStateType), intent(inout) :: DstConstrStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ED_CopyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstConstrStateData%DummyConstrState = SrcConstrStateData%DummyConstrState
end subroutine

subroutine ED_DestroyConstrState(ConstrStateData, ErrStat, ErrMsg)
   type(ED_ConstraintStateType), intent(inout) :: ConstrStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ED_DestroyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine ED_PackConstrState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ED_ConstraintStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ED_PackConstrState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyConstrState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ED_UnPackConstrState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ED_ConstraintStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ED_UnPackConstrState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyConstrState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ED_CopyOtherState(SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg)
   type(ED_OtherStateType), intent(in) :: SrcOtherStateData
   type(ED_OtherStateType), intent(inout) :: DstOtherStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ED_CopyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstOtherStateData%n = SrcOtherStateData%n
   LB(1:1) = lbound(SrcOtherStateData%xdot)
   UB(1:1) = ubound(SrcOtherStateData%xdot)
   do i1 = LB(1), UB(1)
      call ED_CopyContState(SrcOtherStateData%xdot(i1), DstOtherStateData%xdot(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   if (allocated(SrcOtherStateData%IC)) then
      LB(1:1) = lbound(SrcOtherStateData%IC)
      UB(1:1) = ubound(SrcOtherStateData%IC)
      if (.not. allocated(DstOtherStateData%IC)) then
         allocate(DstOtherStateData%IC(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%IC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOtherStateData%IC = SrcOtherStateData%IC
   end if
   DstOtherStateData%HSSBrTrq = SrcOtherStateData%HSSBrTrq
   DstOtherStateData%HSSBrTrqC = SrcOtherStateData%HSSBrTrqC
   DstOtherStateData%SgnPrvLSTQ = SrcOtherStateData%SgnPrvLSTQ
   DstOtherStateData%SgnLSTQ = SrcOtherStateData%SgnLSTQ
   DstOtherStateData%Mfhat = SrcOtherStateData%Mfhat
   DstOtherStateData%YawFriMfp = SrcOtherStateData%YawFriMfp
   DstOtherStateData%OmegaTn = SrcOtherStateData%OmegaTn
   DstOtherStateData%OmegaDotTn = SrcOtherStateData%OmegaDotTn
end subroutine

subroutine ED_DestroyOtherState(OtherStateData, ErrStat, ErrMsg)
   type(ED_OtherStateType), intent(inout) :: OtherStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ED_DestroyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   LB(1:1) = lbound(OtherStateData%xdot)
   UB(1:1) = ubound(OtherStateData%xdot)
   do i1 = LB(1), UB(1)
      call ED_DestroyContState(OtherStateData%xdot(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   if (allocated(OtherStateData%IC)) then
      deallocate(OtherStateData%IC)
   end if
end subroutine

subroutine ED_PackOtherState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ED_OtherStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ED_PackOtherState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%n)
   LB(1:1) = lbound(InData%xdot)
   UB(1:1) = ubound(InData%xdot)
   do i1 = LB(1), UB(1)
      call ED_PackContState(RF, InData%xdot(i1)) 
   end do
   call RegPackAlloc(RF, InData%IC)
   call RegPack(RF, InData%HSSBrTrq)
   call RegPack(RF, InData%HSSBrTrqC)
   call RegPack(RF, InData%SgnPrvLSTQ)
   call RegPack(RF, InData%SgnLSTQ)
   call RegPack(RF, InData%Mfhat)
   call RegPack(RF, InData%YawFriMfp)
   call RegPack(RF, InData%OmegaTn)
   call RegPack(RF, InData%OmegaDotTn)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ED_UnPackOtherState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ED_OtherStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ED_UnPackOtherState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%n); if (RegCheckErr(RF, RoutineName)) return
   LB(1:1) = lbound(OutData%xdot)
   UB(1:1) = ubound(OutData%xdot)
   do i1 = LB(1), UB(1)
      call ED_UnpackContState(RF, OutData%xdot(i1)) ! xdot 
   end do
   call RegUnpackAlloc(RF, OutData%IC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HSSBrTrq); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HSSBrTrqC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SgnPrvLSTQ); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SgnLSTQ); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Mfhat); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawFriMfp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OmegaTn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OmegaDotTn); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ED_CopyMisc(SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg)
   type(ED_MiscVarType), intent(in) :: SrcMiscData
   type(ED_MiscVarType), intent(inout) :: DstMiscData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ED_CopyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call ED_CopyCoordSys(SrcMiscData%CoordSys, DstMiscData%CoordSys, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call ED_CopyRtHndSide(SrcMiscData%RtHS, DstMiscData%RtHS, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcMiscData%AllOuts)) then
      LB(1:1) = lbound(SrcMiscData%AllOuts)
      UB(1:1) = ubound(SrcMiscData%AllOuts)
      if (.not. allocated(DstMiscData%AllOuts)) then
         allocate(DstMiscData%AllOuts(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%AllOuts.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%AllOuts = SrcMiscData%AllOuts
   end if
   if (allocated(SrcMiscData%AugMat)) then
      LB(1:2) = lbound(SrcMiscData%AugMat)
      UB(1:2) = ubound(SrcMiscData%AugMat)
      if (.not. allocated(DstMiscData%AugMat)) then
         allocate(DstMiscData%AugMat(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%AugMat.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%AugMat = SrcMiscData%AugMat
   end if
   if (allocated(SrcMiscData%AugMat_factor)) then
      LB(1:2) = lbound(SrcMiscData%AugMat_factor)
      UB(1:2) = ubound(SrcMiscData%AugMat_factor)
      if (.not. allocated(DstMiscData%AugMat_factor)) then
         allocate(DstMiscData%AugMat_factor(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%AugMat_factor.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%AugMat_factor = SrcMiscData%AugMat_factor
   end if
   if (allocated(SrcMiscData%SolnVec)) then
      LB(1:1) = lbound(SrcMiscData%SolnVec)
      UB(1:1) = ubound(SrcMiscData%SolnVec)
      if (.not. allocated(DstMiscData%SolnVec)) then
         allocate(DstMiscData%SolnVec(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%SolnVec.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%SolnVec = SrcMiscData%SolnVec
   end if
   if (allocated(SrcMiscData%AugMat_pivot)) then
      LB(1:1) = lbound(SrcMiscData%AugMat_pivot)
      UB(1:1) = ubound(SrcMiscData%AugMat_pivot)
      if (.not. allocated(DstMiscData%AugMat_pivot)) then
         allocate(DstMiscData%AugMat_pivot(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%AugMat_pivot.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%AugMat_pivot = SrcMiscData%AugMat_pivot
   end if
   if (allocated(SrcMiscData%OgnlGeAzRo)) then
      LB(1:1) = lbound(SrcMiscData%OgnlGeAzRo)
      UB(1:1) = ubound(SrcMiscData%OgnlGeAzRo)
      if (.not. allocated(DstMiscData%OgnlGeAzRo)) then
         allocate(DstMiscData%OgnlGeAzRo(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%OgnlGeAzRo.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%OgnlGeAzRo = SrcMiscData%OgnlGeAzRo
   end if
   if (allocated(SrcMiscData%QD2T)) then
      LB(1:1) = lbound(SrcMiscData%QD2T)
      UB(1:1) = ubound(SrcMiscData%QD2T)
      if (.not. allocated(DstMiscData%QD2T)) then
         allocate(DstMiscData%QD2T(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%QD2T.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%QD2T = SrcMiscData%QD2T
   end if
   DstMiscData%IgnoreMod = SrcMiscData%IgnoreMod
   if (allocated(SrcMiscData%OgnlYawRow)) then
      LB(1:1) = lbound(SrcMiscData%OgnlYawRow)
      UB(1:1) = ubound(SrcMiscData%OgnlYawRow)
      if (.not. allocated(DstMiscData%OgnlYawRow)) then
         allocate(DstMiscData%OgnlYawRow(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%OgnlYawRow.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%OgnlYawRow = SrcMiscData%OgnlYawRow
   end if
   DstMiscData%FrcONcRt = SrcMiscData%FrcONcRt
   DstMiscData%MomONcRt = SrcMiscData%MomONcRt
   DstMiscData%YawFriMz = SrcMiscData%YawFriMz
end subroutine

subroutine ED_DestroyMisc(MiscData, ErrStat, ErrMsg)
   type(ED_MiscVarType), intent(inout) :: MiscData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ED_DestroyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call ED_DestroyCoordSys(MiscData%CoordSys, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call ED_DestroyRtHndSide(MiscData%RtHS, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(MiscData%AllOuts)) then
      deallocate(MiscData%AllOuts)
   end if
   if (allocated(MiscData%AugMat)) then
      deallocate(MiscData%AugMat)
   end if
   if (allocated(MiscData%AugMat_factor)) then
      deallocate(MiscData%AugMat_factor)
   end if
   if (allocated(MiscData%SolnVec)) then
      deallocate(MiscData%SolnVec)
   end if
   if (allocated(MiscData%AugMat_pivot)) then
      deallocate(MiscData%AugMat_pivot)
   end if
   if (allocated(MiscData%OgnlGeAzRo)) then
      deallocate(MiscData%OgnlGeAzRo)
   end if
   if (allocated(MiscData%QD2T)) then
      deallocate(MiscData%QD2T)
   end if
   if (allocated(MiscData%OgnlYawRow)) then
      deallocate(MiscData%OgnlYawRow)
   end if
end subroutine

subroutine ED_PackMisc(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ED_MiscVarType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ED_PackMisc'
   if (RF%ErrStat >= AbortErrLev) return
   call ED_PackCoordSys(RF, InData%CoordSys) 
   call ED_PackRtHndSide(RF, InData%RtHS) 
   call RegPackAlloc(RF, InData%AllOuts)
   call RegPackAlloc(RF, InData%AugMat)
   call RegPackAlloc(RF, InData%AugMat_factor)
   call RegPackAlloc(RF, InData%SolnVec)
   call RegPackAlloc(RF, InData%AugMat_pivot)
   call RegPackAlloc(RF, InData%OgnlGeAzRo)
   call RegPackAlloc(RF, InData%QD2T)
   call RegPack(RF, InData%IgnoreMod)
   call RegPackAlloc(RF, InData%OgnlYawRow)
   call RegPack(RF, InData%FrcONcRt)
   call RegPack(RF, InData%MomONcRt)
   call RegPack(RF, InData%YawFriMz)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ED_UnPackMisc(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ED_MiscVarType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ED_UnPackMisc'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call ED_UnpackCoordSys(RF, OutData%CoordSys) ! CoordSys 
   call ED_UnpackRtHndSide(RF, OutData%RtHS) ! RtHS 
   call RegUnpackAlloc(RF, OutData%AllOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AugMat); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AugMat_factor); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%SolnVec); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AugMat_pivot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%OgnlGeAzRo); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%QD2T); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%IgnoreMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%OgnlYawRow); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FrcONcRt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MomONcRt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawFriMz); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ED_CopyJac_u_idxStarts(SrcJac_u_idxStartsData, DstJac_u_idxStartsData, CtrlCode, ErrStat, ErrMsg)
   type(Jac_u_idxStarts), intent(in) :: SrcJac_u_idxStartsData
   type(Jac_u_idxStarts), intent(inout) :: DstJac_u_idxStartsData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ED_CopyJac_u_idxStarts'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstJac_u_idxStartsData%BladeLoad = SrcJac_u_idxStartsData%BladeLoad
   DstJac_u_idxStartsData%PlatformLoad = SrcJac_u_idxStartsData%PlatformLoad
   DstJac_u_idxStartsData%TowerLoad = SrcJac_u_idxStartsData%TowerLoad
   DstJac_u_idxStartsData%HubLoad = SrcJac_u_idxStartsData%HubLoad
   DstJac_u_idxStartsData%NacelleLoad = SrcJac_u_idxStartsData%NacelleLoad
   DstJac_u_idxStartsData%TFinLoad = SrcJac_u_idxStartsData%TFinLoad
   DstJac_u_idxStartsData%BlPitchCom = SrcJac_u_idxStartsData%BlPitchCom
end subroutine

subroutine ED_DestroyJac_u_idxStarts(Jac_u_idxStartsData, ErrStat, ErrMsg)
   type(Jac_u_idxStarts), intent(inout) :: Jac_u_idxStartsData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ED_DestroyJac_u_idxStarts'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine ED_PackJac_u_idxStarts(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Jac_u_idxStarts), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ED_PackJac_u_idxStarts'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%BladeLoad)
   call RegPack(RF, InData%PlatformLoad)
   call RegPack(RF, InData%TowerLoad)
   call RegPack(RF, InData%HubLoad)
   call RegPack(RF, InData%NacelleLoad)
   call RegPack(RF, InData%TFinLoad)
   call RegPack(RF, InData%BlPitchCom)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ED_UnPackJac_u_idxStarts(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Jac_u_idxStarts), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ED_UnPackJac_u_idxStarts'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%BladeLoad); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PlatformLoad); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TowerLoad); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HubLoad); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NacelleLoad); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFinLoad); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BlPitchCom); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ED_CopyJac_y_idxStarts(SrcJac_y_idxStartsData, DstJac_y_idxStartsData, CtrlCode, ErrStat, ErrMsg)
   type(Jac_y_idxStarts), intent(in) :: SrcJac_y_idxStartsData
   type(Jac_y_idxStarts), intent(inout) :: DstJac_y_idxStartsData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ED_CopyJac_y_idxStarts'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstJac_y_idxStartsData%Blade = SrcJac_y_idxStartsData%Blade
   DstJac_y_idxStartsData%Platform = SrcJac_y_idxStartsData%Platform
   DstJac_y_idxStartsData%Tower = SrcJac_y_idxStartsData%Tower
   DstJac_y_idxStartsData%Hub = SrcJac_y_idxStartsData%Hub
   DstJac_y_idxStartsData%BladeRoot = SrcJac_y_idxStartsData%BladeRoot
   DstJac_y_idxStartsData%Nacelle = SrcJac_y_idxStartsData%Nacelle
   DstJac_y_idxStartsData%TFin = SrcJac_y_idxStartsData%TFin
end subroutine

subroutine ED_DestroyJac_y_idxStarts(Jac_y_idxStartsData, ErrStat, ErrMsg)
   type(Jac_y_idxStarts), intent(inout) :: Jac_y_idxStartsData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ED_DestroyJac_y_idxStarts'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine ED_PackJac_y_idxStarts(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Jac_y_idxStarts), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ED_PackJac_y_idxStarts'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%Blade)
   call RegPack(RF, InData%Platform)
   call RegPack(RF, InData%Tower)
   call RegPack(RF, InData%Hub)
   call RegPack(RF, InData%BladeRoot)
   call RegPack(RF, InData%Nacelle)
   call RegPack(RF, InData%TFin)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ED_UnPackJac_y_idxStarts(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Jac_y_idxStarts), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ED_UnPackJac_y_idxStarts'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%Blade); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Platform); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Tower); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Hub); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BladeRoot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Nacelle); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFin); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ED_CopyParam(SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg)
   type(ED_ParameterType), intent(in) :: SrcParamData
   type(ED_ParameterType), intent(inout) :: DstParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2, i3, i4, i5
   integer(B4Ki)                  :: LB(5), UB(5)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ED_CopyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstParamData%DT = SrcParamData%DT
   DstParamData%DT24 = SrcParamData%DT24
   DstParamData%BldNodes = SrcParamData%BldNodes
   DstParamData%TipNode = SrcParamData%TipNode
   DstParamData%NDOF = SrcParamData%NDOF
   DstParamData%TwoPiNB = SrcParamData%TwoPiNB
   DstParamData%NAug = SrcParamData%NAug
   DstParamData%NPH = SrcParamData%NPH
   if (allocated(SrcParamData%PH)) then
      LB(1:1) = lbound(SrcParamData%PH)
      UB(1:1) = ubound(SrcParamData%PH)
      if (.not. allocated(DstParamData%PH)) then
         allocate(DstParamData%PH(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%PH.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%PH = SrcParamData%PH
   end if
   DstParamData%NPM = SrcParamData%NPM
   if (allocated(SrcParamData%PM)) then
      LB(1:2) = lbound(SrcParamData%PM)
      UB(1:2) = ubound(SrcParamData%PM)
      if (.not. allocated(DstParamData%PM)) then
         allocate(DstParamData%PM(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%PM.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%PM = SrcParamData%PM
   end if
   if (allocated(SrcParamData%DOF_Flag)) then
      LB(1:1) = lbound(SrcParamData%DOF_Flag)
      UB(1:1) = ubound(SrcParamData%DOF_Flag)
      if (.not. allocated(DstParamData%DOF_Flag)) then
         allocate(DstParamData%DOF_Flag(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%DOF_Flag.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%DOF_Flag = SrcParamData%DOF_Flag
   end if
   if (allocated(SrcParamData%DOF_Desc)) then
      LB(1:1) = lbound(SrcParamData%DOF_Desc)
      UB(1:1) = ubound(SrcParamData%DOF_Desc)
      if (.not. allocated(DstParamData%DOF_Desc)) then
         allocate(DstParamData%DOF_Desc(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%DOF_Desc.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%DOF_Desc = SrcParamData%DOF_Desc
   end if
   call ED_CopyActiveDOFs(SrcParamData%DOFs, DstParamData%DOFs, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstParamData%NumOuts = SrcParamData%NumOuts
   DstParamData%OutFmt = SrcParamData%OutFmt
   DstParamData%NBlGages = SrcParamData%NBlGages
   DstParamData%NTwGages = SrcParamData%NTwGages
   if (allocated(SrcParamData%OutParam)) then
      LB(1:1) = lbound(SrcParamData%OutParam)
      UB(1:1) = ubound(SrcParamData%OutParam)
      if (.not. allocated(DstParamData%OutParam)) then
         allocate(DstParamData%OutParam(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%OutParam.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyOutParmType(SrcParamData%OutParam(i1), DstParamData%OutParam(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstParamData%Delim = SrcParamData%Delim
   DstParamData%AvgNrmTpRd = SrcParamData%AvgNrmTpRd
   DstParamData%AzimB1Up = SrcParamData%AzimB1Up
   DstParamData%CosDel3 = SrcParamData%CosDel3
   if (allocated(SrcParamData%CosPreC)) then
      LB(1:1) = lbound(SrcParamData%CosPreC)
      UB(1:1) = ubound(SrcParamData%CosPreC)
      if (.not. allocated(DstParamData%CosPreC)) then
         allocate(DstParamData%CosPreC(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%CosPreC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%CosPreC = SrcParamData%CosPreC
   end if
   DstParamData%CRFrlSkew = SrcParamData%CRFrlSkew
   DstParamData%CRFrlSkw2 = SrcParamData%CRFrlSkw2
   DstParamData%CRFrlTilt = SrcParamData%CRFrlTilt
   DstParamData%CRFrlTlt2 = SrcParamData%CRFrlTlt2
   DstParamData%CShftSkew = SrcParamData%CShftSkew
   DstParamData%CShftTilt = SrcParamData%CShftTilt
   DstParamData%CSRFrlSkw = SrcParamData%CSRFrlSkw
   DstParamData%CSRFrlTlt = SrcParamData%CSRFrlTlt
   DstParamData%CSTFrlSkw = SrcParamData%CSTFrlSkw
   DstParamData%CSTFrlTlt = SrcParamData%CSTFrlTlt
   DstParamData%CTFrlSkew = SrcParamData%CTFrlSkew
   DstParamData%CTFrlSkw2 = SrcParamData%CTFrlSkw2
   DstParamData%CTFrlTilt = SrcParamData%CTFrlTilt
   DstParamData%CTFrlTlt2 = SrcParamData%CTFrlTlt2
   DstParamData%HubHt = SrcParamData%HubHt
   DstParamData%HubCM = SrcParamData%HubCM
   DstParamData%HubRad = SrcParamData%HubRad
   DstParamData%NacCMxn = SrcParamData%NacCMxn
   DstParamData%NacCMyn = SrcParamData%NacCMyn
   DstParamData%NacCMzn = SrcParamData%NacCMzn
   DstParamData%OverHang = SrcParamData%OverHang
   DstParamData%ProjArea = SrcParamData%ProjArea
   DstParamData%PtfmRefzt = SrcParamData%PtfmRefzt
   DstParamData%RefTwrHt = SrcParamData%RefTwrHt
   DstParamData%RFrlPnt_n = SrcParamData%RFrlPnt_n
   DstParamData%rVDxn = SrcParamData%rVDxn
   DstParamData%rVDyn = SrcParamData%rVDyn
   DstParamData%rVDzn = SrcParamData%rVDzn
   DstParamData%rVIMUxn = SrcParamData%rVIMUxn
   DstParamData%rVIMUyn = SrcParamData%rVIMUyn
   DstParamData%rVIMUzn = SrcParamData%rVIMUzn
   DstParamData%rVPxn = SrcParamData%rVPxn
   DstParamData%rVPyn = SrcParamData%rVPyn
   DstParamData%rVPzn = SrcParamData%rVPzn
   DstParamData%rWIxn = SrcParamData%rWIxn
   DstParamData%rWIyn = SrcParamData%rWIyn
   DstParamData%rWIzn = SrcParamData%rWIzn
   DstParamData%rWJxn = SrcParamData%rWJxn
   DstParamData%rWJyn = SrcParamData%rWJyn
   DstParamData%rWJzn = SrcParamData%rWJzn
   DstParamData%rZT0zt = SrcParamData%rZT0zt
   DstParamData%rZYzt = SrcParamData%rZYzt
   DstParamData%SinDel3 = SrcParamData%SinDel3
   if (allocated(SrcParamData%SinPreC)) then
      LB(1:1) = lbound(SrcParamData%SinPreC)
      UB(1:1) = ubound(SrcParamData%SinPreC)
      if (.not. allocated(DstParamData%SinPreC)) then
         allocate(DstParamData%SinPreC(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%SinPreC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%SinPreC = SrcParamData%SinPreC
   end if
   DstParamData%SRFrlSkew = SrcParamData%SRFrlSkew
   DstParamData%SRFrlSkw2 = SrcParamData%SRFrlSkw2
   DstParamData%SRFrlTilt = SrcParamData%SRFrlTilt
   DstParamData%SRFrlTlt2 = SrcParamData%SRFrlTlt2
   DstParamData%SShftSkew = SrcParamData%SShftSkew
   DstParamData%SShftTilt = SrcParamData%SShftTilt
   DstParamData%STFrlSkew = SrcParamData%STFrlSkew
   DstParamData%STFrlSkw2 = SrcParamData%STFrlSkw2
   DstParamData%STFrlTilt = SrcParamData%STFrlTilt
   DstParamData%STFrlTlt2 = SrcParamData%STFrlTlt2
   DstParamData%TFrlPnt_n = SrcParamData%TFrlPnt_n
   DstParamData%TipRad = SrcParamData%TipRad
   DstParamData%TowerHt = SrcParamData%TowerHt
   DstParamData%TowerBsHt = SrcParamData%TowerBsHt
   DstParamData%UndSling = SrcParamData%UndSling
   DstParamData%NumBl = SrcParamData%NumBl
   if (allocated(SrcParamData%AxRedTFA)) then
      LB(1:3) = lbound(SrcParamData%AxRedTFA)
      UB(1:3) = ubound(SrcParamData%AxRedTFA)
      if (.not. allocated(DstParamData%AxRedTFA)) then
         allocate(DstParamData%AxRedTFA(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%AxRedTFA.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%AxRedTFA = SrcParamData%AxRedTFA
   end if
   if (allocated(SrcParamData%AxRedTSS)) then
      LB(1:3) = lbound(SrcParamData%AxRedTSS)
      UB(1:3) = ubound(SrcParamData%AxRedTSS)
      if (.not. allocated(DstParamData%AxRedTSS)) then
         allocate(DstParamData%AxRedTSS(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%AxRedTSS.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%AxRedTSS = SrcParamData%AxRedTSS
   end if
   DstParamData%CTFA = SrcParamData%CTFA
   DstParamData%CTSS = SrcParamData%CTSS
   if (allocated(SrcParamData%DHNodes)) then
      LB(1:1) = lbound(SrcParamData%DHNodes)
      UB(1:1) = ubound(SrcParamData%DHNodes)
      if (.not. allocated(DstParamData%DHNodes)) then
         allocate(DstParamData%DHNodes(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%DHNodes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%DHNodes = SrcParamData%DHNodes
   end if
   if (allocated(SrcParamData%HNodes)) then
      LB(1:1) = lbound(SrcParamData%HNodes)
      UB(1:1) = ubound(SrcParamData%HNodes)
      if (.not. allocated(DstParamData%HNodes)) then
         allocate(DstParamData%HNodes(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%HNodes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%HNodes = SrcParamData%HNodes
   end if
   if (allocated(SrcParamData%HNodesNorm)) then
      LB(1:1) = lbound(SrcParamData%HNodesNorm)
      UB(1:1) = ubound(SrcParamData%HNodesNorm)
      if (.not. allocated(DstParamData%HNodesNorm)) then
         allocate(DstParamData%HNodesNorm(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%HNodesNorm.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%HNodesNorm = SrcParamData%HNodesNorm
   end if
   DstParamData%KTFA = SrcParamData%KTFA
   DstParamData%KTSS = SrcParamData%KTSS
   if (allocated(SrcParamData%MassT)) then
      LB(1:1) = lbound(SrcParamData%MassT)
      UB(1:1) = ubound(SrcParamData%MassT)
      if (.not. allocated(DstParamData%MassT)) then
         allocate(DstParamData%MassT(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%MassT.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%MassT = SrcParamData%MassT
   end if
   if (allocated(SrcParamData%StiffTSS)) then
      LB(1:1) = lbound(SrcParamData%StiffTSS)
      UB(1:1) = ubound(SrcParamData%StiffTSS)
      if (.not. allocated(DstParamData%StiffTSS)) then
         allocate(DstParamData%StiffTSS(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%StiffTSS.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%StiffTSS = SrcParamData%StiffTSS
   end if
   if (allocated(SrcParamData%TwrFASF)) then
      LB(1:3) = lbound(SrcParamData%TwrFASF)
      UB(1:3) = ubound(SrcParamData%TwrFASF)
      if (.not. allocated(DstParamData%TwrFASF)) then
         allocate(DstParamData%TwrFASF(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%TwrFASF.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%TwrFASF = SrcParamData%TwrFASF
   end if
   DstParamData%TwrFlexL = SrcParamData%TwrFlexL
   if (allocated(SrcParamData%TwrSSSF)) then
      LB(1:3) = lbound(SrcParamData%TwrSSSF)
      UB(1:3) = ubound(SrcParamData%TwrSSSF)
      if (.not. allocated(DstParamData%TwrSSSF)) then
         allocate(DstParamData%TwrSSSF(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%TwrSSSF.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%TwrSSSF = SrcParamData%TwrSSSF
   end if
   DstParamData%TTopNode = SrcParamData%TTopNode
   DstParamData%TwrNodes = SrcParamData%TwrNodes
   DstParamData%MHK = SrcParamData%MHK
   if (allocated(SrcParamData%StiffTFA)) then
      LB(1:1) = lbound(SrcParamData%StiffTFA)
      UB(1:1) = ubound(SrcParamData%StiffTFA)
      if (.not. allocated(DstParamData%StiffTFA)) then
         allocate(DstParamData%StiffTFA(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%StiffTFA.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%StiffTFA = SrcParamData%StiffTFA
   end if
   DstParamData%AtfaIner = SrcParamData%AtfaIner
   if (allocated(SrcParamData%BldCG)) then
      LB(1:1) = lbound(SrcParamData%BldCG)
      UB(1:1) = ubound(SrcParamData%BldCG)
      if (.not. allocated(DstParamData%BldCG)) then
         allocate(DstParamData%BldCG(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%BldCG.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%BldCG = SrcParamData%BldCG
   end if
   if (allocated(SrcParamData%BldMass)) then
      LB(1:1) = lbound(SrcParamData%BldMass)
      UB(1:1) = ubound(SrcParamData%BldMass)
      if (.not. allocated(DstParamData%BldMass)) then
         allocate(DstParamData%BldMass(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%BldMass.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%BldMass = SrcParamData%BldMass
   end if
   DstParamData%BoomMass = SrcParamData%BoomMass
   if (allocated(SrcParamData%FirstMom)) then
      LB(1:1) = lbound(SrcParamData%FirstMom)
      UB(1:1) = ubound(SrcParamData%FirstMom)
      if (.not. allocated(DstParamData%FirstMom)) then
         allocate(DstParamData%FirstMom(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%FirstMom.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%FirstMom = SrcParamData%FirstMom
   end if
   DstParamData%GenIner = SrcParamData%GenIner
   DstParamData%Hubg1Iner = SrcParamData%Hubg1Iner
   DstParamData%Hubg2Iner = SrcParamData%Hubg2Iner
   DstParamData%HubMass = SrcParamData%HubMass
   DstParamData%Nacd2Iner = SrcParamData%Nacd2Iner
   DstParamData%NacMass = SrcParamData%NacMass
   DstParamData%PtfmMass = SrcParamData%PtfmMass
   DstParamData%PtfmPIner = SrcParamData%PtfmPIner
   DstParamData%PtfmRIner = SrcParamData%PtfmRIner
   DstParamData%PtfmYIner = SrcParamData%PtfmYIner
   DstParamData%PtfmXYIner = SrcParamData%PtfmXYIner
   DstParamData%PtfmYZIner = SrcParamData%PtfmYZIner
   DstParamData%PtfmXZIner = SrcParamData%PtfmXZIner
   DstParamData%RFrlMass = SrcParamData%RFrlMass
   DstParamData%RotIner = SrcParamData%RotIner
   DstParamData%RotMass = SrcParamData%RotMass
   DstParamData%RrfaIner = SrcParamData%RrfaIner
   if (allocated(SrcParamData%SecondMom)) then
      LB(1:1) = lbound(SrcParamData%SecondMom)
      UB(1:1) = ubound(SrcParamData%SecondMom)
      if (.not. allocated(DstParamData%SecondMom)) then
         allocate(DstParamData%SecondMom(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%SecondMom.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%SecondMom = SrcParamData%SecondMom
   end if
   DstParamData%TFinMass = SrcParamData%TFinMass
   DstParamData%TFrlIner = SrcParamData%TFrlIner
   if (allocated(SrcParamData%TipMass)) then
      LB(1:1) = lbound(SrcParamData%TipMass)
      UB(1:1) = ubound(SrcParamData%TipMass)
      if (.not. allocated(DstParamData%TipMass)) then
         allocate(DstParamData%TipMass(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%TipMass.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%TipMass = SrcParamData%TipMass
   end if
   DstParamData%TurbMass = SrcParamData%TurbMass
   DstParamData%TwrMass = SrcParamData%TwrMass
   DstParamData%TwrTpMass = SrcParamData%TwrTpMass
   DstParamData%YawBrMass = SrcParamData%YawBrMass
   DstParamData%Gravity = SrcParamData%Gravity
   if (allocated(SrcParamData%PitchAxis)) then
      LB(1:2) = lbound(SrcParamData%PitchAxis)
      UB(1:2) = ubound(SrcParamData%PitchAxis)
      if (.not. allocated(DstParamData%PitchAxis)) then
         allocate(DstParamData%PitchAxis(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%PitchAxis.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%PitchAxis = SrcParamData%PitchAxis
   end if
   if (allocated(SrcParamData%AeroTwst)) then
      LB(1:1) = lbound(SrcParamData%AeroTwst)
      UB(1:1) = ubound(SrcParamData%AeroTwst)
      if (.not. allocated(DstParamData%AeroTwst)) then
         allocate(DstParamData%AeroTwst(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%AeroTwst.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%AeroTwst = SrcParamData%AeroTwst
   end if
   if (allocated(SrcParamData%AxRedBld)) then
      LB(1:4) = lbound(SrcParamData%AxRedBld)
      UB(1:4) = ubound(SrcParamData%AxRedBld)
      if (.not. allocated(DstParamData%AxRedBld)) then
         allocate(DstParamData%AxRedBld(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%AxRedBld.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%AxRedBld = SrcParamData%AxRedBld
   end if
   if (allocated(SrcParamData%BldEDamp)) then
      LB(1:2) = lbound(SrcParamData%BldEDamp)
      UB(1:2) = ubound(SrcParamData%BldEDamp)
      if (.not. allocated(DstParamData%BldEDamp)) then
         allocate(DstParamData%BldEDamp(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%BldEDamp.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%BldEDamp = SrcParamData%BldEDamp
   end if
   if (allocated(SrcParamData%BldFDamp)) then
      LB(1:2) = lbound(SrcParamData%BldFDamp)
      UB(1:2) = ubound(SrcParamData%BldFDamp)
      if (.not. allocated(DstParamData%BldFDamp)) then
         allocate(DstParamData%BldFDamp(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%BldFDamp.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%BldFDamp = SrcParamData%BldFDamp
   end if
   DstParamData%BldFlexL = SrcParamData%BldFlexL
   if (allocated(SrcParamData%CAeroTwst)) then
      LB(1:1) = lbound(SrcParamData%CAeroTwst)
      UB(1:1) = ubound(SrcParamData%CAeroTwst)
      if (.not. allocated(DstParamData%CAeroTwst)) then
         allocate(DstParamData%CAeroTwst(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%CAeroTwst.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%CAeroTwst = SrcParamData%CAeroTwst
   end if
   if (allocated(SrcParamData%CBE)) then
      LB(1:3) = lbound(SrcParamData%CBE)
      UB(1:3) = ubound(SrcParamData%CBE)
      if (.not. allocated(DstParamData%CBE)) then
         allocate(DstParamData%CBE(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%CBE.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%CBE = SrcParamData%CBE
   end if
   if (allocated(SrcParamData%CBF)) then
      LB(1:3) = lbound(SrcParamData%CBF)
      UB(1:3) = ubound(SrcParamData%CBF)
      if (.not. allocated(DstParamData%CBF)) then
         allocate(DstParamData%CBF(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%CBF.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%CBF = SrcParamData%CBF
   end if
   if (allocated(SrcParamData%Chord)) then
      LB(1:1) = lbound(SrcParamData%Chord)
      UB(1:1) = ubound(SrcParamData%Chord)
      if (.not. allocated(DstParamData%Chord)) then
         allocate(DstParamData%Chord(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Chord.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Chord = SrcParamData%Chord
   end if
   if (allocated(SrcParamData%CThetaS)) then
      LB(1:2) = lbound(SrcParamData%CThetaS)
      UB(1:2) = ubound(SrcParamData%CThetaS)
      if (.not. allocated(DstParamData%CThetaS)) then
         allocate(DstParamData%CThetaS(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%CThetaS.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%CThetaS = SrcParamData%CThetaS
   end if
   if (allocated(SrcParamData%DRNodes)) then
      LB(1:1) = lbound(SrcParamData%DRNodes)
      UB(1:1) = ubound(SrcParamData%DRNodes)
      if (.not. allocated(DstParamData%DRNodes)) then
         allocate(DstParamData%DRNodes(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%DRNodes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%DRNodes = SrcParamData%DRNodes
   end if
   if (allocated(SrcParamData%FStTunr)) then
      LB(1:2) = lbound(SrcParamData%FStTunr)
      UB(1:2) = ubound(SrcParamData%FStTunr)
      if (.not. allocated(DstParamData%FStTunr)) then
         allocate(DstParamData%FStTunr(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%FStTunr.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%FStTunr = SrcParamData%FStTunr
   end if
   if (allocated(SrcParamData%KBE)) then
      LB(1:3) = lbound(SrcParamData%KBE)
      UB(1:3) = ubound(SrcParamData%KBE)
      if (.not. allocated(DstParamData%KBE)) then
         allocate(DstParamData%KBE(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%KBE.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%KBE = SrcParamData%KBE
   end if
   if (allocated(SrcParamData%KBF)) then
      LB(1:3) = lbound(SrcParamData%KBF)
      UB(1:3) = ubound(SrcParamData%KBF)
      if (.not. allocated(DstParamData%KBF)) then
         allocate(DstParamData%KBF(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%KBF.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%KBF = SrcParamData%KBF
   end if
   if (allocated(SrcParamData%MassB)) then
      LB(1:2) = lbound(SrcParamData%MassB)
      UB(1:2) = ubound(SrcParamData%MassB)
      if (.not. allocated(DstParamData%MassB)) then
         allocate(DstParamData%MassB(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%MassB.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%MassB = SrcParamData%MassB
   end if
   if (allocated(SrcParamData%RNodes)) then
      LB(1:1) = lbound(SrcParamData%RNodes)
      UB(1:1) = ubound(SrcParamData%RNodes)
      if (.not. allocated(DstParamData%RNodes)) then
         allocate(DstParamData%RNodes(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%RNodes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%RNodes = SrcParamData%RNodes
   end if
   if (allocated(SrcParamData%RNodesNorm)) then
      LB(1:1) = lbound(SrcParamData%RNodesNorm)
      UB(1:1) = ubound(SrcParamData%RNodesNorm)
      if (.not. allocated(DstParamData%RNodesNorm)) then
         allocate(DstParamData%RNodesNorm(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%RNodesNorm.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%RNodesNorm = SrcParamData%RNodesNorm
   end if
   if (allocated(SrcParamData%rSAerCenn1)) then
      LB(1:2) = lbound(SrcParamData%rSAerCenn1)
      UB(1:2) = ubound(SrcParamData%rSAerCenn1)
      if (.not. allocated(DstParamData%rSAerCenn1)) then
         allocate(DstParamData%rSAerCenn1(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%rSAerCenn1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%rSAerCenn1 = SrcParamData%rSAerCenn1
   end if
   if (allocated(SrcParamData%rSAerCenn2)) then
      LB(1:2) = lbound(SrcParamData%rSAerCenn2)
      UB(1:2) = ubound(SrcParamData%rSAerCenn2)
      if (.not. allocated(DstParamData%rSAerCenn2)) then
         allocate(DstParamData%rSAerCenn2(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%rSAerCenn2.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%rSAerCenn2 = SrcParamData%rSAerCenn2
   end if
   if (allocated(SrcParamData%SAeroTwst)) then
      LB(1:1) = lbound(SrcParamData%SAeroTwst)
      UB(1:1) = ubound(SrcParamData%SAeroTwst)
      if (.not. allocated(DstParamData%SAeroTwst)) then
         allocate(DstParamData%SAeroTwst(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%SAeroTwst.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%SAeroTwst = SrcParamData%SAeroTwst
   end if
   if (allocated(SrcParamData%StiffBE)) then
      LB(1:2) = lbound(SrcParamData%StiffBE)
      UB(1:2) = ubound(SrcParamData%StiffBE)
      if (.not. allocated(DstParamData%StiffBE)) then
         allocate(DstParamData%StiffBE(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%StiffBE.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%StiffBE = SrcParamData%StiffBE
   end if
   if (allocated(SrcParamData%StiffBF)) then
      LB(1:2) = lbound(SrcParamData%StiffBF)
      UB(1:2) = ubound(SrcParamData%StiffBF)
      if (.not. allocated(DstParamData%StiffBF)) then
         allocate(DstParamData%StiffBF(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%StiffBF.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%StiffBF = SrcParamData%StiffBF
   end if
   if (allocated(SrcParamData%SThetaS)) then
      LB(1:2) = lbound(SrcParamData%SThetaS)
      UB(1:2) = ubound(SrcParamData%SThetaS)
      if (.not. allocated(DstParamData%SThetaS)) then
         allocate(DstParamData%SThetaS(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%SThetaS.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%SThetaS = SrcParamData%SThetaS
   end if
   if (allocated(SrcParamData%ThetaS)) then
      LB(1:2) = lbound(SrcParamData%ThetaS)
      UB(1:2) = ubound(SrcParamData%ThetaS)
      if (.not. allocated(DstParamData%ThetaS)) then
         allocate(DstParamData%ThetaS(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%ThetaS.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%ThetaS = SrcParamData%ThetaS
   end if
   if (allocated(SrcParamData%TwistedSF)) then
      LB(1:5) = lbound(SrcParamData%TwistedSF)
      UB(1:5) = ubound(SrcParamData%TwistedSF)
      if (.not. allocated(DstParamData%TwistedSF)) then
         allocate(DstParamData%TwistedSF(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4),LB(5):UB(5)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%TwistedSF.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%TwistedSF = SrcParamData%TwistedSF
   end if
   if (allocated(SrcParamData%BldFl1Sh)) then
      LB(1:2) = lbound(SrcParamData%BldFl1Sh)
      UB(1:2) = ubound(SrcParamData%BldFl1Sh)
      if (.not. allocated(DstParamData%BldFl1Sh)) then
         allocate(DstParamData%BldFl1Sh(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%BldFl1Sh.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%BldFl1Sh = SrcParamData%BldFl1Sh
   end if
   if (allocated(SrcParamData%BldFl2Sh)) then
      LB(1:2) = lbound(SrcParamData%BldFl2Sh)
      UB(1:2) = ubound(SrcParamData%BldFl2Sh)
      if (.not. allocated(DstParamData%BldFl2Sh)) then
         allocate(DstParamData%BldFl2Sh(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%BldFl2Sh.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%BldFl2Sh = SrcParamData%BldFl2Sh
   end if
   if (allocated(SrcParamData%BldEdgSh)) then
      LB(1:2) = lbound(SrcParamData%BldEdgSh)
      UB(1:2) = ubound(SrcParamData%BldEdgSh)
      if (.not. allocated(DstParamData%BldEdgSh)) then
         allocate(DstParamData%BldEdgSh(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%BldEdgSh.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%BldEdgSh = SrcParamData%BldEdgSh
   end if
   if (allocated(SrcParamData%FreqBE)) then
      LB(1:3) = lbound(SrcParamData%FreqBE)
      UB(1:3) = ubound(SrcParamData%FreqBE)
      if (.not. allocated(DstParamData%FreqBE)) then
         allocate(DstParamData%FreqBE(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%FreqBE.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%FreqBE = SrcParamData%FreqBE
   end if
   if (allocated(SrcParamData%FreqBF)) then
      LB(1:3) = lbound(SrcParamData%FreqBF)
      UB(1:3) = ubound(SrcParamData%FreqBF)
      if (.not. allocated(DstParamData%FreqBF)) then
         allocate(DstParamData%FreqBF(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%FreqBF.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%FreqBF = SrcParamData%FreqBF
   end if
   DstParamData%FreqTFA = SrcParamData%FreqTFA
   DstParamData%FreqTSS = SrcParamData%FreqTSS
   DstParamData%TeetCDmp = SrcParamData%TeetCDmp
   DstParamData%TeetDmp = SrcParamData%TeetDmp
   DstParamData%TeetDmpP = SrcParamData%TeetDmpP
   DstParamData%TeetHSSp = SrcParamData%TeetHSSp
   DstParamData%TeetHStP = SrcParamData%TeetHStP
   DstParamData%TeetSSSp = SrcParamData%TeetSSSp
   DstParamData%TeetSStP = SrcParamData%TeetSStP
   DstParamData%TeetMod = SrcParamData%TeetMod
   DstParamData%TFrlDmp = SrcParamData%TFrlDmp
   DstParamData%TFrlDSDmp = SrcParamData%TFrlDSDmp
   DstParamData%TFrlDSDP = SrcParamData%TFrlDSDP
   DstParamData%TFrlDSSP = SrcParamData%TFrlDSSP
   DstParamData%TFrlDSSpr = SrcParamData%TFrlDSSpr
   DstParamData%TFrlSpr = SrcParamData%TFrlSpr
   DstParamData%TFrlUSDmp = SrcParamData%TFrlUSDmp
   DstParamData%TFrlUSDP = SrcParamData%TFrlUSDP
   DstParamData%TFrlUSSP = SrcParamData%TFrlUSSP
   DstParamData%TFrlUSSpr = SrcParamData%TFrlUSSpr
   DstParamData%TFrlMod = SrcParamData%TFrlMod
   DstParamData%RFrlDmp = SrcParamData%RFrlDmp
   DstParamData%RFrlDSDmp = SrcParamData%RFrlDSDmp
   DstParamData%RFrlDSDP = SrcParamData%RFrlDSDP
   DstParamData%RFrlDSSP = SrcParamData%RFrlDSSP
   DstParamData%RFrlDSSpr = SrcParamData%RFrlDSSpr
   DstParamData%RFrlSpr = SrcParamData%RFrlSpr
   DstParamData%RFrlUSDmp = SrcParamData%RFrlUSDmp
   DstParamData%RFrlUSDP = SrcParamData%RFrlUSDP
   DstParamData%RFrlUSSP = SrcParamData%RFrlUSSP
   DstParamData%RFrlUSSpr = SrcParamData%RFrlUSSpr
   DstParamData%RFrlMod = SrcParamData%RFrlMod
   DstParamData%ShftGagL = SrcParamData%ShftGagL
   DstParamData%BldGagNd = SrcParamData%BldGagNd
   DstParamData%TwrGagNd = SrcParamData%TwrGagNd
   DstParamData%TStart = SrcParamData%TStart
   DstParamData%DTTorDmp = SrcParamData%DTTorDmp
   DstParamData%DTTorSpr = SrcParamData%DTTorSpr
   DstParamData%GBRatio = SrcParamData%GBRatio
   DstParamData%GBoxEff = SrcParamData%GBoxEff
   DstParamData%RotSpeed = SrcParamData%RotSpeed
   DstParamData%RootName = SrcParamData%RootName
   if (allocated(SrcParamData%BElmntMass)) then
      LB(1:2) = lbound(SrcParamData%BElmntMass)
      UB(1:2) = ubound(SrcParamData%BElmntMass)
      if (.not. allocated(DstParamData%BElmntMass)) then
         allocate(DstParamData%BElmntMass(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%BElmntMass.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%BElmntMass = SrcParamData%BElmntMass
   end if
   if (allocated(SrcParamData%TElmntMass)) then
      LB(1:1) = lbound(SrcParamData%TElmntMass)
      UB(1:1) = ubound(SrcParamData%TElmntMass)
      if (.not. allocated(DstParamData%TElmntMass)) then
         allocate(DstParamData%TElmntMass(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%TElmntMass.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%TElmntMass = SrcParamData%TElmntMass
   end if
   DstParamData%method = SrcParamData%method
   DstParamData%PtfmCMxt = SrcParamData%PtfmCMxt
   DstParamData%PtfmCMyt = SrcParamData%PtfmCMyt
   DstParamData%BD4Blades = SrcParamData%BD4Blades
   DstParamData%RigidAero = SrcParamData%RigidAero
   DstParamData%YawFrctMod = SrcParamData%YawFrctMod
   DstParamData%M_CD = SrcParamData%M_CD
   DstParamData%M_FCD = SrcParamData%M_FCD
   DstParamData%M_MCD = SrcParamData%M_MCD
   DstParamData%M_CSMAX = SrcParamData%M_CSMAX
   DstParamData%M_FCSMAX = SrcParamData%M_FCSMAX
   DstParamData%M_MCSMAX = SrcParamData%M_MCSMAX
   DstParamData%sig_v = SrcParamData%sig_v
   DstParamData%sig_v2 = SrcParamData%sig_v2
   DstParamData%OmgCut = SrcParamData%OmgCut
   DstParamData%BldNd_NumOuts = SrcParamData%BldNd_NumOuts
   DstParamData%BldNd_TotNumOuts = SrcParamData%BldNd_TotNumOuts
   if (allocated(SrcParamData%BldNd_OutParam)) then
      LB(1:1) = lbound(SrcParamData%BldNd_OutParam)
      UB(1:1) = ubound(SrcParamData%BldNd_OutParam)
      if (.not. allocated(DstParamData%BldNd_OutParam)) then
         allocate(DstParamData%BldNd_OutParam(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%BldNd_OutParam.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyOutParmType(SrcParamData%BldNd_OutParam(i1), DstParamData%BldNd_OutParam(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstParamData%BldNd_BladesOut = SrcParamData%BldNd_BladesOut
   call ED_CopyJac_u_idxStarts(SrcParamData%Jac_u_idxStartList, DstParamData%Jac_u_idxStartList, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call ED_CopyJac_y_idxStarts(SrcParamData%Jac_y_idxStartList, DstParamData%Jac_y_idxStartList, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcParamData%Jac_u_indx)) then
      LB(1:2) = lbound(SrcParamData%Jac_u_indx)
      UB(1:2) = ubound(SrcParamData%Jac_u_indx)
      if (.not. allocated(DstParamData%Jac_u_indx)) then
         allocate(DstParamData%Jac_u_indx(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Jac_u_indx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Jac_u_indx = SrcParamData%Jac_u_indx
   end if
   if (allocated(SrcParamData%du)) then
      LB(1:1) = lbound(SrcParamData%du)
      UB(1:1) = ubound(SrcParamData%du)
      if (.not. allocated(DstParamData%du)) then
         allocate(DstParamData%du(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%du.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%du = SrcParamData%du
   end if
   if (allocated(SrcParamData%dx)) then
      LB(1:1) = lbound(SrcParamData%dx)
      UB(1:1) = ubound(SrcParamData%dx)
      if (.not. allocated(DstParamData%dx)) then
         allocate(DstParamData%dx(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%dx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%dx = SrcParamData%dx
   end if
   DstParamData%Jac_ny = SrcParamData%Jac_ny
   DstParamData%CompAeroMaps = SrcParamData%CompAeroMaps
   DstParamData%NumExtendedInputs = SrcParamData%NumExtendedInputs
   DstParamData%NumBl_Lin = SrcParamData%NumBl_Lin
   DstParamData%NActvVelDOF_Lin = SrcParamData%NActvVelDOF_Lin
   DstParamData%NActvDOF_Lin = SrcParamData%NActvDOF_Lin
   DstParamData%NActvDOF_Stride = SrcParamData%NActvDOF_Stride
end subroutine

subroutine ED_DestroyParam(ParamData, ErrStat, ErrMsg)
   type(ED_ParameterType), intent(inout) :: ParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2, i3, i4, i5
   integer(B4Ki)   :: LB(5), UB(5)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ED_DestroyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ParamData%PH)) then
      deallocate(ParamData%PH)
   end if
   if (allocated(ParamData%PM)) then
      deallocate(ParamData%PM)
   end if
   if (allocated(ParamData%DOF_Flag)) then
      deallocate(ParamData%DOF_Flag)
   end if
   if (allocated(ParamData%DOF_Desc)) then
      deallocate(ParamData%DOF_Desc)
   end if
   call ED_DestroyActiveDOFs(ParamData%DOFs, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(ParamData%OutParam)) then
      LB(1:1) = lbound(ParamData%OutParam)
      UB(1:1) = ubound(ParamData%OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyOutParmType(ParamData%OutParam(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%OutParam)
   end if
   if (allocated(ParamData%CosPreC)) then
      deallocate(ParamData%CosPreC)
   end if
   if (allocated(ParamData%SinPreC)) then
      deallocate(ParamData%SinPreC)
   end if
   if (allocated(ParamData%AxRedTFA)) then
      deallocate(ParamData%AxRedTFA)
   end if
   if (allocated(ParamData%AxRedTSS)) then
      deallocate(ParamData%AxRedTSS)
   end if
   if (allocated(ParamData%DHNodes)) then
      deallocate(ParamData%DHNodes)
   end if
   if (allocated(ParamData%HNodes)) then
      deallocate(ParamData%HNodes)
   end if
   if (allocated(ParamData%HNodesNorm)) then
      deallocate(ParamData%HNodesNorm)
   end if
   if (allocated(ParamData%MassT)) then
      deallocate(ParamData%MassT)
   end if
   if (allocated(ParamData%StiffTSS)) then
      deallocate(ParamData%StiffTSS)
   end if
   if (allocated(ParamData%TwrFASF)) then
      deallocate(ParamData%TwrFASF)
   end if
   if (allocated(ParamData%TwrSSSF)) then
      deallocate(ParamData%TwrSSSF)
   end if
   if (allocated(ParamData%StiffTFA)) then
      deallocate(ParamData%StiffTFA)
   end if
   if (allocated(ParamData%BldCG)) then
      deallocate(ParamData%BldCG)
   end if
   if (allocated(ParamData%BldMass)) then
      deallocate(ParamData%BldMass)
   end if
   if (allocated(ParamData%FirstMom)) then
      deallocate(ParamData%FirstMom)
   end if
   if (allocated(ParamData%SecondMom)) then
      deallocate(ParamData%SecondMom)
   end if
   if (allocated(ParamData%TipMass)) then
      deallocate(ParamData%TipMass)
   end if
   if (allocated(ParamData%PitchAxis)) then
      deallocate(ParamData%PitchAxis)
   end if
   if (allocated(ParamData%AeroTwst)) then
      deallocate(ParamData%AeroTwst)
   end if
   if (allocated(ParamData%AxRedBld)) then
      deallocate(ParamData%AxRedBld)
   end if
   if (allocated(ParamData%BldEDamp)) then
      deallocate(ParamData%BldEDamp)
   end if
   if (allocated(ParamData%BldFDamp)) then
      deallocate(ParamData%BldFDamp)
   end if
   if (allocated(ParamData%CAeroTwst)) then
      deallocate(ParamData%CAeroTwst)
   end if
   if (allocated(ParamData%CBE)) then
      deallocate(ParamData%CBE)
   end if
   if (allocated(ParamData%CBF)) then
      deallocate(ParamData%CBF)
   end if
   if (allocated(ParamData%Chord)) then
      deallocate(ParamData%Chord)
   end if
   if (allocated(ParamData%CThetaS)) then
      deallocate(ParamData%CThetaS)
   end if
   if (allocated(ParamData%DRNodes)) then
      deallocate(ParamData%DRNodes)
   end if
   if (allocated(ParamData%FStTunr)) then
      deallocate(ParamData%FStTunr)
   end if
   if (allocated(ParamData%KBE)) then
      deallocate(ParamData%KBE)
   end if
   if (allocated(ParamData%KBF)) then
      deallocate(ParamData%KBF)
   end if
   if (allocated(ParamData%MassB)) then
      deallocate(ParamData%MassB)
   end if
   if (allocated(ParamData%RNodes)) then
      deallocate(ParamData%RNodes)
   end if
   if (allocated(ParamData%RNodesNorm)) then
      deallocate(ParamData%RNodesNorm)
   end if
   if (allocated(ParamData%rSAerCenn1)) then
      deallocate(ParamData%rSAerCenn1)
   end if
   if (allocated(ParamData%rSAerCenn2)) then
      deallocate(ParamData%rSAerCenn2)
   end if
   if (allocated(ParamData%SAeroTwst)) then
      deallocate(ParamData%SAeroTwst)
   end if
   if (allocated(ParamData%StiffBE)) then
      deallocate(ParamData%StiffBE)
   end if
   if (allocated(ParamData%StiffBF)) then
      deallocate(ParamData%StiffBF)
   end if
   if (allocated(ParamData%SThetaS)) then
      deallocate(ParamData%SThetaS)
   end if
   if (allocated(ParamData%ThetaS)) then
      deallocate(ParamData%ThetaS)
   end if
   if (allocated(ParamData%TwistedSF)) then
      deallocate(ParamData%TwistedSF)
   end if
   if (allocated(ParamData%BldFl1Sh)) then
      deallocate(ParamData%BldFl1Sh)
   end if
   if (allocated(ParamData%BldFl2Sh)) then
      deallocate(ParamData%BldFl2Sh)
   end if
   if (allocated(ParamData%BldEdgSh)) then
      deallocate(ParamData%BldEdgSh)
   end if
   if (allocated(ParamData%FreqBE)) then
      deallocate(ParamData%FreqBE)
   end if
   if (allocated(ParamData%FreqBF)) then
      deallocate(ParamData%FreqBF)
   end if
   if (allocated(ParamData%BElmntMass)) then
      deallocate(ParamData%BElmntMass)
   end if
   if (allocated(ParamData%TElmntMass)) then
      deallocate(ParamData%TElmntMass)
   end if
   if (allocated(ParamData%BldNd_OutParam)) then
      LB(1:1) = lbound(ParamData%BldNd_OutParam)
      UB(1:1) = ubound(ParamData%BldNd_OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyOutParmType(ParamData%BldNd_OutParam(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%BldNd_OutParam)
   end if
   call ED_DestroyJac_u_idxStarts(ParamData%Jac_u_idxStartList, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call ED_DestroyJac_y_idxStarts(ParamData%Jac_y_idxStartList, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(ParamData%Jac_u_indx)) then
      deallocate(ParamData%Jac_u_indx)
   end if
   if (allocated(ParamData%du)) then
      deallocate(ParamData%du)
   end if
   if (allocated(ParamData%dx)) then
      deallocate(ParamData%dx)
   end if
end subroutine

subroutine ED_PackParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ED_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ED_PackParam'
   integer(B4Ki)   :: i1, i2, i3, i4, i5
   integer(B4Ki)   :: LB(5), UB(5)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DT)
   call RegPack(RF, InData%DT24)
   call RegPack(RF, InData%BldNodes)
   call RegPack(RF, InData%TipNode)
   call RegPack(RF, InData%NDOF)
   call RegPack(RF, InData%TwoPiNB)
   call RegPack(RF, InData%NAug)
   call RegPack(RF, InData%NPH)
   call RegPackAlloc(RF, InData%PH)
   call RegPack(RF, InData%NPM)
   call RegPackAlloc(RF, InData%PM)
   call RegPackAlloc(RF, InData%DOF_Flag)
   call RegPackAlloc(RF, InData%DOF_Desc)
   call ED_PackActiveDOFs(RF, InData%DOFs) 
   call RegPack(RF, InData%NumOuts)
   call RegPack(RF, InData%OutFmt)
   call RegPack(RF, InData%NBlGages)
   call RegPack(RF, InData%NTwGages)
   call RegPack(RF, allocated(InData%OutParam))
   if (allocated(InData%OutParam)) then
      call RegPackBounds(RF, 1, lbound(InData%OutParam), ubound(InData%OutParam))
      LB(1:1) = lbound(InData%OutParam)
      UB(1:1) = ubound(InData%OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackOutParmType(RF, InData%OutParam(i1)) 
      end do
   end if
   call RegPack(RF, InData%Delim)
   call RegPack(RF, InData%AvgNrmTpRd)
   call RegPack(RF, InData%AzimB1Up)
   call RegPack(RF, InData%CosDel3)
   call RegPackAlloc(RF, InData%CosPreC)
   call RegPack(RF, InData%CRFrlSkew)
   call RegPack(RF, InData%CRFrlSkw2)
   call RegPack(RF, InData%CRFrlTilt)
   call RegPack(RF, InData%CRFrlTlt2)
   call RegPack(RF, InData%CShftSkew)
   call RegPack(RF, InData%CShftTilt)
   call RegPack(RF, InData%CSRFrlSkw)
   call RegPack(RF, InData%CSRFrlTlt)
   call RegPack(RF, InData%CSTFrlSkw)
   call RegPack(RF, InData%CSTFrlTlt)
   call RegPack(RF, InData%CTFrlSkew)
   call RegPack(RF, InData%CTFrlSkw2)
   call RegPack(RF, InData%CTFrlTilt)
   call RegPack(RF, InData%CTFrlTlt2)
   call RegPack(RF, InData%HubHt)
   call RegPack(RF, InData%HubCM)
   call RegPack(RF, InData%HubRad)
   call RegPack(RF, InData%NacCMxn)
   call RegPack(RF, InData%NacCMyn)
   call RegPack(RF, InData%NacCMzn)
   call RegPack(RF, InData%OverHang)
   call RegPack(RF, InData%ProjArea)
   call RegPack(RF, InData%PtfmRefzt)
   call RegPack(RF, InData%RefTwrHt)
   call RegPack(RF, InData%RFrlPnt_n)
   call RegPack(RF, InData%rVDxn)
   call RegPack(RF, InData%rVDyn)
   call RegPack(RF, InData%rVDzn)
   call RegPack(RF, InData%rVIMUxn)
   call RegPack(RF, InData%rVIMUyn)
   call RegPack(RF, InData%rVIMUzn)
   call RegPack(RF, InData%rVPxn)
   call RegPack(RF, InData%rVPyn)
   call RegPack(RF, InData%rVPzn)
   call RegPack(RF, InData%rWIxn)
   call RegPack(RF, InData%rWIyn)
   call RegPack(RF, InData%rWIzn)
   call RegPack(RF, InData%rWJxn)
   call RegPack(RF, InData%rWJyn)
   call RegPack(RF, InData%rWJzn)
   call RegPack(RF, InData%rZT0zt)
   call RegPack(RF, InData%rZYzt)
   call RegPack(RF, InData%SinDel3)
   call RegPackAlloc(RF, InData%SinPreC)
   call RegPack(RF, InData%SRFrlSkew)
   call RegPack(RF, InData%SRFrlSkw2)
   call RegPack(RF, InData%SRFrlTilt)
   call RegPack(RF, InData%SRFrlTlt2)
   call RegPack(RF, InData%SShftSkew)
   call RegPack(RF, InData%SShftTilt)
   call RegPack(RF, InData%STFrlSkew)
   call RegPack(RF, InData%STFrlSkw2)
   call RegPack(RF, InData%STFrlTilt)
   call RegPack(RF, InData%STFrlTlt2)
   call RegPack(RF, InData%TFrlPnt_n)
   call RegPack(RF, InData%TipRad)
   call RegPack(RF, InData%TowerHt)
   call RegPack(RF, InData%TowerBsHt)
   call RegPack(RF, InData%UndSling)
   call RegPack(RF, InData%NumBl)
   call RegPackAlloc(RF, InData%AxRedTFA)
   call RegPackAlloc(RF, InData%AxRedTSS)
   call RegPack(RF, InData%CTFA)
   call RegPack(RF, InData%CTSS)
   call RegPackAlloc(RF, InData%DHNodes)
   call RegPackAlloc(RF, InData%HNodes)
   call RegPackAlloc(RF, InData%HNodesNorm)
   call RegPack(RF, InData%KTFA)
   call RegPack(RF, InData%KTSS)
   call RegPackAlloc(RF, InData%MassT)
   call RegPackAlloc(RF, InData%StiffTSS)
   call RegPackAlloc(RF, InData%TwrFASF)
   call RegPack(RF, InData%TwrFlexL)
   call RegPackAlloc(RF, InData%TwrSSSF)
   call RegPack(RF, InData%TTopNode)
   call RegPack(RF, InData%TwrNodes)
   call RegPack(RF, InData%MHK)
   call RegPackAlloc(RF, InData%StiffTFA)
   call RegPack(RF, InData%AtfaIner)
   call RegPackAlloc(RF, InData%BldCG)
   call RegPackAlloc(RF, InData%BldMass)
   call RegPack(RF, InData%BoomMass)
   call RegPackAlloc(RF, InData%FirstMom)
   call RegPack(RF, InData%GenIner)
   call RegPack(RF, InData%Hubg1Iner)
   call RegPack(RF, InData%Hubg2Iner)
   call RegPack(RF, InData%HubMass)
   call RegPack(RF, InData%Nacd2Iner)
   call RegPack(RF, InData%NacMass)
   call RegPack(RF, InData%PtfmMass)
   call RegPack(RF, InData%PtfmPIner)
   call RegPack(RF, InData%PtfmRIner)
   call RegPack(RF, InData%PtfmYIner)
   call RegPack(RF, InData%PtfmXYIner)
   call RegPack(RF, InData%PtfmYZIner)
   call RegPack(RF, InData%PtfmXZIner)
   call RegPack(RF, InData%RFrlMass)
   call RegPack(RF, InData%RotIner)
   call RegPack(RF, InData%RotMass)
   call RegPack(RF, InData%RrfaIner)
   call RegPackAlloc(RF, InData%SecondMom)
   call RegPack(RF, InData%TFinMass)
   call RegPack(RF, InData%TFrlIner)
   call RegPackAlloc(RF, InData%TipMass)
   call RegPack(RF, InData%TurbMass)
   call RegPack(RF, InData%TwrMass)
   call RegPack(RF, InData%TwrTpMass)
   call RegPack(RF, InData%YawBrMass)
   call RegPack(RF, InData%Gravity)
   call RegPackAlloc(RF, InData%PitchAxis)
   call RegPackAlloc(RF, InData%AeroTwst)
   call RegPackAlloc(RF, InData%AxRedBld)
   call RegPackAlloc(RF, InData%BldEDamp)
   call RegPackAlloc(RF, InData%BldFDamp)
   call RegPack(RF, InData%BldFlexL)
   call RegPackAlloc(RF, InData%CAeroTwst)
   call RegPackAlloc(RF, InData%CBE)
   call RegPackAlloc(RF, InData%CBF)
   call RegPackAlloc(RF, InData%Chord)
   call RegPackAlloc(RF, InData%CThetaS)
   call RegPackAlloc(RF, InData%DRNodes)
   call RegPackAlloc(RF, InData%FStTunr)
   call RegPackAlloc(RF, InData%KBE)
   call RegPackAlloc(RF, InData%KBF)
   call RegPackAlloc(RF, InData%MassB)
   call RegPackAlloc(RF, InData%RNodes)
   call RegPackAlloc(RF, InData%RNodesNorm)
   call RegPackAlloc(RF, InData%rSAerCenn1)
   call RegPackAlloc(RF, InData%rSAerCenn2)
   call RegPackAlloc(RF, InData%SAeroTwst)
   call RegPackAlloc(RF, InData%StiffBE)
   call RegPackAlloc(RF, InData%StiffBF)
   call RegPackAlloc(RF, InData%SThetaS)
   call RegPackAlloc(RF, InData%ThetaS)
   call RegPackAlloc(RF, InData%TwistedSF)
   call RegPackAlloc(RF, InData%BldFl1Sh)
   call RegPackAlloc(RF, InData%BldFl2Sh)
   call RegPackAlloc(RF, InData%BldEdgSh)
   call RegPackAlloc(RF, InData%FreqBE)
   call RegPackAlloc(RF, InData%FreqBF)
   call RegPack(RF, InData%FreqTFA)
   call RegPack(RF, InData%FreqTSS)
   call RegPack(RF, InData%TeetCDmp)
   call RegPack(RF, InData%TeetDmp)
   call RegPack(RF, InData%TeetDmpP)
   call RegPack(RF, InData%TeetHSSp)
   call RegPack(RF, InData%TeetHStP)
   call RegPack(RF, InData%TeetSSSp)
   call RegPack(RF, InData%TeetSStP)
   call RegPack(RF, InData%TeetMod)
   call RegPack(RF, InData%TFrlDmp)
   call RegPack(RF, InData%TFrlDSDmp)
   call RegPack(RF, InData%TFrlDSDP)
   call RegPack(RF, InData%TFrlDSSP)
   call RegPack(RF, InData%TFrlDSSpr)
   call RegPack(RF, InData%TFrlSpr)
   call RegPack(RF, InData%TFrlUSDmp)
   call RegPack(RF, InData%TFrlUSDP)
   call RegPack(RF, InData%TFrlUSSP)
   call RegPack(RF, InData%TFrlUSSpr)
   call RegPack(RF, InData%TFrlMod)
   call RegPack(RF, InData%RFrlDmp)
   call RegPack(RF, InData%RFrlDSDmp)
   call RegPack(RF, InData%RFrlDSDP)
   call RegPack(RF, InData%RFrlDSSP)
   call RegPack(RF, InData%RFrlDSSpr)
   call RegPack(RF, InData%RFrlSpr)
   call RegPack(RF, InData%RFrlUSDmp)
   call RegPack(RF, InData%RFrlUSDP)
   call RegPack(RF, InData%RFrlUSSP)
   call RegPack(RF, InData%RFrlUSSpr)
   call RegPack(RF, InData%RFrlMod)
   call RegPack(RF, InData%ShftGagL)
   call RegPack(RF, InData%BldGagNd)
   call RegPack(RF, InData%TwrGagNd)
   call RegPack(RF, InData%TStart)
   call RegPack(RF, InData%DTTorDmp)
   call RegPack(RF, InData%DTTorSpr)
   call RegPack(RF, InData%GBRatio)
   call RegPack(RF, InData%GBoxEff)
   call RegPack(RF, InData%RotSpeed)
   call RegPack(RF, InData%RootName)
   call RegPackAlloc(RF, InData%BElmntMass)
   call RegPackAlloc(RF, InData%TElmntMass)
   call RegPack(RF, InData%method)
   call RegPack(RF, InData%PtfmCMxt)
   call RegPack(RF, InData%PtfmCMyt)
   call RegPack(RF, InData%BD4Blades)
   call RegPack(RF, InData%RigidAero)
   call RegPack(RF, InData%YawFrctMod)
   call RegPack(RF, InData%M_CD)
   call RegPack(RF, InData%M_FCD)
   call RegPack(RF, InData%M_MCD)
   call RegPack(RF, InData%M_CSMAX)
   call RegPack(RF, InData%M_FCSMAX)
   call RegPack(RF, InData%M_MCSMAX)
   call RegPack(RF, InData%sig_v)
   call RegPack(RF, InData%sig_v2)
   call RegPack(RF, InData%OmgCut)
   call RegPack(RF, InData%BldNd_NumOuts)
   call RegPack(RF, InData%BldNd_TotNumOuts)
   call RegPack(RF, allocated(InData%BldNd_OutParam))
   if (allocated(InData%BldNd_OutParam)) then
      call RegPackBounds(RF, 1, lbound(InData%BldNd_OutParam), ubound(InData%BldNd_OutParam))
      LB(1:1) = lbound(InData%BldNd_OutParam)
      UB(1:1) = ubound(InData%BldNd_OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackOutParmType(RF, InData%BldNd_OutParam(i1)) 
      end do
   end if
   call RegPack(RF, InData%BldNd_BladesOut)
   call ED_PackJac_u_idxStarts(RF, InData%Jac_u_idxStartList) 
   call ED_PackJac_y_idxStarts(RF, InData%Jac_y_idxStartList) 
   call RegPackAlloc(RF, InData%Jac_u_indx)
   call RegPackAlloc(RF, InData%du)
   call RegPackAlloc(RF, InData%dx)
   call RegPack(RF, InData%Jac_ny)
   call RegPack(RF, InData%CompAeroMaps)
   call RegPack(RF, InData%NumExtendedInputs)
   call RegPack(RF, InData%NumBl_Lin)
   call RegPack(RF, InData%NActvVelDOF_Lin)
   call RegPack(RF, InData%NActvDOF_Lin)
   call RegPack(RF, InData%NActvDOF_Stride)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ED_UnPackParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ED_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ED_UnPackParam'
   integer(B4Ki)   :: i1, i2, i3, i4, i5
   integer(B4Ki)   :: LB(5), UB(5)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DT24); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BldNodes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TipNode); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NDOF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TwoPiNB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NAug); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NPH); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PH); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NPM); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PM); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%DOF_Flag); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%DOF_Desc); if (RegCheckErr(RF, RoutineName)) return
   call ED_UnpackActiveDOFs(RF, OutData%DOFs) ! DOFs 
   call RegUnpack(RF, OutData%NumOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutFmt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NBlGages); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NTwGages); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%OutParam)) deallocate(OutData%OutParam)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%OutParam(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%OutParam.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackOutParmType(RF, OutData%OutParam(i1)) ! OutParam 
      end do
   end if
   call RegUnpack(RF, OutData%Delim); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AvgNrmTpRd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AzimB1Up); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CosDel3); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%CosPreC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CRFrlSkew); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CRFrlSkw2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CRFrlTilt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CRFrlTlt2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CShftSkew); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CShftTilt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CSRFrlSkw); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CSRFrlTlt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CSTFrlSkw); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CSTFrlTlt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CTFrlSkew); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CTFrlSkw2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CTFrlTilt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CTFrlTlt2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HubHt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HubCM); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HubRad); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NacCMxn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NacCMyn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NacCMzn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OverHang); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ProjArea); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmRefzt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RefTwrHt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RFrlPnt_n); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rVDxn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rVDyn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rVDzn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rVIMUxn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rVIMUyn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rVIMUzn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rVPxn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rVPyn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rVPzn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rWIxn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rWIyn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rWIzn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rWJxn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rWJyn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rWJzn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rZT0zt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rZYzt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SinDel3); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%SinPreC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SRFrlSkew); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SRFrlSkw2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SRFrlTilt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SRFrlTlt2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SShftSkew); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SShftTilt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%STFrlSkew); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%STFrlSkw2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%STFrlTilt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%STFrlTlt2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFrlPnt_n); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TipRad); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TowerHt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TowerBsHt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UndSling); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumBl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AxRedTFA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AxRedTSS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CTFA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CTSS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%DHNodes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%HNodes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%HNodesNorm); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%KTFA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%KTSS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%MassT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%StiffTSS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TwrFASF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TwrFlexL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TwrSSSF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TTopNode); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TwrNodes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MHK); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%StiffTFA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AtfaIner); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BldCG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BldMass); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BoomMass); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%FirstMom); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GenIner); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Hubg1Iner); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Hubg2Iner); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HubMass); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Nacd2Iner); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NacMass); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmMass); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmPIner); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmRIner); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmYIner); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmXYIner); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmYZIner); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmXZIner); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RFrlMass); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RotIner); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RotMass); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RrfaIner); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%SecondMom); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFinMass); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFrlIner); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TipMass); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TurbMass); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TwrMass); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TwrTpMass); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawBrMass); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Gravity); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PitchAxis); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AeroTwst); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AxRedBld); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BldEDamp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BldFDamp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BldFlexL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%CAeroTwst); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%CBE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%CBF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Chord); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%CThetaS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%DRNodes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%FStTunr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%KBE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%KBF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%MassB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RNodes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RNodesNorm); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%rSAerCenn1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%rSAerCenn2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%SAeroTwst); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%StiffBE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%StiffBF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%SThetaS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%ThetaS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TwistedSF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BldFl1Sh); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BldFl2Sh); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BldEdgSh); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%FreqBE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%FreqBF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FreqTFA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FreqTSS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TeetCDmp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TeetDmp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TeetDmpP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TeetHSSp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TeetHStP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TeetSSSp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TeetSStP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TeetMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFrlDmp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFrlDSDmp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFrlDSDP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFrlDSSP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFrlDSSpr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFrlSpr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFrlUSDmp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFrlUSDP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFrlUSSP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFrlUSSpr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFrlMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RFrlDmp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RFrlDSDmp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RFrlDSDP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RFrlDSSP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RFrlDSSpr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RFrlSpr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RFrlUSDmp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RFrlUSDP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RFrlUSSP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RFrlUSSpr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RFrlMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ShftGagL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BldGagNd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TwrGagNd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TStart); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DTTorDmp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DTTorSpr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GBRatio); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GBoxEff); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RotSpeed); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BElmntMass); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TElmntMass); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%method); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmCMxt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmCMyt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BD4Blades); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RigidAero); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawFrctMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%M_CD); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%M_FCD); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%M_MCD); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%M_CSMAX); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%M_FCSMAX); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%M_MCSMAX); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%sig_v); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%sig_v2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OmgCut); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BldNd_NumOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BldNd_TotNumOuts); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%BldNd_OutParam)) deallocate(OutData%BldNd_OutParam)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BldNd_OutParam(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BldNd_OutParam.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackOutParmType(RF, OutData%BldNd_OutParam(i1)) ! BldNd_OutParam 
      end do
   end if
   call RegUnpack(RF, OutData%BldNd_BladesOut); if (RegCheckErr(RF, RoutineName)) return
   call ED_UnpackJac_u_idxStarts(RF, OutData%Jac_u_idxStartList) ! Jac_u_idxStartList 
   call ED_UnpackJac_y_idxStarts(RF, OutData%Jac_y_idxStartList) ! Jac_y_idxStartList 
   call RegUnpackAlloc(RF, OutData%Jac_u_indx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%du); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%dx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Jac_ny); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CompAeroMaps); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumExtendedInputs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumBl_Lin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NActvVelDOF_Lin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NActvDOF_Lin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NActvDOF_Stride); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ED_CopyInput(SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg)
   type(ED_InputType), intent(inout) :: SrcInputData
   type(ED_InputType), intent(inout) :: DstInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ED_CopyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcInputData%BladePtLoads)) then
      LB(1:1) = lbound(SrcInputData%BladePtLoads)
      UB(1:1) = ubound(SrcInputData%BladePtLoads)
      if (.not. allocated(DstInputData%BladePtLoads)) then
         allocate(DstInputData%BladePtLoads(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%BladePtLoads.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcInputData%BladePtLoads(i1), DstInputData%BladePtLoads(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call MeshCopy(SrcInputData%PlatformPtMesh, DstInputData%PlatformPtMesh, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcInputData%TowerPtLoads, DstInputData%TowerPtLoads, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcInputData%HubPtLoad, DstInputData%HubPtLoad, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcInputData%NacelleLoads, DstInputData%NacelleLoads, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcInputData%TFinCMLoads, DstInputData%TFinCMLoads, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcInputData%TwrAddedMass)) then
      LB(1:3) = lbound(SrcInputData%TwrAddedMass)
      UB(1:3) = ubound(SrcInputData%TwrAddedMass)
      if (.not. allocated(DstInputData%TwrAddedMass)) then
         allocate(DstInputData%TwrAddedMass(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%TwrAddedMass.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%TwrAddedMass = SrcInputData%TwrAddedMass
   end if
   DstInputData%PtfmAddedMass = SrcInputData%PtfmAddedMass
   if (allocated(SrcInputData%BlPitchCom)) then
      LB(1:1) = lbound(SrcInputData%BlPitchCom)
      UB(1:1) = ubound(SrcInputData%BlPitchCom)
      if (.not. allocated(DstInputData%BlPitchCom)) then
         allocate(DstInputData%BlPitchCom(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%BlPitchCom.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%BlPitchCom = SrcInputData%BlPitchCom
   end if
   DstInputData%YawMom = SrcInputData%YawMom
   DstInputData%GenTrq = SrcInputData%GenTrq
   DstInputData%HSSBrTrqC = SrcInputData%HSSBrTrqC
end subroutine

subroutine ED_DestroyInput(InputData, ErrStat, ErrMsg)
   type(ED_InputType), intent(inout) :: InputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ED_DestroyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InputData%BladePtLoads)) then
      LB(1:1) = lbound(InputData%BladePtLoads)
      UB(1:1) = ubound(InputData%BladePtLoads)
      do i1 = LB(1), UB(1)
         call MeshDestroy( InputData%BladePtLoads(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InputData%BladePtLoads)
   end if
   call MeshDestroy( InputData%PlatformPtMesh, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( InputData%TowerPtLoads, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( InputData%HubPtLoad, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( InputData%NacelleLoads, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( InputData%TFinCMLoads, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(InputData%TwrAddedMass)) then
      deallocate(InputData%TwrAddedMass)
   end if
   if (allocated(InputData%BlPitchCom)) then
      deallocate(InputData%BlPitchCom)
   end if
end subroutine

subroutine ED_PackInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ED_InputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ED_PackInput'
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)   :: LB(3), UB(3)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%BladePtLoads))
   if (allocated(InData%BladePtLoads)) then
      call RegPackBounds(RF, 1, lbound(InData%BladePtLoads), ubound(InData%BladePtLoads))
      LB(1:1) = lbound(InData%BladePtLoads)
      UB(1:1) = ubound(InData%BladePtLoads)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%BladePtLoads(i1)) 
      end do
   end if
   call MeshPack(RF, InData%PlatformPtMesh) 
   call MeshPack(RF, InData%TowerPtLoads) 
   call MeshPack(RF, InData%HubPtLoad) 
   call MeshPack(RF, InData%NacelleLoads) 
   call MeshPack(RF, InData%TFinCMLoads) 
   call RegPackAlloc(RF, InData%TwrAddedMass)
   call RegPack(RF, InData%PtfmAddedMass)
   call RegPackAlloc(RF, InData%BlPitchCom)
   call RegPack(RF, InData%YawMom)
   call RegPack(RF, InData%GenTrq)
   call RegPack(RF, InData%HSSBrTrqC)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ED_UnPackInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ED_InputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ED_UnPackInput'
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%BladePtLoads)) deallocate(OutData%BladePtLoads)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BladePtLoads(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BladePtLoads.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%BladePtLoads(i1)) ! BladePtLoads 
      end do
   end if
   call MeshUnpack(RF, OutData%PlatformPtMesh) ! PlatformPtMesh 
   call MeshUnpack(RF, OutData%TowerPtLoads) ! TowerPtLoads 
   call MeshUnpack(RF, OutData%HubPtLoad) ! HubPtLoad 
   call MeshUnpack(RF, OutData%NacelleLoads) ! NacelleLoads 
   call MeshUnpack(RF, OutData%TFinCMLoads) ! TFinCMLoads 
   call RegUnpackAlloc(RF, OutData%TwrAddedMass); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PtfmAddedMass); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BlPitchCom); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawMom); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GenTrq); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HSSBrTrqC); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ED_CopyOutput(SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg)
   type(ED_OutputType), intent(inout) :: SrcOutputData
   type(ED_OutputType), intent(inout) :: DstOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ED_CopyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcOutputData%BladeLn2Mesh)) then
      LB(1:1) = lbound(SrcOutputData%BladeLn2Mesh)
      UB(1:1) = ubound(SrcOutputData%BladeLn2Mesh)
      if (.not. allocated(DstOutputData%BladeLn2Mesh)) then
         allocate(DstOutputData%BladeLn2Mesh(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%BladeLn2Mesh.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcOutputData%BladeLn2Mesh(i1), DstOutputData%BladeLn2Mesh(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call MeshCopy(SrcOutputData%PlatformPtMesh, DstOutputData%PlatformPtMesh, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcOutputData%TowerLn2Mesh, DstOutputData%TowerLn2Mesh, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcOutputData%HubPtMotion, DstOutputData%HubPtMotion, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcOutputData%BladeRootMotion)) then
      LB(1:1) = lbound(SrcOutputData%BladeRootMotion)
      UB(1:1) = ubound(SrcOutputData%BladeRootMotion)
      if (.not. allocated(DstOutputData%BladeRootMotion)) then
         allocate(DstOutputData%BladeRootMotion(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%BladeRootMotion.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcOutputData%BladeRootMotion(i1), DstOutputData%BladeRootMotion(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call MeshCopy(SrcOutputData%NacelleMotion, DstOutputData%NacelleMotion, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcOutputData%TFinCMMotion, DstOutputData%TFinCMMotion, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcOutputData%WriteOutput)) then
      LB(1:1) = lbound(SrcOutputData%WriteOutput)
      UB(1:1) = ubound(SrcOutputData%WriteOutput)
      if (.not. allocated(DstOutputData%WriteOutput)) then
         allocate(DstOutputData%WriteOutput(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%WriteOutput.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%WriteOutput = SrcOutputData%WriteOutput
   end if
   if (allocated(SrcOutputData%BlPitch)) then
      LB(1:1) = lbound(SrcOutputData%BlPitch)
      UB(1:1) = ubound(SrcOutputData%BlPitch)
      if (.not. allocated(DstOutputData%BlPitch)) then
         allocate(DstOutputData%BlPitch(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%BlPitch.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%BlPitch = SrcOutputData%BlPitch
   end if
   DstOutputData%Yaw = SrcOutputData%Yaw
   DstOutputData%YawRate = SrcOutputData%YawRate
   DstOutputData%LSS_Spd = SrcOutputData%LSS_Spd
   DstOutputData%HSS_Spd = SrcOutputData%HSS_Spd
   DstOutputData%RotSpeed = SrcOutputData%RotSpeed
   DstOutputData%TwrAccel = SrcOutputData%TwrAccel
   DstOutputData%YawAngle = SrcOutputData%YawAngle
   DstOutputData%RootMyc = SrcOutputData%RootMyc
   DstOutputData%YawBrTAxp = SrcOutputData%YawBrTAxp
   DstOutputData%YawBrTAyp = SrcOutputData%YawBrTAyp
   DstOutputData%LSSTipPxa = SrcOutputData%LSSTipPxa
   DstOutputData%RootMxc = SrcOutputData%RootMxc
   DstOutputData%LSSTipMxa = SrcOutputData%LSSTipMxa
   DstOutputData%LSSTipMya = SrcOutputData%LSSTipMya
   DstOutputData%LSSTipMza = SrcOutputData%LSSTipMza
   DstOutputData%LSSTipMys = SrcOutputData%LSSTipMys
   DstOutputData%LSSTipMzs = SrcOutputData%LSSTipMzs
   DstOutputData%YawBrMyn = SrcOutputData%YawBrMyn
   DstOutputData%YawBrMzn = SrcOutputData%YawBrMzn
   DstOutputData%NcIMURAxs = SrcOutputData%NcIMURAxs
   DstOutputData%NcIMURAys = SrcOutputData%NcIMURAys
   DstOutputData%NcIMURAzs = SrcOutputData%NcIMURAzs
   DstOutputData%RotPwr = SrcOutputData%RotPwr
   DstOutputData%LSShftFxa = SrcOutputData%LSShftFxa
   DstOutputData%LSShftFys = SrcOutputData%LSShftFys
   DstOutputData%LSShftFzs = SrcOutputData%LSShftFzs
end subroutine

subroutine ED_DestroyOutput(OutputData, ErrStat, ErrMsg)
   type(ED_OutputType), intent(inout) :: OutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ED_DestroyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(OutputData%BladeLn2Mesh)) then
      LB(1:1) = lbound(OutputData%BladeLn2Mesh)
      UB(1:1) = ubound(OutputData%BladeLn2Mesh)
      do i1 = LB(1), UB(1)
         call MeshDestroy( OutputData%BladeLn2Mesh(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(OutputData%BladeLn2Mesh)
   end if
   call MeshDestroy( OutputData%PlatformPtMesh, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( OutputData%TowerLn2Mesh, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( OutputData%HubPtMotion, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(OutputData%BladeRootMotion)) then
      LB(1:1) = lbound(OutputData%BladeRootMotion)
      UB(1:1) = ubound(OutputData%BladeRootMotion)
      do i1 = LB(1), UB(1)
         call MeshDestroy( OutputData%BladeRootMotion(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(OutputData%BladeRootMotion)
   end if
   call MeshDestroy( OutputData%NacelleMotion, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( OutputData%TFinCMMotion, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(OutputData%WriteOutput)) then
      deallocate(OutputData%WriteOutput)
   end if
   if (allocated(OutputData%BlPitch)) then
      deallocate(OutputData%BlPitch)
   end if
end subroutine

subroutine ED_PackOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ED_OutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ED_PackOutput'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%BladeLn2Mesh))
   if (allocated(InData%BladeLn2Mesh)) then
      call RegPackBounds(RF, 1, lbound(InData%BladeLn2Mesh), ubound(InData%BladeLn2Mesh))
      LB(1:1) = lbound(InData%BladeLn2Mesh)
      UB(1:1) = ubound(InData%BladeLn2Mesh)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%BladeLn2Mesh(i1)) 
      end do
   end if
   call MeshPack(RF, InData%PlatformPtMesh) 
   call MeshPack(RF, InData%TowerLn2Mesh) 
   call MeshPack(RF, InData%HubPtMotion) 
   call RegPack(RF, allocated(InData%BladeRootMotion))
   if (allocated(InData%BladeRootMotion)) then
      call RegPackBounds(RF, 1, lbound(InData%BladeRootMotion), ubound(InData%BladeRootMotion))
      LB(1:1) = lbound(InData%BladeRootMotion)
      UB(1:1) = ubound(InData%BladeRootMotion)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%BladeRootMotion(i1)) 
      end do
   end if
   call MeshPack(RF, InData%NacelleMotion) 
   call MeshPack(RF, InData%TFinCMMotion) 
   call RegPackAlloc(RF, InData%WriteOutput)
   call RegPackAlloc(RF, InData%BlPitch)
   call RegPack(RF, InData%Yaw)
   call RegPack(RF, InData%YawRate)
   call RegPack(RF, InData%LSS_Spd)
   call RegPack(RF, InData%HSS_Spd)
   call RegPack(RF, InData%RotSpeed)
   call RegPack(RF, InData%TwrAccel)
   call RegPack(RF, InData%YawAngle)
   call RegPack(RF, InData%RootMyc)
   call RegPack(RF, InData%YawBrTAxp)
   call RegPack(RF, InData%YawBrTAyp)
   call RegPack(RF, InData%LSSTipPxa)
   call RegPack(RF, InData%RootMxc)
   call RegPack(RF, InData%LSSTipMxa)
   call RegPack(RF, InData%LSSTipMya)
   call RegPack(RF, InData%LSSTipMza)
   call RegPack(RF, InData%LSSTipMys)
   call RegPack(RF, InData%LSSTipMzs)
   call RegPack(RF, InData%YawBrMyn)
   call RegPack(RF, InData%YawBrMzn)
   call RegPack(RF, InData%NcIMURAxs)
   call RegPack(RF, InData%NcIMURAys)
   call RegPack(RF, InData%NcIMURAzs)
   call RegPack(RF, InData%RotPwr)
   call RegPack(RF, InData%LSShftFxa)
   call RegPack(RF, InData%LSShftFys)
   call RegPack(RF, InData%LSShftFzs)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ED_UnPackOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ED_OutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ED_UnPackOutput'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%BladeLn2Mesh)) deallocate(OutData%BladeLn2Mesh)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BladeLn2Mesh(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BladeLn2Mesh.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%BladeLn2Mesh(i1)) ! BladeLn2Mesh 
      end do
   end if
   call MeshUnpack(RF, OutData%PlatformPtMesh) ! PlatformPtMesh 
   call MeshUnpack(RF, OutData%TowerLn2Mesh) ! TowerLn2Mesh 
   call MeshUnpack(RF, OutData%HubPtMotion) ! HubPtMotion 
   if (allocated(OutData%BladeRootMotion)) deallocate(OutData%BladeRootMotion)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BladeRootMotion(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BladeRootMotion.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%BladeRootMotion(i1)) ! BladeRootMotion 
      end do
   end if
   call MeshUnpack(RF, OutData%NacelleMotion) ! NacelleMotion 
   call MeshUnpack(RF, OutData%TFinCMMotion) ! TFinCMMotion 
   call RegUnpackAlloc(RF, OutData%WriteOutput); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BlPitch); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Yaw); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawRate); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LSS_Spd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HSS_Spd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RotSpeed); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TwrAccel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawAngle); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootMyc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawBrTAxp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawBrTAyp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LSSTipPxa); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootMxc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LSSTipMxa); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LSSTipMya); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LSSTipMza); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LSSTipMys); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LSSTipMzs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawBrMyn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawBrMzn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NcIMURAxs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NcIMURAys); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NcIMURAzs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RotPwr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LSShftFxa); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LSShftFys); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%LSShftFzs); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ED_Input_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
   ! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(ED_InputType), intent(inout)  :: u(:) ! Input at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Inputs
   type(ED_InputType), intent(inout)  :: u_out ! Input at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'ED_Input_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(u)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(u)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(u) - 1
   select case (order)
   case (0)
      call ED_CopyInput(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call ED_Input_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call ED_Input_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(u) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE ED_Input_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

   TYPE(ED_InputType), INTENT(INOUT)  :: u1    ! Input at t1 > t2
   TYPE(ED_InputType), INTENT(INOUT)  :: u2    ! Input at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Inputs
   TYPE(ED_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'ED_Input_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i02      ! dim2 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i03      ! dim3 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   INTEGER                                    :: i2       ! dim2 counter variable for arrays
   INTEGER                                    :: i3       ! dim3 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   IF (ALLOCATED(u_out%BladePtLoads) .AND. ALLOCATED(u1%BladePtLoads)) THEN
      do i1 = lbound(u_out%BladePtLoads,1),ubound(u_out%BladePtLoads,1)
         CALL MeshExtrapInterp1(u1%BladePtLoads(i1), u2%BladePtLoads(i1), tin, u_out%BladePtLoads(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   CALL MeshExtrapInterp1(u1%PlatformPtMesh, u2%PlatformPtMesh, tin, u_out%PlatformPtMesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp1(u1%TowerPtLoads, u2%TowerPtLoads, tin, u_out%TowerPtLoads, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp1(u1%HubPtLoad, u2%HubPtLoad, tin, u_out%HubPtLoad, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp1(u1%NacelleLoads, u2%NacelleLoads, tin, u_out%NacelleLoads, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp1(u1%TFinCMLoads, u2%TFinCMLoads, tin, u_out%TFinCMLoads, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   IF (ALLOCATED(u_out%TwrAddedMass) .AND. ALLOCATED(u1%TwrAddedMass)) THEN
      u_out%TwrAddedMass = a1*u1%TwrAddedMass + a2*u2%TwrAddedMass
   END IF ! check if allocated
   u_out%PtfmAddedMass = a1*u1%PtfmAddedMass + a2*u2%PtfmAddedMass
   IF (ALLOCATED(u_out%BlPitchCom) .AND. ALLOCATED(u1%BlPitchCom)) THEN
      do i1 = lbound(u_out%BlPitchCom,1),ubound(u_out%BlPitchCom,1)
         CALL Angles_ExtrapInterp( u1%BlPitchCom(i1), u2%BlPitchCom(i1), tin, u_out%BlPitchCom(i1), tin_out )
      END DO
   END IF ! check if allocated
   u_out%YawMom = a1*u1%YawMom + a2*u2%YawMom
   u_out%GenTrq = a1*u1%GenTrq + a2*u2%GenTrq
   u_out%HSSBrTrqC = a1*u1%HSSBrTrqC + a2*u2%HSSBrTrqC
END SUBROUTINE

SUBROUTINE ED_Input_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

   TYPE(ED_InputType), INTENT(INOUT)  :: u1      ! Input at t1 > t2 > t3
   TYPE(ED_InputType), INTENT(INOUT)  :: u2      ! Input at t2 > t3
   TYPE(ED_InputType), INTENT(INOUT)  :: u3      ! Input at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Inputs
   TYPE(ED_InputType), INTENT(INOUT)  :: u_out     ! Input at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'ED_Input_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i02    ! dim2 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i03    ! dim3 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   INTEGER                                    :: i2    ! dim2 counter variable for arrays
   INTEGER                                    :: i3    ! dim3 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   IF (ALLOCATED(u_out%BladePtLoads) .AND. ALLOCATED(u1%BladePtLoads)) THEN
      do i1 = lbound(u_out%BladePtLoads,1),ubound(u_out%BladePtLoads,1)
         CALL MeshExtrapInterp2(u1%BladePtLoads(i1), u2%BladePtLoads(i1), u3%BladePtLoads(i1), tin, u_out%BladePtLoads(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   CALL MeshExtrapInterp2(u1%PlatformPtMesh, u2%PlatformPtMesh, u3%PlatformPtMesh, tin, u_out%PlatformPtMesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp2(u1%TowerPtLoads, u2%TowerPtLoads, u3%TowerPtLoads, tin, u_out%TowerPtLoads, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp2(u1%HubPtLoad, u2%HubPtLoad, u3%HubPtLoad, tin, u_out%HubPtLoad, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp2(u1%NacelleLoads, u2%NacelleLoads, u3%NacelleLoads, tin, u_out%NacelleLoads, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp2(u1%TFinCMLoads, u2%TFinCMLoads, u3%TFinCMLoads, tin, u_out%TFinCMLoads, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   IF (ALLOCATED(u_out%TwrAddedMass) .AND. ALLOCATED(u1%TwrAddedMass)) THEN
      u_out%TwrAddedMass = a1*u1%TwrAddedMass + a2*u2%TwrAddedMass + a3*u3%TwrAddedMass
   END IF ! check if allocated
   u_out%PtfmAddedMass = a1*u1%PtfmAddedMass + a2*u2%PtfmAddedMass + a3*u3%PtfmAddedMass
   IF (ALLOCATED(u_out%BlPitchCom) .AND. ALLOCATED(u1%BlPitchCom)) THEN
      do i1 = lbound(u_out%BlPitchCom,1),ubound(u_out%BlPitchCom,1)
         CALL Angles_ExtrapInterp( u1%BlPitchCom(i1), u2%BlPitchCom(i1), u3%BlPitchCom(i1), tin, u_out%BlPitchCom(i1), tin_out )
      END DO
   END IF ! check if allocated
   u_out%YawMom = a1*u1%YawMom + a2*u2%YawMom + a3*u3%YawMom
   u_out%GenTrq = a1*u1%GenTrq + a2*u2%GenTrq + a3*u3%GenTrq
   u_out%HSSBrTrqC = a1*u1%HSSBrTrqC + a2*u2%HSSBrTrqC + a3*u3%HSSBrTrqC
END SUBROUTINE

subroutine ED_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
   ! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(ED_OutputType), intent(inout)  :: y(:) ! Output at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Outputs
   type(ED_OutputType), intent(inout)  :: y_out ! Output at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'ED_Output_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(y)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(y)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(y) - 1
   select case (order)
   case (0)
      call ED_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call ED_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call ED_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(y) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE ED_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

   TYPE(ED_OutputType), INTENT(INOUT)  :: y1    ! Output at t1 > t2
   TYPE(ED_OutputType), INTENT(INOUT)  :: y2    ! Output at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
   TYPE(ED_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'ED_Output_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   IF (ALLOCATED(y_out%BladeLn2Mesh) .AND. ALLOCATED(y1%BladeLn2Mesh)) THEN
      do i1 = lbound(y_out%BladeLn2Mesh,1),ubound(y_out%BladeLn2Mesh,1)
         CALL MeshExtrapInterp1(y1%BladeLn2Mesh(i1), y2%BladeLn2Mesh(i1), tin, y_out%BladeLn2Mesh(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   CALL MeshExtrapInterp1(y1%PlatformPtMesh, y2%PlatformPtMesh, tin, y_out%PlatformPtMesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp1(y1%TowerLn2Mesh, y2%TowerLn2Mesh, tin, y_out%TowerLn2Mesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp1(y1%HubPtMotion, y2%HubPtMotion, tin, y_out%HubPtMotion, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   IF (ALLOCATED(y_out%BladeRootMotion) .AND. ALLOCATED(y1%BladeRootMotion)) THEN
      do i1 = lbound(y_out%BladeRootMotion,1),ubound(y_out%BladeRootMotion,1)
         CALL MeshExtrapInterp1(y1%BladeRootMotion(i1), y2%BladeRootMotion(i1), tin, y_out%BladeRootMotion(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   CALL MeshExtrapInterp1(y1%NacelleMotion, y2%NacelleMotion, tin, y_out%NacelleMotion, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp1(y1%TFinCMMotion, y2%TFinCMMotion, tin, y_out%TFinCMMotion, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
      y_out%WriteOutput = a1*y1%WriteOutput + a2*y2%WriteOutput
   END IF ! check if allocated
   IF (ALLOCATED(y_out%BlPitch) .AND. ALLOCATED(y1%BlPitch)) THEN
      do i1 = lbound(y_out%BlPitch,1),ubound(y_out%BlPitch,1)
         CALL Angles_ExtrapInterp( y1%BlPitch(i1), y2%BlPitch(i1), tin, y_out%BlPitch(i1), tin_out )
      END DO
   END IF ! check if allocated
   CALL Angles_ExtrapInterp( y1%Yaw, y2%Yaw, tin, y_out%Yaw, tin_out )
   y_out%YawRate = a1*y1%YawRate + a2*y2%YawRate
   y_out%LSS_Spd = a1*y1%LSS_Spd + a2*y2%LSS_Spd
   y_out%HSS_Spd = a1*y1%HSS_Spd + a2*y2%HSS_Spd
   y_out%RotSpeed = a1*y1%RotSpeed + a2*y2%RotSpeed
   y_out%TwrAccel = a1*y1%TwrAccel + a2*y2%TwrAccel
   CALL Angles_ExtrapInterp( y1%YawAngle, y2%YawAngle, tin, y_out%YawAngle, tin_out )
   y_out%RootMyc = a1*y1%RootMyc + a2*y2%RootMyc
   y_out%YawBrTAxp = a1*y1%YawBrTAxp + a2*y2%YawBrTAxp
   y_out%YawBrTAyp = a1*y1%YawBrTAyp + a2*y2%YawBrTAyp
   CALL Angles_ExtrapInterp( y1%LSSTipPxa, y2%LSSTipPxa, tin, y_out%LSSTipPxa, tin_out )
   y_out%RootMxc = a1*y1%RootMxc + a2*y2%RootMxc
   y_out%LSSTipMxa = a1*y1%LSSTipMxa + a2*y2%LSSTipMxa
   y_out%LSSTipMya = a1*y1%LSSTipMya + a2*y2%LSSTipMya
   y_out%LSSTipMza = a1*y1%LSSTipMza + a2*y2%LSSTipMza
   y_out%LSSTipMys = a1*y1%LSSTipMys + a2*y2%LSSTipMys
   y_out%LSSTipMzs = a1*y1%LSSTipMzs + a2*y2%LSSTipMzs
   y_out%YawBrMyn = a1*y1%YawBrMyn + a2*y2%YawBrMyn
   y_out%YawBrMzn = a1*y1%YawBrMzn + a2*y2%YawBrMzn
   y_out%NcIMURAxs = a1*y1%NcIMURAxs + a2*y2%NcIMURAxs
   y_out%NcIMURAys = a1*y1%NcIMURAys + a2*y2%NcIMURAys
   y_out%NcIMURAzs = a1*y1%NcIMURAzs + a2*y2%NcIMURAzs
   y_out%RotPwr = a1*y1%RotPwr + a2*y2%RotPwr
   y_out%LSShftFxa = a1*y1%LSShftFxa + a2*y2%LSShftFxa
   y_out%LSShftFys = a1*y1%LSShftFys + a2*y2%LSShftFys
   y_out%LSShftFzs = a1*y1%LSShftFzs + a2*y2%LSShftFzs
END SUBROUTINE

SUBROUTINE ED_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

   TYPE(ED_OutputType), INTENT(INOUT)  :: y1      ! Output at t1 > t2 > t3
   TYPE(ED_OutputType), INTENT(INOUT)  :: y2      ! Output at t2 > t3
   TYPE(ED_OutputType), INTENT(INOUT)  :: y3      ! Output at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
   TYPE(ED_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'ED_Output_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   IF (ALLOCATED(y_out%BladeLn2Mesh) .AND. ALLOCATED(y1%BladeLn2Mesh)) THEN
      do i1 = lbound(y_out%BladeLn2Mesh,1),ubound(y_out%BladeLn2Mesh,1)
         CALL MeshExtrapInterp2(y1%BladeLn2Mesh(i1), y2%BladeLn2Mesh(i1), y3%BladeLn2Mesh(i1), tin, y_out%BladeLn2Mesh(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   CALL MeshExtrapInterp2(y1%PlatformPtMesh, y2%PlatformPtMesh, y3%PlatformPtMesh, tin, y_out%PlatformPtMesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp2(y1%TowerLn2Mesh, y2%TowerLn2Mesh, y3%TowerLn2Mesh, tin, y_out%TowerLn2Mesh, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp2(y1%HubPtMotion, y2%HubPtMotion, y3%HubPtMotion, tin, y_out%HubPtMotion, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   IF (ALLOCATED(y_out%BladeRootMotion) .AND. ALLOCATED(y1%BladeRootMotion)) THEN
      do i1 = lbound(y_out%BladeRootMotion,1),ubound(y_out%BladeRootMotion,1)
         CALL MeshExtrapInterp2(y1%BladeRootMotion(i1), y2%BladeRootMotion(i1), y3%BladeRootMotion(i1), tin, y_out%BladeRootMotion(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   CALL MeshExtrapInterp2(y1%NacelleMotion, y2%NacelleMotion, y3%NacelleMotion, tin, y_out%NacelleMotion, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp2(y1%TFinCMMotion, y2%TFinCMMotion, y3%TFinCMMotion, tin, y_out%TFinCMMotion, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
      y_out%WriteOutput = a1*y1%WriteOutput + a2*y2%WriteOutput + a3*y3%WriteOutput
   END IF ! check if allocated
   IF (ALLOCATED(y_out%BlPitch) .AND. ALLOCATED(y1%BlPitch)) THEN
      do i1 = lbound(y_out%BlPitch,1),ubound(y_out%BlPitch,1)
         CALL Angles_ExtrapInterp( y1%BlPitch(i1), y2%BlPitch(i1), y3%BlPitch(i1), tin, y_out%BlPitch(i1), tin_out )
      END DO
   END IF ! check if allocated
   CALL Angles_ExtrapInterp( y1%Yaw, y2%Yaw, y3%Yaw, tin, y_out%Yaw, tin_out )
   y_out%YawRate = a1*y1%YawRate + a2*y2%YawRate + a3*y3%YawRate
   y_out%LSS_Spd = a1*y1%LSS_Spd + a2*y2%LSS_Spd + a3*y3%LSS_Spd
   y_out%HSS_Spd = a1*y1%HSS_Spd + a2*y2%HSS_Spd + a3*y3%HSS_Spd
   y_out%RotSpeed = a1*y1%RotSpeed + a2*y2%RotSpeed + a3*y3%RotSpeed
   y_out%TwrAccel = a1*y1%TwrAccel + a2*y2%TwrAccel + a3*y3%TwrAccel
   CALL Angles_ExtrapInterp( y1%YawAngle, y2%YawAngle, y3%YawAngle, tin, y_out%YawAngle, tin_out )
   y_out%RootMyc = a1*y1%RootMyc + a2*y2%RootMyc + a3*y3%RootMyc
   y_out%YawBrTAxp = a1*y1%YawBrTAxp + a2*y2%YawBrTAxp + a3*y3%YawBrTAxp
   y_out%YawBrTAyp = a1*y1%YawBrTAyp + a2*y2%YawBrTAyp + a3*y3%YawBrTAyp
   CALL Angles_ExtrapInterp( y1%LSSTipPxa, y2%LSSTipPxa, y3%LSSTipPxa, tin, y_out%LSSTipPxa, tin_out )
   y_out%RootMxc = a1*y1%RootMxc + a2*y2%RootMxc + a3*y3%RootMxc
   y_out%LSSTipMxa = a1*y1%LSSTipMxa + a2*y2%LSSTipMxa + a3*y3%LSSTipMxa
   y_out%LSSTipMya = a1*y1%LSSTipMya + a2*y2%LSSTipMya + a3*y3%LSSTipMya
   y_out%LSSTipMza = a1*y1%LSSTipMza + a2*y2%LSSTipMza + a3*y3%LSSTipMza
   y_out%LSSTipMys = a1*y1%LSSTipMys + a2*y2%LSSTipMys + a3*y3%LSSTipMys
   y_out%LSSTipMzs = a1*y1%LSSTipMzs + a2*y2%LSSTipMzs + a3*y3%LSSTipMzs
   y_out%YawBrMyn = a1*y1%YawBrMyn + a2*y2%YawBrMyn + a3*y3%YawBrMyn
   y_out%YawBrMzn = a1*y1%YawBrMzn + a2*y2%YawBrMzn + a3*y3%YawBrMzn
   y_out%NcIMURAxs = a1*y1%NcIMURAxs + a2*y2%NcIMURAxs + a3*y3%NcIMURAxs
   y_out%NcIMURAys = a1*y1%NcIMURAys + a2*y2%NcIMURAys + a3*y3%NcIMURAys
   y_out%NcIMURAzs = a1*y1%NcIMURAzs + a2*y2%NcIMURAzs + a3*y3%NcIMURAzs
   y_out%RotPwr = a1*y1%RotPwr + a2*y2%RotPwr + a3*y3%RotPwr
   y_out%LSShftFxa = a1*y1%LSShftFxa + a2*y2%LSShftFxa + a3*y3%LSShftFxa
   y_out%LSShftFys = a1*y1%LSShftFys + a2*y2%LSShftFys + a3*y3%LSShftFys
   y_out%LSShftFzs = a1*y1%LSShftFzs + a2*y2%LSShftFzs + a3*y3%LSShftFzs
END SUBROUTINE
END MODULE ElastoDyn_Types
!ENDOFREGISTRYGENERATEDFILE
