!STARTOFREGISTRYGENERATEDFILE 'BeamDyn_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! BeamDyn_Types
!.................................................................................................................................
! This file is part of BeamDyn.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in BeamDyn. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE BeamDyn_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE NWTC_Library
IMPLICIT NONE
    INTEGER(IntKi), PUBLIC, PARAMETER  :: BD_STATIC_ANALYSIS = 1      ! Constant for static analysis. InputType%Dynamic = FALSE. [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: BD_DYNAMIC_ANALYSIS = 2      ! Constant for dynamic analysis. InputType%Dynamic = TRUE .AND. BD_InputFile%QuasiStaticSolve = FALSE [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: BD_DYN_SSS_ANALYSIS = 3      ! Constant for dynamic analysis with Steady State Startup solve. InputType%Dynamic = TRUE .AND. BD_InputFile%QuasiStaticSolve = TRUE [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: BD_MESH_FE = 1      ! Constant for creating y%BldMotion at the FE (GLL) nodes [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: BD_MESH_QP = 2      ! Constant for creating y%BldMotion at the quadrature nodes [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: BD_MESH_STATIONS = 3      ! Constant for creating y%BldMotion at the blade property input stations [-]
! =========  BD_InitInputType  =======
  TYPE, PUBLIC :: BD_InitInputType
    CHARACTER(1024)  :: InputFile      !< Name of the input file; remove if there is no file [-]
    CHARACTER(1024)  :: RootName      !< RootName for writing output files [-]
    REAL(ReKi) , DIMENSION(1:3)  :: gravity = 0.0_ReKi      !< Gravitational acceleration [m/s^2]
    REAL(ReKi) , DIMENSION(1:3)  :: GlbPos = 0.0_ReKi      !< Initial Position Vector of the local blade coordinate system [-]
    REAL(R8Ki) , DIMENSION(1:3,1:3)  :: GlbRot = 0.0_R8Ki      !< Initial direction cosine matrix of the local blade coordinate system -- in BD coords [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: RootDisp = 0.0_R8Ki      !< Initial root displacement [-]
    REAL(R8Ki) , DIMENSION(1:3,1:3)  :: RootOri = 0.0_R8Ki      !< Initial root orientation [-]
    REAL(ReKi) , DIMENSION(1:6)  :: RootVel = 0.0_ReKi      !< Initial root velocities and angular veolcities [-]
    REAL(ReKi) , DIMENSION(1:3)  :: HubPos = 0.0_ReKi      !< Initial Hub position vector [-]
    REAL(R8Ki) , DIMENSION(1:3,1:3)  :: HubRot = 0.0_R8Ki      !< Initial Hub direction cosine matrix [-]
    LOGICAL  :: Linearize = .FALSE.      !< Flag that tells this module if the glue code wants to linearize. [-]
    LOGICAL  :: DynamicSolve = .TRUE.      !< Use dynamic solve option.  Set to False for static solving (handled by glue code or driver code). [-]
    LOGICAL  :: CompAeroMaps = .FALSE.      !< flag to determine if BeamDyn is computing aero maps (true) or running a normal simulation (false) [-]
  END TYPE BD_InitInputType
! =======================
! =========  BD_InitOutputType  =======
  TYPE, PUBLIC :: BD_InitOutputType
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputHdr      !< Names of the output-to-file channels [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputUnt      !< Units of the output-to-file channels [-]
    TYPE(ProgDesc)  :: Ver      !< This module's name, version, and date [-]
    CHARACTER(LinChanLen) , DIMENSION(:), ALLOCATABLE  :: LinNames_y      !< Names of the outputs used in linearization [-]
    CHARACTER(LinChanLen) , DIMENSION(:), ALLOCATABLE  :: LinNames_x      !< Names of the continuous states used in linearization [-]
    CHARACTER(LinChanLen) , DIMENSION(:), ALLOCATABLE  :: LinNames_u      !< Names of the inputs used in linearization [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: RotFrame_y      !< Flag that tells FAST/MBC3 if the outputs used in linearization are in the rotating frame [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: RotFrame_x      !< Flag that tells FAST/MBC3 if the continuous states used in linearization are in the rotating frame (not used for glue) [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: RotFrame_u      !< Flag that tells FAST/MBC3 if the inputs used in linearization are in the rotating frame [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: IsLoad_u      !< Flag that tells FAST if the inputs used in linearization are loads (for preconditioning matrix) [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: DerivOrder_x      !< Integer that tells FAST/MBC3 the maximum derivative order of continuous states used in linearization [-]
  END TYPE BD_InitOutputType
! =======================
! =========  BladeInputData  =======
  TYPE, PUBLIC :: BladeInputData
    INTEGER(IntKi)  :: station_total = 0_IntKi      !< Number of blade input stations [-]
    INTEGER(IntKi)  :: format_index = 0_IntKi      !< Number of blade input stations [-]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: station_eta      !< Station location in eta [0,1] [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: stiff0      !< C/S stiffness matrix arrays [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: mass0      !< C/S mass matrix arrays [-]
    REAL(R8Ki) , DIMENSION(1:6)  :: beta = 0.0_R8Ki      !< Damping Coefficient [-]
    INTEGER(IntKi)  :: damp_flag = 0_IntKi      !< Damping Flag: 0-No Damping, 1-Damped [-]
  END TYPE BladeInputData
! =======================
! =========  BD_InputFile  =======
  TYPE, PUBLIC :: BD_InputFile
    INTEGER(IntKi)  :: member_total = 0_IntKi      !< Total number of members [-]
    INTEGER(IntKi)  :: kp_total = 0_IntKi      !< Total number of key point [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: kp_member      !< Number of key points in each member [-]
    INTEGER(IntKi)  :: order_elem = 0_IntKi      !< Order of interpolation (basis) function [-]
    INTEGER(IntKi)  :: load_retries = 0_IntKi      !< Maximum Number of factored load retries [-]
    INTEGER(IntKi)  :: NRMax = 0_IntKi      !< Max number of iterations in Newton Raphson algorithm [-]
    INTEGER(IntKi)  :: quadrature = 0_IntKi      !< Quadrature: 1: Gauss; 2: Trapezoidal [-]
    INTEGER(IntKi)  :: n_fact = 0_IntKi      !< Factorization frequency [-]
    INTEGER(IntKi)  :: refine = 0_IntKi      !< FE mesh refinement factor for trapezoidal quadrature [-]
    REAL(DbKi)  :: rhoinf = 0.0_R8Ki      !< Numerical damping parameter for generalized-alpha integrator [-]
    REAL(DbKi)  :: DTBeam = 0.0_R8Ki      !< Time interval for BeamDyn  calculations {or default} (s) [-]
    TYPE(BladeInputData)  :: InpBl      !< Input data for individual blades [see BladeInputData Type]
    CHARACTER(1024)  :: BldFile      !< Name of blade input file [-]
    LOGICAL  :: UsePitchAct = .false.      !< Whether to use a pitch actuator inside BeamDyn [(flag)]
    LOGICAL  :: QuasiStaticInit = .false.      !< Use quasistatic pre-conditioning with centripetal accelerations in initialization (flag) [dynamic solve and enFAST only] [-]
    REAL(R8Ki)  :: stop_tol = 0.0_R8Ki      !< Tolerance for stopping criterion [-]
    REAL(R8Ki)  :: tngt_stf_pert = 0.0_R8Ki      !< Perturbation size for computing finite differenced tangent stiffness [-]
    REAL(R8Ki)  :: tngt_stf_difftol = 0.0_R8Ki      !< When comparing tangent stiffness matrix, stop simulation if error greater than this [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: kp_coordinate      !< Key point coordinates array [-]
    REAL(R8Ki)  :: pitchJ = 0.0_R8Ki      !< Pitch actuator inertia [(kg-m^2)]
    REAL(R8Ki)  :: pitchK = 0.0_R8Ki      !< Pitch actuator stiffness [(kg-m^2/s^2)]
    REAL(R8Ki)  :: pitchC = 0.0_R8Ki      !< Pitch actuator damping [-]
    LOGICAL  :: Echo = .false.      !< Echo [-]
    LOGICAL  :: RotStates = .TRUE.      !< Orient states in rotating frame during linearization? (flag) [-]
    LOGICAL  :: RelStates = .FALSE.      !< Define states relative to root motion during linearization? (flag) [-]
    LOGICAL  :: tngt_stf_fd = .false.      !< Flag to compute tangent stifness matrix via finite difference [-]
    LOGICAL  :: tngt_stf_comp = .false.      !< Flag to compare finite differenced and analytical tangent stifness [-]
    INTEGER(IntKi)  :: NNodeOuts = 0_IntKi      !< Number of node outputs [0 - 9] [-]
    INTEGER(IntKi) , DIMENSION(1:9)  :: OutNd = 0_IntKi      !< Nodes whose values will be output [-]
    INTEGER(IntKi)  :: NumOuts = 0_IntKi      !< Number of parameters in the output list (number of outputs requested) [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: OutList      !< List of user-requested output channels [-]
    LOGICAL  :: SumPrint = .false.      !< Print summary data to file? (.sum) [-]
    CHARACTER(20)  :: OutFmt      !< Format specifier [-]
    INTEGER(IntKi)  :: BldNd_NumOuts = 0_IntKi      !< Number of requested output channels per blade node (BD_BldNdOuts) [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: BldNd_OutList      !< List of user-requested output channels (BD_BldNdOuts) [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: BldNd_BlOutNd      !< The blade nodes to actually output (BD_BldNdOuts) [-]
    CHARACTER(1024)  :: BldNd_BlOutNd_Str      !< String to parse for the blade nodes to actually output (BD_BldNdOuts) [-]
  END TYPE BD_InputFile
! =======================
! =========  BD_ContinuousStateType  =======
  TYPE, PUBLIC :: BD_ContinuousStateType
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: q      !< q - displacement (1:3), and rotation displacement parameters (4:6) [m,-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: dqdt      !< dqdt - velocity [m/s]
  END TYPE BD_ContinuousStateType
! =======================
! =========  BD_DiscreteStateType  =======
  TYPE, PUBLIC :: BD_DiscreteStateType
    REAL(ReKi)  :: thetaP = 0.0_ReKi      !< Pitch angle state [-]
    REAL(ReKi)  :: thetaPD = 0.0_ReKi      !< Pitch rate state [-]
  END TYPE BD_DiscreteStateType
! =======================
! =========  BD_ConstraintStateType  =======
  TYPE, PUBLIC :: BD_ConstraintStateType
    REAL(ReKi)  :: DummyConstrState = 0.0_ReKi      !< A variable, Replace if you have constraint states [-]
  END TYPE BD_ConstraintStateType
! =======================
! =========  BD_OtherStateType  =======
  TYPE, PUBLIC :: BD_OtherStateType
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: acc      !< Acceleration (dqdtdt) [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: xcc      !< Algorithm acceleration in GA2: (1-alpha_m)*xcc_(n+1) = (1-alpha_f)*Acc_(n+1) + alpha_f*Acc_n - alpha_m*xcc_n [-]
    LOGICAL  :: InitAcc = .false.      !< flag to determine if accerlerations have been initialized in updateStates [-]
    LOGICAL  :: RunQuasiStaticInit = .false.      !< flag to determine if quasi-static solution initialization should be run again (with load inputs) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: GlbPos = 0.0_R8Ki      !< Position Vector between origins of Global (moving frame) and blade frames (BD coordinates)  Follows the RootMotion mesh [-]
    REAL(R8Ki) , DIMENSION(1:3,1:3)  :: GlbRot = 0.0_R8Ki      !< Rotation Tensor between Global (moving frame) and Blade frames (BD coordinates; transfers local to global).  Follows the RootMotion mesh [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: Glb_crv = 0.0_R8Ki      !< CRV parameters of GlbRot.  Follows the RootMotion mesh [-]
  END TYPE BD_OtherStateType
! =======================
! =========  qpParam  =======
  TYPE, PUBLIC :: qpParam
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: mmm      !< Mass at current QP [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: mEta      !< Center of mass location times mass: (m*X_cm, m*Y_cm, m*Z_cm) where X_cm = 0 [-]
  END TYPE qpParam
! =======================
! =========  BD_ParameterType  =======
  TYPE, PUBLIC :: BD_ParameterType
    REAL(DbKi)  :: dt = 0.0_R8Ki      !< module dt [s]
    REAL(DbKi) , DIMENSION(1:9)  :: coef = 0.0_R8Ki      !< GA2 Coefficient [-]
    REAL(DbKi)  :: rhoinf = 0.0_R8Ki      !< Numerical Damping Coefficient for GA2 [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: uuN0      !< Initial Postion Vector of GLL (FE) nodes (index 1=DOF; index 2=FE nodes; index 3=element) [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: Stif0_QP      !< Sectional Stiffness Properties at quadrature points (6x6xqp) [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: Mass0_QP      !< Sectional Mass Properties at quadrature points (6x6xqp) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: gravity = 0.0_R8Ki      !< Gravitational acceleration -- intertial frame!!! [m/s^2]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: segment_eta      !< Array stored length ratio of each segment w.r.t. member it lies in [-]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: member_eta      !< Array stored length ratio of each member  w.r.t. entire blade [-]
    REAL(R8Ki)  :: blade_length = 0.0_R8Ki      !< Blade Length [-]
    REAL(R8Ki)  :: blade_mass = 0.0_R8Ki      !< Blade mass [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: blade_CG = 0.0_R8Ki      !< Blade center of gravity [-]
    REAL(R8Ki) , DIMENSION(1:3,1:3)  :: blade_IN = 0.0_R8Ki      !< Blade Length [-]
    REAL(R8Ki) , DIMENSION(1:6)  :: beta = 0.0_R8Ki      !< Damping Coefficient [-]
    REAL(R8Ki)  :: tol = 0.0_R8Ki      !< Tolerance used in stopping criterion [-]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: QPtN      !< Quadrature (QuadPt) point locations in natural frame [-1, 1] [-]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: QPtWeight      !< Weights at each quadrature point (QuadPt) [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: Shp      !< Shape function matrix (index 1 = FE nodes; index 2=quadrature points) [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: ShpDer      !< Derivative of shape function matrix (index 1 = FE nodes; index 2=quadrature points) [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: Jacobian      !< Jacobian value at each quadrature point [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: uu0      !< Initial Disp/Rot value at quadrature point (at T=0) [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: rrN0      !< Initial relative rotation array, relative to root (at T=0) (index 1=rot DOF; index 2=FE nodes; index 3=element) [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: E10      !< Initial E10 at quadrature point [-]
    INTEGER(IntKi)  :: nodes_per_elem = 0_IntKi      !< Finite element (GLL) nodes per element [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: node_elem_idx      !< Index to first and last nodes of element in p%node_total sized arrays [-]
    INTEGER(IntKi)  :: refine = 0_IntKi      !< FE mesh refinement factor for trapezoidal quadrature [-]
    INTEGER(IntKi)  :: dof_node = 0_IntKi      !< dof per node [-]
    INTEGER(IntKi)  :: dof_elem = 0_IntKi      !< dof per element [-]
    INTEGER(IntKi)  :: rot_elem = 0_IntKi      !< rotational dof per element [-]
    INTEGER(IntKi)  :: elem_total = 0_IntKi      !< Total number of elements [-]
    INTEGER(IntKi)  :: node_total = 0_IntKi      !< Total number of finite element (GLL) nodes [-]
    INTEGER(IntKi)  :: dof_total = 0_IntKi      !< Total number of dofs [-]
    INTEGER(IntKi)  :: nqp = 0_IntKi      !< Number of quadrature points (per element) [-]
    INTEGER(IntKi)  :: analysis_type = 0_IntKi      !< analysis_type flag [-]
    INTEGER(IntKi)  :: damp_flag = 0_IntKi      !< damping flag [-]
    INTEGER(IntKi)  :: ld_retries = 0_IntKi      !< Maximum Number of factored load retries [-]
    INTEGER(IntKi)  :: niter = 0_IntKi      !< Maximum number of iterations in Newton-Raphson algorithm [-]
    INTEGER(IntKi)  :: quadrature = 0_IntKi      !< Quadrature method: 1 Gauss 2 Trapezoidal [-]
    INTEGER(IntKi)  :: n_fact = 0_IntKi      !< Factorization frequency [-]
    LOGICAL  :: OutInputs = .false.      !< Determines if we've asked to output the inputs (do we need mesh transfer?) [-]
    INTEGER(IntKi)  :: NumOuts = 0_IntKi      !< Number of parameters in the output list (number of outputs requested) [-]
    TYPE(OutParmType) , DIMENSION(:), ALLOCATABLE  :: OutParam      !< Names and units (and other characteristics) of all requested output parameters [-]
    INTEGER(IntKi)  :: NNodeOuts = 0_IntKi      !< Number of nodes to output data to a file[0 - 9] [-]
    INTEGER(IntKi) , DIMENSION(1:9)  :: OutNd = 0_IntKi      !< Nodes whose values will be output [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: NdIndx      !< Index into BldMotion mesh (to number the nodes for output without using collocated nodes) [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: NdIndxInverse      !< Index from BldMotion mesh to unique nodes (to number the nodes for output without using collocated nodes) [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: OutNd2NdElem      !< To go from an output node number to a node/elem pair [-]
    CHARACTER(20)  :: OutFmt      !< Format specifier [-]
    LOGICAL  :: UsePitchAct = .false.      !< Whether to use a pitch actuator inside BeamDyn [(flag)]
    REAL(ReKi)  :: pitchJ = 0.0_ReKi      !< Pitch actuator inertia [(kg-m^2)]
    REAL(ReKi)  :: pitchK = 0.0_ReKi      !< Pitch actuator stiffness [(kg-m^2/s^2)]
    REAL(ReKi)  :: pitchC = 0.0_ReKi      !< Pitch actuator damping [-]
    REAL(ReKi) , DIMENSION(1:2,1:2)  :: torqM = 0.0_ReKi      !< Pitch actuator matrix: (I-hA)^-1 [-]
    TYPE(qpParam)  :: qp      !< Quadrature point info that does not change during simulation [-]
    INTEGER(IntKi)  :: qp_indx_offset = 0_IntKi      !< Offset for computing index of the quadrature arrays (gauss skips the first [end-point] node) [-]
    INTEGER(IntKi)  :: BldMotionNodeLoc = 0_IntKi      !< switch to determine where the nodes on the blade motion mesh should be located 1=FE (GLL) nodes; 2=quadrature nodes; 3=blade input stations [-]
    LOGICAL  :: tngt_stf_fd = .false.      !< Flag to compute tangent stifness matrix via finite difference [-]
    LOGICAL  :: tngt_stf_comp = .false.      !< Flag to compare finite differenced and analytical tangent stifness [-]
    REAL(R8Ki)  :: tngt_stf_pert = 0.0_R8Ki      !< Perturbation size for computing finite differenced tangent stiffness [-]
    REAL(R8Ki)  :: tngt_stf_difftol = 0.0_R8Ki      !< When comparing tangent stiffness matrix, stop simulation if error greater than this [-]
    INTEGER(IntKi)  :: BldNd_NumOuts = 0_IntKi      !< [BD_BldNdOuts] Number of requested output channels per blade node [-]
    INTEGER(IntKi)  :: BldNd_TotNumOuts = 0_IntKi      !< [BD_BldNdOuts] Total number of requested output channels of blade node information (equal to BldNd_NumOuts * BldNd_BlOutNd) [-]
    TYPE(OutParmType) , DIMENSION(:), ALLOCATABLE  :: BldNd_OutParam      !< [BD_BldNdOuts] Names and units (and other characteristics) of all requested output parameters [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: BldNd_BlOutNd      !< [BD_BldNdOuts] The blade nodes to actually output [-]
    REAL(R8Ki) , DIMENSION(:,:,:,:), ALLOCATABLE  :: QPtw_Shp_Shp_Jac      !< optimization variable: QPtw_Shp_Shp_Jac(idx_qp,i,j,nelem) = p%Shp(i,idx_qp)*p%Shp(j,idx_qp)*p%QPtWeight(idx_qp)*p%Jacobian(idx_qp,nelem) [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: QPtw_Shp_ShpDer      !< optimization variable: QPtw_Shp_ShpDer(idx_qp,i,j) = p%Shp(i,idx_qp)*p%ShpDer(j,idx_qp)*p%QPtWeight(idx_qp) [-]
    REAL(R8Ki) , DIMENSION(:,:,:,:), ALLOCATABLE  :: QPtw_ShpDer_ShpDer_Jac      !< optimization variable: QPtw_ShpDer_ShpDer_Jac(idx_qp,i,j,nelem) = p%ShpDer(i,idx_qp)*p%ShpDer(j,idx_qp)*p%QPtWeight(idx_qp)/p%Jacobian(idx_qp,nelem) [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: QPtw_Shp_Jac      !< optimization variable: QPtw_Shp_Jac(idx_qp,i,nelem) = p%Shp(i,idx_qp)*p%QPtWeight(idx_qp)*p%Jacobian(idx_qp,nelem) [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: QPtw_ShpDer      !< optimization variable: QPtw_ShpDer(idx_qp,i) = p%ShpDer(i,idx_qp)*p%QPtWeight(idx_qp) [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: FEweight      !< weighting factors for integrating local sectional loads [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: Jac_u_indx      !< matrix to help fill/pack the u vector in computing the jacobian [-]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: du      !< vector that determines size of perturbation for u (inputs) [-]
    REAL(R8Ki) , DIMENSION(1:6)  :: dx = 0.0_R8Ki      !< vector that determines size of perturbation for x (continuous states) [-]
    INTEGER(IntKi)  :: Jac_ny = 0_IntKi      !< number of outputs in jacobian matrix [-]
    INTEGER(IntKi)  :: Jac_nx = 0_IntKi      !< half the number of continuous states in jacobian matrix [-]
    LOGICAL  :: RotStates = .false.      !< Orient states in rotating frame during linearization? (flag) [-]
    LOGICAL  :: RelStates = .false.      !< Define states relative to root motion during linearization? (flag) [-]
    LOGICAL  :: CompAeroMaps = .FALSE.      !< flag to determine if BeamDyn is computing aero maps (true) or running a normal simulation (false) [-]
    LOGICAL  :: CompAppliedLdAtRoot = .FALSE.      !< flag to determine if BeamDyn should compute the applied loads at root [-]
  END TYPE BD_ParameterType
! =======================
! =========  BD_InputType  =======
  TYPE, PUBLIC :: BD_InputType
    TYPE(MeshType)  :: RootMotion      !< contains motion [-]
    TYPE(MeshType)  :: PointLoad      !< Applied point forces along beam axis [-]
    TYPE(MeshType)  :: DistrLoad      !< Applied distributed forces along beam axis [-]
    TYPE(MeshType)  :: HubMotion      !< motion (orientation) at the hub [-]
  END TYPE BD_InputType
! =======================
! =========  BD_OutputType  =======
  TYPE, PUBLIC :: BD_OutputType
    TYPE(MeshType)  :: ReactionForce      !< contains force and moments [-]
    TYPE(MeshType)  :: BldMotion      !< Motion (disp,rot,vel, acc) along beam axis [-]
    REAL(ReKi)  :: RootMxr = 0.0_ReKi      !< x-component of the root reaction moment expressed in r (used for ServoDyn Bladed DLL Interface) [Nm]
    REAL(ReKi)  :: RootMyr = 0.0_ReKi      !< y-component of the root reaction moment expressed in r (used for ServoDyn Bladed DLL Interface) [Nm]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WriteOutput      !< Data to be written to an output file: see WriteOutputHdr for names of each variable [see WriteOutputUnt]
  END TYPE BD_OutputType
! =======================
! =========  EqMotionQP  =======
  TYPE, PUBLIC :: EqMotionQP
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: uuu      !< Displacement and rotation field [u c] at current QP [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: uup      !< Derivative of uuu with respect to X at current QP [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: vvv      !< Translational velocity and rotational parameter velocity (at current QP) [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: vvp      !< Derivative of vvv with respect to X [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: aaa      !< Translational acceleration and rotational parameter acceration (at current QP) [-]
    REAL(R8Ki) , DIMENSION(:,:,:,:), ALLOCATABLE  :: RR0      !< Rotation tensor at current QP \f$ \left(\underline{\underline{R}}\underline{\underline{R}}_0\right) \f$ [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: kappa      !< Curvature vector \f$ \underline{k} \f$ at current QP (note this is not \kappa, but a term in \kappa) [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: E1      !< \vec{e_1} = x_0^\prime + u^\prime (3) at current QP [-]
    REAL(R8Ki) , DIMENSION(:,:,:,:), ALLOCATABLE  :: Stif      !< C/S stiffness matrix resolved in inertial frame at current QP. 6x6 [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: Fb      !< Gyroscopic forces at current QP. 6 [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: Fc      !< Elastic force \f$ \underline{F}^c \f$ at current QP. 6 [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: Fd      !< Elastic force \f$ \underline{F}^d \f$ at current QP. 6 [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: Fg      !< Gravity forces at current QP. 6 [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: Fi      !< Inertial forces at current QP. 6 [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: Ftemp      !< Sum of some of the forces at current QP. 6 [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: RR0mEta      !< RR0 times Center of mass location times mass: (m*X_cm, m*Y_cm, m*Z_cm) where X_cm = 0 [-]
    REAL(R8Ki) , DIMENSION(:,:,:,:), ALLOCATABLE  :: rho      !< Tensor of inertia resolved in inertia frame at quadrature point. 3x3 [-]
    REAL(R8Ki) , DIMENSION(:,:,:,:), ALLOCATABLE  :: betaC      !< No idea.  Used in dissipative force.  6x6 [-]
    REAL(R8Ki) , DIMENSION(:,:,:,:), ALLOCATABLE  :: Gi      !< Gyroscopic matrix for inertial force. 6x6 [-]
    REAL(R8Ki) , DIMENSION(:,:,:,:), ALLOCATABLE  :: Ki      !< Stiffness matrix for inertial force. 6x6 [-]
    REAL(R8Ki) , DIMENSION(:,:,:,:), ALLOCATABLE  :: Mi      !< Mass matrix for inertial force. 6x6 [-]
    REAL(R8Ki) , DIMENSION(:,:,:,:), ALLOCATABLE  :: Oe      !< \f$ \underline{\underline{\mathcal{O}}} \f$ from equation (19) of NREL CP-2C00-60759. 6x6 [-]
    REAL(R8Ki) , DIMENSION(:,:,:,:), ALLOCATABLE  :: Pe      !< \f$ \underline{\underline{\mathcal{P}}} \f$ from equation (20) of NREL CP-2C00-60759. 6x6 [-]
    REAL(R8Ki) , DIMENSION(:,:,:,:), ALLOCATABLE  :: Qe      !< \f$ \underline{\underline{\mathcal{Q}}} \f$ from equation (21) of NREL CP-2C00-60759. 6x6 [-]
    REAL(R8Ki) , DIMENSION(:,:,:,:), ALLOCATABLE  :: Gd      !< Dissipative term for gyroscopic term. 6x6 [-]
    REAL(R8Ki) , DIMENSION(:,:,:,:), ALLOCATABLE  :: Od      !< Dissipative term on O. 6x6 [-]
    REAL(R8Ki) , DIMENSION(:,:,:,:), ALLOCATABLE  :: Pd      !< Dissipative term on P. 6x6 [-]
    REAL(R8Ki) , DIMENSION(:,:,:,:), ALLOCATABLE  :: Qd      !< Dissipative term on Q. 6x6 [-]
    REAL(R8Ki) , DIMENSION(:,:,:,:), ALLOCATABLE  :: Sd      !< Dissipative term on S. 6x6 [-]
    REAL(R8Ki) , DIMENSION(:,:,:,:), ALLOCATABLE  :: Xd      !< Dissipative term on X. 6x6 [-]
    REAL(R8Ki) , DIMENSION(:,:,:,:), ALLOCATABLE  :: Yd      !< Dissipative term on Y. 6x6 [-]
  END TYPE EqMotionQP
! =======================
! =========  BD_MiscVarType  =======
  TYPE, PUBLIC :: BD_MiscVarType
    TYPE(MeshType)  :: u_DistrLoad_at_y      !< input loads at output node locations [-]
    TYPE(MeshType)  :: y_BldMotion_at_u      !< output motions at input node locations (displacements necessary for mapping loads) [-]
    TYPE(MeshType)  :: LoadsAtRoot      !< Applied loads mapped to root [-]
    TYPE(MeshMapType)  :: Map_u_DistrLoad_to_y      !< mapping of input loads to output node locations [-]
    TYPE(MeshMapType)  :: Map_y_BldMotion_to_u      !< mapping of output motions to input node locations (for load transfer) [-]
    TYPE(MeshMapType)  :: Map_u_DistrLoad_to_R      !< mapping of input loads to root location [-]
    INTEGER(IntKi)  :: Un_Sum = 0_IntKi      !< unit number of summary file [-]
    TYPE(EqMotionQP)  :: qp      !< Quadrature point calculation info [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: lin_A      !< A (dXdx) matrix used in linearization (before RotState is applied) [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: lin_C      !< C (dYdx) matrix used in linearization (before RotState is applied) [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: Nrrr      !< Rotation parameters relative to root node, from Nuuu (at GLL points) [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: elf      !<  [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: EFint      !< Elastic forces internal to blade.  For output calculations only. [-]
    REAL(R8Ki) , DIMENSION(:,:,:,:), ALLOCATABLE  :: elk      !<  [-]
    REAL(R8Ki) , DIMENSION(:,:,:,:), ALLOCATABLE  :: elg      !<  [-]
    REAL(R8Ki) , DIMENSION(:,:,:,:), ALLOCATABLE  :: elm      !<  [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: DistrLoad_QP      !< Copy of the distributed load, in the BD reference frame [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: PointLoadLcl      !< Copy of the point loads, in the BD reference frame [-]
    REAL(R8Ki) , DIMENSION(:,:,:,:), ALLOCATABLE  :: StifK      !< Stiffness Matrix [-]
    REAL(R8Ki) , DIMENSION(:,:,:,:), ALLOCATABLE  :: MassM      !< Mass Matrix [-]
    REAL(R8Ki) , DIMENSION(:,:,:,:), ALLOCATABLE  :: DampG      !< Damping Matrix [-]
    REAL(R8Ki) , DIMENSION(:,:,:,:), ALLOCATABLE  :: StifK_fd      !< Finite differenced Stiffness Matrix [-]
    REAL(R8Ki) , DIMENSION(:,:,:,:), ALLOCATABLE  :: MassM_fd      !< Finite differenced Mass Matrix [-]
    REAL(R8Ki) , DIMENSION(:,:,:,:), ALLOCATABLE  :: DampG_fd      !< Finite differenced Damping Matrix [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: RHS      !< Right-hand-side vector [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: RHS_p      !< Positive fd perturbation of RHS [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: RHS_m      !< Negative fd perturbation of RHS [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: BldInternalForceFE      !< Force/Moment array for internal force calculations at FE [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: BldInternalForceQP      !< Force/Moment array for internal force calculations at QP [-]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: FirstNodeReactionLclForceMoment      !< Force/Moment array for first node reaction.  Needed in InternalForce calculations. [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: Solution      !< Result from LAPACK solve (X from A*X = B solve) [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: LP_StifK      !< Stiffness Matrix [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: LP_MassM      !< Mass Matrix [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: LP_MassM_LU      !< Mass Matrix for LU [-]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: LP_RHS      !< Right-hand-side vector [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: LP_StifK_LU      !< Stiffness Matrix for LU [-]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: LP_RHS_LU      !< Right-hand-side vector for LU [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: LP_indx      !< Index vector for LU [-]
    TYPE(BD_InputType)  :: u      !< Inputs converted to the internal BD coordinate system [-]
    TYPE(BD_InputType)  :: u2      !< Inputs in the FAST coordinate system, possibly modified by pitch actuator [-]
  END TYPE BD_MiscVarType
! =======================
CONTAINS

subroutine BD_CopyInitInput(SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg)
   type(BD_InitInputType), intent(in) :: SrcInitInputData
   type(BD_InitInputType), intent(inout) :: DstInitInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'BD_CopyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInitInputData%InputFile = SrcInitInputData%InputFile
   DstInitInputData%RootName = SrcInitInputData%RootName
   DstInitInputData%gravity = SrcInitInputData%gravity
   DstInitInputData%GlbPos = SrcInitInputData%GlbPos
   DstInitInputData%GlbRot = SrcInitInputData%GlbRot
   DstInitInputData%RootDisp = SrcInitInputData%RootDisp
   DstInitInputData%RootOri = SrcInitInputData%RootOri
   DstInitInputData%RootVel = SrcInitInputData%RootVel
   DstInitInputData%HubPos = SrcInitInputData%HubPos
   DstInitInputData%HubRot = SrcInitInputData%HubRot
   DstInitInputData%Linearize = SrcInitInputData%Linearize
   DstInitInputData%DynamicSolve = SrcInitInputData%DynamicSolve
   DstInitInputData%CompAeroMaps = SrcInitInputData%CompAeroMaps
end subroutine

subroutine BD_DestroyInitInput(InitInputData, ErrStat, ErrMsg)
   type(BD_InitInputType), intent(inout) :: InitInputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'BD_DestroyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine BD_PackInitInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(BD_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'BD_PackInitInput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%InputFile)
   call RegPack(RF, InData%RootName)
   call RegPack(RF, InData%gravity)
   call RegPack(RF, InData%GlbPos)
   call RegPack(RF, InData%GlbRot)
   call RegPack(RF, InData%RootDisp)
   call RegPack(RF, InData%RootOri)
   call RegPack(RF, InData%RootVel)
   call RegPack(RF, InData%HubPos)
   call RegPack(RF, InData%HubRot)
   call RegPack(RF, InData%Linearize)
   call RegPack(RF, InData%DynamicSolve)
   call RegPack(RF, InData%CompAeroMaps)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BD_UnPackInitInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(BD_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'BD_UnPackInitInput'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%InputFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%gravity); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GlbPos); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GlbRot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootDisp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootOri); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootVel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HubPos); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HubRot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Linearize); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DynamicSolve); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CompAeroMaps); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BD_CopyInitOutput(SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg)
   type(BD_InitOutputType), intent(in) :: SrcInitOutputData
   type(BD_InitOutputType), intent(inout) :: DstInitOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'BD_CopyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcInitOutputData%WriteOutputHdr)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputHdr)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputHdr)
      if (.not. allocated(DstInitOutputData%WriteOutputHdr)) then
         allocate(DstInitOutputData%WriteOutputHdr(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputHdr.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputHdr = SrcInitOutputData%WriteOutputHdr
   end if
   if (allocated(SrcInitOutputData%WriteOutputUnt)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputUnt)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputUnt)
      if (.not. allocated(DstInitOutputData%WriteOutputUnt)) then
         allocate(DstInitOutputData%WriteOutputUnt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputUnt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputUnt = SrcInitOutputData%WriteOutputUnt
   end if
   call NWTC_Library_CopyProgDesc(SrcInitOutputData%Ver, DstInitOutputData%Ver, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcInitOutputData%LinNames_y)) then
      LB(1:1) = lbound(SrcInitOutputData%LinNames_y)
      UB(1:1) = ubound(SrcInitOutputData%LinNames_y)
      if (.not. allocated(DstInitOutputData%LinNames_y)) then
         allocate(DstInitOutputData%LinNames_y(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LinNames_y.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%LinNames_y = SrcInitOutputData%LinNames_y
   end if
   if (allocated(SrcInitOutputData%LinNames_x)) then
      LB(1:1) = lbound(SrcInitOutputData%LinNames_x)
      UB(1:1) = ubound(SrcInitOutputData%LinNames_x)
      if (.not. allocated(DstInitOutputData%LinNames_x)) then
         allocate(DstInitOutputData%LinNames_x(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LinNames_x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%LinNames_x = SrcInitOutputData%LinNames_x
   end if
   if (allocated(SrcInitOutputData%LinNames_u)) then
      LB(1:1) = lbound(SrcInitOutputData%LinNames_u)
      UB(1:1) = ubound(SrcInitOutputData%LinNames_u)
      if (.not. allocated(DstInitOutputData%LinNames_u)) then
         allocate(DstInitOutputData%LinNames_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LinNames_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%LinNames_u = SrcInitOutputData%LinNames_u
   end if
   if (allocated(SrcInitOutputData%RotFrame_y)) then
      LB(1:1) = lbound(SrcInitOutputData%RotFrame_y)
      UB(1:1) = ubound(SrcInitOutputData%RotFrame_y)
      if (.not. allocated(DstInitOutputData%RotFrame_y)) then
         allocate(DstInitOutputData%RotFrame_y(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%RotFrame_y.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%RotFrame_y = SrcInitOutputData%RotFrame_y
   end if
   if (allocated(SrcInitOutputData%RotFrame_x)) then
      LB(1:1) = lbound(SrcInitOutputData%RotFrame_x)
      UB(1:1) = ubound(SrcInitOutputData%RotFrame_x)
      if (.not. allocated(DstInitOutputData%RotFrame_x)) then
         allocate(DstInitOutputData%RotFrame_x(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%RotFrame_x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%RotFrame_x = SrcInitOutputData%RotFrame_x
   end if
   if (allocated(SrcInitOutputData%RotFrame_u)) then
      LB(1:1) = lbound(SrcInitOutputData%RotFrame_u)
      UB(1:1) = ubound(SrcInitOutputData%RotFrame_u)
      if (.not. allocated(DstInitOutputData%RotFrame_u)) then
         allocate(DstInitOutputData%RotFrame_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%RotFrame_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%RotFrame_u = SrcInitOutputData%RotFrame_u
   end if
   if (allocated(SrcInitOutputData%IsLoad_u)) then
      LB(1:1) = lbound(SrcInitOutputData%IsLoad_u)
      UB(1:1) = ubound(SrcInitOutputData%IsLoad_u)
      if (.not. allocated(DstInitOutputData%IsLoad_u)) then
         allocate(DstInitOutputData%IsLoad_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%IsLoad_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%IsLoad_u = SrcInitOutputData%IsLoad_u
   end if
   if (allocated(SrcInitOutputData%DerivOrder_x)) then
      LB(1:1) = lbound(SrcInitOutputData%DerivOrder_x)
      UB(1:1) = ubound(SrcInitOutputData%DerivOrder_x)
      if (.not. allocated(DstInitOutputData%DerivOrder_x)) then
         allocate(DstInitOutputData%DerivOrder_x(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%DerivOrder_x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%DerivOrder_x = SrcInitOutputData%DerivOrder_x
   end if
end subroutine

subroutine BD_DestroyInitOutput(InitOutputData, ErrStat, ErrMsg)
   type(BD_InitOutputType), intent(inout) :: InitOutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'BD_DestroyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InitOutputData%WriteOutputHdr)) then
      deallocate(InitOutputData%WriteOutputHdr)
   end if
   if (allocated(InitOutputData%WriteOutputUnt)) then
      deallocate(InitOutputData%WriteOutputUnt)
   end if
   call NWTC_Library_DestroyProgDesc(InitOutputData%Ver, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(InitOutputData%LinNames_y)) then
      deallocate(InitOutputData%LinNames_y)
   end if
   if (allocated(InitOutputData%LinNames_x)) then
      deallocate(InitOutputData%LinNames_x)
   end if
   if (allocated(InitOutputData%LinNames_u)) then
      deallocate(InitOutputData%LinNames_u)
   end if
   if (allocated(InitOutputData%RotFrame_y)) then
      deallocate(InitOutputData%RotFrame_y)
   end if
   if (allocated(InitOutputData%RotFrame_x)) then
      deallocate(InitOutputData%RotFrame_x)
   end if
   if (allocated(InitOutputData%RotFrame_u)) then
      deallocate(InitOutputData%RotFrame_u)
   end if
   if (allocated(InitOutputData%IsLoad_u)) then
      deallocate(InitOutputData%IsLoad_u)
   end if
   if (allocated(InitOutputData%DerivOrder_x)) then
      deallocate(InitOutputData%DerivOrder_x)
   end if
end subroutine

subroutine BD_PackInitOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(BD_InitOutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'BD_PackInitOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%WriteOutputHdr)
   call RegPackAlloc(RF, InData%WriteOutputUnt)
   call NWTC_Library_PackProgDesc(RF, InData%Ver) 
   call RegPackAlloc(RF, InData%LinNames_y)
   call RegPackAlloc(RF, InData%LinNames_x)
   call RegPackAlloc(RF, InData%LinNames_u)
   call RegPackAlloc(RF, InData%RotFrame_y)
   call RegPackAlloc(RF, InData%RotFrame_x)
   call RegPackAlloc(RF, InData%RotFrame_u)
   call RegPackAlloc(RF, InData%IsLoad_u)
   call RegPackAlloc(RF, InData%DerivOrder_x)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BD_UnPackInitOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(BD_InitOutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'BD_UnPackInitOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%WriteOutputHdr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutputUnt); if (RegCheckErr(RF, RoutineName)) return
   call NWTC_Library_UnpackProgDesc(RF, OutData%Ver) ! Ver 
   call RegUnpackAlloc(RF, OutData%LinNames_y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LinNames_x); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LinNames_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RotFrame_y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RotFrame_x); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RotFrame_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%IsLoad_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%DerivOrder_x); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BD_CopyBladeInputData(SrcBladeInputDataData, DstBladeInputDataData, CtrlCode, ErrStat, ErrMsg)
   type(BladeInputData), intent(in) :: SrcBladeInputDataData
   type(BladeInputData), intent(inout) :: DstBladeInputDataData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'BD_CopyBladeInputData'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstBladeInputDataData%station_total = SrcBladeInputDataData%station_total
   DstBladeInputDataData%format_index = SrcBladeInputDataData%format_index
   if (allocated(SrcBladeInputDataData%station_eta)) then
      LB(1:1) = lbound(SrcBladeInputDataData%station_eta)
      UB(1:1) = ubound(SrcBladeInputDataData%station_eta)
      if (.not. allocated(DstBladeInputDataData%station_eta)) then
         allocate(DstBladeInputDataData%station_eta(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladeInputDataData%station_eta.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladeInputDataData%station_eta = SrcBladeInputDataData%station_eta
   end if
   if (allocated(SrcBladeInputDataData%stiff0)) then
      LB(1:3) = lbound(SrcBladeInputDataData%stiff0)
      UB(1:3) = ubound(SrcBladeInputDataData%stiff0)
      if (.not. allocated(DstBladeInputDataData%stiff0)) then
         allocate(DstBladeInputDataData%stiff0(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladeInputDataData%stiff0.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladeInputDataData%stiff0 = SrcBladeInputDataData%stiff0
   end if
   if (allocated(SrcBladeInputDataData%mass0)) then
      LB(1:3) = lbound(SrcBladeInputDataData%mass0)
      UB(1:3) = ubound(SrcBladeInputDataData%mass0)
      if (.not. allocated(DstBladeInputDataData%mass0)) then
         allocate(DstBladeInputDataData%mass0(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladeInputDataData%mass0.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladeInputDataData%mass0 = SrcBladeInputDataData%mass0
   end if
   DstBladeInputDataData%beta = SrcBladeInputDataData%beta
   DstBladeInputDataData%damp_flag = SrcBladeInputDataData%damp_flag
end subroutine

subroutine BD_DestroyBladeInputData(BladeInputDataData, ErrStat, ErrMsg)
   type(BladeInputData), intent(inout) :: BladeInputDataData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'BD_DestroyBladeInputData'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(BladeInputDataData%station_eta)) then
      deallocate(BladeInputDataData%station_eta)
   end if
   if (allocated(BladeInputDataData%stiff0)) then
      deallocate(BladeInputDataData%stiff0)
   end if
   if (allocated(BladeInputDataData%mass0)) then
      deallocate(BladeInputDataData%mass0)
   end if
end subroutine

subroutine BD_PackBladeInputData(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(BladeInputData), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'BD_PackBladeInputData'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%station_total)
   call RegPack(RF, InData%format_index)
   call RegPackAlloc(RF, InData%station_eta)
   call RegPackAlloc(RF, InData%stiff0)
   call RegPackAlloc(RF, InData%mass0)
   call RegPack(RF, InData%beta)
   call RegPack(RF, InData%damp_flag)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BD_UnPackBladeInputData(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(BladeInputData), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'BD_UnPackBladeInputData'
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%station_total); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%format_index); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%station_eta); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%stiff0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%mass0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%beta); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%damp_flag); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BD_CopyInputFile(SrcInputFileData, DstInputFileData, CtrlCode, ErrStat, ErrMsg)
   type(BD_InputFile), intent(in) :: SrcInputFileData
   type(BD_InputFile), intent(inout) :: DstInputFileData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'BD_CopyInputFile'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInputFileData%member_total = SrcInputFileData%member_total
   DstInputFileData%kp_total = SrcInputFileData%kp_total
   if (allocated(SrcInputFileData%kp_member)) then
      LB(1:1) = lbound(SrcInputFileData%kp_member)
      UB(1:1) = ubound(SrcInputFileData%kp_member)
      if (.not. allocated(DstInputFileData%kp_member)) then
         allocate(DstInputFileData%kp_member(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%kp_member.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%kp_member = SrcInputFileData%kp_member
   end if
   DstInputFileData%order_elem = SrcInputFileData%order_elem
   DstInputFileData%load_retries = SrcInputFileData%load_retries
   DstInputFileData%NRMax = SrcInputFileData%NRMax
   DstInputFileData%quadrature = SrcInputFileData%quadrature
   DstInputFileData%n_fact = SrcInputFileData%n_fact
   DstInputFileData%refine = SrcInputFileData%refine
   DstInputFileData%rhoinf = SrcInputFileData%rhoinf
   DstInputFileData%DTBeam = SrcInputFileData%DTBeam
   call BD_CopyBladeInputData(SrcInputFileData%InpBl, DstInputFileData%InpBl, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstInputFileData%BldFile = SrcInputFileData%BldFile
   DstInputFileData%UsePitchAct = SrcInputFileData%UsePitchAct
   DstInputFileData%QuasiStaticInit = SrcInputFileData%QuasiStaticInit
   DstInputFileData%stop_tol = SrcInputFileData%stop_tol
   DstInputFileData%tngt_stf_pert = SrcInputFileData%tngt_stf_pert
   DstInputFileData%tngt_stf_difftol = SrcInputFileData%tngt_stf_difftol
   if (allocated(SrcInputFileData%kp_coordinate)) then
      LB(1:2) = lbound(SrcInputFileData%kp_coordinate)
      UB(1:2) = ubound(SrcInputFileData%kp_coordinate)
      if (.not. allocated(DstInputFileData%kp_coordinate)) then
         allocate(DstInputFileData%kp_coordinate(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%kp_coordinate.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%kp_coordinate = SrcInputFileData%kp_coordinate
   end if
   DstInputFileData%pitchJ = SrcInputFileData%pitchJ
   DstInputFileData%pitchK = SrcInputFileData%pitchK
   DstInputFileData%pitchC = SrcInputFileData%pitchC
   DstInputFileData%Echo = SrcInputFileData%Echo
   DstInputFileData%RotStates = SrcInputFileData%RotStates
   DstInputFileData%RelStates = SrcInputFileData%RelStates
   DstInputFileData%tngt_stf_fd = SrcInputFileData%tngt_stf_fd
   DstInputFileData%tngt_stf_comp = SrcInputFileData%tngt_stf_comp
   DstInputFileData%NNodeOuts = SrcInputFileData%NNodeOuts
   DstInputFileData%OutNd = SrcInputFileData%OutNd
   DstInputFileData%NumOuts = SrcInputFileData%NumOuts
   if (allocated(SrcInputFileData%OutList)) then
      LB(1:1) = lbound(SrcInputFileData%OutList)
      UB(1:1) = ubound(SrcInputFileData%OutList)
      if (.not. allocated(DstInputFileData%OutList)) then
         allocate(DstInputFileData%OutList(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%OutList.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%OutList = SrcInputFileData%OutList
   end if
   DstInputFileData%SumPrint = SrcInputFileData%SumPrint
   DstInputFileData%OutFmt = SrcInputFileData%OutFmt
   DstInputFileData%BldNd_NumOuts = SrcInputFileData%BldNd_NumOuts
   if (allocated(SrcInputFileData%BldNd_OutList)) then
      LB(1:1) = lbound(SrcInputFileData%BldNd_OutList)
      UB(1:1) = ubound(SrcInputFileData%BldNd_OutList)
      if (.not. allocated(DstInputFileData%BldNd_OutList)) then
         allocate(DstInputFileData%BldNd_OutList(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%BldNd_OutList.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%BldNd_OutList = SrcInputFileData%BldNd_OutList
   end if
   if (allocated(SrcInputFileData%BldNd_BlOutNd)) then
      LB(1:1) = lbound(SrcInputFileData%BldNd_BlOutNd)
      UB(1:1) = ubound(SrcInputFileData%BldNd_BlOutNd)
      if (.not. allocated(DstInputFileData%BldNd_BlOutNd)) then
         allocate(DstInputFileData%BldNd_BlOutNd(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%BldNd_BlOutNd.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%BldNd_BlOutNd = SrcInputFileData%BldNd_BlOutNd
   end if
   DstInputFileData%BldNd_BlOutNd_Str = SrcInputFileData%BldNd_BlOutNd_Str
end subroutine

subroutine BD_DestroyInputFile(InputFileData, ErrStat, ErrMsg)
   type(BD_InputFile), intent(inout) :: InputFileData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'BD_DestroyInputFile'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InputFileData%kp_member)) then
      deallocate(InputFileData%kp_member)
   end if
   call BD_DestroyBladeInputData(InputFileData%InpBl, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(InputFileData%kp_coordinate)) then
      deallocate(InputFileData%kp_coordinate)
   end if
   if (allocated(InputFileData%OutList)) then
      deallocate(InputFileData%OutList)
   end if
   if (allocated(InputFileData%BldNd_OutList)) then
      deallocate(InputFileData%BldNd_OutList)
   end if
   if (allocated(InputFileData%BldNd_BlOutNd)) then
      deallocate(InputFileData%BldNd_BlOutNd)
   end if
end subroutine

subroutine BD_PackInputFile(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(BD_InputFile), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'BD_PackInputFile'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%member_total)
   call RegPack(RF, InData%kp_total)
   call RegPackAlloc(RF, InData%kp_member)
   call RegPack(RF, InData%order_elem)
   call RegPack(RF, InData%load_retries)
   call RegPack(RF, InData%NRMax)
   call RegPack(RF, InData%quadrature)
   call RegPack(RF, InData%n_fact)
   call RegPack(RF, InData%refine)
   call RegPack(RF, InData%rhoinf)
   call RegPack(RF, InData%DTBeam)
   call BD_PackBladeInputData(RF, InData%InpBl) 
   call RegPack(RF, InData%BldFile)
   call RegPack(RF, InData%UsePitchAct)
   call RegPack(RF, InData%QuasiStaticInit)
   call RegPack(RF, InData%stop_tol)
   call RegPack(RF, InData%tngt_stf_pert)
   call RegPack(RF, InData%tngt_stf_difftol)
   call RegPackAlloc(RF, InData%kp_coordinate)
   call RegPack(RF, InData%pitchJ)
   call RegPack(RF, InData%pitchK)
   call RegPack(RF, InData%pitchC)
   call RegPack(RF, InData%Echo)
   call RegPack(RF, InData%RotStates)
   call RegPack(RF, InData%RelStates)
   call RegPack(RF, InData%tngt_stf_fd)
   call RegPack(RF, InData%tngt_stf_comp)
   call RegPack(RF, InData%NNodeOuts)
   call RegPack(RF, InData%OutNd)
   call RegPack(RF, InData%NumOuts)
   call RegPackAlloc(RF, InData%OutList)
   call RegPack(RF, InData%SumPrint)
   call RegPack(RF, InData%OutFmt)
   call RegPack(RF, InData%BldNd_NumOuts)
   call RegPackAlloc(RF, InData%BldNd_OutList)
   call RegPackAlloc(RF, InData%BldNd_BlOutNd)
   call RegPack(RF, InData%BldNd_BlOutNd_Str)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BD_UnPackInputFile(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(BD_InputFile), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'BD_UnPackInputFile'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%member_total); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%kp_total); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%kp_member); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%order_elem); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%load_retries); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NRMax); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%quadrature); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%n_fact); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%refine); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rhoinf); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DTBeam); if (RegCheckErr(RF, RoutineName)) return
   call BD_UnpackBladeInputData(RF, OutData%InpBl) ! InpBl 
   call RegUnpack(RF, OutData%BldFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UsePitchAct); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%QuasiStaticInit); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%stop_tol); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%tngt_stf_pert); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%tngt_stf_difftol); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%kp_coordinate); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%pitchJ); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%pitchK); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%pitchC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Echo); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RotStates); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RelStates); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%tngt_stf_fd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%tngt_stf_comp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NNodeOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutNd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%OutList); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SumPrint); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutFmt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BldNd_NumOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BldNd_OutList); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BldNd_BlOutNd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BldNd_BlOutNd_Str); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BD_CopyContState(SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg)
   type(BD_ContinuousStateType), intent(in) :: SrcContStateData
   type(BD_ContinuousStateType), intent(inout) :: DstContStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'BD_CopyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcContStateData%q)) then
      LB(1:2) = lbound(SrcContStateData%q)
      UB(1:2) = ubound(SrcContStateData%q)
      if (.not. allocated(DstContStateData%q)) then
         allocate(DstContStateData%q(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstContStateData%q.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstContStateData%q = SrcContStateData%q
   end if
   if (allocated(SrcContStateData%dqdt)) then
      LB(1:2) = lbound(SrcContStateData%dqdt)
      UB(1:2) = ubound(SrcContStateData%dqdt)
      if (.not. allocated(DstContStateData%dqdt)) then
         allocate(DstContStateData%dqdt(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstContStateData%dqdt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstContStateData%dqdt = SrcContStateData%dqdt
   end if
end subroutine

subroutine BD_DestroyContState(ContStateData, ErrStat, ErrMsg)
   type(BD_ContinuousStateType), intent(inout) :: ContStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'BD_DestroyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ContStateData%q)) then
      deallocate(ContStateData%q)
   end if
   if (allocated(ContStateData%dqdt)) then
      deallocate(ContStateData%dqdt)
   end if
end subroutine

subroutine BD_PackContState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(BD_ContinuousStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'BD_PackContState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%q)
   call RegPackAlloc(RF, InData%dqdt)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BD_UnPackContState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(BD_ContinuousStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'BD_UnPackContState'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%q); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%dqdt); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BD_CopyDiscState(SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg)
   type(BD_DiscreteStateType), intent(in) :: SrcDiscStateData
   type(BD_DiscreteStateType), intent(inout) :: DstDiscStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'BD_CopyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstDiscStateData%thetaP = SrcDiscStateData%thetaP
   DstDiscStateData%thetaPD = SrcDiscStateData%thetaPD
end subroutine

subroutine BD_DestroyDiscState(DiscStateData, ErrStat, ErrMsg)
   type(BD_DiscreteStateType), intent(inout) :: DiscStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'BD_DestroyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine BD_PackDiscState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(BD_DiscreteStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'BD_PackDiscState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%thetaP)
   call RegPack(RF, InData%thetaPD)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BD_UnPackDiscState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(BD_DiscreteStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'BD_UnPackDiscState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%thetaP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%thetaPD); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BD_CopyConstrState(SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg)
   type(BD_ConstraintStateType), intent(in) :: SrcConstrStateData
   type(BD_ConstraintStateType), intent(inout) :: DstConstrStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'BD_CopyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstConstrStateData%DummyConstrState = SrcConstrStateData%DummyConstrState
end subroutine

subroutine BD_DestroyConstrState(ConstrStateData, ErrStat, ErrMsg)
   type(BD_ConstraintStateType), intent(inout) :: ConstrStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'BD_DestroyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine BD_PackConstrState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(BD_ConstraintStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'BD_PackConstrState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyConstrState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BD_UnPackConstrState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(BD_ConstraintStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'BD_UnPackConstrState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyConstrState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BD_CopyOtherState(SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg)
   type(BD_OtherStateType), intent(in) :: SrcOtherStateData
   type(BD_OtherStateType), intent(inout) :: DstOtherStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'BD_CopyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcOtherStateData%acc)) then
      LB(1:2) = lbound(SrcOtherStateData%acc)
      UB(1:2) = ubound(SrcOtherStateData%acc)
      if (.not. allocated(DstOtherStateData%acc)) then
         allocate(DstOtherStateData%acc(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%acc.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOtherStateData%acc = SrcOtherStateData%acc
   end if
   if (allocated(SrcOtherStateData%xcc)) then
      LB(1:2) = lbound(SrcOtherStateData%xcc)
      UB(1:2) = ubound(SrcOtherStateData%xcc)
      if (.not. allocated(DstOtherStateData%xcc)) then
         allocate(DstOtherStateData%xcc(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%xcc.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOtherStateData%xcc = SrcOtherStateData%xcc
   end if
   DstOtherStateData%InitAcc = SrcOtherStateData%InitAcc
   DstOtherStateData%RunQuasiStaticInit = SrcOtherStateData%RunQuasiStaticInit
   DstOtherStateData%GlbPos = SrcOtherStateData%GlbPos
   DstOtherStateData%GlbRot = SrcOtherStateData%GlbRot
   DstOtherStateData%Glb_crv = SrcOtherStateData%Glb_crv
end subroutine

subroutine BD_DestroyOtherState(OtherStateData, ErrStat, ErrMsg)
   type(BD_OtherStateType), intent(inout) :: OtherStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'BD_DestroyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(OtherStateData%acc)) then
      deallocate(OtherStateData%acc)
   end if
   if (allocated(OtherStateData%xcc)) then
      deallocate(OtherStateData%xcc)
   end if
end subroutine

subroutine BD_PackOtherState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(BD_OtherStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'BD_PackOtherState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%acc)
   call RegPackAlloc(RF, InData%xcc)
   call RegPack(RF, InData%InitAcc)
   call RegPack(RF, InData%RunQuasiStaticInit)
   call RegPack(RF, InData%GlbPos)
   call RegPack(RF, InData%GlbRot)
   call RegPack(RF, InData%Glb_crv)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BD_UnPackOtherState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(BD_OtherStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'BD_UnPackOtherState'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%acc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%xcc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%InitAcc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RunQuasiStaticInit); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GlbPos); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%GlbRot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Glb_crv); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BD_CopyqpParam(SrcqpParamData, DstqpParamData, CtrlCode, ErrStat, ErrMsg)
   type(qpParam), intent(in) :: SrcqpParamData
   type(qpParam), intent(inout) :: DstqpParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'BD_CopyqpParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcqpParamData%mmm)) then
      LB(1:2) = lbound(SrcqpParamData%mmm)
      UB(1:2) = ubound(SrcqpParamData%mmm)
      if (.not. allocated(DstqpParamData%mmm)) then
         allocate(DstqpParamData%mmm(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstqpParamData%mmm.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstqpParamData%mmm = SrcqpParamData%mmm
   end if
   if (allocated(SrcqpParamData%mEta)) then
      LB(1:3) = lbound(SrcqpParamData%mEta)
      UB(1:3) = ubound(SrcqpParamData%mEta)
      if (.not. allocated(DstqpParamData%mEta)) then
         allocate(DstqpParamData%mEta(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstqpParamData%mEta.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstqpParamData%mEta = SrcqpParamData%mEta
   end if
end subroutine

subroutine BD_DestroyqpParam(qpParamData, ErrStat, ErrMsg)
   type(qpParam), intent(inout) :: qpParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'BD_DestroyqpParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(qpParamData%mmm)) then
      deallocate(qpParamData%mmm)
   end if
   if (allocated(qpParamData%mEta)) then
      deallocate(qpParamData%mEta)
   end if
end subroutine

subroutine BD_PackqpParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(qpParam), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'BD_PackqpParam'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%mmm)
   call RegPackAlloc(RF, InData%mEta)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BD_UnPackqpParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(qpParam), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'BD_UnPackqpParam'
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%mmm); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%mEta); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BD_CopyParam(SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg)
   type(BD_ParameterType), intent(in) :: SrcParamData
   type(BD_ParameterType), intent(inout) :: DstParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2, i3, i4
   integer(B4Ki)                  :: LB(4), UB(4)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'BD_CopyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstParamData%dt = SrcParamData%dt
   DstParamData%coef = SrcParamData%coef
   DstParamData%rhoinf = SrcParamData%rhoinf
   if (allocated(SrcParamData%uuN0)) then
      LB(1:3) = lbound(SrcParamData%uuN0)
      UB(1:3) = ubound(SrcParamData%uuN0)
      if (.not. allocated(DstParamData%uuN0)) then
         allocate(DstParamData%uuN0(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%uuN0.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%uuN0 = SrcParamData%uuN0
   end if
   if (allocated(SrcParamData%Stif0_QP)) then
      LB(1:3) = lbound(SrcParamData%Stif0_QP)
      UB(1:3) = ubound(SrcParamData%Stif0_QP)
      if (.not. allocated(DstParamData%Stif0_QP)) then
         allocate(DstParamData%Stif0_QP(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Stif0_QP.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Stif0_QP = SrcParamData%Stif0_QP
   end if
   if (allocated(SrcParamData%Mass0_QP)) then
      LB(1:3) = lbound(SrcParamData%Mass0_QP)
      UB(1:3) = ubound(SrcParamData%Mass0_QP)
      if (.not. allocated(DstParamData%Mass0_QP)) then
         allocate(DstParamData%Mass0_QP(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Mass0_QP.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Mass0_QP = SrcParamData%Mass0_QP
   end if
   DstParamData%gravity = SrcParamData%gravity
   if (allocated(SrcParamData%segment_eta)) then
      LB(1:1) = lbound(SrcParamData%segment_eta)
      UB(1:1) = ubound(SrcParamData%segment_eta)
      if (.not. allocated(DstParamData%segment_eta)) then
         allocate(DstParamData%segment_eta(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%segment_eta.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%segment_eta = SrcParamData%segment_eta
   end if
   if (allocated(SrcParamData%member_eta)) then
      LB(1:1) = lbound(SrcParamData%member_eta)
      UB(1:1) = ubound(SrcParamData%member_eta)
      if (.not. allocated(DstParamData%member_eta)) then
         allocate(DstParamData%member_eta(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%member_eta.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%member_eta = SrcParamData%member_eta
   end if
   DstParamData%blade_length = SrcParamData%blade_length
   DstParamData%blade_mass = SrcParamData%blade_mass
   DstParamData%blade_CG = SrcParamData%blade_CG
   DstParamData%blade_IN = SrcParamData%blade_IN
   DstParamData%beta = SrcParamData%beta
   DstParamData%tol = SrcParamData%tol
   if (allocated(SrcParamData%QPtN)) then
      LB(1:1) = lbound(SrcParamData%QPtN)
      UB(1:1) = ubound(SrcParamData%QPtN)
      if (.not. allocated(DstParamData%QPtN)) then
         allocate(DstParamData%QPtN(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%QPtN.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%QPtN = SrcParamData%QPtN
   end if
   if (allocated(SrcParamData%QPtWeight)) then
      LB(1:1) = lbound(SrcParamData%QPtWeight)
      UB(1:1) = ubound(SrcParamData%QPtWeight)
      if (.not. allocated(DstParamData%QPtWeight)) then
         allocate(DstParamData%QPtWeight(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%QPtWeight.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%QPtWeight = SrcParamData%QPtWeight
   end if
   if (allocated(SrcParamData%Shp)) then
      LB(1:2) = lbound(SrcParamData%Shp)
      UB(1:2) = ubound(SrcParamData%Shp)
      if (.not. allocated(DstParamData%Shp)) then
         allocate(DstParamData%Shp(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Shp.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Shp = SrcParamData%Shp
   end if
   if (allocated(SrcParamData%ShpDer)) then
      LB(1:2) = lbound(SrcParamData%ShpDer)
      UB(1:2) = ubound(SrcParamData%ShpDer)
      if (.not. allocated(DstParamData%ShpDer)) then
         allocate(DstParamData%ShpDer(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%ShpDer.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%ShpDer = SrcParamData%ShpDer
   end if
   if (allocated(SrcParamData%Jacobian)) then
      LB(1:2) = lbound(SrcParamData%Jacobian)
      UB(1:2) = ubound(SrcParamData%Jacobian)
      if (.not. allocated(DstParamData%Jacobian)) then
         allocate(DstParamData%Jacobian(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Jacobian.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Jacobian = SrcParamData%Jacobian
   end if
   if (allocated(SrcParamData%uu0)) then
      LB(1:3) = lbound(SrcParamData%uu0)
      UB(1:3) = ubound(SrcParamData%uu0)
      if (.not. allocated(DstParamData%uu0)) then
         allocate(DstParamData%uu0(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%uu0.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%uu0 = SrcParamData%uu0
   end if
   if (allocated(SrcParamData%rrN0)) then
      LB(1:3) = lbound(SrcParamData%rrN0)
      UB(1:3) = ubound(SrcParamData%rrN0)
      if (.not. allocated(DstParamData%rrN0)) then
         allocate(DstParamData%rrN0(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%rrN0.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%rrN0 = SrcParamData%rrN0
   end if
   if (allocated(SrcParamData%E10)) then
      LB(1:3) = lbound(SrcParamData%E10)
      UB(1:3) = ubound(SrcParamData%E10)
      if (.not. allocated(DstParamData%E10)) then
         allocate(DstParamData%E10(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%E10.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%E10 = SrcParamData%E10
   end if
   DstParamData%nodes_per_elem = SrcParamData%nodes_per_elem
   if (allocated(SrcParamData%node_elem_idx)) then
      LB(1:2) = lbound(SrcParamData%node_elem_idx)
      UB(1:2) = ubound(SrcParamData%node_elem_idx)
      if (.not. allocated(DstParamData%node_elem_idx)) then
         allocate(DstParamData%node_elem_idx(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%node_elem_idx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%node_elem_idx = SrcParamData%node_elem_idx
   end if
   DstParamData%refine = SrcParamData%refine
   DstParamData%dof_node = SrcParamData%dof_node
   DstParamData%dof_elem = SrcParamData%dof_elem
   DstParamData%rot_elem = SrcParamData%rot_elem
   DstParamData%elem_total = SrcParamData%elem_total
   DstParamData%node_total = SrcParamData%node_total
   DstParamData%dof_total = SrcParamData%dof_total
   DstParamData%nqp = SrcParamData%nqp
   DstParamData%analysis_type = SrcParamData%analysis_type
   DstParamData%damp_flag = SrcParamData%damp_flag
   DstParamData%ld_retries = SrcParamData%ld_retries
   DstParamData%niter = SrcParamData%niter
   DstParamData%quadrature = SrcParamData%quadrature
   DstParamData%n_fact = SrcParamData%n_fact
   DstParamData%OutInputs = SrcParamData%OutInputs
   DstParamData%NumOuts = SrcParamData%NumOuts
   if (allocated(SrcParamData%OutParam)) then
      LB(1:1) = lbound(SrcParamData%OutParam)
      UB(1:1) = ubound(SrcParamData%OutParam)
      if (.not. allocated(DstParamData%OutParam)) then
         allocate(DstParamData%OutParam(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%OutParam.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyOutParmType(SrcParamData%OutParam(i1), DstParamData%OutParam(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstParamData%NNodeOuts = SrcParamData%NNodeOuts
   DstParamData%OutNd = SrcParamData%OutNd
   if (allocated(SrcParamData%NdIndx)) then
      LB(1:1) = lbound(SrcParamData%NdIndx)
      UB(1:1) = ubound(SrcParamData%NdIndx)
      if (.not. allocated(DstParamData%NdIndx)) then
         allocate(DstParamData%NdIndx(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%NdIndx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%NdIndx = SrcParamData%NdIndx
   end if
   if (allocated(SrcParamData%NdIndxInverse)) then
      LB(1:1) = lbound(SrcParamData%NdIndxInverse)
      UB(1:1) = ubound(SrcParamData%NdIndxInverse)
      if (.not. allocated(DstParamData%NdIndxInverse)) then
         allocate(DstParamData%NdIndxInverse(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%NdIndxInverse.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%NdIndxInverse = SrcParamData%NdIndxInverse
   end if
   if (allocated(SrcParamData%OutNd2NdElem)) then
      LB(1:2) = lbound(SrcParamData%OutNd2NdElem)
      UB(1:2) = ubound(SrcParamData%OutNd2NdElem)
      if (.not. allocated(DstParamData%OutNd2NdElem)) then
         allocate(DstParamData%OutNd2NdElem(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%OutNd2NdElem.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%OutNd2NdElem = SrcParamData%OutNd2NdElem
   end if
   DstParamData%OutFmt = SrcParamData%OutFmt
   DstParamData%UsePitchAct = SrcParamData%UsePitchAct
   DstParamData%pitchJ = SrcParamData%pitchJ
   DstParamData%pitchK = SrcParamData%pitchK
   DstParamData%pitchC = SrcParamData%pitchC
   DstParamData%torqM = SrcParamData%torqM
   call BD_CopyqpParam(SrcParamData%qp, DstParamData%qp, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstParamData%qp_indx_offset = SrcParamData%qp_indx_offset
   DstParamData%BldMotionNodeLoc = SrcParamData%BldMotionNodeLoc
   DstParamData%tngt_stf_fd = SrcParamData%tngt_stf_fd
   DstParamData%tngt_stf_comp = SrcParamData%tngt_stf_comp
   DstParamData%tngt_stf_pert = SrcParamData%tngt_stf_pert
   DstParamData%tngt_stf_difftol = SrcParamData%tngt_stf_difftol
   DstParamData%BldNd_NumOuts = SrcParamData%BldNd_NumOuts
   DstParamData%BldNd_TotNumOuts = SrcParamData%BldNd_TotNumOuts
   if (allocated(SrcParamData%BldNd_OutParam)) then
      LB(1:1) = lbound(SrcParamData%BldNd_OutParam)
      UB(1:1) = ubound(SrcParamData%BldNd_OutParam)
      if (.not. allocated(DstParamData%BldNd_OutParam)) then
         allocate(DstParamData%BldNd_OutParam(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%BldNd_OutParam.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyOutParmType(SrcParamData%BldNd_OutParam(i1), DstParamData%BldNd_OutParam(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcParamData%BldNd_BlOutNd)) then
      LB(1:1) = lbound(SrcParamData%BldNd_BlOutNd)
      UB(1:1) = ubound(SrcParamData%BldNd_BlOutNd)
      if (.not. allocated(DstParamData%BldNd_BlOutNd)) then
         allocate(DstParamData%BldNd_BlOutNd(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%BldNd_BlOutNd.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%BldNd_BlOutNd = SrcParamData%BldNd_BlOutNd
   end if
   if (allocated(SrcParamData%QPtw_Shp_Shp_Jac)) then
      LB(1:4) = lbound(SrcParamData%QPtw_Shp_Shp_Jac)
      UB(1:4) = ubound(SrcParamData%QPtw_Shp_Shp_Jac)
      if (.not. allocated(DstParamData%QPtw_Shp_Shp_Jac)) then
         allocate(DstParamData%QPtw_Shp_Shp_Jac(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%QPtw_Shp_Shp_Jac.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%QPtw_Shp_Shp_Jac = SrcParamData%QPtw_Shp_Shp_Jac
   end if
   if (allocated(SrcParamData%QPtw_Shp_ShpDer)) then
      LB(1:3) = lbound(SrcParamData%QPtw_Shp_ShpDer)
      UB(1:3) = ubound(SrcParamData%QPtw_Shp_ShpDer)
      if (.not. allocated(DstParamData%QPtw_Shp_ShpDer)) then
         allocate(DstParamData%QPtw_Shp_ShpDer(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%QPtw_Shp_ShpDer.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%QPtw_Shp_ShpDer = SrcParamData%QPtw_Shp_ShpDer
   end if
   if (allocated(SrcParamData%QPtw_ShpDer_ShpDer_Jac)) then
      LB(1:4) = lbound(SrcParamData%QPtw_ShpDer_ShpDer_Jac)
      UB(1:4) = ubound(SrcParamData%QPtw_ShpDer_ShpDer_Jac)
      if (.not. allocated(DstParamData%QPtw_ShpDer_ShpDer_Jac)) then
         allocate(DstParamData%QPtw_ShpDer_ShpDer_Jac(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%QPtw_ShpDer_ShpDer_Jac.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%QPtw_ShpDer_ShpDer_Jac = SrcParamData%QPtw_ShpDer_ShpDer_Jac
   end if
   if (allocated(SrcParamData%QPtw_Shp_Jac)) then
      LB(1:3) = lbound(SrcParamData%QPtw_Shp_Jac)
      UB(1:3) = ubound(SrcParamData%QPtw_Shp_Jac)
      if (.not. allocated(DstParamData%QPtw_Shp_Jac)) then
         allocate(DstParamData%QPtw_Shp_Jac(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%QPtw_Shp_Jac.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%QPtw_Shp_Jac = SrcParamData%QPtw_Shp_Jac
   end if
   if (allocated(SrcParamData%QPtw_ShpDer)) then
      LB(1:2) = lbound(SrcParamData%QPtw_ShpDer)
      UB(1:2) = ubound(SrcParamData%QPtw_ShpDer)
      if (.not. allocated(DstParamData%QPtw_ShpDer)) then
         allocate(DstParamData%QPtw_ShpDer(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%QPtw_ShpDer.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%QPtw_ShpDer = SrcParamData%QPtw_ShpDer
   end if
   if (allocated(SrcParamData%FEweight)) then
      LB(1:2) = lbound(SrcParamData%FEweight)
      UB(1:2) = ubound(SrcParamData%FEweight)
      if (.not. allocated(DstParamData%FEweight)) then
         allocate(DstParamData%FEweight(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%FEweight.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%FEweight = SrcParamData%FEweight
   end if
   if (allocated(SrcParamData%Jac_u_indx)) then
      LB(1:2) = lbound(SrcParamData%Jac_u_indx)
      UB(1:2) = ubound(SrcParamData%Jac_u_indx)
      if (.not. allocated(DstParamData%Jac_u_indx)) then
         allocate(DstParamData%Jac_u_indx(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Jac_u_indx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Jac_u_indx = SrcParamData%Jac_u_indx
   end if
   if (allocated(SrcParamData%du)) then
      LB(1:1) = lbound(SrcParamData%du)
      UB(1:1) = ubound(SrcParamData%du)
      if (.not. allocated(DstParamData%du)) then
         allocate(DstParamData%du(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%du.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%du = SrcParamData%du
   end if
   DstParamData%dx = SrcParamData%dx
   DstParamData%Jac_ny = SrcParamData%Jac_ny
   DstParamData%Jac_nx = SrcParamData%Jac_nx
   DstParamData%RotStates = SrcParamData%RotStates
   DstParamData%RelStates = SrcParamData%RelStates
   DstParamData%CompAeroMaps = SrcParamData%CompAeroMaps
   DstParamData%CompAppliedLdAtRoot = SrcParamData%CompAppliedLdAtRoot
end subroutine

subroutine BD_DestroyParam(ParamData, ErrStat, ErrMsg)
   type(BD_ParameterType), intent(inout) :: ParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2, i3, i4
   integer(B4Ki)   :: LB(4), UB(4)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'BD_DestroyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ParamData%uuN0)) then
      deallocate(ParamData%uuN0)
   end if
   if (allocated(ParamData%Stif0_QP)) then
      deallocate(ParamData%Stif0_QP)
   end if
   if (allocated(ParamData%Mass0_QP)) then
      deallocate(ParamData%Mass0_QP)
   end if
   if (allocated(ParamData%segment_eta)) then
      deallocate(ParamData%segment_eta)
   end if
   if (allocated(ParamData%member_eta)) then
      deallocate(ParamData%member_eta)
   end if
   if (allocated(ParamData%QPtN)) then
      deallocate(ParamData%QPtN)
   end if
   if (allocated(ParamData%QPtWeight)) then
      deallocate(ParamData%QPtWeight)
   end if
   if (allocated(ParamData%Shp)) then
      deallocate(ParamData%Shp)
   end if
   if (allocated(ParamData%ShpDer)) then
      deallocate(ParamData%ShpDer)
   end if
   if (allocated(ParamData%Jacobian)) then
      deallocate(ParamData%Jacobian)
   end if
   if (allocated(ParamData%uu0)) then
      deallocate(ParamData%uu0)
   end if
   if (allocated(ParamData%rrN0)) then
      deallocate(ParamData%rrN0)
   end if
   if (allocated(ParamData%E10)) then
      deallocate(ParamData%E10)
   end if
   if (allocated(ParamData%node_elem_idx)) then
      deallocate(ParamData%node_elem_idx)
   end if
   if (allocated(ParamData%OutParam)) then
      LB(1:1) = lbound(ParamData%OutParam)
      UB(1:1) = ubound(ParamData%OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyOutParmType(ParamData%OutParam(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%OutParam)
   end if
   if (allocated(ParamData%NdIndx)) then
      deallocate(ParamData%NdIndx)
   end if
   if (allocated(ParamData%NdIndxInverse)) then
      deallocate(ParamData%NdIndxInverse)
   end if
   if (allocated(ParamData%OutNd2NdElem)) then
      deallocate(ParamData%OutNd2NdElem)
   end if
   call BD_DestroyqpParam(ParamData%qp, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(ParamData%BldNd_OutParam)) then
      LB(1:1) = lbound(ParamData%BldNd_OutParam)
      UB(1:1) = ubound(ParamData%BldNd_OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyOutParmType(ParamData%BldNd_OutParam(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%BldNd_OutParam)
   end if
   if (allocated(ParamData%BldNd_BlOutNd)) then
      deallocate(ParamData%BldNd_BlOutNd)
   end if
   if (allocated(ParamData%QPtw_Shp_Shp_Jac)) then
      deallocate(ParamData%QPtw_Shp_Shp_Jac)
   end if
   if (allocated(ParamData%QPtw_Shp_ShpDer)) then
      deallocate(ParamData%QPtw_Shp_ShpDer)
   end if
   if (allocated(ParamData%QPtw_ShpDer_ShpDer_Jac)) then
      deallocate(ParamData%QPtw_ShpDer_ShpDer_Jac)
   end if
   if (allocated(ParamData%QPtw_Shp_Jac)) then
      deallocate(ParamData%QPtw_Shp_Jac)
   end if
   if (allocated(ParamData%QPtw_ShpDer)) then
      deallocate(ParamData%QPtw_ShpDer)
   end if
   if (allocated(ParamData%FEweight)) then
      deallocate(ParamData%FEweight)
   end if
   if (allocated(ParamData%Jac_u_indx)) then
      deallocate(ParamData%Jac_u_indx)
   end if
   if (allocated(ParamData%du)) then
      deallocate(ParamData%du)
   end if
end subroutine

subroutine BD_PackParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(BD_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'BD_PackParam'
   integer(B4Ki)   :: i1, i2, i3, i4
   integer(B4Ki)   :: LB(4), UB(4)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%dt)
   call RegPack(RF, InData%coef)
   call RegPack(RF, InData%rhoinf)
   call RegPackAlloc(RF, InData%uuN0)
   call RegPackAlloc(RF, InData%Stif0_QP)
   call RegPackAlloc(RF, InData%Mass0_QP)
   call RegPack(RF, InData%gravity)
   call RegPackAlloc(RF, InData%segment_eta)
   call RegPackAlloc(RF, InData%member_eta)
   call RegPack(RF, InData%blade_length)
   call RegPack(RF, InData%blade_mass)
   call RegPack(RF, InData%blade_CG)
   call RegPack(RF, InData%blade_IN)
   call RegPack(RF, InData%beta)
   call RegPack(RF, InData%tol)
   call RegPackAlloc(RF, InData%QPtN)
   call RegPackAlloc(RF, InData%QPtWeight)
   call RegPackAlloc(RF, InData%Shp)
   call RegPackAlloc(RF, InData%ShpDer)
   call RegPackAlloc(RF, InData%Jacobian)
   call RegPackAlloc(RF, InData%uu0)
   call RegPackAlloc(RF, InData%rrN0)
   call RegPackAlloc(RF, InData%E10)
   call RegPack(RF, InData%nodes_per_elem)
   call RegPackAlloc(RF, InData%node_elem_idx)
   call RegPack(RF, InData%refine)
   call RegPack(RF, InData%dof_node)
   call RegPack(RF, InData%dof_elem)
   call RegPack(RF, InData%rot_elem)
   call RegPack(RF, InData%elem_total)
   call RegPack(RF, InData%node_total)
   call RegPack(RF, InData%dof_total)
   call RegPack(RF, InData%nqp)
   call RegPack(RF, InData%analysis_type)
   call RegPack(RF, InData%damp_flag)
   call RegPack(RF, InData%ld_retries)
   call RegPack(RF, InData%niter)
   call RegPack(RF, InData%quadrature)
   call RegPack(RF, InData%n_fact)
   call RegPack(RF, InData%OutInputs)
   call RegPack(RF, InData%NumOuts)
   call RegPack(RF, allocated(InData%OutParam))
   if (allocated(InData%OutParam)) then
      call RegPackBounds(RF, 1, lbound(InData%OutParam), ubound(InData%OutParam))
      LB(1:1) = lbound(InData%OutParam)
      UB(1:1) = ubound(InData%OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackOutParmType(RF, InData%OutParam(i1)) 
      end do
   end if
   call RegPack(RF, InData%NNodeOuts)
   call RegPack(RF, InData%OutNd)
   call RegPackAlloc(RF, InData%NdIndx)
   call RegPackAlloc(RF, InData%NdIndxInverse)
   call RegPackAlloc(RF, InData%OutNd2NdElem)
   call RegPack(RF, InData%OutFmt)
   call RegPack(RF, InData%UsePitchAct)
   call RegPack(RF, InData%pitchJ)
   call RegPack(RF, InData%pitchK)
   call RegPack(RF, InData%pitchC)
   call RegPack(RF, InData%torqM)
   call BD_PackqpParam(RF, InData%qp) 
   call RegPack(RF, InData%qp_indx_offset)
   call RegPack(RF, InData%BldMotionNodeLoc)
   call RegPack(RF, InData%tngt_stf_fd)
   call RegPack(RF, InData%tngt_stf_comp)
   call RegPack(RF, InData%tngt_stf_pert)
   call RegPack(RF, InData%tngt_stf_difftol)
   call RegPack(RF, InData%BldNd_NumOuts)
   call RegPack(RF, InData%BldNd_TotNumOuts)
   call RegPack(RF, allocated(InData%BldNd_OutParam))
   if (allocated(InData%BldNd_OutParam)) then
      call RegPackBounds(RF, 1, lbound(InData%BldNd_OutParam), ubound(InData%BldNd_OutParam))
      LB(1:1) = lbound(InData%BldNd_OutParam)
      UB(1:1) = ubound(InData%BldNd_OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackOutParmType(RF, InData%BldNd_OutParam(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%BldNd_BlOutNd)
   call RegPackAlloc(RF, InData%QPtw_Shp_Shp_Jac)
   call RegPackAlloc(RF, InData%QPtw_Shp_ShpDer)
   call RegPackAlloc(RF, InData%QPtw_ShpDer_ShpDer_Jac)
   call RegPackAlloc(RF, InData%QPtw_Shp_Jac)
   call RegPackAlloc(RF, InData%QPtw_ShpDer)
   call RegPackAlloc(RF, InData%FEweight)
   call RegPackAlloc(RF, InData%Jac_u_indx)
   call RegPackAlloc(RF, InData%du)
   call RegPack(RF, InData%dx)
   call RegPack(RF, InData%Jac_ny)
   call RegPack(RF, InData%Jac_nx)
   call RegPack(RF, InData%RotStates)
   call RegPack(RF, InData%RelStates)
   call RegPack(RF, InData%CompAeroMaps)
   call RegPack(RF, InData%CompAppliedLdAtRoot)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BD_UnPackParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(BD_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'BD_UnPackParam'
   integer(B4Ki)   :: i1, i2, i3, i4
   integer(B4Ki)   :: LB(4), UB(4)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%dt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%coef); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rhoinf); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%uuN0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Stif0_QP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Mass0_QP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%gravity); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%segment_eta); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%member_eta); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%blade_length); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%blade_mass); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%blade_CG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%blade_IN); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%beta); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%tol); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%QPtN); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%QPtWeight); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Shp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%ShpDer); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Jacobian); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%uu0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%rrN0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%E10); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nodes_per_elem); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%node_elem_idx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%refine); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dof_node); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dof_elem); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rot_elem); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%elem_total); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%node_total); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dof_total); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nqp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%analysis_type); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%damp_flag); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ld_retries); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%niter); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%quadrature); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%n_fact); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutInputs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumOuts); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%OutParam)) deallocate(OutData%OutParam)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%OutParam(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%OutParam.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackOutParmType(RF, OutData%OutParam(i1)) ! OutParam 
      end do
   end if
   call RegUnpack(RF, OutData%NNodeOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutNd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%NdIndx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%NdIndxInverse); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%OutNd2NdElem); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutFmt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UsePitchAct); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%pitchJ); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%pitchK); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%pitchC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%torqM); if (RegCheckErr(RF, RoutineName)) return
   call BD_UnpackqpParam(RF, OutData%qp) ! qp 
   call RegUnpack(RF, OutData%qp_indx_offset); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BldMotionNodeLoc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%tngt_stf_fd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%tngt_stf_comp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%tngt_stf_pert); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%tngt_stf_difftol); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BldNd_NumOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BldNd_TotNumOuts); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%BldNd_OutParam)) deallocate(OutData%BldNd_OutParam)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BldNd_OutParam(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BldNd_OutParam.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackOutParmType(RF, OutData%BldNd_OutParam(i1)) ! BldNd_OutParam 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%BldNd_BlOutNd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%QPtw_Shp_Shp_Jac); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%QPtw_Shp_ShpDer); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%QPtw_ShpDer_ShpDer_Jac); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%QPtw_Shp_Jac); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%QPtw_ShpDer); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%FEweight); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Jac_u_indx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%du); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Jac_ny); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Jac_nx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RotStates); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RelStates); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CompAeroMaps); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CompAppliedLdAtRoot); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BD_CopyInput(SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg)
   type(BD_InputType), intent(inout) :: SrcInputData
   type(BD_InputType), intent(inout) :: DstInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'BD_CopyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshCopy(SrcInputData%RootMotion, DstInputData%RootMotion, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcInputData%PointLoad, DstInputData%PointLoad, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcInputData%DistrLoad, DstInputData%DistrLoad, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcInputData%HubMotion, DstInputData%HubMotion, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine BD_DestroyInput(InputData, ErrStat, ErrMsg)
   type(BD_InputType), intent(inout) :: InputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'BD_DestroyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshDestroy( InputData%RootMotion, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( InputData%PointLoad, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( InputData%DistrLoad, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( InputData%HubMotion, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine BD_PackInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(BD_InputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'BD_PackInput'
   if (RF%ErrStat >= AbortErrLev) return
   call MeshPack(RF, InData%RootMotion) 
   call MeshPack(RF, InData%PointLoad) 
   call MeshPack(RF, InData%DistrLoad) 
   call MeshPack(RF, InData%HubMotion) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BD_UnPackInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(BD_InputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'BD_UnPackInput'
   if (RF%ErrStat /= ErrID_None) return
   call MeshUnpack(RF, OutData%RootMotion) ! RootMotion 
   call MeshUnpack(RF, OutData%PointLoad) ! PointLoad 
   call MeshUnpack(RF, OutData%DistrLoad) ! DistrLoad 
   call MeshUnpack(RF, OutData%HubMotion) ! HubMotion 
end subroutine

subroutine BD_CopyOutput(SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg)
   type(BD_OutputType), intent(inout) :: SrcOutputData
   type(BD_OutputType), intent(inout) :: DstOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'BD_CopyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshCopy(SrcOutputData%ReactionForce, DstOutputData%ReactionForce, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcOutputData%BldMotion, DstOutputData%BldMotion, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstOutputData%RootMxr = SrcOutputData%RootMxr
   DstOutputData%RootMyr = SrcOutputData%RootMyr
   if (allocated(SrcOutputData%WriteOutput)) then
      LB(1:1) = lbound(SrcOutputData%WriteOutput)
      UB(1:1) = ubound(SrcOutputData%WriteOutput)
      if (.not. allocated(DstOutputData%WriteOutput)) then
         allocate(DstOutputData%WriteOutput(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%WriteOutput.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%WriteOutput = SrcOutputData%WriteOutput
   end if
end subroutine

subroutine BD_DestroyOutput(OutputData, ErrStat, ErrMsg)
   type(BD_OutputType), intent(inout) :: OutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'BD_DestroyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshDestroy( OutputData%ReactionForce, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( OutputData%BldMotion, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(OutputData%WriteOutput)) then
      deallocate(OutputData%WriteOutput)
   end if
end subroutine

subroutine BD_PackOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(BD_OutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'BD_PackOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call MeshPack(RF, InData%ReactionForce) 
   call MeshPack(RF, InData%BldMotion) 
   call RegPack(RF, InData%RootMxr)
   call RegPack(RF, InData%RootMyr)
   call RegPackAlloc(RF, InData%WriteOutput)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BD_UnPackOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(BD_OutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'BD_UnPackOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call MeshUnpack(RF, OutData%ReactionForce) ! ReactionForce 
   call MeshUnpack(RF, OutData%BldMotion) ! BldMotion 
   call RegUnpack(RF, OutData%RootMxr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootMyr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutput); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BD_CopyEqMotionQP(SrcEqMotionQPData, DstEqMotionQPData, CtrlCode, ErrStat, ErrMsg)
   type(EqMotionQP), intent(in) :: SrcEqMotionQPData
   type(EqMotionQP), intent(inout) :: DstEqMotionQPData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(4), UB(4)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'BD_CopyEqMotionQP'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcEqMotionQPData%uuu)) then
      LB(1:3) = lbound(SrcEqMotionQPData%uuu)
      UB(1:3) = ubound(SrcEqMotionQPData%uuu)
      if (.not. allocated(DstEqMotionQPData%uuu)) then
         allocate(DstEqMotionQPData%uuu(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstEqMotionQPData%uuu.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstEqMotionQPData%uuu = SrcEqMotionQPData%uuu
   end if
   if (allocated(SrcEqMotionQPData%uup)) then
      LB(1:3) = lbound(SrcEqMotionQPData%uup)
      UB(1:3) = ubound(SrcEqMotionQPData%uup)
      if (.not. allocated(DstEqMotionQPData%uup)) then
         allocate(DstEqMotionQPData%uup(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstEqMotionQPData%uup.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstEqMotionQPData%uup = SrcEqMotionQPData%uup
   end if
   if (allocated(SrcEqMotionQPData%vvv)) then
      LB(1:3) = lbound(SrcEqMotionQPData%vvv)
      UB(1:3) = ubound(SrcEqMotionQPData%vvv)
      if (.not. allocated(DstEqMotionQPData%vvv)) then
         allocate(DstEqMotionQPData%vvv(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstEqMotionQPData%vvv.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstEqMotionQPData%vvv = SrcEqMotionQPData%vvv
   end if
   if (allocated(SrcEqMotionQPData%vvp)) then
      LB(1:3) = lbound(SrcEqMotionQPData%vvp)
      UB(1:3) = ubound(SrcEqMotionQPData%vvp)
      if (.not. allocated(DstEqMotionQPData%vvp)) then
         allocate(DstEqMotionQPData%vvp(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstEqMotionQPData%vvp.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstEqMotionQPData%vvp = SrcEqMotionQPData%vvp
   end if
   if (allocated(SrcEqMotionQPData%aaa)) then
      LB(1:3) = lbound(SrcEqMotionQPData%aaa)
      UB(1:3) = ubound(SrcEqMotionQPData%aaa)
      if (.not. allocated(DstEqMotionQPData%aaa)) then
         allocate(DstEqMotionQPData%aaa(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstEqMotionQPData%aaa.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstEqMotionQPData%aaa = SrcEqMotionQPData%aaa
   end if
   if (allocated(SrcEqMotionQPData%RR0)) then
      LB(1:4) = lbound(SrcEqMotionQPData%RR0)
      UB(1:4) = ubound(SrcEqMotionQPData%RR0)
      if (.not. allocated(DstEqMotionQPData%RR0)) then
         allocate(DstEqMotionQPData%RR0(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstEqMotionQPData%RR0.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstEqMotionQPData%RR0 = SrcEqMotionQPData%RR0
   end if
   if (allocated(SrcEqMotionQPData%kappa)) then
      LB(1:3) = lbound(SrcEqMotionQPData%kappa)
      UB(1:3) = ubound(SrcEqMotionQPData%kappa)
      if (.not. allocated(DstEqMotionQPData%kappa)) then
         allocate(DstEqMotionQPData%kappa(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstEqMotionQPData%kappa.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstEqMotionQPData%kappa = SrcEqMotionQPData%kappa
   end if
   if (allocated(SrcEqMotionQPData%E1)) then
      LB(1:3) = lbound(SrcEqMotionQPData%E1)
      UB(1:3) = ubound(SrcEqMotionQPData%E1)
      if (.not. allocated(DstEqMotionQPData%E1)) then
         allocate(DstEqMotionQPData%E1(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstEqMotionQPData%E1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstEqMotionQPData%E1 = SrcEqMotionQPData%E1
   end if
   if (allocated(SrcEqMotionQPData%Stif)) then
      LB(1:4) = lbound(SrcEqMotionQPData%Stif)
      UB(1:4) = ubound(SrcEqMotionQPData%Stif)
      if (.not. allocated(DstEqMotionQPData%Stif)) then
         allocate(DstEqMotionQPData%Stif(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstEqMotionQPData%Stif.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstEqMotionQPData%Stif = SrcEqMotionQPData%Stif
   end if
   if (allocated(SrcEqMotionQPData%Fb)) then
      LB(1:3) = lbound(SrcEqMotionQPData%Fb)
      UB(1:3) = ubound(SrcEqMotionQPData%Fb)
      if (.not. allocated(DstEqMotionQPData%Fb)) then
         allocate(DstEqMotionQPData%Fb(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstEqMotionQPData%Fb.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstEqMotionQPData%Fb = SrcEqMotionQPData%Fb
   end if
   if (allocated(SrcEqMotionQPData%Fc)) then
      LB(1:3) = lbound(SrcEqMotionQPData%Fc)
      UB(1:3) = ubound(SrcEqMotionQPData%Fc)
      if (.not. allocated(DstEqMotionQPData%Fc)) then
         allocate(DstEqMotionQPData%Fc(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstEqMotionQPData%Fc.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstEqMotionQPData%Fc = SrcEqMotionQPData%Fc
   end if
   if (allocated(SrcEqMotionQPData%Fd)) then
      LB(1:3) = lbound(SrcEqMotionQPData%Fd)
      UB(1:3) = ubound(SrcEqMotionQPData%Fd)
      if (.not. allocated(DstEqMotionQPData%Fd)) then
         allocate(DstEqMotionQPData%Fd(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstEqMotionQPData%Fd.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstEqMotionQPData%Fd = SrcEqMotionQPData%Fd
   end if
   if (allocated(SrcEqMotionQPData%Fg)) then
      LB(1:3) = lbound(SrcEqMotionQPData%Fg)
      UB(1:3) = ubound(SrcEqMotionQPData%Fg)
      if (.not. allocated(DstEqMotionQPData%Fg)) then
         allocate(DstEqMotionQPData%Fg(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstEqMotionQPData%Fg.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstEqMotionQPData%Fg = SrcEqMotionQPData%Fg
   end if
   if (allocated(SrcEqMotionQPData%Fi)) then
      LB(1:3) = lbound(SrcEqMotionQPData%Fi)
      UB(1:3) = ubound(SrcEqMotionQPData%Fi)
      if (.not. allocated(DstEqMotionQPData%Fi)) then
         allocate(DstEqMotionQPData%Fi(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstEqMotionQPData%Fi.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstEqMotionQPData%Fi = SrcEqMotionQPData%Fi
   end if
   if (allocated(SrcEqMotionQPData%Ftemp)) then
      LB(1:3) = lbound(SrcEqMotionQPData%Ftemp)
      UB(1:3) = ubound(SrcEqMotionQPData%Ftemp)
      if (.not. allocated(DstEqMotionQPData%Ftemp)) then
         allocate(DstEqMotionQPData%Ftemp(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstEqMotionQPData%Ftemp.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstEqMotionQPData%Ftemp = SrcEqMotionQPData%Ftemp
   end if
   if (allocated(SrcEqMotionQPData%RR0mEta)) then
      LB(1:3) = lbound(SrcEqMotionQPData%RR0mEta)
      UB(1:3) = ubound(SrcEqMotionQPData%RR0mEta)
      if (.not. allocated(DstEqMotionQPData%RR0mEta)) then
         allocate(DstEqMotionQPData%RR0mEta(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstEqMotionQPData%RR0mEta.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstEqMotionQPData%RR0mEta = SrcEqMotionQPData%RR0mEta
   end if
   if (allocated(SrcEqMotionQPData%rho)) then
      LB(1:4) = lbound(SrcEqMotionQPData%rho)
      UB(1:4) = ubound(SrcEqMotionQPData%rho)
      if (.not. allocated(DstEqMotionQPData%rho)) then
         allocate(DstEqMotionQPData%rho(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstEqMotionQPData%rho.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstEqMotionQPData%rho = SrcEqMotionQPData%rho
   end if
   if (allocated(SrcEqMotionQPData%betaC)) then
      LB(1:4) = lbound(SrcEqMotionQPData%betaC)
      UB(1:4) = ubound(SrcEqMotionQPData%betaC)
      if (.not. allocated(DstEqMotionQPData%betaC)) then
         allocate(DstEqMotionQPData%betaC(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstEqMotionQPData%betaC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstEqMotionQPData%betaC = SrcEqMotionQPData%betaC
   end if
   if (allocated(SrcEqMotionQPData%Gi)) then
      LB(1:4) = lbound(SrcEqMotionQPData%Gi)
      UB(1:4) = ubound(SrcEqMotionQPData%Gi)
      if (.not. allocated(DstEqMotionQPData%Gi)) then
         allocate(DstEqMotionQPData%Gi(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstEqMotionQPData%Gi.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstEqMotionQPData%Gi = SrcEqMotionQPData%Gi
   end if
   if (allocated(SrcEqMotionQPData%Ki)) then
      LB(1:4) = lbound(SrcEqMotionQPData%Ki)
      UB(1:4) = ubound(SrcEqMotionQPData%Ki)
      if (.not. allocated(DstEqMotionQPData%Ki)) then
         allocate(DstEqMotionQPData%Ki(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstEqMotionQPData%Ki.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstEqMotionQPData%Ki = SrcEqMotionQPData%Ki
   end if
   if (allocated(SrcEqMotionQPData%Mi)) then
      LB(1:4) = lbound(SrcEqMotionQPData%Mi)
      UB(1:4) = ubound(SrcEqMotionQPData%Mi)
      if (.not. allocated(DstEqMotionQPData%Mi)) then
         allocate(DstEqMotionQPData%Mi(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstEqMotionQPData%Mi.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstEqMotionQPData%Mi = SrcEqMotionQPData%Mi
   end if
   if (allocated(SrcEqMotionQPData%Oe)) then
      LB(1:4) = lbound(SrcEqMotionQPData%Oe)
      UB(1:4) = ubound(SrcEqMotionQPData%Oe)
      if (.not. allocated(DstEqMotionQPData%Oe)) then
         allocate(DstEqMotionQPData%Oe(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstEqMotionQPData%Oe.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstEqMotionQPData%Oe = SrcEqMotionQPData%Oe
   end if
   if (allocated(SrcEqMotionQPData%Pe)) then
      LB(1:4) = lbound(SrcEqMotionQPData%Pe)
      UB(1:4) = ubound(SrcEqMotionQPData%Pe)
      if (.not. allocated(DstEqMotionQPData%Pe)) then
         allocate(DstEqMotionQPData%Pe(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstEqMotionQPData%Pe.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstEqMotionQPData%Pe = SrcEqMotionQPData%Pe
   end if
   if (allocated(SrcEqMotionQPData%Qe)) then
      LB(1:4) = lbound(SrcEqMotionQPData%Qe)
      UB(1:4) = ubound(SrcEqMotionQPData%Qe)
      if (.not. allocated(DstEqMotionQPData%Qe)) then
         allocate(DstEqMotionQPData%Qe(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstEqMotionQPData%Qe.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstEqMotionQPData%Qe = SrcEqMotionQPData%Qe
   end if
   if (allocated(SrcEqMotionQPData%Gd)) then
      LB(1:4) = lbound(SrcEqMotionQPData%Gd)
      UB(1:4) = ubound(SrcEqMotionQPData%Gd)
      if (.not. allocated(DstEqMotionQPData%Gd)) then
         allocate(DstEqMotionQPData%Gd(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstEqMotionQPData%Gd.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstEqMotionQPData%Gd = SrcEqMotionQPData%Gd
   end if
   if (allocated(SrcEqMotionQPData%Od)) then
      LB(1:4) = lbound(SrcEqMotionQPData%Od)
      UB(1:4) = ubound(SrcEqMotionQPData%Od)
      if (.not. allocated(DstEqMotionQPData%Od)) then
         allocate(DstEqMotionQPData%Od(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstEqMotionQPData%Od.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstEqMotionQPData%Od = SrcEqMotionQPData%Od
   end if
   if (allocated(SrcEqMotionQPData%Pd)) then
      LB(1:4) = lbound(SrcEqMotionQPData%Pd)
      UB(1:4) = ubound(SrcEqMotionQPData%Pd)
      if (.not. allocated(DstEqMotionQPData%Pd)) then
         allocate(DstEqMotionQPData%Pd(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstEqMotionQPData%Pd.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstEqMotionQPData%Pd = SrcEqMotionQPData%Pd
   end if
   if (allocated(SrcEqMotionQPData%Qd)) then
      LB(1:4) = lbound(SrcEqMotionQPData%Qd)
      UB(1:4) = ubound(SrcEqMotionQPData%Qd)
      if (.not. allocated(DstEqMotionQPData%Qd)) then
         allocate(DstEqMotionQPData%Qd(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstEqMotionQPData%Qd.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstEqMotionQPData%Qd = SrcEqMotionQPData%Qd
   end if
   if (allocated(SrcEqMotionQPData%Sd)) then
      LB(1:4) = lbound(SrcEqMotionQPData%Sd)
      UB(1:4) = ubound(SrcEqMotionQPData%Sd)
      if (.not. allocated(DstEqMotionQPData%Sd)) then
         allocate(DstEqMotionQPData%Sd(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstEqMotionQPData%Sd.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstEqMotionQPData%Sd = SrcEqMotionQPData%Sd
   end if
   if (allocated(SrcEqMotionQPData%Xd)) then
      LB(1:4) = lbound(SrcEqMotionQPData%Xd)
      UB(1:4) = ubound(SrcEqMotionQPData%Xd)
      if (.not. allocated(DstEqMotionQPData%Xd)) then
         allocate(DstEqMotionQPData%Xd(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstEqMotionQPData%Xd.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstEqMotionQPData%Xd = SrcEqMotionQPData%Xd
   end if
   if (allocated(SrcEqMotionQPData%Yd)) then
      LB(1:4) = lbound(SrcEqMotionQPData%Yd)
      UB(1:4) = ubound(SrcEqMotionQPData%Yd)
      if (.not. allocated(DstEqMotionQPData%Yd)) then
         allocate(DstEqMotionQPData%Yd(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstEqMotionQPData%Yd.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstEqMotionQPData%Yd = SrcEqMotionQPData%Yd
   end if
end subroutine

subroutine BD_DestroyEqMotionQP(EqMotionQPData, ErrStat, ErrMsg)
   type(EqMotionQP), intent(inout) :: EqMotionQPData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'BD_DestroyEqMotionQP'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(EqMotionQPData%uuu)) then
      deallocate(EqMotionQPData%uuu)
   end if
   if (allocated(EqMotionQPData%uup)) then
      deallocate(EqMotionQPData%uup)
   end if
   if (allocated(EqMotionQPData%vvv)) then
      deallocate(EqMotionQPData%vvv)
   end if
   if (allocated(EqMotionQPData%vvp)) then
      deallocate(EqMotionQPData%vvp)
   end if
   if (allocated(EqMotionQPData%aaa)) then
      deallocate(EqMotionQPData%aaa)
   end if
   if (allocated(EqMotionQPData%RR0)) then
      deallocate(EqMotionQPData%RR0)
   end if
   if (allocated(EqMotionQPData%kappa)) then
      deallocate(EqMotionQPData%kappa)
   end if
   if (allocated(EqMotionQPData%E1)) then
      deallocate(EqMotionQPData%E1)
   end if
   if (allocated(EqMotionQPData%Stif)) then
      deallocate(EqMotionQPData%Stif)
   end if
   if (allocated(EqMotionQPData%Fb)) then
      deallocate(EqMotionQPData%Fb)
   end if
   if (allocated(EqMotionQPData%Fc)) then
      deallocate(EqMotionQPData%Fc)
   end if
   if (allocated(EqMotionQPData%Fd)) then
      deallocate(EqMotionQPData%Fd)
   end if
   if (allocated(EqMotionQPData%Fg)) then
      deallocate(EqMotionQPData%Fg)
   end if
   if (allocated(EqMotionQPData%Fi)) then
      deallocate(EqMotionQPData%Fi)
   end if
   if (allocated(EqMotionQPData%Ftemp)) then
      deallocate(EqMotionQPData%Ftemp)
   end if
   if (allocated(EqMotionQPData%RR0mEta)) then
      deallocate(EqMotionQPData%RR0mEta)
   end if
   if (allocated(EqMotionQPData%rho)) then
      deallocate(EqMotionQPData%rho)
   end if
   if (allocated(EqMotionQPData%betaC)) then
      deallocate(EqMotionQPData%betaC)
   end if
   if (allocated(EqMotionQPData%Gi)) then
      deallocate(EqMotionQPData%Gi)
   end if
   if (allocated(EqMotionQPData%Ki)) then
      deallocate(EqMotionQPData%Ki)
   end if
   if (allocated(EqMotionQPData%Mi)) then
      deallocate(EqMotionQPData%Mi)
   end if
   if (allocated(EqMotionQPData%Oe)) then
      deallocate(EqMotionQPData%Oe)
   end if
   if (allocated(EqMotionQPData%Pe)) then
      deallocate(EqMotionQPData%Pe)
   end if
   if (allocated(EqMotionQPData%Qe)) then
      deallocate(EqMotionQPData%Qe)
   end if
   if (allocated(EqMotionQPData%Gd)) then
      deallocate(EqMotionQPData%Gd)
   end if
   if (allocated(EqMotionQPData%Od)) then
      deallocate(EqMotionQPData%Od)
   end if
   if (allocated(EqMotionQPData%Pd)) then
      deallocate(EqMotionQPData%Pd)
   end if
   if (allocated(EqMotionQPData%Qd)) then
      deallocate(EqMotionQPData%Qd)
   end if
   if (allocated(EqMotionQPData%Sd)) then
      deallocate(EqMotionQPData%Sd)
   end if
   if (allocated(EqMotionQPData%Xd)) then
      deallocate(EqMotionQPData%Xd)
   end if
   if (allocated(EqMotionQPData%Yd)) then
      deallocate(EqMotionQPData%Yd)
   end if
end subroutine

subroutine BD_PackEqMotionQP(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(EqMotionQP), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'BD_PackEqMotionQP'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%uuu)
   call RegPackAlloc(RF, InData%uup)
   call RegPackAlloc(RF, InData%vvv)
   call RegPackAlloc(RF, InData%vvp)
   call RegPackAlloc(RF, InData%aaa)
   call RegPackAlloc(RF, InData%RR0)
   call RegPackAlloc(RF, InData%kappa)
   call RegPackAlloc(RF, InData%E1)
   call RegPackAlloc(RF, InData%Stif)
   call RegPackAlloc(RF, InData%Fb)
   call RegPackAlloc(RF, InData%Fc)
   call RegPackAlloc(RF, InData%Fd)
   call RegPackAlloc(RF, InData%Fg)
   call RegPackAlloc(RF, InData%Fi)
   call RegPackAlloc(RF, InData%Ftemp)
   call RegPackAlloc(RF, InData%RR0mEta)
   call RegPackAlloc(RF, InData%rho)
   call RegPackAlloc(RF, InData%betaC)
   call RegPackAlloc(RF, InData%Gi)
   call RegPackAlloc(RF, InData%Ki)
   call RegPackAlloc(RF, InData%Mi)
   call RegPackAlloc(RF, InData%Oe)
   call RegPackAlloc(RF, InData%Pe)
   call RegPackAlloc(RF, InData%Qe)
   call RegPackAlloc(RF, InData%Gd)
   call RegPackAlloc(RF, InData%Od)
   call RegPackAlloc(RF, InData%Pd)
   call RegPackAlloc(RF, InData%Qd)
   call RegPackAlloc(RF, InData%Sd)
   call RegPackAlloc(RF, InData%Xd)
   call RegPackAlloc(RF, InData%Yd)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BD_UnPackEqMotionQP(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(EqMotionQP), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'BD_UnPackEqMotionQP'
   integer(B4Ki)   :: LB(4), UB(4)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%uuu); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%uup); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%vvv); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%vvp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%aaa); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RR0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%kappa); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%E1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Stif); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Fb); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Fc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Fd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Fg); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Fi); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Ftemp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RR0mEta); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%rho); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%betaC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Gi); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Ki); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Mi); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Oe); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Pe); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Qe); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Gd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Od); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Pd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Qd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Sd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Xd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Yd); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BD_CopyMisc(SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg)
   type(BD_MiscVarType), intent(inout) :: SrcMiscData
   type(BD_MiscVarType), intent(inout) :: DstMiscData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(4), UB(4)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'BD_CopyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshCopy(SrcMiscData%u_DistrLoad_at_y, DstMiscData%u_DistrLoad_at_y, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcMiscData%y_BldMotion_at_u, DstMiscData%y_BldMotion_at_u, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcMiscData%LoadsAtRoot, DstMiscData%LoadsAtRoot, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call NWTC_Library_CopyMeshMapType(SrcMiscData%Map_u_DistrLoad_to_y, DstMiscData%Map_u_DistrLoad_to_y, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call NWTC_Library_CopyMeshMapType(SrcMiscData%Map_y_BldMotion_to_u, DstMiscData%Map_y_BldMotion_to_u, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call NWTC_Library_CopyMeshMapType(SrcMiscData%Map_u_DistrLoad_to_R, DstMiscData%Map_u_DistrLoad_to_R, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstMiscData%Un_Sum = SrcMiscData%Un_Sum
   call BD_CopyEqMotionQP(SrcMiscData%qp, DstMiscData%qp, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcMiscData%lin_A)) then
      LB(1:2) = lbound(SrcMiscData%lin_A)
      UB(1:2) = ubound(SrcMiscData%lin_A)
      if (.not. allocated(DstMiscData%lin_A)) then
         allocate(DstMiscData%lin_A(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%lin_A.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%lin_A = SrcMiscData%lin_A
   end if
   if (allocated(SrcMiscData%lin_C)) then
      LB(1:2) = lbound(SrcMiscData%lin_C)
      UB(1:2) = ubound(SrcMiscData%lin_C)
      if (.not. allocated(DstMiscData%lin_C)) then
         allocate(DstMiscData%lin_C(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%lin_C.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%lin_C = SrcMiscData%lin_C
   end if
   if (allocated(SrcMiscData%Nrrr)) then
      LB(1:3) = lbound(SrcMiscData%Nrrr)
      UB(1:3) = ubound(SrcMiscData%Nrrr)
      if (.not. allocated(DstMiscData%Nrrr)) then
         allocate(DstMiscData%Nrrr(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%Nrrr.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%Nrrr = SrcMiscData%Nrrr
   end if
   if (allocated(SrcMiscData%elf)) then
      LB(1:2) = lbound(SrcMiscData%elf)
      UB(1:2) = ubound(SrcMiscData%elf)
      if (.not. allocated(DstMiscData%elf)) then
         allocate(DstMiscData%elf(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%elf.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%elf = SrcMiscData%elf
   end if
   if (allocated(SrcMiscData%EFint)) then
      LB(1:3) = lbound(SrcMiscData%EFint)
      UB(1:3) = ubound(SrcMiscData%EFint)
      if (.not. allocated(DstMiscData%EFint)) then
         allocate(DstMiscData%EFint(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%EFint.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%EFint = SrcMiscData%EFint
   end if
   if (allocated(SrcMiscData%elk)) then
      LB(1:4) = lbound(SrcMiscData%elk)
      UB(1:4) = ubound(SrcMiscData%elk)
      if (.not. allocated(DstMiscData%elk)) then
         allocate(DstMiscData%elk(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%elk.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%elk = SrcMiscData%elk
   end if
   if (allocated(SrcMiscData%elg)) then
      LB(1:4) = lbound(SrcMiscData%elg)
      UB(1:4) = ubound(SrcMiscData%elg)
      if (.not. allocated(DstMiscData%elg)) then
         allocate(DstMiscData%elg(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%elg.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%elg = SrcMiscData%elg
   end if
   if (allocated(SrcMiscData%elm)) then
      LB(1:4) = lbound(SrcMiscData%elm)
      UB(1:4) = ubound(SrcMiscData%elm)
      if (.not. allocated(DstMiscData%elm)) then
         allocate(DstMiscData%elm(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%elm.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%elm = SrcMiscData%elm
   end if
   if (allocated(SrcMiscData%DistrLoad_QP)) then
      LB(1:3) = lbound(SrcMiscData%DistrLoad_QP)
      UB(1:3) = ubound(SrcMiscData%DistrLoad_QP)
      if (.not. allocated(DstMiscData%DistrLoad_QP)) then
         allocate(DstMiscData%DistrLoad_QP(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%DistrLoad_QP.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%DistrLoad_QP = SrcMiscData%DistrLoad_QP
   end if
   if (allocated(SrcMiscData%PointLoadLcl)) then
      LB(1:2) = lbound(SrcMiscData%PointLoadLcl)
      UB(1:2) = ubound(SrcMiscData%PointLoadLcl)
      if (.not. allocated(DstMiscData%PointLoadLcl)) then
         allocate(DstMiscData%PointLoadLcl(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%PointLoadLcl.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%PointLoadLcl = SrcMiscData%PointLoadLcl
   end if
   if (allocated(SrcMiscData%StifK)) then
      LB(1:4) = lbound(SrcMiscData%StifK)
      UB(1:4) = ubound(SrcMiscData%StifK)
      if (.not. allocated(DstMiscData%StifK)) then
         allocate(DstMiscData%StifK(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%StifK.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%StifK = SrcMiscData%StifK
   end if
   if (allocated(SrcMiscData%MassM)) then
      LB(1:4) = lbound(SrcMiscData%MassM)
      UB(1:4) = ubound(SrcMiscData%MassM)
      if (.not. allocated(DstMiscData%MassM)) then
         allocate(DstMiscData%MassM(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%MassM.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%MassM = SrcMiscData%MassM
   end if
   if (allocated(SrcMiscData%DampG)) then
      LB(1:4) = lbound(SrcMiscData%DampG)
      UB(1:4) = ubound(SrcMiscData%DampG)
      if (.not. allocated(DstMiscData%DampG)) then
         allocate(DstMiscData%DampG(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%DampG.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%DampG = SrcMiscData%DampG
   end if
   if (allocated(SrcMiscData%StifK_fd)) then
      LB(1:4) = lbound(SrcMiscData%StifK_fd)
      UB(1:4) = ubound(SrcMiscData%StifK_fd)
      if (.not. allocated(DstMiscData%StifK_fd)) then
         allocate(DstMiscData%StifK_fd(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%StifK_fd.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%StifK_fd = SrcMiscData%StifK_fd
   end if
   if (allocated(SrcMiscData%MassM_fd)) then
      LB(1:4) = lbound(SrcMiscData%MassM_fd)
      UB(1:4) = ubound(SrcMiscData%MassM_fd)
      if (.not. allocated(DstMiscData%MassM_fd)) then
         allocate(DstMiscData%MassM_fd(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%MassM_fd.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%MassM_fd = SrcMiscData%MassM_fd
   end if
   if (allocated(SrcMiscData%DampG_fd)) then
      LB(1:4) = lbound(SrcMiscData%DampG_fd)
      UB(1:4) = ubound(SrcMiscData%DampG_fd)
      if (.not. allocated(DstMiscData%DampG_fd)) then
         allocate(DstMiscData%DampG_fd(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%DampG_fd.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%DampG_fd = SrcMiscData%DampG_fd
   end if
   if (allocated(SrcMiscData%RHS)) then
      LB(1:2) = lbound(SrcMiscData%RHS)
      UB(1:2) = ubound(SrcMiscData%RHS)
      if (.not. allocated(DstMiscData%RHS)) then
         allocate(DstMiscData%RHS(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%RHS.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%RHS = SrcMiscData%RHS
   end if
   if (allocated(SrcMiscData%RHS_p)) then
      LB(1:2) = lbound(SrcMiscData%RHS_p)
      UB(1:2) = ubound(SrcMiscData%RHS_p)
      if (.not. allocated(DstMiscData%RHS_p)) then
         allocate(DstMiscData%RHS_p(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%RHS_p.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%RHS_p = SrcMiscData%RHS_p
   end if
   if (allocated(SrcMiscData%RHS_m)) then
      LB(1:2) = lbound(SrcMiscData%RHS_m)
      UB(1:2) = ubound(SrcMiscData%RHS_m)
      if (.not. allocated(DstMiscData%RHS_m)) then
         allocate(DstMiscData%RHS_m(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%RHS_m.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%RHS_m = SrcMiscData%RHS_m
   end if
   if (allocated(SrcMiscData%BldInternalForceFE)) then
      LB(1:2) = lbound(SrcMiscData%BldInternalForceFE)
      UB(1:2) = ubound(SrcMiscData%BldInternalForceFE)
      if (.not. allocated(DstMiscData%BldInternalForceFE)) then
         allocate(DstMiscData%BldInternalForceFE(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%BldInternalForceFE.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%BldInternalForceFE = SrcMiscData%BldInternalForceFE
   end if
   if (allocated(SrcMiscData%BldInternalForceQP)) then
      LB(1:2) = lbound(SrcMiscData%BldInternalForceQP)
      UB(1:2) = ubound(SrcMiscData%BldInternalForceQP)
      if (.not. allocated(DstMiscData%BldInternalForceQP)) then
         allocate(DstMiscData%BldInternalForceQP(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%BldInternalForceQP.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%BldInternalForceQP = SrcMiscData%BldInternalForceQP
   end if
   if (allocated(SrcMiscData%FirstNodeReactionLclForceMoment)) then
      LB(1:1) = lbound(SrcMiscData%FirstNodeReactionLclForceMoment)
      UB(1:1) = ubound(SrcMiscData%FirstNodeReactionLclForceMoment)
      if (.not. allocated(DstMiscData%FirstNodeReactionLclForceMoment)) then
         allocate(DstMiscData%FirstNodeReactionLclForceMoment(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%FirstNodeReactionLclForceMoment.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%FirstNodeReactionLclForceMoment = SrcMiscData%FirstNodeReactionLclForceMoment
   end if
   if (allocated(SrcMiscData%Solution)) then
      LB(1:2) = lbound(SrcMiscData%Solution)
      UB(1:2) = ubound(SrcMiscData%Solution)
      if (.not. allocated(DstMiscData%Solution)) then
         allocate(DstMiscData%Solution(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%Solution.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%Solution = SrcMiscData%Solution
   end if
   if (allocated(SrcMiscData%LP_StifK)) then
      LB(1:2) = lbound(SrcMiscData%LP_StifK)
      UB(1:2) = ubound(SrcMiscData%LP_StifK)
      if (.not. allocated(DstMiscData%LP_StifK)) then
         allocate(DstMiscData%LP_StifK(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%LP_StifK.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%LP_StifK = SrcMiscData%LP_StifK
   end if
   if (allocated(SrcMiscData%LP_MassM)) then
      LB(1:2) = lbound(SrcMiscData%LP_MassM)
      UB(1:2) = ubound(SrcMiscData%LP_MassM)
      if (.not. allocated(DstMiscData%LP_MassM)) then
         allocate(DstMiscData%LP_MassM(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%LP_MassM.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%LP_MassM = SrcMiscData%LP_MassM
   end if
   if (allocated(SrcMiscData%LP_MassM_LU)) then
      LB(1:2) = lbound(SrcMiscData%LP_MassM_LU)
      UB(1:2) = ubound(SrcMiscData%LP_MassM_LU)
      if (.not. allocated(DstMiscData%LP_MassM_LU)) then
         allocate(DstMiscData%LP_MassM_LU(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%LP_MassM_LU.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%LP_MassM_LU = SrcMiscData%LP_MassM_LU
   end if
   if (allocated(SrcMiscData%LP_RHS)) then
      LB(1:1) = lbound(SrcMiscData%LP_RHS)
      UB(1:1) = ubound(SrcMiscData%LP_RHS)
      if (.not. allocated(DstMiscData%LP_RHS)) then
         allocate(DstMiscData%LP_RHS(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%LP_RHS.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%LP_RHS = SrcMiscData%LP_RHS
   end if
   if (allocated(SrcMiscData%LP_StifK_LU)) then
      LB(1:2) = lbound(SrcMiscData%LP_StifK_LU)
      UB(1:2) = ubound(SrcMiscData%LP_StifK_LU)
      if (.not. allocated(DstMiscData%LP_StifK_LU)) then
         allocate(DstMiscData%LP_StifK_LU(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%LP_StifK_LU.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%LP_StifK_LU = SrcMiscData%LP_StifK_LU
   end if
   if (allocated(SrcMiscData%LP_RHS_LU)) then
      LB(1:1) = lbound(SrcMiscData%LP_RHS_LU)
      UB(1:1) = ubound(SrcMiscData%LP_RHS_LU)
      if (.not. allocated(DstMiscData%LP_RHS_LU)) then
         allocate(DstMiscData%LP_RHS_LU(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%LP_RHS_LU.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%LP_RHS_LU = SrcMiscData%LP_RHS_LU
   end if
   if (allocated(SrcMiscData%LP_indx)) then
      LB(1:1) = lbound(SrcMiscData%LP_indx)
      UB(1:1) = ubound(SrcMiscData%LP_indx)
      if (.not. allocated(DstMiscData%LP_indx)) then
         allocate(DstMiscData%LP_indx(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%LP_indx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%LP_indx = SrcMiscData%LP_indx
   end if
   call BD_CopyInput(SrcMiscData%u, DstMiscData%u, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call BD_CopyInput(SrcMiscData%u2, DstMiscData%u2, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine BD_DestroyMisc(MiscData, ErrStat, ErrMsg)
   type(BD_MiscVarType), intent(inout) :: MiscData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'BD_DestroyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshDestroy( MiscData%u_DistrLoad_at_y, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( MiscData%y_BldMotion_at_u, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( MiscData%LoadsAtRoot, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call NWTC_Library_DestroyMeshMapType(MiscData%Map_u_DistrLoad_to_y, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call NWTC_Library_DestroyMeshMapType(MiscData%Map_y_BldMotion_to_u, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call NWTC_Library_DestroyMeshMapType(MiscData%Map_u_DistrLoad_to_R, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call BD_DestroyEqMotionQP(MiscData%qp, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(MiscData%lin_A)) then
      deallocate(MiscData%lin_A)
   end if
   if (allocated(MiscData%lin_C)) then
      deallocate(MiscData%lin_C)
   end if
   if (allocated(MiscData%Nrrr)) then
      deallocate(MiscData%Nrrr)
   end if
   if (allocated(MiscData%elf)) then
      deallocate(MiscData%elf)
   end if
   if (allocated(MiscData%EFint)) then
      deallocate(MiscData%EFint)
   end if
   if (allocated(MiscData%elk)) then
      deallocate(MiscData%elk)
   end if
   if (allocated(MiscData%elg)) then
      deallocate(MiscData%elg)
   end if
   if (allocated(MiscData%elm)) then
      deallocate(MiscData%elm)
   end if
   if (allocated(MiscData%DistrLoad_QP)) then
      deallocate(MiscData%DistrLoad_QP)
   end if
   if (allocated(MiscData%PointLoadLcl)) then
      deallocate(MiscData%PointLoadLcl)
   end if
   if (allocated(MiscData%StifK)) then
      deallocate(MiscData%StifK)
   end if
   if (allocated(MiscData%MassM)) then
      deallocate(MiscData%MassM)
   end if
   if (allocated(MiscData%DampG)) then
      deallocate(MiscData%DampG)
   end if
   if (allocated(MiscData%StifK_fd)) then
      deallocate(MiscData%StifK_fd)
   end if
   if (allocated(MiscData%MassM_fd)) then
      deallocate(MiscData%MassM_fd)
   end if
   if (allocated(MiscData%DampG_fd)) then
      deallocate(MiscData%DampG_fd)
   end if
   if (allocated(MiscData%RHS)) then
      deallocate(MiscData%RHS)
   end if
   if (allocated(MiscData%RHS_p)) then
      deallocate(MiscData%RHS_p)
   end if
   if (allocated(MiscData%RHS_m)) then
      deallocate(MiscData%RHS_m)
   end if
   if (allocated(MiscData%BldInternalForceFE)) then
      deallocate(MiscData%BldInternalForceFE)
   end if
   if (allocated(MiscData%BldInternalForceQP)) then
      deallocate(MiscData%BldInternalForceQP)
   end if
   if (allocated(MiscData%FirstNodeReactionLclForceMoment)) then
      deallocate(MiscData%FirstNodeReactionLclForceMoment)
   end if
   if (allocated(MiscData%Solution)) then
      deallocate(MiscData%Solution)
   end if
   if (allocated(MiscData%LP_StifK)) then
      deallocate(MiscData%LP_StifK)
   end if
   if (allocated(MiscData%LP_MassM)) then
      deallocate(MiscData%LP_MassM)
   end if
   if (allocated(MiscData%LP_MassM_LU)) then
      deallocate(MiscData%LP_MassM_LU)
   end if
   if (allocated(MiscData%LP_RHS)) then
      deallocate(MiscData%LP_RHS)
   end if
   if (allocated(MiscData%LP_StifK_LU)) then
      deallocate(MiscData%LP_StifK_LU)
   end if
   if (allocated(MiscData%LP_RHS_LU)) then
      deallocate(MiscData%LP_RHS_LU)
   end if
   if (allocated(MiscData%LP_indx)) then
      deallocate(MiscData%LP_indx)
   end if
   call BD_DestroyInput(MiscData%u, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call BD_DestroyInput(MiscData%u2, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine BD_PackMisc(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(BD_MiscVarType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'BD_PackMisc'
   if (RF%ErrStat >= AbortErrLev) return
   call MeshPack(RF, InData%u_DistrLoad_at_y) 
   call MeshPack(RF, InData%y_BldMotion_at_u) 
   call MeshPack(RF, InData%LoadsAtRoot) 
   call NWTC_Library_PackMeshMapType(RF, InData%Map_u_DistrLoad_to_y) 
   call NWTC_Library_PackMeshMapType(RF, InData%Map_y_BldMotion_to_u) 
   call NWTC_Library_PackMeshMapType(RF, InData%Map_u_DistrLoad_to_R) 
   call RegPack(RF, InData%Un_Sum)
   call BD_PackEqMotionQP(RF, InData%qp) 
   call RegPackAlloc(RF, InData%lin_A)
   call RegPackAlloc(RF, InData%lin_C)
   call RegPackAlloc(RF, InData%Nrrr)
   call RegPackAlloc(RF, InData%elf)
   call RegPackAlloc(RF, InData%EFint)
   call RegPackAlloc(RF, InData%elk)
   call RegPackAlloc(RF, InData%elg)
   call RegPackAlloc(RF, InData%elm)
   call RegPackAlloc(RF, InData%DistrLoad_QP)
   call RegPackAlloc(RF, InData%PointLoadLcl)
   call RegPackAlloc(RF, InData%StifK)
   call RegPackAlloc(RF, InData%MassM)
   call RegPackAlloc(RF, InData%DampG)
   call RegPackAlloc(RF, InData%StifK_fd)
   call RegPackAlloc(RF, InData%MassM_fd)
   call RegPackAlloc(RF, InData%DampG_fd)
   call RegPackAlloc(RF, InData%RHS)
   call RegPackAlloc(RF, InData%RHS_p)
   call RegPackAlloc(RF, InData%RHS_m)
   call RegPackAlloc(RF, InData%BldInternalForceFE)
   call RegPackAlloc(RF, InData%BldInternalForceQP)
   call RegPackAlloc(RF, InData%FirstNodeReactionLclForceMoment)
   call RegPackAlloc(RF, InData%Solution)
   call RegPackAlloc(RF, InData%LP_StifK)
   call RegPackAlloc(RF, InData%LP_MassM)
   call RegPackAlloc(RF, InData%LP_MassM_LU)
   call RegPackAlloc(RF, InData%LP_RHS)
   call RegPackAlloc(RF, InData%LP_StifK_LU)
   call RegPackAlloc(RF, InData%LP_RHS_LU)
   call RegPackAlloc(RF, InData%LP_indx)
   call BD_PackInput(RF, InData%u) 
   call BD_PackInput(RF, InData%u2) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BD_UnPackMisc(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(BD_MiscVarType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'BD_UnPackMisc'
   integer(B4Ki)   :: LB(4), UB(4)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call MeshUnpack(RF, OutData%u_DistrLoad_at_y) ! u_DistrLoad_at_y 
   call MeshUnpack(RF, OutData%y_BldMotion_at_u) ! y_BldMotion_at_u 
   call MeshUnpack(RF, OutData%LoadsAtRoot) ! LoadsAtRoot 
   call NWTC_Library_UnpackMeshMapType(RF, OutData%Map_u_DistrLoad_to_y) ! Map_u_DistrLoad_to_y 
   call NWTC_Library_UnpackMeshMapType(RF, OutData%Map_y_BldMotion_to_u) ! Map_y_BldMotion_to_u 
   call NWTC_Library_UnpackMeshMapType(RF, OutData%Map_u_DistrLoad_to_R) ! Map_u_DistrLoad_to_R 
   call RegUnpack(RF, OutData%Un_Sum); if (RegCheckErr(RF, RoutineName)) return
   call BD_UnpackEqMotionQP(RF, OutData%qp) ! qp 
   call RegUnpackAlloc(RF, OutData%lin_A); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%lin_C); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Nrrr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%elf); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%EFint); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%elk); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%elg); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%elm); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%DistrLoad_QP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PointLoadLcl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%StifK); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%MassM); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%DampG); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%StifK_fd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%MassM_fd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%DampG_fd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RHS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RHS_p); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RHS_m); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BldInternalForceFE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BldInternalForceQP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%FirstNodeReactionLclForceMoment); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Solution); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LP_StifK); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LP_MassM); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LP_MassM_LU); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LP_RHS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LP_StifK_LU); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LP_RHS_LU); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LP_indx); if (RegCheckErr(RF, RoutineName)) return
   call BD_UnpackInput(RF, OutData%u) ! u 
   call BD_UnpackInput(RF, OutData%u2) ! u2 
end subroutine

subroutine BD_Input_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
   ! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(BD_InputType), intent(inout)  :: u(:) ! Input at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Inputs
   type(BD_InputType), intent(inout)  :: u_out ! Input at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'BD_Input_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(u)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(u)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(u) - 1
   select case (order)
   case (0)
      call BD_CopyInput(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call BD_Input_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call BD_Input_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(u) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE BD_Input_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

   TYPE(BD_InputType), INTENT(INOUT)  :: u1    ! Input at t1 > t2
   TYPE(BD_InputType), INTENT(INOUT)  :: u2    ! Input at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Inputs
   TYPE(BD_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'BD_Input_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   CALL MeshExtrapInterp1(u1%RootMotion, u2%RootMotion, tin, u_out%RootMotion, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp1(u1%PointLoad, u2%PointLoad, tin, u_out%PointLoad, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp1(u1%DistrLoad, u2%DistrLoad, tin, u_out%DistrLoad, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp1(u1%HubMotion, u2%HubMotion, tin, u_out%HubMotion, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
END SUBROUTINE

SUBROUTINE BD_Input_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

   TYPE(BD_InputType), INTENT(INOUT)  :: u1      ! Input at t1 > t2 > t3
   TYPE(BD_InputType), INTENT(INOUT)  :: u2      ! Input at t2 > t3
   TYPE(BD_InputType), INTENT(INOUT)  :: u3      ! Input at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Inputs
   TYPE(BD_InputType), INTENT(INOUT)  :: u_out     ! Input at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'BD_Input_ExtrapInterp2'
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   CALL MeshExtrapInterp2(u1%RootMotion, u2%RootMotion, u3%RootMotion, tin, u_out%RootMotion, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp2(u1%PointLoad, u2%PointLoad, u3%PointLoad, tin, u_out%PointLoad, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp2(u1%DistrLoad, u2%DistrLoad, u3%DistrLoad, tin, u_out%DistrLoad, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp2(u1%HubMotion, u2%HubMotion, u3%HubMotion, tin, u_out%HubMotion, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
END SUBROUTINE

subroutine BD_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
   ! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(BD_OutputType), intent(inout)  :: y(:) ! Output at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Outputs
   type(BD_OutputType), intent(inout)  :: y_out ! Output at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'BD_Output_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(y)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(y)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(y) - 1
   select case (order)
   case (0)
      call BD_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call BD_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call BD_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(y) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE BD_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

   TYPE(BD_OutputType), INTENT(INOUT)  :: y1    ! Output at t1 > t2
   TYPE(BD_OutputType), INTENT(INOUT)  :: y2    ! Output at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
   TYPE(BD_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'BD_Output_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   CALL MeshExtrapInterp1(y1%ReactionForce, y2%ReactionForce, tin, y_out%ReactionForce, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp1(y1%BldMotion, y2%BldMotion, tin, y_out%BldMotion, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   y_out%RootMxr = a1*y1%RootMxr + a2*y2%RootMxr
   y_out%RootMyr = a1*y1%RootMyr + a2*y2%RootMyr
   IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
      y_out%WriteOutput = a1*y1%WriteOutput + a2*y2%WriteOutput
   END IF ! check if allocated
END SUBROUTINE

SUBROUTINE BD_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

   TYPE(BD_OutputType), INTENT(INOUT)  :: y1      ! Output at t1 > t2 > t3
   TYPE(BD_OutputType), INTENT(INOUT)  :: y2      ! Output at t2 > t3
   TYPE(BD_OutputType), INTENT(INOUT)  :: y3      ! Output at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
   TYPE(BD_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'BD_Output_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   CALL MeshExtrapInterp2(y1%ReactionForce, y2%ReactionForce, y3%ReactionForce, tin, y_out%ReactionForce, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   CALL MeshExtrapInterp2(y1%BldMotion, y2%BldMotion, y3%BldMotion, tin, y_out%BldMotion, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   y_out%RootMxr = a1*y1%RootMxr + a2*y2%RootMxr + a3*y3%RootMxr
   y_out%RootMyr = a1*y1%RootMyr + a2*y2%RootMyr + a3*y3%RootMyr
   IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
      y_out%WriteOutput = a1*y1%WriteOutput + a2*y2%WriteOutput + a3*y3%WriteOutput
   END IF ! check if allocated
END SUBROUTINE
END MODULE BeamDyn_Types
!ENDOFREGISTRYGENERATEDFILE
