!STARTOFREGISTRYGENERATEDFILE 'AWAE_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! AWAE_Types
!.................................................................................................................................
! This file is part of AWAE.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in AWAE. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE AWAE_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE InflowWind_Types
USE NWTC_Library
IMPLICIT NONE
    INTEGER(IntKi), PUBLIC, PARAMETER  :: XYSlice = 1      ! Extract an XY slice of data from the 3D grid [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: YZSlice = 2      ! Extract an YZ slice of data from the 3D grid [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: XZSlice = 3      ! Extract an XZ slice of data from the 3D grid [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: MeanderMod_Uniform = 1      ! Spatial filter model for wake meandering: uniform [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: MeanderMod_TruncJinc = 2      ! Spatial filter model for wake meandering: truncated jinc [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: MeanderMod_WndwdJinc = 3      ! Spatial filter model for wake meandering: windowed jinc [-]
! =========  AWAE_HighWindGrid  =======
  TYPE, PUBLIC :: AWAE_HighWindGrid
    REAL(SiKi) , DIMENSION(:,:,:,:,:), POINTER  :: data => NULL()      !< UVW components of wind data across the high-res regularly-spaced grid [m/s]
  END TYPE AWAE_HighWindGrid
! =======================
! =========  AWAE_HighWindGridPtr  =======
  TYPE, PUBLIC :: AWAE_HighWindGridPtr
    REAL(SiKi) , DIMENSION(:,:,:,:,:), POINTER  :: data => NULL()      !< Pointer to UVW components of wind data across the high-res regularly-spaced grid [m/s]
  END TYPE AWAE_HighWindGridPtr
! =======================
! =========  AWAE_InputFileType  =======
  TYPE, PUBLIC :: AWAE_InputFileType
    REAL(ReKi)  :: dr = 0.0_ReKi      !< Radial increment of radial finite-difference grid [>0.0] [m]
    REAL(DbKi)  :: dt_low = 0.0_R8Ki      !< Low-resolution (FAST.Farm driver/glue code) time step [s]
    INTEGER(IntKi)  :: NumTurbines = 0_IntKi      !< Number of wind turbines in the farm [>=1] [-]
    INTEGER(IntKi)  :: NumRadii = 0_IntKi      !< Number of radii in the radial finite-difference grid  [>=2] [-]
    INTEGER(IntKi)  :: NumPlanes = 0_IntKi      !< Number of wake planes downwind of the rotor where the wake is propagated [>=2] [-]
    CHARACTER(1024)  :: WindFilePath      !< Path name to the Root folder containing the wind data files from ABLSolver precursor [-]
    LOGICAL  :: WrDisWind = .false.      !< Write disturbed wind data to <WindFilePath>/Low/Dis.t<n>.vtk etc.? [-]
    INTEGER(IntKi)  :: NOutDisWindXY = 0_IntKi      !< Number of XY planes for output of disturbed wind data across the low-resolution domain to <WindFilePath>/Low/DisXY.<n_out>.t<n>.vtk [0 to 9] [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: OutDisWindZ      !< Z coordinates of XY planes for output of disturbed wind data across the low-resolution domain [1 to NOutDisWindXY] [meters]
    INTEGER(IntKi)  :: NOutDisWindYZ = 0_IntKi      !< Number of YZ planes for output of disturbed wind data across the low-resolution domain to <WindFilePath>/Low/DisYZ.<n_out>.t<n>.vtk [0 to 9] [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: OutDisWindX      !< X coordinates of YZ planes for output of disturbed wind data across the low-resolution domain [1 to NOutDisWindYZ] [meters]
    INTEGER(IntKi)  :: NOutDisWindXZ = 0_IntKi      !< Number of XZ planes for output of disturbed wind data across the low-resolution domain to <WindFilePath>/Low/DisXZ.<n_out>.t<n>.vtk [0 to 9] [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: OutDisWindY      !< Y coordinates of XZ planes for output of disturbed wind data across the low-resolution domain [1 to NOutDisWindXZ] [meters]
    REAL(DbKi)  :: WrDisDT = 0.0_R8Ki      !< The time between vtk outputs [must be a multiple of the low resolution time step] [s]
    LOGICAL  :: ChkWndFiles = .false.      !< Check all the ambient wind files for data consistency (flag) [-]
    INTEGER(IntKi)  :: Mod_Meander = 0_IntKi      !< Spatial filter model for wake meandering {1: uniform, 2: truncated jinc, 3: windowed jinc} [DEFAULT=2] [-]
    REAL(ReKi)  :: C_Meander = 0.0_ReKi      !< Calibrated parameter for wake meandering [>=1.0] [DEFAULT=1.9] [-]
    INTEGER(IntKi)  :: Mod_AmbWind = 0_IntKi      !< Ambient wind model {1: high-fidelity precursor in VTK format, 2: InflowWind module} [-]
    CHARACTER(1024)  :: InflowFile      !< Name of file containing InflowWind module input parameters [-]
    REAL(DbKi)  :: dt_high = 0.0_R8Ki      !< High-resolution (FAST) time step [s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: X0_high      !< X-component of the origin of the high-resolution spatial domain for each turbine [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Y0_high      !< Y-component of the origin of the high-resolution spatial domain for each turbine [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Z0_high      !< Z-component of the origin of the high-resolution spatial domain for each turbine [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: dX_high      !< X-component of the spatial increment of the high-resolution spatial domain for each turbine [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: dY_high      !< Y-component of the spatial increment of the high-resolution spatial domain for each turbine [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: dZ_high      !< Z-component of the spatial increment of the high-resolution spatial domain for each turbine [m]
    INTEGER(IntKi)  :: nX_high = 0_IntKi      !< Number of high-resolution spatial nodes in X direction  [-]
    INTEGER(IntKi)  :: nY_high = 0_IntKi      !< Number of high-resolution spatial nodes in Y direction [-]
    INTEGER(IntKi)  :: nZ_high = 0_IntKi      !< Number of high-resolution spatial nodes in Z direction [-]
    REAL(ReKi)  :: dX_low = 0.0_ReKi      !< The spacing of the low-resolution nodes in X direction [m]
    REAL(ReKi)  :: dY_low = 0.0_ReKi      !< The spacing of the low-resolution nodes in Y direction [m]
    REAL(ReKi)  :: dZ_low = 0.0_ReKi      !< The spacing of the low-resolution nodes in Z direction [m]
    INTEGER(IntKi)  :: nX_low = 0_IntKi      !< Number of low-resolution spatial nodes in X direction [-]
    INTEGER(IntKi)  :: nY_low = 0_IntKi      !< Number of low-resolution spatial nodes in Y direction [-]
    INTEGER(IntKi)  :: nZ_low = 0_IntKi      !< Number of low-resolution spatial nodes in Z direction [-]
    REAL(ReKi)  :: X0_low = 0.0_ReKi      !< X-component of the origin of the low-resolution spatial domain [m]
    REAL(ReKi)  :: Y0_low = 0.0_ReKi      !< Y-component of the origin of the low-resolution spatial domain [m]
    REAL(ReKi)  :: Z0_low = 0.0_ReKi      !< Z-component of the origin of the low-resolution spatial domain [m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: WT_Position      !< X-Y-Z position of each wind turbine; index 1 = XYZ; index 2 = turbine number [meters]
    INTEGER(IntKi)  :: Mod_Projection = 0_IntKi      !< Switch to select how the wake plane velocity is projected in AWAE {1: keep all components, 2: project against plane normal} or DEFAULT [DEFAULT=1: if Mod_Wake is 1 or 3, or DEFAULT=2: if Mod_Wake is 2] [-]
  END TYPE AWAE_InputFileType
! =======================
! =========  AWAE_InitInputType  =======
  TYPE, PUBLIC :: AWAE_InitInputType
    TYPE(AWAE_InputFileType)  :: InputFileData      !< FAST.Farm input-file data for AWAE module [-]
    INTEGER(IntKi)  :: n_high_low = 0_IntKi      !< Number of high-resolution time steps per low [-]
    INTEGER(IntKi)  :: NumDT = 0_IntKi      !< Number of low-resolution (FAST.Farm driver/glue code) time steps [-]
    CHARACTER(1024)  :: OutFileRoot      !< The root name derived from the primary FAST.Farm input file [-]
    LOGICAL  :: WAT_Enabled = .false.      !< Is WAT enabled? [-]
    TYPE(FlowFieldType) , POINTER :: WAT_FlowField => NULL()      !< Pointer to the InflowWinds flow field data type [-]
  END TYPE AWAE_InitInputType
! =======================
! =========  AWAE_InitOutputType  =======
  TYPE, PUBLIC :: AWAE_InitOutputType
    TYPE(ProgDesc)  :: Ver      !< This module's name, version, and date [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: X0_high      !< X-component of the origin of the high-resolution spatial domain for each turbine [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Y0_high      !< Y-component of the origin of the high-resolution spatial domain for each turbine [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Z0_high      !< Z-component of the origin of the high-resolution spatial domain for each turbine [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: dX_high      !< X-component of the spatial increment of the high-resolution spatial domain for each turbine [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: dY_high      !< Y-component of the spatial increment of the high-resolution spatial domain for each turbine [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: dZ_high      !< Z-component of the spatial increment of the high-resolution spatial domain for each turbine [m]
    INTEGER(IntKi)  :: nX_high = 0_IntKi      !< Number of high-resolution spatial nodes in X direction  [-]
    INTEGER(IntKi)  :: nY_high = 0_IntKi      !< Number of high-resolution spatial nodes in Y direction [-]
    INTEGER(IntKi)  :: nZ_high = 0_IntKi      !< Number of high-resolution spatial nodes in Z direction [-]
    REAL(ReKi)  :: dX_low = 0.0_ReKi      !< The spacing of the low-resolution nodes in X direction [m]
    REAL(ReKi)  :: dY_low = 0.0_ReKi      !< The spacing of the low-resolution nodes in Y direction [m]
    REAL(ReKi)  :: dZ_low = 0.0_ReKi      !< The spacing of the low-resolution nodes in Z direction [m]
    INTEGER(IntKi)  :: nX_low = 0_IntKi      !< Number of low-resolution spatial nodes in X direction [-]
    INTEGER(IntKi)  :: nY_low = 0_IntKi      !< Number of low-resolution spatial nodes in Y direction [-]
    INTEGER(IntKi)  :: nZ_low = 0_IntKi      !< Number of low-resolution spatial nodes in Z direction [-]
    REAL(ReKi)  :: X0_low = 0.0_ReKi      !< X-component of the origin of the low-resolution spatial domain [m]
    REAL(ReKi)  :: Y0_low = 0.0_ReKi      !< Y-component of the origin of the low-resolution spatial domain [m]
    REAL(ReKi)  :: Z0_low = 0.0_ReKi      !< Z-component of the origin of the low-resolution spatial domain [m]
    TYPE(AWAE_HighWindGridPtr) , DIMENSION(:), ALLOCATABLE  :: Vdist_High      !< Pointers to Wind velocity of disturbed wind (ambient + wakes) across each high-resolution domain around a turbine for each high-resolution step within a low-resolution step [m/s]
  END TYPE AWAE_InitOutputType
! =======================
! =========  AWAE_ContinuousStateType  =======
  TYPE, PUBLIC :: AWAE_ContinuousStateType
    TYPE(InflowWind_ContinuousStateType) , DIMENSION(:), ALLOCATABLE  :: IfW      !< Dummy IfW continuous states [-]
  END TYPE AWAE_ContinuousStateType
! =======================
! =========  AWAE_DiscreteStateType  =======
  TYPE, PUBLIC :: AWAE_DiscreteStateType
    TYPE(InflowWind_DiscreteStateType) , DIMENSION(:), ALLOCATABLE  :: IfW      !< Dummy IfW discrete states [-]
    REAL(ReKi) , DIMENSION(1:3)  :: WAT_B_Box = 0.0_ReKi      !< Position of passive tracer used to offset the WAT box at each low res time step [m]
    REAL(ReKi) , DIMENSION(1:3)  :: Ufarm = 0.0_ReKi      !< mean velocity of all disk average flow for all turbines in farm [m/s]
  END TYPE AWAE_DiscreteStateType
! =======================
! =========  AWAE_ConstraintStateType  =======
  TYPE, PUBLIC :: AWAE_ConstraintStateType
    TYPE(InflowWind_ConstraintStateType) , DIMENSION(:), ALLOCATABLE  :: IfW      !< Dummy IfW  constraint states [-]
  END TYPE AWAE_ConstraintStateType
! =======================
! =========  AWAE_OtherStateType  =======
  TYPE, PUBLIC :: AWAE_OtherStateType
    TYPE(InflowWind_OtherStateType) , DIMENSION(:), ALLOCATABLE  :: IfW      !< Dummy IfW other states [-]
  END TYPE AWAE_OtherStateType
! =======================
! =========  AWAE_MiscVarType  =======
  TYPE, PUBLIC :: AWAE_MiscVarType
    REAL(SiKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: Vamb_low      !< UVW components of ambient wind across the low-resolution domain throughout the farm [m/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Vamb_lowpol      !< UVW components of disturbed wind (ambient + wakes) at points in the polar grid for each wake plane for each turbine [m/s]
    REAL(SiKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: Vdist_low      !< UVW components of disturbed wind (ambient + deficits) across the low-resolution domain throughout the farm [m/s]
    REAL(SiKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: Vdist_low_full      !< UVW components of disturbed wind (ambient + deficits) across the low-resolution domain throughout the farm, for outputs [m/s]
    TYPE(AWAE_HighWindGrid) , DIMENSION(:), ALLOCATABLE  :: Vamb_High      !< UVW components of ambient wind across each high-resolution domain around a turbine (one for each turbine) for each high-resolution time step within a low-resolution time step [m/s]
    LOGICAL , DIMENSION(:,:), ALLOCATABLE  :: parallelFlag      !<  [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: r_s      !<  [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: r_e      !<  [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: rhat_s      !<  [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: rhat_e      !<  [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: pvec_cs      !<  [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: pvec_ce      !<  [-]
    REAL(SiKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: outVizXYPlane      !< An array holding the output data for a 2D visualization slice [-]
    REAL(SiKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: outVizYZPlane      !< An array holding the output data for a 2D visualization slice [-]
    REAL(SiKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: outVizXZPlane      !< An array holding the output data for a 2D visualization slice [-]
    TYPE(InflowWind_MiscVarType) , DIMENSION(:), ALLOCATABLE  :: IfW      !< InflowWind module misc vars [-]
    TYPE(InflowWind_InputType)  :: u_IfW_Low      !< InflowWind module inputs for the low-resolution grid [-]
    TYPE(InflowWind_InputType)  :: u_IfW_High      !< InflowWind module inputs for the high-resolution grid [-]
    TYPE(InflowWind_OutputType)  :: y_IfW_Low      !< InflowWind module outputs for the low-resolution grid [-]
    TYPE(InflowWind_OutputType)  :: y_IfW_High      !< InflowWind module outputs for the high-resolution grid [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: V_amb_low_disk      !< Rotor averaged ambiend wind speed for each wind turbine (3 x nWT) [m/s]
  END TYPE AWAE_MiscVarType
! =======================
! =========  AWAE_ParameterType  =======
  TYPE, PUBLIC :: AWAE_ParameterType
    CHARACTER(1024)  :: WindFilePath      !< Path name to the Root folder containing the wind data files from ABLSolver precursor [-]
    INTEGER(IntKi)  :: NumTurbines = 0_IntKi      !< Number of wind turbines in the farm [>=1] [-]
    INTEGER(IntKi)  :: NumRadii = 0_IntKi      !< Number of radii in the radial finite-difference grid  [>=2] [-]
    INTEGER(IntKi)  :: NumPlanes = 0_IntKi      !< Number of wake planes downwind of the rotor where the wake is propagated [>=2] [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: y      !< Horizontal discretization of the wake planes [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: z      !< Vertical discretization of the wake planes [m]
    INTEGER(IntKi)  :: Mod_AmbWind = 0_IntKi      !< Ambient wind model {1: high-fidelity precursor in VTK format, 2: InflowWind module} [-]
    INTEGER(IntKi)  :: nX_low = 0_IntKi      !< Number of low-resolution spatial nodes in X direction [-]
    INTEGER(IntKi)  :: nY_low = 0_IntKi      !< Number of low-resolution spatial nodes in Y direction [-]
    INTEGER(IntKi)  :: nZ_low = 0_IntKi      !< Number of low-resolution spatial nodes in Z direction [-]
    INTEGER(IntKi)  :: NumGrid_low = 0_IntKi      !< Total number of low-resolution spatial nodes [-]
    INTEGER(IntKi)  :: n_rp_max = 0_IntKi      !< Maximum possible number of points in the polar grid for the wake plane at each rotor [-]
    REAL(ReKi)  :: dpol = 0.0_ReKi      !< Spatial resolution of the polar grid for each wake plane of each turbine [m]
    REAL(ReKi) , DIMENSION(1:3)  :: dXYZ_low = 0.0_ReKi      !< XYZ-components of the spatial increment of the low-resolution domain [m]
    REAL(ReKi)  :: dX_low = 0.0_ReKi      !< The spacing of the low-resolution nodes in X direction [m]
    REAL(ReKi)  :: dY_low = 0.0_ReKi      !< The spacing of the low-resolution nodes in Y direction [m]
    REAL(ReKi)  :: dZ_low = 0.0_ReKi      !< The spacing of the low-resolution nodes in Z direction [m]
    REAL(ReKi)  :: X0_low = 0.0_ReKi      !< X-component of the origin of the low-resolution spatial domain [m]
    REAL(ReKi)  :: Y0_low = 0.0_ReKi      !< Y-component of the origin of the low-resolution spatial domain [m]
    REAL(ReKi)  :: Z0_low = 0.0_ReKi      !< Z-component of the origin of the low-resolution spatial domain [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: X0_high      !< X-component of the origin of the high-resolution spatial domain for each turbine [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Y0_high      !< Y-component of the origin of the high-resolution spatial domain for each turbine [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Z0_high      !< Z-component of the origin of the high-resolution spatial domain for each turbine [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: dX_high      !< X-component of the spatial increment of the high-resolution spatial domain for each turbine [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: dY_high      !< Y-component of the spatial increment of the high-resolution spatial domain for each turbine [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: dZ_high      !< Z-component of the spatial increment of the high-resolution spatial domain for each turbine [m]
    INTEGER(IntKi)  :: nX_high = 0_IntKi      !< Number of high-resolution spatial nodes in X direction  [-]
    INTEGER(IntKi)  :: nY_high = 0_IntKi      !< Number of high-resolution spatial nodes in Y direction [-]
    INTEGER(IntKi)  :: nZ_high = 0_IntKi      !< Number of high-resolution spatial nodes in Z direction [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Grid_low      !< XYZ components (global positions) of the spatial discretization of the low-resolution spatial domain [m]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Grid_high      !< XYZ components (global positions) of the spatial discretization of the high-resolution spatial domain for each turbine  [m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: WT_Position      !< X-Y-Z position of each wind turbine; index 1 = XYZ; index 2 = turbine number [meters]
    INTEGER(IntKi)  :: n_high_low = 0_IntKi      !< Number of high-resolution time steps per low [-]
    REAL(DbKi)  :: dt_low = 0.0_R8Ki      !< Low-resolution (FAST.Farm driver/glue code) time step [s]
    REAL(DbKi)  :: dt_high = 0.0_R8Ki      !< High-resolution (FAST) time step [s]
    INTEGER(IntKi)  :: NumDT = 0_IntKi      !< Number of low-resolution (FAST.Farm driver/glue code) time steps [-]
    INTEGER(IntKi)  :: Mod_Meander = 0_IntKi      !< Spatial filter model for wake meandering [-]
    REAL(ReKi)  :: C_Meander = 0.0_ReKi      !< Calibrated parameter for wake meandering [-]
    REAL(ReKi)  :: C_ScaleDiam = 0.0_ReKi      !< Normalized wake volume radius for wake meandering (normalized by the wake diameter) [-]
    INTEGER(IntKi)  :: Mod_Projection = 0_IntKi      !< Switch to select how the wake plane velocity is projected in AWAE {1: keep all components, 2: project against plane normal} or DEFAULT [DEFAULT=1: if Mod_Wake is 1 or 3, or DEFAULT=2: if Mod_Wake is 2] [-]
    TYPE(InflowWind_ParameterType) , DIMENSION(:), ALLOCATABLE  :: IfW      !< InflowWind module parameters [-]
    INTEGER(IntKi)  :: WrDisSkp1 = 0_IntKi      !< Number of time steps to skip plus one [-]
    LOGICAL  :: WrDisWind = .false.      !< Write disturbed wind data to <WindFilePath>/Low/Dis.t<n>.vtk etc.? [-]
    INTEGER(IntKi)  :: NOutDisWindXY = 0_IntKi      !< Number of XY planes for output of disturbed wind data across the low-resolution domain to <WindFilePath>/Low/DisXY.<n_out>.t<n>.vtk [0 to 9] [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: OutDisWindZ      !< Z coordinates of XY planes for output of disturbed wind data across the low-resolution domain [1 to NOutDisWindXY] [meters]
    INTEGER(IntKi)  :: NOutDisWindYZ = 0_IntKi      !< Number of YZ planes for output of disturbed wind data across the low-resolution domain to <WindFilePath>/Low/DisYZ.<n_out>.t<n>.vtk [0 to 9] [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: OutDisWindX      !< X coordinates of YZ planes for output of disturbed wind data across the low-resolution domain [1 to NOutDisWindYZ] [meters]
    INTEGER(IntKi)  :: NOutDisWindXZ = 0_IntKi      !< Number of XZ planes for output of disturbed wind data across the low-resolution domain to <WindFilePath>/Low/DisXZ.<n_out>.t<n>.vtk [0 to 9] [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: OutDisWindY      !< Y coordinates of XZ planes for output of disturbed wind data across the low-resolution domain [1 to NOutDisWindXZ] [meters]
    CHARACTER(1024)  :: OutFileRoot      !< The root name derived from the primary FAST.Farm input file [-]
    CHARACTER(1024)  :: OutFileVTKRoot      !< The root name for VTK outputs [-]
    INTEGER(IntKi)  :: VTK_tWidth = 0_IntKi      !< Number of characters for VTK timestamp outputs [-]
    LOGICAL  :: WAT_Enabled = .false.      !< Switch for turning on and off wake-added turbulence [-]
    TYPE(FlowFieldType) , POINTER :: WAT_FlowField => NULL()      !< Pointer to the InflowWinds flow field data type [-]
  END TYPE AWAE_ParameterType
! =======================
! =========  AWAE_OutputType  =======
  TYPE, PUBLIC :: AWAE_OutputType
    TYPE(AWAE_HighWindGrid) , DIMENSION(:), ALLOCATABLE  :: Vdist_High      !< Wind velocity of disturbed wind (ambient + wakes) across each high-resolution domain around a turbine for each high-resolution step within a low-resolution step [m/s]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: V_plane      !< Advection, deflection, and meandering velocity of wake planes for each turbine [m/s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TI_amb      !< Ambient turbulence intensity of wind at rotor disk for each turbine [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Vx_wind_disk      !< Rotor-disk-averaged ambient wind speed, normal to disk, for each turbine [m/s]
  END TYPE AWAE_OutputType
! =======================
! =========  AWAE_InputType  =======
  TYPE, PUBLIC :: AWAE_InputType
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: xhat_plane      !< Orientations of wake planes, normal to wake planes, for each turbine [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: p_plane      !< Center positions of wake planes for each turbine [m]
    REAL(ReKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: Vx_wake      !< Axial wake velocity deficit at wake planes, distributed across the plane, for each turbine (ny,nz,np,nWT) [m/s]
    REAL(ReKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: Vy_wake      !< Transverse horizonal wake velocity deficit at wake planes, distributed across the plane, for each turbine (ny,nz,np,nWT) [m/s]
    REAL(ReKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: Vz_wake      !< Transverse nominally vertical wake velocity deficit at wake planes, distributed across the plane, for each turbine (ny,nz,np,nWT) [m/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: D_wake      !< Wake diameters at wake planes for each turbine [m]
    REAL(ReKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: WAT_k      !< Scaling factor for each wake plane and turbine (ny, nz, np, nWT) [-]
  END TYPE AWAE_InputType
! =======================
CONTAINS

subroutine AWAE_CopyHighWindGrid(SrcHighWindGridData, DstHighWindGridData, CtrlCode, ErrStat, ErrMsg)
   type(AWAE_HighWindGrid), intent(in) :: SrcHighWindGridData
   type(AWAE_HighWindGrid), intent(inout) :: DstHighWindGridData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(5), UB(5)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'AWAE_CopyHighWindGrid'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (associated(SrcHighWindGridData%data)) then
      LB(1:5) = lbound(SrcHighWindGridData%data)
      UB(1:5) = ubound(SrcHighWindGridData%data)
      if (.not. associated(DstHighWindGridData%data)) then
         allocate(DstHighWindGridData%data(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4),LB(5):UB(5)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstHighWindGridData%data.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstHighWindGridData%data = SrcHighWindGridData%data
   end if
end subroutine

subroutine AWAE_DestroyHighWindGrid(HighWindGridData, ErrStat, ErrMsg)
   type(AWAE_HighWindGrid), intent(inout) :: HighWindGridData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AWAE_DestroyHighWindGrid'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (associated(HighWindGridData%data)) then
      deallocate(HighWindGridData%data)
      HighWindGridData%data => null()
   end if
end subroutine

subroutine AWAE_PackHighWindGrid(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AWAE_HighWindGrid), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AWAE_PackHighWindGrid'
   logical         :: PtrInIndex
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackPtr(RF, InData%data)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AWAE_UnPackHighWindGrid(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AWAE_HighWindGrid), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AWAE_UnPackHighWindGrid'
   integer(B4Ki)   :: LB(5), UB(5)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   integer(B8Ki)   :: PtrIdx
   type(c_ptr)     :: Ptr
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackPtr(RF, OutData%data, LB, UB); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AWAE_CopyHighWindGridPtr(SrcHighWindGridPtrData, DstHighWindGridPtrData, CtrlCode, ErrStat, ErrMsg)
   type(AWAE_HighWindGridPtr), intent(in) :: SrcHighWindGridPtrData
   type(AWAE_HighWindGridPtr), intent(inout) :: DstHighWindGridPtrData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(5), UB(5)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'AWAE_CopyHighWindGridPtr'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstHighWindGridPtrData%data => SrcHighWindGridPtrData%data
end subroutine

subroutine AWAE_DestroyHighWindGridPtr(HighWindGridPtrData, ErrStat, ErrMsg)
   type(AWAE_HighWindGridPtr), intent(inout) :: HighWindGridPtrData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AWAE_DestroyHighWindGridPtr'
   ErrStat = ErrID_None
   ErrMsg  = ''
   nullify(HighWindGridPtrData%data)
end subroutine

subroutine AWAE_PackHighWindGridPtr(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AWAE_HighWindGridPtr), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AWAE_PackHighWindGridPtr'
   logical         :: PtrInIndex
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackPtr(RF, InData%data)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AWAE_UnPackHighWindGridPtr(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AWAE_HighWindGridPtr), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AWAE_UnPackHighWindGridPtr'
   integer(B4Ki)   :: LB(5), UB(5)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   integer(B8Ki)   :: PtrIdx
   type(c_ptr)     :: Ptr
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackPtr(RF, OutData%data, LB, UB); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AWAE_CopyInputFileType(SrcInputFileTypeData, DstInputFileTypeData, CtrlCode, ErrStat, ErrMsg)
   type(AWAE_InputFileType), intent(in) :: SrcInputFileTypeData
   type(AWAE_InputFileType), intent(inout) :: DstInputFileTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'AWAE_CopyInputFileType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInputFileTypeData%dr = SrcInputFileTypeData%dr
   DstInputFileTypeData%dt_low = SrcInputFileTypeData%dt_low
   DstInputFileTypeData%NumTurbines = SrcInputFileTypeData%NumTurbines
   DstInputFileTypeData%NumRadii = SrcInputFileTypeData%NumRadii
   DstInputFileTypeData%NumPlanes = SrcInputFileTypeData%NumPlanes
   DstInputFileTypeData%WindFilePath = SrcInputFileTypeData%WindFilePath
   DstInputFileTypeData%WrDisWind = SrcInputFileTypeData%WrDisWind
   DstInputFileTypeData%NOutDisWindXY = SrcInputFileTypeData%NOutDisWindXY
   if (allocated(SrcInputFileTypeData%OutDisWindZ)) then
      LB(1:1) = lbound(SrcInputFileTypeData%OutDisWindZ)
      UB(1:1) = ubound(SrcInputFileTypeData%OutDisWindZ)
      if (.not. allocated(DstInputFileTypeData%OutDisWindZ)) then
         allocate(DstInputFileTypeData%OutDisWindZ(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileTypeData%OutDisWindZ.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileTypeData%OutDisWindZ = SrcInputFileTypeData%OutDisWindZ
   end if
   DstInputFileTypeData%NOutDisWindYZ = SrcInputFileTypeData%NOutDisWindYZ
   if (allocated(SrcInputFileTypeData%OutDisWindX)) then
      LB(1:1) = lbound(SrcInputFileTypeData%OutDisWindX)
      UB(1:1) = ubound(SrcInputFileTypeData%OutDisWindX)
      if (.not. allocated(DstInputFileTypeData%OutDisWindX)) then
         allocate(DstInputFileTypeData%OutDisWindX(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileTypeData%OutDisWindX.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileTypeData%OutDisWindX = SrcInputFileTypeData%OutDisWindX
   end if
   DstInputFileTypeData%NOutDisWindXZ = SrcInputFileTypeData%NOutDisWindXZ
   if (allocated(SrcInputFileTypeData%OutDisWindY)) then
      LB(1:1) = lbound(SrcInputFileTypeData%OutDisWindY)
      UB(1:1) = ubound(SrcInputFileTypeData%OutDisWindY)
      if (.not. allocated(DstInputFileTypeData%OutDisWindY)) then
         allocate(DstInputFileTypeData%OutDisWindY(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileTypeData%OutDisWindY.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileTypeData%OutDisWindY = SrcInputFileTypeData%OutDisWindY
   end if
   DstInputFileTypeData%WrDisDT = SrcInputFileTypeData%WrDisDT
   DstInputFileTypeData%ChkWndFiles = SrcInputFileTypeData%ChkWndFiles
   DstInputFileTypeData%Mod_Meander = SrcInputFileTypeData%Mod_Meander
   DstInputFileTypeData%C_Meander = SrcInputFileTypeData%C_Meander
   DstInputFileTypeData%Mod_AmbWind = SrcInputFileTypeData%Mod_AmbWind
   DstInputFileTypeData%InflowFile = SrcInputFileTypeData%InflowFile
   DstInputFileTypeData%dt_high = SrcInputFileTypeData%dt_high
   if (allocated(SrcInputFileTypeData%X0_high)) then
      LB(1:1) = lbound(SrcInputFileTypeData%X0_high)
      UB(1:1) = ubound(SrcInputFileTypeData%X0_high)
      if (.not. allocated(DstInputFileTypeData%X0_high)) then
         allocate(DstInputFileTypeData%X0_high(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileTypeData%X0_high.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileTypeData%X0_high = SrcInputFileTypeData%X0_high
   end if
   if (allocated(SrcInputFileTypeData%Y0_high)) then
      LB(1:1) = lbound(SrcInputFileTypeData%Y0_high)
      UB(1:1) = ubound(SrcInputFileTypeData%Y0_high)
      if (.not. allocated(DstInputFileTypeData%Y0_high)) then
         allocate(DstInputFileTypeData%Y0_high(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileTypeData%Y0_high.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileTypeData%Y0_high = SrcInputFileTypeData%Y0_high
   end if
   if (allocated(SrcInputFileTypeData%Z0_high)) then
      LB(1:1) = lbound(SrcInputFileTypeData%Z0_high)
      UB(1:1) = ubound(SrcInputFileTypeData%Z0_high)
      if (.not. allocated(DstInputFileTypeData%Z0_high)) then
         allocate(DstInputFileTypeData%Z0_high(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileTypeData%Z0_high.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileTypeData%Z0_high = SrcInputFileTypeData%Z0_high
   end if
   if (allocated(SrcInputFileTypeData%dX_high)) then
      LB(1:1) = lbound(SrcInputFileTypeData%dX_high)
      UB(1:1) = ubound(SrcInputFileTypeData%dX_high)
      if (.not. allocated(DstInputFileTypeData%dX_high)) then
         allocate(DstInputFileTypeData%dX_high(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileTypeData%dX_high.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileTypeData%dX_high = SrcInputFileTypeData%dX_high
   end if
   if (allocated(SrcInputFileTypeData%dY_high)) then
      LB(1:1) = lbound(SrcInputFileTypeData%dY_high)
      UB(1:1) = ubound(SrcInputFileTypeData%dY_high)
      if (.not. allocated(DstInputFileTypeData%dY_high)) then
         allocate(DstInputFileTypeData%dY_high(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileTypeData%dY_high.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileTypeData%dY_high = SrcInputFileTypeData%dY_high
   end if
   if (allocated(SrcInputFileTypeData%dZ_high)) then
      LB(1:1) = lbound(SrcInputFileTypeData%dZ_high)
      UB(1:1) = ubound(SrcInputFileTypeData%dZ_high)
      if (.not. allocated(DstInputFileTypeData%dZ_high)) then
         allocate(DstInputFileTypeData%dZ_high(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileTypeData%dZ_high.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileTypeData%dZ_high = SrcInputFileTypeData%dZ_high
   end if
   DstInputFileTypeData%nX_high = SrcInputFileTypeData%nX_high
   DstInputFileTypeData%nY_high = SrcInputFileTypeData%nY_high
   DstInputFileTypeData%nZ_high = SrcInputFileTypeData%nZ_high
   DstInputFileTypeData%dX_low = SrcInputFileTypeData%dX_low
   DstInputFileTypeData%dY_low = SrcInputFileTypeData%dY_low
   DstInputFileTypeData%dZ_low = SrcInputFileTypeData%dZ_low
   DstInputFileTypeData%nX_low = SrcInputFileTypeData%nX_low
   DstInputFileTypeData%nY_low = SrcInputFileTypeData%nY_low
   DstInputFileTypeData%nZ_low = SrcInputFileTypeData%nZ_low
   DstInputFileTypeData%X0_low = SrcInputFileTypeData%X0_low
   DstInputFileTypeData%Y0_low = SrcInputFileTypeData%Y0_low
   DstInputFileTypeData%Z0_low = SrcInputFileTypeData%Z0_low
   if (allocated(SrcInputFileTypeData%WT_Position)) then
      LB(1:2) = lbound(SrcInputFileTypeData%WT_Position)
      UB(1:2) = ubound(SrcInputFileTypeData%WT_Position)
      if (.not. allocated(DstInputFileTypeData%WT_Position)) then
         allocate(DstInputFileTypeData%WT_Position(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileTypeData%WT_Position.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileTypeData%WT_Position = SrcInputFileTypeData%WT_Position
   end if
   DstInputFileTypeData%Mod_Projection = SrcInputFileTypeData%Mod_Projection
end subroutine

subroutine AWAE_DestroyInputFileType(InputFileTypeData, ErrStat, ErrMsg)
   type(AWAE_InputFileType), intent(inout) :: InputFileTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AWAE_DestroyInputFileType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InputFileTypeData%OutDisWindZ)) then
      deallocate(InputFileTypeData%OutDisWindZ)
   end if
   if (allocated(InputFileTypeData%OutDisWindX)) then
      deallocate(InputFileTypeData%OutDisWindX)
   end if
   if (allocated(InputFileTypeData%OutDisWindY)) then
      deallocate(InputFileTypeData%OutDisWindY)
   end if
   if (allocated(InputFileTypeData%X0_high)) then
      deallocate(InputFileTypeData%X0_high)
   end if
   if (allocated(InputFileTypeData%Y0_high)) then
      deallocate(InputFileTypeData%Y0_high)
   end if
   if (allocated(InputFileTypeData%Z0_high)) then
      deallocate(InputFileTypeData%Z0_high)
   end if
   if (allocated(InputFileTypeData%dX_high)) then
      deallocate(InputFileTypeData%dX_high)
   end if
   if (allocated(InputFileTypeData%dY_high)) then
      deallocate(InputFileTypeData%dY_high)
   end if
   if (allocated(InputFileTypeData%dZ_high)) then
      deallocate(InputFileTypeData%dZ_high)
   end if
   if (allocated(InputFileTypeData%WT_Position)) then
      deallocate(InputFileTypeData%WT_Position)
   end if
end subroutine

subroutine AWAE_PackInputFileType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AWAE_InputFileType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AWAE_PackInputFileType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%dr)
   call RegPack(RF, InData%dt_low)
   call RegPack(RF, InData%NumTurbines)
   call RegPack(RF, InData%NumRadii)
   call RegPack(RF, InData%NumPlanes)
   call RegPack(RF, InData%WindFilePath)
   call RegPack(RF, InData%WrDisWind)
   call RegPack(RF, InData%NOutDisWindXY)
   call RegPackAlloc(RF, InData%OutDisWindZ)
   call RegPack(RF, InData%NOutDisWindYZ)
   call RegPackAlloc(RF, InData%OutDisWindX)
   call RegPack(RF, InData%NOutDisWindXZ)
   call RegPackAlloc(RF, InData%OutDisWindY)
   call RegPack(RF, InData%WrDisDT)
   call RegPack(RF, InData%ChkWndFiles)
   call RegPack(RF, InData%Mod_Meander)
   call RegPack(RF, InData%C_Meander)
   call RegPack(RF, InData%Mod_AmbWind)
   call RegPack(RF, InData%InflowFile)
   call RegPack(RF, InData%dt_high)
   call RegPackAlloc(RF, InData%X0_high)
   call RegPackAlloc(RF, InData%Y0_high)
   call RegPackAlloc(RF, InData%Z0_high)
   call RegPackAlloc(RF, InData%dX_high)
   call RegPackAlloc(RF, InData%dY_high)
   call RegPackAlloc(RF, InData%dZ_high)
   call RegPack(RF, InData%nX_high)
   call RegPack(RF, InData%nY_high)
   call RegPack(RF, InData%nZ_high)
   call RegPack(RF, InData%dX_low)
   call RegPack(RF, InData%dY_low)
   call RegPack(RF, InData%dZ_low)
   call RegPack(RF, InData%nX_low)
   call RegPack(RF, InData%nY_low)
   call RegPack(RF, InData%nZ_low)
   call RegPack(RF, InData%X0_low)
   call RegPack(RF, InData%Y0_low)
   call RegPack(RF, InData%Z0_low)
   call RegPackAlloc(RF, InData%WT_Position)
   call RegPack(RF, InData%Mod_Projection)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AWAE_UnPackInputFileType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AWAE_InputFileType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AWAE_UnPackInputFileType'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%dr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dt_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumTurbines); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumRadii); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumPlanes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WindFilePath); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WrDisWind); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NOutDisWindXY); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%OutDisWindZ); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NOutDisWindYZ); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%OutDisWindX); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NOutDisWindXZ); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%OutDisWindY); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WrDisDT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ChkWndFiles); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Mod_Meander); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_Meander); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Mod_AmbWind); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%InflowFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dt_high); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%X0_high); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Y0_high); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Z0_high); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%dX_high); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%dY_high); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%dZ_high); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nX_high); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nY_high); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nZ_high); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dX_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dY_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dZ_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nX_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nY_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nZ_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%X0_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Y0_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Z0_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WT_Position); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Mod_Projection); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AWAE_CopyInitInput(SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg)
   type(AWAE_InitInputType), intent(in) :: SrcInitInputData
   type(AWAE_InitInputType), intent(inout) :: DstInitInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(0), UB(0)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AWAE_CopyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call AWAE_CopyInputFileType(SrcInitInputData%InputFileData, DstInitInputData%InputFileData, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstInitInputData%n_high_low = SrcInitInputData%n_high_low
   DstInitInputData%NumDT = SrcInitInputData%NumDT
   DstInitInputData%OutFileRoot = SrcInitInputData%OutFileRoot
   DstInitInputData%WAT_Enabled = SrcInitInputData%WAT_Enabled
   DstInitInputData%WAT_FlowField => SrcInitInputData%WAT_FlowField
end subroutine

subroutine AWAE_DestroyInitInput(InitInputData, ErrStat, ErrMsg)
   type(AWAE_InitInputType), intent(inout) :: InitInputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AWAE_DestroyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call AWAE_DestroyInputFileType(InitInputData%InputFileData, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   nullify(InitInputData%WAT_FlowField)
end subroutine

subroutine AWAE_PackInitInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AWAE_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AWAE_PackInitInput'
   logical         :: PtrInIndex
   if (RF%ErrStat >= AbortErrLev) return
   call AWAE_PackInputFileType(RF, InData%InputFileData) 
   call RegPack(RF, InData%n_high_low)
   call RegPack(RF, InData%NumDT)
   call RegPack(RF, InData%OutFileRoot)
   call RegPack(RF, InData%WAT_Enabled)
   call RegPack(RF, associated(InData%WAT_FlowField))
   if (associated(InData%WAT_FlowField)) then
      call RegPackPointer(RF, c_loc(InData%WAT_FlowField), PtrInIndex)
      if (.not. PtrInIndex) then
         call IfW_FlowField_PackFlowFieldType(RF, InData%WAT_FlowField) 
      end if
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AWAE_UnPackInitInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AWAE_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AWAE_UnPackInitInput'
   integer(B4Ki)   :: LB(0), UB(0)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   integer(B8Ki)   :: PtrIdx
   type(c_ptr)     :: Ptr
   if (RF%ErrStat /= ErrID_None) return
   call AWAE_UnpackInputFileType(RF, OutData%InputFileData) ! InputFileData 
   call RegUnpack(RF, OutData%n_high_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumDT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutFileRoot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WAT_Enabled); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%WAT_FlowField)) deallocate(OutData%WAT_FlowField)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackPointer(RF, Ptr, PtrIdx); if (RegCheckErr(RF, RoutineName)) return
      if (c_associated(Ptr)) then
         call c_f_pointer(Ptr, OutData%WAT_FlowField)
      else
         allocate(OutData%WAT_FlowField,stat=stat)
         if (stat /= 0) then 
            call SetErrStat(ErrID_Fatal, 'Error allocating OutData%WAT_FlowField.', RF%ErrStat, RF%ErrMsg, RoutineName)
            return
         end if
         RF%Pointers(PtrIdx) = c_loc(OutData%WAT_FlowField)
         call IfW_FlowField_UnpackFlowFieldType(RF, OutData%WAT_FlowField) ! WAT_FlowField 
      end if
   else
      OutData%WAT_FlowField => null()
   end if
end subroutine

subroutine AWAE_CopyInitOutput(SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg)
   type(AWAE_InitOutputType), intent(in) :: SrcInitOutputData
   type(AWAE_InitOutputType), intent(inout) :: DstInitOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AWAE_CopyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call NWTC_Library_CopyProgDesc(SrcInitOutputData%Ver, DstInitOutputData%Ver, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcInitOutputData%X0_high)) then
      LB(1:1) = lbound(SrcInitOutputData%X0_high)
      UB(1:1) = ubound(SrcInitOutputData%X0_high)
      if (.not. allocated(DstInitOutputData%X0_high)) then
         allocate(DstInitOutputData%X0_high(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%X0_high.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%X0_high = SrcInitOutputData%X0_high
   end if
   if (allocated(SrcInitOutputData%Y0_high)) then
      LB(1:1) = lbound(SrcInitOutputData%Y0_high)
      UB(1:1) = ubound(SrcInitOutputData%Y0_high)
      if (.not. allocated(DstInitOutputData%Y0_high)) then
         allocate(DstInitOutputData%Y0_high(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%Y0_high.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%Y0_high = SrcInitOutputData%Y0_high
   end if
   if (allocated(SrcInitOutputData%Z0_high)) then
      LB(1:1) = lbound(SrcInitOutputData%Z0_high)
      UB(1:1) = ubound(SrcInitOutputData%Z0_high)
      if (.not. allocated(DstInitOutputData%Z0_high)) then
         allocate(DstInitOutputData%Z0_high(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%Z0_high.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%Z0_high = SrcInitOutputData%Z0_high
   end if
   if (allocated(SrcInitOutputData%dX_high)) then
      LB(1:1) = lbound(SrcInitOutputData%dX_high)
      UB(1:1) = ubound(SrcInitOutputData%dX_high)
      if (.not. allocated(DstInitOutputData%dX_high)) then
         allocate(DstInitOutputData%dX_high(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%dX_high.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%dX_high = SrcInitOutputData%dX_high
   end if
   if (allocated(SrcInitOutputData%dY_high)) then
      LB(1:1) = lbound(SrcInitOutputData%dY_high)
      UB(1:1) = ubound(SrcInitOutputData%dY_high)
      if (.not. allocated(DstInitOutputData%dY_high)) then
         allocate(DstInitOutputData%dY_high(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%dY_high.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%dY_high = SrcInitOutputData%dY_high
   end if
   if (allocated(SrcInitOutputData%dZ_high)) then
      LB(1:1) = lbound(SrcInitOutputData%dZ_high)
      UB(1:1) = ubound(SrcInitOutputData%dZ_high)
      if (.not. allocated(DstInitOutputData%dZ_high)) then
         allocate(DstInitOutputData%dZ_high(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%dZ_high.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%dZ_high = SrcInitOutputData%dZ_high
   end if
   DstInitOutputData%nX_high = SrcInitOutputData%nX_high
   DstInitOutputData%nY_high = SrcInitOutputData%nY_high
   DstInitOutputData%nZ_high = SrcInitOutputData%nZ_high
   DstInitOutputData%dX_low = SrcInitOutputData%dX_low
   DstInitOutputData%dY_low = SrcInitOutputData%dY_low
   DstInitOutputData%dZ_low = SrcInitOutputData%dZ_low
   DstInitOutputData%nX_low = SrcInitOutputData%nX_low
   DstInitOutputData%nY_low = SrcInitOutputData%nY_low
   DstInitOutputData%nZ_low = SrcInitOutputData%nZ_low
   DstInitOutputData%X0_low = SrcInitOutputData%X0_low
   DstInitOutputData%Y0_low = SrcInitOutputData%Y0_low
   DstInitOutputData%Z0_low = SrcInitOutputData%Z0_low
   if (allocated(SrcInitOutputData%Vdist_High)) then
      LB(1:1) = lbound(SrcInitOutputData%Vdist_High)
      UB(1:1) = ubound(SrcInitOutputData%Vdist_High)
      if (.not. allocated(DstInitOutputData%Vdist_High)) then
         allocate(DstInitOutputData%Vdist_High(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%Vdist_High.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call AWAE_CopyHighWindGridPtr(SrcInitOutputData%Vdist_High(i1), DstInitOutputData%Vdist_High(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
end subroutine

subroutine AWAE_DestroyInitOutput(InitOutputData, ErrStat, ErrMsg)
   type(AWAE_InitOutputType), intent(inout) :: InitOutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AWAE_DestroyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call NWTC_Library_DestroyProgDesc(InitOutputData%Ver, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(InitOutputData%X0_high)) then
      deallocate(InitOutputData%X0_high)
   end if
   if (allocated(InitOutputData%Y0_high)) then
      deallocate(InitOutputData%Y0_high)
   end if
   if (allocated(InitOutputData%Z0_high)) then
      deallocate(InitOutputData%Z0_high)
   end if
   if (allocated(InitOutputData%dX_high)) then
      deallocate(InitOutputData%dX_high)
   end if
   if (allocated(InitOutputData%dY_high)) then
      deallocate(InitOutputData%dY_high)
   end if
   if (allocated(InitOutputData%dZ_high)) then
      deallocate(InitOutputData%dZ_high)
   end if
   if (allocated(InitOutputData%Vdist_High)) then
      LB(1:1) = lbound(InitOutputData%Vdist_High)
      UB(1:1) = ubound(InitOutputData%Vdist_High)
      do i1 = LB(1), UB(1)
         call AWAE_DestroyHighWindGridPtr(InitOutputData%Vdist_High(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InitOutputData%Vdist_High)
   end if
end subroutine

subroutine AWAE_PackInitOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AWAE_InitOutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AWAE_PackInitOutput'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call NWTC_Library_PackProgDesc(RF, InData%Ver) 
   call RegPackAlloc(RF, InData%X0_high)
   call RegPackAlloc(RF, InData%Y0_high)
   call RegPackAlloc(RF, InData%Z0_high)
   call RegPackAlloc(RF, InData%dX_high)
   call RegPackAlloc(RF, InData%dY_high)
   call RegPackAlloc(RF, InData%dZ_high)
   call RegPack(RF, InData%nX_high)
   call RegPack(RF, InData%nY_high)
   call RegPack(RF, InData%nZ_high)
   call RegPack(RF, InData%dX_low)
   call RegPack(RF, InData%dY_low)
   call RegPack(RF, InData%dZ_low)
   call RegPack(RF, InData%nX_low)
   call RegPack(RF, InData%nY_low)
   call RegPack(RF, InData%nZ_low)
   call RegPack(RF, InData%X0_low)
   call RegPack(RF, InData%Y0_low)
   call RegPack(RF, InData%Z0_low)
   call RegPack(RF, allocated(InData%Vdist_High))
   if (allocated(InData%Vdist_High)) then
      call RegPackBounds(RF, 1, lbound(InData%Vdist_High), ubound(InData%Vdist_High))
      LB(1:1) = lbound(InData%Vdist_High)
      UB(1:1) = ubound(InData%Vdist_High)
      do i1 = LB(1), UB(1)
         call AWAE_PackHighWindGridPtr(RF, InData%Vdist_High(i1)) 
      end do
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AWAE_UnPackInitOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AWAE_InitOutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AWAE_UnPackInitOutput'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call NWTC_Library_UnpackProgDesc(RF, OutData%Ver) ! Ver 
   call RegUnpackAlloc(RF, OutData%X0_high); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Y0_high); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Z0_high); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%dX_high); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%dY_high); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%dZ_high); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nX_high); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nY_high); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nZ_high); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dX_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dY_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dZ_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nX_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nY_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nZ_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%X0_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Y0_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Z0_low); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%Vdist_High)) deallocate(OutData%Vdist_High)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Vdist_High(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Vdist_High.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call AWAE_UnpackHighWindGridPtr(RF, OutData%Vdist_High(i1)) ! Vdist_High 
      end do
   end if
end subroutine

subroutine AWAE_CopyContState(SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg)
   type(AWAE_ContinuousStateType), intent(in) :: SrcContStateData
   type(AWAE_ContinuousStateType), intent(inout) :: DstContStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AWAE_CopyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcContStateData%IfW)) then
      LB(1:1) = lbound(SrcContStateData%IfW)
      UB(1:1) = ubound(SrcContStateData%IfW)
      if (.not. allocated(DstContStateData%IfW)) then
         allocate(DstContStateData%IfW(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstContStateData%IfW.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call InflowWind_CopyContState(SrcContStateData%IfW(i1), DstContStateData%IfW(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
end subroutine

subroutine AWAE_DestroyContState(ContStateData, ErrStat, ErrMsg)
   type(AWAE_ContinuousStateType), intent(inout) :: ContStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AWAE_DestroyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ContStateData%IfW)) then
      LB(1:1) = lbound(ContStateData%IfW)
      UB(1:1) = ubound(ContStateData%IfW)
      do i1 = LB(1), UB(1)
         call InflowWind_DestroyContState(ContStateData%IfW(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ContStateData%IfW)
   end if
end subroutine

subroutine AWAE_PackContState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AWAE_ContinuousStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AWAE_PackContState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%IfW))
   if (allocated(InData%IfW)) then
      call RegPackBounds(RF, 1, lbound(InData%IfW), ubound(InData%IfW))
      LB(1:1) = lbound(InData%IfW)
      UB(1:1) = ubound(InData%IfW)
      do i1 = LB(1), UB(1)
         call InflowWind_PackContState(RF, InData%IfW(i1)) 
      end do
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AWAE_UnPackContState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AWAE_ContinuousStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AWAE_UnPackContState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%IfW)) deallocate(OutData%IfW)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%IfW(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%IfW.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call InflowWind_UnpackContState(RF, OutData%IfW(i1)) ! IfW 
      end do
   end if
end subroutine

subroutine AWAE_CopyDiscState(SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg)
   type(AWAE_DiscreteStateType), intent(in) :: SrcDiscStateData
   type(AWAE_DiscreteStateType), intent(inout) :: DstDiscStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AWAE_CopyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcDiscStateData%IfW)) then
      LB(1:1) = lbound(SrcDiscStateData%IfW)
      UB(1:1) = ubound(SrcDiscStateData%IfW)
      if (.not. allocated(DstDiscStateData%IfW)) then
         allocate(DstDiscStateData%IfW(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%IfW.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call InflowWind_CopyDiscState(SrcDiscStateData%IfW(i1), DstDiscStateData%IfW(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstDiscStateData%WAT_B_Box = SrcDiscStateData%WAT_B_Box
   DstDiscStateData%Ufarm = SrcDiscStateData%Ufarm
end subroutine

subroutine AWAE_DestroyDiscState(DiscStateData, ErrStat, ErrMsg)
   type(AWAE_DiscreteStateType), intent(inout) :: DiscStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AWAE_DestroyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(DiscStateData%IfW)) then
      LB(1:1) = lbound(DiscStateData%IfW)
      UB(1:1) = ubound(DiscStateData%IfW)
      do i1 = LB(1), UB(1)
         call InflowWind_DestroyDiscState(DiscStateData%IfW(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(DiscStateData%IfW)
   end if
end subroutine

subroutine AWAE_PackDiscState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AWAE_DiscreteStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AWAE_PackDiscState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%IfW))
   if (allocated(InData%IfW)) then
      call RegPackBounds(RF, 1, lbound(InData%IfW), ubound(InData%IfW))
      LB(1:1) = lbound(InData%IfW)
      UB(1:1) = ubound(InData%IfW)
      do i1 = LB(1), UB(1)
         call InflowWind_PackDiscState(RF, InData%IfW(i1)) 
      end do
   end if
   call RegPack(RF, InData%WAT_B_Box)
   call RegPack(RF, InData%Ufarm)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AWAE_UnPackDiscState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AWAE_DiscreteStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AWAE_UnPackDiscState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%IfW)) deallocate(OutData%IfW)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%IfW(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%IfW.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call InflowWind_UnpackDiscState(RF, OutData%IfW(i1)) ! IfW 
      end do
   end if
   call RegUnpack(RF, OutData%WAT_B_Box); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Ufarm); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AWAE_CopyConstrState(SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg)
   type(AWAE_ConstraintStateType), intent(in) :: SrcConstrStateData
   type(AWAE_ConstraintStateType), intent(inout) :: DstConstrStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AWAE_CopyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcConstrStateData%IfW)) then
      LB(1:1) = lbound(SrcConstrStateData%IfW)
      UB(1:1) = ubound(SrcConstrStateData%IfW)
      if (.not. allocated(DstConstrStateData%IfW)) then
         allocate(DstConstrStateData%IfW(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstConstrStateData%IfW.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call InflowWind_CopyConstrState(SrcConstrStateData%IfW(i1), DstConstrStateData%IfW(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
end subroutine

subroutine AWAE_DestroyConstrState(ConstrStateData, ErrStat, ErrMsg)
   type(AWAE_ConstraintStateType), intent(inout) :: ConstrStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AWAE_DestroyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ConstrStateData%IfW)) then
      LB(1:1) = lbound(ConstrStateData%IfW)
      UB(1:1) = ubound(ConstrStateData%IfW)
      do i1 = LB(1), UB(1)
         call InflowWind_DestroyConstrState(ConstrStateData%IfW(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ConstrStateData%IfW)
   end if
end subroutine

subroutine AWAE_PackConstrState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AWAE_ConstraintStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AWAE_PackConstrState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%IfW))
   if (allocated(InData%IfW)) then
      call RegPackBounds(RF, 1, lbound(InData%IfW), ubound(InData%IfW))
      LB(1:1) = lbound(InData%IfW)
      UB(1:1) = ubound(InData%IfW)
      do i1 = LB(1), UB(1)
         call InflowWind_PackConstrState(RF, InData%IfW(i1)) 
      end do
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AWAE_UnPackConstrState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AWAE_ConstraintStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AWAE_UnPackConstrState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%IfW)) deallocate(OutData%IfW)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%IfW(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%IfW.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call InflowWind_UnpackConstrState(RF, OutData%IfW(i1)) ! IfW 
      end do
   end if
end subroutine

subroutine AWAE_CopyOtherState(SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg)
   type(AWAE_OtherStateType), intent(in) :: SrcOtherStateData
   type(AWAE_OtherStateType), intent(inout) :: DstOtherStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AWAE_CopyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcOtherStateData%IfW)) then
      LB(1:1) = lbound(SrcOtherStateData%IfW)
      UB(1:1) = ubound(SrcOtherStateData%IfW)
      if (.not. allocated(DstOtherStateData%IfW)) then
         allocate(DstOtherStateData%IfW(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%IfW.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call InflowWind_CopyOtherState(SrcOtherStateData%IfW(i1), DstOtherStateData%IfW(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
end subroutine

subroutine AWAE_DestroyOtherState(OtherStateData, ErrStat, ErrMsg)
   type(AWAE_OtherStateType), intent(inout) :: OtherStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AWAE_DestroyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(OtherStateData%IfW)) then
      LB(1:1) = lbound(OtherStateData%IfW)
      UB(1:1) = ubound(OtherStateData%IfW)
      do i1 = LB(1), UB(1)
         call InflowWind_DestroyOtherState(OtherStateData%IfW(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(OtherStateData%IfW)
   end if
end subroutine

subroutine AWAE_PackOtherState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AWAE_OtherStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AWAE_PackOtherState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%IfW))
   if (allocated(InData%IfW)) then
      call RegPackBounds(RF, 1, lbound(InData%IfW), ubound(InData%IfW))
      LB(1:1) = lbound(InData%IfW)
      UB(1:1) = ubound(InData%IfW)
      do i1 = LB(1), UB(1)
         call InflowWind_PackOtherState(RF, InData%IfW(i1)) 
      end do
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AWAE_UnPackOtherState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AWAE_OtherStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AWAE_UnPackOtherState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%IfW)) deallocate(OutData%IfW)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%IfW(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%IfW.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call InflowWind_UnpackOtherState(RF, OutData%IfW(i1)) ! IfW 
      end do
   end if
end subroutine

subroutine AWAE_CopyMisc(SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg)
   type(AWAE_MiscVarType), intent(in) :: SrcMiscData
   type(AWAE_MiscVarType), intent(inout) :: DstMiscData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2, i3, i4
   integer(B4Ki)                  :: LB(4), UB(4)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AWAE_CopyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcMiscData%Vamb_low)) then
      LB(1:4) = lbound(SrcMiscData%Vamb_low)
      UB(1:4) = ubound(SrcMiscData%Vamb_low)
      if (.not. allocated(DstMiscData%Vamb_low)) then
         allocate(DstMiscData%Vamb_low(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%Vamb_low.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%Vamb_low = SrcMiscData%Vamb_low
   end if
   if (allocated(SrcMiscData%Vamb_lowpol)) then
      LB(1:2) = lbound(SrcMiscData%Vamb_lowpol)
      UB(1:2) = ubound(SrcMiscData%Vamb_lowpol)
      if (.not. allocated(DstMiscData%Vamb_lowpol)) then
         allocate(DstMiscData%Vamb_lowpol(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%Vamb_lowpol.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%Vamb_lowpol = SrcMiscData%Vamb_lowpol
   end if
   if (allocated(SrcMiscData%Vdist_low)) then
      LB(1:4) = lbound(SrcMiscData%Vdist_low)
      UB(1:4) = ubound(SrcMiscData%Vdist_low)
      if (.not. allocated(DstMiscData%Vdist_low)) then
         allocate(DstMiscData%Vdist_low(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%Vdist_low.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%Vdist_low = SrcMiscData%Vdist_low
   end if
   if (allocated(SrcMiscData%Vdist_low_full)) then
      LB(1:4) = lbound(SrcMiscData%Vdist_low_full)
      UB(1:4) = ubound(SrcMiscData%Vdist_low_full)
      if (.not. allocated(DstMiscData%Vdist_low_full)) then
         allocate(DstMiscData%Vdist_low_full(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%Vdist_low_full.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%Vdist_low_full = SrcMiscData%Vdist_low_full
   end if
   if (allocated(SrcMiscData%Vamb_High)) then
      LB(1:1) = lbound(SrcMiscData%Vamb_High)
      UB(1:1) = ubound(SrcMiscData%Vamb_High)
      if (.not. allocated(DstMiscData%Vamb_High)) then
         allocate(DstMiscData%Vamb_High(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%Vamb_High.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call AWAE_CopyHighWindGrid(SrcMiscData%Vamb_High(i1), DstMiscData%Vamb_High(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcMiscData%parallelFlag)) then
      LB(1:2) = lbound(SrcMiscData%parallelFlag)
      UB(1:2) = ubound(SrcMiscData%parallelFlag)
      if (.not. allocated(DstMiscData%parallelFlag)) then
         allocate(DstMiscData%parallelFlag(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%parallelFlag.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%parallelFlag = SrcMiscData%parallelFlag
   end if
   if (allocated(SrcMiscData%r_s)) then
      LB(1:2) = lbound(SrcMiscData%r_s)
      UB(1:2) = ubound(SrcMiscData%r_s)
      if (.not. allocated(DstMiscData%r_s)) then
         allocate(DstMiscData%r_s(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%r_s.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%r_s = SrcMiscData%r_s
   end if
   if (allocated(SrcMiscData%r_e)) then
      LB(1:2) = lbound(SrcMiscData%r_e)
      UB(1:2) = ubound(SrcMiscData%r_e)
      if (.not. allocated(DstMiscData%r_e)) then
         allocate(DstMiscData%r_e(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%r_e.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%r_e = SrcMiscData%r_e
   end if
   if (allocated(SrcMiscData%rhat_s)) then
      LB(1:3) = lbound(SrcMiscData%rhat_s)
      UB(1:3) = ubound(SrcMiscData%rhat_s)
      if (.not. allocated(DstMiscData%rhat_s)) then
         allocate(DstMiscData%rhat_s(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%rhat_s.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%rhat_s = SrcMiscData%rhat_s
   end if
   if (allocated(SrcMiscData%rhat_e)) then
      LB(1:3) = lbound(SrcMiscData%rhat_e)
      UB(1:3) = ubound(SrcMiscData%rhat_e)
      if (.not. allocated(DstMiscData%rhat_e)) then
         allocate(DstMiscData%rhat_e(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%rhat_e.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%rhat_e = SrcMiscData%rhat_e
   end if
   if (allocated(SrcMiscData%pvec_cs)) then
      LB(1:3) = lbound(SrcMiscData%pvec_cs)
      UB(1:3) = ubound(SrcMiscData%pvec_cs)
      if (.not. allocated(DstMiscData%pvec_cs)) then
         allocate(DstMiscData%pvec_cs(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%pvec_cs.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%pvec_cs = SrcMiscData%pvec_cs
   end if
   if (allocated(SrcMiscData%pvec_ce)) then
      LB(1:3) = lbound(SrcMiscData%pvec_ce)
      UB(1:3) = ubound(SrcMiscData%pvec_ce)
      if (.not. allocated(DstMiscData%pvec_ce)) then
         allocate(DstMiscData%pvec_ce(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%pvec_ce.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%pvec_ce = SrcMiscData%pvec_ce
   end if
   if (allocated(SrcMiscData%outVizXYPlane)) then
      LB(1:4) = lbound(SrcMiscData%outVizXYPlane)
      UB(1:4) = ubound(SrcMiscData%outVizXYPlane)
      if (.not. allocated(DstMiscData%outVizXYPlane)) then
         allocate(DstMiscData%outVizXYPlane(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%outVizXYPlane.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%outVizXYPlane = SrcMiscData%outVizXYPlane
   end if
   if (allocated(SrcMiscData%outVizYZPlane)) then
      LB(1:4) = lbound(SrcMiscData%outVizYZPlane)
      UB(1:4) = ubound(SrcMiscData%outVizYZPlane)
      if (.not. allocated(DstMiscData%outVizYZPlane)) then
         allocate(DstMiscData%outVizYZPlane(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%outVizYZPlane.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%outVizYZPlane = SrcMiscData%outVizYZPlane
   end if
   if (allocated(SrcMiscData%outVizXZPlane)) then
      LB(1:4) = lbound(SrcMiscData%outVizXZPlane)
      UB(1:4) = ubound(SrcMiscData%outVizXZPlane)
      if (.not. allocated(DstMiscData%outVizXZPlane)) then
         allocate(DstMiscData%outVizXZPlane(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%outVizXZPlane.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%outVizXZPlane = SrcMiscData%outVizXZPlane
   end if
   if (allocated(SrcMiscData%IfW)) then
      LB(1:1) = lbound(SrcMiscData%IfW)
      UB(1:1) = ubound(SrcMiscData%IfW)
      if (.not. allocated(DstMiscData%IfW)) then
         allocate(DstMiscData%IfW(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%IfW.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call InflowWind_CopyMisc(SrcMiscData%IfW(i1), DstMiscData%IfW(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call InflowWind_CopyInput(SrcMiscData%u_IfW_Low, DstMiscData%u_IfW_Low, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call InflowWind_CopyInput(SrcMiscData%u_IfW_High, DstMiscData%u_IfW_High, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call InflowWind_CopyOutput(SrcMiscData%y_IfW_Low, DstMiscData%y_IfW_Low, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call InflowWind_CopyOutput(SrcMiscData%y_IfW_High, DstMiscData%y_IfW_High, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcMiscData%V_amb_low_disk)) then
      LB(1:2) = lbound(SrcMiscData%V_amb_low_disk)
      UB(1:2) = ubound(SrcMiscData%V_amb_low_disk)
      if (.not. allocated(DstMiscData%V_amb_low_disk)) then
         allocate(DstMiscData%V_amb_low_disk(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%V_amb_low_disk.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%V_amb_low_disk = SrcMiscData%V_amb_low_disk
   end if
end subroutine

subroutine AWAE_DestroyMisc(MiscData, ErrStat, ErrMsg)
   type(AWAE_MiscVarType), intent(inout) :: MiscData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2, i3, i4
   integer(B4Ki)   :: LB(4), UB(4)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AWAE_DestroyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(MiscData%Vamb_low)) then
      deallocate(MiscData%Vamb_low)
   end if
   if (allocated(MiscData%Vamb_lowpol)) then
      deallocate(MiscData%Vamb_lowpol)
   end if
   if (allocated(MiscData%Vdist_low)) then
      deallocate(MiscData%Vdist_low)
   end if
   if (allocated(MiscData%Vdist_low_full)) then
      deallocate(MiscData%Vdist_low_full)
   end if
   if (allocated(MiscData%Vamb_High)) then
      LB(1:1) = lbound(MiscData%Vamb_High)
      UB(1:1) = ubound(MiscData%Vamb_High)
      do i1 = LB(1), UB(1)
         call AWAE_DestroyHighWindGrid(MiscData%Vamb_High(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MiscData%Vamb_High)
   end if
   if (allocated(MiscData%parallelFlag)) then
      deallocate(MiscData%parallelFlag)
   end if
   if (allocated(MiscData%r_s)) then
      deallocate(MiscData%r_s)
   end if
   if (allocated(MiscData%r_e)) then
      deallocate(MiscData%r_e)
   end if
   if (allocated(MiscData%rhat_s)) then
      deallocate(MiscData%rhat_s)
   end if
   if (allocated(MiscData%rhat_e)) then
      deallocate(MiscData%rhat_e)
   end if
   if (allocated(MiscData%pvec_cs)) then
      deallocate(MiscData%pvec_cs)
   end if
   if (allocated(MiscData%pvec_ce)) then
      deallocate(MiscData%pvec_ce)
   end if
   if (allocated(MiscData%outVizXYPlane)) then
      deallocate(MiscData%outVizXYPlane)
   end if
   if (allocated(MiscData%outVizYZPlane)) then
      deallocate(MiscData%outVizYZPlane)
   end if
   if (allocated(MiscData%outVizXZPlane)) then
      deallocate(MiscData%outVizXZPlane)
   end if
   if (allocated(MiscData%IfW)) then
      LB(1:1) = lbound(MiscData%IfW)
      UB(1:1) = ubound(MiscData%IfW)
      do i1 = LB(1), UB(1)
         call InflowWind_DestroyMisc(MiscData%IfW(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MiscData%IfW)
   end if
   call InflowWind_DestroyInput(MiscData%u_IfW_Low, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call InflowWind_DestroyInput(MiscData%u_IfW_High, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call InflowWind_DestroyOutput(MiscData%y_IfW_Low, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call InflowWind_DestroyOutput(MiscData%y_IfW_High, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(MiscData%V_amb_low_disk)) then
      deallocate(MiscData%V_amb_low_disk)
   end if
end subroutine

subroutine AWAE_PackMisc(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AWAE_MiscVarType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AWAE_PackMisc'
   integer(B4Ki)   :: i1, i2, i3, i4
   integer(B4Ki)   :: LB(4), UB(4)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%Vamb_low)
   call RegPackAlloc(RF, InData%Vamb_lowpol)
   call RegPackAlloc(RF, InData%Vdist_low)
   call RegPackAlloc(RF, InData%Vdist_low_full)
   call RegPack(RF, allocated(InData%Vamb_High))
   if (allocated(InData%Vamb_High)) then
      call RegPackBounds(RF, 1, lbound(InData%Vamb_High), ubound(InData%Vamb_High))
      LB(1:1) = lbound(InData%Vamb_High)
      UB(1:1) = ubound(InData%Vamb_High)
      do i1 = LB(1), UB(1)
         call AWAE_PackHighWindGrid(RF, InData%Vamb_High(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%parallelFlag)
   call RegPackAlloc(RF, InData%r_s)
   call RegPackAlloc(RF, InData%r_e)
   call RegPackAlloc(RF, InData%rhat_s)
   call RegPackAlloc(RF, InData%rhat_e)
   call RegPackAlloc(RF, InData%pvec_cs)
   call RegPackAlloc(RF, InData%pvec_ce)
   call RegPackAlloc(RF, InData%outVizXYPlane)
   call RegPackAlloc(RF, InData%outVizYZPlane)
   call RegPackAlloc(RF, InData%outVizXZPlane)
   call RegPack(RF, allocated(InData%IfW))
   if (allocated(InData%IfW)) then
      call RegPackBounds(RF, 1, lbound(InData%IfW), ubound(InData%IfW))
      LB(1:1) = lbound(InData%IfW)
      UB(1:1) = ubound(InData%IfW)
      do i1 = LB(1), UB(1)
         call InflowWind_PackMisc(RF, InData%IfW(i1)) 
      end do
   end if
   call InflowWind_PackInput(RF, InData%u_IfW_Low) 
   call InflowWind_PackInput(RF, InData%u_IfW_High) 
   call InflowWind_PackOutput(RF, InData%y_IfW_Low) 
   call InflowWind_PackOutput(RF, InData%y_IfW_High) 
   call RegPackAlloc(RF, InData%V_amb_low_disk)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AWAE_UnPackMisc(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AWAE_MiscVarType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AWAE_UnPackMisc'
   integer(B4Ki)   :: i1, i2, i3, i4
   integer(B4Ki)   :: LB(4), UB(4)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%Vamb_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Vamb_lowpol); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Vdist_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Vdist_low_full); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%Vamb_High)) deallocate(OutData%Vamb_High)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Vamb_High(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Vamb_High.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call AWAE_UnpackHighWindGrid(RF, OutData%Vamb_High(i1)) ! Vamb_High 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%parallelFlag); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%r_s); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%r_e); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%rhat_s); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%rhat_e); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%pvec_cs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%pvec_ce); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%outVizXYPlane); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%outVizYZPlane); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%outVizXZPlane); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%IfW)) deallocate(OutData%IfW)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%IfW(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%IfW.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call InflowWind_UnpackMisc(RF, OutData%IfW(i1)) ! IfW 
      end do
   end if
   call InflowWind_UnpackInput(RF, OutData%u_IfW_Low) ! u_IfW_Low 
   call InflowWind_UnpackInput(RF, OutData%u_IfW_High) ! u_IfW_High 
   call InflowWind_UnpackOutput(RF, OutData%y_IfW_Low) ! y_IfW_Low 
   call InflowWind_UnpackOutput(RF, OutData%y_IfW_High) ! y_IfW_High 
   call RegUnpackAlloc(RF, OutData%V_amb_low_disk); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AWAE_CopyParam(SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg)
   type(AWAE_ParameterType), intent(in) :: SrcParamData
   type(AWAE_ParameterType), intent(inout) :: DstParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AWAE_CopyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstParamData%WindFilePath = SrcParamData%WindFilePath
   DstParamData%NumTurbines = SrcParamData%NumTurbines
   DstParamData%NumRadii = SrcParamData%NumRadii
   DstParamData%NumPlanes = SrcParamData%NumPlanes
   if (allocated(SrcParamData%y)) then
      LB(1:1) = lbound(SrcParamData%y)
      UB(1:1) = ubound(SrcParamData%y)
      if (.not. allocated(DstParamData%y)) then
         allocate(DstParamData%y(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%y.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%y = SrcParamData%y
   end if
   if (allocated(SrcParamData%z)) then
      LB(1:1) = lbound(SrcParamData%z)
      UB(1:1) = ubound(SrcParamData%z)
      if (.not. allocated(DstParamData%z)) then
         allocate(DstParamData%z(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%z.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%z = SrcParamData%z
   end if
   DstParamData%Mod_AmbWind = SrcParamData%Mod_AmbWind
   DstParamData%nX_low = SrcParamData%nX_low
   DstParamData%nY_low = SrcParamData%nY_low
   DstParamData%nZ_low = SrcParamData%nZ_low
   DstParamData%NumGrid_low = SrcParamData%NumGrid_low
   DstParamData%n_rp_max = SrcParamData%n_rp_max
   DstParamData%dpol = SrcParamData%dpol
   DstParamData%dXYZ_low = SrcParamData%dXYZ_low
   DstParamData%dX_low = SrcParamData%dX_low
   DstParamData%dY_low = SrcParamData%dY_low
   DstParamData%dZ_low = SrcParamData%dZ_low
   DstParamData%X0_low = SrcParamData%X0_low
   DstParamData%Y0_low = SrcParamData%Y0_low
   DstParamData%Z0_low = SrcParamData%Z0_low
   if (allocated(SrcParamData%X0_high)) then
      LB(1:1) = lbound(SrcParamData%X0_high)
      UB(1:1) = ubound(SrcParamData%X0_high)
      if (.not. allocated(DstParamData%X0_high)) then
         allocate(DstParamData%X0_high(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%X0_high.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%X0_high = SrcParamData%X0_high
   end if
   if (allocated(SrcParamData%Y0_high)) then
      LB(1:1) = lbound(SrcParamData%Y0_high)
      UB(1:1) = ubound(SrcParamData%Y0_high)
      if (.not. allocated(DstParamData%Y0_high)) then
         allocate(DstParamData%Y0_high(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Y0_high.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Y0_high = SrcParamData%Y0_high
   end if
   if (allocated(SrcParamData%Z0_high)) then
      LB(1:1) = lbound(SrcParamData%Z0_high)
      UB(1:1) = ubound(SrcParamData%Z0_high)
      if (.not. allocated(DstParamData%Z0_high)) then
         allocate(DstParamData%Z0_high(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Z0_high.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Z0_high = SrcParamData%Z0_high
   end if
   if (allocated(SrcParamData%dX_high)) then
      LB(1:1) = lbound(SrcParamData%dX_high)
      UB(1:1) = ubound(SrcParamData%dX_high)
      if (.not. allocated(DstParamData%dX_high)) then
         allocate(DstParamData%dX_high(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%dX_high.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%dX_high = SrcParamData%dX_high
   end if
   if (allocated(SrcParamData%dY_high)) then
      LB(1:1) = lbound(SrcParamData%dY_high)
      UB(1:1) = ubound(SrcParamData%dY_high)
      if (.not. allocated(DstParamData%dY_high)) then
         allocate(DstParamData%dY_high(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%dY_high.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%dY_high = SrcParamData%dY_high
   end if
   if (allocated(SrcParamData%dZ_high)) then
      LB(1:1) = lbound(SrcParamData%dZ_high)
      UB(1:1) = ubound(SrcParamData%dZ_high)
      if (.not. allocated(DstParamData%dZ_high)) then
         allocate(DstParamData%dZ_high(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%dZ_high.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%dZ_high = SrcParamData%dZ_high
   end if
   DstParamData%nX_high = SrcParamData%nX_high
   DstParamData%nY_high = SrcParamData%nY_high
   DstParamData%nZ_high = SrcParamData%nZ_high
   if (allocated(SrcParamData%Grid_low)) then
      LB(1:2) = lbound(SrcParamData%Grid_low)
      UB(1:2) = ubound(SrcParamData%Grid_low)
      if (.not. allocated(DstParamData%Grid_low)) then
         allocate(DstParamData%Grid_low(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Grid_low.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Grid_low = SrcParamData%Grid_low
   end if
   if (allocated(SrcParamData%Grid_high)) then
      LB(1:3) = lbound(SrcParamData%Grid_high)
      UB(1:3) = ubound(SrcParamData%Grid_high)
      if (.not. allocated(DstParamData%Grid_high)) then
         allocate(DstParamData%Grid_high(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Grid_high.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Grid_high = SrcParamData%Grid_high
   end if
   if (allocated(SrcParamData%WT_Position)) then
      LB(1:2) = lbound(SrcParamData%WT_Position)
      UB(1:2) = ubound(SrcParamData%WT_Position)
      if (.not. allocated(DstParamData%WT_Position)) then
         allocate(DstParamData%WT_Position(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%WT_Position.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%WT_Position = SrcParamData%WT_Position
   end if
   DstParamData%n_high_low = SrcParamData%n_high_low
   DstParamData%dt_low = SrcParamData%dt_low
   DstParamData%dt_high = SrcParamData%dt_high
   DstParamData%NumDT = SrcParamData%NumDT
   DstParamData%Mod_Meander = SrcParamData%Mod_Meander
   DstParamData%C_Meander = SrcParamData%C_Meander
   DstParamData%C_ScaleDiam = SrcParamData%C_ScaleDiam
   DstParamData%Mod_Projection = SrcParamData%Mod_Projection
   if (allocated(SrcParamData%IfW)) then
      LB(1:1) = lbound(SrcParamData%IfW)
      UB(1:1) = ubound(SrcParamData%IfW)
      if (.not. allocated(DstParamData%IfW)) then
         allocate(DstParamData%IfW(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%IfW.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call InflowWind_CopyParam(SrcParamData%IfW(i1), DstParamData%IfW(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstParamData%WrDisSkp1 = SrcParamData%WrDisSkp1
   DstParamData%WrDisWind = SrcParamData%WrDisWind
   DstParamData%NOutDisWindXY = SrcParamData%NOutDisWindXY
   if (allocated(SrcParamData%OutDisWindZ)) then
      LB(1:1) = lbound(SrcParamData%OutDisWindZ)
      UB(1:1) = ubound(SrcParamData%OutDisWindZ)
      if (.not. allocated(DstParamData%OutDisWindZ)) then
         allocate(DstParamData%OutDisWindZ(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%OutDisWindZ.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%OutDisWindZ = SrcParamData%OutDisWindZ
   end if
   DstParamData%NOutDisWindYZ = SrcParamData%NOutDisWindYZ
   if (allocated(SrcParamData%OutDisWindX)) then
      LB(1:1) = lbound(SrcParamData%OutDisWindX)
      UB(1:1) = ubound(SrcParamData%OutDisWindX)
      if (.not. allocated(DstParamData%OutDisWindX)) then
         allocate(DstParamData%OutDisWindX(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%OutDisWindX.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%OutDisWindX = SrcParamData%OutDisWindX
   end if
   DstParamData%NOutDisWindXZ = SrcParamData%NOutDisWindXZ
   if (allocated(SrcParamData%OutDisWindY)) then
      LB(1:1) = lbound(SrcParamData%OutDisWindY)
      UB(1:1) = ubound(SrcParamData%OutDisWindY)
      if (.not. allocated(DstParamData%OutDisWindY)) then
         allocate(DstParamData%OutDisWindY(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%OutDisWindY.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%OutDisWindY = SrcParamData%OutDisWindY
   end if
   DstParamData%OutFileRoot = SrcParamData%OutFileRoot
   DstParamData%OutFileVTKRoot = SrcParamData%OutFileVTKRoot
   DstParamData%VTK_tWidth = SrcParamData%VTK_tWidth
   DstParamData%WAT_Enabled = SrcParamData%WAT_Enabled
   DstParamData%WAT_FlowField => SrcParamData%WAT_FlowField
end subroutine

subroutine AWAE_DestroyParam(ParamData, ErrStat, ErrMsg)
   type(AWAE_ParameterType), intent(inout) :: ParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AWAE_DestroyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ParamData%y)) then
      deallocate(ParamData%y)
   end if
   if (allocated(ParamData%z)) then
      deallocate(ParamData%z)
   end if
   if (allocated(ParamData%X0_high)) then
      deallocate(ParamData%X0_high)
   end if
   if (allocated(ParamData%Y0_high)) then
      deallocate(ParamData%Y0_high)
   end if
   if (allocated(ParamData%Z0_high)) then
      deallocate(ParamData%Z0_high)
   end if
   if (allocated(ParamData%dX_high)) then
      deallocate(ParamData%dX_high)
   end if
   if (allocated(ParamData%dY_high)) then
      deallocate(ParamData%dY_high)
   end if
   if (allocated(ParamData%dZ_high)) then
      deallocate(ParamData%dZ_high)
   end if
   if (allocated(ParamData%Grid_low)) then
      deallocate(ParamData%Grid_low)
   end if
   if (allocated(ParamData%Grid_high)) then
      deallocate(ParamData%Grid_high)
   end if
   if (allocated(ParamData%WT_Position)) then
      deallocate(ParamData%WT_Position)
   end if
   if (allocated(ParamData%IfW)) then
      LB(1:1) = lbound(ParamData%IfW)
      UB(1:1) = ubound(ParamData%IfW)
      do i1 = LB(1), UB(1)
         call InflowWind_DestroyParam(ParamData%IfW(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%IfW)
   end if
   if (allocated(ParamData%OutDisWindZ)) then
      deallocate(ParamData%OutDisWindZ)
   end if
   if (allocated(ParamData%OutDisWindX)) then
      deallocate(ParamData%OutDisWindX)
   end if
   if (allocated(ParamData%OutDisWindY)) then
      deallocate(ParamData%OutDisWindY)
   end if
   nullify(ParamData%WAT_FlowField)
end subroutine

subroutine AWAE_PackParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AWAE_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AWAE_PackParam'
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)   :: LB(3), UB(3)
   logical         :: PtrInIndex
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%WindFilePath)
   call RegPack(RF, InData%NumTurbines)
   call RegPack(RF, InData%NumRadii)
   call RegPack(RF, InData%NumPlanes)
   call RegPackAlloc(RF, InData%y)
   call RegPackAlloc(RF, InData%z)
   call RegPack(RF, InData%Mod_AmbWind)
   call RegPack(RF, InData%nX_low)
   call RegPack(RF, InData%nY_low)
   call RegPack(RF, InData%nZ_low)
   call RegPack(RF, InData%NumGrid_low)
   call RegPack(RF, InData%n_rp_max)
   call RegPack(RF, InData%dpol)
   call RegPack(RF, InData%dXYZ_low)
   call RegPack(RF, InData%dX_low)
   call RegPack(RF, InData%dY_low)
   call RegPack(RF, InData%dZ_low)
   call RegPack(RF, InData%X0_low)
   call RegPack(RF, InData%Y0_low)
   call RegPack(RF, InData%Z0_low)
   call RegPackAlloc(RF, InData%X0_high)
   call RegPackAlloc(RF, InData%Y0_high)
   call RegPackAlloc(RF, InData%Z0_high)
   call RegPackAlloc(RF, InData%dX_high)
   call RegPackAlloc(RF, InData%dY_high)
   call RegPackAlloc(RF, InData%dZ_high)
   call RegPack(RF, InData%nX_high)
   call RegPack(RF, InData%nY_high)
   call RegPack(RF, InData%nZ_high)
   call RegPackAlloc(RF, InData%Grid_low)
   call RegPackAlloc(RF, InData%Grid_high)
   call RegPackAlloc(RF, InData%WT_Position)
   call RegPack(RF, InData%n_high_low)
   call RegPack(RF, InData%dt_low)
   call RegPack(RF, InData%dt_high)
   call RegPack(RF, InData%NumDT)
   call RegPack(RF, InData%Mod_Meander)
   call RegPack(RF, InData%C_Meander)
   call RegPack(RF, InData%C_ScaleDiam)
   call RegPack(RF, InData%Mod_Projection)
   call RegPack(RF, allocated(InData%IfW))
   if (allocated(InData%IfW)) then
      call RegPackBounds(RF, 1, lbound(InData%IfW), ubound(InData%IfW))
      LB(1:1) = lbound(InData%IfW)
      UB(1:1) = ubound(InData%IfW)
      do i1 = LB(1), UB(1)
         call InflowWind_PackParam(RF, InData%IfW(i1)) 
      end do
   end if
   call RegPack(RF, InData%WrDisSkp1)
   call RegPack(RF, InData%WrDisWind)
   call RegPack(RF, InData%NOutDisWindXY)
   call RegPackAlloc(RF, InData%OutDisWindZ)
   call RegPack(RF, InData%NOutDisWindYZ)
   call RegPackAlloc(RF, InData%OutDisWindX)
   call RegPack(RF, InData%NOutDisWindXZ)
   call RegPackAlloc(RF, InData%OutDisWindY)
   call RegPack(RF, InData%OutFileRoot)
   call RegPack(RF, InData%OutFileVTKRoot)
   call RegPack(RF, InData%VTK_tWidth)
   call RegPack(RF, InData%WAT_Enabled)
   call RegPack(RF, associated(InData%WAT_FlowField))
   if (associated(InData%WAT_FlowField)) then
      call RegPackPointer(RF, c_loc(InData%WAT_FlowField), PtrInIndex)
      if (.not. PtrInIndex) then
         call IfW_FlowField_PackFlowFieldType(RF, InData%WAT_FlowField) 
      end if
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AWAE_UnPackParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AWAE_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AWAE_UnPackParam'
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   integer(B8Ki)   :: PtrIdx
   type(c_ptr)     :: Ptr
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%WindFilePath); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumTurbines); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumRadii); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumPlanes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%z); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Mod_AmbWind); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nX_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nY_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nZ_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumGrid_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%n_rp_max); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dpol); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dXYZ_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dX_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dY_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dZ_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%X0_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Y0_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Z0_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%X0_high); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Y0_high); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Z0_high); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%dX_high); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%dY_high); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%dZ_high); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nX_high); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nY_high); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nZ_high); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Grid_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Grid_high); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WT_Position); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%n_high_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dt_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dt_high); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumDT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Mod_Meander); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_Meander); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_ScaleDiam); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Mod_Projection); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%IfW)) deallocate(OutData%IfW)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%IfW(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%IfW.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call InflowWind_UnpackParam(RF, OutData%IfW(i1)) ! IfW 
      end do
   end if
   call RegUnpack(RF, OutData%WrDisSkp1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WrDisWind); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NOutDisWindXY); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%OutDisWindZ); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NOutDisWindYZ); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%OutDisWindX); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NOutDisWindXZ); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%OutDisWindY); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutFileRoot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutFileVTKRoot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VTK_tWidth); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WAT_Enabled); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%WAT_FlowField)) deallocate(OutData%WAT_FlowField)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackPointer(RF, Ptr, PtrIdx); if (RegCheckErr(RF, RoutineName)) return
      if (c_associated(Ptr)) then
         call c_f_pointer(Ptr, OutData%WAT_FlowField)
      else
         allocate(OutData%WAT_FlowField,stat=stat)
         if (stat /= 0) then 
            call SetErrStat(ErrID_Fatal, 'Error allocating OutData%WAT_FlowField.', RF%ErrStat, RF%ErrMsg, RoutineName)
            return
         end if
         RF%Pointers(PtrIdx) = c_loc(OutData%WAT_FlowField)
         call IfW_FlowField_UnpackFlowFieldType(RF, OutData%WAT_FlowField) ! WAT_FlowField 
      end if
   else
      OutData%WAT_FlowField => null()
   end if
end subroutine

subroutine AWAE_CopyOutput(SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg)
   type(AWAE_OutputType), intent(in) :: SrcOutputData
   type(AWAE_OutputType), intent(inout) :: DstOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AWAE_CopyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcOutputData%Vdist_High)) then
      LB(1:1) = lbound(SrcOutputData%Vdist_High)
      UB(1:1) = ubound(SrcOutputData%Vdist_High)
      if (.not. allocated(DstOutputData%Vdist_High)) then
         allocate(DstOutputData%Vdist_High(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%Vdist_High.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call AWAE_CopyHighWindGrid(SrcOutputData%Vdist_High(i1), DstOutputData%Vdist_High(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcOutputData%V_plane)) then
      LB(1:3) = lbound(SrcOutputData%V_plane)
      UB(1:3) = ubound(SrcOutputData%V_plane)
      if (.not. allocated(DstOutputData%V_plane)) then
         allocate(DstOutputData%V_plane(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%V_plane.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%V_plane = SrcOutputData%V_plane
   end if
   if (allocated(SrcOutputData%TI_amb)) then
      LB(1:1) = lbound(SrcOutputData%TI_amb)
      UB(1:1) = ubound(SrcOutputData%TI_amb)
      if (.not. allocated(DstOutputData%TI_amb)) then
         allocate(DstOutputData%TI_amb(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%TI_amb.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%TI_amb = SrcOutputData%TI_amb
   end if
   if (allocated(SrcOutputData%Vx_wind_disk)) then
      LB(1:1) = lbound(SrcOutputData%Vx_wind_disk)
      UB(1:1) = ubound(SrcOutputData%Vx_wind_disk)
      if (.not. allocated(DstOutputData%Vx_wind_disk)) then
         allocate(DstOutputData%Vx_wind_disk(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%Vx_wind_disk.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%Vx_wind_disk = SrcOutputData%Vx_wind_disk
   end if
end subroutine

subroutine AWAE_DestroyOutput(OutputData, ErrStat, ErrMsg)
   type(AWAE_OutputType), intent(inout) :: OutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AWAE_DestroyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(OutputData%Vdist_High)) then
      LB(1:1) = lbound(OutputData%Vdist_High)
      UB(1:1) = ubound(OutputData%Vdist_High)
      do i1 = LB(1), UB(1)
         call AWAE_DestroyHighWindGrid(OutputData%Vdist_High(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(OutputData%Vdist_High)
   end if
   if (allocated(OutputData%V_plane)) then
      deallocate(OutputData%V_plane)
   end if
   if (allocated(OutputData%TI_amb)) then
      deallocate(OutputData%TI_amb)
   end if
   if (allocated(OutputData%Vx_wind_disk)) then
      deallocate(OutputData%Vx_wind_disk)
   end if
end subroutine

subroutine AWAE_PackOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AWAE_OutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AWAE_PackOutput'
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)   :: LB(3), UB(3)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%Vdist_High))
   if (allocated(InData%Vdist_High)) then
      call RegPackBounds(RF, 1, lbound(InData%Vdist_High), ubound(InData%Vdist_High))
      LB(1:1) = lbound(InData%Vdist_High)
      UB(1:1) = ubound(InData%Vdist_High)
      do i1 = LB(1), UB(1)
         call AWAE_PackHighWindGrid(RF, InData%Vdist_High(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%V_plane)
   call RegPackAlloc(RF, InData%TI_amb)
   call RegPackAlloc(RF, InData%Vx_wind_disk)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AWAE_UnPackOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AWAE_OutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AWAE_UnPackOutput'
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%Vdist_High)) deallocate(OutData%Vdist_High)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Vdist_High(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Vdist_High.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call AWAE_UnpackHighWindGrid(RF, OutData%Vdist_High(i1)) ! Vdist_High 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%V_plane); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TI_amb); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Vx_wind_disk); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AWAE_CopyInput(SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg)
   type(AWAE_InputType), intent(in) :: SrcInputData
   type(AWAE_InputType), intent(inout) :: DstInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(4), UB(4)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'AWAE_CopyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcInputData%xhat_plane)) then
      LB(1:3) = lbound(SrcInputData%xhat_plane)
      UB(1:3) = ubound(SrcInputData%xhat_plane)
      if (.not. allocated(DstInputData%xhat_plane)) then
         allocate(DstInputData%xhat_plane(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%xhat_plane.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%xhat_plane = SrcInputData%xhat_plane
   end if
   if (allocated(SrcInputData%p_plane)) then
      LB(1:3) = lbound(SrcInputData%p_plane)
      UB(1:3) = ubound(SrcInputData%p_plane)
      if (.not. allocated(DstInputData%p_plane)) then
         allocate(DstInputData%p_plane(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%p_plane.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%p_plane = SrcInputData%p_plane
   end if
   if (allocated(SrcInputData%Vx_wake)) then
      LB(1:4) = lbound(SrcInputData%Vx_wake)
      UB(1:4) = ubound(SrcInputData%Vx_wake)
      if (.not. allocated(DstInputData%Vx_wake)) then
         allocate(DstInputData%Vx_wake(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%Vx_wake.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%Vx_wake = SrcInputData%Vx_wake
   end if
   if (allocated(SrcInputData%Vy_wake)) then
      LB(1:4) = lbound(SrcInputData%Vy_wake)
      UB(1:4) = ubound(SrcInputData%Vy_wake)
      if (.not. allocated(DstInputData%Vy_wake)) then
         allocate(DstInputData%Vy_wake(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%Vy_wake.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%Vy_wake = SrcInputData%Vy_wake
   end if
   if (allocated(SrcInputData%Vz_wake)) then
      LB(1:4) = lbound(SrcInputData%Vz_wake)
      UB(1:4) = ubound(SrcInputData%Vz_wake)
      if (.not. allocated(DstInputData%Vz_wake)) then
         allocate(DstInputData%Vz_wake(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%Vz_wake.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%Vz_wake = SrcInputData%Vz_wake
   end if
   if (allocated(SrcInputData%D_wake)) then
      LB(1:2) = lbound(SrcInputData%D_wake)
      UB(1:2) = ubound(SrcInputData%D_wake)
      if (.not. allocated(DstInputData%D_wake)) then
         allocate(DstInputData%D_wake(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%D_wake.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%D_wake = SrcInputData%D_wake
   end if
   if (allocated(SrcInputData%WAT_k)) then
      LB(1:4) = lbound(SrcInputData%WAT_k)
      UB(1:4) = ubound(SrcInputData%WAT_k)
      if (.not. allocated(DstInputData%WAT_k)) then
         allocate(DstInputData%WAT_k(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%WAT_k.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%WAT_k = SrcInputData%WAT_k
   end if
end subroutine

subroutine AWAE_DestroyInput(InputData, ErrStat, ErrMsg)
   type(AWAE_InputType), intent(inout) :: InputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AWAE_DestroyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InputData%xhat_plane)) then
      deallocate(InputData%xhat_plane)
   end if
   if (allocated(InputData%p_plane)) then
      deallocate(InputData%p_plane)
   end if
   if (allocated(InputData%Vx_wake)) then
      deallocate(InputData%Vx_wake)
   end if
   if (allocated(InputData%Vy_wake)) then
      deallocate(InputData%Vy_wake)
   end if
   if (allocated(InputData%Vz_wake)) then
      deallocate(InputData%Vz_wake)
   end if
   if (allocated(InputData%D_wake)) then
      deallocate(InputData%D_wake)
   end if
   if (allocated(InputData%WAT_k)) then
      deallocate(InputData%WAT_k)
   end if
end subroutine

subroutine AWAE_PackInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AWAE_InputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AWAE_PackInput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%xhat_plane)
   call RegPackAlloc(RF, InData%p_plane)
   call RegPackAlloc(RF, InData%Vx_wake)
   call RegPackAlloc(RF, InData%Vy_wake)
   call RegPackAlloc(RF, InData%Vz_wake)
   call RegPackAlloc(RF, InData%D_wake)
   call RegPackAlloc(RF, InData%WAT_k)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AWAE_UnPackInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AWAE_InputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AWAE_UnPackInput'
   integer(B4Ki)   :: LB(4), UB(4)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%xhat_plane); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%p_plane); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Vx_wake); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Vy_wake); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Vz_wake); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%D_wake); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WAT_k); if (RegCheckErr(RF, RoutineName)) return
end subroutine
END MODULE AWAE_Types
!ENDOFREGISTRYGENERATEDFILE
