!STARTOFREGISTRYGENERATEDFILE 'UnsteadyAero_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! UnsteadyAero_Types
!.................................................................................................................................
! This file is part of UnsteadyAero.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in UnsteadyAero. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE UnsteadyAero_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE AirfoilInfo_Types
USE NWTC_Library
IMPLICIT NONE
    INTEGER(IntKi), PUBLIC, PARAMETER  :: UA_Method_RK4 = 1      ! RK4 integration method [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: UA_Method_AB4 = 2      ! AB4 integration method [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: UA_Method_ABM4 = 3      ! ABM4 integration method [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: UA_Method_BDF2 = 4      ! BDF2 integration method [-]
! =========  UA_InitInputType  =======
  TYPE, PUBLIC :: UA_InitInputType
    REAL(DbKi)  :: dt = 0.0_R8Ki      !< time step [s]
    CHARACTER(1024)  :: OutRootName      !< Supplied by Driver:  The name of the root file (without extension) including the full path [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: c      !< Chord length at node [m]
    REAL(ReKi)  :: d_34_to_ac = 0.5      !< Distance from 3/4 chord to aerodynamic center (typically 0.5) in chord length (no dimension) [-]
    INTEGER(IntKi)  :: numBlades = 0_IntKi      !< Number nodes of all blades [-]
    INTEGER(IntKi)  :: nNodesPerBlade = 0_IntKi      !< Number nodes per blades [-]
    INTEGER(IntKi)  :: UAMod = 0_IntKi      !< Model for the dynamic stall equations [1 = Leishman/Beddoes, 2 = Gonzalez, 3 = Minnema] [-]
    REAL(ReKi)  :: a_s = 0.0_ReKi      !< speed of sound [m/s]
    LOGICAL  :: Flookup = .false.      !< Use table lookup for f' and f''  [-]
    LOGICAL  :: ShedEffect = .True.      !< Include the effect of shed vorticity. If False, the input alpha is assumed to already contain this effect (e.g. vortex methods) [-]
    LOGICAL  :: WrSum = .false.      !< Write UA AFI parameters to summary file? [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: UAOff_innerNode      !< Last node on each blade where UA should be turned off based on span location from blade root (0 if always on) [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: UAOff_outerNode      !< First node on each blade where UA should be turned off based on span location from blade tip (>nNodesPerBlade if always on) [-]
    INTEGER(IntKi)  :: UA_OUTS = 0      !< Store write outputs 0=None, 1=WriteOutpus, 2=WriteToFile [-]
    INTEGER(IntKi)  :: integrationMethod = 3      !< method to integrate states (default is 3=UA_Method_ABM4) [-]
  END TYPE UA_InitInputType
! =======================
! =========  UA_InitOutputType  =======
  TYPE, PUBLIC :: UA_InitOutputType
    TYPE(ProgDesc)  :: Version      !< Version structure [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputHdr      !< The is the list of all UA-related output channel header strings (includes all sub-module channels) [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputUnt      !< The is the list of all UA-related output channel unit strings (includes all sub-module channels) [-]
  END TYPE UA_InitOutputType
! =======================
! =========  UA_KelvinChainType  =======
  TYPE, PUBLIC :: UA_KelvinChainType
    REAL(ReKi)  :: Cn_prime = 0.0      !<  [-]
    REAL(ReKi)  :: C_nalpha_circ = 0.0      !< slope of the circulatory normal force coefficient vs alpha curve [-]
    REAL(ReKi)  :: Kalpha_f = 0.0      !< filtered  backwards finite difference of alpha (xd%Kalpha_f_minus1) [-]
    REAL(ReKi)  :: Kq_f = 0.0      !< filtered  backwards finite difference of q [-]
    REAL(ReKi)  :: alpha_filt_cur = 0.0      !< filtered angle of attack [-]
    REAL(ReKi)  :: alpha_e = 0.0      !< effective angle of attack at 3/4 chord  TODO: verify 3/4 and not 1/4 [-]
    REAL(ReKi)  :: dalpha0 = 0.0      !<  [-]
    REAL(ReKi)  :: alpha_f = 0.0      !<  [-]
    REAL(ReKi)  :: Kq = 0.0      !<  [-]
    REAL(ReKi)  :: q_cur = 0.0      !<  [-]
    REAL(ReKi)  :: q_f_cur = 0.0      !<  [-]
    REAL(ReKi)  :: X1 = 0.0      !<  [-]
    REAL(ReKi)  :: X2 = 0.0      !<  [-]
    REAL(ReKi)  :: X3 = 0.0      !<  [-]
    REAL(ReKi)  :: X4 = 0.0      !<  [-]
    REAL(ReKi)  :: Kprime_alpha = 0.0      !<  [-]
    REAL(ReKi)  :: Kprime_q = 0.0      !<  [-]
    REAL(ReKi)  :: K3prime_q = 0.0      !<  [-]
    REAL(ReKi)  :: Kprimeprime_q = 0.0      !<  [-]
    REAL(ReKi)  :: Dp = 0.0      !<  [-]
    REAL(ReKi)  :: Cn_pot = 0.0      !<  [-]
    REAL(ReKi)  :: Cc_pot = 0.0      !<  [-]
    REAL(ReKi)  :: Cn_alpha_q_circ = 0.0      !<  [-]
    REAL(ReKi)  :: Cn_alpha_q_nc = 0.0      !< non-circulatory component of normal force coefficient response to step change in alpha and q [-]
    REAL(ReKi)  :: Cm_q_circ = 0.0      !<  [-]
    REAL(ReKi)  :: Cn_alpha_nc = 0.0      !< non-circulatory component of the normal force coefficient response to step change in alpha [-]
    REAL(ReKi)  :: Cn_q_circ = 0.0      !<  [-]
    REAL(ReKi)  :: Cn_q_nc = 0.0      !<  [-]
    REAL(ReKi)  :: Cm_q_nc = 0.0      !< non-circulatory component of the moment coefficient response to step change in q [-]
    REAL(ReKi)  :: fprimeprime = 0.0      !<  [-]
    REAL(ReKi)  :: Df = 0.0      !<  [-]
    REAL(ReKi)  :: Df_c = 0.0      !<  [-]
    REAL(ReKi)  :: Df_m = 0.0      !<  [-]
    REAL(ReKi)  :: Dalphaf = 0.0      !<  [-]
    REAL(ReKi)  :: fprime = 0.0      !<  [-]
    REAL(ReKi)  :: fprime_c = 0.0      !<  [-]
    REAL(ReKi)  :: fprimeprime_c = 0.0      !<  [-]
    REAL(ReKi)  :: fprime_m = 0.0      !<  [-]
    REAL(ReKi)  :: fprimeprime_m = 0.0      !<  [-]
    REAL(ReKi)  :: Cn_v = 0.0      !< normal force coefficient due to the presence of LE vortex [-]
    REAL(ReKi)  :: C_V = 0.0      !< contribution to the normal force coefficient due to accumulated vorticity in the LE vortex [-]
    REAL(ReKi)  :: Cn_FS = 0.0      !<  [-]
    REAL(ReKi)  :: T_f = 0.0      !<  [-]
    REAL(ReKi)  :: T_fc = 0.0      !<  [-]
    REAL(ReKi)  :: T_fm = 0.0      !<  [-]
    REAL(ReKi)  :: T_V = 0.0      !< backwards finite difference of the non-dimensionalized distance parameter [-]
    REAL(ReKi)  :: k_alpha = 0.0      !<  [-]
    REAL(ReKi)  :: k_q = 0.0      !<  [-]
    REAL(ReKi)  :: T_alpha = 0.0      !<  [-]
    REAL(ReKi)  :: T_q = 0.0      !<  [-]
    REAL(ReKi)  :: ds = 0.0      !< non-dimensionalized distance parameter [-]
  END TYPE UA_KelvinChainType
! =======================
! =========  UA_ElementContinuousStateType  =======
  TYPE, PUBLIC :: UA_ElementContinuousStateType
    REAL(R8Ki) , DIMENSION(1:7)  :: x = 0.0_R8Ki      !< continuous states when UA_Mod=4 (x1 and x2:Downwash memory terms; x3:Clp', Lift coefficient with a time lag to the attached lift coeff; x4: f'' , Final separation point function) [{rad, rad, - -}]
  END TYPE UA_ElementContinuousStateType
! =======================
! =========  UA_ContinuousStateType  =======
  TYPE, PUBLIC :: UA_ContinuousStateType
    TYPE(UA_ElementContinuousStateType) , DIMENSION(:,:), ALLOCATABLE  :: element      !< continuous states when UA_Mod=4 for each blade/node [-]
  END TYPE UA_ContinuousStateType
! =======================
! =========  UA_DiscreteStateType  =======
  TYPE, PUBLIC :: UA_DiscreteStateType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: alpha_minus1      !< angle of attack, previous time step [rad]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: alpha_filt_minus1      !< filtered angle of attack, previous time step [rad]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: alpha_dot      !< Rate of change of angle of attack (filtered); BV model [rad/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: alpha_dot_minus1      !< Rate of change of angle of attack (filtered); BV model [rad/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: q_minus1      !< non-dimensional pitching rate, previous time step [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Kalpha_f_minus1      !< filtered pitching rate, previous time step [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Kq_f_minus1      !< filtered pitching acceleration, previous time step [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: q_f_minus1      !< filtered non-dimensional pitching rate, previous time step [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: X1_minus1      !< deficiency function used in the development of Cn_alpha_q_circ, previous time step [rad]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: X2_minus1      !< deficiency function used in the development of Cn_alpha_q_circ, previous time step [rad]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: X3_minus1      !< deficiency function used in the development of Cn_q_circ, previous time step [rad]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: X4_minus1      !< deficiency function used in the development of Cn_q_circ, previous time step [rad]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Kprime_alpha_minus1      !< deficiency function used in the development of Cn_alpha_nc, previous time step [rad/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Kprime_q_minus1      !< deficiency function used in the development of Cn_q_nc, previous time step [rad/s^2]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Kprimeprime_q_minus1      !< deficiency function used in the development of Cm_q_nc, previous time step [rad/s^2]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: K3prime_q_minus1      !< deficiency function used in the development of Cm_q_circ, previous time step [rad/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Dp_minus1      !< deficiency function used in the development of Cm_q_circ, previous time step [rad/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Cn_pot_minus1      !< deficiency function used in the development of Cn_prime [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: fprimeprime_minus1      !< lagged version of fprime, accounting for unsteady boundary layer response, previous time step [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: fprimeprime_c_minus1      !< lagged version of fprime_c, accounting for unsteady boundary layer response, previous time step [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: fprimeprime_m_minus1      !< lagged version of fprime_m, accounting for unsteady boundary layer response, previous time step [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Df_minus1      !< deficiency function used in the development of fprime, previous time step [rad/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Df_c_minus1      !< deficiency function used in the development of fprime, previous time step [rad/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Df_m_minus1      !< deficiency function used in the development of fprime, previous time step [rad/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Dalphaf_minus1      !< deficiency function used in the development of fprime, previous time step [rad/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: alphaf_minus1      !< deficiency function used in the development of fprime, previous time step [rad/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: fprime_minus1      !< separation point Cn distance from leading edge, expressed in cord fraction, previous time step [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: fprime_c_minus1      !< separation point Ct distance from leading edge, expressed in cord fraction, previous time step [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: fprime_m_minus1      !< Distance application of Cn with respect to Cm, previous time step [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: tau_V      !< time variable, tracking the travel of the LE vortex over the airfoil suction surface [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: tau_V_minus1      !< time variable, tracking the travel of the LE vortex over the airfoil suction surface [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Cn_v_minus1      !< normal force coefficient due to the presence of LE vortex, previous time step [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: C_V_minus1      !< contribution to the normal force coefficient due to accumulated vorticity in the LE vortex, previous time step [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Cn_prime_minus1      !< difference between Cn_prime and Cn_prime_minus1, previous time step [rad]
  END TYPE UA_DiscreteStateType
! =======================
! =========  UA_ConstraintStateType  =======
  TYPE, PUBLIC :: UA_ConstraintStateType
    REAL(ReKi)  :: DummyConstraintState = 0.0_ReKi      !<  [-]
  END TYPE UA_ConstraintStateType
! =======================
! =========  UA_OtherStateType  =======
  TYPE, PUBLIC :: UA_OtherStateType
    LOGICAL , DIMENSION(:,:), ALLOCATABLE  :: FirstPass      !< logical flag indicating if this is the first time step [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: sigma1      !< multiplier for T_fn [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: sigma1c      !< multiplier for T_fc [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: sigma1m      !< multiplier for T_fm [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: sigma3      !< multiplier for T_V [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: n      !< counter for continuous state integration [-]
    TYPE(UA_ContinuousStateType) , DIMENSION(1:4)  :: xdot      !< history states for continuous state integration [-]
    TYPE(UA_ContinuousStateType) , DIMENSION(1:4)  :: xHistory      !< history states for continuous state integration [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: t_vortexBegin      !< HGMV model: simulation time when vortex lift term became active [s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: SignOfOmega      !< HGMV model: sign of omega when vortex lift term became active  [s]
    LOGICAL , DIMENSION(:,:), ALLOCATABLE  :: PositivePressure      !< HGMV model: logical flag indicating if the vortex lift became active because of positive pressure (or negative) [-]
    LOGICAL , DIMENSION(:,:), ALLOCATABLE  :: vortexOn      !< HGMV model: logical flag indicating if the vortex lift term is active [-]
    LOGICAL , DIMENSION(:,:), ALLOCATABLE  :: BelowThreshold      !< HGMV model: logical flag indicating if cn fell below threshold to form another vortex [-]
    LOGICAL , DIMENSION(:,:), ALLOCATABLE  :: activeL      !< BV model: logical flag indicating if the lift stall is active [-]
    LOGICAL , DIMENSION(:,:), ALLOCATABLE  :: activeD      !< BV model: logical flag indicating if the drag stall is active [-]
  END TYPE UA_OtherStateType
! =======================
! =========  UA_MiscVarType  =======
  TYPE, PUBLIC :: UA_MiscVarType
    LOGICAL  :: FirstWarn_M = .false.      !< flag so Mach number warning doesn't get repeated forever [-]
    LOGICAL  :: FirstWarn_UA = .false.      !< flag so UA state warning doesn't get repeated forever [-]
    LOGICAL  :: FirstWarn_UA_off = .false.      !< flag so UA state warning doesn't get repeated forever [-]
    LOGICAL , DIMENSION(:,:), ALLOCATABLE  :: TESF      !< logical flag indicating if trailing edge separation is possible [-]
    LOGICAL , DIMENSION(:,:), ALLOCATABLE  :: LESF      !< logical flag indicating if leading edge separation is possible [-]
    LOGICAL , DIMENSION(:,:), ALLOCATABLE  :: VRTX      !< logical flag indicating if a vortex is being processed [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: T_Sh      !< shedding frequency [-]
    LOGICAL , DIMENSION(:,:), ALLOCATABLE  :: BEDSEP      !< logical flag indicating if this is undergoing separated flow [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: weight      !< value between 0 and 1 indicating if UA is on (1) or off (0) or somewhere in between [-]
  END TYPE UA_MiscVarType
! =======================
! =========  UA_ParameterType  =======
  TYPE, PUBLIC :: UA_ParameterType
    REAL(DbKi)  :: dt = 0.0_R8Ki      !< time step [s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: c      !< Chord length at node [m]
    REAL(ReKi)  :: d_34_to_ac = 0.5      !< Distance from 3/4 chord to aerodynamic center (typically 0.5) in chord length (no dimension) [-]
    INTEGER(IntKi)  :: numBlades = 0_IntKi      !< Number nodes of all blades [-]
    INTEGER(IntKi)  :: nNodesPerBlade = 0_IntKi      !< Number nodes per blades [-]
    INTEGER(IntKi)  :: UAMod = 0_IntKi      !< Model for the dynamic stall equations [1 = Leishman/Beddoes, 2 = Gonzalez, 3 = Minnema] [-]
    LOGICAL  :: Flookup = .false.      !< Use table lookup for f' and f''  [-]
    REAL(ReKi)  :: a_s = 0.0_ReKi      !< speed of sound [m/s]
    INTEGER(IntKi)  :: NumOuts = 0      !< Number of outputs [-]
    INTEGER(IntKi)  :: OutSwtch = 0_IntKi      !< Output requested channels to: [1=Unsteady.out 2=GlueCode.out  3=both files] [-]
    CHARACTER(20)  :: OutFmt      !< Output format for numerical results [-]
    CHARACTER(20)  :: OutSFmt      !< Output format for header strings [-]
    CHARACTER(1)  :: Delim      !< Delimiter string for outputs, defaults to tab-delimiters [-]
    INTEGER(IntKi)  :: UnOutFile = 0      !< File unit for the UnsteadyAero outputs [-]
    LOGICAL  :: ShedEffect = .false.      !< Include the effect of shed vorticity. If False, the input alpha is assumed to already contain this effect (e.g. vortex methods) [-]
    INTEGER(IntKi)  :: lin_nx = 0      !< Number of continuous states for linearization [-]
    LOGICAL , DIMENSION(:,:), ALLOCATABLE  :: UA_off_forGood      !< logical flag indicating if UA is off for good [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: lin_xIndx      !< array to indicate which state to perturb for UA [-]
    REAL(R8Ki) , DIMENSION(1:7)  :: dx = 0.0_R8Ki      !< array to indicate size of state perturbations (x array) [-]
    INTEGER(IntKi)  :: UA_OUTS = 0      !< Store write outputs 0=None, 1=WriteOutpus, 2=WriteToFile [-]
    INTEGER(IntKi)  :: integrationMethod = 3      !< method to integrate states [-]
  END TYPE UA_ParameterType
! =======================
! =========  UA_InputType  =======
  TYPE, PUBLIC :: UA_InputType
    REAL(ReKi)  :: U = 0.0_ReKi      !< air velocity magnitude relative to the airfoil [m/s]
    REAL(ReKi)  :: alpha = 0.0_ReKi      !< angle of attack [rad]
    REAL(ReKi)  :: Re = 0.0_ReKi      !< Reynold's number [-]
    REAL(ReKi)  :: UserProp = 0.0      !< UserProp value for interpolating airfoil tables [-]
    REAL(ReKi) , DIMENSION(1:2)  :: v_ac = 0.0_ReKi      !< Relative fluid velocity at the aerodynamic center (UAMod=4) [m/s]
    REAL(ReKi)  :: omega = 0.0_ReKi      !< pitching/twisting rate of the airfoil section (UAMod=4) [rad/s]
  END TYPE UA_InputType
! =======================
! =========  UA_OutputType  =======
  TYPE, PUBLIC :: UA_OutputType
    REAL(ReKi)  :: Cn = 0.0_ReKi      !< 2D, normal to chord, force coefficient [-]
    REAL(ReKi)  :: Cc = 0.0_ReKi      !< 2D, tangent to chord, force coefficient [-]
    REAL(ReKi)  :: Cm = 0.0_ReKi      !< 2D pitching moment coefficient about the 1/4 chord, positive when nose is up [-]
    REAL(ReKi)  :: Cl = 0.0_ReKi      !< 2D lift coefficient [-]
    REAL(ReKi)  :: Cd = 0.0_ReKi      !< 2D drag coefficient [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WriteOutput      !< outputs to be written to a file [-]
  END TYPE UA_OutputType
! =======================
CONTAINS

subroutine UA_CopyInitInput(SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg)
   type(UA_InitInputType), intent(in) :: SrcInitInputData
   type(UA_InitInputType), intent(inout) :: DstInitInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'UA_CopyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInitInputData%dt = SrcInitInputData%dt
   DstInitInputData%OutRootName = SrcInitInputData%OutRootName
   if (allocated(SrcInitInputData%c)) then
      LB(1:2) = lbound(SrcInitInputData%c)
      UB(1:2) = ubound(SrcInitInputData%c)
      if (.not. allocated(DstInitInputData%c)) then
         allocate(DstInitInputData%c(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%c.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%c = SrcInitInputData%c
   end if
   DstInitInputData%d_34_to_ac = SrcInitInputData%d_34_to_ac
   DstInitInputData%numBlades = SrcInitInputData%numBlades
   DstInitInputData%nNodesPerBlade = SrcInitInputData%nNodesPerBlade
   DstInitInputData%UAMod = SrcInitInputData%UAMod
   DstInitInputData%a_s = SrcInitInputData%a_s
   DstInitInputData%Flookup = SrcInitInputData%Flookup
   DstInitInputData%ShedEffect = SrcInitInputData%ShedEffect
   DstInitInputData%WrSum = SrcInitInputData%WrSum
   if (allocated(SrcInitInputData%UAOff_innerNode)) then
      LB(1:1) = lbound(SrcInitInputData%UAOff_innerNode)
      UB(1:1) = ubound(SrcInitInputData%UAOff_innerNode)
      if (.not. allocated(DstInitInputData%UAOff_innerNode)) then
         allocate(DstInitInputData%UAOff_innerNode(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%UAOff_innerNode.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%UAOff_innerNode = SrcInitInputData%UAOff_innerNode
   end if
   if (allocated(SrcInitInputData%UAOff_outerNode)) then
      LB(1:1) = lbound(SrcInitInputData%UAOff_outerNode)
      UB(1:1) = ubound(SrcInitInputData%UAOff_outerNode)
      if (.not. allocated(DstInitInputData%UAOff_outerNode)) then
         allocate(DstInitInputData%UAOff_outerNode(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%UAOff_outerNode.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%UAOff_outerNode = SrcInitInputData%UAOff_outerNode
   end if
   DstInitInputData%UA_OUTS = SrcInitInputData%UA_OUTS
   DstInitInputData%integrationMethod = SrcInitInputData%integrationMethod
end subroutine

subroutine UA_DestroyInitInput(InitInputData, ErrStat, ErrMsg)
   type(UA_InitInputType), intent(inout) :: InitInputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'UA_DestroyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InitInputData%c)) then
      deallocate(InitInputData%c)
   end if
   if (allocated(InitInputData%UAOff_innerNode)) then
      deallocate(InitInputData%UAOff_innerNode)
   end if
   if (allocated(InitInputData%UAOff_outerNode)) then
      deallocate(InitInputData%UAOff_outerNode)
   end if
end subroutine

subroutine UA_PackInitInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(UA_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'UA_PackInitInput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%dt)
   call RegPack(RF, InData%OutRootName)
   call RegPackAlloc(RF, InData%c)
   call RegPack(RF, InData%d_34_to_ac)
   call RegPack(RF, InData%numBlades)
   call RegPack(RF, InData%nNodesPerBlade)
   call RegPack(RF, InData%UAMod)
   call RegPack(RF, InData%a_s)
   call RegPack(RF, InData%Flookup)
   call RegPack(RF, InData%ShedEffect)
   call RegPack(RF, InData%WrSum)
   call RegPackAlloc(RF, InData%UAOff_innerNode)
   call RegPackAlloc(RF, InData%UAOff_outerNode)
   call RegPack(RF, InData%UA_OUTS)
   call RegPack(RF, InData%integrationMethod)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine UA_UnPackInitInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(UA_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'UA_UnPackInitInput'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%dt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutRootName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%c); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%d_34_to_ac); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%numBlades); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nNodesPerBlade); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UAMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%a_s); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Flookup); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ShedEffect); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WrSum); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%UAOff_innerNode); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%UAOff_outerNode); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UA_OUTS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%integrationMethod); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine UA_CopyInitOutput(SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg)
   type(UA_InitOutputType), intent(in) :: SrcInitOutputData
   type(UA_InitOutputType), intent(inout) :: DstInitOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'UA_CopyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call NWTC_Library_CopyProgDesc(SrcInitOutputData%Version, DstInitOutputData%Version, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcInitOutputData%WriteOutputHdr)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputHdr)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputHdr)
      if (.not. allocated(DstInitOutputData%WriteOutputHdr)) then
         allocate(DstInitOutputData%WriteOutputHdr(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputHdr.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputHdr = SrcInitOutputData%WriteOutputHdr
   end if
   if (allocated(SrcInitOutputData%WriteOutputUnt)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputUnt)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputUnt)
      if (.not. allocated(DstInitOutputData%WriteOutputUnt)) then
         allocate(DstInitOutputData%WriteOutputUnt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputUnt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputUnt = SrcInitOutputData%WriteOutputUnt
   end if
end subroutine

subroutine UA_DestroyInitOutput(InitOutputData, ErrStat, ErrMsg)
   type(UA_InitOutputType), intent(inout) :: InitOutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'UA_DestroyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call NWTC_Library_DestroyProgDesc(InitOutputData%Version, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(InitOutputData%WriteOutputHdr)) then
      deallocate(InitOutputData%WriteOutputHdr)
   end if
   if (allocated(InitOutputData%WriteOutputUnt)) then
      deallocate(InitOutputData%WriteOutputUnt)
   end if
end subroutine

subroutine UA_PackInitOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(UA_InitOutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'UA_PackInitOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call NWTC_Library_PackProgDesc(RF, InData%Version) 
   call RegPackAlloc(RF, InData%WriteOutputHdr)
   call RegPackAlloc(RF, InData%WriteOutputUnt)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine UA_UnPackInitOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(UA_InitOutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'UA_UnPackInitOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call NWTC_Library_UnpackProgDesc(RF, OutData%Version) ! Version 
   call RegUnpackAlloc(RF, OutData%WriteOutputHdr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutputUnt); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine UA_CopyKelvinChainType(SrcKelvinChainTypeData, DstKelvinChainTypeData, CtrlCode, ErrStat, ErrMsg)
   type(UA_KelvinChainType), intent(in) :: SrcKelvinChainTypeData
   type(UA_KelvinChainType), intent(inout) :: DstKelvinChainTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'UA_CopyKelvinChainType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstKelvinChainTypeData%Cn_prime = SrcKelvinChainTypeData%Cn_prime
   DstKelvinChainTypeData%C_nalpha_circ = SrcKelvinChainTypeData%C_nalpha_circ
   DstKelvinChainTypeData%Kalpha_f = SrcKelvinChainTypeData%Kalpha_f
   DstKelvinChainTypeData%Kq_f = SrcKelvinChainTypeData%Kq_f
   DstKelvinChainTypeData%alpha_filt_cur = SrcKelvinChainTypeData%alpha_filt_cur
   DstKelvinChainTypeData%alpha_e = SrcKelvinChainTypeData%alpha_e
   DstKelvinChainTypeData%dalpha0 = SrcKelvinChainTypeData%dalpha0
   DstKelvinChainTypeData%alpha_f = SrcKelvinChainTypeData%alpha_f
   DstKelvinChainTypeData%Kq = SrcKelvinChainTypeData%Kq
   DstKelvinChainTypeData%q_cur = SrcKelvinChainTypeData%q_cur
   DstKelvinChainTypeData%q_f_cur = SrcKelvinChainTypeData%q_f_cur
   DstKelvinChainTypeData%X1 = SrcKelvinChainTypeData%X1
   DstKelvinChainTypeData%X2 = SrcKelvinChainTypeData%X2
   DstKelvinChainTypeData%X3 = SrcKelvinChainTypeData%X3
   DstKelvinChainTypeData%X4 = SrcKelvinChainTypeData%X4
   DstKelvinChainTypeData%Kprime_alpha = SrcKelvinChainTypeData%Kprime_alpha
   DstKelvinChainTypeData%Kprime_q = SrcKelvinChainTypeData%Kprime_q
   DstKelvinChainTypeData%K3prime_q = SrcKelvinChainTypeData%K3prime_q
   DstKelvinChainTypeData%Kprimeprime_q = SrcKelvinChainTypeData%Kprimeprime_q
   DstKelvinChainTypeData%Dp = SrcKelvinChainTypeData%Dp
   DstKelvinChainTypeData%Cn_pot = SrcKelvinChainTypeData%Cn_pot
   DstKelvinChainTypeData%Cc_pot = SrcKelvinChainTypeData%Cc_pot
   DstKelvinChainTypeData%Cn_alpha_q_circ = SrcKelvinChainTypeData%Cn_alpha_q_circ
   DstKelvinChainTypeData%Cn_alpha_q_nc = SrcKelvinChainTypeData%Cn_alpha_q_nc
   DstKelvinChainTypeData%Cm_q_circ = SrcKelvinChainTypeData%Cm_q_circ
   DstKelvinChainTypeData%Cn_alpha_nc = SrcKelvinChainTypeData%Cn_alpha_nc
   DstKelvinChainTypeData%Cn_q_circ = SrcKelvinChainTypeData%Cn_q_circ
   DstKelvinChainTypeData%Cn_q_nc = SrcKelvinChainTypeData%Cn_q_nc
   DstKelvinChainTypeData%Cm_q_nc = SrcKelvinChainTypeData%Cm_q_nc
   DstKelvinChainTypeData%fprimeprime = SrcKelvinChainTypeData%fprimeprime
   DstKelvinChainTypeData%Df = SrcKelvinChainTypeData%Df
   DstKelvinChainTypeData%Df_c = SrcKelvinChainTypeData%Df_c
   DstKelvinChainTypeData%Df_m = SrcKelvinChainTypeData%Df_m
   DstKelvinChainTypeData%Dalphaf = SrcKelvinChainTypeData%Dalphaf
   DstKelvinChainTypeData%fprime = SrcKelvinChainTypeData%fprime
   DstKelvinChainTypeData%fprime_c = SrcKelvinChainTypeData%fprime_c
   DstKelvinChainTypeData%fprimeprime_c = SrcKelvinChainTypeData%fprimeprime_c
   DstKelvinChainTypeData%fprime_m = SrcKelvinChainTypeData%fprime_m
   DstKelvinChainTypeData%fprimeprime_m = SrcKelvinChainTypeData%fprimeprime_m
   DstKelvinChainTypeData%Cn_v = SrcKelvinChainTypeData%Cn_v
   DstKelvinChainTypeData%C_V = SrcKelvinChainTypeData%C_V
   DstKelvinChainTypeData%Cn_FS = SrcKelvinChainTypeData%Cn_FS
   DstKelvinChainTypeData%T_f = SrcKelvinChainTypeData%T_f
   DstKelvinChainTypeData%T_fc = SrcKelvinChainTypeData%T_fc
   DstKelvinChainTypeData%T_fm = SrcKelvinChainTypeData%T_fm
   DstKelvinChainTypeData%T_V = SrcKelvinChainTypeData%T_V
   DstKelvinChainTypeData%k_alpha = SrcKelvinChainTypeData%k_alpha
   DstKelvinChainTypeData%k_q = SrcKelvinChainTypeData%k_q
   DstKelvinChainTypeData%T_alpha = SrcKelvinChainTypeData%T_alpha
   DstKelvinChainTypeData%T_q = SrcKelvinChainTypeData%T_q
   DstKelvinChainTypeData%ds = SrcKelvinChainTypeData%ds
end subroutine

subroutine UA_DestroyKelvinChainType(KelvinChainTypeData, ErrStat, ErrMsg)
   type(UA_KelvinChainType), intent(inout) :: KelvinChainTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'UA_DestroyKelvinChainType'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine UA_PackKelvinChainType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(UA_KelvinChainType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'UA_PackKelvinChainType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%Cn_prime)
   call RegPack(RF, InData%C_nalpha_circ)
   call RegPack(RF, InData%Kalpha_f)
   call RegPack(RF, InData%Kq_f)
   call RegPack(RF, InData%alpha_filt_cur)
   call RegPack(RF, InData%alpha_e)
   call RegPack(RF, InData%dalpha0)
   call RegPack(RF, InData%alpha_f)
   call RegPack(RF, InData%Kq)
   call RegPack(RF, InData%q_cur)
   call RegPack(RF, InData%q_f_cur)
   call RegPack(RF, InData%X1)
   call RegPack(RF, InData%X2)
   call RegPack(RF, InData%X3)
   call RegPack(RF, InData%X4)
   call RegPack(RF, InData%Kprime_alpha)
   call RegPack(RF, InData%Kprime_q)
   call RegPack(RF, InData%K3prime_q)
   call RegPack(RF, InData%Kprimeprime_q)
   call RegPack(RF, InData%Dp)
   call RegPack(RF, InData%Cn_pot)
   call RegPack(RF, InData%Cc_pot)
   call RegPack(RF, InData%Cn_alpha_q_circ)
   call RegPack(RF, InData%Cn_alpha_q_nc)
   call RegPack(RF, InData%Cm_q_circ)
   call RegPack(RF, InData%Cn_alpha_nc)
   call RegPack(RF, InData%Cn_q_circ)
   call RegPack(RF, InData%Cn_q_nc)
   call RegPack(RF, InData%Cm_q_nc)
   call RegPack(RF, InData%fprimeprime)
   call RegPack(RF, InData%Df)
   call RegPack(RF, InData%Df_c)
   call RegPack(RF, InData%Df_m)
   call RegPack(RF, InData%Dalphaf)
   call RegPack(RF, InData%fprime)
   call RegPack(RF, InData%fprime_c)
   call RegPack(RF, InData%fprimeprime_c)
   call RegPack(RF, InData%fprime_m)
   call RegPack(RF, InData%fprimeprime_m)
   call RegPack(RF, InData%Cn_v)
   call RegPack(RF, InData%C_V)
   call RegPack(RF, InData%Cn_FS)
   call RegPack(RF, InData%T_f)
   call RegPack(RF, InData%T_fc)
   call RegPack(RF, InData%T_fm)
   call RegPack(RF, InData%T_V)
   call RegPack(RF, InData%k_alpha)
   call RegPack(RF, InData%k_q)
   call RegPack(RF, InData%T_alpha)
   call RegPack(RF, InData%T_q)
   call RegPack(RF, InData%ds)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine UA_UnPackKelvinChainType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(UA_KelvinChainType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'UA_UnPackKelvinChainType'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%Cn_prime); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_nalpha_circ); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Kalpha_f); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Kq_f); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%alpha_filt_cur); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%alpha_e); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dalpha0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%alpha_f); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Kq); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%q_cur); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%q_f_cur); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%X1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%X2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%X3); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%X4); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Kprime_alpha); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Kprime_q); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%K3prime_q); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Kprimeprime_q); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Dp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cn_pot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cc_pot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cn_alpha_q_circ); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cn_alpha_q_nc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cm_q_circ); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cn_alpha_nc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cn_q_circ); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cn_q_nc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cm_q_nc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%fprimeprime); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Df); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Df_c); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Df_m); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Dalphaf); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%fprime); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%fprime_c); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%fprimeprime_c); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%fprime_m); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%fprimeprime_m); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cn_v); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_V); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cn_FS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%T_f); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%T_fc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%T_fm); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%T_V); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k_alpha); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k_q); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%T_alpha); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%T_q); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ds); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine UA_CopyElementContinuousStateType(SrcElementContinuousStateTypeData, DstElementContinuousStateTypeData, CtrlCode, ErrStat, ErrMsg)
   type(UA_ElementContinuousStateType), intent(in) :: SrcElementContinuousStateTypeData
   type(UA_ElementContinuousStateType), intent(inout) :: DstElementContinuousStateTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'UA_CopyElementContinuousStateType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstElementContinuousStateTypeData%x = SrcElementContinuousStateTypeData%x
end subroutine

subroutine UA_DestroyElementContinuousStateType(ElementContinuousStateTypeData, ErrStat, ErrMsg)
   type(UA_ElementContinuousStateType), intent(inout) :: ElementContinuousStateTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'UA_DestroyElementContinuousStateType'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine UA_PackElementContinuousStateType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(UA_ElementContinuousStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'UA_PackElementContinuousStateType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%x)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine UA_UnPackElementContinuousStateType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(UA_ElementContinuousStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'UA_UnPackElementContinuousStateType'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%x); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine UA_CopyContState(SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg)
   type(UA_ContinuousStateType), intent(in) :: SrcContStateData
   type(UA_ContinuousStateType), intent(inout) :: DstContStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'UA_CopyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcContStateData%element)) then
      LB(1:2) = lbound(SrcContStateData%element)
      UB(1:2) = ubound(SrcContStateData%element)
      if (.not. allocated(DstContStateData%element)) then
         allocate(DstContStateData%element(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstContStateData%element.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call UA_CopyElementContinuousStateType(SrcContStateData%element(i1,i2), DstContStateData%element(i1,i2), CtrlCode, ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
            if (ErrStat >= AbortErrLev) return
         end do
      end do
   end if
end subroutine

subroutine UA_DestroyContState(ContStateData, ErrStat, ErrMsg)
   type(UA_ContinuousStateType), intent(inout) :: ContStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'UA_DestroyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ContStateData%element)) then
      LB(1:2) = lbound(ContStateData%element)
      UB(1:2) = ubound(ContStateData%element)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call UA_DestroyElementContinuousStateType(ContStateData%element(i1,i2), ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         end do
      end do
      deallocate(ContStateData%element)
   end if
end subroutine

subroutine UA_PackContState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(UA_ContinuousStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'UA_PackContState'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%element))
   if (allocated(InData%element)) then
      call RegPackBounds(RF, 2, lbound(InData%element), ubound(InData%element))
      LB(1:2) = lbound(InData%element)
      UB(1:2) = ubound(InData%element)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call UA_PackElementContinuousStateType(RF, InData%element(i1,i2)) 
         end do
      end do
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine UA_UnPackContState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(UA_ContinuousStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'UA_UnPackContState'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%element)) deallocate(OutData%element)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 2, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%element(LB(1):UB(1),LB(2):UB(2)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%element.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call UA_UnpackElementContinuousStateType(RF, OutData%element(i1,i2)) ! element 
         end do
      end do
   end if
end subroutine

subroutine UA_CopyDiscState(SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg)
   type(UA_DiscreteStateType), intent(in) :: SrcDiscStateData
   type(UA_DiscreteStateType), intent(inout) :: DstDiscStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'UA_CopyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcDiscStateData%alpha_minus1)) then
      LB(1:2) = lbound(SrcDiscStateData%alpha_minus1)
      UB(1:2) = ubound(SrcDiscStateData%alpha_minus1)
      if (.not. allocated(DstDiscStateData%alpha_minus1)) then
         allocate(DstDiscStateData%alpha_minus1(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%alpha_minus1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%alpha_minus1 = SrcDiscStateData%alpha_minus1
   end if
   if (allocated(SrcDiscStateData%alpha_filt_minus1)) then
      LB(1:2) = lbound(SrcDiscStateData%alpha_filt_minus1)
      UB(1:2) = ubound(SrcDiscStateData%alpha_filt_minus1)
      if (.not. allocated(DstDiscStateData%alpha_filt_minus1)) then
         allocate(DstDiscStateData%alpha_filt_minus1(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%alpha_filt_minus1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%alpha_filt_minus1 = SrcDiscStateData%alpha_filt_minus1
   end if
   if (allocated(SrcDiscStateData%alpha_dot)) then
      LB(1:2) = lbound(SrcDiscStateData%alpha_dot)
      UB(1:2) = ubound(SrcDiscStateData%alpha_dot)
      if (.not. allocated(DstDiscStateData%alpha_dot)) then
         allocate(DstDiscStateData%alpha_dot(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%alpha_dot.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%alpha_dot = SrcDiscStateData%alpha_dot
   end if
   if (allocated(SrcDiscStateData%alpha_dot_minus1)) then
      LB(1:2) = lbound(SrcDiscStateData%alpha_dot_minus1)
      UB(1:2) = ubound(SrcDiscStateData%alpha_dot_minus1)
      if (.not. allocated(DstDiscStateData%alpha_dot_minus1)) then
         allocate(DstDiscStateData%alpha_dot_minus1(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%alpha_dot_minus1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%alpha_dot_minus1 = SrcDiscStateData%alpha_dot_minus1
   end if
   if (allocated(SrcDiscStateData%q_minus1)) then
      LB(1:2) = lbound(SrcDiscStateData%q_minus1)
      UB(1:2) = ubound(SrcDiscStateData%q_minus1)
      if (.not. allocated(DstDiscStateData%q_minus1)) then
         allocate(DstDiscStateData%q_minus1(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%q_minus1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%q_minus1 = SrcDiscStateData%q_minus1
   end if
   if (allocated(SrcDiscStateData%Kalpha_f_minus1)) then
      LB(1:2) = lbound(SrcDiscStateData%Kalpha_f_minus1)
      UB(1:2) = ubound(SrcDiscStateData%Kalpha_f_minus1)
      if (.not. allocated(DstDiscStateData%Kalpha_f_minus1)) then
         allocate(DstDiscStateData%Kalpha_f_minus1(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%Kalpha_f_minus1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%Kalpha_f_minus1 = SrcDiscStateData%Kalpha_f_minus1
   end if
   if (allocated(SrcDiscStateData%Kq_f_minus1)) then
      LB(1:2) = lbound(SrcDiscStateData%Kq_f_minus1)
      UB(1:2) = ubound(SrcDiscStateData%Kq_f_minus1)
      if (.not. allocated(DstDiscStateData%Kq_f_minus1)) then
         allocate(DstDiscStateData%Kq_f_minus1(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%Kq_f_minus1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%Kq_f_minus1 = SrcDiscStateData%Kq_f_minus1
   end if
   if (allocated(SrcDiscStateData%q_f_minus1)) then
      LB(1:2) = lbound(SrcDiscStateData%q_f_minus1)
      UB(1:2) = ubound(SrcDiscStateData%q_f_minus1)
      if (.not. allocated(DstDiscStateData%q_f_minus1)) then
         allocate(DstDiscStateData%q_f_minus1(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%q_f_minus1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%q_f_minus1 = SrcDiscStateData%q_f_minus1
   end if
   if (allocated(SrcDiscStateData%X1_minus1)) then
      LB(1:2) = lbound(SrcDiscStateData%X1_minus1)
      UB(1:2) = ubound(SrcDiscStateData%X1_minus1)
      if (.not. allocated(DstDiscStateData%X1_minus1)) then
         allocate(DstDiscStateData%X1_minus1(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%X1_minus1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%X1_minus1 = SrcDiscStateData%X1_minus1
   end if
   if (allocated(SrcDiscStateData%X2_minus1)) then
      LB(1:2) = lbound(SrcDiscStateData%X2_minus1)
      UB(1:2) = ubound(SrcDiscStateData%X2_minus1)
      if (.not. allocated(DstDiscStateData%X2_minus1)) then
         allocate(DstDiscStateData%X2_minus1(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%X2_minus1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%X2_minus1 = SrcDiscStateData%X2_minus1
   end if
   if (allocated(SrcDiscStateData%X3_minus1)) then
      LB(1:2) = lbound(SrcDiscStateData%X3_minus1)
      UB(1:2) = ubound(SrcDiscStateData%X3_minus1)
      if (.not. allocated(DstDiscStateData%X3_minus1)) then
         allocate(DstDiscStateData%X3_minus1(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%X3_minus1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%X3_minus1 = SrcDiscStateData%X3_minus1
   end if
   if (allocated(SrcDiscStateData%X4_minus1)) then
      LB(1:2) = lbound(SrcDiscStateData%X4_minus1)
      UB(1:2) = ubound(SrcDiscStateData%X4_minus1)
      if (.not. allocated(DstDiscStateData%X4_minus1)) then
         allocate(DstDiscStateData%X4_minus1(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%X4_minus1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%X4_minus1 = SrcDiscStateData%X4_minus1
   end if
   if (allocated(SrcDiscStateData%Kprime_alpha_minus1)) then
      LB(1:2) = lbound(SrcDiscStateData%Kprime_alpha_minus1)
      UB(1:2) = ubound(SrcDiscStateData%Kprime_alpha_minus1)
      if (.not. allocated(DstDiscStateData%Kprime_alpha_minus1)) then
         allocate(DstDiscStateData%Kprime_alpha_minus1(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%Kprime_alpha_minus1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%Kprime_alpha_minus1 = SrcDiscStateData%Kprime_alpha_minus1
   end if
   if (allocated(SrcDiscStateData%Kprime_q_minus1)) then
      LB(1:2) = lbound(SrcDiscStateData%Kprime_q_minus1)
      UB(1:2) = ubound(SrcDiscStateData%Kprime_q_minus1)
      if (.not. allocated(DstDiscStateData%Kprime_q_minus1)) then
         allocate(DstDiscStateData%Kprime_q_minus1(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%Kprime_q_minus1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%Kprime_q_minus1 = SrcDiscStateData%Kprime_q_minus1
   end if
   if (allocated(SrcDiscStateData%Kprimeprime_q_minus1)) then
      LB(1:2) = lbound(SrcDiscStateData%Kprimeprime_q_minus1)
      UB(1:2) = ubound(SrcDiscStateData%Kprimeprime_q_minus1)
      if (.not. allocated(DstDiscStateData%Kprimeprime_q_minus1)) then
         allocate(DstDiscStateData%Kprimeprime_q_minus1(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%Kprimeprime_q_minus1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%Kprimeprime_q_minus1 = SrcDiscStateData%Kprimeprime_q_minus1
   end if
   if (allocated(SrcDiscStateData%K3prime_q_minus1)) then
      LB(1:2) = lbound(SrcDiscStateData%K3prime_q_minus1)
      UB(1:2) = ubound(SrcDiscStateData%K3prime_q_minus1)
      if (.not. allocated(DstDiscStateData%K3prime_q_minus1)) then
         allocate(DstDiscStateData%K3prime_q_minus1(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%K3prime_q_minus1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%K3prime_q_minus1 = SrcDiscStateData%K3prime_q_minus1
   end if
   if (allocated(SrcDiscStateData%Dp_minus1)) then
      LB(1:2) = lbound(SrcDiscStateData%Dp_minus1)
      UB(1:2) = ubound(SrcDiscStateData%Dp_minus1)
      if (.not. allocated(DstDiscStateData%Dp_minus1)) then
         allocate(DstDiscStateData%Dp_minus1(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%Dp_minus1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%Dp_minus1 = SrcDiscStateData%Dp_minus1
   end if
   if (allocated(SrcDiscStateData%Cn_pot_minus1)) then
      LB(1:2) = lbound(SrcDiscStateData%Cn_pot_minus1)
      UB(1:2) = ubound(SrcDiscStateData%Cn_pot_minus1)
      if (.not. allocated(DstDiscStateData%Cn_pot_minus1)) then
         allocate(DstDiscStateData%Cn_pot_minus1(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%Cn_pot_minus1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%Cn_pot_minus1 = SrcDiscStateData%Cn_pot_minus1
   end if
   if (allocated(SrcDiscStateData%fprimeprime_minus1)) then
      LB(1:2) = lbound(SrcDiscStateData%fprimeprime_minus1)
      UB(1:2) = ubound(SrcDiscStateData%fprimeprime_minus1)
      if (.not. allocated(DstDiscStateData%fprimeprime_minus1)) then
         allocate(DstDiscStateData%fprimeprime_minus1(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%fprimeprime_minus1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%fprimeprime_minus1 = SrcDiscStateData%fprimeprime_minus1
   end if
   if (allocated(SrcDiscStateData%fprimeprime_c_minus1)) then
      LB(1:2) = lbound(SrcDiscStateData%fprimeprime_c_minus1)
      UB(1:2) = ubound(SrcDiscStateData%fprimeprime_c_minus1)
      if (.not. allocated(DstDiscStateData%fprimeprime_c_minus1)) then
         allocate(DstDiscStateData%fprimeprime_c_minus1(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%fprimeprime_c_minus1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%fprimeprime_c_minus1 = SrcDiscStateData%fprimeprime_c_minus1
   end if
   if (allocated(SrcDiscStateData%fprimeprime_m_minus1)) then
      LB(1:2) = lbound(SrcDiscStateData%fprimeprime_m_minus1)
      UB(1:2) = ubound(SrcDiscStateData%fprimeprime_m_minus1)
      if (.not. allocated(DstDiscStateData%fprimeprime_m_minus1)) then
         allocate(DstDiscStateData%fprimeprime_m_minus1(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%fprimeprime_m_minus1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%fprimeprime_m_minus1 = SrcDiscStateData%fprimeprime_m_minus1
   end if
   if (allocated(SrcDiscStateData%Df_minus1)) then
      LB(1:2) = lbound(SrcDiscStateData%Df_minus1)
      UB(1:2) = ubound(SrcDiscStateData%Df_minus1)
      if (.not. allocated(DstDiscStateData%Df_minus1)) then
         allocate(DstDiscStateData%Df_minus1(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%Df_minus1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%Df_minus1 = SrcDiscStateData%Df_minus1
   end if
   if (allocated(SrcDiscStateData%Df_c_minus1)) then
      LB(1:2) = lbound(SrcDiscStateData%Df_c_minus1)
      UB(1:2) = ubound(SrcDiscStateData%Df_c_minus1)
      if (.not. allocated(DstDiscStateData%Df_c_minus1)) then
         allocate(DstDiscStateData%Df_c_minus1(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%Df_c_minus1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%Df_c_minus1 = SrcDiscStateData%Df_c_minus1
   end if
   if (allocated(SrcDiscStateData%Df_m_minus1)) then
      LB(1:2) = lbound(SrcDiscStateData%Df_m_minus1)
      UB(1:2) = ubound(SrcDiscStateData%Df_m_minus1)
      if (.not. allocated(DstDiscStateData%Df_m_minus1)) then
         allocate(DstDiscStateData%Df_m_minus1(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%Df_m_minus1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%Df_m_minus1 = SrcDiscStateData%Df_m_minus1
   end if
   if (allocated(SrcDiscStateData%Dalphaf_minus1)) then
      LB(1:2) = lbound(SrcDiscStateData%Dalphaf_minus1)
      UB(1:2) = ubound(SrcDiscStateData%Dalphaf_minus1)
      if (.not. allocated(DstDiscStateData%Dalphaf_minus1)) then
         allocate(DstDiscStateData%Dalphaf_minus1(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%Dalphaf_minus1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%Dalphaf_minus1 = SrcDiscStateData%Dalphaf_minus1
   end if
   if (allocated(SrcDiscStateData%alphaf_minus1)) then
      LB(1:2) = lbound(SrcDiscStateData%alphaf_minus1)
      UB(1:2) = ubound(SrcDiscStateData%alphaf_minus1)
      if (.not. allocated(DstDiscStateData%alphaf_minus1)) then
         allocate(DstDiscStateData%alphaf_minus1(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%alphaf_minus1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%alphaf_minus1 = SrcDiscStateData%alphaf_minus1
   end if
   if (allocated(SrcDiscStateData%fprime_minus1)) then
      LB(1:2) = lbound(SrcDiscStateData%fprime_minus1)
      UB(1:2) = ubound(SrcDiscStateData%fprime_minus1)
      if (.not. allocated(DstDiscStateData%fprime_minus1)) then
         allocate(DstDiscStateData%fprime_minus1(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%fprime_minus1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%fprime_minus1 = SrcDiscStateData%fprime_minus1
   end if
   if (allocated(SrcDiscStateData%fprime_c_minus1)) then
      LB(1:2) = lbound(SrcDiscStateData%fprime_c_minus1)
      UB(1:2) = ubound(SrcDiscStateData%fprime_c_minus1)
      if (.not. allocated(DstDiscStateData%fprime_c_minus1)) then
         allocate(DstDiscStateData%fprime_c_minus1(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%fprime_c_minus1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%fprime_c_minus1 = SrcDiscStateData%fprime_c_minus1
   end if
   if (allocated(SrcDiscStateData%fprime_m_minus1)) then
      LB(1:2) = lbound(SrcDiscStateData%fprime_m_minus1)
      UB(1:2) = ubound(SrcDiscStateData%fprime_m_minus1)
      if (.not. allocated(DstDiscStateData%fprime_m_minus1)) then
         allocate(DstDiscStateData%fprime_m_minus1(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%fprime_m_minus1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%fprime_m_minus1 = SrcDiscStateData%fprime_m_minus1
   end if
   if (allocated(SrcDiscStateData%tau_V)) then
      LB(1:2) = lbound(SrcDiscStateData%tau_V)
      UB(1:2) = ubound(SrcDiscStateData%tau_V)
      if (.not. allocated(DstDiscStateData%tau_V)) then
         allocate(DstDiscStateData%tau_V(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%tau_V.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%tau_V = SrcDiscStateData%tau_V
   end if
   if (allocated(SrcDiscStateData%tau_V_minus1)) then
      LB(1:2) = lbound(SrcDiscStateData%tau_V_minus1)
      UB(1:2) = ubound(SrcDiscStateData%tau_V_minus1)
      if (.not. allocated(DstDiscStateData%tau_V_minus1)) then
         allocate(DstDiscStateData%tau_V_minus1(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%tau_V_minus1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%tau_V_minus1 = SrcDiscStateData%tau_V_minus1
   end if
   if (allocated(SrcDiscStateData%Cn_v_minus1)) then
      LB(1:2) = lbound(SrcDiscStateData%Cn_v_minus1)
      UB(1:2) = ubound(SrcDiscStateData%Cn_v_minus1)
      if (.not. allocated(DstDiscStateData%Cn_v_minus1)) then
         allocate(DstDiscStateData%Cn_v_minus1(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%Cn_v_minus1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%Cn_v_minus1 = SrcDiscStateData%Cn_v_minus1
   end if
   if (allocated(SrcDiscStateData%C_V_minus1)) then
      LB(1:2) = lbound(SrcDiscStateData%C_V_minus1)
      UB(1:2) = ubound(SrcDiscStateData%C_V_minus1)
      if (.not. allocated(DstDiscStateData%C_V_minus1)) then
         allocate(DstDiscStateData%C_V_minus1(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%C_V_minus1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%C_V_minus1 = SrcDiscStateData%C_V_minus1
   end if
   if (allocated(SrcDiscStateData%Cn_prime_minus1)) then
      LB(1:2) = lbound(SrcDiscStateData%Cn_prime_minus1)
      UB(1:2) = ubound(SrcDiscStateData%Cn_prime_minus1)
      if (.not. allocated(DstDiscStateData%Cn_prime_minus1)) then
         allocate(DstDiscStateData%Cn_prime_minus1(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%Cn_prime_minus1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%Cn_prime_minus1 = SrcDiscStateData%Cn_prime_minus1
   end if
end subroutine

subroutine UA_DestroyDiscState(DiscStateData, ErrStat, ErrMsg)
   type(UA_DiscreteStateType), intent(inout) :: DiscStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'UA_DestroyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(DiscStateData%alpha_minus1)) then
      deallocate(DiscStateData%alpha_minus1)
   end if
   if (allocated(DiscStateData%alpha_filt_minus1)) then
      deallocate(DiscStateData%alpha_filt_minus1)
   end if
   if (allocated(DiscStateData%alpha_dot)) then
      deallocate(DiscStateData%alpha_dot)
   end if
   if (allocated(DiscStateData%alpha_dot_minus1)) then
      deallocate(DiscStateData%alpha_dot_minus1)
   end if
   if (allocated(DiscStateData%q_minus1)) then
      deallocate(DiscStateData%q_minus1)
   end if
   if (allocated(DiscStateData%Kalpha_f_minus1)) then
      deallocate(DiscStateData%Kalpha_f_minus1)
   end if
   if (allocated(DiscStateData%Kq_f_minus1)) then
      deallocate(DiscStateData%Kq_f_minus1)
   end if
   if (allocated(DiscStateData%q_f_minus1)) then
      deallocate(DiscStateData%q_f_minus1)
   end if
   if (allocated(DiscStateData%X1_minus1)) then
      deallocate(DiscStateData%X1_minus1)
   end if
   if (allocated(DiscStateData%X2_minus1)) then
      deallocate(DiscStateData%X2_minus1)
   end if
   if (allocated(DiscStateData%X3_minus1)) then
      deallocate(DiscStateData%X3_minus1)
   end if
   if (allocated(DiscStateData%X4_minus1)) then
      deallocate(DiscStateData%X4_minus1)
   end if
   if (allocated(DiscStateData%Kprime_alpha_minus1)) then
      deallocate(DiscStateData%Kprime_alpha_minus1)
   end if
   if (allocated(DiscStateData%Kprime_q_minus1)) then
      deallocate(DiscStateData%Kprime_q_minus1)
   end if
   if (allocated(DiscStateData%Kprimeprime_q_minus1)) then
      deallocate(DiscStateData%Kprimeprime_q_minus1)
   end if
   if (allocated(DiscStateData%K3prime_q_minus1)) then
      deallocate(DiscStateData%K3prime_q_minus1)
   end if
   if (allocated(DiscStateData%Dp_minus1)) then
      deallocate(DiscStateData%Dp_minus1)
   end if
   if (allocated(DiscStateData%Cn_pot_minus1)) then
      deallocate(DiscStateData%Cn_pot_minus1)
   end if
   if (allocated(DiscStateData%fprimeprime_minus1)) then
      deallocate(DiscStateData%fprimeprime_minus1)
   end if
   if (allocated(DiscStateData%fprimeprime_c_minus1)) then
      deallocate(DiscStateData%fprimeprime_c_minus1)
   end if
   if (allocated(DiscStateData%fprimeprime_m_minus1)) then
      deallocate(DiscStateData%fprimeprime_m_minus1)
   end if
   if (allocated(DiscStateData%Df_minus1)) then
      deallocate(DiscStateData%Df_minus1)
   end if
   if (allocated(DiscStateData%Df_c_minus1)) then
      deallocate(DiscStateData%Df_c_minus1)
   end if
   if (allocated(DiscStateData%Df_m_minus1)) then
      deallocate(DiscStateData%Df_m_minus1)
   end if
   if (allocated(DiscStateData%Dalphaf_minus1)) then
      deallocate(DiscStateData%Dalphaf_minus1)
   end if
   if (allocated(DiscStateData%alphaf_minus1)) then
      deallocate(DiscStateData%alphaf_minus1)
   end if
   if (allocated(DiscStateData%fprime_minus1)) then
      deallocate(DiscStateData%fprime_minus1)
   end if
   if (allocated(DiscStateData%fprime_c_minus1)) then
      deallocate(DiscStateData%fprime_c_minus1)
   end if
   if (allocated(DiscStateData%fprime_m_minus1)) then
      deallocate(DiscStateData%fprime_m_minus1)
   end if
   if (allocated(DiscStateData%tau_V)) then
      deallocate(DiscStateData%tau_V)
   end if
   if (allocated(DiscStateData%tau_V_minus1)) then
      deallocate(DiscStateData%tau_V_minus1)
   end if
   if (allocated(DiscStateData%Cn_v_minus1)) then
      deallocate(DiscStateData%Cn_v_minus1)
   end if
   if (allocated(DiscStateData%C_V_minus1)) then
      deallocate(DiscStateData%C_V_minus1)
   end if
   if (allocated(DiscStateData%Cn_prime_minus1)) then
      deallocate(DiscStateData%Cn_prime_minus1)
   end if
end subroutine

subroutine UA_PackDiscState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(UA_DiscreteStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'UA_PackDiscState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%alpha_minus1)
   call RegPackAlloc(RF, InData%alpha_filt_minus1)
   call RegPackAlloc(RF, InData%alpha_dot)
   call RegPackAlloc(RF, InData%alpha_dot_minus1)
   call RegPackAlloc(RF, InData%q_minus1)
   call RegPackAlloc(RF, InData%Kalpha_f_minus1)
   call RegPackAlloc(RF, InData%Kq_f_minus1)
   call RegPackAlloc(RF, InData%q_f_minus1)
   call RegPackAlloc(RF, InData%X1_minus1)
   call RegPackAlloc(RF, InData%X2_minus1)
   call RegPackAlloc(RF, InData%X3_minus1)
   call RegPackAlloc(RF, InData%X4_minus1)
   call RegPackAlloc(RF, InData%Kprime_alpha_minus1)
   call RegPackAlloc(RF, InData%Kprime_q_minus1)
   call RegPackAlloc(RF, InData%Kprimeprime_q_minus1)
   call RegPackAlloc(RF, InData%K3prime_q_minus1)
   call RegPackAlloc(RF, InData%Dp_minus1)
   call RegPackAlloc(RF, InData%Cn_pot_minus1)
   call RegPackAlloc(RF, InData%fprimeprime_minus1)
   call RegPackAlloc(RF, InData%fprimeprime_c_minus1)
   call RegPackAlloc(RF, InData%fprimeprime_m_minus1)
   call RegPackAlloc(RF, InData%Df_minus1)
   call RegPackAlloc(RF, InData%Df_c_minus1)
   call RegPackAlloc(RF, InData%Df_m_minus1)
   call RegPackAlloc(RF, InData%Dalphaf_minus1)
   call RegPackAlloc(RF, InData%alphaf_minus1)
   call RegPackAlloc(RF, InData%fprime_minus1)
   call RegPackAlloc(RF, InData%fprime_c_minus1)
   call RegPackAlloc(RF, InData%fprime_m_minus1)
   call RegPackAlloc(RF, InData%tau_V)
   call RegPackAlloc(RF, InData%tau_V_minus1)
   call RegPackAlloc(RF, InData%Cn_v_minus1)
   call RegPackAlloc(RF, InData%C_V_minus1)
   call RegPackAlloc(RF, InData%Cn_prime_minus1)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine UA_UnPackDiscState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(UA_DiscreteStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'UA_UnPackDiscState'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%alpha_minus1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%alpha_filt_minus1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%alpha_dot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%alpha_dot_minus1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%q_minus1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Kalpha_f_minus1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Kq_f_minus1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%q_f_minus1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%X1_minus1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%X2_minus1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%X3_minus1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%X4_minus1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Kprime_alpha_minus1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Kprime_q_minus1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Kprimeprime_q_minus1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%K3prime_q_minus1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Dp_minus1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Cn_pot_minus1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%fprimeprime_minus1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%fprimeprime_c_minus1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%fprimeprime_m_minus1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Df_minus1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Df_c_minus1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Df_m_minus1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Dalphaf_minus1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%alphaf_minus1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%fprime_minus1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%fprime_c_minus1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%fprime_m_minus1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%tau_V); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%tau_V_minus1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Cn_v_minus1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%C_V_minus1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Cn_prime_minus1); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine UA_CopyConstrState(SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg)
   type(UA_ConstraintStateType), intent(in) :: SrcConstrStateData
   type(UA_ConstraintStateType), intent(inout) :: DstConstrStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'UA_CopyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstConstrStateData%DummyConstraintState = SrcConstrStateData%DummyConstraintState
end subroutine

subroutine UA_DestroyConstrState(ConstrStateData, ErrStat, ErrMsg)
   type(UA_ConstraintStateType), intent(inout) :: ConstrStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'UA_DestroyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine UA_PackConstrState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(UA_ConstraintStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'UA_PackConstrState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyConstraintState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine UA_UnPackConstrState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(UA_ConstraintStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'UA_UnPackConstrState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyConstraintState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine UA_CopyOtherState(SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg)
   type(UA_OtherStateType), intent(in) :: SrcOtherStateData
   type(UA_OtherStateType), intent(inout) :: DstOtherStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'UA_CopyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcOtherStateData%FirstPass)) then
      LB(1:2) = lbound(SrcOtherStateData%FirstPass)
      UB(1:2) = ubound(SrcOtherStateData%FirstPass)
      if (.not. allocated(DstOtherStateData%FirstPass)) then
         allocate(DstOtherStateData%FirstPass(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%FirstPass.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOtherStateData%FirstPass = SrcOtherStateData%FirstPass
   end if
   if (allocated(SrcOtherStateData%sigma1)) then
      LB(1:2) = lbound(SrcOtherStateData%sigma1)
      UB(1:2) = ubound(SrcOtherStateData%sigma1)
      if (.not. allocated(DstOtherStateData%sigma1)) then
         allocate(DstOtherStateData%sigma1(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%sigma1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOtherStateData%sigma1 = SrcOtherStateData%sigma1
   end if
   if (allocated(SrcOtherStateData%sigma1c)) then
      LB(1:2) = lbound(SrcOtherStateData%sigma1c)
      UB(1:2) = ubound(SrcOtherStateData%sigma1c)
      if (.not. allocated(DstOtherStateData%sigma1c)) then
         allocate(DstOtherStateData%sigma1c(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%sigma1c.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOtherStateData%sigma1c = SrcOtherStateData%sigma1c
   end if
   if (allocated(SrcOtherStateData%sigma1m)) then
      LB(1:2) = lbound(SrcOtherStateData%sigma1m)
      UB(1:2) = ubound(SrcOtherStateData%sigma1m)
      if (.not. allocated(DstOtherStateData%sigma1m)) then
         allocate(DstOtherStateData%sigma1m(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%sigma1m.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOtherStateData%sigma1m = SrcOtherStateData%sigma1m
   end if
   if (allocated(SrcOtherStateData%sigma3)) then
      LB(1:2) = lbound(SrcOtherStateData%sigma3)
      UB(1:2) = ubound(SrcOtherStateData%sigma3)
      if (.not. allocated(DstOtherStateData%sigma3)) then
         allocate(DstOtherStateData%sigma3(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%sigma3.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOtherStateData%sigma3 = SrcOtherStateData%sigma3
   end if
   if (allocated(SrcOtherStateData%n)) then
      LB(1:2) = lbound(SrcOtherStateData%n)
      UB(1:2) = ubound(SrcOtherStateData%n)
      if (.not. allocated(DstOtherStateData%n)) then
         allocate(DstOtherStateData%n(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%n.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOtherStateData%n = SrcOtherStateData%n
   end if
   LB(1:1) = lbound(SrcOtherStateData%xdot)
   UB(1:1) = ubound(SrcOtherStateData%xdot)
   do i1 = LB(1), UB(1)
      call UA_CopyContState(SrcOtherStateData%xdot(i1), DstOtherStateData%xdot(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcOtherStateData%xHistory)
   UB(1:1) = ubound(SrcOtherStateData%xHistory)
   do i1 = LB(1), UB(1)
      call UA_CopyContState(SrcOtherStateData%xHistory(i1), DstOtherStateData%xHistory(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   if (allocated(SrcOtherStateData%t_vortexBegin)) then
      LB(1:2) = lbound(SrcOtherStateData%t_vortexBegin)
      UB(1:2) = ubound(SrcOtherStateData%t_vortexBegin)
      if (.not. allocated(DstOtherStateData%t_vortexBegin)) then
         allocate(DstOtherStateData%t_vortexBegin(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%t_vortexBegin.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOtherStateData%t_vortexBegin = SrcOtherStateData%t_vortexBegin
   end if
   if (allocated(SrcOtherStateData%SignOfOmega)) then
      LB(1:2) = lbound(SrcOtherStateData%SignOfOmega)
      UB(1:2) = ubound(SrcOtherStateData%SignOfOmega)
      if (.not. allocated(DstOtherStateData%SignOfOmega)) then
         allocate(DstOtherStateData%SignOfOmega(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%SignOfOmega.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOtherStateData%SignOfOmega = SrcOtherStateData%SignOfOmega
   end if
   if (allocated(SrcOtherStateData%PositivePressure)) then
      LB(1:2) = lbound(SrcOtherStateData%PositivePressure)
      UB(1:2) = ubound(SrcOtherStateData%PositivePressure)
      if (.not. allocated(DstOtherStateData%PositivePressure)) then
         allocate(DstOtherStateData%PositivePressure(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%PositivePressure.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOtherStateData%PositivePressure = SrcOtherStateData%PositivePressure
   end if
   if (allocated(SrcOtherStateData%vortexOn)) then
      LB(1:2) = lbound(SrcOtherStateData%vortexOn)
      UB(1:2) = ubound(SrcOtherStateData%vortexOn)
      if (.not. allocated(DstOtherStateData%vortexOn)) then
         allocate(DstOtherStateData%vortexOn(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%vortexOn.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOtherStateData%vortexOn = SrcOtherStateData%vortexOn
   end if
   if (allocated(SrcOtherStateData%BelowThreshold)) then
      LB(1:2) = lbound(SrcOtherStateData%BelowThreshold)
      UB(1:2) = ubound(SrcOtherStateData%BelowThreshold)
      if (.not. allocated(DstOtherStateData%BelowThreshold)) then
         allocate(DstOtherStateData%BelowThreshold(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%BelowThreshold.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOtherStateData%BelowThreshold = SrcOtherStateData%BelowThreshold
   end if
   if (allocated(SrcOtherStateData%activeL)) then
      LB(1:2) = lbound(SrcOtherStateData%activeL)
      UB(1:2) = ubound(SrcOtherStateData%activeL)
      if (.not. allocated(DstOtherStateData%activeL)) then
         allocate(DstOtherStateData%activeL(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%activeL.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOtherStateData%activeL = SrcOtherStateData%activeL
   end if
   if (allocated(SrcOtherStateData%activeD)) then
      LB(1:2) = lbound(SrcOtherStateData%activeD)
      UB(1:2) = ubound(SrcOtherStateData%activeD)
      if (.not. allocated(DstOtherStateData%activeD)) then
         allocate(DstOtherStateData%activeD(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%activeD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOtherStateData%activeD = SrcOtherStateData%activeD
   end if
end subroutine

subroutine UA_DestroyOtherState(OtherStateData, ErrStat, ErrMsg)
   type(UA_OtherStateType), intent(inout) :: OtherStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'UA_DestroyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(OtherStateData%FirstPass)) then
      deallocate(OtherStateData%FirstPass)
   end if
   if (allocated(OtherStateData%sigma1)) then
      deallocate(OtherStateData%sigma1)
   end if
   if (allocated(OtherStateData%sigma1c)) then
      deallocate(OtherStateData%sigma1c)
   end if
   if (allocated(OtherStateData%sigma1m)) then
      deallocate(OtherStateData%sigma1m)
   end if
   if (allocated(OtherStateData%sigma3)) then
      deallocate(OtherStateData%sigma3)
   end if
   if (allocated(OtherStateData%n)) then
      deallocate(OtherStateData%n)
   end if
   LB(1:1) = lbound(OtherStateData%xdot)
   UB(1:1) = ubound(OtherStateData%xdot)
   do i1 = LB(1), UB(1)
      call UA_DestroyContState(OtherStateData%xdot(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(OtherStateData%xHistory)
   UB(1:1) = ubound(OtherStateData%xHistory)
   do i1 = LB(1), UB(1)
      call UA_DestroyContState(OtherStateData%xHistory(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   if (allocated(OtherStateData%t_vortexBegin)) then
      deallocate(OtherStateData%t_vortexBegin)
   end if
   if (allocated(OtherStateData%SignOfOmega)) then
      deallocate(OtherStateData%SignOfOmega)
   end if
   if (allocated(OtherStateData%PositivePressure)) then
      deallocate(OtherStateData%PositivePressure)
   end if
   if (allocated(OtherStateData%vortexOn)) then
      deallocate(OtherStateData%vortexOn)
   end if
   if (allocated(OtherStateData%BelowThreshold)) then
      deallocate(OtherStateData%BelowThreshold)
   end if
   if (allocated(OtherStateData%activeL)) then
      deallocate(OtherStateData%activeL)
   end if
   if (allocated(OtherStateData%activeD)) then
      deallocate(OtherStateData%activeD)
   end if
end subroutine

subroutine UA_PackOtherState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(UA_OtherStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'UA_PackOtherState'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%FirstPass)
   call RegPackAlloc(RF, InData%sigma1)
   call RegPackAlloc(RF, InData%sigma1c)
   call RegPackAlloc(RF, InData%sigma1m)
   call RegPackAlloc(RF, InData%sigma3)
   call RegPackAlloc(RF, InData%n)
   LB(1:1) = lbound(InData%xdot)
   UB(1:1) = ubound(InData%xdot)
   do i1 = LB(1), UB(1)
      call UA_PackContState(RF, InData%xdot(i1)) 
   end do
   LB(1:1) = lbound(InData%xHistory)
   UB(1:1) = ubound(InData%xHistory)
   do i1 = LB(1), UB(1)
      call UA_PackContState(RF, InData%xHistory(i1)) 
   end do
   call RegPackAlloc(RF, InData%t_vortexBegin)
   call RegPackAlloc(RF, InData%SignOfOmega)
   call RegPackAlloc(RF, InData%PositivePressure)
   call RegPackAlloc(RF, InData%vortexOn)
   call RegPackAlloc(RF, InData%BelowThreshold)
   call RegPackAlloc(RF, InData%activeL)
   call RegPackAlloc(RF, InData%activeD)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine UA_UnPackOtherState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(UA_OtherStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'UA_UnPackOtherState'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%FirstPass); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%sigma1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%sigma1c); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%sigma1m); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%sigma3); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%n); if (RegCheckErr(RF, RoutineName)) return
   LB(1:1) = lbound(OutData%xdot)
   UB(1:1) = ubound(OutData%xdot)
   do i1 = LB(1), UB(1)
      call UA_UnpackContState(RF, OutData%xdot(i1)) ! xdot 
   end do
   LB(1:1) = lbound(OutData%xHistory)
   UB(1:1) = ubound(OutData%xHistory)
   do i1 = LB(1), UB(1)
      call UA_UnpackContState(RF, OutData%xHistory(i1)) ! xHistory 
   end do
   call RegUnpackAlloc(RF, OutData%t_vortexBegin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%SignOfOmega); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PositivePressure); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%vortexOn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BelowThreshold); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%activeL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%activeD); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine UA_CopyMisc(SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg)
   type(UA_MiscVarType), intent(in) :: SrcMiscData
   type(UA_MiscVarType), intent(inout) :: DstMiscData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'UA_CopyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstMiscData%FirstWarn_M = SrcMiscData%FirstWarn_M
   DstMiscData%FirstWarn_UA = SrcMiscData%FirstWarn_UA
   DstMiscData%FirstWarn_UA_off = SrcMiscData%FirstWarn_UA_off
   if (allocated(SrcMiscData%TESF)) then
      LB(1:2) = lbound(SrcMiscData%TESF)
      UB(1:2) = ubound(SrcMiscData%TESF)
      if (.not. allocated(DstMiscData%TESF)) then
         allocate(DstMiscData%TESF(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%TESF.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%TESF = SrcMiscData%TESF
   end if
   if (allocated(SrcMiscData%LESF)) then
      LB(1:2) = lbound(SrcMiscData%LESF)
      UB(1:2) = ubound(SrcMiscData%LESF)
      if (.not. allocated(DstMiscData%LESF)) then
         allocate(DstMiscData%LESF(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%LESF.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%LESF = SrcMiscData%LESF
   end if
   if (allocated(SrcMiscData%VRTX)) then
      LB(1:2) = lbound(SrcMiscData%VRTX)
      UB(1:2) = ubound(SrcMiscData%VRTX)
      if (.not. allocated(DstMiscData%VRTX)) then
         allocate(DstMiscData%VRTX(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%VRTX.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%VRTX = SrcMiscData%VRTX
   end if
   if (allocated(SrcMiscData%T_Sh)) then
      LB(1:2) = lbound(SrcMiscData%T_Sh)
      UB(1:2) = ubound(SrcMiscData%T_Sh)
      if (.not. allocated(DstMiscData%T_Sh)) then
         allocate(DstMiscData%T_Sh(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%T_Sh.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%T_Sh = SrcMiscData%T_Sh
   end if
   if (allocated(SrcMiscData%BEDSEP)) then
      LB(1:2) = lbound(SrcMiscData%BEDSEP)
      UB(1:2) = ubound(SrcMiscData%BEDSEP)
      if (.not. allocated(DstMiscData%BEDSEP)) then
         allocate(DstMiscData%BEDSEP(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%BEDSEP.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%BEDSEP = SrcMiscData%BEDSEP
   end if
   if (allocated(SrcMiscData%weight)) then
      LB(1:2) = lbound(SrcMiscData%weight)
      UB(1:2) = ubound(SrcMiscData%weight)
      if (.not. allocated(DstMiscData%weight)) then
         allocate(DstMiscData%weight(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%weight.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%weight = SrcMiscData%weight
   end if
end subroutine

subroutine UA_DestroyMisc(MiscData, ErrStat, ErrMsg)
   type(UA_MiscVarType), intent(inout) :: MiscData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'UA_DestroyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(MiscData%TESF)) then
      deallocate(MiscData%TESF)
   end if
   if (allocated(MiscData%LESF)) then
      deallocate(MiscData%LESF)
   end if
   if (allocated(MiscData%VRTX)) then
      deallocate(MiscData%VRTX)
   end if
   if (allocated(MiscData%T_Sh)) then
      deallocate(MiscData%T_Sh)
   end if
   if (allocated(MiscData%BEDSEP)) then
      deallocate(MiscData%BEDSEP)
   end if
   if (allocated(MiscData%weight)) then
      deallocate(MiscData%weight)
   end if
end subroutine

subroutine UA_PackMisc(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(UA_MiscVarType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'UA_PackMisc'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%FirstWarn_M)
   call RegPack(RF, InData%FirstWarn_UA)
   call RegPack(RF, InData%FirstWarn_UA_off)
   call RegPackAlloc(RF, InData%TESF)
   call RegPackAlloc(RF, InData%LESF)
   call RegPackAlloc(RF, InData%VRTX)
   call RegPackAlloc(RF, InData%T_Sh)
   call RegPackAlloc(RF, InData%BEDSEP)
   call RegPackAlloc(RF, InData%weight)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine UA_UnPackMisc(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(UA_MiscVarType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'UA_UnPackMisc'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%FirstWarn_M); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FirstWarn_UA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FirstWarn_UA_off); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TESF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LESF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%VRTX); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%T_Sh); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BEDSEP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%weight); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine UA_CopyParam(SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg)
   type(UA_ParameterType), intent(in) :: SrcParamData
   type(UA_ParameterType), intent(inout) :: DstParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'UA_CopyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstParamData%dt = SrcParamData%dt
   if (allocated(SrcParamData%c)) then
      LB(1:2) = lbound(SrcParamData%c)
      UB(1:2) = ubound(SrcParamData%c)
      if (.not. allocated(DstParamData%c)) then
         allocate(DstParamData%c(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%c.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%c = SrcParamData%c
   end if
   DstParamData%d_34_to_ac = SrcParamData%d_34_to_ac
   DstParamData%numBlades = SrcParamData%numBlades
   DstParamData%nNodesPerBlade = SrcParamData%nNodesPerBlade
   DstParamData%UAMod = SrcParamData%UAMod
   DstParamData%Flookup = SrcParamData%Flookup
   DstParamData%a_s = SrcParamData%a_s
   DstParamData%NumOuts = SrcParamData%NumOuts
   DstParamData%OutSwtch = SrcParamData%OutSwtch
   DstParamData%OutFmt = SrcParamData%OutFmt
   DstParamData%OutSFmt = SrcParamData%OutSFmt
   DstParamData%Delim = SrcParamData%Delim
   DstParamData%UnOutFile = SrcParamData%UnOutFile
   DstParamData%ShedEffect = SrcParamData%ShedEffect
   DstParamData%lin_nx = SrcParamData%lin_nx
   if (allocated(SrcParamData%UA_off_forGood)) then
      LB(1:2) = lbound(SrcParamData%UA_off_forGood)
      UB(1:2) = ubound(SrcParamData%UA_off_forGood)
      if (.not. allocated(DstParamData%UA_off_forGood)) then
         allocate(DstParamData%UA_off_forGood(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%UA_off_forGood.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%UA_off_forGood = SrcParamData%UA_off_forGood
   end if
   if (allocated(SrcParamData%lin_xIndx)) then
      LB(1:2) = lbound(SrcParamData%lin_xIndx)
      UB(1:2) = ubound(SrcParamData%lin_xIndx)
      if (.not. allocated(DstParamData%lin_xIndx)) then
         allocate(DstParamData%lin_xIndx(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%lin_xIndx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%lin_xIndx = SrcParamData%lin_xIndx
   end if
   DstParamData%dx = SrcParamData%dx
   DstParamData%UA_OUTS = SrcParamData%UA_OUTS
   DstParamData%integrationMethod = SrcParamData%integrationMethod
end subroutine

subroutine UA_DestroyParam(ParamData, ErrStat, ErrMsg)
   type(UA_ParameterType), intent(inout) :: ParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'UA_DestroyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ParamData%c)) then
      deallocate(ParamData%c)
   end if
   if (allocated(ParamData%UA_off_forGood)) then
      deallocate(ParamData%UA_off_forGood)
   end if
   if (allocated(ParamData%lin_xIndx)) then
      deallocate(ParamData%lin_xIndx)
   end if
end subroutine

subroutine UA_PackParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(UA_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'UA_PackParam'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%dt)
   call RegPackAlloc(RF, InData%c)
   call RegPack(RF, InData%d_34_to_ac)
   call RegPack(RF, InData%numBlades)
   call RegPack(RF, InData%nNodesPerBlade)
   call RegPack(RF, InData%UAMod)
   call RegPack(RF, InData%Flookup)
   call RegPack(RF, InData%a_s)
   call RegPack(RF, InData%NumOuts)
   call RegPack(RF, InData%OutSwtch)
   call RegPack(RF, InData%OutFmt)
   call RegPack(RF, InData%OutSFmt)
   call RegPack(RF, InData%Delim)
   call RegPack(RF, InData%UnOutFile)
   call RegPack(RF, InData%ShedEffect)
   call RegPack(RF, InData%lin_nx)
   call RegPackAlloc(RF, InData%UA_off_forGood)
   call RegPackAlloc(RF, InData%lin_xIndx)
   call RegPack(RF, InData%dx)
   call RegPack(RF, InData%UA_OUTS)
   call RegPack(RF, InData%integrationMethod)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine UA_UnPackParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(UA_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'UA_UnPackParam'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%dt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%c); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%d_34_to_ac); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%numBlades); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nNodesPerBlade); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UAMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Flookup); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%a_s); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutSwtch); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutFmt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutSFmt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Delim); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UnOutFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ShedEffect); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%lin_nx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%UA_off_forGood); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%lin_xIndx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UA_OUTS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%integrationMethod); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine UA_CopyInput(SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg)
   type(UA_InputType), intent(in) :: SrcInputData
   type(UA_InputType), intent(inout) :: DstInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'UA_CopyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInputData%U = SrcInputData%U
   DstInputData%alpha = SrcInputData%alpha
   DstInputData%Re = SrcInputData%Re
   DstInputData%UserProp = SrcInputData%UserProp
   DstInputData%v_ac = SrcInputData%v_ac
   DstInputData%omega = SrcInputData%omega
end subroutine

subroutine UA_DestroyInput(InputData, ErrStat, ErrMsg)
   type(UA_InputType), intent(inout) :: InputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'UA_DestroyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine UA_PackInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(UA_InputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'UA_PackInput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%U)
   call RegPack(RF, InData%alpha)
   call RegPack(RF, InData%Re)
   call RegPack(RF, InData%UserProp)
   call RegPack(RF, InData%v_ac)
   call RegPack(RF, InData%omega)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine UA_UnPackInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(UA_InputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'UA_UnPackInput'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%U); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%alpha); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Re); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UserProp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%v_ac); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%omega); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine UA_CopyOutput(SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg)
   type(UA_OutputType), intent(in) :: SrcOutputData
   type(UA_OutputType), intent(inout) :: DstOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'UA_CopyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstOutputData%Cn = SrcOutputData%Cn
   DstOutputData%Cc = SrcOutputData%Cc
   DstOutputData%Cm = SrcOutputData%Cm
   DstOutputData%Cl = SrcOutputData%Cl
   DstOutputData%Cd = SrcOutputData%Cd
   if (allocated(SrcOutputData%WriteOutput)) then
      LB(1:1) = lbound(SrcOutputData%WriteOutput)
      UB(1:1) = ubound(SrcOutputData%WriteOutput)
      if (.not. allocated(DstOutputData%WriteOutput)) then
         allocate(DstOutputData%WriteOutput(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%WriteOutput.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%WriteOutput = SrcOutputData%WriteOutput
   end if
end subroutine

subroutine UA_DestroyOutput(OutputData, ErrStat, ErrMsg)
   type(UA_OutputType), intent(inout) :: OutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'UA_DestroyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(OutputData%WriteOutput)) then
      deallocate(OutputData%WriteOutput)
   end if
end subroutine

subroutine UA_PackOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(UA_OutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'UA_PackOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%Cn)
   call RegPack(RF, InData%Cc)
   call RegPack(RF, InData%Cm)
   call RegPack(RF, InData%Cl)
   call RegPack(RF, InData%Cd)
   call RegPackAlloc(RF, InData%WriteOutput)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine UA_UnPackOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(UA_OutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'UA_UnPackOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%Cn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cm); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutput); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine UA_Input_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
   ! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(UA_InputType), intent(in)  :: u(:) ! Input at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Inputs
   type(UA_InputType), intent(inout)  :: u_out ! Input at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'UA_Input_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(u)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(u)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(u) - 1
   select case (order)
   case (0)
      call UA_CopyInput(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call UA_Input_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call UA_Input_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(u) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE UA_Input_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

   TYPE(UA_InputType), INTENT(IN)  :: u1    ! Input at t1 > t2
   TYPE(UA_InputType), INTENT(IN)  :: u2    ! Input at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Inputs
   TYPE(UA_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'UA_Input_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   u_out%U = a1*u1%U + a2*u2%U
   CALL Angles_ExtrapInterp( u1%alpha, u2%alpha, tin, u_out%alpha, tin_out )
   u_out%Re = a1*u1%Re + a2*u2%Re
   u_out%UserProp = a1*u1%UserProp + a2*u2%UserProp
   u_out%v_ac = a1*u1%v_ac + a2*u2%v_ac
   u_out%omega = a1*u1%omega + a2*u2%omega
END SUBROUTINE

SUBROUTINE UA_Input_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

   TYPE(UA_InputType), INTENT(IN)  :: u1      ! Input at t1 > t2 > t3
   TYPE(UA_InputType), INTENT(IN)  :: u2      ! Input at t2 > t3
   TYPE(UA_InputType), INTENT(IN)  :: u3      ! Input at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Inputs
   TYPE(UA_InputType), INTENT(INOUT)  :: u_out     ! Input at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'UA_Input_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   u_out%U = a1*u1%U + a2*u2%U + a3*u3%U
   CALL Angles_ExtrapInterp( u1%alpha, u2%alpha, u3%alpha, tin, u_out%alpha, tin_out )
   u_out%Re = a1*u1%Re + a2*u2%Re + a3*u3%Re
   u_out%UserProp = a1*u1%UserProp + a2*u2%UserProp + a3*u3%UserProp
   u_out%v_ac = a1*u1%v_ac + a2*u2%v_ac + a3*u3%v_ac
   u_out%omega = a1*u1%omega + a2*u2%omega + a3*u3%omega
END SUBROUTINE

subroutine UA_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
   ! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(UA_OutputType), intent(in)  :: y(:) ! Output at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Outputs
   type(UA_OutputType), intent(inout)  :: y_out ! Output at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'UA_Output_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(y)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(y)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(y) - 1
   select case (order)
   case (0)
      call UA_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call UA_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call UA_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(y) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE UA_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

   TYPE(UA_OutputType), INTENT(IN)  :: y1    ! Output at t1 > t2
   TYPE(UA_OutputType), INTENT(IN)  :: y2    ! Output at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
   TYPE(UA_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'UA_Output_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   y_out%Cn = a1*y1%Cn + a2*y2%Cn
   y_out%Cc = a1*y1%Cc + a2*y2%Cc
   y_out%Cm = a1*y1%Cm + a2*y2%Cm
   y_out%Cl = a1*y1%Cl + a2*y2%Cl
   y_out%Cd = a1*y1%Cd + a2*y2%Cd
   IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
      y_out%WriteOutput = a1*y1%WriteOutput + a2*y2%WriteOutput
   END IF ! check if allocated
END SUBROUTINE

SUBROUTINE UA_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

   TYPE(UA_OutputType), INTENT(IN)  :: y1      ! Output at t1 > t2 > t3
   TYPE(UA_OutputType), INTENT(IN)  :: y2      ! Output at t2 > t3
   TYPE(UA_OutputType), INTENT(IN)  :: y3      ! Output at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
   TYPE(UA_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'UA_Output_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   y_out%Cn = a1*y1%Cn + a2*y2%Cn + a3*y3%Cn
   y_out%Cc = a1*y1%Cc + a2*y2%Cc + a3*y3%Cc
   y_out%Cm = a1*y1%Cm + a2*y2%Cm + a3*y3%Cm
   y_out%Cl = a1*y1%Cl + a2*y2%Cl + a3*y3%Cl
   y_out%Cd = a1*y1%Cd + a2*y2%Cd + a3*y3%Cd
   IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
      y_out%WriteOutput = a1*y1%WriteOutput + a2*y2%WriteOutput + a3*y3%WriteOutput
   END IF ! check if allocated
END SUBROUTINE
END MODULE UnsteadyAero_Types
!ENDOFREGISTRYGENERATEDFILE
