!STARTOFREGISTRYGENERATEDFILE 'FVW_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! FVW_Types
!.................................................................................................................................
! This file is part of FVW.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in FVW. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE FVW_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE AirfoilInfo_Types
USE UnsteadyAero_Types
USE NWTC_Library
IMPLICIT NONE
    INTEGER(IntKi), PUBLIC, PARAMETER  :: idGridVelocity = 1      ! Grid stores velocity field [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: idGridVelVorticity = 2      ! Grid stores velocity and vorticity [-]
! =========  GridOutType  =======
  TYPE, PUBLIC :: GridOutType
    CHARACTER(100)  :: name      !< Grid name [-]
    INTEGER(IntKi)  :: type = 0_IntKi      !< Grid type [-]
    REAL(ReKi)  :: tStart = 0.0_ReKi      !< Time at which outputs starts [-]
    REAL(ReKi)  :: tEnd = 0.0_ReKi      !< Time at which outputs ends [-]
    REAL(ReKi)  :: DTout = 0.0_ReKi      !< Output frequency of grid [-]
    REAL(ReKi)  :: xStart = 0.0_ReKi      !< xStart [-]
    REAL(ReKi)  :: yStart = 0.0_ReKi      !< yStart [-]
    REAL(ReKi)  :: zStart = 0.0_ReKi      !< zStart [-]
    REAL(ReKi)  :: xEnd = 0.0_ReKi      !< xEnd [-]
    REAL(ReKi)  :: yEnd = 0.0_ReKi      !< yEnd [-]
    REAL(ReKi)  :: zEnd = 0.0_ReKi      !< zEnd [-]
    INTEGER(IntKi)  :: nx = 0_IntKi      !< nx [-]
    INTEGER(IntKi)  :: ny = 0_IntKi      !< ny [-]
    INTEGER(IntKi)  :: nz = 0_IntKi      !< nz [-]
    REAL(ReKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: uGrid      !< Grid velocity 3 x nz x ny x nx [-]
    REAL(ReKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: omGrid      !< Grid vorticity 3 x nz x ny x nx [-]
    REAL(DbKi)  :: tLastOutput = 0.0_R8Ki      !< Last output time [-]
  END TYPE GridOutType
! =======================
! =========  T_Sgmt  =======
  TYPE, PUBLIC :: T_Sgmt
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Points      !< Points delimiting the segments [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: Connct      !< Connectivity of segments [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Gamma      !< Segment circulations [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Epsilon      !< Segment regularization parameter [-]
    INTEGER(IntKi)  :: RegFunction = 0_IntKi      !< Type of regularizaion function (LambOseen, Vatistas, see FVW_BiotSavart) [-]
    INTEGER(IntKi)  :: nAct = 0_IntKi      !< Number of active segments [-]
    INTEGER(IntKi)  :: nActP = 0_IntKi      !< Number of active segment points [-]
  END TYPE T_Sgmt
! =======================
! =========  T_Part  =======
  TYPE, PUBLIC :: T_Part
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: P      !< Particle Points [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Alpha      !< Particle intensity 3 x nP [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: RegParam      !< Particle regularization parameter [-]
    INTEGER(IntKi)  :: RegFunction = 0_IntKi      !< Type of regularizaion function (FVW_BiotSavart) [-]
    INTEGER(IntKi)  :: nAct = 0_IntKi      !< Number of active particles <=nP [-]
  END TYPE T_Part
! =======================
! =========  Wng_ParameterType  =======
  TYPE, PUBLIC :: Wng_ParameterType
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: chord_LL      !< Chord of each blade element from input file [idx1=BladeNode, idx2=Blade number] [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: chord_CP      !< Chord on LL cp  [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: s_LL      !< Spanwise coordinate of LL elements [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: s_CP      !< Spanwise coordinate of LL CP [m]
    INTEGER(IntKi)  :: iRotor = 0_IntKi      !< Index of rotor the wing belong to [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: AFindx      !< Index to the airfoils from AD15 [BladeNode,BladeIndex=1] [-]
    INTEGER(IntKi)  :: nSpan = 0_IntKi      !< TODO, should be defined per wing. Number of spanwise element [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: PrescribedCirculation      !< Prescribed circulation on all lifting lines [m/s]
  END TYPE Wng_ParameterType
! =======================
! =========  FVW_ParameterType  =======
  TYPE, PUBLIC :: FVW_ParameterType
    INTEGER(IntKi)  :: nRotors = 0_IntKi      !< Number of Wings [-]
    INTEGER(IntKi)  :: nWings = 0_IntKi      !< Number of Wings [-]
    TYPE(Wng_ParameterType) , DIMENSION(:), ALLOCATABLE  :: W      !< Wings parameters [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: Bld2Wings      !< Index mapping from blades to wings [-]
    INTEGER(IntKi)  :: iNWStart = 0_IntKi      !< Index where NW start in r_NW. (iNWStart=2, the first panel contains the lifting line panel, otherwise, start at 1) [-]
    INTEGER(IntKi)  :: nNWMax = 0_IntKi      !< Maximum number of nw panels, per wing [-]
    INTEGER(IntKi)  :: nNWFree = 0_IntKi      !< Number of nw panels that are free, per wing [-]
    INTEGER(IntKi)  :: nFWMax = 0_IntKi      !< Maximum number of fw panels, per wing [-]
    INTEGER(IntKi)  :: nFWFree = 0_IntKi      !< Number of fw panels that are free, per wing [-]
    LOGICAL  :: FWShedVorticity = .false.      !< Include shed vorticity in the far wake [-]
    INTEGER(IntKi)  :: IntMethod = 0_IntKi      !< Integration Method (1=RK4, 2=AB4, 3=ABM4, 5=Euler1) [-]
    REAL(ReKi)  :: FreeWakeStart = 0.0_ReKi      !< Time when wake starts convecting (rolling up) [s]
    REAL(ReKi)  :: FullCircStart = 0.0_ReKi      !< Time when the circulation is full [s]
    INTEGER(IntKi)  :: CircSolvMethod = 0_IntKi      !< Method to determine the circulation [-]
    INTEGER(IntKi)  :: CircSolvMaxIter = 0_IntKi      !< Maximum number of iterations for circulation solving [-]
    REAL(ReKi)  :: CircSolvConvCrit = 0.0_ReKi      !< Convergence criterion for circulation solving [-]
    REAL(ReKi)  :: CircSolvRelaxation = 0.0_ReKi      !< Relaxation factor for circulation solving [-]
    INTEGER(IntKi)  :: CircSolvPolar = 0_IntKi      !< (0=Use AD polars, 1=2PiAlpha, 2=sin(2pialpha) [-]
    INTEGER(IntKi)  :: DiffusionMethod = 0_IntKi      !< Diffusion method (None, CoreSpreading, PSE) [-]
    REAL(ReKi)  :: CoreSpreadEddyVisc = 0.0_ReKi      !< Eddy viscosity used in the core spreading method [-]
    INTEGER(IntKi)  :: RegDeterMethod = 0_IntKi      !< Regularization determinatino method (manual, automatic) [-]
    INTEGER(IntKi)  :: RegFunction = 0_IntKi      !< Type of regularizaion function (LambOseen, Vatistas, see FVW_BiotSavart) [-]
    INTEGER(IntKi)  :: WakeRegMethod = 0_IntKi      !< Method for regularization (constant, stretching, age, etc.) [-]
    REAL(ReKi)  :: WakeRegParam = 0.0_ReKi      !< Initial value of the regularization parameter [-]
    REAL(ReKi)  :: WingRegParam = 0.0_ReKi      !< Regularization parameter of the wing [-]
    INTEGER(IntKi)  :: ShearModel = 0_IntKi      !< Option for shear modelling [-]
    LOGICAL  :: TwrShadowOnWake = .false.      !< Include tower shadow effects on wake [-]
    INTEGER(IntKi) , DIMENSION(1:2)  :: VelocityMethod = 0_IntKi      !< Velocity calculation method for Full Wake and for LiftingLine [-]
    REAL(ReKi) , DIMENSION(1:2)  :: TreeBranchFactor = 0.0_ReKi      !< Factor used to determine if a point is far enough, for full wake and lifting line [-]
    INTEGER(IntKi) , DIMENSION(1:2)  :: PartPerSegment = 0_IntKi      !< Number of particles per segment, e.g. for tree method, for full wake and lifting line [-]
    REAL(DbKi)  :: DTaero = 0.0_R8Ki      !< Time interval for calls calculations [s]
    REAL(DbKi)  :: DTfvw = 0.0_R8Ki      !< Time interval for calculating wake induced velocities [s]
    REAL(ReKi)  :: KinVisc = 0.0_ReKi      !< Kinematic air viscosity [m^2/s]
    INTEGER(IntKi)  :: MHK = 0_IntKi      !< MHK flag [-]
    REAL(ReKi)  :: WtrDpth = 0.0_ReKi      !< Water depth [m]
    INTEGER(IntKi)  :: WrVTK = 0_IntKi      !< Outputs VTK at each calcoutput call, even if main fst doesnt do it [-]
    INTEGER(IntKi)  :: VTKBlades = 0_IntKi      !< Outputs VTk for each blade 0=no blade, 1=Bld 1 [-]
    REAL(DbKi)  :: DTvtk = 0.0_R8Ki      !< DT between vtk writes [s]
    INTEGER(IntKi)  :: VTKCoord = 0_IntKi      !< Switch for VTK outputs coordinate  system [-]
    CHARACTER(1024)  :: RootName      !< RootName for writing output files [-]
    CHARACTER(1024)  :: VTK_OutFileRoot      !< Rootdirectory for writing VTK files [-]
    CHARACTER(1024)  :: VTK_OutFileBase      !< Basename for writing VTK files [-]
    INTEGER(IntKi)  :: nGridOut = 0_IntKi      !< Number of VTK grid to output [-]
    LOGICAL  :: InductionAtCP = .true.      !< Compute induced velocities at nodes or CP [-]
    LOGICAL  :: WakeAtTE = .true.      !< Start the wake at the trailing edge, or at the LL [-]
    LOGICAL  :: DStallOnWake = .false.      !< Dynamic stall has influence on wake [-]
    LOGICAL  :: Induction = .true.      !< Compute induction [-]
    REAL(ReKi)  :: kFrozenNWStart = 0.75      !< Fraction of wake induced velocity at start of frozen wake. 1 seems too strong. [-]
    REAL(ReKi)  :: kFrozenNWEnd = 0.5      !< Fraction of wake induced velocity at end of frozen wake [-]
  END TYPE FVW_ParameterType
! =======================
! =========  Wng_ContinuousStateType  =======
  TYPE, PUBLIC :: Wng_ContinuousStateType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Gamma_NW      !< Circulation of the near wake panels (    nSpan     x nNW  ) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Gamma_FW      !< Circulation of the far  wake panels (    nFWSpan   x nFW  ) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Eps_NW      !< Reg param   of the near wake panels (3 x nSpan     x nNW  ) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Eps_FW      !< Reg param   of the far  wake panels (3 x nFWSpan   x nFW  ) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: r_NW      !< Position    of the near wake panels (3 x nSpan+1   x nNW+1)  [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: r_FW      !< Position    of the far  wake panels (3 x nFWSpan+1 x nFW+1) [-]
  END TYPE Wng_ContinuousStateType
! =======================
! =========  FVW_ContinuousStateType  =======
  TYPE, PUBLIC :: FVW_ContinuousStateType
    TYPE(Wng_ContinuousStateType) , DIMENSION(:), ALLOCATABLE  :: W      !< Circulation of the near wake panels (    nSpan     x nNW ) [-]
    TYPE(UA_ContinuousStateType) , DIMENSION(:), ALLOCATABLE  :: UA      !< states for UnsteadyAero [-]
  END TYPE FVW_ContinuousStateType
! =======================
! =========  Wng_OutputType  =======
  TYPE, PUBLIC :: Wng_OutputType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Vind      !< TODO mesh  - Induced velocity vector at AeroDyn nodes.  [-]
  END TYPE Wng_OutputType
! =======================
! =========  FVW_OutputType  =======
  TYPE, PUBLIC :: FVW_OutputType
    TYPE(Wng_OutputType) , DIMENSION(:), ALLOCATABLE  :: W      !< Induced velocity vector at AeroDyn nodes for all wings.  [-]
  END TYPE FVW_OutputType
! =======================
! =========  Wng_MiscVarType  =======
  TYPE, PUBLIC :: Wng_MiscVarType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: LE      !< Leading edge points [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: TE      !< Trailing edge points [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: r_LL      !< Position    of the Lifting line panels [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: CP      !< Coordinates of LL CP [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Tang      !< Unit Tangential vector on LL CP [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Norm      !< Unit Normal vector on LL CP     [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Orth      !< Unit Orthogonal vector on LL CP [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: dl      !< Vector of elementary length along the LL [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Area      !< Area of each LL panel [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: diag_LL      !< Diagonal length of each LL panel [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Vind_CP      !< Induced velocity on lifting line control points [m/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Vtot_CP      !< Total velocity on lifting line control points [m/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Vstr_CP      !< Structural velocity on LL CP [m/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Vwnd_CP      !< Wind on lifting line control points [m/s]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Vwnd_NW      !< Wind on near wake panels [m/s]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Vwnd_FW      !< Wind on far  wake panels [m/s]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Vind_NW      !< Induced velocity on near wake panels [m/s]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Vind_FW      !< Induced velocity on far  wake panels [m/s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: PitchAndTwist      !< Twist angle (includes all sources of twist)  [Array of size (NumBlNds,numBlades)] [rad]
    INTEGER(IntKi)  :: iTip = 0_IntKi      !< Index where tip vorticity will be placed. TODO, per blade [-]
    INTEGER(IntKi)  :: iRoot = 0_IntKi      !< Index where root vorticity will be placed [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: alpha_LL      !< Angle of attack at lifting line CP, only computed with CircPolarData method [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Vreln_LL      !< Norm of Vrel on the lifting line [-]
    TYPE(UA_InputType) , DIMENSION(:,:), ALLOCATABLE  :: u_UA      !< inputs to UnsteadyAero  numNode x 2 (t and t+dt) [-]
    TYPE(UA_MiscVarType)  :: m_UA      !< misc vars for UnsteadyAero [-]
    TYPE(UA_OutputType)  :: y_UA      !< outputs from UnsteadyAero [-]
    TYPE(UA_ParameterType)  :: p_UA      !< parameters for UnsteadyAero [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Vind_LL      !< Induced velocity on lifting line nodes [m/s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BN_AxInd      !< Axial induction [size (NumBlNds,numBlades)] [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BN_TanInd      !< Tangential induction [size (NumBlNds,numBlades)] [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BN_Vrel      !< Relative velocity [size (NumBlNds,numBlades)] [m/s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BN_alpha      !< Angle of attack [size (NumBlNds,numBlades)] [rad]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BN_phi      !< angle between the plane of rotation and the direction of the local wind [size (NumBlNds,numBlades)] [rad]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BN_Re      !< Reynolds number [size (NumBlNds,numBlades)] [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: BN_URelWind_s      !< Relative wind velocity in section coordinates [size (3,NumBlNds,numBlades)] [m/s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BN_Cl_Static      !< Coefficient lift,   excluding unsteady aero effects [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BN_Cd_Static      !< Coefficient drag.   excluding unsteady aero effects [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BN_Cm_Static      !< Coefficient moment, excluding unsteady aero effects [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BN_Cpmin      !< Coefficient minimum pressure, excluding unsteady aero effects [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BN_Cl      !< Coefficient lift,   including unsteady aero effects [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BN_Cd      !< Coefficient drag,   including unsteady aero effects [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BN_Cm      !< Coefficient moment, including unsteady aero effects [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BN_Cx      !< normal force coefficient (normal to the plane, not chord) of the jth node in the kth blade [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BN_Cy      !< tangential force coefficient (tangential to the plane, not chord) of the jth node in the kth blade [-]
  END TYPE Wng_MiscVarType
! =======================
! =========  FVW_MiscVarType  =======
  TYPE, PUBLIC :: FVW_MiscVarType
    TYPE(Wng_MiscVarType) , DIMENSION(:), ALLOCATABLE  :: W      !< Misc for all wings [-]
    LOGICAL  :: FirstCall = .false.      !< True if this is the first call to update state (used in CalcOutput) [-]
    INTEGER(IntKi)  :: nNW = 0_IntKi      !< Number of active near wake panels [-]
    INTEGER(IntKi)  :: nFW = 0_IntKi      !< Number of active far  wake panels [-]
    INTEGER(IntKi)  :: iStep = 0_IntKi      !< Current step number used for update state [-]
    INTEGER(IntKi)  :: VTKstep = 0_IntKi      !< Current vtk output step number [-]
    REAL(DbKi)  :: VTKlastTime = 0.0_R8Ki      !< Time the last VTK file set was written out [s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: r_wind      !< List of points where wind is requested for next time step [-]
    LOGICAL  :: ComputeWakeInduced = .false.      !< Compute induced velocities on this timestep [-]
    REAL(DbKi)  :: OldWakeTime = 0.0_R8Ki      !< Time the wake induction velocities were last calculated [s]
    TYPE(FVW_ContinuousStateType)  :: dxdt      !< State time derivatie, stored for overcycling and convenience [-]
    TYPE(FVW_ContinuousStateType)  :: x1      !< States at t (for overcycling)  [-]
    TYPE(FVW_ContinuousStateType)  :: x2      !< States at t+DTFVW (for overcycling) [-]
    REAL(DbKi)  :: t1 = 0.0_R8Ki      !< Time of x1 (for overcycling)  [-]
    REAL(DbKi)  :: t2 = 0.0_R8Ki      !< Time of x2 t+DTFVW (for overcycling) [-]
    LOGICAL  :: UA_Flag = .false.      !< logical flag indicating whether to use UnsteadyAero [-]
    TYPE(T_Sgmt)  :: Sgmt      !< Segments storage [-]
    TYPE(T_Part)  :: Part      !< Particle storage [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: CPs      !< Control points used for wake rollup computation [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Uind      !< Induced velocities obtained at control points [-]
    TYPE(GridOutType) , DIMENSION(:), ALLOCATABLE  :: GridOutputs      !< Number of VTK grid to output [-]
    LOGICAL  :: InfoReeval = .true.      !< Give info about Reevaluation: gets set to false after first info statement [-]
  END TYPE FVW_MiscVarType
! =======================
! =========  Rot_InputType  =======
  TYPE, PUBLIC :: Rot_InputType
    REAL(ReKi) , DIMENSION(1:3,1:3)  :: HubOrientation = 0.0_ReKi      !< Orientation of hub coordinate system (for output only) [-]
    REAL(ReKi) , DIMENSION(1:3)  :: HubPosition = 0.0_ReKi      !< Origin of hub (for output only) [-]
  END TYPE Rot_InputType
! =======================
! =========  Wng_InputType  =======
  TYPE, PUBLIC :: Wng_InputType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Vwnd_LL      !< Disturbed wind at LL mesh points (not CP), for UA only [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: omega_z      !< rotation of no-sweep-pitch-twist coordinate system around z (for CDBEMT and CUA) [rad/s]
  END TYPE Wng_InputType
! =======================
! =========  FVW_InputType  =======
  TYPE, PUBLIC :: FVW_InputType
    TYPE(Rot_InputType) , DIMENSION(:), ALLOCATABLE  :: rotors      !< Rotors inputs [-]
    TYPE(Wng_InputType) , DIMENSION(:), ALLOCATABLE  :: W      !< Wings inputs [-]
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: WingsMesh      !< Input Mesh defining position and orientation of wings (nSpan+1)  [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: V_wind      !< Wind at requested points (r_wind) [-]
  END TYPE FVW_InputType
! =======================
! =========  FVW_DiscreteStateType  =======
  TYPE, PUBLIC :: FVW_DiscreteStateType
    REAL(ReKi)  :: Dummy = 0.0_ReKi      !< Empty to satisfy framework [-]
    TYPE(UA_DiscreteStateType) , DIMENSION(:), ALLOCATABLE  :: UA      !< states for UnsteadyAero for each Wing [-]
  END TYPE FVW_DiscreteStateType
! =======================
! =========  Wng_ConstraintStateType  =======
  TYPE, PUBLIC :: Wng_ConstraintStateType
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Gamma_LL      !< Circulation on the wing lifting line [-]
  END TYPE Wng_ConstraintStateType
! =======================
! =========  FVW_ConstraintStateType  =======
  TYPE, PUBLIC :: FVW_ConstraintStateType
    TYPE(Wng_ConstraintStateType) , DIMENSION(:), ALLOCATABLE  :: W      !< rotors constr. states [-]
    REAL(ReKi)  :: residual = 0.0_ReKi      !< Residual [-]
  END TYPE FVW_ConstraintStateType
! =======================
! =========  FVW_OtherStateType  =======
  TYPE, PUBLIC :: FVW_OtherStateType
    INTEGER(IntKi)  :: Dummy = 0_IntKi      !< Empty to satisfy framework [-]
    TYPE(UA_OtherStateType) , DIMENSION(:), ALLOCATABLE  :: UA      !< other states for UnsteadyAero for each wing [-]
  END TYPE FVW_OtherStateType
! =======================
! =========  Wng_InitInputType  =======
  TYPE, PUBLIC :: Wng_InitInputType
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: AFindx      !< Index to the airfoils from AD15 [idx1=BladeNode, idx2=Blade number=1] [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: chord      !< Chord of each blade element from input file [idx1=BladeNode, idx2=Blade number] [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: RElm      !< radius of center of each element [-]
    INTEGER(IntKi)  :: iRotor = 0_IntKi      !< Index of rotor the wing belong to [-]
    INTEGER(IntKi)  :: UAOff_innerNode = 0_IntKi      !< Last node on each blade where UA should be turned off based on span location from blade root (0 if always on) [-]
    INTEGER(IntKi)  :: UAOff_outerNode = 0_IntKi      !< First node on each blade where UA should be turned off based on span location from blade tip (>nNodesPerBlade if always on) [-]
  END TYPE Wng_InitInputType
! =======================
! =========  FVW_InitInputType  =======
  TYPE, PUBLIC :: FVW_InitInputType
    CHARACTER(1024)  :: FVWFileName      !< Main FVW input file name [-]
    CHARACTER(1024)  :: RootName      !< RootName for writing output files [-]
    TYPE(Wng_InitInputType) , DIMENSION(:), ALLOCATABLE  :: W      !< Number of blades [-]
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: WingsMesh      !< Input Mesh defining position and orientation of wings (nSpan+1)  [-]
    INTEGER(IntKi)  :: numBladeNodes = 0_IntKi      !< Number of nodes on each blade [-]
    REAL(DbKi)  :: DTaero = 0.0_R8Ki      !< Time interval for calls (from AD15) [s]
    REAL(ReKi)  :: KinVisc = 0.0_ReKi      !< Kinematic air viscosity [m^2/s]
    INTEGER(IntKi)  :: MHK = 0_IntKi      !< MHK flag [-]
    REAL(ReKi)  :: WtrDpth = 0.0_ReKi      !< Water depth [m]
    LOGICAL  :: UA_Flag = .false.      !< logical flag indicating whether to use UnsteadyAero [-]
    TYPE(UA_InitInputType)  :: UA_Init      !< InitInput data for UA model [-]
  END TYPE FVW_InitInputType
! =======================
! =========  FVW_InputFile  =======
  TYPE, PUBLIC :: FVW_InputFile
    INTEGER(IntKi)  :: CircSolvMethod = 0_IntKi      !< Method to determine the circulation [-]
    CHARACTER(1024)  :: CirculationFile      !< Prescribed circulation file [-]
    INTEGER(IntKi)  :: CircSolvMaxIter = 0_IntKi      !< Maximum number of iterations for circulation solving [-]
    REAL(ReKi)  :: CircSolvConvCrit = 0.0_ReKi      !< Convergence criterion for circulation solving [-]
    REAL(ReKi)  :: CircSolvRelaxation = 0.0_ReKi      !< Relaxation factor for circulation solving [-]
    INTEGER(IntKi)  :: IntMethod = 0_IntKi      !< Integration Method (1=RK4, 2=AB4, 3=ABM4, 5=Euler1, 7=Corrector/Predictor) [-]
    LOGICAL  :: FreeWake = .false.      !< Disable roll up, wake convects with wind only (flag) [-]
    REAL(ReKi)  :: FreeWakeStart = 0.0_ReKi      !< Time when wake starts convecting (rolling up) [s]
    REAL(ReKi)  :: FullCircStart = 0.0_ReKi      !< Time when the circulation is full [s]
    REAL(DbKi)  :: DTfvw = 0.0_R8Ki      !< Time interval for calculating wake induced velocities [s]
    INTEGER(IntKi)  :: CircSolvPolar = 0_IntKi      !< (0=Use AD polars, 1=2PiAlpha, 2=sin(2pialpha) [-]
    INTEGER(IntKi)  :: nNWPanels = 0_IntKi      !< Number of nw panels [-]
    INTEGER(IntKi)  :: nNWPanelsFree = 0_IntKi      !< Number of nw panels [-]
    INTEGER(IntKi)  :: nFWPanels = 0_IntKi      !< Number of fw panels [-]
    INTEGER(IntKi)  :: nFWPanelsFree = 0_IntKi      !< Number of fw panels that are free [-]
    LOGICAL  :: FWShedVorticity = .false.      !< Include shed vorticity in the far wake [-]
    INTEGER(IntKi)  :: DiffusionMethod = 0_IntKi      !< Diffusion method (None, CoreSpreading, PSE) [-]
    REAL(ReKi)  :: CoreSpreadEddyVisc = 0.0_ReKi      !< Eddy viscosity used in the core spreading method [-]
    INTEGER(IntKi)  :: RegDeterMethod = 0_IntKi      !< Regularization determinatino method (manual, automatic) [-]
    INTEGER(IntKi)  :: RegFunction = 0_IntKi      !< Type of regularizaion function (LambOseen, Vatistas, see FVW_BiotSavart) [-]
    INTEGER(IntKi)  :: WakeRegMethod = 0_IntKi      !< Method for regularization (constant, stretching, age, etc.) [-]
    REAL(ReKi)  :: WakeRegParam = 0.0_ReKi      !< Factor used in the regularization  [-]
    REAL(ReKi)  :: WingRegParam = 0.0_ReKi      !< Factor used in the regularization  [-]
    INTEGER(IntKi)  :: ShearModel = 0_IntKi      !< Option for shear modelling [-]
    LOGICAL  :: TwrShadowOnWake = .false.      !< Include tower shadow effects on wake [-]
    INTEGER(IntKi) , DIMENSION(1:2)  :: VelocityMethod = 0_IntKi      !< Velocity calculation method for Full Wake and for LiftingLine [-]
    REAL(ReKi) , DIMENSION(1:2)  :: TreeBranchFactor = 0.0_ReKi      !< Factor used to determine if a point is far enough, for full wake and lifting line [-]
    INTEGER(IntKi) , DIMENSION(1:2)  :: PartPerSegment = 0_IntKi      !< Number of particles per segment, e.g. for tree method, for full wake and lifting line [-]
    INTEGER(IntKi)  :: WrVTK = 0_IntKi      !< Outputs VTK at each calcoutput call, even if main fst doesnt do it [-]
    INTEGER(IntKi)  :: VTKBlades = 0_IntKi      !< Outputs VTk for each blade 0=no blade, 1=Bld 1 [-]
    REAL(DbKi)  :: DTvtk = 0.0_R8Ki      !< Requested timestep between VTK outputs (calculated from the VTK_fps read in) [s]
    INTEGER(IntKi)  :: VTKCoord = 0_IntKi      !< Switch for VTK outputs coordinate  system [-]
  END TYPE FVW_InputFile
! =======================
! =========  FVW_InitOutputType  =======
  TYPE, PUBLIC :: FVW_InitOutputType
    INTEGER(IntKi)  :: Dummy = 0_IntKi      !< Empty parameter to satisfy framework [-]
  END TYPE FVW_InitOutputType
! =======================
CONTAINS

subroutine FVW_CopyGridOutType(SrcGridOutTypeData, DstGridOutTypeData, CtrlCode, ErrStat, ErrMsg)
   type(GridOutType), intent(in) :: SrcGridOutTypeData
   type(GridOutType), intent(inout) :: DstGridOutTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(4), UB(4)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'FVW_CopyGridOutType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstGridOutTypeData%name = SrcGridOutTypeData%name
   DstGridOutTypeData%type = SrcGridOutTypeData%type
   DstGridOutTypeData%tStart = SrcGridOutTypeData%tStart
   DstGridOutTypeData%tEnd = SrcGridOutTypeData%tEnd
   DstGridOutTypeData%DTout = SrcGridOutTypeData%DTout
   DstGridOutTypeData%xStart = SrcGridOutTypeData%xStart
   DstGridOutTypeData%yStart = SrcGridOutTypeData%yStart
   DstGridOutTypeData%zStart = SrcGridOutTypeData%zStart
   DstGridOutTypeData%xEnd = SrcGridOutTypeData%xEnd
   DstGridOutTypeData%yEnd = SrcGridOutTypeData%yEnd
   DstGridOutTypeData%zEnd = SrcGridOutTypeData%zEnd
   DstGridOutTypeData%nx = SrcGridOutTypeData%nx
   DstGridOutTypeData%ny = SrcGridOutTypeData%ny
   DstGridOutTypeData%nz = SrcGridOutTypeData%nz
   if (allocated(SrcGridOutTypeData%uGrid)) then
      LB(1:4) = lbound(SrcGridOutTypeData%uGrid)
      UB(1:4) = ubound(SrcGridOutTypeData%uGrid)
      if (.not. allocated(DstGridOutTypeData%uGrid)) then
         allocate(DstGridOutTypeData%uGrid(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstGridOutTypeData%uGrid.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstGridOutTypeData%uGrid = SrcGridOutTypeData%uGrid
   end if
   if (allocated(SrcGridOutTypeData%omGrid)) then
      LB(1:4) = lbound(SrcGridOutTypeData%omGrid)
      UB(1:4) = ubound(SrcGridOutTypeData%omGrid)
      if (.not. allocated(DstGridOutTypeData%omGrid)) then
         allocate(DstGridOutTypeData%omGrid(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstGridOutTypeData%omGrid.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstGridOutTypeData%omGrid = SrcGridOutTypeData%omGrid
   end if
   DstGridOutTypeData%tLastOutput = SrcGridOutTypeData%tLastOutput
end subroutine

subroutine FVW_DestroyGridOutType(GridOutTypeData, ErrStat, ErrMsg)
   type(GridOutType), intent(inout) :: GridOutTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FVW_DestroyGridOutType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(GridOutTypeData%uGrid)) then
      deallocate(GridOutTypeData%uGrid)
   end if
   if (allocated(GridOutTypeData%omGrid)) then
      deallocate(GridOutTypeData%omGrid)
   end if
end subroutine

subroutine FVW_PackGridOutType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(GridOutType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FVW_PackGridOutType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%name)
   call RegPack(RF, InData%type)
   call RegPack(RF, InData%tStart)
   call RegPack(RF, InData%tEnd)
   call RegPack(RF, InData%DTout)
   call RegPack(RF, InData%xStart)
   call RegPack(RF, InData%yStart)
   call RegPack(RF, InData%zStart)
   call RegPack(RF, InData%xEnd)
   call RegPack(RF, InData%yEnd)
   call RegPack(RF, InData%zEnd)
   call RegPack(RF, InData%nx)
   call RegPack(RF, InData%ny)
   call RegPack(RF, InData%nz)
   call RegPackAlloc(RF, InData%uGrid)
   call RegPackAlloc(RF, InData%omGrid)
   call RegPack(RF, InData%tLastOutput)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FVW_UnPackGridOutType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(GridOutType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FVW_UnPackGridOutType'
   integer(B4Ki)   :: LB(4), UB(4)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%name); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%type); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%tStart); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%tEnd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DTout); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%xStart); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%yStart); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%zStart); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%xEnd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%yEnd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%zEnd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ny); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nz); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%uGrid); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%omGrid); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%tLastOutput); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FVW_CopyT_Sgmt(SrcT_SgmtData, DstT_SgmtData, CtrlCode, ErrStat, ErrMsg)
   type(T_Sgmt), intent(in) :: SrcT_SgmtData
   type(T_Sgmt), intent(inout) :: DstT_SgmtData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'FVW_CopyT_Sgmt'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcT_SgmtData%Points)) then
      LB(1:2) = lbound(SrcT_SgmtData%Points)
      UB(1:2) = ubound(SrcT_SgmtData%Points)
      if (.not. allocated(DstT_SgmtData%Points)) then
         allocate(DstT_SgmtData%Points(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstT_SgmtData%Points.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstT_SgmtData%Points = SrcT_SgmtData%Points
   end if
   if (allocated(SrcT_SgmtData%Connct)) then
      LB(1:2) = lbound(SrcT_SgmtData%Connct)
      UB(1:2) = ubound(SrcT_SgmtData%Connct)
      if (.not. allocated(DstT_SgmtData%Connct)) then
         allocate(DstT_SgmtData%Connct(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstT_SgmtData%Connct.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstT_SgmtData%Connct = SrcT_SgmtData%Connct
   end if
   if (allocated(SrcT_SgmtData%Gamma)) then
      LB(1:1) = lbound(SrcT_SgmtData%Gamma)
      UB(1:1) = ubound(SrcT_SgmtData%Gamma)
      if (.not. allocated(DstT_SgmtData%Gamma)) then
         allocate(DstT_SgmtData%Gamma(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstT_SgmtData%Gamma.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstT_SgmtData%Gamma = SrcT_SgmtData%Gamma
   end if
   if (allocated(SrcT_SgmtData%Epsilon)) then
      LB(1:1) = lbound(SrcT_SgmtData%Epsilon)
      UB(1:1) = ubound(SrcT_SgmtData%Epsilon)
      if (.not. allocated(DstT_SgmtData%Epsilon)) then
         allocate(DstT_SgmtData%Epsilon(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstT_SgmtData%Epsilon.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstT_SgmtData%Epsilon = SrcT_SgmtData%Epsilon
   end if
   DstT_SgmtData%RegFunction = SrcT_SgmtData%RegFunction
   DstT_SgmtData%nAct = SrcT_SgmtData%nAct
   DstT_SgmtData%nActP = SrcT_SgmtData%nActP
end subroutine

subroutine FVW_DestroyT_Sgmt(T_SgmtData, ErrStat, ErrMsg)
   type(T_Sgmt), intent(inout) :: T_SgmtData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FVW_DestroyT_Sgmt'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(T_SgmtData%Points)) then
      deallocate(T_SgmtData%Points)
   end if
   if (allocated(T_SgmtData%Connct)) then
      deallocate(T_SgmtData%Connct)
   end if
   if (allocated(T_SgmtData%Gamma)) then
      deallocate(T_SgmtData%Gamma)
   end if
   if (allocated(T_SgmtData%Epsilon)) then
      deallocate(T_SgmtData%Epsilon)
   end if
end subroutine

subroutine FVW_PackT_Sgmt(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(T_Sgmt), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FVW_PackT_Sgmt'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%Points)
   call RegPackAlloc(RF, InData%Connct)
   call RegPackAlloc(RF, InData%Gamma)
   call RegPackAlloc(RF, InData%Epsilon)
   call RegPack(RF, InData%RegFunction)
   call RegPack(RF, InData%nAct)
   call RegPack(RF, InData%nActP)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FVW_UnPackT_Sgmt(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(T_Sgmt), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FVW_UnPackT_Sgmt'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%Points); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Connct); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Gamma); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Epsilon); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RegFunction); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nAct); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nActP); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FVW_CopyT_Part(SrcT_PartData, DstT_PartData, CtrlCode, ErrStat, ErrMsg)
   type(T_Part), intent(in) :: SrcT_PartData
   type(T_Part), intent(inout) :: DstT_PartData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'FVW_CopyT_Part'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcT_PartData%P)) then
      LB(1:2) = lbound(SrcT_PartData%P)
      UB(1:2) = ubound(SrcT_PartData%P)
      if (.not. allocated(DstT_PartData%P)) then
         allocate(DstT_PartData%P(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstT_PartData%P.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstT_PartData%P = SrcT_PartData%P
   end if
   if (allocated(SrcT_PartData%Alpha)) then
      LB(1:2) = lbound(SrcT_PartData%Alpha)
      UB(1:2) = ubound(SrcT_PartData%Alpha)
      if (.not. allocated(DstT_PartData%Alpha)) then
         allocate(DstT_PartData%Alpha(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstT_PartData%Alpha.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstT_PartData%Alpha = SrcT_PartData%Alpha
   end if
   if (allocated(SrcT_PartData%RegParam)) then
      LB(1:1) = lbound(SrcT_PartData%RegParam)
      UB(1:1) = ubound(SrcT_PartData%RegParam)
      if (.not. allocated(DstT_PartData%RegParam)) then
         allocate(DstT_PartData%RegParam(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstT_PartData%RegParam.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstT_PartData%RegParam = SrcT_PartData%RegParam
   end if
   DstT_PartData%RegFunction = SrcT_PartData%RegFunction
   DstT_PartData%nAct = SrcT_PartData%nAct
end subroutine

subroutine FVW_DestroyT_Part(T_PartData, ErrStat, ErrMsg)
   type(T_Part), intent(inout) :: T_PartData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FVW_DestroyT_Part'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(T_PartData%P)) then
      deallocate(T_PartData%P)
   end if
   if (allocated(T_PartData%Alpha)) then
      deallocate(T_PartData%Alpha)
   end if
   if (allocated(T_PartData%RegParam)) then
      deallocate(T_PartData%RegParam)
   end if
end subroutine

subroutine FVW_PackT_Part(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(T_Part), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FVW_PackT_Part'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%P)
   call RegPackAlloc(RF, InData%Alpha)
   call RegPackAlloc(RF, InData%RegParam)
   call RegPack(RF, InData%RegFunction)
   call RegPack(RF, InData%nAct)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FVW_UnPackT_Part(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(T_Part), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FVW_UnPackT_Part'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%P); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Alpha); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RegParam); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RegFunction); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nAct); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FVW_CopyWng_ParameterType(SrcWng_ParameterTypeData, DstWng_ParameterTypeData, CtrlCode, ErrStat, ErrMsg)
   type(Wng_ParameterType), intent(in) :: SrcWng_ParameterTypeData
   type(Wng_ParameterType), intent(inout) :: DstWng_ParameterTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'FVW_CopyWng_ParameterType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcWng_ParameterTypeData%chord_LL)) then
      LB(1:1) = lbound(SrcWng_ParameterTypeData%chord_LL)
      UB(1:1) = ubound(SrcWng_ParameterTypeData%chord_LL)
      if (.not. allocated(DstWng_ParameterTypeData%chord_LL)) then
         allocate(DstWng_ParameterTypeData%chord_LL(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_ParameterTypeData%chord_LL.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_ParameterTypeData%chord_LL = SrcWng_ParameterTypeData%chord_LL
   end if
   if (allocated(SrcWng_ParameterTypeData%chord_CP)) then
      LB(1:1) = lbound(SrcWng_ParameterTypeData%chord_CP)
      UB(1:1) = ubound(SrcWng_ParameterTypeData%chord_CP)
      if (.not. allocated(DstWng_ParameterTypeData%chord_CP)) then
         allocate(DstWng_ParameterTypeData%chord_CP(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_ParameterTypeData%chord_CP.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_ParameterTypeData%chord_CP = SrcWng_ParameterTypeData%chord_CP
   end if
   if (allocated(SrcWng_ParameterTypeData%s_LL)) then
      LB(1:1) = lbound(SrcWng_ParameterTypeData%s_LL)
      UB(1:1) = ubound(SrcWng_ParameterTypeData%s_LL)
      if (.not. allocated(DstWng_ParameterTypeData%s_LL)) then
         allocate(DstWng_ParameterTypeData%s_LL(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_ParameterTypeData%s_LL.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_ParameterTypeData%s_LL = SrcWng_ParameterTypeData%s_LL
   end if
   if (allocated(SrcWng_ParameterTypeData%s_CP)) then
      LB(1:1) = lbound(SrcWng_ParameterTypeData%s_CP)
      UB(1:1) = ubound(SrcWng_ParameterTypeData%s_CP)
      if (.not. allocated(DstWng_ParameterTypeData%s_CP)) then
         allocate(DstWng_ParameterTypeData%s_CP(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_ParameterTypeData%s_CP.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_ParameterTypeData%s_CP = SrcWng_ParameterTypeData%s_CP
   end if
   DstWng_ParameterTypeData%iRotor = SrcWng_ParameterTypeData%iRotor
   if (allocated(SrcWng_ParameterTypeData%AFindx)) then
      LB(1:2) = lbound(SrcWng_ParameterTypeData%AFindx)
      UB(1:2) = ubound(SrcWng_ParameterTypeData%AFindx)
      if (.not. allocated(DstWng_ParameterTypeData%AFindx)) then
         allocate(DstWng_ParameterTypeData%AFindx(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_ParameterTypeData%AFindx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_ParameterTypeData%AFindx = SrcWng_ParameterTypeData%AFindx
   end if
   DstWng_ParameterTypeData%nSpan = SrcWng_ParameterTypeData%nSpan
   if (allocated(SrcWng_ParameterTypeData%PrescribedCirculation)) then
      LB(1:1) = lbound(SrcWng_ParameterTypeData%PrescribedCirculation)
      UB(1:1) = ubound(SrcWng_ParameterTypeData%PrescribedCirculation)
      if (.not. allocated(DstWng_ParameterTypeData%PrescribedCirculation)) then
         allocate(DstWng_ParameterTypeData%PrescribedCirculation(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_ParameterTypeData%PrescribedCirculation.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_ParameterTypeData%PrescribedCirculation = SrcWng_ParameterTypeData%PrescribedCirculation
   end if
end subroutine

subroutine FVW_DestroyWng_ParameterType(Wng_ParameterTypeData, ErrStat, ErrMsg)
   type(Wng_ParameterType), intent(inout) :: Wng_ParameterTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FVW_DestroyWng_ParameterType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(Wng_ParameterTypeData%chord_LL)) then
      deallocate(Wng_ParameterTypeData%chord_LL)
   end if
   if (allocated(Wng_ParameterTypeData%chord_CP)) then
      deallocate(Wng_ParameterTypeData%chord_CP)
   end if
   if (allocated(Wng_ParameterTypeData%s_LL)) then
      deallocate(Wng_ParameterTypeData%s_LL)
   end if
   if (allocated(Wng_ParameterTypeData%s_CP)) then
      deallocate(Wng_ParameterTypeData%s_CP)
   end if
   if (allocated(Wng_ParameterTypeData%AFindx)) then
      deallocate(Wng_ParameterTypeData%AFindx)
   end if
   if (allocated(Wng_ParameterTypeData%PrescribedCirculation)) then
      deallocate(Wng_ParameterTypeData%PrescribedCirculation)
   end if
end subroutine

subroutine FVW_PackWng_ParameterType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Wng_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FVW_PackWng_ParameterType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%chord_LL)
   call RegPackAlloc(RF, InData%chord_CP)
   call RegPackAlloc(RF, InData%s_LL)
   call RegPackAlloc(RF, InData%s_CP)
   call RegPack(RF, InData%iRotor)
   call RegPackAlloc(RF, InData%AFindx)
   call RegPack(RF, InData%nSpan)
   call RegPackAlloc(RF, InData%PrescribedCirculation)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FVW_UnPackWng_ParameterType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Wng_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FVW_UnPackWng_ParameterType'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%chord_LL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%chord_CP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%s_LL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%s_CP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%iRotor); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AFindx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nSpan); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PrescribedCirculation); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FVW_CopyParam(SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg)
   type(FVW_ParameterType), intent(in) :: SrcParamData
   type(FVW_ParameterType), intent(inout) :: DstParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FVW_CopyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstParamData%nRotors = SrcParamData%nRotors
   DstParamData%nWings = SrcParamData%nWings
   if (allocated(SrcParamData%W)) then
      LB(1:1) = lbound(SrcParamData%W)
      UB(1:1) = ubound(SrcParamData%W)
      if (.not. allocated(DstParamData%W)) then
         allocate(DstParamData%W(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%W.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call FVW_CopyWng_ParameterType(SrcParamData%W(i1), DstParamData%W(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcParamData%Bld2Wings)) then
      LB(1:2) = lbound(SrcParamData%Bld2Wings)
      UB(1:2) = ubound(SrcParamData%Bld2Wings)
      if (.not. allocated(DstParamData%Bld2Wings)) then
         allocate(DstParamData%Bld2Wings(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Bld2Wings.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Bld2Wings = SrcParamData%Bld2Wings
   end if
   DstParamData%iNWStart = SrcParamData%iNWStart
   DstParamData%nNWMax = SrcParamData%nNWMax
   DstParamData%nNWFree = SrcParamData%nNWFree
   DstParamData%nFWMax = SrcParamData%nFWMax
   DstParamData%nFWFree = SrcParamData%nFWFree
   DstParamData%FWShedVorticity = SrcParamData%FWShedVorticity
   DstParamData%IntMethod = SrcParamData%IntMethod
   DstParamData%FreeWakeStart = SrcParamData%FreeWakeStart
   DstParamData%FullCircStart = SrcParamData%FullCircStart
   DstParamData%CircSolvMethod = SrcParamData%CircSolvMethod
   DstParamData%CircSolvMaxIter = SrcParamData%CircSolvMaxIter
   DstParamData%CircSolvConvCrit = SrcParamData%CircSolvConvCrit
   DstParamData%CircSolvRelaxation = SrcParamData%CircSolvRelaxation
   DstParamData%CircSolvPolar = SrcParamData%CircSolvPolar
   DstParamData%DiffusionMethod = SrcParamData%DiffusionMethod
   DstParamData%CoreSpreadEddyVisc = SrcParamData%CoreSpreadEddyVisc
   DstParamData%RegDeterMethod = SrcParamData%RegDeterMethod
   DstParamData%RegFunction = SrcParamData%RegFunction
   DstParamData%WakeRegMethod = SrcParamData%WakeRegMethod
   DstParamData%WakeRegParam = SrcParamData%WakeRegParam
   DstParamData%WingRegParam = SrcParamData%WingRegParam
   DstParamData%ShearModel = SrcParamData%ShearModel
   DstParamData%TwrShadowOnWake = SrcParamData%TwrShadowOnWake
   DstParamData%VelocityMethod = SrcParamData%VelocityMethod
   DstParamData%TreeBranchFactor = SrcParamData%TreeBranchFactor
   DstParamData%PartPerSegment = SrcParamData%PartPerSegment
   DstParamData%DTaero = SrcParamData%DTaero
   DstParamData%DTfvw = SrcParamData%DTfvw
   DstParamData%KinVisc = SrcParamData%KinVisc
   DstParamData%MHK = SrcParamData%MHK
   DstParamData%WtrDpth = SrcParamData%WtrDpth
   DstParamData%WrVTK = SrcParamData%WrVTK
   DstParamData%VTKBlades = SrcParamData%VTKBlades
   DstParamData%DTvtk = SrcParamData%DTvtk
   DstParamData%VTKCoord = SrcParamData%VTKCoord
   DstParamData%RootName = SrcParamData%RootName
   DstParamData%VTK_OutFileRoot = SrcParamData%VTK_OutFileRoot
   DstParamData%VTK_OutFileBase = SrcParamData%VTK_OutFileBase
   DstParamData%nGridOut = SrcParamData%nGridOut
   DstParamData%InductionAtCP = SrcParamData%InductionAtCP
   DstParamData%WakeAtTE = SrcParamData%WakeAtTE
   DstParamData%DStallOnWake = SrcParamData%DStallOnWake
   DstParamData%Induction = SrcParamData%Induction
   DstParamData%kFrozenNWStart = SrcParamData%kFrozenNWStart
   DstParamData%kFrozenNWEnd = SrcParamData%kFrozenNWEnd
end subroutine

subroutine FVW_DestroyParam(ParamData, ErrStat, ErrMsg)
   type(FVW_ParameterType), intent(inout) :: ParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FVW_DestroyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ParamData%W)) then
      LB(1:1) = lbound(ParamData%W)
      UB(1:1) = ubound(ParamData%W)
      do i1 = LB(1), UB(1)
         call FVW_DestroyWng_ParameterType(ParamData%W(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%W)
   end if
   if (allocated(ParamData%Bld2Wings)) then
      deallocate(ParamData%Bld2Wings)
   end if
end subroutine

subroutine FVW_PackParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FVW_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FVW_PackParam'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%nRotors)
   call RegPack(RF, InData%nWings)
   call RegPack(RF, allocated(InData%W))
   if (allocated(InData%W)) then
      call RegPackBounds(RF, 1, lbound(InData%W), ubound(InData%W))
      LB(1:1) = lbound(InData%W)
      UB(1:1) = ubound(InData%W)
      do i1 = LB(1), UB(1)
         call FVW_PackWng_ParameterType(RF, InData%W(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%Bld2Wings)
   call RegPack(RF, InData%iNWStart)
   call RegPack(RF, InData%nNWMax)
   call RegPack(RF, InData%nNWFree)
   call RegPack(RF, InData%nFWMax)
   call RegPack(RF, InData%nFWFree)
   call RegPack(RF, InData%FWShedVorticity)
   call RegPack(RF, InData%IntMethod)
   call RegPack(RF, InData%FreeWakeStart)
   call RegPack(RF, InData%FullCircStart)
   call RegPack(RF, InData%CircSolvMethod)
   call RegPack(RF, InData%CircSolvMaxIter)
   call RegPack(RF, InData%CircSolvConvCrit)
   call RegPack(RF, InData%CircSolvRelaxation)
   call RegPack(RF, InData%CircSolvPolar)
   call RegPack(RF, InData%DiffusionMethod)
   call RegPack(RF, InData%CoreSpreadEddyVisc)
   call RegPack(RF, InData%RegDeterMethod)
   call RegPack(RF, InData%RegFunction)
   call RegPack(RF, InData%WakeRegMethod)
   call RegPack(RF, InData%WakeRegParam)
   call RegPack(RF, InData%WingRegParam)
   call RegPack(RF, InData%ShearModel)
   call RegPack(RF, InData%TwrShadowOnWake)
   call RegPack(RF, InData%VelocityMethod)
   call RegPack(RF, InData%TreeBranchFactor)
   call RegPack(RF, InData%PartPerSegment)
   call RegPack(RF, InData%DTaero)
   call RegPack(RF, InData%DTfvw)
   call RegPack(RF, InData%KinVisc)
   call RegPack(RF, InData%MHK)
   call RegPack(RF, InData%WtrDpth)
   call RegPack(RF, InData%WrVTK)
   call RegPack(RF, InData%VTKBlades)
   call RegPack(RF, InData%DTvtk)
   call RegPack(RF, InData%VTKCoord)
   call RegPack(RF, InData%RootName)
   call RegPack(RF, InData%VTK_OutFileRoot)
   call RegPack(RF, InData%VTK_OutFileBase)
   call RegPack(RF, InData%nGridOut)
   call RegPack(RF, InData%InductionAtCP)
   call RegPack(RF, InData%WakeAtTE)
   call RegPack(RF, InData%DStallOnWake)
   call RegPack(RF, InData%Induction)
   call RegPack(RF, InData%kFrozenNWStart)
   call RegPack(RF, InData%kFrozenNWEnd)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FVW_UnPackParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FVW_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FVW_UnPackParam'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%nRotors); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nWings); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%W)) deallocate(OutData%W)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%W(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%W.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call FVW_UnpackWng_ParameterType(RF, OutData%W(i1)) ! W 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%Bld2Wings); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%iNWStart); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nNWMax); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nNWFree); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nFWMax); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nFWFree); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FWShedVorticity); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%IntMethod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FreeWakeStart); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FullCircStart); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CircSolvMethod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CircSolvMaxIter); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CircSolvConvCrit); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CircSolvRelaxation); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CircSolvPolar); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DiffusionMethod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CoreSpreadEddyVisc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RegDeterMethod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RegFunction); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WakeRegMethod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WakeRegParam); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WingRegParam); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ShearModel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TwrShadowOnWake); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VelocityMethod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TreeBranchFactor); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PartPerSegment); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DTaero); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DTfvw); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%KinVisc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MHK); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WtrDpth); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WrVTK); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VTKBlades); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DTvtk); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VTKCoord); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VTK_OutFileRoot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VTK_OutFileBase); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nGridOut); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%InductionAtCP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WakeAtTE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DStallOnWake); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Induction); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%kFrozenNWStart); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%kFrozenNWEnd); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FVW_CopyWng_ContinuousStateType(SrcWng_ContinuousStateTypeData, DstWng_ContinuousStateTypeData, CtrlCode, ErrStat, ErrMsg)
   type(Wng_ContinuousStateType), intent(in) :: SrcWng_ContinuousStateTypeData
   type(Wng_ContinuousStateType), intent(inout) :: DstWng_ContinuousStateTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'FVW_CopyWng_ContinuousStateType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcWng_ContinuousStateTypeData%Gamma_NW)) then
      LB(1:2) = lbound(SrcWng_ContinuousStateTypeData%Gamma_NW)
      UB(1:2) = ubound(SrcWng_ContinuousStateTypeData%Gamma_NW)
      if (.not. allocated(DstWng_ContinuousStateTypeData%Gamma_NW)) then
         allocate(DstWng_ContinuousStateTypeData%Gamma_NW(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_ContinuousStateTypeData%Gamma_NW.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_ContinuousStateTypeData%Gamma_NW = SrcWng_ContinuousStateTypeData%Gamma_NW
   end if
   if (allocated(SrcWng_ContinuousStateTypeData%Gamma_FW)) then
      LB(1:2) = lbound(SrcWng_ContinuousStateTypeData%Gamma_FW)
      UB(1:2) = ubound(SrcWng_ContinuousStateTypeData%Gamma_FW)
      if (.not. allocated(DstWng_ContinuousStateTypeData%Gamma_FW)) then
         allocate(DstWng_ContinuousStateTypeData%Gamma_FW(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_ContinuousStateTypeData%Gamma_FW.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_ContinuousStateTypeData%Gamma_FW = SrcWng_ContinuousStateTypeData%Gamma_FW
   end if
   if (allocated(SrcWng_ContinuousStateTypeData%Eps_NW)) then
      LB(1:3) = lbound(SrcWng_ContinuousStateTypeData%Eps_NW)
      UB(1:3) = ubound(SrcWng_ContinuousStateTypeData%Eps_NW)
      if (.not. allocated(DstWng_ContinuousStateTypeData%Eps_NW)) then
         allocate(DstWng_ContinuousStateTypeData%Eps_NW(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_ContinuousStateTypeData%Eps_NW.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_ContinuousStateTypeData%Eps_NW = SrcWng_ContinuousStateTypeData%Eps_NW
   end if
   if (allocated(SrcWng_ContinuousStateTypeData%Eps_FW)) then
      LB(1:3) = lbound(SrcWng_ContinuousStateTypeData%Eps_FW)
      UB(1:3) = ubound(SrcWng_ContinuousStateTypeData%Eps_FW)
      if (.not. allocated(DstWng_ContinuousStateTypeData%Eps_FW)) then
         allocate(DstWng_ContinuousStateTypeData%Eps_FW(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_ContinuousStateTypeData%Eps_FW.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_ContinuousStateTypeData%Eps_FW = SrcWng_ContinuousStateTypeData%Eps_FW
   end if
   if (allocated(SrcWng_ContinuousStateTypeData%r_NW)) then
      LB(1:3) = lbound(SrcWng_ContinuousStateTypeData%r_NW)
      UB(1:3) = ubound(SrcWng_ContinuousStateTypeData%r_NW)
      if (.not. allocated(DstWng_ContinuousStateTypeData%r_NW)) then
         allocate(DstWng_ContinuousStateTypeData%r_NW(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_ContinuousStateTypeData%r_NW.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_ContinuousStateTypeData%r_NW = SrcWng_ContinuousStateTypeData%r_NW
   end if
   if (allocated(SrcWng_ContinuousStateTypeData%r_FW)) then
      LB(1:3) = lbound(SrcWng_ContinuousStateTypeData%r_FW)
      UB(1:3) = ubound(SrcWng_ContinuousStateTypeData%r_FW)
      if (.not. allocated(DstWng_ContinuousStateTypeData%r_FW)) then
         allocate(DstWng_ContinuousStateTypeData%r_FW(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_ContinuousStateTypeData%r_FW.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_ContinuousStateTypeData%r_FW = SrcWng_ContinuousStateTypeData%r_FW
   end if
end subroutine

subroutine FVW_DestroyWng_ContinuousStateType(Wng_ContinuousStateTypeData, ErrStat, ErrMsg)
   type(Wng_ContinuousStateType), intent(inout) :: Wng_ContinuousStateTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FVW_DestroyWng_ContinuousStateType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(Wng_ContinuousStateTypeData%Gamma_NW)) then
      deallocate(Wng_ContinuousStateTypeData%Gamma_NW)
   end if
   if (allocated(Wng_ContinuousStateTypeData%Gamma_FW)) then
      deallocate(Wng_ContinuousStateTypeData%Gamma_FW)
   end if
   if (allocated(Wng_ContinuousStateTypeData%Eps_NW)) then
      deallocate(Wng_ContinuousStateTypeData%Eps_NW)
   end if
   if (allocated(Wng_ContinuousStateTypeData%Eps_FW)) then
      deallocate(Wng_ContinuousStateTypeData%Eps_FW)
   end if
   if (allocated(Wng_ContinuousStateTypeData%r_NW)) then
      deallocate(Wng_ContinuousStateTypeData%r_NW)
   end if
   if (allocated(Wng_ContinuousStateTypeData%r_FW)) then
      deallocate(Wng_ContinuousStateTypeData%r_FW)
   end if
end subroutine

subroutine FVW_PackWng_ContinuousStateType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Wng_ContinuousStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FVW_PackWng_ContinuousStateType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%Gamma_NW)
   call RegPackAlloc(RF, InData%Gamma_FW)
   call RegPackAlloc(RF, InData%Eps_NW)
   call RegPackAlloc(RF, InData%Eps_FW)
   call RegPackAlloc(RF, InData%r_NW)
   call RegPackAlloc(RF, InData%r_FW)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FVW_UnPackWng_ContinuousStateType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Wng_ContinuousStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FVW_UnPackWng_ContinuousStateType'
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%Gamma_NW); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Gamma_FW); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Eps_NW); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Eps_FW); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%r_NW); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%r_FW); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FVW_CopyContState(SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg)
   type(FVW_ContinuousStateType), intent(in) :: SrcContStateData
   type(FVW_ContinuousStateType), intent(inout) :: DstContStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FVW_CopyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcContStateData%W)) then
      LB(1:1) = lbound(SrcContStateData%W)
      UB(1:1) = ubound(SrcContStateData%W)
      if (.not. allocated(DstContStateData%W)) then
         allocate(DstContStateData%W(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstContStateData%W.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call FVW_CopyWng_ContinuousStateType(SrcContStateData%W(i1), DstContStateData%W(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcContStateData%UA)) then
      LB(1:1) = lbound(SrcContStateData%UA)
      UB(1:1) = ubound(SrcContStateData%UA)
      if (.not. allocated(DstContStateData%UA)) then
         allocate(DstContStateData%UA(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstContStateData%UA.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call UA_CopyContState(SrcContStateData%UA(i1), DstContStateData%UA(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
end subroutine

subroutine FVW_DestroyContState(ContStateData, ErrStat, ErrMsg)
   type(FVW_ContinuousStateType), intent(inout) :: ContStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FVW_DestroyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ContStateData%W)) then
      LB(1:1) = lbound(ContStateData%W)
      UB(1:1) = ubound(ContStateData%W)
      do i1 = LB(1), UB(1)
         call FVW_DestroyWng_ContinuousStateType(ContStateData%W(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ContStateData%W)
   end if
   if (allocated(ContStateData%UA)) then
      LB(1:1) = lbound(ContStateData%UA)
      UB(1:1) = ubound(ContStateData%UA)
      do i1 = LB(1), UB(1)
         call UA_DestroyContState(ContStateData%UA(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ContStateData%UA)
   end if
end subroutine

subroutine FVW_PackContState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FVW_ContinuousStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FVW_PackContState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%W))
   if (allocated(InData%W)) then
      call RegPackBounds(RF, 1, lbound(InData%W), ubound(InData%W))
      LB(1:1) = lbound(InData%W)
      UB(1:1) = ubound(InData%W)
      do i1 = LB(1), UB(1)
         call FVW_PackWng_ContinuousStateType(RF, InData%W(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%UA))
   if (allocated(InData%UA)) then
      call RegPackBounds(RF, 1, lbound(InData%UA), ubound(InData%UA))
      LB(1:1) = lbound(InData%UA)
      UB(1:1) = ubound(InData%UA)
      do i1 = LB(1), UB(1)
         call UA_PackContState(RF, InData%UA(i1)) 
      end do
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FVW_UnPackContState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FVW_ContinuousStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FVW_UnPackContState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%W)) deallocate(OutData%W)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%W(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%W.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call FVW_UnpackWng_ContinuousStateType(RF, OutData%W(i1)) ! W 
      end do
   end if
   if (allocated(OutData%UA)) deallocate(OutData%UA)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%UA(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%UA.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call UA_UnpackContState(RF, OutData%UA(i1)) ! UA 
      end do
   end if
end subroutine

subroutine FVW_CopyWng_OutputType(SrcWng_OutputTypeData, DstWng_OutputTypeData, CtrlCode, ErrStat, ErrMsg)
   type(Wng_OutputType), intent(in) :: SrcWng_OutputTypeData
   type(Wng_OutputType), intent(inout) :: DstWng_OutputTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'FVW_CopyWng_OutputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcWng_OutputTypeData%Vind)) then
      LB(1:2) = lbound(SrcWng_OutputTypeData%Vind)
      UB(1:2) = ubound(SrcWng_OutputTypeData%Vind)
      if (.not. allocated(DstWng_OutputTypeData%Vind)) then
         allocate(DstWng_OutputTypeData%Vind(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_OutputTypeData%Vind.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_OutputTypeData%Vind = SrcWng_OutputTypeData%Vind
   end if
end subroutine

subroutine FVW_DestroyWng_OutputType(Wng_OutputTypeData, ErrStat, ErrMsg)
   type(Wng_OutputType), intent(inout) :: Wng_OutputTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FVW_DestroyWng_OutputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(Wng_OutputTypeData%Vind)) then
      deallocate(Wng_OutputTypeData%Vind)
   end if
end subroutine

subroutine FVW_PackWng_OutputType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Wng_OutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FVW_PackWng_OutputType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%Vind)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FVW_UnPackWng_OutputType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Wng_OutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FVW_UnPackWng_OutputType'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%Vind); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FVW_CopyOutput(SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg)
   type(FVW_OutputType), intent(in) :: SrcOutputData
   type(FVW_OutputType), intent(inout) :: DstOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FVW_CopyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcOutputData%W)) then
      LB(1:1) = lbound(SrcOutputData%W)
      UB(1:1) = ubound(SrcOutputData%W)
      if (.not. allocated(DstOutputData%W)) then
         allocate(DstOutputData%W(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%W.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call FVW_CopyWng_OutputType(SrcOutputData%W(i1), DstOutputData%W(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
end subroutine

subroutine FVW_DestroyOutput(OutputData, ErrStat, ErrMsg)
   type(FVW_OutputType), intent(inout) :: OutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FVW_DestroyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(OutputData%W)) then
      LB(1:1) = lbound(OutputData%W)
      UB(1:1) = ubound(OutputData%W)
      do i1 = LB(1), UB(1)
         call FVW_DestroyWng_OutputType(OutputData%W(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(OutputData%W)
   end if
end subroutine

subroutine FVW_PackOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FVW_OutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FVW_PackOutput'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%W))
   if (allocated(InData%W)) then
      call RegPackBounds(RF, 1, lbound(InData%W), ubound(InData%W))
      LB(1:1) = lbound(InData%W)
      UB(1:1) = ubound(InData%W)
      do i1 = LB(1), UB(1)
         call FVW_PackWng_OutputType(RF, InData%W(i1)) 
      end do
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FVW_UnPackOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FVW_OutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FVW_UnPackOutput'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%W)) deallocate(OutData%W)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%W(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%W.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call FVW_UnpackWng_OutputType(RF, OutData%W(i1)) ! W 
      end do
   end if
end subroutine

subroutine FVW_CopyWng_MiscVarType(SrcWng_MiscVarTypeData, DstWng_MiscVarTypeData, CtrlCode, ErrStat, ErrMsg)
   type(Wng_MiscVarType), intent(in) :: SrcWng_MiscVarTypeData
   type(Wng_MiscVarType), intent(inout) :: DstWng_MiscVarTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FVW_CopyWng_MiscVarType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcWng_MiscVarTypeData%LE)) then
      LB(1:2) = lbound(SrcWng_MiscVarTypeData%LE)
      UB(1:2) = ubound(SrcWng_MiscVarTypeData%LE)
      if (.not. allocated(DstWng_MiscVarTypeData%LE)) then
         allocate(DstWng_MiscVarTypeData%LE(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%LE.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_MiscVarTypeData%LE = SrcWng_MiscVarTypeData%LE
   end if
   if (allocated(SrcWng_MiscVarTypeData%TE)) then
      LB(1:2) = lbound(SrcWng_MiscVarTypeData%TE)
      UB(1:2) = ubound(SrcWng_MiscVarTypeData%TE)
      if (.not. allocated(DstWng_MiscVarTypeData%TE)) then
         allocate(DstWng_MiscVarTypeData%TE(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%TE.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_MiscVarTypeData%TE = SrcWng_MiscVarTypeData%TE
   end if
   if (allocated(SrcWng_MiscVarTypeData%r_LL)) then
      LB(1:3) = lbound(SrcWng_MiscVarTypeData%r_LL)
      UB(1:3) = ubound(SrcWng_MiscVarTypeData%r_LL)
      if (.not. allocated(DstWng_MiscVarTypeData%r_LL)) then
         allocate(DstWng_MiscVarTypeData%r_LL(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%r_LL.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_MiscVarTypeData%r_LL = SrcWng_MiscVarTypeData%r_LL
   end if
   if (allocated(SrcWng_MiscVarTypeData%CP)) then
      LB(1:2) = lbound(SrcWng_MiscVarTypeData%CP)
      UB(1:2) = ubound(SrcWng_MiscVarTypeData%CP)
      if (.not. allocated(DstWng_MiscVarTypeData%CP)) then
         allocate(DstWng_MiscVarTypeData%CP(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%CP.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_MiscVarTypeData%CP = SrcWng_MiscVarTypeData%CP
   end if
   if (allocated(SrcWng_MiscVarTypeData%Tang)) then
      LB(1:2) = lbound(SrcWng_MiscVarTypeData%Tang)
      UB(1:2) = ubound(SrcWng_MiscVarTypeData%Tang)
      if (.not. allocated(DstWng_MiscVarTypeData%Tang)) then
         allocate(DstWng_MiscVarTypeData%Tang(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%Tang.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_MiscVarTypeData%Tang = SrcWng_MiscVarTypeData%Tang
   end if
   if (allocated(SrcWng_MiscVarTypeData%Norm)) then
      LB(1:2) = lbound(SrcWng_MiscVarTypeData%Norm)
      UB(1:2) = ubound(SrcWng_MiscVarTypeData%Norm)
      if (.not. allocated(DstWng_MiscVarTypeData%Norm)) then
         allocate(DstWng_MiscVarTypeData%Norm(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%Norm.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_MiscVarTypeData%Norm = SrcWng_MiscVarTypeData%Norm
   end if
   if (allocated(SrcWng_MiscVarTypeData%Orth)) then
      LB(1:2) = lbound(SrcWng_MiscVarTypeData%Orth)
      UB(1:2) = ubound(SrcWng_MiscVarTypeData%Orth)
      if (.not. allocated(DstWng_MiscVarTypeData%Orth)) then
         allocate(DstWng_MiscVarTypeData%Orth(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%Orth.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_MiscVarTypeData%Orth = SrcWng_MiscVarTypeData%Orth
   end if
   if (allocated(SrcWng_MiscVarTypeData%dl)) then
      LB(1:2) = lbound(SrcWng_MiscVarTypeData%dl)
      UB(1:2) = ubound(SrcWng_MiscVarTypeData%dl)
      if (.not. allocated(DstWng_MiscVarTypeData%dl)) then
         allocate(DstWng_MiscVarTypeData%dl(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%dl.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_MiscVarTypeData%dl = SrcWng_MiscVarTypeData%dl
   end if
   if (allocated(SrcWng_MiscVarTypeData%Area)) then
      LB(1:1) = lbound(SrcWng_MiscVarTypeData%Area)
      UB(1:1) = ubound(SrcWng_MiscVarTypeData%Area)
      if (.not. allocated(DstWng_MiscVarTypeData%Area)) then
         allocate(DstWng_MiscVarTypeData%Area(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%Area.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_MiscVarTypeData%Area = SrcWng_MiscVarTypeData%Area
   end if
   if (allocated(SrcWng_MiscVarTypeData%diag_LL)) then
      LB(1:1) = lbound(SrcWng_MiscVarTypeData%diag_LL)
      UB(1:1) = ubound(SrcWng_MiscVarTypeData%diag_LL)
      if (.not. allocated(DstWng_MiscVarTypeData%diag_LL)) then
         allocate(DstWng_MiscVarTypeData%diag_LL(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%diag_LL.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_MiscVarTypeData%diag_LL = SrcWng_MiscVarTypeData%diag_LL
   end if
   if (allocated(SrcWng_MiscVarTypeData%Vind_CP)) then
      LB(1:2) = lbound(SrcWng_MiscVarTypeData%Vind_CP)
      UB(1:2) = ubound(SrcWng_MiscVarTypeData%Vind_CP)
      if (.not. allocated(DstWng_MiscVarTypeData%Vind_CP)) then
         allocate(DstWng_MiscVarTypeData%Vind_CP(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%Vind_CP.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_MiscVarTypeData%Vind_CP = SrcWng_MiscVarTypeData%Vind_CP
   end if
   if (allocated(SrcWng_MiscVarTypeData%Vtot_CP)) then
      LB(1:2) = lbound(SrcWng_MiscVarTypeData%Vtot_CP)
      UB(1:2) = ubound(SrcWng_MiscVarTypeData%Vtot_CP)
      if (.not. allocated(DstWng_MiscVarTypeData%Vtot_CP)) then
         allocate(DstWng_MiscVarTypeData%Vtot_CP(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%Vtot_CP.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_MiscVarTypeData%Vtot_CP = SrcWng_MiscVarTypeData%Vtot_CP
   end if
   if (allocated(SrcWng_MiscVarTypeData%Vstr_CP)) then
      LB(1:2) = lbound(SrcWng_MiscVarTypeData%Vstr_CP)
      UB(1:2) = ubound(SrcWng_MiscVarTypeData%Vstr_CP)
      if (.not. allocated(DstWng_MiscVarTypeData%Vstr_CP)) then
         allocate(DstWng_MiscVarTypeData%Vstr_CP(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%Vstr_CP.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_MiscVarTypeData%Vstr_CP = SrcWng_MiscVarTypeData%Vstr_CP
   end if
   if (allocated(SrcWng_MiscVarTypeData%Vwnd_CP)) then
      LB(1:2) = lbound(SrcWng_MiscVarTypeData%Vwnd_CP)
      UB(1:2) = ubound(SrcWng_MiscVarTypeData%Vwnd_CP)
      if (.not. allocated(DstWng_MiscVarTypeData%Vwnd_CP)) then
         allocate(DstWng_MiscVarTypeData%Vwnd_CP(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%Vwnd_CP.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_MiscVarTypeData%Vwnd_CP = SrcWng_MiscVarTypeData%Vwnd_CP
   end if
   if (allocated(SrcWng_MiscVarTypeData%Vwnd_NW)) then
      LB(1:3) = lbound(SrcWng_MiscVarTypeData%Vwnd_NW)
      UB(1:3) = ubound(SrcWng_MiscVarTypeData%Vwnd_NW)
      if (.not. allocated(DstWng_MiscVarTypeData%Vwnd_NW)) then
         allocate(DstWng_MiscVarTypeData%Vwnd_NW(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%Vwnd_NW.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_MiscVarTypeData%Vwnd_NW = SrcWng_MiscVarTypeData%Vwnd_NW
   end if
   if (allocated(SrcWng_MiscVarTypeData%Vwnd_FW)) then
      LB(1:3) = lbound(SrcWng_MiscVarTypeData%Vwnd_FW)
      UB(1:3) = ubound(SrcWng_MiscVarTypeData%Vwnd_FW)
      if (.not. allocated(DstWng_MiscVarTypeData%Vwnd_FW)) then
         allocate(DstWng_MiscVarTypeData%Vwnd_FW(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%Vwnd_FW.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_MiscVarTypeData%Vwnd_FW = SrcWng_MiscVarTypeData%Vwnd_FW
   end if
   if (allocated(SrcWng_MiscVarTypeData%Vind_NW)) then
      LB(1:3) = lbound(SrcWng_MiscVarTypeData%Vind_NW)
      UB(1:3) = ubound(SrcWng_MiscVarTypeData%Vind_NW)
      if (.not. allocated(DstWng_MiscVarTypeData%Vind_NW)) then
         allocate(DstWng_MiscVarTypeData%Vind_NW(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%Vind_NW.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_MiscVarTypeData%Vind_NW = SrcWng_MiscVarTypeData%Vind_NW
   end if
   if (allocated(SrcWng_MiscVarTypeData%Vind_FW)) then
      LB(1:3) = lbound(SrcWng_MiscVarTypeData%Vind_FW)
      UB(1:3) = ubound(SrcWng_MiscVarTypeData%Vind_FW)
      if (.not. allocated(DstWng_MiscVarTypeData%Vind_FW)) then
         allocate(DstWng_MiscVarTypeData%Vind_FW(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%Vind_FW.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_MiscVarTypeData%Vind_FW = SrcWng_MiscVarTypeData%Vind_FW
   end if
   if (allocated(SrcWng_MiscVarTypeData%PitchAndTwist)) then
      LB(1:1) = lbound(SrcWng_MiscVarTypeData%PitchAndTwist)
      UB(1:1) = ubound(SrcWng_MiscVarTypeData%PitchAndTwist)
      if (.not. allocated(DstWng_MiscVarTypeData%PitchAndTwist)) then
         allocate(DstWng_MiscVarTypeData%PitchAndTwist(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%PitchAndTwist.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_MiscVarTypeData%PitchAndTwist = SrcWng_MiscVarTypeData%PitchAndTwist
   end if
   DstWng_MiscVarTypeData%iTip = SrcWng_MiscVarTypeData%iTip
   DstWng_MiscVarTypeData%iRoot = SrcWng_MiscVarTypeData%iRoot
   if (allocated(SrcWng_MiscVarTypeData%alpha_LL)) then
      LB(1:1) = lbound(SrcWng_MiscVarTypeData%alpha_LL)
      UB(1:1) = ubound(SrcWng_MiscVarTypeData%alpha_LL)
      if (.not. allocated(DstWng_MiscVarTypeData%alpha_LL)) then
         allocate(DstWng_MiscVarTypeData%alpha_LL(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%alpha_LL.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_MiscVarTypeData%alpha_LL = SrcWng_MiscVarTypeData%alpha_LL
   end if
   if (allocated(SrcWng_MiscVarTypeData%Vreln_LL)) then
      LB(1:1) = lbound(SrcWng_MiscVarTypeData%Vreln_LL)
      UB(1:1) = ubound(SrcWng_MiscVarTypeData%Vreln_LL)
      if (.not. allocated(DstWng_MiscVarTypeData%Vreln_LL)) then
         allocate(DstWng_MiscVarTypeData%Vreln_LL(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%Vreln_LL.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_MiscVarTypeData%Vreln_LL = SrcWng_MiscVarTypeData%Vreln_LL
   end if
   if (allocated(SrcWng_MiscVarTypeData%u_UA)) then
      LB(1:2) = lbound(SrcWng_MiscVarTypeData%u_UA)
      UB(1:2) = ubound(SrcWng_MiscVarTypeData%u_UA)
      if (.not. allocated(DstWng_MiscVarTypeData%u_UA)) then
         allocate(DstWng_MiscVarTypeData%u_UA(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%u_UA.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call UA_CopyInput(SrcWng_MiscVarTypeData%u_UA(i1,i2), DstWng_MiscVarTypeData%u_UA(i1,i2), CtrlCode, ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
            if (ErrStat >= AbortErrLev) return
         end do
      end do
   end if
   call UA_CopyMisc(SrcWng_MiscVarTypeData%m_UA, DstWng_MiscVarTypeData%m_UA, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call UA_CopyOutput(SrcWng_MiscVarTypeData%y_UA, DstWng_MiscVarTypeData%y_UA, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call UA_CopyParam(SrcWng_MiscVarTypeData%p_UA, DstWng_MiscVarTypeData%p_UA, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcWng_MiscVarTypeData%Vind_LL)) then
      LB(1:2) = lbound(SrcWng_MiscVarTypeData%Vind_LL)
      UB(1:2) = ubound(SrcWng_MiscVarTypeData%Vind_LL)
      if (.not. allocated(DstWng_MiscVarTypeData%Vind_LL)) then
         allocate(DstWng_MiscVarTypeData%Vind_LL(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%Vind_LL.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_MiscVarTypeData%Vind_LL = SrcWng_MiscVarTypeData%Vind_LL
   end if
   if (allocated(SrcWng_MiscVarTypeData%BN_AxInd)) then
      LB(1:1) = lbound(SrcWng_MiscVarTypeData%BN_AxInd)
      UB(1:1) = ubound(SrcWng_MiscVarTypeData%BN_AxInd)
      if (.not. allocated(DstWng_MiscVarTypeData%BN_AxInd)) then
         allocate(DstWng_MiscVarTypeData%BN_AxInd(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%BN_AxInd.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_MiscVarTypeData%BN_AxInd = SrcWng_MiscVarTypeData%BN_AxInd
   end if
   if (allocated(SrcWng_MiscVarTypeData%BN_TanInd)) then
      LB(1:1) = lbound(SrcWng_MiscVarTypeData%BN_TanInd)
      UB(1:1) = ubound(SrcWng_MiscVarTypeData%BN_TanInd)
      if (.not. allocated(DstWng_MiscVarTypeData%BN_TanInd)) then
         allocate(DstWng_MiscVarTypeData%BN_TanInd(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%BN_TanInd.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_MiscVarTypeData%BN_TanInd = SrcWng_MiscVarTypeData%BN_TanInd
   end if
   if (allocated(SrcWng_MiscVarTypeData%BN_Vrel)) then
      LB(1:1) = lbound(SrcWng_MiscVarTypeData%BN_Vrel)
      UB(1:1) = ubound(SrcWng_MiscVarTypeData%BN_Vrel)
      if (.not. allocated(DstWng_MiscVarTypeData%BN_Vrel)) then
         allocate(DstWng_MiscVarTypeData%BN_Vrel(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%BN_Vrel.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_MiscVarTypeData%BN_Vrel = SrcWng_MiscVarTypeData%BN_Vrel
   end if
   if (allocated(SrcWng_MiscVarTypeData%BN_alpha)) then
      LB(1:1) = lbound(SrcWng_MiscVarTypeData%BN_alpha)
      UB(1:1) = ubound(SrcWng_MiscVarTypeData%BN_alpha)
      if (.not. allocated(DstWng_MiscVarTypeData%BN_alpha)) then
         allocate(DstWng_MiscVarTypeData%BN_alpha(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%BN_alpha.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_MiscVarTypeData%BN_alpha = SrcWng_MiscVarTypeData%BN_alpha
   end if
   if (allocated(SrcWng_MiscVarTypeData%BN_phi)) then
      LB(1:1) = lbound(SrcWng_MiscVarTypeData%BN_phi)
      UB(1:1) = ubound(SrcWng_MiscVarTypeData%BN_phi)
      if (.not. allocated(DstWng_MiscVarTypeData%BN_phi)) then
         allocate(DstWng_MiscVarTypeData%BN_phi(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%BN_phi.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_MiscVarTypeData%BN_phi = SrcWng_MiscVarTypeData%BN_phi
   end if
   if (allocated(SrcWng_MiscVarTypeData%BN_Re)) then
      LB(1:1) = lbound(SrcWng_MiscVarTypeData%BN_Re)
      UB(1:1) = ubound(SrcWng_MiscVarTypeData%BN_Re)
      if (.not. allocated(DstWng_MiscVarTypeData%BN_Re)) then
         allocate(DstWng_MiscVarTypeData%BN_Re(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%BN_Re.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_MiscVarTypeData%BN_Re = SrcWng_MiscVarTypeData%BN_Re
   end if
   if (allocated(SrcWng_MiscVarTypeData%BN_URelWind_s)) then
      LB(1:2) = lbound(SrcWng_MiscVarTypeData%BN_URelWind_s)
      UB(1:2) = ubound(SrcWng_MiscVarTypeData%BN_URelWind_s)
      if (.not. allocated(DstWng_MiscVarTypeData%BN_URelWind_s)) then
         allocate(DstWng_MiscVarTypeData%BN_URelWind_s(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%BN_URelWind_s.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_MiscVarTypeData%BN_URelWind_s = SrcWng_MiscVarTypeData%BN_URelWind_s
   end if
   if (allocated(SrcWng_MiscVarTypeData%BN_Cl_Static)) then
      LB(1:1) = lbound(SrcWng_MiscVarTypeData%BN_Cl_Static)
      UB(1:1) = ubound(SrcWng_MiscVarTypeData%BN_Cl_Static)
      if (.not. allocated(DstWng_MiscVarTypeData%BN_Cl_Static)) then
         allocate(DstWng_MiscVarTypeData%BN_Cl_Static(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%BN_Cl_Static.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_MiscVarTypeData%BN_Cl_Static = SrcWng_MiscVarTypeData%BN_Cl_Static
   end if
   if (allocated(SrcWng_MiscVarTypeData%BN_Cd_Static)) then
      LB(1:1) = lbound(SrcWng_MiscVarTypeData%BN_Cd_Static)
      UB(1:1) = ubound(SrcWng_MiscVarTypeData%BN_Cd_Static)
      if (.not. allocated(DstWng_MiscVarTypeData%BN_Cd_Static)) then
         allocate(DstWng_MiscVarTypeData%BN_Cd_Static(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%BN_Cd_Static.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_MiscVarTypeData%BN_Cd_Static = SrcWng_MiscVarTypeData%BN_Cd_Static
   end if
   if (allocated(SrcWng_MiscVarTypeData%BN_Cm_Static)) then
      LB(1:1) = lbound(SrcWng_MiscVarTypeData%BN_Cm_Static)
      UB(1:1) = ubound(SrcWng_MiscVarTypeData%BN_Cm_Static)
      if (.not. allocated(DstWng_MiscVarTypeData%BN_Cm_Static)) then
         allocate(DstWng_MiscVarTypeData%BN_Cm_Static(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%BN_Cm_Static.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_MiscVarTypeData%BN_Cm_Static = SrcWng_MiscVarTypeData%BN_Cm_Static
   end if
   if (allocated(SrcWng_MiscVarTypeData%BN_Cpmin)) then
      LB(1:1) = lbound(SrcWng_MiscVarTypeData%BN_Cpmin)
      UB(1:1) = ubound(SrcWng_MiscVarTypeData%BN_Cpmin)
      if (.not. allocated(DstWng_MiscVarTypeData%BN_Cpmin)) then
         allocate(DstWng_MiscVarTypeData%BN_Cpmin(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%BN_Cpmin.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_MiscVarTypeData%BN_Cpmin = SrcWng_MiscVarTypeData%BN_Cpmin
   end if
   if (allocated(SrcWng_MiscVarTypeData%BN_Cl)) then
      LB(1:1) = lbound(SrcWng_MiscVarTypeData%BN_Cl)
      UB(1:1) = ubound(SrcWng_MiscVarTypeData%BN_Cl)
      if (.not. allocated(DstWng_MiscVarTypeData%BN_Cl)) then
         allocate(DstWng_MiscVarTypeData%BN_Cl(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%BN_Cl.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_MiscVarTypeData%BN_Cl = SrcWng_MiscVarTypeData%BN_Cl
   end if
   if (allocated(SrcWng_MiscVarTypeData%BN_Cd)) then
      LB(1:1) = lbound(SrcWng_MiscVarTypeData%BN_Cd)
      UB(1:1) = ubound(SrcWng_MiscVarTypeData%BN_Cd)
      if (.not. allocated(DstWng_MiscVarTypeData%BN_Cd)) then
         allocate(DstWng_MiscVarTypeData%BN_Cd(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%BN_Cd.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_MiscVarTypeData%BN_Cd = SrcWng_MiscVarTypeData%BN_Cd
   end if
   if (allocated(SrcWng_MiscVarTypeData%BN_Cm)) then
      LB(1:1) = lbound(SrcWng_MiscVarTypeData%BN_Cm)
      UB(1:1) = ubound(SrcWng_MiscVarTypeData%BN_Cm)
      if (.not. allocated(DstWng_MiscVarTypeData%BN_Cm)) then
         allocate(DstWng_MiscVarTypeData%BN_Cm(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%BN_Cm.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_MiscVarTypeData%BN_Cm = SrcWng_MiscVarTypeData%BN_Cm
   end if
   if (allocated(SrcWng_MiscVarTypeData%BN_Cx)) then
      LB(1:1) = lbound(SrcWng_MiscVarTypeData%BN_Cx)
      UB(1:1) = ubound(SrcWng_MiscVarTypeData%BN_Cx)
      if (.not. allocated(DstWng_MiscVarTypeData%BN_Cx)) then
         allocate(DstWng_MiscVarTypeData%BN_Cx(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%BN_Cx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_MiscVarTypeData%BN_Cx = SrcWng_MiscVarTypeData%BN_Cx
   end if
   if (allocated(SrcWng_MiscVarTypeData%BN_Cy)) then
      LB(1:1) = lbound(SrcWng_MiscVarTypeData%BN_Cy)
      UB(1:1) = ubound(SrcWng_MiscVarTypeData%BN_Cy)
      if (.not. allocated(DstWng_MiscVarTypeData%BN_Cy)) then
         allocate(DstWng_MiscVarTypeData%BN_Cy(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%BN_Cy.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_MiscVarTypeData%BN_Cy = SrcWng_MiscVarTypeData%BN_Cy
   end if
end subroutine

subroutine FVW_DestroyWng_MiscVarType(Wng_MiscVarTypeData, ErrStat, ErrMsg)
   type(Wng_MiscVarType), intent(inout) :: Wng_MiscVarTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FVW_DestroyWng_MiscVarType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(Wng_MiscVarTypeData%LE)) then
      deallocate(Wng_MiscVarTypeData%LE)
   end if
   if (allocated(Wng_MiscVarTypeData%TE)) then
      deallocate(Wng_MiscVarTypeData%TE)
   end if
   if (allocated(Wng_MiscVarTypeData%r_LL)) then
      deallocate(Wng_MiscVarTypeData%r_LL)
   end if
   if (allocated(Wng_MiscVarTypeData%CP)) then
      deallocate(Wng_MiscVarTypeData%CP)
   end if
   if (allocated(Wng_MiscVarTypeData%Tang)) then
      deallocate(Wng_MiscVarTypeData%Tang)
   end if
   if (allocated(Wng_MiscVarTypeData%Norm)) then
      deallocate(Wng_MiscVarTypeData%Norm)
   end if
   if (allocated(Wng_MiscVarTypeData%Orth)) then
      deallocate(Wng_MiscVarTypeData%Orth)
   end if
   if (allocated(Wng_MiscVarTypeData%dl)) then
      deallocate(Wng_MiscVarTypeData%dl)
   end if
   if (allocated(Wng_MiscVarTypeData%Area)) then
      deallocate(Wng_MiscVarTypeData%Area)
   end if
   if (allocated(Wng_MiscVarTypeData%diag_LL)) then
      deallocate(Wng_MiscVarTypeData%diag_LL)
   end if
   if (allocated(Wng_MiscVarTypeData%Vind_CP)) then
      deallocate(Wng_MiscVarTypeData%Vind_CP)
   end if
   if (allocated(Wng_MiscVarTypeData%Vtot_CP)) then
      deallocate(Wng_MiscVarTypeData%Vtot_CP)
   end if
   if (allocated(Wng_MiscVarTypeData%Vstr_CP)) then
      deallocate(Wng_MiscVarTypeData%Vstr_CP)
   end if
   if (allocated(Wng_MiscVarTypeData%Vwnd_CP)) then
      deallocate(Wng_MiscVarTypeData%Vwnd_CP)
   end if
   if (allocated(Wng_MiscVarTypeData%Vwnd_NW)) then
      deallocate(Wng_MiscVarTypeData%Vwnd_NW)
   end if
   if (allocated(Wng_MiscVarTypeData%Vwnd_FW)) then
      deallocate(Wng_MiscVarTypeData%Vwnd_FW)
   end if
   if (allocated(Wng_MiscVarTypeData%Vind_NW)) then
      deallocate(Wng_MiscVarTypeData%Vind_NW)
   end if
   if (allocated(Wng_MiscVarTypeData%Vind_FW)) then
      deallocate(Wng_MiscVarTypeData%Vind_FW)
   end if
   if (allocated(Wng_MiscVarTypeData%PitchAndTwist)) then
      deallocate(Wng_MiscVarTypeData%PitchAndTwist)
   end if
   if (allocated(Wng_MiscVarTypeData%alpha_LL)) then
      deallocate(Wng_MiscVarTypeData%alpha_LL)
   end if
   if (allocated(Wng_MiscVarTypeData%Vreln_LL)) then
      deallocate(Wng_MiscVarTypeData%Vreln_LL)
   end if
   if (allocated(Wng_MiscVarTypeData%u_UA)) then
      LB(1:2) = lbound(Wng_MiscVarTypeData%u_UA)
      UB(1:2) = ubound(Wng_MiscVarTypeData%u_UA)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call UA_DestroyInput(Wng_MiscVarTypeData%u_UA(i1,i2), ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         end do
      end do
      deallocate(Wng_MiscVarTypeData%u_UA)
   end if
   call UA_DestroyMisc(Wng_MiscVarTypeData%m_UA, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call UA_DestroyOutput(Wng_MiscVarTypeData%y_UA, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call UA_DestroyParam(Wng_MiscVarTypeData%p_UA, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(Wng_MiscVarTypeData%Vind_LL)) then
      deallocate(Wng_MiscVarTypeData%Vind_LL)
   end if
   if (allocated(Wng_MiscVarTypeData%BN_AxInd)) then
      deallocate(Wng_MiscVarTypeData%BN_AxInd)
   end if
   if (allocated(Wng_MiscVarTypeData%BN_TanInd)) then
      deallocate(Wng_MiscVarTypeData%BN_TanInd)
   end if
   if (allocated(Wng_MiscVarTypeData%BN_Vrel)) then
      deallocate(Wng_MiscVarTypeData%BN_Vrel)
   end if
   if (allocated(Wng_MiscVarTypeData%BN_alpha)) then
      deallocate(Wng_MiscVarTypeData%BN_alpha)
   end if
   if (allocated(Wng_MiscVarTypeData%BN_phi)) then
      deallocate(Wng_MiscVarTypeData%BN_phi)
   end if
   if (allocated(Wng_MiscVarTypeData%BN_Re)) then
      deallocate(Wng_MiscVarTypeData%BN_Re)
   end if
   if (allocated(Wng_MiscVarTypeData%BN_URelWind_s)) then
      deallocate(Wng_MiscVarTypeData%BN_URelWind_s)
   end if
   if (allocated(Wng_MiscVarTypeData%BN_Cl_Static)) then
      deallocate(Wng_MiscVarTypeData%BN_Cl_Static)
   end if
   if (allocated(Wng_MiscVarTypeData%BN_Cd_Static)) then
      deallocate(Wng_MiscVarTypeData%BN_Cd_Static)
   end if
   if (allocated(Wng_MiscVarTypeData%BN_Cm_Static)) then
      deallocate(Wng_MiscVarTypeData%BN_Cm_Static)
   end if
   if (allocated(Wng_MiscVarTypeData%BN_Cpmin)) then
      deallocate(Wng_MiscVarTypeData%BN_Cpmin)
   end if
   if (allocated(Wng_MiscVarTypeData%BN_Cl)) then
      deallocate(Wng_MiscVarTypeData%BN_Cl)
   end if
   if (allocated(Wng_MiscVarTypeData%BN_Cd)) then
      deallocate(Wng_MiscVarTypeData%BN_Cd)
   end if
   if (allocated(Wng_MiscVarTypeData%BN_Cm)) then
      deallocate(Wng_MiscVarTypeData%BN_Cm)
   end if
   if (allocated(Wng_MiscVarTypeData%BN_Cx)) then
      deallocate(Wng_MiscVarTypeData%BN_Cx)
   end if
   if (allocated(Wng_MiscVarTypeData%BN_Cy)) then
      deallocate(Wng_MiscVarTypeData%BN_Cy)
   end if
end subroutine

subroutine FVW_PackWng_MiscVarType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Wng_MiscVarType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FVW_PackWng_MiscVarType'
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)   :: LB(3), UB(3)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%LE)
   call RegPackAlloc(RF, InData%TE)
   call RegPackAlloc(RF, InData%r_LL)
   call RegPackAlloc(RF, InData%CP)
   call RegPackAlloc(RF, InData%Tang)
   call RegPackAlloc(RF, InData%Norm)
   call RegPackAlloc(RF, InData%Orth)
   call RegPackAlloc(RF, InData%dl)
   call RegPackAlloc(RF, InData%Area)
   call RegPackAlloc(RF, InData%diag_LL)
   call RegPackAlloc(RF, InData%Vind_CP)
   call RegPackAlloc(RF, InData%Vtot_CP)
   call RegPackAlloc(RF, InData%Vstr_CP)
   call RegPackAlloc(RF, InData%Vwnd_CP)
   call RegPackAlloc(RF, InData%Vwnd_NW)
   call RegPackAlloc(RF, InData%Vwnd_FW)
   call RegPackAlloc(RF, InData%Vind_NW)
   call RegPackAlloc(RF, InData%Vind_FW)
   call RegPackAlloc(RF, InData%PitchAndTwist)
   call RegPack(RF, InData%iTip)
   call RegPack(RF, InData%iRoot)
   call RegPackAlloc(RF, InData%alpha_LL)
   call RegPackAlloc(RF, InData%Vreln_LL)
   call RegPack(RF, allocated(InData%u_UA))
   if (allocated(InData%u_UA)) then
      call RegPackBounds(RF, 2, lbound(InData%u_UA), ubound(InData%u_UA))
      LB(1:2) = lbound(InData%u_UA)
      UB(1:2) = ubound(InData%u_UA)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call UA_PackInput(RF, InData%u_UA(i1,i2)) 
         end do
      end do
   end if
   call UA_PackMisc(RF, InData%m_UA) 
   call UA_PackOutput(RF, InData%y_UA) 
   call UA_PackParam(RF, InData%p_UA) 
   call RegPackAlloc(RF, InData%Vind_LL)
   call RegPackAlloc(RF, InData%BN_AxInd)
   call RegPackAlloc(RF, InData%BN_TanInd)
   call RegPackAlloc(RF, InData%BN_Vrel)
   call RegPackAlloc(RF, InData%BN_alpha)
   call RegPackAlloc(RF, InData%BN_phi)
   call RegPackAlloc(RF, InData%BN_Re)
   call RegPackAlloc(RF, InData%BN_URelWind_s)
   call RegPackAlloc(RF, InData%BN_Cl_Static)
   call RegPackAlloc(RF, InData%BN_Cd_Static)
   call RegPackAlloc(RF, InData%BN_Cm_Static)
   call RegPackAlloc(RF, InData%BN_Cpmin)
   call RegPackAlloc(RF, InData%BN_Cl)
   call RegPackAlloc(RF, InData%BN_Cd)
   call RegPackAlloc(RF, InData%BN_Cm)
   call RegPackAlloc(RF, InData%BN_Cx)
   call RegPackAlloc(RF, InData%BN_Cy)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FVW_UnPackWng_MiscVarType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Wng_MiscVarType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FVW_UnPackWng_MiscVarType'
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%LE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%r_LL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%CP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Tang); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Norm); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Orth); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%dl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Area); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%diag_LL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Vind_CP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Vtot_CP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Vstr_CP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Vwnd_CP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Vwnd_NW); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Vwnd_FW); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Vind_NW); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Vind_FW); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PitchAndTwist); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%iTip); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%iRoot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%alpha_LL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Vreln_LL); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%u_UA)) deallocate(OutData%u_UA)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 2, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%u_UA(LB(1):UB(1),LB(2):UB(2)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%u_UA.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call UA_UnpackInput(RF, OutData%u_UA(i1,i2)) ! u_UA 
         end do
      end do
   end if
   call UA_UnpackMisc(RF, OutData%m_UA) ! m_UA 
   call UA_UnpackOutput(RF, OutData%y_UA) ! y_UA 
   call UA_UnpackParam(RF, OutData%p_UA) ! p_UA 
   call RegUnpackAlloc(RF, OutData%Vind_LL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BN_AxInd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BN_TanInd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BN_Vrel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BN_alpha); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BN_phi); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BN_Re); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BN_URelWind_s); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BN_Cl_Static); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BN_Cd_Static); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BN_Cm_Static); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BN_Cpmin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BN_Cl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BN_Cd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BN_Cm); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BN_Cx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BN_Cy); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FVW_CopyMisc(SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg)
   type(FVW_MiscVarType), intent(in) :: SrcMiscData
   type(FVW_MiscVarType), intent(inout) :: DstMiscData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FVW_CopyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcMiscData%W)) then
      LB(1:1) = lbound(SrcMiscData%W)
      UB(1:1) = ubound(SrcMiscData%W)
      if (.not. allocated(DstMiscData%W)) then
         allocate(DstMiscData%W(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%W.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call FVW_CopyWng_MiscVarType(SrcMiscData%W(i1), DstMiscData%W(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstMiscData%FirstCall = SrcMiscData%FirstCall
   DstMiscData%nNW = SrcMiscData%nNW
   DstMiscData%nFW = SrcMiscData%nFW
   DstMiscData%iStep = SrcMiscData%iStep
   DstMiscData%VTKstep = SrcMiscData%VTKstep
   DstMiscData%VTKlastTime = SrcMiscData%VTKlastTime
   if (allocated(SrcMiscData%r_wind)) then
      LB(1:2) = lbound(SrcMiscData%r_wind)
      UB(1:2) = ubound(SrcMiscData%r_wind)
      if (.not. allocated(DstMiscData%r_wind)) then
         allocate(DstMiscData%r_wind(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%r_wind.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%r_wind = SrcMiscData%r_wind
   end if
   DstMiscData%ComputeWakeInduced = SrcMiscData%ComputeWakeInduced
   DstMiscData%OldWakeTime = SrcMiscData%OldWakeTime
   call FVW_CopyContState(SrcMiscData%dxdt, DstMiscData%dxdt, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call FVW_CopyContState(SrcMiscData%x1, DstMiscData%x1, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call FVW_CopyContState(SrcMiscData%x2, DstMiscData%x2, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstMiscData%t1 = SrcMiscData%t1
   DstMiscData%t2 = SrcMiscData%t2
   DstMiscData%UA_Flag = SrcMiscData%UA_Flag
   call FVW_CopyT_Sgmt(SrcMiscData%Sgmt, DstMiscData%Sgmt, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call FVW_CopyT_Part(SrcMiscData%Part, DstMiscData%Part, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcMiscData%CPs)) then
      LB(1:2) = lbound(SrcMiscData%CPs)
      UB(1:2) = ubound(SrcMiscData%CPs)
      if (.not. allocated(DstMiscData%CPs)) then
         allocate(DstMiscData%CPs(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%CPs.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%CPs = SrcMiscData%CPs
   end if
   if (allocated(SrcMiscData%Uind)) then
      LB(1:2) = lbound(SrcMiscData%Uind)
      UB(1:2) = ubound(SrcMiscData%Uind)
      if (.not. allocated(DstMiscData%Uind)) then
         allocate(DstMiscData%Uind(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%Uind.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%Uind = SrcMiscData%Uind
   end if
   if (allocated(SrcMiscData%GridOutputs)) then
      LB(1:1) = lbound(SrcMiscData%GridOutputs)
      UB(1:1) = ubound(SrcMiscData%GridOutputs)
      if (.not. allocated(DstMiscData%GridOutputs)) then
         allocate(DstMiscData%GridOutputs(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%GridOutputs.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call FVW_CopyGridOutType(SrcMiscData%GridOutputs(i1), DstMiscData%GridOutputs(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstMiscData%InfoReeval = SrcMiscData%InfoReeval
end subroutine

subroutine FVW_DestroyMisc(MiscData, ErrStat, ErrMsg)
   type(FVW_MiscVarType), intent(inout) :: MiscData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FVW_DestroyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(MiscData%W)) then
      LB(1:1) = lbound(MiscData%W)
      UB(1:1) = ubound(MiscData%W)
      do i1 = LB(1), UB(1)
         call FVW_DestroyWng_MiscVarType(MiscData%W(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MiscData%W)
   end if
   if (allocated(MiscData%r_wind)) then
      deallocate(MiscData%r_wind)
   end if
   call FVW_DestroyContState(MiscData%dxdt, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FVW_DestroyContState(MiscData%x1, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FVW_DestroyContState(MiscData%x2, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FVW_DestroyT_Sgmt(MiscData%Sgmt, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FVW_DestroyT_Part(MiscData%Part, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(MiscData%CPs)) then
      deallocate(MiscData%CPs)
   end if
   if (allocated(MiscData%Uind)) then
      deallocate(MiscData%Uind)
   end if
   if (allocated(MiscData%GridOutputs)) then
      LB(1:1) = lbound(MiscData%GridOutputs)
      UB(1:1) = ubound(MiscData%GridOutputs)
      do i1 = LB(1), UB(1)
         call FVW_DestroyGridOutType(MiscData%GridOutputs(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MiscData%GridOutputs)
   end if
end subroutine

subroutine FVW_PackMisc(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FVW_MiscVarType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FVW_PackMisc'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%W))
   if (allocated(InData%W)) then
      call RegPackBounds(RF, 1, lbound(InData%W), ubound(InData%W))
      LB(1:1) = lbound(InData%W)
      UB(1:1) = ubound(InData%W)
      do i1 = LB(1), UB(1)
         call FVW_PackWng_MiscVarType(RF, InData%W(i1)) 
      end do
   end if
   call RegPack(RF, InData%FirstCall)
   call RegPack(RF, InData%nNW)
   call RegPack(RF, InData%nFW)
   call RegPack(RF, InData%iStep)
   call RegPack(RF, InData%VTKstep)
   call RegPack(RF, InData%VTKlastTime)
   call RegPackAlloc(RF, InData%r_wind)
   call RegPack(RF, InData%ComputeWakeInduced)
   call RegPack(RF, InData%OldWakeTime)
   call FVW_PackContState(RF, InData%dxdt) 
   call FVW_PackContState(RF, InData%x1) 
   call FVW_PackContState(RF, InData%x2) 
   call RegPack(RF, InData%t1)
   call RegPack(RF, InData%t2)
   call RegPack(RF, InData%UA_Flag)
   call FVW_PackT_Sgmt(RF, InData%Sgmt) 
   call FVW_PackT_Part(RF, InData%Part) 
   call RegPackAlloc(RF, InData%CPs)
   call RegPackAlloc(RF, InData%Uind)
   call RegPack(RF, allocated(InData%GridOutputs))
   if (allocated(InData%GridOutputs)) then
      call RegPackBounds(RF, 1, lbound(InData%GridOutputs), ubound(InData%GridOutputs))
      LB(1:1) = lbound(InData%GridOutputs)
      UB(1:1) = ubound(InData%GridOutputs)
      do i1 = LB(1), UB(1)
         call FVW_PackGridOutType(RF, InData%GridOutputs(i1)) 
      end do
   end if
   call RegPack(RF, InData%InfoReeval)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FVW_UnPackMisc(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FVW_MiscVarType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FVW_UnPackMisc'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%W)) deallocate(OutData%W)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%W(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%W.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call FVW_UnpackWng_MiscVarType(RF, OutData%W(i1)) ! W 
      end do
   end if
   call RegUnpack(RF, OutData%FirstCall); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nNW); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nFW); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%iStep); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VTKstep); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VTKlastTime); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%r_wind); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ComputeWakeInduced); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OldWakeTime); if (RegCheckErr(RF, RoutineName)) return
   call FVW_UnpackContState(RF, OutData%dxdt) ! dxdt 
   call FVW_UnpackContState(RF, OutData%x1) ! x1 
   call FVW_UnpackContState(RF, OutData%x2) ! x2 
   call RegUnpack(RF, OutData%t1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%t2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UA_Flag); if (RegCheckErr(RF, RoutineName)) return
   call FVW_UnpackT_Sgmt(RF, OutData%Sgmt) ! Sgmt 
   call FVW_UnpackT_Part(RF, OutData%Part) ! Part 
   call RegUnpackAlloc(RF, OutData%CPs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Uind); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%GridOutputs)) deallocate(OutData%GridOutputs)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%GridOutputs(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%GridOutputs.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call FVW_UnpackGridOutType(RF, OutData%GridOutputs(i1)) ! GridOutputs 
      end do
   end if
   call RegUnpack(RF, OutData%InfoReeval); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FVW_CopyRot_InputType(SrcRot_InputTypeData, DstRot_InputTypeData, CtrlCode, ErrStat, ErrMsg)
   type(Rot_InputType), intent(in) :: SrcRot_InputTypeData
   type(Rot_InputType), intent(inout) :: DstRot_InputTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FVW_CopyRot_InputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstRot_InputTypeData%HubOrientation = SrcRot_InputTypeData%HubOrientation
   DstRot_InputTypeData%HubPosition = SrcRot_InputTypeData%HubPosition
end subroutine

subroutine FVW_DestroyRot_InputType(Rot_InputTypeData, ErrStat, ErrMsg)
   type(Rot_InputType), intent(inout) :: Rot_InputTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FVW_DestroyRot_InputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine FVW_PackRot_InputType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Rot_InputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FVW_PackRot_InputType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%HubOrientation)
   call RegPack(RF, InData%HubPosition)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FVW_UnPackRot_InputType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Rot_InputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FVW_UnPackRot_InputType'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%HubOrientation); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HubPosition); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FVW_CopyWng_InputType(SrcWng_InputTypeData, DstWng_InputTypeData, CtrlCode, ErrStat, ErrMsg)
   type(Wng_InputType), intent(in) :: SrcWng_InputTypeData
   type(Wng_InputType), intent(inout) :: DstWng_InputTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'FVW_CopyWng_InputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcWng_InputTypeData%Vwnd_LL)) then
      LB(1:2) = lbound(SrcWng_InputTypeData%Vwnd_LL)
      UB(1:2) = ubound(SrcWng_InputTypeData%Vwnd_LL)
      if (.not. allocated(DstWng_InputTypeData%Vwnd_LL)) then
         allocate(DstWng_InputTypeData%Vwnd_LL(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_InputTypeData%Vwnd_LL.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_InputTypeData%Vwnd_LL = SrcWng_InputTypeData%Vwnd_LL
   end if
   if (allocated(SrcWng_InputTypeData%omega_z)) then
      LB(1:1) = lbound(SrcWng_InputTypeData%omega_z)
      UB(1:1) = ubound(SrcWng_InputTypeData%omega_z)
      if (.not. allocated(DstWng_InputTypeData%omega_z)) then
         allocate(DstWng_InputTypeData%omega_z(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_InputTypeData%omega_z.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_InputTypeData%omega_z = SrcWng_InputTypeData%omega_z
   end if
end subroutine

subroutine FVW_DestroyWng_InputType(Wng_InputTypeData, ErrStat, ErrMsg)
   type(Wng_InputType), intent(inout) :: Wng_InputTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FVW_DestroyWng_InputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(Wng_InputTypeData%Vwnd_LL)) then
      deallocate(Wng_InputTypeData%Vwnd_LL)
   end if
   if (allocated(Wng_InputTypeData%omega_z)) then
      deallocate(Wng_InputTypeData%omega_z)
   end if
end subroutine

subroutine FVW_PackWng_InputType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Wng_InputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FVW_PackWng_InputType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%Vwnd_LL)
   call RegPackAlloc(RF, InData%omega_z)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FVW_UnPackWng_InputType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Wng_InputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FVW_UnPackWng_InputType'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%Vwnd_LL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%omega_z); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FVW_CopyInput(SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg)
   type(FVW_InputType), intent(inout) :: SrcInputData
   type(FVW_InputType), intent(inout) :: DstInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FVW_CopyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcInputData%rotors)) then
      LB(1:1) = lbound(SrcInputData%rotors)
      UB(1:1) = ubound(SrcInputData%rotors)
      if (.not. allocated(DstInputData%rotors)) then
         allocate(DstInputData%rotors(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%rotors.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call FVW_CopyRot_InputType(SrcInputData%rotors(i1), DstInputData%rotors(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcInputData%W)) then
      LB(1:1) = lbound(SrcInputData%W)
      UB(1:1) = ubound(SrcInputData%W)
      if (.not. allocated(DstInputData%W)) then
         allocate(DstInputData%W(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%W.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call FVW_CopyWng_InputType(SrcInputData%W(i1), DstInputData%W(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcInputData%WingsMesh)) then
      LB(1:1) = lbound(SrcInputData%WingsMesh)
      UB(1:1) = ubound(SrcInputData%WingsMesh)
      if (.not. allocated(DstInputData%WingsMesh)) then
         allocate(DstInputData%WingsMesh(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%WingsMesh.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcInputData%WingsMesh(i1), DstInputData%WingsMesh(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcInputData%V_wind)) then
      LB(1:2) = lbound(SrcInputData%V_wind)
      UB(1:2) = ubound(SrcInputData%V_wind)
      if (.not. allocated(DstInputData%V_wind)) then
         allocate(DstInputData%V_wind(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%V_wind.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%V_wind = SrcInputData%V_wind
   end if
end subroutine

subroutine FVW_DestroyInput(InputData, ErrStat, ErrMsg)
   type(FVW_InputType), intent(inout) :: InputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FVW_DestroyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InputData%rotors)) then
      LB(1:1) = lbound(InputData%rotors)
      UB(1:1) = ubound(InputData%rotors)
      do i1 = LB(1), UB(1)
         call FVW_DestroyRot_InputType(InputData%rotors(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InputData%rotors)
   end if
   if (allocated(InputData%W)) then
      LB(1:1) = lbound(InputData%W)
      UB(1:1) = ubound(InputData%W)
      do i1 = LB(1), UB(1)
         call FVW_DestroyWng_InputType(InputData%W(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InputData%W)
   end if
   if (allocated(InputData%WingsMesh)) then
      LB(1:1) = lbound(InputData%WingsMesh)
      UB(1:1) = ubound(InputData%WingsMesh)
      do i1 = LB(1), UB(1)
         call MeshDestroy( InputData%WingsMesh(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InputData%WingsMesh)
   end if
   if (allocated(InputData%V_wind)) then
      deallocate(InputData%V_wind)
   end if
end subroutine

subroutine FVW_PackInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FVW_InputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FVW_PackInput'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%rotors))
   if (allocated(InData%rotors)) then
      call RegPackBounds(RF, 1, lbound(InData%rotors), ubound(InData%rotors))
      LB(1:1) = lbound(InData%rotors)
      UB(1:1) = ubound(InData%rotors)
      do i1 = LB(1), UB(1)
         call FVW_PackRot_InputType(RF, InData%rotors(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%W))
   if (allocated(InData%W)) then
      call RegPackBounds(RF, 1, lbound(InData%W), ubound(InData%W))
      LB(1:1) = lbound(InData%W)
      UB(1:1) = ubound(InData%W)
      do i1 = LB(1), UB(1)
         call FVW_PackWng_InputType(RF, InData%W(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%WingsMesh))
   if (allocated(InData%WingsMesh)) then
      call RegPackBounds(RF, 1, lbound(InData%WingsMesh), ubound(InData%WingsMesh))
      LB(1:1) = lbound(InData%WingsMesh)
      UB(1:1) = ubound(InData%WingsMesh)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%WingsMesh(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%V_wind)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FVW_UnPackInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FVW_InputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FVW_UnPackInput'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%rotors)) deallocate(OutData%rotors)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%rotors(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%rotors.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call FVW_UnpackRot_InputType(RF, OutData%rotors(i1)) ! rotors 
      end do
   end if
   if (allocated(OutData%W)) deallocate(OutData%W)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%W(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%W.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call FVW_UnpackWng_InputType(RF, OutData%W(i1)) ! W 
      end do
   end if
   if (allocated(OutData%WingsMesh)) deallocate(OutData%WingsMesh)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%WingsMesh(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%WingsMesh.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%WingsMesh(i1)) ! WingsMesh 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%V_wind); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FVW_CopyDiscState(SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg)
   type(FVW_DiscreteStateType), intent(in) :: SrcDiscStateData
   type(FVW_DiscreteStateType), intent(inout) :: DstDiscStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FVW_CopyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstDiscStateData%Dummy = SrcDiscStateData%Dummy
   if (allocated(SrcDiscStateData%UA)) then
      LB(1:1) = lbound(SrcDiscStateData%UA)
      UB(1:1) = ubound(SrcDiscStateData%UA)
      if (.not. allocated(DstDiscStateData%UA)) then
         allocate(DstDiscStateData%UA(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%UA.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call UA_CopyDiscState(SrcDiscStateData%UA(i1), DstDiscStateData%UA(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
end subroutine

subroutine FVW_DestroyDiscState(DiscStateData, ErrStat, ErrMsg)
   type(FVW_DiscreteStateType), intent(inout) :: DiscStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FVW_DestroyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(DiscStateData%UA)) then
      LB(1:1) = lbound(DiscStateData%UA)
      UB(1:1) = ubound(DiscStateData%UA)
      do i1 = LB(1), UB(1)
         call UA_DestroyDiscState(DiscStateData%UA(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(DiscStateData%UA)
   end if
end subroutine

subroutine FVW_PackDiscState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FVW_DiscreteStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FVW_PackDiscState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%Dummy)
   call RegPack(RF, allocated(InData%UA))
   if (allocated(InData%UA)) then
      call RegPackBounds(RF, 1, lbound(InData%UA), ubound(InData%UA))
      LB(1:1) = lbound(InData%UA)
      UB(1:1) = ubound(InData%UA)
      do i1 = LB(1), UB(1)
         call UA_PackDiscState(RF, InData%UA(i1)) 
      end do
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FVW_UnPackDiscState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FVW_DiscreteStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FVW_UnPackDiscState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%Dummy); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%UA)) deallocate(OutData%UA)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%UA(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%UA.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call UA_UnpackDiscState(RF, OutData%UA(i1)) ! UA 
      end do
   end if
end subroutine

subroutine FVW_CopyWng_ConstraintStateType(SrcWng_ConstraintStateTypeData, DstWng_ConstraintStateTypeData, CtrlCode, ErrStat, ErrMsg)
   type(Wng_ConstraintStateType), intent(in) :: SrcWng_ConstraintStateTypeData
   type(Wng_ConstraintStateType), intent(inout) :: DstWng_ConstraintStateTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'FVW_CopyWng_ConstraintStateType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcWng_ConstraintStateTypeData%Gamma_LL)) then
      LB(1:1) = lbound(SrcWng_ConstraintStateTypeData%Gamma_LL)
      UB(1:1) = ubound(SrcWng_ConstraintStateTypeData%Gamma_LL)
      if (.not. allocated(DstWng_ConstraintStateTypeData%Gamma_LL)) then
         allocate(DstWng_ConstraintStateTypeData%Gamma_LL(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_ConstraintStateTypeData%Gamma_LL.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_ConstraintStateTypeData%Gamma_LL = SrcWng_ConstraintStateTypeData%Gamma_LL
   end if
end subroutine

subroutine FVW_DestroyWng_ConstraintStateType(Wng_ConstraintStateTypeData, ErrStat, ErrMsg)
   type(Wng_ConstraintStateType), intent(inout) :: Wng_ConstraintStateTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FVW_DestroyWng_ConstraintStateType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(Wng_ConstraintStateTypeData%Gamma_LL)) then
      deallocate(Wng_ConstraintStateTypeData%Gamma_LL)
   end if
end subroutine

subroutine FVW_PackWng_ConstraintStateType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Wng_ConstraintStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FVW_PackWng_ConstraintStateType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%Gamma_LL)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FVW_UnPackWng_ConstraintStateType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Wng_ConstraintStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FVW_UnPackWng_ConstraintStateType'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%Gamma_LL); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FVW_CopyConstrState(SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg)
   type(FVW_ConstraintStateType), intent(in) :: SrcConstrStateData
   type(FVW_ConstraintStateType), intent(inout) :: DstConstrStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FVW_CopyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcConstrStateData%W)) then
      LB(1:1) = lbound(SrcConstrStateData%W)
      UB(1:1) = ubound(SrcConstrStateData%W)
      if (.not. allocated(DstConstrStateData%W)) then
         allocate(DstConstrStateData%W(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstConstrStateData%W.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call FVW_CopyWng_ConstraintStateType(SrcConstrStateData%W(i1), DstConstrStateData%W(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstConstrStateData%residual = SrcConstrStateData%residual
end subroutine

subroutine FVW_DestroyConstrState(ConstrStateData, ErrStat, ErrMsg)
   type(FVW_ConstraintStateType), intent(inout) :: ConstrStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FVW_DestroyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ConstrStateData%W)) then
      LB(1:1) = lbound(ConstrStateData%W)
      UB(1:1) = ubound(ConstrStateData%W)
      do i1 = LB(1), UB(1)
         call FVW_DestroyWng_ConstraintStateType(ConstrStateData%W(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ConstrStateData%W)
   end if
end subroutine

subroutine FVW_PackConstrState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FVW_ConstraintStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FVW_PackConstrState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%W))
   if (allocated(InData%W)) then
      call RegPackBounds(RF, 1, lbound(InData%W), ubound(InData%W))
      LB(1:1) = lbound(InData%W)
      UB(1:1) = ubound(InData%W)
      do i1 = LB(1), UB(1)
         call FVW_PackWng_ConstraintStateType(RF, InData%W(i1)) 
      end do
   end if
   call RegPack(RF, InData%residual)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FVW_UnPackConstrState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FVW_ConstraintStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FVW_UnPackConstrState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%W)) deallocate(OutData%W)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%W(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%W.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call FVW_UnpackWng_ConstraintStateType(RF, OutData%W(i1)) ! W 
      end do
   end if
   call RegUnpack(RF, OutData%residual); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FVW_CopyOtherState(SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg)
   type(FVW_OtherStateType), intent(in) :: SrcOtherStateData
   type(FVW_OtherStateType), intent(inout) :: DstOtherStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FVW_CopyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstOtherStateData%Dummy = SrcOtherStateData%Dummy
   if (allocated(SrcOtherStateData%UA)) then
      LB(1:1) = lbound(SrcOtherStateData%UA)
      UB(1:1) = ubound(SrcOtherStateData%UA)
      if (.not. allocated(DstOtherStateData%UA)) then
         allocate(DstOtherStateData%UA(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%UA.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call UA_CopyOtherState(SrcOtherStateData%UA(i1), DstOtherStateData%UA(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
end subroutine

subroutine FVW_DestroyOtherState(OtherStateData, ErrStat, ErrMsg)
   type(FVW_OtherStateType), intent(inout) :: OtherStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FVW_DestroyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(OtherStateData%UA)) then
      LB(1:1) = lbound(OtherStateData%UA)
      UB(1:1) = ubound(OtherStateData%UA)
      do i1 = LB(1), UB(1)
         call UA_DestroyOtherState(OtherStateData%UA(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(OtherStateData%UA)
   end if
end subroutine

subroutine FVW_PackOtherState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FVW_OtherStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FVW_PackOtherState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%Dummy)
   call RegPack(RF, allocated(InData%UA))
   if (allocated(InData%UA)) then
      call RegPackBounds(RF, 1, lbound(InData%UA), ubound(InData%UA))
      LB(1:1) = lbound(InData%UA)
      UB(1:1) = ubound(InData%UA)
      do i1 = LB(1), UB(1)
         call UA_PackOtherState(RF, InData%UA(i1)) 
      end do
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FVW_UnPackOtherState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FVW_OtherStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FVW_UnPackOtherState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%Dummy); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%UA)) deallocate(OutData%UA)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%UA(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%UA.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call UA_UnpackOtherState(RF, OutData%UA(i1)) ! UA 
      end do
   end if
end subroutine

subroutine FVW_CopyWng_InitInputType(SrcWng_InitInputTypeData, DstWng_InitInputTypeData, CtrlCode, ErrStat, ErrMsg)
   type(Wng_InitInputType), intent(in) :: SrcWng_InitInputTypeData
   type(Wng_InitInputType), intent(inout) :: DstWng_InitInputTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'FVW_CopyWng_InitInputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcWng_InitInputTypeData%AFindx)) then
      LB(1:2) = lbound(SrcWng_InitInputTypeData%AFindx)
      UB(1:2) = ubound(SrcWng_InitInputTypeData%AFindx)
      if (.not. allocated(DstWng_InitInputTypeData%AFindx)) then
         allocate(DstWng_InitInputTypeData%AFindx(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_InitInputTypeData%AFindx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_InitInputTypeData%AFindx = SrcWng_InitInputTypeData%AFindx
   end if
   if (allocated(SrcWng_InitInputTypeData%chord)) then
      LB(1:1) = lbound(SrcWng_InitInputTypeData%chord)
      UB(1:1) = ubound(SrcWng_InitInputTypeData%chord)
      if (.not. allocated(DstWng_InitInputTypeData%chord)) then
         allocate(DstWng_InitInputTypeData%chord(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_InitInputTypeData%chord.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_InitInputTypeData%chord = SrcWng_InitInputTypeData%chord
   end if
   if (allocated(SrcWng_InitInputTypeData%RElm)) then
      LB(1:1) = lbound(SrcWng_InitInputTypeData%RElm)
      UB(1:1) = ubound(SrcWng_InitInputTypeData%RElm)
      if (.not. allocated(DstWng_InitInputTypeData%RElm)) then
         allocate(DstWng_InitInputTypeData%RElm(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWng_InitInputTypeData%RElm.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWng_InitInputTypeData%RElm = SrcWng_InitInputTypeData%RElm
   end if
   DstWng_InitInputTypeData%iRotor = SrcWng_InitInputTypeData%iRotor
   DstWng_InitInputTypeData%UAOff_innerNode = SrcWng_InitInputTypeData%UAOff_innerNode
   DstWng_InitInputTypeData%UAOff_outerNode = SrcWng_InitInputTypeData%UAOff_outerNode
end subroutine

subroutine FVW_DestroyWng_InitInputType(Wng_InitInputTypeData, ErrStat, ErrMsg)
   type(Wng_InitInputType), intent(inout) :: Wng_InitInputTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FVW_DestroyWng_InitInputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(Wng_InitInputTypeData%AFindx)) then
      deallocate(Wng_InitInputTypeData%AFindx)
   end if
   if (allocated(Wng_InitInputTypeData%chord)) then
      deallocate(Wng_InitInputTypeData%chord)
   end if
   if (allocated(Wng_InitInputTypeData%RElm)) then
      deallocate(Wng_InitInputTypeData%RElm)
   end if
end subroutine

subroutine FVW_PackWng_InitInputType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Wng_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FVW_PackWng_InitInputType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%AFindx)
   call RegPackAlloc(RF, InData%chord)
   call RegPackAlloc(RF, InData%RElm)
   call RegPack(RF, InData%iRotor)
   call RegPack(RF, InData%UAOff_innerNode)
   call RegPack(RF, InData%UAOff_outerNode)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FVW_UnPackWng_InitInputType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Wng_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FVW_UnPackWng_InitInputType'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%AFindx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%chord); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RElm); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%iRotor); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UAOff_innerNode); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UAOff_outerNode); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FVW_CopyInitInput(SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg)
   type(FVW_InitInputType), intent(inout) :: SrcInitInputData
   type(FVW_InitInputType), intent(inout) :: DstInitInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FVW_CopyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInitInputData%FVWFileName = SrcInitInputData%FVWFileName
   DstInitInputData%RootName = SrcInitInputData%RootName
   if (allocated(SrcInitInputData%W)) then
      LB(1:1) = lbound(SrcInitInputData%W)
      UB(1:1) = ubound(SrcInitInputData%W)
      if (.not. allocated(DstInitInputData%W)) then
         allocate(DstInitInputData%W(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%W.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call FVW_CopyWng_InitInputType(SrcInitInputData%W(i1), DstInitInputData%W(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcInitInputData%WingsMesh)) then
      LB(1:1) = lbound(SrcInitInputData%WingsMesh)
      UB(1:1) = ubound(SrcInitInputData%WingsMesh)
      if (.not. allocated(DstInitInputData%WingsMesh)) then
         allocate(DstInitInputData%WingsMesh(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%WingsMesh.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcInitInputData%WingsMesh(i1), DstInitInputData%WingsMesh(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstInitInputData%numBladeNodes = SrcInitInputData%numBladeNodes
   DstInitInputData%DTaero = SrcInitInputData%DTaero
   DstInitInputData%KinVisc = SrcInitInputData%KinVisc
   DstInitInputData%MHK = SrcInitInputData%MHK
   DstInitInputData%WtrDpth = SrcInitInputData%WtrDpth
   DstInitInputData%UA_Flag = SrcInitInputData%UA_Flag
   call UA_CopyInitInput(SrcInitInputData%UA_Init, DstInitInputData%UA_Init, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine FVW_DestroyInitInput(InitInputData, ErrStat, ErrMsg)
   type(FVW_InitInputType), intent(inout) :: InitInputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FVW_DestroyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InitInputData%W)) then
      LB(1:1) = lbound(InitInputData%W)
      UB(1:1) = ubound(InitInputData%W)
      do i1 = LB(1), UB(1)
         call FVW_DestroyWng_InitInputType(InitInputData%W(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InitInputData%W)
   end if
   if (allocated(InitInputData%WingsMesh)) then
      LB(1:1) = lbound(InitInputData%WingsMesh)
      UB(1:1) = ubound(InitInputData%WingsMesh)
      do i1 = LB(1), UB(1)
         call MeshDestroy( InitInputData%WingsMesh(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InitInputData%WingsMesh)
   end if
   call UA_DestroyInitInput(InitInputData%UA_Init, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine FVW_PackInitInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FVW_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FVW_PackInitInput'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%FVWFileName)
   call RegPack(RF, InData%RootName)
   call RegPack(RF, allocated(InData%W))
   if (allocated(InData%W)) then
      call RegPackBounds(RF, 1, lbound(InData%W), ubound(InData%W))
      LB(1:1) = lbound(InData%W)
      UB(1:1) = ubound(InData%W)
      do i1 = LB(1), UB(1)
         call FVW_PackWng_InitInputType(RF, InData%W(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%WingsMesh))
   if (allocated(InData%WingsMesh)) then
      call RegPackBounds(RF, 1, lbound(InData%WingsMesh), ubound(InData%WingsMesh))
      LB(1:1) = lbound(InData%WingsMesh)
      UB(1:1) = ubound(InData%WingsMesh)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%WingsMesh(i1)) 
      end do
   end if
   call RegPack(RF, InData%numBladeNodes)
   call RegPack(RF, InData%DTaero)
   call RegPack(RF, InData%KinVisc)
   call RegPack(RF, InData%MHK)
   call RegPack(RF, InData%WtrDpth)
   call RegPack(RF, InData%UA_Flag)
   call UA_PackInitInput(RF, InData%UA_Init) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FVW_UnPackInitInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FVW_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FVW_UnPackInitInput'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%FVWFileName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootName); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%W)) deallocate(OutData%W)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%W(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%W.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call FVW_UnpackWng_InitInputType(RF, OutData%W(i1)) ! W 
      end do
   end if
   if (allocated(OutData%WingsMesh)) deallocate(OutData%WingsMesh)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%WingsMesh(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%WingsMesh.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%WingsMesh(i1)) ! WingsMesh 
      end do
   end if
   call RegUnpack(RF, OutData%numBladeNodes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DTaero); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%KinVisc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MHK); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WtrDpth); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UA_Flag); if (RegCheckErr(RF, RoutineName)) return
   call UA_UnpackInitInput(RF, OutData%UA_Init) ! UA_Init 
end subroutine

subroutine FVW_CopyInputFile(SrcInputFileData, DstInputFileData, CtrlCode, ErrStat, ErrMsg)
   type(FVW_InputFile), intent(in) :: SrcInputFileData
   type(FVW_InputFile), intent(inout) :: DstInputFileData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FVW_CopyInputFile'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInputFileData%CircSolvMethod = SrcInputFileData%CircSolvMethod
   DstInputFileData%CirculationFile = SrcInputFileData%CirculationFile
   DstInputFileData%CircSolvMaxIter = SrcInputFileData%CircSolvMaxIter
   DstInputFileData%CircSolvConvCrit = SrcInputFileData%CircSolvConvCrit
   DstInputFileData%CircSolvRelaxation = SrcInputFileData%CircSolvRelaxation
   DstInputFileData%IntMethod = SrcInputFileData%IntMethod
   DstInputFileData%FreeWake = SrcInputFileData%FreeWake
   DstInputFileData%FreeWakeStart = SrcInputFileData%FreeWakeStart
   DstInputFileData%FullCircStart = SrcInputFileData%FullCircStart
   DstInputFileData%DTfvw = SrcInputFileData%DTfvw
   DstInputFileData%CircSolvPolar = SrcInputFileData%CircSolvPolar
   DstInputFileData%nNWPanels = SrcInputFileData%nNWPanels
   DstInputFileData%nNWPanelsFree = SrcInputFileData%nNWPanelsFree
   DstInputFileData%nFWPanels = SrcInputFileData%nFWPanels
   DstInputFileData%nFWPanelsFree = SrcInputFileData%nFWPanelsFree
   DstInputFileData%FWShedVorticity = SrcInputFileData%FWShedVorticity
   DstInputFileData%DiffusionMethod = SrcInputFileData%DiffusionMethod
   DstInputFileData%CoreSpreadEddyVisc = SrcInputFileData%CoreSpreadEddyVisc
   DstInputFileData%RegDeterMethod = SrcInputFileData%RegDeterMethod
   DstInputFileData%RegFunction = SrcInputFileData%RegFunction
   DstInputFileData%WakeRegMethod = SrcInputFileData%WakeRegMethod
   DstInputFileData%WakeRegParam = SrcInputFileData%WakeRegParam
   DstInputFileData%WingRegParam = SrcInputFileData%WingRegParam
   DstInputFileData%ShearModel = SrcInputFileData%ShearModel
   DstInputFileData%TwrShadowOnWake = SrcInputFileData%TwrShadowOnWake
   DstInputFileData%VelocityMethod = SrcInputFileData%VelocityMethod
   DstInputFileData%TreeBranchFactor = SrcInputFileData%TreeBranchFactor
   DstInputFileData%PartPerSegment = SrcInputFileData%PartPerSegment
   DstInputFileData%WrVTK = SrcInputFileData%WrVTK
   DstInputFileData%VTKBlades = SrcInputFileData%VTKBlades
   DstInputFileData%DTvtk = SrcInputFileData%DTvtk
   DstInputFileData%VTKCoord = SrcInputFileData%VTKCoord
end subroutine

subroutine FVW_DestroyInputFile(InputFileData, ErrStat, ErrMsg)
   type(FVW_InputFile), intent(inout) :: InputFileData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FVW_DestroyInputFile'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine FVW_PackInputFile(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FVW_InputFile), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FVW_PackInputFile'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%CircSolvMethod)
   call RegPack(RF, InData%CirculationFile)
   call RegPack(RF, InData%CircSolvMaxIter)
   call RegPack(RF, InData%CircSolvConvCrit)
   call RegPack(RF, InData%CircSolvRelaxation)
   call RegPack(RF, InData%IntMethod)
   call RegPack(RF, InData%FreeWake)
   call RegPack(RF, InData%FreeWakeStart)
   call RegPack(RF, InData%FullCircStart)
   call RegPack(RF, InData%DTfvw)
   call RegPack(RF, InData%CircSolvPolar)
   call RegPack(RF, InData%nNWPanels)
   call RegPack(RF, InData%nNWPanelsFree)
   call RegPack(RF, InData%nFWPanels)
   call RegPack(RF, InData%nFWPanelsFree)
   call RegPack(RF, InData%FWShedVorticity)
   call RegPack(RF, InData%DiffusionMethod)
   call RegPack(RF, InData%CoreSpreadEddyVisc)
   call RegPack(RF, InData%RegDeterMethod)
   call RegPack(RF, InData%RegFunction)
   call RegPack(RF, InData%WakeRegMethod)
   call RegPack(RF, InData%WakeRegParam)
   call RegPack(RF, InData%WingRegParam)
   call RegPack(RF, InData%ShearModel)
   call RegPack(RF, InData%TwrShadowOnWake)
   call RegPack(RF, InData%VelocityMethod)
   call RegPack(RF, InData%TreeBranchFactor)
   call RegPack(RF, InData%PartPerSegment)
   call RegPack(RF, InData%WrVTK)
   call RegPack(RF, InData%VTKBlades)
   call RegPack(RF, InData%DTvtk)
   call RegPack(RF, InData%VTKCoord)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FVW_UnPackInputFile(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FVW_InputFile), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FVW_UnPackInputFile'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%CircSolvMethod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CirculationFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CircSolvMaxIter); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CircSolvConvCrit); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CircSolvRelaxation); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%IntMethod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FreeWake); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FreeWakeStart); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FullCircStart); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DTfvw); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CircSolvPolar); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nNWPanels); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nNWPanelsFree); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nFWPanels); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nFWPanelsFree); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FWShedVorticity); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DiffusionMethod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CoreSpreadEddyVisc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RegDeterMethod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RegFunction); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WakeRegMethod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WakeRegParam); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WingRegParam); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ShearModel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TwrShadowOnWake); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VelocityMethod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TreeBranchFactor); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PartPerSegment); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WrVTK); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VTKBlades); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DTvtk); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VTKCoord); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FVW_CopyInitOutput(SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg)
   type(FVW_InitOutputType), intent(in) :: SrcInitOutputData
   type(FVW_InitOutputType), intent(inout) :: DstInitOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FVW_CopyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInitOutputData%Dummy = SrcInitOutputData%Dummy
end subroutine

subroutine FVW_DestroyInitOutput(InitOutputData, ErrStat, ErrMsg)
   type(FVW_InitOutputType), intent(inout) :: InitOutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FVW_DestroyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine FVW_PackInitOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FVW_InitOutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FVW_PackInitOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%Dummy)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FVW_UnPackInitOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FVW_InitOutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FVW_UnPackInitOutput'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%Dummy); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FVW_Input_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
   ! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(FVW_InputType), intent(inout)  :: u(:) ! Input at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Inputs
   type(FVW_InputType), intent(inout)  :: u_out ! Input at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'FVW_Input_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(u)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(u)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(u) - 1
   select case (order)
   case (0)
      call FVW_CopyInput(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call FVW_Input_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call FVW_Input_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(u) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE FVW_Input_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

   TYPE(FVW_InputType), INTENT(INOUT)  :: u1    ! Input at t1 > t2
   TYPE(FVW_InputType), INTENT(INOUT)  :: u2    ! Input at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Inputs
   TYPE(FVW_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'FVW_Input_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i02      ! dim2 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   INTEGER                                    :: i2       ! dim2 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   IF (ALLOCATED(u_out%rotors) .AND. ALLOCATED(u1%rotors)) THEN
      do i01 = lbound(u_out%rotors,1),ubound(u_out%rotors,1)
         u_out%rotors(i01)%HubOrientation = a1*u1%rotors(i01)%HubOrientation + a2*u2%rotors(i01)%HubOrientation
      END DO
      do i01 = lbound(u_out%rotors,1),ubound(u_out%rotors,1)
         u_out%rotors(i01)%HubPosition = a1*u1%rotors(i01)%HubPosition + a2*u2%rotors(i01)%HubPosition
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(u_out%W) .AND. ALLOCATED(u1%W)) THEN
      do i01 = lbound(u_out%W,1),ubound(u_out%W,1)
         IF (ALLOCATED(u_out%W(i01)%Vwnd_LL) .AND. ALLOCATED(u1%W(i01)%Vwnd_LL)) THEN
            u_out%W(i01)%Vwnd_LL = a1*u1%W(i01)%Vwnd_LL + a2*u2%W(i01)%Vwnd_LL
         END IF ! check if allocated
      END DO
      do i01 = lbound(u_out%W,1),ubound(u_out%W,1)
         IF (ALLOCATED(u_out%W(i01)%omega_z) .AND. ALLOCATED(u1%W(i01)%omega_z)) THEN
            u_out%W(i01)%omega_z = a1*u1%W(i01)%omega_z + a2*u2%W(i01)%omega_z
         END IF ! check if allocated
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(u_out%WingsMesh) .AND. ALLOCATED(u1%WingsMesh)) THEN
      do i1 = lbound(u_out%WingsMesh,1),ubound(u_out%WingsMesh,1)
         CALL MeshExtrapInterp1(u1%WingsMesh(i1), u2%WingsMesh(i1), tin, u_out%WingsMesh(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(u_out%V_wind) .AND. ALLOCATED(u1%V_wind)) THEN
      u_out%V_wind = a1*u1%V_wind + a2*u2%V_wind
   END IF ! check if allocated
END SUBROUTINE

SUBROUTINE FVW_Input_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

   TYPE(FVW_InputType), INTENT(INOUT)  :: u1      ! Input at t1 > t2 > t3
   TYPE(FVW_InputType), INTENT(INOUT)  :: u2      ! Input at t2 > t3
   TYPE(FVW_InputType), INTENT(INOUT)  :: u3      ! Input at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Inputs
   TYPE(FVW_InputType), INTENT(INOUT)  :: u_out     ! Input at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'FVW_Input_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i02    ! dim2 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   INTEGER                                    :: i2    ! dim2 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   IF (ALLOCATED(u_out%rotors) .AND. ALLOCATED(u1%rotors)) THEN
      do i01 = lbound(u_out%rotors,1),ubound(u_out%rotors,1)
         u_out%rotors(i01)%HubOrientation = a1*u1%rotors(i01)%HubOrientation + a2*u2%rotors(i01)%HubOrientation + a3*u3%rotors(i01)%HubOrientation
      END DO
      do i01 = lbound(u_out%rotors,1),ubound(u_out%rotors,1)
         u_out%rotors(i01)%HubPosition = a1*u1%rotors(i01)%HubPosition + a2*u2%rotors(i01)%HubPosition + a3*u3%rotors(i01)%HubPosition
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(u_out%W) .AND. ALLOCATED(u1%W)) THEN
      do i01 = lbound(u_out%W,1),ubound(u_out%W,1)
         IF (ALLOCATED(u_out%W(i01)%Vwnd_LL) .AND. ALLOCATED(u1%W(i01)%Vwnd_LL)) THEN
            u_out%W(i01)%Vwnd_LL = a1*u1%W(i01)%Vwnd_LL + a2*u2%W(i01)%Vwnd_LL + a3*u3%W(i01)%Vwnd_LL
         END IF ! check if allocated
      END DO
      do i01 = lbound(u_out%W,1),ubound(u_out%W,1)
         IF (ALLOCATED(u_out%W(i01)%omega_z) .AND. ALLOCATED(u1%W(i01)%omega_z)) THEN
            u_out%W(i01)%omega_z = a1*u1%W(i01)%omega_z + a2*u2%W(i01)%omega_z + a3*u3%W(i01)%omega_z
         END IF ! check if allocated
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(u_out%WingsMesh) .AND. ALLOCATED(u1%WingsMesh)) THEN
      do i1 = lbound(u_out%WingsMesh,1),ubound(u_out%WingsMesh,1)
         CALL MeshExtrapInterp2(u1%WingsMesh(i1), u2%WingsMesh(i1), u3%WingsMesh(i1), tin, u_out%WingsMesh(i1), tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
   END IF ! check if allocated
   IF (ALLOCATED(u_out%V_wind) .AND. ALLOCATED(u1%V_wind)) THEN
      u_out%V_wind = a1*u1%V_wind + a2*u2%V_wind + a3*u3%V_wind
   END IF ! check if allocated
END SUBROUTINE

subroutine FVW_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
   ! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(FVW_OutputType), intent(in)  :: y(:) ! Output at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Outputs
   type(FVW_OutputType), intent(inout)  :: y_out ! Output at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'FVW_Output_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(y)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(y)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(y) - 1
   select case (order)
   case (0)
      call FVW_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call FVW_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call FVW_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(y) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE FVW_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

   TYPE(FVW_OutputType), INTENT(IN)  :: y1    ! Output at t1 > t2
   TYPE(FVW_OutputType), INTENT(IN)  :: y2    ! Output at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
   TYPE(FVW_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'FVW_Output_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i02      ! dim2 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   INTEGER                                    :: i2       ! dim2 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   IF (ALLOCATED(y_out%W) .AND. ALLOCATED(y1%W)) THEN
      do i01 = lbound(y_out%W,1),ubound(y_out%W,1)
         IF (ALLOCATED(y_out%W(i01)%Vind) .AND. ALLOCATED(y1%W(i01)%Vind)) THEN
            y_out%W(i01)%Vind = a1*y1%W(i01)%Vind + a2*y2%W(i01)%Vind
         END IF ! check if allocated
      END DO
   END IF ! check if allocated
END SUBROUTINE

SUBROUTINE FVW_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

   TYPE(FVW_OutputType), INTENT(IN)  :: y1      ! Output at t1 > t2 > t3
   TYPE(FVW_OutputType), INTENT(IN)  :: y2      ! Output at t2 > t3
   TYPE(FVW_OutputType), INTENT(IN)  :: y3      ! Output at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
   TYPE(FVW_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'FVW_Output_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i02    ! dim2 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   INTEGER                                    :: i2    ! dim2 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   IF (ALLOCATED(y_out%W) .AND. ALLOCATED(y1%W)) THEN
      do i01 = lbound(y_out%W,1),ubound(y_out%W,1)
         IF (ALLOCATED(y_out%W(i01)%Vind) .AND. ALLOCATED(y1%W(i01)%Vind)) THEN
            y_out%W(i01)%Vind = a1*y1%W(i01)%Vind + a2*y2%W(i01)%Vind + a3*y3%W(i01)%Vind
         END IF ! check if allocated
      END DO
   END IF ! check if allocated
END SUBROUTINE
END MODULE FVW_Types
!ENDOFREGISTRYGENERATEDFILE
