!STARTOFREGISTRYGENERATEDFILE 'DBEMT_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! DBEMT_Types
!.................................................................................................................................
! This file is part of DBEMT.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in DBEMT. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE DBEMT_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE NWTC_Library
IMPLICIT NONE
    INTEGER(IntKi), PUBLIC, PARAMETER  :: DBEMT_frozen = -1      ! use frozen-wake for linearization (not DBEMT) [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: DBEMT_none = 0      ! use BEMT instead (not DBEMT) [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: DBEMT_tauConst = 1      ! use constant tau1 [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: DBEMT_tauVaries = 2      ! use time-dependent tau1 [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: DBEMT_cont_tauConst = 3      ! use continuous formulation with constant tau1 [-]
! =========  DBEMT_InitInputType  =======
  TYPE, PUBLIC :: DBEMT_InitInputType
    INTEGER(IntKi)  :: NumBlades = 0_IntKi      !< Number of blades on the turbine [-]
    INTEGER(IntKi)  :: NumNodes = 0_IntKi      !< Number of nodes on each blade [-]
    REAL(ReKi)  :: tau1_const = 0.0_ReKi      !< delay value based on disk-averaged quantities [-]
    INTEGER(IntKi)  :: DBEMT_Mod = 0_IntKi      !< DBEMT Model.  1 = constant tau1, 2 = time dependent tau1, 3=continuous form with constant tau1 [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: rLocal      !< Radial distance to blade node from the center of rotation, measured in the rotor plane, needed for DBEMT [m]
  END TYPE DBEMT_InitInputType
! =======================
! =========  DBEMT_InitOutputType  =======
  TYPE, PUBLIC :: DBEMT_InitOutputType
    TYPE(ProgDesc)  :: Ver      !< This module's name, version, and date [-]
  END TYPE DBEMT_InitOutputType
! =======================
! =========  DBEMT_ElementContinuousStateType  =======
  TYPE, PUBLIC :: DBEMT_ElementContinuousStateType
    REAL(R8Ki) , DIMENSION(1:2)  :: vind = 0.0_R8Ki      !< The filtered induced velocity, [1,i,j] is the axial induced velocity (-Vx*a) at node i on blade j and [2,i,j] is the tantential induced velocity (Vy*a') [m/s]
    REAL(R8Ki) , DIMENSION(1:2)  :: vind_1 = 0.0_R8Ki      !< The filtered reduced or intermediate induced velocity [m/s]
  END TYPE DBEMT_ElementContinuousStateType
! =======================
! =========  DBEMT_ContinuousStateType  =======
  TYPE, PUBLIC :: DBEMT_ContinuousStateType
    TYPE(DBEMT_ElementContinuousStateType) , DIMENSION(:,:), ALLOCATABLE  :: element      !< The filtered induced velocity [1,i,j] is the axial induced velocity (-Vx*a) at node i on blade j and [2,i,j] is the tantential induced velocity (Vy*a') at node i on blade j [m/s]
  END TYPE DBEMT_ContinuousStateType
! =======================
! =========  DBEMT_DiscreteStateType  =======
  TYPE, PUBLIC :: DBEMT_DiscreteStateType
    REAL(SiKi)  :: DummyState = 0.0_R4Ki      !< Remove this variable if you have continuous states [-]
  END TYPE DBEMT_DiscreteStateType
! =======================
! =========  DBEMT_ConstraintStateType  =======
  TYPE, PUBLIC :: DBEMT_ConstraintStateType
    REAL(SiKi)  :: DummyState = 0.0_R4Ki      !< Remove this variable if you have constraint states [-]
  END TYPE DBEMT_ConstraintStateType
! =======================
! =========  DBEMT_OtherStateType  =======
  TYPE, PUBLIC :: DBEMT_OtherStateType
    LOGICAL , DIMENSION(:,:), ALLOCATABLE  :: areStatesInitialized      !< Flag indicating whether the module's states have been initialized properly [-]
    REAL(ReKi)  :: tau1 = 0.0_ReKi      !< value of tau1 used in updateStates (for output-to-file only) [-]
    REAL(ReKi)  :: tau2 = 0.0_ReKi      !< value of tau2 used in updateStates (equal to k_tau * tau1, not used between time steps) [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: n      !< time step # value used for continuous state integrator [-]
    TYPE(DBEMT_ContinuousStateType) , DIMENSION(1:4)  :: xdot      !< derivative history for continuous state integrators [-]
  END TYPE DBEMT_OtherStateType
! =======================
! =========  DBEMT_MiscVarType  =======
  TYPE, PUBLIC :: DBEMT_MiscVarType
    LOGICAL  :: FirstWarn_tau1 = .false.      !< flag so tau1 limit warning doesn't get repeated forever [-]
  END TYPE DBEMT_MiscVarType
! =======================
! =========  DBEMT_ParameterType  =======
  TYPE, PUBLIC :: DBEMT_ParameterType
    REAL(DbKi)  :: DT = 0.0_R8Ki      !< Time step for continuous state integration & discrete state update [seconds]
    INTEGER(IntKi)  :: lin_nx = 0      !< Number of continuous states for linearization [-]
    INTEGER(IntKi)  :: NumBlades = 0_IntKi      !< Number of blades on the turbine [-]
    INTEGER(IntKi)  :: NumNodes = 0_IntKi      !< Number of nodes on each blade [-]
    REAL(ReKi)  :: k_0ye = 0.0_ReKi      !< Filter dynamics constant [default = 0.6 ] [-]
    REAL(ReKi)  :: tau1_const = 0.0_ReKi      !< constant version of the delay value [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: spanRatio      !< static span ratio of each blade node [-]
    INTEGER(IntKi)  :: DBEMT_Mod = 0_IntKi      !< DBEMT Model.  1 = constant tau1, 2 = time dependent tau1, 3=continuous form of constant tau1 [-]
  END TYPE DBEMT_ParameterType
! =======================
! =========  DBEMT_ElementInputType  =======
  TYPE, PUBLIC :: DBEMT_ElementInputType
    REAL(ReKi) , DIMENSION(1:2)  :: vind_s = 0.0_ReKi      !< The unfiltered induced velocity, [1] is the axial induced velocity (-Vx*a) and [2] is the tangential induced velocity (Vy*a') at node i on blade j. Note that the inputs are used only operated on at a particular node and blade, so we don't store all elements [m/s]
    REAL(ReKi)  :: spanRatio = 0.0_ReKi      !< Normalized span location of blade node [-]
  END TYPE DBEMT_ElementInputType
! =======================
! =========  DBEMT_InputType  =======
  TYPE, PUBLIC :: DBEMT_InputType
    REAL(ReKi)  :: AxInd_disk = 0.0_ReKi      !< Disk-averaged axial induction (for time-varying tau) [-]
    REAL(ReKi)  :: Un_disk = 0.0_ReKi      !< Disk-averaged normal relative inflow velocity (for time-varying tau) [m/s]
    REAL(ReKi)  :: R_disk = 0.0_ReKi      !< Disk-maximum rotor radius (for time-varying tau) [m]
    TYPE(DBEMT_ElementInputType) , DIMENSION(:,:), ALLOCATABLE  :: element      !< The element-level inputs at each blade node [-]
  END TYPE DBEMT_InputType
! =======================
! =========  DBEMT_OutputType  =======
  TYPE, PUBLIC :: DBEMT_OutputType
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: vind      !< The filtered induced velocity, [1,i,j] is the axial induced velocity (-Vx*a) at node i on blade j and [2,i,j] is the tangential induced velocity (Vy*a') at node i on blade j [m/s]
  END TYPE DBEMT_OutputType
! =======================
CONTAINS

subroutine DBEMT_CopyInitInput(SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg)
   type(DBEMT_InitInputType), intent(in) :: SrcInitInputData
   type(DBEMT_InitInputType), intent(inout) :: DstInitInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'DBEMT_CopyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInitInputData%NumBlades = SrcInitInputData%NumBlades
   DstInitInputData%NumNodes = SrcInitInputData%NumNodes
   DstInitInputData%tau1_const = SrcInitInputData%tau1_const
   DstInitInputData%DBEMT_Mod = SrcInitInputData%DBEMT_Mod
   if (allocated(SrcInitInputData%rLocal)) then
      LB(1:2) = lbound(SrcInitInputData%rLocal)
      UB(1:2) = ubound(SrcInitInputData%rLocal)
      if (.not. allocated(DstInitInputData%rLocal)) then
         allocate(DstInitInputData%rLocal(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%rLocal.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%rLocal = SrcInitInputData%rLocal
   end if
end subroutine

subroutine DBEMT_DestroyInitInput(InitInputData, ErrStat, ErrMsg)
   type(DBEMT_InitInputType), intent(inout) :: InitInputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'DBEMT_DestroyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InitInputData%rLocal)) then
      deallocate(InitInputData%rLocal)
   end if
end subroutine

subroutine DBEMT_PackInitInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(DBEMT_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'DBEMT_PackInitInput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%NumBlades)
   call RegPack(RF, InData%NumNodes)
   call RegPack(RF, InData%tau1_const)
   call RegPack(RF, InData%DBEMT_Mod)
   call RegPackAlloc(RF, InData%rLocal)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine DBEMT_UnPackInitInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(DBEMT_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'DBEMT_UnPackInitInput'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%NumBlades); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumNodes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%tau1_const); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DBEMT_Mod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%rLocal); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine DBEMT_CopyInitOutput(SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg)
   type(DBEMT_InitOutputType), intent(in) :: SrcInitOutputData
   type(DBEMT_InitOutputType), intent(inout) :: DstInitOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'DBEMT_CopyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call NWTC_Library_CopyProgDesc(SrcInitOutputData%Ver, DstInitOutputData%Ver, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine DBEMT_DestroyInitOutput(InitOutputData, ErrStat, ErrMsg)
   type(DBEMT_InitOutputType), intent(inout) :: InitOutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'DBEMT_DestroyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call NWTC_Library_DestroyProgDesc(InitOutputData%Ver, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine DBEMT_PackInitOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(DBEMT_InitOutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'DBEMT_PackInitOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call NWTC_Library_PackProgDesc(RF, InData%Ver) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine DBEMT_UnPackInitOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(DBEMT_InitOutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'DBEMT_UnPackInitOutput'
   if (RF%ErrStat /= ErrID_None) return
   call NWTC_Library_UnpackProgDesc(RF, OutData%Ver) ! Ver 
end subroutine

subroutine DBEMT_CopyElementContinuousStateType(SrcElementContinuousStateTypeData, DstElementContinuousStateTypeData, CtrlCode, ErrStat, ErrMsg)
   type(DBEMT_ElementContinuousStateType), intent(in) :: SrcElementContinuousStateTypeData
   type(DBEMT_ElementContinuousStateType), intent(inout) :: DstElementContinuousStateTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'DBEMT_CopyElementContinuousStateType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstElementContinuousStateTypeData%vind = SrcElementContinuousStateTypeData%vind
   DstElementContinuousStateTypeData%vind_1 = SrcElementContinuousStateTypeData%vind_1
end subroutine

subroutine DBEMT_DestroyElementContinuousStateType(ElementContinuousStateTypeData, ErrStat, ErrMsg)
   type(DBEMT_ElementContinuousStateType), intent(inout) :: ElementContinuousStateTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'DBEMT_DestroyElementContinuousStateType'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine DBEMT_PackElementContinuousStateType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(DBEMT_ElementContinuousStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'DBEMT_PackElementContinuousStateType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%vind)
   call RegPack(RF, InData%vind_1)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine DBEMT_UnPackElementContinuousStateType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(DBEMT_ElementContinuousStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'DBEMT_UnPackElementContinuousStateType'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%vind); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%vind_1); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine DBEMT_CopyContState(SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg)
   type(DBEMT_ContinuousStateType), intent(in) :: SrcContStateData
   type(DBEMT_ContinuousStateType), intent(inout) :: DstContStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'DBEMT_CopyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcContStateData%element)) then
      LB(1:2) = lbound(SrcContStateData%element)
      UB(1:2) = ubound(SrcContStateData%element)
      if (.not. allocated(DstContStateData%element)) then
         allocate(DstContStateData%element(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstContStateData%element.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call DBEMT_CopyElementContinuousStateType(SrcContStateData%element(i1,i2), DstContStateData%element(i1,i2), CtrlCode, ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
            if (ErrStat >= AbortErrLev) return
         end do
      end do
   end if
end subroutine

subroutine DBEMT_DestroyContState(ContStateData, ErrStat, ErrMsg)
   type(DBEMT_ContinuousStateType), intent(inout) :: ContStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'DBEMT_DestroyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ContStateData%element)) then
      LB(1:2) = lbound(ContStateData%element)
      UB(1:2) = ubound(ContStateData%element)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call DBEMT_DestroyElementContinuousStateType(ContStateData%element(i1,i2), ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         end do
      end do
      deallocate(ContStateData%element)
   end if
end subroutine

subroutine DBEMT_PackContState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(DBEMT_ContinuousStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'DBEMT_PackContState'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%element))
   if (allocated(InData%element)) then
      call RegPackBounds(RF, 2, lbound(InData%element), ubound(InData%element))
      LB(1:2) = lbound(InData%element)
      UB(1:2) = ubound(InData%element)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call DBEMT_PackElementContinuousStateType(RF, InData%element(i1,i2)) 
         end do
      end do
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine DBEMT_UnPackContState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(DBEMT_ContinuousStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'DBEMT_UnPackContState'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%element)) deallocate(OutData%element)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 2, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%element(LB(1):UB(1),LB(2):UB(2)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%element.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call DBEMT_UnpackElementContinuousStateType(RF, OutData%element(i1,i2)) ! element 
         end do
      end do
   end if
end subroutine

subroutine DBEMT_CopyDiscState(SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg)
   type(DBEMT_DiscreteStateType), intent(in) :: SrcDiscStateData
   type(DBEMT_DiscreteStateType), intent(inout) :: DstDiscStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'DBEMT_CopyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstDiscStateData%DummyState = SrcDiscStateData%DummyState
end subroutine

subroutine DBEMT_DestroyDiscState(DiscStateData, ErrStat, ErrMsg)
   type(DBEMT_DiscreteStateType), intent(inout) :: DiscStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'DBEMT_DestroyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine DBEMT_PackDiscState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(DBEMT_DiscreteStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'DBEMT_PackDiscState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine DBEMT_UnPackDiscState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(DBEMT_DiscreteStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'DBEMT_UnPackDiscState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine DBEMT_CopyConstrState(SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg)
   type(DBEMT_ConstraintStateType), intent(in) :: SrcConstrStateData
   type(DBEMT_ConstraintStateType), intent(inout) :: DstConstrStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'DBEMT_CopyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstConstrStateData%DummyState = SrcConstrStateData%DummyState
end subroutine

subroutine DBEMT_DestroyConstrState(ConstrStateData, ErrStat, ErrMsg)
   type(DBEMT_ConstraintStateType), intent(inout) :: ConstrStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'DBEMT_DestroyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine DBEMT_PackConstrState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(DBEMT_ConstraintStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'DBEMT_PackConstrState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine DBEMT_UnPackConstrState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(DBEMT_ConstraintStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'DBEMT_UnPackConstrState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine DBEMT_CopyOtherState(SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg)
   type(DBEMT_OtherStateType), intent(in) :: SrcOtherStateData
   type(DBEMT_OtherStateType), intent(inout) :: DstOtherStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'DBEMT_CopyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcOtherStateData%areStatesInitialized)) then
      LB(1:2) = lbound(SrcOtherStateData%areStatesInitialized)
      UB(1:2) = ubound(SrcOtherStateData%areStatesInitialized)
      if (.not. allocated(DstOtherStateData%areStatesInitialized)) then
         allocate(DstOtherStateData%areStatesInitialized(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%areStatesInitialized.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOtherStateData%areStatesInitialized = SrcOtherStateData%areStatesInitialized
   end if
   DstOtherStateData%tau1 = SrcOtherStateData%tau1
   DstOtherStateData%tau2 = SrcOtherStateData%tau2
   if (allocated(SrcOtherStateData%n)) then
      LB(1:2) = lbound(SrcOtherStateData%n)
      UB(1:2) = ubound(SrcOtherStateData%n)
      if (.not. allocated(DstOtherStateData%n)) then
         allocate(DstOtherStateData%n(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%n.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOtherStateData%n = SrcOtherStateData%n
   end if
   LB(1:1) = lbound(SrcOtherStateData%xdot)
   UB(1:1) = ubound(SrcOtherStateData%xdot)
   do i1 = LB(1), UB(1)
      call DBEMT_CopyContState(SrcOtherStateData%xdot(i1), DstOtherStateData%xdot(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
end subroutine

subroutine DBEMT_DestroyOtherState(OtherStateData, ErrStat, ErrMsg)
   type(DBEMT_OtherStateType), intent(inout) :: OtherStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'DBEMT_DestroyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(OtherStateData%areStatesInitialized)) then
      deallocate(OtherStateData%areStatesInitialized)
   end if
   if (allocated(OtherStateData%n)) then
      deallocate(OtherStateData%n)
   end if
   LB(1:1) = lbound(OtherStateData%xdot)
   UB(1:1) = ubound(OtherStateData%xdot)
   do i1 = LB(1), UB(1)
      call DBEMT_DestroyContState(OtherStateData%xdot(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
end subroutine

subroutine DBEMT_PackOtherState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(DBEMT_OtherStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'DBEMT_PackOtherState'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%areStatesInitialized)
   call RegPack(RF, InData%tau1)
   call RegPack(RF, InData%tau2)
   call RegPackAlloc(RF, InData%n)
   LB(1:1) = lbound(InData%xdot)
   UB(1:1) = ubound(InData%xdot)
   do i1 = LB(1), UB(1)
      call DBEMT_PackContState(RF, InData%xdot(i1)) 
   end do
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine DBEMT_UnPackOtherState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(DBEMT_OtherStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'DBEMT_UnPackOtherState'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%areStatesInitialized); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%tau1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%tau2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%n); if (RegCheckErr(RF, RoutineName)) return
   LB(1:1) = lbound(OutData%xdot)
   UB(1:1) = ubound(OutData%xdot)
   do i1 = LB(1), UB(1)
      call DBEMT_UnpackContState(RF, OutData%xdot(i1)) ! xdot 
   end do
end subroutine

subroutine DBEMT_CopyMisc(SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg)
   type(DBEMT_MiscVarType), intent(in) :: SrcMiscData
   type(DBEMT_MiscVarType), intent(inout) :: DstMiscData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'DBEMT_CopyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstMiscData%FirstWarn_tau1 = SrcMiscData%FirstWarn_tau1
end subroutine

subroutine DBEMT_DestroyMisc(MiscData, ErrStat, ErrMsg)
   type(DBEMT_MiscVarType), intent(inout) :: MiscData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'DBEMT_DestroyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine DBEMT_PackMisc(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(DBEMT_MiscVarType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'DBEMT_PackMisc'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%FirstWarn_tau1)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine DBEMT_UnPackMisc(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(DBEMT_MiscVarType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'DBEMT_UnPackMisc'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%FirstWarn_tau1); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine DBEMT_CopyParam(SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg)
   type(DBEMT_ParameterType), intent(in) :: SrcParamData
   type(DBEMT_ParameterType), intent(inout) :: DstParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'DBEMT_CopyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstParamData%DT = SrcParamData%DT
   DstParamData%lin_nx = SrcParamData%lin_nx
   DstParamData%NumBlades = SrcParamData%NumBlades
   DstParamData%NumNodes = SrcParamData%NumNodes
   DstParamData%k_0ye = SrcParamData%k_0ye
   DstParamData%tau1_const = SrcParamData%tau1_const
   if (allocated(SrcParamData%spanRatio)) then
      LB(1:2) = lbound(SrcParamData%spanRatio)
      UB(1:2) = ubound(SrcParamData%spanRatio)
      if (.not. allocated(DstParamData%spanRatio)) then
         allocate(DstParamData%spanRatio(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%spanRatio.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%spanRatio = SrcParamData%spanRatio
   end if
   DstParamData%DBEMT_Mod = SrcParamData%DBEMT_Mod
end subroutine

subroutine DBEMT_DestroyParam(ParamData, ErrStat, ErrMsg)
   type(DBEMT_ParameterType), intent(inout) :: ParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'DBEMT_DestroyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ParamData%spanRatio)) then
      deallocate(ParamData%spanRatio)
   end if
end subroutine

subroutine DBEMT_PackParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(DBEMT_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'DBEMT_PackParam'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DT)
   call RegPack(RF, InData%lin_nx)
   call RegPack(RF, InData%NumBlades)
   call RegPack(RF, InData%NumNodes)
   call RegPack(RF, InData%k_0ye)
   call RegPack(RF, InData%tau1_const)
   call RegPackAlloc(RF, InData%spanRatio)
   call RegPack(RF, InData%DBEMT_Mod)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine DBEMT_UnPackParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(DBEMT_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'DBEMT_UnPackParam'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%lin_nx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumBlades); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumNodes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k_0ye); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%tau1_const); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%spanRatio); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DBEMT_Mod); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine DBEMT_CopyElementInputType(SrcElementInputTypeData, DstElementInputTypeData, CtrlCode, ErrStat, ErrMsg)
   type(DBEMT_ElementInputType), intent(in) :: SrcElementInputTypeData
   type(DBEMT_ElementInputType), intent(inout) :: DstElementInputTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'DBEMT_CopyElementInputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstElementInputTypeData%vind_s = SrcElementInputTypeData%vind_s
   DstElementInputTypeData%spanRatio = SrcElementInputTypeData%spanRatio
end subroutine

subroutine DBEMT_DestroyElementInputType(ElementInputTypeData, ErrStat, ErrMsg)
   type(DBEMT_ElementInputType), intent(inout) :: ElementInputTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'DBEMT_DestroyElementInputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine DBEMT_PackElementInputType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(DBEMT_ElementInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'DBEMT_PackElementInputType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%vind_s)
   call RegPack(RF, InData%spanRatio)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine DBEMT_UnPackElementInputType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(DBEMT_ElementInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'DBEMT_UnPackElementInputType'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%vind_s); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%spanRatio); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine DBEMT_CopyInput(SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg)
   type(DBEMT_InputType), intent(in) :: SrcInputData
   type(DBEMT_InputType), intent(inout) :: DstInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'DBEMT_CopyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInputData%AxInd_disk = SrcInputData%AxInd_disk
   DstInputData%Un_disk = SrcInputData%Un_disk
   DstInputData%R_disk = SrcInputData%R_disk
   if (allocated(SrcInputData%element)) then
      LB(1:2) = lbound(SrcInputData%element)
      UB(1:2) = ubound(SrcInputData%element)
      if (.not. allocated(DstInputData%element)) then
         allocate(DstInputData%element(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%element.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call DBEMT_CopyElementInputType(SrcInputData%element(i1,i2), DstInputData%element(i1,i2), CtrlCode, ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
            if (ErrStat >= AbortErrLev) return
         end do
      end do
   end if
end subroutine

subroutine DBEMT_DestroyInput(InputData, ErrStat, ErrMsg)
   type(DBEMT_InputType), intent(inout) :: InputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'DBEMT_DestroyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InputData%element)) then
      LB(1:2) = lbound(InputData%element)
      UB(1:2) = ubound(InputData%element)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call DBEMT_DestroyElementInputType(InputData%element(i1,i2), ErrStat2, ErrMsg2)
            call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         end do
      end do
      deallocate(InputData%element)
   end if
end subroutine

subroutine DBEMT_PackInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(DBEMT_InputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'DBEMT_PackInput'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%AxInd_disk)
   call RegPack(RF, InData%Un_disk)
   call RegPack(RF, InData%R_disk)
   call RegPack(RF, allocated(InData%element))
   if (allocated(InData%element)) then
      call RegPackBounds(RF, 2, lbound(InData%element), ubound(InData%element))
      LB(1:2) = lbound(InData%element)
      UB(1:2) = ubound(InData%element)
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call DBEMT_PackElementInputType(RF, InData%element(i1,i2)) 
         end do
      end do
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine DBEMT_UnPackInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(DBEMT_InputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'DBEMT_UnPackInput'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%AxInd_disk); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Un_disk); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%R_disk); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%element)) deallocate(OutData%element)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 2, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%element(LB(1):UB(1),LB(2):UB(2)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%element.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i2 = LB(2), UB(2)
         do i1 = LB(1), UB(1)
            call DBEMT_UnpackElementInputType(RF, OutData%element(i1,i2)) ! element 
         end do
      end do
   end if
end subroutine

subroutine DBEMT_CopyOutput(SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg)
   type(DBEMT_OutputType), intent(in) :: SrcOutputData
   type(DBEMT_OutputType), intent(inout) :: DstOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'DBEMT_CopyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcOutputData%vind)) then
      LB(1:3) = lbound(SrcOutputData%vind)
      UB(1:3) = ubound(SrcOutputData%vind)
      if (.not. allocated(DstOutputData%vind)) then
         allocate(DstOutputData%vind(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%vind.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%vind = SrcOutputData%vind
   end if
end subroutine

subroutine DBEMT_DestroyOutput(OutputData, ErrStat, ErrMsg)
   type(DBEMT_OutputType), intent(inout) :: OutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'DBEMT_DestroyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(OutputData%vind)) then
      deallocate(OutputData%vind)
   end if
end subroutine

subroutine DBEMT_PackOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(DBEMT_OutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'DBEMT_PackOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%vind)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine DBEMT_UnPackOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(DBEMT_OutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'DBEMT_UnPackOutput'
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%vind); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine DBEMT_ElementInputType_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) ElementInputType u_out at time t_out, from previous/future time
   ! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(DBEMT_ElementInputType), intent(in)  :: u(:) ! ElementInputType at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the ElementInputTypes
   type(DBEMT_ElementInputType), intent(inout)  :: u_out ! ElementInputType at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'DBEMT_ElementInputType_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(u)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(u)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(u) - 1
   select case (order)
   case (0)
      call DBEMT_CopyElementInputType(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call DBEMT_ElementInputType_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call DBEMT_ElementInputType_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(u) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE DBEMT_ElementInputType_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) ElementInputType u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

   TYPE(DBEMT_ElementInputType), INTENT(IN)  :: u1    ! ElementInputType at t1 > t2
   TYPE(DBEMT_ElementInputType), INTENT(IN)  :: u2    ! ElementInputType at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the ElementInputTypes
   TYPE(DBEMT_ElementInputType), INTENT(INOUT)  :: u_out ! ElementInputType at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the ElementInputTypes
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'DBEMT_ElementInputType_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   u_out%vind_s = a1*u1%vind_s + a2*u2%vind_s
   u_out%spanRatio = a1*u1%spanRatio + a2*u2%spanRatio
END SUBROUTINE

SUBROUTINE DBEMT_ElementInputType_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) ElementInputType u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

   TYPE(DBEMT_ElementInputType), INTENT(IN)  :: u1      ! ElementInputType at t1 > t2 > t3
   TYPE(DBEMT_ElementInputType), INTENT(IN)  :: u2      ! ElementInputType at t2 > t3
   TYPE(DBEMT_ElementInputType), INTENT(IN)  :: u3      ! ElementInputType at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the ElementInputTypes
   TYPE(DBEMT_ElementInputType), INTENT(INOUT)  :: u_out     ! ElementInputType at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the ElementInputTypes
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'DBEMT_ElementInputType_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   u_out%vind_s = a1*u1%vind_s + a2*u2%vind_s + a3*u3%vind_s
   u_out%spanRatio = a1*u1%spanRatio + a2*u2%spanRatio + a3*u3%spanRatio
END SUBROUTINE

subroutine DBEMT_Input_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
   ! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(DBEMT_InputType), intent(in)  :: u(:) ! Input at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Inputs
   type(DBEMT_InputType), intent(inout)  :: u_out ! Input at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'DBEMT_Input_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(u)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(u)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(u) - 1
   select case (order)
   case (0)
      call DBEMT_CopyInput(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call DBEMT_Input_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call DBEMT_Input_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(u) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE DBEMT_Input_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

   TYPE(DBEMT_InputType), INTENT(IN)  :: u1    ! Input at t1 > t2
   TYPE(DBEMT_InputType), INTENT(IN)  :: u2    ! Input at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Inputs
   TYPE(DBEMT_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'DBEMT_Input_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i02      ! dim2 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   INTEGER                                    :: i2       ! dim2 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   u_out%AxInd_disk = a1*u1%AxInd_disk + a2*u2%AxInd_disk
   u_out%Un_disk = a1*u1%Un_disk + a2*u2%Un_disk
   u_out%R_disk = a1*u1%R_disk + a2*u2%R_disk
   IF (ALLOCATED(u_out%element) .AND. ALLOCATED(u1%element)) THEN
      do i02 = lbound(u_out%element,2),ubound(u_out%element,2)
         do i01 = lbound(u_out%element,1),ubound(u_out%element,1)
            u_out%element(i01,i02)%vind_s = a1*u1%element(i01,i02)%vind_s + a2*u2%element(i01,i02)%vind_s
         END DO
      END DO
      do i02 = lbound(u_out%element,2),ubound(u_out%element,2)
         do i01 = lbound(u_out%element,1),ubound(u_out%element,1)
            u_out%element(i01,i02)%spanRatio = a1*u1%element(i01,i02)%spanRatio + a2*u2%element(i01,i02)%spanRatio
         END DO
      END DO
   END IF ! check if allocated
END SUBROUTINE

SUBROUTINE DBEMT_Input_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

   TYPE(DBEMT_InputType), INTENT(IN)  :: u1      ! Input at t1 > t2 > t3
   TYPE(DBEMT_InputType), INTENT(IN)  :: u2      ! Input at t2 > t3
   TYPE(DBEMT_InputType), INTENT(IN)  :: u3      ! Input at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Inputs
   TYPE(DBEMT_InputType), INTENT(INOUT)  :: u_out     ! Input at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'DBEMT_Input_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i02    ! dim2 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   INTEGER                                    :: i2    ! dim2 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   u_out%AxInd_disk = a1*u1%AxInd_disk + a2*u2%AxInd_disk + a3*u3%AxInd_disk
   u_out%Un_disk = a1*u1%Un_disk + a2*u2%Un_disk + a3*u3%Un_disk
   u_out%R_disk = a1*u1%R_disk + a2*u2%R_disk + a3*u3%R_disk
   IF (ALLOCATED(u_out%element) .AND. ALLOCATED(u1%element)) THEN
      do i02 = lbound(u_out%element,2),ubound(u_out%element,2)
         do i01 = lbound(u_out%element,1),ubound(u_out%element,1)
            u_out%element(i01,i02)%vind_s = a1*u1%element(i01,i02)%vind_s + a2*u2%element(i01,i02)%vind_s + a3*u3%element(i01,i02)%vind_s
         END DO
      END DO
      do i02 = lbound(u_out%element,2),ubound(u_out%element,2)
         do i01 = lbound(u_out%element,1),ubound(u_out%element,1)
            u_out%element(i01,i02)%spanRatio = a1*u1%element(i01,i02)%spanRatio + a2*u2%element(i01,i02)%spanRatio + a3*u3%element(i01,i02)%spanRatio
         END DO
      END DO
   END IF ! check if allocated
END SUBROUTINE

subroutine DBEMT_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
   ! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(DBEMT_OutputType), intent(in)  :: y(:) ! Output at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Outputs
   type(DBEMT_OutputType), intent(inout)  :: y_out ! Output at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'DBEMT_Output_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(y)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(y)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(y) - 1
   select case (order)
   case (0)
      call DBEMT_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call DBEMT_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call DBEMT_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(y) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE DBEMT_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

   TYPE(DBEMT_OutputType), INTENT(IN)  :: y1    ! Output at t1 > t2
   TYPE(DBEMT_OutputType), INTENT(IN)  :: y2    ! Output at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
   TYPE(DBEMT_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'DBEMT_Output_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i02      ! dim2 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i03      ! dim3 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   INTEGER                                    :: i2       ! dim2 counter variable for arrays
   INTEGER                                    :: i3       ! dim3 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   IF (ALLOCATED(y_out%vind) .AND. ALLOCATED(y1%vind)) THEN
      y_out%vind = a1*y1%vind + a2*y2%vind
   END IF ! check if allocated
END SUBROUTINE

SUBROUTINE DBEMT_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

   TYPE(DBEMT_OutputType), INTENT(IN)  :: y1      ! Output at t1 > t2 > t3
   TYPE(DBEMT_OutputType), INTENT(IN)  :: y2      ! Output at t2 > t3
   TYPE(DBEMT_OutputType), INTENT(IN)  :: y3      ! Output at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
   TYPE(DBEMT_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'DBEMT_Output_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i02    ! dim2 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i03    ! dim3 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   INTEGER                                    :: i2    ! dim2 counter variable for arrays
   INTEGER                                    :: i3    ! dim3 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   IF (ALLOCATED(y_out%vind) .AND. ALLOCATED(y1%vind)) THEN
      y_out%vind = a1*y1%vind + a2*y2%vind + a3*y3%vind
   END IF ! check if allocated
END SUBROUTINE
END MODULE DBEMT_Types
!ENDOFREGISTRYGENERATEDFILE
